/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "SPM_CORE_FICca.h"
#include "SPM_CORE_FIJson.h"
#include "SPM_CORE_FIProxy.h"
#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "spm_core_fi_types.h"
#include "spm_core_fi_typesConst.h"
#include "spm_diag_defset_fi_typesConst.h"
#include <string>

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace SPM_CORE_FI {

/*static*/ ::asf::core::Logger SPM_CORE_FIProxy::_logger ("/SPM_CORE_FI/SPM_CORE_FIProxy");


class SPM_CORE_FIProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    SPM_CORE_FIProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<SPM_CORE_FIProxy> proxy = ::boost::static_pointer_cast<SPM_CORE_FIProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_SystemMode: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SystemModeResult);
                                setActAndLogResult(message, "SystemMode", reinterpret_cast<act_t>(this), _logger);
                                ((SystemModeCallbackIF*) _callback)->onSystemModeResult (proxy, ::boost::static_pointer_cast<SystemModeResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SystemModeError);
                                setActAndLogError(message, "SystemMode", reinterpret_cast<act_t>(this), _logger);
                                ((SystemModeCallbackIF*) _callback)->onSystemModeError (proxy, ::boost::static_pointer_cast<SystemModeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DownloadLockState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::DownloadLockStateResult);
                                setActAndLogResult(message, "DownloadLockState", reinterpret_cast<act_t>(this), _logger);
                                ((DownloadLockStateCallbackIF*) _callback)->onDownloadLockStateResult (proxy, ::boost::static_pointer_cast<DownloadLockStateResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::DownloadLockStateError);
                                setActAndLogError(message, "DownloadLockState", reinterpret_cast<act_t>(this), _logger);
                                ((DownloadLockStateCallbackIF*) _callback)->onDownloadLockStateError (proxy, ::boost::static_pointer_cast<DownloadLockStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_UpdateLock: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::UpdateLockResult);
                                setActAndLogResult(message, "UpdateLock", reinterpret_cast<act_t>(this), _logger);
                                ((UpdateLockCallbackIF*) _callback)->onUpdateLockResult (proxy, ::boost::static_pointer_cast<UpdateLockResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::UpdateLockError);
                                setActAndLogError(message, "UpdateLock", reinterpret_cast<act_t>(this), _logger);
                                ((UpdateLockCallbackIF*) _callback)->onUpdateLockError (proxy, ::boost::static_pointer_cast<UpdateLockError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_OnOffTrigger: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::OnOffTriggerResult);
                                setActAndLogResult(message, "OnOffTrigger", reinterpret_cast<act_t>(this), _logger);
                                ((OnOffTriggerCallbackIF*) _callback)->onOnOffTriggerResult (proxy, ::boost::static_pointer_cast<OnOffTriggerResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::OnOffTriggerError);
                                setActAndLogError(message, "OnOffTrigger", reinterpret_cast<act_t>(this), _logger);
                                ((OnOffTriggerCallbackIF*) _callback)->onOnOffTriggerError (proxy, ::boost::static_pointer_cast<OnOffTriggerError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_StartProcess: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::StartProcessResult);
                                setActAndLogResult(message, "StartProcess", reinterpret_cast<act_t>(this), _logger);
                                ((StartProcessCallbackIF*) _callback)->onStartProcessResult (proxy, ::boost::static_pointer_cast<StartProcessResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::StartProcessError);
                                setActAndLogError(message, "StartProcess", reinterpret_cast<act_t>(this), _logger);
                                ((StartProcessCallbackIF*) _callback)->onStartProcessError (proxy, ::boost::static_pointer_cast<StartProcessError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_StopProcess: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::StopProcessResult);
                                setActAndLogResult(message, "StopProcess", reinterpret_cast<act_t>(this), _logger);
                                ((StopProcessCallbackIF*) _callback)->onStopProcessResult (proxy, ::boost::static_pointer_cast<StopProcessResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::StopProcessError);
                                setActAndLogError(message, "StopProcess", reinterpret_cast<act_t>(this), _logger);
                                ((StopProcessCallbackIF*) _callback)->onStopProcessError (proxy, ::boost::static_pointer_cast<StopProcessError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RestartProcess: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::RestartProcessResult);
                                setActAndLogResult(message, "RestartProcess", reinterpret_cast<act_t>(this), _logger);
                                ((RestartProcessCallbackIF*) _callback)->onRestartProcessResult (proxy, ::boost::static_pointer_cast<RestartProcessResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::RestartProcessError);
                                setActAndLogError(message, "RestartProcess", reinterpret_cast<act_t>(this), _logger);
                                ((RestartProcessCallbackIF*) _callback)->onRestartProcessError (proxy, ::boost::static_pointer_cast<RestartProcessError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_StartUpSyncPointReached: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::StartUpSyncPointReachedResult);
                                setActAndLogResult(message, "StartUpSyncPointReached", reinterpret_cast<act_t>(this), _logger);
                                ((StartUpSyncPointReachedCallbackIF*) _callback)->onStartUpSyncPointReachedResult (proxy, ::boost::static_pointer_cast<StartUpSyncPointReachedResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::StartUpSyncPointReachedError);
                                setActAndLogError(message, "StartUpSyncPointReached", reinterpret_cast<act_t>(this), _logger);
                                ((StartUpSyncPointReachedCallbackIF*) _callback)->onStartUpSyncPointReachedError (proxy, ::boost::static_pointer_cast<StartUpSyncPointReachedError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ClearList: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ClearListResult);
                                setActAndLogResult(message, "ClearList", reinterpret_cast<act_t>(this), _logger);
                                ((ClearListCallbackIF*) _callback)->onClearListResult (proxy, ::boost::static_pointer_cast<ClearListResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ClearListError);
                                setActAndLogError(message, "ClearList", reinterpret_cast<act_t>(this), _logger);
                                ((ClearListCallbackIF*) _callback)->onClearListError (proxy, ::boost::static_pointer_cast<ClearListError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SpecificSWVersionStatistic: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SpecificSWVersionStatisticResult);
                                setActAndLogResult(message, "SpecificSWVersionStatistic", reinterpret_cast<act_t>(this), _logger);
                                ((SpecificSWVersionStatisticCallbackIF*) _callback)->onSpecificSWVersionStatisticResult (proxy, ::boost::static_pointer_cast<SpecificSWVersionStatisticResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SpecificSWVersionStatisticError);
                                setActAndLogError(message, "SpecificSWVersionStatistic", reinterpret_cast<act_t>(this), _logger);
                                ((SpecificSWVersionStatisticCallbackIF*) _callback)->onSpecificSWVersionStatisticError (proxy, ::boost::static_pointer_cast<SpecificSWVersionStatisticError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RestartSystem: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::RestartSystemResult);
                                setActAndLogResult(message, "RestartSystem", reinterpret_cast<act_t>(this), _logger);
                                ((RestartSystemCallbackIF*) _callback)->onRestartSystemResult (proxy, ::boost::static_pointer_cast<RestartSystemResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::RestartSystemError);
                                setActAndLogError(message, "RestartSystem", reinterpret_cast<act_t>(this), _logger);
                                ((RestartSystemCallbackIF*) _callback)->onRestartSystemError (proxy, ::boost::static_pointer_cast<RestartSystemError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AudioSourceChange: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::AudioSourceChangeResult);
                                setActAndLogResult(message, "AudioSourceChange", reinterpret_cast<act_t>(this), _logger);
                                ((AudioSourceChangeCallbackIF*) _callback)->onAudioSourceChangeResult (proxy, ::boost::static_pointer_cast<AudioSourceChangeResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::AudioSourceChangeError);
                                setActAndLogError(message, "AudioSourceChange", reinterpret_cast<act_t>(this), _logger);
                                ((AudioSourceChangeCallbackIF*) _callback)->onAudioSourceChangeError (proxy, ::boost::static_pointer_cast<AudioSourceChangeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ChangeBluetoothState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ChangeBluetoothStateResult);
                                setActAndLogResult(message, "ChangeBluetoothState", reinterpret_cast<act_t>(this), _logger);
                                ((ChangeBluetoothStateCallbackIF*) _callback)->onChangeBluetoothStateResult (proxy, ::boost::static_pointer_cast<ChangeBluetoothStateResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ChangeBluetoothStateError);
                                setActAndLogError(message, "ChangeBluetoothState", reinterpret_cast<act_t>(this), _logger);
                                ((ChangeBluetoothStateCallbackIF*) _callback)->onChangeBluetoothStateError (proxy, ::boost::static_pointer_cast<ChangeBluetoothStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ChangeAudioState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ChangeAudioStateResult);
                                setActAndLogResult(message, "ChangeAudioState", reinterpret_cast<act_t>(this), _logger);
                                ((ChangeAudioStateCallbackIF*) _callback)->onChangeAudioStateResult (proxy, ::boost::static_pointer_cast<ChangeAudioStateResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ChangeAudioStateError);
                                setActAndLogError(message, "ChangeAudioState", reinterpret_cast<act_t>(this), _logger);
                                ((ChangeAudioStateCallbackIF*) _callback)->onChangeAudioStateError (proxy, ::boost::static_pointer_cast<ChangeAudioStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ChangeSpiState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ChangeSpiStateResult);
                                setActAndLogResult(message, "ChangeSpiState", reinterpret_cast<act_t>(this), _logger);
                                ((ChangeSpiStateCallbackIF*) _callback)->onChangeSpiStateResult (proxy, ::boost::static_pointer_cast<ChangeSpiStateResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ChangeSpiStateError);
                                setActAndLogError(message, "ChangeSpiState", reinterpret_cast<act_t>(this), _logger);
                                ((ChangeSpiStateCallbackIF*) _callback)->onChangeSpiStateError (proxy, ::boost::static_pointer_cast<ChangeSpiStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ChangeTunerState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ChangeTunerStateResult);
                                setActAndLogResult(message, "ChangeTunerState", reinterpret_cast<act_t>(this), _logger);
                                ((ChangeTunerStateCallbackIF*) _callback)->onChangeTunerStateResult (proxy, ::boost::static_pointer_cast<ChangeTunerStateResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ChangeTunerStateError);
                                setActAndLogError(message, "ChangeTunerState", reinterpret_cast<act_t>(this), _logger);
                                ((ChangeTunerStateCallbackIF*) _callback)->onChangeTunerStateError (proxy, ::boost::static_pointer_cast<ChangeTunerStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ChangeWifiState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ChangeWifiStateResult);
                                setActAndLogResult(message, "ChangeWifiState", reinterpret_cast<act_t>(this), _logger);
                                ((ChangeWifiStateCallbackIF*) _callback)->onChangeWifiStateResult (proxy, ::boost::static_pointer_cast<ChangeWifiStateResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ChangeWifiStateError);
                                setActAndLogError(message, "ChangeWifiState", reinterpret_cast<act_t>(this), _logger);
                                ((ChangeWifiStateCallbackIF*) _callback)->onChangeWifiStateError (proxy, ::boost::static_pointer_cast<ChangeWifiStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ShutdownAndTerminateCcaApps: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ShutdownAndTerminateCcaAppsResult);
                                setActAndLogResult(message, "ShutdownAndTerminateCcaApps", reinterpret_cast<act_t>(this), _logger);
                                ((ShutdownAndTerminateCcaAppsCallbackIF*) _callback)->onShutdownAndTerminateCcaAppsResult (proxy, ::boost::static_pointer_cast<ShutdownAndTerminateCcaAppsResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ShutdownAndTerminateCcaAppsError);
                                setActAndLogError(message, "ShutdownAndTerminateCcaApps", reinterpret_cast<act_t>(this), _logger);
                                ((ShutdownAndTerminateCcaAppsCallbackIF*) _callback)->onShutdownAndTerminateCcaAppsError (proxy, ::boost::static_pointer_cast<ShutdownAndTerminateCcaAppsError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetFactorySettingsNew: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SetFactorySettingsNewResult);
                                setActAndLogResult(message, "SetFactorySettingsNew", reinterpret_cast<act_t>(this), _logger);
                                ((SetFactorySettingsNewCallbackIF*) _callback)->onSetFactorySettingsNewResult (proxy, ::boost::static_pointer_cast<SetFactorySettingsNewResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SetFactorySettingsNewError);
                                setActAndLogError(message, "SetFactorySettingsNew", reinterpret_cast<act_t>(this), _logger);
                                ((SetFactorySettingsNewCallbackIF*) _callback)->onSetFactorySettingsNewError (proxy, ::boost::static_pointer_cast<SetFactorySettingsNewError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ClearVIN: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ClearVINResult);
                                setActAndLogResult(message, "ClearVIN", reinterpret_cast<act_t>(this), _logger);
                                ((ClearVINCallbackIF*) _callback)->onClearVINResult (proxy, ::boost::static_pointer_cast<ClearVINResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ClearVINError);
                                setActAndLogError(message, "ClearVIN", reinterpret_cast<act_t>(this), _logger);
                                ((ClearVINCallbackIF*) _callback)->onClearVINError (proxy, ::boost::static_pointer_cast<ClearVINError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_PrepareDownload: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::PrepareDownloadResult);
                                setActAndLogResult(message, "PrepareDownload", reinterpret_cast<act_t>(this), _logger);
                                ((PrepareDownloadCallbackIF*) _callback)->onPrepareDownloadResult (proxy, ::boost::static_pointer_cast<PrepareDownloadResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::PrepareDownloadError);
                                setActAndLogError(message, "PrepareDownload", reinterpret_cast<act_t>(this), _logger);
                                ((PrepareDownloadCallbackIF*) _callback)->onPrepareDownloadError (proxy, ::boost::static_pointer_cast<PrepareDownloadError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_EndDownload: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::EndDownloadResult);
                                setActAndLogResult(message, "EndDownload", reinterpret_cast<act_t>(this), _logger);
                                ((EndDownloadCallbackIF*) _callback)->onEndDownloadResult (proxy, ::boost::static_pointer_cast<EndDownloadResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::EndDownloadError);
                                setActAndLogError(message, "EndDownload", reinterpret_cast<act_t>(this), _logger);
                                ((EndDownloadCallbackIF*) _callback)->onEndDownloadError (proxy, ::boost::static_pointer_cast<EndDownloadError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetOnConfiguration: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SetOnConfigurationResult);
                                setActAndLogResult(message, "SetOnConfiguration", reinterpret_cast<act_t>(this), _logger);
                                ((SetOnConfigurationCallbackIF*) _callback)->onSetOnConfigurationResult (proxy, ::boost::static_pointer_cast<SetOnConfigurationResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SetOnConfigurationError);
                                setActAndLogError(message, "SetOnConfiguration", reinterpret_cast<act_t>(this), _logger);
                                ((SetOnConfigurationCallbackIF*) _callback)->onSetOnConfigurationError (proxy, ::boost::static_pointer_cast<SetOnConfigurationError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetProcessConfiguration: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SetProcessConfigurationResult);
                                setActAndLogResult(message, "SetProcessConfiguration", reinterpret_cast<act_t>(this), _logger);
                                ((SetProcessConfigurationCallbackIF*) _callback)->onSetProcessConfigurationResult (proxy, ::boost::static_pointer_cast<SetProcessConfigurationResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SetProcessConfigurationError);
                                setActAndLogError(message, "SetProcessConfiguration", reinterpret_cast<act_t>(this), _logger);
                                ((SetProcessConfigurationCallbackIF*) _callback)->onSetProcessConfigurationError (proxy, ::boost::static_pointer_cast<SetProcessConfigurationError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_EntertainDeMute: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::EntertainDeMuteResult);
                                setActAndLogResult(message, "EntertainDeMute", reinterpret_cast<act_t>(this), _logger);
                                ((EntertainDeMuteCallbackIF*) _callback)->onEntertainDeMuteResult (proxy, ::boost::static_pointer_cast<EntertainDeMuteResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::EntertainDeMuteError);
                                setActAndLogError(message, "EntertainDeMute", reinterpret_cast<act_t>(this), _logger);
                                ((EntertainDeMuteCallbackIF*) _callback)->onEntertainDeMuteError (proxy, ::boost::static_pointer_cast<EntertainDeMuteError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_EntertainMuteRequest: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::EntertainMuteRequestResult);
                                setActAndLogResult(message, "EntertainMuteRequest", reinterpret_cast<act_t>(this), _logger);
                                ((EntertainMuteRequestCallbackIF*) _callback)->onEntertainMuteRequestResult (proxy, ::boost::static_pointer_cast<EntertainMuteRequestResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::EntertainMuteRequestError);
                                setActAndLogError(message, "EntertainMuteRequest", reinterpret_cast<act_t>(this), _logger);
                                ((EntertainMuteRequestCallbackIF*) _callback)->onEntertainMuteRequestError (proxy, ::boost::static_pointer_cast<EntertainMuteRequestError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_WelcomeAudioActivation: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::WelcomeAudioActivationResult);
                                setActAndLogResult(message, "WelcomeAudioActivation", reinterpret_cast<act_t>(this), _logger);
                                ((WelcomeAudioActivationCallbackIF*) _callback)->onWelcomeAudioActivationResult (proxy, ::boost::static_pointer_cast<WelcomeAudioActivationResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::WelcomeAudioActivationError);
                                setActAndLogError(message, "WelcomeAudioActivation", reinterpret_cast<act_t>(this), _logger);
                                ((WelcomeAudioActivationCallbackIF*) _callback)->onWelcomeAudioActivationError (proxy, ::boost::static_pointer_cast<WelcomeAudioActivationError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SystemState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SystemStateStatus);
                                setActAndLogStatus(message, "SystemState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SystemStateStatus> payload = ::boost::static_pointer_cast<SystemStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SystemStateStatus >& refNullableStatus = proxy->_systemState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SystemStateCallbackIF*) _callback)->onSystemStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SystemStateCallbackIF*) _callback)->onSystemStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SystemStateError);
                                setActAndLogError(message, "SystemState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SystemStateCallbackIF*) _callback)->onSystemStateError(proxy, ::boost::static_pointer_cast<SystemStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DownloadLockStates: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::DownloadLockStatesStatus);
                                setActAndLogStatus(message, "DownloadLockStates", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DownloadLockStatesStatus> payload = ::boost::static_pointer_cast<DownloadLockStatesStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DownloadLockStatesStatus >& refNullableStatus = proxy->_downloadLockStates;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DownloadLockStatesCallbackIF*) _callback)->onDownloadLockStatesStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DownloadLockStatesCallbackIF*) _callback)->onDownloadLockStatesStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::DownloadLockStatesError);
                                setActAndLogError(message, "DownloadLockStates", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DownloadLockStatesCallbackIF*) _callback)->onDownloadLockStatesError(proxy, ::boost::static_pointer_cast<DownloadLockStatesError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_UpdateLockStates: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::UpdateLockStatesStatus);
                                setActAndLogStatus(message, "UpdateLockStates", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<UpdateLockStatesStatus> payload = ::boost::static_pointer_cast<UpdateLockStatesStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< UpdateLockStatesStatus >& refNullableStatus = proxy->_updateLockStates;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((UpdateLockStatesCallbackIF*) _callback)->onUpdateLockStatesStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((UpdateLockStatesCallbackIF*) _callback)->onUpdateLockStatesStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::UpdateLockStatesError);
                                setActAndLogError(message, "UpdateLockStates", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((UpdateLockStatesCallbackIF*) _callback)->onUpdateLockStatesError(proxy, ::boost::static_pointer_cast<UpdateLockStatesError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ActiveOnOffTrigger: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ActiveOnOffTriggerStatus);
                                setActAndLogStatus(message, "ActiveOnOffTrigger", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ActiveOnOffTriggerStatus> payload = ::boost::static_pointer_cast<ActiveOnOffTriggerStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ActiveOnOffTriggerStatus >& refNullableStatus = proxy->_activeOnOffTrigger;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ActiveOnOffTriggerCallbackIF*) _callback)->onActiveOnOffTriggerStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ActiveOnOffTriggerCallbackIF*) _callback)->onActiveOnOffTriggerStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ActiveOnOffTriggerError);
                                setActAndLogError(message, "ActiveOnOffTrigger", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ActiveOnOffTriggerCallbackIF*) _callback)->onActiveOnOffTriggerError(proxy, ::boost::static_pointer_cast<ActiveOnOffTriggerError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SubStates: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SubStatesStatus);
                                setActAndLogStatus(message, "SubStates", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SubStatesStatus> payload = ::boost::static_pointer_cast<SubStatesStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SubStatesStatus >& refNullableStatus = proxy->_subStates;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SubStatesCallbackIF*) _callback)->onSubStatesStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SubStatesCallbackIF*) _callback)->onSubStatesStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SubStatesError);
                                setActAndLogError(message, "SubStates", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SubStatesCallbackIF*) _callback)->onSubStatesError(proxy, ::boost::static_pointer_cast<SubStatesError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_HistoryTrigger: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::HistoryTriggerStatus);
                                setActAndLogStatus(message, "HistoryTrigger", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<HistoryTriggerStatus> payload = ::boost::static_pointer_cast<HistoryTriggerStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< HistoryTriggerStatus >& refNullableStatus = proxy->_historyTrigger;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((HistoryTriggerCallbackIF*) _callback)->onHistoryTriggerStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((HistoryTriggerCallbackIF*) _callback)->onHistoryTriggerStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::HistoryTriggerError);
                                setActAndLogError(message, "HistoryTrigger", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((HistoryTriggerCallbackIF*) _callback)->onHistoryTriggerError(proxy, ::boost::static_pointer_cast<HistoryTriggerError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_InsertState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::InsertStateStatus);
                                setActAndLogStatus(message, "InsertState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<InsertStateStatus> payload = ::boost::static_pointer_cast<InsertStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< InsertStateStatus >& refNullableStatus = proxy->_insertState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((InsertStateCallbackIF*) _callback)->onInsertStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((InsertStateCallbackIF*) _callback)->onInsertStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::InsertStateError);
                                setActAndLogError(message, "InsertState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((InsertStateCallbackIF*) _callback)->onInsertStateError(proxy, ::boost::static_pointer_cast<InsertStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_MediaEjectState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::MediaEjectStateStatus);
                                setActAndLogStatus(message, "MediaEjectState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<MediaEjectStateStatus> payload = ::boost::static_pointer_cast<MediaEjectStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< MediaEjectStateStatus >& refNullableStatus = proxy->_mediaEjectState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((MediaEjectStateCallbackIF*) _callback)->onMediaEjectStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((MediaEjectStateCallbackIF*) _callback)->onMediaEjectStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::MediaEjectStateError);
                                setActAndLogError(message, "MediaEjectState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((MediaEjectStateCallbackIF*) _callback)->onMediaEjectStateError(proxy, ::boost::static_pointer_cast<MediaEjectStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_PhoneMuteState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::PhoneMuteStateStatus);
                                setActAndLogStatus(message, "PhoneMuteState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<PhoneMuteStateStatus> payload = ::boost::static_pointer_cast<PhoneMuteStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< PhoneMuteStateStatus >& refNullableStatus = proxy->_phoneMuteState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((PhoneMuteStateCallbackIF*) _callback)->onPhoneMuteStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((PhoneMuteStateCallbackIF*) _callback)->onPhoneMuteStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::PhoneMuteStateError);
                                setActAndLogError(message, "PhoneMuteState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((PhoneMuteStateCallbackIF*) _callback)->onPhoneMuteStateError(proxy, ::boost::static_pointer_cast<PhoneMuteStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_OnTipperState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::OnTipperStateStatus);
                                setActAndLogStatus(message, "OnTipperState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<OnTipperStateStatus> payload = ::boost::static_pointer_cast<OnTipperStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< OnTipperStateStatus >& refNullableStatus = proxy->_onTipperState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((OnTipperStateCallbackIF*) _callback)->onOnTipperStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((OnTipperStateCallbackIF*) _callback)->onOnTipperStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::OnTipperStateError);
                                setActAndLogError(message, "OnTipperState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((OnTipperStateCallbackIF*) _callback)->onOnTipperStateError(proxy, ::boost::static_pointer_cast<OnTipperStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_IgnitionCycles: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::IgnitionCyclesStatus);
                                setActAndLogStatus(message, "IgnitionCycles", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<IgnitionCyclesStatus> payload = ::boost::static_pointer_cast<IgnitionCyclesStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< IgnitionCyclesStatus >& refNullableStatus = proxy->_ignitionCycles;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((IgnitionCyclesCallbackIF*) _callback)->onIgnitionCyclesStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((IgnitionCyclesCallbackIF*) _callback)->onIgnitionCyclesStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::IgnitionCyclesError);
                                setActAndLogError(message, "IgnitionCycles", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((IgnitionCyclesCallbackIF*) _callback)->onIgnitionCyclesError(proxy, ::boost::static_pointer_cast<IgnitionCyclesError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SysPwrMode: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SysPwrModeStatus);
                                setActAndLogStatus(message, "SysPwrMode", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SysPwrModeStatus> payload = ::boost::static_pointer_cast<SysPwrModeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SysPwrModeStatus >& refNullableStatus = proxy->_sysPwrMode;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SysPwrModeCallbackIF*) _callback)->onSysPwrModeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SysPwrModeCallbackIF*) _callback)->onSysPwrModeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SysPwrModeError);
                                setActAndLogError(message, "SysPwrMode", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SysPwrModeCallbackIF*) _callback)->onSysPwrModeError(proxy, ::boost::static_pointer_cast<SysPwrModeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SysPwrSaveMode: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SysPwrSaveModeStatus);
                                setActAndLogStatus(message, "SysPwrSaveMode", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SysPwrSaveModeStatus> payload = ::boost::static_pointer_cast<SysPwrSaveModeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SysPwrSaveModeStatus >& refNullableStatus = proxy->_sysPwrSaveMode;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SysPwrSaveModeCallbackIF*) _callback)->onSysPwrSaveModeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SysPwrSaveModeCallbackIF*) _callback)->onSysPwrSaveModeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SysPwrSaveModeError);
                                setActAndLogError(message, "SysPwrSaveMode", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SysPwrSaveModeCallbackIF*) _callback)->onSysPwrSaveModeError(proxy, ::boost::static_pointer_cast<SysPwrSaveModeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_MapDownloadLockState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::MapDownloadLockStateStatus);
                                setActAndLogStatus(message, "MapDownloadLockState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<MapDownloadLockStateStatus> payload = ::boost::static_pointer_cast<MapDownloadLockStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< MapDownloadLockStateStatus >& refNullableStatus = proxy->_mapDownloadLockState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((MapDownloadLockStateCallbackIF*) _callback)->onMapDownloadLockStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((MapDownloadLockStateCallbackIF*) _callback)->onMapDownloadLockStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::MapDownloadLockStateError);
                                setActAndLogError(message, "MapDownloadLockState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((MapDownloadLockStateCallbackIF*) _callback)->onMapDownloadLockStateError(proxy, ::boost::static_pointer_cast<MapDownloadLockStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_StandbyTime: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::StandbyTimeStatus);
                                setActAndLogStatus(message, "StandbyTime", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<StandbyTimeStatus> payload = ::boost::static_pointer_cast<StandbyTimeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< StandbyTimeStatus >& refNullableStatus = proxy->_standbyTime;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((StandbyTimeCallbackIF*) _callback)->onStandbyTimeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((StandbyTimeCallbackIF*) _callback)->onStandbyTimeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::StandbyTimeError);
                                setActAndLogError(message, "StandbyTime", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((StandbyTimeCallbackIF*) _callback)->onStandbyTimeError(proxy, ::boost::static_pointer_cast<StandbyTimeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_PersitentStandbyTime: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::PersitentStandbyTimeStatus);
                                setActAndLogStatus(message, "PersitentStandbyTime", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<PersitentStandbyTimeStatus> payload = ::boost::static_pointer_cast<PersitentStandbyTimeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< PersitentStandbyTimeStatus >& refNullableStatus = proxy->_persitentStandbyTime;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((PersitentStandbyTimeCallbackIF*) _callback)->onPersitentStandbyTimeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((PersitentStandbyTimeCallbackIF*) _callback)->onPersitentStandbyTimeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::PersitentStandbyTimeError);
                                setActAndLogError(message, "PersitentStandbyTime", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((PersitentStandbyTimeCallbackIF*) _callback)->onPersitentStandbyTimeError(proxy, ::boost::static_pointer_cast<PersitentStandbyTimeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_IgnitionOffTime: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::IgnitionOffTimeStatus);
                                setActAndLogStatus(message, "IgnitionOffTime", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<IgnitionOffTimeStatus> payload = ::boost::static_pointer_cast<IgnitionOffTimeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< IgnitionOffTimeStatus >& refNullableStatus = proxy->_ignitionOffTime;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((IgnitionOffTimeCallbackIF*) _callback)->onIgnitionOffTimeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((IgnitionOffTimeCallbackIF*) _callback)->onIgnitionOffTimeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::IgnitionOffTimeError);
                                setActAndLogError(message, "IgnitionOffTime", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((IgnitionOffTimeCallbackIF*) _callback)->onIgnitionOffTimeError(proxy, ::boost::static_pointer_cast<IgnitionOffTimeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DoorOpenTime: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::DoorOpenTimeStatus);
                                setActAndLogStatus(message, "DoorOpenTime", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DoorOpenTimeStatus> payload = ::boost::static_pointer_cast<DoorOpenTimeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DoorOpenTimeStatus >& refNullableStatus = proxy->_doorOpenTime;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DoorOpenTimeCallbackIF*) _callback)->onDoorOpenTimeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DoorOpenTimeCallbackIF*) _callback)->onDoorOpenTimeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::DoorOpenTimeError);
                                setActAndLogError(message, "DoorOpenTime", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DoorOpenTimeCallbackIF*) _callback)->onDoorOpenTimeError(proxy, ::boost::static_pointer_cast<DoorOpenTimeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ClockDisplayTime: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ClockDisplayTimeStatus);
                                setActAndLogStatus(message, "ClockDisplayTime", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ClockDisplayTimeStatus> payload = ::boost::static_pointer_cast<ClockDisplayTimeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ClockDisplayTimeStatus >& refNullableStatus = proxy->_clockDisplayTime;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ClockDisplayTimeCallbackIF*) _callback)->onClockDisplayTimeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ClockDisplayTimeCallbackIF*) _callback)->onClockDisplayTimeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ClockDisplayTimeError);
                                setActAndLogError(message, "ClockDisplayTime", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ClockDisplayTimeCallbackIF*) _callback)->onClockDisplayTimeError(proxy, ::boost::static_pointer_cast<ClockDisplayTimeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SystemStateTime: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SystemStateTimeStatus);
                                setActAndLogStatus(message, "SystemStateTime", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SystemStateTimeStatus> payload = ::boost::static_pointer_cast<SystemStateTimeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SystemStateTimeStatus >& refNullableStatus = proxy->_systemStateTime;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SystemStateTimeCallbackIF*) _callback)->onSystemStateTimeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SystemStateTimeCallbackIF*) _callback)->onSystemStateTimeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SystemStateTimeError);
                                setActAndLogError(message, "SystemStateTime", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SystemStateTimeCallbackIF*) _callback)->onSystemStateTimeError(proxy, ::boost::static_pointer_cast<SystemStateTimeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ProcessList: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ProcessListStatus);
                                setActAndLogStatus(message, "ProcessList", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ProcessListStatus> payload = ::boost::static_pointer_cast<ProcessListStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ProcessListStatus >& refNullableStatus = proxy->_processList;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ProcessListCallbackIF*) _callback)->onProcessListStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ProcessListCallbackIF*) _callback)->onProcessListStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ProcessListError);
                                setActAndLogError(message, "ProcessList", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ProcessListCallbackIF*) _callback)->onProcessListError(proxy, ::boost::static_pointer_cast<ProcessListError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_WakeupReason: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::WakeupReasonStatus);
                                setActAndLogStatus(message, "WakeupReason", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<WakeupReasonStatus> payload = ::boost::static_pointer_cast<WakeupReasonStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< WakeupReasonStatus >& refNullableStatus = proxy->_wakeupReason;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((WakeupReasonCallbackIF*) _callback)->onWakeupReasonStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((WakeupReasonCallbackIF*) _callback)->onWakeupReasonStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::WakeupReasonError);
                                setActAndLogError(message, "WakeupReason", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((WakeupReasonCallbackIF*) _callback)->onWakeupReasonError(proxy, ::boost::static_pointer_cast<WakeupReasonError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_StartupReason: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::StartupReasonStatus);
                                setActAndLogStatus(message, "StartupReason", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<StartupReasonStatus> payload = ::boost::static_pointer_cast<StartupReasonStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< StartupReasonStatus >& refNullableStatus = proxy->_startupReason;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((StartupReasonCallbackIF*) _callback)->onStartupReasonStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((StartupReasonCallbackIF*) _callback)->onStartupReasonStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::StartupReasonError);
                                setActAndLogError(message, "StartupReason", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((StartupReasonCallbackIF*) _callback)->onStartupReasonError(proxy, ::boost::static_pointer_cast<StartupReasonError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ConnectToBattery: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ConnectToBatteryStatus);
                                setActAndLogStatus(message, "ConnectToBattery", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ConnectToBatteryStatus> payload = ::boost::static_pointer_cast<ConnectToBatteryStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ConnectToBatteryStatus >& refNullableStatus = proxy->_connectToBattery;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ConnectToBatteryCallbackIF*) _callback)->onConnectToBatteryStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ConnectToBatteryCallbackIF*) _callback)->onConnectToBatteryStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ConnectToBatteryError);
                                setActAndLogError(message, "ConnectToBattery", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ConnectToBatteryCallbackIF*) _callback)->onConnectToBatteryError(proxy, ::boost::static_pointer_cast<ConnectToBatteryError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_CodeRequestState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::CodeRequestStateStatus);
                                setActAndLogStatus(message, "CodeRequestState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<CodeRequestStateStatus> payload = ::boost::static_pointer_cast<CodeRequestStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< CodeRequestStateStatus >& refNullableStatus = proxy->_codeRequestState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((CodeRequestStateCallbackIF*) _callback)->onCodeRequestStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((CodeRequestStateCallbackIF*) _callback)->onCodeRequestStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::CodeRequestStateError);
                                setActAndLogError(message, "CodeRequestState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((CodeRequestStateCallbackIF*) _callback)->onCodeRequestStateError(proxy, ::boost::static_pointer_cast<CodeRequestStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ActiveStartUpSyncPoints: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ActiveStartUpSyncPointsStatus);
                                setActAndLogStatus(message, "ActiveStartUpSyncPoints", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ActiveStartUpSyncPointsStatus> payload = ::boost::static_pointer_cast<ActiveStartUpSyncPointsStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ActiveStartUpSyncPointsStatus >& refNullableStatus = proxy->_activeStartUpSyncPoints;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ActiveStartUpSyncPointsCallbackIF*) _callback)->onActiveStartUpSyncPointsStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ActiveStartUpSyncPointsCallbackIF*) _callback)->onActiveStartUpSyncPointsStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ActiveStartUpSyncPointsError);
                                setActAndLogError(message, "ActiveStartUpSyncPoints", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ActiveStartUpSyncPointsCallbackIF*) _callback)->onActiveStartUpSyncPointsError(proxy, ::boost::static_pointer_cast<ActiveStartUpSyncPointsError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_CvmEvent: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::CvmEventStatus);
                                setActAndLogStatus(message, "CvmEvent", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<CvmEventStatus> payload = ::boost::static_pointer_cast<CvmEventStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< CvmEventStatus >& refNullableStatus = proxy->_cvmEvent;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((CvmEventCallbackIF*) _callback)->onCvmEventStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((CvmEventCallbackIF*) _callback)->onCvmEventStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::CvmEventError);
                                setActAndLogError(message, "CvmEvent", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((CvmEventCallbackIF*) _callback)->onCvmEventError(proxy, ::boost::static_pointer_cast<CvmEventError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_UBatSense: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::UBatSenseStatus);
                                setActAndLogStatus(message, "UBatSense", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<UBatSenseStatus> payload = ::boost::static_pointer_cast<UBatSenseStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< UBatSenseStatus >& refNullableStatus = proxy->_uBatSense;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((UBatSenseCallbackIF*) _callback)->onUBatSenseStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((UBatSenseCallbackIF*) _callback)->onUBatSenseStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::UBatSenseError);
                                setActAndLogError(message, "UBatSense", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((UBatSenseCallbackIF*) _callback)->onUBatSenseError(proxy, ::boost::static_pointer_cast<UBatSenseError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_CoproState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::CoproStateStatus);
                                setActAndLogStatus(message, "CoproState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<CoproStateStatus> payload = ::boost::static_pointer_cast<CoproStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< CoproStateStatus >& refNullableStatus = proxy->_coproState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((CoproStateCallbackIF*) _callback)->onCoproStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((CoproStateCallbackIF*) _callback)->onCoproStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::CoproStateError);
                                setActAndLogError(message, "CoproState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((CoproStateCallbackIF*) _callback)->onCoproStateError(proxy, ::boost::static_pointer_cast<CoproStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DevicePowerOnTime: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::DevicePowerOnTimeStatus);
                                setActAndLogStatus(message, "DevicePowerOnTime", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DevicePowerOnTimeStatus> payload = ::boost::static_pointer_cast<DevicePowerOnTimeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DevicePowerOnTimeStatus >& refNullableStatus = proxy->_devicePowerOnTime;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DevicePowerOnTimeCallbackIF*) _callback)->onDevicePowerOnTimeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DevicePowerOnTimeCallbackIF*) _callback)->onDevicePowerOnTimeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::DevicePowerOnTimeError);
                                setActAndLogError(message, "DevicePowerOnTime", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DevicePowerOnTimeCallbackIF*) _callback)->onDevicePowerOnTimeError(proxy, ::boost::static_pointer_cast<DevicePowerOnTimeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_LastSystemRuntime: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::LastSystemRuntimeStatus);
                                setActAndLogStatus(message, "LastSystemRuntime", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<LastSystemRuntimeStatus> payload = ::boost::static_pointer_cast<LastSystemRuntimeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< LastSystemRuntimeStatus >& refNullableStatus = proxy->_lastSystemRuntime;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((LastSystemRuntimeCallbackIF*) _callback)->onLastSystemRuntimeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((LastSystemRuntimeCallbackIF*) _callback)->onLastSystemRuntimeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::LastSystemRuntimeError);
                                setActAndLogError(message, "LastSystemRuntime", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((LastSystemRuntimeCallbackIF*) _callback)->onLastSystemRuntimeError(proxy, ::boost::static_pointer_cast<LastSystemRuntimeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_CurrentSystemRuntime: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::CurrentSystemRuntimeStatus);
                                setActAndLogStatus(message, "CurrentSystemRuntime", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<CurrentSystemRuntimeStatus> payload = ::boost::static_pointer_cast<CurrentSystemRuntimeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< CurrentSystemRuntimeStatus >& refNullableStatus = proxy->_currentSystemRuntime;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((CurrentSystemRuntimeCallbackIF*) _callback)->onCurrentSystemRuntimeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((CurrentSystemRuntimeCallbackIF*) _callback)->onCurrentSystemRuntimeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::CurrentSystemRuntimeError);
                                setActAndLogError(message, "CurrentSystemRuntime", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((CurrentSystemRuntimeCallbackIF*) _callback)->onCurrentSystemRuntimeError(proxy, ::boost::static_pointer_cast<CurrentSystemRuntimeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ResetList: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ResetListStatus);
                                setActAndLogStatus(message, "ResetList", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ResetListStatus> payload = ::boost::static_pointer_cast<ResetListStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ResetListStatus >& refNullableStatus = proxy->_resetList;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ResetListCallbackIF*) _callback)->onResetListStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ResetListCallbackIF*) _callback)->onResetListStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ResetListError);
                                setActAndLogError(message, "ResetList", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ResetListCallbackIF*) _callback)->onResetListError(proxy, ::boost::static_pointer_cast<ResetListError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ResetCounter: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ResetCounterStatus);
                                setActAndLogStatus(message, "ResetCounter", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ResetCounterStatus> payload = ::boost::static_pointer_cast<ResetCounterStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ResetCounterStatus >& refNullableStatus = proxy->_resetCounter;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ResetCounterCallbackIF*) _callback)->onResetCounterStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ResetCounterCallbackIF*) _callback)->onResetCounterStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ResetCounterError);
                                setActAndLogError(message, "ResetCounter", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ResetCounterCallbackIF*) _callback)->onResetCounterError(proxy, ::boost::static_pointer_cast<ResetCounterError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_TransportModeList: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::TransportModeListStatus);
                                setActAndLogStatus(message, "TransportModeList", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<TransportModeListStatus> payload = ::boost::static_pointer_cast<TransportModeListStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< TransportModeListStatus >& refNullableStatus = proxy->_transportModeList;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((TransportModeListCallbackIF*) _callback)->onTransportModeListStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((TransportModeListCallbackIF*) _callback)->onTransportModeListStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::TransportModeListError);
                                setActAndLogError(message, "TransportModeList", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((TransportModeListCallbackIF*) _callback)->onTransportModeListError(proxy, ::boost::static_pointer_cast<TransportModeListError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ResetHistory: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ResetHistoryStatus);
                                setActAndLogStatus(message, "ResetHistory", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ResetHistoryStatus> payload = ::boost::static_pointer_cast<ResetHistoryStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ResetHistoryStatus >& refNullableStatus = proxy->_resetHistory;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ResetHistoryCallbackIF*) _callback)->onResetHistoryStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ResetHistoryCallbackIF*) _callback)->onResetHistoryStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ResetHistoryError);
                                setActAndLogError(message, "ResetHistory", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ResetHistoryCallbackIF*) _callback)->onResetHistoryError(proxy, ::boost::static_pointer_cast<ResetHistoryError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_WakeupHistory: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::WakeupHistoryStatus);
                                setActAndLogStatus(message, "WakeupHistory", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<WakeupHistoryStatus> payload = ::boost::static_pointer_cast<WakeupHistoryStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< WakeupHistoryStatus >& refNullableStatus = proxy->_wakeupHistory;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((WakeupHistoryCallbackIF*) _callback)->onWakeupHistoryStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((WakeupHistoryCallbackIF*) _callback)->onWakeupHistoryStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::WakeupHistoryError);
                                setActAndLogError(message, "WakeupHistory", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((WakeupHistoryCallbackIF*) _callback)->onWakeupHistoryError(proxy, ::boost::static_pointer_cast<WakeupHistoryError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_StateHistory: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::StateHistoryStatus);
                                setActAndLogStatus(message, "StateHistory", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<StateHistoryStatus> payload = ::boost::static_pointer_cast<StateHistoryStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< StateHistoryStatus >& refNullableStatus = proxy->_stateHistory;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((StateHistoryCallbackIF*) _callback)->onStateHistoryStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((StateHistoryCallbackIF*) _callback)->onStateHistoryStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::StateHistoryError);
                                setActAndLogError(message, "StateHistory", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((StateHistoryCallbackIF*) _callback)->onStateHistoryError(proxy, ::boost::static_pointer_cast<StateHistoryError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ErrStateHistory01: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ErrStateHistory01Status);
                                setActAndLogStatus(message, "ErrStateHistory01", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ErrStateHistory01Status> payload = ::boost::static_pointer_cast<ErrStateHistory01Status>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ErrStateHistory01Status >& refNullableStatus = proxy->_errStateHistory01;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ErrStateHistory01CallbackIF*) _callback)->onErrStateHistory01Status(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ErrStateHistory01CallbackIF*) _callback)->onErrStateHistory01Status(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ErrStateHistory01Error);
                                setActAndLogError(message, "ErrStateHistory01", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ErrStateHistory01CallbackIF*) _callback)->onErrStateHistory01Error(proxy, ::boost::static_pointer_cast<ErrStateHistory01Error>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ErrStateHistory02: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ErrStateHistory02Status);
                                setActAndLogStatus(message, "ErrStateHistory02", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ErrStateHistory02Status> payload = ::boost::static_pointer_cast<ErrStateHistory02Status>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ErrStateHistory02Status >& refNullableStatus = proxy->_errStateHistory02;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ErrStateHistory02CallbackIF*) _callback)->onErrStateHistory02Status(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ErrStateHistory02CallbackIF*) _callback)->onErrStateHistory02Status(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ErrStateHistory02Error);
                                setActAndLogError(message, "ErrStateHistory02", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ErrStateHistory02CallbackIF*) _callback)->onErrStateHistory02Error(proxy, ::boost::static_pointer_cast<ErrStateHistory02Error>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ErrStateHistory03: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ErrStateHistory03Status);
                                setActAndLogStatus(message, "ErrStateHistory03", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ErrStateHistory03Status> payload = ::boost::static_pointer_cast<ErrStateHistory03Status>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ErrStateHistory03Status >& refNullableStatus = proxy->_errStateHistory03;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ErrStateHistory03CallbackIF*) _callback)->onErrStateHistory03Status(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ErrStateHistory03CallbackIF*) _callback)->onErrStateHistory03Status(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ErrStateHistory03Error);
                                setActAndLogError(message, "ErrStateHistory03", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ErrStateHistory03CallbackIF*) _callback)->onErrStateHistory03Error(proxy, ::boost::static_pointer_cast<ErrStateHistory03Error>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ErrStateHistory04: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ErrStateHistory04Status);
                                setActAndLogStatus(message, "ErrStateHistory04", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ErrStateHistory04Status> payload = ::boost::static_pointer_cast<ErrStateHistory04Status>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ErrStateHistory04Status >& refNullableStatus = proxy->_errStateHistory04;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ErrStateHistory04CallbackIF*) _callback)->onErrStateHistory04Status(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ErrStateHistory04CallbackIF*) _callback)->onErrStateHistory04Status(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ErrStateHistory04Error);
                                setActAndLogError(message, "ErrStateHistory04", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ErrStateHistory04CallbackIF*) _callback)->onErrStateHistory04Error(proxy, ::boost::static_pointer_cast<ErrStateHistory04Error>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ErrStateHistory05: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ErrStateHistory05Status);
                                setActAndLogStatus(message, "ErrStateHistory05", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ErrStateHistory05Status> payload = ::boost::static_pointer_cast<ErrStateHistory05Status>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ErrStateHistory05Status >& refNullableStatus = proxy->_errStateHistory05;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ErrStateHistory05CallbackIF*) _callback)->onErrStateHistory05Status(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ErrStateHistory05CallbackIF*) _callback)->onErrStateHistory05Status(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ErrStateHistory05Error);
                                setActAndLogError(message, "ErrStateHistory05", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ErrStateHistory05CallbackIF*) _callback)->onErrStateHistory05Error(proxy, ::boost::static_pointer_cast<ErrStateHistory05Error>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SwitchOnHistory: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SwitchOnHistoryStatus);
                                setActAndLogStatus(message, "SwitchOnHistory", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SwitchOnHistoryStatus> payload = ::boost::static_pointer_cast<SwitchOnHistoryStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SwitchOnHistoryStatus >& refNullableStatus = proxy->_switchOnHistory;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SwitchOnHistoryCallbackIF*) _callback)->onSwitchOnHistoryStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SwitchOnHistoryCallbackIF*) _callback)->onSwitchOnHistoryStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SwitchOnHistoryError);
                                setActAndLogError(message, "SwitchOnHistory", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SwitchOnHistoryCallbackIF*) _callback)->onSwitchOnHistoryError(proxy, ::boost::static_pointer_cast<SwitchOnHistoryError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DeviceOnCounter: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::DeviceOnCounterStatus);
                                setActAndLogStatus(message, "DeviceOnCounter", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DeviceOnCounterStatus> payload = ::boost::static_pointer_cast<DeviceOnCounterStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DeviceOnCounterStatus >& refNullableStatus = proxy->_deviceOnCounter;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DeviceOnCounterCallbackIF*) _callback)->onDeviceOnCounterStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DeviceOnCounterCallbackIF*) _callback)->onDeviceOnCounterStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::DeviceOnCounterError);
                                setActAndLogError(message, "DeviceOnCounter", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DeviceOnCounterCallbackIF*) _callback)->onDeviceOnCounterError(proxy, ::boost::static_pointer_cast<DeviceOnCounterError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_VoltageEventCounter: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::VoltageEventCounterStatus);
                                setActAndLogStatus(message, "VoltageEventCounter", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<VoltageEventCounterStatus> payload = ::boost::static_pointer_cast<VoltageEventCounterStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< VoltageEventCounterStatus >& refNullableStatus = proxy->_voltageEventCounter;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((VoltageEventCounterCallbackIF*) _callback)->onVoltageEventCounterStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((VoltageEventCounterCallbackIF*) _callback)->onVoltageEventCounterStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::VoltageEventCounterError);
                                setActAndLogError(message, "VoltageEventCounter", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((VoltageEventCounterCallbackIF*) _callback)->onVoltageEventCounterError(proxy, ::boost::static_pointer_cast<VoltageEventCounterError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_VoltageRangeHistogram: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::VoltageRangeHistogramStatus);
                                setActAndLogStatus(message, "VoltageRangeHistogram", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<VoltageRangeHistogramStatus> payload = ::boost::static_pointer_cast<VoltageRangeHistogramStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< VoltageRangeHistogramStatus >& refNullableStatus = proxy->_voltageRangeHistogram;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((VoltageRangeHistogramCallbackIF*) _callback)->onVoltageRangeHistogramStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((VoltageRangeHistogramCallbackIF*) _callback)->onVoltageRangeHistogramStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::VoltageRangeHistogramError);
                                setActAndLogError(message, "VoltageRangeHistogram", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((VoltageRangeHistogramCallbackIF*) _callback)->onVoltageRangeHistogramError(proxy, ::boost::static_pointer_cast<VoltageRangeHistogramError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_CpuUsageStatistic: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::CpuUsageStatisticStatus);
                                setActAndLogStatus(message, "CpuUsageStatistic", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<CpuUsageStatisticStatus> payload = ::boost::static_pointer_cast<CpuUsageStatisticStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< CpuUsageStatisticStatus >& refNullableStatus = proxy->_cpuUsageStatistic;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((CpuUsageStatisticCallbackIF*) _callback)->onCpuUsageStatisticStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((CpuUsageStatisticCallbackIF*) _callback)->onCpuUsageStatisticStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::CpuUsageStatisticError);
                                setActAndLogError(message, "CpuUsageStatistic", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((CpuUsageStatisticCallbackIF*) _callback)->onCpuUsageStatisticError(proxy, ::boost::static_pointer_cast<CpuUsageStatisticError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RamUsageStatistic: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::RamUsageStatisticStatus);
                                setActAndLogStatus(message, "RamUsageStatistic", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<RamUsageStatisticStatus> payload = ::boost::static_pointer_cast<RamUsageStatisticStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< RamUsageStatisticStatus >& refNullableStatus = proxy->_ramUsageStatistic;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((RamUsageStatisticCallbackIF*) _callback)->onRamUsageStatisticStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((RamUsageStatisticCallbackIF*) _callback)->onRamUsageStatisticStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::RamUsageStatisticError);
                                setActAndLogError(message, "RamUsageStatistic", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((RamUsageStatisticCallbackIF*) _callback)->onRamUsageStatisticError(proxy, ::boost::static_pointer_cast<RamUsageStatisticError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_StartupTimeStatistic: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::StartupTimeStatisticStatus);
                                setActAndLogStatus(message, "StartupTimeStatistic", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<StartupTimeStatisticStatus> payload = ::boost::static_pointer_cast<StartupTimeStatisticStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< StartupTimeStatisticStatus >& refNullableStatus = proxy->_startupTimeStatistic;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((StartupTimeStatisticCallbackIF*) _callback)->onStartupTimeStatisticStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((StartupTimeStatisticCallbackIF*) _callback)->onStartupTimeStatisticStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::StartupTimeStatisticError);
                                setActAndLogError(message, "StartupTimeStatistic", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((StartupTimeStatisticCallbackIF*) _callback)->onStartupTimeStatisticError(proxy, ::boost::static_pointer_cast<StartupTimeStatisticError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SWVersionStatistic: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SWVersionStatisticStatus);
                                setActAndLogStatus(message, "SWVersionStatistic", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SWVersionStatisticStatus> payload = ::boost::static_pointer_cast<SWVersionStatisticStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SWVersionStatisticStatus >& refNullableStatus = proxy->_sWVersionStatistic;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SWVersionStatisticCallbackIF*) _callback)->onSWVersionStatisticStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SWVersionStatisticCallbackIF*) _callback)->onSWVersionStatisticStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SWVersionStatisticError);
                                setActAndLogError(message, "SWVersionStatistic", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SWVersionStatisticCallbackIF*) _callback)->onSWVersionStatisticError(proxy, ::boost::static_pointer_cast<SWVersionStatisticError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RunlevelState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::RunlevelStateStatus);
                                setActAndLogStatus(message, "RunlevelState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<RunlevelStateStatus> payload = ::boost::static_pointer_cast<RunlevelStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< RunlevelStateStatus >& refNullableStatus = proxy->_runlevelState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((RunlevelStateCallbackIF*) _callback)->onRunlevelStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((RunlevelStateCallbackIF*) _callback)->onRunlevelStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::RunlevelStateError);
                                setActAndLogError(message, "RunlevelState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((RunlevelStateCallbackIF*) _callback)->onRunlevelStateError(proxy, ::boost::static_pointer_cast<RunlevelStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Restart: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::RestartStatus);
                                setActAndLogStatus(message, "Restart", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<RestartStatus> payload = ::boost::static_pointer_cast<RestartStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< RestartStatus >& refNullableStatus = proxy->_restart;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((RestartCallbackIF*) _callback)->onRestartStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RestartCallbackIF*) _callback)->onRestartStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::RestartError);
                                setActAndLogError(message, "Restart", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RestartCallbackIF*) _callback)->onRestartError(proxy, ::boost::static_pointer_cast<RestartError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Lifesign: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::LifesignStatus);
                                setActAndLogStatus(message, "Lifesign", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<LifesignStatus> payload = ::boost::static_pointer_cast<LifesignStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< LifesignStatus >& refNullableStatus = proxy->_lifesign;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((LifesignCallbackIF*) _callback)->onLifesignStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((LifesignCallbackIF*) _callback)->onLifesignStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::LifesignError);
                                setActAndLogError(message, "Lifesign", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((LifesignCallbackIF*) _callback)->onLifesignError(proxy, ::boost::static_pointer_cast<LifesignError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_HmiState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::HmiStateStatus);
                                setActAndLogStatus(message, "HmiState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<HmiStateStatus> payload = ::boost::static_pointer_cast<HmiStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< HmiStateStatus >& refNullableStatus = proxy->_hmiState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((HmiStateCallbackIF*) _callback)->onHmiStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((HmiStateCallbackIF*) _callback)->onHmiStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::HmiStateError);
                                setActAndLogError(message, "HmiState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((HmiStateCallbackIF*) _callback)->onHmiStateError(proxy, ::boost::static_pointer_cast<HmiStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SystemPowerBehaviour: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SystemPowerBehaviourStatus);
                                setActAndLogStatus(message, "SystemPowerBehaviour", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SystemPowerBehaviourStatus> payload = ::boost::static_pointer_cast<SystemPowerBehaviourStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SystemPowerBehaviourStatus >& refNullableStatus = proxy->_systemPowerBehaviour;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SystemPowerBehaviourCallbackIF*) _callback)->onSystemPowerBehaviourStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SystemPowerBehaviourCallbackIF*) _callback)->onSystemPowerBehaviourStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SystemPowerBehaviourError);
                                setActAndLogError(message, "SystemPowerBehaviour", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SystemPowerBehaviourCallbackIF*) _callback)->onSystemPowerBehaviourError(proxy, ::boost::static_pointer_cast<SystemPowerBehaviourError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DimState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::DimStateStatus);
                                setActAndLogStatus(message, "DimState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DimStateStatus> payload = ::boost::static_pointer_cast<DimStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DimStateStatus >& refNullableStatus = proxy->_dimState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DimStateCallbackIF*) _callback)->onDimStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DimStateCallbackIF*) _callback)->onDimStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::DimStateError);
                                setActAndLogError(message, "DimState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DimStateCallbackIF*) _callback)->onDimStateError(proxy, ::boost::static_pointer_cast<DimStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DimmingState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::DimmingStateStatus);
                                setActAndLogStatus(message, "DimmingState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DimmingStateStatus> payload = ::boost::static_pointer_cast<DimmingStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DimmingStateStatus >& refNullableStatus = proxy->_dimmingState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DimmingStateCallbackIF*) _callback)->onDimmingStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DimmingStateCallbackIF*) _callback)->onDimmingStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::DimmingStateError);
                                setActAndLogError(message, "DimmingState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DimmingStateCallbackIF*) _callback)->onDimmingStateError(proxy, ::boost::static_pointer_cast<DimmingStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_BluetoothState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::BluetoothStateStatus);
                                setActAndLogStatus(message, "BluetoothState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<BluetoothStateStatus> payload = ::boost::static_pointer_cast<BluetoothStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< BluetoothStateStatus >& refNullableStatus = proxy->_bluetoothState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((BluetoothStateCallbackIF*) _callback)->onBluetoothStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((BluetoothStateCallbackIF*) _callback)->onBluetoothStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::BluetoothStateError);
                                setActAndLogError(message, "BluetoothState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((BluetoothStateCallbackIF*) _callback)->onBluetoothStateError(proxy, ::boost::static_pointer_cast<BluetoothStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AudioState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::AudioStateStatus);
                                setActAndLogStatus(message, "AudioState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AudioStateStatus> payload = ::boost::static_pointer_cast<AudioStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AudioStateStatus >& refNullableStatus = proxy->_audioState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AudioStateCallbackIF*) _callback)->onAudioStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AudioStateCallbackIF*) _callback)->onAudioStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::AudioStateError);
                                setActAndLogError(message, "AudioState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AudioStateCallbackIF*) _callback)->onAudioStateError(proxy, ::boost::static_pointer_cast<AudioStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SpiState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SpiStateStatus);
                                setActAndLogStatus(message, "SpiState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SpiStateStatus> payload = ::boost::static_pointer_cast<SpiStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SpiStateStatus >& refNullableStatus = proxy->_spiState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SpiStateCallbackIF*) _callback)->onSpiStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SpiStateCallbackIF*) _callback)->onSpiStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SpiStateError);
                                setActAndLogError(message, "SpiState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SpiStateCallbackIF*) _callback)->onSpiStateError(proxy, ::boost::static_pointer_cast<SpiStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_TunerState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::TunerStateStatus);
                                setActAndLogStatus(message, "TunerState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<TunerStateStatus> payload = ::boost::static_pointer_cast<TunerStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< TunerStateStatus >& refNullableStatus = proxy->_tunerState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((TunerStateCallbackIF*) _callback)->onTunerStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((TunerStateCallbackIF*) _callback)->onTunerStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::TunerStateError);
                                setActAndLogError(message, "TunerState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((TunerStateCallbackIF*) _callback)->onTunerStateError(proxy, ::boost::static_pointer_cast<TunerStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_WifiState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::WifiStateStatus);
                                setActAndLogStatus(message, "WifiState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<WifiStateStatus> payload = ::boost::static_pointer_cast<WifiStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< WifiStateStatus >& refNullableStatus = proxy->_wifiState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((WifiStateCallbackIF*) _callback)->onWifiStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((WifiStateCallbackIF*) _callback)->onWifiStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::WifiStateError);
                                setActAndLogError(message, "WifiState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((WifiStateCallbackIF*) _callback)->onWifiStateError(proxy, ::boost::static_pointer_cast<WifiStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_OnOffReason: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::OnOffReasonStatus);
                                setActAndLogStatus(message, "OnOffReason", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<OnOffReasonStatus> payload = ::boost::static_pointer_cast<OnOffReasonStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< OnOffReasonStatus >& refNullableStatus = proxy->_onOffReason;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((OnOffReasonCallbackIF*) _callback)->onOnOffReasonStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((OnOffReasonCallbackIF*) _callback)->onOnOffReasonStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::OnOffReasonError);
                                setActAndLogError(message, "OnOffReason", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((OnOffReasonCallbackIF*) _callback)->onOnOffReasonError(proxy, ::boost::static_pointer_cast<OnOffReasonError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_WakeupList: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::WakeupListStatus);
                                setActAndLogStatus(message, "WakeupList", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<WakeupListStatus> payload = ::boost::static_pointer_cast<WakeupListStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< WakeupListStatus >& refNullableStatus = proxy->_wakeupList;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((WakeupListCallbackIF*) _callback)->onWakeupListStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((WakeupListCallbackIF*) _callback)->onWakeupListStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::WakeupListError);
                                setActAndLogError(message, "WakeupList", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((WakeupListCallbackIF*) _callback)->onWakeupListError(proxy, ::boost::static_pointer_cast<WakeupListError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_StartupFinished: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::StartupFinishedStatus);
                                setActAndLogStatus(message, "StartupFinished", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<StartupFinishedStatus> payload = ::boost::static_pointer_cast<StartupFinishedStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< StartupFinishedStatus >& refNullableStatus = proxy->_startupFinished;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((StartupFinishedCallbackIF*) _callback)->onStartupFinishedStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((StartupFinishedCallbackIF*) _callback)->onStartupFinishedStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::StartupFinishedError);
                                setActAndLogError(message, "StartupFinished", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((StartupFinishedCallbackIF*) _callback)->onStartupFinishedError(proxy, ::boost::static_pointer_cast<StartupFinishedError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SysState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SysStateStatus);
                                setActAndLogStatus(message, "SysState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SysStateStatus> payload = ::boost::static_pointer_cast<SysStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SysStateStatus >& refNullableStatus = proxy->_sysState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SysStateCallbackIF*) _callback)->onSysStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SysStateCallbackIF*) _callback)->onSysStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SysStateError);
                                setActAndLogError(message, "SysState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SysStateCallbackIF*) _callback)->onSysStateError(proxy, ::boost::static_pointer_cast<SysStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_MostState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::MostStateStatus);
                                setActAndLogStatus(message, "MostState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<MostStateStatus> payload = ::boost::static_pointer_cast<MostStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< MostStateStatus >& refNullableStatus = proxy->_mostState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((MostStateCallbackIF*) _callback)->onMostStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((MostStateCallbackIF*) _callback)->onMostStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::MostStateError);
                                setActAndLogError(message, "MostState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((MostStateCallbackIF*) _callback)->onMostStateError(proxy, ::boost::static_pointer_cast<MostStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_MostVersion: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::MostVersionStatus);
                                setActAndLogStatus(message, "MostVersion", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<MostVersionStatus> payload = ::boost::static_pointer_cast<MostVersionStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< MostVersionStatus >& refNullableStatus = proxy->_mostVersion;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((MostVersionCallbackIF*) _callback)->onMostVersionStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((MostVersionCallbackIF*) _callback)->onMostVersionStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::MostVersionError);
                                setActAndLogError(message, "MostVersion", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((MostVersionCallbackIF*) _callback)->onMostVersionError(proxy, ::boost::static_pointer_cast<MostVersionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RVCState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::RVCStateStatus);
                                setActAndLogStatus(message, "RVCState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<RVCStateStatus> payload = ::boost::static_pointer_cast<RVCStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< RVCStateStatus >& refNullableStatus = proxy->_rVCState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((RVCStateCallbackIF*) _callback)->onRVCStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RVCStateCallbackIF*) _callback)->onRVCStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::RVCStateError);
                                setActAndLogError(message, "RVCState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RVCStateCallbackIF*) _callback)->onRVCStateError(proxy, ::boost::static_pointer_cast<RVCStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_TriggerMostRemoteReset: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::TriggerMostRemoteResetStatus);
                                setActAndLogStatus(message, "TriggerMostRemoteReset", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<TriggerMostRemoteResetStatus> payload = ::boost::static_pointer_cast<TriggerMostRemoteResetStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< TriggerMostRemoteResetStatus >& refNullableStatus = proxy->_triggerMostRemoteReset;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((TriggerMostRemoteResetCallbackIF*) _callback)->onTriggerMostRemoteResetStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((TriggerMostRemoteResetCallbackIF*) _callback)->onTriggerMostRemoteResetStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::TriggerMostRemoteResetError);
                                setActAndLogError(message, "TriggerMostRemoteReset", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((TriggerMostRemoteResetCallbackIF*) _callback)->onTriggerMostRemoteResetError(proxy, ::boost::static_pointer_cast<TriggerMostRemoteResetError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Partnumber: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::PartnumberStatus);
                                setActAndLogStatus(message, "Partnumber", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<PartnumberStatus> payload = ::boost::static_pointer_cast<PartnumberStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< PartnumberStatus >& refNullableStatus = proxy->_partnumber;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((PartnumberCallbackIF*) _callback)->onPartnumberStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((PartnumberCallbackIF*) _callback)->onPartnumberStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::PartnumberError);
                                setActAndLogError(message, "Partnumber", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((PartnumberCallbackIF*) _callback)->onPartnumberError(proxy, ::boost::static_pointer_cast<PartnumberError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Partnumbers: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::PartnumbersStatus);
                                setActAndLogStatus(message, "Partnumbers", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<PartnumbersStatus> payload = ::boost::static_pointer_cast<PartnumbersStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< PartnumbersStatus >& refNullableStatus = proxy->_partnumbers;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((PartnumbersCallbackIF*) _callback)->onPartnumbersStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((PartnumbersCallbackIF*) _callback)->onPartnumbersStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::PartnumbersError);
                                setActAndLogError(message, "Partnumbers", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((PartnumbersCallbackIF*) _callback)->onPartnumbersError(proxy, ::boost::static_pointer_cast<PartnumbersError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Alphacode: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::AlphacodeStatus);
                                setActAndLogStatus(message, "Alphacode", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AlphacodeStatus> payload = ::boost::static_pointer_cast<AlphacodeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AlphacodeStatus >& refNullableStatus = proxy->_alphacode;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AlphacodeCallbackIF*) _callback)->onAlphacodeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AlphacodeCallbackIF*) _callback)->onAlphacodeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::AlphacodeError);
                                setActAndLogError(message, "Alphacode", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AlphacodeCallbackIF*) _callback)->onAlphacodeError(proxy, ::boost::static_pointer_cast<AlphacodeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Alphacodes: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::AlphacodesStatus);
                                setActAndLogStatus(message, "Alphacodes", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AlphacodesStatus> payload = ::boost::static_pointer_cast<AlphacodesStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AlphacodesStatus >& refNullableStatus = proxy->_alphacodes;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AlphacodesCallbackIF*) _callback)->onAlphacodesStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AlphacodesCallbackIF*) _callback)->onAlphacodesStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::AlphacodesError);
                                setActAndLogError(message, "Alphacodes", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AlphacodesCallbackIF*) _callback)->onAlphacodesError(proxy, ::boost::static_pointer_cast<AlphacodesError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ManufacturersEnableCounter: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ManufacturersEnableCounterStatus);
                                setActAndLogStatus(message, "ManufacturersEnableCounter", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ManufacturersEnableCounterStatus> payload = ::boost::static_pointer_cast<ManufacturersEnableCounterStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ManufacturersEnableCounterStatus >& refNullableStatus = proxy->_manufacturersEnableCounter;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ManufacturersEnableCounterCallbackIF*) _callback)->onManufacturersEnableCounterStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ManufacturersEnableCounterCallbackIF*) _callback)->onManufacturersEnableCounterStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ManufacturersEnableCounterError);
                                setActAndLogError(message, "ManufacturersEnableCounter", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ManufacturersEnableCounterCallbackIF*) _callback)->onManufacturersEnableCounterError(proxy, ::boost::static_pointer_cast<ManufacturersEnableCounterError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_NoCalibrationState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::NoCalibrationStateStatus);
                                setActAndLogStatus(message, "NoCalibrationState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<NoCalibrationStateStatus> payload = ::boost::static_pointer_cast<NoCalibrationStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< NoCalibrationStateStatus >& refNullableStatus = proxy->_noCalibrationState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((NoCalibrationStateCallbackIF*) _callback)->onNoCalibrationStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((NoCalibrationStateCallbackIF*) _callback)->onNoCalibrationStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::NoCalibrationStateError);
                                setActAndLogError(message, "NoCalibrationState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((NoCalibrationStateCallbackIF*) _callback)->onNoCalibrationStateError(proxy, ::boost::static_pointer_cast<NoCalibrationStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SecurityCommError: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SecurityCommErrorStatus);
                                setActAndLogStatus(message, "SecurityCommError", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SecurityCommErrorStatus> payload = ::boost::static_pointer_cast<SecurityCommErrorStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SecurityCommErrorStatus >& refNullableStatus = proxy->_securityCommError;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SecurityCommErrorCallbackIF*) _callback)->onSecurityCommErrorStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SecurityCommErrorCallbackIF*) _callback)->onSecurityCommErrorStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SecurityCommErrorError);
                                setActAndLogError(message, "SecurityCommError", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SecurityCommErrorCallbackIF*) _callback)->onSecurityCommErrorError(proxy, ::boost::static_pointer_cast<SecurityCommErrorError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SecurityMoreThan10Vin: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SecurityMoreThan10VinStatus);
                                setActAndLogStatus(message, "SecurityMoreThan10Vin", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SecurityMoreThan10VinStatus> payload = ::boost::static_pointer_cast<SecurityMoreThan10VinStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SecurityMoreThan10VinStatus >& refNullableStatus = proxy->_securityMoreThan10Vin;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SecurityMoreThan10VinCallbackIF*) _callback)->onSecurityMoreThan10VinStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SecurityMoreThan10VinCallbackIF*) _callback)->onSecurityMoreThan10VinStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SecurityMoreThan10VinError);
                                setActAndLogError(message, "SecurityMoreThan10Vin", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SecurityMoreThan10VinCallbackIF*) _callback)->onSecurityMoreThan10VinError(proxy, ::boost::static_pointer_cast<SecurityMoreThan10VinError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SecurityInvalidVin: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SecurityInvalidVinStatus);
                                setActAndLogStatus(message, "SecurityInvalidVin", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SecurityInvalidVinStatus> payload = ::boost::static_pointer_cast<SecurityInvalidVinStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SecurityInvalidVinStatus >& refNullableStatus = proxy->_securityInvalidVin;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SecurityInvalidVinCallbackIF*) _callback)->onSecurityInvalidVinStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SecurityInvalidVinCallbackIF*) _callback)->onSecurityInvalidVinStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SecurityInvalidVinError);
                                setActAndLogError(message, "SecurityInvalidVin", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SecurityInvalidVinCallbackIF*) _callback)->onSecurityInvalidVinError(proxy, ::boost::static_pointer_cast<SecurityInvalidVinError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SecurityCurrentVin: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SecurityCurrentVinStatus);
                                setActAndLogStatus(message, "SecurityCurrentVin", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SecurityCurrentVinStatus> payload = ::boost::static_pointer_cast<SecurityCurrentVinStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SecurityCurrentVinStatus >& refNullableStatus = proxy->_securityCurrentVin;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SecurityCurrentVinCallbackIF*) _callback)->onSecurityCurrentVinStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SecurityCurrentVinCallbackIF*) _callback)->onSecurityCurrentVinStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SecurityCurrentVinError);
                                setActAndLogError(message, "SecurityCurrentVin", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SecurityCurrentVinCallbackIF*) _callback)->onSecurityCurrentVinError(proxy, ::boost::static_pointer_cast<SecurityCurrentVinError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SecurityVinHistory: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SecurityVinHistoryStatus);
                                setActAndLogStatus(message, "SecurityVinHistory", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SecurityVinHistoryStatus> payload = ::boost::static_pointer_cast<SecurityVinHistoryStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SecurityVinHistoryStatus >& refNullableStatus = proxy->_securityVinHistory;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SecurityVinHistoryCallbackIF*) _callback)->onSecurityVinHistoryStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SecurityVinHistoryCallbackIF*) _callback)->onSecurityVinHistoryStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SecurityVinHistoryError);
                                setActAndLogError(message, "SecurityVinHistory", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SecurityVinHistoryCallbackIF*) _callback)->onSecurityVinHistoryError(proxy, ::boost::static_pointer_cast<SecurityVinHistoryError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_VIN: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::VINStatus);
                                setActAndLogStatus(message, "VIN", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<VINStatus> payload = ::boost::static_pointer_cast<VINStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< VINStatus >& refNullableStatus = proxy->_vIN;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((VINCallbackIF*) _callback)->onVINStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((VINCallbackIF*) _callback)->onVINStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::VINError);
                                setActAndLogError(message, "VIN", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((VINCallbackIF*) _callback)->onVINError(proxy, ::boost::static_pointer_cast<VINError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SecurityState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SecurityStateStatus);
                                setActAndLogStatus(message, "SecurityState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SecurityStateStatus> payload = ::boost::static_pointer_cast<SecurityStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SecurityStateStatus >& refNullableStatus = proxy->_securityState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SecurityStateCallbackIF*) _callback)->onSecurityStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SecurityStateCallbackIF*) _callback)->onSecurityStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::SecurityStateError);
                                setActAndLogError(message, "SecurityState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((SecurityStateCallbackIF*) _callback)->onSecurityStateError(proxy, ::boost::static_pointer_cast<SecurityStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_VehicleID: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::VehicleIDStatus);
                                setActAndLogStatus(message, "VehicleID", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<VehicleIDStatus> payload = ::boost::static_pointer_cast<VehicleIDStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< VehicleIDStatus >& refNullableStatus = proxy->_vehicleID;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((VehicleIDCallbackIF*) _callback)->onVehicleIDStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((VehicleIDCallbackIF*) _callback)->onVehicleIDStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::VehicleIDError);
                                setActAndLogError(message, "VehicleID", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((VehicleIDCallbackIF*) _callback)->onVehicleIDError(proxy, ::boost::static_pointer_cast<VehicleIDError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DisplayVariant: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::DisplayVariantStatus);
                                setActAndLogStatus(message, "DisplayVariant", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DisplayVariantStatus> payload = ::boost::static_pointer_cast<DisplayVariantStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DisplayVariantStatus >& refNullableStatus = proxy->_displayVariant;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DisplayVariantCallbackIF*) _callback)->onDisplayVariantStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DisplayVariantCallbackIF*) _callback)->onDisplayVariantStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::DisplayVariantError);
                                setActAndLogError(message, "DisplayVariant", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DisplayVariantCallbackIF*) _callback)->onDisplayVariantError(proxy, ::boost::static_pointer_cast<DisplayVariantError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ReductionLevel: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ReductionLevelStatus);
                                setActAndLogStatus(message, "ReductionLevel", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ReductionLevelStatus> payload = ::boost::static_pointer_cast<ReductionLevelStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ReductionLevelStatus >& refNullableStatus = proxy->_reductionLevel;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ReductionLevelCallbackIF*) _callback)->onReductionLevelStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ReductionLevelCallbackIF*) _callback)->onReductionLevelStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::ReductionLevelError);
                                setActAndLogError(message, "ReductionLevel", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ReductionLevelCallbackIF*) _callback)->onReductionLevelError(proxy, ::boost::static_pointer_cast<ReductionLevelError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_StartupState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::StartupStateStatus);
                                setActAndLogStatus(message, "StartupState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<StartupStateStatus> payload = ::boost::static_pointer_cast<StartupStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< StartupStateStatus >& refNullableStatus = proxy->_startupState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((StartupStateCallbackIF*) _callback)->onStartupStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((StartupStateCallbackIF*) _callback)->onStartupStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::StartupStateError);
                                setActAndLogError(message, "StartupState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((StartupStateCallbackIF*) _callback)->onStartupStateError(proxy, ::boost::static_pointer_cast<StartupStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_EntertainMute: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::EntertainMuteStatus);
                                setActAndLogStatus(message, "EntertainMute", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<EntertainMuteStatus> payload = ::boost::static_pointer_cast<EntertainMuteStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< EntertainMuteStatus >& refNullableStatus = proxy->_entertainMute;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((EntertainMuteCallbackIF*) _callback)->onEntertainMuteStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((EntertainMuteCallbackIF*) _callback)->onEntertainMuteStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::EntertainMuteError);
                                setActAndLogError(message, "EntertainMute", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((EntertainMuteCallbackIF*) _callback)->onEntertainMuteError(proxy, ::boost::static_pointer_cast<EntertainMuteError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_WelcomeAudioState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::WelcomeAudioStateStatus);
                                setActAndLogStatus(message, "WelcomeAudioState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<WelcomeAudioStateStatus> payload = ::boost::static_pointer_cast<WelcomeAudioStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< WelcomeAudioStateStatus >& refNullableStatus = proxy->_welcomeAudioState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((WelcomeAudioStateCallbackIF*) _callback)->onWelcomeAudioStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((WelcomeAudioStateCallbackIF*) _callback)->onWelcomeAudioStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::WelcomeAudioStateError);
                                setActAndLogError(message, "WelcomeAudioState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((WelcomeAudioStateCallbackIF*) _callback)->onWelcomeAudioStateError(proxy, ::boost::static_pointer_cast<WelcomeAudioStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_UnballastTimeFromEngineStopped: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::UnballastTimeFromEngineStoppedStatus);
                                setActAndLogStatus(message, "UnballastTimeFromEngineStopped", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<UnballastTimeFromEngineStoppedStatus> payload = ::boost::static_pointer_cast<UnballastTimeFromEngineStoppedStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< UnballastTimeFromEngineStoppedStatus >& refNullableStatus = proxy->_unballastTimeFromEngineStopped;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((UnballastTimeFromEngineStoppedCallbackIF*) _callback)->onUnballastTimeFromEngineStoppedStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((UnballastTimeFromEngineStoppedCallbackIF*) _callback)->onUnballastTimeFromEngineStoppedStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::UnballastTimeFromEngineStoppedError);
                                setActAndLogError(message, "UnballastTimeFromEngineStopped", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((UnballastTimeFromEngineStoppedCallbackIF*) _callback)->onUnballastTimeFromEngineStoppedError(proxy, ::boost::static_pointer_cast<UnballastTimeFromEngineStoppedError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_UnballastTimeBeforeUnballast: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::UnballastTimeBeforeUnballastStatus);
                                setActAndLogStatus(message, "UnballastTimeBeforeUnballast", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<UnballastTimeBeforeUnballastStatus> payload = ::boost::static_pointer_cast<UnballastTimeBeforeUnballastStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< UnballastTimeBeforeUnballastStatus >& refNullableStatus = proxy->_unballastTimeBeforeUnballast;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((UnballastTimeBeforeUnballastCallbackIF*) _callback)->onUnballastTimeBeforeUnballastStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((UnballastTimeBeforeUnballastCallbackIF*) _callback)->onUnballastTimeBeforeUnballastStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::UnballastTimeBeforeUnballastError);
                                setActAndLogError(message, "UnballastTimeBeforeUnballast", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((UnballastTimeBeforeUnballastCallbackIF*) _callback)->onUnballastTimeBeforeUnballastError(proxy, ::boost::static_pointer_cast<UnballastTimeBeforeUnballastError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_UnballastWarningTime: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::UnballastWarningTimeStatus);
                                setActAndLogStatus(message, "UnballastWarningTime", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<UnballastWarningTimeStatus> payload = ::boost::static_pointer_cast<UnballastWarningTimeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< UnballastWarningTimeStatus >& refNullableStatus = proxy->_unballastWarningTime;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((UnballastWarningTimeCallbackIF*) _callback)->onUnballastWarningTimeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((UnballastWarningTimeCallbackIF*) _callback)->onUnballastWarningTimeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::UnballastWarningTimeError);
                                setActAndLogError(message, "UnballastWarningTime", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((UnballastWarningTimeCallbackIF*) _callback)->onUnballastWarningTimeError(proxy, ::boost::static_pointer_cast<UnballastWarningTimeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DegradedCount: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::DegradedCountStatus);
                                setActAndLogStatus(message, "DegradedCount", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DegradedCountStatus> payload = ::boost::static_pointer_cast<DegradedCountStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DegradedCountStatus >& refNullableStatus = proxy->_degradedCount;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DegradedCountCallbackIF*) _callback)->onDegradedCountStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DegradedCountCallbackIF*) _callback)->onDegradedCountStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::DegradedCountError);
                                setActAndLogError(message, "DegradedCount", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DegradedCountCallbackIF*) _callback)->onDegradedCountError(proxy, ::boost::static_pointer_cast<DegradedCountError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DegradedTime: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::DegradedTimeStatus);
                                setActAndLogStatus(message, "DegradedTime", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DegradedTimeStatus> payload = ::boost::static_pointer_cast<DegradedTimeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DegradedTimeStatus >& refNullableStatus = proxy->_degradedTime;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DegradedTimeCallbackIF*) _callback)->onDegradedTimeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DegradedTimeCallbackIF*) _callback)->onDegradedTimeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::DegradedTimeError);
                                setActAndLogError(message, "DegradedTime", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DegradedTimeCallbackIF*) _callback)->onDegradedTimeError(proxy, ::boost::static_pointer_cast<DegradedTimeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_PhoneHandoverWarnTime: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::PhoneHandoverWarnTimeStatus);
                                setActAndLogStatus(message, "PhoneHandoverWarnTime", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<PhoneHandoverWarnTimeStatus> payload = ::boost::static_pointer_cast<PhoneHandoverWarnTimeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< PhoneHandoverWarnTimeStatus >& refNullableStatus = proxy->_phoneHandoverWarnTime;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((PhoneHandoverWarnTimeCallbackIF*) _callback)->onPhoneHandoverWarnTimeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((PhoneHandoverWarnTimeCallbackIF*) _callback)->onPhoneHandoverWarnTimeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::SPM_CORE_FI::PhoneHandoverWarnTimeError);
                                setActAndLogError(message, "PhoneHandoverWarnTime", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((PhoneHandoverWarnTimeCallbackIF*) _callback)->onPhoneHandoverWarnTimeError(proxy, ::boost::static_pointer_cast<PhoneHandoverWarnTimeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<SPM_CORE_FIProxy> proxy = ::boost::static_pointer_cast<SPM_CORE_FIProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_SystemMode: {
                ::boost::shared_ptr< SystemModeError > payload (new SystemModeError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SystemMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SystemModeCallbackIF*) _callback)->onSystemModeError (proxy, payload);
                return true;
            }
            case FID_DownloadLockState: {
                ::boost::shared_ptr< DownloadLockStateError > payload (new DownloadLockStateError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DownloadLockState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((DownloadLockStateCallbackIF*) _callback)->onDownloadLockStateError (proxy, payload);
                return true;
            }
            case FID_UpdateLock: {
                ::boost::shared_ptr< UpdateLockError > payload (new UpdateLockError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UpdateLock", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((UpdateLockCallbackIF*) _callback)->onUpdateLockError (proxy, payload);
                return true;
            }
            case FID_OnOffTrigger: {
                ::boost::shared_ptr< OnOffTriggerError > payload (new OnOffTriggerError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "OnOffTrigger", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((OnOffTriggerCallbackIF*) _callback)->onOnOffTriggerError (proxy, payload);
                return true;
            }
            case FID_StartProcess: {
                ::boost::shared_ptr< StartProcessError > payload (new StartProcessError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartProcess", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((StartProcessCallbackIF*) _callback)->onStartProcessError (proxy, payload);
                return true;
            }
            case FID_StopProcess: {
                ::boost::shared_ptr< StopProcessError > payload (new StopProcessError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StopProcess", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((StopProcessCallbackIF*) _callback)->onStopProcessError (proxy, payload);
                return true;
            }
            case FID_RestartProcess: {
                ::boost::shared_ptr< RestartProcessError > payload (new RestartProcessError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RestartProcess", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((RestartProcessCallbackIF*) _callback)->onRestartProcessError (proxy, payload);
                return true;
            }
            case FID_StartUpSyncPointReached: {
                ::boost::shared_ptr< StartUpSyncPointReachedError > payload (new StartUpSyncPointReachedError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartUpSyncPointReached", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((StartUpSyncPointReachedCallbackIF*) _callback)->onStartUpSyncPointReachedError (proxy, payload);
                return true;
            }
            case FID_ClearList: {
                ::boost::shared_ptr< ClearListError > payload (new ClearListError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ClearList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ClearListCallbackIF*) _callback)->onClearListError (proxy, payload);
                return true;
            }
            case FID_SpecificSWVersionStatistic: {
                ::boost::shared_ptr< SpecificSWVersionStatisticError > payload (new SpecificSWVersionStatisticError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SpecificSWVersionStatistic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SpecificSWVersionStatisticCallbackIF*) _callback)->onSpecificSWVersionStatisticError (proxy, payload);
                return true;
            }
            case FID_RestartSystem: {
                ::boost::shared_ptr< RestartSystemError > payload (new RestartSystemError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RestartSystem", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((RestartSystemCallbackIF*) _callback)->onRestartSystemError (proxy, payload);
                return true;
            }
            case FID_AudioSourceChange: {
                ::boost::shared_ptr< AudioSourceChangeError > payload (new AudioSourceChangeError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudioSourceChange", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((AudioSourceChangeCallbackIF*) _callback)->onAudioSourceChangeError (proxy, payload);
                return true;
            }
            case FID_ChangeBluetoothState: {
                ::boost::shared_ptr< ChangeBluetoothStateError > payload (new ChangeBluetoothStateError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ChangeBluetoothState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ChangeBluetoothStateCallbackIF*) _callback)->onChangeBluetoothStateError (proxy, payload);
                return true;
            }
            case FID_ChangeAudioState: {
                ::boost::shared_ptr< ChangeAudioStateError > payload (new ChangeAudioStateError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ChangeAudioState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ChangeAudioStateCallbackIF*) _callback)->onChangeAudioStateError (proxy, payload);
                return true;
            }
            case FID_ChangeSpiState: {
                ::boost::shared_ptr< ChangeSpiStateError > payload (new ChangeSpiStateError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ChangeSpiState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ChangeSpiStateCallbackIF*) _callback)->onChangeSpiStateError (proxy, payload);
                return true;
            }
            case FID_ChangeTunerState: {
                ::boost::shared_ptr< ChangeTunerStateError > payload (new ChangeTunerStateError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ChangeTunerState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ChangeTunerStateCallbackIF*) _callback)->onChangeTunerStateError (proxy, payload);
                return true;
            }
            case FID_ChangeWifiState: {
                ::boost::shared_ptr< ChangeWifiStateError > payload (new ChangeWifiStateError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ChangeWifiState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ChangeWifiStateCallbackIF*) _callback)->onChangeWifiStateError (proxy, payload);
                return true;
            }
            case FID_ShutdownAndTerminateCcaApps: {
                ::boost::shared_ptr< ShutdownAndTerminateCcaAppsError > payload (new ShutdownAndTerminateCcaAppsError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ShutdownAndTerminateCcaApps", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ShutdownAndTerminateCcaAppsCallbackIF*) _callback)->onShutdownAndTerminateCcaAppsError (proxy, payload);
                return true;
            }
            case FID_SetFactorySettingsNew: {
                ::boost::shared_ptr< SetFactorySettingsNewError > payload (new SetFactorySettingsNewError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetFactorySettingsNew", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetFactorySettingsNewCallbackIF*) _callback)->onSetFactorySettingsNewError (proxy, payload);
                return true;
            }
            case FID_ClearVIN: {
                ::boost::shared_ptr< ClearVINError > payload (new ClearVINError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ClearVIN", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ClearVINCallbackIF*) _callback)->onClearVINError (proxy, payload);
                return true;
            }
            case FID_PrepareDownload: {
                ::boost::shared_ptr< PrepareDownloadError > payload (new PrepareDownloadError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PrepareDownload", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((PrepareDownloadCallbackIF*) _callback)->onPrepareDownloadError (proxy, payload);
                return true;
            }
            case FID_EndDownload: {
                ::boost::shared_ptr< EndDownloadError > payload (new EndDownloadError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EndDownload", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((EndDownloadCallbackIF*) _callback)->onEndDownloadError (proxy, payload);
                return true;
            }
            case FID_SetOnConfiguration: {
                ::boost::shared_ptr< SetOnConfigurationError > payload (new SetOnConfigurationError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetOnConfiguration", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetOnConfigurationCallbackIF*) _callback)->onSetOnConfigurationError (proxy, payload);
                return true;
            }
            case FID_SetProcessConfiguration: {
                ::boost::shared_ptr< SetProcessConfigurationError > payload (new SetProcessConfigurationError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetProcessConfiguration", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetProcessConfigurationCallbackIF*) _callback)->onSetProcessConfigurationError (proxy, payload);
                return true;
            }
            case FID_EntertainDeMute: {
                ::boost::shared_ptr< EntertainDeMuteError > payload (new EntertainDeMuteError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EntertainDeMute", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((EntertainDeMuteCallbackIF*) _callback)->onEntertainDeMuteError (proxy, payload);
                return true;
            }
            case FID_EntertainMuteRequest: {
                ::boost::shared_ptr< EntertainMuteRequestError > payload (new EntertainMuteRequestError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EntertainMuteRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((EntertainMuteRequestCallbackIF*) _callback)->onEntertainMuteRequestError (proxy, payload);
                return true;
            }
            case FID_WelcomeAudioActivation: {
                ::boost::shared_ptr< WelcomeAudioActivationError > payload (new WelcomeAudioActivationError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "WelcomeAudioActivation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((WelcomeAudioActivationCallbackIF*) _callback)->onWelcomeAudioActivationError (proxy, payload);
                return true;
            }
            case FID_SystemState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SystemStateError > payload (new SystemStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SystemState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SystemStateCallbackIF*) _callback)->onSystemStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DownloadLockStates: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< DownloadLockStatesError > payload (new DownloadLockStatesError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DownloadLockStates", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DownloadLockStatesCallbackIF*) _callback)->onDownloadLockStatesError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_UpdateLockStates: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< UpdateLockStatesError > payload (new UpdateLockStatesError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UpdateLockStates", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((UpdateLockStatesCallbackIF*) _callback)->onUpdateLockStatesError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ActiveOnOffTrigger: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< ActiveOnOffTriggerError > payload (new ActiveOnOffTriggerError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ActiveOnOffTrigger", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ActiveOnOffTriggerCallbackIF*) _callback)->onActiveOnOffTriggerError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SubStates: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SubStatesError > payload (new SubStatesError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SubStates", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SubStatesCallbackIF*) _callback)->onSubStatesError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_HistoryTrigger: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< HistoryTriggerError > payload (new HistoryTriggerError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "HistoryTrigger", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((HistoryTriggerCallbackIF*) _callback)->onHistoryTriggerError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_InsertState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< InsertStateError > payload (new InsertStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "InsertState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((InsertStateCallbackIF*) _callback)->onInsertStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_MediaEjectState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< MediaEjectStateError > payload (new MediaEjectStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MediaEjectState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((MediaEjectStateCallbackIF*) _callback)->onMediaEjectStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_PhoneMuteState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< PhoneMuteStateError > payload (new PhoneMuteStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PhoneMuteState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((PhoneMuteStateCallbackIF*) _callback)->onPhoneMuteStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_OnTipperState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< OnTipperStateError > payload (new OnTipperStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "OnTipperState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((OnTipperStateCallbackIF*) _callback)->onOnTipperStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_IgnitionCycles: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< IgnitionCyclesError > payload (new IgnitionCyclesError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "IgnitionCycles", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((IgnitionCyclesCallbackIF*) _callback)->onIgnitionCyclesError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SysPwrMode: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SysPwrModeError > payload (new SysPwrModeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SysPwrMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SysPwrModeCallbackIF*) _callback)->onSysPwrModeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SysPwrSaveMode: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SysPwrSaveModeError > payload (new SysPwrSaveModeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SysPwrSaveMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SysPwrSaveModeCallbackIF*) _callback)->onSysPwrSaveModeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_MapDownloadLockState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< MapDownloadLockStateError > payload (new MapDownloadLockStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MapDownloadLockState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((MapDownloadLockStateCallbackIF*) _callback)->onMapDownloadLockStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_StandbyTime: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< StandbyTimeError > payload (new StandbyTimeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StandbyTime", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((StandbyTimeCallbackIF*) _callback)->onStandbyTimeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_PersitentStandbyTime: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< PersitentStandbyTimeError > payload (new PersitentStandbyTimeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PersitentStandbyTime", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((PersitentStandbyTimeCallbackIF*) _callback)->onPersitentStandbyTimeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_IgnitionOffTime: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< IgnitionOffTimeError > payload (new IgnitionOffTimeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "IgnitionOffTime", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((IgnitionOffTimeCallbackIF*) _callback)->onIgnitionOffTimeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DoorOpenTime: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< DoorOpenTimeError > payload (new DoorOpenTimeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoorOpenTime", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DoorOpenTimeCallbackIF*) _callback)->onDoorOpenTimeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ClockDisplayTime: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< ClockDisplayTimeError > payload (new ClockDisplayTimeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ClockDisplayTime", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ClockDisplayTimeCallbackIF*) _callback)->onClockDisplayTimeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SystemStateTime: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SystemStateTimeError > payload (new SystemStateTimeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SystemStateTime", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SystemStateTimeCallbackIF*) _callback)->onSystemStateTimeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ProcessList: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< ProcessListError > payload (new ProcessListError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ProcessList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ProcessListCallbackIF*) _callback)->onProcessListError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_WakeupReason: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< WakeupReasonError > payload (new WakeupReasonError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "WakeupReason", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((WakeupReasonCallbackIF*) _callback)->onWakeupReasonError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_StartupReason: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< StartupReasonError > payload (new StartupReasonError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartupReason", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((StartupReasonCallbackIF*) _callback)->onStartupReasonError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ConnectToBattery: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< ConnectToBatteryError > payload (new ConnectToBatteryError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ConnectToBattery", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ConnectToBatteryCallbackIF*) _callback)->onConnectToBatteryError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_CodeRequestState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< CodeRequestStateError > payload (new CodeRequestStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CodeRequestState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((CodeRequestStateCallbackIF*) _callback)->onCodeRequestStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ActiveStartUpSyncPoints: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< ActiveStartUpSyncPointsError > payload (new ActiveStartUpSyncPointsError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ActiveStartUpSyncPoints", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ActiveStartUpSyncPointsCallbackIF*) _callback)->onActiveStartUpSyncPointsError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_CvmEvent: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< CvmEventError > payload (new CvmEventError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CvmEvent", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((CvmEventCallbackIF*) _callback)->onCvmEventError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_UBatSense: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< UBatSenseError > payload (new UBatSenseError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UBatSense", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((UBatSenseCallbackIF*) _callback)->onUBatSenseError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_CoproState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< CoproStateError > payload (new CoproStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CoproState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((CoproStateCallbackIF*) _callback)->onCoproStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DevicePowerOnTime: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< DevicePowerOnTimeError > payload (new DevicePowerOnTimeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DevicePowerOnTime", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DevicePowerOnTimeCallbackIF*) _callback)->onDevicePowerOnTimeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_LastSystemRuntime: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< LastSystemRuntimeError > payload (new LastSystemRuntimeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "LastSystemRuntime", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((LastSystemRuntimeCallbackIF*) _callback)->onLastSystemRuntimeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_CurrentSystemRuntime: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< CurrentSystemRuntimeError > payload (new CurrentSystemRuntimeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CurrentSystemRuntime", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((CurrentSystemRuntimeCallbackIF*) _callback)->onCurrentSystemRuntimeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ResetList: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< ResetListError > payload (new ResetListError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ResetList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ResetListCallbackIF*) _callback)->onResetListError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ResetCounter: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< ResetCounterError > payload (new ResetCounterError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ResetCounter", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ResetCounterCallbackIF*) _callback)->onResetCounterError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_TransportModeList: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< TransportModeListError > payload (new TransportModeListError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "TransportModeList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((TransportModeListCallbackIF*) _callback)->onTransportModeListError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ResetHistory: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< ResetHistoryError > payload (new ResetHistoryError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ResetHistory", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ResetHistoryCallbackIF*) _callback)->onResetHistoryError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_WakeupHistory: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< WakeupHistoryError > payload (new WakeupHistoryError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "WakeupHistory", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((WakeupHistoryCallbackIF*) _callback)->onWakeupHistoryError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_StateHistory: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< StateHistoryError > payload (new StateHistoryError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StateHistory", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((StateHistoryCallbackIF*) _callback)->onStateHistoryError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ErrStateHistory01: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< ErrStateHistory01Error > payload (new ErrStateHistory01Error());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ErrStateHistory01", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ErrStateHistory01CallbackIF*) _callback)->onErrStateHistory01Error (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ErrStateHistory02: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< ErrStateHistory02Error > payload (new ErrStateHistory02Error());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ErrStateHistory02", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ErrStateHistory02CallbackIF*) _callback)->onErrStateHistory02Error (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ErrStateHistory03: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< ErrStateHistory03Error > payload (new ErrStateHistory03Error());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ErrStateHistory03", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ErrStateHistory03CallbackIF*) _callback)->onErrStateHistory03Error (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ErrStateHistory04: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< ErrStateHistory04Error > payload (new ErrStateHistory04Error());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ErrStateHistory04", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ErrStateHistory04CallbackIF*) _callback)->onErrStateHistory04Error (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ErrStateHistory05: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< ErrStateHistory05Error > payload (new ErrStateHistory05Error());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ErrStateHistory05", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ErrStateHistory05CallbackIF*) _callback)->onErrStateHistory05Error (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SwitchOnHistory: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SwitchOnHistoryError > payload (new SwitchOnHistoryError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SwitchOnHistory", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SwitchOnHistoryCallbackIF*) _callback)->onSwitchOnHistoryError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DeviceOnCounter: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< DeviceOnCounterError > payload (new DeviceOnCounterError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DeviceOnCounter", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DeviceOnCounterCallbackIF*) _callback)->onDeviceOnCounterError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_VoltageEventCounter: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< VoltageEventCounterError > payload (new VoltageEventCounterError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "VoltageEventCounter", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((VoltageEventCounterCallbackIF*) _callback)->onVoltageEventCounterError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_VoltageRangeHistogram: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< VoltageRangeHistogramError > payload (new VoltageRangeHistogramError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "VoltageRangeHistogram", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((VoltageRangeHistogramCallbackIF*) _callback)->onVoltageRangeHistogramError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_CpuUsageStatistic: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< CpuUsageStatisticError > payload (new CpuUsageStatisticError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CpuUsageStatistic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((CpuUsageStatisticCallbackIF*) _callback)->onCpuUsageStatisticError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_RamUsageStatistic: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< RamUsageStatisticError > payload (new RamUsageStatisticError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RamUsageStatistic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((RamUsageStatisticCallbackIF*) _callback)->onRamUsageStatisticError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_StartupTimeStatistic: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< StartupTimeStatisticError > payload (new StartupTimeStatisticError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartupTimeStatistic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((StartupTimeStatisticCallbackIF*) _callback)->onStartupTimeStatisticError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SWVersionStatistic: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SWVersionStatisticError > payload (new SWVersionStatisticError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SWVersionStatistic", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SWVersionStatisticCallbackIF*) _callback)->onSWVersionStatisticError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_RunlevelState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< RunlevelStateError > payload (new RunlevelStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RunlevelState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((RunlevelStateCallbackIF*) _callback)->onRunlevelStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Restart: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< RestartError > payload (new RestartError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Restart", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((RestartCallbackIF*) _callback)->onRestartError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Lifesign: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< LifesignError > payload (new LifesignError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Lifesign", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((LifesignCallbackIF*) _callback)->onLifesignError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_HmiState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< HmiStateError > payload (new HmiStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "HmiState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((HmiStateCallbackIF*) _callback)->onHmiStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SystemPowerBehaviour: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SystemPowerBehaviourError > payload (new SystemPowerBehaviourError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SystemPowerBehaviour", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SystemPowerBehaviourCallbackIF*) _callback)->onSystemPowerBehaviourError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DimState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< DimStateError > payload (new DimStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DimState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DimStateCallbackIF*) _callback)->onDimStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DimmingState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< DimmingStateError > payload (new DimmingStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DimmingState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DimmingStateCallbackIF*) _callback)->onDimmingStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_BluetoothState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< BluetoothStateError > payload (new BluetoothStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BluetoothState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((BluetoothStateCallbackIF*) _callback)->onBluetoothStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AudioState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< AudioStateError > payload (new AudioStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudioState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AudioStateCallbackIF*) _callback)->onAudioStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SpiState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SpiStateError > payload (new SpiStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SpiState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SpiStateCallbackIF*) _callback)->onSpiStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_TunerState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< TunerStateError > payload (new TunerStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "TunerState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((TunerStateCallbackIF*) _callback)->onTunerStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_WifiState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< WifiStateError > payload (new WifiStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "WifiState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((WifiStateCallbackIF*) _callback)->onWifiStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_OnOffReason: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< OnOffReasonError > payload (new OnOffReasonError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "OnOffReason", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((OnOffReasonCallbackIF*) _callback)->onOnOffReasonError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_WakeupList: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< WakeupListError > payload (new WakeupListError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "WakeupList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((WakeupListCallbackIF*) _callback)->onWakeupListError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_StartupFinished: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< StartupFinishedError > payload (new StartupFinishedError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartupFinished", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((StartupFinishedCallbackIF*) _callback)->onStartupFinishedError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SysState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SysStateError > payload (new SysStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SysState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SysStateCallbackIF*) _callback)->onSysStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_MostState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< MostStateError > payload (new MostStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MostState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((MostStateCallbackIF*) _callback)->onMostStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_MostVersion: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< MostVersionError > payload (new MostVersionError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MostVersion", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((MostVersionCallbackIF*) _callback)->onMostVersionError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_RVCState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< RVCStateError > payload (new RVCStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RVCState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((RVCStateCallbackIF*) _callback)->onRVCStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_TriggerMostRemoteReset: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< TriggerMostRemoteResetError > payload (new TriggerMostRemoteResetError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "TriggerMostRemoteReset", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((TriggerMostRemoteResetCallbackIF*) _callback)->onTriggerMostRemoteResetError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Partnumber: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< PartnumberError > payload (new PartnumberError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Partnumber", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((PartnumberCallbackIF*) _callback)->onPartnumberError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Partnumbers: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< PartnumbersError > payload (new PartnumbersError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Partnumbers", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((PartnumbersCallbackIF*) _callback)->onPartnumbersError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Alphacode: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< AlphacodeError > payload (new AlphacodeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Alphacode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AlphacodeCallbackIF*) _callback)->onAlphacodeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Alphacodes: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< AlphacodesError > payload (new AlphacodesError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Alphacodes", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AlphacodesCallbackIF*) _callback)->onAlphacodesError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ManufacturersEnableCounter: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< ManufacturersEnableCounterError > payload (new ManufacturersEnableCounterError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ManufacturersEnableCounter", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ManufacturersEnableCounterCallbackIF*) _callback)->onManufacturersEnableCounterError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_NoCalibrationState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< NoCalibrationStateError > payload (new NoCalibrationStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "NoCalibrationState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((NoCalibrationStateCallbackIF*) _callback)->onNoCalibrationStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SecurityCommError: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SecurityCommErrorError > payload (new SecurityCommErrorError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SecurityCommError", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SecurityCommErrorCallbackIF*) _callback)->onSecurityCommErrorError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SecurityMoreThan10Vin: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SecurityMoreThan10VinError > payload (new SecurityMoreThan10VinError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SecurityMoreThan10Vin", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SecurityMoreThan10VinCallbackIF*) _callback)->onSecurityMoreThan10VinError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SecurityInvalidVin: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SecurityInvalidVinError > payload (new SecurityInvalidVinError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SecurityInvalidVin", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SecurityInvalidVinCallbackIF*) _callback)->onSecurityInvalidVinError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SecurityCurrentVin: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SecurityCurrentVinError > payload (new SecurityCurrentVinError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SecurityCurrentVin", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SecurityCurrentVinCallbackIF*) _callback)->onSecurityCurrentVinError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SecurityVinHistory: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SecurityVinHistoryError > payload (new SecurityVinHistoryError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SecurityVinHistory", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SecurityVinHistoryCallbackIF*) _callback)->onSecurityVinHistoryError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_VIN: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< VINError > payload (new VINError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "VIN", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((VINCallbackIF*) _callback)->onVINError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SecurityState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< SecurityStateError > payload (new SecurityStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SecurityState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SecurityStateCallbackIF*) _callback)->onSecurityStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_VehicleID: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< VehicleIDError > payload (new VehicleIDError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "VehicleID", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((VehicleIDCallbackIF*) _callback)->onVehicleIDError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DisplayVariant: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< DisplayVariantError > payload (new DisplayVariantError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DisplayVariant", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DisplayVariantCallbackIF*) _callback)->onDisplayVariantError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ReductionLevel: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< ReductionLevelError > payload (new ReductionLevelError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReductionLevel", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ReductionLevelCallbackIF*) _callback)->onReductionLevelError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_StartupState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< StartupStateError > payload (new StartupStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartupState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((StartupStateCallbackIF*) _callback)->onStartupStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_EntertainMute: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< EntertainMuteError > payload (new EntertainMuteError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EntertainMute", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((EntertainMuteCallbackIF*) _callback)->onEntertainMuteError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_WelcomeAudioState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< WelcomeAudioStateError > payload (new WelcomeAudioStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "WelcomeAudioState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((WelcomeAudioStateCallbackIF*) _callback)->onWelcomeAudioStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_UnballastTimeFromEngineStopped: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< UnballastTimeFromEngineStoppedError > payload (new UnballastTimeFromEngineStoppedError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnballastTimeFromEngineStopped", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((UnballastTimeFromEngineStoppedCallbackIF*) _callback)->onUnballastTimeFromEngineStoppedError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_UnballastTimeBeforeUnballast: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< UnballastTimeBeforeUnballastError > payload (new UnballastTimeBeforeUnballastError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnballastTimeBeforeUnballast", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((UnballastTimeBeforeUnballastCallbackIF*) _callback)->onUnballastTimeBeforeUnballastError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_UnballastWarningTime: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< UnballastWarningTimeError > payload (new UnballastWarningTimeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnballastWarningTime", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((UnballastWarningTimeCallbackIF*) _callback)->onUnballastWarningTimeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DegradedCount: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< DegradedCountError > payload (new DegradedCountError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DegradedCount", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DegradedCountCallbackIF*) _callback)->onDegradedCountError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DegradedTime: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< DegradedTimeError > payload (new DegradedTimeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DegradedTime", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DegradedTimeCallbackIF*) _callback)->onDegradedTimeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_PhoneHandoverWarnTime: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< PhoneHandoverWarnTimeError > payload (new PhoneHandoverWarnTimeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PhoneHandoverWarnTime", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((PhoneHandoverWarnTimeCallbackIF*) _callback)->onPhoneHandoverWarnTimeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& SPM_CORE_FIProxyCallback::_logger (SPM_CORE_FIProxy::_logger);

/*static*/ ::boost::shared_ptr< SPM_CORE_FIProxy > SPM_CORE_FIProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< SPM_CORE_FIProxy >  proxyNew(new SPM_CORE_FIProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< SPM_CORE_FIProxy > SPM_CORE_FIProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< SPM_CORE_FIProxy >  proxyNew(new SPM_CORE_FIProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< SPM_CORE_FIProxy > SPM_CORE_FIProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<SPM_CORE_FIProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< SPM_CORE_FIProxy >  proxyNew(new SPM_CORE_FIProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

SPM_CORE_FIProxy::SPM_CORE_FIProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

SPM_CORE_FIProxy::~SPM_CORE_FIProxy()
{
    LOG_INFO ("Entering ~SPM_CORE_FIProxy");
    sendRelUpRegAll ();
}

act_t SPM_CORE_FIProxy::sendSystemModeStart(SystemModeCallbackIF& cb, ::spm_core_fi_types::T_e8_StateModes eSystemMode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SystemMode);
        ::boost::shared_ptr< SystemModeStart > payload (new SystemModeStart());
        payload->setESystemMode(eSystemMode);
        CCA_MESSAGE(ccaMessage,header,SystemModeStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SystemMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SystemMode);
        ::boost::shared_ptr< SystemModeError > payload (new SystemModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SystemModeError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SystemMode", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendDownloadLockStateStart(DownloadLockStateCallbackIF& cb, const ::std::string& strRestrictedDlState, ::spm_core_fi_types::T_e8_DownloadLockStates eRestrictedDlMode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_DownloadLockState);
        ::boost::shared_ptr< DownloadLockStateStart > payload (new DownloadLockStateStart());
        payload->setStrRestrictedDlState(strRestrictedDlState);
        payload->setERestrictedDlMode(eRestrictedDlMode);
        CCA_MESSAGE(ccaMessage,header,DownloadLockStateStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "DownloadLockState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DownloadLockState);
        ::boost::shared_ptr< DownloadLockStateError > payload (new DownloadLockStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DownloadLockStateError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "DownloadLockState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendUpdateLockStart(UpdateLockCallbackIF& cb, const ::std::string& strLockName, ::spm_core_fi_types::T_e8_UpdateLockCommand eLockRequest) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_UpdateLock);
        ::boost::shared_ptr< UpdateLockStart > payload (new UpdateLockStart());
        payload->setStrLockName(strLockName);
        payload->setELockRequest(eLockRequest);
        CCA_MESSAGE(ccaMessage,header,UpdateLockStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "UpdateLock", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_UpdateLock);
        ::boost::shared_ptr< UpdateLockError > payload (new UpdateLockError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,UpdateLockError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "UpdateLock", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendOnOffTriggerStart(OnOffTriggerCallbackIF& cb, ::spm_core_fi_types::T_SPM_e32_SubStateType eSwitchOnTrigger, bool bState) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_OnOffTrigger);
        ::boost::shared_ptr< OnOffTriggerStart > payload (new OnOffTriggerStart());
        payload->setESwitchOnTrigger(eSwitchOnTrigger);
        payload->setBState(bState);
        CCA_MESSAGE(ccaMessage,header,OnOffTriggerStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "OnOffTrigger", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_OnOffTrigger);
        ::boost::shared_ptr< OnOffTriggerError > payload (new OnOffTriggerError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,OnOffTriggerError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "OnOffTrigger", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendStartProcessStart(StartProcessCallbackIF& cb, const ::std::string& strLocation, uint32 u32Prio, uint32 u32Affinity, uint32 u32AffinityEnd, uint32 u32NiceLevel, uint32 u32NiceLevelEnd, ::spm_core_fi_types::T_SPM_e32_START_PROC_TYPE u32Type, uint32 u32Info) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_StartProcess);
        ::boost::shared_ptr< StartProcessStart > payload (new StartProcessStart());
        payload->setStrLocation(strLocation);
        payload->setU32Prio(u32Prio);
        payload->setU32Affinity(u32Affinity);
        payload->setU32AffinityEnd(u32AffinityEnd);
        payload->setU32NiceLevel(u32NiceLevel);
        payload->setU32NiceLevelEnd(u32NiceLevelEnd);
        payload->setU32Type(u32Type);
        payload->setU32Info(u32Info);
        CCA_MESSAGE(ccaMessage,header,StartProcessStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "StartProcess", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StartProcess);
        ::boost::shared_ptr< StartProcessError > payload (new StartProcessError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StartProcessError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "StartProcess", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendStopProcessStart(StopProcessCallbackIF& cb, const ::std::string& strLocation, uint32 u32ProcId) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_StopProcess);
        ::boost::shared_ptr< StopProcessStart > payload (new StopProcessStart());
        payload->setStrLocation(strLocation);
        payload->setU32ProcId(u32ProcId);
        CCA_MESSAGE(ccaMessage,header,StopProcessStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "StopProcess", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StopProcess);
        ::boost::shared_ptr< StopProcessError > payload (new StopProcessError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StopProcessError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "StopProcess", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendRestartProcessStart(RestartProcessCallbackIF& cb, const ::std::string& strLocation, uint32 u32ProcId) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_RestartProcess);
        ::boost::shared_ptr< RestartProcessStart > payload (new RestartProcessStart());
        payload->setStrLocation(strLocation);
        payload->setU32ProcId(u32ProcId);
        CCA_MESSAGE(ccaMessage,header,RestartProcessStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "RestartProcess", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RestartProcess);
        ::boost::shared_ptr< RestartProcessError > payload (new RestartProcessError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RestartProcessError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "RestartProcess", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendStartUpSyncPointReachedStart(StartUpSyncPointReachedCallbackIF& cb, const ::std::string& strNewSyncPoint) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_StartUpSyncPointReached);
        ::boost::shared_ptr< StartUpSyncPointReachedStart > payload (new StartUpSyncPointReachedStart());
        payload->setStrNewSyncPoint(strNewSyncPoint);
        CCA_MESSAGE(ccaMessage,header,StartUpSyncPointReachedStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "StartUpSyncPointReached", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StartUpSyncPointReached);
        ::boost::shared_ptr< StartUpSyncPointReachedError > payload (new StartUpSyncPointReachedError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StartUpSyncPointReachedError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "StartUpSyncPointReached", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendClearListStart(ClearListCallbackIF& cb, ::spm_core_fi_types::T_SPM_e32_CLEAR_LIST eList2Clear) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ClearList);
        ::boost::shared_ptr< ClearListStart > payload (new ClearListStart());
        payload->setEList2Clear(eList2Clear);
        CCA_MESSAGE(ccaMessage,header,ClearListStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ClearList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ClearList);
        ::boost::shared_ptr< ClearListError > payload (new ClearListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ClearListError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ClearList", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendSpecificSWVersionStatisticStart(SpecificSWVersionStatisticCallbackIF& cb, uint32 u32Index) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SpecificSWVersionStatistic);
        ::boost::shared_ptr< SpecificSWVersionStatisticStart > payload (new SpecificSWVersionStatisticStart());
        payload->setU32Index(u32Index);
        CCA_MESSAGE(ccaMessage,header,SpecificSWVersionStatisticStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SpecificSWVersionStatistic", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SpecificSWVersionStatistic);
        ::boost::shared_ptr< SpecificSWVersionStatisticError > payload (new SpecificSWVersionStatisticError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SpecificSWVersionStatisticError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SpecificSWVersionStatistic", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendRestartSystemStart(RestartSystemCallbackIF& cb, ::spm_core_fi_types::T_SPM_e32_RESTART_TYPE eRestartType) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_RestartSystem);
        ::boost::shared_ptr< RestartSystemStart > payload (new RestartSystemStart());
        payload->setERestartType(eRestartType);
        CCA_MESSAGE(ccaMessage,header,RestartSystemStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "RestartSystem", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RestartSystem);
        ::boost::shared_ptr< RestartSystemError > payload (new RestartSystemError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RestartSystemError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "RestartSystem", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendAudioSourceChangeStart(AudioSourceChangeCallbackIF& cb, ::spm_core_fi_types::T_SPM_e32_AUDIO_SOURCE eAudioSrc) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_AudioSourceChange);
        ::boost::shared_ptr< AudioSourceChangeStart > payload (new AudioSourceChangeStart());
        payload->setEAudioSrc(eAudioSrc);
        CCA_MESSAGE(ccaMessage,header,AudioSourceChangeStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "AudioSourceChange", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AudioSourceChange);
        ::boost::shared_ptr< AudioSourceChangeError > payload (new AudioSourceChangeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AudioSourceChangeError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "AudioSourceChange", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendChangeBluetoothStateStart(ChangeBluetoothStateCallbackIF& cb, ::spm_core_fi_types::T_SPM_e32_BT_STATE btState) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ChangeBluetoothState);
        ::boost::shared_ptr< ChangeBluetoothStateStart > payload (new ChangeBluetoothStateStart());
        payload->setBtState(btState);
        CCA_MESSAGE(ccaMessage,header,ChangeBluetoothStateStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ChangeBluetoothState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ChangeBluetoothState);
        ::boost::shared_ptr< ChangeBluetoothStateError > payload (new ChangeBluetoothStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ChangeBluetoothStateError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ChangeBluetoothState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendChangeAudioStateStart(ChangeAudioStateCallbackIF& cb, ::spm_core_fi_types::T_SPM_e32_AUDIO_STATE audioState) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ChangeAudioState);
        ::boost::shared_ptr< ChangeAudioStateStart > payload (new ChangeAudioStateStart());
        payload->setAudioState(audioState);
        CCA_MESSAGE(ccaMessage,header,ChangeAudioStateStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ChangeAudioState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ChangeAudioState);
        ::boost::shared_ptr< ChangeAudioStateError > payload (new ChangeAudioStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ChangeAudioStateError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ChangeAudioState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendChangeSpiStateStart(ChangeSpiStateCallbackIF& cb, ::spm_core_fi_types::T_SPM_e32_SPI_STATE spiState) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ChangeSpiState);
        ::boost::shared_ptr< ChangeSpiStateStart > payload (new ChangeSpiStateStart());
        payload->setSpiState(spiState);
        CCA_MESSAGE(ccaMessage,header,ChangeSpiStateStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ChangeSpiState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ChangeSpiState);
        ::boost::shared_ptr< ChangeSpiStateError > payload (new ChangeSpiStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ChangeSpiStateError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ChangeSpiState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendChangeTunerStateStart(ChangeTunerStateCallbackIF& cb, ::spm_core_fi_types::T_SPM_e32_TUNER_STATE tunerState) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ChangeTunerState);
        ::boost::shared_ptr< ChangeTunerStateStart > payload (new ChangeTunerStateStart());
        payload->setTunerState(tunerState);
        CCA_MESSAGE(ccaMessage,header,ChangeTunerStateStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ChangeTunerState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ChangeTunerState);
        ::boost::shared_ptr< ChangeTunerStateError > payload (new ChangeTunerStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ChangeTunerStateError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ChangeTunerState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendChangeWifiStateStart(ChangeWifiStateCallbackIF& cb, ::spm_core_fi_types::T_SPM_e32_WIFI_STATE wiFiState) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ChangeWifiState);
        ::boost::shared_ptr< ChangeWifiStateStart > payload (new ChangeWifiStateStart());
        payload->setWiFiState(wiFiState);
        CCA_MESSAGE(ccaMessage,header,ChangeWifiStateStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ChangeWifiState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ChangeWifiState);
        ::boost::shared_ptr< ChangeWifiStateError > payload (new ChangeWifiStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ChangeWifiStateError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ChangeWifiState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendShutdownAndTerminateCcaAppsStart(ShutdownAndTerminateCcaAppsCallbackIF& cb, const ::spm_core_fi_types::T_SPM_AppIdList& tAppIdList) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ShutdownAndTerminateCcaApps);
        ::boost::shared_ptr< ShutdownAndTerminateCcaAppsStart > payload (new ShutdownAndTerminateCcaAppsStart());
        payload->setTAppIdList(tAppIdList);
        CCA_MESSAGE(ccaMessage,header,ShutdownAndTerminateCcaAppsStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ShutdownAndTerminateCcaApps", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ShutdownAndTerminateCcaApps);
        ::boost::shared_ptr< ShutdownAndTerminateCcaAppsError > payload (new ShutdownAndTerminateCcaAppsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ShutdownAndTerminateCcaAppsError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ShutdownAndTerminateCcaApps", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendSetFactorySettingsNewStart(SetFactorySettingsNewCallbackIF& cb, ::spm_diag_defset_fi_types::T_e8_DiaglogDefsetType defSetStateGroup, ::spm_diag_defset_fi_types::T_e8_DefSetMode defSetStateMode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetFactorySettingsNew);
        ::boost::shared_ptr< SetFactorySettingsNewStart > payload (new SetFactorySettingsNewStart());
        payload->setDefSetStateGroup(defSetStateGroup);
        payload->setDefSetStateMode(defSetStateMode);
        CCA_MESSAGE(ccaMessage,header,SetFactorySettingsNewStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetFactorySettingsNew", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetFactorySettingsNew);
        ::boost::shared_ptr< SetFactorySettingsNewError > payload (new SetFactorySettingsNewError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetFactorySettingsNewError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetFactorySettingsNew", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendClearVINStart(ClearVINCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ClearVIN);
        ::boost::shared_ptr< ClearVINStart > payload (new ClearVINStart());
        CCA_MESSAGE(ccaMessage,header,ClearVINStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ClearVIN", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ClearVIN);
        ::boost::shared_ptr< ClearVINError > payload (new ClearVINError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ClearVINError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ClearVIN", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendPrepareDownloadStart(PrepareDownloadCallbackIF& cb, uint32 configuration, bool suspendBusShutdown, uint32 timeout) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_PrepareDownload);
        ::boost::shared_ptr< PrepareDownloadStart > payload (new PrepareDownloadStart());
        payload->setConfiguration(configuration);
        payload->setSuspendBusShutdown(suspendBusShutdown);
        payload->setTimeout(timeout);
        CCA_MESSAGE(ccaMessage,header,PrepareDownloadStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "PrepareDownload", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PrepareDownload);
        ::boost::shared_ptr< PrepareDownloadError > payload (new PrepareDownloadError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PrepareDownloadError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "PrepareDownload", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendEndDownloadStart(EndDownloadCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_EndDownload);
        ::boost::shared_ptr< EndDownloadStart > payload (new EndDownloadStart());
        CCA_MESSAGE(ccaMessage,header,EndDownloadStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "EndDownload", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_EndDownload);
        ::boost::shared_ptr< EndDownloadError > payload (new EndDownloadError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,EndDownloadError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "EndDownload", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendSetOnConfigurationStart(SetOnConfigurationCallbackIF& cb, uint32 configuration) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetOnConfiguration);
        ::boost::shared_ptr< SetOnConfigurationStart > payload (new SetOnConfigurationStart());
        payload->setConfiguration(configuration);
        CCA_MESSAGE(ccaMessage,header,SetOnConfigurationStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetOnConfiguration", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetOnConfiguration);
        ::boost::shared_ptr< SetOnConfigurationError > payload (new SetOnConfigurationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetOnConfigurationError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetOnConfiguration", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendSetProcessConfigurationStart(SetProcessConfigurationCallbackIF& cb, uint32 configuration) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetProcessConfiguration);
        ::boost::shared_ptr< SetProcessConfigurationStart > payload (new SetProcessConfigurationStart());
        payload->setConfiguration(configuration);
        CCA_MESSAGE(ccaMessage,header,SetProcessConfigurationStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetProcessConfiguration", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetProcessConfiguration);
        ::boost::shared_ptr< SetProcessConfigurationError > payload (new SetProcessConfigurationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetProcessConfigurationError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetProcessConfiguration", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendEntertainDeMuteStart(EntertainDeMuteCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_EntertainDeMute);
        ::boost::shared_ptr< EntertainDeMuteStart > payload (new EntertainDeMuteStart());
        CCA_MESSAGE(ccaMessage,header,EntertainDeMuteStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "EntertainDeMute", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_EntertainDeMute);
        ::boost::shared_ptr< EntertainDeMuteError > payload (new EntertainDeMuteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,EntertainDeMuteError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "EntertainDeMute", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendEntertainMuteRequestStart(EntertainMuteRequestCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_EntertainMuteRequest);
        ::boost::shared_ptr< EntertainMuteRequestStart > payload (new EntertainMuteRequestStart());
        CCA_MESSAGE(ccaMessage,header,EntertainMuteRequestStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "EntertainMuteRequest", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_EntertainMuteRequest);
        ::boost::shared_ptr< EntertainMuteRequestError > payload (new EntertainMuteRequestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,EntertainMuteRequestError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "EntertainMuteRequest", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendWelcomeAudioActivationStart(WelcomeAudioActivationCallbackIF& cb, bool bActivateState) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_WelcomeAudioActivation);
        ::boost::shared_ptr< WelcomeAudioActivationStart > payload (new WelcomeAudioActivationStart());
        payload->setBActivateState(bActivateState);
        CCA_MESSAGE(ccaMessage,header,WelcomeAudioActivationStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "WelcomeAudioActivation", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_WelcomeAudioActivation);
        ::boost::shared_ptr< WelcomeAudioActivationError > payload (new WelcomeAudioActivationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,WelcomeAudioActivationError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "WelcomeAudioActivation", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendSystemStateUpReg(SystemStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SystemState);
        ::boost::shared_ptr< SystemStateUpReg > payload (new SystemStateUpReg());
        CCA_MESSAGE(ccaMessage,header,SystemStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SystemStateRelUpReg > payloadRelUpRegHeap (new SystemStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SystemState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::SystemStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SystemState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SystemState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SystemState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSystemState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SystemState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SystemStateStatus > payloadLoopback (new SystemStateStatus(getSystemState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SystemStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SystemState);
        ::boost::shared_ptr< SystemStateError > payload (new SystemStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SystemStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SystemState", &cb);
    }
}

bool SPM_CORE_FIProxy::sendSystemStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SystemState,"SystemState");
}

void SPM_CORE_FIProxy::sendSystemStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SystemState);
}

const SystemStateStatus& SPM_CORE_FIProxy::getSystemState() const {
    return _systemState.get();
}

bool SPM_CORE_FIProxy::hasSystemState() const {
    return _systemState.hasValue();
}

act_t SPM_CORE_FIProxy::sendSystemStateGet(SystemStateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SystemState);
        ::boost::shared_ptr< SystemStateGet > payload (new SystemStateGet());
        CCA_MESSAGE(ccaMessage,header,SystemStateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SystemState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SystemState);
        ::boost::shared_ptr< SystemStateError > payload (new SystemStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SystemStateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SystemState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendDownloadLockStatesUpReg(DownloadLockStatesCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DownloadLockStates);
        ::boost::shared_ptr< DownloadLockStatesUpReg > payload (new DownloadLockStatesUpReg());
        CCA_MESSAGE(ccaMessage,header,DownloadLockStatesUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DownloadLockStatesRelUpReg > payloadRelUpRegHeap (new DownloadLockStatesRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DownloadLockStates, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::DownloadLockStatesRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DownloadLockStates, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DownloadLockStates", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DownloadLockStates", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDownloadLockStates()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DownloadLockStates, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DownloadLockStatesStatus > payloadLoopback (new DownloadLockStatesStatus(getDownloadLockStates()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DownloadLockStatesStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DownloadLockStates);
        ::boost::shared_ptr< DownloadLockStatesError > payload (new DownloadLockStatesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DownloadLockStatesError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DownloadLockStates", &cb);
    }
}

bool SPM_CORE_FIProxy::sendDownloadLockStatesRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DownloadLockStates,"DownloadLockStates");
}

void SPM_CORE_FIProxy::sendDownloadLockStatesRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DownloadLockStates);
}

const DownloadLockStatesStatus& SPM_CORE_FIProxy::getDownloadLockStates() const {
    return _downloadLockStates.get();
}

bool SPM_CORE_FIProxy::hasDownloadLockStates() const {
    return _downloadLockStates.hasValue();
}

act_t SPM_CORE_FIProxy::sendDownloadLockStatesGet(DownloadLockStatesCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DownloadLockStates);
        ::boost::shared_ptr< DownloadLockStatesGet > payload (new DownloadLockStatesGet());
        CCA_MESSAGE(ccaMessage,header,DownloadLockStatesGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DownloadLockStates", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DownloadLockStates);
        ::boost::shared_ptr< DownloadLockStatesError > payload (new DownloadLockStatesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DownloadLockStatesError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DownloadLockStates", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendUpdateLockStatesUpReg(UpdateLockStatesCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_UpdateLockStates);
        ::boost::shared_ptr< UpdateLockStatesUpReg > payload (new UpdateLockStatesUpReg());
        CCA_MESSAGE(ccaMessage,header,UpdateLockStatesUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< UpdateLockStatesRelUpReg > payloadRelUpRegHeap (new UpdateLockStatesRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_UpdateLockStates, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::UpdateLockStatesRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_UpdateLockStates, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "UpdateLockStates", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "UpdateLockStates", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasUpdateLockStates()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_UpdateLockStates, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< UpdateLockStatesStatus > payloadLoopback (new UpdateLockStatesStatus(getUpdateLockStates()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,UpdateLockStatesStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_UpdateLockStates);
        ::boost::shared_ptr< UpdateLockStatesError > payload (new UpdateLockStatesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,UpdateLockStatesError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "UpdateLockStates", &cb);
    }
}

bool SPM_CORE_FIProxy::sendUpdateLockStatesRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_UpdateLockStates,"UpdateLockStates");
}

void SPM_CORE_FIProxy::sendUpdateLockStatesRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_UpdateLockStates);
}

const UpdateLockStatesStatus& SPM_CORE_FIProxy::getUpdateLockStates() const {
    return _updateLockStates.get();
}

bool SPM_CORE_FIProxy::hasUpdateLockStates() const {
    return _updateLockStates.hasValue();
}

act_t SPM_CORE_FIProxy::sendUpdateLockStatesGet(UpdateLockStatesCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_UpdateLockStates);
        ::boost::shared_ptr< UpdateLockStatesGet > payload (new UpdateLockStatesGet());
        CCA_MESSAGE(ccaMessage,header,UpdateLockStatesGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "UpdateLockStates", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_UpdateLockStates);
        ::boost::shared_ptr< UpdateLockStatesError > payload (new UpdateLockStatesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,UpdateLockStatesError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "UpdateLockStates", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendActiveOnOffTriggerUpReg(ActiveOnOffTriggerCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ActiveOnOffTrigger);
        ::boost::shared_ptr< ActiveOnOffTriggerUpReg > payload (new ActiveOnOffTriggerUpReg());
        CCA_MESSAGE(ccaMessage,header,ActiveOnOffTriggerUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ActiveOnOffTriggerRelUpReg > payloadRelUpRegHeap (new ActiveOnOffTriggerRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ActiveOnOffTrigger, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::ActiveOnOffTriggerRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ActiveOnOffTrigger, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ActiveOnOffTrigger", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ActiveOnOffTrigger", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasActiveOnOffTrigger()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ActiveOnOffTrigger, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ActiveOnOffTriggerStatus > payloadLoopback (new ActiveOnOffTriggerStatus(getActiveOnOffTrigger()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ActiveOnOffTriggerStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ActiveOnOffTrigger);
        ::boost::shared_ptr< ActiveOnOffTriggerError > payload (new ActiveOnOffTriggerError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ActiveOnOffTriggerError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ActiveOnOffTrigger", &cb);
    }
}

bool SPM_CORE_FIProxy::sendActiveOnOffTriggerRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ActiveOnOffTrigger,"ActiveOnOffTrigger");
}

void SPM_CORE_FIProxy::sendActiveOnOffTriggerRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ActiveOnOffTrigger);
}

const ActiveOnOffTriggerStatus& SPM_CORE_FIProxy::getActiveOnOffTrigger() const {
    return _activeOnOffTrigger.get();
}

bool SPM_CORE_FIProxy::hasActiveOnOffTrigger() const {
    return _activeOnOffTrigger.hasValue();
}

act_t SPM_CORE_FIProxy::sendActiveOnOffTriggerGet(ActiveOnOffTriggerCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ActiveOnOffTrigger);
        ::boost::shared_ptr< ActiveOnOffTriggerGet > payload (new ActiveOnOffTriggerGet());
        CCA_MESSAGE(ccaMessage,header,ActiveOnOffTriggerGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ActiveOnOffTrigger", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ActiveOnOffTrigger);
        ::boost::shared_ptr< ActiveOnOffTriggerError > payload (new ActiveOnOffTriggerError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ActiveOnOffTriggerError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ActiveOnOffTrigger", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendSubStatesUpReg(SubStatesCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SubStates);
        ::boost::shared_ptr< SubStatesUpReg > payload (new SubStatesUpReg());
        CCA_MESSAGE(ccaMessage,header,SubStatesUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SubStatesRelUpReg > payloadRelUpRegHeap (new SubStatesRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SubStates, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::SubStatesRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SubStates, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SubStates", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SubStates", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSubStates()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SubStates, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SubStatesStatus > payloadLoopback (new SubStatesStatus(getSubStates()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SubStatesStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SubStates);
        ::boost::shared_ptr< SubStatesError > payload (new SubStatesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SubStatesError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SubStates", &cb);
    }
}

bool SPM_CORE_FIProxy::sendSubStatesRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SubStates,"SubStates");
}

void SPM_CORE_FIProxy::sendSubStatesRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SubStates);
}

const SubStatesStatus& SPM_CORE_FIProxy::getSubStates() const {
    return _subStates.get();
}

bool SPM_CORE_FIProxy::hasSubStates() const {
    return _subStates.hasValue();
}

act_t SPM_CORE_FIProxy::sendSubStatesGet(SubStatesCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SubStates);
        ::boost::shared_ptr< SubStatesGet > payload (new SubStatesGet());
        CCA_MESSAGE(ccaMessage,header,SubStatesGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SubStates", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SubStates);
        ::boost::shared_ptr< SubStatesError > payload (new SubStatesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SubStatesError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SubStates", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendSubStatesSet(SubStatesCallbackIF& cb, ::spm_core_fi_types::T_SPM_e32_SubStateType subStateType, bool subStateData) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SubStates);
        ::boost::shared_ptr< SubStatesSet > payload (new SubStatesSet());
        payload->setSubStateType(subStateType);
        payload->setSubStateData(subStateData);
        CCA_MESSAGE(ccaMessage,header,SubStatesSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SubStates", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SubStates);
        ::boost::shared_ptr< SubStatesError > payload (new SubStatesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SubStatesError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SubStates", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendHistoryTriggerUpReg(HistoryTriggerCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_HistoryTrigger);
        ::boost::shared_ptr< HistoryTriggerUpReg > payload (new HistoryTriggerUpReg());
        CCA_MESSAGE(ccaMessage,header,HistoryTriggerUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< HistoryTriggerRelUpReg > payloadRelUpRegHeap (new HistoryTriggerRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_HistoryTrigger, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::HistoryTriggerRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_HistoryTrigger, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "HistoryTrigger", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "HistoryTrigger", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasHistoryTrigger()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_HistoryTrigger, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< HistoryTriggerStatus > payloadLoopback (new HistoryTriggerStatus(getHistoryTrigger()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,HistoryTriggerStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_HistoryTrigger);
        ::boost::shared_ptr< HistoryTriggerError > payload (new HistoryTriggerError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,HistoryTriggerError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "HistoryTrigger", &cb);
    }
}

bool SPM_CORE_FIProxy::sendHistoryTriggerRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_HistoryTrigger,"HistoryTrigger");
}

void SPM_CORE_FIProxy::sendHistoryTriggerRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_HistoryTrigger);
}

const HistoryTriggerStatus& SPM_CORE_FIProxy::getHistoryTrigger() const {
    return _historyTrigger.get();
}

bool SPM_CORE_FIProxy::hasHistoryTrigger() const {
    return _historyTrigger.hasValue();
}

act_t SPM_CORE_FIProxy::sendHistoryTriggerGet(HistoryTriggerCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_HistoryTrigger);
        ::boost::shared_ptr< HistoryTriggerGet > payload (new HistoryTriggerGet());
        CCA_MESSAGE(ccaMessage,header,HistoryTriggerGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "HistoryTrigger", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_HistoryTrigger);
        ::boost::shared_ptr< HistoryTriggerError > payload (new HistoryTriggerError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,HistoryTriggerError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "HistoryTrigger", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendInsertStateUpReg(InsertStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_InsertState);
        ::boost::shared_ptr< InsertStateUpReg > payload (new InsertStateUpReg());
        CCA_MESSAGE(ccaMessage,header,InsertStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< InsertStateRelUpReg > payloadRelUpRegHeap (new InsertStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_InsertState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::InsertStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_InsertState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "InsertState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "InsertState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasInsertState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_InsertState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< InsertStateStatus > payloadLoopback (new InsertStateStatus(getInsertState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,InsertStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_InsertState);
        ::boost::shared_ptr< InsertStateError > payload (new InsertStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,InsertStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "InsertState", &cb);
    }
}

bool SPM_CORE_FIProxy::sendInsertStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_InsertState,"InsertState");
}

void SPM_CORE_FIProxy::sendInsertStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_InsertState);
}

const InsertStateStatus& SPM_CORE_FIProxy::getInsertState() const {
    return _insertState.get();
}

bool SPM_CORE_FIProxy::hasInsertState() const {
    return _insertState.hasValue();
}

act_t SPM_CORE_FIProxy::sendInsertStateGet(InsertStateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_InsertState);
        ::boost::shared_ptr< InsertStateGet > payload (new InsertStateGet());
        CCA_MESSAGE(ccaMessage,header,InsertStateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "InsertState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_InsertState);
        ::boost::shared_ptr< InsertStateError > payload (new InsertStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,InsertStateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "InsertState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendMediaEjectStateUpReg(MediaEjectStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_MediaEjectState);
        ::boost::shared_ptr< MediaEjectStateUpReg > payload (new MediaEjectStateUpReg());
        CCA_MESSAGE(ccaMessage,header,MediaEjectStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< MediaEjectStateRelUpReg > payloadRelUpRegHeap (new MediaEjectStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_MediaEjectState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::MediaEjectStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_MediaEjectState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "MediaEjectState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "MediaEjectState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasMediaEjectState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_MediaEjectState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< MediaEjectStateStatus > payloadLoopback (new MediaEjectStateStatus(getMediaEjectState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,MediaEjectStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_MediaEjectState);
        ::boost::shared_ptr< MediaEjectStateError > payload (new MediaEjectStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,MediaEjectStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "MediaEjectState", &cb);
    }
}

bool SPM_CORE_FIProxy::sendMediaEjectStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_MediaEjectState,"MediaEjectState");
}

void SPM_CORE_FIProxy::sendMediaEjectStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_MediaEjectState);
}

const MediaEjectStateStatus& SPM_CORE_FIProxy::getMediaEjectState() const {
    return _mediaEjectState.get();
}

bool SPM_CORE_FIProxy::hasMediaEjectState() const {
    return _mediaEjectState.hasValue();
}

act_t SPM_CORE_FIProxy::sendMediaEjectStateGet(MediaEjectStateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_MediaEjectState);
        ::boost::shared_ptr< MediaEjectStateGet > payload (new MediaEjectStateGet());
        CCA_MESSAGE(ccaMessage,header,MediaEjectStateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "MediaEjectState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_MediaEjectState);
        ::boost::shared_ptr< MediaEjectStateError > payload (new MediaEjectStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,MediaEjectStateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "MediaEjectState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendPhoneMuteStateUpReg(PhoneMuteStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_PhoneMuteState);
        ::boost::shared_ptr< PhoneMuteStateUpReg > payload (new PhoneMuteStateUpReg());
        CCA_MESSAGE(ccaMessage,header,PhoneMuteStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< PhoneMuteStateRelUpReg > payloadRelUpRegHeap (new PhoneMuteStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_PhoneMuteState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::PhoneMuteStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_PhoneMuteState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "PhoneMuteState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "PhoneMuteState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasPhoneMuteState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_PhoneMuteState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< PhoneMuteStateStatus > payloadLoopback (new PhoneMuteStateStatus(getPhoneMuteState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,PhoneMuteStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PhoneMuteState);
        ::boost::shared_ptr< PhoneMuteStateError > payload (new PhoneMuteStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PhoneMuteStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "PhoneMuteState", &cb);
    }
}

bool SPM_CORE_FIProxy::sendPhoneMuteStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_PhoneMuteState,"PhoneMuteState");
}

void SPM_CORE_FIProxy::sendPhoneMuteStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_PhoneMuteState);
}

const PhoneMuteStateStatus& SPM_CORE_FIProxy::getPhoneMuteState() const {
    return _phoneMuteState.get();
}

bool SPM_CORE_FIProxy::hasPhoneMuteState() const {
    return _phoneMuteState.hasValue();
}

act_t SPM_CORE_FIProxy::sendPhoneMuteStateGet(PhoneMuteStateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_PhoneMuteState);
        ::boost::shared_ptr< PhoneMuteStateGet > payload (new PhoneMuteStateGet());
        CCA_MESSAGE(ccaMessage,header,PhoneMuteStateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "PhoneMuteState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PhoneMuteState);
        ::boost::shared_ptr< PhoneMuteStateError > payload (new PhoneMuteStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PhoneMuteStateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "PhoneMuteState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendOnTipperStateUpReg(OnTipperStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_OnTipperState);
        ::boost::shared_ptr< OnTipperStateUpReg > payload (new OnTipperStateUpReg());
        CCA_MESSAGE(ccaMessage,header,OnTipperStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< OnTipperStateRelUpReg > payloadRelUpRegHeap (new OnTipperStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_OnTipperState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::OnTipperStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_OnTipperState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "OnTipperState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "OnTipperState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasOnTipperState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_OnTipperState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< OnTipperStateStatus > payloadLoopback (new OnTipperStateStatus(getOnTipperState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,OnTipperStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_OnTipperState);
        ::boost::shared_ptr< OnTipperStateError > payload (new OnTipperStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,OnTipperStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "OnTipperState", &cb);
    }
}

bool SPM_CORE_FIProxy::sendOnTipperStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_OnTipperState,"OnTipperState");
}

void SPM_CORE_FIProxy::sendOnTipperStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_OnTipperState);
}

const OnTipperStateStatus& SPM_CORE_FIProxy::getOnTipperState() const {
    return _onTipperState.get();
}

bool SPM_CORE_FIProxy::hasOnTipperState() const {
    return _onTipperState.hasValue();
}

act_t SPM_CORE_FIProxy::sendOnTipperStateGet(OnTipperStateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_OnTipperState);
        ::boost::shared_ptr< OnTipperStateGet > payload (new OnTipperStateGet());
        CCA_MESSAGE(ccaMessage,header,OnTipperStateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "OnTipperState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_OnTipperState);
        ::boost::shared_ptr< OnTipperStateError > payload (new OnTipperStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,OnTipperStateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "OnTipperState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendIgnitionCyclesUpReg(IgnitionCyclesCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_IgnitionCycles);
        ::boost::shared_ptr< IgnitionCyclesUpReg > payload (new IgnitionCyclesUpReg());
        CCA_MESSAGE(ccaMessage,header,IgnitionCyclesUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< IgnitionCyclesRelUpReg > payloadRelUpRegHeap (new IgnitionCyclesRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_IgnitionCycles, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::IgnitionCyclesRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_IgnitionCycles, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "IgnitionCycles", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "IgnitionCycles", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasIgnitionCycles()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_IgnitionCycles, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< IgnitionCyclesStatus > payloadLoopback (new IgnitionCyclesStatus(getIgnitionCycles()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,IgnitionCyclesStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_IgnitionCycles);
        ::boost::shared_ptr< IgnitionCyclesError > payload (new IgnitionCyclesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,IgnitionCyclesError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "IgnitionCycles", &cb);
    }
}

bool SPM_CORE_FIProxy::sendIgnitionCyclesRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_IgnitionCycles,"IgnitionCycles");
}

void SPM_CORE_FIProxy::sendIgnitionCyclesRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_IgnitionCycles);
}

const IgnitionCyclesStatus& SPM_CORE_FIProxy::getIgnitionCycles() const {
    return _ignitionCycles.get();
}

bool SPM_CORE_FIProxy::hasIgnitionCycles() const {
    return _ignitionCycles.hasValue();
}

act_t SPM_CORE_FIProxy::sendIgnitionCyclesGet(IgnitionCyclesCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_IgnitionCycles);
        ::boost::shared_ptr< IgnitionCyclesGet > payload (new IgnitionCyclesGet());
        CCA_MESSAGE(ccaMessage,header,IgnitionCyclesGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "IgnitionCycles", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_IgnitionCycles);
        ::boost::shared_ptr< IgnitionCyclesError > payload (new IgnitionCyclesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,IgnitionCyclesError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "IgnitionCycles", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendSysPwrModeUpReg(SysPwrModeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SysPwrMode);
        ::boost::shared_ptr< SysPwrModeUpReg > payload (new SysPwrModeUpReg());
        CCA_MESSAGE(ccaMessage,header,SysPwrModeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SysPwrModeRelUpReg > payloadRelUpRegHeap (new SysPwrModeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SysPwrMode, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::SysPwrModeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SysPwrMode, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SysPwrMode", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SysPwrMode", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSysPwrMode()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SysPwrMode, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SysPwrModeStatus > payloadLoopback (new SysPwrModeStatus(getSysPwrMode()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SysPwrModeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SysPwrMode);
        ::boost::shared_ptr< SysPwrModeError > payload (new SysPwrModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SysPwrModeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SysPwrMode", &cb);
    }
}

bool SPM_CORE_FIProxy::sendSysPwrModeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SysPwrMode,"SysPwrMode");
}

void SPM_CORE_FIProxy::sendSysPwrModeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SysPwrMode);
}

const SysPwrModeStatus& SPM_CORE_FIProxy::getSysPwrMode() const {
    return _sysPwrMode.get();
}

bool SPM_CORE_FIProxy::hasSysPwrMode() const {
    return _sysPwrMode.hasValue();
}

act_t SPM_CORE_FIProxy::sendSysPwrModeGet(SysPwrModeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SysPwrMode);
        ::boost::shared_ptr< SysPwrModeGet > payload (new SysPwrModeGet());
        CCA_MESSAGE(ccaMessage,header,SysPwrModeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SysPwrMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SysPwrMode);
        ::boost::shared_ptr< SysPwrModeError > payload (new SysPwrModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SysPwrModeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SysPwrMode", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendSysPwrSaveModeUpReg(SysPwrSaveModeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SysPwrSaveMode);
        ::boost::shared_ptr< SysPwrSaveModeUpReg > payload (new SysPwrSaveModeUpReg());
        CCA_MESSAGE(ccaMessage,header,SysPwrSaveModeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SysPwrSaveModeRelUpReg > payloadRelUpRegHeap (new SysPwrSaveModeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SysPwrSaveMode, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::SysPwrSaveModeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SysPwrSaveMode, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SysPwrSaveMode", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SysPwrSaveMode", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSysPwrSaveMode()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SysPwrSaveMode, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SysPwrSaveModeStatus > payloadLoopback (new SysPwrSaveModeStatus(getSysPwrSaveMode()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SysPwrSaveModeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SysPwrSaveMode);
        ::boost::shared_ptr< SysPwrSaveModeError > payload (new SysPwrSaveModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SysPwrSaveModeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SysPwrSaveMode", &cb);
    }
}

bool SPM_CORE_FIProxy::sendSysPwrSaveModeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SysPwrSaveMode,"SysPwrSaveMode");
}

void SPM_CORE_FIProxy::sendSysPwrSaveModeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SysPwrSaveMode);
}

const SysPwrSaveModeStatus& SPM_CORE_FIProxy::getSysPwrSaveMode() const {
    return _sysPwrSaveMode.get();
}

bool SPM_CORE_FIProxy::hasSysPwrSaveMode() const {
    return _sysPwrSaveMode.hasValue();
}

act_t SPM_CORE_FIProxy::sendSysPwrSaveModeGet(SysPwrSaveModeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SysPwrSaveMode);
        ::boost::shared_ptr< SysPwrSaveModeGet > payload (new SysPwrSaveModeGet());
        CCA_MESSAGE(ccaMessage,header,SysPwrSaveModeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SysPwrSaveMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SysPwrSaveMode);
        ::boost::shared_ptr< SysPwrSaveModeError > payload (new SysPwrSaveModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SysPwrSaveModeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SysPwrSaveMode", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendMapDownloadLockStateUpReg(MapDownloadLockStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_MapDownloadLockState);
        ::boost::shared_ptr< MapDownloadLockStateUpReg > payload (new MapDownloadLockStateUpReg());
        CCA_MESSAGE(ccaMessage,header,MapDownloadLockStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< MapDownloadLockStateRelUpReg > payloadRelUpRegHeap (new MapDownloadLockStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_MapDownloadLockState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::MapDownloadLockStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_MapDownloadLockState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "MapDownloadLockState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "MapDownloadLockState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasMapDownloadLockState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_MapDownloadLockState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< MapDownloadLockStateStatus > payloadLoopback (new MapDownloadLockStateStatus(getMapDownloadLockState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,MapDownloadLockStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_MapDownloadLockState);
        ::boost::shared_ptr< MapDownloadLockStateError > payload (new MapDownloadLockStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,MapDownloadLockStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "MapDownloadLockState", &cb);
    }
}

bool SPM_CORE_FIProxy::sendMapDownloadLockStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_MapDownloadLockState,"MapDownloadLockState");
}

void SPM_CORE_FIProxy::sendMapDownloadLockStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_MapDownloadLockState);
}

const MapDownloadLockStateStatus& SPM_CORE_FIProxy::getMapDownloadLockState() const {
    return _mapDownloadLockState.get();
}

bool SPM_CORE_FIProxy::hasMapDownloadLockState() const {
    return _mapDownloadLockState.hasValue();
}

act_t SPM_CORE_FIProxy::sendMapDownloadLockStateGet(MapDownloadLockStateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_MapDownloadLockState);
        ::boost::shared_ptr< MapDownloadLockStateGet > payload (new MapDownloadLockStateGet());
        CCA_MESSAGE(ccaMessage,header,MapDownloadLockStateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "MapDownloadLockState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_MapDownloadLockState);
        ::boost::shared_ptr< MapDownloadLockStateError > payload (new MapDownloadLockStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,MapDownloadLockStateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "MapDownloadLockState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendStandbyTimeUpReg(StandbyTimeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_StandbyTime);
        ::boost::shared_ptr< StandbyTimeUpReg > payload (new StandbyTimeUpReg());
        CCA_MESSAGE(ccaMessage,header,StandbyTimeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< StandbyTimeRelUpReg > payloadRelUpRegHeap (new StandbyTimeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_StandbyTime, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::StandbyTimeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_StandbyTime, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "StandbyTime", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "StandbyTime", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasStandbyTime()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_StandbyTime, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< StandbyTimeStatus > payloadLoopback (new StandbyTimeStatus(getStandbyTime()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,StandbyTimeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StandbyTime);
        ::boost::shared_ptr< StandbyTimeError > payload (new StandbyTimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StandbyTimeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "StandbyTime", &cb);
    }
}

bool SPM_CORE_FIProxy::sendStandbyTimeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_StandbyTime,"StandbyTime");
}

void SPM_CORE_FIProxy::sendStandbyTimeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_StandbyTime);
}

const StandbyTimeStatus& SPM_CORE_FIProxy::getStandbyTime() const {
    return _standbyTime.get();
}

bool SPM_CORE_FIProxy::hasStandbyTime() const {
    return _standbyTime.hasValue();
}

act_t SPM_CORE_FIProxy::sendStandbyTimeGet(StandbyTimeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_StandbyTime);
        ::boost::shared_ptr< StandbyTimeGet > payload (new StandbyTimeGet());
        CCA_MESSAGE(ccaMessage,header,StandbyTimeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "StandbyTime", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StandbyTime);
        ::boost::shared_ptr< StandbyTimeError > payload (new StandbyTimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StandbyTimeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "StandbyTime", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendStandbyTimeSet(StandbyTimeCallbackIF& cb, uint32 standbyTime) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_StandbyTime);
        ::boost::shared_ptr< StandbyTimeSet > payload (new StandbyTimeSet());
        payload->setStandbyTime(standbyTime);
        CCA_MESSAGE(ccaMessage,header,StandbyTimeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "StandbyTime", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StandbyTime);
        ::boost::shared_ptr< StandbyTimeError > payload (new StandbyTimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StandbyTimeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "StandbyTime", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendPersitentStandbyTimeUpReg(PersitentStandbyTimeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_PersitentStandbyTime);
        ::boost::shared_ptr< PersitentStandbyTimeUpReg > payload (new PersitentStandbyTimeUpReg());
        CCA_MESSAGE(ccaMessage,header,PersitentStandbyTimeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< PersitentStandbyTimeRelUpReg > payloadRelUpRegHeap (new PersitentStandbyTimeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_PersitentStandbyTime, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::PersitentStandbyTimeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_PersitentStandbyTime, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "PersitentStandbyTime", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "PersitentStandbyTime", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasPersitentStandbyTime()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_PersitentStandbyTime, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< PersitentStandbyTimeStatus > payloadLoopback (new PersitentStandbyTimeStatus(getPersitentStandbyTime()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,PersitentStandbyTimeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PersitentStandbyTime);
        ::boost::shared_ptr< PersitentStandbyTimeError > payload (new PersitentStandbyTimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PersitentStandbyTimeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "PersitentStandbyTime", &cb);
    }
}

bool SPM_CORE_FIProxy::sendPersitentStandbyTimeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_PersitentStandbyTime,"PersitentStandbyTime");
}

void SPM_CORE_FIProxy::sendPersitentStandbyTimeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_PersitentStandbyTime);
}

const PersitentStandbyTimeStatus& SPM_CORE_FIProxy::getPersitentStandbyTime() const {
    return _persitentStandbyTime.get();
}

bool SPM_CORE_FIProxy::hasPersitentStandbyTime() const {
    return _persitentStandbyTime.hasValue();
}

act_t SPM_CORE_FIProxy::sendPersitentStandbyTimeGet(PersitentStandbyTimeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_PersitentStandbyTime);
        ::boost::shared_ptr< PersitentStandbyTimeGet > payload (new PersitentStandbyTimeGet());
        CCA_MESSAGE(ccaMessage,header,PersitentStandbyTimeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "PersitentStandbyTime", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PersitentStandbyTime);
        ::boost::shared_ptr< PersitentStandbyTimeError > payload (new PersitentStandbyTimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PersitentStandbyTimeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "PersitentStandbyTime", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendPersitentStandbyTimeSet(PersitentStandbyTimeCallbackIF& cb, uint32 persitentStandbyTime) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_PersitentStandbyTime);
        ::boost::shared_ptr< PersitentStandbyTimeSet > payload (new PersitentStandbyTimeSet());
        payload->setPersitentStandbyTime(persitentStandbyTime);
        CCA_MESSAGE(ccaMessage,header,PersitentStandbyTimeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "PersitentStandbyTime", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PersitentStandbyTime);
        ::boost::shared_ptr< PersitentStandbyTimeError > payload (new PersitentStandbyTimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PersitentStandbyTimeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "PersitentStandbyTime", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendIgnitionOffTimeUpReg(IgnitionOffTimeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_IgnitionOffTime);
        ::boost::shared_ptr< IgnitionOffTimeUpReg > payload (new IgnitionOffTimeUpReg());
        CCA_MESSAGE(ccaMessage,header,IgnitionOffTimeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< IgnitionOffTimeRelUpReg > payloadRelUpRegHeap (new IgnitionOffTimeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_IgnitionOffTime, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::IgnitionOffTimeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_IgnitionOffTime, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "IgnitionOffTime", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "IgnitionOffTime", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasIgnitionOffTime()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_IgnitionOffTime, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< IgnitionOffTimeStatus > payloadLoopback (new IgnitionOffTimeStatus(getIgnitionOffTime()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,IgnitionOffTimeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_IgnitionOffTime);
        ::boost::shared_ptr< IgnitionOffTimeError > payload (new IgnitionOffTimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,IgnitionOffTimeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "IgnitionOffTime", &cb);
    }
}

bool SPM_CORE_FIProxy::sendIgnitionOffTimeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_IgnitionOffTime,"IgnitionOffTime");
}

void SPM_CORE_FIProxy::sendIgnitionOffTimeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_IgnitionOffTime);
}

const IgnitionOffTimeStatus& SPM_CORE_FIProxy::getIgnitionOffTime() const {
    return _ignitionOffTime.get();
}

bool SPM_CORE_FIProxy::hasIgnitionOffTime() const {
    return _ignitionOffTime.hasValue();
}

act_t SPM_CORE_FIProxy::sendIgnitionOffTimeGet(IgnitionOffTimeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_IgnitionOffTime);
        ::boost::shared_ptr< IgnitionOffTimeGet > payload (new IgnitionOffTimeGet());
        CCA_MESSAGE(ccaMessage,header,IgnitionOffTimeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "IgnitionOffTime", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_IgnitionOffTime);
        ::boost::shared_ptr< IgnitionOffTimeError > payload (new IgnitionOffTimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,IgnitionOffTimeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "IgnitionOffTime", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendIgnitionOffTimeSet(IgnitionOffTimeCallbackIF& cb, uint32 ignitionOffTime) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_IgnitionOffTime);
        ::boost::shared_ptr< IgnitionOffTimeSet > payload (new IgnitionOffTimeSet());
        payload->setIgnitionOffTime(ignitionOffTime);
        CCA_MESSAGE(ccaMessage,header,IgnitionOffTimeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "IgnitionOffTime", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_IgnitionOffTime);
        ::boost::shared_ptr< IgnitionOffTimeError > payload (new IgnitionOffTimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,IgnitionOffTimeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "IgnitionOffTime", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendDoorOpenTimeUpReg(DoorOpenTimeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DoorOpenTime);
        ::boost::shared_ptr< DoorOpenTimeUpReg > payload (new DoorOpenTimeUpReg());
        CCA_MESSAGE(ccaMessage,header,DoorOpenTimeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DoorOpenTimeRelUpReg > payloadRelUpRegHeap (new DoorOpenTimeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DoorOpenTime, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::DoorOpenTimeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DoorOpenTime, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DoorOpenTime", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DoorOpenTime", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDoorOpenTime()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DoorOpenTime, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DoorOpenTimeStatus > payloadLoopback (new DoorOpenTimeStatus(getDoorOpenTime()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DoorOpenTimeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DoorOpenTime);
        ::boost::shared_ptr< DoorOpenTimeError > payload (new DoorOpenTimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DoorOpenTimeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DoorOpenTime", &cb);
    }
}

bool SPM_CORE_FIProxy::sendDoorOpenTimeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DoorOpenTime,"DoorOpenTime");
}

void SPM_CORE_FIProxy::sendDoorOpenTimeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DoorOpenTime);
}

const DoorOpenTimeStatus& SPM_CORE_FIProxy::getDoorOpenTime() const {
    return _doorOpenTime.get();
}

bool SPM_CORE_FIProxy::hasDoorOpenTime() const {
    return _doorOpenTime.hasValue();
}

act_t SPM_CORE_FIProxy::sendDoorOpenTimeGet(DoorOpenTimeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DoorOpenTime);
        ::boost::shared_ptr< DoorOpenTimeGet > payload (new DoorOpenTimeGet());
        CCA_MESSAGE(ccaMessage,header,DoorOpenTimeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DoorOpenTime", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DoorOpenTime);
        ::boost::shared_ptr< DoorOpenTimeError > payload (new DoorOpenTimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DoorOpenTimeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DoorOpenTime", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendDoorOpenTimeSet(DoorOpenTimeCallbackIF& cb, uint32 doorOpenTime) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_DoorOpenTime);
        ::boost::shared_ptr< DoorOpenTimeSet > payload (new DoorOpenTimeSet());
        payload->setDoorOpenTime(doorOpenTime);
        CCA_MESSAGE(ccaMessage,header,DoorOpenTimeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "DoorOpenTime", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DoorOpenTime);
        ::boost::shared_ptr< DoorOpenTimeError > payload (new DoorOpenTimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DoorOpenTimeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "DoorOpenTime", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendClockDisplayTimeUpReg(ClockDisplayTimeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ClockDisplayTime);
        ::boost::shared_ptr< ClockDisplayTimeUpReg > payload (new ClockDisplayTimeUpReg());
        CCA_MESSAGE(ccaMessage,header,ClockDisplayTimeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ClockDisplayTimeRelUpReg > payloadRelUpRegHeap (new ClockDisplayTimeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ClockDisplayTime, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::ClockDisplayTimeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ClockDisplayTime, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ClockDisplayTime", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ClockDisplayTime", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasClockDisplayTime()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ClockDisplayTime, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ClockDisplayTimeStatus > payloadLoopback (new ClockDisplayTimeStatus(getClockDisplayTime()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ClockDisplayTimeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ClockDisplayTime);
        ::boost::shared_ptr< ClockDisplayTimeError > payload (new ClockDisplayTimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ClockDisplayTimeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ClockDisplayTime", &cb);
    }
}

bool SPM_CORE_FIProxy::sendClockDisplayTimeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ClockDisplayTime,"ClockDisplayTime");
}

void SPM_CORE_FIProxy::sendClockDisplayTimeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ClockDisplayTime);
}

const ClockDisplayTimeStatus& SPM_CORE_FIProxy::getClockDisplayTime() const {
    return _clockDisplayTime.get();
}

bool SPM_CORE_FIProxy::hasClockDisplayTime() const {
    return _clockDisplayTime.hasValue();
}

act_t SPM_CORE_FIProxy::sendClockDisplayTimeGet(ClockDisplayTimeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ClockDisplayTime);
        ::boost::shared_ptr< ClockDisplayTimeGet > payload (new ClockDisplayTimeGet());
        CCA_MESSAGE(ccaMessage,header,ClockDisplayTimeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ClockDisplayTime", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ClockDisplayTime);
        ::boost::shared_ptr< ClockDisplayTimeError > payload (new ClockDisplayTimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ClockDisplayTimeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ClockDisplayTime", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendClockDisplayTimeSet(ClockDisplayTimeCallbackIF& cb, uint32 clockDisplayTime) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_ClockDisplayTime);
        ::boost::shared_ptr< ClockDisplayTimeSet > payload (new ClockDisplayTimeSet());
        payload->setClockDisplayTime(clockDisplayTime);
        CCA_MESSAGE(ccaMessage,header,ClockDisplayTimeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "ClockDisplayTime", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ClockDisplayTime);
        ::boost::shared_ptr< ClockDisplayTimeError > payload (new ClockDisplayTimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ClockDisplayTimeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "ClockDisplayTime", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendSystemStateTimeUpReg(SystemStateTimeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SystemStateTime);
        ::boost::shared_ptr< SystemStateTimeUpReg > payload (new SystemStateTimeUpReg());
        CCA_MESSAGE(ccaMessage,header,SystemStateTimeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SystemStateTimeRelUpReg > payloadRelUpRegHeap (new SystemStateTimeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SystemStateTime, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::SystemStateTimeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SystemStateTime, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SystemStateTime", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SystemStateTime", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSystemStateTime()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SystemStateTime, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SystemStateTimeStatus > payloadLoopback (new SystemStateTimeStatus(getSystemStateTime()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SystemStateTimeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SystemStateTime);
        ::boost::shared_ptr< SystemStateTimeError > payload (new SystemStateTimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SystemStateTimeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SystemStateTime", &cb);
    }
}

bool SPM_CORE_FIProxy::sendSystemStateTimeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SystemStateTime,"SystemStateTime");
}

void SPM_CORE_FIProxy::sendSystemStateTimeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SystemStateTime);
}

const SystemStateTimeStatus& SPM_CORE_FIProxy::getSystemStateTime() const {
    return _systemStateTime.get();
}

bool SPM_CORE_FIProxy::hasSystemStateTime() const {
    return _systemStateTime.hasValue();
}

act_t SPM_CORE_FIProxy::sendSystemStateTimeGet(SystemStateTimeCallbackIF& cb, ::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES tSystemState) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SystemStateTime);
        ::boost::shared_ptr< SystemStateTimeGet > payload (new SystemStateTimeGet());
        payload->setTSystemState(tSystemState);
        CCA_MESSAGE(ccaMessage,header,SystemStateTimeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SystemStateTime", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SystemStateTime);
        ::boost::shared_ptr< SystemStateTimeError > payload (new SystemStateTimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SystemStateTimeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SystemStateTime", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendSystemStateTimeSet(SystemStateTimeCallbackIF& cb, ::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES tSystemState, uint32 tStateTimerValue) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SystemStateTime);
        ::boost::shared_ptr< SystemStateTimeSet > payload (new SystemStateTimeSet());
        payload->setTSystemState(tSystemState);
        payload->setTStateTimerValue(tStateTimerValue);
        CCA_MESSAGE(ccaMessage,header,SystemStateTimeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SystemStateTime", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SystemStateTime);
        ::boost::shared_ptr< SystemStateTimeError > payload (new SystemStateTimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SystemStateTimeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SystemStateTime", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendProcessListUpReg(ProcessListCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ProcessList);
        ::boost::shared_ptr< ProcessListUpReg > payload (new ProcessListUpReg());
        CCA_MESSAGE(ccaMessage,header,ProcessListUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ProcessListRelUpReg > payloadRelUpRegHeap (new ProcessListRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ProcessList, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::ProcessListRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ProcessList, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ProcessList", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ProcessList", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasProcessList()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ProcessList, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ProcessListStatus > payloadLoopback (new ProcessListStatus(getProcessList()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ProcessListStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ProcessList);
        ::boost::shared_ptr< ProcessListError > payload (new ProcessListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ProcessListError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ProcessList", &cb);
    }
}

bool SPM_CORE_FIProxy::sendProcessListRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ProcessList,"ProcessList");
}

void SPM_CORE_FIProxy::sendProcessListRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ProcessList);
}

const ProcessListStatus& SPM_CORE_FIProxy::getProcessList() const {
    return _processList.get();
}

bool SPM_CORE_FIProxy::hasProcessList() const {
    return _processList.hasValue();
}

act_t SPM_CORE_FIProxy::sendProcessListGet(ProcessListCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ProcessList);
        ::boost::shared_ptr< ProcessListGet > payload (new ProcessListGet());
        CCA_MESSAGE(ccaMessage,header,ProcessListGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ProcessList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ProcessList);
        ::boost::shared_ptr< ProcessListError > payload (new ProcessListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ProcessListError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ProcessList", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendWakeupReasonUpReg(WakeupReasonCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_WakeupReason);
        ::boost::shared_ptr< WakeupReasonUpReg > payload (new WakeupReasonUpReg());
        CCA_MESSAGE(ccaMessage,header,WakeupReasonUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< WakeupReasonRelUpReg > payloadRelUpRegHeap (new WakeupReasonRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_WakeupReason, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::WakeupReasonRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_WakeupReason, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "WakeupReason", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "WakeupReason", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasWakeupReason()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_WakeupReason, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< WakeupReasonStatus > payloadLoopback (new WakeupReasonStatus(getWakeupReason()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,WakeupReasonStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_WakeupReason);
        ::boost::shared_ptr< WakeupReasonError > payload (new WakeupReasonError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,WakeupReasonError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "WakeupReason", &cb);
    }
}

bool SPM_CORE_FIProxy::sendWakeupReasonRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_WakeupReason,"WakeupReason");
}

void SPM_CORE_FIProxy::sendWakeupReasonRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_WakeupReason);
}

const WakeupReasonStatus& SPM_CORE_FIProxy::getWakeupReason() const {
    return _wakeupReason.get();
}

bool SPM_CORE_FIProxy::hasWakeupReason() const {
    return _wakeupReason.hasValue();
}

act_t SPM_CORE_FIProxy::sendWakeupReasonGet(WakeupReasonCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_WakeupReason);
        ::boost::shared_ptr< WakeupReasonGet > payload (new WakeupReasonGet());
        CCA_MESSAGE(ccaMessage,header,WakeupReasonGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "WakeupReason", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_WakeupReason);
        ::boost::shared_ptr< WakeupReasonError > payload (new WakeupReasonError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,WakeupReasonError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "WakeupReason", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendStartupReasonUpReg(StartupReasonCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_StartupReason);
        ::boost::shared_ptr< StartupReasonUpReg > payload (new StartupReasonUpReg());
        CCA_MESSAGE(ccaMessage,header,StartupReasonUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< StartupReasonRelUpReg > payloadRelUpRegHeap (new StartupReasonRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_StartupReason, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::StartupReasonRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_StartupReason, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "StartupReason", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "StartupReason", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasStartupReason()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_StartupReason, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< StartupReasonStatus > payloadLoopback (new StartupReasonStatus(getStartupReason()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,StartupReasonStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StartupReason);
        ::boost::shared_ptr< StartupReasonError > payload (new StartupReasonError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StartupReasonError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "StartupReason", &cb);
    }
}

bool SPM_CORE_FIProxy::sendStartupReasonRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_StartupReason,"StartupReason");
}

void SPM_CORE_FIProxy::sendStartupReasonRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_StartupReason);
}

const StartupReasonStatus& SPM_CORE_FIProxy::getStartupReason() const {
    return _startupReason.get();
}

bool SPM_CORE_FIProxy::hasStartupReason() const {
    return _startupReason.hasValue();
}

act_t SPM_CORE_FIProxy::sendStartupReasonGet(StartupReasonCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_StartupReason);
        ::boost::shared_ptr< StartupReasonGet > payload (new StartupReasonGet());
        CCA_MESSAGE(ccaMessage,header,StartupReasonGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "StartupReason", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StartupReason);
        ::boost::shared_ptr< StartupReasonError > payload (new StartupReasonError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StartupReasonError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "StartupReason", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendConnectToBatteryUpReg(ConnectToBatteryCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ConnectToBattery);
        ::boost::shared_ptr< ConnectToBatteryUpReg > payload (new ConnectToBatteryUpReg());
        CCA_MESSAGE(ccaMessage,header,ConnectToBatteryUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ConnectToBatteryRelUpReg > payloadRelUpRegHeap (new ConnectToBatteryRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ConnectToBattery, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::ConnectToBatteryRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ConnectToBattery, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ConnectToBattery", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ConnectToBattery", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasConnectToBattery()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ConnectToBattery, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ConnectToBatteryStatus > payloadLoopback (new ConnectToBatteryStatus(getConnectToBattery()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ConnectToBatteryStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ConnectToBattery);
        ::boost::shared_ptr< ConnectToBatteryError > payload (new ConnectToBatteryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ConnectToBatteryError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ConnectToBattery", &cb);
    }
}

bool SPM_CORE_FIProxy::sendConnectToBatteryRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ConnectToBattery,"ConnectToBattery");
}

void SPM_CORE_FIProxy::sendConnectToBatteryRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ConnectToBattery);
}

const ConnectToBatteryStatus& SPM_CORE_FIProxy::getConnectToBattery() const {
    return _connectToBattery.get();
}

bool SPM_CORE_FIProxy::hasConnectToBattery() const {
    return _connectToBattery.hasValue();
}

act_t SPM_CORE_FIProxy::sendConnectToBatteryGet(ConnectToBatteryCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ConnectToBattery);
        ::boost::shared_ptr< ConnectToBatteryGet > payload (new ConnectToBatteryGet());
        CCA_MESSAGE(ccaMessage,header,ConnectToBatteryGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ConnectToBattery", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ConnectToBattery);
        ::boost::shared_ptr< ConnectToBatteryError > payload (new ConnectToBatteryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ConnectToBatteryError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ConnectToBattery", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendCodeRequestStateUpReg(CodeRequestStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_CodeRequestState);
        ::boost::shared_ptr< CodeRequestStateUpReg > payload (new CodeRequestStateUpReg());
        CCA_MESSAGE(ccaMessage,header,CodeRequestStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< CodeRequestStateRelUpReg > payloadRelUpRegHeap (new CodeRequestStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_CodeRequestState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::CodeRequestStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_CodeRequestState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "CodeRequestState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "CodeRequestState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasCodeRequestState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_CodeRequestState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< CodeRequestStateStatus > payloadLoopback (new CodeRequestStateStatus(getCodeRequestState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,CodeRequestStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CodeRequestState);
        ::boost::shared_ptr< CodeRequestStateError > payload (new CodeRequestStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CodeRequestStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "CodeRequestState", &cb);
    }
}

bool SPM_CORE_FIProxy::sendCodeRequestStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_CodeRequestState,"CodeRequestState");
}

void SPM_CORE_FIProxy::sendCodeRequestStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_CodeRequestState);
}

const CodeRequestStateStatus& SPM_CORE_FIProxy::getCodeRequestState() const {
    return _codeRequestState.get();
}

bool SPM_CORE_FIProxy::hasCodeRequestState() const {
    return _codeRequestState.hasValue();
}

act_t SPM_CORE_FIProxy::sendCodeRequestStateGet(CodeRequestStateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_CodeRequestState);
        ::boost::shared_ptr< CodeRequestStateGet > payload (new CodeRequestStateGet());
        CCA_MESSAGE(ccaMessage,header,CodeRequestStateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "CodeRequestState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CodeRequestState);
        ::boost::shared_ptr< CodeRequestStateError > payload (new CodeRequestStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CodeRequestStateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "CodeRequestState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendCodeRequestStateSet(CodeRequestStateCallbackIF& cb, ::spm_core_fi_types::T_SPM_e32_CODE_REQUEST codeRequestState) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_CodeRequestState);
        ::boost::shared_ptr< CodeRequestStateSet > payload (new CodeRequestStateSet());
        payload->setCodeRequestState(codeRequestState);
        CCA_MESSAGE(ccaMessage,header,CodeRequestStateSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "CodeRequestState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CodeRequestState);
        ::boost::shared_ptr< CodeRequestStateError > payload (new CodeRequestStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CodeRequestStateError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "CodeRequestState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendActiveStartUpSyncPointsUpReg(ActiveStartUpSyncPointsCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ActiveStartUpSyncPoints);
        ::boost::shared_ptr< ActiveStartUpSyncPointsUpReg > payload (new ActiveStartUpSyncPointsUpReg());
        CCA_MESSAGE(ccaMessage,header,ActiveStartUpSyncPointsUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ActiveStartUpSyncPointsRelUpReg > payloadRelUpRegHeap (new ActiveStartUpSyncPointsRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ActiveStartUpSyncPoints, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::ActiveStartUpSyncPointsRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ActiveStartUpSyncPoints, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ActiveStartUpSyncPoints", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ActiveStartUpSyncPoints", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasActiveStartUpSyncPoints()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ActiveStartUpSyncPoints, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ActiveStartUpSyncPointsStatus > payloadLoopback (new ActiveStartUpSyncPointsStatus(getActiveStartUpSyncPoints()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ActiveStartUpSyncPointsStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ActiveStartUpSyncPoints);
        ::boost::shared_ptr< ActiveStartUpSyncPointsError > payload (new ActiveStartUpSyncPointsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ActiveStartUpSyncPointsError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ActiveStartUpSyncPoints", &cb);
    }
}

bool SPM_CORE_FIProxy::sendActiveStartUpSyncPointsRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ActiveStartUpSyncPoints,"ActiveStartUpSyncPoints");
}

void SPM_CORE_FIProxy::sendActiveStartUpSyncPointsRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ActiveStartUpSyncPoints);
}

const ActiveStartUpSyncPointsStatus& SPM_CORE_FIProxy::getActiveStartUpSyncPoints() const {
    return _activeStartUpSyncPoints.get();
}

bool SPM_CORE_FIProxy::hasActiveStartUpSyncPoints() const {
    return _activeStartUpSyncPoints.hasValue();
}

act_t SPM_CORE_FIProxy::sendActiveStartUpSyncPointsGet(ActiveStartUpSyncPointsCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ActiveStartUpSyncPoints);
        ::boost::shared_ptr< ActiveStartUpSyncPointsGet > payload (new ActiveStartUpSyncPointsGet());
        CCA_MESSAGE(ccaMessage,header,ActiveStartUpSyncPointsGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ActiveStartUpSyncPoints", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ActiveStartUpSyncPoints);
        ::boost::shared_ptr< ActiveStartUpSyncPointsError > payload (new ActiveStartUpSyncPointsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ActiveStartUpSyncPointsError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ActiveStartUpSyncPoints", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendCvmEventUpReg(CvmEventCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_CvmEvent);
        ::boost::shared_ptr< CvmEventUpReg > payload (new CvmEventUpReg());
        CCA_MESSAGE(ccaMessage,header,CvmEventUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< CvmEventRelUpReg > payloadRelUpRegHeap (new CvmEventRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_CvmEvent, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::CvmEventRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_CvmEvent, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "CvmEvent", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "CvmEvent", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasCvmEvent()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_CvmEvent, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< CvmEventStatus > payloadLoopback (new CvmEventStatus(getCvmEvent()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,CvmEventStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CvmEvent);
        ::boost::shared_ptr< CvmEventError > payload (new CvmEventError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CvmEventError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "CvmEvent", &cb);
    }
}

bool SPM_CORE_FIProxy::sendCvmEventRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_CvmEvent,"CvmEvent");
}

void SPM_CORE_FIProxy::sendCvmEventRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_CvmEvent);
}

const CvmEventStatus& SPM_CORE_FIProxy::getCvmEvent() const {
    return _cvmEvent.get();
}

bool SPM_CORE_FIProxy::hasCvmEvent() const {
    return _cvmEvent.hasValue();
}

act_t SPM_CORE_FIProxy::sendCvmEventGet(CvmEventCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_CvmEvent);
        ::boost::shared_ptr< CvmEventGet > payload (new CvmEventGet());
        CCA_MESSAGE(ccaMessage,header,CvmEventGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "CvmEvent", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CvmEvent);
        ::boost::shared_ptr< CvmEventError > payload (new CvmEventError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CvmEventError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "CvmEvent", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendUBatSenseUpReg(UBatSenseCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_UBatSense);
        ::boost::shared_ptr< UBatSenseUpReg > payload (new UBatSenseUpReg());
        CCA_MESSAGE(ccaMessage,header,UBatSenseUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< UBatSenseRelUpReg > payloadRelUpRegHeap (new UBatSenseRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_UBatSense, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::UBatSenseRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_UBatSense, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "UBatSense", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "UBatSense", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasUBatSense()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_UBatSense, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< UBatSenseStatus > payloadLoopback (new UBatSenseStatus(getUBatSense()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,UBatSenseStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_UBatSense);
        ::boost::shared_ptr< UBatSenseError > payload (new UBatSenseError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,UBatSenseError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "UBatSense", &cb);
    }
}

bool SPM_CORE_FIProxy::sendUBatSenseRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_UBatSense,"UBatSense");
}

void SPM_CORE_FIProxy::sendUBatSenseRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_UBatSense);
}

const UBatSenseStatus& SPM_CORE_FIProxy::getUBatSense() const {
    return _uBatSense.get();
}

bool SPM_CORE_FIProxy::hasUBatSense() const {
    return _uBatSense.hasValue();
}

act_t SPM_CORE_FIProxy::sendUBatSenseGet(UBatSenseCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_UBatSense);
        ::boost::shared_ptr< UBatSenseGet > payload (new UBatSenseGet());
        CCA_MESSAGE(ccaMessage,header,UBatSenseGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "UBatSense", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_UBatSense);
        ::boost::shared_ptr< UBatSenseError > payload (new UBatSenseError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,UBatSenseError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "UBatSense", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendCoproStateUpReg(CoproStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_CoproState);
        ::boost::shared_ptr< CoproStateUpReg > payload (new CoproStateUpReg());
        CCA_MESSAGE(ccaMessage,header,CoproStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< CoproStateRelUpReg > payloadRelUpRegHeap (new CoproStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_CoproState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::CoproStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_CoproState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "CoproState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "CoproState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasCoproState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_CoproState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< CoproStateStatus > payloadLoopback (new CoproStateStatus(getCoproState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,CoproStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CoproState);
        ::boost::shared_ptr< CoproStateError > payload (new CoproStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CoproStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "CoproState", &cb);
    }
}

bool SPM_CORE_FIProxy::sendCoproStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_CoproState,"CoproState");
}

void SPM_CORE_FIProxy::sendCoproStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_CoproState);
}

const CoproStateStatus& SPM_CORE_FIProxy::getCoproState() const {
    return _coproState.get();
}

bool SPM_CORE_FIProxy::hasCoproState() const {
    return _coproState.hasValue();
}

act_t SPM_CORE_FIProxy::sendCoproStateGet(CoproStateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_CoproState);
        ::boost::shared_ptr< CoproStateGet > payload (new CoproStateGet());
        CCA_MESSAGE(ccaMessage,header,CoproStateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "CoproState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CoproState);
        ::boost::shared_ptr< CoproStateError > payload (new CoproStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CoproStateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "CoproState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendCoproStateSet(CoproStateCallbackIF& cb, ::spm_core_fi_types::T_SPM_e32_PROCESSOR_STATE coproState) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_CoproState);
        ::boost::shared_ptr< CoproStateSet > payload (new CoproStateSet());
        payload->setCoproState(coproState);
        CCA_MESSAGE(ccaMessage,header,CoproStateSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "CoproState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CoproState);
        ::boost::shared_ptr< CoproStateError > payload (new CoproStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CoproStateError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "CoproState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendDevicePowerOnTimeUpReg(DevicePowerOnTimeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DevicePowerOnTime);
        ::boost::shared_ptr< DevicePowerOnTimeUpReg > payload (new DevicePowerOnTimeUpReg());
        CCA_MESSAGE(ccaMessage,header,DevicePowerOnTimeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DevicePowerOnTimeRelUpReg > payloadRelUpRegHeap (new DevicePowerOnTimeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DevicePowerOnTime, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::DevicePowerOnTimeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DevicePowerOnTime, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DevicePowerOnTime", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DevicePowerOnTime", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDevicePowerOnTime()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DevicePowerOnTime, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DevicePowerOnTimeStatus > payloadLoopback (new DevicePowerOnTimeStatus(getDevicePowerOnTime()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DevicePowerOnTimeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevicePowerOnTime);
        ::boost::shared_ptr< DevicePowerOnTimeError > payload (new DevicePowerOnTimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevicePowerOnTimeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DevicePowerOnTime", &cb);
    }
}

bool SPM_CORE_FIProxy::sendDevicePowerOnTimeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DevicePowerOnTime,"DevicePowerOnTime");
}

void SPM_CORE_FIProxy::sendDevicePowerOnTimeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DevicePowerOnTime);
}

const DevicePowerOnTimeStatus& SPM_CORE_FIProxy::getDevicePowerOnTime() const {
    return _devicePowerOnTime.get();
}

bool SPM_CORE_FIProxy::hasDevicePowerOnTime() const {
    return _devicePowerOnTime.hasValue();
}

act_t SPM_CORE_FIProxy::sendDevicePowerOnTimeGet(DevicePowerOnTimeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DevicePowerOnTime);
        ::boost::shared_ptr< DevicePowerOnTimeGet > payload (new DevicePowerOnTimeGet());
        CCA_MESSAGE(ccaMessage,header,DevicePowerOnTimeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DevicePowerOnTime", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevicePowerOnTime);
        ::boost::shared_ptr< DevicePowerOnTimeError > payload (new DevicePowerOnTimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevicePowerOnTimeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DevicePowerOnTime", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendDevicePowerOnTimeSet(DevicePowerOnTimeCallbackIF& cb, uint32 devicePowerOnTime) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_DevicePowerOnTime);
        ::boost::shared_ptr< DevicePowerOnTimeSet > payload (new DevicePowerOnTimeSet());
        payload->setDevicePowerOnTime(devicePowerOnTime);
        CCA_MESSAGE(ccaMessage,header,DevicePowerOnTimeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "DevicePowerOnTime", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevicePowerOnTime);
        ::boost::shared_ptr< DevicePowerOnTimeError > payload (new DevicePowerOnTimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevicePowerOnTimeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "DevicePowerOnTime", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendLastSystemRuntimeUpReg(LastSystemRuntimeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_LastSystemRuntime);
        ::boost::shared_ptr< LastSystemRuntimeUpReg > payload (new LastSystemRuntimeUpReg());
        CCA_MESSAGE(ccaMessage,header,LastSystemRuntimeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< LastSystemRuntimeRelUpReg > payloadRelUpRegHeap (new LastSystemRuntimeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_LastSystemRuntime, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::LastSystemRuntimeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_LastSystemRuntime, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "LastSystemRuntime", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "LastSystemRuntime", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasLastSystemRuntime()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_LastSystemRuntime, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< LastSystemRuntimeStatus > payloadLoopback (new LastSystemRuntimeStatus(getLastSystemRuntime()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,LastSystemRuntimeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_LastSystemRuntime);
        ::boost::shared_ptr< LastSystemRuntimeError > payload (new LastSystemRuntimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,LastSystemRuntimeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "LastSystemRuntime", &cb);
    }
}

bool SPM_CORE_FIProxy::sendLastSystemRuntimeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_LastSystemRuntime,"LastSystemRuntime");
}

void SPM_CORE_FIProxy::sendLastSystemRuntimeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_LastSystemRuntime);
}

const LastSystemRuntimeStatus& SPM_CORE_FIProxy::getLastSystemRuntime() const {
    return _lastSystemRuntime.get();
}

bool SPM_CORE_FIProxy::hasLastSystemRuntime() const {
    return _lastSystemRuntime.hasValue();
}

act_t SPM_CORE_FIProxy::sendLastSystemRuntimeGet(LastSystemRuntimeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_LastSystemRuntime);
        ::boost::shared_ptr< LastSystemRuntimeGet > payload (new LastSystemRuntimeGet());
        CCA_MESSAGE(ccaMessage,header,LastSystemRuntimeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "LastSystemRuntime", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_LastSystemRuntime);
        ::boost::shared_ptr< LastSystemRuntimeError > payload (new LastSystemRuntimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,LastSystemRuntimeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "LastSystemRuntime", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendCurrentSystemRuntimeUpReg(CurrentSystemRuntimeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_CurrentSystemRuntime);
        ::boost::shared_ptr< CurrentSystemRuntimeUpReg > payload (new CurrentSystemRuntimeUpReg());
        CCA_MESSAGE(ccaMessage,header,CurrentSystemRuntimeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< CurrentSystemRuntimeRelUpReg > payloadRelUpRegHeap (new CurrentSystemRuntimeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_CurrentSystemRuntime, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::CurrentSystemRuntimeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_CurrentSystemRuntime, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "CurrentSystemRuntime", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "CurrentSystemRuntime", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasCurrentSystemRuntime()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_CurrentSystemRuntime, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< CurrentSystemRuntimeStatus > payloadLoopback (new CurrentSystemRuntimeStatus(getCurrentSystemRuntime()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,CurrentSystemRuntimeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CurrentSystemRuntime);
        ::boost::shared_ptr< CurrentSystemRuntimeError > payload (new CurrentSystemRuntimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CurrentSystemRuntimeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "CurrentSystemRuntime", &cb);
    }
}

bool SPM_CORE_FIProxy::sendCurrentSystemRuntimeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_CurrentSystemRuntime,"CurrentSystemRuntime");
}

void SPM_CORE_FIProxy::sendCurrentSystemRuntimeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_CurrentSystemRuntime);
}

const CurrentSystemRuntimeStatus& SPM_CORE_FIProxy::getCurrentSystemRuntime() const {
    return _currentSystemRuntime.get();
}

bool SPM_CORE_FIProxy::hasCurrentSystemRuntime() const {
    return _currentSystemRuntime.hasValue();
}

act_t SPM_CORE_FIProxy::sendCurrentSystemRuntimeGet(CurrentSystemRuntimeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_CurrentSystemRuntime);
        ::boost::shared_ptr< CurrentSystemRuntimeGet > payload (new CurrentSystemRuntimeGet());
        CCA_MESSAGE(ccaMessage,header,CurrentSystemRuntimeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "CurrentSystemRuntime", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CurrentSystemRuntime);
        ::boost::shared_ptr< CurrentSystemRuntimeError > payload (new CurrentSystemRuntimeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CurrentSystemRuntimeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "CurrentSystemRuntime", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendResetListUpReg(ResetListCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ResetList);
        ::boost::shared_ptr< ResetListUpReg > payload (new ResetListUpReg());
        CCA_MESSAGE(ccaMessage,header,ResetListUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ResetListRelUpReg > payloadRelUpRegHeap (new ResetListRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ResetList, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::ResetListRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ResetList, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ResetList", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ResetList", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasResetList()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ResetList, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ResetListStatus > payloadLoopback (new ResetListStatus(getResetList()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ResetListStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ResetList);
        ::boost::shared_ptr< ResetListError > payload (new ResetListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ResetListError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ResetList", &cb);
    }
}

bool SPM_CORE_FIProxy::sendResetListRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ResetList,"ResetList");
}

void SPM_CORE_FIProxy::sendResetListRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ResetList);
}

const ResetListStatus& SPM_CORE_FIProxy::getResetList() const {
    return _resetList.get();
}

bool SPM_CORE_FIProxy::hasResetList() const {
    return _resetList.hasValue();
}

act_t SPM_CORE_FIProxy::sendResetListGet(ResetListCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ResetList);
        ::boost::shared_ptr< ResetListGet > payload (new ResetListGet());
        CCA_MESSAGE(ccaMessage,header,ResetListGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ResetList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ResetList);
        ::boost::shared_ptr< ResetListError > payload (new ResetListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ResetListError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ResetList", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendResetListSet(ResetListCallbackIF& cb, uint32 resetResetList) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_ResetList);
        ::boost::shared_ptr< ResetListSet > payload (new ResetListSet());
        payload->setResetResetList(resetResetList);
        CCA_MESSAGE(ccaMessage,header,ResetListSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "ResetList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ResetList);
        ::boost::shared_ptr< ResetListError > payload (new ResetListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ResetListError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "ResetList", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendResetCounterUpReg(ResetCounterCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ResetCounter);
        ::boost::shared_ptr< ResetCounterUpReg > payload (new ResetCounterUpReg());
        CCA_MESSAGE(ccaMessage,header,ResetCounterUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ResetCounterRelUpReg > payloadRelUpRegHeap (new ResetCounterRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ResetCounter, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::ResetCounterRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ResetCounter, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ResetCounter", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ResetCounter", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasResetCounter()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ResetCounter, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ResetCounterStatus > payloadLoopback (new ResetCounterStatus(getResetCounter()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ResetCounterStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ResetCounter);
        ::boost::shared_ptr< ResetCounterError > payload (new ResetCounterError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ResetCounterError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ResetCounter", &cb);
    }
}

bool SPM_CORE_FIProxy::sendResetCounterRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ResetCounter,"ResetCounter");
}

void SPM_CORE_FIProxy::sendResetCounterRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ResetCounter);
}

const ResetCounterStatus& SPM_CORE_FIProxy::getResetCounter() const {
    return _resetCounter.get();
}

bool SPM_CORE_FIProxy::hasResetCounter() const {
    return _resetCounter.hasValue();
}

act_t SPM_CORE_FIProxy::sendResetCounterGet(ResetCounterCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ResetCounter);
        ::boost::shared_ptr< ResetCounterGet > payload (new ResetCounterGet());
        CCA_MESSAGE(ccaMessage,header,ResetCounterGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ResetCounter", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ResetCounter);
        ::boost::shared_ptr< ResetCounterError > payload (new ResetCounterError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ResetCounterError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ResetCounter", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendResetCounterSet(ResetCounterCallbackIF& cb, uint32 resetCounter) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_ResetCounter);
        ::boost::shared_ptr< ResetCounterSet > payload (new ResetCounterSet());
        payload->setResetCounter(resetCounter);
        CCA_MESSAGE(ccaMessage,header,ResetCounterSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "ResetCounter", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ResetCounter);
        ::boost::shared_ptr< ResetCounterError > payload (new ResetCounterError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ResetCounterError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "ResetCounter", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendTransportModeListUpReg(TransportModeListCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_TransportModeList);
        ::boost::shared_ptr< TransportModeListUpReg > payload (new TransportModeListUpReg());
        CCA_MESSAGE(ccaMessage,header,TransportModeListUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< TransportModeListRelUpReg > payloadRelUpRegHeap (new TransportModeListRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_TransportModeList, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::TransportModeListRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_TransportModeList, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "TransportModeList", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "TransportModeList", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasTransportModeList()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_TransportModeList, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< TransportModeListStatus > payloadLoopback (new TransportModeListStatus(getTransportModeList()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,TransportModeListStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TransportModeList);
        ::boost::shared_ptr< TransportModeListError > payload (new TransportModeListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TransportModeListError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "TransportModeList", &cb);
    }
}

bool SPM_CORE_FIProxy::sendTransportModeListRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_TransportModeList,"TransportModeList");
}

void SPM_CORE_FIProxy::sendTransportModeListRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_TransportModeList);
}

const TransportModeListStatus& SPM_CORE_FIProxy::getTransportModeList() const {
    return _transportModeList.get();
}

bool SPM_CORE_FIProxy::hasTransportModeList() const {
    return _transportModeList.hasValue();
}

act_t SPM_CORE_FIProxy::sendTransportModeListGet(TransportModeListCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_TransportModeList);
        ::boost::shared_ptr< TransportModeListGet > payload (new TransportModeListGet());
        CCA_MESSAGE(ccaMessage,header,TransportModeListGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "TransportModeList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TransportModeList);
        ::boost::shared_ptr< TransportModeListError > payload (new TransportModeListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TransportModeListError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "TransportModeList", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendTransportModeListSet(TransportModeListCallbackIF& cb, uint32 transPortList) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_TransportModeList);
        ::boost::shared_ptr< TransportModeListSet > payload (new TransportModeListSet());
        payload->setTransPortList(transPortList);
        CCA_MESSAGE(ccaMessage,header,TransportModeListSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "TransportModeList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TransportModeList);
        ::boost::shared_ptr< TransportModeListError > payload (new TransportModeListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TransportModeListError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "TransportModeList", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendResetHistoryUpReg(ResetHistoryCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ResetHistory);
        ::boost::shared_ptr< ResetHistoryUpReg > payload (new ResetHistoryUpReg());
        CCA_MESSAGE(ccaMessage,header,ResetHistoryUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ResetHistoryRelUpReg > payloadRelUpRegHeap (new ResetHistoryRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ResetHistory, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::ResetHistoryRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ResetHistory, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ResetHistory", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ResetHistory", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasResetHistory()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ResetHistory, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ResetHistoryStatus > payloadLoopback (new ResetHistoryStatus(getResetHistory()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ResetHistoryStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ResetHistory);
        ::boost::shared_ptr< ResetHistoryError > payload (new ResetHistoryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ResetHistoryError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ResetHistory", &cb);
    }
}

bool SPM_CORE_FIProxy::sendResetHistoryRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ResetHistory,"ResetHistory");
}

void SPM_CORE_FIProxy::sendResetHistoryRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ResetHistory);
}

const ResetHistoryStatus& SPM_CORE_FIProxy::getResetHistory() const {
    return _resetHistory.get();
}

bool SPM_CORE_FIProxy::hasResetHistory() const {
    return _resetHistory.hasValue();
}

act_t SPM_CORE_FIProxy::sendResetHistoryGet(ResetHistoryCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ResetHistory);
        ::boost::shared_ptr< ResetHistoryGet > payload (new ResetHistoryGet());
        CCA_MESSAGE(ccaMessage,header,ResetHistoryGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ResetHistory", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ResetHistory);
        ::boost::shared_ptr< ResetHistoryError > payload (new ResetHistoryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ResetHistoryError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ResetHistory", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendResetHistorySet(ResetHistoryCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_ResetHistory);
        ::boost::shared_ptr< ResetHistorySet > payload (new ResetHistorySet());
        CCA_MESSAGE(ccaMessage,header,ResetHistorySet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "ResetHistory", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ResetHistory);
        ::boost::shared_ptr< ResetHistoryError > payload (new ResetHistoryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ResetHistoryError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "ResetHistory", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendWakeupHistoryUpReg(WakeupHistoryCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_WakeupHistory);
        ::boost::shared_ptr< WakeupHistoryUpReg > payload (new WakeupHistoryUpReg());
        CCA_MESSAGE(ccaMessage,header,WakeupHistoryUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< WakeupHistoryRelUpReg > payloadRelUpRegHeap (new WakeupHistoryRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_WakeupHistory, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::WakeupHistoryRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_WakeupHistory, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "WakeupHistory", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "WakeupHistory", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasWakeupHistory()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_WakeupHistory, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< WakeupHistoryStatus > payloadLoopback (new WakeupHistoryStatus(getWakeupHistory()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,WakeupHistoryStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_WakeupHistory);
        ::boost::shared_ptr< WakeupHistoryError > payload (new WakeupHistoryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,WakeupHistoryError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "WakeupHistory", &cb);
    }
}

bool SPM_CORE_FIProxy::sendWakeupHistoryRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_WakeupHistory,"WakeupHistory");
}

void SPM_CORE_FIProxy::sendWakeupHistoryRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_WakeupHistory);
}

const WakeupHistoryStatus& SPM_CORE_FIProxy::getWakeupHistory() const {
    return _wakeupHistory.get();
}

bool SPM_CORE_FIProxy::hasWakeupHistory() const {
    return _wakeupHistory.hasValue();
}

act_t SPM_CORE_FIProxy::sendWakeupHistoryGet(WakeupHistoryCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_WakeupHistory);
        ::boost::shared_ptr< WakeupHistoryGet > payload (new WakeupHistoryGet());
        CCA_MESSAGE(ccaMessage,header,WakeupHistoryGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "WakeupHistory", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_WakeupHistory);
        ::boost::shared_ptr< WakeupHistoryError > payload (new WakeupHistoryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,WakeupHistoryError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "WakeupHistory", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendWakeupHistorySet(WakeupHistoryCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_WakeupHistory);
        ::boost::shared_ptr< WakeupHistorySet > payload (new WakeupHistorySet());
        CCA_MESSAGE(ccaMessage,header,WakeupHistorySet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "WakeupHistory", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_WakeupHistory);
        ::boost::shared_ptr< WakeupHistoryError > payload (new WakeupHistoryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,WakeupHistoryError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "WakeupHistory", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendStateHistoryUpReg(StateHistoryCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_StateHistory);
        ::boost::shared_ptr< StateHistoryUpReg > payload (new StateHistoryUpReg());
        CCA_MESSAGE(ccaMessage,header,StateHistoryUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< StateHistoryRelUpReg > payloadRelUpRegHeap (new StateHistoryRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_StateHistory, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::StateHistoryRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_StateHistory, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "StateHistory", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "StateHistory", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasStateHistory()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_StateHistory, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< StateHistoryStatus > payloadLoopback (new StateHistoryStatus(getStateHistory()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,StateHistoryStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StateHistory);
        ::boost::shared_ptr< StateHistoryError > payload (new StateHistoryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StateHistoryError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "StateHistory", &cb);
    }
}

bool SPM_CORE_FIProxy::sendStateHistoryRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_StateHistory,"StateHistory");
}

void SPM_CORE_FIProxy::sendStateHistoryRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_StateHistory);
}

const StateHistoryStatus& SPM_CORE_FIProxy::getStateHistory() const {
    return _stateHistory.get();
}

bool SPM_CORE_FIProxy::hasStateHistory() const {
    return _stateHistory.hasValue();
}

act_t SPM_CORE_FIProxy::sendStateHistoryGet(StateHistoryCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_StateHistory);
        ::boost::shared_ptr< StateHistoryGet > payload (new StateHistoryGet());
        CCA_MESSAGE(ccaMessage,header,StateHistoryGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "StateHistory", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StateHistory);
        ::boost::shared_ptr< StateHistoryError > payload (new StateHistoryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StateHistoryError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "StateHistory", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendStateHistorySet(StateHistoryCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_StateHistory);
        ::boost::shared_ptr< StateHistorySet > payload (new StateHistorySet());
        CCA_MESSAGE(ccaMessage,header,StateHistorySet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "StateHistory", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StateHistory);
        ::boost::shared_ptr< StateHistoryError > payload (new StateHistoryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StateHistoryError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "StateHistory", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendErrStateHistory01UpReg(ErrStateHistory01CallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ErrStateHistory01);
        ::boost::shared_ptr< ErrStateHistory01UpReg > payload (new ErrStateHistory01UpReg());
        CCA_MESSAGE(ccaMessage,header,ErrStateHistory01UpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ErrStateHistory01RelUpReg > payloadRelUpRegHeap (new ErrStateHistory01RelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ErrStateHistory01, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::ErrStateHistory01RelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ErrStateHistory01, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ErrStateHistory01", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ErrStateHistory01", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasErrStateHistory01()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ErrStateHistory01, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ErrStateHistory01Status > payloadLoopback (new ErrStateHistory01Status(getErrStateHistory01()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ErrStateHistory01Status,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ErrStateHistory01);
        ::boost::shared_ptr< ErrStateHistory01Error > payload (new ErrStateHistory01Error());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ErrStateHistory01Error,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ErrStateHistory01", &cb);
    }
}

bool SPM_CORE_FIProxy::sendErrStateHistory01RelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ErrStateHistory01,"ErrStateHistory01");
}

void SPM_CORE_FIProxy::sendErrStateHistory01RelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ErrStateHistory01);
}

const ErrStateHistory01Status& SPM_CORE_FIProxy::getErrStateHistory01() const {
    return _errStateHistory01.get();
}

bool SPM_CORE_FIProxy::hasErrStateHistory01() const {
    return _errStateHistory01.hasValue();
}

act_t SPM_CORE_FIProxy::sendErrStateHistory01Get(ErrStateHistory01CallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ErrStateHistory01);
        ::boost::shared_ptr< ErrStateHistory01Get > payload (new ErrStateHistory01Get());
        CCA_MESSAGE(ccaMessage,header,ErrStateHistory01Get,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ErrStateHistory01", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ErrStateHistory01);
        ::boost::shared_ptr< ErrStateHistory01Error > payload (new ErrStateHistory01Error());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ErrStateHistory01Error,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ErrStateHistory01", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendErrStateHistory01Set(ErrStateHistory01CallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_ErrStateHistory01);
        ::boost::shared_ptr< ErrStateHistory01Set > payload (new ErrStateHistory01Set());
        CCA_MESSAGE(ccaMessage,header,ErrStateHistory01Set,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "ErrStateHistory01", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ErrStateHistory01);
        ::boost::shared_ptr< ErrStateHistory01Error > payload (new ErrStateHistory01Error());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ErrStateHistory01Error,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "ErrStateHistory01", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendErrStateHistory02UpReg(ErrStateHistory02CallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ErrStateHistory02);
        ::boost::shared_ptr< ErrStateHistory02UpReg > payload (new ErrStateHistory02UpReg());
        CCA_MESSAGE(ccaMessage,header,ErrStateHistory02UpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ErrStateHistory02RelUpReg > payloadRelUpRegHeap (new ErrStateHistory02RelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ErrStateHistory02, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::ErrStateHistory02RelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ErrStateHistory02, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ErrStateHistory02", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ErrStateHistory02", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasErrStateHistory02()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ErrStateHistory02, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ErrStateHistory02Status > payloadLoopback (new ErrStateHistory02Status(getErrStateHistory02()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ErrStateHistory02Status,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ErrStateHistory02);
        ::boost::shared_ptr< ErrStateHistory02Error > payload (new ErrStateHistory02Error());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ErrStateHistory02Error,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ErrStateHistory02", &cb);
    }
}

bool SPM_CORE_FIProxy::sendErrStateHistory02RelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ErrStateHistory02,"ErrStateHistory02");
}

void SPM_CORE_FIProxy::sendErrStateHistory02RelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ErrStateHistory02);
}

const ErrStateHistory02Status& SPM_CORE_FIProxy::getErrStateHistory02() const {
    return _errStateHistory02.get();
}

bool SPM_CORE_FIProxy::hasErrStateHistory02() const {
    return _errStateHistory02.hasValue();
}

act_t SPM_CORE_FIProxy::sendErrStateHistory02Get(ErrStateHistory02CallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ErrStateHistory02);
        ::boost::shared_ptr< ErrStateHistory02Get > payload (new ErrStateHistory02Get());
        CCA_MESSAGE(ccaMessage,header,ErrStateHistory02Get,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ErrStateHistory02", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ErrStateHistory02);
        ::boost::shared_ptr< ErrStateHistory02Error > payload (new ErrStateHistory02Error());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ErrStateHistory02Error,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ErrStateHistory02", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendErrStateHistory02Set(ErrStateHistory02CallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_ErrStateHistory02);
        ::boost::shared_ptr< ErrStateHistory02Set > payload (new ErrStateHistory02Set());
        CCA_MESSAGE(ccaMessage,header,ErrStateHistory02Set,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "ErrStateHistory02", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ErrStateHistory02);
        ::boost::shared_ptr< ErrStateHistory02Error > payload (new ErrStateHistory02Error());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ErrStateHistory02Error,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "ErrStateHistory02", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendErrStateHistory03UpReg(ErrStateHistory03CallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ErrStateHistory03);
        ::boost::shared_ptr< ErrStateHistory03UpReg > payload (new ErrStateHistory03UpReg());
        CCA_MESSAGE(ccaMessage,header,ErrStateHistory03UpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ErrStateHistory03RelUpReg > payloadRelUpRegHeap (new ErrStateHistory03RelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ErrStateHistory03, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::ErrStateHistory03RelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ErrStateHistory03, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ErrStateHistory03", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ErrStateHistory03", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasErrStateHistory03()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ErrStateHistory03, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ErrStateHistory03Status > payloadLoopback (new ErrStateHistory03Status(getErrStateHistory03()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ErrStateHistory03Status,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ErrStateHistory03);
        ::boost::shared_ptr< ErrStateHistory03Error > payload (new ErrStateHistory03Error());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ErrStateHistory03Error,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ErrStateHistory03", &cb);
    }
}

bool SPM_CORE_FIProxy::sendErrStateHistory03RelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ErrStateHistory03,"ErrStateHistory03");
}

void SPM_CORE_FIProxy::sendErrStateHistory03RelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ErrStateHistory03);
}

const ErrStateHistory03Status& SPM_CORE_FIProxy::getErrStateHistory03() const {
    return _errStateHistory03.get();
}

bool SPM_CORE_FIProxy::hasErrStateHistory03() const {
    return _errStateHistory03.hasValue();
}

act_t SPM_CORE_FIProxy::sendErrStateHistory03Get(ErrStateHistory03CallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ErrStateHistory03);
        ::boost::shared_ptr< ErrStateHistory03Get > payload (new ErrStateHistory03Get());
        CCA_MESSAGE(ccaMessage,header,ErrStateHistory03Get,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ErrStateHistory03", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ErrStateHistory03);
        ::boost::shared_ptr< ErrStateHistory03Error > payload (new ErrStateHistory03Error());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ErrStateHistory03Error,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ErrStateHistory03", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendErrStateHistory03Set(ErrStateHistory03CallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_ErrStateHistory03);
        ::boost::shared_ptr< ErrStateHistory03Set > payload (new ErrStateHistory03Set());
        CCA_MESSAGE(ccaMessage,header,ErrStateHistory03Set,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "ErrStateHistory03", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ErrStateHistory03);
        ::boost::shared_ptr< ErrStateHistory03Error > payload (new ErrStateHistory03Error());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ErrStateHistory03Error,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "ErrStateHistory03", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendErrStateHistory04UpReg(ErrStateHistory04CallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ErrStateHistory04);
        ::boost::shared_ptr< ErrStateHistory04UpReg > payload (new ErrStateHistory04UpReg());
        CCA_MESSAGE(ccaMessage,header,ErrStateHistory04UpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ErrStateHistory04RelUpReg > payloadRelUpRegHeap (new ErrStateHistory04RelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ErrStateHistory04, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::ErrStateHistory04RelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ErrStateHistory04, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ErrStateHistory04", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ErrStateHistory04", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasErrStateHistory04()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ErrStateHistory04, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ErrStateHistory04Status > payloadLoopback (new ErrStateHistory04Status(getErrStateHistory04()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ErrStateHistory04Status,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ErrStateHistory04);
        ::boost::shared_ptr< ErrStateHistory04Error > payload (new ErrStateHistory04Error());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ErrStateHistory04Error,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ErrStateHistory04", &cb);
    }
}

bool SPM_CORE_FIProxy::sendErrStateHistory04RelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ErrStateHistory04,"ErrStateHistory04");
}

void SPM_CORE_FIProxy::sendErrStateHistory04RelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ErrStateHistory04);
}

const ErrStateHistory04Status& SPM_CORE_FIProxy::getErrStateHistory04() const {
    return _errStateHistory04.get();
}

bool SPM_CORE_FIProxy::hasErrStateHistory04() const {
    return _errStateHistory04.hasValue();
}

act_t SPM_CORE_FIProxy::sendErrStateHistory04Get(ErrStateHistory04CallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ErrStateHistory04);
        ::boost::shared_ptr< ErrStateHistory04Get > payload (new ErrStateHistory04Get());
        CCA_MESSAGE(ccaMessage,header,ErrStateHistory04Get,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ErrStateHistory04", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ErrStateHistory04);
        ::boost::shared_ptr< ErrStateHistory04Error > payload (new ErrStateHistory04Error());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ErrStateHistory04Error,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ErrStateHistory04", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendErrStateHistory04Set(ErrStateHistory04CallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_ErrStateHistory04);
        ::boost::shared_ptr< ErrStateHistory04Set > payload (new ErrStateHistory04Set());
        CCA_MESSAGE(ccaMessage,header,ErrStateHistory04Set,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "ErrStateHistory04", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ErrStateHistory04);
        ::boost::shared_ptr< ErrStateHistory04Error > payload (new ErrStateHistory04Error());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ErrStateHistory04Error,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "ErrStateHistory04", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendErrStateHistory05UpReg(ErrStateHistory05CallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ErrStateHistory05);
        ::boost::shared_ptr< ErrStateHistory05UpReg > payload (new ErrStateHistory05UpReg());
        CCA_MESSAGE(ccaMessage,header,ErrStateHistory05UpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ErrStateHistory05RelUpReg > payloadRelUpRegHeap (new ErrStateHistory05RelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ErrStateHistory05, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::ErrStateHistory05RelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ErrStateHistory05, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ErrStateHistory05", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ErrStateHistory05", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasErrStateHistory05()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ErrStateHistory05, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ErrStateHistory05Status > payloadLoopback (new ErrStateHistory05Status(getErrStateHistory05()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ErrStateHistory05Status,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ErrStateHistory05);
        ::boost::shared_ptr< ErrStateHistory05Error > payload (new ErrStateHistory05Error());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ErrStateHistory05Error,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ErrStateHistory05", &cb);
    }
}

bool SPM_CORE_FIProxy::sendErrStateHistory05RelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ErrStateHistory05,"ErrStateHistory05");
}

void SPM_CORE_FIProxy::sendErrStateHistory05RelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ErrStateHistory05);
}

const ErrStateHistory05Status& SPM_CORE_FIProxy::getErrStateHistory05() const {
    return _errStateHistory05.get();
}

bool SPM_CORE_FIProxy::hasErrStateHistory05() const {
    return _errStateHistory05.hasValue();
}

act_t SPM_CORE_FIProxy::sendErrStateHistory05Get(ErrStateHistory05CallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ErrStateHistory05);
        ::boost::shared_ptr< ErrStateHistory05Get > payload (new ErrStateHistory05Get());
        CCA_MESSAGE(ccaMessage,header,ErrStateHistory05Get,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ErrStateHistory05", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ErrStateHistory05);
        ::boost::shared_ptr< ErrStateHistory05Error > payload (new ErrStateHistory05Error());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ErrStateHistory05Error,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ErrStateHistory05", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendErrStateHistory05Set(ErrStateHistory05CallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_ErrStateHistory05);
        ::boost::shared_ptr< ErrStateHistory05Set > payload (new ErrStateHistory05Set());
        CCA_MESSAGE(ccaMessage,header,ErrStateHistory05Set,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "ErrStateHistory05", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ErrStateHistory05);
        ::boost::shared_ptr< ErrStateHistory05Error > payload (new ErrStateHistory05Error());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ErrStateHistory05Error,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "ErrStateHistory05", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendSwitchOnHistoryUpReg(SwitchOnHistoryCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SwitchOnHistory);
        ::boost::shared_ptr< SwitchOnHistoryUpReg > payload (new SwitchOnHistoryUpReg());
        CCA_MESSAGE(ccaMessage,header,SwitchOnHistoryUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SwitchOnHistoryRelUpReg > payloadRelUpRegHeap (new SwitchOnHistoryRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SwitchOnHistory, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::SwitchOnHistoryRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SwitchOnHistory, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SwitchOnHistory", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SwitchOnHistory", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSwitchOnHistory()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SwitchOnHistory, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SwitchOnHistoryStatus > payloadLoopback (new SwitchOnHistoryStatus(getSwitchOnHistory()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SwitchOnHistoryStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SwitchOnHistory);
        ::boost::shared_ptr< SwitchOnHistoryError > payload (new SwitchOnHistoryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SwitchOnHistoryError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SwitchOnHistory", &cb);
    }
}

bool SPM_CORE_FIProxy::sendSwitchOnHistoryRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SwitchOnHistory,"SwitchOnHistory");
}

void SPM_CORE_FIProxy::sendSwitchOnHistoryRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SwitchOnHistory);
}

const SwitchOnHistoryStatus& SPM_CORE_FIProxy::getSwitchOnHistory() const {
    return _switchOnHistory.get();
}

bool SPM_CORE_FIProxy::hasSwitchOnHistory() const {
    return _switchOnHistory.hasValue();
}

act_t SPM_CORE_FIProxy::sendSwitchOnHistoryGet(SwitchOnHistoryCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SwitchOnHistory);
        ::boost::shared_ptr< SwitchOnHistoryGet > payload (new SwitchOnHistoryGet());
        CCA_MESSAGE(ccaMessage,header,SwitchOnHistoryGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SwitchOnHistory", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SwitchOnHistory);
        ::boost::shared_ptr< SwitchOnHistoryError > payload (new SwitchOnHistoryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SwitchOnHistoryError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SwitchOnHistory", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendSwitchOnHistorySet(SwitchOnHistoryCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SwitchOnHistory);
        ::boost::shared_ptr< SwitchOnHistorySet > payload (new SwitchOnHistorySet());
        CCA_MESSAGE(ccaMessage,header,SwitchOnHistorySet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SwitchOnHistory", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SwitchOnHistory);
        ::boost::shared_ptr< SwitchOnHistoryError > payload (new SwitchOnHistoryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SwitchOnHistoryError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SwitchOnHistory", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendDeviceOnCounterUpReg(DeviceOnCounterCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DeviceOnCounter);
        ::boost::shared_ptr< DeviceOnCounterUpReg > payload (new DeviceOnCounterUpReg());
        CCA_MESSAGE(ccaMessage,header,DeviceOnCounterUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DeviceOnCounterRelUpReg > payloadRelUpRegHeap (new DeviceOnCounterRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DeviceOnCounter, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::DeviceOnCounterRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DeviceOnCounter, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DeviceOnCounter", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DeviceOnCounter", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDeviceOnCounter()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DeviceOnCounter, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DeviceOnCounterStatus > payloadLoopback (new DeviceOnCounterStatus(getDeviceOnCounter()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DeviceOnCounterStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DeviceOnCounter);
        ::boost::shared_ptr< DeviceOnCounterError > payload (new DeviceOnCounterError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DeviceOnCounterError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DeviceOnCounter", &cb);
    }
}

bool SPM_CORE_FIProxy::sendDeviceOnCounterRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DeviceOnCounter,"DeviceOnCounter");
}

void SPM_CORE_FIProxy::sendDeviceOnCounterRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DeviceOnCounter);
}

const DeviceOnCounterStatus& SPM_CORE_FIProxy::getDeviceOnCounter() const {
    return _deviceOnCounter.get();
}

bool SPM_CORE_FIProxy::hasDeviceOnCounter() const {
    return _deviceOnCounter.hasValue();
}

act_t SPM_CORE_FIProxy::sendDeviceOnCounterGet(DeviceOnCounterCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DeviceOnCounter);
        ::boost::shared_ptr< DeviceOnCounterGet > payload (new DeviceOnCounterGet());
        CCA_MESSAGE(ccaMessage,header,DeviceOnCounterGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DeviceOnCounter", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DeviceOnCounter);
        ::boost::shared_ptr< DeviceOnCounterError > payload (new DeviceOnCounterError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DeviceOnCounterError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DeviceOnCounter", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendVoltageEventCounterUpReg(VoltageEventCounterCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_VoltageEventCounter);
        ::boost::shared_ptr< VoltageEventCounterUpReg > payload (new VoltageEventCounterUpReg());
        CCA_MESSAGE(ccaMessage,header,VoltageEventCounterUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< VoltageEventCounterRelUpReg > payloadRelUpRegHeap (new VoltageEventCounterRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_VoltageEventCounter, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::VoltageEventCounterRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_VoltageEventCounter, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "VoltageEventCounter", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "VoltageEventCounter", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasVoltageEventCounter()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_VoltageEventCounter, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< VoltageEventCounterStatus > payloadLoopback (new VoltageEventCounterStatus(getVoltageEventCounter()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,VoltageEventCounterStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_VoltageEventCounter);
        ::boost::shared_ptr< VoltageEventCounterError > payload (new VoltageEventCounterError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VoltageEventCounterError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "VoltageEventCounter", &cb);
    }
}

bool SPM_CORE_FIProxy::sendVoltageEventCounterRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_VoltageEventCounter,"VoltageEventCounter");
}

void SPM_CORE_FIProxy::sendVoltageEventCounterRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_VoltageEventCounter);
}

const VoltageEventCounterStatus& SPM_CORE_FIProxy::getVoltageEventCounter() const {
    return _voltageEventCounter.get();
}

bool SPM_CORE_FIProxy::hasVoltageEventCounter() const {
    return _voltageEventCounter.hasValue();
}

act_t SPM_CORE_FIProxy::sendVoltageEventCounterGet(VoltageEventCounterCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_VoltageEventCounter);
        ::boost::shared_ptr< VoltageEventCounterGet > payload (new VoltageEventCounterGet());
        CCA_MESSAGE(ccaMessage,header,VoltageEventCounterGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "VoltageEventCounter", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_VoltageEventCounter);
        ::boost::shared_ptr< VoltageEventCounterError > payload (new VoltageEventCounterError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VoltageEventCounterError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "VoltageEventCounter", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendVoltageRangeHistogramUpReg(VoltageRangeHistogramCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_VoltageRangeHistogram);
        ::boost::shared_ptr< VoltageRangeHistogramUpReg > payload (new VoltageRangeHistogramUpReg());
        CCA_MESSAGE(ccaMessage,header,VoltageRangeHistogramUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< VoltageRangeHistogramRelUpReg > payloadRelUpRegHeap (new VoltageRangeHistogramRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_VoltageRangeHistogram, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::VoltageRangeHistogramRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_VoltageRangeHistogram, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "VoltageRangeHistogram", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "VoltageRangeHistogram", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasVoltageRangeHistogram()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_VoltageRangeHistogram, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< VoltageRangeHistogramStatus > payloadLoopback (new VoltageRangeHistogramStatus(getVoltageRangeHistogram()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,VoltageRangeHistogramStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_VoltageRangeHistogram);
        ::boost::shared_ptr< VoltageRangeHistogramError > payload (new VoltageRangeHistogramError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VoltageRangeHistogramError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "VoltageRangeHistogram", &cb);
    }
}

bool SPM_CORE_FIProxy::sendVoltageRangeHistogramRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_VoltageRangeHistogram,"VoltageRangeHistogram");
}

void SPM_CORE_FIProxy::sendVoltageRangeHistogramRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_VoltageRangeHistogram);
}

const VoltageRangeHistogramStatus& SPM_CORE_FIProxy::getVoltageRangeHistogram() const {
    return _voltageRangeHistogram.get();
}

bool SPM_CORE_FIProxy::hasVoltageRangeHistogram() const {
    return _voltageRangeHistogram.hasValue();
}

act_t SPM_CORE_FIProxy::sendVoltageRangeHistogramGet(VoltageRangeHistogramCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_VoltageRangeHistogram);
        ::boost::shared_ptr< VoltageRangeHistogramGet > payload (new VoltageRangeHistogramGet());
        CCA_MESSAGE(ccaMessage,header,VoltageRangeHistogramGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "VoltageRangeHistogram", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_VoltageRangeHistogram);
        ::boost::shared_ptr< VoltageRangeHistogramError > payload (new VoltageRangeHistogramError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VoltageRangeHistogramError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "VoltageRangeHistogram", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendCpuUsageStatisticUpReg(CpuUsageStatisticCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_CpuUsageStatistic);
        ::boost::shared_ptr< CpuUsageStatisticUpReg > payload (new CpuUsageStatisticUpReg());
        CCA_MESSAGE(ccaMessage,header,CpuUsageStatisticUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< CpuUsageStatisticRelUpReg > payloadRelUpRegHeap (new CpuUsageStatisticRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_CpuUsageStatistic, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::CpuUsageStatisticRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_CpuUsageStatistic, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "CpuUsageStatistic", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "CpuUsageStatistic", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasCpuUsageStatistic()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_CpuUsageStatistic, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< CpuUsageStatisticStatus > payloadLoopback (new CpuUsageStatisticStatus(getCpuUsageStatistic()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,CpuUsageStatisticStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CpuUsageStatistic);
        ::boost::shared_ptr< CpuUsageStatisticError > payload (new CpuUsageStatisticError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CpuUsageStatisticError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "CpuUsageStatistic", &cb);
    }
}

bool SPM_CORE_FIProxy::sendCpuUsageStatisticRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_CpuUsageStatistic,"CpuUsageStatistic");
}

void SPM_CORE_FIProxy::sendCpuUsageStatisticRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_CpuUsageStatistic);
}

const CpuUsageStatisticStatus& SPM_CORE_FIProxy::getCpuUsageStatistic() const {
    return _cpuUsageStatistic.get();
}

bool SPM_CORE_FIProxy::hasCpuUsageStatistic() const {
    return _cpuUsageStatistic.hasValue();
}

act_t SPM_CORE_FIProxy::sendCpuUsageStatisticGet(CpuUsageStatisticCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_CpuUsageStatistic);
        ::boost::shared_ptr< CpuUsageStatisticGet > payload (new CpuUsageStatisticGet());
        CCA_MESSAGE(ccaMessage,header,CpuUsageStatisticGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "CpuUsageStatistic", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CpuUsageStatistic);
        ::boost::shared_ptr< CpuUsageStatisticError > payload (new CpuUsageStatisticError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CpuUsageStatisticError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "CpuUsageStatistic", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendRamUsageStatisticUpReg(RamUsageStatisticCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_RamUsageStatistic);
        ::boost::shared_ptr< RamUsageStatisticUpReg > payload (new RamUsageStatisticUpReg());
        CCA_MESSAGE(ccaMessage,header,RamUsageStatisticUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< RamUsageStatisticRelUpReg > payloadRelUpRegHeap (new RamUsageStatisticRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_RamUsageStatistic, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::RamUsageStatisticRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_RamUsageStatistic, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "RamUsageStatistic", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "RamUsageStatistic", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasRamUsageStatistic()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_RamUsageStatistic, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< RamUsageStatisticStatus > payloadLoopback (new RamUsageStatisticStatus(getRamUsageStatistic()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,RamUsageStatisticStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RamUsageStatistic);
        ::boost::shared_ptr< RamUsageStatisticError > payload (new RamUsageStatisticError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RamUsageStatisticError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "RamUsageStatistic", &cb);
    }
}

bool SPM_CORE_FIProxy::sendRamUsageStatisticRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_RamUsageStatistic,"RamUsageStatistic");
}

void SPM_CORE_FIProxy::sendRamUsageStatisticRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_RamUsageStatistic);
}

const RamUsageStatisticStatus& SPM_CORE_FIProxy::getRamUsageStatistic() const {
    return _ramUsageStatistic.get();
}

bool SPM_CORE_FIProxy::hasRamUsageStatistic() const {
    return _ramUsageStatistic.hasValue();
}

act_t SPM_CORE_FIProxy::sendRamUsageStatisticGet(RamUsageStatisticCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_RamUsageStatistic);
        ::boost::shared_ptr< RamUsageStatisticGet > payload (new RamUsageStatisticGet());
        CCA_MESSAGE(ccaMessage,header,RamUsageStatisticGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "RamUsageStatistic", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RamUsageStatistic);
        ::boost::shared_ptr< RamUsageStatisticError > payload (new RamUsageStatisticError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RamUsageStatisticError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "RamUsageStatistic", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendStartupTimeStatisticUpReg(StartupTimeStatisticCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_StartupTimeStatistic);
        ::boost::shared_ptr< StartupTimeStatisticUpReg > payload (new StartupTimeStatisticUpReg());
        CCA_MESSAGE(ccaMessage,header,StartupTimeStatisticUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< StartupTimeStatisticRelUpReg > payloadRelUpRegHeap (new StartupTimeStatisticRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_StartupTimeStatistic, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::StartupTimeStatisticRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_StartupTimeStatistic, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "StartupTimeStatistic", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "StartupTimeStatistic", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasStartupTimeStatistic()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_StartupTimeStatistic, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< StartupTimeStatisticStatus > payloadLoopback (new StartupTimeStatisticStatus(getStartupTimeStatistic()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,StartupTimeStatisticStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StartupTimeStatistic);
        ::boost::shared_ptr< StartupTimeStatisticError > payload (new StartupTimeStatisticError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StartupTimeStatisticError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "StartupTimeStatistic", &cb);
    }
}

bool SPM_CORE_FIProxy::sendStartupTimeStatisticRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_StartupTimeStatistic,"StartupTimeStatistic");
}

void SPM_CORE_FIProxy::sendStartupTimeStatisticRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_StartupTimeStatistic);
}

const StartupTimeStatisticStatus& SPM_CORE_FIProxy::getStartupTimeStatistic() const {
    return _startupTimeStatistic.get();
}

bool SPM_CORE_FIProxy::hasStartupTimeStatistic() const {
    return _startupTimeStatistic.hasValue();
}

act_t SPM_CORE_FIProxy::sendStartupTimeStatisticGet(StartupTimeStatisticCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_StartupTimeStatistic);
        ::boost::shared_ptr< StartupTimeStatisticGet > payload (new StartupTimeStatisticGet());
        CCA_MESSAGE(ccaMessage,header,StartupTimeStatisticGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "StartupTimeStatistic", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StartupTimeStatistic);
        ::boost::shared_ptr< StartupTimeStatisticError > payload (new StartupTimeStatisticError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StartupTimeStatisticError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "StartupTimeStatistic", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendSWVersionStatisticUpReg(SWVersionStatisticCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SWVersionStatistic);
        ::boost::shared_ptr< SWVersionStatisticUpReg > payload (new SWVersionStatisticUpReg());
        CCA_MESSAGE(ccaMessage,header,SWVersionStatisticUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SWVersionStatisticRelUpReg > payloadRelUpRegHeap (new SWVersionStatisticRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SWVersionStatistic, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::SWVersionStatisticRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SWVersionStatistic, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SWVersionStatistic", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SWVersionStatistic", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSWVersionStatistic()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SWVersionStatistic, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SWVersionStatisticStatus > payloadLoopback (new SWVersionStatisticStatus(getSWVersionStatistic()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SWVersionStatisticStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SWVersionStatistic);
        ::boost::shared_ptr< SWVersionStatisticError > payload (new SWVersionStatisticError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SWVersionStatisticError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SWVersionStatistic", &cb);
    }
}

bool SPM_CORE_FIProxy::sendSWVersionStatisticRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SWVersionStatistic,"SWVersionStatistic");
}

void SPM_CORE_FIProxy::sendSWVersionStatisticRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SWVersionStatistic);
}

const SWVersionStatisticStatus& SPM_CORE_FIProxy::getSWVersionStatistic() const {
    return _sWVersionStatistic.get();
}

bool SPM_CORE_FIProxy::hasSWVersionStatistic() const {
    return _sWVersionStatistic.hasValue();
}

act_t SPM_CORE_FIProxy::sendSWVersionStatisticGet(SWVersionStatisticCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SWVersionStatistic);
        ::boost::shared_ptr< SWVersionStatisticGet > payload (new SWVersionStatisticGet());
        CCA_MESSAGE(ccaMessage,header,SWVersionStatisticGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SWVersionStatistic", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SWVersionStatistic);
        ::boost::shared_ptr< SWVersionStatisticError > payload (new SWVersionStatisticError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SWVersionStatisticError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SWVersionStatistic", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendRunlevelStateUpReg(RunlevelStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_RunlevelState);
        ::boost::shared_ptr< RunlevelStateUpReg > payload (new RunlevelStateUpReg());
        CCA_MESSAGE(ccaMessage,header,RunlevelStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< RunlevelStateRelUpReg > payloadRelUpRegHeap (new RunlevelStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_RunlevelState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::RunlevelStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_RunlevelState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "RunlevelState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "RunlevelState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasRunlevelState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_RunlevelState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< RunlevelStateStatus > payloadLoopback (new RunlevelStateStatus(getRunlevelState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,RunlevelStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RunlevelState);
        ::boost::shared_ptr< RunlevelStateError > payload (new RunlevelStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RunlevelStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "RunlevelState", &cb);
    }
}

bool SPM_CORE_FIProxy::sendRunlevelStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_RunlevelState,"RunlevelState");
}

void SPM_CORE_FIProxy::sendRunlevelStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_RunlevelState);
}

const RunlevelStateStatus& SPM_CORE_FIProxy::getRunlevelState() const {
    return _runlevelState.get();
}

bool SPM_CORE_FIProxy::hasRunlevelState() const {
    return _runlevelState.hasValue();
}

act_t SPM_CORE_FIProxy::sendRunlevelStateGet(RunlevelStateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_RunlevelState);
        ::boost::shared_ptr< RunlevelStateGet > payload (new RunlevelStateGet());
        CCA_MESSAGE(ccaMessage,header,RunlevelStateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "RunlevelState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RunlevelState);
        ::boost::shared_ptr< RunlevelStateError > payload (new RunlevelStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RunlevelStateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "RunlevelState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendRestartUpReg(RestartCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Restart);
        ::boost::shared_ptr< RestartUpReg > payload (new RestartUpReg());
        CCA_MESSAGE(ccaMessage,header,RestartUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< RestartRelUpReg > payloadRelUpRegHeap (new RestartRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Restart, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::RestartRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Restart, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Restart", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Restart", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasRestart()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Restart, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< RestartStatus > payloadLoopback (new RestartStatus(getRestart()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,RestartStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Restart);
        ::boost::shared_ptr< RestartError > payload (new RestartError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RestartError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Restart", &cb);
    }
}

bool SPM_CORE_FIProxy::sendRestartRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Restart,"Restart");
}

void SPM_CORE_FIProxy::sendRestartRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Restart);
}

const RestartStatus& SPM_CORE_FIProxy::getRestart() const {
    return _restart.get();
}

bool SPM_CORE_FIProxy::hasRestart() const {
    return _restart.hasValue();
}

act_t SPM_CORE_FIProxy::sendRestartGet(RestartCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Restart);
        ::boost::shared_ptr< RestartGet > payload (new RestartGet());
        CCA_MESSAGE(ccaMessage,header,RestartGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Restart", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Restart);
        ::boost::shared_ptr< RestartError > payload (new RestartError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RestartError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Restart", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendRestartSet(RestartCallbackIF& cb, ::spm_core_fi_types::T_SPM_e32_RESTART_TYPE restart) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_Restart);
        ::boost::shared_ptr< RestartSet > payload (new RestartSet());
        payload->setRestart(restart);
        CCA_MESSAGE(ccaMessage,header,RestartSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "Restart", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Restart);
        ::boost::shared_ptr< RestartError > payload (new RestartError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RestartError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "Restart", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendLifesignUpReg(LifesignCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Lifesign);
        ::boost::shared_ptr< LifesignUpReg > payload (new LifesignUpReg());
        CCA_MESSAGE(ccaMessage,header,LifesignUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< LifesignRelUpReg > payloadRelUpRegHeap (new LifesignRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Lifesign, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::LifesignRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Lifesign, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Lifesign", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Lifesign", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasLifesign()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Lifesign, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< LifesignStatus > payloadLoopback (new LifesignStatus(getLifesign()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,LifesignStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Lifesign);
        ::boost::shared_ptr< LifesignError > payload (new LifesignError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,LifesignError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Lifesign", &cb);
    }
}

bool SPM_CORE_FIProxy::sendLifesignRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Lifesign,"Lifesign");
}

void SPM_CORE_FIProxy::sendLifesignRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Lifesign);
}

const LifesignStatus& SPM_CORE_FIProxy::getLifesign() const {
    return _lifesign.get();
}

bool SPM_CORE_FIProxy::hasLifesign() const {
    return _lifesign.hasValue();
}

act_t SPM_CORE_FIProxy::sendLifesignGet(LifesignCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Lifesign);
        ::boost::shared_ptr< LifesignGet > payload (new LifesignGet());
        CCA_MESSAGE(ccaMessage,header,LifesignGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Lifesign", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Lifesign);
        ::boost::shared_ptr< LifesignError > payload (new LifesignError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,LifesignError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Lifesign", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendHmiStateUpReg(HmiStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_HmiState);
        ::boost::shared_ptr< HmiStateUpReg > payload (new HmiStateUpReg());
        CCA_MESSAGE(ccaMessage,header,HmiStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< HmiStateRelUpReg > payloadRelUpRegHeap (new HmiStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_HmiState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::HmiStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_HmiState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "HmiState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "HmiState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasHmiState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_HmiState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< HmiStateStatus > payloadLoopback (new HmiStateStatus(getHmiState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,HmiStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_HmiState);
        ::boost::shared_ptr< HmiStateError > payload (new HmiStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,HmiStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "HmiState", &cb);
    }
}

bool SPM_CORE_FIProxy::sendHmiStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_HmiState,"HmiState");
}

void SPM_CORE_FIProxy::sendHmiStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_HmiState);
}

const HmiStateStatus& SPM_CORE_FIProxy::getHmiState() const {
    return _hmiState.get();
}

bool SPM_CORE_FIProxy::hasHmiState() const {
    return _hmiState.hasValue();
}

act_t SPM_CORE_FIProxy::sendHmiStateGet(HmiStateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_HmiState);
        ::boost::shared_ptr< HmiStateGet > payload (new HmiStateGet());
        CCA_MESSAGE(ccaMessage,header,HmiStateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "HmiState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_HmiState);
        ::boost::shared_ptr< HmiStateError > payload (new HmiStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,HmiStateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "HmiState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendSystemPowerBehaviourUpReg(SystemPowerBehaviourCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SystemPowerBehaviour);
        ::boost::shared_ptr< SystemPowerBehaviourUpReg > payload (new SystemPowerBehaviourUpReg());
        CCA_MESSAGE(ccaMessage,header,SystemPowerBehaviourUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SystemPowerBehaviourRelUpReg > payloadRelUpRegHeap (new SystemPowerBehaviourRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SystemPowerBehaviour, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::SystemPowerBehaviourRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SystemPowerBehaviour, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SystemPowerBehaviour", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SystemPowerBehaviour", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSystemPowerBehaviour()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SystemPowerBehaviour, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SystemPowerBehaviourStatus > payloadLoopback (new SystemPowerBehaviourStatus(getSystemPowerBehaviour()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SystemPowerBehaviourStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SystemPowerBehaviour);
        ::boost::shared_ptr< SystemPowerBehaviourError > payload (new SystemPowerBehaviourError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SystemPowerBehaviourError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SystemPowerBehaviour", &cb);
    }
}

bool SPM_CORE_FIProxy::sendSystemPowerBehaviourRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SystemPowerBehaviour,"SystemPowerBehaviour");
}

void SPM_CORE_FIProxy::sendSystemPowerBehaviourRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SystemPowerBehaviour);
}

const SystemPowerBehaviourStatus& SPM_CORE_FIProxy::getSystemPowerBehaviour() const {
    return _systemPowerBehaviour.get();
}

bool SPM_CORE_FIProxy::hasSystemPowerBehaviour() const {
    return _systemPowerBehaviour.hasValue();
}

act_t SPM_CORE_FIProxy::sendSystemPowerBehaviourGet(SystemPowerBehaviourCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SystemPowerBehaviour);
        ::boost::shared_ptr< SystemPowerBehaviourGet > payload (new SystemPowerBehaviourGet());
        CCA_MESSAGE(ccaMessage,header,SystemPowerBehaviourGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SystemPowerBehaviour", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SystemPowerBehaviour);
        ::boost::shared_ptr< SystemPowerBehaviourError > payload (new SystemPowerBehaviourError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SystemPowerBehaviourError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SystemPowerBehaviour", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendDimStateUpReg(DimStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DimState);
        ::boost::shared_ptr< DimStateUpReg > payload (new DimStateUpReg());
        CCA_MESSAGE(ccaMessage,header,DimStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DimStateRelUpReg > payloadRelUpRegHeap (new DimStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DimState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::DimStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DimState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DimState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DimState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDimState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DimState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DimStateStatus > payloadLoopback (new DimStateStatus(getDimState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DimStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DimState);
        ::boost::shared_ptr< DimStateError > payload (new DimStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DimStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DimState", &cb);
    }
}

bool SPM_CORE_FIProxy::sendDimStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DimState,"DimState");
}

void SPM_CORE_FIProxy::sendDimStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DimState);
}

const DimStateStatus& SPM_CORE_FIProxy::getDimState() const {
    return _dimState.get();
}

bool SPM_CORE_FIProxy::hasDimState() const {
    return _dimState.hasValue();
}

act_t SPM_CORE_FIProxy::sendDimStateGet(DimStateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DimState);
        ::boost::shared_ptr< DimStateGet > payload (new DimStateGet());
        CCA_MESSAGE(ccaMessage,header,DimStateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DimState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DimState);
        ::boost::shared_ptr< DimStateError > payload (new DimStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DimStateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DimState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendDimmingStateUpReg(DimmingStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DimmingState);
        ::boost::shared_ptr< DimmingStateUpReg > payload (new DimmingStateUpReg());
        CCA_MESSAGE(ccaMessage,header,DimmingStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DimmingStateRelUpReg > payloadRelUpRegHeap (new DimmingStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DimmingState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::DimmingStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DimmingState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DimmingState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DimmingState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDimmingState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DimmingState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DimmingStateStatus > payloadLoopback (new DimmingStateStatus(getDimmingState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DimmingStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DimmingState);
        ::boost::shared_ptr< DimmingStateError > payload (new DimmingStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DimmingStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DimmingState", &cb);
    }
}

bool SPM_CORE_FIProxy::sendDimmingStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DimmingState,"DimmingState");
}

void SPM_CORE_FIProxy::sendDimmingStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DimmingState);
}

const DimmingStateStatus& SPM_CORE_FIProxy::getDimmingState() const {
    return _dimmingState.get();
}

bool SPM_CORE_FIProxy::hasDimmingState() const {
    return _dimmingState.hasValue();
}

act_t SPM_CORE_FIProxy::sendDimmingStateGet(DimmingStateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DimmingState);
        ::boost::shared_ptr< DimmingStateGet > payload (new DimmingStateGet());
        CCA_MESSAGE(ccaMessage,header,DimmingStateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DimmingState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DimmingState);
        ::boost::shared_ptr< DimmingStateError > payload (new DimmingStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DimmingStateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DimmingState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendBluetoothStateUpReg(BluetoothStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_BluetoothState);
        ::boost::shared_ptr< BluetoothStateUpReg > payload (new BluetoothStateUpReg());
        CCA_MESSAGE(ccaMessage,header,BluetoothStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< BluetoothStateRelUpReg > payloadRelUpRegHeap (new BluetoothStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_BluetoothState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::BluetoothStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_BluetoothState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "BluetoothState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "BluetoothState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasBluetoothState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_BluetoothState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< BluetoothStateStatus > payloadLoopback (new BluetoothStateStatus(getBluetoothState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,BluetoothStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_BluetoothState);
        ::boost::shared_ptr< BluetoothStateError > payload (new BluetoothStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,BluetoothStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "BluetoothState", &cb);
    }
}

bool SPM_CORE_FIProxy::sendBluetoothStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_BluetoothState,"BluetoothState");
}

void SPM_CORE_FIProxy::sendBluetoothStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_BluetoothState);
}

const BluetoothStateStatus& SPM_CORE_FIProxy::getBluetoothState() const {
    return _bluetoothState.get();
}

bool SPM_CORE_FIProxy::hasBluetoothState() const {
    return _bluetoothState.hasValue();
}

act_t SPM_CORE_FIProxy::sendBluetoothStateGet(BluetoothStateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_BluetoothState);
        ::boost::shared_ptr< BluetoothStateGet > payload (new BluetoothStateGet());
        CCA_MESSAGE(ccaMessage,header,BluetoothStateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "BluetoothState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_BluetoothState);
        ::boost::shared_ptr< BluetoothStateError > payload (new BluetoothStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,BluetoothStateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "BluetoothState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendAudioStateUpReg(AudioStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AudioState);
        ::boost::shared_ptr< AudioStateUpReg > payload (new AudioStateUpReg());
        CCA_MESSAGE(ccaMessage,header,AudioStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AudioStateRelUpReg > payloadRelUpRegHeap (new AudioStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AudioState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::AudioStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AudioState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AudioState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AudioState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAudioState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AudioState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AudioStateStatus > payloadLoopback (new AudioStateStatus(getAudioState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AudioStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AudioState);
        ::boost::shared_ptr< AudioStateError > payload (new AudioStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AudioStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AudioState", &cb);
    }
}

bool SPM_CORE_FIProxy::sendAudioStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AudioState,"AudioState");
}

void SPM_CORE_FIProxy::sendAudioStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AudioState);
}

const AudioStateStatus& SPM_CORE_FIProxy::getAudioState() const {
    return _audioState.get();
}

bool SPM_CORE_FIProxy::hasAudioState() const {
    return _audioState.hasValue();
}

act_t SPM_CORE_FIProxy::sendAudioStateGet(AudioStateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_AudioState);
        ::boost::shared_ptr< AudioStateGet > payload (new AudioStateGet());
        CCA_MESSAGE(ccaMessage,header,AudioStateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "AudioState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AudioState);
        ::boost::shared_ptr< AudioStateError > payload (new AudioStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AudioStateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "AudioState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendSpiStateUpReg(SpiStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SpiState);
        ::boost::shared_ptr< SpiStateUpReg > payload (new SpiStateUpReg());
        CCA_MESSAGE(ccaMessage,header,SpiStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SpiStateRelUpReg > payloadRelUpRegHeap (new SpiStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SpiState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::SpiStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SpiState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SpiState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SpiState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSpiState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SpiState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SpiStateStatus > payloadLoopback (new SpiStateStatus(getSpiState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SpiStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SpiState);
        ::boost::shared_ptr< SpiStateError > payload (new SpiStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SpiStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SpiState", &cb);
    }
}

bool SPM_CORE_FIProxy::sendSpiStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SpiState,"SpiState");
}

void SPM_CORE_FIProxy::sendSpiStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SpiState);
}

const SpiStateStatus& SPM_CORE_FIProxy::getSpiState() const {
    return _spiState.get();
}

bool SPM_CORE_FIProxy::hasSpiState() const {
    return _spiState.hasValue();
}

act_t SPM_CORE_FIProxy::sendSpiStateGet(SpiStateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SpiState);
        ::boost::shared_ptr< SpiStateGet > payload (new SpiStateGet());
        CCA_MESSAGE(ccaMessage,header,SpiStateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SpiState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SpiState);
        ::boost::shared_ptr< SpiStateError > payload (new SpiStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SpiStateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SpiState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendTunerStateUpReg(TunerStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_TunerState);
        ::boost::shared_ptr< TunerStateUpReg > payload (new TunerStateUpReg());
        CCA_MESSAGE(ccaMessage,header,TunerStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< TunerStateRelUpReg > payloadRelUpRegHeap (new TunerStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_TunerState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::TunerStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_TunerState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "TunerState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "TunerState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasTunerState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_TunerState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< TunerStateStatus > payloadLoopback (new TunerStateStatus(getTunerState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,TunerStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TunerState);
        ::boost::shared_ptr< TunerStateError > payload (new TunerStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TunerStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "TunerState", &cb);
    }
}

bool SPM_CORE_FIProxy::sendTunerStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_TunerState,"TunerState");
}

void SPM_CORE_FIProxy::sendTunerStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_TunerState);
}

const TunerStateStatus& SPM_CORE_FIProxy::getTunerState() const {
    return _tunerState.get();
}

bool SPM_CORE_FIProxy::hasTunerState() const {
    return _tunerState.hasValue();
}

act_t SPM_CORE_FIProxy::sendTunerStateGet(TunerStateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_TunerState);
        ::boost::shared_ptr< TunerStateGet > payload (new TunerStateGet());
        CCA_MESSAGE(ccaMessage,header,TunerStateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "TunerState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TunerState);
        ::boost::shared_ptr< TunerStateError > payload (new TunerStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TunerStateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "TunerState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendWifiStateUpReg(WifiStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_WifiState);
        ::boost::shared_ptr< WifiStateUpReg > payload (new WifiStateUpReg());
        CCA_MESSAGE(ccaMessage,header,WifiStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< WifiStateRelUpReg > payloadRelUpRegHeap (new WifiStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_WifiState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::WifiStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_WifiState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "WifiState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "WifiState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasWifiState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_WifiState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< WifiStateStatus > payloadLoopback (new WifiStateStatus(getWifiState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,WifiStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_WifiState);
        ::boost::shared_ptr< WifiStateError > payload (new WifiStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,WifiStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "WifiState", &cb);
    }
}

bool SPM_CORE_FIProxy::sendWifiStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_WifiState,"WifiState");
}

void SPM_CORE_FIProxy::sendWifiStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_WifiState);
}

const WifiStateStatus& SPM_CORE_FIProxy::getWifiState() const {
    return _wifiState.get();
}

bool SPM_CORE_FIProxy::hasWifiState() const {
    return _wifiState.hasValue();
}

act_t SPM_CORE_FIProxy::sendWifiStateGet(WifiStateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_WifiState);
        ::boost::shared_ptr< WifiStateGet > payload (new WifiStateGet());
        CCA_MESSAGE(ccaMessage,header,WifiStateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "WifiState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_WifiState);
        ::boost::shared_ptr< WifiStateError > payload (new WifiStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,WifiStateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "WifiState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendOnOffReasonUpReg(OnOffReasonCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_OnOffReason);
        ::boost::shared_ptr< OnOffReasonUpReg > payload (new OnOffReasonUpReg());
        CCA_MESSAGE(ccaMessage,header,OnOffReasonUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< OnOffReasonRelUpReg > payloadRelUpRegHeap (new OnOffReasonRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_OnOffReason, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::OnOffReasonRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_OnOffReason, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "OnOffReason", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "OnOffReason", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasOnOffReason()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_OnOffReason, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< OnOffReasonStatus > payloadLoopback (new OnOffReasonStatus(getOnOffReason()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,OnOffReasonStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_OnOffReason);
        ::boost::shared_ptr< OnOffReasonError > payload (new OnOffReasonError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,OnOffReasonError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "OnOffReason", &cb);
    }
}

bool SPM_CORE_FIProxy::sendOnOffReasonRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_OnOffReason,"OnOffReason");
}

void SPM_CORE_FIProxy::sendOnOffReasonRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_OnOffReason);
}

const OnOffReasonStatus& SPM_CORE_FIProxy::getOnOffReason() const {
    return _onOffReason.get();
}

bool SPM_CORE_FIProxy::hasOnOffReason() const {
    return _onOffReason.hasValue();
}

act_t SPM_CORE_FIProxy::sendOnOffReasonGet(OnOffReasonCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_OnOffReason);
        ::boost::shared_ptr< OnOffReasonGet > payload (new OnOffReasonGet());
        CCA_MESSAGE(ccaMessage,header,OnOffReasonGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "OnOffReason", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_OnOffReason);
        ::boost::shared_ptr< OnOffReasonError > payload (new OnOffReasonError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,OnOffReasonError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "OnOffReason", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendOnOffReasonSet(OnOffReasonCallbackIF& cb, ::spm_core_fi_types::T_SPM_e32_OnOffReason onOffReason) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_OnOffReason);
        ::boost::shared_ptr< OnOffReasonSet > payload (new OnOffReasonSet());
        payload->setOnOffReason(onOffReason);
        CCA_MESSAGE(ccaMessage,header,OnOffReasonSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "OnOffReason", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_OnOffReason);
        ::boost::shared_ptr< OnOffReasonError > payload (new OnOffReasonError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,OnOffReasonError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "OnOffReason", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendWakeupListUpReg(WakeupListCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_WakeupList);
        ::boost::shared_ptr< WakeupListUpReg > payload (new WakeupListUpReg());
        CCA_MESSAGE(ccaMessage,header,WakeupListUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< WakeupListRelUpReg > payloadRelUpRegHeap (new WakeupListRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_WakeupList, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::WakeupListRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_WakeupList, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "WakeupList", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "WakeupList", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasWakeupList()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_WakeupList, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< WakeupListStatus > payloadLoopback (new WakeupListStatus(getWakeupList()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,WakeupListStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_WakeupList);
        ::boost::shared_ptr< WakeupListError > payload (new WakeupListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,WakeupListError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "WakeupList", &cb);
    }
}

bool SPM_CORE_FIProxy::sendWakeupListRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_WakeupList,"WakeupList");
}

void SPM_CORE_FIProxy::sendWakeupListRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_WakeupList);
}

const WakeupListStatus& SPM_CORE_FIProxy::getWakeupList() const {
    return _wakeupList.get();
}

bool SPM_CORE_FIProxy::hasWakeupList() const {
    return _wakeupList.hasValue();
}

act_t SPM_CORE_FIProxy::sendWakeupListGet(WakeupListCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_WakeupList);
        ::boost::shared_ptr< WakeupListGet > payload (new WakeupListGet());
        CCA_MESSAGE(ccaMessage,header,WakeupListGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "WakeupList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_WakeupList);
        ::boost::shared_ptr< WakeupListError > payload (new WakeupListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,WakeupListError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "WakeupList", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendWakeupListSet(WakeupListCallbackIF& cb, uint32 wakeupList) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_WakeupList);
        ::boost::shared_ptr< WakeupListSet > payload (new WakeupListSet());
        payload->setWakeupList(wakeupList);
        CCA_MESSAGE(ccaMessage,header,WakeupListSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "WakeupList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_WakeupList);
        ::boost::shared_ptr< WakeupListError > payload (new WakeupListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,WakeupListError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "WakeupList", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendStartupFinishedUpReg(StartupFinishedCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_StartupFinished);
        ::boost::shared_ptr< StartupFinishedUpReg > payload (new StartupFinishedUpReg());
        CCA_MESSAGE(ccaMessage,header,StartupFinishedUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< StartupFinishedRelUpReg > payloadRelUpRegHeap (new StartupFinishedRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_StartupFinished, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::StartupFinishedRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_StartupFinished, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "StartupFinished", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "StartupFinished", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasStartupFinished()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_StartupFinished, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< StartupFinishedStatus > payloadLoopback (new StartupFinishedStatus(getStartupFinished()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,StartupFinishedStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StartupFinished);
        ::boost::shared_ptr< StartupFinishedError > payload (new StartupFinishedError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StartupFinishedError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "StartupFinished", &cb);
    }
}

bool SPM_CORE_FIProxy::sendStartupFinishedRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_StartupFinished,"StartupFinished");
}

void SPM_CORE_FIProxy::sendStartupFinishedRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_StartupFinished);
}

const StartupFinishedStatus& SPM_CORE_FIProxy::getStartupFinished() const {
    return _startupFinished.get();
}

bool SPM_CORE_FIProxy::hasStartupFinished() const {
    return _startupFinished.hasValue();
}

act_t SPM_CORE_FIProxy::sendStartupFinishedGet(StartupFinishedCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_StartupFinished);
        ::boost::shared_ptr< StartupFinishedGet > payload (new StartupFinishedGet());
        CCA_MESSAGE(ccaMessage,header,StartupFinishedGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "StartupFinished", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StartupFinished);
        ::boost::shared_ptr< StartupFinishedError > payload (new StartupFinishedError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StartupFinishedError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "StartupFinished", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendSysStateUpReg(SysStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SysState);
        ::boost::shared_ptr< SysStateUpReg > payload (new SysStateUpReg());
        CCA_MESSAGE(ccaMessage,header,SysStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SysStateRelUpReg > payloadRelUpRegHeap (new SysStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SysState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::SysStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SysState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SysState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SysState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSysState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SysState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SysStateStatus > payloadLoopback (new SysStateStatus(getSysState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SysStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SysState);
        ::boost::shared_ptr< SysStateError > payload (new SysStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SysStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SysState", &cb);
    }
}

bool SPM_CORE_FIProxy::sendSysStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SysState,"SysState");
}

void SPM_CORE_FIProxy::sendSysStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SysState);
}

const SysStateStatus& SPM_CORE_FIProxy::getSysState() const {
    return _sysState.get();
}

bool SPM_CORE_FIProxy::hasSysState() const {
    return _sysState.hasValue();
}

act_t SPM_CORE_FIProxy::sendSysStateGet(SysStateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SysState);
        ::boost::shared_ptr< SysStateGet > payload (new SysStateGet());
        CCA_MESSAGE(ccaMessage,header,SysStateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SysState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SysState);
        ::boost::shared_ptr< SysStateError > payload (new SysStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SysStateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SysState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendMostStateUpReg(MostStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_MostState);
        ::boost::shared_ptr< MostStateUpReg > payload (new MostStateUpReg());
        CCA_MESSAGE(ccaMessage,header,MostStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< MostStateRelUpReg > payloadRelUpRegHeap (new MostStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_MostState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::MostStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_MostState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "MostState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "MostState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasMostState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_MostState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< MostStateStatus > payloadLoopback (new MostStateStatus(getMostState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,MostStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_MostState);
        ::boost::shared_ptr< MostStateError > payload (new MostStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,MostStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "MostState", &cb);
    }
}

bool SPM_CORE_FIProxy::sendMostStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_MostState,"MostState");
}

void SPM_CORE_FIProxy::sendMostStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_MostState);
}

const MostStateStatus& SPM_CORE_FIProxy::getMostState() const {
    return _mostState.get();
}

bool SPM_CORE_FIProxy::hasMostState() const {
    return _mostState.hasValue();
}

act_t SPM_CORE_FIProxy::sendMostStateGet(MostStateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_MostState);
        ::boost::shared_ptr< MostStateGet > payload (new MostStateGet());
        CCA_MESSAGE(ccaMessage,header,MostStateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "MostState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_MostState);
        ::boost::shared_ptr< MostStateError > payload (new MostStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,MostStateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "MostState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendMostVersionUpReg(MostVersionCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_MostVersion);
        ::boost::shared_ptr< MostVersionUpReg > payload (new MostVersionUpReg());
        CCA_MESSAGE(ccaMessage,header,MostVersionUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< MostVersionRelUpReg > payloadRelUpRegHeap (new MostVersionRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_MostVersion, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::MostVersionRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_MostVersion, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "MostVersion", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "MostVersion", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasMostVersion()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_MostVersion, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< MostVersionStatus > payloadLoopback (new MostVersionStatus(getMostVersion()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,MostVersionStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_MostVersion);
        ::boost::shared_ptr< MostVersionError > payload (new MostVersionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,MostVersionError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "MostVersion", &cb);
    }
}

bool SPM_CORE_FIProxy::sendMostVersionRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_MostVersion,"MostVersion");
}

void SPM_CORE_FIProxy::sendMostVersionRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_MostVersion);
}

const MostVersionStatus& SPM_CORE_FIProxy::getMostVersion() const {
    return _mostVersion.get();
}

bool SPM_CORE_FIProxy::hasMostVersion() const {
    return _mostVersion.hasValue();
}

act_t SPM_CORE_FIProxy::sendMostVersionGet(MostVersionCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_MostVersion);
        ::boost::shared_ptr< MostVersionGet > payload (new MostVersionGet());
        CCA_MESSAGE(ccaMessage,header,MostVersionGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "MostVersion", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_MostVersion);
        ::boost::shared_ptr< MostVersionError > payload (new MostVersionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,MostVersionError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "MostVersion", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendRVCStateUpReg(RVCStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_RVCState);
        ::boost::shared_ptr< RVCStateUpReg > payload (new RVCStateUpReg());
        CCA_MESSAGE(ccaMessage,header,RVCStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< RVCStateRelUpReg > payloadRelUpRegHeap (new RVCStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_RVCState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::RVCStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_RVCState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "RVCState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "RVCState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasRVCState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_RVCState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< RVCStateStatus > payloadLoopback (new RVCStateStatus(getRVCState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,RVCStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RVCState);
        ::boost::shared_ptr< RVCStateError > payload (new RVCStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RVCStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "RVCState", &cb);
    }
}

bool SPM_CORE_FIProxy::sendRVCStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_RVCState,"RVCState");
}

void SPM_CORE_FIProxy::sendRVCStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_RVCState);
}

const RVCStateStatus& SPM_CORE_FIProxy::getRVCState() const {
    return _rVCState.get();
}

bool SPM_CORE_FIProxy::hasRVCState() const {
    return _rVCState.hasValue();
}

act_t SPM_CORE_FIProxy::sendRVCStateGet(RVCStateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_RVCState);
        ::boost::shared_ptr< RVCStateGet > payload (new RVCStateGet());
        CCA_MESSAGE(ccaMessage,header,RVCStateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "RVCState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RVCState);
        ::boost::shared_ptr< RVCStateError > payload (new RVCStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RVCStateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "RVCState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendRVCStateSet(RVCStateCallbackIF& cb, bool state) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_RVCState);
        ::boost::shared_ptr< RVCStateSet > payload (new RVCStateSet());
        payload->setState(state);
        CCA_MESSAGE(ccaMessage,header,RVCStateSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "RVCState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RVCState);
        ::boost::shared_ptr< RVCStateError > payload (new RVCStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RVCStateError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "RVCState", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendTriggerMostRemoteResetUpReg(TriggerMostRemoteResetCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_TriggerMostRemoteReset);
        ::boost::shared_ptr< TriggerMostRemoteResetUpReg > payload (new TriggerMostRemoteResetUpReg());
        CCA_MESSAGE(ccaMessage,header,TriggerMostRemoteResetUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< TriggerMostRemoteResetRelUpReg > payloadRelUpRegHeap (new TriggerMostRemoteResetRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_TriggerMostRemoteReset, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::TriggerMostRemoteResetRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_TriggerMostRemoteReset, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "TriggerMostRemoteReset", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "TriggerMostRemoteReset", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasTriggerMostRemoteReset()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_TriggerMostRemoteReset, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< TriggerMostRemoteResetStatus > payloadLoopback (new TriggerMostRemoteResetStatus(getTriggerMostRemoteReset()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,TriggerMostRemoteResetStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TriggerMostRemoteReset);
        ::boost::shared_ptr< TriggerMostRemoteResetError > payload (new TriggerMostRemoteResetError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TriggerMostRemoteResetError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "TriggerMostRemoteReset", &cb);
    }
}

bool SPM_CORE_FIProxy::sendTriggerMostRemoteResetRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_TriggerMostRemoteReset,"TriggerMostRemoteReset");
}

void SPM_CORE_FIProxy::sendTriggerMostRemoteResetRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_TriggerMostRemoteReset);
}

const TriggerMostRemoteResetStatus& SPM_CORE_FIProxy::getTriggerMostRemoteReset() const {
    return _triggerMostRemoteReset.get();
}

bool SPM_CORE_FIProxy::hasTriggerMostRemoteReset() const {
    return _triggerMostRemoteReset.hasValue();
}

act_t SPM_CORE_FIProxy::sendTriggerMostRemoteResetGet(TriggerMostRemoteResetCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_TriggerMostRemoteReset);
        ::boost::shared_ptr< TriggerMostRemoteResetGet > payload (new TriggerMostRemoteResetGet());
        CCA_MESSAGE(ccaMessage,header,TriggerMostRemoteResetGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "TriggerMostRemoteReset", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TriggerMostRemoteReset);
        ::boost::shared_ptr< TriggerMostRemoteResetError > payload (new TriggerMostRemoteResetError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TriggerMostRemoteResetError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "TriggerMostRemoteReset", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendTriggerMostRemoteResetSet(TriggerMostRemoteResetCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_TriggerMostRemoteReset);
        ::boost::shared_ptr< TriggerMostRemoteResetSet > payload (new TriggerMostRemoteResetSet());
        CCA_MESSAGE(ccaMessage,header,TriggerMostRemoteResetSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "TriggerMostRemoteReset", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TriggerMostRemoteReset);
        ::boost::shared_ptr< TriggerMostRemoteResetError > payload (new TriggerMostRemoteResetError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TriggerMostRemoteResetError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "TriggerMostRemoteReset", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendPartnumberUpReg(PartnumberCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Partnumber);
        ::boost::shared_ptr< PartnumberUpReg > payload (new PartnumberUpReg());
        CCA_MESSAGE(ccaMessage,header,PartnumberUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< PartnumberRelUpReg > payloadRelUpRegHeap (new PartnumberRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Partnumber, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::PartnumberRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Partnumber, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Partnumber", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Partnumber", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasPartnumber()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Partnumber, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< PartnumberStatus > payloadLoopback (new PartnumberStatus(getPartnumber()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,PartnumberStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Partnumber);
        ::boost::shared_ptr< PartnumberError > payload (new PartnumberError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PartnumberError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Partnumber", &cb);
    }
}

bool SPM_CORE_FIProxy::sendPartnumberRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Partnumber,"Partnumber");
}

void SPM_CORE_FIProxy::sendPartnumberRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Partnumber);
}

const PartnumberStatus& SPM_CORE_FIProxy::getPartnumber() const {
    return _partnumber.get();
}

bool SPM_CORE_FIProxy::hasPartnumber() const {
    return _partnumber.hasValue();
}

act_t SPM_CORE_FIProxy::sendPartnumberGet(PartnumberCallbackIF& cb, const ::std::string& part) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Partnumber);
        ::boost::shared_ptr< PartnumberGet > payload (new PartnumberGet());
        payload->setPart(part);
        CCA_MESSAGE(ccaMessage,header,PartnumberGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Partnumber", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Partnumber);
        ::boost::shared_ptr< PartnumberError > payload (new PartnumberError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PartnumberError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Partnumber", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendPartnumberSet(PartnumberCallbackIF& cb, const ::std::string& part, uint32 number) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_Partnumber);
        ::boost::shared_ptr< PartnumberSet > payload (new PartnumberSet());
        payload->setPart(part);
        payload->setNumber(number);
        CCA_MESSAGE(ccaMessage,header,PartnumberSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "Partnumber", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Partnumber);
        ::boost::shared_ptr< PartnumberError > payload (new PartnumberError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PartnumberError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "Partnumber", &cb);
    }
}

act_t SPM_CORE_FIProxy::sendPartnumbersUpReg(PartnumbersCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Partnumbers);
        ::boost::shared_ptr< PartnumbersUpReg > payload (new PartnumbersUpReg());
        CCA_MESSAGE(ccaMessage,header,PartnumbersUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< PartnumbersRelUpReg > payloadRelUpRegHeap (new PartnumbersRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Partnumbers, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::SPM_CORE_FI::PartnumbersRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Partnumbers, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Partnumbers", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Partnumbers", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasPartnumbers()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Partnumbers, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< PartnumbersStatus > payloadLoopback (new PartnumbersStatus(getPartnumbers()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,PartnumbersStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Partnumbers);
        ::boost::shared_ptr< PartnumbersError > payload (new PartnumbersError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PartnumbersError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Partnumbers", &cb);
    }
}

bool SPM_CORE_FIProxy::sendPartnumbersRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Partnumbers,"Partnumbers");
}

void SPM_CORE_FIProxy::sendPartnumbersRelUpRegAll()
{
    _ccaProxyDelega