/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "SPM_CORE_FI.h"
#include "SPM_CORE_FIJson.h"
#include "asf/core/Types.h"
#include "asf/stream/json.h"
#include "boost/ptr_container/ptr_vector.hpp"
#include "spm_core_fi_types.h"
#include "spm_core_fi_typesConst.h"
#include "spm_core_fi_typesJsonPrivate.h"
#include "spm_diag_defset_fi_typesConst.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "SystemStateStatus"

void serializeJson (const ::SPM_CORE_FI::SystemStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSystemState()) {
        yajl_gen_string(g, (const unsigned char*)  "SystemState" , 11);
        const char* s = ::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES_Name(value.getSystemState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSystemState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SystemStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SystemModeStart"

void serializeJson (const ::SPM_CORE_FI::SystemModeStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasESystemMode()) {
        yajl_gen_string(g, (const unsigned char*)  "eSystemMode" , 11);
        const char* s = ::spm_core_fi_types::T_e8_StateModes_Name(value.getESystemMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getESystemMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SystemModeStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SystemModeResult"

void serializeJson (const ::SPM_CORE_FI::SystemModeResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS32ReturnVal()) {
        yajl_gen_string(g, (const unsigned char*)  "s32ReturnVal" , 12);
        yajl_gen_integer(g, (long long)value.getS32ReturnVal());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SystemModeResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DownloadLockStateStart"

void serializeJson (const ::SPM_CORE_FI::DownloadLockStateStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStrRestrictedDlState()) {
        yajl_gen_string(g, (const unsigned char*)  "strRestrictedDlState" , 20);
        const char *s = value.getStrRestrictedDlState().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasERestrictedDlMode()) {
        yajl_gen_string(g, (const unsigned char*)  "eRestrictedDlMode" , 17);
        const char* s = ::spm_core_fi_types::T_e8_DownloadLockStates_Name(value.getERestrictedDlMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getERestrictedDlMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::DownloadLockStateStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DownloadLockStateResult"

void serializeJson (const ::SPM_CORE_FI::DownloadLockStateResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS32ReturnVal()) {
        yajl_gen_string(g, (const unsigned char*)  "s32ReturnVal" , 12);
        yajl_gen_integer(g, (long long)value.getS32ReturnVal());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::DownloadLockStateResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DownloadLockStatesStatus"

void serializeJson (const ::SPM_CORE_FI::DownloadLockStatesStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasListRestrictedLock()) {
        yajl_gen_string(g, (const unsigned char*)  "listRestrictedLock" , 18);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_RestrictedDlLock >& o1 = value.getListRestrictedLock();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_RestrictedDlLock >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                serializeJson((*o0), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::DownloadLockStatesStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateLockStart"

void serializeJson (const ::SPM_CORE_FI::UpdateLockStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStrLockName()) {
        yajl_gen_string(g, (const unsigned char*)  "strLockName" , 11);
        const char *s = value.getStrLockName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasELockRequest()) {
        yajl_gen_string(g, (const unsigned char*)  "eLockRequest" , 12);
        const char* s = ::spm_core_fi_types::T_e8_UpdateLockCommand_Name(value.getELockRequest());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getELockRequest());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::UpdateLockStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateLockResult"

void serializeJson (const ::SPM_CORE_FI::UpdateLockResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS32ReturnVal()) {
        yajl_gen_string(g, (const unsigned char*)  "s32ReturnVal" , 12);
        yajl_gen_integer(g, (long long)value.getS32ReturnVal());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::UpdateLockResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UpdateLockStatesStatus"

void serializeJson (const ::SPM_CORE_FI::UpdateLockStatesStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLLocks()) {
        yajl_gen_string(g, (const unsigned char*)  "lLocks" , 6);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_UpdateLockState >& o3 = value.getLLocks();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_UpdateLockState >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::UpdateLockStatesStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OnOffTriggerStart"

void serializeJson (const ::SPM_CORE_FI::OnOffTriggerStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasESwitchOnTrigger()) {
        yajl_gen_string(g, (const unsigned char*)  "eSwitchOnTrigger" , 16);
        const char* s = ::spm_core_fi_types::T_SPM_e32_SubStateType_Name(value.getESwitchOnTrigger());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getESwitchOnTrigger());
    }
    if (!isSparse || value.hasBState()) {
        yajl_gen_string(g, (const unsigned char*)  "bState" , 6);
        yajl_gen_bool(g, (bool)value.getBState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::OnOffTriggerStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ActiveOnOffTriggerStatus"

void serializeJson (const ::SPM_CORE_FI::ActiveOnOffTriggerStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTOnOffTriggerList()) {
        yajl_gen_string(g, (const unsigned char*)  "tOnOffTriggerList" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< ::spm_core_fi_types::T_SPM_e32_SubStateType >& o5 = value.getTOnOffTriggerList();
        {
            ::std::vector< ::spm_core_fi_types::T_SPM_e32_SubStateType >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                const char* s = ::spm_core_fi_types::T_SPM_e32_SubStateType_Name((*o4));
                if (s != NULL)
                    yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
                else
                    yajl_gen_integer(g, (long long)(*o4));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ActiveOnOffTriggerStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SubStatesStatus"

void serializeJson (const ::SPM_CORE_FI::SubStatesStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSubState()) {
        yajl_gen_string(g, (const unsigned char*)  "SubState" , 8);
        yajl_gen_integer(g, (long long)value.getSubState());
    }
    if (!isSparse || value.hasHwSubState()) {
        yajl_gen_string(g, (const unsigned char*)  "HwSubState" , 10);
        yajl_gen_integer(g, (long long)value.getHwSubState());
    }
    if (!isSparse || value.hasInternSubState()) {
        yajl_gen_string(g, (const unsigned char*)  "InternSubState" , 14);
        yajl_gen_integer(g, (long long)value.getInternSubState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SubStatesStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SubStatesSet"

void serializeJson (const ::SPM_CORE_FI::SubStatesSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSubStateType()) {
        yajl_gen_string(g, (const unsigned char*)  "SubStateType" , 12);
        const char* s = ::spm_core_fi_types::T_SPM_e32_SubStateType_Name(value.getSubStateType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSubStateType());
    }
    if (!isSparse || value.hasSubStateData()) {
        yajl_gen_string(g, (const unsigned char*)  "SubStateData" , 12);
        yajl_gen_bool(g, (bool)value.getSubStateData());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SubStatesSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "HistoryTriggerStatus"

void serializeJson (const ::SPM_CORE_FI::HistoryTriggerStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTTriggeredStates()) {
        yajl_gen_string(g, (const unsigned char*)  "tTriggeredStates" , 16);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_HistoryTrigger >& o7 = value.getTTriggeredStates();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_HistoryTrigger >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                serializeJson((*o6), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::HistoryTriggerStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InsertStateStatus"

void serializeJson (const ::SPM_CORE_FI::InsertStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasInsertState()) {
        yajl_gen_string(g, (const unsigned char*)  "InsertState" , 11);
        const char* s = ::spm_core_fi_types::T_SPM_e32_CD_INSERT_STATE_Name(value.getInsertState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getInsertState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::InsertStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MediaEjectStateStatus"

void serializeJson (const ::SPM_CORE_FI::MediaEjectStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMediaEjectState()) {
        yajl_gen_string(g, (const unsigned char*)  "MediaEjectState" , 15);
        const char* s = ::spm_core_fi_types::T_SPM_e32_MEDIA_EJECT_STATE_Name(value.getMediaEjectState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getMediaEjectState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::MediaEjectStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PhoneMuteStateStatus"

void serializeJson (const ::SPM_CORE_FI::PhoneMuteStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPhoneMuteState()) {
        yajl_gen_string(g, (const unsigned char*)  "PhoneMuteState" , 14);
        const char* s = ::spm_core_fi_types::T_SPM_e32_PHONE_MUTE_STATE_Name(value.getPhoneMuteState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getPhoneMuteState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::PhoneMuteStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OnTipperStateStatus"

void serializeJson (const ::SPM_CORE_FI::OnTipperStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOnTipperState()) {
        yajl_gen_string(g, (const unsigned char*)  "OnTipperState" , 13);
        const char* s = ::spm_core_fi_types::T_SPM_e32_KEY_STATE_Name(value.getOnTipperState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getOnTipperState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::OnTipperStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IgnitionCyclesStatus"

void serializeJson (const ::SPM_CORE_FI::IgnitionCyclesStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIgnitionCycle()) {
        yajl_gen_string(g, (const unsigned char*)  "IgnitionCycle" , 13);
        yajl_gen_integer(g, (long long)value.getIgnitionCycle());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::IgnitionCyclesStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SysPwrModeStatus"

void serializeJson (const ::SPM_CORE_FI::SysPwrModeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSysPwrMode()) {
        yajl_gen_string(g, (const unsigned char*)  "SysPwrMode" , 10);
        const char* s = ::spm_core_fi_types::T_SPM_e32_SYSPWRMODE_Name(value.getSysPwrMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSysPwrMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SysPwrModeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SysPwrSaveModeStatus"

void serializeJson (const ::SPM_CORE_FI::SysPwrSaveModeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSysPwrSaveMode()) {
        yajl_gen_string(g, (const unsigned char*)  "SysPwrSaveMode" , 14);
        serializeJson(value.getSysPwrSaveMode(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SysPwrSaveModeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MapDownloadLockStateStatus"

void serializeJson (const ::SPM_CORE_FI::MapDownloadLockStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU16AppIdLockOwner()) {
        yajl_gen_string(g, (const unsigned char*)  "u16AppIdLockOwner" , 17);
        yajl_gen_integer(g, (long long)value.getU16AppIdLockOwner());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::MapDownloadLockStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StandbyTimeStatus"

void serializeJson (const ::SPM_CORE_FI::StandbyTimeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStandbyTime()) {
        yajl_gen_string(g, (const unsigned char*)  "StandbyTime" , 11);
        yajl_gen_integer(g, (long long)value.getStandbyTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::StandbyTimeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StandbyTimeSet"

void serializeJson (const ::SPM_CORE_FI::StandbyTimeSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStandbyTime()) {
        yajl_gen_string(g, (const unsigned char*)  "StandbyTime" , 11);
        yajl_gen_integer(g, (long long)value.getStandbyTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::StandbyTimeSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PersitentStandbyTimeStatus"

void serializeJson (const ::SPM_CORE_FI::PersitentStandbyTimeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPersitentStandbyTime()) {
        yajl_gen_string(g, (const unsigned char*)  "PersitentStandbyTime" , 20);
        yajl_gen_integer(g, (long long)value.getPersitentStandbyTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::PersitentStandbyTimeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PersitentStandbyTimeSet"

void serializeJson (const ::SPM_CORE_FI::PersitentStandbyTimeSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPersitentStandbyTime()) {
        yajl_gen_string(g, (const unsigned char*)  "PersitentStandbyTime" , 20);
        yajl_gen_integer(g, (long long)value.getPersitentStandbyTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::PersitentStandbyTimeSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IgnitionOffTimeStatus"

void serializeJson (const ::SPM_CORE_FI::IgnitionOffTimeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIgnitionOffTime()) {
        yajl_gen_string(g, (const unsigned char*)  "IgnitionOffTime" , 15);
        yajl_gen_integer(g, (long long)value.getIgnitionOffTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::IgnitionOffTimeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IgnitionOffTimeSet"

void serializeJson (const ::SPM_CORE_FI::IgnitionOffTimeSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIgnitionOffTime()) {
        yajl_gen_string(g, (const unsigned char*)  "IgnitionOffTime" , 15);
        yajl_gen_integer(g, (long long)value.getIgnitionOffTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::IgnitionOffTimeSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoorOpenTimeStatus"

void serializeJson (const ::SPM_CORE_FI::DoorOpenTimeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDoorOpenTime()) {
        yajl_gen_string(g, (const unsigned char*)  "DoorOpenTime" , 12);
        yajl_gen_integer(g, (long long)value.getDoorOpenTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::DoorOpenTimeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoorOpenTimeSet"

void serializeJson (const ::SPM_CORE_FI::DoorOpenTimeSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDoorOpenTime()) {
        yajl_gen_string(g, (const unsigned char*)  "DoorOpenTime" , 12);
        yajl_gen_integer(g, (long long)value.getDoorOpenTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::DoorOpenTimeSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ClockDisplayTimeStatus"

void serializeJson (const ::SPM_CORE_FI::ClockDisplayTimeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClockDisplayTime()) {
        yajl_gen_string(g, (const unsigned char*)  "ClockDisplayTime" , 16);
        yajl_gen_integer(g, (long long)value.getClockDisplayTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ClockDisplayTimeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ClockDisplayTimeSet"

void serializeJson (const ::SPM_CORE_FI::ClockDisplayTimeSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasClockDisplayTime()) {
        yajl_gen_string(g, (const unsigned char*)  "ClockDisplayTime" , 16);
        yajl_gen_integer(g, (long long)value.getClockDisplayTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ClockDisplayTimeSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SystemStateTimeStatus"

void serializeJson (const ::SPM_CORE_FI::SystemStateTimeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTSystemState()) {
        yajl_gen_string(g, (const unsigned char*)  "tSystemState" , 12);
        const char* s = ::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES_Name(value.getTSystemState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTSystemState());
    }
    if (!isSparse || value.hasTStateTimerValue()) {
        yajl_gen_string(g, (const unsigned char*)  "tStateTimerValue" , 16);
        yajl_gen_integer(g, (long long)value.getTStateTimerValue());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SystemStateTimeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SystemStateTimeSet"

void serializeJson (const ::SPM_CORE_FI::SystemStateTimeSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTSystemState()) {
        yajl_gen_string(g, (const unsigned char*)  "tSystemState" , 12);
        const char* s = ::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES_Name(value.getTSystemState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTSystemState());
    }
    if (!isSparse || value.hasTStateTimerValue()) {
        yajl_gen_string(g, (const unsigned char*)  "tStateTimerValue" , 16);
        yajl_gen_integer(g, (long long)value.getTStateTimerValue());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SystemStateTimeSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SystemStateTimeGet"

void serializeJson (const ::SPM_CORE_FI::SystemStateTimeGet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTSystemState()) {
        yajl_gen_string(g, (const unsigned char*)  "tSystemState" , 12);
        const char* s = ::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES_Name(value.getTSystemState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTSystemState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SystemStateTimeGet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ProcessListStatus"

void serializeJson (const ::SPM_CORE_FI::ProcessListStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTProcesses()) {
        yajl_gen_string(g, (const unsigned char*)  "tProcesses" , 10);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_ProcessElement >& o9 = value.getTProcesses();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_ProcessElement >::const_iterator o8;
            for (o8 = o9.begin(); o8 != o9.end(); ++o8) {
                serializeJson((*o8), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ProcessListStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartProcessStart"

void serializeJson (const ::SPM_CORE_FI::StartProcessStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStrLocation()) {
        yajl_gen_string(g, (const unsigned char*)  "strLocation" , 11);
        const char *s = value.getStrLocation().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32Prio()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Prio" , 7);
        yajl_gen_integer(g, (long long)value.getU32Prio());
    }
    if (!isSparse || value.hasU32Affinity()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Affinity" , 11);
        yajl_gen_integer(g, (long long)value.getU32Affinity());
    }
    if (!isSparse || value.hasU32AffinityEnd()) {
        yajl_gen_string(g, (const unsigned char*)  "u32AffinityEnd" , 14);
        yajl_gen_integer(g, (long long)value.getU32AffinityEnd());
    }
    if (!isSparse || value.hasU32NiceLevel()) {
        yajl_gen_string(g, (const unsigned char*)  "u32NiceLevel" , 12);
        yajl_gen_integer(g, (long long)value.getU32NiceLevel());
    }
    if (!isSparse || value.hasU32NiceLevelEnd()) {
        yajl_gen_string(g, (const unsigned char*)  "u32NiceLevelEnd" , 15);
        yajl_gen_integer(g, (long long)value.getU32NiceLevelEnd());
    }
    if (!isSparse || value.hasU32Type()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Type" , 7);
        const char* s = ::spm_core_fi_types::T_SPM_e32_START_PROC_TYPE_Name(value.getU32Type());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU32Type());
    }
    if (!isSparse || value.hasU32Info()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Info" , 7);
        yajl_gen_integer(g, (long long)value.getU32Info());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::StartProcessStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartProcessResult"

void serializeJson (const ::SPM_CORE_FI::StartProcessResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS32ReturnVal()) {
        yajl_gen_string(g, (const unsigned char*)  "s32ReturnVal" , 12);
        yajl_gen_integer(g, (long long)value.getS32ReturnVal());
    }
    if (!isSparse || value.hasStrLocation()) {
        yajl_gen_string(g, (const unsigned char*)  "strLocation" , 11);
        const char *s = value.getStrLocation().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32ProcId()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ProcId" , 9);
        yajl_gen_integer(g, (long long)value.getU32ProcId());
    }
    if (!isSparse || value.hasU32SpawnDuration()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SpawnDuration" , 16);
        yajl_gen_integer(g, (long long)value.getU32SpawnDuration());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::StartProcessResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StopProcessStart"

void serializeJson (const ::SPM_CORE_FI::StopProcessStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStrLocation()) {
        yajl_gen_string(g, (const unsigned char*)  "strLocation" , 11);
        const char *s = value.getStrLocation().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32ProcId()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ProcId" , 9);
        yajl_gen_integer(g, (long long)value.getU32ProcId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::StopProcessStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StopProcessResult"

void serializeJson (const ::SPM_CORE_FI::StopProcessResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS32ReturnVal()) {
        yajl_gen_string(g, (const unsigned char*)  "s32ReturnVal" , 12);
        yajl_gen_integer(g, (long long)value.getS32ReturnVal());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::StopProcessResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RestartProcessStart"

void serializeJson (const ::SPM_CORE_FI::RestartProcessStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStrLocation()) {
        yajl_gen_string(g, (const unsigned char*)  "strLocation" , 11);
        const char *s = value.getStrLocation().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasU32ProcId()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ProcId" , 9);
        yajl_gen_integer(g, (long long)value.getU32ProcId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::RestartProcessStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RestartProcessResult"

void serializeJson (const ::SPM_CORE_FI::RestartProcessResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS32ReturnVal()) {
        yajl_gen_string(g, (const unsigned char*)  "s32ReturnVal" , 12);
        yajl_gen_integer(g, (long long)value.getS32ReturnVal());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::RestartProcessResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WakeupReasonStatus"

void serializeJson (const ::SPM_CORE_FI::WakeupReasonStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasWakeupReason()) {
        yajl_gen_string(g, (const unsigned char*)  "WakeupReason" , 12);
        const char* s = ::spm_core_fi_types::T_SPM_e32_WAKEUP_REASON_Name(value.getWakeupReason());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getWakeupReason());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::WakeupReasonStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartupReasonStatus"

void serializeJson (const ::SPM_CORE_FI::StartupReasonStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStartupReason()) {
        yajl_gen_string(g, (const unsigned char*)  "StartupReason" , 13);
        const char* s = ::spm_core_fi_types::T_SPM_e32_STARTUP_REASON_Name(value.getStartupReason());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStartupReason());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::StartupReasonStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConnectToBatteryStatus"

void serializeJson (const ::SPM_CORE_FI::ConnectToBatteryStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasConnectToBatteryState()) {
        yajl_gen_string(g, (const unsigned char*)  "ConnectToBatteryState" , 21);
        yajl_gen_bool(g, (bool)value.getConnectToBatteryState());
    }
    if (!isSparse || value.hasConnectToBatteryCount()) {
        yajl_gen_string(g, (const unsigned char*)  "ConnectToBatteryCount" , 21);
        yajl_gen_integer(g, (long long)value.getConnectToBatteryCount());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ConnectToBatteryStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CodeRequestStateStatus"

void serializeJson (const ::SPM_CORE_FI::CodeRequestStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCodeRequestState()) {
        yajl_gen_string(g, (const unsigned char*)  "CodeRequestState" , 16);
        const char* s = ::spm_core_fi_types::T_SPM_e32_CODE_REQUEST_Name(value.getCodeRequestState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getCodeRequestState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::CodeRequestStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CodeRequestStateSet"

void serializeJson (const ::SPM_CORE_FI::CodeRequestStateSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCodeRequestState()) {
        yajl_gen_string(g, (const unsigned char*)  "CodeRequestState" , 16);
        const char* s = ::spm_core_fi_types::T_SPM_e32_CODE_REQUEST_Name(value.getCodeRequestState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getCodeRequestState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::CodeRequestStateSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartUpSyncPointReachedStart"

void serializeJson (const ::SPM_CORE_FI::StartUpSyncPointReachedStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStrNewSyncPoint()) {
        yajl_gen_string(g, (const unsigned char*)  "strNewSyncPoint" , 15);
        const char *s = value.getStrNewSyncPoint().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::StartUpSyncPointReachedStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ActiveStartUpSyncPointsStatus"

void serializeJson (const ::SPM_CORE_FI::ActiveStartUpSyncPointsStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTStartupSyncPointList()) {
        yajl_gen_string(g, (const unsigned char*)  "tStartupSyncPointList" , 21);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::std::string >& o11 = value.getTStartupSyncPointList();
        {
            ::boost::ptr_vector< ::std::string >::const_iterator o10;
            for (o10 = o11.begin(); o10 != o11.end(); ++o10) {
                const char *s = (*o10).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ActiveStartUpSyncPointsStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CvmEventStatus"

void serializeJson (const ::SPM_CORE_FI::CvmEventStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCvmEvent()) {
        yajl_gen_string(g, (const unsigned char*)  "CvmEvent" , 8);
        const char* s = ::spm_core_fi_types::T_SPM_e32_CVM_EVENT_Name(value.getCvmEvent());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getCvmEvent());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::CvmEventStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UBatSenseStatus"

void serializeJson (const ::SPM_CORE_FI::UBatSenseStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUBatSense()) {
        yajl_gen_string(g, (const unsigned char*)  "UBatSense" , 9);
        yajl_gen_integer(g, (long long)value.getUBatSense());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::UBatSenseStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CoproStateStatus"

void serializeJson (const ::SPM_CORE_FI::CoproStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCoproState()) {
        yajl_gen_string(g, (const unsigned char*)  "CoproState" , 10);
        const char* s = ::spm_core_fi_types::T_SPM_e32_PROCESSOR_STATE_Name(value.getCoproState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getCoproState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::CoproStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CoproStateSet"

void serializeJson (const ::SPM_CORE_FI::CoproStateSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCoproState()) {
        yajl_gen_string(g, (const unsigned char*)  "CoproState" , 10);
        const char* s = ::spm_core_fi_types::T_SPM_e32_PROCESSOR_STATE_Name(value.getCoproState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getCoproState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::CoproStateSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevicePowerOnTimeStatus"

void serializeJson (const ::SPM_CORE_FI::DevicePowerOnTimeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDevicePowerOnTime()) {
        yajl_gen_string(g, (const unsigned char*)  "DevicePowerOnTime" , 17);
        yajl_gen_integer(g, (long long)value.getDevicePowerOnTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::DevicePowerOnTimeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevicePowerOnTimeSet"

void serializeJson (const ::SPM_CORE_FI::DevicePowerOnTimeSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDevicePowerOnTime()) {
        yajl_gen_string(g, (const unsigned char*)  "DevicePowerOnTime" , 17);
        yajl_gen_integer(g, (long long)value.getDevicePowerOnTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::DevicePowerOnTimeSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LastSystemRuntimeStatus"

void serializeJson (const ::SPM_CORE_FI::LastSystemRuntimeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32RunTime()) {
        yajl_gen_string(g, (const unsigned char*)  "u32RunTime" , 10);
        yajl_gen_integer(g, (long long)value.getU32RunTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::LastSystemRuntimeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CurrentSystemRuntimeStatus"

void serializeJson (const ::SPM_CORE_FI::CurrentSystemRuntimeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32RunTime()) {
        yajl_gen_string(g, (const unsigned char*)  "u32RunTime" , 10);
        yajl_gen_integer(g, (long long)value.getU32RunTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::CurrentSystemRuntimeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ResetListStatus"

void serializeJson (const ::SPM_CORE_FI::ResetListStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLastResetReason()) {
        yajl_gen_string(g, (const unsigned char*)  "LastResetReason" , 15);
        const char* s = ::spm_core_fi_types::T_e8_LcmResetReason_Name(value.getLastResetReason());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getLastResetReason());
    }
    if (!isSparse || value.hasDateHour()) {
        yajl_gen_string(g, (const unsigned char*)  "DateHour" , 8);
        yajl_gen_integer(g, (long long)value.getDateHour());
    }
    if (!isSparse || value.hasDateMinute()) {
        yajl_gen_string(g, (const unsigned char*)  "DateMinute" , 10);
        yajl_gen_integer(g, (long long)value.getDateMinute());
    }
    if (!isSparse || value.hasDateDay()) {
        yajl_gen_string(g, (const unsigned char*)  "DateDay" , 7);
        yajl_gen_integer(g, (long long)value.getDateDay());
    }
    if (!isSparse || value.hasDateMonth()) {
        yajl_gen_string(g, (const unsigned char*)  "DateMonth" , 9);
        yajl_gen_integer(g, (long long)value.getDateMonth());
    }
    if (!isSparse || value.hasDateYear()) {
        yajl_gen_string(g, (const unsigned char*)  "DateYear" , 8);
        yajl_gen_integer(g, (long long)value.getDateYear());
    }
    if (!isSparse || value.hasCoproResetByHmi()) {
        yajl_gen_string(g, (const unsigned char*)  "CoproResetByHmi" , 15);
        yajl_gen_integer(g, (long long)value.getCoproResetByHmi());
    }
    if (!isSparse || value.hasCoproResetByUndervoltage()) {
        yajl_gen_string(g, (const unsigned char*)  "CoproResetByUndervoltage" , 24);
        yajl_gen_integer(g, (long long)value.getCoproResetByUndervoltage());
    }
    if (!isSparse || value.hasHmiResetByCoproStartup()) {
        yajl_gen_string(g, (const unsigned char*)  "HmiResetByCoproStartup" , 22);
        yajl_gen_integer(g, (long long)value.getHmiResetByCoproStartup());
    }
    if (!isSparse || value.hasHmiResetByCoproRun()) {
        yajl_gen_string(g, (const unsigned char*)  "HmiResetByCoproRun" , 18);
        yajl_gen_integer(g, (long long)value.getHmiResetByCoproRun());
    }
    if (!isSparse || value.hasHmiResetByCoproShutdown()) {
        yajl_gen_string(g, (const unsigned char*)  "HmiResetByCoproShutdown" , 23);
        yajl_gen_integer(g, (long long)value.getHmiResetByCoproShutdown());
    }
    if (!isSparse || value.hasHmiResetByHmiWdg()) {
        yajl_gen_string(g, (const unsigned char*)  "HmiResetByHmiWdg" , 16);
        yajl_gen_integer(g, (long long)value.getHmiResetByHmiWdg());
    }
    if (!isSparse || value.hasHmiResetByHmiApp()) {
        yajl_gen_string(g, (const unsigned char*)  "HmiResetByHmiApp" , 16);
        yajl_gen_integer(g, (long long)value.getHmiResetByHmiApp());
    }
    if (!isSparse || value.hasHmiResetByHmiException()) {
        yajl_gen_string(g, (const unsigned char*)  "HmiResetByHmiException" , 22);
        yajl_gen_integer(g, (long long)value.getHmiResetByHmiException());
    }
    if (!isSparse || value.hasHmiResetByHmiExtern()) {
        yajl_gen_string(g, (const unsigned char*)  "HmiResetByHmiExtern" , 19);
        yajl_gen_integer(g, (long long)value.getHmiResetByHmiExtern());
    }
    if (!isSparse || value.hasHmiResetByHmiDownload()) {
        yajl_gen_string(g, (const unsigned char*)  "HmiResetByHmiDownload" , 21);
        yajl_gen_integer(g, (long long)value.getHmiResetByHmiDownload());
    }
    if (!isSparse || value.hasHmiResetByHmiDiag()) {
        yajl_gen_string(g, (const unsigned char*)  "HmiResetByHmiDiag" , 17);
        yajl_gen_integer(g, (long long)value.getHmiResetByHmiDiag());
    }
    if (!isSparse || value.hasFgsResetByHmi()) {
        yajl_gen_string(g, (const unsigned char*)  "FgsResetByHmi" , 13);
        yajl_gen_integer(g, (long long)value.getFgsResetByHmi());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ResetListStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ResetListSet"

void serializeJson (const ::SPM_CORE_FI::ResetListSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResetResetList()) {
        yajl_gen_string(g, (const unsigned char*)  "ResetResetList" , 14);
        yajl_gen_integer(g, (long long)value.getResetResetList());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ResetListSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ResetCounterStatus"

void serializeJson (const ::SPM_CORE_FI::ResetCounterStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTLastResetDate()) {
        yajl_gen_string(g, (const unsigned char*)  "tLastResetDate" , 14);
        serializeJson(value.getTLastResetDate(), g, options);
    }
    if (!isSparse || value.hasTLastResetReason()) {
        yajl_gen_string(g, (const unsigned char*)  "tLastResetReason" , 16);
        const char* s = ::spm_core_fi_types::T_e8_LcmResetReason_Name(value.getTLastResetReason());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTLastResetReason());
    }
    if (!isSparse || value.hasU32ApApplicationError()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApApplicationError" , 21);
        yajl_gen_integer(g, (long long)value.getU32ApApplicationError());
    }
    if (!isSparse || value.hasU32ApSoftware()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApSoftware" , 13);
        yajl_gen_integer(g, (long long)value.getU32ApSoftware());
    }
    if (!isSparse || value.hasU32ApEcuReset()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApEcuReset" , 13);
        yajl_gen_integer(g, (long long)value.getU32ApEcuReset());
    }
    if (!isSparse || value.hasU32ApDownload()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApDownload" , 13);
        yajl_gen_integer(g, (long long)value.getU32ApDownload());
    }
    if (!isSparse || value.hasU32ApDownloadError()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApDownloadError" , 18);
        yajl_gen_integer(g, (long long)value.getU32ApDownloadError());
    }
    if (!isSparse || value.hasU32ApOvertemperature()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApOvertemperature" , 20);
        yajl_gen_integer(g, (long long)value.getU32ApOvertemperature());
    }
    if (!isSparse || value.hasU32ApUser()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApUser" , 9);
        yajl_gen_integer(g, (long long)value.getU32ApUser());
    }
    if (!isSparse || value.hasU32ApLcmIntern()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApLcmIntern" , 14);
        yajl_gen_integer(g, (long long)value.getU32ApLcmIntern());
    }
    if (!isSparse || value.hasU32ApWarmstartCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApWarmstartCount" , 19);
        yajl_gen_integer(g, (long long)value.getU32ApWarmstartCount());
    }
    if (!isSparse || value.hasU32ApPowerOnCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApPowerOnCount" , 17);
        yajl_gen_integer(g, (long long)value.getU32ApPowerOnCount());
    }
    if (!isSparse || value.hasU32ApPowerLossCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApPowerLossCount" , 19);
        yajl_gen_integer(g, (long long)value.getU32ApPowerLossCount());
    }
    if (!isSparse || value.hasU32ApPowerOffCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApPowerOffCount" , 18);
        yajl_gen_integer(g, (long long)value.getU32ApPowerOffCount());
    }
    if (!isSparse || value.hasU32ApSccCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApSccCount" , 13);
        yajl_gen_integer(g, (long long)value.getU32ApSccCount());
    }
    if (!isSparse || value.hasU32ApUnknownCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32ApUnknownCount" , 17);
        yajl_gen_integer(g, (long long)value.getU32ApUnknownCount());
    }
    if (!isSparse || value.hasU32SccHwWdtCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SccHwWdtCount" , 16);
        yajl_gen_integer(g, (long long)value.getU32SccHwWdtCount());
    }
    if (!isSparse || value.hasU32SccPowerOnCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SccPowerOnCount" , 18);
        yajl_gen_integer(g, (long long)value.getU32SccPowerOnCount());
    }
    if (!isSparse || value.hasU32SccColdstartCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SccColdstartCount" , 20);
        yajl_gen_integer(g, (long long)value.getU32SccColdstartCount());
    }
    if (!isSparse || value.hasU32SccAppmodeChangeCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SccAppmodeChangeCount" , 24);
        yajl_gen_integer(g, (long long)value.getU32SccAppmodeChangeCount());
    }
    if (!isSparse || value.hasU32SccDuringLpwCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SccDuringLpwCount" , 20);
        yajl_gen_integer(g, (long long)value.getU32SccDuringLpwCount());
    }
    if (!isSparse || value.hasU32SccDuringPllOszCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SccDuringPllOszCount" , 23);
        yajl_gen_integer(g, (long long)value.getU32SccDuringPllOszCount());
    }
    if (!isSparse || value.hasU32SccDuringSWCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SccDuringSWCount" , 19);
        yajl_gen_integer(g, (long long)value.getU32SccDuringSWCount());
    }
    if (!isSparse || value.hasU32SccWarmstartCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32SccWarmstartCount" , 20);
        yajl_gen_integer(g, (long long)value.getU32SccWarmstartCount());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ResetCounterStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ResetCounterSet"

void serializeJson (const ::SPM_CORE_FI::ResetCounterSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResetCounter()) {
        yajl_gen_string(g, (const unsigned char*)  "ResetCounter" , 12);
        yajl_gen_integer(g, (long long)value.getResetCounter());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ResetCounterSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TransportModeListStatus"

void serializeJson (const ::SPM_CORE_FI::TransportModeListStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTransportModeList()) {
        yajl_gen_string(g, (const unsigned char*)  "TransportModeList" , 17);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_TransPortMode >& o13 = value.getTransportModeList();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_TransPortMode >::const_iterator o12;
            for (o12 = o13.begin(); o12 != o13.end(); ++o12) {
                serializeJson((*o12), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::TransportModeListStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TransportModeListSet"

void serializeJson (const ::SPM_CORE_FI::TransportModeListSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTransPortList()) {
        yajl_gen_string(g, (const unsigned char*)  "TransPortList" , 13);
        yajl_gen_integer(g, (long long)value.getTransPortList());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::TransportModeListSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ResetHistoryStatus"

void serializeJson (const ::SPM_CORE_FI::ResetHistoryStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTResetList()) {
        yajl_gen_string(g, (const unsigned char*)  "tResetList" , 10);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_ResetElement >& o15 = value.getTResetList();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_ResetElement >::const_iterator o14;
            for (o14 = o15.begin(); o14 != o15.end(); ++o14) {
                serializeJson((*o14), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ResetHistoryStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WakeupHistoryStatus"

void serializeJson (const ::SPM_CORE_FI::WakeupHistoryStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTWakeupList()) {
        yajl_gen_string(g, (const unsigned char*)  "tWakeupList" , 11);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_WakeupElement >& o17 = value.getTWakeupList();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_WakeupElement >::const_iterator o16;
            for (o16 = o17.begin(); o16 != o17.end(); ++o16) {
                serializeJson((*o16), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::WakeupHistoryStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StateHistoryStatus"

void serializeJson (const ::SPM_CORE_FI::StateHistoryStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTStateList()) {
        yajl_gen_string(g, (const unsigned char*)  "tStateList" , 10);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& o19 = value.getTStateList();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >::const_iterator o18;
            for (o18 = o19.begin(); o18 != o19.end(); ++o18) {
                serializeJson((*o18), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::StateHistoryStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ErrStateHistory01Status"

void serializeJson (const ::SPM_CORE_FI::ErrStateHistory01Status& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTStateList()) {
        yajl_gen_string(g, (const unsigned char*)  "tStateList" , 10);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& o21 = value.getTStateList();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >::const_iterator o20;
            for (o20 = o21.begin(); o20 != o21.end(); ++o20) {
                serializeJson((*o20), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ErrStateHistory01Status& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ErrStateHistory02Status"

void serializeJson (const ::SPM_CORE_FI::ErrStateHistory02Status& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTStateList()) {
        yajl_gen_string(g, (const unsigned char*)  "tStateList" , 10);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& o23 = value.getTStateList();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >::const_iterator o22;
            for (o22 = o23.begin(); o22 != o23.end(); ++o22) {
                serializeJson((*o22), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ErrStateHistory02Status& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ErrStateHistory03Status"

void serializeJson (const ::SPM_CORE_FI::ErrStateHistory03Status& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTStateList()) {
        yajl_gen_string(g, (const unsigned char*)  "tStateList" , 10);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& o25 = value.getTStateList();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >::const_iterator o24;
            for (o24 = o25.begin(); o24 != o25.end(); ++o24) {
                serializeJson((*o24), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ErrStateHistory03Status& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ErrStateHistory04Status"

void serializeJson (const ::SPM_CORE_FI::ErrStateHistory04Status& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTStateList()) {
        yajl_gen_string(g, (const unsigned char*)  "tStateList" , 10);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& o27 = value.getTStateList();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >::const_iterator o26;
            for (o26 = o27.begin(); o26 != o27.end(); ++o26) {
                serializeJson((*o26), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ErrStateHistory04Status& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ErrStateHistory05Status"

void serializeJson (const ::SPM_CORE_FI::ErrStateHistory05Status& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTStateList()) {
        yajl_gen_string(g, (const unsigned char*)  "tStateList" , 10);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& o29 = value.getTStateList();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >::const_iterator o28;
            for (o28 = o29.begin(); o28 != o29.end(); ++o28) {
                serializeJson((*o28), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ErrStateHistory05Status& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SwitchOnHistoryStatus"

void serializeJson (const ::SPM_CORE_FI::SwitchOnHistoryStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTSwitchOnList()) {
        yajl_gen_string(g, (const unsigned char*)  "tSwitchOnList" , 13);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_SwitchOnElement >& o31 = value.getTSwitchOnList();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_SwitchOnElement >::const_iterator o30;
            for (o30 = o31.begin(); o30 != o31.end(); ++o30) {
                serializeJson((*o30), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SwitchOnHistoryStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ClearListStart"

void serializeJson (const ::SPM_CORE_FI::ClearListStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEList2Clear()) {
        yajl_gen_string(g, (const unsigned char*)  "eList2Clear" , 11);
        const char* s = ::spm_core_fi_types::T_SPM_e32_CLEAR_LIST_Name(value.getEList2Clear());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEList2Clear());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ClearListStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeviceOnCounterStatus"

void serializeJson (const ::SPM_CORE_FI::DeviceOnCounterStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32DeviceWakeupCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32DeviceWakeupCount" , 20);
        yajl_gen_integer(g, (long long)value.getU32DeviceWakeupCount());
    }
    if (!isSparse || value.hasU32DeviceUserOnCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32DeviceUserOnCount" , 20);
        yajl_gen_integer(g, (long long)value.getU32DeviceUserOnCount());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::DeviceOnCounterStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VoltageEventCounterStatus"

void serializeJson (const ::SPM_CORE_FI::VoltageEventCounterStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTVoltageEventCounter()) {
        yajl_gen_string(g, (const unsigned char*)  "tVoltageEventCounter" , 20);
        serializeJson(value.getTVoltageEventCounter(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::VoltageEventCounterStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VoltageRangeHistogramStatus"

void serializeJson (const ::SPM_CORE_FI::VoltageRangeHistogramStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasListVoltageRangeHistogram()) {
        yajl_gen_string(g, (const unsigned char*)  "listVoltageRangeHistogram" , 25);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_VoltageRange >& o33 = value.getListVoltageRangeHistogram();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_VoltageRange >::const_iterator o32;
            for (o32 = o33.begin(); o32 != o33.end(); ++o32) {
                serializeJson((*o32), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::VoltageRangeHistogramStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CpuUsageStatisticStatus"

void serializeJson (const ::SPM_CORE_FI::CpuUsageStatisticStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTCpuUsageStatisticsData()) {
        yajl_gen_string(g, (const unsigned char*)  "tCpuUsageStatisticsData" , 23);
        serializeJson(value.getTCpuUsageStatisticsData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::CpuUsageStatisticStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RamUsageStatisticStatus"

void serializeJson (const ::SPM_CORE_FI::RamUsageStatisticStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTRamUsageStatisticsData()) {
        yajl_gen_string(g, (const unsigned char*)  "tRamUsageStatisticsData" , 23);
        serializeJson(value.getTRamUsageStatisticsData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::RamUsageStatisticStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartupTimeStatisticStatus"

void serializeJson (const ::SPM_CORE_FI::StartupTimeStatisticStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTStartupTimeStatisticsData()) {
        yajl_gen_string(g, (const unsigned char*)  "tStartupTimeStatisticsData" , 26);
        serializeJson(value.getTStartupTimeStatisticsData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::StartupTimeStatisticStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SWVersionStatisticStatus"

void serializeJson (const ::SPM_CORE_FI::SWVersionStatisticStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasListSWVersionStatistic()) {
        yajl_gen_string(g, (const unsigned char*)  "listSWVersionStatistic" , 22);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_SWVersionStatisticData >& o35 = value.getListSWVersionStatistic();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_SWVersionStatisticData >::const_iterator o34;
            for (o34 = o35.begin(); o34 != o35.end(); ++o34) {
                serializeJson((*o34), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SWVersionStatisticStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SpecificSWVersionStatisticStart"

void serializeJson (const ::SPM_CORE_FI::SpecificSWVersionStatisticStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32Index()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Index" , 8);
        yajl_gen_integer(g, (long long)value.getU32Index());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SpecificSWVersionStatisticStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SpecificSWVersionStatisticResult"

void serializeJson (const ::SPM_CORE_FI::SpecificSWVersionStatisticResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTSWVersionStatistic()) {
        yajl_gen_string(g, (const unsigned char*)  "tSWVersionStatistic" , 19);
        serializeJson(value.getTSWVersionStatistic(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SpecificSWVersionStatisticResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RestartSystemStart"

void serializeJson (const ::SPM_CORE_FI::RestartSystemStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasERestartType()) {
        yajl_gen_string(g, (const unsigned char*)  "eRestartType" , 12);
        const char* s = ::spm_core_fi_types::T_SPM_e32_RESTART_TYPE_Name(value.getERestartType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getERestartType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::RestartSystemStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RestartSystemResult"

void serializeJson (const ::SPM_CORE_FI::RestartSystemResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE32ReturnVal()) {
        yajl_gen_string(g, (const unsigned char*)  "e32ReturnVal" , 12);
        const char* s = ::spm_core_fi_types::T_SPM_e32_MRESULT_Name(value.getE32ReturnVal());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE32ReturnVal());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::RestartSystemResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RunlevelStateStatus"

void serializeJson (const ::SPM_CORE_FI::RunlevelStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasERunlevel()) {
        yajl_gen_string(g, (const unsigned char*)  "eRunlevel" , 9);
        const char* s = ::spm_core_fi_types::T_SPM_e32_RUNLEVEL_Name(value.getERunlevel());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getERunlevel());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::RunlevelStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RestartStatus"

void serializeJson (const ::SPM_CORE_FI::RestartStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRestart()) {
        yajl_gen_string(g, (const unsigned char*)  "Restart" , 7);
        const char* s = ::spm_core_fi_types::T_SPM_e32_RESTART_TYPE_Name(value.getRestart());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getRestart());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::RestartStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RestartSet"

void serializeJson (const ::SPM_CORE_FI::RestartSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRestart()) {
        yajl_gen_string(g, (const unsigned char*)  "Restart" , 7);
        const char* s = ::spm_core_fi_types::T_SPM_e32_RESTART_TYPE_Name(value.getRestart());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getRestart());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::RestartSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LifesignStatus"

void serializeJson (const ::SPM_CORE_FI::LifesignStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLifesign()) {
        yajl_gen_string(g, (const unsigned char*)  "Lifesign" , 8);
        yajl_gen_integer(g, (long long)value.getLifesign());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::LifesignStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "HmiStateStatus"

void serializeJson (const ::SPM_CORE_FI::HmiStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasHmiState()) {
        yajl_gen_string(g, (const unsigned char*)  "HmiState" , 8);
        const char* s = ::spm_core_fi_types::T_SPM_e32_HMI_STATE_Name(value.getHmiState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getHmiState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::HmiStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SystemPowerBehaviourStatus"

void serializeJson (const ::SPM_CORE_FI::SystemPowerBehaviourStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasESystemPowerBehaviour()) {
        yajl_gen_string(g, (const unsigned char*)  "eSystemPowerBehaviour" , 21);
        const char* s = ::spm_core_fi_types::T_SPM_e32_SYSPWR_BEHAVIOUR_Name(value.getESystemPowerBehaviour());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getESystemPowerBehaviour());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SystemPowerBehaviourStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AudioSourceChangeStart"

void serializeJson (const ::SPM_CORE_FI::AudioSourceChangeStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEAudioSrc()) {
        yajl_gen_string(g, (const unsigned char*)  "eAudioSrc" , 9);
        const char* s = ::spm_core_fi_types::T_SPM_e32_AUDIO_SOURCE_Name(value.getEAudioSrc());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEAudioSrc());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::AudioSourceChangeStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DimStateStatus"

void serializeJson (const ::SPM_CORE_FI::DimStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDimState()) {
        yajl_gen_string(g, (const unsigned char*)  "DimState" , 8);
        const char* s = ::spm_core_fi_types::T_SPM_e32_DIM_STATE_Name(value.getDimState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDimState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::DimStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DimmingStateStatus"

void serializeJson (const ::SPM_CORE_FI::DimmingStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDimState()) {
        yajl_gen_string(g, (const unsigned char*)  "DimState" , 8);
        serializeJson(value.getDimState(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::DimmingStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BluetoothStateStatus"

void serializeJson (const ::SPM_CORE_FI::BluetoothStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBtState()) {
        yajl_gen_string(g, (const unsigned char*)  "BtState" , 7);
        const char* s = ::spm_core_fi_types::T_SPM_e32_BT_STATE_Name(value.getBtState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getBtState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::BluetoothStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ChangeBluetoothStateStart"

void serializeJson (const ::SPM_CORE_FI::ChangeBluetoothStateStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBtState()) {
        yajl_gen_string(g, (const unsigned char*)  "BtState" , 7);
        const char* s = ::spm_core_fi_types::T_SPM_e32_BT_STATE_Name(value.getBtState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getBtState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ChangeBluetoothStateStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AudioStateStatus"

void serializeJson (const ::SPM_CORE_FI::AudioStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAudioState()) {
        yajl_gen_string(g, (const unsigned char*)  "AudioState" , 10);
        const char* s = ::spm_core_fi_types::T_SPM_e32_AUDIO_STATE_Name(value.getAudioState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAudioState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::AudioStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ChangeAudioStateStart"

void serializeJson (const ::SPM_CORE_FI::ChangeAudioStateStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAudioState()) {
        yajl_gen_string(g, (const unsigned char*)  "AudioState" , 10);
        const char* s = ::spm_core_fi_types::T_SPM_e32_AUDIO_STATE_Name(value.getAudioState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAudioState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ChangeAudioStateStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SpiStateStatus"

void serializeJson (const ::SPM_CORE_FI::SpiStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSpiState()) {
        yajl_gen_string(g, (const unsigned char*)  "SpiState" , 8);
        const char* s = ::spm_core_fi_types::T_SPM_e32_SPI_STATE_Name(value.getSpiState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSpiState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SpiStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ChangeSpiStateStart"

void serializeJson (const ::SPM_CORE_FI::ChangeSpiStateStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSpiState()) {
        yajl_gen_string(g, (const unsigned char*)  "SpiState" , 8);
        const char* s = ::spm_core_fi_types::T_SPM_e32_SPI_STATE_Name(value.getSpiState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSpiState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ChangeSpiStateStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TunerStateStatus"

void serializeJson (const ::SPM_CORE_FI::TunerStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTunerState()) {
        yajl_gen_string(g, (const unsigned char*)  "TunerState" , 10);
        const char* s = ::spm_core_fi_types::T_SPM_e32_TUNER_STATE_Name(value.getTunerState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTunerState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::TunerStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ChangeTunerStateStart"

void serializeJson (const ::SPM_CORE_FI::ChangeTunerStateStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTunerState()) {
        yajl_gen_string(g, (const unsigned char*)  "TunerState" , 10);
        const char* s = ::spm_core_fi_types::T_SPM_e32_TUNER_STATE_Name(value.getTunerState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTunerState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ChangeTunerStateStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WifiStateStatus"

void serializeJson (const ::SPM_CORE_FI::WifiStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasWiFiState()) {
        yajl_gen_string(g, (const unsigned char*)  "WiFiState" , 9);
        const char* s = ::spm_core_fi_types::T_SPM_e32_WIFI_STATE_Name(value.getWiFiState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getWiFiState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::WifiStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ChangeWifiStateStart"

void serializeJson (const ::SPM_CORE_FI::ChangeWifiStateStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasWiFiState()) {
        yajl_gen_string(g, (const unsigned char*)  "WiFiState" , 9);
        const char* s = ::spm_core_fi_types::T_SPM_e32_WIFI_STATE_Name(value.getWiFiState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getWiFiState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ChangeWifiStateStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ShutdownAndTerminateCcaAppsStart"

void serializeJson (const ::SPM_CORE_FI::ShutdownAndTerminateCcaAppsStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTAppIdList()) {
        yajl_gen_string(g, (const unsigned char*)  "tAppIdList" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< uint16 >& o37 = value.getTAppIdList();
        {
            ::std::vector< uint16 >::const_iterator o36;
            for (o36 = o37.begin(); o36 != o37.end(); ++o36) {
                yajl_gen_integer(g, (long long)(*o36));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ShutdownAndTerminateCcaAppsStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OnOffReasonStatus"

void serializeJson (const ::SPM_CORE_FI::OnOffReasonStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOnOffReason()) {
        yajl_gen_string(g, (const unsigned char*)  "OnOffReason" , 11);
        const char* s = ::spm_core_fi_types::T_SPM_e32_OnOffReason_Name(value.getOnOffReason());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getOnOffReason());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::OnOffReasonStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OnOffReasonSet"

void serializeJson (const ::SPM_CORE_FI::OnOffReasonSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOnOffReason()) {
        yajl_gen_string(g, (const unsigned char*)  "OnOffReason" , 11);
        const char* s = ::spm_core_fi_types::T_SPM_e32_OnOffReason_Name(value.getOnOffReason());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getOnOffReason());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::OnOffReasonSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WakeupListStatus"

void serializeJson (const ::SPM_CORE_FI::WakeupListStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasWakeUpReason1()) {
        yajl_gen_string(g, (const unsigned char*)  "WakeUpReason1" , 13);
        const char* s = ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON_Name(value.getWakeUpReason1());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getWakeUpReason1());
    }
    if (!isSparse || value.hasWakeUpReason2()) {
        yajl_gen_string(g, (const unsigned char*)  "WakeUpReason2" , 13);
        const char* s = ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON_Name(value.getWakeUpReason2());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getWakeUpReason2());
    }
    if (!isSparse || value.hasWakeUpReason3()) {
        yajl_gen_string(g, (const unsigned char*)  "WakeUpReason3" , 13);
        const char* s = ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON_Name(value.getWakeUpReason3());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getWakeUpReason3());
    }
    if (!isSparse || value.hasWakeUpReason4()) {
        yajl_gen_string(g, (const unsigned char*)  "WakeUpReason4" , 13);
        const char* s = ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON_Name(value.getWakeUpReason4());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getWakeUpReason4());
    }
    if (!isSparse || value.hasWakeUpReason5()) {
        yajl_gen_string(g, (const unsigned char*)  "WakeUpReason5" , 13);
        const char* s = ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON_Name(value.getWakeUpReason5());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getWakeUpReason5());
    }
    if (!isSparse || value.hasWakeUpReason6()) {
        yajl_gen_string(g, (const unsigned char*)  "WakeUpReason6" , 13);
        const char* s = ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON_Name(value.getWakeUpReason6());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getWakeUpReason6());
    }
    if (!isSparse || value.hasWakeUpReason7()) {
        yajl_gen_string(g, (const unsigned char*)  "WakeUpReason7" , 13);
        const char* s = ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON_Name(value.getWakeUpReason7());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getWakeUpReason7());
    }
    if (!isSparse || value.hasWakeUpReason8()) {
        yajl_gen_string(g, (const unsigned char*)  "WakeUpReason8" , 13);
        const char* s = ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON_Name(value.getWakeUpReason8());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getWakeUpReason8());
    }
    if (!isSparse || value.hasWakeUpReason9()) {
        yajl_gen_string(g, (const unsigned char*)  "WakeUpReason9" , 13);
        const char* s = ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON_Name(value.getWakeUpReason9());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getWakeUpReason9());
    }
    if (!isSparse || value.hasWakeUpReason10()) {
        yajl_gen_string(g, (const unsigned char*)  "WakeUpReason10" , 14);
        const char* s = ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON_Name(value.getWakeUpReason10());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getWakeUpReason10());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::WakeupListStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WakeupListSet"

void serializeJson (const ::SPM_CORE_FI::WakeupListSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasWakeupList()) {
        yajl_gen_string(g, (const unsigned char*)  "WakeupList" , 10);
        yajl_gen_integer(g, (long long)value.getWakeupList());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::WakeupListSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartupFinishedStatus"

void serializeJson (const ::SPM_CORE_FI::StartupFinishedStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStartupFinishedState()) {
        yajl_gen_string(g, (const unsigned char*)  "StartupFinishedState" , 20);
        yajl_gen_bool(g, (bool)value.getStartupFinishedState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::StartupFinishedStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SysStateStatus"

void serializeJson (const ::SPM_CORE_FI::SysStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSysState()) {
        yajl_gen_string(g, (const unsigned char*)  "SysState" , 8);
        const char* s = ::spm_core_fi_types::T_SPM_e32_SYS_STATE_Name(value.getSysState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSysState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SysStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MostStateStatus"

void serializeJson (const ::SPM_CORE_FI::MostStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMostEvent()) {
        yajl_gen_string(g, (const unsigned char*)  "MostEvent" , 9);
        const char* s = ::spm_core_fi_types::T_SPM_e32_MOST_EVENT_Name(value.getMostEvent());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getMostEvent());
    }
    if (!isSparse || value.hasMostConfigurationState()) {
        yajl_gen_string(g, (const unsigned char*)  "MostConfigurationState" , 22);
        const char* s = ::spm_core_fi_types::T_SPM_e32_MOST_CONFIG_STATE_Name(value.getMostConfigurationState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getMostConfigurationState());
    }
    if (!isSparse || value.hasFirstReceiveTime()) {
        yajl_gen_string(g, (const unsigned char*)  "FirstReceiveTime" , 16);
        yajl_gen_integer(g, (long long)value.getFirstReceiveTime());
    }
    if (!isSparse || value.hasTLAState()) {
        yajl_gen_string(g, (const unsigned char*)  "TLAState" , 8);
        const char* s = ::spm_core_fi_types::T_SPM_e32_TLA_STATE_Name(value.getTLAState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTLAState());
    }
    if (!isSparse || value.hasOvertemperatureMostOff()) {
        yajl_gen_string(g, (const unsigned char*)  "OvertemperatureMostOff" , 22);
        yajl_gen_bool(g, (bool)value.getOvertemperatureMostOff());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::MostStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MostVersionStatus"

void serializeJson (const ::SPM_CORE_FI::MostVersionStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMostVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "MostVersion" , 11);
        const char *s = value.getMostVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::MostVersionStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RVCStateStatus"

void serializeJson (const ::SPM_CORE_FI::RVCStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasState()) {
        yajl_gen_string(g, (const unsigned char*)  "State" , 5);
        yajl_gen_bool(g, (bool)value.getState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::RVCStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RVCStateSet"

void serializeJson (const ::SPM_CORE_FI::RVCStateSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasState()) {
        yajl_gen_string(g, (const unsigned char*)  "State" , 5);
        yajl_gen_bool(g, (bool)value.getState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::RVCStateSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TriggerMostRemoteResetStatus"

void serializeJson (const ::SPM_CORE_FI::TriggerMostRemoteResetStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTrigger()) {
        yajl_gen_string(g, (const unsigned char*)  "Trigger" , 7);
        yajl_gen_integer(g, (long long)value.getTrigger());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::TriggerMostRemoteResetStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PartnumberStatus"

void serializeJson (const ::SPM_CORE_FI::PartnumberStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPartnumber()) {
        yajl_gen_string(g, (const unsigned char*)  "Partnumber" , 10);
        yajl_gen_integer(g, (long long)value.getPartnumber());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::PartnumberStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PartnumberSet"

void serializeJson (const ::SPM_CORE_FI::PartnumberSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPart()) {
        yajl_gen_string(g, (const unsigned char*)  "Part" , 4);
        const char *s = value.getPart().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "Number" , 6);
        yajl_gen_integer(g, (long long)value.getNumber());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::PartnumberSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PartnumberGet"

void serializeJson (const ::SPM_CORE_FI::PartnumberGet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPart()) {
        yajl_gen_string(g, (const unsigned char*)  "Part" , 4);
        const char *s = value.getPart().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::PartnumberGet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PartnumbersStatus"

void serializeJson (const ::SPM_CORE_FI::PartnumbersStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasParts()) {
        yajl_gen_string(g, (const unsigned char*)  "Parts" , 5);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_PartnumberItem >& o39 = value.getParts();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_PartnumberItem >::const_iterator o38;
            for (o38 = o39.begin(); o38 != o39.end(); ++o38) {
                serializeJson((*o38), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::PartnumbersStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AlphacodeStatus"

void serializeJson (const ::SPM_CORE_FI::AlphacodeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAlphacode1()) {
        yajl_gen_string(g, (const unsigned char*)  "Alphacode1" , 10);
        yajl_gen_integer(g, (long long)value.getAlphacode1());
    }
    if (!isSparse || value.hasAlphacode2()) {
        yajl_gen_string(g, (const unsigned char*)  "Alphacode2" , 10);
        yajl_gen_integer(g, (long long)value.getAlphacode2());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::AlphacodeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AlphacodeSet"

void serializeJson (const ::SPM_CORE_FI::AlphacodeSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPart()) {
        yajl_gen_string(g, (const unsigned char*)  "Part" , 4);
        const char *s = value.getPart().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasAlphacode1()) {
        yajl_gen_string(g, (const unsigned char*)  "Alphacode1" , 10);
        yajl_gen_integer(g, (long long)value.getAlphacode1());
    }
    if (!isSparse || value.hasAlphacode2()) {
        yajl_gen_string(g, (const unsigned char*)  "Alphacode2" , 10);
        yajl_gen_integer(g, (long long)value.getAlphacode2());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::AlphacodeSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AlphacodeGet"

void serializeJson (const ::SPM_CORE_FI::AlphacodeGet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPart()) {
        yajl_gen_string(g, (const unsigned char*)  "Part" , 4);
        const char *s = value.getPart().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::AlphacodeGet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AlphacodesStatus"

void serializeJson (const ::SPM_CORE_FI::AlphacodesStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasParts()) {
        yajl_gen_string(g, (const unsigned char*)  "Parts" , 5);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_AlphacodeItem >& o41 = value.getParts();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_AlphacodeItem >::const_iterator o40;
            for (o40 = o41.begin(); o40 != o41.end(); ++o40) {
                serializeJson((*o40), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::AlphacodesStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetFactorySettingsNewStart"

void serializeJson (const ::SPM_CORE_FI::SetFactorySettingsNewStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDefSetStateGroup()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateGroup" , 16);
        const char* s = ::spm_diag_defset_fi_types::T_e8_DiaglogDefsetType_Name(value.getDefSetStateGroup());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDefSetStateGroup());
    }
    if (!isSparse || value.hasDefSetStateMode()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateMode" , 15);
        const char* s = ::spm_diag_defset_fi_types::T_e8_DefSetMode_Name(value.getDefSetStateMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDefSetStateMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SetFactorySettingsNewStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetFactorySettingsNewResult"

void serializeJson (const ::SPM_CORE_FI::SetFactorySettingsNewResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDefSetStateGroup()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateGroup" , 16);
        const char* s = ::spm_diag_defset_fi_types::T_e8_DiaglogDefsetType_Name(value.getDefSetStateGroup());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDefSetStateGroup());
    }
    if (!isSparse || value.hasDefSetStateMode()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateMode" , 15);
        const char* s = ::spm_diag_defset_fi_types::T_e8_DefSetMode_Name(value.getDefSetStateMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDefSetStateMode());
    }
    if (!isSparse || value.hasDefSetStateSuccessful()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateSuccessful" , 21);
        yajl_gen_bool(g, (bool)value.getDefSetStateSuccessful());
    }
    if (!isSparse || value.hasDefSetStateFirstDifferentParameterId()) {
        yajl_gen_string(g, (const unsigned char*)  "DefSetStateFirstDifferentParameterId" , 36);
        yajl_gen_integer(g, (long long)value.getDefSetStateFirstDifferentParameterId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SetFactorySettingsNewResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ManufacturersEnableCounterStatus"

void serializeJson (const ::SPM_CORE_FI::ManufacturersEnableCounterStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMEC()) {
        yajl_gen_string(g, (const unsigned char*)  "MEC" , 3);
        yajl_gen_integer(g, (long long)value.getMEC());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ManufacturersEnableCounterStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ManufacturersEnableCounterSet"

void serializeJson (const ::SPM_CORE_FI::ManufacturersEnableCounterSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMEC()) {
        yajl_gen_string(g, (const unsigned char*)  "MEC" , 3);
        yajl_gen_integer(g, (long long)value.getMEC());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ManufacturersEnableCounterSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NoCalibrationStateStatus"

void serializeJson (const ::SPM_CORE_FI::NoCalibrationStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasState()) {
        yajl_gen_string(g, (const unsigned char*)  "State" , 5);
        yajl_gen_bool(g, (bool)value.getState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::NoCalibrationStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NoCalibrationStateSet"

void serializeJson (const ::SPM_CORE_FI::NoCalibrationStateSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasState()) {
        yajl_gen_string(g, (const unsigned char*)  "State" , 5);
        yajl_gen_bool(g, (bool)value.getState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::NoCalibrationStateSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SecurityCommErrorStatus"

void serializeJson (const ::SPM_CORE_FI::SecurityCommErrorStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCommErrorCount()) {
        yajl_gen_string(g, (const unsigned char*)  "CommErrorCount" , 14);
        yajl_gen_integer(g, (long long)value.getCommErrorCount());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SecurityCommErrorStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SecurityMoreThan10VinStatus"

void serializeJson (const ::SPM_CORE_FI::SecurityMoreThan10VinStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMoreThan10VinCount()) {
        yajl_gen_string(g, (const unsigned char*)  "MoreThan10VinCount" , 18);
        yajl_gen_integer(g, (long long)value.getMoreThan10VinCount());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SecurityMoreThan10VinStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SecurityInvalidVinStatus"

void serializeJson (const ::SPM_CORE_FI::SecurityInvalidVinStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasInvalidVinCount()) {
        yajl_gen_string(g, (const unsigned char*)  "InvalidVinCount" , 15);
        yajl_gen_integer(g, (long long)value.getInvalidVinCount());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SecurityInvalidVinStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SecurityCurrentVinStatus"

void serializeJson (const ::SPM_CORE_FI::SecurityCurrentVinStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCurrentVin()) {
        yajl_gen_string(g, (const unsigned char*)  "CurrentVin" , 10);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o43 = value.getCurrentVin();
        {
            ::std::vector< uint8 >::const_iterator o42;
            for (o42 = o43.begin(); o42 != o43.end(); ++o42) {
                yajl_gen_integer(g, (long long)(*o42));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SecurityCurrentVinStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SecurityVinHistoryStatus"

void serializeJson (const ::SPM_CORE_FI::SecurityVinHistoryStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVinHistory()) {
        yajl_gen_string(g, (const unsigned char*)  "VinHistory" , 10);
        yajl_gen_array_open(g);
        const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_Vin >& o45 = value.getVinHistory();
        {
            ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_Vin >::const_iterator o44;
            for (o44 = o45.begin(); o44 != o45.end(); ++o44) {
                yajl_gen_array_open(g);
                const ::std::vector< uint8 >& o47 = (*o44);
                {
                    ::std::vector< uint8 >::const_iterator o46;
                    for (o46 = o47.begin(); o46 != o47.end(); ++o46) {
                        yajl_gen_integer(g, (long long)(*o46));
                    }
                }
                yajl_gen_array_close(g);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SecurityVinHistoryStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ClearVINResult"

void serializeJson (const ::SPM_CORE_FI::ClearVINResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ClearVINResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VINStatus"

void serializeJson (const ::SPM_CORE_FI::VINStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVehicleIdentificationNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "VehicleIdentificationNumber" , 27);
        const char *s = value.getVehicleIdentificationNumber().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::VINStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SecurityStateStatus"

void serializeJson (const ::SPM_CORE_FI::SecurityStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasState()) {
        yajl_gen_string(g, (const unsigned char*)  "State" , 5);
        const char* s = ::spm_core_fi_types::T_SPM_e32_SECURITY_STATE_Name(value.getState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SecurityStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VehicleIDStatus"

void serializeJson (const ::SPM_CORE_FI::VehicleIDStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32VehicleID()) {
        yajl_gen_string(g, (const unsigned char*)  "u32VehicleID" , 12);
        yajl_gen_integer(g, (long long)value.getU32VehicleID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::VehicleIDStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DisplayVariantStatus"

void serializeJson (const ::SPM_CORE_FI::DisplayVariantStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDisplayVariantNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "DisplayVariantNumber" , 20);
        yajl_gen_integer(g, (long long)value.getDisplayVariantNumber());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::DisplayVariantStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DisplayVariantSet"

void serializeJson (const ::SPM_CORE_FI::DisplayVariantSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDisplayVariantNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "DisplayVariantNumber" , 20);
        yajl_gen_integer(g, (long long)value.getDisplayVariantNumber());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::DisplayVariantSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReductionLevelStatus"

void serializeJson (const ::SPM_CORE_FI::ReductionLevelStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasReductionLevelState()) {
        yajl_gen_string(g, (const unsigned char*)  "ReductionLevelState" , 19);
        const char* s = ::spm_core_fi_types::T_SPM_e32_REDUCTION_LEVEL_Name(value.getReductionLevelState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getReductionLevelState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::ReductionLevelStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PrepareDownloadStart"

void serializeJson (const ::SPM_CORE_FI::PrepareDownloadStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasConfiguration()) {
        yajl_gen_string(g, (const unsigned char*)  "Configuration" , 13);
        yajl_gen_integer(g, (long long)value.getConfiguration());
    }
    if (!isSparse || value.hasSuspendBusShutdown()) {
        yajl_gen_string(g, (const unsigned char*)  "SuspendBusShutdown" , 18);
        yajl_gen_bool(g, (bool)value.getSuspendBusShutdown());
    }
    if (!isSparse || value.hasTimeout()) {
        yajl_gen_string(g, (const unsigned char*)  "Timeout" , 7);
        yajl_gen_integer(g, (long long)value.getTimeout());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::PrepareDownloadStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PrepareDownloadResult"

void serializeJson (const ::SPM_CORE_FI::PrepareDownloadResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::PrepareDownloadResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EndDownloadResult"

void serializeJson (const ::SPM_CORE_FI::EndDownloadResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::EndDownloadResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetOnConfigurationStart"

void serializeJson (const ::SPM_CORE_FI::SetOnConfigurationStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasConfiguration()) {
        yajl_gen_string(g, (const unsigned char*)  "Configuration" , 13);
        yajl_gen_integer(g, (long long)value.getConfiguration());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SetOnConfigurationStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetOnConfigurationResult"

void serializeJson (const ::SPM_CORE_FI::SetOnConfigurationResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SetOnConfigurationResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetProcessConfigurationStart"

void serializeJson (const ::SPM_CORE_FI::SetProcessConfigurationStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasConfiguration()) {
        yajl_gen_string(g, (const unsigned char*)  "Configuration" , 13);
        yajl_gen_integer(g, (long long)value.getConfiguration());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SetProcessConfigurationStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetProcessConfigurationResult"

void serializeJson (const ::SPM_CORE_FI::SetProcessConfigurationResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::SetProcessConfigurationResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartupStateStatus"

void serializeJson (const ::SPM_CORE_FI::StartupStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStartupState()) {
        yajl_gen_string(g, (const unsigned char*)  "StartupState" , 12);
        const char* s = ::spm_core_fi_types::T_SPM_e32_STARTUP_STATE_Name(value.getStartupState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStartupState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::StartupStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EntertainMuteStatus"

void serializeJson (const ::SPM_CORE_FI::EntertainMuteStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBMuteState()) {
        yajl_gen_string(g, (const unsigned char*)  "bMuteState" , 10);
        yajl_gen_bool(g, (bool)value.getBMuteState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::EntertainMuteStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EntertainDeMuteResult"

void serializeJson (const ::SPM_CORE_FI::EntertainDeMuteResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS32ReturnVal()) {
        yajl_gen_string(g, (const unsigned char*)  "s32ReturnVal" , 12);
        yajl_gen_integer(g, (long long)value.getS32ReturnVal());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::EntertainDeMuteResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EntertainMuteRequestResult"

void serializeJson (const ::SPM_CORE_FI::EntertainMuteRequestResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS32ReturnVal()) {
        yajl_gen_string(g, (const unsigned char*)  "s32ReturnVal" , 12);
        yajl_gen_integer(g, (long long)value.getS32ReturnVal());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::EntertainMuteRequestResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WelcomeAudioActivationStart"

void serializeJson (const ::SPM_CORE_FI::WelcomeAudioActivationStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBActivateState()) {
        yajl_gen_string(g, (const unsigned char*)  "bActivateState" , 14);
        yajl_gen_bool(g, (bool)value.getBActivateState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::WelcomeAudioActivationStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WelcomeAudioActivationResult"

void serializeJson (const ::SPM_CORE_FI::WelcomeAudioActivationResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS32ReturnVal()) {
        yajl_gen_string(g, (const unsigned char*)  "s32ReturnVal" , 12);
        yajl_gen_integer(g, (long long)value.getS32ReturnVal());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::WelcomeAudioActivationResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WelcomeAudioStateStatus"

void serializeJson (const ::SPM_CORE_FI::WelcomeAudioStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBEnabled()) {
        yajl_gen_string(g, (const unsigned char*)  "bEnabled" , 8);
        yajl_gen_bool(g, (bool)value.getBEnabled());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::WelcomeAudioStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnballastTimeFromEngineStoppedStatus"

void serializeJson (const ::SPM_CORE_FI::UnballastTimeFromEngineStoppedStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32TimeFromEngineStopped()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TimeFromEngineStopped" , 24);
        yajl_gen_integer(g, (long long)value.getU32TimeFromEngineStopped());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::UnballastTimeFromEngineStoppedStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnballastTimeBeforeUnballastStatus"

void serializeJson (const ::SPM_CORE_FI::UnballastTimeBeforeUnballastStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32UnballastTime()) {
        yajl_gen_string(g, (const unsigned char*)  "u32UnballastTime" , 16);
        yajl_gen_integer(g, (long long)value.getU32UnballastTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::UnballastTimeBeforeUnballastStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnballastTimeBeforeUnballastSet"

void serializeJson (const ::SPM_CORE_FI::UnballastTimeBeforeUnballastSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32UnballastTime()) {
        yajl_gen_string(g, (const unsigned char*)  "u32UnballastTime" , 16);
        yajl_gen_integer(g, (long long)value.getU32UnballastTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::UnballastTimeBeforeUnballastSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnballastWarningTimeStatus"

void serializeJson (const ::SPM_CORE_FI::UnballastWarningTimeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32UnballastWarningTime()) {
        yajl_gen_string(g, (const unsigned char*)  "u32UnballastWarningTime" , 23);
        yajl_gen_integer(g, (long long)value.getU32UnballastWarningTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::UnballastWarningTimeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnballastWarningTimeSet"

void serializeJson (const ::SPM_CORE_FI::UnballastWarningTimeSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32UnballastWarningTime()) {
        yajl_gen_string(g, (const unsigned char*)  "u32UnballastWarningTime" , 23);
        yajl_gen_integer(g, (long long)value.getU32UnballastWarningTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::UnballastWarningTimeSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DegradedCountStatus"

void serializeJson (const ::SPM_CORE_FI::DegradedCountStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32DegradedCount()) {
        yajl_gen_string(g, (const unsigned char*)  "u32DegradedCount" , 16);
        yajl_gen_integer(g, (long long)value.getU32DegradedCount());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::DegradedCountStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DegradedTimeStatus"

void serializeJson (const ::SPM_CORE_FI::DegradedTimeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32DegradedTime()) {
        yajl_gen_string(g, (const unsigned char*)  "u32DegradedTime" , 15);
        yajl_gen_integer(g, (long long)value.getU32DegradedTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::DegradedTimeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PhoneHandoverWarnTimeStatus"

void serializeJson (const ::SPM_CORE_FI::PhoneHandoverWarnTimeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32Time()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Time" , 7);
        yajl_gen_integer(g, (long long)value.getU32Time());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::PhoneHandoverWarnTimeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PhoneHandoverWarnTimeSet"

void serializeJson (const ::SPM_CORE_FI::PhoneHandoverWarnTimeSet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU32Time()) {
        yajl_gen_string(g, (const unsigned char*)  "u32Time" , 7);
        yajl_gen_integer(g, (long long)value.getU32Time());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::SPM_CORE_FI::PhoneHandoverWarnTimeSet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SystemStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SystemModeStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SystemModeResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::DownloadLockStateStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::DownloadLockStateResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::DownloadLockStatesStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::UpdateLockStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::UpdateLockResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::UpdateLockStatesStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::OnOffTriggerStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ActiveOnOffTriggerStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SubStatesStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SubStatesSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::HistoryTriggerStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::InsertStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::MediaEjectStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::PhoneMuteStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::OnTipperStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::IgnitionCyclesStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SysPwrModeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SysPwrSaveModeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::MapDownloadLockStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::StandbyTimeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::StandbyTimeSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::PersitentStandbyTimeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::PersitentStandbyTimeSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::IgnitionOffTimeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::IgnitionOffTimeSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::DoorOpenTimeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::DoorOpenTimeSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ClockDisplayTimeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ClockDisplayTimeSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SystemStateTimeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SystemStateTimeSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SystemStateTimeGet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ProcessListStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::StartProcessStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::StartProcessResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::StopProcessStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::StopProcessResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::RestartProcessStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::RestartProcessResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::WakeupReasonStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::StartupReasonStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ConnectToBatteryStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::CodeRequestStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::CodeRequestStateSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::StartUpSyncPointReachedStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ActiveStartUpSyncPointsStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::CvmEventStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::UBatSenseStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::CoproStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::CoproStateSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::DevicePowerOnTimeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::DevicePowerOnTimeSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::LastSystemRuntimeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::CurrentSystemRuntimeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ResetListStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ResetListSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ResetCounterStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ResetCounterSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::TransportModeListStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::TransportModeListSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ResetHistoryStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::WakeupHistoryStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::StateHistoryStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ErrStateHistory01Status& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ErrStateHistory02Status& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ErrStateHistory03Status& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ErrStateHistory04Status& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ErrStateHistory05Status& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SwitchOnHistoryStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ClearListStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::DeviceOnCounterStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::VoltageEventCounterStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::VoltageRangeHistogramStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::CpuUsageStatisticStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::RamUsageStatisticStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::StartupTimeStatisticStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SWVersionStatisticStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SpecificSWVersionStatisticStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SpecificSWVersionStatisticResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::RestartSystemStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::RestartSystemResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::RunlevelStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::RestartStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::RestartSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::LifesignStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::HmiStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SystemPowerBehaviourStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::AudioSourceChangeStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::DimStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::DimmingStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::BluetoothStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ChangeBluetoothStateStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::AudioStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ChangeAudioStateStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SpiStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ChangeSpiStateStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::TunerStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ChangeTunerStateStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::WifiStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ChangeWifiStateStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ShutdownAndTerminateCcaAppsStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::OnOffReasonStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::OnOffReasonSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::WakeupListStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::WakeupListSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::StartupFinishedStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SysStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::MostStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::MostVersionStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::RVCStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::RVCStateSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::TriggerMostRemoteResetStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::PartnumberStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::PartnumberSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::PartnumberGet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::PartnumbersStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::AlphacodeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::AlphacodeSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::AlphacodeGet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::AlphacodesStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SetFactorySettingsNewStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SetFactorySettingsNewResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ManufacturersEnableCounterStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ManufacturersEnableCounterSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::NoCalibrationStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::NoCalibrationStateSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SecurityCommErrorStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SecurityMoreThan10VinStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SecurityInvalidVinStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SecurityCurrentVinStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SecurityVinHistoryStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ClearVINResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::VINStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SecurityStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::VehicleIDStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::DisplayVariantStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::DisplayVariantSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::ReductionLevelStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::PrepareDownloadStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::PrepareDownloadResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::EndDownloadResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SetOnConfigurationStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SetOnConfigurationResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SetProcessConfigurationStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::SetProcessConfigurationResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::StartupStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::EntertainMuteStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::EntertainDeMuteResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::EntertainMuteRequestResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::WelcomeAudioActivationStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::WelcomeAudioActivationResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::WelcomeAudioStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::UnballastTimeFromEngineStoppedStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::UnballastTimeBeforeUnballastStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::UnballastTimeBeforeUnballastSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::UnballastWarningTimeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::UnballastWarningTimeSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::DegradedCountStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::DegradedTimeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::PhoneHandoverWarnTimeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI
using namespace ::asf::stream::json;

namespace SPM_CORE_FI {

std::ostream& operator<<(std::ostream& o, const ::SPM_CORE_FI::PhoneHandoverWarnTimeSet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace SPM_CORE_FI

