/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "smartphoneint_main_fi.h"
#include "smartphoneint_main_fiCca.h"
#include "smartphoneint_main_fi_types.h"
#include "smartphoneint_main_fi_typesCca.h"
#include "smartphoneint_main_fi_typesConst.h"
#include <string>
#include <vector>


void serializeCca(const ::smartphoneint_main_fi::DeviceStatusInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceConnectionType();
    out << (uint8) in.getDeviceStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::DeviceStatusInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o0;
    in >> o0;
    out.setDeviceHandle(o0);
    uint8 o1;
    in >> o1;
    out.setDeviceConnectionType((::smartphoneint_main_fi_types::T_e8_DeviceConnectionType)o1);
    uint8 o2;
    in >> o2;
    out.setDeviceStatus((::smartphoneint_main_fi_types::T_e8_DeviceStatusInfo)o2);
}

void serializeCca(const ::smartphoneint_main_fi::AppStatusInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceConnectionType();
    out << (uint8) in.getAppStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::AppStatusInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o3;
    in >> o3;
    out.setDeviceHandle(o3);
    uint8 o4;
    in >> o4;
    out.setDeviceConnectionType((::smartphoneint_main_fi_types::T_e8_DeviceConnectionType)o4);
    uint8 o5;
    in >> o5;
    out.setAppStatus((::smartphoneint_main_fi_types::T_e8_AppStatusInfo)o5);
}

void serializeCca(const ::smartphoneint_main_fi::DAPStatusInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceConnectionType();
    out << (uint8) in.getDAPStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::DAPStatusInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o6;
    in >> o6;
    out.setDeviceHandle(o6);
    uint8 o7;
    in >> o7;
    out.setDeviceConnectionType((::smartphoneint_main_fi_types::T_e8_DeviceConnectionType)o7);
    uint8 o8;
    in >> o8;
    out.setDAPStatus((::smartphoneint_main_fi_types::T_e8_DAPStatus)o8);
}

void serializeCca(const ::smartphoneint_main_fi::NotificationInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getAppHandle();
    serializeCca(in.getNotificationData(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::NotificationInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o9;
    in >> o9;
    out.setDeviceHandle(o9);
    uint32 o10;
    in >> o10;
    out.setAppHandle(o10);
    deserializeCca(in, out.getNotificationDataMutable(), majorVersion);
}

void serializeCca(const ::smartphoneint_main_fi::ApplicationMediaMetaDataStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getMetaDataValid();
    serializeCca(in.getApplicationMediaMetaData(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::ApplicationMediaMetaDataStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o11;
    in >> o11;
    out.setDeviceHandle(o11);
    bool o12;
    in >> o12;
    out.setMetaDataValid(o12);
    deserializeCca(in, out.getApplicationMediaMetaDataMutable(), majorVersion);
}

void serializeCca(const ::smartphoneint_main_fi::DeviceDisplayContextStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDisplayFlag();
    out << (uint8) in.getDisplayContextReason();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::DeviceDisplayContextStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o13;
    in >> o13;
    out.setDeviceHandle(o13);
    bool o14;
    in >> o14;
    out.setDisplayFlag(o14);
    uint8 o15;
    in >> o15;
    out.setDisplayContextReason((::smartphoneint_main_fi_types::T_e8_DisplayContextReason)o15);
}

void serializeCca(const ::smartphoneint_main_fi::ApplicationPhoneDataStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getPhoneDataValid();
    {
        uint32 o16 = static_cast<uint32>(in.getPhoneCallMetadata().size());
        out << o16;
        ::std::vector< ::smartphoneint_main_fi_types::T_ApplicationPhoneCallMetadata >::const_iterator o17;
        for (o17 = in.getPhoneCallMetadata().begin(); o17 != in.getPhoneCallMetadata().end(); ++o17) {
            serializeCca((*o17), out, majorVersion);
        }
    }
    out << (uint8) in.getSignalStrength();
    out << (uint8) in.getRegistrationStatus();
    out << (uint8) in.getAirPlaneModeStatus();
    out << (uint8) in.getMute();
    out << in.getCarrierName();
    out << in.getBatteryChargeLevel();
    out << (uint8) in.getBatteryChargingState();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::ApplicationPhoneDataStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o18;
    in >> o18;
    out.setDeviceHandle(o18);
    bool o19;
    in >> o19;
    out.setPhoneDataValid(o19);
    {
        uint32 o20;
        in >> o20;
        out.getPhoneCallMetadataMutable().clear ();
        out.getPhoneCallMetadataMutable().reserve (o20);
        for (uint32 o21 = 0; o21 < o20; o21++) {
            ::smartphoneint_main_fi_types::T_ApplicationPhoneCallMetadata o22;
            deserializeCca(in, o22, majorVersion);
            out.getPhoneCallMetadataMutable().push_back (o22);
        }
    }
    uint8 o23;
    in >> o23;
    out.setSignalStrength((::smartphoneint_main_fi_types::T_e8_PhoneSignalStrength)o23);
    uint8 o24;
    in >> o24;
    out.setRegistrationStatus((::smartphoneint_main_fi_types::T_e8_PhoneRegistrationStatus)o24);
    uint8 o25;
    in >> o25;
    out.setAirPlaneModeStatus((::smartphoneint_main_fi_types::T_e8_PhoneAirPlaneModeStatus)o25);
    uint8 o26;
    in >> o26;
    out.setMute((::smartphoneint_main_fi_types::T_e8_Mute)o26);
    ::std::string o27;
    in >> o27;
    out.setCarrierName(o27);
    uint8 o28;
    in >> o28;
    out.setBatteryChargeLevel(o28);
    uint8 o29;
    in >> o29;
    out.setBatteryChargingState((::smartphoneint_main_fi_types::T_e8_BatteryChargingState)o29);
}

void serializeCca(const ::smartphoneint_main_fi::BluetoothDeviceStatusStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getBluetoothDeviceHandle();
    out << in.getProjectionDeviceHandle();
    out << in.getConnectedProfiles();
    out << (uint8) in.getBTChangeInfo();
    out << (uint8) in.getSameDevice();
    out << (uint8) in.getCallActiveStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::BluetoothDeviceStatusStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o30;
    in >> o30;
    out.setBluetoothDeviceHandle(o30);
    uint32 o31;
    in >> o31;
    out.setProjectionDeviceHandle(o31);
    uint8 o32;
    in >> o32;
    out.setConnectedProfiles(o32);
    uint8 o33;
    in >> o33;
    out.setBTChangeInfo((::smartphoneint_main_fi_types::T_e8_BTChangeInfo)o33);
    bool o34;
    in >> o34;
    out.setSameDevice(o34);
    bool o35;
    in >> o35;
    out.setCallActiveStatus(o35);
}

void serializeCca(const ::smartphoneint_main_fi::DeviceAudioContextStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getAudioFlag();
    out << (uint8) in.getAudioContext();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::DeviceAudioContextStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o36;
    in >> o36;
    out.setDeviceHandle(o36);
    bool o37;
    in >> o37;
    out.setAudioFlag(o37);
    uint8 o38;
    in >> o38;
    out.setAudioContext((::smartphoneint_main_fi_types::T_e8_AudioContext)o38);
}

void serializeCca(const ::smartphoneint_main_fi::DiPOAppStatusInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getAppStateSpeech();
    out << (uint8) in.getAppStatePhone();
    out << (uint8) in.getAppStateNavigation();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::DiPOAppStatusInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o39;
    in >> o39;
    out.setAppStateSpeech((::smartphoneint_main_fi_types::T_e8_SpeechAppState)o39);
    uint8 o40;
    in >> o40;
    out.setAppStatePhone((::smartphoneint_main_fi_types::T_e8_PhoneAppState)o40);
    uint8 o41;
    in >> o41;
    out.setAppStateNavigation((::smartphoneint_main_fi_types::T_e8_NavigationAppState)o41);
}

void serializeCca(const ::smartphoneint_main_fi::SessionStatusInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceCategory();
    out << (uint8) in.getSessionStatus();
    out << (uint8) in.getHandsetInteractionStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SessionStatusInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o42;
    in >> o42;
    out.setDeviceHandle(o42);
    uint8 o43;
    in >> o43;
    out.setDeviceCategory((::smartphoneint_main_fi_types::T_e8_DeviceCategory)o43);
    uint8 o44;
    in >> o44;
    out.setSessionStatus((::smartphoneint_main_fi_types::T_e8_SessionStatus)o44);
    uint8 o45;
    in >> o45;
    out.setHandsetInteractionStatus((::smartphoneint_main_fi_types::T_e8_HandsetInteraction)o45);
}

void serializeCca(const ::smartphoneint_main_fi::BTPairingRequiredStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSDevBTAddr();
    out << (uint8) in.getBPairingReqd();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::BTPairingRequiredStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o46;
    in >> o46;
    out.setSDevBTAddr(o46);
    bool o47;
    in >> o47;
    out.setBPairingReqd(o47);
}

void serializeCca(const ::smartphoneint_main_fi::MLServerKeyCapabilitiesStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getValidityOfData();
    out << in.getNumXDeviceKeys();
    {
        uint32 o48 = static_cast<uint32>(in.getXDeviceKeysList().size());
        out << o48;
        ::std::vector< ::smartphoneint_main_fi_types::T_XDeviceKeys >::const_iterator o49;
        for (o49 = in.getXDeviceKeysList().begin(); o49 != in.getXDeviceKeysList().end(); ++o49) {
            serializeCca((*o49), out, majorVersion);
        }
    }
    serializeCca(in.getRKeyCapabilities(), out, majorVersion);
    out << (uint8) in.getVoiceRecognitionSupportInfo();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::MLServerKeyCapabilitiesStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o50;
    in >> o50;
    out.setDeviceHandle(o50);
    uint16 o51;
    in >> o51;
    out.setValidityOfData(o51);
    uint16 o52;
    in >> o52;
    out.setNumXDeviceKeys(o52);
    {
        uint32 o53;
        in >> o53;
        out.getXDeviceKeysListMutable().clear ();
        out.getXDeviceKeysListMutable().reserve (o53);
        for (uint32 o54 = 0; o54 < o53; o54++) {
            ::smartphoneint_main_fi_types::T_XDeviceKeys o55;
            deserializeCca(in, o55, majorVersion);
            out.getXDeviceKeysListMutable().push_back (o55);
        }
    }
    deserializeCca(in, out.getRKeyCapabilitiesMutable(), majorVersion);
    uint8 o56;
    in >> o56;
    out.setVoiceRecognitionSupportInfo((::smartphoneint_main_fi_types::T_e8_SupportInfo)o56);
}

void serializeCca(const ::smartphoneint_main_fi::DialStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getTelephoneNumber();
    out << in.getDisplayContent();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::DialStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o57;
    in >> o57;
    out.setDeviceHandle(o57);
    ::std::string o58;
    in >> o58;
    out.setTelephoneNumber(o58);
    ::std::string o59;
    in >> o59;
    out.setDisplayContent(o59);
}

void serializeCca(const ::smartphoneint_main_fi::DialSet& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getPhoneCallState();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::DialSet& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o60;
    in >> o60;
    out.setDeviceHandle(o60);
    uint8 o61;
    in >> o61;
    out.setPhoneCallState((::smartphoneint_main_fi_types::T_e8_PhoneCallState)o61);
}

void serializeCca(const ::smartphoneint_main_fi::MediaPlayBackTimeStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getTotalPlayTime();
    out << in.getElapsedPlayTime();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::MediaPlayBackTimeStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o62;
    in >> o62;
    out.setDeviceHandle(o62);
    uint32 o63;
    in >> o63;
    out.setTotalPlayTime(o63);
    uint32 o64;
    in >> o64;
    out.setElapsedPlayTime(o64);
}

void serializeCca(const ::smartphoneint_main_fi::ProjectionDeviceAuthorizationStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getNumDevices();
    {
        uint32 o65 = static_cast<uint32>(in.getDeviceAuthInfoList().size());
        out << o65;
        ::std::vector< ::smartphoneint_main_fi_types::T_DeviceAuthInfo >::const_iterator o66;
        for (o66 = in.getDeviceAuthInfoList().begin(); o66 != in.getDeviceAuthInfoList().end(); ++o66) {
            serializeCca((*o66), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::ProjectionDeviceAuthorizationStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o67;
    in >> o67;
    out.setNumDevices(o67);
    {
        uint32 o68;
        in >> o68;
        out.getDeviceAuthInfoListMutable().clear ();
        out.getDeviceAuthInfoListMutable().reserve (o68);
        for (uint32 o69 = 0; o69 < o68; o69++) {
            ::smartphoneint_main_fi_types::T_DeviceAuthInfo o70;
            deserializeCca(in, o70, majorVersion);
            out.getDeviceAuthInfoListMutable().push_back (o70);
        }
    }
}

void serializeCca(const ::smartphoneint_main_fi::ProjectionDeviceAuthorizationSet& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getUserAuthorizationStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::ProjectionDeviceAuthorizationSet& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o71;
    in >> o71;
    out.setDeviceHandle(o71);
    uint8 o72;
    in >> o72;
    out.setUserAuthorizationStatus((::smartphoneint_main_fi_types::T_e8_UserAuthorizationStatus)o72);
}

void serializeCca(const ::smartphoneint_main_fi::NavigationStatusInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceCategory();
    out << (uint8) in.getNavigationStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::NavigationStatusInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o73;
    in >> o73;
    out.setDeviceHandle(o73);
    uint8 o74;
    in >> o74;
    out.setDeviceCategory((::smartphoneint_main_fi_types::T_e8_DeviceCategory)o74);
    uint8 o75;
    in >> o75;
    out.setNavigationStatus((::smartphoneint_main_fi_types::T_e8_NavigationAppState)o75);
}

void serializeCca(const ::smartphoneint_main_fi::NavigationNextTurnDataStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceCategory();
    out << in.getRoadName();
    out << (uint8) in.getTurnSide();
    out << (uint8) in.getNextTurnEvent();
    out << in.getImage();
    out << in.getTurnAngle();
    out << in.getTurnNumber();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::NavigationNextTurnDataStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o76;
    in >> o76;
    out.setDeviceHandle(o76);
    uint8 o77;
    in >> o77;
    out.setDeviceCategory((::smartphoneint_main_fi_types::T_e8_DeviceCategory)o77);
    ::std::string o78;
    in >> o78;
    out.setRoadName(o78);
    uint8 o79;
    in >> o79;
    out.setTurnSide((::smartphoneint_main_fi_types::T_e8_TurnSide)o79);
    uint8 o80;
    in >> o80;
    out.setNextTurnEvent((::smartphoneint_main_fi_types::T_e8_NextTurnEvent)o80);
    ::std::string o81;
    in >> o81;
    out.setImage(o81);
    int32 o82;
    in >> o82;
    out.setTurnAngle(o82);
    int32 o83;
    in >> o83;
    out.setTurnNumber(o83);
}

void serializeCca(const ::smartphoneint_main_fi::NavigationNextTurnDistanceDataStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceCategory();
    out << in.getDistanceInMeters();
    out << in.getTimeInSec();
    out << in.getDistanceToManeuver();
    out << (uint8) in.getManeuverDistanceUnits();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::NavigationNextTurnDistanceDataStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o84;
    in >> o84;
    out.setDeviceHandle(o84);
    uint8 o85;
    in >> o85;
    out.setDeviceCategory((::smartphoneint_main_fi_types::T_e8_DeviceCategory)o85);
    int32 o86;
    in >> o86;
    out.setDistanceInMeters(o86);
    int32 o87;
    in >> o87;
    out.setTimeInSec(o87);
    int32 o88;
    in >> o88;
    out.setDistanceToManeuver(o88);
    uint8 o89;
    in >> o89;
    out.setManeuverDistanceUnits((::smartphoneint_main_fi_types::T_e8_ManeuverDistanceUnits)o89);
}

void serializeCca(const ::smartphoneint_main_fi::AAPNotificationEventStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceCategory();
    out << in.getAAPNotificationId();
    out << in.getNotificationText();
    {
        uint32 o90 = static_cast<uint32>(in.getNotificationIcon().size());
        out << o90;
        ::std::vector< uint8 >::const_iterator o91;
        for (o91 = in.getNotificationIcon().begin(); o91 != in.getNotificationIcon().end(); ++o91) {
            out << (*o91);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::AAPNotificationEventStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o92;
    in >> o92;
    out.setDeviceHandle(o92);
    uint8 o93;
    in >> o93;
    out.setDeviceCategory((::smartphoneint_main_fi_types::T_e8_DeviceCategory)o93);
    ::std::string o94;
    in >> o94;
    out.setAAPNotificationId(o94);
    ::std::string o95;
    in >> o95;
    out.setNotificationText(o95);
    {
        uint32 o96;
        in >> o96;
        out.getNotificationIconMutable().clear ();
        out.getNotificationIconMutable().reserve (o96);
        for (uint32 o97 = 0; o97 < o96; o97++) {
            uint8 o98;
            in >> o98;
            out.getNotificationIconMutable().push_back(o98);
        }
    }
}

void serializeCca(const ::smartphoneint_main_fi::AAPNotificationEventSet& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getAAPNotificationId();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::AAPNotificationEventSet& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o99;
    in >> o99;
    out.setAAPNotificationId(o99);
}

void serializeCca(const ::smartphoneint_main_fi::MySPINBluetoothVoiceRecInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getBTVoiceRecRequest();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::MySPINBluetoothVoiceRecInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o100;
    in >> o100;
    out.setDeviceHandle(o100);
    uint8 o101;
    in >> o101;
    out.setBTVoiceRecRequest((::smartphoneint_main_fi_types::T_e8_BTVoiceRecRequest)o101);
}

void serializeCca(const ::smartphoneint_main_fi::MySPINBluetoothVoiceRecInfoSet& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getBTVoiceRecReqResponse();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::MySPINBluetoothVoiceRecInfoSet& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o102;
    in >> o102;
    out.setDeviceHandle(o102);
    uint8 o103;
    in >> o103;
    out.setBTVoiceRecReqResponse((::smartphoneint_main_fi_types::T_e8_BTVoiceRecRequestResponse)o103);
}

void serializeCca(const ::smartphoneint_main_fi::TechnologySelectionStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getSelectedTechnology();
    out << (uint8) in.getDeviceType();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::TechnologySelectionStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o104;
    in >> o104;
    out.setDeviceHandle(o104);
    uint8 o105;
    in >> o105;
    out.setSelectedTechnology((::smartphoneint_main_fi_types::T_e8_DeviceCategory)o105);
    uint8 o106;
    in >> o106;
    out.setDeviceType((::smartphoneint_main_fi_types::T_e8_DeviceType)o106);
}

void serializeCca(const ::smartphoneint_main_fi::TechnologySelectionSet& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getSelectedTechnology();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::TechnologySelectionSet& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o107;
    in >> o107;
    out.setDeviceHandle(o107);
    uint8 o108;
    in >> o108;
    out.setSelectedTechnology((::smartphoneint_main_fi_types::T_e8_DeviceCategory)o108);
}

void serializeCca(const ::smartphoneint_main_fi::WiFiCredentialsStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getAccessoryWiFiAPCredentials(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::WiFiCredentialsStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getAccessoryWiFiAPCredentialsMutable(), majorVersion);
}

void serializeCca(const ::smartphoneint_main_fi::TurnByTurnInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceCategory();
    serializeCca(in.getCarPlayTBTUpdate(), out, majorVersion);
    serializeCca(in.getAAutoTBTUpdate(), out, majorVersion);
    serializeCca(in.getBDCLTBTUpdate(), out, majorVersion);
    serializeCca(in.getMLTBTUpdate(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::TurnByTurnInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o109;
    in >> o109;
    out.setDeviceHandle(o109);
    uint8 o110;
    in >> o110;
    out.setDeviceCategory((::smartphoneint_main_fi_types::T_e8_DeviceCategory)o110);
    deserializeCca(in, out.getCarPlayTBTUpdateMutable(), majorVersion);
    deserializeCca(in, out.getAAutoTBTUpdateMutable(), majorVersion);
    deserializeCca(in, out.getBDCLTBTUpdateMutable(), majorVersion);
    deserializeCca(in, out.getMLTBTUpdateMutable(), majorVersion);
}

void serializeCca(const ::smartphoneint_main_fi::ProjectedVideoInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    serializeCca(in.getProjectedVideoAttributes(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::ProjectedVideoInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o111;
    in >> o111;
    out.setDeviceHandle(o111);
    deserializeCca(in, out.getProjectedVideoAttributesMutable(), majorVersion);
}

void serializeCca(const ::smartphoneint_main_fi::DeviceLockStatusStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceCategory();
    out << (uint8) in.getBDeviceLockStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::DeviceLockStatusStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o112;
    in >> o112;
    out.setDeviceHandle(o112);
    uint8 o113;
    in >> o113;
    out.setDeviceCategory((::smartphoneint_main_fi_types::T_e8_DeviceCategory)o113);
    bool o114;
    in >> o114;
    out.setBDeviceLockStatus(o114);
}

void serializeCca(const ::smartphoneint_main_fi::RelativelyActiveMediaAppStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getMediaAppHandle();
    out << (uint8) in.getMediaAppCategory();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::RelativelyActiveMediaAppStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o115;
    in >> o115;
    out.setMediaAppHandle(o115);
    uint8 o116;
    in >> o116;
    out.setMediaAppCategory((::smartphoneint_main_fi_types::T_e8Media_AppCategory)o116);
}

void serializeCca(const ::smartphoneint_main_fi::CarplayRouteGuidanceUpdateStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getSzDeviceBTMacAddress();
    serializeCca(in.getRouteGuidanceUpdate(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::CarplayRouteGuidanceUpdateStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o117;
    in >> o117;
    out.setDeviceHandle(o117);
    ::std::string o118;
    in >> o118;
    out.setSzDeviceBTMacAddress(o118);
    deserializeCca(in, out.getRouteGuidanceUpdateMutable(), majorVersion);
}

void serializeCca(const ::smartphoneint_main_fi::CarplayRouteGuidanceManeuverUpdateStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getSzDeviceBTMacAddress();
    serializeCca(in.getRouteGuidanceManeuverUpdate(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::CarplayRouteGuidanceManeuverUpdateStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o119;
    in >> o119;
    out.setDeviceHandle(o119);
    ::std::string o120;
    in >> o120;
    out.setSzDeviceBTMacAddress(o120);
    deserializeCca(in, out.getRouteGuidanceManeuverUpdateMutable(), majorVersion);
}

void serializeCca(const ::smartphoneint_main_fi::AAutoTurnByTurnInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    serializeCca(in.getAAutoTBTUpdate(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::AAutoTurnByTurnInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o121;
    in >> o121;
    out.setDeviceHandle(o121);
    deserializeCca(in, out.getAAutoTBTUpdateMutable(), majorVersion);
}

void serializeCca(const ::smartphoneint_main_fi::BDCLTurnByTurnInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    serializeCca(in.getBDCLTBTUpdate(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::BDCLTurnByTurnInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o122;
    in >> o122;
    out.setDeviceHandle(o122);
    deserializeCca(in, out.getBDCLTBTUpdateMutable(), majorVersion);
}

void serializeCca(const ::smartphoneint_main_fi::MLTurnByTurnInfoStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    serializeCca(in.getMLTBTUpdate(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::MLTurnByTurnInfoStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o123;
    in >> o123;
    out.setDeviceHandle(o123);
    deserializeCca(in, out.getMLTBTUpdateMutable(), majorVersion);
}

void serializeCca(const ::smartphoneint_main_fi::GetDeviceInfoListResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getNumDevices();
    {
        uint32 o124 = static_cast<uint32>(in.getDeviceInfoList().size());
        out << o124;
        ::std::vector< ::smartphoneint_main_fi_types::T_DeviceDetails >::const_iterator o125;
        for (o125 = in.getDeviceInfoList().begin(); o125 != in.getDeviceInfoList().end(); ++o125) {
            serializeCca((*o125), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::GetDeviceInfoListResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o126;
    in >> o126;
    out.setNumDevices(o126);
    {
        uint32 o127;
        in >> o127;
        out.getDeviceInfoListMutable().clear ();
        out.getDeviceInfoListMutable().reserve (o127);
        for (uint32 o128 = 0; o128 < o127; o128++) {
            ::smartphoneint_main_fi_types::T_DeviceDetails o129;
            deserializeCca(in, o129, majorVersion);
            out.getDeviceInfoListMutable().push_back (o129);
        }
    }
}

void serializeCca(const ::smartphoneint_main_fi::SelectDeviceStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceConnectionType();
    out << (uint8) in.getDeviceConnectionReq();
    out << (uint8) in.getDAPUsage();
    out << (uint8) in.getCDBUsage();
    out << (uint8) in.getDeviceCategory();
    out << (uint8) in.getSelectionType();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SelectDeviceStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o130;
    in >> o130;
    out.setDeviceHandle(o130);
    uint8 o131;
    in >> o131;
    out.setDeviceConnectionType((::smartphoneint_main_fi_types::T_e8_DeviceConnectionType)o131);
    uint8 o132;
    in >> o132;
    out.setDeviceConnectionReq((::smartphoneint_main_fi_types::T_e8_DeviceConnectionReq)o132);
    uint8 o133;
    in >> o133;
    out.setDAPUsage((::smartphoneint_main_fi_types::T_e8_EnabledInfo)o133);
    uint8 o134;
    in >> o134;
    out.setCDBUsage((::smartphoneint_main_fi_types::T_e8_EnabledInfo)o134);
    uint8 o135;
    in >> o135;
    out.setDeviceCategory((::smartphoneint_main_fi_types::T_e8_DeviceCategory)o135);
    uint8 o136;
    in >> o136;
    out.setSelectionType((::smartphoneint_main_fi_types::T_e8_SelectionType)o136);
}

void serializeCca(const ::smartphoneint_main_fi::SelectDeviceResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceConnectionType();
    out << (uint8) in.getDeviceConnectionReq();
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
    out << (uint8) in.getBTPairingRequired();
    out << (uint8) in.getDeviceCategory();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SelectDeviceResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o137;
    in >> o137;
    out.setDeviceHandle(o137);
    uint8 o138;
    in >> o138;
    out.setDeviceConnectionType((::smartphoneint_main_fi_types::T_e8_DeviceConnectionType)o138);
    uint8 o139;
    in >> o139;
    out.setDeviceConnectionReq((::smartphoneint_main_fi_types::T_e8_DeviceConnectionReq)o139);
    uint8 o140;
    in >> o140;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o140);
    uint8 o141;
    in >> o141;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o141);
    bool o142;
    in >> o142;
    out.setBTPairingRequired(o142);
    uint8 o143;
    in >> o143;
    out.setDeviceCategory((::smartphoneint_main_fi_types::T_e8_DeviceCategory)o143);
}

void serializeCca(const ::smartphoneint_main_fi::LaunchAppStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceCategory();
    out << in.getAppHandle();
    out << (uint8) in.getDiPOAppType();
    out << in.getTelephoneNumber();
    out << (uint8) in.getEcnrSetting();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::LaunchAppStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o144;
    in >> o144;
    out.setDeviceHandle(o144);
    uint8 o145;
    in >> o145;
    out.setDeviceCategory((::smartphoneint_main_fi_types::T_e8_DeviceCategory)o145);
    uint32 o146;
    in >> o146;
    out.setAppHandle(o146);
    uint8 o147;
    in >> o147;
    out.setDiPOAppType((::smartphoneint_main_fi_types::T_e8_DiPOAppType)o147);
    ::std::string o148;
    in >> o148;
    out.setTelephoneNumber(o148);
    uint8 o149;
    in >> o149;
    out.setEcnrSetting((::smartphoneint_main_fi_types::T_e8_EcnrSetting)o149);
}

void serializeCca(const ::smartphoneint_main_fi::LaunchAppResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getAppHandle();
    out << (uint8) in.getDiPOAppType();
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::LaunchAppResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o150;
    in >> o150;
    out.setDeviceHandle(o150);
    uint32 o151;
    in >> o151;
    out.setAppHandle(o151);
    uint8 o152;
    in >> o152;
    out.setDiPOAppType((::smartphoneint_main_fi_types::T_e8_DiPOAppType)o152);
    uint8 o153;
    in >> o153;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o153);
    uint8 o154;
    in >> o154;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o154);
}

void serializeCca(const ::smartphoneint_main_fi::TerminateAppStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getAppHandle();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::TerminateAppStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o155;
    in >> o155;
    out.setDeviceHandle(o155);
    uint32 o156;
    in >> o156;
    out.setAppHandle(o156);
}

void serializeCca(const ::smartphoneint_main_fi::TerminateAppResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getAppHandle();
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::TerminateAppResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o157;
    in >> o157;
    out.setDeviceHandle(o157);
    uint32 o158;
    in >> o158;
    out.setAppHandle(o158);
    uint8 o159;
    in >> o159;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o159);
    uint8 o160;
    in >> o160;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o160);
}

void serializeCca(const ::smartphoneint_main_fi::GetAppListStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::GetAppListStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o161;
    in >> o161;
    out.setDeviceHandle(o161);
}

void serializeCca(const ::smartphoneint_main_fi::GetAppListResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getNumAppDetailsList();
    {
        uint32 o162 = static_cast<uint32>(in.getAppDetailsList().size());
        out << o162;
        ::std::vector< ::smartphoneint_main_fi_types::T_AppDetails >::const_iterator o163;
        for (o163 = in.getAppDetailsList().begin(); o163 != in.getAppDetailsList().end(); ++o163) {
            serializeCca((*o163), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::GetAppListResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o164;
    in >> o164;
    out.setDeviceHandle(o164);
    uint16 o165;
    in >> o165;
    out.setNumAppDetailsList(o165);
    {
        uint32 o166;
        in >> o166;
        out.getAppDetailsListMutable().clear ();
        out.getAppDetailsListMutable().reserve (o166);
        for (uint32 o167 = 0; o167 < o166; o167++) {
            ::smartphoneint_main_fi_types::T_AppDetails o168;
            deserializeCca(in, o168, majorVersion);
            out.getAppDetailsListMutable().push_back (o168);
        }
    }
}

void serializeCca(const ::smartphoneint_main_fi::GetAppIconDataStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getAppIconURL();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::GetAppIconDataStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o169;
    in >> o169;
    out.setAppIconURL(o169);
}

void serializeCca(const ::smartphoneint_main_fi::GetAppIconDataResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getIconMimeType();
    {
        uint32 o170 = static_cast<uint32>(in.getAppIconData().size());
        out << o170;
        ::std::vector< uint8 >::const_iterator o171;
        for (o171 = in.getAppIconData().begin(); o171 != in.getAppIconData().end(); ++o171) {
            out << (*o171);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::GetAppIconDataResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o172;
    in >> o172;
    out.setIconMimeType(o172);
    {
        uint32 o173;
        in >> o173;
        out.getAppIconDataMutable().clear ();
        out.getAppIconDataMutable().reserve (o173);
        for (uint32 o174 = 0; o174 < o173; o174++) {
            uint8 o175;
            in >> o175;
            out.getAppIconDataMutable().push_back(o175);
        }
    }
}

void serializeCca(const ::smartphoneint_main_fi::SetAppIconAttributesStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getAppHandle();
    serializeCca(in.getIconAttributes(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetAppIconAttributesStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o176;
    in >> o176;
    out.setDeviceHandle(o176);
    uint32 o177;
    in >> o177;
    out.setAppHandle(o177);
    deserializeCca(in, out.getIconAttributesMutable(), majorVersion);
}

void serializeCca(const ::smartphoneint_main_fi::SetAppIconAttributesResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetAppIconAttributesResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o178;
    in >> o178;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o178);
    uint8 o179;
    in >> o179;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o179);
}

void serializeCca(const ::smartphoneint_main_fi::SetDeviceUsagePreferenceStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceCategory();
    out << (uint8) in.getEnabledInfo();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetDeviceUsagePreferenceStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o180;
    in >> o180;
    out.setDeviceHandle(o180);
    uint8 o181;
    in >> o181;
    out.setDeviceCategory((::smartphoneint_main_fi_types::T_e8_DeviceCategory)o181);
    uint8 o182;
    in >> o182;
    out.setEnabledInfo((::smartphoneint_main_fi_types::T_e8_EnabledInfo)o182);
}

void serializeCca(const ::smartphoneint_main_fi::SetDeviceUsagePreferenceResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetDeviceUsagePreferenceResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o183;
    in >> o183;
    out.setDeviceHandle(o183);
    uint8 o184;
    in >> o184;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o184);
    uint8 o185;
    in >> o185;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o185);
}

void serializeCca(const ::smartphoneint_main_fi::SetMLNotificationEnabledInfoStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getNumNotificationEnableList();
    {
        uint32 o186 = static_cast<uint32>(in.getNotificationEnableList().size());
        out << o186;
        ::std::vector< ::smartphoneint_main_fi_types::T_NotificationEnable >::const_iterator o187;
        for (o187 = in.getNotificationEnableList().begin(); o187 != in.getNotificationEnableList().end(); ++o187) {
            serializeCca((*o187), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetMLNotificationEnabledInfoStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o188;
    in >> o188;
    out.setDeviceHandle(o188);
    uint16 o189;
    in >> o189;
    out.setNumNotificationEnableList(o189);
    {
        uint32 o190;
        in >> o190;
        out.getNotificationEnableListMutable().clear ();
        out.getNotificationEnableListMutable().reserve (o190);
        for (uint32 o191 = 0; o191 < o190; o191++) {
            ::smartphoneint_main_fi_types::T_NotificationEnable o192;
            deserializeCca(in, o192, majorVersion);
            out.getNotificationEnableListMutable().push_back (o192);
        }
    }
}

void serializeCca(const ::smartphoneint_main_fi::SetMLNotificationEnabledInfoResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetMLNotificationEnabledInfoResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o193;
    in >> o193;
    out.setDeviceHandle(o193);
    uint8 o194;
    in >> o194;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o194);
    uint8 o195;
    in >> o195;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o195);
}

void serializeCca(const ::smartphoneint_main_fi::InvokeNotificationActionStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getAppHandle();
    out << in.getNotificationID();
    out << in.getNotificationActionID();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::InvokeNotificationActionStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o196;
    in >> o196;
    out.setDeviceHandle(o196);
    uint32 o197;
    in >> o197;
    out.setAppHandle(o197);
    uint16 o198;
    in >> o198;
    out.setNotificationID(o198);
    uint16 o199;
    in >> o199;
    out.setNotificationActionID(o199);
}

void serializeCca(const ::smartphoneint_main_fi::InvokeNotificationActionResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::InvokeNotificationActionResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o200;
    in >> o200;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o200);
    uint8 o201;
    in >> o201;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o201);
}

void serializeCca(const ::smartphoneint_main_fi::GetVideoSettingsStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::GetVideoSettingsStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o202;
    in >> o202;
    out.setDeviceHandle(o202);
}

void serializeCca(const ::smartphoneint_main_fi::GetVideoSettingsResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    serializeCca(in.getVideoAttributes(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::GetVideoSettingsResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o203;
    in >> o203;
    out.setDeviceHandle(o203);
    deserializeCca(in, out.getVideoAttributesMutable(), majorVersion);
}

void serializeCca(const ::smartphoneint_main_fi::SetOrientationModeStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getOrientationMode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetOrientationModeStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o204;
    in >> o204;
    out.setDeviceHandle(o204);
    uint8 o205;
    in >> o205;
    out.setOrientationMode((::smartphoneint_main_fi_types::T_e8_OrientationMode)o205);
}

void serializeCca(const ::smartphoneint_main_fi::SetOrientationModeResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetOrientationModeResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o206;
    in >> o206;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o206);
    uint8 o207;
    in >> o207;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o207);
}

void serializeCca(const ::smartphoneint_main_fi::SetScreenSizeStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getScreenAttributes(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetScreenSizeStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getScreenAttributesMutable(), majorVersion);
}

void serializeCca(const ::smartphoneint_main_fi::SetScreenSizeResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetScreenSizeResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o208;
    in >> o208;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o208);
    uint8 o209;
    in >> o209;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o209);
}

void serializeCca(const ::smartphoneint_main_fi::SetVideoBlockingModeStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getBlockingMode();
    out << (uint8) in.getVideoBlockingReason();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetVideoBlockingModeStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o210;
    in >> o210;
    out.setDeviceHandle(o210);
    uint8 o211;
    in >> o211;
    out.setBlockingMode((::smartphoneint_main_fi_types::T_e8_BlockingMode)o211);
    uint8 o212;
    in >> o212;
    out.setVideoBlockingReason((::smartphoneint_main_fi_types::T_e8_VideoBlockingReason)o212);
}

void serializeCca(const ::smartphoneint_main_fi::SetVideoBlockingModeResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetVideoBlockingModeResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o213;
    in >> o213;
    out.setDeviceHandle(o213);
    uint8 o214;
    in >> o214;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o214);
    uint8 o215;
    in >> o215;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o215);
}

void serializeCca(const ::smartphoneint_main_fi::SetAudioBlockingModeStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getGlobalMuteEnable();
    out << (uint8) in.getMediaAudioBlockingEnable();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetAudioBlockingModeStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o216;
    in >> o216;
    out.setGlobalMuteEnable(o216);
    bool o217;
    in >> o217;
    out.setMediaAudioBlockingEnable(o217);
}

void serializeCca(const ::smartphoneint_main_fi::SetAudioBlockingModeResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetAudioBlockingModeResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o218;
    in >> o218;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o218);
    uint8 o219;
    in >> o219;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o219);
}

void serializeCca(const ::smartphoneint_main_fi::SetVehicleConfigurationStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getVehicleConfiguration();
    out << (uint8) in.getSetConfiguration();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetVehicleConfigurationStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o220;
    in >> o220;
    out.setVehicleConfiguration((::smartphoneint_main_fi_types::T_e8_Vehicle_Configuration)o220);
    bool o221;
    in >> o221;
    out.setSetConfiguration(o221);
}

void serializeCca(const ::smartphoneint_main_fi::SetVehicleConfigurationResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetVehicleConfigurationResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o222;
    in >> o222;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o222);
    uint8 o223;
    in >> o223;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o223);
}

void serializeCca(const ::smartphoneint_main_fi::SendTouchEventStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    serializeCca(in.getTouchData(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SendTouchEventStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o224;
    in >> o224;
    out.setDeviceHandle(o224);
    deserializeCca(in, out.getTouchDataMutable(), majorVersion);
}

void serializeCca(const ::smartphoneint_main_fi::SendTouchEventResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SendTouchEventResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o225;
    in >> o225;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o225);
    uint8 o226;
    in >> o226;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o226);
}

void serializeCca(const ::smartphoneint_main_fi::SendKeyEventStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getKeyMode();
    out << (uint32) in.getKeyCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SendKeyEventStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o227;
    in >> o227;
    out.setDeviceHandle(o227);
    uint8 o228;
    in >> o228;
    out.setKeyMode((::smartphoneint_main_fi_types::T_e8_KeyMode)o228);
    uint32 o229;
    in >> o229;
    out.setKeyCode((::smartphoneint_main_fi_types::T_e32_KeyCode)o229);
}

void serializeCca(const ::smartphoneint_main_fi::SendKeyEventResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SendKeyEventResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o230;
    in >> o230;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o230);
    uint8 o231;
    in >> o231;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o231);
}

void serializeCca(const ::smartphoneint_main_fi::SetClientCapabilitiesStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getClientCapabilities(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetClientCapabilitiesStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getClientCapabilitiesMutable(), majorVersion);
}

void serializeCca(const ::smartphoneint_main_fi::SetClientCapabilitiesResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetClientCapabilitiesResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o232;
    in >> o232;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o232);
    uint8 o233;
    in >> o233;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o233);
}

void serializeCca(const ::smartphoneint_main_fi::AccessoryDisplayContextStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDisplayFlag();
    out << (uint8) in.getDisplayContext();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::AccessoryDisplayContextStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o234;
    in >> o234;
    out.setDeviceHandle(o234);
    bool o235;
    in >> o235;
    out.setDisplayFlag(o235);
    uint8 o236;
    in >> o236;
    out.setDisplayContext((::smartphoneint_main_fi_types::T_e8_DisplayContext)o236);
}

void serializeCca(const ::smartphoneint_main_fi::AccessoryDisplayContextResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::AccessoryDisplayContextResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o237;
    in >> o237;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o237);
    uint8 o238;
    in >> o238;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o238);
}

void serializeCca(const ::smartphoneint_main_fi::GetDeviceUsagePreferenceStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceCategory();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::GetDeviceUsagePreferenceStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o239;
    in >> o239;
    out.setDeviceHandle(o239);
    uint8 o240;
    in >> o240;
    out.setDeviceCategory((::smartphoneint_main_fi_types::T_e8_DeviceCategory)o240);
}

void serializeCca(const ::smartphoneint_main_fi::GetDeviceUsagePreferenceResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceCategory();
    out << (uint8) in.getEnabledInfo();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::GetDeviceUsagePreferenceResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o241;
    in >> o241;
    out.setDeviceHandle(o241);
    uint8 o242;
    in >> o242;
    out.setDeviceCategory((::smartphoneint_main_fi_types::T_e8_DeviceCategory)o242);
    uint8 o243;
    in >> o243;
    out.setEnabledInfo((::smartphoneint_main_fi_types::T_e8_EnabledInfo)o243);
}

void serializeCca(const ::smartphoneint_main_fi::SetVehicleBTAddressStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getBTAddress();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetVehicleBTAddressStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o244;
    in >> o244;
    out.setBTAddress(o244);
}

void serializeCca(const ::smartphoneint_main_fi::SetVehicleBTAddressResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetVehicleBTAddressResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o245;
    in >> o245;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o245);
    uint8 o246;
    in >> o246;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o246);
}

void serializeCca(const ::smartphoneint_main_fi::InvokeBluetoothDeviceActionStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getBluetoothDeviceHandle();
    out << in.getProjectionDeviceHandle();
    out << (uint8) in.getBTChangeInfo();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::InvokeBluetoothDeviceActionStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o247;
    in >> o247;
    out.setBluetoothDeviceHandle(o247);
    uint32 o248;
    in >> o248;
    out.setProjectionDeviceHandle(o248);
    uint8 o249;
    in >> o249;
    out.setBTChangeInfo((::smartphoneint_main_fi_types::T_e8_BTChangeInfo)o249);
}

void serializeCca(const ::smartphoneint_main_fi::InvokeBluetoothDeviceActionResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::InvokeBluetoothDeviceActionResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o250;
    in >> o250;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o250);
    uint8 o251;
    in >> o251;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o251);
}

void serializeCca(const ::smartphoneint_main_fi::AccessoryAudioContextStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getAudioFlag();
    out << (uint8) in.getAudioContext();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::AccessoryAudioContextStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o252;
    in >> o252;
    out.setDeviceHandle(o252);
    bool o253;
    in >> o253;
    out.setAudioFlag(o253);
    uint8 o254;
    in >> o254;
    out.setAudioContext((::smartphoneint_main_fi_types::T_e8_AudioContext)o254);
}

void serializeCca(const ::smartphoneint_main_fi::AccessoryAudioContextResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::AccessoryAudioContextResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o255;
    in >> o255;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o255);
    uint8 o256;
    in >> o256;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o256);
}

void serializeCca(const ::smartphoneint_main_fi::AccessoryAppStateStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getAppStateSpeech();
    out << (uint8) in.getAppStatePhone();
    out << (uint8) in.getAppStateNavigation();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::AccessoryAppStateStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o257;
    in >> o257;
    out.setAppStateSpeech((::smartphoneint_main_fi_types::T_e8_SpeechAppState)o257);
    uint8 o258;
    in >> o258;
    out.setAppStatePhone((::smartphoneint_main_fi_types::T_e8_PhoneAppState)o258);
    uint8 o259;
    in >> o259;
    out.setAppStateNavigation((::smartphoneint_main_fi_types::T_e8_NavigationAppState)o259);
}

void serializeCca(const ::smartphoneint_main_fi::AccessoryAppStateResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::AccessoryAppStateResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o260;
    in >> o260;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o260);
    uint8 o261;
    in >> o261;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o261);
}

void serializeCca(const ::smartphoneint_main_fi::SetRegionStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getRegion();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetRegionStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o262;
    in >> o262;
    out.setRegion((::smartphoneint_main_fi_types::T_e8_Region)o262);
}

void serializeCca(const ::smartphoneint_main_fi::SetRegionResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetRegionResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o263;
    in >> o263;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o263);
    uint8 o264;
    in >> o264;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o264);
}

void serializeCca(const ::smartphoneint_main_fi::DiPORoleSwitchRequiredStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8DeviceTag();
    out << in.getUSBSerialNumber();
    out << (uint8) in.getDeviceCarplayCapability();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::DiPORoleSwitchRequiredStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o265;
    in >> o265;
    out.setU8DeviceTag(o265);
    ::std::string o266;
    in >> o266;
    out.setUSBSerialNumber(o266);
    bool o267;
    in >> o267;
    out.setDeviceCarplayCapability(o267);
}

void serializeCca(const ::smartphoneint_main_fi::DiPORoleSwitchRequiredResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8DeviceTag();
    out << (uint8) in.getE8DiPOSwitchReqResponse();
    out << in.getUSBSerialNumber();
    serializeCca(in.getREAPAppInfo(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::DiPORoleSwitchRequiredResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o268;
    in >> o268;
    out.setU8DeviceTag(o268);
    uint8 o269;
    in >> o269;
    out.setE8DiPOSwitchReqResponse((::smartphoneint_main_fi_types::T_e8_DiPOSwitchReqResponse)o269);
    ::std::string o270;
    in >> o270;
    out.setUSBSerialNumber(o270);
    deserializeCca(in, out.getREAPAppInfoMutable(), majorVersion);
}

void serializeCca(const ::smartphoneint_main_fi::SetAccessoryDisplayContextStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    serializeCca(in.getDisplayContextInfo(), out, majorVersion);
    serializeCca(in.getDisplayConstraintInfo(), out, majorVersion);
    out << (uint8) in.getContextResponsibility();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetAccessoryDisplayContextStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o271;
    in >> o271;
    out.setDeviceHandle(o271);
    deserializeCca(in, out.getDisplayContextInfoMutable(), majorVersion);
    deserializeCca(in, out.getDisplayConstraintInfoMutable(), majorVersion);
    uint8 o272;
    in >> o272;
    out.setContextResponsibility((::smartphoneint_main_fi_types::T_e8_DisplayInfo)o272);
}

void serializeCca(const ::smartphoneint_main_fi::SetAccessoryDisplayContextResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetAccessoryDisplayContextResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o273;
    in >> o273;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o273);
    uint8 o274;
    in >> o274;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o274);
}

void serializeCca(const ::smartphoneint_main_fi::GetKeyIconDataStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getKeyIconURL();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::GetKeyIconDataStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o275;
    in >> o275;
    out.setDeviceHandle(o275);
    ::std::string o276;
    in >> o276;
    out.setKeyIconURL(o276);
}

void serializeCca(const ::smartphoneint_main_fi::GetKeyIconDataResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    {
        uint32 o277 = static_cast<uint32>(in.getKeyIconData().size());
        out << o277;
        ::std::vector< uint8 >::const_iterator o278;
        for (o278 = in.getKeyIconData().begin(); o278 != in.getKeyIconData().end(); ++o278) {
            out << (*o278);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::GetKeyIconDataResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o279;
    in >> o279;
    out.setDeviceHandle(o279);
    {
        uint32 o280;
        in >> o280;
        out.getKeyIconDataMutable().clear ();
        out.getKeyIconDataMutable().reserve (o280);
        for (uint32 o281 = 0; o281 < o280; o281++) {
            uint8 o282;
            in >> o282;
            out.getKeyIconDataMutable().push_back(o282);
        }
    }
}

void serializeCca(const ::smartphoneint_main_fi::SetDisplayAttributesStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getDisplayAttributes(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetDisplayAttributesStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getDisplayAttributesMutable(), majorVersion);
}

void serializeCca(const ::smartphoneint_main_fi::SetDisplayAttributesResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetDisplayAttributesResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o283;
    in >> o283;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o283);
    uint8 o284;
    in >> o284;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o284);
}

void serializeCca(const ::smartphoneint_main_fi::RotaryControllerEventStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getControllerDeltaCounts();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::RotaryControllerEventStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o285;
    in >> o285;
    out.setDeviceHandle(o285);
    int8 o286;
    in >> o286;
    out.setControllerDeltaCounts(o286);
}

void serializeCca(const ::smartphoneint_main_fi::RotaryControllerEventResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::RotaryControllerEventResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o287;
    in >> o287;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o287);
    uint8 o288;
    in >> o288;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o288);
}

void serializeCca(const ::smartphoneint_main_fi::SetAccessoryAudioContextStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    {
        uint32 o289 = static_cast<uint32>(in.getAudioContextInfo().size());
        out << o289;
        ::std::vector< ::smartphoneint_main_fi_types::T_AccessoryAudioContext >::const_iterator o290;
        for (o290 = in.getAudioContextInfo().begin(); o290 != in.getAudioContextInfo().end(); ++o290) {
            serializeCca((*o290), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetAccessoryAudioContextStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o291;
    in >> o291;
    out.setDeviceHandle(o291);
    {
        uint32 o292;
        in >> o292;
        out.getAudioContextInfoMutable().clear ();
        out.getAudioContextInfoMutable().reserve (o292);
        for (uint32 o293 = 0; o293 < o292; o293++) {
            ::smartphoneint_main_fi_types::T_AccessoryAudioContext o294;
            deserializeCca(in, o294, majorVersion);
            out.getAudioContextInfoMutable().push_back (o294);
        }
    }
}

void serializeCca(const ::smartphoneint_main_fi::SetAccessoryAudioContextResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetAccessoryAudioContextResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o295;
    in >> o295;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o295);
    uint8 o296;
    in >> o296;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o296);
}

void serializeCca(const ::smartphoneint_main_fi::SetVehicleMovementStateStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getParkBrakeInfo();
    out << (uint8) in.getGearInfo();
    out << (uint8) in.getVehicleState();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetVehicleMovementStateStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o297;
    in >> o297;
    out.setParkBrakeInfo((::smartphoneint_main_fi_types::T_e8_ParkBrake)o297);
    uint8 o298;
    in >> o298;
    out.setGearInfo((::smartphoneint_main_fi_types::T_e8_GearState)o298);
    uint8 o299;
    in >> o299;
    out.setVehicleState((::smartphoneint_main_fi_types::T_e8_VehicleState)o299);
}

void serializeCca(const ::smartphoneint_main_fi::SetVehicleMovementStateResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetVehicleMovementStateResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o300;
    in >> o300;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o300);
    uint8 o301;
    in >> o301;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o301);
}

void serializeCca(const ::smartphoneint_main_fi::SetFeatureRestrictionsStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getDeviceCategory();
    serializeCca(in.getParkModeRestrictionInfo(), out, majorVersion);
    serializeCca(in.getDriveModeRestrictionInfo(), out, majorVersion);
    out << in.getGeneralRestrictionInfo();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetFeatureRestrictionsStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o302;
    in >> o302;
    out.setDeviceCategory((::smartphoneint_main_fi_types::T_e8_DeviceCategory)o302);
    deserializeCca(in, out.getParkModeRestrictionInfoMutable(), majorVersion);
    deserializeCca(in, out.getDriveModeRestrictionInfoMutable(), majorVersion);
    uint16 o303;
    in >> o303;
    out.setGeneralRestrictionInfo(o303);
}

void serializeCca(const ::smartphoneint_main_fi::SetFeatureRestrictionsResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetFeatureRestrictionsResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o304;
    in >> o304;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o304);
    uint8 o305;
    in >> o305;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o305);
}

void serializeCca(const ::smartphoneint_main_fi::VehicleMechanicalSpeedStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getVehicleSpeed();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::VehicleMechanicalSpeedStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    int32 o306;
    in >> o306;
    out.setVehicleSpeed(o306);
}

void serializeCca(const ::smartphoneint_main_fi::VehicleMechanicalSpeedResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::VehicleMechanicalSpeedResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o307;
    in >> o307;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o307);
    uint8 o308;
    in >> o308;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o308);
}

void serializeCca(const ::smartphoneint_main_fi::SetVehicleManufacturerInformationStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getVehicleMake();
    out << in.getVehicleModel();
    out << in.getVehicleModelYear();
    out << in.getVehicleHUSwVersion();
    out << in.getVehicleHUHwVersion();
    out << in.getVehicleHUMake();
    out << in.getVehicleHUModel();
    out << in.getVehicleHUSwBuild();
    out << (uint8) in.getDriverSideInfo();
    out << (uint8) in.getIsNativeNavSupported();
    serializeCca(in.getOEMICONDetails(), out, majorVersion);
    out << (uint8) in.getIsRotaryCtrlSupported();
    out << (uint8) in.getFidelityType();
    out << in.getSupportedSPITechnologiesInfo();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetVehicleManufacturerInformationStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o309;
    in >> o309;
    out.setVehicleMake(o309);
    ::std::string o310;
    in >> o310;
    out.setVehicleModel(o310);
    ::std::string o311;
    in >> o311;
    out.setVehicleModelYear(o311);
    ::std::string o312;
    in >> o312;
    out.setVehicleHUSwVersion(o312);
    ::std::string o313;
    in >> o313;
    out.setVehicleHUHwVersion(o313);
    ::std::string o314;
    in >> o314;
    out.setVehicleHUMake(o314);
    ::std::string o315;
    in >> o315;
    out.setVehicleHUModel(o315);
    ::std::string o316;
    in >> o316;
    out.setVehicleHUSwBuild(o316);
    uint8 o317;
    in >> o317;
    out.setDriverSideInfo((::smartphoneint_main_fi_types::T_e8_Vehicle_Configuration)o317);
    bool o318;
    in >> o318;
    out.setIsNativeNavSupported(o318);
    deserializeCca(in, out.getOEMICONDetailsMutable(), majorVersion);
    bool o319;
    in >> o319;
    out.setIsRotaryCtrlSupported(o319);
    uint8 o320;
    in >> o320;
    out.setFidelityType((::smartphoneint_main_fi_types::T_e8_FidelityType)o320);
    uint16 o321;
    in >> o321;
    out.setSupportedSPITechnologiesInfo(o321);
}

void serializeCca(const ::smartphoneint_main_fi::SetVehicleManufacturerInformationResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetVehicleManufacturerInformationResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o322;
    in >> o322;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o322);
    uint8 o323;
    in >> o323;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o323);
}

void serializeCca(const ::smartphoneint_main_fi::SetEnvironmentDataStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getOutsideTemperature();
    out << (uint8) in.getValidTemperature();
    out << in.getBarometricPressure();
    out << (uint8) in.getValidPressure();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetEnvironmentDataStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    double o324;
    in >> o324;
    out.setOutsideTemperature(o324);
    bool o325;
    in >> o325;
    out.setValidTemperature(o325);
    double o326;
    in >> o326;
    out.setBarometricPressure(o326);
    bool o327;
    in >> o327;
    out.setValidPressure(o327);
}

void serializeCca(const ::smartphoneint_main_fi::SetEnvironmentDataResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetEnvironmentDataResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o328;
    in >> o328;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o328);
    uint8 o329;
    in >> o329;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o329);
}

void serializeCca(const ::smartphoneint_main_fi::GetMediaObjectAlbumArtStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getSAlbumArt();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::GetMediaObjectAlbumArtStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o330;
    in >> o330;
    out.setDeviceHandle(o330);
    ::std::string o331;
    in >> o331;
    out.setSAlbumArt(o331);
}

void serializeCca(const ::smartphoneint_main_fi::GetMediaObjectAlbumArtResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o332 = static_cast<uint32>(in.getOImageData().size());
        out << o332;
        ::std::vector< uint8 >::const_iterator o333;
        for (o333 = in.getOImageData().begin(); o333 != in.getOImageData().end(); ++o333) {
            out << (*o333);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::GetMediaObjectAlbumArtResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o334;
        in >> o334;
        out.getOImageDataMutable().clear ();
        out.getOImageDataMutable().reserve (o334);
        for (uint32 o335 = 0; o335 < o334; o335++) {
            uint8 o336;
            in >> o336;
            out.getOImageDataMutable().push_back(o336);
        }
    }
}

void serializeCca(const ::smartphoneint_main_fi::SetTechnologyPreferenceStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << in.getNumofPreferences();
    {
        uint32 o337 = static_cast<uint32>(in.getPreferenceOrderList().size());
        out << o337;
        ::std::vector< ::smartphoneint_main_fi_types::T_e8_DeviceCategory >::const_iterator o338;
        for (o338 = in.getPreferenceOrderList().begin(); o338 != in.getPreferenceOrderList().end(); ++o338) {
            out << (uint8) (*o338);
        }
    }
    out << (uint8) in.getDeviceType();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetTechnologyPreferenceStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o339;
    in >> o339;
    out.setDeviceHandle(o339);
    uint16 o340;
    in >> o340;
    out.setNumofPreferences(o340);
    {
        uint32 o341;
        in >> o341;
        out.getPreferenceOrderListMutable().clear ();
        out.getPreferenceOrderListMutable().reserve (o341);
        for (uint32 o342 = 0; o342 < o341; o342++) {
            uint8 o343;
            in >> o343;
            out.getPreferenceOrderListMutable().push_back((::smartphoneint_main_fi_types::T_e8_DeviceCategory) o343);
        }
    }
    uint8 o344;
    in >> o344;
    out.setDeviceType((::smartphoneint_main_fi_types::T_e8_DeviceType)o344);
}

void serializeCca(const ::smartphoneint_main_fi::SetTechnologyPreferenceResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetTechnologyPreferenceResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o345;
    in >> o345;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o345);
}

void serializeCca(const ::smartphoneint_main_fi::GetTechnologyPreferenceStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceType();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::GetTechnologyPreferenceStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o346;
    in >> o346;
    out.setDeviceHandle(o346);
    uint8 o347;
    in >> o347;
    out.setDeviceType((::smartphoneint_main_fi_types::T_e8_DeviceType)o347);
}

void serializeCca(const ::smartphoneint_main_fi::GetTechnologyPreferenceResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getNumofPreferences();
    {
        uint32 o348 = static_cast<uint32>(in.getPreferenceOrderList().size());
        out << o348;
        ::std::vector< ::smartphoneint_main_fi_types::T_e8_DeviceCategory >::const_iterator o349;
        for (o349 = in.getPreferenceOrderList().begin(); o349 != in.getPreferenceOrderList().end(); ++o349) {
            out << (uint8) (*o349);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::GetTechnologyPreferenceResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o350;
    in >> o350;
    out.setNumofPreferences(o350);
    {
        uint32 o351;
        in >> o351;
        out.getPreferenceOrderListMutable().clear ();
        out.getPreferenceOrderListMutable().reserve (o351);
        for (uint32 o352 = 0; o352 < o351; o352++) {
            uint8 o353;
            in >> o353;
            out.getPreferenceOrderListMutable().push_back((::smartphoneint_main_fi_types::T_e8_DeviceCategory) o353);
        }
    }
}

void serializeCca(const ::smartphoneint_main_fi::SetDeviceSelectionModeStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getDeviceSelectionMode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetDeviceSelectionModeStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o354;
    in >> o354;
    out.setDeviceSelectionMode((::smartphoneint_main_fi_types::T_e8_DeviceSelectionMode)o354);
}

void serializeCca(const ::smartphoneint_main_fi::SetDeviceSelectionModeResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetDeviceSelectionModeResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o355;
    in >> o355;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o355);
}

void serializeCca(const ::smartphoneint_main_fi::GetSPIVersionInfoResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSPIVersion();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::GetSPIVersionInfoResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o356;
    in >> o356;
    out.setSPIVersion(o356);
}

void serializeCca(const ::smartphoneint_main_fi::InitiateWirelessDiscoveryStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getBTMACAddress();
    out << (uint8) in.getTechnology();
    out << (uint8) in.getIsKnownDevice();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::InitiateWirelessDiscoveryStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o357;
    in >> o357;
    out.setBTMACAddress(o357);
    uint8 o358;
    in >> o358;
    out.setTechnology((::smartphoneint_main_fi_types::T_e8_DeviceCategory)o358);
    bool o359;
    in >> o359;
    out.setIsKnownDevice(o359);
}

void serializeCca(const ::smartphoneint_main_fi::InitiateWirelessDiscoveryResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::InitiateWirelessDiscoveryResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o360;
    in >> o360;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o360);
}

void serializeCca(const ::smartphoneint_main_fi::DeleteDeviceStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o361 = static_cast<uint32>(in.getDeviceList().size());
        out << o361;
        ::std::vector< uint32 >::const_iterator o362;
        for (o362 = in.getDeviceList().begin(); o362 != in.getDeviceList().end(); ++o362) {
            out << (*o362);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::DeleteDeviceStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o363;
        in >> o363;
        out.getDeviceListMutable().clear ();
        out.getDeviceListMutable().reserve (o363);
        for (uint32 o364 = 0; o364 < o363; o364++) {
            uint32 o365;
            in >> o365;
            out.getDeviceListMutable().push_back(o365);
        }
    }
}

void serializeCca(const ::smartphoneint_main_fi::DeleteDeviceResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o366 = static_cast<uint32>(in.getDeviceList().size());
        out << o366;
        ::std::vector< uint32 >::const_iterator o367;
        for (o367 = in.getDeviceList().begin(); o367 != in.getDeviceList().end(); ++o367) {
            out << (*o367);
        }
    }
    out << (uint8) in.getResponseCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::DeleteDeviceResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o368;
        in >> o368;
        out.getDeviceListMutable().clear ();
        out.getDeviceListMutable().reserve (o368);
        for (uint32 o369 = 0; o369 < o368; o369++) {
            uint32 o370;
            in >> o370;
            out.getDeviceListMutable().push_back(o370);
        }
    }
    uint8 o371;
    in >> o371;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o371);
}

void serializeCca(const ::smartphoneint_main_fi::GetWiFiCredentialsStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getBTMACAddress();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::GetWiFiCredentialsStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o372;
    in >> o372;
    out.setBTMACAddress(o372);
}

void serializeCca(const ::smartphoneint_main_fi::GetWiFiCredentialsResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getBTMACAddress();
    out << (uint8) in.getErrorCode();
    serializeCca(in.getAccessoryWiFiAPCredentials(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::GetWiFiCredentialsResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o373;
    in >> o373;
    out.setBTMACAddress(o373);
    uint8 o374;
    in >> o374;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o374);
    deserializeCca(in, out.getAccessoryWiFiAPCredentialsMutable(), majorVersion);
}

void serializeCca(const ::smartphoneint_main_fi::SetETCStatusStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getETCStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetETCStatusStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o375;
    in >> o375;
    out.setETCStatus(o375);
}

void serializeCca(const ::smartphoneint_main_fi::SetETCStatusResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SetETCStatusResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o376;
    in >> o376;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o376);
}

void serializeCca(const ::smartphoneint_main_fi::DistanceToEmptyTankStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDistanceToEmptyTank();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::DistanceToEmptyTankStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    int32 o377;
    in >> o377;
    out.setDistanceToEmptyTank(o377);
}

void serializeCca(const ::smartphoneint_main_fi::DistanceToEmptyTankResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::DistanceToEmptyTankResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o378;
    in >> o378;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o378);
    uint8 o379;
    in >> o379;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o379);
}

void serializeCca(const ::smartphoneint_main_fi::SendLanguageSettingStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (int32) in.getLanguageSetting();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SendLanguageSettingStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    int32 o380;
    in >> o380;
    out.setLanguageSetting((::smartphoneint_main_fi_types::T_e32_Language)o380);
}

void serializeCca(const ::smartphoneint_main_fi::SendLanguageSettingResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SendLanguageSettingResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o381;
    in >> o381;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o381);
    uint8 o382;
    in >> o382;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o382);
}

void serializeCca(const ::smartphoneint_main_fi::SendVehiclePowerModeStateStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getVehiclePowerModeState();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SendVehiclePowerModeStateStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o383;
    in >> o383;
    out.setVehiclePowerModeState((::smartphoneint_main_fi_types::T_e8_VehiclePowerModeState)o383);
}

void serializeCca(const ::smartphoneint_main_fi::SendVehiclePowerModeStateResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SendVehiclePowerModeStateResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o384;
    in >> o384;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o384);
    uint8 o385;
    in >> o385;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o385);
}

void serializeCca(const ::smartphoneint_main_fi::SendAmbientColourStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getAmbientColourData(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SendAmbientColourStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getAmbientColourDataMutable(), majorVersion);
}

void serializeCca(const ::smartphoneint_main_fi::SendAmbientColourResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
    out << (uint8) in.getErrorCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::SendAmbientColourResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o386;
    in >> o386;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o386);
    uint8 o387;
    in >> o387;
    out.setErrorCode((::smartphoneint_main_fi_types::T_e8_ErrorType)o387);
}

void serializeCca(const ::smartphoneint_main_fi::RegisterRouteGuidanceDisplayConfigurationStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o388 = static_cast<uint32>(in.getRouteGuidanceDisplayComponents().size());
        out << o388;
        ::std::vector< ::smartphoneint_main_fi_types::T_RouteGuidanceDisplayComponent >::const_iterator o389;
        for (o389 = in.getRouteGuidanceDisplayComponents().begin(); o389 != in.getRouteGuidanceDisplayComponents().end(); ++o389) {
            serializeCca((*o389), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::RegisterRouteGuidanceDisplayConfigurationStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o390;
        in >> o390;
        out.getRouteGuidanceDisplayComponentsMutable().clear ();
        out.getRouteGuidanceDisplayComponentsMutable().reserve (o390);
        for (uint32 o391 = 0; o391 < o390; o391++) {
            ::smartphoneint_main_fi_types::T_RouteGuidanceDisplayComponent o392;
            deserializeCca(in, o392, majorVersion);
            out.getRouteGuidanceDisplayComponentsMutable().push_back (o392);
        }
    }
}

void serializeCca(const ::smartphoneint_main_fi::RegisterRouteGuidanceDisplayConfigurationResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::RegisterRouteGuidanceDisplayConfigurationResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o393;
    in >> o393;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o393);
}

void serializeCca(const ::smartphoneint_main_fi::StartRouteGuidanceUpdatesStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o394 = static_cast<uint32>(in.getRoutGuidanceComponentID().size());
        out << o394;
        ::std::vector< ::smartphoneint_main_fi_types::T_e8_ComponentID >::const_iterator o395;
        for (o395 = in.getRoutGuidanceComponentID().begin(); o395 != in.getRoutGuidanceComponentID().end(); ++o395) {
            out << (uint8) (*o395);
        }
    }
    out << (uint8) in.getSourceName();
    out << (uint8) in.getSourceSupportsRouteGuidance();
    out << (uint8) in.getNeedAutoStartStopTBTUpdates();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::StartRouteGuidanceUpdatesStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o396;
        in >> o396;
        out.getRoutGuidanceComponentIDMutable().clear ();
        out.getRoutGuidanceComponentIDMutable().reserve (o396);
        for (uint32 o397 = 0; o397 < o396; o397++) {
            uint8 o398;
            in >> o398;
            out.getRoutGuidanceComponentIDMutable().push_back((::smartphoneint_main_fi_types::T_e8_ComponentID) o398);
        }
    }
    bool o399;
    in >> o399;
    out.setSourceName(o399);
    bool o400;
    in >> o400;
    out.setSourceSupportsRouteGuidance(o400);
    bool o401;
    in >> o401;
    out.setNeedAutoStartStopTBTUpdates(o401);
}

void serializeCca(const ::smartphoneint_main_fi::StartRouteGuidanceUpdatesResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::StartRouteGuidanceUpdatesResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o402;
    in >> o402;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o402);
}

void serializeCca(const ::smartphoneint_main_fi::StopRouteGuidanceUpdatesStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o403 = static_cast<uint32>(in.getRoutGuidanceComponentID().size());
        out << o403;
        ::std::vector< ::smartphoneint_main_fi_types::T_e8_ComponentID >::const_iterator o404;
        for (o404 = in.getRoutGuidanceComponentID().begin(); o404 != in.getRoutGuidanceComponentID().end(); ++o404) {
            out << (uint8) (*o404);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::StopRouteGuidanceUpdatesStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o405;
        in >> o405;
        out.getRoutGuidanceComponentIDMutable().clear ();
        out.getRoutGuidanceComponentIDMutable().reserve (o405);
        for (uint32 o406 = 0; o406 < o405; o406++) {
            uint8 o407;
            in >> o407;
            out.getRoutGuidanceComponentIDMutable().push_back((::smartphoneint_main_fi_types::T_e8_ComponentID) o407);
        }
    }
}

void serializeCca(const ::smartphoneint_main_fi::StopRouteGuidanceUpdatesResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getResponseCode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::StopRouteGuidanceUpdatesResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o408;
    in >> o408;
    out.setResponseCode((::smartphoneint_main_fi_types::T_e8_ResponseCode)o408);
}

void serializeCca(const ::smartphoneint_main_fi::GetDeviceListStart& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::GetDeviceListStart& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o409;
    in >> o409;
    out.setDeviceHandle(o409);
}

void serializeCca(const ::smartphoneint_main_fi::GetDeviceListResult& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getNumDevices();
    {
        uint32 o410 = static_cast<uint32>(in.getDeviceInfoList().size());
        out << o410;
        ::std::vector< ::smartphoneint_main_fi_types::T_DeviceDetails >::const_iterator o411;
        for (o411 = in.getDeviceInfoList().begin(); o411 != in.getDeviceInfoList().end(); ++o411) {
            serializeCca((*o411), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi::GetDeviceListResult& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o412;
    in >> o412;
    out.setNumDevices(o412);
    {
        uint32 o413;
        in >> o413;
        out.getDeviceInfoListMutable().clear ();
        out.getDeviceInfoListMutable().reserve (o413);
        for (uint32 o414 = 0; o414 < o413; o414++) {
            ::smartphoneint_main_fi_types::T_DeviceDetails o415;
            deserializeCca(in, o415, majorVersion);
            out.getDeviceInfoListMutable().push_back (o415);
        }
    }
}

