/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "rvc_cca_fi_types.h"
#include "rvc_cca_fi_typesConst.h"
#include "rvc_cca_fi_typesJson.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>

using namespace ::asf::stream::json;


// Json serialization of "T_RVC_VideoAnalogLevels"

void serializeJson (const ::rvc_cca_fi_types::T_RVC_VideoAnalogLevels& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Type()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Type" , 6);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_VideoParameterType_Name(value.getE8Type());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Type());
    }
    if (!isSparse || value.hasE8DimmingMode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DimmingMode" , 13);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_VideoParameterDimmingMode_Name(value.getE8DimmingMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DimmingMode());
    }
    if (!isSparse || value.hasU8Value()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Value" , 7);
        yajl_gen_integer(g, (long long)value.getU8Value());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi_types::T_RVC_VideoAnalogLevels& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_IPA_Voice_Text_Strings"

void serializeJson (const ::rvc_cca_fi_types::T_IPA_Voice_Text_Strings& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8RequestId()) {
        yajl_gen_string(g, (const unsigned char*)  "e8RequestId" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_IPA_VoiceText_Name(value.getE8RequestId());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8RequestId());
    }
    if (!isSparse || value.hasSzText()) {
        yajl_gen_string(g, (const unsigned char*)  "szText" , 6);
        const char *s = value.getSzText().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi_types::T_IPA_Voice_Text_Strings& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_ParkAssist_UserConfiguration"

void serializeJson (const ::rvc_cca_fi_types::T_ParkAssist_UserConfiguration& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Type()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Type" , 6);
        const char* s = ::rvc_cca_fi_types::T_e8_ParkAssist_UserConfigurationType_Name(value.getE8Type());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Type());
    }
    if (!isSparse || value.hasE8Mode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Mode" , 6);
        const char* s = ::rvc_cca_fi_types::T_e8_ParkAssist_UserConfigurationMode_Name(value.getE8Mode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Mode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi_types::T_ParkAssist_UserConfiguration& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_GdlAdj_ConfigParameterData"

void serializeJson (const ::rvc_cca_fi_types::T_GdlAdj_ConfigParameterData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Item()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Item" , 6);
        const char* s = ::rvc_cca_fi_types::T_e8_GdlAdj_ConfigurationItem_Name(value.getE8Item());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Item());
    }
    if (!isSparse || value.hasF64Value()) {
        yajl_gen_string(g, (const unsigned char*)  "f64Value" , 8);
        yajl_gen_double(g, (double)value.getF64Value());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi_types::T_GdlAdj_ConfigParameterData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_FAP_Settings_State"

void serializeJson (const ::rvc_cca_fi_types::T_FAP_Settings_State& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Type()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Type" , 6);
        const char* s = ::rvc_cca_fi_types::T_e8_FAP_SettingItem_Name(value.getE8Type());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Type());
    }
    if (!isSparse || value.hasE8State()) {
        yajl_gen_string(g, (const unsigned char*)  "e8State" , 7);
        const char* s = ::rvc_cca_fi_types::T_e8_AVM_FAP_SettingState_Name(value.getE8State());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8State());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi_types::T_FAP_Settings_State& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_AVM_Settings_State"

void serializeJson (const ::rvc_cca_fi_types::T_AVM_Settings_State& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Type()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Type" , 6);
        const char* s = ::rvc_cca_fi_types::T_e8_AVM_SettingItem_Name(value.getE8Type());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Type());
    }
    if (!isSparse || value.hasE8State()) {
        yajl_gen_string(g, (const unsigned char*)  "e8State" , 7);
        const char* s = ::rvc_cca_fi_types::T_e8_AVM_FAP_SettingState_Name(value.getE8State());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8State());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi_types::T_AVM_Settings_State& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_GPS_Data"

void serializeJson (const ::rvc_cca_fi_types::T_GPS_Data& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasGPS_latitude()) {
        yajl_gen_string(g, (const unsigned char*)  "GPS_latitude" , 12);
        yajl_gen_double(g, (double)value.getGPS_latitude());
    }
    if (!isSparse || value.hasGPS_longitude()) {
        yajl_gen_string(g, (const unsigned char*)  "GPS_longitude" , 13);
        yajl_gen_double(g, (double)value.getGPS_longitude());
    }
    if (!isSparse || value.hasGPS_altitude()) {
        yajl_gen_string(g, (const unsigned char*)  "GPS_altitude" , 12);
        yajl_gen_double(g, (double)value.getGPS_altitude());
    }
    if (!isSparse || value.hasGPS_azimuth()) {
        yajl_gen_string(g, (const unsigned char*)  "GPS_azimuth" , 11);
        yajl_gen_double(g, (double)value.getGPS_azimuth());
    }
    if (!isSparse || value.hasHDOP()) {
        yajl_gen_string(g, (const unsigned char*)  "HDOP" , 4);
        yajl_gen_double(g, (double)value.getHDOP());
    }
    if (!isSparse || value.hasVDOP()) {
        yajl_gen_string(g, (const unsigned char*)  "VDOP" , 4);
        yajl_gen_double(g, (double)value.getVDOP());
    }
    if (!isSparse || value.hasNumOfSatellites()) {
        yajl_gen_string(g, (const unsigned char*)  "numOfSatellites" , 15);
        yajl_gen_integer(g, (long long)value.getNumOfSatellites());
    }
    if (!isSparse || value.hasGroundSpeed()) {
        yajl_gen_string(g, (const unsigned char*)  "groundSpeed" , 11);
        yajl_gen_integer(g, (long long)value.getGroundSpeed());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi_types::T_GPS_Data& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_MapMatched_Data"

void serializeJson (const ::rvc_cca_fi_types::T_MapMatched_Data& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMM_latitude()) {
        yajl_gen_string(g, (const unsigned char*)  "MM_latitude" , 11);
        yajl_gen_double(g, (double)value.getMM_latitude());
    }
    if (!isSparse || value.hasMM_longitude()) {
        yajl_gen_string(g, (const unsigned char*)  "MM_longitude" , 12);
        yajl_gen_double(g, (double)value.getMM_longitude());
    }
    if (!isSparse || value.hasMM_azimuth()) {
        yajl_gen_string(g, (const unsigned char*)  "MM_azimuth" , 10);
        yajl_gen_double(g, (double)value.getMM_azimuth());
    }
    if (!isSparse || value.hasMM_accuracy()) {
        yajl_gen_string(g, (const unsigned char*)  "MM_accuracy" , 11);
        yajl_gen_double(g, (double)value.getMM_accuracy());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi_types::T_MapMatched_Data& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_Touch_Data"

void serializeJson (const ::rvc_cca_fi_types::T_Touch_Data& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasX_ordinate()) {
        yajl_gen_string(g, (const unsigned char*)  "x_ordinate" , 10);
        yajl_gen_integer(g, (long long)value.getX_ordinate());
    }
    if (!isSparse || value.hasY_ordinate()) {
        yajl_gen_string(g, (const unsigned char*)  "y_ordinate" , 10);
        yajl_gen_integer(g, (long long)value.getY_ordinate());
    }
    if (!isSparse || value.hasX1_ordinate()) {
        yajl_gen_string(g, (const unsigned char*)  "x1_ordinate" , 11);
        yajl_gen_integer(g, (long long)value.getX1_ordinate());
    }
    if (!isSparse || value.hasY1_ordinate()) {
        yajl_gen_string(g, (const unsigned char*)  "y1_ordinate" , 11);
        yajl_gen_integer(g, (long long)value.getY1_ordinate());
    }
    if (!isSparse || value.hasE8Gesture()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Gesture" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_TouchGesture_Name(value.getE8Gesture());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Gesture());
    }
    if (!isSparse || value.hasE8Direction()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Direction" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_Direction_Name(value.getE8Direction());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Direction());
    }
    if (!isSparse || value.hasSpeedOfMovement()) {
        yajl_gen_string(g, (const unsigned char*)  "SpeedOfMovement" , 15);
        yajl_gen_integer(g, (long long)value.getSpeedOfMovement());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi_types::T_Touch_Data& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_AVMph3_SwitchDescriptor"

void serializeJson (const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasId()) {
        yajl_gen_string(g, (const unsigned char*)  "Id" , 2);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_SwitchId_Name(value.getId());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getId());
    }
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "Status" , 6);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_SwitchStatus_Name(value.getStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_AVMph3_Setting_Item"

void serializeJson (const ::rvc_cca_fi_types::T_AVMph3_Setting_Item& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ItemId()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ItemId" , 8);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_SettingItemId_Name(value.getE8ItemId());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ItemId());
    }
    if (!isSparse || value.hasU8ItemState()) {
        yajl_gen_string(g, (const unsigned char*)  "u8ItemState" , 11);
        yajl_gen_integer(g, (long long)value.getU8ItemState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi_types::T_AVMph3_Setting_Item& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_AVMph3_Setting_Option"

void serializeJson (const ::rvc_cca_fi_types::T_AVMph3_Setting_Option& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ItemId()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ItemId" , 8);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_SettingItemId_Name(value.getE8ItemId());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ItemId());
    }
    if (!isSparse || value.hasE8ItemState()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ItemState" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_SettingOptionState_Name(value.getE8ItemState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ItemState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi_types::T_AVMph3_Setting_Option& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_AVMph3_Setting_CornerSonarSensLvl"

void serializeJson (const ::rvc_cca_fi_types::T_AVMph3_Setting_CornerSonarSensLvl& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBAvail()) {
        yajl_gen_string(g, (const unsigned char*)  "bAvail" , 6);
        yajl_gen_bool(g, (bool)value.getBAvail());
    }
    if (!isSparse || value.hasE8Level()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Level" , 7);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_CornerSonarSensLvl_Name(value.getE8Level());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Level());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi_types::T_AVMph3_Setting_CornerSonarSensLvl& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_AVMph3_Setting_SonarSensLvl"

void serializeJson (const ::rvc_cca_fi_types::T_AVMph3_Setting_SonarSensLvl& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBAvail()) {
        yajl_gen_string(g, (const unsigned char*)  "bAvail" , 6);
        yajl_gen_bool(g, (bool)value.getBAvail());
    }
    if (!isSparse || value.hasE8Level()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Level" , 7);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_SonarSensLvl_Name(value.getE8Level());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Level());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi_types::T_AVMph3_Setting_SonarSensLvl& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_AVMph3_Setting_BuzzerSoundLvl"

void serializeJson (const ::rvc_cca_fi_types::T_AVMph3_Setting_BuzzerSoundLvl& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBAvail()) {
        yajl_gen_string(g, (const unsigned char*)  "bAvail" , 6);
        yajl_gen_bool(g, (bool)value.getBAvail());
    }
    if (!isSparse || value.hasE8Level()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Level" , 7);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_BuzzerSoundLvl_Name(value.getE8Level());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Level());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi_types::T_AVMph3_Setting_BuzzerSoundLvl& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_AVMph3_VersionInfo"

void serializeJson (const ::rvc_cca_fi_types::T_AVMph3_VersionInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Upper()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Upper" , 7);
        yajl_gen_integer(g, (long long)value.getU8Upper());
    }
    if (!isSparse || value.hasU8Middle()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Middle" , 8);
        yajl_gen_integer(g, (long long)value.getU8Middle());
    }
    if (!isSparse || value.hasU8Lower()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Lower" , 7);
        yajl_gen_integer(g, (long long)value.getU8Lower());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi_types::T_AVMph3_VersionInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_AVMph3_Unit_ID"

void serializeJson (const ::rvc_cca_fi_types::T_AVMph3_Unit_ID& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Unit_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Unit_ID" , 9);
        yajl_gen_integer(g, (long long)value.getU8Unit_ID());
    }
    if (!isSparse || value.hasE8Variant()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Variant" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_Variant_Name(value.getE8Variant());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Variant());
    }
    if (!isSparse || value.hasBLeftHandDrive()) {
        yajl_gen_string(g, (const unsigned char*)  "bLeftHandDrive" , 14);
        yajl_gen_bool(g, (bool)value.getBLeftHandDrive());
    }
    if (!isSparse || value.hasBWithSonar()) {
        yajl_gen_string(g, (const unsigned char*)  "bWithSonar" , 10);
        yajl_gen_bool(g, (bool)value.getBWithSonar());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi_types::T_AVMph3_Unit_ID& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_AVMph3_MCAN_CommunicationErrors"

void serializeJson (const ::rvc_cca_fi_types::T_AVMph3_MCAN_CommunicationErrors& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8BusOff()) {
        yajl_gen_string(g, (const unsigned char*)  "u8BusOff" , 8);
        yajl_gen_integer(g, (long long)value.getU8BusOff());
    }
    if (!isSparse || value.hasU8TxCmfToMaster()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TxCmfToMaster" , 15);
        yajl_gen_integer(g, (long long)value.getU8TxCmfToMaster());
    }
    if (!isSparse || value.hasU8RxCmfFromSonar()) {
        yajl_gen_string(g, (const unsigned char*)  "u8RxCmfFromSonar" , 16);
        yajl_gen_integer(g, (long long)value.getU8RxCmfFromSonar());
    }
    if (!isSparse || value.hasU8TxMpdtToSonar()) {
        yajl_gen_string(g, (const unsigned char*)  "u8TxMpdtToSonar" , 15);
        yajl_gen_integer(g, (long long)value.getU8TxMpdtToSonar());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi_types::T_AVMph3_MCAN_CommunicationErrors& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace rvc_cca_fi_types {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi_types::T_RVC_VideoAnalogLevels& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi_types
using namespace ::asf::stream::json;

namespace rvc_cca_fi_types {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi_types::T_IPA_Voice_Text_Strings& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi_types
using namespace ::asf::stream::json;

namespace rvc_cca_fi_types {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi_types::T_ParkAssist_UserConfiguration& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi_types
using namespace ::asf::stream::json;

namespace rvc_cca_fi_types {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi_types::T_GdlAdj_ConfigParameterData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi_types
using namespace ::asf::stream::json;

namespace rvc_cca_fi_types {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi_types::T_FAP_Settings_State& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi_types
using namespace ::asf::stream::json;

namespace rvc_cca_fi_types {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi_types::T_AVM_Settings_State& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi_types
using namespace ::asf::stream::json;

namespace rvc_cca_fi_types {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi_types::T_GPS_Data& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi_types
using namespace ::asf::stream::json;

namespace rvc_cca_fi_types {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi_types::T_MapMatched_Data& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi_types
using namespace ::asf::stream::json;

namespace rvc_cca_fi_types {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi_types::T_Touch_Data& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi_types
using namespace ::asf::stream::json;

namespace rvc_cca_fi_types {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi_types
using namespace ::asf::stream::json;

namespace rvc_cca_fi_types {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi_types::T_AVMph3_Setting_Item& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi_types
using namespace ::asf::stream::json;

namespace rvc_cca_fi_types {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi_types::T_AVMph3_Setting_Option& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi_types
using namespace ::asf::stream::json;

namespace rvc_cca_fi_types {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi_types::T_AVMph3_Setting_CornerSonarSensLvl& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi_types
using namespace ::asf::stream::json;

namespace rvc_cca_fi_types {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi_types::T_AVMph3_Setting_SonarSensLvl& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi_types
using namespace ::asf::stream::json;

namespace rvc_cca_fi_types {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi_types::T_AVMph3_Setting_BuzzerSoundLvl& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi_types
using namespace ::asf::stream::json;

namespace rvc_cca_fi_types {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi_types::T_AVMph3_VersionInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi_types
using namespace ::asf::stream::json;

namespace rvc_cca_fi_types {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi_types::T_AVMph3_Unit_ID& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi_types
using namespace ::asf::stream::json;

namespace rvc_cca_fi_types {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi_types::T_AVMph3_MCAN_CommunicationErrors& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi_types

