/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "rvc_cca_fi_typesConst.h"
#include <cstddef>
#include <cstdlib>

/**
 * Types rvc_cca_fi_types
 */

using namespace ::asf::stream::json;

namespace rvc_cca_fi_types {

bool T_e8_RVC_CCAError_Parse (const char *str, size_t length, T_e8_RVC_CCAError &value)
{
    static stringEntry entries[] = {
        {15,"RVC_UNKNOWN_MSG", 22U},
        {17,"RVC_UPREG_FAILURE", 17U},
        {18,"RVC_INVALID_OPCODE", 23U},
        {20,"RVC_RELUPREG_FAILURE", 18U},
        {20,"RVC_WRONG_PARAMETERS", 19U},
        {21,"RVC_PARAMETER_LIMITED", 21U},
        {24,"RVC_OPCODE_NOT_SUPPORTED", 16U},
        {29,"RVC_STRING_PARAMETER_OVERSIZE", 20U},
    };

    return lookupInStringEntryTable (str, length, entries, 8, (unsigned int&) value);
}

const char* T_e8_RVC_CCAError_Name (T_e8_RVC_CCAError value)
{
    static const char* enumerationLiterals[] = {
        "RVC_OPCODE_NOT_SUPPORTED",
        "RVC_UPREG_FAILURE",
        "RVC_RELUPREG_FAILURE",
        "RVC_WRONG_PARAMETERS",
        "RVC_STRING_PARAMETER_OVERSIZE",
        "RVC_PARAMETER_LIMITED",
        "RVC_UNKNOWN_MSG",
        "RVC_INVALID_OPCODE",
    };

    if (T_e8_RVC_CCAError_IsValid(value))
        return enumerationLiterals[value - 16U];
    else
        return NULL;
}

bool T_e8_RVC_CCAError_IsValid (T_e8_RVC_CCAError value)
{
    switch (value) {
    case T_e8_RVC_CCAError__RVC_OPCODE_NOT_SUPPORTED:
    case T_e8_RVC_CCAError__RVC_UPREG_FAILURE:
    case T_e8_RVC_CCAError__RVC_RELUPREG_FAILURE:
    case T_e8_RVC_CCAError__RVC_WRONG_PARAMETERS:
    case T_e8_RVC_CCAError__RVC_STRING_PARAMETER_OVERSIZE:
    case T_e8_RVC_CCAError__RVC_PARAMETER_LIMITED:
    case T_e8_RVC_CCAError__RVC_UNKNOWN_MSG:
    case T_e8_RVC_CCAError__RVC_INVALID_OPCODE:
        return true;
    default:
        return false;
    }
}

bool T_e8_RVC_Camera_System_Type_Parse (const char *str, size_t length, T_e8_RVC_Camera_System_Type &value)
{
    static stringEntry entries[] = {
        {3,"MVC", 8U},
        {3,"RVC", 1U},
        {4,"NONE", 0U},
        {7,"AVM_FAP", 11U},
        {7,"AVM_IPA", 5U},
        {7,"AVM_LOW", 3U},
        {8,"AVM_HIGH", 4U},
        {9,"AVM_ENTRY", 6U},
        {10,"AVM_PHASE3", 7U},
        {11,"RVC_RENAULT", 9U},
        {12,"RVC_TAILGATE", 2U},
        {17,"AVM_ENTRY_RENAULT", 10U},
    };

    return lookupInStringEntryTable (str, length, entries, 12, (unsigned int&) value);
}

const char* T_e8_RVC_Camera_System_Type_Name (T_e8_RVC_Camera_System_Type value)
{
    static const char* enumerationLiterals[] = {
        "NONE",
        "RVC",
        "RVC_TAILGATE",
        "AVM_LOW",
        "AVM_HIGH",
        "AVM_IPA",
        "AVM_ENTRY",
        "AVM_PHASE3",
        "MVC",
        "RVC_RENAULT",
        "AVM_ENTRY_RENAULT",
        "AVM_FAP",
    };

    if (T_e8_RVC_Camera_System_Type_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_RVC_Camera_System_Type_IsValid (T_e8_RVC_Camera_System_Type value)
{
    switch (value) {
    case T_e8_RVC_Camera_System_Type__NONE:
    case T_e8_RVC_Camera_System_Type__RVC:
    case T_e8_RVC_Camera_System_Type__RVC_TAILGATE:
    case T_e8_RVC_Camera_System_Type__AVM_LOW:
    case T_e8_RVC_Camera_System_Type__AVM_HIGH:
    case T_e8_RVC_Camera_System_Type__AVM_IPA:
    case T_e8_RVC_Camera_System_Type__AVM_ENTRY:
    case T_e8_RVC_Camera_System_Type__AVM_PHASE3:
    case T_e8_RVC_Camera_System_Type__MVC:
    case T_e8_RVC_Camera_System_Type__RVC_RENAULT:
    case T_e8_RVC_Camera_System_Type__AVM_ENTRY_RENAULT:
    case T_e8_RVC_Camera_System_Type__AVM_FAP:
        return true;
    default:
        return false;
    }
}

bool T_e8_RVC_SignalStatus_Parse (const char *str, size_t length, T_e8_RVC_SignalStatus &value)
{
    static stringEntry entries[] = {
        {9,"SIGNAL_OK", 0U},
        {15,"CURRENT_FAILURE", 2U},
        {17,"CONFIRMED_FAILURE", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_RVC_SignalStatus_Name (T_e8_RVC_SignalStatus value)
{
    static const char* enumerationLiterals[] = {
        "Signal_Ok",
        "Confirmed_Failure",
        "Current_Failure",
    };

    if (T_e8_RVC_SignalStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_RVC_SignalStatus_IsValid (T_e8_RVC_SignalStatus value)
{
    switch (value) {
    case T_e8_RVC_SignalStatus__Signal_Ok:
    case T_e8_RVC_SignalStatus__Confirmed_Failure:
    case T_e8_RVC_SignalStatus__Current_Failure:
        return true;
    default:
        return false;
    }
}

bool T_e8_RVC_SystemStatus_Parse (const char *str, size_t length, T_e8_RVC_SystemStatus &value)
{
    static stringEntry entries[] = {
        {14,"INITIALISATION", 0U},
        {17,"VISUALISATION_OFF", 1U},
        {20,"AVM_VISUALISATION_ON", 41U},
        {20,"MVC_VISUALISATION_ON", 61U},
        {20,"RVC_VISUALISATION_ON", 21U},
        {26,"AVM_EARLY_VISUALISATION_ON", 31U},
        {26,"AVM_VISUALISATION_BLACK_IN", 40U},
        {26,"MVC_VISUALISATION_BLACK_IN", 60U},
        {26,"RVC_EARLY_VISUALISATION_ON", 11U},
        {26,"RVC_VISUALISATION_BLACK_IN", 20U},
        {27,"AVM_VISUALISATION_BLACK_OUT", 43U},
        {27,"MVC_VISUALISATION_BLACK_OUT", 63U},
        {27,"RVC_VISUALISATION_BLACK_OUT", 23U},
        {29,"AVM_VISUALISATION_ON_WITH_UPA", 45U},
        {29,"RVC_VISUALISATION_ON_WITH_UPA", 25U},
        {32,"AVM_EARLY_VISUALISATION_BLACK_IN", 30U},
        {32,"AVM_VISUALISATION_BLACK_WHILE_ON", 44U},
        {32,"RVC_EARLY_VISUALISATION_BLACK_IN", 10U},
        {33,"AVM_EARLY_VISUALISATION_BLACK_OUT", 32U},
        {33,"AVM_VISUALISATION_ON_WITH_UPA_HFP", 46U},
        {33,"RVC_EARLY_VISUALISATION_BLACK_OUT", 12U},
        {33,"RVC_VISUALISATION_ON_WITH_UPA_HFP", 26U},
        {36,"AVM_VISUALISATION_ON_CAMERA_SETTINGS", 42U},
        {36,"MVC_VISUALISATION_ON_CAMERA_SETTINGS", 62U},
        {36,"RVC_VISUALISATION_ON_CAMERA_SETTINGS", 22U},
        {36,"VISUALISATION_OFF_SYSTEM_MALFUNCTION", 3U},
        {38,"VISUALISATION_BLACK_IN_CAMERA_SETTINGS", 50U},
        {38,"VISUALISATION_OFF_VIDEO_SIGNAL_FAILURE", 2U},
        {39,"VISUALISATION_BLACK_OUT_CAMERA_SETTINGS", 51U},
        {41,"RVC_VISUALISATION_ON_GUIDELINE_ADJUSTMENT", 24U},
    };

    return lookupInStringEntryTable (str, length, entries, 30, (unsigned int&) value);
}

const char* T_e8_RVC_SystemStatus_Name (T_e8_RVC_SystemStatus value)
{
    static const char* enumerationLiterals[] = {
        "INITIALISATION",
        "VISUALISATION_OFF",
        "VISUALISATION_OFF_VIDEO_SIGNAL_FAILURE",
        "VISUALISATION_OFF_SYSTEM_MALFUNCTION",
        "RVC_EARLY_VISUALISATION_BLACK_IN",
        "RVC_EARLY_VISUALISATION_ON",
        "RVC_EARLY_VISUALISATION_BLACK_OUT",
        "RVC_VISUALISATION_BLACK_IN",
        "RVC_VISUALISATION_ON",
        "RVC_VISUALISATION_ON_CAMERA_SETTINGS",
        "RVC_VISUALISATION_BLACK_OUT",
        "RVC_VISUALISATION_ON_GUIDELINE_ADJUSTMENT",
        "RVC_VISUALISATION_ON_WITH_UPA",
        "RVC_VISUALISATION_ON_WITH_UPA_HFP",
        "AVM_EARLY_VISUALISATION_BLACK_IN",
        "AVM_EARLY_VISUALISATION_ON",
        "AVM_EARLY_VISUALISATION_BLACK_OUT",
        "AVM_VISUALISATION_BLACK_IN",
        "AVM_VISUALISATION_ON",
        "AVM_VISUALISATION_ON_CAMERA_SETTINGS",
        "AVM_VISUALISATION_BLACK_OUT",
        "AVM_VISUALISATION_BLACK_WHILE_ON",
        "AVM_VISUALISATION_ON_WITH_UPA",
        "AVM_VISUALISATION_ON_WITH_UPA_HFP",
        "VISUALISATION_BLACK_IN_CAMERA_SETTINGS",
        "VISUALISATION_BLACK_OUT_CAMERA_SETTINGS",
        "MVC_VISUALISATION_BLACK_IN",
        "MVC_VISUALISATION_ON",
        "MVC_VISUALISATION_ON_CAMERA_SETTINGS",
        "MVC_VISUALISATION_BLACK_OUT",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        10U,
        11U,
        12U,
        20U,
        21U,
        22U,
        23U,
        24U,
        25U,
        26U,
        30U,
        31U,
        32U,
        40U,
        41U,
        42U,
        43U,
        44U,
        45U,
        46U,
        50U,
        51U,
        60U,
        61U,
        62U,
        63U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 30, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_RVC_SystemStatus_IsValid (T_e8_RVC_SystemStatus value)
{
    switch (value) {
    case T_e8_RVC_SystemStatus__INITIALISATION:
    case T_e8_RVC_SystemStatus__VISUALISATION_OFF:
    case T_e8_RVC_SystemStatus__VISUALISATION_OFF_VIDEO_SIGNAL_FAILURE:
    case T_e8_RVC_SystemStatus__VISUALISATION_OFF_SYSTEM_MALFUNCTION:
    case T_e8_RVC_SystemStatus__RVC_EARLY_VISUALISATION_BLACK_IN:
    case T_e8_RVC_SystemStatus__RVC_EARLY_VISUALISATION_ON:
    case T_e8_RVC_SystemStatus__RVC_EARLY_VISUALISATION_BLACK_OUT:
    case T_e8_RVC_SystemStatus__RVC_VISUALISATION_BLACK_IN:
    case T_e8_RVC_SystemStatus__RVC_VISUALISATION_ON:
    case T_e8_RVC_SystemStatus__RVC_VISUALISATION_ON_CAMERA_SETTINGS:
    case T_e8_RVC_SystemStatus__RVC_VISUALISATION_BLACK_OUT:
    case T_e8_RVC_SystemStatus__RVC_VISUALISATION_ON_GUIDELINE_ADJUSTMENT:
    case T_e8_RVC_SystemStatus__RVC_VISUALISATION_ON_WITH_UPA:
    case T_e8_RVC_SystemStatus__RVC_VISUALISATION_ON_WITH_UPA_HFP:
    case T_e8_RVC_SystemStatus__AVM_EARLY_VISUALISATION_BLACK_IN:
    case T_e8_RVC_SystemStatus__AVM_EARLY_VISUALISATION_ON:
    case T_e8_RVC_SystemStatus__AVM_EARLY_VISUALISATION_BLACK_OUT:
    case T_e8_RVC_SystemStatus__AVM_VISUALISATION_BLACK_IN:
    case T_e8_RVC_SystemStatus__AVM_VISUALISATION_ON:
    case T_e8_RVC_SystemStatus__AVM_VISUALISATION_ON_CAMERA_SETTINGS:
    case T_e8_RVC_SystemStatus__AVM_VISUALISATION_BLACK_OUT:
    case T_e8_RVC_SystemStatus__AVM_VISUALISATION_BLACK_WHILE_ON:
    case T_e8_RVC_SystemStatus__AVM_VISUALISATION_ON_WITH_UPA:
    case T_e8_RVC_SystemStatus__AVM_VISUALISATION_ON_WITH_UPA_HFP:
    case T_e8_RVC_SystemStatus__VISUALISATION_BLACK_IN_CAMERA_SETTINGS:
    case T_e8_RVC_SystemStatus__VISUALISATION_BLACK_OUT_CAMERA_SETTINGS:
    case T_e8_RVC_SystemStatus__MVC_VISUALISATION_BLACK_IN:
    case T_e8_RVC_SystemStatus__MVC_VISUALISATION_ON:
    case T_e8_RVC_SystemStatus__MVC_VISUALISATION_ON_CAMERA_SETTINGS:
    case T_e8_RVC_SystemStatus__MVC_VISUALISATION_BLACK_OUT:
        return true;
    default:
        return false;
    }
}

bool T_e8_RVC_StatusGuideLine_Parse (const char *str, size_t length, T_e8_RVC_StatusGuideLine &value)
{
    static stringEntry entries[] = {
        {17,"STATICGUIDELINEON", 1U},
        {18,"DYNAMICGUIDELINEON", 3U},
        {18,"STATICGUIDELINEOFF", 0U},
        {19,"DYNAMICGUIDELINEOFF", 2U},
        {21,"GUIDELINENOTAVAILABLE", 15U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_RVC_StatusGuideLine_Name (T_e8_RVC_StatusGuideLine value)
{
    static const char* enumerationLiterals[] = {
        "StaticGuideLineOff",
        "StaticGuideLineOn",
        "DynamicGuideLineOff",
        "DynamicGuideLineOn",
        "GuideLineNotAvailable",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        15U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 5, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_RVC_StatusGuideLine_IsValid (T_e8_RVC_StatusGuideLine value)
{
    switch (value) {
    case T_e8_RVC_StatusGuideLine__StaticGuideLineOff:
    case T_e8_RVC_StatusGuideLine__StaticGuideLineOn:
    case T_e8_RVC_StatusGuideLine__DynamicGuideLineOff:
    case T_e8_RVC_StatusGuideLine__DynamicGuideLineOn:
    case T_e8_RVC_StatusGuideLine__GuideLineNotAvailable:
        return true;
    default:
        return false;
    }
}

bool T_e8_RVC_StatusWarningText_Parse (const char *str, size_t length, T_e8_RVC_StatusWarningText &value)
{
    static stringEntry entries[] = {
        {13,"WARNINGTEXTON", 1U},
        {14,"WARNINGTEXTOFF", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_RVC_StatusWarningText_Name (T_e8_RVC_StatusWarningText value)
{
    static const char* enumerationLiterals[] = {
        "WarningTextOff",
        "WarningTextOn",
    };

    if (T_e8_RVC_StatusWarningText_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_RVC_StatusWarningText_IsValid (T_e8_RVC_StatusWarningText value)
{
    switch (value) {
    case T_e8_RVC_StatusWarningText__WarningTextOff:
    case T_e8_RVC_StatusWarningText__WarningTextOn:
        return true;
    default:
        return false;
    }
}

bool T_e8_RVC_Status_Parse (const char *str, size_t length, T_e8_RVC_Status &value)
{
    static stringEntry entries[] = {
        {9,"AVAILABLE", 1U},
        {13,"NOT_AVAILABLE", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_RVC_Status_Name (T_e8_RVC_Status value)
{
    static const char* enumerationLiterals[] = {
        "Not_Available",
        "Available",
    };

    if (T_e8_RVC_Status_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_RVC_Status_IsValid (T_e8_RVC_Status value)
{
    switch (value) {
    case T_e8_RVC_Status__Not_Available:
    case T_e8_RVC_Status__Available:
        return true;
    default:
        return false;
    }
}

bool T_e8_RVC_ButtonState_Parse (const char *str, size_t length, T_e8_RVC_ButtonState &value)
{
    static stringEntry entries[] = {
        {7,"PRESSED", 1U},
        {8,"RELEASED", 0U},
        {11,"LONGPRESSED", 3U},
        {12,"SHORTPRESSED", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_RVC_ButtonState_Name (T_e8_RVC_ButtonState value)
{
    static const char* enumerationLiterals[] = {
        "RELEASED",
        "PRESSED",
        "SHORTPRESSED",
        "LONGPRESSED",
    };

    if (T_e8_RVC_ButtonState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_RVC_ButtonState_IsValid (T_e8_RVC_ButtonState value)
{
    switch (value) {
    case T_e8_RVC_ButtonState__RELEASED:
    case T_e8_RVC_ButtonState__PRESSED:
    case T_e8_RVC_ButtonState__SHORTPRESSED:
    case T_e8_RVC_ButtonState__LONGPRESSED:
        return true;
    default:
        return false;
    }
}

bool T_e8_RVC_Language_Parse (const char *str, size_t length, T_e8_RVC_Language &value)
{
    static stringEntry entries[] = {
        {4,"THAI", 22U},
        {5,"CZECH", 18U},
        {5,"DUTCH", 7U},
        {5,"GREEK", 16U},
        {5,"HINDI", 38U},
        {5,"MALAY", 42U},
        {6,"ARABIC", 21U},
        {6,"DANISH", 12U},
        {6,"GERMAN", 4U},
        {6,"HEBREW", 37U},
        {6,"KOREAN", 26U},
        {6,"POLISH", 17U},
        {6,"SLOVAK", 19U},
        {7,"FINNISH", 14U},
        {7,"FLEMISH", 36U},
        {7,"ITALIAN", 6U},
        {7,"LATVIAN", 40U},
        {7,"RUSSIAN", 10U},
        {7,"SERBIAN", 45U},
        {7,"SWEDISH", 13U},
        {7,"TURKISH", 11U},
        {8,"ALBANESE", 32U},
        {8,"CROATIAN", 34U},
        {8,"ESTONIAN", 35U},
        {8,"JAPANESE", 39U},
        {8,"ROMANIAN", 31U},
        {9,"BRAZILIAN", 24U},
        {9,"BULGARIAN", 33U},
        {9,"HUNGARIAN", 20U},
        {9,"NORWEGIAN", 15U},
        {9,"SLOVENIAN", 46U},
        {9,"UKRAINIAN", 25U},
        {10,"AUSTRALIAN", 23U},
        {10,"ENGLISH_UK", 3U},
        {10,"ENGLISH_US", 0U},
        {10,"FRENCH_CAN", 1U},
        {10,"FRENCH_EUR", 5U},
        {10,"INDONESIAN", 30U},
        {10,"LITHUANIAN", 41U},
        {10,"PORTUGUESE", 9U},
        {10,"VIETNAMESE", 47U},
        {11,"PHILIPPINES", 44U},
        {11,"SPANISH_EUR", 8U},
        {18,"CHINESE_SIMPLIFIED", 27U},
        {21,"PERSIAN_FARSI_IRANIAN", 43U},
        {22,"SPANISH_LATIN_AMERICAN", 2U},
        {29,"CHINESE_TRADITIONAL_CANTONESE", 28U},
        {29,"CHINESE_TRADITIONAL_TAIWANESE", 29U},
    };

    return lookupInStringEntryTable (str, length, entries, 48, (unsigned int&) value);
}

const char* T_e8_RVC_Language_Name (T_e8_RVC_Language value)
{
    static const char* enumerationLiterals[] = {
        "ENGLISH_US",
        "FRENCH_CAN",
        "SPANISH_LATIN_AMERICAN",
        "ENGLISH_UK",
        "GERMAN",
        "FRENCH_EUR",
        "ITALIAN",
        "DUTCH",
        "SPANISH_EUR",
        "PORTUGUESE",
        "RUSSIAN",
        "TURKISH",
        "DANISH",
        "SWEDISH",
        "FINNISH",
        "NORWEGIAN",
        "GREEK",
        "POLISH",
        "CZECH",
        "SLOVAK",
        "HUNGARIAN",
        "ARABIC",
        "THAI",
        "AUSTRALIAN",
        "BRAZILIAN",
        "UKRAINIAN",
        "KOREAN",
        "CHINESE_SIMPLIFIED",
        "CHINESE_TRADITIONAL_CANTONESE",
        "CHINESE_TRADITIONAL_TAIWANESE",
        "INDONESIAN",
        "ROMANIAN",
        "ALBANESE",
        "BULGARIAN",
        "CROATIAN",
        "ESTONIAN",
        "FLEMISH",
        "HEBREW",
        "HINDI",
        "JAPANESE",
        "LATVIAN",
        "LITHUANIAN",
        "MALAY",
        "PERSIAN_FARSI_IRANIAN",
        "PHILIPPINES",
        "SERBIAN",
        "SLOVENIAN",
        "VIETNAMESE",
    };

    if (T_e8_RVC_Language_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_RVC_Language_IsValid (T_e8_RVC_Language value)
{
    switch (value) {
    case T_e8_RVC_Language__ENGLISH_US:
    case T_e8_RVC_Language__FRENCH_CAN:
    case T_e8_RVC_Language__SPANISH_LATIN_AMERICAN:
    case T_e8_RVC_Language__ENGLISH_UK:
    case T_e8_RVC_Language__GERMAN:
    case T_e8_RVC_Language__FRENCH_EUR:
    case T_e8_RVC_Language__ITALIAN:
    case T_e8_RVC_Language__DUTCH:
    case T_e8_RVC_Language__SPANISH_EUR:
    case T_e8_RVC_Language__PORTUGUESE:
    case T_e8_RVC_Language__RUSSIAN:
    case T_e8_RVC_Language__TURKISH:
    case T_e8_RVC_Language__DANISH:
    case T_e8_RVC_Language__SWEDISH:
    case T_e8_RVC_Language__FINNISH:
    case T_e8_RVC_Language__NORWEGIAN:
    case T_e8_RVC_Language__GREEK:
    case T_e8_RVC_Language__POLISH:
    case T_e8_RVC_Language__CZECH:
    case T_e8_RVC_Language__SLOVAK:
    case T_e8_RVC_Language__HUNGARIAN:
    case T_e8_RVC_Language__ARABIC:
    case T_e8_RVC_Language__THAI:
    case T_e8_RVC_Language__AUSTRALIAN:
    case T_e8_RVC_Language__BRAZILIAN:
    case T_e8_RVC_Language__UKRAINIAN:
    case T_e8_RVC_Language__KOREAN:
    case T_e8_RVC_Language__CHINESE_SIMPLIFIED:
    case T_e8_RVC_Language__CHINESE_TRADITIONAL_CANTONESE:
    case T_e8_RVC_Language__CHINESE_TRADITIONAL_TAIWANESE:
    case T_e8_RVC_Language__INDONESIAN:
    case T_e8_RVC_Language__ROMANIAN:
    case T_e8_RVC_Language__ALBANESE:
    case T_e8_RVC_Language__BULGARIAN:
    case T_e8_RVC_Language__CROATIAN:
    case T_e8_RVC_Language__ESTONIAN:
    case T_e8_RVC_Language__FLEMISH:
    case T_e8_RVC_Language__HEBREW:
    case T_e8_RVC_Language__HINDI:
    case T_e8_RVC_Language__JAPANESE:
    case T_e8_RVC_Language__LATVIAN:
    case T_e8_RVC_Language__LITHUANIAN:
    case T_e8_RVC_Language__MALAY:
    case T_e8_RVC_Language__PERSIAN_FARSI_IRANIAN:
    case T_e8_RVC_Language__PHILIPPINES:
    case T_e8_RVC_Language__SERBIAN:
    case T_e8_RVC_Language__SLOVENIAN:
    case T_e8_RVC_Language__VIETNAMESE:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVM_StatusBeep_Parse (const char *str, size_t length, T_e8_AVM_StatusBeep &value)
{
    static stringEntry entries[] = {
        {18,"ALLBEEPTYPESACTIVE", 3U},
        {19,"ONLYERRORBEEPACTIVE", 2U},
        {21,"ALLBEEPTYPESNOTACTIVE", 0U},
        {23,"ONLYOPERATIONBEEPACTIVE", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_AVM_StatusBeep_Name (T_e8_AVM_StatusBeep value)
{
    static const char* enumerationLiterals[] = {
        "AllBeepTypesNotActive",
        "OnlyOperationBeepActive",
        "OnlyErrorBeepActive",
        "AllBeepTypesActive",
    };

    if (T_e8_AVM_StatusBeep_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AVM_StatusBeep_IsValid (T_e8_AVM_StatusBeep value)
{
    switch (value) {
    case T_e8_AVM_StatusBeep__AllBeepTypesNotActive:
    case T_e8_AVM_StatusBeep__OnlyOperationBeepActive:
    case T_e8_AVM_StatusBeep__OnlyErrorBeepActive:
    case T_e8_AVM_StatusBeep__AllBeepTypesActive:
        return true;
    default:
        return false;
    }
}

bool T_e8_AffordableIts_Status_Parse (const char *str, size_t length, T_e8_AffordableIts_Status &value)
{
    static stringEntry entries[] = {
        {9,"AVAILABLE", 2U},
        {12,"INITIALISING", 1U},
        {13,"NOT_AVAILABLE", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_AffordableIts_Status_Name (T_e8_AffordableIts_Status value)
{
    static const char* enumerationLiterals[] = {
        "NOT_AVAILABLE",
        "INITIALISING",
        "AVAILABLE",
    };

    if (T_e8_AffordableIts_Status_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AffordableIts_Status_IsValid (T_e8_AffordableIts_Status value)
{
    switch (value) {
    case T_e8_AffordableIts_Status__NOT_AVAILABLE:
    case T_e8_AffordableIts_Status__INITIALISING:
    case T_e8_AffordableIts_Status__AVAILABLE:
        return true;
    default:
        return false;
    }
}

bool T_e8_RVC_VideoParameterType_Parse (const char *str, size_t length, T_e8_RVC_VideoParameterType &value)
{
    static stringEntry entries[] = {
        {3,"HUE", 3U},
        {5,"COLOR", 2U},
        {7,"DIMMING", 5U},
        {8,"CONTRAST", 1U},
        {10,"BLACKLEVEL", 4U},
        {10,"BRIGHTNESS", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_RVC_VideoParameterType_Name (T_e8_RVC_VideoParameterType value)
{
    static const char* enumerationLiterals[] = {
        "BRIGHTNESS",
        "CONTRAST",
        "COLOR",
        "HUE",
        "BLACKLEVEL",
        "DIMMING",
    };

    if (T_e8_RVC_VideoParameterType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_RVC_VideoParameterType_IsValid (T_e8_RVC_VideoParameterType value)
{
    switch (value) {
    case T_e8_RVC_VideoParameterType__BRIGHTNESS:
    case T_e8_RVC_VideoParameterType__CONTRAST:
    case T_e8_RVC_VideoParameterType__COLOR:
    case T_e8_RVC_VideoParameterType__HUE:
    case T_e8_RVC_VideoParameterType__BLACKLEVEL:
    case T_e8_RVC_VideoParameterType__DIMMING:
        return true;
    default:
        return false;
    }
}

bool T_e8_RVC_VideoParameterDimmingMode_Parse (const char *str, size_t length, T_e8_RVC_VideoParameterDimmingMode &value)
{
    static stringEntry entries[] = {
        {3,"DAY", 0U},
        {5,"NIGHT", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_RVC_VideoParameterDimmingMode_Name (T_e8_RVC_VideoParameterDimmingMode value)
{
    static const char* enumerationLiterals[] = {
        "DAY",
        "NIGHT",
    };

    if (T_e8_RVC_VideoParameterDimmingMode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_RVC_VideoParameterDimmingMode_IsValid (T_e8_RVC_VideoParameterDimmingMode value)
{
    switch (value) {
    case T_e8_RVC_VideoParameterDimmingMode__DAY:
    case T_e8_RVC_VideoParameterDimmingMode__NIGHT:
        return true;
    default:
        return false;
    }
}

bool T_e8_AffordableIts_StatusFeature_Parse (const char *str, size_t length, T_e8_AffordableIts_StatusFeature &value)
{
    static stringEntry entries[] = {
        {2,"ON", 2U},
        {3,"OFF", 1U},
        {7,"UNKNOWN", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_AffordableIts_StatusFeature_Name (T_e8_AffordableIts_StatusFeature value)
{
    static const char* enumerationLiterals[] = {
        "UNKNOWN",
        "OFF",
        "ON",
    };

    if (T_e8_AffordableIts_StatusFeature_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AffordableIts_StatusFeature_IsValid (T_e8_AffordableIts_StatusFeature value)
{
    switch (value) {
    case T_e8_AffordableIts_StatusFeature__UNKNOWN:
    case T_e8_AffordableIts_StatusFeature__OFF:
    case T_e8_AffordableIts_StatusFeature__ON:
        return true;
    default:
        return false;
    }
}

bool T_e8_Exit_Authorized_Parse (const char *str, size_t length, T_e8_Exit_Authorized &value)
{
    static stringEntry entries[] = {
        {7,"ALLOWED", 1U},
        {7,"UNKNOWN", 255U},
        {11,"NOT_ALLOWED", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_Exit_Authorized_Name (T_e8_Exit_Authorized value)
{
    static const char* enumerationLiterals[] = {
        "NOT_ALLOWED",
        "ALLOWED",
        "UNKNOWN",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 3, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_Exit_Authorized_IsValid (T_e8_Exit_Authorized value)
{
    switch (value) {
    case T_e8_Exit_Authorized__NOT_ALLOWED:
    case T_e8_Exit_Authorized__ALLOWED:
    case T_e8_Exit_Authorized__UNKNOWN:
        return true;
    default:
        return false;
    }
}

bool T_e8_RVC_CameraState_Parse (const char *str, size_t length, T_e8_RVC_CameraState &value)
{
    static stringEntry entries[] = {
        {15,"RVC_CAMSTATE_ON", 2U},
        {16,"RVC_CAMSTATE_OFF", 1U},
        {17,"RVC_CAMSTATE_INIT", 0U},
        {20,"AVM_VISUALIZATION_ON", 10U},
        {20,"RVC_CAMSTATE_FAILURE", 255U},
        {21,"AVM_VISUALIZATION_OFF", 11U},
        {25,"RVC_CAMSTATE_NOT_EXISTENT", 254U},
    };

    return lookupInStringEntryTable (str, length, entries, 7, (unsigned int&) value);
}

const char* T_e8_RVC_CameraState_Name (T_e8_RVC_CameraState value)
{
    static const char* enumerationLiterals[] = {
        "RVC_CAMSTATE_INIT",
        "RVC_CAMSTATE_OFF",
        "RVC_CAMSTATE_ON",
        "AVM_VISUALIZATION_ON",
        "AVM_VISUALIZATION_OFF",
        "RVC_CAMSTATE_NOT_EXISTENT",
        "RVC_CAMSTATE_FAILURE",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        10U,
        11U,
        254U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 7, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_RVC_CameraState_IsValid (T_e8_RVC_CameraState value)
{
    switch (value) {
    case T_e8_RVC_CameraState__RVC_CAMSTATE_INIT:
    case T_e8_RVC_CameraState__RVC_CAMSTATE_OFF:
    case T_e8_RVC_CameraState__RVC_CAMSTATE_ON:
    case T_e8_RVC_CameraState__AVM_VISUALIZATION_ON:
    case T_e8_RVC_CameraState__AVM_VISUALIZATION_OFF:
    case T_e8_RVC_CameraState__RVC_CAMSTATE_NOT_EXISTENT:
    case T_e8_RVC_CameraState__RVC_CAMSTATE_FAILURE:
        return true;
    default:
        return false;
    }
}

bool T_e8_IPA_BUTTON_ID_Parse (const char *str, size_t length, T_e8_IPA_BUTTON_ID &value)
{
    static stringEntry entries[] = {
        {2,"CW", 25U},
        {2,"UP", 20U},
        {3,"CCW", 24U},
        {4,"BACK", 6U},
        {4,"DOWN", 21U},
        {4,"HINT", 4U},
        {4,"LEFT", 22U},
        {5,"RIGHT", 23U},
        {5,"START", 3U},
        {6,"ADJUST", 7U},
        {6,"CANCEL", 5U},
        {7,"PARKBOX", 35U},
        {9,"NO_SWITCH", 0U},
        {9,"SCROLL_UP", 19U},
        {10,"GREYOUT_CW", 31U},
        {10,"GREYOUT_UP", 26U},
        {10,"P_STEERING", 32U},
        {11,"BAY_PARKING", 54U},
        {11,"GREYOUT_CCW", 30U},
        {11,"SCROLL_DOWN", 18U},
        {12,"GREYOUT_DOWN", 27U},
        {12,"GREYOUT_LEFT", 28U},
        {12,"SLOT_PARKING", 55U},
        {13,"ANGLE_FORWARD", 58U},
        {13,"GREYOUT_RIGHT", 29U},
        {13,"LEFT_DIAGONAL", 14U},
        {13,"LEFT_PARALLEL", 12U},
        {13,"PERPENDICULAR", 36U},
        {14,"ANGLE_BACKWARD", 57U},
        {14,"RIGHT_DIAGONAL", 15U},
        {14,"RIGHT_PARALLEL", 13U},
        {14,"VOICE_GUIDANCE", 50U},
        {15,"AUTOVIEW_ACTIVE", 8U},
        {15,"AVAIL_PARK_TYPE", 53U},
        {15,"FORWARD_PARKING", 56U},
        {17,"AUTOVIEW_INACTIVE", 9U},
        {18,"LEFT_PERPENDICULAR", 10U},
        {18,"P_STEERING_WO_SCAN", 1U},
        {19,"RIGHT_PERPENDICULAR", 11U},
        {21,"AUTO_SELECT_PARK_TYPE", 52U},
        {21,"VOICE_GUIDANCE_VOLUME", 51U},
    };

    return lookupInStringEntryTable (str, length, entries, 41, (unsigned int&) value);
}

const char* T_e8_IPA_BUTTON_ID_Name (T_e8_IPA_BUTTON_ID value)
{
    static const char* enumerationLiterals[] = {
        "NO_SWITCH",
        "P_STEERING_WO_SCAN",
        "START",
        "HINT",
        "CANCEL",
        "BACK",
        "ADJUST",
        "AUTOVIEW_ACTIVE",
        "AUTOVIEW_INACTIVE",
        "LEFT_PERPENDICULAR",
        "RIGHT_PERPENDICULAR",
        "LEFT_PARALLEL",
        "RIGHT_PARALLEL",
        "LEFT_DIAGONAL",
        "RIGHT_DIAGONAL",
        "SCROLL_DOWN",
        "SCROLL_UP",
        "UP",
        "DOWN",
        "LEFT",
        "RIGHT",
        "CCW",
        "CW",
        "GREYOUT_UP",
        "GREYOUT_DOWN",
        "GREYOUT_LEFT",
        "GREYOUT_RIGHT",
        "GREYOUT_CCW",
        "GREYOUT_CW",
        "P_STEERING",
        "PARKBOX",
        "PERPENDICULAR",
        "VOICE_GUIDANCE",
        "VOICE_GUIDANCE_VOLUME",
        "AUTO_SELECT_PARK_TYPE",
        "AVAIL_PARK_TYPE",
        "BAY_PARKING",
        "SLOT_PARKING",
        "FORWARD_PARKING",
        "ANGLE_BACKWARD",
        "ANGLE_FORWARD",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        10U,
        11U,
        12U,
        13U,
        14U,
        15U,
        18U,
        19U,
        20U,
        21U,
        22U,
        23U,
        24U,
        25U,
        26U,
        27U,
        28U,
        29U,
        30U,
        31U,
        32U,
        35U,
        36U,
        50U,
        51U,
        52U,
        53U,
        54U,
        55U,
        56U,
        57U,
        58U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 41, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_IPA_BUTTON_ID_IsValid (T_e8_IPA_BUTTON_ID value)
{
    switch (value) {
    case T_e8_IPA_BUTTON_ID__NO_SWITCH:
    case T_e8_IPA_BUTTON_ID__P_STEERING_WO_SCAN:
    case T_e8_IPA_BUTTON_ID__START:
    case T_e8_IPA_BUTTON_ID__HINT:
    case T_e8_IPA_BUTTON_ID__CANCEL:
    case T_e8_IPA_BUTTON_ID__BACK:
    case T_e8_IPA_BUTTON_ID__ADJUST:
    case T_e8_IPA_BUTTON_ID__AUTOVIEW_ACTIVE:
    case T_e8_IPA_BUTTON_ID__AUTOVIEW_INACTIVE:
    case T_e8_IPA_BUTTON_ID__LEFT_PERPENDICULAR:
    case T_e8_IPA_BUTTON_ID__RIGHT_PERPENDICULAR:
    case T_e8_IPA_BUTTON_ID__LEFT_PARALLEL:
    case T_e8_IPA_BUTTON_ID__RIGHT_PARALLEL:
    case T_e8_IPA_BUTTON_ID__LEFT_DIAGONAL:
    case T_e8_IPA_BUTTON_ID__RIGHT_DIAGONAL:
    case T_e8_IPA_BUTTON_ID__SCROLL_DOWN:
    case T_e8_IPA_BUTTON_ID__SCROLL_UP:
    case T_e8_IPA_BUTTON_ID__UP:
    case T_e8_IPA_BUTTON_ID__DOWN:
    case T_e8_IPA_BUTTON_ID__LEFT:
    case T_e8_IPA_BUTTON_ID__RIGHT:
    case T_e8_IPA_BUTTON_ID__CCW:
    case T_e8_IPA_BUTTON_ID__CW:
    case T_e8_IPA_BUTTON_ID__GREYOUT_UP:
    case T_e8_IPA_BUTTON_ID__GREYOUT_DOWN:
    case T_e8_IPA_BUTTON_ID__GREYOUT_LEFT:
    case T_e8_IPA_BUTTON_ID__GREYOUT_RIGHT:
    case T_e8_IPA_BUTTON_ID__GREYOUT_CCW:
    case T_e8_IPA_BUTTON_ID__GREYOUT_CW:
    case T_e8_IPA_BUTTON_ID__P_STEERING:
    case T_e8_IPA_BUTTON_ID__PARKBOX:
    case T_e8_IPA_BUTTON_ID__PERPENDICULAR:
    case T_e8_IPA_BUTTON_ID__VOICE_GUIDANCE:
    case T_e8_IPA_BUTTON_ID__VOICE_GUIDANCE_VOLUME:
    case T_e8_IPA_BUTTON_ID__AUTO_SELECT_PARK_TYPE:
    case T_e8_IPA_BUTTON_ID__AVAIL_PARK_TYPE:
    case T_e8_IPA_BUTTON_ID__BAY_PARKING:
    case T_e8_IPA_BUTTON_ID__SLOT_PARKING:
    case T_e8_IPA_BUTTON_ID__FORWARD_PARKING:
    case T_e8_IPA_BUTTON_ID__ANGLE_BACKWARD:
    case T_e8_IPA_BUTTON_ID__ANGLE_FORWARD:
        return true;
    default:
        return false;
    }
}

bool T_e8_IPA_PatternID_Parse (const char *str, size_t length, T_e8_IPA_PatternID &value)
{
    static stringEntry entries[] = {
        {9,"PATTERN_1", 0U},
        {9,"PATTERN_2", 1U},
        {9,"PATTERN_3", 2U},
        {9,"PATTERN_4", 3U},
        {9,"PATTERN_5", 4U},
        {9,"PATTERN_6", 5U},
        {9,"PATTERN_7", 6U},
        {9,"PATTERN_8", 7U},
        {9,"PATTERN_9", 8U},
        {10,"PATTERN_10", 9U},
        {10,"PATTERN_11", 10U},
        {10,"PATTERN_12", 11U},
        {10,"PATTERN_13", 12U},
        {10,"PATTERN_14", 13U},
        {10,"PATTERN_15", 14U},
    };

    return lookupInStringEntryTable (str, length, entries, 15, (unsigned int&) value);
}

const char* T_e8_IPA_PatternID_Name (T_e8_IPA_PatternID value)
{
    static const char* enumerationLiterals[] = {
        "PATTERN_1",
        "PATTERN_2",
        "PATTERN_3",
        "PATTERN_4",
        "PATTERN_5",
        "PATTERN_6",
        "PATTERN_7",
        "PATTERN_8",
        "PATTERN_9",
        "PATTERN_10",
        "PATTERN_11",
        "PATTERN_12",
        "PATTERN_13",
        "PATTERN_14",
        "PATTERN_15",
    };

    if (T_e8_IPA_PatternID_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_IPA_PatternID_IsValid (T_e8_IPA_PatternID value)
{
    switch (value) {
    case T_e8_IPA_PatternID__PATTERN_1:
    case T_e8_IPA_PatternID__PATTERN_2:
    case T_e8_IPA_PatternID__PATTERN_3:
    case T_e8_IPA_PatternID__PATTERN_4:
    case T_e8_IPA_PatternID__PATTERN_5:
    case T_e8_IPA_PatternID__PATTERN_6:
    case T_e8_IPA_PatternID__PATTERN_7:
    case T_e8_IPA_PatternID__PATTERN_8:
    case T_e8_IPA_PatternID__PATTERN_9:
    case T_e8_IPA_PatternID__PATTERN_10:
    case T_e8_IPA_PatternID__PATTERN_11:
    case T_e8_IPA_PatternID__PATTERN_12:
    case T_e8_IPA_PatternID__PATTERN_13:
    case T_e8_IPA_PatternID__PATTERN_14:
    case T_e8_IPA_PatternID__PATTERN_15:
        return true;
    default:
        return false;
    }
}

bool T_e8_IPA_MessageID_Parse (const char *str, size_t length, T_e8_IPA_MessageID &value)
{
    static stringEntry entries[] = {
        {4,"STOP", 39U},
        {11,"SPACE_FOUND", 38U},
        {12,"REDUCE_SPEED", 5U},
        {13,"DRIVE_FORWARD", 4U},
        {14,"DRIVE_REARWARD", 8U},
        {14,"REDUCE_SPEED_1", 42U},
        {15,"DRIVE_FORWARD_1", 43U},
        {16,"DRIVE_REARWARD_1", 41U},
        {17,"PARK_ASSIST_FAULT", 23U},
        {17,"SELECT_DRIVE_GEAR", 17U},
        {19,"SELECT_REVERSE_GEAR", 40U},
        {20,"ADJUST_PARK_POSITION", 11U},
        {20,"NO_MESSAGE_DISPLAYED", 0U},
        {20,"PARK_ASSIST_FINISHED", 16U},
        {21,"CENTER_STEERING_WHEEL", 18U},
        {21,"PARK_ASSIST_CANCELLED", 44U},
        {22,"PARK_ASSIST_FINISHED_1", 45U},
        {23,"PARK_ASSIST_CANCELLED_1", 46U},
        {23,"PARK_ASSIST_UNAVAILABLE", 33U},
        {26,"STOP_AND_SELECT_DRIVE_GEAR", 7U},
        {26,"TURN_SIGNAL_TO_SWITCH_SIDE", 32U},
        {28,"STOP_AND_SELECT_REVERSE_GEAR", 6U},
        {35,"STOP_NEXT_TO_EMPTY_PARKING_POSITION", 9U},
        {36,"ENSURE_IT_IS_SAFE_BEFORE_MANEUVERING", 1U},
        {36,"PRESS_ADJUST_TO_SET_PARKING_POSITION", 10U},
        {42,"STOP_BESIDE_PARK_SLOT_TO_START_PARK_ASSIST", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 26, (unsigned int&) value);
}

const char* T_e8_IPA_MessageID_Name (T_e8_IPA_MessageID value)
{
    static const char* enumerationLiterals[] = {
        "NO_MESSAGE_DISPLAYED",
        "ENSURE_IT_IS_SAFE_BEFORE_MANEUVERING",
        "STOP_BESIDE_PARK_SLOT_TO_START_PARK_ASSIST",
        "DRIVE_FORWARD",
        "REDUCE_SPEED",
        "STOP_AND_SELECT_REVERSE_GEAR",
        "STOP_AND_SELECT_DRIVE_GEAR",
        "DRIVE_REARWARD",
        "STOP_NEXT_TO_EMPTY_PARKING_POSITION",
        "PRESS_ADJUST_TO_SET_PARKING_POSITION",
        "ADJUST_PARK_POSITION",
        "PARK_ASSIST_FINISHED",
        "SELECT_DRIVE_GEAR",
        "CENTER_STEERING_WHEEL",
        "PARK_ASSIST_FAULT",
        "TURN_SIGNAL_TO_SWITCH_SIDE",
        "PARK_ASSIST_UNAVAILABLE",
        "SPACE_FOUND",
        "STOP",
        "SELECT_REVERSE_GEAR",
        "DRIVE_REARWARD_1",
        "REDUCE_SPEED_1",
        "DRIVE_FORWARD_1",
        "PARK_ASSIST_CANCELLED",
        "PARK_ASSIST_FINISHED_1",
        "PARK_ASSIST_CANCELLED_1",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        10U,
        11U,
        16U,
        17U,
        18U,
        23U,
        32U,
        33U,
        38U,
        39U,
        40U,
        41U,
        42U,
        43U,
        44U,
        45U,
        46U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 26, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_IPA_MessageID_IsValid (T_e8_IPA_MessageID value)
{
    switch (value) {
    case T_e8_IPA_MessageID__NO_MESSAGE_DISPLAYED:
    case T_e8_IPA_MessageID__ENSURE_IT_IS_SAFE_BEFORE_MANEUVERING:
    case T_e8_IPA_MessageID__STOP_BESIDE_PARK_SLOT_TO_START_PARK_ASSIST:
    case T_e8_IPA_MessageID__DRIVE_FORWARD:
    case T_e8_IPA_MessageID__REDUCE_SPEED:
    case T_e8_IPA_MessageID__STOP_AND_SELECT_REVERSE_GEAR:
    case T_e8_IPA_MessageID__STOP_AND_SELECT_DRIVE_GEAR:
    case T_e8_IPA_MessageID__DRIVE_REARWARD:
    case T_e8_IPA_MessageID__STOP_NEXT_TO_EMPTY_PARKING_POSITION:
    case T_e8_IPA_MessageID__PRESS_ADJUST_TO_SET_PARKING_POSITION:
    case T_e8_IPA_MessageID__ADJUST_PARK_POSITION:
    case T_e8_IPA_MessageID__PARK_ASSIST_FINISHED:
    case T_e8_IPA_MessageID__SELECT_DRIVE_GEAR:
    case T_e8_IPA_MessageID__CENTER_STEERING_WHEEL:
    case T_e8_IPA_MessageID__PARK_ASSIST_FAULT:
    case T_e8_IPA_MessageID__TURN_SIGNAL_TO_SWITCH_SIDE:
    case T_e8_IPA_MessageID__PARK_ASSIST_UNAVAILABLE:
    case T_e8_IPA_MessageID__SPACE_FOUND:
    case T_e8_IPA_MessageID__STOP:
    case T_e8_IPA_MessageID__SELECT_REVERSE_GEAR:
    case T_e8_IPA_MessageID__DRIVE_REARWARD_1:
    case T_e8_IPA_MessageID__REDUCE_SPEED_1:
    case T_e8_IPA_MessageID__DRIVE_FORWARD_1:
    case T_e8_IPA_MessageID__PARK_ASSIST_CANCELLED:
    case T_e8_IPA_MessageID__PARK_ASSIST_FINISHED_1:
    case T_e8_IPA_MessageID__PARK_ASSIST_CANCELLED_1:
        return true;
    default:
        return false;
    }
}

bool T_e8_IPA_OperationStatus_Parse (const char *str, size_t length, T_e8_IPA_OperationStatus &value)
{
    static stringEntry entries[] = {
        {6,"NORMAL", 0U},
        {11,"MALFUNCTION", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_IPA_OperationStatus_Name (T_e8_IPA_OperationStatus value)
{
    static const char* enumerationLiterals[] = {
        "Normal",
        "Malfunction",
    };

    if (T_e8_IPA_OperationStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_IPA_OperationStatus_IsValid (T_e8_IPA_OperationStatus value)
{
    switch (value) {
    case T_e8_IPA_OperationStatus__Normal:
    case T_e8_IPA_OperationStatus__Malfunction:
        return true;
    default:
        return false;
    }
}

bool T_e8_IPA_ModeChangeRequest_Parse (const char *str, size_t length, T_e8_IPA_ModeChangeRequest &value)
{
    static stringEntry entries[] = {
        {3,"IPA", 1U},
        {6,"NORMAL", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_IPA_ModeChangeRequest_Name (T_e8_IPA_ModeChangeRequest value)
{
    static const char* enumerationLiterals[] = {
        "Normal",
        "IPA",
    };

    if (T_e8_IPA_ModeChangeRequest_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_IPA_ModeChangeRequest_IsValid (T_e8_IPA_ModeChangeRequest value)
{
    switch (value) {
    case T_e8_IPA_ModeChangeRequest__Normal:
    case T_e8_IPA_ModeChangeRequest__IPA:
        return true;
    default:
        return false;
    }
}

bool T_e8_IPA_HMIStatus_Parse (const char *str, size_t length, T_e8_IPA_HMIStatus &value)
{
    static stringEntry entries[] = {
        {9,"ACTIVATED", 1U},
        {12,"NOTACTIVATED", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_IPA_HMIStatus_Name (T_e8_IPA_HMIStatus value)
{
    static const char* enumerationLiterals[] = {
        "NotActivated",
        "Activated",
    };

    if (T_e8_IPA_HMIStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_IPA_HMIStatus_IsValid (T_e8_IPA_HMIStatus value)
{
    switch (value) {
    case T_e8_IPA_HMIStatus__NotActivated:
    case T_e8_IPA_HMIStatus__Activated:
        return true;
    default:
        return false;
    }
}

bool T_e8_IPA_RegionalSelection_Parse (const char *str, size_t length, T_e8_IPA_RegionalSelection &value)
{
    static stringEntry entries[] = {
        {3,"USA", 3U},
        {5,"CHINA", 1U},
        {5,"JAPAN", 0U},
        {6,"EUROPE", 2U},
        {7,"INVALID", 7U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_IPA_RegionalSelection_Name (T_e8_IPA_RegionalSelection value)
{
    static const char* enumerationLiterals[] = {
        "Japan",
        "China",
        "Europe",
        "USA",
        "Invalid",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        7U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 5, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_IPA_RegionalSelection_IsValid (T_e8_IPA_RegionalSelection value)
{
    switch (value) {
    case T_e8_IPA_RegionalSelection__Japan:
    case T_e8_IPA_RegionalSelection__China:
    case T_e8_IPA_RegionalSelection__Europe:
    case T_e8_IPA_RegionalSelection__USA:
    case T_e8_IPA_RegionalSelection__Invalid:
        return true;
    default:
        return false;
    }
}

bool T_e8_IPA_AvailabilityStatus_Parse (const char *str, size_t length, T_e8_IPA_AvailabilityStatus &value)
{
    static stringEntry entries[] = {
        {9,"AVAILABLE", 2U},
        {12,"INITIALISING", 1U},
        {13,"AVM_IPA_ERROR", 3U},
        {13,"NOT_AVAILABLE", 0U},
        {17,"VIDEO_SIGNAL_FAIL", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_IPA_AvailabilityStatus_Name (T_e8_IPA_AvailabilityStatus value)
{
    static const char* enumerationLiterals[] = {
        "NOT_AVAILABLE",
        "INITIALISING",
        "AVAILABLE",
        "AVM_IPA_ERROR",
        "VIDEO_SIGNAL_FAIL",
    };

    if (T_e8_IPA_AvailabilityStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_IPA_AvailabilityStatus_IsValid (T_e8_IPA_AvailabilityStatus value)
{
    switch (value) {
    case T_e8_IPA_AvailabilityStatus__NOT_AVAILABLE:
    case T_e8_IPA_AvailabilityStatus__INITIALISING:
    case T_e8_IPA_AvailabilityStatus__AVAILABLE:
    case T_e8_IPA_AvailabilityStatus__AVM_IPA_ERROR:
    case T_e8_IPA_AvailabilityStatus__VIDEO_SIGNAL_FAIL:
        return true;
    default:
        return false;
    }
}

bool T_e8_IPA_SwitchMask_Parse (const char *str, size_t length, T_e8_IPA_SwitchMask &value)
{
    static stringEntry entries[] = {
        {6,"NOMASK", 0U},
        {8,"LOWSPEED", 1U},
        {9,"HIGHSPEED", 2U},
        {15,"MIDDLESPEEDMASK", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_IPA_SwitchMask_Name (T_e8_IPA_SwitchMask value)
{
    static const char* enumerationLiterals[] = {
        "NoMask",
        "LowSpeed",
        "HighSpeed",
        "MiddleSpeedMask",
    };

    if (T_e8_IPA_SwitchMask_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_IPA_SwitchMask_IsValid (T_e8_IPA_SwitchMask value)
{
    switch (value) {
    case T_e8_IPA_SwitchMask__NoMask:
    case T_e8_IPA_SwitchMask__LowSpeed:
    case T_e8_IPA_SwitchMask__HighSpeed:
    case T_e8_IPA_SwitchMask__MiddleSpeedMask:
        return true;
    default:
        return false;
    }
}

bool T_e8_Set_MicState_Parse (const char *str, size_t length, T_e8_Set_MicState &value)
{
    static stringEntry entries[] = {
        {2,"ON", 1U},
        {3,"OFF", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_Set_MicState_Name (T_e8_Set_MicState value)
{
    static const char* enumerationLiterals[] = {
        "Off",
        "On",
    };

    if (T_e8_Set_MicState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_Set_MicState_IsValid (T_e8_Set_MicState value)
{
    switch (value) {
    case T_e8_Set_MicState__Off:
    case T_e8_Set_MicState__On:
        return true;
    default:
        return false;
    }
}

bool T_e8_IPA_DirectionIndicator_Parse (const char *str, size_t length, T_e8_IPA_DirectionIndicator &value)
{
    static stringEntry entries[] = {
        {7,"FORWARD", 0U},
        {8,"BACKWARD", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_IPA_DirectionIndicator_Name (T_e8_IPA_DirectionIndicator value)
{
    static const char* enumerationLiterals[] = {
        "Forward",
        "Backward",
    };

    if (T_e8_IPA_DirectionIndicator_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_IPA_DirectionIndicator_IsValid (T_e8_IPA_DirectionIndicator value)
{
    switch (value) {
    case T_e8_IPA_DirectionIndicator__Forward:
    case T_e8_IPA_DirectionIndicator__Backward:
        return true;
    default:
        return false;
    }
}

bool T_e8_IPA_VoiceText_Parse (const char *str, size_t length, T_e8_IPA_VoiceText &value)
{
    static stringEntry entries[] = {
        {7,"VOICE_1", 1U},
        {7,"VOICE_2", 2U},
        {7,"VOICE_3", 3U},
        {7,"VOICE_4", 4U},
        {7,"VOICE_5", 5U},
        {7,"VOICE_6", 6U},
        {7,"VOICE_7", 7U},
        {7,"VOICE_8", 8U},
        {7,"VOICE_9", 9U},
        {8,"NO_SOUND", 0U},
        {8,"VOICE_10", 10U},
        {8,"VOICE_11", 11U},
        {8,"VOICE_12", 12U},
        {8,"VOICE_13", 13U},
        {8,"VOICE_14", 14U},
        {8,"VOICE_15", 15U},
    };

    return lookupInStringEntryTable (str, length, entries, 16, (unsigned int&) value);
}

const char* T_e8_IPA_VoiceText_Name (T_e8_IPA_VoiceText value)
{
    static const char* enumerationLiterals[] = {
        "No_Sound",
        "Voice_1",
        "Voice_2",
        "Voice_3",
        "Voice_4",
        "Voice_5",
        "Voice_6",
        "Voice_7",
        "Voice_8",
        "Voice_9",
        "Voice_10",
        "Voice_11",
        "Voice_12",
        "Voice_13",
        "Voice_14",
        "Voice_15",
    };

    if (T_e8_IPA_VoiceText_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_IPA_VoiceText_IsValid (T_e8_IPA_VoiceText value)
{
    switch (value) {
    case T_e8_IPA_VoiceText__No_Sound:
    case T_e8_IPA_VoiceText__Voice_1:
    case T_e8_IPA_VoiceText__Voice_2:
    case T_e8_IPA_VoiceText__Voice_3:
    case T_e8_IPA_VoiceText__Voice_4:
    case T_e8_IPA_VoiceText__Voice_5:
    case T_e8_IPA_VoiceText__Voice_6:
    case T_e8_IPA_VoiceText__Voice_7:
    case T_e8_IPA_VoiceText__Voice_8:
    case T_e8_IPA_VoiceText__Voice_9:
    case T_e8_IPA_VoiceText__Voice_10:
    case T_e8_IPA_VoiceText__Voice_11:
    case T_e8_IPA_VoiceText__Voice_12:
    case T_e8_IPA_VoiceText__Voice_13:
    case T_e8_IPA_VoiceText__Voice_14:
    case T_e8_IPA_VoiceText__Voice_15:
        return true;
    default:
        return false;
    }
}

bool T_e8_Camera_PowerSupplyStatus_Parse (const char *str, size_t length, T_e8_Camera_PowerSupplyStatus &value)
{
    static stringEntry entries[] = {
        {2,"OK", 1U},
        {7,"UNKNOWN", 0U},
        {8,"OPENLOAD", 2U},
        {11,"DEACTIVATED", 4U},
        {12,"SHORTCIRCUIT", 3U},
        {13,"NUMBEROFITEMS", 9U},
        {13,"SHORTTOGROUND", 7U},
        {14,"SHORTTOBATTERY", 8U},
        {22,"DEACTIVATED_LOWVOLTAGE", 5U},
        {23,"DEACTIVATED_HIGHVOLTAGE", 6U},
    };

    return lookupInStringEntryTable (str, length, entries, 10, (unsigned int&) value);
}

const char* T_e8_Camera_PowerSupplyStatus_Name (T_e8_Camera_PowerSupplyStatus value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "Ok",
        "OpenLoad",
        "ShortCircuit",
        "Deactivated",
        "Deactivated_LowVoltage",
        "Deactivated_HighVoltage",
        "ShortToGround",
        "ShortToBattery",
        "NumberOfItems",
    };

    if (T_e8_Camera_PowerSupplyStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_Camera_PowerSupplyStatus_IsValid (T_e8_Camera_PowerSupplyStatus value)
{
    switch (value) {
    case T_e8_Camera_PowerSupplyStatus__Unknown:
    case T_e8_Camera_PowerSupplyStatus__Ok:
    case T_e8_Camera_PowerSupplyStatus__OpenLoad:
    case T_e8_Camera_PowerSupplyStatus__ShortCircuit:
    case T_e8_Camera_PowerSupplyStatus__Deactivated:
    case T_e8_Camera_PowerSupplyStatus__Deactivated_LowVoltage:
    case T_e8_Camera_PowerSupplyStatus__Deactivated_HighVoltage:
    case T_e8_Camera_PowerSupplyStatus__ShortToGround:
    case T_e8_Camera_PowerSupplyStatus__ShortToBattery:
    case T_e8_Camera_PowerSupplyStatus__NumberOfItems:
        return true;
    default:
        return false;
    }
}

bool T_e8_Microphone_PowerSupplyStatus_Parse (const char *str, size_t length, T_e8_Microphone_PowerSupplyStatus &value)
{
    static stringEntry entries[] = {
        {2,"OK", 1U},
        {7,"UNKNOWN", 0U},
        {8,"OPENLOAD", 2U},
        {11,"DEACTIVATED", 4U},
        {12,"SHORTCIRCUIT", 3U},
        {13,"NUMBEROFITEMS", 9U},
        {13,"SHORTTOGROUND", 7U},
        {14,"SHORTTOBATTERY", 8U},
        {22,"DEACTIVATED_LOWVOLTAGE", 5U},
        {23,"DEACTIVATED_HIGHVOLTAGE", 6U},
    };

    return lookupInStringEntryTable (str, length, entries, 10, (unsigned int&) value);
}

const char* T_e8_Microphone_PowerSupplyStatus_Name (T_e8_Microphone_PowerSupplyStatus value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "Ok",
        "OpenLoad",
        "ShortCircuit",
        "Deactivated",
        "Deactivated_LowVoltage",
        "Deactivated_HighVoltage",
        "ShortToGround",
        "ShortToBattery",
        "NumberOfItems",
    };

    if (T_e8_Microphone_PowerSupplyStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_Microphone_PowerSupplyStatus_IsValid (T_e8_Microphone_PowerSupplyStatus value)
{
    switch (value) {
    case T_e8_Microphone_PowerSupplyStatus__Unknown:
    case T_e8_Microphone_PowerSupplyStatus__Ok:
    case T_e8_Microphone_PowerSupplyStatus__OpenLoad:
    case T_e8_Microphone_PowerSupplyStatus__ShortCircuit:
    case T_e8_Microphone_PowerSupplyStatus__Deactivated:
    case T_e8_Microphone_PowerSupplyStatus__Deactivated_LowVoltage:
    case T_e8_Microphone_PowerSupplyStatus__Deactivated_HighVoltage:
    case T_e8_Microphone_PowerSupplyStatus__ShortToGround:
    case T_e8_Microphone_PowerSupplyStatus__ShortToBattery:
    case T_e8_Microphone_PowerSupplyStatus__NumberOfItems:
        return true;
    default:
        return false;
    }
}

bool T_e8_RVC_Module_Parse (const char *str, size_t length, T_e8_RVC_Module &value)
{
    static stringEntry entries[] = {
        {8,"RESERVED", 0U},
        {16,"VIDEOCAPTUREUNIT", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_RVC_Module_Name (T_e8_RVC_Module value)
{
    static const char* enumerationLiterals[] = {
        "Reserved",
        "VideoCaptureUnit",
    };

    if (T_e8_RVC_Module_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_RVC_Module_IsValid (T_e8_RVC_Module value)
{
    switch (value) {
    case T_e8_RVC_Module__Reserved:
    case T_e8_RVC_Module__VideoCaptureUnit:
        return true;
    default:
        return false;
    }
}

bool T_e8_RVC_ReverseSignalStatus_Parse (const char *str, size_t length, T_e8_RVC_ReverseSignalStatus &value)
{
    static stringEntry entries[] = {
        {2,"ON", 1U},
        {3,"OFF", 0U},
        {18,"ON_NISSANDEBOUNCED", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_RVC_ReverseSignalStatus_Name (T_e8_RVC_ReverseSignalStatus value)
{
    static const char* enumerationLiterals[] = {
        "Off",
        "On",
        "On_NissanDebounced",
    };

    if (T_e8_RVC_ReverseSignalStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_RVC_ReverseSignalStatus_IsValid (T_e8_RVC_ReverseSignalStatus value)
{
    switch (value) {
    case T_e8_RVC_ReverseSignalStatus__Off:
    case T_e8_RVC_ReverseSignalStatus__On:
    case T_e8_RVC_ReverseSignalStatus__On_NissanDebounced:
        return true;
    default:
        return false;
    }
}

bool T_e8_ParkAssist_UserConfigurationType_Parse (const char *str, size_t length, T_e8_ParkAssist_UserConfigurationType &value)
{
    static stringEntry entries[] = {
        {9,"GUIDELINE", 1U},
        {16,"REAR_VIEW_CAMERA", 0U},
        {17,"DYNAMIC_GUIDELINE", 4U},
        {21,"STATIC_SIDE_GUIDELINE", 2U},
        {23,"STATIC_CENTRE_GUIDELINE", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_ParkAssist_UserConfigurationType_Name (T_e8_ParkAssist_UserConfigurationType value)
{
    static const char* enumerationLiterals[] = {
        "REAR_VIEW_CAMERA",
        "GUIDELINE",
        "STATIC_SIDE_GUIDELINE",
        "STATIC_CENTRE_GUIDELINE",
        "DYNAMIC_GUIDELINE",
    };

    if (T_e8_ParkAssist_UserConfigurationType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_ParkAssist_UserConfigurationType_IsValid (T_e8_ParkAssist_UserConfigurationType value)
{
    switch (value) {
    case T_e8_ParkAssist_UserConfigurationType__REAR_VIEW_CAMERA:
    case T_e8_ParkAssist_UserConfigurationType__GUIDELINE:
    case T_e8_ParkAssist_UserConfigurationType__STATIC_SIDE_GUIDELINE:
    case T_e8_ParkAssist_UserConfigurationType__STATIC_CENTRE_GUIDELINE:
    case T_e8_ParkAssist_UserConfigurationType__DYNAMIC_GUIDELINE:
        return true;
    default:
        return false;
    }
}

bool T_e8_ParkAssist_UserConfigurationMode_Parse (const char *str, size_t length, T_e8_ParkAssist_UserConfigurationMode &value)
{
    static stringEntry entries[] = {
        {2,"ON", 1U},
        {3,"OFF", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_ParkAssist_UserConfigurationMode_Name (T_e8_ParkAssist_UserConfigurationMode value)
{
    static const char* enumerationLiterals[] = {
        "OFF",
        "ON",
    };

    if (T_e8_ParkAssist_UserConfigurationMode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_ParkAssist_UserConfigurationMode_IsValid (T_e8_ParkAssist_UserConfigurationMode value)
{
    switch (value) {
    case T_e8_ParkAssist_UserConfigurationMode__OFF:
    case T_e8_ParkAssist_UserConfigurationMode__ON:
        return true;
    default:
        return false;
    }
}

bool T_e8_GdlAdj_AdjustButton_Parse (const char *str, size_t length, T_e8_GdlAdj_AdjustButton &value)
{
    static stringEntry entries[] = {
        {2,"UP", 0U},
        {4,"DOWN", 1U},
        {4,"LEFT", 2U},
        {5,"RIGHT", 3U},
        {13,"ROTATION_LEFT", 4U},
        {14,"ROTATION_RIGHT", 5U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_GdlAdj_AdjustButton_Name (T_e8_GdlAdj_AdjustButton value)
{
    static const char* enumerationLiterals[] = {
        "UP",
        "DOWN",
        "LEFT",
        "RIGHT",
        "ROTATION_LEFT",
        "ROTATION_RIGHT",
    };

    if (T_e8_GdlAdj_AdjustButton_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_GdlAdj_AdjustButton_IsValid (T_e8_GdlAdj_AdjustButton value)
{
    switch (value) {
    case T_e8_GdlAdj_AdjustButton__UP:
    case T_e8_GdlAdj_AdjustButton__DOWN:
    case T_e8_GdlAdj_AdjustButton__LEFT:
    case T_e8_GdlAdj_AdjustButton__RIGHT:
    case T_e8_GdlAdj_AdjustButton__ROTATION_LEFT:
    case T_e8_GdlAdj_AdjustButton__ROTATION_RIGHT:
        return true;
    default:
        return false;
    }
}

bool T_e8_GdlAdj_Completion_Parse (const char *str, size_t length, T_e8_GdlAdj_Completion &value)
{
    static stringEntry entries[] = {
        {5,"RESET", 2U},
        {7,"CONFIRM", 0U},
        {7,"REFUSED", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_GdlAdj_Completion_Name (T_e8_GdlAdj_Completion value)
{
    static const char* enumerationLiterals[] = {
        "CONFIRM",
        "REFUSED",
        "RESET",
    };

    if (T_e8_GdlAdj_Completion_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_GdlAdj_Completion_IsValid (T_e8_GdlAdj_Completion value)
{
    switch (value) {
    case T_e8_GdlAdj_Completion__CONFIRM:
    case T_e8_GdlAdj_Completion__REFUSED:
    case T_e8_GdlAdj_Completion__RESET:
        return true;
    default:
        return false;
    }
}

bool T_e8_GdlAdj_Request_Parse (const char *str, size_t length, T_e8_GdlAdj_Request &value)
{
    static stringEntry entries[] = {
        {3,"GET", 1U},
        {3,"SET", 2U},
        {7,"GET_ALL", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_GdlAdj_Request_Name (T_e8_GdlAdj_Request value)
{
    static const char* enumerationLiterals[] = {
        "GET_ALL",
        "GET",
        "SET",
    };

    if (T_e8_GdlAdj_Request_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_GdlAdj_Request_IsValid (T_e8_GdlAdj_Request value)
{
    switch (value) {
    case T_e8_GdlAdj_Request__GET_ALL:
    case T_e8_GdlAdj_Request__GET:
    case T_e8_GdlAdj_Request__SET:
        return true;
    default:
        return false;
    }
}

bool T_e8_GdlAdj_ConfigurationItem_Parse (const char *str, size_t length, T_e8_GdlAdj_ConfigurationItem &value)
{
    static stringEntry entries[] = {
        {4,"NONE", 0U},
        {6,"CAMYAW", 17U},
        {7,"CAMROLL", 19U},
        {8,"CAMPITCH", 18U},
        {9,"WHEELBASE", 3U},
        {10,"CAMXOFFSET", 14U},
        {10,"CAMYOFFSET", 15U},
        {10,"CAMZOFFSET", 16U},
        {12,"REAROVERHANG", 4U},
        {12,"TUNINGMETHOD", 53U},
        {12,"VEHICLEWIDTH", 2U},
        {14,"GUIDELINESTYLE", 13U},
        {14,"REARTIRETHRESH", 22U},
        {15,"FRONTTIRETHRESH", 20U},
        {16,"ANTICIPATORYLINE", 1U},
        {16,"RADIUSTUNINGFACT", 9U},
        {16,"RVCLENSPARAMETER", 67U},
        {17,"FOURWHEELSTEERING", 10U},
        {17,"MAXREARWHEELANGLE", 8U},
        {17,"MINREARTIRECHANGE", 23U},
        {17,"TUNINGDELTACAMYAW", 54U},
        {18,"MAXSTEERWHEELANGLE", 7U},
        {18,"MINFRONTTIRECHANGE", 21U},
        {18,"STEERWHEELCALIB_F1", 5U},
        {18,"STEERWHEELCALIB_F3", 6U},
        {18,"TIREANGLETURNSENSE", 11U},
        {18,"TUNINGDELTACAMROLL", 56U},
        {19,"GUIDELINESIDEMARGIN", 25U},
        {19,"LINEWIDTHDYNAMICFAR", 44U},
        {19,"RGBCOLORDYNAMIC_RED", 38U},
        {19,"STATICLINELENGTHMID", 48U},
        {19,"TUNINGDELTACAMPITCH", 55U},
        {19,"TUNINGDELTAXFARLEFT", 59U},
        {20,"LINEWIDTHDYNAMICNEAR", 43U},
        {20,"RGBCOLORDYNAMIC_BLUE", 40U},
        {20,"STATICLINELENGHTFAR1", 49U},
        {20,"STATICLINELENGHTFAR2", 50U},
        {20,"STATICLINELENGTHNEAR", 47U},
        {20,"TUNINGDELTAXFARRIGHT", 63U},
        {20,"TUNINGDELTAXNEARLEFT", 57U},
        {20,"TUNINGDELTAYNEARLEFT", 58U},
        {21,"RGBCOLORDYNAMIC_GREEN", 39U},
        {21,"STATICHORIZLINELENGHT", 51U},
        {21,"TUNINGDELTAXNEARRIGHT", 61U},
        {21,"TUNINGDELTAYNEARRIGHT", 62U},
        {22,"GUIDELINESTARTDISTANCE", 24U},
        {22,"LINEWIDTHSTATICSIDEFAR", 42U},
        {23,"LINEWIDTHSTATICSIDENEAR", 41U},
        {23,"TIREANGLEREFERENCEPOINT", 12U},
        {24,"LINEWIDTHFACTORNEARHLINE", 52U},
        {24,"LINEWIDTHFACTORVERTLINES", 68U},
        {24,"LINEWIDTHSTATICCENTERFAR", 46U},
        {24,"RGBCOLORSTATICCENTER_RED", 35U},
        {24,"TUNINGNEARLINELENGTHLEFT", 60U},
        {24,"TUNINGRWAZEROPOINTOFFSET", 66U},
        {24,"TUNINGSWAZEROPOINTOFFSET", 65U},
        {25,"LINEWIDTHSTATICCENTERNEAR", 45U},
        {25,"RGBCOLORSTATICCENTER_BLUE", 37U},
        {25,"RGBCOLORSTATICSIDEFAR_RED", 32U},
        {25,"RGBCOLORSTATICSIDEMID_RED", 29U},
        {25,"TUNINGNEARLINELENGHTRIGHT", 64U},
        {26,"RGBCOLORSTATICCENTER_GREEN", 36U},
        {26,"RGBCOLORSTATICSIDEFAR_BLUE", 34U},
        {26,"RGBCOLORSTATICSIDEMID_BLUE", 31U},
        {26,"RGBCOLORSTATICSIDENEAR_RED", 26U},
        {27,"RGBCOLORSTATICSIDEFAR_GREEN", 33U},
        {27,"RGBCOLORSTATICSIDEMID_GREEN", 30U},
        {27,"RGBCOLORSTATICSIDENEAR_BLUE", 28U},
        {28,"RGBCOLORSTATICSIDENEAR_GREEN", 27U},
    };

    return lookupInStringEntryTable (str, length, entries, 69, (unsigned int&) value);
}

const char* T_e8_GdlAdj_ConfigurationItem_Name (T_e8_GdlAdj_ConfigurationItem value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "AnticipatoryLine",
        "VehicleWidth",
        "WheelBase",
        "RearOverhang",
        "SteerWheelCalib_f1",
        "SteerWheelCalib_f3",
        "MaxSteerWheelAngle",
        "MaxRearWheelAngle",
        "RadiusTuningFact",
        "FourWheelSteering",
        "TireAngleTurnSense",
        "TireAngleReferencePoint",
        "GuidelineStyle",
        "CamXOffset",
        "CamYOffset",
        "CamZOffset",
        "CamYaw",
        "CamPitch",
        "CamRoll",
        "FrontTireThresh",
        "MinFrontTireChange",
        "RearTireThresh",
        "MinRearTireChange",
        "GuidelineStartDistance",
        "GuidelineSideMargin",
        "RgbColorStaticSideNear_Red",
        "RgbColorStaticSideNear_Green",
        "RgbColorStaticSideNear_Blue",
        "RgbColorStaticSideMid_Red",
        "RgbColorStaticSideMid_Green",
        "RgbColorStaticSideMid_Blue",
        "RgbColorStaticSideFar_Red",
        "RgbColorStaticSideFar_Green",
        "RgbColorStaticSideFar_Blue",
        "RgbColorStaticCenter_Red",
        "RgbColorStaticCenter_Green",
        "RgbColorStaticCenter_Blue",
        "RgbColorDynamic_Red",
        "RgbColorDynamic_Green",
        "RgbColorDynamic_Blue",
        "LineWidthStaticSideNear",
        "LineWidthStaticSideFar",
        "LineWidthDynamicNear",
        "LineWidthDynamicFar",
        "LineWidthStaticCenterNear",
        "LineWidthStaticCenterFar",
        "StaticLineLengthNear",
        "StaticLineLengthMid",
        "StaticLineLenghtFar1",
        "StaticLineLenghtFar2",
        "StaticHorizLineLenght",
        "LineWidthFactorNearHLine",
        "TuningMethod",
        "TuningDeltaCamYaw",
        "TuningDeltaCamPitch",
        "TuningDeltaCamRoll",
        "TuningDeltaXNearLeft",
        "TuningDeltaYNearLeft",
        "TuningDeltaXFarLeft",
        "TuningNearLineLengthLeft",
        "TuningDeltaXNearRight",
        "TuningDeltaYNearRight",
        "TuningDeltaXFarRight",
        "TuningNearLineLenghtRight",
        "TuningSwaZeroPointOffset",
        "TuningRwaZeroPointOffset",
        "RvcLensParameter",
        "LineWidthFactorVertLines",
    };

    if (T_e8_GdlAdj_ConfigurationItem_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_GdlAdj_ConfigurationItem_IsValid (T_e8_GdlAdj_ConfigurationItem value)
{
    switch (value) {
    case T_e8_GdlAdj_ConfigurationItem__None:
    case T_e8_GdlAdj_ConfigurationItem__AnticipatoryLine:
    case T_e8_GdlAdj_ConfigurationItem__VehicleWidth:
    case T_e8_GdlAdj_ConfigurationItem__WheelBase:
    case T_e8_GdlAdj_ConfigurationItem__RearOverhang:
    case T_e8_GdlAdj_ConfigurationItem__SteerWheelCalib_f1:
    case T_e8_GdlAdj_ConfigurationItem__SteerWheelCalib_f3:
    case T_e8_GdlAdj_ConfigurationItem__MaxSteerWheelAngle:
    case T_e8_GdlAdj_ConfigurationItem__MaxRearWheelAngle:
    case T_e8_GdlAdj_ConfigurationItem__RadiusTuningFact:
    case T_e8_GdlAdj_ConfigurationItem__FourWheelSteering:
    case T_e8_GdlAdj_ConfigurationItem__TireAngleTurnSense:
    case T_e8_GdlAdj_ConfigurationItem__TireAngleReferencePoint:
    case T_e8_GdlAdj_ConfigurationItem__GuidelineStyle:
    case T_e8_GdlAdj_ConfigurationItem__CamXOffset:
    case T_e8_GdlAdj_ConfigurationItem__CamYOffset:
    case T_e8_GdlAdj_ConfigurationItem__CamZOffset:
    case T_e8_GdlAdj_ConfigurationItem__CamYaw:
    case T_e8_GdlAdj_ConfigurationItem__CamPitch:
    case T_e8_GdlAdj_ConfigurationItem__CamRoll:
    case T_e8_GdlAdj_ConfigurationItem__FrontTireThresh:
    case T_e8_GdlAdj_ConfigurationItem__MinFrontTireChange:
    case T_e8_GdlAdj_ConfigurationItem__RearTireThresh:
    case T_e8_GdlAdj_ConfigurationItem__MinRearTireChange:
    case T_e8_GdlAdj_ConfigurationItem__GuidelineStartDistance:
    case T_e8_GdlAdj_ConfigurationItem__GuidelineSideMargin:
    case T_e8_GdlAdj_ConfigurationItem__RgbColorStaticSideNear_Red:
    case T_e8_GdlAdj_ConfigurationItem__RgbColorStaticSideNear_Green:
    case T_e8_GdlAdj_ConfigurationItem__RgbColorStaticSideNear_Blue:
    case T_e8_GdlAdj_ConfigurationItem__RgbColorStaticSideMid_Red:
    case T_e8_GdlAdj_ConfigurationItem__RgbColorStaticSideMid_Green:
    case T_e8_GdlAdj_ConfigurationItem__RgbColorStaticSideMid_Blue:
    case T_e8_GdlAdj_ConfigurationItem__RgbColorStaticSideFar_Red:
    case T_e8_GdlAdj_ConfigurationItem__RgbColorStaticSideFar_Green:
    case T_e8_GdlAdj_ConfigurationItem__RgbColorStaticSideFar_Blue:
    case T_e8_GdlAdj_ConfigurationItem__RgbColorStaticCenter_Red:
    case T_e8_GdlAdj_ConfigurationItem__RgbColorStaticCenter_Green:
    case T_e8_GdlAdj_ConfigurationItem__RgbColorStaticCenter_Blue:
    case T_e8_GdlAdj_ConfigurationItem__RgbColorDynamic_Red:
    case T_e8_GdlAdj_ConfigurationItem__RgbColorDynamic_Green:
    case T_e8_GdlAdj_ConfigurationItem__RgbColorDynamic_Blue:
    case T_e8_GdlAdj_ConfigurationItem__LineWidthStaticSideNear:
    case T_e8_GdlAdj_ConfigurationItem__LineWidthStaticSideFar:
    case T_e8_GdlAdj_ConfigurationItem__LineWidthDynamicNear:
    case T_e8_GdlAdj_ConfigurationItem__LineWidthDynamicFar:
    case T_e8_GdlAdj_ConfigurationItem__LineWidthStaticCenterNear:
    case T_e8_GdlAdj_ConfigurationItem__LineWidthStaticCenterFar:
    case T_e8_GdlAdj_ConfigurationItem__StaticLineLengthNear:
    case T_e8_GdlAdj_ConfigurationItem__StaticLineLengthMid:
    case T_e8_GdlAdj_ConfigurationItem__StaticLineLenghtFar1:
    case T_e8_GdlAdj_ConfigurationItem__StaticLineLenghtFar2:
    case T_e8_GdlAdj_ConfigurationItem__StaticHorizLineLenght:
    case T_e8_GdlAdj_ConfigurationItem__LineWidthFactorNearHLine:
    case T_e8_GdlAdj_ConfigurationItem__TuningMethod:
    case T_e8_GdlAdj_ConfigurationItem__TuningDeltaCamYaw:
    case T_e8_GdlAdj_ConfigurationItem__TuningDeltaCamPitch:
    case T_e8_GdlAdj_ConfigurationItem__TuningDeltaCamRoll:
    case T_e8_GdlAdj_ConfigurationItem__TuningDeltaXNearLeft:
    case T_e8_GdlAdj_ConfigurationItem__TuningDeltaYNearLeft:
    case T_e8_GdlAdj_ConfigurationItem__TuningDeltaXFarLeft:
    case T_e8_GdlAdj_ConfigurationItem__TuningNearLineLengthLeft:
    case T_e8_GdlAdj_ConfigurationItem__TuningDeltaXNearRight:
    case T_e8_GdlAdj_ConfigurationItem__TuningDeltaYNearRight:
    case T_e8_GdlAdj_ConfigurationItem__TuningDeltaXFarRight:
    case T_e8_GdlAdj_ConfigurationItem__TuningNearLineLenghtRight:
    case T_e8_GdlAdj_ConfigurationItem__TuningSwaZeroPointOffset:
    case T_e8_GdlAdj_ConfigurationItem__TuningRwaZeroPointOffset:
    case T_e8_GdlAdj_ConfigurationItem__RvcLensParameter:
    case T_e8_GdlAdj_ConfigurationItem__LineWidthFactorVertLines:
        return true;
    default:
        return false;
    }
}

bool T_e8_MVCViewingState_Parse (const char *str, size_t length, T_e8_MVCViewingState &value)
{
    static stringEntry entries[] = {
        {4,"LEFT", 4U},
        {4,"REAR", 2U},
        {5,"FRONT", 1U},
        {5,"RIGHT", 3U},
        {6,"NOVIEW", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_MVCViewingState_Name (T_e8_MVCViewingState value)
{
    static const char* enumerationLiterals[] = {
        "NoView",
        "Front",
        "Rear",
        "Right",
        "Left",
    };

    if (T_e8_MVCViewingState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_MVCViewingState_IsValid (T_e8_MVCViewingState value)
{
    switch (value) {
    case T_e8_MVCViewingState__NoView:
    case T_e8_MVCViewingState__Front:
    case T_e8_MVCViewingState__Rear:
    case T_e8_MVCViewingState__Right:
    case T_e8_MVCViewingState__Left:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVM_View_Request_Parse (const char *str, size_t length, T_e8_AVM_View_Request &value)
{
    static stringEntry entries[] = {
        {3,"OFF", 3U},
        {9,"BIRD_VIEW", 1U},
        {9,"SIDE_VIEW", 2U},
        {10,"NO_REQUEST", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_AVM_View_Request_Name (T_e8_AVM_View_Request value)
{
    static const char* enumerationLiterals[] = {
        "No_Request",
        "Bird_View",
        "Side_View",
        "Off",
    };

    if (T_e8_AVM_View_Request_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AVM_View_Request_IsValid (T_e8_AVM_View_Request value)
{
    switch (value) {
    case T_e8_AVM_View_Request__No_Request:
    case T_e8_AVM_View_Request__Bird_View:
    case T_e8_AVM_View_Request__Side_View:
    case T_e8_AVM_View_Request__Off:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVM_View_Status_Parse (const char *str, size_t length, T_e8_AVM_View_Status &value)
{
    static stringEntry entries[] = {
        {9,"ONLY_REAR", 4U},
        {10,"DEALERMODE", 5U},
        {10,"NO_REQUEST", 6U},
        {14,"REAR_BIRD_VIEW", 2U},
        {14,"REAR_SIDE_VIEW", 3U},
        {15,"FRONT_BIRD_VIEW", 0U},
        {15,"FRONT_SIDE_VIEW", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 7, (unsigned int&) value);
}

const char* T_e8_AVM_View_Status_Name (T_e8_AVM_View_Status value)
{
    static const char* enumerationLiterals[] = {
        "Front_Bird_View",
        "Front_Side_View",
        "Rear_Bird_View",
        "Rear_Side_View",
        "Only_Rear",
        "DealerMode",
        "No_Request",
    };

    if (T_e8_AVM_View_Status_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AVM_View_Status_IsValid (T_e8_AVM_View_Status value)
{
    switch (value) {
    case T_e8_AVM_View_Status__Front_Bird_View:
    case T_e8_AVM_View_Status__Front_Side_View:
    case T_e8_AVM_View_Status__Rear_Bird_View:
    case T_e8_AVM_View_Status__Rear_Side_View:
    case T_e8_AVM_View_Status__Only_Rear:
    case T_e8_AVM_View_Status__DealerMode:
    case T_e8_AVM_View_Status__No_Request:
        return true;
    default:
        return false;
    }
}

bool T_e8_Tailgate_State_Parse (const char *str, size_t length, T_e8_Tailgate_State &value)
{
    static stringEntry entries[] = {
        {4,"OPEN", 2U},
        {6,"CLOSED", 1U},
        {6,"UNUSED", 3U},
        {11,"UNAVAILABLE", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_Tailgate_State_Name (T_e8_Tailgate_State value)
{
    static const char* enumerationLiterals[] = {
        "Unavailable",
        "Closed",
        "Open",
        "Unused",
    };

    if (T_e8_Tailgate_State_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_Tailgate_State_IsValid (T_e8_Tailgate_State value)
{
    switch (value) {
    case T_e8_Tailgate_State__Unavailable:
    case T_e8_Tailgate_State__Closed:
    case T_e8_Tailgate_State__Open:
    case T_e8_Tailgate_State__Unused:
        return true;
    default:
        return false;
    }
}

bool T_e8_TouchGesture_Parse (const char *str, size_t length, T_e8_TouchGesture &value)
{
    static stringEntry entries[] = {
        {4,"DRAG", 2U},
        {4,"NONE", 0U},
        {5,"FLICK", 4U},
        {5,"PINCH", 3U},
        {5,"PRESS", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_TouchGesture_Name (T_e8_TouchGesture value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "Press",
        "Drag",
        "Pinch",
        "Flick",
    };

    if (T_e8_TouchGesture_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TouchGesture_IsValid (T_e8_TouchGesture value)
{
    switch (value) {
    case T_e8_TouchGesture__None:
    case T_e8_TouchGesture__Press:
    case T_e8_TouchGesture__Drag:
    case T_e8_TouchGesture__Pinch:
    case T_e8_TouchGesture__Flick:
        return true;
    default:
        return false;
    }
}

bool T_e8_Direction_Parse (const char *str, size_t length, T_e8_Direction &value)
{
    static stringEntry entries[] = {
        {4,"EAST", 5U},
        {4,"WEST", 13U},
        {5,"NORTH", 1U},
        {5,"SOUTH", 9U},
        {7,"INVALID", 0U},
        {10,"NORTH_EAST", 3U},
        {10,"NORTH_WEST", 15U},
        {10,"SOUTH_EAST", 7U},
        {10,"SOUTH_WEST", 11U},
        {15,"EAST_NORTH_EAST", 4U},
        {15,"EAST_SOUTH_EAST", 6U},
        {15,"WEST_NORTH_WEST", 14U},
        {15,"WEST_SOUTH_WEST", 12U},
        {16,"NORTH_NORTH_EAST", 2U},
        {16,"NORTH_NORTH_WEST", 16U},
        {16,"SOUTH_SOUTH_EAST", 8U},
        {16,"SOUTH_SOUTH_WEST", 10U},
    };

    return lookupInStringEntryTable (str, length, entries, 17, (unsigned int&) value);
}

const char* T_e8_Direction_Name (T_e8_Direction value)
{
    static const char* enumerationLiterals[] = {
        "Invalid",
        "North",
        "North_North_East",
        "North_East",
        "East_North_East",
        "East",
        "East_South_East",
        "South_East",
        "South_South_East",
        "South",
        "South_South_West",
        "South_West",
        "West_South_West",
        "West",
        "West_North_West",
        "North_West",
        "North_North_West",
    };

    if (T_e8_Direction_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_Direction_IsValid (T_e8_Direction value)
{
    switch (value) {
    case T_e8_Direction__Invalid:
    case T_e8_Direction__North:
    case T_e8_Direction__North_North_East:
    case T_e8_Direction__North_East:
    case T_e8_Direction__East_North_East:
    case T_e8_Direction__East:
    case T_e8_Direction__East_South_East:
    case T_e8_Direction__South_East:
    case T_e8_Direction__South_South_East:
    case T_e8_Direction__South:
    case T_e8_Direction__South_South_West:
    case T_e8_Direction__South_West:
    case T_e8_Direction__West_South_West:
    case T_e8_Direction__West:
    case T_e8_Direction__West_North_West:
    case T_e8_Direction__North_West:
    case T_e8_Direction__North_North_West:
        return true;
    default:
        return false;
    }
}

bool T_e8_FAP_SettingItem_Parse (const char *str, size_t length, T_e8_FAP_SettingItem &value)
{
    static stringEntry entries[] = {
        {10,"SETTINGS_1", 1U},
        {10,"SETTINGS_2", 2U},
        {10,"SETTINGS_3", 3U},
        {10,"SETTINGS_4", 4U},
        {10,"SETTINGS_5", 5U},
        {10,"SETTINGS_6", 6U},
        {10,"SETTINGS_7", 7U},
        {10,"SETTINGS_8", 8U},
        {10,"SETTINGS_9", 9U},
        {11,"SETTINGS_10", 10U},
        {19,"SETTINGSBUTTONAVAIL", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 11, (unsigned int&) value);
}

const char* T_e8_FAP_SettingItem_Name (T_e8_FAP_SettingItem value)
{
    static const char* enumerationLiterals[] = {
        "SettingsButtonAvail",
        "Settings_1",
        "Settings_2",
        "Settings_3",
        "Settings_4",
        "Settings_5",
        "Settings_6",
        "Settings_7",
        "Settings_8",
        "Settings_9",
        "Settings_10",
    };

    if (T_e8_FAP_SettingItem_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_FAP_SettingItem_IsValid (T_e8_FAP_SettingItem value)
{
    switch (value) {
    case T_e8_FAP_SettingItem__SettingsButtonAvail:
    case T_e8_FAP_SettingItem__Settings_1:
    case T_e8_FAP_SettingItem__Settings_2:
    case T_e8_FAP_SettingItem__Settings_3:
    case T_e8_FAP_SettingItem__Settings_4:
    case T_e8_FAP_SettingItem__Settings_5:
    case T_e8_FAP_SettingItem__Settings_6:
    case T_e8_FAP_SettingItem__Settings_7:
    case T_e8_FAP_SettingItem__Settings_8:
    case T_e8_FAP_SettingItem__Settings_9:
    case T_e8_FAP_SettingItem__Settings_10:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVM_FAP_SettingState_Parse (const char *str, size_t length, T_e8_AVM_FAP_SettingState &value)
{
    static stringEntry entries[] = {
        {2,"ON", 1U},
        {3,"OFF", 2U},
        {8,"RESERVED", 3U},
        {13,"NOT_DISPLAYED", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_AVM_FAP_SettingState_Name (T_e8_AVM_FAP_SettingState value)
{
    static const char* enumerationLiterals[] = {
        "Not_Displayed",
        "On",
        "Off",
        "Reserved",
    };

    if (T_e8_AVM_FAP_SettingState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AVM_FAP_SettingState_IsValid (T_e8_AVM_FAP_SettingState value)
{
    switch (value) {
    case T_e8_AVM_FAP_SettingState__Not_Displayed:
    case T_e8_AVM_FAP_SettingState__On:
    case T_e8_AVM_FAP_SettingState__Off:
    case T_e8_AVM_FAP_SettingState__Reserved:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVM_SettingItem_Parse (const char *str, size_t length, T_e8_AVM_SettingItem &value)
{
    static stringEntry entries[] = {
        {10,"SETTINGS_1", 1U},
        {10,"SETTINGS_2", 2U},
        {10,"SETTINGS_3", 3U},
        {10,"SETTINGS_4", 4U},
        {10,"SETTINGS_5", 5U},
        {10,"SETTINGS_6", 6U},
        {10,"SETTINGS_7", 7U},
        {10,"SETTINGS_8", 8U},
        {10,"SETTINGS_9", 9U},
        {11,"SETTINGS_10", 10U},
        {19,"SETTINGSBUTTONAVAIL", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 11, (unsigned int&) value);
}

const char* T_e8_AVM_SettingItem_Name (T_e8_AVM_SettingItem value)
{
    static const char* enumerationLiterals[] = {
        "SettingsButtonAvail",
        "Settings_1",
        "Settings_2",
        "Settings_3",
        "Settings_4",
        "Settings_5",
        "Settings_6",
        "Settings_7",
        "Settings_8",
        "Settings_9",
        "Settings_10",
    };

    if (T_e8_AVM_SettingItem_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AVM_SettingItem_IsValid (T_e8_AVM_SettingItem value)
{
    switch (value) {
    case T_e8_AVM_SettingItem__SettingsButtonAvail:
    case T_e8_AVM_SettingItem__Settings_1:
    case T_e8_AVM_SettingItem__Settings_2:
    case T_e8_AVM_SettingItem__Settings_3:
    case T_e8_AVM_SettingItem__Settings_4:
    case T_e8_AVM_SettingItem__Settings_5:
    case T_e8_AVM_SettingItem__Settings_6:
    case T_e8_AVM_SettingItem__Settings_7:
    case T_e8_AVM_SettingItem__Settings_8:
    case T_e8_AVM_SettingItem__Settings_9:
    case T_e8_AVM_SettingItem__Settings_10:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVMph3_SwitchId_Parse (const char *str, size_t length, T_e8_AVMph3_SwitchId &value)
{
    static stringEntry entries[] = {
        {3,"END", 13U},
        {4,"BACK", 22U},
        {4,"HINT", 14U},
        {4,"NONE", 0U},
        {5,"START", 12U},
        {6,"CAMERA", 3U},
        {8,"SIDEVIEW", 5U},
        {8,"WIDEVIEW", 6U},
        {10,"BCI_IND_ON", 177U},
        {10,"CORNERVIEW", 7U},
        {10,"MOD_IND_ON", 27U},
        {10,"REVERSE_ON", 1U},
        {11,"BCI_IND_OFF", 176U},
        {11,"FINERTUNING", 20U},
        {11,"MOD_IND_OFF", 28U},
        {11,"REVERSE_OFF", 2U},
        {12,"PARKINGGUIDE", 11U},
        {12,"SONAR_IND_ON", 29U},
        {13,"HIGHANGLEVIEW", 4U},
        {13,"POINTREMOVING", 10U},
        {13,"RESERVESWITCH", 31U},
        {13,"SONAR_IND_OFF", 30U},
        {13,"VIEWSWITCHING", 8U},
        {15,"MODSONAR_IND_ON", 23U},
        {16,"MODSONAR_IND_OFF", 24U},
        {16,"STARTVOICEOUTPUT", 15U},
        {16,"TANDEMATLEFTSIDE", 18U},
        {17,"DECIDEFINERTUNING", 21U},
        {17,"NARROWMODE_IND_ON", 25U},
        {17,"POINTREGISTRATION", 9U},
        {17,"TANDEMATRIGHTSIDE", 19U},
        {18,"NARROWMODE_IND_OFF", 26U},
        {18,"PARALLELATLEFTSIDE", 16U},
        {19,"PARALLELATRIGHTSIDE", 17U},
    };

    return lookupInStringEntryTable (str, length, entries, 34, (unsigned int&) value);
}

const char* T_e8_AVMph3_SwitchId_Name (T_e8_AVMph3_SwitchId value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "Reverse_ON",
        "Reverse_OFF",
        "Camera",
        "HighAngleView",
        "SideView",
        "WideView",
        "CornerView",
        "ViewSwitching",
        "PointRegistration",
        "PointRemoving",
        "ParkingGuide",
        "Start",
        "End",
        "Hint",
        "StartVoiceOutput",
        "ParallelAtLeftSide",
        "ParallelAtRightSide",
        "TandemAtLeftSide",
        "TandemAtRightSide",
        "FinerTuning",
        "DecideFinerTuning",
        "Back",
        "MODSonar_IND_ON",
        "MODSonar_IND_OFF",
        "NarrowMode_IND_ON",
        "NarrowMode_IND_OFF",
        "MOD_IND_ON",
        "MOD_IND_OFF",
        "Sonar_IND_ON",
        "Sonar_IND_OFF",
        "ReserveSwitch",
        "BCI_IND_OFF",
        "BCI_IND_ON",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        10U,
        11U,
        12U,
        13U,
        14U,
        15U,
        16U,
        17U,
        18U,
        19U,
        20U,
        21U,
        22U,
        23U,
        24U,
        25U,
        26U,
        27U,
        28U,
        29U,
        30U,
        31U,
        176U,
        177U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 34, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_AVMph3_SwitchId_IsValid (T_e8_AVMph3_SwitchId value)
{
    switch (value) {
    case T_e8_AVMph3_SwitchId__None:
    case T_e8_AVMph3_SwitchId__Reverse_ON:
    case T_e8_AVMph3_SwitchId__Reverse_OFF:
    case T_e8_AVMph3_SwitchId__Camera:
    case T_e8_AVMph3_SwitchId__HighAngleView:
    case T_e8_AVMph3_SwitchId__SideView:
    case T_e8_AVMph3_SwitchId__WideView:
    case T_e8_AVMph3_SwitchId__CornerView:
    case T_e8_AVMph3_SwitchId__ViewSwitching:
    case T_e8_AVMph3_SwitchId__PointRegistration:
    case T_e8_AVMph3_SwitchId__PointRemoving:
    case T_e8_AVMph3_SwitchId__ParkingGuide:
    case T_e8_AVMph3_SwitchId__Start:
    case T_e8_AVMph3_SwitchId__End:
    case T_e8_AVMph3_SwitchId__Hint:
    case T_e8_AVMph3_SwitchId__StartVoiceOutput:
    case T_e8_AVMph3_SwitchId__ParallelAtLeftSide:
    case T_e8_AVMph3_SwitchId__ParallelAtRightSide:
    case T_e8_AVMph3_SwitchId__TandemAtLeftSide:
    case T_e8_AVMph3_SwitchId__TandemAtRightSide:
    case T_e8_AVMph3_SwitchId__FinerTuning:
    case T_e8_AVMph3_SwitchId__DecideFinerTuning:
    case T_e8_AVMph3_SwitchId__Back:
    case T_e8_AVMph3_SwitchId__MODSonar_IND_ON:
    case T_e8_AVMph3_SwitchId__MODSonar_IND_OFF:
    case T_e8_AVMph3_SwitchId__NarrowMode_IND_ON:
    case T_e8_AVMph3_SwitchId__NarrowMode_IND_OFF:
    case T_e8_AVMph3_SwitchId__MOD_IND_ON:
    case T_e8_AVMph3_SwitchId__MOD_IND_OFF:
    case T_e8_AVMph3_SwitchId__Sonar_IND_ON:
    case T_e8_AVMph3_SwitchId__Sonar_IND_OFF:
    case T_e8_AVMph3_SwitchId__ReserveSwitch:
    case T_e8_AVMph3_SwitchId__BCI_IND_OFF:
    case T_e8_AVMph3_SwitchId__BCI_IND_ON:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVMph3_SwitchStatus_Parse (const char *str, size_t length, T_e8_AVMph3_SwitchStatus &value)
{
    static stringEntry entries[] = {
        {4,"MASK", 1U},
        {4,"PUSH", 2U},
        {6,"NORMAL", 0U},
        {9,"HIGHLIGHT", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_AVMph3_SwitchStatus_Name (T_e8_AVMph3_SwitchStatus value)
{
    static const char* enumerationLiterals[] = {
        "Normal",
        "Mask",
        "Push",
        "Highlight",
    };

    if (T_e8_AVMph3_SwitchStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AVMph3_SwitchStatus_IsValid (T_e8_AVMph3_SwitchStatus value)
{
    switch (value) {
    case T_e8_AVMph3_SwitchStatus__Normal:
    case T_e8_AVMph3_SwitchStatus__Mask:
    case T_e8_AVMph3_SwitchStatus__Push:
    case T_e8_AVMph3_SwitchStatus__Highlight:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVMph3_DispStatus_Parse (const char *str, size_t length, T_e8_AVMph3_DispStatus &value)
{
    static stringEntry entries[] = {
        {6,"CAMERA", 1U},
        {15,"OTHERTHANCAMERA", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_AVMph3_DispStatus_Name (T_e8_AVMph3_DispStatus value)
{
    static const char* enumerationLiterals[] = {
        "OtherThanCamera",
        "Camera",
    };

    if (T_e8_AVMph3_DispStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AVMph3_DispStatus_IsValid (T_e8_AVMph3_DispStatus value)
{
    switch (value) {
    case T_e8_AVMph3_DispStatus__OtherThanCamera:
    case T_e8_AVMph3_DispStatus__Camera:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVMph3_ViewPattern_Parse (const char *str, size_t length, T_e8_AVMph3_ViewPattern &value)
{
    static stringEntry entries[] = {
        {4,"NONE", 0U},
        {10,"PATTERN1_1", 1U},
        {10,"PATTERN2_1", 3U},
        {10,"PATTERN3_1", 5U},
        {10,"PATTERN3_2", 6U},
        {10,"PATTERN4_1", 16U},
        {10,"PATTERN4_2", 17U},
        {10,"PATTERN5_1", 18U},
        {10,"PATTERN5_2", 19U},
        {10,"PATTERN6_1", 20U},
        {10,"PATTERN6_2", 21U},
        {10,"PATTERN6_3", 22U},
        {10,"PATTERN7_1", 23U},
        {10,"PATTERN7_2", 24U},
        {10,"PATTERN8_1", 25U},
        {10,"PATTERN8_2", 26U},
        {10,"PATTERN9_1", 27U},
        {10,"PATTERN9_2", 28U},
        {11,"PATTERN10_1", 29U},
    };

    return lookupInStringEntryTable (str, length, entries, 19, (unsigned int&) value);
}

const char* T_e8_AVMph3_ViewPattern_Name (T_e8_AVMph3_ViewPattern value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "Pattern1_1",
        "Pattern2_1",
        "Pattern3_1",
        "Pattern3_2",
        "Pattern4_1",
        "Pattern4_2",
        "Pattern5_1",
        "Pattern5_2",
        "Pattern6_1",
        "Pattern6_2",
        "Pattern6_3",
        "Pattern7_1",
        "Pattern7_2",
        "Pattern8_1",
        "Pattern8_2",
        "Pattern9_1",
        "Pattern9_2",
        "Pattern10_1",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        3U,
        5U,
        6U,
        16U,
        17U,
        18U,
        19U,
        20U,
        21U,
        22U,
        23U,
        24U,
        25U,
        26U,
        27U,
        28U,
        29U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 19, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_AVMph3_ViewPattern_IsValid (T_e8_AVMph3_ViewPattern value)
{
    switch (value) {
    case T_e8_AVMph3_ViewPattern__None:
    case T_e8_AVMph3_ViewPattern__Pattern1_1:
    case T_e8_AVMph3_ViewPattern__Pattern2_1:
    case T_e8_AVMph3_ViewPattern__Pattern3_1:
    case T_e8_AVMph3_ViewPattern__Pattern3_2:
    case T_e8_AVMph3_ViewPattern__Pattern4_1:
    case T_e8_AVMph3_ViewPattern__Pattern4_2:
    case T_e8_AVMph3_ViewPattern__Pattern5_1:
    case T_e8_AVMph3_ViewPattern__Pattern5_2:
    case T_e8_AVMph3_ViewPattern__Pattern6_1:
    case T_e8_AVMph3_ViewPattern__Pattern6_2:
    case T_e8_AVMph3_ViewPattern__Pattern6_3:
    case T_e8_AVMph3_ViewPattern__Pattern7_1:
    case T_e8_AVMph3_ViewPattern__Pattern7_2:
    case T_e8_AVMph3_ViewPattern__Pattern8_1:
    case T_e8_AVMph3_ViewPattern__Pattern8_2:
    case T_e8_AVMph3_ViewPattern__Pattern9_1:
    case T_e8_AVMph3_ViewPattern__Pattern9_2:
    case T_e8_AVMph3_ViewPattern__Pattern10_1:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVMph3_CautionId_Parse (const char *str, size_t length, T_e8_AVMph3_CautionId &value)
{
    static stringEntry entries[] = {
        {4,"NONE", 0U},
        {15,"CAUTIONPATTERN1", 1U},
        {15,"CAUTIONPATTERN2", 2U},
        {15,"CAUTIONPATTERN3", 3U},
        {15,"CAUTIONPATTERN4", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_AVMph3_CautionId_Name (T_e8_AVMph3_CautionId value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "CautionPattern1",
        "CautionPattern2",
        "CautionPattern3",
        "CautionPattern4",
    };

    if (T_e8_AVMph3_CautionId_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AVMph3_CautionId_IsValid (T_e8_AVMph3_CautionId value)
{
    switch (value) {
    case T_e8_AVMph3_CautionId__None:
    case T_e8_AVMph3_CautionId__CautionPattern1:
    case T_e8_AVMph3_CautionId__CautionPattern2:
    case T_e8_AVMph3_CautionId__CautionPattern3:
    case T_e8_AVMph3_CautionId__CautionPattern4:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVMph3_IconId_Parse (const char *str, size_t length, T_e8_AVMph3_IconId &value)
{
    static stringEntry entries[] = {
        {4,"NONE", 0U},
        {12,"REARVIEWICON", 1U},
        {13,"FRONTVIEWICON", 2U},
        {16,"REARWIDEVIEWICON", 3U},
        {17,"FRONTWIDEVIEWICON", 4U},
        {19,"FRONTCORNERVIEWICON", 5U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_AVMph3_IconId_Name (T_e8_AVMph3_IconId value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "RearViewIcon",
        "FrontViewIcon",
        "RearWideViewIcon",
        "FrontWideViewIcon",
        "FrontCornerViewIcon",
    };

    if (T_e8_AVMph3_IconId_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AVMph3_IconId_IsValid (T_e8_AVMph3_IconId value)
{
    switch (value) {
    case T_e8_AVMph3_IconId__None:
    case T_e8_AVMph3_IconId__RearViewIcon:
    case T_e8_AVMph3_IconId__FrontViewIcon:
    case T_e8_AVMph3_IconId__RearWideViewIcon:
    case T_e8_AVMph3_IconId__FrontWideViewIcon:
    case T_e8_AVMph3_IconId__FrontCornerViewIcon:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVMph3_BuzzerStatus_Parse (const char *str, size_t length, T_e8_AVMph3_BuzzerStatus &value)
{
    static stringEntry entries[] = {
        {9,"BUZZER_ON", 1U},
        {10,"BUZZER_OFF", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_AVMph3_BuzzerStatus_Name (T_e8_AVMph3_BuzzerStatus value)
{
    static const char* enumerationLiterals[] = {
        "Buzzer_OFF",
        "Buzzer_ON",
    };

    if (T_e8_AVMph3_BuzzerStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AVMph3_BuzzerStatus_IsValid (T_e8_AVMph3_BuzzerStatus value)
{
    switch (value) {
    case T_e8_AVMph3_BuzzerStatus__Buzzer_OFF:
    case T_e8_AVMph3_BuzzerStatus__Buzzer_ON:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVMph3_ErrorMessage_Parse (const char *str, size_t length, T_e8_AVMph3_ErrorMessage &value)
{
    static stringEntry entries[] = {
        {4,"NONE", 0U},
        {8,"ONLYBEEP", 1U},
        {19,"REMOVESONAROFFPOPUP", 3U},
        {25,"SONAROFFPOPUPANDERRORBEEP", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_AVMph3_ErrorMessage_Name (T_e8_AVMph3_ErrorMessage value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "OnlyBeep",
        "SonarOffPopupAndErrorBeep",
        "RemoveSonarOffPopup",
    };

    if (T_e8_AVMph3_ErrorMessage_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AVMph3_ErrorMessage_IsValid (T_e8_AVMph3_ErrorMessage value)
{
    switch (value) {
    case T_e8_AVMph3_ErrorMessage__None:
    case T_e8_AVMph3_ErrorMessage__OnlyBeep:
    case T_e8_AVMph3_ErrorMessage__SonarOffPopupAndErrorBeep:
    case T_e8_AVMph3_ErrorMessage__RemoveSonarOffPopup:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVMph3_SettingItemId_Parse (const char *str, size_t length, T_e8_AVMph3_SettingItemId &value)
{
    static stringEntry entries[] = {
        {9,"VIEW_LINE", 1U},
        {12,"BCP_FUNCTION", 16U},
        {12,"MOD_FUNCTION", 14U},
        {12,"SONAR_BUZZER", 9U},
        {12,"SONAR_ON_OFF", 11U},
        {12,"VOLUME_VOICE", 8U},
        {13,"MASK_EMPHASIS", 3U},
        {13,"MOD_INTERRUPT", 12U},
        {13,"MOD_NIGHT_USE", 15U},
        {13,"PRIORITY_VIEW", 2U},
        {13,"PRIORITY_WIDE", 6U},
        {13,"VEHICLE_SPEED", 0U},
        {14,"ADJUST_TOPVIEW", 5U},
        {14,"REAR_WIDE_VIEW", 10U},
        {15,"SIDE_SONAR_DISP", 4U},
        {15,"SONAR_INTERRUPT", 13U},
        {16,"FRONT_SONAR_ONLY", 17U},
        {17,"AUTO_CAM_POSITION", 7U},
        {18,"BUZZER_SOUND_LEVEL", 19U},
        {23,"SONAR_SENSITIVITY_LEVEL", 20U},
        {24,"CORNER_SONAR_SENSITIVITY", 18U},
    };

    return lookupInStringEntryTable (str, length, entries, 21, (unsigned int&) value);
}

const char* T_e8_AVMph3_SettingItemId_Name (T_e8_AVMph3_SettingItemId value)
{
    static const char* enumerationLiterals[] = {
        "Vehicle_Speed",
        "View_Line",
        "Priority_View",
        "Mask_Emphasis",
        "Side_Sonar_Disp",
        "Adjust_Topview",
        "Priority_Wide",
        "Auto_Cam_Position",
        "Volume_Voice",
        "Sonar_Buzzer",
        "Rear_Wide_View",
        "Sonar_ON_OFF",
        "MOD_Interrupt",
        "Sonar_Interrupt",
        "MOD_Function",
        "MOD_Night_Use",
        "BCP_Function",
        "Front_Sonar_Only",
        "Corner_Sonar_Sensitivity",
        "Buzzer_Sound_Level",
        "Sonar_Sensitivity_Level",
    };

    if (T_e8_AVMph3_SettingItemId_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AVMph3_SettingItemId_IsValid (T_e8_AVMph3_SettingItemId value)
{
    switch (value) {
    case T_e8_AVMph3_SettingItemId__Vehicle_Speed:
    case T_e8_AVMph3_SettingItemId__View_Line:
    case T_e8_AVMph3_SettingItemId__Priority_View:
    case T_e8_AVMph3_SettingItemId__Mask_Emphasis:
    case T_e8_AVMph3_SettingItemId__Side_Sonar_Disp:
    case T_e8_AVMph3_SettingItemId__Adjust_Topview:
    case T_e8_AVMph3_SettingItemId__Priority_Wide:
    case T_e8_AVMph3_SettingItemId__Auto_Cam_Position:
    case T_e8_AVMph3_SettingItemId__Volume_Voice:
    case T_e8_AVMph3_SettingItemId__Sonar_Buzzer:
    case T_e8_AVMph3_SettingItemId__Rear_Wide_View:
    case T_e8_AVMph3_SettingItemId__Sonar_ON_OFF:
    case T_e8_AVMph3_SettingItemId__MOD_Interrupt:
    case T_e8_AVMph3_SettingItemId__Sonar_Interrupt:
    case T_e8_AVMph3_SettingItemId__MOD_Function:
    case T_e8_AVMph3_SettingItemId__MOD_Night_Use:
    case T_e8_AVMph3_SettingItemId__BCP_Function:
    case T_e8_AVMph3_SettingItemId__Front_Sonar_Only:
    case T_e8_AVMph3_SettingItemId__Corner_Sonar_Sensitivity:
    case T_e8_AVMph3_SettingItemId__Buzzer_Sound_Level:
    case T_e8_AVMph3_SettingItemId__Sonar_Sensitivity_Level:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVMph3_SettingOptionState_Parse (const char *str, size_t length, T_e8_AVMph3_SettingOptionState &value)
{
    static stringEntry entries[] = {
        {2,"ON", 2U},
        {3,"OFF", 1U},
        {7,"UNAVAIL", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_AVMph3_SettingOptionState_Name (T_e8_AVMph3_SettingOptionState value)
{
    static const char* enumerationLiterals[] = {
        "Unavail",
        "Off",
        "On",
    };

    if (T_e8_AVMph3_SettingOptionState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AVMph3_SettingOptionState_IsValid (T_e8_AVMph3_SettingOptionState value)
{
    switch (value) {
    case T_e8_AVMph3_SettingOptionState__Unavail:
    case T_e8_AVMph3_SettingOptionState__Off:
    case T_e8_AVMph3_SettingOptionState__On:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVMph3_Setting_PrioView_Parse (const char *str, size_t length, T_e8_AVMph3_Setting_PrioView &value)
{
    static stringEntry entries[] = {
        {7,"UNAVAIL", 0U},
        {8,"SIDEVIEW", 2U},
        {12,"OVERHEADVIEW", 1U},
        {20,"DISPLAYSETTINGSWITCH", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_AVMph3_Setting_PrioView_Name (T_e8_AVMph3_Setting_PrioView value)
{
    static const char* enumerationLiterals[] = {
        "Unavail",
        "OverheadView",
        "SideView",
        "DisplaySettingSwitch",
    };

    if (T_e8_AVMph3_Setting_PrioView_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AVMph3_Setting_PrioView_IsValid (T_e8_AVMph3_Setting_PrioView value)
{
    switch (value) {
    case T_e8_AVMph3_Setting_PrioView__Unavail:
    case T_e8_AVMph3_Setting_PrioView__OverheadView:
    case T_e8_AVMph3_Setting_PrioView__SideView:
    case T_e8_AVMph3_Setting_PrioView__DisplaySettingSwitch:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVMph3_Setting_PrioWide_Parse (const char *str, size_t length, T_e8_AVMph3_Setting_PrioWide &value)
{
    static stringEntry entries[] = {
        {7,"UNAVAIL", 0U},
        {8,"WIDEVIEW", 1U},
        {10,"CORNERVIEW", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_AVMph3_Setting_PrioWide_Name (T_e8_AVMph3_Setting_PrioWide value)
{
    static const char* enumerationLiterals[] = {
        "Unavail",
        "WideView",
        "CornerView",
    };

    if (T_e8_AVMph3_Setting_PrioWide_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AVMph3_Setting_PrioWide_IsValid (T_e8_AVMph3_Setting_PrioWide value)
{
    switch (value) {
    case T_e8_AVMph3_Setting_PrioWide__Unavail:
    case T_e8_AVMph3_Setting_PrioWide__WideView:
    case T_e8_AVMph3_Setting_PrioWide__CornerView:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVMph3_Setting_AutoCamPos_Parse (const char *str, size_t length, T_e8_AVMph3_Setting_AutoCamPos &value)
{
    static stringEntry entries[] = {
        {7,"UNAVAIL", 0U},
        {13,"DISPLAYSWITCH", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_AVMph3_Setting_AutoCamPos_Name (T_e8_AVMph3_Setting_AutoCamPos value)
{
    static const char* enumerationLiterals[] = {
        "Unavail",
        "DisplaySwitch",
    };

    if (T_e8_AVMph3_Setting_AutoCamPos_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AVMph3_Setting_AutoCamPos_IsValid (T_e8_AVMph3_Setting_AutoCamPos value)
{
    switch (value) {
    case T_e8_AVMph3_Setting_AutoCamPos__Unavail:
    case T_e8_AVMph3_Setting_AutoCamPos__DisplaySwitch:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVMph3_CornerSonarSensLvl_Parse (const char *str, size_t length, T_e8_AVMph3_CornerSonarSensLvl &value)
{
    static stringEntry entries[] = {
        {6,"LEVEL1", 0U},
        {6,"LEVEL2", 1U},
        {6,"LEVEL3", 2U},
        {6,"LEVEL4", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_AVMph3_CornerSonarSensLvl_Name (T_e8_AVMph3_CornerSonarSensLvl value)
{
    static const char* enumerationLiterals[] = {
        "Level1",
        "Level2",
        "Level3",
        "Level4",
    };

    if (T_e8_AVMph3_CornerSonarSensLvl_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AVMph3_CornerSonarSensLvl_IsValid (T_e8_AVMph3_CornerSonarSensLvl value)
{
    switch (value) {
    case T_e8_AVMph3_CornerSonarSensLvl__Level1:
    case T_e8_AVMph3_CornerSonarSensLvl__Level2:
    case T_e8_AVMph3_CornerSonarSensLvl__Level3:
    case T_e8_AVMph3_CornerSonarSensLvl__Level4:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVMph3_SonarSensLvl_Parse (const char *str, size_t length, T_e8_AVMph3_SonarSensLvl &value)
{
    static stringEntry entries[] = {
        {3,"FAR", 1U},
        {4,"NEAR", 3U},
        {6,"MIDDLE", 2U},
        {9,"UNDEFINED", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_AVMph3_SonarSensLvl_Name (T_e8_AVMph3_SonarSensLvl value)
{
    static const char* enumerationLiterals[] = {
        "Undefined",
        "Far",
        "Middle",
        "Near",
    };

    if (T_e8_AVMph3_SonarSensLvl_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AVMph3_SonarSensLvl_IsValid (T_e8_AVMph3_SonarSensLvl value)
{
    switch (value) {
    case T_e8_AVMph3_SonarSensLvl__Undefined:
    case T_e8_AVMph3_SonarSensLvl__Far:
    case T_e8_AVMph3_SonarSensLvl__Middle:
    case T_e8_AVMph3_SonarSensLvl__Near:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVMph3_BuzzerSoundLvl_Parse (const char *str, size_t length, T_e8_AVMph3_BuzzerSoundLvl &value)
{
    static stringEntry entries[] = {
        {3,"LOW", 3U},
        {4,"HIGH", 1U},
        {6,"MIDDLE", 2U},
        {9,"UNDEFINED", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_AVMph3_BuzzerSoundLvl_Name (T_e8_AVMph3_BuzzerSoundLvl value)
{
    static const char* enumerationLiterals[] = {
        "Undefined",
        "High",
        "Middle",
        "Low",
    };

    if (T_e8_AVMph3_BuzzerSoundLvl_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AVMph3_BuzzerSoundLvl_IsValid (T_e8_AVMph3_BuzzerSoundLvl value)
{
    switch (value) {
    case T_e8_AVMph3_BuzzerSoundLvl__Undefined:
    case T_e8_AVMph3_BuzzerSoundLvl__High:
    case T_e8_AVMph3_BuzzerSoundLvl__Middle:
    case T_e8_AVMph3_BuzzerSoundLvl__Low:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVMph3_RequestType_Parse (const char *str, size_t length, T_e8_AVMph3_RequestType &value)
{
    static stringEntry entries[] = {
        {3,"GET", 0U},
        {3,"SET", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_AVMph3_RequestType_Name (T_e8_AVMph3_RequestType value)
{
    static const char* enumerationLiterals[] = {
        "Get",
        "Set",
    };

    if (T_e8_AVMph3_RequestType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AVMph3_RequestType_IsValid (T_e8_AVMph3_RequestType value)
{
    switch (value) {
    case T_e8_AVMph3_RequestType__Get:
    case T_e8_AVMph3_RequestType__Set:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVMph3_VersionInfoType_Parse (const char *str, size_t length, T_e8_AVMph3_VersionInfoType &value)
{
    static stringEntry entries[] = {
        {7,"UNKNOWN", 0U},
        {10,"HW_VERSION", 1U},
        {10,"SW_VERSION", 2U},
        {13,"HW_SW_VERSION", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_AVMph3_VersionInfoType_Name (T_e8_AVMph3_VersionInfoType value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "HW_Version",
        "SW_Version",
        "HW_SW_Version",
    };

    if (T_e8_AVMph3_VersionInfoType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AVMph3_VersionInfoType_IsValid (T_e8_AVMph3_VersionInfoType value)
{
    switch (value) {
    case T_e8_AVMph3_VersionInfoType__Unknown:
    case T_e8_AVMph3_VersionInfoType__HW_Version:
    case T_e8_AVMph3_VersionInfoType__SW_Version:
    case T_e8_AVMph3_VersionInfoType__HW_SW_Version:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVMph3_ConfigurationStatus_Parse (const char *str, size_t length, T_e8_AVMph3_ConfigurationStatus &value)
{
    static stringEntry entries[] = {
        {5,"VALID", 1U},
        {7,"INVALID", 2U},
        {9,"UNDEFINED", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_AVMph3_ConfigurationStatus_Name (T_e8_AVMph3_ConfigurationStatus value)
{
    static const char* enumerationLiterals[] = {
        "Undefined",
        "Valid",
        "Invalid",
    };

    if (T_e8_AVMph3_ConfigurationStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AVMph3_ConfigurationStatus_IsValid (T_e8_AVMph3_ConfigurationStatus value)
{
    switch (value) {
    case T_e8_AVMph3_ConfigurationStatus__Undefined:
    case T_e8_AVMph3_ConfigurationStatus__Valid:
    case T_e8_AVMph3_ConfigurationStatus__Invalid:
        return true;
    default:
        return false;
    }
}

bool T_e8_AVMph3_Variant_Parse (const char *str, size_t length, T_e8_AVMph3_Variant &value)
{
    static stringEntry entries[] = {
        {9,"VAR_06AVM", 0U},
        {9,"VAR_08AVM", 2U},
        {9,"VAR_11AVM", 1U},
        {16,"VAR_REARWIDEVIEW", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_AVMph3_Variant_Name (T_e8_AVMph3_Variant value)
{
    static const char* enumerationLiterals[] = {
        "Var_06AVM",
        "Var_11AVM",
        "Var_08AVM",
        "Var_RearWideView",
    };

    if (T_e8_AVMph3_Variant_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AVMph3_Variant_IsValid (T_e8_AVMph3_Variant value)
{
    switch (value) {
    case T_e8_AVMph3_Variant__Var_06AVM:
    case T_e8_AVMph3_Variant__Var_11AVM:
    case T_e8_AVMph3_Variant__Var_08AVM:
    case T_e8_AVMph3_Variant__Var_RearWideView:
        return true;
    default:
        return false;
    }
}

} // namespace rvc_cca_fi_types
