#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef RVC_CCA_FI_TYPES_H
#define RVC_CCA_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "rvc_cca_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * Types rvc_cca_fi_types
 */

namespace rvc_cca_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_RVC_VideoAnalogLevels;

class T_IPA_Voice_Text_Strings;

class T_ParkAssist_UserConfiguration;

class T_GdlAdj_ConfigParameterData;

class T_FAP_Settings_State;

class T_AVM_Settings_State;

class T_GPS_Data;

class T_MapMatched_Data;

class T_Touch_Data;

class T_AVMph3_SwitchDescriptor;

class T_AVMph3_Setting_Item;

class T_AVMph3_Setting_Option;

class T_AVMph3_Setting_CornerSonarSensLvl;

class T_AVMph3_Setting_SonarSensLvl;

class T_AVMph3_Setting_BuzzerSoundLvl;

class T_AVMph3_VersionInfo;

class T_AVMph3_Unit_ID;

class T_AVMph3_MCAN_CommunicationErrors;


/**
 * Record type containing the video analog level settings.
 */
class T_RVC_VideoAnalogLevels {
public:

    /**
     * Default constructor
     */
    inline  T_RVC_VideoAnalogLevels ();

    /**
     * Copy constructor
     */
    inline  T_RVC_VideoAnalogLevels (const T_RVC_VideoAnalogLevels &rhs);

    /**
     * All fields constructor
     */
    inline  T_RVC_VideoAnalogLevels (T_e8_RVC_VideoParameterType e8Type_, T_e8_RVC_VideoParameterDimmingMode e8DimmingMode_, uint8 u8Value_);

    /**
     * Destructor
     */
    inline  ~T_RVC_VideoAnalogLevels();

    /**
     * Assignment operator
     */
    inline T_RVC_VideoAnalogLevels& operator = (const T_RVC_VideoAnalogLevels& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_RVC_VideoAnalogLevels& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_RVC_VideoAnalogLevels& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_RVC_VideoAnalogLevels& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_RVC_VideoAnalogLevels& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Type"

    static const int kE8Type = 0;

    /**
     * Clears the field "e8Type".
     *
     * The field will be set to its default value. The hasE8Type()
     * method will return false.
     */
    inline void clearE8Type();

    /**
     * Checks whether the field "e8Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Type()). Otherwise it will return false.
     */
    inline bool hasE8Type () const;

    /**
     * Returns the value of the member "e8Type".
     *
     * Type of the video analog level parameter.
     *
     * @return The value of the field "e8Type"
     */
    inline T_e8_RVC_VideoParameterType getE8Type () const;

    /**
     * Sets the value of the member "e8Type".
     *
     * Type of the video analog level parameter.
     *
     * @param e8Type The value which will be set
     */
    inline void setE8Type (T_e8_RVC_VideoParameterType e8Type_);

    // API of field "e8DimmingMode"

    static const int kE8DimmingMode = 1;

    /**
     * Clears the field "e8DimmingMode".
     *
     * The field will be set to its default value. The hasE8DimmingMode()
     * method will return false.
     */
    inline void clearE8DimmingMode();

    /**
     * Checks whether the field "e8DimmingMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DimmingMode()). Otherwise it will return false.
     */
    inline bool hasE8DimmingMode () const;

    /**
     * Returns the value of the member "e8DimmingMode".
     *
     * Indicates if the parameter value is for dimming day or night mode.
     *
     * @return The value of the field "e8DimmingMode"
     */
    inline T_e8_RVC_VideoParameterDimmingMode getE8DimmingMode () const;

    /**
     * Sets the value of the member "e8DimmingMode".
     *
     * Indicates if the parameter value is for dimming day or night mode.
     *
     * @param e8DimmingMode The value which will be set
     */
    inline void setE8DimmingMode (T_e8_RVC_VideoParameterDimmingMode e8DimmingMode_);

    // API of field "u8Value"

    static const int kU8Value = 2;

    /**
     * Clears the field "u8Value".
     *
     * The field will be set to its default value. The hasU8Value()
     * method will return false.
     */
    inline void clearU8Value();

    /**
     * Checks whether the field "u8Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Value()). Otherwise it will return false.
     */
    inline bool hasU8Value () const;

    /**
     * Returns the value of the member "u8Value".
     *
     * <p>To set the analog levels of the video signal.</p>
     * <p>Allowed range is 0..100 which means 0 to 100%.</p>
     * <p>In case the user setup allows a change in positive and negative direction,
     * 50% will be middle (neutral) position.</p>
     *
     * @return The value of the field "u8Value"
     */
    inline uint8 getU8Value () const;

    /**
     * Sets the value of the member "u8Value".
     *
     * <p>To set the analog levels of the video signal.</p>
     * <p>Allowed range is 0..100 which means 0 to 100%.</p>
     * <p>In case the user setup allows a change in positive and negative direction,
     * 50% will be middle (neutral) position.</p>
     *
     * @param u8Value The value which will be set
     */
    inline void setU8Value (uint8 u8Value_);

    static const T_RVC_VideoAnalogLevels &getDefaultInstance();

private:

    inline void set_has_e8Type ();

    inline void clear_has_e8Type ();

    inline void set_has_e8DimmingMode ();

    inline void clear_has_e8DimmingMode ();

    inline void set_has_u8Value ();

    inline void clear_has_u8Value ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_e8_RVC_VideoParameterType _e8Type;

    T_e8_RVC_VideoParameterDimmingMode _e8DimmingMode;

    uint8 _u8Value;

};

/**
 * Record type containing the GPS Data received from Navigation (through GPS).
 */
class T_IPA_Voice_Text_Strings {
public:

    /**
     * Default constructor
     */
    inline  T_IPA_Voice_Text_Strings ();

    /**
     * Copy constructor
     */
    inline  T_IPA_Voice_Text_Strings (const T_IPA_Voice_Text_Strings &rhs);

    /**
     * All fields constructor
     */
    inline  T_IPA_Voice_Text_Strings (T_e8_IPA_VoiceText e8RequestId_, const ::std::string& szText_);

    /**
     * Destructor
     */
    inline  ~T_IPA_Voice_Text_Strings();

    /**
     * Assignment operator
     */
    inline T_IPA_Voice_Text_Strings& operator = (const T_IPA_Voice_Text_Strings& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_IPA_Voice_Text_Strings& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_IPA_Voice_Text_Strings& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_IPA_Voice_Text_Strings& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_IPA_Voice_Text_Strings& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8RequestId"

    static const int kE8RequestId = 0;

    /**
     * Clears the field "e8RequestId".
     *
     * The field will be set to its default value. The hasE8RequestId()
     * method will return false.
     */
    inline void clearE8RequestId();

    /**
     * Checks whether the field "e8RequestId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8RequestId()). Otherwise it will return false.
     */
    inline bool hasE8RequestId () const;

    /**
     * Returns the value of the member "e8RequestId".
     *
     * Voice Request ID
     *
     * @return The value of the field "e8RequestId"
     */
    inline T_e8_IPA_VoiceText getE8RequestId () const;

    /**
     * Sets the value of the member "e8RequestId".
     *
     * Voice Request ID
     *
     * @param e8RequestId The value which will be set
     */
    inline void setE8RequestId (T_e8_IPA_VoiceText e8RequestId_);

    // API of field "szText"

    static const int kSzText = 1;

    /**
     * Clears the field "szText".
     *
     * The field will be set to its default value. The hasSzText()
     * method will return false.
     */
    inline void clearSzText();

    /**
     * Checks whether the field "szText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSzText()). Otherwise it will return false.
     */
    inline bool hasSzText () const;

    /**
     * Returns the value of the member "szText".
     *
     * The translated strings of the Voice requests
     *
     * @return The value of the field "szText"
     */
    inline const ::std::string& getSzText () const;

    /**
     * Retrieves the value of the field "szText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "szText".
     */
    inline ::std::string& getSzTextMutable ();

    /**
     * Sets the value of the member "szText".
     *
     * The translated strings of the Voice requests
     *
     * @param szText The value which will be set
     */
    inline void setSzText (const ::std::string& szText_);

    /**
     * Sets the value of the member "szText".
     *
     * The translated strings of the Voice requests
     *
     * @param szText The value which will be set
     */
    inline void setSzText (const char* szText_);

    /**
     * Sets the value of the member "szText".
     *
     * The translated strings of the Voice requests
     *
     * @param szText The value which will be set
     */
    inline void setSzText (const char* value, size_t size);

    static const T_IPA_Voice_Text_Strings &getDefaultInstance();

private:

    inline void set_has_e8RequestId ();

    inline void clear_has_e8RequestId ();

    inline void set_has_szText ();

    inline void clear_has_szText ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_IPA_VoiceText _e8RequestId;

    ::std::string _szText;

};

/**
 * Record type containing the user configuration(s).
 */
class T_ParkAssist_UserConfiguration {
public:

    /**
     * Default constructor
     */
    inline  T_ParkAssist_UserConfiguration ();

    /**
     * Copy constructor
     */
    inline  T_ParkAssist_UserConfiguration (const T_ParkAssist_UserConfiguration &rhs);

    /**
     * All fields constructor
     */
    inline  T_ParkAssist_UserConfiguration (T_e8_ParkAssist_UserConfigurationType e8Type_, T_e8_ParkAssist_UserConfigurationMode e8Mode_);

    /**
     * Destructor
     */
    inline  ~T_ParkAssist_UserConfiguration();

    /**
     * Assignment operator
     */
    inline T_ParkAssist_UserConfiguration& operator = (const T_ParkAssist_UserConfiguration& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ParkAssist_UserConfiguration& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ParkAssist_UserConfiguration& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ParkAssist_UserConfiguration& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ParkAssist_UserConfiguration& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Type"

    static const int kE8Type = 0;

    /**
     * Clears the field "e8Type".
     *
     * The field will be set to its default value. The hasE8Type()
     * method will return false.
     */
    inline void clearE8Type();

    /**
     * Checks whether the field "e8Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Type()). Otherwise it will return false.
     */
    inline bool hasE8Type () const;

    /**
     * Returns the value of the member "e8Type".
     *
     * Type of the user configuration.
     *
     * @return The value of the field "e8Type"
     */
    inline T_e8_ParkAssist_UserConfigurationType getE8Type () const;

    /**
     * Sets the value of the member "e8Type".
     *
     * Type of the user configuration.
     *
     * @param e8Type The value which will be set
     */
    inline void setE8Type (T_e8_ParkAssist_UserConfigurationType e8Type_);

    // API of field "e8Mode"

    static const int kE8Mode = 1;

    /**
     * Clears the field "e8Mode".
     *
     * The field will be set to its default value. The hasE8Mode()
     * method will return false.
     */
    inline void clearE8Mode();

    /**
     * Checks whether the field "e8Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Mode()). Otherwise it will return false.
     */
    inline bool hasE8Mode () const;

    /**
     * Returns the value of the member "e8Mode".
     *
     * Type of the user configuration.
     *
     * @return The value of the field "e8Mode"
     */
    inline T_e8_ParkAssist_UserConfigurationMode getE8Mode () const;

    /**
     * Sets the value of the member "e8Mode".
     *
     * Type of the user configuration.
     *
     * @param e8Mode The value which will be set
     */
    inline void setE8Mode (T_e8_ParkAssist_UserConfigurationMode e8Mode_);

    static const T_ParkAssist_UserConfiguration &getDefaultInstance();

private:

    inline void set_has_e8Type ();

    inline void clear_has_e8Type ();

    inline void set_has_e8Mode ();

    inline void clear_has_e8Mode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_ParkAssist_UserConfigurationType _e8Type;

    T_e8_ParkAssist_UserConfigurationMode _e8Mode;

};

/**
 * .
 */
class T_GdlAdj_ConfigParameterData {
public:

    /**
     * Default constructor
     */
    inline  T_GdlAdj_ConfigParameterData ();

    /**
     * Copy constructor
     */
    inline  T_GdlAdj_ConfigParameterData (const T_GdlAdj_ConfigParameterData &rhs);

    /**
     * All fields constructor
     */
    inline  T_GdlAdj_ConfigParameterData (T_e8_GdlAdj_ConfigurationItem e8Item_, double f64Value_);

    /**
     * Destructor
     */
    inline  ~T_GdlAdj_ConfigParameterData();

    /**
     * Assignment operator
     */
    inline T_GdlAdj_ConfigParameterData& operator = (const T_GdlAdj_ConfigParameterData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_GdlAdj_ConfigParameterData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_GdlAdj_ConfigParameterData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_GdlAdj_ConfigParameterData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_GdlAdj_ConfigParameterData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Item"

    static const int kE8Item = 0;

    /**
     * Clears the field "e8Item".
     *
     * The field will be set to its default value. The hasE8Item()
     * method will return false.
     */
    inline void clearE8Item();

    /**
     * Checks whether the field "e8Item" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Item()). Otherwise it will return false.
     */
    inline bool hasE8Item () const;

    /**
     * Returns the value of the member "e8Item".
     *
     *
     *
     * @return The value of the field "e8Item"
     */
    inline T_e8_GdlAdj_ConfigurationItem getE8Item () const;

    /**
     * Sets the value of the member "e8Item".
     *
     *
     *
     * @param e8Item The value which will be set
     */
    inline void setE8Item (T_e8_GdlAdj_ConfigurationItem e8Item_);

    // API of field "f64Value"

    static const int kF64Value = 1;

    /**
     * Clears the field "f64Value".
     *
     * The field will be set to its default value. The hasF64Value()
     * method will return false.
     */
    inline void clearF64Value();

    /**
     * Checks whether the field "f64Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setF64Value()). Otherwise it will return false.
     */
    inline bool hasF64Value () const;

    /**
     * Returns the value of the member "f64Value".
     *
     *
     *
     * @return The value of the field "f64Value"
     */
    inline double getF64Value () const;

    /**
     * Sets the value of the member "f64Value".
     *
     *
     *
     * @param f64Value The value which will be set
     */
    inline void setF64Value (double f64Value_);

    static const T_GdlAdj_ConfigParameterData &getDefaultInstance();

private:

    inline void set_has_e8Item ();

    inline void clear_has_e8Item ();

    inline void set_has_f64Value ();

    inline void clear_has_f64Value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_GdlAdj_ConfigurationItem _e8Item;

    double _f64Value;

};

/**
 * Record type containing the video analog level settings.
 */
class T_FAP_Settings_State {
public:

    /**
     * Default constructor
     */
    inline  T_FAP_Settings_State ();

    /**
     * Copy constructor
     */
    inline  T_FAP_Settings_State (const T_FAP_Settings_State &rhs);

    /**
     * All fields constructor
     */
    inline  T_FAP_Settings_State (T_e8_FAP_SettingItem e8Type_, T_e8_AVM_FAP_SettingState e8State_);

    /**
     * Destructor
     */
    inline  ~T_FAP_Settings_State();

    /**
     * Assignment operator
     */
    inline T_FAP_Settings_State& operator = (const T_FAP_Settings_State& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_FAP_Settings_State& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_FAP_Settings_State& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_FAP_Settings_State& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_FAP_Settings_State& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Type"

    static const int kE8Type = 0;

    /**
     * Clears the field "e8Type".
     *
     * The field will be set to its default value. The hasE8Type()
     * method will return false.
     */
    inline void clearE8Type();

    /**
     * Checks whether the field "e8Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Type()). Otherwise it will return false.
     */
    inline bool hasE8Type () const;

    /**
     * Returns the value of the member "e8Type".
     *
     * Type of the video analog level parameter.
     *
     * @return The value of the field "e8Type"
     */
    inline T_e8_FAP_SettingItem getE8Type () const;

    /**
     * Sets the value of the member "e8Type".
     *
     * Type of the video analog level parameter.
     *
     * @param e8Type The value which will be set
     */
    inline void setE8Type (T_e8_FAP_SettingItem e8Type_);

    // API of field "e8State"

    static const int kE8State = 1;

    /**
     * Clears the field "e8State".
     *
     * The field will be set to its default value. The hasE8State()
     * method will return false.
     */
    inline void clearE8State();

    /**
     * Checks whether the field "e8State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8State()). Otherwise it will return false.
     */
    inline bool hasE8State () const;

    /**
     * Returns the value of the member "e8State".
     *
     * Current State of the FAP Setting
     *
     * @return The value of the field "e8State"
     */
    inline T_e8_AVM_FAP_SettingState getE8State () const;

    /**
     * Sets the value of the member "e8State".
     *
     * Current State of the FAP Setting
     *
     * @param e8State The value which will be set
     */
    inline void setE8State (T_e8_AVM_FAP_SettingState e8State_);

    static const T_FAP_Settings_State &getDefaultInstance();

private:

    inline void set_has_e8Type ();

    inline void clear_has_e8Type ();

    inline void set_has_e8State ();

    inline void clear_has_e8State ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_FAP_SettingItem _e8Type;

    T_e8_AVM_FAP_SettingState _e8State;

};

/**
 * Record type containing the video analog level settings.
 */
class T_AVM_Settings_State {
public:

    /**
     * Default constructor
     */
    inline  T_AVM_Settings_State ();

    /**
     * Copy constructor
     */
    inline  T_AVM_Settings_State (const T_AVM_Settings_State &rhs);

    /**
     * All fields constructor
     */
    inline  T_AVM_Settings_State (T_e8_AVM_SettingItem e8Type_, T_e8_AVM_FAP_SettingState e8State_);

    /**
     * Destructor
     */
    inline  ~T_AVM_Settings_State();

    /**
     * Assignment operator
     */
    inline T_AVM_Settings_State& operator = (const T_AVM_Settings_State& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AVM_Settings_State& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AVM_Settings_State& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AVM_Settings_State& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AVM_Settings_State& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Type"

    static const int kE8Type = 0;

    /**
     * Clears the field "e8Type".
     *
     * The field will be set to its default value. The hasE8Type()
     * method will return false.
     */
    inline void clearE8Type();

    /**
     * Checks whether the field "e8Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Type()). Otherwise it will return false.
     */
    inline bool hasE8Type () const;

    /**
     * Returns the value of the member "e8Type".
     *
     * Type of the video analog level parameter.
     *
     * @return The value of the field "e8Type"
     */
    inline T_e8_AVM_SettingItem getE8Type () const;

    /**
     * Sets the value of the member "e8Type".
     *
     * Type of the video analog level parameter.
     *
     * @param e8Type The value which will be set
     */
    inline void setE8Type (T_e8_AVM_SettingItem e8Type_);

    // API of field "e8State"

    static const int kE8State = 1;

    /**
     * Clears the field "e8State".
     *
     * The field will be set to its default value. The hasE8State()
     * method will return false.
     */
    inline void clearE8State();

    /**
     * Checks whether the field "e8State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8State()). Otherwise it will return false.
     */
    inline bool hasE8State () const;

    /**
     * Returns the value of the member "e8State".
     *
     * Current State of the AVM Setting
     *
     * @return The value of the field "e8State"
     */
    inline T_e8_AVM_FAP_SettingState getE8State () const;

    /**
     * Sets the value of the member "e8State".
     *
     * Current State of the AVM Setting
     *
     * @param e8State The value which will be set
     */
    inline void setE8State (T_e8_AVM_FAP_SettingState e8State_);

    static const T_AVM_Settings_State &getDefaultInstance();

private:

    inline void set_has_e8Type ();

    inline void clear_has_e8Type ();

    inline void set_has_e8State ();

    inline void clear_has_e8State ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_AVM_SettingItem _e8Type;

    T_e8_AVM_FAP_SettingState _e8State;

};

/**
 * Record type containing the GPS Data received from Navigation (through GPS).
 */
class T_GPS_Data {
public:

    /**
     * Default constructor
     */
    inline  T_GPS_Data ();

    /**
     * Copy constructor
     */
    inline  T_GPS_Data (const T_GPS_Data &rhs);

    /**
     * All fields constructor
     */
    inline  T_GPS_Data (float GPS_latitude_, float GPS_longitude_, float GPS_altitude_, float GPS_azimuth_, float HDOP_, float VDOP_, uint32 numOfSatellites_, uint32 groundSpeed_);

    /**
     * Destructor
     */
    inline  ~T_GPS_Data();

    /**
     * Assignment operator
     */
    inline T_GPS_Data& operator = (const T_GPS_Data& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_GPS_Data& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_GPS_Data& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_GPS_Data& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_GPS_Data& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GPS_latitude"

    static const int kGPS_latitude = 0;

    /**
     * Clears the field "GPS_latitude".
     *
     * The field will be set to its default value. The hasGPS_latitude()
     * method will return false.
     */
    inline void clearGPS_latitude();

    /**
     * Checks whether the field "GPS_latitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGPS_latitude()). Otherwise it will return false.
     */
    inline bool hasGPS_latitude () const;

    /**
     * Returns the value of the member "GPS_latitude".
     *
     * GPS Latitude
     *
     * @return The value of the field "GPS_latitude"
     */
    inline float getGPS_latitude () const;

    /**
     * Sets the value of the member "GPS_latitude".
     *
     * GPS Latitude
     *
     * @param GPS_latitude The value which will be set
     */
    inline void setGPS_latitude (float GPS_latitude_);

    // API of field "GPS_longitude"

    static const int kGPS_longitude = 1;

    /**
     * Clears the field "GPS_longitude".
     *
     * The field will be set to its default value. The hasGPS_longitude()
     * method will return false.
     */
    inline void clearGPS_longitude();

    /**
     * Checks whether the field "GPS_longitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGPS_longitude()). Otherwise it will return false.
     */
    inline bool hasGPS_longitude () const;

    /**
     * Returns the value of the member "GPS_longitude".
     *
     * GPS Longitude
     *
     * @return The value of the field "GPS_longitude"
     */
    inline float getGPS_longitude () const;

    /**
     * Sets the value of the member "GPS_longitude".
     *
     * GPS Longitude
     *
     * @param GPS_longitude The value which will be set
     */
    inline void setGPS_longitude (float GPS_longitude_);

    // API of field "GPS_altitude"

    static const int kGPS_altitude = 2;

    /**
     * Clears the field "GPS_altitude".
     *
     * The field will be set to its default value. The hasGPS_altitude()
     * method will return false.
     */
    inline void clearGPS_altitude();

    /**
     * Checks whether the field "GPS_altitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGPS_altitude()). Otherwise it will return false.
     */
    inline bool hasGPS_altitude () const;

    /**
     * Returns the value of the member "GPS_altitude".
     *
     * GPS Altitude
     *
     * @return The value of the field "GPS_altitude"
     */
    inline float getGPS_altitude () const;

    /**
     * Sets the value of the member "GPS_altitude".
     *
     * GPS Altitude
     *
     * @param GPS_altitude The value which will be set
     */
    inline void setGPS_altitude (float GPS_altitude_);

    // API of field "GPS_azimuth"

    static const int kGPS_azimuth = 3;

    /**
     * Clears the field "GPS_azimuth".
     *
     * The field will be set to its default value. The hasGPS_azimuth()
     * method will return false.
     */
    inline void clearGPS_azimuth();

    /**
     * Checks whether the field "GPS_azimuth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGPS_azimuth()). Otherwise it will return false.
     */
    inline bool hasGPS_azimuth () const;

    /**
     * Returns the value of the member "GPS_azimuth".
     *
     * GPS azimuth
     *
     * @return The value of the field "GPS_azimuth"
     */
    inline float getGPS_azimuth () const;

    /**
     * Sets the value of the member "GPS_azimuth".
     *
     * GPS azimuth
     *
     * @param GPS_azimuth The value which will be set
     */
    inline void setGPS_azimuth (float GPS_azimuth_);

    // API of field "HDOP"

    static const int kHDOP = 4;

    /**
     * Clears the field "HDOP".
     *
     * The field will be set to its default value. The hasHDOP()
     * method will return false.
     */
    inline void clearHDOP();

    /**
     * Checks whether the field "HDOP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHDOP()). Otherwise it will return false.
     */
    inline bool hasHDOP () const;

    /**
     * Returns the value of the member "HDOP".
     *
     * Horizontal precision of Dilution
     *
     * @return The value of the field "HDOP"
     */
    inline float getHDOP () const;

    /**
     * Sets the value of the member "HDOP".
     *
     * Horizontal precision of Dilution
     *
     * @param HDOP The value which will be set
     */
    inline void setHDOP (float HDOP_);

    // API of field "VDOP"

    static const int kVDOP = 5;

    /**
     * Clears the field "VDOP".
     *
     * The field will be set to its default value. The hasVDOP()
     * method will return false.
     */
    inline void clearVDOP();

    /**
     * Checks whether the field "VDOP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVDOP()). Otherwise it will return false.
     */
    inline bool hasVDOP () const;

    /**
     * Returns the value of the member "VDOP".
     *
     * Vertical precision of Dilution
     *
     * @return The value of the field "VDOP"
     */
    inline float getVDOP () const;

    /**
     * Sets the value of the member "VDOP".
     *
     * Vertical precision of Dilution
     *
     * @param VDOP The value which will be set
     */
    inline void setVDOP (float VDOP_);

    // API of field "numOfSatellites"

    static const int kNumOfSatellites = 6;

    /**
     * Clears the field "numOfSatellites".
     *
     * The field will be set to its default value. The hasNumOfSatellites()
     * method will return false.
     */
    inline void clearNumOfSatellites();

    /**
     * Checks whether the field "numOfSatellites" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumOfSatellites()). Otherwise it will return false.
     */
    inline bool hasNumOfSatellites () const;

    /**
     * Returns the value of the member "numOfSatellites".
     *
     * Number of Satellites being used in order to calculate the position
     *
     * @return The value of the field "numOfSatellites"
     */
    inline uint32 getNumOfSatellites () const;

    /**
     * Sets the value of the member "numOfSatellites".
     *
     * Number of Satellites being used in order to calculate the position
     *
     * @param numOfSatellites The value which will be set
     */
    inline void setNumOfSatellites (uint32 numOfSatellites_);

    // API of field "groundSpeed"

    static const int kGroundSpeed = 7;

    /**
     * Clears the field "groundSpeed".
     *
     * The field will be set to its default value. The hasGroundSpeed()
     * method will return false.
     */
    inline void clearGroundSpeed();

    /**
     * Checks whether the field "groundSpeed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGroundSpeed()). Otherwise it will return false.
     */
    inline bool hasGroundSpeed () const;

    /**
     * Returns the value of the member "groundSpeed".
     *
     * Ground Speed as calculated from GPS data
     *
     * @return The value of the field "groundSpeed"
     */
    inline uint32 getGroundSpeed () const;

    /**
     * Sets the value of the member "groundSpeed".
     *
     * Ground Speed as calculated from GPS data
     *
     * @param groundSpeed The value which will be set
     */
    inline void setGroundSpeed (uint32 groundSpeed_);

    static const T_GPS_Data &getDefaultInstance();

private:

    inline void set_has_GPS_latitude ();

    inline void clear_has_GPS_latitude ();

    inline void set_has_GPS_longitude ();

    inline void clear_has_GPS_longitude ();

    inline void set_has_GPS_altitude ();

    inline void clear_has_GPS_altitude ();

    inline void set_has_GPS_azimuth ();

    inline void clear_has_GPS_azimuth ();

    inline void set_has_HDOP ();

    inline void clear_has_HDOP ();

    inline void set_has_VDOP ();

    inline void clear_has_VDOP ();

    inline void set_has_numOfSatellites ();

    inline void clear_has_numOfSatellites ();

    inline void set_has_groundSpeed ();

    inline void clear_has_groundSpeed ();

    uint32 _has_bits_[ (8 + 31) / 32];

    float _GPS_latitude;

    float _GPS_longitude;

    float _GPS_altitude;

    float _GPS_azimuth;

    float _HDOP;

    float _VDOP;

    uint32 _numOfSatellites;

    uint32 _groundSpeed;

};

/**
 * Record type containing the calculated Dead Reckoning Position from Navigation
 */
class T_MapMatched_Data {
public:

    /**
     * Default constructor
     */
    inline  T_MapMatched_Data ();

    /**
     * Copy constructor
     */
    inline  T_MapMatched_Data (const T_MapMatched_Data &rhs);

    /**
     * All fields constructor
     */
    inline  T_MapMatched_Data (float MM_latitude_, float MM_longitude_, float MM_azimuth_, float MM_accuracy_);

    /**
     * Destructor
     */
    inline  ~T_MapMatched_Data();

    /**
     * Assignment operator
     */
    inline T_MapMatched_Data& operator = (const T_MapMatched_Data& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MapMatched_Data& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MapMatched_Data& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MapMatched_Data& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MapMatched_Data& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MM_latitude"

    static const int kMM_latitude = 0;

    /**
     * Clears the field "MM_latitude".
     *
     * The field will be set to its default value. The hasMM_latitude()
     * method will return false.
     */
    inline void clearMM_latitude();

    /**
     * Checks whether the field "MM_latitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMM_latitude()). Otherwise it will return false.
     */
    inline bool hasMM_latitude () const;

    /**
     * Returns the value of the member "MM_latitude".
     *
     * Map Matched Latitude
     *
     * @return The value of the field "MM_latitude"
     */
    inline float getMM_latitude () const;

    /**
     * Sets the value of the member "MM_latitude".
     *
     * Map Matched Latitude
     *
     * @param MM_latitude The value which will be set
     */
    inline void setMM_latitude (float MM_latitude_);

    // API of field "MM_longitude"

    static const int kMM_longitude = 1;

    /**
     * Clears the field "MM_longitude".
     *
     * The field will be set to its default value. The hasMM_longitude()
     * method will return false.
     */
    inline void clearMM_longitude();

    /**
     * Checks whether the field "MM_longitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMM_longitude()). Otherwise it will return false.
     */
    inline bool hasMM_longitude () const;

    /**
     * Returns the value of the member "MM_longitude".
     *
     * Map Matched Longitude
     *
     * @return The value of the field "MM_longitude"
     */
    inline float getMM_longitude () const;

    /**
     * Sets the value of the member "MM_longitude".
     *
     * Map Matched Longitude
     *
     * @param MM_longitude The value which will be set
     */
    inline void setMM_longitude (float MM_longitude_);

    // API of field "MM_azimuth"

    static const int kMM_azimuth = 2;

    /**
     * Clears the field "MM_azimuth".
     *
     * The field will be set to its default value. The hasMM_azimuth()
     * method will return false.
     */
    inline void clearMM_azimuth();

    /**
     * Checks whether the field "MM_azimuth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMM_azimuth()). Otherwise it will return false.
     */
    inline bool hasMM_azimuth () const;

    /**
     * Returns the value of the member "MM_azimuth".
     *
     * Map Matched azimuth
     *
     * @return The value of the field "MM_azimuth"
     */
    inline float getMM_azimuth () const;

    /**
     * Sets the value of the member "MM_azimuth".
     *
     * Map Matched azimuth
     *
     * @param MM_azimuth The value which will be set
     */
    inline void setMM_azimuth (float MM_azimuth_);

    // API of field "MM_accuracy"

    static const int kMM_accuracy = 3;

    /**
     * Clears the field "MM_accuracy".
     *
     * The field will be set to its default value. The hasMM_accuracy()
     * method will return false.
     */
    inline void clearMM_accuracy();

    /**
     * Checks whether the field "MM_accuracy" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMM_accuracy()). Otherwise it will return false.
     */
    inline bool hasMM_accuracy () const;

    /**
     * Returns the value of the member "MM_accuracy".
     *
     * Map Matched accuracy defined by the distance of the GPS data and Map Matched data
     *
     * @return The value of the field "MM_accuracy"
     */
    inline float getMM_accuracy () const;

    /**
     * Sets the value of the member "MM_accuracy".
     *
     * Map Matched accuracy defined by the distance of the GPS data and Map Matched data
     *
     * @param MM_accuracy The value which will be set
     */
    inline void setMM_accuracy (float MM_accuracy_);

    static const T_MapMatched_Data &getDefaultInstance();

private:

    inline void set_has_MM_latitude ();

    inline void clear_has_MM_latitude ();

    inline void set_has_MM_longitude ();

    inline void clear_has_MM_longitude ();

    inline void set_has_MM_azimuth ();

    inline void clear_has_MM_azimuth ();

    inline void set_has_MM_accuracy ();

    inline void clear_has_MM_accuracy ();

    uint32 _has_bits_[ (4 + 31) / 32];

    float _MM_latitude;

    float _MM_longitude;

    float _MM_azimuth;

    float _MM_accuracy;

};

/**
 * Record type containing the touch event data detected by HMI
 */
class T_Touch_Data {
public:

    /**
     * Default constructor
     */
    inline  T_Touch_Data ();

    /**
     * Copy constructor
     */
    inline  T_Touch_Data (const T_Touch_Data &rhs);

    /**
     * All fields constructor
     */
    inline  T_Touch_Data (uint32 x_ordinate_, uint32 y_ordinate_, uint32 x1_ordinate_, uint32 y1_ordinate_, T_e8_TouchGesture e8Gesture_, T_e8_Direction e8Direction_, uint8 SpeedOfMovement_);

    /**
     * Destructor
     */
    inline  ~T_Touch_Data();

    /**
     * Assignment operator
     */
    inline T_Touch_Data& operator = (const T_Touch_Data& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Touch_Data& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Touch_Data& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Touch_Data& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Touch_Data& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "x_ordinate"

    static const int kX_ordinate = 0;

    /**
     * Clears the field "x_ordinate".
     *
     * The field will be set to its default value. The hasX_ordinate()
     * method will return false.
     */
    inline void clearX_ordinate();

    /**
     * Checks whether the field "x_ordinate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setX_ordinate()). Otherwise it will return false.
     */
    inline bool hasX_ordinate () const;

    /**
     * Returns the value of the member "x_ordinate".
     *
     * X-Ordinate of the touch detetced
     * 0 = if not detected
     *
     * @return The value of the field "x_ordinate"
     */
    inline uint32 getX_ordinate () const;

    /**
     * Sets the value of the member "x_ordinate".
     *
     * X-Ordinate of the touch detetced
     * 0 = if not detected
     *
     * @param x_ordinate The value which will be set
     */
    inline void setX_ordinate (uint32 x_ordinate_);

    // API of field "y_ordinate"

    static const int kY_ordinate = 1;

    /**
     * Clears the field "y_ordinate".
     *
     * The field will be set to its default value. The hasY_ordinate()
     * method will return false.
     */
    inline void clearY_ordinate();

    /**
     * Checks whether the field "y_ordinate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setY_ordinate()). Otherwise it will return false.
     */
    inline bool hasY_ordinate () const;

    /**
     * Returns the value of the member "y_ordinate".
     *
     * Y-Ordinate of the touch detetced
     * 0 = if not detected
     *
     * @return The value of the field "y_ordinate"
     */
    inline uint32 getY_ordinate () const;

    /**
     * Sets the value of the member "y_ordinate".
     *
     * Y-Ordinate of the touch detetced
     * 0 = if not detected
     *
     * @param y_ordinate The value which will be set
     */
    inline void setY_ordinate (uint32 y_ordinate_);

    // API of field "x1_ordinate"

    static const int kX1_ordinate = 2;

    /**
     * Clears the field "x1_ordinate".
     *
     * The field will be set to its default value. The hasX1_ordinate()
     * method will return false.
     */
    inline void clearX1_ordinate();

    /**
     * Checks whether the field "x1_ordinate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setX1_ordinate()). Otherwise it will return false.
     */
    inline bool hasX1_ordinate () const;

    /**
     * Returns the value of the member "x1_ordinate".
     *
     * 2nd X-Ordinate of the touch detetced together with the 1st touch
     * 0 = if not detected
     *
     * @return The value of the field "x1_ordinate"
     */
    inline uint32 getX1_ordinate () const;

    /**
     * Sets the value of the member "x1_ordinate".
     *
     * 2nd X-Ordinate of the touch detetced together with the 1st touch
     * 0 = if not detected
     *
     * @param x1_ordinate The value which will be set
     */
    inline void setX1_ordinate (uint32 x1_ordinate_);

    // API of field "y1_ordinate"

    static const int kY1_ordinate = 3;

    /**
     * Clears the field "y1_ordinate".
     *
     * The field will be set to its default value. The hasY1_ordinate()
     * method will return false.
     */
    inline void clearY1_ordinate();

    /**
     * Checks whether the field "y1_ordinate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setY1_ordinate()). Otherwise it will return false.
     */
    inline bool hasY1_ordinate () const;

    /**
     * Returns the value of the member "y1_ordinate".
     *
     * 2nd Y-Ordinate of the touch detetced together with the 1st touch
     * 0 = if not detected
     *
     * @return The value of the field "y1_ordinate"
     */
    inline uint32 getY1_ordinate () const;

    /**
     * Sets the value of the member "y1_ordinate".
     *
     * 2nd Y-Ordinate of the touch detetced together with the 1st touch
     * 0 = if not detected
     *
     * @param y1_ordinate The value which will be set
     */
    inline void setY1_ordinate (uint32 y1_ordinate_);

    // API of field "e8Gesture"

    static const int kE8Gesture = 4;

    /**
     * Clears the field "e8Gesture".
     *
     * The field will be set to its default value. The hasE8Gesture()
     * method will return false.
     */
    inline void clearE8Gesture();

    /**
     * Checks whether the field "e8Gesture" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Gesture()). Otherwise it will return false.
     */
    inline bool hasE8Gesture () const;

    /**
     * Returns the value of the member "e8Gesture".
     *
     * Indicates the Touch Gesture detected
     *
     * @return The value of the field "e8Gesture"
     */
    inline T_e8_TouchGesture getE8Gesture () const;

    /**
     * Sets the value of the member "e8Gesture".
     *
     * Indicates the Touch Gesture detected
     *
     * @param e8Gesture The value which will be set
     */
    inline void setE8Gesture (T_e8_TouchGesture e8Gesture_);

    // API of field "e8Direction"

    static const int kE8Direction = 5;

    /**
     * Clears the field "e8Direction".
     *
     * The field will be set to its default value. The hasE8Direction()
     * method will return false.
     */
    inline void clearE8Direction();

    /**
     * Checks whether the field "e8Direction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Direction()). Otherwise it will return false.
     */
    inline bool hasE8Direction () const;

    /**
     * Returns the value of the member "e8Direction".
     *
     * <p>Direction of the touch flick or drag detected</p>
     *
     * @return The value of the field "e8Direction"
     */
    inline T_e8_Direction getE8Direction () const;

    /**
     * Sets the value of the member "e8Direction".
     *
     * <p>Direction of the touch flick or drag detected</p>
     *
     * @param e8Direction The value which will be set
     */
    inline void setE8Direction (T_e8_Direction e8Direction_);

    // API of field "SpeedOfMovement"

    static const int kSpeedOfMovement = 6;

    /**
     * Clears the field "SpeedOfMovement".
     *
     * The field will be set to its default value. The hasSpeedOfMovement()
     * method will return false.
     */
    inline void clearSpeedOfMovement();

    /**
     * Checks whether the field "SpeedOfMovement" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeedOfMovement()). Otherwise it will return false.
     */
    inline bool hasSpeedOfMovement () const;

    /**
     * Returns the value of the member "SpeedOfMovement".
     *
     * <p>Speed of the touch points movement in dots / 100ms</p>
     *
     * @return The value of the field "SpeedOfMovement"
     */
    inline uint8 getSpeedOfMovement () const;

    /**
     * Sets the value of the member "SpeedOfMovement".
     *
     * <p>Speed of the touch points movement in dots / 100ms</p>
     *
     * @param SpeedOfMovement The value which will be set
     */
    inline void setSpeedOfMovement (uint8 SpeedOfMovement_);

    static const T_Touch_Data &getDefaultInstance();

private:

    inline void set_has_x_ordinate ();

    inline void clear_has_x_ordinate ();

    inline void set_has_y_ordinate ();

    inline void clear_has_y_ordinate ();

    inline void set_has_x1_ordinate ();

    inline void clear_has_x1_ordinate ();

    inline void set_has_y1_ordinate ();

    inline void clear_has_y1_ordinate ();

    inline void set_has_e8Gesture ();

    inline void clear_has_e8Gesture ();

    inline void set_has_e8Direction ();

    inline void clear_has_e8Direction ();

    inline void set_has_SpeedOfMovement ();

    inline void clear_has_SpeedOfMovement ();

    uint32 _has_bits_[ (7 + 31) / 32];

    uint32 _x_ordinate;

    uint32 _y_ordinate;

    uint32 _x1_ordinate;

    uint32 _y1_ordinate;

    T_e8_TouchGesture _e8Gesture;

    T_e8_Direction _e8Direction;

    uint8 _SpeedOfMovement;

};

/**
 * Structure type to bundle the ID of a (display/touch) switch and its display state
 */
class T_AVMph3_SwitchDescriptor {
public:

    /**
     * Default constructor
     */
    inline  T_AVMph3_SwitchDescriptor ();

    /**
     * Copy constructor
     */
    inline  T_AVMph3_SwitchDescriptor (const T_AVMph3_SwitchDescriptor &rhs);

    /**
     * All fields constructor
     */
    inline  T_AVMph3_SwitchDescriptor (T_e8_AVMph3_SwitchId Id_, T_e8_AVMph3_SwitchStatus Status_);

    /**
     * Destructor
     */
    inline  ~T_AVMph3_SwitchDescriptor();

    /**
     * Assignment operator
     */
    inline T_AVMph3_SwitchDescriptor& operator = (const T_AVMph3_SwitchDescriptor& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AVMph3_SwitchDescriptor& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AVMph3_SwitchDescriptor& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AVMph3_SwitchDescriptor& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AVMph3_SwitchDescriptor& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Id"

    static const int kId = 0;

    /**
     * Clears the field "Id".
     *
     * The field will be set to its default value. The hasId()
     * method will return false.
     */
    inline void clearId();

    /**
     * Checks whether the field "Id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setId()). Otherwise it will return false.
     */
    inline bool hasId () const;

    /**
     * Returns the value of the member "Id".
     *
     *
     *
     * @return The value of the field "Id"
     */
    inline T_e8_AVMph3_SwitchId getId () const;

    /**
     * Sets the value of the member "Id".
     *
     *
     *
     * @param Id The value which will be set
     */
    inline void setId (T_e8_AVMph3_SwitchId Id_);

    // API of field "Status"

    static const int kStatus = 1;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     *
     *
     * @return The value of the field "Status"
     */
    inline T_e8_AVMph3_SwitchStatus getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     *
     *
     * @param Status The value which will be set
     */
    inline void setStatus (T_e8_AVMph3_SwitchStatus Status_);

    static const T_AVMph3_SwitchDescriptor &getDefaultInstance();

private:

    inline void set_has_Id ();

    inline void clear_has_Id ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_AVMph3_SwitchId _Id;

    T_e8_AVMph3_SwitchStatus _Status;

};

/**
 * Generic type for AVM phase3 camera settings item states.
 */
class T_AVMph3_Setting_Item {
public:

    /**
     * Default constructor
     */
    inline  T_AVMph3_Setting_Item ();

    /**
     * Copy constructor
     */
    inline  T_AVMph3_Setting_Item (const T_AVMph3_Setting_Item &rhs);

    /**
     * All fields constructor
     */
    inline  T_AVMph3_Setting_Item (T_e8_AVMph3_SettingItemId e8ItemId_, uint8 u8ItemState_);

    /**
     * Destructor
     */
    inline  ~T_AVMph3_Setting_Item();

    /**
     * Assignment operator
     */
    inline T_AVMph3_Setting_Item& operator = (const T_AVMph3_Setting_Item& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AVMph3_Setting_Item& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AVMph3_Setting_Item& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AVMph3_Setting_Item& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AVMph3_Setting_Item& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ItemId"

    static const int kE8ItemId = 0;

    /**
     * Clears the field "e8ItemId".
     *
     * The field will be set to its default value. The hasE8ItemId()
     * method will return false.
     */
    inline void clearE8ItemId();

    /**
     * Checks whether the field "e8ItemId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ItemId()). Otherwise it will return false.
     */
    inline bool hasE8ItemId () const;

    /**
     * Returns the value of the member "e8ItemId".
     *
     * identifies the settings item
     *
     * @return The value of the field "e8ItemId"
     */
    inline T_e8_AVMph3_SettingItemId getE8ItemId () const;

    /**
     * Sets the value of the member "e8ItemId".
     *
     * identifies the settings item
     *
     * @param e8ItemId The value which will be set
     */
    inline void setE8ItemId (T_e8_AVMph3_SettingItemId e8ItemId_);

    // API of field "u8ItemState"

    static const int kU8ItemState = 1;

    /**
     * Clears the field "u8ItemState".
     *
     * The field will be set to its default value. The hasU8ItemState()
     * method will return false.
     */
    inline void clearU8ItemState();

    /**
     * Checks whether the field "u8ItemState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ItemState()). Otherwise it will return false.
     */
    inline bool hasU8ItemState () const;

    /**
     * Returns the value of the member "u8ItemState".
     *
     * the state of this settings item
     *
     * @return The value of the field "u8ItemState"
     */
    inline uint8 getU8ItemState () const;

    /**
     * Sets the value of the member "u8ItemState".
     *
     * the state of this settings item
     *
     * @param u8ItemState The value which will be set
     */
    inline void setU8ItemState (uint8 u8ItemState_);

    static const T_AVMph3_Setting_Item &getDefaultInstance();

private:

    inline void set_has_e8ItemId ();

    inline void clear_has_e8ItemId ();

    inline void set_has_u8ItemState ();

    inline void clear_has_u8ItemState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_AVMph3_SettingItemId _e8ItemId;

    uint8 _u8ItemState;

};

/**
 * Type for one AVM phase3 option type camera settings item.
 */
class T_AVMph3_Setting_Option {
public:

    /**
     * Default constructor
     */
    inline  T_AVMph3_Setting_Option ();

    /**
     * Copy constructor
     */
    inline  T_AVMph3_Setting_Option (const T_AVMph3_Setting_Option &rhs);

    /**
     * All fields constructor
     */
    inline  T_AVMph3_Setting_Option (T_e8_AVMph3_SettingItemId e8ItemId_, T_e8_AVMph3_SettingOptionState e8ItemState_);

    /**
     * Destructor
     */
    inline  ~T_AVMph3_Setting_Option();

    /**
     * Assignment operator
     */
    inline T_AVMph3_Setting_Option& operator = (const T_AVMph3_Setting_Option& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AVMph3_Setting_Option& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AVMph3_Setting_Option& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AVMph3_Setting_Option& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AVMph3_Setting_Option& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ItemId"

    static const int kE8ItemId = 0;

    /**
     * Clears the field "e8ItemId".
     *
     * The field will be set to its default value. The hasE8ItemId()
     * method will return false.
     */
    inline void clearE8ItemId();

    /**
     * Checks whether the field "e8ItemId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ItemId()). Otherwise it will return false.
     */
    inline bool hasE8ItemId () const;

    /**
     * Returns the value of the member "e8ItemId".
     *
     * identifies the option
     *
     * @return The value of the field "e8ItemId"
     */
    inline T_e8_AVMph3_SettingItemId getE8ItemId () const;

    /**
     * Sets the value of the member "e8ItemId".
     *
     * identifies the option
     *
     * @param e8ItemId The value which will be set
     */
    inline void setE8ItemId (T_e8_AVMph3_SettingItemId e8ItemId_);

    // API of field "e8ItemState"

    static const int kE8ItemState = 1;

    /**
     * Clears the field "e8ItemState".
     *
     * The field will be set to its default value. The hasE8ItemState()
     * method will return false.
     */
    inline void clearE8ItemState();

    /**
     * Checks whether the field "e8ItemState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ItemState()). Otherwise it will return false.
     */
    inline bool hasE8ItemState () const;

    /**
     * Returns the value of the member "e8ItemState".
     *
     * the state of this option
     *
     * @return The value of the field "e8ItemState"
     */
    inline T_e8_AVMph3_SettingOptionState getE8ItemState () const;

    /**
     * Sets the value of the member "e8ItemState".
     *
     * the state of this option
     *
     * @param e8ItemState The value which will be set
     */
    inline void setE8ItemState (T_e8_AVMph3_SettingOptionState e8ItemState_);

    static const T_AVMph3_Setting_Option &getDefaultInstance();

private:

    inline void set_has_e8ItemId ();

    inline void clear_has_e8ItemId ();

    inline void set_has_e8ItemState ();

    inline void clear_has_e8ItemState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_AVMph3_SettingItemId _e8ItemId;

    T_e8_AVMph3_SettingOptionState _e8ItemState;

};

/**
 * Specific type for the state of the camera settings item 'Corner_Sonar_Sensitivity'.
 */
class T_AVMph3_Setting_CornerSonarSensLvl {
public:

    /**
     * Default constructor
     */
    inline  T_AVMph3_Setting_CornerSonarSensLvl ();

    /**
     * Copy constructor
     */
    inline  T_AVMph3_Setting_CornerSonarSensLvl (const T_AVMph3_Setting_CornerSonarSensLvl &rhs);

    /**
     * All fields constructor
     */
    inline  T_AVMph3_Setting_CornerSonarSensLvl (bool bAvail_, T_e8_AVMph3_CornerSonarSensLvl e8Level_);

    /**
     * Destructor
     */
    inline  ~T_AVMph3_Setting_CornerSonarSensLvl();

    /**
     * Assignment operator
     */
    inline T_AVMph3_Setting_CornerSonarSensLvl& operator = (const T_AVMph3_Setting_CornerSonarSensLvl& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AVMph3_Setting_CornerSonarSensLvl& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AVMph3_Setting_CornerSonarSensLvl& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AVMph3_Setting_CornerSonarSensLvl& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AVMph3_Setting_CornerSonarSensLvl& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bAvail"

    static const int kBAvail = 0;

    /**
     * Clears the field "bAvail".
     *
     * The field will be set to its default value. The hasBAvail()
     * method will return false.
     */
    inline void clearBAvail();

    /**
     * Checks whether the field "bAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAvail()). Otherwise it will return false.
     */
    inline bool hasBAvail () const;

    /**
     * Returns the value of the member "bAvail".
     *
     * Availability of the settings item.
     *
     * @return The value of the field "bAvail"
     */
    inline bool getBAvail () const;

    /**
     * Sets the value of the member "bAvail".
     *
     * Availability of the settings item.
     *
     * @param bAvail The value which will be set
     */
    inline void setBAvail (bool bAvail_);

    // API of field "e8Level"

    static const int kE8Level = 1;

    /**
     * Clears the field "e8Level".
     *
     * The field will be set to its default value. The hasE8Level()
     * method will return false.
     */
    inline void clearE8Level();

    /**
     * Checks whether the field "e8Level" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Level()). Otherwise it will return false.
     */
    inline bool hasE8Level () const;

    /**
     * Returns the value of the member "e8Level".
     *
     * Settings value.
     *
     * @return The value of the field "e8Level"
     */
    inline T_e8_AVMph3_CornerSonarSensLvl getE8Level () const;

    /**
     * Sets the value of the member "e8Level".
     *
     * Settings value.
     *
     * @param e8Level The value which will be set
     */
    inline void setE8Level (T_e8_AVMph3_CornerSonarSensLvl e8Level_);

    static const T_AVMph3_Setting_CornerSonarSensLvl &getDefaultInstance();

private:

    inline void set_has_bAvail ();

    inline void clear_has_bAvail ();

    inline void set_has_e8Level ();

    inline void clear_has_e8Level ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bAvail;

    T_e8_AVMph3_CornerSonarSensLvl _e8Level;

};

/**
 * Specific type for the state of the camera settings item 'Sonar_Sensitivity_Level'.
 */
class T_AVMph3_Setting_SonarSensLvl {
public:

    /**
     * Default constructor
     */
    inline  T_AVMph3_Setting_SonarSensLvl ();

    /**
     * Copy constructor
     */
    inline  T_AVMph3_Setting_SonarSensLvl (const T_AVMph3_Setting_SonarSensLvl &rhs);

    /**
     * All fields constructor
     */
    inline  T_AVMph3_Setting_SonarSensLvl (bool bAvail_, T_e8_AVMph3_SonarSensLvl e8Level_);

    /**
     * Destructor
     */
    inline  ~T_AVMph3_Setting_SonarSensLvl();

    /**
     * Assignment operator
     */
    inline T_AVMph3_Setting_SonarSensLvl& operator = (const T_AVMph3_Setting_SonarSensLvl& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AVMph3_Setting_SonarSensLvl& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AVMph3_Setting_SonarSensLvl& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AVMph3_Setting_SonarSensLvl& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AVMph3_Setting_SonarSensLvl& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bAvail"

    static const int kBAvail = 0;

    /**
     * Clears the field "bAvail".
     *
     * The field will be set to its default value. The hasBAvail()
     * method will return false.
     */
    inline void clearBAvail();

    /**
     * Checks whether the field "bAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAvail()). Otherwise it will return false.
     */
    inline bool hasBAvail () const;

    /**
     * Returns the value of the member "bAvail".
     *
     * Availability of the settings item.
     *
     * @return The value of the field "bAvail"
     */
    inline bool getBAvail () const;

    /**
     * Sets the value of the member "bAvail".
     *
     * Availability of the settings item.
     *
     * @param bAvail The value which will be set
     */
    inline void setBAvail (bool bAvail_);

    // API of field "e8Level"

    static const int kE8Level = 1;

    /**
     * Clears the field "e8Level".
     *
     * The field will be set to its default value. The hasE8Level()
     * method will return false.
     */
    inline void clearE8Level();

    /**
     * Checks whether the field "e8Level" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Level()). Otherwise it will return false.
     */
    inline bool hasE8Level () const;

    /**
     * Returns the value of the member "e8Level".
     *
     * Settings value.
     *
     * @return The value of the field "e8Level"
     */
    inline T_e8_AVMph3_SonarSensLvl getE8Level () const;

    /**
     * Sets the value of the member "e8Level".
     *
     * Settings value.
     *
     * @param e8Level The value which will be set
     */
    inline void setE8Level (T_e8_AVMph3_SonarSensLvl e8Level_);

    static const T_AVMph3_Setting_SonarSensLvl &getDefaultInstance();

private:

    inline void set_has_bAvail ();

    inline void clear_has_bAvail ();

    inline void set_has_e8Level ();

    inline void clear_has_e8Level ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bAvail;

    T_e8_AVMph3_SonarSensLvl _e8Level;

};

/**
 * Specific type for the state of the camera settings item 'Buzzer_Sound_Level'.
 */
class T_AVMph3_Setting_BuzzerSoundLvl {
public:

    /**
     * Default constructor
     */
    inline  T_AVMph3_Setting_BuzzerSoundLvl ();

    /**
     * Copy constructor
     */
    inline  T_AVMph3_Setting_BuzzerSoundLvl (const T_AVMph3_Setting_BuzzerSoundLvl &rhs);

    /**
     * All fields constructor
     */
    inline  T_AVMph3_Setting_BuzzerSoundLvl (bool bAvail_, T_e8_AVMph3_BuzzerSoundLvl e8Level_);

    /**
     * Destructor
     */
    inline  ~T_AVMph3_Setting_BuzzerSoundLvl();

    /**
     * Assignment operator
     */
    inline T_AVMph3_Setting_BuzzerSoundLvl& operator = (const T_AVMph3_Setting_BuzzerSoundLvl& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AVMph3_Setting_BuzzerSoundLvl& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AVMph3_Setting_BuzzerSoundLvl& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AVMph3_Setting_BuzzerSoundLvl& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AVMph3_Setting_BuzzerSoundLvl& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bAvail"

    static const int kBAvail = 0;

    /**
     * Clears the field "bAvail".
     *
     * The field will be set to its default value. The hasBAvail()
     * method will return false.
     */
    inline void clearBAvail();

    /**
     * Checks whether the field "bAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAvail()). Otherwise it will return false.
     */
    inline bool hasBAvail () const;

    /**
     * Returns the value of the member "bAvail".
     *
     * Availability of the settings item.
     *
     * @return The value of the field "bAvail"
     */
    inline bool getBAvail () const;

    /**
     * Sets the value of the member "bAvail".
     *
     * Availability of the settings item.
     *
     * @param bAvail The value which will be set
     */
    inline void setBAvail (bool bAvail_);

    // API of field "e8Level"

    static const int kE8Level = 1;

    /**
     * Clears the field "e8Level".
     *
     * The field will be set to its default value. The hasE8Level()
     * method will return false.
     */
    inline void clearE8Level();

    /**
     * Checks whether the field "e8Level" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Level()). Otherwise it will return false.
     */
    inline bool hasE8Level () const;

    /**
     * Returns the value of the member "e8Level".
     *
     * Settings value.
     *
     * @return The value of the field "e8Level"
     */
    inline T_e8_AVMph3_BuzzerSoundLvl getE8Level () const;

    /**
     * Sets the value of the member "e8Level".
     *
     * Settings value.
     *
     * @param e8Level The value which will be set
     */
    inline void setE8Level (T_e8_AVMph3_BuzzerSoundLvl e8Level_);

    static const T_AVMph3_Setting_BuzzerSoundLvl &getDefaultInstance();

private:

    inline void set_has_bAvail ();

    inline void clear_has_bAvail ();

    inline void set_has_e8Level ();

    inline void clear_has_e8Level ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bAvail;

    T_e8_AVMph3_BuzzerSoundLvl _e8Level;

};

/**
 * Record type containing AVM phase3 version info
 */
class T_AVMph3_VersionInfo {
public:

    /**
     * Default constructor
     */
    inline  T_AVMph3_VersionInfo ();

    /**
     * Copy constructor
     */
    inline  T_AVMph3_VersionInfo (const T_AVMph3_VersionInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_AVMph3_VersionInfo (uint8 u8Upper_, uint8 u8Middle_, uint8 u8Lower_);

    /**
     * Destructor
     */
    inline  ~T_AVMph3_VersionInfo();

    /**
     * Assignment operator
     */
    inline T_AVMph3_VersionInfo& operator = (const T_AVMph3_VersionInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AVMph3_VersionInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AVMph3_VersionInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AVMph3_VersionInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AVMph3_VersionInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Upper"

    static const int kU8Upper = 0;

    /**
     * Clears the field "u8Upper".
     *
     * The field will be set to its default value. The hasU8Upper()
     * method will return false.
     */
    inline void clearU8Upper();

    /**
     * Checks whether the field "u8Upper" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Upper()). Otherwise it will return false.
     */
    inline bool hasU8Upper () const;

    /**
     * Returns the value of the member "u8Upper".
     *
     * Upper (= Major)  version number
     *
     * @return The value of the field "u8Upper"
     */
    inline uint8 getU8Upper () const;

    /**
     * Sets the value of the member "u8Upper".
     *
     * Upper (= Major)  version number
     *
     * @param u8Upper The value which will be set
     */
    inline void setU8Upper (uint8 u8Upper_);

    // API of field "u8Middle"

    static const int kU8Middle = 1;

    /**
     * Clears the field "u8Middle".
     *
     * The field will be set to its default value. The hasU8Middle()
     * method will return false.
     */
    inline void clearU8Middle();

    /**
     * Checks whether the field "u8Middle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Middle()). Otherwise it will return false.
     */
    inline bool hasU8Middle () const;

    /**
     * Returns the value of the member "u8Middle".
     *
     * Middle (= Minor) version number
     *
     * @return The value of the field "u8Middle"
     */
    inline uint8 getU8Middle () const;

    /**
     * Sets the value of the member "u8Middle".
     *
     * Middle (= Minor) version number
     *
     * @param u8Middle The value which will be set
     */
    inline void setU8Middle (uint8 u8Middle_);

    // API of field "u8Lower"

    static const int kU8Lower = 2;

    /**
     * Clears the field "u8Lower".
     *
     * The field will be set to its default value. The hasU8Lower()
     * method will return false.
     */
    inline void clearU8Lower();

    /**
     * Checks whether the field "u8Lower" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Lower()). Otherwise it will return false.
     */
    inline bool hasU8Lower () const;

    /**
     * Returns the value of the member "u8Lower".
     *
     * Lower (= Patch)  version number
     *
     * @return The value of the field "u8Lower"
     */
    inline uint8 getU8Lower () const;

    /**
     * Sets the value of the member "u8Lower".
     *
     * Lower (= Patch)  version number
     *
     * @param u8Lower The value which will be set
     */
    inline void setU8Lower (uint8 u8Lower_);

    static const T_AVMph3_VersionInfo &getDefaultInstance();

private:

    inline void set_has_u8Upper ();

    inline void clear_has_u8Upper ();

    inline void set_has_u8Middle ();

    inline void clear_has_u8Middle ();

    inline void set_has_u8Lower ();

    inline void clear_has_u8Lower ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8Upper;

    uint8 _u8Middle;

    uint8 _u8Lower;

};

/**
 * Record type defining properties/capabilities of the AVM phase3 ECU
 */
class T_AVMph3_Unit_ID {
public:

    /**
     * Default constructor
     */
    inline  T_AVMph3_Unit_ID ();

    /**
     * Copy constructor
     */
    inline  T_AVMph3_Unit_ID (const T_AVMph3_Unit_ID &rhs);

    /**
     * All fields constructor
     */
    inline  T_AVMph3_Unit_ID (uint8 u8Unit_ID_, T_e8_AVMph3_Variant e8Variant_, bool bLeftHandDrive_, bool bWithSonar_);

    /**
     * Destructor
     */
    inline  ~T_AVMph3_Unit_ID();

    /**
     * Assignment operator
     */
    inline T_AVMph3_Unit_ID& operator = (const T_AVMph3_Unit_ID& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AVMph3_Unit_ID& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AVMph3_Unit_ID& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AVMph3_Unit_ID& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AVMph3_Unit_ID& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Unit_ID"

    static const int kU8Unit_ID = 0;

    /**
     * Clears the field "u8Unit_ID".
     *
     * The field will be set to its default value. The hasU8Unit_ID()
     * method will return false.
     */
    inline void clearU8Unit_ID();

    /**
     * Checks whether the field "u8Unit_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Unit_ID()). Otherwise it will return false.
     */
    inline bool hasU8Unit_ID () const;

    /**
     * Returns the value of the member "u8Unit_ID".
     *
     * the MCAN parameter Configuration.Unit_ID, from which the remaining values in this property got extracted
     *
     * @return The value of the field "u8Unit_ID"
     */
    inline uint8 getU8Unit_ID () const;

    /**
     * Sets the value of the member "u8Unit_ID".
     *
     * the MCAN parameter Configuration.Unit_ID, from which the remaining values in this property got extracted
     *
     * @param u8Unit_ID The value which will be set
     */
    inline void setU8Unit_ID (uint8 u8Unit_ID_);

    // API of field "e8Variant"

    static const int kE8Variant = 1;

    /**
     * Clears the field "e8Variant".
     *
     * The field will be set to its default value. The hasE8Variant()
     * method will return false.
     */
    inline void clearE8Variant();

    /**
     * Checks whether the field "e8Variant" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Variant()). Otherwise it will return false.
     */
    inline bool hasE8Variant () const;

    /**
     * Returns the value of the member "e8Variant".
     *
     * variant of AVM phase3 ECU connected (bits 7..6 of u8Unit_ID)
     *
     * @return The value of the field "e8Variant"
     */
    inline T_e8_AVMph3_Variant getE8Variant () const;

    /**
     * Sets the value of the member "e8Variant".
     *
     * variant of AVM phase3 ECU connected (bits 7..6 of u8Unit_ID)
     *
     * @param e8Variant The value which will be set
     */
    inline void setE8Variant (T_e8_AVMph3_Variant e8Variant_);

    // API of field "bLeftHandDrive"

    static const int kBLeftHandDrive = 2;

    /**
     * Clears the field "bLeftHandDrive".
     *
     * The field will be set to its default value. The hasBLeftHandDrive()
     * method will return false.
     */
    inline void clearBLeftHandDrive();

    /**
     * Checks whether the field "bLeftHandDrive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBLeftHandDrive()). Otherwise it will return false.
     */
    inline bool hasBLeftHandDrive () const;

    /**
     * Returns the value of the member "bLeftHandDrive".
     *
     * 0 = RightHandDrive, 1 = LeftHandDrive (bit 3 of u8Unit_ID)
     *
     * @return The value of the field "bLeftHandDrive"
     */
    inline bool getBLeftHandDrive () const;

    /**
     * Sets the value of the member "bLeftHandDrive".
     *
     * 0 = RightHandDrive, 1 = LeftHandDrive (bit 3 of u8Unit_ID)
     *
     * @param bLeftHandDrive The value which will be set
     */
    inline void setBLeftHandDrive (bool bLeftHandDrive_);

    // API of field "bWithSonar"

    static const int kBWithSonar = 3;

    /**
     * Clears the field "bWithSonar".
     *
     * The field will be set to its default value. The hasBWithSonar()
     * method will return false.
     */
    inline void clearBWithSonar();

    /**
     * Checks whether the field "bWithSonar" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBWithSonar()). Otherwise it will return false.
     */
    inline bool hasBWithSonar () const;

    /**
     * Returns the value of the member "bWithSonar".
     *
     * 0 = without sonar, 1 = with sonar (bit 2 of u8Unit_ID)
     *
     * @return The value of the field "bWithSonar"
     */
    inline bool getBWithSonar () const;

    /**
     * Sets the value of the member "bWithSonar".
     *
     * 0 = without sonar, 1 = with sonar (bit 2 of u8Unit_ID)
     *
     * @param bWithSonar The value which will be set
     */
    inline void setBWithSonar (bool bWithSonar_);

    static const T_AVMph3_Unit_ID &getDefaultInstance();

private:

    inline void set_has_u8Unit_ID ();

    inline void clear_has_u8Unit_ID ();

    inline void set_has_e8Variant ();

    inline void clear_has_e8Variant ();

    inline void set_has_bLeftHandDrive ();

    inline void clear_has_bLeftHandDrive ();

    inline void set_has_bWithSonar ();

    inline void clear_has_bWithSonar ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _u8Unit_ID;

    T_e8_AVMph3_Variant _e8Variant;

    bool _bLeftHandDrive;

    bool _bWithSonar;

};

/**
 * Record type holding the AVM phase3 ECU's MCAN communication error state parameters (ref. 25953NDS06).
 */
class T_AVMph3_MCAN_CommunicationErrors {
public:

    /**
     * Default constructor
     */
    inline  T_AVMph3_MCAN_CommunicationErrors ();

    /**
     * Copy constructor
     */
    inline  T_AVMph3_MCAN_CommunicationErrors (const T_AVMph3_MCAN_CommunicationErrors &rhs);

    /**
     * All fields constructor
     */
    inline  T_AVMph3_MCAN_CommunicationErrors (uint8 u8BusOff_, uint8 u8TxCmfToMaster_, uint8 u8RxCmfFromSonar_, uint8 u8TxMpdtToSonar_);

    /**
     * Destructor
     */
    inline  ~T_AVMph3_MCAN_CommunicationErrors();

    /**
     * Assignment operator
     */
    inline T_AVMph3_MCAN_CommunicationErrors& operator = (const T_AVMph3_MCAN_CommunicationErrors& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AVMph3_MCAN_CommunicationErrors& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AVMph3_MCAN_CommunicationErrors& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AVMph3_MCAN_CommunicationErrors& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AVMph3_MCAN_CommunicationErrors& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8BusOff"

    static const int kU8BusOff = 0;

    /**
     * Clears the field "u8BusOff".
     *
     * The field will be set to its default value. The hasU8BusOff()
     * method will return false.
     */
    inline void clearU8BusOff();

    /**
     * Checks whether the field "u8BusOff" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8BusOff()). Otherwise it will return false.
     */
    inline bool hasU8BusOff () const;

    /**
     * Returns the value of the member "u8BusOff".
     *
     * status of BusOff
     *
     * @return The value of the field "u8BusOff"
     */
    inline uint8 getU8BusOff () const;

    /**
     * Sets the value of the member "u8BusOff".
     *
     * status of BusOff
     *
     * @param u8BusOff The value which will be set
     */
    inline void setU8BusOff (uint8 u8BusOff_);

    // API of field "u8TxCmfToMaster"

    static const int kU8TxCmfToMaster = 1;

    /**
     * Clears the field "u8TxCmfToMaster".
     *
     * The field will be set to its default value. The hasU8TxCmfToMaster()
     * method will return false.
     */
    inline void clearU8TxCmfToMaster();

    /**
     * Checks whether the field "u8TxCmfToMaster" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TxCmfToMaster()). Otherwise it will return false.
     */
    inline bool hasU8TxCmfToMaster () const;

    /**
     * Returns the value of the member "u8TxCmfToMaster".
     *
     * status of sending CMF to Master
     *
     * @return The value of the field "u8TxCmfToMaster"
     */
    inline uint8 getU8TxCmfToMaster () const;

    /**
     * Sets the value of the member "u8TxCmfToMaster".
     *
     * status of sending CMF to Master
     *
     * @param u8TxCmfToMaster The value which will be set
     */
    inline void setU8TxCmfToMaster (uint8 u8TxCmfToMaster_);

    // API of field "u8RxCmfFromSonar"

    static const int kU8RxCmfFromSonar = 2;

    /**
     * Clears the field "u8RxCmfFromSonar".
     *
     * The field will be set to its default value. The hasU8RxCmfFromSonar()
     * method will return false.
     */
    inline void clearU8RxCmfFromSonar();

    /**
     * Checks whether the field "u8RxCmfFromSonar" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8RxCmfFromSonar()). Otherwise it will return false.
     */
    inline bool hasU8RxCmfFromSonar () const;

    /**
     * Returns the value of the member "u8RxCmfFromSonar".
     *
     * status of receiving CMF from Sonar
     *
     * @return The value of the field "u8RxCmfFromSonar"
     */
    inline uint8 getU8RxCmfFromSonar () const;

    /**
     * Sets the value of the member "u8RxCmfFromSonar".
     *
     * status of receiving CMF from Sonar
     *
     * @param u8RxCmfFromSonar The value which will be set
     */
    inline void setU8RxCmfFromSonar (uint8 u8RxCmfFromSonar_);

    // API of field "u8TxMpdtToSonar"

    static const int kU8TxMpdtToSonar = 3;

    /**
     * Clears the field "u8TxMpdtToSonar".
     *
     * The field will be set to its default value. The hasU8TxMpdtToSonar()
     * method will return false.
     */
    inline void clearU8TxMpdtToSonar();

    /**
     * Checks whether the field "u8TxMpdtToSonar" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TxMpdtToSonar()). Otherwise it will return false.
     */
    inline bool hasU8TxMpdtToSonar () const;

    /**
     * Returns the value of the member "u8TxMpdtToSonar".
     *
     * status of sending MPDT to Sonar
     *
     * @return The value of the field "u8TxMpdtToSonar"
     */
    inline uint8 getU8TxMpdtToSonar () const;

    /**
     * Sets the value of the member "u8TxMpdtToSonar".
     *
     * status of sending MPDT to Sonar
     *
     * @param u8TxMpdtToSonar The value which will be set
     */
    inline void setU8TxMpdtToSonar (uint8 u8TxMpdtToSonar_);

    static const T_AVMph3_MCAN_CommunicationErrors &getDefaultInstance();

private:

    inline void set_has_u8BusOff ();

    inline void clear_has_u8BusOff ();

    inline void set_has_u8TxCmfToMaster ();

    inline void clear_has_u8TxCmfToMaster ();

    inline void set_has_u8RxCmfFromSonar ();

    inline void clear_has_u8RxCmfFromSonar ();

    inline void set_has_u8TxMpdtToSonar ();

    inline void clear_has_u8TxMpdtToSonar ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _u8BusOff;

    uint8 _u8TxCmfToMaster;

    uint8 _u8RxCmfFromSonar;

    uint8 _u8TxMpdtToSonar;

};

inline  T_RVC_VideoAnalogLevels::T_RVC_VideoAnalogLevels ()  :
    _e8Type (::rvc_cca_fi_types::T_e8_RVC_VideoParameterType__BRIGHTNESS),
    _e8DimmingMode (::rvc_cca_fi_types::T_e8_RVC_VideoParameterDimmingMode__DAY),
    _u8Value (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_RVC_VideoAnalogLevels::T_RVC_VideoAnalogLevels (const T_RVC_VideoAnalogLevels &rhs)  :
    _e8Type (::rvc_cca_fi_types::T_e8_RVC_VideoParameterType__BRIGHTNESS),
    _e8DimmingMode (::rvc_cca_fi_types::T_e8_RVC_VideoParameterDimmingMode__DAY),
    _u8Value (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_RVC_VideoAnalogLevels::T_RVC_VideoAnalogLevels (T_e8_RVC_VideoParameterType e8Type_, T_e8_RVC_VideoParameterDimmingMode e8DimmingMode_, uint8 u8Value_)  :
    _e8Type (e8Type_),
    _e8DimmingMode (e8DimmingMode_),
    _u8Value (u8Value_)
{
    #ifndef NDEBUG
    if (!(T_e8_RVC_VideoParameterType_IsValid(e8Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Type_, "T_e8_RVC_VideoParameterType", "e8Type", "T_RVC_VideoAnalogLevels");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_RVC_VideoParameterDimmingMode_IsValid(e8DimmingMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DimmingMode_, "T_e8_RVC_VideoParameterDimmingMode", "e8DimmingMode", "T_RVC_VideoAnalogLevels");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_RVC_VideoAnalogLevels::~T_RVC_VideoAnalogLevels() {
}

inline T_RVC_VideoAnalogLevels& T_RVC_VideoAnalogLevels::operator = (const T_RVC_VideoAnalogLevels& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8Type()) {
            setE8Type(rhs.getE8Type());
        } else {
            clearE8Type();
        }
        if (rhs.hasE8DimmingMode()) {
            setE8DimmingMode(rhs.getE8DimmingMode());
        } else {
            clearE8DimmingMode();
        }
        if (rhs.hasU8Value()) {
            setU8Value(rhs.getU8Value());
        } else {
            clearU8Value();
        }
    }
    return *this;
}

inline bool T_RVC_VideoAnalogLevels::operator == (const T_RVC_VideoAnalogLevels& rhs) const {
    return (((!hasE8Type() && !rhs.hasE8Type()) || getE8Type() == rhs.getE8Type()) &&
        ((!hasE8DimmingMode() && !rhs.hasE8DimmingMode()) || getE8DimmingMode() == rhs.getE8DimmingMode()) &&
        ((!hasU8Value() && !rhs.hasU8Value()) || getU8Value() == rhs.getU8Value()));
}

inline bool T_RVC_VideoAnalogLevels::operator != (const T_RVC_VideoAnalogLevels& rhs) const {
    return ! (*this == rhs);
}

inline bool T_RVC_VideoAnalogLevels::operator < (const T_RVC_VideoAnalogLevels& rhs) const {
    if (hasE8Type() || rhs.hasE8Type()) {
        if ((uint32)getE8Type() < (uint32)rhs.getE8Type()) return true;
        if ((uint32)getE8Type() > (uint32)rhs.getE8Type()) return false;
    }
    if (hasE8DimmingMode() || rhs.hasE8DimmingMode()) {
        if ((uint32)getE8DimmingMode() < (uint32)rhs.getE8DimmingMode()) return true;
        if ((uint32)getE8DimmingMode() > (uint32)rhs.getE8DimmingMode()) return false;
    }
    if (hasU8Value() || rhs.hasU8Value()) {
        if (getU8Value() < rhs.getU8Value()) return true;
        if (getU8Value() > rhs.getU8Value()) return false;
    }
    return false;
}

inline bool T_RVC_VideoAnalogLevels::operator > (const T_RVC_VideoAnalogLevels& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_RVC_VideoAnalogLevels::clear() {
    clearE8Type();
    clearE8DimmingMode();
    clearU8Value();
}

inline void T_RVC_VideoAnalogLevels::clearE8Type() {
    if (hasE8Type()) {
         clear_has_e8Type();
        _e8Type = ::rvc_cca_fi_types::T_e8_RVC_VideoParameterType__BRIGHTNESS;
     }
}

inline bool T_RVC_VideoAnalogLevels::hasE8Type () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_RVC_VideoParameterType T_RVC_VideoAnalogLevels::getE8Type () const {
    return _e8Type;
}

inline void T_RVC_VideoAnalogLevels::setE8Type (T_e8_RVC_VideoParameterType e8Type_) {
    #ifndef NDEBUG
    if (!(T_e8_RVC_VideoParameterType_IsValid(e8Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Type_, "T_e8_RVC_VideoParameterType", "e8Type", "T_RVC_VideoAnalogLevels");
    }
    #endif
    set_has_e8Type();
    this->_e8Type = e8Type_;
}

inline void T_RVC_VideoAnalogLevels::clearE8DimmingMode() {
    if (hasE8DimmingMode()) {
         clear_has_e8DimmingMode();
        _e8DimmingMode = ::rvc_cca_fi_types::T_e8_RVC_VideoParameterDimmingMode__DAY;
     }
}

inline bool T_RVC_VideoAnalogLevels::hasE8DimmingMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_RVC_VideoParameterDimmingMode T_RVC_VideoAnalogLevels::getE8DimmingMode () const {
    return _e8DimmingMode;
}

inline void T_RVC_VideoAnalogLevels::setE8DimmingMode (T_e8_RVC_VideoParameterDimmingMode e8DimmingMode_) {
    #ifndef NDEBUG
    if (!(T_e8_RVC_VideoParameterDimmingMode_IsValid(e8DimmingMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DimmingMode_, "T_e8_RVC_VideoParameterDimmingMode", "e8DimmingMode", "T_RVC_VideoAnalogLevels");
    }
    #endif
    set_has_e8DimmingMode();
    this->_e8DimmingMode = e8DimmingMode_;
}

inline void T_RVC_VideoAnalogLevels::clearU8Value() {
    if (hasU8Value()) {
         clear_has_u8Value();
        _u8Value = 0u;
     }
}

inline bool T_RVC_VideoAnalogLevels::hasU8Value () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_RVC_VideoAnalogLevels::getU8Value () const {
    return _u8Value;
}

inline void T_RVC_VideoAnalogLevels::setU8Value (uint8 u8Value_) {
    set_has_u8Value();
    this->_u8Value = u8Value_;
}

inline void T_RVC_VideoAnalogLevels::set_has_e8Type () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_RVC_VideoAnalogLevels::clear_has_e8Type () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_RVC_VideoAnalogLevels::set_has_e8DimmingMode () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_RVC_VideoAnalogLevels::clear_has_e8DimmingMode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_RVC_VideoAnalogLevels::set_has_u8Value () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_RVC_VideoAnalogLevels::clear_has_u8Value () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_IPA_Voice_Text_Strings::T_IPA_Voice_Text_Strings ()  :
    _e8RequestId (::rvc_cca_fi_types::T_e8_IPA_VoiceText__No_Sound),
    _szText ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_IPA_Voice_Text_Strings::T_IPA_Voice_Text_Strings (const T_IPA_Voice_Text_Strings &rhs)  :
    _e8RequestId (::rvc_cca_fi_types::T_e8_IPA_VoiceText__No_Sound),
    _szText ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_IPA_Voice_Text_Strings::T_IPA_Voice_Text_Strings (T_e8_IPA_VoiceText e8RequestId_, const ::std::string& szText_)  :
    _e8RequestId (e8RequestId_),
    _szText (szText_)
{
    #ifndef NDEBUG
    if (!(T_e8_IPA_VoiceText_IsValid(e8RequestId_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8RequestId_, "T_e8_IPA_VoiceText", "e8RequestId", "T_IPA_Voice_Text_Strings");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szText_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_IPA_Voice_Text_Strings::~T_IPA_Voice_Text_Strings() {
}

inline T_IPA_Voice_Text_Strings& T_IPA_Voice_Text_Strings::operator = (const T_IPA_Voice_Text_Strings& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8RequestId()) {
            setE8RequestId(rhs.getE8RequestId());
        } else {
            clearE8RequestId();
        }
        if (rhs.hasSzText()) {
            setSzText(rhs.getSzText());
        } else {
            clearSzText();
        }
    }
    return *this;
}

inline bool T_IPA_Voice_Text_Strings::operator == (const T_IPA_Voice_Text_Strings& rhs) const {
    return (((!hasE8RequestId() && !rhs.hasE8RequestId()) || getE8RequestId() == rhs.getE8RequestId()) &&
        ((!hasSzText() && !rhs.hasSzText()) || getSzText() == rhs.getSzText()));
}

inline bool T_IPA_Voice_Text_Strings::operator != (const T_IPA_Voice_Text_Strings& rhs) const {
    return ! (*this == rhs);
}

inline bool T_IPA_Voice_Text_Strings::operator < (const T_IPA_Voice_Text_Strings& rhs) const {
    if (hasE8RequestId() || rhs.hasE8RequestId()) {
        if ((uint32)getE8RequestId() < (uint32)rhs.getE8RequestId()) return true;
        if ((uint32)getE8RequestId() > (uint32)rhs.getE8RequestId()) return false;
    }
    if (hasSzText() || rhs.hasSzText()) {
        if (getSzText() < rhs.getSzText()) return true;
        if (getSzText() > rhs.getSzText()) return false;
    }
    return false;
}

inline bool T_IPA_Voice_Text_Strings::operator > (const T_IPA_Voice_Text_Strings& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_IPA_Voice_Text_Strings::clear() {
    clearE8RequestId();
    clearSzText();
}

inline void T_IPA_Voice_Text_Strings::clearE8RequestId() {
    if (hasE8RequestId()) {
         clear_has_e8RequestId();
        _e8RequestId = ::rvc_cca_fi_types::T_e8_IPA_VoiceText__No_Sound;
     }
}

inline bool T_IPA_Voice_Text_Strings::hasE8RequestId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_IPA_VoiceText T_IPA_Voice_Text_Strings::getE8RequestId () const {
    return _e8RequestId;
}

inline void T_IPA_Voice_Text_Strings::setE8RequestId (T_e8_IPA_VoiceText e8RequestId_) {
    #ifndef NDEBUG
    if (!(T_e8_IPA_VoiceText_IsValid(e8RequestId_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8RequestId_, "T_e8_IPA_VoiceText", "e8RequestId", "T_IPA_Voice_Text_Strings");
    }
    #endif
    set_has_e8RequestId();
    this->_e8RequestId = e8RequestId_;
}

inline void T_IPA_Voice_Text_Strings::clearSzText() {
    if (hasSzText()) {
         clear_has_szText();
        _szText.clear();
     }
}

inline bool T_IPA_Voice_Text_Strings::hasSzText () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_IPA_Voice_Text_Strings::getSzText () const {
    return _szText;
}

inline ::std::string& T_IPA_Voice_Text_Strings::getSzTextMutable () {
    set_has_szText();
    return _szText;
}

inline void T_IPA_Voice_Text_Strings::setSzText (const ::std::string& szText_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szText_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szText();
    this->_szText = szText_;
}

inline void T_IPA_Voice_Text_Strings::setSzText (const char* szText_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (szText_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szText();
    this->_szText.assign(szText_);
}

inline void T_IPA_Voice_Text_Strings::setSzText (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_szText();
    this->_szText.assign(value, size);
}

inline void T_IPA_Voice_Text_Strings::set_has_e8RequestId () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_IPA_Voice_Text_Strings::clear_has_e8RequestId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_IPA_Voice_Text_Strings::set_has_szText () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_IPA_Voice_Text_Strings::clear_has_szText () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_ParkAssist_UserConfiguration::T_ParkAssist_UserConfiguration ()  :
    _e8Type (::rvc_cca_fi_types::T_e8_ParkAssist_UserConfigurationType__REAR_VIEW_CAMERA),
    _e8Mode (::rvc_cca_fi_types::T_e8_ParkAssist_UserConfigurationMode__OFF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ParkAssist_UserConfiguration::T_ParkAssist_UserConfiguration (const T_ParkAssist_UserConfiguration &rhs)  :
    _e8Type (::rvc_cca_fi_types::T_e8_ParkAssist_UserConfigurationType__REAR_VIEW_CAMERA),
    _e8Mode (::rvc_cca_fi_types::T_e8_ParkAssist_UserConfigurationMode__OFF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ParkAssist_UserConfiguration::T_ParkAssist_UserConfiguration (T_e8_ParkAssist_UserConfigurationType e8Type_, T_e8_ParkAssist_UserConfigurationMode e8Mode_)  :
    _e8Type (e8Type_),
    _e8Mode (e8Mode_)
{
    #ifndef NDEBUG
    if (!(T_e8_ParkAssist_UserConfigurationType_IsValid(e8Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Type_, "T_e8_ParkAssist_UserConfigurationType", "e8Type", "T_ParkAssist_UserConfiguration");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_ParkAssist_UserConfigurationMode_IsValid(e8Mode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Mode_, "T_e8_ParkAssist_UserConfigurationMode", "e8Mode", "T_ParkAssist_UserConfiguration");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ParkAssist_UserConfiguration::~T_ParkAssist_UserConfiguration() {
}

inline T_ParkAssist_UserConfiguration& T_ParkAssist_UserConfiguration::operator = (const T_ParkAssist_UserConfiguration& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8Type()) {
            setE8Type(rhs.getE8Type());
        } else {
            clearE8Type();
        }
        if (rhs.hasE8Mode()) {
            setE8Mode(rhs.getE8Mode());
        } else {
            clearE8Mode();
        }
    }
    return *this;
}

inline bool T_ParkAssist_UserConfiguration::operator == (const T_ParkAssist_UserConfiguration& rhs) const {
    return (((!hasE8Type() && !rhs.hasE8Type()) || getE8Type() == rhs.getE8Type()) &&
        ((!hasE8Mode() && !rhs.hasE8Mode()) || getE8Mode() == rhs.getE8Mode()));
}

inline bool T_ParkAssist_UserConfiguration::operator != (const T_ParkAssist_UserConfiguration& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ParkAssist_UserConfiguration::operator < (const T_ParkAssist_UserConfiguration& rhs) const {
    if (hasE8Type() || rhs.hasE8Type()) {
        if ((uint32)getE8Type() < (uint32)rhs.getE8Type()) return true;
        if ((uint32)getE8Type() > (uint32)rhs.getE8Type()) return false;
    }
    if (hasE8Mode() || rhs.hasE8Mode()) {
        if ((uint32)getE8Mode() < (uint32)rhs.getE8Mode()) return true;
        if ((uint32)getE8Mode() > (uint32)rhs.getE8Mode()) return false;
    }
    return false;
}

inline bool T_ParkAssist_UserConfiguration::operator > (const T_ParkAssist_UserConfiguration& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ParkAssist_UserConfiguration::clear() {
    clearE8Type();
    clearE8Mode();
}

inline void T_ParkAssist_UserConfiguration::clearE8Type() {
    if (hasE8Type()) {
         clear_has_e8Type();
        _e8Type = ::rvc_cca_fi_types::T_e8_ParkAssist_UserConfigurationType__REAR_VIEW_CAMERA;
     }
}

inline bool T_ParkAssist_UserConfiguration::hasE8Type () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_ParkAssist_UserConfigurationType T_ParkAssist_UserConfiguration::getE8Type () const {
    return _e8Type;
}

inline void T_ParkAssist_UserConfiguration::setE8Type (T_e8_ParkAssist_UserConfigurationType e8Type_) {
    #ifndef NDEBUG
    if (!(T_e8_ParkAssist_UserConfigurationType_IsValid(e8Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Type_, "T_e8_ParkAssist_UserConfigurationType", "e8Type", "T_ParkAssist_UserConfiguration");
    }
    #endif
    set_has_e8Type();
    this->_e8Type = e8Type_;
}

inline void T_ParkAssist_UserConfiguration::clearE8Mode() {
    if (hasE8Mode()) {
         clear_has_e8Mode();
        _e8Mode = ::rvc_cca_fi_types::T_e8_ParkAssist_UserConfigurationMode__OFF;
     }
}

inline bool T_ParkAssist_UserConfiguration::hasE8Mode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_ParkAssist_UserConfigurationMode T_ParkAssist_UserConfiguration::getE8Mode () const {
    return _e8Mode;
}

inline void T_ParkAssist_UserConfiguration::setE8Mode (T_e8_ParkAssist_UserConfigurationMode e8Mode_) {
    #ifndef NDEBUG
    if (!(T_e8_ParkAssist_UserConfigurationMode_IsValid(e8Mode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Mode_, "T_e8_ParkAssist_UserConfigurationMode", "e8Mode", "T_ParkAssist_UserConfiguration");
    }
    #endif
    set_has_e8Mode();
    this->_e8Mode = e8Mode_;
}

inline void T_ParkAssist_UserConfiguration::set_has_e8Type () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ParkAssist_UserConfiguration::clear_has_e8Type () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_ParkAssist_UserConfiguration::set_has_e8Mode () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_ParkAssist_UserConfiguration::clear_has_e8Mode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_GdlAdj_ConfigParameterData::T_GdlAdj_ConfigParameterData ()  :
    _e8Item (::rvc_cca_fi_types::T_e8_GdlAdj_ConfigurationItem__None),
    _f64Value (0.0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_GdlAdj_ConfigParameterData::T_GdlAdj_ConfigParameterData (const T_GdlAdj_ConfigParameterData &rhs)  :
    _e8Item (::rvc_cca_fi_types::T_e8_GdlAdj_ConfigurationItem__None),
    _f64Value (0.0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_GdlAdj_ConfigParameterData::T_GdlAdj_ConfigParameterData (T_e8_GdlAdj_ConfigurationItem e8Item_, double f64Value_)  :
    _e8Item (e8Item_),
    _f64Value (f64Value_)
{
    #ifndef NDEBUG
    if (!(T_e8_GdlAdj_ConfigurationItem_IsValid(e8Item_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Item_, "T_e8_GdlAdj_ConfigurationItem", "e8Item", "T_GdlAdj_ConfigParameterData");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_GdlAdj_ConfigParameterData::~T_GdlAdj_ConfigParameterData() {
}

inline T_GdlAdj_ConfigParameterData& T_GdlAdj_ConfigParameterData::operator = (const T_GdlAdj_ConfigParameterData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8Item()) {
            setE8Item(rhs.getE8Item());
        } else {
            clearE8Item();
        }
        if (rhs.hasF64Value()) {
            setF64Value(rhs.getF64Value());
        } else {
            clearF64Value();
        }
    }
    return *this;
}

inline bool T_GdlAdj_ConfigParameterData::operator == (const T_GdlAdj_ConfigParameterData& rhs) const {
    return (((!hasE8Item() && !rhs.hasE8Item()) || getE8Item() == rhs.getE8Item()) &&
        ((!hasF64Value() && !rhs.hasF64Value()) || getF64Value() == rhs.getF64Value()));
}

inline bool T_GdlAdj_ConfigParameterData::operator != (const T_GdlAdj_ConfigParameterData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_GdlAdj_ConfigParameterData::operator < (const T_GdlAdj_ConfigParameterData& rhs) const {
    if (hasE8Item() || rhs.hasE8Item()) {
        if ((uint32)getE8Item() < (uint32)rhs.getE8Item()) return true;
        if ((uint32)getE8Item() > (uint32)rhs.getE8Item()) return false;
    }
    if (hasF64Value() || rhs.hasF64Value()) {
        if (getF64Value() < rhs.getF64Value()) return true;
        if (getF64Value() > rhs.getF64Value()) return false;
    }
    return false;
}

inline bool T_GdlAdj_ConfigParameterData::operator > (const T_GdlAdj_ConfigParameterData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_GdlAdj_ConfigParameterData::clear() {
    clearE8Item();
    clearF64Value();
}

inline void T_GdlAdj_ConfigParameterData::clearE8Item() {
    if (hasE8Item()) {
         clear_has_e8Item();
        _e8Item = ::rvc_cca_fi_types::T_e8_GdlAdj_ConfigurationItem__None;
     }
}

inline bool T_GdlAdj_ConfigParameterData::hasE8Item () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_GdlAdj_ConfigurationItem T_GdlAdj_ConfigParameterData::getE8Item () const {
    return _e8Item;
}

inline void T_GdlAdj_ConfigParameterData::setE8Item (T_e8_GdlAdj_ConfigurationItem e8Item_) {
    #ifndef NDEBUG
    if (!(T_e8_GdlAdj_ConfigurationItem_IsValid(e8Item_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Item_, "T_e8_GdlAdj_ConfigurationItem", "e8Item", "T_GdlAdj_ConfigParameterData");
    }
    #endif
    set_has_e8Item();
    this->_e8Item = e8Item_;
}

inline void T_GdlAdj_ConfigParameterData::clearF64Value() {
    if (hasF64Value()) {
         clear_has_f64Value();
        _f64Value = 0.0;
     }
}

inline bool T_GdlAdj_ConfigParameterData::hasF64Value () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline double T_GdlAdj_ConfigParameterData::getF64Value () const {
    return _f64Value;
}

inline void T_GdlAdj_ConfigParameterData::setF64Value (double f64Value_) {
    set_has_f64Value();
    this->_f64Value = f64Value_;
}

inline void T_GdlAdj_ConfigParameterData::set_has_e8Item () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_GdlAdj_ConfigParameterData::clear_has_e8Item () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_GdlAdj_ConfigParameterData::set_has_f64Value () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_GdlAdj_ConfigParameterData::clear_has_f64Value () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_FAP_Settings_State::T_FAP_Settings_State ()  :
    _e8Type (::rvc_cca_fi_types::T_e8_FAP_SettingItem__SettingsButtonAvail),
    _e8State (::rvc_cca_fi_types::T_e8_AVM_FAP_SettingState__Not_Displayed)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_FAP_Settings_State::T_FAP_Settings_State (const T_FAP_Settings_State &rhs)  :
    _e8Type (::rvc_cca_fi_types::T_e8_FAP_SettingItem__SettingsButtonAvail),
    _e8State (::rvc_cca_fi_types::T_e8_AVM_FAP_SettingState__Not_Displayed)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_FAP_Settings_State::T_FAP_Settings_State (T_e8_FAP_SettingItem e8Type_, T_e8_AVM_FAP_SettingState e8State_)  :
    _e8Type (e8Type_),
    _e8State (e8State_)
{
    #ifndef NDEBUG
    if (!(T_e8_FAP_SettingItem_IsValid(e8Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Type_, "T_e8_FAP_SettingItem", "e8Type", "T_FAP_Settings_State");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_AVM_FAP_SettingState_IsValid(e8State_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8State_, "T_e8_AVM_FAP_SettingState", "e8State", "T_FAP_Settings_State");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_FAP_Settings_State::~T_FAP_Settings_State() {
}

inline T_FAP_Settings_State& T_FAP_Settings_State::operator = (const T_FAP_Settings_State& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8Type()) {
            setE8Type(rhs.getE8Type());
        } else {
            clearE8Type();
        }
        if (rhs.hasE8State()) {
            setE8State(rhs.getE8State());
        } else {
            clearE8State();
        }
    }
    return *this;
}

inline bool T_FAP_Settings_State::operator == (const T_FAP_Settings_State& rhs) const {
    return (((!hasE8Type() && !rhs.hasE8Type()) || getE8Type() == rhs.getE8Type()) &&
        ((!hasE8State() && !rhs.hasE8State()) || getE8State() == rhs.getE8State()));
}

inline bool T_FAP_Settings_State::operator != (const T_FAP_Settings_State& rhs) const {
    return ! (*this == rhs);
}

inline bool T_FAP_Settings_State::operator < (const T_FAP_Settings_State& rhs) const {
    if (hasE8Type() || rhs.hasE8Type()) {
        if ((uint32)getE8Type() < (uint32)rhs.getE8Type()) return true;
        if ((uint32)getE8Type() > (uint32)rhs.getE8Type()) return false;
    }
    if (hasE8State() || rhs.hasE8State()) {
        if ((uint32)getE8State() < (uint32)rhs.getE8State()) return true;
        if ((uint32)getE8State() > (uint32)rhs.getE8State()) return false;
    }
    return false;
}

inline bool T_FAP_Settings_State::operator > (const T_FAP_Settings_State& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_FAP_Settings_State::clear() {
    clearE8Type();
    clearE8State();
}

inline void T_FAP_Settings_State::clearE8Type() {
    if (hasE8Type()) {
         clear_has_e8Type();
        _e8Type = ::rvc_cca_fi_types::T_e8_FAP_SettingItem__SettingsButtonAvail;
     }
}

inline bool T_FAP_Settings_State::hasE8Type () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_FAP_SettingItem T_FAP_Settings_State::getE8Type () const {
    return _e8Type;
}

inline void T_FAP_Settings_State::setE8Type (T_e8_FAP_SettingItem e8Type_) {
    #ifndef NDEBUG
    if (!(T_e8_FAP_SettingItem_IsValid(e8Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Type_, "T_e8_FAP_SettingItem", "e8Type", "T_FAP_Settings_State");
    }
    #endif
    set_has_e8Type();
    this->_e8Type = e8Type_;
}

inline void T_FAP_Settings_State::clearE8State() {
    if (hasE8State()) {
         clear_has_e8State();
        _e8State = ::rvc_cca_fi_types::T_e8_AVM_FAP_SettingState__Not_Displayed;
     }
}

inline bool T_FAP_Settings_State::hasE8State () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_AVM_FAP_SettingState T_FAP_Settings_State::getE8State () const {
    return _e8State;
}

inline void T_FAP_Settings_State::setE8State (T_e8_AVM_FAP_SettingState e8State_) {
    #ifndef NDEBUG
    if (!(T_e8_AVM_FAP_SettingState_IsValid(e8State_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8State_, "T_e8_AVM_FAP_SettingState", "e8State", "T_FAP_Settings_State");
    }
    #endif
    set_has_e8State();
    this->_e8State = e8State_;
}

inline void T_FAP_Settings_State::set_has_e8Type () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_FAP_Settings_State::clear_has_e8Type () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_FAP_Settings_State::set_has_e8State () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_FAP_Settings_State::clear_has_e8State () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_AVM_Settings_State::T_AVM_Settings_State ()  :
    _e8Type (::rvc_cca_fi_types::T_e8_AVM_SettingItem__SettingsButtonAvail),
    _e8State (::rvc_cca_fi_types::T_e8_AVM_FAP_SettingState__Not_Displayed)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AVM_Settings_State::T_AVM_Settings_State (const T_AVM_Settings_State &rhs)  :
    _e8Type (::rvc_cca_fi_types::T_e8_AVM_SettingItem__SettingsButtonAvail),
    _e8State (::rvc_cca_fi_types::T_e8_AVM_FAP_SettingState__Not_Displayed)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AVM_Settings_State::T_AVM_Settings_State (T_e8_AVM_SettingItem e8Type_, T_e8_AVM_FAP_SettingState e8State_)  :
    _e8Type (e8Type_),
    _e8State (e8State_)
{
    #ifndef NDEBUG
    if (!(T_e8_AVM_SettingItem_IsValid(e8Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Type_, "T_e8_AVM_SettingItem", "e8Type", "T_AVM_Settings_State");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_AVM_FAP_SettingState_IsValid(e8State_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8State_, "T_e8_AVM_FAP_SettingState", "e8State", "T_AVM_Settings_State");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AVM_Settings_State::~T_AVM_Settings_State() {
}

inline T_AVM_Settings_State& T_AVM_Settings_State::operator = (const T_AVM_Settings_State& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8Type()) {
            setE8Type(rhs.getE8Type());
        } else {
            clearE8Type();
        }
        if (rhs.hasE8State()) {
            setE8State(rhs.getE8State());
        } else {
            clearE8State();
        }
    }
    return *this;
}

inline bool T_AVM_Settings_State::operator == (const T_AVM_Settings_State& rhs) const {
    return (((!hasE8Type() && !rhs.hasE8Type()) || getE8Type() == rhs.getE8Type()) &&
        ((!hasE8State() && !rhs.hasE8State()) || getE8State() == rhs.getE8State()));
}

inline bool T_AVM_Settings_State::operator != (const T_AVM_Settings_State& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AVM_Settings_State::operator < (const T_AVM_Settings_State& rhs) const {
    if (hasE8Type() || rhs.hasE8Type()) {
        if ((uint32)getE8Type() < (uint32)rhs.getE8Type()) return true;
        if ((uint32)getE8Type() > (uint32)rhs.getE8Type()) return false;
    }
    if (hasE8State() || rhs.hasE8State()) {
        if ((uint32)getE8State() < (uint32)rhs.getE8State()) return true;
        if ((uint32)getE8State() > (uint32)rhs.getE8State()) return false;
    }
    return false;
}

inline bool T_AVM_Settings_State::operator > (const T_AVM_Settings_State& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AVM_Settings_State::clear() {
    clearE8Type();
    clearE8State();
}

inline void T_AVM_Settings_State::clearE8Type() {
    if (hasE8Type()) {
         clear_has_e8Type();
        _e8Type = ::rvc_cca_fi_types::T_e8_AVM_SettingItem__SettingsButtonAvail;
     }
}

inline bool T_AVM_Settings_State::hasE8Type () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_AVM_SettingItem T_AVM_Settings_State::getE8Type () const {
    return _e8Type;
}

inline void T_AVM_Settings_State::setE8Type (T_e8_AVM_SettingItem e8Type_) {
    #ifndef NDEBUG
    if (!(T_e8_AVM_SettingItem_IsValid(e8Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Type_, "T_e8_AVM_SettingItem", "e8Type", "T_AVM_Settings_State");
    }
    #endif
    set_has_e8Type();
    this->_e8Type = e8Type_;
}

inline void T_AVM_Settings_State::clearE8State() {
    if (hasE8State()) {
         clear_has_e8State();
        _e8State = ::rvc_cca_fi_types::T_e8_AVM_FAP_SettingState__Not_Displayed;
     }
}

inline bool T_AVM_Settings_State::hasE8State () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_AVM_FAP_SettingState T_AVM_Settings_State::getE8State () const {
    return _e8State;
}

inline void T_AVM_Settings_State::setE8State (T_e8_AVM_FAP_SettingState e8State_) {
    #ifndef NDEBUG
    if (!(T_e8_AVM_FAP_SettingState_IsValid(e8State_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8State_, "T_e8_AVM_FAP_SettingState", "e8State", "T_AVM_Settings_State");
    }
    #endif
    set_has_e8State();
    this->_e8State = e8State_;
}

inline void T_AVM_Settings_State::set_has_e8Type () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AVM_Settings_State::clear_has_e8Type () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AVM_Settings_State::set_has_e8State () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AVM_Settings_State::clear_has_e8State () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_GPS_Data::T_GPS_Data ()  :
    _GPS_latitude (0.0f),
    _GPS_longitude (0.0f),
    _GPS_altitude (0.0f),
    _GPS_azimuth (0.0f),
    _HDOP (0.0f),
    _VDOP (0.0f),
    _numOfSatellites (0u),
    _groundSpeed (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_GPS_Data::T_GPS_Data (const T_GPS_Data &rhs)  :
    _GPS_latitude (0.0f),
    _GPS_longitude (0.0f),
    _GPS_altitude (0.0f),
    _GPS_azimuth (0.0f),
    _HDOP (0.0f),
    _VDOP (0.0f),
    _numOfSatellites (0u),
    _groundSpeed (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_GPS_Data::T_GPS_Data (float GPS_latitude_, float GPS_longitude_, float GPS_altitude_, float GPS_azimuth_, float HDOP_, float VDOP_, uint32 numOfSatellites_, uint32 groundSpeed_)  :
    _GPS_latitude (GPS_latitude_),
    _GPS_longitude (GPS_longitude_),
    _GPS_altitude (GPS_altitude_),
    _GPS_azimuth (GPS_azimuth_),
    _HDOP (HDOP_),
    _VDOP (VDOP_),
    _numOfSatellites (numOfSatellites_),
    _groundSpeed (groundSpeed_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_GPS_Data::~T_GPS_Data() {
}

inline T_GPS_Data& T_GPS_Data::operator = (const T_GPS_Data& rhs) {
    if( this != &rhs ) {
        if (rhs.hasGPS_latitude()) {
            setGPS_latitude(rhs.getGPS_latitude());
        } else {
            clearGPS_latitude();
        }
        if (rhs.hasGPS_longitude()) {
            setGPS_longitude(rhs.getGPS_longitude());
        } else {
            clearGPS_longitude();
        }
        if (rhs.hasGPS_altitude()) {
            setGPS_altitude(rhs.getGPS_altitude());
        } else {
            clearGPS_altitude();
        }
        if (rhs.hasGPS_azimuth()) {
            setGPS_azimuth(rhs.getGPS_azimuth());
        } else {
            clearGPS_azimuth();
        }
        if (rhs.hasHDOP()) {
            setHDOP(rhs.getHDOP());
        } else {
            clearHDOP();
        }
        if (rhs.hasVDOP()) {
            setVDOP(rhs.getVDOP());
        } else {
            clearVDOP();
        }
        if (rhs.hasNumOfSatellites()) {
            setNumOfSatellites(rhs.getNumOfSatellites());
        } else {
            clearNumOfSatellites();
        }
        if (rhs.hasGroundSpeed()) {
            setGroundSpeed(rhs.getGroundSpeed());
        } else {
            clearGroundSpeed();
        }
    }
    return *this;
}

inline bool T_GPS_Data::operator == (const T_GPS_Data& rhs) const {
    return (((!hasGPS_latitude() && !rhs.hasGPS_latitude()) || getGPS_latitude() == rhs.getGPS_latitude()) &&
        ((!hasGPS_longitude() && !rhs.hasGPS_longitude()) || getGPS_longitude() == rhs.getGPS_longitude()) &&
        ((!hasGPS_altitude() && !rhs.hasGPS_altitude()) || getGPS_altitude() == rhs.getGPS_altitude()) &&
        ((!hasGPS_azimuth() && !rhs.hasGPS_azimuth()) || getGPS_azimuth() == rhs.getGPS_azimuth()) &&
        ((!hasHDOP() && !rhs.hasHDOP()) || getHDOP() == rhs.getHDOP()) &&
        ((!hasVDOP() && !rhs.hasVDOP()) || getVDOP() == rhs.getVDOP()) &&
        ((!hasNumOfSatellites() && !rhs.hasNumOfSatellites()) || getNumOfSatellites() == rhs.getNumOfSatellites()) &&
        ((!hasGroundSpeed() && !rhs.hasGroundSpeed()) || getGroundSpeed() == rhs.getGroundSpeed()));
}

inline bool T_GPS_Data::operator != (const T_GPS_Data& rhs) const {
    return ! (*this == rhs);
}

inline bool T_GPS_Data::operator < (const T_GPS_Data& rhs) const {
    if (hasGPS_latitude() || rhs.hasGPS_latitude()) {
        if (getGPS_latitude() < rhs.getGPS_latitude()) return true;
        if (getGPS_latitude() > rhs.getGPS_latitude()) return false;
    }
    if (hasGPS_longitude() || rhs.hasGPS_longitude()) {
        if (getGPS_longitude() < rhs.getGPS_longitude()) return true;
        if (getGPS_longitude() > rhs.getGPS_longitude()) return false;
    }
    if (hasGPS_altitude() || rhs.hasGPS_altitude()) {
        if (getGPS_altitude() < rhs.getGPS_altitude()) return true;
        if (getGPS_altitude() > rhs.getGPS_altitude()) return false;
    }
    if (hasGPS_azimuth() || rhs.hasGPS_azimuth()) {
        if (getGPS_azimuth() < rhs.getGPS_azimuth()) return true;
        if (getGPS_azimuth() > rhs.getGPS_azimuth()) return false;
    }
    if (hasHDOP() || rhs.hasHDOP()) {
        if (getHDOP() < rhs.getHDOP()) return true;
        if (getHDOP() > rhs.getHDOP()) return false;
    }
    if (hasVDOP() || rhs.hasVDOP()) {
        if (getVDOP() < rhs.getVDOP()) return true;
        if (getVDOP() > rhs.getVDOP()) return false;
    }
    if (hasNumOfSatellites() || rhs.hasNumOfSatellites()) {
        if (getNumOfSatellites() < rhs.getNumOfSatellites()) return true;
        if (getNumOfSatellites() > rhs.getNumOfSatellites()) return false;
    }
    if (hasGroundSpeed() || rhs.hasGroundSpeed()) {
        if (getGroundSpeed() < rhs.getGroundSpeed()) return true;
        if (getGroundSpeed() > rhs.getGroundSpeed()) return false;
    }
    return false;
}

inline bool T_GPS_Data::operator > (const T_GPS_Data& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_GPS_Data::clear() {
    clearGPS_latitude();
    clearGPS_longitude();
    clearGPS_altitude();
    clearGPS_azimuth();
    clearHDOP();
    clearVDOP();
    clearNumOfSatellites();
    clearGroundSpeed();
}

inline void T_GPS_Data::clearGPS_latitude() {
    if (hasGPS_latitude()) {
         clear_has_GPS_latitude();
        _GPS_latitude = 0.0f;
     }
}

inline bool T_GPS_Data::hasGPS_latitude () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline float T_GPS_Data::getGPS_latitude () const {
    return _GPS_latitude;
}

inline void T_GPS_Data::setGPS_latitude (float GPS_latitude_) {
    set_has_GPS_latitude();
    this->_GPS_latitude = GPS_latitude_;
}

inline void T_GPS_Data::clearGPS_longitude() {
    if (hasGPS_longitude()) {
         clear_has_GPS_longitude();
        _GPS_longitude = 0.0f;
     }
}

inline bool T_GPS_Data::hasGPS_longitude () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline float T_GPS_Data::getGPS_longitude () const {
    return _GPS_longitude;
}

inline void T_GPS_Data::setGPS_longitude (float GPS_longitude_) {
    set_has_GPS_longitude();
    this->_GPS_longitude = GPS_longitude_;
}

inline void T_GPS_Data::clearGPS_altitude() {
    if (hasGPS_altitude()) {
         clear_has_GPS_altitude();
        _GPS_altitude = 0.0f;
     }
}

inline bool T_GPS_Data::hasGPS_altitude () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline float T_GPS_Data::getGPS_altitude () const {
    return _GPS_altitude;
}

inline void T_GPS_Data::setGPS_altitude (float GPS_altitude_) {
    set_has_GPS_altitude();
    this->_GPS_altitude = GPS_altitude_;
}

inline void T_GPS_Data::clearGPS_azimuth() {
    if (hasGPS_azimuth()) {
         clear_has_GPS_azimuth();
        _GPS_azimuth = 0.0f;
     }
}

inline bool T_GPS_Data::hasGPS_azimuth () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline float T_GPS_Data::getGPS_azimuth () const {
    return _GPS_azimuth;
}

inline void T_GPS_Data::setGPS_azimuth (float GPS_azimuth_) {
    set_has_GPS_azimuth();
    this->_GPS_azimuth = GPS_azimuth_;
}

inline void T_GPS_Data::clearHDOP() {
    if (hasHDOP()) {
         clear_has_HDOP();
        _HDOP = 0.0f;
     }
}

inline bool T_GPS_Data::hasHDOP () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline float T_GPS_Data::getHDOP () const {
    return _HDOP;
}

inline void T_GPS_Data::setHDOP (float HDOP_) {
    set_has_HDOP();
    this->_HDOP = HDOP_;
}

inline void T_GPS_Data::clearVDOP() {
    if (hasVDOP()) {
         clear_has_VDOP();
        _VDOP = 0.0f;
     }
}

inline bool T_GPS_Data::hasVDOP () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline float T_GPS_Data::getVDOP () const {
    return _VDOP;
}

inline void T_GPS_Data::setVDOP (float VDOP_) {
    set_has_VDOP();
    this->_VDOP = VDOP_;
}

inline void T_GPS_Data::clearNumOfSatellites() {
    if (hasNumOfSatellites()) {
         clear_has_numOfSatellites();
        _numOfSatellites = 0u;
     }
}

inline bool T_GPS_Data::hasNumOfSatellites () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint32 T_GPS_Data::getNumOfSatellites () const {
    return _numOfSatellites;
}

inline void T_GPS_Data::setNumOfSatellites (uint32 numOfSatellites_) {
    set_has_numOfSatellites();
    this->_numOfSatellites = numOfSatellites_;
}

inline void T_GPS_Data::clearGroundSpeed() {
    if (hasGroundSpeed()) {
         clear_has_groundSpeed();
        _groundSpeed = 0u;
     }
}

inline bool T_GPS_Data::hasGroundSpeed () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint32 T_GPS_Data::getGroundSpeed () const {
    return _groundSpeed;
}

inline void T_GPS_Data::setGroundSpeed (uint32 groundSpeed_) {
    set_has_groundSpeed();
    this->_groundSpeed = groundSpeed_;
}

inline void T_GPS_Data::set_has_GPS_latitude () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_GPS_Data::clear_has_GPS_latitude () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_GPS_Data::set_has_GPS_longitude () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_GPS_Data::clear_has_GPS_longitude () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_GPS_Data::set_has_GPS_altitude () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_GPS_Data::clear_has_GPS_altitude () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_GPS_Data::set_has_GPS_azimuth () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_GPS_Data::clear_has_GPS_azimuth () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_GPS_Data::set_has_HDOP () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_GPS_Data::clear_has_HDOP () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_GPS_Data::set_has_VDOP () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_GPS_Data::clear_has_VDOP () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_GPS_Data::set_has_numOfSatellites () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_GPS_Data::clear_has_numOfSatellites () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_GPS_Data::set_has_groundSpeed () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_GPS_Data::clear_has_groundSpeed () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  T_MapMatched_Data::T_MapMatched_Data ()  :
    _MM_latitude (0.0f),
    _MM_longitude (0.0f),
    _MM_azimuth (0.0f),
    _MM_accuracy (0.0f)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MapMatched_Data::T_MapMatched_Data (const T_MapMatched_Data &rhs)  :
    _MM_latitude (0.0f),
    _MM_longitude (0.0f),
    _MM_azimuth (0.0f),
    _MM_accuracy (0.0f)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MapMatched_Data::T_MapMatched_Data (float MM_latitude_, float MM_longitude_, float MM_azimuth_, float MM_accuracy_)  :
    _MM_latitude (MM_latitude_),
    _MM_longitude (MM_longitude_),
    _MM_azimuth (MM_azimuth_),
    _MM_accuracy (MM_accuracy_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MapMatched_Data::~T_MapMatched_Data() {
}

inline T_MapMatched_Data& T_MapMatched_Data::operator = (const T_MapMatched_Data& rhs) {
    if( this != &rhs ) {
        if (rhs.hasMM_latitude()) {
            setMM_latitude(rhs.getMM_latitude());
        } else {
            clearMM_latitude();
        }
        if (rhs.hasMM_longitude()) {
            setMM_longitude(rhs.getMM_longitude());
        } else {
            clearMM_longitude();
        }
        if (rhs.hasMM_azimuth()) {
            setMM_azimuth(rhs.getMM_azimuth());
        } else {
            clearMM_azimuth();
        }
        if (rhs.hasMM_accuracy()) {
            setMM_accuracy(rhs.getMM_accuracy());
        } else {
            clearMM_accuracy();
        }
    }
    return *this;
}

inline bool T_MapMatched_Data::operator == (const T_MapMatched_Data& rhs) const {
    return (((!hasMM_latitude() && !rhs.hasMM_latitude()) || getMM_latitude() == rhs.getMM_latitude()) &&
        ((!hasMM_longitude() && !rhs.hasMM_longitude()) || getMM_longitude() == rhs.getMM_longitude()) &&
        ((!hasMM_azimuth() && !rhs.hasMM_azimuth()) || getMM_azimuth() == rhs.getMM_azimuth()) &&
        ((!hasMM_accuracy() && !rhs.hasMM_accuracy()) || getMM_accuracy() == rhs.getMM_accuracy()));
}

inline bool T_MapMatched_Data::operator != (const T_MapMatched_Data& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MapMatched_Data::operator < (const T_MapMatched_Data& rhs) const {
    if (hasMM_latitude() || rhs.hasMM_latitude()) {
        if (getMM_latitude() < rhs.getMM_latitude()) return true;
        if (getMM_latitude() > rhs.getMM_latitude()) return false;
    }
    if (hasMM_longitude() || rhs.hasMM_longitude()) {
        if (getMM_longitude() < rhs.getMM_longitude()) return true;
        if (getMM_longitude() > rhs.getMM_longitude()) return false;
    }
    if (hasMM_azimuth() || rhs.hasMM_azimuth()) {
        if (getMM_azimuth() < rhs.getMM_azimuth()) return true;
        if (getMM_azimuth() > rhs.getMM_azimuth()) return false;
    }
    if (hasMM_accuracy() || rhs.hasMM_accuracy()) {
        if (getMM_accuracy() < rhs.getMM_accuracy()) return true;
        if (getMM_accuracy() > rhs.getMM_accuracy()) return false;
    }
    return false;
}

inline bool T_MapMatched_Data::operator > (const T_MapMatched_Data& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MapMatched_Data::clear() {
    clearMM_latitude();
    clearMM_longitude();
    clearMM_azimuth();
    clearMM_accuracy();
}

inline void T_MapMatched_Data::clearMM_latitude() {
    if (hasMM_latitude()) {
         clear_has_MM_latitude();
        _MM_latitude = 0.0f;
     }
}

inline bool T_MapMatched_Data::hasMM_latitude () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline float T_MapMatched_Data::getMM_latitude () const {
    return _MM_latitude;
}

inline void T_MapMatched_Data::setMM_latitude (float MM_latitude_) {
    set_has_MM_latitude();
    this->_MM_latitude = MM_latitude_;
}

inline void T_MapMatched_Data::clearMM_longitude() {
    if (hasMM_longitude()) {
         clear_has_MM_longitude();
        _MM_longitude = 0.0f;
     }
}

inline bool T_MapMatched_Data::hasMM_longitude () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline float T_MapMatched_Data::getMM_longitude () const {
    return _MM_longitude;
}

inline void T_MapMatched_Data::setMM_longitude (float MM_longitude_) {
    set_has_MM_longitude();
    this->_MM_longitude = MM_longitude_;
}

inline void T_MapMatched_Data::clearMM_azimuth() {
    if (hasMM_azimuth()) {
         clear_has_MM_azimuth();
        _MM_azimuth = 0.0f;
     }
}

inline bool T_MapMatched_Data::hasMM_azimuth () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline float T_MapMatched_Data::getMM_azimuth () const {
    return _MM_azimuth;
}

inline void T_MapMatched_Data::setMM_azimuth (float MM_azimuth_) {
    set_has_MM_azimuth();
    this->_MM_azimuth = MM_azimuth_;
}

inline void T_MapMatched_Data::clearMM_accuracy() {
    if (hasMM_accuracy()) {
         clear_has_MM_accuracy();
        _MM_accuracy = 0.0f;
     }
}

inline bool T_MapMatched_Data::hasMM_accuracy () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline float T_MapMatched_Data::getMM_accuracy () const {
    return _MM_accuracy;
}

inline void T_MapMatched_Data::setMM_accuracy (float MM_accuracy_) {
    set_has_MM_accuracy();
    this->_MM_accuracy = MM_accuracy_;
}

inline void T_MapMatched_Data::set_has_MM_latitude () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MapMatched_Data::clear_has_MM_latitude () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MapMatched_Data::set_has_MM_longitude () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MapMatched_Data::clear_has_MM_longitude () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MapMatched_Data::set_has_MM_azimuth () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MapMatched_Data::clear_has_MM_azimuth () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_MapMatched_Data::set_has_MM_accuracy () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_MapMatched_Data::clear_has_MM_accuracy () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_Touch_Data::T_Touch_Data ()  :
    _x_ordinate (0u),
    _y_ordinate (0u),
    _x1_ordinate (0u),
    _y1_ordinate (0u),
    _e8Gesture (::rvc_cca_fi_types::T_e8_TouchGesture__None),
    _e8Direction (::rvc_cca_fi_types::T_e8_Direction__Invalid),
    _SpeedOfMovement (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_Touch_Data::T_Touch_Data (const T_Touch_Data &rhs)  :
    _x_ordinate (0u),
    _y_ordinate (0u),
    _x1_ordinate (0u),
    _y1_ordinate (0u),
    _e8Gesture (::rvc_cca_fi_types::T_e8_TouchGesture__None),
    _e8Direction (::rvc_cca_fi_types::T_e8_Direction__Invalid),
    _SpeedOfMovement (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_Touch_Data::T_Touch_Data (uint32 x_ordinate_, uint32 y_ordinate_, uint32 x1_ordinate_, uint32 y1_ordinate_, T_e8_TouchGesture e8Gesture_, T_e8_Direction e8Direction_, uint8 SpeedOfMovement_)  :
    _x_ordinate (x_ordinate_),
    _y_ordinate (y_ordinate_),
    _x1_ordinate (x1_ordinate_),
    _y1_ordinate (y1_ordinate_),
    _e8Gesture (e8Gesture_),
    _e8Direction (e8Direction_),
    _SpeedOfMovement (SpeedOfMovement_)
{
    #ifndef NDEBUG
    if (!(T_e8_TouchGesture_IsValid(e8Gesture_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Gesture_, "T_e8_TouchGesture", "e8Gesture", "T_Touch_Data");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_Direction_IsValid(e8Direction_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Direction_, "T_e8_Direction", "e8Direction", "T_Touch_Data");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_Touch_Data::~T_Touch_Data() {
}

inline T_Touch_Data& T_Touch_Data::operator = (const T_Touch_Data& rhs) {
    if( this != &rhs ) {
        if (rhs.hasX_ordinate()) {
            setX_ordinate(rhs.getX_ordinate());
        } else {
            clearX_ordinate();
        }
        if (rhs.hasY_ordinate()) {
            setY_ordinate(rhs.getY_ordinate());
        } else {
            clearY_ordinate();
        }
        if (rhs.hasX1_ordinate()) {
            setX1_ordinate(rhs.getX1_ordinate());
        } else {
            clearX1_ordinate();
        }
        if (rhs.hasY1_ordinate()) {
            setY1_ordinate(rhs.getY1_ordinate());
        } else {
            clearY1_ordinate();
        }
        if (rhs.hasE8Gesture()) {
            setE8Gesture(rhs.getE8Gesture());
        } else {
            clearE8Gesture();
        }
        if (rhs.hasE8Direction()) {
            setE8Direction(rhs.getE8Direction());
        } else {
            clearE8Direction();
        }
        if (rhs.hasSpeedOfMovement()) {
            setSpeedOfMovement(rhs.getSpeedOfMovement());
        } else {
            clearSpeedOfMovement();
        }
    }
    return *this;
}

inline bool T_Touch_Data::operator == (const T_Touch_Data& rhs) const {
    return (((!hasX_ordinate() && !rhs.hasX_ordinate()) || getX_ordinate() == rhs.getX_ordinate()) &&
        ((!hasY_ordinate() && !rhs.hasY_ordinate()) || getY_ordinate() == rhs.getY_ordinate()) &&
        ((!hasX1_ordinate() && !rhs.hasX1_ordinate()) || getX1_ordinate() == rhs.getX1_ordinate()) &&
        ((!hasY1_ordinate() && !rhs.hasY1_ordinate()) || getY1_ordinate() == rhs.getY1_ordinate()) &&
        ((!hasE8Gesture() && !rhs.hasE8Gesture()) || getE8Gesture() == rhs.getE8Gesture()) &&
        ((!hasE8Direction() && !rhs.hasE8Direction()) || getE8Direction() == rhs.getE8Direction()) &&
        ((!hasSpeedOfMovement() && !rhs.hasSpeedOfMovement()) || getSpeedOfMovement() == rhs.getSpeedOfMovement()));
}

inline bool T_Touch_Data::operator != (const T_Touch_Data& rhs) const {
    return ! (*this == rhs);
}

inline bool T_Touch_Data::operator < (const T_Touch_Data& rhs) const {
    if (hasX_ordinate() || rhs.hasX_ordinate()) {
        if (getX_ordinate() < rhs.getX_ordinate()) return true;
        if (getX_ordinate() > rhs.getX_ordinate()) return false;
    }
    if (hasY_ordinate() || rhs.hasY_ordinate()) {
        if (getY_ordinate() < rhs.getY_ordinate()) return true;
        if (getY_ordinate() > rhs.getY_ordinate()) return false;
    }
    if (hasX1_ordinate() || rhs.hasX1_ordinate()) {
        if (getX1_ordinate() < rhs.getX1_ordinate()) return true;
        if (getX1_ordinate() > rhs.getX1_ordinate()) return false;
    }
    if (hasY1_ordinate() || rhs.hasY1_ordinate()) {
        if (getY1_ordinate() < rhs.getY1_ordinate()) return true;
        if (getY1_ordinate() > rhs.getY1_ordinate()) return false;
    }
    if (hasE8Gesture() || rhs.hasE8Gesture()) {
        if ((uint32)getE8Gesture() < (uint32)rhs.getE8Gesture()) return true;
        if ((uint32)getE8Gesture() > (uint32)rhs.getE8Gesture()) return false;
    }
    if (hasE8Direction() || rhs.hasE8Direction()) {
        if ((uint32)getE8Direction() < (uint32)rhs.getE8Direction()) return true;
        if ((uint32)getE8Direction() > (uint32)rhs.getE8Direction()) return false;
    }
    if (hasSpeedOfMovement() || rhs.hasSpeedOfMovement()) {
        if (getSpeedOfMovement() < rhs.getSpeedOfMovement()) return true;
        if (getSpeedOfMovement() > rhs.getSpeedOfMovement()) return false;
    }
    return false;
}

inline bool T_Touch_Data::operator > (const T_Touch_Data& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_Touch_Data::clear() {
    clearX_ordinate();
    clearY_ordinate();
    clearX1_ordinate();
    clearY1_ordinate();
    clearE8Gesture();
    clearE8Direction();
    clearSpeedOfMovement();
}

inline void T_Touch_Data::clearX_ordinate() {
    if (hasX_ordinate()) {
         clear_has_x_ordinate();
        _x_ordinate = 0u;
     }
}

inline bool T_Touch_Data::hasX_ordinate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_Touch_Data::getX_ordinate () const {
    return _x_ordinate;
}

inline void T_Touch_Data::setX_ordinate (uint32 x_ordinate_) {
    set_has_x_ordinate();
    this->_x_ordinate = x_ordinate_;
}

inline void T_Touch_Data::clearY_ordinate() {
    if (hasY_ordinate()) {
         clear_has_y_ordinate();
        _y_ordinate = 0u;
     }
}

inline bool T_Touch_Data::hasY_ordinate () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_Touch_Data::getY_ordinate () const {
    return _y_ordinate;
}

inline void T_Touch_Data::setY_ordinate (uint32 y_ordinate_) {
    set_has_y_ordinate();
    this->_y_ordinate = y_ordinate_;
}

inline void T_Touch_Data::clearX1_ordinate() {
    if (hasX1_ordinate()) {
         clear_has_x1_ordinate();
        _x1_ordinate = 0u;
     }
}

inline bool T_Touch_Data::hasX1_ordinate () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_Touch_Data::getX1_ordinate () const {
    return _x1_ordinate;
}

inline void T_Touch_Data::setX1_ordinate (uint32 x1_ordinate_) {
    set_has_x1_ordinate();
    this->_x1_ordinate = x1_ordinate_;
}

inline void T_Touch_Data::clearY1_ordinate() {
    if (hasY1_ordinate()) {
         clear_has_y1_ordinate();
        _y1_ordinate = 0u;
     }
}

inline bool T_Touch_Data::hasY1_ordinate () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_Touch_Data::getY1_ordinate () const {
    return _y1_ordinate;
}

inline void T_Touch_Data::setY1_ordinate (uint32 y1_ordinate_) {
    set_has_y1_ordinate();
    this->_y1_ordinate = y1_ordinate_;
}

inline void T_Touch_Data::clearE8Gesture() {
    if (hasE8Gesture()) {
         clear_has_e8Gesture();
        _e8Gesture = ::rvc_cca_fi_types::T_e8_TouchGesture__None;
     }
}

inline bool T_Touch_Data::hasE8Gesture () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8_TouchGesture T_Touch_Data::getE8Gesture () const {
    return _e8Gesture;
}

inline void T_Touch_Data::setE8Gesture (T_e8_TouchGesture e8Gesture_) {
    #ifndef NDEBUG
    if (!(T_e8_TouchGesture_IsValid(e8Gesture_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Gesture_, "T_e8_TouchGesture", "e8Gesture", "T_Touch_Data");
    }
    #endif
    set_has_e8Gesture();
    this->_e8Gesture = e8Gesture_;
}

inline void T_Touch_Data::clearE8Direction() {
    if (hasE8Direction()) {
         clear_has_e8Direction();
        _e8Direction = ::rvc_cca_fi_types::T_e8_Direction__Invalid;
     }
}

inline bool T_Touch_Data::hasE8Direction () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline T_e8_Direction T_Touch_Data::getE8Direction () const {
    return _e8Direction;
}

inline void T_Touch_Data::setE8Direction (T_e8_Direction e8Direction_) {
    #ifndef NDEBUG
    if (!(T_e8_Direction_IsValid(e8Direction_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Direction_, "T_e8_Direction", "e8Direction", "T_Touch_Data");
    }
    #endif
    set_has_e8Direction();
    this->_e8Direction = e8Direction_;
}

inline void T_Touch_Data::clearSpeedOfMovement() {
    if (hasSpeedOfMovement()) {
         clear_has_SpeedOfMovement();
        _SpeedOfMovement = 0u;
     }
}

inline bool T_Touch_Data::hasSpeedOfMovement () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_Touch_Data::getSpeedOfMovement () const {
    return _SpeedOfMovement;
}

inline void T_Touch_Data::setSpeedOfMovement (uint8 SpeedOfMovement_) {
    set_has_SpeedOfMovement();
    this->_SpeedOfMovement = SpeedOfMovement_;
}

inline void T_Touch_Data::set_has_x_ordinate () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_Touch_Data::clear_has_x_ordinate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_Touch_Data::set_has_y_ordinate () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_Touch_Data::clear_has_y_ordinate () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_Touch_Data::set_has_x1_ordinate () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_Touch_Data::clear_has_x1_ordinate () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_Touch_Data::set_has_y1_ordinate () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_Touch_Data::clear_has_y1_ordinate () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_Touch_Data::set_has_e8Gesture () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_Touch_Data::clear_has_e8Gesture () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_Touch_Data::set_has_e8Direction () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_Touch_Data::clear_has_e8Direction () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_Touch_Data::set_has_SpeedOfMovement () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_Touch_Data::clear_has_SpeedOfMovement () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  T_AVMph3_SwitchDescriptor::T_AVMph3_SwitchDescriptor ()  :
    _Id (::rvc_cca_fi_types::T_e8_AVMph3_SwitchId__None),
    _Status (::rvc_cca_fi_types::T_e8_AVMph3_SwitchStatus__Normal)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AVMph3_SwitchDescriptor::T_AVMph3_SwitchDescriptor (const T_AVMph3_SwitchDescriptor &rhs)  :
    _Id (::rvc_cca_fi_types::T_e8_AVMph3_SwitchId__None),
    _Status (::rvc_cca_fi_types::T_e8_AVMph3_SwitchStatus__Normal)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AVMph3_SwitchDescriptor::T_AVMph3_SwitchDescriptor (T_e8_AVMph3_SwitchId Id_, T_e8_AVMph3_SwitchStatus Status_)  :
    _Id (Id_),
    _Status (Status_)
{
    #ifndef NDEBUG
    if (!(T_e8_AVMph3_SwitchId_IsValid(Id_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Id_, "T_e8_AVMph3_SwitchId", "Id", "T_AVMph3_SwitchDescriptor");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_AVMph3_SwitchStatus_IsValid(Status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_AVMph3_SwitchStatus", "Status", "T_AVMph3_SwitchDescriptor");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AVMph3_SwitchDescriptor::~T_AVMph3_SwitchDescriptor() {
}

inline T_AVMph3_SwitchDescriptor& T_AVMph3_SwitchDescriptor::operator = (const T_AVMph3_SwitchDescriptor& rhs) {
    if( this != &rhs ) {
        if (rhs.hasId()) {
            setId(rhs.getId());
        } else {
            clearId();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool T_AVMph3_SwitchDescriptor::operator == (const T_AVMph3_SwitchDescriptor& rhs) const {
    return (((!hasId() && !rhs.hasId()) || getId() == rhs.getId()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool T_AVMph3_SwitchDescriptor::operator != (const T_AVMph3_SwitchDescriptor& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AVMph3_SwitchDescriptor::operator < (const T_AVMph3_SwitchDescriptor& rhs) const {
    if (hasId() || rhs.hasId()) {
        if ((uint32)getId() < (uint32)rhs.getId()) return true;
        if ((uint32)getId() > (uint32)rhs.getId()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline bool T_AVMph3_SwitchDescriptor::operator > (const T_AVMph3_SwitchDescriptor& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AVMph3_SwitchDescriptor::clear() {
    clearId();
    clearStatus();
}

inline void T_AVMph3_SwitchDescriptor::clearId() {
    if (hasId()) {
         clear_has_Id();
        _Id = ::rvc_cca_fi_types::T_e8_AVMph3_SwitchId__None;
     }
}

inline bool T_AVMph3_SwitchDescriptor::hasId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_AVMph3_SwitchId T_AVMph3_SwitchDescriptor::getId () const {
    return _Id;
}

inline void T_AVMph3_SwitchDescriptor::setId (T_e8_AVMph3_SwitchId Id_) {
    #ifndef NDEBUG
    if (!(T_e8_AVMph3_SwitchId_IsValid(Id_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Id_, "T_e8_AVMph3_SwitchId", "Id", "T_AVMph3_SwitchDescriptor");
    }
    #endif
    set_has_Id();
    this->_Id = Id_;
}

inline void T_AVMph3_SwitchDescriptor::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::rvc_cca_fi_types::T_e8_AVMph3_SwitchStatus__Normal;
     }
}

inline bool T_AVMph3_SwitchDescriptor::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_AVMph3_SwitchStatus T_AVMph3_SwitchDescriptor::getStatus () const {
    return _Status;
}

inline void T_AVMph3_SwitchDescriptor::setStatus (T_e8_AVMph3_SwitchStatus Status_) {
    #ifndef NDEBUG
    if (!(T_e8_AVMph3_SwitchStatus_IsValid(Status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_AVMph3_SwitchStatus", "Status", "T_AVMph3_SwitchDescriptor");
    }
    #endif
    set_has_Status();
    this->_Status = Status_;
}

inline void T_AVMph3_SwitchDescriptor::set_has_Id () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AVMph3_SwitchDescriptor::clear_has_Id () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AVMph3_SwitchDescriptor::set_has_Status () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AVMph3_SwitchDescriptor::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_AVMph3_Setting_Item::T_AVMph3_Setting_Item ()  :
    _e8ItemId (::rvc_cca_fi_types::T_e8_AVMph3_SettingItemId__Vehicle_Speed),
    _u8ItemState (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AVMph3_Setting_Item::T_AVMph3_Setting_Item (const T_AVMph3_Setting_Item &rhs)  :
    _e8ItemId (::rvc_cca_fi_types::T_e8_AVMph3_SettingItemId__Vehicle_Speed),
    _u8ItemState (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AVMph3_Setting_Item::T_AVMph3_Setting_Item (T_e8_AVMph3_SettingItemId e8ItemId_, uint8 u8ItemState_)  :
    _e8ItemId (e8ItemId_),
    _u8ItemState (u8ItemState_)
{
    #ifndef NDEBUG
    if (!(T_e8_AVMph3_SettingItemId_IsValid(e8ItemId_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ItemId_, "T_e8_AVMph3_SettingItemId", "e8ItemId", "T_AVMph3_Setting_Item");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AVMph3_Setting_Item::~T_AVMph3_Setting_Item() {
}

inline T_AVMph3_Setting_Item& T_AVMph3_Setting_Item::operator = (const T_AVMph3_Setting_Item& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8ItemId()) {
            setE8ItemId(rhs.getE8ItemId());
        } else {
            clearE8ItemId();
        }
        if (rhs.hasU8ItemState()) {
            setU8ItemState(rhs.getU8ItemState());
        } else {
            clearU8ItemState();
        }
    }
    return *this;
}

inline bool T_AVMph3_Setting_Item::operator == (const T_AVMph3_Setting_Item& rhs) const {
    return (((!hasE8ItemId() && !rhs.hasE8ItemId()) || getE8ItemId() == rhs.getE8ItemId()) &&
        ((!hasU8ItemState() && !rhs.hasU8ItemState()) || getU8ItemState() == rhs.getU8ItemState()));
}

inline bool T_AVMph3_Setting_Item::operator != (const T_AVMph3_Setting_Item& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AVMph3_Setting_Item::operator < (const T_AVMph3_Setting_Item& rhs) const {
    if (hasE8ItemId() || rhs.hasE8ItemId()) {
        if ((uint32)getE8ItemId() < (uint32)rhs.getE8ItemId()) return true;
        if ((uint32)getE8ItemId() > (uint32)rhs.getE8ItemId()) return false;
    }
    if (hasU8ItemState() || rhs.hasU8ItemState()) {
        if (getU8ItemState() < rhs.getU8ItemState()) return true;
        if (getU8ItemState() > rhs.getU8ItemState()) return false;
    }
    return false;
}

inline bool T_AVMph3_Setting_Item::operator > (const T_AVMph3_Setting_Item& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AVMph3_Setting_Item::clear() {
    clearE8ItemId();
    clearU8ItemState();
}

inline void T_AVMph3_Setting_Item::clearE8ItemId() {
    if (hasE8ItemId()) {
         clear_has_e8ItemId();
        _e8ItemId = ::rvc_cca_fi_types::T_e8_AVMph3_SettingItemId__Vehicle_Speed;
     }
}

inline bool T_AVMph3_Setting_Item::hasE8ItemId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_AVMph3_SettingItemId T_AVMph3_Setting_Item::getE8ItemId () const {
    return _e8ItemId;
}

inline void T_AVMph3_Setting_Item::setE8ItemId (T_e8_AVMph3_SettingItemId e8ItemId_) {
    #ifndef NDEBUG
    if (!(T_e8_AVMph3_SettingItemId_IsValid(e8ItemId_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ItemId_, "T_e8_AVMph3_SettingItemId", "e8ItemId", "T_AVMph3_Setting_Item");
    }
    #endif
    set_has_e8ItemId();
    this->_e8ItemId = e8ItemId_;
}

inline void T_AVMph3_Setting_Item::clearU8ItemState() {
    if (hasU8ItemState()) {
         clear_has_u8ItemState();
        _u8ItemState = 0u;
     }
}

inline bool T_AVMph3_Setting_Item::hasU8ItemState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_AVMph3_Setting_Item::getU8ItemState () const {
    return _u8ItemState;
}

inline void T_AVMph3_Setting_Item::setU8ItemState (uint8 u8ItemState_) {
    set_has_u8ItemState();
    this->_u8ItemState = u8ItemState_;
}

inline void T_AVMph3_Setting_Item::set_has_e8ItemId () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AVMph3_Setting_Item::clear_has_e8ItemId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AVMph3_Setting_Item::set_has_u8ItemState () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AVMph3_Setting_Item::clear_has_u8ItemState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_AVMph3_Setting_Option::T_AVMph3_Setting_Option ()  :
    _e8ItemId (::rvc_cca_fi_types::T_e8_AVMph3_SettingItemId__Vehicle_Speed),
    _e8ItemState (::rvc_cca_fi_types::T_e8_AVMph3_SettingOptionState__Unavail)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AVMph3_Setting_Option::T_AVMph3_Setting_Option (const T_AVMph3_Setting_Option &rhs)  :
    _e8ItemId (::rvc_cca_fi_types::T_e8_AVMph3_SettingItemId__Vehicle_Speed),
    _e8ItemState (::rvc_cca_fi_types::T_e8_AVMph3_SettingOptionState__Unavail)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AVMph3_Setting_Option::T_AVMph3_Setting_Option (T_e8_AVMph3_SettingItemId e8ItemId_, T_e8_AVMph3_SettingOptionState e8ItemState_)  :
    _e8ItemId (e8ItemId_),
    _e8ItemState (e8ItemState_)
{
    #ifndef NDEBUG
    if (!(T_e8_AVMph3_SettingItemId_IsValid(e8ItemId_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ItemId_, "T_e8_AVMph3_SettingItemId", "e8ItemId", "T_AVMph3_Setting_Option");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_AVMph3_SettingOptionState_IsValid(e8ItemState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ItemState_, "T_e8_AVMph3_SettingOptionState", "e8ItemState", "T_AVMph3_Setting_Option");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AVMph3_Setting_Option::~T_AVMph3_Setting_Option() {
}

inline T_AVMph3_Setting_Option& T_AVMph3_Setting_Option::operator = (const T_AVMph3_Setting_Option& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8ItemId()) {
            setE8ItemId(rhs.getE8ItemId());
        } else {
            clearE8ItemId();
        }
        if (rhs.hasE8ItemState()) {
            setE8ItemState(rhs.getE8ItemState());
        } else {
            clearE8ItemState();
        }
    }
    return *this;
}

inline bool T_AVMph3_Setting_Option::operator == (const T_AVMph3_Setting_Option& rhs) const {
    return (((!hasE8ItemId() && !rhs.hasE8ItemId()) || getE8ItemId() == rhs.getE8ItemId()) &&
        ((!hasE8ItemState() && !rhs.hasE8ItemState()) || getE8ItemState() == rhs.getE8ItemState()));
}

inline bool T_AVMph3_Setting_Option::operator != (const T_AVMph3_Setting_Option& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AVMph3_Setting_Option::operator < (const T_AVMph3_Setting_Option& rhs) const {
    if (hasE8ItemId() || rhs.hasE8ItemId()) {
        if ((uint32)getE8ItemId() < (uint32)rhs.getE8ItemId()) return true;
        if ((uint32)getE8ItemId() > (uint32)rhs.getE8ItemId()) return false;
    }
    if (hasE8ItemState() || rhs.hasE8ItemState()) {
        if ((uint32)getE8ItemState() < (uint32)rhs.getE8ItemState()) return true;
        if ((uint32)getE8ItemState() > (uint32)rhs.getE8ItemState()) return false;
    }
    return false;
}

inline bool T_AVMph3_Setting_Option::operator > (const T_AVMph3_Setting_Option& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AVMph3_Setting_Option::clear() {
    clearE8ItemId();
    clearE8ItemState();
}

inline void T_AVMph3_Setting_Option::clearE8ItemId() {
    if (hasE8ItemId()) {
         clear_has_e8ItemId();
        _e8ItemId = ::rvc_cca_fi_types::T_e8_AVMph3_SettingItemId__Vehicle_Speed;
     }
}

inline bool T_AVMph3_Setting_Option::hasE8ItemId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_AVMph3_SettingItemId T_AVMph3_Setting_Option::getE8ItemId () const {
    return _e8ItemId;
}

inline void T_AVMph3_Setting_Option::setE8ItemId (T_e8_AVMph3_SettingItemId e8ItemId_) {
    #ifndef NDEBUG
    if (!(T_e8_AVMph3_SettingItemId_IsValid(e8ItemId_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ItemId_, "T_e8_AVMph3_SettingItemId", "e8ItemId", "T_AVMph3_Setting_Option");
    }
    #endif
    set_has_e8ItemId();
    this->_e8ItemId = e8ItemId_;
}

inline void T_AVMph3_Setting_Option::clearE8ItemState() {
    if (hasE8ItemState()) {
         clear_has_e8ItemState();
        _e8ItemState = ::rvc_cca_fi_types::T_e8_AVMph3_SettingOptionState__Unavail;
     }
}

inline bool T_AVMph3_Setting_Option::hasE8ItemState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_AVMph3_SettingOptionState T_AVMph3_Setting_Option::getE8ItemState () const {
    return _e8ItemState;
}

inline void T_AVMph3_Setting_Option::setE8ItemState (T_e8_AVMph3_SettingOptionState e8ItemState_) {
    #ifndef NDEBUG
    if (!(T_e8_AVMph3_SettingOptionState_IsValid(e8ItemState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ItemState_, "T_e8_AVMph3_SettingOptionState", "e8ItemState", "T_AVMph3_Setting_Option");
    }
    #endif
    set_has_e8ItemState();
    this->_e8ItemState = e8ItemState_;
}

inline void T_AVMph3_Setting_Option::set_has_e8ItemId () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AVMph3_Setting_Option::clear_has_e8ItemId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AVMph3_Setting_Option::set_has_e8ItemState () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AVMph3_Setting_Option::clear_has_e8ItemState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_AVMph3_Setting_CornerSonarSensLvl::T_AVMph3_Setting_CornerSonarSensLvl ()  :
    _bAvail (false),
    _e8Level (::rvc_cca_fi_types::T_e8_AVMph3_CornerSonarSensLvl__Level1)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AVMph3_Setting_CornerSonarSensLvl::T_AVMph3_Setting_CornerSonarSensLvl (const T_AVMph3_Setting_CornerSonarSensLvl &rhs)  :
    _bAvail (false),
    _e8Level (::rvc_cca_fi_types::T_e8_AVMph3_CornerSonarSensLvl__Level1)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AVMph3_Setting_CornerSonarSensLvl::T_AVMph3_Setting_CornerSonarSensLvl (bool bAvail_, T_e8_AVMph3_CornerSonarSensLvl e8Level_)  :
    _bAvail (bAvail_),
    _e8Level (e8Level_)
{
    #ifndef NDEBUG
    if (!(T_e8_AVMph3_CornerSonarSensLvl_IsValid(e8Level_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Level_, "T_e8_AVMph3_CornerSonarSensLvl", "e8Level", "T_AVMph3_Setting_CornerSonarSensLvl");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AVMph3_Setting_CornerSonarSensLvl::~T_AVMph3_Setting_CornerSonarSensLvl() {
}

inline T_AVMph3_Setting_CornerSonarSensLvl& T_AVMph3_Setting_CornerSonarSensLvl::operator = (const T_AVMph3_Setting_CornerSonarSensLvl& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBAvail()) {
            setBAvail(rhs.getBAvail());
        } else {
            clearBAvail();
        }
        if (rhs.hasE8Level()) {
            setE8Level(rhs.getE8Level());
        } else {
            clearE8Level();
        }
    }
    return *this;
}

inline bool T_AVMph3_Setting_CornerSonarSensLvl::operator == (const T_AVMph3_Setting_CornerSonarSensLvl& rhs) const {
    return (((!hasBAvail() && !rhs.hasBAvail()) || getBAvail() == rhs.getBAvail()) &&
        ((!hasE8Level() && !rhs.hasE8Level()) || getE8Level() == rhs.getE8Level()));
}

inline bool T_AVMph3_Setting_CornerSonarSensLvl::operator != (const T_AVMph3_Setting_CornerSonarSensLvl& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AVMph3_Setting_CornerSonarSensLvl::operator < (const T_AVMph3_Setting_CornerSonarSensLvl& rhs) const {
    if (hasBAvail() || rhs.hasBAvail()) {
        if (getBAvail() < rhs.getBAvail()) return true;
        if (getBAvail() > rhs.getBAvail()) return false;
    }
    if (hasE8Level() || rhs.hasE8Level()) {
        if ((uint32)getE8Level() < (uint32)rhs.getE8Level()) return true;
        if ((uint32)getE8Level() > (uint32)rhs.getE8Level()) return false;
    }
    return false;
}

inline bool T_AVMph3_Setting_CornerSonarSensLvl::operator > (const T_AVMph3_Setting_CornerSonarSensLvl& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AVMph3_Setting_CornerSonarSensLvl::clear() {
    clearBAvail();
    clearE8Level();
}

inline void T_AVMph3_Setting_CornerSonarSensLvl::clearBAvail() {
    if (hasBAvail()) {
         clear_has_bAvail();
        _bAvail = false;
     }
}

inline bool T_AVMph3_Setting_CornerSonarSensLvl::hasBAvail () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_AVMph3_Setting_CornerSonarSensLvl::getBAvail () const {
    return _bAvail;
}

inline void T_AVMph3_Setting_CornerSonarSensLvl::setBAvail (bool bAvail_) {
    set_has_bAvail();
    this->_bAvail = bAvail_;
}

inline void T_AVMph3_Setting_CornerSonarSensLvl::clearE8Level() {
    if (hasE8Level()) {
         clear_has_e8Level();
        _e8Level = ::rvc_cca_fi_types::T_e8_AVMph3_CornerSonarSensLvl__Level1;
     }
}

inline bool T_AVMph3_Setting_CornerSonarSensLvl::hasE8Level () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_AVMph3_CornerSonarSensLvl T_AVMph3_Setting_CornerSonarSensLvl::getE8Level () const {
    return _e8Level;
}

inline void T_AVMph3_Setting_CornerSonarSensLvl::setE8Level (T_e8_AVMph3_CornerSonarSensLvl e8Level_) {
    #ifndef NDEBUG
    if (!(T_e8_AVMph3_CornerSonarSensLvl_IsValid(e8Level_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Level_, "T_e8_AVMph3_CornerSonarSensLvl", "e8Level", "T_AVMph3_Setting_CornerSonarSensLvl");
    }
    #endif
    set_has_e8Level();
    this->_e8Level = e8Level_;
}

inline void T_AVMph3_Setting_CornerSonarSensLvl::set_has_bAvail () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AVMph3_Setting_CornerSonarSensLvl::clear_has_bAvail () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AVMph3_Setting_CornerSonarSensLvl::set_has_e8Level () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AVMph3_Setting_CornerSonarSensLvl::clear_has_e8Level () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_AVMph3_Setting_SonarSensLvl::T_AVMph3_Setting_SonarSensLvl ()  :
    _bAvail (false),
    _e8Level (::rvc_cca_fi_types::T_e8_AVMph3_SonarSensLvl__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AVMph3_Setting_SonarSensLvl::T_AVMph3_Setting_SonarSensLvl (const T_AVMph3_Setting_SonarSensLvl &rhs)  :
    _bAvail (false),
    _e8Level (::rvc_cca_fi_types::T_e8_AVMph3_SonarSensLvl__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AVMph3_Setting_SonarSensLvl::T_AVMph3_Setting_SonarSensLvl (bool bAvail_, T_e8_AVMph3_SonarSensLvl e8Level_)  :
    _bAvail (bAvail_),
    _e8Level (e8Level_)
{
    #ifndef NDEBUG
    if (!(T_e8_AVMph3_SonarSensLvl_IsValid(e8Level_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Level_, "T_e8_AVMph3_SonarSensLvl", "e8Level", "T_AVMph3_Setting_SonarSensLvl");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AVMph3_Setting_SonarSensLvl::~T_AVMph3_Setting_SonarSensLvl() {
}

inline T_AVMph3_Setting_SonarSensLvl& T_AVMph3_Setting_SonarSensLvl::operator = (const T_AVMph3_Setting_SonarSensLvl& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBAvail()) {
            setBAvail(rhs.getBAvail());
        } else {
            clearBAvail();
        }
        if (rhs.hasE8Level()) {
            setE8Level(rhs.getE8Level());
        } else {
            clearE8Level();
        }
    }
    return *this;
}

inline bool T_AVMph3_Setting_SonarSensLvl::operator == (const T_AVMph3_Setting_SonarSensLvl& rhs) const {
    return (((!hasBAvail() && !rhs.hasBAvail()) || getBAvail() == rhs.getBAvail()) &&
        ((!hasE8Level() && !rhs.hasE8Level()) || getE8Level() == rhs.getE8Level()));
}

inline bool T_AVMph3_Setting_SonarSensLvl::operator != (const T_AVMph3_Setting_SonarSensLvl& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AVMph3_Setting_SonarSensLvl::operator < (const T_AVMph3_Setting_SonarSensLvl& rhs) const {
    if (hasBAvail() || rhs.hasBAvail()) {
        if (getBAvail() < rhs.getBAvail()) return true;
        if (getBAvail() > rhs.getBAvail()) return false;
    }
    if (hasE8Level() || rhs.hasE8Level()) {
        if ((uint32)getE8Level() < (uint32)rhs.getE8Level()) return true;
        if ((uint32)getE8Level() > (uint32)rhs.getE8Level()) return false;
    }
    return false;
}

inline bool T_AVMph3_Setting_SonarSensLvl::operator > (const T_AVMph3_Setting_SonarSensLvl& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AVMph3_Setting_SonarSensLvl::clear() {
    clearBAvail();
    clearE8Level();
}

inline void T_AVMph3_Setting_SonarSensLvl::clearBAvail() {
    if (hasBAvail()) {
         clear_has_bAvail();
        _bAvail = false;
     }
}

inline bool T_AVMph3_Setting_SonarSensLvl::hasBAvail () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_AVMph3_Setting_SonarSensLvl::getBAvail () const {
    return _bAvail;
}

inline void T_AVMph3_Setting_SonarSensLvl::setBAvail (bool bAvail_) {
    set_has_bAvail();
    this->_bAvail = bAvail_;
}

inline void T_AVMph3_Setting_SonarSensLvl::clearE8Level() {
    if (hasE8Level()) {
         clear_has_e8Level();
        _e8Level = ::rvc_cca_fi_types::T_e8_AVMph3_SonarSensLvl__Undefined;
     }
}

inline bool T_AVMph3_Setting_SonarSensLvl::hasE8Level () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_AVMph3_SonarSensLvl T_AVMph3_Setting_SonarSensLvl::getE8Level () const {
    return _e8Level;
}

inline void T_AVMph3_Setting_SonarSensLvl::setE8Level (T_e8_AVMph3_SonarSensLvl e8Level_) {
    #ifndef NDEBUG
    if (!(T_e8_AVMph3_SonarSensLvl_IsValid(e8Level_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Level_, "T_e8_AVMph3_SonarSensLvl", "e8Level", "T_AVMph3_Setting_SonarSensLvl");
    }
    #endif
    set_has_e8Level();
    this->_e8Level = e8Level_;
}

inline void T_AVMph3_Setting_SonarSensLvl::set_has_bAvail () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AVMph3_Setting_SonarSensLvl::clear_has_bAvail () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AVMph3_Setting_SonarSensLvl::set_has_e8Level () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AVMph3_Setting_SonarSensLvl::clear_has_e8Level () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_AVMph3_Setting_BuzzerSoundLvl::T_AVMph3_Setting_BuzzerSoundLvl ()  :
    _bAvail (false),
    _e8Level (::rvc_cca_fi_types::T_e8_AVMph3_BuzzerSoundLvl__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AVMph3_Setting_BuzzerSoundLvl::T_AVMph3_Setting_BuzzerSoundLvl (const T_AVMph3_Setting_BuzzerSoundLvl &rhs)  :
    _bAvail (false),
    _e8Level (::rvc_cca_fi_types::T_e8_AVMph3_BuzzerSoundLvl__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AVMph3_Setting_BuzzerSoundLvl::T_AVMph3_Setting_BuzzerSoundLvl (bool bAvail_, T_e8_AVMph3_BuzzerSoundLvl e8Level_)  :
    _bAvail (bAvail_),
    _e8Level (e8Level_)
{
    #ifndef NDEBUG
    if (!(T_e8_AVMph3_BuzzerSoundLvl_IsValid(e8Level_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Level_, "T_e8_AVMph3_BuzzerSoundLvl", "e8Level", "T_AVMph3_Setting_BuzzerSoundLvl");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AVMph3_Setting_BuzzerSoundLvl::~T_AVMph3_Setting_BuzzerSoundLvl() {
}

inline T_AVMph3_Setting_BuzzerSoundLvl& T_AVMph3_Setting_BuzzerSoundLvl::operator = (const T_AVMph3_Setting_BuzzerSoundLvl& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBAvail()) {
            setBAvail(rhs.getBAvail());
        } else {
            clearBAvail();
        }
        if (rhs.hasE8Level()) {
            setE8Level(rhs.getE8Level());
        } else {
            clearE8Level();
        }
    }
    return *this;
}

inline bool T_AVMph3_Setting_BuzzerSoundLvl::operator == (const T_AVMph3_Setting_BuzzerSoundLvl& rhs) const {
    return (((!hasBAvail() && !rhs.hasBAvail()) || getBAvail() == rhs.getBAvail()) &&
        ((!hasE8Level() && !rhs.hasE8Level()) || getE8Level() == rhs.getE8Level()));
}

inline bool T_AVMph3_Setting_BuzzerSoundLvl::operator != (const T_AVMph3_Setting_BuzzerSoundLvl& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AVMph3_Setting_BuzzerSoundLvl::operator < (const T_AVMph3_Setting_BuzzerSoundLvl& rhs) const {
    if (hasBAvail() || rhs.hasBAvail()) {
        if (getBAvail() < rhs.getBAvail()) return true;
        if (getBAvail() > rhs.getBAvail()) return false;
    }
    if (hasE8Level() || rhs.hasE8Level()) {
        if ((uint32)getE8Level() < (uint32)rhs.getE8Level()) return true;
        if ((uint32)getE8Level() > (uint32)rhs.getE8Level()) return false;
    }
    return false;
}

inline bool T_AVMph3_Setting_BuzzerSoundLvl::operator > (const T_AVMph3_Setting_BuzzerSoundLvl& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AVMph3_Setting_BuzzerSoundLvl::clear() {
    clearBAvail();
    clearE8Level();
}

inline void T_AVMph3_Setting_BuzzerSoundLvl::clearBAvail() {
    if (hasBAvail()) {
         clear_has_bAvail();
        _bAvail = false;
     }
}

inline bool T_AVMph3_Setting_BuzzerSoundLvl::hasBAvail () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_AVMph3_Setting_BuzzerSoundLvl::getBAvail () const {
    return _bAvail;
}

inline void T_AVMph3_Setting_BuzzerSoundLvl::setBAvail (bool bAvail_) {
    set_has_bAvail();
    this->_bAvail = bAvail_;
}

inline void T_AVMph3_Setting_BuzzerSoundLvl::clearE8Level() {
    if (hasE8Level()) {
         clear_has_e8Level();
        _e8Level = ::rvc_cca_fi_types::T_e8_AVMph3_BuzzerSoundLvl__Undefined;
     }
}

inline bool T_AVMph3_Setting_BuzzerSoundLvl::hasE8Level () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_AVMph3_BuzzerSoundLvl T_AVMph3_Setting_BuzzerSoundLvl::getE8Level () const {
    return _e8Level;
}

inline void T_AVMph3_Setting_BuzzerSoundLvl::setE8Level (T_e8_AVMph3_BuzzerSoundLvl e8Level_) {
    #ifndef NDEBUG
    if (!(T_e8_AVMph3_BuzzerSoundLvl_IsValid(e8Level_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Level_, "T_e8_AVMph3_BuzzerSoundLvl", "e8Level", "T_AVMph3_Setting_BuzzerSoundLvl");
    }
    #endif
    set_has_e8Level();
    this->_e8Level = e8Level_;
}

inline void T_AVMph3_Setting_BuzzerSoundLvl::set_has_bAvail () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AVMph3_Setting_BuzzerSoundLvl::clear_has_bAvail () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AVMph3_Setting_BuzzerSoundLvl::set_has_e8Level () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AVMph3_Setting_BuzzerSoundLvl::clear_has_e8Level () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_AVMph3_VersionInfo::T_AVMph3_VersionInfo ()  :
    _u8Upper (0u),
    _u8Middle (0u),
    _u8Lower (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AVMph3_VersionInfo::T_AVMph3_VersionInfo (const T_AVMph3_VersionInfo &rhs)  :
    _u8Upper (0u),
    _u8Middle (0u),
    _u8Lower (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AVMph3_VersionInfo::T_AVMph3_VersionInfo (uint8 u8Upper_, uint8 u8Middle_, uint8 u8Lower_)  :
    _u8Upper (u8Upper_),
    _u8Middle (u8Middle_),
    _u8Lower (u8Lower_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AVMph3_VersionInfo::~T_AVMph3_VersionInfo() {
}

inline T_AVMph3_VersionInfo& T_AVMph3_VersionInfo::operator = (const T_AVMph3_VersionInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8Upper()) {
            setU8Upper(rhs.getU8Upper());
        } else {
            clearU8Upper();
        }
        if (rhs.hasU8Middle()) {
            setU8Middle(rhs.getU8Middle());
        } else {
            clearU8Middle();
        }
        if (rhs.hasU8Lower()) {
            setU8Lower(rhs.getU8Lower());
        } else {
            clearU8Lower();
        }
    }
    return *this;
}

inline bool T_AVMph3_VersionInfo::operator == (const T_AVMph3_VersionInfo& rhs) const {
    return (((!hasU8Upper() && !rhs.hasU8Upper()) || getU8Upper() == rhs.getU8Upper()) &&
        ((!hasU8Middle() && !rhs.hasU8Middle()) || getU8Middle() == rhs.getU8Middle()) &&
        ((!hasU8Lower() && !rhs.hasU8Lower()) || getU8Lower() == rhs.getU8Lower()));
}

inline bool T_AVMph3_VersionInfo::operator != (const T_AVMph3_VersionInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AVMph3_VersionInfo::operator < (const T_AVMph3_VersionInfo& rhs) const {
    if (hasU8Upper() || rhs.hasU8Upper()) {
        if (getU8Upper() < rhs.getU8Upper()) return true;
        if (getU8Upper() > rhs.getU8Upper()) return false;
    }
    if (hasU8Middle() || rhs.hasU8Middle()) {
        if (getU8Middle() < rhs.getU8Middle()) return true;
        if (getU8Middle() > rhs.getU8Middle()) return false;
    }
    if (hasU8Lower() || rhs.hasU8Lower()) {
        if (getU8Lower() < rhs.getU8Lower()) return true;
        if (getU8Lower() > rhs.getU8Lower()) return false;
    }
    return false;
}

inline bool T_AVMph3_VersionInfo::operator > (const T_AVMph3_VersionInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AVMph3_VersionInfo::clear() {
    clearU8Upper();
    clearU8Middle();
    clearU8Lower();
}

inline void T_AVMph3_VersionInfo::clearU8Upper() {
    if (hasU8Upper()) {
         clear_has_u8Upper();
        _u8Upper = 0u;
     }
}

inline bool T_AVMph3_VersionInfo::hasU8Upper () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_AVMph3_VersionInfo::getU8Upper () const {
    return _u8Upper;
}

inline void T_AVMph3_VersionInfo::setU8Upper (uint8 u8Upper_) {
    set_has_u8Upper();
    this->_u8Upper = u8Upper_;
}

inline void T_AVMph3_VersionInfo::clearU8Middle() {
    if (hasU8Middle()) {
         clear_has_u8Middle();
        _u8Middle = 0u;
     }
}

inline bool T_AVMph3_VersionInfo::hasU8Middle () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_AVMph3_VersionInfo::getU8Middle () const {
    return _u8Middle;
}

inline void T_AVMph3_VersionInfo::setU8Middle (uint8 u8Middle_) {
    set_has_u8Middle();
    this->_u8Middle = u8Middle_;
}

inline void T_AVMph3_VersionInfo::clearU8Lower() {
    if (hasU8Lower()) {
         clear_has_u8Lower();
        _u8Lower = 0u;
     }
}

inline bool T_AVMph3_VersionInfo::hasU8Lower () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_AVMph3_VersionInfo::getU8Lower () const {
    return _u8Lower;
}

inline void T_AVMph3_VersionInfo::setU8Lower (uint8 u8Lower_) {
    set_has_u8Lower();
    this->_u8Lower = u8Lower_;
}

inline void T_AVMph3_VersionInfo::set_has_u8Upper () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AVMph3_VersionInfo::clear_has_u8Upper () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AVMph3_VersionInfo::set_has_u8Middle () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AVMph3_VersionInfo::clear_has_u8Middle () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_AVMph3_VersionInfo::set_has_u8Lower () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_AVMph3_VersionInfo::clear_has_u8Lower () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_AVMph3_Unit_ID::T_AVMph3_Unit_ID ()  :
    _u8Unit_ID (0u),
    _e8Variant (::rvc_cca_fi_types::T_e8_AVMph3_Variant__Var_06AVM),
    _bLeftHandDrive (false),
    _bWithSonar (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AVMph3_Unit_ID::T_AVMph3_Unit_ID (const T_AVMph3_Unit_ID &rhs)  :
    _u8Unit_ID (0u),
    _e8Variant (::rvc_cca_fi_types::T_e8_AVMph3_Variant__Var_06AVM),
    _bLeftHandDrive (false),
    _bWithSonar (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AVMph3_Unit_ID::T_AVMph3_Unit_ID (uint8 u8Unit_ID_, T_e8_AVMph3_Variant e8Variant_, bool bLeftHandDrive_, bool bWithSonar_)  :
    _u8Unit_ID (u8Unit_ID_),
    _e8Variant (e8Variant_),
    _bLeftHandDrive (bLeftHandDrive_),
    _bWithSonar (bWithSonar_)
{
    #ifndef NDEBUG
    if (!(T_e8_AVMph3_Variant_IsValid(e8Variant_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Variant_, "T_e8_AVMph3_Variant", "e8Variant", "T_AVMph3_Unit_ID");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AVMph3_Unit_ID::~T_AVMph3_Unit_ID() {
}

inline T_AVMph3_Unit_ID& T_AVMph3_Unit_ID::operator = (const T_AVMph3_Unit_ID& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8Unit_ID()) {
            setU8Unit_ID(rhs.getU8Unit_ID());
        } else {
            clearU8Unit_ID();
        }
        if (rhs.hasE8Variant()) {
            setE8Variant(rhs.getE8Variant());
        } else {
            clearE8Variant();
        }
        if (rhs.hasBLeftHandDrive()) {
            setBLeftHandDrive(rhs.getBLeftHandDrive());
        } else {
            clearBLeftHandDrive();
        }
        if (rhs.hasBWithSonar()) {
            setBWithSonar(rhs.getBWithSonar());
        } else {
            clearBWithSonar();
        }
    }
    return *this;
}

inline bool T_AVMph3_Unit_ID::operator == (const T_AVMph3_Unit_ID& rhs) const {
    return (((!hasU8Unit_ID() && !rhs.hasU8Unit_ID()) || getU8Unit_ID() == rhs.getU8Unit_ID()) &&
        ((!hasE8Variant() && !rhs.hasE8Variant()) || getE8Variant() == rhs.getE8Variant()) &&
        ((!hasBLeftHandDrive() && !rhs.hasBLeftHandDrive()) || getBLeftHandDrive() == rhs.getBLeftHandDrive()) &&
        ((!hasBWithSonar() && !rhs.hasBWithSonar()) || getBWithSonar() == rhs.getBWithSonar()));
}

inline bool T_AVMph3_Unit_ID::operator != (const T_AVMph3_Unit_ID& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AVMph3_Unit_ID::operator < (const T_AVMph3_Unit_ID& rhs) const {
    if (hasU8Unit_ID() || rhs.hasU8Unit_ID()) {
        if (getU8Unit_ID() < rhs.getU8Unit_ID()) return true;
        if (getU8Unit_ID() > rhs.getU8Unit_ID()) return false;
    }
    if (hasE8Variant() || rhs.hasE8Variant()) {
        if ((uint32)getE8Variant() < (uint32)rhs.getE8Variant()) return true;
        if ((uint32)getE8Variant() > (uint32)rhs.getE8Variant()) return false;
    }
    if (hasBLeftHandDrive() || rhs.hasBLeftHandDrive()) {
        if (getBLeftHandDrive() < rhs.getBLeftHandDrive()) return true;
        if (getBLeftHandDrive() > rhs.getBLeftHandDrive()) return false;
    }
    if (hasBWithSonar() || rhs.hasBWithSonar()) {
        if (getBWithSonar() < rhs.getBWithSonar()) return true;
        if (getBWithSonar() > rhs.getBWithSonar()) return false;
    }
    return false;
}

inline bool T_AVMph3_Unit_ID::operator > (const T_AVMph3_Unit_ID& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AVMph3_Unit_ID::clear() {
    clearU8Unit_ID();
    clearE8Variant();
    clearBLeftHandDrive();
    clearBWithSonar();
}

inline void T_AVMph3_Unit_ID::clearU8Unit_ID() {
    if (hasU8Unit_ID()) {
         clear_has_u8Unit_ID();
        _u8Unit_ID = 0u;
     }
}

inline bool T_AVMph3_Unit_ID::hasU8Unit_ID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_AVMph3_Unit_ID::getU8Unit_ID () const {
    return _u8Unit_ID;
}

inline void T_AVMph3_Unit_ID::setU8Unit_ID (uint8 u8Unit_ID_) {
    set_has_u8Unit_ID();
    this->_u8Unit_ID = u8Unit_ID_;
}

inline void T_AVMph3_Unit_ID::clearE8Variant() {
    if (hasE8Variant()) {
         clear_has_e8Variant();
        _e8Variant = ::rvc_cca_fi_types::T_e8_AVMph3_Variant__Var_06AVM;
     }
}

inline bool T_AVMph3_Unit_ID::hasE8Variant () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_AVMph3_Variant T_AVMph3_Unit_ID::getE8Variant () const {
    return _e8Variant;
}

inline void T_AVMph3_Unit_ID::setE8Variant (T_e8_AVMph3_Variant e8Variant_) {
    #ifndef NDEBUG
    if (!(T_e8_AVMph3_Variant_IsValid(e8Variant_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Variant_, "T_e8_AVMph3_Variant", "e8Variant", "T_AVMph3_Unit_ID");
    }
    #endif
    set_has_e8Variant();
    this->_e8Variant = e8Variant_;
}

inline void T_AVMph3_Unit_ID::clearBLeftHandDrive() {
    if (hasBLeftHandDrive()) {
         clear_has_bLeftHandDrive();
        _bLeftHandDrive = false;
     }
}

inline bool T_AVMph3_Unit_ID::hasBLeftHandDrive () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_AVMph3_Unit_ID::getBLeftHandDrive () const {
    return _bLeftHandDrive;
}

inline void T_AVMph3_Unit_ID::setBLeftHandDrive (bool bLeftHandDrive_) {
    set_has_bLeftHandDrive();
    this->_bLeftHandDrive = bLeftHandDrive_;
}

inline void T_AVMph3_Unit_ID::clearBWithSonar() {
    if (hasBWithSonar()) {
         clear_has_bWithSonar();
        _bWithSonar = false;
     }
}

inline bool T_AVMph3_Unit_ID::hasBWithSonar () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool T_AVMph3_Unit_ID::getBWithSonar () const {
    return _bWithSonar;
}

inline void T_AVMph3_Unit_ID::setBWithSonar (bool bWithSonar_) {
    set_has_bWithSonar();
    this->_bWithSonar = bWithSonar_;
}

inline void T_AVMph3_Unit_ID::set_has_u8Unit_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AVMph3_Unit_ID::clear_has_u8Unit_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AVMph3_Unit_ID::set_has_e8Variant () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AVMph3_Unit_ID::clear_has_e8Variant () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_AVMph3_Unit_ID::set_has_bLeftHandDrive () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_AVMph3_Unit_ID::clear_has_bLeftHandDrive () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_AVMph3_Unit_ID::set_has_bWithSonar () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_AVMph3_Unit_ID::clear_has_bWithSonar () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_AVMph3_MCAN_CommunicationErrors::T_AVMph3_MCAN_CommunicationErrors ()  :
    _u8BusOff (0u),
    _u8TxCmfToMaster (0u),
    _u8RxCmfFromSonar (0u),
    _u8TxMpdtToSonar (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AVMph3_MCAN_CommunicationErrors::T_AVMph3_MCAN_CommunicationErrors (const T_AVMph3_MCAN_CommunicationErrors &rhs)  :
    _u8BusOff (0u),
    _u8TxCmfToMaster (0u),
    _u8RxCmfFromSonar (0u),
    _u8TxMpdtToSonar (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AVMph3_MCAN_CommunicationErrors::T_AVMph3_MCAN_CommunicationErrors (uint8 u8BusOff_, uint8 u8TxCmfToMaster_, uint8 u8RxCmfFromSonar_, uint8 u8TxMpdtToSonar_)  :
    _u8BusOff (u8BusOff_),
    _u8TxCmfToMaster (u8TxCmfToMaster_),
    _u8RxCmfFromSonar (u8RxCmfFromSonar_),
    _u8TxMpdtToSonar (u8TxMpdtToSonar_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AVMph3_MCAN_CommunicationErrors::~T_AVMph3_MCAN_CommunicationErrors() {
}

inline T_AVMph3_MCAN_CommunicationErrors& T_AVMph3_MCAN_CommunicationErrors::operator = (const T_AVMph3_MCAN_CommunicationErrors& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8BusOff()) {
            setU8BusOff(rhs.getU8BusOff());
        } else {
            clearU8BusOff();
        }
        if (rhs.hasU8TxCmfToMaster()) {
            setU8TxCmfToMaster(rhs.getU8TxCmfToMaster());
        } else {
            clearU8TxCmfToMaster();
        }
        if (rhs.hasU8RxCmfFromSonar()) {
            setU8RxCmfFromSonar(rhs.getU8RxCmfFromSonar());
        } else {
            clearU8RxCmfFromSonar();
        }
        if (rhs.hasU8TxMpdtToSonar()) {
            setU8TxMpdtToSonar(rhs.getU8TxMpdtToSonar());
        } else {
            clearU8TxMpdtToSonar();
        }
    }
    return *this;
}

inline bool T_AVMph3_MCAN_CommunicationErrors::operator == (const T_AVMph3_MCAN_CommunicationErrors& rhs) const {
    return (((!hasU8BusOff() && !rhs.hasU8BusOff()) || getU8BusOff() == rhs.getU8BusOff()) &&
        ((!hasU8TxCmfToMaster() && !rhs.hasU8TxCmfToMaster()) || getU8TxCmfToMaster() == rhs.getU8TxCmfToMaster()) &&
        ((!hasU8RxCmfFromSonar() && !rhs.hasU8RxCmfFromSonar()) || getU8RxCmfFromSonar() == rhs.getU8RxCmfFromSonar()) &&
        ((!hasU8TxMpdtToSonar() && !rhs.hasU8TxMpdtToSonar()) || getU8TxMpdtToSonar() == rhs.getU8TxMpdtToSonar()));
}

inline bool T_AVMph3_MCAN_CommunicationErrors::operator != (const T_AVMph3_MCAN_CommunicationErrors& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AVMph3_MCAN_CommunicationErrors::operator < (const T_AVMph3_MCAN_CommunicationErrors& rhs) const {
    if (hasU8BusOff() || rhs.hasU8BusOff()) {
        if (getU8BusOff() < rhs.getU8BusOff()) return true;
        if (getU8BusOff() > rhs.getU8BusOff()) return false;
    }
    if (hasU8TxCmfToMaster() || rhs.hasU8TxCmfToMaster()) {
        if (getU8TxCmfToMaster() < rhs.getU8TxCmfToMaster()) return true;
        if (getU8TxCmfToMaster() > rhs.getU8TxCmfToMaster()) return false;
    }
    if (hasU8RxCmfFromSonar() || rhs.hasU8RxCmfFromSonar()) {
        if (getU8RxCmfFromSonar() < rhs.getU8RxCmfFromSonar()) return true;
        if (getU8RxCmfFromSonar() > rhs.getU8RxCmfFromSonar()) return false;
    }
    if (hasU8TxMpdtToSonar() || rhs.hasU8TxMpdtToSonar()) {
        if (getU8TxMpdtToSonar() < rhs.getU8TxMpdtToSonar()) return true;
        if (getU8TxMpdtToSonar() > rhs.getU8TxMpdtToSonar()) return false;
    }
    return false;
}

inline bool T_AVMph3_MCAN_CommunicationErrors::operator > (const T_AVMph3_MCAN_CommunicationErrors& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AVMph3_MCAN_CommunicationErrors::clear() {
    clearU8BusOff();
    clearU8TxCmfToMaster();
    clearU8RxCmfFromSonar();
    clearU8TxMpdtToSonar();
}

inline void T_AVMph3_MCAN_CommunicationErrors::clearU8BusOff() {
    if (hasU8BusOff()) {
         clear_has_u8BusOff();
        _u8BusOff = 0u;
     }
}

inline bool T_AVMph3_MCAN_CommunicationErrors::hasU8BusOff () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_AVMph3_MCAN_CommunicationErrors::getU8BusOff () const {
    return _u8BusOff;
}

inline void T_AVMph3_MCAN_CommunicationErrors::setU8BusOff (uint8 u8BusOff_) {
    set_has_u8BusOff();
    this->_u8BusOff = u8BusOff_;
}

inline void T_AVMph3_MCAN_CommunicationErrors::clearU8TxCmfToMaster() {
    if (hasU8TxCmfToMaster()) {
         clear_has_u8TxCmfToMaster();
        _u8TxCmfToMaster = 0u;
     }
}

inline bool T_AVMph3_MCAN_CommunicationErrors::hasU8TxCmfToMaster () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_AVMph3_MCAN_CommunicationErrors::getU8TxCmfToMaster () const {
    return _u8TxCmfToMaster;
}

inline void T_AVMph3_MCAN_CommunicationErrors::setU8TxCmfToMaster (uint8 u8TxCmfToMaster_) {
    set_has_u8TxCmfToMaster();
    this->_u8TxCmfToMaster = u8TxCmfToMaster_;
}

inline void T_AVMph3_MCAN_CommunicationErrors::clearU8RxCmfFromSonar() {
    if (hasU8RxCmfFromSonar()) {
         clear_has_u8RxCmfFromSonar();
        _u8RxCmfFromSonar = 0u;
     }
}

inline bool T_AVMph3_MCAN_CommunicationErrors::hasU8RxCmfFromSonar () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_AVMph3_MCAN_CommunicationErrors::getU8RxCmfFromSonar () const {
    return _u8RxCmfFromSonar;
}

inline void T_AVMph3_MCAN_CommunicationErrors::setU8RxCmfFromSonar (uint8 u8RxCmfFromSonar_) {
    set_has_u8RxCmfFromSonar();
    this->_u8RxCmfFromSonar = u8RxCmfFromSonar_;
}

inline void T_AVMph3_MCAN_CommunicationErrors::clearU8TxMpdtToSonar() {
    if (hasU8TxMpdtToSonar()) {
         clear_has_u8TxMpdtToSonar();
        _u8TxMpdtToSonar = 0u;
     }
}

inline bool T_AVMph3_MCAN_CommunicationErrors::hasU8TxMpdtToSonar () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_AVMph3_MCAN_CommunicationErrors::getU8TxMpdtToSonar () const {
    return _u8TxMpdtToSonar;
}

inline void T_AVMph3_MCAN_CommunicationErrors::setU8TxMpdtToSonar (uint8 u8TxMpdtToSonar_) {
    set_has_u8TxMpdtToSonar();
    this->_u8TxMpdtToSonar = u8TxMpdtToSonar_;
}

inline void T_AVMph3_MCAN_CommunicationErrors::set_has_u8BusOff () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AVMph3_MCAN_CommunicationErrors::clear_has_u8BusOff () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AVMph3_MCAN_CommunicationErrors::set_has_u8TxCmfToMaster () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AVMph3_MCAN_CommunicationErrors::clear_has_u8TxCmfToMaster () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_AVMph3_MCAN_CommunicationErrors::set_has_u8RxCmfFromSonar () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_AVMph3_MCAN_CommunicationErrors::clear_has_u8RxCmfFromSonar () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_AVMph3_MCAN_CommunicationErrors::set_has_u8TxMpdtToSonar () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_AVMph3_MCAN_CommunicationErrors::clear_has_u8TxMpdtToSonar () {
    _has_bits_[0] &= ~ (1u << 3);
}

} // namespace rvc_cca_fi_types

#endif // RVC_CCA_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
