#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef RVC_CCA_FI_H
#define RVC_CCA_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "rvc_cca_fi_types.h"
#include "rvc_cca_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'rvc_cca_fi'
 *
 * Fullname: RVC CCA Service, Application Functional Interface
 *
 * Version: $Revision:   1.0.0  $
 *
 * Author: Niemann, Wenzel
 *
 * Date: $Date:  17.04.2015  $
 *
 * Department:
 *
 * Title: rvc_cca_fi
 *
 * <b>Description of 'rvc_cca_fi':</b>
 *
 * Interface for accessing RVC (Rear View Camera), AVM (Around View Monitor), IPA (Intelligent Park Assistant), MVC (Multi View Camera) related functionalities.
 */

namespace rvc_cca_fi {

static const int SERVICE_ID = 65;

static const int FID_SystemConfigurations = 16384;

static const int FID_SystemStatus = 16385;

static const int FID_VideoSignalStatus = 16386;

static const int FID_ReverseSignalStatus = 16387;

static const int FID_Camera_PwrSupplyStatus = 16388;

static const int FID_Microphone_PwrSupplyStatus = 16389;

static const int FID_Tailgate_Status = 16390;

static const int FID_View_Close_Authorized = 16640;

static const int FID_AvmR_Current_View = 16641;

static const int FID_Affordable_ITS = 16896;

static const int FID_IPAConfiguration = 17152;

static const int FID_IPAStatus = 17153;

static const int FID_IPAPatternRequest = 17154;

static const int FID_IPAMessageRequest = 17155;

static const int FID_IPASwitchMaskRequest = 17157;

static const int FID_IPASwitchGreyOutRequest = 17158;

static const int FID_IPADirectionIndicator = 17161;

static const int FID_GdlAdj_SteeringAngle = 17664;

static const int FID_GdlAdj_CameraAngle = 17665;

static const int FID_CANFrameStatus = 17920;

static const int FID_MvcViewStatus = 17921;

static const int FID_MvcAlertRequest = 17922;

static const int FID_FAPMode = 18176;

static const int FID_FAPSettings = 18177;

static const int FID_FAPGuidanceState = 18178;

static const int FID_AVM3_DispStatus = 18432;

static const int FID_AVM3_ViewSetup = 18433;

static const int FID_AVM3_ErrorMessage = 18434;

static const int FID_AVM3_SonarBuzzerStatus = 18435;

static const int FID_AVM3_Settings_Detailed = 18436;

static const int FID_AVM3_Settings_Primary = 18437;

static const int FID_AVM3_Configuration = 18438;

static const int FID_AVM3_Software_Version = 18439;

static const int FID_AVM3_Hardware_Version = 18440;

static const int FID_AVM3_CommunicationErrors = 18441;

static const int FID_CameraButton = 32769;

static const int FID_SetStatusHmi = 32770;

static const int FID_SetupLanguage = 32771;

static const int FID_SetupGuideLine = 32772;

static const int FID_SetupVideoControls = 32773;

static const int FID_SetSystemStatus = 32774;

static const int FID_runExtDevicePowerSupplyTest = 32775;

static const int FID_Initialize = 32776;

static const int FID_ConfirmSystemStatus = 32777;

static const int FID_SetupUserConfiguration = 32778;

static const int FID_SetMicrophoneState = 32779;

static const int FID_SetRVCStatus = 32780;

static const int FID_Camera_SetupBeep = 33024;

static const int FID_SetCamerastate = 33025;

static const int FID_ChangeViewRequest = 33026;

static const int FID_Affordable_Its_SetupBsw = 33280;

static const int FID_Affordable_Its_SetupMod = 33281;

static const int FID_Affordable_Its_SetupLdw = 33282;

static const int FID_IPA_SetHMIStatus = 33536;

static const int FID_IPA_SetButton = 33537;

static const int FID_IPA_Voice_Texts = 33538;

static const int FID_MVC_HMI_ViewRequest = 33792;

static const int FID_GdlAdj_AdjustmentComplete = 34048;

static const int FID_GdlAdj_AdjustButton = 34049;

static const int FID_GdlAdj_ConfigurationData = 34050;

static const int FID_FAP_SetButton = 34304;

static const int FID_TouchEvent = 34305;

static const int FID_GPSInfo = 34306;

static const int FID_MapMatchedInfo = 34307;

static const int FID_FapLearnParkPosition = 34308;

static const int FID_SetFapGuidance = 34309;

static const int FID_AVM3_SetSwitch = 34816;

static const int FID_AVM3_SetSonarBuzzerStatus = 34817;

static const int FID_AVM3_Settings_Detailed_SendReq = 34818;

static const int FID_AVM3_Settings_Primary_SendReq = 34819;

static const int FID_AVM3_GetVersionInfo = 34820;

static const int FID_AVM3_GetCommunicationErrors = 34821;

static const int FID_AVM3_ClearCommunicationErrors = 34822;

static const int FID_ToggleGpioPinOnOff = 34823;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class SystemConfigurationsStatus;

class SystemConfigurationsErrorStructure;

class SystemConfigurationsError;

class SystemStatusStatus;

class SystemStatusErrorStructure;

class SystemStatusError;

class VideoSignalStatusStatus;

class VideoSignalStatusErrorStructure;

class VideoSignalStatusError;

class ReverseSignalStatusStatus;

class ReverseSignalStatusErrorStructure;

class ReverseSignalStatusError;

class Camera_PwrSupplyStatusStatus;

class Camera_PwrSupplyStatusErrorStructure;

class Camera_PwrSupplyStatusError;

class Microphone_PwrSupplyStatusStatus;

class Microphone_PwrSupplyStatusErrorStructure;

class Microphone_PwrSupplyStatusError;

class Tailgate_StatusStatus;

class Tailgate_StatusErrorStructure;

class Tailgate_StatusError;

class View_Close_AuthorizedStatus;

class View_Close_AuthorizedErrorStructure;

class View_Close_AuthorizedError;

class AvmR_Current_ViewStatus;

class AvmR_Current_ViewErrorStructure;

class AvmR_Current_ViewError;

class Affordable_ITSStatus;

class Affordable_ITSErrorStructure;

class Affordable_ITSError;

class IPAConfigurationStatus;

class IPAConfigurationErrorStructure;

class IPAConfigurationError;

class IPAStatusStatus;

class IPAStatusErrorStructure;

class IPAStatusError;

class IPAPatternRequestStatus;

class IPAPatternRequestErrorStructure;

class IPAPatternRequestError;

class IPAMessageRequestStatus;

class IPAMessageRequestErrorStructure;

class IPAMessageRequestError;

class IPASwitchMaskRequestStatus;

class IPASwitchMaskRequestErrorStructure;

class IPASwitchMaskRequestError;

class IPASwitchGreyOutRequestStatus;

class IPASwitchGreyOutRequestErrorStructure;

class IPASwitchGreyOutRequestError;

class IPADirectionIndicatorStatus;

class IPADirectionIndicatorErrorStructure;

class IPADirectionIndicatorError;

class GdlAdj_SteeringAngleStatus;

class GdlAdj_SteeringAngleErrorStructure;

class GdlAdj_SteeringAngleError;

class GdlAdj_CameraAngleStatus;

class GdlAdj_CameraAngleErrorStructure;

class GdlAdj_CameraAngleError;

class CANFrameStatusStatus;

class CANFrameStatusErrorStructure;

class CANFrameStatusError;

class MvcViewStatusStatus;

class MvcViewStatusErrorStructure;

class MvcViewStatusError;

class MvcAlertRequestStatus;

class MvcAlertRequestErrorStructure;

class MvcAlertRequestError;

class FAPModeStatus;

class FAPModeErrorStructure;

class FAPModeError;

class FAPSettingsStatus;

class FAPSettingsErrorStructure;

class FAPSettingsError;

class FAPGuidanceStateStatus;

class FAPGuidanceStateErrorStructure;

class FAPGuidanceStateError;

class AVM3_DispStatusStatus;

class AVM3_DispStatusErrorStructure;

class AVM3_DispStatusError;

class AVM3_ViewSetupStatus;

class AVM3_ViewSetupErrorStructure;

class AVM3_ViewSetupError;

class AVM3_ErrorMessageStatus;

class AVM3_ErrorMessageErrorStructure;

class AVM3_ErrorMessageError;

class AVM3_SonarBuzzerStatusStatus;

class AVM3_SonarBuzzerStatusErrorStructure;

class AVM3_SonarBuzzerStatusError;

class AVM3_Settings_DetailedStatus;

class AVM3_Settings_DetailedErrorStructure;

class AVM3_Settings_DetailedError;

class AVM3_Settings_PrimaryStatus;

class AVM3_Settings_PrimaryErrorStructure;

class AVM3_Settings_PrimaryError;

class AVM3_ConfigurationStatus;

class AVM3_ConfigurationErrorStructure;

class AVM3_ConfigurationError;

class AVM3_Software_VersionStatus;

class AVM3_Software_VersionErrorStructure;

class AVM3_Software_VersionError;

class AVM3_Hardware_VersionStatus;

class AVM3_Hardware_VersionErrorStructure;

class AVM3_Hardware_VersionError;

class AVM3_CommunicationErrorsStatus;

class AVM3_CommunicationErrorsErrorStructure;

class AVM3_CommunicationErrorsError;

class CameraButtonStart;

class CameraButtonResult;

class CameraButtonErrorStructure;

class CameraButtonError;

class SetStatusHmiStart;

class SetStatusHmiResult;

class SetStatusHmiErrorStructure;

class SetStatusHmiError;

class SetupLanguageStart;

class SetupLanguageResult;

class SetupLanguageErrorStructure;

class SetupLanguageError;

class SetupGuideLineStart;

class SetupGuideLineResult;

class SetupGuideLineErrorStructure;

class SetupGuideLineError;

class SetupVideoControlsStart;

class SetupVideoControlsResult;

class SetupVideoControlsErrorStructure;

class SetupVideoControlsError;

class SetSystemStatusStart;

class SetSystemStatusResult;

class SetSystemStatusErrorStructure;

class SetSystemStatusError;

class RunExtDevicePowerSupplyTestStart;

class RunExtDevicePowerSupplyTestResult;

class InitializeStart;

class InitializeResult;

class ConfirmSystemStatusStart;

class ConfirmSystemStatusResult;

class SetupUserConfigurationStart;

class SetupUserConfigurationResult;

class SetupUserConfigurationErrorStructure;

class SetupUserConfigurationError;

class SetMicrophoneStateStart;

class SetMicrophoneStateResult;

class SetMicrophoneStateErrorStructure;

class SetMicrophoneStateError;

class SetRVCStatusStart;

class SetRVCStatusResult;

class SetRVCStatusErrorStructure;

class SetRVCStatusError;

class Camera_SetupBeepStart;

class Camera_SetupBeepResult;

class Camera_SetupBeepErrorStructure;

class Camera_SetupBeepError;

class SetCamerastateStart;

class SetCamerastateResult;

class SetCamerastateErrorStructure;

class SetCamerastateError;

class ChangeViewRequestStart;

class ChangeViewRequestResult;

class ChangeViewRequestErrorStructure;

class ChangeViewRequestError;

class Affordable_Its_SetupBswStart;

class Affordable_Its_SetupBswResult;

class Affordable_Its_SetupBswErrorStructure;

class Affordable_Its_SetupBswError;

class Affordable_Its_SetupModStart;

class Affordable_Its_SetupModResult;

class Affordable_Its_SetupModErrorStructure;

class Affordable_Its_SetupModError;

class Affordable_Its_SetupLdwStart;

class Affordable_Its_SetupLdwResult;

class Affordable_Its_SetupLdwErrorStructure;

class Affordable_Its_SetupLdwError;

class IPA_SetHMIStatusStart;

class IPA_SetHMIStatusResult;

class IPA_SetHMIStatusErrorStructure;

class IPA_SetHMIStatusError;

class IPA_SetButtonStart;

class IPA_SetButtonResult;

class IPA_SetButtonErrorStructure;

class IPA_SetButtonError;

class IPA_Voice_TextsStart;

class IPA_Voice_TextsResult;

class IPA_Voice_TextsErrorStructure;

class IPA_Voice_TextsError;

class MVC_HMI_ViewRequestStart;

class MVC_HMI_ViewRequestResult;

class MVC_HMI_ViewRequestErrorStructure;

class MVC_HMI_ViewRequestError;

class GdlAdj_AdjustmentCompleteStart;

class GdlAdj_AdjustmentCompleteResult;

class GdlAdj_AdjustmentCompleteErrorStructure;

class GdlAdj_AdjustmentCompleteError;

class GdlAdj_AdjustButtonStart;

class GdlAdj_AdjustButtonResult;

class GdlAdj_AdjustButtonErrorStructure;

class GdlAdj_AdjustButtonError;

class GdlAdj_ConfigurationDataStart;

class GdlAdj_ConfigurationDataResult;

class GdlAdj_ConfigurationDataErrorStructure;

class GdlAdj_ConfigurationDataError;

class FAP_SetButtonStart;

class FAP_SetButtonResult;

class FAP_SetButtonErrorStructure;

class FAP_SetButtonError;

class TouchEventStart;

class TouchEventResult;

class TouchEventErrorStructure;

class TouchEventError;

class GPSInfoStart;

class GPSInfoResult;

class GPSInfoErrorStructure;

class GPSInfoError;

class MapMatchedInfoStart;

class MapMatchedInfoResult;

class MapMatchedInfoErrorStructure;

class MapMatchedInfoError;

class FapLearnParkPositionStart;

class FapLearnParkPositionResult;

class FapLearnParkPositionErrorStructure;

class FapLearnParkPositionError;

class SetFapGuidanceStart;

class SetFapGuidanceResult;

class SetFapGuidanceErrorStructure;

class SetFapGuidanceError;

class AVM3_SetSwitchStart;

class AVM3_SetSwitchResult;

class AVM3_SetSwitchErrorStructure;

class AVM3_SetSwitchError;

class AVM3_SetSonarBuzzerStatusStart;

class AVM3_SetSonarBuzzerStatusResult;

class AVM3_SetSonarBuzzerStatusErrorStructure;

class AVM3_SetSonarBuzzerStatusError;

class AVM3_Settings_Detailed_SendReqStart;

class AVM3_Settings_Detailed_SendReqResult;

class AVM3_Settings_Detailed_SendReqErrorStructure;

class AVM3_Settings_Detailed_SendReqError;

class AVM3_Settings_Primary_SendReqStart;

class AVM3_Settings_Primary_SendReqResult;

class AVM3_Settings_Primary_SendReqErrorStructure;

class AVM3_Settings_Primary_SendReqError;

class AVM3_GetVersionInfoStart;

class AVM3_GetVersionInfoResult;

class AVM3_GetVersionInfoErrorStructure;

class AVM3_GetVersionInfoError;

class AVM3_GetCommunicationErrorsResult;

class AVM3_GetCommunicationErrorsErrorStructure;

class AVM3_GetCommunicationErrorsError;

class AVM3_ClearCommunicationErrorsResult;

class AVM3_ClearCommunicationErrorsErrorStructure;

class AVM3_ClearCommunicationErrorsError;

class ToggleGpioPinOnOffErrorStructure;

class ToggleGpioPinOnOffError;

// type definitions
/**
 * The upreg message of the property "SystemConfigurations"
 * Information about configurations which are relevant for the Rear and Around View vision system.
 * <p>FUNCID = RVC_CCAFI_C_U16_SYSTEMCONFIGURATIONS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SystemConfigurationsUpReg;

/**
 * The relUpReg message of the property "SystemConfigurations"
 * Information about configurations which are relevant for the Rear and Around View vision system.
 * <p>FUNCID = RVC_CCAFI_C_U16_SYSTEMCONFIGURATIONS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SystemConfigurationsRelUpReg;

/**
 * The upreg message of the property "SystemStatus"
 * Gives the information about the activation state of the vision system.
 * <p>Client application should use the following parameters :</p>
 * <p>FUNCID = RVC_CCAFI_C_U16_SYSTEMSTATUS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SystemStatusUpReg;

/**
 * The relUpReg message of the property "SystemStatus"
 * Gives the information about the activation state of the vision system.
 * <p>Client application should use the following parameters :</p>
 * <p>FUNCID = RVC_CCAFI_C_U16_SYSTEMSTATUS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SystemStatusRelUpReg;

/**
 * The upreg message of the property "VideoSignalStatus"
 * This Property informs about the video signal state after RVC/AVM visualisation was requested.
 * <p>FUNCID = RVC_CCAFI_C_U16_VIDEOSIGNALSTATUS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoSignalStatusUpReg;

/**
 * The relUpReg message of the property "VideoSignalStatus"
 * This Property informs about the video signal state after RVC/AVM visualisation was requested.
 * <p>FUNCID = RVC_CCAFI_C_U16_VIDEOSIGNALSTATUS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VideoSignalStatusRelUpReg;

/**
 * The upreg message of the property "ReverseSignalStatus"
 * This Property informs about the reverse signal state.
 * <p>FUNCID = RVC_CCAFI_C_U16_REVERSESIGNALSTATUS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ReverseSignalStatusUpReg;

/**
 * The relUpReg message of the property "ReverseSignalStatus"
 * This Property informs about the reverse signal state.
 * <p>FUNCID = RVC_CCAFI_C_U16_REVERSESIGNALSTATUS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ReverseSignalStatusRelUpReg;

/**
 * The get message of the property "Camera_PwrSupplyStatus"
 * This Property informs about the current Camera State (used mainly by Diagnosis)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Camera_PwrSupplyStatusGet;

/**
 * The upreg message of the property "Camera_PwrSupplyStatus"
 * This Property informs about the current Camera State (used mainly by Diagnosis)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Camera_PwrSupplyStatusUpReg;

/**
 * The relUpReg message of the property "Camera_PwrSupplyStatus"
 * This Property informs about the current Camera State (used mainly by Diagnosis)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Camera_PwrSupplyStatusRelUpReg;

/**
 * The get message of the property "Microphone_PwrSupplyStatus"
 * This Property informs about the current Microphone State (used mainly by Diagnosis)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Microphone_PwrSupplyStatusGet;

/**
 * The upreg message of the property "Microphone_PwrSupplyStatus"
 * This Property informs about the current Microphone State (used mainly by Diagnosis)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Microphone_PwrSupplyStatusUpReg;

/**
 * The relUpReg message of the property "Microphone_PwrSupplyStatus"
 * This Property informs about the current Microphone State (used mainly by Diagnosis)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Microphone_PwrSupplyStatusRelUpReg;

/**
 * The get message of the property "Tailgate_Status"
 * This Property informs about the current Tailgate State
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Tailgate_StatusGet;

/**
 * The upreg message of the property "Tailgate_Status"
 * This Property informs about the current Tailgate State
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Tailgate_StatusUpReg;

/**
 * The relUpReg message of the property "Tailgate_Status"
 * This Property informs about the current Tailgate State
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Tailgate_StatusRelUpReg;

/**
 * The upreg message of the property "View_Close_Authorized"
 * This property informs about the availability of an AVM exit through the HMI (Applicable only for Renault specific AVM)
 * <p>FUNCID = RVC_CCAFI_C_U16_VIEW_CLOSE_AUTHORIZED</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage View_Close_AuthorizedUpReg;

/**
 * The relUpReg message of the property "View_Close_Authorized"
 * This property informs about the availability of an AVM exit through the HMI (Applicable only for Renault specific AVM)
 * <p>FUNCID = RVC_CCAFI_C_U16_VIEW_CLOSE_AUTHORIZED</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage View_Close_AuthorizedRelUpReg;

/**
 * The upreg message of the property "AvmR_Current_View"
 * This property informs about the availability of an AVM exit through the HMI (Applicable only for Renault specific AVM)
 * <p>FUNCID = RVC_CCAFI_C_U16_AVMR_CURRENT_VIEW</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AvmR_Current_ViewUpReg;

/**
 * The relUpReg message of the property "AvmR_Current_View"
 * This property informs about the availability of an AVM exit through the HMI (Applicable only for Renault specific AVM)
 * <p>FUNCID = RVC_CCAFI_C_U16_AVMR_CURRENT_VIEW</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AvmR_Current_ViewRelUpReg;

/**
 * The upreg message of the property "Affordable_ITS"
 * This property informs about the availability of an Affordable ITS unit and it's configuration states
 * <p>FUNCID = RVC_CCAFI_C_U16_AFFORDABLE_ITS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Affordable_ITSUpReg;

/**
 * The relUpReg message of the property "Affordable_ITS"
 * This property informs about the availability of an Affordable ITS unit and it's configuration states
 * <p>FUNCID = RVC_CCAFI_C_U16_AFFORDABLE_ITS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Affordable_ITSRelUpReg;

/**
 * The upreg message of the property "IPAConfiguration"
 * This Property informs about the IPA configuration
 * <p>FUNCID = RVC_CCAFI_C_U16_IPACONFIGURATION</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IPAConfigurationUpReg;

/**
 * The relUpReg message of the property "IPAConfiguration"
 * This Property informs about the IPA configuration
 * <p>FUNCID = RVC_CCAFI_C_U16_IPACONFIGURATION</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IPAConfigurationRelUpReg;

/**
 * The upreg message of the property "IPAStatus"
 * This Property informs about the IPA status.
 * <p>FUNCID = RVC_CCAFI_C_U16_IPASTATUS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IPAStatusUpReg;

/**
 * The relUpReg message of the property "IPAStatus"
 * This Property informs about the IPA status.
 * <p>FUNCID = RVC_CCAFI_C_U16_IPASTATUS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IPAStatusRelUpReg;

/**
 * The upreg message of the property "IPAPatternRequest"
 * This Property informs about the current requested screen pattern by IPA.
 * <p>FUNCID = RVC_CCAFI_C_U16_IPAPATTERNREQUEST</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IPAPatternRequestUpReg;

/**
 * The relUpReg message of the property "IPAPatternRequest"
 * This Property informs about the current requested screen pattern by IPA.
 * <p>FUNCID = RVC_CCAFI_C_U16_IPAPATTERNREQUEST</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IPAPatternRequestRelUpReg;

/**
 * The upreg message of the property "IPAMessageRequest"
 * This Property informs about the current requested message lines by IPA.
 * <p>FUNCID = RVC_CCAFI_C_U16_IPAMESSAGEREQUEST</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IPAMessageRequestUpReg;

/**
 * The relUpReg message of the property "IPAMessageRequest"
 * This Property informs about the current requested message lines by IPA.
 * <p>FUNCID = RVC_CCAFI_C_U16_IPAMESSAGEREQUEST</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IPAMessageRequestRelUpReg;

/**
 * The upreg message of the property "IPASwitchMaskRequest"
 * This Property informs about the current requested switch mask by IPA.
 * <p>FUNCID = RVC_CCAFI_C_U16_IPASWITCHMASKREQUEST</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IPASwitchMaskRequestUpReg;

/**
 * The relUpReg message of the property "IPASwitchMaskRequest"
 * This Property informs about the current requested switch mask by IPA.
 * <p>FUNCID = RVC_CCAFI_C_U16_IPASWITCHMASKREQUEST</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IPASwitchMaskRequestRelUpReg;

/**
 * The upreg message of the property "IPASwitchGreyOutRequest"
 * This Property informs about the current requested switch grey out by IPA.
 * <p>FUNCID = RVC_CCAFI_C_U16_IPASWITCHGREYOUTREQUEST</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IPASwitchGreyOutRequestUpReg;

/**
 * The relUpReg message of the property "IPASwitchGreyOutRequest"
 * This Property informs about the current requested switch grey out by IPA.
 * <p>FUNCID = RVC_CCAFI_C_U16_IPASWITCHGREYOUTREQUEST</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IPASwitchGreyOutRequestRelUpReg;

/**
 * The upreg message of the property "IPADirectionIndicator"
 * This property informs about the current direction for the RearViewIcon
 * <p>FUNCID = RVC_CCAFI_C_U16_IPADIRECTIONINDICATOR</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IPADirectionIndicatorUpReg;

/**
 * The relUpReg message of the property "IPADirectionIndicator"
 * This property informs about the current direction for the RearViewIcon
 * <p>FUNCID = RVC_CCAFI_C_U16_IPADIRECTIONINDICATOR</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IPADirectionIndicatorRelUpReg;

/**
 * The upreg message of the property "GdlAdj_SteeringAngle"
 * This Property informs about the Steering Angle and Status to be used for the Guideline Adjustment screens.
 * The parameter will be updated only when the screen is activated.
 * <p>FUNCID = RVC_CCAFI_C_U16_GDLADJ_STEERINGANGLE</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GdlAdj_SteeringAngleUpReg;

/**
 * The relUpReg message of the property "GdlAdj_SteeringAngle"
 * This Property informs about the Steering Angle and Status to be used for the Guideline Adjustment screens.
 * The parameter will be updated only when the screen is activated.
 * <p>FUNCID = RVC_CCAFI_C_U16_GDLADJ_STEERINGANGLE</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GdlAdj_SteeringAngleRelUpReg;

/**
 * The upreg message of the property "GdlAdj_CameraAngle"
 * This Property informs about the Camera Angle values to be used for the Guideline Adjustment screens.
 * The parameter will be updated only when the screen is activated.
 * <p>FUNCID = RVC_CCAFI_C_U16_GDLADJ_CAMERAANGLE</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GdlAdj_CameraAngleUpReg;

/**
 * The relUpReg message of the property "GdlAdj_CameraAngle"
 * This Property informs about the Camera Angle values to be used for the Guideline Adjustment screens.
 * The parameter will be updated only when the screen is activated.
 * <p>FUNCID = RVC_CCAFI_C_U16_GDLADJ_CAMERAANGLE</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GdlAdj_CameraAngleRelUpReg;

/**
 * The upreg message of the property "CANFrameStatus"
 * This Property informs about the CAN(Controller Area Network) frame status after MVC view requested.
 * <p>FUNCID = RVC_CCAFI_C_U16_CANFRAMESTATUS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CANFrameStatusUpReg;

/**
 * The relUpReg message of the property "CANFrameStatus"
 * This Property informs about the CAN(Controller Area Network) frame status after MVC view requested.
 * <p>FUNCID = RVC_CCAFI_C_U16_CANFRAMESTATUS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CANFrameStatusRelUpReg;

/**
 * The upreg message of the property "MvcViewStatus"
 * This Property informs about the current MVC view status.
 * <p>FUNCID = RVC_CCAFI_C_U16_MVCVIEWSTATUS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MvcViewStatusUpReg;

/**
 * The relUpReg message of the property "MvcViewStatus"
 * This Property informs about the current MVC view status.
 * <p>FUNCID = RVC_CCAFI_C_U16_MVCVIEWSTATUS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MvcViewStatusRelUpReg;

/**
 * The upreg message of the property "MvcAlertRequest"
 * This Property informs about the current MVC Alert Requested State.
 * <p>FUNCID = RVC_CCAFI_C_U16_MVCALERTREQUEST</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MvcAlertRequestUpReg;

/**
 * The relUpReg message of the property "MvcAlertRequest"
 * This Property informs about the current MVC Alert Requested State.
 * <p>FUNCID = RVC_CCAFI_C_U16_MVCALERTREQUEST</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MvcAlertRequestRelUpReg;

/**
 * The upreg message of the property "FAPMode"
 * This Property informs about the whether we are in FAP mode or not.
 * <p>FUNCID = RVC_CCAFI_C_U16_FAPMODE</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FAPModeUpReg;

/**
 * The relUpReg message of the property "FAPMode"
 * This Property informs about the whether we are in FAP mode or not.
 * <p>FUNCID = RVC_CCAFI_C_U16_FAPMODE</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FAPModeRelUpReg;

/**
 * The upreg message of the property "FAPSettings"
 * This Property informs about the current FAP Setting State
 * <p>FUNCID = RVC_CCAFI_C_U16_FAPSETTINGS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FAPSettingsUpReg;

/**
 * The relUpReg message of the property "FAPSettings"
 * This Property informs about the current FAP Setting State
 * <p>FUNCID = RVC_CCAFI_C_U16_FAPSETTINGS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FAPSettingsRelUpReg;

/**
 * The upreg message of the property "FAPGuidanceState"
 * This Property informs about the whether we are in FAP Guidance or not.
 * <p>FUNCID = RVC_CCAFI_C_U16_FAPGUIDANCESTATE</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FAPGuidanceStateUpReg;

/**
 * The relUpReg message of the property "FAPGuidanceState"
 * This Property informs about the whether we are in FAP Guidance or not.
 * <p>FUNCID = RVC_CCAFI_C_U16_FAPGUIDANCESTATE</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FAPGuidanceStateRelUpReg;

/**
 * The upreg message of the property "AVM3_DispStatus"
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_DISPSTATUS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AVM3_DispStatusUpReg;

/**
 * The relUpReg message of the property "AVM3_DispStatus"
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_DISPSTATUS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AVM3_DispStatusRelUpReg;

/**
 * The upreg message of the property "AVM3_ViewSetup"
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_VIEWCHANGE</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AVM3_ViewSetupUpReg;

/**
 * The relUpReg message of the property "AVM3_ViewSetup"
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_VIEWCHANGE</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AVM3_ViewSetupRelUpReg;

/**
 * The upreg message of the property "AVM3_ErrorMessage"
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_ERRORMESSAGE</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AVM3_ErrorMessageUpReg;

/**
 * The relUpReg message of the property "AVM3_ErrorMessage"
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_ERRORMESSAGE</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AVM3_ErrorMessageRelUpReg;

/**
 * The upreg message of the property "AVM3_SonarBuzzerStatus"
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_BUZZERSTATUS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AVM3_SonarBuzzerStatusUpReg;

/**
 * The relUpReg message of the property "AVM3_SonarBuzzerStatus"
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_BUZZERSTATUS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AVM3_SonarBuzzerStatusRelUpReg;

/**
 * The upreg message of the property "AVM3_Settings_Detailed"
 * This property holds the availability and states of all AVM3 settings items, as received from the AVM phase3.
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_SETTINGS_DETAILED</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AVM3_Settings_DetailedUpReg;

/**
 * The relUpReg message of the property "AVM3_Settings_Detailed"
 * This property holds the availability and states of all AVM3 settings items, as received from the AVM phase3.
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_SETTINGS_DETAILED</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AVM3_Settings_DetailedRelUpReg;

/**
 * The upreg message of the property "AVM3_Settings_Primary"
 * This property holds the availability and states of all AVM3 settings items in the camera primary settings display.
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_SETTINGS_PRIMARY</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AVM3_Settings_PrimaryUpReg;

/**
 * The relUpReg message of the property "AVM3_Settings_Primary"
 * This property holds the availability and states of all AVM3 settings items in the camera primary settings display.
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_SETTINGS_PRIMARY</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AVM3_Settings_PrimaryRelUpReg;

/**
 * The upreg message of the property "AVM3_Configuration"
 * This property holds the basic configuration parameters of the AVM3 ECU as received from the ECU via MCAN during connection setup.
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_CONFIGURATION</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AVM3_ConfigurationUpReg;

/**
 * The relUpReg message of the property "AVM3_Configuration"
 * This property holds the basic configuration parameters of the AVM3 ECU as received from the ECU via MCAN during connection setup.
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_CONFIGURATION</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AVM3_ConfigurationRelUpReg;

/**
 * The upreg message of the property "AVM3_Software_Version"
 * This property holds the AVM3 software version information.
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_SOFTWARE_VERSION</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AVM3_Software_VersionUpReg;

/**
 * The relUpReg message of the property "AVM3_Software_Version"
 * This property holds the AVM3 software version information.
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_SOFTWARE_VERSION</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AVM3_Software_VersionRelUpReg;

/**
 * The upreg message of the property "AVM3_Hardware_Version"
 * This property holds the AVM3 hardware version information.
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_HARDWARE_VERSION</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AVM3_Hardware_VersionUpReg;

/**
 * The relUpReg message of the property "AVM3_Hardware_Version"
 * This property holds the AVM3 hardware version information.
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_HARDWARE_VERSION</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AVM3_Hardware_VersionRelUpReg;

/**
 * The upreg message of the property "AVM3_CommunicationErrors"
 * This property holds the MCAN communication error related parameters (ref. 25953NDS06).
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_COMMUNICATION_ERROR</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AVM3_CommunicationErrorsUpReg;

/**
 * The relUpReg message of the property "AVM3_CommunicationErrors"
 * This property holds the MCAN communication error related parameters (ref. 25953NDS06).
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_COMMUNICATION_ERROR</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AVM3_CommunicationErrorsRelUpReg;

/**
 * The abort error message of the method "CameraButton"
 * To inform the vd_rvc component about user presses on the camera button within certain HMI states related to RVC/AVM.
 * <p>FUNCID = RVC_CCAFI_C_U16_CAMERABUTTON</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError CameraButtonAbortError;

/**
 * The abort error message of the method "SetStatusHmi"
 * To inform the vd_rvc component about the availibilty of HMI.
 * VD_RVC will use this information to differentiate for early or normal video activation.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetStatusHmiAbortError;

/**
 * The abort error message of the method "SetupLanguage"
 * To inform the vd_rvc component about the Language setup done by the user.
 * This method has to be called by HMI once after system startup and in case of a change of the setup done by the user.
 * <p>FUNCID = RVC_CCAFI_C_U16_SETUPLANGUAGE</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError SetupLanguageAbortError;

/**
 * The abort error message of the method "SetupGuideLine"
 * To inform the vd_rvc component about the Camera visibility and GuideLine setup done by the user.
 * This method has to be called by HMI once after system startup and in case of a change of the setup done by the user.
 * <p>FUNCID = RVC_CCAFI_C_U16_SETGUIDELINE</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError SetupGuideLineAbortError;

/**
 * The abort error message of the method "SetupVideoControls"
 * This method is to inform the vd_rvc component about the Brightness, Contrast, Color Hue/Tint and Black Level setup for the video signal done by the user.
 * This method has to be called by HMI once after system startup and in case of a change of the setup done by the user.
 * <p>FUNCID = RVC_CCAFI_C_U16_SETUPVIDEOCONTROLS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError SetupVideoControlsAbortError;

/**
 * The abort error message of the method "SetSystemStatus"
 * Can be used to switch ON/OFF the vision system.
 * <p>FUNCID = RVC_CCAFI_C_U16_SETSYSTEMSTATUS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError SetSystemStatusAbortError;

/**
 * The abort error message of the method "runExtDevicePowerSupplyTest"
 */
typedef ::asf::cca::CcaTypes::DefaultError RunExtDevicePowerSupplyTestAbortError;

/**
 * The error message of 'runExtDevicePowerSupplyTest'
 */
typedef ::asf::cca::CcaTypes::DefaultError RunExtDevicePowerSupplyTestError;

/**
 * The abort error message of the method "Initialize"
 */
typedef ::asf::cca::CcaTypes::DefaultError InitializeAbortError;

/**
 * The error message of 'Initialize'
 */
typedef ::asf::cca::CcaTypes::DefaultError InitializeError;

/**
 * The abort error message of the method "ConfirmSystemStatus"
 */
typedef ::asf::cca::CcaTypes::DefaultError ConfirmSystemStatusAbortError;

/**
 * The error message of 'ConfirmSystemStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError ConfirmSystemStatusError;

/**
 * The abort error message of the method "SetupUserConfiguration"
 * This method is to inform the Park Assist component about user setup.
 * This method has to be called by HMI once after system start up and in case of a change of the setup done by the user.
 * On start up  the list should be filled with all relevant parameter. Later on an user change, only the current modified list entry must be filled.
 * <p>FUNCID = RVC_CCAFI_C_U16_SETUPUSERCONFIGURATION</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError SetupUserConfigurationAbortError;

/**
 * The abort error message of the method "SetMicrophoneState"
 * <p>Switches the Microphone state ON/OFF via ELMOS IC</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError SetMicrophoneStateAbortError;

/**
 * The abort error message of the method "SetRVCStatus"
 * <p>HMI could set the RVC Status</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError SetRVCStatusAbortError;

/**
 * The abort error message of the method "Camera_SetupBeep"
 * <p>FUNCID = RVC_CCAFI_C_U16_SETUPBEEP</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Camera_SetupBeepAbortError;

/**
 * The abort error message of the method "SetCamerastate"
 * <p>FUNCID = RVC_CCAFI_C_U16_SETCAMERASTATE</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError SetCamerastateAbortError;

/**
 * The abort error message of the method "ChangeViewRequest"
 * This method has to be called by HMI to request a change in AVM View
 * <p>FUNCID = RVC_CCAFI_C_U16_CHANGE_VIEW_REQUEST</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError ChangeViewRequestAbortError;

/**
 * The abort error message of the method "Affordable_Its_SetupBsw"
 * This method has to be called by HMI to inform about a change in configuration for the Blind Spot Warning feature.
 * <p>FUNCID = RVC_CCAFI_C_U16_AFFORDABLE_ITS_SETUPBSW</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Affordable_Its_SetupBswAbortError;

/**
 * The abort error message of the method "Affordable_Its_SetupMod"
 * This method has to be called by HMI to inform about a change in configuration for the Motion Object Detection feature.
 * <p>FUNCID = RVC_CCAFI_C_U16_AFFORDABLE_ITS_SETUPMOD</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Affordable_Its_SetupModAbortError;

/**
 * The abort error message of the method "Affordable_Its_SetupLdw"
 * This method has to be called by HMI to inform about a change in configuration for the Lane Departure Warning feature.
 * <p>FUNCID = RVC_CCAFI_C_U16_AFFORDABLE_ITS_SETUPLDW</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Affordable_Its_SetupLdwAbortError;

/**
 * The abort error message of the method "IPA_SetHMIStatus"
 * <p>FUNCID = RVC_CCAFI_C_U16_IPASETHMISTATUS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError IPA_SetHMIStatusAbortError;

/**
 * The abort error message of the method "IPA_SetButton"
 * <p>FUNCID = RVC_CCAFI_C_U16_IPASETBUTTON</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError IPA_SetButtonAbortError;

/**
 * The abort error message of the method "IPA_Voice_Texts"
 * <p>IPA Voice strings has to be read out in all different Languages</p>
 * <p>the text of these strings is fetched from HMI Translation table and used in TTS</p>
 * <p>FUNCID = RVC_CCAFI_C_U16_IPA_VOICE_TEXTS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError IPA_Voice_TextsAbortError;

/**
 * The abort error message of the method "MVC_HMI_ViewRequest"
 * <p>FUNCID = RVC_CCAFI_C_U16_MVC_HMI_VIEWREQUEST</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError MVC_HMI_ViewRequestAbortError;

/**
 * The abort error message of the method "GdlAdj_AdjustmentComplete"
 * <p>FUNCID = RVC_CCAFI_C_U16_GDLADJ_ADJUSTMENTCOMPLETE</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError GdlAdj_AdjustmentCompleteAbortError;

/**
 * The abort error message of the method "GdlAdj_AdjustButton"
 * This method has to be called by HMI to inform about a button press in Guideline Adjustment Screen.
 * <p>FUNCID = RVC_CCAFI_C_U16_GDLADJ_ADJUSTBUTTON</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError GdlAdj_AdjustButtonAbortError;

/**
 * The abort error message of the method "GdlAdj_ConfigurationData"
 * Method to get, to get all or to set configuration value(s).
 * <p>FUNCID = RVC_CCAFI_C_U16_GDLADJ_CONFIGURATIONDATA</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError GdlAdj_ConfigurationDataAbortError;

/**
 * The abort error message of the method "FAP_SetButton"
 * <p>FUNCID = RVC_CCAFI_C_U16_FAP_SETBUTTON</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError FAP_SetButtonAbortError;

/**
 * The abort error message of the method "TouchEvent"
 * <p>Touch events detected on HMI are sent to Middleware needed for Full Auto Parking</p>
 * <p>this might not be used at all due to the latency requirements for FAP</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError TouchEventAbortError;

/**
 * The abort error message of the method "GPSInfo"
 * <p>GPS Data received from Navi Client used for FAP only</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError GPSInfoAbortError;

/**
 * The abort error message of the method "MapMatchedInfo"
 * <p>Map Matched Data calculated by Navi for every GPS data received used for FAP only</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError MapMatchedInfoAbortError;

/**
 * The abort error message of the method "FapLearnParkPosition"
 * <p>HMI Requests to begin Learning of the Parking Position to be sent to FAP (AVM) unit</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError FapLearnParkPositionAbortError;

/**
 * The abort error message of the method "SetFapGuidance"
 * <p>HMI Requests to set the Fap Guidance On/Off</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError SetFapGuidanceAbortError;

/**
 * The abort error message of the method "AVM3_SetSwitch"
 * This method serves to send a key/switch/touch button event to the AVM phase3.
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_SETSWITCH</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError AVM3_SetSwitchAbortError;

/**
 * The abort error message of the method "AVM3_SetSonarBuzzerStatus"
 * This method serves to send a request to the AVM phase3 to change the Sonar Buzzer ON/OFF state.
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_SETSONARBUZZERSTATUS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError AVM3_SetSonarBuzzerStatusAbortError;

/**
 * The abort error message of the method "AVM3_Settings_Detailed_SendReq"
 * This method serves to send a request to the AVM phase3 to either send the current states/values of all its
 * settings items, or to change the state/value of one or more of them.
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_SETTINGS_DETAILED_SENDREQ</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError AVM3_Settings_Detailed_SendReqAbortError;

/**
 * The abort error message of the method "AVM3_Settings_Primary_SendReq"
 * This method serves to send a request to the AVM phase3 either to send the current states of the
 * settings items on the camera primary settings screen, or to set new states.
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_SETTINGS_PRIMARY_SENDREQ</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError AVM3_Settings_Primary_SendReqAbortError;

/**
 * The abort error message of the method "AVM3_GetVersionInfo"
 * This method serves to retrieve hardware or/and software version information from the AVM phase3 ECU.
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_GETVERSIONINFO</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError AVM3_GetVersionInfoAbortError;

/**
 * The start message of the method "AVM3_GetCommunicationErrors"
 * This method serves to reques the MCAN communication error parameters from the AVM phase3 ECU.
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_GETCOMMUNICATIONERRORS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AVM3_GetCommunicationErrorsStart;

/**
 * The abort error message of the method "AVM3_GetCommunicationErrors"
 * This method serves to reques the MCAN communication error parameters from the AVM phase3 ECU.
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_GETCOMMUNICATIONERRORS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError AVM3_GetCommunicationErrorsAbortError;

/**
 * The start message of the method "AVM3_ClearCommunicationErrors"
 * This method serves to clear the MCAN communication error parameters in the AVM phase3 ECU.
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_CLEARCOMMUNICATIONERRORS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AVM3_ClearCommunicationErrorsStart;

/**
 * The abort error message of the method "AVM3_ClearCommunicationErrors"
 * This method serves to clear the MCAN communication error parameters in the AVM phase3 ECU.
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_CLEARCOMMUNICATIONERRORS</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError AVM3_ClearCommunicationErrorsAbortError;

/**
 * The start message of the method "ToggleGpioPinOnOff"
 * This method serves to clear the MCAN communication error parameters in the AVM phase3 ECU.
 * <p>FUNCID = RVC_CCAFI_C_U16_TOGGLEGPIOPINONOFF</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ToggleGpioPinOnOffStart;

/**
 * The result message of the method "ToggleGpioPinOnOff"
 * This method serves to clear the MCAN communication error parameters in the AVM phase3 ECU.
 * <p>FUNCID = RVC_CCAFI_C_U16_TOGGLEGPIOPINONOFF</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ToggleGpioPinOnOffResult;

/**
 * The abort error message of the method "ToggleGpioPinOnOff"
 * This method serves to clear the MCAN communication error parameters in the AVM phase3 ECU.
 * <p>FUNCID = RVC_CCAFI_C_U16_TOGGLEGPIOPINONOFF</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError ToggleGpioPinOnOffAbortError;


/**
 * The status message of the property "SystemConfigurations"
 * Information about configurations which are relevant for the Rear and Around View vision system.
 * <p>FUNCID = RVC_CCAFI_C_U16_SYSTEMCONFIGURATIONS</p>
 */
class SystemConfigurationsStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemConfigurationsStatus ();

    /**
     * Copy constructor
     */
    inline  SystemConfigurationsStatus (const SystemConfigurationsStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SystemConfigurationsStatus (::rvc_cca_fi_types::T_e8_RVC_Camera_System_Type e8CameraSystem_, uint8 u8RVCGuideLine_, uint8 u8Brightness_);

    /**
     * Destructor
     */
    inline virtual  ~SystemConfigurationsStatus();

    /**
     * Assignment operator
     */
    inline SystemConfigurationsStatus& operator = (const SystemConfigurationsStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemConfigurationsStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemConfigurationsStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemConfigurationsStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemConfigurationsStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8CameraSystem"

    static const int kE8CameraSystem = 0;

    /**
     * Clears the field "e8CameraSystem".
     *
     * The field will be set to its default value. The hasE8CameraSystem()
     * method will return false.
     */
    inline void clearE8CameraSystem();

    /**
     * Checks whether the field "e8CameraSystem" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CameraSystem()). Otherwise it will return false.
     */
    inline bool hasE8CameraSystem () const;

    /**
     * Returns the value of the member "e8CameraSystem".
     *
     * Information about the configured Camera System.
     *
     * @return The value of the field "e8CameraSystem"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_Camera_System_Type getE8CameraSystem () const;

    /**
     * Sets the value of the member "e8CameraSystem".
     *
     * Information about the configured Camera System.
     *
     * @param e8CameraSystem The value which will be set
     */
    inline void setE8CameraSystem (::rvc_cca_fi_types::T_e8_RVC_Camera_System_Type e8CameraSystem_);

    // API of field "u8RVCGuideLine"

    static const int kU8RVCGuideLine = 1;

    /**
     * Clears the field "u8RVCGuideLine".
     *
     * The field will be set to its default value. The hasU8RVCGuideLine()
     * method will return false.
     */
    inline void clearU8RVCGuideLine();

    /**
     * Checks whether the field "u8RVCGuideLine" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8RVCGuideLine()). Otherwise it will return false.
     */
    inline bool hasU8RVCGuideLine () const;

    /**
     * Returns the value of the member "u8RVCGuideLine".
     *
     * Information about the Guideline value.
     * This values is only valid in case Camera System = RVC or MVC
     * 0 = No Guideline Available
     * 1 = Only Static Guideline Available
     * 2 = Both Static and Dynamic Guideline Available
     *
     * @return The value of the field "u8RVCGuideLine"
     */
    inline uint8 getU8RVCGuideLine () const;

    /**
     * Sets the value of the member "u8RVCGuideLine".
     *
     * Information about the Guideline value.
     * This values is only valid in case Camera System = RVC or MVC
     * 0 = No Guideline Available
     * 1 = Only Static Guideline Available
     * 2 = Both Static and Dynamic Guideline Available
     *
     * @param u8RVCGuideLine The value which will be set
     */
    inline void setU8RVCGuideLine (uint8 u8RVCGuideLine_);

    // API of field "u8Brightness"

    static const int kU8Brightness = 2;

    /**
     * Clears the field "u8Brightness".
     *
     * The field will be set to its default value. The hasU8Brightness()
     * method will return false.
     */
    inline void clearU8Brightness();

    /**
     * Checks whether the field "u8Brightness" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Brightness()). Otherwise it will return false.
     */
    inline bool hasU8Brightness () const;

    /**
     * Returns the value of the member "u8Brightness".
     *
     * Reflects the brightness configuration value.
     *
     * @return The value of the field "u8Brightness"
     */
    inline uint8 getU8Brightness () const;

    /**
     * Sets the value of the member "u8Brightness".
     *
     * Reflects the brightness configuration value.
     *
     * @param u8Brightness The value which will be set
     */
    inline void setU8Brightness (uint8 u8Brightness_);

    static const SystemConfigurationsStatus &getDefaultInstance();

private:

    inline void set_has_e8CameraSystem ();

    inline void clear_has_e8CameraSystem ();

    inline void set_has_u8RVCGuideLine ();

    inline void clear_has_u8RVCGuideLine ();

    inline void set_has_u8Brightness ();

    inline void clear_has_u8Brightness ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_Camera_System_Type _e8CameraSystem;

    uint8 _u8RVCGuideLine;

    uint8 _u8Brightness;

};

/**
 * The error message of 'SystemConfigurations'
 */
class SystemConfigurationsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SystemConfigurationsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SystemConfigurationsErrorStructure (const SystemConfigurationsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SystemConfigurationsErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SystemConfigurationsErrorStructure();

    /**
     * Assignment operator
     */
    inline SystemConfigurationsErrorStructure& operator = (const SystemConfigurationsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemConfigurationsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemConfigurationsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemConfigurationsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemConfigurationsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    static const SystemConfigurationsErrorStructure &getDefaultInstance();

private:

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _e8ErrorCode;

};

/**
 * The error message of 'SystemConfigurations'
 */
class SystemConfigurationsError  : public ::asf::core::Payload {
public:

    enum SystemConfigurationsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SystemConfigurationsError ();

   /**
     * Copy constructor
     */
    inline  SystemConfigurationsError (const SystemConfigurationsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SystemConfigurationsError();

    /**
     * Assigns a new value to this object.
     */
    inline SystemConfigurationsError& operator = (const SystemConfigurationsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemConfigurationsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemConfigurationsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemConfigurationsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemConfigurationsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SystemConfigurationsError::SystemConfigurationsErrorField getField () const;

    inline void setField(SystemConfigurationsError::SystemConfigurationsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SystemConfigurationsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SystemConfigurationsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SystemConfigurationsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SystemConfigurationsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SystemConfigurationsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SystemConfigurationsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SystemConfigurationsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SystemConfigurationsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SystemConfigurationsError &getDefaultInstance();

private:

    inline void cloneData (const SystemConfigurationsError& rhs);

    inline void deleteData ();

    SystemConfigurationsErrorField __field;

    union {
        SystemConfigurationsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "SystemStatus"
 * Gives the information about the activation state of the vision system.
 * <p>Client application should use the following parameters :</p>
 * <p>FUNCID = RVC_CCAFI_C_U16_SYSTEMSTATUS</p>
 */
class SystemStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemStatusStatus ();

    /**
     * Copy constructor
     */
    inline  SystemStatusStatus (const SystemStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SystemStatusStatus (::rvc_cca_fi_types::T_e8_RVC_SystemStatus e8SystemStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SystemStatusStatus();

    /**
     * Assignment operator
     */
    inline SystemStatusStatus& operator = (const SystemStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8SystemStatus"

    static const int kE8SystemStatus = 0;

    /**
     * Clears the field "e8SystemStatus".
     *
     * The field will be set to its default value. The hasE8SystemStatus()
     * method will return false.
     */
    inline void clearE8SystemStatus();

    /**
     * Checks whether the field "e8SystemStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SystemStatus()). Otherwise it will return false.
     */
    inline bool hasE8SystemStatus () const;

    /**
     * Returns the value of the member "e8SystemStatus".
     *
     * Current activation status of the vision system
     *
     * @return The value of the field "e8SystemStatus"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_SystemStatus getE8SystemStatus () const;

    /**
     * Sets the value of the member "e8SystemStatus".
     *
     * Current activation status of the vision system
     *
     * @param e8SystemStatus The value which will be set
     */
    inline void setE8SystemStatus (::rvc_cca_fi_types::T_e8_RVC_SystemStatus e8SystemStatus_);

    static const SystemStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8SystemStatus ();

    inline void clear_has_e8SystemStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_SystemStatus _e8SystemStatus;

};

/**
 * The error message of 'SystemStatus'
 */
class SystemStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SystemStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SystemStatusErrorStructure (const SystemStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SystemStatusErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SystemStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline SystemStatusErrorStructure& operator = (const SystemStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const SystemStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'SystemStatus'
 */
class SystemStatusError  : public ::asf::core::Payload {
public:

    enum SystemStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SystemStatusError ();

   /**
     * Copy constructor
     */
    inline  SystemStatusError (const SystemStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SystemStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline SystemStatusError& operator = (const SystemStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SystemStatusError::SystemStatusErrorField getField () const;

    inline void setField(SystemStatusError::SystemStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SystemStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SystemStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SystemStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SystemStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SystemStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SystemStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SystemStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SystemStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SystemStatusError &getDefaultInstance();

private:

    inline void cloneData (const SystemStatusError& rhs);

    inline void deleteData ();

    SystemStatusErrorField __field;

    union {
        SystemStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "VideoSignalStatus"
 * This Property informs about the video signal state after RVC/AVM visualisation was requested.
 * <p>FUNCID = RVC_CCAFI_C_U16_VIDEOSIGNALSTATUS</p>
 */
class VideoSignalStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VideoSignalStatusStatus ();

    /**
     * Copy constructor
     */
    inline  VideoSignalStatusStatus (const VideoSignalStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VideoSignalStatusStatus (::rvc_cca_fi_types::T_e8_RVC_SignalStatus e8StatusVideoSignal_);

    /**
     * Destructor
     */
    inline virtual  ~VideoSignalStatusStatus();

    /**
     * Assignment operator
     */
    inline VideoSignalStatusStatus& operator = (const VideoSignalStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VideoSignalStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VideoSignalStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VideoSignalStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VideoSignalStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8StatusVideoSignal"

    static const int kE8StatusVideoSignal = 0;

    /**
     * Clears the field "e8StatusVideoSignal".
     *
     * The field will be set to its default value. The hasE8StatusVideoSignal()
     * method will return false.
     */
    inline void clearE8StatusVideoSignal();

    /**
     * Checks whether the field "e8StatusVideoSignal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8StatusVideoSignal()). Otherwise it will return false.
     */
    inline bool hasE8StatusVideoSignal () const;

    /**
     * Returns the value of the member "e8StatusVideoSignal".
     *
     * <p>video signal ok or failure</p>
     *
     * @return The value of the field "e8StatusVideoSignal"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_SignalStatus getE8StatusVideoSignal () const;

    /**
     * Sets the value of the member "e8StatusVideoSignal".
     *
     * <p>video signal ok or failure</p>
     *
     * @param e8StatusVideoSignal The value which will be set
     */
    inline void setE8StatusVideoSignal (::rvc_cca_fi_types::T_e8_RVC_SignalStatus e8StatusVideoSignal_);

    static const VideoSignalStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8StatusVideoSignal ();

    inline void clear_has_e8StatusVideoSignal ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_SignalStatus _e8StatusVideoSignal;

};

/**
 * The error message of 'VideoSignalStatus'
 */
class VideoSignalStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  VideoSignalStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  VideoSignalStatusErrorStructure (const VideoSignalStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  VideoSignalStatusErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~VideoSignalStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline VideoSignalStatusErrorStructure& operator = (const VideoSignalStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VideoSignalStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VideoSignalStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VideoSignalStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VideoSignalStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const VideoSignalStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'VideoSignalStatus'
 */
class VideoSignalStatusError  : public ::asf::core::Payload {
public:

    enum VideoSignalStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  VideoSignalStatusError ();

   /**
     * Copy constructor
     */
    inline  VideoSignalStatusError (const VideoSignalStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~VideoSignalStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline VideoSignalStatusError& operator = (const VideoSignalStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VideoSignalStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VideoSignalStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VideoSignalStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VideoSignalStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline VideoSignalStatusError::VideoSignalStatusErrorField getField () const;

    inline void setField(VideoSignalStatusError::VideoSignalStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "VideoSignalStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "VideoSignalStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const VideoSignalStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline VideoSignalStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline VideoSignalStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (VideoSignalStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "VideoSignalStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const VideoSignalStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const VideoSignalStatusError &getDefaultInstance();

private:

    inline void cloneData (const VideoSignalStatusError& rhs);

    inline void deleteData ();

    VideoSignalStatusErrorField __field;

    union {
        VideoSignalStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "ReverseSignalStatus"
 * This Property informs about the reverse signal state.
 * <p>FUNCID = RVC_CCAFI_C_U16_REVERSESIGNALSTATUS</p>
 */
class ReverseSignalStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReverseSignalStatusStatus ();

    /**
     * Copy constructor
     */
    inline  ReverseSignalStatusStatus (const ReverseSignalStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ReverseSignalStatusStatus (::rvc_cca_fi_types::T_e8_RVC_ReverseSignalStatus e8StatusReverseSignal_);

    /**
     * Destructor
     */
    inline virtual  ~ReverseSignalStatusStatus();

    /**
     * Assignment operator
     */
    inline ReverseSignalStatusStatus& operator = (const ReverseSignalStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReverseSignalStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReverseSignalStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReverseSignalStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReverseSignalStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8StatusReverseSignal"

    static const int kE8StatusReverseSignal = 0;

    /**
     * Clears the field "e8StatusReverseSignal".
     *
     * The field will be set to its default value. The hasE8StatusReverseSignal()
     * method will return false.
     */
    inline void clearE8StatusReverseSignal();

    /**
     * Checks whether the field "e8StatusReverseSignal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8StatusReverseSignal()). Otherwise it will return false.
     */
    inline bool hasE8StatusReverseSignal () const;

    /**
     * Returns the value of the member "e8StatusReverseSignal".
     *
     * <p>reverse signal off,on or on with Nissan debouncing time considered</p>
     *
     * @return The value of the field "e8StatusReverseSignal"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_ReverseSignalStatus getE8StatusReverseSignal () const;

    /**
     * Sets the value of the member "e8StatusReverseSignal".
     *
     * <p>reverse signal off,on or on with Nissan debouncing time considered</p>
     *
     * @param e8StatusReverseSignal The value which will be set
     */
    inline void setE8StatusReverseSignal (::rvc_cca_fi_types::T_e8_RVC_ReverseSignalStatus e8StatusReverseSignal_);

    static const ReverseSignalStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8StatusReverseSignal ();

    inline void clear_has_e8StatusReverseSignal ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_ReverseSignalStatus _e8StatusReverseSignal;

};

/**
 * The error message of 'ReverseSignalStatus'
 */
class ReverseSignalStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ReverseSignalStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ReverseSignalStatusErrorStructure (const ReverseSignalStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ReverseSignalStatusErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~ReverseSignalStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline ReverseSignalStatusErrorStructure& operator = (const ReverseSignalStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReverseSignalStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReverseSignalStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReverseSignalStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReverseSignalStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const ReverseSignalStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'ReverseSignalStatus'
 */
class ReverseSignalStatusError  : public ::asf::core::Payload {
public:

    enum ReverseSignalStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ReverseSignalStatusError ();

   /**
     * Copy constructor
     */
    inline  ReverseSignalStatusError (const ReverseSignalStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ReverseSignalStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline ReverseSignalStatusError& operator = (const ReverseSignalStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReverseSignalStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReverseSignalStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReverseSignalStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReverseSignalStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ReverseSignalStatusError::ReverseSignalStatusErrorField getField () const;

    inline void setField(ReverseSignalStatusError::ReverseSignalStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ReverseSignalStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ReverseSignalStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ReverseSignalStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ReverseSignalStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ReverseSignalStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ReverseSignalStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ReverseSignalStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ReverseSignalStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ReverseSignalStatusError &getDefaultInstance();

private:

    inline void cloneData (const ReverseSignalStatusError& rhs);

    inline void deleteData ();

    ReverseSignalStatusErrorField __field;

    union {
        ReverseSignalStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "Camera_PwrSupplyStatus"
 * This Property informs about the current Camera State (used mainly by Diagnosis)
 */
class Camera_PwrSupplyStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Camera_PwrSupplyStatusStatus ();

    /**
     * Copy constructor
     */
    inline  Camera_PwrSupplyStatusStatus (const Camera_PwrSupplyStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Camera_PwrSupplyStatusStatus (uint16 pwrSupplyID_, ::rvc_cca_fi_types::T_e8_Camera_PowerSupplyStatus status_, uint32 current_);

    /**
     * Destructor
     */
    inline virtual  ~Camera_PwrSupplyStatusStatus();

    /**
     * Assignment operator
     */
    inline Camera_PwrSupplyStatusStatus& operator = (const Camera_PwrSupplyStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Camera_PwrSupplyStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Camera_PwrSupplyStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Camera_PwrSupplyStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Camera_PwrSupplyStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pwrSupplyID"

    static const int kPwrSupplyID = 0;

    /**
     * Clears the field "pwrSupplyID".
     *
     * The field will be set to its default value. The hasPwrSupplyID()
     * method will return false.
     */
    inline void clearPwrSupplyID();

    /**
     * Checks whether the field "pwrSupplyID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPwrSupplyID()). Otherwise it will return false.
     */
    inline bool hasPwrSupplyID () const;

    /**
     * Returns the value of the member "pwrSupplyID".
     *
     * If the meaning of "pwrSupplyID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pwrSupplyID"
     */
    inline uint16 getPwrSupplyID () const;

    /**
     * Sets the value of the member "pwrSupplyID".
     *
     * If the meaning of "pwrSupplyID" isn't clear, then there should be a description here.
     *
     * @param pwrSupplyID The value which will be set
     */
    inline void setPwrSupplyID (uint16 pwrSupplyID_);

    // API of field "status"

    static const int kStatus = 1;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline ::rvc_cca_fi_types::T_e8_Camera_PowerSupplyStatus getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (::rvc_cca_fi_types::T_e8_Camera_PowerSupplyStatus status_);

    // API of field "current"

    static const int kCurrent = 2;

    /**
     * Clears the field "current".
     *
     * The field will be set to its default value. The hasCurrent()
     * method will return false.
     */
    inline void clearCurrent();

    /**
     * Checks whether the field "current" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrent()). Otherwise it will return false.
     */
    inline bool hasCurrent () const;

    /**
     * Returns the value of the member "current".
     *
     * If the meaning of "current" isn't clear, then there should be a description here.
     *
     * @return The value of the field "current"
     */
    inline uint32 getCurrent () const;

    /**
     * Sets the value of the member "current".
     *
     * If the meaning of "current" isn't clear, then there should be a description here.
     *
     * @param current The value which will be set
     */
    inline void setCurrent (uint32 current_);

    static const Camera_PwrSupplyStatusStatus &getDefaultInstance();

private:

    inline void set_has_pwrSupplyID ();

    inline void clear_has_pwrSupplyID ();

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_current ();

    inline void clear_has_current ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _pwrSupplyID;

    ::rvc_cca_fi_types::T_e8_Camera_PowerSupplyStatus _status;

    uint32 _current;

};

/**
 * The error message of 'Camera_PwrSupplyStatus'
 */
class Camera_PwrSupplyStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  Camera_PwrSupplyStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  Camera_PwrSupplyStatusErrorStructure (const Camera_PwrSupplyStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  Camera_PwrSupplyStatusErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~Camera_PwrSupplyStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline Camera_PwrSupplyStatusErrorStructure& operator = (const Camera_PwrSupplyStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Camera_PwrSupplyStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Camera_PwrSupplyStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Camera_PwrSupplyStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Camera_PwrSupplyStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const Camera_PwrSupplyStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'Camera_PwrSupplyStatus'
 */
class Camera_PwrSupplyStatusError  : public ::asf::core::Payload {
public:

    enum Camera_PwrSupplyStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  Camera_PwrSupplyStatusError ();

   /**
     * Copy constructor
     */
    inline  Camera_PwrSupplyStatusError (const Camera_PwrSupplyStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~Camera_PwrSupplyStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline Camera_PwrSupplyStatusError& operator = (const Camera_PwrSupplyStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Camera_PwrSupplyStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Camera_PwrSupplyStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Camera_PwrSupplyStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Camera_PwrSupplyStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline Camera_PwrSupplyStatusError::Camera_PwrSupplyStatusErrorField getField () const;

    inline void setField(Camera_PwrSupplyStatusError::Camera_PwrSupplyStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "Camera_PwrSupplyStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "Camera_PwrSupplyStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const Camera_PwrSupplyStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline Camera_PwrSupplyStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline Camera_PwrSupplyStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (Camera_PwrSupplyStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "Camera_PwrSupplyStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const Camera_PwrSupplyStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const Camera_PwrSupplyStatusError &getDefaultInstance();

private:

    inline void cloneData (const Camera_PwrSupplyStatusError& rhs);

    inline void deleteData ();

    Camera_PwrSupplyStatusErrorField __field;

    union {
        Camera_PwrSupplyStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "Microphone_PwrSupplyStatus"
 * This Property informs about the current Microphone State (used mainly by Diagnosis)
 */
class Microphone_PwrSupplyStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Microphone_PwrSupplyStatusStatus ();

    /**
     * Copy constructor
     */
    inline  Microphone_PwrSupplyStatusStatus (const Microphone_PwrSupplyStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Microphone_PwrSupplyStatusStatus (uint16 pwrSupplyID_, ::rvc_cca_fi_types::T_e8_Microphone_PowerSupplyStatus status_, uint32 current_);

    /**
     * Destructor
     */
    inline virtual  ~Microphone_PwrSupplyStatusStatus();

    /**
     * Assignment operator
     */
    inline Microphone_PwrSupplyStatusStatus& operator = (const Microphone_PwrSupplyStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Microphone_PwrSupplyStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Microphone_PwrSupplyStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Microphone_PwrSupplyStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Microphone_PwrSupplyStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pwrSupplyID"

    static const int kPwrSupplyID = 0;

    /**
     * Clears the field "pwrSupplyID".
     *
     * The field will be set to its default value. The hasPwrSupplyID()
     * method will return false.
     */
    inline void clearPwrSupplyID();

    /**
     * Checks whether the field "pwrSupplyID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPwrSupplyID()). Otherwise it will return false.
     */
    inline bool hasPwrSupplyID () const;

    /**
     * Returns the value of the member "pwrSupplyID".
     *
     * If the meaning of "pwrSupplyID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pwrSupplyID"
     */
    inline uint16 getPwrSupplyID () const;

    /**
     * Sets the value of the member "pwrSupplyID".
     *
     * If the meaning of "pwrSupplyID" isn't clear, then there should be a description here.
     *
     * @param pwrSupplyID The value which will be set
     */
    inline void setPwrSupplyID (uint16 pwrSupplyID_);

    // API of field "status"

    static const int kStatus = 1;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline ::rvc_cca_fi_types::T_e8_Microphone_PowerSupplyStatus getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (::rvc_cca_fi_types::T_e8_Microphone_PowerSupplyStatus status_);

    // API of field "current"

    static const int kCurrent = 2;

    /**
     * Clears the field "current".
     *
     * The field will be set to its default value. The hasCurrent()
     * method will return false.
     */
    inline void clearCurrent();

    /**
     * Checks whether the field "current" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrent()). Otherwise it will return false.
     */
    inline bool hasCurrent () const;

    /**
     * Returns the value of the member "current".
     *
     * If the meaning of "current" isn't clear, then there should be a description here.
     *
     * @return The value of the field "current"
     */
    inline uint32 getCurrent () const;

    /**
     * Sets the value of the member "current".
     *
     * If the meaning of "current" isn't clear, then there should be a description here.
     *
     * @param current The value which will be set
     */
    inline void setCurrent (uint32 current_);

    static const Microphone_PwrSupplyStatusStatus &getDefaultInstance();

private:

    inline void set_has_pwrSupplyID ();

    inline void clear_has_pwrSupplyID ();

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_current ();

    inline void clear_has_current ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _pwrSupplyID;

    ::rvc_cca_fi_types::T_e8_Microphone_PowerSupplyStatus _status;

    uint32 _current;

};

/**
 * The error message of 'Microphone_PwrSupplyStatus'
 */
class Microphone_PwrSupplyStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  Microphone_PwrSupplyStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  Microphone_PwrSupplyStatusErrorStructure (const Microphone_PwrSupplyStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  Microphone_PwrSupplyStatusErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~Microphone_PwrSupplyStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline Microphone_PwrSupplyStatusErrorStructure& operator = (const Microphone_PwrSupplyStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Microphone_PwrSupplyStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Microphone_PwrSupplyStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Microphone_PwrSupplyStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Microphone_PwrSupplyStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const Microphone_PwrSupplyStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'Microphone_PwrSupplyStatus'
 */
class Microphone_PwrSupplyStatusError  : public ::asf::core::Payload {
public:

    enum Microphone_PwrSupplyStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  Microphone_PwrSupplyStatusError ();

   /**
     * Copy constructor
     */
    inline  Microphone_PwrSupplyStatusError (const Microphone_PwrSupplyStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~Microphone_PwrSupplyStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline Microphone_PwrSupplyStatusError& operator = (const Microphone_PwrSupplyStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Microphone_PwrSupplyStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Microphone_PwrSupplyStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Microphone_PwrSupplyStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Microphone_PwrSupplyStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline Microphone_PwrSupplyStatusError::Microphone_PwrSupplyStatusErrorField getField () const;

    inline void setField(Microphone_PwrSupplyStatusError::Microphone_PwrSupplyStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "Microphone_PwrSupplyStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "Microphone_PwrSupplyStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const Microphone_PwrSupplyStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline Microphone_PwrSupplyStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline Microphone_PwrSupplyStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (Microphone_PwrSupplyStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "Microphone_PwrSupplyStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const Microphone_PwrSupplyStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const Microphone_PwrSupplyStatusError &getDefaultInstance();

private:

    inline void cloneData (const Microphone_PwrSupplyStatusError& rhs);

    inline void deleteData ();

    Microphone_PwrSupplyStatusErrorField __field;

    union {
        Microphone_PwrSupplyStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "Tailgate_Status"
 * This Property informs about the current Tailgate State
 */
class Tailgate_StatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Tailgate_StatusStatus ();

    /**
     * Copy constructor
     */
    inline  Tailgate_StatusStatus (const Tailgate_StatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Tailgate_StatusStatus (::rvc_cca_fi_types::T_e8_Tailgate_State State_);

    /**
     * Destructor
     */
    inline virtual  ~Tailgate_StatusStatus();

    /**
     * Assignment operator
     */
    inline Tailgate_StatusStatus& operator = (const Tailgate_StatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Tailgate_StatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Tailgate_StatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Tailgate_StatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Tailgate_StatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "State"

    static const int kState = 0;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     *
     * @return The value of the field "State"
     */
    inline ::rvc_cca_fi_types::T_e8_Tailgate_State getState () const;

    /**
     * Sets the value of the member "State".
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     *
     * @param State The value which will be set
     */
    inline void setState (::rvc_cca_fi_types::T_e8_Tailgate_State State_);

    static const Tailgate_StatusStatus &getDefaultInstance();

private:

    inline void set_has_State ();

    inline void clear_has_State ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_Tailgate_State _State;

};

/**
 * The error message of 'Tailgate_Status'
 */
class Tailgate_StatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  Tailgate_StatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  Tailgate_StatusErrorStructure (const Tailgate_StatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  Tailgate_StatusErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~Tailgate_StatusErrorStructure();

    /**
     * Assignment operator
     */
    inline Tailgate_StatusErrorStructure& operator = (const Tailgate_StatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Tailgate_StatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Tailgate_StatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Tailgate_StatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Tailgate_StatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const Tailgate_StatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'Tailgate_Status'
 */
class Tailgate_StatusError  : public ::asf::core::Payload {
public:

    enum Tailgate_StatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  Tailgate_StatusError ();

   /**
     * Copy constructor
     */
    inline  Tailgate_StatusError (const Tailgate_StatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~Tailgate_StatusError();

    /**
     * Assigns a new value to this object.
     */
    inline Tailgate_StatusError& operator = (const Tailgate_StatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Tailgate_StatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Tailgate_StatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Tailgate_StatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Tailgate_StatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline Tailgate_StatusError::Tailgate_StatusErrorField getField () const;

    inline void setField(Tailgate_StatusError::Tailgate_StatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "Tailgate_StatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "Tailgate_StatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const Tailgate_StatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline Tailgate_StatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline Tailgate_StatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (Tailgate_StatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "Tailgate_StatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const Tailgate_StatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const Tailgate_StatusError &getDefaultInstance();

private:

    inline void cloneData (const Tailgate_StatusError& rhs);

    inline void deleteData ();

    Tailgate_StatusErrorField __field;

    union {
        Tailgate_StatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "View_Close_Authorized"
 * This property informs about the availability of an AVM exit through the HMI (Applicable only for Renault specific AVM)
 * <p>FUNCID = RVC_CCAFI_C_U16_VIEW_CLOSE_AUTHORIZED</p>
 */
class View_Close_AuthorizedStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  View_Close_AuthorizedStatus ();

    /**
     * Copy constructor
     */
    inline  View_Close_AuthorizedStatus (const View_Close_AuthorizedStatus &rhs);

    /**
     * All fields constructor
     */
    inline  View_Close_AuthorizedStatus (::rvc_cca_fi_types::T_e8_Exit_Authorized e8Allowed_);

    /**
     * Destructor
     */
    inline virtual  ~View_Close_AuthorizedStatus();

    /**
     * Assignment operator
     */
    inline View_Close_AuthorizedStatus& operator = (const View_Close_AuthorizedStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const View_Close_AuthorizedStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const View_Close_AuthorizedStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const View_Close_AuthorizedStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const View_Close_AuthorizedStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Allowed"

    static const int kE8Allowed = 0;

    /**
     * Clears the field "e8Allowed".
     *
     * The field will be set to its default value. The hasE8Allowed()
     * method will return false.
     */
    inline void clearE8Allowed();

    /**
     * Checks whether the field "e8Allowed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Allowed()). Otherwise it will return false.
     */
    inline bool hasE8Allowed () const;

    /**
     * Returns the value of the member "e8Allowed".
     *
     * Information about whether it is allowed to Exit AVM.
     * <p>"Unknown"</p>
     * <p>"Not allowed" If the user is allowed to Exit AVM from HMI.</p>
     * <p>"Allowed" If the user is allowed to Exit AVM from HMI.</p>
     *
     * @return The value of the field "e8Allowed"
     */
    inline ::rvc_cca_fi_types::T_e8_Exit_Authorized getE8Allowed () const;

    /**
     * Sets the value of the member "e8Allowed".
     *
     * Information about whether it is allowed to Exit AVM.
     * <p>"Unknown"</p>
     * <p>"Not allowed" If the user is allowed to Exit AVM from HMI.</p>
     * <p>"Allowed" If the user is allowed to Exit AVM from HMI.</p>
     *
     * @param e8Allowed The value which will be set
     */
    inline void setE8Allowed (::rvc_cca_fi_types::T_e8_Exit_Authorized e8Allowed_);

    static const View_Close_AuthorizedStatus &getDefaultInstance();

private:

    inline void set_has_e8Allowed ();

    inline void clear_has_e8Allowed ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_Exit_Authorized _e8Allowed;

};

/**
 * The error message of 'View_Close_Authorized'
 */
class View_Close_AuthorizedErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  View_Close_AuthorizedErrorStructure ();

    /**
     * Copy constructor
     */
    inline  View_Close_AuthorizedErrorStructure (const View_Close_AuthorizedErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  View_Close_AuthorizedErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~View_Close_AuthorizedErrorStructure();

    /**
     * Assignment operator
     */
    inline View_Close_AuthorizedErrorStructure& operator = (const View_Close_AuthorizedErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const View_Close_AuthorizedErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const View_Close_AuthorizedErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const View_Close_AuthorizedErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const View_Close_AuthorizedErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    static const View_Close_AuthorizedErrorStructure &getDefaultInstance();

private:

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _e8ErrorCode;

};

/**
 * The error message of 'View_Close_Authorized'
 */
class View_Close_AuthorizedError  : public ::asf::core::Payload {
public:

    enum View_Close_AuthorizedErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  View_Close_AuthorizedError ();

   /**
     * Copy constructor
     */
    inline  View_Close_AuthorizedError (const View_Close_AuthorizedError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~View_Close_AuthorizedError();

    /**
     * Assigns a new value to this object.
     */
    inline View_Close_AuthorizedError& operator = (const View_Close_AuthorizedError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const View_Close_AuthorizedError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const View_Close_AuthorizedError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const View_Close_AuthorizedError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const View_Close_AuthorizedError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline View_Close_AuthorizedError::View_Close_AuthorizedErrorField getField () const;

    inline void setField(View_Close_AuthorizedError::View_Close_AuthorizedErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "View_Close_AuthorizedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "View_Close_AuthorizedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const View_Close_AuthorizedErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline View_Close_AuthorizedErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline View_Close_AuthorizedErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (View_Close_AuthorizedErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "View_Close_AuthorizedErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const View_Close_AuthorizedErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const View_Close_AuthorizedError &getDefaultInstance();

private:

    inline void cloneData (const View_Close_AuthorizedError& rhs);

    inline void deleteData ();

    View_Close_AuthorizedErrorField __field;

    union {
        View_Close_AuthorizedErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "AvmR_Current_View"
 * This property informs about the availability of an AVM exit through the HMI (Applicable only for Renault specific AVM)
 * <p>FUNCID = RVC_CCAFI_C_U16_AVMR_CURRENT_VIEW</p>
 */
class AvmR_Current_ViewStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AvmR_Current_ViewStatus ();

    /**
     * Copy constructor
     */
    inline  AvmR_Current_ViewStatus (const AvmR_Current_ViewStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AvmR_Current_ViewStatus (::rvc_cca_fi_types::T_e8_AVM_View_Status e8View_);

    /**
     * Destructor
     */
    inline virtual  ~AvmR_Current_ViewStatus();

    /**
     * Assignment operator
     */
    inline AvmR_Current_ViewStatus& operator = (const AvmR_Current_ViewStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AvmR_Current_ViewStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AvmR_Current_ViewStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AvmR_Current_ViewStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AvmR_Current_ViewStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8View"

    static const int kE8View = 0;

    /**
     * Clears the field "e8View".
     *
     * The field will be set to its default value. The hasE8View()
     * method will return false.
     */
    inline void clearE8View();

    /**
     * Checks whether the field "e8View" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8View()). Otherwise it will return false.
     */
    inline bool hasE8View () const;

    /**
     * Returns the value of the member "e8View".
     *
     * Information about which is the current view which is shown.
     *
     * @return The value of the field "e8View"
     */
    inline ::rvc_cca_fi_types::T_e8_AVM_View_Status getE8View () const;

    /**
     * Sets the value of the member "e8View".
     *
     * Information about which is the current view which is shown.
     *
     * @param e8View The value which will be set
     */
    inline void setE8View (::rvc_cca_fi_types::T_e8_AVM_View_Status e8View_);

    static const AvmR_Current_ViewStatus &getDefaultInstance();

private:

    inline void set_has_e8View ();

    inline void clear_has_e8View ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_AVM_View_Status _e8View;

};

/**
 * The error message of 'AvmR_Current_View'
 */
class AvmR_Current_ViewErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AvmR_Current_ViewErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AvmR_Current_ViewErrorStructure (const AvmR_Current_ViewErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AvmR_Current_ViewErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~AvmR_Current_ViewErrorStructure();

    /**
     * Assignment operator
     */
    inline AvmR_Current_ViewErrorStructure& operator = (const AvmR_Current_ViewErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AvmR_Current_ViewErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AvmR_Current_ViewErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AvmR_Current_ViewErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AvmR_Current_ViewErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    static const AvmR_Current_ViewErrorStructure &getDefaultInstance();

private:

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _e8ErrorCode;

};

/**
 * The error message of 'AvmR_Current_View'
 */
class AvmR_Current_ViewError  : public ::asf::core::Payload {
public:

    enum AvmR_Current_ViewErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AvmR_Current_ViewError ();

   /**
     * Copy constructor
     */
    inline  AvmR_Current_ViewError (const AvmR_Current_ViewError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AvmR_Current_ViewError();

    /**
     * Assigns a new value to this object.
     */
    inline AvmR_Current_ViewError& operator = (const AvmR_Current_ViewError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AvmR_Current_ViewError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AvmR_Current_ViewError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AvmR_Current_ViewError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AvmR_Current_ViewError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AvmR_Current_ViewError::AvmR_Current_ViewErrorField getField () const;

    inline void setField(AvmR_Current_ViewError::AvmR_Current_ViewErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AvmR_Current_ViewErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AvmR_Current_ViewErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AvmR_Current_ViewErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AvmR_Current_ViewErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AvmR_Current_ViewErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AvmR_Current_ViewErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AvmR_Current_ViewErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AvmR_Current_ViewErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AvmR_Current_ViewError &getDefaultInstance();

private:

    inline void cloneData (const AvmR_Current_ViewError& rhs);

    inline void deleteData ();

    AvmR_Current_ViewErrorField __field;

    union {
        AvmR_Current_ViewErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "Affordable_ITS"
 * This property informs about the availability of an Affordable ITS unit and it's configuration states
 * <p>FUNCID = RVC_CCAFI_C_U16_AFFORDABLE_ITS</p>
 */
class Affordable_ITSStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Affordable_ITSStatus ();

    /**
     * Copy constructor
     */
    inline  Affordable_ITSStatus (const Affordable_ITSStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Affordable_ITSStatus (::rvc_cca_fi_types::T_e8_AffordableIts_Status e8AffordableItsAvailable_, ::rvc_cca_fi_types::T_e8_AffordableIts_StatusFeature e8BswStatus_, ::rvc_cca_fi_types::T_e8_AffordableIts_StatusFeature e8ModStatus_, ::rvc_cca_fi_types::T_e8_AffordableIts_StatusFeature e8LdwStatus_);

    /**
     * Destructor
     */
    inline virtual  ~Affordable_ITSStatus();

    /**
     * Assignment operator
     */
    inline Affordable_ITSStatus& operator = (const Affordable_ITSStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Affordable_ITSStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Affordable_ITSStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Affordable_ITSStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Affordable_ITSStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8AffordableItsAvailable"

    static const int kE8AffordableItsAvailable = 0;

    /**
     * Clears the field "e8AffordableItsAvailable".
     *
     * The field will be set to its default value. The hasE8AffordableItsAvailable()
     * method will return false.
     */
    inline void clearE8AffordableItsAvailable();

    /**
     * Checks whether the field "e8AffordableItsAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AffordableItsAvailable()). Otherwise it will return false.
     */
    inline bool hasE8AffordableItsAvailable () const;

    /**
     * Returns the value of the member "e8AffordableItsAvailable".
     *
     * Information about the availability of an Affordable ITS.
     * <p>"Not available" if a no AVM is configured or if configured but the connected one is not identified as an "Affordable ITS".</p>
     * <p>"Initializing" if init process between AVM and RVC_Server is running.</p>
     * <p>"Available" if the connected AVM is identified as "Affordable ITS".</p>
     *
     * @return The value of the field "e8AffordableItsAvailable"
     */
    inline ::rvc_cca_fi_types::T_e8_AffordableIts_Status getE8AffordableItsAvailable () const;

    /**
     * Sets the value of the member "e8AffordableItsAvailable".
     *
     * Information about the availability of an Affordable ITS.
     * <p>"Not available" if a no AVM is configured or if configured but the connected one is not identified as an "Affordable ITS".</p>
     * <p>"Initializing" if init process between AVM and RVC_Server is running.</p>
     * <p>"Available" if the connected AVM is identified as "Affordable ITS".</p>
     *
     * @param e8AffordableItsAvailable The value which will be set
     */
    inline void setE8AffordableItsAvailable (::rvc_cca_fi_types::T_e8_AffordableIts_Status e8AffordableItsAvailable_);

    // API of field "e8BswStatus"

    static const int kE8BswStatus = 1;

    /**
     * Clears the field "e8BswStatus".
     *
     * The field will be set to its default value. The hasE8BswStatus()
     * method will return false.
     */
    inline void clearE8BswStatus();

    /**
     * Checks whether the field "e8BswStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8BswStatus()). Otherwise it will return false.
     */
    inline bool hasE8BswStatus () const;

    /**
     * Returns the value of the member "e8BswStatus".
     *
     * <p>Information about activation or deactivation of Blind Spot Warning.</p>
     * <p>Default value is "UNKNOWN".</p>
     * <p>Value is not valid in case "Affordable ITS" is not available.</p>
     *
     * @return The value of the field "e8BswStatus"
     */
    inline ::rvc_cca_fi_types::T_e8_AffordableIts_StatusFeature getE8BswStatus () const;

    /**
     * Sets the value of the member "e8BswStatus".
     *
     * <p>Information about activation or deactivation of Blind Spot Warning.</p>
     * <p>Default value is "UNKNOWN".</p>
     * <p>Value is not valid in case "Affordable ITS" is not available.</p>
     *
     * @param e8BswStatus The value which will be set
     */
    inline void setE8BswStatus (::rvc_cca_fi_types::T_e8_AffordableIts_StatusFeature e8BswStatus_);

    // API of field "e8ModStatus"

    static const int kE8ModStatus = 2;

    /**
     * Clears the field "e8ModStatus".
     *
     * The field will be set to its default value. The hasE8ModStatus()
     * method will return false.
     */
    inline void clearE8ModStatus();

    /**
     * Checks whether the field "e8ModStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ModStatus()). Otherwise it will return false.
     */
    inline bool hasE8ModStatus () const;

    /**
     * Returns the value of the member "e8ModStatus".
     *
     * <p>Information about activation or deactivation of Motion Object Detection.</p>
     * <p>Default value is "UNKNOWN".</p>
     * <p>Value is not valid in case "Affordable ITS" is not available.</p>
     *
     * @return The value of the field "e8ModStatus"
     */
    inline ::rvc_cca_fi_types::T_e8_AffordableIts_StatusFeature getE8ModStatus () const;

    /**
     * Sets the value of the member "e8ModStatus".
     *
     * <p>Information about activation or deactivation of Motion Object Detection.</p>
     * <p>Default value is "UNKNOWN".</p>
     * <p>Value is not valid in case "Affordable ITS" is not available.</p>
     *
     * @param e8ModStatus The value which will be set
     */
    inline void setE8ModStatus (::rvc_cca_fi_types::T_e8_AffordableIts_StatusFeature e8ModStatus_);

    // API of field "e8LdwStatus"

    static const int kE8LdwStatus = 3;

    /**
     * Clears the field "e8LdwStatus".
     *
     * The field will be set to its default value. The hasE8LdwStatus()
     * method will return false.
     */
    inline void clearE8LdwStatus();

    /**
     * Checks whether the field "e8LdwStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8LdwStatus()). Otherwise it will return false.
     */
    inline bool hasE8LdwStatus () const;

    /**
     * Returns the value of the member "e8LdwStatus".
     *
     * <p>Information about activation or deactivation of Lane Departure Warning.</p>
     * <p>Default value is "UNKNOWN".</p>
     * <p>Value is not valid in case "Affordable ITS" is not available.</p>
     *
     * @return The value of the field "e8LdwStatus"
     */
    inline ::rvc_cca_fi_types::T_e8_AffordableIts_StatusFeature getE8LdwStatus () const;

    /**
     * Sets the value of the member "e8LdwStatus".
     *
     * <p>Information about activation or deactivation of Lane Departure Warning.</p>
     * <p>Default value is "UNKNOWN".</p>
     * <p>Value is not valid in case "Affordable ITS" is not available.</p>
     *
     * @param e8LdwStatus The value which will be set
     */
    inline void setE8LdwStatus (::rvc_cca_fi_types::T_e8_AffordableIts_StatusFeature e8LdwStatus_);

    static const Affordable_ITSStatus &getDefaultInstance();

private:

    inline void set_has_e8AffordableItsAvailable ();

    inline void clear_has_e8AffordableItsAvailable ();

    inline void set_has_e8BswStatus ();

    inline void clear_has_e8BswStatus ();

    inline void set_has_e8ModStatus ();

    inline void clear_has_e8ModStatus ();

    inline void set_has_e8LdwStatus ();

    inline void clear_has_e8LdwStatus ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_AffordableIts_Status _e8AffordableItsAvailable;

    ::rvc_cca_fi_types::T_e8_AffordableIts_StatusFeature _e8BswStatus;

    ::rvc_cca_fi_types::T_e8_AffordableIts_StatusFeature _e8ModStatus;

    ::rvc_cca_fi_types::T_e8_AffordableIts_StatusFeature _e8LdwStatus;

};

/**
 * The error message of 'Affordable_ITS'
 */
class Affordable_ITSErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  Affordable_ITSErrorStructure ();

    /**
     * Copy constructor
     */
    inline  Affordable_ITSErrorStructure (const Affordable_ITSErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  Affordable_ITSErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~Affordable_ITSErrorStructure();

    /**
     * Assignment operator
     */
    inline Affordable_ITSErrorStructure& operator = (const Affordable_ITSErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Affordable_ITSErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Affordable_ITSErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Affordable_ITSErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Affordable_ITSErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    static const Affordable_ITSErrorStructure &getDefaultInstance();

private:

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _e8ErrorCode;

};

/**
 * The error message of 'Affordable_ITS'
 */
class Affordable_ITSError  : public ::asf::core::Payload {
public:

    enum Affordable_ITSErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  Affordable_ITSError ();

   /**
     * Copy constructor
     */
    inline  Affordable_ITSError (const Affordable_ITSError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~Affordable_ITSError();

    /**
     * Assigns a new value to this object.
     */
    inline Affordable_ITSError& operator = (const Affordable_ITSError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Affordable_ITSError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Affordable_ITSError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Affordable_ITSError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Affordable_ITSError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline Affordable_ITSError::Affordable_ITSErrorField getField () const;

    inline void setField(Affordable_ITSError::Affordable_ITSErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "Affordable_ITSErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "Affordable_ITSErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const Affordable_ITSErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline Affordable_ITSErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline Affordable_ITSErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (Affordable_ITSErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "Affordable_ITSErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const Affordable_ITSErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const Affordable_ITSError &getDefaultInstance();

private:

    inline void cloneData (const Affordable_ITSError& rhs);

    inline void deleteData ();

    Affordable_ITSErrorField __field;

    union {
        Affordable_ITSErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "IPAConfiguration"
 * This Property informs about the IPA configuration
 * <p>FUNCID = RVC_CCAFI_C_U16_IPACONFIGURATION</p>
 */
class IPAConfigurationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IPAConfigurationStatus ();

    /**
     * Copy constructor
     */
    inline  IPAConfigurationStatus (const IPAConfigurationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  IPAConfigurationStatus (::rvc_cca_fi_types::T_e8_IPA_AvailabilityStatus e8AvailabilityStatus_, ::rvc_cca_fi_types::T_e8_IPA_RegionalSelection e8RegionalSelection_);

    /**
     * Destructor
     */
    inline virtual  ~IPAConfigurationStatus();

    /**
     * Assignment operator
     */
    inline IPAConfigurationStatus& operator = (const IPAConfigurationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPAConfigurationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPAConfigurationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPAConfigurationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPAConfigurationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8AvailabilityStatus"

    static const int kE8AvailabilityStatus = 0;

    /**
     * Clears the field "e8AvailabilityStatus".
     *
     * The field will be set to its default value. The hasE8AvailabilityStatus()
     * method will return false.
     */
    inline void clearE8AvailabilityStatus();

    /**
     * Checks whether the field "e8AvailabilityStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AvailabilityStatus()). Otherwise it will return false.
     */
    inline bool hasE8AvailabilityStatus () const;

    /**
     * Returns the value of the member "e8AvailabilityStatus".
     *
     * <p>IPA Availablity, only if IPA is available then the HMI is allowed to draw the IPA switch</p>
     *
     * @return The value of the field "e8AvailabilityStatus"
     */
    inline ::rvc_cca_fi_types::T_e8_IPA_AvailabilityStatus getE8AvailabilityStatus () const;

    /**
     * Sets the value of the member "e8AvailabilityStatus".
     *
     * <p>IPA Availablity, only if IPA is available then the HMI is allowed to draw the IPA switch</p>
     *
     * @param e8AvailabilityStatus The value which will be set
     */
    inline void setE8AvailabilityStatus (::rvc_cca_fi_types::T_e8_IPA_AvailabilityStatus e8AvailabilityStatus_);

    // API of field "e8RegionalSelection"

    static const int kE8RegionalSelection = 1;

    /**
     * Clears the field "e8RegionalSelection".
     *
     * The field will be set to its default value. The hasE8RegionalSelection()
     * method will return false.
     */
    inline void clearE8RegionalSelection();

    /**
     * Checks whether the field "e8RegionalSelection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8RegionalSelection()). Otherwise it will return false.
     */
    inline bool hasE8RegionalSelection () const;

    /**
     * Returns the value of the member "e8RegionalSelection".
     *
     * <p>This is the configured region for the IPA</p>
     *
     * @return The value of the field "e8RegionalSelection"
     */
    inline ::rvc_cca_fi_types::T_e8_IPA_RegionalSelection getE8RegionalSelection () const;

    /**
     * Sets the value of the member "e8RegionalSelection".
     *
     * <p>This is the configured region for the IPA</p>
     *
     * @param e8RegionalSelection The value which will be set
     */
    inline void setE8RegionalSelection (::rvc_cca_fi_types::T_e8_IPA_RegionalSelection e8RegionalSelection_);

    static const IPAConfigurationStatus &getDefaultInstance();

private:

    inline void set_has_e8AvailabilityStatus ();

    inline void clear_has_e8AvailabilityStatus ();

    inline void set_has_e8RegionalSelection ();

    inline void clear_has_e8RegionalSelection ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_IPA_AvailabilityStatus _e8AvailabilityStatus;

    ::rvc_cca_fi_types::T_e8_IPA_RegionalSelection _e8RegionalSelection;

};

/**
 * The error message of 'IPAConfiguration'
 */
class IPAConfigurationErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  IPAConfigurationErrorStructure ();

    /**
     * Copy constructor
     */
    inline  IPAConfigurationErrorStructure (const IPAConfigurationErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  IPAConfigurationErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~IPAConfigurationErrorStructure();

    /**
     * Assignment operator
     */
    inline IPAConfigurationErrorStructure& operator = (const IPAConfigurationErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPAConfigurationErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPAConfigurationErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPAConfigurationErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPAConfigurationErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const IPAConfigurationErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'IPAConfiguration'
 */
class IPAConfigurationError  : public ::asf::core::Payload {
public:

    enum IPAConfigurationErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  IPAConfigurationError ();

   /**
     * Copy constructor
     */
    inline  IPAConfigurationError (const IPAConfigurationError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~IPAConfigurationError();

    /**
     * Assigns a new value to this object.
     */
    inline IPAConfigurationError& operator = (const IPAConfigurationError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPAConfigurationError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPAConfigurationError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPAConfigurationError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPAConfigurationError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline IPAConfigurationError::IPAConfigurationErrorField getField () const;

    inline void setField(IPAConfigurationError::IPAConfigurationErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "IPAConfigurationErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "IPAConfigurationErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const IPAConfigurationErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline IPAConfigurationErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline IPAConfigurationErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (IPAConfigurationErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "IPAConfigurationErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const IPAConfigurationErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const IPAConfigurationError &getDefaultInstance();

private:

    inline void cloneData (const IPAConfigurationError& rhs);

    inline void deleteData ();

    IPAConfigurationErrorField __field;

    union {
        IPAConfigurationErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "IPAStatus"
 * This Property informs about the IPA status.
 * <p>FUNCID = RVC_CCAFI_C_U16_IPASTATUS</p>
 */
class IPAStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IPAStatusStatus ();

    /**
     * Copy constructor
     */
    inline  IPAStatusStatus (const IPAStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  IPAStatusStatus (::rvc_cca_fi_types::T_e8_IPA_OperationStatus e8OperationStatus_, ::rvc_cca_fi_types::T_e8_IPA_ModeChangeRequest e8Request_);

    /**
     * Destructor
     */
    inline virtual  ~IPAStatusStatus();

    /**
     * Assignment operator
     */
    inline IPAStatusStatus& operator = (const IPAStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPAStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPAStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPAStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPAStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8OperationStatus"

    static const int kE8OperationStatus = 0;

    /**
     * Clears the field "e8OperationStatus".
     *
     * The field will be set to its default value. The hasE8OperationStatus()
     * method will return false.
     */
    inline void clearE8OperationStatus();

    /**
     * Checks whether the field "e8OperationStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8OperationStatus()). Otherwise it will return false.
     */
    inline bool hasE8OperationStatus () const;

    /**
     * Returns the value of the member "e8OperationStatus".
     *
     * <p>IPA operational status (normal or malfunction)</p>
     *
     * @return The value of the field "e8OperationStatus"
     */
    inline ::rvc_cca_fi_types::T_e8_IPA_OperationStatus getE8OperationStatus () const;

    /**
     * Sets the value of the member "e8OperationStatus".
     *
     * <p>IPA operational status (normal or malfunction)</p>
     *
     * @param e8OperationStatus The value which will be set
     */
    inline void setE8OperationStatus (::rvc_cca_fi_types::T_e8_IPA_OperationStatus e8OperationStatus_);

    // API of field "e8Request"

    static const int kE8Request = 1;

    /**
     * Clears the field "e8Request".
     *
     * The field will be set to its default value. The hasE8Request()
     * method will return false.
     */
    inline void clearE8Request();

    /**
     * Checks whether the field "e8Request" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Request()). Otherwise it will return false.
     */
    inline bool hasE8Request () const;

    /**
     * Returns the value of the member "e8Request".
     *
     * <p>IPA screen requested or not</p>
     *
     * @return The value of the field "e8Request"
     */
    inline ::rvc_cca_fi_types::T_e8_IPA_ModeChangeRequest getE8Request () const;

    /**
     * Sets the value of the member "e8Request".
     *
     * <p>IPA screen requested or not</p>
     *
     * @param e8Request The value which will be set
     */
    inline void setE8Request (::rvc_cca_fi_types::T_e8_IPA_ModeChangeRequest e8Request_);

    static const IPAStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8OperationStatus ();

    inline void clear_has_e8OperationStatus ();

    inline void set_has_e8Request ();

    inline void clear_has_e8Request ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_IPA_OperationStatus _e8OperationStatus;

    ::rvc_cca_fi_types::T_e8_IPA_ModeChangeRequest _e8Request;

};

/**
 * The error message of 'IPAStatus'
 */
class IPAStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  IPAStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  IPAStatusErrorStructure (const IPAStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  IPAStatusErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~IPAStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline IPAStatusErrorStructure& operator = (const IPAStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPAStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPAStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPAStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPAStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const IPAStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'IPAStatus'
 */
class IPAStatusError  : public ::asf::core::Payload {
public:

    enum IPAStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  IPAStatusError ();

   /**
     * Copy constructor
     */
    inline  IPAStatusError (const IPAStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~IPAStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline IPAStatusError& operator = (const IPAStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPAStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPAStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPAStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPAStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline IPAStatusError::IPAStatusErrorField getField () const;

    inline void setField(IPAStatusError::IPAStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "IPAStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "IPAStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const IPAStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline IPAStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline IPAStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (IPAStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "IPAStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const IPAStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const IPAStatusError &getDefaultInstance();

private:

    inline void cloneData (const IPAStatusError& rhs);

    inline void deleteData ();

    IPAStatusErrorField __field;

    union {
        IPAStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "IPAPatternRequest"
 * This Property informs about the current requested screen pattern by IPA.
 * <p>FUNCID = RVC_CCAFI_C_U16_IPAPATTERNREQUEST</p>
 */
class IPAPatternRequestStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IPAPatternRequestStatus ();

    /**
     * Copy constructor
     */
    inline  IPAPatternRequestStatus (const IPAPatternRequestStatus &rhs);

    /**
     * All fields constructor
     */
    inline  IPAPatternRequestStatus (::rvc_cca_fi_types::T_e8_IPA_PatternID e8DisplayPattern_);

    /**
     * Destructor
     */
    inline virtual  ~IPAPatternRequestStatus();

    /**
     * Assignment operator
     */
    inline IPAPatternRequestStatus& operator = (const IPAPatternRequestStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPAPatternRequestStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPAPatternRequestStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPAPatternRequestStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPAPatternRequestStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DisplayPattern"

    static const int kE8DisplayPattern = 0;

    /**
     * Clears the field "e8DisplayPattern".
     *
     * The field will be set to its default value. The hasE8DisplayPattern()
     * method will return false.
     */
    inline void clearE8DisplayPattern();

    /**
     * Checks whether the field "e8DisplayPattern" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DisplayPattern()). Otherwise it will return false.
     */
    inline bool hasE8DisplayPattern () const;

    /**
     * Returns the value of the member "e8DisplayPattern".
     *
     * The requested screen pattern number (predefined by Nissan)
     *
     * @return The value of the field "e8DisplayPattern"
     */
    inline ::rvc_cca_fi_types::T_e8_IPA_PatternID getE8DisplayPattern () const;

    /**
     * Sets the value of the member "e8DisplayPattern".
     *
     * The requested screen pattern number (predefined by Nissan)
     *
     * @param e8DisplayPattern The value which will be set
     */
    inline void setE8DisplayPattern (::rvc_cca_fi_types::T_e8_IPA_PatternID e8DisplayPattern_);

    static const IPAPatternRequestStatus &getDefaultInstance();

private:

    inline void set_has_e8DisplayPattern ();

    inline void clear_has_e8DisplayPattern ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_IPA_PatternID _e8DisplayPattern;

};

/**
 * The error message of 'IPAPatternRequest'
 */
class IPAPatternRequestErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  IPAPatternRequestErrorStructure ();

    /**
     * Copy constructor
     */
    inline  IPAPatternRequestErrorStructure (const IPAPatternRequestErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  IPAPatternRequestErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~IPAPatternRequestErrorStructure();

    /**
     * Assignment operator
     */
    inline IPAPatternRequestErrorStructure& operator = (const IPAPatternRequestErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPAPatternRequestErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPAPatternRequestErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPAPatternRequestErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPAPatternRequestErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const IPAPatternRequestErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'IPAPatternRequest'
 */
class IPAPatternRequestError  : public ::asf::core::Payload {
public:

    enum IPAPatternRequestErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  IPAPatternRequestError ();

   /**
     * Copy constructor
     */
    inline  IPAPatternRequestError (const IPAPatternRequestError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~IPAPatternRequestError();

    /**
     * Assigns a new value to this object.
     */
    inline IPAPatternRequestError& operator = (const IPAPatternRequestError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPAPatternRequestError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPAPatternRequestError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPAPatternRequestError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPAPatternRequestError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline IPAPatternRequestError::IPAPatternRequestErrorField getField () const;

    inline void setField(IPAPatternRequestError::IPAPatternRequestErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "IPAPatternRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "IPAPatternRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const IPAPatternRequestErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline IPAPatternRequestErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline IPAPatternRequestErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (IPAPatternRequestErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "IPAPatternRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const IPAPatternRequestErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const IPAPatternRequestError &getDefaultInstance();

private:

    inline void cloneData (const IPAPatternRequestError& rhs);

    inline void deleteData ();

    IPAPatternRequestErrorField __field;

    union {
        IPAPatternRequestErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "IPAMessageRequest"
 * This Property informs about the current requested message lines by IPA.
 * <p>FUNCID = RVC_CCAFI_C_U16_IPAMESSAGEREQUEST</p>
 */
class IPAMessageRequestStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IPAMessageRequestStatus ();

    /**
     * Copy constructor
     */
    inline  IPAMessageRequestStatus (const IPAMessageRequestStatus &rhs);

    /**
     * All fields constructor
     */
    inline  IPAMessageRequestStatus (::rvc_cca_fi_types::T_e8_IPA_MessageID e8MessageID_);

    /**
     * Destructor
     */
    inline virtual  ~IPAMessageRequestStatus();

    /**
     * Assignment operator
     */
    inline IPAMessageRequestStatus& operator = (const IPAMessageRequestStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPAMessageRequestStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPAMessageRequestStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPAMessageRequestStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPAMessageRequestStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MessageID"

    static const int kE8MessageID = 0;

    /**
     * Clears the field "e8MessageID".
     *
     * The field will be set to its default value. The hasE8MessageID()
     * method will return false.
     */
    inline void clearE8MessageID();

    /**
     * Checks whether the field "e8MessageID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MessageID()). Otherwise it will return false.
     */
    inline bool hasE8MessageID () const;

    /**
     * Returns the value of the member "e8MessageID".
     *
     * The requested message ID (predefined by Nissan)
     *
     * @return The value of the field "e8MessageID"
     */
    inline ::rvc_cca_fi_types::T_e8_IPA_MessageID getE8MessageID () const;

    /**
     * Sets the value of the member "e8MessageID".
     *
     * The requested message ID (predefined by Nissan)
     *
     * @param e8MessageID The value which will be set
     */
    inline void setE8MessageID (::rvc_cca_fi_types::T_e8_IPA_MessageID e8MessageID_);

    static const IPAMessageRequestStatus &getDefaultInstance();

private:

    inline void set_has_e8MessageID ();

    inline void clear_has_e8MessageID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_IPA_MessageID _e8MessageID;

};

/**
 * The error message of 'IPAMessageRequest'
 */
class IPAMessageRequestErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  IPAMessageRequestErrorStructure ();

    /**
     * Copy constructor
     */
    inline  IPAMessageRequestErrorStructure (const IPAMessageRequestErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  IPAMessageRequestErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~IPAMessageRequestErrorStructure();

    /**
     * Assignment operator
     */
    inline IPAMessageRequestErrorStructure& operator = (const IPAMessageRequestErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPAMessageRequestErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPAMessageRequestErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPAMessageRequestErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPAMessageRequestErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const IPAMessageRequestErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'IPAMessageRequest'
 */
class IPAMessageRequestError  : public ::asf::core::Payload {
public:

    enum IPAMessageRequestErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  IPAMessageRequestError ();

   /**
     * Copy constructor
     */
    inline  IPAMessageRequestError (const IPAMessageRequestError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~IPAMessageRequestError();

    /**
     * Assigns a new value to this object.
     */
    inline IPAMessageRequestError& operator = (const IPAMessageRequestError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPAMessageRequestError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPAMessageRequestError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPAMessageRequestError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPAMessageRequestError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline IPAMessageRequestError::IPAMessageRequestErrorField getField () const;

    inline void setField(IPAMessageRequestError::IPAMessageRequestErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "IPAMessageRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "IPAMessageRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const IPAMessageRequestErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline IPAMessageRequestErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline IPAMessageRequestErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (IPAMessageRequestErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "IPAMessageRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const IPAMessageRequestErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const IPAMessageRequestError &getDefaultInstance();

private:

    inline void cloneData (const IPAMessageRequestError& rhs);

    inline void deleteData ();

    IPAMessageRequestErrorField __field;

    union {
        IPAMessageRequestErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "IPASwitchMaskRequest"
 * This Property informs about the current requested switch mask by IPA.
 * <p>FUNCID = RVC_CCAFI_C_U16_IPASWITCHMASKREQUEST</p>
 */
class IPASwitchMaskRequestStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IPASwitchMaskRequestStatus ();

    /**
     * Copy constructor
     */
    inline  IPASwitchMaskRequestStatus (const IPASwitchMaskRequestStatus &rhs);

    /**
     * All fields constructor
     */
    inline  IPASwitchMaskRequestStatus (::rvc_cca_fi_types::T_e8_IPA_SwitchMask e8SwitchMask_);

    /**
     * Destructor
     */
    inline virtual  ~IPASwitchMaskRequestStatus();

    /**
     * Assignment operator
     */
    inline IPASwitchMaskRequestStatus& operator = (const IPASwitchMaskRequestStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPASwitchMaskRequestStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPASwitchMaskRequestStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPASwitchMaskRequestStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPASwitchMaskRequestStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8SwitchMask"

    static const int kE8SwitchMask = 0;

    /**
     * Clears the field "e8SwitchMask".
     *
     * The field will be set to its default value. The hasE8SwitchMask()
     * method will return false.
     */
    inline void clearE8SwitchMask();

    /**
     * Checks whether the field "e8SwitchMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SwitchMask()). Otherwise it will return false.
     */
    inline bool hasE8SwitchMask () const;

    /**
     * Returns the value of the member "e8SwitchMask".
     *
     * The requested switch mask
     *
     * @return The value of the field "e8SwitchMask"
     */
    inline ::rvc_cca_fi_types::T_e8_IPA_SwitchMask getE8SwitchMask () const;

    /**
     * Sets the value of the member "e8SwitchMask".
     *
     * The requested switch mask
     *
     * @param e8SwitchMask The value which will be set
     */
    inline void setE8SwitchMask (::rvc_cca_fi_types::T_e8_IPA_SwitchMask e8SwitchMask_);

    static const IPASwitchMaskRequestStatus &getDefaultInstance();

private:

    inline void set_has_e8SwitchMask ();

    inline void clear_has_e8SwitchMask ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_IPA_SwitchMask _e8SwitchMask;

};

/**
 * The error message of 'IPASwitchMaskRequest'
 */
class IPASwitchMaskRequestErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  IPASwitchMaskRequestErrorStructure ();

    /**
     * Copy constructor
     */
    inline  IPASwitchMaskRequestErrorStructure (const IPASwitchMaskRequestErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  IPASwitchMaskRequestErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~IPASwitchMaskRequestErrorStructure();

    /**
     * Assignment operator
     */
    inline IPASwitchMaskRequestErrorStructure& operator = (const IPASwitchMaskRequestErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPASwitchMaskRequestErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPASwitchMaskRequestErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPASwitchMaskRequestErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPASwitchMaskRequestErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const IPASwitchMaskRequestErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'IPASwitchMaskRequest'
 */
class IPASwitchMaskRequestError  : public ::asf::core::Payload {
public:

    enum IPASwitchMaskRequestErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  IPASwitchMaskRequestError ();

   /**
     * Copy constructor
     */
    inline  IPASwitchMaskRequestError (const IPASwitchMaskRequestError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~IPASwitchMaskRequestError();

    /**
     * Assigns a new value to this object.
     */
    inline IPASwitchMaskRequestError& operator = (const IPASwitchMaskRequestError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPASwitchMaskRequestError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPASwitchMaskRequestError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPASwitchMaskRequestError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPASwitchMaskRequestError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline IPASwitchMaskRequestError::IPASwitchMaskRequestErrorField getField () const;

    inline void setField(IPASwitchMaskRequestError::IPASwitchMaskRequestErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "IPASwitchMaskRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "IPASwitchMaskRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const IPASwitchMaskRequestErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline IPASwitchMaskRequestErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline IPASwitchMaskRequestErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (IPASwitchMaskRequestErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "IPASwitchMaskRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const IPASwitchMaskRequestErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const IPASwitchMaskRequestError &getDefaultInstance();

private:

    inline void cloneData (const IPASwitchMaskRequestError& rhs);

    inline void deleteData ();

    IPASwitchMaskRequestErrorField __field;

    union {
        IPASwitchMaskRequestErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "IPASwitchGreyOutRequest"
 * This Property informs about the current requested switch grey out by IPA.
 * <p>FUNCID = RVC_CCAFI_C_U16_IPASWITCHGREYOUTREQUEST</p>
 */
class IPASwitchGreyOutRequestStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IPASwitchGreyOutRequestStatus ();

    /**
     * Copy constructor
     */
    inline  IPASwitchGreyOutRequestStatus (const IPASwitchGreyOutRequestStatus &rhs);

    /**
     * All fields constructor
     */
    inline  IPASwitchGreyOutRequestStatus (uint8 u8SwitchGreyOut_);

    /**
     * Destructor
     */
    inline virtual  ~IPASwitchGreyOutRequestStatus();

    /**
     * Assignment operator
     */
    inline IPASwitchGreyOutRequestStatus& operator = (const IPASwitchGreyOutRequestStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPASwitchGreyOutRequestStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPASwitchGreyOutRequestStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPASwitchGreyOutRequestStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPASwitchGreyOutRequestStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8SwitchGreyOut"

    static const int kU8SwitchGreyOut = 0;

    /**
     * Clears the field "u8SwitchGreyOut".
     *
     * The field will be set to its default value. The hasU8SwitchGreyOut()
     * method will return false.
     */
    inline void clearU8SwitchGreyOut();

    /**
     * Checks whether the field "u8SwitchGreyOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SwitchGreyOut()). Otherwise it will return false.
     */
    inline bool hasU8SwitchGreyOut () const;

    /**
     * Returns the value of the member "u8SwitchGreyOut".
     *
     * <p>This is a bitmask with Bits 0..5:</p>
     * <p>- Bit 0 = Arrow Key [Up]</p>
     * <p>- Bit 1 = Arrow Key [Down]</p>
     * <p>- Bit 2 = Arrow Key [Left]</p>
     * <p>- Bit 3 = Arrow Key [Right]</p>
     * <p>- Bit 4 = Arrow Key [CCW]</p>
     * <p>- Bit 5 = Arrow Key [CW]</p>
     * <p>If the bit is set then the arrow key is grayed out (disabled),
     * if the  bit is cleared then the arrow key is shown</p>
     * <p>The arrow keys are only to be displayed on specified screen patterns!</p>
     *
     * @return The value of the field "u8SwitchGreyOut"
     */
    inline uint8 getU8SwitchGreyOut () const;

    /**
     * Sets the value of the member "u8SwitchGreyOut".
     *
     * <p>This is a bitmask with Bits 0..5:</p>
     * <p>- Bit 0 = Arrow Key [Up]</p>
     * <p>- Bit 1 = Arrow Key [Down]</p>
     * <p>- Bit 2 = Arrow Key [Left]</p>
     * <p>- Bit 3 = Arrow Key [Right]</p>
     * <p>- Bit 4 = Arrow Key [CCW]</p>
     * <p>- Bit 5 = Arrow Key [CW]</p>
     * <p>If the bit is set then the arrow key is grayed out (disabled),
     * if the  bit is cleared then the arrow key is shown</p>
     * <p>The arrow keys are only to be displayed on specified screen patterns!</p>
     *
     * @param u8SwitchGreyOut The value which will be set
     */
    inline void setU8SwitchGreyOut (uint8 u8SwitchGreyOut_);

    static const IPASwitchGreyOutRequestStatus &getDefaultInstance();

private:

    inline void set_has_u8SwitchGreyOut ();

    inline void clear_has_u8SwitchGreyOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8SwitchGreyOut;

};

/**
 * The error message of 'IPASwitchGreyOutRequest'
 */
class IPASwitchGreyOutRequestErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  IPASwitchGreyOutRequestErrorStructure ();

    /**
     * Copy constructor
     */
    inline  IPASwitchGreyOutRequestErrorStructure (const IPASwitchGreyOutRequestErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  IPASwitchGreyOutRequestErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~IPASwitchGreyOutRequestErrorStructure();

    /**
     * Assignment operator
     */
    inline IPASwitchGreyOutRequestErrorStructure& operator = (const IPASwitchGreyOutRequestErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPASwitchGreyOutRequestErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPASwitchGreyOutRequestErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPASwitchGreyOutRequestErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPASwitchGreyOutRequestErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const IPASwitchGreyOutRequestErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'IPASwitchGreyOutRequest'
 */
class IPASwitchGreyOutRequestError  : public ::asf::core::Payload {
public:

    enum IPASwitchGreyOutRequestErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  IPASwitchGreyOutRequestError ();

   /**
     * Copy constructor
     */
    inline  IPASwitchGreyOutRequestError (const IPASwitchGreyOutRequestError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~IPASwitchGreyOutRequestError();

    /**
     * Assigns a new value to this object.
     */
    inline IPASwitchGreyOutRequestError& operator = (const IPASwitchGreyOutRequestError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPASwitchGreyOutRequestError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPASwitchGreyOutRequestError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPASwitchGreyOutRequestError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPASwitchGreyOutRequestError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline IPASwitchGreyOutRequestError::IPASwitchGreyOutRequestErrorField getField () const;

    inline void setField(IPASwitchGreyOutRequestError::IPASwitchGreyOutRequestErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "IPASwitchGreyOutRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "IPASwitchGreyOutRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const IPASwitchGreyOutRequestErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline IPASwitchGreyOutRequestErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline IPASwitchGreyOutRequestErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (IPASwitchGreyOutRequestErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "IPASwitchGreyOutRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const IPASwitchGreyOutRequestErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const IPASwitchGreyOutRequestError &getDefaultInstance();

private:

    inline void cloneData (const IPASwitchGreyOutRequestError& rhs);

    inline void deleteData ();

    IPASwitchGreyOutRequestErrorField __field;

    union {
        IPASwitchGreyOutRequestErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "IPADirectionIndicator"
 * This property informs about the current direction for the RearViewIcon
 * <p>FUNCID = RVC_CCAFI_C_U16_IPADIRECTIONINDICATOR</p>
 */
class IPADirectionIndicatorStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IPADirectionIndicatorStatus ();

    /**
     * Copy constructor
     */
    inline  IPADirectionIndicatorStatus (const IPADirectionIndicatorStatus &rhs);

    /**
     * All fields constructor
     */
    inline  IPADirectionIndicatorStatus (::rvc_cca_fi_types::T_e8_IPA_DirectionIndicator e8Direction_);

    /**
     * Destructor
     */
    inline virtual  ~IPADirectionIndicatorStatus();

    /**
     * Assignment operator
     */
    inline IPADirectionIndicatorStatus& operator = (const IPADirectionIndicatorStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPADirectionIndicatorStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPADirectionIndicatorStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPADirectionIndicatorStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPADirectionIndicatorStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Direction"

    static const int kE8Direction = 0;

    /**
     * Clears the field "e8Direction".
     *
     * The field will be set to its default value. The hasE8Direction()
     * method will return false.
     */
    inline void clearE8Direction();

    /**
     * Checks whether the field "e8Direction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Direction()). Otherwise it will return false.
     */
    inline bool hasE8Direction () const;

    /**
     * Returns the value of the member "e8Direction".
     *
     * The direction indicator for the camera icon orientation
     *
     * @return The value of the field "e8Direction"
     */
    inline ::rvc_cca_fi_types::T_e8_IPA_DirectionIndicator getE8Direction () const;

    /**
     * Sets the value of the member "e8Direction".
     *
     * The direction indicator for the camera icon orientation
     *
     * @param e8Direction The value which will be set
     */
    inline void setE8Direction (::rvc_cca_fi_types::T_e8_IPA_DirectionIndicator e8Direction_);

    static const IPADirectionIndicatorStatus &getDefaultInstance();

private:

    inline void set_has_e8Direction ();

    inline void clear_has_e8Direction ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_IPA_DirectionIndicator _e8Direction;

};

/**
 * The error message of 'IPADirectionIndicator'
 */
class IPADirectionIndicatorErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  IPADirectionIndicatorErrorStructure ();

    /**
     * Copy constructor
     */
    inline  IPADirectionIndicatorErrorStructure (const IPADirectionIndicatorErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  IPADirectionIndicatorErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~IPADirectionIndicatorErrorStructure();

    /**
     * Assignment operator
     */
    inline IPADirectionIndicatorErrorStructure& operator = (const IPADirectionIndicatorErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPADirectionIndicatorErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPADirectionIndicatorErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPADirectionIndicatorErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPADirectionIndicatorErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const IPADirectionIndicatorErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'IPADirectionIndicator'
 */
class IPADirectionIndicatorError  : public ::asf::core::Payload {
public:

    enum IPADirectionIndicatorErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  IPADirectionIndicatorError ();

   /**
     * Copy constructor
     */
    inline  IPADirectionIndicatorError (const IPADirectionIndicatorError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~IPADirectionIndicatorError();

    /**
     * Assigns a new value to this object.
     */
    inline IPADirectionIndicatorError& operator = (const IPADirectionIndicatorError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPADirectionIndicatorError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPADirectionIndicatorError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPADirectionIndicatorError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPADirectionIndicatorError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline IPADirectionIndicatorError::IPADirectionIndicatorErrorField getField () const;

    inline void setField(IPADirectionIndicatorError::IPADirectionIndicatorErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "IPADirectionIndicatorErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "IPADirectionIndicatorErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const IPADirectionIndicatorErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline IPADirectionIndicatorErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline IPADirectionIndicatorErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (IPADirectionIndicatorErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "IPADirectionIndicatorErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const IPADirectionIndicatorErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const IPADirectionIndicatorError &getDefaultInstance();

private:

    inline void cloneData (const IPADirectionIndicatorError& rhs);

    inline void deleteData ();

    IPADirectionIndicatorErrorField __field;

    union {
        IPADirectionIndicatorErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "GdlAdj_SteeringAngle"
 * This Property informs about the Steering Angle and Status to be used for the Guideline Adjustment screens.
 * The parameter will be updated only when the screen is activated.
 * <p>FUNCID = RVC_CCAFI_C_U16_GDLADJ_STEERINGANGLE</p>
 */
class GdlAdj_SteeringAngleStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GdlAdj_SteeringAngleStatus ();

    /**
     * Copy constructor
     */
    inline  GdlAdj_SteeringAngleStatus (const GdlAdj_SteeringAngleStatus &rhs);

    /**
     * All fields constructor
     */
    inline  GdlAdj_SteeringAngleStatus (bool bShowValues_, uint8 u8CentreAdjustmentState_, int32 s32SteeringAngleCentreAdjusted_, const ::std::string& SteeringAngleSignalState_);

    /**
     * Destructor
     */
    inline virtual  ~GdlAdj_SteeringAngleStatus();

    /**
     * Assignment operator
     */
    inline GdlAdj_SteeringAngleStatus& operator = (const GdlAdj_SteeringAngleStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GdlAdj_SteeringAngleStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GdlAdj_SteeringAngleStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GdlAdj_SteeringAngleStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GdlAdj_SteeringAngleStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bShowValues"

    static const int kBShowValues = 0;

    /**
     * Clears the field "bShowValues".
     *
     * The field will be set to its default value. The hasBShowValues()
     * method will return false.
     */
    inline void clearBShowValues();

    /**
     * Checks whether the field "bShowValues" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBShowValues()). Otherwise it will return false.
     */
    inline bool hasBShowValues () const;

    /**
     * Returns the value of the member "bShowValues".
     *
     * In certain cases HMI has to show "-" instead the values.
     * E.g. in case predicted course line (anticipatory line) is not configured.
     * This status is reflected with this parameter.
     * <p>if TRUE show the values from the parameters of this property</p>
     * <p>if FALSE show "-"</p>
     *
     * @return The value of the field "bShowValues"
     */
    inline bool getBShowValues () const;

    /**
     * Sets the value of the member "bShowValues".
     *
     * In certain cases HMI has to show "-" instead the values.
     * E.g. in case predicted course line (anticipatory line) is not configured.
     * This status is reflected with this parameter.
     * <p>if TRUE show the values from the parameters of this property</p>
     * <p>if FALSE show "-"</p>
     *
     * @param bShowValues The value which will be set
     */
    inline void setBShowValues (bool bShowValues_);

    // API of field "u8CentreAdjustmentState"

    static const int kU8CentreAdjustmentState = 1;

    /**
     * Clears the field "u8CentreAdjustmentState".
     *
     * The field will be set to its default value. The hasU8CentreAdjustmentState()
     * method will return false.
     */
    inline void clearU8CentreAdjustmentState();

    /**
     * Checks whether the field "u8CentreAdjustmentState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8CentreAdjustmentState()). Otherwise it will return false.
     */
    inline bool hasU8CentreAdjustmentState () const;

    /**
     * Returns the value of the member "u8CentreAdjustmentState".
     *
     *
     *
     * @return The value of the field "u8CentreAdjustmentState"
     */
    inline uint8 getU8CentreAdjustmentState () const;

    /**
     * Sets the value of the member "u8CentreAdjustmentState".
     *
     *
     *
     * @param u8CentreAdjustmentState The value which will be set
     */
    inline void setU8CentreAdjustmentState (uint8 u8CentreAdjustmentState_);

    // API of field "s32SteeringAngleCentreAdjusted"

    static const int kS32SteeringAngleCentreAdjusted = 2;

    /**
     * Clears the field "s32SteeringAngleCentreAdjusted".
     *
     * The field will be set to its default value. The hasS32SteeringAngleCentreAdjusted()
     * method will return false.
     */
    inline void clearS32SteeringAngleCentreAdjusted();

    /**
     * Checks whether the field "s32SteeringAngleCentreAdjusted" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32SteeringAngleCentreAdjusted()). Otherwise it will return false.
     */
    inline bool hasS32SteeringAngleCentreAdjusted () const;

    /**
     * Returns the value of the member "s32SteeringAngleCentreAdjusted".
     *
     * Value of the steering angle which is corrected with the steering angle centre adjustment value.
     *
     * @return The value of the field "s32SteeringAngleCentreAdjusted"
     */
    inline int32 getS32SteeringAngleCentreAdjusted () const;

    /**
     * Sets the value of the member "s32SteeringAngleCentreAdjusted".
     *
     * Value of the steering angle which is corrected with the steering angle centre adjustment value.
     *
     * @param s32SteeringAngleCentreAdjusted The value which will be set
     */
    inline void setS32SteeringAngleCentreAdjusted (int32 s32SteeringAngleCentreAdjusted_);

    // API of field "SteeringAngleSignalState"

    static const int kSteeringAngleSignalState = 3;

    /**
     * Clears the field "SteeringAngleSignalState".
     *
     * The field will be set to its default value. The hasSteeringAngleSignalState()
     * method will return false.
     */
    inline void clearSteeringAngleSignalState();

    /**
     * Checks whether the field "SteeringAngleSignalState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSteeringAngleSignalState()). Otherwise it will return false.
     */
    inline bool hasSteeringAngleSignalState () const;

    /**
     * Returns the value of the member "SteeringAngleSignalState".
     *
     *
     *
     * @return The value of the field "SteeringAngleSignalState"
     */
    inline const ::std::string& getSteeringAngleSignalState () const;

    /**
     * Retrieves the value of the field "SteeringAngleSignalState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SteeringAngleSignalState".
     */
    inline ::std::string& getSteeringAngleSignalStateMutable ();

    /**
     * Sets the value of the member "SteeringAngleSignalState".
     *
     *
     *
     * @param SteeringAngleSignalState The value which will be set
     */
    inline void setSteeringAngleSignalState (const ::std::string& SteeringAngleSignalState_);

    /**
     * Sets the value of the member "SteeringAngleSignalState".
     *
     *
     *
     * @param SteeringAngleSignalState The value which will be set
     */
    inline void setSteeringAngleSignalState (const char* SteeringAngleSignalState_);

    /**
     * Sets the value of the member "SteeringAngleSignalState".
     *
     *
     *
     * @param SteeringAngleSignalState The value which will be set
     */
    inline void setSteeringAngleSignalState (const char* value, size_t size);

    static const GdlAdj_SteeringAngleStatus &getDefaultInstance();

private:

    inline void set_has_bShowValues ();

    inline void clear_has_bShowValues ();

    inline void set_has_u8CentreAdjustmentState ();

    inline void clear_has_u8CentreAdjustmentState ();

    inline void set_has_s32SteeringAngleCentreAdjusted ();

    inline void clear_has_s32SteeringAngleCentreAdjusted ();

    inline void set_has_SteeringAngleSignalState ();

    inline void clear_has_SteeringAngleSignalState ();

    uint32 _has_bits_[ (4 + 31) / 32];

    bool _bShowValues;

    uint8 _u8CentreAdjustmentState;

    int32 _s32SteeringAngleCentreAdjusted;

    ::std::string _SteeringAngleSignalState;

};

/**
 * The error message of 'GdlAdj_SteeringAngle'
 */
class GdlAdj_SteeringAngleErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GdlAdj_SteeringAngleErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GdlAdj_SteeringAngleErrorStructure (const GdlAdj_SteeringAngleErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GdlAdj_SteeringAngleErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GdlAdj_SteeringAngleErrorStructure();

    /**
     * Assignment operator
     */
    inline GdlAdj_SteeringAngleErrorStructure& operator = (const GdlAdj_SteeringAngleErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GdlAdj_SteeringAngleErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GdlAdj_SteeringAngleErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GdlAdj_SteeringAngleErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GdlAdj_SteeringAngleErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    static const GdlAdj_SteeringAngleErrorStructure &getDefaultInstance();

private:

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _e8ErrorCode;

};

/**
 * The error message of 'GdlAdj_SteeringAngle'
 */
class GdlAdj_SteeringAngleError  : public ::asf::core::Payload {
public:

    enum GdlAdj_SteeringAngleErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GdlAdj_SteeringAngleError ();

   /**
     * Copy constructor
     */
    inline  GdlAdj_SteeringAngleError (const GdlAdj_SteeringAngleError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GdlAdj_SteeringAngleError();

    /**
     * Assigns a new value to this object.
     */
    inline GdlAdj_SteeringAngleError& operator = (const GdlAdj_SteeringAngleError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GdlAdj_SteeringAngleError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GdlAdj_SteeringAngleError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GdlAdj_SteeringAngleError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GdlAdj_SteeringAngleError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GdlAdj_SteeringAngleError::GdlAdj_SteeringAngleErrorField getField () const;

    inline void setField(GdlAdj_SteeringAngleError::GdlAdj_SteeringAngleErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GdlAdj_SteeringAngleErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GdlAdj_SteeringAngleErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GdlAdj_SteeringAngleErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GdlAdj_SteeringAngleErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GdlAdj_SteeringAngleErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GdlAdj_SteeringAngleErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GdlAdj_SteeringAngleErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GdlAdj_SteeringAngleErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GdlAdj_SteeringAngleError &getDefaultInstance();

private:

    inline void cloneData (const GdlAdj_SteeringAngleError& rhs);

    inline void deleteData ();

    GdlAdj_SteeringAngleErrorField __field;

    union {
        GdlAdj_SteeringAngleErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "GdlAdj_CameraAngle"
 * This Property informs about the Camera Angle values to be used for the Guideline Adjustment screens.
 * The parameter will be updated only when the screen is activated.
 * <p>FUNCID = RVC_CCAFI_C_U16_GDLADJ_CAMERAANGLE</p>
 */
class GdlAdj_CameraAngleStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GdlAdj_CameraAngleStatus ();

    /**
     * Copy constructor
     */
    inline  GdlAdj_CameraAngleStatus (const GdlAdj_CameraAngleStatus &rhs);

    /**
     * All fields constructor
     */
    inline  GdlAdj_CameraAngleStatus (float f32CameraRollAngle_, float f32CameraYawAngle_, float f32CameraPitchAngle_);

    /**
     * Destructor
     */
    inline virtual  ~GdlAdj_CameraAngleStatus();

    /**
     * Assignment operator
     */
    inline GdlAdj_CameraAngleStatus& operator = (const GdlAdj_CameraAngleStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GdlAdj_CameraAngleStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GdlAdj_CameraAngleStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GdlAdj_CameraAngleStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GdlAdj_CameraAngleStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "f32CameraRollAngle"

    static const int kF32CameraRollAngle = 0;

    /**
     * Clears the field "f32CameraRollAngle".
     *
     * The field will be set to its default value. The hasF32CameraRollAngle()
     * method will return false.
     */
    inline void clearF32CameraRollAngle();

    /**
     * Checks whether the field "f32CameraRollAngle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setF32CameraRollAngle()). Otherwise it will return false.
     */
    inline bool hasF32CameraRollAngle () const;

    /**
     * Returns the value of the member "f32CameraRollAngle".
     *
     *
     *
     * @return The value of the field "f32CameraRollAngle"
     */
    inline float getF32CameraRollAngle () const;

    /**
     * Sets the value of the member "f32CameraRollAngle".
     *
     *
     *
     * @param f32CameraRollAngle The value which will be set
     */
    inline void setF32CameraRollAngle (float f32CameraRollAngle_);

    // API of field "f32CameraYawAngle"

    static const int kF32CameraYawAngle = 1;

    /**
     * Clears the field "f32CameraYawAngle".
     *
     * The field will be set to its default value. The hasF32CameraYawAngle()
     * method will return false.
     */
    inline void clearF32CameraYawAngle();

    /**
     * Checks whether the field "f32CameraYawAngle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setF32CameraYawAngle()). Otherwise it will return false.
     */
    inline bool hasF32CameraYawAngle () const;

    /**
     * Returns the value of the member "f32CameraYawAngle".
     *
     *
     *
     * @return The value of the field "f32CameraYawAngle"
     */
    inline float getF32CameraYawAngle () const;

    /**
     * Sets the value of the member "f32CameraYawAngle".
     *
     *
     *
     * @param f32CameraYawAngle The value which will be set
     */
    inline void setF32CameraYawAngle (float f32CameraYawAngle_);

    // API of field "f32CameraPitchAngle"

    static const int kF32CameraPitchAngle = 2;

    /**
     * Clears the field "f32CameraPitchAngle".
     *
     * The field will be set to its default value. The hasF32CameraPitchAngle()
     * method will return false.
     */
    inline void clearF32CameraPitchAngle();

    /**
     * Checks whether the field "f32CameraPitchAngle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setF32CameraPitchAngle()). Otherwise it will return false.
     */
    inline bool hasF32CameraPitchAngle () const;

    /**
     * Returns the value of the member "f32CameraPitchAngle".
     *
     *
     *
     * @return The value of the field "f32CameraPitchAngle"
     */
    inline float getF32CameraPitchAngle () const;

    /**
     * Sets the value of the member "f32CameraPitchAngle".
     *
     *
     *
     * @param f32CameraPitchAngle The value which will be set
     */
    inline void setF32CameraPitchAngle (float f32CameraPitchAngle_);

    static const GdlAdj_CameraAngleStatus &getDefaultInstance();

private:

    inline void set_has_f32CameraRollAngle ();

    inline void clear_has_f32CameraRollAngle ();

    inline void set_has_f32CameraYawAngle ();

    inline void clear_has_f32CameraYawAngle ();

    inline void set_has_f32CameraPitchAngle ();

    inline void clear_has_f32CameraPitchAngle ();

    uint32 _has_bits_[ (3 + 31) / 32];

    float _f32CameraRollAngle;

    float _f32CameraYawAngle;

    float _f32CameraPitchAngle;

};

/**
 * The error message of 'GdlAdj_CameraAngle'
 */
class GdlAdj_CameraAngleErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GdlAdj_CameraAngleErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GdlAdj_CameraAngleErrorStructure (const GdlAdj_CameraAngleErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GdlAdj_CameraAngleErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GdlAdj_CameraAngleErrorStructure();

    /**
     * Assignment operator
     */
    inline GdlAdj_CameraAngleErrorStructure& operator = (const GdlAdj_CameraAngleErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GdlAdj_CameraAngleErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GdlAdj_CameraAngleErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GdlAdj_CameraAngleErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GdlAdj_CameraAngleErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    static const GdlAdj_CameraAngleErrorStructure &getDefaultInstance();

private:

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _e8ErrorCode;

};

/**
 * The error message of 'GdlAdj_CameraAngle'
 */
class GdlAdj_CameraAngleError  : public ::asf::core::Payload {
public:

    enum GdlAdj_CameraAngleErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GdlAdj_CameraAngleError ();

   /**
     * Copy constructor
     */
    inline  GdlAdj_CameraAngleError (const GdlAdj_CameraAngleError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GdlAdj_CameraAngleError();

    /**
     * Assigns a new value to this object.
     */
    inline GdlAdj_CameraAngleError& operator = (const GdlAdj_CameraAngleError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GdlAdj_CameraAngleError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GdlAdj_CameraAngleError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GdlAdj_CameraAngleError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GdlAdj_CameraAngleError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GdlAdj_CameraAngleError::GdlAdj_CameraAngleErrorField getField () const;

    inline void setField(GdlAdj_CameraAngleError::GdlAdj_CameraAngleErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GdlAdj_CameraAngleErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GdlAdj_CameraAngleErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GdlAdj_CameraAngleErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GdlAdj_CameraAngleErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GdlAdj_CameraAngleErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GdlAdj_CameraAngleErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GdlAdj_CameraAngleErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GdlAdj_CameraAngleErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GdlAdj_CameraAngleError &getDefaultInstance();

private:

    inline void cloneData (const GdlAdj_CameraAngleError& rhs);

    inline void deleteData ();

    GdlAdj_CameraAngleErrorField __field;

    union {
        GdlAdj_CameraAngleErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "CANFrameStatus"
 * This Property informs about the CAN(Controller Area Network) frame status after MVC view requested.
 * <p>FUNCID = RVC_CCAFI_C_U16_CANFRAMESTATUS</p>
 */
class CANFrameStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CANFrameStatusStatus ();

    /**
     * Copy constructor
     */
    inline  CANFrameStatusStatus (const CANFrameStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CANFrameStatusStatus (::rvc_cca_fi_types::T_e8_RVC_SignalStatus e8StatusCANFrame_);

    /**
     * Destructor
     */
    inline virtual  ~CANFrameStatusStatus();

    /**
     * Assignment operator
     */
    inline CANFrameStatusStatus& operator = (const CANFrameStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CANFrameStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CANFrameStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CANFrameStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CANFrameStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8StatusCANFrame"

    static const int kE8StatusCANFrame = 0;

    /**
     * Clears the field "e8StatusCANFrame".
     *
     * The field will be set to its default value. The hasE8StatusCANFrame()
     * method will return false.
     */
    inline void clearE8StatusCANFrame();

    /**
     * Checks whether the field "e8StatusCANFrame" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8StatusCANFrame()). Otherwise it will return false.
     */
    inline bool hasE8StatusCANFrame () const;

    /**
     * Returns the value of the member "e8StatusCANFrame".
     *
     * <p>CAN frame ok or failure</p>
     *
     * @return The value of the field "e8StatusCANFrame"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_SignalStatus getE8StatusCANFrame () const;

    /**
     * Sets the value of the member "e8StatusCANFrame".
     *
     * <p>CAN frame ok or failure</p>
     *
     * @param e8StatusCANFrame The value which will be set
     */
    inline void setE8StatusCANFrame (::rvc_cca_fi_types::T_e8_RVC_SignalStatus e8StatusCANFrame_);

    static const CANFrameStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8StatusCANFrame ();

    inline void clear_has_e8StatusCANFrame ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_SignalStatus _e8StatusCANFrame;

};

/**
 * The error message of 'CANFrameStatus'
 */
class CANFrameStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  CANFrameStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  CANFrameStatusErrorStructure (const CANFrameStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  CANFrameStatusErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~CANFrameStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline CANFrameStatusErrorStructure& operator = (const CANFrameStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CANFrameStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CANFrameStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CANFrameStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CANFrameStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const CANFrameStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'CANFrameStatus'
 */
class CANFrameStatusError  : public ::asf::core::Payload {
public:

    enum CANFrameStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  CANFrameStatusError ();

   /**
     * Copy constructor
     */
    inline  CANFrameStatusError (const CANFrameStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~CANFrameStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline CANFrameStatusError& operator = (const CANFrameStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CANFrameStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CANFrameStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CANFrameStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CANFrameStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline CANFrameStatusError::CANFrameStatusErrorField getField () const;

    inline void setField(CANFrameStatusError::CANFrameStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "CANFrameStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "CANFrameStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const CANFrameStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline CANFrameStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline CANFrameStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (CANFrameStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "CANFrameStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const CANFrameStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const CANFrameStatusError &getDefaultInstance();

private:

    inline void cloneData (const CANFrameStatusError& rhs);

    inline void deleteData ();

    CANFrameStatusErrorField __field;

    union {
        CANFrameStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "MvcViewStatus"
 * This Property informs about the current MVC view status.
 * <p>FUNCID = RVC_CCAFI_C_U16_MVCVIEWSTATUS</p>
 */
class MvcViewStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MvcViewStatusStatus ();

    /**
     * Copy constructor
     */
    inline  MvcViewStatusStatus (const MvcViewStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MvcViewStatusStatus (::rvc_cca_fi_types::T_e8_MVCViewingState e8View_);

    /**
     * Destructor
     */
    inline virtual  ~MvcViewStatusStatus();

    /**
     * Assignment operator
     */
    inline MvcViewStatusStatus& operator = (const MvcViewStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MvcViewStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MvcViewStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MvcViewStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MvcViewStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8View"

    static const int kE8View = 0;

    /**
     * Clears the field "e8View".
     *
     * The field will be set to its default value. The hasE8View()
     * method will return false.
     */
    inline void clearE8View();

    /**
     * Checks whether the field "e8View" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8View()). Otherwise it will return false.
     */
    inline bool hasE8View () const;

    /**
     * Returns the value of the member "e8View".
     *
     * <p>Current View Status</p>
     *
     * @return The value of the field "e8View"
     */
    inline ::rvc_cca_fi_types::T_e8_MVCViewingState getE8View () const;

    /**
     * Sets the value of the member "e8View".
     *
     * <p>Current View Status</p>
     *
     * @param e8View The value which will be set
     */
    inline void setE8View (::rvc_cca_fi_types::T_e8_MVCViewingState e8View_);

    static const MvcViewStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8View ();

    inline void clear_has_e8View ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_MVCViewingState _e8View;

};

/**
 * The error message of 'MvcViewStatus'
 */
class MvcViewStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  MvcViewStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  MvcViewStatusErrorStructure (const MvcViewStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  MvcViewStatusErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~MvcViewStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline MvcViewStatusErrorStructure& operator = (const MvcViewStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MvcViewStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MvcViewStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MvcViewStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MvcViewStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const MvcViewStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'MvcViewStatus'
 */
class MvcViewStatusError  : public ::asf::core::Payload {
public:

    enum MvcViewStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  MvcViewStatusError ();

   /**
     * Copy constructor
     */
    inline  MvcViewStatusError (const MvcViewStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~MvcViewStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline MvcViewStatusError& operator = (const MvcViewStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MvcViewStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MvcViewStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MvcViewStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MvcViewStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline MvcViewStatusError::MvcViewStatusErrorField getField () const;

    inline void setField(MvcViewStatusError::MvcViewStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "MvcViewStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "MvcViewStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const MvcViewStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline MvcViewStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline MvcViewStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (MvcViewStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "MvcViewStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const MvcViewStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const MvcViewStatusError &getDefaultInstance();

private:

    inline void cloneData (const MvcViewStatusError& rhs);

    inline void deleteData ();

    MvcViewStatusErrorField __field;

    union {
        MvcViewStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "MvcAlertRequest"
 * This Property informs about the current MVC Alert Requested State.
 * <p>FUNCID = RVC_CCAFI_C_U16_MVCALERTREQUEST</p>
 */
class MvcAlertRequestStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MvcAlertRequestStatus ();

    /**
     * Copy constructor
     */
    inline  MvcAlertRequestStatus (const MvcAlertRequestStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MvcAlertRequestStatus (bool bRequest_);

    /**
     * Destructor
     */
    inline virtual  ~MvcAlertRequestStatus();

    /**
     * Assignment operator
     */
    inline MvcAlertRequestStatus& operator = (const MvcAlertRequestStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MvcAlertRequestStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MvcAlertRequestStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MvcAlertRequestStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MvcAlertRequestStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bRequest"

    static const int kBRequest = 0;

    /**
     * Clears the field "bRequest".
     *
     * The field will be set to its default value. The hasBRequest()
     * method will return false.
     */
    inline void clearBRequest();

    /**
     * Checks whether the field "bRequest" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBRequest()). Otherwise it will return false.
     */
    inline bool hasBRequest () const;

    /**
     * Returns the value of the member "bRequest".
     *
     * <p>TRUE = Show Alert or FALSE = No Alert Requested</p>
     *
     * @return The value of the field "bRequest"
     */
    inline bool getBRequest () const;

    /**
     * Sets the value of the member "bRequest".
     *
     * <p>TRUE = Show Alert or FALSE = No Alert Requested</p>
     *
     * @param bRequest The value which will be set
     */
    inline void setBRequest (bool bRequest_);

    static const MvcAlertRequestStatus &getDefaultInstance();

private:

    inline void set_has_bRequest ();

    inline void clear_has_bRequest ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bRequest;

};

/**
 * The error message of 'MvcAlertRequest'
 */
class MvcAlertRequestErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  MvcAlertRequestErrorStructure ();

    /**
     * Copy constructor
     */
    inline  MvcAlertRequestErrorStructure (const MvcAlertRequestErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  MvcAlertRequestErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~MvcAlertRequestErrorStructure();

    /**
     * Assignment operator
     */
    inline MvcAlertRequestErrorStructure& operator = (const MvcAlertRequestErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MvcAlertRequestErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MvcAlertRequestErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MvcAlertRequestErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MvcAlertRequestErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const MvcAlertRequestErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'MvcAlertRequest'
 */
class MvcAlertRequestError  : public ::asf::core::Payload {
public:

    enum MvcAlertRequestErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  MvcAlertRequestError ();

   /**
     * Copy constructor
     */
    inline  MvcAlertRequestError (const MvcAlertRequestError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~MvcAlertRequestError();

    /**
     * Assigns a new value to this object.
     */
    inline MvcAlertRequestError& operator = (const MvcAlertRequestError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MvcAlertRequestError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MvcAlertRequestError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MvcAlertRequestError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MvcAlertRequestError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline MvcAlertRequestError::MvcAlertRequestErrorField getField () const;

    inline void setField(MvcAlertRequestError::MvcAlertRequestErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "MvcAlertRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "MvcAlertRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const MvcAlertRequestErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline MvcAlertRequestErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline MvcAlertRequestErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (MvcAlertRequestErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "MvcAlertRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const MvcAlertRequestErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const MvcAlertRequestError &getDefaultInstance();

private:

    inline void cloneData (const MvcAlertRequestError& rhs);

    inline void deleteData ();

    MvcAlertRequestErrorField __field;

    union {
        MvcAlertRequestErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "FAPMode"
 * This Property informs about the whether we are in FAP mode or not.
 * <p>FUNCID = RVC_CCAFI_C_U16_FAPMODE</p>
 */
class FAPModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FAPModeStatus ();

    /**
     * Copy constructor
     */
    inline  FAPModeStatus (const FAPModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FAPModeStatus (bool e8State_);

    /**
     * Destructor
     */
    inline virtual  ~FAPModeStatus();

    /**
     * Assignment operator
     */
    inline FAPModeStatus& operator = (const FAPModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FAPModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FAPModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FAPModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FAPModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8State"

    static const int kE8State = 0;

    /**
     * Clears the field "e8State".
     *
     * The field will be set to its default value. The hasE8State()
     * method will return false.
     */
    inline void clearE8State();

    /**
     * Checks whether the field "e8State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8State()). Otherwise it will return false.
     */
    inline bool hasE8State () const;

    /**
     * Returns the value of the member "e8State".
     *
     * <p>0 = FAP Mode Off / 1 = FAP Mode On</p>
     *
     * @return The value of the field "e8State"
     */
    inline bool getE8State () const;

    /**
     * Sets the value of the member "e8State".
     *
     * <p>0 = FAP Mode Off / 1 = FAP Mode On</p>
     *
     * @param e8State The value which will be set
     */
    inline void setE8State (bool e8State_);

    static const FAPModeStatus &getDefaultInstance();

private:

    inline void set_has_e8State ();

    inline void clear_has_e8State ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _e8State;

};

/**
 * The error message of 'FAPMode'
 */
class FAPModeErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FAPModeErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FAPModeErrorStructure (const FAPModeErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FAPModeErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FAPModeErrorStructure();

    /**
     * Assignment operator
     */
    inline FAPModeErrorStructure& operator = (const FAPModeErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FAPModeErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FAPModeErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FAPModeErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FAPModeErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const FAPModeErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'FAPMode'
 */
class FAPModeError  : public ::asf::core::Payload {
public:

    enum FAPModeErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FAPModeError ();

   /**
     * Copy constructor
     */
    inline  FAPModeError (const FAPModeError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FAPModeError();

    /**
     * Assigns a new value to this object.
     */
    inline FAPModeError& operator = (const FAPModeError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FAPModeError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FAPModeError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FAPModeError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FAPModeError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FAPModeError::FAPModeErrorField getField () const;

    inline void setField(FAPModeError::FAPModeErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FAPModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FAPModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FAPModeErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FAPModeErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FAPModeErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FAPModeErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FAPModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FAPModeErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FAPModeError &getDefaultInstance();

private:

    inline void cloneData (const FAPModeError& rhs);

    inline void deleteData ();

    FAPModeErrorField __field;

    union {
        FAPModeErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "FAPSettings"
 * This Property informs about the current FAP Setting State
 * <p>FUNCID = RVC_CCAFI_C_U16_FAPSETTINGS</p>
 */
class FAPSettingsStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FAPSettingsStatus ();

    /**
     * Copy constructor
     */
    inline  FAPSettingsStatus (const FAPSettingsStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FAPSettingsStatus (const ::std::vector< ::rvc_cca_fi_types::T_FAP_Settings_State >& arFapSettingState_, const ::std::vector< ::rvc_cca_fi_types::T_AVM_Settings_State >& arAvmSettingState_);

    /**
     * Destructor
     */
    inline virtual  ~FAPSettingsStatus();

    /**
     * Assignment operator
     */
    inline FAPSettingsStatus& operator = (const FAPSettingsStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FAPSettingsStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FAPSettingsStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FAPSettingsStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FAPSettingsStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arFapSettingState"

    static const int kArFapSettingState = 0;

    /**
     * Clears the field "arFapSettingState".
     *
     * The field will be set to its default value. The hasArFapSettingState()
     * method will return false.
     */
    inline void clearArFapSettingState();

    /**
     * Checks whether the field "arFapSettingState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArFapSettingState()). Otherwise it will return false.
     */
    inline bool hasArFapSettingState () const;

    /**
     * Returns the value of the member "arFapSettingState".
     *
     * <p>List of FAP Settings Current State,
     * always update the status according to the current state,
     * and not on the basis of HMI actions</p>
     *
     * @return The value of the field "arFapSettingState"
     */
    inline const ::std::vector< ::rvc_cca_fi_types::T_FAP_Settings_State >& getArFapSettingState () const;

    /**
     * Retrieves the value of the field "arFapSettingState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arFapSettingState".
     */
    inline ::std::vector< ::rvc_cca_fi_types::T_FAP_Settings_State >& getArFapSettingStateMutable ();

    /**
     * Sets the value of the member "arFapSettingState".
     *
     * <p>List of FAP Settings Current State,
     * always update the status according to the current state,
     * and not on the basis of HMI actions</p>
     *
     * @param arFapSettingState The value which will be set
     */
    inline void setArFapSettingState (const ::std::vector< ::rvc_cca_fi_types::T_FAP_Settings_State >& arFapSettingState_);

    // API of field "arAvmSettingState"

    static const int kArAvmSettingState = 1;

    /**
     * Clears the field "arAvmSettingState".
     *
     * The field will be set to its default value. The hasArAvmSettingState()
     * method will return false.
     */
    inline void clearArAvmSettingState();

    /**
     * Checks whether the field "arAvmSettingState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArAvmSettingState()). Otherwise it will return false.
     */
    inline bool hasArAvmSettingState () const;

    /**
     * Returns the value of the member "arAvmSettingState".
     *
     * <p>List of AVM Settings Current State,
     * always update the status according to the current state,
     * and not on the basis of HMI actions</p>
     *
     * @return The value of the field "arAvmSettingState"
     */
    inline const ::std::vector< ::rvc_cca_fi_types::T_AVM_Settings_State >& getArAvmSettingState () const;

    /**
     * Retrieves the value of the field "arAvmSettingState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arAvmSettingState".
     */
    inline ::std::vector< ::rvc_cca_fi_types::T_AVM_Settings_State >& getArAvmSettingStateMutable ();

    /**
     * Sets the value of the member "arAvmSettingState".
     *
     * <p>List of AVM Settings Current State,
     * always update the status according to the current state,
     * and not on the basis of HMI actions</p>
     *
     * @param arAvmSettingState The value which will be set
     */
    inline void setArAvmSettingState (const ::std::vector< ::rvc_cca_fi_types::T_AVM_Settings_State >& arAvmSettingState_);

    static const FAPSettingsStatus &getDefaultInstance();

private:

    static const ::std::vector< ::rvc_cca_fi_types::T_FAP_Settings_State >& getT_FAP_Settings_StateList_DefaultInstance ();

    static const ::std::vector< ::rvc_cca_fi_types::T_AVM_Settings_State >& getT_AVM_Settings_StateList_DefaultInstance ();

    inline void set_has_arFapSettingState ();

    inline void clear_has_arFapSettingState ();

    inline void set_has_arAvmSettingState ();

    inline void clear_has_arAvmSettingState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< ::rvc_cca_fi_types::T_FAP_Settings_State > _arFapSettingState;

    ::std::vector< ::rvc_cca_fi_types::T_AVM_Settings_State > _arAvmSettingState;

};

/**
 * The error message of 'FAPSettings'
 */
class FAPSettingsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FAPSettingsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FAPSettingsErrorStructure (const FAPSettingsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FAPSettingsErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FAPSettingsErrorStructure();

    /**
     * Assignment operator
     */
    inline FAPSettingsErrorStructure& operator = (const FAPSettingsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FAPSettingsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FAPSettingsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FAPSettingsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FAPSettingsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const FAPSettingsErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'FAPSettings'
 */
class FAPSettingsError  : public ::asf::core::Payload {
public:

    enum FAPSettingsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FAPSettingsError ();

   /**
     * Copy constructor
     */
    inline  FAPSettingsError (const FAPSettingsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FAPSettingsError();

    /**
     * Assigns a new value to this object.
     */
    inline FAPSettingsError& operator = (const FAPSettingsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FAPSettingsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FAPSettingsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FAPSettingsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FAPSettingsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FAPSettingsError::FAPSettingsErrorField getField () const;

    inline void setField(FAPSettingsError::FAPSettingsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FAPSettingsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FAPSettingsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FAPSettingsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FAPSettingsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FAPSettingsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FAPSettingsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FAPSettingsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FAPSettingsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FAPSettingsError &getDefaultInstance();

private:

    inline void cloneData (const FAPSettingsError& rhs);

    inline void deleteData ();

    FAPSettingsErrorField __field;

    union {
        FAPSettingsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "FAPGuidanceState"
 * This Property informs about the whether we are in FAP Guidance or not.
 * <p>FUNCID = RVC_CCAFI_C_U16_FAPGUIDANCESTATE</p>
 */
class FAPGuidanceStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FAPGuidanceStateStatus ();

    /**
     * Copy constructor
     */
    inline  FAPGuidanceStateStatus (const FAPGuidanceStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FAPGuidanceStateStatus (bool e8State_);

    /**
     * Destructor
     */
    inline virtual  ~FAPGuidanceStateStatus();

    /**
     * Assignment operator
     */
    inline FAPGuidanceStateStatus& operator = (const FAPGuidanceStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FAPGuidanceStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FAPGuidanceStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FAPGuidanceStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FAPGuidanceStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8State"

    static const int kE8State = 0;

    /**
     * Clears the field "e8State".
     *
     * The field will be set to its default value. The hasE8State()
     * method will return false.
     */
    inline void clearE8State();

    /**
     * Checks whether the field "e8State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8State()). Otherwise it will return false.
     */
    inline bool hasE8State () const;

    /**
     * Returns the value of the member "e8State".
     *
     * <p>0 = FAP Guidance Off / 1 = FAP Guidance On</p>
     *
     * @return The value of the field "e8State"
     */
    inline bool getE8State () const;

    /**
     * Sets the value of the member "e8State".
     *
     * <p>0 = FAP Guidance Off / 1 = FAP Guidance On</p>
     *
     * @param e8State The value which will be set
     */
    inline void setE8State (bool e8State_);

    static const FAPGuidanceStateStatus &getDefaultInstance();

private:

    inline void set_has_e8State ();

    inline void clear_has_e8State ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _e8State;

};

/**
 * The error message of 'FAPGuidanceState'
 */
class FAPGuidanceStateErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FAPGuidanceStateErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FAPGuidanceStateErrorStructure (const FAPGuidanceStateErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FAPGuidanceStateErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FAPGuidanceStateErrorStructure();

    /**
     * Assignment operator
     */
    inline FAPGuidanceStateErrorStructure& operator = (const FAPGuidanceStateErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FAPGuidanceStateErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FAPGuidanceStateErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FAPGuidanceStateErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FAPGuidanceStateErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const FAPGuidanceStateErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'FAPGuidanceState'
 */
class FAPGuidanceStateError  : public ::asf::core::Payload {
public:

    enum FAPGuidanceStateErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FAPGuidanceStateError ();

   /**
     * Copy constructor
     */
    inline  FAPGuidanceStateError (const FAPGuidanceStateError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FAPGuidanceStateError();

    /**
     * Assigns a new value to this object.
     */
    inline FAPGuidanceStateError& operator = (const FAPGuidanceStateError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FAPGuidanceStateError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FAPGuidanceStateError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FAPGuidanceStateError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FAPGuidanceStateError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FAPGuidanceStateError::FAPGuidanceStateErrorField getField () const;

    inline void setField(FAPGuidanceStateError::FAPGuidanceStateErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FAPGuidanceStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FAPGuidanceStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FAPGuidanceStateErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FAPGuidanceStateErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FAPGuidanceStateErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FAPGuidanceStateErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FAPGuidanceStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FAPGuidanceStateErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FAPGuidanceStateError &getDefaultInstance();

private:

    inline void cloneData (const FAPGuidanceStateError& rhs);

    inline void deleteData ();

    FAPGuidanceStateErrorField __field;

    union {
        FAPGuidanceStateErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "AVM3_DispStatus"
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_DISPSTATUS</p>
 */
class AVM3_DispStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AVM3_DispStatusStatus ();

    /**
     * Copy constructor
     */
    inline  AVM3_DispStatusStatus (const AVM3_DispStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AVM3_DispStatusStatus (::rvc_cca_fi_types::T_e8_AVMph3_DispStatus e8DispStatus_);

    /**
     * Destructor
     */
    inline virtual  ~AVM3_DispStatusStatus();

    /**
     * Assignment operator
     */
    inline AVM3_DispStatusStatus& operator = (const AVM3_DispStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_DispStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_DispStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_DispStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_DispStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DispStatus"

    static const int kE8DispStatus = 0;

    /**
     * Clears the field "e8DispStatus".
     *
     * The field will be set to its default value. The hasE8DispStatus()
     * method will return false.
     */
    inline void clearE8DispStatus();

    /**
     * Checks whether the field "e8DispStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DispStatus()). Otherwise it will return false.
     */
    inline bool hasE8DispStatus () const;

    /**
     * Returns the value of the member "e8DispStatus".
     *
     * <p>0 = other display than camera / 1 = camera display</p>
     *
     * @return The value of the field "e8DispStatus"
     */
    inline ::rvc_cca_fi_types::T_e8_AVMph3_DispStatus getE8DispStatus () const;

    /**
     * Sets the value of the member "e8DispStatus".
     *
     * <p>0 = other display than camera / 1 = camera display</p>
     *
     * @param e8DispStatus The value which will be set
     */
    inline void setE8DispStatus (::rvc_cca_fi_types::T_e8_AVMph3_DispStatus e8DispStatus_);

    static const AVM3_DispStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8DispStatus ();

    inline void clear_has_e8DispStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_AVMph3_DispStatus _e8DispStatus;

};

/**
 * The error message of 'AVM3_DispStatus'
 */
class AVM3_DispStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AVM3_DispStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AVM3_DispStatusErrorStructure (const AVM3_DispStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AVM3_DispStatusErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~AVM3_DispStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline AVM3_DispStatusErrorStructure& operator = (const AVM3_DispStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_DispStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_DispStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_DispStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_DispStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const AVM3_DispStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'AVM3_DispStatus'
 */
class AVM3_DispStatusError  : public ::asf::core::Payload {
public:

    enum AVM3_DispStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AVM3_DispStatusError ();

   /**
     * Copy constructor
     */
    inline  AVM3_DispStatusError (const AVM3_DispStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AVM3_DispStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline AVM3_DispStatusError& operator = (const AVM3_DispStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_DispStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_DispStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_DispStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_DispStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AVM3_DispStatusError::AVM3_DispStatusErrorField getField () const;

    inline void setField(AVM3_DispStatusError::AVM3_DispStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AVM3_DispStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AVM3_DispStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AVM3_DispStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AVM3_DispStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AVM3_DispStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AVM3_DispStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AVM3_DispStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AVM3_DispStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AVM3_DispStatusError &getDefaultInstance();

private:

    inline void cloneData (const AVM3_DispStatusError& rhs);

    inline void deleteData ();

    AVM3_DispStatusErrorField __field;

    union {
        AVM3_DispStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "AVM3_ViewSetup"
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_VIEWCHANGE</p>
 */
class AVM3_ViewSetupStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AVM3_ViewSetupStatus ();

    /**
     * Copy constructor
     */
    inline  AVM3_ViewSetupStatus (const AVM3_ViewSetupStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AVM3_ViewSetupStatus (::rvc_cca_fi_types::T_e8_AVMph3_ViewPattern e8ViewPattern_, ::rvc_cca_fi_types::T_e8_AVMph3_CautionId e8CautionId_, const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& Switch1_, const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& Switch2_, const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& Switch3_, const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& Switch4_, const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& Switch5_, const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& Switch6_, const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& Switch7_, const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& Switch8_, ::rvc_cca_fi_types::T_e8_AVMph3_IconId e8IconId_, ::rvc_cca_fi_types::T_e8_AVMph3_BuzzerStatus e8BuzzerStatus_);

    /**
     * Destructor
     */
    inline virtual  ~AVM3_ViewSetupStatus();

    /**
     * Assignment operator
     */
    inline AVM3_ViewSetupStatus& operator = (const AVM3_ViewSetupStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_ViewSetupStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_ViewSetupStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_ViewSetupStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_ViewSetupStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ViewPattern"

    static const int kE8ViewPattern = 0;

    /**
     * Clears the field "e8ViewPattern".
     *
     * The field will be set to its default value. The hasE8ViewPattern()
     * method will return false.
     */
    inline void clearE8ViewPattern();

    /**
     * Checks whether the field "e8ViewPattern" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ViewPattern()). Otherwise it will return false.
     */
    inline bool hasE8ViewPattern () const;

    /**
     * Returns the value of the member "e8ViewPattern".
     *
     * <p>0 = none / other = ID of the general camera screen layout to be displayed</p>
     *
     * @return The value of the field "e8ViewPattern"
     */
    inline ::rvc_cca_fi_types::T_e8_AVMph3_ViewPattern getE8ViewPattern () const;

    /**
     * Sets the value of the member "e8ViewPattern".
     *
     * <p>0 = none / other = ID of the general camera screen layout to be displayed</p>
     *
     * @param e8ViewPattern The value which will be set
     */
    inline void setE8ViewPattern (::rvc_cca_fi_types::T_e8_AVMph3_ViewPattern e8ViewPattern_);

    // API of field "e8CautionId"

    static const int kE8CautionId = 1;

    /**
     * Clears the field "e8CautionId".
     *
     * The field will be set to its default value. The hasE8CautionId()
     * method will return false.
     */
    inline void clearE8CautionId();

    /**
     * Checks whether the field "e8CautionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CautionId()). Otherwise it will return false.
     */
    inline bool hasE8CautionId () const;

    /**
     * Returns the value of the member "e8CautionId".
     *
     * <p>0 = none / other = ID of the caution message/masking information to be displayed</p>
     *
     * @return The value of the field "e8CautionId"
     */
    inline ::rvc_cca_fi_types::T_e8_AVMph3_CautionId getE8CautionId () const;

    /**
     * Sets the value of the member "e8CautionId".
     *
     * <p>0 = none / other = ID of the caution message/masking information to be displayed</p>
     *
     * @param e8CautionId The value which will be set
     */
    inline void setE8CautionId (::rvc_cca_fi_types::T_e8_AVMph3_CautionId e8CautionId_);

    // API of field "Switch1"

    static const int kSwitch1 = 2;

    /**
     * Clears the field "Switch1".
     *
     * The field will be set to its default value. The hasSwitch1()
     * method will return false.
     */
    inline void clearSwitch1();

    /**
     * Checks whether the field "Switch1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSwitch1()). Otherwise it will return false.
     */
    inline bool hasSwitch1 () const;

    /**
     * Returns the value of the member "Switch1".
     *
     * <p>ID and enabled/disabled/highlighted state of touch button #1</p>
     *
     * @return The value of the field "Switch1"
     */
    inline const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& getSwitch1 () const;

    /**
     * Retrieves the value of the field "Switch1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Switch1".
     */
    inline ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& getSwitch1Mutable ();

    /**
     * Sets the value of the member "Switch1".
     *
     * <p>ID and enabled/disabled/highlighted state of touch button #1</p>
     *
     * @param Switch1 The value which will be set
     */
    inline void setSwitch1 (const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& Switch1_);

    // API of field "Switch2"

    static const int kSwitch2 = 3;

    /**
     * Clears the field "Switch2".
     *
     * The field will be set to its default value. The hasSwitch2()
     * method will return false.
     */
    inline void clearSwitch2();

    /**
     * Checks whether the field "Switch2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSwitch2()). Otherwise it will return false.
     */
    inline bool hasSwitch2 () const;

    /**
     * Returns the value of the member "Switch2".
     *
     * <p>ID and enabled/disabled/highlighted state of touch button #2</p>
     *
     * @return The value of the field "Switch2"
     */
    inline const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& getSwitch2 () const;

    /**
     * Retrieves the value of the field "Switch2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Switch2".
     */
    inline ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& getSwitch2Mutable ();

    /**
     * Sets the value of the member "Switch2".
     *
     * <p>ID and enabled/disabled/highlighted state of touch button #2</p>
     *
     * @param Switch2 The value which will be set
     */
    inline void setSwitch2 (const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& Switch2_);

    // API of field "Switch3"

    static const int kSwitch3 = 4;

    /**
     * Clears the field "Switch3".
     *
     * The field will be set to its default value. The hasSwitch3()
     * method will return false.
     */
    inline void clearSwitch3();

    /**
     * Checks whether the field "Switch3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSwitch3()). Otherwise it will return false.
     */
    inline bool hasSwitch3 () const;

    /**
     * Returns the value of the member "Switch3".
     *
     * <p>ID and enabled/disabled/highlighted state of touch button #3</p>
     *
     * @return The value of the field "Switch3"
     */
    inline const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& getSwitch3 () const;

    /**
     * Retrieves the value of the field "Switch3" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Switch3".
     */
    inline ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& getSwitch3Mutable ();

    /**
     * Sets the value of the member "Switch3".
     *
     * <p>ID and enabled/disabled/highlighted state of touch button #3</p>
     *
     * @param Switch3 The value which will be set
     */
    inline void setSwitch3 (const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& Switch3_);

    // API of field "Switch4"

    static const int kSwitch4 = 5;

    /**
     * Clears the field "Switch4".
     *
     * The field will be set to its default value. The hasSwitch4()
     * method will return false.
     */
    inline void clearSwitch4();

    /**
     * Checks whether the field "Switch4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSwitch4()). Otherwise it will return false.
     */
    inline bool hasSwitch4 () const;

    /**
     * Returns the value of the member "Switch4".
     *
     * <p>ID and enabled/disabled/highlighted state of touch button #4</p>
     *
     * @return The value of the field "Switch4"
     */
    inline const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& getSwitch4 () const;

    /**
     * Retrieves the value of the field "Switch4" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Switch4".
     */
    inline ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& getSwitch4Mutable ();

    /**
     * Sets the value of the member "Switch4".
     *
     * <p>ID and enabled/disabled/highlighted state of touch button #4</p>
     *
     * @param Switch4 The value which will be set
     */
    inline void setSwitch4 (const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& Switch4_);

    // API of field "Switch5"

    static const int kSwitch5 = 6;

    /**
     * Clears the field "Switch5".
     *
     * The field will be set to its default value. The hasSwitch5()
     * method will return false.
     */
    inline void clearSwitch5();

    /**
     * Checks whether the field "Switch5" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSwitch5()). Otherwise it will return false.
     */
    inline bool hasSwitch5 () const;

    /**
     * Returns the value of the member "Switch5".
     *
     * <p>ID and enabled/disabled/highlighted state of touch button #5</p>
     *
     * @return The value of the field "Switch5"
     */
    inline const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& getSwitch5 () const;

    /**
     * Retrieves the value of the field "Switch5" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Switch5".
     */
    inline ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& getSwitch5Mutable ();

    /**
     * Sets the value of the member "Switch5".
     *
     * <p>ID and enabled/disabled/highlighted state of touch button #5</p>
     *
     * @param Switch5 The value which will be set
     */
    inline void setSwitch5 (const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& Switch5_);

    // API of field "Switch6"

    static const int kSwitch6 = 7;

    /**
     * Clears the field "Switch6".
     *
     * The field will be set to its default value. The hasSwitch6()
     * method will return false.
     */
    inline void clearSwitch6();

    /**
     * Checks whether the field "Switch6" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSwitch6()). Otherwise it will return false.
     */
    inline bool hasSwitch6 () const;

    /**
     * Returns the value of the member "Switch6".
     *
     * <p>ID and enabled/disabled/highlighted state of touch button #6</p>
     *
     * @return The value of the field "Switch6"
     */
    inline const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& getSwitch6 () const;

    /**
     * Retrieves the value of the field "Switch6" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Switch6".
     */
    inline ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& getSwitch6Mutable ();

    /**
     * Sets the value of the member "Switch6".
     *
     * <p>ID and enabled/disabled/highlighted state of touch button #6</p>
     *
     * @param Switch6 The value which will be set
     */
    inline void setSwitch6 (const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& Switch6_);

    // API of field "Switch7"

    static const int kSwitch7 = 8;

    /**
     * Clears the field "Switch7".
     *
     * The field will be set to its default value. The hasSwitch7()
     * method will return false.
     */
    inline void clearSwitch7();

    /**
     * Checks whether the field "Switch7" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSwitch7()). Otherwise it will return false.
     */
    inline bool hasSwitch7 () const;

    /**
     * Returns the value of the member "Switch7".
     *
     * <p>ID and enabled/disabled/highlighted state of touch button #7</p>
     *
     * @return The value of the field "Switch7"
     */
    inline const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& getSwitch7 () const;

    /**
     * Retrieves the value of the field "Switch7" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Switch7".
     */
    inline ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& getSwitch7Mutable ();

    /**
     * Sets the value of the member "Switch7".
     *
     * <p>ID and enabled/disabled/highlighted state of touch button #7</p>
     *
     * @param Switch7 The value which will be set
     */
    inline void setSwitch7 (const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& Switch7_);

    // API of field "Switch8"

    static const int kSwitch8 = 9;

    /**
     * Clears the field "Switch8".
     *
     * The field will be set to its default value. The hasSwitch8()
     * method will return false.
     */
    inline void clearSwitch8();

    /**
     * Checks whether the field "Switch8" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSwitch8()). Otherwise it will return false.
     */
    inline bool hasSwitch8 () const;

    /**
     * Returns the value of the member "Switch8".
     *
     * <p>ID and enabled/disabled/highlighted state of touch button #8</p>
     *
     * @return The value of the field "Switch8"
     */
    inline const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& getSwitch8 () const;

    /**
     * Retrieves the value of the field "Switch8" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Switch8".
     */
    inline ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& getSwitch8Mutable ();

    /**
     * Sets the value of the member "Switch8".
     *
     * <p>ID and enabled/disabled/highlighted state of touch button #8</p>
     *
     * @param Switch8 The value which will be set
     */
    inline void setSwitch8 (const ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor& Switch8_);

    // API of field "e8IconId"

    static const int kE8IconId = 10;

    /**
     * Clears the field "e8IconId".
     *
     * The field will be set to its default value. The hasE8IconId()
     * method will return false.
     */
    inline void clearE8IconId();

    /**
     * Checks whether the field "e8IconId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8IconId()). Otherwise it will return false.
     */
    inline bool hasE8IconId () const;

    /**
     * Returns the value of the member "e8IconId".
     *
     * <p>0 = none / other = ID of the camera icon to be displayed</p>
     *
     * @return The value of the field "e8IconId"
     */
    inline ::rvc_cca_fi_types::T_e8_AVMph3_IconId getE8IconId () const;

    /**
     * Sets the value of the member "e8IconId".
     *
     * <p>0 = none / other = ID of the camera icon to be displayed</p>
     *
     * @param e8IconId The value which will be set
     */
    inline void setE8IconId (::rvc_cca_fi_types::T_e8_AVMph3_IconId e8IconId_);

    // API of field "e8BuzzerStatus"

    static const int kE8BuzzerStatus = 11;

    /**
     * Clears the field "e8BuzzerStatus".
     *
     * The field will be set to its default value. The hasE8BuzzerStatus()
     * method will return false.
     */
    inline void clearE8BuzzerStatus();

    /**
     * Checks whether the field "e8BuzzerStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8BuzzerStatus()). Otherwise it will return false.
     */
    inline bool hasE8BuzzerStatus () const;

    /**
     * Returns the value of the member "e8BuzzerStatus".
     *
     * <p>0 = Buzzer setting OFF / 1 = Buzzer setting ON</p>
     *
     * @return The value of the field "e8BuzzerStatus"
     */
    inline ::rvc_cca_fi_types::T_e8_AVMph3_BuzzerStatus getE8BuzzerStatus () const;

    /**
     * Sets the value of the member "e8BuzzerStatus".
     *
     * <p>0 = Buzzer setting OFF / 1 = Buzzer setting ON</p>
     *
     * @param e8BuzzerStatus The value which will be set
     */
    inline void setE8BuzzerStatus (::rvc_cca_fi_types::T_e8_AVMph3_BuzzerStatus e8BuzzerStatus_);

    static const AVM3_ViewSetupStatus &getDefaultInstance();

private:

    inline void set_has_e8ViewPattern ();

    inline void clear_has_e8ViewPattern ();

    inline void set_has_e8CautionId ();

    inline void clear_has_e8CautionId ();

    inline void set_has_Switch1 ();

    inline void clear_has_Switch1 ();

    inline void set_has_Switch2 ();

    inline void clear_has_Switch2 ();

    inline void set_has_Switch3 ();

    inline void clear_has_Switch3 ();

    inline void set_has_Switch4 ();

    inline void clear_has_Switch4 ();

    inline void set_has_Switch5 ();

    inline void clear_has_Switch5 ();

    inline void set_has_Switch6 ();

    inline void clear_has_Switch6 ();

    inline void set_has_Switch7 ();

    inline void clear_has_Switch7 ();

    inline void set_has_Switch8 ();

    inline void clear_has_Switch8 ();

    inline void set_has_e8IconId ();

    inline void clear_has_e8IconId ();

    inline void set_has_e8BuzzerStatus ();

    inline void clear_has_e8BuzzerStatus ();

    uint32 _has_bits_[ (12 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_AVMph3_ViewPattern _e8ViewPattern;

    ::rvc_cca_fi_types::T_e8_AVMph3_CautionId _e8CautionId;

    ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor _Switch1;

    ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor _Switch2;

    ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor _Switch3;

    ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor _Switch4;

    ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor _Switch5;

    ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor _Switch6;

    ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor _Switch7;

    ::rvc_cca_fi_types::T_AVMph3_SwitchDescriptor _Switch8;

    ::rvc_cca_fi_types::T_e8_AVMph3_IconId _e8IconId;

    ::rvc_cca_fi_types::T_e8_AVMph3_BuzzerStatus _e8BuzzerStatus;

};

/**
 * The error message of 'AVM3_ViewSetup'
 */
class AVM3_ViewSetupErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AVM3_ViewSetupErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AVM3_ViewSetupErrorStructure (const AVM3_ViewSetupErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AVM3_ViewSetupErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~AVM3_ViewSetupErrorStructure();

    /**
     * Assignment operator
     */
    inline AVM3_ViewSetupErrorStructure& operator = (const AVM3_ViewSetupErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_ViewSetupErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_ViewSetupErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_ViewSetupErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_ViewSetupErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const AVM3_ViewSetupErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'AVM3_ViewSetup'
 */
class AVM3_ViewSetupError  : public ::asf::core::Payload {
public:

    enum AVM3_ViewSetupErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AVM3_ViewSetupError ();

   /**
     * Copy constructor
     */
    inline  AVM3_ViewSetupError (const AVM3_ViewSetupError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AVM3_ViewSetupError();

    /**
     * Assigns a new value to this object.
     */
    inline AVM3_ViewSetupError& operator = (const AVM3_ViewSetupError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_ViewSetupError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_ViewSetupError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_ViewSetupError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_ViewSetupError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AVM3_ViewSetupError::AVM3_ViewSetupErrorField getField () const;

    inline void setField(AVM3_ViewSetupError::AVM3_ViewSetupErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AVM3_ViewSetupErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AVM3_ViewSetupErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AVM3_ViewSetupErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AVM3_ViewSetupErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AVM3_ViewSetupErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AVM3_ViewSetupErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AVM3_ViewSetupErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AVM3_ViewSetupErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AVM3_ViewSetupError &getDefaultInstance();

private:

    inline void cloneData (const AVM3_ViewSetupError& rhs);

    inline void deleteData ();

    AVM3_ViewSetupErrorField __field;

    union {
        AVM3_ViewSetupErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "AVM3_ErrorMessage"
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_ERRORMESSAGE</p>
 */
class AVM3_ErrorMessageStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AVM3_ErrorMessageStatus ();

    /**
     * Copy constructor
     */
    inline  AVM3_ErrorMessageStatus (const AVM3_ErrorMessageStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AVM3_ErrorMessageStatus (::rvc_cca_fi_types::T_e8_AVMph3_ErrorMessage e8ErrorMessage_);

    /**
     * Destructor
     */
    inline virtual  ~AVM3_ErrorMessageStatus();

    /**
     * Assignment operator
     */
    inline AVM3_ErrorMessageStatus& operator = (const AVM3_ErrorMessageStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_ErrorMessageStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_ErrorMessageStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_ErrorMessageStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_ErrorMessageStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorMessage"

    static const int kE8ErrorMessage = 0;

    /**
     * Clears the field "e8ErrorMessage".
     *
     * The field will be set to its default value. The hasE8ErrorMessage()
     * method will return false.
     */
    inline void clearE8ErrorMessage();

    /**
     * Checks whether the field "e8ErrorMessage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorMessage()). Otherwise it will return false.
     */
    inline bool hasE8ErrorMessage () const;

    /**
     * Returns the value of the member "e8ErrorMessage".
     *
     * <p>0 = none / other = the type of error message/information to be given (e.g. pop-up, beep)</p>
     *
     * @return The value of the field "e8ErrorMessage"
     */
    inline ::rvc_cca_fi_types::T_e8_AVMph3_ErrorMessage getE8ErrorMessage () const;

    /**
     * Sets the value of the member "e8ErrorMessage".
     *
     * <p>0 = none / other = the type of error message/information to be given (e.g. pop-up, beep)</p>
     *
     * @param e8ErrorMessage The value which will be set
     */
    inline void setE8ErrorMessage (::rvc_cca_fi_types::T_e8_AVMph3_ErrorMessage e8ErrorMessage_);

    static const AVM3_ErrorMessageStatus &getDefaultInstance();

private:

    inline void set_has_e8ErrorMessage ();

    inline void clear_has_e8ErrorMessage ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_AVMph3_ErrorMessage _e8ErrorMessage;

};

/**
 * The error message of 'AVM3_ErrorMessage'
 */
class AVM3_ErrorMessageErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AVM3_ErrorMessageErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AVM3_ErrorMessageErrorStructure (const AVM3_ErrorMessageErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AVM3_ErrorMessageErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~AVM3_ErrorMessageErrorStructure();

    /**
     * Assignment operator
     */
    inline AVM3_ErrorMessageErrorStructure& operator = (const AVM3_ErrorMessageErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_ErrorMessageErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_ErrorMessageErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_ErrorMessageErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_ErrorMessageErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const AVM3_ErrorMessageErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'AVM3_ErrorMessage'
 */
class AVM3_ErrorMessageError  : public ::asf::core::Payload {
public:

    enum AVM3_ErrorMessageErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AVM3_ErrorMessageError ();

   /**
     * Copy constructor
     */
    inline  AVM3_ErrorMessageError (const AVM3_ErrorMessageError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AVM3_ErrorMessageError();

    /**
     * Assigns a new value to this object.
     */
    inline AVM3_ErrorMessageError& operator = (const AVM3_ErrorMessageError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_ErrorMessageError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_ErrorMessageError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_ErrorMessageError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_ErrorMessageError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AVM3_ErrorMessageError::AVM3_ErrorMessageErrorField getField () const;

    inline void setField(AVM3_ErrorMessageError::AVM3_ErrorMessageErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AVM3_ErrorMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AVM3_ErrorMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AVM3_ErrorMessageErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AVM3_ErrorMessageErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AVM3_ErrorMessageErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AVM3_ErrorMessageErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AVM3_ErrorMessageErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AVM3_ErrorMessageErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AVM3_ErrorMessageError &getDefaultInstance();

private:

    inline void cloneData (const AVM3_ErrorMessageError& rhs);

    inline void deleteData ();

    AVM3_ErrorMessageErrorField __field;

    union {
        AVM3_ErrorMessageErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "AVM3_SonarBuzzerStatus"
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_BUZZERSTATUS</p>
 */
class AVM3_SonarBuzzerStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AVM3_SonarBuzzerStatusStatus ();

    /**
     * Copy constructor
     */
    inline  AVM3_SonarBuzzerStatusStatus (const AVM3_SonarBuzzerStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AVM3_SonarBuzzerStatusStatus (::rvc_cca_fi_types::T_e8_AVMph3_BuzzerStatus e8BuzzerStatus_);

    /**
     * Destructor
     */
    inline virtual  ~AVM3_SonarBuzzerStatusStatus();

    /**
     * Assignment operator
     */
    inline AVM3_SonarBuzzerStatusStatus& operator = (const AVM3_SonarBuzzerStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_SonarBuzzerStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_SonarBuzzerStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_SonarBuzzerStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_SonarBuzzerStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8BuzzerStatus"

    static const int kE8BuzzerStatus = 0;

    /**
     * Clears the field "e8BuzzerStatus".
     *
     * The field will be set to its default value. The hasE8BuzzerStatus()
     * method will return false.
     */
    inline void clearE8BuzzerStatus();

    /**
     * Checks whether the field "e8BuzzerStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8BuzzerStatus()). Otherwise it will return false.
     */
    inline bool hasE8BuzzerStatus () const;

    /**
     * Returns the value of the member "e8BuzzerStatus".
     *
     * <p>0 = Buzzer setting OFF / 1 = Buzzer setting ON</p>
     *
     * @return The value of the field "e8BuzzerStatus"
     */
    inline ::rvc_cca_fi_types::T_e8_AVMph3_BuzzerStatus getE8BuzzerStatus () const;

    /**
     * Sets the value of the member "e8BuzzerStatus".
     *
     * <p>0 = Buzzer setting OFF / 1 = Buzzer setting ON</p>
     *
     * @param e8BuzzerStatus The value which will be set
     */
    inline void setE8BuzzerStatus (::rvc_cca_fi_types::T_e8_AVMph3_BuzzerStatus e8BuzzerStatus_);

    static const AVM3_SonarBuzzerStatusStatus &getDefaultInstance();

private:

    inline void set_has_e8BuzzerStatus ();

    inline void clear_has_e8BuzzerStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_AVMph3_BuzzerStatus _e8BuzzerStatus;

};

/**
 * The error message of 'AVM3_SonarBuzzerStatus'
 */
class AVM3_SonarBuzzerStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AVM3_SonarBuzzerStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AVM3_SonarBuzzerStatusErrorStructure (const AVM3_SonarBuzzerStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AVM3_SonarBuzzerStatusErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~AVM3_SonarBuzzerStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline AVM3_SonarBuzzerStatusErrorStructure& operator = (const AVM3_SonarBuzzerStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_SonarBuzzerStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_SonarBuzzerStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_SonarBuzzerStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_SonarBuzzerStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const AVM3_SonarBuzzerStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'AVM3_SonarBuzzerStatus'
 */
class AVM3_SonarBuzzerStatusError  : public ::asf::core::Payload {
public:

    enum AVM3_SonarBuzzerStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AVM3_SonarBuzzerStatusError ();

   /**
     * Copy constructor
     */
    inline  AVM3_SonarBuzzerStatusError (const AVM3_SonarBuzzerStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AVM3_SonarBuzzerStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline AVM3_SonarBuzzerStatusError& operator = (const AVM3_SonarBuzzerStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_SonarBuzzerStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_SonarBuzzerStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_SonarBuzzerStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_SonarBuzzerStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AVM3_SonarBuzzerStatusError::AVM3_SonarBuzzerStatusErrorField getField () const;

    inline void setField(AVM3_SonarBuzzerStatusError::AVM3_SonarBuzzerStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AVM3_SonarBuzzerStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AVM3_SonarBuzzerStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AVM3_SonarBuzzerStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AVM3_SonarBuzzerStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AVM3_SonarBuzzerStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AVM3_SonarBuzzerStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AVM3_SonarBuzzerStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AVM3_SonarBuzzerStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AVM3_SonarBuzzerStatusError &getDefaultInstance();

private:

    inline void cloneData (const AVM3_SonarBuzzerStatusError& rhs);

    inline void deleteData ();

    AVM3_SonarBuzzerStatusErrorField __field;

    union {
        AVM3_SonarBuzzerStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "AVM3_Settings_Detailed"
 * This property holds the availability and states of all AVM3 settings items, as received from the AVM phase3.
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_SETTINGS_DETAILED</p>
 */
class AVM3_Settings_DetailedStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AVM3_Settings_DetailedStatus ();

    /**
     * Copy constructor
     */
    inline  AVM3_Settings_DetailedStatus (const AVM3_Settings_DetailedStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AVM3_Settings_DetailedStatus (const ::std::vector< ::rvc_cca_fi_types::T_AVMph3_Setting_Option >& arSettingsOption_, ::rvc_cca_fi_types::T_e8_AVMph3_Setting_PrioView e8PriorityView_, ::rvc_cca_fi_types::T_e8_AVMph3_Setting_PrioWide e8PriorityWide_, ::rvc_cca_fi_types::T_e8_AVMph3_Setting_AutoCamPos e8AutoCamPos_, const ::rvc_cca_fi_types::T_AVMph3_Setting_CornerSonarSensLvl& rCornerSonarSensLvl_, const ::rvc_cca_fi_types::T_AVMph3_Setting_SonarSensLvl& rSonarSensLvl_, const ::rvc_cca_fi_types::T_AVMph3_Setting_BuzzerSoundLvl& rBuzzerSoundLvl_);

    /**
     * Destructor
     */
    inline virtual  ~AVM3_Settings_DetailedStatus();

    /**
     * Assignment operator
     */
    inline AVM3_Settings_DetailedStatus& operator = (const AVM3_Settings_DetailedStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_Settings_DetailedStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_Settings_DetailedStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_Settings_DetailedStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_Settings_DetailedStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arSettingsOption"

    static const int kArSettingsOption = 0;

    /**
     * Clears the field "arSettingsOption".
     *
     * The field will be set to its default value. The hasArSettingsOption()
     * method will return false.
     */
    inline void clearArSettingsOption();

    /**
     * Checks whether the field "arSettingsOption" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArSettingsOption()). Otherwise it will return false.
     */
    inline bool hasArSettingsOption () const;

    /**
     * Returns the value of the member "arSettingsOption".
     *
     * List of states of option type camera settings items.
     *
     * @return The value of the field "arSettingsOption"
     */
    inline const ::std::vector< ::rvc_cca_fi_types::T_AVMph3_Setting_Option >& getArSettingsOption () const;

    /**
     * Retrieves the value of the field "arSettingsOption" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arSettingsOption".
     */
    inline ::std::vector< ::rvc_cca_fi_types::T_AVMph3_Setting_Option >& getArSettingsOptionMutable ();

    /**
     * Sets the value of the member "arSettingsOption".
     *
     * List of states of option type camera settings items.
     *
     * @param arSettingsOption The value which will be set
     */
    inline void setArSettingsOption (const ::std::vector< ::rvc_cca_fi_types::T_AVMph3_Setting_Option >& arSettingsOption_);

    // API of field "e8PriorityView"

    static const int kE8PriorityView = 1;

    /**
     * Clears the field "e8PriorityView".
     *
     * The field will be set to its default value. The hasE8PriorityView()
     * method will return false.
     */
    inline void clearE8PriorityView();

    /**
     * Checks whether the field "e8PriorityView" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PriorityView()). Otherwise it will return false.
     */
    inline bool hasE8PriorityView () const;

    /**
     * Returns the value of the member "e8PriorityView".
     *
     * The state of the camera settings item 'Priority_View'
     *
     * @return The value of the field "e8PriorityView"
     */
    inline ::rvc_cca_fi_types::T_e8_AVMph3_Setting_PrioView getE8PriorityView () const;

    /**
     * Sets the value of the member "e8PriorityView".
     *
     * The state of the camera settings item 'Priority_View'
     *
     * @param e8PriorityView The value which will be set
     */
    inline void setE8PriorityView (::rvc_cca_fi_types::T_e8_AVMph3_Setting_PrioView e8PriorityView_);

    // API of field "e8PriorityWide"

    static const int kE8PriorityWide = 2;

    /**
     * Clears the field "e8PriorityWide".
     *
     * The field will be set to its default value. The hasE8PriorityWide()
     * method will return false.
     */
    inline void clearE8PriorityWide();

    /**
     * Checks whether the field "e8PriorityWide" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PriorityWide()). Otherwise it will return false.
     */
    inline bool hasE8PriorityWide () const;

    /**
     * Returns the value of the member "e8PriorityWide".
     *
     * The state of the camera settings item 'Priority_Wide'
     *
     * @return The value of the field "e8PriorityWide"
     */
    inline ::rvc_cca_fi_types::T_e8_AVMph3_Setting_PrioWide getE8PriorityWide () const;

    /**
     * Sets the value of the member "e8PriorityWide".
     *
     * The state of the camera settings item 'Priority_Wide'
     *
     * @param e8PriorityWide The value which will be set
     */
    inline void setE8PriorityWide (::rvc_cca_fi_types::T_e8_AVMph3_Setting_PrioWide e8PriorityWide_);

    // API of field "e8AutoCamPos"

    static const int kE8AutoCamPos = 3;

    /**
     * Clears the field "e8AutoCamPos".
     *
     * The field will be set to its default value. The hasE8AutoCamPos()
     * method will return false.
     */
    inline void clearE8AutoCamPos();

    /**
     * Checks whether the field "e8AutoCamPos" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AutoCamPos()). Otherwise it will return false.
     */
    inline bool hasE8AutoCamPos () const;

    /**
     * Returns the value of the member "e8AutoCamPos".
     *
     * The state of the camera settings item 'Auto_Cam_Pos'
     *
     * @return The value of the field "e8AutoCamPos"
     */
    inline ::rvc_cca_fi_types::T_e8_AVMph3_Setting_AutoCamPos getE8AutoCamPos () const;

    /**
     * Sets the value of the member "e8AutoCamPos".
     *
     * The state of the camera settings item 'Auto_Cam_Pos'
     *
     * @param e8AutoCamPos The value which will be set
     */
    inline void setE8AutoCamPos (::rvc_cca_fi_types::T_e8_AVMph3_Setting_AutoCamPos e8AutoCamPos_);

    // API of field "rCornerSonarSensLvl"

    static const int kRCornerSonarSensLvl = 4;

    /**
     * Clears the field "rCornerSonarSensLvl".
     *
     * The field will be set to its default value. The hasRCornerSonarSensLvl()
     * method will return false.
     */
    inline void clearRCornerSonarSensLvl();

    /**
     * Checks whether the field "rCornerSonarSensLvl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRCornerSonarSensLvl()). Otherwise it will return false.
     */
    inline bool hasRCornerSonarSensLvl () const;

    /**
     * Returns the value of the member "rCornerSonarSensLvl".
     *
     * The state of the camera settings item 'Corner_Sonar_Sensitivity'
     *
     * @return The value of the field "rCornerSonarSensLvl"
     */
    inline const ::rvc_cca_fi_types::T_AVMph3_Setting_CornerSonarSensLvl& getRCornerSonarSensLvl () const;

    /**
     * Retrieves the value of the field "rCornerSonarSensLvl" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rCornerSonarSensLvl".
     */
    inline ::rvc_cca_fi_types::T_AVMph3_Setting_CornerSonarSensLvl& getRCornerSonarSensLvlMutable ();

    /**
     * Sets the value of the member "rCornerSonarSensLvl".
     *
     * The state of the camera settings item 'Corner_Sonar_Sensitivity'
     *
     * @param rCornerSonarSensLvl The value which will be set
     */
    inline void setRCornerSonarSensLvl (const ::rvc_cca_fi_types::T_AVMph3_Setting_CornerSonarSensLvl& rCornerSonarSensLvl_);

    // API of field "rSonarSensLvl"

    static const int kRSonarSensLvl = 5;

    /**
     * Clears the field "rSonarSensLvl".
     *
     * The field will be set to its default value. The hasRSonarSensLvl()
     * method will return false.
     */
    inline void clearRSonarSensLvl();

    /**
     * Checks whether the field "rSonarSensLvl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRSonarSensLvl()). Otherwise it will return false.
     */
    inline bool hasRSonarSensLvl () const;

    /**
     * Returns the value of the member "rSonarSensLvl".
     *
     * The state of the camera settings item 'Sonar_Sensitivity_Level'
     *
     * @return The value of the field "rSonarSensLvl"
     */
    inline const ::rvc_cca_fi_types::T_AVMph3_Setting_SonarSensLvl& getRSonarSensLvl () const;

    /**
     * Retrieves the value of the field "rSonarSensLvl" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rSonarSensLvl".
     */
    inline ::rvc_cca_fi_types::T_AVMph3_Setting_SonarSensLvl& getRSonarSensLvlMutable ();

    /**
     * Sets the value of the member "rSonarSensLvl".
     *
     * The state of the camera settings item 'Sonar_Sensitivity_Level'
     *
     * @param rSonarSensLvl The value which will be set
     */
    inline void setRSonarSensLvl (const ::rvc_cca_fi_types::T_AVMph3_Setting_SonarSensLvl& rSonarSensLvl_);

    // API of field "rBuzzerSoundLvl"

    static const int kRBuzzerSoundLvl = 6;

    /**
     * Clears the field "rBuzzerSoundLvl".
     *
     * The field will be set to its default value. The hasRBuzzerSoundLvl()
     * method will return false.
     */
    inline void clearRBuzzerSoundLvl();

    /**
     * Checks whether the field "rBuzzerSoundLvl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRBuzzerSoundLvl()). Otherwise it will return false.
     */
    inline bool hasRBuzzerSoundLvl () const;

    /**
     * Returns the value of the member "rBuzzerSoundLvl".
     *
     * The state of the camera settings item 'Buzzer_Sound_Level'
     *
     * @return The value of the field "rBuzzerSoundLvl"
     */
    inline const ::rvc_cca_fi_types::T_AVMph3_Setting_BuzzerSoundLvl& getRBuzzerSoundLvl () const;

    /**
     * Retrieves the value of the field "rBuzzerSoundLvl" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rBuzzerSoundLvl".
     */
    inline ::rvc_cca_fi_types::T_AVMph3_Setting_BuzzerSoundLvl& getRBuzzerSoundLvlMutable ();

    /**
     * Sets the value of the member "rBuzzerSoundLvl".
     *
     * The state of the camera settings item 'Buzzer_Sound_Level'
     *
     * @param rBuzzerSoundLvl The value which will be set
     */
    inline void setRBuzzerSoundLvl (const ::rvc_cca_fi_types::T_AVMph3_Setting_BuzzerSoundLvl& rBuzzerSoundLvl_);

    static const AVM3_Settings_DetailedStatus &getDefaultInstance();

private:

    static const ::std::vector< ::rvc_cca_fi_types::T_AVMph3_Setting_Option >& getT_AVMph3_Setting_OptionList_DefaultInstance ();

    inline void set_has_arSettingsOption ();

    inline void clear_has_arSettingsOption ();

    inline void set_has_e8PriorityView ();

    inline void clear_has_e8PriorityView ();

    inline void set_has_e8PriorityWide ();

    inline void clear_has_e8PriorityWide ();

    inline void set_has_e8AutoCamPos ();

    inline void clear_has_e8AutoCamPos ();

    inline void set_has_rCornerSonarSensLvl ();

    inline void clear_has_rCornerSonarSensLvl ();

    inline void set_has_rSonarSensLvl ();

    inline void clear_has_rSonarSensLvl ();

    inline void set_has_rBuzzerSoundLvl ();

    inline void clear_has_rBuzzerSoundLvl ();

    uint32 _has_bits_[ (7 + 31) / 32];

    ::std::vector< ::rvc_cca_fi_types::T_AVMph3_Setting_Option > _arSettingsOption;

    ::rvc_cca_fi_types::T_e8_AVMph3_Setting_PrioView _e8PriorityView;

    ::rvc_cca_fi_types::T_e8_AVMph3_Setting_PrioWide _e8PriorityWide;

    ::rvc_cca_fi_types::T_e8_AVMph3_Setting_AutoCamPos _e8AutoCamPos;

    ::rvc_cca_fi_types::T_AVMph3_Setting_CornerSonarSensLvl _rCornerSonarSensLvl;

    ::rvc_cca_fi_types::T_AVMph3_Setting_SonarSensLvl _rSonarSensLvl;

    ::rvc_cca_fi_types::T_AVMph3_Setting_BuzzerSoundLvl _rBuzzerSoundLvl;

};

/**
 * The error message of 'AVM3_Settings_Detailed'
 */
class AVM3_Settings_DetailedErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AVM3_Settings_DetailedErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AVM3_Settings_DetailedErrorStructure (const AVM3_Settings_DetailedErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AVM3_Settings_DetailedErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~AVM3_Settings_DetailedErrorStructure();

    /**
     * Assignment operator
     */
    inline AVM3_Settings_DetailedErrorStructure& operator = (const AVM3_Settings_DetailedErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_Settings_DetailedErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_Settings_DetailedErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_Settings_DetailedErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_Settings_DetailedErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const AVM3_Settings_DetailedErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'AVM3_Settings_Detailed'
 */
class AVM3_Settings_DetailedError  : public ::asf::core::Payload {
public:

    enum AVM3_Settings_DetailedErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AVM3_Settings_DetailedError ();

   /**
     * Copy constructor
     */
    inline  AVM3_Settings_DetailedError (const AVM3_Settings_DetailedError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AVM3_Settings_DetailedError();

    /**
     * Assigns a new value to this object.
     */
    inline AVM3_Settings_DetailedError& operator = (const AVM3_Settings_DetailedError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_Settings_DetailedError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_Settings_DetailedError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_Settings_DetailedError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_Settings_DetailedError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AVM3_Settings_DetailedError::AVM3_Settings_DetailedErrorField getField () const;

    inline void setField(AVM3_Settings_DetailedError::AVM3_Settings_DetailedErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AVM3_Settings_DetailedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AVM3_Settings_DetailedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AVM3_Settings_DetailedErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AVM3_Settings_DetailedErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AVM3_Settings_DetailedErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AVM3_Settings_DetailedErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AVM3_Settings_DetailedErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AVM3_Settings_DetailedErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AVM3_Settings_DetailedError &getDefaultInstance();

private:

    inline void cloneData (const AVM3_Settings_DetailedError& rhs);

    inline void deleteData ();

    AVM3_Settings_DetailedErrorField __field;

    union {
        AVM3_Settings_DetailedErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "AVM3_Settings_Primary"
 * This property holds the availability and states of all AVM3 settings items in the camera primary settings display.
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_SETTINGS_PRIMARY</p>
 */
class AVM3_Settings_PrimaryStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AVM3_Settings_PrimaryStatus ();

    /**
     * Copy constructor
     */
    inline  AVM3_Settings_PrimaryStatus (const AVM3_Settings_PrimaryStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AVM3_Settings_PrimaryStatus (::rvc_cca_fi_types::T_e8_AVMph3_SettingOptionState e8AvmSonarBuzzer_, bool bDetailsSettingsAvail_, bool bImageQualitySettingAvail_);

    /**
     * Destructor
     */
    inline virtual  ~AVM3_Settings_PrimaryStatus();

    /**
     * Assignment operator
     */
    inline AVM3_Settings_PrimaryStatus& operator = (const AVM3_Settings_PrimaryStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_Settings_PrimaryStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_Settings_PrimaryStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_Settings_PrimaryStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_Settings_PrimaryStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8AvmSonarBuzzer"

    static const int kE8AvmSonarBuzzer = 0;

    /**
     * Clears the field "e8AvmSonarBuzzer".
     *
     * The field will be set to its default value. The hasE8AvmSonarBuzzer()
     * method will return false.
     */
    inline void clearE8AvmSonarBuzzer();

    /**
     * Checks whether the field "e8AvmSonarBuzzer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AvmSonarBuzzer()). Otherwise it will return false.
     */
    inline bool hasE8AvmSonarBuzzer () const;

    /**
     * Returns the value of the member "e8AvmSonarBuzzer".
     *
     * Unavailable/OFF/ON state of the AVM Sonar Buzzer setting.
     *
     * @return The value of the field "e8AvmSonarBuzzer"
     */
    inline ::rvc_cca_fi_types::T_e8_AVMph3_SettingOptionState getE8AvmSonarBuzzer () const;

    /**
     * Sets the value of the member "e8AvmSonarBuzzer".
     *
     * Unavailable/OFF/ON state of the AVM Sonar Buzzer setting.
     *
     * @param e8AvmSonarBuzzer The value which will be set
     */
    inline void setE8AvmSonarBuzzer (::rvc_cca_fi_types::T_e8_AVMph3_SettingOptionState e8AvmSonarBuzzer_);

    // API of field "bDetailsSettingsAvail"

    static const int kBDetailsSettingsAvail = 1;

    /**
     * Clears the field "bDetailsSettingsAvail".
     *
     * The field will be set to its default value. The hasBDetailsSettingsAvail()
     * method will return false.
     */
    inline void clearBDetailsSettingsAvail();

    /**
     * Checks whether the field "bDetailsSettingsAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDetailsSettingsAvail()). Otherwise it will return false.
     */
    inline bool hasBDetailsSettingsAvail () const;

    /**
     * Returns the value of the member "bDetailsSettingsAvail".
     *
     * <p>FALSE/TRUE = Details Settings unavailable / available</p>
     *
     * @return The value of the field "bDetailsSettingsAvail"
     */
    inline bool getBDetailsSettingsAvail () const;

    /**
     * Sets the value of the member "bDetailsSettingsAvail".
     *
     * <p>FALSE/TRUE = Details Settings unavailable / available</p>
     *
     * @param bDetailsSettingsAvail The value which will be set
     */
    inline void setBDetailsSettingsAvail (bool bDetailsSettingsAvail_);

    // API of field "bImageQualitySettingAvail"

    static const int kBImageQualitySettingAvail = 2;

    /**
     * Clears the field "bImageQualitySettingAvail".
     *
     * The field will be set to its default value. The hasBImageQualitySettingAvail()
     * method will return false.
     */
    inline void clearBImageQualitySettingAvail();

    /**
     * Checks whether the field "bImageQualitySettingAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBImageQualitySettingAvail()). Otherwise it will return false.
     */
    inline bool hasBImageQualitySettingAvail () const;

    /**
     * Returns the value of the member "bImageQualitySettingAvail".
     *
     * <p>FALSE/TRUE = Image Quality Settings unavailable / available</p>
     *
     * @return The value of the field "bImageQualitySettingAvail"
     */
    inline bool getBImageQualitySettingAvail () const;

    /**
     * Sets the value of the member "bImageQualitySettingAvail".
     *
     * <p>FALSE/TRUE = Image Quality Settings unavailable / available</p>
     *
     * @param bImageQualitySettingAvail The value which will be set
     */
    inline void setBImageQualitySettingAvail (bool bImageQualitySettingAvail_);

    static const AVM3_Settings_PrimaryStatus &getDefaultInstance();

private:

    inline void set_has_e8AvmSonarBuzzer ();

    inline void clear_has_e8AvmSonarBuzzer ();

    inline void set_has_bDetailsSettingsAvail ();

    inline void clear_has_bDetailsSettingsAvail ();

    inline void set_has_bImageQualitySettingAvail ();

    inline void clear_has_bImageQualitySettingAvail ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_AVMph3_SettingOptionState _e8AvmSonarBuzzer;

    bool _bDetailsSettingsAvail;

    bool _bImageQualitySettingAvail;

};

/**
 * The error message of 'AVM3_Settings_Primary'
 */
class AVM3_Settings_PrimaryErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AVM3_Settings_PrimaryErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AVM3_Settings_PrimaryErrorStructure (const AVM3_Settings_PrimaryErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AVM3_Settings_PrimaryErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~AVM3_Settings_PrimaryErrorStructure();

    /**
     * Assignment operator
     */
    inline AVM3_Settings_PrimaryErrorStructure& operator = (const AVM3_Settings_PrimaryErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_Settings_PrimaryErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_Settings_PrimaryErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_Settings_PrimaryErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_Settings_PrimaryErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const AVM3_Settings_PrimaryErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'AVM3_Settings_Primary'
 */
class AVM3_Settings_PrimaryError  : public ::asf::core::Payload {
public:

    enum AVM3_Settings_PrimaryErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AVM3_Settings_PrimaryError ();

   /**
     * Copy constructor
     */
    inline  AVM3_Settings_PrimaryError (const AVM3_Settings_PrimaryError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AVM3_Settings_PrimaryError();

    /**
     * Assigns a new value to this object.
     */
    inline AVM3_Settings_PrimaryError& operator = (const AVM3_Settings_PrimaryError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_Settings_PrimaryError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_Settings_PrimaryError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_Settings_PrimaryError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_Settings_PrimaryError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AVM3_Settings_PrimaryError::AVM3_Settings_PrimaryErrorField getField () const;

    inline void setField(AVM3_Settings_PrimaryError::AVM3_Settings_PrimaryErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AVM3_Settings_PrimaryErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AVM3_Settings_PrimaryErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AVM3_Settings_PrimaryErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AVM3_Settings_PrimaryErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AVM3_Settings_PrimaryErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AVM3_Settings_PrimaryErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AVM3_Settings_PrimaryErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AVM3_Settings_PrimaryErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AVM3_Settings_PrimaryError &getDefaultInstance();

private:

    inline void cloneData (const AVM3_Settings_PrimaryError& rhs);

    inline void deleteData ();

    AVM3_Settings_PrimaryErrorField __field;

    union {
        AVM3_Settings_PrimaryErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "AVM3_Configuration"
 * This property holds the basic configuration parameters of the AVM3 ECU as received from the ECU via MCAN during connection setup.
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_CONFIGURATION</p>
 */
class AVM3_ConfigurationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AVM3_ConfigurationStatus ();

    /**
     * Copy constructor
     */
    inline  AVM3_ConfigurationStatus (const AVM3_ConfigurationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AVM3_ConfigurationStatus (::rvc_cca_fi_types::T_e8_AVMph3_ConfigurationStatus e8ConfigStatus_, const ::rvc_cca_fi_types::T_AVMph3_Unit_ID& rUnit_ID_, const ::rvc_cca_fi_types::T_AVMph3_VersionInfo& rMsgSetVersion_);

    /**
     * Destructor
     */
    inline virtual  ~AVM3_ConfigurationStatus();

    /**
     * Assignment operator
     */
    inline AVM3_ConfigurationStatus& operator = (const AVM3_ConfigurationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_ConfigurationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_ConfigurationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_ConfigurationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_ConfigurationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ConfigStatus"

    static const int kE8ConfigStatus = 0;

    /**
     * Clears the field "e8ConfigStatus".
     *
     * The field will be set to its default value. The hasE8ConfigStatus()
     * method will return false.
     */
    inline void clearE8ConfigStatus();

    /**
     * Checks whether the field "e8ConfigStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ConfigStatus()). Otherwise it will return false.
     */
    inline bool hasE8ConfigStatus () const;

    /**
     * Returns the value of the member "e8ConfigStatus".
     *
     * Status of the configuration (undefined, valid, invalid)
     *
     * @return The value of the field "e8ConfigStatus"
     */
    inline ::rvc_cca_fi_types::T_e8_AVMph3_ConfigurationStatus getE8ConfigStatus () const;

    /**
     * Sets the value of the member "e8ConfigStatus".
     *
     * Status of the configuration (undefined, valid, invalid)
     *
     * @param e8ConfigStatus The value which will be set
     */
    inline void setE8ConfigStatus (::rvc_cca_fi_types::T_e8_AVMph3_ConfigurationStatus e8ConfigStatus_);

    // API of field "rUnit_ID"

    static const int kRUnit_ID = 1;

    /**
     * Clears the field "rUnit_ID".
     *
     * The field will be set to its default value. The hasRUnit_ID()
     * method will return false.
     */
    inline void clearRUnit_ID();

    /**
     * Checks whether the field "rUnit_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRUnit_ID()). Otherwise it will return false.
     */
    inline bool hasRUnit_ID () const;

    /**
     * Returns the value of the member "rUnit_ID".
     *
     * Record defining properties/capabilities of the AVM phase3 ECU being connected
     *
     * @return The value of the field "rUnit_ID"
     */
    inline const ::rvc_cca_fi_types::T_AVMph3_Unit_ID& getRUnit_ID () const;

    /**
     * Retrieves the value of the field "rUnit_ID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rUnit_ID".
     */
    inline ::rvc_cca_fi_types::T_AVMph3_Unit_ID& getRUnit_IDMutable ();

    /**
     * Sets the value of the member "rUnit_ID".
     *
     * Record defining properties/capabilities of the AVM phase3 ECU being connected
     *
     * @param rUnit_ID The value which will be set
     */
    inline void setRUnit_ID (const ::rvc_cca_fi_types::T_AVMph3_Unit_ID& rUnit_ID_);

    // API of field "rMsgSetVersion"

    static const int kRMsgSetVersion = 2;

    /**
     * Clears the field "rMsgSetVersion".
     *
     * The field will be set to its default value. The hasRMsgSetVersion()
     * method will return false.
     */
    inline void clearRMsgSetVersion();

    /**
     * Checks whether the field "rMsgSetVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRMsgSetVersion()). Otherwise it will return false.
     */
    inline bool hasRMsgSetVersion () const;

    /**
     * Returns the value of the member "rMsgSetVersion".
     *
     * Record with information about the version number of the message set specification
     *
     * @return The value of the field "rMsgSetVersion"
     */
    inline const ::rvc_cca_fi_types::T_AVMph3_VersionInfo& getRMsgSetVersion () const;

    /**
     * Retrieves the value of the field "rMsgSetVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rMsgSetVersion".
     */
    inline ::rvc_cca_fi_types::T_AVMph3_VersionInfo& getRMsgSetVersionMutable ();

    /**
     * Sets the value of the member "rMsgSetVersion".
     *
     * Record with information about the version number of the message set specification
     *
     * @param rMsgSetVersion The value which will be set
     */
    inline void setRMsgSetVersion (const ::rvc_cca_fi_types::T_AVMph3_VersionInfo& rMsgSetVersion_);

    static const AVM3_ConfigurationStatus &getDefaultInstance();

private:

    inline void set_has_e8ConfigStatus ();

    inline void clear_has_e8ConfigStatus ();

    inline void set_has_rUnit_ID ();

    inline void clear_has_rUnit_ID ();

    inline void set_has_rMsgSetVersion ();

    inline void clear_has_rMsgSetVersion ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_AVMph3_ConfigurationStatus _e8ConfigStatus;

    ::rvc_cca_fi_types::T_AVMph3_Unit_ID _rUnit_ID;

    ::rvc_cca_fi_types::T_AVMph3_VersionInfo _rMsgSetVersion;

};

/**
 * The error message of 'AVM3_Configuration'
 */
class AVM3_ConfigurationErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AVM3_ConfigurationErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AVM3_ConfigurationErrorStructure (const AVM3_ConfigurationErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AVM3_ConfigurationErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~AVM3_ConfigurationErrorStructure();

    /**
     * Assignment operator
     */
    inline AVM3_ConfigurationErrorStructure& operator = (const AVM3_ConfigurationErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_ConfigurationErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_ConfigurationErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_ConfigurationErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_ConfigurationErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const AVM3_ConfigurationErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'AVM3_Configuration'
 */
class AVM3_ConfigurationError  : public ::asf::core::Payload {
public:

    enum AVM3_ConfigurationErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AVM3_ConfigurationError ();

   /**
     * Copy constructor
     */
    inline  AVM3_ConfigurationError (const AVM3_ConfigurationError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AVM3_ConfigurationError();

    /**
     * Assigns a new value to this object.
     */
    inline AVM3_ConfigurationError& operator = (const AVM3_ConfigurationError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_ConfigurationError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_ConfigurationError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_ConfigurationError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_ConfigurationError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AVM3_ConfigurationError::AVM3_ConfigurationErrorField getField () const;

    inline void setField(AVM3_ConfigurationError::AVM3_ConfigurationErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AVM3_ConfigurationErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AVM3_ConfigurationErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AVM3_ConfigurationErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AVM3_ConfigurationErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AVM3_ConfigurationErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AVM3_ConfigurationErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AVM3_ConfigurationErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AVM3_ConfigurationErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AVM3_ConfigurationError &getDefaultInstance();

private:

    inline void cloneData (const AVM3_ConfigurationError& rhs);

    inline void deleteData ();

    AVM3_ConfigurationErrorField __field;

    union {
        AVM3_ConfigurationErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "AVM3_Software_Version"
 * This property holds the AVM3 software version information.
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_SOFTWARE_VERSION</p>
 */
class AVM3_Software_VersionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AVM3_Software_VersionStatus ();

    /**
     * Copy constructor
     */
    inline  AVM3_Software_VersionStatus (const AVM3_Software_VersionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AVM3_Software_VersionStatus (const ::rvc_cca_fi_types::T_AVMph3_VersionInfo& rSW_Version_AVM_, const ::rvc_cca_fi_types::T_AVMph3_VersionInfo& rSW_Version_Sonar_);

    /**
     * Destructor
     */
    inline virtual  ~AVM3_Software_VersionStatus();

    /**
     * Assignment operator
     */
    inline AVM3_Software_VersionStatus& operator = (const AVM3_Software_VersionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_Software_VersionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_Software_VersionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_Software_VersionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_Software_VersionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rSW_Version_AVM"

    static const int kRSW_Version_AVM = 0;

    /**
     * Clears the field "rSW_Version_AVM".
     *
     * The field will be set to its default value. The hasRSW_Version_AVM()
     * method will return false.
     */
    inline void clearRSW_Version_AVM();

    /**
     * Checks whether the field "rSW_Version_AVM" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRSW_Version_AVM()). Otherwise it will return false.
     */
    inline bool hasRSW_Version_AVM () const;

    /**
     * Returns the value of the member "rSW_Version_AVM".
     *
     * Version info for the AVM3 ECU itself
     *
     * @return The value of the field "rSW_Version_AVM"
     */
    inline const ::rvc_cca_fi_types::T_AVMph3_VersionInfo& getRSW_Version_AVM () const;

    /**
     * Retrieves the value of the field "rSW_Version_AVM" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rSW_Version_AVM".
     */
    inline ::rvc_cca_fi_types::T_AVMph3_VersionInfo& getRSW_Version_AVMMutable ();

    /**
     * Sets the value of the member "rSW_Version_AVM".
     *
     * Version info for the AVM3 ECU itself
     *
     * @param rSW_Version_AVM The value which will be set
     */
    inline void setRSW_Version_AVM (const ::rvc_cca_fi_types::T_AVMph3_VersionInfo& rSW_Version_AVM_);

    // API of field "rSW_Version_Sonar"

    static const int kRSW_Version_Sonar = 1;

    /**
     * Clears the field "rSW_Version_Sonar".
     *
     * The field will be set to its default value. The hasRSW_Version_Sonar()
     * method will return false.
     */
    inline void clearRSW_Version_Sonar();

    /**
     * Checks whether the field "rSW_Version_Sonar" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRSW_Version_Sonar()). Otherwise it will return false.
     */
    inline bool hasRSW_Version_Sonar () const;

    /**
     * Returns the value of the member "rSW_Version_Sonar".
     *
     * Version info for the Sonar ECU connected to the AVM3 ECU
     *
     * @return The value of the field "rSW_Version_Sonar"
     */
    inline const ::rvc_cca_fi_types::T_AVMph3_VersionInfo& getRSW_Version_Sonar () const;

    /**
     * Retrieves the value of the field "rSW_Version_Sonar" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rSW_Version_Sonar".
     */
    inline ::rvc_cca_fi_types::T_AVMph3_VersionInfo& getRSW_Version_SonarMutable ();

    /**
     * Sets the value of the member "rSW_Version_Sonar".
     *
     * Version info for the Sonar ECU connected to the AVM3 ECU
     *
     * @param rSW_Version_Sonar The value which will be set
     */
    inline void setRSW_Version_Sonar (const ::rvc_cca_fi_types::T_AVMph3_VersionInfo& rSW_Version_Sonar_);

    static const AVM3_Software_VersionStatus &getDefaultInstance();

private:

    inline void set_has_rSW_Version_AVM ();

    inline void clear_has_rSW_Version_AVM ();

    inline void set_has_rSW_Version_Sonar ();

    inline void clear_has_rSW_Version_Sonar ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::rvc_cca_fi_types::T_AVMph3_VersionInfo _rSW_Version_AVM;

    ::rvc_cca_fi_types::T_AVMph3_VersionInfo _rSW_Version_Sonar;

};

/**
 * The error message of 'AVM3_Software_Version'
 */
class AVM3_Software_VersionErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AVM3_Software_VersionErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AVM3_Software_VersionErrorStructure (const AVM3_Software_VersionErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AVM3_Software_VersionErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~AVM3_Software_VersionErrorStructure();

    /**
     * Assignment operator
     */
    inline AVM3_Software_VersionErrorStructure& operator = (const AVM3_Software_VersionErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_Software_VersionErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_Software_VersionErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_Software_VersionErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_Software_VersionErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const AVM3_Software_VersionErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'AVM3_Software_Version'
 */
class AVM3_Software_VersionError  : public ::asf::core::Payload {
public:

    enum AVM3_Software_VersionErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AVM3_Software_VersionError ();

   /**
     * Copy constructor
     */
    inline  AVM3_Software_VersionError (const AVM3_Software_VersionError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AVM3_Software_VersionError();

    /**
     * Assigns a new value to this object.
     */
    inline AVM3_Software_VersionError& operator = (const AVM3_Software_VersionError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_Software_VersionError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_Software_VersionError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_Software_VersionError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_Software_VersionError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AVM3_Software_VersionError::AVM3_Software_VersionErrorField getField () const;

    inline void setField(AVM3_Software_VersionError::AVM3_Software_VersionErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AVM3_Software_VersionErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AVM3_Software_VersionErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AVM3_Software_VersionErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AVM3_Software_VersionErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AVM3_Software_VersionErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AVM3_Software_VersionErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AVM3_Software_VersionErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AVM3_Software_VersionErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AVM3_Software_VersionError &getDefaultInstance();

private:

    inline void cloneData (const AVM3_Software_VersionError& rhs);

    inline void deleteData ();

    AVM3_Software_VersionErrorField __field;

    union {
        AVM3_Software_VersionErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "AVM3_Hardware_Version"
 * This property holds the AVM3 hardware version information.
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_HARDWARE_VERSION</p>
 */
class AVM3_Hardware_VersionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AVM3_Hardware_VersionStatus ();

    /**
     * Copy constructor
     */
    inline  AVM3_Hardware_VersionStatus (const AVM3_Hardware_VersionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AVM3_Hardware_VersionStatus (const ::rvc_cca_fi_types::T_AVMph3_VersionInfo& rHW_Version_AVM_, const ::rvc_cca_fi_types::T_AVMph3_VersionInfo& rHW_Version_Sonar_);

    /**
     * Destructor
     */
    inline virtual  ~AVM3_Hardware_VersionStatus();

    /**
     * Assignment operator
     */
    inline AVM3_Hardware_VersionStatus& operator = (const AVM3_Hardware_VersionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_Hardware_VersionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_Hardware_VersionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_Hardware_VersionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_Hardware_VersionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rHW_Version_AVM"

    static const int kRHW_Version_AVM = 0;

    /**
     * Clears the field "rHW_Version_AVM".
     *
     * The field will be set to its default value. The hasRHW_Version_AVM()
     * method will return false.
     */
    inline void clearRHW_Version_AVM();

    /**
     * Checks whether the field "rHW_Version_AVM" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRHW_Version_AVM()). Otherwise it will return false.
     */
    inline bool hasRHW_Version_AVM () const;

    /**
     * Returns the value of the member "rHW_Version_AVM".
     *
     * Version info for the AVM3 ECU itself
     *
     * @return The value of the field "rHW_Version_AVM"
     */
    inline const ::rvc_cca_fi_types::T_AVMph3_VersionInfo& getRHW_Version_AVM () const;

    /**
     * Retrieves the value of the field "rHW_Version_AVM" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rHW_Version_AVM".
     */
    inline ::rvc_cca_fi_types::T_AVMph3_VersionInfo& getRHW_Version_AVMMutable ();

    /**
     * Sets the value of the member "rHW_Version_AVM".
     *
     * Version info for the AVM3 ECU itself
     *
     * @param rHW_Version_AVM The value which will be set
     */
    inline void setRHW_Version_AVM (const ::rvc_cca_fi_types::T_AVMph3_VersionInfo& rHW_Version_AVM_);

    // API of field "rHW_Version_Sonar"

    static const int kRHW_Version_Sonar = 1;

    /**
     * Clears the field "rHW_Version_Sonar".
     *
     * The field will be set to its default value. The hasRHW_Version_Sonar()
     * method will return false.
     */
    inline void clearRHW_Version_Sonar();

    /**
     * Checks whether the field "rHW_Version_Sonar" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRHW_Version_Sonar()). Otherwise it will return false.
     */
    inline bool hasRHW_Version_Sonar () const;

    /**
     * Returns the value of the member "rHW_Version_Sonar".
     *
     * Version info for the Sonar ECU connected to the AVM3 ECU
     *
     * @return The value of the field "rHW_Version_Sonar"
     */
    inline const ::rvc_cca_fi_types::T_AVMph3_VersionInfo& getRHW_Version_Sonar () const;

    /**
     * Retrieves the value of the field "rHW_Version_Sonar" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rHW_Version_Sonar".
     */
    inline ::rvc_cca_fi_types::T_AVMph3_VersionInfo& getRHW_Version_SonarMutable ();

    /**
     * Sets the value of the member "rHW_Version_Sonar".
     *
     * Version info for the Sonar ECU connected to the AVM3 ECU
     *
     * @param rHW_Version_Sonar The value which will be set
     */
    inline void setRHW_Version_Sonar (const ::rvc_cca_fi_types::T_AVMph3_VersionInfo& rHW_Version_Sonar_);

    static const AVM3_Hardware_VersionStatus &getDefaultInstance();

private:

    inline void set_has_rHW_Version_AVM ();

    inline void clear_has_rHW_Version_AVM ();

    inline void set_has_rHW_Version_Sonar ();

    inline void clear_has_rHW_Version_Sonar ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::rvc_cca_fi_types::T_AVMph3_VersionInfo _rHW_Version_AVM;

    ::rvc_cca_fi_types::T_AVMph3_VersionInfo _rHW_Version_Sonar;

};

/**
 * The error message of 'AVM3_Hardware_Version'
 */
class AVM3_Hardware_VersionErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AVM3_Hardware_VersionErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AVM3_Hardware_VersionErrorStructure (const AVM3_Hardware_VersionErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AVM3_Hardware_VersionErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~AVM3_Hardware_VersionErrorStructure();

    /**
     * Assignment operator
     */
    inline AVM3_Hardware_VersionErrorStructure& operator = (const AVM3_Hardware_VersionErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_Hardware_VersionErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_Hardware_VersionErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_Hardware_VersionErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_Hardware_VersionErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const AVM3_Hardware_VersionErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'AVM3_Hardware_Version'
 */
class AVM3_Hardware_VersionError  : public ::asf::core::Payload {
public:

    enum AVM3_Hardware_VersionErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AVM3_Hardware_VersionError ();

   /**
     * Copy constructor
     */
    inline  AVM3_Hardware_VersionError (const AVM3_Hardware_VersionError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AVM3_Hardware_VersionError();

    /**
     * Assigns a new value to this object.
     */
    inline AVM3_Hardware_VersionError& operator = (const AVM3_Hardware_VersionError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_Hardware_VersionError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_Hardware_VersionError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_Hardware_VersionError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_Hardware_VersionError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AVM3_Hardware_VersionError::AVM3_Hardware_VersionErrorField getField () const;

    inline void setField(AVM3_Hardware_VersionError::AVM3_Hardware_VersionErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AVM3_Hardware_VersionErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AVM3_Hardware_VersionErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AVM3_Hardware_VersionErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AVM3_Hardware_VersionErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AVM3_Hardware_VersionErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AVM3_Hardware_VersionErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AVM3_Hardware_VersionErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AVM3_Hardware_VersionErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AVM3_Hardware_VersionError &getDefaultInstance();

private:

    inline void cloneData (const AVM3_Hardware_VersionError& rhs);

    inline void deleteData ();

    AVM3_Hardware_VersionErrorField __field;

    union {
        AVM3_Hardware_VersionErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "AVM3_CommunicationErrors"
 * This property holds the MCAN communication error related parameters (ref. 25953NDS06).
 * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_COMMUNICATION_ERROR</p>
 */
class AVM3_CommunicationErrorsStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AVM3_CommunicationErrorsStatus ();

    /**
     * Copy constructor
     */
    inline  AVM3_CommunicationErrorsStatus (const AVM3_CommunicationErrorsStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AVM3_CommunicationErrorsStatus (const ::rvc_cca_fi_types::T_AVMph3_MCAN_CommunicationErrors& rCommErrors_);

    /**
     * Destructor
     */
    inline virtual  ~AVM3_CommunicationErrorsStatus();

    /**
     * Assignment operator
     */
    inline AVM3_CommunicationErrorsStatus& operator = (const AVM3_CommunicationErrorsStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_CommunicationErrorsStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_CommunicationErrorsStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_CommunicationErrorsStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_CommunicationErrorsStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "rCommErrors"

    static const int kRCommErrors = 0;

    /**
     * Clears the field "rCommErrors".
     *
     * The field will be set to its default value. The hasRCommErrors()
     * method will return false.
     */
    inline void clearRCommErrors();

    /**
     * Checks whether the field "rCommErrors" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRCommErrors()). Otherwise it will return false.
     */
    inline bool hasRCommErrors () const;

    /**
     * Returns the value of the member "rCommErrors".
     *
     * Record holding the states of all AVM phase3 MCAN communication errors
     *
     * @return The value of the field "rCommErrors"
     */
    inline const ::rvc_cca_fi_types::T_AVMph3_MCAN_CommunicationErrors& getRCommErrors () const;

    /**
     * Retrieves the value of the field "rCommErrors" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rCommErrors".
     */
    inline ::rvc_cca_fi_types::T_AVMph3_MCAN_CommunicationErrors& getRCommErrorsMutable ();

    /**
     * Sets the value of the member "rCommErrors".
     *
     * Record holding the states of all AVM phase3 MCAN communication errors
     *
     * @param rCommErrors The value which will be set
     */
    inline void setRCommErrors (const ::rvc_cca_fi_types::T_AVMph3_MCAN_CommunicationErrors& rCommErrors_);

    static const AVM3_CommunicationErrorsStatus &getDefaultInstance();

private:

    inline void set_has_rCommErrors ();

    inline void clear_has_rCommErrors ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_AVMph3_MCAN_CommunicationErrors _rCommErrors;

};

/**
 * The error message of 'AVM3_CommunicationErrors'
 */
class AVM3_CommunicationErrorsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AVM3_CommunicationErrorsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AVM3_CommunicationErrorsErrorStructure (const AVM3_CommunicationErrorsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AVM3_CommunicationErrorsErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~AVM3_CommunicationErrorsErrorStructure();

    /**
     * Assignment operator
     */
    inline AVM3_CommunicationErrorsErrorStructure& operator = (const AVM3_CommunicationErrorsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_CommunicationErrorsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_CommunicationErrorsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_CommunicationErrorsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_CommunicationErrorsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const AVM3_CommunicationErrorsErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'AVM3_CommunicationErrors'
 */
class AVM3_CommunicationErrorsError  : public ::asf::core::Payload {
public:

    enum AVM3_CommunicationErrorsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AVM3_CommunicationErrorsError ();

   /**
     * Copy constructor
     */
    inline  AVM3_CommunicationErrorsError (const AVM3_CommunicationErrorsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AVM3_CommunicationErrorsError();

    /**
     * Assigns a new value to this object.
     */
    inline AVM3_CommunicationErrorsError& operator = (const AVM3_CommunicationErrorsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AVM3_CommunicationErrorsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AVM3_CommunicationErrorsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AVM3_CommunicationErrorsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AVM3_CommunicationErrorsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AVM3_CommunicationErrorsError::AVM3_CommunicationErrorsErrorField getField () const;

    inline void setField(AVM3_CommunicationErrorsError::AVM3_CommunicationErrorsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AVM3_CommunicationErrorsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AVM3_CommunicationErrorsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AVM3_CommunicationErrorsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AVM3_CommunicationErrorsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AVM3_CommunicationErrorsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AVM3_CommunicationErrorsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AVM3_CommunicationErrorsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AVM3_CommunicationErrorsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AVM3_CommunicationErrorsError &getDefaultInstance();

private:

    inline void cloneData (const AVM3_CommunicationErrorsError& rhs);

    inline void deleteData ();

    AVM3_CommunicationErrorsErrorField __field;

    union {
        AVM3_CommunicationErrorsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "CameraButton"
 * To inform the vd_rvc component about user presses on the camera button within certain HMI states related to RVC/AVM.
 * <p>FUNCID = RVC_CCAFI_C_U16_CAMERABUTTON</p>
 */
class CameraButtonStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CameraButtonStart ();

    /**
     * Copy constructor
     */
    inline  CameraButtonStart (const CameraButtonStart &rhs);

    /**
     * All fields constructor
     */
    inline  CameraButtonStart (::rvc_cca_fi_types::T_e8_RVC_ButtonState e8ButtonState_);

    /**
     * Destructor
     */
    inline virtual  ~CameraButtonStart();

    /**
     * Assignment operator
     */
    inline CameraButtonStart& operator = (const CameraButtonStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CameraButtonStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CameraButtonStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CameraButtonStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CameraButtonStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ButtonState"

    static const int kE8ButtonState = 0;

    /**
     * Clears the field "e8ButtonState".
     *
     * The field will be set to its default value. The hasE8ButtonState()
     * method will return false.
     */
    inline void clearE8ButtonState();

    /**
     * Checks whether the field "e8ButtonState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ButtonState()). Otherwise it will return false.
     */
    inline bool hasE8ButtonState () const;

    /**
     * Returns the value of the member "e8ButtonState".
     *
     * To inform about camera button state changes (pressed/released).
     *
     * @return The value of the field "e8ButtonState"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_ButtonState getE8ButtonState () const;

    /**
     * Sets the value of the member "e8ButtonState".
     *
     * To inform about camera button state changes (pressed/released).
     *
     * @param e8ButtonState The value which will be set
     */
    inline void setE8ButtonState (::rvc_cca_fi_types::T_e8_RVC_ButtonState e8ButtonState_);

    static const CameraButtonStart &getDefaultInstance();

private:

    inline void set_has_e8ButtonState ();

    inline void clear_has_e8ButtonState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_ButtonState _e8ButtonState;

};

/**
 * The result message of the method "CameraButton"
 * To inform the vd_rvc component about user presses on the camera button within certain HMI states related to RVC/AVM.
 * <p>FUNCID = RVC_CCAFI_C_U16_CAMERABUTTON</p>
 */
class CameraButtonResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CameraButtonResult ();

    /**
     * Copy constructor
     */
    inline  CameraButtonResult (const CameraButtonResult &rhs);

    /**
     * All fields constructor
     */
    inline  CameraButtonResult (bool Result_);

    /**
     * Destructor
     */
    inline virtual  ~CameraButtonResult();

    /**
     * Assignment operator
     */
    inline CameraButtonResult& operator = (const CameraButtonResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CameraButtonResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CameraButtonResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CameraButtonResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CameraButtonResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @return The value of the field "Result"
     */
    inline bool getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @param Result The value which will be set
     */
    inline void setResult (bool Result_);

    static const CameraButtonResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Result;

};

/**
 * The error message of 'CameraButton'
 */
class CameraButtonErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  CameraButtonErrorStructure ();

    /**
     * Copy constructor
     */
    inline  CameraButtonErrorStructure (const CameraButtonErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  CameraButtonErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~CameraButtonErrorStructure();

    /**
     * Assignment operator
     */
    inline CameraButtonErrorStructure& operator = (const CameraButtonErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CameraButtonErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CameraButtonErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CameraButtonErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CameraButtonErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Error codes
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Error codes
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const CameraButtonErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'CameraButton'
 */
class CameraButtonError  : public ::asf::core::Payload {
public:

    enum CameraButtonErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  CameraButtonError ();

   /**
     * Copy constructor
     */
    inline  CameraButtonError (const CameraButtonError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~CameraButtonError();

    /**
     * Assigns a new value to this object.
     */
    inline CameraButtonError& operator = (const CameraButtonError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CameraButtonError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CameraButtonError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CameraButtonError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CameraButtonError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline CameraButtonError::CameraButtonErrorField getField () const;

    inline void setField(CameraButtonError::CameraButtonErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "CameraButtonErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "CameraButtonErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const CameraButtonErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline CameraButtonErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline CameraButtonErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (CameraButtonErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "CameraButtonErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const CameraButtonErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const CameraButtonError &getDefaultInstance();

private:

    inline void cloneData (const CameraButtonError& rhs);

    inline void deleteData ();

    CameraButtonErrorField __field;

    union {
        CameraButtonErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetStatusHmi"
 * To inform the vd_rvc component about the availibilty of HMI.
 * VD_RVC will use this information to differentiate for early or normal video activation.
 */
class SetStatusHmiStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetStatusHmiStart ();

    /**
     * Copy constructor
     */
    inline  SetStatusHmiStart (const SetStatusHmiStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetStatusHmiStart (::rvc_cca_fi_types::T_e8_RVC_Status e8StatusHmi_);

    /**
     * Destructor
     */
    inline virtual  ~SetStatusHmiStart();

    /**
     * Assignment operator
     */
    inline SetStatusHmiStart& operator = (const SetStatusHmiStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetStatusHmiStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetStatusHmiStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetStatusHmiStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetStatusHmiStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8StatusHmi"

    static const int kE8StatusHmi = 0;

    /**
     * Clears the field "e8StatusHmi".
     *
     * The field will be set to its default value. The hasE8StatusHmi()
     * method will return false.
     */
    inline void clearE8StatusHmi();

    /**
     * Checks whether the field "e8StatusHmi" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8StatusHmi()). Otherwise it will return false.
     */
    inline bool hasE8StatusHmi () const;

    /**
     * Returns the value of the member "e8StatusHmi".
     *
     * HMI availability status.
     * If available, HMI can handle the normal RVC/AVM screen activation.
     *
     * @return The value of the field "e8StatusHmi"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_Status getE8StatusHmi () const;

    /**
     * Sets the value of the member "e8StatusHmi".
     *
     * HMI availability status.
     * If available, HMI can handle the normal RVC/AVM screen activation.
     *
     * @param e8StatusHmi The value which will be set
     */
    inline void setE8StatusHmi (::rvc_cca_fi_types::T_e8_RVC_Status e8StatusHmi_);

    static const SetStatusHmiStart &getDefaultInstance();

private:

    inline void set_has_e8StatusHmi ();

    inline void clear_has_e8StatusHmi ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_Status _e8StatusHmi;

};

/**
 * The result message of the method "SetStatusHmi"
 * To inform the vd_rvc component about the availibilty of HMI.
 * VD_RVC will use this information to differentiate for early or normal video activation.
 */
class SetStatusHmiResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetStatusHmiResult ();

    /**
     * Copy constructor
     */
    inline  SetStatusHmiResult (const SetStatusHmiResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetStatusHmiResult (::rvc_cca_fi_types::T_e8_RVC_SystemStatus e8SystemStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SetStatusHmiResult();

    /**
     * Assignment operator
     */
    inline SetStatusHmiResult& operator = (const SetStatusHmiResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetStatusHmiResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetStatusHmiResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetStatusHmiResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetStatusHmiResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8SystemStatus"

    static const int kE8SystemStatus = 0;

    /**
     * Clears the field "e8SystemStatus".
     *
     * The field will be set to its default value. The hasE8SystemStatus()
     * method will return false.
     */
    inline void clearE8SystemStatus();

    /**
     * Checks whether the field "e8SystemStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SystemStatus()). Otherwise it will return false.
     */
    inline bool hasE8SystemStatus () const;

    /**
     * Returns the value of the member "e8SystemStatus".
     *
     * Current activation status of the vision sytem
     *
     * @return The value of the field "e8SystemStatus"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_SystemStatus getE8SystemStatus () const;

    /**
     * Sets the value of the member "e8SystemStatus".
     *
     * Current activation status of the vision sytem
     *
     * @param e8SystemStatus The value which will be set
     */
    inline void setE8SystemStatus (::rvc_cca_fi_types::T_e8_RVC_SystemStatus e8SystemStatus_);

    static const SetStatusHmiResult &getDefaultInstance();

private:

    inline void set_has_e8SystemStatus ();

    inline void clear_has_e8SystemStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_SystemStatus _e8SystemStatus;

};

/**
 * The error message of 'SetStatusHmi'
 */
class SetStatusHmiErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetStatusHmiErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetStatusHmiErrorStructure (const SetStatusHmiErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetStatusHmiErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SetStatusHmiErrorStructure();

    /**
     * Assignment operator
     */
    inline SetStatusHmiErrorStructure& operator = (const SetStatusHmiErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetStatusHmiErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetStatusHmiErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetStatusHmiErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetStatusHmiErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * If the meaning of "e8ErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * If the meaning of "e8ErrorCode" isn't clear, then there should be a description here.
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    static const SetStatusHmiErrorStructure &getDefaultInstance();

private:

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _e8ErrorCode;

};

/**
 * The error message of 'SetStatusHmi'
 */
class SetStatusHmiError  : public ::asf::core::Payload {
public:

    enum SetStatusHmiErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetStatusHmiError ();

   /**
     * Copy constructor
     */
    inline  SetStatusHmiError (const SetStatusHmiError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetStatusHmiError();

    /**
     * Assigns a new value to this object.
     */
    inline SetStatusHmiError& operator = (const SetStatusHmiError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetStatusHmiError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetStatusHmiError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetStatusHmiError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetStatusHmiError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetStatusHmiError::SetStatusHmiErrorField getField () const;

    inline void setField(SetStatusHmiError::SetStatusHmiErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetStatusHmiErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetStatusHmiErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetStatusHmiErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetStatusHmiErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetStatusHmiErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetStatusHmiErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetStatusHmiErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetStatusHmiErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetStatusHmiError &getDefaultInstance();

private:

    inline void cloneData (const SetStatusHmiError& rhs);

    inline void deleteData ();

    SetStatusHmiErrorField __field;

    union {
        SetStatusHmiErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetupLanguage"
 * To inform the vd_rvc component about the Language setup done by the user.
 * This method has to be called by HMI once after system startup and in case of a change of the setup done by the user.
 * <p>FUNCID = RVC_CCAFI_C_U16_SETUPLANGUAGE</p>
 */
class SetupLanguageStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetupLanguageStart ();

    /**
     * Copy constructor
     */
    inline  SetupLanguageStart (const SetupLanguageStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetupLanguageStart (::rvc_cca_fi_types::T_e8_RVC_Language e8Language_);

    /**
     * Destructor
     */
    inline virtual  ~SetupLanguageStart();

    /**
     * Assignment operator
     */
    inline SetupLanguageStart& operator = (const SetupLanguageStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetupLanguageStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetupLanguageStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetupLanguageStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetupLanguageStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Language"

    static const int kE8Language = 0;

    /**
     * Clears the field "e8Language".
     *
     * The field will be set to its default value. The hasE8Language()
     * method will return false.
     */
    inline void clearE8Language();

    /**
     * Checks whether the field "e8Language" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Language()). Otherwise it will return false.
     */
    inline bool hasE8Language () const;

    /**
     * Returns the value of the member "e8Language".
     *
     * To set the language.
     *
     * @return The value of the field "e8Language"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_Language getE8Language () const;

    /**
     * Sets the value of the member "e8Language".
     *
     * To set the language.
     *
     * @param e8Language The value which will be set
     */
    inline void setE8Language (::rvc_cca_fi_types::T_e8_RVC_Language e8Language_);

    static const SetupLanguageStart &getDefaultInstance();

private:

    inline void set_has_e8Language ();

    inline void clear_has_e8Language ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_Language _e8Language;

};

/**
 * The result message of the method "SetupLanguage"
 * To inform the vd_rvc component about the Language setup done by the user.
 * This method has to be called by HMI once after system startup and in case of a change of the setup done by the user.
 * <p>FUNCID = RVC_CCAFI_C_U16_SETUPLANGUAGE</p>
 */
class SetupLanguageResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetupLanguageResult ();

    /**
     * Copy constructor
     */
    inline  SetupLanguageResult (const SetupLanguageResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetupLanguageResult (bool Result_);

    /**
     * Destructor
     */
    inline virtual  ~SetupLanguageResult();

    /**
     * Assignment operator
     */
    inline SetupLanguageResult& operator = (const SetupLanguageResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetupLanguageResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetupLanguageResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetupLanguageResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetupLanguageResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @return The value of the field "Result"
     */
    inline bool getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @param Result The value which will be set
     */
    inline void setResult (bool Result_);

    static const SetupLanguageResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Result;

};

/**
 * The error message of 'SetupLanguage'
 */
class SetupLanguageErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetupLanguageErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetupLanguageErrorStructure (const SetupLanguageErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetupLanguageErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SetupLanguageErrorStructure();

    /**
     * Assignment operator
     */
    inline SetupLanguageErrorStructure& operator = (const SetupLanguageErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetupLanguageErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetupLanguageErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetupLanguageErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetupLanguageErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Error codes
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Error codes
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const SetupLanguageErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'SetupLanguage'
 */
class SetupLanguageError  : public ::asf::core::Payload {
public:

    enum SetupLanguageErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetupLanguageError ();

   /**
     * Copy constructor
     */
    inline  SetupLanguageError (const SetupLanguageError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetupLanguageError();

    /**
     * Assigns a new value to this object.
     */
    inline SetupLanguageError& operator = (const SetupLanguageError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetupLanguageError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetupLanguageError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetupLanguageError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetupLanguageError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetupLanguageError::SetupLanguageErrorField getField () const;

    inline void setField(SetupLanguageError::SetupLanguageErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetupLanguageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetupLanguageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetupLanguageErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetupLanguageErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetupLanguageErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetupLanguageErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetupLanguageErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetupLanguageErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetupLanguageError &getDefaultInstance();

private:

    inline void cloneData (const SetupLanguageError& rhs);

    inline void deleteData ();

    SetupLanguageErrorField __field;

    union {
        SetupLanguageErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetupGuideLine"
 * To inform the vd_rvc component about the Camera visibility and GuideLine setup done by the user.
 * This method has to be called by HMI once after system startup and in case of a change of the setup done by the user.
 * <p>FUNCID = RVC_CCAFI_C_U16_SETGUIDELINE</p>
 */
class SetupGuideLineStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetupGuideLineStart ();

    /**
     * Copy constructor
     */
    inline  SetupGuideLineStart (const SetupGuideLineStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetupGuideLineStart (::rvc_cca_fi_types::T_e8_RVC_StatusGuideLine e8GuideLine_);

    /**
     * Destructor
     */
    inline virtual  ~SetupGuideLineStart();

    /**
     * Assignment operator
     */
    inline SetupGuideLineStart& operator = (const SetupGuideLineStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetupGuideLineStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetupGuideLineStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetupGuideLineStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetupGuideLineStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8GuideLine"

    static const int kE8GuideLine = 0;

    /**
     * Clears the field "e8GuideLine".
     *
     * The field will be set to its default value. The hasE8GuideLine()
     * method will return false.
     */
    inline void clearE8GuideLine();

    /**
     * Checks whether the field "e8GuideLine" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8GuideLine()). Otherwise it will return false.
     */
    inline bool hasE8GuideLine () const;

    /**
     * Returns the value of the member "e8GuideLine".
     *
     * Set user configuration for GuideLine visibility (ON/Off value) for both Static and Dynamic.
     *
     * @return The value of the field "e8GuideLine"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_StatusGuideLine getE8GuideLine () const;

    /**
     * Sets the value of the member "e8GuideLine".
     *
     * Set user configuration for GuideLine visibility (ON/Off value) for both Static and Dynamic.
     *
     * @param e8GuideLine The value which will be set
     */
    inline void setE8GuideLine (::rvc_cca_fi_types::T_e8_RVC_StatusGuideLine e8GuideLine_);

    static const SetupGuideLineStart &getDefaultInstance();

private:

    inline void set_has_e8GuideLine ();

    inline void clear_has_e8GuideLine ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_StatusGuideLine _e8GuideLine;

};

/**
 * The result message of the method "SetupGuideLine"
 * To inform the vd_rvc component about the Camera visibility and GuideLine setup done by the user.
 * This method has to be called by HMI once after system startup and in case of a change of the setup done by the user.
 * <p>FUNCID = RVC_CCAFI_C_U16_SETGUIDELINE</p>
 */
class SetupGuideLineResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetupGuideLineResult ();

    /**
     * Copy constructor
     */
    inline  SetupGuideLineResult (const SetupGuideLineResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetupGuideLineResult (bool Result_);

    /**
     * Destructor
     */
    inline virtual  ~SetupGuideLineResult();

    /**
     * Assignment operator
     */
    inline SetupGuideLineResult& operator = (const SetupGuideLineResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetupGuideLineResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetupGuideLineResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetupGuideLineResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetupGuideLineResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @return The value of the field "Result"
     */
    inline bool getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @param Result The value which will be set
     */
    inline void setResult (bool Result_);

    static const SetupGuideLineResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Result;

};

/**
 * The error message of 'SetupGuideLine'
 */
class SetupGuideLineErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetupGuideLineErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetupGuideLineErrorStructure (const SetupGuideLineErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetupGuideLineErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SetupGuideLineErrorStructure();

    /**
     * Assignment operator
     */
    inline SetupGuideLineErrorStructure& operator = (const SetupGuideLineErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetupGuideLineErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetupGuideLineErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetupGuideLineErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetupGuideLineErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Error codes
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Error codes
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const SetupGuideLineErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'SetupGuideLine'
 */
class SetupGuideLineError  : public ::asf::core::Payload {
public:

    enum SetupGuideLineErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetupGuideLineError ();

   /**
     * Copy constructor
     */
    inline  SetupGuideLineError (const SetupGuideLineError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetupGuideLineError();

    /**
     * Assigns a new value to this object.
     */
    inline SetupGuideLineError& operator = (const SetupGuideLineError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetupGuideLineError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetupGuideLineError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetupGuideLineError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetupGuideLineError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetupGuideLineError::SetupGuideLineErrorField getField () const;

    inline void setField(SetupGuideLineError::SetupGuideLineErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetupGuideLineErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetupGuideLineErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetupGuideLineErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetupGuideLineErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetupGuideLineErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetupGuideLineErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetupGuideLineErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetupGuideLineErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetupGuideLineError &getDefaultInstance();

private:

    inline void cloneData (const SetupGuideLineError& rhs);

    inline void deleteData ();

    SetupGuideLineErrorField __field;

    union {
        SetupGuideLineErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetupVideoControls"
 * This method is to inform the vd_rvc component about the Brightness, Contrast, Color Hue/Tint and Black Level setup for the video signal done by the user.
 * This method has to be called by HMI once after system startup and in case of a change of the setup done by the user.
 * <p>FUNCID = RVC_CCAFI_C_U16_SETUPVIDEOCONTROLS</p>
 */
class SetupVideoControlsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetupVideoControlsStart ();

    /**
     * Copy constructor
     */
    inline  SetupVideoControlsStart (const SetupVideoControlsStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetupVideoControlsStart (::rvc_cca_fi_types::T_e8_RVC_VideoParameterDimmingMode e8HMIDimmingMode_, const ::std::vector< ::rvc_cca_fi_types::T_RVC_VideoAnalogLevels >& arVideoControlParameter_, ::rvc_cca_fi_types::T_e8_MVCViewingState e8MVCViewingState_);

    /**
     * Destructor
     */
    inline virtual  ~SetupVideoControlsStart();

    /**
     * Assignment operator
     */
    inline SetupVideoControlsStart& operator = (const SetupVideoControlsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetupVideoControlsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetupVideoControlsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetupVideoControlsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetupVideoControlsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8HMIDimmingMode"

    static const int kE8HMIDimmingMode = 0;

    /**
     * Clears the field "e8HMIDimmingMode".
     *
     * The field will be set to its default value. The hasE8HMIDimmingMode()
     * method will return false.
     */
    inline void clearE8HMIDimmingMode();

    /**
     * Checks whether the field "e8HMIDimmingMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8HMIDimmingMode()). Otherwise it will return false.
     */
    inline bool hasE8HMIDimmingMode () const;

    /**
     * Returns the value of the member "e8HMIDimmingMode".
     *
     * current HMI dimming state
     *
     * @return The value of the field "e8HMIDimmingMode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_VideoParameterDimmingMode getE8HMIDimmingMode () const;

    /**
     * Sets the value of the member "e8HMIDimmingMode".
     *
     * current HMI dimming state
     *
     * @param e8HMIDimmingMode The value which will be set
     */
    inline void setE8HMIDimmingMode (::rvc_cca_fi_types::T_e8_RVC_VideoParameterDimmingMode e8HMIDimmingMode_);

    // API of field "arVideoControlParameter"

    static const int kArVideoControlParameter = 1;

    /**
     * Clears the field "arVideoControlParameter".
     *
     * The field will be set to its default value. The hasArVideoControlParameter()
     * method will return false.
     */
    inline void clearArVideoControlParameter();

    /**
     * Checks whether the field "arVideoControlParameter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArVideoControlParameter()). Otherwise it will return false.
     */
    inline bool hasArVideoControlParameter () const;

    /**
     * Returns the value of the member "arVideoControlParameter".
     *
     * List with parameters for the video analog levels to
     * set the analog levels of the video signal.
     *
     * @return The value of the field "arVideoControlParameter"
     */
    inline const ::std::vector< ::rvc_cca_fi_types::T_RVC_VideoAnalogLevels >& getArVideoControlParameter () const;

    /**
     * Retrieves the value of the field "arVideoControlParameter" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arVideoControlParameter".
     */
    inline ::std::vector< ::rvc_cca_fi_types::T_RVC_VideoAnalogLevels >& getArVideoControlParameterMutable ();

    /**
     * Sets the value of the member "arVideoControlParameter".
     *
     * List with parameters for the video analog levels to
     * set the analog levels of the video signal.
     *
     * @param arVideoControlParameter The value which will be set
     */
    inline void setArVideoControlParameter (const ::std::vector< ::rvc_cca_fi_types::T_RVC_VideoAnalogLevels >& arVideoControlParameter_);

    // API of field "e8MVCViewingState"

    static const int kE8MVCViewingState = 2;

    /**
     * Clears the field "e8MVCViewingState".
     *
     * The field will be set to its default value. The hasE8MVCViewingState()
     * method will return false.
     */
    inline void clearE8MVCViewingState();

    /**
     * Checks whether the field "e8MVCViewingState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MVCViewingState()). Otherwise it will return false.
     */
    inline bool hasE8MVCViewingState () const;

    /**
     * Returns the value of the member "e8MVCViewingState".
     *
     * current MVC viewing state
     *
     * @return The value of the field "e8MVCViewingState"
     */
    inline ::rvc_cca_fi_types::T_e8_MVCViewingState getE8MVCViewingState () const;

    /**
     * Sets the value of the member "e8MVCViewingState".
     *
     * current MVC viewing state
     *
     * @param e8MVCViewingState The value which will be set
     */
    inline void setE8MVCViewingState (::rvc_cca_fi_types::T_e8_MVCViewingState e8MVCViewingState_);

    static const SetupVideoControlsStart &getDefaultInstance();

private:

    static const ::std::vector< ::rvc_cca_fi_types::T_RVC_VideoAnalogLevels >& getT_RVC_VideoAnalogLevelsList_DefaultInstance ();

    inline void set_has_e8HMIDimmingMode ();

    inline void clear_has_e8HMIDimmingMode ();

    inline void set_has_arVideoControlParameter ();

    inline void clear_has_arVideoControlParameter ();

    inline void set_has_e8MVCViewingState ();

    inline void clear_has_e8MVCViewingState ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_VideoParameterDimmingMode _e8HMIDimmingMode;

    ::std::vector< ::rvc_cca_fi_types::T_RVC_VideoAnalogLevels > _arVideoControlParameter;

    ::rvc_cca_fi_types::T_e8_MVCViewingState _e8MVCViewingState;

};

/**
 * The result message of the method "SetupVideoControls"
 * This method is to inform the vd_rvc component about the Brightness, Contrast, Color Hue/Tint and Black Level setup for the video signal done by the user.
 * This method has to be called by HMI once after system startup and in case of a change of the setup done by the user.
 * <p>FUNCID = RVC_CCAFI_C_U16_SETUPVIDEOCONTROLS</p>
 */
class SetupVideoControlsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetupVideoControlsResult ();

    /**
     * Copy constructor
     */
    inline  SetupVideoControlsResult (const SetupVideoControlsResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetupVideoControlsResult (bool Result_);

    /**
     * Destructor
     */
    inline virtual  ~SetupVideoControlsResult();

    /**
     * Assignment operator
     */
    inline SetupVideoControlsResult& operator = (const SetupVideoControlsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetupVideoControlsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetupVideoControlsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetupVideoControlsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetupVideoControlsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @return The value of the field "Result"
     */
    inline bool getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @param Result The value which will be set
     */
    inline void setResult (bool Result_);

    static const SetupVideoControlsResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Result;

};

/**
 * The error message of 'SetupVideoControls'
 */
class SetupVideoControlsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetupVideoControlsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetupVideoControlsErrorStructure (const SetupVideoControlsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetupVideoControlsErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SetupVideoControlsErrorStructure();

    /**
     * Assignment operator
     */
    inline SetupVideoControlsErrorStructure& operator = (const SetupVideoControlsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetupVideoControlsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetupVideoControlsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetupVideoControlsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetupVideoControlsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Error codes
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Error codes
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const SetupVideoControlsErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'SetupVideoControls'
 */
class SetupVideoControlsError  : public ::asf::core::Payload {
public:

    enum SetupVideoControlsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetupVideoControlsError ();

   /**
     * Copy constructor
     */
    inline  SetupVideoControlsError (const SetupVideoControlsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetupVideoControlsError();

    /**
     * Assigns a new value to this object.
     */
    inline SetupVideoControlsError& operator = (const SetupVideoControlsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetupVideoControlsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetupVideoControlsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetupVideoControlsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetupVideoControlsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetupVideoControlsError::SetupVideoControlsErrorField getField () const;

    inline void setField(SetupVideoControlsError::SetupVideoControlsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetupVideoControlsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetupVideoControlsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetupVideoControlsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetupVideoControlsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetupVideoControlsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetupVideoControlsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetupVideoControlsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetupVideoControlsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetupVideoControlsError &getDefaultInstance();

private:

    inline void cloneData (const SetupVideoControlsError& rhs);

    inline void deleteData ();

    SetupVideoControlsErrorField __field;

    union {
        SetupVideoControlsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetSystemStatus"
 * Can be used to switch ON/OFF the vision system.
 * <p>FUNCID = RVC_CCAFI_C_U16_SETSYSTEMSTATUS</p>
 */
class SetSystemStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetSystemStatusStart ();

    /**
     * Copy constructor
     */
    inline  SetSystemStatusStart (const SetSystemStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetSystemStatusStart (::rvc_cca_fi_types::T_e8_RVC_SystemStatus e8SystemStatus_, ::rvc_cca_fi_types::T_e8_RVC_StatusGuideLine e8GuideLine_, ::rvc_cca_fi_types::T_e8_RVC_StatusWarningText e8WarningText_);

    /**
     * Destructor
     */
    inline virtual  ~SetSystemStatusStart();

    /**
     * Assignment operator
     */
    inline SetSystemStatusStart& operator = (const SetSystemStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetSystemStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetSystemStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetSystemStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetSystemStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8SystemStatus"

    static const int kE8SystemStatus = 0;

    /**
     * Clears the field "e8SystemStatus".
     *
     * The field will be set to its default value. The hasE8SystemStatus()
     * method will return false.
     */
    inline void clearE8SystemStatus();

    /**
     * Checks whether the field "e8SystemStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SystemStatus()). Otherwise it will return false.
     */
    inline bool hasE8SystemStatus () const;

    /**
     * Returns the value of the member "e8SystemStatus".
     *
     * <p>requested activation status of the vision sytem,</p>
     * <p>only the states</p>
     * <p>"VISUALISATION_OFF",</p>
     * <p>"RVC_VISUALISATION_ON"</p>
     * <p>"AVM_VISUALISATION_ON"</p>
     * <p>"MVC_VISUALISATION_FRONT_VIEW</p>
     * <p>"MVC_VISUALISATION_REAR_VIEW"</p>
     * <p>"MVC_VISUALISATION_RIGHT_VIEW"</p>
     * <p>"MVC_VISUALISATION_LEFT_VIEW"</p>
     * <p>are supported</p>
     *
     * @return The value of the field "e8SystemStatus"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_SystemStatus getE8SystemStatus () const;

    /**
     * Sets the value of the member "e8SystemStatus".
     *
     * <p>requested activation status of the vision sytem,</p>
     * <p>only the states</p>
     * <p>"VISUALISATION_OFF",</p>
     * <p>"RVC_VISUALISATION_ON"</p>
     * <p>"AVM_VISUALISATION_ON"</p>
     * <p>"MVC_VISUALISATION_FRONT_VIEW</p>
     * <p>"MVC_VISUALISATION_REAR_VIEW"</p>
     * <p>"MVC_VISUALISATION_RIGHT_VIEW"</p>
     * <p>"MVC_VISUALISATION_LEFT_VIEW"</p>
     * <p>are supported</p>
     *
     * @param e8SystemStatus The value which will be set
     */
    inline void setE8SystemStatus (::rvc_cca_fi_types::T_e8_RVC_SystemStatus e8SystemStatus_);

    // API of field "e8GuideLine"

    static const int kE8GuideLine = 1;

    /**
     * Clears the field "e8GuideLine".
     *
     * The field will be set to its default value. The hasE8GuideLine()
     * method will return false.
     */
    inline void clearE8GuideLine();

    /**
     * Checks whether the field "e8GuideLine" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8GuideLine()). Otherwise it will return false.
     */
    inline bool hasE8GuideLine () const;

    /**
     * Returns the value of the member "e8GuideLine".
     *
     * With this parameter decission could be made to show the guidelines or not when visualization is requested.
     *
     * @return The value of the field "e8GuideLine"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_StatusGuideLine getE8GuideLine () const;

    /**
     * Sets the value of the member "e8GuideLine".
     *
     * With this parameter decission could be made to show the guidelines or not when visualization is requested.
     *
     * @param e8GuideLine The value which will be set
     */
    inline void setE8GuideLine (::rvc_cca_fi_types::T_e8_RVC_StatusGuideLine e8GuideLine_);

    // API of field "e8WarningText"

    static const int kE8WarningText = 2;

    /**
     * Clears the field "e8WarningText".
     *
     * The field will be set to its default value. The hasE8WarningText()
     * method will return false.
     */
    inline void clearE8WarningText();

    /**
     * Checks whether the field "e8WarningText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8WarningText()). Otherwise it will return false.
     */
    inline bool hasE8WarningText () const;

    /**
     * Returns the value of the member "e8WarningText".
     *
     * With this parameter decission could be made to show the warning text or not when visualization is requested.
     *
     * @return The value of the field "e8WarningText"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_StatusWarningText getE8WarningText () const;

    /**
     * Sets the value of the member "e8WarningText".
     *
     * With this parameter decission could be made to show the warning text or not when visualization is requested.
     *
     * @param e8WarningText The value which will be set
     */
    inline void setE8WarningText (::rvc_cca_fi_types::T_e8_RVC_StatusWarningText e8WarningText_);

    static const SetSystemStatusStart &getDefaultInstance();

private:

    inline void set_has_e8SystemStatus ();

    inline void clear_has_e8SystemStatus ();

    inline void set_has_e8GuideLine ();

    inline void clear_has_e8GuideLine ();

    inline void set_has_e8WarningText ();

    inline void clear_has_e8WarningText ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_SystemStatus _e8SystemStatus;

    ::rvc_cca_fi_types::T_e8_RVC_StatusGuideLine _e8GuideLine;

    ::rvc_cca_fi_types::T_e8_RVC_StatusWarningText _e8WarningText;

};

/**
 * The result message of the method "SetSystemStatus"
 * Can be used to switch ON/OFF the vision system.
 * <p>FUNCID = RVC_CCAFI_C_U16_SETSYSTEMSTATUS</p>
 */
class SetSystemStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetSystemStatusResult ();

    /**
     * Copy constructor
     */
    inline  SetSystemStatusResult (const SetSystemStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetSystemStatusResult (bool Result_);

    /**
     * Destructor
     */
    inline virtual  ~SetSystemStatusResult();

    /**
     * Assignment operator
     */
    inline SetSystemStatusResult& operator = (const SetSystemStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetSystemStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetSystemStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetSystemStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetSystemStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @return The value of the field "Result"
     */
    inline bool getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @param Result The value which will be set
     */
    inline void setResult (bool Result_);

    static const SetSystemStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Result;

};

/**
 * The error message of 'SetSystemStatus'
 */
class SetSystemStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetSystemStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetSystemStatusErrorStructure (const SetSystemStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetSystemStatusErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SetSystemStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline SetSystemStatusErrorStructure& operator = (const SetSystemStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetSystemStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetSystemStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetSystemStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetSystemStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Error codes
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Error codes
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const SetSystemStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'SetSystemStatus'
 */
class SetSystemStatusError  : public ::asf::core::Payload {
public:

    enum SetSystemStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetSystemStatusError ();

   /**
     * Copy constructor
     */
    inline  SetSystemStatusError (const SetSystemStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetSystemStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline SetSystemStatusError& operator = (const SetSystemStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetSystemStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetSystemStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetSystemStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetSystemStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetSystemStatusError::SetSystemStatusErrorField getField () const;

    inline void setField(SetSystemStatusError::SetSystemStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetSystemStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetSystemStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetSystemStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetSystemStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetSystemStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetSystemStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetSystemStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetSystemStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetSystemStatusError &getDefaultInstance();

private:

    inline void cloneData (const SetSystemStatusError& rhs);

    inline void deleteData ();

    SetSystemStatusErrorField __field;

    union {
        SetSystemStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "runExtDevicePowerSupplyTest"
 */
class RunExtDevicePowerSupplyTestStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RunExtDevicePowerSupplyTestStart ();

    /**
     * Copy constructor
     */
    inline  RunExtDevicePowerSupplyTestStart (const RunExtDevicePowerSupplyTestStart &rhs);

    /**
     * All fields constructor
     */
    inline  RunExtDevicePowerSupplyTestStart (uint16 pwrSupplyID_);

    /**
     * Destructor
     */
    inline virtual  ~RunExtDevicePowerSupplyTestStart();

    /**
     * Assignment operator
     */
    inline RunExtDevicePowerSupplyTestStart& operator = (const RunExtDevicePowerSupplyTestStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RunExtDevicePowerSupplyTestStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RunExtDevicePowerSupplyTestStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RunExtDevicePowerSupplyTestStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RunExtDevicePowerSupplyTestStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pwrSupplyID"

    static const int kPwrSupplyID = 0;

    /**
     * Clears the field "pwrSupplyID".
     *
     * The field will be set to its default value. The hasPwrSupplyID()
     * method will return false.
     */
    inline void clearPwrSupplyID();

    /**
     * Checks whether the field "pwrSupplyID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPwrSupplyID()). Otherwise it will return false.
     */
    inline bool hasPwrSupplyID () const;

    /**
     * Returns the value of the member "pwrSupplyID".
     *
     * If the meaning of "pwrSupplyID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pwrSupplyID"
     */
    inline uint16 getPwrSupplyID () const;

    /**
     * Sets the value of the member "pwrSupplyID".
     *
     * If the meaning of "pwrSupplyID" isn't clear, then there should be a description here.
     *
     * @param pwrSupplyID The value which will be set
     */
    inline void setPwrSupplyID (uint16 pwrSupplyID_);

    static const RunExtDevicePowerSupplyTestStart &getDefaultInstance();

private:

    inline void set_has_pwrSupplyID ();

    inline void clear_has_pwrSupplyID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _pwrSupplyID;

};

/**
 * The result message of the method "runExtDevicePowerSupplyTest"
 */
class RunExtDevicePowerSupplyTestResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RunExtDevicePowerSupplyTestResult ();

    /**
     * Copy constructor
     */
    inline  RunExtDevicePowerSupplyTestResult (const RunExtDevicePowerSupplyTestResult &rhs);

    /**
     * All fields constructor
     */
    inline  RunExtDevicePowerSupplyTestResult (uint16 pwrSupplyID_, ::rvc_cca_fi_types::T_e8_Camera_PowerSupplyStatus status_, uint32 current_);

    /**
     * Destructor
     */
    inline virtual  ~RunExtDevicePowerSupplyTestResult();

    /**
     * Assignment operator
     */
    inline RunExtDevicePowerSupplyTestResult& operator = (const RunExtDevicePowerSupplyTestResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RunExtDevicePowerSupplyTestResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RunExtDevicePowerSupplyTestResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RunExtDevicePowerSupplyTestResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RunExtDevicePowerSupplyTestResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pwrSupplyID"

    static const int kPwrSupplyID = 0;

    /**
     * Clears the field "pwrSupplyID".
     *
     * The field will be set to its default value. The hasPwrSupplyID()
     * method will return false.
     */
    inline void clearPwrSupplyID();

    /**
     * Checks whether the field "pwrSupplyID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPwrSupplyID()). Otherwise it will return false.
     */
    inline bool hasPwrSupplyID () const;

    /**
     * Returns the value of the member "pwrSupplyID".
     *
     * If the meaning of "pwrSupplyID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pwrSupplyID"
     */
    inline uint16 getPwrSupplyID () const;

    /**
     * Sets the value of the member "pwrSupplyID".
     *
     * If the meaning of "pwrSupplyID" isn't clear, then there should be a description here.
     *
     * @param pwrSupplyID The value which will be set
     */
    inline void setPwrSupplyID (uint16 pwrSupplyID_);

    // API of field "status"

    static const int kStatus = 1;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline ::rvc_cca_fi_types::T_e8_Camera_PowerSupplyStatus getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (::rvc_cca_fi_types::T_e8_Camera_PowerSupplyStatus status_);

    // API of field "current"

    static const int kCurrent = 2;

    /**
     * Clears the field "current".
     *
     * The field will be set to its default value. The hasCurrent()
     * method will return false.
     */
    inline void clearCurrent();

    /**
     * Checks whether the field "current" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrent()). Otherwise it will return false.
     */
    inline bool hasCurrent () const;

    /**
     * Returns the value of the member "current".
     *
     * If the meaning of "current" isn't clear, then there should be a description here.
     *
     * @return The value of the field "current"
     */
    inline uint32 getCurrent () const;

    /**
     * Sets the value of the member "current".
     *
     * If the meaning of "current" isn't clear, then there should be a description here.
     *
     * @param current The value which will be set
     */
    inline void setCurrent (uint32 current_);

    static const RunExtDevicePowerSupplyTestResult &getDefaultInstance();

private:

    inline void set_has_pwrSupplyID ();

    inline void clear_has_pwrSupplyID ();

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_current ();

    inline void clear_has_current ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _pwrSupplyID;

    ::rvc_cca_fi_types::T_e8_Camera_PowerSupplyStatus _status;

    uint32 _current;

};

/**
 * The start message of the method "Initialize"
 */
class InitializeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InitializeStart ();

    /**
     * Copy constructor
     */
    inline  InitializeStart (const InitializeStart &rhs);

    /**
     * All fields constructor
     */
    inline  InitializeStart (::rvc_cca_fi_types::T_e8_RVC_Module e8Module_);

    /**
     * Destructor
     */
    inline virtual  ~InitializeStart();

    /**
     * Assignment operator
     */
    inline InitializeStart& operator = (const InitializeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InitializeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InitializeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InitializeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InitializeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Module"

    static const int kE8Module = 0;

    /**
     * Clears the field "e8Module".
     *
     * The field will be set to its default value. The hasE8Module()
     * method will return false.
     */
    inline void clearE8Module();

    /**
     * Checks whether the field "e8Module" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Module()). Otherwise it will return false.
     */
    inline bool hasE8Module () const;

    /**
     * Returns the value of the member "e8Module".
     *
     * <p>Module (part odf the component) to (re)initialize</p>
     *
     * @return The value of the field "e8Module"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_Module getE8Module () const;

    /**
     * Sets the value of the member "e8Module".
     *
     * <p>Module (part odf the component) to (re)initialize</p>
     *
     * @param e8Module The value which will be set
     */
    inline void setE8Module (::rvc_cca_fi_types::T_e8_RVC_Module e8Module_);

    static const InitializeStart &getDefaultInstance();

private:

    inline void set_has_e8Module ();

    inline void clear_has_e8Module ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_Module _e8Module;

};

/**
 * The result message of the method "Initialize"
 */
class InitializeResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InitializeResult ();

    /**
     * Copy constructor
     */
    inline  InitializeResult (const InitializeResult &rhs);

    /**
     * All fields constructor
     */
    inline  InitializeResult (bool Result_);

    /**
     * Destructor
     */
    inline virtual  ~InitializeResult();

    /**
     * Assignment operator
     */
    inline InitializeResult& operator = (const InitializeResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InitializeResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InitializeResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InitializeResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InitializeResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * True: the initalization was successful
     * <p>False: the initialization was not successful</p>
     *
     * @return The value of the field "Result"
     */
    inline bool getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * True: the initalization was successful
     * <p>False: the initialization was not successful</p>
     *
     * @param Result The value which will be set
     */
    inline void setResult (bool Result_);

    static const InitializeResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Result;

};

/**
 * The start message of the method "ConfirmSystemStatus"
 */
class ConfirmSystemStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConfirmSystemStatusStart ();

    /**
     * Copy constructor
     */
    inline  ConfirmSystemStatusStart (const ConfirmSystemStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  ConfirmSystemStatusStart (::rvc_cca_fi_types::T_e8_RVC_SystemStatus e8SystemStatus_);

    /**
     * Destructor
     */
    inline virtual  ~ConfirmSystemStatusStart();

    /**
     * Assignment operator
     */
    inline ConfirmSystemStatusStart& operator = (const ConfirmSystemStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConfirmSystemStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConfirmSystemStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConfirmSystemStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConfirmSystemStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8SystemStatus"

    static const int kE8SystemStatus = 0;

    /**
     * Clears the field "e8SystemStatus".
     *
     * The field will be set to its default value. The hasE8SystemStatus()
     * method will return false.
     */
    inline void clearE8SystemStatus();

    /**
     * Checks whether the field "e8SystemStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SystemStatus()). Otherwise it will return false.
     */
    inline bool hasE8SystemStatus () const;

    /**
     * Returns the value of the member "e8SystemStatus".
     *
     * <p>Confirm system status after each system status change.</p>
     *
     * @return The value of the field "e8SystemStatus"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_SystemStatus getE8SystemStatus () const;

    /**
     * Sets the value of the member "e8SystemStatus".
     *
     * <p>Confirm system status after each system status change.</p>
     *
     * @param e8SystemStatus The value which will be set
     */
    inline void setE8SystemStatus (::rvc_cca_fi_types::T_e8_RVC_SystemStatus e8SystemStatus_);

    static const ConfirmSystemStatusStart &getDefaultInstance();

private:

    inline void set_has_e8SystemStatus ();

    inline void clear_has_e8SystemStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_SystemStatus _e8SystemStatus;

};

/**
 * The result message of the method "ConfirmSystemStatus"
 */
class ConfirmSystemStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConfirmSystemStatusResult ();

    /**
     * Copy constructor
     */
    inline  ConfirmSystemStatusResult (const ConfirmSystemStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  ConfirmSystemStatusResult (bool Result_);

    /**
     * Destructor
     */
    inline virtual  ~ConfirmSystemStatusResult();

    /**
     * Assignment operator
     */
    inline ConfirmSystemStatusResult& operator = (const ConfirmSystemStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConfirmSystemStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConfirmSystemStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConfirmSystemStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConfirmSystemStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * True: the confirmation was successful
     * <p>False: the confirmation was not successful</p>
     *
     * @return The value of the field "Result"
     */
    inline bool getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * True: the confirmation was successful
     * <p>False: the confirmation was not successful</p>
     *
     * @param Result The value which will be set
     */
    inline void setResult (bool Result_);

    static const ConfirmSystemStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Result;

};

/**
 * The start message of the method "SetupUserConfiguration"
 * This method is to inform the Park Assist component about user setup.
 * This method has to be called by HMI once after system start up and in case of a change of the setup done by the user.
 * On start up  the list should be filled with all relevant parameter. Later on an user change, only the current modified list entry must be filled.
 * <p>FUNCID = RVC_CCAFI_C_U16_SETUPUSERCONFIGURATION</p>
 */
class SetupUserConfigurationStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetupUserConfigurationStart ();

    /**
     * Copy constructor
     */
    inline  SetupUserConfigurationStart (const SetupUserConfigurationStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetupUserConfigurationStart (const ::std::vector< ::rvc_cca_fi_types::T_ParkAssist_UserConfiguration >& arUserConfiguration_);

    /**
     * Destructor
     */
    inline virtual  ~SetupUserConfigurationStart();

    /**
     * Assignment operator
     */
    inline SetupUserConfigurationStart& operator = (const SetupUserConfigurationStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetupUserConfigurationStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetupUserConfigurationStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetupUserConfigurationStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetupUserConfigurationStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arUserConfiguration"

    static const int kArUserConfiguration = 0;

    /**
     * Clears the field "arUserConfiguration".
     *
     * The field will be set to its default value. The hasArUserConfiguration()
     * method will return false.
     */
    inline void clearArUserConfiguration();

    /**
     * Checks whether the field "arUserConfiguration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArUserConfiguration()). Otherwise it will return false.
     */
    inline bool hasArUserConfiguration () const;

    /**
     * Returns the value of the member "arUserConfiguration".
     *
     * List with user configuration(s) (e.g. Guideline visibility).
     *
     * @return The value of the field "arUserConfiguration"
     */
    inline const ::std::vector< ::rvc_cca_fi_types::T_ParkAssist_UserConfiguration >& getArUserConfiguration () const;

    /**
     * Retrieves the value of the field "arUserConfiguration" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arUserConfiguration".
     */
    inline ::std::vector< ::rvc_cca_fi_types::T_ParkAssist_UserConfiguration >& getArUserConfigurationMutable ();

    /**
     * Sets the value of the member "arUserConfiguration".
     *
     * List with user configuration(s) (e.g. Guideline visibility).
     *
     * @param arUserConfiguration The value which will be set
     */
    inline void setArUserConfiguration (const ::std::vector< ::rvc_cca_fi_types::T_ParkAssist_UserConfiguration >& arUserConfiguration_);

    static const SetupUserConfigurationStart &getDefaultInstance();

private:

    static const ::std::vector< ::rvc_cca_fi_types::T_ParkAssist_UserConfiguration >& getT_ParkAssist_UserConfigurationList_DefaultInstance ();

    inline void set_has_arUserConfiguration ();

    inline void clear_has_arUserConfiguration ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::rvc_cca_fi_types::T_ParkAssist_UserConfiguration > _arUserConfiguration;

};

/**
 * The result message of the method "SetupUserConfiguration"
 * This method is to inform the Park Assist component about user setup.
 * This method has to be called by HMI once after system start up and in case of a change of the setup done by the user.
 * On start up  the list should be filled with all relevant parameter. Later on an user change, only the current modified list entry must be filled.
 * <p>FUNCID = RVC_CCAFI_C_U16_SETUPUSERCONFIGURATION</p>
 */
class SetupUserConfigurationResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetupUserConfigurationResult ();

    /**
     * Copy constructor
     */
    inline  SetupUserConfigurationResult (const SetupUserConfigurationResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetupUserConfigurationResult (bool Result_);

    /**
     * Destructor
     */
    inline virtual  ~SetupUserConfigurationResult();

    /**
     * Assignment operator
     */
    inline SetupUserConfigurationResult& operator = (const SetupUserConfigurationResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetupUserConfigurationResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetupUserConfigurationResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetupUserConfigurationResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetupUserConfigurationResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @return The value of the field "Result"
     */
    inline bool getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @param Result The value which will be set
     */
    inline void setResult (bool Result_);

    static const SetupUserConfigurationResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Result;

};

/**
 * The error message of 'SetupUserConfiguration'
 */
class SetupUserConfigurationErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetupUserConfigurationErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetupUserConfigurationErrorStructure (const SetupUserConfigurationErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetupUserConfigurationErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SetupUserConfigurationErrorStructure();

    /**
     * Assignment operator
     */
    inline SetupUserConfigurationErrorStructure& operator = (const SetupUserConfigurationErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetupUserConfigurationErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetupUserConfigurationErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetupUserConfigurationErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetupUserConfigurationErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Error codes
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Error codes
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const SetupUserConfigurationErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'SetupUserConfiguration'
 */
class SetupUserConfigurationError  : public ::asf::core::Payload {
public:

    enum SetupUserConfigurationErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetupUserConfigurationError ();

   /**
     * Copy constructor
     */
    inline  SetupUserConfigurationError (const SetupUserConfigurationError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetupUserConfigurationError();

    /**
     * Assigns a new value to this object.
     */
    inline SetupUserConfigurationError& operator = (const SetupUserConfigurationError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetupUserConfigurationError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetupUserConfigurationError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetupUserConfigurationError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetupUserConfigurationError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetupUserConfigurationError::SetupUserConfigurationErrorField getField () const;

    inline void setField(SetupUserConfigurationError::SetupUserConfigurationErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetupUserConfigurationErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetupUserConfigurationErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetupUserConfigurationErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetupUserConfigurationErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetupUserConfigurationErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetupUserConfigurationErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetupUserConfigurationErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetupUserConfigurationErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetupUserConfigurationError &getDefaultInstance();

private:

    inline void cloneData (const SetupUserConfigurationError& rhs);

    inline void deleteData ();

    SetupUserConfigurationErrorField __field;

    union {
        SetupUserConfigurationErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetMicrophoneState"
 * <p>Switches the Microphone state ON/OFF via ELMOS IC</p>
 */
class SetMicrophoneStateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetMicrophoneStateStart ();

    /**
     * Copy constructor
     */
    inline  SetMicrophoneStateStart (const SetMicrophoneStateStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetMicrophoneStateStart (::rvc_cca_fi_types::T_e8_Set_MicState e8RequestState_);

    /**
     * Destructor
     */
    inline virtual  ~SetMicrophoneStateStart();

    /**
     * Assignment operator
     */
    inline SetMicrophoneStateStart& operator = (const SetMicrophoneStateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetMicrophoneStateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetMicrophoneStateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetMicrophoneStateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetMicrophoneStateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8RequestState"

    static const int kE8RequestState = 0;

    /**
     * Clears the field "e8RequestState".
     *
     * The field will be set to its default value. The hasE8RequestState()
     * method will return false.
     */
    inline void clearE8RequestState();

    /**
     * Checks whether the field "e8RequestState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8RequestState()). Otherwise it will return false.
     */
    inline bool hasE8RequestState () const;

    /**
     * Returns the value of the member "e8RequestState".
     *
     * Microphone new State request
     *
     * @return The value of the field "e8RequestState"
     */
    inline ::rvc_cca_fi_types::T_e8_Set_MicState getE8RequestState () const;

    /**
     * Sets the value of the member "e8RequestState".
     *
     * Microphone new State request
     *
     * @param e8RequestState The value which will be set
     */
    inline void setE8RequestState (::rvc_cca_fi_types::T_e8_Set_MicState e8RequestState_);

    static const SetMicrophoneStateStart &getDefaultInstance();

private:

    inline void set_has_e8RequestState ();

    inline void clear_has_e8RequestState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_Set_MicState _e8RequestState;

};

/**
 * The result message of the method "SetMicrophoneState"
 * <p>Switches the Microphone state ON/OFF via ELMOS IC</p>
 */
class SetMicrophoneStateResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetMicrophoneStateResult ();

    /**
     * Copy constructor
     */
    inline  SetMicrophoneStateResult (const SetMicrophoneStateResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetMicrophoneStateResult (bool Result_);

    /**
     * Destructor
     */
    inline virtual  ~SetMicrophoneStateResult();

    /**
     * Assignment operator
     */
    inline SetMicrophoneStateResult& operator = (const SetMicrophoneStateResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetMicrophoneStateResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetMicrophoneStateResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetMicrophoneStateResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetMicrophoneStateResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @return The value of the field "Result"
     */
    inline bool getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @param Result The value which will be set
     */
    inline void setResult (bool Result_);

    static const SetMicrophoneStateResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Result;

};

/**
 * The error message of 'SetMicrophoneState'
 */
class SetMicrophoneStateErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetMicrophoneStateErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetMicrophoneStateErrorStructure (const SetMicrophoneStateErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetMicrophoneStateErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SetMicrophoneStateErrorStructure();

    /**
     * Assignment operator
     */
    inline SetMicrophoneStateErrorStructure& operator = (const SetMicrophoneStateErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetMicrophoneStateErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetMicrophoneStateErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetMicrophoneStateErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetMicrophoneStateErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    static const SetMicrophoneStateErrorStructure &getDefaultInstance();

private:

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _e8ErrorCode;

};

/**
 * The error message of 'SetMicrophoneState'
 */
class SetMicrophoneStateError  : public ::asf::core::Payload {
public:

    enum SetMicrophoneStateErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetMicrophoneStateError ();

   /**
     * Copy constructor
     */
    inline  SetMicrophoneStateError (const SetMicrophoneStateError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetMicrophoneStateError();

    /**
     * Assigns a new value to this object.
     */
    inline SetMicrophoneStateError& operator = (const SetMicrophoneStateError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetMicrophoneStateError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetMicrophoneStateError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetMicrophoneStateError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetMicrophoneStateError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetMicrophoneStateError::SetMicrophoneStateErrorField getField () const;

    inline void setField(SetMicrophoneStateError::SetMicrophoneStateErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetMicrophoneStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetMicrophoneStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetMicrophoneStateErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetMicrophoneStateErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetMicrophoneStateErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetMicrophoneStateErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetMicrophoneStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetMicrophoneStateErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetMicrophoneStateError &getDefaultInstance();

private:

    inline void cloneData (const SetMicrophoneStateError& rhs);

    inline void deleteData ();

    SetMicrophoneStateErrorField __field;

    union {
        SetMicrophoneStateErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetRVCStatus"
 * <p>HMI could set the RVC Status</p>
 */
class SetRVCStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetRVCStatusStart ();

    /**
     * Copy constructor
     */
    inline  SetRVCStatusStart (const SetRVCStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetRVCStatusStart (uint8 e8RequestState_);

    /**
     * Destructor
     */
    inline virtual  ~SetRVCStatusStart();

    /**
     * Assignment operator
     */
    inline SetRVCStatusStart& operator = (const SetRVCStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetRVCStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetRVCStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetRVCStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetRVCStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8RequestState"

    static const int kE8RequestState = 0;

    /**
     * Clears the field "e8RequestState".
     *
     * The field will be set to its default value. The hasE8RequestState()
     * method will return false.
     */
    inline void clearE8RequestState();

    /**
     * Checks whether the field "e8RequestState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8RequestState()). Otherwise it will return false.
     */
    inline bool hasE8RequestState () const;

    /**
     * Returns the value of the member "e8RequestState".
     *
     * RVC new State request
     *
     * @return The value of the field "e8RequestState"
     */
    inline uint8 getE8RequestState () const;

    /**
     * Sets the value of the member "e8RequestState".
     *
     * RVC new State request
     *
     * @param e8RequestState The value which will be set
     */
    inline void setE8RequestState (uint8 e8RequestState_);

    static const SetRVCStatusStart &getDefaultInstance();

private:

    inline void set_has_e8RequestState ();

    inline void clear_has_e8RequestState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _e8RequestState;

};

/**
 * The result message of the method "SetRVCStatus"
 * <p>HMI could set the RVC Status</p>
 */
class SetRVCStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetRVCStatusResult ();

    /**
     * Copy constructor
     */
    inline  SetRVCStatusResult (const SetRVCStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetRVCStatusResult (bool Result_);

    /**
     * Destructor
     */
    inline virtual  ~SetRVCStatusResult();

    /**
     * Assignment operator
     */
    inline SetRVCStatusResult& operator = (const SetRVCStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetRVCStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetRVCStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetRVCStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetRVCStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @return The value of the field "Result"
     */
    inline bool getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @param Result The value which will be set
     */
    inline void setResult (bool Result_);

    static const SetRVCStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Result;

};

/**
 * The error message of 'SetRVCStatus'
 */
class SetRVCStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetRVCStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetRVCStatusErrorStructure (const SetRVCStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetRVCStatusErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SetRVCStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline SetRVCStatusErrorStructure& operator = (const SetRVCStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetRVCStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetRVCStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetRVCStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetRVCStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    static const SetRVCStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _e8ErrorCode;

};

/**
 * The error message of 'SetRVCStatus'
 */
class SetRVCStatusError  : public ::asf::core::Payload {
public:

    enum SetRVCStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetRVCStatusError ();

   /**
     * Copy constructor
     */
    inline  SetRVCStatusError (const SetRVCStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetRVCStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline SetRVCStatusError& operator = (const SetRVCStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetRVCStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetRVCStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetRVCStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetRVCStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetRVCStatusError::SetRVCStatusErrorField getField () const;

    inline void setField(SetRVCStatusError::SetRVCStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetRVCStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetRVCStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetRVCStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetRVCStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetRVCStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetRVCStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetRVCStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetRVCStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetRVCStatusError &getDefaultInstance();

private:

    inline void cloneData (const SetRVCStatusError& rhs);

    inline void deleteData ();

    SetRVCStatusErrorField __field;

    union {
        SetRVCStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "Camera_SetupBeep"
 * <p>FUNCID = RVC_CCAFI_C_U16_SETUPBEEP</p>
 */
class Camera_SetupBeepStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Camera_SetupBeepStart ();

    /**
     * Copy constructor
     */
    inline  Camera_SetupBeepStart (const Camera_SetupBeepStart &rhs);

    /**
     * All fields constructor
     */
    inline  Camera_SetupBeepStart (::rvc_cca_fi_types::T_e8_AVM_StatusBeep e8SetupBeep_);

    /**
     * Destructor
     */
    inline virtual  ~Camera_SetupBeepStart();

    /**
     * Assignment operator
     */
    inline Camera_SetupBeepStart& operator = (const Camera_SetupBeepStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Camera_SetupBeepStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Camera_SetupBeepStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Camera_SetupBeepStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Camera_SetupBeepStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8SetupBeep"

    static const int kE8SetupBeep = 0;

    /**
     * Clears the field "e8SetupBeep".
     *
     * The field will be set to its default value. The hasE8SetupBeep()
     * method will return false.
     */
    inline void clearE8SetupBeep();

    /**
     * Checks whether the field "e8SetupBeep" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SetupBeep()). Otherwise it will return false.
     */
    inline bool hasE8SetupBeep () const;

    /**
     * Returns the value of the member "e8SetupBeep".
     *
     * Activate or deactivate the AVM beeps.
     *
     * @return The value of the field "e8SetupBeep"
     */
    inline ::rvc_cca_fi_types::T_e8_AVM_StatusBeep getE8SetupBeep () const;

    /**
     * Sets the value of the member "e8SetupBeep".
     *
     * Activate or deactivate the AVM beeps.
     *
     * @param e8SetupBeep The value which will be set
     */
    inline void setE8SetupBeep (::rvc_cca_fi_types::T_e8_AVM_StatusBeep e8SetupBeep_);

    static const Camera_SetupBeepStart &getDefaultInstance();

private:

    inline void set_has_e8SetupBeep ();

    inline void clear_has_e8SetupBeep ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_AVM_StatusBeep _e8SetupBeep;

};

/**
 * The result message of the method "Camera_SetupBeep"
 * <p>FUNCID = RVC_CCAFI_C_U16_SETUPBEEP</p>
 */
class Camera_SetupBeepResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Camera_SetupBeepResult ();

    /**
     * Copy constructor
     */
    inline  Camera_SetupBeepResult (const Camera_SetupBeepResult &rhs);

    /**
     * All fields constructor
     */
    inline  Camera_SetupBeepResult (::rvc_cca_fi_types::T_e8_AVM_StatusBeep e8StatusBeep_);

    /**
     * Destructor
     */
    inline virtual  ~Camera_SetupBeepResult();

    /**
     * Assignment operator
     */
    inline Camera_SetupBeepResult& operator = (const Camera_SetupBeepResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Camera_SetupBeepResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Camera_SetupBeepResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Camera_SetupBeepResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Camera_SetupBeepResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8StatusBeep"

    static const int kE8StatusBeep = 0;

    /**
     * Clears the field "e8StatusBeep".
     *
     * The field will be set to its default value. The hasE8StatusBeep()
     * method will return false.
     */
    inline void clearE8StatusBeep();

    /**
     * Checks whether the field "e8StatusBeep" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8StatusBeep()). Otherwise it will return false.
     */
    inline bool hasE8StatusBeep () const;

    /**
     * Returns the value of the member "e8StatusBeep".
     *
     * Information about activated or deactivated beep types.
     *
     * @return The value of the field "e8StatusBeep"
     */
    inline ::rvc_cca_fi_types::T_e8_AVM_StatusBeep getE8StatusBeep () const;

    /**
     * Sets the value of the member "e8StatusBeep".
     *
     * Information about activated or deactivated beep types.
     *
     * @param e8StatusBeep The value which will be set
     */
    inline void setE8StatusBeep (::rvc_cca_fi_types::T_e8_AVM_StatusBeep e8StatusBeep_);

    static const Camera_SetupBeepResult &getDefaultInstance();

private:

    inline void set_has_e8StatusBeep ();

    inline void clear_has_e8StatusBeep ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_AVM_StatusBeep _e8StatusBeep;

};

/**
 * The error message of 'Camera_SetupBeep'
 */
class Camera_SetupBeepErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  Camera_SetupBeepErrorStructure ();

    /**
     * Copy constructor
     */
    inline  Camera_SetupBeepErrorStructure (const Camera_SetupBeepErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  Camera_SetupBeepErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~Camera_SetupBeepErrorStructure();

    /**
     * Assignment operator
     */
    inline Camera_SetupBeepErrorStructure& operator = (const Camera_SetupBeepErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Camera_SetupBeepErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Camera_SetupBeepErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Camera_SetupBeepErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Camera_SetupBeepErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    static const Camera_SetupBeepErrorStructure &getDefaultInstance();

private:

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _e8ErrorCode;

};

/**
 * The error message of 'Camera_SetupBeep'
 */
class Camera_SetupBeepError  : public ::asf::core::Payload {
public:

    enum Camera_SetupBeepErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  Camera_SetupBeepError ();

   /**
     * Copy constructor
     */
    inline  Camera_SetupBeepError (const Camera_SetupBeepError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~Camera_SetupBeepError();

    /**
     * Assigns a new value to this object.
     */
    inline Camera_SetupBeepError& operator = (const Camera_SetupBeepError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Camera_SetupBeepError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Camera_SetupBeepError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Camera_SetupBeepError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Camera_SetupBeepError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline Camera_SetupBeepError::Camera_SetupBeepErrorField getField () const;

    inline void setField(Camera_SetupBeepError::Camera_SetupBeepErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "Camera_SetupBeepErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "Camera_SetupBeepErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const Camera_SetupBeepErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline Camera_SetupBeepErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline Camera_SetupBeepErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (Camera_SetupBeepErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "Camera_SetupBeepErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const Camera_SetupBeepErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const Camera_SetupBeepError &getDefaultInstance();

private:

    inline void cloneData (const Camera_SetupBeepError& rhs);

    inline void deleteData ();

    Camera_SetupBeepErrorField __field;

    union {
        Camera_SetupBeepErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "SetCamerastate"
 * <p>FUNCID = RVC_CCAFI_C_U16_SETCAMERASTATE</p>
 */
class SetCamerastateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetCamerastateStart ();

    /**
     * Copy constructor
     */
    inline  SetCamerastateStart (const SetCamerastateStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetCamerastateStart (::rvc_cca_fi_types::T_e8_RVC_CameraState CameraState_);

    /**
     * Destructor
     */
    inline virtual  ~SetCamerastateStart();

    /**
     * Assignment operator
     */
    inline SetCamerastateStart& operator = (const SetCamerastateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetCamerastateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetCamerastateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetCamerastateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetCamerastateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CameraState"

    static const int kCameraState = 0;

    /**
     * Clears the field "CameraState".
     *
     * The field will be set to its default value. The hasCameraState()
     * method will return false.
     */
    inline void clearCameraState();

    /**
     * Checks whether the field "CameraState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCameraState()). Otherwise it will return false.
     */
    inline bool hasCameraState () const;

    /**
     * Returns the value of the member "CameraState".
     *
     * New state into RVC shall be brought.
     *
     * @return The value of the field "CameraState"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CameraState getCameraState () const;

    /**
     * Sets the value of the member "CameraState".
     *
     * New state into RVC shall be brought.
     *
     * @param CameraState The value which will be set
     */
    inline void setCameraState (::rvc_cca_fi_types::T_e8_RVC_CameraState CameraState_);

    static const SetCamerastateStart &getDefaultInstance();

private:

    inline void set_has_CameraState ();

    inline void clear_has_CameraState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CameraState _CameraState;

};

/**
 * The result message of the method "SetCamerastate"
 * <p>FUNCID = RVC_CCAFI_C_U16_SETCAMERASTATE</p>
 */
class SetCamerastateResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetCamerastateResult ();

    /**
     * Copy constructor
     */
    inline  SetCamerastateResult (const SetCamerastateResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetCamerastateResult (bool Result_);

    /**
     * Destructor
     */
    inline virtual  ~SetCamerastateResult();

    /**
     * Assignment operator
     */
    inline SetCamerastateResult& operator = (const SetCamerastateResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetCamerastateResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetCamerastateResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetCamerastateResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetCamerastateResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * True : the  method was successful,
     * <p>False, method was not successful</p>
     *
     * @return The value of the field "Result"
     */
    inline bool getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * True : the  method was successful,
     * <p>False, method was not successful</p>
     *
     * @param Result The value which will be set
     */
    inline void setResult (bool Result_);

    static const SetCamerastateResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Result;

};

/**
 * The error message of 'SetCamerastate'
 */
class SetCamerastateErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  SetCamerastateErrorStructure ();

    /**
     * Copy constructor
     */
    inline  SetCamerastateErrorStructure (const SetCamerastateErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  SetCamerastateErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    /**
     * Destructor
     */
    inline  ~SetCamerastateErrorStructure();

    /**
     * Assignment operator
     */
    inline SetCamerastateErrorStructure& operator = (const SetCamerastateErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetCamerastateErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetCamerastateErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetCamerastateErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetCamerastateErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Error codes
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Error codes
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError ErrorCode_);

    static const SetCamerastateErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _ErrorCode;

};

/**
 * The error message of 'SetCamerastate'
 */
class SetCamerastateError  : public ::asf::core::Payload {
public:

    enum SetCamerastateErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  SetCamerastateError ();

   /**
     * Copy constructor
     */
    inline  SetCamerastateError (const SetCamerastateError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~SetCamerastateError();

    /**
     * Assigns a new value to this object.
     */
    inline SetCamerastateError& operator = (const SetCamerastateError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetCamerastateError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetCamerastateError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetCamerastateError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetCamerastateError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline SetCamerastateError::SetCamerastateErrorField getField () const;

    inline void setField(SetCamerastateError::SetCamerastateErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "SetCamerastateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "SetCamerastateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SetCamerastateErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SetCamerastateErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline SetCamerastateErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (SetCamerastateErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "SetCamerastateErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const SetCamerastateErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const SetCamerastateError &getDefaultInstance();

private:

    inline void cloneData (const SetCamerastateError& rhs);

    inline void deleteData ();

    SetCamerastateErrorField __field;

    union {
        SetCamerastateErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "ChangeViewRequest"
 * This method has to be called by HMI to request a change in AVM View
 * <p>FUNCID = RVC_CCAFI_C_U16_CHANGE_VIEW_REQUEST</p>
 */
class ChangeViewRequestStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeViewRequestStart ();

    /**
     * Copy constructor
     */
    inline  ChangeViewRequestStart (const ChangeViewRequestStart &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeViewRequestStart (::rvc_cca_fi_types::T_e8_AVM_View_Request u8Status_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeViewRequestStart();

    /**
     * Assignment operator
     */
    inline ChangeViewRequestStart& operator = (const ChangeViewRequestStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeViewRequestStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeViewRequestStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeViewRequestStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeViewRequestStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Status"

    static const int kU8Status = 0;

    /**
     * Clears the field "u8Status".
     *
     * The field will be set to its default value. The hasU8Status()
     * method will return false.
     */
    inline void clearU8Status();

    /**
     * Checks whether the field "u8Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Status()). Otherwise it will return false.
     */
    inline bool hasU8Status () const;

    /**
     * Returns the value of the member "u8Status".
     *
     * HMI should request the view selected by the User on HMI buttons.
     *
     * @return The value of the field "u8Status"
     */
    inline ::rvc_cca_fi_types::T_e8_AVM_View_Request getU8Status () const;

    /**
     * Sets the value of the member "u8Status".
     *
     * HMI should request the view selected by the User on HMI buttons.
     *
     * @param u8Status The value which will be set
     */
    inline void setU8Status (::rvc_cca_fi_types::T_e8_AVM_View_Request u8Status_);

    static const ChangeViewRequestStart &getDefaultInstance();

private:

    inline void set_has_u8Status ();

    inline void clear_has_u8Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_AVM_View_Request _u8Status;

};

/**
 * The result message of the method "ChangeViewRequest"
 * This method has to be called by HMI to request a change in AVM View
 * <p>FUNCID = RVC_CCAFI_C_U16_CHANGE_VIEW_REQUEST</p>
 */
class ChangeViewRequestResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeViewRequestResult ();

    /**
     * Copy constructor
     */
    inline  ChangeViewRequestResult (const ChangeViewRequestResult &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeViewRequestResult (bool Result_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeViewRequestResult();

    /**
     * Assignment operator
     */
    inline ChangeViewRequestResult& operator = (const ChangeViewRequestResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeViewRequestResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeViewRequestResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeViewRequestResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeViewRequestResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @return The value of the field "Result"
     */
    inline bool getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @param Result The value which will be set
     */
    inline void setResult (bool Result_);

    static const ChangeViewRequestResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Result;

};

/**
 * The error message of 'ChangeViewRequest'
 */
class ChangeViewRequestErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  ChangeViewRequestErrorStructure ();

    /**
     * Copy constructor
     */
    inline  ChangeViewRequestErrorStructure (const ChangeViewRequestErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeViewRequestErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~ChangeViewRequestErrorStructure();

    /**
     * Assignment operator
     */
    inline ChangeViewRequestErrorStructure& operator = (const ChangeViewRequestErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeViewRequestErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeViewRequestErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeViewRequestErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeViewRequestErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    static const ChangeViewRequestErrorStructure &getDefaultInstance();

private:

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _e8ErrorCode;

};

/**
 * The error message of 'ChangeViewRequest'
 */
class ChangeViewRequestError  : public ::asf::core::Payload {
public:

    enum ChangeViewRequestErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  ChangeViewRequestError ();

   /**
     * Copy constructor
     */
    inline  ChangeViewRequestError (const ChangeViewRequestError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~ChangeViewRequestError();

    /**
     * Assigns a new value to this object.
     */
    inline ChangeViewRequestError& operator = (const ChangeViewRequestError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeViewRequestError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeViewRequestError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeViewRequestError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeViewRequestError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline ChangeViewRequestError::ChangeViewRequestErrorField getField () const;

    inline void setField(ChangeViewRequestError::ChangeViewRequestErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "ChangeViewRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "ChangeViewRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ChangeViewRequestErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ChangeViewRequestErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline ChangeViewRequestErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (ChangeViewRequestErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "ChangeViewRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const ChangeViewRequestErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const ChangeViewRequestError &getDefaultInstance();

private:

    inline void cloneData (const ChangeViewRequestError& rhs);

    inline void deleteData ();

    ChangeViewRequestErrorField __field;

    union {
        ChangeViewRequestErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "Affordable_Its_SetupBsw"
 * This method has to be called by HMI to inform about a change in configuration for the Blind Spot Warning feature.
 * <p>FUNCID = RVC_CCAFI_C_U16_AFFORDABLE_ITS_SETUPBSW</p>
 */
class Affordable_Its_SetupBswStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Affordable_Its_SetupBswStart ();

    /**
     * Copy constructor
     */
    inline  Affordable_Its_SetupBswStart (const Affordable_Its_SetupBswStart &rhs);

    /**
     * All fields constructor
     */
    inline  Affordable_Its_SetupBswStart (uint8 u8Status_);

    /**
     * Destructor
     */
    inline virtual  ~Affordable_Its_SetupBswStart();

    /**
     * Assignment operator
     */
    inline Affordable_Its_SetupBswStart& operator = (const Affordable_Its_SetupBswStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Affordable_Its_SetupBswStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Affordable_Its_SetupBswStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Affordable_Its_SetupBswStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Affordable_Its_SetupBswStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Status"

    static const int kU8Status = 0;

    /**
     * Clears the field "u8Status".
     *
     * The field will be set to its default value. The hasU8Status()
     * method will return false.
     */
    inline void clearU8Status();

    /**
     * Checks whether the field "u8Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Status()). Otherwise it will return false.
     */
    inline bool hasU8Status () const;

    /**
     * Returns the value of the member "u8Status".
     *
     * Depending on the required implementation the values have following meaning:
     * <p>Implementation variant 1:</p>
     * <p>0 = BSW configuration no change request</p>
     * <p>1 = BSW configuration change request</p>
     * <p>The property Affordable_ITS reflects the current Affordable ITS configuration.</p>
     * <p></p>
     * <p>Implementation variant 2:</p>
     * <p>0 = BSW configuration change to off</p>
     * <p>1 = BSW configuration change to on</p>
     *
     * @return The value of the field "u8Status"
     */
    inline uint8 getU8Status () const;

    /**
     * Sets the value of the member "u8Status".
     *
     * Depending on the required implementation the values have following meaning:
     * <p>Implementation variant 1:</p>
     * <p>0 = BSW configuration no change request</p>
     * <p>1 = BSW configuration change request</p>
     * <p>The property Affordable_ITS reflects the current Affordable ITS configuration.</p>
     * <p></p>
     * <p>Implementation variant 2:</p>
     * <p>0 = BSW configuration change to off</p>
     * <p>1 = BSW configuration change to on</p>
     *
     * @param u8Status The value which will be set
     */
    inline void setU8Status (uint8 u8Status_);

    static const Affordable_Its_SetupBswStart &getDefaultInstance();

private:

    inline void set_has_u8Status ();

    inline void clear_has_u8Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8Status;

};

/**
 * The result message of the method "Affordable_Its_SetupBsw"
 * This method has to be called by HMI to inform about a change in configuration for the Blind Spot Warning feature.
 * <p>FUNCID = RVC_CCAFI_C_U16_AFFORDABLE_ITS_SETUPBSW</p>
 */
class Affordable_Its_SetupBswResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Affordable_Its_SetupBswResult ();

    /**
     * Copy constructor
     */
    inline  Affordable_Its_SetupBswResult (const Affordable_Its_SetupBswResult &rhs);

    /**
     * All fields constructor
     */
    inline  Affordable_Its_SetupBswResult (bool Result_);

    /**
     * Destructor
     */
    inline virtual  ~Affordable_Its_SetupBswResult();

    /**
     * Assignment operator
     */
    inline Affordable_Its_SetupBswResult& operator = (const Affordable_Its_SetupBswResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Affordable_Its_SetupBswResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Affordable_Its_SetupBswResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Affordable_Its_SetupBswResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Affordable_Its_SetupBswResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @return The value of the field "Result"
     */
    inline bool getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @param Result The value which will be set
     */
    inline void setResult (bool Result_);

    static const Affordable_Its_SetupBswResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Result;

};

/**
 * The error message of 'Affordable_Its_SetupBsw'
 */
class Affordable_Its_SetupBswErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  Affordable_Its_SetupBswErrorStructure ();

    /**
     * Copy constructor
     */
    inline  Affordable_Its_SetupBswErrorStructure (const Affordable_Its_SetupBswErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  Affordable_Its_SetupBswErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~Affordable_Its_SetupBswErrorStructure();

    /**
     * Assignment operator
     */
    inline Affordable_Its_SetupBswErrorStructure& operator = (const Affordable_Its_SetupBswErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Affordable_Its_SetupBswErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Affordable_Its_SetupBswErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Affordable_Its_SetupBswErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Affordable_Its_SetupBswErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    static const Affordable_Its_SetupBswErrorStructure &getDefaultInstance();

private:

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _e8ErrorCode;

};

/**
 * The error message of 'Affordable_Its_SetupBsw'
 */
class Affordable_Its_SetupBswError  : public ::asf::core::Payload {
public:

    enum Affordable_Its_SetupBswErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  Affordable_Its_SetupBswError ();

   /**
     * Copy constructor
     */
    inline  Affordable_Its_SetupBswError (const Affordable_Its_SetupBswError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~Affordable_Its_SetupBswError();

    /**
     * Assigns a new value to this object.
     */
    inline Affordable_Its_SetupBswError& operator = (const Affordable_Its_SetupBswError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Affordable_Its_SetupBswError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Affordable_Its_SetupBswError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Affordable_Its_SetupBswError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Affordable_Its_SetupBswError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline Affordable_Its_SetupBswError::Affordable_Its_SetupBswErrorField getField () const;

    inline void setField(Affordable_Its_SetupBswError::Affordable_Its_SetupBswErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "Affordable_Its_SetupBswErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "Affordable_Its_SetupBswErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const Affordable_Its_SetupBswErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline Affordable_Its_SetupBswErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline Affordable_Its_SetupBswErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (Affordable_Its_SetupBswErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "Affordable_Its_SetupBswErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const Affordable_Its_SetupBswErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const Affordable_Its_SetupBswError &getDefaultInstance();

private:

    inline void cloneData (const Affordable_Its_SetupBswError& rhs);

    inline void deleteData ();

    Affordable_Its_SetupBswErrorField __field;

    union {
        Affordable_Its_SetupBswErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "Affordable_Its_SetupMod"
 * This method has to be called by HMI to inform about a change in configuration for the Motion Object Detection feature.
 * <p>FUNCID = RVC_CCAFI_C_U16_AFFORDABLE_ITS_SETUPMOD</p>
 */
class Affordable_Its_SetupModStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Affordable_Its_SetupModStart ();

    /**
     * Copy constructor
     */
    inline  Affordable_Its_SetupModStart (const Affordable_Its_SetupModStart &rhs);

    /**
     * All fields constructor
     */
    inline  Affordable_Its_SetupModStart (uint8 u8Status_);

    /**
     * Destructor
     */
    inline virtual  ~Affordable_Its_SetupModStart();

    /**
     * Assignment operator
     */
    inline Affordable_Its_SetupModStart& operator = (const Affordable_Its_SetupModStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Affordable_Its_SetupModStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Affordable_Its_SetupModStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Affordable_Its_SetupModStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Affordable_Its_SetupModStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Status"

    static const int kU8Status = 0;

    /**
     * Clears the field "u8Status".
     *
     * The field will be set to its default value. The hasU8Status()
     * method will return false.
     */
    inline void clearU8Status();

    /**
     * Checks whether the field "u8Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Status()). Otherwise it will return false.
     */
    inline bool hasU8Status () const;

    /**
     * Returns the value of the member "u8Status".
     *
     * Depending on the required implementation the values have following meaning
     * <p>Implementation variant 1:</p>
     * <p>0 = MOD configuration no change request</p>
     * <p>1 = MOD configuration change request</p>
     * <p>The property Affordable_ITS reflects the current Affordable ITS configuration.</p>
     * <p></p>
     * <p>Implementation variant 2:</p>
     * <p>0 = MOD configuration change to off</p>
     * <p>1 = MOD configuration change to on</p>
     *
     * @return The value of the field "u8Status"
     */
    inline uint8 getU8Status () const;

    /**
     * Sets the value of the member "u8Status".
     *
     * Depending on the required implementation the values have following meaning
     * <p>Implementation variant 1:</p>
     * <p>0 = MOD configuration no change request</p>
     * <p>1 = MOD configuration change request</p>
     * <p>The property Affordable_ITS reflects the current Affordable ITS configuration.</p>
     * <p></p>
     * <p>Implementation variant 2:</p>
     * <p>0 = MOD configuration change to off</p>
     * <p>1 = MOD configuration change to on</p>
     *
     * @param u8Status The value which will be set
     */
    inline void setU8Status (uint8 u8Status_);

    static const Affordable_Its_SetupModStart &getDefaultInstance();

private:

    inline void set_has_u8Status ();

    inline void clear_has_u8Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8Status;

};

/**
 * The result message of the method "Affordable_Its_SetupMod"
 * This method has to be called by HMI to inform about a change in configuration for the Motion Object Detection feature.
 * <p>FUNCID = RVC_CCAFI_C_U16_AFFORDABLE_ITS_SETUPMOD</p>
 */
class Affordable_Its_SetupModResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Affordable_Its_SetupModResult ();

    /**
     * Copy constructor
     */
    inline  Affordable_Its_SetupModResult (const Affordable_Its_SetupModResult &rhs);

    /**
     * All fields constructor
     */
    inline  Affordable_Its_SetupModResult (bool Result_);

    /**
     * Destructor
     */
    inline virtual  ~Affordable_Its_SetupModResult();

    /**
     * Assignment operator
     */
    inline Affordable_Its_SetupModResult& operator = (const Affordable_Its_SetupModResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Affordable_Its_SetupModResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Affordable_Its_SetupModResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Affordable_Its_SetupModResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Affordable_Its_SetupModResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @return The value of the field "Result"
     */
    inline bool getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @param Result The value which will be set
     */
    inline void setResult (bool Result_);

    static const Affordable_Its_SetupModResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Result;

};

/**
 * The error message of 'Affordable_Its_SetupMod'
 */
class Affordable_Its_SetupModErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  Affordable_Its_SetupModErrorStructure ();

    /**
     * Copy constructor
     */
    inline  Affordable_Its_SetupModErrorStructure (const Affordable_Its_SetupModErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  Affordable_Its_SetupModErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~Affordable_Its_SetupModErrorStructure();

    /**
     * Assignment operator
     */
    inline Affordable_Its_SetupModErrorStructure& operator = (const Affordable_Its_SetupModErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Affordable_Its_SetupModErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Affordable_Its_SetupModErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Affordable_Its_SetupModErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Affordable_Its_SetupModErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    static const Affordable_Its_SetupModErrorStructure &getDefaultInstance();

private:

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _e8ErrorCode;

};

/**
 * The error message of 'Affordable_Its_SetupMod'
 */
class Affordable_Its_SetupModError  : public ::asf::core::Payload {
public:

    enum Affordable_Its_SetupModErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  Affordable_Its_SetupModError ();

   /**
     * Copy constructor
     */
    inline  Affordable_Its_SetupModError (const Affordable_Its_SetupModError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~Affordable_Its_SetupModError();

    /**
     * Assigns a new value to this object.
     */
    inline Affordable_Its_SetupModError& operator = (const Affordable_Its_SetupModError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Affordable_Its_SetupModError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Affordable_Its_SetupModError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Affordable_Its_SetupModError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Affordable_Its_SetupModError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline Affordable_Its_SetupModError::Affordable_Its_SetupModErrorField getField () const;

    inline void setField(Affordable_Its_SetupModError::Affordable_Its_SetupModErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "Affordable_Its_SetupModErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "Affordable_Its_SetupModErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const Affordable_Its_SetupModErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline Affordable_Its_SetupModErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline Affordable_Its_SetupModErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (Affordable_Its_SetupModErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "Affordable_Its_SetupModErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const Affordable_Its_SetupModErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const Affordable_Its_SetupModError &getDefaultInstance();

private:

    inline void cloneData (const Affordable_Its_SetupModError& rhs);

    inline void deleteData ();

    Affordable_Its_SetupModErrorField __field;

    union {
        Affordable_Its_SetupModErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "Affordable_Its_SetupLdw"
 * This method has to be called by HMI to inform about a change in configuration for the Lane Departure Warning feature.
 * <p>FUNCID = RVC_CCAFI_C_U16_AFFORDABLE_ITS_SETUPLDW</p>
 */
class Affordable_Its_SetupLdwStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Affordable_Its_SetupLdwStart ();

    /**
     * Copy constructor
     */
    inline  Affordable_Its_SetupLdwStart (const Affordable_Its_SetupLdwStart &rhs);

    /**
     * All fields constructor
     */
    inline  Affordable_Its_SetupLdwStart (uint8 u8Status_);

    /**
     * Destructor
     */
    inline virtual  ~Affordable_Its_SetupLdwStart();

    /**
     * Assignment operator
     */
    inline Affordable_Its_SetupLdwStart& operator = (const Affordable_Its_SetupLdwStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Affordable_Its_SetupLdwStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Affordable_Its_SetupLdwStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Affordable_Its_SetupLdwStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Affordable_Its_SetupLdwStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Status"

    static const int kU8Status = 0;

    /**
     * Clears the field "u8Status".
     *
     * The field will be set to its default value. The hasU8Status()
     * method will return false.
     */
    inline void clearU8Status();

    /**
     * Checks whether the field "u8Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Status()). Otherwise it will return false.
     */
    inline bool hasU8Status () const;

    /**
     * Returns the value of the member "u8Status".
     *
     * Depending on the required implementation the values have following meaning
     * <p>Implementation variant 1:</p>
     * <p>0 = LDW configuration no change request</p>
     * <p>1 = LDW configuration change request</p>
     * <p>The property Affordable_ITS reflects the current Affordable ITS configuration.</p>
     * <p></p>
     * <p>Implementation variant 2:</p>
     * <p>0 = LDW configuration change to off</p>
     * <p>1 = LDW configuration change to on</p>
     *
     * @return The value of the field "u8Status"
     */
    inline uint8 getU8Status () const;

    /**
     * Sets the value of the member "u8Status".
     *
     * Depending on the required implementation the values have following meaning
     * <p>Implementation variant 1:</p>
     * <p>0 = LDW configuration no change request</p>
     * <p>1 = LDW configuration change request</p>
     * <p>The property Affordable_ITS reflects the current Affordable ITS configuration.</p>
     * <p></p>
     * <p>Implementation variant 2:</p>
     * <p>0 = LDW configuration change to off</p>
     * <p>1 = LDW configuration change to on</p>
     *
     * @param u8Status The value which will be set
     */
    inline void setU8Status (uint8 u8Status_);

    static const Affordable_Its_SetupLdwStart &getDefaultInstance();

private:

    inline void set_has_u8Status ();

    inline void clear_has_u8Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8Status;

};

/**
 * The result message of the method "Affordable_Its_SetupLdw"
 * This method has to be called by HMI to inform about a change in configuration for the Lane Departure Warning feature.
 * <p>FUNCID = RVC_CCAFI_C_U16_AFFORDABLE_ITS_SETUPLDW</p>
 */
class Affordable_Its_SetupLdwResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Affordable_Its_SetupLdwResult ();

    /**
     * Copy constructor
     */
    inline  Affordable_Its_SetupLdwResult (const Affordable_Its_SetupLdwResult &rhs);

    /**
     * All fields constructor
     */
    inline  Affordable_Its_SetupLdwResult (bool Result_);

    /**
     * Destructor
     */
    inline virtual  ~Affordable_Its_SetupLdwResult();

    /**
     * Assignment operator
     */
    inline Affordable_Its_SetupLdwResult& operator = (const Affordable_Its_SetupLdwResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Affordable_Its_SetupLdwResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Affordable_Its_SetupLdwResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Affordable_Its_SetupLdwResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Affordable_Its_SetupLdwResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @return The value of the field "Result"
     */
    inline bool getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @param Result The value which will be set
     */
    inline void setResult (bool Result_);

    static const Affordable_Its_SetupLdwResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Result;

};

/**
 * The error message of 'Affordable_Its_SetupLdw'
 */
class Affordable_Its_SetupLdwErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  Affordable_Its_SetupLdwErrorStructure ();

    /**
     * Copy constructor
     */
    inline  Affordable_Its_SetupLdwErrorStructure (const Affordable_Its_SetupLdwErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  Affordable_Its_SetupLdwErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~Affordable_Its_SetupLdwErrorStructure();

    /**
     * Assignment operator
     */
    inline Affordable_Its_SetupLdwErrorStructure& operator = (const Affordable_Its_SetupLdwErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Affordable_Its_SetupLdwErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Affordable_Its_SetupLdwErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Affordable_Its_SetupLdwErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Affordable_Its_SetupLdwErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    static const Affordable_Its_SetupLdwErrorStructure &getDefaultInstance();

private:

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _e8ErrorCode;

};

/**
 * The error message of 'Affordable_Its_SetupLdw'
 */
class Affordable_Its_SetupLdwError  : public ::asf::core::Payload {
public:

    enum Affordable_Its_SetupLdwErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  Affordable_Its_SetupLdwError ();

   /**
     * Copy constructor
     */
    inline  Affordable_Its_SetupLdwError (const Affordable_Its_SetupLdwError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~Affordable_Its_SetupLdwError();

    /**
     * Assigns a new value to this object.
     */
    inline Affordable_Its_SetupLdwError& operator = (const Affordable_Its_SetupLdwError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Affordable_Its_SetupLdwError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Affordable_Its_SetupLdwError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Affordable_Its_SetupLdwError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Affordable_Its_SetupLdwError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline Affordable_Its_SetupLdwError::Affordable_Its_SetupLdwErrorField getField () const;

    inline void setField(Affordable_Its_SetupLdwError::Affordable_Its_SetupLdwErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "Affordable_Its_SetupLdwErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "Affordable_Its_SetupLdwErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const Affordable_Its_SetupLdwErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline Affordable_Its_SetupLdwErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline Affordable_Its_SetupLdwErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (Affordable_Its_SetupLdwErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "Affordable_Its_SetupLdwErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const Affordable_Its_SetupLdwErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const Affordable_Its_SetupLdwError &getDefaultInstance();

private:

    inline void cloneData (const Affordable_Its_SetupLdwError& rhs);

    inline void deleteData ();

    Affordable_Its_SetupLdwErrorField __field;

    union {
        Affordable_Its_SetupLdwErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "IPA_SetHMIStatus"
 * <p>FUNCID = RVC_CCAFI_C_U16_IPASETHMISTATUS</p>
 */
class IPA_SetHMIStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IPA_SetHMIStatusStart ();

    /**
     * Copy constructor
     */
    inline  IPA_SetHMIStatusStart (const IPA_SetHMIStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  IPA_SetHMIStatusStart (::rvc_cca_fi_types::T_e8_IPA_HMIStatus e8IPAStatus_);

    /**
     * Destructor
     */
    inline virtual  ~IPA_SetHMIStatusStart();

    /**
     * Assignment operator
     */
    inline IPA_SetHMIStatusStart& operator = (const IPA_SetHMIStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPA_SetHMIStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPA_SetHMIStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPA_SetHMIStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPA_SetHMIStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8IPAStatus"

    static const int kE8IPAStatus = 0;

    /**
     * Clears the field "e8IPAStatus".
     *
     * The field will be set to its default value. The hasE8IPAStatus()
     * method will return false.
     */
    inline void clearE8IPAStatus();

    /**
     * Checks whether the field "e8IPAStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8IPAStatus()). Otherwise it will return false.
     */
    inline bool hasE8IPAStatus () const;

    /**
     * Returns the value of the member "e8IPAStatus".
     *
     * HMI status of IPA
     *
     * @return The value of the field "e8IPAStatus"
     */
    inline ::rvc_cca_fi_types::T_e8_IPA_HMIStatus getE8IPAStatus () const;

    /**
     * Sets the value of the member "e8IPAStatus".
     *
     * HMI status of IPA
     *
     * @param e8IPAStatus The value which will be set
     */
    inline void setE8IPAStatus (::rvc_cca_fi_types::T_e8_IPA_HMIStatus e8IPAStatus_);

    static const IPA_SetHMIStatusStart &getDefaultInstance();

private:

    inline void set_has_e8IPAStatus ();

    inline void clear_has_e8IPAStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_IPA_HMIStatus _e8IPAStatus;

};

/**
 * The result message of the method "IPA_SetHMIStatus"
 * <p>FUNCID = RVC_CCAFI_C_U16_IPASETHMISTATUS</p>
 */
class IPA_SetHMIStatusResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IPA_SetHMIStatusResult ();

    /**
     * Copy constructor
     */
    inline  IPA_SetHMIStatusResult (const IPA_SetHMIStatusResult &rhs);

    /**
     * All fields constructor
     */
    inline  IPA_SetHMIStatusResult (bool Result_);

    /**
     * Destructor
     */
    inline virtual  ~IPA_SetHMIStatusResult();

    /**
     * Assignment operator
     */
    inline IPA_SetHMIStatusResult& operator = (const IPA_SetHMIStatusResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPA_SetHMIStatusResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPA_SetHMIStatusResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPA_SetHMIStatusResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPA_SetHMIStatusResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @return The value of the field "Result"
     */
    inline bool getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @param Result The value which will be set
     */
    inline void setResult (bool Result_);

    static const IPA_SetHMIStatusResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Result;

};

/**
 * The error message of 'IPA_SetHMIStatus'
 */
class IPA_SetHMIStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  IPA_SetHMIStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  IPA_SetHMIStatusErrorStructure (const IPA_SetHMIStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  IPA_SetHMIStatusErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~IPA_SetHMIStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline IPA_SetHMIStatusErrorStructure& operator = (const IPA_SetHMIStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPA_SetHMIStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPA_SetHMIStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPA_SetHMIStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPA_SetHMIStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    static const IPA_SetHMIStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _e8ErrorCode;

};

/**
 * The error message of 'IPA_SetHMIStatus'
 */
class IPA_SetHMIStatusError  : public ::asf::core::Payload {
public:

    enum IPA_SetHMIStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  IPA_SetHMIStatusError ();

   /**
     * Copy constructor
     */
    inline  IPA_SetHMIStatusError (const IPA_SetHMIStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~IPA_SetHMIStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline IPA_SetHMIStatusError& operator = (const IPA_SetHMIStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPA_SetHMIStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPA_SetHMIStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPA_SetHMIStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPA_SetHMIStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline IPA_SetHMIStatusError::IPA_SetHMIStatusErrorField getField () const;

    inline void setField(IPA_SetHMIStatusError::IPA_SetHMIStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "IPA_SetHMIStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "IPA_SetHMIStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const IPA_SetHMIStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline IPA_SetHMIStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline IPA_SetHMIStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (IPA_SetHMIStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "IPA_SetHMIStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const IPA_SetHMIStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const IPA_SetHMIStatusError &getDefaultInstance();

private:

    inline void cloneData (const IPA_SetHMIStatusError& rhs);

    inline void deleteData ();

    IPA_SetHMIStatusErrorField __field;

    union {
        IPA_SetHMIStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "IPA_SetButton"
 * <p>FUNCID = RVC_CCAFI_C_U16_IPASETBUTTON</p>
 */
class IPA_SetButtonStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IPA_SetButtonStart ();

    /**
     * Copy constructor
     */
    inline  IPA_SetButtonStart (const IPA_SetButtonStart &rhs);

    /**
     * All fields constructor
     */
    inline  IPA_SetButtonStart (::rvc_cca_fi_types::T_e8_IPA_BUTTON_ID e8ButtonIdentifier_, ::rvc_cca_fi_types::T_e8_RVC_ButtonState e8ButtonStatus_);

    /**
     * Destructor
     */
    inline virtual  ~IPA_SetButtonStart();

    /**
     * Assignment operator
     */
    inline IPA_SetButtonStart& operator = (const IPA_SetButtonStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPA_SetButtonStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPA_SetButtonStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPA_SetButtonStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPA_SetButtonStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ButtonIdentifier"

    static const int kE8ButtonIdentifier = 0;

    /**
     * Clears the field "e8ButtonIdentifier".
     *
     * The field will be set to its default value. The hasE8ButtonIdentifier()
     * method will return false.
     */
    inline void clearE8ButtonIdentifier();

    /**
     * Checks whether the field "e8ButtonIdentifier" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ButtonIdentifier()). Otherwise it will return false.
     */
    inline bool hasE8ButtonIdentifier () const;

    /**
     * Returns the value of the member "e8ButtonIdentifier".
     *
     * The identifier of the button
     *
     * @return The value of the field "e8ButtonIdentifier"
     */
    inline ::rvc_cca_fi_types::T_e8_IPA_BUTTON_ID getE8ButtonIdentifier () const;

    /**
     * Sets the value of the member "e8ButtonIdentifier".
     *
     * The identifier of the button
     *
     * @param e8ButtonIdentifier The value which will be set
     */
    inline void setE8ButtonIdentifier (::rvc_cca_fi_types::T_e8_IPA_BUTTON_ID e8ButtonIdentifier_);

    // API of field "e8ButtonStatus"

    static const int kE8ButtonStatus = 1;

    /**
     * Clears the field "e8ButtonStatus".
     *
     * The field will be set to its default value. The hasE8ButtonStatus()
     * method will return false.
     */
    inline void clearE8ButtonStatus();

    /**
     * Checks whether the field "e8ButtonStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ButtonStatus()). Otherwise it will return false.
     */
    inline bool hasE8ButtonStatus () const;

    /**
     * Returns the value of the member "e8ButtonStatus".
     *
     * The status of the button
     *
     * @return The value of the field "e8ButtonStatus"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_ButtonState getE8ButtonStatus () const;

    /**
     * Sets the value of the member "e8ButtonStatus".
     *
     * The status of the button
     *
     * @param e8ButtonStatus The value which will be set
     */
    inline void setE8ButtonStatus (::rvc_cca_fi_types::T_e8_RVC_ButtonState e8ButtonStatus_);

    static const IPA_SetButtonStart &getDefaultInstance();

private:

    inline void set_has_e8ButtonIdentifier ();

    inline void clear_has_e8ButtonIdentifier ();

    inline void set_has_e8ButtonStatus ();

    inline void clear_has_e8ButtonStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_IPA_BUTTON_ID _e8ButtonIdentifier;

    ::rvc_cca_fi_types::T_e8_RVC_ButtonState _e8ButtonStatus;

};

/**
 * The result message of the method "IPA_SetButton"
 * <p>FUNCID = RVC_CCAFI_C_U16_IPASETBUTTON</p>
 */
class IPA_SetButtonResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IPA_SetButtonResult ();

    /**
     * Copy constructor
     */
    inline  IPA_SetButtonResult (const IPA_SetButtonResult &rhs);

    /**
     * All fields constructor
     */
    inline  IPA_SetButtonResult (bool Result_);

    /**
     * Destructor
     */
    inline virtual  ~IPA_SetButtonResult();

    /**
     * Assignment operator
     */
    inline IPA_SetButtonResult& operator = (const IPA_SetButtonResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPA_SetButtonResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPA_SetButtonResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPA_SetButtonResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPA_SetButtonResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @return The value of the field "Result"
     */
    inline bool getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @param Result The value which will be set
     */
    inline void setResult (bool Result_);

    static const IPA_SetButtonResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Result;

};

/**
 * The error message of 'IPA_SetButton'
 */
class IPA_SetButtonErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  IPA_SetButtonErrorStructure ();

    /**
     * Copy constructor
     */
    inline  IPA_SetButtonErrorStructure (const IPA_SetButtonErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  IPA_SetButtonErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~IPA_SetButtonErrorStructure();

    /**
     * Assignment operator
     */
    inline IPA_SetButtonErrorStructure& operator = (const IPA_SetButtonErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPA_SetButtonErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPA_SetButtonErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPA_SetButtonErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPA_SetButtonErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    static const IPA_SetButtonErrorStructure &getDefaultInstance();

private:

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _e8ErrorCode;

};

/**
 * The error message of 'IPA_SetButton'
 */
class IPA_SetButtonError  : public ::asf::core::Payload {
public:

    enum IPA_SetButtonErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  IPA_SetButtonError ();

   /**
     * Copy constructor
     */
    inline  IPA_SetButtonError (const IPA_SetButtonError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~IPA_SetButtonError();

    /**
     * Assigns a new value to this object.
     */
    inline IPA_SetButtonError& operator = (const IPA_SetButtonError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPA_SetButtonError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPA_SetButtonError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPA_SetButtonError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPA_SetButtonError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline IPA_SetButtonError::IPA_SetButtonErrorField getField () const;

    inline void setField(IPA_SetButtonError::IPA_SetButtonErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "IPA_SetButtonErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "IPA_SetButtonErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const IPA_SetButtonErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline IPA_SetButtonErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline IPA_SetButtonErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (IPA_SetButtonErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "IPA_SetButtonErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const IPA_SetButtonErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const IPA_SetButtonError &getDefaultInstance();

private:

    inline void cloneData (const IPA_SetButtonError& rhs);

    inline void deleteData ();

    IPA_SetButtonErrorField __field;

    union {
        IPA_SetButtonErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "IPA_Voice_Texts"
 * <p>IPA Voice strings has to be read out in all different Languages</p>
 * <p>the text of these strings is fetched from HMI Translation table and used in TTS</p>
 * <p>FUNCID = RVC_CCAFI_C_U16_IPA_VOICE_TEXTS</p>
 */
class IPA_Voice_TextsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IPA_Voice_TextsStart ();

    /**
     * Copy constructor
     */
    inline  IPA_Voice_TextsStart (const IPA_Voice_TextsStart &rhs);

    /**
     * All fields constructor
     */
    inline  IPA_Voice_TextsStart (const ::std::vector< ::rvc_cca_fi_types::T_IPA_Voice_Text_Strings >& arTexts_, ::rvc_cca_fi_types::T_e8_RVC_Language Language_);

    /**
     * Destructor
     */
    inline virtual  ~IPA_Voice_TextsStart();

    /**
     * Assignment operator
     */
    inline IPA_Voice_TextsStart& operator = (const IPA_Voice_TextsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPA_Voice_TextsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPA_Voice_TextsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPA_Voice_TextsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPA_Voice_TextsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arTexts"

    static const int kArTexts = 0;

    /**
     * Clears the field "arTexts".
     *
     * The field will be set to its default value. The hasArTexts()
     * method will return false.
     */
    inline void clearArTexts();

    /**
     * Checks whether the field "arTexts" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArTexts()). Otherwise it will return false.
     */
    inline bool hasArTexts () const;

    /**
     * Returns the value of the member "arTexts".
     *
     * The list of the Strings for each Voice Request ID
     *
     * @return The value of the field "arTexts"
     */
    inline const ::std::vector< ::rvc_cca_fi_types::T_IPA_Voice_Text_Strings >& getArTexts () const;

    /**
     * Retrieves the value of the field "arTexts" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arTexts".
     */
    inline ::std::vector< ::rvc_cca_fi_types::T_IPA_Voice_Text_Strings >& getArTextsMutable ();

    /**
     * Sets the value of the member "arTexts".
     *
     * The list of the Strings for each Voice Request ID
     *
     * @param arTexts The value which will be set
     */
    inline void setArTexts (const ::std::vector< ::rvc_cca_fi_types::T_IPA_Voice_Text_Strings >& arTexts_);

    // API of field "Language"

    static const int kLanguage = 1;

    /**
     * Clears the field "Language".
     *
     * The field will be set to its default value. The hasLanguage()
     * method will return false.
     */
    inline void clearLanguage();

    /**
     * Checks whether the field "Language" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguage()). Otherwise it will return false.
     */
    inline bool hasLanguage () const;

    /**
     * Returns the value of the member "Language".
     *
     * Current translation is for this language
     *
     * @return The value of the field "Language"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_Language getLanguage () const;

    /**
     * Sets the value of the member "Language".
     *
     * Current translation is for this language
     *
     * @param Language The value which will be set
     */
    inline void setLanguage (::rvc_cca_fi_types::T_e8_RVC_Language Language_);

    static const IPA_Voice_TextsStart &getDefaultInstance();

private:

    static const ::std::vector< ::rvc_cca_fi_types::T_IPA_Voice_Text_Strings >& getT_IPA_Voice_Text_StringsList_DefaultInstance ();

    inline void set_has_arTexts ();

    inline void clear_has_arTexts ();

    inline void set_has_Language ();

    inline void clear_has_Language ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< ::rvc_cca_fi_types::T_IPA_Voice_Text_Strings > _arTexts;

    ::rvc_cca_fi_types::T_e8_RVC_Language _Language;

};

/**
 * The result message of the method "IPA_Voice_Texts"
 * <p>IPA Voice strings has to be read out in all different Languages</p>
 * <p>the text of these strings is fetched from HMI Translation table and used in TTS</p>
 * <p>FUNCID = RVC_CCAFI_C_U16_IPA_VOICE_TEXTS</p>
 */
class IPA_Voice_TextsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IPA_Voice_TextsResult ();

    /**
     * Copy constructor
     */
    inline  IPA_Voice_TextsResult (const IPA_Voice_TextsResult &rhs);

    /**
     * All fields constructor
     */
    inline  IPA_Voice_TextsResult (bool Result_);

    /**
     * Destructor
     */
    inline virtual  ~IPA_Voice_TextsResult();

    /**
     * Assignment operator
     */
    inline IPA_Voice_TextsResult& operator = (const IPA_Voice_TextsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPA_Voice_TextsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPA_Voice_TextsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPA_Voice_TextsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPA_Voice_TextsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @return The value of the field "Result"
     */
    inline bool getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @param Result The value which will be set
     */
    inline void setResult (bool Result_);

    static const IPA_Voice_TextsResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Result;

};

/**
 * The error message of 'IPA_Voice_Texts'
 */
class IPA_Voice_TextsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  IPA_Voice_TextsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  IPA_Voice_TextsErrorStructure (const IPA_Voice_TextsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  IPA_Voice_TextsErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~IPA_Voice_TextsErrorStructure();

    /**
     * Assignment operator
     */
    inline IPA_Voice_TextsErrorStructure& operator = (const IPA_Voice_TextsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPA_Voice_TextsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPA_Voice_TextsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPA_Voice_TextsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPA_Voice_TextsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    static const IPA_Voice_TextsErrorStructure &getDefaultInstance();

private:

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _e8ErrorCode;

};

/**
 * The error message of 'IPA_Voice_Texts'
 */
class IPA_Voice_TextsError  : public ::asf::core::Payload {
public:

    enum IPA_Voice_TextsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  IPA_Voice_TextsError ();

   /**
     * Copy constructor
     */
    inline  IPA_Voice_TextsError (const IPA_Voice_TextsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~IPA_Voice_TextsError();

    /**
     * Assigns a new value to this object.
     */
    inline IPA_Voice_TextsError& operator = (const IPA_Voice_TextsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IPA_Voice_TextsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IPA_Voice_TextsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IPA_Voice_TextsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IPA_Voice_TextsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline IPA_Voice_TextsError::IPA_Voice_TextsErrorField getField () const;

    inline void setField(IPA_Voice_TextsError::IPA_Voice_TextsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "IPA_Voice_TextsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "IPA_Voice_TextsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const IPA_Voice_TextsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline IPA_Voice_TextsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline IPA_Voice_TextsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (IPA_Voice_TextsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "IPA_Voice_TextsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const IPA_Voice_TextsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const IPA_Voice_TextsError &getDefaultInstance();

private:

    inline void cloneData (const IPA_Voice_TextsError& rhs);

    inline void deleteData ();

    IPA_Voice_TextsErrorField __field;

    union {
        IPA_Voice_TextsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "MVC_HMI_ViewRequest"
 * <p>FUNCID = RVC_CCAFI_C_U16_MVC_HMI_VIEWREQUEST</p>
 */
class MVC_HMI_ViewRequestStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MVC_HMI_ViewRequestStart ();

    /**
     * Copy constructor
     */
    inline  MVC_HMI_ViewRequestStart (const MVC_HMI_ViewRequestStart &rhs);

    /**
     * All fields constructor
     */
    inline  MVC_HMI_ViewRequestStart (::rvc_cca_fi_types::T_e8_MVCViewingState e8Request_);

    /**
     * Destructor
     */
    inline virtual  ~MVC_HMI_ViewRequestStart();

    /**
     * Assignment operator
     */
    inline MVC_HMI_ViewRequestStart& operator = (const MVC_HMI_ViewRequestStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MVC_HMI_ViewRequestStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MVC_HMI_ViewRequestStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MVC_HMI_ViewRequestStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MVC_HMI_ViewRequestStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Request"

    static const int kE8Request = 0;

    /**
     * Clears the field "e8Request".
     *
     * The field will be set to its default value. The hasE8Request()
     * method will return false.
     */
    inline void clearE8Request();

    /**
     * Checks whether the field "e8Request" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Request()). Otherwise it will return false.
     */
    inline bool hasE8Request () const;

    /**
     * Returns the value of the member "e8Request".
     *
     * MVC View Request from HMI
     *
     * @return The value of the field "e8Request"
     */
    inline ::rvc_cca_fi_types::T_e8_MVCViewingState getE8Request () const;

    /**
     * Sets the value of the member "e8Request".
     *
     * MVC View Request from HMI
     *
     * @param e8Request The value which will be set
     */
    inline void setE8Request (::rvc_cca_fi_types::T_e8_MVCViewingState e8Request_);

    static const MVC_HMI_ViewRequestStart &getDefaultInstance();

private:

    inline void set_has_e8Request ();

    inline void clear_has_e8Request ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_MVCViewingState _e8Request;

};

/**
 * The result message of the method "MVC_HMI_ViewRequest"
 * <p>FUNCID = RVC_CCAFI_C_U16_MVC_HMI_VIEWREQUEST</p>
 */
class MVC_HMI_ViewRequestResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MVC_HMI_ViewRequestResult ();

    /**
     * Copy constructor
     */
    inline  MVC_HMI_ViewRequestResult (const MVC_HMI_ViewRequestResult &rhs);

    /**
     * All fields constructor
     */
    inline  MVC_HMI_ViewRequestResult (bool Result_);

    /**
     * Destructor
     */
    inline virtual  ~MVC_HMI_ViewRequestResult();

    /**
     * Assignment operator
     */
    inline MVC_HMI_ViewRequestResult& operator = (const MVC_HMI_ViewRequestResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MVC_HMI_ViewRequestResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MVC_HMI_ViewRequestResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MVC_HMI_ViewRequestResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MVC_HMI_ViewRequestResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @return The value of the field "Result"
     */
    inline bool getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @param Result The value which will be set
     */
    inline void setResult (bool Result_);

    static const MVC_HMI_ViewRequestResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Result;

};

/**
 * The error message of 'MVC_HMI_ViewRequest'
 */
class MVC_HMI_ViewRequestErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  MVC_HMI_ViewRequestErrorStructure ();

    /**
     * Copy constructor
     */
    inline  MVC_HMI_ViewRequestErrorStructure (const MVC_HMI_ViewRequestErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  MVC_HMI_ViewRequestErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~MVC_HMI_ViewRequestErrorStructure();

    /**
     * Assignment operator
     */
    inline MVC_HMI_ViewRequestErrorStructure& operator = (const MVC_HMI_ViewRequestErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MVC_HMI_ViewRequestErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MVC_HMI_ViewRequestErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MVC_HMI_ViewRequestErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MVC_HMI_ViewRequestErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    static const MVC_HMI_ViewRequestErrorStructure &getDefaultInstance();

private:

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _e8ErrorCode;

};

/**
 * The error message of 'MVC_HMI_ViewRequest'
 */
class MVC_HMI_ViewRequestError  : public ::asf::core::Payload {
public:

    enum MVC_HMI_ViewRequestErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  MVC_HMI_ViewRequestError ();

   /**
     * Copy constructor
     */
    inline  MVC_HMI_ViewRequestError (const MVC_HMI_ViewRequestError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~MVC_HMI_ViewRequestError();

    /**
     * Assigns a new value to this object.
     */
    inline MVC_HMI_ViewRequestError& operator = (const MVC_HMI_ViewRequestError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MVC_HMI_ViewRequestError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MVC_HMI_ViewRequestError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MVC_HMI_ViewRequestError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MVC_HMI_ViewRequestError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline MVC_HMI_ViewRequestError::MVC_HMI_ViewRequestErrorField getField () const;

    inline void setField(MVC_HMI_ViewRequestError::MVC_HMI_ViewRequestErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "MVC_HMI_ViewRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "MVC_HMI_ViewRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const MVC_HMI_ViewRequestErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline MVC_HMI_ViewRequestErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline MVC_HMI_ViewRequestErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (MVC_HMI_ViewRequestErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "MVC_HMI_ViewRequestErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const MVC_HMI_ViewRequestErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const MVC_HMI_ViewRequestError &getDefaultInstance();

private:

    inline void cloneData (const MVC_HMI_ViewRequestError& rhs);

    inline void deleteData ();

    MVC_HMI_ViewRequestErrorField __field;

    union {
        MVC_HMI_ViewRequestErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GdlAdj_AdjustmentComplete"
 * <p>FUNCID = RVC_CCAFI_C_U16_GDLADJ_ADJUSTMENTCOMPLETE</p>
 */
class GdlAdj_AdjustmentCompleteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GdlAdj_AdjustmentCompleteStart ();

    /**
     * Copy constructor
     */
    inline  GdlAdj_AdjustmentCompleteStart (const GdlAdj_AdjustmentCompleteStart &rhs);

    /**
     * All fields constructor
     */
    inline  GdlAdj_AdjustmentCompleteStart (::rvc_cca_fi_types::T_e8_GdlAdj_Completion e8Completion_);

    /**
     * Destructor
     */
    inline virtual  ~GdlAdj_AdjustmentCompleteStart();

    /**
     * Assignment operator
     */
    inline GdlAdj_AdjustmentCompleteStart& operator = (const GdlAdj_AdjustmentCompleteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GdlAdj_AdjustmentCompleteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GdlAdj_AdjustmentCompleteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GdlAdj_AdjustmentCompleteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GdlAdj_AdjustmentCompleteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Completion"

    static const int kE8Completion = 0;

    /**
     * Clears the field "e8Completion".
     *
     * The field will be set to its default value. The hasE8Completion()
     * method will return false.
     */
    inline void clearE8Completion();

    /**
     * Checks whether the field "e8Completion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Completion()). Otherwise it will return false.
     */
    inline bool hasE8Completion () const;

    /**
     * Returns the value of the member "e8Completion".
     *
     * to inform about the completion action
     *
     * @return The value of the field "e8Completion"
     */
    inline ::rvc_cca_fi_types::T_e8_GdlAdj_Completion getE8Completion () const;

    /**
     * Sets the value of the member "e8Completion".
     *
     * to inform about the completion action
     *
     * @param e8Completion The value which will be set
     */
    inline void setE8Completion (::rvc_cca_fi_types::T_e8_GdlAdj_Completion e8Completion_);

    static const GdlAdj_AdjustmentCompleteStart &getDefaultInstance();

private:

    inline void set_has_e8Completion ();

    inline void clear_has_e8Completion ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_GdlAdj_Completion _e8Completion;

};

/**
 * The result message of the method "GdlAdj_AdjustmentComplete"
 * <p>FUNCID = RVC_CCAFI_C_U16_GDLADJ_ADJUSTMENTCOMPLETE</p>
 */
class GdlAdj_AdjustmentCompleteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GdlAdj_AdjustmentCompleteResult ();

    /**
     * Copy constructor
     */
    inline  GdlAdj_AdjustmentCompleteResult (const GdlAdj_AdjustmentCompleteResult &rhs);

    /**
     * All fields constructor
     */
    inline  GdlAdj_AdjustmentCompleteResult (bool Result_);

    /**
     * Destructor
     */
    inline virtual  ~GdlAdj_AdjustmentCompleteResult();

    /**
     * Assignment operator
     */
    inline GdlAdj_AdjustmentCompleteResult& operator = (const GdlAdj_AdjustmentCompleteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GdlAdj_AdjustmentCompleteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GdlAdj_AdjustmentCompleteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GdlAdj_AdjustmentCompleteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GdlAdj_AdjustmentCompleteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @return The value of the field "Result"
     */
    inline bool getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @param Result The value which will be set
     */
    inline void setResult (bool Result_);

    static const GdlAdj_AdjustmentCompleteResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Result;

};

/**
 * The error message of 'GdlAdj_AdjustmentComplete'
 */
class GdlAdj_AdjustmentCompleteErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GdlAdj_AdjustmentCompleteErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GdlAdj_AdjustmentCompleteErrorStructure (const GdlAdj_AdjustmentCompleteErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GdlAdj_AdjustmentCompleteErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GdlAdj_AdjustmentCompleteErrorStructure();

    /**
     * Assignment operator
     */
    inline GdlAdj_AdjustmentCompleteErrorStructure& operator = (const GdlAdj_AdjustmentCompleteErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GdlAdj_AdjustmentCompleteErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GdlAdj_AdjustmentCompleteErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GdlAdj_AdjustmentCompleteErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GdlAdj_AdjustmentCompleteErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    static const GdlAdj_AdjustmentCompleteErrorStructure &getDefaultInstance();

private:

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _e8ErrorCode;

};

/**
 * The error message of 'GdlAdj_AdjustmentComplete'
 */
class GdlAdj_AdjustmentCompleteError  : public ::asf::core::Payload {
public:

    enum GdlAdj_AdjustmentCompleteErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GdlAdj_AdjustmentCompleteError ();

   /**
     * Copy constructor
     */
    inline  GdlAdj_AdjustmentCompleteError (const GdlAdj_AdjustmentCompleteError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GdlAdj_AdjustmentCompleteError();

    /**
     * Assigns a new value to this object.
     */
    inline GdlAdj_AdjustmentCompleteError& operator = (const GdlAdj_AdjustmentCompleteError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GdlAdj_AdjustmentCompleteError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GdlAdj_AdjustmentCompleteError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GdlAdj_AdjustmentCompleteError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GdlAdj_AdjustmentCompleteError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline GdlAdj_AdjustmentCompleteError::GdlAdj_AdjustmentCompleteErrorField getField () const;

    inline void setField(GdlAdj_AdjustmentCompleteError::GdlAdj_AdjustmentCompleteErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "GdlAdj_AdjustmentCompleteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "GdlAdj_AdjustmentCompleteErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const GdlAdj_AdjustmentCompleteErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline GdlAdj_AdjustmentCompleteErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline GdlAdj_AdjustmentCompleteErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (GdlAdj_AdjustmentCompleteErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "GdlAdj_AdjustmentCompleteErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const GdlAdj_AdjustmentCompleteErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const GdlAdj_AdjustmentCompleteError &getDefaultInstance();

private:

    inline void cloneData (const GdlAdj_AdjustmentCompleteError& rhs);

    inline void deleteData ();

    GdlAdj_AdjustmentCompleteErrorField __field;

    union {
        GdlAdj_AdjustmentCompleteErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "GdlAdj_AdjustButton"
 * This method has to be called by HMI to inform about a button press in Guideline Adjustment Screen.
 * <p>FUNCID = RVC_CCAFI_C_U16_GDLADJ_ADJUSTBUTTON</p>
 */
class GdlAdj_AdjustButtonStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GdlAdj_AdjustButtonStart ();

    /**
     * Copy constructor
     */
    inline  GdlAdj_AdjustButtonStart (const GdlAdj_AdjustButtonStart &rhs);

    /**
     * All fields constructor
     */
    inline  GdlAdj_AdjustButtonStart (::rvc_cca_fi_types::T_e8_GdlAdj_AdjustButton e8Button_);

    /**
     * Destructor
     */
    inline virtual  ~GdlAdj_AdjustButtonStart();

    /**
     * Assignment operator
     */
    inline GdlAdj_AdjustButtonStart& operator = (const GdlAdj_AdjustButtonStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GdlAdj_AdjustButtonStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GdlAdj_AdjustButtonStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GdlAdj_AdjustButtonStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GdlAdj_AdjustButtonStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Button"

    static const int kE8Button = 0;

    /**
     * Clears the field "e8Button".
     *
     * The field will be set to its default value. The hasE8Button()
     * method will return false.
     */
    inline void clearE8Button();

    /**
     * Checks whether the field "e8Button" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Button()). Otherwise it will return false.
     */
    inline bool hasE8Button () const;

    /**
     * Returns the value of the member "e8Button".
     *
     * to inform about a Adjust Button press
     *
     * @return The value of the field "e8Button"
     */
    inline ::rvc_cca_fi_types::T_e8_GdlAdj_AdjustButton getE8Button () const;

    /**
     * Sets the value of the member "e8Button".
     *
     * to inform about a Adjust Button press
     *
     * @param e8Button The value which will be set
     */
    inline void setE8Button (::rvc_cca_fi_types::T_e8_GdlAdj_AdjustButton e8Button_);

    static const GdlAdj_AdjustButtonStart &getDefaultInstance();

private:

    inline void set_has_e8Button ();

    inline void clear_has_e8Button ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_GdlAdj_AdjustButton _e8Button;

};

/**
 * The result message of the method "GdlAdj_AdjustButton"
 * This method has to be called by HMI to inform about a button press in Guideline Adjustment Screen.
 * <p>FUNCID = RVC_CCAFI_C_U16_GDLADJ_ADJUSTBUTTON</p>
 */
class GdlAdj_AdjustButtonResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GdlAdj_AdjustButtonResult ();

    /**
     * Copy constructor
     */
    inline  GdlAdj_AdjustButtonResult (const GdlAdj_AdjustButtonResult &rhs);

    /**
     * All fields constructor
     */
    inline  GdlAdj_AdjustButtonResult (bool Result_);

    /**
     * Destructor
     */
    inline virtual  ~GdlAdj_AdjustButtonResult();

    /**
     * Assignment operator
     */
    inline GdlAdj_AdjustButtonResult& operator = (const GdlAdj_AdjustButtonResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GdlAdj_AdjustButtonResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GdlAdj_AdjustButtonResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GdlAdj_AdjustButtonResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GdlAdj_AdjustButtonResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @return The value of the field "Result"
     */
    inline bool getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * True: the  method was successful
     * <p>False: method was not successful</p>
     *
     * @param Result The value which will be set
     */
    inline void setResult (bool Result_);

    static const GdlAdj_AdjustButtonResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Result;

};

/**
 * The error message of 'GdlAdj_AdjustButton'
 */
class GdlAdj_AdjustButtonErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  GdlAdj_AdjustButtonErrorStructure ();

    /**
     * Copy constructor
     */
    inline  GdlAdj_AdjustButtonErrorStructure (const GdlAdj_AdjustButtonErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  GdlAdj_AdjustButtonErrorStructure (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    /**
     * Destructor
     */
    inline  ~GdlAdj_AdjustButtonErrorStructure();

    /**
     * Assignment operator
     */
    inline GdlAdj_AdjustButtonErrorStructure& operator = (const GdlAdj_AdjustButtonErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GdlAdj_AdjustButtonErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GdlAdj_AdjustButtonErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GdlAdj_AdjustButtonErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GdlAdj_AdjustButtonErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ErrorCode"

    static const int kE8ErrorCode = 0;

    /**
     * Clears the field "e8ErrorCode".
     *
     * The field will be set to its default value. The hasE8ErrorCode()
     * method will return false.
     */
    inline void clearE8ErrorCode();

    /**
     * Checks whether the field "e8ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ErrorCode()). Otherwise it will return false.
     */
    inline bool hasE8ErrorCode () const;

    /**
     * Returns the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @return The value of the field "e8ErrorCode"
     */
    inline ::rvc_cca_fi_types::T_e8_RVC_CCAError getE8ErrorCode () const;

    /**
     * Sets the value of the member "e8ErrorCode".
     *
     * Error codes
     *
     * @param e8ErrorCode The value which will be set
     */
    inline void setE8ErrorCode (::rvc_cca_fi_types::T_e8_RVC_CCAError e8ErrorCode_);

    static const GdlAdj_AdjustButtonErrorStructure &getDefaultInstance();

private:

    inline void set_has_e8ErrorCode ();

    inline void clear_has_e8ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::rvc_cca_fi_types::T_e8_RVC_CCAError _e8ErrorCode;

};

/**
 * The error message of 'GdlAdj_AdjustButton'
 */
class GdlAdj_AdjustButtonError  : public ::asf::core::Payload {
public:

    enum GdlAdj_AdjustButtonErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  GdlAdj_AdjustButtonError ();

   /**
     * Copy constructor
     */
    inline  GdlAdj_AdjustButtonError (const GdlAdj_AdjustButtonError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~GdlAdj_AdjustButtonError();

    /**
     * Assigns a new value to this object.
     */
    inline GdlAdj_AdjustButtonError& operator = (const GdlAdj_AdjustButtonError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GdlAdj_AdjustButtonError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GdlAdj_AdjustButtonError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Righ