/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_PROFILEPIVISTUB_H
#define BOSCH_CM_PROFILEPIVISTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/profilePIVI.h"
#include "bosch/cm/profilePIVIConst.h"
#include <vector>

namespace bosch {
namespace cm {
namespace profilePIVI {

class ProfilePIVIStubDelegate;

class ProfilePIVIStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the ProfilePIVIStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    ProfilePIVIStub (const std::string& portName);

    /**
     * Create an instance of the ProfilePIVIStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    ProfilePIVIStub (const std::string& portName, const std::string& objectPath);

    virtual ~ProfilePIVIStub();

    // property 'keyIsMapped'

    /**
     * The method onKeyIsMappedGet() is called by ASF when a client invokes
     * the read method for the property 'keyIsMapped'. The onKeyIsMappedGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'keyIsMapped'</b>:
     *
     * current user Profile. Updated only on user change.
     */
    virtual void onKeyIsMappedGet(const ::boost::shared_ptr< KeyIsMappedGet >& payload);

    /**
     * Sends back the update to a previous onKeyIsMappedGet().
     *
     * <b>Documentation of 'keyIsMapped'</b>:
     *
     * current user Profile. Updated only on user change.
     *
     * @param act Identifies a previous invocation of onKeyIsMappedGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendKeyIsMappedGetUpdate(bool keyIsMapped, act_t act = 0);

    /**
     * Set the value of the property 'keyIsMapped' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'keyIsMapped'</b>:
     *
     * current user Profile. Updated only on user change.
     */
    void setKeyIsMapped(bool keyIsMapped);

    /**
     * Returns the current value of the property 'keyIsMapped'.
     *
     * <b>Documentation of 'keyIsMapped'</b>:
     *
     * current user Profile. Updated only on user change.
     */
    bool getKeyIsMapped() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendKeyIsMappedUpdate().
     *
     * <b>Documentation of 'keyIsMapped'</b>:
     *
     * current user Profile. Updated only on user change.
     */
    void sendKeyIsMappedUpdate();

    // property 'keyMappingPossible'

    /**
     * The method onKeyMappingPossibleGet() is called by ASF when a client
     * invokes the read method for the property 'keyMappingPossible'. The
     * onKeyMappingPossibleGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'keyMappingPossible'</b>:
     *
     * If the meaning of "keyMappingPossible" isn't clear, then there should be a description here.
     */
    virtual void onKeyMappingPossibleGet(const ::boost::shared_ptr< KeyMappingPossibleGet >& payload);

    /**
     * Sends back the update to a previous onKeyMappingPossibleGet().
     *
     * <b>Documentation of 'keyMappingPossible'</b>:
     *
     * If the meaning of "keyMappingPossible" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onKeyMappingPossibleGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendKeyMappingPossibleGetUpdate(bool keyMappingPossible, act_t act = 0);

    /**
     * Set the value of the property 'keyMappingPossible' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'keyMappingPossible'</b>:
     *
     * If the meaning of "keyMappingPossible" isn't clear, then there should be a description here.
     */
    void setKeyMappingPossible(bool keyMappingPossible);

    /**
     * Returns the current value of the property 'keyMappingPossible'.
     *
     * <b>Documentation of 'keyMappingPossible'</b>:
     *
     * If the meaning of "keyMappingPossible" isn't clear, then there should be a description here.
     */
    bool getKeyMappingPossible() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendKeyMappingPossibleUpdate().
     *
     * <b>Documentation of 'keyMappingPossible'</b>:
     *
     * If the meaning of "keyMappingPossible" isn't clear, then there should be a description here.
     */
    void sendKeyMappingPossibleUpdate();

    // property 'keyID'

    /**
     * The method onKeyIDGet() is called by ASF when a client invokes the read
     * method for the property 'keyID'. The onKeyIDGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'keyID'</b>:
     *
     * If the meaning of "keyID" isn't clear, then there should be a description here.
     */
    virtual void onKeyIDGet(const ::boost::shared_ptr< KeyIDGet >& payload);

    /**
     * Sends back the update to a previous onKeyIDGet().
     *
     * <b>Documentation of 'keyID'</b>:
     *
     * If the meaning of "keyID" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onKeyIDGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendKeyIDGetUpdate(uint32 keyID, act_t act = 0);

    /**
     * Set the value of the property 'keyID' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'keyID'</b>:
     *
     * If the meaning of "keyID" isn't clear, then there should be a description here.
     */
    void setKeyID(uint32 keyID);

    /**
     * Returns the current value of the property 'keyID'.
     *
     * <b>Documentation of 'keyID'</b>:
     *
     * If the meaning of "keyID" isn't clear, then there should be a description here.
     */
    uint32 getKeyID() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendKeyIDUpdate().
     *
     * <b>Documentation of 'keyID'</b>:
     *
     * If the meaning of "keyID" isn't clear, then there should be a description here.
     */
    void sendKeyIDUpdate();

    // property 'ProfilekeyIIndex'

    /**
     * The method onProfilekeyIIndexGet() is called by ASF when a client
     * invokes the read method for the property 'ProfilekeyIIndex'. The
     * onProfilekeyIIndexGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ProfilekeyIIndex'</b>:
     *
     * If the meaning of "ProfilekeyIIndex" isn't clear, then there should be a description here.
     */
    virtual void onProfilekeyIIndexGet(const ::boost::shared_ptr< ProfilekeyIIndexGet >& payload);

    /**
     * Sends back the update to a previous onProfilekeyIIndexGet().
     *
     * <b>Documentation of 'ProfilekeyIIndex'</b>:
     *
     * If the meaning of "ProfilekeyIIndex" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onProfilekeyIIndexGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendProfilekeyIIndexGetUpdate(uint8 profilekeyIIndex, act_t act = 0);

    /**
     * Set the value of the property 'ProfilekeyIIndex' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ProfilekeyIIndex'</b>:
     *
     * If the meaning of "ProfilekeyIIndex" isn't clear, then there should be a description here.
     */
    void setProfilekeyIIndex(uint8 profilekeyIIndex);

    /**
     * Returns the current value of the property 'ProfilekeyIIndex'.
     *
     * <b>Documentation of 'ProfilekeyIIndex'</b>:
     *
     * If the meaning of "ProfilekeyIIndex" isn't clear, then there should be a description here.
     */
    uint8 getProfilekeyIIndex() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendProfilekeyIIndexUpdate().
     *
     * <b>Documentation of 'ProfilekeyIIndex'</b>:
     *
     * If the meaning of "ProfilekeyIIndex" isn't clear, then there should be a description here.
     */
    void sendProfilekeyIIndexUpdate();

    // property 'welcomeGuidanceActive'

    /**
     * The method onWelcomeGuidanceActiveGet() is called by ASF when a client
     * invokes the read method for the property 'welcomeGuidanceActive'. The
     * onWelcomeGuidanceActiveGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'welcomeGuidanceActive'</b>:
     *
     * If the meaning of "welcomeGuidanceActive" isn't clear, then there should be a description here.
     */
    virtual void onWelcomeGuidanceActiveGet(const ::boost::shared_ptr< WelcomeGuidanceActiveGet >& payload);

    /**
     * Sends back the update to a previous onWelcomeGuidanceActiveGet().
     *
     * <b>Documentation of 'welcomeGuidanceActive'</b>:
     *
     * If the meaning of "welcomeGuidanceActive" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onWelcomeGuidanceActiveGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendWelcomeGuidanceActiveGetUpdate(bool welcomeGuidanceActive, act_t act = 0);

    /**
     * Set the value of the property 'welcomeGuidanceActive' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'welcomeGuidanceActive'</b>:
     *
     * If the meaning of "welcomeGuidanceActive" isn't clear, then there should be a description here.
     */
    void setWelcomeGuidanceActive(bool welcomeGuidanceActive);

    /**
     * Returns the current value of the property 'welcomeGuidanceActive'.
     *
     * <b>Documentation of 'welcomeGuidanceActive'</b>:
     *
     * If the meaning of "welcomeGuidanceActive" isn't clear, then there should be a description here.
     */
    bool getWelcomeGuidanceActive() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendWelcomeGuidanceActiveUpdate().
     *
     * <b>Documentation of 'welcomeGuidanceActive'</b>:
     *
     * If the meaning of "welcomeGuidanceActive" isn't clear, then there should be a description here.
     */
    void sendWelcomeGuidanceActiveUpdate();

    // property 'loginKeyLinkStatus'

    /**
     * The method onLoginKeyLinkStatusGet() is called by ASF when a client
     * invokes the read method for the property 'loginKeyLinkStatus'. The
     * onLoginKeyLinkStatusGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'loginKeyLinkStatus'</b>:
     *
     * If the meaning of "loginKeyLinkStatus" isn't clear, then there should be a description here.
     */
    virtual void onLoginKeyLinkStatusGet(const ::boost::shared_ptr< LoginKeyLinkStatusGet >& payload);

    /**
     * Sends back the update to a previous onLoginKeyLinkStatusGet().
     *
     * <b>Documentation of 'loginKeyLinkStatus'</b>:
     *
     * If the meaning of "loginKeyLinkStatus" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onLoginKeyLinkStatusGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendLoginKeyLinkStatusGetUpdate(bool loginKeyLinkStatus, act_t act = 0);

    /**
     * Set the value of the property 'loginKeyLinkStatus' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'loginKeyLinkStatus'</b>:
     *
     * If the meaning of "loginKeyLinkStatus" isn't clear, then there should be a description here.
     */
    void setLoginKeyLinkStatus(bool loginKeyLinkStatus);

    /**
     * Returns the current value of the property 'loginKeyLinkStatus'.
     *
     * <b>Documentation of 'loginKeyLinkStatus'</b>:
     *
     * If the meaning of "loginKeyLinkStatus" isn't clear, then there should be a description here.
     */
    bool getLoginKeyLinkStatus() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLoginKeyLinkStatusUpdate().
     *
     * <b>Documentation of 'loginKeyLinkStatus'</b>:
     *
     * If the meaning of "loginKeyLinkStatus" isn't clear, then there should be a description here.
     */
    void sendLoginKeyLinkStatusUpdate();

    // property 'IsStartupSequence'

    /**
     * The method onIsStartupSequenceGet() is called by ASF when a client
     * invokes the read method for the property 'IsStartupSequence'. The
     * onIsStartupSequenceGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'IsStartupSequence'</b>:
     *
     * If the meaning of "IsStartupSequence" isn't clear, then there should be a description here.
     */
    virtual void onIsStartupSequenceGet(const ::boost::shared_ptr< IsStartupSequenceGet >& payload);

    /**
     * Sends back the update to a previous onIsStartupSequenceGet().
     *
     * <b>Documentation of 'IsStartupSequence'</b>:
     *
     * If the meaning of "IsStartupSequence" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onIsStartupSequenceGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendIsStartupSequenceGetUpdate(bool isStartupSequence, act_t act = 0);

    /**
     * Set the value of the property 'IsStartupSequence' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'IsStartupSequence'</b>:
     *
     * If the meaning of "IsStartupSequence" isn't clear, then there should be a description here.
     */
    void setIsStartupSequence(bool isStartupSequence);

    /**
     * Returns the current value of the property 'IsStartupSequence'.
     *
     * <b>Documentation of 'IsStartupSequence'</b>:
     *
     * If the meaning of "IsStartupSequence" isn't clear, then there should be a description here.
     */
    bool getIsStartupSequence() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendIsStartupSequenceUpdate().
     *
     * <b>Documentation of 'IsStartupSequence'</b>:
     *
     * If the meaning of "IsStartupSequence" isn't clear, then there should be a description here.
     */
    void sendIsStartupSequenceUpdate();

    // method 'mapKeyToCurrentProfile'

    /**
     * The method onMapKeyToCurrentProfile() is called by ASF when a client
     * invokes the method 'mapKeyToCurrentProfile'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendMapKeyToCurrentProfile() or
     * sendMapKeyToCurrentProfileError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'mapKeyToCurrentProfile'</b>:
     *
     * map the current KeyID to the active Profile
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onMapKeyToCurrentProfileRequest (const ::boost::shared_ptr< MapKeyToCurrentProfileRequest >& request) = 0;

    /**
     * The method sendMapKeyToCurrentProfileResponse() sends a response of a
     * previous method invocation of 'mapKeyToCurrentProfile' back to the
     * client.
     *
     * <b>Documentation of 'mapKeyToCurrentProfile'</b>:
     *
     * map the current KeyID to the active Profile
     *
     * @param Result If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onMapKeyToCurrentProfile(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendMapKeyToCurrentProfileResponse (serverResult result, act_t act = 0);

    /**
     * The method sendMapKeyToCurrentProfileError() sends an error response of
     * a previous method invocation of 'mapKeyToCurrentProfile' back to the
     * client.
     *
     * <b>Documentation of 'mapKeyToCurrentProfile'</b>:
     *
     * map the current KeyID to the active Profile
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onMapKeyToCurrentProfile(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendMapKeyToCurrentProfileError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetWelcomeGuidanceActive'

    /**
     * The method onSetWelcomeGuidanceActive() is called by ASF when a client
     * invokes the method 'SetWelcomeGuidanceActive'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendSetWelcomeGuidanceActive() or
     * sendSetWelcomeGuidanceActiveError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'SetWelcomeGuidanceActive'</b>:
     *
     * If the meaning of "SetWelcomeGuidanceActive" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetWelcomeGuidanceActiveRequest (const ::boost::shared_ptr< SetWelcomeGuidanceActiveRequest >& request) = 0;

    /**
     * The method sendSetWelcomeGuidanceActiveResponse() sends a response of a
     * previous method invocation of 'SetWelcomeGuidanceActive' back to the
     * client.
     *
     * <b>Documentation of 'SetWelcomeGuidanceActive'</b>:
     *
     * If the meaning of "SetWelcomeGuidanceActive" isn't clear, then there should be a description here.
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetWelcomeGuidanceActive(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetWelcomeGuidanceActiveResponse (serverResult result, act_t act = 0);

    /**
     * The method sendSetWelcomeGuidanceActiveError() sends an error response
     * of a previous method invocation of 'SetWelcomeGuidanceActive' back to
     * the client.
     *
     * <b>Documentation of 'SetWelcomeGuidanceActive'</b>:
     *
     * If the meaning of "SetWelcomeGuidanceActive" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetWelcomeGuidanceActive(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetWelcomeGuidanceActiveError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setLoginKeyLinkSetting'

    /**
     * The method onSetLoginKeyLinkSetting() is called by ASF when a client
     * invokes the method 'setLoginKeyLinkSetting'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendSetLoginKeyLinkSetting() or
     * sendSetLoginKeyLinkSettingError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'setLoginKeyLinkSetting'</b>:
     *
     * If the meaning of "setLoginKeyLinkSetting" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetLoginKeyLinkSettingRequest (const ::boost::shared_ptr< SetLoginKeyLinkSettingRequest >& request) = 0;

    /**
     * The method sendSetLoginKeyLinkSettingResponse() sends a response of a
     * previous method invocation of 'setLoginKeyLinkSetting' back to the
     * client.
     *
     * <b>Documentation of 'setLoginKeyLinkSetting'</b>:
     *
     * If the meaning of "setLoginKeyLinkSetting" isn't clear, then there should be a description here.
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetLoginKeyLinkSetting(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetLoginKeyLinkSettingResponse (serverResult result, act_t act = 0);

    /**
     * The method sendSetLoginKeyLinkSettingError() sends an error response of
     * a previous method invocation of 'setLoginKeyLinkSetting' back to the
     * client.
     *
     * <b>Documentation of 'setLoginKeyLinkSetting'</b>:
     *
     * If the meaning of "setLoginKeyLinkSetting" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetLoginKeyLinkSetting(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetLoginKeyLinkSettingError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getKeylist'

    /**
     * The method onGetKeylist() is called by ASF when a client invokes the
     * method 'getKeylist'. A subclass has to implement this method and send
     * back a response to the client either with the sendGetKeylist() or
     * sendGetKeylistError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'getKeylist'</b>:
     *
     * If the meaning of "getKeylist" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetKeylistRequest (const ::boost::shared_ptr< GetKeylistRequest >& request) = 0;

    /**
     * The method sendGetKeylistResponse() sends a response of a previous
     * method invocation of 'getKeylist' back to the client.
     *
     * <b>Documentation of 'getKeylist'</b>:
     *
     * If the meaning of "getKeylist" isn't clear, then there should be a description here.
     *
     * @param keylist If the meaning of "keylist" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetKeylist(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetKeylistResponse (const ::std::vector< uint8 >& keylist, act_t act = 0);

    /**
     * The method sendGetKeylistError() sends an error response of a previous
     * method invocation of 'getKeylist' back to the client.
     *
     * <b>Documentation of 'getKeylist'</b>:
     *
     * If the meaning of "getKeylist" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetKeylist(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendGetKeylistError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    KeyIsMappedUpdate _keyIsMappedProperty;

    KeyMappingPossibleUpdate _keyMappingPossibleProperty;

    KeyIDUpdate _keyIDProperty;

    ProfilekeyIIndexUpdate _ProfilekeyIIndexProperty;

    WelcomeGuidanceActiveUpdate _welcomeGuidanceActiveProperty;

    LoginKeyLinkStatusUpdate _loginKeyLinkStatusProperty;

    IsStartupSequenceUpdate _IsStartupSequenceProperty;

    friend class ProfilePIVIStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace profilePIVI
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_PROFILEPIVISTUB_H
