#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_PROFILEPIVI_H
#define BOSCH_CM_PROFILEPIVI_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "bosch/cm/profilePIVIConst.h"
#include <cstring>
#include <vector>

/**
 * basic attributes for User Profile Management
 */

namespace bosch {
namespace cm {
namespace profilePIVI {

// method IDs
static const uint16 ID_mapKeyToCurrentProfile = 0;
static const uint16 ID_SetWelcomeGuidanceActive = 1;
static const uint16 ID_setLoginKeyLinkSetting = 2;
static const uint16 ID_getKeylist = 3;

// signal IDs

// property IDs
static const uint16 ID_keyIsMapped = 4;
static const uint16 ID_keyMappingPossible = 5;
static const uint16 ID_keyID = 6;
static const uint16 ID_ProfilekeyIIndex = 7;
static const uint16 ID_welcomeGuidanceActive = 8;
static const uint16 ID_loginKeyLinkStatus = 9;
static const uint16 ID_IsStartupSequence = 10;

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class MapKeyToCurrentProfileResponse;

class SetWelcomeGuidanceActiveRequest;

class SetWelcomeGuidanceActiveResponse;

class SetLoginKeyLinkSettingRequest;

class SetLoginKeyLinkSettingResponse;

class GetKeylistRequest;

class GetKeylistResponse;

class KeyIsMappedUpdate;

class KeyIsMappedRegister;

class KeyMappingPossibleUpdate;

class KeyMappingPossibleRegister;

class KeyIDUpdate;

class KeyIDRegister;

class ProfilekeyIIndexUpdate;

class ProfilekeyIIndexRegister;

class WelcomeGuidanceActiveUpdate;

class WelcomeGuidanceActiveRegister;

class LoginKeyLinkStatusUpdate;

class LoginKeyLinkStatusRegister;

class IsStartupSequenceUpdate;

class IsStartupSequenceRegister;

// type definitions
/**
 * map the current KeyID to the active Profile
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage MapKeyToCurrentProfileRequest;

/**
 * If the meaning of "MapKeyToCurrentProfileError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MapKeyToCurrentProfileError;

/**
 * If the meaning of "SetWelcomeGuidanceActiveError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetWelcomeGuidanceActiveError;

/**
 * If the meaning of "SetLoginKeyLinkSettingError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetLoginKeyLinkSettingError;

/**
 * If the meaning of "GetKeylistError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetKeylistError;

/**
 * current user Profile. Updated only on user change.
 */
typedef KeyIsMappedUpdate KeyIsMappedSet;

/**
 * current user Profile. Updated only on user change.
 */
typedef KeyIsMappedUpdate KeyIsMappedGet;

/**
 * If the meaning of "KeyIsMappedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError KeyIsMappedError;

/**
 * If the meaning of "keyMappingPossible" isn't clear, then there should be a description here.
 */
typedef KeyMappingPossibleUpdate KeyMappingPossibleSet;

/**
 * If the meaning of "keyMappingPossible" isn't clear, then there should be a description here.
 */
typedef KeyMappingPossibleUpdate KeyMappingPossibleGet;

/**
 * If the meaning of "KeyMappingPossibleError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError KeyMappingPossibleError;

/**
 * If the meaning of "keyID" isn't clear, then there should be a description here.
 */
typedef KeyIDUpdate KeyIDSet;

/**
 * If the meaning of "keyID" isn't clear, then there should be a description here.
 */
typedef KeyIDUpdate KeyIDGet;

/**
 * If the meaning of "KeyIDError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError KeyIDError;

/**
 * If the meaning of "ProfilekeyIIndex" isn't clear, then there should be a description here.
 */
typedef ProfilekeyIIndexUpdate ProfilekeyIIndexSet;

/**
 * If the meaning of "ProfilekeyIIndex" isn't clear, then there should be a description here.
 */
typedef ProfilekeyIIndexUpdate ProfilekeyIIndexGet;

/**
 * If the meaning of "ProfilekeyIIndexError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ProfilekeyIIndexError;

/**
 * If the meaning of "welcomeGuidanceActive" isn't clear, then there should be a description here.
 */
typedef WelcomeGuidanceActiveUpdate WelcomeGuidanceActiveSet;

/**
 * If the meaning of "welcomeGuidanceActive" isn't clear, then there should be a description here.
 */
typedef WelcomeGuidanceActiveUpdate WelcomeGuidanceActiveGet;

/**
 * If the meaning of "WelcomeGuidanceActiveError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError WelcomeGuidanceActiveError;

/**
 * If the meaning of "loginKeyLinkStatus" isn't clear, then there should be a description here.
 */
typedef LoginKeyLinkStatusUpdate LoginKeyLinkStatusSet;

/**
 * If the meaning of "loginKeyLinkStatus" isn't clear, then there should be a description here.
 */
typedef LoginKeyLinkStatusUpdate LoginKeyLinkStatusGet;

/**
 * If the meaning of "LoginKeyLinkStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LoginKeyLinkStatusError;

/**
 * If the meaning of "IsStartupSequence" isn't clear, then there should be a description here.
 */
typedef IsStartupSequenceUpdate IsStartupSequenceSet;

/**
 * If the meaning of "IsStartupSequence" isn't clear, then there should be a description here.
 */
typedef IsStartupSequenceUpdate IsStartupSequenceGet;

/**
 * If the meaning of "IsStartupSequenceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError IsStartupSequenceError;


/**
 * map the current KeyID to the active Profile
 */
class MapKeyToCurrentProfileResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MapKeyToCurrentProfileResponse ();

    /**
     * Copy constructor
     */
    inline  MapKeyToCurrentProfileResponse (const MapKeyToCurrentProfileResponse &rhs);

    /**
     * All fields constructor
     */
    inline  MapKeyToCurrentProfileResponse (serverResult Result_);

    /**
     * Destructor
     */
    inline virtual  ~MapKeyToCurrentProfileResponse();

    /**
     * Assignment operator
     */
    inline MapKeyToCurrentProfileResponse& operator = (const MapKeyToCurrentProfileResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MapKeyToCurrentProfileResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MapKeyToCurrentProfileResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MapKeyToCurrentProfileResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MapKeyToCurrentProfileResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline serverResult getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (serverResult Result_);

    static const MapKeyToCurrentProfileResponse &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    serverResult _Result;

};

/**
 * If the meaning of "SetWelcomeGuidanceActive" isn't clear, then there should be a description here.
 */
class SetWelcomeGuidanceActiveRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetWelcomeGuidanceActiveRequest ();

    /**
     * Copy constructor
     */
    inline  SetWelcomeGuidanceActiveRequest (const SetWelcomeGuidanceActiveRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetWelcomeGuidanceActiveRequest (uint8 userID_, bool wgActive_);

    /**
     * Destructor
     */
    inline virtual  ~SetWelcomeGuidanceActiveRequest();

    /**
     * Assignment operator
     */
    inline SetWelcomeGuidanceActiveRequest& operator = (const SetWelcomeGuidanceActiveRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWelcomeGuidanceActiveRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWelcomeGuidanceActiveRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWelcomeGuidanceActiveRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWelcomeGuidanceActiveRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "userID"

    static const int kUserID = 0;

    /**
     * Clears the field "userID".
     *
     * The field will be set to its default value. The hasUserID()
     * method will return false.
     */
    inline void clearUserID();

    /**
     * Checks whether the field "userID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserID()). Otherwise it will return false.
     */
    inline bool hasUserID () const;

    /**
     * Returns the value of the member "userID".
     *
     * If the meaning of "userID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "userID"
     */
    inline uint8 getUserID () const;

    /**
     * Sets the value of the member "userID".
     *
     * If the meaning of "userID" isn't clear, then there should be a description here.
     *
     * @param userID The value which will be set
     */
    inline void setUserID (uint8 userID_);

    // API of field "wgActive"

    static const int kWgActive = 1;

    /**
     * Clears the field "wgActive".
     *
     * The field will be set to its default value. The hasWgActive()
     * method will return false.
     */
    inline void clearWgActive();

    /**
     * Checks whether the field "wgActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWgActive()). Otherwise it will return false.
     */
    inline bool hasWgActive () const;

    /**
     * Returns the value of the member "wgActive".
     *
     * If the meaning of "wgActive" isn't clear, then there should be a description here.
     *
     * @return The value of the field "wgActive"
     */
    inline bool getWgActive () const;

    /**
     * Sets the value of the member "wgActive".
     *
     * If the meaning of "wgActive" isn't clear, then there should be a description here.
     *
     * @param wgActive The value which will be set
     */
    inline void setWgActive (bool wgActive_);

    static const SetWelcomeGuidanceActiveRequest &getDefaultInstance();

private:

    inline void set_has_userID ();

    inline void clear_has_userID ();

    inline void set_has_wgActive ();

    inline void clear_has_wgActive ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _userID;

    bool _wgActive;

};

/**
 * If the meaning of "SetWelcomeGuidanceActive" isn't clear, then there should be a description here.
 */
class SetWelcomeGuidanceActiveResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetWelcomeGuidanceActiveResponse ();

    /**
     * Copy constructor
     */
    inline  SetWelcomeGuidanceActiveResponse (const SetWelcomeGuidanceActiveResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetWelcomeGuidanceActiveResponse (serverResult result_);

    /**
     * Destructor
     */
    inline virtual  ~SetWelcomeGuidanceActiveResponse();

    /**
     * Assignment operator
     */
    inline SetWelcomeGuidanceActiveResponse& operator = (const SetWelcomeGuidanceActiveResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetWelcomeGuidanceActiveResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetWelcomeGuidanceActiveResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetWelcomeGuidanceActiveResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetWelcomeGuidanceActiveResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline serverResult getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (serverResult result_);

    static const SetWelcomeGuidanceActiveResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    serverResult _result;

};

/**
 * If the meaning of "setLoginKeyLinkSetting" isn't clear, then there should be a description here.
 */
class SetLoginKeyLinkSettingRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetLoginKeyLinkSettingRequest ();

    /**
     * Copy constructor
     */
    inline  SetLoginKeyLinkSettingRequest (const SetLoginKeyLinkSettingRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetLoginKeyLinkSettingRequest (bool loginKeyLinkSetting_);

    /**
     * Destructor
     */
    inline virtual  ~SetLoginKeyLinkSettingRequest();

    /**
     * Assignment operator
     */
    inline SetLoginKeyLinkSettingRequest& operator = (const SetLoginKeyLinkSettingRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetLoginKeyLinkSettingRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetLoginKeyLinkSettingRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetLoginKeyLinkSettingRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetLoginKeyLinkSettingRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "loginKeyLinkSetting"

    static const int kLoginKeyLinkSetting = 0;

    /**
     * Clears the field "loginKeyLinkSetting".
     *
     * The field will be set to its default value. The hasLoginKeyLinkSetting()
     * method will return false.
     */
    inline void clearLoginKeyLinkSetting();

    /**
     * Checks whether the field "loginKeyLinkSetting" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLoginKeyLinkSetting()). Otherwise it will return false.
     */
    inline bool hasLoginKeyLinkSetting () const;

    /**
     * Returns the value of the member "loginKeyLinkSetting".
     *
     * If the meaning of "loginKeyLinkSetting" isn't clear, then there should be a description here.
     *
     * @return The value of the field "loginKeyLinkSetting"
     */
    inline bool getLoginKeyLinkSetting () const;

    /**
     * Sets the value of the member "loginKeyLinkSetting".
     *
     * If the meaning of "loginKeyLinkSetting" isn't clear, then there should be a description here.
     *
     * @param loginKeyLinkSetting The value which will be set
     */
    inline void setLoginKeyLinkSetting (bool loginKeyLinkSetting_);

    static const SetLoginKeyLinkSettingRequest &getDefaultInstance();

private:

    inline void set_has_loginKeyLinkSetting ();

    inline void clear_has_loginKeyLinkSetting ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _loginKeyLinkSetting;

};

/**
 * If the meaning of "setLoginKeyLinkSetting" isn't clear, then there should be a description here.
 */
class SetLoginKeyLinkSettingResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetLoginKeyLinkSettingResponse ();

    /**
     * Copy constructor
     */
    inline  SetLoginKeyLinkSettingResponse (const SetLoginKeyLinkSettingResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetLoginKeyLinkSettingResponse (serverResult result_);

    /**
     * Destructor
     */
    inline virtual  ~SetLoginKeyLinkSettingResponse();

    /**
     * Assignment operator
     */
    inline SetLoginKeyLinkSettingResponse& operator = (const SetLoginKeyLinkSettingResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetLoginKeyLinkSettingResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetLoginKeyLinkSettingResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetLoginKeyLinkSettingResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetLoginKeyLinkSettingResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline serverResult getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (serverResult result_);

    static const SetLoginKeyLinkSettingResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    serverResult _result;

};

/**
 * If the meaning of "getKeylist" isn't clear, then there should be a description here.
 */
class GetKeylistRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetKeylistRequest ();

    /**
     * Copy constructor
     */
    inline  GetKeylistRequest (const GetKeylistRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetKeylistRequest (uint8 userID_);

    /**
     * Destructor
     */
    inline virtual  ~GetKeylistRequest();

    /**
     * Assignment operator
     */
    inline GetKeylistRequest& operator = (const GetKeylistRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetKeylistRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetKeylistRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetKeylistRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetKeylistRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "userID"

    static const int kUserID = 0;

    /**
     * Clears the field "userID".
     *
     * The field will be set to its default value. The hasUserID()
     * method will return false.
     */
    inline void clearUserID();

    /**
     * Checks whether the field "userID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserID()). Otherwise it will return false.
     */
    inline bool hasUserID () const;

    /**
     * Returns the value of the member "userID".
     *
     * If the meaning of "userID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "userID"
     */
    inline uint8 getUserID () const;

    /**
     * Sets the value of the member "userID".
     *
     * If the meaning of "userID" isn't clear, then there should be a description here.
     *
     * @param userID The value which will be set
     */
    inline void setUserID (uint8 userID_);

    static const GetKeylistRequest &getDefaultInstance();

private:

    inline void set_has_userID ();

    inline void clear_has_userID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _userID;

};

/**
 * If the meaning of "getKeylist" isn't clear, then there should be a description here.
 */
class GetKeylistResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetKeylistResponse ();

    /**
     * Copy constructor
     */
    inline  GetKeylistResponse (const GetKeylistResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetKeylistResponse (const ::std::vector< uint8 >& keylist_);

    /**
     * Destructor
     */
    inline virtual  ~GetKeylistResponse();

    /**
     * Assignment operator
     */
    inline GetKeylistResponse& operator = (const GetKeylistResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetKeylistResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetKeylistResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetKeylistResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetKeylistResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "keylist"

    static const int kKeylist = 0;

    /**
     * Clears the field "keylist".
     *
     * The field will be set to its default value. The hasKeylist()
     * method will return false.
     */
    inline void clearKeylist();

    /**
     * Checks whether the field "keylist" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeylist()). Otherwise it will return false.
     */
    inline bool hasKeylist () const;

    /**
     * Returns the value of the member "keylist".
     *
     * If the meaning of "keylist" isn't clear, then there should be a description here.
     *
     * @return The value of the field "keylist"
     */
    inline const ::std::vector< uint8 >& getKeylist () const;

    /**
     * Retrieves the value of the field "keylist" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "keylist".
     */
    inline ::std::vector< uint8 >& getKeylistMutable ();

    /**
     * Sets the value of the member "keylist".
     *
     * If the meaning of "keylist" isn't clear, then there should be a description here.
     *
     * @param keylist The value which will be set
     */
    inline void setKeylist (const ::std::vector< uint8 >& keylist_);

    static const GetKeylistResponse &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_keylist ();

    inline void clear_has_keylist ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _keylist;

};

/**
 * current user Profile. Updated only on user change.
 */
class KeyIsMappedUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  KeyIsMappedUpdate ();

    /**
     * Copy constructor
     */
    inline  KeyIsMappedUpdate (const KeyIsMappedUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  KeyIsMappedUpdate (bool keyIsMapped_);

    /**
     * Destructor
     */
    inline virtual  ~KeyIsMappedUpdate();

    /**
     * Assignment operator
     */
    inline KeyIsMappedUpdate& operator = (const KeyIsMappedUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const KeyIsMappedUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const KeyIsMappedUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const KeyIsMappedUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const KeyIsMappedUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "keyIsMapped"

    static const int kKeyIsMapped = 0;

    /**
     * Clears the field "keyIsMapped".
     *
     * The field will be set to its default value. The hasKeyIsMapped()
     * method will return false.
     */
    inline void clearKeyIsMapped();

    /**
     * Checks whether the field "keyIsMapped" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeyIsMapped()). Otherwise it will return false.
     */
    inline bool hasKeyIsMapped () const;

    /**
     * Returns the value of the member "keyIsMapped".
     *
     * current user Profile. Updated only on user change.
     *
     * @return The value of the field "keyIsMapped"
     */
    inline bool getKeyIsMapped () const;

    /**
     * Sets the value of the member "keyIsMapped".
     *
     * current user Profile. Updated only on user change.
     *
     * @param keyIsMapped The value which will be set
     */
    inline void setKeyIsMapped (bool keyIsMapped_);

    static const KeyIsMappedUpdate &getDefaultInstance();

private:

    inline void set_has_keyIsMapped ();

    inline void clear_has_keyIsMapped ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _keyIsMapped;

};

/**
 * current user Profile. Updated only on user change.
 */
class KeyIsMappedRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  KeyIsMappedRegister ();

    /**
     * Copy constructor
     */
    inline  KeyIsMappedRegister (const KeyIsMappedRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~KeyIsMappedRegister();

    /**
     * Assignment operator
     */
    inline KeyIsMappedRegister& operator = (const KeyIsMappedRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const KeyIsMappedRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const KeyIsMappedRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const KeyIsMappedRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const KeyIsMappedRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const KeyIsMappedRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "keyMappingPossible" isn't clear, then there should be a description here.
 */
class KeyMappingPossibleUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  KeyMappingPossibleUpdate ();

    /**
     * Copy constructor
     */
    inline  KeyMappingPossibleUpdate (const KeyMappingPossibleUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  KeyMappingPossibleUpdate (bool keyMappingPossible_);

    /**
     * Destructor
     */
    inline virtual  ~KeyMappingPossibleUpdate();

    /**
     * Assignment operator
     */
    inline KeyMappingPossibleUpdate& operator = (const KeyMappingPossibleUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const KeyMappingPossibleUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const KeyMappingPossibleUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const KeyMappingPossibleUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const KeyMappingPossibleUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "keyMappingPossible"

    static const int kKeyMappingPossible = 0;

    /**
     * Clears the field "keyMappingPossible".
     *
     * The field will be set to its default value. The hasKeyMappingPossible()
     * method will return false.
     */
    inline void clearKeyMappingPossible();

    /**
     * Checks whether the field "keyMappingPossible" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeyMappingPossible()). Otherwise it will return false.
     */
    inline bool hasKeyMappingPossible () const;

    /**
     * Returns the value of the member "keyMappingPossible".
     *
     * If the meaning of "keyMappingPossible" isn't clear, then there should be a description here.
     *
     * @return The value of the field "keyMappingPossible"
     */
    inline bool getKeyMappingPossible () const;

    /**
     * Sets the value of the member "keyMappingPossible".
     *
     * If the meaning of "keyMappingPossible" isn't clear, then there should be a description here.
     *
     * @param keyMappingPossible The value which will be set
     */
    inline void setKeyMappingPossible (bool keyMappingPossible_);

    static const KeyMappingPossibleUpdate &getDefaultInstance();

private:

    inline void set_has_keyMappingPossible ();

    inline void clear_has_keyMappingPossible ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _keyMappingPossible;

};

/**
 * If the meaning of "keyMappingPossible" isn't clear, then there should be a description here.
 */
class KeyMappingPossibleRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  KeyMappingPossibleRegister ();

    /**
     * Copy constructor
     */
    inline  KeyMappingPossibleRegister (const KeyMappingPossibleRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~KeyMappingPossibleRegister();

    /**
     * Assignment operator
     */
    inline KeyMappingPossibleRegister& operator = (const KeyMappingPossibleRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const KeyMappingPossibleRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const KeyMappingPossibleRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const KeyMappingPossibleRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const KeyMappingPossibleRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const KeyMappingPossibleRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "keyID" isn't clear, then there should be a description here.
 */
class KeyIDUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  KeyIDUpdate ();

    /**
     * Copy constructor
     */
    inline  KeyIDUpdate (const KeyIDUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  KeyIDUpdate (uint32 keyID_);

    /**
     * Destructor
     */
    inline virtual  ~KeyIDUpdate();

    /**
     * Assignment operator
     */
    inline KeyIDUpdate& operator = (const KeyIDUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const KeyIDUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const KeyIDUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const KeyIDUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const KeyIDUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "keyID"

    static const int kKeyID = 0;

    /**
     * Clears the field "keyID".
     *
     * The field will be set to its default value. The hasKeyID()
     * method will return false.
     */
    inline void clearKeyID();

    /**
     * Checks whether the field "keyID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeyID()). Otherwise it will return false.
     */
    inline bool hasKeyID () const;

    /**
     * Returns the value of the member "keyID".
     *
     * If the meaning of "keyID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "keyID"
     */
    inline uint32 getKeyID () const;

    /**
     * Sets the value of the member "keyID".
     *
     * If the meaning of "keyID" isn't clear, then there should be a description here.
     *
     * @param keyID The value which will be set
     */
    inline void setKeyID (uint32 keyID_);

    static const KeyIDUpdate &getDefaultInstance();

private:

    inline void set_has_keyID ();

    inline void clear_has_keyID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _keyID;

};

/**
 * If the meaning of "keyID" isn't clear, then there should be a description here.
 */
class KeyIDRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  KeyIDRegister ();

    /**
     * Copy constructor
     */
    inline  KeyIDRegister (const KeyIDRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~KeyIDRegister();

    /**
     * Assignment operator
     */
    inline KeyIDRegister& operator = (const KeyIDRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const KeyIDRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const KeyIDRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const KeyIDRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const KeyIDRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const KeyIDRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "ProfilekeyIIndex" isn't clear, then there should be a description here.
 */
class ProfilekeyIIndexUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProfilekeyIIndexUpdate ();

    /**
     * Copy constructor
     */
    inline  ProfilekeyIIndexUpdate (const ProfilekeyIIndexUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ProfilekeyIIndexUpdate (uint8 ProfilekeyIIndex_);

    /**
     * Destructor
     */
    inline virtual  ~ProfilekeyIIndexUpdate();

    /**
     * Assignment operator
     */
    inline ProfilekeyIIndexUpdate& operator = (const ProfilekeyIIndexUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProfilekeyIIndexUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProfilekeyIIndexUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProfilekeyIIndexUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProfilekeyIIndexUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ProfilekeyIIndex"

    static const int kProfilekeyIIndex = 0;

    /**
     * Clears the field "ProfilekeyIIndex".
     *
     * The field will be set to its default value. The hasProfilekeyIIndex()
     * method will return false.
     */
    inline void clearProfilekeyIIndex();

    /**
     * Checks whether the field "ProfilekeyIIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProfilekeyIIndex()). Otherwise it will return false.
     */
    inline bool hasProfilekeyIIndex () const;

    /**
     * Returns the value of the member "ProfilekeyIIndex".
     *
     * If the meaning of "ProfilekeyIIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ProfilekeyIIndex"
     */
    inline uint8 getProfilekeyIIndex () const;

    /**
     * Sets the value of the member "ProfilekeyIIndex".
     *
     * If the meaning of "ProfilekeyIIndex" isn't clear, then there should be a description here.
     *
     * @param ProfilekeyIIndex The value which will be set
     */
    inline void setProfilekeyIIndex (uint8 ProfilekeyIIndex_);

    static const ProfilekeyIIndexUpdate &getDefaultInstance();

private:

    inline void set_has_ProfilekeyIIndex ();

    inline void clear_has_ProfilekeyIIndex ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ProfilekeyIIndex;

};

/**
 * If the meaning of "ProfilekeyIIndex" isn't clear, then there should be a description here.
 */
class ProfilekeyIIndexRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProfilekeyIIndexRegister ();

    /**
     * Copy constructor
     */
    inline  ProfilekeyIIndexRegister (const ProfilekeyIIndexRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ProfilekeyIIndexRegister();

    /**
     * Assignment operator
     */
    inline ProfilekeyIIndexRegister& operator = (const ProfilekeyIIndexRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProfilekeyIIndexRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProfilekeyIIndexRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProfilekeyIIndexRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProfilekeyIIndexRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ProfilekeyIIndexRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "welcomeGuidanceActive" isn't clear, then there should be a description here.
 */
class WelcomeGuidanceActiveUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WelcomeGuidanceActiveUpdate ();

    /**
     * Copy constructor
     */
    inline  WelcomeGuidanceActiveUpdate (const WelcomeGuidanceActiveUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  WelcomeGuidanceActiveUpdate (bool welcomeGuidanceActive_);

    /**
     * Destructor
     */
    inline virtual  ~WelcomeGuidanceActiveUpdate();

    /**
     * Assignment operator
     */
    inline WelcomeGuidanceActiveUpdate& operator = (const WelcomeGuidanceActiveUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WelcomeGuidanceActiveUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WelcomeGuidanceActiveUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WelcomeGuidanceActiveUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WelcomeGuidanceActiveUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "welcomeGuidanceActive"

    static const int kWelcomeGuidanceActive = 0;

    /**
     * Clears the field "welcomeGuidanceActive".
     *
     * The field will be set to its default value. The hasWelcomeGuidanceActive()
     * method will return false.
     */
    inline void clearWelcomeGuidanceActive();

    /**
     * Checks whether the field "welcomeGuidanceActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWelcomeGuidanceActive()). Otherwise it will return false.
     */
    inline bool hasWelcomeGuidanceActive () const;

    /**
     * Returns the value of the member "welcomeGuidanceActive".
     *
     * If the meaning of "welcomeGuidanceActive" isn't clear, then there should be a description here.
     *
     * @return The value of the field "welcomeGuidanceActive"
     */
    inline bool getWelcomeGuidanceActive () const;

    /**
     * Sets the value of the member "welcomeGuidanceActive".
     *
     * If the meaning of "welcomeGuidanceActive" isn't clear, then there should be a description here.
     *
     * @param welcomeGuidanceActive The value which will be set
     */
    inline void setWelcomeGuidanceActive (bool welcomeGuidanceActive_);

    static const WelcomeGuidanceActiveUpdate &getDefaultInstance();

private:

    inline void set_has_welcomeGuidanceActive ();

    inline void clear_has_welcomeGuidanceActive ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _welcomeGuidanceActive;

};

/**
 * If the meaning of "welcomeGuidanceActive" isn't clear, then there should be a description here.
 */
class WelcomeGuidanceActiveRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WelcomeGuidanceActiveRegister ();

    /**
     * Copy constructor
     */
    inline  WelcomeGuidanceActiveRegister (const WelcomeGuidanceActiveRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~WelcomeGuidanceActiveRegister();

    /**
     * Assignment operator
     */
    inline WelcomeGuidanceActiveRegister& operator = (const WelcomeGuidanceActiveRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WelcomeGuidanceActiveRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WelcomeGuidanceActiveRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WelcomeGuidanceActiveRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WelcomeGuidanceActiveRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const WelcomeGuidanceActiveRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "loginKeyLinkStatus" isn't clear, then there should be a description here.
 */
class LoginKeyLinkStatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LoginKeyLinkStatusUpdate ();

    /**
     * Copy constructor
     */
    inline  LoginKeyLinkStatusUpdate (const LoginKeyLinkStatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  LoginKeyLinkStatusUpdate (bool loginKeyLinkStatus_);

    /**
     * Destructor
     */
    inline virtual  ~LoginKeyLinkStatusUpdate();

    /**
     * Assignment operator
     */
    inline LoginKeyLinkStatusUpdate& operator = (const LoginKeyLinkStatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LoginKeyLinkStatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LoginKeyLinkStatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LoginKeyLinkStatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LoginKeyLinkStatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "loginKeyLinkStatus"

    static const int kLoginKeyLinkStatus = 0;

    /**
     * Clears the field "loginKeyLinkStatus".
     *
     * The field will be set to its default value. The hasLoginKeyLinkStatus()
     * method will return false.
     */
    inline void clearLoginKeyLinkStatus();

    /**
     * Checks whether the field "loginKeyLinkStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLoginKeyLinkStatus()). Otherwise it will return false.
     */
    inline bool hasLoginKeyLinkStatus () const;

    /**
     * Returns the value of the member "loginKeyLinkStatus".
     *
     * If the meaning of "loginKeyLinkStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "loginKeyLinkStatus"
     */
    inline bool getLoginKeyLinkStatus () const;

    /**
     * Sets the value of the member "loginKeyLinkStatus".
     *
     * If the meaning of "loginKeyLinkStatus" isn't clear, then there should be a description here.
     *
     * @param loginKeyLinkStatus The value which will be set
     */
    inline void setLoginKeyLinkStatus (bool loginKeyLinkStatus_);

    static const LoginKeyLinkStatusUpdate &getDefaultInstance();

private:

    inline void set_has_loginKeyLinkStatus ();

    inline void clear_has_loginKeyLinkStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _loginKeyLinkStatus;

};

/**
 * If the meaning of "loginKeyLinkStatus" isn't clear, then there should be a description here.
 */
class LoginKeyLinkStatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LoginKeyLinkStatusRegister ();

    /**
     * Copy constructor
     */
    inline  LoginKeyLinkStatusRegister (const LoginKeyLinkStatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~LoginKeyLinkStatusRegister();

    /**
     * Assignment operator
     */
    inline LoginKeyLinkStatusRegister& operator = (const LoginKeyLinkStatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LoginKeyLinkStatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LoginKeyLinkStatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LoginKeyLinkStatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LoginKeyLinkStatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const LoginKeyLinkStatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "IsStartupSequence" isn't clear, then there should be a description here.
 */
class IsStartupSequenceUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IsStartupSequenceUpdate ();

    /**
     * Copy constructor
     */
    inline  IsStartupSequenceUpdate (const IsStartupSequenceUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  IsStartupSequenceUpdate (bool IsStartupSequence_);

    /**
     * Destructor
     */
    inline virtual  ~IsStartupSequenceUpdate();

    /**
     * Assignment operator
     */
    inline IsStartupSequenceUpdate& operator = (const IsStartupSequenceUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IsStartupSequenceUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IsStartupSequenceUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IsStartupSequenceUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IsStartupSequenceUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IsStartupSequence"

    static const int kIsStartupSequence = 0;

    /**
     * Clears the field "IsStartupSequence".
     *
     * The field will be set to its default value. The hasIsStartupSequence()
     * method will return false.
     */
    inline void clearIsStartupSequence();

    /**
     * Checks whether the field "IsStartupSequence" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsStartupSequence()). Otherwise it will return false.
     */
    inline bool hasIsStartupSequence () const;

    /**
     * Returns the value of the member "IsStartupSequence".
     *
     * If the meaning of "IsStartupSequence" isn't clear, then there should be a description here.
     *
     * @return The value of the field "IsStartupSequence"
     */
    inline bool getIsStartupSequence () const;

    /**
     * Sets the value of the member "IsStartupSequence".
     *
     * If the meaning of "IsStartupSequence" isn't clear, then there should be a description here.
     *
     * @param IsStartupSequence The value which will be set
     */
    inline void setIsStartupSequence (bool IsStartupSequence_);

    static const IsStartupSequenceUpdate &getDefaultInstance();

private:

    inline void set_has_IsStartupSequence ();

    inline void clear_has_IsStartupSequence ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _IsStartupSequence;

};

/**
 * If the meaning of "IsStartupSequence" isn't clear, then there should be a description here.
 */
class IsStartupSequenceRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IsStartupSequenceRegister ();

    /**
     * Copy constructor
     */
    inline  IsStartupSequenceRegister (const IsStartupSequenceRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~IsStartupSequenceRegister();

    /**
     * Assignment operator
     */
    inline IsStartupSequenceRegister& operator = (const IsStartupSequenceRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IsStartupSequenceRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IsStartupSequenceRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IsStartupSequenceRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IsStartupSequenceRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const IsStartupSequenceRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  MapKeyToCurrentProfileResponse::MapKeyToCurrentProfileResponse ()  :
    _Result (::bosch::cm::profilePIVI::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MapKeyToCurrentProfileResponse::MapKeyToCurrentProfileResponse (const MapKeyToCurrentProfileResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _Result (::bosch::cm::profilePIVI::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MapKeyToCurrentProfileResponse::MapKeyToCurrentProfileResponse (serverResult Result_)  :
    _Result (Result_)
{
    #ifndef NDEBUG
    if (!(serverResult_IsValid(Result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Result_, "serverResult", "Result", "MapKeyToCurrentProfileResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MapKeyToCurrentProfileResponse::~MapKeyToCurrentProfileResponse() {
}

inline MapKeyToCurrentProfileResponse& MapKeyToCurrentProfileResponse::operator = (const MapKeyToCurrentProfileResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool MapKeyToCurrentProfileResponse::operator == (const MapKeyToCurrentProfileResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool MapKeyToCurrentProfileResponse::operator != (const MapKeyToCurrentProfileResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool MapKeyToCurrentProfileResponse::operator < (const MapKeyToCurrentProfileResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MapKeyToCurrentProfileResponse::clone() {
    return new MapKeyToCurrentProfileResponse(*this);
}

inline bool MapKeyToCurrentProfileResponse::operator > (const MapKeyToCurrentProfileResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MapKeyToCurrentProfileResponse::clear() {
    clearResult();
}

inline void MapKeyToCurrentProfileResponse::clearResult() {
    if (hasResult()) {
         clear_has_Result();
        _Result = ::bosch::cm::profilePIVI::serverResult__SUCCESS;
     }
}

inline bool MapKeyToCurrentProfileResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline serverResult MapKeyToCurrentProfileResponse::getResult () const {
    return _Result;
}

inline void MapKeyToCurrentProfileResponse::setResult (serverResult Result_) {
    #ifndef NDEBUG
    if (!(serverResult_IsValid(Result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Result_, "serverResult", "Result", "MapKeyToCurrentProfileResponse");
    }
    #endif
    set_has_Result();
    this->_Result = Result_;
}

inline void MapKeyToCurrentProfileResponse::set_has_Result () {
    _has_bits_[0] |= 1u << 0;
}

inline void MapKeyToCurrentProfileResponse::clear_has_Result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetWelcomeGuidanceActiveRequest::SetWelcomeGuidanceActiveRequest ()  :
    _userID (0u),
    _wgActive (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetWelcomeGuidanceActiveRequest::SetWelcomeGuidanceActiveRequest (const SetWelcomeGuidanceActiveRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _userID (0u),
    _wgActive (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetWelcomeGuidanceActiveRequest::SetWelcomeGuidanceActiveRequest (uint8 userID_, bool wgActive_)  :
    _userID (userID_),
    _wgActive (wgActive_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetWelcomeGuidanceActiveRequest::~SetWelcomeGuidanceActiveRequest() {
}

inline SetWelcomeGuidanceActiveRequest& SetWelcomeGuidanceActiveRequest::operator = (const SetWelcomeGuidanceActiveRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUserID()) {
            setUserID(rhs.getUserID());
        } else {
            clearUserID();
        }
        if (rhs.hasWgActive()) {
            setWgActive(rhs.getWgActive());
        } else {
            clearWgActive();
        }
    }
    return *this;
}

inline bool SetWelcomeGuidanceActiveRequest::operator == (const SetWelcomeGuidanceActiveRequest& rhs) const {
    return (((!hasUserID() && !rhs.hasUserID()) || getUserID() == rhs.getUserID()) &&
        ((!hasWgActive() && !rhs.hasWgActive()) || getWgActive() == rhs.getWgActive()));
}

inline bool SetWelcomeGuidanceActiveRequest::operator != (const SetWelcomeGuidanceActiveRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetWelcomeGuidanceActiveRequest::operator < (const SetWelcomeGuidanceActiveRequest& rhs) const {
    if (hasUserID() || rhs.hasUserID()) {
        if (getUserID() < rhs.getUserID()) return true;
        if (getUserID() > rhs.getUserID()) return false;
    }
    if (hasWgActive() || rhs.hasWgActive()) {
        if (getWgActive() < rhs.getWgActive()) return true;
        if (getWgActive() > rhs.getWgActive()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetWelcomeGuidanceActiveRequest::clone() {
    return new SetWelcomeGuidanceActiveRequest(*this);
}

inline bool SetWelcomeGuidanceActiveRequest::operator > (const SetWelcomeGuidanceActiveRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetWelcomeGuidanceActiveRequest::clear() {
    clearUserID();
    clearWgActive();
}

inline void SetWelcomeGuidanceActiveRequest::clearUserID() {
    if (hasUserID()) {
         clear_has_userID();
        _userID = 0u;
     }
}

inline bool SetWelcomeGuidanceActiveRequest::hasUserID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SetWelcomeGuidanceActiveRequest::getUserID () const {
    return _userID;
}

inline void SetWelcomeGuidanceActiveRequest::setUserID (uint8 userID_) {
    set_has_userID();
    this->_userID = userID_;
}

inline void SetWelcomeGuidanceActiveRequest::clearWgActive() {
    if (hasWgActive()) {
         clear_has_wgActive();
        _wgActive = false;
     }
}

inline bool SetWelcomeGuidanceActiveRequest::hasWgActive () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool SetWelcomeGuidanceActiveRequest::getWgActive () const {
    return _wgActive;
}

inline void SetWelcomeGuidanceActiveRequest::setWgActive (bool wgActive_) {
    set_has_wgActive();
    this->_wgActive = wgActive_;
}

inline void SetWelcomeGuidanceActiveRequest::set_has_userID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetWelcomeGuidanceActiveRequest::clear_has_userID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetWelcomeGuidanceActiveRequest::set_has_wgActive () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetWelcomeGuidanceActiveRequest::clear_has_wgActive () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetWelcomeGuidanceActiveResponse::SetWelcomeGuidanceActiveResponse ()  :
    _result (::bosch::cm::profilePIVI::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetWelcomeGuidanceActiveResponse::SetWelcomeGuidanceActiveResponse (const SetWelcomeGuidanceActiveResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (::bosch::cm::profilePIVI::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetWelcomeGuidanceActiveResponse::SetWelcomeGuidanceActiveResponse (serverResult result_)  :
    _result (result_)
{
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "SetWelcomeGuidanceActiveResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetWelcomeGuidanceActiveResponse::~SetWelcomeGuidanceActiveResponse() {
}

inline SetWelcomeGuidanceActiveResponse& SetWelcomeGuidanceActiveResponse::operator = (const SetWelcomeGuidanceActiveResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool SetWelcomeGuidanceActiveResponse::operator == (const SetWelcomeGuidanceActiveResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool SetWelcomeGuidanceActiveResponse::operator != (const SetWelcomeGuidanceActiveResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetWelcomeGuidanceActiveResponse::operator < (const SetWelcomeGuidanceActiveResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetWelcomeGuidanceActiveResponse::clone() {
    return new SetWelcomeGuidanceActiveResponse(*this);
}

inline bool SetWelcomeGuidanceActiveResponse::operator > (const SetWelcomeGuidanceActiveResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetWelcomeGuidanceActiveResponse::clear() {
    clearResult();
}

inline void SetWelcomeGuidanceActiveResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = ::bosch::cm::profilePIVI::serverResult__SUCCESS;
     }
}

inline bool SetWelcomeGuidanceActiveResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline serverResult SetWelcomeGuidanceActiveResponse::getResult () const {
    return _result;
}

inline void SetWelcomeGuidanceActiveResponse::setResult (serverResult result_) {
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "SetWelcomeGuidanceActiveResponse");
    }
    #endif
    set_has_result();
    this->_result = result_;
}

inline void SetWelcomeGuidanceActiveResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetWelcomeGuidanceActiveResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetLoginKeyLinkSettingRequest::SetLoginKeyLinkSettingRequest ()  :
    _loginKeyLinkSetting (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetLoginKeyLinkSettingRequest::SetLoginKeyLinkSettingRequest (const SetLoginKeyLinkSettingRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _loginKeyLinkSetting (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetLoginKeyLinkSettingRequest::SetLoginKeyLinkSettingRequest (bool loginKeyLinkSetting_)  :
    _loginKeyLinkSetting (loginKeyLinkSetting_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetLoginKeyLinkSettingRequest::~SetLoginKeyLinkSettingRequest() {
}

inline SetLoginKeyLinkSettingRequest& SetLoginKeyLinkSettingRequest::operator = (const SetLoginKeyLinkSettingRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasLoginKeyLinkSetting()) {
            setLoginKeyLinkSetting(rhs.getLoginKeyLinkSetting());
        } else {
            clearLoginKeyLinkSetting();
        }
    }
    return *this;
}

inline bool SetLoginKeyLinkSettingRequest::operator == (const SetLoginKeyLinkSettingRequest& rhs) const {
    return (((!hasLoginKeyLinkSetting() && !rhs.hasLoginKeyLinkSetting()) || getLoginKeyLinkSetting() == rhs.getLoginKeyLinkSetting()));
}

inline bool SetLoginKeyLinkSettingRequest::operator != (const SetLoginKeyLinkSettingRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetLoginKeyLinkSettingRequest::operator < (const SetLoginKeyLinkSettingRequest& rhs) const {
    if (hasLoginKeyLinkSetting() || rhs.hasLoginKeyLinkSetting()) {
        if (getLoginKeyLinkSetting() < rhs.getLoginKeyLinkSetting()) return true;
        if (getLoginKeyLinkSetting() > rhs.getLoginKeyLinkSetting()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetLoginKeyLinkSettingRequest::clone() {
    return new SetLoginKeyLinkSettingRequest(*this);
}

inline bool SetLoginKeyLinkSettingRequest::operator > (const SetLoginKeyLinkSettingRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetLoginKeyLinkSettingRequest::clear() {
    clearLoginKeyLinkSetting();
}

inline void SetLoginKeyLinkSettingRequest::clearLoginKeyLinkSetting() {
    if (hasLoginKeyLinkSetting()) {
         clear_has_loginKeyLinkSetting();
        _loginKeyLinkSetting = false;
     }
}

inline bool SetLoginKeyLinkSettingRequest::hasLoginKeyLinkSetting () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetLoginKeyLinkSettingRequest::getLoginKeyLinkSetting () const {
    return _loginKeyLinkSetting;
}

inline void SetLoginKeyLinkSettingRequest::setLoginKeyLinkSetting (bool loginKeyLinkSetting_) {
    set_has_loginKeyLinkSetting();
    this->_loginKeyLinkSetting = loginKeyLinkSetting_;
}

inline void SetLoginKeyLinkSettingRequest::set_has_loginKeyLinkSetting () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetLoginKeyLinkSettingRequest::clear_has_loginKeyLinkSetting () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetLoginKeyLinkSettingResponse::SetLoginKeyLinkSettingResponse ()  :
    _result (::bosch::cm::profilePIVI::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetLoginKeyLinkSettingResponse::SetLoginKeyLinkSettingResponse (const SetLoginKeyLinkSettingResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (::bosch::cm::profilePIVI::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetLoginKeyLinkSettingResponse::SetLoginKeyLinkSettingResponse (serverResult result_)  :
    _result (result_)
{
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "SetLoginKeyLinkSettingResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetLoginKeyLinkSettingResponse::~SetLoginKeyLinkSettingResponse() {
}

inline SetLoginKeyLinkSettingResponse& SetLoginKeyLinkSettingResponse::operator = (const SetLoginKeyLinkSettingResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool SetLoginKeyLinkSettingResponse::operator == (const SetLoginKeyLinkSettingResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool SetLoginKeyLinkSettingResponse::operator != (const SetLoginKeyLinkSettingResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetLoginKeyLinkSettingResponse::operator < (const SetLoginKeyLinkSettingResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetLoginKeyLinkSettingResponse::clone() {
    return new SetLoginKeyLinkSettingResponse(*this);
}

inline bool SetLoginKeyLinkSettingResponse::operator > (const SetLoginKeyLinkSettingResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetLoginKeyLinkSettingResponse::clear() {
    clearResult();
}

inline void SetLoginKeyLinkSettingResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = ::bosch::cm::profilePIVI::serverResult__SUCCESS;
     }
}

inline bool SetLoginKeyLinkSettingResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline serverResult SetLoginKeyLinkSettingResponse::getResult () const {
    return _result;
}

inline void SetLoginKeyLinkSettingResponse::setResult (serverResult result_) {
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "SetLoginKeyLinkSettingResponse");
    }
    #endif
    set_has_result();
    this->_result = result_;
}

inline void SetLoginKeyLinkSettingResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetLoginKeyLinkSettingResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetKeylistRequest::GetKeylistRequest ()  :
    _userID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetKeylistRequest::GetKeylistRequest (const GetKeylistRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _userID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetKeylistRequest::GetKeylistRequest (uint8 userID_)  :
    _userID (userID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetKeylistRequest::~GetKeylistRequest() {
}

inline GetKeylistRequest& GetKeylistRequest::operator = (const GetKeylistRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUserID()) {
            setUserID(rhs.getUserID());
        } else {
            clearUserID();
        }
    }
    return *this;
}

inline bool GetKeylistRequest::operator == (const GetKeylistRequest& rhs) const {
    return (((!hasUserID() && !rhs.hasUserID()) || getUserID() == rhs.getUserID()));
}

inline bool GetKeylistRequest::operator != (const GetKeylistRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool GetKeylistRequest::operator < (const GetKeylistRequest& rhs) const {
    if (hasUserID() || rhs.hasUserID()) {
        if (getUserID() < rhs.getUserID()) return true;
        if (getUserID() > rhs.getUserID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetKeylistRequest::clone() {
    return new GetKeylistRequest(*this);
}

inline bool GetKeylistRequest::operator > (const GetKeylistRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetKeylistRequest::clear() {
    clearUserID();
}

inline void GetKeylistRequest::clearUserID() {
    if (hasUserID()) {
         clear_has_userID();
        _userID = 0u;
     }
}

inline bool GetKeylistRequest::hasUserID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GetKeylistRequest::getUserID () const {
    return _userID;
}

inline void GetKeylistRequest::setUserID (uint8 userID_) {
    set_has_userID();
    this->_userID = userID_;
}

inline void GetKeylistRequest::set_has_userID () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetKeylistRequest::clear_has_userID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetKeylistResponse::GetKeylistResponse ()  :
    _keylist ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetKeylistResponse::GetKeylistResponse (const GetKeylistResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _keylist ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetKeylistResponse::GetKeylistResponse (const ::std::vector< uint8 >& keylist_)  :
    _keylist (keylist_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetKeylistResponse::~GetKeylistResponse() {
}

inline GetKeylistResponse& GetKeylistResponse::operator = (const GetKeylistResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasKeylist()) {
            setKeylist(rhs.getKeylist());
        } else {
            clearKeylist();
        }
    }
    return *this;
}

inline bool GetKeylistResponse::operator == (const GetKeylistResponse& rhs) const {
    return (((!hasKeylist() && !rhs.hasKeylist()) || getKeylist() == rhs.getKeylist()));
}

inline bool GetKeylistResponse::operator != (const GetKeylistResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetKeylistResponse::operator < (const GetKeylistResponse& rhs) const {
    if (hasKeylist() || rhs.hasKeylist()) {
        if (getKeylist() < rhs.getKeylist()) return true;
        if (getKeylist() > rhs.getKeylist()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetKeylistResponse::clone() {
    return new GetKeylistResponse(*this);
}

inline bool GetKeylistResponse::operator > (const GetKeylistResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetKeylistResponse::clear() {
    clearKeylist();
}

inline void GetKeylistResponse::clearKeylist() {
    if (hasKeylist()) {
         clear_has_keylist();
        _keylist.clear();
     }
}

inline bool GetKeylistResponse::hasKeylist () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& GetKeylistResponse::getKeylist () const {
    return _keylist;
}

inline ::std::vector< uint8 >& GetKeylistResponse::getKeylistMutable () {
    set_has_keylist();
    return _keylist;
}

inline void GetKeylistResponse::setKeylist (const ::std::vector< uint8 >& keylist_) {
    set_has_keylist();
    this->_keylist = keylist_;
}

inline void GetKeylistResponse::set_has_keylist () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetKeylistResponse::clear_has_keylist () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  KeyIsMappedUpdate::KeyIsMappedUpdate ()  :
    _keyIsMapped (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  KeyIsMappedUpdate::KeyIsMappedUpdate (const KeyIsMappedUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _keyIsMapped (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  KeyIsMappedUpdate::KeyIsMappedUpdate (bool keyIsMapped_)  :
    _keyIsMapped (keyIsMapped_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  KeyIsMappedUpdate::~KeyIsMappedUpdate() {
}

inline KeyIsMappedUpdate& KeyIsMappedUpdate::operator = (const KeyIsMappedUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasKeyIsMapped()) {
            setKeyIsMapped(rhs.getKeyIsMapped());
        } else {
            clearKeyIsMapped();
        }
    }
    return *this;
}

inline bool KeyIsMappedUpdate::operator == (const KeyIsMappedUpdate& rhs) const {
    return (((!hasKeyIsMapped() && !rhs.hasKeyIsMapped()) || getKeyIsMapped() == rhs.getKeyIsMapped()));
}

inline bool KeyIsMappedUpdate::operator != (const KeyIsMappedUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool KeyIsMappedUpdate::operator < (const KeyIsMappedUpdate& rhs) const {
    if (hasKeyIsMapped() || rhs.hasKeyIsMapped()) {
        if (getKeyIsMapped() < rhs.getKeyIsMapped()) return true;
        if (getKeyIsMapped() > rhs.getKeyIsMapped()) return false;
    }
    return false;
}

inline ::asf::core::Payload* KeyIsMappedUpdate::clone() {
    return new KeyIsMappedUpdate(*this);
}

inline bool KeyIsMappedUpdate::operator > (const KeyIsMappedUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void KeyIsMappedUpdate::clear() {
    clearKeyIsMapped();
}

inline void KeyIsMappedUpdate::clearKeyIsMapped() {
    if (hasKeyIsMapped()) {
         clear_has_keyIsMapped();
        _keyIsMapped = false;
     }
}

inline bool KeyIsMappedUpdate::hasKeyIsMapped () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool KeyIsMappedUpdate::getKeyIsMapped () const {
    return _keyIsMapped;
}

inline void KeyIsMappedUpdate::setKeyIsMapped (bool keyIsMapped_) {
    set_has_keyIsMapped();
    this->_keyIsMapped = keyIsMapped_;
}

inline void KeyIsMappedUpdate::set_has_keyIsMapped () {
    _has_bits_[0] |= 1u << 0;
}

inline void KeyIsMappedUpdate::clear_has_keyIsMapped () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  KeyIsMappedRegister::KeyIsMappedRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  KeyIsMappedRegister::KeyIsMappedRegister (const KeyIsMappedRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  KeyIsMappedRegister::~KeyIsMappedRegister() {
}

inline KeyIsMappedRegister& KeyIsMappedRegister::operator = (const KeyIsMappedRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool KeyIsMappedRegister::operator == (const KeyIsMappedRegister& ) const {
    return true;
}

inline bool KeyIsMappedRegister::operator != (const KeyIsMappedRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool KeyIsMappedRegister::operator < (const KeyIsMappedRegister& ) const {
    return false;
}

inline ::asf::core::Payload* KeyIsMappedRegister::clone() {
    return new KeyIsMappedRegister(*this);
}

inline bool KeyIsMappedRegister::operator > (const KeyIsMappedRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void KeyIsMappedRegister::clear() {
}

inline  KeyMappingPossibleUpdate::KeyMappingPossibleUpdate ()  :
    _keyMappingPossible (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  KeyMappingPossibleUpdate::KeyMappingPossibleUpdate (const KeyMappingPossibleUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _keyMappingPossible (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  KeyMappingPossibleUpdate::KeyMappingPossibleUpdate (bool keyMappingPossible_)  :
    _keyMappingPossible (keyMappingPossible_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  KeyMappingPossibleUpdate::~KeyMappingPossibleUpdate() {
}

inline KeyMappingPossibleUpdate& KeyMappingPossibleUpdate::operator = (const KeyMappingPossibleUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasKeyMappingPossible()) {
            setKeyMappingPossible(rhs.getKeyMappingPossible());
        } else {
            clearKeyMappingPossible();
        }
    }
    return *this;
}

inline bool KeyMappingPossibleUpdate::operator == (const KeyMappingPossibleUpdate& rhs) const {
    return (((!hasKeyMappingPossible() && !rhs.hasKeyMappingPossible()) || getKeyMappingPossible() == rhs.getKeyMappingPossible()));
}

inline bool KeyMappingPossibleUpdate::operator != (const KeyMappingPossibleUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool KeyMappingPossibleUpdate::operator < (const KeyMappingPossibleUpdate& rhs) const {
    if (hasKeyMappingPossible() || rhs.hasKeyMappingPossible()) {
        if (getKeyMappingPossible() < rhs.getKeyMappingPossible()) return true;
        if (getKeyMappingPossible() > rhs.getKeyMappingPossible()) return false;
    }
    return false;
}

inline ::asf::core::Payload* KeyMappingPossibleUpdate::clone() {
    return new KeyMappingPossibleUpdate(*this);
}

inline bool KeyMappingPossibleUpdate::operator > (const KeyMappingPossibleUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void KeyMappingPossibleUpdate::clear() {
    clearKeyMappingPossible();
}

inline void KeyMappingPossibleUpdate::clearKeyMappingPossible() {
    if (hasKeyMappingPossible()) {
         clear_has_keyMappingPossible();
        _keyMappingPossible = false;
     }
}

inline bool KeyMappingPossibleUpdate::hasKeyMappingPossible () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool KeyMappingPossibleUpdate::getKeyMappingPossible () const {
    return _keyMappingPossible;
}

inline void KeyMappingPossibleUpdate::setKeyMappingPossible (bool keyMappingPossible_) {
    set_has_keyMappingPossible();
    this->_keyMappingPossible = keyMappingPossible_;
}

inline void KeyMappingPossibleUpdate::set_has_keyMappingPossible () {
    _has_bits_[0] |= 1u << 0;
}

inline void KeyMappingPossibleUpdate::clear_has_keyMappingPossible () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  KeyMappingPossibleRegister::KeyMappingPossibleRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  KeyMappingPossibleRegister::KeyMappingPossibleRegister (const KeyMappingPossibleRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  KeyMappingPossibleRegister::~KeyMappingPossibleRegister() {
}

inline KeyMappingPossibleRegister& KeyMappingPossibleRegister::operator = (const KeyMappingPossibleRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool KeyMappingPossibleRegister::operator == (const KeyMappingPossibleRegister& ) const {
    return true;
}

inline bool KeyMappingPossibleRegister::operator != (const KeyMappingPossibleRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool KeyMappingPossibleRegister::operator < (const KeyMappingPossibleRegister& ) const {
    return false;
}

inline ::asf::core::Payload* KeyMappingPossibleRegister::clone() {
    return new KeyMappingPossibleRegister(*this);
}

inline bool KeyMappingPossibleRegister::operator > (const KeyMappingPossibleRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void KeyMappingPossibleRegister::clear() {
}

inline  KeyIDUpdate::KeyIDUpdate ()  :
    _keyID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  KeyIDUpdate::KeyIDUpdate (const KeyIDUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _keyID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  KeyIDUpdate::KeyIDUpdate (uint32 keyID_)  :
    _keyID (keyID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  KeyIDUpdate::~KeyIDUpdate() {
}

inline KeyIDUpdate& KeyIDUpdate::operator = (const KeyIDUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasKeyID()) {
            setKeyID(rhs.getKeyID());
        } else {
            clearKeyID();
        }
    }
    return *this;
}

inline bool KeyIDUpdate::operator == (const KeyIDUpdate& rhs) const {
    return (((!hasKeyID() && !rhs.hasKeyID()) || getKeyID() == rhs.getKeyID()));
}

inline bool KeyIDUpdate::operator != (const KeyIDUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool KeyIDUpdate::operator < (const KeyIDUpdate& rhs) const {
    if (hasKeyID() || rhs.hasKeyID()) {
        if (getKeyID() < rhs.getKeyID()) return true;
        if (getKeyID() > rhs.getKeyID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* KeyIDUpdate::clone() {
    return new KeyIDUpdate(*this);
}

inline bool KeyIDUpdate::operator > (const KeyIDUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void KeyIDUpdate::clear() {
    clearKeyID();
}

inline void KeyIDUpdate::clearKeyID() {
    if (hasKeyID()) {
         clear_has_keyID();
        _keyID = 0u;
     }
}

inline bool KeyIDUpdate::hasKeyID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 KeyIDUpdate::getKeyID () const {
    return _keyID;
}

inline void KeyIDUpdate::setKeyID (uint32 keyID_) {
    set_has_keyID();
    this->_keyID = keyID_;
}

inline void KeyIDUpdate::set_has_keyID () {
    _has_bits_[0] |= 1u << 0;
}

inline void KeyIDUpdate::clear_has_keyID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  KeyIDRegister::KeyIDRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  KeyIDRegister::KeyIDRegister (const KeyIDRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  KeyIDRegister::~KeyIDRegister() {
}

inline KeyIDRegister& KeyIDRegister::operator = (const KeyIDRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool KeyIDRegister::operator == (const KeyIDRegister& ) const {
    return true;
}

inline bool KeyIDRegister::operator != (const KeyIDRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool KeyIDRegister::operator < (const KeyIDRegister& ) const {
    return false;
}

inline ::asf::core::Payload* KeyIDRegister::clone() {
    return new KeyIDRegister(*this);
}

inline bool KeyIDRegister::operator > (const KeyIDRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void KeyIDRegister::clear() {
}

inline  ProfilekeyIIndexUpdate::ProfilekeyIIndexUpdate ()  :
    _ProfilekeyIIndex (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProfilekeyIIndexUpdate::ProfilekeyIIndexUpdate (const ProfilekeyIIndexUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _ProfilekeyIIndex (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProfilekeyIIndexUpdate::ProfilekeyIIndexUpdate (uint8 ProfilekeyIIndex_)  :
    _ProfilekeyIIndex (ProfilekeyIIndex_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ProfilekeyIIndexUpdate::~ProfilekeyIIndexUpdate() {
}

inline ProfilekeyIIndexUpdate& ProfilekeyIIndexUpdate::operator = (const ProfilekeyIIndexUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProfilekeyIIndex()) {
            setProfilekeyIIndex(rhs.getProfilekeyIIndex());
        } else {
            clearProfilekeyIIndex();
        }
    }
    return *this;
}

inline bool ProfilekeyIIndexUpdate::operator == (const ProfilekeyIIndexUpdate& rhs) const {
    return (((!hasProfilekeyIIndex() && !rhs.hasProfilekeyIIndex()) || getProfilekeyIIndex() == rhs.getProfilekeyIIndex()));
}

inline bool ProfilekeyIIndexUpdate::operator != (const ProfilekeyIIndexUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ProfilekeyIIndexUpdate::operator < (const ProfilekeyIIndexUpdate& rhs) const {
    if (hasProfilekeyIIndex() || rhs.hasProfilekeyIIndex()) {
        if (getProfilekeyIIndex() < rhs.getProfilekeyIIndex()) return true;
        if (getProfilekeyIIndex() > rhs.getProfilekeyIIndex()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ProfilekeyIIndexUpdate::clone() {
    return new ProfilekeyIIndexUpdate(*this);
}

inline bool ProfilekeyIIndexUpdate::operator > (const ProfilekeyIIndexUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProfilekeyIIndexUpdate::clear() {
    clearProfilekeyIIndex();
}

inline void ProfilekeyIIndexUpdate::clearProfilekeyIIndex() {
    if (hasProfilekeyIIndex()) {
         clear_has_ProfilekeyIIndex();
        _ProfilekeyIIndex = 0u;
     }
}

inline bool ProfilekeyIIndexUpdate::hasProfilekeyIIndex () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 ProfilekeyIIndexUpdate::getProfilekeyIIndex () const {
    return _ProfilekeyIIndex;
}

inline void ProfilekeyIIndexUpdate::setProfilekeyIIndex (uint8 ProfilekeyIIndex_) {
    set_has_ProfilekeyIIndex();
    this->_ProfilekeyIIndex = ProfilekeyIIndex_;
}

inline void ProfilekeyIIndexUpdate::set_has_ProfilekeyIIndex () {
    _has_bits_[0] |= 1u << 0;
}

inline void ProfilekeyIIndexUpdate::clear_has_ProfilekeyIIndex () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ProfilekeyIIndexRegister::ProfilekeyIIndexRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProfilekeyIIndexRegister::ProfilekeyIIndexRegister (const ProfilekeyIIndexRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProfilekeyIIndexRegister::~ProfilekeyIIndexRegister() {
}

inline ProfilekeyIIndexRegister& ProfilekeyIIndexRegister::operator = (const ProfilekeyIIndexRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ProfilekeyIIndexRegister::operator == (const ProfilekeyIIndexRegister& ) const {
    return true;
}

inline bool ProfilekeyIIndexRegister::operator != (const ProfilekeyIIndexRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ProfilekeyIIndexRegister::operator < (const ProfilekeyIIndexRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ProfilekeyIIndexRegister::clone() {
    return new ProfilekeyIIndexRegister(*this);
}

inline bool ProfilekeyIIndexRegister::operator > (const ProfilekeyIIndexRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProfilekeyIIndexRegister::clear() {
}

inline  WelcomeGuidanceActiveUpdate::WelcomeGuidanceActiveUpdate ()  :
    _welcomeGuidanceActive (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WelcomeGuidanceActiveUpdate::WelcomeGuidanceActiveUpdate (const WelcomeGuidanceActiveUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _welcomeGuidanceActive (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WelcomeGuidanceActiveUpdate::WelcomeGuidanceActiveUpdate (bool welcomeGuidanceActive_)  :
    _welcomeGuidanceActive (welcomeGuidanceActive_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  WelcomeGuidanceActiveUpdate::~WelcomeGuidanceActiveUpdate() {
}

inline WelcomeGuidanceActiveUpdate& WelcomeGuidanceActiveUpdate::operator = (const WelcomeGuidanceActiveUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasWelcomeGuidanceActive()) {
            setWelcomeGuidanceActive(rhs.getWelcomeGuidanceActive());
        } else {
            clearWelcomeGuidanceActive();
        }
    }
    return *this;
}

inline bool WelcomeGuidanceActiveUpdate::operator == (const WelcomeGuidanceActiveUpdate& rhs) const {
    return (((!hasWelcomeGuidanceActive() && !rhs.hasWelcomeGuidanceActive()) || getWelcomeGuidanceActive() == rhs.getWelcomeGuidanceActive()));
}

inline bool WelcomeGuidanceActiveUpdate::operator != (const WelcomeGuidanceActiveUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool WelcomeGuidanceActiveUpdate::operator < (const WelcomeGuidanceActiveUpdate& rhs) const {
    if (hasWelcomeGuidanceActive() || rhs.hasWelcomeGuidanceActive()) {
        if (getWelcomeGuidanceActive() < rhs.getWelcomeGuidanceActive()) return true;
        if (getWelcomeGuidanceActive() > rhs.getWelcomeGuidanceActive()) return false;
    }
    return false;
}

inline ::asf::core::Payload* WelcomeGuidanceActiveUpdate::clone() {
    return new WelcomeGuidanceActiveUpdate(*this);
}

inline bool WelcomeGuidanceActiveUpdate::operator > (const WelcomeGuidanceActiveUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WelcomeGuidanceActiveUpdate::clear() {
    clearWelcomeGuidanceActive();
}

inline void WelcomeGuidanceActiveUpdate::clearWelcomeGuidanceActive() {
    if (hasWelcomeGuidanceActive()) {
         clear_has_welcomeGuidanceActive();
        _welcomeGuidanceActive = false;
     }
}

inline bool WelcomeGuidanceActiveUpdate::hasWelcomeGuidanceActive () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool WelcomeGuidanceActiveUpdate::getWelcomeGuidanceActive () const {
    return _welcomeGuidanceActive;
}

inline void WelcomeGuidanceActiveUpdate::setWelcomeGuidanceActive (bool welcomeGuidanceActive_) {
    set_has_welcomeGuidanceActive();
    this->_welcomeGuidanceActive = welcomeGuidanceActive_;
}

inline void WelcomeGuidanceActiveUpdate::set_has_welcomeGuidanceActive () {
    _has_bits_[0] |= 1u << 0;
}

inline void WelcomeGuidanceActiveUpdate::clear_has_welcomeGuidanceActive () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  WelcomeGuidanceActiveRegister::WelcomeGuidanceActiveRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WelcomeGuidanceActiveRegister::WelcomeGuidanceActiveRegister (const WelcomeGuidanceActiveRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WelcomeGuidanceActiveRegister::~WelcomeGuidanceActiveRegister() {
}

inline WelcomeGuidanceActiveRegister& WelcomeGuidanceActiveRegister::operator = (const WelcomeGuidanceActiveRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool WelcomeGuidanceActiveRegister::operator == (const WelcomeGuidanceActiveRegister& ) const {
    return true;
}

inline bool WelcomeGuidanceActiveRegister::operator != (const WelcomeGuidanceActiveRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool WelcomeGuidanceActiveRegister::operator < (const WelcomeGuidanceActiveRegister& ) const {
    return false;
}

inline ::asf::core::Payload* WelcomeGuidanceActiveRegister::clone() {
    return new WelcomeGuidanceActiveRegister(*this);
}

inline bool WelcomeGuidanceActiveRegister::operator > (const WelcomeGuidanceActiveRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WelcomeGuidanceActiveRegister::clear() {
}

inline  LoginKeyLinkStatusUpdate::LoginKeyLinkStatusUpdate ()  :
    _loginKeyLinkStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LoginKeyLinkStatusUpdate::LoginKeyLinkStatusUpdate (const LoginKeyLinkStatusUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _loginKeyLinkStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LoginKeyLinkStatusUpdate::LoginKeyLinkStatusUpdate (bool loginKeyLinkStatus_)  :
    _loginKeyLinkStatus (loginKeyLinkStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LoginKeyLinkStatusUpdate::~LoginKeyLinkStatusUpdate() {
}

inline LoginKeyLinkStatusUpdate& LoginKeyLinkStatusUpdate::operator = (const LoginKeyLinkStatusUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasLoginKeyLinkStatus()) {
            setLoginKeyLinkStatus(rhs.getLoginKeyLinkStatus());
        } else {
            clearLoginKeyLinkStatus();
        }
    }
    return *this;
}

inline bool LoginKeyLinkStatusUpdate::operator == (const LoginKeyLinkStatusUpdate& rhs) const {
    return (((!hasLoginKeyLinkStatus() && !rhs.hasLoginKeyLinkStatus()) || getLoginKeyLinkStatus() == rhs.getLoginKeyLinkStatus()));
}

inline bool LoginKeyLinkStatusUpdate::operator != (const LoginKeyLinkStatusUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool LoginKeyLinkStatusUpdate::operator < (const LoginKeyLinkStatusUpdate& rhs) const {
    if (hasLoginKeyLinkStatus() || rhs.hasLoginKeyLinkStatus()) {
        if (getLoginKeyLinkStatus() < rhs.getLoginKeyLinkStatus()) return true;
        if (getLoginKeyLinkStatus() > rhs.getLoginKeyLinkStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LoginKeyLinkStatusUpdate::clone() {
    return new LoginKeyLinkStatusUpdate(*this);
}

inline bool LoginKeyLinkStatusUpdate::operator > (const LoginKeyLinkStatusUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LoginKeyLinkStatusUpdate::clear() {
    clearLoginKeyLinkStatus();
}

inline void LoginKeyLinkStatusUpdate::clearLoginKeyLinkStatus() {
    if (hasLoginKeyLinkStatus()) {
         clear_has_loginKeyLinkStatus();
        _loginKeyLinkStatus = false;
     }
}

inline bool LoginKeyLinkStatusUpdate::hasLoginKeyLinkStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool LoginKeyLinkStatusUpdate::getLoginKeyLinkStatus () const {
    return _loginKeyLinkStatus;
}

inline void LoginKeyLinkStatusUpdate::setLoginKeyLinkStatus (bool loginKeyLinkStatus_) {
    set_has_loginKeyLinkStatus();
    this->_loginKeyLinkStatus = loginKeyLinkStatus_;
}

inline void LoginKeyLinkStatusUpdate::set_has_loginKeyLinkStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void LoginKeyLinkStatusUpdate::clear_has_loginKeyLinkStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  LoginKeyLinkStatusRegister::LoginKeyLinkStatusRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LoginKeyLinkStatusRegister::LoginKeyLinkStatusRegister (const LoginKeyLinkStatusRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LoginKeyLinkStatusRegister::~LoginKeyLinkStatusRegister() {
}

inline LoginKeyLinkStatusRegister& LoginKeyLinkStatusRegister::operator = (const LoginKeyLinkStatusRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool LoginKeyLinkStatusRegister::operator == (const LoginKeyLinkStatusRegister& ) const {
    return true;
}

inline bool LoginKeyLinkStatusRegister::operator != (const LoginKeyLinkStatusRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool LoginKeyLinkStatusRegister::operator < (const LoginKeyLinkStatusRegister& ) const {
    return false;
}

inline ::asf::core::Payload* LoginKeyLinkStatusRegister::clone() {
    return new LoginKeyLinkStatusRegister(*this);
}

inline bool LoginKeyLinkStatusRegister::operator > (const LoginKeyLinkStatusRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LoginKeyLinkStatusRegister::clear() {
}

inline  IsStartupSequenceUpdate::IsStartupSequenceUpdate ()  :
    _IsStartupSequence (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  IsStartupSequenceUpdate::IsStartupSequenceUpdate (const IsStartupSequenceUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _IsStartupSequence (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  IsStartupSequenceUpdate::IsStartupSequenceUpdate (bool IsStartupSequence_)  :
    _IsStartupSequence (IsStartupSequence_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  IsStartupSequenceUpdate::~IsStartupSequenceUpdate() {
}

inline IsStartupSequenceUpdate& IsStartupSequenceUpdate::operator = (const IsStartupSequenceUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasIsStartupSequence()) {
            setIsStartupSequence(rhs.getIsStartupSequence());
        } else {
            clearIsStartupSequence();
        }
    }
    return *this;
}

inline bool IsStartupSequenceUpdate::operator == (const IsStartupSequenceUpdate& rhs) const {
    return (((!hasIsStartupSequence() && !rhs.hasIsStartupSequence()) || getIsStartupSequence() == rhs.getIsStartupSequence()));
}

inline bool IsStartupSequenceUpdate::operator != (const IsStartupSequenceUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool IsStartupSequenceUpdate::operator < (const IsStartupSequenceUpdate& rhs) const {
    if (hasIsStartupSequence() || rhs.hasIsStartupSequence()) {
        if (getIsStartupSequence() < rhs.getIsStartupSequence()) return true;
        if (getIsStartupSequence() > rhs.getIsStartupSequence()) return false;
    }
    return false;
}

inline ::asf::core::Payload* IsStartupSequenceUpdate::clone() {
    return new IsStartupSequenceUpdate(*this);
}

inline bool IsStartupSequenceUpdate::operator > (const IsStartupSequenceUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void IsStartupSequenceUpdate::clear() {
    clearIsStartupSequence();
}

inline void IsStartupSequenceUpdate::clearIsStartupSequence() {
    if (hasIsStartupSequence()) {
         clear_has_IsStartupSequence();
        _IsStartupSequence = false;
     }
}

inline bool IsStartupSequenceUpdate::hasIsStartupSequence () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool IsStartupSequenceUpdate::getIsStartupSequence () const {
    return _IsStartupSequence;
}

inline void IsStartupSequenceUpdate::setIsStartupSequence (bool IsStartupSequence_) {
    set_has_IsStartupSequence();
    this->_IsStartupSequence = IsStartupSequence_;
}

inline void IsStartupSequenceUpdate::set_has_IsStartupSequence () {
    _has_bits_[0] |= 1u << 0;
}

inline void IsStartupSequenceUpdate::clear_has_IsStartupSequence () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  IsStartupSequenceRegister::IsStartupSequenceRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  IsStartupSequenceRegister::IsStartupSequenceRegister (const IsStartupSequenceRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  IsStartupSequenceRegister::~IsStartupSequenceRegister() {
}

inline IsStartupSequenceRegister& IsStartupSequenceRegister::operator = (const IsStartupSequenceRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool IsStartupSequenceRegister::operator == (const IsStartupSequenceRegister& ) const {
    return true;
}

inline bool IsStartupSequenceRegister::operator != (const IsStartupSequenceRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool IsStartupSequenceRegister::operator < (const IsStartupSequenceRegister& ) const {
    return false;
}

inline ::asf::core::Payload* IsStartupSequenceRegister::clone() {
    return new IsStartupSequenceRegister(*this);
}

inline bool IsStartupSequenceRegister::operator > (const IsStartupSequenceRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void IsStartupSequenceRegister::clear() {
}

} // namespace profilePIVI
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_PROFILEPIVI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
