/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_PROFILESTUB_H
#define BOSCH_CM_PROFILESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/profile.h"
#include "bosch/cm/profileConst.h"
#include <string>
#include <vector>

namespace bosch {
namespace cm {
namespace profile {

class ProfileStubDelegate;

class ProfileStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the ProfileStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    ProfileStub (const std::string& portName);

    /**
     * Create an instance of the ProfileStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    ProfileStub (const std::string& portName, const std::string& objectPath);

    virtual ~ProfileStub();

    // property 'activeProfile'

    /**
     * The method onActiveProfileGet() is called by ASF when a client invokes
     * the read method for the property 'activeProfile'. The
     * onActiveProfileGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'activeProfile'</b>:
     *
     * current user Profile. Updated only on user change.
     */
    virtual void onActiveProfileGet(const ::boost::shared_ptr< ActiveProfileGet >& payload);

    /**
     * Sends back the update to a previous onActiveProfileGet().
     *
     * <b>Documentation of 'activeProfile'</b>:
     *
     * current user Profile. Updated only on user change.
     *
     * @param act Identifies a previous invocation of onActiveProfileGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendActiveProfileGetUpdate(uint8 activeProfile, act_t act = 0);

    /**
     * Set the value of the property 'activeProfile' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'activeProfile'</b>:
     *
     * current user Profile. Updated only on user change.
     */
    void setActiveProfile(uint8 activeProfile);

    /**
     * Returns the current value of the property 'activeProfile'.
     *
     * <b>Documentation of 'activeProfile'</b>:
     *
     * current user Profile. Updated only on user change.
     */
    uint8 getActiveProfile() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendActiveProfileUpdate().
     *
     * <b>Documentation of 'activeProfile'</b>:
     *
     * current user Profile. Updated only on user change.
     */
    void sendActiveProfileUpdate();

    // property 'status'

    /**
     * The method onStatusGet() is called by ASF when a client invokes the
     * read method for the property 'status'. The onStatusGet() method returns
     * by default the current property value to the caller. In case this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'status'</b>:
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     */
    virtual void onStatusGet(const ::boost::shared_ptr< StatusGet >& payload);

    /**
     * Sends back the update to a previous onStatusGet().
     *
     * <b>Documentation of 'status'</b>:
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onStatusGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendStatusGetUpdate(ProfileStatus status, act_t act = 0);

    /**
     * Set the value of the property 'status' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'status'</b>:
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     */
    void setStatus(ProfileStatus status);

    /**
     * Returns the current value of the property 'status'.
     *
     * <b>Documentation of 'status'</b>:
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     */
    ProfileStatus getStatus() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendStatusUpdate().
     *
     * <b>Documentation of 'status'</b>:
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     */
    void sendStatusUpdate();

    // property 'copyProfile'

    /**
     * The method onCopyProfileGet() is called by ASF when a client invokes
     * the read method for the property 'copyProfile'. The onCopyProfileGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'copyProfile'</b>:
     *
     * If the meaning of "copyProfile" isn't clear, then there should be a description here.
     */
    virtual void onCopyProfileGet(const ::boost::shared_ptr< CopyProfileGet >& payload);

    /**
     * Sends back the update to a previous onCopyProfileGet().
     *
     * <b>Documentation of 'copyProfile'</b>:
     *
     * If the meaning of "copyProfile" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onCopyProfileGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCopyProfileGetUpdate(const copyInfo& copyProfile, act_t act = 0);

    /**
     * Set the value of the property 'copyProfile' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'copyProfile'</b>:
     *
     * If the meaning of "copyProfile" isn't clear, then there should be a description here.
     */
    void setCopyProfile(const copyInfo& copyProfile);

    /**
     * Returns the current value of the property 'copyProfile'.
     *
     * <b>Documentation of 'copyProfile'</b>:
     *
     * If the meaning of "copyProfile" isn't clear, then there should be a description here.
     */
    const copyInfo& getCopyProfile() const;

    /**
     * Returns the current value of the property 'copyProfile' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendCopyProfileUpdate() method.
     *
     * <b>Documentation of 'copyProfile'</b>:
     *
     * If the meaning of "copyProfile" isn't clear, then there should be a description here.
     */
    copyInfo& getCopyProfileMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCopyProfileUpdate().
     *
     * <b>Documentation of 'copyProfile'</b>:
     *
     * If the meaning of "copyProfile" isn't clear, then there should be a description here.
     */
    void sendCopyProfileUpdate();

    // property 'deleteProfile'

    /**
     * The method onDeleteProfileGet() is called by ASF when a client invokes
     * the read method for the property 'deleteProfile'. The
     * onDeleteProfileGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'deleteProfile'</b>:
     *
     * Profile is to be Deleted (values to be overwritten with Default values)
     */
    virtual void onDeleteProfileGet(const ::boost::shared_ptr< DeleteProfileGet >& payload);

    /**
     * Sends back the update to a previous onDeleteProfileGet().
     *
     * <b>Documentation of 'deleteProfile'</b>:
     *
     * Profile is to be Deleted (values to be overwritten with Default values)
     *
     * @param act Identifies a previous invocation of onDeleteProfileGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDeleteProfileGetUpdate(uint8 deleteProfile, act_t act = 0);

    /**
     * Set the value of the property 'deleteProfile' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'deleteProfile'</b>:
     *
     * Profile is to be Deleted (values to be overwritten with Default values)
     */
    void setDeleteProfile(uint8 deleteProfile);

    /**
     * Returns the current value of the property 'deleteProfile'.
     *
     * <b>Documentation of 'deleteProfile'</b>:
     *
     * Profile is to be Deleted (values to be overwritten with Default values)
     */
    uint8 getDeleteProfile() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDeleteProfileUpdate().
     *
     * <b>Documentation of 'deleteProfile'</b>:
     *
     * Profile is to be Deleted (values to be overwritten with Default values)
     */
    void sendDeleteProfileUpdate();

    // property 'dataChanged'

    /**
     * The method onDataChangedGet() is called by ASF when a client invokes
     * the read method for the property 'dataChanged'. The onDataChangedGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'dataChanged'</b>:
     *
     * Download marker will be set to true, if upload / downlaod is in progress Application should not accept value changes, while this attribute is true
     */
    virtual void onDataChangedGet(const ::boost::shared_ptr< DataChangedGet >& payload);

    /**
     * Sends back the update to a previous onDataChangedGet().
     *
     * <b>Documentation of 'dataChanged'</b>:
     *
     * Download marker will be set to true, if upload / downlaod is in progress Application should not accept value changes, while this attribute is true
     *
     * @param act Identifies a previous invocation of onDataChangedGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDataChangedGetUpdate(dataChangeReason dataChanged, act_t act = 0);

    /**
     * Set the value of the property 'dataChanged' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'dataChanged'</b>:
     *
     * Download marker will be set to true, if upload / downlaod is in progress Application should not accept value changes, while this attribute is true
     */
    void setDataChanged(dataChangeReason dataChanged);

    /**
     * Returns the current value of the property 'dataChanged'.
     *
     * <b>Documentation of 'dataChanged'</b>:
     *
     * Download marker will be set to true, if upload / downlaod is in progress Application should not accept value changes, while this attribute is true
     */
    dataChangeReason getDataChanged() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDataChangedUpdate().
     *
     * <b>Documentation of 'dataChanged'</b>:
     *
     * Download marker will be set to true, if upload / downlaod is in progress Application should not accept value changes, while this attribute is true
     */
    void sendDataChangedUpdate();

    // property 'createProfile'

    /**
     * The method onCreateProfileGet() is called by ASF when a client invokes
     * the read method for the property 'createProfile'. The
     * onCreateProfileGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'createProfile'</b>:
     *
     * New Profile to be created(values to be overwritten with Default values)
     */
    virtual void onCreateProfileGet(const ::boost::shared_ptr< CreateProfileGet >& payload);

    /**
     * Sends back the update to a previous onCreateProfileGet().
     *
     * <b>Documentation of 'createProfile'</b>:
     *
     * New Profile to be created(values to be overwritten with Default values)
     *
     * @param act Identifies a previous invocation of onCreateProfileGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCreateProfileGetUpdate(uint8 createProfile, act_t act = 0);

    /**
     * Set the value of the property 'createProfile' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'createProfile'</b>:
     *
     * New Profile to be created(values to be overwritten with Default values)
     */
    void setCreateProfile(uint8 createProfile);

    /**
     * Returns the current value of the property 'createProfile'.
     *
     * <b>Documentation of 'createProfile'</b>:
     *
     * New Profile to be created(values to be overwritten with Default values)
     */
    uint8 getCreateProfile() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCreateProfileUpdate().
     *
     * <b>Documentation of 'createProfile'</b>:
     *
     * New Profile to be created(values to be overwritten with Default values)
     */
    void sendCreateProfileUpdate();

    // property 'privacyMode'

    /**
     * The method onPrivacyModeGet() is called by ASF when a client invokes
     * the read method for the property 'privacyMode'. The onPrivacyModeGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'privacyMode'</b>:
     *
     * Privacy mode flag for scope 2.1 treated as one boolean, for 3.0 as 32 booleans (0: privacy mode off, 1:Privacy mode On)
     */
    virtual void onPrivacyModeGet(const ::boost::shared_ptr< PrivacyModeGet >& payload);

    /**
     * Sends back the update to a previous onPrivacyModeGet().
     *
     * <b>Documentation of 'privacyMode'</b>:
     *
     * Privacy mode flag for scope 2.1 treated as one boolean, for 3.0 as 32 booleans (0: privacy mode off, 1:Privacy mode On)
     *
     * @param act Identifies a previous invocation of onPrivacyModeGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPrivacyModeGetUpdate(uint32 privacyMode, act_t act = 0);

    /**
     * The method onPrivacyModeSet() is called by ASF when a client invokes
     * the write method for the property 'privacyMode'. The onPrivacyModeSet()
     * method set property value to the given parameter privacyMode by
     * default. If this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'privacyMode'</b>:
     *
     * Privacy mode flag for scope 2.1 treated as one boolean, for 3.0 as 32 booleans (0: privacy mode off, 1:Privacy mode On)
     */
    virtual void onPrivacyModeSet(const ::boost::shared_ptr< PrivacyModeSet >& payload);

    /**
     * Sends back the update to a previous onPrivacyModeSet().
     *
     * <b>Documentation of 'privacyMode'</b>:
     *
     * Privacy mode flag for scope 2.1 treated as one boolean, for 3.0 as 32 booleans (0: privacy mode off, 1:Privacy mode On)
     *
     * @param act Identifies a previous invocation of onPrivacyModeSet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPrivacyModeSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'privacyMode' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'privacyMode'</b>:
     *
     * Privacy mode flag for scope 2.1 treated as one boolean, for 3.0 as 32 booleans (0: privacy mode off, 1:Privacy mode On)
     */
    void setPrivacyMode(uint32 privacyMode);

    /**
     * Returns the current value of the property 'privacyMode'.
     *
     * <b>Documentation of 'privacyMode'</b>:
     *
     * Privacy mode flag for scope 2.1 treated as one boolean, for 3.0 as 32 booleans (0: privacy mode off, 1:Privacy mode On)
     */
    uint32 getPrivacyMode() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPrivacyModeUpdate().
     *
     * <b>Documentation of 'privacyMode'</b>:
     *
     * Privacy mode flag for scope 2.1 treated as one boolean, for 3.0 as 32 booleans (0: privacy mode off, 1:Privacy mode On)
     */
    void sendPrivacyModeUpdate();

    // property 'profileName'

    /**
     * The method onProfileNameGet() is called by ASF when a client invokes
     * the read method for the property 'profileName'. The onProfileNameGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'profileName'</b>:
     *
     * Profile names for current profile con be changed with this attribute
     */
    virtual void onProfileNameGet(const ::boost::shared_ptr< ProfileNameGet >& payload);

    /**
     * Sends back the update to a previous onProfileNameGet().
     *
     * <b>Documentation of 'profileName'</b>:
     *
     * Profile names for current profile con be changed with this attribute
     *
     * @param act Identifies a previous invocation of onProfileNameGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendProfileNameGetUpdate(const ::std::string& profileName, act_t act = 0);

    /**
     * Set the value of the property 'profileName' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'profileName'</b>:
     *
     * Profile names for current profile con be changed with this attribute
     */
    void setProfileName(const ::std::string& profileName);

    /**
     * Returns the current value of the property 'profileName'.
     *
     * <b>Documentation of 'profileName'</b>:
     *
     * Profile names for current profile con be changed with this attribute
     */
    const ::std::string& getProfileName() const;

    /**
     * Returns the current value of the property 'profileName' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendProfileNameUpdate() method.
     *
     * <b>Documentation of 'profileName'</b>:
     *
     * Profile names for current profile con be changed with this attribute
     */
    ::std::string& getProfileNameMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendProfileNameUpdate().
     *
     * <b>Documentation of 'profileName'</b>:
     *
     * Profile names for current profile con be changed with this attribute
     */
    void sendProfileNameUpdate();

    // property 'profileImage'

    /**
     * The method onProfileImageGet() is called by ASF when a client invokes
     * the read method for the property 'profileImage'. The
     * onProfileImageGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'profileImage'</b>:
     *
     * Profile names for current profile con be changed with this attribute
     */
    virtual void onProfileImageGet(const ::boost::shared_ptr< ProfileImageGet >& payload);

    /**
     * Sends back the update to a previous onProfileImageGet().
     *
     * <b>Documentation of 'profileImage'</b>:
     *
     * Profile names for current profile con be changed with this attribute
     *
     * @param act Identifies a previous invocation of onProfileImageGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendProfileImageGetUpdate(uint8 profileImage, act_t act = 0);

    /**
     * Set the value of the property 'profileImage' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'profileImage'</b>:
     *
     * Profile names for current profile con be changed with this attribute
     */
    void setProfileImage(uint8 profileImage);

    /**
     * Returns the current value of the property 'profileImage'.
     *
     * <b>Documentation of 'profileImage'</b>:
     *
     * Profile names for current profile con be changed with this attribute
     */
    uint8 getProfileImage() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendProfileImageUpdate().
     *
     * <b>Documentation of 'profileImage'</b>:
     *
     * Profile names for current profile con be changed with this attribute
     */
    void sendProfileImageUpdate();

    // property 'pinRequested'

    /**
     * The method onPinRequestedGet() is called by ASF when a client invokes
     * the read method for the property 'pinRequested'. The
     * onPinRequestedGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'pinRequested'</b>:
     *
     * checkPin  call requested, to finish ongoing user action (e.g. change User
     */
    virtual void onPinRequestedGet(const ::boost::shared_ptr< PinRequestedGet >& payload);

    /**
     * Sends back the update to a previous onPinRequestedGet().
     *
     * <b>Documentation of 'pinRequested'</b>:
     *
     * checkPin  call requested, to finish ongoing user action (e.g. change User
     *
     * @param act Identifies a previous invocation of onPinRequestedGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPinRequestedGetUpdate(uint8 pinRequested, act_t act = 0);

    /**
     * Set the value of the property 'pinRequested' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'pinRequested'</b>:
     *
     * checkPin  call requested, to finish ongoing user action (e.g. change User
     */
    void setPinRequested(uint8 pinRequested);

    /**
     * Returns the current value of the property 'pinRequested'.
     *
     * <b>Documentation of 'pinRequested'</b>:
     *
     * checkPin  call requested, to finish ongoing user action (e.g. change User
     */
    uint8 getPinRequested() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPinRequestedUpdate().
     *
     * <b>Documentation of 'pinRequested'</b>:
     *
     * checkPin  call requested, to finish ongoing user action (e.g. change User
     */
    void sendPinRequestedUpdate();

    // property 'maxPINAttempts'

    /**
     * The method onMaxPINAttemptsGet() is called by ASF when a client invokes
     * the read method for the property 'maxPINAttempts'. The
     * onMaxPINAttemptsGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'maxPINAttempts'</b>:
     *
     * Max PIN attempts allowed
     */
    virtual void onMaxPINAttemptsGet(const ::boost::shared_ptr< MaxPINAttemptsGet >& payload);

    /**
     * Sends back the update to a previous onMaxPINAttemptsGet().
     *
     * <b>Documentation of 'maxPINAttempts'</b>:
     *
     * Max PIN attempts allowed
     *
     * @param act Identifies a previous invocation of onMaxPINAttemptsGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendMaxPINAttemptsGetUpdate(uint8 maxPINAttempts, act_t act = 0);

    /**
     * The method onMaxPINAttemptsSet() is called by ASF when a client invokes
     * the write method for the property 'maxPINAttempts'. The
     * onMaxPINAttemptsSet() method set property value to the given parameter
     * maxPINAttempts by default. If this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'maxPINAttempts'</b>:
     *
     * Max PIN attempts allowed
     */
    virtual void onMaxPINAttemptsSet(const ::boost::shared_ptr< MaxPINAttemptsSet >& payload);

    /**
     * Sends back the update to a previous onMaxPINAttemptsSet().
     *
     * <b>Documentation of 'maxPINAttempts'</b>:
     *
     * Max PIN attempts allowed
     *
     * @param act Identifies a previous invocation of onMaxPINAttemptsSet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendMaxPINAttemptsSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'maxPINAttempts' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'maxPINAttempts'</b>:
     *
     * Max PIN attempts allowed
     */
    void setMaxPINAttempts(uint8 maxPINAttempts);

    /**
     * Returns the current value of the property 'maxPINAttempts'.
     *
     * <b>Documentation of 'maxPINAttempts'</b>:
     *
     * Max PIN attempts allowed
     */
    uint8 getMaxPINAttempts() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendMaxPINAttemptsUpdate().
     *
     * <b>Documentation of 'maxPINAttempts'</b>:
     *
     * Max PIN attempts allowed
     */
    void sendMaxPINAttemptsUpdate();

    // property 'maxPINAttemptsBeforeDelay'

    /**
     * The method onMaxPINAttemptsBeforeDelayGet() is called by ASF when a
     * client invokes the read method for the property
     * 'maxPINAttemptsBeforeDelay'. The onMaxPINAttemptsBeforeDelayGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'maxPINAttemptsBeforeDelay'</b>:
     *
     * Maximum PIN Attempts before Delay
     */
    virtual void onMaxPINAttemptsBeforeDelayGet(const ::boost::shared_ptr< MaxPINAttemptsBeforeDelayGet >& payload);

    /**
     * Sends back the update to a previous onMaxPINAttemptsBeforeDelayGet().
     *
     * <b>Documentation of 'maxPINAttemptsBeforeDelay'</b>:
     *
     * Maximum PIN Attempts before Delay
     *
     * @param act Identifies a previous invocation of
     * onMaxPINAttemptsBeforeDelayGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendMaxPINAttemptsBeforeDelayGetUpdate(uint8 maxPINAttemptsBeforeDelay, act_t act = 0);

    /**
     * The method onMaxPINAttemptsBeforeDelaySet() is called by ASF when a
     * client invokes the write method for the property
     * 'maxPINAttemptsBeforeDelay'. The onMaxPINAttemptsBeforeDelaySet()
     * method set property value to the given parameter
     * maxPINAttemptsBeforeDelay by default. If this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'maxPINAttemptsBeforeDelay'</b>:
     *
     * Maximum PIN Attempts before Delay
     */
    virtual void onMaxPINAttemptsBeforeDelaySet(const ::boost::shared_ptr< MaxPINAttemptsBeforeDelaySet >& payload);

    /**
     * Sends back the update to a previous onMaxPINAttemptsBeforeDelaySet().
     *
     * <b>Documentation of 'maxPINAttemptsBeforeDelay'</b>:
     *
     * Maximum PIN Attempts before Delay
     *
     * @param act Identifies a previous invocation of
     * onMaxPINAttemptsBeforeDelaySet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendMaxPINAttemptsBeforeDelaySetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'maxPINAttemptsBeforeDelay' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'maxPINAttemptsBeforeDelay'</b>:
     *
     * Maximum PIN Attempts before Delay
     */
    void setMaxPINAttemptsBeforeDelay(uint8 maxPINAttemptsBeforeDelay);

    /**
     * Returns the current value of the property 'maxPINAttemptsBeforeDelay'.
     *
     * <b>Documentation of 'maxPINAttemptsBeforeDelay'</b>:
     *
     * Maximum PIN Attempts before Delay
     */
    uint8 getMaxPINAttemptsBeforeDelay() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendMaxPINAttemptsBeforeDelayUpdate().
     *
     * <b>Documentation of 'maxPINAttemptsBeforeDelay'</b>:
     *
     * Maximum PIN Attempts before Delay
     */
    void sendMaxPINAttemptsBeforeDelayUpdate();

    // property 'pinAuthenticationDelayTime'

    /**
     * The method onPinAuthenticationDelayTimeGet() is called by ASF when a
     * client invokes the read method for the property
     * 'pinAuthenticationDelayTime'. The onPinAuthenticationDelayTimeGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'pinAuthenticationDelayTime'</b>:
     *
     * PIN Autherntication Delay in milliseconds
     */
    virtual void onPinAuthenticationDelayTimeGet(const ::boost::shared_ptr< PinAuthenticationDelayTimeGet >& payload);

    /**
     * Sends back the update to a previous onPinAuthenticationDelayTimeGet().
     *
     * <b>Documentation of 'pinAuthenticationDelayTime'</b>:
     *
     * PIN Autherntication Delay in milliseconds
     *
     * @param act Identifies a previous invocation of
     * onPinAuthenticationDelayTimeGet(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendPinAuthenticationDelayTimeGetUpdate(uint32 pinAuthenticationDelayTime, act_t act = 0);

    /**
     * The method onPinAuthenticationDelayTimeSet() is called by ASF when a
     * client invokes the write method for the property
     * 'pinAuthenticationDelayTime'. The onPinAuthenticationDelayTimeSet()
     * method set property value to the given parameter
     * pinAuthenticationDelayTime by default. If this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'pinAuthenticationDelayTime'</b>:
     *
     * PIN Autherntication Delay in milliseconds
     */
    virtual void onPinAuthenticationDelayTimeSet(const ::boost::shared_ptr< PinAuthenticationDelayTimeSet >& payload);

    /**
     * Sends back the update to a previous onPinAuthenticationDelayTimeSet().
     *
     * <b>Documentation of 'pinAuthenticationDelayTime'</b>:
     *
     * PIN Autherntication Delay in milliseconds
     *
     * @param act Identifies a previous invocation of
     * onPinAuthenticationDelayTimeSet(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendPinAuthenticationDelayTimeSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'pinAuthenticationDelayTime' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'pinAuthenticationDelayTime'</b>:
     *
     * PIN Autherntication Delay in milliseconds
     */
    void setPinAuthenticationDelayTime(uint32 pinAuthenticationDelayTime);

    /**
     * Returns the current value of the property 'pinAuthenticationDelayTime'.
     *
     * <b>Documentation of 'pinAuthenticationDelayTime'</b>:
     *
     * PIN Autherntication Delay in milliseconds
     */
    uint32 getPinAuthenticationDelayTime() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPinAuthenticationDelayTimeUpdate().
     *
     * <b>Documentation of 'pinAuthenticationDelayTime'</b>:
     *
     * PIN Autherntication Delay in milliseconds
     */
    void sendPinAuthenticationDelayTimeUpdate();

    // property 'pinVerificationValidityTime'

    /**
     * The method onPinVerificationValidityTimeGet() is called by ASF when a
     * client invokes the read method for the property
     * 'pinVerificationValidityTime'. The onPinVerificationValidityTimeGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'pinVerificationValidityTime'</b>:
     *
     * PINVerificationValidityTime in milliseconds
     */
    virtual void onPinVerificationValidityTimeGet(const ::boost::shared_ptr< PinVerificationValidityTimeGet >& payload);

    /**
     * Sends back the update to a previous onPinVerificationValidityTimeGet().
     *
     * <b>Documentation of 'pinVerificationValidityTime'</b>:
     *
     * PINVerificationValidityTime in milliseconds
     *
     * @param act Identifies a previous invocation of
     * onPinVerificationValidityTimeGet(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendPinVerificationValidityTimeGetUpdate(uint32 pinVerificationValidityTime, act_t act = 0);

    /**
     * The method onPinVerificationValidityTimeSet() is called by ASF when a
     * client invokes the write method for the property
     * 'pinVerificationValidityTime'. The onPinVerificationValidityTimeSet()
     * method set property value to the given parameter
     * pinVerificationValidityTime by default. If this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'pinVerificationValidityTime'</b>:
     *
     * PINVerificationValidityTime in milliseconds
     */
    virtual void onPinVerificationValidityTimeSet(const ::boost::shared_ptr< PinVerificationValidityTimeSet >& payload);

    /**
     * Sends back the update to a previous onPinVerificationValidityTimeSet().
     *
     * <b>Documentation of 'pinVerificationValidityTime'</b>:
     *
     * PINVerificationValidityTime in milliseconds
     *
     * @param act Identifies a previous invocation of
     * onPinVerificationValidityTimeSet(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendPinVerificationValidityTimeSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'pinVerificationValidityTime' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'pinVerificationValidityTime'</b>:
     *
     * PINVerificationValidityTime in milliseconds
     */
    void setPinVerificationValidityTime(uint32 pinVerificationValidityTime);

    /**
     * Returns the current value of the property 'pinVerificationValidityTime'.
     *
     * <b>Documentation of 'pinVerificationValidityTime'</b>:
     *
     * PINVerificationValidityTime in milliseconds
     */
    uint32 getPinVerificationValidityTime() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPinVerificationValidityTimeUpdate().
     *
     * <b>Documentation of 'pinVerificationValidityTime'</b>:
     *
     * PINVerificationValidityTime in milliseconds
     */
    void sendPinVerificationValidityTimeUpdate();

    // property 'activeProfileType'

    /**
     * The method onActiveProfileTypeGet() is called by ASF when a client
     * invokes the read method for the property 'activeProfileType'. The
     * onActiveProfileTypeGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'activeProfileType'</b>:
     *
     * Current Active User Profile Type
     */
    virtual void onActiveProfileTypeGet(const ::boost::shared_ptr< ActiveProfileTypeGet >& payload);

    /**
     * Sends back the update to a previous onActiveProfileTypeGet().
     *
     * <b>Documentation of 'activeProfileType'</b>:
     *
     * Current Active User Profile Type
     *
     * @param act Identifies a previous invocation of
     * onActiveProfileTypeGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendActiveProfileTypeGetUpdate(profileType activeProfileType, act_t act = 0);

    /**
     * The method onActiveProfileTypeSet() is called by ASF when a client
     * invokes the write method for the property 'activeProfileType'. The
     * onActiveProfileTypeSet() method set property value to the given
     * parameter activeProfileType by default. If this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'activeProfileType'</b>:
     *
     * Current Active User Profile Type
     */
    virtual void onActiveProfileTypeSet(const ::boost::shared_ptr< ActiveProfileTypeSet >& payload);

    /**
     * Sends back the update to a previous onActiveProfileTypeSet().
     *
     * <b>Documentation of 'activeProfileType'</b>:
     *
     * Current Active User Profile Type
     *
     * @param act Identifies a previous invocation of
     * onActiveProfileTypeSet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendActiveProfileTypeSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'activeProfileType' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'activeProfileType'</b>:
     *
     * Current Active User Profile Type
     */
    void setActiveProfileType(profileType activeProfileType);

    /**
     * Returns the current value of the property 'activeProfileType'.
     *
     * <b>Documentation of 'activeProfileType'</b>:
     *
     * Current Active User Profile Type
     */
    profileType getActiveProfileType() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendActiveProfileTypeUpdate().
     *
     * <b>Documentation of 'activeProfileType'</b>:
     *
     * Current Active User Profile Type
     */
    void sendActiveProfileTypeUpdate();

    // method 'doRegisterApp'

    /**
     * The method onDoRegisterApp() is called by ASF when a client invokes the
     * method 'doRegisterApp'. A subclass has to implement this method and
     * send back a response to the client either with the sendDoRegisterApp()
     * or sendDoRegisterAppError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'doRegisterApp'</b>:
     *
     * Each Application, that stores Profile Data has to register here.
     *    The application has to store the AppID returned by RegisterApp and uset it for all other calls to the Profile Manager
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDoRegisterAppRequest (const ::boost::shared_ptr< DoRegisterAppRequest >& request) = 0;

    /**
     * The method sendDoRegisterAppResponse() sends a response of a previous
     * method invocation of 'doRegisterApp' back to the client.
     *
     * <b>Documentation of 'doRegisterApp'</b>:
     *
     * Each Application, that stores Profile Data has to register here.
     *    The application has to store the AppID returned by RegisterApp and uset it for all other calls to the Profile Manager
     *
     * @param AppID If the meaning of "AppID" isn't clear, then there should be a description here.
     *
     * @param ApplName If the meaning of "ApplName" isn't clear, then there should be a description here.
     *
     * @param reloadData If the meaning of "reloadData" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDoRegisterApp(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendDoRegisterAppResponse (uint32 appID, const ::std::string& applName, bool reloadData, act_t act = 0);

    /**
     * The method sendDoRegisterAppError() sends an error response of a
     * previous method invocation of 'doRegisterApp' back to the client.
     *
     * <b>Documentation of 'doRegisterApp'</b>:
     *
     * Each Application, that stores Profile Data has to register here.
     *    The application has to store the AppID returned by RegisterApp and uset it for all other calls to the Profile Manager
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDoRegisterApp(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDoRegisterAppError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'onDataChanged'

    /**
     * The method onOnDataChanged() is called by ASF when a client invokes the
     * method 'onDataChanged'.  Do not invoke this method on your own.
     *
     * <b>Documentation of 'onDataChanged'</b>:
     *
     * Function to be called after user change has been done. User change is triggered by activeProfile Property update
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onOnDataChangedRequest (const ::boost::shared_ptr< OnDataChangedRequest >& request) = 0;

    // method 'onProfileDeleted'

    /**
     * The method onOnProfileDeleted() is called by ASF when a client invokes
     * the method 'onProfileDeleted'.  Do not invoke this method on your own.
     *
     * <b>Documentation of 'onProfileDeleted'</b>:
     *
     * Function to be called after user has been deleted. User deleteion is triggered by deleteProfile Property update
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onOnProfileDeletedRequest (const ::boost::shared_ptr< OnProfileDeletedRequest >& request) = 0;

    // method 'onProfileCopied'

    /**
     * The method onOnProfileCopied() is called by ASF when a client invokes
     * the method 'onProfileCopied'.  Do not invoke this method on your own.
     *
     * <b>Documentation of 'onProfileCopied'</b>:
     *
     * function to be called by the clients after Profile copy action triggered by copyProfile property update has been executed
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onOnProfileCopiedRequest (const ::boost::shared_ptr< OnProfileCopiedRequest >& request) = 0;

    // method 'onProfileCreated'

    /**
     * The method onOnProfileCreated() is called by ASF when a client invokes
     * the method 'onProfileCreated'.  Do not invoke this method on your own.
     *
     * <b>Documentation of 'onProfileCreated'</b>:
     *
     * function to be called by the clients after Profile create action triggered by createProfile property update has been executed
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onOnProfileCreatedRequest (const ::boost::shared_ptr< OnProfileCreatedRequest >& request) = 0;

    // method 'doCopyProfile'

    /**
     * The method onDoCopyProfile() is called by ASF when a client invokes the
     * method 'doCopyProfile'. A subclass has to implement this method and
     * send back a response to the client either with the sendDoCopyProfile()
     * or sendDoCopyProfileError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'doCopyProfile'</b>:
     *
     * function to request a user copy from the Profile Manager
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDoCopyProfileRequest (const ::boost::shared_ptr< DoCopyProfileRequest >& request) = 0;

    /**
     * The method sendDoCopyProfileResponse() sends a response of a previous
     * method invocation of 'doCopyProfile' back to the client.
     *
     * <b>Documentation of 'doCopyProfile'</b>:
     *
     * function to request a user copy from the Profile Manager
     *
     * @param Result If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDoCopyProfile(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendDoCopyProfileResponse (serverResult result, act_t act = 0);

    /**
     * The method sendDoCopyProfileError() sends an error response of a
     * previous method invocation of 'doCopyProfile' back to the client.
     *
     * <b>Documentation of 'doCopyProfile'</b>:
     *
     * function to request a user copy from the Profile Manager
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDoCopyProfile(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDoCopyProfileError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'doDeleteProfile'

    /**
     * The method onDoDeleteProfile() is called by ASF when a client invokes
     * the method 'doDeleteProfile'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendDoDeleteProfile() or sendDoDeleteProfileError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'doDeleteProfile'</b>:
     *
     * function to delete a Profile
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDoDeleteProfileRequest (const ::boost::shared_ptr< DoDeleteProfileRequest >& request) = 0;

    /**
     * The method sendDoDeleteProfileResponse() sends a response of a previous
     * method invocation of 'doDeleteProfile' back to the client.
     *
     * <b>Documentation of 'doDeleteProfile'</b>:
     *
     * function to delete a Profile
     *
     * @param Result If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDoDeleteProfile(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendDoDeleteProfileResponse (serverResult result, act_t act = 0);

    /**
     * The method sendDoDeleteProfileError() sends an error response of a
     * previous method invocation of 'doDeleteProfile' back to the client.
     *
     * <b>Documentation of 'doDeleteProfile'</b>:
     *
     * function to delete a Profile
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDoDeleteProfile(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDoDeleteProfileError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'doChangeToProfile'

    /**
     * The method onDoChangeToProfile() is called by ASF when a client invokes
     * the method 'doChangeToProfile'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendDoChangeToProfile() or sendDoChangeToProfileError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'doChangeToProfile'</b>:
     *
     * function to request a change of the current user from the Profile Manager
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDoChangeToProfileRequest (const ::boost::shared_ptr< DoChangeToProfileRequest >& request) = 0;

    /**
     * The method sendDoChangeToProfileResponse() sends a response of a
     * previous method invocation of 'doChangeToProfile' back to the client.
     *
     * <b>Documentation of 'doChangeToProfile'</b>:
     *
     * function to request a change of the current user from the Profile Manager
     *
     * @param Result If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDoChangeToProfile(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDoChangeToProfileResponse (serverResult result, act_t act = 0);

    /**
     * The method sendDoChangeToProfileError() sends an error response of a
     * previous method invocation of 'doChangeToProfile' back to the client.
     *
     * <b>Documentation of 'doChangeToProfile'</b>:
     *
     * function to request a change of the current user from the Profile Manager
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDoChangeToProfile().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDoChangeToProfileError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'doCreateProfile'

    /**
     * The method onDoCreateProfile() is called by ASF when a client invokes
     * the method 'doCreateProfile'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendDoCreateProfile() or sendDoCreateProfileError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'doCreateProfile'</b>:
     *
     * function to request a creations of a new User Profile from the Profile Manager
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDoCreateProfileRequest (const ::boost::shared_ptr< DoCreateProfileRequest >& request) = 0;

    /**
     * The method sendDoCreateProfileResponse() sends a response of a previous
     * method invocation of 'doCreateProfile' back to the client.
     *
     * <b>Documentation of 'doCreateProfile'</b>:
     *
     * function to request a creations of a new User Profile from the Profile Manager
     *
     * @param Result If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param newUserID If the meaning of "newUserID" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDoCreateProfile(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendDoCreateProfileResponse (serverResult result, uint8 newUserID, act_t act = 0);

    /**
     * The method sendDoCreateProfileError() sends an error response of a
     * previous method invocation of 'doCreateProfile' back to the client.
     *
     * <b>Documentation of 'doCreateProfile'</b>:
     *
     * function to request a creations of a new User Profile from the Profile Manager
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDoCreateProfile(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDoCreateProfileError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'do_SetProfileName'

    /**
     * The method onDo_SetProfileName() is called by ASF when a client invokes
     * the method 'do_SetProfileName'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendDo_SetProfileName() or sendDo_SetProfileNameError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'do_SetProfileName'</b>:
     *
     * sets the profile name for the current profile
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDo_SetProfileNameRequest (const ::boost::shared_ptr< Do_SetProfileNameRequest >& request) = 0;

    /**
     * The method sendDo_SetProfileNameResponse() sends a response of a
     * previous method invocation of 'do_SetProfileName' back to the client.
     *
     * <b>Documentation of 'do_SetProfileName'</b>:
     *
     * sets the profile name for the current profile
     *
     * @param Result If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDo_SetProfileName(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDo_SetProfileNameResponse (serverResult result, act_t act = 0);

    /**
     * The method sendDo_SetProfileNameError() sends an error response of a
     * previous method invocation of 'do_SetProfileName' back to the client.
     *
     * <b>Documentation of 'do_SetProfileName'</b>:
     *
     * sets the profile name for the current profile
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDo_SetProfileName().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDo_SetProfileNameError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getProfileNames'

    /**
     * The method onGetProfileNames() is called by ASF when a client invokes
     * the method 'getProfileNames'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendGetProfileNames() or sendGetProfileNamesError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'getProfileNames'</b>:
     *
     * gets all profile names
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetProfileNamesRequest (const ::boost::shared_ptr< GetProfileNamesRequest >& request) = 0;

    /**
     * The method sendGetProfileNamesResponse() sends a response of a previous
     * method invocation of 'getProfileNames' back to the client.
     *
     * <b>Documentation of 'getProfileNames'</b>:
     *
     * gets all profile names
     *
     * @param names If the meaning of "names" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetProfileNames(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetProfileNamesResponse (const ::std::vector< ::std::string >& names, act_t act = 0);

    /**
     * The method sendGetProfileNamesError() sends an error response of a
     * previous method invocation of 'getProfileNames' back to the client.
     *
     * <b>Documentation of 'getProfileNames'</b>:
     *
     * gets all profile names
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetProfileNames(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetProfileNamesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'doImportProfileImage'

    /**
     * The method onDoImportProfileImage() is called by ASF when a client
     * invokes the method 'doImportProfileImage'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendDoImportProfileImage() or sendDoImportProfileImageError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'doImportProfileImage'</b>:
     *
     * import an image from usb drive as Proifle image in the given slot. if slot is 0xFFFF, then the profile manager will assign it tot the user image slot for the current Profile
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDoImportProfileImageRequest (const ::boost::shared_ptr< DoImportProfileImageRequest >& request) = 0;

    /**
     * The method sendDoImportProfileImageResponse() sends a response of a
     * previous method invocation of 'doImportProfileImage' back to the
     * client.
     *
     * <b>Documentation of 'doImportProfileImage'</b>:
     *
     * import an image from usb drive as Proifle image in the given slot. if slot is 0xFFFF, then the profile manager will assign it tot the user image slot for the current Profile
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDoImportProfileImage(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDoImportProfileImageResponse (serverResult result, act_t act = 0);

    /**
     * The method sendDoImportProfileImageError() sends an error response of a
     * previous method invocation of 'doImportProfileImage' back to the
     * client.
     *
     * <b>Documentation of 'doImportProfileImage'</b>:
     *
     * import an image from usb drive as Proifle image in the given slot. if slot is 0xFFFF, then the profile manager will assign it tot the user image slot for the current Profile
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onDoImportProfileImage(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDoImportProfileImageError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'removeUserImage'

    /**
     * The method onRemoveUserImage() is called by ASF when a client invokes
     * the method 'removeUserImage'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendRemoveUserImage() or sendRemoveUserImageError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'removeUserImage'</b>:
     *
     * delete an imported image referenced by the slotIdx from the system.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRemoveUserImageRequest (const ::boost::shared_ptr< RemoveUserImageRequest >& request) = 0;

    /**
     * The method sendRemoveUserImageResponse() sends a response of a previous
     * method invocation of 'removeUserImage' back to the client.
     *
     * <b>Documentation of 'removeUserImage'</b>:
     *
     * delete an imported image referenced by the slotIdx from the system.
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRemoveUserImage(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRemoveUserImageResponse (serverResult result, act_t act = 0);

    /**
     * The method sendRemoveUserImageError() sends an error response of a
     * previous method invocation of 'removeUserImage' back to the client.
     *
     * <b>Documentation of 'removeUserImage'</b>:
     *
     * delete an imported image referenced by the slotIdx from the system.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRemoveUserImage(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRemoveUserImageError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'doSetProfileImage'

    /**
     * The method onDoSetProfileImage() is called by ASF when a client invokes
     * the method 'doSetProfileImage'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendDoSetProfileImage() or sendDoSetProfileImageError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'doSetProfileImage'</b>:
     *
     * set current profile image (index)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDoSetProfileImageRequest (const ::boost::shared_ptr< DoSetProfileImageRequest >& request) = 0;

    /**
     * The method sendDoSetProfileImageResponse() sends a response of a
     * previous method invocation of 'doSetProfileImage' back to the client.
     *
     * <b>Documentation of 'doSetProfileImage'</b>:
     *
     * set current profile image (index)
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDoSetProfileImage(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDoSetProfileImageResponse (serverResult result, act_t act = 0);

    /**
     * The method sendDoSetProfileImageError() sends an error response of a
     * previous method invocation of 'doSetProfileImage' back to the client.
     *
     * <b>Documentation of 'doSetProfileImage'</b>:
     *
     * set current profile image (index)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDoSetProfileImage().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDoSetProfileImageError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getProfileImages'

    /**
     * The method onGetProfileImages() is called by ASF when a client invokes
     * the method 'getProfileImages'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendGetProfileImages() or sendGetProfileImagesError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'getProfileImages'</b>:
     *
     * gets all profile images
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetProfileImagesRequest (const ::boost::shared_ptr< GetProfileImagesRequest >& request) = 0;

    /**
     * The method sendGetProfileImagesResponse() sends a response of a
     * previous method invocation of 'getProfileImages' back to the client.
     *
     * <b>Documentation of 'getProfileImages'</b>:
     *
     * gets all profile images
     *
     * @param images If the meaning of "images" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetProfileImages(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetProfileImagesResponse (const ::std::vector< uint8 >& images, act_t act = 0);

    /**
     * The method sendGetProfileImagesError() sends an error response of a
     * previous method invocation of 'getProfileImages' back to the client.
     *
     * <b>Documentation of 'getProfileImages'</b>:
     *
     * gets all profile images
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetProfileImages(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetProfileImagesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getProfileTypes'

    /**
     * The method onGetProfileTypes() is called by ASF when a client invokes
     * the method 'getProfileTypes'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendGetProfileTypes() or sendGetProfileTypesError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'getProfileTypes'</b>:
     *
     * gets all profile types
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetProfileTypesRequest (const ::boost::shared_ptr< GetProfileTypesRequest >& request) = 0;

    /**
     * The method sendGetProfileTypesResponse() sends a response of a previous
     * method invocation of 'getProfileTypes' back to the client.
     *
     * <b>Documentation of 'getProfileTypes'</b>:
     *
     * gets all profile types
     *
     * @param types If the meaning of "types" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetProfileTypes(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetProfileTypesResponse (const ::std::vector< profileType >& types, act_t act = 0);

    /**
     * The method sendGetProfileTypesError() sends an error response of a
     * previous method invocation of 'getProfileTypes' back to the client.
     *
     * <b>Documentation of 'getProfileTypes'</b>:
     *
     * gets all profile types
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetProfileTypes(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetProfileTypesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setProfilePin'

    /**
     * The method onSetProfilePin() is called by ASF when a client invokes the
     * method 'setProfilePin'. A subclass has to implement this method and
     * send back a response to the client either with the sendSetProfilePin()
     * or sendSetProfilePinError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'setProfilePin'</b>:
     *
     * sets Authentication Method PIN
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetProfilePinRequest (const ::boost::shared_ptr< SetProfilePinRequest >& request) = 0;

    /**
     * The method sendSetProfilePinResponse() sends a response of a previous
     * method invocation of 'setProfilePin' back to the client.
     *
     * <b>Documentation of 'setProfilePin'</b>:
     *
     * sets Authentication Method PIN
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetProfilePin(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetProfilePinResponse (serverResult result, act_t act = 0);

    /**
     * The method sendSetProfilePinError() sends an error response of a
     * previous method invocation of 'setProfilePin' back to the client.
     *
     * <b>Documentation of 'setProfilePin'</b>:
     *
     * sets Authentication Method PIN
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetProfilePin(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetProfilePinError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setRememberMe'

    /**
     * The method onSetRememberMe() is called by ASF when a client invokes the
     * method 'setRememberMe'. A subclass has to implement this method and
     * send back a response to the client either with the sendSetRememberMe()
     * or sendSetRememberMeError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'setRememberMe'</b>:
     *
     * sets Authentication Method to Remember Me
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetRememberMeRequest (const ::boost::shared_ptr< SetRememberMeRequest >& request) = 0;

    /**
     * The method sendSetRememberMeResponse() sends a response of a previous
     * method invocation of 'setRememberMe' back to the client.
     *
     * <b>Documentation of 'setRememberMe'</b>:
     *
     * sets Authentication Method to Remember Me
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetRememberMe(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetRememberMeResponse (serverResult result, act_t act = 0);

    /**
     * The method sendSetRememberMeError() sends an error response of a
     * previous method invocation of 'setRememberMe' back to the client.
     *
     * <b>Documentation of 'setRememberMe'</b>:
     *
     * sets Authentication Method to Remember Me
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetRememberMe(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetRememberMeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'checkPin'

    /**
     * The method onCheckPin() is called by ASF when a client invokes the
     * method 'checkPin'. A subclass has to implement this method and send
     * back a response to the client either with the sendCheckPin() or
     * sendCheckPinError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'checkPin'</b>:
     *
     * Validates the current PIN. needs to be called before setProfilePin & setRememberMe if Prodile is secured by PIN
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCheckPinRequest (const ::boost::shared_ptr< CheckPinRequest >& request) = 0;

    /**
     * The method sendCheckPinResponse() sends a response of a previous method
     * invocation of 'checkPin' back to the client.
     *
     * <b>Documentation of 'checkPin'</b>:
     *
     * Validates the current PIN. needs to be called before setProfilePin & setRememberMe if Prodile is secured by PIN
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onCheckPin(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendCheckPinResponse (serverResult result, act_t act = 0);

    /**
     * The method sendCheckPinError() sends an error response of a previous
     * method invocation of 'checkPin' back to the client.
     *
     * <b>Documentation of 'checkPin'</b>:
     *
     * Validates the current PIN. needs to be called before setProfilePin & setRememberMe if Prodile is secured by PIN
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onCheckPin(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendCheckPinError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'unProtectProfile'

    /**
     * The method onUnProtectProfile() is called by ASF when a client invokes
     * the method 'unProtectProfile'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendUnProtectProfile() or sendUnProtectProfileError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'unProtectProfile'</b>:
     *
     * removes the Authentication Method
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onUnProtectProfileRequest (const ::boost::shared_ptr< UnProtectProfileRequest >& request) = 0;

    /**
     * The method sendUnProtectProfileResponse() sends a response of a
     * previous method invocation of 'unProtectProfile' back to the client.
     *
     * <b>Documentation of 'unProtectProfile'</b>:
     *
     * removes the Authentication Method
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onUnProtectProfile(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendUnProtectProfileResponse (serverResult result, act_t act = 0);

    /**
     * The method sendUnProtectProfileError() sends an error response of a
     * previous method invocation of 'unProtectProfile' back to the client.
     *
     * <b>Documentation of 'unProtectProfile'</b>:
     *
     * removes the Authentication Method
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onUnProtectProfile(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendUnProtectProfileError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'linkProfile'

    /**
     * The method onLinkProfile() is called by ASF when a client invokes the
     * method 'linkProfile'. A subclass has to implement this method and send
     * back a response to the client either with the sendLinkProfile() or
     * sendLinkProfileError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'linkProfile'</b>:
     *
     * link profile
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onLinkProfileRequest (const ::boost::shared_ptr< LinkProfileRequest >& request) = 0;

    /**
     * The method sendLinkProfileResponse() sends a response of a previous
     * method invocation of 'linkProfile' back to the client.
     *
     * <b>Documentation of 'linkProfile'</b>:
     *
     * link profile
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onLinkProfile(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendLinkProfileResponse (serverResult result, act_t act = 0);

    /**
     * The method sendLinkProfileError() sends an error response of a previous
     * method invocation of 'linkProfile' back to the client.
     *
     * <b>Documentation of 'linkProfile'</b>:
     *
     * link profile
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onLinkProfile(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendLinkProfileError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setValetMode'

    /**
     * The method onSetValetMode() is called by ASF when a client invokes the
     * method 'setValetMode'. A subclass has to implement this method and send
     * back a response to the client either with the sendSetValetMode() or
     * sendSetValetModeError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'setValetMode'</b>:
     *
     * SetValetMode
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetValetModeRequest (const ::boost::shared_ptr< SetValetModeRequest >& request) = 0;

    /**
     * The method sendSetValetModeResponse() sends a response of a previous
     * method invocation of 'setValetMode' back to the client.
     *
     * <b>Documentation of 'setValetMode'</b>:
     *
     * SetValetMode
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetValetMode(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetValetModeResponse (serverResult result, act_t act = 0);

    /**
     * The method sendSetValetModeError() sends an error response of a
     * previous method invocation of 'setValetMode' back to the client.
     *
     * <b>Documentation of 'setValetMode'</b>:
     *
     * SetValetMode
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetValetMode(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSetValetModeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    ActiveProfileUpdate _activeProfileProperty;

    StatusUpdate _statusProperty;

    CopyProfileUpdate _copyProfileProperty;

    DeleteProfileUpdate _deleteProfileProperty;

    DataChangedUpdate _dataChangedProperty;

    CreateProfileUpdate _createProfileProperty;

    PrivacyModeUpdate _privacyModeProperty;

    ProfileNameUpdate _profileNameProperty;

    ProfileImageUpdate _profileImageProperty;

    PinRequestedUpdate _pinRequestedProperty;

    MaxPINAttemptsUpdate _maxPINAttemptsProperty;

    MaxPINAttemptsBeforeDelayUpdate _maxPINAttemptsBeforeDelayProperty;

    PinAuthenticationDelayTimeUpdate _pinAuthenticationDelayTimeProperty;

    PinVerificationValidityTimeUpdate _pinVerificationValidityTimeProperty;

    ActiveProfileTypeUpdate _activeProfileTypeProperty;

    friend class ProfileStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace profile
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_PROFILESTUB_H
