/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/profile.h"
#include "bosch/cm/profileConst.h"
#include "bosch/cm/profileDBus.h"
#include "bosch/cm/profileJson.h"
#include "bosch/cm/profileStub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace profile {

DEFINE_CLASS_LOGGER("/bosch/cm/bosch/cm/profile", ProfileStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 8, "checkPin", 18 },
    { 11, "linkProfile", 20 },
    { 12, "setValetMode", 21 },
    { 13, "doCopyProfile", 5 },
    { 13, "doRegisterApp", 0 },
    { 13, "onDataChanged", 1 },
    { 13, "setProfilePin", 16 },
    { 13, "setRememberMe", 17 },
    { 15, "doCreateProfile", 8 },
    { 15, "doDeleteProfile", 6 },
    { 15, "getProfileNames", 10 },
    { 15, "getProfileTypes", 15 },
    { 15, "onProfileCopied", 3 },
    { 15, "removeUserImage", 12 },
    { 16, "getProfileImages", 14 },
    { 16, "onProfileCreated", 4 },
    { 16, "onProfileDeleted", 2 },
    { 16, "unProtectProfile", 19 },
    { 17, "doChangeToProfile", 7 },
    { 17, "doSetProfileImage", 13 },
    { 17, "do_SetProfileName", 9 },
    { 20, "doImportProfileImage", 11 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 6, "status", 1 },
    { 11, "copyProfile", 2 },
    { 11, "dataChanged", 4 },
    { 11, "privacyMode", 6 },
    { 11, "profileName", 7 },
    { 12, "pinRequested", 9 },
    { 12, "profileImage", 8 },
    { 13, "activeProfile", 0 },
    { 13, "createProfile", 5 },
    { 13, "deleteProfile", 3 },
    { 14, "maxPINAttempts", 10 },
    { 17, "activeProfileType", 14 },
    { 25, "maxPINAttemptsBeforeDelay", 11 },
    { 26, "pinAuthenticationDelayTime", 12 },
    { 27, "pinVerificationValidityTime", 13 },
};

class ProfileStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    ProfileStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    ProfileStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    ProfileStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "bosch.cm.profile"),
          _logger(logger) {}

    virtual ~ProfileStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void ProfileStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 22, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'doRegisterApp'

            LOG_DEBUG_STUB("process method '%s'", "doRegisterApp");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DoRegisterAppRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DoRegisterApp", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DoRegisterAppRequest > payload = ::boost::static_pointer_cast<DoRegisterAppRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileStub*>(getStub())->onDoRegisterAppRequest(payload);
            return;
        }
        case 1: {

            // method 'onDataChanged'

            LOG_DEBUG_STUB("process method '%s'", "onDataChanged");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OnDataChangedRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "OnDataChanged", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< OnDataChangedRequest > payload = ::boost::static_pointer_cast<OnDataChangedRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileStub*>(getStub())->onOnDataChangedRequest(payload);
            return;
        }
        case 2: {

            // method 'onProfileDeleted'

            LOG_DEBUG_STUB("process method '%s'", "onProfileDeleted");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OnProfileDeletedRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "OnProfileDeleted", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< OnProfileDeletedRequest > payload = ::boost::static_pointer_cast<OnProfileDeletedRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileStub*>(getStub())->onOnProfileDeletedRequest(payload);
            return;
        }
        case 3: {

            // method 'onProfileCopied'

            LOG_DEBUG_STUB("process method '%s'", "onProfileCopied");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OnProfileCopiedRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "OnProfileCopied", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< OnProfileCopiedRequest > payload = ::boost::static_pointer_cast<OnProfileCopiedRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileStub*>(getStub())->onOnProfileCopiedRequest(payload);
            return;
        }
        case 4: {

            // method 'onProfileCreated'

            LOG_DEBUG_STUB("process method '%s'", "onProfileCreated");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OnProfileCreatedRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "OnProfileCreated", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< OnProfileCreatedRequest > payload = ::boost::static_pointer_cast<OnProfileCreatedRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileStub*>(getStub())->onOnProfileCreatedRequest(payload);
            return;
        }
        case 5: {

            // method 'doCopyProfile'

            LOG_DEBUG_STUB("process method '%s'", "doCopyProfile");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DoCopyProfileRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DoCopyProfile", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DoCopyProfileRequest > payload = ::boost::static_pointer_cast<DoCopyProfileRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileStub*>(getStub())->onDoCopyProfileRequest(payload);
            return;
        }
        case 6: {

            // method 'doDeleteProfile'

            LOG_DEBUG_STUB("process method '%s'", "doDeleteProfile");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DoDeleteProfileRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DoDeleteProfile", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DoDeleteProfileRequest > payload = ::boost::static_pointer_cast<DoDeleteProfileRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileStub*>(getStub())->onDoDeleteProfileRequest(payload);
            return;
        }
        case 7: {

            // method 'doChangeToProfile'

            LOG_DEBUG_STUB("process method '%s'", "doChangeToProfile");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DoChangeToProfileRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DoChangeToProfile", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DoChangeToProfileRequest > payload = ::boost::static_pointer_cast<DoChangeToProfileRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileStub*>(getStub())->onDoChangeToProfileRequest(payload);
            return;
        }
        case 8: {

            // method 'doCreateProfile'

            LOG_DEBUG_STUB("process method '%s'", "doCreateProfile");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DoCreateProfileRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DoCreateProfile", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DoCreateProfileRequest > payload = ::boost::static_pointer_cast<DoCreateProfileRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileStub*>(getStub())->onDoCreateProfileRequest(payload);
            return;
        }
        case 9: {

            // method 'do_SetProfileName'

            LOG_DEBUG_STUB("process method '%s'", "do_SetProfileName");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Do_SetProfileNameRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Do_SetProfileName", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< Do_SetProfileNameRequest > payload = ::boost::static_pointer_cast<Do_SetProfileNameRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileStub*>(getStub())->onDo_SetProfileNameRequest(payload);
            return;
        }
        case 10: {

            // method 'getProfileNames'

            LOG_DEBUG_STUB("process method '%s'", "getProfileNames");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetProfileNamesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetProfileNames", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetProfileNamesRequest > payload = ::boost::static_pointer_cast<GetProfileNamesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileStub*>(getStub())->onGetProfileNamesRequest(payload);
            return;
        }
        case 11: {

            // method 'doImportProfileImage'

            LOG_DEBUG_STUB("process method '%s'", "doImportProfileImage");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DoImportProfileImageRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DoImportProfileImage", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DoImportProfileImageRequest > payload = ::boost::static_pointer_cast<DoImportProfileImageRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileStub*>(getStub())->onDoImportProfileImageRequest(payload);
            return;
        }
        case 12: {

            // method 'removeUserImage'

            LOG_DEBUG_STUB("process method '%s'", "removeUserImage");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemoveUserImageRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RemoveUserImage", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RemoveUserImageRequest > payload = ::boost::static_pointer_cast<RemoveUserImageRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileStub*>(getStub())->onRemoveUserImageRequest(payload);
            return;
        }
        case 13: {

            // method 'doSetProfileImage'

            LOG_DEBUG_STUB("process method '%s'", "doSetProfileImage");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DoSetProfileImageRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DoSetProfileImage", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DoSetProfileImageRequest > payload = ::boost::static_pointer_cast<DoSetProfileImageRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileStub*>(getStub())->onDoSetProfileImageRequest(payload);
            return;
        }
        case 14: {

            // method 'getProfileImages'

            LOG_DEBUG_STUB("process method '%s'", "getProfileImages");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetProfileImagesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetProfileImages", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetProfileImagesRequest > payload = ::boost::static_pointer_cast<GetProfileImagesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileStub*>(getStub())->onGetProfileImagesRequest(payload);
            return;
        }
        case 15: {

            // method 'getProfileTypes'

            LOG_DEBUG_STUB("process method '%s'", "getProfileTypes");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetProfileTypesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetProfileTypes", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetProfileTypesRequest > payload = ::boost::static_pointer_cast<GetProfileTypesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileStub*>(getStub())->onGetProfileTypesRequest(payload);
            return;
        }
        case 16: {

            // method 'setProfilePin'

            LOG_DEBUG_STUB("process method '%s'", "setProfilePin");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetProfilePinRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetProfilePin", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetProfilePinRequest > payload = ::boost::static_pointer_cast<SetProfilePinRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileStub*>(getStub())->onSetProfilePinRequest(payload);
            return;
        }
        case 17: {

            // method 'setRememberMe'

            LOG_DEBUG_STUB("process method '%s'", "setRememberMe");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetRememberMeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetRememberMe", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetRememberMeRequest > payload = ::boost::static_pointer_cast<SetRememberMeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileStub*>(getStub())->onSetRememberMeRequest(payload);
            return;
        }
        case 18: {

            // method 'checkPin'

            LOG_DEBUG_STUB("process method '%s'", "checkPin");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CheckPinRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "CheckPin", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CheckPinRequest > payload = ::boost::static_pointer_cast<CheckPinRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileStub*>(getStub())->onCheckPinRequest(payload);
            return;
        }
        case 19: {

            // method 'unProtectProfile'

            LOG_DEBUG_STUB("process method '%s'", "unProtectProfile");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnProtectProfileRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UnProtectProfile", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UnProtectProfileRequest > payload = ::boost::static_pointer_cast<UnProtectProfileRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileStub*>(getStub())->onUnProtectProfileRequest(payload);
            return;
        }
        case 20: {

            // method 'linkProfile'

            LOG_DEBUG_STUB("process method '%s'", "linkProfile");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LinkProfileRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "LinkProfile", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< LinkProfileRequest > payload = ::boost::static_pointer_cast<LinkProfileRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileStub*>(getStub())->onLinkProfileRequest(payload);
            return;
        }
        case 21: {

            // method 'setValetMode'

            LOG_DEBUG_STUB("process method '%s'", "setValetMode");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetValetModeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetValetMode", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetValetModeRequest > payload = ::boost::static_pointer_cast<SetValetModeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileStub*>(getStub())->onSetValetModeRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* ProfileStubDelegate::introspect() const {
    return     "<interface name=\"bosch.cm.profile\">\n"
            "    <property access=\"read\" name=\"activeProfile\" type=\"y\"/>\n"
            "    <property access=\"read\" name=\"status\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"copyProfile\" type=\"(yy)\"/>\n"
            "    <property access=\"read\" name=\"deleteProfile\" type=\"y\"/>\n"
            "    <property access=\"read\" name=\"dataChanged\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"createProfile\" type=\"y\"/>\n"
            "    <property access=\"readwrite\" name=\"privacyMode\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"profileName\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"profileImage\" type=\"y\"/>\n"
            "    <property access=\"read\" name=\"pinRequested\" type=\"y\"/>\n"
            "    <property access=\"readwrite\" name=\"maxPINAttempts\" type=\"y\"/>\n"
            "    <property access=\"readwrite\" name=\"maxPINAttemptsBeforeDelay\" type=\"y\"/>\n"
            "    <property access=\"readwrite\" name=\"pinAuthenticationDelayTime\" type=\"u\"/>\n"
            "    <property access=\"readwrite\" name=\"pinVerificationValidityTime\" type=\"u\"/>\n"
            "    <property access=\"readwrite\" name=\"activeProfileType\" type=\"u\"/>\n"
            "    <method name=\"doRegisterApp\">\n"
            "      <doc>\n"
            "        <line>doRegisterApp = Each Application, that stores Profile Data has to register here.</line>\n"
            "        <line>The application has to store the AppID returned by RegisterApp and uset it for all other calls to the Profile Manager</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"AppName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>AppName = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"AppID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>AppID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ApplName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>ApplName = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"reloadData\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>reloadData = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"onDataChanged\">\n"
            "      <doc>\n"
            "        <line>onDataChanged = Function to be called after user change has been done. User change is triggered by activeProfile Property update</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"ApplicationPID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ApplicationPID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"onProfileDeleted\">\n"
            "      <doc>\n"
            "        <line>onProfileDeleted = Function to be called after user has been deleted. User deleteion is triggered by deleteProfile Property update</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"ApplicationPID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ApplicationPID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"onProfileCopied\">\n"
            "      <doc>\n"
            "        <line>onProfileCopied = function to be called by the clients after Profile copy action triggered by copyProfile property update has been executed</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"ApplicationPID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ApplicationPID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"onProfileCreated\">\n"
            "      <doc>\n"
            "        <line>onProfileCreated = function to be called by the clients after Profile create action triggered by createProfile property update has been executed</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"ApplicationPID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ApplicationPID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"doCopyProfile\">\n"
            "      <doc>\n"
            "        <line>doCopyProfile = function to request a user copy from the Profile Manager</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"sourceUserID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>sourceUserID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"destUserID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>destUserID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"doDeleteProfile\">\n"
            "      <doc>\n"
            "        <line>doDeleteProfile = function to delete a Profile</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"userID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>userID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"doChangeToProfile\">\n"
            "      <doc>\n"
            "        <line>doChangeToProfile = function to request a change of the current user from the Profile Manager</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"userID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>userID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"doCreateProfile\">\n"
            "      <doc>\n"
            "        <line>doCreateProfile = function to request a creations of a new User Profile from the Profile Manager</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"newName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>newName = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"imageID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>imageID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"newUserID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>newUserID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"do_SetProfileName\">\n"
            "      <doc>\n"
            "        <line>do_SetProfileName = sets the profile name for the current profile</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"newName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>newName = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"userID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>userID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"getProfileNames\">\n"
            "      <doc>\n"
            "        <line>getProfileNames = gets all profile names</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"names\" type=\"as\">\n"
            "        <doc>\n"
            "          <line>names = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"doImportProfileImage\">\n"
            "      <doc>\n"
            "        <line>doImportProfileImage = import an image from usb drive as Proifle image in the given slot. if slot is 0xFFFF, then the profile manager will assign it tot the user image slot for the current Profile</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"sourcePath\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>sourcePath = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"width\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>width = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"height\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>height = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"slotIdx\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>slotIdx = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"bSetForCurrentProfile\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bSetForCurrentProfile = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"removeUserImage\">\n"
            "      <doc>\n"
            "        <line>removeUserImage = delete an imported image referenced by the slotIdx from the system.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"slotIdx\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>slotIdx = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"doSetProfileImage\">\n"
            "      <doc>\n"
            "        <line>doSetProfileImage = set current profile image (index)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"imageID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>imageID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"userID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>userID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"getProfileImages\">\n"
            "      <doc>\n"
            "        <line>getProfileImages = gets all profile images</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"images\" type=\"ay\">\n"
            "        <doc>\n"
            "          <line>images = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"getProfileTypes\">\n"
            "      <doc>\n"
            "        <line>getProfileTypes = gets all profile types</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"types\" type=\"au\">\n"
            "        <doc>\n"
            "          <line>types = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setProfilePin\">\n"
            "      <doc>\n"
            "        <line>setProfilePin = sets Authentication Method PIN</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"profileID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>profileID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Pin\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>Pin = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setRememberMe\">\n"
            "      <doc>\n"
            "        <line>setRememberMe = sets Authentication Method to Remember Me</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"profileID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>profileID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"checkPin\">\n"
            "      <doc>\n"
            "        <line>checkPin = Validates the current PIN. needs to be called before setProfilePin &amp; setRememberMe if Prodile is secured by PIN</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"profileID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>profileID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"PIN\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>PIN = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"unProtectProfile\">\n"
            "      <doc>\n"
            "        <line>unProtectProfile = removes the Authentication Method</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"profileID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>profileID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"linkProfile\">\n"
            "      <doc>\n"
            "        <line>linkProfile = link profile</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"bSetLink\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bSetLink = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setValetMode\">\n"
            "      <doc>\n"
            "        <line>setValetMode = SetValetMode</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"bEnableValetMode\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bEnableValetMode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void ProfileStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<ProfileStub*>(getStub()))->onGetAll (properties);
}

void ProfileStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 15, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "activeProfile");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "status");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "copyProfile");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "deleteProfile");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "dataChanged");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "createProfile");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "privacyMode");
            ::boost::shared_ptr< PrivacyModeSet > payload(new PrivacyModeSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ProfileStub*>(getStub())->onPrivacyModeSet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "profileName");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "profileImage");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "pinRequested");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "maxPINAttempts");
            ::boost::shared_ptr< MaxPINAttemptsSet > payload(new MaxPINAttemptsSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ProfileStub*>(getStub())->onMaxPINAttemptsSet (payload);
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "maxPINAttemptsBeforeDelay");
            ::boost::shared_ptr< MaxPINAttemptsBeforeDelaySet > payload(new MaxPINAttemptsBeforeDelaySet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ProfileStub*>(getStub())->onMaxPINAttemptsBeforeDelaySet (payload);
            return;
        }
        case 12: {
            LOG_DEBUG_STUB("process property '%s'", "pinAuthenticationDelayTime");
            ::boost::shared_ptr< PinAuthenticationDelayTimeSet > payload(new PinAuthenticationDelayTimeSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ProfileStub*>(getStub())->onPinAuthenticationDelayTimeSet (payload);
            return;
        }
        case 13: {
            LOG_DEBUG_STUB("process property '%s'", "pinVerificationValidityTime");
            ::boost::shared_ptr< PinVerificationValidityTimeSet > payload(new PinVerificationValidityTimeSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ProfileStub*>(getStub())->onPinVerificationValidityTimeSet (payload);
            return;
        }
        case 14: {
            LOG_DEBUG_STUB("process property '%s'", "activeProfileType");
            ::boost::shared_ptr< ActiveProfileTypeSet > payload(new ActiveProfileTypeSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ProfileStub*>(getStub())->onActiveProfileTypeSet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void ProfileStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 15, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "activeProfile");
            ::boost::shared_ptr< ActiveProfileGet > payload(new ActiveProfileGet());
            payload->setAct(act);
            static_cast<ProfileStub*>(getStub())->onActiveProfileGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "status");
            ::boost::shared_ptr< StatusGet > payload(new StatusGet());
            payload->setAct(act);
            static_cast<ProfileStub*>(getStub())->onStatusGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "copyProfile");
            ::boost::shared_ptr< CopyProfileGet > payload(new CopyProfileGet());
            payload->setAct(act);
            static_cast<ProfileStub*>(getStub())->onCopyProfileGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "deleteProfile");
            ::boost::shared_ptr< DeleteProfileGet > payload(new DeleteProfileGet());
            payload->setAct(act);
            static_cast<ProfileStub*>(getStub())->onDeleteProfileGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "dataChanged");
            ::boost::shared_ptr< DataChangedGet > payload(new DataChangedGet());
            payload->setAct(act);
            static_cast<ProfileStub*>(getStub())->onDataChangedGet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "createProfile");
            ::boost::shared_ptr< CreateProfileGet > payload(new CreateProfileGet());
            payload->setAct(act);
            static_cast<ProfileStub*>(getStub())->onCreateProfileGet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "privacyMode");
            ::boost::shared_ptr< PrivacyModeGet > payload(new PrivacyModeGet());
            payload->setAct(act);
            static_cast<ProfileStub*>(getStub())->onPrivacyModeGet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "profileName");
            ::boost::shared_ptr< ProfileNameGet > payload(new ProfileNameGet());
            payload->setAct(act);
            static_cast<ProfileStub*>(getStub())->onProfileNameGet (payload);
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "profileImage");
            ::boost::shared_ptr< ProfileImageGet > payload(new ProfileImageGet());
            payload->setAct(act);
            static_cast<ProfileStub*>(getStub())->onProfileImageGet (payload);
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "pinRequested");
            ::boost::shared_ptr< PinRequestedGet > payload(new PinRequestedGet());
            payload->setAct(act);
            static_cast<ProfileStub*>(getStub())->onPinRequestedGet (payload);
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "maxPINAttempts");
            ::boost::shared_ptr< MaxPINAttemptsGet > payload(new MaxPINAttemptsGet());
            payload->setAct(act);
            static_cast<ProfileStub*>(getStub())->onMaxPINAttemptsGet (payload);
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "maxPINAttemptsBeforeDelay");
            ::boost::shared_ptr< MaxPINAttemptsBeforeDelayGet > payload(new MaxPINAttemptsBeforeDelayGet());
            payload->setAct(act);
            static_cast<ProfileStub*>(getStub())->onMaxPINAttemptsBeforeDelayGet (payload);
            return;
        }
        case 12: {
            LOG_DEBUG_STUB("process property '%s'", "pinAuthenticationDelayTime");
            ::boost::shared_ptr< PinAuthenticationDelayTimeGet > payload(new PinAuthenticationDelayTimeGet());
            payload->setAct(act);
            static_cast<ProfileStub*>(getStub())->onPinAuthenticationDelayTimeGet (payload);
            return;
        }
        case 13: {
            LOG_DEBUG_STUB("process property '%s'", "pinVerificationValidityTime");
            ::boost::shared_ptr< PinVerificationValidityTimeGet > payload(new PinVerificationValidityTimeGet());
            payload->setAct(act);
            static_cast<ProfileStub*>(getStub())->onPinVerificationValidityTimeGet (payload);
            return;
        }
        case 14: {
            LOG_DEBUG_STUB("process property '%s'", "activeProfileType");
            ::boost::shared_ptr< ActiveProfileTypeGet > payload(new ActiveProfileTypeGet());
            payload->setAct(act);
            static_cast<ProfileStub*>(getStub())->onActiveProfileTypeGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

ProfileStub::ProfileStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ProfileStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ProfileStub::ProfileStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ProfileStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ProfileStub::~ProfileStub() {
    delete _stubDelegate;
}

void ProfileStub::sendActiveProfileUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ActiveProfileUpdate payload(_activeProfileProperty);

        LOG_INFO ("-> send%s", "ActiveProfileUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("activeProfile", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profile", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ActiveProfileUpdate");
    }
}

void ProfileStub::onActiveProfileGet(const ::boost::shared_ptr< ActiveProfileGet >& activeProfile) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ActiveProfileGet", activeProfile->getAct());
    sendActiveProfileGetUpdate(_activeProfileProperty.getActiveProfile(), activeProfile->getAct());
}

void ProfileStub::sendActiveProfileGetUpdate(uint8 activeProfile, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ActiveProfileGet payload(activeProfile);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ActiveProfileGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfileStub::setActiveProfile(uint8 activeProfile) {
    if(activeProfile!=_activeProfileProperty.getActiveProfile()) {
        _activeProfileProperty.setActiveProfile(activeProfile);
        sendActiveProfileUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 ProfileStub::getActiveProfile() const {
    return _activeProfileProperty.getActiveProfile();
}

void ProfileStub::sendStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StatusUpdate payload(_statusProperty);

        LOG_INFO ("-> send%s", "StatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("status", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profile", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StatusUpdate");
    }
}

void ProfileStub::onStatusGet(const ::boost::shared_ptr< StatusGet >& status) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StatusGet", status->getAct());
    sendStatusGetUpdate(_statusProperty.getStatus(), status->getAct());
}

void ProfileStub::sendStatusGetUpdate(ProfileStatus status, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StatusGet payload(status);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfileStub::setStatus(ProfileStatus status) {
    if(status!=_statusProperty.getStatus()) {
        _statusProperty.setStatus(status);
        sendStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

ProfileStatus ProfileStub::getStatus() const {
    return _statusProperty.getStatus();
}

void ProfileStub::sendCopyProfileUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CopyProfileUpdate payload(_copyProfileProperty);

        LOG_INFO ("-> send%s", "CopyProfileUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("copyProfile", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profile", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CopyProfileUpdate");
    }
}

void ProfileStub::onCopyProfileGet(const ::boost::shared_ptr< CopyProfileGet >& copyProfile) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CopyProfileGet", copyProfile->getAct());
    sendCopyProfileGetUpdate(_copyProfileProperty.getCopyProfile(), copyProfile->getAct());
}

void ProfileStub::sendCopyProfileGetUpdate(const copyInfo& copyProfile, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CopyProfileGet payload(copyProfile);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CopyProfileGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfileStub::setCopyProfile(const copyInfo& copyProfile) {
    if(copyProfile!=_copyProfileProperty.getCopyProfile()) {
        _copyProfileProperty.setCopyProfile(copyProfile);
        sendCopyProfileUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const copyInfo& ProfileStub::getCopyProfile() const {
    return _copyProfileProperty.getCopyProfile();
}

copyInfo& ProfileStub::getCopyProfileMutable() {
    return _copyProfileProperty.getCopyProfileMutable();
}

void ProfileStub::sendDeleteProfileUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DeleteProfileUpdate payload(_deleteProfileProperty);

        LOG_INFO ("-> send%s", "DeleteProfileUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("deleteProfile", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profile", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DeleteProfileUpdate");
    }
}

void ProfileStub::onDeleteProfileGet(const ::boost::shared_ptr< DeleteProfileGet >& deleteProfile) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DeleteProfileGet", deleteProfile->getAct());
    sendDeleteProfileGetUpdate(_deleteProfileProperty.getDeleteProfile(), deleteProfile->getAct());
}

void ProfileStub::sendDeleteProfileGetUpdate(uint8 deleteProfile, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DeleteProfileGet payload(deleteProfile);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DeleteProfileGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfileStub::setDeleteProfile(uint8 deleteProfile) {
    if(deleteProfile!=_deleteProfileProperty.getDeleteProfile()) {
        _deleteProfileProperty.setDeleteProfile(deleteProfile);
        sendDeleteProfileUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 ProfileStub::getDeleteProfile() const {
    return _deleteProfileProperty.getDeleteProfile();
}

void ProfileStub::sendDataChangedUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DataChangedUpdate payload(_dataChangedProperty);

        LOG_INFO ("-> send%s", "DataChangedUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("dataChanged", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profile", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DataChangedUpdate");
    }
}

void ProfileStub::onDataChangedGet(const ::boost::shared_ptr< DataChangedGet >& dataChanged) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DataChangedGet", dataChanged->getAct());
    sendDataChangedGetUpdate(_dataChangedProperty.getDataChanged(), dataChanged->getAct());
}

void ProfileStub::sendDataChangedGetUpdate(dataChangeReason dataChanged, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DataChangedGet payload(dataChanged);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DataChangedGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfileStub::setDataChanged(dataChangeReason dataChanged) {
    if(dataChanged!=_dataChangedProperty.getDataChanged()) {
        _dataChangedProperty.setDataChanged(dataChanged);
        sendDataChangedUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

dataChangeReason ProfileStub::getDataChanged() const {
    return _dataChangedProperty.getDataChanged();
}

void ProfileStub::sendCreateProfileUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CreateProfileUpdate payload(_createProfileProperty);

        LOG_INFO ("-> send%s", "CreateProfileUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("createProfile", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profile", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CreateProfileUpdate");
    }
}

void ProfileStub::onCreateProfileGet(const ::boost::shared_ptr< CreateProfileGet >& createProfile) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CreateProfileGet", createProfile->getAct());
    sendCreateProfileGetUpdate(_createProfileProperty.getCreateProfile(), createProfile->getAct());
}

void ProfileStub::sendCreateProfileGetUpdate(uint8 createProfile, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CreateProfileGet payload(createProfile);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CreateProfileGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfileStub::setCreateProfile(uint8 createProfile) {
    if(createProfile!=_createProfileProperty.getCreateProfile()) {
        _createProfileProperty.setCreateProfile(createProfile);
        sendCreateProfileUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 ProfileStub::getCreateProfile() const {
    return _createProfileProperty.getCreateProfile();
}

void ProfileStub::sendPrivacyModeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PrivacyModeUpdate payload(_privacyModeProperty);

        LOG_INFO ("-> send%s", "PrivacyModeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("privacyMode", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profile", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PrivacyModeUpdate");
    }
}

void ProfileStub::onPrivacyModeGet(const ::boost::shared_ptr< PrivacyModeGet >& privacyMode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PrivacyModeGet", privacyMode->getAct());
    sendPrivacyModeGetUpdate(_privacyModeProperty.getPrivacyMode(), privacyMode->getAct());
}

void ProfileStub::sendPrivacyModeGetUpdate(uint32 privacyMode, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PrivacyModeGet payload(privacyMode);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PrivacyModeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfileStub::onPrivacyModeSet(const ::boost::shared_ptr< PrivacyModeSet >& privacyMode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PrivacyModeSet", privacyMode->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*privacyMode, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setPrivacyMode (privacyMode->getPrivacyMode());
    sendPrivacyModeSetUpdate(privacyMode->getAct());
}

void ProfileStub::sendPrivacyModeSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PrivacyModeSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ProfileStub::setPrivacyMode(uint32 privacyMode) {
    if(privacyMode!=_privacyModeProperty.getPrivacyMode()) {
        _privacyModeProperty.setPrivacyMode(privacyMode);
        sendPrivacyModeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 ProfileStub::getPrivacyMode() const {
    return _privacyModeProperty.getPrivacyMode();
}

void ProfileStub::sendProfileNameUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ProfileNameUpdate payload(_profileNameProperty);

        LOG_INFO ("-> send%s", "ProfileNameUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("profileName", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profile", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ProfileNameUpdate");
    }
}

void ProfileStub::onProfileNameGet(const ::boost::shared_ptr< ProfileNameGet >& profileName) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ProfileNameGet", profileName->getAct());
    sendProfileNameGetUpdate(_profileNameProperty.getProfileName(), profileName->getAct());
}

void ProfileStub::sendProfileNameGetUpdate(const ::std::string& profileName, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ProfileNameGet payload(profileName);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ProfileNameGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfileStub::setProfileName(const ::std::string& profileName) {
    if(profileName!=_profileNameProperty.getProfileName()) {
        _profileNameProperty.setProfileName(profileName);
        sendProfileNameUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ProfileStub::getProfileName() const {
    return _profileNameProperty.getProfileName();
}

::std::string& ProfileStub::getProfileNameMutable() {
    return _profileNameProperty.getProfileNameMutable();
}

void ProfileStub::sendProfileImageUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ProfileImageUpdate payload(_profileImageProperty);

        LOG_INFO ("-> send%s", "ProfileImageUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("profileImage", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profile", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ProfileImageUpdate");
    }
}

void ProfileStub::onProfileImageGet(const ::boost::shared_ptr< ProfileImageGet >& profileImage) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ProfileImageGet", profileImage->getAct());
    sendProfileImageGetUpdate(_profileImageProperty.getProfileImage(), profileImage->getAct());
}

void ProfileStub::sendProfileImageGetUpdate(uint8 profileImage, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ProfileImageGet payload(profileImage);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ProfileImageGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfileStub::setProfileImage(uint8 profileImage) {
    if(profileImage!=_profileImageProperty.getProfileImage()) {
        _profileImageProperty.setProfileImage(profileImage);
        sendProfileImageUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 ProfileStub::getProfileImage() const {
    return _profileImageProperty.getProfileImage();
}

void ProfileStub::sendPinRequestedUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PinRequestedUpdate payload(_pinRequestedProperty);

        LOG_INFO ("-> send%s", "PinRequestedUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("pinRequested", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profile", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PinRequestedUpdate");
    }
}

void ProfileStub::onPinRequestedGet(const ::boost::shared_ptr< PinRequestedGet >& pinRequested) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PinRequestedGet", pinRequested->getAct());
    sendPinRequestedGetUpdate(_pinRequestedProperty.getPinRequested(), pinRequested->getAct());
}

void ProfileStub::sendPinRequestedGetUpdate(uint8 pinRequested, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PinRequestedGet payload(pinRequested);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PinRequestedGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfileStub::setPinRequested(uint8 pinRequested) {
    if(pinRequested!=_pinRequestedProperty.getPinRequested()) {
        _pinRequestedProperty.setPinRequested(pinRequested);
        sendPinRequestedUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 ProfileStub::getPinRequested() const {
    return _pinRequestedProperty.getPinRequested();
}

void ProfileStub::sendMaxPINAttemptsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MaxPINAttemptsUpdate payload(_maxPINAttemptsProperty);

        LOG_INFO ("-> send%s", "MaxPINAttemptsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("maxPINAttempts", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profile", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MaxPINAttemptsUpdate");
    }
}

void ProfileStub::onMaxPINAttemptsGet(const ::boost::shared_ptr< MaxPINAttemptsGet >& maxPINAttempts) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MaxPINAttemptsGet", maxPINAttempts->getAct());
    sendMaxPINAttemptsGetUpdate(_maxPINAttemptsProperty.getMaxPINAttempts(), maxPINAttempts->getAct());
}

void ProfileStub::sendMaxPINAttemptsGetUpdate(uint8 maxPINAttempts, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MaxPINAttemptsGet payload(maxPINAttempts);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MaxPINAttemptsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfileStub::onMaxPINAttemptsSet(const ::boost::shared_ptr< MaxPINAttemptsSet >& maxPINAttempts) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MaxPINAttemptsSet", maxPINAttempts->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*maxPINAttempts, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setMaxPINAttempts (maxPINAttempts->getMaxPINAttempts());
    sendMaxPINAttemptsSetUpdate(maxPINAttempts->getAct());
}

void ProfileStub::sendMaxPINAttemptsSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MaxPINAttemptsSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ProfileStub::setMaxPINAttempts(uint8 maxPINAttempts) {
    if(maxPINAttempts!=_maxPINAttemptsProperty.getMaxPINAttempts()) {
        _maxPINAttemptsProperty.setMaxPINAttempts(maxPINAttempts);
        sendMaxPINAttemptsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 ProfileStub::getMaxPINAttempts() const {
    return _maxPINAttemptsProperty.getMaxPINAttempts();
}

void ProfileStub::sendMaxPINAttemptsBeforeDelayUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MaxPINAttemptsBeforeDelayUpdate payload(_maxPINAttemptsBeforeDelayProperty);

        LOG_INFO ("-> send%s", "MaxPINAttemptsBeforeDelayUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("maxPINAttemptsBeforeDelay", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profile", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MaxPINAttemptsBeforeDelayUpdate");
    }
}

void ProfileStub::onMaxPINAttemptsBeforeDelayGet(const ::boost::shared_ptr< MaxPINAttemptsBeforeDelayGet >& maxPINAttemptsBeforeDelay) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MaxPINAttemptsBeforeDelayGet", maxPINAttemptsBeforeDelay->getAct());
    sendMaxPINAttemptsBeforeDelayGetUpdate(_maxPINAttemptsBeforeDelayProperty.getMaxPINAttemptsBeforeDelay(), maxPINAttemptsBeforeDelay->getAct());
}

void ProfileStub::sendMaxPINAttemptsBeforeDelayGetUpdate(uint8 maxPINAttemptsBeforeDelay, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MaxPINAttemptsBeforeDelayGet payload(maxPINAttemptsBeforeDelay);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MaxPINAttemptsBeforeDelayGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfileStub::onMaxPINAttemptsBeforeDelaySet(const ::boost::shared_ptr< MaxPINAttemptsBeforeDelaySet >& maxPINAttemptsBeforeDelay) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MaxPINAttemptsBeforeDelaySet", maxPINAttemptsBeforeDelay->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*maxPINAttemptsBeforeDelay, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setMaxPINAttemptsBeforeDelay (maxPINAttemptsBeforeDelay->getMaxPINAttemptsBeforeDelay());
    sendMaxPINAttemptsBeforeDelaySetUpdate(maxPINAttemptsBeforeDelay->getAct());
}

void ProfileStub::sendMaxPINAttemptsBeforeDelaySetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MaxPINAttemptsBeforeDelaySetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ProfileStub::setMaxPINAttemptsBeforeDelay(uint8 maxPINAttemptsBeforeDelay) {
    if(maxPINAttemptsBeforeDelay!=_maxPINAttemptsBeforeDelayProperty.getMaxPINAttemptsBeforeDelay()) {
        _maxPINAttemptsBeforeDelayProperty.setMaxPINAttemptsBeforeDelay(maxPINAttemptsBeforeDelay);
        sendMaxPINAttemptsBeforeDelayUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 ProfileStub::getMaxPINAttemptsBeforeDelay() const {
    return _maxPINAttemptsBeforeDelayProperty.getMaxPINAttemptsBeforeDelay();
}

void ProfileStub::sendPinAuthenticationDelayTimeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PinAuthenticationDelayTimeUpdate payload(_pinAuthenticationDelayTimeProperty);

        LOG_INFO ("-> send%s", "PinAuthenticationDelayTimeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("pinAuthenticationDelayTime", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profile", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PinAuthenticationDelayTimeUpdate");
    }
}

void ProfileStub::onPinAuthenticationDelayTimeGet(const ::boost::shared_ptr< PinAuthenticationDelayTimeGet >& pinAuthenticationDelayTime) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PinAuthenticationDelayTimeGet", pinAuthenticationDelayTime->getAct());
    sendPinAuthenticationDelayTimeGetUpdate(_pinAuthenticationDelayTimeProperty.getPinAuthenticationDelayTime(), pinAuthenticationDelayTime->getAct());
}

void ProfileStub::sendPinAuthenticationDelayTimeGetUpdate(uint32 pinAuthenticationDelayTime, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PinAuthenticationDelayTimeGet payload(pinAuthenticationDelayTime);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PinAuthenticationDelayTimeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfileStub::onPinAuthenticationDelayTimeSet(const ::boost::shared_ptr< PinAuthenticationDelayTimeSet >& pinAuthenticationDelayTime) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PinAuthenticationDelayTimeSet", pinAuthenticationDelayTime->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*pinAuthenticationDelayTime, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setPinAuthenticationDelayTime (pinAuthenticationDelayTime->getPinAuthenticationDelayTime());
    sendPinAuthenticationDelayTimeSetUpdate(pinAuthenticationDelayTime->getAct());
}

void ProfileStub::sendPinAuthenticationDelayTimeSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PinAuthenticationDelayTimeSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ProfileStub::setPinAuthenticationDelayTime(uint32 pinAuthenticationDelayTime) {
    if(pinAuthenticationDelayTime!=_pinAuthenticationDelayTimeProperty.getPinAuthenticationDelayTime()) {
        _pinAuthenticationDelayTimeProperty.setPinAuthenticationDelayTime(pinAuthenticationDelayTime);
        sendPinAuthenticationDelayTimeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 ProfileStub::getPinAuthenticationDelayTime() const {
    return _pinAuthenticationDelayTimeProperty.getPinAuthenticationDelayTime();
}

void ProfileStub::sendPinVerificationValidityTimeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PinVerificationValidityTimeUpdate payload(_pinVerificationValidityTimeProperty);

        LOG_INFO ("-> send%s", "PinVerificationValidityTimeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("pinVerificationValidityTime", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profile", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PinVerificationValidityTimeUpdate");
    }
}

void ProfileStub::onPinVerificationValidityTimeGet(const ::boost::shared_ptr< PinVerificationValidityTimeGet >& pinVerificationValidityTime) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PinVerificationValidityTimeGet", pinVerificationValidityTime->getAct());
    sendPinVerificationValidityTimeGetUpdate(_pinVerificationValidityTimeProperty.getPinVerificationValidityTime(), pinVerificationValidityTime->getAct());
}

void ProfileStub::sendPinVerificationValidityTimeGetUpdate(uint32 pinVerificationValidityTime, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PinVerificationValidityTimeGet payload(pinVerificationValidityTime);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PinVerificationValidityTimeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfileStub::onPinVerificationValidityTimeSet(const ::boost::shared_ptr< PinVerificationValidityTimeSet >& pinVerificationValidityTime) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PinVerificationValidityTimeSet", pinVerificationValidityTime->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*pinVerificationValidityTime, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setPinVerificationValidityTime (pinVerificationValidityTime->getPinVerificationValidityTime());
    sendPinVerificationValidityTimeSetUpdate(pinVerificationValidityTime->getAct());
}

void ProfileStub::sendPinVerificationValidityTimeSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PinVerificationValidityTimeSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ProfileStub::setPinVerificationValidityTime(uint32 pinVerificationValidityTime) {
    if(pinVerificationValidityTime!=_pinVerificationValidityTimeProperty.getPinVerificationValidityTime()) {
        _pinVerificationValidityTimeProperty.setPinVerificationValidityTime(pinVerificationValidityTime);
        sendPinVerificationValidityTimeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 ProfileStub::getPinVerificationValidityTime() const {
    return _pinVerificationValidityTimeProperty.getPinVerificationValidityTime();
}

void ProfileStub::sendActiveProfileTypeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ActiveProfileTypeUpdate payload(_activeProfileTypeProperty);

        LOG_INFO ("-> send%s", "ActiveProfileTypeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("activeProfileType", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profile", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ActiveProfileTypeUpdate");
    }
}

void ProfileStub::onActiveProfileTypeGet(const ::boost::shared_ptr< ActiveProfileTypeGet >& activeProfileType) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ActiveProfileTypeGet", activeProfileType->getAct());
    sendActiveProfileTypeGetUpdate(_activeProfileTypeProperty.getActiveProfileType(), activeProfileType->getAct());
}

void ProfileStub::sendActiveProfileTypeGetUpdate(profileType activeProfileType, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ActiveProfileTypeGet payload(activeProfileType);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ActiveProfileTypeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfileStub::onActiveProfileTypeSet(const ::boost::shared_ptr< ActiveProfileTypeSet >& activeProfileType) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ActiveProfileTypeSet", activeProfileType->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*activeProfileType, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setActiveProfileType (activeProfileType->getActiveProfileType());
    sendActiveProfileTypeSetUpdate(activeProfileType->getAct());
}

void ProfileStub::sendActiveProfileTypeSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ActiveProfileTypeSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ProfileStub::setActiveProfileType(profileType activeProfileType) {
    if(activeProfileType!=_activeProfileTypeProperty.getActiveProfileType()) {
        _activeProfileTypeProperty.setActiveProfileType(activeProfileType);
        sendActiveProfileTypeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

profileType ProfileStub::getActiveProfileType() const {
    return _activeProfileTypeProperty.getActiveProfileType();
}

void  ProfileStub::sendDoRegisterAppResponse (uint32 appID, const ::std::string& applName, bool reloadData, act_t act) {
    DoRegisterAppResponse* payload = new DoRegisterAppResponse(appID, applName, reloadData);
    DBUS_MESSAGE_REPLY(dbusMessage, "doRegisterApp", DoRegisterAppResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DoRegisterApp", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendDoRegisterAppError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DoRegisterAppError* payload = new DoRegisterAppError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "doRegisterApp", DoRegisterAppError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DoRegisterApp", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}





void  ProfileStub::sendDoCopyProfileResponse (serverResult result, act_t act) {
    DoCopyProfileResponse* payload = new DoCopyProfileResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "doCopyProfile", DoCopyProfileResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DoCopyProfile", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendDoCopyProfileError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DoCopyProfileError* payload = new DoCopyProfileError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "doCopyProfile", DoCopyProfileError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DoCopyProfile", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendDoDeleteProfileResponse (serverResult result, act_t act) {
    DoDeleteProfileResponse* payload = new DoDeleteProfileResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "doDeleteProfile", DoDeleteProfileResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DoDeleteProfile", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendDoDeleteProfileError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DoDeleteProfileError* payload = new DoDeleteProfileError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "doDeleteProfile", DoDeleteProfileError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DoDeleteProfile", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendDoChangeToProfileResponse (serverResult result, act_t act) {
    DoChangeToProfileResponse* payload = new DoChangeToProfileResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "doChangeToProfile", DoChangeToProfileResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DoChangeToProfile", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendDoChangeToProfileError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DoChangeToProfileError* payload = new DoChangeToProfileError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "doChangeToProfile", DoChangeToProfileError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DoChangeToProfile", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendDoCreateProfileResponse (serverResult result, uint8 newUserID, act_t act) {
    DoCreateProfileResponse* payload = new DoCreateProfileResponse(result, newUserID);
    DBUS_MESSAGE_REPLY(dbusMessage, "doCreateProfile", DoCreateProfileResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DoCreateProfile", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendDoCreateProfileError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DoCreateProfileError* payload = new DoCreateProfileError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "doCreateProfile", DoCreateProfileError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DoCreateProfile", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendDo_SetProfileNameResponse (serverResult result, act_t act) {
    Do_SetProfileNameResponse* payload = new Do_SetProfileNameResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "do_SetProfileName", Do_SetProfileNameResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Do_SetProfileName", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendDo_SetProfileNameError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    Do_SetProfileNameError* payload = new Do_SetProfileNameError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "do_SetProfileName", Do_SetProfileNameError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Do_SetProfileName", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendGetProfileNamesResponse (const ::std::vector< ::std::string >& names, act_t act) {
    GetProfileNamesResponse* payload = new GetProfileNamesResponse(names);
    DBUS_MESSAGE_REPLY(dbusMessage, "getProfileNames", GetProfileNamesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetProfileNames", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendGetProfileNamesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetProfileNamesError* payload = new GetProfileNamesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getProfileNames", GetProfileNamesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetProfileNames", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendDoImportProfileImageResponse (serverResult result, act_t act) {
    DoImportProfileImageResponse* payload = new DoImportProfileImageResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "doImportProfileImage", DoImportProfileImageResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DoImportProfileImage", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendDoImportProfileImageError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DoImportProfileImageError* payload = new DoImportProfileImageError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "doImportProfileImage", DoImportProfileImageError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DoImportProfileImage", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendRemoveUserImageResponse (serverResult result, act_t act) {
    RemoveUserImageResponse* payload = new RemoveUserImageResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "removeUserImage", RemoveUserImageResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RemoveUserImage", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendRemoveUserImageError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RemoveUserImageError* payload = new RemoveUserImageError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "removeUserImage", RemoveUserImageError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RemoveUserImage", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendDoSetProfileImageResponse (serverResult result, act_t act) {
    DoSetProfileImageResponse* payload = new DoSetProfileImageResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "doSetProfileImage", DoSetProfileImageResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DoSetProfileImage", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendDoSetProfileImageError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DoSetProfileImageError* payload = new DoSetProfileImageError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "doSetProfileImage", DoSetProfileImageError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DoSetProfileImage", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendGetProfileImagesResponse (const ::std::vector< uint8 >& images, act_t act) {
    GetProfileImagesResponse* payload = new GetProfileImagesResponse(images);
    DBUS_MESSAGE_REPLY(dbusMessage, "getProfileImages", GetProfileImagesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetProfileImages", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendGetProfileImagesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetProfileImagesError* payload = new GetProfileImagesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getProfileImages", GetProfileImagesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetProfileImages", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendGetProfileTypesResponse (const ::std::vector< profileType >& types, act_t act) {
    GetProfileTypesResponse* payload = new GetProfileTypesResponse(types);
    DBUS_MESSAGE_REPLY(dbusMessage, "getProfileTypes", GetProfileTypesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetProfileTypes", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendGetProfileTypesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetProfileTypesError* payload = new GetProfileTypesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getProfileTypes", GetProfileTypesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetProfileTypes", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendSetProfilePinResponse (serverResult result, act_t act) {
    SetProfilePinResponse* payload = new SetProfilePinResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "setProfilePin", SetProfilePinResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetProfilePin", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendSetProfilePinError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetProfilePinError* payload = new SetProfilePinError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setProfilePin", SetProfilePinError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetProfilePin", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendSetRememberMeResponse (serverResult result, act_t act) {
    SetRememberMeResponse* payload = new SetRememberMeResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "setRememberMe", SetRememberMeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetRememberMe", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendSetRememberMeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetRememberMeError* payload = new SetRememberMeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setRememberMe", SetRememberMeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetRememberMe", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendCheckPinResponse (serverResult result, act_t act) {
    CheckPinResponse* payload = new CheckPinResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "checkPin", CheckPinResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "CheckPin", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendCheckPinError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CheckPinError* payload = new CheckPinError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "checkPin", CheckPinError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "CheckPin", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendUnProtectProfileResponse (serverResult result, act_t act) {
    UnProtectProfileResponse* payload = new UnProtectProfileResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "unProtectProfile", UnProtectProfileResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UnProtectProfile", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendUnProtectProfileError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UnProtectProfileError* payload = new UnProtectProfileError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "unProtectProfile", UnProtectProfileError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UnProtectProfile", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendLinkProfileResponse (serverResult result, act_t act) {
    LinkProfileResponse* payload = new LinkProfileResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "linkProfile", LinkProfileResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "LinkProfile", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendLinkProfileError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    LinkProfileError* payload = new LinkProfileError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "linkProfile", LinkProfileError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "LinkProfile", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendSetValetModeResponse (serverResult result, act_t act) {
    SetValetModeResponse* payload = new SetValetModeResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "setValetMode", SetValetModeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetValetMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileStub::sendSetValetModeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetValetModeError* payload = new SetValetModeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setValetMode", SetValetModeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetValetMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void ProfileStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'activeProfile'
    {
        ::asf::dbus::DBusVariant variant;
        ActiveProfileGet payload(_activeProfileProperty.getActiveProfile());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("activeProfile", variant));
    }

    //property 'status'
    {
        ::asf::dbus::DBusVariant variant;
        StatusGet payload(_statusProperty.getStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("status", variant));
    }

    //property 'copyProfile'
    {
        ::asf::dbus::DBusVariant variant;
        CopyProfileGet payload(_copyProfileProperty.getCopyProfile());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("copyProfile", variant));
    }

    //property 'deleteProfile'
    {
        ::asf::dbus::DBusVariant variant;
        DeleteProfileGet payload(_deleteProfileProperty.getDeleteProfile());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("deleteProfile", variant));
    }

    //property 'dataChanged'
    {
        ::asf::dbus::DBusVariant variant;
        DataChangedGet payload(_dataChangedProperty.getDataChanged());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("dataChanged", variant));
    }

    //property 'createProfile'
    {
        ::asf::dbus::DBusVariant variant;
        CreateProfileGet payload(_createProfileProperty.getCreateProfile());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("createProfile", variant));
    }

    //property 'privacyMode'
    {
        ::asf::dbus::DBusVariant variant;
        PrivacyModeGet payload(_privacyModeProperty.getPrivacyMode());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("privacyMode", variant));
    }

    //property 'profileName'
    {
        ::asf::dbus::DBusVariant variant;
        ProfileNameGet payload(_profileNameProperty.getProfileName());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("profileName", variant));
    }

    //property 'profileImage'
    {
        ::asf::dbus::DBusVariant variant;
        ProfileImageGet payload(_profileImageProperty.getProfileImage());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("profileImage", variant));
    }

    //property 'pinRequested'
    {
        ::asf::dbus::DBusVariant variant;
        PinRequestedGet payload(_pinRequestedProperty.getPinRequested());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("pinRequested", variant));
    }

    //property 'maxPINAttempts'
    {
        ::asf::dbus::DBusVariant variant;
        MaxPINAttemptsGet payload(_maxPINAttemptsProperty.getMaxPINAttempts());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("maxPINAttempts", variant));
    }

    //property 'maxPINAttemptsBeforeDelay'
    {
        ::asf::dbus::DBusVariant variant;
        MaxPINAttemptsBeforeDelayGet payload(_maxPINAttemptsBeforeDelayProperty.getMaxPINAttemptsBeforeDelay());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("maxPINAttemptsBeforeDelay", variant));
    }

    //property 'pinAuthenticationDelayTime'
    {
        ::asf::dbus::DBusVariant variant;
        PinAuthenticationDelayTimeGet payload(_pinAuthenticationDelayTimeProperty.getPinAuthenticationDelayTime());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("pinAuthenticationDelayTime", variant));
    }

    //property 'pinVerificationValidityTime'
    {
        ::asf::dbus::DBusVariant variant;
        PinVerificationValidityTimeGet payload(_pinVerificationValidityTimeProperty.getPinVerificationValidityTime());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("pinVerificationValidityTime", variant));
    }

    //property 'activeProfileType'
    {
        ::asf::dbus::DBusVariant variant;
        ActiveProfileTypeGet payload(_activeProfileTypeProperty.getActiveProfileType());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("activeProfileType", variant));
    }
}

} // namespace profile
} // namespace cm
} // namespace bosch
