/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_PROFILEPROXY_H
#define BOSCH_CM_PROFILEPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/profile.h"
#include "bosch/cm/profileConst.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include <dbus/dbus.h>
#include <string>

namespace bosch {
namespace cm {
namespace profile {

class ProfileProxy;

class ActiveProfileCallbackIF {
public:
    virtual ~ActiveProfileCallbackIF() {}

    virtual void onActiveProfileError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< ActiveProfileError >& error) = 0;

    virtual void onActiveProfileUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< ActiveProfileUpdate >& update) = 0;
};

class ActiveProfileTypeCallbackIF {
public:
    virtual ~ActiveProfileTypeCallbackIF() {}

    virtual void onActiveProfileTypeError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< ActiveProfileTypeError >& error) = 0;

    virtual void onActiveProfileTypeUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< ActiveProfileTypeUpdate >& update) = 0;
};

class CheckPinCallbackIF {
public:
    virtual ~CheckPinCallbackIF() {}

    virtual void onCheckPinError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< CheckPinError >& error) = 0;

    virtual void onCheckPinResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< CheckPinResponse >& response) = 0;
};

class CopyProfileCallbackIF {
public:
    virtual ~CopyProfileCallbackIF() {}

    virtual void onCopyProfileError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< CopyProfileError >& error) = 0;

    virtual void onCopyProfileUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< CopyProfileUpdate >& update) = 0;
};

class CreateProfileCallbackIF {
public:
    virtual ~CreateProfileCallbackIF() {}

    virtual void onCreateProfileError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< CreateProfileError >& error) = 0;

    virtual void onCreateProfileUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< CreateProfileUpdate >& update) = 0;
};

class DataChangedCallbackIF {
public:
    virtual ~DataChangedCallbackIF() {}

    virtual void onDataChangedError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< DataChangedError >& error) = 0;

    virtual void onDataChangedUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< DataChangedUpdate >& update) = 0;
};

class DeleteProfileCallbackIF {
public:
    virtual ~DeleteProfileCallbackIF() {}

    virtual void onDeleteProfileError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< DeleteProfileError >& error) = 0;

    virtual void onDeleteProfileUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< DeleteProfileUpdate >& update) = 0;
};

class DoChangeToProfileCallbackIF {
public:
    virtual ~DoChangeToProfileCallbackIF() {}

    virtual void onDoChangeToProfileError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< DoChangeToProfileError >& error) = 0;

    virtual void onDoChangeToProfileResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< DoChangeToProfileResponse >& response) = 0;
};

class DoCopyProfileCallbackIF {
public:
    virtual ~DoCopyProfileCallbackIF() {}

    virtual void onDoCopyProfileError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< DoCopyProfileError >& error) = 0;

    virtual void onDoCopyProfileResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< DoCopyProfileResponse >& response) = 0;
};

class DoCreateProfileCallbackIF {
public:
    virtual ~DoCreateProfileCallbackIF() {}

    virtual void onDoCreateProfileError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< DoCreateProfileError >& error) = 0;

    virtual void onDoCreateProfileResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< DoCreateProfileResponse >& response) = 0;
};

class DoDeleteProfileCallbackIF {
public:
    virtual ~DoDeleteProfileCallbackIF() {}

    virtual void onDoDeleteProfileError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< DoDeleteProfileError >& error) = 0;

    virtual void onDoDeleteProfileResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< DoDeleteProfileResponse >& response) = 0;
};

class DoImportProfileImageCallbackIF {
public:
    virtual ~DoImportProfileImageCallbackIF() {}

    virtual void onDoImportProfileImageError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< DoImportProfileImageError >& error) = 0;

    virtual void onDoImportProfileImageResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< DoImportProfileImageResponse >& response) = 0;
};

class DoRegisterAppCallbackIF {
public:
    virtual ~DoRegisterAppCallbackIF() {}

    virtual void onDoRegisterAppError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< DoRegisterAppError >& error) = 0;

    virtual void onDoRegisterAppResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< DoRegisterAppResponse >& response) = 0;
};

class DoSetProfileImageCallbackIF {
public:
    virtual ~DoSetProfileImageCallbackIF() {}

    virtual void onDoSetProfileImageError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< DoSetProfileImageError >& error) = 0;

    virtual void onDoSetProfileImageResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< DoSetProfileImageResponse >& response) = 0;
};

class Do_SetProfileNameCallbackIF {
public:
    virtual ~Do_SetProfileNameCallbackIF() {}

    virtual void onDo_SetProfileNameError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< Do_SetProfileNameError >& error) = 0;

    virtual void onDo_SetProfileNameResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< Do_SetProfileNameResponse >& response) = 0;
};

class GetProfileImagesCallbackIF {
public:
    virtual ~GetProfileImagesCallbackIF() {}

    virtual void onGetProfileImagesError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< GetProfileImagesError >& error) = 0;

    virtual void onGetProfileImagesResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< GetProfileImagesResponse >& response) = 0;
};

class GetProfileNamesCallbackIF {
public:
    virtual ~GetProfileNamesCallbackIF() {}

    virtual void onGetProfileNamesError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< GetProfileNamesError >& error) = 0;

    virtual void onGetProfileNamesResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< GetProfileNamesResponse >& response) = 0;
};

class GetProfileTypesCallbackIF {
public:
    virtual ~GetProfileTypesCallbackIF() {}

    virtual void onGetProfileTypesError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< GetProfileTypesError >& error) = 0;

    virtual void onGetProfileTypesResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< GetProfileTypesResponse >& response) = 0;
};

class LinkProfileCallbackIF {
public:
    virtual ~LinkProfileCallbackIF() {}

    virtual void onLinkProfileError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< LinkProfileError >& error) = 0;

    virtual void onLinkProfileResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< LinkProfileResponse >& response) = 0;
};

class MaxPINAttemptsBeforeDelayCallbackIF {
public:
    virtual ~MaxPINAttemptsBeforeDelayCallbackIF() {}

    virtual void onMaxPINAttemptsBeforeDelayError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< MaxPINAttemptsBeforeDelayError >& error) = 0;

    virtual void onMaxPINAttemptsBeforeDelayUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< MaxPINAttemptsBeforeDelayUpdate >& update) = 0;
};

class MaxPINAttemptsCallbackIF {
public:
    virtual ~MaxPINAttemptsCallbackIF() {}

    virtual void onMaxPINAttemptsError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< MaxPINAttemptsError >& error) = 0;

    virtual void onMaxPINAttemptsUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< MaxPINAttemptsUpdate >& update) = 0;
};

class PinAuthenticationDelayTimeCallbackIF {
public:
    virtual ~PinAuthenticationDelayTimeCallbackIF() {}

    virtual void onPinAuthenticationDelayTimeError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< PinAuthenticationDelayTimeError >& error) = 0;

    virtual void onPinAuthenticationDelayTimeUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< PinAuthenticationDelayTimeUpdate >& update) = 0;
};

class PinRequestedCallbackIF {
public:
    virtual ~PinRequestedCallbackIF() {}

    virtual void onPinRequestedError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< PinRequestedError >& error) = 0;

    virtual void onPinRequestedUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< PinRequestedUpdate >& update) = 0;
};

class PinVerificationValidityTimeCallbackIF {
public:
    virtual ~PinVerificationValidityTimeCallbackIF() {}

    virtual void onPinVerificationValidityTimeError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< PinVerificationValidityTimeError >& error) = 0;

    virtual void onPinVerificationValidityTimeUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< PinVerificationValidityTimeUpdate >& update) = 0;
};

class PrivacyModeCallbackIF {
public:
    virtual ~PrivacyModeCallbackIF() {}

    virtual void onPrivacyModeError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< PrivacyModeError >& error) = 0;

    virtual void onPrivacyModeUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< PrivacyModeUpdate >& update) = 0;
};

class ProfileImageCallbackIF {
public:
    virtual ~ProfileImageCallbackIF() {}

    virtual void onProfileImageError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< ProfileImageError >& error) = 0;

    virtual void onProfileImageUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< ProfileImageUpdate >& update) = 0;
};

class ProfileNameCallbackIF {
public:
    virtual ~ProfileNameCallbackIF() {}

    virtual void onProfileNameError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< ProfileNameError >& error) = 0;

    virtual void onProfileNameUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< ProfileNameUpdate >& update) = 0;
};

class RemoveUserImageCallbackIF {
public:
    virtual ~RemoveUserImageCallbackIF() {}

    virtual void onRemoveUserImageError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< RemoveUserImageError >& error) = 0;

    virtual void onRemoveUserImageResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< RemoveUserImageResponse >& response) = 0;
};

class SetProfilePinCallbackIF {
public:
    virtual ~SetProfilePinCallbackIF() {}

    virtual void onSetProfilePinError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< SetProfilePinError >& error) = 0;

    virtual void onSetProfilePinResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< SetProfilePinResponse >& response) = 0;
};

class SetRememberMeCallbackIF {
public:
    virtual ~SetRememberMeCallbackIF() {}

    virtual void onSetRememberMeError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< SetRememberMeError >& error) = 0;

    virtual void onSetRememberMeResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< SetRememberMeResponse >& response) = 0;
};

class SetValetModeCallbackIF {
public:
    virtual ~SetValetModeCallbackIF() {}

    virtual void onSetValetModeError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< SetValetModeError >& error) = 0;

    virtual void onSetValetModeResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< SetValetModeResponse >& response) = 0;
};

class StatusCallbackIF {
public:
    virtual ~StatusCallbackIF() {}

    virtual void onStatusError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< StatusError >& error) = 0;

    virtual void onStatusUpdate(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< StatusUpdate >& update) = 0;
};

class UnProtectProfileCallbackIF {
public:
    virtual ~UnProtectProfileCallbackIF() {}

    virtual void onUnProtectProfileError(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< UnProtectProfileError >& error) = 0;

    virtual void onUnProtectProfileResponse(const ::boost::shared_ptr< ProfileProxy >& proxy, const ::boost::shared_ptr< UnProtectProfileResponse >& response) = 0;
};


/**
 * ProfileProxy is the client side representation of the D-Bus service
 * interface 'bosch.cm.profile' (specified in file Profile-Base_.xml).
 *
 * basic attributes for User Profile Management
 */
class ProfileProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of ProfileProxy.
     */
    static ::boost::shared_ptr< ProfileProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of ProfileProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< ProfileProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of ProfileProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< ProfileProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< ProfileProxy > proxyNew(new ProfileProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~ProfileProxy ();



    // Property 'activeProfile'

    /**
     * Notify on the property 'activeProfile'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'activeProfile'</b>:
     *
     * current user Profile. Updated only on user change.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActiveProfileRegister(ActiveProfileCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'activeProfile'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'activeProfile'</b>:
     *
     * current user Profile. Updated only on user change.
     *
     * @param act The act which was previously returned by the
     * sendActiveProfileRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendActiveProfileDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'activeProfile'.
     */
    void sendActiveProfileDeregisterAll() const;

    /**
     * Request the value of the property 'activeProfile' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'activeProfile'</b>:
     *
     * current user Profile. Updated only on user change.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActiveProfileGet(ActiveProfileCallbackIF& cb);


    /**
     * Returns the current value of the property 'activeProfile' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasActiveProfile() returns true.
     *
     * @return the previously received value of the property 'activeProfile'.
     */
    uint8 getActiveProfile() const;

    /**
     * Determines whether a status message for the property 'activeProfile'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasActiveProfile() const;

    // Property 'status'

    /**
     * Notify on the property 'status'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'status'</b>:
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStatusRegister(StatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'status'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'status'</b>:
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'status'.
     */
    void sendStatusDeregisterAll() const;

    /**
     * Request the value of the property 'status' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'status'</b>:
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStatusGet(StatusCallbackIF& cb);


    /**
     * Returns the current value of the property 'status' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasStatus()
     * returns true.
     *
     * @return the previously received value of the property 'status'.
     */
    ProfileStatus getStatus() const;

    /**
     * Determines whether a status message for the property 'status' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasStatus() const;

    // Property 'copyProfile'

    /**
     * Notify on the property 'copyProfile'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'copyProfile'</b>:
     *
     * If the meaning of "copyProfile" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCopyProfileRegister(CopyProfileCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'copyProfile'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'copyProfile'</b>:
     *
     * If the meaning of "copyProfile" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendCopyProfileRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendCopyProfileDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'copyProfile'.
     */
    void sendCopyProfileDeregisterAll() const;

    /**
     * Request the value of the property 'copyProfile' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'copyProfile'</b>:
     *
     * If the meaning of "copyProfile" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCopyProfileGet(CopyProfileCallbackIF& cb);


    /**
     * Returns the current value of the property 'copyProfile' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasCopyProfile() returns true.
     *
     * @return the previously received value of the property 'copyProfile'.
     */
    const copyInfo& getCopyProfile() const;

    /**
     * Determines whether a status message for the property 'copyProfile' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCopyProfile() const;

    // Property 'deleteProfile'

    /**
     * Notify on the property 'deleteProfile'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'deleteProfile'</b>:
     *
     * Profile is to be Deleted (values to be overwritten with Default values)
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeleteProfileRegister(DeleteProfileCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'deleteProfile'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'deleteProfile'</b>:
     *
     * Profile is to be Deleted (values to be overwritten with Default values)
     *
     * @param act The act which was previously returned by the
     * sendDeleteProfileRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDeleteProfileDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'deleteProfile'.
     */
    void sendDeleteProfileDeregisterAll() const;

    /**
     * Request the value of the property 'deleteProfile' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'deleteProfile'</b>:
     *
     * Profile is to be Deleted (values to be overwritten with Default values)
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeleteProfileGet(DeleteProfileCallbackIF& cb);


    /**
     * Returns the current value of the property 'deleteProfile' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDeleteProfile() returns true.
     *
     * @return the previously received value of the property 'deleteProfile'.
     */
    uint8 getDeleteProfile() const;

    /**
     * Determines whether a status message for the property 'deleteProfile'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDeleteProfile() const;

    // Property 'dataChanged'

    /**
     * Notify on the property 'dataChanged'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'dataChanged'</b>:
     *
     * Download marker will be set to true, if upload / downlaod is in progress Application should not accept value changes, while this attribute is true
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDataChangedRegister(DataChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'dataChanged'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'dataChanged'</b>:
     *
     * Download marker will be set to true, if upload / downlaod is in progress Application should not accept value changes, while this attribute is true
     *
     * @param act The act which was previously returned by the
     * sendDataChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDataChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'dataChanged'.
     */
    void sendDataChangedDeregisterAll() const;

    /**
     * Request the value of the property 'dataChanged' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'dataChanged'</b>:
     *
     * Download marker will be set to true, if upload / downlaod is in progress Application should not accept value changes, while this attribute is true
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDataChangedGet(DataChangedCallbackIF& cb);


    /**
     * Returns the current value of the property 'dataChanged' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDataChanged() returns true.
     *
     * @return the previously received value of the property 'dataChanged'.
     */
    dataChangeReason getDataChanged() const;

    /**
     * Determines whether a status message for the property 'dataChanged' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDataChanged() const;

    // Property 'createProfile'

    /**
     * Notify on the property 'createProfile'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'createProfile'</b>:
     *
     * New Profile to be created(values to be overwritten with Default values)
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCreateProfileRegister(CreateProfileCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'createProfile'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'createProfile'</b>:
     *
     * New Profile to be created(values to be overwritten with Default values)
     *
     * @param act The act which was previously returned by the
     * sendCreateProfileRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendCreateProfileDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'createProfile'.
     */
    void sendCreateProfileDeregisterAll() const;

    /**
     * Request the value of the property 'createProfile' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'createProfile'</b>:
     *
     * New Profile to be created(values to be overwritten with Default values)
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCreateProfileGet(CreateProfileCallbackIF& cb);


    /**
     * Returns the current value of the property 'createProfile' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasCreateProfile() returns true.
     *
     * @return the previously received value of the property 'createProfile'.
     */
    uint8 getCreateProfile() const;

    /**
     * Determines whether a status message for the property 'createProfile'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCreateProfile() const;

    // Property 'privacyMode'

    /**
     * Notify on the property 'privacyMode'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'privacyMode'</b>:
     *
     * Privacy mode flag for scope 2.1 treated as one boolean, for 3.0 as 32 booleans (0: privacy mode off, 1:Privacy mode On)
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPrivacyModeRegister(PrivacyModeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'privacyMode'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'privacyMode'</b>:
     *
     * Privacy mode flag for scope 2.1 treated as one boolean, for 3.0 as 32 booleans (0: privacy mode off, 1:Privacy mode On)
     *
     * @param act The act which was previously returned by the
     * sendPrivacyModeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPrivacyModeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'privacyMode'.
     */
    void sendPrivacyModeDeregisterAll() const;

    /**
     * Request the value of the property 'privacyMode' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'privacyMode'</b>:
     *
     * Privacy mode flag for scope 2.1 treated as one boolean, for 3.0 as 32 booleans (0: privacy mode off, 1:Privacy mode On)
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPrivacyModeGet(PrivacyModeCallbackIF& cb);

    /**
     * Set the value of the property 'privacyMode'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendPrivacyModeSet(PrivacyModeCallbackIF& cb,
     * uint32 privacyMode) method instead.
     *
     * <b>Documentation of 'privacyMode'</b>:
     *
     * Privacy mode flag for scope 2.1 treated as one boolean, for 3.0 as 32 booleans (0: privacy mode off, 1:Privacy mode On)
     */
    void sendPrivacyModeSet(uint32 privacyMode);

    /**
     * Set the value of the property 'privacyMode'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'privacyMode'</b>:
     *
     * Privacy mode flag for scope 2.1 treated as one boolean, for 3.0 as 32 booleans (0: privacy mode off, 1:Privacy mode On)
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPrivacyModeSet(PrivacyModeCallbackIF& cb, uint32 privacyMode);

    /**
     * Returns the current value of the property 'privacyMode' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasPrivacyMode() returns true.
     *
     * @return the previously received value of the property 'privacyMode'.
     */
    uint32 getPrivacyMode() const;

    /**
     * Determines whether a status message for the property 'privacyMode' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPrivacyMode() const;

    // Property 'profileName'

    /**
     * Notify on the property 'profileName'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'profileName'</b>:
     *
     * Profile names for current profile con be changed with this attribute
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProfileNameRegister(ProfileNameCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'profileName'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'profileName'</b>:
     *
     * Profile names for current profile con be changed with this attribute
     *
     * @param act The act which was previously returned by the
     * sendProfileNameRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendProfileNameDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'profileName'.
     */
    void sendProfileNameDeregisterAll() const;

    /**
     * Request the value of the property 'profileName' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'profileName'</b>:
     *
     * Profile names for current profile con be changed with this attribute
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProfileNameGet(ProfileNameCallbackIF& cb);


    /**
     * Returns the current value of the property 'profileName' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasProfileName() returns true.
     *
     * @return the previously received value of the property 'profileName'.
     */
    const ::std::string& getProfileName() const;

    /**
     * Determines whether a status message for the property 'profileName' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProfileName() const;

    // Property 'profileImage'

    /**
     * Notify on the property 'profileImage'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'profileImage'</b>:
     *
     * Profile names for current profile con be changed with this attribute
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProfileImageRegister(ProfileImageCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'profileImage'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'profileImage'</b>:
     *
     * Profile names for current profile con be changed with this attribute
     *
     * @param act The act which was previously returned by the
     * sendProfileImageRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendProfileImageDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'profileImage'.
     */
    void sendProfileImageDeregisterAll() const;

    /**
     * Request the value of the property 'profileImage' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'profileImage'</b>:
     *
     * Profile names for current profile con be changed with this attribute
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProfileImageGet(ProfileImageCallbackIF& cb);


    /**
     * Returns the current value of the property 'profileImage' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasProfileImage() returns true.
     *
     * @return the previously received value of the property 'profileImage'.
     */
    uint8 getProfileImage() const;

    /**
     * Determines whether a status message for the property 'profileImage' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProfileImage() const;

    // Property 'pinRequested'

    /**
     * Notify on the property 'pinRequested'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'pinRequested'</b>:
     *
     * checkPin  call requested, to finish ongoing user action (e.g. change User
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPinRequestedRegister(PinRequestedCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'pinRequested'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'pinRequested'</b>:
     *
     * checkPin  call requested, to finish ongoing user action (e.g. change User
     *
     * @param act The act which was previously returned by the
     * sendPinRequestedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPinRequestedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'pinRequested'.
     */
    void sendPinRequestedDeregisterAll() const;

    /**
     * Request the value of the property 'pinRequested' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'pinRequested'</b>:
     *
     * checkPin  call requested, to finish ongoing user action (e.g. change User
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPinRequestedGet(PinRequestedCallbackIF& cb);


    /**
     * Returns the current value of the property 'pinRequested' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasPinRequested() returns true.
     *
     * @return the previously received value of the property 'pinRequested'.
     */
    uint8 getPinRequested() const;

    /**
     * Determines whether a status message for the property 'pinRequested' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPinRequested() const;

    // Property 'maxPINAttempts'

    /**
     * Notify on the property 'maxPINAttempts'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'maxPINAttempts'</b>:
     *
     * Max PIN attempts allowed
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMaxPINAttemptsRegister(MaxPINAttemptsCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'maxPINAttempts'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'maxPINAttempts'</b>:
     *
     * Max PIN attempts allowed
     *
     * @param act The act which was previously returned by the
     * sendMaxPINAttemptsRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendMaxPINAttemptsDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'maxPINAttempts'.
     */
    void sendMaxPINAttemptsDeregisterAll() const;

    /**
     * Request the value of the property 'maxPINAttempts' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'maxPINAttempts'</b>:
     *
     * Max PIN attempts allowed
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMaxPINAttemptsGet(MaxPINAttemptsCallbackIF& cb);

    /**
     * Set the value of the property 'maxPINAttempts'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendMaxPINAttemptsSet(MaxPINAttemptsCallbackIF& cb,
     * uint8 maxPINAttempts) method instead.
     *
     * <b>Documentation of 'maxPINAttempts'</b>:
     *
     * Max PIN attempts allowed
     */
    void sendMaxPINAttemptsSet(uint8 maxPINAttempts);

    /**
     * Set the value of the property 'maxPINAttempts'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'maxPINAttempts'</b>:
     *
     * Max PIN attempts allowed
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMaxPINAttemptsSet(MaxPINAttemptsCallbackIF& cb, uint8 maxPINAttempts);

    /**
     * Returns the current value of the property 'maxPINAttempts' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasMaxPINAttempts() returns true.
     *
     * @return the previously received value of the property 'maxPINAttempts'.
     */
    uint8 getMaxPINAttempts() const;

    /**
     * Determines whether a status message for the property 'maxPINAttempts'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMaxPINAttempts() const;

    // Property 'maxPINAttemptsBeforeDelay'

    /**
     * Notify on the property 'maxPINAttemptsBeforeDelay'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'maxPINAttemptsBeforeDelay'</b>:
     *
     * Maximum PIN Attempts before Delay
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMaxPINAttemptsBeforeDelayRegister(MaxPINAttemptsBeforeDelayCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'maxPINAttemptsBeforeDelay'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'maxPINAttemptsBeforeDelay'</b>:
     *
     * Maximum PIN Attempts before Delay
     *
     * @param act The act which was previously returned by the
     * sendMaxPINAttemptsBeforeDelayRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendMaxPINAttemptsBeforeDelayDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'maxPINAttemptsBeforeDelay'.
     */
    void sendMaxPINAttemptsBeforeDelayDeregisterAll() const;

    /**
     * Request the value of the property 'maxPINAttemptsBeforeDelay' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'maxPINAttemptsBeforeDelay'</b>:
     *
     * Maximum PIN Attempts before Delay
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMaxPINAttemptsBeforeDelayGet(MaxPINAttemptsBeforeDelayCallbackIF& cb);

    /**
     * Set the value of the property 'maxPINAttemptsBeforeDelay'. This method
     * sends a Set message to the D-Bus server.
     *
     * @deprecated use the
     * sendMaxPINAttemptsBeforeDelaySet(MaxPINAttemptsBeforeDelayCallbackIF&
     * cb, uint8 maxPINAttemptsBeforeDelay) method instead.
     *
     * <b>Documentation of 'maxPINAttemptsBeforeDelay'</b>:
     *
     * Maximum PIN Attempts before Delay
     */
    void sendMaxPINAttemptsBeforeDelaySet(uint8 maxPINAttemptsBeforeDelay);

    /**
     * Set the value of the property 'maxPINAttemptsBeforeDelay'. This method
     * sends a Set message to the D-Bus server.
     *
     * <b>Documentation of 'maxPINAttemptsBeforeDelay'</b>:
     *
     * Maximum PIN Attempts before Delay
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMaxPINAttemptsBeforeDelaySet(MaxPINAttemptsBeforeDelayCallbackIF& cb, uint8 maxPINAttemptsBeforeDelay);

    /**
     * Returns the current value of the property 'maxPINAttemptsBeforeDelay'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasMaxPINAttemptsBeforeDelay() returns true.
     *
     * @return the previously received value of the property 'maxPINAttemptsBeforeDelay'.
     */
    uint8 getMaxPINAttemptsBeforeDelay() const;

    /**
     * Determines whether a status message for the property
     * 'maxPINAttemptsBeforeDelay' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMaxPINAttemptsBeforeDelay() const;

    // Property 'pinAuthenticationDelayTime'

    /**
     * Notify on the property 'pinAuthenticationDelayTime'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'pinAuthenticationDelayTime'</b>:
     *
     * PIN Autherntication Delay in milliseconds
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPinAuthenticationDelayTimeRegister(PinAuthenticationDelayTimeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'pinAuthenticationDelayTime'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'pinAuthenticationDelayTime'</b>:
     *
     * PIN Autherntication Delay in milliseconds
     *
     * @param act The act which was previously returned by the
     * sendPinAuthenticationDelayTimeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPinAuthenticationDelayTimeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'pinAuthenticationDelayTime'.
     */
    void sendPinAuthenticationDelayTimeDeregisterAll() const;

    /**
     * Request the value of the property 'pinAuthenticationDelayTime' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'pinAuthenticationDelayTime'</b>:
     *
     * PIN Autherntication Delay in milliseconds
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPinAuthenticationDelayTimeGet(PinAuthenticationDelayTimeCallbackIF& cb);

    /**
     * Set the value of the property 'pinAuthenticationDelayTime'. This method
     * sends a Set message to the D-Bus server.
     *
     * @deprecated use the
     * sendPinAuthenticationDelayTimeSet(PinAuthenticationDelayTimeCallbackIF&
     * cb, uint32 pinAuthenticationDelayTime) method instead.
     *
     * <b>Documentation of 'pinAuthenticationDelayTime'</b>:
     *
     * PIN Autherntication Delay in milliseconds
     */
    void sendPinAuthenticationDelayTimeSet(uint32 pinAuthenticationDelayTime);

    /**
     * Set the value of the property 'pinAuthenticationDelayTime'. This method
     * sends a Set message to the D-Bus server.
     *
     * <b>Documentation of 'pinAuthenticationDelayTime'</b>:
     *
     * PIN Autherntication Delay in milliseconds
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPinAuthenticationDelayTimeSet(PinAuthenticationDelayTimeCallbackIF& cb, uint32 pinAuthenticationDelayTime);

    /**
     * Returns the current value of the property 'pinAuthenticationDelayTime'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasPinAuthenticationDelayTime() returns true.
     *
     * @return the previously received value of the property 'pinAuthenticationDelayTime'.
     */
    uint32 getPinAuthenticationDelayTime() const;

    /**
     * Determines whether a status message for the property
     * 'pinAuthenticationDelayTime' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPinAuthenticationDelayTime() const;

    // Property 'pinVerificationValidityTime'

    /**
     * Notify on the property 'pinVerificationValidityTime'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'pinVerificationValidityTime'</b>:
     *
     * PINVerificationValidityTime in milliseconds
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPinVerificationValidityTimeRegister(PinVerificationValidityTimeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'pinVerificationValidityTime'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'pinVerificationValidityTime'</b>:
     *
     * PINVerificationValidityTime in milliseconds
     *
     * @param act The act which was previously returned by the
     * sendPinVerificationValidityTimeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPinVerificationValidityTimeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'pinVerificationValidityTime'.
     */
    void sendPinVerificationValidityTimeDeregisterAll() const;

    /**
     * Request the value of the property 'pinVerificationValidityTime' from
     * the D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'pinVerificationValidityTime'</b>:
     *
     * PINVerificationValidityTime in milliseconds
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPinVerificationValidityTimeGet(PinVerificationValidityTimeCallbackIF& cb);

    /**
     * Set the value of the property 'pinVerificationValidityTime'. This
     * method sends a Set message to the D-Bus server.
     *
     * @deprecated use the
     * sendPinVerificationValidityTimeSet(PinVerificationValidityTimeCallbackIF&
     * cb, uint32 pinVerificationValidityTime) method instead.
     *
     * <b>Documentation of 'pinVerificationValidityTime'</b>:
     *
     * PINVerificationValidityTime in milliseconds
     */
    void sendPinVerificationValidityTimeSet(uint32 pinVerificationValidityTime);

    /**
     * Set the value of the property 'pinVerificationValidityTime'. This
     * method sends a Set message to the D-Bus server.
     *
     * <b>Documentation of 'pinVerificationValidityTime'</b>:
     *
     * PINVerificationValidityTime in milliseconds
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPinVerificationValidityTimeSet(PinVerificationValidityTimeCallbackIF& cb, uint32 pinVerificationValidityTime);

    /**
     * Returns the current value of the property 'pinVerificationValidityTime'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasPinVerificationValidityTime() returns true.
     *
     * @return the previously received value of the property 'pinVerificationValidityTime'.
     */
    uint32 getPinVerificationValidityTime() const;

    /**
     * Determines whether a status message for the property
     * 'pinVerificationValidityTime' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPinVerificationValidityTime() const;

    // Property 'activeProfileType'

    /**
     * Notify on the property 'activeProfileType'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'activeProfileType'</b>:
     *
     * Current Active User Profile Type
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActiveProfileTypeRegister(ActiveProfileTypeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'activeProfileType'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'activeProfileType'</b>:
     *
     * Current Active User Profile Type
     *
     * @param act The act which was previously returned by the
     * sendActiveProfileTypeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendActiveProfileTypeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'activeProfileType'.
     */
    void sendActiveProfileTypeDeregisterAll() const;

    /**
     * Request the value of the property 'activeProfileType' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'activeProfileType'</b>:
     *
     * Current Active User Profile Type
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActiveProfileTypeGet(ActiveProfileTypeCallbackIF& cb);

    /**
     * Set the value of the property 'activeProfileType'. This method sends a
     * Set message to the D-Bus server.
     *
     * @deprecated use the
     * sendActiveProfileTypeSet(ActiveProfileTypeCallbackIF& cb, profileType
     * activeProfileType) method instead.
     *
     * <b>Documentation of 'activeProfileType'</b>:
     *
     * Current Active User Profile Type
     */
    void sendActiveProfileTypeSet(profileType activeProfileType);

    /**
     * Set the value of the property 'activeProfileType'. This method sends a
     * Set message to the D-Bus server.
     *
     * <b>Documentation of 'activeProfileType'</b>:
     *
     * Current Active User Profile Type
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActiveProfileTypeSet(ActiveProfileTypeCallbackIF& cb, profileType activeProfileType);

    /**
     * Returns the current value of the property 'activeProfileType' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasActiveProfileType() returns true.
     *
     * @return the previously received value of the property 'activeProfileType'.
     */
    profileType getActiveProfileType() const;

    /**
     * Determines whether a status message for the property
     * 'activeProfileType' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasActiveProfileType() const;


    // Method 'doRegisterApp'

    /**
     * Call the method 'doRegisterApp'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'doRegisterApp'</b>:
     *
     * Each Application, that stores Profile Data has to register here.
     *    The application has to store the AppID returned by RegisterApp and uset it for all other calls to the Profile Manager
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param AppName If the meaning of "AppName" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDoRegisterAppRequest(DoRegisterAppCallbackIF& cb, const ::std::string& appName) const;

    // Method 'onDataChanged'

    /**
     * Call the method 'onDataChanged'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'onDataChanged'</b>:
     *
     * Function to be called after user change has been done. User change is triggered by activeProfile Property update
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param ApplicationPID If the meaning of "ApplicationPID" isn't clear, then there should be a description here.
     *
     * @param Result If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendOnDataChangedRequest(uint32 applicationPID, dataChangedResult result) const;

    // Method 'onProfileDeleted'

    /**
     * Call the method 'onProfileDeleted'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'onProfileDeleted'</b>:
     *
     * Function to be called after user has been deleted. User deleteion is triggered by deleteProfile Property update
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param ApplicationPID If the meaning of "ApplicationPID" isn't clear, then there should be a description here.
     *
     * @param Result If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendOnProfileDeletedRequest(uint32 applicationPID, clientResult result) const;

    // Method 'onProfileCopied'

    /**
     * Call the method 'onProfileCopied'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'onProfileCopied'</b>:
     *
     * function to be called by the clients after Profile copy action triggered by copyProfile property update has been executed
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param ApplicationPID If the meaning of "ApplicationPID" isn't clear, then there should be a description here.
     *
     * @param Result If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendOnProfileCopiedRequest(uint32 applicationPID, clientResult result) const;

    // Method 'onProfileCreated'

    /**
     * Call the method 'onProfileCreated'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'onProfileCreated'</b>:
     *
     * function to be called by the clients after Profile create action triggered by createProfile property update has been executed
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param ApplicationPID If the meaning of "ApplicationPID" isn't clear, then there should be a description here.
     *
     * @param Result If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendOnProfileCreatedRequest(uint32 applicationPID, clientResult result) const;

    // Method 'doCopyProfile'

    /**
     * Call the method 'doCopyProfile'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'doCopyProfile'</b>:
     *
     * function to request a user copy from the Profile Manager
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param sourceUserID If the meaning of "sourceUserID" isn't clear, then there should be a description here.
     *
     * @param destUserID If the meaning of "destUserID" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDoCopyProfileRequest(DoCopyProfileCallbackIF& cb, uint8 sourceUserID, uint8 destUserID) const;

    // Method 'doDeleteProfile'

    /**
     * Call the method 'doDeleteProfile'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'doDeleteProfile'</b>:
     *
     * function to delete a Profile
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param userID If the meaning of "userID" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDoDeleteProfileRequest(DoDeleteProfileCallbackIF& cb, uint8 userID) const;

    // Method 'doChangeToProfile'

    /**
     * Call the method 'doChangeToProfile'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'doChangeToProfile'</b>:
     *
     * function to request a change of the current user from the Profile Manager
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param userID If the meaning of "userID" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDoChangeToProfileRequest(DoChangeToProfileCallbackIF& cb, uint8 userID) const;

    // Method 'doCreateProfile'

    /**
     * Call the method 'doCreateProfile'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'doCreateProfile'</b>:
     *
     * function to request a creations of a new User Profile from the Profile Manager
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param newName If the meaning of "newName" isn't clear, then there should be a description here.
     *
     * @param imageID If the meaning of "imageID" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDoCreateProfileRequest(DoCreateProfileCallbackIF& cb, const ::std::string& newName, uint8 imageID) const;

    // Method 'do_SetProfileName'

    /**
     * Call the method 'do_SetProfileName'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'do_SetProfileName'</b>:
     *
     * sets the profile name for the current profile
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param newName If the meaning of "newName" isn't clear, then there should be a description here.
     *
     * @param userID If the meaning of "userID" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDo_SetProfileNameRequest(Do_SetProfileNameCallbackIF& cb, const ::std::string& newName, uint8 userID) const;

    // Method 'getProfileNames'

    /**
     * Call the method 'getProfileNames'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'getProfileNames'</b>:
     *
     * gets all profile names
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetProfileNamesRequest(GetProfileNamesCallbackIF& cb) const;

    // Method 'doImportProfileImage'

    /**
     * Call the method 'doImportProfileImage'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'doImportProfileImage'</b>:
     *
     * import an image from usb drive as Proifle image in the given slot. if slot is 0xFFFF, then the profile manager will assign it tot the user image slot for the current Profile
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param sourcePath If the meaning of "sourcePath" isn't clear, then there should be a description here.
     *
     * @param width If the meaning of "width" isn't clear, then there should be a description here.
     *
     * @param height If the meaning of "height" isn't clear, then there should be a description here.
     *
     * @param slotIdx If the meaning of "slotIdx" isn't clear, then there should be a description here.
     *
     * @param bSetForCurrentProfile If the meaning of "bSetForCurrentProfile" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDoImportProfileImageRequest(DoImportProfileImageCallbackIF& cb, const ::std::string& sourcePath, uint16 width, uint16 height, uint16 slotIdx, bool bSetForCurrentProfile) const;

    // Method 'removeUserImage'

    /**
     * Call the method 'removeUserImage'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'removeUserImage'</b>:
     *
     * delete an imported image referenced by the slotIdx from the system.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param slotIdx If the meaning of "slotIdx" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRemoveUserImageRequest(RemoveUserImageCallbackIF& cb, uint16 slotIdx) const;

    // Method 'doSetProfileImage'

    /**
     * Call the method 'doSetProfileImage'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'doSetProfileImage'</b>:
     *
     * set current profile image (index)
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param imageID If the meaning of "imageID" isn't clear, then there should be a description here.
     *
     * @param userID If the meaning of "userID" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDoSetProfileImageRequest(DoSetProfileImageCallbackIF& cb, uint8 imageID, uint8 userID) const;

    // Method 'getProfileImages'

    /**
     * Call the method 'getProfileImages'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'getProfileImages'</b>:
     *
     * gets all profile images
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetProfileImagesRequest(GetProfileImagesCallbackIF& cb) const;

    // Method 'getProfileTypes'

    /**
     * Call the method 'getProfileTypes'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'getProfileTypes'</b>:
     *
     * gets all profile types
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetProfileTypesRequest(GetProfileTypesCallbackIF& cb) const;

    // Method 'setProfilePin'

    /**
     * Call the method 'setProfilePin'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'setProfilePin'</b>:
     *
     * sets Authentication Method PIN
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param profileID If the meaning of "profileID" isn't clear, then there should be a description here.
     *
     * @param Pin If the meaning of "Pin" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetProfilePinRequest(SetProfilePinCallbackIF& cb, uint8 profileID, const ::std::string& pin) const;

    // Method 'setRememberMe'

    /**
     * Call the method 'setRememberMe'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'setRememberMe'</b>:
     *
     * sets Authentication Method to Remember Me
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param profileID If the meaning of "profileID" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetRememberMeRequest(SetRememberMeCallbackIF& cb, uint8 profileID) const;

    // Method 'checkPin'

    /**
     * Call the method 'checkPin'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'checkPin'</b>:
     *
     * Validates the current PIN. needs to be called before setProfilePin & setRememberMe if Prodile is secured by PIN
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param profileID If the meaning of "profileID" isn't clear, then there should be a description here.
     *
     * @param PIN If the meaning of "PIN" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCheckPinRequest(CheckPinCallbackIF& cb, uint8 profileID, const ::std::string& pIN) const;

    // Method 'unProtectProfile'

    /**
     * Call the method 'unProtectProfile'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'unProtectProfile'</b>:
     *
     * removes the Authentication Method
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param profileID If the meaning of "profileID" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnProtectProfileRequest(UnProtectProfileCallbackIF& cb, uint8 profileID) const;

    // Method 'linkProfile'

    /**
     * Call the method 'linkProfile'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'linkProfile'</b>:
     *
     * link profile
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param bSetLink If the meaning of "bSetLink" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLinkProfileRequest(LinkProfileCallbackIF& cb, bool bSetLink) const;

    // Method 'setValetMode'

    /**
     * Call the method 'setValetMode'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'setValetMode'</b>:
     *
     * SetValetMode
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param bEnableValetMode If the meaning of "bEnableValetMode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetValetModeRequest(SetValetModeCallbackIF& cb, bool bEnableValetMode) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    ProfileProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'activeProfile'

    ::asf::core::nullable< ActiveProfileUpdate > _activeProfile;

    // Property 'status'

    ::asf::core::nullable< StatusUpdate > _status;

    // Property 'copyProfile'

    ::asf::core::nullable< CopyProfileUpdate > _copyProfile;

    // Property 'deleteProfile'

    ::asf::core::nullable< DeleteProfileUpdate > _deleteProfile;

    // Property 'dataChanged'

    ::asf::core::nullable< DataChangedUpdate > _dataChanged;

    // Property 'createProfile'

    ::asf::core::nullable< CreateProfileUpdate > _createProfile;

    // Property 'privacyMode'

    ::asf::core::nullable< PrivacyModeUpdate > _privacyMode;

    // Property 'profileName'

    ::asf::core::nullable< ProfileNameUpdate > _profileName;

    // Property 'profileImage'

    ::asf::core::nullable< ProfileImageUpdate > _profileImage;

    // Property 'pinRequested'

    ::asf::core::nullable< PinRequestedUpdate > _pinRequested;

    // Property 'maxPINAttempts'

    ::asf::core::nullable< MaxPINAttemptsUpdate > _maxPINAttempts;

    // Property 'maxPINAttemptsBeforeDelay'

    ::asf::core::nullable< MaxPINAttemptsBeforeDelayUpdate > _maxPINAttemptsBeforeDelay;

    // Property 'pinAuthenticationDelayTime'

    ::asf::core::nullable< PinAuthenticationDelayTimeUpdate > _pinAuthenticationDelayTime;

    // Property 'pinVerificationValidityTime'

    ::asf::core::nullable< PinVerificationValidityTimeUpdate > _pinVerificationValidityTime;

    // Property 'activeProfileType'

    ::asf::core::nullable< ActiveProfileTypeUpdate > _activeProfileType;

    DECLARE_CLASS_LOGGER();

    friend class ProfileProxyCallback;
};

} // namespace profile
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_PROFILEPROXY_H
