/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/profile.h"
#include "bosch/cm/profileConst.h"
#include "bosch/cm/profileDBus.h"
#include "bosch/cm/profileJson.h"
#include "bosch/cm/profileProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace profile {

DEFINE_CLASS_LOGGER("/bosch/cm/bosch/cm/profile", ProfileProxy);

class ProfileProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    ProfileProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< ProfileProxy >& proxyShared = ::boost::static_pointer_cast< ProfileProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_activeProfile:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveProfileError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveProfileError> payload = ::boost::static_pointer_cast<ActiveProfileError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ActiveProfileCallbackIF*) _callback)->onActiveProfileError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveProfileUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveProfileUpdate> payload = ::boost::static_pointer_cast<ActiveProfileUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ActiveProfileCallbackIF*) _callback)->onActiveProfileUpdate(proxyShared, payload);
                        proxyShared->_activeProfile = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_status:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Status", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StatusError> payload = ::boost::static_pointer_cast<StatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((StatusCallbackIF*) _callback)->onStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Status", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StatusUpdate> payload = ::boost::static_pointer_cast<StatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((StatusCallbackIF*) _callback)->onStatusUpdate(proxyShared, payload);
                        proxyShared->_status = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_copyProfile:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CopyProfileError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CopyProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CopyProfileError> payload = ::boost::static_pointer_cast<CopyProfileError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CopyProfileCallbackIF*) _callback)->onCopyProfileError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CopyProfileUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CopyProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CopyProfileUpdate> payload = ::boost::static_pointer_cast<CopyProfileUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CopyProfileCallbackIF*) _callback)->onCopyProfileUpdate(proxyShared, payload);
                        proxyShared->_copyProfile = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_deleteProfile:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeleteProfileError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DeleteProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeleteProfileError> payload = ::boost::static_pointer_cast<DeleteProfileError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DeleteProfileCallbackIF*) _callback)->onDeleteProfileError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeleteProfileUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DeleteProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeleteProfileUpdate> payload = ::boost::static_pointer_cast<DeleteProfileUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DeleteProfileCallbackIF*) _callback)->onDeleteProfileUpdate(proxyShared, payload);
                        proxyShared->_deleteProfile = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_dataChanged:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DataChangedError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DataChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DataChangedError> payload = ::boost::static_pointer_cast<DataChangedError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DataChangedCallbackIF*) _callback)->onDataChangedError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DataChangedUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DataChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DataChangedUpdate> payload = ::boost::static_pointer_cast<DataChangedUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DataChangedCallbackIF*) _callback)->onDataChangedUpdate(proxyShared, payload);
                        proxyShared->_dataChanged = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_createProfile:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CreateProfileError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CreateProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CreateProfileError> payload = ::boost::static_pointer_cast<CreateProfileError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CreateProfileCallbackIF*) _callback)->onCreateProfileError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CreateProfileUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CreateProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CreateProfileUpdate> payload = ::boost::static_pointer_cast<CreateProfileUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CreateProfileCallbackIF*) _callback)->onCreateProfileUpdate(proxyShared, payload);
                        proxyShared->_createProfile = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_privacyMode:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PrivacyModeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PrivacyMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PrivacyModeError> payload = ::boost::static_pointer_cast<PrivacyModeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PrivacyModeCallbackIF*) _callback)->onPrivacyModeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PrivacyModeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PrivacyMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PrivacyModeUpdate> payload = ::boost::static_pointer_cast<PrivacyModeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PrivacyModeCallbackIF*) _callback)->onPrivacyModeUpdate(proxyShared, payload);
                        proxyShared->_privacyMode = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_profileName:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProfileNameError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ProfileName", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ProfileNameError> payload = ::boost::static_pointer_cast<ProfileNameError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ProfileNameCallbackIF*) _callback)->onProfileNameError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProfileNameUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ProfileName", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ProfileNameUpdate> payload = ::boost::static_pointer_cast<ProfileNameUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ProfileNameCallbackIF*) _callback)->onProfileNameUpdate(proxyShared, payload);
                        proxyShared->_profileName = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_profileImage:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProfileImageError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ProfileImage", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ProfileImageError> payload = ::boost::static_pointer_cast<ProfileImageError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ProfileImageCallbackIF*) _callback)->onProfileImageError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProfileImageUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ProfileImage", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ProfileImageUpdate> payload = ::boost::static_pointer_cast<ProfileImageUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ProfileImageCallbackIF*) _callback)->onProfileImageUpdate(proxyShared, payload);
                        proxyShared->_profileImage = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_pinRequested:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PinRequestedError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PinRequested", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PinRequestedError> payload = ::boost::static_pointer_cast<PinRequestedError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PinRequestedCallbackIF*) _callback)->onPinRequestedError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PinRequestedUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PinRequested", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PinRequestedUpdate> payload = ::boost::static_pointer_cast<PinRequestedUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PinRequestedCallbackIF*) _callback)->onPinRequestedUpdate(proxyShared, payload);
                        proxyShared->_pinRequested = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_maxPINAttempts:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MaxPINAttemptsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MaxPINAttempts", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MaxPINAttemptsError> payload = ::boost::static_pointer_cast<MaxPINAttemptsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((MaxPINAttemptsCallbackIF*) _callback)->onMaxPINAttemptsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MaxPINAttemptsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MaxPINAttempts", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MaxPINAttemptsUpdate> payload = ::boost::static_pointer_cast<MaxPINAttemptsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((MaxPINAttemptsCallbackIF*) _callback)->onMaxPINAttemptsUpdate(proxyShared, payload);
                        proxyShared->_maxPINAttempts = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_maxPINAttemptsBeforeDelay:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MaxPINAttemptsBeforeDelayError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MaxPINAttemptsBeforeDelay", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MaxPINAttemptsBeforeDelayError> payload = ::boost::static_pointer_cast<MaxPINAttemptsBeforeDelayError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((MaxPINAttemptsBeforeDelayCallbackIF*) _callback)->onMaxPINAttemptsBeforeDelayError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MaxPINAttemptsBeforeDelayUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MaxPINAttemptsBeforeDelay", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MaxPINAttemptsBeforeDelayUpdate> payload = ::boost::static_pointer_cast<MaxPINAttemptsBeforeDelayUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((MaxPINAttemptsBeforeDelayCallbackIF*) _callback)->onMaxPINAttemptsBeforeDelayUpdate(proxyShared, payload);
                        proxyShared->_maxPINAttemptsBeforeDelay = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_pinAuthenticationDelayTime:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PinAuthenticationDelayTimeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PinAuthenticationDelayTime", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PinAuthenticationDelayTimeError> payload = ::boost::static_pointer_cast<PinAuthenticationDelayTimeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PinAuthenticationDelayTimeCallbackIF*) _callback)->onPinAuthenticationDelayTimeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PinAuthenticationDelayTimeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PinAuthenticationDelayTime", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PinAuthenticationDelayTimeUpdate> payload = ::boost::static_pointer_cast<PinAuthenticationDelayTimeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PinAuthenticationDelayTimeCallbackIF*) _callback)->onPinAuthenticationDelayTimeUpdate(proxyShared, payload);
                        proxyShared->_pinAuthenticationDelayTime = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_pinVerificationValidityTime:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PinVerificationValidityTimeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PinVerificationValidityTime", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PinVerificationValidityTimeError> payload = ::boost::static_pointer_cast<PinVerificationValidityTimeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PinVerificationValidityTimeCallbackIF*) _callback)->onPinVerificationValidityTimeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PinVerificationValidityTimeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PinVerificationValidityTime", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PinVerificationValidityTimeUpdate> payload = ::boost::static_pointer_cast<PinVerificationValidityTimeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PinVerificationValidityTimeCallbackIF*) _callback)->onPinVerificationValidityTimeUpdate(proxyShared, payload);
                        proxyShared->_pinVerificationValidityTime = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_activeProfileType:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveProfileTypeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveProfileType", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveProfileTypeError> payload = ::boost::static_pointer_cast<ActiveProfileTypeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ActiveProfileTypeCallbackIF*) _callback)->onActiveProfileTypeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveProfileTypeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveProfileType", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveProfileTypeUpdate> payload = ::boost::static_pointer_cast<ActiveProfileTypeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ActiveProfileTypeCallbackIF*) _callback)->onActiveProfileTypeUpdate(proxyShared, payload);
                        proxyShared->_activeProfileType = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_doRegisterApp:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DoRegisterAppError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoRegisterApp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DoRegisterAppError> payload = ::boost::static_pointer_cast<DoRegisterAppError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DoRegisterAppCallbackIF*) _callback)->onDoRegisterAppError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DoRegisterAppResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoRegisterApp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DoRegisterAppResponse> payload = ::boost::static_pointer_cast<DoRegisterAppResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DoRegisterAppCallbackIF*) _callback)->onDoRegisterAppResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_doCopyProfile:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DoCopyProfileError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoCopyProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DoCopyProfileError> payload = ::boost::static_pointer_cast<DoCopyProfileError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DoCopyProfileCallbackIF*) _callback)->onDoCopyProfileError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DoCopyProfileResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoCopyProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DoCopyProfileResponse> payload = ::boost::static_pointer_cast<DoCopyProfileResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DoCopyProfileCallbackIF*) _callback)->onDoCopyProfileResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_doDeleteProfile:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DoDeleteProfileError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoDeleteProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DoDeleteProfileError> payload = ::boost::static_pointer_cast<DoDeleteProfileError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DoDeleteProfileCallbackIF*) _callback)->onDoDeleteProfileError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DoDeleteProfileResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoDeleteProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DoDeleteProfileResponse> payload = ::boost::static_pointer_cast<DoDeleteProfileResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DoDeleteProfileCallbackIF*) _callback)->onDoDeleteProfileResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_doChangeToProfile:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DoChangeToProfileError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoChangeToProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DoChangeToProfileError> payload = ::boost::static_pointer_cast<DoChangeToProfileError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DoChangeToProfileCallbackIF*) _callback)->onDoChangeToProfileError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DoChangeToProfileResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoChangeToProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DoChangeToProfileResponse> payload = ::boost::static_pointer_cast<DoChangeToProfileResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DoChangeToProfileCallbackIF*) _callback)->onDoChangeToProfileResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_doCreateProfile:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DoCreateProfileError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoCreateProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DoCreateProfileError> payload = ::boost::static_pointer_cast<DoCreateProfileError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DoCreateProfileCallbackIF*) _callback)->onDoCreateProfileError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DoCreateProfileResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoCreateProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DoCreateProfileResponse> payload = ::boost::static_pointer_cast<DoCreateProfileResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DoCreateProfileCallbackIF*) _callback)->onDoCreateProfileResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_do_SetProfileName:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), Do_SetProfileNameError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Do_SetProfileName", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<Do_SetProfileNameError> payload = ::boost::static_pointer_cast<Do_SetProfileNameError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((Do_SetProfileNameCallbackIF*) _callback)->onDo_SetProfileNameError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Do_SetProfileNameResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Do_SetProfileName", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<Do_SetProfileNameResponse> payload = ::boost::static_pointer_cast<Do_SetProfileNameResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((Do_SetProfileNameCallbackIF*) _callback)->onDo_SetProfileNameResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getProfileNames:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetProfileNamesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProfileNames", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetProfileNamesError> payload = ::boost::static_pointer_cast<GetProfileNamesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetProfileNamesCallbackIF*) _callback)->onGetProfileNamesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetProfileNamesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProfileNames", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetProfileNamesResponse> payload = ::boost::static_pointer_cast<GetProfileNamesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetProfileNamesCallbackIF*) _callback)->onGetProfileNamesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_doImportProfileImage:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DoImportProfileImageError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoImportProfileImage", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DoImportProfileImageError> payload = ::boost::static_pointer_cast<DoImportProfileImageError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DoImportProfileImageCallbackIF*) _callback)->onDoImportProfileImageError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DoImportProfileImageResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoImportProfileImage", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DoImportProfileImageResponse> payload = ::boost::static_pointer_cast<DoImportProfileImageResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DoImportProfileImageCallbackIF*) _callback)->onDoImportProfileImageResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_removeUserImage:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RemoveUserImageError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RemoveUserImage", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RemoveUserImageError> payload = ::boost::static_pointer_cast<RemoveUserImageError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RemoveUserImageCallbackIF*) _callback)->onRemoveUserImageError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemoveUserImageResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RemoveUserImage", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RemoveUserImageResponse> payload = ::boost::static_pointer_cast<RemoveUserImageResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RemoveUserImageCallbackIF*) _callback)->onRemoveUserImageResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_doSetProfileImage:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DoSetProfileImageError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoSetProfileImage", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DoSetProfileImageError> payload = ::boost::static_pointer_cast<DoSetProfileImageError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DoSetProfileImageCallbackIF*) _callback)->onDoSetProfileImageError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DoSetProfileImageResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoSetProfileImage", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DoSetProfileImageResponse> payload = ::boost::static_pointer_cast<DoSetProfileImageResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DoSetProfileImageCallbackIF*) _callback)->onDoSetProfileImageResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getProfileImages:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetProfileImagesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProfileImages", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetProfileImagesError> payload = ::boost::static_pointer_cast<GetProfileImagesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetProfileImagesCallbackIF*) _callback)->onGetProfileImagesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetProfileImagesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProfileImages", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetProfileImagesResponse> payload = ::boost::static_pointer_cast<GetProfileImagesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetProfileImagesCallbackIF*) _callback)->onGetProfileImagesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getProfileTypes:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetProfileTypesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProfileTypes", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetProfileTypesError> payload = ::boost::static_pointer_cast<GetProfileTypesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetProfileTypesCallbackIF*) _callback)->onGetProfileTypesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetProfileTypesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProfileTypes", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetProfileTypesResponse> payload = ::boost::static_pointer_cast<GetProfileTypesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetProfileTypesCallbackIF*) _callback)->onGetProfileTypesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setProfilePin:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetProfilePinError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetProfilePin", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetProfilePinError> payload = ::boost::static_pointer_cast<SetProfilePinError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetProfilePinCallbackIF*) _callback)->onSetProfilePinError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetProfilePinResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetProfilePin", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetProfilePinResponse> payload = ::boost::static_pointer_cast<SetProfilePinResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetProfilePinCallbackIF*) _callback)->onSetProfilePinResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setRememberMe:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetRememberMeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetRememberMe", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetRememberMeError> payload = ::boost::static_pointer_cast<SetRememberMeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetRememberMeCallbackIF*) _callback)->onSetRememberMeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetRememberMeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetRememberMe", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetRememberMeResponse> payload = ::boost::static_pointer_cast<SetRememberMeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetRememberMeCallbackIF*) _callback)->onSetRememberMeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_checkPin:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CheckPinError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CheckPin", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CheckPinError> payload = ::boost::static_pointer_cast<CheckPinError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CheckPinCallbackIF*) _callback)->onCheckPinError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CheckPinResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "CheckPin", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CheckPinResponse> payload = ::boost::static_pointer_cast<CheckPinResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CheckPinCallbackIF*) _callback)->onCheckPinResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_unProtectProfile:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UnProtectProfileError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnProtectProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnProtectProfileError> payload = ::boost::static_pointer_cast<UnProtectProfileError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnProtectProfileCallbackIF*) _callback)->onUnProtectProfileError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnProtectProfileResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnProtectProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnProtectProfileResponse> payload = ::boost::static_pointer_cast<UnProtectProfileResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnProtectProfileCallbackIF*) _callback)->onUnProtectProfileResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_linkProfile:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), LinkProfileError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "LinkProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LinkProfileError> payload = ::boost::static_pointer_cast<LinkProfileError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((LinkProfileCallbackIF*) _callback)->onLinkProfileError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LinkProfileResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "LinkProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LinkProfileResponse> payload = ::boost::static_pointer_cast<LinkProfileResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((LinkProfileCallbackIF*) _callback)->onLinkProfileResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setValetMode:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetValetModeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetValetMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetValetModeError> payload = ::boost::static_pointer_cast<SetValetModeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetValetModeCallbackIF*) _callback)->onSetValetModeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetValetModeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetValetMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetValetModeResponse> payload = ::boost::static_pointer_cast<SetValetModeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetValetModeCallbackIF*) _callback)->onSetValetModeResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_activeProfile: {
                ::boost::shared_ptr< ActiveProfileError > payload = ::boost::shared_ptr< ActiveProfileError >
                (new ActiveProfileError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ActiveProfile", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ActiveProfileCallbackIF*) _callback)->onActiveProfileError (proxyShared,payload);
                return true;
            }
            break;
            case ID_status: {
                ::boost::shared_ptr< StatusError > payload = ::boost::shared_ptr< StatusError >
                (new StatusError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Status", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StatusCallbackIF*) _callback)->onStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_copyProfile: {
                ::boost::shared_ptr< CopyProfileError > payload = ::boost::shared_ptr< CopyProfileError >
                (new CopyProfileError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CopyProfile", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CopyProfileCallbackIF*) _callback)->onCopyProfileError (proxyShared,payload);
                return true;
            }
            break;
            case ID_deleteProfile: {
                ::boost::shared_ptr< DeleteProfileError > payload = ::boost::shared_ptr< DeleteProfileError >
                (new DeleteProfileError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DeleteProfile", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DeleteProfileCallbackIF*) _callback)->onDeleteProfileError (proxyShared,payload);
                return true;
            }
            break;
            case ID_dataChanged: {
                ::boost::shared_ptr< DataChangedError > payload = ::boost::shared_ptr< DataChangedError >
                (new DataChangedError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DataChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DataChangedCallbackIF*) _callback)->onDataChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_createProfile: {
                ::boost::shared_ptr< CreateProfileError > payload = ::boost::shared_ptr< CreateProfileError >
                (new CreateProfileError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CreateProfile", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CreateProfileCallbackIF*) _callback)->onCreateProfileError (proxyShared,payload);
                return true;
            }
            break;
            case ID_privacyMode: {
                ::boost::shared_ptr< PrivacyModeError > payload = ::boost::shared_ptr< PrivacyModeError >
                (new PrivacyModeError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PrivacyMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PrivacyModeCallbackIF*) _callback)->onPrivacyModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_profileName: {
                ::boost::shared_ptr< ProfileNameError > payload = ::boost::shared_ptr< ProfileNameError >
                (new ProfileNameError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ProfileName", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ProfileNameCallbackIF*) _callback)->onProfileNameError (proxyShared,payload);
                return true;
            }
            break;
            case ID_profileImage: {
                ::boost::shared_ptr< ProfileImageError > payload = ::boost::shared_ptr< ProfileImageError >
                (new ProfileImageError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ProfileImage", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ProfileImageCallbackIF*) _callback)->onProfileImageError (proxyShared,payload);
                return true;
            }
            break;
            case ID_pinRequested: {
                ::boost::shared_ptr< PinRequestedError > payload = ::boost::shared_ptr< PinRequestedError >
                (new PinRequestedError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PinRequested", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PinRequestedCallbackIF*) _callback)->onPinRequestedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_maxPINAttempts: {
                ::boost::shared_ptr< MaxPINAttemptsError > payload = ::boost::shared_ptr< MaxPINAttemptsError >
                (new MaxPINAttemptsError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MaxPINAttempts", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MaxPINAttemptsCallbackIF*) _callback)->onMaxPINAttemptsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_maxPINAttemptsBeforeDelay: {
                ::boost::shared_ptr< MaxPINAttemptsBeforeDelayError > payload = ::boost::shared_ptr< MaxPINAttemptsBeforeDelayError >
                (new MaxPINAttemptsBeforeDelayError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MaxPINAttemptsBeforeDelay", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MaxPINAttemptsBeforeDelayCallbackIF*) _callback)->onMaxPINAttemptsBeforeDelayError (proxyShared,payload);
                return true;
            }
            break;
            case ID_pinAuthenticationDelayTime: {
                ::boost::shared_ptr< PinAuthenticationDelayTimeError > payload = ::boost::shared_ptr< PinAuthenticationDelayTimeError >
                (new PinAuthenticationDelayTimeError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PinAuthenticationDelayTime", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PinAuthenticationDelayTimeCallbackIF*) _callback)->onPinAuthenticationDelayTimeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_pinVerificationValidityTime: {
                ::boost::shared_ptr< PinVerificationValidityTimeError > payload = ::boost::shared_ptr< PinVerificationValidityTimeError >
                (new PinVerificationValidityTimeError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PinVerificationValidityTime", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PinVerificationValidityTimeCallbackIF*) _callback)->onPinVerificationValidityTimeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_activeProfileType: {
                ::boost::shared_ptr< ActiveProfileTypeError > payload = ::boost::shared_ptr< ActiveProfileTypeError >
                (new ActiveProfileTypeError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ActiveProfileType", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ActiveProfileTypeCallbackIF*) _callback)->onActiveProfileTypeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_doRegisterApp: {
                ::boost::shared_ptr< DoRegisterAppError > payload = ::boost::shared_ptr< DoRegisterAppError >
                (new DoRegisterAppError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DoRegisterApp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DoRegisterAppCallbackIF*) _callback)->onDoRegisterAppError (proxyShared,payload);
                return true;
            }
            break;
            case ID_doCopyProfile: {
                ::boost::shared_ptr< DoCopyProfileError > payload = ::boost::shared_ptr< DoCopyProfileError >
                (new DoCopyProfileError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DoCopyProfile", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DoCopyProfileCallbackIF*) _callback)->onDoCopyProfileError (proxyShared,payload);
                return true;
            }
            break;
            case ID_doDeleteProfile: {
                ::boost::shared_ptr< DoDeleteProfileError > payload = ::boost::shared_ptr< DoDeleteProfileError >
                (new DoDeleteProfileError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DoDeleteProfile", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DoDeleteProfileCallbackIF*) _callback)->onDoDeleteProfileError (proxyShared,payload);
                return true;
            }
            break;
            case ID_doChangeToProfile: {
                ::boost::shared_ptr< DoChangeToProfileError > payload = ::boost::shared_ptr< DoChangeToProfileError >
                (new DoChangeToProfileError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DoChangeToProfile", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DoChangeToProfileCallbackIF*) _callback)->onDoChangeToProfileError (proxyShared,payload);
                return true;
            }
            break;
            case ID_doCreateProfile: {
                ::boost::shared_ptr< DoCreateProfileError > payload = ::boost::shared_ptr< DoCreateProfileError >
                (new DoCreateProfileError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DoCreateProfile", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DoCreateProfileCallbackIF*) _callback)->onDoCreateProfileError (proxyShared,payload);
                return true;
            }
            break;
            case ID_do_SetProfileName: {
                ::boost::shared_ptr< Do_SetProfileNameError > payload = ::boost::shared_ptr< Do_SetProfileNameError >
                (new Do_SetProfileNameError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Do_SetProfileName", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Do_SetProfileNameCallbackIF*) _callback)->onDo_SetProfileNameError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getProfileNames: {
                ::boost::shared_ptr< GetProfileNamesError > payload = ::boost::shared_ptr< GetProfileNamesError >
                (new GetProfileNamesError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetProfileNames", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetProfileNamesCallbackIF*) _callback)->onGetProfileNamesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_doImportProfileImage: {
                ::boost::shared_ptr< DoImportProfileImageError > payload = ::boost::shared_ptr< DoImportProfileImageError >
                (new DoImportProfileImageError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DoImportProfileImage", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DoImportProfileImageCallbackIF*) _callback)->onDoImportProfileImageError (proxyShared,payload);
                return true;
            }
            break;
            case ID_removeUserImage: {
                ::boost::shared_ptr< RemoveUserImageError > payload = ::boost::shared_ptr< RemoveUserImageError >
                (new RemoveUserImageError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RemoveUserImage", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RemoveUserImageCallbackIF*) _callback)->onRemoveUserImageError (proxyShared,payload);
                return true;
            }
            break;
            case ID_doSetProfileImage: {
                ::boost::shared_ptr< DoSetProfileImageError > payload = ::boost::shared_ptr< DoSetProfileImageError >
                (new DoSetProfileImageError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DoSetProfileImage", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DoSetProfileImageCallbackIF*) _callback)->onDoSetProfileImageError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getProfileImages: {
                ::boost::shared_ptr< GetProfileImagesError > payload = ::boost::shared_ptr< GetProfileImagesError >
                (new GetProfileImagesError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetProfileImages", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetProfileImagesCallbackIF*) _callback)->onGetProfileImagesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getProfileTypes: {
                ::boost::shared_ptr< GetProfileTypesError > payload = ::boost::shared_ptr< GetProfileTypesError >
                (new GetProfileTypesError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetProfileTypes", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetProfileTypesCallbackIF*) _callback)->onGetProfileTypesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setProfilePin: {
                ::boost::shared_ptr< SetProfilePinError > payload = ::boost::shared_ptr< SetProfilePinError >
                (new SetProfilePinError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetProfilePin", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetProfilePinCallbackIF*) _callback)->onSetProfilePinError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setRememberMe: {
                ::boost::shared_ptr< SetRememberMeError > payload = ::boost::shared_ptr< SetRememberMeError >
                (new SetRememberMeError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetRememberMe", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetRememberMeCallbackIF*) _callback)->onSetRememberMeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_checkPin: {
                ::boost::shared_ptr< CheckPinError > payload = ::boost::shared_ptr< CheckPinError >
                (new CheckPinError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CheckPin", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CheckPinCallbackIF*) _callback)->onCheckPinError (proxyShared,payload);
                return true;
            }
            break;
            case ID_unProtectProfile: {
                ::boost::shared_ptr< UnProtectProfileError > payload = ::boost::shared_ptr< UnProtectProfileError >
                (new UnProtectProfileError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UnProtectProfile", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UnProtectProfileCallbackIF*) _callback)->onUnProtectProfileError (proxyShared,payload);
                return true;
            }
            break;
            case ID_linkProfile: {
                ::boost::shared_ptr< LinkProfileError > payload = ::boost::shared_ptr< LinkProfileError >
                (new LinkProfileError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LinkProfile", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LinkProfileCallbackIF*) _callback)->onLinkProfileError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setValetMode: {
                ::boost::shared_ptr< SetValetModeError > payload = ::boost::shared_ptr< SetValetModeError >
                (new SetValetModeError(DBUS_ERROR_NO_SERVER, "The DBus service Profile is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetValetMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileProxy> proxyShared = ::boost::static_pointer_cast<ProfileProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetValetModeCallbackIF*) _callback)->onSetValetModeError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& ProfileProxyCallback::_logger (ProfileProxy::_logger);

ProfileProxy::ProfileProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "bosch.cm.profile", serviceAvailable, _logger) {
}

ProfileProxy::~ProfileProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< ProfileProxy > ProfileProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<ProfileProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< ProfileProxy > proxyNew(new ProfileProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t ProfileProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    ProfileProxyCallback* callback = new ProfileProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t ProfileProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    ProfileProxyCallback* callback = new ProfileProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ProfileProxy::clearAllProperties ()
{
    _activeProfile = ::asf::core::nullable< ActiveProfileUpdate >();
    _status = ::asf::core::nullable< StatusUpdate >();
    _copyProfile = ::asf::core::nullable< CopyProfileUpdate >();
    _deleteProfile = ::asf::core::nullable< DeleteProfileUpdate >();
    _dataChanged = ::asf::core::nullable< DataChangedUpdate >();
    _createProfile = ::asf::core::nullable< CreateProfileUpdate >();
    _privacyMode = ::asf::core::nullable< PrivacyModeUpdate >();
    _profileName = ::asf::core::nullable< ProfileNameUpdate >();
    _profileImage = ::asf::core::nullable< ProfileImageUpdate >();
    _pinRequested = ::asf::core::nullable< PinRequestedUpdate >();
    _maxPINAttempts = ::asf::core::nullable< MaxPINAttemptsUpdate >();
    _maxPINAttemptsBeforeDelay = ::asf::core::nullable< MaxPINAttemptsBeforeDelayUpdate >();
    _pinAuthenticationDelayTime = ::asf::core::nullable< PinAuthenticationDelayTimeUpdate >();
    _pinVerificationValidityTime = ::asf::core::nullable< PinVerificationValidityTimeUpdate >();
    _activeProfileType = ::asf::core::nullable< ActiveProfileTypeUpdate >();
}

void ProfileProxy::sendDeregisterAll () const
{
    sendActiveProfileDeregisterAll();
    sendStatusDeregisterAll();
    sendCopyProfileDeregisterAll();
    sendDeleteProfileDeregisterAll();
    sendDataChangedDeregisterAll();
    sendCreateProfileDeregisterAll();
    sendPrivacyModeDeregisterAll();
    sendProfileNameDeregisterAll();
    sendProfileImageDeregisterAll();
    sendPinRequestedDeregisterAll();
    sendMaxPINAttemptsDeregisterAll();
    sendMaxPINAttemptsBeforeDelayDeregisterAll();
    sendPinAuthenticationDelayTimeDeregisterAll();
    sendPinVerificationValidityTimeDeregisterAll();
    sendActiveProfileTypeDeregisterAll();
}

act_t ProfileProxy::sendActiveProfileRegister(ActiveProfileCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_activeProfile, "activeProfile", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ActiveProfile", &cb, act);
    return act;
}

bool ProfileProxy::sendActiveProfileDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("activeProfile", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ActiveProfile", act, static_cast<int>(rv));
    return rv;
}

act_t ProfileProxy::sendActiveProfileGet(ActiveProfileCallbackIF& cb) {
    ProfileProxyCallback* callback = new ProfileProxyCallback(ID_activeProfile, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ActiveProfile", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("activeProfile", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint8 ProfileProxy::getActiveProfile() const {
    return _activeProfile.get().getActiveProfile();
}

bool ProfileProxy::hasActiveProfile() const {
    return _activeProfile.hasValue();
}

void ProfileProxy::sendActiveProfileDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ActiveProfile");
    _dbusProxyDelegate->deregisterSignalCallback("activeProfile", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfileProxy::sendStatusRegister(StatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_status, "status", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Status", &cb, act);
    return act;
}

bool ProfileProxy::sendStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("status", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Status", act, static_cast<int>(rv));
    return rv;
}

act_t ProfileProxy::sendStatusGet(StatusCallbackIF& cb) {
    ProfileProxyCallback* callback = new ProfileProxyCallback(ID_status, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Status", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("status", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


ProfileStatus ProfileProxy::getStatus() const {
    return _status.get().getStatus();
}

bool ProfileProxy::hasStatus() const {
    return _status.hasValue();
}

void ProfileProxy::sendStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Status");
    _dbusProxyDelegate->deregisterSignalCallback("status", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfileProxy::sendCopyProfileRegister(CopyProfileCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_copyProfile, "copyProfile", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CopyProfile", &cb, act);
    return act;
}

bool ProfileProxy::sendCopyProfileDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("copyProfile", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CopyProfile", act, static_cast<int>(rv));
    return rv;
}

act_t ProfileProxy::sendCopyProfileGet(CopyProfileCallbackIF& cb) {
    ProfileProxyCallback* callback = new ProfileProxyCallback(ID_copyProfile, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CopyProfile", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("copyProfile", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const copyInfo& ProfileProxy::getCopyProfile() const {
    return _copyProfile.get().getCopyProfile();
}

bool ProfileProxy::hasCopyProfile() const {
    return _copyProfile.hasValue();
}

void ProfileProxy::sendCopyProfileDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CopyProfile");
    _dbusProxyDelegate->deregisterSignalCallback("copyProfile", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfileProxy::sendDeleteProfileRegister(DeleteProfileCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_deleteProfile, "deleteProfile", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DeleteProfile", &cb, act);
    return act;
}

bool ProfileProxy::sendDeleteProfileDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("deleteProfile", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DeleteProfile", act, static_cast<int>(rv));
    return rv;
}

act_t ProfileProxy::sendDeleteProfileGet(DeleteProfileCallbackIF& cb) {
    ProfileProxyCallback* callback = new ProfileProxyCallback(ID_deleteProfile, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DeleteProfile", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("deleteProfile", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint8 ProfileProxy::getDeleteProfile() const {
    return _deleteProfile.get().getDeleteProfile();
}

bool ProfileProxy::hasDeleteProfile() const {
    return _deleteProfile.hasValue();
}

void ProfileProxy::sendDeleteProfileDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DeleteProfile");
    _dbusProxyDelegate->deregisterSignalCallback("deleteProfile", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfileProxy::sendDataChangedRegister(DataChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_dataChanged, "dataChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DataChanged", &cb, act);
    return act;
}

bool ProfileProxy::sendDataChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("dataChanged", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DataChanged", act, static_cast<int>(rv));
    return rv;
}

act_t ProfileProxy::sendDataChangedGet(DataChangedCallbackIF& cb) {
    ProfileProxyCallback* callback = new ProfileProxyCallback(ID_dataChanged, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DataChanged", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("dataChanged", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


dataChangeReason ProfileProxy::getDataChanged() const {
    return _dataChanged.get().getDataChanged();
}

bool ProfileProxy::hasDataChanged() const {
    return _dataChanged.hasValue();
}

void ProfileProxy::sendDataChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DataChanged");
    _dbusProxyDelegate->deregisterSignalCallback("dataChanged", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfileProxy::sendCreateProfileRegister(CreateProfileCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_createProfile, "createProfile", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CreateProfile", &cb, act);
    return act;
}

bool ProfileProxy::sendCreateProfileDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("createProfile", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CreateProfile", act, static_cast<int>(rv));
    return rv;
}

act_t ProfileProxy::sendCreateProfileGet(CreateProfileCallbackIF& cb) {
    ProfileProxyCallback* callback = new ProfileProxyCallback(ID_createProfile, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CreateProfile", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("createProfile", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint8 ProfileProxy::getCreateProfile() const {
    return _createProfile.get().getCreateProfile();
}

bool ProfileProxy::hasCreateProfile() const {
    return _createProfile.hasValue();
}

void ProfileProxy::sendCreateProfileDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CreateProfile");
    _dbusProxyDelegate->deregisterSignalCallback("createProfile", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfileProxy::sendPrivacyModeRegister(PrivacyModeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_privacyMode, "privacyMode", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PrivacyMode", &cb, act);
    return act;
}

bool ProfileProxy::sendPrivacyModeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("privacyMode", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PrivacyMode", act, static_cast<int>(rv));
    return rv;
}

act_t ProfileProxy::sendPrivacyModeGet(PrivacyModeCallbackIF& cb) {
    ProfileProxyCallback* callback = new ProfileProxyCallback(ID_privacyMode, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PrivacyMode", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("privacyMode", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ProfileProxy::sendPrivacyModeSet(uint32 privacyMode) {
    PrivacyModeSet parameter(privacyMode);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "PrivacyMode");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "privacyMode", propertyContent);
}

act_t ProfileProxy::sendPrivacyModeSet(PrivacyModeCallbackIF& cb, uint32 privacyMode) {
    ProfileProxyCallback* callback = new ProfileProxyCallback(ID_privacyMode, &cb);
    PrivacyModeSet parameter(privacyMode);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "PrivacyMode", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "privacyMode", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

uint32 ProfileProxy::getPrivacyMode() const {
    return _privacyMode.get().getPrivacyMode();
}

bool ProfileProxy::hasPrivacyMode() const {
    return _privacyMode.hasValue();
}

void ProfileProxy::sendPrivacyModeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PrivacyMode");
    _dbusProxyDelegate->deregisterSignalCallback("privacyMode", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfileProxy::sendProfileNameRegister(ProfileNameCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_profileName, "profileName", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ProfileName", &cb, act);
    return act;
}

bool ProfileProxy::sendProfileNameDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("profileName", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ProfileName", act, static_cast<int>(rv));
    return rv;
}

act_t ProfileProxy::sendProfileNameGet(ProfileNameCallbackIF& cb) {
    ProfileProxyCallback* callback = new ProfileProxyCallback(ID_profileName, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ProfileName", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("profileName", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ProfileProxy::getProfileName() const {
    return _profileName.get().getProfileName();
}

bool ProfileProxy::hasProfileName() const {
    return _profileName.hasValue();
}

void ProfileProxy::sendProfileNameDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ProfileName");
    _dbusProxyDelegate->deregisterSignalCallback("profileName", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfileProxy::sendProfileImageRegister(ProfileImageCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_profileImage, "profileImage", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ProfileImage", &cb, act);
    return act;
}

bool ProfileProxy::sendProfileImageDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("profileImage", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ProfileImage", act, static_cast<int>(rv));
    return rv;
}

act_t ProfileProxy::sendProfileImageGet(ProfileImageCallbackIF& cb) {
    ProfileProxyCallback* callback = new ProfileProxyCallback(ID_profileImage, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ProfileImage", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("profileImage", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint8 ProfileProxy::getProfileImage() const {
    return _profileImage.get().getProfileImage();
}

bool ProfileProxy::hasProfileImage() const {
    return _profileImage.hasValue();
}

void ProfileProxy::sendProfileImageDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ProfileImage");
    _dbusProxyDelegate->deregisterSignalCallback("profileImage", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfileProxy::sendPinRequestedRegister(PinRequestedCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_pinRequested, "pinRequested", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PinRequested", &cb, act);
    return act;
}

bool ProfileProxy::sendPinRequestedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("pinRequested", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PinRequested", act, static_cast<int>(rv));
    return rv;
}

act_t ProfileProxy::sendPinRequestedGet(PinRequestedCallbackIF& cb) {
    ProfileProxyCallback* callback = new ProfileProxyCallback(ID_pinRequested, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PinRequested", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("pinRequested", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint8 ProfileProxy::getPinRequested() const {
    return _pinRequested.get().getPinRequested();
}

bool ProfileProxy::hasPinRequested() const {
    return _pinRequested.hasValue();
}

void ProfileProxy::sendPinRequestedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PinRequested");
    _dbusProxyDelegate->deregisterSignalCallback("pinRequested", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfileProxy::sendMaxPINAttemptsRegister(MaxPINAttemptsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_maxPINAttempts, "maxPINAttempts", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MaxPINAttempts", &cb, act);
    return act;
}

bool ProfileProxy::sendMaxPINAttemptsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("maxPINAttempts", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MaxPINAttempts", act, static_cast<int>(rv));
    return rv;
}

act_t ProfileProxy::sendMaxPINAttemptsGet(MaxPINAttemptsCallbackIF& cb) {
    ProfileProxyCallback* callback = new ProfileProxyCallback(ID_maxPINAttempts, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "MaxPINAttempts", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("maxPINAttempts", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ProfileProxy::sendMaxPINAttemptsSet(uint8 maxPINAttempts) {
    MaxPINAttemptsSet parameter(maxPINAttempts);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "MaxPINAttempts");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "maxPINAttempts", propertyContent);
}

act_t ProfileProxy::sendMaxPINAttemptsSet(MaxPINAttemptsCallbackIF& cb, uint8 maxPINAttempts) {
    ProfileProxyCallback* callback = new ProfileProxyCallback(ID_maxPINAttempts, &cb);
    MaxPINAttemptsSet parameter(maxPINAttempts);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "MaxPINAttempts", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "maxPINAttempts", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

uint8 ProfileProxy::getMaxPINAttempts() const {
    return _maxPINAttempts.get().getMaxPINAttempts();
}

bool ProfileProxy::hasMaxPINAttempts() const {
    return _maxPINAttempts.hasValue();
}

void ProfileProxy::sendMaxPINAttemptsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MaxPINAttempts");
    _dbusProxyDelegate->deregisterSignalCallback("maxPINAttempts", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfileProxy::sendMaxPINAttemptsBeforeDelayRegister(MaxPINAttemptsBeforeDelayCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_maxPINAttemptsBeforeDelay, "maxPINAttemptsBeforeDelay", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MaxPINAttemptsBeforeDelay", &cb, act);
    return act;
}

bool ProfileProxy::sendMaxPINAttemptsBeforeDelayDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("maxPINAttemptsBeforeDelay", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MaxPINAttemptsBeforeDelay", act, static_cast<int>(rv));
    return rv;
}

act_t ProfileProxy::sendMaxPINAttemptsBeforeDelayGet(MaxPINAttemptsBeforeDelayCallbackIF& cb) {
    ProfileProxyCallback* callback = new ProfileProxyCallback(ID_maxPINAttemptsBeforeDelay, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "MaxPINAttemptsBeforeDelay", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("maxPINAttemptsBeforeDelay", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ProfileProxy::sendMaxPINAttemptsBeforeDelaySet(uint8 maxPINAttemptsBeforeDelay) {
    MaxPINAttemptsBeforeDelaySet parameter(maxPINAttemptsBeforeDelay);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "MaxPINAttemptsBeforeDelay");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "maxPINAttemptsBeforeDelay", propertyContent);
}

act_t ProfileProxy::sendMaxPINAttemptsBeforeDelaySet(MaxPINAttemptsBeforeDelayCallbackIF& cb, uint8 maxPINAttemptsBeforeDelay) {
    ProfileProxyCallback* callback = new ProfileProxyCallback(ID_maxPINAttemptsBeforeDelay, &cb);
    MaxPINAttemptsBeforeDelaySet parameter(maxPINAttemptsBeforeDelay);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "MaxPINAttemptsBeforeDelay", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "maxPINAttemptsBeforeDelay", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

uint8 ProfileProxy::getMaxPINAttemptsBeforeDelay() const {
    return _maxPINAttemptsBeforeDelay.get().getMaxPINAttemptsBeforeDelay();
}

bool ProfileProxy::hasMaxPINAttemptsBeforeDelay() const {
    return _maxPINAttemptsBeforeDelay.hasValue();
}

void ProfileProxy::sendMaxPINAttemptsBeforeDelayDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MaxPINAttemptsBeforeDelay");
    _dbusProxyDelegate->deregisterSignalCallback("maxPINAttemptsBeforeDelay", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfileProxy::sendPinAuthenticationDelayTimeRegister(PinAuthenticationDelayTimeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_pinAuthenticationDelayTime, "pinAuthenticationDelayTime", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PinAuthenticationDelayTime", &cb, act);
    return act;
}

bool ProfileProxy::sendPinAuthenticationDelayTimeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("pinAuthenticationDelayTime", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PinAuthenticationDelayTime", act, static_cast<int>(rv));
    return rv;
}

act_t ProfileProxy::sendPinAuthenticationDelayTimeGet(PinAuthenticationDelayTimeCallbackIF& cb) {
    ProfileProxyCallback* callback = new ProfileProxyCallback(ID_pinAuthenticationDelayTime, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PinAuthenticationDelayTime", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("pinAuthenticationDelayTime", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ProfileProxy::sendPinAuthenticationDelayTimeSet(uint32 pinAuthenticationDelayTime) {
    PinAuthenticationDelayTimeSet parameter(pinAuthenticationDelayTime);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "PinAuthenticationDelayTime");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "pinAuthenticationDelayTime", propertyContent);
}

act_t ProfileProxy::sendPinAuthenticationDelayTimeSet(PinAuthenticationDelayTimeCallbackIF& cb, uint32 pinAuthenticationDelayTime) {
    ProfileProxyCallback* callback = new ProfileProxyCallback(ID_pinAuthenticationDelayTime, &cb);
    PinAuthenticationDelayTimeSet parameter(pinAuthenticationDelayTime);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "PinAuthenticationDelayTime", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "pinAuthenticationDelayTime", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

uint32 ProfileProxy::getPinAuthenticationDelayTime() const {
    return _pinAuthenticationDelayTime.get().getPinAuthenticationDelayTime();
}

bool ProfileProxy::hasPinAuthenticationDelayTime() const {
    return _pinAuthenticationDelayTime.hasValue();
}

void ProfileProxy::sendPinAuthenticationDelayTimeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PinAuthenticationDelayTime");
    _dbusProxyDelegate->deregisterSignalCallback("pinAuthenticationDelayTime", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfileProxy::sendPinVerificationValidityTimeRegister(PinVerificationValidityTimeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_pinVerificationValidityTime, "pinVerificationValidityTime", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PinVerificationValidityTime", &cb, act);
    return act;
}

bool ProfileProxy::sendPinVerificationValidityTimeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("pinVerificationValidityTime", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PinVerificationValidityTime", act, static_cast<int>(rv));
    return rv;
}

act_t ProfileProxy::sendPinVerificationValidityTimeGet(PinVerificationValidityTimeCallbackIF& cb) {
    ProfileProxyCallback* callback = new ProfileProxyCallback(ID_pinVerificationValidityTime, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PinVerificationValidityTime", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("pinVerificationValidityTime", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ProfileProxy::sendPinVerificationValidityTimeSet(uint32 pinVerificationValidityTime) {
    PinVerificationValidityTimeSet parameter(pinVerificationValidityTime);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "PinVerificationValidityTime");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "pinVerificationValidityTime", propertyContent);
}

act_t ProfileProxy::sendPinVerificationValidityTimeSet(PinVerificationValidityTimeCallbackIF& cb, uint32 pinVerificationValidityTime) {
    ProfileProxyCallback* callback = new ProfileProxyCallback(ID_pinVerificationValidityTime, &cb);
    PinVerificationValidityTimeSet parameter(pinVerificationValidityTime);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "PinVerificationValidityTime", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "pinVerificationValidityTime", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

uint32 ProfileProxy::getPinVerificationValidityTime() const {
    return _pinVerificationValidityTime.get().getPinVerificationValidityTime();
}

bool ProfileProxy::hasPinVerificationValidityTime() const {
    return _pinVerificationValidityTime.hasValue();
}

void ProfileProxy::sendPinVerificationValidityTimeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PinVerificationValidityTime");
    _dbusProxyDelegate->deregisterSignalCallback("pinVerificationValidityTime", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfileProxy::sendActiveProfileTypeRegister(ActiveProfileTypeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_activeProfileType, "activeProfileType", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ActiveProfileType", &cb, act);
    return act;
}

bool ProfileProxy::sendActiveProfileTypeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("activeProfileType", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ActiveProfileType", act, static_cast<int>(rv));
    return rv;
}

act_t ProfileProxy::sendActiveProfileTypeGet(ActiveProfileTypeCallbackIF& cb) {
    ProfileProxyCallback* callback = new ProfileProxyCallback(ID_activeProfileType, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ActiveProfileType", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("activeProfileType", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ProfileProxy::sendActiveProfileTypeSet(profileType activeProfileType) {
    ActiveProfileTypeSet parameter(activeProfileType);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "ActiveProfileType");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "activeProfileType", propertyContent);
}

act_t ProfileProxy::sendActiveProfileTypeSet(ActiveProfileTypeCallbackIF& cb, profileType activeProfileType) {
    ProfileProxyCallback* callback = new ProfileProxyCallback(ID_activeProfileType, &cb);
    ActiveProfileTypeSet parameter(activeProfileType);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "ActiveProfileType", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "activeProfileType", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

profileType ProfileProxy::getActiveProfileType() const {
    return _activeProfileType.get().getActiveProfileType();
}

bool ProfileProxy::hasActiveProfileType() const {
    return _activeProfileType.hasValue();
}

void ProfileProxy::sendActiveProfileTypeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ActiveProfileType");
    _dbusProxyDelegate->deregisterSignalCallback("activeProfileType", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfileProxy::sendDoRegisterAppRequest(DoRegisterAppCallbackIF& cb, const ::std::string& appName) const {
    DoRegisterAppRequest* payload = new DoRegisterAppRequest();
    CHECK_ALLOCATION(payload);
    payload->setAppName(appName);
    DBUS_MESSAGE_CALL(dbusMessage, "doRegisterApp", DoRegisterAppRequest, payload, true)
    act_t act = addMethodCallback(ID_doRegisterApp, dbusMessage.getUniqueSerial(), "doRegisterApp", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DoRegisterApp", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ProfileProxy::sendOnDataChangedRequest(uint32 applicationPID, dataChangedResult result) const {
    OnDataChangedRequest* payload = new OnDataChangedRequest();
    CHECK_ALLOCATION(payload);
    payload->setApplicationPID(applicationPID);
    payload->setResult(result);
    DBUS_MESSAGE_CALL(dbusMessage, "onDataChanged", OnDataChangedRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "OnDataChanged");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t ProfileProxy::sendOnProfileDeletedRequest(uint32 applicationPID, clientResult result) const {
    OnProfileDeletedRequest* payload = new OnProfileDeletedRequest();
    CHECK_ALLOCATION(payload);
    payload->setApplicationPID(applicationPID);
    payload->setResult(result);
    DBUS_MESSAGE_CALL(dbusMessage, "onProfileDeleted", OnProfileDeletedRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "OnProfileDeleted");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t ProfileProxy::sendOnProfileCopiedRequest(uint32 applicationPID, clientResult result) const {
    OnProfileCopiedRequest* payload = new OnProfileCopiedRequest();
    CHECK_ALLOCATION(payload);
    payload->setApplicationPID(applicationPID);
    payload->setResult(result);
    DBUS_MESSAGE_CALL(dbusMessage, "onProfileCopied", OnProfileCopiedRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "OnProfileCopied");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t ProfileProxy::sendOnProfileCreatedRequest(uint32 applicationPID, clientResult result) const {
    OnProfileCreatedRequest* payload = new OnProfileCreatedRequest();
    CHECK_ALLOCATION(payload);
    payload->setApplicationPID(applicationPID);
    payload->setResult(result);
    DBUS_MESSAGE_CALL(dbusMessage, "onProfileCreated", OnProfileCreatedRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "OnProfileCreated");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t ProfileProxy::sendDoCopyProfileRequest(DoCopyProfileCallbackIF& cb, uint8 sourceUserID, uint8 destUserID) const {
    DoCopyProfileRequest* payload = new DoCopyProfileRequest();
    CHECK_ALLOCATION(payload);
    payload->setSourceUserID(sourceUserID);
    payload->setDestUserID(destUserID);
    DBUS_MESSAGE_CALL(dbusMessage, "doCopyProfile", DoCopyProfileRequest, payload, true)
    act_t act = addMethodCallback(ID_doCopyProfile, dbusMessage.getUniqueSerial(), "doCopyProfile", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DoCopyProfile", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ProfileProxy::sendDoDeleteProfileRequest(DoDeleteProfileCallbackIF& cb, uint8 userID) const {
    DoDeleteProfileRequest* payload = new DoDeleteProfileRequest();
    CHECK_ALLOCATION(payload);
    payload->setUserID(userID);
    DBUS_MESSAGE_CALL(dbusMessage, "doDeleteProfile", DoDeleteProfileRequest, payload, true)
    act_t act = addMethodCallback(ID_doDeleteProfile, dbusMessage.getUniqueSerial(), "doDeleteProfile", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DoDeleteProfile", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ProfileProxy::sendDoChangeToProfileRequest(DoChangeToProfileCallbackIF& cb, uint8 userID) const {
    DoChangeToProfileRequest* payload = new DoChangeToProfileRequest();
    CHECK_ALLOCATION(payload);
    payload->setUserID(userID);
    DBUS_MESSAGE_CALL(dbusMessage, "doChangeToProfile", DoChangeToProfileRequest, payload, true)
    act_t act = addMethodCallback(ID_doChangeToProfile, dbusMessage.getUniqueSerial(), "doChangeToProfile", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DoChangeToProfile", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ProfileProxy::sendDoCreateProfileRequest(DoCreateProfileCallbackIF& cb, const ::std::string& newName, uint8 imageID) const {
    DoCreateProfileRequest* payload = new DoCreateProfileRequest();
    CHECK_ALLOCATION(payload);
    payload->setNewName(newName);
    payload->setImageID(imageID);
    DBUS_MESSAGE_CALL(dbusMessage, "doCreateProfile", DoCreateProfileRequest, payload, true)
    act_t act = addMethodCallback(ID_doCreateProfile, dbusMessage.getUniqueSerial(), "doCreateProfile", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DoCreateProfile", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ProfileProxy::sendDo_SetProfileNameRequest(Do_SetProfileNameCallbackIF& cb, const ::std::string& newName, uint8 userID) const {
    Do_SetProfileNameRequest* payload = new Do_SetProfileNameRequest();
    CHECK_ALLOCATION(payload);
    payload->setNewName(newName);
    payload->setUserID(userID);
    DBUS_MESSAGE_CALL(dbusMessage, "do_SetProfileName", Do_SetProfileNameRequest, payload, true)
    act_t act = addMethodCallback(ID_do_SetProfileName, dbusMessage.getUniqueSerial(), "do_SetProfileName", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Do_SetProfileName", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ProfileProxy::sendGetProfileNamesRequest(GetProfileNamesCallbackIF& cb) const {
    GetProfileNamesRequest* payload = new GetProfileNamesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "getProfileNames", GetProfileNamesRequest, payload, true)
    act_t act = addMethodCallback(ID_getProfileNames, dbusMessage.getUniqueSerial(), "getProfileNames", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetProfileNames", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ProfileProxy::sendDoImportProfileImageRequest(DoImportProfileImageCallbackIF& cb, const ::std::string& sourcePath, uint16 width, uint16 height, uint16 slotIdx, bool bSetForCurrentProfile) const {
    DoImportProfileImageRequest* payload = new DoImportProfileImageRequest();
    CHECK_ALLOCATION(payload);
    payload->setSourcePath(sourcePath);
    payload->setWidth(width);
    payload->setHeight(height);
    payload->setSlotIdx(slotIdx);
    payload->setBSetForCurrentProfile(bSetForCurrentProfile);
    DBUS_MESSAGE_CALL(dbusMessage, "doImportProfileImage", DoImportProfileImageRequest, payload, true)
    act_t act = addMethodCallback(ID_doImportProfileImage, dbusMessage.getUniqueSerial(), "doImportProfileImage", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DoImportProfileImage", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ProfileProxy::sendRemoveUserImageRequest(RemoveUserImageCallbackIF& cb, uint16 slotIdx) const {
    RemoveUserImageRequest* payload = new RemoveUserImageRequest();
    CHECK_ALLOCATION(payload);
    payload->setSlotIdx(slotIdx);
    DBUS_MESSAGE_CALL(dbusMessage, "removeUserImage", RemoveUserImageRequest, payload, true)
    act_t act = addMethodCallback(ID_removeUserImage, dbusMessage.getUniqueSerial(), "removeUserImage", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RemoveUserImage", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ProfileProxy::sendDoSetProfileImageRequest(DoSetProfileImageCallbackIF& cb, uint8 imageID, uint8 userID) const {
    DoSetProfileImageRequest* payload = new DoSetProfileImageRequest();
    CHECK_ALLOCATION(payload);
    payload->setImageID(imageID);
    payload->setUserID(userID);
    DBUS_MESSAGE_CALL(dbusMessage, "doSetProfileImage", DoSetProfileImageRequest, payload, true)
    act_t act = addMethodCallback(ID_doSetProfileImage, dbusMessage.getUniqueSerial(), "doSetProfileImage", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DoSetProfileImage", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ProfileProxy::sendGetProfileImagesRequest(GetProfileImagesCallbackIF& cb) const {
    GetProfileImagesRequest* payload = new GetProfileImagesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "getProfileImages", GetProfileImagesRequest, payload, true)
    act_t act = addMethodCallback(ID_getProfileImages, dbusMessage.getUniqueSerial(), "getProfileImages", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetProfileImages", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ProfileProxy::sendGetProfileTypesRequest(GetProfileTypesCallbackIF& cb) const {
    GetProfileTypesRequest* payload = new GetProfileTypesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "getProfileTypes", GetProfileTypesRequest, payload, true)
    act_t act = addMethodCallback(ID_getProfileTypes, dbusMessage.getUniqueSerial(), "getProfileTypes", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetProfileTypes", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ProfileProxy::sendSetProfilePinRequest(SetProfilePinCallbackIF& cb, uint8 profileID, const ::std::string& pin) const {
    SetProfilePinRequest* payload = new SetProfilePinRequest();
    CHECK_ALLOCATION(payload);
    payload->setProfileID(profileID);
    payload->setPin(pin);
    DBUS_MESSAGE_CALL(dbusMessage, "setProfilePin", SetProfilePinRequest, payload, true)
    act_t act = addMethodCallback(ID_setProfilePin, dbusMessage.getUniqueSerial(), "setProfilePin", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetProfilePin", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ProfileProxy::sendSetRememberMeRequest(SetRememberMeCallbackIF& cb, uint8 profileID) const {
    SetRememberMeRequest* payload = new SetRememberMeRequest();
    CHECK_ALLOCATION(payload);
    payload->setProfileID(profileID);
    DBUS_MESSAGE_CALL(dbusMessage, "setRememberMe", SetRememberMeRequest, payload, true)
    act_t act = addMethodCallback(ID_setRememberMe, dbusMessage.getUniqueSerial(), "setRememberMe", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetRememberMe", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ProfileProxy::sendCheckPinRequest(CheckPinCallbackIF& cb, uint8 profileID, const ::std::string& pIN) const {
    CheckPinRequest* payload = new CheckPinRequest();
    CHECK_ALLOCATION(payload);
    payload->setProfileID(profileID);
    payload->setPIN(pIN);
    DBUS_MESSAGE_CALL(dbusMessage, "checkPin", CheckPinRequest, payload, true)
    act_t act = addMethodCallback(ID_checkPin, dbusMessage.getUniqueSerial(), "checkPin", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "CheckPin", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ProfileProxy::sendUnProtectProfileRequest(UnProtectProfileCallbackIF& cb, uint8 profileID) const {
    UnProtectProfileRequest* payload = new UnProtectProfileRequest();
    CHECK_ALLOCATION(payload);
    payload->setProfileID(profileID);
    DBUS_MESSAGE_CALL(dbusMessage, "unProtectProfile", UnProtectProfileRequest, payload, true)
    act_t act = addMethodCallback(ID_unProtectProfile, dbusMessage.getUniqueSerial(), "unProtectProfile", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UnProtectProfile", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ProfileProxy::sendLinkProfileRequest(LinkProfileCallbackIF& cb, bool bSetLink) const {
    LinkProfileRequest* payload = new LinkProfileRequest();
    CHECK_ALLOCATION(payload);
    payload->setBSetLink(bSetLink);
    DBUS_MESSAGE_CALL(dbusMessage, "linkProfile", LinkProfileRequest, payload, true)
    act_t act = addMethodCallback(ID_linkProfile, dbusMessage.getUniqueSerial(), "linkProfile", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "LinkProfile", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ProfileProxy::sendSetValetModeRequest(SetValetModeCallbackIF& cb, bool bEnableValetMode) const {
    SetValetModeRequest* payload = new SetValetModeRequest();
    CHECK_ALLOCATION(payload);
    payload->setBEnableValetMode(bEnableValetMode);
    DBUS_MESSAGE_CALL(dbusMessage, "setValetMode", SetValetModeRequest, payload, true)
    act_t act = addMethodCallback(ID_setValetMode, dbusMessage.getUniqueSerial(), "setValetMode", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetValetMode", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace profile
} // namespace cm
} // namespace bosch
