/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "bosch/cm/profile.h"
#include "bosch/cm/profileConst.h"
#include "bosch/cm/profileDBus.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of copyInfo

void serializeDBus (const ::bosch::cm::profile::copyInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o0Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o0Struct));
        uint8 o1 = in.getSource();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_BYTE, &o1));
        uint8 o2 = in.getDestination();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_BYTE, &o2));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o0Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::copyInfo& out) {
    {
        DBusMessageIter o3;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o3);
                {
                    uint8 sourceValue;
                    uint8 &sourceTmpValue = sourceValue;
                    dbus_message_iter_get_basic(&o3, &sourceTmpValue);
                    out.setSource(sourceValue);
                }

                if (dbus_message_iter_has_next(&o3)) {
                    dbus_message_iter_next(&o3);
                } else {
                    return true;
                }

                {
                    uint8 destinationValue;
                    uint8 &destinationTmpValue = destinationValue;
                    dbus_message_iter_get_basic(&o3, &destinationTmpValue);
                    out.setDestination(destinationValue);
                }

                if (dbus_message_iter_has_next(&o3)) {
                    dbus_message_iter_next(&o3);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of DoRegisterAppRequest

void serializeDBus (const ::bosch::cm::profile::DoRegisterAppRequest& in, DBusMessageIter* out) {
    const char* o4 = in.getAppName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o4));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::DoRegisterAppRequest& out) {
    {
        ::std::string AppNameValue;
        ::std::string &AppNameTmpValue = AppNameValue;
        {
            char* o5 = 0;
            dbus_message_iter_get_basic(in, &o5);
            AppNameTmpValue.assign (o5);
        }
        out.setAppName(AppNameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DoRegisterAppResponse

void serializeDBus (const ::bosch::cm::profile::DoRegisterAppResponse& in, DBusMessageIter* out) {
    uint32 o6 = in.getAppID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o6));
    const char* o7 = in.getApplName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o7));
    dbus_bool_t o8 = in.getReloadData() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o8));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::DoRegisterAppResponse& out) {
    {
        uint32 AppIDValue;
        uint32 &AppIDTmpValue = AppIDValue;
        dbus_message_iter_get_basic(in, &AppIDTmpValue);
        out.setAppID(AppIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string ApplNameValue;
        ::std::string &ApplNameTmpValue = ApplNameValue;
        {
            char* o9 = 0;
            dbus_message_iter_get_basic(in, &o9);
            ApplNameTmpValue.assign (o9);
        }
        out.setApplName(ApplNameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool reloadDataValue;
        bool &reloadDataTmpValue = reloadDataValue;
        {
            dbus_bool_t o10;
            dbus_message_iter_get_basic(in, &o10);
            reloadDataTmpValue = o10 ? true : false;
        }
        out.setReloadData(reloadDataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of OnDataChangedRequest

void serializeDBus (const ::bosch::cm::profile::OnDataChangedRequest& in, DBusMessageIter* out) {
    uint32 o11 = in.getApplicationPID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o11));
    const ::bosch::cm::profile::dataChangedResult  o12 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o12));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::OnDataChangedRequest& out) {
    {
        uint32 ApplicationPIDValue;
        uint32 &ApplicationPIDTmpValue = ApplicationPIDValue;
        dbus_message_iter_get_basic(in, &ApplicationPIDTmpValue);
        out.setApplicationPID(ApplicationPIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::profile::dataChangedResult ResultValue = ::bosch::cm::profile::dataChangedResult__PREPARED;
        dbus_message_iter_get_basic(in, &ResultValue);
        out.setResult(ResultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of OnProfileDeletedRequest

void serializeDBus (const ::bosch::cm::profile::OnProfileDeletedRequest& in, DBusMessageIter* out) {
    uint32 o13 = in.getApplicationPID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o13));
    const ::bosch::cm::profile::clientResult  o14 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o14));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::OnProfileDeletedRequest& out) {
    {
        uint32 ApplicationPIDValue;
        uint32 &ApplicationPIDTmpValue = ApplicationPIDValue;
        dbus_message_iter_get_basic(in, &ApplicationPIDTmpValue);
        out.setApplicationPID(ApplicationPIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::profile::clientResult ResultValue = ::bosch::cm::profile::clientResult__SUCCESS;
        dbus_message_iter_get_basic(in, &ResultValue);
        out.setResult(ResultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of OnProfileCopiedRequest

void serializeDBus (const ::bosch::cm::profile::OnProfileCopiedRequest& in, DBusMessageIter* out) {
    uint32 o15 = in.getApplicationPID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o15));
    const ::bosch::cm::profile::clientResult  o16 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o16));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::OnProfileCopiedRequest& out) {
    {
        uint32 ApplicationPIDValue;
        uint32 &ApplicationPIDTmpValue = ApplicationPIDValue;
        dbus_message_iter_get_basic(in, &ApplicationPIDTmpValue);
        out.setApplicationPID(ApplicationPIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::profile::clientResult ResultValue = ::bosch::cm::profile::clientResult__SUCCESS;
        dbus_message_iter_get_basic(in, &ResultValue);
        out.setResult(ResultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of OnProfileCreatedRequest

void serializeDBus (const ::bosch::cm::profile::OnProfileCreatedRequest& in, DBusMessageIter* out) {
    uint32 o17 = in.getApplicationPID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o17));
    const ::bosch::cm::profile::clientResult  o18 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o18));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::OnProfileCreatedRequest& out) {
    {
        uint32 ApplicationPIDValue;
        uint32 &ApplicationPIDTmpValue = ApplicationPIDValue;
        dbus_message_iter_get_basic(in, &ApplicationPIDTmpValue);
        out.setApplicationPID(ApplicationPIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::profile::clientResult ResultValue = ::bosch::cm::profile::clientResult__SUCCESS;
        dbus_message_iter_get_basic(in, &ResultValue);
        out.setResult(ResultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DoCopyProfileRequest

void serializeDBus (const ::bosch::cm::profile::DoCopyProfileRequest& in, DBusMessageIter* out) {
    uint8 o19 = in.getSourceUserID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o19));
    uint8 o20 = in.getDestUserID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o20));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::DoCopyProfileRequest& out) {
    {
        uint8 sourceUserIDValue;
        uint8 &sourceUserIDTmpValue = sourceUserIDValue;
        dbus_message_iter_get_basic(in, &sourceUserIDTmpValue);
        out.setSourceUserID(sourceUserIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 destUserIDValue;
        uint8 &destUserIDTmpValue = destUserIDValue;
        dbus_message_iter_get_basic(in, &destUserIDTmpValue);
        out.setDestUserID(destUserIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DoCopyProfileResponse

void serializeDBus (const ::bosch::cm::profile::DoCopyProfileResponse& in, DBusMessageIter* out) {
    const ::bosch::cm::profile::serverResult  o21 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o21));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::DoCopyProfileResponse& out) {
    {
        ::bosch::cm::profile::serverResult ResultValue = ::bosch::cm::profile::serverResult__SUCCESS;
        dbus_message_iter_get_basic(in, &ResultValue);
        out.setResult(ResultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DoDeleteProfileRequest

void serializeDBus (const ::bosch::cm::profile::DoDeleteProfileRequest& in, DBusMessageIter* out) {
    uint8 o22 = in.getUserID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o22));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::DoDeleteProfileRequest& out) {
    {
        uint8 userIDValue;
        uint8 &userIDTmpValue = userIDValue;
        dbus_message_iter_get_basic(in, &userIDTmpValue);
        out.setUserID(userIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DoDeleteProfileResponse

void serializeDBus (const ::bosch::cm::profile::DoDeleteProfileResponse& in, DBusMessageIter* out) {
    const ::bosch::cm::profile::serverResult  o23 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o23));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::DoDeleteProfileResponse& out) {
    {
        ::bosch::cm::profile::serverResult ResultValue = ::bosch::cm::profile::serverResult__SUCCESS;
        dbus_message_iter_get_basic(in, &ResultValue);
        out.setResult(ResultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DoChangeToProfileRequest

void serializeDBus (const ::bosch::cm::profile::DoChangeToProfileRequest& in, DBusMessageIter* out) {
    uint8 o24 = in.getUserID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o24));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::DoChangeToProfileRequest& out) {
    {
        uint8 userIDValue;
        uint8 &userIDTmpValue = userIDValue;
        dbus_message_iter_get_basic(in, &userIDTmpValue);
        out.setUserID(userIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DoChangeToProfileResponse

void serializeDBus (const ::bosch::cm::profile::DoChangeToProfileResponse& in, DBusMessageIter* out) {
    const ::bosch::cm::profile::serverResult  o25 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o25));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::DoChangeToProfileResponse& out) {
    {
        ::bosch::cm::profile::serverResult ResultValue = ::bosch::cm::profile::serverResult__SUCCESS;
        dbus_message_iter_get_basic(in, &ResultValue);
        out.setResult(ResultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DoCreateProfileRequest

void serializeDBus (const ::bosch::cm::profile::DoCreateProfileRequest& in, DBusMessageIter* out) {
    const char* o26 = in.getNewName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o26));
    uint8 o27 = in.getImageID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o27));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::DoCreateProfileRequest& out) {
    {
        ::std::string newNameValue;
        ::std::string &newNameTmpValue = newNameValue;
        {
            char* o28 = 0;
            dbus_message_iter_get_basic(in, &o28);
            newNameTmpValue.assign (o28);
        }
        out.setNewName(newNameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 imageIDValue;
        uint8 &imageIDTmpValue = imageIDValue;
        dbus_message_iter_get_basic(in, &imageIDTmpValue);
        out.setImageID(imageIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DoCreateProfileResponse

void serializeDBus (const ::bosch::cm::profile::DoCreateProfileResponse& in, DBusMessageIter* out) {
    const ::bosch::cm::profile::serverResult  o29 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o29));
    uint8 o30 = in.getNewUserID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o30));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::DoCreateProfileResponse& out) {
    {
        ::bosch::cm::profile::serverResult ResultValue = ::bosch::cm::profile::serverResult__SUCCESS;
        dbus_message_iter_get_basic(in, &ResultValue);
        out.setResult(ResultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 newUserIDValue;
        uint8 &newUserIDTmpValue = newUserIDValue;
        dbus_message_iter_get_basic(in, &newUserIDTmpValue);
        out.setNewUserID(newUserIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of Do_SetProfileNameRequest

void serializeDBus (const ::bosch::cm::profile::Do_SetProfileNameRequest& in, DBusMessageIter* out) {
    const char* o31 = in.getNewName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o31));
    uint8 o32 = in.getUserID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o32));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::Do_SetProfileNameRequest& out) {
    {
        ::std::string newNameValue;
        ::std::string &newNameTmpValue = newNameValue;
        {
            char* o33 = 0;
            dbus_message_iter_get_basic(in, &o33);
            newNameTmpValue.assign (o33);
        }
        out.setNewName(newNameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 userIDValue;
        uint8 &userIDTmpValue = userIDValue;
        dbus_message_iter_get_basic(in, &userIDTmpValue);
        out.setUserID(userIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of Do_SetProfileNameResponse

void serializeDBus (const ::bosch::cm::profile::Do_SetProfileNameResponse& in, DBusMessageIter* out) {
    const ::bosch::cm::profile::serverResult  o34 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o34));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::Do_SetProfileNameResponse& out) {
    {
        ::bosch::cm::profile::serverResult ResultValue = ::bosch::cm::profile::serverResult__SUCCESS;
        dbus_message_iter_get_basic(in, &ResultValue);
        out.setResult(ResultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetProfileNamesResponse

void serializeDBus (const ::bosch::cm::profile::GetProfileNamesResponse& in, DBusMessageIter* out) {
    DBusMessageIter o35ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o35ArrayIter));
    const ::std::vector< ::std::string >* o36 = &in.getNames();
    ::std::vector< ::std::string >::const_iterator o37 = o36->end();
    for (::std::vector< ::std::string >::const_iterator o38 = o36->begin(); o38 != o37; ++o38) {
        const char* o39 = (*o38).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o35ArrayIter, DBUS_TYPE_STRING, &o39));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o35ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::GetProfileNamesResponse& out) {
    {
        ::std::vector< ::std::string > namesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o40ArrayIter;
            dbus_message_iter_recurse (in, &o40ArrayIter);

            if(dbus_message_iter_get_arg_type(&o40ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o41;
                    {
                        char* o42 = 0;
                        dbus_message_iter_get_basic(&o40ArrayIter, &o42);
                        o41.assign (o42);
                    }
                    namesValue.push_back(o41);
                } while (dbus_message_iter_next(&o40ArrayIter));
            }
        }
        out.setNames(namesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DoImportProfileImageRequest

void serializeDBus (const ::bosch::cm::profile::DoImportProfileImageRequest& in, DBusMessageIter* out) {
    const char* o43 = in.getSourcePath().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o43));
    uint16 o44 = in.getWidth();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o44));
    uint16 o45 = in.getHeight();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o45));
    uint16 o46 = in.getSlotIdx();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o46));
    dbus_bool_t o47 = in.getBSetForCurrentProfile() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o47));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::DoImportProfileImageRequest& out) {
    {
        ::std::string sourcePathValue;
        ::std::string &sourcePathTmpValue = sourcePathValue;
        {
            char* o48 = 0;
            dbus_message_iter_get_basic(in, &o48);
            sourcePathTmpValue.assign (o48);
        }
        out.setSourcePath(sourcePathValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 widthValue;
        uint16 &widthTmpValue = widthValue;
        dbus_message_iter_get_basic(in, &widthTmpValue);
        out.setWidth(widthValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 heightValue;
        uint16 &heightTmpValue = heightValue;
        dbus_message_iter_get_basic(in, &heightTmpValue);
        out.setHeight(heightValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 slotIdxValue;
        uint16 &slotIdxTmpValue = slotIdxValue;
        dbus_message_iter_get_basic(in, &slotIdxTmpValue);
        out.setSlotIdx(slotIdxValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool bSetForCurrentProfileValue;
        bool &bSetForCurrentProfileTmpValue = bSetForCurrentProfileValue;
        {
            dbus_bool_t o49;
            dbus_message_iter_get_basic(in, &o49);
            bSetForCurrentProfileTmpValue = o49 ? true : false;
        }
        out.setBSetForCurrentProfile(bSetForCurrentProfileValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DoImportProfileImageResponse

void serializeDBus (const ::bosch::cm::profile::DoImportProfileImageResponse& in, DBusMessageIter* out) {
    const ::bosch::cm::profile::serverResult  o50 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o50));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::DoImportProfileImageResponse& out) {
    {
        ::bosch::cm::profile::serverResult resultValue = ::bosch::cm::profile::serverResult__SUCCESS;
        dbus_message_iter_get_basic(in, &resultValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RemoveUserImageRequest

void serializeDBus (const ::bosch::cm::profile::RemoveUserImageRequest& in, DBusMessageIter* out) {
    uint16 o51 = in.getSlotIdx();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o51));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::RemoveUserImageRequest& out) {
    {
        uint16 slotIdxValue;
        uint16 &slotIdxTmpValue = slotIdxValue;
        dbus_message_iter_get_basic(in, &slotIdxTmpValue);
        out.setSlotIdx(slotIdxValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RemoveUserImageResponse

void serializeDBus (const ::bosch::cm::profile::RemoveUserImageResponse& in, DBusMessageIter* out) {
    const ::bosch::cm::profile::serverResult  o52 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o52));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::RemoveUserImageResponse& out) {
    {
        ::bosch::cm::profile::serverResult resultValue = ::bosch::cm::profile::serverResult__SUCCESS;
        dbus_message_iter_get_basic(in, &resultValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DoSetProfileImageRequest

void serializeDBus (const ::bosch::cm::profile::DoSetProfileImageRequest& in, DBusMessageIter* out) {
    uint8 o53 = in.getImageID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o53));
    uint8 o54 = in.getUserID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o54));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::DoSetProfileImageRequest& out) {
    {
        uint8 imageIDValue;
        uint8 &imageIDTmpValue = imageIDValue;
        dbus_message_iter_get_basic(in, &imageIDTmpValue);
        out.setImageID(imageIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 userIDValue;
        uint8 &userIDTmpValue = userIDValue;
        dbus_message_iter_get_basic(in, &userIDTmpValue);
        out.setUserID(userIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DoSetProfileImageResponse

void serializeDBus (const ::bosch::cm::profile::DoSetProfileImageResponse& in, DBusMessageIter* out) {
    const ::bosch::cm::profile::serverResult  o55 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o55));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::DoSetProfileImageResponse& out) {
    {
        ::bosch::cm::profile::serverResult resultValue = ::bosch::cm::profile::serverResult__SUCCESS;
        dbus_message_iter_get_basic(in, &resultValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetProfileImagesResponse

void serializeDBus (const ::bosch::cm::profile::GetProfileImagesResponse& in, DBusMessageIter* out) {
    DBusMessageIter o56ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "y", &o56ArrayIter));
    const ::std::vector< uint8 >* o57 = &in.getImages();
    ::std::vector< uint8 >::const_iterator o58 = o57->end();
    for (::std::vector< uint8 >::const_iterator o59 = o57->begin(); o59 != o58; ++o59) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o56ArrayIter, DBUS_TYPE_BYTE, &(*o59)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o56ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::GetProfileImagesResponse& out) {
    {
        ::std::vector< uint8 > imagesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o60ArrayIter;
            dbus_message_iter_recurse (in, &o60ArrayIter);

            if(dbus_message_iter_get_arg_type(&o60ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint8 o61;
                    dbus_message_iter_get_basic(&o60ArrayIter, &o61);
                    imagesValue.push_back(o61);
                } while (dbus_message_iter_next(&o60ArrayIter));
            }
        }
        out.setImages(imagesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetProfileTypesResponse

void serializeDBus (const ::bosch::cm::profile::GetProfileTypesResponse& in, DBusMessageIter* out) {
    DBusMessageIter o62ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "u", &o62ArrayIter));
    const ::std::vector< ::bosch::cm::profile::profileType >* o63 = &in.getTypes();
    ::std::vector< ::bosch::cm::profile::profileType >::const_iterator o64 = o63->end();
    for (::std::vector< ::bosch::cm::profile::profileType >::const_iterator o65 = o63->begin(); o65 != o64; ++o65) {
        const ::bosch::cm::profile::profileType  o66 = (*o65);
        DBUS_ASSERT(dbus_message_iter_append_basic(&o62ArrayIter, DBUS_TYPE_UINT32, &o66));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o62ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::GetProfileTypesResponse& out) {
    {
        ::std::vector< ::bosch::cm::profile::profileType > typesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o67ArrayIter;
            dbus_message_iter_recurse (in, &o67ArrayIter);

            if(dbus_message_iter_get_arg_type(&o67ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::bosch::cm::profile::profileType o68 = ::bosch::cm::profile::profileType__EMPTY;
                    dbus_message_iter_get_basic(&o67ArrayIter, &o68);
                    typesValue.push_back(o68);
                } while (dbus_message_iter_next(&o67ArrayIter));
            }
        }
        out.setTypes(typesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetProfilePinRequest

void serializeDBus (const ::bosch::cm::profile::SetProfilePinRequest& in, DBusMessageIter* out) {
    uint8 o69 = in.getProfileID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o69));
    const char* o70 = in.getPin().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o70));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::SetProfilePinRequest& out) {
    {
        uint8 profileIDValue;
        uint8 &profileIDTmpValue = profileIDValue;
        dbus_message_iter_get_basic(in, &profileIDTmpValue);
        out.setProfileID(profileIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string PinValue;
        ::std::string &PinTmpValue = PinValue;
        {
            char* o71 = 0;
            dbus_message_iter_get_basic(in, &o71);
            PinTmpValue.assign (o71);
        }
        out.setPin(PinValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetProfilePinResponse

void serializeDBus (const ::bosch::cm::profile::SetProfilePinResponse& in, DBusMessageIter* out) {
    const ::bosch::cm::profile::serverResult  o72 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o72));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::SetProfilePinResponse& out) {
    {
        ::bosch::cm::profile::serverResult resultValue = ::bosch::cm::profile::serverResult__SUCCESS;
        dbus_message_iter_get_basic(in, &resultValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetRememberMeRequest

void serializeDBus (const ::bosch::cm::profile::SetRememberMeRequest& in, DBusMessageIter* out) {
    uint8 o73 = in.getProfileID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o73));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::SetRememberMeRequest& out) {
    {
        uint8 profileIDValue;
        uint8 &profileIDTmpValue = profileIDValue;
        dbus_message_iter_get_basic(in, &profileIDTmpValue);
        out.setProfileID(profileIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetRememberMeResponse

void serializeDBus (const ::bosch::cm::profile::SetRememberMeResponse& in, DBusMessageIter* out) {
    const ::bosch::cm::profile::serverResult  o74 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o74));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::SetRememberMeResponse& out) {
    {
        ::bosch::cm::profile::serverResult resultValue = ::bosch::cm::profile::serverResult__SUCCESS;
        dbus_message_iter_get_basic(in, &resultValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CheckPinRequest

void serializeDBus (const ::bosch::cm::profile::CheckPinRequest& in, DBusMessageIter* out) {
    uint8 o75 = in.getProfileID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o75));
    const char* o76 = in.getPIN().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o76));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::CheckPinRequest& out) {
    {
        uint8 profileIDValue;
        uint8 &profileIDTmpValue = profileIDValue;
        dbus_message_iter_get_basic(in, &profileIDTmpValue);
        out.setProfileID(profileIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string PINValue;
        ::std::string &PINTmpValue = PINValue;
        {
            char* o77 = 0;
            dbus_message_iter_get_basic(in, &o77);
            PINTmpValue.assign (o77);
        }
        out.setPIN(PINValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CheckPinResponse

void serializeDBus (const ::bosch::cm::profile::CheckPinResponse& in, DBusMessageIter* out) {
    const ::bosch::cm::profile::serverResult  o78 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o78));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::CheckPinResponse& out) {
    {
        ::bosch::cm::profile::serverResult resultValue = ::bosch::cm::profile::serverResult__SUCCESS;
        dbus_message_iter_get_basic(in, &resultValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UnProtectProfileRequest

void serializeDBus (const ::bosch::cm::profile::UnProtectProfileRequest& in, DBusMessageIter* out) {
    uint8 o79 = in.getProfileID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o79));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::UnProtectProfileRequest& out) {
    {
        uint8 profileIDValue;
        uint8 &profileIDTmpValue = profileIDValue;
        dbus_message_iter_get_basic(in, &profileIDTmpValue);
        out.setProfileID(profileIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UnProtectProfileResponse

void serializeDBus (const ::bosch::cm::profile::UnProtectProfileResponse& in, DBusMessageIter* out) {
    const ::bosch::cm::profile::serverResult  o80 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o80));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::UnProtectProfileResponse& out) {
    {
        ::bosch::cm::profile::serverResult resultValue = ::bosch::cm::profile::serverResult__SUCCESS;
        dbus_message_iter_get_basic(in, &resultValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LinkProfileRequest

void serializeDBus (const ::bosch::cm::profile::LinkProfileRequest& in, DBusMessageIter* out) {
    dbus_bool_t o81 = in.getBSetLink() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o81));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::LinkProfileRequest& out) {
    {
        bool bSetLinkValue;
        bool &bSetLinkTmpValue = bSetLinkValue;
        {
            dbus_bool_t o82;
            dbus_message_iter_get_basic(in, &o82);
            bSetLinkTmpValue = o82 ? true : false;
        }
        out.setBSetLink(bSetLinkValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LinkProfileResponse

void serializeDBus (const ::bosch::cm::profile::LinkProfileResponse& in, DBusMessageIter* out) {
    const ::bosch::cm::profile::serverResult  o83 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o83));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::LinkProfileResponse& out) {
    {
        ::bosch::cm::profile::serverResult resultValue = ::bosch::cm::profile::serverResult__SUCCESS;
        dbus_message_iter_get_basic(in, &resultValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetValetModeRequest

void serializeDBus (const ::bosch::cm::profile::SetValetModeRequest& in, DBusMessageIter* out) {
    dbus_bool_t o84 = in.getBEnableValetMode() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o84));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::SetValetModeRequest& out) {
    {
        bool bEnableValetModeValue;
        bool &bEnableValetModeTmpValue = bEnableValetModeValue;
        {
            dbus_bool_t o85;
            dbus_message_iter_get_basic(in, &o85);
            bEnableValetModeTmpValue = o85 ? true : false;
        }
        out.setBEnableValetMode(bEnableValetModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetValetModeResponse

void serializeDBus (const ::bosch::cm::profile::SetValetModeResponse& in, DBusMessageIter* out) {
    const ::bosch::cm::profile::serverResult  o86 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o86));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::SetValetModeResponse& out) {
    {
        ::bosch::cm::profile::serverResult resultValue = ::bosch::cm::profile::serverResult__SUCCESS;
        dbus_message_iter_get_basic(in, &resultValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ActiveProfileUpdate

void serializeDBus (const ::bosch::cm::profile::ActiveProfileUpdate& in, DBusMessageIter* out) {
    uint8 o87 = in.getActiveProfile();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o87));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::ActiveProfileUpdate& out) {
    {
        uint8 activeProfileValue;
        uint8 &activeProfileTmpValue = activeProfileValue;
        dbus_message_iter_get_basic(in, &activeProfileTmpValue);
        out.setActiveProfile(activeProfileValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ActiveProfileRegister

void serializeDBus (const ::bosch::cm::profile::ActiveProfileRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::profile::ActiveProfileRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of StatusUpdate

void serializeDBus (const ::bosch::cm::profile::StatusUpdate& in, DBusMessageIter* out) {
    const ::bosch::cm::profile::ProfileStatus  o88 = in.getStatus();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o88));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::StatusUpdate& out) {
    {
        ::bosch::cm::profile::ProfileStatus statusValue = ::bosch::cm::profile::ProfileStatus__UNLOCKED;
        dbus_message_iter_get_basic(in, &statusValue);
        out.setStatus(statusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StatusRegister

void serializeDBus (const ::bosch::cm::profile::StatusRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::profile::StatusRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CopyProfileUpdate

void serializeDBus (const ::bosch::cm::profile::CopyProfileUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getCopyProfile(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::CopyProfileUpdate& out) {
    {
        ::bosch::cm::profile::copyInfo copyProfileValue;
        if (!deserializeDBus(in, copyProfileValue)) {
            return false;
        }
        out.setCopyProfile(copyProfileValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CopyProfileRegister

void serializeDBus (const ::bosch::cm::profile::CopyProfileRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::profile::CopyProfileRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of DeleteProfileUpdate

void serializeDBus (const ::bosch::cm::profile::DeleteProfileUpdate& in, DBusMessageIter* out) {
    uint8 o89 = in.getDeleteProfile();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o89));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::DeleteProfileUpdate& out) {
    {
        uint8 deleteProfileValue;
        uint8 &deleteProfileTmpValue = deleteProfileValue;
        dbus_message_iter_get_basic(in, &deleteProfileTmpValue);
        out.setDeleteProfile(deleteProfileValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DeleteProfileRegister

void serializeDBus (const ::bosch::cm::profile::DeleteProfileRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::profile::DeleteProfileRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of DataChangedUpdate

void serializeDBus (const ::bosch::cm::profile::DataChangedUpdate& in, DBusMessageIter* out) {
    const ::bosch::cm::profile::dataChangeReason  o90 = in.getDataChanged();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o90));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::DataChangedUpdate& out) {
    {
        ::bosch::cm::profile::dataChangeReason dataChangedValue = ::bosch::cm::profile::dataChangeReason__IDLE;
        dbus_message_iter_get_basic(in, &dataChangedValue);
        out.setDataChanged(dataChangedValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DataChangedRegister

void serializeDBus (const ::bosch::cm::profile::DataChangedRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::profile::DataChangedRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CreateProfileUpdate

void serializeDBus (const ::bosch::cm::profile::CreateProfileUpdate& in, DBusMessageIter* out) {
    uint8 o91 = in.getCreateProfile();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o91));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::CreateProfileUpdate& out) {
    {
        uint8 createProfileValue;
        uint8 &createProfileTmpValue = createProfileValue;
        dbus_message_iter_get_basic(in, &createProfileTmpValue);
        out.setCreateProfile(createProfileValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CreateProfileRegister

void serializeDBus (const ::bosch::cm::profile::CreateProfileRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::profile::CreateProfileRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PrivacyModeUpdate

void serializeDBus (const ::bosch::cm::profile::PrivacyModeUpdate& in, DBusMessageIter* out) {
    uint32 o92 = in.getPrivacyMode();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o92));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::PrivacyModeUpdate& out) {
    {
        uint32 privacyModeValue;
        uint32 &privacyModeTmpValue = privacyModeValue;
        dbus_message_iter_get_basic(in, &privacyModeTmpValue);
        out.setPrivacyMode(privacyModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PrivacyModeRegister

void serializeDBus (const ::bosch::cm::profile::PrivacyModeRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::profile::PrivacyModeRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ProfileNameUpdate

void serializeDBus (const ::bosch::cm::profile::ProfileNameUpdate& in, DBusMessageIter* out) {
    const char* o93 = in.getProfileName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o93));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::ProfileNameUpdate& out) {
    {
        ::std::string profileNameValue;
        ::std::string &profileNameTmpValue = profileNameValue;
        {
            char* o94 = 0;
            dbus_message_iter_get_basic(in, &o94);
            profileNameTmpValue.assign (o94);
        }
        out.setProfileName(profileNameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ProfileNameRegister

void serializeDBus (const ::bosch::cm::profile::ProfileNameRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::profile::ProfileNameRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ProfileImageUpdate

void serializeDBus (const ::bosch::cm::profile::ProfileImageUpdate& in, DBusMessageIter* out) {
    uint8 o95 = in.getProfileImage();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o95));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::ProfileImageUpdate& out) {
    {
        uint8 profileImageValue;
        uint8 &profileImageTmpValue = profileImageValue;
        dbus_message_iter_get_basic(in, &profileImageTmpValue);
        out.setProfileImage(profileImageValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ProfileImageRegister

void serializeDBus (const ::bosch::cm::profile::ProfileImageRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::profile::ProfileImageRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PinRequestedUpdate

void serializeDBus (const ::bosch::cm::profile::PinRequestedUpdate& in, DBusMessageIter* out) {
    uint8 o96 = in.getPinRequested();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o96));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::PinRequestedUpdate& out) {
    {
        uint8 pinRequestedValue;
        uint8 &pinRequestedTmpValue = pinRequestedValue;
        dbus_message_iter_get_basic(in, &pinRequestedTmpValue);
        out.setPinRequested(pinRequestedValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PinRequestedRegister

void serializeDBus (const ::bosch::cm::profile::PinRequestedRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::profile::PinRequestedRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of MaxPINAttemptsUpdate

void serializeDBus (const ::bosch::cm::profile::MaxPINAttemptsUpdate& in, DBusMessageIter* out) {
    uint8 o97 = in.getMaxPINAttempts();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o97));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::MaxPINAttemptsUpdate& out) {
    {
        uint8 maxPINAttemptsValue;
        uint8 &maxPINAttemptsTmpValue = maxPINAttemptsValue;
        dbus_message_iter_get_basic(in, &maxPINAttemptsTmpValue);
        out.setMaxPINAttempts(maxPINAttemptsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MaxPINAttemptsRegister

void serializeDBus (const ::bosch::cm::profile::MaxPINAttemptsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::profile::MaxPINAttemptsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of MaxPINAttemptsBeforeDelayUpdate

void serializeDBus (const ::bosch::cm::profile::MaxPINAttemptsBeforeDelayUpdate& in, DBusMessageIter* out) {
    uint8 o98 = in.getMaxPINAttemptsBeforeDelay();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o98));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::MaxPINAttemptsBeforeDelayUpdate& out) {
    {
        uint8 maxPINAttemptsBeforeDelayValue;
        uint8 &maxPINAttemptsBeforeDelayTmpValue = maxPINAttemptsBeforeDelayValue;
        dbus_message_iter_get_basic(in, &maxPINAttemptsBeforeDelayTmpValue);
        out.setMaxPINAttemptsBeforeDelay(maxPINAttemptsBeforeDelayValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MaxPINAttemptsBeforeDelayRegister

void serializeDBus (const ::bosch::cm::profile::MaxPINAttemptsBeforeDelayRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::profile::MaxPINAttemptsBeforeDelayRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PinAuthenticationDelayTimeUpdate

void serializeDBus (const ::bosch::cm::profile::PinAuthenticationDelayTimeUpdate& in, DBusMessageIter* out) {
    uint32 o99 = in.getPinAuthenticationDelayTime();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o99));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::PinAuthenticationDelayTimeUpdate& out) {
    {
        uint32 pinAuthenticationDelayTimeValue;
        uint32 &pinAuthenticationDelayTimeTmpValue = pinAuthenticationDelayTimeValue;
        dbus_message_iter_get_basic(in, &pinAuthenticationDelayTimeTmpValue);
        out.setPinAuthenticationDelayTime(pinAuthenticationDelayTimeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PinAuthenticationDelayTimeRegister

void serializeDBus (const ::bosch::cm::profile::PinAuthenticationDelayTimeRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::profile::PinAuthenticationDelayTimeRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PinVerificationValidityTimeUpdate

void serializeDBus (const ::bosch::cm::profile::PinVerificationValidityTimeUpdate& in, DBusMessageIter* out) {
    uint32 o100 = in.getPinVerificationValidityTime();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o100));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::PinVerificationValidityTimeUpdate& out) {
    {
        uint32 pinVerificationValidityTimeValue;
        uint32 &pinVerificationValidityTimeTmpValue = pinVerificationValidityTimeValue;
        dbus_message_iter_get_basic(in, &pinVerificationValidityTimeTmpValue);
        out.setPinVerificationValidityTime(pinVerificationValidityTimeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PinVerificationValidityTimeRegister

void serializeDBus (const ::bosch::cm::profile::PinVerificationValidityTimeRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::profile::PinVerificationValidityTimeRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ActiveProfileTypeUpdate

void serializeDBus (const ::bosch::cm::profile::ActiveProfileTypeUpdate& in, DBusMessageIter* out) {
    const ::bosch::cm::profile::profileType  o101 = in.getActiveProfileType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o101));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::profile::ActiveProfileTypeUpdate& out) {
    {
        ::bosch::cm::profile::profileType activeProfileTypeValue = ::bosch::cm::profile::profileType__EMPTY;
        dbus_message_iter_get_basic(in, &activeProfileTypeValue);
        out.setActiveProfileType(activeProfileTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ActiveProfileTypeRegister

void serializeDBus (const ::bosch::cm::profile::ActiveProfileTypeRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::profile::ActiveProfileTypeRegister& /*out*/) {
    return true;
}

