/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_PROFILECONST_H
#define BOSCH_CM_PROFILECONST_H

#include <cstddef>

/**
 * basic attributes for User Profile Management
 */

namespace bosch {
namespace cm {
namespace profile {

/**
 * If the meaning of "ProfileStatus" isn't clear, then there should be a description here.
 */
enum ProfileStatus {

    /**
     * Normal Mode. All Read and write acesses are allowed
     */
    ProfileStatus__UNLOCKED,
    /**
     * In locked status, Private data should not be written. On read request to a Private value, the default value should be returned
     */
    ProfileStatus__LOCKED,
    /**
     * User change is ongoing. No write acess to Profile values is allowed
     */
    ProfileStatus__LOADING,
    /**
     * System is starting. no user actions are allowed
     */
    ProfileStatus__INITIALIZING,
    /**
     * System is in valet mode. no profile actions are allowed
     */
    ProfileStatus__VALET_MODE

};

bool ProfileStatus_Parse (const char *str, size_t length, ProfileStatus &value);

const char* ProfileStatus_Name (ProfileStatus value);

bool ProfileStatus_IsValid (ProfileStatus value);

/**
 * If the meaning of "serverResult" isn't clear, then there should be a description here.
 */
enum serverResult {

    /**
     * If the meaning of "SUCCESS" isn't clear, then there should be a description here.
     */
    serverResult__SUCCESS,
    /**
     * If the meaning of "ONGOING" isn't clear, then there should be a description here.
     */
    serverResult__ONGOING,
    /**
     * If the meaning of "FAILED" isn't clear, then there should be a description here.
     */
    serverResult__FAILED,
    /**
     * If the meaning of "INTIALIZING" isn't clear, then there should be a description here.
     */
    serverResult__INTIALIZING,
    /**
     * If the meaning of "WRONG_PARAMETER" isn't clear, then there should be a description here.
     */
    serverResult__WRONG_PARAMETER,
    /**
     * If the meaning of "ACCESS_DENIED" isn't clear, then there should be a description here.
     */
    serverResult__ACCESS_DENIED,
    /**
     * If the meaning of "IMAGE_FILE_ERROR" isn't clear, then there should be a description here.
     */
    serverResult__IMAGE_FILE_ERROR,
    /**
     * If the meaning of "PROFILE_BLOCKED" isn't clear, then there should be a description here.
     */
    serverResult__PROFILE_BLOCKED,
    /**
     * If the meaning of "DENIED_DELAYED" isn't clear, then there should be a description here.
     */
    serverResult__DENIED_DELAYED,
    /**
     * If the meaning of "DENIED_WAITING" isn't clear, then there should be a description here.
     */
    serverResult__DENIED_WAITING,
    /**
     * If the meaning of "CANCELLED" isn't clear, then there should be a description here.
     */
    serverResult__CANCELLED

};

bool serverResult_Parse (const char *str, size_t length, serverResult &value);

const char* serverResult_Name (serverResult value);

bool serverResult_IsValid (serverResult value);

/**
 * If the meaning of "clientResult" isn't clear, then there should be a description here.
 */
enum clientResult {

    /**
     * If the meaning of "SUCCESS" isn't clear, then there should be a description here.
     */
    clientResult__SUCCESS,
    /**
     * If the meaning of "FAILED" isn't clear, then there should be a description here.
     */
    clientResult__FAILED

};

bool clientResult_Parse (const char *str, size_t length, clientResult &value);

const char* clientResult_Name (clientResult value);

bool clientResult_IsValid (clientResult value);

/**
 * If the meaning of "dataChangedResult" isn't clear, then there should be a description here.
 */
enum dataChangedResult {

    /**
     * If the meaning of "PREPARED" isn't clear, then there should be a description here.
     */
    dataChangedResult__PREPARED,
    /**
     * If the meaning of "PROFILE_CHANGED" isn't clear, then there should be a description here.
     */
    dataChangedResult__PROFILE_CHANGED,
    /**
     * If the meaning of "PROFILE_COPIED" isn't clear, then there should be a description here.
     */
    dataChangedResult__PROFILE_COPIED,
    /**
     * If the meaning of "PROFILE_DELETED" isn't clear, then there should be a description here.
     */
    dataChangedResult__PROFILE_DELETED,
    /**
     * If the meaning of "FAILED" isn't clear, then there should be a description here.
     */
    dataChangedResult__FAILED

};

bool dataChangedResult_Parse (const char *str, size_t length, dataChangedResult &value);

const char* dataChangedResult_Name (dataChangedResult value);

bool dataChangedResult_IsValid (dataChangedResult value);

/**
 * If the meaning of "dataChangeReason" isn't clear, then there should be a description here.
 */
enum dataChangeReason {

    /**
     * If the meaning of "IDLE" isn't clear, then there should be a description here.
     */
    dataChangeReason__IDLE,
    /**
     * If the meaning of "PROFILE_RESET" isn't clear, then there should be a description here.
     */
    dataChangeReason__PROFILE_RESET,
    /**
     * If the meaning of "PROFILE_CHANGED" isn't clear, then there should be a description here.
     */
    dataChangeReason__PROFILE_CHANGED,
    /**
     * If the meaning of "DOWNLOAD" isn't clear, then there should be a description here.
     */
    dataChangeReason__DOWNLOAD,
    /**
     * If the meaning of "PREPARE" isn't clear, then there should be a description here.
     */
    dataChangeReason__PREPARE

};

bool dataChangeReason_Parse (const char *str, size_t length, dataChangeReason &value);

const char* dataChangeReason_Name (dataChangeReason value);

bool dataChangeReason_IsValid (dataChangeReason value);

/**
 * If the meaning of "profileType" isn't clear, then there should be a description here.
 */
enum profileType {

    /**
     * Empty User Profile
     */
    profileType__EMPTY,
    /**
     * Guest User Profile
     */
    profileType__GUEST,
    /**
     * Normal User Profile
     */
    profileType__NORMAL,
    /**
     * Protected by any type of security method
     */
    profileType__PROTECTED,
    /**
     * Linked to vNext & Protected by Remember me
     */
    profileType__LINKED,
    /**
     * Profile is Blocked due to invalid credentials used
     */
    profileType__BLOCKED,
    /**
     * Profile is linked to vNext and protected by a PIN
     */
    profileType__LINKED_PIN

};

bool profileType_Parse (const char *str, size_t length, profileType &value);

const char* profileType_Name (profileType value);

bool profileType_IsValid (profileType value);

} // namespace profile
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_PROFILECONST_H
