/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "bosch/cm/profileConst.h"
#include <cstddef>

/**
 * basic attributes for User Profile Management
 */

using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

bool ProfileStatus_Parse (const char *str, size_t length, ProfileStatus &value)
{
    static stringEntry entries[] = {
        {6,"LOCKED", 1U},
        {7,"LOADING", 2U},
        {8,"UNLOCKED", 0U},
        {10,"VALET_MODE", 4U},
        {12,"INITIALIZING", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* ProfileStatus_Name (ProfileStatus value)
{
    static const char* enumerationLiterals[] = {
        "UNLOCKED",
        "LOCKED",
        "LOADING",
        "INITIALIZING",
        "VALET_MODE",
    };

    if (ProfileStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool ProfileStatus_IsValid (ProfileStatus value)
{
    switch (value) {
    case ProfileStatus__UNLOCKED:
    case ProfileStatus__LOCKED:
    case ProfileStatus__LOADING:
    case ProfileStatus__INITIALIZING:
    case ProfileStatus__VALET_MODE:
        return true;
    default:
        return false;
    }
}

bool serverResult_Parse (const char *str, size_t length, serverResult &value)
{
    static stringEntry entries[] = {
        {6,"FAILED", 2U},
        {7,"ONGOING", 1U},
        {7,"SUCCESS", 0U},
        {9,"CANCELLED", 10U},
        {11,"INTIALIZING", 3U},
        {13,"ACCESS_DENIED", 5U},
        {14,"DENIED_DELAYED", 8U},
        {14,"DENIED_WAITING", 9U},
        {15,"PROFILE_BLOCKED", 7U},
        {15,"WRONG_PARAMETER", 4U},
        {16,"IMAGE_FILE_ERROR", 6U},
    };

    return lookupInStringEntryTable (str, length, entries, 11, (unsigned int&) value);
}

const char* serverResult_Name (serverResult value)
{
    static const char* enumerationLiterals[] = {
        "SUCCESS",
        "ONGOING",
        "FAILED",
        "INTIALIZING",
        "WRONG_PARAMETER",
        "ACCESS_DENIED",
        "IMAGE_FILE_ERROR",
        "PROFILE_BLOCKED",
        "DENIED_DELAYED",
        "DENIED_WAITING",
        "CANCELLED",
    };

    if (serverResult_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool serverResult_IsValid (serverResult value)
{
    switch (value) {
    case serverResult__SUCCESS:
    case serverResult__ONGOING:
    case serverResult__FAILED:
    case serverResult__INTIALIZING:
    case serverResult__WRONG_PARAMETER:
    case serverResult__ACCESS_DENIED:
    case serverResult__IMAGE_FILE_ERROR:
    case serverResult__PROFILE_BLOCKED:
    case serverResult__DENIED_DELAYED:
    case serverResult__DENIED_WAITING:
    case serverResult__CANCELLED:
        return true;
    default:
        return false;
    }
}

bool clientResult_Parse (const char *str, size_t length, clientResult &value)
{
    static stringEntry entries[] = {
        {6,"FAILED", 1U},
        {7,"SUCCESS", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* clientResult_Name (clientResult value)
{
    static const char* enumerationLiterals[] = {
        "SUCCESS",
        "FAILED",
    };

    if (clientResult_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool clientResult_IsValid (clientResult value)
{
    switch (value) {
    case clientResult__SUCCESS:
    case clientResult__FAILED:
        return true;
    default:
        return false;
    }
}

bool dataChangedResult_Parse (const char *str, size_t length, dataChangedResult &value)
{
    static stringEntry entries[] = {
        {6,"FAILED", 4U},
        {8,"PREPARED", 0U},
        {14,"PROFILE_COPIED", 2U},
        {15,"PROFILE_CHANGED", 1U},
        {15,"PROFILE_DELETED", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* dataChangedResult_Name (dataChangedResult value)
{
    static const char* enumerationLiterals[] = {
        "PREPARED",
        "PROFILE_CHANGED",
        "PROFILE_COPIED",
        "PROFILE_DELETED",
        "FAILED",
    };

    if (dataChangedResult_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool dataChangedResult_IsValid (dataChangedResult value)
{
    switch (value) {
    case dataChangedResult__PREPARED:
    case dataChangedResult__PROFILE_CHANGED:
    case dataChangedResult__PROFILE_COPIED:
    case dataChangedResult__PROFILE_DELETED:
    case dataChangedResult__FAILED:
        return true;
    default:
        return false;
    }
}

bool dataChangeReason_Parse (const char *str, size_t length, dataChangeReason &value)
{
    static stringEntry entries[] = {
        {4,"IDLE", 0U},
        {7,"PREPARE", 4U},
        {8,"DOWNLOAD", 3U},
        {13,"PROFILE_RESET", 1U},
        {15,"PROFILE_CHANGED", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* dataChangeReason_Name (dataChangeReason value)
{
    static const char* enumerationLiterals[] = {
        "IDLE",
        "PROFILE_RESET",
        "PROFILE_CHANGED",
        "DOWNLOAD",
        "PREPARE",
    };

    if (dataChangeReason_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool dataChangeReason_IsValid (dataChangeReason value)
{
    switch (value) {
    case dataChangeReason__IDLE:
    case dataChangeReason__PROFILE_RESET:
    case dataChangeReason__PROFILE_CHANGED:
    case dataChangeReason__DOWNLOAD:
    case dataChangeReason__PREPARE:
        return true;
    default:
        return false;
    }
}

bool profileType_Parse (const char *str, size_t length, profileType &value)
{
    static stringEntry entries[] = {
        {5,"EMPTY", 0U},
        {5,"GUEST", 1U},
        {6,"LINKED", 4U},
        {6,"NORMAL", 2U},
        {7,"BLOCKED", 5U},
        {9,"PROTECTED", 3U},
        {10,"LINKED_PIN", 6U},
    };

    return lookupInStringEntryTable (str, length, entries, 7, (unsigned int&) value);
}

const char* profileType_Name (profileType value)
{
    static const char* enumerationLiterals[] = {
        "EMPTY",
        "GUEST",
        "NORMAL",
        "PROTECTED",
        "LINKED",
        "BLOCKED",
        "LINKED_PIN",
    };

    if (profileType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool profileType_IsValid (profileType value)
{
    switch (value) {
    case profileType__EMPTY:
    case profileType__GUEST:
    case profileType__NORMAL:
    case profileType__PROTECTED:
    case profileType__LINKED:
    case profileType__BLOCKED:
    case profileType__LINKED_PIN:
        return true;
    default:
        return false;
    }
}

} // namespace profile
} // namespace cm
} // namespace bosch
