#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_PROFILE_H
#define BOSCH_CM_PROFILE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "bosch/cm/profileConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * basic attributes for User Profile Management
 */

namespace bosch {
namespace cm {
namespace profile {

// method IDs
static const uint16 ID_doRegisterApp = 0;
static const uint16 ID_onDataChanged = 1;
static const uint16 ID_onProfileDeleted = 2;
static const uint16 ID_onProfileCopied = 3;
static const uint16 ID_onProfileCreated = 4;
static const uint16 ID_doCopyProfile = 5;
static const uint16 ID_doDeleteProfile = 6;
static const uint16 ID_doChangeToProfile = 7;
static const uint16 ID_doCreateProfile = 8;
static const uint16 ID_do_SetProfileName = 9;
static const uint16 ID_getProfileNames = 10;
static const uint16 ID_doImportProfileImage = 11;
static const uint16 ID_removeUserImage = 12;
static const uint16 ID_doSetProfileImage = 13;
static const uint16 ID_getProfileImages = 14;
static const uint16 ID_getProfileTypes = 15;
static const uint16 ID_setProfilePin = 16;
static const uint16 ID_setRememberMe = 17;
static const uint16 ID_checkPin = 18;
static const uint16 ID_unProtectProfile = 19;
static const uint16 ID_linkProfile = 20;
static const uint16 ID_setValetMode = 21;

// signal IDs

// property IDs
static const uint16 ID_activeProfile = 22;
static const uint16 ID_status = 23;
static const uint16 ID_copyProfile = 24;
static const uint16 ID_deleteProfile = 25;
static const uint16 ID_dataChanged = 26;
static const uint16 ID_createProfile = 27;
static const uint16 ID_privacyMode = 28;
static const uint16 ID_profileName = 29;
static const uint16 ID_profileImage = 30;
static const uint16 ID_pinRequested = 31;
static const uint16 ID_maxPINAttempts = 32;
static const uint16 ID_maxPINAttemptsBeforeDelay = 33;
static const uint16 ID_pinAuthenticationDelayTime = 34;
static const uint16 ID_pinVerificationValidityTime = 35;
static const uint16 ID_activeProfileType = 36;

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 1;

static const int VERSION_PATCH = 0;

// forward declarations
class copyInfo;

class DoRegisterAppRequest;

class DoRegisterAppResponse;

class OnDataChangedRequest;

class OnProfileDeletedRequest;

class OnProfileCopiedRequest;

class OnProfileCreatedRequest;

class DoCopyProfileRequest;

class DoCopyProfileResponse;

class DoDeleteProfileRequest;

class DoDeleteProfileResponse;

class DoChangeToProfileRequest;

class DoChangeToProfileResponse;

class DoCreateProfileRequest;

class DoCreateProfileResponse;

class Do_SetProfileNameRequest;

class Do_SetProfileNameResponse;

class GetProfileNamesResponse;

class DoImportProfileImageRequest;

class DoImportProfileImageResponse;

class RemoveUserImageRequest;

class RemoveUserImageResponse;

class DoSetProfileImageRequest;

class DoSetProfileImageResponse;

class GetProfileImagesResponse;

class GetProfileTypesResponse;

class SetProfilePinRequest;

class SetProfilePinResponse;

class SetRememberMeRequest;

class SetRememberMeResponse;

class CheckPinRequest;

class CheckPinResponse;

class UnProtectProfileRequest;

class UnProtectProfileResponse;

class LinkProfileRequest;

class LinkProfileResponse;

class SetValetModeRequest;

class SetValetModeResponse;

class ActiveProfileUpdate;

class ActiveProfileRegister;

class StatusUpdate;

class StatusRegister;

class CopyProfileUpdate;

class CopyProfileRegister;

class DeleteProfileUpdate;

class DeleteProfileRegister;

class DataChangedUpdate;

class DataChangedRegister;

class CreateProfileUpdate;

class CreateProfileRegister;

class PrivacyModeUpdate;

class PrivacyModeRegister;

class ProfileNameUpdate;

class ProfileNameRegister;

class ProfileImageUpdate;

class ProfileImageRegister;

class PinRequestedUpdate;

class PinRequestedRegister;

class MaxPINAttemptsUpdate;

class MaxPINAttemptsRegister;

class MaxPINAttemptsBeforeDelayUpdate;

class MaxPINAttemptsBeforeDelayRegister;

class PinAuthenticationDelayTimeUpdate;

class PinAuthenticationDelayTimeRegister;

class PinVerificationValidityTimeUpdate;

class PinVerificationValidityTimeRegister;

class ActiveProfileTypeUpdate;

class ActiveProfileTypeRegister;

// type definitions
/**
 * If the meaning of "DoRegisterAppError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DoRegisterAppError;

/**
 * Function to be called after user change has been done. User change is triggered by activeProfile Property update
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage OnDataChangedResponse;

/**
 * If the meaning of "OnDataChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError OnDataChangedError;

/**
 * Function to be called after user has been deleted. User deleteion is triggered by deleteProfile Property update
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage OnProfileDeletedResponse;

/**
 * If the meaning of "OnProfileDeletedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError OnProfileDeletedError;

/**
 * function to be called by the clients after Profile copy action triggered by copyProfile property update has been executed
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage OnProfileCopiedResponse;

/**
 * If the meaning of "OnProfileCopiedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError OnProfileCopiedError;

/**
 * function to be called by the clients after Profile create action triggered by createProfile property update has been executed
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage OnProfileCreatedResponse;

/**
 * If the meaning of "OnProfileCreatedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError OnProfileCreatedError;

/**
 * If the meaning of "DoCopyProfileError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DoCopyProfileError;

/**
 * If the meaning of "DoDeleteProfileError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DoDeleteProfileError;

/**
 * If the meaning of "DoChangeToProfileError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DoChangeToProfileError;

/**
 * If the meaning of "DoCreateProfileError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DoCreateProfileError;

/**
 * If the meaning of "Do_SetProfileNameError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Do_SetProfileNameError;

/**
 * gets all profile names
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetProfileNamesRequest;

/**
 * If the meaning of "GetProfileNamesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetProfileNamesError;

/**
 * If the meaning of "DoImportProfileImageError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DoImportProfileImageError;

/**
 * If the meaning of "RemoveUserImageError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RemoveUserImageError;

/**
 * If the meaning of "DoSetProfileImageError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DoSetProfileImageError;

/**
 * gets all profile images
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetProfileImagesRequest;

/**
 * If the meaning of "GetProfileImagesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetProfileImagesError;

/**
 * gets all profile types
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetProfileTypesRequest;

/**
 * If the meaning of "GetProfileTypesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetProfileTypesError;

/**
 * If the meaning of "SetProfilePinError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetProfilePinError;

/**
 * If the meaning of "SetRememberMeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetRememberMeError;

/**
 * If the meaning of "CheckPinError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CheckPinError;

/**
 * If the meaning of "UnProtectProfileError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnProtectProfileError;

/**
 * If the meaning of "LinkProfileError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LinkProfileError;

/**
 * If the meaning of "SetValetModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetValetModeError;

/**
 * current user Profile. Updated only on user change.
 */
typedef ActiveProfileUpdate ActiveProfileSet;

/**
 * current user Profile. Updated only on user change.
 */
typedef ActiveProfileUpdate ActiveProfileGet;

/**
 * If the meaning of "ActiveProfileError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActiveProfileError;

/**
 * If the meaning of "status" isn't clear, then there should be a description here.
 */
typedef StatusUpdate StatusSet;

/**
 * If the meaning of "status" isn't clear, then there should be a description here.
 */
typedef StatusUpdate StatusGet;

/**
 * If the meaning of "StatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StatusError;

/**
 * If the meaning of "copyProfile" isn't clear, then there should be a description here.
 */
typedef CopyProfileUpdate CopyProfileSet;

/**
 * If the meaning of "copyProfile" isn't clear, then there should be a description here.
 */
typedef CopyProfileUpdate CopyProfileGet;

/**
 * If the meaning of "CopyProfileError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CopyProfileError;

/**
 * Profile is to be Deleted (values to be overwritten with Default values)
 */
typedef DeleteProfileUpdate DeleteProfileSet;

/**
 * Profile is to be Deleted (values to be overwritten with Default values)
 */
typedef DeleteProfileUpdate DeleteProfileGet;

/**
 * If the meaning of "DeleteProfileError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DeleteProfileError;

/**
 * Download marker will be set to true, if upload / downlaod is in progress Application should not accept value changes, while this attribute is true
 */
typedef DataChangedUpdate DataChangedSet;

/**
 * Download marker will be set to true, if upload / downlaod is in progress Application should not accept value changes, while this attribute is true
 */
typedef DataChangedUpdate DataChangedGet;

/**
 * If the meaning of "DataChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DataChangedError;

/**
 * New Profile to be created(values to be overwritten with Default values)
 */
typedef CreateProfileUpdate CreateProfileSet;

/**
 * New Profile to be created(values to be overwritten with Default values)
 */
typedef CreateProfileUpdate CreateProfileGet;

/**
 * If the meaning of "CreateProfileError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CreateProfileError;

/**
 * Privacy mode flag for scope 2.1 treated as one boolean, for 3.0 as 32 booleans (0: privacy mode off, 1:Privacy mode On)
 */
typedef PrivacyModeUpdate PrivacyModeSet;

/**
 * Privacy mode flag for scope 2.1 treated as one boolean, for 3.0 as 32 booleans (0: privacy mode off, 1:Privacy mode On)
 */
typedef PrivacyModeUpdate PrivacyModeGet;

/**
 * If the meaning of "PrivacyModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PrivacyModeError;

/**
 * Profile names for current profile con be changed with this attribute
 */
typedef ProfileNameUpdate ProfileNameSet;

/**
 * Profile names for current profile con be changed with this attribute
 */
typedef ProfileNameUpdate ProfileNameGet;

/**
 * If the meaning of "ProfileNameError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ProfileNameError;

/**
 * Profile names for current profile con be changed with this attribute
 */
typedef ProfileImageUpdate ProfileImageSet;

/**
 * Profile names for current profile con be changed with this attribute
 */
typedef ProfileImageUpdate ProfileImageGet;

/**
 * If the meaning of "ProfileImageError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ProfileImageError;

/**
 * checkPin  call requested, to finish ongoing user action (e.g. change User
 */
typedef PinRequestedUpdate PinRequestedSet;

/**
 * checkPin  call requested, to finish ongoing user action (e.g. change User
 */
typedef PinRequestedUpdate PinRequestedGet;

/**
 * If the meaning of "PinRequestedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PinRequestedError;

/**
 * Max PIN attempts allowed
 */
typedef MaxPINAttemptsUpdate MaxPINAttemptsSet;

/**
 * Max PIN attempts allowed
 */
typedef MaxPINAttemptsUpdate MaxPINAttemptsGet;

/**
 * If the meaning of "MaxPINAttemptsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MaxPINAttemptsError;

/**
 * Maximum PIN Attempts before Delay
 */
typedef MaxPINAttemptsBeforeDelayUpdate MaxPINAttemptsBeforeDelaySet;

/**
 * Maximum PIN Attempts before Delay
 */
typedef MaxPINAttemptsBeforeDelayUpdate MaxPINAttemptsBeforeDelayGet;

/**
 * If the meaning of "MaxPINAttemptsBeforeDelayError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MaxPINAttemptsBeforeDelayError;

/**
 * PIN Autherntication Delay in milliseconds
 */
typedef PinAuthenticationDelayTimeUpdate PinAuthenticationDelayTimeSet;

/**
 * PIN Autherntication Delay in milliseconds
 */
typedef PinAuthenticationDelayTimeUpdate PinAuthenticationDelayTimeGet;

/**
 * If the meaning of "PinAuthenticationDelayTimeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PinAuthenticationDelayTimeError;

/**
 * PINVerificationValidityTime in milliseconds
 */
typedef PinVerificationValidityTimeUpdate PinVerificationValidityTimeSet;

/**
 * PINVerificationValidityTime in milliseconds
 */
typedef PinVerificationValidityTimeUpdate PinVerificationValidityTimeGet;

/**
 * If the meaning of "PinVerificationValidityTimeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PinVerificationValidityTimeError;

/**
 * Current Active User Profile Type
 */
typedef ActiveProfileTypeUpdate ActiveProfileTypeSet;

/**
 * Current Active User Profile Type
 */
typedef ActiveProfileTypeUpdate ActiveProfileTypeGet;

/**
 * If the meaning of "ActiveProfileTypeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActiveProfileTypeError;


/**
 * If the meaning of "copyInfo" isn't clear, then there should be a description here.
 */
class copyInfo {
public:

    /**
     * Default constructor
     */
    inline  copyInfo ();

    /**
     * Copy constructor
     */
    inline  copyInfo (const copyInfo &rhs);

    /**
     * All fields constructor
     */
    inline  copyInfo (uint8 source_, uint8 destination_);

    /**
     * Destructor
     */
    inline  ~copyInfo();

    /**
     * Assignment operator
     */
    inline copyInfo& operator = (const copyInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const copyInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const copyInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const copyInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const copyInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "source"

    static const int kSource = 0;

    /**
     * Clears the field "source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @return The value of the field "source"
     */
    inline uint8 getSource () const;

    /**
     * Sets the value of the member "source".
     *
     * If the meaning of "source" isn't clear, then there should be a description here.
     *
     * @param source The value which will be set
     */
    inline void setSource (uint8 source_);

    // API of field "destination"

    static const int kDestination = 1;

    /**
     * Clears the field "destination".
     *
     * The field will be set to its default value. The hasDestination()
     * method will return false.
     */
    inline void clearDestination();

    /**
     * Checks whether the field "destination" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestination()). Otherwise it will return false.
     */
    inline bool hasDestination () const;

    /**
     * Returns the value of the member "destination".
     *
     * If the meaning of "destination" isn't clear, then there should be a description here.
     *
     * @return The value of the field "destination"
     */
    inline uint8 getDestination () const;

    /**
     * Sets the value of the member "destination".
     *
     * If the meaning of "destination" isn't clear, then there should be a description here.
     *
     * @param destination The value which will be set
     */
    inline void setDestination (uint8 destination_);

    static const copyInfo &getDefaultInstance();

private:

    inline void set_has_source ();

    inline void clear_has_source ();

    inline void set_has_destination ();

    inline void clear_has_destination ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _source;

    uint8 _destination;

};

/**
 * Each Application, that stores Profile Data has to register here.
 *    The application has to store the AppID returned by RegisterApp and uset it for all other calls to the Profile Manager
 */
class DoRegisterAppRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoRegisterAppRequest ();

    /**
     * Copy constructor
     */
    inline  DoRegisterAppRequest (const DoRegisterAppRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DoRegisterAppRequest (const ::std::string& AppName_);

    /**
     * Destructor
     */
    inline virtual  ~DoRegisterAppRequest();

    /**
     * Assignment operator
     */
    inline DoRegisterAppRequest& operator = (const DoRegisterAppRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoRegisterAppRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoRegisterAppRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoRegisterAppRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoRegisterAppRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AppName"

    static const int kAppName = 0;

    /**
     * Clears the field "AppName".
     *
     * The field will be set to its default value. The hasAppName()
     * method will return false.
     */
    inline void clearAppName();

    /**
     * Checks whether the field "AppName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppName()). Otherwise it will return false.
     */
    inline bool hasAppName () const;

    /**
     * Returns the value of the member "AppName".
     *
     * If the meaning of "AppName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AppName"
     */
    inline const ::std::string& getAppName () const;

    /**
     * Retrieves the value of the field "AppName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AppName".
     */
    inline ::std::string& getAppNameMutable ();

    /**
     * Sets the value of the member "AppName".
     *
     * If the meaning of "AppName" isn't clear, then there should be a description here.
     *
     * @param AppName The value which will be set
     */
    inline void setAppName (const ::std::string& AppName_);

    /**
     * Sets the value of the member "AppName".
     *
     * If the meaning of "AppName" isn't clear, then there should be a description here.
     *
     * @param AppName The value which will be set
     */
    inline void setAppName (const char* AppName_);

    /**
     * Sets the value of the member "AppName".
     *
     * If the meaning of "AppName" isn't clear, then there should be a description here.
     *
     * @param AppName The value which will be set
     */
    inline void setAppName (const char* value, size_t size);

    static const DoRegisterAppRequest &getDefaultInstance();

private:

    inline void set_has_AppName ();

    inline void clear_has_AppName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _AppName;

};

/**
 * Each Application, that stores Profile Data has to register here.
 *    The application has to store the AppID returned by RegisterApp and uset it for all other calls to the Profile Manager
 */
class DoRegisterAppResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoRegisterAppResponse ();

    /**
     * Copy constructor
     */
    inline  DoRegisterAppResponse (const DoRegisterAppResponse &rhs);

    /**
     * All fields constructor
     */
    inline  DoRegisterAppResponse (uint32 AppID_, const ::std::string& ApplName_, bool reloadData_);

    /**
     * Destructor
     */
    inline virtual  ~DoRegisterAppResponse();

    /**
     * Assignment operator
     */
    inline DoRegisterAppResponse& operator = (const DoRegisterAppResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoRegisterAppResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoRegisterAppResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoRegisterAppResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoRegisterAppResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AppID"

    static const int kAppID = 0;

    /**
     * Clears the field "AppID".
     *
     * The field will be set to its default value. The hasAppID()
     * method will return false.
     */
    inline void clearAppID();

    /**
     * Checks whether the field "AppID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppID()). Otherwise it will return false.
     */
    inline bool hasAppID () const;

    /**
     * Returns the value of the member "AppID".
     *
     * If the meaning of "AppID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AppID"
     */
    inline uint32 getAppID () const;

    /**
     * Sets the value of the member "AppID".
     *
     * If the meaning of "AppID" isn't clear, then there should be a description here.
     *
     * @param AppID The value which will be set
     */
    inline void setAppID (uint32 AppID_);

    // API of field "ApplName"

    static const int kApplName = 1;

    /**
     * Clears the field "ApplName".
     *
     * The field will be set to its default value. The hasApplName()
     * method will return false.
     */
    inline void clearApplName();

    /**
     * Checks whether the field "ApplName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setApplName()). Otherwise it will return false.
     */
    inline bool hasApplName () const;

    /**
     * Returns the value of the member "ApplName".
     *
     * If the meaning of "ApplName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ApplName"
     */
    inline const ::std::string& getApplName () const;

    /**
     * Retrieves the value of the field "ApplName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ApplName".
     */
    inline ::std::string& getApplNameMutable ();

    /**
     * Sets the value of the member "ApplName".
     *
     * If the meaning of "ApplName" isn't clear, then there should be a description here.
     *
     * @param ApplName The value which will be set
     */
    inline void setApplName (const ::std::string& ApplName_);

    /**
     * Sets the value of the member "ApplName".
     *
     * If the meaning of "ApplName" isn't clear, then there should be a description here.
     *
     * @param ApplName The value which will be set
     */
    inline void setApplName (const char* ApplName_);

    /**
     * Sets the value of the member "ApplName".
     *
     * If the meaning of "ApplName" isn't clear, then there should be a description here.
     *
     * @param ApplName The value which will be set
     */
    inline void setApplName (const char* value, size_t size);

    // API of field "reloadData"

    static const int kReloadData = 2;

    /**
     * Clears the field "reloadData".
     *
     * The field will be set to its default value. The hasReloadData()
     * method will return false.
     */
    inline void clearReloadData();

    /**
     * Checks whether the field "reloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReloadData()). Otherwise it will return false.
     */
    inline bool hasReloadData () const;

    /**
     * Returns the value of the member "reloadData".
     *
     * If the meaning of "reloadData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "reloadData"
     */
    inline bool getReloadData () const;

    /**
     * Sets the value of the member "reloadData".
     *
     * If the meaning of "reloadData" isn't clear, then there should be a description here.
     *
     * @param reloadData The value which will be set
     */
    inline void setReloadData (bool reloadData_);

    static const DoRegisterAppResponse &getDefaultInstance();

private:

    inline void set_has_AppID ();

    inline void clear_has_AppID ();

    inline void set_has_ApplName ();

    inline void clear_has_ApplName ();

    inline void set_has_reloadData ();

    inline void clear_has_reloadData ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _AppID;

    ::std::string _ApplName;

    bool _reloadData;

};

/**
 * Function to be called after user change has been done. User change is triggered by activeProfile Property update
 */
class OnDataChangedRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnDataChangedRequest ();

    /**
     * Copy constructor
     */
    inline  OnDataChangedRequest (const OnDataChangedRequest &rhs);

    /**
     * All fields constructor
     */
    inline  OnDataChangedRequest (uint32 ApplicationPID_, dataChangedResult Result_);

    /**
     * Destructor
     */
    inline virtual  ~OnDataChangedRequest();

    /**
     * Assignment operator
     */
    inline OnDataChangedRequest& operator = (const OnDataChangedRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnDataChangedRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnDataChangedRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnDataChangedRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnDataChangedRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ApplicationPID"

    static const int kApplicationPID = 0;

    /**
     * Clears the field "ApplicationPID".
     *
     * The field will be set to its default value. The hasApplicationPID()
     * method will return false.
     */
    inline void clearApplicationPID();

    /**
     * Checks whether the field "ApplicationPID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setApplicationPID()). Otherwise it will return false.
     */
    inline bool hasApplicationPID () const;

    /**
     * Returns the value of the member "ApplicationPID".
     *
     * If the meaning of "ApplicationPID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ApplicationPID"
     */
    inline uint32 getApplicationPID () const;

    /**
     * Sets the value of the member "ApplicationPID".
     *
     * If the meaning of "ApplicationPID" isn't clear, then there should be a description here.
     *
     * @param ApplicationPID The value which will be set
     */
    inline void setApplicationPID (uint32 ApplicationPID_);

    // API of field "Result"

    static const int kResult = 1;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline dataChangedResult getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (dataChangedResult Result_);

    static const OnDataChangedRequest &getDefaultInstance();

private:

    inline void set_has_ApplicationPID ();

    inline void clear_has_ApplicationPID ();

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _ApplicationPID;

    dataChangedResult _Result;

};

/**
 * Function to be called after user has been deleted. User deleteion is triggered by deleteProfile Property update
 */
class OnProfileDeletedRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnProfileDeletedRequest ();

    /**
     * Copy constructor
     */
    inline  OnProfileDeletedRequest (const OnProfileDeletedRequest &rhs);

    /**
     * All fields constructor
     */
    inline  OnProfileDeletedRequest (uint32 ApplicationPID_, clientResult Result_);

    /**
     * Destructor
     */
    inline virtual  ~OnProfileDeletedRequest();

    /**
     * Assignment operator
     */
    inline OnProfileDeletedRequest& operator = (const OnProfileDeletedRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnProfileDeletedRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnProfileDeletedRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnProfileDeletedRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnProfileDeletedRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ApplicationPID"

    static const int kApplicationPID = 0;

    /**
     * Clears the field "ApplicationPID".
     *
     * The field will be set to its default value. The hasApplicationPID()
     * method will return false.
     */
    inline void clearApplicationPID();

    /**
     * Checks whether the field "ApplicationPID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setApplicationPID()). Otherwise it will return false.
     */
    inline bool hasApplicationPID () const;

    /**
     * Returns the value of the member "ApplicationPID".
     *
     * If the meaning of "ApplicationPID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ApplicationPID"
     */
    inline uint32 getApplicationPID () const;

    /**
     * Sets the value of the member "ApplicationPID".
     *
     * If the meaning of "ApplicationPID" isn't clear, then there should be a description here.
     *
     * @param ApplicationPID The value which will be set
     */
    inline void setApplicationPID (uint32 ApplicationPID_);

    // API of field "Result"

    static const int kResult = 1;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline clientResult getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (clientResult Result_);

    static const OnProfileDeletedRequest &getDefaultInstance();

private:

    inline void set_has_ApplicationPID ();

    inline void clear_has_ApplicationPID ();

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _ApplicationPID;

    clientResult _Result;

};

/**
 * function to be called by the clients after Profile copy action triggered by copyProfile property update has been executed
 */
class OnProfileCopiedRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnProfileCopiedRequest ();

    /**
     * Copy constructor
     */
    inline  OnProfileCopiedRequest (const OnProfileCopiedRequest &rhs);

    /**
     * All fields constructor
     */
    inline  OnProfileCopiedRequest (uint32 ApplicationPID_, clientResult Result_);

    /**
     * Destructor
     */
    inline virtual  ~OnProfileCopiedRequest();

    /**
     * Assignment operator
     */
    inline OnProfileCopiedRequest& operator = (const OnProfileCopiedRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnProfileCopiedRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnProfileCopiedRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnProfileCopiedRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnProfileCopiedRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ApplicationPID"

    static const int kApplicationPID = 0;

    /**
     * Clears the field "ApplicationPID".
     *
     * The field will be set to its default value. The hasApplicationPID()
     * method will return false.
     */
    inline void clearApplicationPID();

    /**
     * Checks whether the field "ApplicationPID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setApplicationPID()). Otherwise it will return false.
     */
    inline bool hasApplicationPID () const;

    /**
     * Returns the value of the member "ApplicationPID".
     *
     * If the meaning of "ApplicationPID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ApplicationPID"
     */
    inline uint32 getApplicationPID () const;

    /**
     * Sets the value of the member "ApplicationPID".
     *
     * If the meaning of "ApplicationPID" isn't clear, then there should be a description here.
     *
     * @param ApplicationPID The value which will be set
     */
    inline void setApplicationPID (uint32 ApplicationPID_);

    // API of field "Result"

    static const int kResult = 1;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline clientResult getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (clientResult Result_);

    static const OnProfileCopiedRequest &getDefaultInstance();

private:

    inline void set_has_ApplicationPID ();

    inline void clear_has_ApplicationPID ();

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _ApplicationPID;

    clientResult _Result;

};

/**
 * function to be called by the clients after Profile create action triggered by createProfile property update has been executed
 */
class OnProfileCreatedRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnProfileCreatedRequest ();

    /**
     * Copy constructor
     */
    inline  OnProfileCreatedRequest (const OnProfileCreatedRequest &rhs);

    /**
     * All fields constructor
     */
    inline  OnProfileCreatedRequest (uint32 ApplicationPID_, clientResult Result_);

    /**
     * Destructor
     */
    inline virtual  ~OnProfileCreatedRequest();

    /**
     * Assignment operator
     */
    inline OnProfileCreatedRequest& operator = (const OnProfileCreatedRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnProfileCreatedRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnProfileCreatedRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnProfileCreatedRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnProfileCreatedRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ApplicationPID"

    static const int kApplicationPID = 0;

    /**
     * Clears the field "ApplicationPID".
     *
     * The field will be set to its default value. The hasApplicationPID()
     * method will return false.
     */
    inline void clearApplicationPID();

    /**
     * Checks whether the field "ApplicationPID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setApplicationPID()). Otherwise it will return false.
     */
    inline bool hasApplicationPID () const;

    /**
     * Returns the value of the member "ApplicationPID".
     *
     * If the meaning of "ApplicationPID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ApplicationPID"
     */
    inline uint32 getApplicationPID () const;

    /**
     * Sets the value of the member "ApplicationPID".
     *
     * If the meaning of "ApplicationPID" isn't clear, then there should be a description here.
     *
     * @param ApplicationPID The value which will be set
     */
    inline void setApplicationPID (uint32 ApplicationPID_);

    // API of field "Result"

    static const int kResult = 1;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline clientResult getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (clientResult Result_);

    static const OnProfileCreatedRequest &getDefaultInstance();

private:

    inline void set_has_ApplicationPID ();

    inline void clear_has_ApplicationPID ();

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _ApplicationPID;

    clientResult _Result;

};

/**
 * function to request a user copy from the Profile Manager
 */
class DoCopyProfileRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoCopyProfileRequest ();

    /**
     * Copy constructor
     */
    inline  DoCopyProfileRequest (const DoCopyProfileRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DoCopyProfileRequest (uint8 sourceUserID_, uint8 destUserID_);

    /**
     * Destructor
     */
    inline virtual  ~DoCopyProfileRequest();

    /**
     * Assignment operator
     */
    inline DoCopyProfileRequest& operator = (const DoCopyProfileRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoCopyProfileRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoCopyProfileRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoCopyProfileRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoCopyProfileRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sourceUserID"

    static const int kSourceUserID = 0;

    /**
     * Clears the field "sourceUserID".
     *
     * The field will be set to its default value. The hasSourceUserID()
     * method will return false.
     */
    inline void clearSourceUserID();

    /**
     * Checks whether the field "sourceUserID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceUserID()). Otherwise it will return false.
     */
    inline bool hasSourceUserID () const;

    /**
     * Returns the value of the member "sourceUserID".
     *
     * If the meaning of "sourceUserID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourceUserID"
     */
    inline uint8 getSourceUserID () const;

    /**
     * Sets the value of the member "sourceUserID".
     *
     * If the meaning of "sourceUserID" isn't clear, then there should be a description here.
     *
     * @param sourceUserID The value which will be set
     */
    inline void setSourceUserID (uint8 sourceUserID_);

    // API of field "destUserID"

    static const int kDestUserID = 1;

    /**
     * Clears the field "destUserID".
     *
     * The field will be set to its default value. The hasDestUserID()
     * method will return false.
     */
    inline void clearDestUserID();

    /**
     * Checks whether the field "destUserID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestUserID()). Otherwise it will return false.
     */
    inline bool hasDestUserID () const;

    /**
     * Returns the value of the member "destUserID".
     *
     * If the meaning of "destUserID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "destUserID"
     */
    inline uint8 getDestUserID () const;

    /**
     * Sets the value of the member "destUserID".
     *
     * If the meaning of "destUserID" isn't clear, then there should be a description here.
     *
     * @param destUserID The value which will be set
     */
    inline void setDestUserID (uint8 destUserID_);

    static const DoCopyProfileRequest &getDefaultInstance();

private:

    inline void set_has_sourceUserID ();

    inline void clear_has_sourceUserID ();

    inline void set_has_destUserID ();

    inline void clear_has_destUserID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _sourceUserID;

    uint8 _destUserID;

};

/**
 * function to request a user copy from the Profile Manager
 */
class DoCopyProfileResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoCopyProfileResponse ();

    /**
     * Copy constructor
     */
    inline  DoCopyProfileResponse (const DoCopyProfileResponse &rhs);

    /**
     * All fields constructor
     */
    inline  DoCopyProfileResponse (serverResult Result_);

    /**
     * Destructor
     */
    inline virtual  ~DoCopyProfileResponse();

    /**
     * Assignment operator
     */
    inline DoCopyProfileResponse& operator = (const DoCopyProfileResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoCopyProfileResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoCopyProfileResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoCopyProfileResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoCopyProfileResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline serverResult getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (serverResult Result_);

    static const DoCopyProfileResponse &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    serverResult _Result;

};

/**
 * function to delete a Profile
 */
class DoDeleteProfileRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoDeleteProfileRequest ();

    /**
     * Copy constructor
     */
    inline  DoDeleteProfileRequest (const DoDeleteProfileRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DoDeleteProfileRequest (uint8 userID_);

    /**
     * Destructor
     */
    inline virtual  ~DoDeleteProfileRequest();

    /**
     * Assignment operator
     */
    inline DoDeleteProfileRequest& operator = (const DoDeleteProfileRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoDeleteProfileRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoDeleteProfileRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoDeleteProfileRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoDeleteProfileRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "userID"

    static const int kUserID = 0;

    /**
     * Clears the field "userID".
     *
     * The field will be set to its default value. The hasUserID()
     * method will return false.
     */
    inline void clearUserID();

    /**
     * Checks whether the field "userID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserID()). Otherwise it will return false.
     */
    inline bool hasUserID () const;

    /**
     * Returns the value of the member "userID".
     *
     * If the meaning of "userID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "userID"
     */
    inline uint8 getUserID () const;

    /**
     * Sets the value of the member "userID".
     *
     * If the meaning of "userID" isn't clear, then there should be a description here.
     *
     * @param userID The value which will be set
     */
    inline void setUserID (uint8 userID_);

    static const DoDeleteProfileRequest &getDefaultInstance();

private:

    inline void set_has_userID ();

    inline void clear_has_userID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _userID;

};

/**
 * function to delete a Profile
 */
class DoDeleteProfileResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoDeleteProfileResponse ();

    /**
     * Copy constructor
     */
    inline  DoDeleteProfileResponse (const DoDeleteProfileResponse &rhs);

    /**
     * All fields constructor
     */
    inline  DoDeleteProfileResponse (serverResult Result_);

    /**
     * Destructor
     */
    inline virtual  ~DoDeleteProfileResponse();

    /**
     * Assignment operator
     */
    inline DoDeleteProfileResponse& operator = (const DoDeleteProfileResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoDeleteProfileResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoDeleteProfileResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoDeleteProfileResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoDeleteProfileResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline serverResult getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (serverResult Result_);

    static const DoDeleteProfileResponse &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    serverResult _Result;

};

/**
 * function to request a change of the current user from the Profile Manager
 */
class DoChangeToProfileRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoChangeToProfileRequest ();

    /**
     * Copy constructor
     */
    inline  DoChangeToProfileRequest (const DoChangeToProfileRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DoChangeToProfileRequest (uint8 userID_);

    /**
     * Destructor
     */
    inline virtual  ~DoChangeToProfileRequest();

    /**
     * Assignment operator
     */
    inline DoChangeToProfileRequest& operator = (const DoChangeToProfileRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoChangeToProfileRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoChangeToProfileRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoChangeToProfileRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoChangeToProfileRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "userID"

    static const int kUserID = 0;

    /**
     * Clears the field "userID".
     *
     * The field will be set to its default value. The hasUserID()
     * method will return false.
     */
    inline void clearUserID();

    /**
     * Checks whether the field "userID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserID()). Otherwise it will return false.
     */
    inline bool hasUserID () const;

    /**
     * Returns the value of the member "userID".
     *
     * If the meaning of "userID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "userID"
     */
    inline uint8 getUserID () const;

    /**
     * Sets the value of the member "userID".
     *
     * If the meaning of "userID" isn't clear, then there should be a description here.
     *
     * @param userID The value which will be set
     */
    inline void setUserID (uint8 userID_);

    static const DoChangeToProfileRequest &getDefaultInstance();

private:

    inline void set_has_userID ();

    inline void clear_has_userID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _userID;

};

/**
 * function to request a change of the current user from the Profile Manager
 */
class DoChangeToProfileResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoChangeToProfileResponse ();

    /**
     * Copy constructor
     */
    inline  DoChangeToProfileResponse (const DoChangeToProfileResponse &rhs);

    /**
     * All fields constructor
     */
    inline  DoChangeToProfileResponse (serverResult Result_);

    /**
     * Destructor
     */
    inline virtual  ~DoChangeToProfileResponse();

    /**
     * Assignment operator
     */
    inline DoChangeToProfileResponse& operator = (const DoChangeToProfileResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoChangeToProfileResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoChangeToProfileResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoChangeToProfileResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoChangeToProfileResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline serverResult getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (serverResult Result_);

    static const DoChangeToProfileResponse &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    serverResult _Result;

};

/**
 * function to request a creations of a new User Profile from the Profile Manager
 */
class DoCreateProfileRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoCreateProfileRequest ();

    /**
     * Copy constructor
     */
    inline  DoCreateProfileRequest (const DoCreateProfileRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DoCreateProfileRequest (const ::std::string& newName_, uint8 imageID_);

    /**
     * Destructor
     */
    inline virtual  ~DoCreateProfileRequest();

    /**
     * Assignment operator
     */
    inline DoCreateProfileRequest& operator = (const DoCreateProfileRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoCreateProfileRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoCreateProfileRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoCreateProfileRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoCreateProfileRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "newName"

    static const int kNewName = 0;

    /**
     * Clears the field "newName".
     *
     * The field will be set to its default value. The hasNewName()
     * method will return false.
     */
    inline void clearNewName();

    /**
     * Checks whether the field "newName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNewName()). Otherwise it will return false.
     */
    inline bool hasNewName () const;

    /**
     * Returns the value of the member "newName".
     *
     * If the meaning of "newName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "newName"
     */
    inline const ::std::string& getNewName () const;

    /**
     * Retrieves the value of the field "newName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "newName".
     */
    inline ::std::string& getNewNameMutable ();

    /**
     * Sets the value of the member "newName".
     *
     * If the meaning of "newName" isn't clear, then there should be a description here.
     *
     * @param newName The value which will be set
     */
    inline void setNewName (const ::std::string& newName_);

    /**
     * Sets the value of the member "newName".
     *
     * If the meaning of "newName" isn't clear, then there should be a description here.
     *
     * @param newName The value which will be set
     */
    inline void setNewName (const char* newName_);

    /**
     * Sets the value of the member "newName".
     *
     * If the meaning of "newName" isn't clear, then there should be a description here.
     *
     * @param newName The value which will be set
     */
    inline void setNewName (const char* value, size_t size);

    // API of field "imageID"

    static const int kImageID = 1;

    /**
     * Clears the field "imageID".
     *
     * The field will be set to its default value. The hasImageID()
     * method will return false.
     */
    inline void clearImageID();

    /**
     * Checks whether the field "imageID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImageID()). Otherwise it will return false.
     */
    inline bool hasImageID () const;

    /**
     * Returns the value of the member "imageID".
     *
     * If the meaning of "imageID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "imageID"
     */
    inline uint8 getImageID () const;

    /**
     * Sets the value of the member "imageID".
     *
     * If the meaning of "imageID" isn't clear, then there should be a description here.
     *
     * @param imageID The value which will be set
     */
    inline void setImageID (uint8 imageID_);

    static const DoCreateProfileRequest &getDefaultInstance();

private:

    inline void set_has_newName ();

    inline void clear_has_newName ();

    inline void set_has_imageID ();

    inline void clear_has_imageID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _newName;

    uint8 _imageID;

};

/**
 * function to request a creations of a new User Profile from the Profile Manager
 */
class DoCreateProfileResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoCreateProfileResponse ();

    /**
     * Copy constructor
     */
    inline  DoCreateProfileResponse (const DoCreateProfileResponse &rhs);

    /**
     * All fields constructor
     */
    inline  DoCreateProfileResponse (serverResult Result_, uint8 newUserID_);

    /**
     * Destructor
     */
    inline virtual  ~DoCreateProfileResponse();

    /**
     * Assignment operator
     */
    inline DoCreateProfileResponse& operator = (const DoCreateProfileResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoCreateProfileResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoCreateProfileResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoCreateProfileResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoCreateProfileResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline serverResult getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (serverResult Result_);

    // API of field "newUserID"

    static const int kNewUserID = 1;

    /**
     * Clears the field "newUserID".
     *
     * The field will be set to its default value. The hasNewUserID()
     * method will return false.
     */
    inline void clearNewUserID();

    /**
     * Checks whether the field "newUserID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNewUserID()). Otherwise it will return false.
     */
    inline bool hasNewUserID () const;

    /**
     * Returns the value of the member "newUserID".
     *
     * If the meaning of "newUserID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "newUserID"
     */
    inline uint8 getNewUserID () const;

    /**
     * Sets the value of the member "newUserID".
     *
     * If the meaning of "newUserID" isn't clear, then there should be a description here.
     *
     * @param newUserID The value which will be set
     */
    inline void setNewUserID (uint8 newUserID_);

    static const DoCreateProfileResponse &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    inline void set_has_newUserID ();

    inline void clear_has_newUserID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    serverResult _Result;

    uint8 _newUserID;

};

/**
 * sets the profile name for the current profile
 */
class Do_SetProfileNameRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Do_SetProfileNameRequest ();

    /**
     * Copy constructor
     */
    inline  Do_SetProfileNameRequest (const Do_SetProfileNameRequest &rhs);

    /**
     * All fields constructor
     */
    inline  Do_SetProfileNameRequest (const ::std::string& newName_, uint8 userID_);

    /**
     * Destructor
     */
    inline virtual  ~Do_SetProfileNameRequest();

    /**
     * Assignment operator
     */
    inline Do_SetProfileNameRequest& operator = (const Do_SetProfileNameRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Do_SetProfileNameRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Do_SetProfileNameRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Do_SetProfileNameRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Do_SetProfileNameRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "newName"

    static const int kNewName = 0;

    /**
     * Clears the field "newName".
     *
     * The field will be set to its default value. The hasNewName()
     * method will return false.
     */
    inline void clearNewName();

    /**
     * Checks whether the field "newName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNewName()). Otherwise it will return false.
     */
    inline bool hasNewName () const;

    /**
     * Returns the value of the member "newName".
     *
     * If the meaning of "newName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "newName"
     */
    inline const ::std::string& getNewName () const;

    /**
     * Retrieves the value of the field "newName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "newName".
     */
    inline ::std::string& getNewNameMutable ();

    /**
     * Sets the value of the member "newName".
     *
     * If the meaning of "newName" isn't clear, then there should be a description here.
     *
     * @param newName The value which will be set
     */
    inline void setNewName (const ::std::string& newName_);

    /**
     * Sets the value of the member "newName".
     *
     * If the meaning of "newName" isn't clear, then there should be a description here.
     *
     * @param newName The value which will be set
     */
    inline void setNewName (const char* newName_);

    /**
     * Sets the value of the member "newName".
     *
     * If the meaning of "newName" isn't clear, then there should be a description here.
     *
     * @param newName The value which will be set
     */
    inline void setNewName (const char* value, size_t size);

    // API of field "userID"

    static const int kUserID = 1;

    /**
     * Clears the field "userID".
     *
     * The field will be set to its default value. The hasUserID()
     * method will return false.
     */
    inline void clearUserID();

    /**
     * Checks whether the field "userID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserID()). Otherwise it will return false.
     */
    inline bool hasUserID () const;

    /**
     * Returns the value of the member "userID".
     *
     * If the meaning of "userID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "userID"
     */
    inline uint8 getUserID () const;

    /**
     * Sets the value of the member "userID".
     *
     * If the meaning of "userID" isn't clear, then there should be a description here.
     *
     * @param userID The value which will be set
     */
    inline void setUserID (uint8 userID_);

    static const Do_SetProfileNameRequest &getDefaultInstance();

private:

    inline void set_has_newName ();

    inline void clear_has_newName ();

    inline void set_has_userID ();

    inline void clear_has_userID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _newName;

    uint8 _userID;

};

/**
 * sets the profile name for the current profile
 */
class Do_SetProfileNameResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Do_SetProfileNameResponse ();

    /**
     * Copy constructor
     */
    inline  Do_SetProfileNameResponse (const Do_SetProfileNameResponse &rhs);

    /**
     * All fields constructor
     */
    inline  Do_SetProfileNameResponse (serverResult Result_);

    /**
     * Destructor
     */
    inline virtual  ~Do_SetProfileNameResponse();

    /**
     * Assignment operator
     */
    inline Do_SetProfileNameResponse& operator = (const Do_SetProfileNameResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Do_SetProfileNameResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Do_SetProfileNameResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Do_SetProfileNameResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Do_SetProfileNameResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline serverResult getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (serverResult Result_);

    static const Do_SetProfileNameResponse &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    serverResult _Result;

};

/**
 * gets all profile names
 */
class GetProfileNamesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetProfileNamesResponse ();

    /**
     * Copy constructor
     */
    inline  GetProfileNamesResponse (const GetProfileNamesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetProfileNamesResponse (const ::std::vector< ::std::string >& names_);

    /**
     * Destructor
     */
    inline virtual  ~GetProfileNamesResponse();

    /**
     * Assignment operator
     */
    inline GetProfileNamesResponse& operator = (const GetProfileNamesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetProfileNamesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetProfileNamesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetProfileNamesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetProfileNamesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "names"

    static const int kNames = 0;

    /**
     * Clears the field "names".
     *
     * The field will be set to its default value. The hasNames()
     * method will return false.
     */
    inline void clearNames();

    /**
     * Checks whether the field "names" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNames()). Otherwise it will return false.
     */
    inline bool hasNames () const;

    /**
     * Returns the value of the member "names".
     *
     * If the meaning of "names" isn't clear, then there should be a description here.
     *
     * @return The value of the field "names"
     */
    inline const ::std::vector< ::std::string >& getNames () const;

    /**
     * Retrieves the value of the field "names" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "names".
     */
    inline ::std::vector< ::std::string >& getNamesMutable ();

    /**
     * Sets the value of the member "names".
     *
     * If the meaning of "names" isn't clear, then there should be a description here.
     *
     * @param names The value which will be set
     */
    inline void setNames (const ::std::vector< ::std::string >& names_);

    static const GetProfileNamesResponse &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_names ();

    inline void clear_has_names ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _names;

};

/**
 * import an image from usb drive as Proifle image in the given slot. if slot is 0xFFFF, then the profile manager will assign it tot the user image slot for the current Profile
 */
class DoImportProfileImageRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoImportProfileImageRequest ();

    /**
     * Copy constructor
     */
    inline  DoImportProfileImageRequest (const DoImportProfileImageRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DoImportProfileImageRequest (const ::std::string& sourcePath_, uint16 width_, uint16 height_, uint16 slotIdx_, bool bSetForCurrentProfile_);

    /**
     * Destructor
     */
    inline virtual  ~DoImportProfileImageRequest();

    /**
     * Assignment operator
     */
    inline DoImportProfileImageRequest& operator = (const DoImportProfileImageRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoImportProfileImageRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoImportProfileImageRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoImportProfileImageRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoImportProfileImageRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sourcePath"

    static const int kSourcePath = 0;

    /**
     * Clears the field "sourcePath".
     *
     * The field will be set to its default value. The hasSourcePath()
     * method will return false.
     */
    inline void clearSourcePath();

    /**
     * Checks whether the field "sourcePath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourcePath()). Otherwise it will return false.
     */
    inline bool hasSourcePath () const;

    /**
     * Returns the value of the member "sourcePath".
     *
     * If the meaning of "sourcePath" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourcePath"
     */
    inline const ::std::string& getSourcePath () const;

    /**
     * Retrieves the value of the field "sourcePath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sourcePath".
     */
    inline ::std::string& getSourcePathMutable ();

    /**
     * Sets the value of the member "sourcePath".
     *
     * If the meaning of "sourcePath" isn't clear, then there should be a description here.
     *
     * @param sourcePath The value which will be set
     */
    inline void setSourcePath (const ::std::string& sourcePath_);

    /**
     * Sets the value of the member "sourcePath".
     *
     * If the meaning of "sourcePath" isn't clear, then there should be a description here.
     *
     * @param sourcePath The value which will be set
     */
    inline void setSourcePath (const char* sourcePath_);

    /**
     * Sets the value of the member "sourcePath".
     *
     * If the meaning of "sourcePath" isn't clear, then there should be a description here.
     *
     * @param sourcePath The value which will be set
     */
    inline void setSourcePath (const char* value, size_t size);

    // API of field "width"

    static const int kWidth = 1;

    /**
     * Clears the field "width".
     *
     * The field will be set to its default value. The hasWidth()
     * method will return false.
     */
    inline void clearWidth();

    /**
     * Checks whether the field "width" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWidth()). Otherwise it will return false.
     */
    inline bool hasWidth () const;

    /**
     * Returns the value of the member "width".
     *
     * If the meaning of "width" isn't clear, then there should be a description here.
     *
     * @return The value of the field "width"
     */
    inline uint16 getWidth () const;

    /**
     * Sets the value of the member "width".
     *
     * If the meaning of "width" isn't clear, then there should be a description here.
     *
     * @param width The value which will be set
     */
    inline void setWidth (uint16 width_);

    // API of field "height"

    static const int kHeight = 2;

    /**
     * Clears the field "height".
     *
     * The field will be set to its default value. The hasHeight()
     * method will return false.
     */
    inline void clearHeight();

    /**
     * Checks whether the field "height" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHeight()). Otherwise it will return false.
     */
    inline bool hasHeight () const;

    /**
     * Returns the value of the member "height".
     *
     * If the meaning of "height" isn't clear, then there should be a description here.
     *
     * @return The value of the field "height"
     */
    inline uint16 getHeight () const;

    /**
     * Sets the value of the member "height".
     *
     * If the meaning of "height" isn't clear, then there should be a description here.
     *
     * @param height The value which will be set
     */
    inline void setHeight (uint16 height_);

    // API of field "slotIdx"

    static const int kSlotIdx = 3;

    /**
     * Clears the field "slotIdx".
     *
     * The field will be set to its default value. The hasSlotIdx()
     * method will return false.
     */
    inline void clearSlotIdx();

    /**
     * Checks whether the field "slotIdx" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSlotIdx()). Otherwise it will return false.
     */
    inline bool hasSlotIdx () const;

    /**
     * Returns the value of the member "slotIdx".
     *
     * If the meaning of "slotIdx" isn't clear, then there should be a description here.
     *
     * @return The value of the field "slotIdx"
     */
    inline uint16 getSlotIdx () const;

    /**
     * Sets the value of the member "slotIdx".
     *
     * If the meaning of "slotIdx" isn't clear, then there should be a description here.
     *
     * @param slotIdx The value which will be set
     */
    inline void setSlotIdx (uint16 slotIdx_);

    // API of field "bSetForCurrentProfile"

    static const int kBSetForCurrentProfile = 4;

    /**
     * Clears the field "bSetForCurrentProfile".
     *
     * The field will be set to its default value. The hasBSetForCurrentProfile()
     * method will return false.
     */
    inline void clearBSetForCurrentProfile();

    /**
     * Checks whether the field "bSetForCurrentProfile" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSetForCurrentProfile()). Otherwise it will return false.
     */
    inline bool hasBSetForCurrentProfile () const;

    /**
     * Returns the value of the member "bSetForCurrentProfile".
     *
     * If the meaning of "bSetForCurrentProfile" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bSetForCurrentProfile"
     */
    inline bool getBSetForCurrentProfile () const;

    /**
     * Sets the value of the member "bSetForCurrentProfile".
     *
     * If the meaning of "bSetForCurrentProfile" isn't clear, then there should be a description here.
     *
     * @param bSetForCurrentProfile The value which will be set
     */
    inline void setBSetForCurrentProfile (bool bSetForCurrentProfile_);

    static const DoImportProfileImageRequest &getDefaultInstance();

private:

    inline void set_has_sourcePath ();

    inline void clear_has_sourcePath ();

    inline void set_has_width ();

    inline void clear_has_width ();

    inline void set_has_height ();

    inline void clear_has_height ();

    inline void set_has_slotIdx ();

    inline void clear_has_slotIdx ();

    inline void set_has_bSetForCurrentProfile ();

    inline void clear_has_bSetForCurrentProfile ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string _sourcePath;

    uint16 _width;

    uint16 _height;

    uint16 _slotIdx;

    bool _bSetForCurrentProfile;

};

/**
 * import an image from usb drive as Proifle image in the given slot. if slot is 0xFFFF, then the profile manager will assign it tot the user image slot for the current Profile
 */
class DoImportProfileImageResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoImportProfileImageResponse ();

    /**
     * Copy constructor
     */
    inline  DoImportProfileImageResponse (const DoImportProfileImageResponse &rhs);

    /**
     * All fields constructor
     */
    inline  DoImportProfileImageResponse (serverResult result_);

    /**
     * Destructor
     */
    inline virtual  ~DoImportProfileImageResponse();

    /**
     * Assignment operator
     */
    inline DoImportProfileImageResponse& operator = (const DoImportProfileImageResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoImportProfileImageResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoImportProfileImageResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoImportProfileImageResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoImportProfileImageResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline serverResult getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (serverResult result_);

    static const DoImportProfileImageResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    serverResult _result;

};

/**
 * delete an imported image referenced by the slotIdx from the system.
 */
class RemoveUserImageRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoveUserImageRequest ();

    /**
     * Copy constructor
     */
    inline  RemoveUserImageRequest (const RemoveUserImageRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RemoveUserImageRequest (uint16 slotIdx_);

    /**
     * Destructor
     */
    inline virtual  ~RemoveUserImageRequest();

    /**
     * Assignment operator
     */
    inline RemoveUserImageRequest& operator = (const RemoveUserImageRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoveUserImageRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoveUserImageRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoveUserImageRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoveUserImageRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "slotIdx"

    static const int kSlotIdx = 0;

    /**
     * Clears the field "slotIdx".
     *
     * The field will be set to its default value. The hasSlotIdx()
     * method will return false.
     */
    inline void clearSlotIdx();

    /**
     * Checks whether the field "slotIdx" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSlotIdx()). Otherwise it will return false.
     */
    inline bool hasSlotIdx () const;

    /**
     * Returns the value of the member "slotIdx".
     *
     * If the meaning of "slotIdx" isn't clear, then there should be a description here.
     *
     * @return The value of the field "slotIdx"
     */
    inline uint16 getSlotIdx () const;

    /**
     * Sets the value of the member "slotIdx".
     *
     * If the meaning of "slotIdx" isn't clear, then there should be a description here.
     *
     * @param slotIdx The value which will be set
     */
    inline void setSlotIdx (uint16 slotIdx_);

    static const RemoveUserImageRequest &getDefaultInstance();

private:

    inline void set_has_slotIdx ();

    inline void clear_has_slotIdx ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _slotIdx;

};

/**
 * delete an imported image referenced by the slotIdx from the system.
 */
class RemoveUserImageResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoveUserImageResponse ();

    /**
     * Copy constructor
     */
    inline  RemoveUserImageResponse (const RemoveUserImageResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RemoveUserImageResponse (serverResult result_);

    /**
     * Destructor
     */
    inline virtual  ~RemoveUserImageResponse();

    /**
     * Assignment operator
     */
    inline RemoveUserImageResponse& operator = (const RemoveUserImageResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoveUserImageResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoveUserImageResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoveUserImageResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoveUserImageResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline serverResult getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (serverResult result_);

    static const RemoveUserImageResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    serverResult _result;

};

/**
 * set current profile image (index)
 */
class DoSetProfileImageRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoSetProfileImageRequest ();

    /**
     * Copy constructor
     */
    inline  DoSetProfileImageRequest (const DoSetProfileImageRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DoSetProfileImageRequest (uint8 imageID_, uint8 userID_);

    /**
     * Destructor
     */
    inline virtual  ~DoSetProfileImageRequest();

    /**
     * Assignment operator
     */
    inline DoSetProfileImageRequest& operator = (const DoSetProfileImageRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoSetProfileImageRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoSetProfileImageRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoSetProfileImageRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoSetProfileImageRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "imageID"

    static const int kImageID = 0;

    /**
     * Clears the field "imageID".
     *
     * The field will be set to its default value. The hasImageID()
     * method will return false.
     */
    inline void clearImageID();

    /**
     * Checks whether the field "imageID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImageID()). Otherwise it will return false.
     */
    inline bool hasImageID () const;

    /**
     * Returns the value of the member "imageID".
     *
     * If the meaning of "imageID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "imageID"
     */
    inline uint8 getImageID () const;

    /**
     * Sets the value of the member "imageID".
     *
     * If the meaning of "imageID" isn't clear, then there should be a description here.
     *
     * @param imageID The value which will be set
     */
    inline void setImageID (uint8 imageID_);

    // API of field "userID"

    static const int kUserID = 1;

    /**
     * Clears the field "userID".
     *
     * The field will be set to its default value. The hasUserID()
     * method will return false.
     */
    inline void clearUserID();

    /**
     * Checks whether the field "userID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserID()). Otherwise it will return false.
     */
    inline bool hasUserID () const;

    /**
     * Returns the value of the member "userID".
     *
     * If the meaning of "userID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "userID"
     */
    inline uint8 getUserID () const;

    /**
     * Sets the value of the member "userID".
     *
     * If the meaning of "userID" isn't clear, then there should be a description here.
     *
     * @param userID The value which will be set
     */
    inline void setUserID (uint8 userID_);

    static const DoSetProfileImageRequest &getDefaultInstance();

private:

    inline void set_has_imageID ();

    inline void clear_has_imageID ();

    inline void set_has_userID ();

    inline void clear_has_userID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _imageID;

    uint8 _userID;

};

/**
 * set current profile image (index)
 */
class DoSetProfileImageResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoSetProfileImageResponse ();

    /**
     * Copy constructor
     */
    inline  DoSetProfileImageResponse (const DoSetProfileImageResponse &rhs);

    /**
     * All fields constructor
     */
    inline  DoSetProfileImageResponse (serverResult result_);

    /**
     * Destructor
     */
    inline virtual  ~DoSetProfileImageResponse();

    /**
     * Assignment operator
     */
    inline DoSetProfileImageResponse& operator = (const DoSetProfileImageResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoSetProfileImageResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoSetProfileImageResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoSetProfileImageResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoSetProfileImageResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline serverResult getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (serverResult result_);

    static const DoSetProfileImageResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    serverResult _result;

};

/**
 * gets all profile images
 */
class GetProfileImagesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetProfileImagesResponse ();

    /**
     * Copy constructor
     */
    inline  GetProfileImagesResponse (const GetProfileImagesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetProfileImagesResponse (const ::std::vector< uint8 >& images_);

    /**
     * Destructor
     */
    inline virtual  ~GetProfileImagesResponse();

    /**
     * Assignment operator
     */
    inline GetProfileImagesResponse& operator = (const GetProfileImagesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetProfileImagesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetProfileImagesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetProfileImagesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetProfileImagesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "images"

    static const int kImages = 0;

    /**
     * Clears the field "images".
     *
     * The field will be set to its default value. The hasImages()
     * method will return false.
     */
    inline void clearImages();

    /**
     * Checks whether the field "images" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImages()). Otherwise it will return false.
     */
    inline bool hasImages () const;

    /**
     * Returns the value of the member "images".
     *
     * If the meaning of "images" isn't clear, then there should be a description here.
     *
     * @return The value of the field "images"
     */
    inline const ::std::vector< uint8 >& getImages () const;

    /**
     * Retrieves the value of the field "images" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "images".
     */
    inline ::std::vector< uint8 >& getImagesMutable ();

    /**
     * Sets the value of the member "images".
     *
     * If the meaning of "images" isn't clear, then there should be a description here.
     *
     * @param images The value which will be set
     */
    inline void setImages (const ::std::vector< uint8 >& images_);

    static const GetProfileImagesResponse &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_images ();

    inline void clear_has_images ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _images;

};

/**
 * gets all profile types
 */
class GetProfileTypesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetProfileTypesResponse ();

    /**
     * Copy constructor
     */
    inline  GetProfileTypesResponse (const GetProfileTypesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetProfileTypesResponse (const ::std::vector< profileType >& types_);

    /**
     * Destructor
     */
    inline virtual  ~GetProfileTypesResponse();

    /**
     * Assignment operator
     */
    inline GetProfileTypesResponse& operator = (const GetProfileTypesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetProfileTypesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetProfileTypesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetProfileTypesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetProfileTypesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "types"

    static const int kTypes = 0;

    /**
     * Clears the field "types".
     *
     * The field will be set to its default value. The hasTypes()
     * method will return false.
     */
    inline void clearTypes();

    /**
     * Checks whether the field "types" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTypes()). Otherwise it will return false.
     */
    inline bool hasTypes () const;

    /**
     * Returns the value of the member "types".
     *
     * If the meaning of "types" isn't clear, then there should be a description here.
     *
     * @return The value of the field "types"
     */
    inline const ::std::vector< profileType >& getTypes () const;

    /**
     * Retrieves the value of the field "types" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "types".
     */
    inline ::std::vector< profileType >& getTypesMutable ();

    /**
     * Sets the value of the member "types".
     *
     * If the meaning of "types" isn't clear, then there should be a description here.
     *
     * @param types The value which will be set
     */
    inline void setTypes (const ::std::vector< profileType >& types_);

    static const GetProfileTypesResponse &getDefaultInstance();

private:

    static const ::std::vector< profileType >& getProfileTypeList_DefaultInstance ();

    inline void set_has_types ();

    inline void clear_has_types ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< profileType > _types;

};

/**
 * sets Authentication Method PIN
 */
class SetProfilePinRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetProfilePinRequest ();

    /**
     * Copy constructor
     */
    inline  SetProfilePinRequest (const SetProfilePinRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetProfilePinRequest (uint8 profileID_, const ::std::string& Pin_);

    /**
     * Destructor
     */
    inline virtual  ~SetProfilePinRequest();

    /**
     * Assignment operator
     */
    inline SetProfilePinRequest& operator = (const SetProfilePinRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetProfilePinRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetProfilePinRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetProfilePinRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetProfilePinRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "profileID"

    static const int kProfileID = 0;

    /**
     * Clears the field "profileID".
     *
     * The field will be set to its default value. The hasProfileID()
     * method will return false.
     */
    inline void clearProfileID();

    /**
     * Checks whether the field "profileID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProfileID()). Otherwise it will return false.
     */
    inline bool hasProfileID () const;

    /**
     * Returns the value of the member "profileID".
     *
     * If the meaning of "profileID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "profileID"
     */
    inline uint8 getProfileID () const;

    /**
     * Sets the value of the member "profileID".
     *
     * If the meaning of "profileID" isn't clear, then there should be a description here.
     *
     * @param profileID The value which will be set
     */
    inline void setProfileID (uint8 profileID_);

    // API of field "Pin"

    static const int kPin = 1;

    /**
     * Clears the field "Pin".
     *
     * The field will be set to its default value. The hasPin()
     * method will return false.
     */
    inline void clearPin();

    /**
     * Checks whether the field "Pin" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPin()). Otherwise it will return false.
     */
    inline bool hasPin () const;

    /**
     * Returns the value of the member "Pin".
     *
     * If the meaning of "Pin" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Pin"
     */
    inline const ::std::string& getPin () const;

    /**
     * Retrieves the value of the field "Pin" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Pin".
     */
    inline ::std::string& getPinMutable ();

    /**
     * Sets the value of the member "Pin".
     *
     * If the meaning of "Pin" isn't clear, then there should be a description here.
     *
     * @param Pin The value which will be set
     */
    inline void setPin (const ::std::string& Pin_);

    /**
     * Sets the value of the member "Pin".
     *
     * If the meaning of "Pin" isn't clear, then there should be a description here.
     *
     * @param Pin The value which will be set
     */
    inline void setPin (const char* Pin_);

    /**
     * Sets the value of the member "Pin".
     *
     * If the meaning of "Pin" isn't clear, then there should be a description here.
     *
     * @param Pin The value which will be set
     */
    inline void setPin (const char* value, size_t size);

    static const SetProfilePinRequest &getDefaultInstance();

private:

    inline void set_has_profileID ();

    inline void clear_has_profileID ();

    inline void set_has_Pin ();

    inline void clear_has_Pin ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _profileID;

    ::std::string _Pin;

};

/**
 * sets Authentication Method PIN
 */
class SetProfilePinResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetProfilePinResponse ();

    /**
     * Copy constructor
     */
    inline  SetProfilePinResponse (const SetProfilePinResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetProfilePinResponse (serverResult result_);

    /**
     * Destructor
     */
    inline virtual  ~SetProfilePinResponse();

    /**
     * Assignment operator
     */
    inline SetProfilePinResponse& operator = (const SetProfilePinResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetProfilePinResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetProfilePinResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetProfilePinResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetProfilePinResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline serverResult getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (serverResult result_);

    static const SetProfilePinResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    serverResult _result;

};

/**
 * sets Authentication Method to Remember Me
 */
class SetRememberMeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetRememberMeRequest ();

    /**
     * Copy constructor
     */
    inline  SetRememberMeRequest (const SetRememberMeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetRememberMeRequest (uint8 profileID_);

    /**
     * Destructor
     */
    inline virtual  ~SetRememberMeRequest();

    /**
     * Assignment operator
     */
    inline SetRememberMeRequest& operator = (const SetRememberMeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetRememberMeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetRememberMeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetRememberMeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetRememberMeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "profileID"

    static const int kProfileID = 0;

    /**
     * Clears the field "profileID".
     *
     * The field will be set to its default value. The hasProfileID()
     * method will return false.
     */
    inline void clearProfileID();

    /**
     * Checks whether the field "profileID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProfileID()). Otherwise it will return false.
     */
    inline bool hasProfileID () const;

    /**
     * Returns the value of the member "profileID".
     *
     * If the meaning of "profileID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "profileID"
     */
    inline uint8 getProfileID () const;

    /**
     * Sets the value of the member "profileID".
     *
     * If the meaning of "profileID" isn't clear, then there should be a description here.
     *
     * @param profileID The value which will be set
     */
    inline void setProfileID (uint8 profileID_);

    static const SetRememberMeRequest &getDefaultInstance();

private:

    inline void set_has_profileID ();

    inline void clear_has_profileID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _profileID;

};

/**
 * sets Authentication Method to Remember Me
 */
class SetRememberMeResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetRememberMeResponse ();

    /**
     * Copy constructor
     */
    inline  SetRememberMeResponse (const SetRememberMeResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetRememberMeResponse (serverResult result_);

    /**
     * Destructor
     */
    inline virtual  ~SetRememberMeResponse();

    /**
     * Assignment operator
     */
    inline SetRememberMeResponse& operator = (const SetRememberMeResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetRememberMeResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetRememberMeResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetRememberMeResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetRememberMeResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline serverResult getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (serverResult result_);

    static const SetRememberMeResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    serverResult _result;

};

/**
 * Validates the current PIN. needs to be called before setProfilePin & setRememberMe if Prodile is secured by PIN
 */
class CheckPinRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CheckPinRequest ();

    /**
     * Copy constructor
     */
    inline  CheckPinRequest (const CheckPinRequest &rhs);

    /**
     * All fields constructor
     */
    inline  CheckPinRequest (uint8 profileID_, const ::std::string& PIN_);

    /**
     * Destructor
     */
    inline virtual  ~CheckPinRequest();

    /**
     * Assignment operator
     */
    inline CheckPinRequest& operator = (const CheckPinRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CheckPinRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CheckPinRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CheckPinRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CheckPinRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "profileID"

    static const int kProfileID = 0;

    /**
     * Clears the field "profileID".
     *
     * The field will be set to its default value. The hasProfileID()
     * method will return false.
     */
    inline void clearProfileID();

    /**
     * Checks whether the field "profileID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProfileID()). Otherwise it will return false.
     */
    inline bool hasProfileID () const;

    /**
     * Returns the value of the member "profileID".
     *
     * If the meaning of "profileID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "profileID"
     */
    inline uint8 getProfileID () const;

    /**
     * Sets the value of the member "profileID".
     *
     * If the meaning of "profileID" isn't clear, then there should be a description here.
     *
     * @param profileID The value which will be set
     */
    inline void setProfileID (uint8 profileID_);

    // API of field "PIN"

    static const int kPIN = 1;

    /**
     * Clears the field "PIN".
     *
     * The field will be set to its default value. The hasPIN()
     * method will return false.
     */
    inline void clearPIN();

    /**
     * Checks whether the field "PIN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPIN()). Otherwise it will return false.
     */
    inline bool hasPIN () const;

    /**
     * Returns the value of the member "PIN".
     *
     * If the meaning of "PIN" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PIN"
     */
    inline const ::std::string& getPIN () const;

    /**
     * Retrieves the value of the field "PIN" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PIN".
     */
    inline ::std::string& getPINMutable ();

    /**
     * Sets the value of the member "PIN".
     *
     * If the meaning of "PIN" isn't clear, then there should be a description here.
     *
     * @param PIN The value which will be set
     */
    inline void setPIN (const ::std::string& PIN_);

    /**
     * Sets the value of the member "PIN".
     *
     * If the meaning of "PIN" isn't clear, then there should be a description here.
     *
     * @param PIN The value which will be set
     */
    inline void setPIN (const char* PIN_);

    /**
     * Sets the value of the member "PIN".
     *
     * If the meaning of "PIN" isn't clear, then there should be a description here.
     *
     * @param PIN The value which will be set
     */
    inline void setPIN (const char* value, size_t size);

    static const CheckPinRequest &getDefaultInstance();

private:

    inline void set_has_profileID ();

    inline void clear_has_profileID ();

    inline void set_has_PIN ();

    inline void clear_has_PIN ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _profileID;

    ::std::string _PIN;

};

/**
 * Validates the current PIN. needs to be called before setProfilePin & setRememberMe if Prodile is secured by PIN
 */
class CheckPinResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CheckPinResponse ();

    /**
     * Copy constructor
     */
    inline  CheckPinResponse (const CheckPinResponse &rhs);

    /**
     * All fields constructor
     */
    inline  CheckPinResponse (serverResult result_);

    /**
     * Destructor
     */
    inline virtual  ~CheckPinResponse();

    /**
     * Assignment operator
     */
    inline CheckPinResponse& operator = (const CheckPinResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CheckPinResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CheckPinResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CheckPinResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CheckPinResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline serverResult getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (serverResult result_);

    static const CheckPinResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    serverResult _result;

};

/**
 * removes the Authentication Method
 */
class UnProtectProfileRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnProtectProfileRequest ();

    /**
     * Copy constructor
     */
    inline  UnProtectProfileRequest (const UnProtectProfileRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UnProtectProfileRequest (uint8 profileID_);

    /**
     * Destructor
     */
    inline virtual  ~UnProtectProfileRequest();

    /**
     * Assignment operator
     */
    inline UnProtectProfileRequest& operator = (const UnProtectProfileRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnProtectProfileRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnProtectProfileRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnProtectProfileRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnProtectProfileRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "profileID"

    static const int kProfileID = 0;

    /**
     * Clears the field "profileID".
     *
     * The field will be set to its default value. The hasProfileID()
     * method will return false.
     */
    inline void clearProfileID();

    /**
     * Checks whether the field "profileID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProfileID()). Otherwise it will return false.
     */
    inline bool hasProfileID () const;

    /**
     * Returns the value of the member "profileID".
     *
     * If the meaning of "profileID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "profileID"
     */
    inline uint8 getProfileID () const;

    /**
     * Sets the value of the member "profileID".
     *
     * If the meaning of "profileID" isn't clear, then there should be a description here.
     *
     * @param profileID The value which will be set
     */
    inline void setProfileID (uint8 profileID_);

    static const UnProtectProfileRequest &getDefaultInstance();

private:

    inline void set_has_profileID ();

    inline void clear_has_profileID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _profileID;

};

/**
 * removes the Authentication Method
 */
class UnProtectProfileResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnProtectProfileResponse ();

    /**
     * Copy constructor
     */
    inline  UnProtectProfileResponse (const UnProtectProfileResponse &rhs);

    /**
     * All fields constructor
     */
    inline  UnProtectProfileResponse (serverResult result_);

    /**
     * Destructor
     */
    inline virtual  ~UnProtectProfileResponse();

    /**
     * Assignment operator
     */
    inline UnProtectProfileResponse& operator = (const UnProtectProfileResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnProtectProfileResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnProtectProfileResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnProtectProfileResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnProtectProfileResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline serverResult getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (serverResult result_);

    static const UnProtectProfileResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    serverResult _result;

};

/**
 * link profile
 */
class LinkProfileRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LinkProfileRequest ();

    /**
     * Copy constructor
     */
    inline  LinkProfileRequest (const LinkProfileRequest &rhs);

    /**
     * All fields constructor
     */
    inline  LinkProfileRequest (bool bSetLink_);

    /**
     * Destructor
     */
    inline virtual  ~LinkProfileRequest();

    /**
     * Assignment operator
     */
    inline LinkProfileRequest& operator = (const LinkProfileRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LinkProfileRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LinkProfileRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LinkProfileRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LinkProfileRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bSetLink"

    static const int kBSetLink = 0;

    /**
     * Clears the field "bSetLink".
     *
     * The field will be set to its default value. The hasBSetLink()
     * method will return false.
     */
    inline void clearBSetLink();

    /**
     * Checks whether the field "bSetLink" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSetLink()). Otherwise it will return false.
     */
    inline bool hasBSetLink () const;

    /**
     * Returns the value of the member "bSetLink".
     *
     * If the meaning of "bSetLink" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bSetLink"
     */
    inline bool getBSetLink () const;

    /**
     * Sets the value of the member "bSetLink".
     *
     * If the meaning of "bSetLink" isn't clear, then there should be a description here.
     *
     * @param bSetLink The value which will be set
     */
    inline void setBSetLink (bool bSetLink_);

    static const LinkProfileRequest &getDefaultInstance();

private:

    inline void set_has_bSetLink ();

    inline void clear_has_bSetLink ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bSetLink;

};

/**
 * link profile
 */
class LinkProfileResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LinkProfileResponse ();

    /**
     * Copy constructor
     */
    inline  LinkProfileResponse (const LinkProfileResponse &rhs);

    /**
     * All fields constructor
     */
    inline  LinkProfileResponse (serverResult result_);

    /**
     * Destructor
     */
    inline virtual  ~LinkProfileResponse();

    /**
     * Assignment operator
     */
    inline LinkProfileResponse& operator = (const LinkProfileResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LinkProfileResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LinkProfileResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LinkProfileResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LinkProfileResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline serverResult getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (serverResult result_);

    static const LinkProfileResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    serverResult _result;

};

/**
 * SetValetMode
 */
class SetValetModeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetValetModeRequest ();

    /**
     * Copy constructor
     */
    inline  SetValetModeRequest (const SetValetModeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetValetModeRequest (bool bEnableValetMode_);

    /**
     * Destructor
     */
    inline virtual  ~SetValetModeRequest();

    /**
     * Assignment operator
     */
    inline SetValetModeRequest& operator = (const SetValetModeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetValetModeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetValetModeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetValetModeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetValetModeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bEnableValetMode"

    static const int kBEnableValetMode = 0;

    /**
     * Clears the field "bEnableValetMode".
     *
     * The field will be set to its default value. The hasBEnableValetMode()
     * method will return false.
     */
    inline void clearBEnableValetMode();

    /**
     * Checks whether the field "bEnableValetMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEnableValetMode()). Otherwise it will return false.
     */
    inline bool hasBEnableValetMode () const;

    /**
     * Returns the value of the member "bEnableValetMode".
     *
     * If the meaning of "bEnableValetMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bEnableValetMode"
     */
    inline bool getBEnableValetMode () const;

    /**
     * Sets the value of the member "bEnableValetMode".
     *
     * If the meaning of "bEnableValetMode" isn't clear, then there should be a description here.
     *
     * @param bEnableValetMode The value which will be set
     */
    inline void setBEnableValetMode (bool bEnableValetMode_);

    static const SetValetModeRequest &getDefaultInstance();

private:

    inline void set_has_bEnableValetMode ();

    inline void clear_has_bEnableValetMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bEnableValetMode;

};

/**
 * SetValetMode
 */
class SetValetModeResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetValetModeResponse ();

    /**
     * Copy constructor
     */
    inline  SetValetModeResponse (const SetValetModeResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetValetModeResponse (serverResult result_);

    /**
     * Destructor
     */
    inline virtual  ~SetValetModeResponse();

    /**
     * Assignment operator
     */
    inline SetValetModeResponse& operator = (const SetValetModeResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetValetModeResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetValetModeResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetValetModeResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetValetModeResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline serverResult getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (serverResult result_);

    static const SetValetModeResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    serverResult _result;

};

/**
 * current user Profile. Updated only on user change.
 */
class ActiveProfileUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveProfileUpdate ();

    /**
     * Copy constructor
     */
    inline  ActiveProfileUpdate (const ActiveProfileUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ActiveProfileUpdate (uint8 activeProfile_);

    /**
     * Destructor
     */
    inline virtual  ~ActiveProfileUpdate();

    /**
     * Assignment operator
     */
    inline ActiveProfileUpdate& operator = (const ActiveProfileUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveProfileUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveProfileUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveProfileUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveProfileUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "activeProfile"

    static const int kActiveProfile = 0;

    /**
     * Clears the field "activeProfile".
     *
     * The field will be set to its default value. The hasActiveProfile()
     * method will return false.
     */
    inline void clearActiveProfile();

    /**
     * Checks whether the field "activeProfile" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveProfile()). Otherwise it will return false.
     */
    inline bool hasActiveProfile () const;

    /**
     * Returns the value of the member "activeProfile".
     *
     * current user Profile. Updated only on user change.
     *
     * @return The value of the field "activeProfile"
     */
    inline uint8 getActiveProfile () const;

    /**
     * Sets the value of the member "activeProfile".
     *
     * current user Profile. Updated only on user change.
     *
     * @param activeProfile The value which will be set
     */
    inline void setActiveProfile (uint8 activeProfile_);

    static const ActiveProfileUpdate &getDefaultInstance();

private:

    inline void set_has_activeProfile ();

    inline void clear_has_activeProfile ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _activeProfile;

};

/**
 * current user Profile. Updated only on user change.
 */
class ActiveProfileRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveProfileRegister ();

    /**
     * Copy constructor
     */
    inline  ActiveProfileRegister (const ActiveProfileRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ActiveProfileRegister();

    /**
     * Assignment operator
     */
    inline ActiveProfileRegister& operator = (const ActiveProfileRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveProfileRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveProfileRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveProfileRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveProfileRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ActiveProfileRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "status" isn't clear, then there should be a description here.
 */
class StatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StatusUpdate ();

    /**
     * Copy constructor
     */
    inline  StatusUpdate (const StatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  StatusUpdate (ProfileStatus status_);

    /**
     * Destructor
     */
    inline virtual  ~StatusUpdate();

    /**
     * Assignment operator
     */
    inline StatusUpdate& operator = (const StatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline ProfileStatus getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (ProfileStatus status_);

    static const StatusUpdate &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ProfileStatus _status;

};

/**
 * If the meaning of "status" isn't clear, then there should be a description here.
 */
class StatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StatusRegister ();

    /**
     * Copy constructor
     */
    inline  StatusRegister (const StatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~StatusRegister();

    /**
     * Assignment operator
     */
    inline StatusRegister& operator = (const StatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const StatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "copyProfile" isn't clear, then there should be a description here.
 */
class CopyProfileUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CopyProfileUpdate ();

    /**
     * Copy constructor
     */
    inline  CopyProfileUpdate (const CopyProfileUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CopyProfileUpdate (const copyInfo& copyProfile_);

    /**
     * Destructor
     */
    inline virtual  ~CopyProfileUpdate();

    /**
     * Assignment operator
     */
    inline CopyProfileUpdate& operator = (const CopyProfileUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CopyProfileUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CopyProfileUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CopyProfileUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CopyProfileUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "copyProfile"

    static const int kCopyProfile = 0;

    /**
     * Clears the field "copyProfile".
     *
     * The field will be set to its default value. The hasCopyProfile()
     * method will return false.
     */
    inline void clearCopyProfile();

    /**
     * Checks whether the field "copyProfile" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCopyProfile()). Otherwise it will return false.
     */
    inline bool hasCopyProfile () const;

    /**
     * Returns the value of the member "copyProfile".
     *
     * If the meaning of "copyProfile" isn't clear, then there should be a description here.
     *
     * @return The value of the field "copyProfile"
     */
    inline const copyInfo& getCopyProfile () const;

    /**
     * Retrieves the value of the field "copyProfile" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "copyProfile".
     */
    inline copyInfo& getCopyProfileMutable ();

    /**
     * Sets the value of the member "copyProfile".
     *
     * If the meaning of "copyProfile" isn't clear, then there should be a description here.
     *
     * @param copyProfile The value which will be set
     */
    inline void setCopyProfile (const copyInfo& copyProfile_);

    static const CopyProfileUpdate &getDefaultInstance();

private:

    inline void set_has_copyProfile ();

    inline void clear_has_copyProfile ();

    uint32 _has_bits_[ (1 + 31) / 32];

    copyInfo _copyProfile;

};

/**
 * If the meaning of "copyProfile" isn't clear, then there should be a description here.
 */
class CopyProfileRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CopyProfileRegister ();

    /**
     * Copy constructor
     */
    inline  CopyProfileRegister (const CopyProfileRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CopyProfileRegister();

    /**
     * Assignment operator
     */
    inline CopyProfileRegister& operator = (const CopyProfileRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CopyProfileRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CopyProfileRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CopyProfileRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CopyProfileRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CopyProfileRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Profile is to be Deleted (values to be overwritten with Default values)
 */
class DeleteProfileUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeleteProfileUpdate ();

    /**
     * Copy constructor
     */
    inline  DeleteProfileUpdate (const DeleteProfileUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DeleteProfileUpdate (uint8 deleteProfile_);

    /**
     * Destructor
     */
    inline virtual  ~DeleteProfileUpdate();

    /**
     * Assignment operator
     */
    inline DeleteProfileUpdate& operator = (const DeleteProfileUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteProfileUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteProfileUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteProfileUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteProfileUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "deleteProfile"

    static const int kDeleteProfile = 0;

    /**
     * Clears the field "deleteProfile".
     *
     * The field will be set to its default value. The hasDeleteProfile()
     * method will return false.
     */
    inline void clearDeleteProfile();

    /**
     * Checks whether the field "deleteProfile" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeleteProfile()). Otherwise it will return false.
     */
    inline bool hasDeleteProfile () const;

    /**
     * Returns the value of the member "deleteProfile".
     *
     * Profile is to be Deleted (values to be overwritten with Default values)
     *
     * @return The value of the field "deleteProfile"
     */
    inline uint8 getDeleteProfile () const;

    /**
     * Sets the value of the member "deleteProfile".
     *
     * Profile is to be Deleted (values to be overwritten with Default values)
     *
     * @param deleteProfile The value which will be set
     */
    inline void setDeleteProfile (uint8 deleteProfile_);

    static const DeleteProfileUpdate &getDefaultInstance();

private:

    inline void set_has_deleteProfile ();

    inline void clear_has_deleteProfile ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _deleteProfile;

};

/**
 * Profile is to be Deleted (values to be overwritten with Default values)
 */
class DeleteProfileRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeleteProfileRegister ();

    /**
     * Copy constructor
     */
    inline  DeleteProfileRegister (const DeleteProfileRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DeleteProfileRegister();

    /**
     * Assignment operator
     */
    inline DeleteProfileRegister& operator = (const DeleteProfileRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeleteProfileRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeleteProfileRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeleteProfileRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeleteProfileRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DeleteProfileRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Download marker will be set to true, if upload / downlaod is in progress Application should not accept value changes, while this attribute is true
 */
class DataChangedUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DataChangedUpdate ();

    /**
     * Copy constructor
     */
    inline  DataChangedUpdate (const DataChangedUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DataChangedUpdate (dataChangeReason dataChanged_);

    /**
     * Destructor
     */
    inline virtual  ~DataChangedUpdate();

    /**
     * Assignment operator
     */
    inline DataChangedUpdate& operator = (const DataChangedUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DataChangedUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DataChangedUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DataChangedUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DataChangedUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "dataChanged"

    static const int kDataChanged = 0;

    /**
     * Clears the field "dataChanged".
     *
     * The field will be set to its default value. The hasDataChanged()
     * method will return false.
     */
    inline void clearDataChanged();

    /**
     * Checks whether the field "dataChanged" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDataChanged()). Otherwise it will return false.
     */
    inline bool hasDataChanged () const;

    /**
     * Returns the value of the member "dataChanged".
     *
     * Download marker will be set to true, if upload / downlaod is in progress Application should not accept value changes, while this attribute is true
     *
     * @return The value of the field "dataChanged"
     */
    inline dataChangeReason getDataChanged () const;

    /**
     * Sets the value of the member "dataChanged".
     *
     * Download marker will be set to true, if upload / downlaod is in progress Application should not accept value changes, while this attribute is true
     *
     * @param dataChanged The value which will be set
     */
    inline void setDataChanged (dataChangeReason dataChanged_);

    static const DataChangedUpdate &getDefaultInstance();

private:

    inline void set_has_dataChanged ();

    inline void clear_has_dataChanged ();

    uint32 _has_bits_[ (1 + 31) / 32];

    dataChangeReason _dataChanged;

};

/**
 * Download marker will be set to true, if upload / downlaod is in progress Application should not accept value changes, while this attribute is true
 */
class DataChangedRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DataChangedRegister ();

    /**
     * Copy constructor
     */
    inline  DataChangedRegister (const DataChangedRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DataChangedRegister();

    /**
     * Assignment operator
     */
    inline DataChangedRegister& operator = (const DataChangedRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DataChangedRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DataChangedRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DataChangedRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DataChangedRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DataChangedRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * New Profile to be created(values to be overwritten with Default values)
 */
class CreateProfileUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateProfileUpdate ();

    /**
     * Copy constructor
     */
    inline  CreateProfileUpdate (const CreateProfileUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CreateProfileUpdate (uint8 createProfile_);

    /**
     * Destructor
     */
    inline virtual  ~CreateProfileUpdate();

    /**
     * Assignment operator
     */
    inline CreateProfileUpdate& operator = (const CreateProfileUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateProfileUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateProfileUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateProfileUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateProfileUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "createProfile"

    static const int kCreateProfile = 0;

    /**
     * Clears the field "createProfile".
     *
     * The field will be set to its default value. The hasCreateProfile()
     * method will return false.
     */
    inline void clearCreateProfile();

    /**
     * Checks whether the field "createProfile" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCreateProfile()). Otherwise it will return false.
     */
    inline bool hasCreateProfile () const;

    /**
     * Returns the value of the member "createProfile".
     *
     * New Profile to be created(values to be overwritten with Default values)
     *
     * @return The value of the field "createProfile"
     */
    inline uint8 getCreateProfile () const;

    /**
     * Sets the value of the member "createProfile".
     *
     * New Profile to be created(values to be overwritten with Default values)
     *
     * @param createProfile The value which will be set
     */
    inline void setCreateProfile (uint8 createProfile_);

    static const CreateProfileUpdate &getDefaultInstance();

private:

    inline void set_has_createProfile ();

    inline void clear_has_createProfile ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _createProfile;

};

/**
 * New Profile to be created(values to be overwritten with Default values)
 */
class CreateProfileRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateProfileRegister ();

    /**
     * Copy constructor
     */
    inline  CreateProfileRegister (const CreateProfileRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CreateProfileRegister();

    /**
     * Assignment operator
     */
    inline CreateProfileRegister& operator = (const CreateProfileRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateProfileRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateProfileRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateProfileRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateProfileRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CreateProfileRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Privacy mode flag for scope 2.1 treated as one boolean, for 3.0 as 32 booleans (0: privacy mode off, 1:Privacy mode On)
 */
class PrivacyModeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PrivacyModeUpdate ();

    /**
     * Copy constructor
     */
    inline  PrivacyModeUpdate (const PrivacyModeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PrivacyModeUpdate (uint32 privacyMode_);

    /**
     * Destructor
     */
    inline virtual  ~PrivacyModeUpdate();

    /**
     * Assignment operator
     */
    inline PrivacyModeUpdate& operator = (const PrivacyModeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PrivacyModeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PrivacyModeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PrivacyModeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PrivacyModeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "privacyMode"

    static const int kPrivacyMode = 0;

    /**
     * Clears the field "privacyMode".
     *
     * The field will be set to its default value. The hasPrivacyMode()
     * method will return false.
     */
    inline void clearPrivacyMode();

    /**
     * Checks whether the field "privacyMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPrivacyMode()). Otherwise it will return false.
     */
    inline bool hasPrivacyMode () const;

    /**
     * Returns the value of the member "privacyMode".
     *
     * Privacy mode flag for scope 2.1 treated as one boolean, for 3.0 as 32 booleans (0: privacy mode off, 1:Privacy mode On)
     *
     * @return The value of the field "privacyMode"
     */
    inline uint32 getPrivacyMode () const;

    /**
     * Sets the value of the member "privacyMode".
     *
     * Privacy mode flag for scope 2.1 treated as one boolean, for 3.0 as 32 booleans (0: privacy mode off, 1:Privacy mode On)
     *
     * @param privacyMode The value which will be set
     */
    inline void setPrivacyMode (uint32 privacyMode_);

    static const PrivacyModeUpdate &getDefaultInstance();

private:

    inline void set_has_privacyMode ();

    inline void clear_has_privacyMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _privacyMode;

};

/**
 * Privacy mode flag for scope 2.1 treated as one boolean, for 3.0 as 32 booleans (0: privacy mode off, 1:Privacy mode On)
 */
class PrivacyModeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PrivacyModeRegister ();

    /**
     * Copy constructor
     */
    inline  PrivacyModeRegister (const PrivacyModeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PrivacyModeRegister();

    /**
     * Assignment operator
     */
    inline PrivacyModeRegister& operator = (const PrivacyModeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PrivacyModeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PrivacyModeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PrivacyModeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PrivacyModeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PrivacyModeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Profile names for current profile con be changed with this attribute
 */
class ProfileNameUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProfileNameUpdate ();

    /**
     * Copy constructor
     */
    inline  ProfileNameUpdate (const ProfileNameUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ProfileNameUpdate (const ::std::string& profileName_);

    /**
     * Destructor
     */
    inline virtual  ~ProfileNameUpdate();

    /**
     * Assignment operator
     */
    inline ProfileNameUpdate& operator = (const ProfileNameUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProfileNameUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProfileNameUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProfileNameUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProfileNameUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "profileName"

    static const int kProfileName = 0;

    /**
     * Clears the field "profileName".
     *
     * The field will be set to its default value. The hasProfileName()
     * method will return false.
     */
    inline void clearProfileName();

    /**
     * Checks whether the field "profileName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProfileName()). Otherwise it will return false.
     */
    inline bool hasProfileName () const;

    /**
     * Returns the value of the member "profileName".
     *
     * Profile names for current profile con be changed with this attribute
     *
     * @return The value of the field "profileName"
     */
    inline const ::std::string& getProfileName () const;

    /**
     * Retrieves the value of the field "profileName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "profileName".
     */
    inline ::std::string& getProfileNameMutable ();

    /**
     * Sets the value of the member "profileName".
     *
     * Profile names for current profile con be changed with this attribute
     *
     * @param profileName The value which will be set
     */
    inline void setProfileName (const ::std::string& profileName_);

    /**
     * Sets the value of the member "profileName".
     *
     * Profile names for current profile con be changed with this attribute
     *
     * @param profileName The value which will be set
     */
    inline void setProfileName (const char* profileName_);

    /**
     * Sets the value of the member "profileName".
     *
     * Profile names for current profile con be changed with this attribute
     *
     * @param profileName The value which will be set
     */
    inline void setProfileName (const char* value, size_t size);

    static const ProfileNameUpdate &getDefaultInstance();

private:

    inline void set_has_profileName ();

    inline void clear_has_profileName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _profileName;

};

/**
 * Profile names for current profile con be changed with this attribute
 */
class ProfileNameRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProfileNameRegister ();

    /**
     * Copy constructor
     */
    inline  ProfileNameRegister (const ProfileNameRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ProfileNameRegister();

    /**
     * Assignment operator
     */
    inline ProfileNameRegister& operator = (const ProfileNameRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProfileNameRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProfileNameRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProfileNameRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProfileNameRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ProfileNameRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Profile names for current profile con be changed with this attribute
 */
class ProfileImageUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProfileImageUpdate ();

    /**
     * Copy constructor
     */
    inline  ProfileImageUpdate (const ProfileImageUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ProfileImageUpdate (uint8 profileImage_);

    /**
     * Destructor
     */
    inline virtual  ~ProfileImageUpdate();

    /**
     * Assignment operator
     */
    inline ProfileImageUpdate& operator = (const ProfileImageUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProfileImageUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProfileImageUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProfileImageUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProfileImageUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "profileImage"

    static const int kProfileImage = 0;

    /**
     * Clears the field "profileImage".
     *
     * The field will be set to its default value. The hasProfileImage()
     * method will return false.
     */
    inline void clearProfileImage();

    /**
     * Checks whether the field "profileImage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProfileImage()). Otherwise it will return false.
     */
    inline bool hasProfileImage () const;

    /**
     * Returns the value of the member "profileImage".
     *
     * Profile names for current profile con be changed with this attribute
     *
     * @return The value of the field "profileImage"
     */
    inline uint8 getProfileImage () const;

    /**
     * Sets the value of the member "profileImage".
     *
     * Profile names for current profile con be changed with this attribute
     *
     * @param profileImage The value which will be set
     */
    inline void setProfileImage (uint8 profileImage_);

    static const ProfileImageUpdate &getDefaultInstance();

private:

    inline void set_has_profileImage ();

    inline void clear_has_profileImage ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _profileImage;

};

/**
 * Profile names for current profile con be changed with this attribute
 */
class ProfileImageRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProfileImageRegister ();

    /**
     * Copy constructor
     */
    inline  ProfileImageRegister (const ProfileImageRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ProfileImageRegister();

    /**
     * Assignment operator
     */
    inline ProfileImageRegister& operator = (const ProfileImageRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProfileImageRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProfileImageRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProfileImageRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProfileImageRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ProfileImageRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * checkPin  call requested, to finish ongoing user action (e.g. change User
 */
class PinRequestedUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PinRequestedUpdate ();

    /**
     * Copy constructor
     */
    inline  PinRequestedUpdate (const PinRequestedUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PinRequestedUpdate (uint8 pinRequested_);

    /**
     * Destructor
     */
    inline virtual  ~PinRequestedUpdate();

    /**
     * Assignment operator
     */
    inline PinRequestedUpdate& operator = (const PinRequestedUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PinRequestedUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PinRequestedUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PinRequestedUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PinRequestedUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pinRequested"

    static const int kPinRequested = 0;

    /**
     * Clears the field "pinRequested".
     *
     * The field will be set to its default value. The hasPinRequested()
     * method will return false.
     */
    inline void clearPinRequested();

    /**
     * Checks whether the field "pinRequested" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPinRequested()). Otherwise it will return false.
     */
    inline bool hasPinRequested () const;

    /**
     * Returns the value of the member "pinRequested".
     *
     * checkPin  call requested, to finish ongoing user action (e.g. change User
     *
     * @return The value of the field "pinRequested"
     */
    inline uint8 getPinRequested () const;

    /**
     * Sets the value of the member "pinRequested".
     *
     * checkPin  call requested, to finish ongoing user action (e.g. change User
     *
     * @param pinRequested The value which will be set
     */
    inline void setPinRequested (uint8 pinRequested_);

    static const PinRequestedUpdate &getDefaultInstance();

private:

    inline void set_has_pinRequested ();

    inline void clear_has_pinRequested ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _pinRequested;

};

/**
 * checkPin  call requested, to finish ongoing user action (e.g. change User
 */
class PinRequestedRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PinRequestedRegister ();

    /**
     * Copy constructor
     */
    inline  PinRequestedRegister (const PinRequestedRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PinRequestedRegister();

    /**
     * Assignment operator
     */
    inline PinRequestedRegister& operator = (const PinRequestedRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PinRequestedRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PinRequestedRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PinRequestedRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PinRequestedRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PinRequestedRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Max PIN attempts allowed
 */
class MaxPINAttemptsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MaxPINAttemptsUpdate ();

    /**
     * Copy constructor
     */
    inline  MaxPINAttemptsUpdate (const MaxPINAttemptsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  MaxPINAttemptsUpdate (uint8 maxPINAttempts_);

    /**
     * Destructor
     */
    inline virtual  ~MaxPINAttemptsUpdate();

    /**
     * Assignment operator
     */
    inline MaxPINAttemptsUpdate& operator = (const MaxPINAttemptsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MaxPINAttemptsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MaxPINAttemptsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MaxPINAttemptsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MaxPINAttemptsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "maxPINAttempts"

    static const int kMaxPINAttempts = 0;

    /**
     * Clears the field "maxPINAttempts".
     *
     * The field will be set to its default value. The hasMaxPINAttempts()
     * method will return false.
     */
    inline void clearMaxPINAttempts();

    /**
     * Checks whether the field "maxPINAttempts" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxPINAttempts()). Otherwise it will return false.
     */
    inline bool hasMaxPINAttempts () const;

    /**
     * Returns the value of the member "maxPINAttempts".
     *
     * Max PIN attempts allowed
     *
     * @return The value of the field "maxPINAttempts"
     */
    inline uint8 getMaxPINAttempts () const;

    /**
     * Sets the value of the member "maxPINAttempts".
     *
     * Max PIN attempts allowed
     *
     * @param maxPINAttempts The value which will be set
     */
    inline void setMaxPINAttempts (uint8 maxPINAttempts_);

    static const MaxPINAttemptsUpdate &getDefaultInstance();

private:

    inline void set_has_maxPINAttempts ();

    inline void clear_has_maxPINAttempts ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _maxPINAttempts;

};

/**
 * Max PIN attempts allowed
 */
class MaxPINAttemptsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MaxPINAttemptsRegister ();

    /**
     * Copy constructor
     */
    inline  MaxPINAttemptsRegister (const MaxPINAttemptsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~MaxPINAttemptsRegister();

    /**
     * Assignment operator
     */
    inline MaxPINAttemptsRegister& operator = (const MaxPINAttemptsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MaxPINAttemptsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MaxPINAttemptsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MaxPINAttemptsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MaxPINAttemptsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const MaxPINAttemptsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Maximum PIN Attempts before Delay
 */
class MaxPINAttemptsBeforeDelayUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MaxPINAttemptsBeforeDelayUpdate ();

    /**
     * Copy constructor
     */
    inline  MaxPINAttemptsBeforeDelayUpdate (const MaxPINAttemptsBeforeDelayUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  MaxPINAttemptsBeforeDelayUpdate (uint8 maxPINAttemptsBeforeDelay_);

    /**
     * Destructor
     */
    inline virtual  ~MaxPINAttemptsBeforeDelayUpdate();

    /**
     * Assignment operator
     */
    inline MaxPINAttemptsBeforeDelayUpdate& operator = (const MaxPINAttemptsBeforeDelayUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MaxPINAttemptsBeforeDelayUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MaxPINAttemptsBeforeDelayUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MaxPINAttemptsBeforeDelayUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MaxPINAttemptsBeforeDelayUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "maxPINAttemptsBeforeDelay"

    static const int kMaxPINAttemptsBeforeDelay = 0;

    /**
     * Clears the field "maxPINAttemptsBeforeDelay".
     *
     * The field will be set to its default value. The hasMaxPINAttemptsBeforeDelay()
     * method will return false.
     */
    inline void clearMaxPINAttemptsBeforeDelay();

    /**
     * Checks whether the field "maxPINAttemptsBeforeDelay" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxPINAttemptsBeforeDelay()). Otherwise it will return false.
     */
    inline bool hasMaxPINAttemptsBeforeDelay () const;

    /**
     * Returns the value of the member "maxPINAttemptsBeforeDelay".
     *
     * Maximum PIN Attempts before Delay
     *
     * @return The value of the field "maxPINAttemptsBeforeDelay"
     */
    inline uint8 getMaxPINAttemptsBeforeDelay () const;

    /**
     * Sets the value of the member "maxPINAttemptsBeforeDelay".
     *
     * Maximum PIN Attempts before Delay
     *
     * @param maxPINAttemptsBeforeDelay The value which will be set
     */
    inline void setMaxPINAttemptsBeforeDelay (uint8 maxPINAttemptsBeforeDelay_);

    static const MaxPINAttemptsBeforeDelayUpdate &getDefaultInstance();

private:

    inline void set_has_maxPINAttemptsBeforeDelay ();

    inline void clear_has_maxPINAttemptsBeforeDelay ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _maxPINAttemptsBeforeDelay;

};

/**
 * Maximum PIN Attempts before Delay
 */
class MaxPINAttemptsBeforeDelayRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MaxPINAttemptsBeforeDelayRegister ();

    /**
     * Copy constructor
     */
    inline  MaxPINAttemptsBeforeDelayRegister (const MaxPINAttemptsBeforeDelayRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~MaxPINAttemptsBeforeDelayRegister();

    /**
     * Assignment operator
     */
    inline MaxPINAttemptsBeforeDelayRegister& operator = (const MaxPINAttemptsBeforeDelayRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MaxPINAttemptsBeforeDelayRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MaxPINAttemptsBeforeDelayRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MaxPINAttemptsBeforeDelayRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MaxPINAttemptsBeforeDelayRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const MaxPINAttemptsBeforeDelayRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * PIN Autherntication Delay in milliseconds
 */
class PinAuthenticationDelayTimeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PinAuthenticationDelayTimeUpdate ();

    /**
     * Copy constructor
     */
    inline  PinAuthenticationDelayTimeUpdate (const PinAuthenticationDelayTimeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PinAuthenticationDelayTimeUpdate (uint32 pinAuthenticationDelayTime_);

    /**
     * Destructor
     */
    inline virtual  ~PinAuthenticationDelayTimeUpdate();

    /**
     * Assignment operator
     */
    inline PinAuthenticationDelayTimeUpdate& operator = (const PinAuthenticationDelayTimeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PinAuthenticationDelayTimeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PinAuthenticationDelayTimeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PinAuthenticationDelayTimeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PinAuthenticationDelayTimeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pinAuthenticationDelayTime"

    static const int kPinAuthenticationDelayTime = 0;

    /**
     * Clears the field "pinAuthenticationDelayTime".
     *
     * The field will be set to its default value. The hasPinAuthenticationDelayTime()
     * method will return false.
     */
    inline void clearPinAuthenticationDelayTime();

    /**
     * Checks whether the field "pinAuthenticationDelayTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPinAuthenticationDelayTime()). Otherwise it will return false.
     */
    inline bool hasPinAuthenticationDelayTime () const;

    /**
     * Returns the value of the member "pinAuthenticationDelayTime".
     *
     * PIN Autherntication Delay in milliseconds
     *
     * @return The value of the field "pinAuthenticationDelayTime"
     */
    inline uint32 getPinAuthenticationDelayTime () const;

    /**
     * Sets the value of the member "pinAuthenticationDelayTime".
     *
     * PIN Autherntication Delay in milliseconds
     *
     * @param pinAuthenticationDelayTime The value which will be set
     */
    inline void setPinAuthenticationDelayTime (uint32 pinAuthenticationDelayTime_);

    static const PinAuthenticationDelayTimeUpdate &getDefaultInstance();

private:

    inline void set_has_pinAuthenticationDelayTime ();

    inline void clear_has_pinAuthenticationDelayTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _pinAuthenticationDelayTime;

};

/**
 * PIN Autherntication Delay in milliseconds
 */
class PinAuthenticationDelayTimeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PinAuthenticationDelayTimeRegister ();

    /**
     * Copy constructor
     */
    inline  PinAuthenticationDelayTimeRegister (const PinAuthenticationDelayTimeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PinAuthenticationDelayTimeRegister();

    /**
     * Assignment operator
     */
    inline PinAuthenticationDelayTimeRegister& operator = (const PinAuthenticationDelayTimeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PinAuthenticationDelayTimeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PinAuthenticationDelayTimeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PinAuthenticationDelayTimeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PinAuthenticationDelayTimeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PinAuthenticationDelayTimeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * PINVerificationValidityTime in milliseconds
 */
class PinVerificationValidityTimeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PinVerificationValidityTimeUpdate ();

    /**
     * Copy constructor
     */
    inline  PinVerificationValidityTimeUpdate (const PinVerificationValidityTimeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PinVerificationValidityTimeUpdate (uint32 pinVerificationValidityTime_);

    /**
     * Destructor
     */
    inline virtual  ~PinVerificationValidityTimeUpdate();

    /**
     * Assignment operator
     */
    inline PinVerificationValidityTimeUpdate& operator = (const PinVerificationValidityTimeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PinVerificationValidityTimeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PinVerificationValidityTimeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PinVerificationValidityTimeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PinVerificationValidityTimeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pinVerificationValidityTime"

    static const int kPinVerificationValidityTime = 0;

    /**
     * Clears the field "pinVerificationValidityTime".
     *
     * The field will be set to its default value. The hasPinVerificationValidityTime()
     * method will return false.
     */
    inline void clearPinVerificationValidityTime();

    /**
     * Checks whether the field "pinVerificationValidityTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPinVerificationValidityTime()). Otherwise it will return false.
     */
    inline bool hasPinVerificationValidityTime () const;

    /**
     * Returns the value of the member "pinVerificationValidityTime".
     *
     * PINVerificationValidityTime in milliseconds
     *
     * @return The value of the field "pinVerificationValidityTime"
     */
    inline uint32 getPinVerificationValidityTime () const;

    /**
     * Sets the value of the member "pinVerificationValidityTime".
     *
     * PINVerificationValidityTime in milliseconds
     *
     * @param pinVerificationValidityTime The value which will be set
     */
    inline void setPinVerificationValidityTime (uint32 pinVerificationValidityTime_);

    static const PinVerificationValidityTimeUpdate &getDefaultInstance();

private:

    inline void set_has_pinVerificationValidityTime ();

    inline void clear_has_pinVerificationValidityTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _pinVerificationValidityTime;

};

/**
 * PINVerificationValidityTime in milliseconds
 */
class PinVerificationValidityTimeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PinVerificationValidityTimeRegister ();

    /**
     * Copy constructor
     */
    inline  PinVerificationValidityTimeRegister (const PinVerificationValidityTimeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PinVerificationValidityTimeRegister();

    /**
     * Assignment operator
     */
    inline PinVerificationValidityTimeRegister& operator = (const PinVerificationValidityTimeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PinVerificationValidityTimeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PinVerificationValidityTimeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PinVerificationValidityTimeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PinVerificationValidityTimeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PinVerificationValidityTimeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Current Active User Profile Type
 */
class ActiveProfileTypeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveProfileTypeUpdate ();

    /**
     * Copy constructor
     */
    inline  ActiveProfileTypeUpdate (const ActiveProfileTypeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ActiveProfileTypeUpdate (profileType activeProfileType_);

    /**
     * Destructor
     */
    inline virtual  ~ActiveProfileTypeUpdate();

    /**
     * Assignment operator
     */
    inline ActiveProfileTypeUpdate& operator = (const ActiveProfileTypeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveProfileTypeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveProfileTypeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveProfileTypeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveProfileTypeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "activeProfileType"

    static const int kActiveProfileType = 0;

    /**
     * Clears the field "activeProfileType".
     *
     * The field will be set to its default value. The hasActiveProfileType()
     * method will return false.
     */
    inline void clearActiveProfileType();

    /**
     * Checks whether the field "activeProfileType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveProfileType()). Otherwise it will return false.
     */
    inline bool hasActiveProfileType () const;

    /**
     * Returns the value of the member "activeProfileType".
     *
     * Current Active User Profile Type
     *
     * @return The value of the field "activeProfileType"
     */
    inline profileType getActiveProfileType () const;

    /**
     * Sets the value of the member "activeProfileType".
     *
     * Current Active User Profile Type
     *
     * @param activeProfileType The value which will be set
     */
    inline void setActiveProfileType (profileType activeProfileType_);

    static const ActiveProfileTypeUpdate &getDefaultInstance();

private:

    inline void set_has_activeProfileType ();

    inline void clear_has_activeProfileType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    profileType _activeProfileType;

};

/**
 * Current Active User Profile Type
 */
class ActiveProfileTypeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveProfileTypeRegister ();

    /**
     * Copy constructor
     */
    inline  ActiveProfileTypeRegister (const ActiveProfileTypeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ActiveProfileTypeRegister();

    /**
     * Assignment operator
     */
    inline ActiveProfileTypeRegister& operator = (const ActiveProfileTypeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveProfileTypeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveProfileTypeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveProfileTypeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveProfileTypeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ActiveProfileTypeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  copyInfo::copyInfo ()  :
    _source (0u),
    _destination (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  copyInfo::copyInfo (const copyInfo &rhs)  :
    _source (0u),
    _destination (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  copyInfo::copyInfo (uint8 source_, uint8 destination_)  :
    _source (source_),
    _destination (destination_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  copyInfo::~copyInfo() {
}

inline copyInfo& copyInfo::operator = (const copyInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSource()) {
            setSource(rhs.getSource());
        } else {
            clearSource();
        }
        if (rhs.hasDestination()) {
            setDestination(rhs.getDestination());
        } else {
            clearDestination();
        }
    }
    return *this;
}

inline bool copyInfo::operator == (const copyInfo& rhs) const {
    return (((!hasSource() && !rhs.hasSource()) || getSource() == rhs.getSource()) &&
        ((!hasDestination() && !rhs.hasDestination()) || getDestination() == rhs.getDestination()));
}

inline bool copyInfo::operator != (const copyInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool copyInfo::operator < (const copyInfo& rhs) const {
    if (hasSource() || rhs.hasSource()) {
        if (getSource() < rhs.getSource()) return true;
        if (getSource() > rhs.getSource()) return false;
    }
    if (hasDestination() || rhs.hasDestination()) {
        if (getDestination() < rhs.getDestination()) return true;
        if (getDestination() > rhs.getDestination()) return false;
    }
    return false;
}

inline bool copyInfo::operator > (const copyInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void copyInfo::clear() {
    clearSource();
    clearDestination();
}

inline void copyInfo::clearSource() {
    if (hasSource()) {
         clear_has_source();
        _source = 0u;
     }
}

inline bool copyInfo::hasSource () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 copyInfo::getSource () const {
    return _source;
}

inline void copyInfo::setSource (uint8 source_) {
    set_has_source();
    this->_source = source_;
}

inline void copyInfo::clearDestination() {
    if (hasDestination()) {
         clear_has_destination();
        _destination = 0u;
     }
}

inline bool copyInfo::hasDestination () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 copyInfo::getDestination () const {
    return _destination;
}

inline void copyInfo::setDestination (uint8 destination_) {
    set_has_destination();
    this->_destination = destination_;
}

inline void copyInfo::set_has_source () {
    _has_bits_[0] |= 1u << 0;
}

inline void copyInfo::clear_has_source () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void copyInfo::set_has_destination () {
    _has_bits_[0] |= 1u << 1;
}

inline void copyInfo::clear_has_destination () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DoRegisterAppRequest::DoRegisterAppRequest ()  :
    _AppName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoRegisterAppRequest::DoRegisterAppRequest (const DoRegisterAppRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _AppName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoRegisterAppRequest::DoRegisterAppRequest (const ::std::string& AppName_)  :
    _AppName (AppName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AppName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoRegisterAppRequest::~DoRegisterAppRequest() {
}

inline DoRegisterAppRequest& DoRegisterAppRequest::operator = (const DoRegisterAppRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAppName()) {
            setAppName(rhs.getAppName());
        } else {
            clearAppName();
        }
    }
    return *this;
}

inline bool DoRegisterAppRequest::operator == (const DoRegisterAppRequest& rhs) const {
    return (((!hasAppName() && !rhs.hasAppName()) || getAppName() == rhs.getAppName()));
}

inline bool DoRegisterAppRequest::operator != (const DoRegisterAppRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DoRegisterAppRequest::operator < (const DoRegisterAppRequest& rhs) const {
    if (hasAppName() || rhs.hasAppName()) {
        if (getAppName() < rhs.getAppName()) return true;
        if (getAppName() > rhs.getAppName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoRegisterAppRequest::clone() {
    return new DoRegisterAppRequest(*this);
}

inline bool DoRegisterAppRequest::operator > (const DoRegisterAppRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoRegisterAppRequest::clear() {
    clearAppName();
}

inline void DoRegisterAppRequest::clearAppName() {
    if (hasAppName()) {
         clear_has_AppName();
        _AppName.clear();
     }
}

inline bool DoRegisterAppRequest::hasAppName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DoRegisterAppRequest::getAppName () const {
    return _AppName;
}

inline ::std::string& DoRegisterAppRequest::getAppNameMutable () {
    set_has_AppName();
    return _AppName;
}

inline void DoRegisterAppRequest::setAppName (const ::std::string& AppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AppName();
    this->_AppName = AppName_;
}

inline void DoRegisterAppRequest::setAppName (const char* AppName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (AppName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AppName();
    this->_AppName.assign(AppName_);
}

inline void DoRegisterAppRequest::setAppName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_AppName();
    this->_AppName.assign(value, size);
}

inline void DoRegisterAppRequest::set_has_AppName () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoRegisterAppRequest::clear_has_AppName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoRegisterAppResponse::DoRegisterAppResponse ()  :
    _AppID (0u),
    _ApplName (),
    _reloadData (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoRegisterAppResponse::DoRegisterAppResponse (const DoRegisterAppResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _AppID (0u),
    _ApplName (),
    _reloadData (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoRegisterAppResponse::DoRegisterAppResponse (uint32 AppID_, const ::std::string& ApplName_, bool reloadData_)  :
    _AppID (AppID_),
    _ApplName (ApplName_),
    _reloadData (reloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ApplName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoRegisterAppResponse::~DoRegisterAppResponse() {
}

inline DoRegisterAppResponse& DoRegisterAppResponse::operator = (const DoRegisterAppResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAppID()) {
            setAppID(rhs.getAppID());
        } else {
            clearAppID();
        }
        if (rhs.hasApplName()) {
            setApplName(rhs.getApplName());
        } else {
            clearApplName();
        }
        if (rhs.hasReloadData()) {
            setReloadData(rhs.getReloadData());
        } else {
            clearReloadData();
        }
    }
    return *this;
}

inline bool DoRegisterAppResponse::operator == (const DoRegisterAppResponse& rhs) const {
    return (((!hasAppID() && !rhs.hasAppID()) || getAppID() == rhs.getAppID()) &&
        ((!hasApplName() && !rhs.hasApplName()) || getApplName() == rhs.getApplName()) &&
        ((!hasReloadData() && !rhs.hasReloadData()) || getReloadData() == rhs.getReloadData()));
}

inline bool DoRegisterAppResponse::operator != (const DoRegisterAppResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool DoRegisterAppResponse::operator < (const DoRegisterAppResponse& rhs) const {
    if (hasAppID() || rhs.hasAppID()) {
        if (getAppID() < rhs.getAppID()) return true;
        if (getAppID() > rhs.getAppID()) return false;
    }
    if (hasApplName() || rhs.hasApplName()) {
        if (getApplName() < rhs.getApplName()) return true;
        if (getApplName() > rhs.getApplName()) return false;
    }
    if (hasReloadData() || rhs.hasReloadData()) {
        if (getReloadData() < rhs.getReloadData()) return true;
        if (getReloadData() > rhs.getReloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoRegisterAppResponse::clone() {
    return new DoRegisterAppResponse(*this);
}

inline bool DoRegisterAppResponse::operator > (const DoRegisterAppResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoRegisterAppResponse::clear() {
    clearAppID();
    clearApplName();
    clearReloadData();
}

inline void DoRegisterAppResponse::clearAppID() {
    if (hasAppID()) {
         clear_has_AppID();
        _AppID = 0u;
     }
}

inline bool DoRegisterAppResponse::hasAppID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 DoRegisterAppResponse::getAppID () const {
    return _AppID;
}

inline void DoRegisterAppResponse::setAppID (uint32 AppID_) {
    set_has_AppID();
    this->_AppID = AppID_;
}

inline void DoRegisterAppResponse::clearApplName() {
    if (hasApplName()) {
         clear_has_ApplName();
        _ApplName.clear();
     }
}

inline bool DoRegisterAppResponse::hasApplName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& DoRegisterAppResponse::getApplName () const {
    return _ApplName;
}

inline ::std::string& DoRegisterAppResponse::getApplNameMutable () {
    set_has_ApplName();
    return _ApplName;
}

inline void DoRegisterAppResponse::setApplName (const ::std::string& ApplName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ApplName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ApplName();
    this->_ApplName = ApplName_;
}

inline void DoRegisterAppResponse::setApplName (const char* ApplName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ApplName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ApplName();
    this->_ApplName.assign(ApplName_);
}

inline void DoRegisterAppResponse::setApplName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ApplName();
    this->_ApplName.assign(value, size);
}

inline void DoRegisterAppResponse::clearReloadData() {
    if (hasReloadData()) {
         clear_has_reloadData();
        _reloadData = false;
     }
}

inline bool DoRegisterAppResponse::hasReloadData () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool DoRegisterAppResponse::getReloadData () const {
    return _reloadData;
}

inline void DoRegisterAppResponse::setReloadData (bool reloadData_) {
    set_has_reloadData();
    this->_reloadData = reloadData_;
}

inline void DoRegisterAppResponse::set_has_AppID () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoRegisterAppResponse::clear_has_AppID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DoRegisterAppResponse::set_has_ApplName () {
    _has_bits_[0] |= 1u << 1;
}

inline void DoRegisterAppResponse::clear_has_ApplName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DoRegisterAppResponse::set_has_reloadData () {
    _has_bits_[0] |= 1u << 2;
}

inline void DoRegisterAppResponse::clear_has_reloadData () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  OnDataChangedRequest::OnDataChangedRequest ()  :
    _ApplicationPID (0u),
    _Result (::bosch::cm::profile::dataChangedResult__PREPARED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  OnDataChangedRequest::OnDataChangedRequest (const OnDataChangedRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ApplicationPID (0u),
    _Result (::bosch::cm::profile::dataChangedResult__PREPARED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  OnDataChangedRequest::OnDataChangedRequest (uint32 ApplicationPID_, dataChangedResult Result_)  :
    _ApplicationPID (ApplicationPID_),
    _Result (Result_)
{
    #ifndef NDEBUG
    if (!(dataChangedResult_IsValid(Result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Result_, "dataChangedResult", "Result", "OnDataChangedRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  OnDataChangedRequest::~OnDataChangedRequest() {
}

inline OnDataChangedRequest& OnDataChangedRequest::operator = (const OnDataChangedRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasApplicationPID()) {
            setApplicationPID(rhs.getApplicationPID());
        } else {
            clearApplicationPID();
        }
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool OnDataChangedRequest::operator == (const OnDataChangedRequest& rhs) const {
    return (((!hasApplicationPID() && !rhs.hasApplicationPID()) || getApplicationPID() == rhs.getApplicationPID()) &&
        ((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool OnDataChangedRequest::operator != (const OnDataChangedRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool OnDataChangedRequest::operator < (const OnDataChangedRequest& rhs) const {
    if (hasApplicationPID() || rhs.hasApplicationPID()) {
        if (getApplicationPID() < rhs.getApplicationPID()) return true;
        if (getApplicationPID() > rhs.getApplicationPID()) return false;
    }
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* OnDataChangedRequest::clone() {
    return new OnDataChangedRequest(*this);
}

inline bool OnDataChangedRequest::operator > (const OnDataChangedRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void OnDataChangedRequest::clear() {
    clearApplicationPID();
    clearResult();
}

inline void OnDataChangedRequest::clearApplicationPID() {
    if (hasApplicationPID()) {
         clear_has_ApplicationPID();
        _ApplicationPID = 0u;
     }
}

inline bool OnDataChangedRequest::hasApplicationPID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 OnDataChangedRequest::getApplicationPID () const {
    return _ApplicationPID;
}

inline void OnDataChangedRequest::setApplicationPID (uint32 ApplicationPID_) {
    set_has_ApplicationPID();
    this->_ApplicationPID = ApplicationPID_;
}

inline void OnDataChangedRequest::clearResult() {
    if (hasResult()) {
         clear_has_Result();
        _Result = ::bosch::cm::profile::dataChangedResult__PREPARED;
     }
}

inline bool OnDataChangedRequest::hasResult () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline dataChangedResult OnDataChangedRequest::getResult () const {
    return _Result;
}

inline void OnDataChangedRequest::setResult (dataChangedResult Result_) {
    #ifndef NDEBUG
    if (!(dataChangedResult_IsValid(Result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Result_, "dataChangedResult", "Result", "OnDataChangedRequest");
    }
    #endif
    set_has_Result();
    this->_Result = Result_;
}

inline void OnDataChangedRequest::set_has_ApplicationPID () {
    _has_bits_[0] |= 1u << 0;
}

inline void OnDataChangedRequest::clear_has_ApplicationPID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void OnDataChangedRequest::set_has_Result () {
    _has_bits_[0] |= 1u << 1;
}

inline void OnDataChangedRequest::clear_has_Result () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  OnProfileDeletedRequest::OnProfileDeletedRequest ()  :
    _ApplicationPID (0u),
    _Result (::bosch::cm::profile::clientResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  OnProfileDeletedRequest::OnProfileDeletedRequest (const OnProfileDeletedRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ApplicationPID (0u),
    _Result (::bosch::cm::profile::clientResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  OnProfileDeletedRequest::OnProfileDeletedRequest (uint32 ApplicationPID_, clientResult Result_)  :
    _ApplicationPID (ApplicationPID_),
    _Result (Result_)
{
    #ifndef NDEBUG
    if (!(clientResult_IsValid(Result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Result_, "clientResult", "Result", "OnProfileDeletedRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  OnProfileDeletedRequest::~OnProfileDeletedRequest() {
}

inline OnProfileDeletedRequest& OnProfileDeletedRequest::operator = (const OnProfileDeletedRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasApplicationPID()) {
            setApplicationPID(rhs.getApplicationPID());
        } else {
            clearApplicationPID();
        }
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool OnProfileDeletedRequest::operator == (const OnProfileDeletedRequest& rhs) const {
    return (((!hasApplicationPID() && !rhs.hasApplicationPID()) || getApplicationPID() == rhs.getApplicationPID()) &&
        ((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool OnProfileDeletedRequest::operator != (const OnProfileDeletedRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool OnProfileDeletedRequest::operator < (const OnProfileDeletedRequest& rhs) const {
    if (hasApplicationPID() || rhs.hasApplicationPID()) {
        if (getApplicationPID() < rhs.getApplicationPID()) return true;
        if (getApplicationPID() > rhs.getApplicationPID()) return false;
    }
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* OnProfileDeletedRequest::clone() {
    return new OnProfileDeletedRequest(*this);
}

inline bool OnProfileDeletedRequest::operator > (const OnProfileDeletedRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void OnProfileDeletedRequest::clear() {
    clearApplicationPID();
    clearResult();
}

inline void OnProfileDeletedRequest::clearApplicationPID() {
    if (hasApplicationPID()) {
         clear_has_ApplicationPID();
        _ApplicationPID = 0u;
     }
}

inline bool OnProfileDeletedRequest::hasApplicationPID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 OnProfileDeletedRequest::getApplicationPID () const {
    return _ApplicationPID;
}

inline void OnProfileDeletedRequest::setApplicationPID (uint32 ApplicationPID_) {
    set_has_ApplicationPID();
    this->_ApplicationPID = ApplicationPID_;
}

inline void OnProfileDeletedRequest::clearResult() {
    if (hasResult()) {
         clear_has_Result();
        _Result = ::bosch::cm::profile::clientResult__SUCCESS;
     }
}

inline bool OnProfileDeletedRequest::hasResult () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline clientResult OnProfileDeletedRequest::getResult () const {
    return _Result;
}

inline void OnProfileDeletedRequest::setResult (clientResult Result_) {
    #ifndef NDEBUG
    if (!(clientResult_IsValid(Result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Result_, "clientResult", "Result", "OnProfileDeletedRequest");
    }
    #endif
    set_has_Result();
    this->_Result = Result_;
}

inline void OnProfileDeletedRequest::set_has_ApplicationPID () {
    _has_bits_[0] |= 1u << 0;
}

inline void OnProfileDeletedRequest::clear_has_ApplicationPID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void OnProfileDeletedRequest::set_has_Result () {
    _has_bits_[0] |= 1u << 1;
}

inline void OnProfileDeletedRequest::clear_has_Result () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  OnProfileCopiedRequest::OnProfileCopiedRequest ()  :
    _ApplicationPID (0u),
    _Result (::bosch::cm::profile::clientResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  OnProfileCopiedRequest::OnProfileCopiedRequest (const OnProfileCopiedRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ApplicationPID (0u),
    _Result (::bosch::cm::profile::clientResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  OnProfileCopiedRequest::OnProfileCopiedRequest (uint32 ApplicationPID_, clientResult Result_)  :
    _ApplicationPID (ApplicationPID_),
    _Result (Result_)
{
    #ifndef NDEBUG
    if (!(clientResult_IsValid(Result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Result_, "clientResult", "Result", "OnProfileCopiedRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  OnProfileCopiedRequest::~OnProfileCopiedRequest() {
}

inline OnProfileCopiedRequest& OnProfileCopiedRequest::operator = (const OnProfileCopiedRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasApplicationPID()) {
            setApplicationPID(rhs.getApplicationPID());
        } else {
            clearApplicationPID();
        }
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool OnProfileCopiedRequest::operator == (const OnProfileCopiedRequest& rhs) const {
    return (((!hasApplicationPID() && !rhs.hasApplicationPID()) || getApplicationPID() == rhs.getApplicationPID()) &&
        ((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool OnProfileCopiedRequest::operator != (const OnProfileCopiedRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool OnProfileCopiedRequest::operator < (const OnProfileCopiedRequest& rhs) const {
    if (hasApplicationPID() || rhs.hasApplicationPID()) {
        if (getApplicationPID() < rhs.getApplicationPID()) return true;
        if (getApplicationPID() > rhs.getApplicationPID()) return false;
    }
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* OnProfileCopiedRequest::clone() {
    return new OnProfileCopiedRequest(*this);
}

inline bool OnProfileCopiedRequest::operator > (const OnProfileCopiedRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void OnProfileCopiedRequest::clear() {
    clearApplicationPID();
    clearResult();
}

inline void OnProfileCopiedRequest::clearApplicationPID() {
    if (hasApplicationPID()) {
         clear_has_ApplicationPID();
        _ApplicationPID = 0u;
     }
}

inline bool OnProfileCopiedRequest::hasApplicationPID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 OnProfileCopiedRequest::getApplicationPID () const {
    return _ApplicationPID;
}

inline void OnProfileCopiedRequest::setApplicationPID (uint32 ApplicationPID_) {
    set_has_ApplicationPID();
    this->_ApplicationPID = ApplicationPID_;
}

inline void OnProfileCopiedRequest::clearResult() {
    if (hasResult()) {
         clear_has_Result();
        _Result = ::bosch::cm::profile::clientResult__SUCCESS;
     }
}

inline bool OnProfileCopiedRequest::hasResult () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline clientResult OnProfileCopiedRequest::getResult () const {
    return _Result;
}

inline void OnProfileCopiedRequest::setResult (clientResult Result_) {
    #ifndef NDEBUG
    if (!(clientResult_IsValid(Result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Result_, "clientResult", "Result", "OnProfileCopiedRequest");
    }
    #endif
    set_has_Result();
    this->_Result = Result_;
}

inline void OnProfileCopiedRequest::set_has_ApplicationPID () {
    _has_bits_[0] |= 1u << 0;
}

inline void OnProfileCopiedRequest::clear_has_ApplicationPID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void OnProfileCopiedRequest::set_has_Result () {
    _has_bits_[0] |= 1u << 1;
}

inline void OnProfileCopiedRequest::clear_has_Result () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  OnProfileCreatedRequest::OnProfileCreatedRequest ()  :
    _ApplicationPID (0u),
    _Result (::bosch::cm::profile::clientResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  OnProfileCreatedRequest::OnProfileCreatedRequest (const OnProfileCreatedRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _ApplicationPID (0u),
    _Result (::bosch::cm::profile::clientResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  OnProfileCreatedRequest::OnProfileCreatedRequest (uint32 ApplicationPID_, clientResult Result_)  :
    _ApplicationPID (ApplicationPID_),
    _Result (Result_)
{
    #ifndef NDEBUG
    if (!(clientResult_IsValid(Result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Result_, "clientResult", "Result", "OnProfileCreatedRequest");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  OnProfileCreatedRequest::~OnProfileCreatedRequest() {
}

inline OnProfileCreatedRequest& OnProfileCreatedRequest::operator = (const OnProfileCreatedRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasApplicationPID()) {
            setApplicationPID(rhs.getApplicationPID());
        } else {
            clearApplicationPID();
        }
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool OnProfileCreatedRequest::operator == (const OnProfileCreatedRequest& rhs) const {
    return (((!hasApplicationPID() && !rhs.hasApplicationPID()) || getApplicationPID() == rhs.getApplicationPID()) &&
        ((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool OnProfileCreatedRequest::operator != (const OnProfileCreatedRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool OnProfileCreatedRequest::operator < (const OnProfileCreatedRequest& rhs) const {
    if (hasApplicationPID() || rhs.hasApplicationPID()) {
        if (getApplicationPID() < rhs.getApplicationPID()) return true;
        if (getApplicationPID() > rhs.getApplicationPID()) return false;
    }
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* OnProfileCreatedRequest::clone() {
    return new OnProfileCreatedRequest(*this);
}

inline bool OnProfileCreatedRequest::operator > (const OnProfileCreatedRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void OnProfileCreatedRequest::clear() {
    clearApplicationPID();
    clearResult();
}

inline void OnProfileCreatedRequest::clearApplicationPID() {
    if (hasApplicationPID()) {
         clear_has_ApplicationPID();
        _ApplicationPID = 0u;
     }
}

inline bool OnProfileCreatedRequest::hasApplicationPID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 OnProfileCreatedRequest::getApplicationPID () const {
    return _ApplicationPID;
}

inline void OnProfileCreatedRequest::setApplicationPID (uint32 ApplicationPID_) {
    set_has_ApplicationPID();
    this->_ApplicationPID = ApplicationPID_;
}

inline void OnProfileCreatedRequest::clearResult() {
    if (hasResult()) {
         clear_has_Result();
        _Result = ::bosch::cm::profile::clientResult__SUCCESS;
     }
}

inline bool OnProfileCreatedRequest::hasResult () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline clientResult OnProfileCreatedRequest::getResult () const {
    return _Result;
}

inline void OnProfileCreatedRequest::setResult (clientResult Result_) {
    #ifndef NDEBUG
    if (!(clientResult_IsValid(Result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Result_, "clientResult", "Result", "OnProfileCreatedRequest");
    }
    #endif
    set_has_Result();
    this->_Result = Result_;
}

inline void OnProfileCreatedRequest::set_has_ApplicationPID () {
    _has_bits_[0] |= 1u << 0;
}

inline void OnProfileCreatedRequest::clear_has_ApplicationPID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void OnProfileCreatedRequest::set_has_Result () {
    _has_bits_[0] |= 1u << 1;
}

inline void OnProfileCreatedRequest::clear_has_Result () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DoCopyProfileRequest::DoCopyProfileRequest ()  :
    _sourceUserID (0u),
    _destUserID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoCopyProfileRequest::DoCopyProfileRequest (const DoCopyProfileRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _sourceUserID (0u),
    _destUserID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoCopyProfileRequest::DoCopyProfileRequest (uint8 sourceUserID_, uint8 destUserID_)  :
    _sourceUserID (sourceUserID_),
    _destUserID (destUserID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoCopyProfileRequest::~DoCopyProfileRequest() {
}

inline DoCopyProfileRequest& DoCopyProfileRequest::operator = (const DoCopyProfileRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSourceUserID()) {
            setSourceUserID(rhs.getSourceUserID());
        } else {
            clearSourceUserID();
        }
        if (rhs.hasDestUserID()) {
            setDestUserID(rhs.getDestUserID());
        } else {
            clearDestUserID();
        }
    }
    return *this;
}

inline bool DoCopyProfileRequest::operator == (const DoCopyProfileRequest& rhs) const {
    return (((!hasSourceUserID() && !rhs.hasSourceUserID()) || getSourceUserID() == rhs.getSourceUserID()) &&
        ((!hasDestUserID() && !rhs.hasDestUserID()) || getDestUserID() == rhs.getDestUserID()));
}

inline bool DoCopyProfileRequest::operator != (const DoCopyProfileRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DoCopyProfileRequest::operator < (const DoCopyProfileRequest& rhs) const {
    if (hasSourceUserID() || rhs.hasSourceUserID()) {
        if (getSourceUserID() < rhs.getSourceUserID()) return true;
        if (getSourceUserID() > rhs.getSourceUserID()) return false;
    }
    if (hasDestUserID() || rhs.hasDestUserID()) {
        if (getDestUserID() < rhs.getDestUserID()) return true;
        if (getDestUserID() > rhs.getDestUserID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoCopyProfileRequest::clone() {
    return new DoCopyProfileRequest(*this);
}

inline bool DoCopyProfileRequest::operator > (const DoCopyProfileRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoCopyProfileRequest::clear() {
    clearSourceUserID();
    clearDestUserID();
}

inline void DoCopyProfileRequest::clearSourceUserID() {
    if (hasSourceUserID()) {
         clear_has_sourceUserID();
        _sourceUserID = 0u;
     }
}

inline bool DoCopyProfileRequest::hasSourceUserID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DoCopyProfileRequest::getSourceUserID () const {
    return _sourceUserID;
}

inline void DoCopyProfileRequest::setSourceUserID (uint8 sourceUserID_) {
    set_has_sourceUserID();
    this->_sourceUserID = sourceUserID_;
}

inline void DoCopyProfileRequest::clearDestUserID() {
    if (hasDestUserID()) {
         clear_has_destUserID();
        _destUserID = 0u;
     }
}

inline bool DoCopyProfileRequest::hasDestUserID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 DoCopyProfileRequest::getDestUserID () const {
    return _destUserID;
}

inline void DoCopyProfileRequest::setDestUserID (uint8 destUserID_) {
    set_has_destUserID();
    this->_destUserID = destUserID_;
}

inline void DoCopyProfileRequest::set_has_sourceUserID () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoCopyProfileRequest::clear_has_sourceUserID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DoCopyProfileRequest::set_has_destUserID () {
    _has_bits_[0] |= 1u << 1;
}

inline void DoCopyProfileRequest::clear_has_destUserID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DoCopyProfileResponse::DoCopyProfileResponse ()  :
    _Result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoCopyProfileResponse::DoCopyProfileResponse (const DoCopyProfileResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _Result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoCopyProfileResponse::DoCopyProfileResponse (serverResult Result_)  :
    _Result (Result_)
{
    #ifndef NDEBUG
    if (!(serverResult_IsValid(Result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Result_, "serverResult", "Result", "DoCopyProfileResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoCopyProfileResponse::~DoCopyProfileResponse() {
}

inline DoCopyProfileResponse& DoCopyProfileResponse::operator = (const DoCopyProfileResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool DoCopyProfileResponse::operator == (const DoCopyProfileResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool DoCopyProfileResponse::operator != (const DoCopyProfileResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool DoCopyProfileResponse::operator < (const DoCopyProfileResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoCopyProfileResponse::clone() {
    return new DoCopyProfileResponse(*this);
}

inline bool DoCopyProfileResponse::operator > (const DoCopyProfileResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoCopyProfileResponse::clear() {
    clearResult();
}

inline void DoCopyProfileResponse::clearResult() {
    if (hasResult()) {
         clear_has_Result();
        _Result = ::bosch::cm::profile::serverResult__SUCCESS;
     }
}

inline bool DoCopyProfileResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline serverResult DoCopyProfileResponse::getResult () const {
    return _Result;
}

inline void DoCopyProfileResponse::setResult (serverResult Result_) {
    #ifndef NDEBUG
    if (!(serverResult_IsValid(Result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Result_, "serverResult", "Result", "DoCopyProfileResponse");
    }
    #endif
    set_has_Result();
    this->_Result = Result_;
}

inline void DoCopyProfileResponse::set_has_Result () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoCopyProfileResponse::clear_has_Result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoDeleteProfileRequest::DoDeleteProfileRequest ()  :
    _userID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoDeleteProfileRequest::DoDeleteProfileRequest (const DoDeleteProfileRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _userID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoDeleteProfileRequest::DoDeleteProfileRequest (uint8 userID_)  :
    _userID (userID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoDeleteProfileRequest::~DoDeleteProfileRequest() {
}

inline DoDeleteProfileRequest& DoDeleteProfileRequest::operator = (const DoDeleteProfileRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUserID()) {
            setUserID(rhs.getUserID());
        } else {
            clearUserID();
        }
    }
    return *this;
}

inline bool DoDeleteProfileRequest::operator == (const DoDeleteProfileRequest& rhs) const {
    return (((!hasUserID() && !rhs.hasUserID()) || getUserID() == rhs.getUserID()));
}

inline bool DoDeleteProfileRequest::operator != (const DoDeleteProfileRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DoDeleteProfileRequest::operator < (const DoDeleteProfileRequest& rhs) const {
    if (hasUserID() || rhs.hasUserID()) {
        if (getUserID() < rhs.getUserID()) return true;
        if (getUserID() > rhs.getUserID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoDeleteProfileRequest::clone() {
    return new DoDeleteProfileRequest(*this);
}

inline bool DoDeleteProfileRequest::operator > (const DoDeleteProfileRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoDeleteProfileRequest::clear() {
    clearUserID();
}

inline void DoDeleteProfileRequest::clearUserID() {
    if (hasUserID()) {
         clear_has_userID();
        _userID = 0u;
     }
}

inline bool DoDeleteProfileRequest::hasUserID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DoDeleteProfileRequest::getUserID () const {
    return _userID;
}

inline void DoDeleteProfileRequest::setUserID (uint8 userID_) {
    set_has_userID();
    this->_userID = userID_;
}

inline void DoDeleteProfileRequest::set_has_userID () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoDeleteProfileRequest::clear_has_userID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoDeleteProfileResponse::DoDeleteProfileResponse ()  :
    _Result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoDeleteProfileResponse::DoDeleteProfileResponse (const DoDeleteProfileResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _Result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoDeleteProfileResponse::DoDeleteProfileResponse (serverResult Result_)  :
    _Result (Result_)
{
    #ifndef NDEBUG
    if (!(serverResult_IsValid(Result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Result_, "serverResult", "Result", "DoDeleteProfileResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoDeleteProfileResponse::~DoDeleteProfileResponse() {
}

inline DoDeleteProfileResponse& DoDeleteProfileResponse::operator = (const DoDeleteProfileResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool DoDeleteProfileResponse::operator == (const DoDeleteProfileResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool DoDeleteProfileResponse::operator != (const DoDeleteProfileResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool DoDeleteProfileResponse::operator < (const DoDeleteProfileResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoDeleteProfileResponse::clone() {
    return new DoDeleteProfileResponse(*this);
}

inline bool DoDeleteProfileResponse::operator > (const DoDeleteProfileResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoDeleteProfileResponse::clear() {
    clearResult();
}

inline void DoDeleteProfileResponse::clearResult() {
    if (hasResult()) {
         clear_has_Result();
        _Result = ::bosch::cm::profile::serverResult__SUCCESS;
     }
}

inline bool DoDeleteProfileResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline serverResult DoDeleteProfileResponse::getResult () const {
    return _Result;
}

inline void DoDeleteProfileResponse::setResult (serverResult Result_) {
    #ifndef NDEBUG
    if (!(serverResult_IsValid(Result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Result_, "serverResult", "Result", "DoDeleteProfileResponse");
    }
    #endif
    set_has_Result();
    this->_Result = Result_;
}

inline void DoDeleteProfileResponse::set_has_Result () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoDeleteProfileResponse::clear_has_Result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoChangeToProfileRequest::DoChangeToProfileRequest ()  :
    _userID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoChangeToProfileRequest::DoChangeToProfileRequest (const DoChangeToProfileRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _userID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoChangeToProfileRequest::DoChangeToProfileRequest (uint8 userID_)  :
    _userID (userID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoChangeToProfileRequest::~DoChangeToProfileRequest() {
}

inline DoChangeToProfileRequest& DoChangeToProfileRequest::operator = (const DoChangeToProfileRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUserID()) {
            setUserID(rhs.getUserID());
        } else {
            clearUserID();
        }
    }
    return *this;
}

inline bool DoChangeToProfileRequest::operator == (const DoChangeToProfileRequest& rhs) const {
    return (((!hasUserID() && !rhs.hasUserID()) || getUserID() == rhs.getUserID()));
}

inline bool DoChangeToProfileRequest::operator != (const DoChangeToProfileRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DoChangeToProfileRequest::operator < (const DoChangeToProfileRequest& rhs) const {
    if (hasUserID() || rhs.hasUserID()) {
        if (getUserID() < rhs.getUserID()) return true;
        if (getUserID() > rhs.getUserID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoChangeToProfileRequest::clone() {
    return new DoChangeToProfileRequest(*this);
}

inline bool DoChangeToProfileRequest::operator > (const DoChangeToProfileRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoChangeToProfileRequest::clear() {
    clearUserID();
}

inline void DoChangeToProfileRequest::clearUserID() {
    if (hasUserID()) {
         clear_has_userID();
        _userID = 0u;
     }
}

inline bool DoChangeToProfileRequest::hasUserID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DoChangeToProfileRequest::getUserID () const {
    return _userID;
}

inline void DoChangeToProfileRequest::setUserID (uint8 userID_) {
    set_has_userID();
    this->_userID = userID_;
}

inline void DoChangeToProfileRequest::set_has_userID () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoChangeToProfileRequest::clear_has_userID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoChangeToProfileResponse::DoChangeToProfileResponse ()  :
    _Result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoChangeToProfileResponse::DoChangeToProfileResponse (const DoChangeToProfileResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _Result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoChangeToProfileResponse::DoChangeToProfileResponse (serverResult Result_)  :
    _Result (Result_)
{
    #ifndef NDEBUG
    if (!(serverResult_IsValid(Result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Result_, "serverResult", "Result", "DoChangeToProfileResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoChangeToProfileResponse::~DoChangeToProfileResponse() {
}

inline DoChangeToProfileResponse& DoChangeToProfileResponse::operator = (const DoChangeToProfileResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool DoChangeToProfileResponse::operator == (const DoChangeToProfileResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool DoChangeToProfileResponse::operator != (const DoChangeToProfileResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool DoChangeToProfileResponse::operator < (const DoChangeToProfileResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoChangeToProfileResponse::clone() {
    return new DoChangeToProfileResponse(*this);
}

inline bool DoChangeToProfileResponse::operator > (const DoChangeToProfileResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoChangeToProfileResponse::clear() {
    clearResult();
}

inline void DoChangeToProfileResponse::clearResult() {
    if (hasResult()) {
         clear_has_Result();
        _Result = ::bosch::cm::profile::serverResult__SUCCESS;
     }
}

inline bool DoChangeToProfileResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline serverResult DoChangeToProfileResponse::getResult () const {
    return _Result;
}

inline void DoChangeToProfileResponse::setResult (serverResult Result_) {
    #ifndef NDEBUG
    if (!(serverResult_IsValid(Result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Result_, "serverResult", "Result", "DoChangeToProfileResponse");
    }
    #endif
    set_has_Result();
    this->_Result = Result_;
}

inline void DoChangeToProfileResponse::set_has_Result () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoChangeToProfileResponse::clear_has_Result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoCreateProfileRequest::DoCreateProfileRequest ()  :
    _newName (),
    _imageID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoCreateProfileRequest::DoCreateProfileRequest (const DoCreateProfileRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _newName (),
    _imageID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoCreateProfileRequest::DoCreateProfileRequest (const ::std::string& newName_, uint8 imageID_)  :
    _newName (newName_),
    _imageID (imageID_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (newName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoCreateProfileRequest::~DoCreateProfileRequest() {
}

inline DoCreateProfileRequest& DoCreateProfileRequest::operator = (const DoCreateProfileRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNewName()) {
            setNewName(rhs.getNewName());
        } else {
            clearNewName();
        }
        if (rhs.hasImageID()) {
            setImageID(rhs.getImageID());
        } else {
            clearImageID();
        }
    }
    return *this;
}

inline bool DoCreateProfileRequest::operator == (const DoCreateProfileRequest& rhs) const {
    return (((!hasNewName() && !rhs.hasNewName()) || getNewName() == rhs.getNewName()) &&
        ((!hasImageID() && !rhs.hasImageID()) || getImageID() == rhs.getImageID()));
}

inline bool DoCreateProfileRequest::operator != (const DoCreateProfileRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DoCreateProfileRequest::operator < (const DoCreateProfileRequest& rhs) const {
    if (hasNewName() || rhs.hasNewName()) {
        if (getNewName() < rhs.getNewName()) return true;
        if (getNewName() > rhs.getNewName()) return false;
    }
    if (hasImageID() || rhs.hasImageID()) {
        if (getImageID() < rhs.getImageID()) return true;
        if (getImageID() > rhs.getImageID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoCreateProfileRequest::clone() {
    return new DoCreateProfileRequest(*this);
}

inline bool DoCreateProfileRequest::operator > (const DoCreateProfileRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoCreateProfileRequest::clear() {
    clearNewName();
    clearImageID();
}

inline void DoCreateProfileRequest::clearNewName() {
    if (hasNewName()) {
         clear_has_newName();
        _newName.clear();
     }
}

inline bool DoCreateProfileRequest::hasNewName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DoCreateProfileRequest::getNewName () const {
    return _newName;
}

inline ::std::string& DoCreateProfileRequest::getNewNameMutable () {
    set_has_newName();
    return _newName;
}

inline void DoCreateProfileRequest::setNewName (const ::std::string& newName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (newName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_newName();
    this->_newName = newName_;
}

inline void DoCreateProfileRequest::setNewName (const char* newName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (newName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_newName();
    this->_newName.assign(newName_);
}

inline void DoCreateProfileRequest::setNewName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_newName();
    this->_newName.assign(value, size);
}

inline void DoCreateProfileRequest::clearImageID() {
    if (hasImageID()) {
         clear_has_imageID();
        _imageID = 0u;
     }
}

inline bool DoCreateProfileRequest::hasImageID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 DoCreateProfileRequest::getImageID () const {
    return _imageID;
}

inline void DoCreateProfileRequest::setImageID (uint8 imageID_) {
    set_has_imageID();
    this->_imageID = imageID_;
}

inline void DoCreateProfileRequest::set_has_newName () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoCreateProfileRequest::clear_has_newName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DoCreateProfileRequest::set_has_imageID () {
    _has_bits_[0] |= 1u << 1;
}

inline void DoCreateProfileRequest::clear_has_imageID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DoCreateProfileResponse::DoCreateProfileResponse ()  :
    _Result (::bosch::cm::profile::serverResult__SUCCESS),
    _newUserID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoCreateProfileResponse::DoCreateProfileResponse (const DoCreateProfileResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _Result (::bosch::cm::profile::serverResult__SUCCESS),
    _newUserID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoCreateProfileResponse::DoCreateProfileResponse (serverResult Result_, uint8 newUserID_)  :
    _Result (Result_),
    _newUserID (newUserID_)
{
    #ifndef NDEBUG
    if (!(serverResult_IsValid(Result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Result_, "serverResult", "Result", "DoCreateProfileResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoCreateProfileResponse::~DoCreateProfileResponse() {
}

inline DoCreateProfileResponse& DoCreateProfileResponse::operator = (const DoCreateProfileResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
        if (rhs.hasNewUserID()) {
            setNewUserID(rhs.getNewUserID());
        } else {
            clearNewUserID();
        }
    }
    return *this;
}

inline bool DoCreateProfileResponse::operator == (const DoCreateProfileResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()) &&
        ((!hasNewUserID() && !rhs.hasNewUserID()) || getNewUserID() == rhs.getNewUserID()));
}

inline bool DoCreateProfileResponse::operator != (const DoCreateProfileResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool DoCreateProfileResponse::operator < (const DoCreateProfileResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    if (hasNewUserID() || rhs.hasNewUserID()) {
        if (getNewUserID() < rhs.getNewUserID()) return true;
        if (getNewUserID() > rhs.getNewUserID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoCreateProfileResponse::clone() {
    return new DoCreateProfileResponse(*this);
}

inline bool DoCreateProfileResponse::operator > (const DoCreateProfileResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoCreateProfileResponse::clear() {
    clearResult();
    clearNewUserID();
}

inline void DoCreateProfileResponse::clearResult() {
    if (hasResult()) {
         clear_has_Result();
        _Result = ::bosch::cm::profile::serverResult__SUCCESS;
     }
}

inline bool DoCreateProfileResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline serverResult DoCreateProfileResponse::getResult () const {
    return _Result;
}

inline void DoCreateProfileResponse::setResult (serverResult Result_) {
    #ifndef NDEBUG
    if (!(serverResult_IsValid(Result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Result_, "serverResult", "Result", "DoCreateProfileResponse");
    }
    #endif
    set_has_Result();
    this->_Result = Result_;
}

inline void DoCreateProfileResponse::clearNewUserID() {
    if (hasNewUserID()) {
         clear_has_newUserID();
        _newUserID = 0u;
     }
}

inline bool DoCreateProfileResponse::hasNewUserID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 DoCreateProfileResponse::getNewUserID () const {
    return _newUserID;
}

inline void DoCreateProfileResponse::setNewUserID (uint8 newUserID_) {
    set_has_newUserID();
    this->_newUserID = newUserID_;
}

inline void DoCreateProfileResponse::set_has_Result () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoCreateProfileResponse::clear_has_Result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DoCreateProfileResponse::set_has_newUserID () {
    _has_bits_[0] |= 1u << 1;
}

inline void DoCreateProfileResponse::clear_has_newUserID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Do_SetProfileNameRequest::Do_SetProfileNameRequest ()  :
    _newName (),
    _userID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Do_SetProfileNameRequest::Do_SetProfileNameRequest (const Do_SetProfileNameRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _newName (),
    _userID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Do_SetProfileNameRequest::Do_SetProfileNameRequest (const ::std::string& newName_, uint8 userID_)  :
    _newName (newName_),
    _userID (userID_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (newName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Do_SetProfileNameRequest::~Do_SetProfileNameRequest() {
}

inline Do_SetProfileNameRequest& Do_SetProfileNameRequest::operator = (const Do_SetProfileNameRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNewName()) {
            setNewName(rhs.getNewName());
        } else {
            clearNewName();
        }
        if (rhs.hasUserID()) {
            setUserID(rhs.getUserID());
        } else {
            clearUserID();
        }
    }
    return *this;
}

inline bool Do_SetProfileNameRequest::operator == (const Do_SetProfileNameRequest& rhs) const {
    return (((!hasNewName() && !rhs.hasNewName()) || getNewName() == rhs.getNewName()) &&
        ((!hasUserID() && !rhs.hasUserID()) || getUserID() == rhs.getUserID()));
}

inline bool Do_SetProfileNameRequest::operator != (const Do_SetProfileNameRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool Do_SetProfileNameRequest::operator < (const Do_SetProfileNameRequest& rhs) const {
    if (hasNewName() || rhs.hasNewName()) {
        if (getNewName() < rhs.getNewName()) return true;
        if (getNewName() > rhs.getNewName()) return false;
    }
    if (hasUserID() || rhs.hasUserID()) {
        if (getUserID() < rhs.getUserID()) return true;
        if (getUserID() > rhs.getUserID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Do_SetProfileNameRequest::clone() {
    return new Do_SetProfileNameRequest(*this);
}

inline bool Do_SetProfileNameRequest::operator > (const Do_SetProfileNameRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Do_SetProfileNameRequest::clear() {
    clearNewName();
    clearUserID();
}

inline void Do_SetProfileNameRequest::clearNewName() {
    if (hasNewName()) {
         clear_has_newName();
        _newName.clear();
     }
}

inline bool Do_SetProfileNameRequest::hasNewName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& Do_SetProfileNameRequest::getNewName () const {
    return _newName;
}

inline ::std::string& Do_SetProfileNameRequest::getNewNameMutable () {
    set_has_newName();
    return _newName;
}

inline void Do_SetProfileNameRequest::setNewName (const ::std::string& newName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (newName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_newName();
    this->_newName = newName_;
}

inline void Do_SetProfileNameRequest::setNewName (const char* newName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (newName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_newName();
    this->_newName.assign(newName_);
}

inline void Do_SetProfileNameRequest::setNewName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_newName();
    this->_newName.assign(value, size);
}

inline void Do_SetProfileNameRequest::clearUserID() {
    if (hasUserID()) {
         clear_has_userID();
        _userID = 0u;
     }
}

inline bool Do_SetProfileNameRequest::hasUserID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 Do_SetProfileNameRequest::getUserID () const {
    return _userID;
}

inline void Do_SetProfileNameRequest::setUserID (uint8 userID_) {
    set_has_userID();
    this->_userID = userID_;
}

inline void Do_SetProfileNameRequest::set_has_newName () {
    _has_bits_[0] |= 1u << 0;
}

inline void Do_SetProfileNameRequest::clear_has_newName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Do_SetProfileNameRequest::set_has_userID () {
    _has_bits_[0] |= 1u << 1;
}

inline void Do_SetProfileNameRequest::clear_has_userID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Do_SetProfileNameResponse::Do_SetProfileNameResponse ()  :
    _Result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Do_SetProfileNameResponse::Do_SetProfileNameResponse (const Do_SetProfileNameResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _Result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Do_SetProfileNameResponse::Do_SetProfileNameResponse (serverResult Result_)  :
    _Result (Result_)
{
    #ifndef NDEBUG
    if (!(serverResult_IsValid(Result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Result_, "serverResult", "Result", "Do_SetProfileNameResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Do_SetProfileNameResponse::~Do_SetProfileNameResponse() {
}

inline Do_SetProfileNameResponse& Do_SetProfileNameResponse::operator = (const Do_SetProfileNameResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool Do_SetProfileNameResponse::operator == (const Do_SetProfileNameResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool Do_SetProfileNameResponse::operator != (const Do_SetProfileNameResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool Do_SetProfileNameResponse::operator < (const Do_SetProfileNameResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Do_SetProfileNameResponse::clone() {
    return new Do_SetProfileNameResponse(*this);
}

inline bool Do_SetProfileNameResponse::operator > (const Do_SetProfileNameResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Do_SetProfileNameResponse::clear() {
    clearResult();
}

inline void Do_SetProfileNameResponse::clearResult() {
    if (hasResult()) {
         clear_has_Result();
        _Result = ::bosch::cm::profile::serverResult__SUCCESS;
     }
}

inline bool Do_SetProfileNameResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline serverResult Do_SetProfileNameResponse::getResult () const {
    return _Result;
}

inline void Do_SetProfileNameResponse::setResult (serverResult Result_) {
    #ifndef NDEBUG
    if (!(serverResult_IsValid(Result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Result_, "serverResult", "Result", "Do_SetProfileNameResponse");
    }
    #endif
    set_has_Result();
    this->_Result = Result_;
}

inline void Do_SetProfileNameResponse::set_has_Result () {
    _has_bits_[0] |= 1u << 0;
}

inline void Do_SetProfileNameResponse::clear_has_Result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetProfileNamesResponse::GetProfileNamesResponse ()  :
    _names ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetProfileNamesResponse::GetProfileNamesResponse (const GetProfileNamesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _names ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetProfileNamesResponse::GetProfileNamesResponse (const ::std::vector< ::std::string >& names_)  :
    _names (names_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetProfileNamesResponse::~GetProfileNamesResponse() {
}

inline GetProfileNamesResponse& GetProfileNamesResponse::operator = (const GetProfileNamesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNames()) {
            setNames(rhs.getNames());
        } else {
            clearNames();
        }
    }
    return *this;
}

inline bool GetProfileNamesResponse::operator == (const GetProfileNamesResponse& rhs) const {
    return (((!hasNames() && !rhs.hasNames()) || getNames() == rhs.getNames()));
}

inline bool GetProfileNamesResponse::operator != (const GetProfileNamesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetProfileNamesResponse::operator < (const GetProfileNamesResponse& rhs) const {
    if (hasNames() || rhs.hasNames()) {
        if (getNames() < rhs.getNames()) return true;
        if (getNames() > rhs.getNames()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetProfileNamesResponse::clone() {
    return new GetProfileNamesResponse(*this);
}

inline bool GetProfileNamesResponse::operator > (const GetProfileNamesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetProfileNamesResponse::clear() {
    clearNames();
}

inline void GetProfileNamesResponse::clearNames() {
    if (hasNames()) {
         clear_has_names();
        _names.clear();
     }
}

inline bool GetProfileNamesResponse::hasNames () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& GetProfileNamesResponse::getNames () const {
    return _names;
}

inline ::std::vector< ::std::string >& GetProfileNamesResponse::getNamesMutable () {
    set_has_names();
    return _names;
}

inline void GetProfileNamesResponse::setNames (const ::std::vector< ::std::string >& names_) {
    set_has_names();
    this->_names = names_;
}

inline void GetProfileNamesResponse::set_has_names () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetProfileNamesResponse::clear_has_names () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoImportProfileImageRequest::DoImportProfileImageRequest ()  :
    _sourcePath (),
    _width (0u),
    _height (0u),
    _slotIdx (0u),
    _bSetForCurrentProfile (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoImportProfileImageRequest::DoImportProfileImageRequest (const DoImportProfileImageRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _sourcePath (),
    _width (0u),
    _height (0u),
    _slotIdx (0u),
    _bSetForCurrentProfile (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoImportProfileImageRequest::DoImportProfileImageRequest (const ::std::string& sourcePath_, uint16 width_, uint16 height_, uint16 slotIdx_, bool bSetForCurrentProfile_)  :
    _sourcePath (sourcePath_),
    _width (width_),
    _height (height_),
    _slotIdx (slotIdx_),
    _bSetForCurrentProfile (bSetForCurrentProfile_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sourcePath_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoImportProfileImageRequest::~DoImportProfileImageRequest() {
}

inline DoImportProfileImageRequest& DoImportProfileImageRequest::operator = (const DoImportProfileImageRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSourcePath()) {
            setSourcePath(rhs.getSourcePath());
        } else {
            clearSourcePath();
        }
        if (rhs.hasWidth()) {
            setWidth(rhs.getWidth());
        } else {
            clearWidth();
        }
        if (rhs.hasHeight()) {
            setHeight(rhs.getHeight());
        } else {
            clearHeight();
        }
        if (rhs.hasSlotIdx()) {
            setSlotIdx(rhs.getSlotIdx());
        } else {
            clearSlotIdx();
        }
        if (rhs.hasBSetForCurrentProfile()) {
            setBSetForCurrentProfile(rhs.getBSetForCurrentProfile());
        } else {
            clearBSetForCurrentProfile();
        }
    }
    return *this;
}

inline bool DoImportProfileImageRequest::operator == (const DoImportProfileImageRequest& rhs) const {
    return (((!hasSourcePath() && !rhs.hasSourcePath()) || getSourcePath() == rhs.getSourcePath()) &&
        ((!hasWidth() && !rhs.hasWidth()) || getWidth() == rhs.getWidth()) &&
        ((!hasHeight() && !rhs.hasHeight()) || getHeight() == rhs.getHeight()) &&
        ((!hasSlotIdx() && !rhs.hasSlotIdx()) || getSlotIdx() == rhs.getSlotIdx()) &&
        ((!hasBSetForCurrentProfile() && !rhs.hasBSetForCurrentProfile()) || getBSetForCurrentProfile() == rhs.getBSetForCurrentProfile()));
}

inline bool DoImportProfileImageRequest::operator != (const DoImportProfileImageRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DoImportProfileImageRequest::operator < (const DoImportProfileImageRequest& rhs) const {
    if (hasSourcePath() || rhs.hasSourcePath()) {
        if (getSourcePath() < rhs.getSourcePath()) return true;
        if (getSourcePath() > rhs.getSourcePath()) return false;
    }
    if (hasWidth() || rhs.hasWidth()) {
        if (getWidth() < rhs.getWidth()) return true;
        if (getWidth() > rhs.getWidth()) return false;
    }
    if (hasHeight() || rhs.hasHeight()) {
        if (getHeight() < rhs.getHeight()) return true;
        if (getHeight() > rhs.getHeight()) return false;
    }
    if (hasSlotIdx() || rhs.hasSlotIdx()) {
        if (getSlotIdx() < rhs.getSlotIdx()) return true;
        if (getSlotIdx() > rhs.getSlotIdx()) return false;
    }
    if (hasBSetForCurrentProfile() || rhs.hasBSetForCurrentProfile()) {
        if (getBSetForCurrentProfile() < rhs.getBSetForCurrentProfile()) return true;
        if (getBSetForCurrentProfile() > rhs.getBSetForCurrentProfile()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoImportProfileImageRequest::clone() {
    return new DoImportProfileImageRequest(*this);
}

inline bool DoImportProfileImageRequest::operator > (const DoImportProfileImageRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoImportProfileImageRequest::clear() {
    clearSourcePath();
    clearWidth();
    clearHeight();
    clearSlotIdx();
    clearBSetForCurrentProfile();
}

inline void DoImportProfileImageRequest::clearSourcePath() {
    if (hasSourcePath()) {
         clear_has_sourcePath();
        _sourcePath.clear();
     }
}

inline bool DoImportProfileImageRequest::hasSourcePath () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DoImportProfileImageRequest::getSourcePath () const {
    return _sourcePath;
}

inline ::std::string& DoImportProfileImageRequest::getSourcePathMutable () {
    set_has_sourcePath();
    return _sourcePath;
}

inline void DoImportProfileImageRequest::setSourcePath (const ::std::string& sourcePath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sourcePath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sourcePath();
    this->_sourcePath = sourcePath_;
}

inline void DoImportProfileImageRequest::setSourcePath (const char* sourcePath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sourcePath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sourcePath();
    this->_sourcePath.assign(sourcePath_);
}

inline void DoImportProfileImageRequest::setSourcePath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sourcePath();
    this->_sourcePath.assign(value, size);
}

inline void DoImportProfileImageRequest::clearWidth() {
    if (hasWidth()) {
         clear_has_width();
        _width = 0u;
     }
}

inline bool DoImportProfileImageRequest::hasWidth () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 DoImportProfileImageRequest::getWidth () const {
    return _width;
}

inline void DoImportProfileImageRequest::setWidth (uint16 width_) {
    set_has_width();
    this->_width = width_;
}

inline void DoImportProfileImageRequest::clearHeight() {
    if (hasHeight()) {
         clear_has_height();
        _height = 0u;
     }
}

inline bool DoImportProfileImageRequest::hasHeight () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 DoImportProfileImageRequest::getHeight () const {
    return _height;
}

inline void DoImportProfileImageRequest::setHeight (uint16 height_) {
    set_has_height();
    this->_height = height_;
}

inline void DoImportProfileImageRequest::clearSlotIdx() {
    if (hasSlotIdx()) {
         clear_has_slotIdx();
        _slotIdx = 0u;
     }
}

inline bool DoImportProfileImageRequest::hasSlotIdx () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 DoImportProfileImageRequest::getSlotIdx () const {
    return _slotIdx;
}

inline void DoImportProfileImageRequest::setSlotIdx (uint16 slotIdx_) {
    set_has_slotIdx();
    this->_slotIdx = slotIdx_;
}

inline void DoImportProfileImageRequest::clearBSetForCurrentProfile() {
    if (hasBSetForCurrentProfile()) {
         clear_has_bSetForCurrentProfile();
        _bSetForCurrentProfile = false;
     }
}

inline bool DoImportProfileImageRequest::hasBSetForCurrentProfile () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool DoImportProfileImageRequest::getBSetForCurrentProfile () const {
    return _bSetForCurrentProfile;
}

inline void DoImportProfileImageRequest::setBSetForCurrentProfile (bool bSetForCurrentProfile_) {
    set_has_bSetForCurrentProfile();
    this->_bSetForCurrentProfile = bSetForCurrentProfile_;
}

inline void DoImportProfileImageRequest::set_has_sourcePath () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoImportProfileImageRequest::clear_has_sourcePath () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DoImportProfileImageRequest::set_has_width () {
    _has_bits_[0] |= 1u << 1;
}

inline void DoImportProfileImageRequest::clear_has_width () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DoImportProfileImageRequest::set_has_height () {
    _has_bits_[0] |= 1u << 2;
}

inline void DoImportProfileImageRequest::clear_has_height () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void DoImportProfileImageRequest::set_has_slotIdx () {
    _has_bits_[0] |= 1u << 3;
}

inline void DoImportProfileImageRequest::clear_has_slotIdx () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void DoImportProfileImageRequest::set_has_bSetForCurrentProfile () {
    _has_bits_[0] |= 1u << 4;
}

inline void DoImportProfileImageRequest::clear_has_bSetForCurrentProfile () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  DoImportProfileImageResponse::DoImportProfileImageResponse ()  :
    _result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoImportProfileImageResponse::DoImportProfileImageResponse (const DoImportProfileImageResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoImportProfileImageResponse::DoImportProfileImageResponse (serverResult result_)  :
    _result (result_)
{
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "DoImportProfileImageResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoImportProfileImageResponse::~DoImportProfileImageResponse() {
}

inline DoImportProfileImageResponse& DoImportProfileImageResponse::operator = (const DoImportProfileImageResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool DoImportProfileImageResponse::operator == (const DoImportProfileImageResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool DoImportProfileImageResponse::operator != (const DoImportProfileImageResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool DoImportProfileImageResponse::operator < (const DoImportProfileImageResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoImportProfileImageResponse::clone() {
    return new DoImportProfileImageResponse(*this);
}

inline bool DoImportProfileImageResponse::operator > (const DoImportProfileImageResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoImportProfileImageResponse::clear() {
    clearResult();
}

inline void DoImportProfileImageResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = ::bosch::cm::profile::serverResult__SUCCESS;
     }
}

inline bool DoImportProfileImageResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline serverResult DoImportProfileImageResponse::getResult () const {
    return _result;
}

inline void DoImportProfileImageResponse::setResult (serverResult result_) {
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "DoImportProfileImageResponse");
    }
    #endif
    set_has_result();
    this->_result = result_;
}

inline void DoImportProfileImageResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoImportProfileImageResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RemoveUserImageRequest::RemoveUserImageRequest ()  :
    _slotIdx (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoveUserImageRequest::RemoveUserImageRequest (const RemoveUserImageRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _slotIdx (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoveUserImageRequest::RemoveUserImageRequest (uint16 slotIdx_)  :
    _slotIdx (slotIdx_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoveUserImageRequest::~RemoveUserImageRequest() {
}

inline RemoveUserImageRequest& RemoveUserImageRequest::operator = (const RemoveUserImageRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSlotIdx()) {
            setSlotIdx(rhs.getSlotIdx());
        } else {
            clearSlotIdx();
        }
    }
    return *this;
}

inline bool RemoveUserImageRequest::operator == (const RemoveUserImageRequest& rhs) const {
    return (((!hasSlotIdx() && !rhs.hasSlotIdx()) || getSlotIdx() == rhs.getSlotIdx()));
}

inline bool RemoveUserImageRequest::operator != (const RemoveUserImageRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoveUserImageRequest::operator < (const RemoveUserImageRequest& rhs) const {
    if (hasSlotIdx() || rhs.hasSlotIdx()) {
        if (getSlotIdx() < rhs.getSlotIdx()) return true;
        if (getSlotIdx() > rhs.getSlotIdx()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoveUserImageRequest::clone() {
    return new RemoveUserImageRequest(*this);
}

inline bool RemoveUserImageRequest::operator > (const RemoveUserImageRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoveUserImageRequest::clear() {
    clearSlotIdx();
}

inline void RemoveUserImageRequest::clearSlotIdx() {
    if (hasSlotIdx()) {
         clear_has_slotIdx();
        _slotIdx = 0u;
     }
}

inline bool RemoveUserImageRequest::hasSlotIdx () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 RemoveUserImageRequest::getSlotIdx () const {
    return _slotIdx;
}

inline void RemoveUserImageRequest::setSlotIdx (uint16 slotIdx_) {
    set_has_slotIdx();
    this->_slotIdx = slotIdx_;
}

inline void RemoveUserImageRequest::set_has_slotIdx () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoveUserImageRequest::clear_has_slotIdx () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RemoveUserImageResponse::RemoveUserImageResponse ()  :
    _result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoveUserImageResponse::RemoveUserImageResponse (const RemoveUserImageResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoveUserImageResponse::RemoveUserImageResponse (serverResult result_)  :
    _result (result_)
{
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "RemoveUserImageResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoveUserImageResponse::~RemoveUserImageResponse() {
}

inline RemoveUserImageResponse& RemoveUserImageResponse::operator = (const RemoveUserImageResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool RemoveUserImageResponse::operator == (const RemoveUserImageResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool RemoveUserImageResponse::operator != (const RemoveUserImageResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoveUserImageResponse::operator < (const RemoveUserImageResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoveUserImageResponse::clone() {
    return new RemoveUserImageResponse(*this);
}

inline bool RemoveUserImageResponse::operator > (const RemoveUserImageResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoveUserImageResponse::clear() {
    clearResult();
}

inline void RemoveUserImageResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = ::bosch::cm::profile::serverResult__SUCCESS;
     }
}

inline bool RemoveUserImageResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline serverResult RemoveUserImageResponse::getResult () const {
    return _result;
}

inline void RemoveUserImageResponse::setResult (serverResult result_) {
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "RemoveUserImageResponse");
    }
    #endif
    set_has_result();
    this->_result = result_;
}

inline void RemoveUserImageResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoveUserImageResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoSetProfileImageRequest::DoSetProfileImageRequest ()  :
    _imageID (0u),
    _userID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoSetProfileImageRequest::DoSetProfileImageRequest (const DoSetProfileImageRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _imageID (0u),
    _userID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoSetProfileImageRequest::DoSetProfileImageRequest (uint8 imageID_, uint8 userID_)  :
    _imageID (imageID_),
    _userID (userID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoSetProfileImageRequest::~DoSetProfileImageRequest() {
}

inline DoSetProfileImageRequest& DoSetProfileImageRequest::operator = (const DoSetProfileImageRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasImageID()) {
            setImageID(rhs.getImageID());
        } else {
            clearImageID();
        }
        if (rhs.hasUserID()) {
            setUserID(rhs.getUserID());
        } else {
            clearUserID();
        }
    }
    return *this;
}

inline bool DoSetProfileImageRequest::operator == (const DoSetProfileImageRequest& rhs) const {
    return (((!hasImageID() && !rhs.hasImageID()) || getImageID() == rhs.getImageID()) &&
        ((!hasUserID() && !rhs.hasUserID()) || getUserID() == rhs.getUserID()));
}

inline bool DoSetProfileImageRequest::operator != (const DoSetProfileImageRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DoSetProfileImageRequest::operator < (const DoSetProfileImageRequest& rhs) const {
    if (hasImageID() || rhs.hasImageID()) {
        if (getImageID() < rhs.getImageID()) return true;
        if (getImageID() > rhs.getImageID()) return false;
    }
    if (hasUserID() || rhs.hasUserID()) {
        if (getUserID() < rhs.getUserID()) return true;
        if (getUserID() > rhs.getUserID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoSetProfileImageRequest::clone() {
    return new DoSetProfileImageRequest(*this);
}

inline bool DoSetProfileImageRequest::operator > (const DoSetProfileImageRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoSetProfileImageRequest::clear() {
    clearImageID();
    clearUserID();
}

inline void DoSetProfileImageRequest::clearImageID() {
    if (hasImageID()) {
         clear_has_imageID();
        _imageID = 0u;
     }
}

inline bool DoSetProfileImageRequest::hasImageID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DoSetProfileImageRequest::getImageID () const {
    return _imageID;
}

inline void DoSetProfileImageRequest::setImageID (uint8 imageID_) {
    set_has_imageID();
    this->_imageID = imageID_;
}

inline void DoSetProfileImageRequest::clearUserID() {
    if (hasUserID()) {
         clear_has_userID();
        _userID = 0u;
     }
}

inline bool DoSetProfileImageRequest::hasUserID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 DoSetProfileImageRequest::getUserID () const {
    return _userID;
}

inline void DoSetProfileImageRequest::setUserID (uint8 userID_) {
    set_has_userID();
    this->_userID = userID_;
}

inline void DoSetProfileImageRequest::set_has_imageID () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoSetProfileImageRequest::clear_has_imageID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DoSetProfileImageRequest::set_has_userID () {
    _has_bits_[0] |= 1u << 1;
}

inline void DoSetProfileImageRequest::clear_has_userID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DoSetProfileImageResponse::DoSetProfileImageResponse ()  :
    _result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoSetProfileImageResponse::DoSetProfileImageResponse (const DoSetProfileImageResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoSetProfileImageResponse::DoSetProfileImageResponse (serverResult result_)  :
    _result (result_)
{
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "DoSetProfileImageResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoSetProfileImageResponse::~DoSetProfileImageResponse() {
}

inline DoSetProfileImageResponse& DoSetProfileImageResponse::operator = (const DoSetProfileImageResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool DoSetProfileImageResponse::operator == (const DoSetProfileImageResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool DoSetProfileImageResponse::operator != (const DoSetProfileImageResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool DoSetProfileImageResponse::operator < (const DoSetProfileImageResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoSetProfileImageResponse::clone() {
    return new DoSetProfileImageResponse(*this);
}

inline bool DoSetProfileImageResponse::operator > (const DoSetProfileImageResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoSetProfileImageResponse::clear() {
    clearResult();
}

inline void DoSetProfileImageResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = ::bosch::cm::profile::serverResult__SUCCESS;
     }
}

inline bool DoSetProfileImageResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline serverResult DoSetProfileImageResponse::getResult () const {
    return _result;
}

inline void DoSetProfileImageResponse::setResult (serverResult result_) {
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "DoSetProfileImageResponse");
    }
    #endif
    set_has_result();
    this->_result = result_;
}

inline void DoSetProfileImageResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoSetProfileImageResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetProfileImagesResponse::GetProfileImagesResponse ()  :
    _images ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetProfileImagesResponse::GetProfileImagesResponse (const GetProfileImagesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _images ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetProfileImagesResponse::GetProfileImagesResponse (const ::std::vector< uint8 >& images_)  :
    _images (images_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetProfileImagesResponse::~GetProfileImagesResponse() {
}

inline GetProfileImagesResponse& GetProfileImagesResponse::operator = (const GetProfileImagesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasImages()) {
            setImages(rhs.getImages());
        } else {
            clearImages();
        }
    }
    return *this;
}

inline bool GetProfileImagesResponse::operator == (const GetProfileImagesResponse& rhs) const {
    return (((!hasImages() && !rhs.hasImages()) || getImages() == rhs.getImages()));
}

inline bool GetProfileImagesResponse::operator != (const GetProfileImagesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetProfileImagesResponse::operator < (const GetProfileImagesResponse& rhs) const {
    if (hasImages() || rhs.hasImages()) {
        if (getImages() < rhs.getImages()) return true;
        if (getImages() > rhs.getImages()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetProfileImagesResponse::clone() {
    return new GetProfileImagesResponse(*this);
}

inline bool GetProfileImagesResponse::operator > (const GetProfileImagesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetProfileImagesResponse::clear() {
    clearImages();
}

inline void GetProfileImagesResponse::clearImages() {
    if (hasImages()) {
         clear_has_images();
        _images.clear();
     }
}

inline bool GetProfileImagesResponse::hasImages () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& GetProfileImagesResponse::getImages () const {
    return _images;
}

inline ::std::vector< uint8 >& GetProfileImagesResponse::getImagesMutable () {
    set_has_images();
    return _images;
}

inline void GetProfileImagesResponse::setImages (const ::std::vector< uint8 >& images_) {
    set_has_images();
    this->_images = images_;
}

inline void GetProfileImagesResponse::set_has_images () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetProfileImagesResponse::clear_has_images () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetProfileTypesResponse::GetProfileTypesResponse ()  :
    _types ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetProfileTypesResponse::GetProfileTypesResponse (const GetProfileTypesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _types ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetProfileTypesResponse::GetProfileTypesResponse (const ::std::vector< profileType >& types_)  :
    _types (types_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetProfileTypesResponse::~GetProfileTypesResponse() {
}

inline GetProfileTypesResponse& GetProfileTypesResponse::operator = (const GetProfileTypesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTypes()) {
            setTypes(rhs.getTypes());
        } else {
            clearTypes();
        }
    }
    return *this;
}

inline bool GetProfileTypesResponse::operator == (const GetProfileTypesResponse& rhs) const {
    return (((!hasTypes() && !rhs.hasTypes()) || getTypes() == rhs.getTypes()));
}

inline bool GetProfileTypesResponse::operator != (const GetProfileTypesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetProfileTypesResponse::operator < (const GetProfileTypesResponse& rhs) const {
    if (hasTypes() || rhs.hasTypes()) {
        if (getTypes() < rhs.getTypes()) return true;
        if (getTypes() > rhs.getTypes()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetProfileTypesResponse::clone() {
    return new GetProfileTypesResponse(*this);
}

inline bool GetProfileTypesResponse::operator > (const GetProfileTypesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetProfileTypesResponse::clear() {
    clearTypes();
}

inline void GetProfileTypesResponse::clearTypes() {
    if (hasTypes()) {
         clear_has_types();
        _types.clear();
     }
}

inline bool GetProfileTypesResponse::hasTypes () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< profileType >& GetProfileTypesResponse::getTypes () const {
    return _types;
}

inline ::std::vector< profileType >& GetProfileTypesResponse::getTypesMutable () {
    set_has_types();
    return _types;
}

inline void GetProfileTypesResponse::setTypes (const ::std::vector< profileType >& types_) {
    set_has_types();
    this->_types = types_;
}

inline void GetProfileTypesResponse::set_has_types () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetProfileTypesResponse::clear_has_types () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetProfilePinRequest::SetProfilePinRequest ()  :
    _profileID (0u),
    _Pin ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetProfilePinRequest::SetProfilePinRequest (const SetProfilePinRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _profileID (0u),
    _Pin ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetProfilePinRequest::SetProfilePinRequest (uint8 profileID_, const ::std::string& Pin_)  :
    _profileID (profileID_),
    _Pin (Pin_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Pin_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetProfilePinRequest::~SetProfilePinRequest() {
}

inline SetProfilePinRequest& SetProfilePinRequest::operator = (const SetProfilePinRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProfileID()) {
            setProfileID(rhs.getProfileID());
        } else {
            clearProfileID();
        }
        if (rhs.hasPin()) {
            setPin(rhs.getPin());
        } else {
            clearPin();
        }
    }
    return *this;
}

inline bool SetProfilePinRequest::operator == (const SetProfilePinRequest& rhs) const {
    return (((!hasProfileID() && !rhs.hasProfileID()) || getProfileID() == rhs.getProfileID()) &&
        ((!hasPin() && !rhs.hasPin()) || getPin() == rhs.getPin()));
}

inline bool SetProfilePinRequest::operator != (const SetProfilePinRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetProfilePinRequest::operator < (const SetProfilePinRequest& rhs) const {
    if (hasProfileID() || rhs.hasProfileID()) {
        if (getProfileID() < rhs.getProfileID()) return true;
        if (getProfileID() > rhs.getProfileID()) return false;
    }
    if (hasPin() || rhs.hasPin()) {
        if (getPin() < rhs.getPin()) return true;
        if (getPin() > rhs.getPin()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetProfilePinRequest::clone() {
    return new SetProfilePinRequest(*this);
}

inline bool SetProfilePinRequest::operator > (const SetProfilePinRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetProfilePinRequest::clear() {
    clearProfileID();
    clearPin();
}

inline void SetProfilePinRequest::clearProfileID() {
    if (hasProfileID()) {
         clear_has_profileID();
        _profileID = 0u;
     }
}

inline bool SetProfilePinRequest::hasProfileID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SetProfilePinRequest::getProfileID () const {
    return _profileID;
}

inline void SetProfilePinRequest::setProfileID (uint8 profileID_) {
    set_has_profileID();
    this->_profileID = profileID_;
}

inline void SetProfilePinRequest::clearPin() {
    if (hasPin()) {
         clear_has_Pin();
        _Pin.clear();
     }
}

inline bool SetProfilePinRequest::hasPin () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& SetProfilePinRequest::getPin () const {
    return _Pin;
}

inline ::std::string& SetProfilePinRequest::getPinMutable () {
    set_has_Pin();
    return _Pin;
}

inline void SetProfilePinRequest::setPin (const ::std::string& Pin_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Pin_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Pin();
    this->_Pin = Pin_;
}

inline void SetProfilePinRequest::setPin (const char* Pin_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Pin_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Pin();
    this->_Pin.assign(Pin_);
}

inline void SetProfilePinRequest::setPin (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Pin();
    this->_Pin.assign(value, size);
}

inline void SetProfilePinRequest::set_has_profileID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetProfilePinRequest::clear_has_profileID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetProfilePinRequest::set_has_Pin () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetProfilePinRequest::clear_has_Pin () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetProfilePinResponse::SetProfilePinResponse ()  :
    _result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetProfilePinResponse::SetProfilePinResponse (const SetProfilePinResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetProfilePinResponse::SetProfilePinResponse (serverResult result_)  :
    _result (result_)
{
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "SetProfilePinResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetProfilePinResponse::~SetProfilePinResponse() {
}

inline SetProfilePinResponse& SetProfilePinResponse::operator = (const SetProfilePinResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool SetProfilePinResponse::operator == (const SetProfilePinResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool SetProfilePinResponse::operator != (const SetProfilePinResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetProfilePinResponse::operator < (const SetProfilePinResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetProfilePinResponse::clone() {
    return new SetProfilePinResponse(*this);
}

inline bool SetProfilePinResponse::operator > (const SetProfilePinResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetProfilePinResponse::clear() {
    clearResult();
}

inline void SetProfilePinResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = ::bosch::cm::profile::serverResult__SUCCESS;
     }
}

inline bool SetProfilePinResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline serverResult SetProfilePinResponse::getResult () const {
    return _result;
}

inline void SetProfilePinResponse::setResult (serverResult result_) {
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "SetProfilePinResponse");
    }
    #endif
    set_has_result();
    this->_result = result_;
}

inline void SetProfilePinResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetProfilePinResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetRememberMeRequest::SetRememberMeRequest ()  :
    _profileID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetRememberMeRequest::SetRememberMeRequest (const SetRememberMeRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _profileID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetRememberMeRequest::SetRememberMeRequest (uint8 profileID_)  :
    _profileID (profileID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetRememberMeRequest::~SetRememberMeRequest() {
}

inline SetRememberMeRequest& SetRememberMeRequest::operator = (const SetRememberMeRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProfileID()) {
            setProfileID(rhs.getProfileID());
        } else {
            clearProfileID();
        }
    }
    return *this;
}

inline bool SetRememberMeRequest::operator == (const SetRememberMeRequest& rhs) const {
    return (((!hasProfileID() && !rhs.hasProfileID()) || getProfileID() == rhs.getProfileID()));
}

inline bool SetRememberMeRequest::operator != (const SetRememberMeRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetRememberMeRequest::operator < (const SetRememberMeRequest& rhs) const {
    if (hasProfileID() || rhs.hasProfileID()) {
        if (getProfileID() < rhs.getProfileID()) return true;
        if (getProfileID() > rhs.getProfileID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetRememberMeRequest::clone() {
    return new SetRememberMeRequest(*this);
}

inline bool SetRememberMeRequest::operator > (const SetRememberMeRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetRememberMeRequest::clear() {
    clearProfileID();
}

inline void SetRememberMeRequest::clearProfileID() {
    if (hasProfileID()) {
         clear_has_profileID();
        _profileID = 0u;
     }
}

inline bool SetRememberMeRequest::hasProfileID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SetRememberMeRequest::getProfileID () const {
    return _profileID;
}

inline void SetRememberMeRequest::setProfileID (uint8 profileID_) {
    set_has_profileID();
    this->_profileID = profileID_;
}

inline void SetRememberMeRequest::set_has_profileID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetRememberMeRequest::clear_has_profileID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetRememberMeResponse::SetRememberMeResponse ()  :
    _result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetRememberMeResponse::SetRememberMeResponse (const SetRememberMeResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetRememberMeResponse::SetRememberMeResponse (serverResult result_)  :
    _result (result_)
{
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "SetRememberMeResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetRememberMeResponse::~SetRememberMeResponse() {
}

inline SetRememberMeResponse& SetRememberMeResponse::operator = (const SetRememberMeResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool SetRememberMeResponse::operator == (const SetRememberMeResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool SetRememberMeResponse::operator != (const SetRememberMeResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetRememberMeResponse::operator < (const SetRememberMeResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetRememberMeResponse::clone() {
    return new SetRememberMeResponse(*this);
}

inline bool SetRememberMeResponse::operator > (const SetRememberMeResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetRememberMeResponse::clear() {
    clearResult();
}

inline void SetRememberMeResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = ::bosch::cm::profile::serverResult__SUCCESS;
     }
}

inline bool SetRememberMeResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline serverResult SetRememberMeResponse::getResult () const {
    return _result;
}

inline void SetRememberMeResponse::setResult (serverResult result_) {
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "SetRememberMeResponse");
    }
    #endif
    set_has_result();
    this->_result = result_;
}

inline void SetRememberMeResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetRememberMeResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CheckPinRequest::CheckPinRequest ()  :
    _profileID (0u),
    _PIN ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CheckPinRequest::CheckPinRequest (const CheckPinRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _profileID (0u),
    _PIN ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CheckPinRequest::CheckPinRequest (uint8 profileID_, const ::std::string& PIN_)  :
    _profileID (profileID_),
    _PIN (PIN_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PIN_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CheckPinRequest::~CheckPinRequest() {
}

inline CheckPinRequest& CheckPinRequest::operator = (const CheckPinRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProfileID()) {
            setProfileID(rhs.getProfileID());
        } else {
            clearProfileID();
        }
        if (rhs.hasPIN()) {
            setPIN(rhs.getPIN());
        } else {
            clearPIN();
        }
    }
    return *this;
}

inline bool CheckPinRequest::operator == (const CheckPinRequest& rhs) const {
    return (((!hasProfileID() && !rhs.hasProfileID()) || getProfileID() == rhs.getProfileID()) &&
        ((!hasPIN() && !rhs.hasPIN()) || getPIN() == rhs.getPIN()));
}

inline bool CheckPinRequest::operator != (const CheckPinRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool CheckPinRequest::operator < (const CheckPinRequest& rhs) const {
    if (hasProfileID() || rhs.hasProfileID()) {
        if (getProfileID() < rhs.getProfileID()) return true;
        if (getProfileID() > rhs.getProfileID()) return false;
    }
    if (hasPIN() || rhs.hasPIN()) {
        if (getPIN() < rhs.getPIN()) return true;
        if (getPIN() > rhs.getPIN()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CheckPinRequest::clone() {
    return new CheckPinRequest(*this);
}

inline bool CheckPinRequest::operator > (const CheckPinRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CheckPinRequest::clear() {
    clearProfileID();
    clearPIN();
}

inline void CheckPinRequest::clearProfileID() {
    if (hasProfileID()) {
         clear_has_profileID();
        _profileID = 0u;
     }
}

inline bool CheckPinRequest::hasProfileID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 CheckPinRequest::getProfileID () const {
    return _profileID;
}

inline void CheckPinRequest::setProfileID (uint8 profileID_) {
    set_has_profileID();
    this->_profileID = profileID_;
}

inline void CheckPinRequest::clearPIN() {
    if (hasPIN()) {
         clear_has_PIN();
        _PIN.clear();
     }
}

inline bool CheckPinRequest::hasPIN () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& CheckPinRequest::getPIN () const {
    return _PIN;
}

inline ::std::string& CheckPinRequest::getPINMutable () {
    set_has_PIN();
    return _PIN;
}

inline void CheckPinRequest::setPIN (const ::std::string& PIN_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PIN_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PIN();
    this->_PIN = PIN_;
}

inline void CheckPinRequest::setPIN (const char* PIN_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PIN_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PIN();
    this->_PIN.assign(PIN_);
}

inline void CheckPinRequest::setPIN (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PIN();
    this->_PIN.assign(value, size);
}

inline void CheckPinRequest::set_has_profileID () {
    _has_bits_[0] |= 1u << 0;
}

inline void CheckPinRequest::clear_has_profileID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CheckPinRequest::set_has_PIN () {
    _has_bits_[0] |= 1u << 1;
}

inline void CheckPinRequest::clear_has_PIN () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  CheckPinResponse::CheckPinResponse ()  :
    _result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CheckPinResponse::CheckPinResponse (const CheckPinResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CheckPinResponse::CheckPinResponse (serverResult result_)  :
    _result (result_)
{
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "CheckPinResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CheckPinResponse::~CheckPinResponse() {
}

inline CheckPinResponse& CheckPinResponse::operator = (const CheckPinResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool CheckPinResponse::operator == (const CheckPinResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool CheckPinResponse::operator != (const CheckPinResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool CheckPinResponse::operator < (const CheckPinResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CheckPinResponse::clone() {
    return new CheckPinResponse(*this);
}

inline bool CheckPinResponse::operator > (const CheckPinResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CheckPinResponse::clear() {
    clearResult();
}

inline void CheckPinResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = ::bosch::cm::profile::serverResult__SUCCESS;
     }
}

inline bool CheckPinResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline serverResult CheckPinResponse::getResult () const {
    return _result;
}

inline void CheckPinResponse::setResult (serverResult result_) {
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "CheckPinResponse");
    }
    #endif
    set_has_result();
    this->_result = result_;
}

inline void CheckPinResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void CheckPinResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  UnProtectProfileRequest::UnProtectProfileRequest ()  :
    _profileID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UnProtectProfileRequest::UnProtectProfileRequest (const UnProtectProfileRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _profileID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UnProtectProfileRequest::UnProtectProfileRequest (uint8 profileID_)  :
    _profileID (profileID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UnProtectProfileRequest::~UnProtectProfileRequest() {
}

inline UnProtectProfileRequest& UnProtectProfileRequest::operator = (const UnProtectProfileRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProfileID()) {
            setProfileID(rhs.getProfileID());
        } else {
            clearProfileID();
        }
    }
    return *this;
}

inline bool UnProtectProfileRequest::operator == (const UnProtectProfileRequest& rhs) const {
    return (((!hasProfileID() && !rhs.hasProfileID()) || getProfileID() == rhs.getProfileID()));
}

inline bool UnProtectProfileRequest::operator != (const UnProtectProfileRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool UnProtectProfileRequest::operator < (const UnProtectProfileRequest& rhs) const {
    if (hasProfileID() || rhs.hasProfileID()) {
        if (getProfileID() < rhs.getProfileID()) return true;
        if (getProfileID() > rhs.getProfileID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UnProtectProfileRequest::clone() {
    return new UnProtectProfileRequest(*this);
}

inline bool UnProtectProfileRequest::operator > (const UnProtectProfileRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UnProtectProfileRequest::clear() {
    clearProfileID();
}

inline void UnProtectProfileRequest::clearProfileID() {
    if (hasProfileID()) {
         clear_has_profileID();
        _profileID = 0u;
     }
}

inline bool UnProtectProfileRequest::hasProfileID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 UnProtectProfileRequest::getProfileID () const {
    return _profileID;
}

inline void UnProtectProfileRequest::setProfileID (uint8 profileID_) {
    set_has_profileID();
    this->_profileID = profileID_;
}

inline void UnProtectProfileRequest::set_has_profileID () {
    _has_bits_[0] |= 1u << 0;
}

inline void UnProtectProfileRequest::clear_has_profileID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  UnProtectProfileResponse::UnProtectProfileResponse ()  :
    _result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UnProtectProfileResponse::UnProtectProfileResponse (const UnProtectProfileResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UnProtectProfileResponse::UnProtectProfileResponse (serverResult result_)  :
    _result (result_)
{
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "UnProtectProfileResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UnProtectProfileResponse::~UnProtectProfileResponse() {
}

inline UnProtectProfileResponse& UnProtectProfileResponse::operator = (const UnProtectProfileResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool UnProtectProfileResponse::operator == (const UnProtectProfileResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool UnProtectProfileResponse::operator != (const UnProtectProfileResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool UnProtectProfileResponse::operator < (const UnProtectProfileResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UnProtectProfileResponse::clone() {
    return new UnProtectProfileResponse(*this);
}

inline bool UnProtectProfileResponse::operator > (const UnProtectProfileResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UnProtectProfileResponse::clear() {
    clearResult();
}

inline void UnProtectProfileResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = ::bosch::cm::profile::serverResult__SUCCESS;
     }
}

inline bool UnProtectProfileResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline serverResult UnProtectProfileResponse::getResult () const {
    return _result;
}

inline void UnProtectProfileResponse::setResult (serverResult result_) {
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "UnProtectProfileResponse");
    }
    #endif
    set_has_result();
    this->_result = result_;
}

inline void UnProtectProfileResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void UnProtectProfileResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  LinkProfileRequest::LinkProfileRequest ()  :
    _bSetLink (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LinkProfileRequest::LinkProfileRequest (const LinkProfileRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _bSetLink (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LinkProfileRequest::LinkProfileRequest (bool bSetLink_)  :
    _bSetLink (bSetLink_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LinkProfileRequest::~LinkProfileRequest() {
}

inline LinkProfileRequest& LinkProfileRequest::operator = (const LinkProfileRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBSetLink()) {
            setBSetLink(rhs.getBSetLink());
        } else {
            clearBSetLink();
        }
    }
    return *this;
}

inline bool LinkProfileRequest::operator == (const LinkProfileRequest& rhs) const {
    return (((!hasBSetLink() && !rhs.hasBSetLink()) || getBSetLink() == rhs.getBSetLink()));
}

inline bool LinkProfileRequest::operator != (const LinkProfileRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool LinkProfileRequest::operator < (const LinkProfileRequest& rhs) const {
    if (hasBSetLink() || rhs.hasBSetLink()) {
        if (getBSetLink() < rhs.getBSetLink()) return true;
        if (getBSetLink() > rhs.getBSetLink()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LinkProfileRequest::clone() {
    return new LinkProfileRequest(*this);
}

inline bool LinkProfileRequest::operator > (const LinkProfileRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LinkProfileRequest::clear() {
    clearBSetLink();
}

inline void LinkProfileRequest::clearBSetLink() {
    if (hasBSetLink()) {
         clear_has_bSetLink();
        _bSetLink = false;
     }
}

inline bool LinkProfileRequest::hasBSetLink () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool LinkProfileRequest::getBSetLink () const {
    return _bSetLink;
}

inline void LinkProfileRequest::setBSetLink (bool bSetLink_) {
    set_has_bSetLink();
    this->_bSetLink = bSetLink_;
}

inline void LinkProfileRequest::set_has_bSetLink () {
    _has_bits_[0] |= 1u << 0;
}

inline void LinkProfileRequest::clear_has_bSetLink () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  LinkProfileResponse::LinkProfileResponse ()  :
    _result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LinkProfileResponse::LinkProfileResponse (const LinkProfileResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LinkProfileResponse::LinkProfileResponse (serverResult result_)  :
    _result (result_)
{
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "LinkProfileResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LinkProfileResponse::~LinkProfileResponse() {
}

inline LinkProfileResponse& LinkProfileResponse::operator = (const LinkProfileResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool LinkProfileResponse::operator == (const LinkProfileResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool LinkProfileResponse::operator != (const LinkProfileResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool LinkProfileResponse::operator < (const LinkProfileResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LinkProfileResponse::clone() {
    return new LinkProfileResponse(*this);
}

inline bool LinkProfileResponse::operator > (const LinkProfileResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LinkProfileResponse::clear() {
    clearResult();
}

inline void LinkProfileResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = ::bosch::cm::profile::serverResult__SUCCESS;
     }
}

inline bool LinkProfileResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline serverResult LinkProfileResponse::getResult () const {
    return _result;
}

inline void LinkProfileResponse::setResult (serverResult result_) {
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "LinkProfileResponse");
    }
    #endif
    set_has_result();
    this->_result = result_;
}

inline void LinkProfileResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void LinkProfileResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetValetModeRequest::SetValetModeRequest ()  :
    _bEnableValetMode (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetValetModeRequest::SetValetModeRequest (const SetValetModeRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _bEnableValetMode (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetValetModeRequest::SetValetModeRequest (bool bEnableValetMode_)  :
    _bEnableValetMode (bEnableValetMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetValetModeRequest::~SetValetModeRequest() {
}

inline SetValetModeRequest& SetValetModeRequest::operator = (const SetValetModeRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBEnableValetMode()) {
            setBEnableValetMode(rhs.getBEnableValetMode());
        } else {
            clearBEnableValetMode();
        }
    }
    return *this;
}

inline bool SetValetModeRequest::operator == (const SetValetModeRequest& rhs) const {
    return (((!hasBEnableValetMode() && !rhs.hasBEnableValetMode()) || getBEnableValetMode() == rhs.getBEnableValetMode()));
}

inline bool SetValetModeRequest::operator != (const SetValetModeRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetValetModeRequest::operator < (const SetValetModeRequest& rhs) const {
    if (hasBEnableValetMode() || rhs.hasBEnableValetMode()) {
        if (getBEnableValetMode() < rhs.getBEnableValetMode()) return true;
        if (getBEnableValetMode() > rhs.getBEnableValetMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetValetModeRequest::clone() {
    return new SetValetModeRequest(*this);
}

inline bool SetValetModeRequest::operator > (const SetValetModeRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetValetModeRequest::clear() {
    clearBEnableValetMode();
}

inline void SetValetModeRequest::clearBEnableValetMode() {
    if (hasBEnableValetMode()) {
         clear_has_bEnableValetMode();
        _bEnableValetMode = false;
     }
}

inline bool SetValetModeRequest::hasBEnableValetMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetValetModeRequest::getBEnableValetMode () const {
    return _bEnableValetMode;
}

inline void SetValetModeRequest::setBEnableValetMode (bool bEnableValetMode_) {
    set_has_bEnableValetMode();
    this->_bEnableValetMode = bEnableValetMode_;
}

inline void SetValetModeRequest::set_has_bEnableValetMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetValetModeRequest::clear_has_bEnableValetMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetValetModeResponse::SetValetModeResponse ()  :
    _result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetValetModeResponse::SetValetModeResponse (const SetValetModeResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (::bosch::cm::profile::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetValetModeResponse::SetValetModeResponse (serverResult result_)  :
    _result (result_)
{
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "SetValetModeResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetValetModeResponse::~SetValetModeResponse() {
}

inline SetValetModeResponse& SetValetModeResponse::operator = (const SetValetModeResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool SetValetModeResponse::operator == (const SetValetModeResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool SetValetModeResponse::operator != (const SetValetModeResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetValetModeResponse::operator < (const SetValetModeResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetValetModeResponse::clone() {
    return new SetValetModeResponse(*this);
}

inline bool SetValetModeResponse::operator > (const SetValetModeResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetValetModeResponse::clear() {
    clearResult();
}

inline void SetValetModeResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = ::bosch::cm::profile::serverResult__SUCCESS;
     }
}

inline bool SetValetModeResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline serverResult SetValetModeResponse::getResult () const {
    return _result;
}

inline void SetValetModeResponse::setResult (serverResult result_) {
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "SetValetModeResponse");
    }
    #endif
    set_has_result();
    this->_result = result_;
}

inline void SetValetModeResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetValetModeResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ActiveProfileUpdate::ActiveProfileUpdate ()  :
    _activeProfile (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveProfileUpdate::ActiveProfileUpdate (const ActiveProfileUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _activeProfile (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveProfileUpdate::ActiveProfileUpdate (uint8 activeProfile_)  :
    _activeProfile (activeProfile_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActiveProfileUpdate::~ActiveProfileUpdate() {
}

inline ActiveProfileUpdate& ActiveProfileUpdate::operator = (const ActiveProfileUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActiveProfile()) {
            setActiveProfile(rhs.getActiveProfile());
        } else {
            clearActiveProfile();
        }
    }
    return *this;
}

inline bool ActiveProfileUpdate::operator == (const ActiveProfileUpdate& rhs) const {
    return (((!hasActiveProfile() && !rhs.hasActiveProfile()) || getActiveProfile() == rhs.getActiveProfile()));
}

inline bool ActiveProfileUpdate::operator != (const ActiveProfileUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveProfileUpdate::operator < (const ActiveProfileUpdate& rhs) const {
    if (hasActiveProfile() || rhs.hasActiveProfile()) {
        if (getActiveProfile() < rhs.getActiveProfile()) return true;
        if (getActiveProfile() > rhs.getActiveProfile()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActiveProfileUpdate::clone() {
    return new ActiveProfileUpdate(*this);
}

inline bool ActiveProfileUpdate::operator > (const ActiveProfileUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveProfileUpdate::clear() {
    clearActiveProfile();
}

inline void ActiveProfileUpdate::clearActiveProfile() {
    if (hasActiveProfile()) {
         clear_has_activeProfile();
        _activeProfile = 0u;
     }
}

inline bool ActiveProfileUpdate::hasActiveProfile () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 ActiveProfileUpdate::getActiveProfile () const {
    return _activeProfile;
}

inline void ActiveProfileUpdate::setActiveProfile (uint8 activeProfile_) {
    set_has_activeProfile();
    this->_activeProfile = activeProfile_;
}

inline void ActiveProfileUpdate::set_has_activeProfile () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActiveProfileUpdate::clear_has_activeProfile () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ActiveProfileRegister::ActiveProfileRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveProfileRegister::ActiveProfileRegister (const ActiveProfileRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveProfileRegister::~ActiveProfileRegister() {
}

inline ActiveProfileRegister& ActiveProfileRegister::operator = (const ActiveProfileRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ActiveProfileRegister::operator == (const ActiveProfileRegister& ) const {
    return true;
}

inline bool ActiveProfileRegister::operator != (const ActiveProfileRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveProfileRegister::operator < (const ActiveProfileRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ActiveProfileRegister::clone() {
    return new ActiveProfileRegister(*this);
}

inline bool ActiveProfileRegister::operator > (const ActiveProfileRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveProfileRegister::clear() {
}

inline  StatusUpdate::StatusUpdate ()  :
    _status (::bosch::cm::profile::ProfileStatus__UNLOCKED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StatusUpdate::StatusUpdate (const StatusUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _status (::bosch::cm::profile::ProfileStatus__UNLOCKED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StatusUpdate::StatusUpdate (ProfileStatus status_)  :
    _status (status_)
{
    #ifndef NDEBUG
    if (!(ProfileStatus_IsValid(status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "ProfileStatus", "status", "StatusUpdate");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StatusUpdate::~StatusUpdate() {
}

inline StatusUpdate& StatusUpdate::operator = (const StatusUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool StatusUpdate::operator == (const StatusUpdate& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool StatusUpdate::operator != (const StatusUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool StatusUpdate::operator < (const StatusUpdate& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StatusUpdate::clone() {
    return new StatusUpdate(*this);
}

inline bool StatusUpdate::operator > (const StatusUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StatusUpdate::clear() {
    clearStatus();
}

inline void StatusUpdate::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = ::bosch::cm::profile::ProfileStatus__UNLOCKED;
     }
}

inline bool StatusUpdate::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ProfileStatus StatusUpdate::getStatus () const {
    return _status;
}

inline void StatusUpdate::setStatus (ProfileStatus status_) {
    #ifndef NDEBUG
    if (!(ProfileStatus_IsValid(status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "ProfileStatus", "status", "StatusUpdate");
    }
    #endif
    set_has_status();
    this->_status = status_;
}

inline void StatusUpdate::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void StatusUpdate::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StatusRegister::StatusRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StatusRegister::StatusRegister (const StatusRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StatusRegister::~StatusRegister() {
}

inline StatusRegister& StatusRegister::operator = (const StatusRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool StatusRegister::operator == (const StatusRegister& ) const {
    return true;
}

inline bool StatusRegister::operator != (const StatusRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool StatusRegister::operator < (const StatusRegister& ) const {
    return false;
}

inline ::asf::core::Payload* StatusRegister::clone() {
    return new StatusRegister(*this);
}

inline bool StatusRegister::operator > (const StatusRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StatusRegister::clear() {
}

inline  CopyProfileUpdate::CopyProfileUpdate ()  :
    _copyProfile ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CopyProfileUpdate::CopyProfileUpdate (const CopyProfileUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _copyProfile ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CopyProfileUpdate::CopyProfileUpdate (const copyInfo& copyProfile_)  :
    _copyProfile (copyProfile_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CopyProfileUpdate::~CopyProfileUpdate() {
}

inline CopyProfileUpdate& CopyProfileUpdate::operator = (const CopyProfileUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCopyProfile()) {
            setCopyProfile(rhs.getCopyProfile());
        } else {
            clearCopyProfile();
        }
    }
    return *this;
}

inline bool CopyProfileUpdate::operator == (const CopyProfileUpdate& rhs) const {
    return (((!hasCopyProfile() && !rhs.hasCopyProfile()) || getCopyProfile() == rhs.getCopyProfile()));
}

inline bool CopyProfileUpdate::operator != (const CopyProfileUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool CopyProfileUpdate::operator < (const CopyProfileUpdate& rhs) const {
    if (hasCopyProfile() || rhs.hasCopyProfile()) {
        if (getCopyProfile() < rhs.getCopyProfile()) return true;
        if (getCopyProfile() > rhs.getCopyProfile()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CopyProfileUpdate::clone() {
    return new CopyProfileUpdate(*this);
}

inline bool CopyProfileUpdate::operator > (const CopyProfileUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CopyProfileUpdate::clear() {
    clearCopyProfile();
}

inline void CopyProfileUpdate::clearCopyProfile() {
    if (hasCopyProfile()) {
         clear_has_copyProfile();
        _copyProfile.clear();
     }
}

inline bool CopyProfileUpdate::hasCopyProfile () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const copyInfo& CopyProfileUpdate::getCopyProfile () const {
    return _copyProfile;
}

inline copyInfo& CopyProfileUpdate::getCopyProfileMutable () {
    set_has_copyProfile();
    return _copyProfile;
}

inline void CopyProfileUpdate::setCopyProfile (const copyInfo& copyProfile_) {
    set_has_copyProfile();
    this->_copyProfile = copyProfile_;
}

inline void CopyProfileUpdate::set_has_copyProfile () {
    _has_bits_[0] |= 1u << 0;
}

inline void CopyProfileUpdate::clear_has_copyProfile () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CopyProfileRegister::CopyProfileRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CopyProfileRegister::CopyProfileRegister (const CopyProfileRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CopyProfileRegister::~CopyProfileRegister() {
}

inline CopyProfileRegister& CopyProfileRegister::operator = (const CopyProfileRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool CopyProfileRegister::operator == (const CopyProfileRegister& ) const {
    return true;
}

inline bool CopyProfileRegister::operator != (const CopyProfileRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool CopyProfileRegister::operator < (const CopyProfileRegister& ) const {
    return false;
}

inline ::asf::core::Payload* CopyProfileRegister::clone() {
    return new CopyProfileRegister(*this);
}

inline bool CopyProfileRegister::operator > (const CopyProfileRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CopyProfileRegister::clear() {
}

inline  DeleteProfileUpdate::DeleteProfileUpdate ()  :
    _deleteProfile (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeleteProfileUpdate::DeleteProfileUpdate (const DeleteProfileUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _deleteProfile (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeleteProfileUpdate::DeleteProfileUpdate (uint8 deleteProfile_)  :
    _deleteProfile (deleteProfile_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeleteProfileUpdate::~DeleteProfileUpdate() {
}

inline DeleteProfileUpdate& DeleteProfileUpdate::operator = (const DeleteProfileUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDeleteProfile()) {
            setDeleteProfile(rhs.getDeleteProfile());
        } else {
            clearDeleteProfile();
        }
    }
    return *this;
}

inline bool DeleteProfileUpdate::operator == (const DeleteProfileUpdate& rhs) const {
    return (((!hasDeleteProfile() && !rhs.hasDeleteProfile()) || getDeleteProfile() == rhs.getDeleteProfile()));
}

inline bool DeleteProfileUpdate::operator != (const DeleteProfileUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool DeleteProfileUpdate::operator < (const DeleteProfileUpdate& rhs) const {
    if (hasDeleteProfile() || rhs.hasDeleteProfile()) {
        if (getDeleteProfile() < rhs.getDeleteProfile()) return true;
        if (getDeleteProfile() > rhs.getDeleteProfile()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DeleteProfileUpdate::clone() {
    return new DeleteProfileUpdate(*this);
}

inline bool DeleteProfileUpdate::operator > (const DeleteProfileUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeleteProfileUpdate::clear() {
    clearDeleteProfile();
}

inline void DeleteProfileUpdate::clearDeleteProfile() {
    if (hasDeleteProfile()) {
         clear_has_deleteProfile();
        _deleteProfile = 0u;
     }
}

inline bool DeleteProfileUpdate::hasDeleteProfile () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DeleteProfileUpdate::getDeleteProfile () const {
    return _deleteProfile;
}

inline void DeleteProfileUpdate::setDeleteProfile (uint8 deleteProfile_) {
    set_has_deleteProfile();
    this->_deleteProfile = deleteProfile_;
}

inline void DeleteProfileUpdate::set_has_deleteProfile () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeleteProfileUpdate::clear_has_deleteProfile () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DeleteProfileRegister::DeleteProfileRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeleteProfileRegister::DeleteProfileRegister (const DeleteProfileRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeleteProfileRegister::~DeleteProfileRegister() {
}

inline DeleteProfileRegister& DeleteProfileRegister::operator = (const DeleteProfileRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DeleteProfileRegister::operator == (const DeleteProfileRegister& ) const {
    return true;
}

inline bool DeleteProfileRegister::operator != (const DeleteProfileRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool DeleteProfileRegister::operator < (const DeleteProfileRegister& ) const {
    return false;
}

inline ::asf::core::Payload* DeleteProfileRegister::clone() {
    return new DeleteProfileRegister(*this);
}

inline bool DeleteProfileRegister::operator > (const DeleteProfileRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeleteProfileRegister::clear() {
}

inline  DataChangedUpdate::DataChangedUpdate ()  :
    _dataChanged (::bosch::cm::profile::dataChangeReason__IDLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DataChangedUpdate::DataChangedUpdate (const DataChangedUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _dataChanged (::bosch::cm::profile::dataChangeReason__IDLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DataChangedUpdate::DataChangedUpdate (dataChangeReason dataChanged_)  :
    _dataChanged (dataChanged_)
{
    #ifndef NDEBUG
    if (!(dataChangeReason_IsValid(dataChanged_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", dataChanged_, "dataChangeReason", "dataChanged", "DataChangedUpdate");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DataChangedUpdate::~DataChangedUpdate() {
}

inline DataChangedUpdate& DataChangedUpdate::operator = (const DataChangedUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDataChanged()) {
            setDataChanged(rhs.getDataChanged());
        } else {
            clearDataChanged();
        }
    }
    return *this;
}

inline bool DataChangedUpdate::operator == (const DataChangedUpdate& rhs) const {
    return (((!hasDataChanged() && !rhs.hasDataChanged()) || getDataChanged() == rhs.getDataChanged()));
}

inline bool DataChangedUpdate::operator != (const DataChangedUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool DataChangedUpdate::operator < (const DataChangedUpdate& rhs) const {
    if (hasDataChanged() || rhs.hasDataChanged()) {
        if ((uint32)getDataChanged() < (uint32)rhs.getDataChanged()) return true;
        if ((uint32)getDataChanged() > (uint32)rhs.getDataChanged()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DataChangedUpdate::clone() {
    return new DataChangedUpdate(*this);
}

inline bool DataChangedUpdate::operator > (const DataChangedUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DataChangedUpdate::clear() {
    clearDataChanged();
}

inline void DataChangedUpdate::clearDataChanged() {
    if (hasDataChanged()) {
         clear_has_dataChanged();
        _dataChanged = ::bosch::cm::profile::dataChangeReason__IDLE;
     }
}

inline bool DataChangedUpdate::hasDataChanged () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline dataChangeReason DataChangedUpdate::getDataChanged () const {
    return _dataChanged;
}

inline void DataChangedUpdate::setDataChanged (dataChangeReason dataChanged_) {
    #ifndef NDEBUG
    if (!(dataChangeReason_IsValid(dataChanged_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", dataChanged_, "dataChangeReason", "dataChanged", "DataChangedUpdate");
    }
    #endif
    set_has_dataChanged();
    this->_dataChanged = dataChanged_;
}

inline void DataChangedUpdate::set_has_dataChanged () {
    _has_bits_[0] |= 1u << 0;
}

inline void DataChangedUpdate::clear_has_dataChanged () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DataChangedRegister::DataChangedRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DataChangedRegister::DataChangedRegister (const DataChangedRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DataChangedRegister::~DataChangedRegister() {
}

inline DataChangedRegister& DataChangedRegister::operator = (const DataChangedRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DataChangedRegister::operator == (const DataChangedRegister& ) const {
    return true;
}

inline bool DataChangedRegister::operator != (const DataChangedRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool DataChangedRegister::operator < (const DataChangedRegister& ) const {
    return false;
}

inline ::asf::core::Payload* DataChangedRegister::clone() {
    return new DataChangedRegister(*this);
}

inline bool DataChangedRegister::operator > (const DataChangedRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DataChangedRegister::clear() {
}

inline  CreateProfileUpdate::CreateProfileUpdate ()  :
    _createProfile (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CreateProfileUpdate::CreateProfileUpdate (const CreateProfileUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _createProfile (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CreateProfileUpdate::CreateProfileUpdate (uint8 createProfile_)  :
    _createProfile (createProfile_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CreateProfileUpdate::~CreateProfileUpdate() {
}

inline CreateProfileUpdate& CreateProfileUpdate::operator = (const CreateProfileUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCreateProfile()) {
            setCreateProfile(rhs.getCreateProfile());
        } else {
            clearCreateProfile();
        }
    }
    return *this;
}

inline bool CreateProfileUpdate::operator == (const CreateProfileUpdate& rhs) const {
    return (((!hasCreateProfile() && !rhs.hasCreateProfile()) || getCreateProfile() == rhs.getCreateProfile()));
}

inline bool CreateProfileUpdate::operator != (const CreateProfileUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool CreateProfileUpdate::operator < (const CreateProfileUpdate& rhs) const {
    if (hasCreateProfile() || rhs.hasCreateProfile()) {
        if (getCreateProfile() < rhs.getCreateProfile()) return true;
        if (getCreateProfile() > rhs.getCreateProfile()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CreateProfileUpdate::clone() {
    return new CreateProfileUpdate(*this);
}

inline bool CreateProfileUpdate::operator > (const CreateProfileUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CreateProfileUpdate::clear() {
    clearCreateProfile();
}

inline void CreateProfileUpdate::clearCreateProfile() {
    if (hasCreateProfile()) {
         clear_has_createProfile();
        _createProfile = 0u;
     }
}

inline bool CreateProfileUpdate::hasCreateProfile () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 CreateProfileUpdate::getCreateProfile () const {
    return _createProfile;
}

inline void CreateProfileUpdate::setCreateProfile (uint8 createProfile_) {
    set_has_createProfile();
    this->_createProfile = createProfile_;
}

inline void CreateProfileUpdate::set_has_createProfile () {
    _has_bits_[0] |= 1u << 0;
}

inline void CreateProfileUpdate::clear_has_createProfile () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CreateProfileRegister::CreateProfileRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CreateProfileRegister::CreateProfileRegister (const CreateProfileRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CreateProfileRegister::~CreateProfileRegister() {
}

inline CreateProfileRegister& CreateProfileRegister::operator = (const CreateProfileRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool CreateProfileRegister::operator == (const CreateProfileRegister& ) const {
    return true;
}

inline bool CreateProfileRegister::operator != (const CreateProfileRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool CreateProfileRegister::operator < (const CreateProfileRegister& ) const {
    return false;
}

inline ::asf::core::Payload* CreateProfileRegister::clone() {
    return new CreateProfileRegister(*this);
}

inline bool CreateProfileRegister::operator > (const CreateProfileRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CreateProfileRegister::clear() {
}

inline  PrivacyModeUpdate::PrivacyModeUpdate ()  :
    _privacyMode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PrivacyModeUpdate::PrivacyModeUpdate (const PrivacyModeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _privacyMode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PrivacyModeUpdate::PrivacyModeUpdate (uint32 privacyMode_)  :
    _privacyMode (privacyMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PrivacyModeUpdate::~PrivacyModeUpdate() {
}

inline PrivacyModeUpdate& PrivacyModeUpdate::operator = (const PrivacyModeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPrivacyMode()) {
            setPrivacyMode(rhs.getPrivacyMode());
        } else {
            clearPrivacyMode();
        }
    }
    return *this;
}

inline bool PrivacyModeUpdate::operator == (const PrivacyModeUpdate& rhs) const {
    return (((!hasPrivacyMode() && !rhs.hasPrivacyMode()) || getPrivacyMode() == rhs.getPrivacyMode()));
}

inline bool PrivacyModeUpdate::operator != (const PrivacyModeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool PrivacyModeUpdate::operator < (const PrivacyModeUpdate& rhs) const {
    if (hasPrivacyMode() || rhs.hasPrivacyMode()) {
        if (getPrivacyMode() < rhs.getPrivacyMode()) return true;
        if (getPrivacyMode() > rhs.getPrivacyMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PrivacyModeUpdate::clone() {
    return new PrivacyModeUpdate(*this);
}

inline bool PrivacyModeUpdate::operator > (const PrivacyModeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PrivacyModeUpdate::clear() {
    clearPrivacyMode();
}

inline void PrivacyModeUpdate::clearPrivacyMode() {
    if (hasPrivacyMode()) {
         clear_has_privacyMode();
        _privacyMode = 0u;
     }
}

inline bool PrivacyModeUpdate::hasPrivacyMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 PrivacyModeUpdate::getPrivacyMode () const {
    return _privacyMode;
}

inline void PrivacyModeUpdate::setPrivacyMode (uint32 privacyMode_) {
    set_has_privacyMode();
    this->_privacyMode = privacyMode_;
}

inline void PrivacyModeUpdate::set_has_privacyMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void PrivacyModeUpdate::clear_has_privacyMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PrivacyModeRegister::PrivacyModeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PrivacyModeRegister::PrivacyModeRegister (const PrivacyModeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PrivacyModeRegister::~PrivacyModeRegister() {
}

inline PrivacyModeRegister& PrivacyModeRegister::operator = (const PrivacyModeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool PrivacyModeRegister::operator == (const PrivacyModeRegister& ) const {
    return true;
}

inline bool PrivacyModeRegister::operator != (const PrivacyModeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool PrivacyModeRegister::operator < (const PrivacyModeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* PrivacyModeRegister::clone() {
    return new PrivacyModeRegister(*this);
}

inline bool PrivacyModeRegister::operator > (const PrivacyModeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PrivacyModeRegister::clear() {
}

inline  ProfileNameUpdate::ProfileNameUpdate ()  :
    _profileName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProfileNameUpdate::ProfileNameUpdate (const ProfileNameUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _profileName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProfileNameUpdate::ProfileNameUpdate (const ::std::string& profileName_)  :
    _profileName (profileName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (profileName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ProfileNameUpdate::~ProfileNameUpdate() {
}

inline ProfileNameUpdate& ProfileNameUpdate::operator = (const ProfileNameUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProfileName()) {
            setProfileName(rhs.getProfileName());
        } else {
            clearProfileName();
        }
    }
    return *this;
}

inline bool ProfileNameUpdate::operator == (const ProfileNameUpdate& rhs) const {
    return (((!hasProfileName() && !rhs.hasProfileName()) || getProfileName() == rhs.getProfileName()));
}

inline bool ProfileNameUpdate::operator != (const ProfileNameUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ProfileNameUpdate::operator < (const ProfileNameUpdate& rhs) const {
    if (hasProfileName() || rhs.hasProfileName()) {
        if (getProfileName() < rhs.getProfileName()) return true;
        if (getProfileName() > rhs.getProfileName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ProfileNameUpdate::clone() {
    return new ProfileNameUpdate(*this);
}

inline bool ProfileNameUpdate::operator > (const ProfileNameUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProfileNameUpdate::clear() {
    clearProfileName();
}

inline void ProfileNameUpdate::clearProfileName() {
    if (hasProfileName()) {
         clear_has_profileName();
        _profileName.clear();
     }
}

inline bool ProfileNameUpdate::hasProfileName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ProfileNameUpdate::getProfileName () const {
    return _profileName;
}

inline ::std::string& ProfileNameUpdate::getProfileNameMutable () {
    set_has_profileName();
    return _profileName;
}

inline void ProfileNameUpdate::setProfileName (const ::std::string& profileName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (profileName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_profileName();
    this->_profileName = profileName_;
}

inline void ProfileNameUpdate::setProfileName (const char* profileName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (profileName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_profileName();
    this->_profileName.assign(profileName_);
}

inline void ProfileNameUpdate::setProfileName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_profileName();
    this->_profileName.assign(value, size);
}

inline void ProfileNameUpdate::set_has_profileName () {
    _has_bits_[0] |= 1u << 0;
}

inline void ProfileNameUpdate::clear_has_profileName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ProfileNameRegister::ProfileNameRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProfileNameRegister::ProfileNameRegister (const ProfileNameRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProfileNameRegister::~ProfileNameRegister() {
}

inline ProfileNameRegister& ProfileNameRegister::operator = (const ProfileNameRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ProfileNameRegister::operator == (const ProfileNameRegister& ) const {
    return true;
}

inline bool ProfileNameRegister::operator != (const ProfileNameRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ProfileNameRegister::operator < (const ProfileNameRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ProfileNameRegister::clone() {
    return new ProfileNameRegister(*this);
}

inline bool ProfileNameRegister::operator > (const ProfileNameRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProfileNameRegister::clear() {
}

inline  ProfileImageUpdate::ProfileImageUpdate ()  :
    _profileImage (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProfileImageUpdate::ProfileImageUpdate (const ProfileImageUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _profileImage (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProfileImageUpdate::ProfileImageUpdate (uint8 profileImage_)  :
    _profileImage (profileImage_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ProfileImageUpdate::~ProfileImageUpdate() {
}

inline ProfileImageUpdate& ProfileImageUpdate::operator = (const ProfileImageUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProfileImage()) {
            setProfileImage(rhs.getProfileImage());
        } else {
            clearProfileImage();
        }
    }
    return *this;
}

inline bool ProfileImageUpdate::operator == (const ProfileImageUpdate& rhs) const {
    return (((!hasProfileImage() && !rhs.hasProfileImage()) || getProfileImage() == rhs.getProfileImage()));
}

inline bool ProfileImageUpdate::operator != (const ProfileImageUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ProfileImageUpdate::operator < (const ProfileImageUpdate& rhs) const {
    if (hasProfileImage() || rhs.hasProfileImage()) {
        if (getProfileImage() < rhs.getProfileImage()) return true;
        if (getProfileImage() > rhs.getProfileImage()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ProfileImageUpdate::clone() {
    return new ProfileImageUpdate(*this);
}

inline bool ProfileImageUpdate::operator > (const ProfileImageUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProfileImageUpdate::clear() {
    clearProfileImage();
}

inline void ProfileImageUpdate::clearProfileImage() {
    if (hasProfileImage()) {
         clear_has_profileImage();
        _profileImage = 0u;
     }
}

inline bool ProfileImageUpdate::hasProfileImage () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 ProfileImageUpdate::getProfileImage () const {
    return _profileImage;
}

inline void ProfileImageUpdate::setProfileImage (uint8 profileImage_) {
    set_has_profileImage();
    this->_profileImage = profileImage_;
}

inline void ProfileImageUpdate::set_has_profileImage () {
    _has_bits_[0] |= 1u << 0;
}

inline void ProfileImageUpdate::clear_has_profileImage () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ProfileImageRegister::ProfileImageRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProfileImageRegister::ProfileImageRegister (const ProfileImageRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProfileImageRegister::~ProfileImageRegister() {
}

inline ProfileImageRegister& ProfileImageRegister::operator = (const ProfileImageRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ProfileImageRegister::operator == (const ProfileImageRegister& ) const {
    return true;
}

inline bool ProfileImageRegister::operator != (const ProfileImageRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ProfileImageRegister::operator < (const ProfileImageRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ProfileImageRegister::clone() {
    return new ProfileImageRegister(*this);
}

inline bool ProfileImageRegister::operator > (const ProfileImageRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProfileImageRegister::clear() {
}

inline  PinRequestedUpdate::PinRequestedUpdate ()  :
    _pinRequested (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PinRequestedUpdate::PinRequestedUpdate (const PinRequestedUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _pinRequested (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PinRequestedUpdate::PinRequestedUpdate (uint8 pinRequested_)  :
    _pinRequested (pinRequested_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PinRequestedUpdate::~PinRequestedUpdate() {
}

inline PinRequestedUpdate& PinRequestedUpdate::operator = (const PinRequestedUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPinRequested()) {
            setPinRequested(rhs.getPinRequested());
        } else {
            clearPinRequested();
        }
    }
    return *this;
}

inline bool PinRequestedUpdate::operator == (const PinRequestedUpdate& rhs) const {
    return (((!hasPinRequested() && !rhs.hasPinRequested()) || getPinRequested() == rhs.getPinRequested()));
}

inline bool PinRequestedUpdate::operator != (const PinRequestedUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool PinRequestedUpdate::operator < (const PinRequestedUpdate& rhs) const {
    if (hasPinRequested() || rhs.hasPinRequested()) {
        if (getPinRequested() < rhs.getPinRequested()) return true;
        if (getPinRequested() > rhs.getPinRequested()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PinRequestedUpdate::clone() {
    return new PinRequestedUpdate(*this);
}

inline bool PinRequestedUpdate::operator > (const PinRequestedUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PinRequestedUpdate::clear() {
    clearPinRequested();
}

inline void PinRequestedUpdate::clearPinRequested() {
    if (hasPinRequested()) {
         clear_has_pinRequested();
        _pinRequested = 0u;
     }
}

inline bool PinRequestedUpdate::hasPinRequested () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 PinRequestedUpdate::getPinRequested () const {
    return _pinRequested;
}

inline void PinRequestedUpdate::setPinRequested (uint8 pinRequested_) {
    set_has_pinRequested();
    this->_pinRequested = pinRequested_;
}

inline void PinRequestedUpdate::set_has_pinRequested () {
    _has_bits_[0] |= 1u << 0;
}

inline void PinRequestedUpdate::clear_has_pinRequested () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PinRequestedRegister::PinRequestedRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PinRequestedRegister::PinRequestedRegister (const PinRequestedRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PinRequestedRegister::~PinRequestedRegister() {
}

inline PinRequestedRegister& PinRequestedRegister::operator = (const PinRequestedRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool PinRequestedRegister::operator == (const PinRequestedRegister& ) const {
    return true;
}

inline bool PinRequestedRegister::operator != (const PinRequestedRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool PinRequestedRegister::operator < (const PinRequestedRegister& ) const {
    return false;
}

inline ::asf::core::Payload* PinRequestedRegister::clone() {
    return new PinRequestedRegister(*this);
}

inline bool PinRequestedRegister::operator > (const PinRequestedRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PinRequestedRegister::clear() {
}

inline  MaxPINAttemptsUpdate::MaxPINAttemptsUpdate ()  :
    _maxPINAttempts (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MaxPINAttemptsUpdate::MaxPINAttemptsUpdate (const MaxPINAttemptsUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _maxPINAttempts (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MaxPINAttemptsUpdate::MaxPINAttemptsUpdate (uint8 maxPINAttempts_)  :
    _maxPINAttempts (maxPINAttempts_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MaxPINAttemptsUpdate::~MaxPINAttemptsUpdate() {
}

inline MaxPINAttemptsUpdate& MaxPINAttemptsUpdate::operator = (const MaxPINAttemptsUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMaxPINAttempts()) {
            setMaxPINAttempts(rhs.getMaxPINAttempts());
        } else {
            clearMaxPINAttempts();
        }
    }
    return *this;
}

inline bool MaxPINAttemptsUpdate::operator == (const MaxPINAttemptsUpdate& rhs) const {
    return (((!hasMaxPINAttempts() && !rhs.hasMaxPINAttempts()) || getMaxPINAttempts() == rhs.getMaxPINAttempts()));
}

inline bool MaxPINAttemptsUpdate::operator != (const MaxPINAttemptsUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool MaxPINAttemptsUpdate::operator < (const MaxPINAttemptsUpdate& rhs) const {
    if (hasMaxPINAttempts() || rhs.hasMaxPINAttempts()) {
        if (getMaxPINAttempts() < rhs.getMaxPINAttempts()) return true;
        if (getMaxPINAttempts() > rhs.getMaxPINAttempts()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MaxPINAttemptsUpdate::clone() {
    return new MaxPINAttemptsUpdate(*this);
}

inline bool MaxPINAttemptsUpdate::operator > (const MaxPINAttemptsUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MaxPINAttemptsUpdate::clear() {
    clearMaxPINAttempts();
}

inline void MaxPINAttemptsUpdate::clearMaxPINAttempts() {
    if (hasMaxPINAttempts()) {
         clear_has_maxPINAttempts();
        _maxPINAttempts = 0u;
     }
}

inline bool MaxPINAttemptsUpdate::hasMaxPINAttempts () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 MaxPINAttemptsUpdate::getMaxPINAttempts () const {
    return _maxPINAttempts;
}

inline void MaxPINAttemptsUpdate::setMaxPINAttempts (uint8 maxPINAttempts_) {
    set_has_maxPINAttempts();
    this->_maxPINAttempts = maxPINAttempts_;
}

inline void MaxPINAttemptsUpdate::set_has_maxPINAttempts () {
    _has_bits_[0] |= 1u << 0;
}

inline void MaxPINAttemptsUpdate::clear_has_maxPINAttempts () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  MaxPINAttemptsRegister::MaxPINAttemptsRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MaxPINAttemptsRegister::MaxPINAttemptsRegister (const MaxPINAttemptsRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MaxPINAttemptsRegister::~MaxPINAttemptsRegister() {
}

inline MaxPINAttemptsRegister& MaxPINAttemptsRegister::operator = (const MaxPINAttemptsRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool MaxPINAttemptsRegister::operator == (const MaxPINAttemptsRegister& ) const {
    return true;
}

inline bool MaxPINAttemptsRegister::operator != (const MaxPINAttemptsRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool MaxPINAttemptsRegister::operator < (const MaxPINAttemptsRegister& ) const {
    return false;
}

inline ::asf::core::Payload* MaxPINAttemptsRegister::clone() {
    return new MaxPINAttemptsRegister(*this);
}

inline bool MaxPINAttemptsRegister::operator > (const MaxPINAttemptsRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MaxPINAttemptsRegister::clear() {
}

inline  MaxPINAttemptsBeforeDelayUpdate::MaxPINAttemptsBeforeDelayUpdate ()  :
    _maxPINAttemptsBeforeDelay (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MaxPINAttemptsBeforeDelayUpdate::MaxPINAttemptsBeforeDelayUpdate (const MaxPINAttemptsBeforeDelayUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _maxPINAttemptsBeforeDelay (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MaxPINAttemptsBeforeDelayUpdate::MaxPINAttemptsBeforeDelayUpdate (uint8 maxPINAttemptsBeforeDelay_)  :
    _maxPINAttemptsBeforeDelay (maxPINAttemptsBeforeDelay_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MaxPINAttemptsBeforeDelayUpdate::~MaxPINAttemptsBeforeDelayUpdate() {
}

inline MaxPINAttemptsBeforeDelayUpdate& MaxPINAttemptsBeforeDelayUpdate::operator = (const MaxPINAttemptsBeforeDelayUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMaxPINAttemptsBeforeDelay()) {
            setMaxPINAttemptsBeforeDelay(rhs.getMaxPINAttemptsBeforeDelay());
        } else {
            clearMaxPINAttemptsBeforeDelay();
        }
    }
    return *this;
}

inline bool MaxPINAttemptsBeforeDelayUpdate::operator == (const MaxPINAttemptsBeforeDelayUpdate& rhs) const {
    return (((!hasMaxPINAttemptsBeforeDelay() && !rhs.hasMaxPINAttemptsBeforeDelay()) || getMaxPINAttemptsBeforeDelay() == rhs.getMaxPINAttemptsBeforeDelay()));
}

inline bool MaxPINAttemptsBeforeDelayUpdate::operator != (const MaxPINAttemptsBeforeDelayUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool MaxPINAttemptsBeforeDelayUpdate::operator < (const MaxPINAttemptsBeforeDelayUpdate& rhs) const {
    if (hasMaxPINAttemptsBeforeDelay() || rhs.hasMaxPINAttemptsBeforeDelay()) {
        if (getMaxPINAttemptsBeforeDelay() < rhs.getMaxPINAttemptsBeforeDelay()) return true;
        if (getMaxPINAttemptsBeforeDelay() > rhs.getMaxPINAttemptsBeforeDelay()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MaxPINAttemptsBeforeDelayUpdate::clone() {
    return new MaxPINAttemptsBeforeDelayUpdate(*this);
}

inline bool MaxPINAttemptsBeforeDelayUpdate::operator > (const MaxPINAttemptsBeforeDelayUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MaxPINAttemptsBeforeDelayUpdate::clear() {
    clearMaxPINAttemptsBeforeDelay();
}

inline void MaxPINAttemptsBeforeDelayUpdate::clearMaxPINAttemptsBeforeDelay() {
    if (hasMaxPINAttemptsBeforeDelay()) {
         clear_has_maxPINAttemptsBeforeDelay();
        _maxPINAttemptsBeforeDelay = 0u;
     }
}

inline bool MaxPINAttemptsBeforeDelayUpdate::hasMaxPINAttemptsBeforeDelay () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 MaxPINAttemptsBeforeDelayUpdate::getMaxPINAttemptsBeforeDelay () const {
    return _maxPINAttemptsBeforeDelay;
}

inline void MaxPINAttemptsBeforeDelayUpdate::setMaxPINAttemptsBeforeDelay (uint8 maxPINAttemptsBeforeDelay_) {
    set_has_maxPINAttemptsBeforeDelay();
    this->_maxPINAttemptsBeforeDelay = maxPINAttemptsBeforeDelay_;
}

inline void MaxPINAttemptsBeforeDelayUpdate::set_has_maxPINAttemptsBeforeDelay () {
    _has_bits_[0] |= 1u << 0;
}

inline void MaxPINAttemptsBeforeDelayUpdate::clear_has_maxPINAttemptsBeforeDelay () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  MaxPINAttemptsBeforeDelayRegister::MaxPINAttemptsBeforeDelayRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MaxPINAttemptsBeforeDelayRegister::MaxPINAttemptsBeforeDelayRegister (const MaxPINAttemptsBeforeDelayRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MaxPINAttemptsBeforeDelayRegister::~MaxPINAttemptsBeforeDelayRegister() {
}

inline MaxPINAttemptsBeforeDelayRegister& MaxPINAttemptsBeforeDelayRegister::operator = (const MaxPINAttemptsBeforeDelayRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool MaxPINAttemptsBeforeDelayRegister::operator == (const MaxPINAttemptsBeforeDelayRegister& ) const {
    return true;
}

inline bool MaxPINAttemptsBeforeDelayRegister::operator != (const MaxPINAttemptsBeforeDelayRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool MaxPINAttemptsBeforeDelayRegister::operator < (const MaxPINAttemptsBeforeDelayRegister& ) const {
    return false;
}

inline ::asf::core::Payload* MaxPINAttemptsBeforeDelayRegister::clone() {
    return new MaxPINAttemptsBeforeDelayRegister(*this);
}

inline bool MaxPINAttemptsBeforeDelayRegister::operator > (const MaxPINAttemptsBeforeDelayRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MaxPINAttemptsBeforeDelayRegister::clear() {
}

inline  PinAuthenticationDelayTimeUpdate::PinAuthenticationDelayTimeUpdate ()  :
    _pinAuthenticationDelayTime (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PinAuthenticationDelayTimeUpdate::PinAuthenticationDelayTimeUpdate (const PinAuthenticationDelayTimeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _pinAuthenticationDelayTime (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PinAuthenticationDelayTimeUpdate::PinAuthenticationDelayTimeUpdate (uint32 pinAuthenticationDelayTime_)  :
    _pinAuthenticationDelayTime (pinAuthenticationDelayTime_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PinAuthenticationDelayTimeUpdate::~PinAuthenticationDelayTimeUpdate() {
}

inline PinAuthenticationDelayTimeUpdate& PinAuthenticationDelayTimeUpdate::operator = (const PinAuthenticationDelayTimeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPinAuthenticationDelayTime()) {
            setPinAuthenticationDelayTime(rhs.getPinAuthenticationDelayTime());
        } else {
            clearPinAuthenticationDelayTime();
        }
    }
    return *this;
}

inline bool PinAuthenticationDelayTimeUpdate::operator == (const PinAuthenticationDelayTimeUpdate& rhs) const {
    return (((!hasPinAuthenticationDelayTime() && !rhs.hasPinAuthenticationDelayTime()) || getPinAuthenticationDelayTime() == rhs.getPinAuthenticationDelayTime()));
}

inline bool PinAuthenticationDelayTimeUpdate::operator != (const PinAuthenticationDelayTimeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool PinAuthenticationDelayTimeUpdate::operator < (const PinAuthenticationDelayTimeUpdate& rhs) const {
    if (hasPinAuthenticationDelayTime() || rhs.hasPinAuthenticationDelayTime()) {
        if (getPinAuthenticationDelayTime() < rhs.getPinAuthenticationDelayTime()) return true;
        if (getPinAuthenticationDelayTime() > rhs.getPinAuthenticationDelayTime()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PinAuthenticationDelayTimeUpdate::clone() {
    return new PinAuthenticationDelayTimeUpdate(*this);
}

inline bool PinAuthenticationDelayTimeUpdate::operator > (const PinAuthenticationDelayTimeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PinAuthenticationDelayTimeUpdate::clear() {
    clearPinAuthenticationDelayTime();
}

inline void PinAuthenticationDelayTimeUpdate::clearPinAuthenticationDelayTime() {
    if (hasPinAuthenticationDelayTime()) {
         clear_has_pinAuthenticationDelayTime();
        _pinAuthenticationDelayTime = 0u;
     }
}

inline bool PinAuthenticationDelayTimeUpdate::hasPinAuthenticationDelayTime () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 PinAuthenticationDelayTimeUpdate::getPinAuthenticationDelayTime () const {
    return _pinAuthenticationDelayTime;
}

inline void PinAuthenticationDelayTimeUpdate::setPinAuthenticationDelayTime (uint32 pinAuthenticationDelayTime_) {
    set_has_pinAuthenticationDelayTime();
    this->_pinAuthenticationDelayTime = pinAuthenticationDelayTime_;
}

inline void PinAuthenticationDelayTimeUpdate::set_has_pinAuthenticationDelayTime () {
    _has_bits_[0] |= 1u << 0;
}

inline void PinAuthenticationDelayTimeUpdate::clear_has_pinAuthenticationDelayTime () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PinAuthenticationDelayTimeRegister::PinAuthenticationDelayTimeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PinAuthenticationDelayTimeRegister::PinAuthenticationDelayTimeRegister (const PinAuthenticationDelayTimeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PinAuthenticationDelayTimeRegister::~PinAuthenticationDelayTimeRegister() {
}

inline PinAuthenticationDelayTimeRegister& PinAuthenticationDelayTimeRegister::operator = (const PinAuthenticationDelayTimeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool PinAuthenticationDelayTimeRegister::operator == (const PinAuthenticationDelayTimeRegister& ) const {
    return true;
}

inline bool PinAuthenticationDelayTimeRegister::operator != (const PinAuthenticationDelayTimeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool PinAuthenticationDelayTimeRegister::operator < (const PinAuthenticationDelayTimeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* PinAuthenticationDelayTimeRegister::clone() {
    return new PinAuthenticationDelayTimeRegister(*this);
}

inline bool PinAuthenticationDelayTimeRegister::operator > (const PinAuthenticationDelayTimeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PinAuthenticationDelayTimeRegister::clear() {
}

inline  PinVerificationValidityTimeUpdate::PinVerificationValidityTimeUpdate ()  :
    _pinVerificationValidityTime (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PinVerificationValidityTimeUpdate::PinVerificationValidityTimeUpdate (const PinVerificationValidityTimeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _pinVerificationValidityTime (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PinVerificationValidityTimeUpdate::PinVerificationValidityTimeUpdate (uint32 pinVerificationValidityTime_)  :
    _pinVerificationValidityTime (pinVerificationValidityTime_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PinVerificationValidityTimeUpdate::~PinVerificationValidityTimeUpdate() {
}

inline PinVerificationValidityTimeUpdate& PinVerificationValidityTimeUpdate::operator = (const PinVerificationValidityTimeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPinVerificationValidityTime()) {
            setPinVerificationValidityTime(rhs.getPinVerificationValidityTime());
        } else {
            clearPinVerificationValidityTime();
        }
    }
    return *this;
}

inline bool PinVerificationValidityTimeUpdate::operator == (const PinVerificationValidityTimeUpdate& rhs) const {
    return (((!hasPinVerificationValidityTime() && !rhs.hasPinVerificationValidityTime()) || getPinVerificationValidityTime() == rhs.getPinVerificationValidityTime()));
}

inline bool PinVerificationValidityTimeUpdate::operator != (const PinVerificationValidityTimeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool PinVerificationValidityTimeUpdate::operator < (const PinVerificationValidityTimeUpdate& rhs) const {
    if (hasPinVerificationValidityTime() || rhs.hasPinVerificationValidityTime()) {
        if (getPinVerificationValidityTime() < rhs.getPinVerificationValidityTime()) return true;
        if (getPinVerificationValidityTime() > rhs.getPinVerificationValidityTime()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PinVerificationValidityTimeUpdate::clone() {
    return new PinVerificationValidityTimeUpdate(*this);
}

inline bool PinVerificationValidityTimeUpdate::operator > (const PinVerificationValidityTimeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PinVerificationValidityTimeUpdate::clear() {
    clearPinVerificationValidityTime();
}

inline void PinVerificationValidityTimeUpdate::clearPinVerificationValidityTime() {
    if (hasPinVerificationValidityTime()) {
         clear_has_pinVerificationValidityTime();
        _pinVerificationValidityTime = 0u;
     }
}

inline bool PinVerificationValidityTimeUpdate::hasPinVerificationValidityTime () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 PinVerificationValidityTimeUpdate::getPinVerificationValidityTime () const {
    return _pinVerificationValidityTime;
}

inline void PinVerificationValidityTimeUpdate::setPinVerificationValidityTime (uint32 pinVerificationValidityTime_) {
    set_has_pinVerificationValidityTime();
    this->_pinVerificationValidityTime = pinVerificationValidityTime_;
}

inline void PinVerificationValidityTimeUpdate::set_has_pinVerificationValidityTime () {
    _has_bits_[0] |= 1u << 0;
}

inline void PinVerificationValidityTimeUpdate::clear_has_pinVerificationValidityTime () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PinVerificationValidityTimeRegister::PinVerificationValidityTimeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PinVerificationValidityTimeRegister::PinVerificationValidityTimeRegister (const PinVerificationValidityTimeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PinVerificationValidityTimeRegister::~PinVerificationValidityTimeRegister() {
}

inline PinVerificationValidityTimeRegister& PinVerificationValidityTimeRegister::operator = (const PinVerificationValidityTimeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool PinVerificationValidityTimeRegister::operator == (const PinVerificationValidityTimeRegister& ) const {
    return true;
}

inline bool PinVerificationValidityTimeRegister::operator != (const PinVerificationValidityTimeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool PinVerificationValidityTimeRegister::operator < (const PinVerificationValidityTimeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* PinVerificationValidityTimeRegister::clone() {
    return new PinVerificationValidityTimeRegister(*this);
}

inline bool PinVerificationValidityTimeRegister::operator > (const PinVerificationValidityTimeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PinVerificationValidityTimeRegister::clear() {
}

inline  ActiveProfileTypeUpdate::ActiveProfileTypeUpdate ()  :
    _activeProfileType (::bosch::cm::profile::profileType__EMPTY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveProfileTypeUpdate::ActiveProfileTypeUpdate (const ActiveProfileTypeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _activeProfileType (::bosch::cm::profile::profileType__EMPTY)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveProfileTypeUpdate::ActiveProfileTypeUpdate (profileType activeProfileType_)  :
    _activeProfileType (activeProfileType_)
{
    #ifndef NDEBUG
    if (!(profileType_IsValid(activeProfileType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", activeProfileType_, "profileType", "activeProfileType", "ActiveProfileTypeUpdate");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActiveProfileTypeUpdate::~ActiveProfileTypeUpdate() {
}

inline ActiveProfileTypeUpdate& ActiveProfileTypeUpdate::operator = (const ActiveProfileTypeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActiveProfileType()) {
            setActiveProfileType(rhs.getActiveProfileType());
        } else {
            clearActiveProfileType();
        }
    }
    return *this;
}

inline bool ActiveProfileTypeUpdate::operator == (const ActiveProfileTypeUpdate& rhs) const {
    return (((!hasActiveProfileType() && !rhs.hasActiveProfileType()) || getActiveProfileType() == rhs.getActiveProfileType()));
}

inline bool ActiveProfileTypeUpdate::operator != (const ActiveProfileTypeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveProfileTypeUpdate::operator < (const ActiveProfileTypeUpdate& rhs) const {
    if (hasActiveProfileType() || rhs.hasActiveProfileType()) {
        if ((uint32)getActiveProfileType() < (uint32)rhs.getActiveProfileType()) return true;
        if ((uint32)getActiveProfileType() > (uint32)rhs.getActiveProfileType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActiveProfileTypeUpdate::clone() {
    return new ActiveProfileTypeUpdate(*this);
}

inline bool ActiveProfileTypeUpdate::operator > (const ActiveProfileTypeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveProfileTypeUpdate::clear() {
    clearActiveProfileType();
}

inline void ActiveProfileTypeUpdate::clearActiveProfileType() {
    if (hasActiveProfileType()) {
         clear_has_activeProfileType();
        _activeProfileType = ::bosch::cm::profile::profileType__EMPTY;
     }
}

inline bool ActiveProfileTypeUpdate::hasActiveProfileType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline profileType ActiveProfileTypeUpdate::getActiveProfileType () const {
    return _activeProfileType;
}

inline void ActiveProfileTypeUpdate::setActiveProfileType (profileType activeProfileType_) {
    #ifndef NDEBUG
    if (!(profileType_IsValid(activeProfileType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", activeProfileType_, "profileType", "activeProfileType", "ActiveProfileTypeUpdate");
    }
    #endif
    set_has_activeProfileType();
    this->_activeProfileType = activeProfileType_;
}

inline void ActiveProfileTypeUpdate::set_has_activeProfileType () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActiveProfileTypeUpdate::clear_has_activeProfileType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ActiveProfileTypeRegister::ActiveProfileTypeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveProfileTypeRegister::ActiveProfileTypeRegister (const ActiveProfileTypeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveProfileTypeRegister::~ActiveProfileTypeRegister() {
}

inline ActiveProfileTypeRegister& ActiveProfileTypeRegister::operator = (const ActiveProfileTypeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ActiveProfileTypeRegister::operator == (const ActiveProfileTypeRegister& ) const {
    return true;
}

inline bool ActiveProfileTypeRegister::operator != (const ActiveProfileTypeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveProfileTypeRegister::operator < (const ActiveProfileTypeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ActiveProfileTypeRegister::clone() {
    return new ActiveProfileTypeRegister(*this);
}

inline bool ActiveProfileTypeRegister::operator > (const ActiveProfileTypeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveProfileTypeRegister::clear() {
}

} // namespace profile
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_PROFILE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
