/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_PROFILECONNECTEDSTUB_H
#define BOSCH_CM_PROFILECONNECTEDSTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/profileConnected.h"
#include "bosch/cm/profileConnectedConst.h"
#include <string>

namespace bosch {
namespace cm {
namespace profileConnected {

class ProfileConnectedStubDelegate;

class ProfileConnectedStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the ProfileConnectedStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    ProfileConnectedStub (const std::string& portName);

    /**
     * Create an instance of the ProfileConnectedStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    ProfileConnectedStub (const std::string& portName, const std::string& objectPath);

    virtual ~ProfileConnectedStub();

    // property 'status'

    /**
     * The method onStatusGet() is called by ASF when a client invokes the
     * read method for the property 'status'. The onStatusGet() method returns
     * by default the current property value to the caller. In case this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'status'</b>:
     *
     * connected profile application status
     */
    virtual void onStatusGet(const ::boost::shared_ptr< StatusGet >& payload);

    /**
     * Sends back the update to a previous onStatusGet().
     *
     * <b>Documentation of 'status'</b>:
     *
     * connected profile application status
     *
     * @param act Identifies a previous invocation of onStatusGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendStatusGetUpdate(appStatus status, act_t act = 0);

    /**
     * Set the value of the property 'status' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'status'</b>:
     *
     * connected profile application status
     */
    void setStatus(appStatus status);

    /**
     * Returns the current value of the property 'status'.
     *
     * <b>Documentation of 'status'</b>:
     *
     * connected profile application status
     */
    appStatus getStatus() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendStatusUpdate().
     *
     * <b>Documentation of 'status'</b>:
     *
     * connected profile application status
     */
    void sendStatusUpdate();

    // property 'accountName'

    /**
     * The method onAccountNameGet() is called by ASF when a client invokes
     * the read method for the property 'accountName'. The onAccountNameGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'accountName'</b>:
     *
     * accountName of the currently Logged on Profile.Valid Name is sent if logon is successful.Otherwise Empty name is sent
     */
    virtual void onAccountNameGet(const ::boost::shared_ptr< AccountNameGet >& payload);

    /**
     * Sends back the update to a previous onAccountNameGet().
     *
     * <b>Documentation of 'accountName'</b>:
     *
     * accountName of the currently Logged on Profile.Valid Name is sent if logon is successful.Otherwise Empty name is sent
     *
     * @param act Identifies a previous invocation of onAccountNameGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendAccountNameGetUpdate(const ::std::string& accountName, act_t act = 0);

    /**
     * Set the value of the property 'accountName' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'accountName'</b>:
     *
     * accountName of the currently Logged on Profile.Valid Name is sent if logon is successful.Otherwise Empty name is sent
     */
    void setAccountName(const ::std::string& accountName);

    /**
     * Returns the current value of the property 'accountName'.
     *
     * <b>Documentation of 'accountName'</b>:
     *
     * accountName of the currently Logged on Profile.Valid Name is sent if logon is successful.Otherwise Empty name is sent
     */
    const ::std::string& getAccountName() const;

    /**
     * Returns the current value of the property 'accountName' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendAccountNameUpdate() method.
     *
     * <b>Documentation of 'accountName'</b>:
     *
     * accountName of the currently Logged on Profile.Valid Name is sent if logon is successful.Otherwise Empty name is sent
     */
    ::std::string& getAccountNameMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAccountNameUpdate().
     *
     * <b>Documentation of 'accountName'</b>:
     *
     * accountName of the currently Logged on Profile.Valid Name is sent if logon is successful.Otherwise Empty name is sent
     */
    void sendAccountNameUpdate();

    // property 'kID'

    /**
     * The method onKIDGet() is called by ASF when a client invokes the read
     * method for the property 'kID'. The onKIDGet() method returns by default
     * the current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'kID'</b>:
     *
     * If the meaning of "kID" isn't clear, then there should be a description here.
     */
    virtual void onKIDGet(const ::boost::shared_ptr< KIDGet >& payload);

    /**
     * Sends back the update to a previous onKIDGet().
     *
     * <b>Documentation of 'kID'</b>:
     *
     * If the meaning of "kID" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onKIDGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendKIDGetUpdate(const ::std::string& kID, act_t act = 0);

    /**
     * Set the value of the property 'kID' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'kID'</b>:
     *
     * If the meaning of "kID" isn't clear, then there should be a description here.
     */
    void setKID(const ::std::string& kID);

    /**
     * Returns the current value of the property 'kID'.
     *
     * <b>Documentation of 'kID'</b>:
     *
     * If the meaning of "kID" isn't clear, then there should be a description here.
     */
    const ::std::string& getKID() const;

    /**
     * Returns the current value of the property 'kID' as a mutable reference.
     * If you change the content of the returned object you have to send
     * updates to registered clients by yourself with the help of the
     * sendKIDUpdate() method.
     *
     * <b>Documentation of 'kID'</b>:
     *
     * If the meaning of "kID" isn't clear, then there should be a description here.
     */
    ::std::string& getKIDMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendKIDUpdate().
     *
     * <b>Documentation of 'kID'</b>:
     *
     * If the meaning of "kID" isn't clear, then there should be a description here.
     */
    void sendKIDUpdate();

    // property 'remoteVehicleSettingsActivation'

    /**
     * The method onRemoteVehicleSettingsActivationGet() is called by ASF when
     * a client invokes the read method for the property
     * 'remoteVehicleSettingsActivation'. The
     * onRemoteVehicleSettingsActivationGet() method returns by default the
     * current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'remoteVehicleSettingsActivation'</b>:
     *
     * RVS is a Configuration Manager Setting Item maintained by PM. TRUE:Subscription is Active. FALSE: subscription is Inactive
     */
    virtual void onRemoteVehicleSettingsActivationGet(const ::boost::shared_ptr< RemoteVehicleSettingsActivationGet >& payload);

    /**
     * Sends back the update to a previous
     * onRemoteVehicleSettingsActivationGet().
     *
     * <b>Documentation of 'remoteVehicleSettingsActivation'</b>:
     *
     * RVS is a Configuration Manager Setting Item maintained by PM. TRUE:Subscription is Active. FALSE: subscription is Inactive
     *
     * @param act Identifies a previous invocation of
     * onRemoteVehicleSettingsActivationGet(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendRemoteVehicleSettingsActivationGetUpdate(bool remoteVehicleSettingsActivation, act_t act = 0);

    /**
     * Set the value of the property 'remoteVehicleSettingsActivation' and
     * send updates to registered clients. No updates will be sent if the
     * property value does not change.
     *
     * <b>Documentation of 'remoteVehicleSettingsActivation'</b>:
     *
     * RVS is a Configuration Manager Setting Item maintained by PM. TRUE:Subscription is Active. FALSE: subscription is Inactive
     */
    void setRemoteVehicleSettingsActivation(bool remoteVehicleSettingsActivation);

    /**
     * Returns the current value of the property 'remoteVehicleSettingsActivation'.
     *
     * <b>Documentation of 'remoteVehicleSettingsActivation'</b>:
     *
     * RVS is a Configuration Manager Setting Item maintained by PM. TRUE:Subscription is Active. FALSE: subscription is Inactive
     */
    bool getRemoteVehicleSettingsActivation() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRemoteVehicleSettingsActivationUpdate().
     *
     * <b>Documentation of 'remoteVehicleSettingsActivation'</b>:
     *
     * RVS is a Configuration Manager Setting Item maintained by PM. TRUE:Subscription is Active. FALSE: subscription is Inactive
     */
    void sendRemoteVehicleSettingsActivationUpdate();

    // method 'doSynchronizeProfile'

    /**
     * The method onDoSynchronizeProfile() is called by ASF when a client
     * invokes the method 'doSynchronizeProfile'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendDoSynchronizeProfile() or sendDoSynchronizeProfileError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'doSynchronizeProfile'</b>:
     *
     * Will mark the profile at ProfileIndex to be synchronized.
     *                        Synchronization is done if the profile is active and no other synchronization is pending.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDoSynchronizeProfileRequest (const ::boost::shared_ptr< DoSynchronizeProfileRequest >& request) = 0;

    /**
     * The method sendDoSynchronizeProfileResponse() sends a response of a
     * previous method invocation of 'doSynchronizeProfile' back to the
     * client.
     *
     * <b>Documentation of 'doSynchronizeProfile'</b>:
     *
     * Will mark the profile at ProfileIndex to be synchronized.
     *                        Synchronization is done if the profile is active and no other synchronization is pending.
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDoSynchronizeProfile(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDoSynchronizeProfileResponse (serverResult result, act_t act = 0);

    /**
     * The method sendDoSynchronizeProfileError() sends an error response of a
     * previous method invocation of 'doSynchronizeProfile' back to the
     * client.
     *
     * <b>Documentation of 'doSynchronizeProfile'</b>:
     *
     * Will mark the profile at ProfileIndex to be synchronized.
     *                        Synchronization is done if the profile is active and no other synchronization is pending.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onDoSynchronizeProfile(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDoSynchronizeProfileError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'doLinkProfile'

    /**
     * The method onDoLinkProfile() is called by ASF when a client invokes the
     * method 'doLinkProfile'. A subclass has to implement this method and
     * send back a response to the client either with the sendDoLinkProfile()
     * or sendDoLinkProfileError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'doLinkProfile'</b>:
     *
     * Request to Link a Profile. Shall result in setting the profile to type LINKED
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDoLinkProfileRequest (const ::boost::shared_ptr< DoLinkProfileRequest >& request) = 0;

    /**
     * The method sendDoLinkProfileResponse() sends a response of a previous
     * method invocation of 'doLinkProfile' back to the client.
     *
     * <b>Documentation of 'doLinkProfile'</b>:
     *
     * Request to Link a Profile. Shall result in setting the profile to type LINKED
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDoLinkProfile(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendDoLinkProfileResponse (serverResult result, act_t act = 0);

    /**
     * The method sendDoLinkProfileError() sends an error response of a
     * previous method invocation of 'doLinkProfile' back to the client.
     *
     * <b>Documentation of 'doLinkProfile'</b>:
     *
     * Request to Link a Profile. Shall result in setting the profile to type LINKED
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDoLinkProfile(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDoLinkProfileError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'doUnlinkProfile'

    /**
     * The method onDoUnlinkProfile() is called by ASF when a client invokes
     * the method 'doUnlinkProfile'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendDoUnlinkProfile() or sendDoUnlinkProfileError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'doUnlinkProfile'</b>:
     *
     * Request to Unlink a Profile. Shall result in setting the profile to type LOCAL
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDoUnlinkProfileRequest (const ::boost::shared_ptr< DoUnlinkProfileRequest >& request) = 0;

    /**
     * The method sendDoUnlinkProfileResponse() sends a response of a previous
     * method invocation of 'doUnlinkProfile' back to the client.
     *
     * <b>Documentation of 'doUnlinkProfile'</b>:
     *
     * Request to Unlink a Profile. Shall result in setting the profile to type LOCAL
     *
     * @param result If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDoUnlinkProfile(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendDoUnlinkProfileResponse (serverResult result, act_t act = 0);

    /**
     * The method sendDoUnlinkProfileError() sends an error response of a
     * previous method invocation of 'doUnlinkProfile' back to the client.
     *
     * <b>Documentation of 'doUnlinkProfile'</b>:
     *
     * Request to Unlink a Profile. Shall result in setting the profile to type LOCAL
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDoUnlinkProfile(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDoUnlinkProfileError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    StatusUpdate _statusProperty;

    AccountNameUpdate _accountNameProperty;

    KIDUpdate _kIDProperty;

    RemoteVehicleSettingsActivationUpdate _remoteVehicleSettingsActivationProperty;

    friend class ProfileConnectedStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace profileConnected
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_PROFILECONNECTEDSTUB_H
