#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_PROFILECONNECTED_H
#define BOSCH_CM_PROFILECONNECTED_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "bosch/cm/profileConnectedConst.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * attributes for connected User Profile Management
 */

namespace bosch {
namespace cm {
namespace profileConnected {

// method IDs
static const uint16 ID_doSynchronizeProfile = 0;
static const uint16 ID_doLinkProfile = 1;
static const uint16 ID_doUnlinkProfile = 2;

// signal IDs

// property IDs
static const uint16 ID_status = 3;
static const uint16 ID_accountName = 4;
static const uint16 ID_kID = 5;
static const uint16 ID_remoteVehicleSettingsActivation = 6;

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class DoSynchronizeProfileRequest;

class DoSynchronizeProfileResponse;

class DoLinkProfileRequest;

class DoLinkProfileResponse;

class DoUnlinkProfileRequest;

class DoUnlinkProfileResponse;

class StatusUpdate;

class StatusRegister;

class AccountNameUpdate;

class AccountNameRegister;

class KIDUpdate;

class KIDRegister;

class RemoteVehicleSettingsActivationUpdate;

class RemoteVehicleSettingsActivationRegister;

// type definitions
/**
 * If the meaning of "DoSynchronizeProfileError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DoSynchronizeProfileError;

/**
 * If the meaning of "DoLinkProfileError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DoLinkProfileError;

/**
 * If the meaning of "DoUnlinkProfileError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DoUnlinkProfileError;

/**
 * connected profile application status
 */
typedef StatusUpdate StatusSet;

/**
 * connected profile application status
 */
typedef StatusUpdate StatusGet;

/**
 * If the meaning of "StatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StatusError;

/**
 * accountName of the currently Logged on Profile.Valid Name is sent if logon is successful.Otherwise Empty name is sent
 */
typedef AccountNameUpdate AccountNameSet;

/**
 * accountName of the currently Logged on Profile.Valid Name is sent if logon is successful.Otherwise Empty name is sent
 */
typedef AccountNameUpdate AccountNameGet;

/**
 * If the meaning of "AccountNameError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AccountNameError;

/**
 * If the meaning of "kID" isn't clear, then there should be a description here.
 */
typedef KIDUpdate KIDSet;

/**
 * If the meaning of "kID" isn't clear, then there should be a description here.
 */
typedef KIDUpdate KIDGet;

/**
 * If the meaning of "KIDError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError KIDError;

/**
 * RVS is a Configuration Manager Setting Item maintained by PM. TRUE:Subscription is Active. FALSE: subscription is Inactive
 */
typedef RemoteVehicleSettingsActivationUpdate RemoteVehicleSettingsActivationSet;

/**
 * RVS is a Configuration Manager Setting Item maintained by PM. TRUE:Subscription is Active. FALSE: subscription is Inactive
 */
typedef RemoteVehicleSettingsActivationUpdate RemoteVehicleSettingsActivationGet;

/**
 * If the meaning of "RemoteVehicleSettingsActivationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RemoteVehicleSettingsActivationError;


/**
 * Will mark the profile at ProfileIndex to be synchronized.
 *                        Synchronization is done if the profile is active and no other synchronization is pending.
 */
class DoSynchronizeProfileRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoSynchronizeProfileRequest ();

    /**
     * Copy constructor
     */
    inline  DoSynchronizeProfileRequest (const DoSynchronizeProfileRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DoSynchronizeProfileRequest (uint8 profileIndex_);

    /**
     * Destructor
     */
    inline virtual  ~DoSynchronizeProfileRequest();

    /**
     * Assignment operator
     */
    inline DoSynchronizeProfileRequest& operator = (const DoSynchronizeProfileRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoSynchronizeProfileRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoSynchronizeProfileRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoSynchronizeProfileRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoSynchronizeProfileRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "profileIndex"

    static const int kProfileIndex = 0;

    /**
     * Clears the field "profileIndex".
     *
     * The field will be set to its default value. The hasProfileIndex()
     * method will return false.
     */
    inline void clearProfileIndex();

    /**
     * Checks whether the field "profileIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProfileIndex()). Otherwise it will return false.
     */
    inline bool hasProfileIndex () const;

    /**
     * Returns the value of the member "profileIndex".
     *
     * If the meaning of "profileIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "profileIndex"
     */
    inline uint8 getProfileIndex () const;

    /**
     * Sets the value of the member "profileIndex".
     *
     * If the meaning of "profileIndex" isn't clear, then there should be a description here.
     *
     * @param profileIndex The value which will be set
     */
    inline void setProfileIndex (uint8 profileIndex_);

    static const DoSynchronizeProfileRequest &getDefaultInstance();

private:

    inline void set_has_profileIndex ();

    inline void clear_has_profileIndex ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _profileIndex;

};

/**
 * Will mark the profile at ProfileIndex to be synchronized.
 *                        Synchronization is done if the profile is active and no other synchronization is pending.
 */
class DoSynchronizeProfileResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoSynchronizeProfileResponse ();

    /**
     * Copy constructor
     */
    inline  DoSynchronizeProfileResponse (const DoSynchronizeProfileResponse &rhs);

    /**
     * All fields constructor
     */
    inline  DoSynchronizeProfileResponse (serverResult result_);

    /**
     * Destructor
     */
    inline virtual  ~DoSynchronizeProfileResponse();

    /**
     * Assignment operator
     */
    inline DoSynchronizeProfileResponse& operator = (const DoSynchronizeProfileResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoSynchronizeProfileResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoSynchronizeProfileResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoSynchronizeProfileResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoSynchronizeProfileResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline serverResult getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (serverResult result_);

    static const DoSynchronizeProfileResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    serverResult _result;

};

/**
 * Request to Link a Profile. Shall result in setting the profile to type LINKED
 */
class DoLinkProfileRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoLinkProfileRequest ();

    /**
     * Copy constructor
     */
    inline  DoLinkProfileRequest (const DoLinkProfileRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DoLinkProfileRequest (const ::std::string& accountName_, const ::std::string& pwd_);

    /**
     * Destructor
     */
    inline virtual  ~DoLinkProfileRequest();

    /**
     * Assignment operator
     */
    inline DoLinkProfileRequest& operator = (const DoLinkProfileRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoLinkProfileRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoLinkProfileRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoLinkProfileRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoLinkProfileRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "accountName"

    static const int kAccountName = 0;

    /**
     * Clears the field "accountName".
     *
     * The field will be set to its default value. The hasAccountName()
     * method will return false.
     */
    inline void clearAccountName();

    /**
     * Checks whether the field "accountName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAccountName()). Otherwise it will return false.
     */
    inline bool hasAccountName () const;

    /**
     * Returns the value of the member "accountName".
     *
     * If the meaning of "accountName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "accountName"
     */
    inline const ::std::string& getAccountName () const;

    /**
     * Retrieves the value of the field "accountName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "accountName".
     */
    inline ::std::string& getAccountNameMutable ();

    /**
     * Sets the value of the member "accountName".
     *
     * If the meaning of "accountName" isn't clear, then there should be a description here.
     *
     * @param accountName The value which will be set
     */
    inline void setAccountName (const ::std::string& accountName_);

    /**
     * Sets the value of the member "accountName".
     *
     * If the meaning of "accountName" isn't clear, then there should be a description here.
     *
     * @param accountName The value which will be set
     */
    inline void setAccountName (const char* accountName_);

    /**
     * Sets the value of the member "accountName".
     *
     * If the meaning of "accountName" isn't clear, then there should be a description here.
     *
     * @param accountName The value which will be set
     */
    inline void setAccountName (const char* value, size_t size);

    // API of field "pwd"

    static const int kPwd = 1;

    /**
     * Clears the field "pwd".
     *
     * The field will be set to its default value. The hasPwd()
     * method will return false.
     */
    inline void clearPwd();

    /**
     * Checks whether the field "pwd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPwd()). Otherwise it will return false.
     */
    inline bool hasPwd () const;

    /**
     * Returns the value of the member "pwd".
     *
     * If the meaning of "pwd" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pwd"
     */
    inline const ::std::string& getPwd () const;

    /**
     * Retrieves the value of the field "pwd" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "pwd".
     */
    inline ::std::string& getPwdMutable ();

    /**
     * Sets the value of the member "pwd".
     *
     * If the meaning of "pwd" isn't clear, then there should be a description here.
     *
     * @param pwd The value which will be set
     */
    inline void setPwd (const ::std::string& pwd_);

    /**
     * Sets the value of the member "pwd".
     *
     * If the meaning of "pwd" isn't clear, then there should be a description here.
     *
     * @param pwd The value which will be set
     */
    inline void setPwd (const char* pwd_);

    /**
     * Sets the value of the member "pwd".
     *
     * If the meaning of "pwd" isn't clear, then there should be a description here.
     *
     * @param pwd The value which will be set
     */
    inline void setPwd (const char* value, size_t size);

    static const DoLinkProfileRequest &getDefaultInstance();

private:

    inline void set_has_accountName ();

    inline void clear_has_accountName ();

    inline void set_has_pwd ();

    inline void clear_has_pwd ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _accountName;

    ::std::string _pwd;

};

/**
 * Request to Link a Profile. Shall result in setting the profile to type LINKED
 */
class DoLinkProfileResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoLinkProfileResponse ();

    /**
     * Copy constructor
     */
    inline  DoLinkProfileResponse (const DoLinkProfileResponse &rhs);

    /**
     * All fields constructor
     */
    inline  DoLinkProfileResponse (serverResult result_);

    /**
     * Destructor
     */
    inline virtual  ~DoLinkProfileResponse();

    /**
     * Assignment operator
     */
    inline DoLinkProfileResponse& operator = (const DoLinkProfileResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoLinkProfileResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoLinkProfileResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoLinkProfileResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoLinkProfileResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline serverResult getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (serverResult result_);

    static const DoLinkProfileResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    serverResult _result;

};

/**
 * Request to Unlink a Profile. Shall result in setting the profile to type LOCAL
 */
class DoUnlinkProfileRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoUnlinkProfileRequest ();

    /**
     * Copy constructor
     */
    inline  DoUnlinkProfileRequest (const DoUnlinkProfileRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DoUnlinkProfileRequest (uint8 userID_);

    /**
     * Destructor
     */
    inline virtual  ~DoUnlinkProfileRequest();

    /**
     * Assignment operator
     */
    inline DoUnlinkProfileRequest& operator = (const DoUnlinkProfileRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoUnlinkProfileRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoUnlinkProfileRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoUnlinkProfileRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoUnlinkProfileRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "userID"

    static const int kUserID = 0;

    /**
     * Clears the field "userID".
     *
     * The field will be set to its default value. The hasUserID()
     * method will return false.
     */
    inline void clearUserID();

    /**
     * Checks whether the field "userID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserID()). Otherwise it will return false.
     */
    inline bool hasUserID () const;

    /**
     * Returns the value of the member "userID".
     *
     * If the meaning of "userID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "userID"
     */
    inline uint8 getUserID () const;

    /**
     * Sets the value of the member "userID".
     *
     * If the meaning of "userID" isn't clear, then there should be a description here.
     *
     * @param userID The value which will be set
     */
    inline void setUserID (uint8 userID_);

    static const DoUnlinkProfileRequest &getDefaultInstance();

private:

    inline void set_has_userID ();

    inline void clear_has_userID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _userID;

};

/**
 * Request to Unlink a Profile. Shall result in setting the profile to type LOCAL
 */
class DoUnlinkProfileResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoUnlinkProfileResponse ();

    /**
     * Copy constructor
     */
    inline  DoUnlinkProfileResponse (const DoUnlinkProfileResponse &rhs);

    /**
     * All fields constructor
     */
    inline  DoUnlinkProfileResponse (serverResult result_);

    /**
     * Destructor
     */
    inline virtual  ~DoUnlinkProfileResponse();

    /**
     * Assignment operator
     */
    inline DoUnlinkProfileResponse& operator = (const DoUnlinkProfileResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoUnlinkProfileResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoUnlinkProfileResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoUnlinkProfileResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoUnlinkProfileResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline serverResult getResult () const;

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (serverResult result_);

    static const DoUnlinkProfileResponse &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    serverResult _result;

};

/**
 * connected profile application status
 */
class StatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StatusUpdate ();

    /**
     * Copy constructor
     */
    inline  StatusUpdate (const StatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  StatusUpdate (appStatus status_);

    /**
     * Destructor
     */
    inline virtual  ~StatusUpdate();

    /**
     * Assignment operator
     */
    inline StatusUpdate& operator = (const StatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * connected profile application status
     *
     * @return The value of the field "status"
     */
    inline appStatus getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * connected profile application status
     *
     * @param status The value which will be set
     */
    inline void setStatus (appStatus status_);

    static const StatusUpdate &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    appStatus _status;

};

/**
 * connected profile application status
 */
class StatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StatusRegister ();

    /**
     * Copy constructor
     */
    inline  StatusRegister (const StatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~StatusRegister();

    /**
     * Assignment operator
     */
    inline StatusRegister& operator = (const StatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const StatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * accountName of the currently Logged on Profile.Valid Name is sent if logon is successful.Otherwise Empty name is sent
 */
class AccountNameUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AccountNameUpdate ();

    /**
     * Copy constructor
     */
    inline  AccountNameUpdate (const AccountNameUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AccountNameUpdate (const ::std::string& accountName_);

    /**
     * Destructor
     */
    inline virtual  ~AccountNameUpdate();

    /**
     * Assignment operator
     */
    inline AccountNameUpdate& operator = (const AccountNameUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AccountNameUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AccountNameUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AccountNameUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AccountNameUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "accountName"

    static const int kAccountName = 0;

    /**
     * Clears the field "accountName".
     *
     * The field will be set to its default value. The hasAccountName()
     * method will return false.
     */
    inline void clearAccountName();

    /**
     * Checks whether the field "accountName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAccountName()). Otherwise it will return false.
     */
    inline bool hasAccountName () const;

    /**
     * Returns the value of the member "accountName".
     *
     * accountName of the currently Logged on Profile.Valid Name is sent if logon is successful.Otherwise Empty name is sent
     *
     * @return The value of the field "accountName"
     */
    inline const ::std::string& getAccountName () const;

    /**
     * Retrieves the value of the field "accountName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "accountName".
     */
    inline ::std::string& getAccountNameMutable ();

    /**
     * Sets the value of the member "accountName".
     *
     * accountName of the currently Logged on Profile.Valid Name is sent if logon is successful.Otherwise Empty name is sent
     *
     * @param accountName The value which will be set
     */
    inline void setAccountName (const ::std::string& accountName_);

    /**
     * Sets the value of the member "accountName".
     *
     * accountName of the currently Logged on Profile.Valid Name is sent if logon is successful.Otherwise Empty name is sent
     *
     * @param accountName The value which will be set
     */
    inline void setAccountName (const char* accountName_);

    /**
     * Sets the value of the member "accountName".
     *
     * accountName of the currently Logged on Profile.Valid Name is sent if logon is successful.Otherwise Empty name is sent
     *
     * @param accountName The value which will be set
     */
    inline void setAccountName (const char* value, size_t size);

    static const AccountNameUpdate &getDefaultInstance();

private:

    inline void set_has_accountName ();

    inline void clear_has_accountName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _accountName;

};

/**
 * accountName of the currently Logged on Profile.Valid Name is sent if logon is successful.Otherwise Empty name is sent
 */
class AccountNameRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AccountNameRegister ();

    /**
     * Copy constructor
     */
    inline  AccountNameRegister (const AccountNameRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AccountNameRegister();

    /**
     * Assignment operator
     */
    inline AccountNameRegister& operator = (const AccountNameRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AccountNameRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AccountNameRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AccountNameRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AccountNameRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AccountNameRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "kID" isn't clear, then there should be a description here.
 */
class KIDUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  KIDUpdate ();

    /**
     * Copy constructor
     */
    inline  KIDUpdate (const KIDUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  KIDUpdate (const ::std::string& kID_);

    /**
     * Destructor
     */
    inline virtual  ~KIDUpdate();

    /**
     * Assignment operator
     */
    inline KIDUpdate& operator = (const KIDUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const KIDUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const KIDUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const KIDUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const KIDUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "kID"

    static const int kKID = 0;

    /**
     * Clears the field "kID".
     *
     * The field will be set to its default value. The hasKID()
     * method will return false.
     */
    inline void clearKID();

    /**
     * Checks whether the field "kID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKID()). Otherwise it will return false.
     */
    inline bool hasKID () const;

    /**
     * Returns the value of the member "kID".
     *
     * If the meaning of "kID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "kID"
     */
    inline const ::std::string& getKID () const;

    /**
     * Retrieves the value of the field "kID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "kID".
     */
    inline ::std::string& getKIDMutable ();

    /**
     * Sets the value of the member "kID".
     *
     * If the meaning of "kID" isn't clear, then there should be a description here.
     *
     * @param kID The value which will be set
     */
    inline void setKID (const ::std::string& kID_);

    /**
     * Sets the value of the member "kID".
     *
     * If the meaning of "kID" isn't clear, then there should be a description here.
     *
     * @param kID The value which will be set
     */
    inline void setKID (const char* kID_);

    /**
     * Sets the value of the member "kID".
     *
     * If the meaning of "kID" isn't clear, then there should be a description here.
     *
     * @param kID The value which will be set
     */
    inline void setKID (const char* value, size_t size);

    static const KIDUpdate &getDefaultInstance();

private:

    inline void set_has_kID ();

    inline void clear_has_kID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _kID;

};

/**
 * If the meaning of "kID" isn't clear, then there should be a description here.
 */
class KIDRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  KIDRegister ();

    /**
     * Copy constructor
     */
    inline  KIDRegister (const KIDRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~KIDRegister();

    /**
     * Assignment operator
     */
    inline KIDRegister& operator = (const KIDRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const KIDRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const KIDRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const KIDRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const KIDRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const KIDRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * RVS is a Configuration Manager Setting Item maintained by PM. TRUE:Subscription is Active. FALSE: subscription is Inactive
 */
class RemoteVehicleSettingsActivationUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoteVehicleSettingsActivationUpdate ();

    /**
     * Copy constructor
     */
    inline  RemoteVehicleSettingsActivationUpdate (const RemoteVehicleSettingsActivationUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RemoteVehicleSettingsActivationUpdate (bool remoteVehicleSettingsActivation_);

    /**
     * Destructor
     */
    inline virtual  ~RemoteVehicleSettingsActivationUpdate();

    /**
     * Assignment operator
     */
    inline RemoteVehicleSettingsActivationUpdate& operator = (const RemoteVehicleSettingsActivationUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoteVehicleSettingsActivationUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoteVehicleSettingsActivationUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoteVehicleSettingsActivationUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoteVehicleSettingsActivationUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "remoteVehicleSettingsActivation"

    static const int kRemoteVehicleSettingsActivation = 0;

    /**
     * Clears the field "remoteVehicleSettingsActivation".
     *
     * The field will be set to its default value. The hasRemoteVehicleSettingsActivation()
     * method will return false.
     */
    inline void clearRemoteVehicleSettingsActivation();

    /**
     * Checks whether the field "remoteVehicleSettingsActivation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRemoteVehicleSettingsActivation()). Otherwise it will return false.
     */
    inline bool hasRemoteVehicleSettingsActivation () const;

    /**
     * Returns the value of the member "remoteVehicleSettingsActivation".
     *
     * RVS is a Configuration Manager Setting Item maintained by PM. TRUE:Subscription is Active. FALSE: subscription is Inactive
     *
     * @return The value of the field "remoteVehicleSettingsActivation"
     */
    inline bool getRemoteVehicleSettingsActivation () const;

    /**
     * Sets the value of the member "remoteVehicleSettingsActivation".
     *
     * RVS is a Configuration Manager Setting Item maintained by PM. TRUE:Subscription is Active. FALSE: subscription is Inactive
     *
     * @param remoteVehicleSettingsActivation The value which will be set
     */
    inline void setRemoteVehicleSettingsActivation (bool remoteVehicleSettingsActivation_);

    static const RemoteVehicleSettingsActivationUpdate &getDefaultInstance();

private:

    inline void set_has_remoteVehicleSettingsActivation ();

    inline void clear_has_remoteVehicleSettingsActivation ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _remoteVehicleSettingsActivation;

};

/**
 * RVS is a Configuration Manager Setting Item maintained by PM. TRUE:Subscription is Active. FALSE: subscription is Inactive
 */
class RemoteVehicleSettingsActivationRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoteVehicleSettingsActivationRegister ();

    /**
     * Copy constructor
     */
    inline  RemoteVehicleSettingsActivationRegister (const RemoteVehicleSettingsActivationRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RemoteVehicleSettingsActivationRegister();

    /**
     * Assignment operator
     */
    inline RemoteVehicleSettingsActivationRegister& operator = (const RemoteVehicleSettingsActivationRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoteVehicleSettingsActivationRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoteVehicleSettingsActivationRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoteVehicleSettingsActivationRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoteVehicleSettingsActivationRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RemoteVehicleSettingsActivationRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  DoSynchronizeProfileRequest::DoSynchronizeProfileRequest ()  :
    _profileIndex (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoSynchronizeProfileRequest::DoSynchronizeProfileRequest (const DoSynchronizeProfileRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _profileIndex (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoSynchronizeProfileRequest::DoSynchronizeProfileRequest (uint8 profileIndex_)  :
    _profileIndex (profileIndex_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoSynchronizeProfileRequest::~DoSynchronizeProfileRequest() {
}

inline DoSynchronizeProfileRequest& DoSynchronizeProfileRequest::operator = (const DoSynchronizeProfileRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProfileIndex()) {
            setProfileIndex(rhs.getProfileIndex());
        } else {
            clearProfileIndex();
        }
    }
    return *this;
}

inline bool DoSynchronizeProfileRequest::operator == (const DoSynchronizeProfileRequest& rhs) const {
    return (((!hasProfileIndex() && !rhs.hasProfileIndex()) || getProfileIndex() == rhs.getProfileIndex()));
}

inline bool DoSynchronizeProfileRequest::operator != (const DoSynchronizeProfileRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DoSynchronizeProfileRequest::operator < (const DoSynchronizeProfileRequest& rhs) const {
    if (hasProfileIndex() || rhs.hasProfileIndex()) {
        if (getProfileIndex() < rhs.getProfileIndex()) return true;
        if (getProfileIndex() > rhs.getProfileIndex()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoSynchronizeProfileRequest::clone() {
    return new DoSynchronizeProfileRequest(*this);
}

inline bool DoSynchronizeProfileRequest::operator > (const DoSynchronizeProfileRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoSynchronizeProfileRequest::clear() {
    clearProfileIndex();
}

inline void DoSynchronizeProfileRequest::clearProfileIndex() {
    if (hasProfileIndex()) {
         clear_has_profileIndex();
        _profileIndex = 0u;
     }
}

inline bool DoSynchronizeProfileRequest::hasProfileIndex () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DoSynchronizeProfileRequest::getProfileIndex () const {
    return _profileIndex;
}

inline void DoSynchronizeProfileRequest::setProfileIndex (uint8 profileIndex_) {
    set_has_profileIndex();
    this->_profileIndex = profileIndex_;
}

inline void DoSynchronizeProfileRequest::set_has_profileIndex () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoSynchronizeProfileRequest::clear_has_profileIndex () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoSynchronizeProfileResponse::DoSynchronizeProfileResponse ()  :
    _result (::bosch::cm::profileConnected::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoSynchronizeProfileResponse::DoSynchronizeProfileResponse (const DoSynchronizeProfileResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (::bosch::cm::profileConnected::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoSynchronizeProfileResponse::DoSynchronizeProfileResponse (serverResult result_)  :
    _result (result_)
{
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "DoSynchronizeProfileResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoSynchronizeProfileResponse::~DoSynchronizeProfileResponse() {
}

inline DoSynchronizeProfileResponse& DoSynchronizeProfileResponse::operator = (const DoSynchronizeProfileResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool DoSynchronizeProfileResponse::operator == (const DoSynchronizeProfileResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool DoSynchronizeProfileResponse::operator != (const DoSynchronizeProfileResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool DoSynchronizeProfileResponse::operator < (const DoSynchronizeProfileResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoSynchronizeProfileResponse::clone() {
    return new DoSynchronizeProfileResponse(*this);
}

inline bool DoSynchronizeProfileResponse::operator > (const DoSynchronizeProfileResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoSynchronizeProfileResponse::clear() {
    clearResult();
}

inline void DoSynchronizeProfileResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = ::bosch::cm::profileConnected::serverResult__SUCCESS;
     }
}

inline bool DoSynchronizeProfileResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline serverResult DoSynchronizeProfileResponse::getResult () const {
    return _result;
}

inline void DoSynchronizeProfileResponse::setResult (serverResult result_) {
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "DoSynchronizeProfileResponse");
    }
    #endif
    set_has_result();
    this->_result = result_;
}

inline void DoSynchronizeProfileResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoSynchronizeProfileResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoLinkProfileRequest::DoLinkProfileRequest ()  :
    _accountName (),
    _pwd ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoLinkProfileRequest::DoLinkProfileRequest (const DoLinkProfileRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _accountName (),
    _pwd ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoLinkProfileRequest::DoLinkProfileRequest (const ::std::string& accountName_, const ::std::string& pwd_)  :
    _accountName (accountName_),
    _pwd (pwd_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (accountName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (pwd_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoLinkProfileRequest::~DoLinkProfileRequest() {
}

inline DoLinkProfileRequest& DoLinkProfileRequest::operator = (const DoLinkProfileRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAccountName()) {
            setAccountName(rhs.getAccountName());
        } else {
            clearAccountName();
        }
        if (rhs.hasPwd()) {
            setPwd(rhs.getPwd());
        } else {
            clearPwd();
        }
    }
    return *this;
}

inline bool DoLinkProfileRequest::operator == (const DoLinkProfileRequest& rhs) const {
    return (((!hasAccountName() && !rhs.hasAccountName()) || getAccountName() == rhs.getAccountName()) &&
        ((!hasPwd() && !rhs.hasPwd()) || getPwd() == rhs.getPwd()));
}

inline bool DoLinkProfileRequest::operator != (const DoLinkProfileRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DoLinkProfileRequest::operator < (const DoLinkProfileRequest& rhs) const {
    if (hasAccountName() || rhs.hasAccountName()) {
        if (getAccountName() < rhs.getAccountName()) return true;
        if (getAccountName() > rhs.getAccountName()) return false;
    }
    if (hasPwd() || rhs.hasPwd()) {
        if (getPwd() < rhs.getPwd()) return true;
        if (getPwd() > rhs.getPwd()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoLinkProfileRequest::clone() {
    return new DoLinkProfileRequest(*this);
}

inline bool DoLinkProfileRequest::operator > (const DoLinkProfileRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoLinkProfileRequest::clear() {
    clearAccountName();
    clearPwd();
}

inline void DoLinkProfileRequest::clearAccountName() {
    if (hasAccountName()) {
         clear_has_accountName();
        _accountName.clear();
     }
}

inline bool DoLinkProfileRequest::hasAccountName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DoLinkProfileRequest::getAccountName () const {
    return _accountName;
}

inline ::std::string& DoLinkProfileRequest::getAccountNameMutable () {
    set_has_accountName();
    return _accountName;
}

inline void DoLinkProfileRequest::setAccountName (const ::std::string& accountName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (accountName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_accountName();
    this->_accountName = accountName_;
}

inline void DoLinkProfileRequest::setAccountName (const char* accountName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (accountName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_accountName();
    this->_accountName.assign(accountName_);
}

inline void DoLinkProfileRequest::setAccountName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_accountName();
    this->_accountName.assign(value, size);
}

inline void DoLinkProfileRequest::clearPwd() {
    if (hasPwd()) {
         clear_has_pwd();
        _pwd.clear();
     }
}

inline bool DoLinkProfileRequest::hasPwd () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& DoLinkProfileRequest::getPwd () const {
    return _pwd;
}

inline ::std::string& DoLinkProfileRequest::getPwdMutable () {
    set_has_pwd();
    return _pwd;
}

inline void DoLinkProfileRequest::setPwd (const ::std::string& pwd_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (pwd_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_pwd();
    this->_pwd = pwd_;
}

inline void DoLinkProfileRequest::setPwd (const char* pwd_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (pwd_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_pwd();
    this->_pwd.assign(pwd_);
}

inline void DoLinkProfileRequest::setPwd (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_pwd();
    this->_pwd.assign(value, size);
}

inline void DoLinkProfileRequest::set_has_accountName () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoLinkProfileRequest::clear_has_accountName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DoLinkProfileRequest::set_has_pwd () {
    _has_bits_[0] |= 1u << 1;
}

inline void DoLinkProfileRequest::clear_has_pwd () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DoLinkProfileResponse::DoLinkProfileResponse ()  :
    _result (::bosch::cm::profileConnected::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoLinkProfileResponse::DoLinkProfileResponse (const DoLinkProfileResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (::bosch::cm::profileConnected::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoLinkProfileResponse::DoLinkProfileResponse (serverResult result_)  :
    _result (result_)
{
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "DoLinkProfileResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoLinkProfileResponse::~DoLinkProfileResponse() {
}

inline DoLinkProfileResponse& DoLinkProfileResponse::operator = (const DoLinkProfileResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool DoLinkProfileResponse::operator == (const DoLinkProfileResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool DoLinkProfileResponse::operator != (const DoLinkProfileResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool DoLinkProfileResponse::operator < (const DoLinkProfileResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoLinkProfileResponse::clone() {
    return new DoLinkProfileResponse(*this);
}

inline bool DoLinkProfileResponse::operator > (const DoLinkProfileResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoLinkProfileResponse::clear() {
    clearResult();
}

inline void DoLinkProfileResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = ::bosch::cm::profileConnected::serverResult__SUCCESS;
     }
}

inline bool DoLinkProfileResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline serverResult DoLinkProfileResponse::getResult () const {
    return _result;
}

inline void DoLinkProfileResponse::setResult (serverResult result_) {
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "DoLinkProfileResponse");
    }
    #endif
    set_has_result();
    this->_result = result_;
}

inline void DoLinkProfileResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoLinkProfileResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoUnlinkProfileRequest::DoUnlinkProfileRequest ()  :
    _userID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoUnlinkProfileRequest::DoUnlinkProfileRequest (const DoUnlinkProfileRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _userID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoUnlinkProfileRequest::DoUnlinkProfileRequest (uint8 userID_)  :
    _userID (userID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoUnlinkProfileRequest::~DoUnlinkProfileRequest() {
}

inline DoUnlinkProfileRequest& DoUnlinkProfileRequest::operator = (const DoUnlinkProfileRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUserID()) {
            setUserID(rhs.getUserID());
        } else {
            clearUserID();
        }
    }
    return *this;
}

inline bool DoUnlinkProfileRequest::operator == (const DoUnlinkProfileRequest& rhs) const {
    return (((!hasUserID() && !rhs.hasUserID()) || getUserID() == rhs.getUserID()));
}

inline bool DoUnlinkProfileRequest::operator != (const DoUnlinkProfileRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DoUnlinkProfileRequest::operator < (const DoUnlinkProfileRequest& rhs) const {
    if (hasUserID() || rhs.hasUserID()) {
        if (getUserID() < rhs.getUserID()) return true;
        if (getUserID() > rhs.getUserID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoUnlinkProfileRequest::clone() {
    return new DoUnlinkProfileRequest(*this);
}

inline bool DoUnlinkProfileRequest::operator > (const DoUnlinkProfileRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoUnlinkProfileRequest::clear() {
    clearUserID();
}

inline void DoUnlinkProfileRequest::clearUserID() {
    if (hasUserID()) {
         clear_has_userID();
        _userID = 0u;
     }
}

inline bool DoUnlinkProfileRequest::hasUserID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DoUnlinkProfileRequest::getUserID () const {
    return _userID;
}

inline void DoUnlinkProfileRequest::setUserID (uint8 userID_) {
    set_has_userID();
    this->_userID = userID_;
}

inline void DoUnlinkProfileRequest::set_has_userID () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoUnlinkProfileRequest::clear_has_userID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoUnlinkProfileResponse::DoUnlinkProfileResponse ()  :
    _result (::bosch::cm::profileConnected::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoUnlinkProfileResponse::DoUnlinkProfileResponse (const DoUnlinkProfileResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _result (::bosch::cm::profileConnected::serverResult__SUCCESS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoUnlinkProfileResponse::DoUnlinkProfileResponse (serverResult result_)  :
    _result (result_)
{
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "DoUnlinkProfileResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoUnlinkProfileResponse::~DoUnlinkProfileResponse() {
}

inline DoUnlinkProfileResponse& DoUnlinkProfileResponse::operator = (const DoUnlinkProfileResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool DoUnlinkProfileResponse::operator == (const DoUnlinkProfileResponse& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool DoUnlinkProfileResponse::operator != (const DoUnlinkProfileResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool DoUnlinkProfileResponse::operator < (const DoUnlinkProfileResponse& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoUnlinkProfileResponse::clone() {
    return new DoUnlinkProfileResponse(*this);
}

inline bool DoUnlinkProfileResponse::operator > (const DoUnlinkProfileResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoUnlinkProfileResponse::clear() {
    clearResult();
}

inline void DoUnlinkProfileResponse::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result = ::bosch::cm::profileConnected::serverResult__SUCCESS;
     }
}

inline bool DoUnlinkProfileResponse::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline serverResult DoUnlinkProfileResponse::getResult () const {
    return _result;
}

inline void DoUnlinkProfileResponse::setResult (serverResult result_) {
    #ifndef NDEBUG
    if (!(serverResult_IsValid(result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", result_, "serverResult", "result", "DoUnlinkProfileResponse");
    }
    #endif
    set_has_result();
    this->_result = result_;
}

inline void DoUnlinkProfileResponse::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoUnlinkProfileResponse::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StatusUpdate::StatusUpdate ()  :
    _status (::bosch::cm::profileConnected::appStatus__IDLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StatusUpdate::StatusUpdate (const StatusUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _status (::bosch::cm::profileConnected::appStatus__IDLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StatusUpdate::StatusUpdate (appStatus status_)  :
    _status (status_)
{
    #ifndef NDEBUG
    if (!(appStatus_IsValid(status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "appStatus", "status", "StatusUpdate");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StatusUpdate::~StatusUpdate() {
}

inline StatusUpdate& StatusUpdate::operator = (const StatusUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool StatusUpdate::operator == (const StatusUpdate& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool StatusUpdate::operator != (const StatusUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool StatusUpdate::operator < (const StatusUpdate& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StatusUpdate::clone() {
    return new StatusUpdate(*this);
}

inline bool StatusUpdate::operator > (const StatusUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StatusUpdate::clear() {
    clearStatus();
}

inline void StatusUpdate::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = ::bosch::cm::profileConnected::appStatus__IDLE;
     }
}

inline bool StatusUpdate::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline appStatus StatusUpdate::getStatus () const {
    return _status;
}

inline void StatusUpdate::setStatus (appStatus status_) {
    #ifndef NDEBUG
    if (!(appStatus_IsValid(status_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", status_, "appStatus", "status", "StatusUpdate");
    }
    #endif
    set_has_status();
    this->_status = status_;
}

inline void StatusUpdate::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void StatusUpdate::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StatusRegister::StatusRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StatusRegister::StatusRegister (const StatusRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StatusRegister::~StatusRegister() {
}

inline StatusRegister& StatusRegister::operator = (const StatusRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool StatusRegister::operator == (const StatusRegister& ) const {
    return true;
}

inline bool StatusRegister::operator != (const StatusRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool StatusRegister::operator < (const StatusRegister& ) const {
    return false;
}

inline ::asf::core::Payload* StatusRegister::clone() {
    return new StatusRegister(*this);
}

inline bool StatusRegister::operator > (const StatusRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StatusRegister::clear() {
}

inline  AccountNameUpdate::AccountNameUpdate ()  :
    _accountName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AccountNameUpdate::AccountNameUpdate (const AccountNameUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _accountName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AccountNameUpdate::AccountNameUpdate (const ::std::string& accountName_)  :
    _accountName (accountName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (accountName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AccountNameUpdate::~AccountNameUpdate() {
}

inline AccountNameUpdate& AccountNameUpdate::operator = (const AccountNameUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAccountName()) {
            setAccountName(rhs.getAccountName());
        } else {
            clearAccountName();
        }
    }
    return *this;
}

inline bool AccountNameUpdate::operator == (const AccountNameUpdate& rhs) const {
    return (((!hasAccountName() && !rhs.hasAccountName()) || getAccountName() == rhs.getAccountName()));
}

inline bool AccountNameUpdate::operator != (const AccountNameUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AccountNameUpdate::operator < (const AccountNameUpdate& rhs) const {
    if (hasAccountName() || rhs.hasAccountName()) {
        if (getAccountName() < rhs.getAccountName()) return true;
        if (getAccountName() > rhs.getAccountName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AccountNameUpdate::clone() {
    return new AccountNameUpdate(*this);
}

inline bool AccountNameUpdate::operator > (const AccountNameUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AccountNameUpdate::clear() {
    clearAccountName();
}

inline void AccountNameUpdate::clearAccountName() {
    if (hasAccountName()) {
         clear_has_accountName();
        _accountName.clear();
     }
}

inline bool AccountNameUpdate::hasAccountName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& AccountNameUpdate::getAccountName () const {
    return _accountName;
}

inline ::std::string& AccountNameUpdate::getAccountNameMutable () {
    set_has_accountName();
    return _accountName;
}

inline void AccountNameUpdate::setAccountName (const ::std::string& accountName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (accountName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_accountName();
    this->_accountName = accountName_;
}

inline void AccountNameUpdate::setAccountName (const char* accountName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (accountName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_accountName();
    this->_accountName.assign(accountName_);
}

inline void AccountNameUpdate::setAccountName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_accountName();
    this->_accountName.assign(value, size);
}

inline void AccountNameUpdate::set_has_accountName () {
    _has_bits_[0] |= 1u << 0;
}

inline void AccountNameUpdate::clear_has_accountName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AccountNameRegister::AccountNameRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AccountNameRegister::AccountNameRegister (const AccountNameRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AccountNameRegister::~AccountNameRegister() {
}

inline AccountNameRegister& AccountNameRegister::operator = (const AccountNameRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AccountNameRegister::operator == (const AccountNameRegister& ) const {
    return true;
}

inline bool AccountNameRegister::operator != (const AccountNameRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AccountNameRegister::operator < (const AccountNameRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AccountNameRegister::clone() {
    return new AccountNameRegister(*this);
}

inline bool AccountNameRegister::operator > (const AccountNameRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AccountNameRegister::clear() {
}

inline  KIDUpdate::KIDUpdate ()  :
    _kID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  KIDUpdate::KIDUpdate (const KIDUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _kID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  KIDUpdate::KIDUpdate (const ::std::string& kID_)  :
    _kID (kID_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (kID_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  KIDUpdate::~KIDUpdate() {
}

inline KIDUpdate& KIDUpdate::operator = (const KIDUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasKID()) {
            setKID(rhs.getKID());
        } else {
            clearKID();
        }
    }
    return *this;
}

inline bool KIDUpdate::operator == (const KIDUpdate& rhs) const {
    return (((!hasKID() && !rhs.hasKID()) || getKID() == rhs.getKID()));
}

inline bool KIDUpdate::operator != (const KIDUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool KIDUpdate::operator < (const KIDUpdate& rhs) const {
    if (hasKID() || rhs.hasKID()) {
        if (getKID() < rhs.getKID()) return true;
        if (getKID() > rhs.getKID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* KIDUpdate::clone() {
    return new KIDUpdate(*this);
}

inline bool KIDUpdate::operator > (const KIDUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void KIDUpdate::clear() {
    clearKID();
}

inline void KIDUpdate::clearKID() {
    if (hasKID()) {
         clear_has_kID();
        _kID.clear();
     }
}

inline bool KIDUpdate::hasKID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& KIDUpdate::getKID () const {
    return _kID;
}

inline ::std::string& KIDUpdate::getKIDMutable () {
    set_has_kID();
    return _kID;
}

inline void KIDUpdate::setKID (const ::std::string& kID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (kID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_kID();
    this->_kID = kID_;
}

inline void KIDUpdate::setKID (const char* kID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (kID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_kID();
    this->_kID.assign(kID_);
}

inline void KIDUpdate::setKID (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_kID();
    this->_kID.assign(value, size);
}

inline void KIDUpdate::set_has_kID () {
    _has_bits_[0] |= 1u << 0;
}

inline void KIDUpdate::clear_has_kID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  KIDRegister::KIDRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  KIDRegister::KIDRegister (const KIDRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  KIDRegister::~KIDRegister() {
}

inline KIDRegister& KIDRegister::operator = (const KIDRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool KIDRegister::operator == (const KIDRegister& ) const {
    return true;
}

inline bool KIDRegister::operator != (const KIDRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool KIDRegister::operator < (const KIDRegister& ) const {
    return false;
}

inline ::asf::core::Payload* KIDRegister::clone() {
    return new KIDRegister(*this);
}

inline bool KIDRegister::operator > (const KIDRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void KIDRegister::clear() {
}

inline  RemoteVehicleSettingsActivationUpdate::RemoteVehicleSettingsActivationUpdate ()  :
    _remoteVehicleSettingsActivation (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoteVehicleSettingsActivationUpdate::RemoteVehicleSettingsActivationUpdate (const RemoteVehicleSettingsActivationUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _remoteVehicleSettingsActivation (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoteVehicleSettingsActivationUpdate::RemoteVehicleSettingsActivationUpdate (bool remoteVehicleSettingsActivation_)  :
    _remoteVehicleSettingsActivation (remoteVehicleSettingsActivation_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoteVehicleSettingsActivationUpdate::~RemoteVehicleSettingsActivationUpdate() {
}

inline RemoteVehicleSettingsActivationUpdate& RemoteVehicleSettingsActivationUpdate::operator = (const RemoteVehicleSettingsActivationUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRemoteVehicleSettingsActivation()) {
            setRemoteVehicleSettingsActivation(rhs.getRemoteVehicleSettingsActivation());
        } else {
            clearRemoteVehicleSettingsActivation();
        }
    }
    return *this;
}

inline bool RemoteVehicleSettingsActivationUpdate::operator == (const RemoteVehicleSettingsActivationUpdate& rhs) const {
    return (((!hasRemoteVehicleSettingsActivation() && !rhs.hasRemoteVehicleSettingsActivation()) || getRemoteVehicleSettingsActivation() == rhs.getRemoteVehicleSettingsActivation()));
}

inline bool RemoteVehicleSettingsActivationUpdate::operator != (const RemoteVehicleSettingsActivationUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoteVehicleSettingsActivationUpdate::operator < (const RemoteVehicleSettingsActivationUpdate& rhs) const {
    if (hasRemoteVehicleSettingsActivation() || rhs.hasRemoteVehicleSettingsActivation()) {
        if (getRemoteVehicleSettingsActivation() < rhs.getRemoteVehicleSettingsActivation()) return true;
        if (getRemoteVehicleSettingsActivation() > rhs.getRemoteVehicleSettingsActivation()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoteVehicleSettingsActivationUpdate::clone() {
    return new RemoteVehicleSettingsActivationUpdate(*this);
}

inline bool RemoteVehicleSettingsActivationUpdate::operator > (const RemoteVehicleSettingsActivationUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoteVehicleSettingsActivationUpdate::clear() {
    clearRemoteVehicleSettingsActivation();
}

inline void RemoteVehicleSettingsActivationUpdate::clearRemoteVehicleSettingsActivation() {
    if (hasRemoteVehicleSettingsActivation()) {
         clear_has_remoteVehicleSettingsActivation();
        _remoteVehicleSettingsActivation = false;
     }
}

inline bool RemoteVehicleSettingsActivationUpdate::hasRemoteVehicleSettingsActivation () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool RemoteVehicleSettingsActivationUpdate::getRemoteVehicleSettingsActivation () const {
    return _remoteVehicleSettingsActivation;
}

inline void RemoteVehicleSettingsActivationUpdate::setRemoteVehicleSettingsActivation (bool remoteVehicleSettingsActivation_) {
    set_has_remoteVehicleSettingsActivation();
    this->_remoteVehicleSettingsActivation = remoteVehicleSettingsActivation_;
}

inline void RemoteVehicleSettingsActivationUpdate::set_has_remoteVehicleSettingsActivation () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoteVehicleSettingsActivationUpdate::clear_has_remoteVehicleSettingsActivation () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RemoteVehicleSettingsActivationRegister::RemoteVehicleSettingsActivationRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoteVehicleSettingsActivationRegister::RemoteVehicleSettingsActivationRegister (const RemoteVehicleSettingsActivationRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoteVehicleSettingsActivationRegister::~RemoteVehicleSettingsActivationRegister() {
}

inline RemoteVehicleSettingsActivationRegister& RemoteVehicleSettingsActivationRegister::operator = (const RemoteVehicleSettingsActivationRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool RemoteVehicleSettingsActivationRegister::operator == (const RemoteVehicleSettingsActivationRegister& ) const {
    return true;
}

inline bool RemoteVehicleSettingsActivationRegister::operator != (const RemoteVehicleSettingsActivationRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoteVehicleSettingsActivationRegister::operator < (const RemoteVehicleSettingsActivationRegister& ) const {
    return false;
}

inline ::asf::core::Payload* RemoteVehicleSettingsActivationRegister::clone() {
    return new RemoteVehicleSettingsActivationRegister(*this);
}

inline bool RemoteVehicleSettingsActivationRegister::operator > (const RemoteVehicleSettingsActivationRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoteVehicleSettingsActivationRegister::clear() {
}

} // namespace profileConnected
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_PROFILECONNECTED_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
