#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MIDW_TUNERMASTER_FI_TYPES_H
#define MIDW_TUNERMASTER_FI_TYPES_H

#include "asf/core/Internal.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "midw_tunermaster_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types midw_tunermaster_fi_types
 */

namespace midw_tunermaster_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_TunerMaster_StatusResponse;

class T_TunMstr_RadioSetting_StatusResponse;

class Tunmstr_RFAntenna;

class T_SXMPresetListEntry;

class T_SXMChannelAttributes;

class T_PresetList;

class T_SXMPresetEntry;

class T_SXMChannelImagedata;

class T_b32_AnnoType;

class T_b8_SourceAnno;

class T_b8_ModeType;

class T_DAB_Label;

class T_b8_RadioProfileSettingAction;

class T_TunMst_PresetListElement;

class T_ProfileResponse;


/**
 * Tuner Server sends status back to the client.
 */
class T_TunerMaster_StatusResponse {
public:

    /**
     * Default constructor
     */
    inline  T_TunerMaster_StatusResponse ();

    /**
     * Copy constructor
     */
    inline  T_TunerMaster_StatusResponse (const T_TunerMaster_StatusResponse &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunerMaster_StatusResponse (T_e8_TunMstr_ResponseStatus u8TunermasterStatus_);

    /**
     * Destructor
     */
    inline  ~T_TunerMaster_StatusResponse();

    /**
     * Assignment operator
     */
    inline T_TunerMaster_StatusResponse& operator = (const T_TunerMaster_StatusResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunerMaster_StatusResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunerMaster_StatusResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunerMaster_StatusResponse& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunerMaster_StatusResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8TunermasterStatus"

    static const int kU8TunermasterStatus = 0;

    /**
     * Clears the field "u8TunermasterStatus".
     *
     * The field will be set to its default value. The hasU8TunermasterStatus()
     * method will return false.
     */
    inline void clearU8TunermasterStatus();

    /**
     * Checks whether the field "u8TunermasterStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TunermasterStatus()). Otherwise it will return false.
     */
    inline bool hasU8TunermasterStatus () const;

    /**
     * Returns the value of the member "u8TunermasterStatus".
     *
     * Indictaes the status of the client request.
     *
     * @return The value of the field "u8TunermasterStatus"
     */
    inline T_e8_TunMstr_ResponseStatus getU8TunermasterStatus () const;

    /**
     * Sets the value of the member "u8TunermasterStatus".
     *
     * Indictaes the status of the client request.
     *
     * @param u8TunermasterStatus The value which will be set
     */
    inline void setU8TunermasterStatus (T_e8_TunMstr_ResponseStatus u8TunermasterStatus_);

    static const T_TunerMaster_StatusResponse &getDefaultInstance();

private:

    inline void set_has_u8TunermasterStatus ();

    inline void clear_has_u8TunermasterStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_e8_TunMstr_ResponseStatus _u8TunermasterStatus;

};

/**
 * Tunermaster Server sends status back to the client.
 */
class T_TunMstr_RadioSetting_StatusResponse {
public:

    /**
     * Default constructor
     */
    inline  T_TunMstr_RadioSetting_StatusResponse ();

    /**
     * Copy constructor
     */
    inline  T_TunMstr_RadioSetting_StatusResponse (const T_TunMstr_RadioSetting_StatusResponse &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunMstr_RadioSetting_StatusResponse (T_e8_TunMstr_RadioProfileSetting_Response RadioProfileSetting_Response_, T_e8_TunMstr_RadioProfileSetting_ErrorCode RadioProfileSetting_ErrorCode_);

    /**
     * Destructor
     */
    inline  ~T_TunMstr_RadioSetting_StatusResponse();

    /**
     * Assignment operator
     */
    inline T_TunMstr_RadioSetting_StatusResponse& operator = (const T_TunMstr_RadioSetting_StatusResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunMstr_RadioSetting_StatusResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunMstr_RadioSetting_StatusResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunMstr_RadioSetting_StatusResponse& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunMstr_RadioSetting_StatusResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RadioProfileSetting_Response"

    static const int kRadioProfileSetting_Response = 0;

    /**
     * Clears the field "RadioProfileSetting_Response".
     *
     * The field will be set to its default value. The hasRadioProfileSetting_Response()
     * method will return false.
     */
    inline void clearRadioProfileSetting_Response();

    /**
     * Checks whether the field "RadioProfileSetting_Response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRadioProfileSetting_Response()). Otherwise it will return false.
     */
    inline bool hasRadioProfileSetting_Response () const;

    /**
     * Returns the value of the member "RadioProfileSetting_Response".
     *
     * Indictaes the status of the client request.
     *
     * @return The value of the field "RadioProfileSetting_Response"
     */
    inline T_e8_TunMstr_RadioProfileSetting_Response getRadioProfileSetting_Response () const;

    /**
     * Sets the value of the member "RadioProfileSetting_Response".
     *
     * Indictaes the status of the client request.
     *
     * @param RadioProfileSetting_Response The value which will be set
     */
    inline void setRadioProfileSetting_Response (T_e8_TunMstr_RadioProfileSetting_Response RadioProfileSetting_Response_);

    // API of field "RadioProfileSetting_ErrorCode"

    static const int kRadioProfileSetting_ErrorCode = 1;

    /**
     * Clears the field "RadioProfileSetting_ErrorCode".
     *
     * The field will be set to its default value. The hasRadioProfileSetting_ErrorCode()
     * method will return false.
     */
    inline void clearRadioProfileSetting_ErrorCode();

    /**
     * Checks whether the field "RadioProfileSetting_ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRadioProfileSetting_ErrorCode()). Otherwise it will return false.
     */
    inline bool hasRadioProfileSetting_ErrorCode () const;

    /**
     * Returns the value of the member "RadioProfileSetting_ErrorCode".
     *
     * Indicates the type of error. In case of success Error Code none will be used
     *
     * @return The value of the field "RadioProfileSetting_ErrorCode"
     */
    inline T_e8_TunMstr_RadioProfileSetting_ErrorCode getRadioProfileSetting_ErrorCode () const;

    /**
     * Sets the value of the member "RadioProfileSetting_ErrorCode".
     *
     * Indicates the type of error. In case of success Error Code none will be used
     *
     * @param RadioProfileSetting_ErrorCode The value which will be set
     */
    inline void setRadioProfileSetting_ErrorCode (T_e8_TunMstr_RadioProfileSetting_ErrorCode RadioProfileSetting_ErrorCode_);

    static const T_TunMstr_RadioSetting_StatusResponse &getDefaultInstance();

private:

    inline void set_has_RadioProfileSetting_Response ();

    inline void clear_has_RadioProfileSetting_Response ();

    inline void set_has_RadioProfileSetting_ErrorCode ();

    inline void clear_has_RadioProfileSetting_ErrorCode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_TunMstr_RadioProfileSetting_Response _RadioProfileSetting_Response;

    T_e8_TunMstr_RadioProfileSetting_ErrorCode _RadioProfileSetting_ErrorCode;

};

/**
 * Response of RFAntenna Test.
 */
class Tunmstr_RFAntenna {
public:

    /**
     * Default constructor
     */
    inline  Tunmstr_RFAntenna ();

    /**
     * Copy constructor
     */
    inline  Tunmstr_RFAntenna (const Tunmstr_RFAntenna &rhs);

    /**
     * All fields constructor
     */
    inline  Tunmstr_RFAntenna (T_e8_AntennaTest AntennaTest_, T_e8_RFAntenna RFAntennaStatus_, uint8 ConnectionCurrent_);

    /**
     * Destructor
     */
    inline  ~Tunmstr_RFAntenna();

    /**
     * Assignment operator
     */
    inline Tunmstr_RFAntenna& operator = (const Tunmstr_RFAntenna& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Tunmstr_RFAntenna& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Tunmstr_RFAntenna& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Tunmstr_RFAntenna& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Tunmstr_RFAntenna& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AntennaTest"

    static const int kAntennaTest = 0;

    /**
     * Clears the field "AntennaTest".
     *
     * The field will be set to its default value. The hasAntennaTest()
     * method will return false.
     */
    inline void clearAntennaTest();

    /**
     * Checks whether the field "AntennaTest" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAntennaTest()). Otherwise it will return false.
     */
    inline bool hasAntennaTest () const;

    /**
     * Returns the value of the member "AntennaTest".
     *
     * This gives the response from RL.
     *
     * @return The value of the field "AntennaTest"
     */
    inline T_e8_AntennaTest getAntennaTest () const;

    /**
     * Sets the value of the member "AntennaTest".
     *
     * This gives the response from RL.
     *
     * @param AntennaTest The value which will be set
     */
    inline void setAntennaTest (T_e8_AntennaTest AntennaTest_);

    // API of field "RFAntennaStatus"

    static const int kRFAntennaStatus = 1;

    /**
     * Clears the field "RFAntennaStatus".
     *
     * The field will be set to its default value. The hasRFAntennaStatus()
     * method will return false.
     */
    inline void clearRFAntennaStatus();

    /**
     * Checks whether the field "RFAntennaStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRFAntennaStatus()). Otherwise it will return false.
     */
    inline bool hasRFAntennaStatus () const;

    /**
     * Returns the value of the member "RFAntennaStatus".
     *
     * This provides whether the result is OK or not.
     *
     * @return The value of the field "RFAntennaStatus"
     */
    inline T_e8_RFAntenna getRFAntennaStatus () const;

    /**
     * Sets the value of the member "RFAntennaStatus".
     *
     * This provides whether the result is OK or not.
     *
     * @param RFAntennaStatus The value which will be set
     */
    inline void setRFAntennaStatus (T_e8_RFAntenna RFAntennaStatus_);

    // API of field "ConnectionCurrent"

    static const int kConnectionCurrent = 2;

    /**
     * Clears the field "ConnectionCurrent".
     *
     * The field will be set to its default value. The hasConnectionCurrent()
     * method will return false.
     */
    inline void clearConnectionCurrent();

    /**
     * Checks whether the field "ConnectionCurrent" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnectionCurrent()). Otherwise it will return false.
     */
    inline bool hasConnectionCurrent () const;

    /**
     * Returns the value of the member "ConnectionCurrent".
     *
     * This provides the measured current in mA.
     *
     * @return The value of the field "ConnectionCurrent"
     */
    inline uint8 getConnectionCurrent () const;

    /**
     * Sets the value of the member "ConnectionCurrent".
     *
     * This provides the measured current in mA.
     *
     * @param ConnectionCurrent The value which will be set
     */
    inline void setConnectionCurrent (uint8 ConnectionCurrent_);

    static const Tunmstr_RFAntenna &getDefaultInstance();

private:

    inline void set_has_AntennaTest ();

    inline void clear_has_AntennaTest ();

    inline void set_has_RFAntennaStatus ();

    inline void clear_has_RFAntennaStatus ();

    inline void set_has_ConnectionCurrent ();

    inline void clear_has_ConnectionCurrent ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_e8_AntennaTest _AntennaTest;

    T_e8_RFAntenna _RFAntennaStatus;

    uint8 _ConnectionCurrent;

};

/**
 * If the meaning of "T_SXMPresetListEntry" isn't clear, then there should be a description here.
 */
class T_SXMPresetListEntry {
public:

    /**
     * Default constructor
     */
    inline  T_SXMPresetListEntry ();

    /**
     * Copy constructor
     */
    inline  T_SXMPresetListEntry (const T_SXMPresetListEntry &rhs);

    /**
     * All fields constructor
     */
    inline  T_SXMPresetListEntry (uint16 ServiceID_, uint16 ChannelID_, bool ChannelNameAvail_, const ::std::string& ChannelName_, bool ChannelActive_, T_e8_Graphics ChnGraphicAvail_, bool IsSmartFavorite_, bool IsLocked_, bool IsAvailable_, bool IsMature_, bool IsSkipped_);

    /**
     * Destructor
     */
    inline  ~T_SXMPresetListEntry();

    /**
     * Assignment operator
     */
    inline T_SXMPresetListEntry& operator = (const T_SXMPresetListEntry& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SXMPresetListEntry& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SXMPresetListEntry& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SXMPresetListEntry& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SXMPresetListEntry& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ServiceID"

    static const int kServiceID = 0;

    /**
     * Clears the field "ServiceID".
     *
     * The field will be set to its default value. The hasServiceID()
     * method will return false.
     */
    inline void clearServiceID();

    /**
     * Checks whether the field "ServiceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceID()). Otherwise it will return false.
     */
    inline bool hasServiceID () const;

    /**
     * Returns the value of the member "ServiceID".
     *
     * Unique identifier of the SXM service
     *
     * @return The value of the field "ServiceID"
     */
    inline uint16 getServiceID () const;

    /**
     * Sets the value of the member "ServiceID".
     *
     * Unique identifier of the SXM service
     *
     * @param ServiceID The value which will be set
     */
    inline void setServiceID (uint16 ServiceID_);

    // API of field "ChannelID"

    static const int kChannelID = 1;

    /**
     * Clears the field "ChannelID".
     *
     * The field will be set to its default value. The hasChannelID()
     * method will return false.
     */
    inline void clearChannelID();

    /**
     * Checks whether the field "ChannelID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelID()). Otherwise it will return false.
     */
    inline bool hasChannelID () const;

    /**
     * Returns the value of the member "ChannelID".
     *
     * Unique identifier of the SXM channel
     *
     * @return The value of the field "ChannelID"
     */
    inline uint16 getChannelID () const;

    /**
     * Sets the value of the member "ChannelID".
     *
     * Unique identifier of the SXM channel
     *
     * @param ChannelID The value which will be set
     */
    inline void setChannelID (uint16 ChannelID_);

    // API of field "ChannelNameAvail"

    static const int kChannelNameAvail = 2;

    /**
     * Clears the field "ChannelNameAvail".
     *
     * The field will be set to its default value. The hasChannelNameAvail()
     * method will return false.
     */
    inline void clearChannelNameAvail();

    /**
     * Checks whether the field "ChannelNameAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelNameAvail()). Otherwise it will return false.
     */
    inline bool hasChannelNameAvail () const;

    /**
     * Returns the value of the member "ChannelNameAvail".
     *
     * SXM Channel name is available or not
     * TRUE = Available, FALSE = Not available
     *
     * @return The value of the field "ChannelNameAvail"
     */
    inline bool getChannelNameAvail () const;

    /**
     * Sets the value of the member "ChannelNameAvail".
     *
     * SXM Channel name is available or not
     * TRUE = Available, FALSE = Not available
     *
     * @param ChannelNameAvail The value which will be set
     */
    inline void setChannelNameAvail (bool ChannelNameAvail_);

    // API of field "ChannelName"

    static const int kChannelName = 3;

    /**
     * Clears the field "ChannelName".
     *
     * The field will be set to its default value. The hasChannelName()
     * method will return false.
     */
    inline void clearChannelName();

    /**
     * Checks whether the field "ChannelName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelName()). Otherwise it will return false.
     */
    inline bool hasChannelName () const;

    /**
     * Returns the value of the member "ChannelName".
     *
     * Name of the SXM channel. The maximum size for the ChannelName
     * is 16 bytes (ASCII characters).
     *
     * @return The value of the field "ChannelName"
     */
    inline const ::std::string& getChannelName () const;

    /**
     * Retrieves the value of the field "ChannelName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelName".
     */
    inline ::std::string& getChannelNameMutable ();

    /**
     * Sets the value of the member "ChannelName".
     *
     * Name of the SXM channel. The maximum size for the ChannelName
     * is 16 bytes (ASCII characters).
     *
     * @param ChannelName The value which will be set
     */
    inline void setChannelName (const ::std::string& ChannelName_);

    /**
     * Sets the value of the member "ChannelName".
     *
     * Name of the SXM channel. The maximum size for the ChannelName
     * is 16 bytes (ASCII characters).
     *
     * @param ChannelName The value which will be set
     */
    inline void setChannelName (const char* ChannelName_);

    /**
     * Sets the value of the member "ChannelName".
     *
     * Name of the SXM channel. The maximum size for the ChannelName
     * is 16 bytes (ASCII characters).
     *
     * @param ChannelName The value which will be set
     */
    inline void setChannelName (const char* value, size_t size);

    /**
     * Release the object stored in the field "ChannelName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "ChannelName"
     */
    inline ::std::string* releaseChannelName();

    /**
     * Replace the field "ChannelName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceChannelName (::std::string* ChannelName_);

    // API of field "ChannelActive"

    static const int kChannelActive = 4;

    /**
     * Clears the field "ChannelActive".
     *
     * The field will be set to its default value. The hasChannelActive()
     * method will return false.
     */
    inline void clearChannelActive();

    /**
     * Checks whether the field "ChannelActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelActive()). Otherwise it will return false.
     */
    inline bool hasChannelActive () const;

    /**
     * Returns the value of the member "ChannelActive".
     *
     * This field is used to decide whether the entry needs to be greyed
     * out or not. For e.g. in case of an OFF AIR SXM channel, this flag is
     * set to FALSE. TRUE = SXM Channel is active , FALSE = SXM Channel is not
     * active (i.e. may be greyed out)
     *
     * @return The value of the field "ChannelActive"
     */
    inline bool getChannelActive () const;

    /**
     * Sets the value of the member "ChannelActive".
     *
     * This field is used to decide whether the entry needs to be greyed
     * out or not. For e.g. in case of an OFF AIR SXM channel, this flag is
     * set to FALSE. TRUE = SXM Channel is active , FALSE = SXM Channel is not
     * active (i.e. may be greyed out)
     *
     * @param ChannelActive The value which will be set
     */
    inline void setChannelActive (bool ChannelActive_);

    // API of field "ChnGraphicAvail"

    static const int kChnGraphicAvail = 5;

    /**
     * Clears the field "ChnGraphicAvail".
     *
     * The field will be set to its default value. The hasChnGraphicAvail()
     * method will return false.
     */
    inline void clearChnGraphicAvail();

    /**
     * Checks whether the field "ChnGraphicAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChnGraphicAvail()). Otherwise it will return false.
     */
    inline bool hasChnGraphicAvail () const;

    /**
     * Returns the value of the member "ChnGraphicAvail".
     *
     * Indicates whether SXM Channel Graphics needs to be refreshed.
     *
     * @return The value of the field "ChnGraphicAvail"
     */
    inline T_e8_Graphics getChnGraphicAvail () const;

    /**
     * Sets the value of the member "ChnGraphicAvail".
     *
     * Indicates whether SXM Channel Graphics needs to be refreshed.
     *
     * @param ChnGraphicAvail The value which will be set
     */
    inline void setChnGraphicAvail (T_e8_Graphics ChnGraphicAvail_);

    // API of field "IsSmartFavorite"

    static const int kIsSmartFavorite = 6;

    /**
     * Clears the field "IsSmartFavorite".
     *
     * The field will be set to its default value. The hasIsSmartFavorite()
     * method will return false.
     */
    inline void clearIsSmartFavorite();

    /**
     * Checks whether the field "IsSmartFavorite" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsSmartFavorite()). Otherwise it will return false.
     */
    inline bool hasIsSmartFavorite () const;

    /**
     * Returns the value of the member "IsSmartFavorite".
     *
     * Flag to indicate if the SXM channel is a smart favorite channel.
     *
     * @return The value of the field "IsSmartFavorite"
     */
    inline bool getIsSmartFavorite () const;

    /**
     * Sets the value of the member "IsSmartFavorite".
     *
     * Flag to indicate if the SXM channel is a smart favorite channel.
     *
     * @param IsSmartFavorite The value which will be set
     */
    inline void setIsSmartFavorite (bool IsSmartFavorite_);

    // API of field "IsLocked"

    static const int kIsLocked = 7;

    /**
     * Clears the field "IsLocked".
     *
     * The field will be set to its default value. The hasIsLocked()
     * method will return false.
     */
    inline void clearIsLocked();

    /**
     * Checks whether the field "IsLocked" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsLocked()). Otherwise it will return false.
     */
    inline bool hasIsLocked () const;

    /**
     * Returns the value of the member "IsLocked".
     *
     * SXM Channel's Lock status.
     * TRUE, if the channel is locked;
     * FALSE, if the channel is unlocked;
     *
     * @return The value of the field "IsLocked"
     */
    inline bool getIsLocked () const;

    /**
     * Sets the value of the member "IsLocked".
     *
     * SXM Channel's Lock status.
     * TRUE, if the channel is locked;
     * FALSE, if the channel is unlocked;
     *
     * @param IsLocked The value which will be set
     */
    inline void setIsLocked (bool IsLocked_);

    // API of field "IsAvailable"

    static const int kIsAvailable = 8;

    /**
     * Clears the field "IsAvailable".
     *
     * The field will be set to its default value. The hasIsAvailable()
     * method will return false.
     */
    inline void clearIsAvailable();

    /**
     * Checks whether the field "IsAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsAvailable()). Otherwise it will return false.
     */
    inline bool hasIsAvailable () const;

    /**
     * Returns the value of the member "IsAvailable".
     *
     * SXM Channel's Availability status.
     * TRUE, if the channel is subscribed and available;
     * FALSE, if the channel is either unsubscribed or not aired;
     *
     * @return The value of the field "IsAvailable"
     */
    inline bool getIsAvailable () const;

    /**
     * Sets the value of the member "IsAvailable".
     *
     * SXM Channel's Availability status.
     * TRUE, if the channel is subscribed and available;
     * FALSE, if the channel is either unsubscribed or not aired;
     *
     * @param IsAvailable The value which will be set
     */
    inline void setIsAvailable (bool IsAvailable_);

    // API of field "IsMature"

    static const int kIsMature = 9;

    /**
     * Clears the field "IsMature".
     *
     * The field will be set to its default value. The hasIsMature()
     * method will return false.
     */
    inline void clearIsMature();

    /**
     * Checks whether the field "IsMature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsMature()). Otherwise it will return false.
     */
    inline bool hasIsMature () const;

    /**
     * Returns the value of the member "IsMature".
     *
     * SXM Channel's Broadcast content type.
     * TRUE, if the channel is identified as a channel which MAY be broadcasting mature or adult content and may need Parental Guidance;
     * FALSE, if Parental Guidance not required;
     *
     * @return The value of the field "IsMature"
     */
    inline bool getIsMature () const;

    /**
     * Sets the value of the member "IsMature".
     *
     * SXM Channel's Broadcast content type.
     * TRUE, if the channel is identified as a channel which MAY be broadcasting mature or adult content and may need Parental Guidance;
     * FALSE, if Parental Guidance not required;
     *
     * @param IsMature The value which will be set
     */
    inline void setIsMature (bool IsMature_);

    // API of field "IsSkipped"

    static const int kIsSkipped = 10;

    /**
     * Clears the field "IsSkipped".
     *
     * The field will be set to its default value. The hasIsSkipped()
     * method will return false.
     */
    inline void clearIsSkipped();

    /**
     * Checks whether the field "IsSkipped" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsSkipped()). Otherwise it will return false.
     */
    inline bool hasIsSkipped () const;

    /**
     * Returns the value of the member "IsSkipped".
     *
     * SXM Channel's Skip status.
     * TRUE, if the channel is skipped;
     * FALSE, if the channel is unskipped;
     *
     * @return The value of the field "IsSkipped"
     */
    inline bool getIsSkipped () const;

    /**
     * Sets the value of the member "IsSkipped".
     *
     * SXM Channel's Skip status.
     * TRUE, if the channel is skipped;
     * FALSE, if the channel is unskipped;
     *
     * @param IsSkipped The value which will be set
     */
    inline void setIsSkipped (bool IsSkipped_);

    static const T_SXMPresetListEntry &getDefaultInstance();

private:

    inline void set_has_ServiceID ();

    inline void clear_has_ServiceID ();

    inline void set_has_ChannelID ();

    inline void clear_has_ChannelID ();

    inline void set_has_ChannelNameAvail ();

    inline void clear_has_ChannelNameAvail ();

    inline void set_has_ChannelName ();

    inline void clear_has_ChannelName ();

    inline void set_has_ChannelActive ();

    inline void clear_has_ChannelActive ();

    inline void set_has_ChnGraphicAvail ();

    inline void clear_has_ChnGraphicAvail ();

    inline void set_has_IsSmartFavorite ();

    inline void clear_has_IsSmartFavorite ();

    inline void set_has_IsLocked ();

    inline void clear_has_IsLocked ();

    inline void set_has_IsAvailable ();

    inline void clear_has_IsAvailable ();

    inline void set_has_IsMature ();

    inline void clear_has_IsMature ();

    inline void set_has_IsSkipped ();

    inline void clear_has_IsSkipped ();

    uint32 _has_bits_[ (11 + 31) / 32];

    uint16 _ServiceID;

    uint16 _ChannelID;

    bool _ChannelNameAvail;

    ::std::string* _ChannelName;

    bool _ChannelActive;

    T_e8_Graphics _ChnGraphicAvail;

    bool _IsSmartFavorite;

    bool _IsLocked;

    bool _IsAvailable;

    bool _IsMature;

    bool _IsSkipped;

};

/**
 * If the meaning of "T_SXMChannelAttributes" isn't clear, then there should be a description here.
 */
class T_SXMChannelAttributes {
public:

    /**
     * Default constructor
     */
    inline  T_SXMChannelAttributes ();

    /**
     * Copy constructor
     */
    inline  T_SXMChannelAttributes (const T_SXMChannelAttributes &rhs);

    /**
     * All fields constructor
     */
    inline  T_SXMChannelAttributes (const ::std::vector< uint8 >& Logo_, const ::std::string& Name_, const ::std::string& PDT_, bool IsLocked_, const ::std::string& ContextualBanner_, uint32 ChannelNumber_);

    /**
     * Destructor
     */
    inline  ~T_SXMChannelAttributes();

    /**
     * Assignment operator
     */
    inline T_SXMChannelAttributes& operator = (const T_SXMChannelAttributes& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SXMChannelAttributes& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SXMChannelAttributes& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SXMChannelAttributes& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SXMChannelAttributes& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Logo"

    static const int kLogo = 0;

    /**
     * Clears the field "Logo".
     *
     * The field will be set to its default value. The hasLogo()
     * method will return false.
     */
    inline void clearLogo();

    /**
     * Checks whether the field "Logo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLogo()). Otherwise it will return false.
     */
    inline bool hasLogo () const;

    /**
     * Returns the value of the member "Logo".
     *
     * Indicates the program logo.
     *
     * @return The value of the field "Logo"
     */
    inline const ::std::vector< uint8 >& getLogo () const;

    /**
     * Retrieves the value of the field "Logo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Logo".
     */
    inline ::std::vector< uint8 >& getLogoMutable ();

    /**
     * Sets the value of the member "Logo".
     *
     * Indicates the program logo.
     *
     * @param Logo The value which will be set
     */
    inline void setLogo (const ::std::vector< uint8 >& Logo_);

    /**
     * Release the object stored in the field "Logo".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "Logo"
     */
    inline ::std::vector< uint8 >* releaseLogo();

    /**
     * Replace the field "Logo".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceLogo (::std::vector< uint8 >* Logo_);

    // API of field "Name"

    static const int kName = 1;

    /**
     * Clears the field "Name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "Name".
     *
     * Indicates the name of the channel
     *
     * @return The value of the field "Name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "Name".
     *
     * Indicates the name of the channel
     *
     * @param Name The value which will be set
     */
    inline void setName (const ::std::string& Name_);

    /**
     * Sets the value of the member "Name".
     *
     * Indicates the name of the channel
     *
     * @param Name The value which will be set
     */
    inline void setName (const char* Name_);

    /**
     * Sets the value of the member "Name".
     *
     * Indicates the name of the channel
     *
     * @param Name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    /**
     * Release the object stored in the field "Name".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "Name"
     */
    inline ::std::string* releaseName();

    /**
     * Replace the field "Name".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceName (::std::string* Name_);

    // API of field "PDT"

    static const int kPDT = 2;

    /**
     * Clears the field "PDT".
     *
     * The field will be set to its default value. The hasPDT()
     * method will return false.
     */
    inline void clearPDT();

    /**
     * Checks whether the field "PDT" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPDT()). Otherwise it will return false.
     */
    inline bool hasPDT () const;

    /**
     * Returns the value of the member "PDT".
     *
     * Indicates the Program Description Type
     *
     * @return The value of the field "PDT"
     */
    inline const ::std::string& getPDT () const;

    /**
     * Retrieves the value of the field "PDT" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PDT".
     */
    inline ::std::string& getPDTMutable ();

    /**
     * Sets the value of the member "PDT".
     *
     * Indicates the Program Description Type
     *
     * @param PDT The value which will be set
     */
    inline void setPDT (const ::std::string& PDT_);

    /**
     * Sets the value of the member "PDT".
     *
     * Indicates the Program Description Type
     *
     * @param PDT The value which will be set
     */
    inline void setPDT (const char* PDT_);

    /**
     * Sets the value of the member "PDT".
     *
     * Indicates the Program Description Type
     *
     * @param PDT The value which will be set
     */
    inline void setPDT (const char* value, size_t size);

    /**
     * Release the object stored in the field "PDT".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "PDT"
     */
    inline ::std::string* releasePDT();

    /**
     * Replace the field "PDT".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replacePDT (::std::string* PDT_);

    // API of field "IsLocked"

    static const int kIsLocked = 3;

    /**
     * Clears the field "IsLocked".
     *
     * The field will be set to its default value. The hasIsLocked()
     * method will return false.
     */
    inline void clearIsLocked();

    /**
     * Checks whether the field "IsLocked" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsLocked()). Otherwise it will return false.
     */
    inline bool hasIsLocked () const;

    /**
     * Returns the value of the member "IsLocked".
     *
     * Indicates SXM Channel's Lock status.
     * TRUE, if the channel is locked;
     * FALSE, if the channel is unlocked;
     *
     * @return The value of the field "IsLocked"
     */
    inline bool getIsLocked () const;

    /**
     * Sets the value of the member "IsLocked".
     *
     * Indicates SXM Channel's Lock status.
     * TRUE, if the channel is locked;
     * FALSE, if the channel is unlocked;
     *
     * @param IsLocked The value which will be set
     */
    inline void setIsLocked (bool IsLocked_);

    // API of field "ContextualBanner"

    static const int kContextualBanner = 4;

    /**
     * Clears the field "ContextualBanner".
     *
     * The field will be set to its default value. The hasContextualBanner()
     * method will return false.
     */
    inline void clearContextualBanner();

    /**
     * Checks whether the field "ContextualBanner" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setContextualBanner()). Otherwise it will return false.
     */
    inline bool hasContextualBanner () const;

    /**
     * Returns the value of the member "ContextualBanner".
     *
     * Indicates the supplemental information of the channel
     *
     * @return The value of the field "ContextualBanner"
     */
    inline const ::std::string& getContextualBanner () const;

    /**
     * Retrieves the value of the field "ContextualBanner" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ContextualBanner".
     */
    inline ::std::string& getContextualBannerMutable ();

    /**
     * Sets the value of the member "ContextualBanner".
     *
     * Indicates the supplemental information of the channel
     *
     * @param ContextualBanner The value which will be set
     */
    inline void setContextualBanner (const ::std::string& ContextualBanner_);

    /**
     * Sets the value of the member "ContextualBanner".
     *
     * Indicates the supplemental information of the channel
     *
     * @param ContextualBanner The value which will be set
     */
    inline void setContextualBanner (const char* ContextualBanner_);

    /**
     * Sets the value of the member "ContextualBanner".
     *
     * Indicates the supplemental information of the channel
     *
     * @param ContextualBanner The value which will be set
     */
    inline void setContextualBanner (const char* value, size_t size);

    /**
     * Release the object stored in the field "ContextualBanner".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "ContextualBanner"
     */
    inline ::std::string* releaseContextualBanner();

    /**
     * Replace the field "ContextualBanner".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceContextualBanner (::std::string* ContextualBanner_);

    // API of field "ChannelNumber"

    static const int kChannelNumber = 5;

    /**
     * Clears the field "ChannelNumber".
     *
     * The field will be set to its default value. The hasChannelNumber()
     * method will return false.
     */
    inline void clearChannelNumber();

    /**
     * Checks whether the field "ChannelNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelNumber()). Otherwise it will return false.
     */
    inline bool hasChannelNumber () const;

    /**
     * Returns the value of the member "ChannelNumber".
     *
     * Indicates the channel number
     *
     * @return The value of the field "ChannelNumber"
     */
    inline uint32 getChannelNumber () const;

    /**
     * Sets the value of the member "ChannelNumber".
     *
     * Indicates the channel number
     *
     * @param ChannelNumber The value which will be set
     */
    inline void setChannelNumber (uint32 ChannelNumber_);

    static const T_SXMChannelAttributes &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_Logo ();

    inline void clear_has_Logo ();

    inline void set_has_Name ();

    inline void clear_has_Name ();

    inline void set_has_PDT ();

    inline void clear_has_PDT ();

    inline void set_has_IsLocked ();

    inline void clear_has_IsLocked ();

    inline void set_has_ContextualBanner ();

    inline void clear_has_ContextualBanner ();

    inline void set_has_ChannelNumber ();

    inline void clear_has_ChannelNumber ();

    uint32 _has_bits_[ (6 + 31) / 32];

    ::std::vector< uint8 >* _Logo;

    ::std::string* _Name;

    ::std::string* _PDT;

    bool _IsLocked;

    ::std::string* _ContextualBanner;

    uint32 _ChannelNumber;

};

/**
 * List of presets in the current active list
 */
class T_PresetList {
public:

    /**
     * Default constructor
     */
    inline  T_PresetList ();

    /**
     * Copy constructor
     */
    inline  T_PresetList (const T_PresetList &rhs);

    /**
     * All fields constructor
     */
    inline  T_PresetList (T_e8_List List_, T_e8_Band Band_, uint8 Element_ID_, uint32 Frequency_, const ::std::string& PSName_, uint8 u8TpTmcInfo_, uint32 PTY_, const ::std::string& EnsembleName_, const ::std::string& Frequency_Label_, const ::std::string& StationLogo_, uint32 u32HDStationId_, const ::std::string& sHDCallSign_, T_e8_HDAudioProgram e8HDAudioProgram_, uint32 u32DRMServiceId_, const ::std::string& sDRMServiceLabel_, uint8 u8DRMServiceShortId_, T_e8_ModulationType e8Modulation_, uint32 u32HDStationId_DRMServiceId_, T_e8_HDTextEncoding e8HDTextEncoding_, const ::std::string& sHDCallSign_DRMServiceLabel_, uint8 u8HDStationGenre_DRMPty_, uint8 u8HDAudioProgram_DRMShortID_, const T_SXMPresetListEntry& SXMSMSlib_PresetListEntry_, const ::std::string& Key_, T_e8_PresetType PresetType_, const T_SXMChannelAttributes& SXM360L_PresetListEntry_);

    /**
     * Destructor
     */
    inline  ~T_PresetList();

    /**
     * Assignment operator
     */
    inline T_PresetList& operator = (const T_PresetList& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_PresetList& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_PresetList& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_PresetList& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_PresetList& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "List"

    static const int kList = 0;

    /**
     * Clears the field "List".
     *
     * The field will be set to its default value. The hasList()
     * method will return false.
     */
    inline void clearList();

    /**
     * Checks whether the field "List" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setList()). Otherwise it will return false.
     */
    inline bool hasList () const;

    /**
     * Returns the value of the member "List".
     *
     * Band infomation of the station
     *
     * @return The value of the field "List"
     */
    inline T_e8_List getList () const;

    /**
     * Sets the value of the member "List".
     *
     * Band infomation of the station
     *
     * @param List The value which will be set
     */
    inline void setList (T_e8_List List_);

    // API of field "Band"

    static const int kBand = 1;

    /**
     * Clears the field "Band".
     *
     * The field will be set to its default value. The hasBand()
     * method will return false.
     */
    inline void clearBand();

    /**
     * Checks whether the field "Band" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBand()). Otherwise it will return false.
     */
    inline bool hasBand () const;

    /**
     * Returns the value of the member "Band".
     *
     * Band infomation of the station
     *
     * @return The value of the field "Band"
     */
    inline T_e8_Band getBand () const;

    /**
     * Sets the value of the member "Band".
     *
     * Band infomation of the station
     *
     * @param Band The value which will be set
     */
    inline void setBand (T_e8_Band Band_);

    // API of field "Element_ID"

    static const int kElement_ID = 2;

    /**
     * Clears the field "Element_ID".
     *
     * The field will be set to its default value. The hasElement_ID()
     * method will return false.
     */
    inline void clearElement_ID();

    /**
     * Checks whether the field "Element_ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElement_ID()). Otherwise it will return false.
     */
    inline bool hasElement_ID () const;

    /**
     * Returns the value of the member "Element_ID".
     *
     * Element IDof the station
     *
     * @return The value of the field "Element_ID"
     */
    inline uint8 getElement_ID () const;

    /**
     * Sets the value of the member "Element_ID".
     *
     * Element IDof the station
     *
     * @param Element_ID The value which will be set
     */
    inline void setElement_ID (uint8 Element_ID_);

    // API of field "Frequency"

    static const int kFrequency = 3;

    /**
     * Clears the field "Frequency".
     *
     * The field will be set to its default value. The hasFrequency()
     * method will return false.
     */
    inline void clearFrequency();

    /**
     * Checks whether the field "Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFrequency()). Otherwise it will return false.
     */
    inline bool hasFrequency () const;

    /**
     * Returns the value of the member "Frequency".
     *
     * Frequency Value of the station
     *
     * @return The value of the field "Frequency"
     */
    inline uint32 getFrequency () const;

    /**
     * Sets the value of the member "Frequency".
     *
     * Frequency Value of the station
     *
     * @param Frequency The value which will be set
     */
    inline void setFrequency (uint32 Frequency_);

    // API of field "PSName"

    static const int kPSName = 4;

    /**
     * Clears the field "PSName".
     *
     * The field will be set to its default value. The hasPSName()
     * method will return false.
     */
    inline void clearPSName();

    /**
     * Checks whether the field "PSName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPSName()). Otherwise it will return false.
     */
    inline bool hasPSName () const;

    /**
     * Returns the value of the member "PSName".
     *
     * PS name of the station
     *
     * @return The value of the field "PSName"
     */
    inline const ::std::string& getPSName () const;

    /**
     * Retrieves the value of the field "PSName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PSName".
     */
    inline ::std::string& getPSNameMutable ();

    /**
     * Sets the value of the member "PSName".
     *
     * PS name of the station
     *
     * @param PSName The value which will be set
     */
    inline void setPSName (const ::std::string& PSName_);

    /**
     * Sets the value of the member "PSName".
     *
     * PS name of the station
     *
     * @param PSName The value which will be set
     */
    inline void setPSName (const char* PSName_);

    /**
     * Sets the value of the member "PSName".
     *
     * PS name of the station
     *
     * @param PSName The value which will be set
     */
    inline void setPSName (const char* value, size_t size);

    /**
     * Release the object stored in the field "PSName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "PSName"
     */
    inline ::std::string* releasePSName();

    /**
     * Replace the field "PSName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replacePSName (::std::string* PSName_);

    // API of field "u8TpTmcInfo"

    static const int kU8TpTmcInfo = 5;

    /**
     * Clears the field "u8TpTmcInfo".
     *
     * The field will be set to its default value. The hasU8TpTmcInfo()
     * method will return false.
     */
    inline void clearU8TpTmcInfo();

    /**
     * Checks whether the field "u8TpTmcInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TpTmcInfo()). Otherwise it will return false.
     */
    inline bool hasU8TpTmcInfo () const;

    /**
     * Returns the value of the member "u8TpTmcInfo".
     *
     * Informs TP and TMC status of the station
     * 1st nibble gives TP status, 2nd nibble gives TMC status
     *
     * @return The value of the field "u8TpTmcInfo"
     */
    inline uint8 getU8TpTmcInfo () const;

    /**
     * Sets the value of the member "u8TpTmcInfo".
     *
     * Informs TP and TMC status of the station
     * 1st nibble gives TP status, 2nd nibble gives TMC status
     *
     * @param u8TpTmcInfo The value which will be set
     */
    inline void setU8TpTmcInfo (uint8 u8TpTmcInfo_);

    // API of field "PTY"

    static const int kPTY = 6;

    /**
     * Clears the field "PTY".
     *
     * The field will be set to its default value. The hasPTY()
     * method will return false.
     */
    inline void clearPTY();

    /**
     * Checks whether the field "PTY" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPTY()). Otherwise it will return false.
     */
    inline bool hasPTY () const;

    /**
     * Returns the value of the member "PTY".
     *
     * Gives PTY type info of the station.
     *
     * @return The value of the field "PTY"
     */
    inline uint32 getPTY () const;

    /**
     * Sets the value of the member "PTY".
     *
     * Gives PTY type info of the station.
     *
     * @param PTY The value which will be set
     */
    inline void setPTY (uint32 PTY_);

    // API of field "EnsembleName"

    static const int kEnsembleName = 7;

    /**
     * Clears the field "EnsembleName".
     *
     * The field will be set to its default value. The hasEnsembleName()
     * method will return false.
     */
    inline void clearEnsembleName();

    /**
     * Checks whether the field "EnsembleName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnsembleName()). Otherwise it will return false.
     */
    inline bool hasEnsembleName () const;

    /**
     * Returns the value of the member "EnsembleName".
     *
     * This is used only in case of DAB
     *
     * @return The value of the field "EnsembleName"
     */
    inline const ::std::string& getEnsembleName () const;

    /**
     * Retrieves the value of the field "EnsembleName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "EnsembleName".
     */
    inline ::std::string& getEnsembleNameMutable ();

    /**
     * Sets the value of the member "EnsembleName".
     *
     * This is used only in case of DAB
     *
     * @param EnsembleName The value which will be set
     */
    inline void setEnsembleName (const ::std::string& EnsembleName_);

    /**
     * Sets the value of the member "EnsembleName".
     *
     * This is used only in case of DAB
     *
     * @param EnsembleName The value which will be set
     */
    inline void setEnsembleName (const char* EnsembleName_);

    /**
     * Sets the value of the member "EnsembleName".
     *
     * This is used only in case of DAB
     *
     * @param EnsembleName The value which will be set
     */
    inline void setEnsembleName (const char* value, size_t size);

    /**
     * Release the object stored in the field "EnsembleName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "EnsembleName"
     */
    inline ::std::string* releaseEnsembleName();

    /**
     * Replace the field "EnsembleName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceEnsembleName (::std::string* EnsembleName_);

    // API of field "Frequency_Label"

    static const int kFrequency_Label = 8;

    /**
     * Clears the field "Frequency_Label".
     *
     * The field will be set to its default value. The hasFrequency_Label()
     * method will return false.
     */
    inline void clearFrequency_Label();

    /**
     * Checks whether the field "Frequency_Label" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFrequency_Label()). Otherwise it will return false.
     */
    inline bool hasFrequency_Label () const;

    /**
     * Returns the value of the member "Frequency_Label".
     *
     * This is used only in case of DAB
     *
     * @return The value of the field "Frequency_Label"
     */
    inline const ::std::string& getFrequency_Label () const;

    /**
     * Retrieves the value of the field "Frequency_Label" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Frequency_Label".
     */
    inline ::std::string& getFrequency_LabelMutable ();

    /**
     * Sets the value of the member "Frequency_Label".
     *
     * This is used only in case of DAB
     *
     * @param Frequency_Label The value which will be set
     */
    inline void setFrequency_Label (const ::std::string& Frequency_Label_);

    /**
     * Sets the value of the member "Frequency_Label".
     *
     * This is used only in case of DAB
     *
     * @param Frequency_Label The value which will be set
     */
    inline void setFrequency_Label (const char* Frequency_Label_);

    /**
     * Sets the value of the member "Frequency_Label".
     *
     * This is used only in case of DAB
     *
     * @param Frequency_Label The value which will be set
     */
    inline void setFrequency_Label (const char* value, size_t size);

    /**
     * Release the object stored in the field "Frequency_Label".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "Frequency_Label"
     */
    inline ::std::string* releaseFrequency_Label();

    /**
     * Replace the field "Frequency_Label".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceFrequency_Label (::std::string* Frequency_Label_);

    // API of field "StationLogo"

    static const int kStationLogo = 9;

    /**
     * Clears the field "StationLogo".
     *
     * The field will be set to its default value. The hasStationLogo()
     * method will return false.
     */
    inline void clearStationLogo();

    /**
     * Checks whether the field "StationLogo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStationLogo()). Otherwise it will return false.
     */
    inline bool hasStationLogo () const;

    /**
     * Returns the value of the member "StationLogo".
     *
     * Contains the link info where the LOGO is stored
     *
     * @return The value of the field "StationLogo"
     */
    inline const ::std::string& getStationLogo () const;

    /**
     * Retrieves the value of the field "StationLogo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StationLogo".
     */
    inline ::std::string& getStationLogoMutable ();

    /**
     * Sets the value of the member "StationLogo".
     *
     * Contains the link info where the LOGO is stored
     *
     * @param StationLogo The value which will be set
     */
    inline void setStationLogo (const ::std::string& StationLogo_);

    /**
     * Sets the value of the member "StationLogo".
     *
     * Contains the link info where the LOGO is stored
     *
     * @param StationLogo The value which will be set
     */
    inline void setStationLogo (const char* StationLogo_);

    /**
     * Sets the value of the member "StationLogo".
     *
     * Contains the link info where the LOGO is stored
     *
     * @param StationLogo The value which will be set
     */
    inline void setStationLogo (const char* value, size_t size);

    /**
     * Release the object stored in the field "StationLogo".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "StationLogo"
     */
    inline ::std::string* releaseStationLogo();

    /**
     * Replace the field "StationLogo".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceStationLogo (::std::string* StationLogo_);

    // API of field "u32HDStationId"

    static const int kU32HDStationId = 10;

    /**
     * Clears the field "u32HDStationId".
     *
     * The field will be set to its default value. The hasU32HDStationId()
     * method will return false.
     */
    inline void clearU32HDStationId();

    /**
     * Checks whether the field "u32HDStationId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32HDStationId()). Otherwise it will return false.
     */
    inline bool hasU32HDStationId () const;

    /**
     * Returns the value of the member "u32HDStationId".
     *
     *
     *
     * @return The value of the field "u32HDStationId"
     */
    inline uint32 getU32HDStationId () const;

    /**
     * Sets the value of the member "u32HDStationId".
     *
     *
     *
     * @param u32HDStationId The value which will be set
     */
    inline void setU32HDStationId (uint32 u32HDStationId_);

    // API of field "sHDCallSign"

    static const int kSHDCallSign = 11;

    /**
     * Clears the field "sHDCallSign".
     *
     * The field will be set to its default value. The hasSHDCallSign()
     * method will return false.
     */
    inline void clearSHDCallSign();

    /**
     * Checks whether the field "sHDCallSign" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSHDCallSign()). Otherwise it will return false.
     */
    inline bool hasSHDCallSign () const;

    /**
     * Returns the value of the member "sHDCallSign".
     *
     * Will be removed in coming releases, instead use sHDCallSign_DRMServiceLabel
     *
     * @return The value of the field "sHDCallSign"
     */
    inline const ::std::string& getSHDCallSign () const;

    /**
     * Retrieves the value of the field "sHDCallSign" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sHDCallSign".
     */
    inline ::std::string& getSHDCallSignMutable ();

    /**
     * Sets the value of the member "sHDCallSign".
     *
     * Will be removed in coming releases, instead use sHDCallSign_DRMServiceLabel
     *
     * @param sHDCallSign The value which will be set
     */
    inline void setSHDCallSign (const ::std::string& sHDCallSign_);

    /**
     * Sets the value of the member "sHDCallSign".
     *
     * Will be removed in coming releases, instead use sHDCallSign_DRMServiceLabel
     *
     * @param sHDCallSign The value which will be set
     */
    inline void setSHDCallSign (const char* sHDCallSign_);

    /**
     * Sets the value of the member "sHDCallSign".
     *
     * Will be removed in coming releases, instead use sHDCallSign_DRMServiceLabel
     *
     * @param sHDCallSign The value which will be set
     */
    inline void setSHDCallSign (const char* value, size_t size);

    /**
     * Release the object stored in the field "sHDCallSign".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sHDCallSign"
     */
    inline ::std::string* releaseSHDCallSign();

    /**
     * Replace the field "sHDCallSign".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSHDCallSign (::std::string* sHDCallSign_);

    // API of field "e8HDAudioProgram"

    static const int kE8HDAudioProgram = 12;

    /**
     * Clears the field "e8HDAudioProgram".
     *
     * The field will be set to its default value. The hasE8HDAudioProgram()
     * method will return false.
     */
    inline void clearE8HDAudioProgram();

    /**
     * Checks whether the field "e8HDAudioProgram" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8HDAudioProgram()). Otherwise it will return false.
     */
    inline bool hasE8HDAudioProgram () const;

    /**
     * Returns the value of the member "e8HDAudioProgram".
     *
     *
     *
     * @return The value of the field "e8HDAudioProgram"
     */
    inline T_e8_HDAudioProgram getE8HDAudioProgram () const;

    /**
     * Sets the value of the member "e8HDAudioProgram".
     *
     *
     *
     * @param e8HDAudioProgram The value which will be set
     */
    inline void setE8HDAudioProgram (T_e8_HDAudioProgram e8HDAudioProgram_);

    // API of field "u32DRMServiceId"

    static const int kU32DRMServiceId = 13;

    /**
     * Clears the field "u32DRMServiceId".
     *
     * The field will be set to its default value. The hasU32DRMServiceId()
     * method will return false.
     */
    inline void clearU32DRMServiceId();

    /**
     * Checks whether the field "u32DRMServiceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DRMServiceId()). Otherwise it will return false.
     */
    inline bool hasU32DRMServiceId () const;

    /**
     * Returns the value of the member "u32DRMServiceId".
     *
     * If the meaning of "u32DRMServiceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32DRMServiceId"
     */
    inline uint32 getU32DRMServiceId () const;

    /**
     * Sets the value of the member "u32DRMServiceId".
     *
     * If the meaning of "u32DRMServiceId" isn't clear, then there should be a description here.
     *
     * @param u32DRMServiceId The value which will be set
     */
    inline void setU32DRMServiceId (uint32 u32DRMServiceId_);

    // API of field "sDRMServiceLabel"

    static const int kSDRMServiceLabel = 14;

    /**
     * Clears the field "sDRMServiceLabel".
     *
     * The field will be set to its default value. The hasSDRMServiceLabel()
     * method will return false.
     */
    inline void clearSDRMServiceLabel();

    /**
     * Checks whether the field "sDRMServiceLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDRMServiceLabel()). Otherwise it will return false.
     */
    inline bool hasSDRMServiceLabel () const;

    /**
     * Returns the value of the member "sDRMServiceLabel".
     *
     * Will be removed in coming releases, instead use sHDCallSign_DRMServiceLabel
     *
     * @return The value of the field "sDRMServiceLabel"
     */
    inline const ::std::string& getSDRMServiceLabel () const;

    /**
     * Retrieves the value of the field "sDRMServiceLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDRMServiceLabel".
     */
    inline ::std::string& getSDRMServiceLabelMutable ();

    /**
     * Sets the value of the member "sDRMServiceLabel".
     *
     * Will be removed in coming releases, instead use sHDCallSign_DRMServiceLabel
     *
     * @param sDRMServiceLabel The value which will be set
     */
    inline void setSDRMServiceLabel (const ::std::string& sDRMServiceLabel_);

    /**
     * Sets the value of the member "sDRMServiceLabel".
     *
     * Will be removed in coming releases, instead use sHDCallSign_DRMServiceLabel
     *
     * @param sDRMServiceLabel The value which will be set
     */
    inline void setSDRMServiceLabel (const char* sDRMServiceLabel_);

    /**
     * Sets the value of the member "sDRMServiceLabel".
     *
     * Will be removed in coming releases, instead use sHDCallSign_DRMServiceLabel
     *
     * @param sDRMServiceLabel The value which will be set
     */
    inline void setSDRMServiceLabel (const char* value, size_t size);

    /**
     * Release the object stored in the field "sDRMServiceLabel".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sDRMServiceLabel"
     */
    inline ::std::string* releaseSDRMServiceLabel();

    /**
     * Replace the field "sDRMServiceLabel".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSDRMServiceLabel (::std::string* sDRMServiceLabel_);

    // API of field "u8DRMServiceShortId"

    static const int kU8DRMServiceShortId = 15;

    /**
     * Clears the field "u8DRMServiceShortId".
     *
     * The field will be set to its default value. The hasU8DRMServiceShortId()
     * method will return false.
     */
    inline void clearU8DRMServiceShortId();

    /**
     * Checks whether the field "u8DRMServiceShortId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DRMServiceShortId()). Otherwise it will return false.
     */
    inline bool hasU8DRMServiceShortId () const;

    /**
     * Returns the value of the member "u8DRMServiceShortId".
     *
     * If the meaning of "u8DRMServiceShortId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8DRMServiceShortId"
     */
    inline uint8 getU8DRMServiceShortId () const;

    /**
     * Sets the value of the member "u8DRMServiceShortId".
     *
     * If the meaning of "u8DRMServiceShortId" isn't clear, then there should be a description here.
     *
     * @param u8DRMServiceShortId The value which will be set
     */
    inline void setU8DRMServiceShortId (uint8 u8DRMServiceShortId_);

    // API of field "e8Modulation"

    static const int kE8Modulation = 16;

    /**
     * Clears the field "e8Modulation".
     *
     * The field will be set to its default value. The hasE8Modulation()
     * method will return false.
     */
    inline void clearE8Modulation();

    /**
     * Checks whether the field "e8Modulation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Modulation()). Otherwise it will return false.
     */
    inline bool hasE8Modulation () const;

    /**
     * Returns the value of the member "e8Modulation".
     *
     * If the meaning of "e8Modulation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Modulation"
     */
    inline T_e8_ModulationType getE8Modulation () const;

    /**
     * Sets the value of the member "e8Modulation".
     *
     * If the meaning of "e8Modulation" isn't clear, then there should be a description here.
     *
     * @param e8Modulation The value which will be set
     */
    inline void setE8Modulation (T_e8_ModulationType e8Modulation_);

    // API of field "u32HDStationId_DRMServiceId"

    static const int kU32HDStationId_DRMServiceId = 17;

    /**
     * Clears the field "u32HDStationId_DRMServiceId".
     *
     * The field will be set to its default value. The hasU32HDStationId_DRMServiceId()
     * method will return false.
     */
    inline void clearU32HDStationId_DRMServiceId();

    /**
     * Checks whether the field "u32HDStationId_DRMServiceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32HDStationId_DRMServiceId()). Otherwise it will return false.
     */
    inline bool hasU32HDStationId_DRMServiceId () const;

    /**
     * Returns the value of the member "u32HDStationId_DRMServiceId".
     *
     * If the meaning of "u32HDStationId_DRMServiceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32HDStationId_DRMServiceId"
     */
    inline uint32 getU32HDStationId_DRMServiceId () const;

    /**
     * Sets the value of the member "u32HDStationId_DRMServiceId".
     *
     * If the meaning of "u32HDStationId_DRMServiceId" isn't clear, then there should be a description here.
     *
     * @param u32HDStationId_DRMServiceId The value which will be set
     */
    inline void setU32HDStationId_DRMServiceId (uint32 u32HDStationId_DRMServiceId_);

    // API of field "e8HDTextEncoding"

    static const int kE8HDTextEncoding = 18;

    /**
     * Clears the field "e8HDTextEncoding".
     *
     * The field will be set to its default value. The hasE8HDTextEncoding()
     * method will return false.
     */
    inline void clearE8HDTextEncoding();

    /**
     * Checks whether the field "e8HDTextEncoding" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8HDTextEncoding()). Otherwise it will return false.
     */
    inline bool hasE8HDTextEncoding () const;

    /**
     * Returns the value of the member "e8HDTextEncoding".
     *
     * If the meaning of "e8HDTextEncoding" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8HDTextEncoding"
     */
    inline T_e8_HDTextEncoding getE8HDTextEncoding () const;

    /**
     * Sets the value of the member "e8HDTextEncoding".
     *
     * If the meaning of "e8HDTextEncoding" isn't clear, then there should be a description here.
     *
     * @param e8HDTextEncoding The value which will be set
     */
    inline void setE8HDTextEncoding (T_e8_HDTextEncoding e8HDTextEncoding_);

    // API of field "sHDCallSign_DRMServiceLabel"

    static const int kSHDCallSign_DRMServiceLabel = 19;

    /**
     * Clears the field "sHDCallSign_DRMServiceLabel".
     *
     * The field will be set to its default value. The hasSHDCallSign_DRMServiceLabel()
     * method will return false.
     */
    inline void clearSHDCallSign_DRMServiceLabel();

    /**
     * Checks whether the field "sHDCallSign_DRMServiceLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSHDCallSign_DRMServiceLabel()). Otherwise it will return false.
     */
    inline bool hasSHDCallSign_DRMServiceLabel () const;

    /**
     * Returns the value of the member "sHDCallSign_DRMServiceLabel".
     *
     * If the meaning of "sHDCallSign_DRMServiceLabel" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sHDCallSign_DRMServiceLabel"
     */
    inline const ::std::string& getSHDCallSign_DRMServiceLabel () const;

    /**
     * Retrieves the value of the field "sHDCallSign_DRMServiceLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sHDCallSign_DRMServiceLabel".
     */
    inline ::std::string& getSHDCallSign_DRMServiceLabelMutable ();

    /**
     * Sets the value of the member "sHDCallSign_DRMServiceLabel".
     *
     * If the meaning of "sHDCallSign_DRMServiceLabel" isn't clear, then there should be a description here.
     *
     * @param sHDCallSign_DRMServiceLabel The value which will be set
     */
    inline void setSHDCallSign_DRMServiceLabel (const ::std::string& sHDCallSign_DRMServiceLabel_);

    /**
     * Sets the value of the member "sHDCallSign_DRMServiceLabel".
     *
     * If the meaning of "sHDCallSign_DRMServiceLabel" isn't clear, then there should be a description here.
     *
     * @param sHDCallSign_DRMServiceLabel The value which will be set
     */
    inline void setSHDCallSign_DRMServiceLabel (const char* sHDCallSign_DRMServiceLabel_);

    /**
     * Sets the value of the member "sHDCallSign_DRMServiceLabel".
     *
     * If the meaning of "sHDCallSign_DRMServiceLabel" isn't clear, then there should be a description here.
     *
     * @param sHDCallSign_DRMServiceLabel The value which will be set
     */
    inline void setSHDCallSign_DRMServiceLabel (const char* value, size_t size);

    /**
     * Release the object stored in the field "sHDCallSign_DRMServiceLabel".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sHDCallSign_DRMServiceLabel"
     */
    inline ::std::string* releaseSHDCallSign_DRMServiceLabel();

    /**
     * Replace the field "sHDCallSign_DRMServiceLabel".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSHDCallSign_DRMServiceLabel (::std::string* sHDCallSign_DRMServiceLabel_);

    // API of field "u8HDStationGenre_DRMPty"

    static const int kU8HDStationGenre_DRMPty = 20;

    /**
     * Clears the field "u8HDStationGenre_DRMPty".
     *
     * The field will be set to its default value. The hasU8HDStationGenre_DRMPty()
     * method will return false.
     */
    inline void clearU8HDStationGenre_DRMPty();

    /**
     * Checks whether the field "u8HDStationGenre_DRMPty" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8HDStationGenre_DRMPty()). Otherwise it will return false.
     */
    inline bool hasU8HDStationGenre_DRMPty () const;

    /**
     * Returns the value of the member "u8HDStationGenre_DRMPty".
     *
     * If the meaning of "u8HDStationGenre_DRMPty" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8HDStationGenre_DRMPty"
     */
    inline uint8 getU8HDStationGenre_DRMPty () const;

    /**
     * Sets the value of the member "u8HDStationGenre_DRMPty".
     *
     * If the meaning of "u8HDStationGenre_DRMPty" isn't clear, then there should be a description here.
     *
     * @param u8HDStationGenre_DRMPty The value which will be set
     */
    inline void setU8HDStationGenre_DRMPty (uint8 u8HDStationGenre_DRMPty_);

    // API of field "u8HDAudioProgram_DRMShortID"

    static const int kU8HDAudioProgram_DRMShortID = 21;

    /**
     * Clears the field "u8HDAudioProgram_DRMShortID".
     *
     * The field will be set to its default value. The hasU8HDAudioProgram_DRMShortID()
     * method will return false.
     */
    inline void clearU8HDAudioProgram_DRMShortID();

    /**
     * Checks whether the field "u8HDAudioProgram_DRMShortID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8HDAudioProgram_DRMShortID()). Otherwise it will return false.
     */
    inline bool hasU8HDAudioProgram_DRMShortID () const;

    /**
     * Returns the value of the member "u8HDAudioProgram_DRMShortID".
     *
     * If the meaning of "u8HDAudioProgram_DRMShortID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8HDAudioProgram_DRMShortID"
     */
    inline uint8 getU8HDAudioProgram_DRMShortID () const;

    /**
     * Sets the value of the member "u8HDAudioProgram_DRMShortID".
     *
     * If the meaning of "u8HDAudioProgram_DRMShortID" isn't clear, then there should be a description here.
     *
     * @param u8HDAudioProgram_DRMShortID The value which will be set
     */
    inline void setU8HDAudioProgram_DRMShortID (uint8 u8HDAudioProgram_DRMShortID_);

    // API of field "SXMSMSlib_PresetListEntry"

    static const int kSXMSMSlib_PresetListEntry = 22;

    /**
     * Clears the field "SXMSMSlib_PresetListEntry".
     *
     * The field will be set to its default value. The hasSXMSMSlib_PresetListEntry()
     * method will return false.
     */
    inline void clearSXMSMSlib_PresetListEntry();

    /**
     * Checks whether the field "SXMSMSlib_PresetListEntry" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSXMSMSlib_PresetListEntry()). Otherwise it will return false.
     */
    inline bool hasSXMSMSlib_PresetListEntry () const;

    /**
     * Returns the value of the member "SXMSMSlib_PresetListEntry".
     *
     * Indicates the SXM channel contents for smslib
     *
     * @return The value of the field "SXMSMSlib_PresetListEntry"
     */
    inline const T_SXMPresetListEntry& getSXMSMSlib_PresetListEntry () const;

    /**
     * Retrieves the value of the field "SXMSMSlib_PresetListEntry" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SXMSMSlib_PresetListEntry".
     */
    inline T_SXMPresetListEntry& getSXMSMSlib_PresetListEntryMutable ();

    /**
     * Sets the value of the member "SXMSMSlib_PresetListEntry".
     *
     * Indicates the SXM channel contents for smslib
     *
     * @param SXMSMSlib_PresetListEntry The value which will be set
     */
    inline void setSXMSMSlib_PresetListEntry (const T_SXMPresetListEntry& SXMSMSlib_PresetListEntry_);

    /**
     * Release the object stored in the field "SXMSMSlib_PresetListEntry".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "SXMSMSlib_PresetListEntry"
     */
    inline T_SXMPresetListEntry* releaseSXMSMSlib_PresetListEntry();

    /**
     * Replace the field "SXMSMSlib_PresetListEntry".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSXMSMSlib_PresetListEntry (T_SXMPresetListEntry* SXMSMSlib_PresetListEntry_);

    // API of field "Key"

    static const int kKey = 23;

    /**
     * Clears the field "Key".
     *
     * The field will be set to its default value. The hasKey()
     * method will return false.
     */
    inline void clearKey();

    /**
     * Checks whether the field "Key" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKey()). Otherwise it will return false.
     */
    inline bool hasKey () const;

    /**
     * Returns the value of the member "Key".
     *
     * Indicates the Team Key or GUID for SXM360L
     *
     * @return The value of the field "Key"
     */
    inline const ::std::string& getKey () const;

    /**
     * Retrieves the value of the field "Key" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Key".
     */
    inline ::std::string& getKeyMutable ();

    /**
     * Sets the value of the member "Key".
     *
     * Indicates the Team Key or GUID for SXM360L
     *
     * @param Key The value which will be set
     */
    inline void setKey (const ::std::string& Key_);

    /**
     * Sets the value of the member "Key".
     *
     * Indicates the Team Key or GUID for SXM360L
     *
     * @param Key The value which will be set
     */
    inline void setKey (const char* Key_);

    /**
     * Sets the value of the member "Key".
     *
     * Indicates the Team Key or GUID for SXM360L
     *
     * @param Key The value which will be set
     */
    inline void setKey (const char* value, size_t size);

    /**
     * Release the object stored in the field "Key".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "Key"
     */
    inline ::std::string* releaseKey();

    /**
     * Replace the field "Key".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceKey (::std::string* Key_);

    // API of field "PresetType"

    static const int kPresetType = 24;

    /**
     * Clears the field "PresetType".
     *
     * The field will be set to its default value. The hasPresetType()
     * method will return false.
     */
    inline void clearPresetType();

    /**
     * Checks whether the field "PresetType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetType()). Otherwise it will return false.
     */
    inline bool hasPresetType () const;

    /**
     * Returns the value of the member "PresetType".
     *
     * Indicates the preset type for SXM360L
     *
     * @return The value of the field "PresetType"
     */
    inline T_e8_PresetType getPresetType () const;

    /**
     * Sets the value of the member "PresetType".
     *
     * Indicates the preset type for SXM360L
     *
     * @param PresetType The value which will be set
     */
    inline void setPresetType (T_e8_PresetType PresetType_);

    // API of field "SXM360L_PresetListEntry"

    static const int kSXM360L_PresetListEntry = 25;

    /**
     * Clears the field "SXM360L_PresetListEntry".
     *
     * The field will be set to its default value. The hasSXM360L_PresetListEntry()
     * method will return false.
     */
    inline void clearSXM360L_PresetListEntry();

    /**
     * Checks whether the field "SXM360L_PresetListEntry" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSXM360L_PresetListEntry()). Otherwise it will return false.
     */
    inline bool hasSXM360L_PresetListEntry () const;

    /**
     * Returns the value of the member "SXM360L_PresetListEntry".
     *
     * Indicates the SXM channel contents for SXM360L
     *
     * @return The value of the field "SXM360L_PresetListEntry"
     */
    inline const T_SXMChannelAttributes& getSXM360L_PresetListEntry () const;

    /**
     * Retrieves the value of the field "SXM360L_PresetListEntry" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SXM360L_PresetListEntry".
     */
    inline T_SXMChannelAttributes& getSXM360L_PresetListEntryMutable ();

    /**
     * Sets the value of the member "SXM360L_PresetListEntry".
     *
     * Indicates the SXM channel contents for SXM360L
     *
     * @param SXM360L_PresetListEntry The value which will be set
     */
    inline void setSXM360L_PresetListEntry (const T_SXMChannelAttributes& SXM360L_PresetListEntry_);

    /**
     * Release the object stored in the field "SXM360L_PresetListEntry".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "SXM360L_PresetListEntry"
     */
    inline T_SXMChannelAttributes* releaseSXM360L_PresetListEntry();

    /**
     * Replace the field "SXM360L_PresetListEntry".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSXM360L_PresetListEntry (T_SXMChannelAttributes* SXM360L_PresetListEntry_);

    static const T_PresetList &getDefaultInstance();

private:

    inline void set_has_List ();

    inline void clear_has_List ();

    inline void set_has_Band ();

    inline void clear_has_Band ();

    inline void set_has_Element_ID ();

    inline void clear_has_Element_ID ();

    inline void set_has_Frequency ();

    inline void clear_has_Frequency ();

    inline void set_has_PSName ();

    inline void clear_has_PSName ();

    inline void set_has_u8TpTmcInfo ();

    inline void clear_has_u8TpTmcInfo ();

    inline void set_has_PTY ();

    inline void clear_has_PTY ();

    inline void set_has_EnsembleName ();

    inline void clear_has_EnsembleName ();

    inline void set_has_Frequency_Label ();

    inline void clear_has_Frequency_Label ();

    inline void set_has_StationLogo ();

    inline void clear_has_StationLogo ();

    inline void set_has_u32HDStationId ();

    inline void clear_has_u32HDStationId ();

    inline void set_has_sHDCallSign ();

    inline void clear_has_sHDCallSign ();

    inline void set_has_e8HDAudioProgram ();

    inline void clear_has_e8HDAudioProgram ();

    inline void set_has_u32DRMServiceId ();

    inline void clear_has_u32DRMServiceId ();

    inline void set_has_sDRMServiceLabel ();

    inline void clear_has_sDRMServiceLabel ();

    inline void set_has_u8DRMServiceShortId ();

    inline void clear_has_u8DRMServiceShortId ();

    inline void set_has_e8Modulation ();

    inline void clear_has_e8Modulation ();

    inline void set_has_u32HDStationId_DRMServiceId ();

    inline void clear_has_u32HDStationId_DRMServiceId ();

    inline void set_has_e8HDTextEncoding ();

    inline void clear_has_e8HDTextEncoding ();

    inline void set_has_sHDCallSign_DRMServiceLabel ();

    inline void clear_has_sHDCallSign_DRMServiceLabel ();

    inline void set_has_u8HDStationGenre_DRMPty ();

    inline void clear_has_u8HDStationGenre_DRMPty ();

    inline void set_has_u8HDAudioProgram_DRMShortID ();

    inline void clear_has_u8HDAudioProgram_DRMShortID ();

    inline void set_has_SXMSMSlib_PresetListEntry ();

    inline void clear_has_SXMSMSlib_PresetListEntry ();

    inline void set_has_Key ();

    inline void clear_has_Key ();

    inline void set_has_PresetType ();

    inline void clear_has_PresetType ();

    inline void set_has_SXM360L_PresetListEntry ();

    inline void clear_has_SXM360L_PresetListEntry ();

    uint32 _has_bits_[ (26 + 31) / 32];

    T_e8_List _List;

    T_e8_Band _Band;

    uint8 _Element_ID;

    uint32 _Frequency;

    ::std::string* _PSName;

    uint8 _u8TpTmcInfo;

    uint32 _PTY;

    ::std::string* _EnsembleName;

    ::std::string* _Frequency_Label;

    ::std::string* _StationLogo;

    uint32 _u32HDStationId;

    ::std::string* _sHDCallSign;

    T_e8_HDAudioProgram _e8HDAudioProgram;

    uint32 _u32DRMServiceId;

    ::std::string* _sDRMServiceLabel;

    uint8 _u8DRMServiceShortId;

    T_e8_ModulationType _e8Modulation;

    uint32 _u32HDStationId_DRMServiceId;

    T_e8_HDTextEncoding _e8HDTextEncoding;

    ::std::string* _sHDCallSign_DRMServiceLabel;

    uint8 _u8HDStationGenre_DRMPty;

    uint8 _u8HDAudioProgram_DRMShortID;

    T_SXMPresetListEntry* _SXMSMSlib_PresetListEntry;

    ::std::string* _Key;

    T_e8_PresetType _PresetType;

    T_SXMChannelAttributes* _SXM360L_PresetListEntry;

};

/**
 * If the meaning of "T_SXMPresetEntry" isn't clear, then there should be a description here.
 */
class T_SXMPresetEntry {
public:

    /**
     * Default constructor
     */
    inline  T_SXMPresetEntry ();

    /**
     * Copy constructor
     */
    inline  T_SXMPresetEntry (const T_SXMPresetEntry &rhs);

    /**
     * All fields constructor
     */
    inline  T_SXMPresetEntry (uint8 PresetIndex_, uint32 PresetElemID_, const ::std::string& Key_, T_e8_PresetType PresetType_, const T_SXMChannelAttributes& ChannelAttributes_);

    /**
     * Destructor
     */
    inline  ~T_SXMPresetEntry();

    /**
     * Assignment operator
     */
    inline T_SXMPresetEntry& operator = (const T_SXMPresetEntry& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SXMPresetEntry& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SXMPresetEntry& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SXMPresetEntry& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SXMPresetEntry& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PresetIndex"

    static const int kPresetIndex = 0;

    /**
     * Clears the field "PresetIndex".
     *
     * The field will be set to its default value. The hasPresetIndex()
     * method will return false.
     */
    inline void clearPresetIndex();

    /**
     * Checks whether the field "PresetIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetIndex()). Otherwise it will return false.
     */
    inline bool hasPresetIndex () const;

    /**
     * Returns the value of the member "PresetIndex".
     *
     * Indicates preset index
     *
     * @return The value of the field "PresetIndex"
     */
    inline uint8 getPresetIndex () const;

    /**
     * Sets the value of the member "PresetIndex".
     *
     * Indicates preset index
     *
     * @param PresetIndex The value which will be set
     */
    inline void setPresetIndex (uint8 PresetIndex_);

    // API of field "PresetElemID"

    static const int kPresetElemID = 1;

    /**
     * Clears the field "PresetElemID".
     *
     * The field will be set to its default value. The hasPresetElemID()
     * method will return false.
     */
    inline void clearPresetElemID();

    /**
     * Checks whether the field "PresetElemID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetElemID()). Otherwise it will return false.
     */
    inline bool hasPresetElemID () const;

    /**
     * Returns the value of the member "PresetElemID".
     *
     * Indicates Channel ID or Service ID or Team ID
     *
     * @return The value of the field "PresetElemID"
     */
    inline uint32 getPresetElemID () const;

    /**
     * Sets the value of the member "PresetElemID".
     *
     * Indicates Channel ID or Service ID or Team ID
     *
     * @param PresetElemID The value which will be set
     */
    inline void setPresetElemID (uint32 PresetElemID_);

    // API of field "Key"

    static const int kKey = 2;

    /**
     * Clears the field "Key".
     *
     * The field will be set to its default value. The hasKey()
     * method will return false.
     */
    inline void clearKey();

    /**
     * Checks whether the field "Key" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKey()). Otherwise it will return false.
     */
    inline bool hasKey () const;

    /**
     * Returns the value of the member "Key".
     *
     * Indicates Team Key or GUID of the channel
     *
     * @return The value of the field "Key"
     */
    inline const ::std::string& getKey () const;

    /**
     * Retrieves the value of the field "Key" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Key".
     */
    inline ::std::string& getKeyMutable ();

    /**
     * Sets the value of the member "Key".
     *
     * Indicates Team Key or GUID of the channel
     *
     * @param Key The value which will be set
     */
    inline void setKey (const ::std::string& Key_);

    /**
     * Sets the value of the member "Key".
     *
     * Indicates Team Key or GUID of the channel
     *
     * @param Key The value which will be set
     */
    inline void setKey (const char* Key_);

    /**
     * Sets the value of the member "Key".
     *
     * Indicates Team Key or GUID of the channel
     *
     * @param Key The value which will be set
     */
    inline void setKey (const char* value, size_t size);

    /**
     * Release the object stored in the field "Key".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "Key"
     */
    inline ::std::string* releaseKey();

    /**
     * Replace the field "Key".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceKey (::std::string* Key_);

    // API of field "PresetType"

    static const int kPresetType = 3;

    /**
     * Clears the field "PresetType".
     *
     * The field will be set to its default value. The hasPresetType()
     * method will return false.
     */
    inline void clearPresetType();

    /**
     * Checks whether the field "PresetType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetType()). Otherwise it will return false.
     */
    inline bool hasPresetType () const;

    /**
     * Returns the value of the member "PresetType".
     *
     * Indicates the SXM preset type
     *
     * @return The value of the field "PresetType"
     */
    inline T_e8_PresetType getPresetType () const;

    /**
     * Sets the value of the member "PresetType".
     *
     * Indicates the SXM preset type
     *
     * @param PresetType The value which will be set
     */
    inline void setPresetType (T_e8_PresetType PresetType_);

    // API of field "ChannelAttributes"

    static const int kChannelAttributes = 4;

    /**
     * Clears the field "ChannelAttributes".
     *
     * The field will be set to its default value. The hasChannelAttributes()
     * method will return false.
     */
    inline void clearChannelAttributes();

    /**
     * Checks whether the field "ChannelAttributes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelAttributes()). Otherwise it will return false.
     */
    inline bool hasChannelAttributes () const;

    /**
     * Returns the value of the member "ChannelAttributes".
     *
     * Indicates the channel contents
     *
     * @return The value of the field "ChannelAttributes"
     */
    inline const T_SXMChannelAttributes& getChannelAttributes () const;

    /**
     * Retrieves the value of the field "ChannelAttributes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelAttributes".
     */
    inline T_SXMChannelAttributes& getChannelAttributesMutable ();

    /**
     * Sets the value of the member "ChannelAttributes".
     *
     * Indicates the channel contents
     *
     * @param ChannelAttributes The value which will be set
     */
    inline void setChannelAttributes (const T_SXMChannelAttributes& ChannelAttributes_);

    /**
     * Release the object stored in the field "ChannelAttributes".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "ChannelAttributes"
     */
    inline T_SXMChannelAttributes* releaseChannelAttributes();

    /**
     * Replace the field "ChannelAttributes".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceChannelAttributes (T_SXMChannelAttributes* ChannelAttributes_);

    static const T_SXMPresetEntry &getDefaultInstance();

private:

    inline void set_has_PresetIndex ();

    inline void clear_has_PresetIndex ();

    inline void set_has_PresetElemID ();

    inline void clear_has_PresetElemID ();

    inline void set_has_Key ();

    inline void clear_has_Key ();

    inline void set_has_PresetType ();

    inline void clear_has_PresetType ();

    inline void set_has_ChannelAttributes ();

    inline void clear_has_ChannelAttributes ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint8 _PresetIndex;

    uint32 _PresetElemID;

    ::std::string* _Key;

    T_e8_PresetType _PresetType;

    T_SXMChannelAttributes* _ChannelAttributes;

};

/**
 * If the meaning of "T_SXMChannelImagedata" isn't clear, then there should be a description here.
 */
class T_SXMChannelImagedata {
public:

    /**
     * Default constructor
     */
    inline  T_SXMChannelImagedata ();

    /**
     * Copy constructor
     */
    inline  T_SXMChannelImagedata (const T_SXMChannelImagedata &rhs);

    /**
     * All fields constructor
     */
    inline  T_SXMChannelImagedata (uint16 SID_, const ::std::vector< uint8 >& ImageData_, uint32 ImageDataSize_);

    /**
     * Destructor
     */
    inline  ~T_SXMChannelImagedata();

    /**
     * Assignment operator
     */
    inline T_SXMChannelImagedata& operator = (const T_SXMChannelImagedata& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SXMChannelImagedata& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SXMChannelImagedata& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SXMChannelImagedata& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SXMChannelImagedata& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SID"

    static const int kSID = 0;

    /**
     * Clears the field "SID".
     *
     * The field will be set to its default value. The hasSID()
     * method will return false.
     */
    inline void clearSID();

    /**
     * Checks whether the field "SID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSID()). Otherwise it will return false.
     */
    inline bool hasSID () const;

    /**
     * Returns the value of the member "SID".
     *
     * Service Indentifier.
     *
     * @return The value of the field "SID"
     */
    inline uint16 getSID () const;

    /**
     * Sets the value of the member "SID".
     *
     * Service Indentifier.
     *
     * @param SID The value which will be set
     */
    inline void setSID (uint16 SID_);

    // API of field "ImageData"

    static const int kImageData = 1;

    /**
     * Clears the field "ImageData".
     *
     * The field will be set to its default value. The hasImageData()
     * method will return false.
     */
    inline void clearImageData();

    /**
     * Checks whether the field "ImageData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImageData()). Otherwise it will return false.
     */
    inline bool hasImageData () const;

    /**
     * Returns the value of the member "ImageData".
     *
     * Indicates the program logo.
     *
     * @return The value of the field "ImageData"
     */
    inline const ::std::vector< uint8 >& getImageData () const;

    /**
     * Retrieves the value of the field "ImageData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ImageData".
     */
    inline ::std::vector< uint8 >& getImageDataMutable ();

    /**
     * Sets the value of the member "ImageData".
     *
     * Indicates the program logo.
     *
     * @param ImageData The value which will be set
     */
    inline void setImageData (const ::std::vector< uint8 >& ImageData_);

    /**
     * Release the object stored in the field "ImageData".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "ImageData"
     */
    inline ::std::vector< uint8 >* releaseImageData();

    /**
     * Replace the field "ImageData".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceImageData (::std::vector< uint8 >* ImageData_);

    // API of field "ImageDataSize"

    static const int kImageDataSize = 2;

    /**
     * Clears the field "ImageDataSize".
     *
     * The field will be set to its default value. The hasImageDataSize()
     * method will return false.
     */
    inline void clearImageDataSize();

    /**
     * Checks whether the field "ImageDataSize" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImageDataSize()). Otherwise it will return false.
     */
    inline bool hasImageDataSize () const;

    /**
     * Returns the value of the member "ImageDataSize".
     *
     * Image data size in bytes
     *
     * @return The value of the field "ImageDataSize"
     */
    inline uint32 getImageDataSize () const;

    /**
     * Sets the value of the member "ImageDataSize".
     *
     * Image data size in bytes
     *
     * @param ImageDataSize The value which will be set
     */
    inline void setImageDataSize (uint32 ImageDataSize_);

    static const T_SXMChannelImagedata &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_SID ();

    inline void clear_has_SID ();

    inline void set_has_ImageData ();

    inline void clear_has_ImageData ();

    inline void set_has_ImageDataSize ();

    inline void clear_has_ImageDataSize ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _SID;

    ::std::vector< uint8 >* _ImageData;

    uint32 _ImageDataSize;

};

/**
 * Indicates the type of Announcement. Bit 11- Weather alert from Weather Band
 */
class T_b32_AnnoType {
public:

    /**
     * Default constructor
     */
    inline  T_b32_AnnoType ();

    /**
     * Copy constructor
     */
    inline  T_b32_AnnoType (const T_b32_AnnoType &c);

    /**
     * Field constructor
     */
    inline  T_b32_AnnoType (bool TUNMSTR_ANNOTYPE_PTY, bool TUNMSTR_ANNOTYPE_TA, bool TUNMSTR_ANNOTYPE_TRANSPORT, bool TUNMSTR_ANNOTYPE_WARNING, bool TUNMSTR_ANNOTYPE_NEWS, bool TUNMSTR_ANNOTYPE_WEATHER, bool TUNMSTR_ANNOTYPE_EVENT, bool TUNMSTR_ANNOTYPE_SPECIALEVENT, bool TUNMSTR_ANNOTYPE_PROGRAMME, bool TUNMSTR_ANNOTYPE_SPORTS, bool TUNMSTR_ANNOTYPE_FINANCE, bool TUNMSTR_ANNOTYPE_WEATHERALERT);

    /**
     * Assignment operator
     */
    inline T_b32_AnnoType& operator = (const T_b32_AnnoType& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b32_AnnoType& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b32_AnnoType& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b32_AnnoType& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b32_AnnoType& rhs) const;

    /**
     * Sets the value of the member "TUNMSTR_ANNOTYPE_PTY".
     *
     * If the meaning of "TUNMSTR_ANNOTYPE_PTY" isn't clear, then there should be a description here.
     *
     * @param TUNMSTR_ANNOTYPE_PTY The value which will be set
     */
    inline void setTUNMSTR_ANNOTYPE_PTY (bool TUNMSTR_ANNOTYPE_PTY);

    /**
     * Returns the value of the member "TUNMSTR_ANNOTYPE_PTY".
     *
     * If the meaning of "TUNMSTR_ANNOTYPE_PTY" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUNMSTR_ANNOTYPE_PTY"
     */
    inline bool getTUNMSTR_ANNOTYPE_PTY () const;

    /**
     * Sets the value of the member "TUNMSTR_ANNOTYPE_TA".
     *
     * If the meaning of "TUNMSTR_ANNOTYPE_TA" isn't clear, then there should be a description here.
     *
     * @param TUNMSTR_ANNOTYPE_TA The value which will be set
     */
    inline void setTUNMSTR_ANNOTYPE_TA (bool TUNMSTR_ANNOTYPE_TA);

    /**
     * Returns the value of the member "TUNMSTR_ANNOTYPE_TA".
     *
     * If the meaning of "TUNMSTR_ANNOTYPE_TA" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUNMSTR_ANNOTYPE_TA"
     */
    inline bool getTUNMSTR_ANNOTYPE_TA () const;

    /**
     * Sets the value of the member "TUNMSTR_ANNOTYPE_TRANSPORT".
     *
     * If the meaning of "TUNMSTR_ANNOTYPE_TRANSPORT" isn't clear, then there should be a description here.
     *
     * @param TUNMSTR_ANNOTYPE_TRANSPORT The value which will be set
     */
    inline void setTUNMSTR_ANNOTYPE_TRANSPORT (bool TUNMSTR_ANNOTYPE_TRANSPORT);

    /**
     * Returns the value of the member "TUNMSTR_ANNOTYPE_TRANSPORT".
     *
     * If the meaning of "TUNMSTR_ANNOTYPE_TRANSPORT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUNMSTR_ANNOTYPE_TRANSPORT"
     */
    inline bool getTUNMSTR_ANNOTYPE_TRANSPORT () const;

    /**
     * Sets the value of the member "TUNMSTR_ANNOTYPE_WARNING".
     *
     * If the meaning of "TUNMSTR_ANNOTYPE_WARNING" isn't clear, then there should be a description here.
     *
     * @param TUNMSTR_ANNOTYPE_WARNING The value which will be set
     */
    inline void setTUNMSTR_ANNOTYPE_WARNING (bool TUNMSTR_ANNOTYPE_WARNING);

    /**
     * Returns the value of the member "TUNMSTR_ANNOTYPE_WARNING".
     *
     * If the meaning of "TUNMSTR_ANNOTYPE_WARNING" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUNMSTR_ANNOTYPE_WARNING"
     */
    inline bool getTUNMSTR_ANNOTYPE_WARNING () const;

    /**
     * Sets the value of the member "TUNMSTR_ANNOTYPE_NEWS".
     *
     * If the meaning of "TUNMSTR_ANNOTYPE_NEWS" isn't clear, then there should be a description here.
     *
     * @param TUNMSTR_ANNOTYPE_NEWS The value which will be set
     */
    inline void setTUNMSTR_ANNOTYPE_NEWS (bool TUNMSTR_ANNOTYPE_NEWS);

    /**
     * Returns the value of the member "TUNMSTR_ANNOTYPE_NEWS".
     *
     * If the meaning of "TUNMSTR_ANNOTYPE_NEWS" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUNMSTR_ANNOTYPE_NEWS"
     */
    inline bool getTUNMSTR_ANNOTYPE_NEWS () const;

    /**
     * Sets the value of the member "TUNMSTR_ANNOTYPE_WEATHER".
     *
     * If the meaning of "TUNMSTR_ANNOTYPE_WEATHER" isn't clear, then there should be a description here.
     *
     * @param TUNMSTR_ANNOTYPE_WEATHER The value which will be set
     */
    inline void setTUNMSTR_ANNOTYPE_WEATHER (bool TUNMSTR_ANNOTYPE_WEATHER);

    /**
     * Returns the value of the member "TUNMSTR_ANNOTYPE_WEATHER".
     *
     * If the meaning of "TUNMSTR_ANNOTYPE_WEATHER" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUNMSTR_ANNOTYPE_WEATHER"
     */
    inline bool getTUNMSTR_ANNOTYPE_WEATHER () const;

    /**
     * Sets the value of the member "TUNMSTR_ANNOTYPE_EVENT".
     *
     * If the meaning of "TUNMSTR_ANNOTYPE_EVENT" isn't clear, then there should be a description here.
     *
     * @param TUNMSTR_ANNOTYPE_EVENT The value which will be set
     */
    inline void setTUNMSTR_ANNOTYPE_EVENT (bool TUNMSTR_ANNOTYPE_EVENT);

    /**
     * Returns the value of the member "TUNMSTR_ANNOTYPE_EVENT".
     *
     * If the meaning of "TUNMSTR_ANNOTYPE_EVENT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUNMSTR_ANNOTYPE_EVENT"
     */
    inline bool getTUNMSTR_ANNOTYPE_EVENT () const;

    /**
     * Sets the value of the member "TUNMSTR_ANNOTYPE_SPECIALEVENT".
     *
     * If the meaning of "TUNMSTR_ANNOTYPE_SPECIALEVENT" isn't clear, then there should be a description here.
     *
     * @param TUNMSTR_ANNOTYPE_SPECIALEVENT The value which will be set
     */
    inline void setTUNMSTR_ANNOTYPE_SPECIALEVENT (bool TUNMSTR_ANNOTYPE_SPECIALEVENT);

    /**
     * Returns the value of the member "TUNMSTR_ANNOTYPE_SPECIALEVENT".
     *
     * If the meaning of "TUNMSTR_ANNOTYPE_SPECIALEVENT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUNMSTR_ANNOTYPE_SPECIALEVENT"
     */
    inline bool getTUNMSTR_ANNOTYPE_SPECIALEVENT () const;

    /**
     * Sets the value of the member "TUNMSTR_ANNOTYPE_PROGRAMME".
     *
     * If the meaning of "TUNMSTR_ANNOTYPE_PROGRAMME" isn't clear, then there should be a description here.
     *
     * @param TUNMSTR_ANNOTYPE_PROGRAMME The value which will be set
     */
    inline void setTUNMSTR_ANNOTYPE_PROGRAMME (bool TUNMSTR_ANNOTYPE_PROGRAMME);

    /**
     * Returns the value of the member "TUNMSTR_ANNOTYPE_PROGRAMME".
     *
     * If the meaning of "TUNMSTR_ANNOTYPE_PROGRAMME" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUNMSTR_ANNOTYPE_PROGRAMME"
     */
    inline bool getTUNMSTR_ANNOTYPE_PROGRAMME () const;

    /**
     * Sets the value of the member "TUNMSTR_ANNOTYPE_SPORTS".
     *
     * If the meaning of "TUNMSTR_ANNOTYPE_SPORTS" isn't clear, then there should be a description here.
     *
     * @param TUNMSTR_ANNOTYPE_SPORTS The value which will be set
     */
    inline void setTUNMSTR_ANNOTYPE_SPORTS (bool TUNMSTR_ANNOTYPE_SPORTS);

    /**
     * Returns the value of the member "TUNMSTR_ANNOTYPE_SPORTS".
     *
     * If the meaning of "TUNMSTR_ANNOTYPE_SPORTS" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUNMSTR_ANNOTYPE_SPORTS"
     */
    inline bool getTUNMSTR_ANNOTYPE_SPORTS () const;

    /**
     * Sets the value of the member "TUNMSTR_ANNOTYPE_FINANCE".
     *
     * If the meaning of "TUNMSTR_ANNOTYPE_FINANCE" isn't clear, then there should be a description here.
     *
     * @param TUNMSTR_ANNOTYPE_FINANCE The value which will be set
     */
    inline void setTUNMSTR_ANNOTYPE_FINANCE (bool TUNMSTR_ANNOTYPE_FINANCE);

    /**
     * Returns the value of the member "TUNMSTR_ANNOTYPE_FINANCE".
     *
     * If the meaning of "TUNMSTR_ANNOTYPE_FINANCE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUNMSTR_ANNOTYPE_FINANCE"
     */
    inline bool getTUNMSTR_ANNOTYPE_FINANCE () const;

    /**
     * Sets the value of the member "TUNMSTR_ANNOTYPE_WEATHERALERT".
     *
     * If the meaning of "TUNMSTR_ANNOTYPE_WEATHERALERT" isn't clear, then there should be a description here.
     *
     * @param TUNMSTR_ANNOTYPE_WEATHERALERT The value which will be set
     */
    inline void setTUNMSTR_ANNOTYPE_WEATHERALERT (bool TUNMSTR_ANNOTYPE_WEATHERALERT);

    /**
     * Returns the value of the member "TUNMSTR_ANNOTYPE_WEATHERALERT".
     *
     * If the meaning of "TUNMSTR_ANNOTYPE_WEATHERALERT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUNMSTR_ANNOTYPE_WEATHERALERT"
     */
    inline bool getTUNMSTR_ANNOTYPE_WEATHERALERT () const;

    static const T_b32_AnnoType &getDefaultInstance();

private:

    bool _TUNMSTR_ANNOTYPE_PTY:1;

    bool _TUNMSTR_ANNOTYPE_TA:1;

    bool _TUNMSTR_ANNOTYPE_TRANSPORT:1;

    bool _TUNMSTR_ANNOTYPE_WARNING:1;

    bool _TUNMSTR_ANNOTYPE_NEWS:1;

    bool _TUNMSTR_ANNOTYPE_WEATHER:1;

    bool _TUNMSTR_ANNOTYPE_EVENT:1;

    bool _TUNMSTR_ANNOTYPE_SPECIALEVENT:1;

    bool _TUNMSTR_ANNOTYPE_PROGRAMME:1;

    bool _TUNMSTR_ANNOTYPE_SPORTS:1;

    bool _TUNMSTR_ANNOTYPE_FINANCE:1;

    bool _TUNMSTR_ANNOTYPE_WEATHERALERT:1;

};

/**
 * Give Announcment setting Source infomation
 */
class T_b8_SourceAnno {
public:

    /**
     * Default constructor
     */
    inline  T_b8_SourceAnno ();

    /**
     * Copy constructor
     */
    inline  T_b8_SourceAnno (const T_b8_SourceAnno &c);

    /**
     * Field constructor
     */
    inline  T_b8_SourceAnno (bool TUNMSTR_ANNOSRC_FM, bool TUNMSTR_ANNOSRC_DAB, bool TUNMSTR_ANNOSRC_WEATHER);

    /**
     * Assignment operator
     */
    inline T_b8_SourceAnno& operator = (const T_b8_SourceAnno& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_SourceAnno& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_SourceAnno& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_SourceAnno& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_SourceAnno& rhs) const;

    /**
     * Sets the value of the member "TUNMSTR_ANNOSRC_FM".
     *
     * If the meaning of "TUNMSTR_ANNOSRC_FM" isn't clear, then there should be a description here.
     *
     * @param TUNMSTR_ANNOSRC_FM The value which will be set
     */
    inline void setTUNMSTR_ANNOSRC_FM (bool TUNMSTR_ANNOSRC_FM);

    /**
     * Returns the value of the member "TUNMSTR_ANNOSRC_FM".
     *
     * If the meaning of "TUNMSTR_ANNOSRC_FM" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUNMSTR_ANNOSRC_FM"
     */
    inline bool getTUNMSTR_ANNOSRC_FM () const;

    /**
     * Sets the value of the member "TUNMSTR_ANNOSRC_DAB".
     *
     * If the meaning of "TUNMSTR_ANNOSRC_DAB" isn't clear, then there should be a description here.
     *
     * @param TUNMSTR_ANNOSRC_DAB The value which will be set
     */
    inline void setTUNMSTR_ANNOSRC_DAB (bool TUNMSTR_ANNOSRC_DAB);

    /**
     * Returns the value of the member "TUNMSTR_ANNOSRC_DAB".
     *
     * If the meaning of "TUNMSTR_ANNOSRC_DAB" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUNMSTR_ANNOSRC_DAB"
     */
    inline bool getTUNMSTR_ANNOSRC_DAB () const;

    /**
     * Sets the value of the member "TUNMSTR_ANNOSRC_WEATHER".
     *
     * If the meaning of "TUNMSTR_ANNOSRC_WEATHER" isn't clear, then there should be a description here.
     *
     * @param TUNMSTR_ANNOSRC_WEATHER The value which will be set
     */
    inline void setTUNMSTR_ANNOSRC_WEATHER (bool TUNMSTR_ANNOSRC_WEATHER);

    /**
     * Returns the value of the member "TUNMSTR_ANNOSRC_WEATHER".
     *
     * If the meaning of "TUNMSTR_ANNOSRC_WEATHER" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUNMSTR_ANNOSRC_WEATHER"
     */
    inline bool getTUNMSTR_ANNOSRC_WEATHER () const;

    static const T_b8_SourceAnno &getDefaultInstance();

private:

    bool _TUNMSTR_ANNOSRC_FM:1;

    bool _TUNMSTR_ANNOSRC_DAB:1;

    bool _TUNMSTR_ANNOSRC_WEATHER:1;

};

/**
 * Mode for service linking
 */
class T_b8_ModeType {
public:

    /**
     * Default constructor
     */
    inline  T_b8_ModeType ();

    /**
     * Copy constructor
     */
    inline  T_b8_ModeType (const T_b8_ModeType &c);

    /**
     * Field constructor
     */
    inline  T_b8_ModeType (bool TUNMSTR_SF_FM, bool TUNMSTR_SF_DAB, bool TUNMSTR_SF_NONE);

    /**
     * Assignment operator
     */
    inline T_b8_ModeType& operator = (const T_b8_ModeType& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_ModeType& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_ModeType& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_ModeType& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_ModeType& rhs) const;

    /**
     * Sets the value of the member "TUNMSTR_SF_FM".
     *
     * If the meaning of "TUNMSTR_SF_FM" isn't clear, then there should be a description here.
     *
     * @param TUNMSTR_SF_FM The value which will be set
     */
    inline void setTUNMSTR_SF_FM (bool TUNMSTR_SF_FM);

    /**
     * Returns the value of the member "TUNMSTR_SF_FM".
     *
     * If the meaning of "TUNMSTR_SF_FM" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUNMSTR_SF_FM"
     */
    inline bool getTUNMSTR_SF_FM () const;

    /**
     * Sets the value of the member "TUNMSTR_SF_DAB".
     *
     * If the meaning of "TUNMSTR_SF_DAB" isn't clear, then there should be a description here.
     *
     * @param TUNMSTR_SF_DAB The value which will be set
     */
    inline void setTUNMSTR_SF_DAB (bool TUNMSTR_SF_DAB);

    /**
     * Returns the value of the member "TUNMSTR_SF_DAB".
     *
     * If the meaning of "TUNMSTR_SF_DAB" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUNMSTR_SF_DAB"
     */
    inline bool getTUNMSTR_SF_DAB () const;

    /**
     * Sets the value of the member "TUNMSTR_SF_NONE".
     *
     * If the meaning of "TUNMSTR_SF_NONE" isn't clear, then there should be a description here.
     *
     * @param TUNMSTR_SF_NONE The value which will be set
     */
    inline void setTUNMSTR_SF_NONE (bool TUNMSTR_SF_NONE);

    /**
     * Returns the value of the member "TUNMSTR_SF_NONE".
     *
     * If the meaning of "TUNMSTR_SF_NONE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUNMSTR_SF_NONE"
     */
    inline bool getTUNMSTR_SF_NONE () const;

    static const T_b8_ModeType &getDefaultInstance();

private:

    bool _TUNMSTR_SF_FM:1;

    bool _TUNMSTR_SF_DAB:1;

    bool _TUNMSTR_SF_NONE:1;

};

/**
 * DAB label used for ensemble, service and component labels .
 */
class T_DAB_Label {
public:

    /**
     * Default constructor
     */
    inline  T_DAB_Label ();

    /**
     * Copy constructor
     */
    inline  T_DAB_Label (const T_DAB_Label &rhs);

    /**
     * All fields constructor
     */
    inline  T_DAB_Label (const ::std::string& sLabel_, const ::std::string& sLabelShort_, uint16 u16LabelMask_);

    /**
     * Destructor
     */
    inline  ~T_DAB_Label();

    /**
     * Assignment operator
     */
    inline T_DAB_Label& operator = (const T_DAB_Label& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DAB_Label& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DAB_Label& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DAB_Label& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DAB_Label& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sLabel"

    static const int kSLabel = 0;

    /**
     * Clears the field "sLabel".
     *
     * The field will be set to its default value. The hasSLabel()
     * method will return false.
     */
    inline void clearSLabel();

    /**
     * Checks whether the field "sLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSLabel()). Otherwise it will return false.
     */
    inline bool hasSLabel () const;

    /**
     * Returns the value of the member "sLabel".
     *
     * Content of the label in UTF8 format. Max 16 characters.
     *
     * @return The value of the field "sLabel"
     */
    inline const ::std::string& getSLabel () const;

    /**
     * Retrieves the value of the field "sLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sLabel".
     */
    inline ::std::string& getSLabelMutable ();

    /**
     * Sets the value of the member "sLabel".
     *
     * Content of the label in UTF8 format. Max 16 characters.
     *
     * @param sLabel The value which will be set
     */
    inline void setSLabel (const ::std::string& sLabel_);

    /**
     * Sets the value of the member "sLabel".
     *
     * Content of the label in UTF8 format. Max 16 characters.
     *
     * @param sLabel The value which will be set
     */
    inline void setSLabel (const char* sLabel_);

    /**
     * Sets the value of the member "sLabel".
     *
     * Content of the label in UTF8 format. Max 16 characters.
     *
     * @param sLabel The value which will be set
     */
    inline void setSLabel (const char* value, size_t size);

    /**
     * Release the object stored in the field "sLabel".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sLabel"
     */
    inline ::std::string* releaseSLabel();

    /**
     * Replace the field "sLabel".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSLabel (::std::string* sLabel_);

    // API of field "sLabelShort"

    static const int kSLabelShort = 1;

    /**
     * Clears the field "sLabelShort".
     *
     * The field will be set to its default value. The hasSLabelShort()
     * method will return false.
     */
    inline void clearSLabelShort();

    /**
     * Checks whether the field "sLabelShort" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSLabelShort()). Otherwise it will return false.
     */
    inline bool hasSLabelShort () const;

    /**
     * Returns the value of the member "sLabelShort".
     *
     * Content of the label in UTF8 format. Max  8 characters.
     *
     * @return The value of the field "sLabelShort"
     */
    inline const ::std::string& getSLabelShort () const;

    /**
     * Retrieves the value of the field "sLabelShort" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sLabelShort".
     */
    inline ::std::string& getSLabelShortMutable ();

    /**
     * Sets the value of the member "sLabelShort".
     *
     * Content of the label in UTF8 format. Max  8 characters.
     *
     * @param sLabelShort The value which will be set
     */
    inline void setSLabelShort (const ::std::string& sLabelShort_);

    /**
     * Sets the value of the member "sLabelShort".
     *
     * Content of the label in UTF8 format. Max  8 characters.
     *
     * @param sLabelShort The value which will be set
     */
    inline void setSLabelShort (const char* sLabelShort_);

    /**
     * Sets the value of the member "sLabelShort".
     *
     * Content of the label in UTF8 format. Max  8 characters.
     *
     * @param sLabelShort The value which will be set
     */
    inline void setSLabelShort (const char* value, size_t size);

    /**
     * Release the object stored in the field "sLabelShort".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sLabelShort"
     */
    inline ::std::string* releaseSLabelShort();

    /**
     * Replace the field "sLabelShort".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSLabelShort (::std::string* sLabelShort_);

    // API of field "u16LabelMask"

    static const int kU16LabelMask = 2;

    /**
     * Clears the field "u16LabelMask".
     *
     * The field will be set to its default value. The hasU16LabelMask()
     * method will return false.
     */
    inline void clearU16LabelMask();

    /**
     * Checks whether the field "u16LabelMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16LabelMask()). Otherwise it will return false.
     */
    inline bool hasU16LabelMask () const;

    /**
     * Returns the value of the member "u16LabelMask".
     *
     * Label Mask to get short label
     *
     * @return The value of the field "u16LabelMask"
     */
    inline uint16 getU16LabelMask () const;

    /**
     * Sets the value of the member "u16LabelMask".
     *
     * Label Mask to get short label
     *
     * @param u16LabelMask The value which will be set
     */
    inline void setU16LabelMask (uint16 u16LabelMask_);

    static const T_DAB_Label &getDefaultInstance();

private:

    inline void set_has_sLabel ();

    inline void clear_has_sLabel ();

    inline void set_has_sLabelShort ();

    inline void clear_has_sLabelShort ();

    inline void set_has_u16LabelMask ();

    inline void clear_has_u16LabelMask ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string* _sLabel;

    ::std::string* _sLabelShort;

    uint16 _u16LabelMask;

};

/**
 * Parameters that needs to be configured or notified 01-Only Presets 02-Only AM switch 03- Both Presets and AM Switch
 */
class T_b8_RadioProfileSettingAction {
public:

    /**
     * Default constructor
     */
    inline  T_b8_RadioProfileSettingAction ();

    /**
     * Copy constructor
     */
    inline  T_b8_RadioProfileSettingAction (const T_b8_RadioProfileSettingAction &c);

    /**
     * Field constructor
     */
    inline  T_b8_RadioProfileSettingAction (bool TUNMSTR_PROFILE_ACTION_PRESETS, bool TUNMSTR_PROFILE_ACTION_AMSWITCH);

    /**
     * Assignment operator
     */
    inline T_b8_RadioProfileSettingAction& operator = (const T_b8_RadioProfileSettingAction& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_RadioProfileSettingAction& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_RadioProfileSettingAction& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_RadioProfileSettingAction& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_RadioProfileSettingAction& rhs) const;

    /**
     * Sets the value of the member "TUNMSTR_PROFILE_ACTION_PRESETS".
     *
     * If the meaning of "TUNMSTR_PROFILE_ACTION_PRESETS" isn't clear, then there should be a description here.
     *
     * @param TUNMSTR_PROFILE_ACTION_PRESETS The value which will be set
     */
    inline void setTUNMSTR_PROFILE_ACTION_PRESETS (bool TUNMSTR_PROFILE_ACTION_PRESETS);

    /**
     * Returns the value of the member "TUNMSTR_PROFILE_ACTION_PRESETS".
     *
     * If the meaning of "TUNMSTR_PROFILE_ACTION_PRESETS" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUNMSTR_PROFILE_ACTION_PRESETS"
     */
    inline bool getTUNMSTR_PROFILE_ACTION_PRESETS () const;

    /**
     * Sets the value of the member "TUNMSTR_PROFILE_ACTION_AMSWITCH".
     *
     * If the meaning of "TUNMSTR_PROFILE_ACTION_AMSWITCH" isn't clear, then there should be a description here.
     *
     * @param TUNMSTR_PROFILE_ACTION_AMSWITCH The value which will be set
     */
    inline void setTUNMSTR_PROFILE_ACTION_AMSWITCH (bool TUNMSTR_PROFILE_ACTION_AMSWITCH);

    /**
     * Returns the value of the member "TUNMSTR_PROFILE_ACTION_AMSWITCH".
     *
     * If the meaning of "TUNMSTR_PROFILE_ACTION_AMSWITCH" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUNMSTR_PROFILE_ACTION_AMSWITCH"
     */
    inline bool getTUNMSTR_PROFILE_ACTION_AMSWITCH () const;

    static const T_b8_RadioProfileSettingAction &getDefaultInstance();

private:

    bool _TUNMSTR_PROFILE_ACTION_PRESETS:1;

    bool _TUNMSTR_PROFILE_ACTION_AMSWITCH:1;

};

/**
 * Tuner Preset list element structure.
 */
class T_TunMst_PresetListElement {
public:

    /**
     * Default constructor
     */
    inline  T_TunMst_PresetListElement ();

    /**
     * Copy constructor
     */
    inline  T_TunMst_PresetListElement (const T_TunMst_PresetListElement &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunMst_PresetListElement (T_e8_TunMst_RadioType e8RadioType_, uint8 u8PresetNumber_, uint32 u32Frequency_, uint32 u32SID_, const ::std::string& sStationName_, uint32 u32TextEncoding_, uint8 u8ProgramNumber_, uint32 u32EnsembleId_, const ::std::string& ComponentLabel_, uint32 u32ComponentLabelEncoding_);

    /**
     * Destructor
     */
    inline  ~T_TunMst_PresetListElement();

    /**
     * Assignment operator
     */
    inline T_TunMst_PresetListElement& operator = (const T_TunMst_PresetListElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunMst_PresetListElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunMst_PresetListElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunMst_PresetListElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunMst_PresetListElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8RadioType"

    static const int kE8RadioType = 0;

    /**
     * Clears the field "e8RadioType".
     *
     * The field will be set to its default value. The hasE8RadioType()
     * method will return false.
     */
    inline void clearE8RadioType();

    /**
     * Checks whether the field "e8RadioType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8RadioType()). Otherwise it will return false.
     */
    inline bool hasE8RadioType () const;

    /**
     * Returns the value of the member "e8RadioType".
     *
     * AM, FM ,DAB , AMHD ,FMHD, SXM  or DRM station
     *
     * @return The value of the field "e8RadioType"
     */
    inline T_e8_TunMst_RadioType getE8RadioType () const;

    /**
     * Sets the value of the member "e8RadioType".
     *
     * AM, FM ,DAB , AMHD ,FMHD, SXM  or DRM station
     *
     * @param e8RadioType The value which will be set
     */
    inline void setE8RadioType (T_e8_TunMst_RadioType e8RadioType_);

    // API of field "u8PresetNumber"

    static const int kU8PresetNumber = 1;

    /**
     * Clears the field "u8PresetNumber".
     *
     * The field will be set to its default value. The hasU8PresetNumber()
     * method will return false.
     */
    inline void clearU8PresetNumber();

    /**
     * Checks whether the field "u8PresetNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PresetNumber()). Otherwise it will return false.
     */
    inline bool hasU8PresetNumber () const;

    /**
     * Returns the value of the member "u8PresetNumber".
     *
     * preset number
     *
     * @return The value of the field "u8PresetNumber"
     */
    inline uint8 getU8PresetNumber () const;

    /**
     * Sets the value of the member "u8PresetNumber".
     *
     * preset number
     *
     * @param u8PresetNumber The value which will be set
     */
    inline void setU8PresetNumber (uint8 u8PresetNumber_);

    // API of field "u32Frequency"

    static const int kU32Frequency = 2;

    /**
     * Clears the field "u32Frequency".
     *
     * The field will be set to its default value. The hasU32Frequency()
     * method will return false.
     */
    inline void clearU32Frequency();

    /**
     * Checks whether the field "u32Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Frequency()). Otherwise it will return false.
     */
    inline bool hasU32Frequency () const;

    /**
     * Returns the value of the member "u32Frequency".
     *
     *
     *
     * @return The value of the field "u32Frequency"
     */
    inline uint32 getU32Frequency () const;

    /**
     * Sets the value of the member "u32Frequency".
     *
     *
     *
     * @param u32Frequency The value which will be set
     */
    inline void setU32Frequency (uint32 u32Frequency_);

    // API of field "u32SID"

    static const int kU32SID = 3;

    /**
     * Clears the field "u32SID".
     *
     * The field will be set to its default value. The hasU32SID()
     * method will return false.
     */
    inline void clearU32SID();

    /**
     * Checks whether the field "u32SID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SID()). Otherwise it will return false.
     */
    inline bool hasU32SID () const;

    /**
     * Returns the value of the member "u32SID".
     *
     * DAB/SXM/DRM/HD service ID
     * For FM RDS station u32SID will have PI code
     *
     * @return The value of the field "u32SID"
     */
    inline uint32 getU32SID () const;

    /**
     * Sets the value of the member "u32SID".
     *
     * DAB/SXM/DRM/HD service ID
     * For FM RDS station u32SID will have PI code
     *
     * @param u32SID The value which will be set
     */
    inline void setU32SID (uint32 u32SID_);

    // API of field "sStationName"

    static const int kSStationName = 4;

    /**
     * Clears the field "sStationName".
     *
     * The field will be set to its default value. The hasSStationName()
     * method will return false.
     */
    inline void clearSStationName();

    /**
     * Checks whether the field "sStationName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSStationName()). Otherwise it will return false.
     */
    inline bool hasSStationName () const;

    /**
     * Returns the value of the member "sStationName".
     *
     *
     *
     * @return The value of the field "sStationName"
     */
    inline const ::std::string& getSStationName () const;

    /**
     * Retrieves the value of the field "sStationName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sStationName".
     */
    inline ::std::string& getSStationNameMutable ();

    /**
     * Sets the value of the member "sStationName".
     *
     *
     *
     * @param sStationName The value which will be set
     */
    inline void setSStationName (const ::std::string& sStationName_);

    /**
     * Sets the value of the member "sStationName".
     *
     *
     *
     * @param sStationName The value which will be set
     */
    inline void setSStationName (const char* sStationName_);

    /**
     * Sets the value of the member "sStationName".
     *
     *
     *
     * @param sStationName The value which will be set
     */
    inline void setSStationName (const char* value, size_t size);

    /**
     * Release the object stored in the field "sStationName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sStationName"
     */
    inline ::std::string* releaseSStationName();

    /**
     * Replace the field "sStationName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSStationName (::std::string* sStationName_);

    // API of field "u32TextEncoding"

    static const int kU32TextEncoding = 5;

    /**
     * Clears the field "u32TextEncoding".
     *
     * The field will be set to its default value. The hasU32TextEncoding()
     * method will return false.
     */
    inline void clearU32TextEncoding();

    /**
     * Checks whether the field "u32TextEncoding" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32TextEncoding()). Otherwise it will return false.
     */
    inline bool hasU32TextEncoding () const;

    /**
     * Returns the value of the member "u32TextEncoding".
     *
     *
     *
     * @return The value of the field "u32TextEncoding"
     */
    inline uint32 getU32TextEncoding () const;

    /**
     * Sets the value of the member "u32TextEncoding".
     *
     *
     *
     * @param u32TextEncoding The value which will be set
     */
    inline void setU32TextEncoding (uint32 u32TextEncoding_);

    // API of field "u8ProgramNumber"

    static const int kU8ProgramNumber = 6;

    /**
     * Clears the field "u8ProgramNumber".
     *
     * The field will be set to its default value. The hasU8ProgramNumber()
     * method will return false.
     */
    inline void clearU8ProgramNumber();

    /**
     * Checks whether the field "u8ProgramNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ProgramNumber()). Otherwise it will return false.
     */
    inline bool hasU8ProgramNumber () const;

    /**
     * Returns the value of the member "u8ProgramNumber".
     *
     * HD/DRM program number/DAB component id
     *
     * @return The value of the field "u8ProgramNumber"
     */
    inline uint8 getU8ProgramNumber () const;

    /**
     * Sets the value of the member "u8ProgramNumber".
     *
     * HD/DRM program number/DAB component id
     *
     * @param u8ProgramNumber The value which will be set
     */
    inline void setU8ProgramNumber (uint8 u8ProgramNumber_);

    // API of field "u32EnsembleId"

    static const int kU32EnsembleId = 7;

    /**
     * Clears the field "u32EnsembleId".
     *
     * The field will be set to its default value. The hasU32EnsembleId()
     * method will return false.
     */
    inline void clearU32EnsembleId();

    /**
     * Checks whether the field "u32EnsembleId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32EnsembleId()). Otherwise it will return false.
     */
    inline bool hasU32EnsembleId () const;

    /**
     * Returns the value of the member "u32EnsembleId".
     *
     * Ensemble id
     *
     * @return The value of the field "u32EnsembleId"
     */
    inline uint32 getU32EnsembleId () const;

    /**
     * Sets the value of the member "u32EnsembleId".
     *
     * Ensemble id
     *
     * @param u32EnsembleId The value which will be set
     */
    inline void setU32EnsembleId (uint32 u32EnsembleId_);

    // API of field "ComponentLabel"

    static const int kComponentLabel = 8;

    /**
     * Clears the field "ComponentLabel".
     *
     * The field will be set to its default value. The hasComponentLabel()
     * method will return false.
     */
    inline void clearComponentLabel();

    /**
     * Checks whether the field "ComponentLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setComponentLabel()). Otherwise it will return false.
     */
    inline bool hasComponentLabel () const;

    /**
     * Returns the value of the member "ComponentLabel".
     *
     * Component label
     *
     * @return The value of the field "ComponentLabel"
     */
    inline const ::std::string& getComponentLabel () const;

    /**
     * Retrieves the value of the field "ComponentLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ComponentLabel".
     */
    inline ::std::string& getComponentLabelMutable ();

    /**
     * Sets the value of the member "ComponentLabel".
     *
     * Component label
     *
     * @param ComponentLabel The value which will be set
     */
    inline void setComponentLabel (const ::std::string& ComponentLabel_);

    /**
     * Sets the value of the member "ComponentLabel".
     *
     * Component label
     *
     * @param ComponentLabel The value which will be set
     */
    inline void setComponentLabel (const char* ComponentLabel_);

    /**
     * Sets the value of the member "ComponentLabel".
     *
     * Component label
     *
     * @param ComponentLabel The value which will be set
     */
    inline void setComponentLabel (const char* value, size_t size);

    /**
     * Release the object stored in the field "ComponentLabel".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "ComponentLabel"
     */
    inline ::std::string* releaseComponentLabel();

    /**
     * Replace the field "ComponentLabel".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceComponentLabel (::std::string* ComponentLabel_);

    // API of field "u32ComponentLabelEncoding"

    static const int kU32ComponentLabelEncoding = 9;

    /**
     * Clears the field "u32ComponentLabelEncoding".
     *
     * The field will be set to its default value. The hasU32ComponentLabelEncoding()
     * method will return false.
     */
    inline void clearU32ComponentLabelEncoding();

    /**
     * Checks whether the field "u32ComponentLabelEncoding" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ComponentLabelEncoding()). Otherwise it will return false.
     */
    inline bool hasU32ComponentLabelEncoding () const;

    /**
     * Returns the value of the member "u32ComponentLabelEncoding".
     *
     *
     *
     * @return The value of the field "u32ComponentLabelEncoding"
     */
    inline uint32 getU32ComponentLabelEncoding () const;

    /**
     * Sets the value of the member "u32ComponentLabelEncoding".
     *
     *
     *
     * @param u32ComponentLabelEncoding The value which will be set
     */
    inline void setU32ComponentLabelEncoding (uint32 u32ComponentLabelEncoding_);

    static const T_TunMst_PresetListElement &getDefaultInstance();

private:

    inline void set_has_e8RadioType ();

    inline void clear_has_e8RadioType ();

    inline void set_has_u8PresetNumber ();

    inline void clear_has_u8PresetNumber ();

    inline void set_has_u32Frequency ();

    inline void clear_has_u32Frequency ();

    inline void set_has_u32SID ();

    inline void clear_has_u32SID ();

    inline void set_has_sStationName ();

    inline void clear_has_sStationName ();

    inline void set_has_u32TextEncoding ();

    inline void clear_has_u32TextEncoding ();

    inline void set_has_u8ProgramNumber ();

    inline void clear_has_u8ProgramNumber ();

    inline void set_has_u32EnsembleId ();

    inline void clear_has_u32EnsembleId ();

    inline void set_has_ComponentLabel ();

    inline void clear_has_ComponentLabel ();

    inline void set_has_u32ComponentLabelEncoding ();

    inline void clear_has_u32ComponentLabelEncoding ();

    uint32 _has_bits_[ (10 + 31) / 32];

    T_e8_TunMst_RadioType _e8RadioType;

    uint8 _u8PresetNumber;

    uint32 _u32Frequency;

    uint32 _u32SID;

    ::std::string* _sStationName;

    uint32 _u32TextEncoding;

    uint8 _u8ProgramNumber;

    uint32 _u32EnsembleId;

    ::std::string* _ComponentLabel;

    uint32 _u32ComponentLabelEncoding;

};

/**
 * If the meaning of "T_ProfileResponse" isn't clear, then there should be a description here.
 */
class T_ProfileResponse {
public:

    /**
     * Default constructor
     */
    inline  T_ProfileResponse ();

    /**
     * Copy constructor
     */
    inline  T_ProfileResponse (const T_ProfileResponse &rhs);

    /**
     * All fields constructor
     */
    inline  T_ProfileResponse (T_ProfileActionStatus Status_, T_ProfileAction ProfileAction_, T_ProfileStatus ProfileStatus_);

    /**
     * Destructor
     */
    inline  ~T_ProfileResponse();

    /**
     * Assignment operator
     */
    inline T_ProfileResponse& operator = (const T_ProfileResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ProfileResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ProfileResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ProfileResponse& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ProfileResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * User profile action status success/failed for SXM360L.
     *
     * @return The value of the field "Status"
     */
    inline T_ProfileActionStatus getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * User profile action status success/failed for SXM360L.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (T_ProfileActionStatus Status_);

    // API of field "ProfileAction"

    static const int kProfileAction = 1;

    /**
     * Clears the field "ProfileAction".
     *
     * The field will be set to its default value. The hasProfileAction()
     * method will return false.
     */
    inline void clearProfileAction();

    /**
     * Checks whether the field "ProfileAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProfileAction()). Otherwise it will return false.
     */
    inline bool hasProfileAction () const;

    /**
     * Returns the value of the member "ProfileAction".
     *
     * Type of profile action
     *
     * @return The value of the field "ProfileAction"
     */
    inline T_ProfileAction getProfileAction () const;

    /**
     * Sets the value of the member "ProfileAction".
     *
     * Type of profile action
     *
     * @param ProfileAction The value which will be set
     */
    inline void setProfileAction (T_ProfileAction ProfileAction_);

    // API of field "ProfileStatus"

    static const int kProfileStatus = 2;

    /**
     * Clears the field "ProfileStatus".
     *
     * The field will be set to its default value. The hasProfileStatus()
     * method will return false.
     */
    inline void clearProfileStatus();

    /**
     * Checks whether the field "ProfileStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProfileStatus()). Otherwise it will return false.
     */
    inline bool hasProfileStatus () const;

    /**
     * Returns the value of the member "ProfileStatus".
     *
     * Profile status
     *
     * @return The value of the field "ProfileStatus"
     */
    inline T_ProfileStatus getProfileStatus () const;

    /**
     * Sets the value of the member "ProfileStatus".
     *
     * Profile status
     *
     * @param ProfileStatus The value which will be set
     */
    inline void setProfileStatus (T_ProfileStatus ProfileStatus_);

    static const T_ProfileResponse &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    inline void set_has_ProfileAction ();

    inline void clear_has_ProfileAction ();

    inline void set_has_ProfileStatus ();

    inline void clear_has_ProfileStatus ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_ProfileActionStatus _Status;

    T_ProfileAction _ProfileAction;

    T_ProfileStatus _ProfileStatus;

};

inline  T_TunerMaster_StatusResponse::T_TunerMaster_StatusResponse ()  :
    _u8TunermasterStatus (::midw_tunermaster_fi_types::T_e8_TunMstr_ResponseStatus__TUN_MSTR_RES_REQ_SUCCEED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TunerMaster_StatusResponse::T_TunerMaster_StatusResponse (const T_TunerMaster_StatusResponse &rhs)  :
    _u8TunermasterStatus (::midw_tunermaster_fi_types::T_e8_TunMstr_ResponseStatus__TUN_MSTR_RES_REQ_SUCCEED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TunerMaster_StatusResponse::T_TunerMaster_StatusResponse (T_e8_TunMstr_ResponseStatus u8TunermasterStatus_)  :
    _u8TunermasterStatus (u8TunermasterStatus_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_TunMstr_ResponseStatus_IsValid(u8TunermasterStatus_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8TunermasterStatus_, "T_e8_TunMstr_ResponseStatus", "u8TunermasterStatus", "T_TunerMaster_StatusResponse");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TunerMaster_StatusResponse::~T_TunerMaster_StatusResponse() {
}

inline T_TunerMaster_StatusResponse& T_TunerMaster_StatusResponse::operator = (const T_TunerMaster_StatusResponse& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8TunermasterStatus()) {
            setU8TunermasterStatus(rhs.getU8TunermasterStatus());
        } else {
            clearU8TunermasterStatus();
        }
    }
    return *this;
}

inline bool T_TunerMaster_StatusResponse::operator == (const T_TunerMaster_StatusResponse& rhs) const {
    return (((!hasU8TunermasterStatus() && !rhs.hasU8TunermasterStatus()) || getU8TunermasterStatus() == rhs.getU8TunermasterStatus()));
}

inline bool T_TunerMaster_StatusResponse::operator != (const T_TunerMaster_StatusResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TunerMaster_StatusResponse::operator < (const T_TunerMaster_StatusResponse& rhs) const {
    if (hasU8TunermasterStatus() || rhs.hasU8TunermasterStatus()) {
        if ((uint32)getU8TunermasterStatus() < (uint32)rhs.getU8TunermasterStatus()) return true;
        if ((uint32)getU8TunermasterStatus() > (uint32)rhs.getU8TunermasterStatus()) return false;
    }
    return false;
}

inline bool T_TunerMaster_StatusResponse::operator > (const T_TunerMaster_StatusResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TunerMaster_StatusResponse::clear() {
    clearU8TunermasterStatus();
}

inline void T_TunerMaster_StatusResponse::clearU8TunermasterStatus() {
    if (hasU8TunermasterStatus()) {
         clear_has_u8TunermasterStatus();
        _u8TunermasterStatus = ::midw_tunermaster_fi_types::T_e8_TunMstr_ResponseStatus__TUN_MSTR_RES_REQ_SUCCEED;
     }
}

inline bool T_TunerMaster_StatusResponse::hasU8TunermasterStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_TunMstr_ResponseStatus T_TunerMaster_StatusResponse::getU8TunermasterStatus () const {
    return _u8TunermasterStatus;
}

inline void T_TunerMaster_StatusResponse::setU8TunermasterStatus (T_e8_TunMstr_ResponseStatus u8TunermasterStatus_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_TunMstr_ResponseStatus_IsValid(u8TunermasterStatus_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8TunermasterStatus_, "T_e8_TunMstr_ResponseStatus", "u8TunermasterStatus", "T_TunerMaster_StatusResponse");
    }
    set_has_u8TunermasterStatus();
    this->_u8TunermasterStatus = u8TunermasterStatus_;
}

inline void T_TunerMaster_StatusResponse::set_has_u8TunermasterStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TunerMaster_StatusResponse::clear_has_u8TunermasterStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  T_TunMstr_RadioSetting_StatusResponse::T_TunMstr_RadioSetting_StatusResponse ()  :
    _RadioProfileSetting_Response (::midw_tunermaster_fi_types::T_e8_TunMstr_RadioProfileSetting_Response__TUN_MSTR_RadioProfileSetting_Res_Succeed),
    _RadioProfileSetting_ErrorCode (::midw_tunermaster_fi_types::T_e8_TunMstr_RadioProfileSetting_ErrorCode__TUN_MSTR_RadioProfileSetting_ErrorCode_BandNotSupported)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TunMstr_RadioSetting_StatusResponse::T_TunMstr_RadioSetting_StatusResponse (const T_TunMstr_RadioSetting_StatusResponse &rhs)  :
    _RadioProfileSetting_Response (::midw_tunermaster_fi_types::T_e8_TunMstr_RadioProfileSetting_Response__TUN_MSTR_RadioProfileSetting_Res_Succeed),
    _RadioProfileSetting_ErrorCode (::midw_tunermaster_fi_types::T_e8_TunMstr_RadioProfileSetting_ErrorCode__TUN_MSTR_RadioProfileSetting_ErrorCode_BandNotSupported)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TunMstr_RadioSetting_StatusResponse::T_TunMstr_RadioSetting_StatusResponse (T_e8_TunMstr_RadioProfileSetting_Response RadioProfileSetting_Response_, T_e8_TunMstr_RadioProfileSetting_ErrorCode RadioProfileSetting_ErrorCode_)  :
    _RadioProfileSetting_Response (RadioProfileSetting_Response_),
    _RadioProfileSetting_ErrorCode (RadioProfileSetting_ErrorCode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_TunMstr_RadioProfileSetting_Response_IsValid(RadioProfileSetting_Response_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", RadioProfileSetting_Response_, "T_e8_TunMstr_RadioProfileSetting_Response", "RadioProfileSetting_Response", "T_TunMstr_RadioSetting_StatusResponse");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_TunMstr_RadioProfileSetting_ErrorCode_IsValid(RadioProfileSetting_ErrorCode_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", RadioProfileSetting_ErrorCode_, "T_e8_TunMstr_RadioProfileSetting_ErrorCode", "RadioProfileSetting_ErrorCode", "T_TunMstr_RadioSetting_StatusResponse");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TunMstr_RadioSetting_StatusResponse::~T_TunMstr_RadioSetting_StatusResponse() {
}

inline T_TunMstr_RadioSetting_StatusResponse& T_TunMstr_RadioSetting_StatusResponse::operator = (const T_TunMstr_RadioSetting_StatusResponse& rhs) {
    if( this != &rhs ) {
        if (rhs.hasRadioProfileSetting_Response()) {
            setRadioProfileSetting_Response(rhs.getRadioProfileSetting_Response());
        } else {
            clearRadioProfileSetting_Response();
        }
        if (rhs.hasRadioProfileSetting_ErrorCode()) {
            setRadioProfileSetting_ErrorCode(rhs.getRadioProfileSetting_ErrorCode());
        } else {
            clearRadioProfileSetting_ErrorCode();
        }
    }
    return *this;
}

inline bool T_TunMstr_RadioSetting_StatusResponse::operator == (const T_TunMstr_RadioSetting_StatusResponse& rhs) const {
    return (((!hasRadioProfileSetting_Response() && !rhs.hasRadioProfileSetting_Response()) || getRadioProfileSetting_Response() == rhs.getRadioProfileSetting_Response()) &&
        ((!hasRadioProfileSetting_ErrorCode() && !rhs.hasRadioProfileSetting_ErrorCode()) || getRadioProfileSetting_ErrorCode() == rhs.getRadioProfileSetting_ErrorCode()));
}

inline bool T_TunMstr_RadioSetting_StatusResponse::operator != (const T_TunMstr_RadioSetting_StatusResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TunMstr_RadioSetting_StatusResponse::operator < (const T_TunMstr_RadioSetting_StatusResponse& rhs) const {
    if (hasRadioProfileSetting_Response() || rhs.hasRadioProfileSetting_Response()) {
        if ((uint32)getRadioProfileSetting_Response() < (uint32)rhs.getRadioProfileSetting_Response()) return true;
        if ((uint32)getRadioProfileSetting_Response() > (uint32)rhs.getRadioProfileSetting_Response()) return false;
    }
    if (hasRadioProfileSetting_ErrorCode() || rhs.hasRadioProfileSetting_ErrorCode()) {
        if ((uint32)getRadioProfileSetting_ErrorCode() < (uint32)rhs.getRadioProfileSetting_ErrorCode()) return true;
        if ((uint32)getRadioProfileSetting_ErrorCode() > (uint32)rhs.getRadioProfileSetting_ErrorCode()) return false;
    }
    return false;
}

inline bool T_TunMstr_RadioSetting_StatusResponse::operator > (const T_TunMstr_RadioSetting_StatusResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TunMstr_RadioSetting_StatusResponse::clear() {
    clearRadioProfileSetting_Response();
    clearRadioProfileSetting_ErrorCode();
}

inline void T_TunMstr_RadioSetting_StatusResponse::clearRadioProfileSetting_Response() {
    if (hasRadioProfileSetting_Response()) {
         clear_has_RadioProfileSetting_Response();
        _RadioProfileSetting_Response = ::midw_tunermaster_fi_types::T_e8_TunMstr_RadioProfileSetting_Response__TUN_MSTR_RadioProfileSetting_Res_Succeed;
     }
}

inline bool T_TunMstr_RadioSetting_StatusResponse::hasRadioProfileSetting_Response () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_TunMstr_RadioProfileSetting_Response T_TunMstr_RadioSetting_StatusResponse::getRadioProfileSetting_Response () const {
    return _RadioProfileSetting_Response;
}

inline void T_TunMstr_RadioSetting_StatusResponse::setRadioProfileSetting_Response (T_e8_TunMstr_RadioProfileSetting_Response RadioProfileSetting_Response_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_TunMstr_RadioProfileSetting_Response_IsValid(RadioProfileSetting_Response_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", RadioProfileSetting_Response_, "T_e8_TunMstr_RadioProfileSetting_Response", "RadioProfileSetting_Response", "T_TunMstr_RadioSetting_StatusResponse");
    }
    set_has_RadioProfileSetting_Response();
    this->_RadioProfileSetting_Response = RadioProfileSetting_Response_;
}

inline void T_TunMstr_RadioSetting_StatusResponse::clearRadioProfileSetting_ErrorCode() {
    if (hasRadioProfileSetting_ErrorCode()) {
         clear_has_RadioProfileSetting_ErrorCode();
        _RadioProfileSetting_ErrorCode = ::midw_tunermaster_fi_types::T_e8_TunMstr_RadioProfileSetting_ErrorCode__TUN_MSTR_RadioProfileSetting_ErrorCode_BandNotSupported;
     }
}

inline bool T_TunMstr_RadioSetting_StatusResponse::hasRadioProfileSetting_ErrorCode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_TunMstr_RadioProfileSetting_ErrorCode T_TunMstr_RadioSetting_StatusResponse::getRadioProfileSetting_ErrorCode () const {
    return _RadioProfileSetting_ErrorCode;
}

inline void T_TunMstr_RadioSetting_StatusResponse::setRadioProfileSetting_ErrorCode (T_e8_TunMstr_RadioProfileSetting_ErrorCode RadioProfileSetting_ErrorCode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_TunMstr_RadioProfileSetting_ErrorCode_IsValid(RadioProfileSetting_ErrorCode_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", RadioProfileSetting_ErrorCode_, "T_e8_TunMstr_RadioProfileSetting_ErrorCode", "RadioProfileSetting_ErrorCode", "T_TunMstr_RadioSetting_StatusResponse");
    }
    set_has_RadioProfileSetting_ErrorCode();
    this->_RadioProfileSetting_ErrorCode = RadioProfileSetting_ErrorCode_;
}

inline void T_TunMstr_RadioSetting_StatusResponse::set_has_RadioProfileSetting_Response () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TunMstr_RadioSetting_StatusResponse::clear_has_RadioProfileSetting_Response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TunMstr_RadioSetting_StatusResponse::set_has_RadioProfileSetting_ErrorCode () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TunMstr_RadioSetting_StatusResponse::clear_has_RadioProfileSetting_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Tunmstr_RFAntenna::Tunmstr_RFAntenna ()  :
    _AntennaTest (::midw_tunermaster_fi_types::T_e8_AntennaTest__AMFM_Antenna1),
    _RFAntennaStatus (::midw_tunermaster_fi_types::T_e8_RFAntenna__TUN_MSTR_RF_ANTENNA_STATE_UNKNOWN),
    _ConnectionCurrent (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Tunmstr_RFAntenna::Tunmstr_RFAntenna (const Tunmstr_RFAntenna &rhs)  :
    _AntennaTest (::midw_tunermaster_fi_types::T_e8_AntennaTest__AMFM_Antenna1),
    _RFAntennaStatus (::midw_tunermaster_fi_types::T_e8_RFAntenna__TUN_MSTR_RF_ANTENNA_STATE_UNKNOWN),
    _ConnectionCurrent (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Tunmstr_RFAntenna::Tunmstr_RFAntenna (T_e8_AntennaTest AntennaTest_, T_e8_RFAntenna RFAntennaStatus_, uint8 ConnectionCurrent_)  :
    _AntennaTest (AntennaTest_),
    _RFAntennaStatus (RFAntennaStatus_),
    _ConnectionCurrent (ConnectionCurrent_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_AntennaTest_IsValid(AntennaTest_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", AntennaTest_, "T_e8_AntennaTest", "AntennaTest", "Tunmstr_RFAntenna");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_RFAntenna_IsValid(RFAntennaStatus_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", RFAntennaStatus_, "T_e8_RFAntenna", "RFAntennaStatus", "Tunmstr_RFAntenna");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Tunmstr_RFAntenna::~Tunmstr_RFAntenna() {
}

inline Tunmstr_RFAntenna& Tunmstr_RFAntenna::operator = (const Tunmstr_RFAntenna& rhs) {
    if( this != &rhs ) {
        if (rhs.hasAntennaTest()) {
            setAntennaTest(rhs.getAntennaTest());
        } else {
            clearAntennaTest();
        }
        if (rhs.hasRFAntennaStatus()) {
            setRFAntennaStatus(rhs.getRFAntennaStatus());
        } else {
            clearRFAntennaStatus();
        }
        if (rhs.hasConnectionCurrent()) {
            setConnectionCurrent(rhs.getConnectionCurrent());
        } else {
            clearConnectionCurrent();
        }
    }
    return *this;
}

inline bool Tunmstr_RFAntenna::operator == (const Tunmstr_RFAntenna& rhs) const {
    return (((!hasAntennaTest() && !rhs.hasAntennaTest()) || getAntennaTest() == rhs.getAntennaTest()) &&
        ((!hasRFAntennaStatus() && !rhs.hasRFAntennaStatus()) || getRFAntennaStatus() == rhs.getRFAntennaStatus()) &&
        ((!hasConnectionCurrent() && !rhs.hasConnectionCurrent()) || getConnectionCurrent() == rhs.getConnectionCurrent()));
}

inline bool Tunmstr_RFAntenna::operator != (const Tunmstr_RFAntenna& rhs) const {
    return ! (*this == rhs);
}

inline bool Tunmstr_RFAntenna::operator < (const Tunmstr_RFAntenna& rhs) const {
    if (hasAntennaTest() || rhs.hasAntennaTest()) {
        if ((uint32)getAntennaTest() < (uint32)rhs.getAntennaTest()) return true;
        if ((uint32)getAntennaTest() > (uint32)rhs.getAntennaTest()) return false;
    }
    if (hasRFAntennaStatus() || rhs.hasRFAntennaStatus()) {
        if ((uint32)getRFAntennaStatus() < (uint32)rhs.getRFAntennaStatus()) return true;
        if ((uint32)getRFAntennaStatus() > (uint32)rhs.getRFAntennaStatus()) return false;
    }
    if (hasConnectionCurrent() || rhs.hasConnectionCurrent()) {
        if (getConnectionCurrent() < rhs.getConnectionCurrent()) return true;
        if (getConnectionCurrent() > rhs.getConnectionCurrent()) return false;
    }
    return false;
}

inline bool Tunmstr_RFAntenna::operator > (const Tunmstr_RFAntenna& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Tunmstr_RFAntenna::clear() {
    clearAntennaTest();
    clearRFAntennaStatus();
    clearConnectionCurrent();
}

inline void Tunmstr_RFAntenna::clearAntennaTest() {
    if (hasAntennaTest()) {
         clear_has_AntennaTest();
        _AntennaTest = ::midw_tunermaster_fi_types::T_e8_AntennaTest__AMFM_Antenna1;
     }
}

inline bool Tunmstr_RFAntenna::hasAntennaTest () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_AntennaTest Tunmstr_RFAntenna::getAntennaTest () const {
    return _AntennaTest;
}

inline void Tunmstr_RFAntenna::setAntennaTest (T_e8_AntennaTest AntennaTest_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_AntennaTest_IsValid(AntennaTest_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", AntennaTest_, "T_e8_AntennaTest", "AntennaTest", "Tunmstr_RFAntenna");
    }
    set_has_AntennaTest();
    this->_AntennaTest = AntennaTest_;
}

inline void Tunmstr_RFAntenna::clearRFAntennaStatus() {
    if (hasRFAntennaStatus()) {
         clear_has_RFAntennaStatus();
        _RFAntennaStatus = ::midw_tunermaster_fi_types::T_e8_RFAntenna__TUN_MSTR_RF_ANTENNA_STATE_UNKNOWN;
     }
}

inline bool Tunmstr_RFAntenna::hasRFAntennaStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_RFAntenna Tunmstr_RFAntenna::getRFAntennaStatus () const {
    return _RFAntennaStatus;
}

inline void Tunmstr_RFAntenna::setRFAntennaStatus (T_e8_RFAntenna RFAntennaStatus_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_RFAntenna_IsValid(RFAntennaStatus_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", RFAntennaStatus_, "T_e8_RFAntenna", "RFAntennaStatus", "Tunmstr_RFAntenna");
    }
    set_has_RFAntennaStatus();
    this->_RFAntennaStatus = RFAntennaStatus_;
}

inline void Tunmstr_RFAntenna::clearConnectionCurrent() {
    if (hasConnectionCurrent()) {
         clear_has_ConnectionCurrent();
        _ConnectionCurrent = 0u;
     }
}

inline bool Tunmstr_RFAntenna::hasConnectionCurrent () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 Tunmstr_RFAntenna::getConnectionCurrent () const {
    return _ConnectionCurrent;
}

inline void Tunmstr_RFAntenna::setConnectionCurrent (uint8 ConnectionCurrent_) {
    set_has_ConnectionCurrent();
    this->_ConnectionCurrent = ConnectionCurrent_;
}

inline void Tunmstr_RFAntenna::set_has_AntennaTest () {
    _has_bits_[0] |= 1u << 0;
}

inline void Tunmstr_RFAntenna::clear_has_AntennaTest () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Tunmstr_RFAntenna::set_has_RFAntennaStatus () {
    _has_bits_[0] |= 1u << 1;
}

inline void Tunmstr_RFAntenna::clear_has_RFAntennaStatus () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Tunmstr_RFAntenna::set_has_ConnectionCurrent () {
    _has_bits_[0] |= 1u << 2;
}

inline void Tunmstr_RFAntenna::clear_has_ConnectionCurrent () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_SXMPresetListEntry::T_SXMPresetListEntry ()  :
    _ServiceID (0u),
    _ChannelID (0u),
    _ChannelNameAvail (false),
    _ChannelName (NULL),
    _ChannelActive (false),
    _ChnGraphicAvail (::midw_tunermaster_fi_types::T_e8_Graphics__GRAPHICS_NEEDS_NOREFRESH),
    _IsSmartFavorite (false),
    _IsLocked (false),
    _IsAvailable (false),
    _IsMature (false),
    _IsSkipped (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SXMPresetListEntry::T_SXMPresetListEntry (const T_SXMPresetListEntry &rhs)  :
    _ServiceID (0u),
    _ChannelID (0u),
    _ChannelNameAvail (false),
    _ChannelName (NULL),
    _ChannelActive (false),
    _ChnGraphicAvail (::midw_tunermaster_fi_types::T_e8_Graphics__GRAPHICS_NEEDS_NOREFRESH),
    _IsSmartFavorite (false),
    _IsLocked (false),
    _IsAvailable (false),
    _IsMature (false),
    _IsSkipped (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SXMPresetListEntry::T_SXMPresetListEntry (uint16 ServiceID_, uint16 ChannelID_, bool ChannelNameAvail_, const ::std::string& ChannelName_, bool ChannelActive_, T_e8_Graphics ChnGraphicAvail_, bool IsSmartFavorite_, bool IsLocked_, bool IsAvailable_, bool IsMature_, bool IsSkipped_)  :
    _ServiceID (ServiceID_),
    _ChannelID (ChannelID_),
    _ChannelNameAvail (ChannelNameAvail_),
    _ChannelName (new ::std::string(ChannelName_)),
    _ChannelActive (ChannelActive_),
    _ChnGraphicAvail (ChnGraphicAvail_),
    _IsSmartFavorite (IsSmartFavorite_),
    _IsLocked (IsLocked_),
    _IsAvailable (IsAvailable_),
    _IsMature (IsMature_),
    _IsSkipped (IsSkipped_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Graphics_IsValid(ChnGraphicAvail_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", ChnGraphicAvail_, "T_e8_Graphics", "ChnGraphicAvail", "T_SXMPresetListEntry");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SXMPresetListEntry::~T_SXMPresetListEntry() {
    delete _ChannelName;
}

inline T_SXMPresetListEntry& T_SXMPresetListEntry::operator = (const T_SXMPresetListEntry& rhs) {
    if( this != &rhs ) {
        if (rhs.hasServiceID()) {
            setServiceID(rhs.getServiceID());
        } else {
            clearServiceID();
        }
        if (rhs.hasChannelID()) {
            setChannelID(rhs.getChannelID());
        } else {
            clearChannelID();
        }
        if (rhs.hasChannelNameAvail()) {
            setChannelNameAvail(rhs.getChannelNameAvail());
        } else {
            clearChannelNameAvail();
        }
        if (rhs.hasChannelName()) {
            setChannelName(rhs.getChannelName());
        } else {
            clearChannelName();
        }
        if (rhs.hasChannelActive()) {
            setChannelActive(rhs.getChannelActive());
        } else {
            clearChannelActive();
        }
        if (rhs.hasChnGraphicAvail()) {
            setChnGraphicAvail(rhs.getChnGraphicAvail());
        } else {
            clearChnGraphicAvail();
        }
        if (rhs.hasIsSmartFavorite()) {
            setIsSmartFavorite(rhs.getIsSmartFavorite());
        } else {
            clearIsSmartFavorite();
        }
        if (rhs.hasIsLocked()) {
            setIsLocked(rhs.getIsLocked());
        } else {
            clearIsLocked();
        }
        if (rhs.hasIsAvailable()) {
            setIsAvailable(rhs.getIsAvailable());
        } else {
            clearIsAvailable();
        }
        if (rhs.hasIsMature()) {
            setIsMature(rhs.getIsMature());
        } else {
            clearIsMature();
        }
        if (rhs.hasIsSkipped()) {
            setIsSkipped(rhs.getIsSkipped());
        } else {
            clearIsSkipped();
        }
    }
    return *this;
}

inline bool T_SXMPresetListEntry::operator == (const T_SXMPresetListEntry& rhs) const {
    return (((!hasServiceID() && !rhs.hasServiceID()) || getServiceID() == rhs.getServiceID()) &&
        ((!hasChannelID() && !rhs.hasChannelID()) || getChannelID() == rhs.getChannelID()) &&
        ((!hasChannelNameAvail() && !rhs.hasChannelNameAvail()) || getChannelNameAvail() == rhs.getChannelNameAvail()) &&
        ((!hasChannelName() && !rhs.hasChannelName()) || getChannelName() == rhs.getChannelName()) &&
        ((!hasChannelActive() && !rhs.hasChannelActive()) || getChannelActive() == rhs.getChannelActive()) &&
        ((!hasChnGraphicAvail() && !rhs.hasChnGraphicAvail()) || getChnGraphicAvail() == rhs.getChnGraphicAvail()) &&
        ((!hasIsSmartFavorite() && !rhs.hasIsSmartFavorite()) || getIsSmartFavorite() == rhs.getIsSmartFavorite()) &&
        ((!hasIsLocked() && !rhs.hasIsLocked()) || getIsLocked() == rhs.getIsLocked()) &&
        ((!hasIsAvailable() && !rhs.hasIsAvailable()) || getIsAvailable() == rhs.getIsAvailable()) &&
        ((!hasIsMature() && !rhs.hasIsMature()) || getIsMature() == rhs.getIsMature()) &&
        ((!hasIsSkipped() && !rhs.hasIsSkipped()) || getIsSkipped() == rhs.getIsSkipped()));
}

inline bool T_SXMPresetListEntry::operator != (const T_SXMPresetListEntry& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SXMPresetListEntry::operator < (const T_SXMPresetListEntry& rhs) const {
    if (hasServiceID() || rhs.hasServiceID()) {
        if (getServiceID() < rhs.getServiceID()) return true;
        if (getServiceID() > rhs.getServiceID()) return false;
    }
    if (hasChannelID() || rhs.hasChannelID()) {
        if (getChannelID() < rhs.getChannelID()) return true;
        if (getChannelID() > rhs.getChannelID()) return false;
    }
    if (hasChannelNameAvail() || rhs.hasChannelNameAvail()) {
        if (getChannelNameAvail() < rhs.getChannelNameAvail()) return true;
        if (getChannelNameAvail() > rhs.getChannelNameAvail()) return false;
    }
    if (hasChannelName() || rhs.hasChannelName()) {
        if (getChannelName() < rhs.getChannelName()) return true;
        if (getChannelName() > rhs.getChannelName()) return false;
    }
    if (hasChannelActive() || rhs.hasChannelActive()) {
        if (getChannelActive() < rhs.getChannelActive()) return true;
        if (getChannelActive() > rhs.getChannelActive()) return false;
    }
    if (hasChnGraphicAvail() || rhs.hasChnGraphicAvail()) {
        if ((uint32)getChnGraphicAvail() < (uint32)rhs.getChnGraphicAvail()) return true;
        if ((uint32)getChnGraphicAvail() > (uint32)rhs.getChnGraphicAvail()) return false;
    }
    if (hasIsSmartFavorite() || rhs.hasIsSmartFavorite()) {
        if (getIsSmartFavorite() < rhs.getIsSmartFavorite()) return true;
        if (getIsSmartFavorite() > rhs.getIsSmartFavorite()) return false;
    }
    if (hasIsLocked() || rhs.hasIsLocked()) {
        if (getIsLocked() < rhs.getIsLocked()) return true;
        if (getIsLocked() > rhs.getIsLocked()) return false;
    }
    if (hasIsAvailable() || rhs.hasIsAvailable()) {
        if (getIsAvailable() < rhs.getIsAvailable()) return true;
        if (getIsAvailable() > rhs.getIsAvailable()) return false;
    }
    if (hasIsMature() || rhs.hasIsMature()) {
        if (getIsMature() < rhs.getIsMature()) return true;
        if (getIsMature() > rhs.getIsMature()) return false;
    }
    if (hasIsSkipped() || rhs.hasIsSkipped()) {
        if (getIsSkipped() < rhs.getIsSkipped()) return true;
        if (getIsSkipped() > rhs.getIsSkipped()) return false;
    }
    return false;
}

inline bool T_SXMPresetListEntry::operator > (const T_SXMPresetListEntry& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SXMPresetListEntry::clear() {
    clearServiceID();
    clearChannelID();
    clearChannelNameAvail();
    clearChannelName();
    clearChannelActive();
    clearChnGraphicAvail();
    clearIsSmartFavorite();
    clearIsLocked();
    clearIsAvailable();
    clearIsMature();
    clearIsSkipped();
}

inline void T_SXMPresetListEntry::clearServiceID() {
    if (hasServiceID()) {
         clear_has_ServiceID();
        _ServiceID = 0u;
     }
}

inline bool T_SXMPresetListEntry::hasServiceID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_SXMPresetListEntry::getServiceID () const {
    return _ServiceID;
}

inline void T_SXMPresetListEntry::setServiceID (uint16 ServiceID_) {
    set_has_ServiceID();
    this->_ServiceID = ServiceID_;
}

inline void T_SXMPresetListEntry::clearChannelID() {
    if (hasChannelID()) {
         clear_has_ChannelID();
        _ChannelID = 0u;
     }
}

inline bool T_SXMPresetListEntry::hasChannelID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_SXMPresetListEntry::getChannelID () const {
    return _ChannelID;
}

inline void T_SXMPresetListEntry::setChannelID (uint16 ChannelID_) {
    set_has_ChannelID();
    this->_ChannelID = ChannelID_;
}

inline void T_SXMPresetListEntry::clearChannelNameAvail() {
    if (hasChannelNameAvail()) {
         clear_has_ChannelNameAvail();
        _ChannelNameAvail = false;
     }
}

inline bool T_SXMPresetListEntry::hasChannelNameAvail () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool T_SXMPresetListEntry::getChannelNameAvail () const {
    return _ChannelNameAvail;
}

inline void T_SXMPresetListEntry::setChannelNameAvail (bool ChannelNameAvail_) {
    set_has_ChannelNameAvail();
    this->_ChannelNameAvail = ChannelNameAvail_;
}

inline void T_SXMPresetListEntry::clearChannelName() {
    if (hasChannelName()) {
         clear_has_ChannelName();
        if (_ChannelName != NULL) {
            _ChannelName->clear();
        }
     }
}

inline bool T_SXMPresetListEntry::hasChannelName () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_SXMPresetListEntry::getChannelName () const {
    if (_ChannelName == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_ChannelName;
}

inline ::std::string& T_SXMPresetListEntry::getChannelNameMutable () {
    set_has_ChannelName();
    if (_ChannelName == NULL) {
        _ChannelName = new ::std::string ();
        CHECK_ALLOCATION( _ChannelName );
    }
    return *_ChannelName;
}

inline void T_SXMPresetListEntry::setChannelName (const ::std::string& ChannelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelName();
    if (this->_ChannelName == NULL) {
        this->_ChannelName = new ::std::string (ChannelName_);
        CHECK_ALLOCATION( this->_ChannelName );
    } else {
        *this->_ChannelName = ChannelName_;
    }
}

inline void T_SXMPresetListEntry::setChannelName (const char* ChannelName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ChannelName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelName();
    if (this->_ChannelName == NULL) {
        this->_ChannelName = new ::std::string (ChannelName_);
        CHECK_ALLOCATION( this->_ChannelName );
    } else {
        this->_ChannelName->assign(ChannelName_);
    }
}

inline void T_SXMPresetListEntry::setChannelName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ChannelName();
    if (this->_ChannelName == NULL) {
        this->_ChannelName = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_ChannelName );
    } else {
        this->_ChannelName->assign(value, size);
    }
}

inline ::std::string* T_SXMPresetListEntry::releaseChannelName() {
    clear_has_ChannelName();
    ::std::string* temp = _ChannelName;
    this->_ChannelName = NULL;
    return temp;
}

inline void T_SXMPresetListEntry::replaceChannelName (::std::string* ChannelName_) {
    set_has_ChannelName();
    if (this->_ChannelName != ChannelName_) {
        if (this->_ChannelName != NULL) {
            delete this->_ChannelName;
        }
        this->_ChannelName = ChannelName_;
    }
}

inline void T_SXMPresetListEntry::clearChannelActive() {
    if (hasChannelActive()) {
         clear_has_ChannelActive();
        _ChannelActive = false;
     }
}

inline bool T_SXMPresetListEntry::hasChannelActive () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool T_SXMPresetListEntry::getChannelActive () const {
    return _ChannelActive;
}

inline void T_SXMPresetListEntry::setChannelActive (bool ChannelActive_) {
    set_has_ChannelActive();
    this->_ChannelActive = ChannelActive_;
}

inline void T_SXMPresetListEntry::clearChnGraphicAvail() {
    if (hasChnGraphicAvail()) {
         clear_has_ChnGraphicAvail();
        _ChnGraphicAvail = ::midw_tunermaster_fi_types::T_e8_Graphics__GRAPHICS_NEEDS_NOREFRESH;
     }
}

inline bool T_SXMPresetListEntry::hasChnGraphicAvail () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline T_e8_Graphics T_SXMPresetListEntry::getChnGraphicAvail () const {
    return _ChnGraphicAvail;
}

inline void T_SXMPresetListEntry::setChnGraphicAvail (T_e8_Graphics ChnGraphicAvail_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Graphics_IsValid(ChnGraphicAvail_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", ChnGraphicAvail_, "T_e8_Graphics", "ChnGraphicAvail", "T_SXMPresetListEntry");
    }
    set_has_ChnGraphicAvail();
    this->_ChnGraphicAvail = ChnGraphicAvail_;
}

inline void T_SXMPresetListEntry::clearIsSmartFavorite() {
    if (hasIsSmartFavorite()) {
         clear_has_IsSmartFavorite();
        _IsSmartFavorite = false;
     }
}

inline bool T_SXMPresetListEntry::hasIsSmartFavorite () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool T_SXMPresetListEntry::getIsSmartFavorite () const {
    return _IsSmartFavorite;
}

inline void T_SXMPresetListEntry::setIsSmartFavorite (bool IsSmartFavorite_) {
    set_has_IsSmartFavorite();
    this->_IsSmartFavorite = IsSmartFavorite_;
}

inline void T_SXMPresetListEntry::clearIsLocked() {
    if (hasIsLocked()) {
         clear_has_IsLocked();
        _IsLocked = false;
     }
}

inline bool T_SXMPresetListEntry::hasIsLocked () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline bool T_SXMPresetListEntry::getIsLocked () const {
    return _IsLocked;
}

inline void T_SXMPresetListEntry::setIsLocked (bool IsLocked_) {
    set_has_IsLocked();
    this->_IsLocked = IsLocked_;
}

inline void T_SXMPresetListEntry::clearIsAvailable() {
    if (hasIsAvailable()) {
         clear_has_IsAvailable();
        _IsAvailable = false;
     }
}

inline bool T_SXMPresetListEntry::hasIsAvailable () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline bool T_SXMPresetListEntry::getIsAvailable () const {
    return _IsAvailable;
}

inline void T_SXMPresetListEntry::setIsAvailable (bool IsAvailable_) {
    set_has_IsAvailable();
    this->_IsAvailable = IsAvailable_;
}

inline void T_SXMPresetListEntry::clearIsMature() {
    if (hasIsMature()) {
         clear_has_IsMature();
        _IsMature = false;
     }
}

inline bool T_SXMPresetListEntry::hasIsMature () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline bool T_SXMPresetListEntry::getIsMature () const {
    return _IsMature;
}

inline void T_SXMPresetListEntry::setIsMature (bool IsMature_) {
    set_has_IsMature();
    this->_IsMature = IsMature_;
}

inline void T_SXMPresetListEntry::clearIsSkipped() {
    if (hasIsSkipped()) {
         clear_has_IsSkipped();
        _IsSkipped = false;
     }
}

inline bool T_SXMPresetListEntry::hasIsSkipped () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline bool T_SXMPresetListEntry::getIsSkipped () const {
    return _IsSkipped;
}

inline void T_SXMPresetListEntry::setIsSkipped (bool IsSkipped_) {
    set_has_IsSkipped();
    this->_IsSkipped = IsSkipped_;
}

inline void T_SXMPresetListEntry::set_has_ServiceID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SXMPresetListEntry::clear_has_ServiceID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SXMPresetListEntry::set_has_ChannelID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SXMPresetListEntry::clear_has_ChannelID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SXMPresetListEntry::set_has_ChannelNameAvail () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SXMPresetListEntry::clear_has_ChannelNameAvail () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SXMPresetListEntry::set_has_ChannelName () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SXMPresetListEntry::clear_has_ChannelName () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_SXMPresetListEntry::set_has_ChannelActive () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_SXMPresetListEntry::clear_has_ChannelActive () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_SXMPresetListEntry::set_has_ChnGraphicAvail () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_SXMPresetListEntry::clear_has_ChnGraphicAvail () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_SXMPresetListEntry::set_has_IsSmartFavorite () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_SXMPresetListEntry::clear_has_IsSmartFavorite () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_SXMPresetListEntry::set_has_IsLocked () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_SXMPresetListEntry::clear_has_IsLocked () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_SXMPresetListEntry::set_has_IsAvailable () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_SXMPresetListEntry::clear_has_IsAvailable () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_SXMPresetListEntry::set_has_IsMature () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_SXMPresetListEntry::clear_has_IsMature () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_SXMPresetListEntry::set_has_IsSkipped () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_SXMPresetListEntry::clear_has_IsSkipped () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline  T_SXMChannelAttributes::T_SXMChannelAttributes ()  :
    _Logo (NULL),
    _Name (NULL),
    _PDT (NULL),
    _IsLocked (false),
    _ContextualBanner (NULL),
    _ChannelNumber (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SXMChannelAttributes::T_SXMChannelAttributes (const T_SXMChannelAttributes &rhs)  :
    _Logo (NULL),
    _Name (NULL),
    _PDT (NULL),
    _IsLocked (false),
    _ContextualBanner (NULL),
    _ChannelNumber (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SXMChannelAttributes::T_SXMChannelAttributes (const ::std::vector< uint8 >& Logo_, const ::std::string& Name_, const ::std::string& PDT_, bool IsLocked_, const ::std::string& ContextualBanner_, uint32 ChannelNumber_)  :
    _Logo (new ::std::vector< uint8 >(Logo_)),
    _Name (new ::std::string(Name_)),
    _PDT (new ::std::string(PDT_)),
    _IsLocked (IsLocked_),
    _ContextualBanner (new ::std::string(ContextualBanner_)),
    _ChannelNumber (ChannelNumber_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PDT_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ContextualBanner_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SXMChannelAttributes::~T_SXMChannelAttributes() {
    delete _Logo;
    delete _Name;
    delete _PDT;
    delete _ContextualBanner;
}

inline T_SXMChannelAttributes& T_SXMChannelAttributes::operator = (const T_SXMChannelAttributes& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLogo()) {
            setLogo(rhs.getLogo());
        } else {
            clearLogo();
        }
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasPDT()) {
            setPDT(rhs.getPDT());
        } else {
            clearPDT();
        }
        if (rhs.hasIsLocked()) {
            setIsLocked(rhs.getIsLocked());
        } else {
            clearIsLocked();
        }
        if (rhs.hasContextualBanner()) {
            setContextualBanner(rhs.getContextualBanner());
        } else {
            clearContextualBanner();
        }
        if (rhs.hasChannelNumber()) {
            setChannelNumber(rhs.getChannelNumber());
        } else {
            clearChannelNumber();
        }
    }
    return *this;
}

inline bool T_SXMChannelAttributes::operator == (const T_SXMChannelAttributes& rhs) const {
    return (((!hasLogo() && !rhs.hasLogo()) || getLogo() == rhs.getLogo()) &&
        ((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasPDT() && !rhs.hasPDT()) || getPDT() == rhs.getPDT()) &&
        ((!hasIsLocked() && !rhs.hasIsLocked()) || getIsLocked() == rhs.getIsLocked()) &&
        ((!hasContextualBanner() && !rhs.hasContextualBanner()) || getContextualBanner() == rhs.getContextualBanner()) &&
        ((!hasChannelNumber() && !rhs.hasChannelNumber()) || getChannelNumber() == rhs.getChannelNumber()));
}

inline bool T_SXMChannelAttributes::operator != (const T_SXMChannelAttributes& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SXMChannelAttributes::operator < (const T_SXMChannelAttributes& rhs) const {
    if (hasLogo() || rhs.hasLogo()) {
        if (getLogo() < rhs.getLogo()) return true;
        if (getLogo() > rhs.getLogo()) return false;
    }
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasPDT() || rhs.hasPDT()) {
        if (getPDT() < rhs.getPDT()) return true;
        if (getPDT() > rhs.getPDT()) return false;
    }
    if (hasIsLocked() || rhs.hasIsLocked()) {
        if (getIsLocked() < rhs.getIsLocked()) return true;
        if (getIsLocked() > rhs.getIsLocked()) return false;
    }
    if (hasContextualBanner() || rhs.hasContextualBanner()) {
        if (getContextualBanner() < rhs.getContextualBanner()) return true;
        if (getContextualBanner() > rhs.getContextualBanner()) return false;
    }
    if (hasChannelNumber() || rhs.hasChannelNumber()) {
        if (getChannelNumber() < rhs.getChannelNumber()) return true;
        if (getChannelNumber() > rhs.getChannelNumber()) return false;
    }
    return false;
}

inline bool T_SXMChannelAttributes::operator > (const T_SXMChannelAttributes& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SXMChannelAttributes::clear() {
    clearLogo();
    clearName();
    clearPDT();
    clearIsLocked();
    clearContextualBanner();
    clearChannelNumber();
}

inline void T_SXMChannelAttributes::clearLogo() {
    if (hasLogo()) {
         clear_has_Logo();
        if (_Logo != NULL) {
            _Logo->clear();
        }
     }
}

inline bool T_SXMChannelAttributes::hasLogo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& T_SXMChannelAttributes::getLogo () const {
    if (_Logo == NULL) {
        return getUint8List_DefaultInstance();
    }
    return *_Logo;
}

inline ::std::vector< uint8 >& T_SXMChannelAttributes::getLogoMutable () {
    set_has_Logo();
    if (_Logo == NULL) {
        _Logo = new ::std::vector< uint8 > ();
        CHECK_ALLOCATION( _Logo );
    }
    return *_Logo;
}

inline void T_SXMChannelAttributes::setLogo (const ::std::vector< uint8 >& Logo_) {
    set_has_Logo();
    if (this->_Logo == NULL) {
        this->_Logo = new ::std::vector< uint8 > (Logo_);
        CHECK_ALLOCATION( this->_Logo );
    } else {
        *this->_Logo = Logo_;
    }
}

inline ::std::vector< uint8 >* T_SXMChannelAttributes::releaseLogo() {
    clear_has_Logo();
    ::std::vector< uint8 >* temp = _Logo;
    this->_Logo = NULL;
    return temp;
}

inline void T_SXMChannelAttributes::replaceLogo (::std::vector< uint8 >* Logo_) {
    set_has_Logo();
    if (this->_Logo != Logo_) {
        if (this->_Logo != NULL) {
            delete this->_Logo;
        }
        this->_Logo = Logo_;
    }
}

inline void T_SXMChannelAttributes::clearName() {
    if (hasName()) {
         clear_has_Name();
        if (_Name != NULL) {
            _Name->clear();
        }
     }
}

inline bool T_SXMChannelAttributes::hasName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_SXMChannelAttributes::getName () const {
    if (_Name == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_Name;
}

inline ::std::string& T_SXMChannelAttributes::getNameMutable () {
    set_has_Name();
    if (_Name == NULL) {
        _Name = new ::std::string ();
        CHECK_ALLOCATION( _Name );
    }
    return *_Name;
}

inline void T_SXMChannelAttributes::setName (const ::std::string& Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    if (this->_Name == NULL) {
        this->_Name = new ::std::string (Name_);
        CHECK_ALLOCATION( this->_Name );
    } else {
        *this->_Name = Name_;
    }
}

inline void T_SXMChannelAttributes::setName (const char* Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    if (this->_Name == NULL) {
        this->_Name = new ::std::string (Name_);
        CHECK_ALLOCATION( this->_Name );
    } else {
        this->_Name->assign(Name_);
    }
}

inline void T_SXMChannelAttributes::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    if (this->_Name == NULL) {
        this->_Name = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_Name );
    } else {
        this->_Name->assign(value, size);
    }
}

inline ::std::string* T_SXMChannelAttributes::releaseName() {
    clear_has_Name();
    ::std::string* temp = _Name;
    this->_Name = NULL;
    return temp;
}

inline void T_SXMChannelAttributes::replaceName (::std::string* Name_) {
    set_has_Name();
    if (this->_Name != Name_) {
        if (this->_Name != NULL) {
            delete this->_Name;
        }
        this->_Name = Name_;
    }
}

inline void T_SXMChannelAttributes::clearPDT() {
    if (hasPDT()) {
         clear_has_PDT();
        if (_PDT != NULL) {
            _PDT->clear();
        }
     }
}

inline bool T_SXMChannelAttributes::hasPDT () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_SXMChannelAttributes::getPDT () const {
    if (_PDT == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_PDT;
}

inline ::std::string& T_SXMChannelAttributes::getPDTMutable () {
    set_has_PDT();
    if (_PDT == NULL) {
        _PDT = new ::std::string ();
        CHECK_ALLOCATION( _PDT );
    }
    return *_PDT;
}

inline void T_SXMChannelAttributes::setPDT (const ::std::string& PDT_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PDT_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PDT();
    if (this->_PDT == NULL) {
        this->_PDT = new ::std::string (PDT_);
        CHECK_ALLOCATION( this->_PDT );
    } else {
        *this->_PDT = PDT_;
    }
}

inline void T_SXMChannelAttributes::setPDT (const char* PDT_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PDT_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PDT();
    if (this->_PDT == NULL) {
        this->_PDT = new ::std::string (PDT_);
        CHECK_ALLOCATION( this->_PDT );
    } else {
        this->_PDT->assign(PDT_);
    }
}

inline void T_SXMChannelAttributes::setPDT (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PDT();
    if (this->_PDT == NULL) {
        this->_PDT = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_PDT );
    } else {
        this->_PDT->assign(value, size);
    }
}

inline ::std::string* T_SXMChannelAttributes::releasePDT() {
    clear_has_PDT();
    ::std::string* temp = _PDT;
    this->_PDT = NULL;
    return temp;
}

inline void T_SXMChannelAttributes::replacePDT (::std::string* PDT_) {
    set_has_PDT();
    if (this->_PDT != PDT_) {
        if (this->_PDT != NULL) {
            delete this->_PDT;
        }
        this->_PDT = PDT_;
    }
}

inline void T_SXMChannelAttributes::clearIsLocked() {
    if (hasIsLocked()) {
         clear_has_IsLocked();
        _IsLocked = false;
     }
}

inline bool T_SXMChannelAttributes::hasIsLocked () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool T_SXMChannelAttributes::getIsLocked () const {
    return _IsLocked;
}

inline void T_SXMChannelAttributes::setIsLocked (bool IsLocked_) {
    set_has_IsLocked();
    this->_IsLocked = IsLocked_;
}

inline void T_SXMChannelAttributes::clearContextualBanner() {
    if (hasContextualBanner()) {
         clear_has_ContextualBanner();
        if (_ContextualBanner != NULL) {
            _ContextualBanner->clear();
        }
     }
}

inline bool T_SXMChannelAttributes::hasContextualBanner () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_SXMChannelAttributes::getContextualBanner () const {
    if (_ContextualBanner == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_ContextualBanner;
}

inline ::std::string& T_SXMChannelAttributes::getContextualBannerMutable () {
    set_has_ContextualBanner();
    if (_ContextualBanner == NULL) {
        _ContextualBanner = new ::std::string ();
        CHECK_ALLOCATION( _ContextualBanner );
    }
    return *_ContextualBanner;
}

inline void T_SXMChannelAttributes::setContextualBanner (const ::std::string& ContextualBanner_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ContextualBanner_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ContextualBanner();
    if (this->_ContextualBanner == NULL) {
        this->_ContextualBanner = new ::std::string (ContextualBanner_);
        CHECK_ALLOCATION( this->_ContextualBanner );
    } else {
        *this->_ContextualBanner = ContextualBanner_;
    }
}

inline void T_SXMChannelAttributes::setContextualBanner (const char* ContextualBanner_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ContextualBanner_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ContextualBanner();
    if (this->_ContextualBanner == NULL) {
        this->_ContextualBanner = new ::std::string (ContextualBanner_);
        CHECK_ALLOCATION( this->_ContextualBanner );
    } else {
        this->_ContextualBanner->assign(ContextualBanner_);
    }
}

inline void T_SXMChannelAttributes::setContextualBanner (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ContextualBanner();
    if (this->_ContextualBanner == NULL) {
        this->_ContextualBanner = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_ContextualBanner );
    } else {
        this->_ContextualBanner->assign(value, size);
    }
}

inline ::std::string* T_SXMChannelAttributes::releaseContextualBanner() {
    clear_has_ContextualBanner();
    ::std::string* temp = _ContextualBanner;
    this->_ContextualBanner = NULL;
    return temp;
}

inline void T_SXMChannelAttributes::replaceContextualBanner (::std::string* ContextualBanner_) {
    set_has_ContextualBanner();
    if (this->_ContextualBanner != ContextualBanner_) {
        if (this->_ContextualBanner != NULL) {
            delete this->_ContextualBanner;
        }
        this->_ContextualBanner = ContextualBanner_;
    }
}

inline void T_SXMChannelAttributes::clearChannelNumber() {
    if (hasChannelNumber()) {
         clear_has_ChannelNumber();
        _ChannelNumber = 0u;
     }
}

inline bool T_SXMChannelAttributes::hasChannelNumber () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint32 T_SXMChannelAttributes::getChannelNumber () const {
    return _ChannelNumber;
}

inline void T_SXMChannelAttributes::setChannelNumber (uint32 ChannelNumber_) {
    set_has_ChannelNumber();
    this->_ChannelNumber = ChannelNumber_;
}

inline void T_SXMChannelAttributes::set_has_Logo () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SXMChannelAttributes::clear_has_Logo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SXMChannelAttributes::set_has_Name () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SXMChannelAttributes::clear_has_Name () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SXMChannelAttributes::set_has_PDT () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SXMChannelAttributes::clear_has_PDT () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SXMChannelAttributes::set_has_IsLocked () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SXMChannelAttributes::clear_has_IsLocked () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_SXMChannelAttributes::set_has_ContextualBanner () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_SXMChannelAttributes::clear_has_ContextualBanner () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_SXMChannelAttributes::set_has_ChannelNumber () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_SXMChannelAttributes::clear_has_ChannelNumber () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  T_PresetList::T_PresetList ()  :
    _List (::midw_tunermaster_fi_types::T_e8_List__BANK_FM1),
    _Band (::midw_tunermaster_fi_types::T_e8_Band__TUN_MSTR_BAND_FM),
    _Element_ID (0u),
    _Frequency (0u),
    _PSName (NULL),
    _u8TpTmcInfo (0u),
    _PTY (0u),
    _EnsembleName (NULL),
    _Frequency_Label (NULL),
    _StationLogo (NULL),
    _u32HDStationId (0u),
    _sHDCallSign (NULL),
    _e8HDAudioProgram (::midw_tunermaster_fi_types::T_e8_HDAudioProgram__TUN_MSTR_AUDIO_PROGRAM_ONE),
    _u32DRMServiceId (0u),
    _sDRMServiceLabel (NULL),
    _u8DRMServiceShortId (0u),
    _e8Modulation (::midw_tunermaster_fi_types::T_e8_ModulationType__TUN_MSTR_MODULATION_ANALOG),
    _u32HDStationId_DRMServiceId (0u),
    _e8HDTextEncoding (::midw_tunermaster_fi_types::T_e8_HDTextEncoding__TUN_MSTR_ISO_IEC_8859_1_1998),
    _sHDCallSign_DRMServiceLabel (NULL),
    _u8HDStationGenre_DRMPty (0u),
    _u8HDAudioProgram_DRMShortID (0u),
    _SXMSMSlib_PresetListEntry (NULL),
    _Key (NULL),
    _PresetType (::midw_tunermaster_fi_types::T_e8_PresetType__Invalid),
    _SXM360L_PresetListEntry (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_PresetList::T_PresetList (const T_PresetList &rhs)  :
    _List (::midw_tunermaster_fi_types::T_e8_List__BANK_FM1),
    _Band (::midw_tunermaster_fi_types::T_e8_Band__TUN_MSTR_BAND_FM),
    _Element_ID (0u),
    _Frequency (0u),
    _PSName (NULL),
    _u8TpTmcInfo (0u),
    _PTY (0u),
    _EnsembleName (NULL),
    _Frequency_Label (NULL),
    _StationLogo (NULL),
    _u32HDStationId (0u),
    _sHDCallSign (NULL),
    _e8HDAudioProgram (::midw_tunermaster_fi_types::T_e8_HDAudioProgram__TUN_MSTR_AUDIO_PROGRAM_ONE),
    _u32DRMServiceId (0u),
    _sDRMServiceLabel (NULL),
    _u8DRMServiceShortId (0u),
    _e8Modulation (::midw_tunermaster_fi_types::T_e8_ModulationType__TUN_MSTR_MODULATION_ANALOG),
    _u32HDStationId_DRMServiceId (0u),
    _e8HDTextEncoding (::midw_tunermaster_fi_types::T_e8_HDTextEncoding__TUN_MSTR_ISO_IEC_8859_1_1998),
    _sHDCallSign_DRMServiceLabel (NULL),
    _u8HDStationGenre_DRMPty (0u),
    _u8HDAudioProgram_DRMShortID (0u),
    _SXMSMSlib_PresetListEntry (NULL),
    _Key (NULL),
    _PresetType (::midw_tunermaster_fi_types::T_e8_PresetType__Invalid),
    _SXM360L_PresetListEntry (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_PresetList::T_PresetList (T_e8_List List_, T_e8_Band Band_, uint8 Element_ID_, uint32 Frequency_, const ::std::string& PSName_, uint8 u8TpTmcInfo_, uint32 PTY_, const ::std::string& EnsembleName_, const ::std::string& Frequency_Label_, const ::std::string& StationLogo_, uint32 u32HDStationId_, const ::std::string& sHDCallSign_, T_e8_HDAudioProgram e8HDAudioProgram_, uint32 u32DRMServiceId_, const ::std::string& sDRMServiceLabel_, uint8 u8DRMServiceShortId_, T_e8_ModulationType e8Modulation_, uint32 u32HDStationId_DRMServiceId_, T_e8_HDTextEncoding e8HDTextEncoding_, const ::std::string& sHDCallSign_DRMServiceLabel_, uint8 u8HDStationGenre_DRMPty_, uint8 u8HDAudioProgram_DRMShortID_, const T_SXMPresetListEntry& SXMSMSlib_PresetListEntry_, const ::std::string& Key_, T_e8_PresetType PresetType_, const T_SXMChannelAttributes& SXM360L_PresetListEntry_)  :
    _List (List_),
    _Band (Band_),
    _Element_ID (Element_ID_),
    _Frequency (Frequency_),
    _PSName (new ::std::string(PSName_)),
    _u8TpTmcInfo (u8TpTmcInfo_),
    _PTY (PTY_),
    _EnsembleName (new ::std::string(EnsembleName_)),
    _Frequency_Label (new ::std::string(Frequency_Label_)),
    _StationLogo (new ::std::string(StationLogo_)),
    _u32HDStationId (u32HDStationId_),
    _sHDCallSign (new ::std::string(sHDCallSign_)),
    _e8HDAudioProgram (e8HDAudioProgram_),
    _u32DRMServiceId (u32DRMServiceId_),
    _sDRMServiceLabel (new ::std::string(sDRMServiceLabel_)),
    _u8DRMServiceShortId (u8DRMServiceShortId_),
    _e8Modulation (e8Modulation_),
    _u32HDStationId_DRMServiceId (u32HDStationId_DRMServiceId_),
    _e8HDTextEncoding (e8HDTextEncoding_),
    _sHDCallSign_DRMServiceLabel (new ::std::string(sHDCallSign_DRMServiceLabel_)),
    _u8HDStationGenre_DRMPty (u8HDStationGenre_DRMPty_),
    _u8HDAudioProgram_DRMShortID (u8HDAudioProgram_DRMShortID_),
    _SXMSMSlib_PresetListEntry (new T_SXMPresetListEntry(SXMSMSlib_PresetListEntry_)),
    _Key (new ::std::string(Key_)),
    _PresetType (PresetType_),
    _SXM360L_PresetListEntry (new T_SXMChannelAttributes(SXM360L_PresetListEntry_))
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_List_IsValid(List_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", List_, "T_e8_List", "List", "T_PresetList");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Band_IsValid(Band_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Band_, "T_e8_Band", "Band", "T_PresetList");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PSName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (EnsembleName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Frequency_Label_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StationLogo_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sHDCallSign_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_HDAudioProgram_IsValid(e8HDAudioProgram_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8HDAudioProgram_, "T_e8_HDAudioProgram", "e8HDAudioProgram", "T_PresetList");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDRMServiceLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_ModulationType_IsValid(e8Modulation_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Modulation_, "T_e8_ModulationType", "e8Modulation", "T_PresetList");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_HDTextEncoding_IsValid(e8HDTextEncoding_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8HDTextEncoding_, "T_e8_HDTextEncoding", "e8HDTextEncoding", "T_PresetList");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sHDCallSign_DRMServiceLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Key_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_PresetType_IsValid(PresetType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", PresetType_, "T_e8_PresetType", "PresetType", "T_PresetList");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_PresetList::~T_PresetList() {
    delete _PSName;
    delete _EnsembleName;
    delete _Frequency_Label;
    delete _StationLogo;
    delete _sHDCallSign;
    delete _sDRMServiceLabel;
    delete _sHDCallSign_DRMServiceLabel;
    delete _SXMSMSlib_PresetListEntry;
    delete _Key;
    delete _SXM360L_PresetListEntry;
}

inline T_PresetList& T_PresetList::operator = (const T_PresetList& rhs) {
    if( this != &rhs ) {
        if (rhs.hasList()) {
            setList(rhs.getList());
        } else {
            clearList();
        }
        if (rhs.hasBand()) {
            setBand(rhs.getBand());
        } else {
            clearBand();
        }
        if (rhs.hasElement_ID()) {
            setElement_ID(rhs.getElement_ID());
        } else {
            clearElement_ID();
        }
        if (rhs.hasFrequency()) {
            setFrequency(rhs.getFrequency());
        } else {
            clearFrequency();
        }
        if (rhs.hasPSName()) {
            setPSName(rhs.getPSName());
        } else {
            clearPSName();
        }
        if (rhs.hasU8TpTmcInfo()) {
            setU8TpTmcInfo(rhs.getU8TpTmcInfo());
        } else {
            clearU8TpTmcInfo();
        }
        if (rhs.hasPTY()) {
            setPTY(rhs.getPTY());
        } else {
            clearPTY();
        }
        if (rhs.hasEnsembleName()) {
            setEnsembleName(rhs.getEnsembleName());
        } else {
            clearEnsembleName();
        }
        if (rhs.hasFrequency_Label()) {
            setFrequency_Label(rhs.getFrequency_Label());
        } else {
            clearFrequency_Label();
        }
        if (rhs.hasStationLogo()) {
            setStationLogo(rhs.getStationLogo());
        } else {
            clearStationLogo();
        }
        if (rhs.hasU32HDStationId()) {
            setU32HDStationId(rhs.getU32HDStationId());
        } else {
            clearU32HDStationId();
        }
        if (rhs.hasSHDCallSign()) {
            setSHDCallSign(rhs.getSHDCallSign());
        } else {
            clearSHDCallSign();
        }
        if (rhs.hasE8HDAudioProgram()) {
            setE8HDAudioProgram(rhs.getE8HDAudioProgram());
        } else {
            clearE8HDAudioProgram();
        }
        if (rhs.hasU32DRMServiceId()) {
            setU32DRMServiceId(rhs.getU32DRMServiceId());
        } else {
            clearU32DRMServiceId();
        }
        if (rhs.hasSDRMServiceLabel()) {
            setSDRMServiceLabel(rhs.getSDRMServiceLabel());
        } else {
            clearSDRMServiceLabel();
        }
        if (rhs.hasU8DRMServiceShortId()) {
            setU8DRMServiceShortId(rhs.getU8DRMServiceShortId());
        } else {
            clearU8DRMServiceShortId();
        }
        if (rhs.hasE8Modulation()) {
            setE8Modulation(rhs.getE8Modulation());
        } else {
            clearE8Modulation();
        }
        if (rhs.hasU32HDStationId_DRMServiceId()) {
            setU32HDStationId_DRMServiceId(rhs.getU32HDStationId_DRMServiceId());
        } else {
            clearU32HDStationId_DRMServiceId();
        }
        if (rhs.hasE8HDTextEncoding()) {
            setE8HDTextEncoding(rhs.getE8HDTextEncoding());
        } else {
            clearE8HDTextEncoding();
        }
        if (rhs.hasSHDCallSign_DRMServiceLabel()) {
            setSHDCallSign_DRMServiceLabel(rhs.getSHDCallSign_DRMServiceLabel());
        } else {
            clearSHDCallSign_DRMServiceLabel();
        }
        if (rhs.hasU8HDStationGenre_DRMPty()) {
            setU8HDStationGenre_DRMPty(rhs.getU8HDStationGenre_DRMPty());
        } else {
            clearU8HDStationGenre_DRMPty();
        }
        if (rhs.hasU8HDAudioProgram_DRMShortID()) {
            setU8HDAudioProgram_DRMShortID(rhs.getU8HDAudioProgram_DRMShortID());
        } else {
            clearU8HDAudioProgram_DRMShortID();
        }
        if (rhs.hasSXMSMSlib_PresetListEntry()) {
            setSXMSMSlib_PresetListEntry(rhs.getSXMSMSlib_PresetListEntry());
        } else {
            clearSXMSMSlib_PresetListEntry();
        }
        if (rhs.hasKey()) {
            setKey(rhs.getKey());
        } else {
            clearKey();
        }
        if (rhs.hasPresetType()) {
            setPresetType(rhs.getPresetType());
        } else {
            clearPresetType();
        }
        if (rhs.hasSXM360L_PresetListEntry()) {
            setSXM360L_PresetListEntry(rhs.getSXM360L_PresetListEntry());
        } else {
            clearSXM360L_PresetListEntry();
        }
    }
    return *this;
}

inline bool T_PresetList::operator == (const T_PresetList& rhs) const {
    return (((!hasList() && !rhs.hasList()) || getList() == rhs.getList()) &&
        ((!hasBand() && !rhs.hasBand()) || getBand() == rhs.getBand()) &&
        ((!hasElement_ID() && !rhs.hasElement_ID()) || getElement_ID() == rhs.getElement_ID()) &&
        ((!hasFrequency() && !rhs.hasFrequency()) || getFrequency() == rhs.getFrequency()) &&
        ((!hasPSName() && !rhs.hasPSName()) || getPSName() == rhs.getPSName()) &&
        ((!hasU8TpTmcInfo() && !rhs.hasU8TpTmcInfo()) || getU8TpTmcInfo() == rhs.getU8TpTmcInfo()) &&
        ((!hasPTY() && !rhs.hasPTY()) || getPTY() == rhs.getPTY()) &&
        ((!hasEnsembleName() && !rhs.hasEnsembleName()) || getEnsembleName() == rhs.getEnsembleName()) &&
        ((!hasFrequency_Label() && !rhs.hasFrequency_Label()) || getFrequency_Label() == rhs.getFrequency_Label()) &&
        ((!hasStationLogo() && !rhs.hasStationLogo()) || getStationLogo() == rhs.getStationLogo()) &&
        ((!hasU32HDStationId() && !rhs.hasU32HDStationId()) || getU32HDStationId() == rhs.getU32HDStationId()) &&
        ((!hasSHDCallSign() && !rhs.hasSHDCallSign()) || getSHDCallSign() == rhs.getSHDCallSign()) &&
        ((!hasE8HDAudioProgram() && !rhs.hasE8HDAudioProgram()) || getE8HDAudioProgram() == rhs.getE8HDAudioProgram()) &&
        ((!hasU32DRMServiceId() && !rhs.hasU32DRMServiceId()) || getU32DRMServiceId() == rhs.getU32DRMServiceId()) &&
        ((!hasSDRMServiceLabel() && !rhs.hasSDRMServiceLabel()) || getSDRMServiceLabel() == rhs.getSDRMServiceLabel()) &&
        ((!hasU8DRMServiceShortId() && !rhs.hasU8DRMServiceShortId()) || getU8DRMServiceShortId() == rhs.getU8DRMServiceShortId()) &&
        ((!hasE8Modulation() && !rhs.hasE8Modulation()) || getE8Modulation() == rhs.getE8Modulation()) &&
        ((!hasU32HDStationId_DRMServiceId() && !rhs.hasU32HDStationId_DRMServiceId()) || getU32HDStationId_DRMServiceId() == rhs.getU32HDStationId_DRMServiceId()) &&
        ((!hasE8HDTextEncoding() && !rhs.hasE8HDTextEncoding()) || getE8HDTextEncoding() == rhs.getE8HDTextEncoding()) &&
        ((!hasSHDCallSign_DRMServiceLabel() && !rhs.hasSHDCallSign_DRMServiceLabel()) || getSHDCallSign_DRMServiceLabel() == rhs.getSHDCallSign_DRMServiceLabel()) &&
        ((!hasU8HDStationGenre_DRMPty() && !rhs.hasU8HDStationGenre_DRMPty()) || getU8HDStationGenre_DRMPty() == rhs.getU8HDStationGenre_DRMPty()) &&
        ((!hasU8HDAudioProgram_DRMShortID() && !rhs.hasU8HDAudioProgram_DRMShortID()) || getU8HDAudioProgram_DRMShortID() == rhs.getU8HDAudioProgram_DRMShortID()) &&
        ((!hasSXMSMSlib_PresetListEntry() && !rhs.hasSXMSMSlib_PresetListEntry()) || getSXMSMSlib_PresetListEntry() == rhs.getSXMSMSlib_PresetListEntry()) &&
        ((!hasKey() && !rhs.hasKey()) || getKey() == rhs.getKey()) &&
        ((!hasPresetType() && !rhs.hasPresetType()) || getPresetType() == rhs.getPresetType()) &&
        ((!hasSXM360L_PresetListEntry() && !rhs.hasSXM360L_PresetListEntry()) || getSXM360L_PresetListEntry() == rhs.getSXM360L_PresetListEntry()));
}

inline bool T_PresetList::operator != (const T_PresetList& rhs) const {
    return ! (*this == rhs);
}

inline bool T_PresetList::operator < (const T_PresetList& rhs) const {
    if (hasList() || rhs.hasList()) {
        if ((uint32)getList() < (uint32)rhs.getList()) return true;
        if ((uint32)getList() > (uint32)rhs.getList()) return false;
    }
    if (hasBand() || rhs.hasBand()) {
        if ((uint32)getBand() < (uint32)rhs.getBand()) return true;
        if ((uint32)getBand() > (uint32)rhs.getBand()) return false;
    }
    if (hasElement_ID() || rhs.hasElement_ID()) {
        if (getElement_ID() < rhs.getElement_ID()) return true;
        if (getElement_ID() > rhs.getElement_ID()) return false;
    }
    if (hasFrequency() || rhs.hasFrequency()) {
        if (getFrequency() < rhs.getFrequency()) return true;
        if (getFrequency() > rhs.getFrequency()) return false;
    }
    if (hasPSName() || rhs.hasPSName()) {
        if (getPSName() < rhs.getPSName()) return true;
        if (getPSName() > rhs.getPSName()) return false;
    }
    if (hasU8TpTmcInfo() || rhs.hasU8TpTmcInfo()) {
        if (getU8TpTmcInfo() < rhs.getU8TpTmcInfo()) return true;
        if (getU8TpTmcInfo() > rhs.getU8TpTmcInfo()) return false;
    }
    if (hasPTY() || rhs.hasPTY()) {
        if (getPTY() < rhs.getPTY()) return true;
        if (getPTY() > rhs.getPTY()) return false;
    }
    if (hasEnsembleName() || rhs.hasEnsembleName()) {
        if (getEnsembleName() < rhs.getEnsembleName()) return true;
        if (getEnsembleName() > rhs.getEnsembleName()) return false;
    }
    if (hasFrequency_Label() || rhs.hasFrequency_Label()) {
        if (getFrequency_Label() < rhs.getFrequency_Label()) return true;
        if (getFrequency_Label() > rhs.getFrequency_Label()) return false;
    }
    if (hasStationLogo() || rhs.hasStationLogo()) {
        if (getStationLogo() < rhs.getStationLogo()) return true;
        if (getStationLogo() > rhs.getStationLogo()) return false;
    }
    if (hasU32HDStationId() || rhs.hasU32HDStationId()) {
        if (getU32HDStationId() < rhs.getU32HDStationId()) return true;
        if (getU32HDStationId() > rhs.getU32HDStationId()) return false;
    }
    if (hasSHDCallSign() || rhs.hasSHDCallSign()) {
        if (getSHDCallSign() < rhs.getSHDCallSign()) return true;
        if (getSHDCallSign() > rhs.getSHDCallSign()) return false;
    }
    if (hasE8HDAudioProgram() || rhs.hasE8HDAudioProgram()) {
        if ((uint32)getE8HDAudioProgram() < (uint32)rhs.getE8HDAudioProgram()) return true;
        if ((uint32)getE8HDAudioProgram() > (uint32)rhs.getE8HDAudioProgram()) return false;
    }
    if (hasU32DRMServiceId() || rhs.hasU32DRMServiceId()) {
        if (getU32DRMServiceId() < rhs.getU32DRMServiceId()) return true;
        if (getU32DRMServiceId() > rhs.getU32DRMServiceId()) return false;
    }
    if (hasSDRMServiceLabel() || rhs.hasSDRMServiceLabel()) {
        if (getSDRMServiceLabel() < rhs.getSDRMServiceLabel()) return true;
        if (getSDRMServiceLabel() > rhs.getSDRMServiceLabel()) return false;
    }
    if (hasU8DRMServiceShortId() || rhs.hasU8DRMServiceShortId()) {
        if (getU8DRMServiceShortId() < rhs.getU8DRMServiceShortId()) return true;
        if (getU8DRMServiceShortId() > rhs.getU8DRMServiceShortId()) return false;
    }
    if (hasE8Modulation() || rhs.hasE8Modulation()) {
        if ((uint32)getE8Modulation() < (uint32)rhs.getE8Modulation()) return true;
        if ((uint32)getE8Modulation() > (uint32)rhs.getE8Modulation()) return false;
    }
    if (hasU32HDStationId_DRMServiceId() || rhs.hasU32HDStationId_DRMServiceId()) {
        if (getU32HDStationId_DRMServiceId() < rhs.getU32HDStationId_DRMServiceId()) return true;
        if (getU32HDStationId_DRMServiceId() > rhs.getU32HDStationId_DRMServiceId()) return false;
    }
    if (hasE8HDTextEncoding() || rhs.hasE8HDTextEncoding()) {
        if ((uint32)getE8HDTextEncoding() < (uint32)rhs.getE8HDTextEncoding()) return true;
        if ((uint32)getE8HDTextEncoding() > (uint32)rhs.getE8HDTextEncoding()) return false;
    }
    if (hasSHDCallSign_DRMServiceLabel() || rhs.hasSHDCallSign_DRMServiceLabel()) {
        if (getSHDCallSign_DRMServiceLabel() < rhs.getSHDCallSign_DRMServiceLabel()) return true;
        if (getSHDCallSign_DRMServiceLabel() > rhs.getSHDCallSign_DRMServiceLabel()) return false;
    }
    if (hasU8HDStationGenre_DRMPty() || rhs.hasU8HDStationGenre_DRMPty()) {
        if (getU8HDStationGenre_DRMPty() < rhs.getU8HDStationGenre_DRMPty()) return true;
        if (getU8HDStationGenre_DRMPty() > rhs.getU8HDStationGenre_DRMPty()) return false;
    }
    if (hasU8HDAudioProgram_DRMShortID() || rhs.hasU8HDAudioProgram_DRMShortID()) {
        if (getU8HDAudioProgram_DRMShortID() < rhs.getU8HDAudioProgram_DRMShortID()) return true;
        if (getU8HDAudioProgram_DRMShortID() > rhs.getU8HDAudioProgram_DRMShortID()) return false;
    }
    if (hasSXMSMSlib_PresetListEntry() || rhs.hasSXMSMSlib_PresetListEntry()) {
        if (getSXMSMSlib_PresetListEntry() < rhs.getSXMSMSlib_PresetListEntry()) return true;
        if (getSXMSMSlib_PresetListEntry() > rhs.getSXMSMSlib_PresetListEntry()) return false;
    }
    if (hasKey() || rhs.hasKey()) {
        if (getKey() < rhs.getKey()) return true;
        if (getKey() > rhs.getKey()) return false;
    }
    if (hasPresetType() || rhs.hasPresetType()) {
        if ((uint32)getPresetType() < (uint32)rhs.getPresetType()) return true;
        if ((uint32)getPresetType() > (uint32)rhs.getPresetType()) return false;
    }
    if (hasSXM360L_PresetListEntry() || rhs.hasSXM360L_PresetListEntry()) {
        if (getSXM360L_PresetListEntry() < rhs.getSXM360L_PresetListEntry()) return true;
        if (getSXM360L_PresetListEntry() > rhs.getSXM360L_PresetListEntry()) return false;
    }
    return false;
}

inline bool T_PresetList::operator > (const T_PresetList& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_PresetList::clear() {
    clearList();
    clearBand();
    clearElement_ID();
    clearFrequency();
    clearPSName();
    clearU8TpTmcInfo();
    clearPTY();
    clearEnsembleName();
    clearFrequency_Label();
    clearStationLogo();
    clearU32HDStationId();
    clearSHDCallSign();
    clearE8HDAudioProgram();
    clearU32DRMServiceId();
    clearSDRMServiceLabel();
    clearU8DRMServiceShortId();
    clearE8Modulation();
    clearU32HDStationId_DRMServiceId();
    clearE8HDTextEncoding();
    clearSHDCallSign_DRMServiceLabel();
    clearU8HDStationGenre_DRMPty();
    clearU8HDAudioProgram_DRMShortID();
    clearSXMSMSlib_PresetListEntry();
    clearKey();
    clearPresetType();
    clearSXM360L_PresetListEntry();
}

inline void T_PresetList::clearList() {
    if (hasList()) {
         clear_has_List();
        _List = ::midw_tunermaster_fi_types::T_e8_List__BANK_FM1;
     }
}

inline bool T_PresetList::hasList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_List T_PresetList::getList () const {
    return _List;
}

inline void T_PresetList::setList (T_e8_List List_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_List_IsValid(List_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", List_, "T_e8_List", "List", "T_PresetList");
    }
    set_has_List();
    this->_List = List_;
}

inline void T_PresetList::clearBand() {
    if (hasBand()) {
         clear_has_Band();
        _Band = ::midw_tunermaster_fi_types::T_e8_Band__TUN_MSTR_BAND_FM;
     }
}

inline bool T_PresetList::hasBand () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_Band T_PresetList::getBand () const {
    return _Band;
}

inline void T_PresetList::setBand (T_e8_Band Band_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Band_IsValid(Band_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Band_, "T_e8_Band", "Band", "T_PresetList");
    }
    set_has_Band();
    this->_Band = Band_;
}

inline void T_PresetList::clearElement_ID() {
    if (hasElement_ID()) {
         clear_has_Element_ID();
        _Element_ID = 0u;
     }
}

inline bool T_PresetList::hasElement_ID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_PresetList::getElement_ID () const {
    return _Element_ID;
}

inline void T_PresetList::setElement_ID (uint8 Element_ID_) {
    set_has_Element_ID();
    this->_Element_ID = Element_ID_;
}

inline void T_PresetList::clearFrequency() {
    if (hasFrequency()) {
         clear_has_Frequency();
        _Frequency = 0u;
     }
}

inline bool T_PresetList::hasFrequency () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_PresetList::getFrequency () const {
    return _Frequency;
}

inline void T_PresetList::setFrequency (uint32 Frequency_) {
    set_has_Frequency();
    this->_Frequency = Frequency_;
}

inline void T_PresetList::clearPSName() {
    if (hasPSName()) {
         clear_has_PSName();
        if (_PSName != NULL) {
            _PSName->clear();
        }
     }
}

inline bool T_PresetList::hasPSName () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_PresetList::getPSName () const {
    if (_PSName == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_PSName;
}

inline ::std::string& T_PresetList::getPSNameMutable () {
    set_has_PSName();
    if (_PSName == NULL) {
        _PSName = new ::std::string ();
        CHECK_ALLOCATION( _PSName );
    }
    return *_PSName;
}

inline void T_PresetList::setPSName (const ::std::string& PSName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PSName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PSName();
    if (this->_PSName == NULL) {
        this->_PSName = new ::std::string (PSName_);
        CHECK_ALLOCATION( this->_PSName );
    } else {
        *this->_PSName = PSName_;
    }
}

inline void T_PresetList::setPSName (const char* PSName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (PSName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PSName();
    if (this->_PSName == NULL) {
        this->_PSName = new ::std::string (PSName_);
        CHECK_ALLOCATION( this->_PSName );
    } else {
        this->_PSName->assign(PSName_);
    }
}

inline void T_PresetList::setPSName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_PSName();
    if (this->_PSName == NULL) {
        this->_PSName = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_PSName );
    } else {
        this->_PSName->assign(value, size);
    }
}

inline ::std::string* T_PresetList::releasePSName() {
    clear_has_PSName();
    ::std::string* temp = _PSName;
    this->_PSName = NULL;
    return temp;
}

inline void T_PresetList::replacePSName (::std::string* PSName_) {
    set_has_PSName();
    if (this->_PSName != PSName_) {
        if (this->_PSName != NULL) {
            delete this->_PSName;
        }
        this->_PSName = PSName_;
    }
}

inline void T_PresetList::clearU8TpTmcInfo() {
    if (hasU8TpTmcInfo()) {
         clear_has_u8TpTmcInfo();
        _u8TpTmcInfo = 0u;
     }
}

inline bool T_PresetList::hasU8TpTmcInfo () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_PresetList::getU8TpTmcInfo () const {
    return _u8TpTmcInfo;
}

inline void T_PresetList::setU8TpTmcInfo (uint8 u8TpTmcInfo_) {
    set_has_u8TpTmcInfo();
    this->_u8TpTmcInfo = u8TpTmcInfo_;
}

inline void T_PresetList::clearPTY() {
    if (hasPTY()) {
         clear_has_PTY();
        _PTY = 0u;
     }
}

inline bool T_PresetList::hasPTY () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint32 T_PresetList::getPTY () const {
    return _PTY;
}

inline void T_PresetList::setPTY (uint32 PTY_) {
    set_has_PTY();
    this->_PTY = PTY_;
}

inline void T_PresetList::clearEnsembleName() {
    if (hasEnsembleName()) {
         clear_has_EnsembleName();
        if (_EnsembleName != NULL) {
            _EnsembleName->clear();
        }
     }
}

inline bool T_PresetList::hasEnsembleName () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& T_PresetList::getEnsembleName () const {
    if (_EnsembleName == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_EnsembleName;
}

inline ::std::string& T_PresetList::getEnsembleNameMutable () {
    set_has_EnsembleName();
    if (_EnsembleName == NULL) {
        _EnsembleName = new ::std::string ();
        CHECK_ALLOCATION( _EnsembleName );
    }
    return *_EnsembleName;
}

inline void T_PresetList::setEnsembleName (const ::std::string& EnsembleName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (EnsembleName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_EnsembleName();
    if (this->_EnsembleName == NULL) {
        this->_EnsembleName = new ::std::string (EnsembleName_);
        CHECK_ALLOCATION( this->_EnsembleName );
    } else {
        *this->_EnsembleName = EnsembleName_;
    }
}

inline void T_PresetList::setEnsembleName (const char* EnsembleName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (EnsembleName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_EnsembleName();
    if (this->_EnsembleName == NULL) {
        this->_EnsembleName = new ::std::string (EnsembleName_);
        CHECK_ALLOCATION( this->_EnsembleName );
    } else {
        this->_EnsembleName->assign(EnsembleName_);
    }
}

inline void T_PresetList::setEnsembleName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_EnsembleName();
    if (this->_EnsembleName == NULL) {
        this->_EnsembleName = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_EnsembleName );
    } else {
        this->_EnsembleName->assign(value, size);
    }
}

inline ::std::string* T_PresetList::releaseEnsembleName() {
    clear_has_EnsembleName();
    ::std::string* temp = _EnsembleName;
    this->_EnsembleName = NULL;
    return temp;
}

inline void T_PresetList::replaceEnsembleName (::std::string* EnsembleName_) {
    set_has_EnsembleName();
    if (this->_EnsembleName != EnsembleName_) {
        if (this->_EnsembleName != NULL) {
            delete this->_EnsembleName;
        }
        this->_EnsembleName = EnsembleName_;
    }
}

inline void T_PresetList::clearFrequency_Label() {
    if (hasFrequency_Label()) {
         clear_has_Frequency_Label();
        if (_Frequency_Label != NULL) {
            _Frequency_Label->clear();
        }
     }
}

inline bool T_PresetList::hasFrequency_Label () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& T_PresetList::getFrequency_Label () const {
    if (_Frequency_Label == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_Frequency_Label;
}

inline ::std::string& T_PresetList::getFrequency_LabelMutable () {
    set_has_Frequency_Label();
    if (_Frequency_Label == NULL) {
        _Frequency_Label = new ::std::string ();
        CHECK_ALLOCATION( _Frequency_Label );
    }
    return *_Frequency_Label;
}

inline void T_PresetList::setFrequency_Label (const ::std::string& Frequency_Label_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Frequency_Label_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Frequency_Label();
    if (this->_Frequency_Label == NULL) {
        this->_Frequency_Label = new ::std::string (Frequency_Label_);
        CHECK_ALLOCATION( this->_Frequency_Label );
    } else {
        *this->_Frequency_Label = Frequency_Label_;
    }
}

inline void T_PresetList::setFrequency_Label (const char* Frequency_Label_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Frequency_Label_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Frequency_Label();
    if (this->_Frequency_Label == NULL) {
        this->_Frequency_Label = new ::std::string (Frequency_Label_);
        CHECK_ALLOCATION( this->_Frequency_Label );
    } else {
        this->_Frequency_Label->assign(Frequency_Label_);
    }
}

inline void T_PresetList::setFrequency_Label (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Frequency_Label();
    if (this->_Frequency_Label == NULL) {
        this->_Frequency_Label = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_Frequency_Label );
    } else {
        this->_Frequency_Label->assign(value, size);
    }
}

inline ::std::string* T_PresetList::releaseFrequency_Label() {
    clear_has_Frequency_Label();
    ::std::string* temp = _Frequency_Label;
    this->_Frequency_Label = NULL;
    return temp;
}

inline void T_PresetList::replaceFrequency_Label (::std::string* Frequency_Label_) {
    set_has_Frequency_Label();
    if (this->_Frequency_Label != Frequency_Label_) {
        if (this->_Frequency_Label != NULL) {
            delete this->_Frequency_Label;
        }
        this->_Frequency_Label = Frequency_Label_;
    }
}

inline void T_PresetList::clearStationLogo() {
    if (hasStationLogo()) {
         clear_has_StationLogo();
        if (_StationLogo != NULL) {
            _StationLogo->clear();
        }
     }
}

inline bool T_PresetList::hasStationLogo () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const ::std::string& T_PresetList::getStationLogo () const {
    if (_StationLogo == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_StationLogo;
}

inline ::std::string& T_PresetList::getStationLogoMutable () {
    set_has_StationLogo();
    if (_StationLogo == NULL) {
        _StationLogo = new ::std::string ();
        CHECK_ALLOCATION( _StationLogo );
    }
    return *_StationLogo;
}

inline void T_PresetList::setStationLogo (const ::std::string& StationLogo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StationLogo_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StationLogo();
    if (this->_StationLogo == NULL) {
        this->_StationLogo = new ::std::string (StationLogo_);
        CHECK_ALLOCATION( this->_StationLogo );
    } else {
        *this->_StationLogo = StationLogo_;
    }
}

inline void T_PresetList::setStationLogo (const char* StationLogo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StationLogo_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StationLogo();
    if (this->_StationLogo == NULL) {
        this->_StationLogo = new ::std::string (StationLogo_);
        CHECK_ALLOCATION( this->_StationLogo );
    } else {
        this->_StationLogo->assign(StationLogo_);
    }
}

inline void T_PresetList::setStationLogo (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StationLogo();
    if (this->_StationLogo == NULL) {
        this->_StationLogo = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_StationLogo );
    } else {
        this->_StationLogo->assign(value, size);
    }
}

inline ::std::string* T_PresetList::releaseStationLogo() {
    clear_has_StationLogo();
    ::std::string* temp = _StationLogo;
    this->_StationLogo = NULL;
    return temp;
}

inline void T_PresetList::replaceStationLogo (::std::string* StationLogo_) {
    set_has_StationLogo();
    if (this->_StationLogo != StationLogo_) {
        if (this->_StationLogo != NULL) {
            delete this->_StationLogo;
        }
        this->_StationLogo = StationLogo_;
    }
}

inline void T_PresetList::clearU32HDStationId() {
    if (hasU32HDStationId()) {
         clear_has_u32HDStationId();
        _u32HDStationId = 0u;
     }
}

inline bool T_PresetList::hasU32HDStationId () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline uint32 T_PresetList::getU32HDStationId () const {
    return _u32HDStationId;
}

inline void T_PresetList::setU32HDStationId (uint32 u32HDStationId_) {
    set_has_u32HDStationId();
    this->_u32HDStationId = u32HDStationId_;
}

inline void T_PresetList::clearSHDCallSign() {
    if (hasSHDCallSign()) {
         clear_has_sHDCallSign();
        if (_sHDCallSign != NULL) {
            _sHDCallSign->clear();
        }
     }
}

inline bool T_PresetList::hasSHDCallSign () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline const ::std::string& T_PresetList::getSHDCallSign () const {
    if (_sHDCallSign == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_sHDCallSign;
}

inline ::std::string& T_PresetList::getSHDCallSignMutable () {
    set_has_sHDCallSign();
    if (_sHDCallSign == NULL) {
        _sHDCallSign = new ::std::string ();
        CHECK_ALLOCATION( _sHDCallSign );
    }
    return *_sHDCallSign;
}

inline void T_PresetList::setSHDCallSign (const ::std::string& sHDCallSign_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sHDCallSign_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sHDCallSign();
    if (this->_sHDCallSign == NULL) {
        this->_sHDCallSign = new ::std::string (sHDCallSign_);
        CHECK_ALLOCATION( this->_sHDCallSign );
    } else {
        *this->_sHDCallSign = sHDCallSign_;
    }
}

inline void T_PresetList::setSHDCallSign (const char* sHDCallSign_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sHDCallSign_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sHDCallSign();
    if (this->_sHDCallSign == NULL) {
        this->_sHDCallSign = new ::std::string (sHDCallSign_);
        CHECK_ALLOCATION( this->_sHDCallSign );
    } else {
        this->_sHDCallSign->assign(sHDCallSign_);
    }
}

inline void T_PresetList::setSHDCallSign (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sHDCallSign();
    if (this->_sHDCallSign == NULL) {
        this->_sHDCallSign = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_sHDCallSign );
    } else {
        this->_sHDCallSign->assign(value, size);
    }
}

inline ::std::string* T_PresetList::releaseSHDCallSign() {
    clear_has_sHDCallSign();
    ::std::string* temp = _sHDCallSign;
    this->_sHDCallSign = NULL;
    return temp;
}

inline void T_PresetList::replaceSHDCallSign (::std::string* sHDCallSign_) {
    set_has_sHDCallSign();
    if (this->_sHDCallSign != sHDCallSign_) {
        if (this->_sHDCallSign != NULL) {
            delete this->_sHDCallSign;
        }
        this->_sHDCallSign = sHDCallSign_;
    }
}

inline void T_PresetList::clearE8HDAudioProgram() {
    if (hasE8HDAudioProgram()) {
         clear_has_e8HDAudioProgram();
        _e8HDAudioProgram = ::midw_tunermaster_fi_types::T_e8_HDAudioProgram__TUN_MSTR_AUDIO_PROGRAM_ONE;
     }
}

inline bool T_PresetList::hasE8HDAudioProgram () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline T_e8_HDAudioProgram T_PresetList::getE8HDAudioProgram () const {
    return _e8HDAudioProgram;
}

inline void T_PresetList::setE8HDAudioProgram (T_e8_HDAudioProgram e8HDAudioProgram_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_HDAudioProgram_IsValid(e8HDAudioProgram_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8HDAudioProgram_, "T_e8_HDAudioProgram", "e8HDAudioProgram", "T_PresetList");
    }
    set_has_e8HDAudioProgram();
    this->_e8HDAudioProgram = e8HDAudioProgram_;
}

inline void T_PresetList::clearU32DRMServiceId() {
    if (hasU32DRMServiceId()) {
         clear_has_u32DRMServiceId();
        _u32DRMServiceId = 0u;
     }
}

inline bool T_PresetList::hasU32DRMServiceId () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint32 T_PresetList::getU32DRMServiceId () const {
    return _u32DRMServiceId;
}

inline void T_PresetList::setU32DRMServiceId (uint32 u32DRMServiceId_) {
    set_has_u32DRMServiceId();
    this->_u32DRMServiceId = u32DRMServiceId_;
}

inline void T_PresetList::clearSDRMServiceLabel() {
    if (hasSDRMServiceLabel()) {
         clear_has_sDRMServiceLabel();
        if (_sDRMServiceLabel != NULL) {
            _sDRMServiceLabel->clear();
        }
     }
}

inline bool T_PresetList::hasSDRMServiceLabel () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline const ::std::string& T_PresetList::getSDRMServiceLabel () const {
    if (_sDRMServiceLabel == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_sDRMServiceLabel;
}

inline ::std::string& T_PresetList::getSDRMServiceLabelMutable () {
    set_has_sDRMServiceLabel();
    if (_sDRMServiceLabel == NULL) {
        _sDRMServiceLabel = new ::std::string ();
        CHECK_ALLOCATION( _sDRMServiceLabel );
    }
    return *_sDRMServiceLabel;
}

inline void T_PresetList::setSDRMServiceLabel (const ::std::string& sDRMServiceLabel_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDRMServiceLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDRMServiceLabel();
    if (this->_sDRMServiceLabel == NULL) {
        this->_sDRMServiceLabel = new ::std::string (sDRMServiceLabel_);
        CHECK_ALLOCATION( this->_sDRMServiceLabel );
    } else {
        *this->_sDRMServiceLabel = sDRMServiceLabel_;
    }
}

inline void T_PresetList::setSDRMServiceLabel (const char* sDRMServiceLabel_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sDRMServiceLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDRMServiceLabel();
    if (this->_sDRMServiceLabel == NULL) {
        this->_sDRMServiceLabel = new ::std::string (sDRMServiceLabel_);
        CHECK_ALLOCATION( this->_sDRMServiceLabel );
    } else {
        this->_sDRMServiceLabel->assign(sDRMServiceLabel_);
    }
}

inline void T_PresetList::setSDRMServiceLabel (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sDRMServiceLabel();
    if (this->_sDRMServiceLabel == NULL) {
        this->_sDRMServiceLabel = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_sDRMServiceLabel );
    } else {
        this->_sDRMServiceLabel->assign(value, size);
    }
}

inline ::std::string* T_PresetList::releaseSDRMServiceLabel() {
    clear_has_sDRMServiceLabel();
    ::std::string* temp = _sDRMServiceLabel;
    this->_sDRMServiceLabel = NULL;
    return temp;
}

inline void T_PresetList::replaceSDRMServiceLabel (::std::string* sDRMServiceLabel_) {
    set_has_sDRMServiceLabel();
    if (this->_sDRMServiceLabel != sDRMServiceLabel_) {
        if (this->_sDRMServiceLabel != NULL) {
            delete this->_sDRMServiceLabel;
        }
        this->_sDRMServiceLabel = sDRMServiceLabel_;
    }
}

inline void T_PresetList::clearU8DRMServiceShortId() {
    if (hasU8DRMServiceShortId()) {
         clear_has_u8DRMServiceShortId();
        _u8DRMServiceShortId = 0u;
     }
}

inline bool T_PresetList::hasU8DRMServiceShortId () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline uint8 T_PresetList::getU8DRMServiceShortId () const {
    return _u8DRMServiceShortId;
}

inline void T_PresetList::setU8DRMServiceShortId (uint8 u8DRMServiceShortId_) {
    set_has_u8DRMServiceShortId();
    this->_u8DRMServiceShortId = u8DRMServiceShortId_;
}

inline void T_PresetList::clearE8Modulation() {
    if (hasE8Modulation()) {
         clear_has_e8Modulation();
        _e8Modulation = ::midw_tunermaster_fi_types::T_e8_ModulationType__TUN_MSTR_MODULATION_ANALOG;
     }
}

inline bool T_PresetList::hasE8Modulation () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline T_e8_ModulationType T_PresetList::getE8Modulation () const {
    return _e8Modulation;
}

inline void T_PresetList::setE8Modulation (T_e8_ModulationType e8Modulation_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_ModulationType_IsValid(e8Modulation_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Modulation_, "T_e8_ModulationType", "e8Modulation", "T_PresetList");
    }
    set_has_e8Modulation();
    this->_e8Modulation = e8Modulation_;
}

inline void T_PresetList::clearU32HDStationId_DRMServiceId() {
    if (hasU32HDStationId_DRMServiceId()) {
         clear_has_u32HDStationId_DRMServiceId();
        _u32HDStationId_DRMServiceId = 0u;
     }
}

inline bool T_PresetList::hasU32HDStationId_DRMServiceId () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline uint32 T_PresetList::getU32HDStationId_DRMServiceId () const {
    return _u32HDStationId_DRMServiceId;
}

inline void T_PresetList::setU32HDStationId_DRMServiceId (uint32 u32HDStationId_DRMServiceId_) {
    set_has_u32HDStationId_DRMServiceId();
    this->_u32HDStationId_DRMServiceId = u32HDStationId_DRMServiceId_;
}

inline void T_PresetList::clearE8HDTextEncoding() {
    if (hasE8HDTextEncoding()) {
         clear_has_e8HDTextEncoding();
        _e8HDTextEncoding = ::midw_tunermaster_fi_types::T_e8_HDTextEncoding__TUN_MSTR_ISO_IEC_8859_1_1998;
     }
}

inline bool T_PresetList::hasE8HDTextEncoding () const {
    return (_has_bits_[0] & (1u << 18)) > 0;
}

inline T_e8_HDTextEncoding T_PresetList::getE8HDTextEncoding () const {
    return _e8HDTextEncoding;
}

inline void T_PresetList::setE8HDTextEncoding (T_e8_HDTextEncoding e8HDTextEncoding_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_HDTextEncoding_IsValid(e8HDTextEncoding_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8HDTextEncoding_, "T_e8_HDTextEncoding", "e8HDTextEncoding", "T_PresetList");
    }
    set_has_e8HDTextEncoding();
    this->_e8HDTextEncoding = e8HDTextEncoding_;
}

inline void T_PresetList::clearSHDCallSign_DRMServiceLabel() {
    if (hasSHDCallSign_DRMServiceLabel()) {
         clear_has_sHDCallSign_DRMServiceLabel();
        if (_sHDCallSign_DRMServiceLabel != NULL) {
            _sHDCallSign_DRMServiceLabel->clear();
        }
     }
}

inline bool T_PresetList::hasSHDCallSign_DRMServiceLabel () const {
    return (_has_bits_[0] & (1u << 19)) > 0;
}

inline const ::std::string& T_PresetList::getSHDCallSign_DRMServiceLabel () const {
    if (_sHDCallSign_DRMServiceLabel == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_sHDCallSign_DRMServiceLabel;
}

inline ::std::string& T_PresetList::getSHDCallSign_DRMServiceLabelMutable () {
    set_has_sHDCallSign_DRMServiceLabel();
    if (_sHDCallSign_DRMServiceLabel == NULL) {
        _sHDCallSign_DRMServiceLabel = new ::std::string ();
        CHECK_ALLOCATION( _sHDCallSign_DRMServiceLabel );
    }
    return *_sHDCallSign_DRMServiceLabel;
}

inline void T_PresetList::setSHDCallSign_DRMServiceLabel (const ::std::string& sHDCallSign_DRMServiceLabel_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sHDCallSign_DRMServiceLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sHDCallSign_DRMServiceLabel();
    if (this->_sHDCallSign_DRMServiceLabel == NULL) {
        this->_sHDCallSign_DRMServiceLabel = new ::std::string (sHDCallSign_DRMServiceLabel_);
        CHECK_ALLOCATION( this->_sHDCallSign_DRMServiceLabel );
    } else {
        *this->_sHDCallSign_DRMServiceLabel = sHDCallSign_DRMServiceLabel_;
    }
}

inline void T_PresetList::setSHDCallSign_DRMServiceLabel (const char* sHDCallSign_DRMServiceLabel_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sHDCallSign_DRMServiceLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sHDCallSign_DRMServiceLabel();
    if (this->_sHDCallSign_DRMServiceLabel == NULL) {
        this->_sHDCallSign_DRMServiceLabel = new ::std::string (sHDCallSign_DRMServiceLabel_);
        CHECK_ALLOCATION( this->_sHDCallSign_DRMServiceLabel );
    } else {
        this->_sHDCallSign_DRMServiceLabel->assign(sHDCallSign_DRMServiceLabel_);
    }
}

inline void T_PresetList::setSHDCallSign_DRMServiceLabel (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sHDCallSign_DRMServiceLabel();
    if (this->_sHDCallSign_DRMServiceLabel == NULL) {
        this->_sHDCallSign_DRMServiceLabel = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_sHDCallSign_DRMServiceLabel );
    } else {
        this->_sHDCallSign_DRMServiceLabel->assign(value, size);
    }
}

inline ::std::string* T_PresetList::releaseSHDCallSign_DRMServiceLabel() {
    clear_has_sHDCallSign_DRMServiceLabel();
    ::std::string* temp = _sHDCallSign_DRMServiceLabel;
    this->_sHDCallSign_DRMServiceLabel = NULL;
    return temp;
}

inline void T_PresetList::replaceSHDCallSign_DRMServiceLabel (::std::string* sHDCallSign_DRMServiceLabel_) {
    set_has_sHDCallSign_DRMServiceLabel();
    if (this->_sHDCallSign_DRMServiceLabel != sHDCallSign_DRMServiceLabel_) {
        if (this->_sHDCallSign_DRMServiceLabel != NULL) {
            delete this->_sHDCallSign_DRMServiceLabel;
        }
        this->_sHDCallSign_DRMServiceLabel = sHDCallSign_DRMServiceLabel_;
    }
}

inline void T_PresetList::clearU8HDStationGenre_DRMPty() {
    if (hasU8HDStationGenre_DRMPty()) {
         clear_has_u8HDStationGenre_DRMPty();
        _u8HDStationGenre_DRMPty = 0u;
     }
}

inline bool T_PresetList::hasU8HDStationGenre_DRMPty () const {
    return (_has_bits_[0] & (1u << 20)) > 0;
}

inline uint8 T_PresetList::getU8HDStationGenre_DRMPty () const {
    return _u8HDStationGenre_DRMPty;
}

inline void T_PresetList::setU8HDStationGenre_DRMPty (uint8 u8HDStationGenre_DRMPty_) {
    set_has_u8HDStationGenre_DRMPty();
    this->_u8HDStationGenre_DRMPty = u8HDStationGenre_DRMPty_;
}

inline void T_PresetList::clearU8HDAudioProgram_DRMShortID() {
    if (hasU8HDAudioProgram_DRMShortID()) {
         clear_has_u8HDAudioProgram_DRMShortID();
        _u8HDAudioProgram_DRMShortID = 0u;
     }
}

inline bool T_PresetList::hasU8HDAudioProgram_DRMShortID () const {
    return (_has_bits_[0] & (1u << 21)) > 0;
}

inline uint8 T_PresetList::getU8HDAudioProgram_DRMShortID () const {
    return _u8HDAudioProgram_DRMShortID;
}

inline void T_PresetList::setU8HDAudioProgram_DRMShortID (uint8 u8HDAudioProgram_DRMShortID_) {
    set_has_u8HDAudioProgram_DRMShortID();
    this->_u8HDAudioProgram_DRMShortID = u8HDAudioProgram_DRMShortID_;
}

inline void T_PresetList::clearSXMSMSlib_PresetListEntry() {
    if (hasSXMSMSlib_PresetListEntry()) {
         clear_has_SXMSMSlib_PresetListEntry();
        if (_SXMSMSlib_PresetListEntry != NULL) {
            _SXMSMSlib_PresetListEntry->clear();
        }
     }
}

inline bool T_PresetList::hasSXMSMSlib_PresetListEntry () const {
    return (_has_bits_[0] & (1u << 22)) > 0;
}

inline const T_SXMPresetListEntry& T_PresetList::getSXMSMSlib_PresetListEntry () const {
    if (_SXMSMSlib_PresetListEntry == NULL) {
        return T_SXMPresetListEntry::getDefaultInstance();
    }
    return *_SXMSMSlib_PresetListEntry;
}

inline T_SXMPresetListEntry& T_PresetList::getSXMSMSlib_PresetListEntryMutable () {
    set_has_SXMSMSlib_PresetListEntry();
    if (_SXMSMSlib_PresetListEntry == NULL) {
        _SXMSMSlib_PresetListEntry = new T_SXMPresetListEntry ();
        CHECK_ALLOCATION( _SXMSMSlib_PresetListEntry );
    }
    return *_SXMSMSlib_PresetListEntry;
}

inline void T_PresetList::setSXMSMSlib_PresetListEntry (const T_SXMPresetListEntry& SXMSMSlib_PresetListEntry_) {
    set_has_SXMSMSlib_PresetListEntry();
    if (this->_SXMSMSlib_PresetListEntry == NULL) {
        this->_SXMSMSlib_PresetListEntry = new T_SXMPresetListEntry (SXMSMSlib_PresetListEntry_);
        CHECK_ALLOCATION( this->_SXMSMSlib_PresetListEntry );
    } else {
        *this->_SXMSMSlib_PresetListEntry = SXMSMSlib_PresetListEntry_;
    }
}

inline T_SXMPresetListEntry* T_PresetList::releaseSXMSMSlib_PresetListEntry() {
    clear_has_SXMSMSlib_PresetListEntry();
    T_SXMPresetListEntry* temp = _SXMSMSlib_PresetListEntry;
    this->_SXMSMSlib_PresetListEntry = NULL;
    return temp;
}

inline void T_PresetList::replaceSXMSMSlib_PresetListEntry (T_SXMPresetListEntry* SXMSMSlib_PresetListEntry_) {
    set_has_SXMSMSlib_PresetListEntry();
    if (this->_SXMSMSlib_PresetListEntry != SXMSMSlib_PresetListEntry_) {
        if (this->_SXMSMSlib_PresetListEntry != NULL) {
            delete this->_SXMSMSlib_PresetListEntry;
        }
        this->_SXMSMSlib_PresetListEntry = SXMSMSlib_PresetListEntry_;
    }
}

inline void T_PresetList::clearKey() {
    if (hasKey()) {
         clear_has_Key();
        if (_Key != NULL) {
            _Key->clear();
        }
     }
}

inline bool T_PresetList::hasKey () const {
    return (_has_bits_[0] & (1u << 23)) > 0;
}

inline const ::std::string& T_PresetList::getKey () const {
    if (_Key == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_Key;
}

inline ::std::string& T_PresetList::getKeyMutable () {
    set_has_Key();
    if (_Key == NULL) {
        _Key = new ::std::string ();
        CHECK_ALLOCATION( _Key );
    }
    return *_Key;
}

inline void T_PresetList::setKey (const ::std::string& Key_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Key_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Key();
    if (this->_Key == NULL) {
        this->_Key = new ::std::string (Key_);
        CHECK_ALLOCATION( this->_Key );
    } else {
        *this->_Key = Key_;
    }
}

inline void T_PresetList::setKey (const char* Key_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Key_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Key();
    if (this->_Key == NULL) {
        this->_Key = new ::std::string (Key_);
        CHECK_ALLOCATION( this->_Key );
    } else {
        this->_Key->assign(Key_);
    }
}

inline void T_PresetList::setKey (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Key();
    if (this->_Key == NULL) {
        this->_Key = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_Key );
    } else {
        this->_Key->assign(value, size);
    }
}

inline ::std::string* T_PresetList::releaseKey() {
    clear_has_Key();
    ::std::string* temp = _Key;
    this->_Key = NULL;
    return temp;
}

inline void T_PresetList::replaceKey (::std::string* Key_) {
    set_has_Key();
    if (this->_Key != Key_) {
        if (this->_Key != NULL) {
            delete this->_Key;
        }
        this->_Key = Key_;
    }
}

inline void T_PresetList::clearPresetType() {
    if (hasPresetType()) {
         clear_has_PresetType();
        _PresetType = ::midw_tunermaster_fi_types::T_e8_PresetType__Invalid;
     }
}

inline bool T_PresetList::hasPresetType () const {
    return (_has_bits_[0] & (1u << 24)) > 0;
}

inline T_e8_PresetType T_PresetList::getPresetType () const {
    return _PresetType;
}

inline void T_PresetList::setPresetType (T_e8_PresetType PresetType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_PresetType_IsValid(PresetType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", PresetType_, "T_e8_PresetType", "PresetType", "T_PresetList");
    }
    set_has_PresetType();
    this->_PresetType = PresetType_;
}

inline void T_PresetList::clearSXM360L_PresetListEntry() {
    if (hasSXM360L_PresetListEntry()) {
         clear_has_SXM360L_PresetListEntry();
        if (_SXM360L_PresetListEntry != NULL) {
            _SXM360L_PresetListEntry->clear();
        }
     }
}

inline bool T_PresetList::hasSXM360L_PresetListEntry () const {
    return (_has_bits_[0] & (1u << 25)) > 0;
}

inline const T_SXMChannelAttributes& T_PresetList::getSXM360L_PresetListEntry () const {
    if (_SXM360L_PresetListEntry == NULL) {
        return T_SXMChannelAttributes::getDefaultInstance();
    }
    return *_SXM360L_PresetListEntry;
}

inline T_SXMChannelAttributes& T_PresetList::getSXM360L_PresetListEntryMutable () {
    set_has_SXM360L_PresetListEntry();
    if (_SXM360L_PresetListEntry == NULL) {
        _SXM360L_PresetListEntry = new T_SXMChannelAttributes ();
        CHECK_ALLOCATION( _SXM360L_PresetListEntry );
    }
    return *_SXM360L_PresetListEntry;
}

inline void T_PresetList::setSXM360L_PresetListEntry (const T_SXMChannelAttributes& SXM360L_PresetListEntry_) {
    set_has_SXM360L_PresetListEntry();
    if (this->_SXM360L_PresetListEntry == NULL) {
        this->_SXM360L_PresetListEntry = new T_SXMChannelAttributes (SXM360L_PresetListEntry_);
        CHECK_ALLOCATION( this->_SXM360L_PresetListEntry );
    } else {
        *this->_SXM360L_PresetListEntry = SXM360L_PresetListEntry_;
    }
}

inline T_SXMChannelAttributes* T_PresetList::releaseSXM360L_PresetListEntry() {
    clear_has_SXM360L_PresetListEntry();
    T_SXMChannelAttributes* temp = _SXM360L_PresetListEntry;
    this->_SXM360L_PresetListEntry = NULL;
    return temp;
}

inline void T_PresetList::replaceSXM360L_PresetListEntry (T_SXMChannelAttributes* SXM360L_PresetListEntry_) {
    set_has_SXM360L_PresetListEntry();
    if (this->_SXM360L_PresetListEntry != SXM360L_PresetListEntry_) {
        if (this->_SXM360L_PresetListEntry != NULL) {
            delete this->_SXM360L_PresetListEntry;
        }
        this->_SXM360L_PresetListEntry = SXM360L_PresetListEntry_;
    }
}

inline void T_PresetList::set_has_List () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_PresetList::clear_has_List () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_PresetList::set_has_Band () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_PresetList::clear_has_Band () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_PresetList::set_has_Element_ID () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_PresetList::clear_has_Element_ID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_PresetList::set_has_Frequency () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_PresetList::clear_has_Frequency () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_PresetList::set_has_PSName () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_PresetList::clear_has_PSName () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_PresetList::set_has_u8TpTmcInfo () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_PresetList::clear_has_u8TpTmcInfo () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_PresetList::set_has_PTY () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_PresetList::clear_has_PTY () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_PresetList::set_has_EnsembleName () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_PresetList::clear_has_EnsembleName () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_PresetList::set_has_Frequency_Label () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_PresetList::clear_has_Frequency_Label () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_PresetList::set_has_StationLogo () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_PresetList::clear_has_StationLogo () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_PresetList::set_has_u32HDStationId () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_PresetList::clear_has_u32HDStationId () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_PresetList::set_has_sHDCallSign () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_PresetList::clear_has_sHDCallSign () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_PresetList::set_has_e8HDAudioProgram () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_PresetList::clear_has_e8HDAudioProgram () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_PresetList::set_has_u32DRMServiceId () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_PresetList::clear_has_u32DRMServiceId () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_PresetList::set_has_sDRMServiceLabel () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_PresetList::clear_has_sDRMServiceLabel () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_PresetList::set_has_u8DRMServiceShortId () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_PresetList::clear_has_u8DRMServiceShortId () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_PresetList::set_has_e8Modulation () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_PresetList::clear_has_e8Modulation () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void T_PresetList::set_has_u32HDStationId_DRMServiceId () {
    _has_bits_[0] |= 1u << 17;
}

inline void T_PresetList::clear_has_u32HDStationId_DRMServiceId () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline void T_PresetList::set_has_e8HDTextEncoding () {
    _has_bits_[0] |= 1u << 18;
}

inline void T_PresetList::clear_has_e8HDTextEncoding () {
    _has_bits_[0] &= ~ (1u << 18);
}

inline void T_PresetList::set_has_sHDCallSign_DRMServiceLabel () {
    _has_bits_[0] |= 1u << 19;
}

inline void T_PresetList::clear_has_sHDCallSign_DRMServiceLabel () {
    _has_bits_[0] &= ~ (1u << 19);
}

inline void T_PresetList::set_has_u8HDStationGenre_DRMPty () {
    _has_bits_[0] |= 1u << 20;
}

inline void T_PresetList::clear_has_u8HDStationGenre_DRMPty () {
    _has_bits_[0] &= ~ (1u << 20);
}

inline void T_PresetList::set_has_u8HDAudioProgram_DRMShortID () {
    _has_bits_[0] |= 1u << 21;
}

inline void T_PresetList::clear_has_u8HDAudioProgram_DRMShortID () {
    _has_bits_[0] &= ~ (1u << 21);
}

inline void T_PresetList::set_has_SXMSMSlib_PresetListEntry () {
    _has_bits_[0] |= 1u << 22;
}

inline void T_PresetList::clear_has_SXMSMSlib_PresetListEntry () {
    _has_bits_[0] &= ~ (1u << 22);
}

inline void T_PresetList::set_has_Key () {
    _has_bits_[0] |= 1u << 23;
}

inline void T_PresetList::clear_has_Key () {
    _has_bits_[0] &= ~ (1u << 23);
}

inline void T_PresetList::set_has_PresetType () {
    _has_bits_[0] |= 1u << 24;
}

inline void T_PresetList::clear_has_PresetType () {
    _has_bits_[0] &= ~ (1u << 24);
}

inline void T_PresetList::set_has_SXM360L_PresetListEntry () {
    _has_bits_[0] |= 1u << 25;
}

inline void T_PresetList::clear_has_SXM360L_PresetListEntry () {
    _has_bits_[0] &= ~ (1u << 25);
}

inline  T_SXMPresetEntry::T_SXMPresetEntry ()  :
    _PresetIndex (0u),
    _PresetElemID (0u),
    _Key (NULL),
    _PresetType (::midw_tunermaster_fi_types::T_e8_PresetType__Invalid),
    _ChannelAttributes (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SXMPresetEntry::T_SXMPresetEntry (const T_SXMPresetEntry &rhs)  :
    _PresetIndex (0u),
    _PresetElemID (0u),
    _Key (NULL),
    _PresetType (::midw_tunermaster_fi_types::T_e8_PresetType__Invalid),
    _ChannelAttributes (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SXMPresetEntry::T_SXMPresetEntry (uint8 PresetIndex_, uint32 PresetElemID_, const ::std::string& Key_, T_e8_PresetType PresetType_, const T_SXMChannelAttributes& ChannelAttributes_)  :
    _PresetIndex (PresetIndex_),
    _PresetElemID (PresetElemID_),
    _Key (new ::std::string(Key_)),
    _PresetType (PresetType_),
    _ChannelAttributes (new T_SXMChannelAttributes(ChannelAttributes_))
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Key_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_PresetType_IsValid(PresetType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", PresetType_, "T_e8_PresetType", "PresetType", "T_SXMPresetEntry");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SXMPresetEntry::~T_SXMPresetEntry() {
    delete _Key;
    delete _ChannelAttributes;
}

inline T_SXMPresetEntry& T_SXMPresetEntry::operator = (const T_SXMPresetEntry& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPresetIndex()) {
            setPresetIndex(rhs.getPresetIndex());
        } else {
            clearPresetIndex();
        }
        if (rhs.hasPresetElemID()) {
            setPresetElemID(rhs.getPresetElemID());
        } else {
            clearPresetElemID();
        }
        if (rhs.hasKey()) {
            setKey(rhs.getKey());
        } else {
            clearKey();
        }
        if (rhs.hasPresetType()) {
            setPresetType(rhs.getPresetType());
        } else {
            clearPresetType();
        }
        if (rhs.hasChannelAttributes()) {
            setChannelAttributes(rhs.getChannelAttributes());
        } else {
            clearChannelAttributes();
        }
    }
    return *this;
}

inline bool T_SXMPresetEntry::operator == (const T_SXMPresetEntry& rhs) const {
    return (((!hasPresetIndex() && !rhs.hasPresetIndex()) || getPresetIndex() == rhs.getPresetIndex()) &&
        ((!hasPresetElemID() && !rhs.hasPresetElemID()) || getPresetElemID() == rhs.getPresetElemID()) &&
        ((!hasKey() && !rhs.hasKey()) || getKey() == rhs.getKey()) &&
        ((!hasPresetType() && !rhs.hasPresetType()) || getPresetType() == rhs.getPresetType()) &&
        ((!hasChannelAttributes() && !rhs.hasChannelAttributes()) || getChannelAttributes() == rhs.getChannelAttributes()));
}

inline bool T_SXMPresetEntry::operator != (const T_SXMPresetEntry& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SXMPresetEntry::operator < (const T_SXMPresetEntry& rhs) const {
    if (hasPresetIndex() || rhs.hasPresetIndex()) {
        if (getPresetIndex() < rhs.getPresetIndex()) return true;
        if (getPresetIndex() > rhs.getPresetIndex()) return false;
    }
    if (hasPresetElemID() || rhs.hasPresetElemID()) {
        if (getPresetElemID() < rhs.getPresetElemID()) return true;
        if (getPresetElemID() > rhs.getPresetElemID()) return false;
    }
    if (hasKey() || rhs.hasKey()) {
        if (getKey() < rhs.getKey()) return true;
        if (getKey() > rhs.getKey()) return false;
    }
    if (hasPresetType() || rhs.hasPresetType()) {
        if ((uint32)getPresetType() < (uint32)rhs.getPresetType()) return true;
        if ((uint32)getPresetType() > (uint32)rhs.getPresetType()) return false;
    }
    if (hasChannelAttributes() || rhs.hasChannelAttributes()) {
        if (getChannelAttributes() < rhs.getChannelAttributes()) return true;
        if (getChannelAttributes() > rhs.getChannelAttributes()) return false;
    }
    return false;
}

inline bool T_SXMPresetEntry::operator > (const T_SXMPresetEntry& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SXMPresetEntry::clear() {
    clearPresetIndex();
    clearPresetElemID();
    clearKey();
    clearPresetType();
    clearChannelAttributes();
}

inline void T_SXMPresetEntry::clearPresetIndex() {
    if (hasPresetIndex()) {
         clear_has_PresetIndex();
        _PresetIndex = 0u;
     }
}

inline bool T_SXMPresetEntry::hasPresetIndex () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_SXMPresetEntry::getPresetIndex () const {
    return _PresetIndex;
}

inline void T_SXMPresetEntry::setPresetIndex (uint8 PresetIndex_) {
    set_has_PresetIndex();
    this->_PresetIndex = PresetIndex_;
}

inline void T_SXMPresetEntry::clearPresetElemID() {
    if (hasPresetElemID()) {
         clear_has_PresetElemID();
        _PresetElemID = 0u;
     }
}

inline bool T_SXMPresetEntry::hasPresetElemID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_SXMPresetEntry::getPresetElemID () const {
    return _PresetElemID;
}

inline void T_SXMPresetEntry::setPresetElemID (uint32 PresetElemID_) {
    set_has_PresetElemID();
    this->_PresetElemID = PresetElemID_;
}

inline void T_SXMPresetEntry::clearKey() {
    if (hasKey()) {
         clear_has_Key();
        if (_Key != NULL) {
            _Key->clear();
        }
     }
}

inline bool T_SXMPresetEntry::hasKey () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_SXMPresetEntry::getKey () const {
    if (_Key == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_Key;
}

inline ::std::string& T_SXMPresetEntry::getKeyMutable () {
    set_has_Key();
    if (_Key == NULL) {
        _Key = new ::std::string ();
        CHECK_ALLOCATION( _Key );
    }
    return *_Key;
}

inline void T_SXMPresetEntry::setKey (const ::std::string& Key_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Key_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Key();
    if (this->_Key == NULL) {
        this->_Key = new ::std::string (Key_);
        CHECK_ALLOCATION( this->_Key );
    } else {
        *this->_Key = Key_;
    }
}

inline void T_SXMPresetEntry::setKey (const char* Key_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Key_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Key();
    if (this->_Key == NULL) {
        this->_Key = new ::std::string (Key_);
        CHECK_ALLOCATION( this->_Key );
    } else {
        this->_Key->assign(Key_);
    }
}

inline void T_SXMPresetEntry::setKey (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Key();
    if (this->_Key == NULL) {
        this->_Key = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_Key );
    } else {
        this->_Key->assign(value, size);
    }
}

inline ::std::string* T_SXMPresetEntry::releaseKey() {
    clear_has_Key();
    ::std::string* temp = _Key;
    this->_Key = NULL;
    return temp;
}

inline void T_SXMPresetEntry::replaceKey (::std::string* Key_) {
    set_has_Key();
    if (this->_Key != Key_) {
        if (this->_Key != NULL) {
            delete this->_Key;
        }
        this->_Key = Key_;
    }
}

inline void T_SXMPresetEntry::clearPresetType() {
    if (hasPresetType()) {
         clear_has_PresetType();
        _PresetType = ::midw_tunermaster_fi_types::T_e8_PresetType__Invalid;
     }
}

inline bool T_SXMPresetEntry::hasPresetType () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_PresetType T_SXMPresetEntry::getPresetType () const {
    return _PresetType;
}

inline void T_SXMPresetEntry::setPresetType (T_e8_PresetType PresetType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_PresetType_IsValid(PresetType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", PresetType_, "T_e8_PresetType", "PresetType", "T_SXMPresetEntry");
    }
    set_has_PresetType();
    this->_PresetType = PresetType_;
}

inline void T_SXMPresetEntry::clearChannelAttributes() {
    if (hasChannelAttributes()) {
         clear_has_ChannelAttributes();
        if (_ChannelAttributes != NULL) {
            _ChannelAttributes->clear();
        }
     }
}

inline bool T_SXMPresetEntry::hasChannelAttributes () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const T_SXMChannelAttributes& T_SXMPresetEntry::getChannelAttributes () const {
    if (_ChannelAttributes == NULL) {
        return T_SXMChannelAttributes::getDefaultInstance();
    }
    return *_ChannelAttributes;
}

inline T_SXMChannelAttributes& T_SXMPresetEntry::getChannelAttributesMutable () {
    set_has_ChannelAttributes();
    if (_ChannelAttributes == NULL) {
        _ChannelAttributes = new T_SXMChannelAttributes ();
        CHECK_ALLOCATION( _ChannelAttributes );
    }
    return *_ChannelAttributes;
}

inline void T_SXMPresetEntry::setChannelAttributes (const T_SXMChannelAttributes& ChannelAttributes_) {
    set_has_ChannelAttributes();
    if (this->_ChannelAttributes == NULL) {
        this->_ChannelAttributes = new T_SXMChannelAttributes (ChannelAttributes_);
        CHECK_ALLOCATION( this->_ChannelAttributes );
    } else {
        *this->_ChannelAttributes = ChannelAttributes_;
    }
}

inline T_SXMChannelAttributes* T_SXMPresetEntry::releaseChannelAttributes() {
    clear_has_ChannelAttributes();
    T_SXMChannelAttributes* temp = _ChannelAttributes;
    this->_ChannelAttributes = NULL;
    return temp;
}

inline void T_SXMPresetEntry::replaceChannelAttributes (T_SXMChannelAttributes* ChannelAttributes_) {
    set_has_ChannelAttributes();
    if (this->_ChannelAttributes != ChannelAttributes_) {
        if (this->_ChannelAttributes != NULL) {
            delete this->_ChannelAttributes;
        }
        this->_ChannelAttributes = ChannelAttributes_;
    }
}

inline void T_SXMPresetEntry::set_has_PresetIndex () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SXMPresetEntry::clear_has_PresetIndex () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SXMPresetEntry::set_has_PresetElemID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SXMPresetEntry::clear_has_PresetElemID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SXMPresetEntry::set_has_Key () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SXMPresetEntry::clear_has_Key () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SXMPresetEntry::set_has_PresetType () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SXMPresetEntry::clear_has_PresetType () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_SXMPresetEntry::set_has_ChannelAttributes () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_SXMPresetEntry::clear_has_ChannelAttributes () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_SXMChannelImagedata::T_SXMChannelImagedata ()  :
    _SID (0u),
    _ImageData (NULL),
    _ImageDataSize (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SXMChannelImagedata::T_SXMChannelImagedata (const T_SXMChannelImagedata &rhs)  :
    _SID (0u),
    _ImageData (NULL),
    _ImageDataSize (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SXMChannelImagedata::T_SXMChannelImagedata (uint16 SID_, const ::std::vector< uint8 >& ImageData_, uint32 ImageDataSize_)  :
    _SID (SID_),
    _ImageData (new ::std::vector< uint8 >(ImageData_)),
    _ImageDataSize (ImageDataSize_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SXMChannelImagedata::~T_SXMChannelImagedata() {
    delete _ImageData;
}

inline T_SXMChannelImagedata& T_SXMChannelImagedata::operator = (const T_SXMChannelImagedata& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSID()) {
            setSID(rhs.getSID());
        } else {
            clearSID();
        }
        if (rhs.hasImageData()) {
            setImageData(rhs.getImageData());
        } else {
            clearImageData();
        }
        if (rhs.hasImageDataSize()) {
            setImageDataSize(rhs.getImageDataSize());
        } else {
            clearImageDataSize();
        }
    }
    return *this;
}

inline bool T_SXMChannelImagedata::operator == (const T_SXMChannelImagedata& rhs) const {
    return (((!hasSID() && !rhs.hasSID()) || getSID() == rhs.getSID()) &&
        ((!hasImageData() && !rhs.hasImageData()) || getImageData() == rhs.getImageData()) &&
        ((!hasImageDataSize() && !rhs.hasImageDataSize()) || getImageDataSize() == rhs.getImageDataSize()));
}

inline bool T_SXMChannelImagedata::operator != (const T_SXMChannelImagedata& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SXMChannelImagedata::operator < (const T_SXMChannelImagedata& rhs) const {
    if (hasSID() || rhs.hasSID()) {
        if (getSID() < rhs.getSID()) return true;
        if (getSID() > rhs.getSID()) return false;
    }
    if (hasImageData() || rhs.hasImageData()) {
        if (getImageData() < rhs.getImageData()) return true;
        if (getImageData() > rhs.getImageData()) return false;
    }
    if (hasImageDataSize() || rhs.hasImageDataSize()) {
        if (getImageDataSize() < rhs.getImageDataSize()) return true;
        if (getImageDataSize() > rhs.getImageDataSize()) return false;
    }
    return false;
}

inline bool T_SXMChannelImagedata::operator > (const T_SXMChannelImagedata& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SXMChannelImagedata::clear() {
    clearSID();
    clearImageData();
    clearImageDataSize();
}

inline void T_SXMChannelImagedata::clearSID() {
    if (hasSID()) {
         clear_has_SID();
        _SID = 0u;
     }
}

inline bool T_SXMChannelImagedata::hasSID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_SXMChannelImagedata::getSID () const {
    return _SID;
}

inline void T_SXMChannelImagedata::setSID (uint16 SID_) {
    set_has_SID();
    this->_SID = SID_;
}

inline void T_SXMChannelImagedata::clearImageData() {
    if (hasImageData()) {
         clear_has_ImageData();
        if (_ImageData != NULL) {
            _ImageData->clear();
        }
     }
}

inline bool T_SXMChannelImagedata::hasImageData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint8 >& T_SXMChannelImagedata::getImageData () const {
    if (_ImageData == NULL) {
        return getUint8List_DefaultInstance();
    }
    return *_ImageData;
}

inline ::std::vector< uint8 >& T_SXMChannelImagedata::getImageDataMutable () {
    set_has_ImageData();
    if (_ImageData == NULL) {
        _ImageData = new ::std::vector< uint8 > ();
        CHECK_ALLOCATION( _ImageData );
    }
    return *_ImageData;
}

inline void T_SXMChannelImagedata::setImageData (const ::std::vector< uint8 >& ImageData_) {
    set_has_ImageData();
    if (this->_ImageData == NULL) {
        this->_ImageData = new ::std::vector< uint8 > (ImageData_);
        CHECK_ALLOCATION( this->_ImageData );
    } else {
        *this->_ImageData = ImageData_;
    }
}

inline ::std::vector< uint8 >* T_SXMChannelImagedata::releaseImageData() {
    clear_has_ImageData();
    ::std::vector< uint8 >* temp = _ImageData;
    this->_ImageData = NULL;
    return temp;
}

inline void T_SXMChannelImagedata::replaceImageData (::std::vector< uint8 >* ImageData_) {
    set_has_ImageData();
    if (this->_ImageData != ImageData_) {
        if (this->_ImageData != NULL) {
            delete this->_ImageData;
        }
        this->_ImageData = ImageData_;
    }
}

inline void T_SXMChannelImagedata::clearImageDataSize() {
    if (hasImageDataSize()) {
         clear_has_ImageDataSize();
        _ImageDataSize = 0u;
     }
}

inline bool T_SXMChannelImagedata::hasImageDataSize () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_SXMChannelImagedata::getImageDataSize () const {
    return _ImageDataSize;
}

inline void T_SXMChannelImagedata::setImageDataSize (uint32 ImageDataSize_) {
    set_has_ImageDataSize();
    this->_ImageDataSize = ImageDataSize_;
}

inline void T_SXMChannelImagedata::set_has_SID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SXMChannelImagedata::clear_has_SID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SXMChannelImagedata::set_has_ImageData () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SXMChannelImagedata::clear_has_ImageData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SXMChannelImagedata::set_has_ImageDataSize () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SXMChannelImagedata::clear_has_ImageDataSize () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_b32_AnnoType::T_b32_AnnoType ()  :
    _TUNMSTR_ANNOTYPE_PTY (false),
    _TUNMSTR_ANNOTYPE_TA (false),
    _TUNMSTR_ANNOTYPE_TRANSPORT (false),
    _TUNMSTR_ANNOTYPE_WARNING (false),
    _TUNMSTR_ANNOTYPE_NEWS (false),
    _TUNMSTR_ANNOTYPE_WEATHER (false),
    _TUNMSTR_ANNOTYPE_EVENT (false),
    _TUNMSTR_ANNOTYPE_SPECIALEVENT (false),
    _TUNMSTR_ANNOTYPE_PROGRAMME (false),
    _TUNMSTR_ANNOTYPE_SPORTS (false),
    _TUNMSTR_ANNOTYPE_FINANCE (false),
    _TUNMSTR_ANNOTYPE_WEATHERALERT (false)
{
}

inline  T_b32_AnnoType::T_b32_AnnoType (const T_b32_AnnoType &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b32_AnnoType::T_b32_AnnoType (bool TUNMSTR_ANNOTYPE_PTY, bool TUNMSTR_ANNOTYPE_TA, bool TUNMSTR_ANNOTYPE_TRANSPORT, bool TUNMSTR_ANNOTYPE_WARNING, bool TUNMSTR_ANNOTYPE_NEWS, bool TUNMSTR_ANNOTYPE_WEATHER, bool TUNMSTR_ANNOTYPE_EVENT, bool TUNMSTR_ANNOTYPE_SPECIALEVENT, bool TUNMSTR_ANNOTYPE_PROGRAMME, bool TUNMSTR_ANNOTYPE_SPORTS, bool TUNMSTR_ANNOTYPE_FINANCE, bool TUNMSTR_ANNOTYPE_WEATHERALERT) :
    _TUNMSTR_ANNOTYPE_PTY (TUNMSTR_ANNOTYPE_PTY),
    _TUNMSTR_ANNOTYPE_TA (TUNMSTR_ANNOTYPE_TA),
    _TUNMSTR_ANNOTYPE_TRANSPORT (TUNMSTR_ANNOTYPE_TRANSPORT),
    _TUNMSTR_ANNOTYPE_WARNING (TUNMSTR_ANNOTYPE_WARNING),
    _TUNMSTR_ANNOTYPE_NEWS (TUNMSTR_ANNOTYPE_NEWS),
    _TUNMSTR_ANNOTYPE_WEATHER (TUNMSTR_ANNOTYPE_WEATHER),
    _TUNMSTR_ANNOTYPE_EVENT (TUNMSTR_ANNOTYPE_EVENT),
    _TUNMSTR_ANNOTYPE_SPECIALEVENT (TUNMSTR_ANNOTYPE_SPECIALEVENT),
    _TUNMSTR_ANNOTYPE_PROGRAMME (TUNMSTR_ANNOTYPE_PROGRAMME),
    _TUNMSTR_ANNOTYPE_SPORTS (TUNMSTR_ANNOTYPE_SPORTS),
    _TUNMSTR_ANNOTYPE_FINANCE (TUNMSTR_ANNOTYPE_FINANCE),
    _TUNMSTR_ANNOTYPE_WEATHERALERT (TUNMSTR_ANNOTYPE_WEATHERALERT)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b32_AnnoType& T_b32_AnnoType::operator = (const T_b32_AnnoType& rhs) {
    if( this != &rhs ) {
        _TUNMSTR_ANNOTYPE_PTY = rhs._TUNMSTR_ANNOTYPE_PTY;
        _TUNMSTR_ANNOTYPE_TA = rhs._TUNMSTR_ANNOTYPE_TA;
        _TUNMSTR_ANNOTYPE_TRANSPORT = rhs._TUNMSTR_ANNOTYPE_TRANSPORT;
        _TUNMSTR_ANNOTYPE_WARNING = rhs._TUNMSTR_ANNOTYPE_WARNING;
        _TUNMSTR_ANNOTYPE_NEWS = rhs._TUNMSTR_ANNOTYPE_NEWS;
        _TUNMSTR_ANNOTYPE_WEATHER = rhs._TUNMSTR_ANNOTYPE_WEATHER;
        _TUNMSTR_ANNOTYPE_EVENT = rhs._TUNMSTR_ANNOTYPE_EVENT;
        _TUNMSTR_ANNOTYPE_SPECIALEVENT = rhs._TUNMSTR_ANNOTYPE_SPECIALEVENT;
        _TUNMSTR_ANNOTYPE_PROGRAMME = rhs._TUNMSTR_ANNOTYPE_PROGRAMME;
        _TUNMSTR_ANNOTYPE_SPORTS = rhs._TUNMSTR_ANNOTYPE_SPORTS;
        _TUNMSTR_ANNOTYPE_FINANCE = rhs._TUNMSTR_ANNOTYPE_FINANCE;
        _TUNMSTR_ANNOTYPE_WEATHERALERT = rhs._TUNMSTR_ANNOTYPE_WEATHERALERT;
    }
    return *this;
}

inline bool T_b32_AnnoType::operator == (const T_b32_AnnoType& rhs) const {
    return (_TUNMSTR_ANNOTYPE_PTY == rhs._TUNMSTR_ANNOTYPE_PTY &&
        _TUNMSTR_ANNOTYPE_TA == rhs._TUNMSTR_ANNOTYPE_TA &&
        _TUNMSTR_ANNOTYPE_TRANSPORT == rhs._TUNMSTR_ANNOTYPE_TRANSPORT &&
        _TUNMSTR_ANNOTYPE_WARNING == rhs._TUNMSTR_ANNOTYPE_WARNING &&
        _TUNMSTR_ANNOTYPE_NEWS == rhs._TUNMSTR_ANNOTYPE_NEWS &&
        _TUNMSTR_ANNOTYPE_WEATHER == rhs._TUNMSTR_ANNOTYPE_WEATHER &&
        _TUNMSTR_ANNOTYPE_EVENT == rhs._TUNMSTR_ANNOTYPE_EVENT &&
        _TUNMSTR_ANNOTYPE_SPECIALEVENT == rhs._TUNMSTR_ANNOTYPE_SPECIALEVENT &&
        _TUNMSTR_ANNOTYPE_PROGRAMME == rhs._TUNMSTR_ANNOTYPE_PROGRAMME &&
        _TUNMSTR_ANNOTYPE_SPORTS == rhs._TUNMSTR_ANNOTYPE_SPORTS &&
        _TUNMSTR_ANNOTYPE_FINANCE == rhs._TUNMSTR_ANNOTYPE_FINANCE &&
        _TUNMSTR_ANNOTYPE_WEATHERALERT == rhs._TUNMSTR_ANNOTYPE_WEATHERALERT);
}

inline bool T_b32_AnnoType::operator != (const T_b32_AnnoType& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b32_AnnoType::operator < (const T_b32_AnnoType& rhs) const {
    if (getTUNMSTR_ANNOTYPE_PTY() < rhs.getTUNMSTR_ANNOTYPE_PTY()) return true;
    if (getTUNMSTR_ANNOTYPE_PTY() > rhs.getTUNMSTR_ANNOTYPE_PTY()) return false;

    if (getTUNMSTR_ANNOTYPE_TA() < rhs.getTUNMSTR_ANNOTYPE_TA()) return true;
    if (getTUNMSTR_ANNOTYPE_TA() > rhs.getTUNMSTR_ANNOTYPE_TA()) return false;

    if (getTUNMSTR_ANNOTYPE_TRANSPORT() < rhs.getTUNMSTR_ANNOTYPE_TRANSPORT()) return true;
    if (getTUNMSTR_ANNOTYPE_TRANSPORT() > rhs.getTUNMSTR_ANNOTYPE_TRANSPORT()) return false;

    if (getTUNMSTR_ANNOTYPE_WARNING() < rhs.getTUNMSTR_ANNOTYPE_WARNING()) return true;
    if (getTUNMSTR_ANNOTYPE_WARNING() > rhs.getTUNMSTR_ANNOTYPE_WARNING()) return false;

    if (getTUNMSTR_ANNOTYPE_NEWS() < rhs.getTUNMSTR_ANNOTYPE_NEWS()) return true;
    if (getTUNMSTR_ANNOTYPE_NEWS() > rhs.getTUNMSTR_ANNOTYPE_NEWS()) return false;

    if (getTUNMSTR_ANNOTYPE_WEATHER() < rhs.getTUNMSTR_ANNOTYPE_WEATHER()) return true;
    if (getTUNMSTR_ANNOTYPE_WEATHER() > rhs.getTUNMSTR_ANNOTYPE_WEATHER()) return false;

    if (getTUNMSTR_ANNOTYPE_EVENT() < rhs.getTUNMSTR_ANNOTYPE_EVENT()) return true;
    if (getTUNMSTR_ANNOTYPE_EVENT() > rhs.getTUNMSTR_ANNOTYPE_EVENT()) return false;

    if (getTUNMSTR_ANNOTYPE_SPECIALEVENT() < rhs.getTUNMSTR_ANNOTYPE_SPECIALEVENT()) return true;
    if (getTUNMSTR_ANNOTYPE_SPECIALEVENT() > rhs.getTUNMSTR_ANNOTYPE_SPECIALEVENT()) return false;

    if (getTUNMSTR_ANNOTYPE_PROGRAMME() < rhs.getTUNMSTR_ANNOTYPE_PROGRAMME()) return true;
    if (getTUNMSTR_ANNOTYPE_PROGRAMME() > rhs.getTUNMSTR_ANNOTYPE_PROGRAMME()) return false;

    if (getTUNMSTR_ANNOTYPE_SPORTS() < rhs.getTUNMSTR_ANNOTYPE_SPORTS()) return true;
    if (getTUNMSTR_ANNOTYPE_SPORTS() > rhs.getTUNMSTR_ANNOTYPE_SPORTS()) return false;

    if (getTUNMSTR_ANNOTYPE_FINANCE() < rhs.getTUNMSTR_ANNOTYPE_FINANCE()) return true;
    if (getTUNMSTR_ANNOTYPE_FINANCE() > rhs.getTUNMSTR_ANNOTYPE_FINANCE()) return false;

    if (getTUNMSTR_ANNOTYPE_WEATHERALERT() < rhs.getTUNMSTR_ANNOTYPE_WEATHERALERT()) return true;
    if (getTUNMSTR_ANNOTYPE_WEATHERALERT() > rhs.getTUNMSTR_ANNOTYPE_WEATHERALERT()) return false;

    return false;
}

inline bool T_b32_AnnoType::operator > (const T_b32_AnnoType& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b32_AnnoType::setTUNMSTR_ANNOTYPE_PTY (bool TUNMSTR_ANNOTYPE_PTY) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUNMSTR_ANNOTYPE_PTY = TUNMSTR_ANNOTYPE_PTY;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_AnnoType::getTUNMSTR_ANNOTYPE_PTY () const {
    return _TUNMSTR_ANNOTYPE_PTY;
}

inline void T_b32_AnnoType::setTUNMSTR_ANNOTYPE_TA (bool TUNMSTR_ANNOTYPE_TA) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUNMSTR_ANNOTYPE_TA = TUNMSTR_ANNOTYPE_TA;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_AnnoType::getTUNMSTR_ANNOTYPE_TA () const {
    return _TUNMSTR_ANNOTYPE_TA;
}

inline void T_b32_AnnoType::setTUNMSTR_ANNOTYPE_TRANSPORT (bool TUNMSTR_ANNOTYPE_TRANSPORT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUNMSTR_ANNOTYPE_TRANSPORT = TUNMSTR_ANNOTYPE_TRANSPORT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_AnnoType::getTUNMSTR_ANNOTYPE_TRANSPORT () const {
    return _TUNMSTR_ANNOTYPE_TRANSPORT;
}

inline void T_b32_AnnoType::setTUNMSTR_ANNOTYPE_WARNING (bool TUNMSTR_ANNOTYPE_WARNING) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUNMSTR_ANNOTYPE_WARNING = TUNMSTR_ANNOTYPE_WARNING;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_AnnoType::getTUNMSTR_ANNOTYPE_WARNING () const {
    return _TUNMSTR_ANNOTYPE_WARNING;
}

inline void T_b32_AnnoType::setTUNMSTR_ANNOTYPE_NEWS (bool TUNMSTR_ANNOTYPE_NEWS) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUNMSTR_ANNOTYPE_NEWS = TUNMSTR_ANNOTYPE_NEWS;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_AnnoType::getTUNMSTR_ANNOTYPE_NEWS () const {
    return _TUNMSTR_ANNOTYPE_NEWS;
}

inline void T_b32_AnnoType::setTUNMSTR_ANNOTYPE_WEATHER (bool TUNMSTR_ANNOTYPE_WEATHER) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUNMSTR_ANNOTYPE_WEATHER = TUNMSTR_ANNOTYPE_WEATHER;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_AnnoType::getTUNMSTR_ANNOTYPE_WEATHER () const {
    return _TUNMSTR_ANNOTYPE_WEATHER;
}

inline void T_b32_AnnoType::setTUNMSTR_ANNOTYPE_EVENT (bool TUNMSTR_ANNOTYPE_EVENT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUNMSTR_ANNOTYPE_EVENT = TUNMSTR_ANNOTYPE_EVENT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_AnnoType::getTUNMSTR_ANNOTYPE_EVENT () const {
    return _TUNMSTR_ANNOTYPE_EVENT;
}

inline void T_b32_AnnoType::setTUNMSTR_ANNOTYPE_SPECIALEVENT (bool TUNMSTR_ANNOTYPE_SPECIALEVENT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUNMSTR_ANNOTYPE_SPECIALEVENT = TUNMSTR_ANNOTYPE_SPECIALEVENT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_AnnoType::getTUNMSTR_ANNOTYPE_SPECIALEVENT () const {
    return _TUNMSTR_ANNOTYPE_SPECIALEVENT;
}

inline void T_b32_AnnoType::setTUNMSTR_ANNOTYPE_PROGRAMME (bool TUNMSTR_ANNOTYPE_PROGRAMME) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUNMSTR_ANNOTYPE_PROGRAMME = TUNMSTR_ANNOTYPE_PROGRAMME;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_AnnoType::getTUNMSTR_ANNOTYPE_PROGRAMME () const {
    return _TUNMSTR_ANNOTYPE_PROGRAMME;
}

inline void T_b32_AnnoType::setTUNMSTR_ANNOTYPE_SPORTS (bool TUNMSTR_ANNOTYPE_SPORTS) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUNMSTR_ANNOTYPE_SPORTS = TUNMSTR_ANNOTYPE_SPORTS;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_AnnoType::getTUNMSTR_ANNOTYPE_SPORTS () const {
    return _TUNMSTR_ANNOTYPE_SPORTS;
}

inline void T_b32_AnnoType::setTUNMSTR_ANNOTYPE_FINANCE (bool TUNMSTR_ANNOTYPE_FINANCE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUNMSTR_ANNOTYPE_FINANCE = TUNMSTR_ANNOTYPE_FINANCE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_AnnoType::getTUNMSTR_ANNOTYPE_FINANCE () const {
    return _TUNMSTR_ANNOTYPE_FINANCE;
}

inline void T_b32_AnnoType::setTUNMSTR_ANNOTYPE_WEATHERALERT (bool TUNMSTR_ANNOTYPE_WEATHERALERT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUNMSTR_ANNOTYPE_WEATHERALERT = TUNMSTR_ANNOTYPE_WEATHERALERT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_AnnoType::getTUNMSTR_ANNOTYPE_WEATHERALERT () const {
    return _TUNMSTR_ANNOTYPE_WEATHERALERT;
}

inline  T_b8_SourceAnno::T_b8_SourceAnno ()  :
    _TUNMSTR_ANNOSRC_FM (false),
    _TUNMSTR_ANNOSRC_DAB (false),
    _TUNMSTR_ANNOSRC_WEATHER (false)
{
}

inline  T_b8_SourceAnno::T_b8_SourceAnno (const T_b8_SourceAnno &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_SourceAnno::T_b8_SourceAnno (bool TUNMSTR_ANNOSRC_FM, bool TUNMSTR_ANNOSRC_DAB, bool TUNMSTR_ANNOSRC_WEATHER) :
    _TUNMSTR_ANNOSRC_FM (TUNMSTR_ANNOSRC_FM),
    _TUNMSTR_ANNOSRC_DAB (TUNMSTR_ANNOSRC_DAB),
    _TUNMSTR_ANNOSRC_WEATHER (TUNMSTR_ANNOSRC_WEATHER)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_SourceAnno& T_b8_SourceAnno::operator = (const T_b8_SourceAnno& rhs) {
    if( this != &rhs ) {
        _TUNMSTR_ANNOSRC_FM = rhs._TUNMSTR_ANNOSRC_FM;
        _TUNMSTR_ANNOSRC_DAB = rhs._TUNMSTR_ANNOSRC_DAB;
        _TUNMSTR_ANNOSRC_WEATHER = rhs._TUNMSTR_ANNOSRC_WEATHER;
    }
    return *this;
}

inline bool T_b8_SourceAnno::operator == (const T_b8_SourceAnno& rhs) const {
    return (_TUNMSTR_ANNOSRC_FM == rhs._TUNMSTR_ANNOSRC_FM &&
        _TUNMSTR_ANNOSRC_DAB == rhs._TUNMSTR_ANNOSRC_DAB &&
        _TUNMSTR_ANNOSRC_WEATHER == rhs._TUNMSTR_ANNOSRC_WEATHER);
}

inline bool T_b8_SourceAnno::operator != (const T_b8_SourceAnno& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_SourceAnno::operator < (const T_b8_SourceAnno& rhs) const {
    if (getTUNMSTR_ANNOSRC_FM() < rhs.getTUNMSTR_ANNOSRC_FM()) return true;
    if (getTUNMSTR_ANNOSRC_FM() > rhs.getTUNMSTR_ANNOSRC_FM()) return false;

    if (getTUNMSTR_ANNOSRC_DAB() < rhs.getTUNMSTR_ANNOSRC_DAB()) return true;
    if (getTUNMSTR_ANNOSRC_DAB() > rhs.getTUNMSTR_ANNOSRC_DAB()) return false;

    if (getTUNMSTR_ANNOSRC_WEATHER() < rhs.getTUNMSTR_ANNOSRC_WEATHER()) return true;
    if (getTUNMSTR_ANNOSRC_WEATHER() > rhs.getTUNMSTR_ANNOSRC_WEATHER()) return false;

    return false;
}

inline bool T_b8_SourceAnno::operator > (const T_b8_SourceAnno& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_SourceAnno::setTUNMSTR_ANNOSRC_FM (bool TUNMSTR_ANNOSRC_FM) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUNMSTR_ANNOSRC_FM = TUNMSTR_ANNOSRC_FM;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_SourceAnno::getTUNMSTR_ANNOSRC_FM () const {
    return _TUNMSTR_ANNOSRC_FM;
}

inline void T_b8_SourceAnno::setTUNMSTR_ANNOSRC_DAB (bool TUNMSTR_ANNOSRC_DAB) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUNMSTR_ANNOSRC_DAB = TUNMSTR_ANNOSRC_DAB;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_SourceAnno::getTUNMSTR_ANNOSRC_DAB () const {
    return _TUNMSTR_ANNOSRC_DAB;
}

inline void T_b8_SourceAnno::setTUNMSTR_ANNOSRC_WEATHER (bool TUNMSTR_ANNOSRC_WEATHER) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUNMSTR_ANNOSRC_WEATHER = TUNMSTR_ANNOSRC_WEATHER;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_SourceAnno::getTUNMSTR_ANNOSRC_WEATHER () const {
    return _TUNMSTR_ANNOSRC_WEATHER;
}

inline  T_b8_ModeType::T_b8_ModeType ()  :
    _TUNMSTR_SF_FM (false),
    _TUNMSTR_SF_DAB (false),
    _TUNMSTR_SF_NONE (false)
{
}

inline  T_b8_ModeType::T_b8_ModeType (const T_b8_ModeType &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_ModeType::T_b8_ModeType (bool TUNMSTR_SF_FM, bool TUNMSTR_SF_DAB, bool TUNMSTR_SF_NONE) :
    _TUNMSTR_SF_FM (TUNMSTR_SF_FM),
    _TUNMSTR_SF_DAB (TUNMSTR_SF_DAB),
    _TUNMSTR_SF_NONE (TUNMSTR_SF_NONE)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_ModeType& T_b8_ModeType::operator = (const T_b8_ModeType& rhs) {
    if( this != &rhs ) {
        _TUNMSTR_SF_FM = rhs._TUNMSTR_SF_FM;
        _TUNMSTR_SF_DAB = rhs._TUNMSTR_SF_DAB;
        _TUNMSTR_SF_NONE = rhs._TUNMSTR_SF_NONE;
    }
    return *this;
}

inline bool T_b8_ModeType::operator == (const T_b8_ModeType& rhs) const {
    return (_TUNMSTR_SF_FM == rhs._TUNMSTR_SF_FM &&
        _TUNMSTR_SF_DAB == rhs._TUNMSTR_SF_DAB &&
        _TUNMSTR_SF_NONE == rhs._TUNMSTR_SF_NONE);
}

inline bool T_b8_ModeType::operator != (const T_b8_ModeType& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_ModeType::operator < (const T_b8_ModeType& rhs) const {
    if (getTUNMSTR_SF_FM() < rhs.getTUNMSTR_SF_FM()) return true;
    if (getTUNMSTR_SF_FM() > rhs.getTUNMSTR_SF_FM()) return false;

    if (getTUNMSTR_SF_DAB() < rhs.getTUNMSTR_SF_DAB()) return true;
    if (getTUNMSTR_SF_DAB() > rhs.getTUNMSTR_SF_DAB()) return false;

    if (getTUNMSTR_SF_NONE() < rhs.getTUNMSTR_SF_NONE()) return true;
    if (getTUNMSTR_SF_NONE() > rhs.getTUNMSTR_SF_NONE()) return false;

    return false;
}

inline bool T_b8_ModeType::operator > (const T_b8_ModeType& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_ModeType::setTUNMSTR_SF_FM (bool TUNMSTR_SF_FM) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUNMSTR_SF_FM = TUNMSTR_SF_FM;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_ModeType::getTUNMSTR_SF_FM () const {
    return _TUNMSTR_SF_FM;
}

inline void T_b8_ModeType::setTUNMSTR_SF_DAB (bool TUNMSTR_SF_DAB) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUNMSTR_SF_DAB = TUNMSTR_SF_DAB;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_ModeType::getTUNMSTR_SF_DAB () const {
    return _TUNMSTR_SF_DAB;
}

inline void T_b8_ModeType::setTUNMSTR_SF_NONE (bool TUNMSTR_SF_NONE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUNMSTR_SF_NONE = TUNMSTR_SF_NONE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_ModeType::getTUNMSTR_SF_NONE () const {
    return _TUNMSTR_SF_NONE;
}

inline  T_DAB_Label::T_DAB_Label ()  :
    _sLabel (NULL),
    _sLabelShort (NULL),
    _u16LabelMask (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DAB_Label::T_DAB_Label (const T_DAB_Label &rhs)  :
    _sLabel (NULL),
    _sLabelShort (NULL),
    _u16LabelMask (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DAB_Label::T_DAB_Label (const ::std::string& sLabel_, const ::std::string& sLabelShort_, uint16 u16LabelMask_)  :
    _sLabel (new ::std::string(sLabel_)),
    _sLabelShort (new ::std::string(sLabelShort_)),
    _u16LabelMask (u16LabelMask_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLabelShort_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DAB_Label::~T_DAB_Label() {
    delete _sLabel;
    delete _sLabelShort;
}

inline T_DAB_Label& T_DAB_Label::operator = (const T_DAB_Label& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSLabel()) {
            setSLabel(rhs.getSLabel());
        } else {
            clearSLabel();
        }
        if (rhs.hasSLabelShort()) {
            setSLabelShort(rhs.getSLabelShort());
        } else {
            clearSLabelShort();
        }
        if (rhs.hasU16LabelMask()) {
            setU16LabelMask(rhs.getU16LabelMask());
        } else {
            clearU16LabelMask();
        }
    }
    return *this;
}

inline bool T_DAB_Label::operator == (const T_DAB_Label& rhs) const {
    return (((!hasSLabel() && !rhs.hasSLabel()) || getSLabel() == rhs.getSLabel()) &&
        ((!hasSLabelShort() && !rhs.hasSLabelShort()) || getSLabelShort() == rhs.getSLabelShort()) &&
        ((!hasU16LabelMask() && !rhs.hasU16LabelMask()) || getU16LabelMask() == rhs.getU16LabelMask()));
}

inline bool T_DAB_Label::operator != (const T_DAB_Label& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DAB_Label::operator < (const T_DAB_Label& rhs) const {
    if (hasSLabel() || rhs.hasSLabel()) {
        if (getSLabel() < rhs.getSLabel()) return true;
        if (getSLabel() > rhs.getSLabel()) return false;
    }
    if (hasSLabelShort() || rhs.hasSLabelShort()) {
        if (getSLabelShort() < rhs.getSLabelShort()) return true;
        if (getSLabelShort() > rhs.getSLabelShort()) return false;
    }
    if (hasU16LabelMask() || rhs.hasU16LabelMask()) {
        if (getU16LabelMask() < rhs.getU16LabelMask()) return true;
        if (getU16LabelMask() > rhs.getU16LabelMask()) return false;
    }
    return false;
}

inline bool T_DAB_Label::operator > (const T_DAB_Label& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DAB_Label::clear() {
    clearSLabel();
    clearSLabelShort();
    clearU16LabelMask();
}

inline void T_DAB_Label::clearSLabel() {
    if (hasSLabel()) {
         clear_has_sLabel();
        if (_sLabel != NULL) {
            _sLabel->clear();
        }
     }
}

inline bool T_DAB_Label::hasSLabel () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_DAB_Label::getSLabel () const {
    if (_sLabel == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_sLabel;
}

inline ::std::string& T_DAB_Label::getSLabelMutable () {
    set_has_sLabel();
    if (_sLabel == NULL) {
        _sLabel = new ::std::string ();
        CHECK_ALLOCATION( _sLabel );
    }
    return *_sLabel;
}

inline void T_DAB_Label::setSLabel (const ::std::string& sLabel_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLabel();
    if (this->_sLabel == NULL) {
        this->_sLabel = new ::std::string (sLabel_);
        CHECK_ALLOCATION( this->_sLabel );
    } else {
        *this->_sLabel = sLabel_;
    }
}

inline void T_DAB_Label::setSLabel (const char* sLabel_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLabel();
    if (this->_sLabel == NULL) {
        this->_sLabel = new ::std::string (sLabel_);
        CHECK_ALLOCATION( this->_sLabel );
    } else {
        this->_sLabel->assign(sLabel_);
    }
}

inline void T_DAB_Label::setSLabel (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLabel();
    if (this->_sLabel == NULL) {
        this->_sLabel = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_sLabel );
    } else {
        this->_sLabel->assign(value, size);
    }
}

inline ::std::string* T_DAB_Label::releaseSLabel() {
    clear_has_sLabel();
    ::std::string* temp = _sLabel;
    this->_sLabel = NULL;
    return temp;
}

inline void T_DAB_Label::replaceSLabel (::std::string* sLabel_) {
    set_has_sLabel();
    if (this->_sLabel != sLabel_) {
        if (this->_sLabel != NULL) {
            delete this->_sLabel;
        }
        this->_sLabel = sLabel_;
    }
}

inline void T_DAB_Label::clearSLabelShort() {
    if (hasSLabelShort()) {
         clear_has_sLabelShort();
        if (_sLabelShort != NULL) {
            _sLabelShort->clear();
        }
     }
}

inline bool T_DAB_Label::hasSLabelShort () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_DAB_Label::getSLabelShort () const {
    if (_sLabelShort == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_sLabelShort;
}

inline ::std::string& T_DAB_Label::getSLabelShortMutable () {
    set_has_sLabelShort();
    if (_sLabelShort == NULL) {
        _sLabelShort = new ::std::string ();
        CHECK_ALLOCATION( _sLabelShort );
    }
    return *_sLabelShort;
}

inline void T_DAB_Label::setSLabelShort (const ::std::string& sLabelShort_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLabelShort_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLabelShort();
    if (this->_sLabelShort == NULL) {
        this->_sLabelShort = new ::std::string (sLabelShort_);
        CHECK_ALLOCATION( this->_sLabelShort );
    } else {
        *this->_sLabelShort = sLabelShort_;
    }
}

inline void T_DAB_Label::setSLabelShort (const char* sLabelShort_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sLabelShort_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLabelShort();
    if (this->_sLabelShort == NULL) {
        this->_sLabelShort = new ::std::string (sLabelShort_);
        CHECK_ALLOCATION( this->_sLabelShort );
    } else {
        this->_sLabelShort->assign(sLabelShort_);
    }
}

inline void T_DAB_Label::setSLabelShort (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sLabelShort();
    if (this->_sLabelShort == NULL) {
        this->_sLabelShort = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_sLabelShort );
    } else {
        this->_sLabelShort->assign(value, size);
    }
}

inline ::std::string* T_DAB_Label::releaseSLabelShort() {
    clear_has_sLabelShort();
    ::std::string* temp = _sLabelShort;
    this->_sLabelShort = NULL;
    return temp;
}

inline void T_DAB_Label::replaceSLabelShort (::std::string* sLabelShort_) {
    set_has_sLabelShort();
    if (this->_sLabelShort != sLabelShort_) {
        if (this->_sLabelShort != NULL) {
            delete this->_sLabelShort;
        }
        this->_sLabelShort = sLabelShort_;
    }
}

inline void T_DAB_Label::clearU16LabelMask() {
    if (hasU16LabelMask()) {
         clear_has_u16LabelMask();
        _u16LabelMask = 0u;
     }
}

inline bool T_DAB_Label::hasU16LabelMask () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_DAB_Label::getU16LabelMask () const {
    return _u16LabelMask;
}

inline void T_DAB_Label::setU16LabelMask (uint16 u16LabelMask_) {
    set_has_u16LabelMask();
    this->_u16LabelMask = u16LabelMask_;
}

inline void T_DAB_Label::set_has_sLabel () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DAB_Label::clear_has_sLabel () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DAB_Label::set_has_sLabelShort () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DAB_Label::clear_has_sLabelShort () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DAB_Label::set_has_u16LabelMask () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DAB_Label::clear_has_u16LabelMask () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_b8_RadioProfileSettingAction::T_b8_RadioProfileSettingAction ()  :
    _TUNMSTR_PROFILE_ACTION_PRESETS (false),
    _TUNMSTR_PROFILE_ACTION_AMSWITCH (false)
{
}

inline  T_b8_RadioProfileSettingAction::T_b8_RadioProfileSettingAction (const T_b8_RadioProfileSettingAction &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_RadioProfileSettingAction::T_b8_RadioProfileSettingAction (bool TUNMSTR_PROFILE_ACTION_PRESETS, bool TUNMSTR_PROFILE_ACTION_AMSWITCH) :
    _TUNMSTR_PROFILE_ACTION_PRESETS (TUNMSTR_PROFILE_ACTION_PRESETS),
    _TUNMSTR_PROFILE_ACTION_AMSWITCH (TUNMSTR_PROFILE_ACTION_AMSWITCH)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_RadioProfileSettingAction& T_b8_RadioProfileSettingAction::operator = (const T_b8_RadioProfileSettingAction& rhs) {
    if( this != &rhs ) {
        _TUNMSTR_PROFILE_ACTION_PRESETS = rhs._TUNMSTR_PROFILE_ACTION_PRESETS;
        _TUNMSTR_PROFILE_ACTION_AMSWITCH = rhs._TUNMSTR_PROFILE_ACTION_AMSWITCH;
    }
    return *this;
}

inline bool T_b8_RadioProfileSettingAction::operator == (const T_b8_RadioProfileSettingAction& rhs) const {
    return (_TUNMSTR_PROFILE_ACTION_PRESETS == rhs._TUNMSTR_PROFILE_ACTION_PRESETS &&
        _TUNMSTR_PROFILE_ACTION_AMSWITCH == rhs._TUNMSTR_PROFILE_ACTION_AMSWITCH);
}

inline bool T_b8_RadioProfileSettingAction::operator != (const T_b8_RadioProfileSettingAction& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_RadioProfileSettingAction::operator < (const T_b8_RadioProfileSettingAction& rhs) const {
    if (getTUNMSTR_PROFILE_ACTION_PRESETS() < rhs.getTUNMSTR_PROFILE_ACTION_PRESETS()) return true;
    if (getTUNMSTR_PROFILE_ACTION_PRESETS() > rhs.getTUNMSTR_PROFILE_ACTION_PRESETS()) return false;

    if (getTUNMSTR_PROFILE_ACTION_AMSWITCH() < rhs.getTUNMSTR_PROFILE_ACTION_AMSWITCH()) return true;
    if (getTUNMSTR_PROFILE_ACTION_AMSWITCH() > rhs.getTUNMSTR_PROFILE_ACTION_AMSWITCH()) return false;

    return false;
}

inline bool T_b8_RadioProfileSettingAction::operator > (const T_b8_RadioProfileSettingAction& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_RadioProfileSettingAction::setTUNMSTR_PROFILE_ACTION_PRESETS (bool TUNMSTR_PROFILE_ACTION_PRESETS) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUNMSTR_PROFILE_ACTION_PRESETS = TUNMSTR_PROFILE_ACTION_PRESETS;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_RadioProfileSettingAction::getTUNMSTR_PROFILE_ACTION_PRESETS () const {
    return _TUNMSTR_PROFILE_ACTION_PRESETS;
}

inline void T_b8_RadioProfileSettingAction::setTUNMSTR_PROFILE_ACTION_AMSWITCH (bool TUNMSTR_PROFILE_ACTION_AMSWITCH) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUNMSTR_PROFILE_ACTION_AMSWITCH = TUNMSTR_PROFILE_ACTION_AMSWITCH;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_RadioProfileSettingAction::getTUNMSTR_PROFILE_ACTION_AMSWITCH () const {
    return _TUNMSTR_PROFILE_ACTION_AMSWITCH;
}

inline  T_TunMst_PresetListElement::T_TunMst_PresetListElement ()  :
    _e8RadioType (::midw_tunermaster_fi_types::T_e8_TunMst_RadioType__RadioType_None),
    _u8PresetNumber (0u),
    _u32Frequency (0u),
    _u32SID (0u),
    _sStationName (NULL),
    _u32TextEncoding (0u),
    _u8ProgramNumber (0u),
    _u32EnsembleId (0u),
    _ComponentLabel (NULL),
    _u32ComponentLabelEncoding (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TunMst_PresetListElement::T_TunMst_PresetListElement (const T_TunMst_PresetListElement &rhs)  :
    _e8RadioType (::midw_tunermaster_fi_types::T_e8_TunMst_RadioType__RadioType_None),
    _u8PresetNumber (0u),
    _u32Frequency (0u),
    _u32SID (0u),
    _sStationName (NULL),
    _u32TextEncoding (0u),
    _u8ProgramNumber (0u),
    _u32EnsembleId (0u),
    _ComponentLabel (NULL),
    _u32ComponentLabelEncoding (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TunMst_PresetListElement::T_TunMst_PresetListElement (T_e8_TunMst_RadioType e8RadioType_, uint8 u8PresetNumber_, uint32 u32Frequency_, uint32 u32SID_, const ::std::string& sStationName_, uint32 u32TextEncoding_, uint8 u8ProgramNumber_, uint32 u32EnsembleId_, const ::std::string& ComponentLabel_, uint32 u32ComponentLabelEncoding_)  :
    _e8RadioType (e8RadioType_),
    _u8PresetNumber (u8PresetNumber_),
    _u32Frequency (u32Frequency_),
    _u32SID (u32SID_),
    _sStationName (new ::std::string(sStationName_)),
    _u32TextEncoding (u32TextEncoding_),
    _u8ProgramNumber (u8ProgramNumber_),
    _u32EnsembleId (u32EnsembleId_),
    _ComponentLabel (new ::std::string(ComponentLabel_)),
    _u32ComponentLabelEncoding (u32ComponentLabelEncoding_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_TunMst_RadioType_IsValid(e8RadioType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8RadioType_, "T_e8_TunMst_RadioType", "e8RadioType", "T_TunMst_PresetListElement");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sStationName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ComponentLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TunMst_PresetListElement::~T_TunMst_PresetListElement() {
    delete _sStationName;
    delete _ComponentLabel;
}

inline T_TunMst_PresetListElement& T_TunMst_PresetListElement::operator = (const T_TunMst_PresetListElement& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8RadioType()) {
            setE8RadioType(rhs.getE8RadioType());
        } else {
            clearE8RadioType();
        }
        if (rhs.hasU8PresetNumber()) {
            setU8PresetNumber(rhs.getU8PresetNumber());
        } else {
            clearU8PresetNumber();
        }
        if (rhs.hasU32Frequency()) {
            setU32Frequency(rhs.getU32Frequency());
        } else {
            clearU32Frequency();
        }
        if (rhs.hasU32SID()) {
            setU32SID(rhs.getU32SID());
        } else {
            clearU32SID();
        }
        if (rhs.hasSStationName()) {
            setSStationName(rhs.getSStationName());
        } else {
            clearSStationName();
        }
        if (rhs.hasU32TextEncoding()) {
            setU32TextEncoding(rhs.getU32TextEncoding());
        } else {
            clearU32TextEncoding();
        }
        if (rhs.hasU8ProgramNumber()) {
            setU8ProgramNumber(rhs.getU8ProgramNumber());
        } else {
            clearU8ProgramNumber();
        }
        if (rhs.hasU32EnsembleId()) {
            setU32EnsembleId(rhs.getU32EnsembleId());
        } else {
            clearU32EnsembleId();
        }
        if (rhs.hasComponentLabel()) {
            setComponentLabel(rhs.getComponentLabel());
        } else {
            clearComponentLabel();
        }
        if (rhs.hasU32ComponentLabelEncoding()) {
            setU32ComponentLabelEncoding(rhs.getU32ComponentLabelEncoding());
        } else {
            clearU32ComponentLabelEncoding();
        }
    }
    return *this;
}

inline bool T_TunMst_PresetListElement::operator == (const T_TunMst_PresetListElement& rhs) const {
    return (((!hasE8RadioType() && !rhs.hasE8RadioType()) || getE8RadioType() == rhs.getE8RadioType()) &&
        ((!hasU8PresetNumber() && !rhs.hasU8PresetNumber()) || getU8PresetNumber() == rhs.getU8PresetNumber()) &&
        ((!hasU32Frequency() && !rhs.hasU32Frequency()) || getU32Frequency() == rhs.getU32Frequency()) &&
        ((!hasU32SID() && !rhs.hasU32SID()) || getU32SID() == rhs.getU32SID()) &&
        ((!hasSStationName() && !rhs.hasSStationName()) || getSStationName() == rhs.getSStationName()) &&
        ((!hasU32TextEncoding() && !rhs.hasU32TextEncoding()) || getU32TextEncoding() == rhs.getU32TextEncoding()) &&
        ((!hasU8ProgramNumber() && !rhs.hasU8ProgramNumber()) || getU8ProgramNumber() == rhs.getU8ProgramNumber()) &&
        ((!hasU32EnsembleId() && !rhs.hasU32EnsembleId()) || getU32EnsembleId() == rhs.getU32EnsembleId()) &&
        ((!hasComponentLabel() && !rhs.hasComponentLabel()) || getComponentLabel() == rhs.getComponentLabel()) &&
        ((!hasU32ComponentLabelEncoding() && !rhs.hasU32ComponentLabelEncoding()) || getU32ComponentLabelEncoding() == rhs.getU32ComponentLabelEncoding()));
}

inline bool T_TunMst_PresetListElement::operator != (const T_TunMst_PresetListElement& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TunMst_PresetListElement::operator < (const T_TunMst_PresetListElement& rhs) const {
    if (hasE8RadioType() || rhs.hasE8RadioType()) {
        if ((uint32)getE8RadioType() < (uint32)rhs.getE8RadioType()) return true;
        if ((uint32)getE8RadioType() > (uint32)rhs.getE8RadioType()) return false;
    }
    if (hasU8PresetNumber() || rhs.hasU8PresetNumber()) {
        if (getU8PresetNumber() < rhs.getU8PresetNumber()) return true;
        if (getU8PresetNumber() > rhs.getU8PresetNumber()) return false;
    }
    if (hasU32Frequency() || rhs.hasU32Frequency()) {
        if (getU32Frequency() < rhs.getU32Frequency()) return true;
        if (getU32Frequency() > rhs.getU32Frequency()) return false;
    }
    if (hasU32SID() || rhs.hasU32SID()) {
        if (getU32SID() < rhs.getU32SID()) return true;
        if (getU32SID() > rhs.getU32SID()) return false;
    }
    if (hasSStationName() || rhs.hasSStationName()) {
        if (getSStationName() < rhs.getSStationName()) return true;
        if (getSStationName() > rhs.getSStationName()) return false;
    }
    if (hasU32TextEncoding() || rhs.hasU32TextEncoding()) {
        if (getU32TextEncoding() < rhs.getU32TextEncoding()) return true;
        if (getU32TextEncoding() > rhs.getU32TextEncoding()) return false;
    }
    if (hasU8ProgramNumber() || rhs.hasU8ProgramNumber()) {
        if (getU8ProgramNumber() < rhs.getU8ProgramNumber()) return true;
        if (getU8ProgramNumber() > rhs.getU8ProgramNumber()) return false;
    }
    if (hasU32EnsembleId() || rhs.hasU32EnsembleId()) {
        if (getU32EnsembleId() < rhs.getU32EnsembleId()) return true;
        if (getU32EnsembleId() > rhs.getU32EnsembleId()) return false;
    }
    if (hasComponentLabel() || rhs.hasComponentLabel()) {
        if (getComponentLabel() < rhs.getComponentLabel()) return true;
        if (getComponentLabel() > rhs.getComponentLabel()) return false;
    }
    if (hasU32ComponentLabelEncoding() || rhs.hasU32ComponentLabelEncoding()) {
        if (getU32ComponentLabelEncoding() < rhs.getU32ComponentLabelEncoding()) return true;
        if (getU32ComponentLabelEncoding() > rhs.getU32ComponentLabelEncoding()) return false;
    }
    return false;
}

inline bool T_TunMst_PresetListElement::operator > (const T_TunMst_PresetListElement& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TunMst_PresetListElement::clear() {
    clearE8RadioType();
    clearU8PresetNumber();
    clearU32Frequency();
    clearU32SID();
    clearSStationName();
    clearU32TextEncoding();
    clearU8ProgramNumber();
    clearU32EnsembleId();
    clearComponentLabel();
    clearU32ComponentLabelEncoding();
}

inline void T_TunMst_PresetListElement::clearE8RadioType() {
    if (hasE8RadioType()) {
         clear_has_e8RadioType();
        _e8RadioType = ::midw_tunermaster_fi_types::T_e8_TunMst_RadioType__RadioType_None;
     }
}

inline bool T_TunMst_PresetListElement::hasE8RadioType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_TunMst_RadioType T_TunMst_PresetListElement::getE8RadioType () const {
    return _e8RadioType;
}

inline void T_TunMst_PresetListElement::setE8RadioType (T_e8_TunMst_RadioType e8RadioType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_TunMst_RadioType_IsValid(e8RadioType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8RadioType_, "T_e8_TunMst_RadioType", "e8RadioType", "T_TunMst_PresetListElement");
    }
    set_has_e8RadioType();
    this->_e8RadioType = e8RadioType_;
}

inline void T_TunMst_PresetListElement::clearU8PresetNumber() {
    if (hasU8PresetNumber()) {
         clear_has_u8PresetNumber();
        _u8PresetNumber = 0u;
     }
}

inline bool T_TunMst_PresetListElement::hasU8PresetNumber () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_TunMst_PresetListElement::getU8PresetNumber () const {
    return _u8PresetNumber;
}

inline void T_TunMst_PresetListElement::setU8PresetNumber (uint8 u8PresetNumber_) {
    set_has_u8PresetNumber();
    this->_u8PresetNumber = u8PresetNumber_;
}

inline void T_TunMst_PresetListElement::clearU32Frequency() {
    if (hasU32Frequency()) {
         clear_has_u32Frequency();
        _u32Frequency = 0u;
     }
}

inline bool T_TunMst_PresetListElement::hasU32Frequency () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_TunMst_PresetListElement::getU32Frequency () const {
    return _u32Frequency;
}

inline void T_TunMst_PresetListElement::setU32Frequency (uint32 u32Frequency_) {
    set_has_u32Frequency();
    this->_u32Frequency = u32Frequency_;
}

inline void T_TunMst_PresetListElement::clearU32SID() {
    if (hasU32SID()) {
         clear_has_u32SID();
        _u32SID = 0u;
     }
}

inline bool T_TunMst_PresetListElement::hasU32SID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_TunMst_PresetListElement::getU32SID () const {
    return _u32SID;
}

inline void T_TunMst_PresetListElement::setU32SID (uint32 u32SID_) {
    set_has_u32SID();
    this->_u32SID = u32SID_;
}

inline void T_TunMst_PresetListElement::clearSStationName() {
    if (hasSStationName()) {
         clear_has_sStationName();
        if (_sStationName != NULL) {
            _sStationName->clear();
        }
     }
}

inline bool T_TunMst_PresetListElement::hasSStationName () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_TunMst_PresetListElement::getSStationName () const {
    if (_sStationName == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_sStationName;
}

inline ::std::string& T_TunMst_PresetListElement::getSStationNameMutable () {
    set_has_sStationName();
    if (_sStationName == NULL) {
        _sStationName = new ::std::string ();
        CHECK_ALLOCATION( _sStationName );
    }
    return *_sStationName;
}

inline void T_TunMst_PresetListElement::setSStationName (const ::std::string& sStationName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sStationName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sStationName();
    if (this->_sStationName == NULL) {
        this->_sStationName = new ::std::string (sStationName_);
        CHECK_ALLOCATION( this->_sStationName );
    } else {
        *this->_sStationName = sStationName_;
    }
}

inline void T_TunMst_PresetListElement::setSStationName (const char* sStationName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sStationName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sStationName();
    if (this->_sStationName == NULL) {
        this->_sStationName = new ::std::string (sStationName_);
        CHECK_ALLOCATION( this->_sStationName );
    } else {
        this->_sStationName->assign(sStationName_);
    }
}

inline void T_TunMst_PresetListElement::setSStationName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sStationName();
    if (this->_sStationName == NULL) {
        this->_sStationName = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_sStationName );
    } else {
        this->_sStationName->assign(value, size);
    }
}

inline ::std::string* T_TunMst_PresetListElement::releaseSStationName() {
    clear_has_sStationName();
    ::std::string* temp = _sStationName;
    this->_sStationName = NULL;
    return temp;
}

inline void T_TunMst_PresetListElement::replaceSStationName (::std::string* sStationName_) {
    set_has_sStationName();
    if (this->_sStationName != sStationName_) {
        if (this->_sStationName != NULL) {
            delete this->_sStationName;
        }
        this->_sStationName = sStationName_;
    }
}

inline void T_TunMst_PresetListElement::clearU32TextEncoding() {
    if (hasU32TextEncoding()) {
         clear_has_u32TextEncoding();
        _u32TextEncoding = 0u;
     }
}

inline bool T_TunMst_PresetListElement::hasU32TextEncoding () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint32 T_TunMst_PresetListElement::getU32TextEncoding () const {
    return _u32TextEncoding;
}

inline void T_TunMst_PresetListElement::setU32TextEncoding (uint32 u32TextEncoding_) {
    set_has_u32TextEncoding();
    this->_u32TextEncoding = u32TextEncoding_;
}

inline void T_TunMst_PresetListElement::clearU8ProgramNumber() {
    if (hasU8ProgramNumber()) {
         clear_has_u8ProgramNumber();
        _u8ProgramNumber = 0u;
     }
}

inline bool T_TunMst_PresetListElement::hasU8ProgramNumber () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_TunMst_PresetListElement::getU8ProgramNumber () const {
    return _u8ProgramNumber;
}

inline void T_TunMst_PresetListElement::setU8ProgramNumber (uint8 u8ProgramNumber_) {
    set_has_u8ProgramNumber();
    this->_u8ProgramNumber = u8ProgramNumber_;
}

inline void T_TunMst_PresetListElement::clearU32EnsembleId() {
    if (hasU32EnsembleId()) {
         clear_has_u32EnsembleId();
        _u32EnsembleId = 0u;
     }
}

inline bool T_TunMst_PresetListElement::hasU32EnsembleId () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint32 T_TunMst_PresetListElement::getU32EnsembleId () const {
    return _u32EnsembleId;
}

inline void T_TunMst_PresetListElement::setU32EnsembleId (uint32 u32EnsembleId_) {
    set_has_u32EnsembleId();
    this->_u32EnsembleId = u32EnsembleId_;
}

inline void T_TunMst_PresetListElement::clearComponentLabel() {
    if (hasComponentLabel()) {
         clear_has_ComponentLabel();
        if (_ComponentLabel != NULL) {
            _ComponentLabel->clear();
        }
     }
}

inline bool T_TunMst_PresetListElement::hasComponentLabel () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline const ::std::string& T_TunMst_PresetListElement::getComponentLabel () const {
    if (_ComponentLabel == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_ComponentLabel;
}

inline ::std::string& T_TunMst_PresetListElement::getComponentLabelMutable () {
    set_has_ComponentLabel();
    if (_ComponentLabel == NULL) {
        _ComponentLabel = new ::std::string ();
        CHECK_ALLOCATION( _ComponentLabel );
    }
    return *_ComponentLabel;
}

inline void T_TunMst_PresetListElement::setComponentLabel (const ::std::string& ComponentLabel_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ComponentLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ComponentLabel();
    if (this->_ComponentLabel == NULL) {
        this->_ComponentLabel = new ::std::string (ComponentLabel_);
        CHECK_ALLOCATION( this->_ComponentLabel );
    } else {
        *this->_ComponentLabel = ComponentLabel_;
    }
}

inline void T_TunMst_PresetListElement::setComponentLabel (const char* ComponentLabel_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ComponentLabel_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ComponentLabel();
    if (this->_ComponentLabel == NULL) {
        this->_ComponentLabel = new ::std::string (ComponentLabel_);
        CHECK_ALLOCATION( this->_ComponentLabel );
    } else {
        this->_ComponentLabel->assign(ComponentLabel_);
    }
}

inline void T_TunMst_PresetListElement::setComponentLabel (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ComponentLabel();
    if (this->_ComponentLabel == NULL) {
        this->_ComponentLabel = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_ComponentLabel );
    } else {
        this->_ComponentLabel->assign(value, size);
    }
}

inline ::std::string* T_TunMst_PresetListElement::releaseComponentLabel() {
    clear_has_ComponentLabel();
    ::std::string* temp = _ComponentLabel;
    this->_ComponentLabel = NULL;
    return temp;
}

inline void T_TunMst_PresetListElement::replaceComponentLabel (::std::string* ComponentLabel_) {
    set_has_ComponentLabel();
    if (this->_ComponentLabel != ComponentLabel_) {
        if (this->_ComponentLabel != NULL) {
            delete this->_ComponentLabel;
        }
        this->_ComponentLabel = ComponentLabel_;
    }
}

inline void T_TunMst_PresetListElement::clearU32ComponentLabelEncoding() {
    if (hasU32ComponentLabelEncoding()) {
         clear_has_u32ComponentLabelEncoding();
        _u32ComponentLabelEncoding = 0u;
     }
}

inline bool T_TunMst_PresetListElement::hasU32ComponentLabelEncoding () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline uint32 T_TunMst_PresetListElement::getU32ComponentLabelEncoding () const {
    return _u32ComponentLabelEncoding;
}

inline void T_TunMst_PresetListElement::setU32ComponentLabelEncoding (uint32 u32ComponentLabelEncoding_) {
    set_has_u32ComponentLabelEncoding();
    this->_u32ComponentLabelEncoding = u32ComponentLabelEncoding_;
}

inline void T_TunMst_PresetListElement::set_has_e8RadioType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TunMst_PresetListElement::clear_has_e8RadioType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TunMst_PresetListElement::set_has_u8PresetNumber () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TunMst_PresetListElement::clear_has_u8PresetNumber () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TunMst_PresetListElement::set_has_u32Frequency () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TunMst_PresetListElement::clear_has_u32Frequency () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TunMst_PresetListElement::set_has_u32SID () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TunMst_PresetListElement::clear_has_u32SID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TunMst_PresetListElement::set_has_sStationName () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TunMst_PresetListElement::clear_has_sStationName () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_TunMst_PresetListElement::set_has_u32TextEncoding () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_TunMst_PresetListElement::clear_has_u32TextEncoding () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_TunMst_PresetListElement::set_has_u8ProgramNumber () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_TunMst_PresetListElement::clear_has_u8ProgramNumber () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_TunMst_PresetListElement::set_has_u32EnsembleId () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_TunMst_PresetListElement::clear_has_u32EnsembleId () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_TunMst_PresetListElement::set_has_ComponentLabel () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_TunMst_PresetListElement::clear_has_ComponentLabel () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_TunMst_PresetListElement::set_has_u32ComponentLabelEncoding () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_TunMst_PresetListElement::clear_has_u32ComponentLabelEncoding () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline  T_ProfileResponse::T_ProfileResponse ()  :
    _Status (::midw_tunermaster_fi_types::T_ProfileActionStatus__Failed),
    _ProfileAction (::midw_tunermaster_fi_types::T_ProfileAction__ActiveProfile),
    _ProfileStatus (::midw_tunermaster_fi_types::T_ProfileStatus__Idle)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ProfileResponse::T_ProfileResponse (const T_ProfileResponse &rhs)  :
    _Status (::midw_tunermaster_fi_types::T_ProfileActionStatus__Failed),
    _ProfileAction (::midw_tunermaster_fi_types::T_ProfileAction__ActiveProfile),
    _ProfileStatus (::midw_tunermaster_fi_types::T_ProfileStatus__Idle)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ProfileResponse::T_ProfileResponse (T_ProfileActionStatus Status_, T_ProfileAction ProfileAction_, T_ProfileStatus ProfileStatus_)  :
    _Status (Status_),
    _ProfileAction (ProfileAction_),
    _ProfileStatus (ProfileStatus_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_ProfileActionStatus_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_ProfileActionStatus", "Status", "T_ProfileResponse");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_ProfileAction_IsValid(ProfileAction_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", ProfileAction_, "T_ProfileAction", "ProfileAction", "T_ProfileResponse");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_ProfileStatus_IsValid(ProfileStatus_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", ProfileStatus_, "T_ProfileStatus", "ProfileStatus", "T_ProfileResponse");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ProfileResponse::~T_ProfileResponse() {
}

inline T_ProfileResponse& T_ProfileResponse::operator = (const T_ProfileResponse& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasProfileAction()) {
            setProfileAction(rhs.getProfileAction());
        } else {
            clearProfileAction();
        }
        if (rhs.hasProfileStatus()) {
            setProfileStatus(rhs.getProfileStatus());
        } else {
            clearProfileStatus();
        }
    }
    return *this;
}

inline bool T_ProfileResponse::operator == (const T_ProfileResponse& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasProfileAction() && !rhs.hasProfileAction()) || getProfileAction() == rhs.getProfileAction()) &&
        ((!hasProfileStatus() && !rhs.hasProfileStatus()) || getProfileStatus() == rhs.getProfileStatus()));
}

inline bool T_ProfileResponse::operator != (const T_ProfileResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ProfileResponse::operator < (const T_ProfileResponse& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    if (hasProfileAction() || rhs.hasProfileAction()) {
        if ((uint32)getProfileAction() < (uint32)rhs.getProfileAction()) return true;
        if ((uint32)getProfileAction() > (uint32)rhs.getProfileAction()) return false;
    }
    if (hasProfileStatus() || rhs.hasProfileStatus()) {
        if ((uint32)getProfileStatus() < (uint32)rhs.getProfileStatus()) return true;
        if ((uint32)getProfileStatus() > (uint32)rhs.getProfileStatus()) return false;
    }
    return false;
}

inline bool T_ProfileResponse::operator > (const T_ProfileResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ProfileResponse::clear() {
    clearStatus();
    clearProfileAction();
    clearProfileStatus();
}

inline void T_ProfileResponse::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::midw_tunermaster_fi_types::T_ProfileActionStatus__Failed;
     }
}

inline bool T_ProfileResponse::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_ProfileActionStatus T_ProfileResponse::getStatus () const {
    return _Status;
}

inline void T_ProfileResponse::setStatus (T_ProfileActionStatus Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_ProfileActionStatus_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_ProfileActionStatus", "Status", "T_ProfileResponse");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void T_ProfileResponse::clearProfileAction() {
    if (hasProfileAction()) {
         clear_has_ProfileAction();
        _ProfileAction = ::midw_tunermaster_fi_types::T_ProfileAction__ActiveProfile;
     }
}

inline bool T_ProfileResponse::hasProfileAction () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_ProfileAction T_ProfileResponse::getProfileAction () const {
    return _ProfileAction;
}

inline void T_ProfileResponse::setProfileAction (T_ProfileAction ProfileAction_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_ProfileAction_IsValid(ProfileAction_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", ProfileAction_, "T_ProfileAction", "ProfileAction", "T_ProfileResponse");
    }
    set_has_ProfileAction();
    this->_ProfileAction = ProfileAction_;
}

inline void T_ProfileResponse::clearProfileStatus() {
    if (hasProfileStatus()) {
         clear_has_ProfileStatus();
        _ProfileStatus = ::midw_tunermaster_fi_types::T_ProfileStatus__Idle;
     }
}

inline bool T_ProfileResponse::hasProfileStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_ProfileStatus T_ProfileResponse::getProfileStatus () const {
    return _ProfileStatus;
}

inline void T_ProfileResponse::setProfileStatus (T_ProfileStatus ProfileStatus_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_ProfileStatus_IsValid(ProfileStatus_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", ProfileStatus_, "T_ProfileStatus", "ProfileStatus", "T_ProfileResponse");
    }
    set_has_ProfileStatus();
    this->_ProfileStatus = ProfileStatus_;
}

inline void T_ProfileResponse::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ProfileResponse::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_ProfileResponse::set_has_ProfileAction () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_ProfileResponse::clear_has_ProfileAction () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_ProfileResponse::set_has_ProfileStatus () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_ProfileResponse::clear_has_ProfileStatus () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace midw_tunermaster_fi_types

#endif // MIDW_TUNERMASTER_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
