/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/stc/stcservices.h"
#include "org/bosch/stc/stcservicesDBus.h"
#include "org/bosch/stc/stcservicesJson.h"
#include "org/bosch/stc/stcservicesStub.h"

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace stc {
namespace stcservices {

DEFINE_CLASS_LOGGER("/org/bosch/stc/org/bosch/stc/stcservices", StcservicesStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 7, "GetTime", 0 },
    { 7, "SetTime", 1 },
    { 14, "ProvideCEAtime", 2 },
    { 15, "SetCEATokenTime", 3 },
};


class StcservicesStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    StcservicesStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    StcservicesStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    StcservicesStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.stc.stcservices"),
          _logger(logger) {}

    virtual ~StcservicesStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void StcservicesStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 4, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'GetTime'

            LOG_DEBUG_STUB("process method '%s'", "GetTime");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetTimeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetTime", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetTimeRequest > payload = ::boost::static_pointer_cast<GetTimeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<StcservicesStub*>(getStub())->onGetTimeRequest(payload);
            return;
        }
        case 1: {

            // method 'SetTime'

            LOG_DEBUG_STUB("process method '%s'", "SetTime");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetTimeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetTime", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetTimeRequest > payload = ::boost::static_pointer_cast<SetTimeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<StcservicesStub*>(getStub())->onSetTimeRequest(payload);
            return;
        }
        case 2: {

            // method 'ProvideCEAtime'

            LOG_DEBUG_STUB("process method '%s'", "ProvideCEAtime");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProvideCEAtimeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ProvideCEAtime", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ProvideCEAtimeRequest > payload = ::boost::static_pointer_cast<ProvideCEAtimeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<StcservicesStub*>(getStub())->onProvideCEAtimeRequest(payload);
            return;
        }
        case 3: {

            // method 'SetCEATokenTime'

            LOG_DEBUG_STUB("process method '%s'", "SetCEATokenTime");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetCEATokenTimeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetCEATokenTime", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetCEATokenTimeRequest > payload = ::boost::static_pointer_cast<SetCEATokenTimeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<StcservicesStub*>(getStub())->onSetCEATokenTimeRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* StcservicesStubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.stc.stcservices\">\n"
            "      <method name=\"GetTime\">\n"
            "        <arg direction=\"out\" name=\"value\" type=\"t\"/>\n"
            "      </method>\n"
            "      <method name=\"SetTime\">\n"
            "        <arg direction=\"in\" name=\"value\" type=\"t\"/>\n"
            "      </method>\n"
            "      <method name=\"ProvideCEAtime\">\n"
            "        <arg direction=\"in\" name=\"value\" type=\"t\"/>\n"
            "      </method>\n"
            "      <method name=\"SetCEATokenTime\">\n"
            "        <arg direction=\"in\" name=\"value\" type=\"t\"/>\n"
            "      </method>\n"
            "</interface>\n";
}

void StcservicesStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<StcservicesStub*>(getStub()))->onGetAll (properties);
}

void StcservicesStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void StcservicesStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

StcservicesStub::StcservicesStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new StcservicesStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

StcservicesStub::StcservicesStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new StcservicesStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

StcservicesStub::~StcservicesStub() {
    delete _stubDelegate;
}

void  StcservicesStub::sendGetTimeResponse (uint64 value, act_t act) {
    GetTimeResponse* payload = new GetTimeResponse(value);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetTime", GetTimeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetTime", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  StcservicesStub::sendGetTimeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetTimeError* payload = new GetTimeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetTime", GetTimeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetTime", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  StcservicesStub::sendSetTimeResponse (act_t act) {
    SetTimeResponse* payload = new SetTimeResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SetTime", SetTimeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetTime", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  StcservicesStub::sendSetTimeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetTimeError* payload = new SetTimeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetTime", SetTimeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetTime", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  StcservicesStub::sendProvideCEAtimeResponse (act_t act) {
    ProvideCEAtimeResponse* payload = new ProvideCEAtimeResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ProvideCEAtime", ProvideCEAtimeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ProvideCEAtime", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  StcservicesStub::sendProvideCEAtimeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ProvideCEAtimeError* payload = new ProvideCEAtimeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ProvideCEAtime", ProvideCEAtimeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ProvideCEAtime", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  StcservicesStub::sendSetCEATokenTimeResponse (act_t act) {
    SetCEATokenTimeResponse* payload = new SetCEATokenTimeResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SetCEATokenTime", SetCEATokenTimeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetCEATokenTime", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  StcservicesStub::sendSetCEATokenTimeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetCEATokenTimeError* payload = new SetCEATokenTimeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetCEATokenTime", SetCEATokenTimeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetCEATokenTime", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void StcservicesStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace stcservices
} // namespace stc
} // namespace bosch
} // namespace org
