/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "masc_main_fi_types.h"
#include "masc_main_fi_typesConst.h"
#include "mascf_aud_src_route_fi_types.h"
#include "mascf_aud_src_route_fi_typesConst.h"
#include "mascf_main_fiCca.h"
#include "mascf_main_fiJson.h"
#include "mascf_main_fiProxy.h"
#include <string>

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace mascf_main_fi {

/*static*/ ::asf::core::Logger Mascf_main_fiProxy::_logger ("/mascf_main_fi/Mascf_main_fiProxy");


class Mascf_main_fiProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Mascf_main_fiProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Mascf_main_fiProxy> proxy = ::boost::static_pointer_cast<Mascf_main_fiProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_VolumeMode: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::VolumeModeResult);
                                setActAndLogResult(message, "VolumeMode", reinterpret_cast<act_t>(this), _logger);
                                ((VolumeModeCallbackIF*) _callback)->onVolumeModeResult (proxy, ::boost::static_pointer_cast<VolumeModeResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::VolumeModeError);
                                setActAndLogError(message, "VolumeMode", reinterpret_cast<act_t>(this), _logger);
                                ((VolumeModeCallbackIF*) _callback)->onVolumeModeError (proxy, ::boost::static_pointer_cast<VolumeModeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Beep: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::BeepResult);
                                setActAndLogResult(message, "Beep", reinterpret_cast<act_t>(this), _logger);
                                ((BeepCallbackIF*) _callback)->onBeepResult (proxy, ::boost::static_pointer_cast<BeepResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::BeepError);
                                setActAndLogError(message, "Beep", reinterpret_cast<act_t>(this), _logger);
                                ((BeepCallbackIF*) _callback)->onBeepError (proxy, ::boost::static_pointer_cast<BeepError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_BeepFile: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::BeepFileResult);
                                setActAndLogResult(message, "BeepFile", reinterpret_cast<act_t>(this), _logger);
                                ((BeepFileCallbackIF*) _callback)->onBeepFileResult (proxy, ::boost::static_pointer_cast<BeepFileResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::BeepFileError);
                                setActAndLogError(message, "BeepFile", reinterpret_cast<act_t>(this), _logger);
                                ((BeepFileCallbackIF*) _callback)->onBeepFileError (proxy, ::boost::static_pointer_cast<BeepFileError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Mute: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::MuteResult);
                                setActAndLogResult(message, "Mute", reinterpret_cast<act_t>(this), _logger);
                                ((MuteCallbackIF*) _callback)->onMuteResult (proxy, ::boost::static_pointer_cast<MuteResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::MuteError);
                                setActAndLogError(message, "Mute", reinterpret_cast<act_t>(this), _logger);
                                ((MuteCallbackIF*) _callback)->onMuteError (proxy, ::boost::static_pointer_cast<MuteError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Set_Mute_Ramp: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::Set_Mute_RampResult);
                                setActAndLogResult(message, "Set_Mute_Ramp", reinterpret_cast<act_t>(this), _logger);
                                ((Set_Mute_RampCallbackIF*) _callback)->onSet_Mute_RampResult (proxy, ::boost::static_pointer_cast<Set_Mute_RampResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::Set_Mute_RampError);
                                setActAndLogError(message, "Set_Mute_Ramp", reinterpret_cast<act_t>(this), _logger);
                                ((Set_Mute_RampCallbackIF*) _callback)->onSet_Mute_RampError (proxy, ::boost::static_pointer_cast<Set_Mute_RampError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AudioSource: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AudioSourceResult);
                                setActAndLogResult(message, "AudioSource", reinterpret_cast<act_t>(this), _logger);
                                ((AudioSourceCallbackIF*) _callback)->onAudioSourceResult (proxy, ::boost::static_pointer_cast<AudioSourceResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AudioSourceError);
                                setActAndLogError(message, "AudioSource", reinterpret_cast<act_t>(this), _logger);
                                ((AudioSourceCallbackIF*) _callback)->onAudioSourceError (proxy, ::boost::static_pointer_cast<AudioSourceError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AmpDeviceAudioRoute: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AmpDeviceAudioRouteResult);
                                setActAndLogResult(message, "AmpDeviceAudioRoute", reinterpret_cast<act_t>(this), _logger);
                                ((AmpDeviceAudioRouteCallbackIF*) _callback)->onAmpDeviceAudioRouteResult (proxy, ::boost::static_pointer_cast<AmpDeviceAudioRouteResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AmpDeviceAudioRouteError);
                                setActAndLogError(message, "AmpDeviceAudioRoute", reinterpret_cast<act_t>(this), _logger);
                                ((AmpDeviceAudioRouteCallbackIF*) _callback)->onAmpDeviceAudioRouteError (proxy, ::boost::static_pointer_cast<AmpDeviceAudioRouteError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AudioTestTone: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AudioTestToneResult);
                                setActAndLogResult(message, "AudioTestTone", reinterpret_cast<act_t>(this), _logger);
                                ((AudioTestToneCallbackIF*) _callback)->onAudioTestToneResult (proxy, ::boost::static_pointer_cast<AudioTestToneResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AudioTestToneError);
                                setActAndLogError(message, "AudioTestTone", reinterpret_cast<act_t>(this), _logger);
                                ((AudioTestToneCallbackIF*) _callback)->onAudioTestToneError (proxy, ::boost::static_pointer_cast<AudioTestToneError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_CueState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::CueStateResult);
                                setActAndLogResult(message, "CueState", reinterpret_cast<act_t>(this), _logger);
                                ((CueStateCallbackIF*) _callback)->onCueStateResult (proxy, ::boost::static_pointer_cast<CueStateResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::CueStateError);
                                setActAndLogError(message, "CueState", reinterpret_cast<act_t>(this), _logger);
                                ((CueStateCallbackIF*) _callback)->onCueStateError (proxy, ::boost::static_pointer_cast<CueStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SpeakerDiagnosisStart: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::SpeakerDiagnosisStartResult);
                                setActAndLogResult(message, "SpeakerDiagnosisStart", reinterpret_cast<act_t>(this), _logger);
                                ((SpeakerDiagnosisStartCallbackIF*) _callback)->onSpeakerDiagnosisStartResult (proxy, ::boost::static_pointer_cast<SpeakerDiagnosisStartResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::SpeakerDiagnosisStartError);
                                setActAndLogError(message, "SpeakerDiagnosisStart", reinterpret_cast<act_t>(this), _logger);
                                ((SpeakerDiagnosisStartCallbackIF*) _callback)->onSpeakerDiagnosisStartError (proxy, ::boost::static_pointer_cast<SpeakerDiagnosisStartError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SystemMute: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::SystemMuteResult);
                                setActAndLogResult(message, "SystemMute", reinterpret_cast<act_t>(this), _logger);
                                ((SystemMuteCallbackIF*) _callback)->onSystemMuteResult (proxy, ::boost::static_pointer_cast<SystemMuteResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::SystemMuteError);
                                setActAndLogError(message, "SystemMute", reinterpret_cast<act_t>(this), _logger);
                                ((SystemMuteCallbackIF*) _callback)->onSystemMuteError (proxy, ::boost::static_pointer_cast<SystemMuteError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ADAS_SettingSound: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ADAS_SettingSoundResult);
                                setActAndLogResult(message, "ADAS_SettingSound", reinterpret_cast<act_t>(this), _logger);
                                ((ADAS_SettingSoundCallbackIF*) _callback)->onADAS_SettingSoundResult (proxy, ::boost::static_pointer_cast<ADAS_SettingSoundResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ADAS_SettingSoundError);
                                setActAndLogError(message, "ADAS_SettingSound", reinterpret_cast<act_t>(this), _logger);
                                ((ADAS_SettingSoundCallbackIF*) _callback)->onADAS_SettingSoundError (proxy, ::boost::static_pointer_cast<ADAS_SettingSoundError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_EntertainmentMute: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::EntertainmentMuteResult);
                                setActAndLogResult(message, "EntertainmentMute", reinterpret_cast<act_t>(this), _logger);
                                ((EntertainmentMuteCallbackIF*) _callback)->onEntertainmentMuteResult (proxy, ::boost::static_pointer_cast<EntertainmentMuteResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::EntertainmentMuteError);
                                setActAndLogError(message, "EntertainmentMute", reinterpret_cast<act_t>(this), _logger);
                                ((EntertainmentMuteCallbackIF*) _callback)->onEntertainmentMuteError (proxy, ::boost::static_pointer_cast<EntertainmentMuteError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_MCANBoseAmp_VersionInfo: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::MCANBoseAmp_VersionInfoResult);
                                setActAndLogResult(message, "MCANBoseAmp_VersionInfo", reinterpret_cast<act_t>(this), _logger);
                                ((MCANBoseAmp_VersionInfoCallbackIF*) _callback)->onMCANBoseAmp_VersionInfoResult (proxy, ::boost::static_pointer_cast<MCANBoseAmp_VersionInfoResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::MCANBoseAmp_VersionInfoError);
                                setActAndLogError(message, "MCANBoseAmp_VersionInfo", reinterpret_cast<act_t>(this), _logger);
                                ((MCANBoseAmp_VersionInfoCallbackIF*) _callback)->onMCANBoseAmp_VersionInfoError (proxy, ::boost::static_pointer_cast<MCANBoseAmp_VersionInfoError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_VolumeModeStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::VolumeModeStatusStatus);
                                setActAndLogStatus(message, "VolumeModeStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<VolumeModeStatusStatus> payload = ::boost::static_pointer_cast<VolumeModeStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< VolumeModeStatusStatus >& refNullableStatus = proxy->_volumeModeStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((VolumeModeStatusCallbackIF*) _callback)->onVolumeModeStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((VolumeModeStatusCallbackIF*) _callback)->onVolumeModeStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::VolumeModeStatusError);
                                setActAndLogError(message, "VolumeModeStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((VolumeModeStatusCallbackIF*) _callback)->onVolumeModeStatusError(proxy, ::boost::static_pointer_cast<VolumeModeStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Volume: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::VolumeStatus);
                                setActAndLogStatus(message, "Volume", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<VolumeStatus> payload = ::boost::static_pointer_cast<VolumeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< VolumeStatus >& refNullableStatus = proxy->_volume;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((VolumeCallbackIF*) _callback)->onVolumeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((VolumeCallbackIF*) _callback)->onVolumeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::VolumeError);
                                setActAndLogError(message, "Volume", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((VolumeCallbackIF*) _callback)->onVolumeError(proxy, ::boost::static_pointer_cast<VolumeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_BeepStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::BeepStatusStatus);
                                setActAndLogStatus(message, "BeepStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<BeepStatusStatus> payload = ::boost::static_pointer_cast<BeepStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< BeepStatusStatus >& refNullableStatus = proxy->_beepStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((BeepStatusCallbackIF*) _callback)->onBeepStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::BeepStatusError);
                                setActAndLogError(message, "BeepStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((BeepStatusCallbackIF*) _callback)->onBeepStatusError(proxy, ::boost::static_pointer_cast<BeepStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Gala: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::GalaStatus);
                                setActAndLogStatus(message, "Gala", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<GalaStatus> payload = ::boost::static_pointer_cast<GalaStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< GalaStatus >& refNullableStatus = proxy->_gala;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((GalaCallbackIF*) _callback)->onGalaStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((GalaCallbackIF*) _callback)->onGalaStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::GalaError);
                                setActAndLogError(message, "Gala", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((GalaCallbackIF*) _callback)->onGalaError(proxy, ::boost::static_pointer_cast<GalaError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Balance: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::BalanceStatus);
                                setActAndLogStatus(message, "Balance", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<BalanceStatus> payload = ::boost::static_pointer_cast<BalanceStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< BalanceStatus >& refNullableStatus = proxy->_balance;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((BalanceCallbackIF*) _callback)->onBalanceStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((BalanceCallbackIF*) _callback)->onBalanceStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::BalanceError);
                                setActAndLogError(message, "Balance", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((BalanceCallbackIF*) _callback)->onBalanceError(proxy, ::boost::static_pointer_cast<BalanceError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Loudness: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::LoudnessStatus);
                                setActAndLogStatus(message, "Loudness", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<LoudnessStatus> payload = ::boost::static_pointer_cast<LoudnessStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< LoudnessStatus >& refNullableStatus = proxy->_loudness;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((LoudnessCallbackIF*) _callback)->onLoudnessStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((LoudnessCallbackIF*) _callback)->onLoudnessStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::LoudnessError);
                                setActAndLogError(message, "Loudness", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((LoudnessCallbackIF*) _callback)->onLoudnessError(proxy, ::boost::static_pointer_cast<LoudnessError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Bass: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::BassStatus);
                                setActAndLogStatus(message, "Bass", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<BassStatus> payload = ::boost::static_pointer_cast<BassStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< BassStatus >& refNullableStatus = proxy->_bass;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((BassCallbackIF*) _callback)->onBassStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((BassCallbackIF*) _callback)->onBassStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::BassError);
                                setActAndLogError(message, "Bass", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((BassCallbackIF*) _callback)->onBassError(proxy, ::boost::static_pointer_cast<BassError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Treble: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::TrebleStatus);
                                setActAndLogStatus(message, "Treble", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<TrebleStatus> payload = ::boost::static_pointer_cast<TrebleStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< TrebleStatus >& refNullableStatus = proxy->_treble;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((TrebleCallbackIF*) _callback)->onTrebleStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((TrebleCallbackIF*) _callback)->onTrebleStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::TrebleError);
                                setActAndLogError(message, "Treble", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((TrebleCallbackIF*) _callback)->onTrebleError(proxy, ::boost::static_pointer_cast<TrebleError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Fader: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::FaderStatus);
                                setActAndLogStatus(message, "Fader", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<FaderStatus> payload = ::boost::static_pointer_cast<FaderStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< FaderStatus >& refNullableStatus = proxy->_fader;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((FaderCallbackIF*) _callback)->onFaderStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((FaderCallbackIF*) _callback)->onFaderStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::FaderError);
                                setActAndLogError(message, "Fader", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((FaderCallbackIF*) _callback)->onFaderError(proxy, ::boost::static_pointer_cast<FaderError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_MidRange: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::MidRangeStatus);
                                setActAndLogStatus(message, "MidRange", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<MidRangeStatus> payload = ::boost::static_pointer_cast<MidRangeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< MidRangeStatus >& refNullableStatus = proxy->_midRange;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((MidRangeCallbackIF*) _callback)->onMidRangeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((MidRangeCallbackIF*) _callback)->onMidRangeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::MidRangeError);
                                setActAndLogError(message, "MidRange", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((MidRangeCallbackIF*) _callback)->onMidRangeError(proxy, ::boost::static_pointer_cast<MidRangeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_MemSound: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::MemSoundStatus);
                                setActAndLogStatus(message, "MemSound", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<MemSoundStatus> payload = ::boost::static_pointer_cast<MemSoundStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< MemSoundStatus >& refNullableStatus = proxy->_memSound;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((MemSoundCallbackIF*) _callback)->onMemSoundStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((MemSoundCallbackIF*) _callback)->onMemSoundStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::MemSoundError);
                                setActAndLogError(message, "MemSound", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((MemSoundCallbackIF*) _callback)->onMemSoundError(proxy, ::boost::static_pointer_cast<MemSoundError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_FaderActivationStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::FaderActivationStatusStatus);
                                setActAndLogStatus(message, "FaderActivationStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<FaderActivationStatusStatus> payload = ::boost::static_pointer_cast<FaderActivationStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< FaderActivationStatusStatus >& refNullableStatus = proxy->_faderActivationStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((FaderActivationStatusCallbackIF*) _callback)->onFaderActivationStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((FaderActivationStatusCallbackIF*) _callback)->onFaderActivationStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::FaderActivationStatusError);
                                setActAndLogError(message, "FaderActivationStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((FaderActivationStatusCallbackIF*) _callback)->onFaderActivationStatusError(proxy, ::boost::static_pointer_cast<FaderActivationStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DynamicCompression: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::DynamicCompressionStatus);
                                setActAndLogStatus(message, "DynamicCompression", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DynamicCompressionStatus> payload = ::boost::static_pointer_cast<DynamicCompressionStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DynamicCompressionStatus >& refNullableStatus = proxy->_dynamicCompression;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DynamicCompressionCallbackIF*) _callback)->onDynamicCompressionStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DynamicCompressionCallbackIF*) _callback)->onDynamicCompressionStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::DynamicCompressionError);
                                setActAndLogError(message, "DynamicCompression", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DynamicCompressionCallbackIF*) _callback)->onDynamicCompressionError(proxy, ::boost::static_pointer_cast<DynamicCompressionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Optimization: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::OptimizationStatus);
                                setActAndLogStatus(message, "Optimization", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<OptimizationStatus> payload = ::boost::static_pointer_cast<OptimizationStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< OptimizationStatus >& refNullableStatus = proxy->_optimization;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((OptimizationCallbackIF*) _callback)->onOptimizationStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((OptimizationCallbackIF*) _callback)->onOptimizationStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::OptimizationError);
                                setActAndLogError(message, "Optimization", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((OptimizationCallbackIF*) _callback)->onOptimizationError(proxy, ::boost::static_pointer_cast<OptimizationError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_EqualiserPreset: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::EqualiserPresetStatus);
                                setActAndLogStatus(message, "EqualiserPreset", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<EqualiserPresetStatus> payload = ::boost::static_pointer_cast<EqualiserPresetStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< EqualiserPresetStatus >& refNullableStatus = proxy->_equaliserPreset;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((EqualiserPresetCallbackIF*) _callback)->onEqualiserPresetStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((EqualiserPresetCallbackIF*) _callback)->onEqualiserPresetStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::EqualiserPresetError);
                                setActAndLogError(message, "EqualiserPreset", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((EqualiserPresetCallbackIF*) _callback)->onEqualiserPresetError(proxy, ::boost::static_pointer_cast<EqualiserPresetError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DiagAudMode: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::DiagAudModeStatus);
                                setActAndLogStatus(message, "DiagAudMode", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DiagAudModeStatus> payload = ::boost::static_pointer_cast<DiagAudModeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DiagAudModeStatus >& refNullableStatus = proxy->_diagAudMode;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DiagAudModeCallbackIF*) _callback)->onDiagAudModeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DiagAudModeCallbackIF*) _callback)->onDiagAudModeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::DiagAudModeError);
                                setActAndLogError(message, "DiagAudMode", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DiagAudModeCallbackIF*) _callback)->onDiagAudModeError(proxy, ::boost::static_pointer_cast<DiagAudModeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AuxInLevel: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AuxInLevelStatus);
                                setActAndLogStatus(message, "AuxInLevel", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AuxInLevelStatus> payload = ::boost::static_pointer_cast<AuxInLevelStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AuxInLevelStatus >& refNullableStatus = proxy->_auxInLevel;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AuxInLevelCallbackIF*) _callback)->onAuxInLevelStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AuxInLevelCallbackIF*) _callback)->onAuxInLevelStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AuxInLevelError);
                                setActAndLogError(message, "AuxInLevel", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AuxInLevelCallbackIF*) _callback)->onAuxInLevelError(proxy, ::boost::static_pointer_cast<AuxInLevelError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_BeepLevel: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::BeepLevelStatus);
                                setActAndLogStatus(message, "BeepLevel", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<BeepLevelStatus> payload = ::boost::static_pointer_cast<BeepLevelStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< BeepLevelStatus >& refNullableStatus = proxy->_beepLevel;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((BeepLevelCallbackIF*) _callback)->onBeepLevelStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((BeepLevelCallbackIF*) _callback)->onBeepLevelStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::BeepLevelError);
                                setActAndLogError(message, "BeepLevel", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((BeepLevelCallbackIF*) _callback)->onBeepLevelError(proxy, ::boost::static_pointer_cast<BeepLevelError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Rear_Mute: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::Rear_MuteStatus);
                                setActAndLogStatus(message, "Rear_Mute", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<Rear_MuteStatus> payload = ::boost::static_pointer_cast<Rear_MuteStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< Rear_MuteStatus >& refNullableStatus = proxy->_rear_Mute;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((Rear_MuteCallbackIF*) _callback)->onRear_MuteStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((Rear_MuteCallbackIF*) _callback)->onRear_MuteStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::Rear_MuteError);
                                setActAndLogError(message, "Rear_Mute", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((Rear_MuteCallbackIF*) _callback)->onRear_MuteError(proxy, ::boost::static_pointer_cast<Rear_MuteError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Geometry_Mode: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::Geometry_ModeStatus);
                                setActAndLogStatus(message, "Geometry_Mode", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<Geometry_ModeStatus> payload = ::boost::static_pointer_cast<Geometry_ModeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< Geometry_ModeStatus >& refNullableStatus = proxy->_geometry_Mode;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((Geometry_ModeCallbackIF*) _callback)->onGeometry_ModeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((Geometry_ModeCallbackIF*) _callback)->onGeometry_ModeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::Geometry_ModeError);
                                setActAndLogError(message, "Geometry_Mode", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((Geometry_ModeCallbackIF*) _callback)->onGeometry_ModeError(proxy, ::boost::static_pointer_cast<Geometry_ModeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_LSValueStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::LSValueStatusStatus);
                                setActAndLogStatus(message, "LSValueStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<LSValueStatusStatus> payload = ::boost::static_pointer_cast<LSValueStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< LSValueStatusStatus >& refNullableStatus = proxy->_lSValueStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((LSValueStatusCallbackIF*) _callback)->onLSValueStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((LSValueStatusCallbackIF*) _callback)->onLSValueStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::LSValueStatusError);
                                setActAndLogError(message, "LSValueStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((LSValueStatusCallbackIF*) _callback)->onLSValueStatusError(proxy, ::boost::static_pointer_cast<LSValueStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_PDCAttenuationLevel: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::PDCAttenuationLevelStatus);
                                setActAndLogStatus(message, "PDCAttenuationLevel", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<PDCAttenuationLevelStatus> payload = ::boost::static_pointer_cast<PDCAttenuationLevelStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< PDCAttenuationLevelStatus >& refNullableStatus = proxy->_pDCAttenuationLevel;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((PDCAttenuationLevelCallbackIF*) _callback)->onPDCAttenuationLevelStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((PDCAttenuationLevelCallbackIF*) _callback)->onPDCAttenuationLevelStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::PDCAttenuationLevelError);
                                setActAndLogError(message, "PDCAttenuationLevel", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((PDCAttenuationLevelCallbackIF*) _callback)->onPDCAttenuationLevelError(proxy, ::boost::static_pointer_cast<PDCAttenuationLevelError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_PDCAttenuation: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::PDCAttenuationStatus);
                                setActAndLogStatus(message, "PDCAttenuation", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<PDCAttenuationStatus> payload = ::boost::static_pointer_cast<PDCAttenuationStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< PDCAttenuationStatus >& refNullableStatus = proxy->_pDCAttenuation;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((PDCAttenuationCallbackIF*) _callback)->onPDCAttenuationStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((PDCAttenuationCallbackIF*) _callback)->onPDCAttenuationStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::PDCAttenuationError);
                                setActAndLogError(message, "PDCAttenuation", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((PDCAttenuationCallbackIF*) _callback)->onPDCAttenuationError(proxy, ::boost::static_pointer_cast<PDCAttenuationError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AudioDeviceStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AudioDeviceStatusStatus);
                                setActAndLogStatus(message, "AudioDeviceStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AudioDeviceStatusStatus> payload = ::boost::static_pointer_cast<AudioDeviceStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AudioDeviceStatusStatus >& refNullableStatus = proxy->_audioDeviceStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AudioDeviceStatusCallbackIF*) _callback)->onAudioDeviceStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AudioDeviceStatusCallbackIF*) _callback)->onAudioDeviceStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AudioDeviceStatusError);
                                setActAndLogError(message, "AudioDeviceStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AudioDeviceStatusCallbackIF*) _callback)->onAudioDeviceStatusError(proxy, ::boost::static_pointer_cast<AudioDeviceStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_OverTempReduction: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::OverTempReductionStatus);
                                setActAndLogStatus(message, "OverTempReduction", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<OverTempReductionStatus> payload = ::boost::static_pointer_cast<OverTempReductionStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< OverTempReductionStatus >& refNullableStatus = proxy->_overTempReduction;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((OverTempReductionCallbackIF*) _callback)->onOverTempReductionStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((OverTempReductionCallbackIF*) _callback)->onOverTempReductionStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::OverTempReductionError);
                                setActAndLogError(message, "OverTempReduction", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((OverTempReductionCallbackIF*) _callback)->onOverTempReductionError(proxy, ::boost::static_pointer_cast<OverTempReductionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_OverTempAmplifierStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::OverTempAmplifierStatusStatus);
                                setActAndLogStatus(message, "OverTempAmplifierStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<OverTempAmplifierStatusStatus> payload = ::boost::static_pointer_cast<OverTempAmplifierStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< OverTempAmplifierStatusStatus >& refNullableStatus = proxy->_overTempAmplifierStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((OverTempAmplifierStatusCallbackIF*) _callback)->onOverTempAmplifierStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((OverTempAmplifierStatusCallbackIF*) _callback)->onOverTempAmplifierStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::OverTempAmplifierStatusError);
                                setActAndLogError(message, "OverTempAmplifierStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((OverTempAmplifierStatusCallbackIF*) _callback)->onOverTempAmplifierStatusError(proxy, ::boost::static_pointer_cast<OverTempAmplifierStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ReadMeasurementResult: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ReadMeasurementResultStatus);
                                setActAndLogStatus(message, "ReadMeasurementResult", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ReadMeasurementResultStatus> payload = ::boost::static_pointer_cast<ReadMeasurementResultStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ReadMeasurementResultStatus >& refNullableStatus = proxy->_readMeasurementResult;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ReadMeasurementResultCallbackIF*) _callback)->onReadMeasurementResultStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ReadMeasurementResultCallbackIF*) _callback)->onReadMeasurementResultStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ReadMeasurementResultError);
                                setActAndLogError(message, "ReadMeasurementResult", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ReadMeasurementResultCallbackIF*) _callback)->onReadMeasurementResultError(proxy, ::boost::static_pointer_cast<ReadMeasurementResultError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Center: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::CenterStatus);
                                setActAndLogStatus(message, "Center", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<CenterStatus> payload = ::boost::static_pointer_cast<CenterStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< CenterStatus >& refNullableStatus = proxy->_center;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((CenterCallbackIF*) _callback)->onCenterStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((CenterCallbackIF*) _callback)->onCenterStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::CenterError);
                                setActAndLogError(message, "Center", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((CenterCallbackIF*) _callback)->onCenterError(proxy, ::boost::static_pointer_cast<CenterError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SubWoofer: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::SubWooferStatus);
                                setActAndLogStatus(message, "SubWoofer", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SubWooferStatus> payload = ::boost::static_pointer_cast<SubWooferStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SubWooferStatus >& refNullableStatus = proxy->_subWoofer;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SubWooferCallbackIF*) _callback)->onSubWooferStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SubWooferCallbackIF*) _callback)->onSubWooferStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::SubWooferError);
                                setActAndLogError(message, "SubWoofer", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SubWooferCallbackIF*) _callback)->onSubWooferError(proxy, ::boost::static_pointer_cast<SubWooferError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ExternalAmplifierConnectionState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ExternalAmplifierConnectionStateStatus);
                                setActAndLogStatus(message, "ExternalAmplifierConnectionState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ExternalAmplifierConnectionStateStatus> payload = ::boost::static_pointer_cast<ExternalAmplifierConnectionStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ExternalAmplifierConnectionStateStatus >& refNullableStatus = proxy->_externalAmplifierConnectionState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ExternalAmplifierConnectionStateCallbackIF*) _callback)->onExternalAmplifierConnectionStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ExternalAmplifierConnectionStateCallbackIF*) _callback)->onExternalAmplifierConnectionStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ExternalAmplifierConnectionStateError);
                                setActAndLogError(message, "ExternalAmplifierConnectionState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ExternalAmplifierConnectionStateCallbackIF*) _callback)->onExternalAmplifierConnectionStateError(proxy, ::boost::static_pointer_cast<ExternalAmplifierConnectionStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GeneralSpeakerTest: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::GeneralSpeakerTestStatus);
                                setActAndLogStatus(message, "GeneralSpeakerTest", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<GeneralSpeakerTestStatus> payload = ::boost::static_pointer_cast<GeneralSpeakerTestStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< GeneralSpeakerTestStatus >& refNullableStatus = proxy->_generalSpeakerTest;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((GeneralSpeakerTestCallbackIF*) _callback)->onGeneralSpeakerTestStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((GeneralSpeakerTestCallbackIF*) _callback)->onGeneralSpeakerTestStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::GeneralSpeakerTestError);
                                setActAndLogError(message, "GeneralSpeakerTest", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((GeneralSpeakerTestCallbackIF*) _callback)->onGeneralSpeakerTestError(proxy, ::boost::static_pointer_cast<GeneralSpeakerTestError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ANCSWVersion: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ANCSWVersionStatus);
                                setActAndLogStatus(message, "ANCSWVersion", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ANCSWVersionStatus> payload = ::boost::static_pointer_cast<ANCSWVersionStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ANCSWVersionStatus >& refNullableStatus = proxy->_aNCSWVersion;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ANCSWVersionCallbackIF*) _callback)->onANCSWVersionStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ANCSWVersionCallbackIF*) _callback)->onANCSWVersionStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ANCSWVersionError);
                                setActAndLogError(message, "ANCSWVersion", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ANCSWVersionCallbackIF*) _callback)->onANCSWVersionError(proxy, ::boost::static_pointer_cast<ANCSWVersionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ASCSWVersion: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ASCSWVersionStatus);
                                setActAndLogStatus(message, "ASCSWVersion", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ASCSWVersionStatus> payload = ::boost::static_pointer_cast<ASCSWVersionStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ASCSWVersionStatus >& refNullableStatus = proxy->_aSCSWVersion;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ASCSWVersionCallbackIF*) _callback)->onASCSWVersionStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ASCSWVersionCallbackIF*) _callback)->onASCSWVersionStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ASCSWVersionError);
                                setActAndLogError(message, "ASCSWVersion", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ASCSWVersionCallbackIF*) _callback)->onASCSWVersionError(proxy, ::boost::static_pointer_cast<ASCSWVersionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ANCASCSetting: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ANCASCSettingStatus);
                                setActAndLogStatus(message, "ANCASCSetting", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ANCASCSettingStatus> payload = ::boost::static_pointer_cast<ANCASCSettingStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ANCASCSettingStatus >& refNullableStatus = proxy->_aNCASCSetting;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ANCASCSettingCallbackIF*) _callback)->onANCASCSettingStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ANCASCSettingCallbackIF*) _callback)->onANCASCSettingStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ANCASCSettingError);
                                setActAndLogError(message, "ANCASCSetting", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ANCASCSettingCallbackIF*) _callback)->onANCASCSettingError(proxy, ::boost::static_pointer_cast<ANCASCSettingError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AmpSoftwareVersion: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AmpSoftwareVersionStatus);
                                setActAndLogStatus(message, "AmpSoftwareVersion", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AmpSoftwareVersionStatus> payload = ::boost::static_pointer_cast<AmpSoftwareVersionStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AmpSoftwareVersionStatus >& refNullableStatus = proxy->_ampSoftwareVersion;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AmpSoftwareVersionCallbackIF*) _callback)->onAmpSoftwareVersionStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AmpSoftwareVersionCallbackIF*) _callback)->onAmpSoftwareVersionStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AmpSoftwareVersionError);
                                setActAndLogError(message, "AmpSoftwareVersion", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AmpSoftwareVersionCallbackIF*) _callback)->onAmpSoftwareVersionError(proxy, ::boost::static_pointer_cast<AmpSoftwareVersionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AmpParameterVersion: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AmpParameterVersionStatus);
                                setActAndLogStatus(message, "AmpParameterVersion", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AmpParameterVersionStatus> payload = ::boost::static_pointer_cast<AmpParameterVersionStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AmpParameterVersionStatus >& refNullableStatus = proxy->_ampParameterVersion;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AmpParameterVersionCallbackIF*) _callback)->onAmpParameterVersionStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AmpParameterVersionCallbackIF*) _callback)->onAmpParameterVersionStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AmpParameterVersionError);
                                setActAndLogError(message, "AmpParameterVersion", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AmpParameterVersionCallbackIF*) _callback)->onAmpParameterVersionError(proxy, ::boost::static_pointer_cast<AmpParameterVersionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AmpHardwareVersion: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AmpHardwareVersionStatus);
                                setActAndLogStatus(message, "AmpHardwareVersion", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AmpHardwareVersionStatus> payload = ::boost::static_pointer_cast<AmpHardwareVersionStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AmpHardwareVersionStatus >& refNullableStatus = proxy->_ampHardwareVersion;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AmpHardwareVersionCallbackIF*) _callback)->onAmpHardwareVersionStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AmpHardwareVersionCallbackIF*) _callback)->onAmpHardwareVersionStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AmpHardwareVersionError);
                                setActAndLogError(message, "AmpHardwareVersion", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AmpHardwareVersionCallbackIF*) _callback)->onAmpHardwareVersionError(proxy, ::boost::static_pointer_cast<AmpHardwareVersionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SurroundVol: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::SurroundVolStatus);
                                setActAndLogStatus(message, "SurroundVol", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SurroundVolStatus> payload = ::boost::static_pointer_cast<SurroundVolStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SurroundVolStatus >& refNullableStatus = proxy->_surroundVol;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SurroundVolCallbackIF*) _callback)->onSurroundVolStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SurroundVolCallbackIF*) _callback)->onSurroundVolStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::SurroundVolError);
                                setActAndLogError(message, "SurroundVol", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SurroundVolCallbackIF*) _callback)->onSurroundVolError(proxy, ::boost::static_pointer_cast<SurroundVolError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AudioPilotMode: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AudioPilotModeStatus);
                                setActAndLogStatus(message, "AudioPilotMode", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AudioPilotModeStatus> payload = ::boost::static_pointer_cast<AudioPilotModeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AudioPilotModeStatus >& refNullableStatus = proxy->_audioPilotMode;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AudioPilotModeCallbackIF*) _callback)->onAudioPilotModeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AudioPilotModeCallbackIF*) _callback)->onAudioPilotModeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AudioPilotModeError);
                                setActAndLogError(message, "AudioPilotMode", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AudioPilotModeCallbackIF*) _callback)->onAudioPilotModeError(proxy, ::boost::static_pointer_cast<AudioPilotModeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SurroundMode: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::SurroundModeStatus);
                                setActAndLogStatus(message, "SurroundMode", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SurroundModeStatus> payload = ::boost::static_pointer_cast<SurroundModeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SurroundModeStatus >& refNullableStatus = proxy->_surroundMode;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SurroundModeCallbackIF*) _callback)->onSurroundModeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SurroundModeCallbackIF*) _callback)->onSurroundModeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::SurroundModeError);
                                setActAndLogError(message, "SurroundMode", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SurroundModeCallbackIF*) _callback)->onSurroundModeError(proxy, ::boost::static_pointer_cast<SurroundModeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AmpDownMixMode: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AmpDownMixModeStatus);
                                setActAndLogStatus(message, "AmpDownMixMode", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AmpDownMixModeStatus> payload = ::boost::static_pointer_cast<AmpDownMixModeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AmpDownMixModeStatus >& refNullableStatus = proxy->_ampDownMixMode;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AmpDownMixModeCallbackIF*) _callback)->onAmpDownMixModeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AmpDownMixModeCallbackIF*) _callback)->onAmpDownMixModeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AmpDownMixModeError);
                                setActAndLogError(message, "AmpDownMixMode", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AmpDownMixModeCallbackIF*) _callback)->onAmpDownMixModeError(proxy, ::boost::static_pointer_cast<AmpDownMixModeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DriverSoundMode: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::DriverSoundModeStatus);
                                setActAndLogStatus(message, "DriverSoundMode", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DriverSoundModeStatus> payload = ::boost::static_pointer_cast<DriverSoundModeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DriverSoundModeStatus >& refNullableStatus = proxy->_driverSoundMode;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DriverSoundModeCallbackIF*) _callback)->onDriverSoundModeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DriverSoundModeCallbackIF*) _callback)->onDriverSoundModeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::DriverSoundModeError);
                                setActAndLogError(message, "DriverSoundMode", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DriverSoundModeCallbackIF*) _callback)->onDriverSoundModeError(proxy, ::boost::static_pointer_cast<DriverSoundModeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RearSoundMode: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::RearSoundModeStatus);
                                setActAndLogStatus(message, "RearSoundMode", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<RearSoundModeStatus> payload = ::boost::static_pointer_cast<RearSoundModeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< RearSoundModeStatus >& refNullableStatus = proxy->_rearSoundMode;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((RearSoundModeCallbackIF*) _callback)->onRearSoundModeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RearSoundModeCallbackIF*) _callback)->onRearSoundModeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::RearSoundModeError);
                                setActAndLogError(message, "RearSoundMode", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RearSoundModeCallbackIF*) _callback)->onRearSoundModeError(proxy, ::boost::static_pointer_cast<RearSoundModeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AudioOFFMuteState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AudioOFFMuteStateStatus);
                                setActAndLogStatus(message, "AudioOFFMuteState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AudioOFFMuteStateStatus> payload = ::boost::static_pointer_cast<AudioOFFMuteStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AudioOFFMuteStateStatus >& refNullableStatus = proxy->_audioOFFMuteState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AudioOFFMuteStateCallbackIF*) _callback)->onAudioOFFMuteStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AudioOFFMuteStateCallbackIF*) _callback)->onAudioOFFMuteStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AudioOFFMuteStateError);
                                setActAndLogError(message, "AudioOFFMuteState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AudioOFFMuteStateCallbackIF*) _callback)->onAudioOFFMuteStateError(proxy, ::boost::static_pointer_cast<AudioOFFMuteStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_MicrophoneConnectionStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::MicrophoneConnectionStatusStatus);
                                setActAndLogStatus(message, "MicrophoneConnectionStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<MicrophoneConnectionStatusStatus> payload = ::boost::static_pointer_cast<MicrophoneConnectionStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< MicrophoneConnectionStatusStatus >& refNullableStatus = proxy->_microphoneConnectionStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((MicrophoneConnectionStatusCallbackIF*) _callback)->onMicrophoneConnectionStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((MicrophoneConnectionStatusCallbackIF*) _callback)->onMicrophoneConnectionStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::MicrophoneConnectionStatusError);
                                setActAndLogError(message, "MicrophoneConnectionStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((MicrophoneConnectionStatusCallbackIF*) _callback)->onMicrophoneConnectionStatusError(proxy, ::boost::static_pointer_cast<MicrophoneConnectionStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Connection: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ConnectionStatus);
                                setActAndLogStatus(message, "Connection", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ConnectionStatus> payload = ::boost::static_pointer_cast<ConnectionStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ConnectionStatus >& refNullableStatus = proxy->_connection;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ConnectionCallbackIF*) _callback)->onConnectionStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ConnectionCallbackIF*) _callback)->onConnectionStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ConnectionError);
                                setActAndLogError(message, "Connection", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((ConnectionCallbackIF*) _callback)->onConnectionError(proxy, ::boost::static_pointer_cast<ConnectionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_VolumeList: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::VolumeListStatus);
                                setActAndLogStatus(message, "VolumeList", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<VolumeListStatus> payload = ::boost::static_pointer_cast<VolumeListStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< VolumeListStatus >& refNullableStatus = proxy->_volumeList;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((VolumeListCallbackIF*) _callback)->onVolumeListStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((VolumeListCallbackIF*) _callback)->onVolumeListStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::VolumeListError);
                                setActAndLogError(message, "VolumeList", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((VolumeListCallbackIF*) _callback)->onVolumeListError(proxy, ::boost::static_pointer_cast<VolumeListError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_BTAudioInLevel: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::BTAudioInLevelStatus);
                                setActAndLogStatus(message, "BTAudioInLevel", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<BTAudioInLevelStatus> payload = ::boost::static_pointer_cast<BTAudioInLevelStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< BTAudioInLevelStatus >& refNullableStatus = proxy->_bTAudioInLevel;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((BTAudioInLevelCallbackIF*) _callback)->onBTAudioInLevelStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((BTAudioInLevelCallbackIF*) _callback)->onBTAudioInLevelStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::BTAudioInLevelError);
                                setActAndLogError(message, "BTAudioInLevel", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((BTAudioInLevelCallbackIF*) _callback)->onBTAudioInLevelError(proxy, ::boost::static_pointer_cast<BTAudioInLevelError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_EngineeringData: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::EngineeringDataStatus);
                                setActAndLogStatus(message, "EngineeringData", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<EngineeringDataStatus> payload = ::boost::static_pointer_cast<EngineeringDataStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< EngineeringDataStatus >& refNullableStatus = proxy->_engineeringData;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((EngineeringDataCallbackIF*) _callback)->onEngineeringDataStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((EngineeringDataCallbackIF*) _callback)->onEngineeringDataStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::EngineeringDataError);
                                setActAndLogError(message, "EngineeringData", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((EngineeringDataCallbackIF*) _callback)->onEngineeringDataError(proxy, ::boost::static_pointer_cast<EngineeringDataError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SurroundSetting: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::SurroundSettingStatus);
                                setActAndLogStatus(message, "SurroundSetting", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SurroundSettingStatus> payload = ::boost::static_pointer_cast<SurroundSettingStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SurroundSettingStatus >& refNullableStatus = proxy->_surroundSetting;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SurroundSettingCallbackIF*) _callback)->onSurroundSettingStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SurroundSettingCallbackIF*) _callback)->onSurroundSettingStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::SurroundSettingError);
                                setActAndLogError(message, "SurroundSetting", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SurroundSettingCallbackIF*) _callback)->onSurroundSettingError(proxy, ::boost::static_pointer_cast<SurroundSettingError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_VolumeLock: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::VolumeLockStatus);
                                setActAndLogStatus(message, "VolumeLock", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<VolumeLockStatus> payload = ::boost::static_pointer_cast<VolumeLockStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< VolumeLockStatus >& refNullableStatus = proxy->_volumeLock;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((VolumeLockCallbackIF*) _callback)->onVolumeLockStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((VolumeLockCallbackIF*) _callback)->onVolumeLockStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::VolumeLockError);
                                setActAndLogError(message, "VolumeLock", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((VolumeLockCallbackIF*) _callback)->onVolumeLockError(proxy, ::boost::static_pointer_cast<VolumeLockError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AmpAvailFunction: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AmpAvailFunctionStatus);
                                setActAndLogStatus(message, "AmpAvailFunction", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AmpAvailFunctionStatus> payload = ::boost::static_pointer_cast<AmpAvailFunctionStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AmpAvailFunctionStatus >& refNullableStatus = proxy->_ampAvailFunction;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AmpAvailFunctionCallbackIF*) _callback)->onAmpAvailFunctionStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AmpAvailFunctionCallbackIF*) _callback)->onAmpAvailFunctionStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AmpAvailFunctionError);
                                setActAndLogError(message, "AmpAvailFunction", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AmpAvailFunctionCallbackIF*) _callback)->onAmpAvailFunctionError(proxy, ::boost::static_pointer_cast<AmpAvailFunctionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetAudioProperty: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::SetAudioPropertyStatus);
                                setActAndLogStatus(message, "SetAudioProperty", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SetAudioPropertyStatus> payload = ::boost::static_pointer_cast<SetAudioPropertyStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SetAudioPropertyStatus >& refNullableStatus = proxy->_setAudioProperty;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SetAudioPropertyCallbackIF*) _callback)->onSetAudioPropertyStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SetAudioPropertyCallbackIF*) _callback)->onSetAudioPropertyStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::SetAudioPropertyError);
                                setActAndLogError(message, "SetAudioProperty", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SetAudioPropertyCallbackIF*) _callback)->onSetAudioPropertyError(proxy, ::boost::static_pointer_cast<SetAudioPropertyError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_EntOnVolumeSetup: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::EntOnVolumeSetupStatus);
                                setActAndLogStatus(message, "EntOnVolumeSetup", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<EntOnVolumeSetupStatus> payload = ::boost::static_pointer_cast<EntOnVolumeSetupStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< EntOnVolumeSetupStatus >& refNullableStatus = proxy->_entOnVolumeSetup;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((EntOnVolumeSetupCallbackIF*) _callback)->onEntOnVolumeSetupStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((EntOnVolumeSetupCallbackIF*) _callback)->onEntOnVolumeSetupStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::EntOnVolumeSetupError);
                                setActAndLogError(message, "EntOnVolumeSetup", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((EntOnVolumeSetupCallbackIF*) _callback)->onEntOnVolumeSetupError(proxy, ::boost::static_pointer_cast<EntOnVolumeSetupError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RoomEffect: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::RoomEffectStatus);
                                setActAndLogStatus(message, "RoomEffect", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<RoomEffectStatus> payload = ::boost::static_pointer_cast<RoomEffectStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< RoomEffectStatus >& refNullableStatus = proxy->_roomEffect;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((RoomEffectCallbackIF*) _callback)->onRoomEffectStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RoomEffectCallbackIF*) _callback)->onRoomEffectStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::RoomEffectError);
                                setActAndLogError(message, "RoomEffect", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RoomEffectCallbackIF*) _callback)->onRoomEffectError(proxy, ::boost::static_pointer_cast<RoomEffectError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_FMEnhancerMode: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::FMEnhancerModeStatus);
                                setActAndLogStatus(message, "FMEnhancerMode", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<FMEnhancerModeStatus> payload = ::boost::static_pointer_cast<FMEnhancerModeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< FMEnhancerModeStatus >& refNullableStatus = proxy->_fMEnhancerMode;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((FMEnhancerModeCallbackIF*) _callback)->onFMEnhancerModeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((FMEnhancerModeCallbackIF*) _callback)->onFMEnhancerModeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::FMEnhancerModeError);
                                setActAndLogError(message, "FMEnhancerMode", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((FMEnhancerModeCallbackIF*) _callback)->onFMEnhancerModeError(proxy, ::boost::static_pointer_cast<FMEnhancerModeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DiagDefSetPhase: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::DiagDefSetPhaseStatus);
                                setActAndLogStatus(message, "DiagDefSetPhase", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DiagDefSetPhaseStatus> payload = ::boost::static_pointer_cast<DiagDefSetPhaseStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DiagDefSetPhaseStatus >& refNullableStatus = proxy->_diagDefSetPhase;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DiagDefSetPhaseCallbackIF*) _callback)->onDiagDefSetPhaseStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DiagDefSetPhaseCallbackIF*) _callback)->onDiagDefSetPhaseStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::DiagDefSetPhaseError);
                                setActAndLogError(message, "DiagDefSetPhase", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DiagDefSetPhaseCallbackIF*) _callback)->onDiagDefSetPhaseError(proxy, ::boost::static_pointer_cast<DiagDefSetPhaseError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ESESoundType: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ESESoundTypeStatus);
                                setActAndLogStatus(message, "ESESoundType", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ESESoundTypeStatus> payload = ::boost::static_pointer_cast<ESESoundTypeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ESESoundTypeStatus >& refNullableStatus = proxy->_eSESoundType;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ESESoundTypeCallbackIF*) _callback)->onESESoundTypeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ESESoundTypeCallbackIF*) _callback)->onESESoundTypeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ESESoundTypeError);
                                setActAndLogError(message, "ESESoundType", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ESESoundTypeCallbackIF*) _callback)->onESESoundTypeError(proxy, ::boost::static_pointer_cast<ESESoundTypeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ESEVolume: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ESEVolumeStatus);
                                setActAndLogStatus(message, "ESEVolume", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ESEVolumeStatus> payload = ::boost::static_pointer_cast<ESEVolumeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ESEVolumeStatus >& refNullableStatus = proxy->_eSEVolume;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ESEVolumeCallbackIF*) _callback)->onESEVolumeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ESEVolumeCallbackIF*) _callback)->onESEVolumeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ESEVolumeError);
                                setActAndLogError(message, "ESEVolume", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ESEVolumeCallbackIF*) _callback)->onESEVolumeError(proxy, ::boost::static_pointer_cast<ESEVolumeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RSoundOnOff: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::RSoundOnOffStatus);
                                setActAndLogStatus(message, "RSoundOnOff", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<RSoundOnOffStatus> payload = ::boost::static_pointer_cast<RSoundOnOffStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< RSoundOnOffStatus >& refNullableStatus = proxy->_rSoundOnOff;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((RSoundOnOffCallbackIF*) _callback)->onRSoundOnOffStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RSoundOnOffCallbackIF*) _callback)->onRSoundOnOffStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::RSoundOnOffError);
                                setActAndLogError(message, "RSoundOnOff", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RSoundOnOffCallbackIF*) _callback)->onRSoundOnOffError(proxy, ::boost::static_pointer_cast<RSoundOnOffError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RSoundSoundType: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::RSoundSoundTypeStatus);
                                setActAndLogStatus(message, "RSoundSoundType", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<RSoundSoundTypeStatus> payload = ::boost::static_pointer_cast<RSoundSoundTypeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< RSoundSoundTypeStatus >& refNullableStatus = proxy->_rSoundSoundType;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((RSoundSoundTypeCallbackIF*) _callback)->onRSoundSoundTypeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RSoundSoundTypeCallbackIF*) _callback)->onRSoundSoundTypeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::RSoundSoundTypeError);
                                setActAndLogError(message, "RSoundSoundType", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RSoundSoundTypeCallbackIF*) _callback)->onRSoundSoundTypeError(proxy, ::boost::static_pointer_cast<RSoundSoundTypeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RSoundVolume: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::RSoundVolumeStatus);
                                setActAndLogStatus(message, "RSoundVolume", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<RSoundVolumeStatus> payload = ::boost::static_pointer_cast<RSoundVolumeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< RSoundVolumeStatus >& refNullableStatus = proxy->_rSoundVolume;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((RSoundVolumeCallbackIF*) _callback)->onRSoundVolumeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RSoundVolumeCallbackIF*) _callback)->onRSoundVolumeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::RSoundVolumeError);
                                setActAndLogError(message, "RSoundVolume", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RSoundVolumeCallbackIF*) _callback)->onRSoundVolumeError(proxy, ::boost::static_pointer_cast<RSoundVolumeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ESEDriveMode: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ESEDriveModeStatus);
                                setActAndLogStatus(message, "ESEDriveMode", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ESEDriveModeStatus> payload = ::boost::static_pointer_cast<ESEDriveModeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ESEDriveModeStatus >& refNullableStatus = proxy->_eSEDriveMode;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ESEDriveModeCallbackIF*) _callback)->onESEDriveModeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ESEDriveModeCallbackIF*) _callback)->onESEDriveModeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ESEDriveModeError);
                                setActAndLogError(message, "ESEDriveMode", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ESEDriveModeCallbackIF*) _callback)->onESEDriveModeError(proxy, ::boost::static_pointer_cast<ESEDriveModeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AudioMode: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AudioModeStatus);
                                setActAndLogStatus(message, "AudioMode", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AudioModeStatus> payload = ::boost::static_pointer_cast<AudioModeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AudioModeStatus >& refNullableStatus = proxy->_audioMode;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AudioModeCallbackIF*) _callback)->onAudioModeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AudioModeCallbackIF*) _callback)->onAudioModeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AudioModeError);
                                setActAndLogError(message, "AudioMode", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AudioModeCallbackIF*) _callback)->onAudioModeError(proxy, ::boost::static_pointer_cast<AudioModeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ADAS_UPASoundType: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ADAS_UPASoundTypeStatus);
                                setActAndLogStatus(message, "ADAS_UPASoundType", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ADAS_UPASoundTypeStatus> payload = ::boost::static_pointer_cast<ADAS_UPASoundTypeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ADAS_UPASoundTypeStatus >& refNullableStatus = proxy->_aDAS_UPASoundType;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ADAS_UPASoundTypeCallbackIF*) _callback)->onADAS_UPASoundTypeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ADAS_UPASoundTypeCallbackIF*) _callback)->onADAS_UPASoundTypeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ADAS_UPASoundTypeError);
                                setActAndLogError(message, "ADAS_UPASoundType", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ADAS_UPASoundTypeCallbackIF*) _callback)->onADAS_UPASoundTypeError(proxy, ::boost::static_pointer_cast<ADAS_UPASoundTypeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ADAS_ParkAssistVolume: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ADAS_ParkAssistVolumeStatus);
                                setActAndLogStatus(message, "ADAS_ParkAssistVolume", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ADAS_ParkAssistVolumeStatus> payload = ::boost::static_pointer_cast<ADAS_ParkAssistVolumeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ADAS_ParkAssistVolumeStatus >& refNullableStatus = proxy->_aDAS_ParkAssistVolume;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ADAS_ParkAssistVolumeCallbackIF*) _callback)->onADAS_ParkAssistVolumeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ADAS_ParkAssistVolumeCallbackIF*) _callback)->onADAS_ParkAssistVolumeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ADAS_ParkAssistVolumeError);
                                setActAndLogError(message, "ADAS_ParkAssistVolume", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ADAS_ParkAssistVolumeCallbackIF*) _callback)->onADAS_ParkAssistVolumeError(proxy, ::boost::static_pointer_cast<ADAS_ParkAssistVolumeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ADAS_UPAMute: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ADAS_UPAMuteStatus);
                                setActAndLogStatus(message, "ADAS_UPAMute", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ADAS_UPAMuteStatus> payload = ::boost::static_pointer_cast<ADAS_UPAMuteStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ADAS_UPAMuteStatus >& refNullableStatus = proxy->_aDAS_UPAMute;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ADAS_UPAMuteCallbackIF*) _callback)->onADAS_UPAMuteStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ADAS_UPAMuteCallbackIF*) _callback)->onADAS_UPAMuteStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ADAS_UPAMuteError);
                                setActAndLogError(message, "ADAS_UPAMute", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ADAS_UPAMuteCallbackIF*) _callback)->onADAS_UPAMuteError(proxy, ::boost::static_pointer_cast<ADAS_UPAMuteError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AutomaticGainControl: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AutomaticGainControlStatus);
                                setActAndLogStatus(message, "AutomaticGainControl", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AutomaticGainControlStatus> payload = ::boost::static_pointer_cast<AutomaticGainControlStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AutomaticGainControlStatus >& refNullableStatus = proxy->_automaticGainControl;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AutomaticGainControlCallbackIF*) _callback)->onAutomaticGainControlStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AutomaticGainControlCallbackIF*) _callback)->onAutomaticGainControlStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AutomaticGainControlError);
                                setActAndLogError(message, "AutomaticGainControl", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AutomaticGainControlCallbackIF*) _callback)->onAutomaticGainControlError(proxy, ::boost::static_pointer_cast<AutomaticGainControlError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ADAS_LDW_UserVolume: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ADAS_LDW_UserVolumeStatus);
                                setActAndLogStatus(message, "ADAS_LDW_UserVolume", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ADAS_LDW_UserVolumeStatus> payload = ::boost::static_pointer_cast<ADAS_LDW_UserVolumeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ADAS_LDW_UserVolumeStatus >& refNullableStatus = proxy->_aDAS_LDW_UserVolume;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ADAS_LDW_UserVolumeCallbackIF*) _callback)->onADAS_LDW_UserVolumeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ADAS_LDW_UserVolumeCallbackIF*) _callback)->onADAS_LDW_UserVolumeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ADAS_LDW_UserVolumeError);
                                setActAndLogError(message, "ADAS_LDW_UserVolume", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ADAS_LDW_UserVolumeCallbackIF*) _callback)->onADAS_LDW_UserVolumeError(proxy, ::boost::static_pointer_cast<ADAS_LDW_UserVolumeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RSoundActivation: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::RSoundActivationStatus);
                                setActAndLogStatus(message, "RSoundActivation", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<RSoundActivationStatus> payload = ::boost::static_pointer_cast<RSoundActivationStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< RSoundActivationStatus >& refNullableStatus = proxy->_rSoundActivation;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((RSoundActivationCallbackIF*) _callback)->onRSoundActivationStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RSoundActivationCallbackIF*) _callback)->onRSoundActivationStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::RSoundActivationError);
                                setActAndLogError(message, "RSoundActivation", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((RSoundActivationCallbackIF*) _callback)->onRSoundActivationError(proxy, ::boost::static_pointer_cast<RSoundActivationError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ANCASCActiveTest: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ANCASCActiveTestStatus);
                                setActAndLogStatus(message, "ANCASCActiveTest", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ANCASCActiveTestStatus> payload = ::boost::static_pointer_cast<ANCASCActiveTestStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ANCASCActiveTestStatus >& refNullableStatus = proxy->_aNCASCActiveTest;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ANCASCActiveTestCallbackIF*) _callback)->onANCASCActiveTestStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ANCASCActiveTestCallbackIF*) _callback)->onANCASCActiveTestStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ANCASCActiveTestError);
                                setActAndLogError(message, "ANCASCActiveTest", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ANCASCActiveTestCallbackIF*) _callback)->onANCASCActiveTestError(proxy, ::boost::static_pointer_cast<ANCASCActiveTestError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ANCASCSelfDiagnosticStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ANCASCSelfDiagnosticStatusStatus);
                                setActAndLogStatus(message, "ANCASCSelfDiagnosticStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ANCASCSelfDiagnosticStatusStatus> payload = ::boost::static_pointer_cast<ANCASCSelfDiagnosticStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ANCASCSelfDiagnosticStatusStatus >& refNullableStatus = proxy->_aNCASCSelfDiagnosticStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ANCASCSelfDiagnosticStatusCallbackIF*) _callback)->onANCASCSelfDiagnosticStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ANCASCSelfDiagnosticStatusCallbackIF*) _callback)->onANCASCSelfDiagnosticStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::ANCASCSelfDiagnosticStatusError);
                                setActAndLogError(message, "ANCASCSelfDiagnosticStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ANCASCSelfDiagnosticStatusCallbackIF*) _callback)->onANCASCSelfDiagnosticStatusError(proxy, ::boost::static_pointer_cast<ANCASCSelfDiagnosticStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_UserProfileChange: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::UserProfileChangeStatus);
                                setActAndLogStatus(message, "UserProfileChange", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<UserProfileChangeStatus> payload = ::boost::static_pointer_cast<UserProfileChangeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< UserProfileChangeStatus >& refNullableStatus = proxy->_userProfileChange;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((UserProfileChangeCallbackIF*) _callback)->onUserProfileChangeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((UserProfileChangeCallbackIF*) _callback)->onUserProfileChangeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::UserProfileChangeError);
                                setActAndLogError(message, "UserProfileChange", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((UserProfileChangeCallbackIF*) _callback)->onUserProfileChangeError(proxy, ::boost::static_pointer_cast<UserProfileChangeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SRSoundNotificationState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::SRSoundNotificationStateStatus);
                                setActAndLogStatus(message, "SRSoundNotificationState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SRSoundNotificationStateStatus> payload = ::boost::static_pointer_cast<SRSoundNotificationStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SRSoundNotificationStateStatus >& refNullableStatus = proxy->_sRSoundNotificationState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SRSoundNotificationStateCallbackIF*) _callback)->onSRSoundNotificationStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SRSoundNotificationStateCallbackIF*) _callback)->onSRSoundNotificationStateStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::SRSoundNotificationStateError);
                                setActAndLogError(message, "SRSoundNotificationState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SRSoundNotificationStateCallbackIF*) _callback)->onSRSoundNotificationStateError(proxy, ::boost::static_pointer_cast<SRSoundNotificationStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AudioPilotIntensity: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AudioPilotIntensityStatus);
                                setActAndLogStatus(message, "AudioPilotIntensity", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AudioPilotIntensityStatus> payload = ::boost::static_pointer_cast<AudioPilotIntensityStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AudioPilotIntensityStatus >& refNullableStatus = proxy->_audioPilotIntensity;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AudioPilotIntensityCallbackIF*) _callback)->onAudioPilotIntensityStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AudioPilotIntensityCallbackIF*) _callback)->onAudioPilotIntensityStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::AudioPilotIntensityError);
                                setActAndLogError(message, "AudioPilotIntensity", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AudioPilotIntensityCallbackIF*) _callback)->onAudioPilotIntensityError(proxy, ::boost::static_pointer_cast<AudioPilotIntensityError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_MainAudioAttenuation: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::MainAudioAttenuationStatus);
                                setActAndLogStatus(message, "MainAudioAttenuation", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<MainAudioAttenuationStatus> payload = ::boost::static_pointer_cast<MainAudioAttenuationStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< MainAudioAttenuationStatus >& refNullableStatus = proxy->_mainAudioAttenuation;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((MainAudioAttenuationCallbackIF*) _callback)->onMainAudioAttenuationStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::mascf_main_fi::MainAudioAttenuationError);
                                setActAndLogError(message, "MainAudioAttenuation", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((MainAudioAttenuationCallbackIF*) _callback)->onMainAudioAttenuationError(proxy, ::boost::static_pointer_cast<MainAudioAttenuationError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Mascf_main_fiProxy> proxy = ::boost::static_pointer_cast<Mascf_main_fiProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_VolumeMode: {
                ::boost::shared_ptr< VolumeModeError > payload (new VolumeModeError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "VolumeMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((VolumeModeCallbackIF*) _callback)->onVolumeModeError (proxy, payload);
                return true;
            }
            case FID_Beep: {
                ::boost::shared_ptr< BeepError > payload (new BeepError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Beep", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((BeepCallbackIF*) _callback)->onBeepError (proxy, payload);
                return true;
            }
            case FID_BeepFile: {
                ::boost::shared_ptr< BeepFileError > payload (new BeepFileError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BeepFile", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((BeepFileCallbackIF*) _callback)->onBeepFileError (proxy, payload);
                return true;
            }
            case FID_Mute: {
                ::boost::shared_ptr< MuteError > payload (new MuteError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Mute", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((MuteCallbackIF*) _callback)->onMuteError (proxy, payload);
                return true;
            }
            case FID_Set_Mute_Ramp: {
                ::boost::shared_ptr< Set_Mute_RampError > payload (new Set_Mute_RampError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Set_Mute_Ramp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((Set_Mute_RampCallbackIF*) _callback)->onSet_Mute_RampError (proxy, payload);
                return true;
            }
            case FID_AudioSource: {
                ::boost::shared_ptr< AudioSourceError > payload (new AudioSourceError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudioSource", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((AudioSourceCallbackIF*) _callback)->onAudioSourceError (proxy, payload);
                return true;
            }
            case FID_AmpDeviceAudioRoute: {
                ::boost::shared_ptr< AmpDeviceAudioRouteError > payload (new AmpDeviceAudioRouteError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AmpDeviceAudioRoute", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((AmpDeviceAudioRouteCallbackIF*) _callback)->onAmpDeviceAudioRouteError (proxy, payload);
                return true;
            }
            case FID_AudioTestTone: {
                ::boost::shared_ptr< AudioTestToneError > payload (new AudioTestToneError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudioTestTone", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((AudioTestToneCallbackIF*) _callback)->onAudioTestToneError (proxy, payload);
                return true;
            }
            case FID_CueState: {
                ::boost::shared_ptr< CueStateError > payload (new CueStateError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CueState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((CueStateCallbackIF*) _callback)->onCueStateError (proxy, payload);
                return true;
            }
            case FID_SpeakerDiagnosisStart: {
                ::boost::shared_ptr< SpeakerDiagnosisStartError > payload (new SpeakerDiagnosisStartError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SpeakerDiagnosisStart", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SpeakerDiagnosisStartCallbackIF*) _callback)->onSpeakerDiagnosisStartError (proxy, payload);
                return true;
            }
            case FID_SystemMute: {
                ::boost::shared_ptr< SystemMuteError > payload (new SystemMuteError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SystemMute", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SystemMuteCallbackIF*) _callback)->onSystemMuteError (proxy, payload);
                return true;
            }
            case FID_ADAS_SettingSound: {
                ::boost::shared_ptr< ADAS_SettingSoundError > payload (new ADAS_SettingSoundError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ADAS_SettingSound", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ADAS_SettingSoundCallbackIF*) _callback)->onADAS_SettingSoundError (proxy, payload);
                return true;
            }
            case FID_EntertainmentMute: {
                ::boost::shared_ptr< EntertainmentMuteError > payload (new EntertainmentMuteError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EntertainmentMute", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((EntertainmentMuteCallbackIF*) _callback)->onEntertainmentMuteError (proxy, payload);
                return true;
            }
            case FID_MCANBoseAmp_VersionInfo: {
                ::boost::shared_ptr< MCANBoseAmp_VersionInfoError > payload (new MCANBoseAmp_VersionInfoError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MCANBoseAmp_VersionInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((MCANBoseAmp_VersionInfoCallbackIF*) _callback)->onMCANBoseAmp_VersionInfoError (proxy, payload);
                return true;
            }
            case FID_VolumeModeStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< VolumeModeStatusError > payload (new VolumeModeStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "VolumeModeStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((VolumeModeStatusCallbackIF*) _callback)->onVolumeModeStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Volume: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< VolumeError > payload (new VolumeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Volume", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((VolumeCallbackIF*) _callback)->onVolumeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_BeepStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< BeepStatusError > payload (new BeepStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BeepStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((BeepStatusCallbackIF*) _callback)->onBeepStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Gala: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< GalaError > payload (new GalaError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Gala", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((GalaCallbackIF*) _callback)->onGalaError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Balance: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< BalanceError > payload (new BalanceError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Balance", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((BalanceCallbackIF*) _callback)->onBalanceError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Loudness: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< LoudnessError > payload (new LoudnessError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Loudness", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((LoudnessCallbackIF*) _callback)->onLoudnessError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Bass: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< BassError > payload (new BassError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Bass", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((BassCallbackIF*) _callback)->onBassError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Treble: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< TrebleError > payload (new TrebleError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Treble", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((TrebleCallbackIF*) _callback)->onTrebleError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Fader: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< FaderError > payload (new FaderError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Fader", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((FaderCallbackIF*) _callback)->onFaderError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_MidRange: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< MidRangeError > payload (new MidRangeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MidRange", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((MidRangeCallbackIF*) _callback)->onMidRangeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_MemSound: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< MemSoundError > payload (new MemSoundError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MemSound", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((MemSoundCallbackIF*) _callback)->onMemSoundError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_FaderActivationStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< FaderActivationStatusError > payload (new FaderActivationStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "FaderActivationStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((FaderActivationStatusCallbackIF*) _callback)->onFaderActivationStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DynamicCompression: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< DynamicCompressionError > payload (new DynamicCompressionError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DynamicCompression", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DynamicCompressionCallbackIF*) _callback)->onDynamicCompressionError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Optimization: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< OptimizationError > payload (new OptimizationError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Optimization", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((OptimizationCallbackIF*) _callback)->onOptimizationError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_EqualiserPreset: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< EqualiserPresetError > payload (new EqualiserPresetError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EqualiserPreset", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((EqualiserPresetCallbackIF*) _callback)->onEqualiserPresetError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DiagAudMode: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< DiagAudModeError > payload (new DiagAudModeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DiagAudMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DiagAudModeCallbackIF*) _callback)->onDiagAudModeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AuxInLevel: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< AuxInLevelError > payload (new AuxInLevelError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AuxInLevel", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AuxInLevelCallbackIF*) _callback)->onAuxInLevelError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_BeepLevel: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< BeepLevelError > payload (new BeepLevelError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BeepLevel", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((BeepLevelCallbackIF*) _callback)->onBeepLevelError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Rear_Mute: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< Rear_MuteError > payload (new Rear_MuteError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Rear_Mute", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((Rear_MuteCallbackIF*) _callback)->onRear_MuteError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Geometry_Mode: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< Geometry_ModeError > payload (new Geometry_ModeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Geometry_Mode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((Geometry_ModeCallbackIF*) _callback)->onGeometry_ModeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_LSValueStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< LSValueStatusError > payload (new LSValueStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "LSValueStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((LSValueStatusCallbackIF*) _callback)->onLSValueStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_PDCAttenuationLevel: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< PDCAttenuationLevelError > payload (new PDCAttenuationLevelError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PDCAttenuationLevel", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((PDCAttenuationLevelCallbackIF*) _callback)->onPDCAttenuationLevelError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_PDCAttenuation: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< PDCAttenuationError > payload (new PDCAttenuationError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PDCAttenuation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((PDCAttenuationCallbackIF*) _callback)->onPDCAttenuationError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AudioDeviceStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< AudioDeviceStatusError > payload (new AudioDeviceStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudioDeviceStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AudioDeviceStatusCallbackIF*) _callback)->onAudioDeviceStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_OverTempReduction: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< OverTempReductionError > payload (new OverTempReductionError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "OverTempReduction", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((OverTempReductionCallbackIF*) _callback)->onOverTempReductionError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_OverTempAmplifierStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< OverTempAmplifierStatusError > payload (new OverTempAmplifierStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "OverTempAmplifierStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((OverTempAmplifierStatusCallbackIF*) _callback)->onOverTempAmplifierStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ReadMeasurementResult: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< ReadMeasurementResultError > payload (new ReadMeasurementResultError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReadMeasurementResult", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ReadMeasurementResultCallbackIF*) _callback)->onReadMeasurementResultError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Center: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< CenterError > payload (new CenterError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Center", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((CenterCallbackIF*) _callback)->onCenterError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SubWoofer: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SubWooferError > payload (new SubWooferError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SubWoofer", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SubWooferCallbackIF*) _callback)->onSubWooferError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ExternalAmplifierConnectionState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< ExternalAmplifierConnectionStateError > payload (new ExternalAmplifierConnectionStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ExternalAmplifierConnectionState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ExternalAmplifierConnectionStateCallbackIF*) _callback)->onExternalAmplifierConnectionStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_GeneralSpeakerTest: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< GeneralSpeakerTestError > payload (new GeneralSpeakerTestError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GeneralSpeakerTest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((GeneralSpeakerTestCallbackIF*) _callback)->onGeneralSpeakerTestError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ANCSWVersion: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< ANCSWVersionError > payload (new ANCSWVersionError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ANCSWVersion", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ANCSWVersionCallbackIF*) _callback)->onANCSWVersionError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ASCSWVersion: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< ASCSWVersionError > payload (new ASCSWVersionError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ASCSWVersion", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ASCSWVersionCallbackIF*) _callback)->onASCSWVersionError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ANCASCSetting: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< ANCASCSettingError > payload (new ANCASCSettingError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ANCASCSetting", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ANCASCSettingCallbackIF*) _callback)->onANCASCSettingError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AmpSoftwareVersion: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< AmpSoftwareVersionError > payload (new AmpSoftwareVersionError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AmpSoftwareVersion", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AmpSoftwareVersionCallbackIF*) _callback)->onAmpSoftwareVersionError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AmpParameterVersion: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< AmpParameterVersionError > payload (new AmpParameterVersionError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AmpParameterVersion", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AmpParameterVersionCallbackIF*) _callback)->onAmpParameterVersionError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AmpHardwareVersion: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< AmpHardwareVersionError > payload (new AmpHardwareVersionError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AmpHardwareVersion", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AmpHardwareVersionCallbackIF*) _callback)->onAmpHardwareVersionError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SurroundVol: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SurroundVolError > payload (new SurroundVolError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SurroundVol", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SurroundVolCallbackIF*) _callback)->onSurroundVolError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AudioPilotMode: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< AudioPilotModeError > payload (new AudioPilotModeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudioPilotMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AudioPilotModeCallbackIF*) _callback)->onAudioPilotModeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SurroundMode: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SurroundModeError > payload (new SurroundModeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SurroundMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SurroundModeCallbackIF*) _callback)->onSurroundModeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AmpDownMixMode: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< AmpDownMixModeError > payload (new AmpDownMixModeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AmpDownMixMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AmpDownMixModeCallbackIF*) _callback)->onAmpDownMixModeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DriverSoundMode: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< DriverSoundModeError > payload (new DriverSoundModeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DriverSoundMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DriverSoundModeCallbackIF*) _callback)->onDriverSoundModeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_RearSoundMode: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< RearSoundModeError > payload (new RearSoundModeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RearSoundMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((RearSoundModeCallbackIF*) _callback)->onRearSoundModeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AudioOFFMuteState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< AudioOFFMuteStateError > payload (new AudioOFFMuteStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudioOFFMuteState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AudioOFFMuteStateCallbackIF*) _callback)->onAudioOFFMuteStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_MicrophoneConnectionStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< MicrophoneConnectionStatusError > payload (new MicrophoneConnectionStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MicrophoneConnectionStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((MicrophoneConnectionStatusCallbackIF*) _callback)->onMicrophoneConnectionStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Connection: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< ConnectionError > payload (new ConnectionError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Connection", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ConnectionCallbackIF*) _callback)->onConnectionError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_VolumeList: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< VolumeListError > payload (new VolumeListError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "VolumeList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((VolumeListCallbackIF*) _callback)->onVolumeListError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_BTAudioInLevel: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< BTAudioInLevelError > payload (new BTAudioInLevelError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BTAudioInLevel", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((BTAudioInLevelCallbackIF*) _callback)->onBTAudioInLevelError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_EngineeringData: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< EngineeringDataError > payload (new EngineeringDataError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EngineeringData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((EngineeringDataCallbackIF*) _callback)->onEngineeringDataError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SurroundSetting: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SurroundSettingError > payload (new SurroundSettingError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SurroundSetting", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SurroundSettingCallbackIF*) _callback)->onSurroundSettingError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_VolumeLock: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< VolumeLockError > payload (new VolumeLockError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "VolumeLock", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((VolumeLockCallbackIF*) _callback)->onVolumeLockError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AmpAvailFunction: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< AmpAvailFunctionError > payload (new AmpAvailFunctionError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AmpAvailFunction", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AmpAvailFunctionCallbackIF*) _callback)->onAmpAvailFunctionError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SetAudioProperty: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SetAudioPropertyError > payload (new SetAudioPropertyError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetAudioProperty", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SetAudioPropertyCallbackIF*) _callback)->onSetAudioPropertyError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_EntOnVolumeSetup: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< EntOnVolumeSetupError > payload (new EntOnVolumeSetupError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EntOnVolumeSetup", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((EntOnVolumeSetupCallbackIF*) _callback)->onEntOnVolumeSetupError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_RoomEffect: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< RoomEffectError > payload (new RoomEffectError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RoomEffect", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((RoomEffectCallbackIF*) _callback)->onRoomEffectError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_FMEnhancerMode: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< FMEnhancerModeError > payload (new FMEnhancerModeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "FMEnhancerMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((FMEnhancerModeCallbackIF*) _callback)->onFMEnhancerModeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DiagDefSetPhase: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< DiagDefSetPhaseError > payload (new DiagDefSetPhaseError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DiagDefSetPhase", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DiagDefSetPhaseCallbackIF*) _callback)->onDiagDefSetPhaseError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ESESoundType: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< ESESoundTypeError > payload (new ESESoundTypeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ESESoundType", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ESESoundTypeCallbackIF*) _callback)->onESESoundTypeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ESEVolume: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< ESEVolumeError > payload (new ESEVolumeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ESEVolume", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ESEVolumeCallbackIF*) _callback)->onESEVolumeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_RSoundOnOff: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< RSoundOnOffError > payload (new RSoundOnOffError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RSoundOnOff", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((RSoundOnOffCallbackIF*) _callback)->onRSoundOnOffError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_RSoundSoundType: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< RSoundSoundTypeError > payload (new RSoundSoundTypeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RSoundSoundType", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((RSoundSoundTypeCallbackIF*) _callback)->onRSoundSoundTypeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_RSoundVolume: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< RSoundVolumeError > payload (new RSoundVolumeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RSoundVolume", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((RSoundVolumeCallbackIF*) _callback)->onRSoundVolumeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ESEDriveMode: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< ESEDriveModeError > payload (new ESEDriveModeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ESEDriveMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ESEDriveModeCallbackIF*) _callback)->onESEDriveModeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AudioMode: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< AudioModeError > payload (new AudioModeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudioMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AudioModeCallbackIF*) _callback)->onAudioModeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ADAS_UPASoundType: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< ADAS_UPASoundTypeError > payload (new ADAS_UPASoundTypeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ADAS_UPASoundType", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ADAS_UPASoundTypeCallbackIF*) _callback)->onADAS_UPASoundTypeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ADAS_ParkAssistVolume: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< ADAS_ParkAssistVolumeError > payload (new ADAS_ParkAssistVolumeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ADAS_ParkAssistVolume", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ADAS_ParkAssistVolumeCallbackIF*) _callback)->onADAS_ParkAssistVolumeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ADAS_UPAMute: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< ADAS_UPAMuteError > payload (new ADAS_UPAMuteError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ADAS_UPAMute", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ADAS_UPAMuteCallbackIF*) _callback)->onADAS_UPAMuteError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AutomaticGainControl: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< AutomaticGainControlError > payload (new AutomaticGainControlError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AutomaticGainControl", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AutomaticGainControlCallbackIF*) _callback)->onAutomaticGainControlError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ADAS_LDW_UserVolume: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< ADAS_LDW_UserVolumeError > payload (new ADAS_LDW_UserVolumeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ADAS_LDW_UserVolume", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ADAS_LDW_UserVolumeCallbackIF*) _callback)->onADAS_LDW_UserVolumeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_RSoundActivation: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< RSoundActivationError > payload (new RSoundActivationError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RSoundActivation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((RSoundActivationCallbackIF*) _callback)->onRSoundActivationError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ANCASCActiveTest: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< ANCASCActiveTestError > payload (new ANCASCActiveTestError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ANCASCActiveTest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ANCASCActiveTestCallbackIF*) _callback)->onANCASCActiveTestError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ANCASCSelfDiagnosticStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< ANCASCSelfDiagnosticStatusError > payload (new ANCASCSelfDiagnosticStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ANCASCSelfDiagnosticStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ANCASCSelfDiagnosticStatusCallbackIF*) _callback)->onANCASCSelfDiagnosticStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_UserProfileChange: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< UserProfileChangeError > payload (new UserProfileChangeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UserProfileChange", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((UserProfileChangeCallbackIF*) _callback)->onUserProfileChangeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SRSoundNotificationState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SRSoundNotificationStateError > payload (new SRSoundNotificationStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SRSoundNotificationState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SRSoundNotificationStateCallbackIF*) _callback)->onSRSoundNotificationStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AudioPilotIntensity: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< AudioPilotIntensityError > payload (new AudioPilotIntensityError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudioPilotIntensity", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AudioPilotIntensityCallbackIF*) _callback)->onAudioPilotIntensityError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_MainAudioAttenuation: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< MainAudioAttenuationError > payload (new MainAudioAttenuationError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MainAudioAttenuation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((MainAudioAttenuationCallbackIF*) _callback)->onMainAudioAttenuationError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Mascf_main_fiProxyCallback::_logger (Mascf_main_fiProxy::_logger);

/*static*/ ::boost::shared_ptr< Mascf_main_fiProxy > Mascf_main_fiProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Mascf_main_fiProxy >  proxyNew(new Mascf_main_fiProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Mascf_main_fiProxy > Mascf_main_fiProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Mascf_main_fiProxy >  proxyNew(new Mascf_main_fiProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Mascf_main_fiProxy > Mascf_main_fiProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Mascf_main_fiProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Mascf_main_fiProxy >  proxyNew(new Mascf_main_fiProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Mascf_main_fiProxy::Mascf_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Mascf_main_fiProxy::~Mascf_main_fiProxy()
{
    LOG_INFO ("Entering ~Mascf_main_fiProxy");
    sendRelUpRegAll ();
}

act_t Mascf_main_fiProxy::sendVolumeModeStart(VolumeModeCallbackIF& cb, ::masc_main_fi_types::T_e8_VolumeMode volumeMode, ::masc_main_fi_types::T_e8_ResourceNo resource) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_VolumeMode);
        ::boost::shared_ptr< VolumeModeStart > payload (new VolumeModeStart());
        payload->setVolumeMode(volumeMode);
        payload->setResource(resource);
        CCA_MESSAGE(ccaMessage,header,VolumeModeStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "VolumeMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_VolumeMode);
        ::boost::shared_ptr< VolumeModeError > payload (new VolumeModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VolumeModeError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "VolumeMode", &cb);
    }
}

act_t Mascf_main_fiProxy::sendBeepStart(BeepCallbackIF& cb, ::masc_main_fi_types::T_e8_AudioBeepType beepType, ::masc_main_fi_types::T_e8_ResourceNo resource) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_Beep);
        ::boost::shared_ptr< BeepStart > payload (new BeepStart());
        payload->setBeepType(beepType);
        payload->setResource(resource);
        CCA_MESSAGE(ccaMessage,header,BeepStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "Beep", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Beep);
        ::boost::shared_ptr< BeepError > payload (new BeepError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,BeepError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "Beep", &cb);
    }
}

act_t Mascf_main_fiProxy::sendBeepFileStart(BeepFileCallbackIF& cb, const ::std::string& sFilePath, const ::masc_main_fi_types::T_BeepConfig& oConfig) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_BeepFile);
        ::boost::shared_ptr< BeepFileStart > payload (new BeepFileStart());
        payload->setSFilePath(sFilePath);
        payload->setOConfig(oConfig);
        CCA_MESSAGE(ccaMessage,header,BeepFileStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "BeepFile", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_BeepFile);
        ::boost::shared_ptr< BeepFileError > payload (new BeepFileError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,BeepFileError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "BeepFile", &cb);
    }
}

act_t Mascf_main_fiProxy::sendMuteStart(MuteCallbackIF& cb, ::mascf_aud_src_route_fi_types::T_e8_MuteRequester requester, ::masc_main_fi_types::T_e8_ResourceNo resource, ::mascf_aud_src_route_fi_types::T_e8MuteAction state, const ::mascf_aud_src_route_fi_types::T_b32MuteReason& reason, ::masc_main_fi_types::T_e8_AudioChannel channel) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_Mute);
        ::boost::shared_ptr< MuteStart > payload (new MuteStart());
        payload->setRequester(requester);
        payload->setResource(resource);
        payload->setState(state);
        payload->setReason(reason);
        payload->setChannel(channel);
        CCA_MESSAGE(ccaMessage,header,MuteStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "Mute", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Mute);
        ::boost::shared_ptr< MuteError > payload (new MuteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,MuteError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "Mute", &cb);
    }
}

act_t Mascf_main_fiProxy::sendSet_Mute_RampStart(Set_Mute_RampCallbackIF& cb, ::masc_main_fi_types::T_e8_ResourceNo resource, ::mascf_aud_src_route_fi_types::T_e8MuteSpeed state, ::masc_main_fi_types::T_e8_AudioChannel channel) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_Set_Mute_Ramp);
        ::boost::shared_ptr< Set_Mute_RampStart > payload (new Set_Mute_RampStart());
        payload->setResource(resource);
        payload->setState(state);
        payload->setChannel(channel);
        CCA_MESSAGE(ccaMessage,header,Set_Mute_RampStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "Set_Mute_Ramp", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Set_Mute_Ramp);
        ::boost::shared_ptr< Set_Mute_RampError > payload (new Set_Mute_RampError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Set_Mute_RampError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "Set_Mute_Ramp", &cb);
    }
}

act_t Mascf_main_fiProxy::sendAudioSourceStart(AudioSourceCallbackIF& cb, ::masc_main_fi_types::T_e8_ResourceNo resource, ::mascf_aud_src_route_fi_types::T_e8_AudSource source, ::masc_main_fi_types::T_e8_AudioChannel channel) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_AudioSource);
        ::boost::shared_ptr< AudioSourceStart > payload (new AudioSourceStart());
        payload->setResource(resource);
        payload->setSource(source);
        payload->setChannel(channel);
        CCA_MESSAGE(ccaMessage,header,AudioSourceStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "AudioSource", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AudioSource);
        ::boost::shared_ptr< AudioSourceError > payload (new AudioSourceError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AudioSourceError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "AudioSource", &cb);
    }
}

act_t Mascf_main_fiProxy::sendAmpDeviceAudioRouteStart(AmpDeviceAudioRouteCallbackIF& cb, ::masc_main_fi_types::T_e8_ResourceNo resource, ::masc_main_fi_types::T_e8_AudioChannel channel, ::masc_main_fi_types::T_e8_RouteNo source, const ::std::string& audProcAdev, uint32 msgHandle, ::masc_main_fi_types::T_e8_OnGoingAction action) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_AmpDeviceAudioRoute);
        ::boost::shared_ptr< AmpDeviceAudioRouteStart > payload (new AmpDeviceAudioRouteStart());
        payload->setResource(resource);
        payload->setChannel(channel);
        payload->setSource(source);
        payload->setAudProcAdev(audProcAdev);
        payload->setMsgHandle(msgHandle);
        payload->setAction(action);
        CCA_MESSAGE(ccaMessage,header,AmpDeviceAudioRouteStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "AmpDeviceAudioRoute", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AmpDeviceAudioRoute);
        ::boost::shared_ptr< AmpDeviceAudioRouteError > payload (new AmpDeviceAudioRouteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AmpDeviceAudioRouteError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "AmpDeviceAudioRoute", &cb);
    }
}

act_t Mascf_main_fiProxy::sendAudioTestToneStart(AudioTestToneCallbackIF& cb, const ::masc_main_fi_types::T_b8_ChannelSelect& channelSelect, uint32 frequency, const ::masc_main_fi_types::T_Volume& volume) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_AudioTestTone);
        ::boost::shared_ptr< AudioTestToneStart > payload (new AudioTestToneStart());
        payload->setChannelSelect(channelSelect);
        payload->setFrequency(frequency);
        payload->setVolume(volume);
        CCA_MESSAGE(ccaMessage,header,AudioTestToneStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "AudioTestTone", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AudioTestTone);
        ::boost::shared_ptr< AudioTestToneError > payload (new AudioTestToneError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AudioTestToneError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "AudioTestTone", &cb);
    }
}

act_t Mascf_main_fiProxy::sendCueStateStart(CueStateCallbackIF& cb, ::masc_main_fi_types::T_e8_State state, ::mascf_aud_src_route_fi_types::T_e8_AudSource source) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_CueState);
        ::boost::shared_ptr< CueStateStart > payload (new CueStateStart());
        payload->setState(state);
        payload->setSource(source);
        CCA_MESSAGE(ccaMessage,header,CueStateStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "CueState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CueState);
        ::boost::shared_ptr< CueStateError > payload (new CueStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CueStateError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "CueState", &cb);
    }
}

act_t Mascf_main_fiProxy::sendPerformOnVolumeLimitStart() {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_PerformOnVolumeLimit);
        ::boost::shared_ptr< PerformOnVolumeLimitStart > payload (new PerformOnVolumeLimitStart());
        CCA_MESSAGE(ccaMessage,header,PerformOnVolumeLimitStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "PerformOnVolumeLimit");
    } else {
        return _ccaProxyDelegate->oneWayMethodStartError ("PerformOnVolumeLimit");
    }
}

act_t Mascf_main_fiProxy::sendSpeakerDiagnosisStartStart(SpeakerDiagnosisStartCallbackIF& cb, ::masc_main_fi_types::T_e8_DiagMode dC_Mode, ::masc_main_fi_types::T_e8_DiagMode aC_Mode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SpeakerDiagnosisStart);
        ::boost::shared_ptr< SpeakerDiagnosisStartStart > payload (new SpeakerDiagnosisStartStart());
        payload->setDC_Mode(dC_Mode);
        payload->setAC_Mode(aC_Mode);
        CCA_MESSAGE(ccaMessage,header,SpeakerDiagnosisStartStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SpeakerDiagnosisStart", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SpeakerDiagnosisStart);
        ::boost::shared_ptr< SpeakerDiagnosisStartError > payload (new SpeakerDiagnosisStartError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SpeakerDiagnosisStartError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SpeakerDiagnosisStart", &cb);
    }
}

act_t Mascf_main_fiProxy::sendSystemMuteStart(SystemMuteCallbackIF& cb, ::mascf_aud_src_route_fi_types::T_e8_MuteRequester requester, ::masc_main_fi_types::T_e8_ResourceNo resource, ::mascf_aud_src_route_fi_types::T_e8MuteAction state, const ::mascf_aud_src_route_fi_types::T_b32MuteReason& reason) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SystemMute);
        ::boost::shared_ptr< SystemMuteStart > payload (new SystemMuteStart());
        payload->setRequester(requester);
        payload->setResource(resource);
        payload->setState(state);
        payload->setReason(reason);
        CCA_MESSAGE(ccaMessage,header,SystemMuteStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SystemMute", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SystemMute);
        ::boost::shared_ptr< SystemMuteError > payload (new SystemMuteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SystemMuteError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SystemMute", &cb);
    }
}

act_t Mascf_main_fiProxy::sendADAS_SettingSoundStart(ADAS_SettingSoundCallbackIF& cb, ::masc_main_fi_types::T_e8_ADAS_Setting_Sound settingSound) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ADAS_SettingSound);
        ::boost::shared_ptr< ADAS_SettingSoundStart > payload (new ADAS_SettingSoundStart());
        payload->setSettingSound(settingSound);
        CCA_MESSAGE(ccaMessage,header,ADAS_SettingSoundStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ADAS_SettingSound", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ADAS_SettingSound);
        ::boost::shared_ptr< ADAS_SettingSoundError > payload (new ADAS_SettingSoundError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ADAS_SettingSoundError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ADAS_SettingSound", &cb);
    }
}

act_t Mascf_main_fiProxy::sendEntertainmentMuteStart(EntertainmentMuteCallbackIF& cb, ::mascf_aud_src_route_fi_types::T_e8_MuteRequester requester, ::masc_main_fi_types::T_e8_ResourceNo resource, ::mascf_aud_src_route_fi_types::T_e8MuteAction state, const ::mascf_aud_src_route_fi_types::T_b32MuteReason& reason) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_EntertainmentMute);
        ::boost::shared_ptr< EntertainmentMuteStart > payload (new EntertainmentMuteStart());
        payload->setRequester(requester);
        payload->setResource(resource);
        payload->setState(state);
        payload->setReason(reason);
        CCA_MESSAGE(ccaMessage,header,EntertainmentMuteStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "EntertainmentMute", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_EntertainmentMute);
        ::boost::shared_ptr< EntertainmentMuteError > payload (new EntertainmentMuteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,EntertainmentMuteError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "EntertainmentMute", &cb);
    }
}

act_t Mascf_main_fiProxy::sendMCANBoseAmp_VersionInfoStart(MCANBoseAmp_VersionInfoCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_MCANBoseAmp_VersionInfo);
        ::boost::shared_ptr< MCANBoseAmp_VersionInfoStart > payload (new MCANBoseAmp_VersionInfoStart());
        CCA_MESSAGE(ccaMessage,header,MCANBoseAmp_VersionInfoStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "MCANBoseAmp_VersionInfo", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_MCANBoseAmp_VersionInfo);
        ::boost::shared_ptr< MCANBoseAmp_VersionInfoError > payload (new MCANBoseAmp_VersionInfoError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,MCANBoseAmp_VersionInfoError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "MCANBoseAmp_VersionInfo", &cb);
    }
}

act_t Mascf_main_fiProxy::sendVolumeModeStatusUpReg(VolumeModeStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_VolumeModeStatus);
        ::boost::shared_ptr< VolumeModeStatusUpReg > payload (new VolumeModeStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,VolumeModeStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< VolumeModeStatusRelUpReg > payloadRelUpRegHeap (new VolumeModeStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_VolumeModeStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::VolumeModeStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_VolumeModeStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "VolumeModeStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "VolumeModeStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasVolumeModeStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_VolumeModeStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< VolumeModeStatusStatus > payloadLoopback (new VolumeModeStatusStatus(getVolumeModeStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,VolumeModeStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_VolumeModeStatus);
        ::boost::shared_ptr< VolumeModeStatusError > payload (new VolumeModeStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VolumeModeStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "VolumeModeStatus", &cb);
    }
}

bool Mascf_main_fiProxy::sendVolumeModeStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_VolumeModeStatus,"VolumeModeStatus");
}

void Mascf_main_fiProxy::sendVolumeModeStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_VolumeModeStatus);
}

const VolumeModeStatusStatus& Mascf_main_fiProxy::getVolumeModeStatus() const {
    return _volumeModeStatus.get();
}

bool Mascf_main_fiProxy::hasVolumeModeStatus() const {
    return _volumeModeStatus.hasValue();
}

act_t Mascf_main_fiProxy::sendVolumeModeStatusGet(VolumeModeStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_VolumeModeStatus);
        ::boost::shared_ptr< VolumeModeStatusGet > payload (new VolumeModeStatusGet());
        CCA_MESSAGE(ccaMessage,header,VolumeModeStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "VolumeModeStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_VolumeModeStatus);
        ::boost::shared_ptr< VolumeModeStatusError > payload (new VolumeModeStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VolumeModeStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "VolumeModeStatus", &cb);
    }
}

act_t Mascf_main_fiProxy::sendVolumeUpReg(VolumeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Volume);
        ::boost::shared_ptr< VolumeUpReg > payload (new VolumeUpReg());
        CCA_MESSAGE(ccaMessage,header,VolumeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< VolumeRelUpReg > payloadRelUpRegHeap (new VolumeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Volume, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::VolumeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Volume, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Volume", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Volume", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasVolume()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Volume, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< VolumeStatus > payloadLoopback (new VolumeStatus(getVolume()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,VolumeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Volume);
        ::boost::shared_ptr< VolumeError > payload (new VolumeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VolumeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Volume", &cb);
    }
}

bool Mascf_main_fiProxy::sendVolumeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Volume,"Volume");
}

void Mascf_main_fiProxy::sendVolumeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Volume);
}

const VolumeStatus& Mascf_main_fiProxy::getVolume() const {
    return _volume.get();
}

bool Mascf_main_fiProxy::hasVolume() const {
    return _volume.hasValue();
}

act_t Mascf_main_fiProxy::sendVolumeGet(VolumeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Volume);
        ::boost::shared_ptr< VolumeGet > payload (new VolumeGet());
        CCA_MESSAGE(ccaMessage,header,VolumeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Volume", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Volume);
        ::boost::shared_ptr< VolumeError > payload (new VolumeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VolumeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Volume", &cb);
    }
}

act_t Mascf_main_fiProxy::sendVolumeSet(VolumeCallbackIF& cb, ::masc_main_fi_types::T_e8_AudioVolumeType volumeType, ::masc_main_fi_types::T_e8_ResourceNo resource, uint8 volume) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_Volume);
        ::boost::shared_ptr< VolumeSet > payload (new VolumeSet());
        payload->setVolumeType(volumeType);
        payload->setResource(resource);
        payload->setVolume(volume);
        CCA_MESSAGE(ccaMessage,header,VolumeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "Volume", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Volume);
        ::boost::shared_ptr< VolumeError > payload (new VolumeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VolumeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "Volume", &cb);
    }
}

act_t Mascf_main_fiProxy::sendBeepStatusUpReg(BeepStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_BeepStatus);
        ::boost::shared_ptr< BeepStatusUpReg > payload (new BeepStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,BeepStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< BeepStatusRelUpReg > payloadRelUpRegHeap (new BeepStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_BeepStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::BeepStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_BeepStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "BeepStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "BeepStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasBeepStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_BeepStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< BeepStatusStatus > payloadLoopback (new BeepStatusStatus(getBeepStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,BeepStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_BeepStatus);
        ::boost::shared_ptr< BeepStatusError > payload (new BeepStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,BeepStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "BeepStatus", &cb);
    }
}

bool Mascf_main_fiProxy::sendBeepStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_BeepStatus,"BeepStatus");
}

void Mascf_main_fiProxy::sendBeepStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_BeepStatus);
}

const BeepStatusStatus& Mascf_main_fiProxy::getBeepStatus() const {
    return _beepStatus.get();
}

bool Mascf_main_fiProxy::hasBeepStatus() const {
    return _beepStatus.hasValue();
}

act_t Mascf_main_fiProxy::sendGalaUpReg(GalaCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Gala);
        ::boost::shared_ptr< GalaUpReg > payload (new GalaUpReg());
        CCA_MESSAGE(ccaMessage,header,GalaUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< GalaRelUpReg > payloadRelUpRegHeap (new GalaRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Gala, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::GalaRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Gala, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Gala", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Gala", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasGala()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Gala, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< GalaStatus > payloadLoopback (new GalaStatus(getGala()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,GalaStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Gala);
        ::boost::shared_ptr< GalaError > payload (new GalaError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GalaError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Gala", &cb);
    }
}

bool Mascf_main_fiProxy::sendGalaRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Gala,"Gala");
}

void Mascf_main_fiProxy::sendGalaRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Gala);
}

const GalaStatus& Mascf_main_fiProxy::getGala() const {
    return _gala.get();
}

bool Mascf_main_fiProxy::hasGala() const {
    return _gala.hasValue();
}

act_t Mascf_main_fiProxy::sendGalaGet(GalaCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Gala);
        ::boost::shared_ptr< GalaGet > payload (new GalaGet());
        CCA_MESSAGE(ccaMessage,header,GalaGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Gala", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Gala);
        ::boost::shared_ptr< GalaError > payload (new GalaError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GalaError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Gala", &cb);
    }
}

act_t Mascf_main_fiProxy::sendGalaSet(GalaCallbackIF& cb, ::masc_main_fi_types::T_e8_GalaLevel galaLevel, ::masc_main_fi_types::T_e8_ResourceNo resource) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_Gala);
        ::boost::shared_ptr< GalaSet > payload (new GalaSet());
        payload->setGalaLevel(galaLevel);
        payload->setResource(resource);
        CCA_MESSAGE(ccaMessage,header,GalaSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "Gala", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Gala);
        ::boost::shared_ptr< GalaError > payload (new GalaError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GalaError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "Gala", &cb);
    }
}

act_t Mascf_main_fiProxy::sendBalanceUpReg(BalanceCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Balance);
        ::boost::shared_ptr< BalanceUpReg > payload (new BalanceUpReg());
        CCA_MESSAGE(ccaMessage,header,BalanceUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< BalanceRelUpReg > payloadRelUpRegHeap (new BalanceRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Balance, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::BalanceRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Balance, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Balance", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Balance", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasBalance()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Balance, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< BalanceStatus > payloadLoopback (new BalanceStatus(getBalance()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,BalanceStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Balance);
        ::boost::shared_ptr< BalanceError > payload (new BalanceError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,BalanceError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Balance", &cb);
    }
}

bool Mascf_main_fiProxy::sendBalanceRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Balance,"Balance");
}

void Mascf_main_fiProxy::sendBalanceRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Balance);
}

const BalanceStatus& Mascf_main_fiProxy::getBalance() const {
    return _balance.get();
}

bool Mascf_main_fiProxy::hasBalance() const {
    return _balance.hasValue();
}

act_t Mascf_main_fiProxy::sendBalanceGet(BalanceCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Balance);
        ::boost::shared_ptr< BalanceGet > payload (new BalanceGet());
        CCA_MESSAGE(ccaMessage,header,BalanceGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Balance", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Balance);
        ::boost::shared_ptr< BalanceError > payload (new BalanceError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,BalanceError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Balance", &cb);
    }
}

act_t Mascf_main_fiProxy::sendBalanceSet(BalanceCallbackIF& cb, ::masc_main_fi_types::T_e8_AudioSoundType soundType, ::masc_main_fi_types::T_e8_ResourceNo resource, int8 balance) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_Balance);
        ::boost::shared_ptr< BalanceSet > payload (new BalanceSet());
        payload->setSoundType(soundType);
        payload->setResource(resource);
        payload->setBalance(balance);
        CCA_MESSAGE(ccaMessage,header,BalanceSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "Balance", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Balance);
        ::boost::shared_ptr< BalanceError > payload (new BalanceError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,BalanceError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "Balance", &cb);
    }
}

act_t Mascf_main_fiProxy::sendLoudnessUpReg(LoudnessCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Loudness);
        ::boost::shared_ptr< LoudnessUpReg > payload (new LoudnessUpReg());
        CCA_MESSAGE(ccaMessage,header,LoudnessUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< LoudnessRelUpReg > payloadRelUpRegHeap (new LoudnessRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Loudness, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::LoudnessRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Loudness, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Loudness", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Loudness", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasLoudness()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Loudness, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< LoudnessStatus > payloadLoopback (new LoudnessStatus(getLoudness()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,LoudnessStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Loudness);
        ::boost::shared_ptr< LoudnessError > payload (new LoudnessError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,LoudnessError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Loudness", &cb);
    }
}

bool Mascf_main_fiProxy::sendLoudnessRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Loudness,"Loudness");
}

void Mascf_main_fiProxy::sendLoudnessRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Loudness);
}

const LoudnessStatus& Mascf_main_fiProxy::getLoudness() const {
    return _loudness.get();
}

bool Mascf_main_fiProxy::hasLoudness() const {
    return _loudness.hasValue();
}

act_t Mascf_main_fiProxy::sendLoudnessGet(LoudnessCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Loudness);
        ::boost::shared_ptr< LoudnessGet > payload (new LoudnessGet());
        CCA_MESSAGE(ccaMessage,header,LoudnessGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Loudness", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Loudness);
        ::boost::shared_ptr< LoudnessError > payload (new LoudnessError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,LoudnessError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Loudness", &cb);
    }
}

act_t Mascf_main_fiProxy::sendLoudnessSet(LoudnessCallbackIF& cb, ::masc_main_fi_types::T_e8_AudioSoundType soundType, ::masc_main_fi_types::T_e8_ResourceNo resource, uint8 loudness) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_Loudness);
        ::boost::shared_ptr< LoudnessSet > payload (new LoudnessSet());
        payload->setSoundType(soundType);
        payload->setResource(resource);
        payload->setLoudness(loudness);
        CCA_MESSAGE(ccaMessage,header,LoudnessSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "Loudness", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Loudness);
        ::boost::shared_ptr< LoudnessError > payload (new LoudnessError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,LoudnessError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "Loudness", &cb);
    }
}

act_t Mascf_main_fiProxy::sendBassUpReg(BassCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Bass);
        ::boost::shared_ptr< BassUpReg > payload (new BassUpReg());
        CCA_MESSAGE(ccaMessage,header,BassUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< BassRelUpReg > payloadRelUpRegHeap (new BassRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Bass, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::BassRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Bass, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Bass", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Bass", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasBass()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Bass, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< BassStatus > payloadLoopback (new BassStatus(getBass()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,BassStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Bass);
        ::boost::shared_ptr< BassError > payload (new BassError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,BassError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Bass", &cb);
    }
}

bool Mascf_main_fiProxy::sendBassRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Bass,"Bass");
}

void Mascf_main_fiProxy::sendBassRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Bass);
}

const BassStatus& Mascf_main_fiProxy::getBass() const {
    return _bass.get();
}

bool Mascf_main_fiProxy::hasBass() const {
    return _bass.hasValue();
}

act_t Mascf_main_fiProxy::sendBassGet(BassCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Bass);
        ::boost::shared_ptr< BassGet > payload (new BassGet());
        CCA_MESSAGE(ccaMessage,header,BassGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Bass", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Bass);
        ::boost::shared_ptr< BassError > payload (new BassError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,BassError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Bass", &cb);
    }
}

act_t Mascf_main_fiProxy::sendBassSet(BassCallbackIF& cb, ::masc_main_fi_types::T_e8_AudioSoundType soundType, ::masc_main_fi_types::T_e8_ResourceNo resource, int8 bass) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_Bass);
        ::boost::shared_ptr< BassSet > payload (new BassSet());
        payload->setSoundType(soundType);
        payload->setResource(resource);
        payload->setBass(bass);
        CCA_MESSAGE(ccaMessage,header,BassSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "Bass", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Bass);
        ::boost::shared_ptr< BassError > payload (new BassError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,BassError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "Bass", &cb);
    }
}

act_t Mascf_main_fiProxy::sendTrebleUpReg(TrebleCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Treble);
        ::boost::shared_ptr< TrebleUpReg > payload (new TrebleUpReg());
        CCA_MESSAGE(ccaMessage,header,TrebleUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< TrebleRelUpReg > payloadRelUpRegHeap (new TrebleRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Treble, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::TrebleRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Treble, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Treble", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Treble", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasTreble()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Treble, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< TrebleStatus > payloadLoopback (new TrebleStatus(getTreble()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,TrebleStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Treble);
        ::boost::shared_ptr< TrebleError > payload (new TrebleError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TrebleError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Treble", &cb);
    }
}

bool Mascf_main_fiProxy::sendTrebleRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Treble,"Treble");
}

void Mascf_main_fiProxy::sendTrebleRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Treble);
}

const TrebleStatus& Mascf_main_fiProxy::getTreble() const {
    return _treble.get();
}

bool Mascf_main_fiProxy::hasTreble() const {
    return _treble.hasValue();
}

act_t Mascf_main_fiProxy::sendTrebleGet(TrebleCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Treble);
        ::boost::shared_ptr< TrebleGet > payload (new TrebleGet());
        CCA_MESSAGE(ccaMessage,header,TrebleGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Treble", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Treble);
        ::boost::shared_ptr< TrebleError > payload (new TrebleError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TrebleError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Treble", &cb);
    }
}

act_t Mascf_main_fiProxy::sendTrebleSet(TrebleCallbackIF& cb, ::masc_main_fi_types::T_e8_AudioSoundType soundType, ::masc_main_fi_types::T_e8_ResourceNo resource, int8 treble) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_Treble);
        ::boost::shared_ptr< TrebleSet > payload (new TrebleSet());
        payload->setSoundType(soundType);
        payload->setResource(resource);
        payload->setTreble(treble);
        CCA_MESSAGE(ccaMessage,header,TrebleSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "Treble", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Treble);
        ::boost::shared_ptr< TrebleError > payload (new TrebleError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TrebleError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "Treble", &cb);
    }
}

act_t Mascf_main_fiProxy::sendFaderUpReg(FaderCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Fader);
        ::boost::shared_ptr< FaderUpReg > payload (new FaderUpReg());
        CCA_MESSAGE(ccaMessage,header,FaderUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< FaderRelUpReg > payloadRelUpRegHeap (new FaderRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Fader, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::FaderRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Fader, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Fader", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Fader", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasFader()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Fader, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< FaderStatus > payloadLoopback (new FaderStatus(getFader()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,FaderStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Fader);
        ::boost::shared_ptr< FaderError > payload (new FaderError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FaderError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Fader", &cb);
    }
}

bool Mascf_main_fiProxy::sendFaderRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Fader,"Fader");
}

void Mascf_main_fiProxy::sendFaderRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Fader);
}

const FaderStatus& Mascf_main_fiProxy::getFader() const {
    return _fader.get();
}

bool Mascf_main_fiProxy::hasFader() const {
    return _fader.hasValue();
}

act_t Mascf_main_fiProxy::sendFaderGet(FaderCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Fader);
        ::boost::shared_ptr< FaderGet > payload (new FaderGet());
        CCA_MESSAGE(ccaMessage,header,FaderGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Fader", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Fader);
        ::boost::shared_ptr< FaderError > payload (new FaderError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FaderError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Fader", &cb);
    }
}

act_t Mascf_main_fiProxy::sendFaderSet(FaderCallbackIF& cb, ::masc_main_fi_types::T_e8_AudioSoundType soundType, ::masc_main_fi_types::T_e8_ResourceNo resource, int8 fader) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_Fader);
        ::boost::shared_ptr< FaderSet > payload (new FaderSet());
        payload->setSoundType(soundType);
        payload->setResource(resource);
        payload->setFader(fader);
        CCA_MESSAGE(ccaMessage,header,FaderSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "Fader", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Fader);
        ::boost::shared_ptr< FaderError > payload (new FaderError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FaderError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "Fader", &cb);
    }
}

act_t Mascf_main_fiProxy::sendMidRangeUpReg(MidRangeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_MidRange);
        ::boost::shared_ptr< MidRangeUpReg > payload (new MidRangeUpReg());
        CCA_MESSAGE(ccaMessage,header,MidRangeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< MidRangeRelUpReg > payloadRelUpRegHeap (new MidRangeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_MidRange, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::MidRangeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_MidRange, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "MidRange", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "MidRange", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasMidRange()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_MidRange, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< MidRangeStatus > payloadLoopback (new MidRangeStatus(getMidRange()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,MidRangeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_MidRange);
        ::boost::shared_ptr< MidRangeError > payload (new MidRangeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,MidRangeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "MidRange", &cb);
    }
}

bool Mascf_main_fiProxy::sendMidRangeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_MidRange,"MidRange");
}

void Mascf_main_fiProxy::sendMidRangeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_MidRange);
}

const MidRangeStatus& Mascf_main_fiProxy::getMidRange() const {
    return _midRange.get();
}

bool Mascf_main_fiProxy::hasMidRange() const {
    return _midRange.hasValue();
}

act_t Mascf_main_fiProxy::sendMidRangeGet(MidRangeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_MidRange);
        ::boost::shared_ptr< MidRangeGet > payload (new MidRangeGet());
        CCA_MESSAGE(ccaMessage,header,MidRangeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "MidRange", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_MidRange);
        ::boost::shared_ptr< MidRangeError > payload (new MidRangeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,MidRangeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "MidRange", &cb);
    }
}

act_t Mascf_main_fiProxy::sendMidRangeSet(MidRangeCallbackIF& cb, ::masc_main_fi_types::T_e8_AudioSoundType soundType, ::masc_main_fi_types::T_e8_ResourceNo resource, int8 midRange) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_MidRange);
        ::boost::shared_ptr< MidRangeSet > payload (new MidRangeSet());
        payload->setSoundType(soundType);
        payload->setResource(resource);
        payload->setMidRange(midRange);
        CCA_MESSAGE(ccaMessage,header,MidRangeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "MidRange", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_MidRange);
        ::boost::shared_ptr< MidRangeError > payload (new MidRangeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,MidRangeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "MidRange", &cb);
    }
}

act_t Mascf_main_fiProxy::sendMemSoundUpReg(MemSoundCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_MemSound);
        ::boost::shared_ptr< MemSoundUpReg > payload (new MemSoundUpReg());
        CCA_MESSAGE(ccaMessage,header,MemSoundUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< MemSoundRelUpReg > payloadRelUpRegHeap (new MemSoundRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_MemSound, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::MemSoundRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_MemSound, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "MemSound", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "MemSound", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasMemSound()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_MemSound, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< MemSoundStatus > payloadLoopback (new MemSoundStatus(getMemSound()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,MemSoundStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_MemSound);
        ::boost::shared_ptr< MemSoundError > payload (new MemSoundError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,MemSoundError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "MemSound", &cb);
    }
}

bool Mascf_main_fiProxy::sendMemSoundRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_MemSound,"MemSound");
}

void Mascf_main_fiProxy::sendMemSoundRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_MemSound);
}

const MemSoundStatus& Mascf_main_fiProxy::getMemSound() const {
    return _memSound.get();
}

bool Mascf_main_fiProxy::hasMemSound() const {
    return _memSound.hasValue();
}

act_t Mascf_main_fiProxy::sendMemSoundSet(MemSoundCallbackIF& cb, ::masc_main_fi_types::T_e8_Sound sound, ::masc_main_fi_types::T_e8_ResourceNo resource) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_MemSound);
        ::boost::shared_ptr< MemSoundSet > payload (new MemSoundSet());
        payload->setSound(sound);
        payload->setResource(resource);
        CCA_MESSAGE(ccaMessage,header,MemSoundSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "MemSound", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_MemSound);
        ::boost::shared_ptr< MemSoundError > payload (new MemSoundError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,MemSoundError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "MemSound", &cb);
    }
}

act_t Mascf_main_fiProxy::sendFaderActivationStatusUpReg(FaderActivationStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_FaderActivationStatus);
        ::boost::shared_ptr< FaderActivationStatusUpReg > payload (new FaderActivationStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,FaderActivationStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< FaderActivationStatusRelUpReg > payloadRelUpRegHeap (new FaderActivationStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_FaderActivationStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::FaderActivationStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_FaderActivationStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "FaderActivationStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "FaderActivationStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasFaderActivationStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_FaderActivationStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< FaderActivationStatusStatus > payloadLoopback (new FaderActivationStatusStatus(getFaderActivationStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,FaderActivationStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FaderActivationStatus);
        ::boost::shared_ptr< FaderActivationStatusError > payload (new FaderActivationStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FaderActivationStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "FaderActivationStatus", &cb);
    }
}

bool Mascf_main_fiProxy::sendFaderActivationStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_FaderActivationStatus,"FaderActivationStatus");
}

void Mascf_main_fiProxy::sendFaderActivationStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_FaderActivationStatus);
}

const FaderActivationStatusStatus& Mascf_main_fiProxy::getFaderActivationStatus() const {
    return _faderActivationStatus.get();
}

bool Mascf_main_fiProxy::hasFaderActivationStatus() const {
    return _faderActivationStatus.hasValue();
}

act_t Mascf_main_fiProxy::sendFaderActivationStatusGet(FaderActivationStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_FaderActivationStatus);
        ::boost::shared_ptr< FaderActivationStatusGet > payload (new FaderActivationStatusGet());
        CCA_MESSAGE(ccaMessage,header,FaderActivationStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "FaderActivationStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FaderActivationStatus);
        ::boost::shared_ptr< FaderActivationStatusError > payload (new FaderActivationStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FaderActivationStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "FaderActivationStatus", &cb);
    }
}

act_t Mascf_main_fiProxy::sendDynamicCompressionUpReg(DynamicCompressionCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DynamicCompression);
        ::boost::shared_ptr< DynamicCompressionUpReg > payload (new DynamicCompressionUpReg());
        CCA_MESSAGE(ccaMessage,header,DynamicCompressionUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DynamicCompressionRelUpReg > payloadRelUpRegHeap (new DynamicCompressionRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DynamicCompression, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::DynamicCompressionRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DynamicCompression, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DynamicCompression", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DynamicCompression", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDynamicCompression()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DynamicCompression, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DynamicCompressionStatus > payloadLoopback (new DynamicCompressionStatus(getDynamicCompression()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DynamicCompressionStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DynamicCompression);
        ::boost::shared_ptr< DynamicCompressionError > payload (new DynamicCompressionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DynamicCompressionError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DynamicCompression", &cb);
    }
}

bool Mascf_main_fiProxy::sendDynamicCompressionRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DynamicCompression,"DynamicCompression");
}

void Mascf_main_fiProxy::sendDynamicCompressionRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DynamicCompression);
}

const DynamicCompressionStatus& Mascf_main_fiProxy::getDynamicCompression() const {
    return _dynamicCompression.get();
}

bool Mascf_main_fiProxy::hasDynamicCompression() const {
    return _dynamicCompression.hasValue();
}

act_t Mascf_main_fiProxy::sendDynamicCompressionGet(DynamicCompressionCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DynamicCompression);
        ::boost::shared_ptr< DynamicCompressionGet > payload (new DynamicCompressionGet());
        CCA_MESSAGE(ccaMessage,header,DynamicCompressionGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DynamicCompression", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DynamicCompression);
        ::boost::shared_ptr< DynamicCompressionError > payload (new DynamicCompressionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DynamicCompressionError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DynamicCompression", &cb);
    }
}

act_t Mascf_main_fiProxy::sendDynamicCompressionSet(DynamicCompressionCallbackIF& cb, ::masc_main_fi_types::T_e8_DynCompression dynComp, ::masc_main_fi_types::T_e8_ResourceNo resource) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_DynamicCompression);
        ::boost::shared_ptr< DynamicCompressionSet > payload (new DynamicCompressionSet());
        payload->setDynComp(dynComp);
        payload->setResource(resource);
        CCA_MESSAGE(ccaMessage,header,DynamicCompressionSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "DynamicCompression", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DynamicCompression);
        ::boost::shared_ptr< DynamicCompressionError > payload (new DynamicCompressionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DynamicCompressionError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "DynamicCompression", &cb);
    }
}

act_t Mascf_main_fiProxy::sendOptimizationUpReg(OptimizationCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Optimization);
        ::boost::shared_ptr< OptimizationUpReg > payload (new OptimizationUpReg());
        CCA_MESSAGE(ccaMessage,header,OptimizationUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< OptimizationRelUpReg > payloadRelUpRegHeap (new OptimizationRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Optimization, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::OptimizationRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Optimization, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Optimization", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Optimization", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasOptimization()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Optimization, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< OptimizationStatus > payloadLoopback (new OptimizationStatus(getOptimization()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,OptimizationStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Optimization);
        ::boost::shared_ptr< OptimizationError > payload (new OptimizationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,OptimizationError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Optimization", &cb);
    }
}

bool Mascf_main_fiProxy::sendOptimizationRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Optimization,"Optimization");
}

void Mascf_main_fiProxy::sendOptimizationRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Optimization);
}

const OptimizationStatus& Mascf_main_fiProxy::getOptimization() const {
    return _optimization.get();
}

bool Mascf_main_fiProxy::hasOptimization() const {
    return _optimization.hasValue();
}

act_t Mascf_main_fiProxy::sendOptimizationGet(OptimizationCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Optimization);
        ::boost::shared_ptr< OptimizationGet > payload (new OptimizationGet());
        CCA_MESSAGE(ccaMessage,header,OptimizationGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Optimization", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Optimization);
        ::boost::shared_ptr< OptimizationError > payload (new OptimizationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,OptimizationError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Optimization", &cb);
    }
}

act_t Mascf_main_fiProxy::sendOptimizationSet(OptimizationCallbackIF& cb, ::masc_main_fi_types::T_e8_Optimization optimization, ::masc_main_fi_types::T_e8_ResourceNo resource) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_Optimization);
        ::boost::shared_ptr< OptimizationSet > payload (new OptimizationSet());
        payload->setOptimization(optimization);
        payload->setResource(resource);
        CCA_MESSAGE(ccaMessage,header,OptimizationSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "Optimization", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Optimization);
        ::boost::shared_ptr< OptimizationError > payload (new OptimizationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,OptimizationError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "Optimization", &cb);
    }
}

act_t Mascf_main_fiProxy::sendEqualiserPresetUpReg(EqualiserPresetCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_EqualiserPreset);
        ::boost::shared_ptr< EqualiserPresetUpReg > payload (new EqualiserPresetUpReg());
        CCA_MESSAGE(ccaMessage,header,EqualiserPresetUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< EqualiserPresetRelUpReg > payloadRelUpRegHeap (new EqualiserPresetRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_EqualiserPreset, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::EqualiserPresetRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_EqualiserPreset, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "EqualiserPreset", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "EqualiserPreset", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasEqualiserPreset()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_EqualiserPreset, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< EqualiserPresetStatus > payloadLoopback (new EqualiserPresetStatus(getEqualiserPreset()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,EqualiserPresetStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_EqualiserPreset);
        ::boost::shared_ptr< EqualiserPresetError > payload (new EqualiserPresetError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,EqualiserPresetError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "EqualiserPreset", &cb);
    }
}

bool Mascf_main_fiProxy::sendEqualiserPresetRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_EqualiserPreset,"EqualiserPreset");
}

void Mascf_main_fiProxy::sendEqualiserPresetRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_EqualiserPreset);
}

const EqualiserPresetStatus& Mascf_main_fiProxy::getEqualiserPreset() const {
    return _equaliserPreset.get();
}

bool Mascf_main_fiProxy::hasEqualiserPreset() const {
    return _equaliserPreset.hasValue();
}

act_t Mascf_main_fiProxy::sendEqualiserPresetGet(EqualiserPresetCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_EqualiserPreset);
        ::boost::shared_ptr< EqualiserPresetGet > payload (new EqualiserPresetGet());
        CCA_MESSAGE(ccaMessage,header,EqualiserPresetGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "EqualiserPreset", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_EqualiserPreset);
        ::boost::shared_ptr< EqualiserPresetError > payload (new EqualiserPresetError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,EqualiserPresetError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "EqualiserPreset", &cb);
    }
}

act_t Mascf_main_fiProxy::sendEqualiserPresetSet(EqualiserPresetCallbackIF& cb, ::masc_main_fi_types::T_e8_EquPresets equPreset, ::masc_main_fi_types::T_e8_ResourceNo resource) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_EqualiserPreset);
        ::boost::shared_ptr< EqualiserPresetSet > payload (new EqualiserPresetSet());
        payload->setEquPreset(equPreset);
        payload->setResource(resource);
        CCA_MESSAGE(ccaMessage,header,EqualiserPresetSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "EqualiserPreset", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_EqualiserPreset);
        ::boost::shared_ptr< EqualiserPresetError > payload (new EqualiserPresetError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,EqualiserPresetError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "EqualiserPreset", &cb);
    }
}

act_t Mascf_main_fiProxy::sendDiagAudModeUpReg(DiagAudModeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DiagAudMode);
        ::boost::shared_ptr< DiagAudModeUpReg > payload (new DiagAudModeUpReg());
        CCA_MESSAGE(ccaMessage,header,DiagAudModeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DiagAudModeRelUpReg > payloadRelUpRegHeap (new DiagAudModeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DiagAudMode, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::DiagAudModeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DiagAudMode, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DiagAudMode", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DiagAudMode", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDiagAudMode()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DiagAudMode, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DiagAudModeStatus > payloadLoopback (new DiagAudModeStatus(getDiagAudMode()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DiagAudModeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DiagAudMode);
        ::boost::shared_ptr< DiagAudModeError > payload (new DiagAudModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DiagAudModeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DiagAudMode", &cb);
    }
}

bool Mascf_main_fiProxy::sendDiagAudModeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DiagAudMode,"DiagAudMode");
}

void Mascf_main_fiProxy::sendDiagAudModeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DiagAudMode);
}

const DiagAudModeStatus& Mascf_main_fiProxy::getDiagAudMode() const {
    return _diagAudMode.get();
}

bool Mascf_main_fiProxy::hasDiagAudMode() const {
    return _diagAudMode.hasValue();
}

act_t Mascf_main_fiProxy::sendDiagAudModeGet(DiagAudModeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DiagAudMode);
        ::boost::shared_ptr< DiagAudModeGet > payload (new DiagAudModeGet());
        CCA_MESSAGE(ccaMessage,header,DiagAudModeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DiagAudMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DiagAudMode);
        ::boost::shared_ptr< DiagAudModeError > payload (new DiagAudModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DiagAudModeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DiagAudMode", &cb);
    }
}

act_t Mascf_main_fiProxy::sendDiagAudModeSet(DiagAudModeCallbackIF& cb, ::masc_main_fi_types::T_e8_DiagAudMode diagAudMode, ::masc_main_fi_types::T_e8_GenericDiagAudMode onVolLimiterMode, ::masc_main_fi_types::T_e8_GenericDiagAudMode muteRampMode, ::masc_main_fi_types::T_e8_GenericDiagAudMode volumeRampMode, ::masc_main_fi_types::T_e8_GenericDiagAudMode clippingMode, ::masc_main_fi_types::T_e8_GenericDiagAudMode presetMode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_DiagAudMode);
        ::boost::shared_ptr< DiagAudModeSet > payload (new DiagAudModeSet());
        payload->setDiagAudMode(diagAudMode);
        payload->setOnVolLimiterMode(onVolLimiterMode);
        payload->setMuteRampMode(muteRampMode);
        payload->setVolumeRampMode(volumeRampMode);
        payload->setClippingMode(clippingMode);
        payload->setPresetMode(presetMode);
        CCA_MESSAGE(ccaMessage,header,DiagAudModeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "DiagAudMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DiagAudMode);
        ::boost::shared_ptr< DiagAudModeError > payload (new DiagAudModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DiagAudModeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "DiagAudMode", &cb);
    }
}

act_t Mascf_main_fiProxy::sendAuxInLevelUpReg(AuxInLevelCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AuxInLevel);
        ::boost::shared_ptr< AuxInLevelUpReg > payload (new AuxInLevelUpReg());
        CCA_MESSAGE(ccaMessage,header,AuxInLevelUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AuxInLevelRelUpReg > payloadRelUpRegHeap (new AuxInLevelRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AuxInLevel, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::AuxInLevelRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AuxInLevel, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AuxInLevel", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AuxInLevel", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAuxInLevel()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AuxInLevel, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AuxInLevelStatus > payloadLoopback (new AuxInLevelStatus(getAuxInLevel()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AuxInLevelStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AuxInLevel);
        ::boost::shared_ptr< AuxInLevelError > payload (new AuxInLevelError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AuxInLevelError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AuxInLevel", &cb);
    }
}

bool Mascf_main_fiProxy::sendAuxInLevelRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AuxInLevel,"AuxInLevel");
}

void Mascf_main_fiProxy::sendAuxInLevelRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AuxInLevel);
}

const AuxInLevelStatus& Mascf_main_fiProxy::getAuxInLevel() const {
    return _auxInLevel.get();
}

bool Mascf_main_fiProxy::hasAuxInLevel() const {
    return _auxInLevel.hasValue();
}

act_t Mascf_main_fiProxy::sendAuxInLevelGet(AuxInLevelCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_AuxInLevel);
        ::boost::shared_ptr< AuxInLevelGet > payload (new AuxInLevelGet());
        CCA_MESSAGE(ccaMessage,header,AuxInLevelGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "AuxInLevel", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AuxInLevel);
        ::boost::shared_ptr< AuxInLevelError > payload (new AuxInLevelError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AuxInLevelError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "AuxInLevel", &cb);
    }
}

act_t Mascf_main_fiProxy::sendAuxInLevelSet(AuxInLevelCallbackIF& cb, ::masc_main_fi_types::T_e8_AuxInLevel auxInLevel) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_AuxInLevel);
        ::boost::shared_ptr< AuxInLevelSet > payload (new AuxInLevelSet());
        payload->setAuxInLevel(auxInLevel);
        CCA_MESSAGE(ccaMessage,header,AuxInLevelSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "AuxInLevel", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AuxInLevel);
        ::boost::shared_ptr< AuxInLevelError > payload (new AuxInLevelError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AuxInLevelError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "AuxInLevel", &cb);
    }
}

act_t Mascf_main_fiProxy::sendBeepLevelUpReg(BeepLevelCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_BeepLevel);
        ::boost::shared_ptr< BeepLevelUpReg > payload (new BeepLevelUpReg());
        CCA_MESSAGE(ccaMessage,header,BeepLevelUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< BeepLevelRelUpReg > payloadRelUpRegHeap (new BeepLevelRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_BeepLevel, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::BeepLevelRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_BeepLevel, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "BeepLevel", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "BeepLevel", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasBeepLevel()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_BeepLevel, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< BeepLevelStatus > payloadLoopback (new BeepLevelStatus(getBeepLevel()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,BeepLevelStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_BeepLevel);
        ::boost::shared_ptr< BeepLevelError > payload (new BeepLevelError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,BeepLevelError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "BeepLevel", &cb);
    }
}

bool Mascf_main_fiProxy::sendBeepLevelRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_BeepLevel,"BeepLevel");
}

void Mascf_main_fiProxy::sendBeepLevelRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_BeepLevel);
}

const BeepLevelStatus& Mascf_main_fiProxy::getBeepLevel() const {
    return _beepLevel.get();
}

bool Mascf_main_fiProxy::hasBeepLevel() const {
    return _beepLevel.hasValue();
}

act_t Mascf_main_fiProxy::sendBeepLevelGet(BeepLevelCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_BeepLevel);
        ::boost::shared_ptr< BeepLevelGet > payload (new BeepLevelGet());
        CCA_MESSAGE(ccaMessage,header,BeepLevelGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "BeepLevel", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_BeepLevel);
        ::boost::shared_ptr< BeepLevelError > payload (new BeepLevelError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,BeepLevelError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "BeepLevel", &cb);
    }
}

act_t Mascf_main_fiProxy::sendBeepLevelSet(BeepLevelCallbackIF& cb, ::masc_main_fi_types::T_e8_BeepLevel beepLevel) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_BeepLevel);
        ::boost::shared_ptr< BeepLevelSet > payload (new BeepLevelSet());
        payload->setBeepLevel(beepLevel);
        CCA_MESSAGE(ccaMessage,header,BeepLevelSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "BeepLevel", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_BeepLevel);
        ::boost::shared_ptr< BeepLevelError > payload (new BeepLevelError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,BeepLevelError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "BeepLevel", &cb);
    }
}

act_t Mascf_main_fiProxy::sendRear_MuteUpReg(Rear_MuteCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Rear_Mute);
        ::boost::shared_ptr< Rear_MuteUpReg > payload (new Rear_MuteUpReg());
        CCA_MESSAGE(ccaMessage,header,Rear_MuteUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< Rear_MuteRelUpReg > payloadRelUpRegHeap (new Rear_MuteRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Rear_Mute, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::Rear_MuteRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Rear_Mute, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Rear_Mute", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Rear_Mute", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasRear_Mute()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Rear_Mute, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< Rear_MuteStatus > payloadLoopback (new Rear_MuteStatus(getRear_Mute()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,Rear_MuteStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Rear_Mute);
        ::boost::shared_ptr< Rear_MuteError > payload (new Rear_MuteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Rear_MuteError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Rear_Mute", &cb);
    }
}

bool Mascf_main_fiProxy::sendRear_MuteRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Rear_Mute,"Rear_Mute");
}

void Mascf_main_fiProxy::sendRear_MuteRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Rear_Mute);
}

const Rear_MuteStatus& Mascf_main_fiProxy::getRear_Mute() const {
    return _rear_Mute.get();
}

bool Mascf_main_fiProxy::hasRear_Mute() const {
    return _rear_Mute.hasValue();
}

act_t Mascf_main_fiProxy::sendRear_MuteGet(Rear_MuteCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Rear_Mute);
        ::boost::shared_ptr< Rear_MuteGet > payload (new Rear_MuteGet());
        CCA_MESSAGE(ccaMessage,header,Rear_MuteGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Rear_Mute", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Rear_Mute);
        ::boost::shared_ptr< Rear_MuteError > payload (new Rear_MuteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Rear_MuteError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Rear_Mute", &cb);
    }
}

act_t Mascf_main_fiProxy::sendRear_MuteSet(Rear_MuteCallbackIF& cb, ::masc_main_fi_types::T_e8_Rear_Mute rear_Mute) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_Rear_Mute);
        ::boost::shared_ptr< Rear_MuteSet > payload (new Rear_MuteSet());
        payload->setRear_Mute(rear_Mute);
        CCA_MESSAGE(ccaMessage,header,Rear_MuteSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "Rear_Mute", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Rear_Mute);
        ::boost::shared_ptr< Rear_MuteError > payload (new Rear_MuteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Rear_MuteError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "Rear_Mute", &cb);
    }
}

act_t Mascf_main_fiProxy::sendGeometry_ModeUpReg(Geometry_ModeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Geometry_Mode);
        ::boost::shared_ptr< Geometry_ModeUpReg > payload (new Geometry_ModeUpReg());
        CCA_MESSAGE(ccaMessage,header,Geometry_ModeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< Geometry_ModeRelUpReg > payloadRelUpRegHeap (new Geometry_ModeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Geometry_Mode, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::Geometry_ModeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Geometry_Mode, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Geometry_Mode", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Geometry_Mode", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasGeometry_Mode()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Geometry_Mode, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< Geometry_ModeStatus > payloadLoopback (new Geometry_ModeStatus(getGeometry_Mode()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,Geometry_ModeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Geometry_Mode);
        ::boost::shared_ptr< Geometry_ModeError > payload (new Geometry_ModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Geometry_ModeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Geometry_Mode", &cb);
    }
}

bool Mascf_main_fiProxy::sendGeometry_ModeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Geometry_Mode,"Geometry_Mode");
}

void Mascf_main_fiProxy::sendGeometry_ModeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Geometry_Mode);
}

const Geometry_ModeStatus& Mascf_main_fiProxy::getGeometry_Mode() const {
    return _geometry_Mode.get();
}

bool Mascf_main_fiProxy::hasGeometry_Mode() const {
    return _geometry_Mode.hasValue();
}

act_t Mascf_main_fiProxy::sendGeometry_ModeGet(Geometry_ModeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Geometry_Mode);
        ::boost::shared_ptr< Geometry_ModeGet > payload (new Geometry_ModeGet());
        CCA_MESSAGE(ccaMessage,header,Geometry_ModeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Geometry_Mode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Geometry_Mode);
        ::boost::shared_ptr< Geometry_ModeError > payload (new Geometry_ModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Geometry_ModeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Geometry_Mode", &cb);
    }
}

act_t Mascf_main_fiProxy::sendGeometry_ModeSet(Geometry_ModeCallbackIF& cb, ::masc_main_fi_types::T_e8_Geometry_Mode geometry_Mode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_Geometry_Mode);
        ::boost::shared_ptr< Geometry_ModeSet > payload (new Geometry_ModeSet());
        payload->setGeometry_Mode(geometry_Mode);
        CCA_MESSAGE(ccaMessage,header,Geometry_ModeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "Geometry_Mode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Geometry_Mode);
        ::boost::shared_ptr< Geometry_ModeError > payload (new Geometry_ModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Geometry_ModeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "Geometry_Mode", &cb);
    }
}

act_t Mascf_main_fiProxy::sendLSValueStatusUpReg(LSValueStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_LSValueStatus);
        ::boost::shared_ptr< LSValueStatusUpReg > payload (new LSValueStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,LSValueStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< LSValueStatusRelUpReg > payloadRelUpRegHeap (new LSValueStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_LSValueStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::LSValueStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_LSValueStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "LSValueStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "LSValueStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasLSValueStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_LSValueStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< LSValueStatusStatus > payloadLoopback (new LSValueStatusStatus(getLSValueStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,LSValueStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_LSValueStatus);
        ::boost::shared_ptr< LSValueStatusError > payload (new LSValueStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,LSValueStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "LSValueStatus", &cb);
    }
}

bool Mascf_main_fiProxy::sendLSValueStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_LSValueStatus,"LSValueStatus");
}

void Mascf_main_fiProxy::sendLSValueStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_LSValueStatus);
}

const LSValueStatusStatus& Mascf_main_fiProxy::getLSValueStatus() const {
    return _lSValueStatus.get();
}

bool Mascf_main_fiProxy::hasLSValueStatus() const {
    return _lSValueStatus.hasValue();
}

act_t Mascf_main_fiProxy::sendLSValueStatusGet(LSValueStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_LSValueStatus);
        ::boost::shared_ptr< LSValueStatusGet > payload (new LSValueStatusGet());
        CCA_MESSAGE(ccaMessage,header,LSValueStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "LSValueStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_LSValueStatus);
        ::boost::shared_ptr< LSValueStatusError > payload (new LSValueStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,LSValueStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "LSValueStatus", &cb);
    }
}

act_t Mascf_main_fiProxy::sendPDCAttenuationLevelUpReg(PDCAttenuationLevelCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_PDCAttenuationLevel);
        ::boost::shared_ptr< PDCAttenuationLevelUpReg > payload (new PDCAttenuationLevelUpReg());
        CCA_MESSAGE(ccaMessage,header,PDCAttenuationLevelUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< PDCAttenuationLevelRelUpReg > payloadRelUpRegHeap (new PDCAttenuationLevelRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_PDCAttenuationLevel, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::PDCAttenuationLevelRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_PDCAttenuationLevel, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "PDCAttenuationLevel", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "PDCAttenuationLevel", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasPDCAttenuationLevel()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_PDCAttenuationLevel, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< PDCAttenuationLevelStatus > payloadLoopback (new PDCAttenuationLevelStatus(getPDCAttenuationLevel()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,PDCAttenuationLevelStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PDCAttenuationLevel);
        ::boost::shared_ptr< PDCAttenuationLevelError > payload (new PDCAttenuationLevelError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PDCAttenuationLevelError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "PDCAttenuationLevel", &cb);
    }
}

bool Mascf_main_fiProxy::sendPDCAttenuationLevelRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_PDCAttenuationLevel,"PDCAttenuationLevel");
}

void Mascf_main_fiProxy::sendPDCAttenuationLevelRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_PDCAttenuationLevel);
}

const PDCAttenuationLevelStatus& Mascf_main_fiProxy::getPDCAttenuationLevel() const {
    return _pDCAttenuationLevel.get();
}

bool Mascf_main_fiProxy::hasPDCAttenuationLevel() const {
    return _pDCAttenuationLevel.hasValue();
}

act_t Mascf_main_fiProxy::sendPDCAttenuationLevelGet(PDCAttenuationLevelCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_PDCAttenuationLevel);
        ::boost::shared_ptr< PDCAttenuationLevelGet > payload (new PDCAttenuationLevelGet());
        CCA_MESSAGE(ccaMessage,header,PDCAttenuationLevelGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "PDCAttenuationLevel", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PDCAttenuationLevel);
        ::boost::shared_ptr< PDCAttenuationLevelError > payload (new PDCAttenuationLevelError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PDCAttenuationLevelError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "PDCAttenuationLevel", &cb);
    }
}

act_t Mascf_main_fiProxy::sendPDCAttenuationLevelSet(PDCAttenuationLevelCallbackIF& cb, uint8 pDCAttenutionLevel) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_PDCAttenuationLevel);
        ::boost::shared_ptr< PDCAttenuationLevelSet > payload (new PDCAttenuationLevelSet());
        payload->setPDCAttenutionLevel(pDCAttenutionLevel);
        CCA_MESSAGE(ccaMessage,header,PDCAttenuationLevelSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "PDCAttenuationLevel", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PDCAttenuationLevel);
        ::boost::shared_ptr< PDCAttenuationLevelError > payload (new PDCAttenuationLevelError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PDCAttenuationLevelError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "PDCAttenuationLevel", &cb);
    }
}

act_t Mascf_main_fiProxy::sendPDCAttenuationUpReg(PDCAttenuationCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_PDCAttenuation);
        ::boost::shared_ptr< PDCAttenuationUpReg > payload (new PDCAttenuationUpReg());
        CCA_MESSAGE(ccaMessage,header,PDCAttenuationUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< PDCAttenuationRelUpReg > payloadRelUpRegHeap (new PDCAttenuationRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_PDCAttenuation, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::PDCAttenuationRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_PDCAttenuation, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "PDCAttenuation", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "PDCAttenuation", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasPDCAttenuation()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_PDCAttenuation, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< PDCAttenuationStatus > payloadLoopback (new PDCAttenuationStatus(getPDCAttenuation()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,PDCAttenuationStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PDCAttenuation);
        ::boost::shared_ptr< PDCAttenuationError > payload (new PDCAttenuationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PDCAttenuationError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "PDCAttenuation", &cb);
    }
}

bool Mascf_main_fiProxy::sendPDCAttenuationRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_PDCAttenuation,"PDCAttenuation");
}

void Mascf_main_fiProxy::sendPDCAttenuationRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_PDCAttenuation);
}

const PDCAttenuationStatus& Mascf_main_fiProxy::getPDCAttenuation() const {
    return _pDCAttenuation.get();
}

bool Mascf_main_fiProxy::hasPDCAttenuation() const {
    return _pDCAttenuation.hasValue();
}

act_t Mascf_main_fiProxy::sendPDCAttenuationGet(PDCAttenuationCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_PDCAttenuation);
        ::boost::shared_ptr< PDCAttenuationGet > payload (new PDCAttenuationGet());
        CCA_MESSAGE(ccaMessage,header,PDCAttenuationGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "PDCAttenuation", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PDCAttenuation);
        ::boost::shared_ptr< PDCAttenuationError > payload (new PDCAttenuationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PDCAttenuationError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "PDCAttenuation", &cb);
    }
}

act_t Mascf_main_fiProxy::sendPDCAttenuationSet(PDCAttenuationCallbackIF& cb, ::masc_main_fi_types::T_e8_PDCAttenuation pDCAttenuationCommand) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_PDCAttenuation);
        ::boost::shared_ptr< PDCAttenuationSet > payload (new PDCAttenuationSet());
        payload->setPDCAttenuationCommand(pDCAttenuationCommand);
        CCA_MESSAGE(ccaMessage,header,PDCAttenuationSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "PDCAttenuation", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PDCAttenuation);
        ::boost::shared_ptr< PDCAttenuationError > payload (new PDCAttenuationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PDCAttenuationError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "PDCAttenuation", &cb);
    }
}

act_t Mascf_main_fiProxy::sendAudioDeviceStatusUpReg(AudioDeviceStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AudioDeviceStatus);
        ::boost::shared_ptr< AudioDeviceStatusUpReg > payload (new AudioDeviceStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,AudioDeviceStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AudioDeviceStatusRelUpReg > payloadRelUpRegHeap (new AudioDeviceStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AudioDeviceStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::AudioDeviceStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AudioDeviceStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AudioDeviceStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AudioDeviceStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAudioDeviceStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AudioDeviceStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AudioDeviceStatusStatus > payloadLoopback (new AudioDeviceStatusStatus(getAudioDeviceStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AudioDeviceStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AudioDeviceStatus);
        ::boost::shared_ptr< AudioDeviceStatusError > payload (new AudioDeviceStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AudioDeviceStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AudioDeviceStatus", &cb);
    }
}

bool Mascf_main_fiProxy::sendAudioDeviceStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AudioDeviceStatus,"AudioDeviceStatus");
}

void Mascf_main_fiProxy::sendAudioDeviceStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AudioDeviceStatus);
}

const AudioDeviceStatusStatus& Mascf_main_fiProxy::getAudioDeviceStatus() const {
    return _audioDeviceStatus.get();
}

bool Mascf_main_fiProxy::hasAudioDeviceStatus() const {
    return _audioDeviceStatus.hasValue();
}

act_t Mascf_main_fiProxy::sendAudioDeviceStatusGet(AudioDeviceStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_AudioDeviceStatus);
        ::boost::shared_ptr< AudioDeviceStatusGet > payload (new AudioDeviceStatusGet());
        CCA_MESSAGE(ccaMessage,header,AudioDeviceStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "AudioDeviceStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AudioDeviceStatus);
        ::boost::shared_ptr< AudioDeviceStatusError > payload (new AudioDeviceStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AudioDeviceStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "AudioDeviceStatus", &cb);
    }
}

act_t Mascf_main_fiProxy::sendOverTempReductionUpReg(OverTempReductionCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_OverTempReduction);
        ::boost::shared_ptr< OverTempReductionUpReg > payload (new OverTempReductionUpReg());
        CCA_MESSAGE(ccaMessage,header,OverTempReductionUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< OverTempReductionRelUpReg > payloadRelUpRegHeap (new OverTempReductionRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_OverTempReduction, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::OverTempReductionRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_OverTempReduction, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "OverTempReduction", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "OverTempReduction", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasOverTempReduction()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_OverTempReduction, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< OverTempReductionStatus > payloadLoopback (new OverTempReductionStatus(getOverTempReduction()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,OverTempReductionStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_OverTempReduction);
        ::boost::shared_ptr< OverTempReductionError > payload (new OverTempReductionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,OverTempReductionError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "OverTempReduction", &cb);
    }
}

bool Mascf_main_fiProxy::sendOverTempReductionRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_OverTempReduction,"OverTempReduction");
}

void Mascf_main_fiProxy::sendOverTempReductionRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_OverTempReduction);
}

const OverTempReductionStatus& Mascf_main_fiProxy::getOverTempReduction() const {
    return _overTempReduction.get();
}

bool Mascf_main_fiProxy::hasOverTempReduction() const {
    return _overTempReduction.hasValue();
}

act_t Mascf_main_fiProxy::sendOverTempReductionGet(OverTempReductionCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_OverTempReduction);
        ::boost::shared_ptr< OverTempReductionGet > payload (new OverTempReductionGet());
        CCA_MESSAGE(ccaMessage,header,OverTempReductionGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "OverTempReduction", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_OverTempReduction);
        ::boost::shared_ptr< OverTempReductionError > payload (new OverTempReductionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,OverTempReductionError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "OverTempReduction", &cb);
    }
}

act_t Mascf_main_fiProxy::sendOverTempReductionSet(OverTempReductionCallbackIF& cb, bool downScaling_Active, uint8 reductionInterval) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_OverTempReduction);
        ::boost::shared_ptr< OverTempReductionSet > payload (new OverTempReductionSet());
        payload->setDownScaling_Active(downScaling_Active);
        payload->setReductionInterval(reductionInterval);
        CCA_MESSAGE(ccaMessage,header,OverTempReductionSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "OverTempReduction", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_OverTempReduction);
        ::boost::shared_ptr< OverTempReductionError > payload (new OverTempReductionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,OverTempReductionError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "OverTempReduction", &cb);
    }
}

act_t Mascf_main_fiProxy::sendOverTempAmplifierStatusUpReg(OverTempAmplifierStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_OverTempAmplifierStatus);
        ::boost::shared_ptr< OverTempAmplifierStatusUpReg > payload (new OverTempAmplifierStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,OverTempAmplifierStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< OverTempAmplifierStatusRelUpReg > payloadRelUpRegHeap (new OverTempAmplifierStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_OverTempAmplifierStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::OverTempAmplifierStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_OverTempAmplifierStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "OverTempAmplifierStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "OverTempAmplifierStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasOverTempAmplifierStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_OverTempAmplifierStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< OverTempAmplifierStatusStatus > payloadLoopback (new OverTempAmplifierStatusStatus(getOverTempAmplifierStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,OverTempAmplifierStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_OverTempAmplifierStatus);
        ::boost::shared_ptr< OverTempAmplifierStatusError > payload (new OverTempAmplifierStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,OverTempAmplifierStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "OverTempAmplifierStatus", &cb);
    }
}

bool Mascf_main_fiProxy::sendOverTempAmplifierStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_OverTempAmplifierStatus,"OverTempAmplifierStatus");
}

void Mascf_main_fiProxy::sendOverTempAmplifierStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_OverTempAmplifierStatus);
}

const OverTempAmplifierStatusStatus& Mascf_main_fiProxy::getOverTempAmplifierStatus() const {
    return _overTempAmplifierStatus.get();
}

bool Mascf_main_fiProxy::hasOverTempAmplifierStatus() const {
    return _overTempAmplifierStatus.hasValue();
}

act_t Mascf_main_fiProxy::sendOverTempAmplifierStatusGet(OverTempAmplifierStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_OverTempAmplifierStatus);
        ::boost::shared_ptr< OverTempAmplifierStatusGet > payload (new OverTempAmplifierStatusGet());
        CCA_MESSAGE(ccaMessage,header,OverTempAmplifierStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "OverTempAmplifierStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_OverTempAmplifierStatus);
        ::boost::shared_ptr< OverTempAmplifierStatusError > payload (new OverTempAmplifierStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,OverTempAmplifierStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "OverTempAmplifierStatus", &cb);
    }
}

act_t Mascf_main_fiProxy::sendReadMeasurementResultUpReg(ReadMeasurementResultCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ReadMeasurementResult);
        ::boost::shared_ptr< ReadMeasurementResultUpReg > payload (new ReadMeasurementResultUpReg());
        CCA_MESSAGE(ccaMessage,header,ReadMeasurementResultUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ReadMeasurementResultRelUpReg > payloadRelUpRegHeap (new ReadMeasurementResultRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ReadMeasurementResult, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::ReadMeasurementResultRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ReadMeasurementResult, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ReadMeasurementResult", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ReadMeasurementResult", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasReadMeasurementResult()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ReadMeasurementResult, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ReadMeasurementResultStatus > payloadLoopback (new ReadMeasurementResultStatus(getReadMeasurementResult()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ReadMeasurementResultStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ReadMeasurementResult);
        ::boost::shared_ptr< ReadMeasurementResultError > payload (new ReadMeasurementResultError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ReadMeasurementResultError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ReadMeasurementResult", &cb);
    }
}

bool Mascf_main_fiProxy::sendReadMeasurementResultRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ReadMeasurementResult,"ReadMeasurementResult");
}

void Mascf_main_fiProxy::sendReadMeasurementResultRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ReadMeasurementResult);
}

const ReadMeasurementResultStatus& Mascf_main_fiProxy::getReadMeasurementResult() const {
    return _readMeasurementResult.get();
}

bool Mascf_main_fiProxy::hasReadMeasurementResult() const {
    return _readMeasurementResult.hasValue();
}

act_t Mascf_main_fiProxy::sendReadMeasurementResultGet(ReadMeasurementResultCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ReadMeasurementResult);
        ::boost::shared_ptr< ReadMeasurementResultGet > payload (new ReadMeasurementResultGet());
        CCA_MESSAGE(ccaMessage,header,ReadMeasurementResultGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ReadMeasurementResult", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ReadMeasurementResult);
        ::boost::shared_ptr< ReadMeasurementResultError > payload (new ReadMeasurementResultError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ReadMeasurementResultError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ReadMeasurementResult", &cb);
    }
}

act_t Mascf_main_fiProxy::sendCenterUpReg(CenterCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Center);
        ::boost::shared_ptr< CenterUpReg > payload (new CenterUpReg());
        CCA_MESSAGE(ccaMessage,header,CenterUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< CenterRelUpReg > payloadRelUpRegHeap (new CenterRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Center, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::CenterRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Center, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Center", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Center", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasCenter()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Center, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< CenterStatus > payloadLoopback (new CenterStatus(getCenter()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,CenterStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Center);
        ::boost::shared_ptr< CenterError > payload (new CenterError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CenterError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Center", &cb);
    }
}

bool Mascf_main_fiProxy::sendCenterRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Center,"Center");
}

void Mascf_main_fiProxy::sendCenterRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Center);
}

const CenterStatus& Mascf_main_fiProxy::getCenter() const {
    return _center.get();
}

bool Mascf_main_fiProxy::hasCenter() const {
    return _center.hasValue();
}

act_t Mascf_main_fiProxy::sendCenterGet(CenterCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Center);
        ::boost::shared_ptr< CenterGet > payload (new CenterGet());
        CCA_MESSAGE(ccaMessage,header,CenterGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Center", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Center);
        ::boost::shared_ptr< CenterError > payload (new CenterError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CenterError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Center", &cb);
    }
}

act_t Mascf_main_fiProxy::sendCenterSet(CenterCallbackIF& cb, ::masc_main_fi_types::T_e8_AudioSoundType soundType, ::masc_main_fi_types::T_e8_ResourceNo resource, int16 center) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_Center);
        ::boost::shared_ptr< CenterSet > payload (new CenterSet());
        payload->setSoundType(soundType);
        payload->setResource(resource);
        payload->setCenter(center);
        CCA_MESSAGE(ccaMessage,header,CenterSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "Center", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Center);
        ::boost::shared_ptr< CenterError > payload (new CenterError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CenterError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "Center", &cb);
    }
}

act_t Mascf_main_fiProxy::sendSubWooferUpReg(SubWooferCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SubWoofer);
        ::boost::shared_ptr< SubWooferUpReg > payload (new SubWooferUpReg());
        CCA_MESSAGE(ccaMessage,header,SubWooferUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SubWooferRelUpReg > payloadRelUpRegHeap (new SubWooferRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SubWoofer, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::SubWooferRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SubWoofer, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SubWoofer", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SubWoofer", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSubWoofer()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SubWoofer, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SubWooferStatus > payloadLoopback (new SubWooferStatus(getSubWoofer()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SubWooferStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SubWoofer);
        ::boost::shared_ptr< SubWooferError > payload (new SubWooferError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SubWooferError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SubWoofer", &cb);
    }
}

bool Mascf_main_fiProxy::sendSubWooferRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SubWoofer,"SubWoofer");
}

void Mascf_main_fiProxy::sendSubWooferRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SubWoofer);
}

const SubWooferStatus& Mascf_main_fiProxy::getSubWoofer() const {
    return _subWoofer.get();
}

bool Mascf_main_fiProxy::hasSubWoofer() const {
    return _subWoofer.hasValue();
}

act_t Mascf_main_fiProxy::sendSubWooferGet(SubWooferCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SubWoofer);
        ::boost::shared_ptr< SubWooferGet > payload (new SubWooferGet());
        CCA_MESSAGE(ccaMessage,header,SubWooferGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SubWoofer", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SubWoofer);
        ::boost::shared_ptr< SubWooferError > payload (new SubWooferError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SubWooferError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SubWoofer", &cb);
    }
}

act_t Mascf_main_fiProxy::sendSubWooferSet(SubWooferCallbackIF& cb, ::masc_main_fi_types::T_e8_AudioSoundType soundType, ::masc_main_fi_types::T_e8_ResourceNo resource, int16 subWoofer) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SubWoofer);
        ::boost::shared_ptr< SubWooferSet > payload (new SubWooferSet());
        payload->setSoundType(soundType);
        payload->setResource(resource);
        payload->setSubWoofer(subWoofer);
        CCA_MESSAGE(ccaMessage,header,SubWooferSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SubWoofer", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SubWoofer);
        ::boost::shared_ptr< SubWooferError > payload (new SubWooferError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SubWooferError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SubWoofer", &cb);
    }
}

act_t Mascf_main_fiProxy::sendExternalAmplifierConnectionStateUpReg(ExternalAmplifierConnectionStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ExternalAmplifierConnectionState);
        ::boost::shared_ptr< ExternalAmplifierConnectionStateUpReg > payload (new ExternalAmplifierConnectionStateUpReg());
        CCA_MESSAGE(ccaMessage,header,ExternalAmplifierConnectionStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ExternalAmplifierConnectionStateRelUpReg > payloadRelUpRegHeap (new ExternalAmplifierConnectionStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ExternalAmplifierConnectionState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::ExternalAmplifierConnectionStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ExternalAmplifierConnectionState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ExternalAmplifierConnectionState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ExternalAmplifierConnectionState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasExternalAmplifierConnectionState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ExternalAmplifierConnectionState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ExternalAmplifierConnectionStateStatus > payloadLoopback (new ExternalAmplifierConnectionStateStatus(getExternalAmplifierConnectionState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ExternalAmplifierConnectionStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ExternalAmplifierConnectionState);
        ::boost::shared_ptr< ExternalAmplifierConnectionStateError > payload (new ExternalAmplifierConnectionStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ExternalAmplifierConnectionStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ExternalAmplifierConnectionState", &cb);
    }
}

bool Mascf_main_fiProxy::sendExternalAmplifierConnectionStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ExternalAmplifierConnectionState,"ExternalAmplifierConnectionState");
}

void Mascf_main_fiProxy::sendExternalAmplifierConnectionStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ExternalAmplifierConnectionState);
}

const ExternalAmplifierConnectionStateStatus& Mascf_main_fiProxy::getExternalAmplifierConnectionState() const {
    return _externalAmplifierConnectionState.get();
}

bool Mascf_main_fiProxy::hasExternalAmplifierConnectionState() const {
    return _externalAmplifierConnectionState.hasValue();
}

act_t Mascf_main_fiProxy::sendExternalAmplifierConnectionStateGet(ExternalAmplifierConnectionStateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ExternalAmplifierConnectionState);
        ::boost::shared_ptr< ExternalAmplifierConnectionStateGet > payload (new ExternalAmplifierConnectionStateGet());
        CCA_MESSAGE(ccaMessage,header,ExternalAmplifierConnectionStateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ExternalAmplifierConnectionState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ExternalAmplifierConnectionState);
        ::boost::shared_ptr< ExternalAmplifierConnectionStateError > payload (new ExternalAmplifierConnectionStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ExternalAmplifierConnectionStateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ExternalAmplifierConnectionState", &cb);
    }
}

act_t Mascf_main_fiProxy::sendGeneralSpeakerTestUpReg(GeneralSpeakerTestCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_GeneralSpeakerTest);
        ::boost::shared_ptr< GeneralSpeakerTestUpReg > payload (new GeneralSpeakerTestUpReg());
        CCA_MESSAGE(ccaMessage,header,GeneralSpeakerTestUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< GeneralSpeakerTestRelUpReg > payloadRelUpRegHeap (new GeneralSpeakerTestRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_GeneralSpeakerTest, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::GeneralSpeakerTestRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_GeneralSpeakerTest, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "GeneralSpeakerTest", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "GeneralSpeakerTest", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasGeneralSpeakerTest()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_GeneralSpeakerTest, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< GeneralSpeakerTestStatus > payloadLoopback (new GeneralSpeakerTestStatus(getGeneralSpeakerTest()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,GeneralSpeakerTestStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GeneralSpeakerTest);
        ::boost::shared_ptr< GeneralSpeakerTestError > payload (new GeneralSpeakerTestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GeneralSpeakerTestError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "GeneralSpeakerTest", &cb);
    }
}

bool Mascf_main_fiProxy::sendGeneralSpeakerTestRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_GeneralSpeakerTest,"GeneralSpeakerTest");
}

void Mascf_main_fiProxy::sendGeneralSpeakerTestRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_GeneralSpeakerTest);
}

const GeneralSpeakerTestStatus& Mascf_main_fiProxy::getGeneralSpeakerTest() const {
    return _generalSpeakerTest.get();
}

bool Mascf_main_fiProxy::hasGeneralSpeakerTest() const {
    return _generalSpeakerTest.hasValue();
}

act_t Mascf_main_fiProxy::sendGeneralSpeakerTestGet(GeneralSpeakerTestCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_GeneralSpeakerTest);
        ::boost::shared_ptr< GeneralSpeakerTestGet > payload (new GeneralSpeakerTestGet());
        CCA_MESSAGE(ccaMessage,header,GeneralSpeakerTestGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "GeneralSpeakerTest", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GeneralSpeakerTest);
        ::boost::shared_ptr< GeneralSpeakerTestError > payload (new GeneralSpeakerTestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GeneralSpeakerTestError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "GeneralSpeakerTest", &cb);
    }
}

act_t Mascf_main_fiProxy::sendGeneralSpeakerTestSet(GeneralSpeakerTestCallbackIF& cb, uint8 request) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_GeneralSpeakerTest);
        ::boost::shared_ptr< GeneralSpeakerTestSet > payload (new GeneralSpeakerTestSet());
        payload->setRequest(request);
        CCA_MESSAGE(ccaMessage,header,GeneralSpeakerTestSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "GeneralSpeakerTest", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GeneralSpeakerTest);
        ::boost::shared_ptr< GeneralSpeakerTestError > payload (new GeneralSpeakerTestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GeneralSpeakerTestError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "GeneralSpeakerTest", &cb);
    }
}

act_t Mascf_main_fiProxy::sendANCSWVersionUpReg(ANCSWVersionCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ANCSWVersion);
        ::boost::shared_ptr< ANCSWVersionUpReg > payload (new ANCSWVersionUpReg());
        CCA_MESSAGE(ccaMessage,header,ANCSWVersionUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ANCSWVersionRelUpReg > payloadRelUpRegHeap (new ANCSWVersionRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ANCSWVersion, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::ANCSWVersionRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ANCSWVersion, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ANCSWVersion", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ANCSWVersion", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasANCSWVersion()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ANCSWVersion, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ANCSWVersionStatus > payloadLoopback (new ANCSWVersionStatus(getANCSWVersion()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ANCSWVersionStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ANCSWVersion);
        ::boost::shared_ptr< ANCSWVersionError > payload (new ANCSWVersionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ANCSWVersionError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ANCSWVersion", &cb);
    }
}

bool Mascf_main_fiProxy::sendANCSWVersionRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ANCSWVersion,"ANCSWVersion");
}

void Mascf_main_fiProxy::sendANCSWVersionRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ANCSWVersion);
}

const ANCSWVersionStatus& Mascf_main_fiProxy::getANCSWVersion() const {
    return _aNCSWVersion.get();
}

bool Mascf_main_fiProxy::hasANCSWVersion() const {
    return _aNCSWVersion.hasValue();
}

act_t Mascf_main_fiProxy::sendANCSWVersionGet(ANCSWVersionCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ANCSWVersion);
        ::boost::shared_ptr< ANCSWVersionGet > payload (new ANCSWVersionGet());
        CCA_MESSAGE(ccaMessage,header,ANCSWVersionGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ANCSWVersion", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ANCSWVersion);
        ::boost::shared_ptr< ANCSWVersionError > payload (new ANCSWVersionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ANCSWVersionError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ANCSWVersion", &cb);
    }
}

act_t Mascf_main_fiProxy::sendASCSWVersionUpReg(ASCSWVersionCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ASCSWVersion);
        ::boost::shared_ptr< ASCSWVersionUpReg > payload (new ASCSWVersionUpReg());
        CCA_MESSAGE(ccaMessage,header,ASCSWVersionUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ASCSWVersionRelUpReg > payloadRelUpRegHeap (new ASCSWVersionRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ASCSWVersion, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::ASCSWVersionRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ASCSWVersion, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ASCSWVersion", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ASCSWVersion", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasASCSWVersion()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ASCSWVersion, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ASCSWVersionStatus > payloadLoopback (new ASCSWVersionStatus(getASCSWVersion()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ASCSWVersionStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ASCSWVersion);
        ::boost::shared_ptr< ASCSWVersionError > payload (new ASCSWVersionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ASCSWVersionError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ASCSWVersion", &cb);
    }
}

bool Mascf_main_fiProxy::sendASCSWVersionRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ASCSWVersion,"ASCSWVersion");
}

void Mascf_main_fiProxy::sendASCSWVersionRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ASCSWVersion);
}

const ASCSWVersionStatus& Mascf_main_fiProxy::getASCSWVersion() const {
    return _aSCSWVersion.get();
}

bool Mascf_main_fiProxy::hasASCSWVersion() const {
    return _aSCSWVersion.hasValue();
}

act_t Mascf_main_fiProxy::sendASCSWVersionGet(ASCSWVersionCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ASCSWVersion);
        ::boost::shared_ptr< ASCSWVersionGet > payload (new ASCSWVersionGet());
        CCA_MESSAGE(ccaMessage,header,ASCSWVersionGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ASCSWVersion", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ASCSWVersion);
        ::boost::shared_ptr< ASCSWVersionError > payload (new ASCSWVersionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ASCSWVersionError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ASCSWVersion", &cb);
    }
}

act_t Mascf_main_fiProxy::sendANCASCSettingUpReg(ANCASCSettingCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ANCASCSetting);
        ::boost::shared_ptr< ANCASCSettingUpReg > payload (new ANCASCSettingUpReg());
        CCA_MESSAGE(ccaMessage,header,ANCASCSettingUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ANCASCSettingRelUpReg > payloadRelUpRegHeap (new ANCASCSettingRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ANCASCSetting, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::ANCASCSettingRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ANCASCSetting, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ANCASCSetting", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ANCASCSetting", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasANCASCSetting()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ANCASCSetting, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ANCASCSettingStatus > payloadLoopback (new ANCASCSettingStatus(getANCASCSetting()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ANCASCSettingStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ANCASCSetting);
        ::boost::shared_ptr< ANCASCSettingError > payload (new ANCASCSettingError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ANCASCSettingError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ANCASCSetting", &cb);
    }
}

bool Mascf_main_fiProxy::sendANCASCSettingRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ANCASCSetting,"ANCASCSetting");
}

void Mascf_main_fiProxy::sendANCASCSettingRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ANCASCSetting);
}

const ANCASCSettingStatus& Mascf_main_fiProxy::getANCASCSetting() const {
    return _aNCASCSetting.get();
}

bool Mascf_main_fiProxy::hasANCASCSetting() const {
    return _aNCASCSetting.hasValue();
}

act_t Mascf_main_fiProxy::sendANCASCSettingGet(ANCASCSettingCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ANCASCSetting);
        ::boost::shared_ptr< ANCASCSettingGet > payload (new ANCASCSettingGet());
        CCA_MESSAGE(ccaMessage,header,ANCASCSettingGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ANCASCSetting", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ANCASCSetting);
        ::boost::shared_ptr< ANCASCSettingError > payload (new ANCASCSettingError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ANCASCSettingError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ANCASCSetting", &cb);
    }
}

act_t Mascf_main_fiProxy::sendANCASCSettingSet(ANCASCSettingCallbackIF& cb, uint8 aNCAvailability, uint8 aSCAvailability) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_ANCASCSetting);
        ::boost::shared_ptr< ANCASCSettingSet > payload (new ANCASCSettingSet());
        payload->setANCAvailability(aNCAvailability);
        payload->setASCAvailability(aSCAvailability);
        CCA_MESSAGE(ccaMessage,header,ANCASCSettingSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "ANCASCSetting", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ANCASCSetting);
        ::boost::shared_ptr< ANCASCSettingError > payload (new ANCASCSettingError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ANCASCSettingError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "ANCASCSetting", &cb);
    }
}

act_t Mascf_main_fiProxy::sendAmpSoftwareVersionUpReg(AmpSoftwareVersionCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AmpSoftwareVersion);
        ::boost::shared_ptr< AmpSoftwareVersionUpReg > payload (new AmpSoftwareVersionUpReg());
        CCA_MESSAGE(ccaMessage,header,AmpSoftwareVersionUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AmpSoftwareVersionRelUpReg > payloadRelUpRegHeap (new AmpSoftwareVersionRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AmpSoftwareVersion, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::AmpSoftwareVersionRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AmpSoftwareVersion, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AmpSoftwareVersion", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AmpSoftwareVersion", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAmpSoftwareVersion()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AmpSoftwareVersion, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AmpSoftwareVersionStatus > payloadLoopback (new AmpSoftwareVersionStatus(getAmpSoftwareVersion()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AmpSoftwareVersionStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AmpSoftwareVersion);
        ::boost::shared_ptr< AmpSoftwareVersionError > payload (new AmpSoftwareVersionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AmpSoftwareVersionError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AmpSoftwareVersion", &cb);
    }
}

bool Mascf_main_fiProxy::sendAmpSoftwareVersionRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AmpSoftwareVersion,"AmpSoftwareVersion");
}

void Mascf_main_fiProxy::sendAmpSoftwareVersionRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AmpSoftwareVersion);
}

const AmpSoftwareVersionStatus& Mascf_main_fiProxy::getAmpSoftwareVersion() const {
    return _ampSoftwareVersion.get();
}

bool Mascf_main_fiProxy::hasAmpSoftwareVersion() const {
    return _ampSoftwareVersion.hasValue();
}

act_t Mascf_main_fiProxy::sendAmpSoftwareVersionGet(AmpSoftwareVersionCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_AmpSoftwareVersion);
        ::boost::shared_ptr< AmpSoftwareVersionGet > payload (new AmpSoftwareVersionGet());
        CCA_MESSAGE(ccaMessage,header,AmpSoftwareVersionGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "AmpSoftwareVersion", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AmpSoftwareVersion);
        ::boost::shared_ptr< AmpSoftwareVersionError > payload (new AmpSoftwareVersionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AmpSoftwareVersionError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "AmpSoftwareVersion", &cb);
    }
}

act_t Mascf_main_fiProxy::sendAmpParameterVersionUpReg(AmpParameterVersionCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AmpParameterVersion);
        ::boost::shared_ptr< AmpParameterVersionUpReg > payload (new AmpParameterVersionUpReg());
        CCA_MESSAGE(ccaMessage,header,AmpParameterVersionUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AmpParameterVersionRelUpReg > payloadRelUpRegHeap (new AmpParameterVersionRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AmpParameterVersion, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::AmpParameterVersionRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AmpParameterVersion, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AmpParameterVersion", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AmpParameterVersion", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAmpParameterVersion()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AmpParameterVersion, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AmpParameterVersionStatus > payloadLoopback (new AmpParameterVersionStatus(getAmpParameterVersion()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AmpParameterVersionStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AmpParameterVersion);
        ::boost::shared_ptr< AmpParameterVersionError > payload (new AmpParameterVersionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AmpParameterVersionError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AmpParameterVersion", &cb);
    }
}

bool Mascf_main_fiProxy::sendAmpParameterVersionRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AmpParameterVersion,"AmpParameterVersion");
}

void Mascf_main_fiProxy::sendAmpParameterVersionRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AmpParameterVersion);
}

const AmpParameterVersionStatus& Mascf_main_fiProxy::getAmpParameterVersion() const {
    return _ampParameterVersion.get();
}

bool Mascf_main_fiProxy::hasAmpParameterVersion() const {
    return _ampParameterVersion.hasValue();
}

act_t Mascf_main_fiProxy::sendAmpParameterVersionGet(AmpParameterVersionCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_AmpParameterVersion);
        ::boost::shared_ptr< AmpParameterVersionGet > payload (new AmpParameterVersionGet());
        CCA_MESSAGE(ccaMessage,header,AmpParameterVersionGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "AmpParameterVersion", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AmpParameterVersion);
        ::boost::shared_ptr< AmpParameterVersionError > payload (new AmpParameterVersionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AmpParameterVersionError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "AmpParameterVersion", &cb);
    }
}

act_t Mascf_main_fiProxy::sendAmpHardwareVersionUpReg(AmpHardwareVersionCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AmpHardwareVersion);
        ::boost::shared_ptr< AmpHardwareVersionUpReg > payload (new AmpHardwareVersionUpReg());
        CCA_MESSAGE(ccaMessage,header,AmpHardwareVersionUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AmpHardwareVersionRelUpReg > payloadRelUpRegHeap (new AmpHardwareVersionRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AmpHardwareVersion, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::AmpHardwareVersionRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AmpHardwareVersion, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AmpHardwareVersion", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AmpHardwareVersion", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAmpHardwareVersion()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AmpHardwareVersion, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AmpHardwareVersionStatus > payloadLoopback (new AmpHardwareVersionStatus(getAmpHardwareVersion()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AmpHardwareVersionStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AmpHardwareVersion);
        ::boost::shared_ptr< AmpHardwareVersionError > payload (new AmpHardwareVersionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AmpHardwareVersionError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AmpHardwareVersion", &cb);
    }
}

bool Mascf_main_fiProxy::sendAmpHardwareVersionRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AmpHardwareVersion,"AmpHardwareVersion");
}

void Mascf_main_fiProxy::sendAmpHardwareVersionRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AmpHardwareVersion);
}

const AmpHardwareVersionStatus& Mascf_main_fiProxy::getAmpHardwareVersion() const {
    return _ampHardwareVersion.get();
}

bool Mascf_main_fiProxy::hasAmpHardwareVersion() const {
    return _ampHardwareVersion.hasValue();
}

act_t Mascf_main_fiProxy::sendAmpHardwareVersionGet(AmpHardwareVersionCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_AmpHardwareVersion);
        ::boost::shared_ptr< AmpHardwareVersionGet > payload (new AmpHardwareVersionGet());
        CCA_MESSAGE(ccaMessage,header,AmpHardwareVersionGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "AmpHardwareVersion", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AmpHardwareVersion);
        ::boost::shared_ptr< AmpHardwareVersionError > payload (new AmpHardwareVersionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AmpHardwareVersionError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "AmpHardwareVersion", &cb);
    }
}

act_t Mascf_main_fiProxy::sendSurroundVolUpReg(SurroundVolCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SurroundVol);
        ::boost::shared_ptr< SurroundVolUpReg > payload (new SurroundVolUpReg());
        CCA_MESSAGE(ccaMessage,header,SurroundVolUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SurroundVolRelUpReg > payloadRelUpRegHeap (new SurroundVolRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SurroundVol, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::SurroundVolRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SurroundVol, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SurroundVol", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SurroundVol", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSurroundVol()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SurroundVol, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SurroundVolStatus > payloadLoopback (new SurroundVolStatus(getSurroundVol()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SurroundVolStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SurroundVol);
        ::boost::shared_ptr< SurroundVolError > payload (new SurroundVolError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SurroundVolError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SurroundVol", &cb);
    }
}

bool Mascf_main_fiProxy::sendSurroundVolRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SurroundVol,"SurroundVol");
}

void Mascf_main_fiProxy::sendSurroundVolRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SurroundVol);
}

const SurroundVolStatus& Mascf_main_fiProxy::getSurroundVol() const {
    return _surroundVol.get();
}

bool Mascf_main_fiProxy::hasSurroundVol() const {
    return _surroundVol.hasValue();
}

act_t Mascf_main_fiProxy::sendSurroundVolGet(SurroundVolCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SurroundVol);
        ::boost::shared_ptr< SurroundVolGet > payload (new SurroundVolGet());
        CCA_MESSAGE(ccaMessage,header,SurroundVolGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SurroundVol", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SurroundVol);
        ::boost::shared_ptr< SurroundVolError > payload (new SurroundVolError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SurroundVolError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SurroundVol", &cb);
    }
}

act_t Mascf_main_fiProxy::sendSurroundVolSet(SurroundVolCallbackIF& cb, ::masc_main_fi_types::T_e8_AudioSoundType soundType, ::masc_main_fi_types::T_e8_ResourceNo resource, int8 surroundVol) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SurroundVol);
        ::boost::shared_ptr< SurroundVolSet > payload (new SurroundVolSet());
        payload->setSoundType(soundType);
        payload->setResource(resource);
        payload->setSurroundVol(surroundVol);
        CCA_MESSAGE(ccaMessage,header,SurroundVolSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SurroundVol", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SurroundVol);
        ::boost::shared_ptr< SurroundVolError > payload (new SurroundVolError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SurroundVolError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SurroundVol", &cb);
    }
}

act_t Mascf_main_fiProxy::sendAudioPilotModeUpReg(AudioPilotModeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AudioPilotMode);
        ::boost::shared_ptr< AudioPilotModeUpReg > payload (new AudioPilotModeUpReg());
        CCA_MESSAGE(ccaMessage,header,AudioPilotModeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AudioPilotModeRelUpReg > payloadRelUpRegHeap (new AudioPilotModeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AudioPilotMode, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::AudioPilotModeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AudioPilotMode, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AudioPilotMode", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AudioPilotMode", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAudioPilotMode()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AudioPilotMode, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AudioPilotModeStatus > payloadLoopback (new AudioPilotModeStatus(getAudioPilotMode()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AudioPilotModeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AudioPilotMode);
        ::boost::shared_ptr< AudioPilotModeError > payload (new AudioPilotModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AudioPilotModeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AudioPilotMode", &cb);
    }
}

bool Mascf_main_fiProxy::sendAudioPilotModeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AudioPilotMode,"AudioPilotMode");
}

void Mascf_main_fiProxy::sendAudioPilotModeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AudioPilotMode);
}

const AudioPilotModeStatus& Mascf_main_fiProxy::getAudioPilotMode() const {
    return _audioPilotMode.get();
}

bool Mascf_main_fiProxy::hasAudioPilotMode() const {
    return _audioPilotMode.hasValue();
}

act_t Mascf_main_fiProxy::sendAudioPilotModeGet(AudioPilotModeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_AudioPilotMode);
        ::boost::shared_ptr< AudioPilotModeGet > payload (new AudioPilotModeGet());
        CCA_MESSAGE(ccaMessage,header,AudioPilotModeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "AudioPilotMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AudioPilotMode);
        ::boost::shared_ptr< AudioPilotModeError > payload (new AudioPilotModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AudioPilotModeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "AudioPilotMode", &cb);
    }
}

act_t Mascf_main_fiProxy::sendAudioPilotModeSet(AudioPilotModeCallbackIF& cb, bool audPilotMode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_AudioPilotMode);
        ::boost::shared_ptr< AudioPilotModeSet > payload (new AudioPilotModeSet());
        payload->setAudPilotMode(audPilotMode);
        CCA_MESSAGE(ccaMessage,header,AudioPilotModeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "AudioPilotMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AudioPilotMode);
        ::boost::shared_ptr< AudioPilotModeError > payload (new AudioPilotModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AudioPilotModeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "AudioPilotMode", &cb);
    }
}

act_t Mascf_main_fiProxy::sendSurroundModeUpReg(SurroundModeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SurroundMode);
        ::boost::shared_ptr< SurroundModeUpReg > payload (new SurroundModeUpReg());
        CCA_MESSAGE(ccaMessage,header,SurroundModeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SurroundModeRelUpReg > payloadRelUpRegHeap (new SurroundModeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SurroundMode, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::SurroundModeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SurroundMode, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SurroundMode", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SurroundMode", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSurroundMode()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SurroundMode, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SurroundModeStatus > payloadLoopback (new SurroundModeStatus(getSurroundMode()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SurroundModeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SurroundMode);
        ::boost::shared_ptr< SurroundModeError > payload (new SurroundModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SurroundModeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SurroundMode", &cb);
    }
}

bool Mascf_main_fiProxy::sendSurroundModeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SurroundMode,"SurroundMode");
}

void Mascf_main_fiProxy::sendSurroundModeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SurroundMode);
}

const SurroundModeStatus& Mascf_main_fiProxy::getSurroundMode() const {
    return _surroundMode.get();
}

bool Mascf_main_fiProxy::hasSurroundMode() const {
    return _surroundMode.hasValue();
}

act_t Mascf_main_fiProxy::sendSurroundModeGet(SurroundModeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SurroundMode);
        ::boost::shared_ptr< SurroundModeGet > payload (new SurroundModeGet());
        CCA_MESSAGE(ccaMessage,header,SurroundModeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SurroundMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SurroundMode);
        ::boost::shared_ptr< SurroundModeError > payload (new SurroundModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SurroundModeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SurroundMode", &cb);
    }
}

act_t Mascf_main_fiProxy::sendSurroundModeSet(SurroundModeCallbackIF& cb, bool surroundMode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SurroundMode);
        ::boost::shared_ptr< SurroundModeSet > payload (new SurroundModeSet());
        payload->setSurroundMode(surroundMode);
        CCA_MESSAGE(ccaMessage,header,SurroundModeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SurroundMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SurroundMode);
        ::boost::shared_ptr< SurroundModeError > payload (new SurroundModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SurroundModeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SurroundMode", &cb);
    }
}

act_t Mascf_main_fiProxy::sendAmpDownMixModeUpReg(AmpDownMixModeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AmpDownMixMode);
        ::boost::shared_ptr< AmpDownMixModeUpReg > payload (new AmpDownMixModeUpReg());
        CCA_MESSAGE(ccaMessage,header,AmpDownMixModeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AmpDownMixModeRelUpReg > payloadRelUpRegHeap (new AmpDownMixModeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AmpDownMixMode, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::AmpDownMixModeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AmpDownMixMode, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AmpDownMixMode", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AmpDownMixMode", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAmpDownMixMode()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AmpDownMixMode, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AmpDownMixModeStatus > payloadLoopback (new AmpDownMixModeStatus(getAmpDownMixMode()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AmpDownMixModeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AmpDownMixMode);
        ::boost::shared_ptr< AmpDownMixModeError > payload (new AmpDownMixModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AmpDownMixModeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AmpDownMixMode", &cb);
    }
}

bool Mascf_main_fiProxy::sendAmpDownMixModeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AmpDownMixMode,"AmpDownMixMode");
}

void Mascf_main_fiProxy::sendAmpDownMixModeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AmpDownMixMode);
}

const AmpDownMixModeStatus& Mascf_main_fiProxy::getAmpDownMixMode() const {
    return _ampDownMixMode.get();
}

bool Mascf_main_fiProxy::hasAmpDownMixMode() const {
    return _ampDownMixMode.hasValue();
}

act_t Mascf_main_fiProxy::sendAmpDownMixModeGet(AmpDownMixModeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_AmpDownMixMode);
        ::boost::shared_ptr< AmpDownMixModeGet > payload (new AmpDownMixModeGet());
        CCA_MESSAGE(ccaMessage,header,AmpDownMixModeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "AmpDownMixMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AmpDownMixMode);
        ::boost::shared_ptr< AmpDownMixModeError > payload (new AmpDownMixModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AmpDownMixModeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "AmpDownMixMode", &cb);
    }
}

act_t Mascf_main_fiProxy::sendAmpDownMixModeSet(AmpDownMixModeCallbackIF& cb, bool ampDownMixMode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_AmpDownMixMode);
        ::boost::shared_ptr< AmpDownMixModeSet > payload (new AmpDownMixModeSet());
        payload->setAmpDownMixMode(ampDownMixMode);
        CCA_MESSAGE(ccaMessage,header,AmpDownMixModeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "AmpDownMixMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AmpDownMixMode);
        ::boost::shared_ptr< AmpDownMixModeError > payload (new AmpDownMixModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AmpDownMixModeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "AmpDownMixMode", &cb);
    }
}

act_t Mascf_main_fiProxy::sendDriverSoundModeUpReg(DriverSoundModeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DriverSoundMode);
        ::boost::shared_ptr< DriverSoundModeUpReg > payload (new DriverSoundModeUpReg());
        CCA_MESSAGE(ccaMessage,header,DriverSoundModeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DriverSoundModeRelUpReg > payloadRelUpRegHeap (new DriverSoundModeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DriverSoundMode, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::DriverSoundModeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DriverSoundMode, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DriverSoundMode", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DriverSoundMode", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDriverSoundMode()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DriverSoundMode, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DriverSoundModeStatus > payloadLoopback (new DriverSoundModeStatus(getDriverSoundMode()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DriverSoundModeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DriverSoundMode);
        ::boost::shared_ptr< DriverSoundModeError > payload (new DriverSoundModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DriverSoundModeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DriverSoundMode", &cb);
    }
}

bool Mascf_main_fiProxy::sendDriverSoundModeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DriverSoundMode,"DriverSoundMode");
}

void Mascf_main_fiProxy::sendDriverSoundModeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DriverSoundMode);
}

const DriverSoundModeStatus& Mascf_main_fiProxy::getDriverSoundMode() const {
    return _driverSoundMode.get();
}

bool Mascf_main_fiProxy::hasDriverSoundMode() const {
    return _driverSoundMode.hasValue();
}

act_t Mascf_main_fiProxy::sendDriverSoundModeGet(DriverSoundModeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DriverSoundMode);
        ::boost::shared_ptr< DriverSoundModeGet > payload (new DriverSoundModeGet());
        CCA_MESSAGE(ccaMessage,header,DriverSoundModeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DriverSoundMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DriverSoundMode);
        ::boost::shared_ptr< DriverSoundModeError > payload (new DriverSoundModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DriverSoundModeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DriverSoundMode", &cb);
    }
}

act_t Mascf_main_fiProxy::sendDriverSoundModeSet(DriverSoundModeCallbackIF& cb, bool driverMode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_DriverSoundMode);
        ::boost::shared_ptr< DriverSoundModeSet > payload (new DriverSoundModeSet());
        payload->setDriverMode(driverMode);
        CCA_MESSAGE(ccaMessage,header,DriverSoundModeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "DriverSoundMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DriverSoundMode);
        ::boost::shared_ptr< DriverSoundModeError > payload (new DriverSoundModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DriverSoundModeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "DriverSoundMode", &cb);
    }
}

act_t Mascf_main_fiProxy::sendRearSoundModeUpReg(RearSoundModeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_RearSoundMode);
        ::boost::shared_ptr< RearSoundModeUpReg > payload (new RearSoundModeUpReg());
        CCA_MESSAGE(ccaMessage,header,RearSoundModeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< RearSoundModeRelUpReg > payloadRelUpRegHeap (new RearSoundModeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_RearSoundMode, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::RearSoundModeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_RearSoundMode, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "RearSoundMode", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "RearSoundMode", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasRearSoundMode()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_RearSoundMode, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< RearSoundModeStatus > payloadLoopback (new RearSoundModeStatus(getRearSoundMode()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,RearSoundModeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RearSoundMode);
        ::boost::shared_ptr< RearSoundModeError > payload (new RearSoundModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RearSoundModeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "RearSoundMode", &cb);
    }
}

bool Mascf_main_fiProxy::sendRearSoundModeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_RearSoundMode,"RearSoundMode");
}

void Mascf_main_fiProxy::sendRearSoundModeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_RearSoundMode);
}

const RearSoundModeStatus& Mascf_main_fiProxy::getRearSoundMode() const {
    return _rearSoundMode.get();
}

bool Mascf_main_fiProxy::hasRearSoundMode() const {
    return _rearSoundMode.hasValue();
}

act_t Mascf_main_fiProxy::sendRearSoundModeGet(RearSoundModeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_RearSoundMode);
        ::boost::shared_ptr< RearSoundModeGet > payload (new RearSoundModeGet());
        CCA_MESSAGE(ccaMessage,header,RearSoundModeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "RearSoundMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RearSoundMode);
        ::boost::shared_ptr< RearSoundModeError > payload (new RearSoundModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RearSoundModeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "RearSoundMode", &cb);
    }
}

act_t Mascf_main_fiProxy::sendRearSoundModeSet(RearSoundModeCallbackIF& cb, bool rearMode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_RearSoundMode);
        ::boost::shared_ptr< RearSoundModeSet > payload (new RearSoundModeSet());
        payload->setRearMode(rearMode);
        CCA_MESSAGE(ccaMessage,header,RearSoundModeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "RearSoundMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RearSoundMode);
        ::boost::shared_ptr< RearSoundModeError > payload (new RearSoundModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RearSoundModeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "RearSoundMode", &cb);
    }
}

act_t Mascf_main_fiProxy::sendAudioOFFMuteStateUpReg(AudioOFFMuteStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AudioOFFMuteState);
        ::boost::shared_ptr< AudioOFFMuteStateUpReg > payload (new AudioOFFMuteStateUpReg());
        CCA_MESSAGE(ccaMessage,header,AudioOFFMuteStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AudioOFFMuteStateRelUpReg > payloadRelUpRegHeap (new AudioOFFMuteStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AudioOFFMuteState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::AudioOFFMuteStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AudioOFFMuteState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AudioOFFMuteState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AudioOFFMuteState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAudioOFFMuteState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AudioOFFMuteState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AudioOFFMuteStateStatus > payloadLoopback (new AudioOFFMuteStateStatus(getAudioOFFMuteState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AudioOFFMuteStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AudioOFFMuteState);
        ::boost::shared_ptr< AudioOFFMuteStateError > payload (new AudioOFFMuteStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AudioOFFMuteStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AudioOFFMuteState", &cb);
    }
}

bool Mascf_main_fiProxy::sendAudioOFFMuteStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AudioOFFMuteState,"AudioOFFMuteState");
}

void Mascf_main_fiProxy::sendAudioOFFMuteStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AudioOFFMuteState);
}

const AudioOFFMuteStateStatus& Mascf_main_fiProxy::getAudioOFFMuteState() const {
    return _audioOFFMuteState.get();
}

bool Mascf_main_fiProxy::hasAudioOFFMuteState() const {
    return _audioOFFMuteState.hasValue();
}

act_t Mascf_main_fiProxy::sendAudioOFFMuteStateSet(AudioOFFMuteStateCallbackIF& cb, uint8 muteState) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_AudioOFFMuteState);
        ::boost::shared_ptr< AudioOFFMuteStateSet > payload (new AudioOFFMuteStateSet());
        payload->setMuteState(muteState);
        CCA_MESSAGE(ccaMessage,header,AudioOFFMuteStateSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "AudioOFFMuteState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AudioOFFMuteState);
        ::boost::shared_ptr< AudioOFFMuteStateError > payload (new AudioOFFMuteStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AudioOFFMuteStateError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "AudioOFFMuteState", &cb);
    }
}

act_t Mascf_main_fiProxy::sendMicrophoneConnectionStatusUpReg(MicrophoneConnectionStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_MicrophoneConnectionStatus);
        ::boost::shared_ptr< MicrophoneConnectionStatusUpReg > payload (new MicrophoneConnectionStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,MicrophoneConnectionStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< MicrophoneConnectionStatusRelUpReg > payloadRelUpRegHeap (new MicrophoneConnectionStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_MicrophoneConnectionStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::MicrophoneConnectionStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_MicrophoneConnectionStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "MicrophoneConnectionStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "MicrophoneConnectionStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasMicrophoneConnectionStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_MicrophoneConnectionStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< MicrophoneConnectionStatusStatus > payloadLoopback (new MicrophoneConnectionStatusStatus(getMicrophoneConnectionStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,MicrophoneConnectionStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_MicrophoneConnectionStatus);
        ::boost::shared_ptr< MicrophoneConnectionStatusError > payload (new MicrophoneConnectionStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,MicrophoneConnectionStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "MicrophoneConnectionStatus", &cb);
    }
}

bool Mascf_main_fiProxy::sendMicrophoneConnectionStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_MicrophoneConnectionStatus,"MicrophoneConnectionStatus");
}

void Mascf_main_fiProxy::sendMicrophoneConnectionStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_MicrophoneConnectionStatus);
}

const MicrophoneConnectionStatusStatus& Mascf_main_fiProxy::getMicrophoneConnectionStatus() const {
    return _microphoneConnectionStatus.get();
}

bool Mascf_main_fiProxy::hasMicrophoneConnectionStatus() const {
    return _microphoneConnectionStatus.hasValue();
}

act_t Mascf_main_fiProxy::sendMicrophoneConnectionStatusGet(MicrophoneConnectionStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_MicrophoneConnectionStatus);
        ::boost::shared_ptr< MicrophoneConnectionStatusGet > payload (new MicrophoneConnectionStatusGet());
        CCA_MESSAGE(ccaMessage,header,MicrophoneConnectionStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "MicrophoneConnectionStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_MicrophoneConnectionStatus);
        ::boost::shared_ptr< MicrophoneConnectionStatusError > payload (new MicrophoneConnectionStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,MicrophoneConnectionStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "MicrophoneConnectionStatus", &cb);
    }
}

act_t Mascf_main_fiProxy::sendConnectionUpReg(ConnectionCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Connection);
        ::boost::shared_ptr< ConnectionUpReg > payload (new ConnectionUpReg());
        CCA_MESSAGE(ccaMessage,header,ConnectionUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ConnectionRelUpReg > payloadRelUpRegHeap (new ConnectionRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Connection, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::ConnectionRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Connection, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Connection", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Connection", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasConnection()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Connection, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ConnectionStatus > payloadLoopback (new ConnectionStatus(getConnection()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ConnectionStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Connection);
        ::boost::shared_ptr< ConnectionError > payload (new ConnectionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ConnectionError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Connection", &cb);
    }
}

bool Mascf_main_fiProxy::sendConnectionRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Connection,"Connection");
}

void Mascf_main_fiProxy::sendConnectionRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Connection);
}

const ConnectionStatus& Mascf_main_fiProxy::getConnection() const {
    return _connection.get();
}

bool Mascf_main_fiProxy::hasConnection() const {
    return _connection.hasValue();
}

act_t Mascf_main_fiProxy::sendConnectionGet(ConnectionCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Connection);
        ::boost::shared_ptr< ConnectionGet > payload (new ConnectionGet());
        CCA_MESSAGE(ccaMessage,header,ConnectionGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Connection", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Connection);
        ::boost::shared_ptr< ConnectionError > payload (new ConnectionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ConnectionError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Connection", &cb);
    }
}

act_t Mascf_main_fiProxy::sendVolumeListUpReg(VolumeListCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_VolumeList);
        ::boost::shared_ptr< VolumeListUpReg > payload (new VolumeListUpReg());
        CCA_MESSAGE(ccaMessage,header,VolumeListUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< VolumeListRelUpReg > payloadRelUpRegHeap (new VolumeListRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_VolumeList, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::VolumeListRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_VolumeList, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "VolumeList", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "VolumeList", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasVolumeList()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_VolumeList, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< VolumeListStatus > payloadLoopback (new VolumeListStatus(getVolumeList()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,VolumeListStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_VolumeList);
        ::boost::shared_ptr< VolumeListError > payload (new VolumeListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VolumeListError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "VolumeList", &cb);
    }
}

bool Mascf_main_fiProxy::sendVolumeListRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_VolumeList,"VolumeList");
}

void Mascf_main_fiProxy::sendVolumeListRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_VolumeList);
}

const VolumeListStatus& Mascf_main_fiProxy::getVolumeList() const {
    return _volumeList.get();
}

bool Mascf_main_fiProxy::hasVolumeList() const {
    return _volumeList.hasValue();
}

act_t Mascf_main_fiProxy::sendVolumeListGet(VolumeListCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_VolumeList);
        ::boost::shared_ptr< VolumeListGet > payload (new VolumeListGet());
        CCA_MESSAGE(ccaMessage,header,VolumeListGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "VolumeList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_VolumeList);
        ::boost::shared_ptr< VolumeListError > payload (new VolumeListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VolumeListError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "VolumeList", &cb);
    }
}

act_t Mascf_main_fiProxy::sendVolumeListSet(VolumeListCallbackIF& cb, const ::masc_main_fi_types::T_Aud_VolumeStatusList& audVolumeList) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_VolumeList);
        ::boost::shared_ptr< VolumeListSet > payload (new VolumeListSet());
        payload->setAudVolumeList(audVolumeList);
        CCA_MESSAGE(ccaMessage,header,VolumeListSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "VolumeList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_VolumeList);
        ::boost::shared_ptr< VolumeListError > payload (new VolumeListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VolumeListError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "VolumeList", &cb);
    }
}

act_t Mascf_main_fiProxy::sendBTAudioInLevelUpReg(BTAudioInLevelCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_BTAudioInLevel);
        ::boost::shared_ptr< BTAudioInLevelUpReg > payload (new BTAudioInLevelUpReg());
        CCA_MESSAGE(ccaMessage,header,BTAudioInLevelUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< BTAudioInLevelRelUpReg > payloadRelUpRegHeap (new BTAudioInLevelRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_BTAudioInLevel, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::BTAudioInLevelRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_BTAudioInLevel, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "BTAudioInLevel", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "BTAudioInLevel", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasBTAudioInLevel()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_BTAudioInLevel, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< BTAudioInLevelStatus > payloadLoopback (new BTAudioInLevelStatus(getBTAudioInLevel()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,BTAudioInLevelStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_BTAudioInLevel);
        ::boost::shared_ptr< BTAudioInLevelError > payload (new BTAudioInLevelError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,BTAudioInLevelError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "BTAudioInLevel", &cb);
    }
}

bool Mascf_main_fiProxy::sendBTAudioInLevelRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_BTAudioInLevel,"BTAudioInLevel");
}

void Mascf_main_fiProxy::sendBTAudioInLevelRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_BTAudioInLevel);
}

const BTAudioInLevelStatus& Mascf_main_fiProxy::getBTAudioInLevel() const {
    return _bTAudioInLevel.get();
}

bool Mascf_main_fiProxy::hasBTAudioInLevel() const {
    return _bTAudioInLevel.hasValue();
}

act_t Mascf_main_fiProxy::sendBTAudioInLevelGet(BTAudioInLevelCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_BTAudioInLevel);
        ::boost::shared_ptr< BTAudioInLevelGet > payload (new BTAudioInLevelGet());
        CCA_MESSAGE(ccaMessage,header,BTAudioInLevelGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "BTAudioInLevel", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_BTAudioInLevel);
        ::boost::shared_ptr< BTAudioInLevelError > payload (new BTAudioInLevelError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,BTAudioInLevelError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "BTAudioInLevel", &cb);
    }
}

act_t Mascf_main_fiProxy::sendBTAudioInLevelSet(BTAudioInLevelCallbackIF& cb, ::masc_main_fi_types::T_e8_BTAudioInLevel bTAudioInLevel) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_BTAudioInLevel);
        ::boost::shared_ptr< BTAudioInLevelSet > payload (new BTAudioInLevelSet());
        payload->setBTAudioInLevel(bTAudioInLevel);
        CCA_MESSAGE(ccaMessage,header,BTAudioInLevelSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "BTAudioInLevel", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_BTAudioInLevel);
        ::boost::shared_ptr< BTAudioInLevelError > payload (new BTAudioInLevelError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,BTAudioInLevelError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "BTAudioInLevel", &cb);
    }
}

act_t Mascf_main_fiProxy::sendEngineeringDataUpReg(EngineeringDataCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_EngineeringData);
        ::boost::shared_ptr< EngineeringDataUpReg > payload (new EngineeringDataUpReg());
        CCA_MESSAGE(ccaMessage,header,EngineeringDataUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< EngineeringDataRelUpReg > payloadRelUpRegHeap (new EngineeringDataRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_EngineeringData, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::EngineeringDataRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_EngineeringData, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "EngineeringData", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "EngineeringData", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasEngineeringData()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_EngineeringData, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< EngineeringDataStatus > payloadLoopback (new EngineeringDataStatus(getEngineeringData()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,EngineeringDataStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_EngineeringData);
        ::boost::shared_ptr< EngineeringDataError > payload (new EngineeringDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,EngineeringDataError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "EngineeringData", &cb);
    }
}

bool Mascf_main_fiProxy::sendEngineeringDataRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_EngineeringData,"EngineeringData");
}

void Mascf_main_fiProxy::sendEngineeringDataRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_EngineeringData);
}

const EngineeringDataStatus& Mascf_main_fiProxy::getEngineeringData() const {
    return _engineeringData.get();
}

bool Mascf_main_fiProxy::hasEngineeringData() const {
    return _engineeringData.hasValue();
}

act_t Mascf_main_fiProxy::sendEngineeringDataGet(EngineeringDataCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_EngineeringData);
        ::boost::shared_ptr< EngineeringDataGet > payload (new EngineeringDataGet());
        CCA_MESSAGE(ccaMessage,header,EngineeringDataGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "EngineeringData", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_EngineeringData);
        ::boost::shared_ptr< EngineeringDataError > payload (new EngineeringDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,EngineeringDataError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "EngineeringData", &cb);
    }
}

act_t Mascf_main_fiProxy::sendEngineeringDataSet(EngineeringDataCallbackIF& cb, const ::masc_main_fi_types::T_Aud_EDStatusList& engineeringDataList) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_EngineeringData);
        ::boost::shared_ptr< EngineeringDataSet > payload (new EngineeringDataSet());
        payload->setEngineeringDataList(engineeringDataList);
        CCA_MESSAGE(ccaMessage,header,EngineeringDataSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "EngineeringData", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_EngineeringData);
        ::boost::shared_ptr< EngineeringDataError > payload (new EngineeringDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,EngineeringDataError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "EngineeringData", &cb);
    }
}

act_t Mascf_main_fiProxy::sendSurroundSettingUpReg(SurroundSettingCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SurroundSetting);
        ::boost::shared_ptr< SurroundSettingUpReg > payload (new SurroundSettingUpReg());
        CCA_MESSAGE(ccaMessage,header,SurroundSettingUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SurroundSettingRelUpReg > payloadRelUpRegHeap (new SurroundSettingRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SurroundSetting, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::SurroundSettingRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SurroundSetting, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SurroundSetting", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SurroundSetting", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSurroundSetting()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SurroundSetting, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SurroundSettingStatus > payloadLoopback (new SurroundSettingStatus(getSurroundSetting()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SurroundSettingStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SurroundSetting);
        ::boost::shared_ptr< SurroundSettingError > payload (new SurroundSettingError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SurroundSettingError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SurroundSetting", &cb);
    }
}

bool Mascf_main_fiProxy::sendSurroundSettingRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SurroundSetting,"SurroundSetting");
}

void Mascf_main_fiProxy::sendSurroundSettingRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SurroundSetting);
}

const SurroundSettingStatus& Mascf_main_fiProxy::getSurroundSetting() const {
    return _surroundSetting.get();
}

bool Mascf_main_fiProxy::hasSurroundSetting() const {
    return _surroundSetting.hasValue();
}

act_t Mascf_main_fiProxy::sendSurroundSettingGet(SurroundSettingCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SurroundSetting);
        ::boost::shared_ptr< SurroundSettingGet > payload (new SurroundSettingGet());
        CCA_MESSAGE(ccaMessage,header,SurroundSettingGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SurroundSetting", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SurroundSetting);
        ::boost::shared_ptr< SurroundSettingError > payload (new SurroundSettingError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SurroundSettingError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SurroundSetting", &cb);
    }
}

act_t Mascf_main_fiProxy::sendSurroundSettingSet(SurroundSettingCallbackIF& cb, ::masc_main_fi_types::T_e8_SurroundSetting surround) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SurroundSetting);
        ::boost::shared_ptr< SurroundSettingSet > payload (new SurroundSettingSet());
        payload->setSurround(surround);
        CCA_MESSAGE(ccaMessage,header,SurroundSettingSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SurroundSetting", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SurroundSetting);
        ::boost::shared_ptr< SurroundSettingError > payload (new SurroundSettingError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SurroundSettingError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SurroundSetting", &cb);
    }
}

act_t Mascf_main_fiProxy::sendVolumeLockUpReg(VolumeLockCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_VolumeLock);
        ::boost::shared_ptr< VolumeLockUpReg > payload (new VolumeLockUpReg());
        CCA_MESSAGE(ccaMessage,header,VolumeLockUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< VolumeLockRelUpReg > payloadRelUpRegHeap (new VolumeLockRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_VolumeLock, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::VolumeLockRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_VolumeLock, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "VolumeLock", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "VolumeLock", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasVolumeLock()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_VolumeLock, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< VolumeLockStatus > payloadLoopback (new VolumeLockStatus(getVolumeLock()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,VolumeLockStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_VolumeLock);
        ::boost::shared_ptr< VolumeLockError > payload (new VolumeLockError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VolumeLockError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "VolumeLock", &cb);
    }
}

bool Mascf_main_fiProxy::sendVolumeLockRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_VolumeLock,"VolumeLock");
}

void Mascf_main_fiProxy::sendVolumeLockRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_VolumeLock);
}

const VolumeLockStatus& Mascf_main_fiProxy::getVolumeLock() const {
    return _volumeLock.get();
}

bool Mascf_main_fiProxy::hasVolumeLock() const {
    return _volumeLock.hasValue();
}

act_t Mascf_main_fiProxy::sendVolumeLockGet(VolumeLockCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_VolumeLock);
        ::boost::shared_ptr< VolumeLockGet > payload (new VolumeLockGet());
        CCA_MESSAGE(ccaMessage,header,VolumeLockGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "VolumeLock", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_VolumeLock);
        ::boost::shared_ptr< VolumeLockError > payload (new VolumeLockError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VolumeLockError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "VolumeLock", &cb);
    }
}

act_t Mascf_main_fiProxy::sendVolumeLockSet(VolumeLockCallbackIF& cb, ::masc_main_fi_types::T_e8_VolumeLock volumeLockType, ::masc_main_fi_types::T_e8_Requester requester) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_VolumeLock);
        ::boost::shared_ptr< VolumeLockSet > payload (new VolumeLockSet());
        payload->setVolumeLockType(volumeLockType);
        payload->setRequester(requester);
        CCA_MESSAGE(ccaMessage,header,VolumeLockSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "VolumeLock", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_VolumeLock);
        ::boost::shared_ptr< VolumeLockError > payload (new VolumeLockError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VolumeLockError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "VolumeLock", &cb);
    }
}

act_t Mascf_main_fiProxy::sendAmpAvailFunctionUpReg(AmpAvailFunctionCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AmpAvailFunction);
        ::boost::shared_ptr< AmpAvailFunctionUpReg > payload (new AmpAvailFunctionUpReg());
        CCA_MESSAGE(ccaMessage,header,AmpAvailFunctionUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AmpAvailFunctionRelUpReg > payloadRelUpRegHeap (new AmpAvailFunctionRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AmpAvailFunction, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::AmpAvailFunctionRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AmpAvailFunction, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AmpAvailFunction", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AmpAvailFunction", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAmpAvailFunction()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AmpAvailFunction, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AmpAvailFunctionStatus > payloadLoopback (new AmpAvailFunctionStatus(getAmpAvailFunction()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AmpAvailFunctionStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AmpAvailFunction);
        ::boost::shared_ptr< AmpAvailFunctionError > payload (new AmpAvailFunctionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AmpAvailFunctionError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AmpAvailFunction", &cb);
    }
}

bool Mascf_main_fiProxy::sendAmpAvailFunctionRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AmpAvailFunction,"AmpAvailFunction");
}

void Mascf_main_fiProxy::sendAmpAvailFunctionRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AmpAvailFunction);
}

const AmpAvailFunctionStatus& Mascf_main_fiProxy::getAmpAvailFunction() const {
    return _ampAvailFunction.get();
}

bool Mascf_main_fiProxy::hasAmpAvailFunction() const {
    return _ampAvailFunction.hasValue();
}

act_t Mascf_main_fiProxy::sendAmpAvailFunctionGet(AmpAvailFunctionCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_AmpAvailFunction);
        ::boost::shared_ptr< AmpAvailFunctionGet > payload (new AmpAvailFunctionGet());
        CCA_MESSAGE(ccaMessage,header,AmpAvailFunctionGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "AmpAvailFunction", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AmpAvailFunction);
        ::boost::shared_ptr< AmpAvailFunctionError > payload (new AmpAvailFunctionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AmpAvailFunctionError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "AmpAvailFunction", &cb);
    }
}

act_t Mascf_main_fiProxy::sendSetAudioPropertyUpReg(SetAudioPropertyCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SetAudioProperty);
        ::boost::shared_ptr< SetAudioPropertyUpReg > payload (new SetAudioPropertyUpReg());
        CCA_MESSAGE(ccaMessage,header,SetAudioPropertyUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SetAudioPropertyRelUpReg > payloadRelUpRegHeap (new SetAudioPropertyRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SetAudioProperty, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::SetAudioPropertyRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SetAudioProperty, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SetAudioProperty", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SetAudioProperty", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSetAudioProperty()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SetAudioProperty, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SetAudioPropertyStatus > payloadLoopback (new SetAudioPropertyStatus(getSetAudioProperty()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SetAudioPropertyStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetAudioProperty);
        ::boost::shared_ptr< SetAudioPropertyError > payload (new SetAudioPropertyError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetAudioPropertyError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SetAudioProperty", &cb);
    }
}

bool Mascf_main_fiProxy::sendSetAudioPropertyRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SetAudioProperty,"SetAudioProperty");
}

void Mascf_main_fiProxy::sendSetAudioPropertyRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SetAudioProperty);
}

const SetAudioPropertyStatus& Mascf_main_fiProxy::getSetAudioProperty() const {
    return _setAudioProperty.get();
}

bool Mascf_main_fiProxy::hasSetAudioProperty() const {
    return _setAudioProperty.hasValue();
}

act_t Mascf_main_fiProxy::sendSetAudioPropertyGet(SetAudioPropertyCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SetAudioProperty);
        ::boost::shared_ptr< SetAudioPropertyGet > payload (new SetAudioPropertyGet());
        CCA_MESSAGE(ccaMessage,header,SetAudioPropertyGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SetAudioProperty", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetAudioProperty);
        ::boost::shared_ptr< SetAudioPropertyError > payload (new SetAudioPropertyError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetAudioPropertyError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SetAudioProperty", &cb);
    }
}

act_t Mascf_main_fiProxy::sendSetAudioPropertySet(SetAudioPropertyCallbackIF& cb, ::mascf_aud_src_route_fi_types::T_e8_AudSource u8Source, ::mascf_aud_src_route_fi_types::T_e8_AudioProperty u8Property, int32 s32PropValue) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SetAudioProperty);
        ::boost::shared_ptr< SetAudioPropertySet > payload (new SetAudioPropertySet());
        payload->setU8Source(u8Source);
        payload->setU8Property(u8Property);
        payload->setS32PropValue(s32PropValue);
        CCA_MESSAGE(ccaMessage,header,SetAudioPropertySet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SetAudioProperty", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetAudioProperty);
        ::boost::shared_ptr< SetAudioPropertyError > payload (new SetAudioPropertyError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetAudioPropertyError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SetAudioProperty", &cb);
    }
}

act_t Mascf_main_fiProxy::sendEntOnVolumeSetupUpReg(EntOnVolumeSetupCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_EntOnVolumeSetup);
        ::boost::shared_ptr< EntOnVolumeSetupUpReg > payload (new EntOnVolumeSetupUpReg());
        CCA_MESSAGE(ccaMessage,header,EntOnVolumeSetupUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< EntOnVolumeSetupRelUpReg > payloadRelUpRegHeap (new EntOnVolumeSetupRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_EntOnVolumeSetup, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::EntOnVolumeSetupRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_EntOnVolumeSetup, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "EntOnVolumeSetup", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "EntOnVolumeSetup", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasEntOnVolumeSetup()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_EntOnVolumeSetup, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< EntOnVolumeSetupStatus > payloadLoopback (new EntOnVolumeSetupStatus(getEntOnVolumeSetup()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,EntOnVolumeSetupStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_EntOnVolumeSetup);
        ::boost::shared_ptr< EntOnVolumeSetupError > payload (new EntOnVolumeSetupError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,EntOnVolumeSetupError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "EntOnVolumeSetup", &cb);
    }
}

bool Mascf_main_fiProxy::sendEntOnVolumeSetupRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_EntOnVolumeSetup,"EntOnVolumeSetup");
}

void Mascf_main_fiProxy::sendEntOnVolumeSetupRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_EntOnVolumeSetup);
}

const EntOnVolumeSetupStatus& Mascf_main_fiProxy::getEntOnVolumeSetup() const {
    return _entOnVolumeSetup.get();
}

bool Mascf_main_fiProxy::hasEntOnVolumeSetup() const {
    return _entOnVolumeSetup.hasValue();
}

act_t Mascf_main_fiProxy::sendEntOnVolumeSetupSet(EntOnVolumeSetupCallbackIF& cb, uint8 limitValue, ::masc_main_fi_types::T_e8_AudioSoundType soundType) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_EntOnVolumeSetup);
        ::boost::shared_ptr< EntOnVolumeSetupSet > payload (new EntOnVolumeSetupSet());
        payload->setLimitValue(limitValue);
        payload->setSoundType(soundType);
        CCA_MESSAGE(ccaMessage,header,EntOnVolumeSetupSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "EntOnVolumeSetup", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_EntOnVolumeSetup);
        ::boost::shared_ptr< EntOnVolumeSetupError > payload (new EntOnVolumeSetupError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,EntOnVolumeSetupError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "EntOnVolumeSetup", &cb);
    }
}

act_t Mascf_main_fiProxy::sendRoomEffectUpReg(RoomEffectCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_RoomEffect);
        ::boost::shared_ptr< RoomEffectUpReg > payload (new RoomEffectUpReg());
        CCA_MESSAGE(ccaMessage,header,RoomEffectUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< RoomEffectRelUpReg > payloadRelUpRegHeap (new RoomEffectRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_RoomEffect, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::RoomEffectRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_RoomEffect, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "RoomEffect", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "RoomEffect", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasRoomEffect()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_RoomEffect, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< RoomEffectStatus > payloadLoopback (new RoomEffectStatus(getRoomEffect()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,RoomEffectStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RoomEffect);
        ::boost::shared_ptr< RoomEffectError > payload (new RoomEffectError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RoomEffectError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "RoomEffect", &cb);
    }
}

bool Mascf_main_fiProxy::sendRoomEffectRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_RoomEffect,"RoomEffect");
}

void Mascf_main_fiProxy::sendRoomEffectRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_RoomEffect);
}

const RoomEffectStatus& Mascf_main_fiProxy::getRoomEffect() const {
    return _roomEffect.get();
}

bool Mascf_main_fiProxy::hasRoomEffect() const {
    return _roomEffect.hasValue();
}

act_t Mascf_main_fiProxy::sendRoomEffectGet(RoomEffectCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_RoomEffect);
        ::boost::shared_ptr< RoomEffectGet > payload (new RoomEffectGet());
        CCA_MESSAGE(ccaMessage,header,RoomEffectGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "RoomEffect", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RoomEffect);
        ::boost::shared_ptr< RoomEffectError > payload (new RoomEffectError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RoomEffectError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "RoomEffect", &cb);
    }
}

act_t Mascf_main_fiProxy::sendRoomEffectSet(RoomEffectCallbackIF& cb, ::masc_main_fi_types::T_e8_RoomEffect roomEffect, ::masc_main_fi_types::T_e8_ResourceNo resource) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_RoomEffect);
        ::boost::shared_ptr< RoomEffectSet > payload (new RoomEffectSet());
        payload->setRoomEffect(roomEffect);
        payload->setResource(resource);
        CCA_MESSAGE(ccaMessage,header,RoomEffectSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "RoomEffect", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RoomEffect);
        ::boost::shared_ptr< RoomEffectError > payload (new RoomEffectError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RoomEffectError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "RoomEffect", &cb);
    }
}

act_t Mascf_main_fiProxy::sendFMEnhancerModeUpReg(FMEnhancerModeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_FMEnhancerMode);
        ::boost::shared_ptr< FMEnhancerModeUpReg > payload (new FMEnhancerModeUpReg());
        CCA_MESSAGE(ccaMessage,header,FMEnhancerModeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< FMEnhancerModeRelUpReg > payloadRelUpRegHeap (new FMEnhancerModeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_FMEnhancerMode, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::FMEnhancerModeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_FMEnhancerMode, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "FMEnhancerMode", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "FMEnhancerMode", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasFMEnhancerMode()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_FMEnhancerMode, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< FMEnhancerModeStatus > payloadLoopback (new FMEnhancerModeStatus(getFMEnhancerMode()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,FMEnhancerModeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FMEnhancerMode);
        ::boost::shared_ptr< FMEnhancerModeError > payload (new FMEnhancerModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FMEnhancerModeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "FMEnhancerMode", &cb);
    }
}

bool Mascf_main_fiProxy::sendFMEnhancerModeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_FMEnhancerMode,"FMEnhancerMode");
}

void Mascf_main_fiProxy::sendFMEnhancerModeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_FMEnhancerMode);
}

const FMEnhancerModeStatus& Mascf_main_fiProxy::getFMEnhancerMode() const {
    return _fMEnhancerMode.get();
}

bool Mascf_main_fiProxy::hasFMEnhancerMode() const {
    return _fMEnhancerMode.hasValue();
}

act_t Mascf_main_fiProxy::sendFMEnhancerModeGet(FMEnhancerModeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_FMEnhancerMode);
        ::boost::shared_ptr< FMEnhancerModeGet > payload (new FMEnhancerModeGet());
        CCA_MESSAGE(ccaMessage,header,FMEnhancerModeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "FMEnhancerMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FMEnhancerMode);
        ::boost::shared_ptr< FMEnhancerModeError > payload (new FMEnhancerModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FMEnhancerModeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "FMEnhancerMode", &cb);
    }
}

act_t Mascf_main_fiProxy::sendFMEnhancerModeSet(FMEnhancerModeCallbackIF& cb, bool fMEnhancer) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_FMEnhancerMode);
        ::boost::shared_ptr< FMEnhancerModeSet > payload (new FMEnhancerModeSet());
        payload->setFMEnhancer(fMEnhancer);
        CCA_MESSAGE(ccaMessage,header,FMEnhancerModeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "FMEnhancerMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FMEnhancerMode);
        ::boost::shared_ptr< FMEnhancerModeError > payload (new FMEnhancerModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FMEnhancerModeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "FMEnhancerMode", &cb);
    }
}

act_t Mascf_main_fiProxy::sendDiagDefSetPhaseUpReg(DiagDefSetPhaseCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DiagDefSetPhase);
        ::boost::shared_ptr< DiagDefSetPhaseUpReg > payload (new DiagDefSetPhaseUpReg());
        CCA_MESSAGE(ccaMessage,header,DiagDefSetPhaseUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DiagDefSetPhaseRelUpReg > payloadRelUpRegHeap (new DiagDefSetPhaseRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DiagDefSetPhase, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::DiagDefSetPhaseRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DiagDefSetPhase, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DiagDefSetPhase", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DiagDefSetPhase", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDiagDefSetPhase()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DiagDefSetPhase, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DiagDefSetPhaseStatus > payloadLoopback (new DiagDefSetPhaseStatus(getDiagDefSetPhase()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DiagDefSetPhaseStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DiagDefSetPhase);
        ::boost::shared_ptr< DiagDefSetPhaseError > payload (new DiagDefSetPhaseError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DiagDefSetPhaseError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DiagDefSetPhase", &cb);
    }
}

bool Mascf_main_fiProxy::sendDiagDefSetPhaseRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DiagDefSetPhase,"DiagDefSetPhase");
}

void Mascf_main_fiProxy::sendDiagDefSetPhaseRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DiagDefSetPhase);
}

const DiagDefSetPhaseStatus& Mascf_main_fiProxy::getDiagDefSetPhase() const {
    return _diagDefSetPhase.get();
}

bool Mascf_main_fiProxy::hasDiagDefSetPhase() const {
    return _diagDefSetPhase.hasValue();
}

act_t Mascf_main_fiProxy::sendDiagDefSetPhaseGet(DiagDefSetPhaseCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DiagDefSetPhase);
        ::boost::shared_ptr< DiagDefSetPhaseGet > payload (new DiagDefSetPhaseGet());
        CCA_MESSAGE(ccaMessage,header,DiagDefSetPhaseGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DiagDefSetPhase", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DiagDefSetPhase);
        ::boost::shared_ptr< DiagDefSetPhaseError > payload (new DiagDefSetPhaseError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DiagDefSetPhaseError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DiagDefSetPhase", &cb);
    }
}

act_t Mascf_main_fiProxy::sendESESoundTypeUpReg(ESESoundTypeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ESESoundType);
        ::boost::shared_ptr< ESESoundTypeUpReg > payload (new ESESoundTypeUpReg());
        CCA_MESSAGE(ccaMessage,header,ESESoundTypeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ESESoundTypeRelUpReg > payloadRelUpRegHeap (new ESESoundTypeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ESESoundType, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::ESESoundTypeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ESESoundType, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ESESoundType", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ESESoundType", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasESESoundType()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ESESoundType, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ESESoundTypeStatus > payloadLoopback (new ESESoundTypeStatus(getESESoundType()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ESESoundTypeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ESESoundType);
        ::boost::shared_ptr< ESESoundTypeError > payload (new ESESoundTypeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ESESoundTypeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ESESoundType", &cb);
    }
}

bool Mascf_main_fiProxy::sendESESoundTypeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ESESoundType,"ESESoundType");
}

void Mascf_main_fiProxy::sendESESoundTypeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ESESoundType);
}

const ESESoundTypeStatus& Mascf_main_fiProxy::getESESoundType() const {
    return _eSESoundType.get();
}

bool Mascf_main_fiProxy::hasESESoundType() const {
    return _eSESoundType.hasValue();
}

act_t Mascf_main_fiProxy::sendESESoundTypeGet(ESESoundTypeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ESESoundType);
        ::boost::shared_ptr< ESESoundTypeGet > payload (new ESESoundTypeGet());
        CCA_MESSAGE(ccaMessage,header,ESESoundTypeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ESESoundType", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ESESoundType);
        ::boost::shared_ptr< ESESoundTypeError > payload (new ESESoundTypeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ESESoundTypeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ESESoundType", &cb);
    }
}

act_t Mascf_main_fiProxy::sendESESoundTypeSet(ESESoundTypeCallbackIF& cb, uint8 soundType) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_ESESoundType);
        ::boost::shared_ptr< ESESoundTypeSet > payload (new ESESoundTypeSet());
        payload->setSoundType(soundType);
        CCA_MESSAGE(ccaMessage,header,ESESoundTypeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "ESESoundType", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ESESoundType);
        ::boost::shared_ptr< ESESoundTypeError > payload (new ESESoundTypeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ESESoundTypeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "ESESoundType", &cb);
    }
}

act_t Mascf_main_fiProxy::sendESEVolumeUpReg(ESEVolumeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ESEVolume);
        ::boost::shared_ptr< ESEVolumeUpReg > payload (new ESEVolumeUpReg());
        CCA_MESSAGE(ccaMessage,header,ESEVolumeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ESEVolumeRelUpReg > payloadRelUpRegHeap (new ESEVolumeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ESEVolume, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::ESEVolumeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ESEVolume, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ESEVolume", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ESEVolume", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasESEVolume()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ESEVolume, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ESEVolumeStatus > payloadLoopback (new ESEVolumeStatus(getESEVolume()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ESEVolumeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ESEVolume);
        ::boost::shared_ptr< ESEVolumeError > payload (new ESEVolumeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ESEVolumeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ESEVolume", &cb);
    }
}

bool Mascf_main_fiProxy::sendESEVolumeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ESEVolume,"ESEVolume");
}

void Mascf_main_fiProxy::sendESEVolumeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ESEVolume);
}

const ESEVolumeStatus& Mascf_main_fiProxy::getESEVolume() const {
    return _eSEVolume.get();
}

bool Mascf_main_fiProxy::hasESEVolume() const {
    return _eSEVolume.hasValue();
}

act_t Mascf_main_fiProxy::sendESEVolumeGet(ESEVolumeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ESEVolume);
        ::boost::shared_ptr< ESEVolumeGet > payload (new ESEVolumeGet());
        CCA_MESSAGE(ccaMessage,header,ESEVolumeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ESEVolume", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ESEVolume);
        ::boost::shared_ptr< ESEVolumeError > payload (new ESEVolumeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ESEVolumeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ESEVolume", &cb);
    }
}

act_t Mascf_main_fiProxy::sendESEVolumeSet(ESEVolumeCallbackIF& cb, uint8 volume) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_ESEVolume);
        ::boost::shared_ptr< ESEVolumeSet > payload (new ESEVolumeSet());
        payload->setVolume(volume);
        CCA_MESSAGE(ccaMessage,header,ESEVolumeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "ESEVolume", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ESEVolume);
        ::boost::shared_ptr< ESEVolumeError > payload (new ESEVolumeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ESEVolumeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "ESEVolume", &cb);
    }
}

act_t Mascf_main_fiProxy::sendRSoundOnOffUpReg(RSoundOnOffCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_RSoundOnOff);
        ::boost::shared_ptr< RSoundOnOffUpReg > payload (new RSoundOnOffUpReg());
        CCA_MESSAGE(ccaMessage,header,RSoundOnOffUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< RSoundOnOffRelUpReg > payloadRelUpRegHeap (new RSoundOnOffRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_RSoundOnOff, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::RSoundOnOffRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_RSoundOnOff, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "RSoundOnOff", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "RSoundOnOff", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasRSoundOnOff()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_RSoundOnOff, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< RSoundOnOffStatus > payloadLoopback (new RSoundOnOffStatus(getRSoundOnOff()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,RSoundOnOffStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RSoundOnOff);
        ::boost::shared_ptr< RSoundOnOffError > payload (new RSoundOnOffError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RSoundOnOffError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "RSoundOnOff", &cb);
    }
}

bool Mascf_main_fiProxy::sendRSoundOnOffRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_RSoundOnOff,"RSoundOnOff");
}

void Mascf_main_fiProxy::sendRSoundOnOffRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_RSoundOnOff);
}

const RSoundOnOffStatus& Mascf_main_fiProxy::getRSoundOnOff() const {
    return _rSoundOnOff.get();
}

bool Mascf_main_fiProxy::hasRSoundOnOff() const {
    return _rSoundOnOff.hasValue();
}

act_t Mascf_main_fiProxy::sendRSoundOnOffGet(RSoundOnOffCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_RSoundOnOff);
        ::boost::shared_ptr< RSoundOnOffGet > payload (new RSoundOnOffGet());
        CCA_MESSAGE(ccaMessage,header,RSoundOnOffGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "RSoundOnOff", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RSoundOnOff);
        ::boost::shared_ptr< RSoundOnOffError > payload (new RSoundOnOffError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RSoundOnOffError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "RSoundOnOff", &cb);
    }
}

act_t Mascf_main_fiProxy::sendRSoundOnOffSet(RSoundOnOffCallbackIF& cb, bool rSound) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_RSoundOnOff);
        ::boost::shared_ptr< RSoundOnOffSet > payload (new RSoundOnOffSet());
        payload->setRSound(rSound);
        CCA_MESSAGE(ccaMessage,header,RSoundOnOffSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "RSoundOnOff", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RSoundOnOff);
        ::boost::shared_ptr< RSoundOnOffError > payload (new RSoundOnOffError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RSoundOnOffError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "RSoundOnOff", &cb);
    }
}

act_t Mascf_main_fiProxy::sendRSoundSoundTypeUpReg(RSoundSoundTypeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_RSoundSoundType);
        ::boost::shared_ptr< RSoundSoundTypeUpReg > payload (new RSoundSoundTypeUpReg());
        CCA_MESSAGE(ccaMessage,header,RSoundSoundTypeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< RSoundSoundTypeRelUpReg > payloadRelUpRegHeap (new RSoundSoundTypeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_RSoundSoundType, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::RSoundSoundTypeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_RSoundSoundType, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "RSoundSoundType", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "RSoundSoundType", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasRSoundSoundType()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_RSoundSoundType, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< RSoundSoundTypeStatus > payloadLoopback (new RSoundSoundTypeStatus(getRSoundSoundType()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,RSoundSoundTypeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RSoundSoundType);
        ::boost::shared_ptr< RSoundSoundTypeError > payload (new RSoundSoundTypeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RSoundSoundTypeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "RSoundSoundType", &cb);
    }
}

bool Mascf_main_fiProxy::sendRSoundSoundTypeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_RSoundSoundType,"RSoundSoundType");
}

void Mascf_main_fiProxy::sendRSoundSoundTypeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_RSoundSoundType);
}

const RSoundSoundTypeStatus& Mascf_main_fiProxy::getRSoundSoundType() const {
    return _rSoundSoundType.get();
}

bool Mascf_main_fiProxy::hasRSoundSoundType() const {
    return _rSoundSoundType.hasValue();
}

act_t Mascf_main_fiProxy::sendRSoundSoundTypeGet(RSoundSoundTypeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_RSoundSoundType);
        ::boost::shared_ptr< RSoundSoundTypeGet > payload (new RSoundSoundTypeGet());
        CCA_MESSAGE(ccaMessage,header,RSoundSoundTypeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "RSoundSoundType", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RSoundSoundType);
        ::boost::shared_ptr< RSoundSoundTypeError > payload (new RSoundSoundTypeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RSoundSoundTypeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "RSoundSoundType", &cb);
    }
}

act_t Mascf_main_fiProxy::sendRSoundSoundTypeSet(RSoundSoundTypeCallbackIF& cb, uint8 rSoundType) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_RSoundSoundType);
        ::boost::shared_ptr< RSoundSoundTypeSet > payload (new RSoundSoundTypeSet());
        payload->setRSoundType(rSoundType);
        CCA_MESSAGE(ccaMessage,header,RSoundSoundTypeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "RSoundSoundType", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RSoundSoundType);
        ::boost::shared_ptr< RSoundSoundTypeError > payload (new RSoundSoundTypeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RSoundSoundTypeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "RSoundSoundType", &cb);
    }
}

act_t Mascf_main_fiProxy::sendRSoundVolumeUpReg(RSoundVolumeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_RSoundVolume);
        ::boost::shared_ptr< RSoundVolumeUpReg > payload (new RSoundVolumeUpReg());
        CCA_MESSAGE(ccaMessage,header,RSoundVolumeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< RSoundVolumeRelUpReg > payloadRelUpRegHeap (new RSoundVolumeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_RSoundVolume, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::RSoundVolumeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_RSoundVolume, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "RSoundVolume", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "RSoundVolume", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasRSoundVolume()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_RSoundVolume, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< RSoundVolumeStatus > payloadLoopback (new RSoundVolumeStatus(getRSoundVolume()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,RSoundVolumeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RSoundVolume);
        ::boost::shared_ptr< RSoundVolumeError > payload (new RSoundVolumeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RSoundVolumeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "RSoundVolume", &cb);
    }
}

bool Mascf_main_fiProxy::sendRSoundVolumeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_RSoundVolume,"RSoundVolume");
}

void Mascf_main_fiProxy::sendRSoundVolumeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_RSoundVolume);
}

const RSoundVolumeStatus& Mascf_main_fiProxy::getRSoundVolume() const {
    return _rSoundVolume.get();
}

bool Mascf_main_fiProxy::hasRSoundVolume() const {
    return _rSoundVolume.hasValue();
}

act_t Mascf_main_fiProxy::sendRSoundVolumeGet(RSoundVolumeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_RSoundVolume);
        ::boost::shared_ptr< RSoundVolumeGet > payload (new RSoundVolumeGet());
        CCA_MESSAGE(ccaMessage,header,RSoundVolumeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "RSoundVolume", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RSoundVolume);
        ::boost::shared_ptr< RSoundVolumeError > payload (new RSoundVolumeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RSoundVolumeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "RSoundVolume", &cb);
    }
}

act_t Mascf_main_fiProxy::sendRSoundVolumeSet(RSoundVolumeCallbackIF& cb, uint8 volume) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_RSoundVolume);
        ::boost::shared_ptr< RSoundVolumeSet > payload (new RSoundVolumeSet());
        payload->setVolume(volume);
        CCA_MESSAGE(ccaMessage,header,RSoundVolumeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "RSoundVolume", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RSoundVolume);
        ::boost::shared_ptr< RSoundVolumeError > payload (new RSoundVolumeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RSoundVolumeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "RSoundVolume", &cb);
    }
}

act_t Mascf_main_fiProxy::sendESEDriveModeUpReg(ESEDriveModeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ESEDriveMode);
        ::boost::shared_ptr< ESEDriveModeUpReg > payload (new ESEDriveModeUpReg());
        CCA_MESSAGE(ccaMessage,header,ESEDriveModeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ESEDriveModeRelUpReg > payloadRelUpRegHeap (new ESEDriveModeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ESEDriveMode, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::ESEDriveModeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ESEDriveMode, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ESEDriveMode", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ESEDriveMode", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasESEDriveMode()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ESEDriveMode, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ESEDriveModeStatus > payloadLoopback (new ESEDriveModeStatus(getESEDriveMode()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ESEDriveModeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ESEDriveMode);
        ::boost::shared_ptr< ESEDriveModeError > payload (new ESEDriveModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ESEDriveModeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ESEDriveMode", &cb);
    }
}

bool Mascf_main_fiProxy::sendESEDriveModeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ESEDriveMode,"ESEDriveMode");
}

void Mascf_main_fiProxy::sendESEDriveModeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ESEDriveMode);
}

const ESEDriveModeStatus& Mascf_main_fiProxy::getESEDriveMode() const {
    return _eSEDriveMode.get();
}

bool Mascf_main_fiProxy::hasESEDriveMode() const {
    return _eSEDriveMode.hasValue();
}

act_t Mascf_main_fiProxy::sendESEDriveModeGet(ESEDriveModeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ESEDriveMode);
        ::boost::shared_ptr< ESEDriveModeGet > payload (new ESEDriveModeGet());
        CCA_MESSAGE(ccaMessage,header,ESEDriveModeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ESEDriveMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ESEDriveMode);
        ::boost::shared_ptr< ESEDriveModeError > payload (new ESEDriveModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ESEDriveModeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ESEDriveMode", &cb);
    }
}

act_t Mascf_main_fiProxy::sendESEDriveModeSet(ESEDriveModeCallbackIF& cb, uint8 driveMode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_ESEDriveMode);
        ::boost::shared_ptr< ESEDriveModeSet > payload (new ESEDriveModeSet());
        payload->setDriveMode(driveMode);
        CCA_MESSAGE(ccaMessage,header,ESEDriveModeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "ESEDriveMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ESEDriveMode);
        ::boost::shared_ptr< ESEDriveModeError > payload (new ESEDriveModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ESEDriveModeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "ESEDriveMode", &cb);
    }
}

act_t Mascf_main_fiProxy::sendAudioModeUpReg(AudioModeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AudioMode);
        ::boost::shared_ptr< AudioModeUpReg > payload (new AudioModeUpReg());
        CCA_MESSAGE(ccaMessage,header,AudioModeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AudioModeRelUpReg > payloadRelUpRegHeap (new AudioModeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AudioMode, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::AudioModeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AudioMode, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AudioMode", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AudioMode", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAudioMode()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AudioMode, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AudioModeStatus > payloadLoopback (new AudioModeStatus(getAudioMode()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AudioModeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AudioMode);
        ::boost::shared_ptr< AudioModeError > payload (new AudioModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AudioModeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AudioMode", &cb);
    }
}

bool Mascf_main_fiProxy::sendAudioModeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AudioMode,"AudioMode");
}

void Mascf_main_fiProxy::sendAudioModeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AudioMode);
}

const AudioModeStatus& Mascf_main_fiProxy::getAudioMode() const {
    return _audioMode.get();
}

bool Mascf_main_fiProxy::hasAudioMode() const {
    return _audioMode.hasValue();
}

act_t Mascf_main_fiProxy::sendAudioModeGet(AudioModeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_AudioMode);
        ::boost::shared_ptr< AudioModeGet > payload (new AudioModeGet());
        CCA_MESSAGE(ccaMessage,header,AudioModeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "AudioMode", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AudioMode);
        ::boost::shared_ptr< AudioModeError > payload (new AudioModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AudioModeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "AudioMode", &cb);
    }
}

act_t Mascf_main_fiProxy::sendADAS_UPASoundTypeUpReg(ADAS_UPASoundTypeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ADAS_UPASoundType);
        ::boost::shared_ptr< ADAS_UPASoundTypeUpReg > payload (new ADAS_UPASoundTypeUpReg());
        CCA_MESSAGE(ccaMessage,header,ADAS_UPASoundTypeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ADAS_UPASoundTypeRelUpReg > payloadRelUpRegHeap (new ADAS_UPASoundTypeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ADAS_UPASoundType, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::ADAS_UPASoundTypeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ADAS_UPASoundType, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ADAS_UPASoundType", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ADAS_UPASoundType", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasADAS_UPASoundType()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ADAS_UPASoundType, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ADAS_UPASoundTypeStatus > payloadLoopback (new ADAS_UPASoundTypeStatus(getADAS_UPASoundType()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ADAS_UPASoundTypeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ADAS_UPASoundType);
        ::boost::shared_ptr< ADAS_UPASoundTypeError > payload (new ADAS_UPASoundTypeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ADAS_UPASoundTypeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ADAS_UPASoundType", &cb);
    }
}

bool Mascf_main_fiProxy::sendADAS_UPASoundTypeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ADAS_UPASoundType,"ADAS_UPASoundType");
}

void Mascf_main_fiProxy::sendADAS_UPASoundTypeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ADAS_UPASoundType);
}

const ADAS_UPASoundTypeStatus& Mascf_main_fiProxy::getADAS_UPASoundType() const {
    return _aDAS_UPASoundType.get();
}

bool Mascf_main_fiProxy::hasADAS_UPASoundType() const {
    return _aDAS_UPASoundType.hasValue();
}

act_t Mascf_main_fiProxy::sendADAS_UPASoundTypeGet(ADAS_UPASoundTypeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ADAS_UPASoundType);
        ::boost::shared_ptr< ADAS_UPASoundTypeGet > payload (new ADAS_UPASoundTypeGet());
        CCA_MESSAGE(ccaMessage,header,ADAS_UPASoundTypeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ADAS_UPASoundType", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ADAS_UPASoundType);
        ::boost::shared_ptr< ADAS_UPASoundTypeError > payload (new ADAS_UPASoundTypeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ADAS_UPASoundTypeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ADAS_UPASoundType", &cb);
    }
}

act_t Mascf_main_fiProxy::sendADAS_UPASoundTypeSet(ADAS_UPASoundTypeCallbackIF& cb, ::masc_main_fi_types::T_e8_ADAS_UPA_SoundType soundType) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_ADAS_UPASoundType);
        ::boost::shared_ptr< ADAS_UPASoundTypeSet > payload (new ADAS_UPASoundTypeSet());
        payload->setSoundType(soundType);
        CCA_MESSAGE(ccaMessage,header,ADAS_UPASoundTypeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "ADAS_UPASoundType", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ADAS_UPASoundType);
        ::boost::shared_ptr< ADAS_UPASoundTypeError > payload (new ADAS_UPASoundTypeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ADAS_UPASoundTypeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "ADAS_UPASoundType", &cb);
    }
}

act_t Mascf_main_fiProxy::sendADAS_ParkAssistVolumeUpReg(ADAS_ParkAssistVolumeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ADAS_ParkAssistVolume);
        ::boost::shared_ptr< ADAS_ParkAssistVolumeUpReg > payload (new ADAS_ParkAssistVolumeUpReg());
        CCA_MESSAGE(ccaMessage,header,ADAS_ParkAssistVolumeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ADAS_ParkAssistVolumeRelUpReg > payloadRelUpRegHeap (new ADAS_ParkAssistVolumeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ADAS_ParkAssistVolume, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::ADAS_ParkAssistVolumeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ADAS_ParkAssistVolume, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ADAS_ParkAssistVolume", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ADAS_ParkAssistVolume", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasADAS_ParkAssistVolume()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ADAS_ParkAssistVolume, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ADAS_ParkAssistVolumeStatus > payloadLoopback (new ADAS_ParkAssistVolumeStatus(getADAS_ParkAssistVolume()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ADAS_ParkAssistVolumeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ADAS_ParkAssistVolume);
        ::boost::shared_ptr< ADAS_ParkAssistVolumeError > payload (new ADAS_ParkAssistVolumeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ADAS_ParkAssistVolumeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ADAS_ParkAssistVolume", &cb);
    }
}

bool Mascf_main_fiProxy::sendADAS_ParkAssistVolumeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ADAS_ParkAssistVolume,"ADAS_ParkAssistVolume");
}

void Mascf_main_fiProxy::sendADAS_ParkAssistVolumeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ADAS_ParkAssistVolume);
}

const ADAS_ParkAssistVolumeStatus& Mascf_main_fiProxy::getADAS_ParkAssistVolume() const {
    return _aDAS_ParkAssistVolume.get();
}

bool Mascf_main_fiProxy::hasADAS_ParkAssistVolume() const {
    return _aDAS_ParkAssistVolume.hasValue();
}

act_t Mascf_main_fiProxy::sendADAS_ParkAssistVolumeGet(ADAS_ParkAssistVolumeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ADAS_ParkAssistVolume);
        ::boost::shared_ptr< ADAS_ParkAssistVolumeGet > payload (new ADAS_ParkAssistVolumeGet());
        CCA_MESSAGE(ccaMessage,header,ADAS_ParkAssistVolumeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ADAS_ParkAssistVolume", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ADAS_ParkAssistVolume);
        ::boost::shared_ptr< ADAS_ParkAssistVolumeError > payload (new ADAS_ParkAssistVolumeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ADAS_ParkAssistVolumeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ADAS_ParkAssistVolume", &cb);
    }
}

act_t Mascf_main_fiProxy::sendADAS_ParkAssistVolumeSet(ADAS_ParkAssistVolumeCallbackIF& cb, ::masc_main_fi_types::T_e8_ADAS_ParkAssist_Volume volumeLevel) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_ADAS_ParkAssistVolume);
        ::boost::shared_ptr< ADAS_ParkAssistVolumeSet > payload (new ADAS_ParkAssistVolumeSet());
        payload->setVolumeLevel(volumeLevel);
        CCA_MESSAGE(ccaMessage,header,ADAS_ParkAssistVolumeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "ADAS_ParkAssistVolume", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ADAS_ParkAssistVolume);
        ::boost::shared_ptr< ADAS_ParkAssistVolumeError > payload (new ADAS_ParkAssistVolumeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ADAS_ParkAssistVolumeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "ADAS_ParkAssistVolume", &cb);
    }
}

act_t Mascf_main_fiProxy::sendADAS_UPAMuteUpReg(ADAS_UPAMuteCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ADAS_UPAMute);
        ::boost::shared_ptr< ADAS_UPAMuteUpReg > payload (new ADAS_UPAMuteUpReg());
        CCA_MESSAGE(ccaMessage,header,ADAS_UPAMuteUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ADAS_UPAMuteRelUpReg > payloadRelUpRegHeap (new ADAS_UPAMuteRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ADAS_UPAMute, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::ADAS_UPAMuteRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ADAS_UPAMute, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ADAS_UPAMute", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ADAS_UPAMute", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasADAS_UPAMute()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ADAS_UPAMute, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ADAS_UPAMuteStatus > payloadLoopback (new ADAS_UPAMuteStatus(getADAS_UPAMute()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ADAS_UPAMuteStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ADAS_UPAMute);
        ::boost::shared_ptr< ADAS_UPAMuteError > payload (new ADAS_UPAMuteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ADAS_UPAMuteError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ADAS_UPAMute", &cb);
    }
}

bool Mascf_main_fiProxy::sendADAS_UPAMuteRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ADAS_UPAMute,"ADAS_UPAMute");
}

void Mascf_main_fiProxy::sendADAS_UPAMuteRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ADAS_UPAMute);
}

const ADAS_UPAMuteStatus& Mascf_main_fiProxy::getADAS_UPAMute() const {
    return _aDAS_UPAMute.get();
}

bool Mascf_main_fiProxy::hasADAS_UPAMute() const {
    return _aDAS_UPAMute.hasValue();
}

act_t Mascf_main_fiProxy::sendADAS_UPAMuteGet(ADAS_UPAMuteCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ADAS_UPAMute);
        ::boost::shared_ptr< ADAS_UPAMuteGet > payload (new ADAS_UPAMuteGet());
        CCA_MESSAGE(ccaMessage,header,ADAS_UPAMuteGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ADAS_UPAMute", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ADAS_UPAMute);
        ::boost::shared_ptr< ADAS_UPAMuteError > payload (new ADAS_UPAMuteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ADAS_UPAMuteError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ADAS_UPAMute", &cb);
    }
}

act_t Mascf_main_fiProxy::sendADAS_UPAMuteSet(ADAS_UPAMuteCallbackIF& cb, bool bMute) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_ADAS_UPAMute);
        ::boost::shared_ptr< ADAS_UPAMuteSet > payload (new ADAS_UPAMuteSet());
        payload->setBMute(bMute);
        CCA_MESSAGE(ccaMessage,header,ADAS_UPAMuteSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "ADAS_UPAMute", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ADAS_UPAMute);
        ::boost::shared_ptr< ADAS_UPAMuteError > payload (new ADAS_UPAMuteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ADAS_UPAMuteError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "ADAS_UPAMute", &cb);
    }
}

act_t Mascf_main_fiProxy::sendAutomaticGainControlUpReg(AutomaticGainControlCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AutomaticGainControl);
        ::boost::shared_ptr< AutomaticGainControlUpReg > payload (new AutomaticGainControlUpReg());
        CCA_MESSAGE(ccaMessage,header,AutomaticGainControlUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AutomaticGainControlRelUpReg > payloadRelUpRegHeap (new AutomaticGainControlRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AutomaticGainControl, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::AutomaticGainControlRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AutomaticGainControl, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AutomaticGainControl", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AutomaticGainControl", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAutomaticGainControl()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AutomaticGainControl, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AutomaticGainControlStatus > payloadLoopback (new AutomaticGainControlStatus(getAutomaticGainControl()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AutomaticGainControlStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AutomaticGainControl);
        ::boost::shared_ptr< AutomaticGainControlError > payload (new AutomaticGainControlError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AutomaticGainControlError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AutomaticGainControl", &cb);
    }
}

bool Mascf_main_fiProxy::sendAutomaticGainControlRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AutomaticGainControl,"AutomaticGainControl");
}

void Mascf_main_fiProxy::sendAutomaticGainControlRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AutomaticGainControl);
}

const AutomaticGainControlStatus& Mascf_main_fiProxy::getAutomaticGainControl() const {
    return _automaticGainControl.get();
}

bool Mascf_main_fiProxy::hasAutomaticGainControl() const {
    return _automaticGainControl.hasValue();
}

act_t Mascf_main_fiProxy::sendAutomaticGainControlGet(AutomaticGainControlCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_AutomaticGainControl);
        ::boost::shared_ptr< AutomaticGainControlGet > payload (new AutomaticGainControlGet());
        CCA_MESSAGE(ccaMessage,header,AutomaticGainControlGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "AutomaticGainControl", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AutomaticGainControl);
        ::boost::shared_ptr< AutomaticGainControlError > payload (new AutomaticGainControlError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AutomaticGainControlError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "AutomaticGainControl", &cb);
    }
}

act_t Mascf_main_fiProxy::sendAutomaticGainControlSet(AutomaticGainControlCallbackIF& cb, bool automaticGainControl) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_AutomaticGainControl);
        ::boost::shared_ptr< AutomaticGainControlSet > payload (new AutomaticGainControlSet());
        payload->setAutomaticGainControl(automaticGainControl);
        CCA_MESSAGE(ccaMessage,header,AutomaticGainControlSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "AutomaticGainControl", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AutomaticGainControl);
        ::boost::shared_ptr< AutomaticGainControlError > payload (new AutomaticGainControlError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AutomaticGainControlError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "AutomaticGainControl", &cb);
    }
}

act_t Mascf_main_fiProxy::sendADAS_LDW_UserVolumeUpReg(ADAS_LDW_UserVolumeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ADAS_LDW_UserVolume);
        ::boost::shared_ptr< ADAS_LDW_UserVolumeUpReg > payload (new ADAS_LDW_UserVolumeUpReg());
        CCA_MESSAGE(ccaMessage,header,ADAS_LDW_UserVolumeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ADAS_LDW_UserVolumeRelUpReg > payloadRelUpRegHeap (new ADAS_LDW_UserVolumeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ADAS_LDW_UserVolume, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::ADAS_LDW_UserVolumeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ADAS_LDW_UserVolume, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ADAS_LDW_UserVolume", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ADAS_LDW_UserVolume", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasADAS_LDW_UserVolume()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ADAS_LDW_UserVolume, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ADAS_LDW_UserVolumeStatus > payloadLoopback (new ADAS_LDW_UserVolumeStatus(getADAS_LDW_UserVolume()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ADAS_LDW_UserVolumeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ADAS_LDW_UserVolume);
        ::boost::shared_ptr< ADAS_LDW_UserVolumeError > payload (new ADAS_LDW_UserVolumeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ADAS_LDW_UserVolumeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ADAS_LDW_UserVolume", &cb);
    }
}

bool Mascf_main_fiProxy::sendADAS_LDW_UserVolumeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ADAS_LDW_UserVolume,"ADAS_LDW_UserVolume");
}

void Mascf_main_fiProxy::sendADAS_LDW_UserVolumeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ADAS_LDW_UserVolume);
}

const ADAS_LDW_UserVolumeStatus& Mascf_main_fiProxy::getADAS_LDW_UserVolume() const {
    return _aDAS_LDW_UserVolume.get();
}

bool Mascf_main_fiProxy::hasADAS_LDW_UserVolume() const {
    return _aDAS_LDW_UserVolume.hasValue();
}

act_t Mascf_main_fiProxy::sendADAS_LDW_UserVolumeGet(ADAS_LDW_UserVolumeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ADAS_LDW_UserVolume);
        ::boost::shared_ptr< ADAS_LDW_UserVolumeGet > payload (new ADAS_LDW_UserVolumeGet());
        CCA_MESSAGE(ccaMessage,header,ADAS_LDW_UserVolumeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ADAS_LDW_UserVolume", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ADAS_LDW_UserVolume);
        ::boost::shared_ptr< ADAS_LDW_UserVolumeError > payload (new ADAS_LDW_UserVolumeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ADAS_LDW_UserVolumeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ADAS_LDW_UserVolume", &cb);
    }
}

act_t Mascf_main_fiProxy::sendADAS_LDW_UserVolumeSet(ADAS_LDW_UserVolumeCallbackIF& cb, ::masc_main_fi_types::T_e8_ADAS_LDW_UserVolume volumeLevel) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_ADAS_LDW_UserVolume);
        ::boost::shared_ptr< ADAS_LDW_UserVolumeSet > payload (new ADAS_LDW_UserVolumeSet());
        payload->setVolumeLevel(volumeLevel);
        CCA_MESSAGE(ccaMessage,header,ADAS_LDW_UserVolumeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "ADAS_LDW_UserVolume", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ADAS_LDW_UserVolume);
        ::boost::shared_ptr< ADAS_LDW_UserVolumeError > payload (new ADAS_LDW_UserVolumeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ADAS_LDW_UserVolumeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "ADAS_LDW_UserVolume", &cb);
    }
}

act_t Mascf_main_fiProxy::sendRSoundActivationUpReg(RSoundActivationCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_RSoundActivation);
        ::boost::shared_ptr< RSoundActivationUpReg > payload (new RSoundActivationUpReg());
        CCA_MESSAGE(ccaMessage,header,RSoundActivationUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< RSoundActivationRelUpReg > payloadRelUpRegHeap (new RSoundActivationRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_RSoundActivation, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::RSoundActivationRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_RSoundActivation, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "RSoundActivation", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "RSoundActivation", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasRSoundActivation()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_RSoundActivation, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< RSoundActivationStatus > payloadLoopback (new RSoundActivationStatus(getRSoundActivation()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,RSoundActivationStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RSoundActivation);
        ::boost::shared_ptr< RSoundActivationError > payload (new RSoundActivationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RSoundActivationError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "RSoundActivation", &cb);
    }
}

bool Mascf_main_fiProxy::sendRSoundActivationRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_RSoundActivation,"RSoundActivation");
}

void Mascf_main_fiProxy::sendRSoundActivationRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_RSoundActivation);
}

const RSoundActivationStatus& Mascf_main_fiProxy::getRSoundActivation() const {
    return _rSoundActivation.get();
}

bool Mascf_main_fiProxy::hasRSoundActivation() const {
    return _rSoundActivation.hasValue();
}

act_t Mascf_main_fiProxy::sendRSoundActivationGet(RSoundActivationCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_RSoundActivation);
        ::boost::shared_ptr< RSoundActivationGet > payload (new RSoundActivationGet());
        CCA_MESSAGE(ccaMessage,header,RSoundActivationGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "RSoundActivation", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RSoundActivation);
        ::boost::shared_ptr< RSoundActivationError > payload (new RSoundActivationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RSoundActivationError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "RSoundActivation", &cb);
    }
}

act_t Mascf_main_fiProxy::sendRSoundActivationSet(RSoundActivationCallbackIF& cb, bool rSoundActive) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_RSoundActivation);
        ::boost::shared_ptr< RSoundActivationSet > payload (new RSoundActivationSet());
        payload->setRSoundActive(rSoundActive);
        CCA_MESSAGE(ccaMessage,header,RSoundActivationSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "RSoundActivation", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RSoundActivation);
        ::boost::shared_ptr< RSoundActivationError > payload (new RSoundActivationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RSoundActivationError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "RSoundActivation", &cb);
    }
}

act_t Mascf_main_fiProxy::sendANCASCActiveTestUpReg(ANCASCActiveTestCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ANCASCActiveTest);
        ::boost::shared_ptr< ANCASCActiveTestUpReg > payload (new ANCASCActiveTestUpReg());
        CCA_MESSAGE(ccaMessage,header,ANCASCActiveTestUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ANCASCActiveTestRelUpReg > payloadRelUpRegHeap (new ANCASCActiveTestRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ANCASCActiveTest, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::ANCASCActiveTestRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ANCASCActiveTest, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ANCASCActiveTest", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ANCASCActiveTest", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasANCASCActiveTest()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ANCASCActiveTest, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ANCASCActiveTestStatus > payloadLoopback (new ANCASCActiveTestStatus(getANCASCActiveTest()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ANCASCActiveTestStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ANCASCActiveTest);
        ::boost::shared_ptr< ANCASCActiveTestError > payload (new ANCASCActiveTestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ANCASCActiveTestError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ANCASCActiveTest", &cb);
    }
}

bool Mascf_main_fiProxy::sendANCASCActiveTestRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ANCASCActiveTest,"ANCASCActiveTest");
}

void Mascf_main_fiProxy::sendANCASCActiveTestRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ANCASCActiveTest);
}

const ANCASCActiveTestStatus& Mascf_main_fiProxy::getANCASCActiveTest() const {
    return _aNCASCActiveTest.get();
}

bool Mascf_main_fiProxy::hasANCASCActiveTest() const {
    return _aNCASCActiveTest.hasValue();
}

act_t Mascf_main_fiProxy::sendANCASCActiveTestGet(ANCASCActiveTestCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ANCASCActiveTest);
        ::boost::shared_ptr< ANCASCActiveTestGet > payload (new ANCASCActiveTestGet());
        CCA_MESSAGE(ccaMessage,header,ANCASCActiveTestGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ANCASCActiveTest", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ANCASCActiveTest);
        ::boost::shared_ptr< ANCASCActiveTestError > payload (new ANCASCActiveTestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ANCASCActiveTestError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ANCASCActiveTest", &cb);
    }
}

act_t Mascf_main_fiProxy::sendANCASCActiveTestSet(ANCASCActiveTestCallbackIF& cb, uint8 request) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_ANCASCActiveTest);
        ::boost::shared_ptr< ANCASCActiveTestSet > payload (new ANCASCActiveTestSet());
        payload->setRequest(request);
        CCA_MESSAGE(ccaMessage,header,ANCASCActiveTestSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "ANCASCActiveTest", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ANCASCActiveTest);
        ::boost::shared_ptr< ANCASCActiveTestError > payload (new ANCASCActiveTestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ANCASCActiveTestError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "ANCASCActiveTest", &cb);
    }
}

act_t Mascf_main_fiProxy::sendANCASCSelfDiagnosticStatusUpReg(ANCASCSelfDiagnosticStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ANCASCSelfDiagnosticStatus);
        ::boost::shared_ptr< ANCASCSelfDiagnosticStatusUpReg > payload (new ANCASCSelfDiagnosticStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,ANCASCSelfDiagnosticStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ANCASCSelfDiagnosticStatusRelUpReg > payloadRelUpRegHeap (new ANCASCSelfDiagnosticStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ANCASCSelfDiagnosticStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::ANCASCSelfDiagnosticStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ANCASCSelfDiagnosticStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ANCASCSelfDiagnosticStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ANCASCSelfDiagnosticStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasANCASCSelfDiagnosticStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ANCASCSelfDiagnosticStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ANCASCSelfDiagnosticStatusStatus > payloadLoopback (new ANCASCSelfDiagnosticStatusStatus(getANCASCSelfDiagnosticStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ANCASCSelfDiagnosticStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ANCASCSelfDiagnosticStatus);
        ::boost::shared_ptr< ANCASCSelfDiagnosticStatusError > payload (new ANCASCSelfDiagnosticStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ANCASCSelfDiagnosticStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ANCASCSelfDiagnosticStatus", &cb);
    }
}

bool Mascf_main_fiProxy::sendANCASCSelfDiagnosticStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ANCASCSelfDiagnosticStatus,"ANCASCSelfDiagnosticStatus");
}

void Mascf_main_fiProxy::sendANCASCSelfDiagnosticStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ANCASCSelfDiagnosticStatus);
}

const ANCASCSelfDiagnosticStatusStatus& Mascf_main_fiProxy::getANCASCSelfDiagnosticStatus() const {
    return _aNCASCSelfDiagnosticStatus.get();
}

bool Mascf_main_fiProxy::hasANCASCSelfDiagnosticStatus() const {
    return _aNCASCSelfDiagnosticStatus.hasValue();
}

act_t Mascf_main_fiProxy::sendANCASCSelfDiagnosticStatusGet(ANCASCSelfDiagnosticStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ANCASCSelfDiagnosticStatus);
        ::boost::shared_ptr< ANCASCSelfDiagnosticStatusGet > payload (new ANCASCSelfDiagnosticStatusGet());
        CCA_MESSAGE(ccaMessage,header,ANCASCSelfDiagnosticStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ANCASCSelfDiagnosticStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ANCASCSelfDiagnosticStatus);
        ::boost::shared_ptr< ANCASCSelfDiagnosticStatusError > payload (new ANCASCSelfDiagnosticStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ANCASCSelfDiagnosticStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ANCASCSelfDiagnosticStatus", &cb);
    }
}

act_t Mascf_main_fiProxy::sendANCASCSelfDiagnosticStatusSet(ANCASCSelfDiagnosticStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_ANCASCSelfDiagnosticStatus);
        ::boost::shared_ptr< ANCASCSelfDiagnosticStatusSet > payload (new ANCASCSelfDiagnosticStatusSet());
        CCA_MESSAGE(ccaMessage,header,ANCASCSelfDiagnosticStatusSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "ANCASCSelfDiagnosticStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ANCASCSelfDiagnosticStatus);
        ::boost::shared_ptr< ANCASCSelfDiagnosticStatusError > payload (new ANCASCSelfDiagnosticStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ANCASCSelfDiagnosticStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "ANCASCSelfDiagnosticStatus", &cb);
    }
}

act_t Mascf_main_fiProxy::sendUserProfileChangeUpReg(UserProfileChangeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_UserProfileChange);
        ::boost::shared_ptr< UserProfileChangeUpReg > payload (new UserProfileChangeUpReg());
        CCA_MESSAGE(ccaMessage,header,UserProfileChangeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< UserProfileChangeRelUpReg > payloadRelUpRegHeap (new UserProfileChangeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_UserProfileChange, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::UserProfileChangeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_UserProfileChange, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "UserProfileChange", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "UserProfileChange", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasUserProfileChange()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_UserProfileChange, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< UserProfileChangeStatus > payloadLoopback (new UserProfileChangeStatus(getUserProfileChange()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,UserProfileChangeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_UserProfileChange);
        ::boost::shared_ptr< UserProfileChangeError > payload (new UserProfileChangeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,UserProfileChangeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "UserProfileChange", &cb);
    }
}

bool Mascf_main_fiProxy::sendUserProfileChangeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_UserProfileChange,"UserProfileChange");
}

void Mascf_main_fiProxy::sendUserProfileChangeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_UserProfileChange);
}

const UserProfileChangeStatus& Mascf_main_fiProxy::getUserProfileChange() const {
    return _userProfileChange.get();
}

bool Mascf_main_fiProxy::hasUserProfileChange() const {
    return _userProfileChange.hasValue();
}

act_t Mascf_main_fiProxy::sendUserProfileChangeGet(UserProfileChangeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_UserProfileChange);
        ::boost::shared_ptr< UserProfileChangeGet > payload (new UserProfileChangeGet());
        CCA_MESSAGE(ccaMessage,header,UserProfileChangeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "UserProfileChange", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_UserProfileChange);
        ::boost::shared_ptr< UserProfileChangeError > payload (new UserProfileChangeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,UserProfileChangeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "UserProfileChange", &cb);
    }
}

act_t Mascf_main_fiProxy::sendUserProfileChangeSet(UserProfileChangeCallbackIF& cb, bool userProfileChange) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_UserProfileChange);
        ::boost::shared_ptr< UserProfileChangeSet > payload (new UserProfileChangeSet());
        payload->setUserProfileChange(userProfileChange);
        CCA_MESSAGE(ccaMessage,header,UserProfileChangeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "UserProfileChange", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_UserProfileChange);
        ::boost::shared_ptr< UserProfileChangeError > payload (new UserProfileChangeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,UserProfileChangeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "UserProfileChange", &cb);
    }
}

act_t Mascf_main_fiProxy::sendSRSoundNotificationStateUpReg(SRSoundNotificationStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SRSoundNotificationState);
        ::boost::shared_ptr< SRSoundNotificationStateUpReg > payload (new SRSoundNotificationStateUpReg());
        CCA_MESSAGE(ccaMessage,header,SRSoundNotificationStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SRSoundNotificationStateRelUpReg > payloadRelUpRegHeap (new SRSoundNotificationStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SRSoundNotificationState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::SRSoundNotificationStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SRSoundNotificationState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SRSoundNotificationState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SRSoundNotificationState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSRSoundNotificationState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SRSoundNotificationState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SRSoundNotificationStateStatus > payloadLoopback (new SRSoundNotificationStateStatus(getSRSoundNotificationState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SRSoundNotificationStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SRSoundNotificationState);
        ::boost::shared_ptr< SRSoundNotificationStateError > payload (new SRSoundNotificationStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SRSoundNotificationStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SRSoundNotificationState", &cb);
    }
}

bool Mascf_main_fiProxy::sendSRSoundNotificationStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SRSoundNotificationState,"SRSoundNotificationState");
}

void Mascf_main_fiProxy::sendSRSoundNotificationStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SRSoundNotificationState);
}

const SRSoundNotificationStateStatus& Mascf_main_fiProxy::getSRSoundNotificationState() const {
    return _sRSoundNotificationState.get();
}

bool Mascf_main_fiProxy::hasSRSoundNotificationState() const {
    return _sRSoundNotificationState.hasValue();
}

act_t Mascf_main_fiProxy::sendSRSoundNotificationStateGet(SRSoundNotificationStateCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SRSoundNotificationState);
        ::boost::shared_ptr< SRSoundNotificationStateGet > payload (new SRSoundNotificationStateGet());
        CCA_MESSAGE(ccaMessage,header,SRSoundNotificationStateGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SRSoundNotificationState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SRSoundNotificationState);
        ::boost::shared_ptr< SRSoundNotificationStateError > payload (new SRSoundNotificationStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SRSoundNotificationStateError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SRSoundNotificationState", &cb);
    }
}

act_t Mascf_main_fiProxy::sendSRSoundNotificationStateSet(SRSoundNotificationStateCallbackIF& cb, bool sR_SoundNotification_State) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SRSoundNotificationState);
        ::boost::shared_ptr< SRSoundNotificationStateSet > payload (new SRSoundNotificationStateSet());
        payload->setSR_SoundNotification_State(sR_SoundNotification_State);
        CCA_MESSAGE(ccaMessage,header,SRSoundNotificationStateSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SRSoundNotificationState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SRSoundNotificationState);
        ::boost::shared_ptr< SRSoundNotificationStateError > payload (new SRSoundNotificationStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SRSoundNotificationStateError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SRSoundNotificationState", &cb);
    }
}

act_t Mascf_main_fiProxy::sendAudioPilotIntensityUpReg(AudioPilotIntensityCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AudioPilotIntensity);
        ::boost::shared_ptr< AudioPilotIntensityUpReg > payload (new AudioPilotIntensityUpReg());
        CCA_MESSAGE(ccaMessage,header,AudioPilotIntensityUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AudioPilotIntensityRelUpReg > payloadRelUpRegHeap (new AudioPilotIntensityRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AudioPilotIntensity, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::AudioPilotIntensityRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AudioPilotIntensity, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AudioPilotIntensity", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AudioPilotIntensity", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAudioPilotIntensity()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AudioPilotIntensity, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AudioPilotIntensityStatus > payloadLoopback (new AudioPilotIntensityStatus(getAudioPilotIntensity()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AudioPilotIntensityStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AudioPilotIntensity);
        ::boost::shared_ptr< AudioPilotIntensityError > payload (new AudioPilotIntensityError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AudioPilotIntensityError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AudioPilotIntensity", &cb);
    }
}

bool Mascf_main_fiProxy::sendAudioPilotIntensityRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AudioPilotIntensity,"AudioPilotIntensity");
}

void Mascf_main_fiProxy::sendAudioPilotIntensityRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AudioPilotIntensity);
}

const AudioPilotIntensityStatus& Mascf_main_fiProxy::getAudioPilotIntensity() const {
    return _audioPilotIntensity.get();
}

bool Mascf_main_fiProxy::hasAudioPilotIntensity() const {
    return _audioPilotIntensity.hasValue();
}

act_t Mascf_main_fiProxy::sendAudioPilotIntensityGet(AudioPilotIntensityCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_AudioPilotIntensity);
        ::boost::shared_ptr< AudioPilotIntensityGet > payload (new AudioPilotIntensityGet());
        CCA_MESSAGE(ccaMessage,header,AudioPilotIntensityGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "AudioPilotIntensity", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AudioPilotIntensity);
        ::boost::shared_ptr< AudioPilotIntensityError > payload (new AudioPilotIntensityError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AudioPilotIntensityError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "AudioPilotIntensity", &cb);
    }
}

act_t Mascf_main_fiProxy::sendAudioPilotIntensitySet(AudioPilotIntensityCallbackIF& cb, ::masc_main_fi_types::T_e8_AudioPilotIntensity audio_Pilot_Intensity) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_AudioPilotIntensity);
        ::boost::shared_ptr< AudioPilotIntensitySet > payload (new AudioPilotIntensitySet());
        payload->setAudio_Pilot_Intensity(audio_Pilot_Intensity);
        CCA_MESSAGE(ccaMessage,header,AudioPilotIntensitySet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "AudioPilotIntensity", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AudioPilotIntensity);
        ::boost::shared_ptr< AudioPilotIntensityError > payload (new AudioPilotIntensityError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AudioPilotIntensityError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "AudioPilotIntensity", &cb);
    }
}

act_t Mascf_main_fiProxy::sendMainAudioAttenuationUpReg(MainAudioAttenuationCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_MainAudioAttenuation);
        ::boost::shared_ptr< MainAudioAttenuationUpReg > payload (new MainAudioAttenuationUpReg());
        CCA_MESSAGE(ccaMessage,header,MainAudioAttenuationUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< MainAudioAttenuationRelUpReg > payloadRelUpRegHeap (new MainAudioAttenuationRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_MainAudioAttenuation, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::mascf_main_fi::MainAudioAttenuationRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_MainAudioAttenuation, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "MainAudioAttenuation", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "MainAudioAttenuation", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasMainAudioAttenuation()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_MainAudioAttenuation, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< MainAudioAttenuationStatus > payloadLoopback (new MainAudioAttenuationStatus(getMainAudioAttenuation()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,MainAudioAttenuationStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_MainAudioAttenuation);
        ::boost::shared_ptr< MainAudioAttenuationError > payload (new MainAudioAttenuationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,MainAudioAttenuationError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "MainAudioAttenuation", &cb);
    }
}

bool Mascf_main_fiProxy::sendMainAudioAttenuationRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_MainAudioAttenuation,"MainAudioAttenuation");
}

void Mascf_main_fiProxy::sendMainAudioAttenuationRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_MainAudioAttenuation);
}

const MainAudioAttenuationStatus& Mascf_main_fiProxy::getMainAudioAttenuation() const {
    return _mainAudioAttenuation.get();
}

bool Mascf_main_fiProxy::hasMainAudioAttenuation() const {
    return _mainAudioAttenuation.hasValue();
}


void Mascf_main_fiProxy::clearAllProperties ()
{
    _volumeModeStatus = ::asf::core::nullable<VolumeModeStatusStatus>();
    _volume = ::asf::core::nullable<VolumeStatus>();
    _beepStatus = ::asf::core::nullable<BeepStatusStatus>();
    _gala = ::asf::core::nullable<GalaStatus>();
    _balance = ::asf::core::nullable<BalanceStatus>();
    _loudness = ::asf::core::nullable<LoudnessStatus>();
    _bass = ::asf::core::nullable<BassStatus>();
    _treble = ::asf::core::nullable<TrebleStatus>();
    _fader = ::asf::core::nullable<FaderStatus>();
    _midRange = ::asf::core::nullable<MidRangeStatus>();
    _memSound = ::asf::core::nullable<MemSoundStatus>();
    _faderActivationStatus = ::asf::core::nullable<FaderActivationStatusStatus>();
    _dynamicCompression = ::asf::core::nullable<DynamicCompressionStatus>();
    _optimization = ::asf::core::nullable<OptimizationStatus>();
    _equaliserPreset = ::asf::core::nullable<EqualiserPresetStatus>();
    _diagAudMode = ::asf::core::nullable<DiagAudModeStatus>();
    _auxInLevel = ::asf::core::nullable<AuxInLevelStatus>();
    _beepLevel = ::asf::core::nullable<BeepLevelStatus>();
    _rear_Mute = ::asf::core::nullable<Rear_MuteStatus>();
    _geometry_Mode = ::asf::core::nullable<Geometry_ModeStatus>();
    _lSValueStatus = ::asf::core::nullable<LSValueStatusStatus>();
    _pDCAttenuationLevel = ::asf::core::nullable<PDCAttenuationLevelStatus>();
    _pDCAttenuation = ::asf::core::nullable<PDCAttenuationStatus>();
    _audioDeviceStatus = ::asf::core::nullable<AudioDeviceStatusStatus>();
    _overTempReduction = ::asf::core::nullable<OverTempReductionStatus>();
    _overTempAmplifierStatus = ::asf::core::nullable<OverTempAmplifierStatusStatus>();
    _readMeasurementResult = ::asf::core::nullable<ReadMeasurementResultStatus>();
    _center = ::asf::core::nullable<CenterStatus>();
    _subWoofer = ::asf::core::nullable<SubWooferStatus>();
    _externalAmplifierConnectionState = ::asf::core::nullable<ExternalAmplifierConnectionStateStatus>();
    _generalSpeakerTest = ::asf::core::nullable<GeneralSpeakerTestStatus>();
    _aNCSWVersion = ::asf::core::nullable<ANCSWVersionStatus>();
    _aSCSWVersion = ::asf::core::nullable<ASCSWVersionStatus>();
    _aNCASCSetting = ::asf::core::nullable<ANCASCSettingStatus>();
    _ampSoftwareVersion = ::asf::core::nullable<AmpSoftwareVersionStatus>();
    _ampParameterVersion = ::asf::core::nullable<AmpParameterVersionStatus>();
    _ampHardwareVersion = ::asf::core::nullable<AmpHardwareVersionStatus>();
    _surroundVol = ::asf::core::nullable<SurroundVolStatus>();
    _audioPilotMode = ::asf::core::nullable<AudioPilotModeStatus>();
    _surroundMode = ::asf::core::nullable<SurroundModeStatus>();
    _ampDownMixMode = ::asf::core::nullable<AmpDownMixModeStatus>();
    _driverSoundMode = ::asf::core::nullable<DriverSoundModeStatus>();
    _rearSoundMode = ::asf::core::nullable<RearSoundModeStatus>();
    _audioOFFMuteState = ::asf::core::nullable<AudioOFFMuteStateStatus>();
    _microphoneConnectionStatus = ::asf::core::nullable<MicrophoneConnectionStatusStatus>();
    _connection = ::asf::core::nullable<ConnectionStatus>();
    _volumeList = ::asf::core::nullable<VolumeListStatus>();
    _bTAudioInLevel = ::asf::core::nullable<BTAudioInLevelStatus>();
    _engineeringData = ::asf::core::nullable<EngineeringDataStatus>();
    _surroundSetting = ::asf::core::nullable<SurroundSettingStatus>();
    _volumeLock = ::asf::core::nullable<VolumeLockStatus>();
    _ampAvailFunction = ::asf::core::nullable<AmpAvailFunctionStatus>();
    _setAudioProperty = ::asf::core::nullable<SetAudioPropertyStatus>();
    _entOnVolumeSetup = ::asf::core::nullable<EntOnVolumeSetupStatus>();
    _roomEffect = ::asf::core::nullable<RoomEffectStatus>();
    _fMEnhancerMode = ::asf::core::nullable<FMEnhancerModeStatus>();
    _diagDefSetPhase = ::asf::core::nullable<DiagDefSetPhaseStatus>();
    _eSESoundType = ::asf::core::nullable<ESESoundTypeStatus>();
    _eSEVolume = ::asf::core::nullable<ESEVolumeStatus>();
    _rSoundOnOff = ::asf::core::nullable<RSoundOnOffStatus>();
    _rSoundSoundType = ::asf::core::nullable<RSoundSoundTypeStatus>();
    _rSoundVolume = ::asf::core::nullable<RSoundVolumeStatus>();
    _eSEDriveMode = ::asf::core::nullable<ESEDriveModeStatus>();
    _audioMode = ::asf::core::nullable<AudioModeStatus>();
    _aDAS_UPASoundType = ::asf::core::nullable<ADAS_UPASoundTypeStatus>();
    _aDAS_ParkAssistVolume = ::asf::core::nullable<ADAS_ParkAssistVolumeStatus>();
    _aDAS_UPAMute = ::asf::core::nullable<ADAS_UPAMuteStatus>();
    _automaticGainControl = ::asf::core::nullable<AutomaticGainControlStatus>();
    _aDAS_LDW_UserVolume = ::asf::core::nullable<ADAS_LDW_UserVolumeStatus>();
    _rSoundActivation = ::asf::core::nullable<RSoundActivationStatus>();
    _aNCASCActiveTest = ::asf::core::nullable<ANCASCActiveTestStatus>();
    _aNCASCSelfDiagnosticStatus = ::asf::core::nullable<ANCASCSelfDiagnosticStatusStatus>();
    _userProfileChange = ::asf::core::nullable<UserProfileChangeStatus>();
    _sRSoundNotificationState = ::asf::core::nullable<SRSoundNotificationStateStatus>();
    _audioPilotIntensity = ::asf::core::nullable<AudioPilotIntensityStatus>();
    _mainAudioAttenuation = ::asf::core::nullable<MainAudioAttenuationStatus>();
}

void Mascf_main_fiProxy::sendRelUpRegAll()
{
    sendVolumeModeStatusRelUpRegAll();
    sendVolumeRelUpRegAll();
    sendBeepStatusRelUpRegAll();
    sendGalaRelUpRegAll();
    sendBalanceRelUpRegAll();
    sendLoudnessRelUpRegAll();
    sendBassRelUpRegAll();
    sendTrebleRelUpRegAll();
    sendFaderRelUpRegAll();
    sendMidRangeRelUpRegAll();
    sendMemSoundRelUpRegAll();
    sendFaderActivationStatusRelUpRegAll();
    sendDynamicCompressionRelUpRegAll();
    sendOptimizationRelUpRegAll();
    sendEqualiserPresetRelUpRegAll();
    sendDiagAudModeRelUpRegAll();
    sendAuxInLevelRelUpRegAll();
    sendBeepLevelRelUpRegAll();
    sendRear_MuteRelUpRegAll();
    sendGeometry_ModeRelUpRegAll();
    sendLSValueStatusRelUpRegAll();
    sendPDCAttenuationLevelRelUpRegAll();
    sendPDCAttenuationRelUpRegAll();
    sendAudioDeviceStatusRelUpRegAll();
    sendOverTempReductionRelUpRegAll();
    sendOverTempAmplifierStatusRelUpRegAll();
    sendReadMeasurementResultRelUpRegAll();
    sendCenterRelUpRegAll();
    sendSubWooferRelUpRegAll();
    sendExternalAmplifierConnectionStateRelUpRegAll();
    sendGeneralSpeakerTestRelUpRegAll();
    sendANCSWVersionRelUpRegAll();
    sendASCSWVersionRelUpRegAll();
    sendANCASCSettingRelUpRegAll();
    sendAmpSoftwareVersionRelUpRegAll();
    sendAmpParameterVersionRelUpRegAll();
    sendAmpHardwareVersionRelUpRegAll();
    sendSurroundVolRelUpRegAll();
    sendAudioPilotModeRelUpRegAll();
    sendSurroundModeRelUpRegAll();
    sendAmpDownMixModeRelUpRegAll();
    sendDriverSoundModeRelUpRegAll();
    sendRearSoundModeRelUpRegAll();
    sendAudioOFFMuteStateRelUpRegAll();
    sendMicrophoneConnectionStatusRelUpRegAll();
    sendConnectionRelUpRegAll();
    sendVolumeListRelUpRegAll();
    sendBTAudioInLevelRelUpRegAll();
    sendEngineeringDataRelUpRegAll();
    sendSurroundSettingRelUpRegAll();
    sendVolumeLockRelUpRegAll();
    sendAmpAvailFunctionRelUpRegAll();
    sendSetAudioPropertyRelUpRegAll();
    sendEntOnVolumeSetupRelUpRegAll();
    sendRoomEffectRelUpRegAll();
    sendFMEnhancerModeRelUpRegAll();
    sendDiagDefSetPhaseRelUpRegAll();
    sendESESoundTypeRelUpRegAll();
    sendESEVolumeRelUpRegAll();
    sendRSoundOnOffRelUpRegAll();
    sendRSoundSoundTypeRelUpRegAll();
    sendRSoundVolumeRelUpRegAll();
    sendESEDriveModeRelUpRegAll();
    sendAudioModeRelUpRegAll();
    sendADAS_UPASoundTypeRelUpRegAll();
    sendADAS_ParkAssistVolumeRelUpRegAll();
    sendADAS_UPAMuteRelUpRegAll();
    sendAutomaticGainControlRelUpRegAll();
    sendADAS_LDW_UserVolumeRelUpRegAll();
    sendRSoundActivationRelUpRegAll();
    sendANCASCActiveTestRelUpRegAll();
    sendANCASCSelfDiagnosticStatusRelUpRegAll();
    sendUserProfileChangeRelUpRegAll();
    sendSRSoundNotificationStateRelUpRegAll();
    sendAudioPilotIntensityRelUpRegAll();
    sendMainAudioAttenuationRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Mascf_main_fiProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Mascf_main_fiProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace mascf_main_fi
