#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MASCF_MAIN_FI_H
#define MASCF_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "masc_main_fi_types.h"
#include "masc_main_fi_typesConst.h"
#include "mascf_aud_src_route_fi_types.h"
#include "mascf_aud_src_route_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'mascf_main_fi'
 *
 * Fullname: Middleware Audio Service, Application Functional Interface
 *
 * Version: $Revision: 7.1$
 *
 * Author: Rocco Mamone, Amit Acharya, Ruben Volkmer, Amit Tadkod, Karsten Geier, Gerlinde Klotz
 *
 * Date: $Date:20.03.2013$
 *
 * Department:
 *
 * Title: mascf_main_fi
 *
 * <b>Description of 'mascf_main_fi':</b>
 *
 * ..
 */

namespace mascf_main_fi {

static const int SERVICE_ID = 263;

static const int FID_VolumeModeStatus = 3072;

static const int FID_Volume = 3074;

static const int FID_BeepStatus = 3075;

static const int FID_Gala = 3077;

static const int FID_Balance = 3081;

static const int FID_Loudness = 3082;

static const int FID_Bass = 3083;

static const int FID_Treble = 3084;

static const int FID_Fader = 3085;

static const int FID_MidRange = 3103;

static const int FID_MemSound = 3086;

static const int FID_FaderActivationStatus = 3087;

static const int FID_DynamicCompression = 3090;

static const int FID_Optimization = 3092;

static const int FID_EqualiserPreset = 3094;

static const int FID_DiagAudMode = 3096;

static const int FID_AuxInLevel = 3098;

static const int FID_BeepLevel = 3099;

static const int FID_Rear_Mute = 3100;

static const int FID_Geometry_Mode = 804;

static const int FID_LSValueStatus = 3104;

static const int FID_PDCAttenuationLevel = 3102;

static const int FID_PDCAttenuation = 3101;

static const int FID_AudioDeviceStatus = 3105;

static const int FID_OverTempReduction = 3106;

static const int FID_OverTempAmplifierStatus = 3107;

static const int FID_ReadMeasurementResult = 3108;

static const int FID_Center = 3109;

static const int FID_SubWoofer = 3110;

static const int FID_ExternalAmplifierConnectionState = 3114;

static const int FID_GeneralSpeakerTest = 3115;

static const int FID_ANCSWVersion = 3116;

static const int FID_ASCSWVersion = 3117;

static const int FID_ANCASCSetting = 3120;

static const int FID_AmpSoftwareVersion = 3121;

static const int FID_AmpParameterVersion = 3133;

static const int FID_AmpHardwareVersion = 3124;

static const int FID_SurroundVol = 3125;

static const int FID_AudioPilotMode = 3132;

static const int FID_SurroundMode = 3134;

static const int FID_AmpDownMixMode = 3135;

static const int FID_DriverSoundMode = 3136;

static const int FID_RearSoundMode = 3137;

static const int FID_AudioOFFMuteState = 3131;

static const int FID_MicrophoneConnectionStatus = 768;

static const int FID_Connection = 769;

static const int FID_VolumeList = 770;

static const int FID_BTAudioInLevel = 772;

static const int FID_EngineeringData = 774;

static const int FID_SurroundSetting = 776;

static const int FID_VolumeLock = 778;

static const int FID_AmpAvailFunction = 3113;

static const int FID_SetAudioProperty = 780;

static const int FID_EntOnVolumeSetup = 807;

static const int FID_RoomEffect = 782;

static const int FID_FMEnhancerMode = 784;

static const int FID_DiagDefSetPhase = 786;

static const int FID_ESESoundType = 788;

static const int FID_ESEVolume = 790;

static const int FID_RSoundOnOff = 792;

static const int FID_RSoundSoundType = 794;

static const int FID_RSoundVolume = 796;

static const int FID_ESEDriveMode = 798;

static const int FID_AudioMode = 800;

static const int FID_ADAS_UPASoundType = 801;

static const int FID_ADAS_ParkAssistVolume = 802;

static const int FID_ADAS_UPAMute = 803;

static const int FID_AutomaticGainControl = 805;

static const int FID_ADAS_LDW_UserVolume = 806;

static const int FID_RSoundActivation = 808;

static const int FID_ANCASCActiveTest = 3118;

static const int FID_ANCASCSelfDiagnosticStatus = 3119;

static const int FID_UserProfileChange = 3139;

static const int FID_SRSoundNotificationState = 3141;

static const int FID_AudioPilotIntensity = 3143;

static const int FID_MainAudioAttenuation = 3145;

static const int FID_VolumeMode = 3073;

static const int FID_Beep = 3076;

static const int FID_BeepFile = 3123;

static const int FID_Mute = 3328;

static const int FID_Set_Mute_Ramp = 3329;

static const int FID_AudioSource = 3584;

static const int FID_AmpDeviceAudioRoute = 3585;

static const int FID_AudioTestTone = 3122;

static const int FID_CueState = 3126;

static const int FID_PerformOnVolumeLimit = 3127;

static const int FID_SpeakerDiagnosisStart = 3128;

static const int FID_SystemMute = 3129;

static const int FID_ADAS_SettingSound = 3130;

static const int FID_EntertainmentMute = 3138;

static const int FID_MCANBoseAmp_VersionInfo = 3140;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class VolumeModeStatusStatus;

class VolumeStatus;

class VolumeSet;

class BeepStatusStatus;

class GalaStatus;

class GalaSet;

class BalanceStatus;

class BalanceSet;

class LoudnessStatus;

class LoudnessSet;

class BassStatus;

class BassSet;

class TrebleStatus;

class TrebleSet;

class FaderStatus;

class FaderSet;

class MidRangeStatus;

class MidRangeSet;

class MemSoundStatus;

class MemSoundSet;

class FaderActivationStatusStatus;

class DynamicCompressionStatus;

class DynamicCompressionSet;

class OptimizationStatus;

class OptimizationSet;

class EqualiserPresetStatus;

class EqualiserPresetSet;

class DiagAudModeStatus;

class DiagAudModeSet;

class AuxInLevelStatus;

class AuxInLevelSet;

class BeepLevelStatus;

class BeepLevelSet;

class Rear_MuteStatus;

class Rear_MuteSet;

class Geometry_ModeStatus;

class Geometry_ModeSet;

class LSValueStatusStatus;

class PDCAttenuationLevelStatus;

class PDCAttenuationLevelSet;

class PDCAttenuationStatus;

class PDCAttenuationSet;

class AudioDeviceStatusStatus;

class OverTempReductionStatus;

class OverTempReductionSet;

class OverTempAmplifierStatusStatus;

class ReadMeasurementResultStatus;

class CenterStatus;

class CenterSet;

class SubWooferStatus;

class SubWooferSet;

class ExternalAmplifierConnectionStateStatus;

class GeneralSpeakerTestStatus;

class GeneralSpeakerTestSet;

class ANCSWVersionStatus;

class ASCSWVersionStatus;

class ANCASCSettingStatus;

class ANCASCSettingSet;

class AmpSoftwareVersionStatus;

class AmpParameterVersionStatus;

class AmpHardwareVersionStatus;

class SurroundVolStatus;

class SurroundVolSet;

class AudioPilotModeStatus;

class AudioPilotModeSet;

class SurroundModeStatus;

class SurroundModeSet;

class AmpDownMixModeStatus;

class AmpDownMixModeSet;

class DriverSoundModeStatus;

class DriverSoundModeSet;

class RearSoundModeStatus;

class RearSoundModeSet;

class AudioOFFMuteStateStatus;

class AudioOFFMuteStateSet;

class MicrophoneConnectionStatusStatus;

class ConnectionStatus;

class VolumeListStatus;

class VolumeListSet;

class BTAudioInLevelStatus;

class BTAudioInLevelSet;

class EngineeringDataStatus;

class EngineeringDataSet;

class SurroundSettingStatus;

class SurroundSettingSet;

class VolumeLockStatus;

class VolumeLockSet;

class AmpAvailFunctionStatus;

class SetAudioPropertyStatus;

class SetAudioPropertySet;

class EntOnVolumeSetupStatus;

class EntOnVolumeSetupSet;

class RoomEffectStatus;

class RoomEffectSet;

class FMEnhancerModeStatus;

class FMEnhancerModeSet;

class DiagDefSetPhaseStatus;

class ESESoundTypeStatus;

class ESESoundTypeSet;

class ESEVolumeStatus;

class ESEVolumeSet;

class RSoundOnOffStatus;

class RSoundOnOffSet;

class RSoundSoundTypeStatus;

class RSoundSoundTypeSet;

class RSoundVolumeStatus;

class RSoundVolumeSet;

class ESEDriveModeStatus;

class ESEDriveModeSet;

class AudioModeStatus;

class ADAS_UPASoundTypeStatus;

class ADAS_UPASoundTypeSet;

class ADAS_ParkAssistVolumeStatus;

class ADAS_ParkAssistVolumeSet;

class ADAS_UPAMuteStatus;

class ADAS_UPAMuteSet;

class AutomaticGainControlStatus;

class AutomaticGainControlSet;

class ADAS_LDW_UserVolumeStatus;

class ADAS_LDW_UserVolumeSet;

class RSoundActivationStatus;

class RSoundActivationSet;

class ANCASCActiveTestStatus;

class ANCASCActiveTestSet;

class ANCASCSelfDiagnosticStatusStatus;

class UserProfileChangeStatus;

class UserProfileChangeSet;

class SRSoundNotificationStateStatus;

class SRSoundNotificationStateSet;

class AudioPilotIntensityStatus;

class AudioPilotIntensitySet;

class MainAudioAttenuationStatus;

class VolumeModeStart;

class VolumeModeResult;

class BeepStart;

class BeepResult;

class BeepFileStart;

class BeepFileResult;

class MuteStart;

class MuteResult;

class Set_Mute_RampStart;

class Set_Mute_RampResult;

class AudioSourceStart;

class AudioSourceResult;

class AmpDeviceAudioRouteStart;

class AmpDeviceAudioRouteResult;

class AudioTestToneStart;

class AudioTestToneResult;

class CueStateStart;

class CueStateResult;

class SpeakerDiagnosisStartStart;

class SpeakerDiagnosisStartResult;

class SystemMuteStart;

class SystemMuteResult;

class ADAS_SettingSoundStart;

class ADAS_SettingSoundResult;

class EntertainmentMuteStart;

class EntertainmentMuteResult;

// type definitions
/**
 * The get message of the property "VolumeModeStatus"
 * This property gives information about the actual volume mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VolumeModeStatusGet;

/**
 * The upreg message of the property "VolumeModeStatus"
 * This property gives information about the actual volume mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VolumeModeStatusUpReg;

/**
 * The relUpReg message of the property "VolumeModeStatus"
 * This property gives information about the actual volume mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VolumeModeStatusRelUpReg;

/**
 * The error message of 'VolumeModeStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError VolumeModeStatusError;

/**
 * The get message of the property "Volume"
 * status of the actual volume order.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VolumeGet;

/**
 * The upreg message of the property "Volume"
 * status of the actual volume order.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VolumeUpReg;

/**
 * The relUpReg message of the property "Volume"
 * status of the actual volume order.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VolumeRelUpReg;

/**
 * The error message of 'Volume'
 */
typedef ::asf::cca::CcaTypes::DefaultError VolumeError;

/**
 * The upreg message of the property "BeepStatus"
 * Gives the present status of the beep. This status is not related to a special. It just gives the information that a beep is running.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BeepStatusUpReg;

/**
 * The relUpReg message of the property "BeepStatus"
 * Gives the present status of the beep. This status is not related to a special. It just gives the information that a beep is running.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BeepStatusRelUpReg;

/**
 * The error message of 'BeepStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError BeepStatusError;

/**
 * The get message of the property "Gala"
 * status of actual gala order.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GalaGet;

/**
 * The upreg message of the property "Gala"
 * status of actual gala order.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GalaUpReg;

/**
 * The relUpReg message of the property "Gala"
 * status of actual gala order.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GalaRelUpReg;

/**
 * The error message of 'Gala'
 */
typedef ::asf::cca::CcaTypes::DefaultError GalaError;

/**
 * The get message of the property "Balance"
 * status of actual balance value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BalanceGet;

/**
 * The upreg message of the property "Balance"
 * status of actual balance value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BalanceUpReg;

/**
 * The relUpReg message of the property "Balance"
 * status of actual balance value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BalanceRelUpReg;

/**
 * The error message of 'Balance'
 */
typedef ::asf::cca::CcaTypes::DefaultError BalanceError;

/**
 * The get message of the property "Loudness"
 * status of actual loudness value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LoudnessGet;

/**
 * The upreg message of the property "Loudness"
 * status of actual loudness value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LoudnessUpReg;

/**
 * The relUpReg message of the property "Loudness"
 * status of actual loudness value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LoudnessRelUpReg;

/**
 * The error message of 'Loudness'
 */
typedef ::asf::cca::CcaTypes::DefaultError LoudnessError;

/**
 * The get message of the property "Bass"
 * status of actual bass value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BassGet;

/**
 * The upreg message of the property "Bass"
 * status of actual bass value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BassUpReg;

/**
 * The relUpReg message of the property "Bass"
 * status of actual bass value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BassRelUpReg;

/**
 * The error message of 'Bass'
 */
typedef ::asf::cca::CcaTypes::DefaultError BassError;

/**
 * The get message of the property "Treble"
 * status of actual treble value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TrebleGet;

/**
 * The upreg message of the property "Treble"
 * status of actual treble value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TrebleUpReg;

/**
 * The relUpReg message of the property "Treble"
 * status of actual treble value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TrebleRelUpReg;

/**
 * The error message of 'Treble'
 */
typedef ::asf::cca::CcaTypes::DefaultError TrebleError;

/**
 * The get message of the property "Fader"
 * status of actual fader value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FaderGet;

/**
 * The upreg message of the property "Fader"
 * status of actual fader value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FaderUpReg;

/**
 * The relUpReg message of the property "Fader"
 * status of actual fader value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FaderRelUpReg;

/**
 * The error message of 'Fader'
 */
typedef ::asf::cca::CcaTypes::DefaultError FaderError;

/**
 * The get message of the property "MidRange"
 * status of actual MidRange value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MidRangeGet;

/**
 * The upreg message of the property "MidRange"
 * status of actual MidRange value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MidRangeUpReg;

/**
 * The relUpReg message of the property "MidRange"
 * status of actual MidRange value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MidRangeRelUpReg;

/**
 * The error message of 'MidRange'
 */
typedef ::asf::cca::CcaTypes::DefaultError MidRangeError;

/**
 * The upreg message of the property "MemSound"
 * status of last sound stored.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MemSoundUpReg;

/**
 * The relUpReg message of the property "MemSound"
 * status of last sound stored.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MemSoundRelUpReg;

/**
 * The error message of 'MemSound'
 */
typedef ::asf::cca::CcaTypes::DefaultError MemSoundError;

/**
 * The get message of the property "FaderActivationStatus"
 * active/deactive status of fader.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FaderActivationStatusGet;

/**
 * The upreg message of the property "FaderActivationStatus"
 * active/deactive status of fader.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FaderActivationStatusUpReg;

/**
 * The relUpReg message of the property "FaderActivationStatus"
 * active/deactive status of fader.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FaderActivationStatusRelUpReg;

/**
 * The error message of 'FaderActivationStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError FaderActivationStatusError;

/**
 * The get message of the property "DynamicCompression"
 * status of changed dynamic compression value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DynamicCompressionGet;

/**
 * The upreg message of the property "DynamicCompression"
 * status of changed dynamic compression value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DynamicCompressionUpReg;

/**
 * The relUpReg message of the property "DynamicCompression"
 * status of changed dynamic compression value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DynamicCompressionRelUpReg;

/**
 * The error message of 'DynamicCompression'
 */
typedef ::asf::cca::CcaTypes::DefaultError DynamicCompressionError;

/**
 * The get message of the property "Optimization"
 * status of changed optimization value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage OptimizationGet;

/**
 * The upreg message of the property "Optimization"
 * status of changed optimization value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage OptimizationUpReg;

/**
 * The relUpReg message of the property "Optimization"
 * status of changed optimization value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage OptimizationRelUpReg;

/**
 * The error message of 'Optimization'
 */
typedef ::asf::cca::CcaTypes::DefaultError OptimizationError;

/**
 * The get message of the property "EqualiserPreset"
 * status of changed equaliser preset.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EqualiserPresetGet;

/**
 * The upreg message of the property "EqualiserPreset"
 * status of changed equaliser preset.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EqualiserPresetUpReg;

/**
 * The relUpReg message of the property "EqualiserPreset"
 * status of changed equaliser preset.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EqualiserPresetRelUpReg;

/**
 * The error message of 'EqualiserPreset'
 */
typedef ::asf::cca::CcaTypes::DefaultError EqualiserPresetError;

/**
 * The get message of the property "DiagAudMode"
 * status of changed audio mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiagAudModeGet;

/**
 * The upreg message of the property "DiagAudMode"
 * status of changed audio mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiagAudModeUpReg;

/**
 * The relUpReg message of the property "DiagAudMode"
 * status of changed audio mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiagAudModeRelUpReg;

/**
 * The error message of 'DiagAudMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiagAudModeError;

/**
 * The get message of the property "AuxInLevel"
 * status of changed audio mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AuxInLevelGet;

/**
 * The upreg message of the property "AuxInLevel"
 * status of changed audio mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AuxInLevelUpReg;

/**
 * The relUpReg message of the property "AuxInLevel"
 * status of changed audio mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AuxInLevelRelUpReg;

/**
 * The error message of 'AuxInLevel'
 */
typedef ::asf::cca::CcaTypes::DefaultError AuxInLevelError;

/**
 * The get message of the property "BeepLevel"
 * Beep Level can be set in FC_AudioManager through this interface.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BeepLevelGet;

/**
 * The upreg message of the property "BeepLevel"
 * Beep Level can be set in FC_AudioManager through this interface.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BeepLevelUpReg;

/**
 * The relUpReg message of the property "BeepLevel"
 * Beep Level can be set in FC_AudioManager through this interface.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BeepLevelRelUpReg;

/**
 * The error message of 'BeepLevel'
 */
typedef ::asf::cca::CcaTypes::DefaultError BeepLevelError;

/**
 * The get message of the property "Rear_Mute"
 * RearMute Level can be set in FC_AudioManager through this interface.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Rear_MuteGet;

/**
 * The upreg message of the property "Rear_Mute"
 * RearMute Level can be set in FC_AudioManager through this interface.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Rear_MuteUpReg;

/**
 * The relUpReg message of the property "Rear_Mute"
 * RearMute Level can be set in FC_AudioManager through this interface.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Rear_MuteRelUpReg;

/**
 * The error message of 'Rear_Mute'
 */
typedef ::asf::cca::CcaTypes::DefaultError Rear_MuteError;

/**
 * The get message of the property "Geometry_Mode"
 * Geometry mode is set in FC_AudioManager through this interface.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Geometry_ModeGet;

/**
 * The upreg message of the property "Geometry_Mode"
 * Geometry mode is set in FC_AudioManager through this interface.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Geometry_ModeUpReg;

/**
 * The relUpReg message of the property "Geometry_Mode"
 * Geometry mode is set in FC_AudioManager through this interface.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Geometry_ModeRelUpReg;

/**
 * The error message of 'Geometry_Mode'
 */
typedef ::asf::cca::CcaTypes::DefaultError Geometry_ModeError;

/**
 * The get message of the property "LSValueStatus"
 * With this message, the present values of the audio management are transfered to the client software (mostly HMI).
 * Is is mainly used for to sysnchronize the client on startup, and in situations where serveral values can change spontanously.
 * This is the case at source change, where e.g. volume and toncontroler values might change.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LSValueStatusGet;

/**
 * The upreg message of the property "LSValueStatus"
 * With this message, the present values of the audio management are transfered to the client software (mostly HMI).
 * Is is mainly used for to sysnchronize the client on startup, and in situations where serveral values can change spontanously.
 * This is the case at source change, where e.g. volume and toncontroler values might change.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LSValueStatusUpReg;

/**
 * The relUpReg message of the property "LSValueStatus"
 * With this message, the present values of the audio management are transfered to the client software (mostly HMI).
 * Is is mainly used for to sysnchronize the client on startup, and in situations where serveral values can change spontanously.
 * This is the case at source change, where e.g. volume and toncontroler values might change.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LSValueStatusRelUpReg;

/**
 * The error message of 'LSValueStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError LSValueStatusError;

/**
 * The get message of the property "PDCAttenuationLevel"
 * ONLY AVAILABLE IN VW-LL-TFT.  Status of changed audio mode GenericFI FunctionID
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PDCAttenuationLevelGet;

/**
 * The upreg message of the property "PDCAttenuationLevel"
 * ONLY AVAILABLE IN VW-LL-TFT.  Status of changed audio mode GenericFI FunctionID
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PDCAttenuationLevelUpReg;

/**
 * The relUpReg message of the property "PDCAttenuationLevel"
 * ONLY AVAILABLE IN VW-LL-TFT.  Status of changed audio mode GenericFI FunctionID
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PDCAttenuationLevelRelUpReg;

/**
 * The error message of 'PDCAttenuationLevel'
 */
typedef ::asf::cca::CcaTypes::DefaultError PDCAttenuationLevelError;

/**
 * The get message of the property "PDCAttenuation"
 * ONLY AVAILABLE IN VW-LL-TFT. Status of ongoing PDCAttenuation.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PDCAttenuationGet;

/**
 * The upreg message of the property "PDCAttenuation"
 * ONLY AVAILABLE IN VW-LL-TFT. Status of ongoing PDCAttenuation.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PDCAttenuationUpReg;

/**
 * The relUpReg message of the property "PDCAttenuation"
 * ONLY AVAILABLE IN VW-LL-TFT. Status of ongoing PDCAttenuation.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PDCAttenuationRelUpReg;

/**
 * The error message of 'PDCAttenuation'
 */
typedef ::asf::cca::CcaTypes::DefaultError PDCAttenuationError;

/**
 * The get message of the property "AudioDeviceStatus"
 * Gives Status of AudioDevice Availability.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioDeviceStatusGet;

/**
 * The upreg message of the property "AudioDeviceStatus"
 * Gives Status of AudioDevice Availability.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioDeviceStatusUpReg;

/**
 * The relUpReg message of the property "AudioDeviceStatus"
 * Gives Status of AudioDevice Availability.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioDeviceStatusRelUpReg;

/**
 * The error message of 'AudioDeviceStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError AudioDeviceStatusError;

/**
 * The get message of the property "OverTempReduction"
 * <p>Audio Volume downscaling for use in over-temperature situations.</p>
 * Note: Audible volume will be lower than reported in VolumeStatus
 */
typedef ::asf::cca::CcaTypes::DefaultMessage OverTempReductionGet;

/**
 * The upreg message of the property "OverTempReduction"
 * <p>Audio Volume downscaling for use in over-temperature situations.</p>
 * Note: Audible volume will be lower than reported in VolumeStatus
 */
typedef ::asf::cca::CcaTypes::DefaultMessage OverTempReductionUpReg;

/**
 * The relUpReg message of the property "OverTempReduction"
 * <p>Audio Volume downscaling for use in over-temperature situations.</p>
 * Note: Audible volume will be lower than reported in VolumeStatus
 */
typedef ::asf::cca::CcaTypes::DefaultMessage OverTempReductionRelUpReg;

/**
 * The error message of 'OverTempReduction'
 */
typedef ::asf::cca::CcaTypes::DefaultError OverTempReductionError;

/**
 * The get message of the property "OverTempAmplifierStatus"
 * Status of Amplifier Temperature level.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage OverTempAmplifierStatusGet;

/**
 * The upreg message of the property "OverTempAmplifierStatus"
 * Status of Amplifier Temperature level.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage OverTempAmplifierStatusUpReg;

/**
 * The relUpReg message of the property "OverTempAmplifierStatus"
 * Status of Amplifier Temperature level.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage OverTempAmplifierStatusRelUpReg;

/**
 * The error message of 'OverTempAmplifierStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError OverTempAmplifierStatusError;

/**
 * The get message of the property "ReadMeasurementResult"
 * Status of Amplifier loudspeaker diagnosis result that was triggered by method SpeakerDiagnosisStart.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ReadMeasurementResultGet;

/**
 * The upreg message of the property "ReadMeasurementResult"
 * Status of Amplifier loudspeaker diagnosis result that was triggered by method SpeakerDiagnosisStart.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ReadMeasurementResultUpReg;

/**
 * The relUpReg message of the property "ReadMeasurementResult"
 * Status of Amplifier loudspeaker diagnosis result that was triggered by method SpeakerDiagnosisStart.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ReadMeasurementResultRelUpReg;

/**
 * The error message of 'ReadMeasurementResult'
 */
typedef ::asf::cca::CcaTypes::DefaultError ReadMeasurementResultError;

/**
 * The get message of the property "Center"
 * status of actual Center value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CenterGet;

/**
 * The upreg message of the property "Center"
 * status of actual Center value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CenterUpReg;

/**
 * The relUpReg message of the property "Center"
 * status of actual Center value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CenterRelUpReg;

/**
 * The error message of 'Center'
 */
typedef ::asf::cca::CcaTypes::DefaultError CenterError;

/**
 * The get message of the property "SubWoofer"
 * status of actual SubWoofer value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SubWooferGet;

/**
 * The upreg message of the property "SubWoofer"
 * status of actual SubWoofer value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SubWooferUpReg;

/**
 * The relUpReg message of the property "SubWoofer"
 * status of actual SubWoofer value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SubWooferRelUpReg;

/**
 * The error message of 'SubWoofer'
 */
typedef ::asf::cca::CcaTypes::DefaultError SubWooferError;

/**
 * The get message of the property "ExternalAmplifierConnectionState"
 * status of Bose MCAN-amplifier connection state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ExternalAmplifierConnectionStateGet;

/**
 * The upreg message of the property "ExternalAmplifierConnectionState"
 * status of Bose MCAN-amplifier connection state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ExternalAmplifierConnectionStateUpReg;

/**
 * The relUpReg message of the property "ExternalAmplifierConnectionState"
 * status of Bose MCAN-amplifier connection state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ExternalAmplifierConnectionStateRelUpReg;

/**
 * The error message of 'ExternalAmplifierConnectionState'
 */
typedef ::asf::cca::CcaTypes::DefaultError ExternalAmplifierConnectionStateError;

/**
 * The get message of the property "GeneralSpeakerTest"
 * Set the request(start, stop and next)for speaker test. And the status of speaker test.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GeneralSpeakerTestGet;

/**
 * The upreg message of the property "GeneralSpeakerTest"
 * Set the request(start, stop and next)for speaker test. And the status of speaker test.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GeneralSpeakerTestUpReg;

/**
 * The relUpReg message of the property "GeneralSpeakerTest"
 * Set the request(start, stop and next)for speaker test. And the status of speaker test.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GeneralSpeakerTestRelUpReg;

/**
 * The error message of 'GeneralSpeakerTest'
 */
typedef ::asf::cca::CcaTypes::DefaultError GeneralSpeakerTestError;

/**
 * The get message of the property "ANCSWVersion"
 * Updates ANC Software Version
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ANCSWVersionGet;

/**
 * The upreg message of the property "ANCSWVersion"
 * Updates ANC Software Version
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ANCSWVersionUpReg;

/**
 * The relUpReg message of the property "ANCSWVersion"
 * Updates ANC Software Version
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ANCSWVersionRelUpReg;

/**
 * The error message of 'ANCSWVersion'
 */
typedef ::asf::cca::CcaTypes::DefaultError ANCSWVersionError;

/**
 * The get message of the property "ASCSWVersion"
 * Updates ASC Software Version
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ASCSWVersionGet;

/**
 * The upreg message of the property "ASCSWVersion"
 * Updates ASC Software Version
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ASCSWVersionUpReg;

/**
 * The relUpReg message of the property "ASCSWVersion"
 * Updates ASC Software Version
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ASCSWVersionRelUpReg;

/**
 * The error message of 'ASCSWVersion'
 */
typedef ::asf::cca::CcaTypes::DefaultError ASCSWVersionError;

/**
 * The get message of the property "ANCASCSetting"
 * User setting of ANC ASC
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ANCASCSettingGet;

/**
 * The upreg message of the property "ANCASCSetting"
 * User setting of ANC ASC
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ANCASCSettingUpReg;

/**
 * The relUpReg message of the property "ANCASCSetting"
 * User setting of ANC ASC
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ANCASCSettingRelUpReg;

/**
 * The error message of 'ANCASCSetting'
 */
typedef ::asf::cca::CcaTypes::DefaultError ANCASCSettingError;

/**
 * The get message of the property "AmpSoftwareVersion"
 * Updates Amplifier Software Version
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AmpSoftwareVersionGet;

/**
 * The upreg message of the property "AmpSoftwareVersion"
 * Updates Amplifier Software Version
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AmpSoftwareVersionUpReg;

/**
 * The relUpReg message of the property "AmpSoftwareVersion"
 * Updates Amplifier Software Version
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AmpSoftwareVersionRelUpReg;

/**
 * The error message of 'AmpSoftwareVersion'
 */
typedef ::asf::cca::CcaTypes::DefaultError AmpSoftwareVersionError;

/**
 * The get message of the property "AmpParameterVersion"
 * Updates Amplifier Parameter Version
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AmpParameterVersionGet;

/**
 * The upreg message of the property "AmpParameterVersion"
 * Updates Amplifier Parameter Version
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AmpParameterVersionUpReg;

/**
 * The relUpReg message of the property "AmpParameterVersion"
 * Updates Amplifier Parameter Version
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AmpParameterVersionRelUpReg;

/**
 * The error message of 'AmpParameterVersion'
 */
typedef ::asf::cca::CcaTypes::DefaultError AmpParameterVersionError;

/**
 * The get message of the property "AmpHardwareVersion"
 * Updates Amplifier Hardware Version
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AmpHardwareVersionGet;

/**
 * The upreg message of the property "AmpHardwareVersion"
 * Updates Amplifier Hardware Version
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AmpHardwareVersionUpReg;

/**
 * The relUpReg message of the property "AmpHardwareVersion"
 * Updates Amplifier Hardware Version
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AmpHardwareVersionRelUpReg;

/**
 * The error message of 'AmpHardwareVersion'
 */
typedef ::asf::cca::CcaTypes::DefaultError AmpHardwareVersionError;

/**
 * The get message of the property "SurroundVol"
 * status of actual surround volume value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SurroundVolGet;

/**
 * The upreg message of the property "SurroundVol"
 * status of actual surround volume value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SurroundVolUpReg;

/**
 * The relUpReg message of the property "SurroundVol"
 * status of actual surround volume value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SurroundVolRelUpReg;

/**
 * The error message of 'SurroundVol'
 */
typedef ::asf::cca::CcaTypes::DefaultError SurroundVolError;

/**
 * The get message of the property "AudioPilotMode"
 * status of actual audio pilot mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioPilotModeGet;

/**
 * The upreg message of the property "AudioPilotMode"
 * status of actual audio pilot mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioPilotModeUpReg;

/**
 * The relUpReg message of the property "AudioPilotMode"
 * status of actual audio pilot mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioPilotModeRelUpReg;

/**
 * The error message of 'AudioPilotMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError AudioPilotModeError;

/**
 * The get message of the property "SurroundMode"
 * status of surround mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SurroundModeGet;

/**
 * The upreg message of the property "SurroundMode"
 * status of surround mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SurroundModeUpReg;

/**
 * The relUpReg message of the property "SurroundMode"
 * status of surround mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SurroundModeRelUpReg;

/**
 * The error message of 'SurroundMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError SurroundModeError;

/**
 * The get message of the property "AmpDownMixMode"
 * status of amplifier down mix mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AmpDownMixModeGet;

/**
 * The upreg message of the property "AmpDownMixMode"
 * status of amplifier down mix mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AmpDownMixModeUpReg;

/**
 * The relUpReg message of the property "AmpDownMixMode"
 * status of amplifier down mix mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AmpDownMixModeRelUpReg;

/**
 * The error message of 'AmpDownMixMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError AmpDownMixModeError;

/**
 * The get message of the property "DriverSoundMode"
 * status of driver sound mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DriverSoundModeGet;

/**
 * The upreg message of the property "DriverSoundMode"
 * status of driver sound mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DriverSoundModeUpReg;

/**
 * The relUpReg message of the property "DriverSoundMode"
 * status of driver sound mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DriverSoundModeRelUpReg;

/**
 * The error message of 'DriverSoundMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError DriverSoundModeError;

/**
 * The get message of the property "RearSoundMode"
 * status of driver sound mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RearSoundModeGet;

/**
 * The upreg message of the property "RearSoundMode"
 * status of driver sound mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RearSoundModeUpReg;

/**
 * The relUpReg message of the property "RearSoundMode"
 * status of driver sound mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RearSoundModeRelUpReg;

/**
 * The error message of 'RearSoundMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError RearSoundModeError;

/**
 * The upreg message of the property "AudioOFFMuteState"
 * This property will not used to activate a mute. It is only used to give the status of AUDIO OFF Mute in the audio-stack to fc_audiomanager
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioOFFMuteStateUpReg;

/**
 * The relUpReg message of the property "AudioOFFMuteState"
 * This property will not used to activate a mute. It is only used to give the status of AUDIO OFF Mute in the audio-stack to fc_audiomanager
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioOFFMuteStateRelUpReg;

/**
 * The error message of 'AudioOFFMuteState'
 */
typedef ::asf::cca::CcaTypes::DefaultError AudioOFFMuteStateError;

/**
 * The get message of the property "MicrophoneConnectionStatus"
 * Status of microphone connection.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MicrophoneConnectionStatusGet;

/**
 * The upreg message of the property "MicrophoneConnectionStatus"
 * Status of microphone connection.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MicrophoneConnectionStatusUpReg;

/**
 * The relUpReg message of the property "MicrophoneConnectionStatus"
 * Status of microphone connection.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MicrophoneConnectionStatusRelUpReg;

/**
 * The error message of 'MicrophoneConnectionStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError MicrophoneConnectionStatusError;

/**
 * The get message of the property "Connection"
 * This property gives information about the connection status to the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConnectionGet;

/**
 * The upreg message of the property "Connection"
 * This property gives information about the connection status to the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConnectionUpReg;

/**
 * The relUpReg message of the property "Connection"
 * This property gives information about the connection status to the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConnectionRelUpReg;

/**
 * The error message of 'Connection'
 */
typedef ::asf::cca::CcaTypes::DefaultError ConnectionError;

/**
 * The get message of the property "VolumeList"
 * Status of volume of various AudVolumeTypes.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VolumeListGet;

/**
 * The upreg message of the property "VolumeList"
 * Status of volume of various AudVolumeTypes.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VolumeListUpReg;

/**
 * The relUpReg message of the property "VolumeList"
 * Status of volume of various AudVolumeTypes.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VolumeListRelUpReg;

/**
 * The error message of 'VolumeList'
 */
typedef ::asf::cca::CcaTypes::DefaultError VolumeListError;

/**
 * The get message of the property "BTAudioInLevel"
 * status of changed BT audio input level.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BTAudioInLevelGet;

/**
 * The upreg message of the property "BTAudioInLevel"
 * status of changed BT audio input level.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BTAudioInLevelUpReg;

/**
 * The relUpReg message of the property "BTAudioInLevel"
 * status of changed BT audio input level.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BTAudioInLevelRelUpReg;

/**
 * The error message of 'BTAudioInLevel'
 */
typedef ::asf::cca::CcaTypes::DefaultError BTAudioInLevelError;

/**
 * The get message of the property "EngineeringData"
 * Status of Engineering Data of various AudEDTypes.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EngineeringDataGet;

/**
 * The upreg message of the property "EngineeringData"
 * Status of Engineering Data of various AudEDTypes.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EngineeringDataUpReg;

/**
 * The relUpReg message of the property "EngineeringData"
 * Status of Engineering Data of various AudEDTypes.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EngineeringDataRelUpReg;

/**
 * The error message of 'EngineeringData'
 */
typedef ::asf::cca::CcaTypes::DefaultError EngineeringDataError;

/**
 * The get message of the property "SurroundSetting"
 * Property for setting the Surround value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SurroundSettingGet;

/**
 * The upreg message of the property "SurroundSetting"
 * Property for setting the Surround value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SurroundSettingUpReg;

/**
 * The relUpReg message of the property "SurroundSetting"
 * Property for setting the Surround value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SurroundSettingRelUpReg;

/**
 * The error message of 'SurroundSetting'
 */
typedef ::asf::cca::CcaTypes::DefaultError SurroundSettingError;

/**
 * The get message of the property "VolumeLock"
 * Property for setting the Volume Lock.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VolumeLockGet;

/**
 * The upreg message of the property "VolumeLock"
 * Property for setting the Volume Lock.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VolumeLockUpReg;

/**
 * The relUpReg message of the property "VolumeLock"
 * Property for setting the Volume Lock.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VolumeLockRelUpReg;

/**
 * The error message of 'VolumeLock'
 */
typedef ::asf::cca::CcaTypes::DefaultError VolumeLockError;

/**
 * The get message of the property "AmpAvailFunction"
 * status of Ampliifier available function.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AmpAvailFunctionGet;

/**
 * The upreg message of the property "AmpAvailFunction"
 * status of Ampliifier available function.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AmpAvailFunctionUpReg;

/**
 * The relUpReg message of the property "AmpAvailFunction"
 * status of Ampliifier available function.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AmpAvailFunctionRelUpReg;

/**
 * The error message of 'AmpAvailFunction'
 */
typedef ::asf::cca::CcaTypes::DefaultError AmpAvailFunctionError;

/**
 * The get message of the property "SetAudioProperty"
 * With this interface a source-component set the Audio Property(InputGain and Volume Lock) of an audio source.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetAudioPropertyGet;

/**
 * The upreg message of the property "SetAudioProperty"
 * With this interface a source-component set the Audio Property(InputGain and Volume Lock) of an audio source.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetAudioPropertyUpReg;

/**
 * The relUpReg message of the property "SetAudioProperty"
 * With this interface a source-component set the Audio Property(InputGain and Volume Lock) of an audio source.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetAudioPropertyRelUpReg;

/**
 * The error message of 'SetAudioProperty'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetAudioPropertyError;

/**
 * The upreg message of the property "EntOnVolumeSetup"
 * Property for setting the on volume to entertainment source
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EntOnVolumeSetupUpReg;

/**
 * The relUpReg message of the property "EntOnVolumeSetup"
 * Property for setting the on volume to entertainment source
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EntOnVolumeSetupRelUpReg;

/**
 * The error message of 'EntOnVolumeSetup'
 */
typedef ::asf::cca::CcaTypes::DefaultError EntOnVolumeSetupError;

/**
 * The get message of the property "RoomEffect"
 * status of changed Sound Room Effect.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RoomEffectGet;

/**
 * The upreg message of the property "RoomEffect"
 * status of changed Sound Room Effect.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RoomEffectUpReg;

/**
 * The relUpReg message of the property "RoomEffect"
 * status of changed Sound Room Effect.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RoomEffectRelUpReg;

/**
 * The error message of 'RoomEffect'
 */
typedef ::asf::cca::CcaTypes::DefaultError RoomEffectError;

/**
 * The get message of the property "FMEnhancerMode"
 * status of FM Enhancer mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FMEnhancerModeGet;

/**
 * The upreg message of the property "FMEnhancerMode"
 * status of FM Enhancer mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FMEnhancerModeUpReg;

/**
 * The relUpReg message of the property "FMEnhancerMode"
 * status of FM Enhancer mode.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FMEnhancerModeRelUpReg;

/**
 * The error message of 'FMEnhancerMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError FMEnhancerModeError;

/**
 * The get message of the property "DiagDefSetPhase"
 * status of Diagnosis DefSet Phase.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiagDefSetPhaseGet;

/**
 * The upreg message of the property "DiagDefSetPhase"
 * status of Diagnosis DefSet Phase.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiagDefSetPhaseUpReg;

/**
 * The relUpReg message of the property "DiagDefSetPhase"
 * status of Diagnosis DefSet Phase.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DiagDefSetPhaseRelUpReg;

/**
 * The error message of 'DiagDefSetPhase'
 */
typedef ::asf::cca::CcaTypes::DefaultError DiagDefSetPhaseError;

/**
 * The get message of the property "ESESoundType"
 * Property for setting the ESE Sound type value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ESESoundTypeGet;

/**
 * The upreg message of the property "ESESoundType"
 * Property for setting the ESE Sound type value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ESESoundTypeUpReg;

/**
 * The relUpReg message of the property "ESESoundType"
 * Property for setting the ESE Sound type value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ESESoundTypeRelUpReg;

/**
 * The error message of 'ESESoundType'
 */
typedef ::asf::cca::CcaTypes::DefaultError ESESoundTypeError;

/**
 * The get message of the property "ESEVolume"
 * Property for setting the ESE volume value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ESEVolumeGet;

/**
 * The upreg message of the property "ESEVolume"
 * Property for setting the ESE volume value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ESEVolumeUpReg;

/**
 * The relUpReg message of the property "ESEVolume"
 * Property for setting the ESE volume value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ESEVolumeRelUpReg;

/**
 * The error message of 'ESEVolume'
 */
typedef ::asf::cca::CcaTypes::DefaultError ESEVolumeError;

/**
 * The get message of the property "RSoundOnOff"
 * Property for setting the RSound Activation value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RSoundOnOffGet;

/**
 * The upreg message of the property "RSoundOnOff"
 * Property for setting the RSound Activation value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RSoundOnOffUpReg;

/**
 * The relUpReg message of the property "RSoundOnOff"
 * Property for setting the RSound Activation value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RSoundOnOffRelUpReg;

/**
 * The error message of 'RSoundOnOff'
 */
typedef ::asf::cca::CcaTypes::DefaultError RSoundOnOffError;

/**
 * The get message of the property "RSoundSoundType"
 * Property for setting the RSound Sound type value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RSoundSoundTypeGet;

/**
 * The upreg message of the property "RSoundSoundType"
 * Property for setting the RSound Sound type value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RSoundSoundTypeUpReg;

/**
 * The relUpReg message of the property "RSoundSoundType"
 * Property for setting the RSound Sound type value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RSoundSoundTypeRelUpReg;

/**
 * The error message of 'RSoundSoundType'
 */
typedef ::asf::cca::CcaTypes::DefaultError RSoundSoundTypeError;

/**
 * The get message of the property "RSoundVolume"
 * Property for setting the RSound volume value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RSoundVolumeGet;

/**
 * The upreg message of the property "RSoundVolume"
 * Property for setting the RSound volume value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RSoundVolumeUpReg;

/**
 * The relUpReg message of the property "RSoundVolume"
 * Property for setting the RSound volume value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RSoundVolumeRelUpReg;

/**
 * The error message of 'RSoundVolume'
 */
typedef ::asf::cca::CcaTypes::DefaultError RSoundVolumeError;

/**
 * The get message of the property "ESEDriveMode"
 * Property for setting the ESE Driving mode value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ESEDriveModeGet;

/**
 * The upreg message of the property "ESEDriveMode"
 * Property for setting the ESE Driving mode value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ESEDriveModeUpReg;

/**
 * The relUpReg message of the property "ESEDriveMode"
 * Property for setting the ESE Driving mode value.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ESEDriveModeRelUpReg;

/**
 * The error message of 'ESEDriveMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError ESEDriveModeError;

/**
 * The get message of the property "AudioMode"
 * Property for setting the audio mode in HMI based on Arkamys Library.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioModeGet;

/**
 * The upreg message of the property "AudioMode"
 * Property for setting the audio mode in HMI based on Arkamys Library.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioModeUpReg;

/**
 * The relUpReg message of the property "AudioMode"
 * Property for setting the audio mode in HMI based on Arkamys Library.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioModeRelUpReg;

/**
 * The error message of 'AudioMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError AudioModeError;

/**
 * The get message of the property "ADAS_UPASoundType"
 * Property for setting Sound file type to be used to play UPA sounds
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ADAS_UPASoundTypeGet;

/**
 * The upreg message of the property "ADAS_UPASoundType"
 * Property for setting Sound file type to be used to play UPA sounds
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ADAS_UPASoundTypeUpReg;

/**
 * The relUpReg message of the property "ADAS_UPASoundType"
 * Property for setting Sound file type to be used to play UPA sounds
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ADAS_UPASoundTypeRelUpReg;

/**
 * The error message of 'ADAS_UPASoundType'
 */
typedef ::asf::cca::CcaTypes::DefaultError ADAS_UPASoundTypeError;

/**
 * The get message of the property "ADAS_ParkAssistVolume"
 * Property for setting the volume to be used for Park Assist BeepS (ADAS Sounds) except LDW.
 * For LDW use the property ADAS_LDW_UserVolume
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ADAS_ParkAssistVolumeGet;

/**
 * The upreg message of the property "ADAS_ParkAssistVolume"
 * Property for setting the volume to be used for Park Assist BeepS (ADAS Sounds) except LDW.
 * For LDW use the property ADAS_LDW_UserVolume
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ADAS_ParkAssistVolumeUpReg;

/**
 * The relUpReg message of the property "ADAS_ParkAssistVolume"
 * Property for setting the volume to be used for Park Assist BeepS (ADAS Sounds) except LDW.
 * For LDW use the property ADAS_LDW_UserVolume
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ADAS_ParkAssistVolumeRelUpReg;

/**
 * The error message of 'ADAS_ParkAssistVolume'
 */
typedef ::asf::cca::CcaTypes::DefaultError ADAS_ParkAssistVolumeError;

/**
 * The get message of the property "ADAS_UPAMute"
 * Property for setting the Mute status of UPA Beeps
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ADAS_UPAMuteGet;

/**
 * The upreg message of the property "ADAS_UPAMute"
 * Property for setting the Mute status of UPA Beeps
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ADAS_UPAMuteUpReg;

/**
 * The relUpReg message of the property "ADAS_UPAMute"
 * Property for setting the Mute status of UPA Beeps
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ADAS_UPAMuteRelUpReg;

/**
 * The error message of 'ADAS_UPAMute'
 */
typedef ::asf::cca::CcaTypes::DefaultError ADAS_UPAMuteError;

/**
 * The get message of the property "AutomaticGainControl"
 * Property for setting the automatic gain control in HMI based on Arkamys Library.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutomaticGainControlGet;

/**
 * The upreg message of the property "AutomaticGainControl"
 * Property for setting the automatic gain control in HMI based on Arkamys Library.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutomaticGainControlUpReg;

/**
 * The relUpReg message of the property "AutomaticGainControl"
 * Property for setting the automatic gain control in HMI based on Arkamys Library.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AutomaticGainControlRelUpReg;

/**
 * The error message of 'AutomaticGainControl'
 */
typedef ::asf::cca::CcaTypes::DefaultError AutomaticGainControlError;

/**
 * The get message of the property "ADAS_LDW_UserVolume"
 * Property for setting the user volume for LDW or LKA
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ADAS_LDW_UserVolumeGet;

/**
 * The upreg message of the property "ADAS_LDW_UserVolume"
 * Property for setting the user volume for LDW or LKA
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ADAS_LDW_UserVolumeUpReg;

/**
 * The relUpReg message of the property "ADAS_LDW_UserVolume"
 * Property for setting the user volume for LDW or LKA
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ADAS_LDW_UserVolumeRelUpReg;

/**
 * The error message of 'ADAS_LDW_UserVolume'
 */
typedef ::asf::cca::CcaTypes::DefaultError ADAS_LDW_UserVolumeError;

/**
 * The get message of the property "RSoundActivation"
 * Property for activation/deactivation of RSOUND
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RSoundActivationGet;

/**
 * The upreg message of the property "RSoundActivation"
 * Property for activation/deactivation of RSOUND
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RSoundActivationUpReg;

/**
 * The relUpReg message of the property "RSoundActivation"
 * Property for activation/deactivation of RSOUND
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RSoundActivationRelUpReg;

/**
 * The error message of 'RSoundActivation'
 */
typedef ::asf::cca::CcaTypes::DefaultError RSoundActivationError;

/**
 * The get message of the property "ANCASCActiveTest"
 * Start/Stop the ANC,ASC Test
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ANCASCActiveTestGet;

/**
 * The upreg message of the property "ANCASCActiveTest"
 * Start/Stop the ANC,ASC Test
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ANCASCActiveTestUpReg;

/**
 * The relUpReg message of the property "ANCASCActiveTest"
 * Start/Stop the ANC,ASC Test
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ANCASCActiveTestRelUpReg;

/**
 * The error message of 'ANCASCActiveTest'
 */
typedef ::asf::cca::CcaTypes::DefaultError ANCASCActiveTestError;

/**
 * The set message of the property "ANCASCSelfDiagnosticStatus"
 * ANC ASC Self Diagnostic status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ANCASCSelfDiagnosticStatusSet;

/**
 * The get message of the property "ANCASCSelfDiagnosticStatus"
 * ANC ASC Self Diagnostic status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ANCASCSelfDiagnosticStatusGet;

/**
 * The upreg message of the property "ANCASCSelfDiagnosticStatus"
 * ANC ASC Self Diagnostic status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ANCASCSelfDiagnosticStatusUpReg;

/**
 * The relUpReg message of the property "ANCASCSelfDiagnosticStatus"
 * ANC ASC Self Diagnostic status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ANCASCSelfDiagnosticStatusRelUpReg;

/**
 * The error message of 'ANCASCSelfDiagnosticStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError ANCASCSelfDiagnosticStatusError;

/**
 * The get message of the property "UserProfileChange"
 * status to inform User Profile Change Operation
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UserProfileChangeGet;

/**
 * The upreg message of the property "UserProfileChange"
 * status to inform User Profile Change Operation
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UserProfileChangeUpReg;

/**
 * The relUpReg message of the property "UserProfileChange"
 * status to inform User Profile Change Operation
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UserProfileChangeRelUpReg;

/**
 * The error message of 'UserProfileChange'
 */
typedef ::asf::cca::CcaTypes::DefaultError UserProfileChangeError;

/**
 * The get message of the property "SRSoundNotificationState"
 * User can activate and de-activate Sound Notification for the request based on SR_AutomaticRecordStatus
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SRSoundNotificationStateGet;

/**
 * The upreg message of the property "SRSoundNotificationState"
 * User can activate and de-activate Sound Notification for the request based on SR_AutomaticRecordStatus
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SRSoundNotificationStateUpReg;

/**
 * The relUpReg message of the property "SRSoundNotificationState"
 * User can activate and de-activate Sound Notification for the request based on SR_AutomaticRecordStatus
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SRSoundNotificationStateRelUpReg;

/**
 * The error message of 'SRSoundNotificationState'
 */
typedef ::asf::cca::CcaTypes::DefaultError SRSoundNotificationStateError;

/**
 * The get message of the property "AudioPilotIntensity"
 * status of actual audio pilot intensity.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioPilotIntensityGet;

/**
 * The upreg message of the property "AudioPilotIntensity"
 * status of actual audio pilot intensity.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioPilotIntensityUpReg;

/**
 * The relUpReg message of the property "AudioPilotIntensity"
 * status of actual audio pilot intensity.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioPilotIntensityRelUpReg;

/**
 * The error message of 'AudioPilotIntensity'
 */
typedef ::asf::cca::CcaTypes::DefaultError AudioPilotIntensityError;

/**
 * The upreg message of the property "MainAudioAttenuation"
 * status of main audio attenuation from amplifier
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MainAudioAttenuationUpReg;

/**
 * The relUpReg message of the property "MainAudioAttenuation"
 * status of main audio attenuation from amplifier
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MainAudioAttenuationRelUpReg;

/**
 * The error message of 'MainAudioAttenuation'
 */
typedef ::asf::cca::CcaTypes::DefaultError MainAudioAttenuationError;

/**
 * The abort error message of the method "VolumeMode"
 * Set special volume mode for volume changes of sound settings (e.g. set OnVolume).
 */
typedef ::asf::cca::CcaTypes::DefaultError VolumeModeAbortError;

/**
 * The error message of 'VolumeMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError VolumeModeError;

/**
 * The abort error message of the method "Beep"
 * start beep sound.
 */
typedef ::asf::cca::CcaTypes::DefaultError BeepAbortError;

/**
 * The error message of 'Beep'
 */
typedef ::asf::cca::CcaTypes::DefaultError BeepError;

/**
 * The abort error message of the method "BeepFile"
 * Start Beep on Mix3 stream by playing the file provided.
 */
typedef ::asf::cca::CcaTypes::DefaultError BeepFileAbortError;

/**
 * The error message of 'BeepFile'
 */
typedef ::asf::cca::CcaTypes::DefaultError BeepFileError;

/**
 * The abort error message of the method "Mute"
 * With this methode a requester can gives a mute request to the audio management. Same methode is used to release the request.
 *
 * The RUN Events are specially conceived for drives, to indicate the starting of a Demute. If audio playback is stoped an restarted the middle of a track nothing from the track should be left out, but there should also be a soft fade in. That means the drive must start playing only when the Demute begins.
 * This treatment is planned only for the Demute. There is no RUN Acknowledge for a Mute!
 *
 * The time between demute-request and start of the command is unspecified, as demute dependent on all Requesters.#xD#xA
 * Keep always in mind as a Design-Rule:
 * The generation of Acknowledges or start of additonal actions should not depend on Methode Result of a demute.
 */
typedef ::asf::cca::CcaTypes::DefaultError MuteAbortError;

/**
 * The error message of 'Mute'
 */
typedef ::asf::cca::CcaTypes::DefaultError MuteError;

/**
 * The abort error message of the method "Set_Mute_Ramp"
 * The MuteRequest Methode give a Mute Request to the Audio System
 */
typedef ::asf::cca::CcaTypes::DefaultError Set_Mute_RampAbortError;

/**
 * The error message of 'Set_Mute_Ramp'
 */
typedef ::asf::cca::CcaTypes::DefaultError Set_Mute_RampError;

/**
 * The abort error message of the method "AudioSource"
 * The audio Manager is informed about the actual source.
 * This information is used to adapt the signal processing to the new source.
 * To adapt might mean changing the frequency responce, use seperate user setting like Volume, bas or fader or change the audio level,...
 * It might also mean, that some functions are blocked, like fader, which his set to linear during phone.
 */
typedef ::asf::cca::CcaTypes::DefaultError AudioSourceAbortError;

/**
 * The error message of 'AudioSource'
 */
typedef ::asf::cca::CcaTypes::DefaultError AudioSourceError;

/**
 * The abort error message of the method "AmpDeviceAudioRoute"
 * command to set the audio route in amplifier device.
 * This information is used to set the amplifier device (presently this is the ADR) to the correct audio input.
 */
typedef ::asf::cca::CcaTypes::DefaultError AmpDeviceAudioRouteAbortError;

/**
 * The error message of 'AmpDeviceAudioRoute'
 */
typedef ::asf::cca::CcaTypes::DefaultError AmpDeviceAudioRouteError;

/**
 * The abort error message of the method "AudioTestTone"
 * This method, former known as actuator test, controlles a test tone that plays on the selected loudspeaker.
 */
typedef ::asf::cca::CcaTypes::DefaultError AudioTestToneAbortError;

/**
 * The error message of 'AudioTestTone'
 */
typedef ::asf::cca::CcaTypes::DefaultError AudioTestToneError;

/**
 * The abort error message of the method "CueState"
 * This method, indicates if the FF/FR cue is in START state or STOP state
 */
typedef ::asf::cca::CcaTypes::DefaultError CueStateAbortError;

/**
 * The error message of 'CueState'
 */
typedef ::asf::cca::CcaTypes::DefaultError CueStateError;

/**
 * The start message of the method "PerformOnVolumeLimit"
 * Nofity wether volume must be limitted. All source groups which are candidates for on volume limit will be limited.
 * The volume of each group will be reduced if it's higher than the limit. The change will be audible, once a member source is demuted.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PerformOnVolumeLimitStart;

/**
 * The abort error message of the method "PerformOnVolumeLimit"
 * Nofity wether volume must be limitted. All source groups which are candidates for on volume limit will be limited.
 * The volume of each group will be reduced if it's higher than the limit. The change will be audible, once a member source is demuted.
 */
typedef ::asf::cca::CcaTypes::DefaultError PerformOnVolumeLimitAbortError;

/**
 * The abort error message of the method "SpeakerDiagnosisStart"
 * This method triggers the diagnosis functions of an internal amplifier via ADR3.
 */
typedef ::asf::cca::CcaTypes::DefaultError SpeakerDiagnosisStartAbortError;

/**
 * The error message of 'SpeakerDiagnosisStart'
 */
typedef ::asf::cca::CcaTypes::DefaultError SpeakerDiagnosisStartError;

/**
 * The abort error message of the method "SystemMute"
 * With this method a requester can gives a system mute request to the audio management. Same method is used to release the request.
 *
 * The RUN Events are specially conceived for drives, to indicate the starting of a Demute. If audio playback is stoped an restarted the middle of a track nothing from the track should be left out, but there should also be a soft fade in. That means the drive must start playing only when the Demute begins.
 * This treatment is planned only for the Demute. There is no RUN Acknowledge for a Mute!
 *
 * The time between demute-request and start of the command is unspecified, as demute dependent on all Requesters.#xD#xA
 * Keep always in mind as a Design-Rule:
 * The generation of Acknowledges or start of additonal actions should not depend on Methode Result of a demute.
 */
typedef ::asf::cca::CcaTypes::DefaultError SystemMuteAbortError;

/**
 * The error message of 'SystemMute'
 */
typedef ::asf::cca::CcaTypes::DefaultError SystemMuteError;

/**
 * The abort error message of the method "ADAS_SettingSound"
 * Start playing a ADAS setting sound
 */
typedef ::asf::cca::CcaTypes::DefaultError ADAS_SettingSoundAbortError;

/**
 * The error message of 'ADAS_SettingSound'
 */
typedef ::asf::cca::CcaTypes::DefaultError ADAS_SettingSoundError;

/**
 * The abort error message of the method "EntertainmentMute"
 * With this method a requester can gives a mute request to the external MCAN Bose Amplifier. Same method is used to release the request.
 *
 * The RUN Events are specially conceived for drives, to indicate the starting of a Demute. If audio playback is stoped an restarted the middle of a track nothing from the track should be left out, but there should also be a soft fade in. That means the drive must start playing only when the Demute begins.
 * This treatment is planned only for the Demute. There is no RUN Acknowledge for a Mute!
 *
 * The time between demute-request and start of the command is unspecified, as demute dependent on all Requesters.#xD#xA
 * Keep always in mind as a Design-Rule:
 * The generation of Acknowledges or start of additonal actions should not depend on Methode Result of a demute.
 */
typedef ::asf::cca::CcaTypes::DefaultError EntertainmentMuteAbortError;

/**
 * The error message of 'EntertainmentMute'
 */
typedef ::asf::cca::CcaTypes::DefaultError EntertainmentMuteError;

/**
 * The start message of the method "MCANBoseAmp_VersionInfo"
 * Request from HMI to get the version information from bose amplifier
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MCANBoseAmp_VersionInfoStart;

/**
 * The result message of the method "MCANBoseAmp_VersionInfo"
 * Request from HMI to get the version information from bose amplifier
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MCANBoseAmp_VersionInfoResult;

/**
 * The abort error message of the method "MCANBoseAmp_VersionInfo"
 * Request from HMI to get the version information from bose amplifier
 */
typedef ::asf::cca::CcaTypes::DefaultError MCANBoseAmp_VersionInfoAbortError;

/**
 * The error message of 'MCANBoseAmp_VersionInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError MCANBoseAmp_VersionInfoError;


/**
 * The status message of the property "VolumeModeStatus"
 * This property gives information about the actual volume mode.
 */
class VolumeModeStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VolumeModeStatusStatus ();

    /**
     * Copy constructor
     */
    inline  VolumeModeStatusStatus (const VolumeModeStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VolumeModeStatusStatus (::masc_main_fi_types::T_e8_VolumeMode VolumeMode_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::masc_main_fi_types::T_e8_AudioChannel Channel_);

    /**
     * Destructor
     */
    inline virtual  ~VolumeModeStatusStatus();

    /**
     * Assignment operator
     */
    inline VolumeModeStatusStatus& operator = (const VolumeModeStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VolumeModeStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VolumeModeStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VolumeModeStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VolumeModeStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VolumeMode"

    static const int kVolumeMode = 0;

    /**
     * Clears the field "VolumeMode".
     *
     * The field will be set to its default value. The hasVolumeMode()
     * method will return false.
     */
    inline void clearVolumeMode();

    /**
     * Checks whether the field "VolumeMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolumeMode()). Otherwise it will return false.
     */
    inline bool hasVolumeMode () const;

    /**
     * Returns the value of the member "VolumeMode".
     *
     * volume mode that was set
     *
     * @return The value of the field "VolumeMode"
     */
    inline ::masc_main_fi_types::T_e8_VolumeMode getVolumeMode () const;

    /**
     * Sets the value of the member "VolumeMode".
     *
     * volume mode that was set
     *
     * @param VolumeMode The value which will be set
     */
    inline void setVolumeMode (::masc_main_fi_types::T_e8_VolumeMode VolumeMode_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "Channel"

    static const int kChannel = 2;

    /**
     * Clears the field "Channel".
     *
     * The field will be set to its default value. The hasChannel()
     * method will return false.
     */
    inline void clearChannel();

    /**
     * Checks whether the field "Channel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannel()). Otherwise it will return false.
     */
    inline bool hasChannel () const;

    /**
     * Returns the value of the member "Channel".
     *
     * Related channel
     *
     * @return The value of the field "Channel"
     */
    inline ::masc_main_fi_types::T_e8_AudioChannel getChannel () const;

    /**
     * Sets the value of the member "Channel".
     *
     * Related channel
     *
     * @param Channel The value which will be set
     */
    inline void setChannel (::masc_main_fi_types::T_e8_AudioChannel Channel_);

    static const VolumeModeStatusStatus &getDefaultInstance();

private:

    inline void set_has_VolumeMode ();

    inline void clear_has_VolumeMode ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_Channel ();

    inline void clear_has_Channel ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::masc_main_fi_types::T_e8_VolumeMode _VolumeMode;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    ::masc_main_fi_types::T_e8_AudioChannel _Channel;

};

/**
 * The status message of the property "Volume"
 * status of the actual volume order.
 */
class VolumeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VolumeStatus ();

    /**
     * Copy constructor
     */
    inline  VolumeStatus (const VolumeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VolumeStatus (::masc_main_fi_types::T_e8_VolumeMode VolumeMode_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::masc_main_fi_types::T_e8_AudioChannel Channel_, uint8 Volume_, ::mascf_aud_src_route_fi_types::T_e8_AudSource Source_);

    /**
     * Destructor
     */
    inline virtual  ~VolumeStatus();

    /**
     * Assignment operator
     */
    inline VolumeStatus& operator = (const VolumeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VolumeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VolumeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VolumeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VolumeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VolumeMode"

    static const int kVolumeMode = 0;

    /**
     * Clears the field "VolumeMode".
     *
     * The field will be set to its default value. The hasVolumeMode()
     * method will return false.
     */
    inline void clearVolumeMode();

    /**
     * Checks whether the field "VolumeMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolumeMode()). Otherwise it will return false.
     */
    inline bool hasVolumeMode () const;

    /**
     * Returns the value of the member "VolumeMode".
     *
     * volume mode of current volume value
     *
     * @return The value of the field "VolumeMode"
     */
    inline ::masc_main_fi_types::T_e8_VolumeMode getVolumeMode () const;

    /**
     * Sets the value of the member "VolumeMode".
     *
     * volume mode of current volume value
     *
     * @param VolumeMode The value which will be set
     */
    inline void setVolumeMode (::masc_main_fi_types::T_e8_VolumeMode VolumeMode_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "Channel"

    static const int kChannel = 2;

    /**
     * Clears the field "Channel".
     *
     * The field will be set to its default value. The hasChannel()
     * method will return false.
     */
    inline void clearChannel();

    /**
     * Checks whether the field "Channel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannel()). Otherwise it will return false.
     */
    inline bool hasChannel () const;

    /**
     * Returns the value of the member "Channel".
     *
     * Related channel
     *
     * @return The value of the field "Channel"
     */
    inline ::masc_main_fi_types::T_e8_AudioChannel getChannel () const;

    /**
     * Sets the value of the member "Channel".
     *
     * Related channel
     *
     * @param Channel The value which will be set
     */
    inline void setChannel (::masc_main_fi_types::T_e8_AudioChannel Channel_);

    // API of field "Volume"

    static const int kVolume = 3;

    /**
     * Clears the field "Volume".
     *
     * The field will be set to its default value. The hasVolume()
     * method will return false.
     */
    inline void clearVolume();

    /**
     * Checks whether the field "Volume" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolume()). Otherwise it will return false.
     */
    inline bool hasVolume () const;

    /**
     * Returns the value of the member "Volume".
     *
     * actual volume value in User-Steps
     *
     * @return The value of the field "Volume"
     */
    inline uint8 getVolume () const;

    /**
     * Sets the value of the member "Volume".
     *
     * actual volume value in User-Steps
     *
     * @param Volume The value which will be set
     */
    inline void setVolume (uint8 Volume_);

    // API of field "Source"

    static const int kSource = 4;

    /**
     * Clears the field "Source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "Source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "Source".
     *
     * actual Active source.
     *
     * @return The value of the field "Source"
     */
    inline ::mascf_aud_src_route_fi_types::T_e8_AudSource getSource () const;

    /**
     * Sets the value of the member "Source".
     *
     * actual Active source.
     *
     * @param Source The value which will be set
     */
    inline void setSource (::mascf_aud_src_route_fi_types::T_e8_AudSource Source_);

    static const VolumeStatus &getDefaultInstance();

private:

    inline void set_has_VolumeMode ();

    inline void clear_has_VolumeMode ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_Channel ();

    inline void clear_has_Channel ();

    inline void set_has_Volume ();

    inline void clear_has_Volume ();

    inline void set_has_Source ();

    inline void clear_has_Source ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::masc_main_fi_types::T_e8_VolumeMode _VolumeMode;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    ::masc_main_fi_types::T_e8_AudioChannel _Channel;

    uint8 _Volume;

    ::mascf_aud_src_route_fi_types::T_e8_AudSource _Source;

};

/**
 * The set message of the property "Volume"
 * status of the actual volume order.
 */
class VolumeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VolumeSet ();

    /**
     * Copy constructor
     */
    inline  VolumeSet (const VolumeSet &rhs);

    /**
     * All fields constructor
     */
    inline  VolumeSet (::masc_main_fi_types::T_e8_AudioVolumeType VolumeType_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, uint8 Volume_);

    /**
     * Destructor
     */
    inline virtual  ~VolumeSet();

    /**
     * Assignment operator
     */
    inline VolumeSet& operator = (const VolumeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VolumeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VolumeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VolumeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VolumeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VolumeType"

    static const int kVolumeType = 0;

    /**
     * Clears the field "VolumeType".
     *
     * The field will be set to its default value. The hasVolumeType()
     * method will return false.
     */
    inline void clearVolumeType();

    /**
     * Checks whether the field "VolumeType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolumeType()). Otherwise it will return false.
     */
    inline bool hasVolumeType () const;

    /**
     * Returns the value of the member "VolumeType".
     *
     * volume type, it can be an absolut volume change or a relative volume change
     * (increment or decrement)
     *
     * @return The value of the field "VolumeType"
     */
    inline ::masc_main_fi_types::T_e8_AudioVolumeType getVolumeType () const;

    /**
     * Sets the value of the member "VolumeType".
     *
     * volume type, it can be an absolut volume change or a relative volume change
     * (increment or decrement)
     *
     * @param VolumeType The value which will be set
     */
    inline void setVolumeType (::masc_main_fi_types::T_e8_AudioVolumeType VolumeType_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "Volume"

    static const int kVolume = 2;

    /**
     * Clears the field "Volume".
     *
     * The field will be set to its default value. The hasVolume()
     * method will return false.
     */
    inline void clearVolume();

    /**
     * Checks whether the field "Volume" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolume()). Otherwise it will return false.
     */
    inline bool hasVolume () const;

    /**
     * Returns the value of the member "Volume".
     *
     * value, volume should be changed to
     *
     * @return The value of the field "Volume"
     */
    inline uint8 getVolume () const;

    /**
     * Sets the value of the member "Volume".
     *
     * value, volume should be changed to
     *
     * @param Volume The value which will be set
     */
    inline void setVolume (uint8 Volume_);

    static const VolumeSet &getDefaultInstance();

private:

    inline void set_has_VolumeType ();

    inline void clear_has_VolumeType ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_Volume ();

    inline void clear_has_Volume ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudioVolumeType _VolumeType;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    uint8 _Volume;

};

/**
 * The status message of the property "BeepStatus"
 * Gives the present status of the beep. This status is not related to a special. It just gives the information that a beep is running.
 */
class BeepStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BeepStatusStatus ();

    /**
     * Copy constructor
     */
    inline  BeepStatusStatus (const BeepStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  BeepStatusStatus (::masc_main_fi_types::T_e8_AudioBeepStatus BeepStatus_, uint32 u32Token_, ::masc_main_fi_types::T_e8_ResourceNo Resource_);

    /**
     * Destructor
     */
    inline virtual  ~BeepStatusStatus();

    /**
     * Assignment operator
     */
    inline BeepStatusStatus& operator = (const BeepStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BeepStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BeepStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BeepStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BeepStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BeepStatus"

    static const int kBeepStatus = 0;

    /**
     * Clears the field "BeepStatus".
     *
     * The field will be set to its default value. The hasBeepStatus()
     * method will return false.
     */
    inline void clearBeepStatus();

    /**
     * Checks whether the field "BeepStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBeepStatus()). Otherwise it will return false.
     */
    inline bool hasBeepStatus () const;

    /**
     * Returns the value of the member "BeepStatus".
     *
     * status of beep
     *
     * @return The value of the field "BeepStatus"
     */
    inline ::masc_main_fi_types::T_e8_AudioBeepStatus getBeepStatus () const;

    /**
     * Sets the value of the member "BeepStatus".
     *
     * status of beep
     *
     * @param BeepStatus The value which will be set
     */
    inline void setBeepStatus (::masc_main_fi_types::T_e8_AudioBeepStatus BeepStatus_);

    // API of field "u32Token"

    static const int kU32Token = 1;

    /**
     * Clears the field "u32Token".
     *
     * The field will be set to its default value. The hasU32Token()
     * method will return false.
     */
    inline void clearU32Token();

    /**
     * Checks whether the field "u32Token" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Token()). Otherwise it will return false.
     */
    inline bool hasU32Token () const;

    /**
     * Returns the value of the member "u32Token".
     *
     * Token ID of the beep for which the status is sent
     *
     * @return The value of the field "u32Token"
     */
    inline uint32 getU32Token () const;

    /**
     * Sets the value of the member "u32Token".
     *
     * Token ID of the beep for which the status is sent
     *
     * @param u32Token The value which will be set
     */
    inline void setU32Token (uint32 u32Token_);

    // API of field "Resource"

    static const int kResource = 2;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    static const BeepStatusStatus &getDefaultInstance();

private:

    inline void set_has_BeepStatus ();

    inline void clear_has_BeepStatus ();

    inline void set_has_u32Token ();

    inline void clear_has_u32Token ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudioBeepStatus _BeepStatus;

    uint32 _u32Token;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

};

/**
 * The status message of the property "Gala"
 * status of actual gala order.
 */
class GalaStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GalaStatus ();

    /**
     * Copy constructor
     */
    inline  GalaStatus (const GalaStatus &rhs);

    /**
     * All fields constructor
     */
    inline  GalaStatus (::masc_main_fi_types::T_e8_GalaLevel GalaLevel_, ::masc_main_fi_types::T_e8_ResourceNo Resource_);

    /**
     * Destructor
     */
    inline virtual  ~GalaStatus();

    /**
     * Assignment operator
     */
    inline GalaStatus& operator = (const GalaStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GalaStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GalaStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GalaStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GalaStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GalaLevel"

    static const int kGalaLevel = 0;

    /**
     * Clears the field "GalaLevel".
     *
     * The field will be set to its default value. The hasGalaLevel()
     * method will return false.
     */
    inline void clearGalaLevel();

    /**
     * Checks whether the field "GalaLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGalaLevel()). Otherwise it will return false.
     */
    inline bool hasGalaLevel () const;

    /**
     * Returns the value of the member "GalaLevel".
     *
     * status of requested beep
     *
     * @return The value of the field "GalaLevel"
     */
    inline ::masc_main_fi_types::T_e8_GalaLevel getGalaLevel () const;

    /**
     * Sets the value of the member "GalaLevel".
     *
     * status of requested beep
     *
     * @param GalaLevel The value which will be set
     */
    inline void setGalaLevel (::masc_main_fi_types::T_e8_GalaLevel GalaLevel_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    static const GalaStatus &getDefaultInstance();

private:

    inline void set_has_GalaLevel ();

    inline void clear_has_GalaLevel ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::masc_main_fi_types::T_e8_GalaLevel _GalaLevel;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

};

/**
 * The set message of the property "Gala"
 * status of actual gala order.
 */
class GalaSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GalaSet ();

    /**
     * Copy constructor
     */
    inline  GalaSet (const GalaSet &rhs);

    /**
     * All fields constructor
     */
    inline  GalaSet (::masc_main_fi_types::T_e8_GalaLevel GalaLevel_, ::masc_main_fi_types::T_e8_ResourceNo Resource_);

    /**
     * Destructor
     */
    inline virtual  ~GalaSet();

    /**
     * Assignment operator
     */
    inline GalaSet& operator = (const GalaSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GalaSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GalaSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GalaSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GalaSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GalaLevel"

    static const int kGalaLevel = 0;

    /**
     * Clears the field "GalaLevel".
     *
     * The field will be set to its default value. The hasGalaLevel()
     * method will return false.
     */
    inline void clearGalaLevel();

    /**
     * Checks whether the field "GalaLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGalaLevel()). Otherwise it will return false.
     */
    inline bool hasGalaLevel () const;

    /**
     * Returns the value of the member "GalaLevel".
     *
     * gala level
     *
     * @return The value of the field "GalaLevel"
     */
    inline ::masc_main_fi_types::T_e8_GalaLevel getGalaLevel () const;

    /**
     * Sets the value of the member "GalaLevel".
     *
     * gala level
     *
     * @param GalaLevel The value which will be set
     */
    inline void setGalaLevel (::masc_main_fi_types::T_e8_GalaLevel GalaLevel_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    static const GalaSet &getDefaultInstance();

private:

    inline void set_has_GalaLevel ();

    inline void clear_has_GalaLevel ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::masc_main_fi_types::T_e8_GalaLevel _GalaLevel;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

};

/**
 * The status message of the property "Balance"
 * status of actual balance value.
 */
class BalanceStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BalanceStatus ();

    /**
     * Copy constructor
     */
    inline  BalanceStatus (const BalanceStatus &rhs);

    /**
     * All fields constructor
     */
    inline  BalanceStatus (int8 Balance_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::masc_main_fi_types::T_e8_AudioChannel Channel_);

    /**
     * Destructor
     */
    inline virtual  ~BalanceStatus();

    /**
     * Assignment operator
     */
    inline BalanceStatus& operator = (const BalanceStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BalanceStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BalanceStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BalanceStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BalanceStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Balance"

    static const int kBalance = 0;

    /**
     * Clears the field "Balance".
     *
     * The field will be set to its default value. The hasBalance()
     * method will return false.
     */
    inline void clearBalance();

    /**
     * Checks whether the field "Balance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBalance()). Otherwise it will return false.
     */
    inline bool hasBalance () const;

    /**
     * Returns the value of the member "Balance".
     *
     * Balance value
     *
     * @return The value of the field "Balance"
     */
    inline int8 getBalance () const;

    /**
     * Sets the value of the member "Balance".
     *
     * Balance value
     *
     * @param Balance The value which will be set
     */
    inline void setBalance (int8 Balance_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "Channel"

    static const int kChannel = 2;

    /**
     * Clears the field "Channel".
     *
     * The field will be set to its default value. The hasChannel()
     * method will return false.
     */
    inline void clearChannel();

    /**
     * Checks whether the field "Channel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannel()). Otherwise it will return false.
     */
    inline bool hasChannel () const;

    /**
     * Returns the value of the member "Channel".
     *
     * Related channel
     *
     * @return The value of the field "Channel"
     */
    inline ::masc_main_fi_types::T_e8_AudioChannel getChannel () const;

    /**
     * Sets the value of the member "Channel".
     *
     * Related channel
     *
     * @param Channel The value which will be set
     */
    inline void setChannel (::masc_main_fi_types::T_e8_AudioChannel Channel_);

    static const BalanceStatus &getDefaultInstance();

private:

    inline void set_has_Balance ();

    inline void clear_has_Balance ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_Channel ();

    inline void clear_has_Channel ();

    uint32 _has_bits_[ (3 + 31) / 32];

    int8 _Balance;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    ::masc_main_fi_types::T_e8_AudioChannel _Channel;

};

/**
 * The set message of the property "Balance"
 * status of actual balance value.
 */
class BalanceSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BalanceSet ();

    /**
     * Copy constructor
     */
    inline  BalanceSet (const BalanceSet &rhs);

    /**
     * All fields constructor
     */
    inline  BalanceSet (::masc_main_fi_types::T_e8_AudioSoundType SoundType_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, int8 Balance_);

    /**
     * Destructor
     */
    inline virtual  ~BalanceSet();

    /**
     * Assignment operator
     */
    inline BalanceSet& operator = (const BalanceSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BalanceSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BalanceSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BalanceSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BalanceSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SoundType"

    static const int kSoundType = 0;

    /**
     * Clears the field "SoundType".
     *
     * The field will be set to its default value. The hasSoundType()
     * method will return false.
     */
    inline void clearSoundType();

    /**
     * Checks whether the field "SoundType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundType()). Otherwise it will return false.
     */
    inline bool hasSoundType () const;

    /**
     * Returns the value of the member "SoundType".
     *
     * Type of sound (balance) , it can be absolute or relative
     *
     * @return The value of the field "SoundType"
     */
    inline ::masc_main_fi_types::T_e8_AudioSoundType getSoundType () const;

    /**
     * Sets the value of the member "SoundType".
     *
     * Type of sound (balance) , it can be absolute or relative
     *
     * @param SoundType The value which will be set
     */
    inline void setSoundType (::masc_main_fi_types::T_e8_AudioSoundType SoundType_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "Balance"

    static const int kBalance = 2;

    /**
     * Clears the field "Balance".
     *
     * The field will be set to its default value. The hasBalance()
     * method will return false.
     */
    inline void clearBalance();

    /**
     * Checks whether the field "Balance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBalance()). Otherwise it will return false.
     */
    inline bool hasBalance () const;

    /**
     * Returns the value of the member "Balance".
     *
     * Balance value to set
     *
     * @return The value of the field "Balance"
     */
    inline int8 getBalance () const;

    /**
     * Sets the value of the member "Balance".
     *
     * Balance value to set
     *
     * @param Balance The value which will be set
     */
    inline void setBalance (int8 Balance_);

    static const BalanceSet &getDefaultInstance();

private:

    inline void set_has_SoundType ();

    inline void clear_has_SoundType ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_Balance ();

    inline void clear_has_Balance ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudioSoundType _SoundType;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    int8 _Balance;

};

/**
 * The status message of the property "Loudness"
 * status of actual loudness value.
 */
class LoudnessStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LoudnessStatus ();

    /**
     * Copy constructor
     */
    inline  LoudnessStatus (const LoudnessStatus &rhs);

    /**
     * All fields constructor
     */
    inline  LoudnessStatus (uint8 Loudness_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::masc_main_fi_types::T_e8_AudioChannel Channel_);

    /**
     * Destructor
     */
    inline virtual  ~LoudnessStatus();

    /**
     * Assignment operator
     */
    inline LoudnessStatus& operator = (const LoudnessStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LoudnessStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LoudnessStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LoudnessStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LoudnessStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Loudness"

    static const int kLoudness = 0;

    /**
     * Clears the field "Loudness".
     *
     * The field will be set to its default value. The hasLoudness()
     * method will return false.
     */
    inline void clearLoudness();

    /**
     * Checks whether the field "Loudness" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLoudness()). Otherwise it will return false.
     */
    inline bool hasLoudness () const;

    /**
     * Returns the value of the member "Loudness".
     *
     * Loudness value
     *
     * @return The value of the field "Loudness"
     */
    inline uint8 getLoudness () const;

    /**
     * Sets the value of the member "Loudness".
     *
     * Loudness value
     *
     * @param Loudness The value which will be set
     */
    inline void setLoudness (uint8 Loudness_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "Channel"

    static const int kChannel = 2;

    /**
     * Clears the field "Channel".
     *
     * The field will be set to its default value. The hasChannel()
     * method will return false.
     */
    inline void clearChannel();

    /**
     * Checks whether the field "Channel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannel()). Otherwise it will return false.
     */
    inline bool hasChannel () const;

    /**
     * Returns the value of the member "Channel".
     *
     * Related channel
     *
     * @return The value of the field "Channel"
     */
    inline ::masc_main_fi_types::T_e8_AudioChannel getChannel () const;

    /**
     * Sets the value of the member "Channel".
     *
     * Related channel
     *
     * @param Channel The value which will be set
     */
    inline void setChannel (::masc_main_fi_types::T_e8_AudioChannel Channel_);

    static const LoudnessStatus &getDefaultInstance();

private:

    inline void set_has_Loudness ();

    inline void clear_has_Loudness ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_Channel ();

    inline void clear_has_Channel ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _Loudness;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    ::masc_main_fi_types::T_e8_AudioChannel _Channel;

};

/**
 * The set message of the property "Loudness"
 * status of actual loudness value.
 */
class LoudnessSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LoudnessSet ();

    /**
     * Copy constructor
     */
    inline  LoudnessSet (const LoudnessSet &rhs);

    /**
     * All fields constructor
     */
    inline  LoudnessSet (::masc_main_fi_types::T_e8_AudioSoundType SoundType_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, uint8 Loudness_);

    /**
     * Destructor
     */
    inline virtual  ~LoudnessSet();

    /**
     * Assignment operator
     */
    inline LoudnessSet& operator = (const LoudnessSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LoudnessSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LoudnessSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LoudnessSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LoudnessSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SoundType"

    static const int kSoundType = 0;

    /**
     * Clears the field "SoundType".
     *
     * The field will be set to its default value. The hasSoundType()
     * method will return false.
     */
    inline void clearSoundType();

    /**
     * Checks whether the field "SoundType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundType()). Otherwise it will return false.
     */
    inline bool hasSoundType () const;

    /**
     * Returns the value of the member "SoundType".
     *
     * Type of sound (loudness) , it can be absolute or relative
     *
     * @return The value of the field "SoundType"
     */
    inline ::masc_main_fi_types::T_e8_AudioSoundType getSoundType () const;

    /**
     * Sets the value of the member "SoundType".
     *
     * Type of sound (loudness) , it can be absolute or relative
     *
     * @param SoundType The value which will be set
     */
    inline void setSoundType (::masc_main_fi_types::T_e8_AudioSoundType SoundType_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "Loudness"

    static const int kLoudness = 2;

    /**
     * Clears the field "Loudness".
     *
     * The field will be set to its default value. The hasLoudness()
     * method will return false.
     */
    inline void clearLoudness();

    /**
     * Checks whether the field "Loudness" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLoudness()). Otherwise it will return false.
     */
    inline bool hasLoudness () const;

    /**
     * Returns the value of the member "Loudness".
     *
     * Loudness value to set
     *
     * @return The value of the field "Loudness"
     */
    inline uint8 getLoudness () const;

    /**
     * Sets the value of the member "Loudness".
     *
     * Loudness value to set
     *
     * @param Loudness The value which will be set
     */
    inline void setLoudness (uint8 Loudness_);

    static const LoudnessSet &getDefaultInstance();

private:

    inline void set_has_SoundType ();

    inline void clear_has_SoundType ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_Loudness ();

    inline void clear_has_Loudness ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudioSoundType _SoundType;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    uint8 _Loudness;

};

/**
 * The status message of the property "Bass"
 * status of actual bass value.
 */
class BassStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BassStatus ();

    /**
     * Copy constructor
     */
    inline  BassStatus (const BassStatus &rhs);

    /**
     * All fields constructor
     */
    inline  BassStatus (int8 Bass_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::masc_main_fi_types::T_e8_AudioChannel Channel_);

    /**
     * Destructor
     */
    inline virtual  ~BassStatus();

    /**
     * Assignment operator
     */
    inline BassStatus& operator = (const BassStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BassStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BassStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BassStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BassStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Bass"

    static const int kBass = 0;

    /**
     * Clears the field "Bass".
     *
     * The field will be set to its default value. The hasBass()
     * method will return false.
     */
    inline void clearBass();

    /**
     * Checks whether the field "Bass" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBass()). Otherwise it will return false.
     */
    inline bool hasBass () const;

    /**
     * Returns the value of the member "Bass".
     *
     * Bass value
     *
     * @return The value of the field "Bass"
     */
    inline int8 getBass () const;

    /**
     * Sets the value of the member "Bass".
     *
     * Bass value
     *
     * @param Bass The value which will be set
     */
    inline void setBass (int8 Bass_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "Channel"

    static const int kChannel = 2;

    /**
     * Clears the field "Channel".
     *
     * The field will be set to its default value. The hasChannel()
     * method will return false.
     */
    inline void clearChannel();

    /**
     * Checks whether the field "Channel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannel()). Otherwise it will return false.
     */
    inline bool hasChannel () const;

    /**
     * Returns the value of the member "Channel".
     *
     * Related channel
     *
     * @return The value of the field "Channel"
     */
    inline ::masc_main_fi_types::T_e8_AudioChannel getChannel () const;

    /**
     * Sets the value of the member "Channel".
     *
     * Related channel
     *
     * @param Channel The value which will be set
     */
    inline void setChannel (::masc_main_fi_types::T_e8_AudioChannel Channel_);

    static const BassStatus &getDefaultInstance();

private:

    inline void set_has_Bass ();

    inline void clear_has_Bass ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_Channel ();

    inline void clear_has_Channel ();

    uint32 _has_bits_[ (3 + 31) / 32];

    int8 _Bass;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    ::masc_main_fi_types::T_e8_AudioChannel _Channel;

};

/**
 * The set message of the property "Bass"
 * status of actual bass value.
 */
class BassSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BassSet ();

    /**
     * Copy constructor
     */
    inline  BassSet (const BassSet &rhs);

    /**
     * All fields constructor
     */
    inline  BassSet (::masc_main_fi_types::T_e8_AudioSoundType SoundType_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, int8 Bass_);

    /**
     * Destructor
     */
    inline virtual  ~BassSet();

    /**
     * Assignment operator
     */
    inline BassSet& operator = (const BassSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BassSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BassSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BassSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BassSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SoundType"

    static const int kSoundType = 0;

    /**
     * Clears the field "SoundType".
     *
     * The field will be set to its default value. The hasSoundType()
     * method will return false.
     */
    inline void clearSoundType();

    /**
     * Checks whether the field "SoundType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundType()). Otherwise it will return false.
     */
    inline bool hasSoundType () const;

    /**
     * Returns the value of the member "SoundType".
     *
     * Type of sound (bass) , it can be absolute or relative
     *
     * @return The value of the field "SoundType"
     */
    inline ::masc_main_fi_types::T_e8_AudioSoundType getSoundType () const;

    /**
     * Sets the value of the member "SoundType".
     *
     * Type of sound (bass) , it can be absolute or relative
     *
     * @param SoundType The value which will be set
     */
    inline void setSoundType (::masc_main_fi_types::T_e8_AudioSoundType SoundType_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "Bass"

    static const int kBass = 2;

    /**
     * Clears the field "Bass".
     *
     * The field will be set to its default value. The hasBass()
     * method will return false.
     */
    inline void clearBass();

    /**
     * Checks whether the field "Bass" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBass()). Otherwise it will return false.
     */
    inline bool hasBass () const;

    /**
     * Returns the value of the member "Bass".
     *
     * Bass value to set
     *
     * @return The value of the field "Bass"
     */
    inline int8 getBass () const;

    /**
     * Sets the value of the member "Bass".
     *
     * Bass value to set
     *
     * @param Bass The value which will be set
     */
    inline void setBass (int8 Bass_);

    static const BassSet &getDefaultInstance();

private:

    inline void set_has_SoundType ();

    inline void clear_has_SoundType ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_Bass ();

    inline void clear_has_Bass ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudioSoundType _SoundType;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    int8 _Bass;

};

/**
 * The status message of the property "Treble"
 * status of actual treble value.
 */
class TrebleStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TrebleStatus ();

    /**
     * Copy constructor
     */
    inline  TrebleStatus (const TrebleStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TrebleStatus (int8 Treble_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::masc_main_fi_types::T_e8_AudioChannel Channel_);

    /**
     * Destructor
     */
    inline virtual  ~TrebleStatus();

    /**
     * Assignment operator
     */
    inline TrebleStatus& operator = (const TrebleStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TrebleStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TrebleStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TrebleStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TrebleStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Treble"

    static const int kTreble = 0;

    /**
     * Clears the field "Treble".
     *
     * The field will be set to its default value. The hasTreble()
     * method will return false.
     */
    inline void clearTreble();

    /**
     * Checks whether the field "Treble" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTreble()). Otherwise it will return false.
     */
    inline bool hasTreble () const;

    /**
     * Returns the value of the member "Treble".
     *
     * Treble value
     *
     * @return The value of the field "Treble"
     */
    inline int8 getTreble () const;

    /**
     * Sets the value of the member "Treble".
     *
     * Treble value
     *
     * @param Treble The value which will be set
     */
    inline void setTreble (int8 Treble_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "Channel"

    static const int kChannel = 2;

    /**
     * Clears the field "Channel".
     *
     * The field will be set to its default value. The hasChannel()
     * method will return false.
     */
    inline void clearChannel();

    /**
     * Checks whether the field "Channel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannel()). Otherwise it will return false.
     */
    inline bool hasChannel () const;

    /**
     * Returns the value of the member "Channel".
     *
     * Related channel
     *
     * @return The value of the field "Channel"
     */
    inline ::masc_main_fi_types::T_e8_AudioChannel getChannel () const;

    /**
     * Sets the value of the member "Channel".
     *
     * Related channel
     *
     * @param Channel The value which will be set
     */
    inline void setChannel (::masc_main_fi_types::T_e8_AudioChannel Channel_);

    static const TrebleStatus &getDefaultInstance();

private:

    inline void set_has_Treble ();

    inline void clear_has_Treble ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_Channel ();

    inline void clear_has_Channel ();

    uint32 _has_bits_[ (3 + 31) / 32];

    int8 _Treble;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    ::masc_main_fi_types::T_e8_AudioChannel _Channel;

};

/**
 * The set message of the property "Treble"
 * status of actual treble value.
 */
class TrebleSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TrebleSet ();

    /**
     * Copy constructor
     */
    inline  TrebleSet (const TrebleSet &rhs);

    /**
     * All fields constructor
     */
    inline  TrebleSet (::masc_main_fi_types::T_e8_AudioSoundType SoundType_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, int8 Treble_);

    /**
     * Destructor
     */
    inline virtual  ~TrebleSet();

    /**
     * Assignment operator
     */
    inline TrebleSet& operator = (const TrebleSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TrebleSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TrebleSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TrebleSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TrebleSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SoundType"

    static const int kSoundType = 0;

    /**
     * Clears the field "SoundType".
     *
     * The field will be set to its default value. The hasSoundType()
     * method will return false.
     */
    inline void clearSoundType();

    /**
     * Checks whether the field "SoundType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundType()). Otherwise it will return false.
     */
    inline bool hasSoundType () const;

    /**
     * Returns the value of the member "SoundType".
     *
     * Type of sound (treble) , it can be absolute or relative
     *
     * @return The value of the field "SoundType"
     */
    inline ::masc_main_fi_types::T_e8_AudioSoundType getSoundType () const;

    /**
     * Sets the value of the member "SoundType".
     *
     * Type of sound (treble) , it can be absolute or relative
     *
     * @param SoundType The value which will be set
     */
    inline void setSoundType (::masc_main_fi_types::T_e8_AudioSoundType SoundType_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "Treble"

    static const int kTreble = 2;

    /**
     * Clears the field "Treble".
     *
     * The field will be set to its default value. The hasTreble()
     * method will return false.
     */
    inline void clearTreble();

    /**
     * Checks whether the field "Treble" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTreble()). Otherwise it will return false.
     */
    inline bool hasTreble () const;

    /**
     * Returns the value of the member "Treble".
     *
     * Treble value to set
     *
     * @return The value of the field "Treble"
     */
    inline int8 getTreble () const;

    /**
     * Sets the value of the member "Treble".
     *
     * Treble value to set
     *
     * @param Treble The value which will be set
     */
    inline void setTreble (int8 Treble_);

    static const TrebleSet &getDefaultInstance();

private:

    inline void set_has_SoundType ();

    inline void clear_has_SoundType ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_Treble ();

    inline void clear_has_Treble ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudioSoundType _SoundType;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    int8 _Treble;

};

/**
 * The status message of the property "Fader"
 * status of actual fader value.
 */
class FaderStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FaderStatus ();

    /**
     * Copy constructor
     */
    inline  FaderStatus (const FaderStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FaderStatus (int8 Fader_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::masc_main_fi_types::T_e8_AudioChannel Channel_);

    /**
     * Destructor
     */
    inline virtual  ~FaderStatus();

    /**
     * Assignment operator
     */
    inline FaderStatus& operator = (const FaderStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FaderStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FaderStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FaderStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FaderStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Fader"

    static const int kFader = 0;

    /**
     * Clears the field "Fader".
     *
     * The field will be set to its default value. The hasFader()
     * method will return false.
     */
    inline void clearFader();

    /**
     * Checks whether the field "Fader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFader()). Otherwise it will return false.
     */
    inline bool hasFader () const;

    /**
     * Returns the value of the member "Fader".
     *
     * Fader value
     *
     * @return The value of the field "Fader"
     */
    inline int8 getFader () const;

    /**
     * Sets the value of the member "Fader".
     *
     * Fader value
     *
     * @param Fader The value which will be set
     */
    inline void setFader (int8 Fader_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "Channel"

    static const int kChannel = 2;

    /**
     * Clears the field "Channel".
     *
     * The field will be set to its default value. The hasChannel()
     * method will return false.
     */
    inline void clearChannel();

    /**
     * Checks whether the field "Channel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannel()). Otherwise it will return false.
     */
    inline bool hasChannel () const;

    /**
     * Returns the value of the member "Channel".
     *
     * Related channel
     *
     * @return The value of the field "Channel"
     */
    inline ::masc_main_fi_types::T_e8_AudioChannel getChannel () const;

    /**
     * Sets the value of the member "Channel".
     *
     * Related channel
     *
     * @param Channel The value which will be set
     */
    inline void setChannel (::masc_main_fi_types::T_e8_AudioChannel Channel_);

    static const FaderStatus &getDefaultInstance();

private:

    inline void set_has_Fader ();

    inline void clear_has_Fader ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_Channel ();

    inline void clear_has_Channel ();

    uint32 _has_bits_[ (3 + 31) / 32];

    int8 _Fader;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    ::masc_main_fi_types::T_e8_AudioChannel _Channel;

};

/**
 * The set message of the property "Fader"
 * status of actual fader value.
 */
class FaderSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FaderSet ();

    /**
     * Copy constructor
     */
    inline  FaderSet (const FaderSet &rhs);

    /**
     * All fields constructor
     */
    inline  FaderSet (::masc_main_fi_types::T_e8_AudioSoundType SoundType_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, int8 Fader_);

    /**
     * Destructor
     */
    inline virtual  ~FaderSet();

    /**
     * Assignment operator
     */
    inline FaderSet& operator = (const FaderSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FaderSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FaderSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FaderSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FaderSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SoundType"

    static const int kSoundType = 0;

    /**
     * Clears the field "SoundType".
     *
     * The field will be set to its default value. The hasSoundType()
     * method will return false.
     */
    inline void clearSoundType();

    /**
     * Checks whether the field "SoundType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundType()). Otherwise it will return false.
     */
    inline bool hasSoundType () const;

    /**
     * Returns the value of the member "SoundType".
     *
     * Type of sound (fader) , it can be absolute or relative
     *
     * @return The value of the field "SoundType"
     */
    inline ::masc_main_fi_types::T_e8_AudioSoundType getSoundType () const;

    /**
     * Sets the value of the member "SoundType".
     *
     * Type of sound (fader) , it can be absolute or relative
     *
     * @param SoundType The value which will be set
     */
    inline void setSoundType (::masc_main_fi_types::T_e8_AudioSoundType SoundType_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "Fader"

    static const int kFader = 2;

    /**
     * Clears the field "Fader".
     *
     * The field will be set to its default value. The hasFader()
     * method will return false.
     */
    inline void clearFader();

    /**
     * Checks whether the field "Fader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFader()). Otherwise it will return false.
     */
    inline bool hasFader () const;

    /**
     * Returns the value of the member "Fader".
     *
     * Fader value to set
     *
     * @return The value of the field "Fader"
     */
    inline int8 getFader () const;

    /**
     * Sets the value of the member "Fader".
     *
     * Fader value to set
     *
     * @param Fader The value which will be set
     */
    inline void setFader (int8 Fader_);

    static const FaderSet &getDefaultInstance();

private:

    inline void set_has_SoundType ();

    inline void clear_has_SoundType ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_Fader ();

    inline void clear_has_Fader ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudioSoundType _SoundType;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    int8 _Fader;

};

/**
 * The status message of the property "MidRange"
 * status of actual MidRange value.
 */
class MidRangeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MidRangeStatus ();

    /**
     * Copy constructor
     */
    inline  MidRangeStatus (const MidRangeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MidRangeStatus (int8 MidRange_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::masc_main_fi_types::T_e8_AudioChannel Channel_);

    /**
     * Destructor
     */
    inline virtual  ~MidRangeStatus();

    /**
     * Assignment operator
     */
    inline MidRangeStatus& operator = (const MidRangeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MidRangeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MidRangeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MidRangeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MidRangeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MidRange"

    static const int kMidRange = 0;

    /**
     * Clears the field "MidRange".
     *
     * The field will be set to its default value. The hasMidRange()
     * method will return false.
     */
    inline void clearMidRange();

    /**
     * Checks whether the field "MidRange" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMidRange()). Otherwise it will return false.
     */
    inline bool hasMidRange () const;

    /**
     * Returns the value of the member "MidRange".
     *
     * MidRange value
     *
     * @return The value of the field "MidRange"
     */
    inline int8 getMidRange () const;

    /**
     * Sets the value of the member "MidRange".
     *
     * MidRange value
     *
     * @param MidRange The value which will be set
     */
    inline void setMidRange (int8 MidRange_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "Channel"

    static const int kChannel = 2;

    /**
     * Clears the field "Channel".
     *
     * The field will be set to its default value. The hasChannel()
     * method will return false.
     */
    inline void clearChannel();

    /**
     * Checks whether the field "Channel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannel()). Otherwise it will return false.
     */
    inline bool hasChannel () const;

    /**
     * Returns the value of the member "Channel".
     *
     * Related channel
     *
     * @return The value of the field "Channel"
     */
    inline ::masc_main_fi_types::T_e8_AudioChannel getChannel () const;

    /**
     * Sets the value of the member "Channel".
     *
     * Related channel
     *
     * @param Channel The value which will be set
     */
    inline void setChannel (::masc_main_fi_types::T_e8_AudioChannel Channel_);

    static const MidRangeStatus &getDefaultInstance();

private:

    inline void set_has_MidRange ();

    inline void clear_has_MidRange ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_Channel ();

    inline void clear_has_Channel ();

    uint32 _has_bits_[ (3 + 31) / 32];

    int8 _MidRange;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    ::masc_main_fi_types::T_e8_AudioChannel _Channel;

};

/**
 * The set message of the property "MidRange"
 * status of actual MidRange value.
 */
class MidRangeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MidRangeSet ();

    /**
     * Copy constructor
     */
    inline  MidRangeSet (const MidRangeSet &rhs);

    /**
     * All fields constructor
     */
    inline  MidRangeSet (::masc_main_fi_types::T_e8_AudioSoundType SoundType_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, int8 MidRange_);

    /**
     * Destructor
     */
    inline virtual  ~MidRangeSet();

    /**
     * Assignment operator
     */
    inline MidRangeSet& operator = (const MidRangeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MidRangeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MidRangeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MidRangeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MidRangeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SoundType"

    static const int kSoundType = 0;

    /**
     * Clears the field "SoundType".
     *
     * The field will be set to its default value. The hasSoundType()
     * method will return false.
     */
    inline void clearSoundType();

    /**
     * Checks whether the field "SoundType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundType()). Otherwise it will return false.
     */
    inline bool hasSoundType () const;

    /**
     * Returns the value of the member "SoundType".
     *
     * Type of sound (MidRange) , it can be absolute or relative
     *
     * @return The value of the field "SoundType"
     */
    inline ::masc_main_fi_types::T_e8_AudioSoundType getSoundType () const;

    /**
     * Sets the value of the member "SoundType".
     *
     * Type of sound (MidRange) , it can be absolute or relative
     *
     * @param SoundType The value which will be set
     */
    inline void setSoundType (::masc_main_fi_types::T_e8_AudioSoundType SoundType_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "MidRange"

    static const int kMidRange = 2;

    /**
     * Clears the field "MidRange".
     *
     * The field will be set to its default value. The hasMidRange()
     * method will return false.
     */
    inline void clearMidRange();

    /**
     * Checks whether the field "MidRange" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMidRange()). Otherwise it will return false.
     */
    inline bool hasMidRange () const;

    /**
     * Returns the value of the member "MidRange".
     *
     * MidRange value to set
     *
     * @return The value of the field "MidRange"
     */
    inline int8 getMidRange () const;

    /**
     * Sets the value of the member "MidRange".
     *
     * MidRange value to set
     *
     * @param MidRange The value which will be set
     */
    inline void setMidRange (int8 MidRange_);

    static const MidRangeSet &getDefaultInstance();

private:

    inline void set_has_SoundType ();

    inline void clear_has_SoundType ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_MidRange ();

    inline void clear_has_MidRange ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudioSoundType _SoundType;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    int8 _MidRange;

};

/**
 * The status message of the property "MemSound"
 * status of last sound stored.
 */
class MemSoundStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MemSoundStatus ();

    /**
     * Copy constructor
     */
    inline  MemSoundStatus (const MemSoundStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MemSoundStatus (::masc_main_fi_types::T_e8_Sound Sound_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::masc_main_fi_types::T_e8_MemStatus MemStatus_);

    /**
     * Destructor
     */
    inline virtual  ~MemSoundStatus();

    /**
     * Assignment operator
     */
    inline MemSoundStatus& operator = (const MemSoundStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MemSoundStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MemSoundStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MemSoundStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MemSoundStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Sound"

    static const int kSound = 0;

    /**
     * Clears the field "Sound".
     *
     * The field will be set to its default value. The hasSound()
     * method will return false.
     */
    inline void clearSound();

    /**
     * Checks whether the field "Sound" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSound()). Otherwise it will return false.
     */
    inline bool hasSound () const;

    /**
     * Returns the value of the member "Sound".
     *
     * Stored Sound
     *
     * @return The value of the field "Sound"
     */
    inline ::masc_main_fi_types::T_e8_Sound getSound () const;

    /**
     * Sets the value of the member "Sound".
     *
     * Stored Sound
     *
     * @param Sound The value which will be set
     */
    inline void setSound (::masc_main_fi_types::T_e8_Sound Sound_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "MemStatus"

    static const int kMemStatus = 2;

    /**
     * Clears the field "MemStatus".
     *
     * The field will be set to its default value. The hasMemStatus()
     * method will return false.
     */
    inline void clearMemStatus();

    /**
     * Checks whether the field "MemStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMemStatus()). Otherwise it will return false.
     */
    inline bool hasMemStatus () const;

    /**
     * Returns the value of the member "MemStatus".
     *
     * Last stored sound success or failure
     *
     * @return The value of the field "MemStatus"
     */
    inline ::masc_main_fi_types::T_e8_MemStatus getMemStatus () const;

    /**
     * Sets the value of the member "MemStatus".
     *
     * Last stored sound success or failure
     *
     * @param MemStatus The value which will be set
     */
    inline void setMemStatus (::masc_main_fi_types::T_e8_MemStatus MemStatus_);

    static const MemSoundStatus &getDefaultInstance();

private:

    inline void set_has_Sound ();

    inline void clear_has_Sound ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_MemStatus ();

    inline void clear_has_MemStatus ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::masc_main_fi_types::T_e8_Sound _Sound;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    ::masc_main_fi_types::T_e8_MemStatus _MemStatus;

};

/**
 * The set message of the property "MemSound"
 * status of last sound stored.
 */
class MemSoundSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MemSoundSet ();

    /**
     * Copy constructor
     */
    inline  MemSoundSet (const MemSoundSet &rhs);

    /**
     * All fields constructor
     */
    inline  MemSoundSet (::masc_main_fi_types::T_e8_Sound Sound_, ::masc_main_fi_types::T_e8_ResourceNo Resource_);

    /**
     * Destructor
     */
    inline virtual  ~MemSoundSet();

    /**
     * Assignment operator
     */
    inline MemSoundSet& operator = (const MemSoundSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MemSoundSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MemSoundSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MemSoundSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MemSoundSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Sound"

    static const int kSound = 0;

    /**
     * Clears the field "Sound".
     *
     * The field will be set to its default value. The hasSound()
     * method will return false.
     */
    inline void clearSound();

    /**
     * Checks whether the field "Sound" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSound()). Otherwise it will return false.
     */
    inline bool hasSound () const;

    /**
     * Returns the value of the member "Sound".
     *
     * Sound to store e.g volume, bass, treble, fader, balance etc.
     *
     * @return The value of the field "Sound"
     */
    inline ::masc_main_fi_types::T_e8_Sound getSound () const;

    /**
     * Sets the value of the member "Sound".
     *
     * Sound to store e.g volume, bass, treble, fader, balance etc.
     *
     * @param Sound The value which will be set
     */
    inline void setSound (::masc_main_fi_types::T_e8_Sound Sound_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    static const MemSoundSet &getDefaultInstance();

private:

    inline void set_has_Sound ();

    inline void clear_has_Sound ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::masc_main_fi_types::T_e8_Sound _Sound;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

};

/**
 * The status message of the property "FaderActivationStatus"
 * active/deactive status of fader.
 */
class FaderActivationStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FaderActivationStatusStatus ();

    /**
     * Copy constructor
     */
    inline  FaderActivationStatusStatus (const FaderActivationStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FaderActivationStatusStatus (::masc_main_fi_types::T_e8_FaderStatus FaderStatus_);

    /**
     * Destructor
     */
    inline virtual  ~FaderActivationStatusStatus();

    /**
     * Assignment operator
     */
    inline FaderActivationStatusStatus& operator = (const FaderActivationStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FaderActivationStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FaderActivationStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FaderActivationStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FaderActivationStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FaderStatus"

    static const int kFaderStatus = 0;

    /**
     * Clears the field "FaderStatus".
     *
     * The field will be set to its default value. The hasFaderStatus()
     * method will return false.
     */
    inline void clearFaderStatus();

    /**
     * Checks whether the field "FaderStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFaderStatus()). Otherwise it will return false.
     */
    inline bool hasFaderStatus () const;

    /**
     * Returns the value of the member "FaderStatus".
     *
     * Fader status as active/deactive
     *
     * @return The value of the field "FaderStatus"
     */
    inline ::masc_main_fi_types::T_e8_FaderStatus getFaderStatus () const;

    /**
     * Sets the value of the member "FaderStatus".
     *
     * Fader status as active/deactive
     *
     * @param FaderStatus The value which will be set
     */
    inline void setFaderStatus (::masc_main_fi_types::T_e8_FaderStatus FaderStatus_);

    static const FaderActivationStatusStatus &getDefaultInstance();

private:

    inline void set_has_FaderStatus ();

    inline void clear_has_FaderStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_FaderStatus _FaderStatus;

};

/**
 * The status message of the property "DynamicCompression"
 * status of changed dynamic compression value.
 */
class DynamicCompressionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DynamicCompressionStatus ();

    /**
     * Copy constructor
     */
    inline  DynamicCompressionStatus (const DynamicCompressionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DynamicCompressionStatus (::masc_main_fi_types::T_e8_DynCompression DynCompression_, ::masc_main_fi_types::T_e8_ResourceNo Resource_);

    /**
     * Destructor
     */
    inline virtual  ~DynamicCompressionStatus();

    /**
     * Assignment operator
     */
    inline DynamicCompressionStatus& operator = (const DynamicCompressionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DynamicCompressionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DynamicCompressionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DynamicCompressionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DynamicCompressionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DynCompression"

    static const int kDynCompression = 0;

    /**
     * Clears the field "DynCompression".
     *
     * The field will be set to its default value. The hasDynCompression()
     * method will return false.
     */
    inline void clearDynCompression();

    /**
     * Checks whether the field "DynCompression" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDynCompression()). Otherwise it will return false.
     */
    inline bool hasDynCompression () const;

    /**
     * Returns the value of the member "DynCompression".
     *
     * Dynamic compression value
     *
     * @return The value of the field "DynCompression"
     */
    inline ::masc_main_fi_types::T_e8_DynCompression getDynCompression () const;

    /**
     * Sets the value of the member "DynCompression".
     *
     * Dynamic compression value
     *
     * @param DynCompression The value which will be set
     */
    inline void setDynCompression (::masc_main_fi_types::T_e8_DynCompression DynCompression_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    static const DynamicCompressionStatus &getDefaultInstance();

private:

    inline void set_has_DynCompression ();

    inline void clear_has_DynCompression ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::masc_main_fi_types::T_e8_DynCompression _DynCompression;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

};

/**
 * The set message of the property "DynamicCompression"
 * status of changed dynamic compression value.
 */
class DynamicCompressionSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DynamicCompressionSet ();

    /**
     * Copy constructor
     */
    inline  DynamicCompressionSet (const DynamicCompressionSet &rhs);

    /**
     * All fields constructor
     */
    inline  DynamicCompressionSet (::masc_main_fi_types::T_e8_DynCompression DynComp_, ::masc_main_fi_types::T_e8_ResourceNo Resource_);

    /**
     * Destructor
     */
    inline virtual  ~DynamicCompressionSet();

    /**
     * Assignment operator
     */
    inline DynamicCompressionSet& operator = (const DynamicCompressionSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DynamicCompressionSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DynamicCompressionSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DynamicCompressionSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DynamicCompressionSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DynComp"

    static const int kDynComp = 0;

    /**
     * Clears the field "DynComp".
     *
     * The field will be set to its default value. The hasDynComp()
     * method will return false.
     */
    inline void clearDynComp();

    /**
     * Checks whether the field "DynComp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDynComp()). Otherwise it will return false.
     */
    inline bool hasDynComp () const;

    /**
     * Returns the value of the member "DynComp".
     *
     * Dynamic compression value
     *
     * @return The value of the field "DynComp"
     */
    inline ::masc_main_fi_types::T_e8_DynCompression getDynComp () const;

    /**
     * Sets the value of the member "DynComp".
     *
     * Dynamic compression value
     *
     * @param DynComp The value which will be set
     */
    inline void setDynComp (::masc_main_fi_types::T_e8_DynCompression DynComp_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    static const DynamicCompressionSet &getDefaultInstance();

private:

    inline void set_has_DynComp ();

    inline void clear_has_DynComp ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::masc_main_fi_types::T_e8_DynCompression _DynComp;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

};

/**
 * The status message of the property "Optimization"
 * status of changed optimization value.
 */
class OptimizationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OptimizationStatus ();

    /**
     * Copy constructor
     */
    inline  OptimizationStatus (const OptimizationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  OptimizationStatus (::masc_main_fi_types::T_e8_Optimization Optimization_, ::masc_main_fi_types::T_e8_ResourceNo Resource_);

    /**
     * Destructor
     */
    inline virtual  ~OptimizationStatus();

    /**
     * Assignment operator
     */
    inline OptimizationStatus& operator = (const OptimizationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OptimizationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OptimizationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OptimizationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OptimizationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Optimization"

    static const int kOptimization = 0;

    /**
     * Clears the field "Optimization".
     *
     * The field will be set to its default value. The hasOptimization()
     * method will return false.
     */
    inline void clearOptimization();

    /**
     * Checks whether the field "Optimization" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOptimization()). Otherwise it will return false.
     */
    inline bool hasOptimization () const;

    /**
     * Returns the value of the member "Optimization".
     *
     * Optimization value
     *
     * @return The value of the field "Optimization"
     */
    inline ::masc_main_fi_types::T_e8_Optimization getOptimization () const;

    /**
     * Sets the value of the member "Optimization".
     *
     * Optimization value
     *
     * @param Optimization The value which will be set
     */
    inline void setOptimization (::masc_main_fi_types::T_e8_Optimization Optimization_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    static const OptimizationStatus &getDefaultInstance();

private:

    inline void set_has_Optimization ();

    inline void clear_has_Optimization ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::masc_main_fi_types::T_e8_Optimization _Optimization;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

};

/**
 * The set message of the property "Optimization"
 * status of changed optimization value.
 */
class OptimizationSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OptimizationSet ();

    /**
     * Copy constructor
     */
    inline  OptimizationSet (const OptimizationSet &rhs);

    /**
     * All fields constructor
     */
    inline  OptimizationSet (::masc_main_fi_types::T_e8_Optimization Optimization_, ::masc_main_fi_types::T_e8_ResourceNo Resource_);

    /**
     * Destructor
     */
    inline virtual  ~OptimizationSet();

    /**
     * Assignment operator
     */
    inline OptimizationSet& operator = (const OptimizationSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OptimizationSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OptimizationSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OptimizationSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OptimizationSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Optimization"

    static const int kOptimization = 0;

    /**
     * Clears the field "Optimization".
     *
     * The field will be set to its default value. The hasOptimization()
     * method will return false.
     */
    inline void clearOptimization();

    /**
     * Checks whether the field "Optimization" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOptimization()). Otherwise it will return false.
     */
    inline bool hasOptimization () const;

    /**
     * Returns the value of the member "Optimization".
     *
     * Optimization value
     *
     * @return The value of the field "Optimization"
     */
    inline ::masc_main_fi_types::T_e8_Optimization getOptimization () const;

    /**
     * Sets the value of the member "Optimization".
     *
     * Optimization value
     *
     * @param Optimization The value which will be set
     */
    inline void setOptimization (::masc_main_fi_types::T_e8_Optimization Optimization_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    static const OptimizationSet &getDefaultInstance();

private:

    inline void set_has_Optimization ();

    inline void clear_has_Optimization ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::masc_main_fi_types::T_e8_Optimization _Optimization;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

};

/**
 * The status message of the property "EqualiserPreset"
 * status of changed equaliser preset.
 */
class EqualiserPresetStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EqualiserPresetStatus ();

    /**
     * Copy constructor
     */
    inline  EqualiserPresetStatus (const EqualiserPresetStatus &rhs);

    /**
     * All fields constructor
     */
    inline  EqualiserPresetStatus (::masc_main_fi_types::T_e8_EquPresets EquPreset_, ::masc_main_fi_types::T_e8_ResourceNo Resource_);

    /**
     * Destructor
     */
    inline virtual  ~EqualiserPresetStatus();

    /**
     * Assignment operator
     */
    inline EqualiserPresetStatus& operator = (const EqualiserPresetStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EqualiserPresetStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EqualiserPresetStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EqualiserPresetStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EqualiserPresetStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "EquPreset"

    static const int kEquPreset = 0;

    /**
     * Clears the field "EquPreset".
     *
     * The field will be set to its default value. The hasEquPreset()
     * method will return false.
     */
    inline void clearEquPreset();

    /**
     * Checks whether the field "EquPreset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEquPreset()). Otherwise it will return false.
     */
    inline bool hasEquPreset () const;

    /**
     * Returns the value of the member "EquPreset".
     *
     * Equaliser preset value
     *
     * @return The value of the field "EquPreset"
     */
    inline ::masc_main_fi_types::T_e8_EquPresets getEquPreset () const;

    /**
     * Sets the value of the member "EquPreset".
     *
     * Equaliser preset value
     *
     * @param EquPreset The value which will be set
     */
    inline void setEquPreset (::masc_main_fi_types::T_e8_EquPresets EquPreset_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    static const EqualiserPresetStatus &getDefaultInstance();

private:

    inline void set_has_EquPreset ();

    inline void clear_has_EquPreset ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::masc_main_fi_types::T_e8_EquPresets _EquPreset;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

};

/**
 * The set message of the property "EqualiserPreset"
 * status of changed equaliser preset.
 */
class EqualiserPresetSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EqualiserPresetSet ();

    /**
     * Copy constructor
     */
    inline  EqualiserPresetSet (const EqualiserPresetSet &rhs);

    /**
     * All fields constructor
     */
    inline  EqualiserPresetSet (::masc_main_fi_types::T_e8_EquPresets EquPreset_, ::masc_main_fi_types::T_e8_ResourceNo Resource_);

    /**
     * Destructor
     */
    inline virtual  ~EqualiserPresetSet();

    /**
     * Assignment operator
     */
    inline EqualiserPresetSet& operator = (const EqualiserPresetSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EqualiserPresetSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EqualiserPresetSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EqualiserPresetSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EqualiserPresetSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "EquPreset"

    static const int kEquPreset = 0;

    /**
     * Clears the field "EquPreset".
     *
     * The field will be set to its default value. The hasEquPreset()
     * method will return false.
     */
    inline void clearEquPreset();

    /**
     * Checks whether the field "EquPreset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEquPreset()). Otherwise it will return false.
     */
    inline bool hasEquPreset () const;

    /**
     * Returns the value of the member "EquPreset".
     *
     * Equaliser preset value
     *
     * @return The value of the field "EquPreset"
     */
    inline ::masc_main_fi_types::T_e8_EquPresets getEquPreset () const;

    /**
     * Sets the value of the member "EquPreset".
     *
     * Equaliser preset value
     *
     * @param EquPreset The value which will be set
     */
    inline void setEquPreset (::masc_main_fi_types::T_e8_EquPresets EquPreset_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    static const EqualiserPresetSet &getDefaultInstance();

private:

    inline void set_has_EquPreset ();

    inline void clear_has_EquPreset ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::masc_main_fi_types::T_e8_EquPresets _EquPreset;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

};

/**
 * The status message of the property "DiagAudMode"
 * status of changed audio mode.
 */
class DiagAudModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiagAudModeStatus ();

    /**
     * Copy constructor
     */
    inline  DiagAudModeStatus (const DiagAudModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiagAudModeStatus (::masc_main_fi_types::T_e8_DiagAudMode DiagAudMode_, ::masc_main_fi_types::T_e8_GenericDiagAudMode OnVolLimiterMode_, ::masc_main_fi_types::T_e8_GenericDiagAudMode MuteRampMode_, ::masc_main_fi_types::T_e8_GenericDiagAudMode VolumeRampMode_, ::masc_main_fi_types::T_e8_GenericDiagAudMode clippingMode_, ::masc_main_fi_types::T_e8_GenericDiagAudMode PresetMode_);

    /**
     * Destructor
     */
    inline virtual  ~DiagAudModeStatus();

    /**
     * Assignment operator
     */
    inline DiagAudModeStatus& operator = (const DiagAudModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiagAudModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiagAudModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiagAudModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiagAudModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DiagAudMode"

    static const int kDiagAudMode = 0;

    /**
     * Clears the field "DiagAudMode".
     *
     * The field will be set to its default value. The hasDiagAudMode()
     * method will return false.
     */
    inline void clearDiagAudMode();

    /**
     * Checks whether the field "DiagAudMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDiagAudMode()). Otherwise it will return false.
     */
    inline bool hasDiagAudMode () const;

    /**
     * Returns the value of the member "DiagAudMode".
     *
     * Diag Audio mode value
     *
     * @return The value of the field "DiagAudMode"
     */
    inline ::masc_main_fi_types::T_e8_DiagAudMode getDiagAudMode () const;

    /**
     * Sets the value of the member "DiagAudMode".
     *
     * Diag Audio mode value
     *
     * @param DiagAudMode The value which will be set
     */
    inline void setDiagAudMode (::masc_main_fi_types::T_e8_DiagAudMode DiagAudMode_);

    // API of field "OnVolLimiterMode"

    static const int kOnVolLimiterMode = 1;

    /**
     * Clears the field "OnVolLimiterMode".
     *
     * The field will be set to its default value. The hasOnVolLimiterMode()
     * method will return false.
     */
    inline void clearOnVolLimiterMode();

    /**
     * Checks whether the field "OnVolLimiterMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOnVolLimiterMode()). Otherwise it will return false.
     */
    inline bool hasOnVolLimiterMode () const;

    /**
     * Returns the value of the member "OnVolLimiterMode".
     *
     * Audio Diag mode On volume limitter On/Off/Not valid
     *
     * @return The value of the field "OnVolLimiterMode"
     */
    inline ::masc_main_fi_types::T_e8_GenericDiagAudMode getOnVolLimiterMode () const;

    /**
     * Sets the value of the member "OnVolLimiterMode".
     *
     * Audio Diag mode On volume limitter On/Off/Not valid
     *
     * @param OnVolLimiterMode The value which will be set
     */
    inline void setOnVolLimiterMode (::masc_main_fi_types::T_e8_GenericDiagAudMode OnVolLimiterMode_);

    // API of field "MuteRampMode"

    static const int kMuteRampMode = 2;

    /**
     * Clears the field "MuteRampMode".
     *
     * The field will be set to its default value. The hasMuteRampMode()
     * method will return false.
     */
    inline void clearMuteRampMode();

    /**
     * Checks whether the field "MuteRampMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMuteRampMode()). Otherwise it will return false.
     */
    inline bool hasMuteRampMode () const;

    /**
     * Returns the value of the member "MuteRampMode".
     *
     * Audio Diag mode Mute Ramp On/Off/Not valid
     *
     * @return The value of the field "MuteRampMode"
     */
    inline ::masc_main_fi_types::T_e8_GenericDiagAudMode getMuteRampMode () const;

    /**
     * Sets the value of the member "MuteRampMode".
     *
     * Audio Diag mode Mute Ramp On/Off/Not valid
     *
     * @param MuteRampMode The value which will be set
     */
    inline void setMuteRampMode (::masc_main_fi_types::T_e8_GenericDiagAudMode MuteRampMode_);

    // API of field "VolumeRampMode"

    static const int kVolumeRampMode = 3;

    /**
     * Clears the field "VolumeRampMode".
     *
     * The field will be set to its default value. The hasVolumeRampMode()
     * method will return false.
     */
    inline void clearVolumeRampMode();

    /**
     * Checks whether the field "VolumeRampMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolumeRampMode()). Otherwise it will return false.
     */
    inline bool hasVolumeRampMode () const;

    /**
     * Returns the value of the member "VolumeRampMode".
     *
     * Audio Diag mode Volume Ramp On/off/Not valid
     *
     * @return The value of the field "VolumeRampMode"
     */
    inline ::masc_main_fi_types::T_e8_GenericDiagAudMode getVolumeRampMode () const;

    /**
     * Sets the value of the member "VolumeRampMode".
     *
     * Audio Diag mode Volume Ramp On/off/Not valid
     *
     * @param VolumeRampMode The value which will be set
     */
    inline void setVolumeRampMode (::masc_main_fi_types::T_e8_GenericDiagAudMode VolumeRampMode_);

    // API of field "clippingMode"

    static const int kClippingMode = 4;

    /**
     * Clears the field "clippingMode".
     *
     * The field will be set to its default value. The hasClippingMode()
     * method will return false.
     */
    inline void clearClippingMode();

    /**
     * Checks whether the field "clippingMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClippingMode()). Otherwise it will return false.
     */
    inline bool hasClippingMode () const;

    /**
     * Returns the value of the member "clippingMode".
     *
     * Audio Diag mode Clipping on/off/Not valid
     *
     * @return The value of the field "clippingMode"
     */
    inline ::masc_main_fi_types::T_e8_GenericDiagAudMode getClippingMode () const;

    /**
     * Sets the value of the member "clippingMode".
     *
     * Audio Diag mode Clipping on/off/Not valid
     *
     * @param clippingMode The value which will be set
     */
    inline void setClippingMode (::masc_main_fi_types::T_e8_GenericDiagAudMode clippingMode_);

    // API of field "PresetMode"

    static const int kPresetMode = 5;

    /**
     * Clears the field "PresetMode".
     *
     * The field will be set to its default value. The hasPresetMode()
     * method will return false.
     */
    inline void clearPresetMode();

    /**
     * Checks whether the field "PresetMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetMode()). Otherwise it will return false.
     */
    inline bool hasPresetMode () const;

    /**
     * Returns the value of the member "PresetMode".
     *
     * Enabling or disabling of Preset Level Adjustment. Applicable for VW_LL_TFT
     * Project
     *
     * @return The value of the field "PresetMode"
     */
    inline ::masc_main_fi_types::T_e8_GenericDiagAudMode getPresetMode () const;

    /**
     * Sets the value of the member "PresetMode".
     *
     * Enabling or disabling of Preset Level Adjustment. Applicable for VW_LL_TFT
     * Project
     *
     * @param PresetMode The value which will be set
     */
    inline void setPresetMode (::masc_main_fi_types::T_e8_GenericDiagAudMode PresetMode_);

    static const DiagAudModeStatus &getDefaultInstance();

private:

    inline void set_has_DiagAudMode ();

    inline void clear_has_DiagAudMode ();

    inline void set_has_OnVolLimiterMode ();

    inline void clear_has_OnVolLimiterMode ();

    inline void set_has_MuteRampMode ();

    inline void clear_has_MuteRampMode ();

    inline void set_has_VolumeRampMode ();

    inline void clear_has_VolumeRampMode ();

    inline void set_has_clippingMode ();

    inline void clear_has_clippingMode ();

    inline void set_has_PresetMode ();

    inline void clear_has_PresetMode ();

    uint32 _has_bits_[ (6 + 31) / 32];

    ::masc_main_fi_types::T_e8_DiagAudMode _DiagAudMode;

    ::masc_main_fi_types::T_e8_GenericDiagAudMode _OnVolLimiterMode;

    ::masc_main_fi_types::T_e8_GenericDiagAudMode _MuteRampMode;

    ::masc_main_fi_types::T_e8_GenericDiagAudMode _VolumeRampMode;

    ::masc_main_fi_types::T_e8_GenericDiagAudMode _clippingMode;

    ::masc_main_fi_types::T_e8_GenericDiagAudMode _PresetMode;

};

/**
 * The set message of the property "DiagAudMode"
 * status of changed audio mode.
 */
class DiagAudModeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiagAudModeSet ();

    /**
     * Copy constructor
     */
    inline  DiagAudModeSet (const DiagAudModeSet &rhs);

    /**
     * All fields constructor
     */
    inline  DiagAudModeSet (::masc_main_fi_types::T_e8_DiagAudMode DiagAudMode_, ::masc_main_fi_types::T_e8_GenericDiagAudMode OnVolLimiterMode_, ::masc_main_fi_types::T_e8_GenericDiagAudMode MuteRampMode_, ::masc_main_fi_types::T_e8_GenericDiagAudMode VolumeRampMode_, ::masc_main_fi_types::T_e8_GenericDiagAudMode clippingMode_, ::masc_main_fi_types::T_e8_GenericDiagAudMode PresetMode_);

    /**
     * Destructor
     */
    inline virtual  ~DiagAudModeSet();

    /**
     * Assignment operator
     */
    inline DiagAudModeSet& operator = (const DiagAudModeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiagAudModeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiagAudModeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiagAudModeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiagAudModeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DiagAudMode"

    static const int kDiagAudMode = 0;

    /**
     * Clears the field "DiagAudMode".
     *
     * The field will be set to its default value. The hasDiagAudMode()
     * method will return false.
     */
    inline void clearDiagAudMode();

    /**
     * Checks whether the field "DiagAudMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDiagAudMode()). Otherwise it will return false.
     */
    inline bool hasDiagAudMode () const;

    /**
     * Returns the value of the member "DiagAudMode".
     *
     * Audio Diag mode linear/normal. Applicable for FORD and VW_LL_TFT Projects
     *
     * @return The value of the field "DiagAudMode"
     */
    inline ::masc_main_fi_types::T_e8_DiagAudMode getDiagAudMode () const;

    /**
     * Sets the value of the member "DiagAudMode".
     *
     * Audio Diag mode linear/normal. Applicable for FORD and VW_LL_TFT Projects
     *
     * @param DiagAudMode The value which will be set
     */
    inline void setDiagAudMode (::masc_main_fi_types::T_e8_DiagAudMode DiagAudMode_);

    // API of field "OnVolLimiterMode"

    static const int kOnVolLimiterMode = 1;

    /**
     * Clears the field "OnVolLimiterMode".
     *
     * The field will be set to its default value. The hasOnVolLimiterMode()
     * method will return false.
     */
    inline void clearOnVolLimiterMode();

    /**
     * Checks whether the field "OnVolLimiterMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOnVolLimiterMode()). Otherwise it will return false.
     */
    inline bool hasOnVolLimiterMode () const;

    /**
     * Returns the value of the member "OnVolLimiterMode".
     *
     * Audio Diag mode On volume limitter On/Off/Not valid. Applicable for VW_LL_TFT
     * Project
     *
     * @return The value of the field "OnVolLimiterMode"
     */
    inline ::masc_main_fi_types::T_e8_GenericDiagAudMode getOnVolLimiterMode () const;

    /**
     * Sets the value of the member "OnVolLimiterMode".
     *
     * Audio Diag mode On volume limitter On/Off/Not valid. Applicable for VW_LL_TFT
     * Project
     *
     * @param OnVolLimiterMode The value which will be set
     */
    inline void setOnVolLimiterMode (::masc_main_fi_types::T_e8_GenericDiagAudMode OnVolLimiterMode_);

    // API of field "MuteRampMode"

    static const int kMuteRampMode = 2;

    /**
     * Clears the field "MuteRampMode".
     *
     * The field will be set to its default value. The hasMuteRampMode()
     * method will return false.
     */
    inline void clearMuteRampMode();

    /**
     * Checks whether the field "MuteRampMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMuteRampMode()). Otherwise it will return false.
     */
    inline bool hasMuteRampMode () const;

    /**
     * Returns the value of the member "MuteRampMode".
     *
     * Audio Diag mode Mute Ramp On/Off/Not valid. Applicable for VW_LL_TFT Project
     *
     * @return The value of the field "MuteRampMode"
     */
    inline ::masc_main_fi_types::T_e8_GenericDiagAudMode getMuteRampMode () const;

    /**
     * Sets the value of the member "MuteRampMode".
     *
     * Audio Diag mode Mute Ramp On/Off/Not valid. Applicable for VW_LL_TFT Project
     *
     * @param MuteRampMode The value which will be set
     */
    inline void setMuteRampMode (::masc_main_fi_types::T_e8_GenericDiagAudMode MuteRampMode_);

    // API of field "VolumeRampMode"

    static const int kVolumeRampMode = 3;

    /**
     * Clears the field "VolumeRampMode".
     *
     * The field will be set to its default value. The hasVolumeRampMode()
     * method will return false.
     */
    inline void clearVolumeRampMode();

    /**
     * Checks whether the field "VolumeRampMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolumeRampMode()). Otherwise it will return false.
     */
    inline bool hasVolumeRampMode () const;

    /**
     * Returns the value of the member "VolumeRampMode".
     *
     * Audio Diag mode Volume Ramp On/off/Not valid. Applicable for VW_LL_TFT Project
     *
     * @return The value of the field "VolumeRampMode"
     */
    inline ::masc_main_fi_types::T_e8_GenericDiagAudMode getVolumeRampMode () const;

    /**
     * Sets the value of the member "VolumeRampMode".
     *
     * Audio Diag mode Volume Ramp On/off/Not valid. Applicable for VW_LL_TFT Project
     *
     * @param VolumeRampMode The value which will be set
     */
    inline void setVolumeRampMode (::masc_main_fi_types::T_e8_GenericDiagAudMode VolumeRampMode_);

    // API of field "clippingMode"

    static const int kClippingMode = 4;

    /**
     * Clears the field "clippingMode".
     *
     * The field will be set to its default value. The hasClippingMode()
     * method will return false.
     */
    inline void clearClippingMode();

    /**
     * Checks whether the field "clippingMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClippingMode()). Otherwise it will return false.
     */
    inline bool hasClippingMode () const;

    /**
     * Returns the value of the member "clippingMode".
     *
     * Audio Diag mode Clipping on/off/Not valid. Applicable for VW_LL_TFT Project
     *
     * @return The value of the field "clippingMode"
     */
    inline ::masc_main_fi_types::T_e8_GenericDiagAudMode getClippingMode () const;

    /**
     * Sets the value of the member "clippingMode".
     *
     * Audio Diag mode Clipping on/off/Not valid. Applicable for VW_LL_TFT Project
     *
     * @param clippingMode The value which will be set
     */
    inline void setClippingMode (::masc_main_fi_types::T_e8_GenericDiagAudMode clippingMode_);

    // API of field "PresetMode"

    static const int kPresetMode = 5;

    /**
     * Clears the field "PresetMode".
     *
     * The field will be set to its default value. The hasPresetMode()
     * method will return false.
     */
    inline void clearPresetMode();

    /**
     * Checks whether the field "PresetMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetMode()). Otherwise it will return false.
     */
    inline bool hasPresetMode () const;

    /**
     * Returns the value of the member "PresetMode".
     *
     * Enabling or disabling of Preset Level Adjustment. Applicable for VW_LL_TFT
     * Project
     *
     * @return The value of the field "PresetMode"
     */
    inline ::masc_main_fi_types::T_e8_GenericDiagAudMode getPresetMode () const;

    /**
     * Sets the value of the member "PresetMode".
     *
     * Enabling or disabling of Preset Level Adjustment. Applicable for VW_LL_TFT
     * Project
     *
     * @param PresetMode The value which will be set
     */
    inline void setPresetMode (::masc_main_fi_types::T_e8_GenericDiagAudMode PresetMode_);

    static const DiagAudModeSet &getDefaultInstance();

private:

    inline void set_has_DiagAudMode ();

    inline void clear_has_DiagAudMode ();

    inline void set_has_OnVolLimiterMode ();

    inline void clear_has_OnVolLimiterMode ();

    inline void set_has_MuteRampMode ();

    inline void clear_has_MuteRampMode ();

    inline void set_has_VolumeRampMode ();

    inline void clear_has_VolumeRampMode ();

    inline void set_has_clippingMode ();

    inline void clear_has_clippingMode ();

    inline void set_has_PresetMode ();

    inline void clear_has_PresetMode ();

    uint32 _has_bits_[ (6 + 31) / 32];

    ::masc_main_fi_types::T_e8_DiagAudMode _DiagAudMode;

    ::masc_main_fi_types::T_e8_GenericDiagAudMode _OnVolLimiterMode;

    ::masc_main_fi_types::T_e8_GenericDiagAudMode _MuteRampMode;

    ::masc_main_fi_types::T_e8_GenericDiagAudMode _VolumeRampMode;

    ::masc_main_fi_types::T_e8_GenericDiagAudMode _clippingMode;

    ::masc_main_fi_types::T_e8_GenericDiagAudMode _PresetMode;

};

/**
 * The status message of the property "AuxInLevel"
 * status of changed audio mode.
 */
class AuxInLevelStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AuxInLevelStatus ();

    /**
     * Copy constructor
     */
    inline  AuxInLevelStatus (const AuxInLevelStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AuxInLevelStatus (::masc_main_fi_types::T_e8_AuxInLevel AuxInLevel_);

    /**
     * Destructor
     */
    inline virtual  ~AuxInLevelStatus();

    /**
     * Assignment operator
     */
    inline AuxInLevelStatus& operator = (const AuxInLevelStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AuxInLevelStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AuxInLevelStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AuxInLevelStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AuxInLevelStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AuxInLevel"

    static const int kAuxInLevel = 0;

    /**
     * Clears the field "AuxInLevel".
     *
     * The field will be set to its default value. The hasAuxInLevel()
     * method will return false.
     */
    inline void clearAuxInLevel();

    /**
     * Checks whether the field "AuxInLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAuxInLevel()). Otherwise it will return false.
     */
    inline bool hasAuxInLevel () const;

    /**
     * Returns the value of the member "AuxInLevel".
     *
     * AUX-Sensivity Level
     *
     * @return The value of the field "AuxInLevel"
     */
    inline ::masc_main_fi_types::T_e8_AuxInLevel getAuxInLevel () const;

    /**
     * Sets the value of the member "AuxInLevel".
     *
     * AUX-Sensivity Level
     *
     * @param AuxInLevel The value which will be set
     */
    inline void setAuxInLevel (::masc_main_fi_types::T_e8_AuxInLevel AuxInLevel_);

    static const AuxInLevelStatus &getDefaultInstance();

private:

    inline void set_has_AuxInLevel ();

    inline void clear_has_AuxInLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_AuxInLevel _AuxInLevel;

};

/**
 * The set message of the property "AuxInLevel"
 * status of changed audio mode.
 */
class AuxInLevelSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AuxInLevelSet ();

    /**
     * Copy constructor
     */
    inline  AuxInLevelSet (const AuxInLevelSet &rhs);

    /**
     * All fields constructor
     */
    inline  AuxInLevelSet (::masc_main_fi_types::T_e8_AuxInLevel AuxInLevel_);

    /**
     * Destructor
     */
    inline virtual  ~AuxInLevelSet();

    /**
     * Assignment operator
     */
    inline AuxInLevelSet& operator = (const AuxInLevelSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AuxInLevelSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AuxInLevelSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AuxInLevelSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AuxInLevelSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AuxInLevel"

    static const int kAuxInLevel = 0;

    /**
     * Clears the field "AuxInLevel".
     *
     * The field will be set to its default value. The hasAuxInLevel()
     * method will return false.
     */
    inline void clearAuxInLevel();

    /**
     * Checks whether the field "AuxInLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAuxInLevel()). Otherwise it will return false.
     */
    inline bool hasAuxInLevel () const;

    /**
     * Returns the value of the member "AuxInLevel".
     *
     * Input AUX-Sensivity Level
     *
     * @return The value of the field "AuxInLevel"
     */
    inline ::masc_main_fi_types::T_e8_AuxInLevel getAuxInLevel () const;

    /**
     * Sets the value of the member "AuxInLevel".
     *
     * Input AUX-Sensivity Level
     *
     * @param AuxInLevel The value which will be set
     */
    inline void setAuxInLevel (::masc_main_fi_types::T_e8_AuxInLevel AuxInLevel_);

    static const AuxInLevelSet &getDefaultInstance();

private:

    inline void set_has_AuxInLevel ();

    inline void clear_has_AuxInLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_AuxInLevel _AuxInLevel;

};

/**
 * The status message of the property "BeepLevel"
 * Beep Level can be set in FC_AudioManager through this interface.
 */
class BeepLevelStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BeepLevelStatus ();

    /**
     * Copy constructor
     */
    inline  BeepLevelStatus (const BeepLevelStatus &rhs);

    /**
     * All fields constructor
     */
    inline  BeepLevelStatus (::masc_main_fi_types::T_e8_BeepLevel BeepLevel_);

    /**
     * Destructor
     */
    inline virtual  ~BeepLevelStatus();

    /**
     * Assignment operator
     */
    inline BeepLevelStatus& operator = (const BeepLevelStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BeepLevelStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BeepLevelStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BeepLevelStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BeepLevelStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BeepLevel"

    static const int kBeepLevel = 0;

    /**
     * Clears the field "BeepLevel".
     *
     * The field will be set to its default value. The hasBeepLevel()
     * method will return false.
     */
    inline void clearBeepLevel();

    /**
     * Checks whether the field "BeepLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBeepLevel()). Otherwise it will return false.
     */
    inline bool hasBeepLevel () const;

    /**
     * Returns the value of the member "BeepLevel".
     *
     * Beep Level
     *
     * @return The value of the field "BeepLevel"
     */
    inline ::masc_main_fi_types::T_e8_BeepLevel getBeepLevel () const;

    /**
     * Sets the value of the member "BeepLevel".
     *
     * Beep Level
     *
     * @param BeepLevel The value which will be set
     */
    inline void setBeepLevel (::masc_main_fi_types::T_e8_BeepLevel BeepLevel_);

    static const BeepLevelStatus &getDefaultInstance();

private:

    inline void set_has_BeepLevel ();

    inline void clear_has_BeepLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_BeepLevel _BeepLevel;

};

/**
 * The set message of the property "BeepLevel"
 * Beep Level can be set in FC_AudioManager through this interface.
 */
class BeepLevelSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BeepLevelSet ();

    /**
     * Copy constructor
     */
    inline  BeepLevelSet (const BeepLevelSet &rhs);

    /**
     * All fields constructor
     */
    inline  BeepLevelSet (::masc_main_fi_types::T_e8_BeepLevel BeepLevel_);

    /**
     * Destructor
     */
    inline virtual  ~BeepLevelSet();

    /**
     * Assignment operator
     */
    inline BeepLevelSet& operator = (const BeepLevelSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BeepLevelSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BeepLevelSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BeepLevelSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BeepLevelSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BeepLevel"

    static const int kBeepLevel = 0;

    /**
     * Clears the field "BeepLevel".
     *
     * The field will be set to its default value. The hasBeepLevel()
     * method will return false.
     */
    inline void clearBeepLevel();

    /**
     * Checks whether the field "BeepLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBeepLevel()). Otherwise it will return false.
     */
    inline bool hasBeepLevel () const;

    /**
     * Returns the value of the member "BeepLevel".
     *
     * Input Beep Level
     *
     * @return The value of the field "BeepLevel"
     */
    inline ::masc_main_fi_types::T_e8_BeepLevel getBeepLevel () const;

    /**
     * Sets the value of the member "BeepLevel".
     *
     * Input Beep Level
     *
     * @param BeepLevel The value which will be set
     */
    inline void setBeepLevel (::masc_main_fi_types::T_e8_BeepLevel BeepLevel_);

    static const BeepLevelSet &getDefaultInstance();

private:

    inline void set_has_BeepLevel ();

    inline void clear_has_BeepLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_BeepLevel _BeepLevel;

};

/**
 * The status message of the property "Rear_Mute"
 * RearMute Level can be set in FC_AudioManager through this interface.
 */
class Rear_MuteStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Rear_MuteStatus ();

    /**
     * Copy constructor
     */
    inline  Rear_MuteStatus (const Rear_MuteStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Rear_MuteStatus (::masc_main_fi_types::T_e8_Rear_Mute Rear_Mute_);

    /**
     * Destructor
     */
    inline virtual  ~Rear_MuteStatus();

    /**
     * Assignment operator
     */
    inline Rear_MuteStatus& operator = (const Rear_MuteStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Rear_MuteStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Rear_MuteStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Rear_MuteStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Rear_MuteStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Rear_Mute"

    static const int kRear_Mute = 0;

    /**
     * Clears the field "Rear_Mute".
     *
     * The field will be set to its default value. The hasRear_Mute()
     * method will return false.
     */
    inline void clearRear_Mute();

    /**
     * Checks whether the field "Rear_Mute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRear_Mute()). Otherwise it will return false.
     */
    inline bool hasRear_Mute () const;

    /**
     * Returns the value of the member "Rear_Mute".
     *
     * Children sleep mode
     *
     * @return The value of the field "Rear_Mute"
     */
    inline ::masc_main_fi_types::T_e8_Rear_Mute getRear_Mute () const;

    /**
     * Sets the value of the member "Rear_Mute".
     *
     * Children sleep mode
     *
     * @param Rear_Mute The value which will be set
     */
    inline void setRear_Mute (::masc_main_fi_types::T_e8_Rear_Mute Rear_Mute_);

    static const Rear_MuteStatus &getDefaultInstance();

private:

    inline void set_has_Rear_Mute ();

    inline void clear_has_Rear_Mute ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_Rear_Mute _Rear_Mute;

};

/**
 * The set message of the property "Rear_Mute"
 * RearMute Level can be set in FC_AudioManager through this interface.
 */
class Rear_MuteSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Rear_MuteSet ();

    /**
     * Copy constructor
     */
    inline  Rear_MuteSet (const Rear_MuteSet &rhs);

    /**
     * All fields constructor
     */
    inline  Rear_MuteSet (::masc_main_fi_types::T_e8_Rear_Mute Rear_Mute_);

    /**
     * Destructor
     */
    inline virtual  ~Rear_MuteSet();

    /**
     * Assignment operator
     */
    inline Rear_MuteSet& operator = (const Rear_MuteSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Rear_MuteSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Rear_MuteSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Rear_MuteSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Rear_MuteSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Rear_Mute"

    static const int kRear_Mute = 0;

    /**
     * Clears the field "Rear_Mute".
     *
     * The field will be set to its default value. The hasRear_Mute()
     * method will return false.
     */
    inline void clearRear_Mute();

    /**
     * Checks whether the field "Rear_Mute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRear_Mute()). Otherwise it will return false.
     */
    inline bool hasRear_Mute () const;

    /**
     * Returns the value of the member "Rear_Mute".
     *
     * children sleep mode
     *
     * @return The value of the field "Rear_Mute"
     */
    inline ::masc_main_fi_types::T_e8_Rear_Mute getRear_Mute () const;

    /**
     * Sets the value of the member "Rear_Mute".
     *
     * children sleep mode
     *
     * @param Rear_Mute The value which will be set
     */
    inline void setRear_Mute (::masc_main_fi_types::T_e8_Rear_Mute Rear_Mute_);

    static const Rear_MuteSet &getDefaultInstance();

private:

    inline void set_has_Rear_Mute ();

    inline void clear_has_Rear_Mute ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_Rear_Mute _Rear_Mute;

};

/**
 * The status message of the property "Geometry_Mode"
 * Geometry mode is set in FC_AudioManager through this interface.
 */
class Geometry_ModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Geometry_ModeStatus ();

    /**
     * Copy constructor
     */
    inline  Geometry_ModeStatus (const Geometry_ModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Geometry_ModeStatus (::masc_main_fi_types::T_e8_Geometry_Mode Geometry_Mode_);

    /**
     * Destructor
     */
    inline virtual  ~Geometry_ModeStatus();

    /**
     * Assignment operator
     */
    inline Geometry_ModeStatus& operator = (const Geometry_ModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Geometry_ModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Geometry_ModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Geometry_ModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Geometry_ModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Geometry_Mode"

    static const int kGeometry_Mode = 0;

    /**
     * Clears the field "Geometry_Mode".
     *
     * The field will be set to its default value. The hasGeometry_Mode()
     * method will return false.
     */
    inline void clearGeometry_Mode();

    /**
     * Checks whether the field "Geometry_Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGeometry_Mode()). Otherwise it will return false.
     */
    inline bool hasGeometry_Mode () const;

    /**
     * Returns the value of the member "Geometry_Mode".
     *
     * Geometry mode
     *
     * @return The value of the field "Geometry_Mode"
     */
    inline ::masc_main_fi_types::T_e8_Geometry_Mode getGeometry_Mode () const;

    /**
     * Sets the value of the member "Geometry_Mode".
     *
     * Geometry mode
     *
     * @param Geometry_Mode The value which will be set
     */
    inline void setGeometry_Mode (::masc_main_fi_types::T_e8_Geometry_Mode Geometry_Mode_);

    static const Geometry_ModeStatus &getDefaultInstance();

private:

    inline void set_has_Geometry_Mode ();

    inline void clear_has_Geometry_Mode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_Geometry_Mode _Geometry_Mode;

};

/**
 * The set message of the property "Geometry_Mode"
 * Geometry mode is set in FC_AudioManager through this interface.
 */
class Geometry_ModeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Geometry_ModeSet ();

    /**
     * Copy constructor
     */
    inline  Geometry_ModeSet (const Geometry_ModeSet &rhs);

    /**
     * All fields constructor
     */
    inline  Geometry_ModeSet (::masc_main_fi_types::T_e8_Geometry_Mode Geometry_Mode_);

    /**
     * Destructor
     */
    inline virtual  ~Geometry_ModeSet();

    /**
     * Assignment operator
     */
    inline Geometry_ModeSet& operator = (const Geometry_ModeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Geometry_ModeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Geometry_ModeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Geometry_ModeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Geometry_ModeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Geometry_Mode"

    static const int kGeometry_Mode = 0;

    /**
     * Clears the field "Geometry_Mode".
     *
     * The field will be set to its default value. The hasGeometry_Mode()
     * method will return false.
     */
    inline void clearGeometry_Mode();

    /**
     * Checks whether the field "Geometry_Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGeometry_Mode()). Otherwise it will return false.
     */
    inline bool hasGeometry_Mode () const;

    /**
     * Returns the value of the member "Geometry_Mode".
     *
     * Geometry mode
     *
     * @return The value of the field "Geometry_Mode"
     */
    inline ::masc_main_fi_types::T_e8_Geometry_Mode getGeometry_Mode () const;

    /**
     * Sets the value of the member "Geometry_Mode".
     *
     * Geometry mode
     *
     * @param Geometry_Mode The value which will be set
     */
    inline void setGeometry_Mode (::masc_main_fi_types::T_e8_Geometry_Mode Geometry_Mode_);

    static const Geometry_ModeSet &getDefaultInstance();

private:

    inline void set_has_Geometry_Mode ();

    inline void clear_has_Geometry_Mode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_Geometry_Mode _Geometry_Mode;

};

/**
 * The status message of the property "LSValueStatus"
 * With this message, the present values of the audio management are transfered to the client software (mostly HMI).
 * Is is mainly used for to sysnchronize the client on startup, and in situations where serveral values can change spontanously.
 * This is the case at source change, where e.g. volume and toncontroler values might change.
 */
class LSValueStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LSValueStatusStatus ();

    /**
     * Copy constructor
     */
    inline  LSValueStatusStatus (const LSValueStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  LSValueStatusStatus (uint8 u8NaviSetupLs_);

    /**
     * Destructor
     */
    inline virtual  ~LSValueStatusStatus();

    /**
     * Assignment operator
     */
    inline LSValueStatusStatus& operator = (const LSValueStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LSValueStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LSValueStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LSValueStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LSValueStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8NaviSetupLs"

    static const int kU8NaviSetupLs = 0;

    /**
     * Clears the field "u8NaviSetupLs".
     *
     * The field will be set to its default value. The hasU8NaviSetupLs()
     * method will return false.
     */
    inline void clearU8NaviSetupLs();

    /**
     * Checks whether the field "u8NaviSetupLs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NaviSetupLs()). Otherwise it will return false.
     */
    inline bool hasU8NaviSetupLs () const;

    /**
     * Returns the value of the member "u8NaviSetupLs".
     *
     * Actual Nav Setup Loudspeakers Value.
     *
     * @return The value of the field "u8NaviSetupLs"
     */
    inline uint8 getU8NaviSetupLs () const;

    /**
     * Sets the value of the member "u8NaviSetupLs".
     *
     * Actual Nav Setup Loudspeakers Value.
     *
     * @param u8NaviSetupLs The value which will be set
     */
    inline void setU8NaviSetupLs (uint8 u8NaviSetupLs_);

    static const LSValueStatusStatus &getDefaultInstance();

private:

    inline void set_has_u8NaviSetupLs ();

    inline void clear_has_u8NaviSetupLs ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8NaviSetupLs;

};

/**
 * The status message of the property "PDCAttenuationLevel"
 * ONLY AVAILABLE IN VW-LL-TFT.  Status of changed audio mode GenericFI FunctionID
 */
class PDCAttenuationLevelStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PDCAttenuationLevelStatus ();

    /**
     * Copy constructor
     */
    inline  PDCAttenuationLevelStatus (const PDCAttenuationLevelStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PDCAttenuationLevelStatus (uint8 PDCAttenuationLevel_);

    /**
     * Destructor
     */
    inline virtual  ~PDCAttenuationLevelStatus();

    /**
     * Assignment operator
     */
    inline PDCAttenuationLevelStatus& operator = (const PDCAttenuationLevelStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PDCAttenuationLevelStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PDCAttenuationLevelStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PDCAttenuationLevelStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PDCAttenuationLevelStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PDCAttenuationLevel"

    static const int kPDCAttenuationLevel = 0;

    /**
     * Clears the field "PDCAttenuationLevel".
     *
     * The field will be set to its default value. The hasPDCAttenuationLevel()
     * method will return false.
     */
    inline void clearPDCAttenuationLevel();

    /**
     * Checks whether the field "PDCAttenuationLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPDCAttenuationLevel()). Otherwise it will return false.
     */
    inline bool hasPDCAttenuationLevel () const;

    /**
     * Returns the value of the member "PDCAttenuationLevel".
     *
     * PDCAttenuation Level Status (0x00 - 0xFF)
     *
     * @return The value of the field "PDCAttenuationLevel"
     */
    inline uint8 getPDCAttenuationLevel () const;

    /**
     * Sets the value of the member "PDCAttenuationLevel".
     *
     * PDCAttenuation Level Status (0x00 - 0xFF)
     *
     * @param PDCAttenuationLevel The value which will be set
     */
    inline void setPDCAttenuationLevel (uint8 PDCAttenuationLevel_);

    static const PDCAttenuationLevelStatus &getDefaultInstance();

private:

    inline void set_has_PDCAttenuationLevel ();

    inline void clear_has_PDCAttenuationLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _PDCAttenuationLevel;

};

/**
 * The set message of the property "PDCAttenuationLevel"
 * ONLY AVAILABLE IN VW-LL-TFT.  Status of changed audio mode GenericFI FunctionID
 */
class PDCAttenuationLevelSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PDCAttenuationLevelSet ();

    /**
     * Copy constructor
     */
    inline  PDCAttenuationLevelSet (const PDCAttenuationLevelSet &rhs);

    /**
     * All fields constructor
     */
    inline  PDCAttenuationLevelSet (uint8 PDCAttenutionLevel_);

    /**
     * Destructor
     */
    inline virtual  ~PDCAttenuationLevelSet();

    /**
     * Assignment operator
     */
    inline PDCAttenuationLevelSet& operator = (const PDCAttenuationLevelSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PDCAttenuationLevelSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PDCAttenuationLevelSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PDCAttenuationLevelSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PDCAttenuationLevelSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PDCAttenutionLevel"

    static const int kPDCAttenutionLevel = 0;

    /**
     * Clears the field "PDCAttenutionLevel".
     *
     * The field will be set to its default value. The hasPDCAttenutionLevel()
     * method will return false.
     */
    inline void clearPDCAttenutionLevel();

    /**
     * Checks whether the field "PDCAttenutionLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPDCAttenutionLevel()). Otherwise it will return false.
     */
    inline bool hasPDCAttenutionLevel () const;

    /**
     * Returns the value of the member "PDCAttenutionLevel".
     *
     * Absolute PDCAttenution Level
     *
     * @return The value of the field "PDCAttenutionLevel"
     */
    inline uint8 getPDCAttenutionLevel () const;

    /**
     * Sets the value of the member "PDCAttenutionLevel".
     *
     * Absolute PDCAttenution Level
     *
     * @param PDCAttenutionLevel The value which will be set
     */
    inline void setPDCAttenutionLevel (uint8 PDCAttenutionLevel_);

    static const PDCAttenuationLevelSet &getDefaultInstance();

private:

    inline void set_has_PDCAttenutionLevel ();

    inline void clear_has_PDCAttenutionLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _PDCAttenutionLevel;

};

/**
 * The status message of the property "PDCAttenuation"
 * ONLY AVAILABLE IN VW-LL-TFT. Status of ongoing PDCAttenuation.
 */
class PDCAttenuationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PDCAttenuationStatus ();

    /**
     * Copy constructor
     */
    inline  PDCAttenuationStatus (const PDCAttenuationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PDCAttenuationStatus (::masc_main_fi_types::T_e8_PDCAttenuation PDCAttenuation_);

    /**
     * Destructor
     */
    inline virtual  ~PDCAttenuationStatus();

    /**
     * Assignment operator
     */
    inline PDCAttenuationStatus& operator = (const PDCAttenuationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PDCAttenuationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PDCAttenuationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PDCAttenuationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PDCAttenuationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PDCAttenuation"

    static const int kPDCAttenuation = 0;

    /**
     * Clears the field "PDCAttenuation".
     *
     * The field will be set to its default value. The hasPDCAttenuation()
     * method will return false.
     */
    inline void clearPDCAttenuation();

    /**
     * Checks whether the field "PDCAttenuation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPDCAttenuation()). Otherwise it will return false.
     */
    inline bool hasPDCAttenuation () const;

    /**
     * Returns the value of the member "PDCAttenuation".
     *
     * PDCAttenuation Status (running, stopped, ...)
     *
     * @return The value of the field "PDCAttenuation"
     */
    inline ::masc_main_fi_types::T_e8_PDCAttenuation getPDCAttenuation () const;

    /**
     * Sets the value of the member "PDCAttenuation".
     *
     * PDCAttenuation Status (running, stopped, ...)
     *
     * @param PDCAttenuation The value which will be set
     */
    inline void setPDCAttenuation (::masc_main_fi_types::T_e8_PDCAttenuation PDCAttenuation_);

    static const PDCAttenuationStatus &getDefaultInstance();

private:

    inline void set_has_PDCAttenuation ();

    inline void clear_has_PDCAttenuation ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_PDCAttenuation _PDCAttenuation;

};

/**
 * The set message of the property "PDCAttenuation"
 * ONLY AVAILABLE IN VW-LL-TFT. Status of ongoing PDCAttenuation.
 */
class PDCAttenuationSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PDCAttenuationSet ();

    /**
     * Copy constructor
     */
    inline  PDCAttenuationSet (const PDCAttenuationSet &rhs);

    /**
     * All fields constructor
     */
    inline  PDCAttenuationSet (::masc_main_fi_types::T_e8_PDCAttenuation PDCAttenuationCommand_);

    /**
     * Destructor
     */
    inline virtual  ~PDCAttenuationSet();

    /**
     * Assignment operator
     */
    inline PDCAttenuationSet& operator = (const PDCAttenuationSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PDCAttenuationSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PDCAttenuationSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PDCAttenuationSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PDCAttenuationSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PDCAttenuationCommand"

    static const int kPDCAttenuationCommand = 0;

    /**
     * Clears the field "PDCAttenuationCommand".
     *
     * The field will be set to its default value. The hasPDCAttenuationCommand()
     * method will return false.
     */
    inline void clearPDCAttenuationCommand();

    /**
     * Checks whether the field "PDCAttenuationCommand" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPDCAttenuationCommand()). Otherwise it will return false.
     */
    inline bool hasPDCAttenuationCommand () const;

    /**
     * Returns the value of the member "PDCAttenuationCommand".
     *
     * PDC Attenuation Command
     *
     * @return The value of the field "PDCAttenuationCommand"
     */
    inline ::masc_main_fi_types::T_e8_PDCAttenuation getPDCAttenuationCommand () const;

    /**
     * Sets the value of the member "PDCAttenuationCommand".
     *
     * PDC Attenuation Command
     *
     * @param PDCAttenuationCommand The value which will be set
     */
    inline void setPDCAttenuationCommand (::masc_main_fi_types::T_e8_PDCAttenuation PDCAttenuationCommand_);

    static const PDCAttenuationSet &getDefaultInstance();

private:

    inline void set_has_PDCAttenuationCommand ();

    inline void clear_has_PDCAttenuationCommand ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_PDCAttenuation _PDCAttenuationCommand;

};

/**
 * The status message of the property "AudioDeviceStatus"
 * Gives Status of AudioDevice Availability.
 */
class AudioDeviceStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioDeviceStatusStatus ();

    /**
     * Copy constructor
     */
    inline  AudioDeviceStatusStatus (const AudioDeviceStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AudioDeviceStatusStatus (::masc_main_fi_types::T_e8_AudioDevice_Availability AudioDeviceAvailability_);

    /**
     * Destructor
     */
    inline virtual  ~AudioDeviceStatusStatus();

    /**
     * Assignment operator
     */
    inline AudioDeviceStatusStatus& operator = (const AudioDeviceStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioDeviceStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioDeviceStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioDeviceStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioDeviceStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudioDeviceAvailability"

    static const int kAudioDeviceAvailability = 0;

    /**
     * Clears the field "AudioDeviceAvailability".
     *
     * The field will be set to its default value. The hasAudioDeviceAvailability()
     * method will return false.
     */
    inline void clearAudioDeviceAvailability();

    /**
     * Checks whether the field "AudioDeviceAvailability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioDeviceAvailability()). Otherwise it will return false.
     */
    inline bool hasAudioDeviceAvailability () const;

    /**
     * Returns the value of the member "AudioDeviceAvailability".
     *
     * AudioDevice availability status.
     *
     * @return The value of the field "AudioDeviceAvailability"
     */
    inline ::masc_main_fi_types::T_e8_AudioDevice_Availability getAudioDeviceAvailability () const;

    /**
     * Sets the value of the member "AudioDeviceAvailability".
     *
     * AudioDevice availability status.
     *
     * @param AudioDeviceAvailability The value which will be set
     */
    inline void setAudioDeviceAvailability (::masc_main_fi_types::T_e8_AudioDevice_Availability AudioDeviceAvailability_);

    static const AudioDeviceStatusStatus &getDefaultInstance();

private:

    inline void set_has_AudioDeviceAvailability ();

    inline void clear_has_AudioDeviceAvailability ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudioDevice_Availability _AudioDeviceAvailability;

};

/**
 * The status message of the property "OverTempReduction"
 * <p>Audio Volume downscaling for use in over-temperature situations.</p>
 * Note: Audible volume will be lower than reported in VolumeStatus
 */
class OverTempReductionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OverTempReductionStatus ();

    /**
     * Copy constructor
     */
    inline  OverTempReductionStatus (const OverTempReductionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  OverTempReductionStatus (bool ActiveByCommand_, bool ActiveByAmplifier_, uint8 CurrentFactor_, uint8 ReductionInterval_);

    /**
     * Destructor
     */
    inline virtual  ~OverTempReductionStatus();

    /**
     * Assignment operator
     */
    inline OverTempReductionStatus& operator = (const OverTempReductionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OverTempReductionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OverTempReductionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OverTempReductionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OverTempReductionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActiveByCommand"

    static const int kActiveByCommand = 0;

    /**
     * Clears the field "ActiveByCommand".
     *
     * The field will be set to its default value. The hasActiveByCommand()
     * method will return false.
     */
    inline void clearActiveByCommand();

    /**
     * Checks whether the field "ActiveByCommand" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveByCommand()). Otherwise it will return false.
     */
    inline bool hasActiveByCommand () const;

    /**
     * Returns the value of the member "ActiveByCommand".
     *
     * Volume downscaling issued by Set-message of this property
     * TRUE:  volume is reduced
     * FALSE: volume unchanged (as set in VolumeStatus).
     *
     * @return The value of the field "ActiveByCommand"
     */
    inline bool getActiveByCommand () const;

    /**
     * Sets the value of the member "ActiveByCommand".
     *
     * Volume downscaling issued by Set-message of this property
     * TRUE:  volume is reduced
     * FALSE: volume unchanged (as set in VolumeStatus).
     *
     * @param ActiveByCommand The value which will be set
     */
    inline void setActiveByCommand (bool ActiveByCommand_);

    // API of field "ActiveByAmplifier"

    static const int kActiveByAmplifier = 1;

    /**
     * Clears the field "ActiveByAmplifier".
     *
     * The field will be set to its default value. The hasActiveByAmplifier()
     * method will return false.
     */
    inline void clearActiveByAmplifier();

    /**
     * Checks whether the field "ActiveByAmplifier" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveByAmplifier()). Otherwise it will return false.
     */
    inline bool hasActiveByAmplifier () const;

    /**
     * Returns the value of the member "ActiveByAmplifier".
     *
     * Volume downscaling issued by amplifier-intrinsic sensor
     * TRUE:  volume is reduced
     * FALSE: volume unchanged (as set in VolumeStatus).
     *
     * @return The value of the field "ActiveByAmplifier"
     */
    inline bool getActiveByAmplifier () const;

    /**
     * Sets the value of the member "ActiveByAmplifier".
     *
     * Volume downscaling issued by amplifier-intrinsic sensor
     * TRUE:  volume is reduced
     * FALSE: volume unchanged (as set in VolumeStatus).
     *
     * @param ActiveByAmplifier The value which will be set
     */
    inline void setActiveByAmplifier (bool ActiveByAmplifier_);

    // API of field "CurrentFactor"

    static const int kCurrentFactor = 2;

    /**
     * Clears the field "CurrentFactor".
     *
     * The field will be set to its default value. The hasCurrentFactor()
     * method will return false.
     */
    inline void clearCurrentFactor();

    /**
     * Checks whether the field "CurrentFactor" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentFactor()). Otherwise it will return false.
     */
    inline bool hasCurrentFactor () const;

    /**
     * Returns the value of the member "CurrentFactor".
     *
     * current downscaling factor for volume in per cent (62 ... 100%).
     *
     * @return The value of the field "CurrentFactor"
     */
    inline uint8 getCurrentFactor () const;

    /**
     * Sets the value of the member "CurrentFactor".
     *
     * current downscaling factor for volume in per cent (62 ... 100%).
     *
     * @param CurrentFactor The value which will be set
     */
    inline void setCurrentFactor (uint8 CurrentFactor_);

    // API of field "ReductionInterval"

    static const int kReductionInterval = 3;

    /**
     * Clears the field "ReductionInterval".
     *
     * The field will be set to its default value. The hasReductionInterval()
     * method will return false.
     */
    inline void clearReductionInterval();

    /**
     * Checks whether the field "ReductionInterval" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReductionInterval()). Otherwise it will return false.
     */
    inline bool hasReductionInterval () const;

    /**
     * Returns the value of the member "ReductionInterval".
     *
     * Time interval in seconds for reducing the volume in steps
     *
     * @return The value of the field "ReductionInterval"
     */
    inline uint8 getReductionInterval () const;

    /**
     * Sets the value of the member "ReductionInterval".
     *
     * Time interval in seconds for reducing the volume in steps
     *
     * @param ReductionInterval The value which will be set
     */
    inline void setReductionInterval (uint8 ReductionInterval_);

    static const OverTempReductionStatus &getDefaultInstance();

private:

    inline void set_has_ActiveByCommand ();

    inline void clear_has_ActiveByCommand ();

    inline void set_has_ActiveByAmplifier ();

    inline void clear_has_ActiveByAmplifier ();

    inline void set_has_CurrentFactor ();

    inline void clear_has_CurrentFactor ();

    inline void set_has_ReductionInterval ();

    inline void clear_has_ReductionInterval ();

    uint32 _has_bits_[ (4 + 31) / 32];

    bool _ActiveByCommand;

    bool _ActiveByAmplifier;

    uint8 _CurrentFactor;

    uint8 _ReductionInterval;

};

/**
 * The set message of the property "OverTempReduction"
 * <p>Audio Volume downscaling for use in over-temperature situations.</p>
 * Note: Audible volume will be lower than reported in VolumeStatus
 */
class OverTempReductionSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OverTempReductionSet ();

    /**
     * Copy constructor
     */
    inline  OverTempReductionSet (const OverTempReductionSet &rhs);

    /**
     * All fields constructor
     */
    inline  OverTempReductionSet (bool DownScaling_Active_, uint8 ReductionInterval_);

    /**
     * Destructor
     */
    inline virtual  ~OverTempReductionSet();

    /**
     * Assignment operator
     */
    inline OverTempReductionSet& operator = (const OverTempReductionSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OverTempReductionSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OverTempReductionSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OverTempReductionSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OverTempReductionSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DownScaling_Active"

    static const int kDownScaling_Active = 0;

    /**
     * Clears the field "DownScaling_Active".
     *
     * The field will be set to its default value. The hasDownScaling_Active()
     * method will return false.
     */
    inline void clearDownScaling_Active();

    /**
     * Checks whether the field "DownScaling_Active" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDownScaling_Active()). Otherwise it will return false.
     */
    inline bool hasDownScaling_Active () const;

    /**
     * Returns the value of the member "DownScaling_Active".
     *
     * TRUE:  turn ON volume reduction
     * FALSE: turn OFF volume reduction
     *
     * @return The value of the field "DownScaling_Active"
     */
    inline bool getDownScaling_Active () const;

    /**
     * Sets the value of the member "DownScaling_Active".
     *
     * TRUE:  turn ON volume reduction
     * FALSE: turn OFF volume reduction
     *
     * @param DownScaling_Active The value which will be set
     */
    inline void setDownScaling_Active (bool DownScaling_Active_);

    // API of field "ReductionInterval"

    static const int kReductionInterval = 1;

    /**
     * Clears the field "ReductionInterval".
     *
     * The field will be set to its default value. The hasReductionInterval()
     * method will return false.
     */
    inline void clearReductionInterval();

    /**
     * Checks whether the field "ReductionInterval" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReductionInterval()). Otherwise it will return false.
     */
    inline bool hasReductionInterval () const;

    /**
     * Returns the value of the member "ReductionInterval".
     *
     * Time interval in seconds for reducing the volume in steps
     *
     * @return The value of the field "ReductionInterval"
     */
    inline uint8 getReductionInterval () const;

    /**
     * Sets the value of the member "ReductionInterval".
     *
     * Time interval in seconds for reducing the volume in steps
     *
     * @param ReductionInterval The value which will be set
     */
    inline void setReductionInterval (uint8 ReductionInterval_);

    static const OverTempReductionSet &getDefaultInstance();

private:

    inline void set_has_DownScaling_Active ();

    inline void clear_has_DownScaling_Active ();

    inline void set_has_ReductionInterval ();

    inline void clear_has_ReductionInterval ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _DownScaling_Active;

    uint8 _ReductionInterval;

};

/**
 * The status message of the property "OverTempAmplifierStatus"
 * Status of Amplifier Temperature level.
 */
class OverTempAmplifierStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OverTempAmplifierStatusStatus ();

    /**
     * Copy constructor
     */
    inline  OverTempAmplifierStatusStatus (const OverTempAmplifierStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  OverTempAmplifierStatusStatus (::masc_main_fi_types::T_e8_AmpTemperatureLevel AmpTemperatureLevel_);

    /**
     * Destructor
     */
    inline virtual  ~OverTempAmplifierStatusStatus();

    /**
     * Assignment operator
     */
    inline OverTempAmplifierStatusStatus& operator = (const OverTempAmplifierStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OverTempAmplifierStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OverTempAmplifierStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OverTempAmplifierStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OverTempAmplifierStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AmpTemperatureLevel"

    static const int kAmpTemperatureLevel = 0;

    /**
     * Clears the field "AmpTemperatureLevel".
     *
     * The field will be set to its default value. The hasAmpTemperatureLevel()
     * method will return false.
     */
    inline void clearAmpTemperatureLevel();

    /**
     * Checks whether the field "AmpTemperatureLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAmpTemperatureLevel()). Otherwise it will return false.
     */
    inline bool hasAmpTemperatureLevel () const;

    /**
     * Returns the value of the member "AmpTemperatureLevel".
     *
     * Amplifier Temperature level.
     *
     * @return The value of the field "AmpTemperatureLevel"
     */
    inline ::masc_main_fi_types::T_e8_AmpTemperatureLevel getAmpTemperatureLevel () const;

    /**
     * Sets the value of the member "AmpTemperatureLevel".
     *
     * Amplifier Temperature level.
     *
     * @param AmpTemperatureLevel The value which will be set
     */
    inline void setAmpTemperatureLevel (::masc_main_fi_types::T_e8_AmpTemperatureLevel AmpTemperatureLevel_);

    static const OverTempAmplifierStatusStatus &getDefaultInstance();

private:

    inline void set_has_AmpTemperatureLevel ();

    inline void clear_has_AmpTemperatureLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_AmpTemperatureLevel _AmpTemperatureLevel;

};

/**
 * The status message of the property "ReadMeasurementResult"
 * Status of Amplifier loudspeaker diagnosis result that was triggered by method SpeakerDiagnosisStart.
 */
class ReadMeasurementResultStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReadMeasurementResultStatus ();

    /**
     * Copy constructor
     */
    inline  ReadMeasurementResultStatus (const ReadMeasurementResultStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ReadMeasurementResultStatus (const ::std::vector< ::masc_main_fi_types::T_Aud_MeasurementResultItem >& MeasurementResultList_);

    /**
     * Destructor
     */
    inline virtual  ~ReadMeasurementResultStatus();

    /**
     * Assignment operator
     */
    inline ReadMeasurementResultStatus& operator = (const ReadMeasurementResultStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReadMeasurementResultStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReadMeasurementResultStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReadMeasurementResultStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReadMeasurementResultStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MeasurementResultList"

    static const int kMeasurementResultList = 0;

    /**
     * Clears the field "MeasurementResultList".
     *
     * The field will be set to its default value. The hasMeasurementResultList()
     * method will return false.
     */
    inline void clearMeasurementResultList();

    /**
     * Checks whether the field "MeasurementResultList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMeasurementResultList()). Otherwise it will return false.
     */
    inline bool hasMeasurementResultList () const;

    /**
     * Returns the value of the member "MeasurementResultList".
     *
     * List of measurement results with the corresponding DataIds
     *
     * @return The value of the field "MeasurementResultList"
     */
    inline const ::std::vector< ::masc_main_fi_types::T_Aud_MeasurementResultItem >& getMeasurementResultList () const;

    /**
     * Retrieves the value of the field "MeasurementResultList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MeasurementResultList".
     */
    inline ::std::vector< ::masc_main_fi_types::T_Aud_MeasurementResultItem >& getMeasurementResultListMutable ();

    /**
     * Sets the value of the member "MeasurementResultList".
     *
     * List of measurement results with the corresponding DataIds
     *
     * @param MeasurementResultList The value which will be set
     */
    inline void setMeasurementResultList (const ::std::vector< ::masc_main_fi_types::T_Aud_MeasurementResultItem >& MeasurementResultList_);

    static const ReadMeasurementResultStatus &getDefaultInstance();

private:

    static const ::std::vector< ::masc_main_fi_types::T_Aud_MeasurementResultItem >& getT_Aud_MeasurementResultItemList_DefaultInstance ();

    inline void set_has_MeasurementResultList ();

    inline void clear_has_MeasurementResultList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::masc_main_fi_types::T_Aud_MeasurementResultItem > _MeasurementResultList;

};

/**
 * The status message of the property "Center"
 * status of actual Center value.
 */
class CenterStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CenterStatus ();

    /**
     * Copy constructor
     */
    inline  CenterStatus (const CenterStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CenterStatus (int16 Center_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::masc_main_fi_types::T_e8_AudioChannel Channel_);

    /**
     * Destructor
     */
    inline virtual  ~CenterStatus();

    /**
     * Assignment operator
     */
    inline CenterStatus& operator = (const CenterStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CenterStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CenterStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CenterStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CenterStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Center"

    static const int kCenter = 0;

    /**
     * Clears the field "Center".
     *
     * The field will be set to its default value. The hasCenter()
     * method will return false.
     */
    inline void clearCenter();

    /**
     * Checks whether the field "Center" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCenter()). Otherwise it will return false.
     */
    inline bool hasCenter () const;

    /**
     * Returns the value of the member "Center".
     *
     * Center value
     *
     * @return The value of the field "Center"
     */
    inline int16 getCenter () const;

    /**
     * Sets the value of the member "Center".
     *
     * Center value
     *
     * @param Center The value which will be set
     */
    inline void setCenter (int16 Center_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "Channel"

    static const int kChannel = 2;

    /**
     * Clears the field "Channel".
     *
     * The field will be set to its default value. The hasChannel()
     * method will return false.
     */
    inline void clearChannel();

    /**
     * Checks whether the field "Channel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannel()). Otherwise it will return false.
     */
    inline bool hasChannel () const;

    /**
     * Returns the value of the member "Channel".
     *
     * Related channel
     *
     * @return The value of the field "Channel"
     */
    inline ::masc_main_fi_types::T_e8_AudioChannel getChannel () const;

    /**
     * Sets the value of the member "Channel".
     *
     * Related channel
     *
     * @param Channel The value which will be set
     */
    inline void setChannel (::masc_main_fi_types::T_e8_AudioChannel Channel_);

    static const CenterStatus &getDefaultInstance();

private:

    inline void set_has_Center ();

    inline void clear_has_Center ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_Channel ();

    inline void clear_has_Channel ();

    uint32 _has_bits_[ (3 + 31) / 32];

    int16 _Center;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    ::masc_main_fi_types::T_e8_AudioChannel _Channel;

};

/**
 * The set message of the property "Center"
 * status of actual Center value.
 */
class CenterSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CenterSet ();

    /**
     * Copy constructor
     */
    inline  CenterSet (const CenterSet &rhs);

    /**
     * All fields constructor
     */
    inline  CenterSet (::masc_main_fi_types::T_e8_AudioSoundType SoundType_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, int16 Center_);

    /**
     * Destructor
     */
    inline virtual  ~CenterSet();

    /**
     * Assignment operator
     */
    inline CenterSet& operator = (const CenterSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CenterSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CenterSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CenterSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CenterSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SoundType"

    static const int kSoundType = 0;

    /**
     * Clears the field "SoundType".
     *
     * The field will be set to its default value. The hasSoundType()
     * method will return false.
     */
    inline void clearSoundType();

    /**
     * Checks whether the field "SoundType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundType()). Otherwise it will return false.
     */
    inline bool hasSoundType () const;

    /**
     * Returns the value of the member "SoundType".
     *
     * Type of sound (Center) , it can be absolute or relative
     *
     * @return The value of the field "SoundType"
     */
    inline ::masc_main_fi_types::T_e8_AudioSoundType getSoundType () const;

    /**
     * Sets the value of the member "SoundType".
     *
     * Type of sound (Center) , it can be absolute or relative
     *
     * @param SoundType The value which will be set
     */
    inline void setSoundType (::masc_main_fi_types::T_e8_AudioSoundType SoundType_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "Center"

    static const int kCenter = 2;

    /**
     * Clears the field "Center".
     *
     * The field will be set to its default value. The hasCenter()
     * method will return false.
     */
    inline void clearCenter();

    /**
     * Checks whether the field "Center" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCenter()). Otherwise it will return false.
     */
    inline bool hasCenter () const;

    /**
     * Returns the value of the member "Center".
     *
     * Center value to set
     *
     * @return The value of the field "Center"
     */
    inline int16 getCenter () const;

    /**
     * Sets the value of the member "Center".
     *
     * Center value to set
     *
     * @param Center The value which will be set
     */
    inline void setCenter (int16 Center_);

    static const CenterSet &getDefaultInstance();

private:

    inline void set_has_SoundType ();

    inline void clear_has_SoundType ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_Center ();

    inline void clear_has_Center ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudioSoundType _SoundType;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    int16 _Center;

};

/**
 * The status message of the property "SubWoofer"
 * status of actual SubWoofer value.
 */
class SubWooferStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SubWooferStatus ();

    /**
     * Copy constructor
     */
    inline  SubWooferStatus (const SubWooferStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SubWooferStatus (int16 SubWoofer_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::masc_main_fi_types::T_e8_AudioChannel Channel_);

    /**
     * Destructor
     */
    inline virtual  ~SubWooferStatus();

    /**
     * Assignment operator
     */
    inline SubWooferStatus& operator = (const SubWooferStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SubWooferStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SubWooferStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SubWooferStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SubWooferStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SubWoofer"

    static const int kSubWoofer = 0;

    /**
     * Clears the field "SubWoofer".
     *
     * The field will be set to its default value. The hasSubWoofer()
     * method will return false.
     */
    inline void clearSubWoofer();

    /**
     * Checks whether the field "SubWoofer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubWoofer()). Otherwise it will return false.
     */
    inline bool hasSubWoofer () const;

    /**
     * Returns the value of the member "SubWoofer".
     *
     * SubWoofer value
     *
     * @return The value of the field "SubWoofer"
     */
    inline int16 getSubWoofer () const;

    /**
     * Sets the value of the member "SubWoofer".
     *
     * SubWoofer value
     *
     * @param SubWoofer The value which will be set
     */
    inline void setSubWoofer (int16 SubWoofer_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "Channel"

    static const int kChannel = 2;

    /**
     * Clears the field "Channel".
     *
     * The field will be set to its default value. The hasChannel()
     * method will return false.
     */
    inline void clearChannel();

    /**
     * Checks whether the field "Channel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannel()). Otherwise it will return false.
     */
    inline bool hasChannel () const;

    /**
     * Returns the value of the member "Channel".
     *
     * Related channel
     *
     * @return The value of the field "Channel"
     */
    inline ::masc_main_fi_types::T_e8_AudioChannel getChannel () const;

    /**
     * Sets the value of the member "Channel".
     *
     * Related channel
     *
     * @param Channel The value which will be set
     */
    inline void setChannel (::masc_main_fi_types::T_e8_AudioChannel Channel_);

    static const SubWooferStatus &getDefaultInstance();

private:

    inline void set_has_SubWoofer ();

    inline void clear_has_SubWoofer ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_Channel ();

    inline void clear_has_Channel ();

    uint32 _has_bits_[ (3 + 31) / 32];

    int16 _SubWoofer;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    ::masc_main_fi_types::T_e8_AudioChannel _Channel;

};

/**
 * The set message of the property "SubWoofer"
 * status of actual SubWoofer value.
 */
class SubWooferSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SubWooferSet ();

    /**
     * Copy constructor
     */
    inline  SubWooferSet (const SubWooferSet &rhs);

    /**
     * All fields constructor
     */
    inline  SubWooferSet (::masc_main_fi_types::T_e8_AudioSoundType SoundType_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, int16 SubWoofer_);

    /**
     * Destructor
     */
    inline virtual  ~SubWooferSet();

    /**
     * Assignment operator
     */
    inline SubWooferSet& operator = (const SubWooferSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SubWooferSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SubWooferSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SubWooferSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SubWooferSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SoundType"

    static const int kSoundType = 0;

    /**
     * Clears the field "SoundType".
     *
     * The field will be set to its default value. The hasSoundType()
     * method will return false.
     */
    inline void clearSoundType();

    /**
     * Checks whether the field "SoundType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundType()). Otherwise it will return false.
     */
    inline bool hasSoundType () const;

    /**
     * Returns the value of the member "SoundType".
     *
     * Type of sound (SubWoofer) , it can be absolute or relative
     *
     * @return The value of the field "SoundType"
     */
    inline ::masc_main_fi_types::T_e8_AudioSoundType getSoundType () const;

    /**
     * Sets the value of the member "SoundType".
     *
     * Type of sound (SubWoofer) , it can be absolute or relative
     *
     * @param SoundType The value which will be set
     */
    inline void setSoundType (::masc_main_fi_types::T_e8_AudioSoundType SoundType_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "SubWoofer"

    static const int kSubWoofer = 2;

    /**
     * Clears the field "SubWoofer".
     *
     * The field will be set to its default value. The hasSubWoofer()
     * method will return false.
     */
    inline void clearSubWoofer();

    /**
     * Checks whether the field "SubWoofer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubWoofer()). Otherwise it will return false.
     */
    inline bool hasSubWoofer () const;

    /**
     * Returns the value of the member "SubWoofer".
     *
     * SubWoofer value to set
     *
     * @return The value of the field "SubWoofer"
     */
    inline int16 getSubWoofer () const;

    /**
     * Sets the value of the member "SubWoofer".
     *
     * SubWoofer value to set
     *
     * @param SubWoofer The value which will be set
     */
    inline void setSubWoofer (int16 SubWoofer_);

    static const SubWooferSet &getDefaultInstance();

private:

    inline void set_has_SoundType ();

    inline void clear_has_SoundType ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_SubWoofer ();

    inline void clear_has_SubWoofer ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudioSoundType _SoundType;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    int16 _SubWoofer;

};

/**
 * The status message of the property "ExternalAmplifierConnectionState"
 * status of Bose MCAN-amplifier connection state.
 */
class ExternalAmplifierConnectionStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ExternalAmplifierConnectionStateStatus ();

    /**
     * Copy constructor
     */
    inline  ExternalAmplifierConnectionStateStatus (const ExternalAmplifierConnectionStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ExternalAmplifierConnectionStateStatus (bool ConnectionState_);

    /**
     * Destructor
     */
    inline virtual  ~ExternalAmplifierConnectionStateStatus();

    /**
     * Assignment operator
     */
    inline ExternalAmplifierConnectionStateStatus& operator = (const ExternalAmplifierConnectionStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ExternalAmplifierConnectionStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ExternalAmplifierConnectionStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ExternalAmplifierConnectionStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ExternalAmplifierConnectionStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ConnectionState"

    static const int kConnectionState = 0;

    /**
     * Clears the field "ConnectionState".
     *
     * The field will be set to its default value. The hasConnectionState()
     * method will return false.
     */
    inline void clearConnectionState();

    /**
     * Checks whether the field "ConnectionState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnectionState()). Otherwise it will return false.
     */
    inline bool hasConnectionState () const;

    /**
     * Returns the value of the member "ConnectionState".
     *
     * TRUE:  Bose amplifier connected
     * FALSE: Bose amplifier not connected
     *
     * @return The value of the field "ConnectionState"
     */
    inline bool getConnectionState () const;

    /**
     * Sets the value of the member "ConnectionState".
     *
     * TRUE:  Bose amplifier connected
     * FALSE: Bose amplifier not connected
     *
     * @param ConnectionState The value which will be set
     */
    inline void setConnectionState (bool ConnectionState_);

    static const ExternalAmplifierConnectionStateStatus &getDefaultInstance();

private:

    inline void set_has_ConnectionState ();

    inline void clear_has_ConnectionState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _ConnectionState;

};

/**
 * The status message of the property "GeneralSpeakerTest"
 * Set the request(start, stop and next)for speaker test. And the status of speaker test.
 */
class GeneralSpeakerTestStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GeneralSpeakerTestStatus ();

    /**
     * Copy constructor
     */
    inline  GeneralSpeakerTestStatus (const GeneralSpeakerTestStatus &rhs);

    /**
     * All fields constructor
     */
    inline  GeneralSpeakerTestStatus (uint8 SpeakerValue_1_, uint8 SpeakerValue_2_, uint8 SpeakerValue_3_, uint8 SpeakerValue_4_, uint8 SpeakerValue_5_);

    /**
     * Destructor
     */
    inline virtual  ~GeneralSpeakerTestStatus();

    /**
     * Assignment operator
     */
    inline GeneralSpeakerTestStatus& operator = (const GeneralSpeakerTestStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GeneralSpeakerTestStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GeneralSpeakerTestStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GeneralSpeakerTestStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GeneralSpeakerTestStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SpeakerValue_1"

    static const int kSpeakerValue_1 = 0;

    /**
     * Clears the field "SpeakerValue_1".
     *
     * The field will be set to its default value. The hasSpeakerValue_1()
     * method will return false.
     */
    inline void clearSpeakerValue_1();

    /**
     * Checks whether the field "SpeakerValue_1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeakerValue_1()). Otherwise it will return false.
     */
    inline bool hasSpeakerValue_1 () const;

    /**
     * Returns the value of the member "SpeakerValue_1".
     *
     * 0: No discription
     * 1: -A
     * 2: -B
     * 3: -C
     *
     * @return The value of the field "SpeakerValue_1"
     */
    inline uint8 getSpeakerValue_1 () const;

    /**
     * Sets the value of the member "SpeakerValue_1".
     *
     * 0: No discription
     * 1: -A
     * 2: -B
     * 3: -C
     *
     * @param SpeakerValue_1 The value which will be set
     */
    inline void setSpeakerValue_1 (uint8 SpeakerValue_1_);

    // API of field "SpeakerValue_2"

    static const int kSpeakerValue_2 = 1;

    /**
     * Clears the field "SpeakerValue_2".
     *
     * The field will be set to its default value. The hasSpeakerValue_2()
     * method will return false.
     */
    inline void clearSpeakerValue_2();

    /**
     * Checks whether the field "SpeakerValue_2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeakerValue_2()). Otherwise it will return false.
     */
    inline bool hasSpeakerValue_2 () const;

    /**
     * Returns the value of the member "SpeakerValue_2".
     *
     * 0: Speaker
     * 1: SubWoofer
     * 2: Squawker
     * 3: Tweeter
     *
     * @return The value of the field "SpeakerValue_2"
     */
    inline uint8 getSpeakerValue_2 () const;

    /**
     * Sets the value of the member "SpeakerValue_2".
     *
     * 0: Speaker
     * 1: SubWoofer
     * 2: Squawker
     * 3: Tweeter
     *
     * @param SpeakerValue_2 The value which will be set
     */
    inline void setSpeakerValue_2 (uint8 SpeakerValue_2_);

    // API of field "SpeakerValue_3"

    static const int kSpeakerValue_3 = 2;

    /**
     * Clears the field "SpeakerValue_3".
     *
     * The field will be set to its default value. The hasSpeakerValue_3()
     * method will return false.
     */
    inline void clearSpeakerValue_3();

    /**
     * Checks whether the field "SpeakerValue_3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeakerValue_3()). Otherwise it will return false.
     */
    inline bool hasSpeakerValue_3 () const;

    /**
     * Returns the value of the member "SpeakerValue_3".
     *
     * 0: Left
     * 1: Center
     * 2: Right
     *
     * @return The value of the field "SpeakerValue_3"
     */
    inline uint8 getSpeakerValue_3 () const;

    /**
     * Sets the value of the member "SpeakerValue_3".
     *
     * 0: Left
     * 1: Center
     * 2: Right
     *
     * @param SpeakerValue_3 The value which will be set
     */
    inline void setSpeakerValue_3 (uint8 SpeakerValue_3_);

    // API of field "SpeakerValue_4"

    static const int kSpeakerValue_4 = 3;

    /**
     * Clears the field "SpeakerValue_4".
     *
     * The field will be set to its default value. The hasSpeakerValue_4()
     * method will return false.
     */
    inline void clearSpeakerValue_4();

    /**
     * Checks whether the field "SpeakerValue_4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeakerValue_4()). Otherwise it will return false.
     */
    inline bool hasSpeakerValue_4 () const;

    /**
     * Returns the value of the member "SpeakerValue_4".
     *
     * 0: Door
     * 1: Side Panel
     * 2: Pshelf
     * 3: Inst-Panel
     * 4: Left Seat
     * 5: Right Seat
     * 6: Pillar
     * 7: Luggage
     * 8: Roof
     * 9: Seat
     * 10: Console
     *
     * @return The value of the field "SpeakerValue_4"
     */
    inline uint8 getSpeakerValue_4 () const;

    /**
     * Sets the value of the member "SpeakerValue_4".
     *
     * 0: Door
     * 1: Side Panel
     * 2: Pshelf
     * 3: Inst-Panel
     * 4: Left Seat
     * 5: Right Seat
     * 6: Pillar
     * 7: Luggage
     * 8: Roof
     * 9: Seat
     * 10: Console
     *
     * @param SpeakerValue_4 The value which will be set
     */
    inline void setSpeakerValue_4 (uint8 SpeakerValue_4_);

    // API of field "SpeakerValue_5"

    static const int kSpeakerValue_5 = 4;

    /**
     * Clears the field "SpeakerValue_5".
     *
     * The field will be set to its default value. The hasSpeakerValue_5()
     * method will return false.
     */
    inline void clearSpeakerValue_5();

    /**
     * Checks whether the field "SpeakerValue_5" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeakerValue_5()). Otherwise it will return false.
     */
    inline bool hasSpeakerValue_5 () const;

    /**
     * Returns the value of the member "SpeakerValue_5".
     *
     * 0: Front
     * 1: 2nd
     * 2: Rear
     * 3: Center
     * 4: Back
     *
     * @return The value of the field "SpeakerValue_5"
     */
    inline uint8 getSpeakerValue_5 () const;

    /**
     * Sets the value of the member "SpeakerValue_5".
     *
     * 0: Front
     * 1: 2nd
     * 2: Rear
     * 3: Center
     * 4: Back
     *
     * @param SpeakerValue_5 The value which will be set
     */
    inline void setSpeakerValue_5 (uint8 SpeakerValue_5_);

    static const GeneralSpeakerTestStatus &getDefaultInstance();

private:

    inline void set_has_SpeakerValue_1 ();

    inline void clear_has_SpeakerValue_1 ();

    inline void set_has_SpeakerValue_2 ();

    inline void clear_has_SpeakerValue_2 ();

    inline void set_has_SpeakerValue_3 ();

    inline void clear_has_SpeakerValue_3 ();

    inline void set_has_SpeakerValue_4 ();

    inline void clear_has_SpeakerValue_4 ();

    inline void set_has_SpeakerValue_5 ();

    inline void clear_has_SpeakerValue_5 ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint8 _SpeakerValue_1;

    uint8 _SpeakerValue_2;

    uint8 _SpeakerValue_3;

    uint8 _SpeakerValue_4;

    uint8 _SpeakerValue_5;

};

/**
 * The set message of the property "GeneralSpeakerTest"
 * Set the request(start, stop and next)for speaker test. And the status of speaker test.
 */
class GeneralSpeakerTestSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GeneralSpeakerTestSet ();

    /**
     * Copy constructor
     */
    inline  GeneralSpeakerTestSet (const GeneralSpeakerTestSet &rhs);

    /**
     * All fields constructor
     */
    inline  GeneralSpeakerTestSet (uint8 Request_);

    /**
     * Destructor
     */
    inline virtual  ~GeneralSpeakerTestSet();

    /**
     * Assignment operator
     */
    inline GeneralSpeakerTestSet& operator = (const GeneralSpeakerTestSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GeneralSpeakerTestSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GeneralSpeakerTestSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GeneralSpeakerTestSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GeneralSpeakerTestSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Request"

    static const int kRequest = 0;

    /**
     * Clears the field "Request".
     *
     * The field will be set to its default value. The hasRequest()
     * method will return false.
     */
    inline void clearRequest();

    /**
     * Checks whether the field "Request" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequest()). Otherwise it will return false.
     */
    inline bool hasRequest () const;

    /**
     * Returns the value of the member "Request".
     *
     * 0:  Stop
     * 1:  Start/Next
     *
     * @return The value of the field "Request"
     */
    inline uint8 getRequest () const;

    /**
     * Sets the value of the member "Request".
     *
     * 0:  Stop
     * 1:  Start/Next
     *
     * @param Request The value which will be set
     */
    inline void setRequest (uint8 Request_);

    static const GeneralSpeakerTestSet &getDefaultInstance();

private:

    inline void set_has_Request ();

    inline void clear_has_Request ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Request;

};

/**
 * The status message of the property "ANCSWVersion"
 * Updates ANC Software Version
 */
class ANCSWVersionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ANCSWVersionStatus ();

    /**
     * Copy constructor
     */
    inline  ANCSWVersionStatus (const ANCSWVersionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ANCSWVersionStatus (uint8 LargeVersion_, uint8 MiddleVersion_, uint8 SmallVersion_);

    /**
     * Destructor
     */
    inline virtual  ~ANCSWVersionStatus();

    /**
     * Assignment operator
     */
    inline ANCSWVersionStatus& operator = (const ANCSWVersionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ANCSWVersionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ANCSWVersionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ANCSWVersionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ANCSWVersionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LargeVersion"

    static const int kLargeVersion = 0;

    /**
     * Clears the field "LargeVersion".
     *
     * The field will be set to its default value. The hasLargeVersion()
     * method will return false.
     */
    inline void clearLargeVersion();

    /**
     * Checks whether the field "LargeVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLargeVersion()). Otherwise it will return false.
     */
    inline bool hasLargeVersion () const;

    /**
     * Returns the value of the member "LargeVersion".
     *
     *
     *
     * @return The value of the field "LargeVersion"
     */
    inline uint8 getLargeVersion () const;

    /**
     * Sets the value of the member "LargeVersion".
     *
     *
     *
     * @param LargeVersion The value which will be set
     */
    inline void setLargeVersion (uint8 LargeVersion_);

    // API of field "MiddleVersion"

    static const int kMiddleVersion = 1;

    /**
     * Clears the field "MiddleVersion".
     *
     * The field will be set to its default value. The hasMiddleVersion()
     * method will return false.
     */
    inline void clearMiddleVersion();

    /**
     * Checks whether the field "MiddleVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMiddleVersion()). Otherwise it will return false.
     */
    inline bool hasMiddleVersion () const;

    /**
     * Returns the value of the member "MiddleVersion".
     *
     *
     *
     * @return The value of the field "MiddleVersion"
     */
    inline uint8 getMiddleVersion () const;

    /**
     * Sets the value of the member "MiddleVersion".
     *
     *
     *
     * @param MiddleVersion The value which will be set
     */
    inline void setMiddleVersion (uint8 MiddleVersion_);

    // API of field "SmallVersion"

    static const int kSmallVersion = 2;

    /**
     * Clears the field "SmallVersion".
     *
     * The field will be set to its default value. The hasSmallVersion()
     * method will return false.
     */
    inline void clearSmallVersion();

    /**
     * Checks whether the field "SmallVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSmallVersion()). Otherwise it will return false.
     */
    inline bool hasSmallVersion () const;

    /**
     * Returns the value of the member "SmallVersion".
     *
     *
     *
     * @return The value of the field "SmallVersion"
     */
    inline uint8 getSmallVersion () const;

    /**
     * Sets the value of the member "SmallVersion".
     *
     *
     *
     * @param SmallVersion The value which will be set
     */
    inline void setSmallVersion (uint8 SmallVersion_);

    static const ANCSWVersionStatus &getDefaultInstance();

private:

    inline void set_has_LargeVersion ();

    inline void clear_has_LargeVersion ();

    inline void set_has_MiddleVersion ();

    inline void clear_has_MiddleVersion ();

    inline void set_has_SmallVersion ();

    inline void clear_has_SmallVersion ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _LargeVersion;

    uint8 _MiddleVersion;

    uint8 _SmallVersion;

};

/**
 * The status message of the property "ASCSWVersion"
 * Updates ASC Software Version
 */
class ASCSWVersionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ASCSWVersionStatus ();

    /**
     * Copy constructor
     */
    inline  ASCSWVersionStatus (const ASCSWVersionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ASCSWVersionStatus (uint8 LargeVersion_, uint8 MiddleVersion_, uint8 SmallVersion_);

    /**
     * Destructor
     */
    inline virtual  ~ASCSWVersionStatus();

    /**
     * Assignment operator
     */
    inline ASCSWVersionStatus& operator = (const ASCSWVersionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ASCSWVersionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ASCSWVersionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ASCSWVersionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ASCSWVersionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LargeVersion"

    static const int kLargeVersion = 0;

    /**
     * Clears the field "LargeVersion".
     *
     * The field will be set to its default value. The hasLargeVersion()
     * method will return false.
     */
    inline void clearLargeVersion();

    /**
     * Checks whether the field "LargeVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLargeVersion()). Otherwise it will return false.
     */
    inline bool hasLargeVersion () const;

    /**
     * Returns the value of the member "LargeVersion".
     *
     *
     *
     * @return The value of the field "LargeVersion"
     */
    inline uint8 getLargeVersion () const;

    /**
     * Sets the value of the member "LargeVersion".
     *
     *
     *
     * @param LargeVersion The value which will be set
     */
    inline void setLargeVersion (uint8 LargeVersion_);

    // API of field "MiddleVersion"

    static const int kMiddleVersion = 1;

    /**
     * Clears the field "MiddleVersion".
     *
     * The field will be set to its default value. The hasMiddleVersion()
     * method will return false.
     */
    inline void clearMiddleVersion();

    /**
     * Checks whether the field "MiddleVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMiddleVersion()). Otherwise it will return false.
     */
    inline bool hasMiddleVersion () const;

    /**
     * Returns the value of the member "MiddleVersion".
     *
     *
     *
     * @return The value of the field "MiddleVersion"
     */
    inline uint8 getMiddleVersion () const;

    /**
     * Sets the value of the member "MiddleVersion".
     *
     *
     *
     * @param MiddleVersion The value which will be set
     */
    inline void setMiddleVersion (uint8 MiddleVersion_);

    // API of field "SmallVersion"

    static const int kSmallVersion = 2;

    /**
     * Clears the field "SmallVersion".
     *
     * The field will be set to its default value. The hasSmallVersion()
     * method will return false.
     */
    inline void clearSmallVersion();

    /**
     * Checks whether the field "SmallVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSmallVersion()). Otherwise it will return false.
     */
    inline bool hasSmallVersion () const;

    /**
     * Returns the value of the member "SmallVersion".
     *
     *
     *
     * @return The value of the field "SmallVersion"
     */
    inline uint8 getSmallVersion () const;

    /**
     * Sets the value of the member "SmallVersion".
     *
     *
     *
     * @param SmallVersion The value which will be set
     */
    inline void setSmallVersion (uint8 SmallVersion_);

    static const ASCSWVersionStatus &getDefaultInstance();

private:

    inline void set_has_LargeVersion ();

    inline void clear_has_LargeVersion ();

    inline void set_has_MiddleVersion ();

    inline void clear_has_MiddleVersion ();

    inline void set_has_SmallVersion ();

    inline void clear_has_SmallVersion ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _LargeVersion;

    uint8 _MiddleVersion;

    uint8 _SmallVersion;

};

/**
 * The status message of the property "ANCASCSetting"
 * User setting of ANC ASC
 */
class ANCASCSettingStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ANCASCSettingStatus ();

    /**
     * Copy constructor
     */
    inline  ANCASCSettingStatus (const ANCASCSettingStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ANCASCSettingStatus (uint8 ANCAvailability_, uint8 ASCAvailability_);

    /**
     * Destructor
     */
    inline virtual  ~ANCASCSettingStatus();

    /**
     * Assignment operator
     */
    inline ANCASCSettingStatus& operator = (const ANCASCSettingStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ANCASCSettingStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ANCASCSettingStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ANCASCSettingStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ANCASCSettingStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ANCAvailability"

    static const int kANCAvailability = 0;

    /**
     * Clears the field "ANCAvailability".
     *
     * The field will be set to its default value. The hasANCAvailability()
     * method will return false.
     */
    inline void clearANCAvailability();

    /**
     * Checks whether the field "ANCAvailability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setANCAvailability()). Otherwise it will return false.
     */
    inline bool hasANCAvailability () const;

    /**
     * Returns the value of the member "ANCAvailability".
     *
     * 0x0F:  Unavailable
     * 0x01:  Enable
     * 0x00:  Disable
     *
     * @return The value of the field "ANCAvailability"
     */
    inline uint8 getANCAvailability () const;

    /**
     * Sets the value of the member "ANCAvailability".
     *
     * 0x0F:  Unavailable
     * 0x01:  Enable
     * 0x00:  Disable
     *
     * @param ANCAvailability The value which will be set
     */
    inline void setANCAvailability (uint8 ANCAvailability_);

    // API of field "ASCAvailability"

    static const int kASCAvailability = 1;

    /**
     * Clears the field "ASCAvailability".
     *
     * The field will be set to its default value. The hasASCAvailability()
     * method will return false.
     */
    inline void clearASCAvailability();

    /**
     * Checks whether the field "ASCAvailability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setASCAvailability()). Otherwise it will return false.
     */
    inline bool hasASCAvailability () const;

    /**
     * Returns the value of the member "ASCAvailability".
     *
     * 0x0F:  Unavailable
     * 0x01:  Enable
     * 0x00:  Disable
     *
     * @return The value of the field "ASCAvailability"
     */
    inline uint8 getASCAvailability () const;

    /**
     * Sets the value of the member "ASCAvailability".
     *
     * 0x0F:  Unavailable
     * 0x01:  Enable
     * 0x00:  Disable
     *
     * @param ASCAvailability The value which will be set
     */
    inline void setASCAvailability (uint8 ASCAvailability_);

    static const ANCASCSettingStatus &getDefaultInstance();

private:

    inline void set_has_ANCAvailability ();

    inline void clear_has_ANCAvailability ();

    inline void set_has_ASCAvailability ();

    inline void clear_has_ASCAvailability ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _ANCAvailability;

    uint8 _ASCAvailability;

};

/**
 * The set message of the property "ANCASCSetting"
 * User setting of ANC ASC
 */
class ANCASCSettingSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ANCASCSettingSet ();

    /**
     * Copy constructor
     */
    inline  ANCASCSettingSet (const ANCASCSettingSet &rhs);

    /**
     * All fields constructor
     */
    inline  ANCASCSettingSet (uint8 ANCAvailability_, uint8 ASCAvailability_);

    /**
     * Destructor
     */
    inline virtual  ~ANCASCSettingSet();

    /**
     * Assignment operator
     */
    inline ANCASCSettingSet& operator = (const ANCASCSettingSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ANCASCSettingSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ANCASCSettingSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ANCASCSettingSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ANCASCSettingSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ANCAvailability"

    static const int kANCAvailability = 0;

    /**
     * Clears the field "ANCAvailability".
     *
     * The field will be set to its default value. The hasANCAvailability()
     * method will return false.
     */
    inline void clearANCAvailability();

    /**
     * Checks whether the field "ANCAvailability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setANCAvailability()). Otherwise it will return false.
     */
    inline bool hasANCAvailability () const;

    /**
     * Returns the value of the member "ANCAvailability".
     *
     * 0x0F:  Unavailable
     * 0x01:  Enable
     * 0x00:  Disable
     *
     * @return The value of the field "ANCAvailability"
     */
    inline uint8 getANCAvailability () const;

    /**
     * Sets the value of the member "ANCAvailability".
     *
     * 0x0F:  Unavailable
     * 0x01:  Enable
     * 0x00:  Disable
     *
     * @param ANCAvailability The value which will be set
     */
    inline void setANCAvailability (uint8 ANCAvailability_);

    // API of field "ASCAvailability"

    static const int kASCAvailability = 1;

    /**
     * Clears the field "ASCAvailability".
     *
     * The field will be set to its default value. The hasASCAvailability()
     * method will return false.
     */
    inline void clearASCAvailability();

    /**
     * Checks whether the field "ASCAvailability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setASCAvailability()). Otherwise it will return false.
     */
    inline bool hasASCAvailability () const;

    /**
     * Returns the value of the member "ASCAvailability".
     *
     * 0x0F:  Unavailable
     * 0x01:  Enable
     * 0x00:  Disable
     *
     * @return The value of the field "ASCAvailability"
     */
    inline uint8 getASCAvailability () const;

    /**
     * Sets the value of the member "ASCAvailability".
     *
     * 0x0F:  Unavailable
     * 0x01:  Enable
     * 0x00:  Disable
     *
     * @param ASCAvailability The value which will be set
     */
    inline void setASCAvailability (uint8 ASCAvailability_);

    static const ANCASCSettingSet &getDefaultInstance();

private:

    inline void set_has_ANCAvailability ();

    inline void clear_has_ANCAvailability ();

    inline void set_has_ASCAvailability ();

    inline void clear_has_ASCAvailability ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _ANCAvailability;

    uint8 _ASCAvailability;

};

/**
 * The status message of the property "AmpSoftwareVersion"
 * Updates Amplifier Software Version
 */
class AmpSoftwareVersionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AmpSoftwareVersionStatus ();

    /**
     * Copy constructor
     */
    inline  AmpSoftwareVersionStatus (const AmpSoftwareVersionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AmpSoftwareVersionStatus (uint8 LowerVersion_, uint8 MiddleVersion_, uint8 HigherVersion_);

    /**
     * Destructor
     */
    inline virtual  ~AmpSoftwareVersionStatus();

    /**
     * Assignment operator
     */
    inline AmpSoftwareVersionStatus& operator = (const AmpSoftwareVersionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AmpSoftwareVersionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AmpSoftwareVersionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AmpSoftwareVersionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AmpSoftwareVersionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LowerVersion"

    static const int kLowerVersion = 0;

    /**
     * Clears the field "LowerVersion".
     *
     * The field will be set to its default value. The hasLowerVersion()
     * method will return false.
     */
    inline void clearLowerVersion();

    /**
     * Checks whether the field "LowerVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLowerVersion()). Otherwise it will return false.
     */
    inline bool hasLowerVersion () const;

    /**
     * Returns the value of the member "LowerVersion".
     *
     *
     *
     * @return The value of the field "LowerVersion"
     */
    inline uint8 getLowerVersion () const;

    /**
     * Sets the value of the member "LowerVersion".
     *
     *
     *
     * @param LowerVersion The value which will be set
     */
    inline void setLowerVersion (uint8 LowerVersion_);

    // API of field "MiddleVersion"

    static const int kMiddleVersion = 1;

    /**
     * Clears the field "MiddleVersion".
     *
     * The field will be set to its default value. The hasMiddleVersion()
     * method will return false.
     */
    inline void clearMiddleVersion();

    /**
     * Checks whether the field "MiddleVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMiddleVersion()). Otherwise it will return false.
     */
    inline bool hasMiddleVersion () const;

    /**
     * Returns the value of the member "MiddleVersion".
     *
     *
     *
     * @return The value of the field "MiddleVersion"
     */
    inline uint8 getMiddleVersion () const;

    /**
     * Sets the value of the member "MiddleVersion".
     *
     *
     *
     * @param MiddleVersion The value which will be set
     */
    inline void setMiddleVersion (uint8 MiddleVersion_);

    // API of field "HigherVersion"

    static const int kHigherVersion = 2;

    /**
     * Clears the field "HigherVersion".
     *
     * The field will be set to its default value. The hasHigherVersion()
     * method will return false.
     */
    inline void clearHigherVersion();

    /**
     * Checks whether the field "HigherVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHigherVersion()). Otherwise it will return false.
     */
    inline bool hasHigherVersion () const;

    /**
     * Returns the value of the member "HigherVersion".
     *
     *
     *
     * @return The value of the field "HigherVersion"
     */
    inline uint8 getHigherVersion () const;

    /**
     * Sets the value of the member "HigherVersion".
     *
     *
     *
     * @param HigherVersion The value which will be set
     */
    inline void setHigherVersion (uint8 HigherVersion_);

    static const AmpSoftwareVersionStatus &getDefaultInstance();

private:

    inline void set_has_LowerVersion ();

    inline void clear_has_LowerVersion ();

    inline void set_has_MiddleVersion ();

    inline void clear_has_MiddleVersion ();

    inline void set_has_HigherVersion ();

    inline void clear_has_HigherVersion ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _LowerVersion;

    uint8 _MiddleVersion;

    uint8 _HigherVersion;

};

/**
 * The status message of the property "AmpParameterVersion"
 * Updates Amplifier Parameter Version
 */
class AmpParameterVersionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AmpParameterVersionStatus ();

    /**
     * Copy constructor
     */
    inline  AmpParameterVersionStatus (const AmpParameterVersionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AmpParameterVersionStatus (uint8 LowerVersion_, uint8 MiddleVersion_, uint8 HigherVersion_);

    /**
     * Destructor
     */
    inline virtual  ~AmpParameterVersionStatus();

    /**
     * Assignment operator
     */
    inline AmpParameterVersionStatus& operator = (const AmpParameterVersionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AmpParameterVersionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AmpParameterVersionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AmpParameterVersionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AmpParameterVersionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LowerVersion"

    static const int kLowerVersion = 0;

    /**
     * Clears the field "LowerVersion".
     *
     * The field will be set to its default value. The hasLowerVersion()
     * method will return false.
     */
    inline void clearLowerVersion();

    /**
     * Checks whether the field "LowerVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLowerVersion()). Otherwise it will return false.
     */
    inline bool hasLowerVersion () const;

    /**
     * Returns the value of the member "LowerVersion".
     *
     *
     *
     * @return The value of the field "LowerVersion"
     */
    inline uint8 getLowerVersion () const;

    /**
     * Sets the value of the member "LowerVersion".
     *
     *
     *
     * @param LowerVersion The value which will be set
     */
    inline void setLowerVersion (uint8 LowerVersion_);

    // API of field "MiddleVersion"

    static const int kMiddleVersion = 1;

    /**
     * Clears the field "MiddleVersion".
     *
     * The field will be set to its default value. The hasMiddleVersion()
     * method will return false.
     */
    inline void clearMiddleVersion();

    /**
     * Checks whether the field "MiddleVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMiddleVersion()). Otherwise it will return false.
     */
    inline bool hasMiddleVersion () const;

    /**
     * Returns the value of the member "MiddleVersion".
     *
     *
     *
     * @return The value of the field "MiddleVersion"
     */
    inline uint8 getMiddleVersion () const;

    /**
     * Sets the value of the member "MiddleVersion".
     *
     *
     *
     * @param MiddleVersion The value which will be set
     */
    inline void setMiddleVersion (uint8 MiddleVersion_);

    // API of field "HigherVersion"

    static const int kHigherVersion = 2;

    /**
     * Clears the field "HigherVersion".
     *
     * The field will be set to its default value. The hasHigherVersion()
     * method will return false.
     */
    inline void clearHigherVersion();

    /**
     * Checks whether the field "HigherVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHigherVersion()). Otherwise it will return false.
     */
    inline bool hasHigherVersion () const;

    /**
     * Returns the value of the member "HigherVersion".
     *
     *
     *
     * @return The value of the field "HigherVersion"
     */
    inline uint8 getHigherVersion () const;

    /**
     * Sets the value of the member "HigherVersion".
     *
     *
     *
     * @param HigherVersion The value which will be set
     */
    inline void setHigherVersion (uint8 HigherVersion_);

    static const AmpParameterVersionStatus &getDefaultInstance();

private:

    inline void set_has_LowerVersion ();

    inline void clear_has_LowerVersion ();

    inline void set_has_MiddleVersion ();

    inline void clear_has_MiddleVersion ();

    inline void set_has_HigherVersion ();

    inline void clear_has_HigherVersion ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _LowerVersion;

    uint8 _MiddleVersion;

    uint8 _HigherVersion;

};

/**
 * The status message of the property "AmpHardwareVersion"
 * Updates Amplifier Hardware Version
 */
class AmpHardwareVersionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AmpHardwareVersionStatus ();

    /**
     * Copy constructor
     */
    inline  AmpHardwareVersionStatus (const AmpHardwareVersionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AmpHardwareVersionStatus (uint8 LowerVersion_, uint8 MiddleVersion_, uint8 HigherVersion_);

    /**
     * Destructor
     */
    inline virtual  ~AmpHardwareVersionStatus();

    /**
     * Assignment operator
     */
    inline AmpHardwareVersionStatus& operator = (const AmpHardwareVersionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AmpHardwareVersionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AmpHardwareVersionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AmpHardwareVersionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AmpHardwareVersionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LowerVersion"

    static const int kLowerVersion = 0;

    /**
     * Clears the field "LowerVersion".
     *
     * The field will be set to its default value. The hasLowerVersion()
     * method will return false.
     */
    inline void clearLowerVersion();

    /**
     * Checks whether the field "LowerVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLowerVersion()). Otherwise it will return false.
     */
    inline bool hasLowerVersion () const;

    /**
     * Returns the value of the member "LowerVersion".
     *
     *
     *
     * @return The value of the field "LowerVersion"
     */
    inline uint8 getLowerVersion () const;

    /**
     * Sets the value of the member "LowerVersion".
     *
     *
     *
     * @param LowerVersion The value which will be set
     */
    inline void setLowerVersion (uint8 LowerVersion_);

    // API of field "MiddleVersion"

    static const int kMiddleVersion = 1;

    /**
     * Clears the field "MiddleVersion".
     *
     * The field will be set to its default value. The hasMiddleVersion()
     * method will return false.
     */
    inline void clearMiddleVersion();

    /**
     * Checks whether the field "MiddleVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMiddleVersion()). Otherwise it will return false.
     */
    inline bool hasMiddleVersion () const;

    /**
     * Returns the value of the member "MiddleVersion".
     *
     *
     *
     * @return The value of the field "MiddleVersion"
     */
    inline uint8 getMiddleVersion () const;

    /**
     * Sets the value of the member "MiddleVersion".
     *
     *
     *
     * @param MiddleVersion The value which will be set
     */
    inline void setMiddleVersion (uint8 MiddleVersion_);

    // API of field "HigherVersion"

    static const int kHigherVersion = 2;

    /**
     * Clears the field "HigherVersion".
     *
     * The field will be set to its default value. The hasHigherVersion()
     * method will return false.
     */
    inline void clearHigherVersion();

    /**
     * Checks whether the field "HigherVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHigherVersion()). Otherwise it will return false.
     */
    inline bool hasHigherVersion () const;

    /**
     * Returns the value of the member "HigherVersion".
     *
     *
     *
     * @return The value of the field "HigherVersion"
     */
    inline uint8 getHigherVersion () const;

    /**
     * Sets the value of the member "HigherVersion".
     *
     *
     *
     * @param HigherVersion The value which will be set
     */
    inline void setHigherVersion (uint8 HigherVersion_);

    static const AmpHardwareVersionStatus &getDefaultInstance();

private:

    inline void set_has_LowerVersion ();

    inline void clear_has_LowerVersion ();

    inline void set_has_MiddleVersion ();

    inline void clear_has_MiddleVersion ();

    inline void set_has_HigherVersion ();

    inline void clear_has_HigherVersion ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _LowerVersion;

    uint8 _MiddleVersion;

    uint8 _HigherVersion;

};

/**
 * The status message of the property "SurroundVol"
 * status of actual surround volume value.
 */
class SurroundVolStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SurroundVolStatus ();

    /**
     * Copy constructor
     */
    inline  SurroundVolStatus (const SurroundVolStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SurroundVolStatus (int8 SurroundVol_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::masc_main_fi_types::T_e8_AudioChannel Channel_);

    /**
     * Destructor
     */
    inline virtual  ~SurroundVolStatus();

    /**
     * Assignment operator
     */
    inline SurroundVolStatus& operator = (const SurroundVolStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SurroundVolStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SurroundVolStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SurroundVolStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SurroundVolStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SurroundVol"

    static const int kSurroundVol = 0;

    /**
     * Clears the field "SurroundVol".
     *
     * The field will be set to its default value. The hasSurroundVol()
     * method will return false.
     */
    inline void clearSurroundVol();

    /**
     * Checks whether the field "SurroundVol" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurroundVol()). Otherwise it will return false.
     */
    inline bool hasSurroundVol () const;

    /**
     * Returns the value of the member "SurroundVol".
     *
     * Surround volume value
     *
     * @return The value of the field "SurroundVol"
     */
    inline int8 getSurroundVol () const;

    /**
     * Sets the value of the member "SurroundVol".
     *
     * Surround volume value
     *
     * @param SurroundVol The value which will be set
     */
    inline void setSurroundVol (int8 SurroundVol_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "Channel"

    static const int kChannel = 2;

    /**
     * Clears the field "Channel".
     *
     * The field will be set to its default value. The hasChannel()
     * method will return false.
     */
    inline void clearChannel();

    /**
     * Checks whether the field "Channel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannel()). Otherwise it will return false.
     */
    inline bool hasChannel () const;

    /**
     * Returns the value of the member "Channel".
     *
     * Related channel
     *
     * @return The value of the field "Channel"
     */
    inline ::masc_main_fi_types::T_e8_AudioChannel getChannel () const;

    /**
     * Sets the value of the member "Channel".
     *
     * Related channel
     *
     * @param Channel The value which will be set
     */
    inline void setChannel (::masc_main_fi_types::T_e8_AudioChannel Channel_);

    static const SurroundVolStatus &getDefaultInstance();

private:

    inline void set_has_SurroundVol ();

    inline void clear_has_SurroundVol ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_Channel ();

    inline void clear_has_Channel ();

    uint32 _has_bits_[ (3 + 31) / 32];

    int8 _SurroundVol;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    ::masc_main_fi_types::T_e8_AudioChannel _Channel;

};

/**
 * The set message of the property "SurroundVol"
 * status of actual surround volume value.
 */
class SurroundVolSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SurroundVolSet ();

    /**
     * Copy constructor
     */
    inline  SurroundVolSet (const SurroundVolSet &rhs);

    /**
     * All fields constructor
     */
    inline  SurroundVolSet (::masc_main_fi_types::T_e8_AudioSoundType SoundType_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, int8 SurroundVol_);

    /**
     * Destructor
     */
    inline virtual  ~SurroundVolSet();

    /**
     * Assignment operator
     */
    inline SurroundVolSet& operator = (const SurroundVolSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SurroundVolSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SurroundVolSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SurroundVolSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SurroundVolSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SoundType"

    static const int kSoundType = 0;

    /**
     * Clears the field "SoundType".
     *
     * The field will be set to its default value. The hasSoundType()
     * method will return false.
     */
    inline void clearSoundType();

    /**
     * Checks whether the field "SoundType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundType()). Otherwise it will return false.
     */
    inline bool hasSoundType () const;

    /**
     * Returns the value of the member "SoundType".
     *
     * Type of sound (Surround volume) , it can be absolute or relative
     *
     * @return The value of the field "SoundType"
     */
    inline ::masc_main_fi_types::T_e8_AudioSoundType getSoundType () const;

    /**
     * Sets the value of the member "SoundType".
     *
     * Type of sound (Surround volume) , it can be absolute or relative
     *
     * @param SoundType The value which will be set
     */
    inline void setSoundType (::masc_main_fi_types::T_e8_AudioSoundType SoundType_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "SurroundVol"

    static const int kSurroundVol = 2;

    /**
     * Clears the field "SurroundVol".
     *
     * The field will be set to its default value. The hasSurroundVol()
     * method will return false.
     */
    inline void clearSurroundVol();

    /**
     * Checks whether the field "SurroundVol" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurroundVol()). Otherwise it will return false.
     */
    inline bool hasSurroundVol () const;

    /**
     * Returns the value of the member "SurroundVol".
     *
     * Surround Volume value to set
     *
     * @return The value of the field "SurroundVol"
     */
    inline int8 getSurroundVol () const;

    /**
     * Sets the value of the member "SurroundVol".
     *
     * Surround Volume value to set
     *
     * @param SurroundVol The value which will be set
     */
    inline void setSurroundVol (int8 SurroundVol_);

    static const SurroundVolSet &getDefaultInstance();

private:

    inline void set_has_SoundType ();

    inline void clear_has_SoundType ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_SurroundVol ();

    inline void clear_has_SurroundVol ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudioSoundType _SoundType;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    int8 _SurroundVol;

};

/**
 * The status message of the property "AudioPilotMode"
 * status of actual audio pilot mode.
 */
class AudioPilotModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioPilotModeStatus ();

    /**
     * Copy constructor
     */
    inline  AudioPilotModeStatus (const AudioPilotModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AudioPilotModeStatus (bool AudPilotMode_);

    /**
     * Destructor
     */
    inline virtual  ~AudioPilotModeStatus();

    /**
     * Assignment operator
     */
    inline AudioPilotModeStatus& operator = (const AudioPilotModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioPilotModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioPilotModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioPilotModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioPilotModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudPilotMode"

    static const int kAudPilotMode = 0;

    /**
     * Clears the field "AudPilotMode".
     *
     * The field will be set to its default value. The hasAudPilotMode()
     * method will return false.
     */
    inline void clearAudPilotMode();

    /**
     * Checks whether the field "AudPilotMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudPilotMode()). Otherwise it will return false.
     */
    inline bool hasAudPilotMode () const;

    /**
     * Returns the value of the member "AudPilotMode".
     *
     * TRUE:  audio pilot mode is ON
     * FALSE: audio pilot mode is OFF
     *
     * @return The value of the field "AudPilotMode"
     */
    inline bool getAudPilotMode () const;

    /**
     * Sets the value of the member "AudPilotMode".
     *
     * TRUE:  audio pilot mode is ON
     * FALSE: audio pilot mode is OFF
     *
     * @param AudPilotMode The value which will be set
     */
    inline void setAudPilotMode (bool AudPilotMode_);

    static const AudioPilotModeStatus &getDefaultInstance();

private:

    inline void set_has_AudPilotMode ();

    inline void clear_has_AudPilotMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _AudPilotMode;

};

/**
 * The set message of the property "AudioPilotMode"
 * status of actual audio pilot mode.
 */
class AudioPilotModeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioPilotModeSet ();

    /**
     * Copy constructor
     */
    inline  AudioPilotModeSet (const AudioPilotModeSet &rhs);

    /**
     * All fields constructor
     */
    inline  AudioPilotModeSet (bool AudPilotMode_);

    /**
     * Destructor
     */
    inline virtual  ~AudioPilotModeSet();

    /**
     * Assignment operator
     */
    inline AudioPilotModeSet& operator = (const AudioPilotModeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioPilotModeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioPilotModeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioPilotModeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioPilotModeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudPilotMode"

    static const int kAudPilotMode = 0;

    /**
     * Clears the field "AudPilotMode".
     *
     * The field will be set to its default value. The hasAudPilotMode()
     * method will return false.
     */
    inline void clearAudPilotMode();

    /**
     * Checks whether the field "AudPilotMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudPilotMode()). Otherwise it will return false.
     */
    inline bool hasAudPilotMode () const;

    /**
     * Returns the value of the member "AudPilotMode".
     *
     * TRUE:  audio pilot mode is ON
     * FALSE: audio pilot mode is OFF
     *
     * @return The value of the field "AudPilotMode"
     */
    inline bool getAudPilotMode () const;

    /**
     * Sets the value of the member "AudPilotMode".
     *
     * TRUE:  audio pilot mode is ON
     * FALSE: audio pilot mode is OFF
     *
     * @param AudPilotMode The value which will be set
     */
    inline void setAudPilotMode (bool AudPilotMode_);

    static const AudioPilotModeSet &getDefaultInstance();

private:

    inline void set_has_AudPilotMode ();

    inline void clear_has_AudPilotMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _AudPilotMode;

};

/**
 * The status message of the property "SurroundMode"
 * status of surround mode.
 */
class SurroundModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SurroundModeStatus ();

    /**
     * Copy constructor
     */
    inline  SurroundModeStatus (const SurroundModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SurroundModeStatus (bool SurroundMode_);

    /**
     * Destructor
     */
    inline virtual  ~SurroundModeStatus();

    /**
     * Assignment operator
     */
    inline SurroundModeStatus& operator = (const SurroundModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SurroundModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SurroundModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SurroundModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SurroundModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SurroundMode"

    static const int kSurroundMode = 0;

    /**
     * Clears the field "SurroundMode".
     *
     * The field will be set to its default value. The hasSurroundMode()
     * method will return false.
     */
    inline void clearSurroundMode();

    /**
     * Checks whether the field "SurroundMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurroundMode()). Otherwise it will return false.
     */
    inline bool hasSurroundMode () const;

    /**
     * Returns the value of the member "SurroundMode".
     *
     * TRUE:  surround mode is ON
     * FALSE: surround mode is OFF. Normal mode is set.
     *
     * @return The value of the field "SurroundMode"
     */
    inline bool getSurroundMode () const;

    /**
     * Sets the value of the member "SurroundMode".
     *
     * TRUE:  surround mode is ON
     * FALSE: surround mode is OFF. Normal mode is set.
     *
     * @param SurroundMode The value which will be set
     */
    inline void setSurroundMode (bool SurroundMode_);

    static const SurroundModeStatus &getDefaultInstance();

private:

    inline void set_has_SurroundMode ();

    inline void clear_has_SurroundMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _SurroundMode;

};

/**
 * The set message of the property "SurroundMode"
 * status of surround mode.
 */
class SurroundModeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SurroundModeSet ();

    /**
     * Copy constructor
     */
    inline  SurroundModeSet (const SurroundModeSet &rhs);

    /**
     * All fields constructor
     */
    inline  SurroundModeSet (bool SurroundMode_);

    /**
     * Destructor
     */
    inline virtual  ~SurroundModeSet();

    /**
     * Assignment operator
     */
    inline SurroundModeSet& operator = (const SurroundModeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SurroundModeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SurroundModeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SurroundModeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SurroundModeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SurroundMode"

    static const int kSurroundMode = 0;

    /**
     * Clears the field "SurroundMode".
     *
     * The field will be set to its default value. The hasSurroundMode()
     * method will return false.
     */
    inline void clearSurroundMode();

    /**
     * Checks whether the field "SurroundMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurroundMode()). Otherwise it will return false.
     */
    inline bool hasSurroundMode () const;

    /**
     * Returns the value of the member "SurroundMode".
     *
     * TRUE:  surround mode is ON
     * FALSE: surround mode is OFF. Normal mode is set.
     *
     * @return The value of the field "SurroundMode"
     */
    inline bool getSurroundMode () const;

    /**
     * Sets the value of the member "SurroundMode".
     *
     * TRUE:  surround mode is ON
     * FALSE: surround mode is OFF. Normal mode is set.
     *
     * @param SurroundMode The value which will be set
     */
    inline void setSurroundMode (bool SurroundMode_);

    static const SurroundModeSet &getDefaultInstance();

private:

    inline void set_has_SurroundMode ();

    inline void clear_has_SurroundMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _SurroundMode;

};

/**
 * The status message of the property "AmpDownMixMode"
 * status of amplifier down mix mode.
 */
class AmpDownMixModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AmpDownMixModeStatus ();

    /**
     * Copy constructor
     */
    inline  AmpDownMixModeStatus (const AmpDownMixModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AmpDownMixModeStatus (bool AmpDownMixMode_);

    /**
     * Destructor
     */
    inline virtual  ~AmpDownMixModeStatus();

    /**
     * Assignment operator
     */
    inline AmpDownMixModeStatus& operator = (const AmpDownMixModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AmpDownMixModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AmpDownMixModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AmpDownMixModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AmpDownMixModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AmpDownMixMode"

    static const int kAmpDownMixMode = 0;

    /**
     * Clears the field "AmpDownMixMode".
     *
     * The field will be set to its default value. The hasAmpDownMixMode()
     * method will return false.
     */
    inline void clearAmpDownMixMode();

    /**
     * Checks whether the field "AmpDownMixMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAmpDownMixMode()). Otherwise it will return false.
     */
    inline bool hasAmpDownMixMode () const;

    /**
     * Returns the value of the member "AmpDownMixMode".
     *
     * TRUE:  Amp down mix mode is ON
     * FALSE: Amp down mix mode is OFF
     *
     * @return The value of the field "AmpDownMixMode"
     */
    inline bool getAmpDownMixMode () const;

    /**
     * Sets the value of the member "AmpDownMixMode".
     *
     * TRUE:  Amp down mix mode is ON
     * FALSE: Amp down mix mode is OFF
     *
     * @param AmpDownMixMode The value which will be set
     */
    inline void setAmpDownMixMode (bool AmpDownMixMode_);

    static const AmpDownMixModeStatus &getDefaultInstance();

private:

    inline void set_has_AmpDownMixMode ();

    inline void clear_has_AmpDownMixMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _AmpDownMixMode;

};

/**
 * The set message of the property "AmpDownMixMode"
 * status of amplifier down mix mode.
 */
class AmpDownMixModeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AmpDownMixModeSet ();

    /**
     * Copy constructor
     */
    inline  AmpDownMixModeSet (const AmpDownMixModeSet &rhs);

    /**
     * All fields constructor
     */
    inline  AmpDownMixModeSet (bool AmpDownMixMode_);

    /**
     * Destructor
     */
    inline virtual  ~AmpDownMixModeSet();

    /**
     * Assignment operator
     */
    inline AmpDownMixModeSet& operator = (const AmpDownMixModeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AmpDownMixModeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AmpDownMixModeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AmpDownMixModeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AmpDownMixModeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AmpDownMixMode"

    static const int kAmpDownMixMode = 0;

    /**
     * Clears the field "AmpDownMixMode".
     *
     * The field will be set to its default value. The hasAmpDownMixMode()
     * method will return false.
     */
    inline void clearAmpDownMixMode();

    /**
     * Checks whether the field "AmpDownMixMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAmpDownMixMode()). Otherwise it will return false.
     */
    inline bool hasAmpDownMixMode () const;

    /**
     * Returns the value of the member "AmpDownMixMode".
     *
     * TRUE:  Amp down mix mode is ON
     * FALSE: Amp down mix mode is OFF
     *
     * @return The value of the field "AmpDownMixMode"
     */
    inline bool getAmpDownMixMode () const;

    /**
     * Sets the value of the member "AmpDownMixMode".
     *
     * TRUE:  Amp down mix mode is ON
     * FALSE: Amp down mix mode is OFF
     *
     * @param AmpDownMixMode The value which will be set
     */
    inline void setAmpDownMixMode (bool AmpDownMixMode_);

    static const AmpDownMixModeSet &getDefaultInstance();

private:

    inline void set_has_AmpDownMixMode ();

    inline void clear_has_AmpDownMixMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _AmpDownMixMode;

};

/**
 * The status message of the property "DriverSoundMode"
 * status of driver sound mode.
 */
class DriverSoundModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DriverSoundModeStatus ();

    /**
     * Copy constructor
     */
    inline  DriverSoundModeStatus (const DriverSoundModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DriverSoundModeStatus (bool DriverMode_);

    /**
     * Destructor
     */
    inline virtual  ~DriverSoundModeStatus();

    /**
     * Assignment operator
     */
    inline DriverSoundModeStatus& operator = (const DriverSoundModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DriverSoundModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DriverSoundModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DriverSoundModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DriverSoundModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DriverMode"

    static const int kDriverMode = 0;

    /**
     * Clears the field "DriverMode".
     *
     * The field will be set to its default value. The hasDriverMode()
     * method will return false.
     */
    inline void clearDriverMode();

    /**
     * Checks whether the field "DriverMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDriverMode()). Otherwise it will return false.
     */
    inline bool hasDriverMode () const;

    /**
     * Returns the value of the member "DriverMode".
     *
     * TRUE:  driver sound mode is ON
     * FALSE: driver sound mode is OFF
     *
     * @return The value of the field "DriverMode"
     */
    inline bool getDriverMode () const;

    /**
     * Sets the value of the member "DriverMode".
     *
     * TRUE:  driver sound mode is ON
     * FALSE: driver sound mode is OFF
     *
     * @param DriverMode The value which will be set
     */
    inline void setDriverMode (bool DriverMode_);

    static const DriverSoundModeStatus &getDefaultInstance();

private:

    inline void set_has_DriverMode ();

    inline void clear_has_DriverMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _DriverMode;

};

/**
 * The set message of the property "DriverSoundMode"
 * status of driver sound mode.
 */
class DriverSoundModeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DriverSoundModeSet ();

    /**
     * Copy constructor
     */
    inline  DriverSoundModeSet (const DriverSoundModeSet &rhs);

    /**
     * All fields constructor
     */
    inline  DriverSoundModeSet (bool DriverMode_);

    /**
     * Destructor
     */
    inline virtual  ~DriverSoundModeSet();

    /**
     * Assignment operator
     */
    inline DriverSoundModeSet& operator = (const DriverSoundModeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DriverSoundModeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DriverSoundModeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DriverSoundModeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DriverSoundModeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DriverMode"

    static const int kDriverMode = 0;

    /**
     * Clears the field "DriverMode".
     *
     * The field will be set to its default value. The hasDriverMode()
     * method will return false.
     */
    inline void clearDriverMode();

    /**
     * Checks whether the field "DriverMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDriverMode()). Otherwise it will return false.
     */
    inline bool hasDriverMode () const;

    /**
     * Returns the value of the member "DriverMode".
     *
     * TRUE:  driver sound mode is ON
     * FALSE: driver sound mode is OFF
     *
     * @return The value of the field "DriverMode"
     */
    inline bool getDriverMode () const;

    /**
     * Sets the value of the member "DriverMode".
     *
     * TRUE:  driver sound mode is ON
     * FALSE: driver sound mode is OFF
     *
     * @param DriverMode The value which will be set
     */
    inline void setDriverMode (bool DriverMode_);

    static const DriverSoundModeSet &getDefaultInstance();

private:

    inline void set_has_DriverMode ();

    inline void clear_has_DriverMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _DriverMode;

};

/**
 * The status message of the property "RearSoundMode"
 * status of driver sound mode.
 */
class RearSoundModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RearSoundModeStatus ();

    /**
     * Copy constructor
     */
    inline  RearSoundModeStatus (const RearSoundModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RearSoundModeStatus (bool RearMode_);

    /**
     * Destructor
     */
    inline virtual  ~RearSoundModeStatus();

    /**
     * Assignment operator
     */
    inline RearSoundModeStatus& operator = (const RearSoundModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RearSoundModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RearSoundModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RearSoundModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RearSoundModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RearMode"

    static const int kRearMode = 0;

    /**
     * Clears the field "RearMode".
     *
     * The field will be set to its default value. The hasRearMode()
     * method will return false.
     */
    inline void clearRearMode();

    /**
     * Checks whether the field "RearMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRearMode()). Otherwise it will return false.
     */
    inline bool hasRearMode () const;

    /**
     * Returns the value of the member "RearMode".
     *
     * TRUE:  Rear sound mode is ON
     * FALSE: Rear sound mode is OFF
     *
     * @return The value of the field "RearMode"
     */
    inline bool getRearMode () const;

    /**
     * Sets the value of the member "RearMode".
     *
     * TRUE:  Rear sound mode is ON
     * FALSE: Rear sound mode is OFF
     *
     * @param RearMode The value which will be set
     */
    inline void setRearMode (bool RearMode_);

    static const RearSoundModeStatus &getDefaultInstance();

private:

    inline void set_has_RearMode ();

    inline void clear_has_RearMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _RearMode;

};

/**
 * The set message of the property "RearSoundMode"
 * status of driver sound mode.
 */
class RearSoundModeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RearSoundModeSet ();

    /**
     * Copy constructor
     */
    inline  RearSoundModeSet (const RearSoundModeSet &rhs);

    /**
     * All fields constructor
     */
    inline  RearSoundModeSet (bool RearMode_);

    /**
     * Destructor
     */
    inline virtual  ~RearSoundModeSet();

    /**
     * Assignment operator
     */
    inline RearSoundModeSet& operator = (const RearSoundModeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RearSoundModeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RearSoundModeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RearSoundModeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RearSoundModeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RearMode"

    static const int kRearMode = 0;

    /**
     * Clears the field "RearMode".
     *
     * The field will be set to its default value. The hasRearMode()
     * method will return false.
     */
    inline void clearRearMode();

    /**
     * Checks whether the field "RearMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRearMode()). Otherwise it will return false.
     */
    inline bool hasRearMode () const;

    /**
     * Returns the value of the member "RearMode".
     *
     * TRUE:  Rear sound mode is ON
     * FALSE: Rear sound mode is OFF
     *
     * @return The value of the field "RearMode"
     */
    inline bool getRearMode () const;

    /**
     * Sets the value of the member "RearMode".
     *
     * TRUE:  Rear sound mode is ON
     * FALSE: Rear sound mode is OFF
     *
     * @param RearMode The value which will be set
     */
    inline void setRearMode (bool RearMode_);

    static const RearSoundModeSet &getDefaultInstance();

private:

    inline void set_has_RearMode ();

    inline void clear_has_RearMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _RearMode;

};

/**
 * The status message of the property "AudioOFFMuteState"
 * This property will not used to activate a mute. It is only used to give the status of AUDIO OFF Mute in the audio-stack to fc_audiomanager
 */
class AudioOFFMuteStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioOFFMuteStateStatus ();

    /**
     * Copy constructor
     */
    inline  AudioOFFMuteStateStatus (const AudioOFFMuteStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AudioOFFMuteStateStatus (uint8 MuteState_);

    /**
     * Destructor
     */
    inline virtual  ~AudioOFFMuteStateStatus();

    /**
     * Assignment operator
     */
    inline AudioOFFMuteStateStatus& operator = (const AudioOFFMuteStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioOFFMuteStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioOFFMuteStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioOFFMuteStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioOFFMuteStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MuteState"

    static const int kMuteState = 0;

    /**
     * Clears the field "MuteState".
     *
     * The field will be set to its default value. The hasMuteState()
     * method will return false.
     */
    inline void clearMuteState();

    /**
     * Checks whether the field "MuteState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMuteState()). Otherwise it will return false.
     */
    inline bool hasMuteState () const;

    /**
     * Returns the value of the member "MuteState".
     *
     * 0:  Mute OFF
     * 1:  Mute ON
     *
     * @return The value of the field "MuteState"
     */
    inline uint8 getMuteState () const;

    /**
     * Sets the value of the member "MuteState".
     *
     * 0:  Mute OFF
     * 1:  Mute ON
     *
     * @param MuteState The value which will be set
     */
    inline void setMuteState (uint8 MuteState_);

    static const AudioOFFMuteStateStatus &getDefaultInstance();

private:

    inline void set_has_MuteState ();

    inline void clear_has_MuteState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _MuteState;

};

/**
 * The set message of the property "AudioOFFMuteState"
 * This property will not used to activate a mute. It is only used to give the status of AUDIO OFF Mute in the audio-stack to fc_audiomanager
 */
class AudioOFFMuteStateSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioOFFMuteStateSet ();

    /**
     * Copy constructor
     */
    inline  AudioOFFMuteStateSet (const AudioOFFMuteStateSet &rhs);

    /**
     * All fields constructor
     */
    inline  AudioOFFMuteStateSet (uint8 MuteState_);

    /**
     * Destructor
     */
    inline virtual  ~AudioOFFMuteStateSet();

    /**
     * Assignment operator
     */
    inline AudioOFFMuteStateSet& operator = (const AudioOFFMuteStateSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioOFFMuteStateSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioOFFMuteStateSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioOFFMuteStateSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioOFFMuteStateSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MuteState"

    static const int kMuteState = 0;

    /**
     * Clears the field "MuteState".
     *
     * The field will be set to its default value. The hasMuteState()
     * method will return false.
     */
    inline void clearMuteState();

    /**
     * Checks whether the field "MuteState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMuteState()). Otherwise it will return false.
     */
    inline bool hasMuteState () const;

    /**
     * Returns the value of the member "MuteState".
     *
     * 0:  Mute OFF
     * 1:  Mute ON
     *
     * @return The value of the field "MuteState"
     */
    inline uint8 getMuteState () const;

    /**
     * Sets the value of the member "MuteState".
     *
     * 0:  Mute OFF
     * 1:  Mute ON
     *
     * @param MuteState The value which will be set
     */
    inline void setMuteState (uint8 MuteState_);

    static const AudioOFFMuteStateSet &getDefaultInstance();

private:

    inline void set_has_MuteState ();

    inline void clear_has_MuteState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _MuteState;

};

/**
 * The status message of the property "MicrophoneConnectionStatus"
 * Status of microphone connection.
 */
class MicrophoneConnectionStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MicrophoneConnectionStatusStatus ();

    /**
     * Copy constructor
     */
    inline  MicrophoneConnectionStatusStatus (const MicrophoneConnectionStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MicrophoneConnectionStatusStatus (const ::masc_main_fi_types::T_MicrophoneConnectionStatusList& MicrophoneConnectionStatusList_);

    /**
     * Destructor
     */
    inline virtual  ~MicrophoneConnectionStatusStatus();

    /**
     * Assignment operator
     */
    inline MicrophoneConnectionStatusStatus& operator = (const MicrophoneConnectionStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MicrophoneConnectionStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MicrophoneConnectionStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MicrophoneConnectionStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MicrophoneConnectionStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MicrophoneConnectionStatusList"

    static const int kMicrophoneConnectionStatusList = 0;

    /**
     * Clears the field "MicrophoneConnectionStatusList".
     *
     * The field will be set to its default value. The hasMicrophoneConnectionStatusList()
     * method will return false.
     */
    inline void clearMicrophoneConnectionStatusList();

    /**
     * Checks whether the field "MicrophoneConnectionStatusList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMicrophoneConnectionStatusList()). Otherwise it will return false.
     */
    inline bool hasMicrophoneConnectionStatusList () const;

    /**
     * Returns the value of the member "MicrophoneConnectionStatusList".
     *
     * Last measured connection status of all existing microphones.
     *
     * @return The value of the field "MicrophoneConnectionStatusList"
     */
    inline const ::masc_main_fi_types::T_MicrophoneConnectionStatusList& getMicrophoneConnectionStatusList () const;

    /**
     * Retrieves the value of the field "MicrophoneConnectionStatusList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MicrophoneConnectionStatusList".
     */
    inline ::masc_main_fi_types::T_MicrophoneConnectionStatusList& getMicrophoneConnectionStatusListMutable ();

    /**
     * Sets the value of the member "MicrophoneConnectionStatusList".
     *
     * Last measured connection status of all existing microphones.
     *
     * @param MicrophoneConnectionStatusList The value which will be set
     */
    inline void setMicrophoneConnectionStatusList (const ::masc_main_fi_types::T_MicrophoneConnectionStatusList& MicrophoneConnectionStatusList_);

    static const MicrophoneConnectionStatusStatus &getDefaultInstance();

private:

    static const ::std::vector< ::masc_main_fi_types::T_MicrophoneConnectionStatus >& getT_MicrophoneConnectionStatusList_DefaultInstance ();

    inline void set_has_MicrophoneConnectionStatusList ();

    inline void clear_has_MicrophoneConnectionStatusList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_MicrophoneConnectionStatusList _MicrophoneConnectionStatusList;

};

/**
 * The status message of the property "Connection"
 * This property gives information about the connection status to the various MCAN units.
 */
class ConnectionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectionStatus ();

    /**
     * Copy constructor
     */
    inline  ConnectionStatus (const ConnectionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectionStatus (const ::std::vector< ::masc_main_fi_types::T_BOSE_UnitConnectionStatus >& arConnectionStatusList_);

    /**
     * Destructor
     */
    inline virtual  ~ConnectionStatus();

    /**
     * Assignment operator
     */
    inline ConnectionStatus& operator = (const ConnectionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arConnectionStatusList"

    static const int kArConnectionStatusList = 0;

    /**
     * Clears the field "arConnectionStatusList".
     *
     * The field will be set to its default value. The hasArConnectionStatusList()
     * method will return false.
     */
    inline void clearArConnectionStatusList();

    /**
     * Checks whether the field "arConnectionStatusList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArConnectionStatusList()). Otherwise it will return false.
     */
    inline bool hasArConnectionStatusList () const;

    /**
     * Returns the value of the member "arConnectionStatusList".
     *
     * List with connection status of each MCAN unit.
     *
     * @return The value of the field "arConnectionStatusList"
     */
    inline const ::std::vector< ::masc_main_fi_types::T_BOSE_UnitConnectionStatus >& getArConnectionStatusList () const;

    /**
     * Retrieves the value of the field "arConnectionStatusList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arConnectionStatusList".
     */
    inline ::std::vector< ::masc_main_fi_types::T_BOSE_UnitConnectionStatus >& getArConnectionStatusListMutable ();

    /**
     * Sets the value of the member "arConnectionStatusList".
     *
     * List with connection status of each MCAN unit.
     *
     * @param arConnectionStatusList The value which will be set
     */
    inline void setArConnectionStatusList (const ::std::vector< ::masc_main_fi_types::T_BOSE_UnitConnectionStatus >& arConnectionStatusList_);

    static const ConnectionStatus &getDefaultInstance();

private:

    static const ::std::vector< ::masc_main_fi_types::T_BOSE_UnitConnectionStatus >& getT_BOSE_UnitConnectionStatusList_DefaultInstance ();

    inline void set_has_arConnectionStatusList ();

    inline void clear_has_arConnectionStatusList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::masc_main_fi_types::T_BOSE_UnitConnectionStatus > _arConnectionStatusList;

};

/**
 * The status message of the property "VolumeList"
 * Status of volume of various AudVolumeTypes.
 */
class VolumeListStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VolumeListStatus ();

    /**
     * Copy constructor
     */
    inline  VolumeListStatus (const VolumeListStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VolumeListStatus (const ::masc_main_fi_types::T_Aud_VolumeStatusList& AudVolumeList_);

    /**
     * Destructor
     */
    inline virtual  ~VolumeListStatus();

    /**
     * Assignment operator
     */
    inline VolumeListStatus& operator = (const VolumeListStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VolumeListStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VolumeListStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VolumeListStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VolumeListStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudVolumeList"

    static const int kAudVolumeList = 0;

    /**
     * Clears the field "AudVolumeList".
     *
     * The field will be set to its default value. The hasAudVolumeList()
     * method will return false.
     */
    inline void clearAudVolumeList();

    /**
     * Checks whether the field "AudVolumeList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudVolumeList()). Otherwise it will return false.
     */
    inline bool hasAudVolumeList () const;

    /**
     * Returns the value of the member "AudVolumeList".
     *
     * Last measured volumes of various AudVolumeTypes.
     *
     * @return The value of the field "AudVolumeList"
     */
    inline const ::masc_main_fi_types::T_Aud_VolumeStatusList& getAudVolumeList () const;

    /**
     * Retrieves the value of the field "AudVolumeList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AudVolumeList".
     */
    inline ::masc_main_fi_types::T_Aud_VolumeStatusList& getAudVolumeListMutable ();

    /**
     * Sets the value of the member "AudVolumeList".
     *
     * Last measured volumes of various AudVolumeTypes.
     *
     * @param AudVolumeList The value which will be set
     */
    inline void setAudVolumeList (const ::masc_main_fi_types::T_Aud_VolumeStatusList& AudVolumeList_);

    static const VolumeListStatus &getDefaultInstance();

private:

    static const ::std::vector< ::masc_main_fi_types::T_Aud_VolumeStatus >& getT_Aud_VolumeStatusList_DefaultInstance ();

    inline void set_has_AudVolumeList ();

    inline void clear_has_AudVolumeList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_Aud_VolumeStatusList _AudVolumeList;

};

/**
 * The set message of the property "VolumeList"
 * Status of volume of various AudVolumeTypes.
 */
class VolumeListSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VolumeListSet ();

    /**
     * Copy constructor
     */
    inline  VolumeListSet (const VolumeListSet &rhs);

    /**
     * All fields constructor
     */
    inline  VolumeListSet (const ::masc_main_fi_types::T_Aud_VolumeStatusList& AudVolumeList_);

    /**
     * Destructor
     */
    inline virtual  ~VolumeListSet();

    /**
     * Assignment operator
     */
    inline VolumeListSet& operator = (const VolumeListSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VolumeListSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VolumeListSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VolumeListSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VolumeListSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudVolumeList"

    static const int kAudVolumeList = 0;

    /**
     * Clears the field "AudVolumeList".
     *
     * The field will be set to its default value. The hasAudVolumeList()
     * method will return false.
     */
    inline void clearAudVolumeList();

    /**
     * Checks whether the field "AudVolumeList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudVolumeList()). Otherwise it will return false.
     */
    inline bool hasAudVolumeList () const;

    /**
     * Returns the value of the member "AudVolumeList".
     *
     *
     *
     * @return The value of the field "AudVolumeList"
     */
    inline const ::masc_main_fi_types::T_Aud_VolumeStatusList& getAudVolumeList () const;

    /**
     * Retrieves the value of the field "AudVolumeList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AudVolumeList".
     */
    inline ::masc_main_fi_types::T_Aud_VolumeStatusList& getAudVolumeListMutable ();

    /**
     * Sets the value of the member "AudVolumeList".
     *
     *
     *
     * @param AudVolumeList The value which will be set
     */
    inline void setAudVolumeList (const ::masc_main_fi_types::T_Aud_VolumeStatusList& AudVolumeList_);

    static const VolumeListSet &getDefaultInstance();

private:

    static const ::std::vector< ::masc_main_fi_types::T_Aud_VolumeStatus >& getT_Aud_VolumeStatusList_DefaultInstance ();

    inline void set_has_AudVolumeList ();

    inline void clear_has_AudVolumeList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_Aud_VolumeStatusList _AudVolumeList;

};

/**
 * The status message of the property "BTAudioInLevel"
 * status of changed BT audio input level.
 */
class BTAudioInLevelStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BTAudioInLevelStatus ();

    /**
     * Copy constructor
     */
    inline  BTAudioInLevelStatus (const BTAudioInLevelStatus &rhs);

    /**
     * All fields constructor
     */
    inline  BTAudioInLevelStatus (::masc_main_fi_types::T_e8_BTAudioInLevel BTAudioInLevel_);

    /**
     * Destructor
     */
    inline virtual  ~BTAudioInLevelStatus();

    /**
     * Assignment operator
     */
    inline BTAudioInLevelStatus& operator = (const BTAudioInLevelStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BTAudioInLevelStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BTAudioInLevelStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BTAudioInLevelStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BTAudioInLevelStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BTAudioInLevel"

    static const int kBTAudioInLevel = 0;

    /**
     * Clears the field "BTAudioInLevel".
     *
     * The field will be set to its default value. The hasBTAudioInLevel()
     * method will return false.
     */
    inline void clearBTAudioInLevel();

    /**
     * Checks whether the field "BTAudioInLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTAudioInLevel()). Otherwise it will return false.
     */
    inline bool hasBTAudioInLevel () const;

    /**
     * Returns the value of the member "BTAudioInLevel".
     *
     * BT-Sensivity Level
     *
     * @return The value of the field "BTAudioInLevel"
     */
    inline ::masc_main_fi_types::T_e8_BTAudioInLevel getBTAudioInLevel () const;

    /**
     * Sets the value of the member "BTAudioInLevel".
     *
     * BT-Sensivity Level
     *
     * @param BTAudioInLevel The value which will be set
     */
    inline void setBTAudioInLevel (::masc_main_fi_types::T_e8_BTAudioInLevel BTAudioInLevel_);

    static const BTAudioInLevelStatus &getDefaultInstance();

private:

    inline void set_has_BTAudioInLevel ();

    inline void clear_has_BTAudioInLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_BTAudioInLevel _BTAudioInLevel;

};

/**
 * The set message of the property "BTAudioInLevel"
 * status of changed BT audio input level.
 */
class BTAudioInLevelSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BTAudioInLevelSet ();

    /**
     * Copy constructor
     */
    inline  BTAudioInLevelSet (const BTAudioInLevelSet &rhs);

    /**
     * All fields constructor
     */
    inline  BTAudioInLevelSet (::masc_main_fi_types::T_e8_BTAudioInLevel BTAudioInLevel_);

    /**
     * Destructor
     */
    inline virtual  ~BTAudioInLevelSet();

    /**
     * Assignment operator
     */
    inline BTAudioInLevelSet& operator = (const BTAudioInLevelSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BTAudioInLevelSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BTAudioInLevelSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BTAudioInLevelSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BTAudioInLevelSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BTAudioInLevel"

    static const int kBTAudioInLevel = 0;

    /**
     * Clears the field "BTAudioInLevel".
     *
     * The field will be set to its default value. The hasBTAudioInLevel()
     * method will return false.
     */
    inline void clearBTAudioInLevel();

    /**
     * Checks whether the field "BTAudioInLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTAudioInLevel()). Otherwise it will return false.
     */
    inline bool hasBTAudioInLevel () const;

    /**
     * Returns the value of the member "BTAudioInLevel".
     *
     * Input BT-Sensivity Level
     *
     * @return The value of the field "BTAudioInLevel"
     */
    inline ::masc_main_fi_types::T_e8_BTAudioInLevel getBTAudioInLevel () const;

    /**
     * Sets the value of the member "BTAudioInLevel".
     *
     * Input BT-Sensivity Level
     *
     * @param BTAudioInLevel The value which will be set
     */
    inline void setBTAudioInLevel (::masc_main_fi_types::T_e8_BTAudioInLevel BTAudioInLevel_);

    static const BTAudioInLevelSet &getDefaultInstance();

private:

    inline void set_has_BTAudioInLevel ();

    inline void clear_has_BTAudioInLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_BTAudioInLevel _BTAudioInLevel;

};

/**
 * The status message of the property "EngineeringData"
 * Status of Engineering Data of various AudEDTypes.
 */
class EngineeringDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EngineeringDataStatus ();

    /**
     * Copy constructor
     */
    inline  EngineeringDataStatus (const EngineeringDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  EngineeringDataStatus (const ::masc_main_fi_types::T_Aud_EDStatusList& EngineeringDataList_);

    /**
     * Destructor
     */
    inline virtual  ~EngineeringDataStatus();

    /**
     * Assignment operator
     */
    inline EngineeringDataStatus& operator = (const EngineeringDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EngineeringDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EngineeringDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EngineeringDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EngineeringDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "EngineeringDataList"

    static const int kEngineeringDataList = 0;

    /**
     * Clears the field "EngineeringDataList".
     *
     * The field will be set to its default value. The hasEngineeringDataList()
     * method will return false.
     */
    inline void clearEngineeringDataList();

    /**
     * Checks whether the field "EngineeringDataList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEngineeringDataList()). Otherwise it will return false.
     */
    inline bool hasEngineeringDataList () const;

    /**
     * Returns the value of the member "EngineeringDataList".
     *
     * Last measured value of various EngineeringData Types.
     *
     * @return The value of the field "EngineeringDataList"
     */
    inline const ::masc_main_fi_types::T_Aud_EDStatusList& getEngineeringDataList () const;

    /**
     * Retrieves the value of the field "EngineeringDataList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "EngineeringDataList".
     */
    inline ::masc_main_fi_types::T_Aud_EDStatusList& getEngineeringDataListMutable ();

    /**
     * Sets the value of the member "EngineeringDataList".
     *
     * Last measured value of various EngineeringData Types.
     *
     * @param EngineeringDataList The value which will be set
     */
    inline void setEngineeringDataList (const ::masc_main_fi_types::T_Aud_EDStatusList& EngineeringDataList_);

    static const EngineeringDataStatus &getDefaultInstance();

private:

    static const ::std::vector< ::masc_main_fi_types::T_Aud_EDStatus >& getT_Aud_EDStatusList_DefaultInstance ();

    inline void set_has_EngineeringDataList ();

    inline void clear_has_EngineeringDataList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_Aud_EDStatusList _EngineeringDataList;

};

/**
 * The set message of the property "EngineeringData"
 * Status of Engineering Data of various AudEDTypes.
 */
class EngineeringDataSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EngineeringDataSet ();

    /**
     * Copy constructor
     */
    inline  EngineeringDataSet (const EngineeringDataSet &rhs);

    /**
     * All fields constructor
     */
    inline  EngineeringDataSet (const ::masc_main_fi_types::T_Aud_EDStatusList& EngineeringDataList_);

    /**
     * Destructor
     */
    inline virtual  ~EngineeringDataSet();

    /**
     * Assignment operator
     */
    inline EngineeringDataSet& operator = (const EngineeringDataSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EngineeringDataSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EngineeringDataSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EngineeringDataSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EngineeringDataSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "EngineeringDataList"

    static const int kEngineeringDataList = 0;

    /**
     * Clears the field "EngineeringDataList".
     *
     * The field will be set to its default value. The hasEngineeringDataList()
     * method will return false.
     */
    inline void clearEngineeringDataList();

    /**
     * Checks whether the field "EngineeringDataList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEngineeringDataList()). Otherwise it will return false.
     */
    inline bool hasEngineeringDataList () const;

    /**
     * Returns the value of the member "EngineeringDataList".
     *
     * Set functionality will be effective only for valid
     * engineering data types and for read only types
     * the set functionality is ignored.
     *
     * @return The value of the field "EngineeringDataList"
     */
    inline const ::masc_main_fi_types::T_Aud_EDStatusList& getEngineeringDataList () const;

    /**
     * Retrieves the value of the field "EngineeringDataList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "EngineeringDataList".
     */
    inline ::masc_main_fi_types::T_Aud_EDStatusList& getEngineeringDataListMutable ();

    /**
     * Sets the value of the member "EngineeringDataList".
     *
     * Set functionality will be effective only for valid
     * engineering data types and for read only types
     * the set functionality is ignored.
     *
     * @param EngineeringDataList The value which will be set
     */
    inline void setEngineeringDataList (const ::masc_main_fi_types::T_Aud_EDStatusList& EngineeringDataList_);

    static const EngineeringDataSet &getDefaultInstance();

private:

    static const ::std::vector< ::masc_main_fi_types::T_Aud_EDStatus >& getT_Aud_EDStatusList_DefaultInstance ();

    inline void set_has_EngineeringDataList ();

    inline void clear_has_EngineeringDataList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_Aud_EDStatusList _EngineeringDataList;

};

/**
 * The status message of the property "SurroundSetting"
 * Property for setting the Surround value.
 */
class SurroundSettingStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SurroundSettingStatus ();

    /**
     * Copy constructor
     */
    inline  SurroundSettingStatus (const SurroundSettingStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SurroundSettingStatus (::masc_main_fi_types::T_e8_SurroundSetting Surround_);

    /**
     * Destructor
     */
    inline virtual  ~SurroundSettingStatus();

    /**
     * Assignment operator
     */
    inline SurroundSettingStatus& operator = (const SurroundSettingStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SurroundSettingStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SurroundSettingStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SurroundSettingStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SurroundSettingStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Surround"

    static const int kSurround = 0;

    /**
     * Clears the field "Surround".
     *
     * The field will be set to its default value. The hasSurround()
     * method will return false.
     */
    inline void clearSurround();

    /**
     * Checks whether the field "Surround" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurround()). Otherwise it will return false.
     */
    inline bool hasSurround () const;

    /**
     * Returns the value of the member "Surround".
     *
     * Value of Surround mode
     *
     * @return The value of the field "Surround"
     */
    inline ::masc_main_fi_types::T_e8_SurroundSetting getSurround () const;

    /**
     * Sets the value of the member "Surround".
     *
     * Value of Surround mode
     *
     * @param Surround The value which will be set
     */
    inline void setSurround (::masc_main_fi_types::T_e8_SurroundSetting Surround_);

    static const SurroundSettingStatus &getDefaultInstance();

private:

    inline void set_has_Surround ();

    inline void clear_has_Surround ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_SurroundSetting _Surround;

};

/**
 * The set message of the property "SurroundSetting"
 * Property for setting the Surround value.
 */
class SurroundSettingSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SurroundSettingSet ();

    /**
     * Copy constructor
     */
    inline  SurroundSettingSet (const SurroundSettingSet &rhs);

    /**
     * All fields constructor
     */
    inline  SurroundSettingSet (::masc_main_fi_types::T_e8_SurroundSetting Surround_);

    /**
     * Destructor
     */
    inline virtual  ~SurroundSettingSet();

    /**
     * Assignment operator
     */
    inline SurroundSettingSet& operator = (const SurroundSettingSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SurroundSettingSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SurroundSettingSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SurroundSettingSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SurroundSettingSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Surround"

    static const int kSurround = 0;

    /**
     * Clears the field "Surround".
     *
     * The field will be set to its default value. The hasSurround()
     * method will return false.
     */
    inline void clearSurround();

    /**
     * Checks whether the field "Surround" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurround()). Otherwise it will return false.
     */
    inline bool hasSurround () const;

    /**
     * Returns the value of the member "Surround".
     *
     * Value of Surround mode
     *
     * @return The value of the field "Surround"
     */
    inline ::masc_main_fi_types::T_e8_SurroundSetting getSurround () const;

    /**
     * Sets the value of the member "Surround".
     *
     * Value of Surround mode
     *
     * @param Surround The value which will be set
     */
    inline void setSurround (::masc_main_fi_types::T_e8_SurroundSetting Surround_);

    static const SurroundSettingSet &getDefaultInstance();

private:

    inline void set_has_Surround ();

    inline void clear_has_Surround ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_SurroundSetting _Surround;

};

/**
 * The status message of the property "VolumeLock"
 * Property for setting the Volume Lock.
 */
class VolumeLockStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VolumeLockStatus ();

    /**
     * Copy constructor
     */
    inline  VolumeLockStatus (const VolumeLockStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VolumeLockStatus (::masc_main_fi_types::T_e8_VolumeLock VolumeLockType_, ::masc_main_fi_types::T_e8_Requester Requester_);

    /**
     * Destructor
     */
    inline virtual  ~VolumeLockStatus();

    /**
     * Assignment operator
     */
    inline VolumeLockStatus& operator = (const VolumeLockStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VolumeLockStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VolumeLockStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VolumeLockStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VolumeLockStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VolumeLockType"

    static const int kVolumeLockType = 0;

    /**
     * Clears the field "VolumeLockType".
     *
     * The field will be set to its default value. The hasVolumeLockType()
     * method will return false.
     */
    inline void clearVolumeLockType();

    /**
     * Checks whether the field "VolumeLockType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolumeLockType()). Otherwise it will return false.
     */
    inline bool hasVolumeLockType () const;

    /**
     * Returns the value of the member "VolumeLockType".
     *
     * Value of Volume Lock mode
     *
     * @return The value of the field "VolumeLockType"
     */
    inline ::masc_main_fi_types::T_e8_VolumeLock getVolumeLockType () const;

    /**
     * Sets the value of the member "VolumeLockType".
     *
     * Value of Volume Lock mode
     *
     * @param VolumeLockType The value which will be set
     */
    inline void setVolumeLockType (::masc_main_fi_types::T_e8_VolumeLock VolumeLockType_);

    // API of field "Requester"

    static const int kRequester = 1;

    /**
     * Clears the field "Requester".
     *
     * The field will be set to its default value. The hasRequester()
     * method will return false.
     */
    inline void clearRequester();

    /**
     * Checks whether the field "Requester" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequester()). Otherwise it will return false.
     */
    inline bool hasRequester () const;

    /**
     * Returns the value of the member "Requester".
     *
     * Initiator of the Volume Lock
     *
     * @return The value of the field "Requester"
     */
    inline ::masc_main_fi_types::T_e8_Requester getRequester () const;

    /**
     * Sets the value of the member "Requester".
     *
     * Initiator of the Volume Lock
     *
     * @param Requester The value which will be set
     */
    inline void setRequester (::masc_main_fi_types::T_e8_Requester Requester_);

    static const VolumeLockStatus &getDefaultInstance();

private:

    inline void set_has_VolumeLockType ();

    inline void clear_has_VolumeLockType ();

    inline void set_has_Requester ();

    inline void clear_has_Requester ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::masc_main_fi_types::T_e8_VolumeLock _VolumeLockType;

    ::masc_main_fi_types::T_e8_Requester _Requester;

};

/**
 * The set message of the property "VolumeLock"
 * Property for setting the Volume Lock.
 */
class VolumeLockSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VolumeLockSet ();

    /**
     * Copy constructor
     */
    inline  VolumeLockSet (const VolumeLockSet &rhs);

    /**
     * All fields constructor
     */
    inline  VolumeLockSet (::masc_main_fi_types::T_e8_VolumeLock VolumeLockType_, ::masc_main_fi_types::T_e8_Requester Requester_);

    /**
     * Destructor
     */
    inline virtual  ~VolumeLockSet();

    /**
     * Assignment operator
     */
    inline VolumeLockSet& operator = (const VolumeLockSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VolumeLockSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VolumeLockSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VolumeLockSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VolumeLockSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VolumeLockType"

    static const int kVolumeLockType = 0;

    /**
     * Clears the field "VolumeLockType".
     *
     * The field will be set to its default value. The hasVolumeLockType()
     * method will return false.
     */
    inline void clearVolumeLockType();

    /**
     * Checks whether the field "VolumeLockType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolumeLockType()). Otherwise it will return false.
     */
    inline bool hasVolumeLockType () const;

    /**
     * Returns the value of the member "VolumeLockType".
     *
     * Value of Volume Lock mode
     *
     * @return The value of the field "VolumeLockType"
     */
    inline ::masc_main_fi_types::T_e8_VolumeLock getVolumeLockType () const;

    /**
     * Sets the value of the member "VolumeLockType".
     *
     * Value of Volume Lock mode
     *
     * @param VolumeLockType The value which will be set
     */
    inline void setVolumeLockType (::masc_main_fi_types::T_e8_VolumeLock VolumeLockType_);

    // API of field "Requester"

    static const int kRequester = 1;

    /**
     * Clears the field "Requester".
     *
     * The field will be set to its default value. The hasRequester()
     * method will return false.
     */
    inline void clearRequester();

    /**
     * Checks whether the field "Requester" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequester()). Otherwise it will return false.
     */
    inline bool hasRequester () const;

    /**
     * Returns the value of the member "Requester".
     *
     * Initiator of the Volume Lock
     *
     * @return The value of the field "Requester"
     */
    inline ::masc_main_fi_types::T_e8_Requester getRequester () const;

    /**
     * Sets the value of the member "Requester".
     *
     * Initiator of the Volume Lock
     *
     * @param Requester The value which will be set
     */
    inline void setRequester (::masc_main_fi_types::T_e8_Requester Requester_);

    static const VolumeLockSet &getDefaultInstance();

private:

    inline void set_has_VolumeLockType ();

    inline void clear_has_VolumeLockType ();

    inline void set_has_Requester ();

    inline void clear_has_Requester ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::masc_main_fi_types::T_e8_VolumeLock _VolumeLockType;

    ::masc_main_fi_types::T_e8_Requester _Requester;

};

/**
 * The status message of the property "AmpAvailFunction"
 * status of Ampliifier available function.
 */
class AmpAvailFunctionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AmpAvailFunctionStatus ();

    /**
     * Copy constructor
     */
    inline  AmpAvailFunctionStatus (const AmpAvailFunctionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AmpAvailFunctionStatus (bool Bass_, bool Middle_, bool Treble_, bool Balance_, bool Fader_, bool AudioPilot_, bool Gala_, bool SurroundMode_, bool SubWoofer_, bool Staging_, bool RoomEffect_, bool Loudness_, bool AGC_, bool AmpDownMix_, bool SurroundVol_, bool RearSoundMode_, bool DriverSoundMode_, bool ANC_, bool ASC_, bool SoundAmbiance_, bool ESE_);

    /**
     * Destructor
     */
    inline virtual  ~AmpAvailFunctionStatus();

    /**
     * Assignment operator
     */
    inline AmpAvailFunctionStatus& operator = (const AmpAvailFunctionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AmpAvailFunctionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AmpAvailFunctionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AmpAvailFunctionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AmpAvailFunctionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Bass"

    static const int kBass = 0;

    /**
     * Clears the field "Bass".
     *
     * The field will be set to its default value. The hasBass()
     * method will return false.
     */
    inline void clearBass();

    /**
     * Checks whether the field "Bass" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBass()). Otherwise it will return false.
     */
    inline bool hasBass () const;

    /**
     * Returns the value of the member "Bass".
     *
     * TRUE:  Bass function is supported
     * FALSE: Bass function is not supported
     *
     * @return The value of the field "Bass"
     */
    inline bool getBass () const;

    /**
     * Sets the value of the member "Bass".
     *
     * TRUE:  Bass function is supported
     * FALSE: Bass function is not supported
     *
     * @param Bass The value which will be set
     */
    inline void setBass (bool Bass_);

    // API of field "Middle"

    static const int kMiddle = 1;

    /**
     * Clears the field "Middle".
     *
     * The field will be set to its default value. The hasMiddle()
     * method will return false.
     */
    inline void clearMiddle();

    /**
     * Checks whether the field "Middle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMiddle()). Otherwise it will return false.
     */
    inline bool hasMiddle () const;

    /**
     * Returns the value of the member "Middle".
     *
     * TRUE:  Middle function is supported
     * FALSE: Middle function is not supported
     *
     * @return The value of the field "Middle"
     */
    inline bool getMiddle () const;

    /**
     * Sets the value of the member "Middle".
     *
     * TRUE:  Middle function is supported
     * FALSE: Middle function is not supported
     *
     * @param Middle The value which will be set
     */
    inline void setMiddle (bool Middle_);

    // API of field "Treble"

    static const int kTreble = 2;

    /**
     * Clears the field "Treble".
     *
     * The field will be set to its default value. The hasTreble()
     * method will return false.
     */
    inline void clearTreble();

    /**
     * Checks whether the field "Treble" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTreble()). Otherwise it will return false.
     */
    inline bool hasTreble () const;

    /**
     * Returns the value of the member "Treble".
     *
     * TRUE:  Treble function is supported
     * FALSE: Treble function is not supported
     *
     * @return The value of the field "Treble"
     */
    inline bool getTreble () const;

    /**
     * Sets the value of the member "Treble".
     *
     * TRUE:  Treble function is supported
     * FALSE: Treble function is not supported
     *
     * @param Treble The value which will be set
     */
    inline void setTreble (bool Treble_);

    // API of field "Balance"

    static const int kBalance = 3;

    /**
     * Clears the field "Balance".
     *
     * The field will be set to its default value. The hasBalance()
     * method will return false.
     */
    inline void clearBalance();

    /**
     * Checks whether the field "Balance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBalance()). Otherwise it will return false.
     */
    inline bool hasBalance () const;

    /**
     * Returns the value of the member "Balance".
     *
     * TRUE:  Balance function is supported
     * FALSE: Balance function is not supported
     *
     * @return The value of the field "Balance"
     */
    inline bool getBalance () const;

    /**
     * Sets the value of the member "Balance".
     *
     * TRUE:  Balance function is supported
     * FALSE: Balance function is not supported
     *
     * @param Balance The value which will be set
     */
    inline void setBalance (bool Balance_);

    // API of field "Fader"

    static const int kFader = 4;

    /**
     * Clears the field "Fader".
     *
     * The field will be set to its default value. The hasFader()
     * method will return false.
     */
    inline void clearFader();

    /**
     * Checks whether the field "Fader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFader()). Otherwise it will return false.
     */
    inline bool hasFader () const;

    /**
     * Returns the value of the member "Fader".
     *
     * TRUE:  Fader function is supported
     * FALSE: Fader function is not supported
     *
     * @return The value of the field "Fader"
     */
    inline bool getFader () const;

    /**
     * Sets the value of the member "Fader".
     *
     * TRUE:  Fader function is supported
     * FALSE: Fader function is not supported
     *
     * @param Fader The value which will be set
     */
    inline void setFader (bool Fader_);

    // API of field "AudioPilot"

    static const int kAudioPilot = 5;

    /**
     * Clears the field "AudioPilot".
     *
     * The field will be set to its default value. The hasAudioPilot()
     * method will return false.
     */
    inline void clearAudioPilot();

    /**
     * Checks whether the field "AudioPilot" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioPilot()). Otherwise it will return false.
     */
    inline bool hasAudioPilot () const;

    /**
     * Returns the value of the member "AudioPilot".
     *
     * TRUE:  AudioPilot function is supported
     * FALSE: AudioPilot function is not supported
     *
     * @return The value of the field "AudioPilot"
     */
    inline bool getAudioPilot () const;

    /**
     * Sets the value of the member "AudioPilot".
     *
     * TRUE:  AudioPilot function is supported
     * FALSE: AudioPilot function is not supported
     *
     * @param AudioPilot The value which will be set
     */
    inline void setAudioPilot (bool AudioPilot_);

    // API of field "Gala"

    static const int kGala = 6;

    /**
     * Clears the field "Gala".
     *
     * The field will be set to its default value. The hasGala()
     * method will return false.
     */
    inline void clearGala();

    /**
     * Checks whether the field "Gala" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGala()). Otherwise it will return false.
     */
    inline bool hasGala () const;

    /**
     * Returns the value of the member "Gala".
     *
     * TRUE:  Gala function is supported
     * FALSE: Gala function is not supported
     *
     * @return The value of the field "Gala"
     */
    inline bool getGala () const;

    /**
     * Sets the value of the member "Gala".
     *
     * TRUE:  Gala function is supported
     * FALSE: Gala function is not supported
     *
     * @param Gala The value which will be set
     */
    inline void setGala (bool Gala_);

    // API of field "SurroundMode"

    static const int kSurroundMode = 7;

    /**
     * Clears the field "SurroundMode".
     *
     * The field will be set to its default value. The hasSurroundMode()
     * method will return false.
     */
    inline void clearSurroundMode();

    /**
     * Checks whether the field "SurroundMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurroundMode()). Otherwise it will return false.
     */
    inline bool hasSurroundMode () const;

    /**
     * Returns the value of the member "SurroundMode".
     *
     * TRUE:  Surround Mode function is supported
     * FALSE: Surround Mode function is not supported
     *
     * @return The value of the field "SurroundMode"
     */
    inline bool getSurroundMode () const;

    /**
     * Sets the value of the member "SurroundMode".
     *
     * TRUE:  Surround Mode function is supported
     * FALSE: Surround Mode function is not supported
     *
     * @param SurroundMode The value which will be set
     */
    inline void setSurroundMode (bool SurroundMode_);

    // API of field "SubWoofer"

    static const int kSubWoofer = 8;

    /**
     * Clears the field "SubWoofer".
     *
     * The field will be set to its default value. The hasSubWoofer()
     * method will return false.
     */
    inline void clearSubWoofer();

    /**
     * Checks whether the field "SubWoofer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubWoofer()). Otherwise it will return false.
     */
    inline bool hasSubWoofer () const;

    /**
     * Returns the value of the member "SubWoofer".
     *
     * TRUE:  SubWoofer function is supported
     * FALSE: SubWoofer function is not supported
     *
     * @return The value of the field "SubWoofer"
     */
    inline bool getSubWoofer () const;

    /**
     * Sets the value of the member "SubWoofer".
     *
     * TRUE:  SubWoofer function is supported
     * FALSE: SubWoofer function is not supported
     *
     * @param SubWoofer The value which will be set
     */
    inline void setSubWoofer (bool SubWoofer_);

    // API of field "Staging"

    static const int kStaging = 9;

    /**
     * Clears the field "Staging".
     *
     * The field will be set to its default value. The hasStaging()
     * method will return false.
     */
    inline void clearStaging();

    /**
     * Checks whether the field "Staging" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStaging()). Otherwise it will return false.
     */
    inline bool hasStaging () const;

    /**
     * Returns the value of the member "Staging".
     *
     * TRUE:  Staging function is supported
     * FALSE: Staging function is not supported
     *
     * @return The value of the field "Staging"
     */
    inline bool getStaging () const;

    /**
     * Sets the value of the member "Staging".
     *
     * TRUE:  Staging function is supported
     * FALSE: Staging function is not supported
     *
     * @param Staging The value which will be set
     */
    inline void setStaging (bool Staging_);

    // API of field "RoomEffect"

    static const int kRoomEffect = 10;

    /**
     * Clears the field "RoomEffect".
     *
     * The field will be set to its default value. The hasRoomEffect()
     * method will return false.
     */
    inline void clearRoomEffect();

    /**
     * Checks whether the field "RoomEffect" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRoomEffect()). Otherwise it will return false.
     */
    inline bool hasRoomEffect () const;

    /**
     * Returns the value of the member "RoomEffect".
     *
     * TRUE:  RoomEffect function is supported
     * FALSE: RoomEffect function is not supported
     *
     * @return The value of the field "RoomEffect"
     */
    inline bool getRoomEffect () const;

    /**
     * Sets the value of the member "RoomEffect".
     *
     * TRUE:  RoomEffect function is supported
     * FALSE: RoomEffect function is not supported
     *
     * @param RoomEffect The value which will be set
     */
    inline void setRoomEffect (bool RoomEffect_);

    // API of field "Loudness"

    static const int kLoudness = 11;

    /**
     * Clears the field "Loudness".
     *
     * The field will be set to its default value. The hasLoudness()
     * method will return false.
     */
    inline void clearLoudness();

    /**
     * Checks whether the field "Loudness" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLoudness()). Otherwise it will return false.
     */
    inline bool hasLoudness () const;

    /**
     * Returns the value of the member "Loudness".
     *
     * TRUE:  Loudness function is supported
     * FALSE: Loudness function is not supported
     *
     * @return The value of the field "Loudness"
     */
    inline bool getLoudness () const;

    /**
     * Sets the value of the member "Loudness".
     *
     * TRUE:  Loudness function is supported
     * FALSE: Loudness function is not supported
     *
     * @param Loudness The value which will be set
     */
    inline void setLoudness (bool Loudness_);

    // API of field "AGC"

    static const int kAGC = 12;

    /**
     * Clears the field "AGC".
     *
     * The field will be set to its default value. The hasAGC()
     * method will return false.
     */
    inline void clearAGC();

    /**
     * Checks whether the field "AGC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAGC()). Otherwise it will return false.
     */
    inline bool hasAGC () const;

    /**
     * Returns the value of the member "AGC".
     *
     * TRUE:  AGC function is supported
     * FALSE: AGC function is not supported
     *
     * @return The value of the field "AGC"
     */
    inline bool getAGC () const;

    /**
     * Sets the value of the member "AGC".
     *
     * TRUE:  AGC function is supported
     * FALSE: AGC function is not supported
     *
     * @param AGC The value which will be set
     */
    inline void setAGC (bool AGC_);

    // API of field "AmpDownMix"

    static const int kAmpDownMix = 13;

    /**
     * Clears the field "AmpDownMix".
     *
     * The field will be set to its default value. The hasAmpDownMix()
     * method will return false.
     */
    inline void clearAmpDownMix();

    /**
     * Checks whether the field "AmpDownMix" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAmpDownMix()). Otherwise it will return false.
     */
    inline bool hasAmpDownMix () const;

    /**
     * Returns the value of the member "AmpDownMix".
     *
     * TRUE:  DownMix function is supported
     * FALSE: DownMix function is not supported
     *
     * @return The value of the field "AmpDownMix"
     */
    inline bool getAmpDownMix () const;

    /**
     * Sets the value of the member "AmpDownMix".
     *
     * TRUE:  DownMix function is supported
     * FALSE: DownMix function is not supported
     *
     * @param AmpDownMix The value which will be set
     */
    inline void setAmpDownMix (bool AmpDownMix_);

    // API of field "SurroundVol"

    static const int kSurroundVol = 14;

    /**
     * Clears the field "SurroundVol".
     *
     * The field will be set to its default value. The hasSurroundVol()
     * method will return false.
     */
    inline void clearSurroundVol();

    /**
     * Checks whether the field "SurroundVol" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurroundVol()). Otherwise it will return false.
     */
    inline bool hasSurroundVol () const;

    /**
     * Returns the value of the member "SurroundVol".
     *
     * TRUE:  SurroundVol function is supported
     * FALSE: SurroundVol function is not supported
     *
     * @return The value of the field "SurroundVol"
     */
    inline bool getSurroundVol () const;

    /**
     * Sets the value of the member "SurroundVol".
     *
     * TRUE:  SurroundVol function is supported
     * FALSE: SurroundVol function is not supported
     *
     * @param SurroundVol The value which will be set
     */
    inline void setSurroundVol (bool SurroundVol_);

    // API of field "RearSoundMode"

    static const int kRearSoundMode = 15;

    /**
     * Clears the field "RearSoundMode".
     *
     * The field will be set to its default value. The hasRearSoundMode()
     * method will return false.
     */
    inline void clearRearSoundMode();

    /**
     * Checks whether the field "RearSoundMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRearSoundMode()). Otherwise it will return false.
     */
    inline bool hasRearSoundMode () const;

    /**
     * Returns the value of the member "RearSoundMode".
     *
     * TRUE:  Rear Sound Mode function is supported
     * FALSE: Rear Sound Mode function is not supported
     *
     * @return The value of the field "RearSoundMode"
     */
    inline bool getRearSoundMode () const;

    /**
     * Sets the value of the member "RearSoundMode".
     *
     * TRUE:  Rear Sound Mode function is supported
     * FALSE: Rear Sound Mode function is not supported
     *
     * @param RearSoundMode The value which will be set
     */
    inline void setRearSoundMode (bool RearSoundMode_);

    // API of field "DriverSoundMode"

    static const int kDriverSoundMode = 16;

    /**
     * Clears the field "DriverSoundMode".
     *
     * The field will be set to its default value. The hasDriverSoundMode()
     * method will return false.
     */
    inline void clearDriverSoundMode();

    /**
     * Checks whether the field "DriverSoundMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDriverSoundMode()). Otherwise it will return false.
     */
    inline bool hasDriverSoundMode () const;

    /**
     * Returns the value of the member "DriverSoundMode".
     *
     * TRUE:  Driver Sound Mode function is supported
     * FALSE: Driver Sound Mode function is not supported
     *
     * @return The value of the field "DriverSoundMode"
     */
    inline bool getDriverSoundMode () const;

    /**
     * Sets the value of the member "DriverSoundMode".
     *
     * TRUE:  Driver Sound Mode function is supported
     * FALSE: Driver Sound Mode function is not supported
     *
     * @param DriverSoundMode The value which will be set
     */
    inline void setDriverSoundMode (bool DriverSoundMode_);

    // API of field "ANC"

    static const int kANC = 17;

    /**
     * Clears the field "ANC".
     *
     * The field will be set to its default value. The hasANC()
     * method will return false.
     */
    inline void clearANC();

    /**
     * Checks whether the field "ANC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setANC()). Otherwise it will return false.
     */
    inline bool hasANC () const;

    /**
     * Returns the value of the member "ANC".
     *
     * TRUE:  ANC function is supported
     * FALSE: ANC function is not supported
     *
     * @return The value of the field "ANC"
     */
    inline bool getANC () const;

    /**
     * Sets the value of the member "ANC".
     *
     * TRUE:  ANC function is supported
     * FALSE: ANC function is not supported
     *
     * @param ANC The value which will be set
     */
    inline void setANC (bool ANC_);

    // API of field "ASC"

    static const int kASC = 18;

    /**
     * Clears the field "ASC".
     *
     * The field will be set to its default value. The hasASC()
     * method will return false.
     */
    inline void clearASC();

    /**
     * Checks whether the field "ASC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setASC()). Otherwise it will return false.
     */
    inline bool hasASC () const;

    /**
     * Returns the value of the member "ASC".
     *
     * TRUE:  ASC function is supported
     * FALSE: ASC function is not supported
     *
     * @return The value of the field "ASC"
     */
    inline bool getASC () const;

    /**
     * Sets the value of the member "ASC".
     *
     * TRUE:  ASC function is supported
     * FALSE: ASC function is not supported
     *
     * @param ASC The value which will be set
     */
    inline void setASC (bool ASC_);

    // API of field "SoundAmbiance"

    static const int kSoundAmbiance = 19;

    /**
     * Clears the field "SoundAmbiance".
     *
     * The field will be set to its default value. The hasSoundAmbiance()
     * method will return false.
     */
    inline void clearSoundAmbiance();

    /**
     * Checks whether the field "SoundAmbiance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundAmbiance()). Otherwise it will return false.
     */
    inline bool hasSoundAmbiance () const;

    /**
     * Returns the value of the member "SoundAmbiance".
     *
     * TRUE:  SoundAmbiance function is supported
     * FALSE: SoundAmbiance function is not supported
     *
     * @return The value of the field "SoundAmbiance"
     */
    inline bool getSoundAmbiance () const;

    /**
     * Sets the value of the member "SoundAmbiance".
     *
     * TRUE:  SoundAmbiance function is supported
     * FALSE: SoundAmbiance function is not supported
     *
     * @param SoundAmbiance The value which will be set
     */
    inline void setSoundAmbiance (bool SoundAmbiance_);

    // API of field "ESE"

    static const int kESE = 20;

    /**
     * Clears the field "ESE".
     *
     * The field will be set to its default value. The hasESE()
     * method will return false.
     */
    inline void clearESE();

    /**
     * Checks whether the field "ESE" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setESE()). Otherwise it will return false.
     */
    inline bool hasESE () const;

    /**
     * Returns the value of the member "ESE".
     *
     * TRUE:  ESE function is supported
     * FALSE: ESE function is not supported
     *
     * @return The value of the field "ESE"
     */
    inline bool getESE () const;

    /**
     * Sets the value of the member "ESE".
     *
     * TRUE:  ESE function is supported
     * FALSE: ESE function is not supported
     *
     * @param ESE The value which will be set
     */
    inline void setESE (bool ESE_);

    static const AmpAvailFunctionStatus &getDefaultInstance();

private:

    inline void set_has_Bass ();

    inline void clear_has_Bass ();

    inline void set_has_Middle ();

    inline void clear_has_Middle ();

    inline void set_has_Treble ();

    inline void clear_has_Treble ();

    inline void set_has_Balance ();

    inline void clear_has_Balance ();

    inline void set_has_Fader ();

    inline void clear_has_Fader ();

    inline void set_has_AudioPilot ();

    inline void clear_has_AudioPilot ();

    inline void set_has_Gala ();

    inline void clear_has_Gala ();

    inline void set_has_SurroundMode ();

    inline void clear_has_SurroundMode ();

    inline void set_has_SubWoofer ();

    inline void clear_has_SubWoofer ();

    inline void set_has_Staging ();

    inline void clear_has_Staging ();

    inline void set_has_RoomEffect ();

    inline void clear_has_RoomEffect ();

    inline void set_has_Loudness ();

    inline void clear_has_Loudness ();

    inline void set_has_AGC ();

    inline void clear_has_AGC ();

    inline void set_has_AmpDownMix ();

    inline void clear_has_AmpDownMix ();

    inline void set_has_SurroundVol ();

    inline void clear_has_SurroundVol ();

    inline void set_has_RearSoundMode ();

    inline void clear_has_RearSoundMode ();

    inline void set_has_DriverSoundMode ();

    inline void clear_has_DriverSoundMode ();

    inline void set_has_ANC ();

    inline void clear_has_ANC ();

    inline void set_has_ASC ();

    inline void clear_has_ASC ();

    inline void set_has_SoundAmbiance ();

    inline void clear_has_SoundAmbiance ();

    inline void set_has_ESE ();

    inline void clear_has_ESE ();

    uint32 _has_bits_[ (21 + 31) / 32];

    bool _Bass;

    bool _Middle;

    bool _Treble;

    bool _Balance;

    bool _Fader;

    bool _AudioPilot;

    bool _Gala;

    bool _SurroundMode;

    bool _SubWoofer;

    bool _Staging;

    bool _RoomEffect;

    bool _Loudness;

    bool _AGC;

    bool _AmpDownMix;

    bool _SurroundVol;

    bool _RearSoundMode;

    bool _DriverSoundMode;

    bool _ANC;

    bool _ASC;

    bool _SoundAmbiance;

    bool _ESE;

};

/**
 * The status message of the property "SetAudioProperty"
 * With this interface a source-component set the Audio Property(InputGain and Volume Lock) of an audio source.
 */
class SetAudioPropertyStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAudioPropertyStatus ();

    /**
     * Copy constructor
     */
    inline  SetAudioPropertyStatus (const SetAudioPropertyStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SetAudioPropertyStatus (::mascf_aud_src_route_fi_types::T_e8_AudSource u8Source_, ::mascf_aud_src_route_fi_types::T_e8_AudioProperty u8Property_, int32 s32PropValue_);

    /**
     * Destructor
     */
    inline virtual  ~SetAudioPropertyStatus();

    /**
     * Assignment operator
     */
    inline SetAudioPropertyStatus& operator = (const SetAudioPropertyStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAudioPropertyStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAudioPropertyStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAudioPropertyStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAudioPropertyStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Source"

    static const int kU8Source = 0;

    /**
     * Clears the field "u8Source".
     *
     * The field will be set to its default value. The hasU8Source()
     * method will return false.
     */
    inline void clearU8Source();

    /**
     * Checks whether the field "u8Source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Source()). Otherwise it will return false.
     */
    inline bool hasU8Source () const;

    /**
     * Returns the value of the member "u8Source".
     *
     * The u8Source gives the source ID.
     *
     * @return The value of the field "u8Source"
     */
    inline ::mascf_aud_src_route_fi_types::T_e8_AudSource getU8Source () const;

    /**
     * Sets the value of the member "u8Source".
     *
     * The u8Source gives the source ID.
     *
     * @param u8Source The value which will be set
     */
    inline void setU8Source (::mascf_aud_src_route_fi_types::T_e8_AudSource u8Source_);

    // API of field "u8Property"

    static const int kU8Property = 1;

    /**
     * Clears the field "u8Property".
     *
     * The field will be set to its default value. The hasU8Property()
     * method will return false.
     */
    inline void clearU8Property();

    /**
     * Checks whether the field "u8Property" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Property()). Otherwise it will return false.
     */
    inline bool hasU8Property () const;

    /**
     * Returns the value of the member "u8Property".
     *
     * The u8Property gives the AudioProperty to be set by the Source.
     *
     * @return The value of the field "u8Property"
     */
    inline ::mascf_aud_src_route_fi_types::T_e8_AudioProperty getU8Property () const;

    /**
     * Sets the value of the member "u8Property".
     *
     * The u8Property gives the AudioProperty to be set by the Source.
     *
     * @param u8Property The value which will be set
     */
    inline void setU8Property (::mascf_aud_src_route_fi_types::T_e8_AudioProperty u8Property_);

    // API of field "s32PropValue"

    static const int kS32PropValue = 2;

    /**
     * Clears the field "s32PropValue".
     *
     * The field will be set to its default value. The hasS32PropValue()
     * method will return false.
     */
    inline void clearS32PropValue();

    /**
     * Checks whether the field "s32PropValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32PropValue()). Otherwise it will return false.
     */
    inline bool hasS32PropValue () const;

    /**
     * Returns the value of the member "s32PropValue".
     *
     * The s32PropValue gives the Value of the Audio Property to be Set.
     *
     * @return The value of the field "s32PropValue"
     */
    inline int32 getS32PropValue () const;

    /**
     * Sets the value of the member "s32PropValue".
     *
     * The s32PropValue gives the Value of the Audio Property to be Set.
     *
     * @param s32PropValue The value which will be set
     */
    inline void setS32PropValue (int32 s32PropValue_);

    static const SetAudioPropertyStatus &getDefaultInstance();

private:

    inline void set_has_u8Source ();

    inline void clear_has_u8Source ();

    inline void set_has_u8Property ();

    inline void clear_has_u8Property ();

    inline void set_has_s32PropValue ();

    inline void clear_has_s32PropValue ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::mascf_aud_src_route_fi_types::T_e8_AudSource _u8Source;

    ::mascf_aud_src_route_fi_types::T_e8_AudioProperty _u8Property;

    int32 _s32PropValue;

};

/**
 * The set message of the property "SetAudioProperty"
 * With this interface a source-component set the Audio Property(InputGain and Volume Lock) of an audio source.
 */
class SetAudioPropertySet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetAudioPropertySet ();

    /**
     * Copy constructor
     */
    inline  SetAudioPropertySet (const SetAudioPropertySet &rhs);

    /**
     * All fields constructor
     */
    inline  SetAudioPropertySet (::mascf_aud_src_route_fi_types::T_e8_AudSource u8Source_, ::mascf_aud_src_route_fi_types::T_e8_AudioProperty u8Property_, int32 s32PropValue_);

    /**
     * Destructor
     */
    inline virtual  ~SetAudioPropertySet();

    /**
     * Assignment operator
     */
    inline SetAudioPropertySet& operator = (const SetAudioPropertySet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetAudioPropertySet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetAudioPropertySet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetAudioPropertySet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetAudioPropertySet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Source"

    static const int kU8Source = 0;

    /**
     * Clears the field "u8Source".
     *
     * The field will be set to its default value. The hasU8Source()
     * method will return false.
     */
    inline void clearU8Source();

    /**
     * Checks whether the field "u8Source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Source()). Otherwise it will return false.
     */
    inline bool hasU8Source () const;

    /**
     * Returns the value of the member "u8Source".
     *
     * The u8Source gives the source ID.
     *
     * @return The value of the field "u8Source"
     */
    inline ::mascf_aud_src_route_fi_types::T_e8_AudSource getU8Source () const;

    /**
     * Sets the value of the member "u8Source".
     *
     * The u8Source gives the source ID.
     *
     * @param u8Source The value which will be set
     */
    inline void setU8Source (::mascf_aud_src_route_fi_types::T_e8_AudSource u8Source_);

    // API of field "u8Property"

    static const int kU8Property = 1;

    /**
     * Clears the field "u8Property".
     *
     * The field will be set to its default value. The hasU8Property()
     * method will return false.
     */
    inline void clearU8Property();

    /**
     * Checks whether the field "u8Property" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Property()). Otherwise it will return false.
     */
    inline bool hasU8Property () const;

    /**
     * Returns the value of the member "u8Property".
     *
     * The u8Property gives the AudioProperty to be set by the Source.
     *
     * @return The value of the field "u8Property"
     */
    inline ::mascf_aud_src_route_fi_types::T_e8_AudioProperty getU8Property () const;

    /**
     * Sets the value of the member "u8Property".
     *
     * The u8Property gives the AudioProperty to be set by the Source.
     *
     * @param u8Property The value which will be set
     */
    inline void setU8Property (::mascf_aud_src_route_fi_types::T_e8_AudioProperty u8Property_);

    // API of field "s32PropValue"

    static const int kS32PropValue = 2;

    /**
     * Clears the field "s32PropValue".
     *
     * The field will be set to its default value. The hasS32PropValue()
     * method will return false.
     */
    inline void clearS32PropValue();

    /**
     * Checks whether the field "s32PropValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32PropValue()). Otherwise it will return false.
     */
    inline bool hasS32PropValue () const;

    /**
     * Returns the value of the member "s32PropValue".
     *
     * The s32PropValue gives the Value of the Audio Property to be Set.
     *
     * @return The value of the field "s32PropValue"
     */
    inline int32 getS32PropValue () const;

    /**
     * Sets the value of the member "s32PropValue".
     *
     * The s32PropValue gives the Value of the Audio Property to be Set.
     *
     * @param s32PropValue The value which will be set
     */
    inline void setS32PropValue (int32 s32PropValue_);

    static const SetAudioPropertySet &getDefaultInstance();

private:

    inline void set_has_u8Source ();

    inline void clear_has_u8Source ();

    inline void set_has_u8Property ();

    inline void clear_has_u8Property ();

    inline void set_has_s32PropValue ();

    inline void clear_has_s32PropValue ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::mascf_aud_src_route_fi_types::T_e8_AudSource _u8Source;

    ::mascf_aud_src_route_fi_types::T_e8_AudioProperty _u8Property;

    int32 _s32PropValue;

};

/**
 * The status message of the property "EntOnVolumeSetup"
 * Property for setting the on volume to entertainment source
 */
class EntOnVolumeSetupStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EntOnVolumeSetupStatus ();

    /**
     * Copy constructor
     */
    inline  EntOnVolumeSetupStatus (const EntOnVolumeSetupStatus &rhs);

    /**
     * All fields constructor
     */
    inline  EntOnVolumeSetupStatus (uint8 LimitValue_);

    /**
     * Destructor
     */
    inline virtual  ~EntOnVolumeSetupStatus();

    /**
     * Assignment operator
     */
    inline EntOnVolumeSetupStatus& operator = (const EntOnVolumeSetupStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EntOnVolumeSetupStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EntOnVolumeSetupStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EntOnVolumeSetupStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EntOnVolumeSetupStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LimitValue"

    static const int kLimitValue = 0;

    /**
     * Clears the field "LimitValue".
     *
     * The field will be set to its default value. The hasLimitValue()
     * method will return false.
     */
    inline void clearLimitValue();

    /**
     * Checks whether the field "LimitValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLimitValue()). Otherwise it will return false.
     */
    inline bool hasLimitValue () const;

    /**
     * Returns the value of the member "LimitValue".
     *
     * Status of On Volume limit for Entertainment source
     *
     * @return The value of the field "LimitValue"
     */
    inline uint8 getLimitValue () const;

    /**
     * Sets the value of the member "LimitValue".
     *
     * Status of On Volume limit for Entertainment source
     *
     * @param LimitValue The value which will be set
     */
    inline void setLimitValue (uint8 LimitValue_);

    static const EntOnVolumeSetupStatus &getDefaultInstance();

private:

    inline void set_has_LimitValue ();

    inline void clear_has_LimitValue ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _LimitValue;

};

/**
 * The set message of the property "EntOnVolumeSetup"
 * Property for setting the on volume to entertainment source
 */
class EntOnVolumeSetupSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EntOnVolumeSetupSet ();

    /**
     * Copy constructor
     */
    inline  EntOnVolumeSetupSet (const EntOnVolumeSetupSet &rhs);

    /**
     * All fields constructor
     */
    inline  EntOnVolumeSetupSet (uint8 LimitValue_, ::masc_main_fi_types::T_e8_AudioSoundType SoundType_);

    /**
     * Destructor
     */
    inline virtual  ~EntOnVolumeSetupSet();

    /**
     * Assignment operator
     */
    inline EntOnVolumeSetupSet& operator = (const EntOnVolumeSetupSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EntOnVolumeSetupSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EntOnVolumeSetupSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EntOnVolumeSetupSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EntOnVolumeSetupSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LimitValue"

    static const int kLimitValue = 0;

    /**
     * Clears the field "LimitValue".
     *
     * The field will be set to its default value. The hasLimitValue()
     * method will return false.
     */
    inline void clearLimitValue();

    /**
     * Checks whether the field "LimitValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLimitValue()). Otherwise it will return false.
     */
    inline bool hasLimitValue () const;

    /**
     * Returns the value of the member "LimitValue".
     *
     * To set On Volume limit for Entertainment source
     *
     * @return The value of the field "LimitValue"
     */
    inline uint8 getLimitValue () const;

    /**
     * Sets the value of the member "LimitValue".
     *
     * To set On Volume limit for Entertainment source
     *
     * @param LimitValue The value which will be set
     */
    inline void setLimitValue (uint8 LimitValue_);

    // API of field "SoundType"

    static const int kSoundType = 1;

    /**
     * Clears the field "SoundType".
     *
     * The field will be set to its default value. The hasSoundType()
     * method will return false.
     */
    inline void clearSoundType();

    /**
     * Checks whether the field "SoundType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundType()). Otherwise it will return false.
     */
    inline bool hasSoundType () const;

    /**
     * Returns the value of the member "SoundType".
     *
     * Type of sound, it can be absolute or relative
     *
     * @return The value of the field "SoundType"
     */
    inline ::masc_main_fi_types::T_e8_AudioSoundType getSoundType () const;

    /**
     * Sets the value of the member "SoundType".
     *
     * Type of sound, it can be absolute or relative
     *
     * @param SoundType The value which will be set
     */
    inline void setSoundType (::masc_main_fi_types::T_e8_AudioSoundType SoundType_);

    static const EntOnVolumeSetupSet &getDefaultInstance();

private:

    inline void set_has_LimitValue ();

    inline void clear_has_LimitValue ();

    inline void set_has_SoundType ();

    inline void clear_has_SoundType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _LimitValue;

    ::masc_main_fi_types::T_e8_AudioSoundType _SoundType;

};

/**
 * The status message of the property "RoomEffect"
 * status of changed Sound Room Effect.
 */
class RoomEffectStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RoomEffectStatus ();

    /**
     * Copy constructor
     */
    inline  RoomEffectStatus (const RoomEffectStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RoomEffectStatus (::masc_main_fi_types::T_e8_RoomEffect RoomEffect_, ::masc_main_fi_types::T_e8_ResourceNo Resource_);

    /**
     * Destructor
     */
    inline virtual  ~RoomEffectStatus();

    /**
     * Assignment operator
     */
    inline RoomEffectStatus& operator = (const RoomEffectStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RoomEffectStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RoomEffectStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RoomEffectStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RoomEffectStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RoomEffect"

    static const int kRoomEffect = 0;

    /**
     * Clears the field "RoomEffect".
     *
     * The field will be set to its default value. The hasRoomEffect()
     * method will return false.
     */
    inline void clearRoomEffect();

    /**
     * Checks whether the field "RoomEffect" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRoomEffect()). Otherwise it will return false.
     */
    inline bool hasRoomEffect () const;

    /**
     * Returns the value of the member "RoomEffect".
     *
     * Sound Room Effect Value
     *
     * @return The value of the field "RoomEffect"
     */
    inline ::masc_main_fi_types::T_e8_RoomEffect getRoomEffect () const;

    /**
     * Sets the value of the member "RoomEffect".
     *
     * Sound Room Effect Value
     *
     * @param RoomEffect The value which will be set
     */
    inline void setRoomEffect (::masc_main_fi_types::T_e8_RoomEffect RoomEffect_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    static const RoomEffectStatus &getDefaultInstance();

private:

    inline void set_has_RoomEffect ();

    inline void clear_has_RoomEffect ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::masc_main_fi_types::T_e8_RoomEffect _RoomEffect;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

};

/**
 * The set message of the property "RoomEffect"
 * status of changed Sound Room Effect.
 */
class RoomEffectSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RoomEffectSet ();

    /**
     * Copy constructor
     */
    inline  RoomEffectSet (const RoomEffectSet &rhs);

    /**
     * All fields constructor
     */
    inline  RoomEffectSet (::masc_main_fi_types::T_e8_RoomEffect RoomEffect_, ::masc_main_fi_types::T_e8_ResourceNo Resource_);

    /**
     * Destructor
     */
    inline virtual  ~RoomEffectSet();

    /**
     * Assignment operator
     */
    inline RoomEffectSet& operator = (const RoomEffectSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RoomEffectSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RoomEffectSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RoomEffectSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RoomEffectSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RoomEffect"

    static const int kRoomEffect = 0;

    /**
     * Clears the field "RoomEffect".
     *
     * The field will be set to its default value. The hasRoomEffect()
     * method will return false.
     */
    inline void clearRoomEffect();

    /**
     * Checks whether the field "RoomEffect" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRoomEffect()). Otherwise it will return false.
     */
    inline bool hasRoomEffect () const;

    /**
     * Returns the value of the member "RoomEffect".
     *
     * Sound Room Effect Value
     *
     * @return The value of the field "RoomEffect"
     */
    inline ::masc_main_fi_types::T_e8_RoomEffect getRoomEffect () const;

    /**
     * Sets the value of the member "RoomEffect".
     *
     * Sound Room Effect Value
     *
     * @param RoomEffect The value which will be set
     */
    inline void setRoomEffect (::masc_main_fi_types::T_e8_RoomEffect RoomEffect_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    static const RoomEffectSet &getDefaultInstance();

private:

    inline void set_has_RoomEffect ();

    inline void clear_has_RoomEffect ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::masc_main_fi_types::T_e8_RoomEffect _RoomEffect;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

};

/**
 * The status message of the property "FMEnhancerMode"
 * status of FM Enhancer mode.
 */
class FMEnhancerModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FMEnhancerModeStatus ();

    /**
     * Copy constructor
     */
    inline  FMEnhancerModeStatus (const FMEnhancerModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FMEnhancerModeStatus (bool FMEnhancer_);

    /**
     * Destructor
     */
    inline virtual  ~FMEnhancerModeStatus();

    /**
     * Assignment operator
     */
    inline FMEnhancerModeStatus& operator = (const FMEnhancerModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FMEnhancerModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FMEnhancerModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FMEnhancerModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FMEnhancerModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FMEnhancer"

    static const int kFMEnhancer = 0;

    /**
     * Clears the field "FMEnhancer".
     *
     * The field will be set to its default value. The hasFMEnhancer()
     * method will return false.
     */
    inline void clearFMEnhancer();

    /**
     * Checks whether the field "FMEnhancer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFMEnhancer()). Otherwise it will return false.
     */
    inline bool hasFMEnhancer () const;

    /**
     * Returns the value of the member "FMEnhancer".
     *
     * TRUE:  FM Enhancer mode is enabled
     * FALSE: FM Enhancer mode is disabled
     *
     * @return The value of the field "FMEnhancer"
     */
    inline bool getFMEnhancer () const;

    /**
     * Sets the value of the member "FMEnhancer".
     *
     * TRUE:  FM Enhancer mode is enabled
     * FALSE: FM Enhancer mode is disabled
     *
     * @param FMEnhancer The value which will be set
     */
    inline void setFMEnhancer (bool FMEnhancer_);

    static const FMEnhancerModeStatus &getDefaultInstance();

private:

    inline void set_has_FMEnhancer ();

    inline void clear_has_FMEnhancer ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _FMEnhancer;

};

/**
 * The set message of the property "FMEnhancerMode"
 * status of FM Enhancer mode.
 */
class FMEnhancerModeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FMEnhancerModeSet ();

    /**
     * Copy constructor
     */
    inline  FMEnhancerModeSet (const FMEnhancerModeSet &rhs);

    /**
     * All fields constructor
     */
    inline  FMEnhancerModeSet (bool FMEnhancer_);

    /**
     * Destructor
     */
    inline virtual  ~FMEnhancerModeSet();

    /**
     * Assignment operator
     */
    inline FMEnhancerModeSet& operator = (const FMEnhancerModeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FMEnhancerModeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FMEnhancerModeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FMEnhancerModeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FMEnhancerModeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FMEnhancer"

    static const int kFMEnhancer = 0;

    /**
     * Clears the field "FMEnhancer".
     *
     * The field will be set to its default value. The hasFMEnhancer()
     * method will return false.
     */
    inline void clearFMEnhancer();

    /**
     * Checks whether the field "FMEnhancer" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFMEnhancer()). Otherwise it will return false.
     */
    inline bool hasFMEnhancer () const;

    /**
     * Returns the value of the member "FMEnhancer".
     *
     * TRUE:  FM Enhancer mode is enabled
     * FALSE: FM Enhancer mode is disabled
     *
     * @return The value of the field "FMEnhancer"
     */
    inline bool getFMEnhancer () const;

    /**
     * Sets the value of the member "FMEnhancer".
     *
     * TRUE:  FM Enhancer mode is enabled
     * FALSE: FM Enhancer mode is disabled
     *
     * @param FMEnhancer The value which will be set
     */
    inline void setFMEnhancer (bool FMEnhancer_);

    static const FMEnhancerModeSet &getDefaultInstance();

private:

    inline void set_has_FMEnhancer ();

    inline void clear_has_FMEnhancer ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _FMEnhancer;

};

/**
 * The status message of the property "DiagDefSetPhase"
 * status of Diagnosis DefSet Phase.
 */
class DiagDefSetPhaseStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DiagDefSetPhaseStatus ();

    /**
     * Copy constructor
     */
    inline  DiagDefSetPhaseStatus (const DiagDefSetPhaseStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DiagDefSetPhaseStatus (::masc_main_fi_types::T_e8_AudDiagDefSetPhase DefSetPhase_);

    /**
     * Destructor
     */
    inline virtual  ~DiagDefSetPhaseStatus();

    /**
     * Assignment operator
     */
    inline DiagDefSetPhaseStatus& operator = (const DiagDefSetPhaseStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DiagDefSetPhaseStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DiagDefSetPhaseStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DiagDefSetPhaseStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DiagDefSetPhaseStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefSetPhase"

    static const int kDefSetPhase = 0;

    /**
     * Clears the field "DefSetPhase".
     *
     * The field will be set to its default value. The hasDefSetPhase()
     * method will return false.
     */
    inline void clearDefSetPhase();

    /**
     * Checks whether the field "DefSetPhase" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetPhase()). Otherwise it will return false.
     */
    inline bool hasDefSetPhase () const;

    /**
     * Returns the value of the member "DefSetPhase".
     *
     * DefSet Phase value status
     *
     * @return The value of the field "DefSetPhase"
     */
    inline ::masc_main_fi_types::T_e8_AudDiagDefSetPhase getDefSetPhase () const;

    /**
     * Sets the value of the member "DefSetPhase".
     *
     * DefSet Phase value status
     *
     * @param DefSetPhase The value which will be set
     */
    inline void setDefSetPhase (::masc_main_fi_types::T_e8_AudDiagDefSetPhase DefSetPhase_);

    static const DiagDefSetPhaseStatus &getDefaultInstance();

private:

    inline void set_has_DefSetPhase ();

    inline void clear_has_DefSetPhase ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudDiagDefSetPhase _DefSetPhase;

};

/**
 * The status message of the property "ESESoundType"
 * Property for setting the ESE Sound type value.
 */
class ESESoundTypeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ESESoundTypeStatus ();

    /**
     * Copy constructor
     */
    inline  ESESoundTypeStatus (const ESESoundTypeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ESESoundTypeStatus (uint8 SoundType_);

    /**
     * Destructor
     */
    inline virtual  ~ESESoundTypeStatus();

    /**
     * Assignment operator
     */
    inline ESESoundTypeStatus& operator = (const ESESoundTypeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ESESoundTypeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ESESoundTypeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ESESoundTypeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ESESoundTypeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SoundType"

    static const int kSoundType = 0;

    /**
     * Clears the field "SoundType".
     *
     * The field will be set to its default value. The hasSoundType()
     * method will return false.
     */
    inline void clearSoundType();

    /**
     * Checks whether the field "SoundType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundType()). Otherwise it will return false.
     */
    inline bool hasSoundType () const;

    /**
     * Returns the value of the member "SoundType".
     *
     * Value of ESE Sound Type
     *
     * @return The value of the field "SoundType"
     */
    inline uint8 getSoundType () const;

    /**
     * Sets the value of the member "SoundType".
     *
     * Value of ESE Sound Type
     *
     * @param SoundType The value which will be set
     */
    inline void setSoundType (uint8 SoundType_);

    static const ESESoundTypeStatus &getDefaultInstance();

private:

    inline void set_has_SoundType ();

    inline void clear_has_SoundType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _SoundType;

};

/**
 * The set message of the property "ESESoundType"
 * Property for setting the ESE Sound type value.
 */
class ESESoundTypeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ESESoundTypeSet ();

    /**
     * Copy constructor
     */
    inline  ESESoundTypeSet (const ESESoundTypeSet &rhs);

    /**
     * All fields constructor
     */
    inline  ESESoundTypeSet (uint8 SoundType_);

    /**
     * Destructor
     */
    inline virtual  ~ESESoundTypeSet();

    /**
     * Assignment operator
     */
    inline ESESoundTypeSet& operator = (const ESESoundTypeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ESESoundTypeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ESESoundTypeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ESESoundTypeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ESESoundTypeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SoundType"

    static const int kSoundType = 0;

    /**
     * Clears the field "SoundType".
     *
     * The field will be set to its default value. The hasSoundType()
     * method will return false.
     */
    inline void clearSoundType();

    /**
     * Checks whether the field "SoundType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundType()). Otherwise it will return false.
     */
    inline bool hasSoundType () const;

    /**
     * Returns the value of the member "SoundType".
     *
     * Value of ESE sound type
     *
     * @return The value of the field "SoundType"
     */
    inline uint8 getSoundType () const;

    /**
     * Sets the value of the member "SoundType".
     *
     * Value of ESE sound type
     *
     * @param SoundType The value which will be set
     */
    inline void setSoundType (uint8 SoundType_);

    static const ESESoundTypeSet &getDefaultInstance();

private:

    inline void set_has_SoundType ();

    inline void clear_has_SoundType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _SoundType;

};

/**
 * The status message of the property "ESEVolume"
 * Property for setting the ESE volume value.
 */
class ESEVolumeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ESEVolumeStatus ();

    /**
     * Copy constructor
     */
    inline  ESEVolumeStatus (const ESEVolumeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ESEVolumeStatus (uint8 Volume_);

    /**
     * Destructor
     */
    inline virtual  ~ESEVolumeStatus();

    /**
     * Assignment operator
     */
    inline ESEVolumeStatus& operator = (const ESEVolumeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ESEVolumeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ESEVolumeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ESEVolumeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ESEVolumeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Volume"

    static const int kVolume = 0;

    /**
     * Clears the field "Volume".
     *
     * The field will be set to its default value. The hasVolume()
     * method will return false.
     */
    inline void clearVolume();

    /**
     * Checks whether the field "Volume" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolume()). Otherwise it will return false.
     */
    inline bool hasVolume () const;

    /**
     * Returns the value of the member "Volume".
     *
     * Value of ESE volume
     *
     * @return The value of the field "Volume"
     */
    inline uint8 getVolume () const;

    /**
     * Sets the value of the member "Volume".
     *
     * Value of ESE volume
     *
     * @param Volume The value which will be set
     */
    inline void setVolume (uint8 Volume_);

    static const ESEVolumeStatus &getDefaultInstance();

private:

    inline void set_has_Volume ();

    inline void clear_has_Volume ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Volume;

};

/**
 * The set message of the property "ESEVolume"
 * Property for setting the ESE volume value.
 */
class ESEVolumeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ESEVolumeSet ();

    /**
     * Copy constructor
     */
    inline  ESEVolumeSet (const ESEVolumeSet &rhs);

    /**
     * All fields constructor
     */
    inline  ESEVolumeSet (uint8 Volume_);

    /**
     * Destructor
     */
    inline virtual  ~ESEVolumeSet();

    /**
     * Assignment operator
     */
    inline ESEVolumeSet& operator = (const ESEVolumeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ESEVolumeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ESEVolumeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ESEVolumeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ESEVolumeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Volume"

    static const int kVolume = 0;

    /**
     * Clears the field "Volume".
     *
     * The field will be set to its default value. The hasVolume()
     * method will return false.
     */
    inline void clearVolume();

    /**
     * Checks whether the field "Volume" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolume()). Otherwise it will return false.
     */
    inline bool hasVolume () const;

    /**
     * Returns the value of the member "Volume".
     *
     * Value of ESE volume
     *
     * @return The value of the field "Volume"
     */
    inline uint8 getVolume () const;

    /**
     * Sets the value of the member "Volume".
     *
     * Value of ESE volume
     *
     * @param Volume The value which will be set
     */
    inline void setVolume (uint8 Volume_);

    static const ESEVolumeSet &getDefaultInstance();

private:

    inline void set_has_Volume ();

    inline void clear_has_Volume ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Volume;

};

/**
 * The status message of the property "RSoundOnOff"
 * Property for setting the RSound Activation value.
 */
class RSoundOnOffStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RSoundOnOffStatus ();

    /**
     * Copy constructor
     */
    inline  RSoundOnOffStatus (const RSoundOnOffStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RSoundOnOffStatus (bool RSound_);

    /**
     * Destructor
     */
    inline virtual  ~RSoundOnOffStatus();

    /**
     * Assignment operator
     */
    inline RSoundOnOffStatus& operator = (const RSoundOnOffStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RSoundOnOffStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RSoundOnOffStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RSoundOnOffStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RSoundOnOffStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RSound"

    static const int kRSound = 0;

    /**
     * Clears the field "RSound".
     *
     * The field will be set to its default value. The hasRSound()
     * method will return false.
     */
    inline void clearRSound();

    /**
     * Checks whether the field "RSound" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRSound()). Otherwise it will return false.
     */
    inline bool hasRSound () const;

    /**
     * Returns the value of the member "RSound".
     *
     * Value of RSoundActivation
     *
     * @return The value of the field "RSound"
     */
    inline bool getRSound () const;

    /**
     * Sets the value of the member "RSound".
     *
     * Value of RSoundActivation
     *
     * @param RSound The value which will be set
     */
    inline void setRSound (bool RSound_);

    static const RSoundOnOffStatus &getDefaultInstance();

private:

    inline void set_has_RSound ();

    inline void clear_has_RSound ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _RSound;

};

/**
 * The set message of the property "RSoundOnOff"
 * Property for setting the RSound Activation value.
 */
class RSoundOnOffSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RSoundOnOffSet ();

    /**
     * Copy constructor
     */
    inline  RSoundOnOffSet (const RSoundOnOffSet &rhs);

    /**
     * All fields constructor
     */
    inline  RSoundOnOffSet (bool RSound_);

    /**
     * Destructor
     */
    inline virtual  ~RSoundOnOffSet();

    /**
     * Assignment operator
     */
    inline RSoundOnOffSet& operator = (const RSoundOnOffSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RSoundOnOffSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RSoundOnOffSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RSoundOnOffSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RSoundOnOffSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RSound"

    static const int kRSound = 0;

    /**
     * Clears the field "RSound".
     *
     * The field will be set to its default value. The hasRSound()
     * method will return false.
     */
    inline void clearRSound();

    /**
     * Checks whether the field "RSound" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRSound()). Otherwise it will return false.
     */
    inline bool hasRSound () const;

    /**
     * Returns the value of the member "RSound".
     *
     * Value of RSoundActivation
     *
     * @return The value of the field "RSound"
     */
    inline bool getRSound () const;

    /**
     * Sets the value of the member "RSound".
     *
     * Value of RSoundActivation
     *
     * @param RSound The value which will be set
     */
    inline void setRSound (bool RSound_);

    static const RSoundOnOffSet &getDefaultInstance();

private:

    inline void set_has_RSound ();

    inline void clear_has_RSound ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _RSound;

};

/**
 * The status message of the property "RSoundSoundType"
 * Property for setting the RSound Sound type value.
 */
class RSoundSoundTypeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RSoundSoundTypeStatus ();

    /**
     * Copy constructor
     */
    inline  RSoundSoundTypeStatus (const RSoundSoundTypeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RSoundSoundTypeStatus (uint8 RSoundType_);

    /**
     * Destructor
     */
    inline virtual  ~RSoundSoundTypeStatus();

    /**
     * Assignment operator
     */
    inline RSoundSoundTypeStatus& operator = (const RSoundSoundTypeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RSoundSoundTypeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RSoundSoundTypeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RSoundSoundTypeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RSoundSoundTypeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RSoundType"

    static const int kRSoundType = 0;

    /**
     * Clears the field "RSoundType".
     *
     * The field will be set to its default value. The hasRSoundType()
     * method will return false.
     */
    inline void clearRSoundType();

    /**
     * Checks whether the field "RSoundType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRSoundType()). Otherwise it will return false.
     */
    inline bool hasRSoundType () const;

    /**
     * Returns the value of the member "RSoundType".
     *
     * Value of RSound Sound Type (range of 1 to 6)
     *
     * @return The value of the field "RSoundType"
     */
    inline uint8 getRSoundType () const;

    /**
     * Sets the value of the member "RSoundType".
     *
     * Value of RSound Sound Type (range of 1 to 6)
     *
     * @param RSoundType The value which will be set
     */
    inline void setRSoundType (uint8 RSoundType_);

    static const RSoundSoundTypeStatus &getDefaultInstance();

private:

    inline void set_has_RSoundType ();

    inline void clear_has_RSoundType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _RSoundType;

};

/**
 * The set message of the property "RSoundSoundType"
 * Property for setting the RSound Sound type value.
 */
class RSoundSoundTypeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RSoundSoundTypeSet ();

    /**
     * Copy constructor
     */
    inline  RSoundSoundTypeSet (const RSoundSoundTypeSet &rhs);

    /**
     * All fields constructor
     */
    inline  RSoundSoundTypeSet (uint8 RSoundType_);

    /**
     * Destructor
     */
    inline virtual  ~RSoundSoundTypeSet();

    /**
     * Assignment operator
     */
    inline RSoundSoundTypeSet& operator = (const RSoundSoundTypeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RSoundSoundTypeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RSoundSoundTypeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RSoundSoundTypeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RSoundSoundTypeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RSoundType"

    static const int kRSoundType = 0;

    /**
     * Clears the field "RSoundType".
     *
     * The field will be set to its default value. The hasRSoundType()
     * method will return false.
     */
    inline void clearRSoundType();

    /**
     * Checks whether the field "RSoundType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRSoundType()). Otherwise it will return false.
     */
    inline bool hasRSoundType () const;

    /**
     * Returns the value of the member "RSoundType".
     *
     * Value of RSound sound type (range of 1 to 6)
     *
     * @return The value of the field "RSoundType"
     */
    inline uint8 getRSoundType () const;

    /**
     * Sets the value of the member "RSoundType".
     *
     * Value of RSound sound type (range of 1 to 6)
     *
     * @param RSoundType The value which will be set
     */
    inline void setRSoundType (uint8 RSoundType_);

    static const RSoundSoundTypeSet &getDefaultInstance();

private:

    inline void set_has_RSoundType ();

    inline void clear_has_RSoundType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _RSoundType;

};

/**
 * The status message of the property "RSoundVolume"
 * Property for setting the RSound volume value.
 */
class RSoundVolumeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RSoundVolumeStatus ();

    /**
     * Copy constructor
     */
    inline  RSoundVolumeStatus (const RSoundVolumeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RSoundVolumeStatus (uint8 Volume_);

    /**
     * Destructor
     */
    inline virtual  ~RSoundVolumeStatus();

    /**
     * Assignment operator
     */
    inline RSoundVolumeStatus& operator = (const RSoundVolumeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RSoundVolumeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RSoundVolumeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RSoundVolumeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RSoundVolumeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Volume"

    static const int kVolume = 0;

    /**
     * Clears the field "Volume".
     *
     * The field will be set to its default value. The hasVolume()
     * method will return false.
     */
    inline void clearVolume();

    /**
     * Checks whether the field "Volume" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolume()). Otherwise it will return false.
     */
    inline bool hasVolume () const;

    /**
     * Returns the value of the member "Volume".
     *
     * Value of RSound volume
     *
     * @return The value of the field "Volume"
     */
    inline uint8 getVolume () const;

    /**
     * Sets the value of the member "Volume".
     *
     * Value of RSound volume
     *
     * @param Volume The value which will be set
     */
    inline void setVolume (uint8 Volume_);

    static const RSoundVolumeStatus &getDefaultInstance();

private:

    inline void set_has_Volume ();

    inline void clear_has_Volume ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Volume;

};

/**
 * The set message of the property "RSoundVolume"
 * Property for setting the RSound volume value.
 */
class RSoundVolumeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RSoundVolumeSet ();

    /**
     * Copy constructor
     */
    inline  RSoundVolumeSet (const RSoundVolumeSet &rhs);

    /**
     * All fields constructor
     */
    inline  RSoundVolumeSet (uint8 Volume_);

    /**
     * Destructor
     */
    inline virtual  ~RSoundVolumeSet();

    /**
     * Assignment operator
     */
    inline RSoundVolumeSet& operator = (const RSoundVolumeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RSoundVolumeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RSoundVolumeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RSoundVolumeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RSoundVolumeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Volume"

    static const int kVolume = 0;

    /**
     * Clears the field "Volume".
     *
     * The field will be set to its default value. The hasVolume()
     * method will return false.
     */
    inline void clearVolume();

    /**
     * Checks whether the field "Volume" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolume()). Otherwise it will return false.
     */
    inline bool hasVolume () const;

    /**
     * Returns the value of the member "Volume".
     *
     * Value of RSound volume
     *
     * @return The value of the field "Volume"
     */
    inline uint8 getVolume () const;

    /**
     * Sets the value of the member "Volume".
     *
     * Value of RSound volume
     *
     * @param Volume The value which will be set
     */
    inline void setVolume (uint8 Volume_);

    static const RSoundVolumeSet &getDefaultInstance();

private:

    inline void set_has_Volume ();

    inline void clear_has_Volume ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Volume;

};

/**
 * The status message of the property "ESEDriveMode"
 * Property for setting the ESE Driving mode value.
 */
class ESEDriveModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ESEDriveModeStatus ();

    /**
     * Copy constructor
     */
    inline  ESEDriveModeStatus (const ESEDriveModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ESEDriveModeStatus (uint8 DriveMode_);

    /**
     * Destructor
     */
    inline virtual  ~ESEDriveModeStatus();

    /**
     * Assignment operator
     */
    inline ESEDriveModeStatus& operator = (const ESEDriveModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ESEDriveModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ESEDriveModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ESEDriveModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ESEDriveModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DriveMode"

    static const int kDriveMode = 0;

    /**
     * Clears the field "DriveMode".
     *
     * The field will be set to its default value. The hasDriveMode()
     * method will return false.
     */
    inline void clearDriveMode();

    /**
     * Checks whether the field "DriveMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDriveMode()). Otherwise it will return false.
     */
    inline bool hasDriveMode () const;

    /**
     * Returns the value of the member "DriveMode".
     *
     * Value of Drive Mode
     *
     * @return The value of the field "DriveMode"
     */
    inline uint8 getDriveMode () const;

    /**
     * Sets the value of the member "DriveMode".
     *
     * Value of Drive Mode
     *
     * @param DriveMode The value which will be set
     */
    inline void setDriveMode (uint8 DriveMode_);

    static const ESEDriveModeStatus &getDefaultInstance();

private:

    inline void set_has_DriveMode ();

    inline void clear_has_DriveMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _DriveMode;

};

/**
 * The set message of the property "ESEDriveMode"
 * Property for setting the ESE Driving mode value.
 */
class ESEDriveModeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ESEDriveModeSet ();

    /**
     * Copy constructor
     */
    inline  ESEDriveModeSet (const ESEDriveModeSet &rhs);

    /**
     * All fields constructor
     */
    inline  ESEDriveModeSet (uint8 DriveMode_);

    /**
     * Destructor
     */
    inline virtual  ~ESEDriveModeSet();

    /**
     * Assignment operator
     */
    inline ESEDriveModeSet& operator = (const ESEDriveModeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ESEDriveModeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ESEDriveModeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ESEDriveModeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ESEDriveModeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DriveMode"

    static const int kDriveMode = 0;

    /**
     * Clears the field "DriveMode".
     *
     * The field will be set to its default value. The hasDriveMode()
     * method will return false.
     */
    inline void clearDriveMode();

    /**
     * Checks whether the field "DriveMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDriveMode()). Otherwise it will return false.
     */
    inline bool hasDriveMode () const;

    /**
     * Returns the value of the member "DriveMode".
     *
     * Value of Drive Mode
     *
     * @return The value of the field "DriveMode"
     */
    inline uint8 getDriveMode () const;

    /**
     * Sets the value of the member "DriveMode".
     *
     * Value of Drive Mode
     *
     * @param DriveMode The value which will be set
     */
    inline void setDriveMode (uint8 DriveMode_);

    static const ESEDriveModeSet &getDefaultInstance();

private:

    inline void set_has_DriveMode ();

    inline void clear_has_DriveMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _DriveMode;

};

/**
 * The status message of the property "AudioMode"
 * Property for setting the audio mode in HMI based on Arkamys Library.
 */
class AudioModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioModeStatus ();

    /**
     * Copy constructor
     */
    inline  AudioModeStatus (const AudioModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AudioModeStatus (::masc_main_fi_types::T_e8_AudioMode AudioMode_);

    /**
     * Destructor
     */
    inline virtual  ~AudioModeStatus();

    /**
     * Assignment operator
     */
    inline AudioModeStatus& operator = (const AudioModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudioMode"

    static const int kAudioMode = 0;

    /**
     * Clears the field "AudioMode".
     *
     * The field will be set to its default value. The hasAudioMode()
     * method will return false.
     */
    inline void clearAudioMode();

    /**
     * Checks whether the field "AudioMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioMode()). Otherwise it will return false.
     */
    inline bool hasAudioMode () const;

    /**
     * Returns the value of the member "AudioMode".
     *
     * value of audio mode to be used,
     * 1 - Arkamys Bypass
     * 2 - Arkamys Classic
     * 3 - Arkamys Auditorium
     * 4 - Arkamys Premium1
     * 5 - Arkamys Premium2
     *
     * @return The value of the field "AudioMode"
     */
    inline ::masc_main_fi_types::T_e8_AudioMode getAudioMode () const;

    /**
     * Sets the value of the member "AudioMode".
     *
     * value of audio mode to be used,
     * 1 - Arkamys Bypass
     * 2 - Arkamys Classic
     * 3 - Arkamys Auditorium
     * 4 - Arkamys Premium1
     * 5 - Arkamys Premium2
     *
     * @param AudioMode The value which will be set
     */
    inline void setAudioMode (::masc_main_fi_types::T_e8_AudioMode AudioMode_);

    static const AudioModeStatus &getDefaultInstance();

private:

    inline void set_has_AudioMode ();

    inline void clear_has_AudioMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudioMode _AudioMode;

};

/**
 * The status message of the property "ADAS_UPASoundType"
 * Property for setting Sound file type to be used to play UPA sounds
 */
class ADAS_UPASoundTypeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ADAS_UPASoundTypeStatus ();

    /**
     * Copy constructor
     */
    inline  ADAS_UPASoundTypeStatus (const ADAS_UPASoundTypeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ADAS_UPASoundTypeStatus (::masc_main_fi_types::T_e8_ADAS_UPA_SoundType SoundType_);

    /**
     * Destructor
     */
    inline virtual  ~ADAS_UPASoundTypeStatus();

    /**
     * Assignment operator
     */
    inline ADAS_UPASoundTypeStatus& operator = (const ADAS_UPASoundTypeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ADAS_UPASoundTypeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ADAS_UPASoundTypeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ADAS_UPASoundTypeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ADAS_UPASoundTypeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SoundType"

    static const int kSoundType = 0;

    /**
     * Clears the field "SoundType".
     *
     * The field will be set to its default value. The hasSoundType()
     * method will return false.
     */
    inline void clearSoundType();

    /**
     * Checks whether the field "SoundType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundType()). Otherwise it will return false.
     */
    inline bool hasSoundType () const;

    /**
     * Returns the value of the member "SoundType".
     *
     * Value of Sound Type being used
     *
     * @return The value of the field "SoundType"
     */
    inline ::masc_main_fi_types::T_e8_ADAS_UPA_SoundType getSoundType () const;

    /**
     * Sets the value of the member "SoundType".
     *
     * Value of Sound Type being used
     *
     * @param SoundType The value which will be set
     */
    inline void setSoundType (::masc_main_fi_types::T_e8_ADAS_UPA_SoundType SoundType_);

    static const ADAS_UPASoundTypeStatus &getDefaultInstance();

private:

    inline void set_has_SoundType ();

    inline void clear_has_SoundType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_ADAS_UPA_SoundType _SoundType;

};

/**
 * The set message of the property "ADAS_UPASoundType"
 * Property for setting Sound file type to be used to play UPA sounds
 */
class ADAS_UPASoundTypeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ADAS_UPASoundTypeSet ();

    /**
     * Copy constructor
     */
    inline  ADAS_UPASoundTypeSet (const ADAS_UPASoundTypeSet &rhs);

    /**
     * All fields constructor
     */
    inline  ADAS_UPASoundTypeSet (::masc_main_fi_types::T_e8_ADAS_UPA_SoundType SoundType_);

    /**
     * Destructor
     */
    inline virtual  ~ADAS_UPASoundTypeSet();

    /**
     * Assignment operator
     */
    inline ADAS_UPASoundTypeSet& operator = (const ADAS_UPASoundTypeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ADAS_UPASoundTypeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ADAS_UPASoundTypeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ADAS_UPASoundTypeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ADAS_UPASoundTypeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SoundType"

    static const int kSoundType = 0;

    /**
     * Clears the field "SoundType".
     *
     * The field will be set to its default value. The hasSoundType()
     * method will return false.
     */
    inline void clearSoundType();

    /**
     * Checks whether the field "SoundType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSoundType()). Otherwise it will return false.
     */
    inline bool hasSoundType () const;

    /**
     * Returns the value of the member "SoundType".
     *
     * Value of Sound Type to be used
     *
     * @return The value of the field "SoundType"
     */
    inline ::masc_main_fi_types::T_e8_ADAS_UPA_SoundType getSoundType () const;

    /**
     * Sets the value of the member "SoundType".
     *
     * Value of Sound Type to be used
     *
     * @param SoundType The value which will be set
     */
    inline void setSoundType (::masc_main_fi_types::T_e8_ADAS_UPA_SoundType SoundType_);

    static const ADAS_UPASoundTypeSet &getDefaultInstance();

private:

    inline void set_has_SoundType ();

    inline void clear_has_SoundType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_ADAS_UPA_SoundType _SoundType;

};

/**
 * The status message of the property "ADAS_ParkAssistVolume"
 * Property for setting the volume to be used for Park Assist BeepS (ADAS Sounds) except LDW.
 * For LDW use the property ADAS_LDW_UserVolume
 */
class ADAS_ParkAssistVolumeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ADAS_ParkAssistVolumeStatus ();

    /**
     * Copy constructor
     */
    inline  ADAS_ParkAssistVolumeStatus (const ADAS_ParkAssistVolumeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ADAS_ParkAssistVolumeStatus (::masc_main_fi_types::T_e8_ADAS_ParkAssist_Volume VolumeLevel_);

    /**
     * Destructor
     */
    inline virtual  ~ADAS_ParkAssistVolumeStatus();

    /**
     * Assignment operator
     */
    inline ADAS_ParkAssistVolumeStatus& operator = (const ADAS_ParkAssistVolumeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ADAS_ParkAssistVolumeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ADAS_ParkAssistVolumeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ADAS_ParkAssistVolumeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ADAS_ParkAssistVolumeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VolumeLevel"

    static const int kVolumeLevel = 0;

    /**
     * Clears the field "VolumeLevel".
     *
     * The field will be set to its default value. The hasVolumeLevel()
     * method will return false.
     */
    inline void clearVolumeLevel();

    /**
     * Checks whether the field "VolumeLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolumeLevel()). Otherwise it will return false.
     */
    inline bool hasVolumeLevel () const;

    /**
     * Returns the value of the member "VolumeLevel".
     *
     * Volume level being used
     *
     * @return The value of the field "VolumeLevel"
     */
    inline ::masc_main_fi_types::T_e8_ADAS_ParkAssist_Volume getVolumeLevel () const;

    /**
     * Sets the value of the member "VolumeLevel".
     *
     * Volume level being used
     *
     * @param VolumeLevel The value which will be set
     */
    inline void setVolumeLevel (::masc_main_fi_types::T_e8_ADAS_ParkAssist_Volume VolumeLevel_);

    static const ADAS_ParkAssistVolumeStatus &getDefaultInstance();

private:

    inline void set_has_VolumeLevel ();

    inline void clear_has_VolumeLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_ADAS_ParkAssist_Volume _VolumeLevel;

};

/**
 * The set message of the property "ADAS_ParkAssistVolume"
 * Property for setting the volume to be used for Park Assist BeepS (ADAS Sounds) except LDW.
 * For LDW use the property ADAS_LDW_UserVolume
 */
class ADAS_ParkAssistVolumeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ADAS_ParkAssistVolumeSet ();

    /**
     * Copy constructor
     */
    inline  ADAS_ParkAssistVolumeSet (const ADAS_ParkAssistVolumeSet &rhs);

    /**
     * All fields constructor
     */
    inline  ADAS_ParkAssistVolumeSet (::masc_main_fi_types::T_e8_ADAS_ParkAssist_Volume VolumeLevel_);

    /**
     * Destructor
     */
    inline virtual  ~ADAS_ParkAssistVolumeSet();

    /**
     * Assignment operator
     */
    inline ADAS_ParkAssistVolumeSet& operator = (const ADAS_ParkAssistVolumeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ADAS_ParkAssistVolumeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ADAS_ParkAssistVolumeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ADAS_ParkAssistVolumeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ADAS_ParkAssistVolumeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VolumeLevel"

    static const int kVolumeLevel = 0;

    /**
     * Clears the field "VolumeLevel".
     *
     * The field will be set to its default value. The hasVolumeLevel()
     * method will return false.
     */
    inline void clearVolumeLevel();

    /**
     * Checks whether the field "VolumeLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolumeLevel()). Otherwise it will return false.
     */
    inline bool hasVolumeLevel () const;

    /**
     * Returns the value of the member "VolumeLevel".
     *
     * Volume level to be used
     *
     * @return The value of the field "VolumeLevel"
     */
    inline ::masc_main_fi_types::T_e8_ADAS_ParkAssist_Volume getVolumeLevel () const;

    /**
     * Sets the value of the member "VolumeLevel".
     *
     * Volume level to be used
     *
     * @param VolumeLevel The value which will be set
     */
    inline void setVolumeLevel (::masc_main_fi_types::T_e8_ADAS_ParkAssist_Volume VolumeLevel_);

    static const ADAS_ParkAssistVolumeSet &getDefaultInstance();

private:

    inline void set_has_VolumeLevel ();

    inline void clear_has_VolumeLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_ADAS_ParkAssist_Volume _VolumeLevel;

};

/**
 * The status message of the property "ADAS_UPAMute"
 * Property for setting the Mute status of UPA Beeps
 */
class ADAS_UPAMuteStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ADAS_UPAMuteStatus ();

    /**
     * Copy constructor
     */
    inline  ADAS_UPAMuteStatus (const ADAS_UPAMuteStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ADAS_UPAMuteStatus (bool bMuted_);

    /**
     * Destructor
     */
    inline virtual  ~ADAS_UPAMuteStatus();

    /**
     * Assignment operator
     */
    inline ADAS_UPAMuteStatus& operator = (const ADAS_UPAMuteStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ADAS_UPAMuteStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ADAS_UPAMuteStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ADAS_UPAMuteStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ADAS_UPAMuteStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bMuted"

    static const int kBMuted = 0;

    /**
     * Clears the field "bMuted".
     *
     * The field will be set to its default value. The hasBMuted()
     * method will return false.
     */
    inline void clearBMuted();

    /**
     * Checks whether the field "bMuted" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBMuted()). Otherwise it will return false.
     */
    inline bool hasBMuted () const;

    /**
     * Returns the value of the member "bMuted".
     *
     * UPA Beep Mute status
     *
     * @return The value of the field "bMuted"
     */
    inline bool getBMuted () const;

    /**
     * Sets the value of the member "bMuted".
     *
     * UPA Beep Mute status
     *
     * @param bMuted The value which will be set
     */
    inline void setBMuted (bool bMuted_);

    static const ADAS_UPAMuteStatus &getDefaultInstance();

private:

    inline void set_has_bMuted ();

    inline void clear_has_bMuted ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bMuted;

};

/**
 * The set message of the property "ADAS_UPAMute"
 * Property for setting the Mute status of UPA Beeps
 */
class ADAS_UPAMuteSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ADAS_UPAMuteSet ();

    /**
     * Copy constructor
     */
    inline  ADAS_UPAMuteSet (const ADAS_UPAMuteSet &rhs);

    /**
     * All fields constructor
     */
    inline  ADAS_UPAMuteSet (bool bMute_);

    /**
     * Destructor
     */
    inline virtual  ~ADAS_UPAMuteSet();

    /**
     * Assignment operator
     */
    inline ADAS_UPAMuteSet& operator = (const ADAS_UPAMuteSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ADAS_UPAMuteSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ADAS_UPAMuteSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ADAS_UPAMuteSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ADAS_UPAMuteSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bMute"

    static const int kBMute = 0;

    /**
     * Clears the field "bMute".
     *
     * The field will be set to its default value. The hasBMute()
     * method will return false.
     */
    inline void clearBMute();

    /**
     * Checks whether the field "bMute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBMute()). Otherwise it will return false.
     */
    inline bool hasBMute () const;

    /**
     * Returns the value of the member "bMute".
     *
     * True - Mute, False - Unmute
     *
     * @return The value of the field "bMute"
     */
    inline bool getBMute () const;

    /**
     * Sets the value of the member "bMute".
     *
     * True - Mute, False - Unmute
     *
     * @param bMute The value which will be set
     */
    inline void setBMute (bool bMute_);

    static const ADAS_UPAMuteSet &getDefaultInstance();

private:

    inline void set_has_bMute ();

    inline void clear_has_bMute ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bMute;

};

/**
 * The status message of the property "AutomaticGainControl"
 * Property for setting the automatic gain control in HMI based on Arkamys Library.
 */
class AutomaticGainControlStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AutomaticGainControlStatus ();

    /**
     * Copy constructor
     */
    inline  AutomaticGainControlStatus (const AutomaticGainControlStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AutomaticGainControlStatus (bool AutomaticGainControl_);

    /**
     * Destructor
     */
    inline virtual  ~AutomaticGainControlStatus();

    /**
     * Assignment operator
     */
    inline AutomaticGainControlStatus& operator = (const AutomaticGainControlStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AutomaticGainControlStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AutomaticGainControlStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AutomaticGainControlStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AutomaticGainControlStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AutomaticGainControl"

    static const int kAutomaticGainControl = 0;

    /**
     * Clears the field "AutomaticGainControl".
     *
     * The field will be set to its default value. The hasAutomaticGainControl()
     * method will return false.
     */
    inline void clearAutomaticGainControl();

    /**
     * Checks whether the field "AutomaticGainControl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAutomaticGainControl()). Otherwise it will return false.
     */
    inline bool hasAutomaticGainControl () const;

    /**
     * Returns the value of the member "AutomaticGainControl".
     *
     * TRUE:  AGC mode is enabled
     * FALSE: AGC mode is disabled
     *
     * @return The value of the field "AutomaticGainControl"
     */
    inline bool getAutomaticGainControl () const;

    /**
     * Sets the value of the member "AutomaticGainControl".
     *
     * TRUE:  AGC mode is enabled
     * FALSE: AGC mode is disabled
     *
     * @param AutomaticGainControl The value which will be set
     */
    inline void setAutomaticGainControl (bool AutomaticGainControl_);

    static const AutomaticGainControlStatus &getDefaultInstance();

private:

    inline void set_has_AutomaticGainControl ();

    inline void clear_has_AutomaticGainControl ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _AutomaticGainControl;

};

/**
 * The set message of the property "AutomaticGainControl"
 * Property for setting the automatic gain control in HMI based on Arkamys Library.
 */
class AutomaticGainControlSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AutomaticGainControlSet ();

    /**
     * Copy constructor
     */
    inline  AutomaticGainControlSet (const AutomaticGainControlSet &rhs);

    /**
     * All fields constructor
     */
    inline  AutomaticGainControlSet (bool AutomaticGainControl_);

    /**
     * Destructor
     */
    inline virtual  ~AutomaticGainControlSet();

    /**
     * Assignment operator
     */
    inline AutomaticGainControlSet& operator = (const AutomaticGainControlSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AutomaticGainControlSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AutomaticGainControlSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AutomaticGainControlSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AutomaticGainControlSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AutomaticGainControl"

    static const int kAutomaticGainControl = 0;

    /**
     * Clears the field "AutomaticGainControl".
     *
     * The field will be set to its default value. The hasAutomaticGainControl()
     * method will return false.
     */
    inline void clearAutomaticGainControl();

    /**
     * Checks whether the field "AutomaticGainControl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAutomaticGainControl()). Otherwise it will return false.
     */
    inline bool hasAutomaticGainControl () const;

    /**
     * Returns the value of the member "AutomaticGainControl".
     *
     * TRUE:  AGC mode is enabled
     * FALSE: AGC mode is disabled
     *
     * @return The value of the field "AutomaticGainControl"
     */
    inline bool getAutomaticGainControl () const;

    /**
     * Sets the value of the member "AutomaticGainControl".
     *
     * TRUE:  AGC mode is enabled
     * FALSE: AGC mode is disabled
     *
     * @param AutomaticGainControl The value which will be set
     */
    inline void setAutomaticGainControl (bool AutomaticGainControl_);

    static const AutomaticGainControlSet &getDefaultInstance();

private:

    inline void set_has_AutomaticGainControl ();

    inline void clear_has_AutomaticGainControl ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _AutomaticGainControl;

};

/**
 * The status message of the property "ADAS_LDW_UserVolume"
 * Property for setting the user volume for LDW or LKA
 */
class ADAS_LDW_UserVolumeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ADAS_LDW_UserVolumeStatus ();

    /**
     * Copy constructor
     */
    inline  ADAS_LDW_UserVolumeStatus (const ADAS_LDW_UserVolumeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ADAS_LDW_UserVolumeStatus (::masc_main_fi_types::T_e8_ADAS_LDW_UserVolume VolumeLevel_);

    /**
     * Destructor
     */
    inline virtual  ~ADAS_LDW_UserVolumeStatus();

    /**
     * Assignment operator
     */
    inline ADAS_LDW_UserVolumeStatus& operator = (const ADAS_LDW_UserVolumeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ADAS_LDW_UserVolumeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ADAS_LDW_UserVolumeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ADAS_LDW_UserVolumeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ADAS_LDW_UserVolumeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VolumeLevel"

    static const int kVolumeLevel = 0;

    /**
     * Clears the field "VolumeLevel".
     *
     * The field will be set to its default value. The hasVolumeLevel()
     * method will return false.
     */
    inline void clearVolumeLevel();

    /**
     * Checks whether the field "VolumeLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolumeLevel()). Otherwise it will return false.
     */
    inline bool hasVolumeLevel () const;

    /**
     * Returns the value of the member "VolumeLevel".
     *
     * Volume level being used
     *
     * @return The value of the field "VolumeLevel"
     */
    inline ::masc_main_fi_types::T_e8_ADAS_LDW_UserVolume getVolumeLevel () const;

    /**
     * Sets the value of the member "VolumeLevel".
     *
     * Volume level being used
     *
     * @param VolumeLevel The value which will be set
     */
    inline void setVolumeLevel (::masc_main_fi_types::T_e8_ADAS_LDW_UserVolume VolumeLevel_);

    static const ADAS_LDW_UserVolumeStatus &getDefaultInstance();

private:

    inline void set_has_VolumeLevel ();

    inline void clear_has_VolumeLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_ADAS_LDW_UserVolume _VolumeLevel;

};

/**
 * The set message of the property "ADAS_LDW_UserVolume"
 * Property for setting the user volume for LDW or LKA
 */
class ADAS_LDW_UserVolumeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ADAS_LDW_UserVolumeSet ();

    /**
     * Copy constructor
     */
    inline  ADAS_LDW_UserVolumeSet (const ADAS_LDW_UserVolumeSet &rhs);

    /**
     * All fields constructor
     */
    inline  ADAS_LDW_UserVolumeSet (::masc_main_fi_types::T_e8_ADAS_LDW_UserVolume VolumeLevel_);

    /**
     * Destructor
     */
    inline virtual  ~ADAS_LDW_UserVolumeSet();

    /**
     * Assignment operator
     */
    inline ADAS_LDW_UserVolumeSet& operator = (const ADAS_LDW_UserVolumeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ADAS_LDW_UserVolumeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ADAS_LDW_UserVolumeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ADAS_LDW_UserVolumeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ADAS_LDW_UserVolumeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VolumeLevel"

    static const int kVolumeLevel = 0;

    /**
     * Clears the field "VolumeLevel".
     *
     * The field will be set to its default value. The hasVolumeLevel()
     * method will return false.
     */
    inline void clearVolumeLevel();

    /**
     * Checks whether the field "VolumeLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolumeLevel()). Otherwise it will return false.
     */
    inline bool hasVolumeLevel () const;

    /**
     * Returns the value of the member "VolumeLevel".
     *
     * Volume level to be used
     *
     * @return The value of the field "VolumeLevel"
     */
    inline ::masc_main_fi_types::T_e8_ADAS_LDW_UserVolume getVolumeLevel () const;

    /**
     * Sets the value of the member "VolumeLevel".
     *
     * Volume level to be used
     *
     * @param VolumeLevel The value which will be set
     */
    inline void setVolumeLevel (::masc_main_fi_types::T_e8_ADAS_LDW_UserVolume VolumeLevel_);

    static const ADAS_LDW_UserVolumeSet &getDefaultInstance();

private:

    inline void set_has_VolumeLevel ();

    inline void clear_has_VolumeLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_ADAS_LDW_UserVolume _VolumeLevel;

};

/**
 * The status message of the property "RSoundActivation"
 * Property for activation/deactivation of RSOUND
 */
class RSoundActivationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RSoundActivationStatus ();

    /**
     * Copy constructor
     */
    inline  RSoundActivationStatus (const RSoundActivationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RSoundActivationStatus (bool RSoundActive_);

    /**
     * Destructor
     */
    inline virtual  ~RSoundActivationStatus();

    /**
     * Assignment operator
     */
    inline RSoundActivationStatus& operator = (const RSoundActivationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RSoundActivationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RSoundActivationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RSoundActivationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RSoundActivationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RSoundActive"

    static const int kRSoundActive = 0;

    /**
     * Clears the field "RSoundActive".
     *
     * The field will be set to its default value. The hasRSoundActive()
     * method will return false.
     */
    inline void clearRSoundActive();

    /**
     * Checks whether the field "RSoundActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRSoundActive()). Otherwise it will return false.
     */
    inline bool hasRSoundActive () const;

    /**
     * Returns the value of the member "RSoundActive".
     *
     * TRUE : RSound will be activated
     * FALSE : RSound will be deactivated
     *
     * @return The value of the field "RSoundActive"
     */
    inline bool getRSoundActive () const;

    /**
     * Sets the value of the member "RSoundActive".
     *
     * TRUE : RSound will be activated
     * FALSE : RSound will be deactivated
     *
     * @param RSoundActive The value which will be set
     */
    inline void setRSoundActive (bool RSoundActive_);

    static const RSoundActivationStatus &getDefaultInstance();

private:

    inline void set_has_RSoundActive ();

    inline void clear_has_RSoundActive ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _RSoundActive;

};

/**
 * The set message of the property "RSoundActivation"
 * Property for activation/deactivation of RSOUND
 */
class RSoundActivationSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RSoundActivationSet ();

    /**
     * Copy constructor
     */
    inline  RSoundActivationSet (const RSoundActivationSet &rhs);

    /**
     * All fields constructor
     */
    inline  RSoundActivationSet (bool RSoundActive_);

    /**
     * Destructor
     */
    inline virtual  ~RSoundActivationSet();

    /**
     * Assignment operator
     */
    inline RSoundActivationSet& operator = (const RSoundActivationSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RSoundActivationSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RSoundActivationSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RSoundActivationSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RSoundActivationSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RSoundActive"

    static const int kRSoundActive = 0;

    /**
     * Clears the field "RSoundActive".
     *
     * The field will be set to its default value. The hasRSoundActive()
     * method will return false.
     */
    inline void clearRSoundActive();

    /**
     * Checks whether the field "RSoundActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRSoundActive()). Otherwise it will return false.
     */
    inline bool hasRSoundActive () const;

    /**
     * Returns the value of the member "RSoundActive".
     *
     * TRUE : RSound will be activated
     * FALSE : RSound will be deactivated
     *
     * @return The value of the field "RSoundActive"
     */
    inline bool getRSoundActive () const;

    /**
     * Sets the value of the member "RSoundActive".
     *
     * TRUE : RSound will be activated
     * FALSE : RSound will be deactivated
     *
     * @param RSoundActive The value which will be set
     */
    inline void setRSoundActive (bool RSoundActive_);

    static const RSoundActivationSet &getDefaultInstance();

private:

    inline void set_has_RSoundActive ();

    inline void clear_has_RSoundActive ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _RSoundActive;

};

/**
 * The status message of the property "ANCASCActiveTest"
 * Start/Stop the ANC,ASC Test
 */
class ANCASCActiveTestStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ANCASCActiveTestStatus ();

    /**
     * Copy constructor
     */
    inline  ANCASCActiveTestStatus (const ANCASCActiveTestStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ANCASCActiveTestStatus (uint8 TestStatus_);

    /**
     * Destructor
     */
    inline virtual  ~ANCASCActiveTestStatus();

    /**
     * Assignment operator
     */
    inline ANCASCActiveTestStatus& operator = (const ANCASCActiveTestStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ANCASCActiveTestStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ANCASCActiveTestStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ANCASCActiveTestStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ANCASCActiveTestStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TestStatus"

    static const int kTestStatus = 0;

    /**
     * Clears the field "TestStatus".
     *
     * The field will be set to its default value. The hasTestStatus()
     * method will return false.
     */
    inline void clearTestStatus();

    /**
     * Checks whether the field "TestStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTestStatus()). Otherwise it will return false.
     */
    inline bool hasTestStatus () const;

    /**
     * Returns the value of the member "TestStatus".
     *
     * 0:  Stop
     * 1:  Start
     *
     * @return The value of the field "TestStatus"
     */
    inline uint8 getTestStatus () const;

    /**
     * Sets the value of the member "TestStatus".
     *
     * 0:  Stop
     * 1:  Start
     *
     * @param TestStatus The value which will be set
     */
    inline void setTestStatus (uint8 TestStatus_);

    static const ANCASCActiveTestStatus &getDefaultInstance();

private:

    inline void set_has_TestStatus ();

    inline void clear_has_TestStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _TestStatus;

};

/**
 * The set message of the property "ANCASCActiveTest"
 * Start/Stop the ANC,ASC Test
 */
class ANCASCActiveTestSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ANCASCActiveTestSet ();

    /**
     * Copy constructor
     */
    inline  ANCASCActiveTestSet (const ANCASCActiveTestSet &rhs);

    /**
     * All fields constructor
     */
    inline  ANCASCActiveTestSet (uint8 Request_);

    /**
     * Destructor
     */
    inline virtual  ~ANCASCActiveTestSet();

    /**
     * Assignment operator
     */
    inline ANCASCActiveTestSet& operator = (const ANCASCActiveTestSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ANCASCActiveTestSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ANCASCActiveTestSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ANCASCActiveTestSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ANCASCActiveTestSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Request"

    static const int kRequest = 0;

    /**
     * Clears the field "Request".
     *
     * The field will be set to its default value. The hasRequest()
     * method will return false.
     */
    inline void clearRequest();

    /**
     * Checks whether the field "Request" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequest()). Otherwise it will return false.
     */
    inline bool hasRequest () const;

    /**
     * Returns the value of the member "Request".
     *
     * 0:  Stop
     * 1:  Start
     *
     * @return The value of the field "Request"
     */
    inline uint8 getRequest () const;

    /**
     * Sets the value of the member "Request".
     *
     * 0:  Stop
     * 1:  Start
     *
     * @param Request The value which will be set
     */
    inline void setRequest (uint8 Request_);

    static const ANCASCActiveTestSet &getDefaultInstance();

private:

    inline void set_has_Request ();

    inline void clear_has_Request ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Request;

};

/**
 * The status message of the property "ANCASCSelfDiagnosticStatus"
 * ANC ASC Self Diagnostic status
 */
class ANCASCSelfDiagnosticStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ANCASCSelfDiagnosticStatusStatus ();

    /**
     * Copy constructor
     */
    inline  ANCASCSelfDiagnosticStatusStatus (const ANCASCSelfDiagnosticStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ANCASCSelfDiagnosticStatusStatus (uint8 DiagResultSummary_, const ::masc_main_fi_types::T_MicrophoneResult& MicrophoneResult_, uint8 EnginePulse_, uint8 DoorOpenClose_, const ::std::string& ConfigInformation_);

    /**
     * Destructor
     */
    inline virtual  ~ANCASCSelfDiagnosticStatusStatus();

    /**
     * Assignment operator
     */
    inline ANCASCSelfDiagnosticStatusStatus& operator = (const ANCASCSelfDiagnosticStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ANCASCSelfDiagnosticStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ANCASCSelfDiagnosticStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ANCASCSelfDiagnosticStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ANCASCSelfDiagnosticStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DiagResultSummary"

    static const int kDiagResultSummary = 0;

    /**
     * Clears the field "DiagResultSummary".
     *
     * The field will be set to its default value. The hasDiagResultSummary()
     * method will return false.
     */
    inline void clearDiagResultSummary();

    /**
     * Checks whether the field "DiagResultSummary" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDiagResultSummary()). Otherwise it will return false.
     */
    inline bool hasDiagResultSummary () const;

    /**
     * Returns the value of the member "DiagResultSummary".
     *
     * 0:  Not tested
     * 1:  Normal
     * 2:  Fail
     *
     * @return The value of the field "DiagResultSummary"
     */
    inline uint8 getDiagResultSummary () const;

    /**
     * Sets the value of the member "DiagResultSummary".
     *
     * 0:  Not tested
     * 1:  Normal
     * 2:  Fail
     *
     * @param DiagResultSummary The value which will be set
     */
    inline void setDiagResultSummary (uint8 DiagResultSummary_);

    // API of field "MicrophoneResult"

    static const int kMicrophoneResult = 1;

    /**
     * Clears the field "MicrophoneResult".
     *
     * The field will be set to its default value. The hasMicrophoneResult()
     * method will return false.
     */
    inline void clearMicrophoneResult();

    /**
     * Checks whether the field "MicrophoneResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMicrophoneResult()). Otherwise it will return false.
     */
    inline bool hasMicrophoneResult () const;

    /**
     * Returns the value of the member "MicrophoneResult".
     *
     * Microphone Result
     *
     * @return The value of the field "MicrophoneResult"
     */
    inline const ::masc_main_fi_types::T_MicrophoneResult& getMicrophoneResult () const;

    /**
     * Retrieves the value of the field "MicrophoneResult" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MicrophoneResult".
     */
    inline ::masc_main_fi_types::T_MicrophoneResult& getMicrophoneResultMutable ();

    /**
     * Sets the value of the member "MicrophoneResult".
     *
     * Microphone Result
     *
     * @param MicrophoneResult The value which will be set
     */
    inline void setMicrophoneResult (const ::masc_main_fi_types::T_MicrophoneResult& MicrophoneResult_);

    // API of field "EnginePulse"

    static const int kEnginePulse = 2;

    /**
     * Clears the field "EnginePulse".
     *
     * The field will be set to its default value. The hasEnginePulse()
     * method will return false.
     */
    inline void clearEnginePulse();

    /**
     * Checks whether the field "EnginePulse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnginePulse()). Otherwise it will return false.
     */
    inline bool hasEnginePulse () const;

    /**
     * Returns the value of the member "EnginePulse".
     *
     * Engine pulse
     * 0: Normal
     * 1: Fail
     *
     * @return The value of the field "EnginePulse"
     */
    inline uint8 getEnginePulse () const;

    /**
     * Sets the value of the member "EnginePulse".
     *
     * Engine pulse
     * 0: Normal
     * 1: Fail
     *
     * @param EnginePulse The value which will be set
     */
    inline void setEnginePulse (uint8 EnginePulse_);

    // API of field "DoorOpenClose"

    static const int kDoorOpenClose = 3;

    /**
     * Clears the field "DoorOpenClose".
     *
     * The field will be set to its default value. The hasDoorOpenClose()
     * method will return false.
     */
    inline void clearDoorOpenClose();

    /**
     * Checks whether the field "DoorOpenClose" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDoorOpenClose()). Otherwise it will return false.
     */
    inline bool hasDoorOpenClose () const;

    /**
     * Returns the value of the member "DoorOpenClose".
     *
     * Door open close
     * 0: Normal
     * 1: Fail
     *
     * @return The value of the field "DoorOpenClose"
     */
    inline uint8 getDoorOpenClose () const;

    /**
     * Sets the value of the member "DoorOpenClose".
     *
     * Door open close
     * 0: Normal
     * 1: Fail
     *
     * @param DoorOpenClose The value which will be set
     */
    inline void setDoorOpenClose (uint8 DoorOpenClose_);

    // API of field "ConfigInformation"

    static const int kConfigInformation = 4;

    /**
     * Clears the field "ConfigInformation".
     *
     * The field will be set to its default value. The hasConfigInformation()
     * method will return false.
     */
    inline void clearConfigInformation();

    /**
     * Checks whether the field "ConfigInformation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfigInformation()). Otherwise it will return false.
     */
    inline bool hasConfigInformation () const;

    /**
     * Returns the value of the member "ConfigInformation".
     *
     * ANC config Result, ASCII information maximum of 100 bytes
     *
     * @return The value of the field "ConfigInformation"
     */
    inline const ::std::string& getConfigInformation () const;

    /**
     * Retrieves the value of the field "ConfigInformation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ConfigInformation".
     */
    inline ::std::string& getConfigInformationMutable ();

    /**
     * Sets the value of the member "ConfigInformation".
     *
     * ANC config Result, ASCII information maximum of 100 bytes
     *
     * @param ConfigInformation The value which will be set
     */
    inline void setConfigInformation (const ::std::string& ConfigInformation_);

    /**
     * Sets the value of the member "ConfigInformation".
     *
     * ANC config Result, ASCII information maximum of 100 bytes
     *
     * @param ConfigInformation The value which will be set
     */
    inline void setConfigInformation (const char* ConfigInformation_);

    /**
     * Sets the value of the member "ConfigInformation".
     *
     * ANC config Result, ASCII information maximum of 100 bytes
     *
     * @param ConfigInformation The value which will be set
     */
    inline void setConfigInformation (const char* value, size_t size);

    static const ANCASCSelfDiagnosticStatusStatus &getDefaultInstance();

private:

    inline void set_has_DiagResultSummary ();

    inline void clear_has_DiagResultSummary ();

    inline void set_has_MicrophoneResult ();

    inline void clear_has_MicrophoneResult ();

    inline void set_has_EnginePulse ();

    inline void clear_has_EnginePulse ();

    inline void set_has_DoorOpenClose ();

    inline void clear_has_DoorOpenClose ();

    inline void set_has_ConfigInformation ();

    inline void clear_has_ConfigInformation ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint8 _DiagResultSummary;

    ::masc_main_fi_types::T_MicrophoneResult _MicrophoneResult;

    uint8 _EnginePulse;

    uint8 _DoorOpenClose;

    ::std::string _ConfigInformation;

};

/**
 * The status message of the property "UserProfileChange"
 * status to inform User Profile Change Operation
 */
class UserProfileChangeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UserProfileChangeStatus ();

    /**
     * Copy constructor
     */
    inline  UserProfileChangeStatus (const UserProfileChangeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  UserProfileChangeStatus (bool UserProfileChange_);

    /**
     * Destructor
     */
    inline virtual  ~UserProfileChangeStatus();

    /**
     * Assignment operator
     */
    inline UserProfileChangeStatus& operator = (const UserProfileChangeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UserProfileChangeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UserProfileChangeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UserProfileChangeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UserProfileChangeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UserProfileChange"

    static const int kUserProfileChange = 0;

    /**
     * Clears the field "UserProfileChange".
     *
     * The field will be set to its default value. The hasUserProfileChange()
     * method will return false.
     */
    inline void clearUserProfileChange();

    /**
     * Checks whether the field "UserProfileChange" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserProfileChange()). Otherwise it will return false.
     */
    inline bool hasUserProfileChange () const;

    /**
     * Returns the value of the member "UserProfileChange".
     *
     * TRUE:  If User Profile is Changed
     * FALSE: If User Profile is not Changed
     *
     * @return The value of the field "UserProfileChange"
     */
    inline bool getUserProfileChange () const;

    /**
     * Sets the value of the member "UserProfileChange".
     *
     * TRUE:  If User Profile is Changed
     * FALSE: If User Profile is not Changed
     *
     * @param UserProfileChange The value which will be set
     */
    inline void setUserProfileChange (bool UserProfileChange_);

    static const UserProfileChangeStatus &getDefaultInstance();

private:

    inline void set_has_UserProfileChange ();

    inline void clear_has_UserProfileChange ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _UserProfileChange;

};

/**
 * The set message of the property "UserProfileChange"
 * status to inform User Profile Change Operation
 */
class UserProfileChangeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UserProfileChangeSet ();

    /**
     * Copy constructor
     */
    inline  UserProfileChangeSet (const UserProfileChangeSet &rhs);

    /**
     * All fields constructor
     */
    inline  UserProfileChangeSet (bool UserProfileChange_);

    /**
     * Destructor
     */
    inline virtual  ~UserProfileChangeSet();

    /**
     * Assignment operator
     */
    inline UserProfileChangeSet& operator = (const UserProfileChangeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UserProfileChangeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UserProfileChangeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UserProfileChangeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UserProfileChangeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UserProfileChange"

    static const int kUserProfileChange = 0;

    /**
     * Clears the field "UserProfileChange".
     *
     * The field will be set to its default value. The hasUserProfileChange()
     * method will return false.
     */
    inline void clearUserProfileChange();

    /**
     * Checks whether the field "UserProfileChange" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserProfileChange()). Otherwise it will return false.
     */
    inline bool hasUserProfileChange () const;

    /**
     * Returns the value of the member "UserProfileChange".
     *
     * TRUE:  If User Profile is Changed
     * FALSE: If User Profile is not Changed
     *
     * @return The value of the field "UserProfileChange"
     */
    inline bool getUserProfileChange () const;

    /**
     * Sets the value of the member "UserProfileChange".
     *
     * TRUE:  If User Profile is Changed
     * FALSE: If User Profile is not Changed
     *
     * @param UserProfileChange The value which will be set
     */
    inline void setUserProfileChange (bool UserProfileChange_);

    static const UserProfileChangeSet &getDefaultInstance();

private:

    inline void set_has_UserProfileChange ();

    inline void clear_has_UserProfileChange ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _UserProfileChange;

};

/**
 * The status message of the property "SRSoundNotificationState"
 * User can activate and de-activate Sound Notification for the request based on SR_AutomaticRecordStatus
 */
class SRSoundNotificationStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SRSoundNotificationStateStatus ();

    /**
     * Copy constructor
     */
    inline  SRSoundNotificationStateStatus (const SRSoundNotificationStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SRSoundNotificationStateStatus (bool SR_SoundNotification_State_);

    /**
     * Destructor
     */
    inline virtual  ~SRSoundNotificationStateStatus();

    /**
     * Assignment operator
     */
    inline SRSoundNotificationStateStatus& operator = (const SRSoundNotificationStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SRSoundNotificationStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SRSoundNotificationStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SRSoundNotificationStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SRSoundNotificationStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SR_SoundNotification_State"

    static const int kSR_SoundNotification_State = 0;

    /**
     * Clears the field "SR_SoundNotification_State".
     *
     * The field will be set to its default value. The hasSR_SoundNotification_State()
     * method will return false.
     */
    inline void clearSR_SoundNotification_State();

    /**
     * Checks whether the field "SR_SoundNotification_State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSR_SoundNotification_State()). Otherwise it will return false.
     */
    inline bool hasSR_SoundNotification_State () const;

    /**
     * Returns the value of the member "SR_SoundNotification_State".
     *
     * TRUE:  Sound Notification is on
     * FALSE: No sound notification
     *
     * @return The value of the field "SR_SoundNotification_State"
     */
    inline bool getSR_SoundNotification_State () const;

    /**
     * Sets the value of the member "SR_SoundNotification_State".
     *
     * TRUE:  Sound Notification is on
     * FALSE: No sound notification
     *
     * @param SR_SoundNotification_State The value which will be set
     */
    inline void setSR_SoundNotification_State (bool SR_SoundNotification_State_);

    static const SRSoundNotificationStateStatus &getDefaultInstance();

private:

    inline void set_has_SR_SoundNotification_State ();

    inline void clear_has_SR_SoundNotification_State ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _SR_SoundNotification_State;

};

/**
 * The set message of the property "SRSoundNotificationState"
 * User can activate and de-activate Sound Notification for the request based on SR_AutomaticRecordStatus
 */
class SRSoundNotificationStateSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SRSoundNotificationStateSet ();

    /**
     * Copy constructor
     */
    inline  SRSoundNotificationStateSet (const SRSoundNotificationStateSet &rhs);

    /**
     * All fields constructor
     */
    inline  SRSoundNotificationStateSet (bool SR_SoundNotification_State_);

    /**
     * Destructor
     */
    inline virtual  ~SRSoundNotificationStateSet();

    /**
     * Assignment operator
     */
    inline SRSoundNotificationStateSet& operator = (const SRSoundNotificationStateSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SRSoundNotificationStateSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SRSoundNotificationStateSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SRSoundNotificationStateSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SRSoundNotificationStateSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SR_SoundNotification_State"

    static const int kSR_SoundNotification_State = 0;

    /**
     * Clears the field "SR_SoundNotification_State".
     *
     * The field will be set to its default value. The hasSR_SoundNotification_State()
     * method will return false.
     */
    inline void clearSR_SoundNotification_State();

    /**
     * Checks whether the field "SR_SoundNotification_State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSR_SoundNotification_State()). Otherwise it will return false.
     */
    inline bool hasSR_SoundNotification_State () const;

    /**
     * Returns the value of the member "SR_SoundNotification_State".
     *
     * TRUE:  Sound Notification is on
     * FALSE: No sound notification
     *
     * @return The value of the field "SR_SoundNotification_State"
     */
    inline bool getSR_SoundNotification_State () const;

    /**
     * Sets the value of the member "SR_SoundNotification_State".
     *
     * TRUE:  Sound Notification is on
     * FALSE: No sound notification
     *
     * @param SR_SoundNotification_State The value which will be set
     */
    inline void setSR_SoundNotification_State (bool SR_SoundNotification_State_);

    static const SRSoundNotificationStateSet &getDefaultInstance();

private:

    inline void set_has_SR_SoundNotification_State ();

    inline void clear_has_SR_SoundNotification_State ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _SR_SoundNotification_State;

};

/**
 * The status message of the property "AudioPilotIntensity"
 * status of actual audio pilot intensity.
 */
class AudioPilotIntensityStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioPilotIntensityStatus ();

    /**
     * Copy constructor
     */
    inline  AudioPilotIntensityStatus (const AudioPilotIntensityStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AudioPilotIntensityStatus (::masc_main_fi_types::T_e8_AudioPilotIntensity Audio_Pilot_Intensity_);

    /**
     * Destructor
     */
    inline virtual  ~AudioPilotIntensityStatus();

    /**
     * Assignment operator
     */
    inline AudioPilotIntensityStatus& operator = (const AudioPilotIntensityStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioPilotIntensityStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioPilotIntensityStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioPilotIntensityStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioPilotIntensityStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Audio_Pilot_Intensity"

    static const int kAudio_Pilot_Intensity = 0;

    /**
     * Clears the field "Audio_Pilot_Intensity".
     *
     * The field will be set to its default value. The hasAudio_Pilot_Intensity()
     * method will return false.
     */
    inline void clearAudio_Pilot_Intensity();

    /**
     * Checks whether the field "Audio_Pilot_Intensity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudio_Pilot_Intensity()). Otherwise it will return false.
     */
    inline bool hasAudio_Pilot_Intensity () const;

    /**
     * Returns the value of the member "Audio_Pilot_Intensity".
     *
     * 1:  audio pilot intensity is LOW
     * 2:  audio pilot intensity is MEDIUM
     * 3:  audio pilot intensity is HIGH
     *
     * @return The value of the field "Audio_Pilot_Intensity"
     */
    inline ::masc_main_fi_types::T_e8_AudioPilotIntensity getAudio_Pilot_Intensity () const;

    /**
     * Sets the value of the member "Audio_Pilot_Intensity".
     *
     * 1:  audio pilot intensity is LOW
     * 2:  audio pilot intensity is MEDIUM
     * 3:  audio pilot intensity is HIGH
     *
     * @param Audio_Pilot_Intensity The value which will be set
     */
    inline void setAudio_Pilot_Intensity (::masc_main_fi_types::T_e8_AudioPilotIntensity Audio_Pilot_Intensity_);

    static const AudioPilotIntensityStatus &getDefaultInstance();

private:

    inline void set_has_Audio_Pilot_Intensity ();

    inline void clear_has_Audio_Pilot_Intensity ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudioPilotIntensity _Audio_Pilot_Intensity;

};

/**
 * The set message of the property "AudioPilotIntensity"
 * status of actual audio pilot intensity.
 */
class AudioPilotIntensitySet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioPilotIntensitySet ();

    /**
     * Copy constructor
     */
    inline  AudioPilotIntensitySet (const AudioPilotIntensitySet &rhs);

    /**
     * All fields constructor
     */
    inline  AudioPilotIntensitySet (::masc_main_fi_types::T_e8_AudioPilotIntensity Audio_Pilot_Intensity_);

    /**
     * Destructor
     */
    inline virtual  ~AudioPilotIntensitySet();

    /**
     * Assignment operator
     */
    inline AudioPilotIntensitySet& operator = (const AudioPilotIntensitySet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioPilotIntensitySet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioPilotIntensitySet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioPilotIntensitySet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioPilotIntensitySet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Audio_Pilot_Intensity"

    static const int kAudio_Pilot_Intensity = 0;

    /**
     * Clears the field "Audio_Pilot_Intensity".
     *
     * The field will be set to its default value. The hasAudio_Pilot_Intensity()
     * method will return false.
     */
    inline void clearAudio_Pilot_Intensity();

    /**
     * Checks whether the field "Audio_Pilot_Intensity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudio_Pilot_Intensity()). Otherwise it will return false.
     */
    inline bool hasAudio_Pilot_Intensity () const;

    /**
     * Returns the value of the member "Audio_Pilot_Intensity".
     *
     * 1:  audio pilot intensity is LOW
     * 2:  audio pilot intensity is MEDIUM
     * 3:  audio pilot intensity is HIGH
     *
     * @return The value of the field "Audio_Pilot_Intensity"
     */
    inline ::masc_main_fi_types::T_e8_AudioPilotIntensity getAudio_Pilot_Intensity () const;

    /**
     * Sets the value of the member "Audio_Pilot_Intensity".
     *
     * 1:  audio pilot intensity is LOW
     * 2:  audio pilot intensity is MEDIUM
     * 3:  audio pilot intensity is HIGH
     *
     * @param Audio_Pilot_Intensity The value which will be set
     */
    inline void setAudio_Pilot_Intensity (::masc_main_fi_types::T_e8_AudioPilotIntensity Audio_Pilot_Intensity_);

    static const AudioPilotIntensitySet &getDefaultInstance();

private:

    inline void set_has_Audio_Pilot_Intensity ();

    inline void clear_has_Audio_Pilot_Intensity ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudioPilotIntensity _Audio_Pilot_Intensity;

};

/**
 * The status message of the property "MainAudioAttenuation"
 * status of main audio attenuation from amplifier
 */
class MainAudioAttenuationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MainAudioAttenuationStatus ();

    /**
     * Copy constructor
     */
    inline  MainAudioAttenuationStatus (const MainAudioAttenuationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MainAudioAttenuationStatus (int8 Attenuation_Value_);

    /**
     * Destructor
     */
    inline virtual  ~MainAudioAttenuationStatus();

    /**
     * Assignment operator
     */
    inline MainAudioAttenuationStatus& operator = (const MainAudioAttenuationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MainAudioAttenuationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MainAudioAttenuationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MainAudioAttenuationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MainAudioAttenuationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Attenuation_Value"

    static const int kAttenuation_Value = 0;

    /**
     * Clears the field "Attenuation_Value".
     *
     * The field will be set to its default value. The hasAttenuation_Value()
     * method will return false.
     */
    inline void clearAttenuation_Value();

    /**
     * Checks whether the field "Attenuation_Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAttenuation_Value()). Otherwise it will return false.
     */
    inline bool hasAttenuation_Value () const;

    /**
     * Returns the value of the member "Attenuation_Value".
     *
     * Main Audio Attenuation value from Premium2 external amplifier
     *
     * @return The value of the field "Attenuation_Value"
     */
    inline int8 getAttenuation_Value () const;

    /**
     * Sets the value of the member "Attenuation_Value".
     *
     * Main Audio Attenuation value from Premium2 external amplifier
     *
     * @param Attenuation_Value The value which will be set
     */
    inline void setAttenuation_Value (int8 Attenuation_Value_);

    static const MainAudioAttenuationStatus &getDefaultInstance();

private:

    inline void set_has_Attenuation_Value ();

    inline void clear_has_Attenuation_Value ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int8 _Attenuation_Value;

};

/**
 * The start message of the method "VolumeMode"
 * Set special volume mode for volume changes of sound settings (e.g. set OnVolume).
 */
class VolumeModeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VolumeModeStart ();

    /**
     * Copy constructor
     */
    inline  VolumeModeStart (const VolumeModeStart &rhs);

    /**
     * All fields constructor
     */
    inline  VolumeModeStart (::masc_main_fi_types::T_e8_VolumeMode VolumeMode_, ::masc_main_fi_types::T_e8_ResourceNo Resource_);

    /**
     * Destructor
     */
    inline virtual  ~VolumeModeStart();

    /**
     * Assignment operator
     */
    inline VolumeModeStart& operator = (const VolumeModeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VolumeModeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VolumeModeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VolumeModeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VolumeModeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VolumeMode"

    static const int kVolumeMode = 0;

    /**
     * Clears the field "VolumeMode".
     *
     * The field will be set to its default value. The hasVolumeMode()
     * method will return false.
     */
    inline void clearVolumeMode();

    /**
     * Checks whether the field "VolumeMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolumeMode()). Otherwise it will return false.
     */
    inline bool hasVolumeMode () const;

    /**
     * Returns the value of the member "VolumeMode".
     *
     * volume mode to be set
     *
     * @return The value of the field "VolumeMode"
     */
    inline ::masc_main_fi_types::T_e8_VolumeMode getVolumeMode () const;

    /**
     * Sets the value of the member "VolumeMode".
     *
     * volume mode to be set
     *
     * @param VolumeMode The value which will be set
     */
    inline void setVolumeMode (::masc_main_fi_types::T_e8_VolumeMode VolumeMode_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    static const VolumeModeStart &getDefaultInstance();

private:

    inline void set_has_VolumeMode ();

    inline void clear_has_VolumeMode ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::masc_main_fi_types::T_e8_VolumeMode _VolumeMode;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

};

/**
 * The result message of the method "VolumeMode"
 * Set special volume mode for volume changes of sound settings (e.g. set OnVolume).
 */
class VolumeModeResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VolumeModeResult ();

    /**
     * Copy constructor
     */
    inline  VolumeModeResult (const VolumeModeResult &rhs);

    /**
     * All fields constructor
     */
    inline  VolumeModeResult (::masc_main_fi_types::T_e8_AudioServiceStatus ServiceStatus_);

    /**
     * Destructor
     */
    inline virtual  ~VolumeModeResult();

    /**
     * Assignment operator
     */
    inline VolumeModeResult& operator = (const VolumeModeResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VolumeModeResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VolumeModeResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VolumeModeResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VolumeModeResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ServiceStatus"

    static const int kServiceStatus = 0;

    /**
     * Clears the field "ServiceStatus".
     *
     * The field will be set to its default value. The hasServiceStatus()
     * method will return false.
     */
    inline void clearServiceStatus();

    /**
     * Checks whether the field "ServiceStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceStatus()). Otherwise it will return false.
     */
    inline bool hasServiceStatus () const;

    /**
     * Returns the value of the member "ServiceStatus".
     *
     * Confirmation that the message is received in audio middleware component
     *
     * @return The value of the field "ServiceStatus"
     */
    inline ::masc_main_fi_types::T_e8_AudioServiceStatus getServiceStatus () const;

    /**
     * Sets the value of the member "ServiceStatus".
     *
     * Confirmation that the message is received in audio middleware component
     *
     * @param ServiceStatus The value which will be set
     */
    inline void setServiceStatus (::masc_main_fi_types::T_e8_AudioServiceStatus ServiceStatus_);

    static const VolumeModeResult &getDefaultInstance();

private:

    inline void set_has_ServiceStatus ();

    inline void clear_has_ServiceStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudioServiceStatus _ServiceStatus;

};

/**
 * The start message of the method "Beep"
 * start beep sound.
 */
class BeepStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BeepStart ();

    /**
     * Copy constructor
     */
    inline  BeepStart (const BeepStart &rhs);

    /**
     * All fields constructor
     */
    inline  BeepStart (::masc_main_fi_types::T_e8_AudioBeepType BeepType_, ::masc_main_fi_types::T_e8_ResourceNo Resource_);

    /**
     * Destructor
     */
    inline virtual  ~BeepStart();

    /**
     * Assignment operator
     */
    inline BeepStart& operator = (const BeepStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BeepStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BeepStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BeepStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BeepStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BeepType"

    static const int kBeepType = 0;

    /**
     * Clears the field "BeepType".
     *
     * The field will be set to its default value. The hasBeepType()
     * method will return false.
     */
    inline void clearBeepType();

    /**
     * Checks whether the field "BeepType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBeepType()). Otherwise it will return false.
     */
    inline bool hasBeepType () const;

    /**
     * Returns the value of the member "BeepType".
     *
     * kind of beep
     *
     * @return The value of the field "BeepType"
     */
    inline ::masc_main_fi_types::T_e8_AudioBeepType getBeepType () const;

    /**
     * Sets the value of the member "BeepType".
     *
     * kind of beep
     *
     * @param BeepType The value which will be set
     */
    inline void setBeepType (::masc_main_fi_types::T_e8_AudioBeepType BeepType_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    static const BeepStart &getDefaultInstance();

private:

    inline void set_has_BeepType ();

    inline void clear_has_BeepType ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudioBeepType _BeepType;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

};

/**
 * The result message of the method "Beep"
 * start beep sound.
 */
class BeepResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BeepResult ();

    /**
     * Copy constructor
     */
    inline  BeepResult (const BeepResult &rhs);

    /**
     * All fields constructor
     */
    inline  BeepResult (::masc_main_fi_types::T_e8_AudioServiceStatus ServiceStatus_);

    /**
     * Destructor
     */
    inline virtual  ~BeepResult();

    /**
     * Assignment operator
     */
    inline BeepResult& operator = (const BeepResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BeepResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BeepResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BeepResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BeepResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ServiceStatus"

    static const int kServiceStatus = 0;

    /**
     * Clears the field "ServiceStatus".
     *
     * The field will be set to its default value. The hasServiceStatus()
     * method will return false.
     */
    inline void clearServiceStatus();

    /**
     * Checks whether the field "ServiceStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceStatus()). Otherwise it will return false.
     */
    inline bool hasServiceStatus () const;

    /**
     * Returns the value of the member "ServiceStatus".
     *
     * Confirmation that the message is received in audio middleware component
     *
     * @return The value of the field "ServiceStatus"
     */
    inline ::masc_main_fi_types::T_e8_AudioServiceStatus getServiceStatus () const;

    /**
     * Sets the value of the member "ServiceStatus".
     *
     * Confirmation that the message is received in audio middleware component
     *
     * @param ServiceStatus The value which will be set
     */
    inline void setServiceStatus (::masc_main_fi_types::T_e8_AudioServiceStatus ServiceStatus_);

    static const BeepResult &getDefaultInstance();

private:

    inline void set_has_ServiceStatus ();

    inline void clear_has_ServiceStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudioServiceStatus _ServiceStatus;

};

/**
 * The start message of the method "BeepFile"
 * Start Beep on Mix3 stream by playing the file provided.
 */
class BeepFileStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BeepFileStart ();

    /**
     * Copy constructor
     */
    inline  BeepFileStart (const BeepFileStart &rhs);

    /**
     * All fields constructor
     */
    inline  BeepFileStart (const ::std::string& sFilePath_, const ::masc_main_fi_types::T_BeepConfig& oConfig_);

    /**
     * Destructor
     */
    inline virtual  ~BeepFileStart();

    /**
     * Assignment operator
     */
    inline BeepFileStart& operator = (const BeepFileStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BeepFileStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BeepFileStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BeepFileStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BeepFileStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sFilePath"

    static const int kSFilePath = 0;

    /**
     * Clears the field "sFilePath".
     *
     * The field will be set to its default value. The hasSFilePath()
     * method will return false.
     */
    inline void clearSFilePath();

    /**
     * Checks whether the field "sFilePath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSFilePath()). Otherwise it will return false.
     */
    inline bool hasSFilePath () const;

    /**
     * Returns the value of the member "sFilePath".
     *
     * Full path to the audio file to be played
     *
     * @return The value of the field "sFilePath"
     */
    inline const ::std::string& getSFilePath () const;

    /**
     * Retrieves the value of the field "sFilePath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sFilePath".
     */
    inline ::std::string& getSFilePathMutable ();

    /**
     * Sets the value of the member "sFilePath".
     *
     * Full path to the audio file to be played
     *
     * @param sFilePath The value which will be set
     */
    inline void setSFilePath (const ::std::string& sFilePath_);

    /**
     * Sets the value of the member "sFilePath".
     *
     * Full path to the audio file to be played
     *
     * @param sFilePath The value which will be set
     */
    inline void setSFilePath (const char* sFilePath_);

    /**
     * Sets the value of the member "sFilePath".
     *
     * Full path to the audio file to be played
     *
     * @param sFilePath The value which will be set
     */
    inline void setSFilePath (const char* value, size_t size);

    // API of field "oConfig"

    static const int kOConfig = 1;

    /**
     * Clears the field "oConfig".
     *
     * The field will be set to its default value. The hasOConfig()
     * method will return false.
     */
    inline void clearOConfig();

    /**
     * Checks whether the field "oConfig" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOConfig()). Otherwise it will return false.
     */
    inline bool hasOConfig () const;

    /**
     * Returns the value of the member "oConfig".
     *
     * If the meaning of "oConfig" isn't clear, then there should be a description here.
     *
     * @return The value of the field "oConfig"
     */
    inline const ::masc_main_fi_types::T_BeepConfig& getOConfig () const;

    /**
     * Retrieves the value of the field "oConfig" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "oConfig".
     */
    inline ::masc_main_fi_types::T_BeepConfig& getOConfigMutable ();

    /**
     * Sets the value of the member "oConfig".
     *
     * If the meaning of "oConfig" isn't clear, then there should be a description here.
     *
     * @param oConfig The value which will be set
     */
    inline void setOConfig (const ::masc_main_fi_types::T_BeepConfig& oConfig_);

    static const BeepFileStart &getDefaultInstance();

private:

    inline void set_has_sFilePath ();

    inline void clear_has_sFilePath ();

    inline void set_has_oConfig ();

    inline void clear_has_oConfig ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _sFilePath;

    ::masc_main_fi_types::T_BeepConfig _oConfig;

};

/**
 * The result message of the method "BeepFile"
 * Start Beep on Mix3 stream by playing the file provided.
 */
class BeepFileResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BeepFileResult ();

    /**
     * Copy constructor
     */
    inline  BeepFileResult (const BeepFileResult &rhs);

    /**
     * All fields constructor
     */
    inline  BeepFileResult (::masc_main_fi_types::T_e8_AudioServiceStatus ServiceStatus_, uint32 u32Token_);

    /**
     * Destructor
     */
    inline virtual  ~BeepFileResult();

    /**
     * Assignment operator
     */
    inline BeepFileResult& operator = (const BeepFileResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BeepFileResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BeepFileResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BeepFileResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BeepFileResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ServiceStatus"

    static const int kServiceStatus = 0;

    /**
     * Clears the field "ServiceStatus".
     *
     * The field will be set to its default value. The hasServiceStatus()
     * method will return false.
     */
    inline void clearServiceStatus();

    /**
     * Checks whether the field "ServiceStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceStatus()). Otherwise it will return false.
     */
    inline bool hasServiceStatus () const;

    /**
     * Returns the value of the member "ServiceStatus".
     *
     * Confirmation that the message is received in audio middleware component
     *
     * @return The value of the field "ServiceStatus"
     */
    inline ::masc_main_fi_types::T_e8_AudioServiceStatus getServiceStatus () const;

    /**
     * Sets the value of the member "ServiceStatus".
     *
     * Confirmation that the message is received in audio middleware component
     *
     * @param ServiceStatus The value which will be set
     */
    inline void setServiceStatus (::masc_main_fi_types::T_e8_AudioServiceStatus ServiceStatus_);

    // API of field "u32Token"

    static const int kU32Token = 1;

    /**
     * Clears the field "u32Token".
     *
     * The field will be set to its default value. The hasU32Token()
     * method will return false.
     */
    inline void clearU32Token();

    /**
     * Checks whether the field "u32Token" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Token()). Otherwise it will return false.
     */
    inline bool hasU32Token () const;

    /**
     * Returns the value of the member "u32Token".
     *
     * If Service status is OK, then a token is issued. Beep Status can be tracked using the token.
     *
     * @return The value of the field "u32Token"
     */
    inline uint32 getU32Token () const;

    /**
     * Sets the value of the member "u32Token".
     *
     * If Service status is OK, then a token is issued. Beep Status can be tracked using the token.
     *
     * @param u32Token The value which will be set
     */
    inline void setU32Token (uint32 u32Token_);

    static const BeepFileResult &getDefaultInstance();

private:

    inline void set_has_ServiceStatus ();

    inline void clear_has_ServiceStatus ();

    inline void set_has_u32Token ();

    inline void clear_has_u32Token ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudioServiceStatus _ServiceStatus;

    uint32 _u32Token;

};

/**
 * The start message of the method "Mute"
 * With this methode a requester can gives a mute request to the audio management. Same methode is used to release the request.
 *
 * The RUN Events are specially conceived for drives, to indicate the starting of a Demute. If audio playback is stoped an restarted the middle of a track nothing from the track should be left out, but there should also be a soft fade in. That means the drive must start playing only when the Demute begins.
 * This treatment is planned only for the Demute. There is no RUN Acknowledge for a Mute!
 *
 * The time between demute-request and start of the command is unspecified, as demute dependent on all Requesters.#xD#xA
 * Keep always in mind as a Design-Rule:
 * The generation of Acknowledges or start of additonal actions should not depend on Methode Result of a demute.
 */
class MuteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MuteStart ();

    /**
     * Copy constructor
     */
    inline  MuteStart (const MuteStart &rhs);

    /**
     * All fields constructor
     */
    inline  MuteStart (::mascf_aud_src_route_fi_types::T_e8_MuteRequester Requester_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::mascf_aud_src_route_fi_types::T_e8MuteAction State_, const ::mascf_aud_src_route_fi_types::T_b32MuteReason& Reason_, ::masc_main_fi_types::T_e8_AudioChannel Channel_);

    /**
     * Destructor
     */
    inline virtual  ~MuteStart();

    /**
     * Assignment operator
     */
    inline MuteStart& operator = (const MuteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MuteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MuteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MuteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MuteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Requester"

    static const int kRequester = 0;

    /**
     * Clears the field "Requester".
     *
     * The field will be set to its default value. The hasRequester()
     * method will return false.
     */
    inline void clearRequester();

    /**
     * Checks whether the field "Requester" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequester()). Otherwise it will return false.
     */
    inline bool hasRequester () const;

    /**
     * Returns the value of the member "Requester".
     *
     * Gives the Requester, a new mute state is requested for
     *
     * @return The value of the field "Requester"
     */
    inline ::mascf_aud_src_route_fi_types::T_e8_MuteRequester getRequester () const;

    /**
     * Sets the value of the member "Requester".
     *
     * Gives the Requester, a new mute state is requested for
     *
     * @param Requester The value which will be set
     */
    inline void setRequester (::mascf_aud_src_route_fi_types::T_e8_MuteRequester Requester_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "State"

    static const int kState = 2;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * Give the new action of the request. With ON a mute is requested, with OFF
     * a Demute is requested
     *
     * @return The value of the field "State"
     */
    inline ::mascf_aud_src_route_fi_types::T_e8MuteAction getState () const;

    /**
     * Sets the value of the member "State".
     *
     * Give the new action of the request. With ON a mute is requested, with OFF
     * a Demute is requested
     *
     * @param State The value which will be set
     */
    inline void setState (::mascf_aud_src_route_fi_types::T_e8MuteAction State_);

    // API of field "Reason"

    static const int kReason = 3;

    /**
     * Clears the field "Reason".
     *
     * The field will be set to its default value. The hasReason()
     * method will return false.
     */
    inline void clearReason();

    /**
     * Checks whether the field "Reason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReason()). Otherwise it will return false.
     */
    inline bool hasReason () const;

    /**
     * Returns the value of the member "Reason".
     *
     * Give the reason of a mute request this parameter can be used for controlling
     * the mute ramp.
     *
     * @return The value of the field "Reason"
     */
    inline const ::mascf_aud_src_route_fi_types::T_b32MuteReason& getReason () const;

    /**
     * Retrieves the value of the field "Reason" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Reason".
     */
    inline ::mascf_aud_src_route_fi_types::T_b32MuteReason& getReasonMutable ();

    /**
     * Sets the value of the member "Reason".
     *
     * Give the reason of a mute request this parameter can be used for controlling
     * the mute ramp.
     *
     * @param Reason The value which will be set
     */
    inline void setReason (const ::mascf_aud_src_route_fi_types::T_b32MuteReason& Reason_);

    // API of field "Channel"

    static const int kChannel = 4;

    /**
     * Clears the field "Channel".
     *
     * The field will be set to its default value. The hasChannel()
     * method will return false.
     */
    inline void clearChannel();

    /**
     * Checks whether the field "Channel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannel()). Otherwise it will return false.
     */
    inline bool hasChannel () const;

    /**
     * Returns the value of the member "Channel".
     *
     * Related channel
     *
     * @return The value of the field "Channel"
     */
    inline ::masc_main_fi_types::T_e8_AudioChannel getChannel () const;

    /**
     * Sets the value of the member "Channel".
     *
     * Related channel
     *
     * @param Channel The value which will be set
     */
    inline void setChannel (::masc_main_fi_types::T_e8_AudioChannel Channel_);

    static const MuteStart &getDefaultInstance();

private:

    inline void set_has_Requester ();

    inline void clear_has_Requester ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_State ();

    inline void clear_has_State ();

    inline void set_has_Reason ();

    inline void clear_has_Reason ();

    inline void set_has_Channel ();

    inline void clear_has_Channel ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::mascf_aud_src_route_fi_types::T_e8_MuteRequester _Requester;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    ::mascf_aud_src_route_fi_types::T_e8MuteAction _State;

    ::mascf_aud_src_route_fi_types::T_b32MuteReason _Reason;

    ::masc_main_fi_types::T_e8_AudioChannel _Channel;

};

/**
 * The result message of the method "Mute"
 * With this methode a requester can gives a mute request to the audio management. Same methode is used to release the request.
 *
 * The RUN Events are specially conceived for drives, to indicate the starting of a Demute. If audio playback is stoped an restarted the middle of a track nothing from the track should be left out, but there should also be a soft fade in. That means the drive must start playing only when the Demute begins.
 * This treatment is planned only for the Demute. There is no RUN Acknowledge for a Mute!
 *
 * The time between demute-request and start of the command is unspecified, as demute dependent on all Requesters.#xD#xA
 * Keep always in mind as a Design-Rule:
 * The generation of Acknowledges or start of additonal actions should not depend on Methode Result of a demute.
 */
class MuteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MuteResult ();

    /**
     * Copy constructor
     */
    inline  MuteResult (const MuteResult &rhs);

    /**
     * All fields constructor
     */
    inline  MuteResult (::mascf_aud_src_route_fi_types::T_e8_MuteRequester Requester_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::mascf_aud_src_route_fi_types::T_e8_MuteState State_, ::masc_main_fi_types::T_e8_AudioChannel Channel_);

    /**
     * Destructor
     */
    inline virtual  ~MuteResult();

    /**
     * Assignment operator
     */
    inline MuteResult& operator = (const MuteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MuteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MuteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MuteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MuteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Requester"

    static const int kRequester = 0;

    /**
     * Clears the field "Requester".
     *
     * The field will be set to its default value. The hasRequester()
     * method will return false.
     */
    inline void clearRequester();

    /**
     * Checks whether the field "Requester" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequester()). Otherwise it will return false.
     */
    inline bool hasRequester () const;

    /**
     * Returns the value of the member "Requester".
     *
     * Gives the Requester, a new mute state is requested for
     *
     * @return The value of the field "Requester"
     */
    inline ::mascf_aud_src_route_fi_types::T_e8_MuteRequester getRequester () const;

    /**
     * Sets the value of the member "Requester".
     *
     * Gives the Requester, a new mute state is requested for
     *
     * @param Requester The value which will be set
     */
    inline void setRequester (::mascf_aud_src_route_fi_types::T_e8_MuteRequester Requester_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "State"

    static const int kState = 2;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * Give the new action of the request. with ON a mute is requested, with OFF
     * a Demute is requested
     *
     * @return The value of the field "State"
     */
    inline ::mascf_aud_src_route_fi_types::T_e8_MuteState getState () const;

    /**
     * Sets the value of the member "State".
     *
     * Give the new action of the request. with ON a mute is requested, with OFF
     * a Demute is requested
     *
     * @param State The value which will be set
     */
    inline void setState (::mascf_aud_src_route_fi_types::T_e8_MuteState State_);

    // API of field "Channel"

    static const int kChannel = 3;

    /**
     * Clears the field "Channel".
     *
     * The field will be set to its default value. The hasChannel()
     * method will return false.
     */
    inline void clearChannel();

    /**
     * Checks whether the field "Channel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannel()). Otherwise it will return false.
     */
    inline bool hasChannel () const;

    /**
     * Returns the value of the member "Channel".
     *
     * Related channel
     *
     * @return The value of the field "Channel"
     */
    inline ::masc_main_fi_types::T_e8_AudioChannel getChannel () const;

    /**
     * Sets the value of the member "Channel".
     *
     * Related channel
     *
     * @param Channel The value which will be set
     */
    inline void setChannel (::masc_main_fi_types::T_e8_AudioChannel Channel_);

    static const MuteResult &getDefaultInstance();

private:

    inline void set_has_Requester ();

    inline void clear_has_Requester ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_State ();

    inline void clear_has_State ();

    inline void set_has_Channel ();

    inline void clear_has_Channel ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::mascf_aud_src_route_fi_types::T_e8_MuteRequester _Requester;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    ::mascf_aud_src_route_fi_types::T_e8_MuteState _State;

    ::masc_main_fi_types::T_e8_AudioChannel _Channel;

};

/**
 * The start message of the method "Set_Mute_Ramp"
 * The MuteRequest Methode give a Mute Request to the Audio System
 */
class Set_Mute_RampStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Set_Mute_RampStart ();

    /**
     * Copy constructor
     */
    inline  Set_Mute_RampStart (const Set_Mute_RampStart &rhs);

    /**
     * All fields constructor
     */
    inline  Set_Mute_RampStart (::masc_main_fi_types::T_e8_ResourceNo Resource_, ::mascf_aud_src_route_fi_types::T_e8MuteSpeed State_, ::masc_main_fi_types::T_e8_AudioChannel Channel_);

    /**
     * Destructor
     */
    inline virtual  ~Set_Mute_RampStart();

    /**
     * Assignment operator
     */
    inline Set_Mute_RampStart& operator = (const Set_Mute_RampStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Set_Mute_RampStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Set_Mute_RampStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Set_Mute_RampStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Set_Mute_RampStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Resource"

    static const int kResource = 0;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "State"

    static const int kState = 1;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * This parameter selcets the mute speed
     *
     * @return The value of the field "State"
     */
    inline ::mascf_aud_src_route_fi_types::T_e8MuteSpeed getState () const;

    /**
     * Sets the value of the member "State".
     *
     * This parameter selcets the mute speed
     *
     * @param State The value which will be set
     */
    inline void setState (::mascf_aud_src_route_fi_types::T_e8MuteSpeed State_);

    // API of field "Channel"

    static const int kChannel = 2;

    /**
     * Clears the field "Channel".
     *
     * The field will be set to its default value. The hasChannel()
     * method will return false.
     */
    inline void clearChannel();

    /**
     * Checks whether the field "Channel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannel()). Otherwise it will return false.
     */
    inline bool hasChannel () const;

    /**
     * Returns the value of the member "Channel".
     *
     * Related Channel
     *
     * @return The value of the field "Channel"
     */
    inline ::masc_main_fi_types::T_e8_AudioChannel getChannel () const;

    /**
     * Sets the value of the member "Channel".
     *
     * Related Channel
     *
     * @param Channel The value which will be set
     */
    inline void setChannel (::masc_main_fi_types::T_e8_AudioChannel Channel_);

    static const Set_Mute_RampStart &getDefaultInstance();

private:

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_State ();

    inline void clear_has_State ();

    inline void set_has_Channel ();

    inline void clear_has_Channel ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    ::mascf_aud_src_route_fi_types::T_e8MuteSpeed _State;

    ::masc_main_fi_types::T_e8_AudioChannel _Channel;

};

/**
 * The result message of the method "Set_Mute_Ramp"
 * The MuteRequest Methode give a Mute Request to the Audio System
 */
class Set_Mute_RampResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Set_Mute_RampResult ();

    /**
     * Copy constructor
     */
    inline  Set_Mute_RampResult (const Set_Mute_RampResult &rhs);

    /**
     * All fields constructor
     */
    inline  Set_Mute_RampResult (::masc_main_fi_types::T_e8_AudioServiceStatus ServiceStatus_);

    /**
     * Destructor
     */
    inline virtual  ~Set_Mute_RampResult();

    /**
     * Assignment operator
     */
    inline Set_Mute_RampResult& operator = (const Set_Mute_RampResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Set_Mute_RampResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Set_Mute_RampResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Set_Mute_RampResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Set_Mute_RampResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ServiceStatus"

    static const int kServiceStatus = 0;

    /**
     * Clears the field "ServiceStatus".
     *
     * The field will be set to its default value. The hasServiceStatus()
     * method will return false.
     */
    inline void clearServiceStatus();

    /**
     * Checks whether the field "ServiceStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceStatus()). Otherwise it will return false.
     */
    inline bool hasServiceStatus () const;

    /**
     * Returns the value of the member "ServiceStatus".
     *
     * Confirmation that the message is received in audio middleware component
     *
     * @return The value of the field "ServiceStatus"
     */
    inline ::masc_main_fi_types::T_e8_AudioServiceStatus getServiceStatus () const;

    /**
     * Sets the value of the member "ServiceStatus".
     *
     * Confirmation that the message is received in audio middleware component
     *
     * @param ServiceStatus The value which will be set
     */
    inline void setServiceStatus (::masc_main_fi_types::T_e8_AudioServiceStatus ServiceStatus_);

    static const Set_Mute_RampResult &getDefaultInstance();

private:

    inline void set_has_ServiceStatus ();

    inline void clear_has_ServiceStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudioServiceStatus _ServiceStatus;

};

/**
 * The start message of the method "AudioSource"
 * The audio Manager is informed about the actual source.
 * This information is used to adapt the signal processing to the new source.
 * To adapt might mean changing the frequency responce, use seperate user setting like Volume, bas or fader or change the audio level,...
 * It might also mean, that some functions are blocked, like fader, which his set to linear during phone.
 */
class AudioSourceStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioSourceStart ();

    /**
     * Copy constructor
     */
    inline  AudioSourceStart (const AudioSourceStart &rhs);

    /**
     * All fields constructor
     */
    inline  AudioSourceStart (::masc_main_fi_types::T_e8_ResourceNo Resource_, ::mascf_aud_src_route_fi_types::T_e8_AudSource Source_, ::masc_main_fi_types::T_e8_AudioChannel Channel_);

    /**
     * Destructor
     */
    inline virtual  ~AudioSourceStart();

    /**
     * Assignment operator
     */
    inline AudioSourceStart& operator = (const AudioSourceStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioSourceStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioSourceStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioSourceStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioSourceStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Resource"

    static const int kResource = 0;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "Source"

    static const int kSource = 1;

    /**
     * Clears the field "Source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "Source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "Source".
     *
     * actual Active source.
     *
     * @return The value of the field "Source"
     */
    inline ::mascf_aud_src_route_fi_types::T_e8_AudSource getSource () const;

    /**
     * Sets the value of the member "Source".
     *
     * actual Active source.
     *
     * @param Source The value which will be set
     */
    inline void setSource (::mascf_aud_src_route_fi_types::T_e8_AudSource Source_);

    // API of field "Channel"

    static const int kChannel = 2;

    /**
     * Clears the field "Channel".
     *
     * The field will be set to its default value. The hasChannel()
     * method will return false.
     */
    inline void clearChannel();

    /**
     * Checks whether the field "Channel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannel()). Otherwise it will return false.
     */
    inline bool hasChannel () const;

    /**
     * Returns the value of the member "Channel".
     *
     * Related channel
     *
     * @return The value of the field "Channel"
     */
    inline ::masc_main_fi_types::T_e8_AudioChannel getChannel () const;

    /**
     * Sets the value of the member "Channel".
     *
     * Related channel
     *
     * @param Channel The value which will be set
     */
    inline void setChannel (::masc_main_fi_types::T_e8_AudioChannel Channel_);

    static const AudioSourceStart &getDefaultInstance();

private:

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_Source ();

    inline void clear_has_Source ();

    inline void set_has_Channel ();

    inline void clear_has_Channel ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    ::mascf_aud_src_route_fi_types::T_e8_AudSource _Source;

    ::masc_main_fi_types::T_e8_AudioChannel _Channel;

};

/**
 * The result message of the method "AudioSource"
 * The audio Manager is informed about the actual source.
 * This information is used to adapt the signal processing to the new source.
 * To adapt might mean changing the frequency responce, use seperate user setting like Volume, bas or fader or change the audio level,...
 * It might also mean, that some functions are blocked, like fader, which his set to linear during phone.
 */
class AudioSourceResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioSourceResult ();

    /**
     * Copy constructor
     */
    inline  AudioSourceResult (const AudioSourceResult &rhs);

    /**
     * All fields constructor
     */
    inline  AudioSourceResult (::masc_main_fi_types::T_e8_AudioServiceStatus ServiceStatus_);

    /**
     * Destructor
     */
    inline virtual  ~AudioSourceResult();

    /**
     * Assignment operator
     */
    inline AudioSourceResult& operator = (const AudioSourceResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioSourceResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioSourceResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioSourceResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioSourceResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ServiceStatus"

    static const int kServiceStatus = 0;

    /**
     * Clears the field "ServiceStatus".
     *
     * The field will be set to its default value. The hasServiceStatus()
     * method will return false.
     */
    inline void clearServiceStatus();

    /**
     * Checks whether the field "ServiceStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceStatus()). Otherwise it will return false.
     */
    inline bool hasServiceStatus () const;

    /**
     * Returns the value of the member "ServiceStatus".
     *
     * Confirmation that the message is received in audio middleware component
     *
     * @return The value of the field "ServiceStatus"
     */
    inline ::masc_main_fi_types::T_e8_AudioServiceStatus getServiceStatus () const;

    /**
     * Sets the value of the member "ServiceStatus".
     *
     * Confirmation that the message is received in audio middleware component
     *
     * @param ServiceStatus The value which will be set
     */
    inline void setServiceStatus (::masc_main_fi_types::T_e8_AudioServiceStatus ServiceStatus_);

    static const AudioSourceResult &getDefaultInstance();

private:

    inline void set_has_ServiceStatus ();

    inline void clear_has_ServiceStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudioServiceStatus _ServiceStatus;

};

/**
 * The start message of the method "AmpDeviceAudioRoute"
 * command to set the audio route in amplifier device.
 * This information is used to set the amplifier device (presently this is the ADR) to the correct audio input.
 */
class AmpDeviceAudioRouteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AmpDeviceAudioRouteStart ();

    /**
     * Copy constructor
     */
    inline  AmpDeviceAudioRouteStart (const AmpDeviceAudioRouteStart &rhs);

    /**
     * All fields constructor
     */
    inline  AmpDeviceAudioRouteStart (::masc_main_fi_types::T_e8_ResourceNo Resource_, ::masc_main_fi_types::T_e8_AudioChannel Channel_, ::masc_main_fi_types::T_e8_RouteNo Source_, const ::std::string& AudProcAdev_, uint32 MsgHandle_, ::masc_main_fi_types::T_e8_OnGoingAction Action_);

    /**
     * Destructor
     */
    inline virtual  ~AmpDeviceAudioRouteStart();

    /**
     * Assignment operator
     */
    inline AmpDeviceAudioRouteStart& operator = (const AmpDeviceAudioRouteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AmpDeviceAudioRouteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AmpDeviceAudioRouteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AmpDeviceAudioRouteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AmpDeviceAudioRouteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Resource"

    static const int kResource = 0;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not supported at the moment.
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not supported at the moment.
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "Channel"

    static const int kChannel = 1;

    /**
     * Clears the field "Channel".
     *
     * The field will be set to its default value. The hasChannel()
     * method will return false.
     */
    inline void clearChannel();

    /**
     * Checks whether the field "Channel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannel()). Otherwise it will return false.
     */
    inline bool hasChannel () const;

    /**
     * Returns the value of the member "Channel".
     *
     * Related channel
     *
     * @return The value of the field "Channel"
     */
    inline ::masc_main_fi_types::T_e8_AudioChannel getChannel () const;

    /**
     * Sets the value of the member "Channel".
     *
     * Related channel
     *
     * @param Channel The value which will be set
     */
    inline void setChannel (::masc_main_fi_types::T_e8_AudioChannel Channel_);

    // API of field "Source"

    static const int kSource = 2;

    /**
     * Clears the field "Source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "Source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "Source".
     *
     * actual Active source.
     *
     * @return The value of the field "Source"
     */
    inline ::masc_main_fi_types::T_e8_RouteNo getSource () const;

    /**
     * Sets the value of the member "Source".
     *
     * actual Active source.
     *
     * @param Source The value which will be set
     */
    inline void setSource (::masc_main_fi_types::T_e8_RouteNo Source_);

    // API of field "AudProcAdev"

    static const int kAudProcAdev = 3;

    /**
     * Clears the field "AudProcAdev".
     *
     * The field will be set to its default value. The hasAudProcAdev()
     * method will return false.
     */
    inline void clearAudProcAdev();

    /**
     * Checks whether the field "AudProcAdev" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudProcAdev()). Otherwise it will return false.
     */
    inline bool hasAudProcAdev () const;

    /**
     * Returns the value of the member "AudProcAdev".
     *
     * Alsa Device for AudProc
     *
     * @return The value of the field "AudProcAdev"
     */
    inline const ::std::string& getAudProcAdev () const;

    /**
     * Retrieves the value of the field "AudProcAdev" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AudProcAdev".
     */
    inline ::std::string& getAudProcAdevMutable ();

    /**
     * Sets the value of the member "AudProcAdev".
     *
     * Alsa Device for AudProc
     *
     * @param AudProcAdev The value which will be set
     */
    inline void setAudProcAdev (const ::std::string& AudProcAdev_);

    /**
     * Sets the value of the member "AudProcAdev".
     *
     * Alsa Device for AudProc
     *
     * @param AudProcAdev The value which will be set
     */
    inline void setAudProcAdev (const char* AudProcAdev_);

    /**
     * Sets the value of the member "AudProcAdev".
     *
     * Alsa Device for AudProc
     *
     * @param AudProcAdev The value which will be set
     */
    inline void setAudProcAdev (const char* value, size_t size);

    // API of field "MsgHandle"

    static const int kMsgHandle = 4;

    /**
     * Clears the field "MsgHandle".
     *
     * The field will be set to its default value. The hasMsgHandle()
     * method will return false.
     */
    inline void clearMsgHandle();

    /**
     * Checks whether the field "MsgHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsgHandle()). Otherwise it will return false.
     */
    inline bool hasMsgHandle () const;

    /**
     * Returns the value of the member "MsgHandle".
     *
     * Handle to be mirrored back
     *
     * @return The value of the field "MsgHandle"
     */
    inline uint32 getMsgHandle () const;

    /**
     * Sets the value of the member "MsgHandle".
     *
     * Handle to be mirrored back
     *
     * @param MsgHandle The value which will be set
     */
    inline void setMsgHandle (uint32 MsgHandle_);

    // API of field "Action"

    static const int kAction = 5;

    /**
     * Clears the field "Action".
     *
     * The field will be set to its default value. The hasAction()
     * method will return false.
     */
    inline void clearAction();

    /**
     * Checks whether the field "Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAction()). Otherwise it will return false.
     */
    inline bool hasAction () const;

    /**
     * Returns the value of the member "Action".
     *
     * Inform about the ongoing action, allocate or deallocate
     *
     * @return The value of the field "Action"
     */
    inline ::masc_main_fi_types::T_e8_OnGoingAction getAction () const;

    /**
     * Sets the value of the member "Action".
     *
     * Inform about the ongoing action, allocate or deallocate
     *
     * @param Action The value which will be set
     */
    inline void setAction (::masc_main_fi_types::T_e8_OnGoingAction Action_);

    static const AmpDeviceAudioRouteStart &getDefaultInstance();

private:

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_Channel ();

    inline void clear_has_Channel ();

    inline void set_has_Source ();

    inline void clear_has_Source ();

    inline void set_has_AudProcAdev ();

    inline void clear_has_AudProcAdev ();

    inline void set_has_MsgHandle ();

    inline void clear_has_MsgHandle ();

    inline void set_has_Action ();

    inline void clear_has_Action ();

    uint32 _has_bits_[ (6 + 31) / 32];

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    ::masc_main_fi_types::T_e8_AudioChannel _Channel;

    ::masc_main_fi_types::T_e8_RouteNo _Source;

    ::std::string _AudProcAdev;

    uint32 _MsgHandle;

    ::masc_main_fi_types::T_e8_OnGoingAction _Action;

};

/**
 * The result message of the method "AmpDeviceAudioRoute"
 * command to set the audio route in amplifier device.
 * This information is used to set the amplifier device (presently this is the ADR) to the correct audio input.
 */
class AmpDeviceAudioRouteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AmpDeviceAudioRouteResult ();

    /**
     * Copy constructor
     */
    inline  AmpDeviceAudioRouteResult (const AmpDeviceAudioRouteResult &rhs);

    /**
     * All fields constructor
     */
    inline  AmpDeviceAudioRouteResult (::masc_main_fi_types::T_e8_AudioServiceStatus ServiceStatus_, uint32 MsgHandle_);

    /**
     * Destructor
     */
    inline virtual  ~AmpDeviceAudioRouteResult();

    /**
     * Assignment operator
     */
    inline AmpDeviceAudioRouteResult& operator = (const AmpDeviceAudioRouteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AmpDeviceAudioRouteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AmpDeviceAudioRouteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AmpDeviceAudioRouteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AmpDeviceAudioRouteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ServiceStatus"

    static const int kServiceStatus = 0;

    /**
     * Clears the field "ServiceStatus".
     *
     * The field will be set to its default value. The hasServiceStatus()
     * method will return false.
     */
    inline void clearServiceStatus();

    /**
     * Checks whether the field "ServiceStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceStatus()). Otherwise it will return false.
     */
    inline bool hasServiceStatus () const;

    /**
     * Returns the value of the member "ServiceStatus".
     *
     * Confirmation that the message is received.
     *
     * @return The value of the field "ServiceStatus"
     */
    inline ::masc_main_fi_types::T_e8_AudioServiceStatus getServiceStatus () const;

    /**
     * Sets the value of the member "ServiceStatus".
     *
     * Confirmation that the message is received.
     *
     * @param ServiceStatus The value which will be set
     */
    inline void setServiceStatus (::masc_main_fi_types::T_e8_AudioServiceStatus ServiceStatus_);

    // API of field "MsgHandle"

    static const int kMsgHandle = 1;

    /**
     * Clears the field "MsgHandle".
     *
     * The field will be set to its default value. The hasMsgHandle()
     * method will return false.
     */
    inline void clearMsgHandle();

    /**
     * Checks whether the field "MsgHandle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsgHandle()). Otherwise it will return false.
     */
    inline bool hasMsgHandle () const;

    /**
     * Returns the value of the member "MsgHandle".
     *
     * Handle to be mirrored back
     *
     * @return The value of the field "MsgHandle"
     */
    inline uint32 getMsgHandle () const;

    /**
     * Sets the value of the member "MsgHandle".
     *
     * Handle to be mirrored back
     *
     * @param MsgHandle The value which will be set
     */
    inline void setMsgHandle (uint32 MsgHandle_);

    static const AmpDeviceAudioRouteResult &getDefaultInstance();

private:

    inline void set_has_ServiceStatus ();

    inline void clear_has_ServiceStatus ();

    inline void set_has_MsgHandle ();

    inline void clear_has_MsgHandle ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudioServiceStatus _ServiceStatus;

    uint32 _MsgHandle;

};

/**
 * The start message of the method "AudioTestTone"
 * This method, former known as actuator test, controlles a test tone that plays on the selected loudspeaker.
 */
class AudioTestToneStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioTestToneStart ();

    /**
     * Copy constructor
     */
    inline  AudioTestToneStart (const AudioTestToneStart &rhs);

    /**
     * All fields constructor
     */
    inline  AudioTestToneStart (const ::masc_main_fi_types::T_b8_ChannelSelect& ChannelSelect_, uint32 Frequency_, const ::masc_main_fi_types::T_Volume& Volume_);

    /**
     * Destructor
     */
    inline virtual  ~AudioTestToneStart();

    /**
     * Assignment operator
     */
    inline AudioTestToneStart& operator = (const AudioTestToneStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioTestToneStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioTestToneStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioTestToneStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioTestToneStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ChannelSelect"

    static const int kChannelSelect = 0;

    /**
     * Clears the field "ChannelSelect".
     *
     * The field will be set to its default value. The hasChannelSelect()
     * method will return false.
     */
    inline void clearChannelSelect();

    /**
     * Checks whether the field "ChannelSelect" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelSelect()). Otherwise it will return false.
     */
    inline bool hasChannelSelect () const;

    /**
     * Returns the value of the member "ChannelSelect".
     *
     * Speaker on which the test tone is to be generated. If no speaker is set, the testone is stopped
     *
     * @return The value of the field "ChannelSelect"
     */
    inline const ::masc_main_fi_types::T_b8_ChannelSelect& getChannelSelect () const;

    /**
     * Retrieves the value of the field "ChannelSelect" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelSelect".
     */
    inline ::masc_main_fi_types::T_b8_ChannelSelect& getChannelSelectMutable ();

    /**
     * Sets the value of the member "ChannelSelect".
     *
     * Speaker on which the test tone is to be generated. If no speaker is set, the testone is stopped
     *
     * @param ChannelSelect The value which will be set
     */
    inline void setChannelSelect (const ::masc_main_fi_types::T_b8_ChannelSelect& ChannelSelect_);

    // API of field "Frequency"

    static const int kFrequency = 1;

    /**
     * Clears the field "Frequency".
     *
     * The field will be set to its default value. The hasFrequency()
     * method will return false.
     */
    inline void clearFrequency();

    /**
     * Checks whether the field "Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFrequency()). Otherwise it will return false.
     */
    inline bool hasFrequency () const;

    /**
     * Returns the value of the member "Frequency".
     *
     * Frequency of the test tone in Hz
     *
     * @return The value of the field "Frequency"
     */
    inline uint32 getFrequency () const;

    /**
     * Sets the value of the member "Frequency".
     *
     * Frequency of the test tone in Hz
     *
     * @param Frequency The value which will be set
     */
    inline void setFrequency (uint32 Frequency_);

    // API of field "Volume"

    static const int kVolume = 2;

    /**
     * Clears the field "Volume".
     *
     * The field will be set to its default value. The hasVolume()
     * method will return false.
     */
    inline void clearVolume();

    /**
     * Checks whether the field "Volume" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolume()). Otherwise it will return false.
     */
    inline bool hasVolume () const;

    /**
     * Returns the value of the member "Volume".
     *
     * If the meaning of "Volume" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Volume"
     */
    inline const ::masc_main_fi_types::T_Volume& getVolume () const;

    /**
     * Retrieves the value of the field "Volume" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Volume".
     */
    inline ::masc_main_fi_types::T_Volume& getVolumeMutable ();

    /**
     * Sets the value of the member "Volume".
     *
     * If the meaning of "Volume" isn't clear, then there should be a description here.
     *
     * @param Volume The value which will be set
     */
    inline void setVolume (const ::masc_main_fi_types::T_Volume& Volume_);

    static const AudioTestToneStart &getDefaultInstance();

private:

    inline void set_has_ChannelSelect ();

    inline void clear_has_ChannelSelect ();

    inline void set_has_Frequency ();

    inline void clear_has_Frequency ();

    inline void set_has_Volume ();

    inline void clear_has_Volume ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::masc_main_fi_types::T_b8_ChannelSelect _ChannelSelect;

    uint32 _Frequency;

    ::masc_main_fi_types::T_Volume _Volume;

};

/**
 * The result message of the method "AudioTestTone"
 * This method, former known as actuator test, controlles a test tone that plays on the selected loudspeaker.
 */
class AudioTestToneResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioTestToneResult ();

    /**
     * Copy constructor
     */
    inline  AudioTestToneResult (const AudioTestToneResult &rhs);

    /**
     * All fields constructor
     */
    inline  AudioTestToneResult (const ::masc_main_fi_types::T_b8_ChannelSelect& ChannelSelect_, ::masc_main_fi_types::T_e8_Aud_TestToneControl Status_);

    /**
     * Destructor
     */
    inline virtual  ~AudioTestToneResult();

    /**
     * Assignment operator
     */
    inline AudioTestToneResult& operator = (const AudioTestToneResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioTestToneResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioTestToneResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioTestToneResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioTestToneResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ChannelSelect"

    static const int kChannelSelect = 0;

    /**
     * Clears the field "ChannelSelect".
     *
     * The field will be set to its default value. The hasChannelSelect()
     * method will return false.
     */
    inline void clearChannelSelect();

    /**
     * Checks whether the field "ChannelSelect" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelSelect()). Otherwise it will return false.
     */
    inline bool hasChannelSelect () const;

    /**
     * Returns the value of the member "ChannelSelect".
     *
     * Speaker generating the test tone
     *
     * @return The value of the field "ChannelSelect"
     */
    inline const ::masc_main_fi_types::T_b8_ChannelSelect& getChannelSelect () const;

    /**
     * Retrieves the value of the field "ChannelSelect" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelSelect".
     */
    inline ::masc_main_fi_types::T_b8_ChannelSelect& getChannelSelectMutable ();

    /**
     * Sets the value of the member "ChannelSelect".
     *
     * Speaker generating the test tone
     *
     * @param ChannelSelect The value which will be set
     */
    inline void setChannelSelect (const ::masc_main_fi_types::T_b8_ChannelSelect& ChannelSelect_);

    // API of field "Status"

    static const int kStatus = 1;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Test tone status ON or OFF
     *
     * @return The value of the field "Status"
     */
    inline ::masc_main_fi_types::T_e8_Aud_TestToneControl getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Test tone status ON or OFF
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::masc_main_fi_types::T_e8_Aud_TestToneControl Status_);

    static const AudioTestToneResult &getDefaultInstance();

private:

    inline void set_has_ChannelSelect ();

    inline void clear_has_ChannelSelect ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::masc_main_fi_types::T_b8_ChannelSelect _ChannelSelect;

    ::masc_main_fi_types::T_e8_Aud_TestToneControl _Status;

};

/**
 * The start message of the method "CueState"
 * This method, indicates if the FF/FR cue is in START state or STOP state
 */
class CueStateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CueStateStart ();

    /**
     * Copy constructor
     */
    inline  CueStateStart (const CueStateStart &rhs);

    /**
     * All fields constructor
     */
    inline  CueStateStart (::masc_main_fi_types::T_e8_State State_, ::mascf_aud_src_route_fi_types::T_e8_AudSource Source_);

    /**
     * Destructor
     */
    inline virtual  ~CueStateStart();

    /**
     * Assignment operator
     */
    inline CueStateStart& operator = (const CueStateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CueStateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CueStateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CueStateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CueStateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "State"

    static const int kState = 0;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * Cue is in Start state or Stop State
     *
     * @return The value of the field "State"
     */
    inline ::masc_main_fi_types::T_e8_State getState () const;

    /**
     * Sets the value of the member "State".
     *
     * Cue is in Start state or Stop State
     *
     * @param State The value which will be set
     */
    inline void setState (::masc_main_fi_types::T_e8_State State_);

    // API of field "Source"

    static const int kSource = 1;

    /**
     * Clears the field "Source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "Source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "Source".
     *
     * actual Active source.
     *
     * @return The value of the field "Source"
     */
    inline ::mascf_aud_src_route_fi_types::T_e8_AudSource getSource () const;

    /**
     * Sets the value of the member "Source".
     *
     * actual Active source.
     *
     * @param Source The value which will be set
     */
    inline void setSource (::mascf_aud_src_route_fi_types::T_e8_AudSource Source_);

    static const CueStateStart &getDefaultInstance();

private:

    inline void set_has_State ();

    inline void clear_has_State ();

    inline void set_has_Source ();

    inline void clear_has_Source ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::masc_main_fi_types::T_e8_State _State;

    ::mascf_aud_src_route_fi_types::T_e8_AudSource _Source;

};

/**
 * The result message of the method "CueState"
 * This method, indicates if the FF/FR cue is in START state or STOP state
 */
class CueStateResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CueStateResult ();

    /**
     * Copy constructor
     */
    inline  CueStateResult (const CueStateResult &rhs);

    /**
     * All fields constructor
     */
    inline  CueStateResult (::masc_main_fi_types::T_e8_AudioServiceStatus ServiceStatus_);

    /**
     * Destructor
     */
    inline virtual  ~CueStateResult();

    /**
     * Assignment operator
     */
    inline CueStateResult& operator = (const CueStateResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CueStateResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CueStateResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CueStateResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CueStateResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ServiceStatus"

    static const int kServiceStatus = 0;

    /**
     * Clears the field "ServiceStatus".
     *
     * The field will be set to its default value. The hasServiceStatus()
     * method will return false.
     */
    inline void clearServiceStatus();

    /**
     * Checks whether the field "ServiceStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceStatus()). Otherwise it will return false.
     */
    inline bool hasServiceStatus () const;

    /**
     * Returns the value of the member "ServiceStatus".
     *
     * Confirmation that the message is received.
     *
     * @return The value of the field "ServiceStatus"
     */
    inline ::masc_main_fi_types::T_e8_AudioServiceStatus getServiceStatus () const;

    /**
     * Sets the value of the member "ServiceStatus".
     *
     * Confirmation that the message is received.
     *
     * @param ServiceStatus The value which will be set
     */
    inline void setServiceStatus (::masc_main_fi_types::T_e8_AudioServiceStatus ServiceStatus_);

    static const CueStateResult &getDefaultInstance();

private:

    inline void set_has_ServiceStatus ();

    inline void clear_has_ServiceStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudioServiceStatus _ServiceStatus;

};

/**
 * The start message of the method "SpeakerDiagnosisStart"
 * This method triggers the diagnosis functions of an internal amplifier via ADR3.
 */
class SpeakerDiagnosisStartStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpeakerDiagnosisStartStart ();

    /**
     * Copy constructor
     */
    inline  SpeakerDiagnosisStartStart (const SpeakerDiagnosisStartStart &rhs);

    /**
     * All fields constructor
     */
    inline  SpeakerDiagnosisStartStart (::masc_main_fi_types::T_e8_DiagMode DC_Mode_, ::masc_main_fi_types::T_e8_DiagMode AC_Mode_);

    /**
     * Destructor
     */
    inline virtual  ~SpeakerDiagnosisStartStart();

    /**
     * Assignment operator
     */
    inline SpeakerDiagnosisStartStart& operator = (const SpeakerDiagnosisStartStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeakerDiagnosisStartStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeakerDiagnosisStartStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeakerDiagnosisStartStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeakerDiagnosisStartStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DC_Mode"

    static const int kDC_Mode = 0;

    /**
     * Clears the field "DC_Mode".
     *
     * The field will be set to its default value. The hasDC_Mode()
     * method will return false.
     */
    inline void clearDC_Mode();

    /**
     * Checks whether the field "DC_Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDC_Mode()). Otherwise it will return false.
     */
    inline bool hasDC_Mode () const;

    /**
     * Returns the value of the member "DC_Mode".
     *
     * Mode of DC diagnostics (woofer): [Off, unqualified, qualified, continous]
     *
     * @return The value of the field "DC_Mode"
     */
    inline ::masc_main_fi_types::T_e8_DiagMode getDC_Mode () const;

    /**
     * Sets the value of the member "DC_Mode".
     *
     * Mode of DC diagnostics (woofer): [Off, unqualified, qualified, continous]
     *
     * @param DC_Mode The value which will be set
     */
    inline void setDC_Mode (::masc_main_fi_types::T_e8_DiagMode DC_Mode_);

    // API of field "AC_Mode"

    static const int kAC_Mode = 1;

    /**
     * Clears the field "AC_Mode".
     *
     * The field will be set to its default value. The hasAC_Mode()
     * method will return false.
     */
    inline void clearAC_Mode();

    /**
     * Checks whether the field "AC_Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAC_Mode()). Otherwise it will return false.
     */
    inline bool hasAC_Mode () const;

    /**
     * Returns the value of the member "AC_Mode".
     *
     * Mode of AC diagnostics (tweeter): [Off, unqualified, qualified, continous]
     *
     * @return The value of the field "AC_Mode"
     */
    inline ::masc_main_fi_types::T_e8_DiagMode getAC_Mode () const;

    /**
     * Sets the value of the member "AC_Mode".
     *
     * Mode of AC diagnostics (tweeter): [Off, unqualified, qualified, continous]
     *
     * @param AC_Mode The value which will be set
     */
    inline void setAC_Mode (::masc_main_fi_types::T_e8_DiagMode AC_Mode_);

    static const SpeakerDiagnosisStartStart &getDefaultInstance();

private:

    inline void set_has_DC_Mode ();

    inline void clear_has_DC_Mode ();

    inline void set_has_AC_Mode ();

    inline void clear_has_AC_Mode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::masc_main_fi_types::T_e8_DiagMode _DC_Mode;

    ::masc_main_fi_types::T_e8_DiagMode _AC_Mode;

};

/**
 * The result message of the method "SpeakerDiagnosisStart"
 * This method triggers the diagnosis functions of an internal amplifier via ADR3.
 */
class SpeakerDiagnosisStartResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpeakerDiagnosisStartResult ();

    /**
     * Copy constructor
     */
    inline  SpeakerDiagnosisStartResult (const SpeakerDiagnosisStartResult &rhs);

    /**
     * All fields constructor
     */
    inline  SpeakerDiagnosisStartResult (::masc_main_fi_types::T_e8_DiagState Status_);

    /**
     * Destructor
     */
    inline virtual  ~SpeakerDiagnosisStartResult();

    /**
     * Assignment operator
     */
    inline SpeakerDiagnosisStartResult& operator = (const SpeakerDiagnosisStartResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeakerDiagnosisStartResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeakerDiagnosisStartResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeakerDiagnosisStartResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeakerDiagnosisStartResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Diagnosis status: [OFF, DC_STARTED, AC_STARTED]. DC diagnosis is always started first.
     *
     * @return The value of the field "Status"
     */
    inline ::masc_main_fi_types::T_e8_DiagState getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Diagnosis status: [OFF, DC_STARTED, AC_STARTED]. DC diagnosis is always started first.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::masc_main_fi_types::T_e8_DiagState Status_);

    static const SpeakerDiagnosisStartResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_DiagState _Status;

};

/**
 * The start message of the method "SystemMute"
 * With this method a requester can gives a system mute request to the audio management. Same method is used to release the request.
 *
 * The RUN Events are specially conceived for drives, to indicate the starting of a Demute. If audio playback is stoped an restarted the middle of a track nothing from the track should be left out, but there should also be a soft fade in. That means the drive must start playing only when the Demute begins.
 * This treatment is planned only for the Demute. There is no RUN Acknowledge for a Mute!
 *
 * The time between demute-request and start of the command is unspecified, as demute dependent on all Requesters.#xD#xA
 * Keep always in mind as a Design-Rule:
 * The generation of Acknowledges or start of additonal actions should not depend on Methode Result of a demute.
 */
class SystemMuteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemMuteStart ();

    /**
     * Copy constructor
     */
    inline  SystemMuteStart (const SystemMuteStart &rhs);

    /**
     * All fields constructor
     */
    inline  SystemMuteStart (::mascf_aud_src_route_fi_types::T_e8_MuteRequester Requester_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::mascf_aud_src_route_fi_types::T_e8MuteAction State_, const ::mascf_aud_src_route_fi_types::T_b32MuteReason& Reason_);

    /**
     * Destructor
     */
    inline virtual  ~SystemMuteStart();

    /**
     * Assignment operator
     */
    inline SystemMuteStart& operator = (const SystemMuteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemMuteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemMuteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemMuteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemMuteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Requester"

    static const int kRequester = 0;

    /**
     * Clears the field "Requester".
     *
     * The field will be set to its default value. The hasRequester()
     * method will return false.
     */
    inline void clearRequester();

    /**
     * Checks whether the field "Requester" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequester()). Otherwise it will return false.
     */
    inline bool hasRequester () const;

    /**
     * Returns the value of the member "Requester".
     *
     * Gives the Requester, a new mute state is requested for
     *
     * @return The value of the field "Requester"
     */
    inline ::mascf_aud_src_route_fi_types::T_e8_MuteRequester getRequester () const;

    /**
     * Sets the value of the member "Requester".
     *
     * Gives the Requester, a new mute state is requested for
     *
     * @param Requester The value which will be set
     */
    inline void setRequester (::mascf_aud_src_route_fi_types::T_e8_MuteRequester Requester_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "State"

    static const int kState = 2;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * Give the new action of the request. With ON a mute is requested, with OFF
     * a Demute is requested
     *
     * @return The value of the field "State"
     */
    inline ::mascf_aud_src_route_fi_types::T_e8MuteAction getState () const;

    /**
     * Sets the value of the member "State".
     *
     * Give the new action of the request. With ON a mute is requested, with OFF
     * a Demute is requested
     *
     * @param State The value which will be set
     */
    inline void setState (::mascf_aud_src_route_fi_types::T_e8MuteAction State_);

    // API of field "Reason"

    static const int kReason = 3;

    /**
     * Clears the field "Reason".
     *
     * The field will be set to its default value. The hasReason()
     * method will return false.
     */
    inline void clearReason();

    /**
     * Checks whether the field "Reason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReason()). Otherwise it will return false.
     */
    inline bool hasReason () const;

    /**
     * Returns the value of the member "Reason".
     *
     * Give the reason of a mute request this parameter can be used for controlling
     * the mute ramp.
     *
     * @return The value of the field "Reason"
     */
    inline const ::mascf_aud_src_route_fi_types::T_b32MuteReason& getReason () const;

    /**
     * Retrieves the value of the field "Reason" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Reason".
     */
    inline ::mascf_aud_src_route_fi_types::T_b32MuteReason& getReasonMutable ();

    /**
     * Sets the value of the member "Reason".
     *
     * Give the reason of a mute request this parameter can be used for controlling
     * the mute ramp.
     *
     * @param Reason The value which will be set
     */
    inline void setReason (const ::mascf_aud_src_route_fi_types::T_b32MuteReason& Reason_);

    static const SystemMuteStart &getDefaultInstance();

private:

    inline void set_has_Requester ();

    inline void clear_has_Requester ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_State ();

    inline void clear_has_State ();

    inline void set_has_Reason ();

    inline void clear_has_Reason ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::mascf_aud_src_route_fi_types::T_e8_MuteRequester _Requester;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    ::mascf_aud_src_route_fi_types::T_e8MuteAction _State;

    ::mascf_aud_src_route_fi_types::T_b32MuteReason _Reason;

};

/**
 * The result message of the method "SystemMute"
 * With this method a requester can gives a system mute request to the audio management. Same method is used to release the request.
 *
 * The RUN Events are specially conceived for drives, to indicate the starting of a Demute. If audio playback is stoped an restarted the middle of a track nothing from the track should be left out, but there should also be a soft fade in. That means the drive must start playing only when the Demute begins.
 * This treatment is planned only for the Demute. There is no RUN Acknowledge for a Mute!
 *
 * The time between demute-request and start of the command is unspecified, as demute dependent on all Requesters.#xD#xA
 * Keep always in mind as a Design-Rule:
 * The generation of Acknowledges or start of additonal actions should not depend on Methode Result of a demute.
 */
class SystemMuteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemMuteResult ();

    /**
     * Copy constructor
     */
    inline  SystemMuteResult (const SystemMuteResult &rhs);

    /**
     * All fields constructor
     */
    inline  SystemMuteResult (::mascf_aud_src_route_fi_types::T_e8_MuteRequester Requester_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::mascf_aud_src_route_fi_types::T_e8_MuteState State_);

    /**
     * Destructor
     */
    inline virtual  ~SystemMuteResult();

    /**
     * Assignment operator
     */
    inline SystemMuteResult& operator = (const SystemMuteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemMuteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemMuteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemMuteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemMuteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Requester"

    static const int kRequester = 0;

    /**
     * Clears the field "Requester".
     *
     * The field will be set to its default value. The hasRequester()
     * method will return false.
     */
    inline void clearRequester();

    /**
     * Checks whether the field "Requester" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequester()). Otherwise it will return false.
     */
    inline bool hasRequester () const;

    /**
     * Returns the value of the member "Requester".
     *
     * Gives the Requester, a new mute state is requested for
     *
     * @return The value of the field "Requester"
     */
    inline ::mascf_aud_src_route_fi_types::T_e8_MuteRequester getRequester () const;

    /**
     * Sets the value of the member "Requester".
     *
     * Gives the Requester, a new mute state is requested for
     *
     * @param Requester The value which will be set
     */
    inline void setRequester (::mascf_aud_src_route_fi_types::T_e8_MuteRequester Requester_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "State"

    static const int kState = 2;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * Give the new action of the request. with ON a mute is requested, with OFF
     * a Demute is requested
     *
     * @return The value of the field "State"
     */
    inline ::mascf_aud_src_route_fi_types::T_e8_MuteState getState () const;

    /**
     * Sets the value of the member "State".
     *
     * Give the new action of the request. with ON a mute is requested, with OFF
     * a Demute is requested
     *
     * @param State The value which will be set
     */
    inline void setState (::mascf_aud_src_route_fi_types::T_e8_MuteState State_);

    static const SystemMuteResult &getDefaultInstance();

private:

    inline void set_has_Requester ();

    inline void clear_has_Requester ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_State ();

    inline void clear_has_State ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::mascf_aud_src_route_fi_types::T_e8_MuteRequester _Requester;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    ::mascf_aud_src_route_fi_types::T_e8_MuteState _State;

};

/**
 * The start message of the method "ADAS_SettingSound"
 * Start playing a ADAS setting sound
 */
class ADAS_SettingSoundStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ADAS_SettingSoundStart ();

    /**
     * Copy constructor
     */
    inline  ADAS_SettingSoundStart (const ADAS_SettingSoundStart &rhs);

    /**
     * All fields constructor
     */
    inline  ADAS_SettingSoundStart (::masc_main_fi_types::T_e8_ADAS_Setting_Sound SettingSound_);

    /**
     * Destructor
     */
    inline virtual  ~ADAS_SettingSoundStart();

    /**
     * Assignment operator
     */
    inline ADAS_SettingSoundStart& operator = (const ADAS_SettingSoundStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ADAS_SettingSoundStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ADAS_SettingSoundStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ADAS_SettingSoundStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ADAS_SettingSoundStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SettingSound"

    static const int kSettingSound = 0;

    /**
     * Clears the field "SettingSound".
     *
     * The field will be set to its default value. The hasSettingSound()
     * method will return false.
     */
    inline void clearSettingSound();

    /**
     * Checks whether the field "SettingSound" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSettingSound()). Otherwise it will return false.
     */
    inline bool hasSettingSound () const;

    /**
     * Returns the value of the member "SettingSound".
     *
     * kind of setting sound to be played
     *
     * @return The value of the field "SettingSound"
     */
    inline ::masc_main_fi_types::T_e8_ADAS_Setting_Sound getSettingSound () const;

    /**
     * Sets the value of the member "SettingSound".
     *
     * kind of setting sound to be played
     *
     * @param SettingSound The value which will be set
     */
    inline void setSettingSound (::masc_main_fi_types::T_e8_ADAS_Setting_Sound SettingSound_);

    static const ADAS_SettingSoundStart &getDefaultInstance();

private:

    inline void set_has_SettingSound ();

    inline void clear_has_SettingSound ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_ADAS_Setting_Sound _SettingSound;

};

/**
 * The result message of the method "ADAS_SettingSound"
 * Start playing a ADAS setting sound
 */
class ADAS_SettingSoundResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ADAS_SettingSoundResult ();

    /**
     * Copy constructor
     */
    inline  ADAS_SettingSoundResult (const ADAS_SettingSoundResult &rhs);

    /**
     * All fields constructor
     */
    inline  ADAS_SettingSoundResult (::masc_main_fi_types::T_e8_AudioServiceStatus ServiceStatus_);

    /**
     * Destructor
     */
    inline virtual  ~ADAS_SettingSoundResult();

    /**
     * Assignment operator
     */
    inline ADAS_SettingSoundResult& operator = (const ADAS_SettingSoundResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ADAS_SettingSoundResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ADAS_SettingSoundResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ADAS_SettingSoundResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ADAS_SettingSoundResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ServiceStatus"

    static const int kServiceStatus = 0;

    /**
     * Clears the field "ServiceStatus".
     *
     * The field will be set to its default value. The hasServiceStatus()
     * method will return false.
     */
    inline void clearServiceStatus();

    /**
     * Checks whether the field "ServiceStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceStatus()). Otherwise it will return false.
     */
    inline bool hasServiceStatus () const;

    /**
     * Returns the value of the member "ServiceStatus".
     *
     * Confirmation that the message is received in audio middleware component
     *
     * @return The value of the field "ServiceStatus"
     */
    inline ::masc_main_fi_types::T_e8_AudioServiceStatus getServiceStatus () const;

    /**
     * Sets the value of the member "ServiceStatus".
     *
     * Confirmation that the message is received in audio middleware component
     *
     * @param ServiceStatus The value which will be set
     */
    inline void setServiceStatus (::masc_main_fi_types::T_e8_AudioServiceStatus ServiceStatus_);

    static const ADAS_SettingSoundResult &getDefaultInstance();

private:

    inline void set_has_ServiceStatus ();

    inline void clear_has_ServiceStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::masc_main_fi_types::T_e8_AudioServiceStatus _ServiceStatus;

};

/**
 * The start message of the method "EntertainmentMute"
 * With this method a requester can gives a mute request to the external MCAN Bose Amplifier. Same method is used to release the request.
 *
 * The RUN Events are specially conceived for drives, to indicate the starting of a Demute. If audio playback is stoped an restarted the middle of a track nothing from the track should be left out, but there should also be a soft fade in. That means the drive must start playing only when the Demute begins.
 * This treatment is planned only for the Demute. There is no RUN Acknowledge for a Mute!
 *
 * The time between demute-request and start of the command is unspecified, as demute dependent on all Requesters.#xD#xA
 * Keep always in mind as a Design-Rule:
 * The generation of Acknowledges or start of additonal actions should not depend on Methode Result of a demute.
 */
class EntertainmentMuteStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EntertainmentMuteStart ();

    /**
     * Copy constructor
     */
    inline  EntertainmentMuteStart (const EntertainmentMuteStart &rhs);

    /**
     * All fields constructor
     */
    inline  EntertainmentMuteStart (::mascf_aud_src_route_fi_types::T_e8_MuteRequester Requester_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::mascf_aud_src_route_fi_types::T_e8MuteAction State_, const ::mascf_aud_src_route_fi_types::T_b32MuteReason& Reason_);

    /**
     * Destructor
     */
    inline virtual  ~EntertainmentMuteStart();

    /**
     * Assignment operator
     */
    inline EntertainmentMuteStart& operator = (const EntertainmentMuteStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EntertainmentMuteStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EntertainmentMuteStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EntertainmentMuteStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EntertainmentMuteStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Requester"

    static const int kRequester = 0;

    /**
     * Clears the field "Requester".
     *
     * The field will be set to its default value. The hasRequester()
     * method will return false.
     */
    inline void clearRequester();

    /**
     * Checks whether the field "Requester" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequester()). Otherwise it will return false.
     */
    inline bool hasRequester () const;

    /**
     * Returns the value of the member "Requester".
     *
     * Gives the Requester, a new mute state is requested for
     *
     * @return The value of the field "Requester"
     */
    inline ::mascf_aud_src_route_fi_types::T_e8_MuteRequester getRequester () const;

    /**
     * Sets the value of the member "Requester".
     *
     * Gives the Requester, a new mute state is requested for
     *
     * @param Requester The value which will be set
     */
    inline void setRequester (::mascf_aud_src_route_fi_types::T_e8_MuteRequester Requester_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "State"

    static const int kState = 2;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * Give the new action of the request. With ON a mute is requested, with OFF
     * a Demute is requested
     *
     * @return The value of the field "State"
     */
    inline ::mascf_aud_src_route_fi_types::T_e8MuteAction getState () const;

    /**
     * Sets the value of the member "State".
     *
     * Give the new action of the request. With ON a mute is requested, with OFF
     * a Demute is requested
     *
     * @param State The value which will be set
     */
    inline void setState (::mascf_aud_src_route_fi_types::T_e8MuteAction State_);

    // API of field "Reason"

    static const int kReason = 3;

    /**
     * Clears the field "Reason".
     *
     * The field will be set to its default value. The hasReason()
     * method will return false.
     */
    inline void clearReason();

    /**
     * Checks whether the field "Reason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReason()). Otherwise it will return false.
     */
    inline bool hasReason () const;

    /**
     * Returns the value of the member "Reason".
     *
     * Give the reason of a mute request this parameter can be used for controlling
     * the mute ramp.
     *
     * @return The value of the field "Reason"
     */
    inline const ::mascf_aud_src_route_fi_types::T_b32MuteReason& getReason () const;

    /**
     * Retrieves the value of the field "Reason" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Reason".
     */
    inline ::mascf_aud_src_route_fi_types::T_b32MuteReason& getReasonMutable ();

    /**
     * Sets the value of the member "Reason".
     *
     * Give the reason of a mute request this parameter can be used for controlling
     * the mute ramp.
     *
     * @param Reason The value which will be set
     */
    inline void setReason (const ::mascf_aud_src_route_fi_types::T_b32MuteReason& Reason_);

    static const EntertainmentMuteStart &getDefaultInstance();

private:

    inline void set_has_Requester ();

    inline void clear_has_Requester ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_State ();

    inline void clear_has_State ();

    inline void set_has_Reason ();

    inline void clear_has_Reason ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::mascf_aud_src_route_fi_types::T_e8_MuteRequester _Requester;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    ::mascf_aud_src_route_fi_types::T_e8MuteAction _State;

    ::mascf_aud_src_route_fi_types::T_b32MuteReason _Reason;

};

/**
 * The result message of the method "EntertainmentMute"
 * With this method a requester can gives a mute request to the external MCAN Bose Amplifier. Same method is used to release the request.
 *
 * The RUN Events are specially conceived for drives, to indicate the starting of a Demute. If audio playback is stoped an restarted the middle of a track nothing from the track should be left out, but there should also be a soft fade in. That means the drive must start playing only when the Demute begins.
 * This treatment is planned only for the Demute. There is no RUN Acknowledge for a Mute!
 *
 * The time between demute-request and start of the command is unspecified, as demute dependent on all Requesters.#xD#xA
 * Keep always in mind as a Design-Rule:
 * The generation of Acknowledges or start of additonal actions should not depend on Methode Result of a demute.
 */
class EntertainmentMuteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EntertainmentMuteResult ();

    /**
     * Copy constructor
     */
    inline  EntertainmentMuteResult (const EntertainmentMuteResult &rhs);

    /**
     * All fields constructor
     */
    inline  EntertainmentMuteResult (::mascf_aud_src_route_fi_types::T_e8_MuteRequester Requester_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::mascf_aud_src_route_fi_types::T_e8_MuteState State_);

    /**
     * Destructor
     */
    inline virtual  ~EntertainmentMuteResult();

    /**
     * Assignment operator
     */
    inline EntertainmentMuteResult& operator = (const EntertainmentMuteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EntertainmentMuteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EntertainmentMuteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EntertainmentMuteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EntertainmentMuteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Requester"

    static const int kRequester = 0;

    /**
     * Clears the field "Requester".
     *
     * The field will be set to its default value. The hasRequester()
     * method will return false.
     */
    inline void clearRequester();

    /**
     * Checks whether the field "Requester" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequester()). Otherwise it will return false.
     */
    inline bool hasRequester () const;

    /**
     * Returns the value of the member "Requester".
     *
     * Gives the Requester, a new mute state is requested for
     *
     * @return The value of the field "Requester"
     */
    inline ::mascf_aud_src_route_fi_types::T_e8_MuteRequester getRequester () const;

    /**
     * Sets the value of the member "Requester".
     *
     * Gives the Requester, a new mute state is requested for
     *
     * @param Requester The value which will be set
     */
    inline void setRequester (::mascf_aud_src_route_fi_types::T_e8_MuteRequester Requester_);

    // API of field "Resource"

    static const int kResource = 1;

    /**
     * Clears the field "Resource".
     *
     * The field will be set to its default value. The hasResource()
     * method will return false.
     */
    inline void clearResource();

    /**
     * Checks whether the field "Resource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResource()). Otherwise it will return false.
     */
    inline bool hasResource () const;

    /**
     * Returns the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @return The value of the field "Resource"
     */
    inline ::masc_main_fi_types::T_e8_ResourceNo getResource () const;

    /**
     * Sets the value of the member "Resource".
     *
     * Related resource. Default setting is loudspeaker. Other destinations are not
     * supported at the moment
     *
     * @param Resource The value which will be set
     */
    inline void setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_);

    // API of field "State"

    static const int kState = 2;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * Give the new action of the request. with ON a mute is requested, with OFF
     * a Demute is requested
     *
     * @return The value of the field "State"
     */
    inline ::mascf_aud_src_route_fi_types::T_e8_MuteState getState () const;

    /**
     * Sets the value of the member "State".
     *
     * Give the new action of the request. with ON a mute is requested, with OFF
     * a Demute is requested
     *
     * @param State The value which will be set
     */
    inline void setState (::mascf_aud_src_route_fi_types::T_e8_MuteState State_);

    static const EntertainmentMuteResult &getDefaultInstance();

private:

    inline void set_has_Requester ();

    inline void clear_has_Requester ();

    inline void set_has_Resource ();

    inline void clear_has_Resource ();

    inline void set_has_State ();

    inline void clear_has_State ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::mascf_aud_src_route_fi_types::T_e8_MuteRequester _Requester;

    ::masc_main_fi_types::T_e8_ResourceNo _Resource;

    ::mascf_aud_src_route_fi_types::T_e8_MuteState _State;

};

inline  VolumeModeStatusStatus::VolumeModeStatusStatus ()  :
    _VolumeMode (::masc_main_fi_types::T_e8_VolumeMode__AUDIO_VOLMODE_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Channel (::masc_main_fi_types::T_e8_AudioChannel__AUDIO_CHANNEL_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VolumeModeStatusStatus::VolumeModeStatusStatus (const VolumeModeStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _VolumeMode (::masc_main_fi_types::T_e8_VolumeMode__AUDIO_VOLMODE_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Channel (::masc_main_fi_types::T_e8_AudioChannel__AUDIO_CHANNEL_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VolumeModeStatusStatus::VolumeModeStatusStatus (::masc_main_fi_types::T_e8_VolumeMode VolumeMode_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::masc_main_fi_types::T_e8_AudioChannel Channel_)  :
    _VolumeMode (VolumeMode_),
    _Resource (Resource_),
    _Channel (Channel_)
{
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_VolumeMode_IsValid(VolumeMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", VolumeMode_, "T_e8_VolumeMode", "VolumeMode", "VolumeModeStatusStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "VolumeModeStatusStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioChannel_IsValid(Channel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Channel_, "T_e8_AudioChannel", "Channel", "VolumeModeStatusStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VolumeModeStatusStatus::~VolumeModeStatusStatus() {
}

inline VolumeModeStatusStatus& VolumeModeStatusStatus::operator = (const VolumeModeStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVolumeMode()) {
            setVolumeMode(rhs.getVolumeMode());
        } else {
            clearVolumeMode();
        }
        if (rhs.hasResource()) {
            setResource(rhs.getResource());
        } else {
            clearResource();
        }
        if (rhs.hasChannel()) {
            setChannel(rhs.getChannel());
        } else {
            clearChannel();
        }
    }
    return *this;
}

inline bool VolumeModeStatusStatus::operator == (const VolumeModeStatusStatus& rhs) const {
    return (((!hasVolumeMode() && !rhs.hasVolumeMode()) || getVolumeMode() == rhs.getVolumeMode()) &&
        ((!hasResource() && !rhs.hasResource()) || getResource() == rhs.getResource()) &&
        ((!hasChannel() && !rhs.hasChannel()) || getChannel() == rhs.getChannel()));
}

inline bool VolumeModeStatusStatus::operator != (const VolumeModeStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool VolumeModeStatusStatus::operator < (const VolumeModeStatusStatus& rhs) const {
    if (hasVolumeMode() || rhs.hasVolumeMode()) {
        if ((uint32)getVolumeMode() < (uint32)rhs.getVolumeMode()) return true;
        if ((uint32)getVolumeMode() > (uint32)rhs.getVolumeMode()) return false;
    }
    if (hasResource() || rhs.hasResource()) {
        if ((uint32)getResource() < (uint32)rhs.getResource()) return true;
        if ((uint32)getResource() > (uint32)rhs.getResource()) return false;
    }
    if (hasChannel() || rhs.hasChannel()) {
        if ((uint32)getChannel() < (uint32)rhs.getChannel()) return true;
        if ((uint32)getChannel() > (uint32)rhs.getChannel()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VolumeModeStatusStatus::clone() {
    return new VolumeModeStatusStatus(*this);
}

inline bool VolumeModeStatusStatus::operator > (const VolumeModeStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VolumeModeStatusStatus::clear() {
    clearVolumeMode();
    clearResource();
    clearChannel();
}

inline void VolumeModeStatusStatus::clearVolumeMode() {
    if (hasVolumeMode()) {
         clear_has_VolumeMode();
        _VolumeMode = ::masc_main_fi_types::T_e8_VolumeMode__AUDIO_VOLMODE_NOT_DEF;
     }
}

inline bool VolumeModeStatusStatus::hasVolumeMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::masc_main_fi_types::T_e8_VolumeMode VolumeModeStatusStatus::getVolumeMode () const {
    return _VolumeMode;
}

inline void VolumeModeStatusStatus::setVolumeMode (::masc_main_fi_types::T_e8_VolumeMode VolumeMode_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_VolumeMode_IsValid(VolumeMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", VolumeMode_, "T_e8_VolumeMode", "VolumeMode", "VolumeModeStatusStatus");
    }
    #endif
    set_has_VolumeMode();
    this->_VolumeMode = VolumeMode_;
}

inline void VolumeModeStatusStatus::clearResource() {
    if (hasResource()) {
         clear_has_Resource();
        _Resource = ::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF;
     }
}

inline bool VolumeModeStatusStatus::hasResource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::masc_main_fi_types::T_e8_ResourceNo VolumeModeStatusStatus::getResource () const {
    return _Resource;
}

inline void VolumeModeStatusStatus::setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "VolumeModeStatusStatus");
    }
    #endif
    set_has_Resource();
    this->_Resource = Resource_;
}

inline void VolumeModeStatusStatus::clearChannel() {
    if (hasChannel()) {
         clear_has_Channel();
        _Channel = ::masc_main_fi_types::T_e8_AudioChannel__AUDIO_CHANNEL_NOT_DEF;
     }
}

inline bool VolumeModeStatusStatus::hasChannel () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::masc_main_fi_types::T_e8_AudioChannel VolumeModeStatusStatus::getChannel () const {
    return _Channel;
}

inline void VolumeModeStatusStatus::setChannel (::masc_main_fi_types::T_e8_AudioChannel Channel_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioChannel_IsValid(Channel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Channel_, "T_e8_AudioChannel", "Channel", "VolumeModeStatusStatus");
    }
    #endif
    set_has_Channel();
    this->_Channel = Channel_;
}

inline void VolumeModeStatusStatus::set_has_VolumeMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void VolumeModeStatusStatus::clear_has_VolumeMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void VolumeModeStatusStatus::set_has_Resource () {
    _has_bits_[0] |= 1u << 1;
}

inline void VolumeModeStatusStatus::clear_has_Resource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void VolumeModeStatusStatus::set_has_Channel () {
    _has_bits_[0] |= 1u << 2;
}

inline void VolumeModeStatusStatus::clear_has_Channel () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  VolumeStatus::VolumeStatus ()  :
    _VolumeMode (::masc_main_fi_types::T_e8_VolumeMode__AUDIO_VOLMODE_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Channel (::masc_main_fi_types::T_e8_AudioChannel__AUDIO_CHANNEL_NOT_DEF),
    _Volume (0u),
    _Source (::mascf_aud_src_route_fi_types::T_e8_AudSource__NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VolumeStatus::VolumeStatus (const VolumeStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _VolumeMode (::masc_main_fi_types::T_e8_VolumeMode__AUDIO_VOLMODE_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Channel (::masc_main_fi_types::T_e8_AudioChannel__AUDIO_CHANNEL_NOT_DEF),
    _Volume (0u),
    _Source (::mascf_aud_src_route_fi_types::T_e8_AudSource__NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VolumeStatus::VolumeStatus (::masc_main_fi_types::T_e8_VolumeMode VolumeMode_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::masc_main_fi_types::T_e8_AudioChannel Channel_, uint8 Volume_, ::mascf_aud_src_route_fi_types::T_e8_AudSource Source_)  :
    _VolumeMode (VolumeMode_),
    _Resource (Resource_),
    _Channel (Channel_),
    _Volume (Volume_),
    _Source (Source_)
{
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_VolumeMode_IsValid(VolumeMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", VolumeMode_, "T_e8_VolumeMode", "VolumeMode", "VolumeStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "VolumeStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioChannel_IsValid(Channel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Channel_, "T_e8_AudioChannel", "Channel", "VolumeStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::mascf_aud_src_route_fi_types::T_e8_AudSource_IsValid(Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Source_, "T_e8_AudSource", "Source", "VolumeStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VolumeStatus::~VolumeStatus() {
}

inline VolumeStatus& VolumeStatus::operator = (const VolumeStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVolumeMode()) {
            setVolumeMode(rhs.getVolumeMode());
        } else {
            clearVolumeMode();
        }
        if (rhs.hasResource()) {
            setResource(rhs.getResource());
        } else {
            clearResource();
        }
        if (rhs.hasChannel()) {
            setChannel(rhs.getChannel());
        } else {
            clearChannel();
        }
        if (rhs.hasVolume()) {
            setVolume(rhs.getVolume());
        } else {
            clearVolume();
        }
        if (rhs.hasSource()) {
            setSource(rhs.getSource());
        } else {
            clearSource();
        }
    }
    return *this;
}

inline bool VolumeStatus::operator == (const VolumeStatus& rhs) const {
    return (((!hasVolumeMode() && !rhs.hasVolumeMode()) || getVolumeMode() == rhs.getVolumeMode()) &&
        ((!hasResource() && !rhs.hasResource()) || getResource() == rhs.getResource()) &&
        ((!hasChannel() && !rhs.hasChannel()) || getChannel() == rhs.getChannel()) &&
        ((!hasVolume() && !rhs.hasVolume()) || getVolume() == rhs.getVolume()) &&
        ((!hasSource() && !rhs.hasSource()) || getSource() == rhs.getSource()));
}

inline bool VolumeStatus::operator != (const VolumeStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool VolumeStatus::operator < (const VolumeStatus& rhs) const {
    if (hasVolumeMode() || rhs.hasVolumeMode()) {
        if ((uint32)getVolumeMode() < (uint32)rhs.getVolumeMode()) return true;
        if ((uint32)getVolumeMode() > (uint32)rhs.getVolumeMode()) return false;
    }
    if (hasResource() || rhs.hasResource()) {
        if ((uint32)getResource() < (uint32)rhs.getResource()) return true;
        if ((uint32)getResource() > (uint32)rhs.getResource()) return false;
    }
    if (hasChannel() || rhs.hasChannel()) {
        if ((uint32)getChannel() < (uint32)rhs.getChannel()) return true;
        if ((uint32)getChannel() > (uint32)rhs.getChannel()) return false;
    }
    if (hasVolume() || rhs.hasVolume()) {
        if (getVolume() < rhs.getVolume()) return true;
        if (getVolume() > rhs.getVolume()) return false;
    }
    if (hasSource() || rhs.hasSource()) {
        if ((uint32)getSource() < (uint32)rhs.getSource()) return true;
        if ((uint32)getSource() > (uint32)rhs.getSource()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VolumeStatus::clone() {
    return new VolumeStatus(*this);
}

inline bool VolumeStatus::operator > (const VolumeStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VolumeStatus::clear() {
    clearVolumeMode();
    clearResource();
    clearChannel();
    clearVolume();
    clearSource();
}

inline void VolumeStatus::clearVolumeMode() {
    if (hasVolumeMode()) {
         clear_has_VolumeMode();
        _VolumeMode = ::masc_main_fi_types::T_e8_VolumeMode__AUDIO_VOLMODE_NOT_DEF;
     }
}

inline bool VolumeStatus::hasVolumeMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::masc_main_fi_types::T_e8_VolumeMode VolumeStatus::getVolumeMode () const {
    return _VolumeMode;
}

inline void VolumeStatus::setVolumeMode (::masc_main_fi_types::T_e8_VolumeMode VolumeMode_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_VolumeMode_IsValid(VolumeMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", VolumeMode_, "T_e8_VolumeMode", "VolumeMode", "VolumeStatus");
    }
    #endif
    set_has_VolumeMode();
    this->_VolumeMode = VolumeMode_;
}

inline void VolumeStatus::clearResource() {
    if (hasResource()) {
         clear_has_Resource();
        _Resource = ::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF;
     }
}

inline bool VolumeStatus::hasResource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::masc_main_fi_types::T_e8_ResourceNo VolumeStatus::getResource () const {
    return _Resource;
}

inline void VolumeStatus::setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "VolumeStatus");
    }
    #endif
    set_has_Resource();
    this->_Resource = Resource_;
}

inline void VolumeStatus::clearChannel() {
    if (hasChannel()) {
         clear_has_Channel();
        _Channel = ::masc_main_fi_types::T_e8_AudioChannel__AUDIO_CHANNEL_NOT_DEF;
     }
}

inline bool VolumeStatus::hasChannel () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::masc_main_fi_types::T_e8_AudioChannel VolumeStatus::getChannel () const {
    return _Channel;
}

inline void VolumeStatus::setChannel (::masc_main_fi_types::T_e8_AudioChannel Channel_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioChannel_IsValid(Channel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Channel_, "T_e8_AudioChannel", "Channel", "VolumeStatus");
    }
    #endif
    set_has_Channel();
    this->_Channel = Channel_;
}

inline void VolumeStatus::clearVolume() {
    if (hasVolume()) {
         clear_has_Volume();
        _Volume = 0u;
     }
}

inline bool VolumeStatus::hasVolume () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 VolumeStatus::getVolume () const {
    return _Volume;
}

inline void VolumeStatus::setVolume (uint8 Volume_) {
    set_has_Volume();
    this->_Volume = Volume_;
}

inline void VolumeStatus::clearSource() {
    if (hasSource()) {
         clear_has_Source();
        _Source = ::mascf_aud_src_route_fi_types::T_e8_AudSource__NONE;
     }
}

inline bool VolumeStatus::hasSource () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline ::mascf_aud_src_route_fi_types::T_e8_AudSource VolumeStatus::getSource () const {
    return _Source;
}

inline void VolumeStatus::setSource (::mascf_aud_src_route_fi_types::T_e8_AudSource Source_) {
    #ifndef NDEBUG
    if (!(::mascf_aud_src_route_fi_types::T_e8_AudSource_IsValid(Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Source_, "T_e8_AudSource", "Source", "VolumeStatus");
    }
    #endif
    set_has_Source();
    this->_Source = Source_;
}

inline void VolumeStatus::set_has_VolumeMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void VolumeStatus::clear_has_VolumeMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void VolumeStatus::set_has_Resource () {
    _has_bits_[0] |= 1u << 1;
}

inline void VolumeStatus::clear_has_Resource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void VolumeStatus::set_has_Channel () {
    _has_bits_[0] |= 1u << 2;
}

inline void VolumeStatus::clear_has_Channel () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void VolumeStatus::set_has_Volume () {
    _has_bits_[0] |= 1u << 3;
}

inline void VolumeStatus::clear_has_Volume () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void VolumeStatus::set_has_Source () {
    _has_bits_[0] |= 1u << 4;
}

inline void VolumeStatus::clear_has_Source () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  VolumeSet::VolumeSet ()  :
    _VolumeType (::masc_main_fi_types::T_e8_AudioVolumeType__AUDIO_VAL_TYPE_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Volume (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VolumeSet::VolumeSet (const VolumeSet &rhs)  :
    ::asf::core::Payload(rhs),
    _VolumeType (::masc_main_fi_types::T_e8_AudioVolumeType__AUDIO_VAL_TYPE_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Volume (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VolumeSet::VolumeSet (::masc_main_fi_types::T_e8_AudioVolumeType VolumeType_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, uint8 Volume_)  :
    _VolumeType (VolumeType_),
    _Resource (Resource_),
    _Volume (Volume_)
{
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioVolumeType_IsValid(VolumeType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", VolumeType_, "T_e8_AudioVolumeType", "VolumeType", "VolumeSet");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "VolumeSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VolumeSet::~VolumeSet() {
}

inline VolumeSet& VolumeSet::operator = (const VolumeSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVolumeType()) {
            setVolumeType(rhs.getVolumeType());
        } else {
            clearVolumeType();
        }
        if (rhs.hasResource()) {
            setResource(rhs.getResource());
        } else {
            clearResource();
        }
        if (rhs.hasVolume()) {
            setVolume(rhs.getVolume());
        } else {
            clearVolume();
        }
    }
    return *this;
}

inline bool VolumeSet::operator == (const VolumeSet& rhs) const {
    return (((!hasVolumeType() && !rhs.hasVolumeType()) || getVolumeType() == rhs.getVolumeType()) &&
        ((!hasResource() && !rhs.hasResource()) || getResource() == rhs.getResource()) &&
        ((!hasVolume() && !rhs.hasVolume()) || getVolume() == rhs.getVolume()));
}

inline bool VolumeSet::operator != (const VolumeSet& rhs) const {
    return ! (*this == rhs);
}

inline bool VolumeSet::operator < (const VolumeSet& rhs) const {
    if (hasVolumeType() || rhs.hasVolumeType()) {
        if ((uint32)getVolumeType() < (uint32)rhs.getVolumeType()) return true;
        if ((uint32)getVolumeType() > (uint32)rhs.getVolumeType()) return false;
    }
    if (hasResource() || rhs.hasResource()) {
        if ((uint32)getResource() < (uint32)rhs.getResource()) return true;
        if ((uint32)getResource() > (uint32)rhs.getResource()) return false;
    }
    if (hasVolume() || rhs.hasVolume()) {
        if (getVolume() < rhs.getVolume()) return true;
        if (getVolume() > rhs.getVolume()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VolumeSet::clone() {
    return new VolumeSet(*this);
}

inline bool VolumeSet::operator > (const VolumeSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VolumeSet::clear() {
    clearVolumeType();
    clearResource();
    clearVolume();
}

inline void VolumeSet::clearVolumeType() {
    if (hasVolumeType()) {
         clear_has_VolumeType();
        _VolumeType = ::masc_main_fi_types::T_e8_AudioVolumeType__AUDIO_VAL_TYPE_NOT_DEF;
     }
}

inline bool VolumeSet::hasVolumeType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::masc_main_fi_types::T_e8_AudioVolumeType VolumeSet::getVolumeType () const {
    return _VolumeType;
}

inline void VolumeSet::setVolumeType (::masc_main_fi_types::T_e8_AudioVolumeType VolumeType_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioVolumeType_IsValid(VolumeType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", VolumeType_, "T_e8_AudioVolumeType", "VolumeType", "VolumeSet");
    }
    #endif
    set_has_VolumeType();
    this->_VolumeType = VolumeType_;
}

inline void VolumeSet::clearResource() {
    if (hasResource()) {
         clear_has_Resource();
        _Resource = ::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF;
     }
}

inline bool VolumeSet::hasResource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::masc_main_fi_types::T_e8_ResourceNo VolumeSet::getResource () const {
    return _Resource;
}

inline void VolumeSet::setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "VolumeSet");
    }
    #endif
    set_has_Resource();
    this->_Resource = Resource_;
}

inline void VolumeSet::clearVolume() {
    if (hasVolume()) {
         clear_has_Volume();
        _Volume = 0u;
     }
}

inline bool VolumeSet::hasVolume () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 VolumeSet::getVolume () const {
    return _Volume;
}

inline void VolumeSet::setVolume (uint8 Volume_) {
    set_has_Volume();
    this->_Volume = Volume_;
}

inline void VolumeSet::set_has_VolumeType () {
    _has_bits_[0] |= 1u << 0;
}

inline void VolumeSet::clear_has_VolumeType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void VolumeSet::set_has_Resource () {
    _has_bits_[0] |= 1u << 1;
}

inline void VolumeSet::clear_has_Resource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void VolumeSet::set_has_Volume () {
    _has_bits_[0] |= 1u << 2;
}

inline void VolumeSet::clear_has_Volume () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  BeepStatusStatus::BeepStatusStatus ()  :
    _BeepStatus (::masc_main_fi_types::T_e8_AudioBeepStatus__AUDIO_BEEP_STATUS_NOT_DEF),
    _u32Token (0u),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BeepStatusStatus::BeepStatusStatus (const BeepStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _BeepStatus (::masc_main_fi_types::T_e8_AudioBeepStatus__AUDIO_BEEP_STATUS_NOT_DEF),
    _u32Token (0u),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BeepStatusStatus::BeepStatusStatus (::masc_main_fi_types::T_e8_AudioBeepStatus BeepStatus_, uint32 u32Token_, ::masc_main_fi_types::T_e8_ResourceNo Resource_)  :
    _BeepStatus (BeepStatus_),
    _u32Token (u32Token_),
    _Resource (Resource_)
{
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioBeepStatus_IsValid(BeepStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", BeepStatus_, "T_e8_AudioBeepStatus", "BeepStatus", "BeepStatusStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "BeepStatusStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BeepStatusStatus::~BeepStatusStatus() {
}

inline BeepStatusStatus& BeepStatusStatus::operator = (const BeepStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBeepStatus()) {
            setBeepStatus(rhs.getBeepStatus());
        } else {
            clearBeepStatus();
        }
        if (rhs.hasU32Token()) {
            setU32Token(rhs.getU32Token());
        } else {
            clearU32Token();
        }
        if (rhs.hasResource()) {
            setResource(rhs.getResource());
        } else {
            clearResource();
        }
    }
    return *this;
}

inline bool BeepStatusStatus::operator == (const BeepStatusStatus& rhs) const {
    return (((!hasBeepStatus() && !rhs.hasBeepStatus()) || getBeepStatus() == rhs.getBeepStatus()) &&
        ((!hasU32Token() && !rhs.hasU32Token()) || getU32Token() == rhs.getU32Token()) &&
        ((!hasResource() && !rhs.hasResource()) || getResource() == rhs.getResource()));
}

inline bool BeepStatusStatus::operator != (const BeepStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool BeepStatusStatus::operator < (const BeepStatusStatus& rhs) const {
    if (hasBeepStatus() || rhs.hasBeepStatus()) {
        if ((uint32)getBeepStatus() < (uint32)rhs.getBeepStatus()) return true;
        if ((uint32)getBeepStatus() > (uint32)rhs.getBeepStatus()) return false;
    }
    if (hasU32Token() || rhs.hasU32Token()) {
        if (getU32Token() < rhs.getU32Token()) return true;
        if (getU32Token() > rhs.getU32Token()) return false;
    }
    if (hasResource() || rhs.hasResource()) {
        if ((uint32)getResource() < (uint32)rhs.getResource()) return true;
        if ((uint32)getResource() > (uint32)rhs.getResource()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BeepStatusStatus::clone() {
    return new BeepStatusStatus(*this);
}

inline bool BeepStatusStatus::operator > (const BeepStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BeepStatusStatus::clear() {
    clearBeepStatus();
    clearU32Token();
    clearResource();
}

inline void BeepStatusStatus::clearBeepStatus() {
    if (hasBeepStatus()) {
         clear_has_BeepStatus();
        _BeepStatus = ::masc_main_fi_types::T_e8_AudioBeepStatus__AUDIO_BEEP_STATUS_NOT_DEF;
     }
}

inline bool BeepStatusStatus::hasBeepStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::masc_main_fi_types::T_e8_AudioBeepStatus BeepStatusStatus::getBeepStatus () const {
    return _BeepStatus;
}

inline void BeepStatusStatus::setBeepStatus (::masc_main_fi_types::T_e8_AudioBeepStatus BeepStatus_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioBeepStatus_IsValid(BeepStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", BeepStatus_, "T_e8_AudioBeepStatus", "BeepStatus", "BeepStatusStatus");
    }
    #endif
    set_has_BeepStatus();
    this->_BeepStatus = BeepStatus_;
}

inline void BeepStatusStatus::clearU32Token() {
    if (hasU32Token()) {
         clear_has_u32Token();
        _u32Token = 0u;
     }
}

inline bool BeepStatusStatus::hasU32Token () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 BeepStatusStatus::getU32Token () const {
    return _u32Token;
}

inline void BeepStatusStatus::setU32Token (uint32 u32Token_) {
    set_has_u32Token();
    this->_u32Token = u32Token_;
}

inline void BeepStatusStatus::clearResource() {
    if (hasResource()) {
         clear_has_Resource();
        _Resource = ::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF;
     }
}

inline bool BeepStatusStatus::hasResource () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::masc_main_fi_types::T_e8_ResourceNo BeepStatusStatus::getResource () const {
    return _Resource;
}

inline void BeepStatusStatus::setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "BeepStatusStatus");
    }
    #endif
    set_has_Resource();
    this->_Resource = Resource_;
}

inline void BeepStatusStatus::set_has_BeepStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void BeepStatusStatus::clear_has_BeepStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BeepStatusStatus::set_has_u32Token () {
    _has_bits_[0] |= 1u << 1;
}

inline void BeepStatusStatus::clear_has_u32Token () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BeepStatusStatus::set_has_Resource () {
    _has_bits_[0] |= 1u << 2;
}

inline void BeepStatusStatus::clear_has_Resource () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  GalaStatus::GalaStatus ()  :
    _GalaLevel (::masc_main_fi_types::T_e8_GalaLevel__AUDIO_GALA_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GalaStatus::GalaStatus (const GalaStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _GalaLevel (::masc_main_fi_types::T_e8_GalaLevel__AUDIO_GALA_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GalaStatus::GalaStatus (::masc_main_fi_types::T_e8_GalaLevel GalaLevel_, ::masc_main_fi_types::T_e8_ResourceNo Resource_)  :
    _GalaLevel (GalaLevel_),
    _Resource (Resource_)
{
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_GalaLevel_IsValid(GalaLevel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", GalaLevel_, "T_e8_GalaLevel", "GalaLevel", "GalaStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "GalaStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GalaStatus::~GalaStatus() {
}

inline GalaStatus& GalaStatus::operator = (const GalaStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGalaLevel()) {
            setGalaLevel(rhs.getGalaLevel());
        } else {
            clearGalaLevel();
        }
        if (rhs.hasResource()) {
            setResource(rhs.getResource());
        } else {
            clearResource();
        }
    }
    return *this;
}

inline bool GalaStatus::operator == (const GalaStatus& rhs) const {
    return (((!hasGalaLevel() && !rhs.hasGalaLevel()) || getGalaLevel() == rhs.getGalaLevel()) &&
        ((!hasResource() && !rhs.hasResource()) || getResource() == rhs.getResource()));
}

inline bool GalaStatus::operator != (const GalaStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool GalaStatus::operator < (const GalaStatus& rhs) const {
    if (hasGalaLevel() || rhs.hasGalaLevel()) {
        if ((uint32)getGalaLevel() < (uint32)rhs.getGalaLevel()) return true;
        if ((uint32)getGalaLevel() > (uint32)rhs.getGalaLevel()) return false;
    }
    if (hasResource() || rhs.hasResource()) {
        if ((uint32)getResource() < (uint32)rhs.getResource()) return true;
        if ((uint32)getResource() > (uint32)rhs.getResource()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GalaStatus::clone() {
    return new GalaStatus(*this);
}

inline bool GalaStatus::operator > (const GalaStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GalaStatus::clear() {
    clearGalaLevel();
    clearResource();
}

inline void GalaStatus::clearGalaLevel() {
    if (hasGalaLevel()) {
         clear_has_GalaLevel();
        _GalaLevel = ::masc_main_fi_types::T_e8_GalaLevel__AUDIO_GALA_NOT_DEF;
     }
}

inline bool GalaStatus::hasGalaLevel () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::masc_main_fi_types::T_e8_GalaLevel GalaStatus::getGalaLevel () const {
    return _GalaLevel;
}

inline void GalaStatus::setGalaLevel (::masc_main_fi_types::T_e8_GalaLevel GalaLevel_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_GalaLevel_IsValid(GalaLevel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", GalaLevel_, "T_e8_GalaLevel", "GalaLevel", "GalaStatus");
    }
    #endif
    set_has_GalaLevel();
    this->_GalaLevel = GalaLevel_;
}

inline void GalaStatus::clearResource() {
    if (hasResource()) {
         clear_has_Resource();
        _Resource = ::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF;
     }
}

inline bool GalaStatus::hasResource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::masc_main_fi_types::T_e8_ResourceNo GalaStatus::getResource () const {
    return _Resource;
}

inline void GalaStatus::setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "GalaStatus");
    }
    #endif
    set_has_Resource();
    this->_Resource = Resource_;
}

inline void GalaStatus::set_has_GalaLevel () {
    _has_bits_[0] |= 1u << 0;
}

inline void GalaStatus::clear_has_GalaLevel () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GalaStatus::set_has_Resource () {
    _has_bits_[0] |= 1u << 1;
}

inline void GalaStatus::clear_has_Resource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GalaSet::GalaSet ()  :
    _GalaLevel (::masc_main_fi_types::T_e8_GalaLevel__AUDIO_GALA_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GalaSet::GalaSet (const GalaSet &rhs)  :
    ::asf::core::Payload(rhs),
    _GalaLevel (::masc_main_fi_types::T_e8_GalaLevel__AUDIO_GALA_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GalaSet::GalaSet (::masc_main_fi_types::T_e8_GalaLevel GalaLevel_, ::masc_main_fi_types::T_e8_ResourceNo Resource_)  :
    _GalaLevel (GalaLevel_),
    _Resource (Resource_)
{
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_GalaLevel_IsValid(GalaLevel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", GalaLevel_, "T_e8_GalaLevel", "GalaLevel", "GalaSet");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "GalaSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GalaSet::~GalaSet() {
}

inline GalaSet& GalaSet::operator = (const GalaSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGalaLevel()) {
            setGalaLevel(rhs.getGalaLevel());
        } else {
            clearGalaLevel();
        }
        if (rhs.hasResource()) {
            setResource(rhs.getResource());
        } else {
            clearResource();
        }
    }
    return *this;
}

inline bool GalaSet::operator == (const GalaSet& rhs) const {
    return (((!hasGalaLevel() && !rhs.hasGalaLevel()) || getGalaLevel() == rhs.getGalaLevel()) &&
        ((!hasResource() && !rhs.hasResource()) || getResource() == rhs.getResource()));
}

inline bool GalaSet::operator != (const GalaSet& rhs) const {
    return ! (*this == rhs);
}

inline bool GalaSet::operator < (const GalaSet& rhs) const {
    if (hasGalaLevel() || rhs.hasGalaLevel()) {
        if ((uint32)getGalaLevel() < (uint32)rhs.getGalaLevel()) return true;
        if ((uint32)getGalaLevel() > (uint32)rhs.getGalaLevel()) return false;
    }
    if (hasResource() || rhs.hasResource()) {
        if ((uint32)getResource() < (uint32)rhs.getResource()) return true;
        if ((uint32)getResource() > (uint32)rhs.getResource()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GalaSet::clone() {
    return new GalaSet(*this);
}

inline bool GalaSet::operator > (const GalaSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GalaSet::clear() {
    clearGalaLevel();
    clearResource();
}

inline void GalaSet::clearGalaLevel() {
    if (hasGalaLevel()) {
         clear_has_GalaLevel();
        _GalaLevel = ::masc_main_fi_types::T_e8_GalaLevel__AUDIO_GALA_NOT_DEF;
     }
}

inline bool GalaSet::hasGalaLevel () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::masc_main_fi_types::T_e8_GalaLevel GalaSet::getGalaLevel () const {
    return _GalaLevel;
}

inline void GalaSet::setGalaLevel (::masc_main_fi_types::T_e8_GalaLevel GalaLevel_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_GalaLevel_IsValid(GalaLevel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", GalaLevel_, "T_e8_GalaLevel", "GalaLevel", "GalaSet");
    }
    #endif
    set_has_GalaLevel();
    this->_GalaLevel = GalaLevel_;
}

inline void GalaSet::clearResource() {
    if (hasResource()) {
         clear_has_Resource();
        _Resource = ::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF;
     }
}

inline bool GalaSet::hasResource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::masc_main_fi_types::T_e8_ResourceNo GalaSet::getResource () const {
    return _Resource;
}

inline void GalaSet::setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "GalaSet");
    }
    #endif
    set_has_Resource();
    this->_Resource = Resource_;
}

inline void GalaSet::set_has_GalaLevel () {
    _has_bits_[0] |= 1u << 0;
}

inline void GalaSet::clear_has_GalaLevel () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GalaSet::set_has_Resource () {
    _has_bits_[0] |= 1u << 1;
}

inline void GalaSet::clear_has_Resource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  BalanceStatus::BalanceStatus ()  :
    _Balance (0),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Channel (::masc_main_fi_types::T_e8_AudioChannel__AUDIO_CHANNEL_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BalanceStatus::BalanceStatus (const BalanceStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Balance (0),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Channel (::masc_main_fi_types::T_e8_AudioChannel__AUDIO_CHANNEL_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BalanceStatus::BalanceStatus (int8 Balance_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::masc_main_fi_types::T_e8_AudioChannel Channel_)  :
    _Balance (Balance_),
    _Resource (Resource_),
    _Channel (Channel_)
{
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "BalanceStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioChannel_IsValid(Channel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Channel_, "T_e8_AudioChannel", "Channel", "BalanceStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BalanceStatus::~BalanceStatus() {
}

inline BalanceStatus& BalanceStatus::operator = (const BalanceStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBalance()) {
            setBalance(rhs.getBalance());
        } else {
            clearBalance();
        }
        if (rhs.hasResource()) {
            setResource(rhs.getResource());
        } else {
            clearResource();
        }
        if (rhs.hasChannel()) {
            setChannel(rhs.getChannel());
        } else {
            clearChannel();
        }
    }
    return *this;
}

inline bool BalanceStatus::operator == (const BalanceStatus& rhs) const {
    return (((!hasBalance() && !rhs.hasBalance()) || getBalance() == rhs.getBalance()) &&
        ((!hasResource() && !rhs.hasResource()) || getResource() == rhs.getResource()) &&
        ((!hasChannel() && !rhs.hasChannel()) || getChannel() == rhs.getChannel()));
}

inline bool BalanceStatus::operator != (const BalanceStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool BalanceStatus::operator < (const BalanceStatus& rhs) const {
    if (hasBalance() || rhs.hasBalance()) {
        if (getBalance() < rhs.getBalance()) return true;
        if (getBalance() > rhs.getBalance()) return false;
    }
    if (hasResource() || rhs.hasResource()) {
        if ((uint32)getResource() < (uint32)rhs.getResource()) return true;
        if ((uint32)getResource() > (uint32)rhs.getResource()) return false;
    }
    if (hasChannel() || rhs.hasChannel()) {
        if ((uint32)getChannel() < (uint32)rhs.getChannel()) return true;
        if ((uint32)getChannel() > (uint32)rhs.getChannel()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BalanceStatus::clone() {
    return new BalanceStatus(*this);
}

inline bool BalanceStatus::operator > (const BalanceStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BalanceStatus::clear() {
    clearBalance();
    clearResource();
    clearChannel();
}

inline void BalanceStatus::clearBalance() {
    if (hasBalance()) {
         clear_has_Balance();
        _Balance = 0;
     }
}

inline bool BalanceStatus::hasBalance () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int8 BalanceStatus::getBalance () const {
    return _Balance;
}

inline void BalanceStatus::setBalance (int8 Balance_) {
    set_has_Balance();
    this->_Balance = Balance_;
}

inline void BalanceStatus::clearResource() {
    if (hasResource()) {
         clear_has_Resource();
        _Resource = ::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF;
     }
}

inline bool BalanceStatus::hasResource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::masc_main_fi_types::T_e8_ResourceNo BalanceStatus::getResource () const {
    return _Resource;
}

inline void BalanceStatus::setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "BalanceStatus");
    }
    #endif
    set_has_Resource();
    this->_Resource = Resource_;
}

inline void BalanceStatus::clearChannel() {
    if (hasChannel()) {
         clear_has_Channel();
        _Channel = ::masc_main_fi_types::T_e8_AudioChannel__AUDIO_CHANNEL_NOT_DEF;
     }
}

inline bool BalanceStatus::hasChannel () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::masc_main_fi_types::T_e8_AudioChannel BalanceStatus::getChannel () const {
    return _Channel;
}

inline void BalanceStatus::setChannel (::masc_main_fi_types::T_e8_AudioChannel Channel_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioChannel_IsValid(Channel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Channel_, "T_e8_AudioChannel", "Channel", "BalanceStatus");
    }
    #endif
    set_has_Channel();
    this->_Channel = Channel_;
}

inline void BalanceStatus::set_has_Balance () {
    _has_bits_[0] |= 1u << 0;
}

inline void BalanceStatus::clear_has_Balance () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BalanceStatus::set_has_Resource () {
    _has_bits_[0] |= 1u << 1;
}

inline void BalanceStatus::clear_has_Resource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BalanceStatus::set_has_Channel () {
    _has_bits_[0] |= 1u << 2;
}

inline void BalanceStatus::clear_has_Channel () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  BalanceSet::BalanceSet ()  :
    _SoundType (::masc_main_fi_types::T_e8_AudioSoundType__AUDIO_SND_TYPE_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Balance (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BalanceSet::BalanceSet (const BalanceSet &rhs)  :
    ::asf::core::Payload(rhs),
    _SoundType (::masc_main_fi_types::T_e8_AudioSoundType__AUDIO_SND_TYPE_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Balance (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BalanceSet::BalanceSet (::masc_main_fi_types::T_e8_AudioSoundType SoundType_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, int8 Balance_)  :
    _SoundType (SoundType_),
    _Resource (Resource_),
    _Balance (Balance_)
{
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioSoundType_IsValid(SoundType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SoundType_, "T_e8_AudioSoundType", "SoundType", "BalanceSet");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "BalanceSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BalanceSet::~BalanceSet() {
}

inline BalanceSet& BalanceSet::operator = (const BalanceSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSoundType()) {
            setSoundType(rhs.getSoundType());
        } else {
            clearSoundType();
        }
        if (rhs.hasResource()) {
            setResource(rhs.getResource());
        } else {
            clearResource();
        }
        if (rhs.hasBalance()) {
            setBalance(rhs.getBalance());
        } else {
            clearBalance();
        }
    }
    return *this;
}

inline bool BalanceSet::operator == (const BalanceSet& rhs) const {
    return (((!hasSoundType() && !rhs.hasSoundType()) || getSoundType() == rhs.getSoundType()) &&
        ((!hasResource() && !rhs.hasResource()) || getResource() == rhs.getResource()) &&
        ((!hasBalance() && !rhs.hasBalance()) || getBalance() == rhs.getBalance()));
}

inline bool BalanceSet::operator != (const BalanceSet& rhs) const {
    return ! (*this == rhs);
}

inline bool BalanceSet::operator < (const BalanceSet& rhs) const {
    if (hasSoundType() || rhs.hasSoundType()) {
        if ((uint32)getSoundType() < (uint32)rhs.getSoundType()) return true;
        if ((uint32)getSoundType() > (uint32)rhs.getSoundType()) return false;
    }
    if (hasResource() || rhs.hasResource()) {
        if ((uint32)getResource() < (uint32)rhs.getResource()) return true;
        if ((uint32)getResource() > (uint32)rhs.getResource()) return false;
    }
    if (hasBalance() || rhs.hasBalance()) {
        if (getBalance() < rhs.getBalance()) return true;
        if (getBalance() > rhs.getBalance()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BalanceSet::clone() {
    return new BalanceSet(*this);
}

inline bool BalanceSet::operator > (const BalanceSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BalanceSet::clear() {
    clearSoundType();
    clearResource();
    clearBalance();
}

inline void BalanceSet::clearSoundType() {
    if (hasSoundType()) {
         clear_has_SoundType();
        _SoundType = ::masc_main_fi_types::T_e8_AudioSoundType__AUDIO_SND_TYPE_NOT_DEF;
     }
}

inline bool BalanceSet::hasSoundType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::masc_main_fi_types::T_e8_AudioSoundType BalanceSet::getSoundType () const {
    return _SoundType;
}

inline void BalanceSet::setSoundType (::masc_main_fi_types::T_e8_AudioSoundType SoundType_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioSoundType_IsValid(SoundType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SoundType_, "T_e8_AudioSoundType", "SoundType", "BalanceSet");
    }
    #endif
    set_has_SoundType();
    this->_SoundType = SoundType_;
}

inline void BalanceSet::clearResource() {
    if (hasResource()) {
         clear_has_Resource();
        _Resource = ::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF;
     }
}

inline bool BalanceSet::hasResource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::masc_main_fi_types::T_e8_ResourceNo BalanceSet::getResource () const {
    return _Resource;
}

inline void BalanceSet::setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "BalanceSet");
    }
    #endif
    set_has_Resource();
    this->_Resource = Resource_;
}

inline void BalanceSet::clearBalance() {
    if (hasBalance()) {
         clear_has_Balance();
        _Balance = 0;
     }
}

inline bool BalanceSet::hasBalance () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int8 BalanceSet::getBalance () const {
    return _Balance;
}

inline void BalanceSet::setBalance (int8 Balance_) {
    set_has_Balance();
    this->_Balance = Balance_;
}

inline void BalanceSet::set_has_SoundType () {
    _has_bits_[0] |= 1u << 0;
}

inline void BalanceSet::clear_has_SoundType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BalanceSet::set_has_Resource () {
    _has_bits_[0] |= 1u << 1;
}

inline void BalanceSet::clear_has_Resource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BalanceSet::set_has_Balance () {
    _has_bits_[0] |= 1u << 2;
}

inline void BalanceSet::clear_has_Balance () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  LoudnessStatus::LoudnessStatus ()  :
    _Loudness (0u),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Channel (::masc_main_fi_types::T_e8_AudioChannel__AUDIO_CHANNEL_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LoudnessStatus::LoudnessStatus (const LoudnessStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Loudness (0u),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Channel (::masc_main_fi_types::T_e8_AudioChannel__AUDIO_CHANNEL_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LoudnessStatus::LoudnessStatus (uint8 Loudness_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::masc_main_fi_types::T_e8_AudioChannel Channel_)  :
    _Loudness (Loudness_),
    _Resource (Resource_),
    _Channel (Channel_)
{
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "LoudnessStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioChannel_IsValid(Channel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Channel_, "T_e8_AudioChannel", "Channel", "LoudnessStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LoudnessStatus::~LoudnessStatus() {
}

inline LoudnessStatus& LoudnessStatus::operator = (const LoudnessStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasLoudness()) {
            setLoudness(rhs.getLoudness());
        } else {
            clearLoudness();
        }
        if (rhs.hasResource()) {
            setResource(rhs.getResource());
        } else {
            clearResource();
        }
        if (rhs.hasChannel()) {
            setChannel(rhs.getChannel());
        } else {
            clearChannel();
        }
    }
    return *this;
}

inline bool LoudnessStatus::operator == (const LoudnessStatus& rhs) const {
    return (((!hasLoudness() && !rhs.hasLoudness()) || getLoudness() == rhs.getLoudness()) &&
        ((!hasResource() && !rhs.hasResource()) || getResource() == rhs.getResource()) &&
        ((!hasChannel() && !rhs.hasChannel()) || getChannel() == rhs.getChannel()));
}

inline bool LoudnessStatus::operator != (const LoudnessStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool LoudnessStatus::operator < (const LoudnessStatus& rhs) const {
    if (hasLoudness() || rhs.hasLoudness()) {
        if (getLoudness() < rhs.getLoudness()) return true;
        if (getLoudness() > rhs.getLoudness()) return false;
    }
    if (hasResource() || rhs.hasResource()) {
        if ((uint32)getResource() < (uint32)rhs.getResource()) return true;
        if ((uint32)getResource() > (uint32)rhs.getResource()) return false;
    }
    if (hasChannel() || rhs.hasChannel()) {
        if ((uint32)getChannel() < (uint32)rhs.getChannel()) return true;
        if ((uint32)getChannel() > (uint32)rhs.getChannel()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LoudnessStatus::clone() {
    return new LoudnessStatus(*this);
}

inline bool LoudnessStatus::operator > (const LoudnessStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LoudnessStatus::clear() {
    clearLoudness();
    clearResource();
    clearChannel();
}

inline void LoudnessStatus::clearLoudness() {
    if (hasLoudness()) {
         clear_has_Loudness();
        _Loudness = 0u;
     }
}

inline bool LoudnessStatus::hasLoudness () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 LoudnessStatus::getLoudness () const {
    return _Loudness;
}

inline void LoudnessStatus::setLoudness (uint8 Loudness_) {
    set_has_Loudness();
    this->_Loudness = Loudness_;
}

inline void LoudnessStatus::clearResource() {
    if (hasResource()) {
         clear_has_Resource();
        _Resource = ::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF;
     }
}

inline bool LoudnessStatus::hasResource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::masc_main_fi_types::T_e8_ResourceNo LoudnessStatus::getResource () const {
    return _Resource;
}

inline void LoudnessStatus::setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "LoudnessStatus");
    }
    #endif
    set_has_Resource();
    this->_Resource = Resource_;
}

inline void LoudnessStatus::clearChannel() {
    if (hasChannel()) {
         clear_has_Channel();
        _Channel = ::masc_main_fi_types::T_e8_AudioChannel__AUDIO_CHANNEL_NOT_DEF;
     }
}

inline bool LoudnessStatus::hasChannel () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::masc_main_fi_types::T_e8_AudioChannel LoudnessStatus::getChannel () const {
    return _Channel;
}

inline void LoudnessStatus::setChannel (::masc_main_fi_types::T_e8_AudioChannel Channel_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioChannel_IsValid(Channel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Channel_, "T_e8_AudioChannel", "Channel", "LoudnessStatus");
    }
    #endif
    set_has_Channel();
    this->_Channel = Channel_;
}

inline void LoudnessStatus::set_has_Loudness () {
    _has_bits_[0] |= 1u << 0;
}

inline void LoudnessStatus::clear_has_Loudness () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void LoudnessStatus::set_has_Resource () {
    _has_bits_[0] |= 1u << 1;
}

inline void LoudnessStatus::clear_has_Resource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void LoudnessStatus::set_has_Channel () {
    _has_bits_[0] |= 1u << 2;
}

inline void LoudnessStatus::clear_has_Channel () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  LoudnessSet::LoudnessSet ()  :
    _SoundType (::masc_main_fi_types::T_e8_AudioSoundType__AUDIO_SND_TYPE_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Loudness (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LoudnessSet::LoudnessSet (const LoudnessSet &rhs)  :
    ::asf::core::Payload(rhs),
    _SoundType (::masc_main_fi_types::T_e8_AudioSoundType__AUDIO_SND_TYPE_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Loudness (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LoudnessSet::LoudnessSet (::masc_main_fi_types::T_e8_AudioSoundType SoundType_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, uint8 Loudness_)  :
    _SoundType (SoundType_),
    _Resource (Resource_),
    _Loudness (Loudness_)
{
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioSoundType_IsValid(SoundType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SoundType_, "T_e8_AudioSoundType", "SoundType", "LoudnessSet");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "LoudnessSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LoudnessSet::~LoudnessSet() {
}

inline LoudnessSet& LoudnessSet::operator = (const LoudnessSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSoundType()) {
            setSoundType(rhs.getSoundType());
        } else {
            clearSoundType();
        }
        if (rhs.hasResource()) {
            setResource(rhs.getResource());
        } else {
            clearResource();
        }
        if (rhs.hasLoudness()) {
            setLoudness(rhs.getLoudness());
        } else {
            clearLoudness();
        }
    }
    return *this;
}

inline bool LoudnessSet::operator == (const LoudnessSet& rhs) const {
    return (((!hasSoundType() && !rhs.hasSoundType()) || getSoundType() == rhs.getSoundType()) &&
        ((!hasResource() && !rhs.hasResource()) || getResource() == rhs.getResource()) &&
        ((!hasLoudness() && !rhs.hasLoudness()) || getLoudness() == rhs.getLoudness()));
}

inline bool LoudnessSet::operator != (const LoudnessSet& rhs) const {
    return ! (*this == rhs);
}

inline bool LoudnessSet::operator < (const LoudnessSet& rhs) const {
    if (hasSoundType() || rhs.hasSoundType()) {
        if ((uint32)getSoundType() < (uint32)rhs.getSoundType()) return true;
        if ((uint32)getSoundType() > (uint32)rhs.getSoundType()) return false;
    }
    if (hasResource() || rhs.hasResource()) {
        if ((uint32)getResource() < (uint32)rhs.getResource()) return true;
        if ((uint32)getResource() > (uint32)rhs.getResource()) return false;
    }
    if (hasLoudness() || rhs.hasLoudness()) {
        if (getLoudness() < rhs.getLoudness()) return true;
        if (getLoudness() > rhs.getLoudness()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LoudnessSet::clone() {
    return new LoudnessSet(*this);
}

inline bool LoudnessSet::operator > (const LoudnessSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LoudnessSet::clear() {
    clearSoundType();
    clearResource();
    clearLoudness();
}

inline void LoudnessSet::clearSoundType() {
    if (hasSoundType()) {
         clear_has_SoundType();
        _SoundType = ::masc_main_fi_types::T_e8_AudioSoundType__AUDIO_SND_TYPE_NOT_DEF;
     }
}

inline bool LoudnessSet::hasSoundType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::masc_main_fi_types::T_e8_AudioSoundType LoudnessSet::getSoundType () const {
    return _SoundType;
}

inline void LoudnessSet::setSoundType (::masc_main_fi_types::T_e8_AudioSoundType SoundType_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioSoundType_IsValid(SoundType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SoundType_, "T_e8_AudioSoundType", "SoundType", "LoudnessSet");
    }
    #endif
    set_has_SoundType();
    this->_SoundType = SoundType_;
}

inline void LoudnessSet::clearResource() {
    if (hasResource()) {
         clear_has_Resource();
        _Resource = ::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF;
     }
}

inline bool LoudnessSet::hasResource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::masc_main_fi_types::T_e8_ResourceNo LoudnessSet::getResource () const {
    return _Resource;
}

inline void LoudnessSet::setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "LoudnessSet");
    }
    #endif
    set_has_Resource();
    this->_Resource = Resource_;
}

inline void LoudnessSet::clearLoudness() {
    if (hasLoudness()) {
         clear_has_Loudness();
        _Loudness = 0u;
     }
}

inline bool LoudnessSet::hasLoudness () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 LoudnessSet::getLoudness () const {
    return _Loudness;
}

inline void LoudnessSet::setLoudness (uint8 Loudness_) {
    set_has_Loudness();
    this->_Loudness = Loudness_;
}

inline void LoudnessSet::set_has_SoundType () {
    _has_bits_[0] |= 1u << 0;
}

inline void LoudnessSet::clear_has_SoundType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void LoudnessSet::set_has_Resource () {
    _has_bits_[0] |= 1u << 1;
}

inline void LoudnessSet::clear_has_Resource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void LoudnessSet::set_has_Loudness () {
    _has_bits_[0] |= 1u << 2;
}

inline void LoudnessSet::clear_has_Loudness () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  BassStatus::BassStatus ()  :
    _Bass (0),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Channel (::masc_main_fi_types::T_e8_AudioChannel__AUDIO_CHANNEL_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BassStatus::BassStatus (const BassStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Bass (0),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Channel (::masc_main_fi_types::T_e8_AudioChannel__AUDIO_CHANNEL_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BassStatus::BassStatus (int8 Bass_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::masc_main_fi_types::T_e8_AudioChannel Channel_)  :
    _Bass (Bass_),
    _Resource (Resource_),
    _Channel (Channel_)
{
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "BassStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioChannel_IsValid(Channel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Channel_, "T_e8_AudioChannel", "Channel", "BassStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BassStatus::~BassStatus() {
}

inline BassStatus& BassStatus::operator = (const BassStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBass()) {
            setBass(rhs.getBass());
        } else {
            clearBass();
        }
        if (rhs.hasResource()) {
            setResource(rhs.getResource());
        } else {
            clearResource();
        }
        if (rhs.hasChannel()) {
            setChannel(rhs.getChannel());
        } else {
            clearChannel();
        }
    }
    return *this;
}

inline bool BassStatus::operator == (const BassStatus& rhs) const {
    return (((!hasBass() && !rhs.hasBass()) || getBass() == rhs.getBass()) &&
        ((!hasResource() && !rhs.hasResource()) || getResource() == rhs.getResource()) &&
        ((!hasChannel() && !rhs.hasChannel()) || getChannel() == rhs.getChannel()));
}

inline bool BassStatus::operator != (const BassStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool BassStatus::operator < (const BassStatus& rhs) const {
    if (hasBass() || rhs.hasBass()) {
        if (getBass() < rhs.getBass()) return true;
        if (getBass() > rhs.getBass()) return false;
    }
    if (hasResource() || rhs.hasResource()) {
        if ((uint32)getResource() < (uint32)rhs.getResource()) return true;
        if ((uint32)getResource() > (uint32)rhs.getResource()) return false;
    }
    if (hasChannel() || rhs.hasChannel()) {
        if ((uint32)getChannel() < (uint32)rhs.getChannel()) return true;
        if ((uint32)getChannel() > (uint32)rhs.getChannel()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BassStatus::clone() {
    return new BassStatus(*this);
}

inline bool BassStatus::operator > (const BassStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BassStatus::clear() {
    clearBass();
    clearResource();
    clearChannel();
}

inline void BassStatus::clearBass() {
    if (hasBass()) {
         clear_has_Bass();
        _Bass = 0;
     }
}

inline bool BassStatus::hasBass () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int8 BassStatus::getBass () const {
    return _Bass;
}

inline void BassStatus::setBass (int8 Bass_) {
    set_has_Bass();
    this->_Bass = Bass_;
}

inline void BassStatus::clearResource() {
    if (hasResource()) {
         clear_has_Resource();
        _Resource = ::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF;
     }
}

inline bool BassStatus::hasResource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::masc_main_fi_types::T_e8_ResourceNo BassStatus::getResource () const {
    return _Resource;
}

inline void BassStatus::setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "BassStatus");
    }
    #endif
    set_has_Resource();
    this->_Resource = Resource_;
}

inline void BassStatus::clearChannel() {
    if (hasChannel()) {
         clear_has_Channel();
        _Channel = ::masc_main_fi_types::T_e8_AudioChannel__AUDIO_CHANNEL_NOT_DEF;
     }
}

inline bool BassStatus::hasChannel () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::masc_main_fi_types::T_e8_AudioChannel BassStatus::getChannel () const {
    return _Channel;
}

inline void BassStatus::setChannel (::masc_main_fi_types::T_e8_AudioChannel Channel_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioChannel_IsValid(Channel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Channel_, "T_e8_AudioChannel", "Channel", "BassStatus");
    }
    #endif
    set_has_Channel();
    this->_Channel = Channel_;
}

inline void BassStatus::set_has_Bass () {
    _has_bits_[0] |= 1u << 0;
}

inline void BassStatus::clear_has_Bass () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BassStatus::set_has_Resource () {
    _has_bits_[0] |= 1u << 1;
}

inline void BassStatus::clear_has_Resource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BassStatus::set_has_Channel () {
    _has_bits_[0] |= 1u << 2;
}

inline void BassStatus::clear_has_Channel () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  BassSet::BassSet ()  :
    _SoundType (::masc_main_fi_types::T_e8_AudioSoundType__AUDIO_SND_TYPE_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Bass (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BassSet::BassSet (const BassSet &rhs)  :
    ::asf::core::Payload(rhs),
    _SoundType (::masc_main_fi_types::T_e8_AudioSoundType__AUDIO_SND_TYPE_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Bass (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BassSet::BassSet (::masc_main_fi_types::T_e8_AudioSoundType SoundType_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, int8 Bass_)  :
    _SoundType (SoundType_),
    _Resource (Resource_),
    _Bass (Bass_)
{
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioSoundType_IsValid(SoundType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SoundType_, "T_e8_AudioSoundType", "SoundType", "BassSet");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "BassSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BassSet::~BassSet() {
}

inline BassSet& BassSet::operator = (const BassSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSoundType()) {
            setSoundType(rhs.getSoundType());
        } else {
            clearSoundType();
        }
        if (rhs.hasResource()) {
            setResource(rhs.getResource());
        } else {
            clearResource();
        }
        if (rhs.hasBass()) {
            setBass(rhs.getBass());
        } else {
            clearBass();
        }
    }
    return *this;
}

inline bool BassSet::operator == (const BassSet& rhs) const {
    return (((!hasSoundType() && !rhs.hasSoundType()) || getSoundType() == rhs.getSoundType()) &&
        ((!hasResource() && !rhs.hasResource()) || getResource() == rhs.getResource()) &&
        ((!hasBass() && !rhs.hasBass()) || getBass() == rhs.getBass()));
}

inline bool BassSet::operator != (const BassSet& rhs) const {
    return ! (*this == rhs);
}

inline bool BassSet::operator < (const BassSet& rhs) const {
    if (hasSoundType() || rhs.hasSoundType()) {
        if ((uint32)getSoundType() < (uint32)rhs.getSoundType()) return true;
        if ((uint32)getSoundType() > (uint32)rhs.getSoundType()) return false;
    }
    if (hasResource() || rhs.hasResource()) {
        if ((uint32)getResource() < (uint32)rhs.getResource()) return true;
        if ((uint32)getResource() > (uint32)rhs.getResource()) return false;
    }
    if (hasBass() || rhs.hasBass()) {
        if (getBass() < rhs.getBass()) return true;
        if (getBass() > rhs.getBass()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BassSet::clone() {
    return new BassSet(*this);
}

inline bool BassSet::operator > (const BassSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BassSet::clear() {
    clearSoundType();
    clearResource();
    clearBass();
}

inline void BassSet::clearSoundType() {
    if (hasSoundType()) {
         clear_has_SoundType();
        _SoundType = ::masc_main_fi_types::T_e8_AudioSoundType__AUDIO_SND_TYPE_NOT_DEF;
     }
}

inline bool BassSet::hasSoundType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::masc_main_fi_types::T_e8_AudioSoundType BassSet::getSoundType () const {
    return _SoundType;
}

inline void BassSet::setSoundType (::masc_main_fi_types::T_e8_AudioSoundType SoundType_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioSoundType_IsValid(SoundType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SoundType_, "T_e8_AudioSoundType", "SoundType", "BassSet");
    }
    #endif
    set_has_SoundType();
    this->_SoundType = SoundType_;
}

inline void BassSet::clearResource() {
    if (hasResource()) {
         clear_has_Resource();
        _Resource = ::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF;
     }
}

inline bool BassSet::hasResource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::masc_main_fi_types::T_e8_ResourceNo BassSet::getResource () const {
    return _Resource;
}

inline void BassSet::setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "BassSet");
    }
    #endif
    set_has_Resource();
    this->_Resource = Resource_;
}

inline void BassSet::clearBass() {
    if (hasBass()) {
         clear_has_Bass();
        _Bass = 0;
     }
}

inline bool BassSet::hasBass () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int8 BassSet::getBass () const {
    return _Bass;
}

inline void BassSet::setBass (int8 Bass_) {
    set_has_Bass();
    this->_Bass = Bass_;
}

inline void BassSet::set_has_SoundType () {
    _has_bits_[0] |= 1u << 0;
}

inline void BassSet::clear_has_SoundType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BassSet::set_has_Resource () {
    _has_bits_[0] |= 1u << 1;
}

inline void BassSet::clear_has_Resource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BassSet::set_has_Bass () {
    _has_bits_[0] |= 1u << 2;
}

inline void BassSet::clear_has_Bass () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  TrebleStatus::TrebleStatus ()  :
    _Treble (0),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Channel (::masc_main_fi_types::T_e8_AudioChannel__AUDIO_CHANNEL_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TrebleStatus::TrebleStatus (const TrebleStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Treble (0),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Channel (::masc_main_fi_types::T_e8_AudioChannel__AUDIO_CHANNEL_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TrebleStatus::TrebleStatus (int8 Treble_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::masc_main_fi_types::T_e8_AudioChannel Channel_)  :
    _Treble (Treble_),
    _Resource (Resource_),
    _Channel (Channel_)
{
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "TrebleStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioChannel_IsValid(Channel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Channel_, "T_e8_AudioChannel", "Channel", "TrebleStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TrebleStatus::~TrebleStatus() {
}

inline TrebleStatus& TrebleStatus::operator = (const TrebleStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTreble()) {
            setTreble(rhs.getTreble());
        } else {
            clearTreble();
        }
        if (rhs.hasResource()) {
            setResource(rhs.getResource());
        } else {
            clearResource();
        }
        if (rhs.hasChannel()) {
            setChannel(rhs.getChannel());
        } else {
            clearChannel();
        }
    }
    return *this;
}

inline bool TrebleStatus::operator == (const TrebleStatus& rhs) const {
    return (((!hasTreble() && !rhs.hasTreble()) || getTreble() == rhs.getTreble()) &&
        ((!hasResource() && !rhs.hasResource()) || getResource() == rhs.getResource()) &&
        ((!hasChannel() && !rhs.hasChannel()) || getChannel() == rhs.getChannel()));
}

inline bool TrebleStatus::operator != (const TrebleStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool TrebleStatus::operator < (const TrebleStatus& rhs) const {
    if (hasTreble() || rhs.hasTreble()) {
        if (getTreble() < rhs.getTreble()) return true;
        if (getTreble() > rhs.getTreble()) return false;
    }
    if (hasResource() || rhs.hasResource()) {
        if ((uint32)getResource() < (uint32)rhs.getResource()) return true;
        if ((uint32)getResource() > (uint32)rhs.getResource()) return false;
    }
    if (hasChannel() || rhs.hasChannel()) {
        if ((uint32)getChannel() < (uint32)rhs.getChannel()) return true;
        if ((uint32)getChannel() > (uint32)rhs.getChannel()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TrebleStatus::clone() {
    return new TrebleStatus(*this);
}

inline bool TrebleStatus::operator > (const TrebleStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TrebleStatus::clear() {
    clearTreble();
    clearResource();
    clearChannel();
}

inline void TrebleStatus::clearTreble() {
    if (hasTreble()) {
         clear_has_Treble();
        _Treble = 0;
     }
}

inline bool TrebleStatus::hasTreble () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int8 TrebleStatus::getTreble () const {
    return _Treble;
}

inline void TrebleStatus::setTreble (int8 Treble_) {
    set_has_Treble();
    this->_Treble = Treble_;
}

inline void TrebleStatus::clearResource() {
    if (hasResource()) {
         clear_has_Resource();
        _Resource = ::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF;
     }
}

inline bool TrebleStatus::hasResource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::masc_main_fi_types::T_e8_ResourceNo TrebleStatus::getResource () const {
    return _Resource;
}

inline void TrebleStatus::setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "TrebleStatus");
    }
    #endif
    set_has_Resource();
    this->_Resource = Resource_;
}

inline void TrebleStatus::clearChannel() {
    if (hasChannel()) {
         clear_has_Channel();
        _Channel = ::masc_main_fi_types::T_e8_AudioChannel__AUDIO_CHANNEL_NOT_DEF;
     }
}

inline bool TrebleStatus::hasChannel () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::masc_main_fi_types::T_e8_AudioChannel TrebleStatus::getChannel () const {
    return _Channel;
}

inline void TrebleStatus::setChannel (::masc_main_fi_types::T_e8_AudioChannel Channel_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioChannel_IsValid(Channel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Channel_, "T_e8_AudioChannel", "Channel", "TrebleStatus");
    }
    #endif
    set_has_Channel();
    this->_Channel = Channel_;
}

inline void TrebleStatus::set_has_Treble () {
    _has_bits_[0] |= 1u << 0;
}

inline void TrebleStatus::clear_has_Treble () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void TrebleStatus::set_has_Resource () {
    _has_bits_[0] |= 1u << 1;
}

inline void TrebleStatus::clear_has_Resource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void TrebleStatus::set_has_Channel () {
    _has_bits_[0] |= 1u << 2;
}

inline void TrebleStatus::clear_has_Channel () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  TrebleSet::TrebleSet ()  :
    _SoundType (::masc_main_fi_types::T_e8_AudioSoundType__AUDIO_SND_TYPE_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Treble (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TrebleSet::TrebleSet (const TrebleSet &rhs)  :
    ::asf::core::Payload(rhs),
    _SoundType (::masc_main_fi_types::T_e8_AudioSoundType__AUDIO_SND_TYPE_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Treble (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TrebleSet::TrebleSet (::masc_main_fi_types::T_e8_AudioSoundType SoundType_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, int8 Treble_)  :
    _SoundType (SoundType_),
    _Resource (Resource_),
    _Treble (Treble_)
{
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioSoundType_IsValid(SoundType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SoundType_, "T_e8_AudioSoundType", "SoundType", "TrebleSet");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "TrebleSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TrebleSet::~TrebleSet() {
}

inline TrebleSet& TrebleSet::operator = (const TrebleSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSoundType()) {
            setSoundType(rhs.getSoundType());
        } else {
            clearSoundType();
        }
        if (rhs.hasResource()) {
            setResource(rhs.getResource());
        } else {
            clearResource();
        }
        if (rhs.hasTreble()) {
            setTreble(rhs.getTreble());
        } else {
            clearTreble();
        }
    }
    return *this;
}

inline bool TrebleSet::operator == (const TrebleSet& rhs) const {
    return (((!hasSoundType() && !rhs.hasSoundType()) || getSoundType() == rhs.getSoundType()) &&
        ((!hasResource() && !rhs.hasResource()) || getResource() == rhs.getResource()) &&
        ((!hasTreble() && !rhs.hasTreble()) || getTreble() == rhs.getTreble()));
}

inline bool TrebleSet::operator != (const TrebleSet& rhs) const {
    return ! (*this == rhs);
}

inline bool TrebleSet::operator < (const TrebleSet& rhs) const {
    if (hasSoundType() || rhs.hasSoundType()) {
        if ((uint32)getSoundType() < (uint32)rhs.getSoundType()) return true;
        if ((uint32)getSoundType() > (uint32)rhs.getSoundType()) return false;
    }
    if (hasResource() || rhs.hasResource()) {
        if ((uint32)getResource() < (uint32)rhs.getResource()) return true;
        if ((uint32)getResource() > (uint32)rhs.getResource()) return false;
    }
    if (hasTreble() || rhs.hasTreble()) {
        if (getTreble() < rhs.getTreble()) return true;
        if (getTreble() > rhs.getTreble()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TrebleSet::clone() {
    return new TrebleSet(*this);
}

inline bool TrebleSet::operator > (const TrebleSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TrebleSet::clear() {
    clearSoundType();
    clearResource();
    clearTreble();
}

inline void TrebleSet::clearSoundType() {
    if (hasSoundType()) {
         clear_has_SoundType();
        _SoundType = ::masc_main_fi_types::T_e8_AudioSoundType__AUDIO_SND_TYPE_NOT_DEF;
     }
}

inline bool TrebleSet::hasSoundType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::masc_main_fi_types::T_e8_AudioSoundType TrebleSet::getSoundType () const {
    return _SoundType;
}

inline void TrebleSet::setSoundType (::masc_main_fi_types::T_e8_AudioSoundType SoundType_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioSoundType_IsValid(SoundType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SoundType_, "T_e8_AudioSoundType", "SoundType", "TrebleSet");
    }
    #endif
    set_has_SoundType();
    this->_SoundType = SoundType_;
}

inline void TrebleSet::clearResource() {
    if (hasResource()) {
         clear_has_Resource();
        _Resource = ::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF;
     }
}

inline bool TrebleSet::hasResource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::masc_main_fi_types::T_e8_ResourceNo TrebleSet::getResource () const {
    return _Resource;
}

inline void TrebleSet::setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "TrebleSet");
    }
    #endif
    set_has_Resource();
    this->_Resource = Resource_;
}

inline void TrebleSet::clearTreble() {
    if (hasTreble()) {
         clear_has_Treble();
        _Treble = 0;
     }
}

inline bool TrebleSet::hasTreble () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int8 TrebleSet::getTreble () const {
    return _Treble;
}

inline void TrebleSet::setTreble (int8 Treble_) {
    set_has_Treble();
    this->_Treble = Treble_;
}

inline void TrebleSet::set_has_SoundType () {
    _has_bits_[0] |= 1u << 0;
}

inline void TrebleSet::clear_has_SoundType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void TrebleSet::set_has_Resource () {
    _has_bits_[0] |= 1u << 1;
}

inline void TrebleSet::clear_has_Resource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void TrebleSet::set_has_Treble () {
    _has_bits_[0] |= 1u << 2;
}

inline void TrebleSet::clear_has_Treble () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  FaderStatus::FaderStatus ()  :
    _Fader (0),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Channel (::masc_main_fi_types::T_e8_AudioChannel__AUDIO_CHANNEL_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FaderStatus::FaderStatus (const FaderStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Fader (0),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Channel (::masc_main_fi_types::T_e8_AudioChannel__AUDIO_CHANNEL_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FaderStatus::FaderStatus (int8 Fader_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::masc_main_fi_types::T_e8_AudioChannel Channel_)  :
    _Fader (Fader_),
    _Resource (Resource_),
    _Channel (Channel_)
{
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "FaderStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioChannel_IsValid(Channel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Channel_, "T_e8_AudioChannel", "Channel", "FaderStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FaderStatus::~FaderStatus() {
}

inline FaderStatus& FaderStatus::operator = (const FaderStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFader()) {
            setFader(rhs.getFader());
        } else {
            clearFader();
        }
        if (rhs.hasResource()) {
            setResource(rhs.getResource());
        } else {
            clearResource();
        }
        if (rhs.hasChannel()) {
            setChannel(rhs.getChannel());
        } else {
            clearChannel();
        }
    }
    return *this;
}

inline bool FaderStatus::operator == (const FaderStatus& rhs) const {
    return (((!hasFader() && !rhs.hasFader()) || getFader() == rhs.getFader()) &&
        ((!hasResource() && !rhs.hasResource()) || getResource() == rhs.getResource()) &&
        ((!hasChannel() && !rhs.hasChannel()) || getChannel() == rhs.getChannel()));
}

inline bool FaderStatus::operator != (const FaderStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool FaderStatus::operator < (const FaderStatus& rhs) const {
    if (hasFader() || rhs.hasFader()) {
        if (getFader() < rhs.getFader()) return true;
        if (getFader() > rhs.getFader()) return false;
    }
    if (hasResource() || rhs.hasResource()) {
        if ((uint32)getResource() < (uint32)rhs.getResource()) return true;
        if ((uint32)getResource() > (uint32)rhs.getResource()) return false;
    }
    if (hasChannel() || rhs.hasChannel()) {
        if ((uint32)getChannel() < (uint32)rhs.getChannel()) return true;
        if ((uint32)getChannel() > (uint32)rhs.getChannel()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FaderStatus::clone() {
    return new FaderStatus(*this);
}

inline bool FaderStatus::operator > (const FaderStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FaderStatus::clear() {
    clearFader();
    clearResource();
    clearChannel();
}

inline void FaderStatus::clearFader() {
    if (hasFader()) {
         clear_has_Fader();
        _Fader = 0;
     }
}

inline bool FaderStatus::hasFader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int8 FaderStatus::getFader () const {
    return _Fader;
}

inline void FaderStatus::setFader (int8 Fader_) {
    set_has_Fader();
    this->_Fader = Fader_;
}

inline void FaderStatus::clearResource() {
    if (hasResource()) {
         clear_has_Resource();
        _Resource = ::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF;
     }
}

inline bool FaderStatus::hasResource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::masc_main_fi_types::T_e8_ResourceNo FaderStatus::getResource () const {
    return _Resource;
}

inline void FaderStatus::setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "FaderStatus");
    }
    #endif
    set_has_Resource();
    this->_Resource = Resource_;
}

inline void FaderStatus::clearChannel() {
    if (hasChannel()) {
         clear_has_Channel();
        _Channel = ::masc_main_fi_types::T_e8_AudioChannel__AUDIO_CHANNEL_NOT_DEF;
     }
}

inline bool FaderStatus::hasChannel () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::masc_main_fi_types::T_e8_AudioChannel FaderStatus::getChannel () const {
    return _Channel;
}

inline void FaderStatus::setChannel (::masc_main_fi_types::T_e8_AudioChannel Channel_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioChannel_IsValid(Channel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Channel_, "T_e8_AudioChannel", "Channel", "FaderStatus");
    }
    #endif
    set_has_Channel();
    this->_Channel = Channel_;
}

inline void FaderStatus::set_has_Fader () {
    _has_bits_[0] |= 1u << 0;
}

inline void FaderStatus::clear_has_Fader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FaderStatus::set_has_Resource () {
    _has_bits_[0] |= 1u << 1;
}

inline void FaderStatus::clear_has_Resource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void FaderStatus::set_has_Channel () {
    _has_bits_[0] |= 1u << 2;
}

inline void FaderStatus::clear_has_Channel () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  FaderSet::FaderSet ()  :
    _SoundType (::masc_main_fi_types::T_e8_AudioSoundType__AUDIO_SND_TYPE_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Fader (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FaderSet::FaderSet (const FaderSet &rhs)  :
    ::asf::core::Payload(rhs),
    _SoundType (::masc_main_fi_types::T_e8_AudioSoundType__AUDIO_SND_TYPE_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Fader (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FaderSet::FaderSet (::masc_main_fi_types::T_e8_AudioSoundType SoundType_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, int8 Fader_)  :
    _SoundType (SoundType_),
    _Resource (Resource_),
    _Fader (Fader_)
{
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioSoundType_IsValid(SoundType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SoundType_, "T_e8_AudioSoundType", "SoundType", "FaderSet");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "FaderSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FaderSet::~FaderSet() {
}

inline FaderSet& FaderSet::operator = (const FaderSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSoundType()) {
            setSoundType(rhs.getSoundType());
        } else {
            clearSoundType();
        }
        if (rhs.hasResource()) {
            setResource(rhs.getResource());
        } else {
            clearResource();
        }
        if (rhs.hasFader()) {
            setFader(rhs.getFader());
        } else {
            clearFader();
        }
    }
    return *this;
}

inline bool FaderSet::operator == (const FaderSet& rhs) const {
    return (((!hasSoundType() && !rhs.hasSoundType()) || getSoundType() == rhs.getSoundType()) &&
        ((!hasResource() && !rhs.hasResource()) || getResource() == rhs.getResource()) &&
        ((!hasFader() && !rhs.hasFader()) || getFader() == rhs.getFader()));
}

inline bool FaderSet::operator != (const FaderSet& rhs) const {
    return ! (*this == rhs);
}

inline bool FaderSet::operator < (const FaderSet& rhs) const {
    if (hasSoundType() || rhs.hasSoundType()) {
        if ((uint32)getSoundType() < (uint32)rhs.getSoundType()) return true;
        if ((uint32)getSoundType() > (uint32)rhs.getSoundType()) return false;
    }
    if (hasResource() || rhs.hasResource()) {
        if ((uint32)getResource() < (uint32)rhs.getResource()) return true;
        if ((uint32)getResource() > (uint32)rhs.getResource()) return false;
    }
    if (hasFader() || rhs.hasFader()) {
        if (getFader() < rhs.getFader()) return true;
        if (getFader() > rhs.getFader()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FaderSet::clone() {
    return new FaderSet(*this);
}

inline bool FaderSet::operator > (const FaderSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FaderSet::clear() {
    clearSoundType();
    clearResource();
    clearFader();
}

inline void FaderSet::clearSoundType() {
    if (hasSoundType()) {
         clear_has_SoundType();
        _SoundType = ::masc_main_fi_types::T_e8_AudioSoundType__AUDIO_SND_TYPE_NOT_DEF;
     }
}

inline bool FaderSet::hasSoundType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::masc_main_fi_types::T_e8_AudioSoundType FaderSet::getSoundType () const {
    return _SoundType;
}

inline void FaderSet::setSoundType (::masc_main_fi_types::T_e8_AudioSoundType SoundType_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioSoundType_IsValid(SoundType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SoundType_, "T_e8_AudioSoundType", "SoundType", "FaderSet");
    }
    #endif
    set_has_SoundType();
    this->_SoundType = SoundType_;
}

inline void FaderSet::clearResource() {
    if (hasResource()) {
         clear_has_Resource();
        _Resource = ::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF;
     }
}

inline bool FaderSet::hasResource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::masc_main_fi_types::T_e8_ResourceNo FaderSet::getResource () const {
    return _Resource;
}

inline void FaderSet::setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "FaderSet");
    }
    #endif
    set_has_Resource();
    this->_Resource = Resource_;
}

inline void FaderSet::clearFader() {
    if (hasFader()) {
         clear_has_Fader();
        _Fader = 0;
     }
}

inline bool FaderSet::hasFader () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int8 FaderSet::getFader () const {
    return _Fader;
}

inline void FaderSet::setFader (int8 Fader_) {
    set_has_Fader();
    this->_Fader = Fader_;
}

inline void FaderSet::set_has_SoundType () {
    _has_bits_[0] |= 1u << 0;
}

inline void FaderSet::clear_has_SoundType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FaderSet::set_has_Resource () {
    _has_bits_[0] |= 1u << 1;
}

inline void FaderSet::clear_has_Resource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void FaderSet::set_has_Fader () {
    _has_bits_[0] |= 1u << 2;
}

inline void FaderSet::clear_has_Fader () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  MidRangeStatus::MidRangeStatus ()  :
    _MidRange (0),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Channel (::masc_main_fi_types::T_e8_AudioChannel__AUDIO_CHANNEL_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MidRangeStatus::MidRangeStatus (const MidRangeStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _MidRange (0),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _Channel (::masc_main_fi_types::T_e8_AudioChannel__AUDIO_CHANNEL_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MidRangeStatus::MidRangeStatus (int8 MidRange_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::masc_main_fi_types::T_e8_AudioChannel Channel_)  :
    _MidRange (MidRange_),
    _Resource (Resource_),
    _Channel (Channel_)
{
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "MidRangeStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioChannel_IsValid(Channel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Channel_, "T_e8_AudioChannel", "Channel", "MidRangeStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MidRangeStatus::~MidRangeStatus() {
}

inline MidRangeStatus& MidRangeStatus::operator = (const MidRangeStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMidRange()) {
            setMidRange(rhs.getMidRange());
        } else {
            clearMidRange();
        }
        if (rhs.hasResource()) {
            setResource(rhs.getResource());
        } else {
            clearResource();
        }
        if (rhs.hasChannel()) {
            setChannel(rhs.getChannel());
        } else {
            clearChannel();
        }
    }
    return *this;
}

inline bool MidRangeStatus::operator == (const MidRangeStatus& rhs) const {
    return (((!hasMidRange() && !rhs.hasMidRange()) || getMidRange() == rhs.getMidRange()) &&
        ((!hasResource() && !rhs.hasResource()) || getResource() == rhs.getResource()) &&
        ((!hasChannel() && !rhs.hasChannel()) || getChannel() == rhs.getChannel()));
}

inline bool MidRangeStatus::operator != (const MidRangeStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool MidRangeStatus::operator < (const MidRangeStatus& rhs) const {
    if (hasMidRange() || rhs.hasMidRange()) {
        if (getMidRange() < rhs.getMidRange()) return true;
        if (getMidRange() > rhs.getMidRange()) return false;
    }
    if (hasResource() || rhs.hasResource()) {
        if ((uint32)getResource() < (uint32)rhs.getResource()) return true;
        if ((uint32)getResource() > (uint32)rhs.getResource()) return false;
    }
    if (hasChannel() || rhs.hasChannel()) {
        if ((uint32)getChannel() < (uint32)rhs.getChannel()) return true;
        if ((uint32)getChannel() > (uint32)rhs.getChannel()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MidRangeStatus::clone() {
    return new MidRangeStatus(*this);
}

inline bool MidRangeStatus::operator > (const MidRangeStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MidRangeStatus::clear() {
    clearMidRange();
    clearResource();
    clearChannel();
}

inline void MidRangeStatus::clearMidRange() {
    if (hasMidRange()) {
         clear_has_MidRange();
        _MidRange = 0;
     }
}

inline bool MidRangeStatus::hasMidRange () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int8 MidRangeStatus::getMidRange () const {
    return _MidRange;
}

inline void MidRangeStatus::setMidRange (int8 MidRange_) {
    set_has_MidRange();
    this->_MidRange = MidRange_;
}

inline void MidRangeStatus::clearResource() {
    if (hasResource()) {
         clear_has_Resource();
        _Resource = ::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF;
     }
}

inline bool MidRangeStatus::hasResource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::masc_main_fi_types::T_e8_ResourceNo MidRangeStatus::getResource () const {
    return _Resource;
}

inline void MidRangeStatus::setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "MidRangeStatus");
    }
    #endif
    set_has_Resource();
    this->_Resource = Resource_;
}

inline void MidRangeStatus::clearChannel() {
    if (hasChannel()) {
         clear_has_Channel();
        _Channel = ::masc_main_fi_types::T_e8_AudioChannel__AUDIO_CHANNEL_NOT_DEF;
     }
}

inline bool MidRangeStatus::hasChannel () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::masc_main_fi_types::T_e8_AudioChannel MidRangeStatus::getChannel () const {
    return _Channel;
}

inline void MidRangeStatus::setChannel (::masc_main_fi_types::T_e8_AudioChannel Channel_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioChannel_IsValid(Channel_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Channel_, "T_e8_AudioChannel", "Channel", "MidRangeStatus");
    }
    #endif
    set_has_Channel();
    this->_Channel = Channel_;
}

inline void MidRangeStatus::set_has_MidRange () {
    _has_bits_[0] |= 1u << 0;
}

inline void MidRangeStatus::clear_has_MidRange () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void MidRangeStatus::set_has_Resource () {
    _has_bits_[0] |= 1u << 1;
}

inline void MidRangeStatus::clear_has_Resource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void MidRangeStatus::set_has_Channel () {
    _has_bits_[0] |= 1u << 2;
}

inline void MidRangeStatus::clear_has_Channel () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  MidRangeSet::MidRangeSet ()  :
    _SoundType (::masc_main_fi_types::T_e8_AudioSoundType__AUDIO_SND_TYPE_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _MidRange (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MidRangeSet::MidRangeSet (const MidRangeSet &rhs)  :
    ::asf::core::Payload(rhs),
    _SoundType (::masc_main_fi_types::T_e8_AudioSoundType__AUDIO_SND_TYPE_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _MidRange (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MidRangeSet::MidRangeSet (::masc_main_fi_types::T_e8_AudioSoundType SoundType_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, int8 MidRange_)  :
    _SoundType (SoundType_),
    _Resource (Resource_),
    _MidRange (MidRange_)
{
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioSoundType_IsValid(SoundType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SoundType_, "T_e8_AudioSoundType", "SoundType", "MidRangeSet");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "MidRangeSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MidRangeSet::~MidRangeSet() {
}

inline MidRangeSet& MidRangeSet::operator = (const MidRangeSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSoundType()) {
            setSoundType(rhs.getSoundType());
        } else {
            clearSoundType();
        }
        if (rhs.hasResource()) {
            setResource(rhs.getResource());
        } else {
            clearResource();
        }
        if (rhs.hasMidRange()) {
            setMidRange(rhs.getMidRange());
        } else {
            clearMidRange();
        }
    }
    return *this;
}

inline bool MidRangeSet::operator == (const MidRangeSet& rhs) const {
    return (((!hasSoundType() && !rhs.hasSoundType()) || getSoundType() == rhs.getSoundType()) &&
        ((!hasResource() && !rhs.hasResource()) || getResource() == rhs.getResource()) &&
        ((!hasMidRange() && !rhs.hasMidRange()) || getMidRange() == rhs.getMidRange()));
}

inline bool MidRangeSet::operator != (const MidRangeSet& rhs) const {
    return ! (*this == rhs);
}

inline bool MidRangeSet::operator < (const MidRangeSet& rhs) const {
    if (hasSoundType() || rhs.hasSoundType()) {
        if ((uint32)getSoundType() < (uint32)rhs.getSoundType()) return true;
        if ((uint32)getSoundType() > (uint32)rhs.getSoundType()) return false;
    }
    if (hasResource() || rhs.hasResource()) {
        if ((uint32)getResource() < (uint32)rhs.getResource()) return true;
        if ((uint32)getResource() > (uint32)rhs.getResource()) return false;
    }
    if (hasMidRange() || rhs.hasMidRange()) {
        if (getMidRange() < rhs.getMidRange()) return true;
        if (getMidRange() > rhs.getMidRange()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MidRangeSet::clone() {
    return new MidRangeSet(*this);
}

inline bool MidRangeSet::operator > (const MidRangeSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MidRangeSet::clear() {
    clearSoundType();
    clearResource();
    clearMidRange();
}

inline void MidRangeSet::clearSoundType() {
    if (hasSoundType()) {
         clear_has_SoundType();
        _SoundType = ::masc_main_fi_types::T_e8_AudioSoundType__AUDIO_SND_TYPE_NOT_DEF;
     }
}

inline bool MidRangeSet::hasSoundType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::masc_main_fi_types::T_e8_AudioSoundType MidRangeSet::getSoundType () const {
    return _SoundType;
}

inline void MidRangeSet::setSoundType (::masc_main_fi_types::T_e8_AudioSoundType SoundType_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_AudioSoundType_IsValid(SoundType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SoundType_, "T_e8_AudioSoundType", "SoundType", "MidRangeSet");
    }
    #endif
    set_has_SoundType();
    this->_SoundType = SoundType_;
}

inline void MidRangeSet::clearResource() {
    if (hasResource()) {
         clear_has_Resource();
        _Resource = ::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF;
     }
}

inline bool MidRangeSet::hasResource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::masc_main_fi_types::T_e8_ResourceNo MidRangeSet::getResource () const {
    return _Resource;
}

inline void MidRangeSet::setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "MidRangeSet");
    }
    #endif
    set_has_Resource();
    this->_Resource = Resource_;
}

inline void MidRangeSet::clearMidRange() {
    if (hasMidRange()) {
         clear_has_MidRange();
        _MidRange = 0;
     }
}

inline bool MidRangeSet::hasMidRange () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int8 MidRangeSet::getMidRange () const {
    return _MidRange;
}

inline void MidRangeSet::setMidRange (int8 MidRange_) {
    set_has_MidRange();
    this->_MidRange = MidRange_;
}

inline void MidRangeSet::set_has_SoundType () {
    _has_bits_[0] |= 1u << 0;
}

inline void MidRangeSet::clear_has_SoundType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void MidRangeSet::set_has_Resource () {
    _has_bits_[0] |= 1u << 1;
}

inline void MidRangeSet::clear_has_Resource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void MidRangeSet::set_has_MidRange () {
    _has_bits_[0] |= 1u << 2;
}

inline void MidRangeSet::clear_has_MidRange () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  MemSoundStatus::MemSoundStatus ()  :
    _Sound (::masc_main_fi_types::T_e8_Sound__AUDIO_SOUND_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _MemStatus (::masc_main_fi_types::T_e8_MemStatus__AUDIO_MEMSTATUS_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MemSoundStatus::MemSoundStatus (const MemSoundStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Sound (::masc_main_fi_types::T_e8_Sound__AUDIO_SOUND_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF),
    _MemStatus (::masc_main_fi_types::T_e8_MemStatus__AUDIO_MEMSTATUS_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MemSoundStatus::MemSoundStatus (::masc_main_fi_types::T_e8_Sound Sound_, ::masc_main_fi_types::T_e8_ResourceNo Resource_, ::masc_main_fi_types::T_e8_MemStatus MemStatus_)  :
    _Sound (Sound_),
    _Resource (Resource_),
    _MemStatus (MemStatus_)
{
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_Sound_IsValid(Sound_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Sound_, "T_e8_Sound", "Sound", "MemSoundStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "MemSoundStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_MemStatus_IsValid(MemStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", MemStatus_, "T_e8_MemStatus", "MemStatus", "MemSoundStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MemSoundStatus::~MemSoundStatus() {
}

inline MemSoundStatus& MemSoundStatus::operator = (const MemSoundStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSound()) {
            setSound(rhs.getSound());
        } else {
            clearSound();
        }
        if (rhs.hasResource()) {
            setResource(rhs.getResource());
        } else {
            clearResource();
        }
        if (rhs.hasMemStatus()) {
            setMemStatus(rhs.getMemStatus());
        } else {
            clearMemStatus();
        }
    }
    return *this;
}

inline bool MemSoundStatus::operator == (const MemSoundStatus& rhs) const {
    return (((!hasSound() && !rhs.hasSound()) || getSound() == rhs.getSound()) &&
        ((!hasResource() && !rhs.hasResource()) || getResource() == rhs.getResource()) &&
        ((!hasMemStatus() && !rhs.hasMemStatus()) || getMemStatus() == rhs.getMemStatus()));
}

inline bool MemSoundStatus::operator != (const MemSoundStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool MemSoundStatus::operator < (const MemSoundStatus& rhs) const {
    if (hasSound() || rhs.hasSound()) {
        if ((uint32)getSound() < (uint32)rhs.getSound()) return true;
        if ((uint32)getSound() > (uint32)rhs.getSound()) return false;
    }
    if (hasResource() || rhs.hasResource()) {
        if ((uint32)getResource() < (uint32)rhs.getResource()) return true;
        if ((uint32)getResource() > (uint32)rhs.getResource()) return false;
    }
    if (hasMemStatus() || rhs.hasMemStatus()) {
        if ((uint32)getMemStatus() < (uint32)rhs.getMemStatus()) return true;
        if ((uint32)getMemStatus() > (uint32)rhs.getMemStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MemSoundStatus::clone() {
    return new MemSoundStatus(*this);
}

inline bool MemSoundStatus::operator > (const MemSoundStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MemSoundStatus::clear() {
    clearSound();
    clearResource();
    clearMemStatus();
}

inline void MemSoundStatus::clearSound() {
    if (hasSound()) {
         clear_has_Sound();
        _Sound = ::masc_main_fi_types::T_e8_Sound__AUDIO_SOUND_NOT_DEF;
     }
}

inline bool MemSoundStatus::hasSound () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::masc_main_fi_types::T_e8_Sound MemSoundStatus::getSound () const {
    return _Sound;
}

inline void MemSoundStatus::setSound (::masc_main_fi_types::T_e8_Sound Sound_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_Sound_IsValid(Sound_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Sound_, "T_e8_Sound", "Sound", "MemSoundStatus");
    }
    #endif
    set_has_Sound();
    this->_Sound = Sound_;
}

inline void MemSoundStatus::clearResource() {
    if (hasResource()) {
         clear_has_Resource();
        _Resource = ::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF;
     }
}

inline bool MemSoundStatus::hasResource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::masc_main_fi_types::T_e8_ResourceNo MemSoundStatus::getResource () const {
    return _Resource;
}

inline void MemSoundStatus::setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "MemSoundStatus");
    }
    #endif
    set_has_Resource();
    this->_Resource = Resource_;
}

inline void MemSoundStatus::clearMemStatus() {
    if (hasMemStatus()) {
         clear_has_MemStatus();
        _MemStatus = ::masc_main_fi_types::T_e8_MemStatus__AUDIO_MEMSTATUS_NOT_DEF;
     }
}

inline bool MemSoundStatus::hasMemStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::masc_main_fi_types::T_e8_MemStatus MemSoundStatus::getMemStatus () const {
    return _MemStatus;
}

inline void MemSoundStatus::setMemStatus (::masc_main_fi_types::T_e8_MemStatus MemStatus_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_MemStatus_IsValid(MemStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", MemStatus_, "T_e8_MemStatus", "MemStatus", "MemSoundStatus");
    }
    #endif
    set_has_MemStatus();
    this->_MemStatus = MemStatus_;
}

inline void MemSoundStatus::set_has_Sound () {
    _has_bits_[0] |= 1u << 0;
}

inline void MemSoundStatus::clear_has_Sound () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void MemSoundStatus::set_has_Resource () {
    _has_bits_[0] |= 1u << 1;
}

inline void MemSoundStatus::clear_has_Resource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void MemSoundStatus::set_has_MemStatus () {
    _has_bits_[0] |= 1u << 2;
}

inline void MemSoundStatus::clear_has_MemStatus () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  MemSoundSet::MemSoundSet ()  :
    _Sound (::masc_main_fi_types::T_e8_Sound__AUDIO_SOUND_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MemSoundSet::MemSoundSet (const MemSoundSet &rhs)  :
    ::asf::core::Payload(rhs),
    _Sound (::masc_main_fi_types::T_e8_Sound__AUDIO_SOUND_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MemSoundSet::MemSoundSet (::masc_main_fi_types::T_e8_Sound Sound_, ::masc_main_fi_types::T_e8_ResourceNo Resource_)  :
    _Sound (Sound_),
    _Resource (Resource_)
{
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_Sound_IsValid(Sound_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Sound_, "T_e8_Sound", "Sound", "MemSoundSet");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "MemSoundSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MemSoundSet::~MemSoundSet() {
}

inline MemSoundSet& MemSoundSet::operator = (const MemSoundSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSound()) {
            setSound(rhs.getSound());
        } else {
            clearSound();
        }
        if (rhs.hasResource()) {
            setResource(rhs.getResource());
        } else {
            clearResource();
        }
    }
    return *this;
}

inline bool MemSoundSet::operator == (const MemSoundSet& rhs) const {
    return (((!hasSound() && !rhs.hasSound()) || getSound() == rhs.getSound()) &&
        ((!hasResource() && !rhs.hasResource()) || getResource() == rhs.getResource()));
}

inline bool MemSoundSet::operator != (const MemSoundSet& rhs) const {
    return ! (*this == rhs);
}

inline bool MemSoundSet::operator < (const MemSoundSet& rhs) const {
    if (hasSound() || rhs.hasSound()) {
        if ((uint32)getSound() < (uint32)rhs.getSound()) return true;
        if ((uint32)getSound() > (uint32)rhs.getSound()) return false;
    }
    if (hasResource() || rhs.hasResource()) {
        if ((uint32)getResource() < (uint32)rhs.getResource()) return true;
        if ((uint32)getResource() > (uint32)rhs.getResource()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MemSoundSet::clone() {
    return new MemSoundSet(*this);
}

inline bool MemSoundSet::operator > (const MemSoundSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MemSoundSet::clear() {
    clearSound();
    clearResource();
}

inline void MemSoundSet::clearSound() {
    if (hasSound()) {
         clear_has_Sound();
        _Sound = ::masc_main_fi_types::T_e8_Sound__AUDIO_SOUND_NOT_DEF;
     }
}

inline bool MemSoundSet::hasSound () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::masc_main_fi_types::T_e8_Sound MemSoundSet::getSound () const {
    return _Sound;
}

inline void MemSoundSet::setSound (::masc_main_fi_types::T_e8_Sound Sound_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_Sound_IsValid(Sound_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Sound_, "T_e8_Sound", "Sound", "MemSoundSet");
    }
    #endif
    set_has_Sound();
    this->_Sound = Sound_;
}

inline void MemSoundSet::clearResource() {
    if (hasResource()) {
         clear_has_Resource();
        _Resource = ::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF;
     }
}

inline bool MemSoundSet::hasResource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::masc_main_fi_types::T_e8_ResourceNo MemSoundSet::getResource () const {
    return _Resource;
}

inline void MemSoundSet::setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "MemSoundSet");
    }
    #endif
    set_has_Resource();
    this->_Resource = Resource_;
}

inline void MemSoundSet::set_has_Sound () {
    _has_bits_[0] |= 1u << 0;
}

inline void MemSoundSet::clear_has_Sound () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void MemSoundSet::set_has_Resource () {
    _has_bits_[0] |= 1u << 1;
}

inline void MemSoundSet::clear_has_Resource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  FaderActivationStatusStatus::FaderActivationStatusStatus ()  :
    _FaderStatus (::masc_main_fi_types::T_e8_FaderStatus__AUDIO_FADERSTATUS_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FaderActivationStatusStatus::FaderActivationStatusStatus (const FaderActivationStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _FaderStatus (::masc_main_fi_types::T_e8_FaderStatus__AUDIO_FADERSTATUS_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FaderActivationStatusStatus::FaderActivationStatusStatus (::masc_main_fi_types::T_e8_FaderStatus FaderStatus_)  :
    _FaderStatus (FaderStatus_)
{
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_FaderStatus_IsValid(FaderStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", FaderStatus_, "T_e8_FaderStatus", "FaderStatus", "FaderActivationStatusStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FaderActivationStatusStatus::~FaderActivationStatusStatus() {
}

inline FaderActivationStatusStatus& FaderActivationStatusStatus::operator = (const FaderActivationStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFaderStatus()) {
            setFaderStatus(rhs.getFaderStatus());
        } else {
            clearFaderStatus();
        }
    }
    return *this;
}

inline bool FaderActivationStatusStatus::operator == (const FaderActivationStatusStatus& rhs) const {
    return (((!hasFaderStatus() && !rhs.hasFaderStatus()) || getFaderStatus() == rhs.getFaderStatus()));
}

inline bool FaderActivationStatusStatus::operator != (const FaderActivationStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool FaderActivationStatusStatus::operator < (const FaderActivationStatusStatus& rhs) const {
    if (hasFaderStatus() || rhs.hasFaderStatus()) {
        if ((uint32)getFaderStatus() < (uint32)rhs.getFaderStatus()) return true;
        if ((uint32)getFaderStatus() > (uint32)rhs.getFaderStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FaderActivationStatusStatus::clone() {
    return new FaderActivationStatusStatus(*this);
}

inline bool FaderActivationStatusStatus::operator > (const FaderActivationStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FaderActivationStatusStatus::clear() {
    clearFaderStatus();
}

inline void FaderActivationStatusStatus::clearFaderStatus() {
    if (hasFaderStatus()) {
         clear_has_FaderStatus();
        _FaderStatus = ::masc_main_fi_types::T_e8_FaderStatus__AUDIO_FADERSTATUS_NOT_DEF;
     }
}

inline bool FaderActivationStatusStatus::hasFaderStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::masc_main_fi_types::T_e8_FaderStatus FaderActivationStatusStatus::getFaderStatus () const {
    return _FaderStatus;
}

inline void FaderActivationStatusStatus::setFaderStatus (::masc_main_fi_types::T_e8_FaderStatus FaderStatus_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_FaderStatus_IsValid(FaderStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", FaderStatus_, "T_e8_FaderStatus", "FaderStatus", "FaderActivationStatusStatus");
    }
    #endif
    set_has_FaderStatus();
    this->_FaderStatus = FaderStatus_;
}

inline void FaderActivationStatusStatus::set_has_FaderStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void FaderActivationStatusStatus::clear_has_FaderStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DynamicCompressionStatus::DynamicCompressionStatus ()  :
    _DynCompression (::masc_main_fi_types::T_e8_DynCompression__AUDIO_DYN_COMPRESSION_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DynamicCompressionStatus::DynamicCompressionStatus (const DynamicCompressionStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _DynCompression (::masc_main_fi_types::T_e8_DynCompression__AUDIO_DYN_COMPRESSION_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DynamicCompressionStatus::DynamicCompressionStatus (::masc_main_fi_types::T_e8_DynCompression DynCompression_, ::masc_main_fi_types::T_e8_ResourceNo Resource_)  :
    _DynCompression (DynCompression_),
    _Resource (Resource_)
{
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_DynCompression_IsValid(DynCompression_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DynCompression_, "T_e8_DynCompression", "DynCompression", "DynamicCompressionStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "DynamicCompressionStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DynamicCompressionStatus::~DynamicCompressionStatus() {
}

inline DynamicCompressionStatus& DynamicCompressionStatus::operator = (const DynamicCompressionStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDynCompression()) {
            setDynCompression(rhs.getDynCompression());
        } else {
            clearDynCompression();
        }
        if (rhs.hasResource()) {
            setResource(rhs.getResource());
        } else {
            clearResource();
        }
    }
    return *this;
}

inline bool DynamicCompressionStatus::operator == (const DynamicCompressionStatus& rhs) const {
    return (((!hasDynCompression() && !rhs.hasDynCompression()) || getDynCompression() == rhs.getDynCompression()) &&
        ((!hasResource() && !rhs.hasResource()) || getResource() == rhs.getResource()));
}

inline bool DynamicCompressionStatus::operator != (const DynamicCompressionStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DynamicCompressionStatus::operator < (const DynamicCompressionStatus& rhs) const {
    if (hasDynCompression() || rhs.hasDynCompression()) {
        if ((uint32)getDynCompression() < (uint32)rhs.getDynCompression()) return true;
        if ((uint32)getDynCompression() > (uint32)rhs.getDynCompression()) return false;
    }
    if (hasResource() || rhs.hasResource()) {
        if ((uint32)getResource() < (uint32)rhs.getResource()) return true;
        if ((uint32)getResource() > (uint32)rhs.getResource()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DynamicCompressionStatus::clone() {
    return new DynamicCompressionStatus(*this);
}

inline bool DynamicCompressionStatus::operator > (const DynamicCompressionStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DynamicCompressionStatus::clear() {
    clearDynCompression();
    clearResource();
}

inline void DynamicCompressionStatus::clearDynCompression() {
    if (hasDynCompression()) {
         clear_has_DynCompression();
        _DynCompression = ::masc_main_fi_types::T_e8_DynCompression__AUDIO_DYN_COMPRESSION_NOT_DEF;
     }
}

inline bool DynamicCompressionStatus::hasDynCompression () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::masc_main_fi_types::T_e8_DynCompression DynamicCompressionStatus::getDynCompression () const {
    return _DynCompression;
}

inline void DynamicCompressionStatus::setDynCompression (::masc_main_fi_types::T_e8_DynCompression DynCompression_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_DynCompression_IsValid(DynCompression_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DynCompression_, "T_e8_DynCompression", "DynCompression", "DynamicCompressionStatus");
    }
    #endif
    set_has_DynCompression();
    this->_DynCompression = DynCompression_;
}

inline void DynamicCompressionStatus::clearResource() {
    if (hasResource()) {
         clear_has_Resource();
        _Resource = ::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF;
     }
}

inline bool DynamicCompressionStatus::hasResource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::masc_main_fi_types::T_e8_ResourceNo DynamicCompressionStatus::getResource () const {
    return _Resource;
}

inline void DynamicCompressionStatus::setResource (::masc_main_fi_types::T_e8_ResourceNo Resource_) {
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "DynamicCompressionStatus");
    }
    #endif
    set_has_Resource();
    this->_Resource = Resource_;
}

inline void DynamicCompressionStatus::set_has_DynCompression () {
    _has_bits_[0] |= 1u << 0;
}

inline void DynamicCompressionStatus::clear_has_DynCompression () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DynamicCompressionStatus::set_has_Resource () {
    _has_bits_[0] |= 1u << 1;
}

inline void DynamicCompressionStatus::clear_has_Resource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DynamicCompressionSet::DynamicCompressionSet ()  :
    _DynComp (::masc_main_fi_types::T_e8_DynCompression__AUDIO_DYN_COMPRESSION_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DynamicCompressionSet::DynamicCompressionSet (const DynamicCompressionSet &rhs)  :
    ::asf::core::Payload(rhs),
    _DynComp (::masc_main_fi_types::T_e8_DynCompression__AUDIO_DYN_COMPRESSION_NOT_DEF),
    _Resource (::masc_main_fi_types::T_e8_ResourceNo__AUDIO_RESOURCE_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DynamicCompressionSet::DynamicCompressionSet (::masc_main_fi_types::T_e8_DynCompression DynComp_, ::masc_main_fi_types::T_e8_ResourceNo Resource_)  :
    _DynComp (DynComp_),
    _Resource (Resource_)
{
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_DynCompression_IsValid(DynComp_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DynComp_, "T_e8_DynCompression", "DynComp", "DynamicCompressionSet");
    }
    #endif
    #ifndef NDEBUG
    if (!(::masc_main_fi_types::T_e8_ResourceNo_IsValid(Resource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Resource_, "T_e8_ResourceNo", "Resource", "DynamicCompressionSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DynamicCompressionSet::~DynamicCompressionSet() {
}

inline DynamicCompressionSet& DynamicCompressionSet::operator = (const DynamicCompressionSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDynComp()) {
            setDynComp(rhs.getDynComp());
        } else {
            clearDynComp();
        }
        if (rhs.hasResource()) {
            setResource(rhs.getResource());
        } else {
            clearResource();
        }
    }
    return *this;
}

inline bool DynamicCompressionSet::operator == (const DynamicCompressionSet& rhs) const {
    return (((!hasDynComp() && !rhs.hasDynComp()) || getDynComp() == rhs.getDynComp()) &&
        ((!hasResource() && !rhs.hasResource()) || getResource() == rhs.getResource()));
}

inline bool DynamicCompressionSet::operator != (const DynamicCompressionSet& rhs) const {
    return ! (*this == rhs);
}

inlin