#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MASC_MAIN_FI_TYPES_H
#define MASC_MAIN_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "masc_main_fi_typesConst.h"
#include <cstring>
#include <vector>

/**
 * Types masc_main_fi_types
 */

namespace masc_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_Aud_TestRoutineParameter;

class T_Aud_TestTroubleCodeStatus;

class T_MicrophoneConnectionStatus;

class T_Volume;

class T_b8_ChannelSelect;

class T_BeepConfig;

class T_Aud_VolumeStatus;

class T_Aud_EDStatus;

class T_b32_MeasurementResult;

class T_Aud_MeasurementResultItem;

class T_BOSE_UnitConnectionStatus;

class T_MicrophoneStatus;

class T_MicrophoneResult;

// type definitions
/**
 * If the meaning of "T_Aud_TestRoutineParameterList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_Aud_TestRoutineParameter > T_Aud_TestRoutineParameterList;

/**
 * If the meaning of "T_Aud_TestTroubleCodeStatusList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_Aud_TestTroubleCodeStatus > T_Aud_TestTroubleCodeStatusList;

/**
 * If the meaning of "T_MicrophoneConnectionStatusList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_MicrophoneConnectionStatus > T_MicrophoneConnectionStatusList;

/**
 * If the meaning of "T_Aud_VolumeStatusList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_Aud_VolumeStatus > T_Aud_VolumeStatusList;

/**
 * If the meaning of "T_Aud_EDStatusList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_Aud_EDStatus > T_Aud_EDStatusList;


/**
 * If the meaning of "T_Aud_TestRoutineParameter" isn't clear, then there should be a description here.
 */
class T_Aud_TestRoutineParameter {
public:

    /**
     * Default constructor
     */
    inline  T_Aud_TestRoutineParameter ();

    /**
     * Copy constructor
     */
    inline  T_Aud_TestRoutineParameter (const T_Aud_TestRoutineParameter &rhs);

    /**
     * All fields constructor
     */
    inline  T_Aud_TestRoutineParameter (T_e16_Aud_TroubleCode TroubleCode_, bool WriteToRM_, T_e8_Aud_MonitoringMode MonitoringMode_, T_e8_Aud_SupervisionControl SupervisionControl_);

    /**
     * Destructor
     */
    inline  ~T_Aud_TestRoutineParameter();

    /**
     * Assignment operator
     */
    inline T_Aud_TestRoutineParameter& operator = (const T_Aud_TestRoutineParameter& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Aud_TestRoutineParameter& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Aud_TestRoutineParameter& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Aud_TestRoutineParameter& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Aud_TestRoutineParameter& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TroubleCode"

    static const int kTroubleCode = 0;

    /**
     * Clears the field "TroubleCode".
     *
     * The field will be set to its default value. The hasTroubleCode()
     * method will return false.
     */
    inline void clearTroubleCode();

    /**
     * Checks whether the field "TroubleCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTroubleCode()). Otherwise it will return false.
     */
    inline bool hasTroubleCode () const;

    /**
     * Returns the value of the member "TroubleCode".
     *
     * Trouble codes for speaker and tweeter tests
     *
     * @return The value of the field "TroubleCode"
     */
    inline T_e16_Aud_TroubleCode getTroubleCode () const;

    /**
     * Sets the value of the member "TroubleCode".
     *
     * Trouble codes for speaker and tweeter tests
     *
     * @param TroubleCode The value which will be set
     */
    inline void setTroubleCode (T_e16_Aud_TroubleCode TroubleCode_);

    // API of field "WriteToRM"

    static const int kWriteToRM = 1;

    /**
     * Clears the field "WriteToRM".
     *
     * The field will be set to its default value. The hasWriteToRM()
     * method will return false.
     */
    inline void clearWriteToRM();

    /**
     * Checks whether the field "WriteToRM" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWriteToRM()). Otherwise it will return false.
     */
    inline bool hasWriteToRM () const;

    /**
     * Returns the value of the member "WriteToRM".
     *
     * This flag controls if the component shall report the routine result to the
     * report memory (DiagLog) or not.
     *
     * @return The value of the field "WriteToRM"
     */
    inline bool getWriteToRM () const;

    /**
     * Sets the value of the member "WriteToRM".
     *
     * This flag controls if the component shall report the routine result to the
     * report memory (DiagLog) or not.
     *
     * @param WriteToRM The value which will be set
     */
    inline void setWriteToRM (bool WriteToRM_);

    // API of field "MonitoringMode"

    static const int kMonitoringMode = 2;

    /**
     * Clears the field "MonitoringMode".
     *
     * The field will be set to its default value. The hasMonitoringMode()
     * method will return false.
     */
    inline void clearMonitoringMode();

    /**
     * Checks whether the field "MonitoringMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMonitoringMode()). Otherwise it will return false.
     */
    inline bool hasMonitoringMode () const;

    /**
     * Returns the value of the member "MonitoringMode".
     *
     * The MonitoringMode controls the execution duration of the test routine during
     * the diagnostic mode.
     *
     * @return The value of the field "MonitoringMode"
     */
    inline T_e8_Aud_MonitoringMode getMonitoringMode () const;

    /**
     * Sets the value of the member "MonitoringMode".
     *
     * The MonitoringMode controls the execution duration of the test routine during
     * the diagnostic mode.
     *
     * @param MonitoringMode The value which will be set
     */
    inline void setMonitoringMode (T_e8_Aud_MonitoringMode MonitoringMode_);

    // API of field "SupervisionControl"

    static const int kSupervisionControl = 3;

    /**
     * Clears the field "SupervisionControl".
     *
     * The field will be set to its default value. The hasSupervisionControl()
     * method will return false.
     */
    inline void clearSupervisionControl();

    /**
     * Checks whether the field "SupervisionControl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSupervisionControl()). Otherwise it will return false.
     */
    inline bool hasSupervisionControl () const;

    /**
     * Returns the value of the member "SupervisionControl".
     *
     * To switch on/off the tweeter test monitoring on entering diagnostic mode
     *
     * @return The value of the field "SupervisionControl"
     */
    inline T_e8_Aud_SupervisionControl getSupervisionControl () const;

    /**
     * Sets the value of the member "SupervisionControl".
     *
     * To switch on/off the tweeter test monitoring on entering diagnostic mode
     *
     * @param SupervisionControl The value which will be set
     */
    inline void setSupervisionControl (T_e8_Aud_SupervisionControl SupervisionControl_);

    static const T_Aud_TestRoutineParameter &getDefaultInstance();

private:

    inline void set_has_TroubleCode ();

    inline void clear_has_TroubleCode ();

    inline void set_has_WriteToRM ();

    inline void clear_has_WriteToRM ();

    inline void set_has_MonitoringMode ();

    inline void clear_has_MonitoringMode ();

    inline void set_has_SupervisionControl ();

    inline void clear_has_SupervisionControl ();

    uint32 _has_bits_[ (4 + 31) / 32];

    T_e16_Aud_TroubleCode _TroubleCode;

    bool _WriteToRM;

    T_e8_Aud_MonitoringMode _MonitoringMode;

    T_e8_Aud_SupervisionControl _SupervisionControl;

};

/**
 * The TroubleCodeStatus contains information about the status of the trouble
 * code.
 */
class T_Aud_TestTroubleCodeStatus {
public:

    /**
     * Default constructor
     */
    inline  T_Aud_TestTroubleCodeStatus ();

    /**
     * Copy constructor
     */
    inline  T_Aud_TestTroubleCodeStatus (const T_Aud_TestTroubleCodeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  T_Aud_TestTroubleCodeStatus (T_e16_Aud_TroubleCode TroubleCode_, T_e8_Aud_ErrorStatus ErrorStatus_, T_e8_Aud_RoutineStatus RoutineStatus_, T_e8_Aud_WriteTestErrorStatus DiagnosisLogWrite_);

    /**
     * Destructor
     */
    inline  ~T_Aud_TestTroubleCodeStatus();

    /**
     * Assignment operator
     */
    inline T_Aud_TestTroubleCodeStatus& operator = (const T_Aud_TestTroubleCodeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Aud_TestTroubleCodeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Aud_TestTroubleCodeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Aud_TestTroubleCodeStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Aud_TestTroubleCodeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TroubleCode"

    static const int kTroubleCode = 0;

    /**
     * Clears the field "TroubleCode".
     *
     * The field will be set to its default value. The hasTroubleCode()
     * method will return false.
     */
    inline void clearTroubleCode();

    /**
     * Checks whether the field "TroubleCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTroubleCode()). Otherwise it will return false.
     */
    inline bool hasTroubleCode () const;

    /**
     * Returns the value of the member "TroubleCode".
     *
     * TroubleCode whose result has come
     *
     * @return The value of the field "TroubleCode"
     */
    inline T_e16_Aud_TroubleCode getTroubleCode () const;

    /**
     * Sets the value of the member "TroubleCode".
     *
     * TroubleCode whose result has come
     *
     * @param TroubleCode The value which will be set
     */
    inline void setTroubleCode (T_e16_Aud_TroubleCode TroubleCode_);

    // API of field "ErrorStatus"

    static const int kErrorStatus = 1;

    /**
     * Clears the field "ErrorStatus".
     *
     * The field will be set to its default value. The hasErrorStatus()
     * method will return false.
     */
    inline void clearErrorStatus();

    /**
     * Checks whether the field "ErrorStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorStatus()). Otherwise it will return false.
     */
    inline bool hasErrorStatus () const;

    /**
     * Returns the value of the member "ErrorStatus".
     *
     * Status of a TroubleCode
     *
     * @return The value of the field "ErrorStatus"
     */
    inline T_e8_Aud_ErrorStatus getErrorStatus () const;

    /**
     * Sets the value of the member "ErrorStatus".
     *
     * Status of a TroubleCode
     *
     * @param ErrorStatus The value which will be set
     */
    inline void setErrorStatus (T_e8_Aud_ErrorStatus ErrorStatus_);

    // API of field "RoutineStatus"

    static const int kRoutineStatus = 2;

    /**
     * Clears the field "RoutineStatus".
     *
     * The field will be set to its default value. The hasRoutineStatus()
     * method will return false.
     */
    inline void clearRoutineStatus();

    /**
     * Checks whether the field "RoutineStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRoutineStatus()). Otherwise it will return false.
     */
    inline bool hasRoutineStatus () const;

    /**
     * Returns the value of the member "RoutineStatus".
     *
     * Status of test routine
     *
     * @return The value of the field "RoutineStatus"
     */
    inline T_e8_Aud_RoutineStatus getRoutineStatus () const;

    /**
     * Sets the value of the member "RoutineStatus".
     *
     * Status of test routine
     *
     * @param RoutineStatus The value which will be set
     */
    inline void setRoutineStatus (T_e8_Aud_RoutineStatus RoutineStatus_);

    // API of field "DiagnosisLogWrite"

    static const int kDiagnosisLogWrite = 3;

    /**
     * Clears the field "DiagnosisLogWrite".
     *
     * The field will be set to its default value. The hasDiagnosisLogWrite()
     * method will return false.
     */
    inline void clearDiagnosisLogWrite();

    /**
     * Checks whether the field "DiagnosisLogWrite" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDiagnosisLogWrite()). Otherwise it will return false.
     */
    inline bool hasDiagnosisLogWrite () const;

    /**
     * Returns the value of the member "DiagnosisLogWrite".
     *
     * Parameter which requests Write into Diagnosis Log
     *
     * @return The value of the field "DiagnosisLogWrite"
     */
    inline T_e8_Aud_WriteTestErrorStatus getDiagnosisLogWrite () const;

    /**
     * Sets the value of the member "DiagnosisLogWrite".
     *
     * Parameter which requests Write into Diagnosis Log
     *
     * @param DiagnosisLogWrite The value which will be set
     */
    inline void setDiagnosisLogWrite (T_e8_Aud_WriteTestErrorStatus DiagnosisLogWrite_);

    static const T_Aud_TestTroubleCodeStatus &getDefaultInstance();

private:

    inline void set_has_TroubleCode ();

    inline void clear_has_TroubleCode ();

    inline void set_has_ErrorStatus ();

    inline void clear_has_ErrorStatus ();

    inline void set_has_RoutineStatus ();

    inline void clear_has_RoutineStatus ();

    inline void set_has_DiagnosisLogWrite ();

    inline void clear_has_DiagnosisLogWrite ();

    uint32 _has_bits_[ (4 + 31) / 32];

    T_e16_Aud_TroubleCode _TroubleCode;

    T_e8_Aud_ErrorStatus _ErrorStatus;

    T_e8_Aud_RoutineStatus _RoutineStatus;

    T_e8_Aud_WriteTestErrorStatus _DiagnosisLogWrite;

};

/**
 * If the meaning of "T_MicrophoneConnectionStatus" isn't clear, then there should be a description here.
 */
class T_MicrophoneConnectionStatus {
public:

    /**
     * Default constructor
     */
    inline  T_MicrophoneConnectionStatus ();

    /**
     * Copy constructor
     */
    inline  T_MicrophoneConnectionStatus (const T_MicrophoneConnectionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  T_MicrophoneConnectionStatus (T_e8_MicrophoneNumber e8MicrophoneNumber_, uint16 u16MicrophoneCurrent_, T_e8_MicrophoneConnectionStatus e8MicrophoneConnectionStatus_, T_e8_MicrophoneDetection e8MicrophoneDetection_);

    /**
     * Destructor
     */
    inline  ~T_MicrophoneConnectionStatus();

    /**
     * Assignment operator
     */
    inline T_MicrophoneConnectionStatus& operator = (const T_MicrophoneConnectionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MicrophoneConnectionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MicrophoneConnectionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MicrophoneConnectionStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MicrophoneConnectionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MicrophoneNumber"

    static const int kE8MicrophoneNumber = 0;

    /**
     * Clears the field "e8MicrophoneNumber".
     *
     * The field will be set to its default value. The hasE8MicrophoneNumber()
     * method will return false.
     */
    inline void clearE8MicrophoneNumber();

    /**
     * Checks whether the field "e8MicrophoneNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MicrophoneNumber()). Otherwise it will return false.
     */
    inline bool hasE8MicrophoneNumber () const;

    /**
     * Returns the value of the member "e8MicrophoneNumber".
     *
     * Microphone Number. If there are 2 Microphones is MIC_1 or MIC_2.
     *
     * @return The value of the field "e8MicrophoneNumber"
     */
    inline T_e8_MicrophoneNumber getE8MicrophoneNumber () const;

    /**
     * Sets the value of the member "e8MicrophoneNumber".
     *
     * Microphone Number. If there are 2 Microphones is MIC_1 or MIC_2.
     *
     * @param e8MicrophoneNumber The value which will be set
     */
    inline void setE8MicrophoneNumber (T_e8_MicrophoneNumber e8MicrophoneNumber_);

    // API of field "u16MicrophoneCurrent"

    static const int kU16MicrophoneCurrent = 1;

    /**
     * Clears the field "u16MicrophoneCurrent".
     *
     * The field will be set to its default value. The hasU16MicrophoneCurrent()
     * method will return false.
     */
    inline void clearU16MicrophoneCurrent();

    /**
     * Checks whether the field "u16MicrophoneCurrent" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16MicrophoneCurrent()). Otherwise it will return false.
     */
    inline bool hasU16MicrophoneCurrent () const;

    /**
     * Returns the value of the member "u16MicrophoneCurrent".
     *
     * Last measured microphone current. Value is given in 1/10 mA.
     *
     * @return The value of the field "u16MicrophoneCurrent"
     */
    inline uint16 getU16MicrophoneCurrent () const;

    /**
     * Sets the value of the member "u16MicrophoneCurrent".
     *
     * Last measured microphone current. Value is given in 1/10 mA.
     *
     * @param u16MicrophoneCurrent The value which will be set
     */
    inline void setU16MicrophoneCurrent (uint16 u16MicrophoneCurrent_);

    // API of field "e8MicrophoneConnectionStatus"

    static const int kE8MicrophoneConnectionStatus = 2;

    /**
     * Clears the field "e8MicrophoneConnectionStatus".
     *
     * The field will be set to its default value. The hasE8MicrophoneConnectionStatus()
     * method will return false.
     */
    inline void clearE8MicrophoneConnectionStatus();

    /**
     * Checks whether the field "e8MicrophoneConnectionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MicrophoneConnectionStatus()). Otherwise it will return false.
     */
    inline bool hasE8MicrophoneConnectionStatus () const;

    /**
     * Returns the value of the member "e8MicrophoneConnectionStatus".
     *
     * Last status of microphone connection.
     *
     * @return The value of the field "e8MicrophoneConnectionStatus"
     */
    inline T_e8_MicrophoneConnectionStatus getE8MicrophoneConnectionStatus () const;

    /**
     * Sets the value of the member "e8MicrophoneConnectionStatus".
     *
     * Last status of microphone connection.
     *
     * @param e8MicrophoneConnectionStatus The value which will be set
     */
    inline void setE8MicrophoneConnectionStatus (T_e8_MicrophoneConnectionStatus e8MicrophoneConnectionStatus_);

    // API of field "e8MicrophoneDetection"

    static const int kE8MicrophoneDetection = 3;

    /**
     * Clears the field "e8MicrophoneDetection".
     *
     * The field will be set to its default value. The hasE8MicrophoneDetection()
     * method will return false.
     */
    inline void clearE8MicrophoneDetection();

    /**
     * Checks whether the field "e8MicrophoneDetection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MicrophoneDetection()). Otherwise it will return false.
     */
    inline bool hasE8MicrophoneDetection () const;

    /**
     * Returns the value of the member "e8MicrophoneDetection".
     *
     * Last status of microphone detection pin.
     *
     * @return The value of the field "e8MicrophoneDetection"
     */
    inline T_e8_MicrophoneDetection getE8MicrophoneDetection () const;

    /**
     * Sets the value of the member "e8MicrophoneDetection".
     *
     * Last status of microphone detection pin.
     *
     * @param e8MicrophoneDetection The value which will be set
     */
    inline void setE8MicrophoneDetection (T_e8_MicrophoneDetection e8MicrophoneDetection_);

    static const T_MicrophoneConnectionStatus &getDefaultInstance();

private:

    inline void set_has_e8MicrophoneNumber ();

    inline void clear_has_e8MicrophoneNumber ();

    inline void set_has_u16MicrophoneCurrent ();

    inline void clear_has_u16MicrophoneCurrent ();

    inline void set_has_e8MicrophoneConnectionStatus ();

    inline void clear_has_e8MicrophoneConnectionStatus ();

    inline void set_has_e8MicrophoneDetection ();

    inline void clear_has_e8MicrophoneDetection ();

    uint32 _has_bits_[ (4 + 31) / 32];

    T_e8_MicrophoneNumber _e8MicrophoneNumber;

    uint16 _u16MicrophoneCurrent;

    T_e8_MicrophoneConnectionStatus _e8MicrophoneConnectionStatus;

    T_e8_MicrophoneDetection _e8MicrophoneDetection;

};

/**
 * Gives a volume value and describe in parameter type how the volume value should be interpreted
 */
class T_Volume {
public:

    /**
     * Default constructor
     */
    inline  T_Volume ();

    /**
     * Copy constructor
     */
    inline  T_Volume (const T_Volume &rhs);

    /**
     * All fields constructor
     */
    inline  T_Volume (T_e8_VolumeType e8VolType_, int16 s16Volume_);

    /**
     * Destructor
     */
    inline  ~T_Volume();

    /**
     * Assignment operator
     */
    inline T_Volume& operator = (const T_Volume& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Volume& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Volume& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Volume& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Volume& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8VolType"

    static const int kE8VolType = 0;

    /**
     * Clears the field "e8VolType".
     *
     * The field will be set to its default value. The hasE8VolType()
     * method will return false.
     */
    inline void clearE8VolType();

    /**
     * Checks whether the field "e8VolType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8VolType()). Otherwise it will return false.
     */
    inline bool hasE8VolType () const;

    /**
     * Returns the value of the member "e8VolType".
     *
     * Describe how the following value should be interpreted.
     *
     * @return The value of the field "e8VolType"
     */
    inline T_e8_VolumeType getE8VolType () const;

    /**
     * Sets the value of the member "e8VolType".
     *
     * Describe how the following value should be interpreted.
     *
     * @param e8VolType The value which will be set
     */
    inline void setE8VolType (T_e8_VolumeType e8VolType_);

    // API of field "s16Volume"

    static const int kS16Volume = 1;

    /**
     * Clears the field "s16Volume".
     *
     * The field will be set to its default value. The hasS16Volume()
     * method will return false.
     */
    inline void clearS16Volume();

    /**
     * Checks whether the field "s16Volume" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16Volume()). Otherwise it will return false.
     */
    inline bool hasS16Volume () const;

    /**
     * Returns the value of the member "s16Volume".
     *
     * Actual Volume Loudspeakers Exclusive.
     *
     * @return The value of the field "s16Volume"
     */
    inline int16 getS16Volume () const;

    /**
     * Sets the value of the member "s16Volume".
     *
     * Actual Volume Loudspeakers Exclusive.
     *
     * @param s16Volume The value which will be set
     */
    inline void setS16Volume (int16 s16Volume_);

    static const T_Volume &getDefaultInstance();

private:

    inline void set_has_e8VolType ();

    inline void clear_has_e8VolType ();

    inline void set_has_s16Volume ();

    inline void clear_has_s16Volume ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_VolumeType _e8VolType;

    int16 _s16Volume;

};

/**
 * Select one Tuner Hicut and Sharx settings.
 */
class T_b8_ChannelSelect {
public:

    /**
     * Default constructor
     */
    inline  T_b8_ChannelSelect ();

    /**
     * Copy constructor
     */
    inline  T_b8_ChannelSelect (const T_b8_ChannelSelect &c);

    /**
     * Field constructor
     */
    inline  T_b8_ChannelSelect (bool CHANNEL_LF, bool CHANNEL_RF, bool CHANNEL_LR, bool CHANNEL_RR, bool CHANNEL_CENT, bool CHANNEL_SUB);

    /**
     * Assignment operator
     */
    inline T_b8_ChannelSelect& operator = (const T_b8_ChannelSelect& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_ChannelSelect& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_ChannelSelect& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_ChannelSelect& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_ChannelSelect& rhs) const;

    /**
     * Sets the value of the member "CHANNEL_LF".
     *
     * If the meaning of "CHANNEL_LF" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_LF The value which will be set
     */
    inline void setCHANNEL_LF (bool CHANNEL_LF);

    /**
     * Returns the value of the member "CHANNEL_LF".
     *
     * If the meaning of "CHANNEL_LF" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_LF"
     */
    inline bool getCHANNEL_LF () const;

    /**
     * Sets the value of the member "CHANNEL_RF".
     *
     * If the meaning of "CHANNEL_RF" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_RF The value which will be set
     */
    inline void setCHANNEL_RF (bool CHANNEL_RF);

    /**
     * Returns the value of the member "CHANNEL_RF".
     *
     * If the meaning of "CHANNEL_RF" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_RF"
     */
    inline bool getCHANNEL_RF () const;

    /**
     * Sets the value of the member "CHANNEL_LR".
     *
     * If the meaning of "CHANNEL_LR" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_LR The value which will be set
     */
    inline void setCHANNEL_LR (bool CHANNEL_LR);

    /**
     * Returns the value of the member "CHANNEL_LR".
     *
     * If the meaning of "CHANNEL_LR" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_LR"
     */
    inline bool getCHANNEL_LR () const;

    /**
     * Sets the value of the member "CHANNEL_RR".
     *
     * If the meaning of "CHANNEL_RR" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_RR The value which will be set
     */
    inline void setCHANNEL_RR (bool CHANNEL_RR);

    /**
     * Returns the value of the member "CHANNEL_RR".
     *
     * If the meaning of "CHANNEL_RR" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_RR"
     */
    inline bool getCHANNEL_RR () const;

    /**
     * Sets the value of the member "CHANNEL_CENT".
     *
     * If the meaning of "CHANNEL_CENT" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_CENT The value which will be set
     */
    inline void setCHANNEL_CENT (bool CHANNEL_CENT);

    /**
     * Returns the value of the member "CHANNEL_CENT".
     *
     * If the meaning of "CHANNEL_CENT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_CENT"
     */
    inline bool getCHANNEL_CENT () const;

    /**
     * Sets the value of the member "CHANNEL_SUB".
     *
     * If the meaning of "CHANNEL_SUB" isn't clear, then there should be a description here.
     *
     * @param CHANNEL_SUB The value which will be set
     */
    inline void setCHANNEL_SUB (bool CHANNEL_SUB);

    /**
     * Returns the value of the member "CHANNEL_SUB".
     *
     * If the meaning of "CHANNEL_SUB" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CHANNEL_SUB"
     */
    inline bool getCHANNEL_SUB () const;

    static const T_b8_ChannelSelect &getDefaultInstance();

private:

    bool _CHANNEL_LF:1;

    bool _CHANNEL_RF:1;

    bool _CHANNEL_LR:1;

    bool _CHANNEL_RR:1;

    bool _CHANNEL_CENT:1;

    bool _CHANNEL_SUB:1;

};

/**
 * Configuration to play the requested beep.
 */
class T_BeepConfig {
public:

    /**
     * Default constructor
     */
    inline  T_BeepConfig ();

    /**
     * Copy constructor
     */
    inline  T_BeepConfig (const T_BeepConfig &rhs);

    /**
     * All fields constructor
     */
    inline  T_BeepConfig (T_e8_Aud_Beep_Vol_Type e8VolType_, int16 s16VoldB_);

    /**
     * Destructor
     */
    inline  ~T_BeepConfig();

    /**
     * Assignment operator
     */
    inline T_BeepConfig& operator = (const T_BeepConfig& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BeepConfig& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BeepConfig& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BeepConfig& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BeepConfig& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8VolType"

    static const int kE8VolType = 0;

    /**
     * Clears the field "e8VolType".
     *
     * The field will be set to its default value. The hasE8VolType()
     * method will return false.
     */
    inline void clearE8VolType();

    /**
     * Checks whether the field "e8VolType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8VolType()). Otherwise it will return false.
     */
    inline bool hasE8VolType () const;

    /**
     * Returns the value of the member "e8VolType".
     *
     * Describe whether the System Defaults have to be used to play beep file or if the user specified volume has to be used.
     *
     * @return The value of the field "e8VolType"
     */
    inline T_e8_Aud_Beep_Vol_Type getE8VolType () const;

    /**
     * Sets the value of the member "e8VolType".
     *
     * Describe whether the System Defaults have to be used to play beep file or if the user specified volume has to be used.
     *
     * @param e8VolType The value which will be set
     */
    inline void setE8VolType (T_e8_Aud_Beep_Vol_Type e8VolType_);

    // API of field "s16VoldB"

    static const int kS16VoldB = 1;

    /**
     * Clears the field "s16VoldB".
     *
     * The field will be set to its default value. The hasS16VoldB()
     * method will return false.
     */
    inline void clearS16VoldB();

    /**
     * Checks whether the field "s16VoldB" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16VoldB()). Otherwise it will return false.
     */
    inline bool hasS16VoldB () const;

    /**
     * Returns the value of the member "s16VoldB".
     *
     * This field would be considered if the volume type is set to User Specific. Supported dB Ranges is 0 (louder) to -120 (Muted) dB.
     *
     * @return The value of the field "s16VoldB"
     */
    inline int16 getS16VoldB () const;

    /**
     * Sets the value of the member "s16VoldB".
     *
     * This field would be considered if the volume type is set to User Specific. Supported dB Ranges is 0 (louder) to -120 (Muted) dB.
     *
     * @param s16VoldB The value which will be set
     */
    inline void setS16VoldB (int16 s16VoldB_);

    static const T_BeepConfig &getDefaultInstance();

private:

    inline void set_has_e8VolType ();

    inline void clear_has_e8VolType ();

    inline void set_has_s16VoldB ();

    inline void clear_has_s16VoldB ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_Aud_Beep_Vol_Type _e8VolType;

    int16 _s16VoldB;

};

/**
 * If the meaning of "T_Aud_VolumeStatus" isn't clear, then there should be a description here.
 */
class T_Aud_VolumeStatus {
public:

    /**
     * Default constructor
     */
    inline  T_Aud_VolumeStatus ();

    /**
     * Copy constructor
     */
    inline  T_Aud_VolumeStatus (const T_Aud_VolumeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  T_Aud_VolumeStatus (T_e8_Aud_VolumeType AudVolumeType_, uint8 Volume_);

    /**
     * Destructor
     */
    inline  ~T_Aud_VolumeStatus();

    /**
     * Assignment operator
     */
    inline T_Aud_VolumeStatus& operator = (const T_Aud_VolumeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Aud_VolumeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Aud_VolumeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Aud_VolumeStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Aud_VolumeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudVolumeType"

    static const int kAudVolumeType = 0;

    /**
     * Clears the field "AudVolumeType".
     *
     * The field will be set to its default value. The hasAudVolumeType()
     * method will return false.
     */
    inline void clearAudVolumeType();

    /**
     * Checks whether the field "AudVolumeType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudVolumeType()). Otherwise it will return false.
     */
    inline bool hasAudVolumeType () const;

    /**
     * Returns the value of the member "AudVolumeType".
     *
     * The AudVolumeType in which source is indexed.
     *
     * @return The value of the field "AudVolumeType"
     */
    inline T_e8_Aud_VolumeType getAudVolumeType () const;

    /**
     * Sets the value of the member "AudVolumeType".
     *
     * The AudVolumeType in which source is indexed.
     *
     * @param AudVolumeType The value which will be set
     */
    inline void setAudVolumeType (T_e8_Aud_VolumeType AudVolumeType_);

    // API of field "Volume"

    static const int kVolume = 1;

    /**
     * Clears the field "Volume".
     *
     * The field will be set to its default value. The hasVolume()
     * method will return false.
     */
    inline void clearVolume();

    /**
     * Checks whether the field "Volume" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVolume()). Otherwise it will return false.
     */
    inline bool hasVolume () const;

    /**
     * Returns the value of the member "Volume".
     *
     * The Volume value of AudVolumeTypes.
     *
     * @return The value of the field "Volume"
     */
    inline uint8 getVolume () const;

    /**
     * Sets the value of the member "Volume".
     *
     * The Volume value of AudVolumeTypes.
     *
     * @param Volume The value which will be set
     */
    inline void setVolume (uint8 Volume_);

    static const T_Aud_VolumeStatus &getDefaultInstance();

private:

    inline void set_has_AudVolumeType ();

    inline void clear_has_AudVolumeType ();

    inline void set_has_Volume ();

    inline void clear_has_Volume ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_Aud_VolumeType _AudVolumeType;

    uint8 _Volume;

};

/**
 * If the meaning of "T_Aud_EDStatus" isn't clear, then there should be a description here.
 */
class T_Aud_EDStatus {
public:

    /**
     * Default constructor
     */
    inline  T_Aud_EDStatus ();

    /**
     * Copy constructor
     */
    inline  T_Aud_EDStatus (const T_Aud_EDStatus &rhs);

    /**
     * All fields constructor
     */
    inline  T_Aud_EDStatus (T_e8_Aud_EDType AudEDType_, int32 EDValue_);

    /**
     * Destructor
     */
    inline  ~T_Aud_EDStatus();

    /**
     * Assignment operator
     */
    inline T_Aud_EDStatus& operator = (const T_Aud_EDStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Aud_EDStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Aud_EDStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Aud_EDStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Aud_EDStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudEDType"

    static const int kAudEDType = 0;

    /**
     * Clears the field "AudEDType".
     *
     * The field will be set to its default value. The hasAudEDType()
     * method will return false.
     */
    inline void clearAudEDType();

    /**
     * Checks whether the field "AudEDType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudEDType()). Otherwise it will return false.
     */
    inline bool hasAudEDType () const;

    /**
     * Returns the value of the member "AudEDType".
     *
     * The Audio EngineeringData Type is indexed.
     *
     * @return The value of the field "AudEDType"
     */
    inline T_e8_Aud_EDType getAudEDType () const;

    /**
     * Sets the value of the member "AudEDType".
     *
     * The Audio EngineeringData Type is indexed.
     *
     * @param AudEDType The value which will be set
     */
    inline void setAudEDType (T_e8_Aud_EDType AudEDType_);

    // API of field "EDValue"

    static const int kEDValue = 1;

    /**
     * Clears the field "EDValue".
     *
     * The field will be set to its default value. The hasEDValue()
     * method will return false.
     */
    inline void clearEDValue();

    /**
     * Checks whether the field "EDValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEDValue()). Otherwise it will return false.
     */
    inline bool hasEDValue () const;

    /**
     * Returns the value of the member "EDValue".
     *
     * The EngineeringData value of EDType.
     *
     * @return The value of the field "EDValue"
     */
    inline int32 getEDValue () const;

    /**
     * Sets the value of the member "EDValue".
     *
     * The EngineeringData value of EDType.
     *
     * @param EDValue The value which will be set
     */
    inline void setEDValue (int32 EDValue_);

    static const T_Aud_EDStatus &getDefaultInstance();

private:

    inline void set_has_AudEDType ();

    inline void clear_has_AudEDType ();

    inline void set_has_EDValue ();

    inline void clear_has_EDValue ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_Aud_EDType _AudEDType;

    int32 _EDValue;

};

/**
 * Result for one channel of each error type. Different errors can be combined in the bitfield.
 */
class T_b32_MeasurementResult {
public:

    /**
     * Default constructor
     */
    inline  T_b32_MeasurementResult ();

    /**
     * Copy constructor
     */
    inline  T_b32_MeasurementResult (const T_b32_MeasurementResult &c);

    /**
     * Field constructor
     */
    inline  T_b32_MeasurementResult (bool SHORT_TO_GROUND_OK, bool SHORT_TO_GROUND_ERROR, bool SHORT_TO_GROUND_NOT_TESTED, bool SHORT_TO_GROUND_CONDITION_NOK, bool SHORT_TO_BATTERY_OK, bool SHORT_TO_BATTERY_ERROR, bool SHORT_TO_BATTERY_NOT_TESTED, bool SHORT_TO_BATTERY_CONDITION_NOK, bool SHORTED_LOAD_OK, bool SHORTED_LOAD_ERROR, bool SHORTED_LOAD_NOT_TESTED, bool SHORTED_LOAD_CONDITION_NOK, bool WOOFER_OPEN_LOAD_OK, bool WOOFER_OPEN_LOAD_ERROR, bool WOOFER_OPEN_LOAD_NOT_TESTED, bool WOOFER_OPEN_LOAD_CONDITION_NOK, bool TWEETER_OPEN_LOAD_OK, bool TWEETER_OPEN_LOAD_ERROR, bool TWEETER_OPEN_LOAD_NOT_TESTED, bool TWEETER_OPEN_LOAD_CONDITION_NOK, bool DC_DIAGMODE_UNQUALIFIED, bool DC_DIAGMODE_QUALIFIED, bool AC_DIAGMODE_UNQUALIFIED, bool AC_DIAGMODE_QUALIFIED, bool WOOFER_AVAILABILITY, bool TWEETER_AVAILABILITY);

    /**
     * Assignment operator
     */
    inline T_b32_MeasurementResult& operator = (const T_b32_MeasurementResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b32_MeasurementResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b32_MeasurementResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b32_MeasurementResult& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b32_MeasurementResult& rhs) const;

    /**
     * Sets the value of the member "SHORT_TO_GROUND_OK".
     *
     * If the meaning of "SHORT_TO_GROUND_OK" isn't clear, then there should be a description here.
     *
     * @param SHORT_TO_GROUND_OK The value which will be set
     */
    inline void setSHORT_TO_GROUND_OK (bool SHORT_TO_GROUND_OK);

    /**
     * Returns the value of the member "SHORT_TO_GROUND_OK".
     *
     * If the meaning of "SHORT_TO_GROUND_OK" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SHORT_TO_GROUND_OK"
     */
    inline bool getSHORT_TO_GROUND_OK () const;

    /**
     * Sets the value of the member "SHORT_TO_GROUND_ERROR".
     *
     * If the meaning of "SHORT_TO_GROUND_ERROR" isn't clear, then there should be a description here.
     *
     * @param SHORT_TO_GROUND_ERROR The value which will be set
     */
    inline void setSHORT_TO_GROUND_ERROR (bool SHORT_TO_GROUND_ERROR);

    /**
     * Returns the value of the member "SHORT_TO_GROUND_ERROR".
     *
     * If the meaning of "SHORT_TO_GROUND_ERROR" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SHORT_TO_GROUND_ERROR"
     */
    inline bool getSHORT_TO_GROUND_ERROR () const;

    /**
     * Sets the value of the member "SHORT_TO_GROUND_NOT_TESTED".
     *
     * If the meaning of "SHORT_TO_GROUND_NOT_TESTED" isn't clear, then there should be a description here.
     *
     * @param SHORT_TO_GROUND_NOT_TESTED The value which will be set
     */
    inline void setSHORT_TO_GROUND_NOT_TESTED (bool SHORT_TO_GROUND_NOT_TESTED);

    /**
     * Returns the value of the member "SHORT_TO_GROUND_NOT_TESTED".
     *
     * If the meaning of "SHORT_TO_GROUND_NOT_TESTED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SHORT_TO_GROUND_NOT_TESTED"
     */
    inline bool getSHORT_TO_GROUND_NOT_TESTED () const;

    /**
     * Sets the value of the member "SHORT_TO_GROUND_CONDITION_NOK".
     *
     * If the meaning of "SHORT_TO_GROUND_CONDITION_NOK" isn't clear, then there should be a description here.
     *
     * @param SHORT_TO_GROUND_CONDITION_NOK The value which will be set
     */
    inline void setSHORT_TO_GROUND_CONDITION_NOK (bool SHORT_TO_GROUND_CONDITION_NOK);

    /**
     * Returns the value of the member "SHORT_TO_GROUND_CONDITION_NOK".
     *
     * If the meaning of "SHORT_TO_GROUND_CONDITION_NOK" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SHORT_TO_GROUND_CONDITION_NOK"
     */
    inline bool getSHORT_TO_GROUND_CONDITION_NOK () const;

    /**
     * Sets the value of the member "SHORT_TO_BATTERY_OK".
     *
     * If the meaning of "SHORT_TO_BATTERY_OK" isn't clear, then there should be a description here.
     *
     * @param SHORT_TO_BATTERY_OK The value which will be set
     */
    inline void setSHORT_TO_BATTERY_OK (bool SHORT_TO_BATTERY_OK);

    /**
     * Returns the value of the member "SHORT_TO_BATTERY_OK".
     *
     * If the meaning of "SHORT_TO_BATTERY_OK" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SHORT_TO_BATTERY_OK"
     */
    inline bool getSHORT_TO_BATTERY_OK () const;

    /**
     * Sets the value of the member "SHORT_TO_BATTERY_ERROR".
     *
     * If the meaning of "SHORT_TO_BATTERY_ERROR" isn't clear, then there should be a description here.
     *
     * @param SHORT_TO_BATTERY_ERROR The value which will be set
     */
    inline void setSHORT_TO_BATTERY_ERROR (bool SHORT_TO_BATTERY_ERROR);

    /**
     * Returns the value of the member "SHORT_TO_BATTERY_ERROR".
     *
     * If the meaning of "SHORT_TO_BATTERY_ERROR" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SHORT_TO_BATTERY_ERROR"
     */
    inline bool getSHORT_TO_BATTERY_ERROR () const;

    /**
     * Sets the value of the member "SHORT_TO_BATTERY_NOT_TESTED".
     *
     * If the meaning of "SHORT_TO_BATTERY_NOT_TESTED" isn't clear, then there should be a description here.
     *
     * @param SHORT_TO_BATTERY_NOT_TESTED The value which will be set
     */
    inline void setSHORT_TO_BATTERY_NOT_TESTED (bool SHORT_TO_BATTERY_NOT_TESTED);

    /**
     * Returns the value of the member "SHORT_TO_BATTERY_NOT_TESTED".
     *
     * If the meaning of "SHORT_TO_BATTERY_NOT_TESTED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SHORT_TO_BATTERY_NOT_TESTED"
     */
    inline bool getSHORT_TO_BATTERY_NOT_TESTED () const;

    /**
     * Sets the value of the member "SHORT_TO_BATTERY_CONDITION_NOK".
     *
     * If the meaning of "SHORT_TO_BATTERY_CONDITION_NOK" isn't clear, then there should be a description here.
     *
     * @param SHORT_TO_BATTERY_CONDITION_NOK The value which will be set
     */
    inline void setSHORT_TO_BATTERY_CONDITION_NOK (bool SHORT_TO_BATTERY_CONDITION_NOK);

    /**
     * Returns the value of the member "SHORT_TO_BATTERY_CONDITION_NOK".
     *
     * If the meaning of "SHORT_TO_BATTERY_CONDITION_NOK" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SHORT_TO_BATTERY_CONDITION_NOK"
     */
    inline bool getSHORT_TO_BATTERY_CONDITION_NOK () const;

    /**
     * Sets the value of the member "SHORTED_LOAD_OK".
     *
     * If the meaning of "SHORTED_LOAD_OK" isn't clear, then there should be a description here.
     *
     * @param SHORTED_LOAD_OK The value which will be set
     */
    inline void setSHORTED_LOAD_OK (bool SHORTED_LOAD_OK);

    /**
     * Returns the value of the member "SHORTED_LOAD_OK".
     *
     * If the meaning of "SHORTED_LOAD_OK" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SHORTED_LOAD_OK"
     */
    inline bool getSHORTED_LOAD_OK () const;

    /**
     * Sets the value of the member "SHORTED_LOAD_ERROR".
     *
     * If the meaning of "SHORTED_LOAD_ERROR" isn't clear, then there should be a description here.
     *
     * @param SHORTED_LOAD_ERROR The value which will be set
     */
    inline void setSHORTED_LOAD_ERROR (bool SHORTED_LOAD_ERROR);

    /**
     * Returns the value of the member "SHORTED_LOAD_ERROR".
     *
     * If the meaning of "SHORTED_LOAD_ERROR" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SHORTED_LOAD_ERROR"
     */
    inline bool getSHORTED_LOAD_ERROR () const;

    /**
     * Sets the value of the member "SHORTED_LOAD_NOT_TESTED".
     *
     * If the meaning of "SHORTED_LOAD_NOT_TESTED" isn't clear, then there should be a description here.
     *
     * @param SHORTED_LOAD_NOT_TESTED The value which will be set
     */
    inline void setSHORTED_LOAD_NOT_TESTED (bool SHORTED_LOAD_NOT_TESTED);

    /**
     * Returns the value of the member "SHORTED_LOAD_NOT_TESTED".
     *
     * If the meaning of "SHORTED_LOAD_NOT_TESTED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SHORTED_LOAD_NOT_TESTED"
     */
    inline bool getSHORTED_LOAD_NOT_TESTED () const;

    /**
     * Sets the value of the member "SHORTED_LOAD_CONDITION_NOK".
     *
     * If the meaning of "SHORTED_LOAD_CONDITION_NOK" isn't clear, then there should be a description here.
     *
     * @param SHORTED_LOAD_CONDITION_NOK The value which will be set
     */
    inline void setSHORTED_LOAD_CONDITION_NOK (bool SHORTED_LOAD_CONDITION_NOK);

    /**
     * Returns the value of the member "SHORTED_LOAD_CONDITION_NOK".
     *
     * If the meaning of "SHORTED_LOAD_CONDITION_NOK" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SHORTED_LOAD_CONDITION_NOK"
     */
    inline bool getSHORTED_LOAD_CONDITION_NOK () const;

    /**
     * Sets the value of the member "WOOFER_OPEN_LOAD_OK".
     *
     * If the meaning of "WOOFER_OPEN_LOAD_OK" isn't clear, then there should be a description here.
     *
     * @param WOOFER_OPEN_LOAD_OK The value which will be set
     */
    inline void setWOOFER_OPEN_LOAD_OK (bool WOOFER_OPEN_LOAD_OK);

    /**
     * Returns the value of the member "WOOFER_OPEN_LOAD_OK".
     *
     * If the meaning of "WOOFER_OPEN_LOAD_OK" isn't clear, then there should be a description here.
     *
     * @return The value of the field "WOOFER_OPEN_LOAD_OK"
     */
    inline bool getWOOFER_OPEN_LOAD_OK () const;

    /**
     * Sets the value of the member "WOOFER_OPEN_LOAD_ERROR".
     *
     * If the meaning of "WOOFER_OPEN_LOAD_ERROR" isn't clear, then there should be a description here.
     *
     * @param WOOFER_OPEN_LOAD_ERROR The value which will be set
     */
    inline void setWOOFER_OPEN_LOAD_ERROR (bool WOOFER_OPEN_LOAD_ERROR);

    /**
     * Returns the value of the member "WOOFER_OPEN_LOAD_ERROR".
     *
     * If the meaning of "WOOFER_OPEN_LOAD_ERROR" isn't clear, then there should be a description here.
     *
     * @return The value of the field "WOOFER_OPEN_LOAD_ERROR"
     */
    inline bool getWOOFER_OPEN_LOAD_ERROR () const;

    /**
     * Sets the value of the member "WOOFER_OPEN_LOAD_NOT_TESTED".
     *
     * If the meaning of "WOOFER_OPEN_LOAD_NOT_TESTED" isn't clear, then there should be a description here.
     *
     * @param WOOFER_OPEN_LOAD_NOT_TESTED The value which will be set
     */
    inline void setWOOFER_OPEN_LOAD_NOT_TESTED (bool WOOFER_OPEN_LOAD_NOT_TESTED);

    /**
     * Returns the value of the member "WOOFER_OPEN_LOAD_NOT_TESTED".
     *
     * If the meaning of "WOOFER_OPEN_LOAD_NOT_TESTED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "WOOFER_OPEN_LOAD_NOT_TESTED"
     */
    inline bool getWOOFER_OPEN_LOAD_NOT_TESTED () const;

    /**
     * Sets the value of the member "WOOFER_OPEN_LOAD_CONDITION_NOK".
     *
     * If the meaning of "WOOFER_OPEN_LOAD_CONDITION_NOK" isn't clear, then there should be a description here.
     *
     * @param WOOFER_OPEN_LOAD_CONDITION_NOK The value which will be set
     */
    inline void setWOOFER_OPEN_LOAD_CONDITION_NOK (bool WOOFER_OPEN_LOAD_CONDITION_NOK);

    /**
     * Returns the value of the member "WOOFER_OPEN_LOAD_CONDITION_NOK".
     *
     * If the meaning of "WOOFER_OPEN_LOAD_CONDITION_NOK" isn't clear, then there should be a description here.
     *
     * @return The value of the field "WOOFER_OPEN_LOAD_CONDITION_NOK"
     */
    inline bool getWOOFER_OPEN_LOAD_CONDITION_NOK () const;

    /**
     * Sets the value of the member "TWEETER_OPEN_LOAD_OK".
     *
     * If the meaning of "TWEETER_OPEN_LOAD_OK" isn't clear, then there should be a description here.
     *
     * @param TWEETER_OPEN_LOAD_OK The value which will be set
     */
    inline void setTWEETER_OPEN_LOAD_OK (bool TWEETER_OPEN_LOAD_OK);

    /**
     * Returns the value of the member "TWEETER_OPEN_LOAD_OK".
     *
     * If the meaning of "TWEETER_OPEN_LOAD_OK" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TWEETER_OPEN_LOAD_OK"
     */
    inline bool getTWEETER_OPEN_LOAD_OK () const;

    /**
     * Sets the value of the member "TWEETER_OPEN_LOAD_ERROR".
     *
     * If the meaning of "TWEETER_OPEN_LOAD_ERROR" isn't clear, then there should be a description here.
     *
     * @param TWEETER_OPEN_LOAD_ERROR The value which will be set
     */
    inline void setTWEETER_OPEN_LOAD_ERROR (bool TWEETER_OPEN_LOAD_ERROR);

    /**
     * Returns the value of the member "TWEETER_OPEN_LOAD_ERROR".
     *
     * If the meaning of "TWEETER_OPEN_LOAD_ERROR" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TWEETER_OPEN_LOAD_ERROR"
     */
    inline bool getTWEETER_OPEN_LOAD_ERROR () const;

    /**
     * Sets the value of the member "TWEETER_OPEN_LOAD_NOT_TESTED".
     *
     * If the meaning of "TWEETER_OPEN_LOAD_NOT_TESTED" isn't clear, then there should be a description here.
     *
     * @param TWEETER_OPEN_LOAD_NOT_TESTED The value which will be set
     */
    inline void setTWEETER_OPEN_LOAD_NOT_TESTED (bool TWEETER_OPEN_LOAD_NOT_TESTED);

    /**
     * Returns the value of the member "TWEETER_OPEN_LOAD_NOT_TESTED".
     *
     * If the meaning of "TWEETER_OPEN_LOAD_NOT_TESTED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TWEETER_OPEN_LOAD_NOT_TESTED"
     */
    inline bool getTWEETER_OPEN_LOAD_NOT_TESTED () const;

    /**
     * Sets the value of the member "TWEETER_OPEN_LOAD_CONDITION_NOK".
     *
     * If the meaning of "TWEETER_OPEN_LOAD_CONDITION_NOK" isn't clear, then there should be a description here.
     *
     * @param TWEETER_OPEN_LOAD_CONDITION_NOK The value which will be set
     */
    inline void setTWEETER_OPEN_LOAD_CONDITION_NOK (bool TWEETER_OPEN_LOAD_CONDITION_NOK);

    /**
     * Returns the value of the member "TWEETER_OPEN_LOAD_CONDITION_NOK".
     *
     * If the meaning of "TWEETER_OPEN_LOAD_CONDITION_NOK" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TWEETER_OPEN_LOAD_CONDITION_NOK"
     */
    inline bool getTWEETER_OPEN_LOAD_CONDITION_NOK () const;

    /**
     * Sets the value of the member "DC_DIAGMODE_UNQUALIFIED".
     *
     * If the meaning of "DC_DIAGMODE_UNQUALIFIED" isn't clear, then there should be a description here.
     *
     * @param DC_DIAGMODE_UNQUALIFIED The value which will be set
     */
    inline void setDC_DIAGMODE_UNQUALIFIED (bool DC_DIAGMODE_UNQUALIFIED);

    /**
     * Returns the value of the member "DC_DIAGMODE_UNQUALIFIED".
     *
     * If the meaning of "DC_DIAGMODE_UNQUALIFIED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DC_DIAGMODE_UNQUALIFIED"
     */
    inline bool getDC_DIAGMODE_UNQUALIFIED () const;

    /**
     * Sets the value of the member "DC_DIAGMODE_QUALIFIED".
     *
     * If the meaning of "DC_DIAGMODE_QUALIFIED" isn't clear, then there should be a description here.
     *
     * @param DC_DIAGMODE_QUALIFIED The value which will be set
     */
    inline void setDC_DIAGMODE_QUALIFIED (bool DC_DIAGMODE_QUALIFIED);

    /**
     * Returns the value of the member "DC_DIAGMODE_QUALIFIED".
     *
     * If the meaning of "DC_DIAGMODE_QUALIFIED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DC_DIAGMODE_QUALIFIED"
     */
    inline bool getDC_DIAGMODE_QUALIFIED () const;

    /**
     * Sets the value of the member "AC_DIAGMODE_UNQUALIFIED".
     *
     * If the meaning of "AC_DIAGMODE_UNQUALIFIED" isn't clear, then there should be a description here.
     *
     * @param AC_DIAGMODE_UNQUALIFIED The value which will be set
     */
    inline void setAC_DIAGMODE_UNQUALIFIED (bool AC_DIAGMODE_UNQUALIFIED);

    /**
     * Returns the value of the member "AC_DIAGMODE_UNQUALIFIED".
     *
     * If the meaning of "AC_DIAGMODE_UNQUALIFIED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AC_DIAGMODE_UNQUALIFIED"
     */
    inline bool getAC_DIAGMODE_UNQUALIFIED () const;

    /**
     * Sets the value of the member "AC_DIAGMODE_QUALIFIED".
     *
     * If the meaning of "AC_DIAGMODE_QUALIFIED" isn't clear, then there should be a description here.
     *
     * @param AC_DIAGMODE_QUALIFIED The value which will be set
     */
    inline void setAC_DIAGMODE_QUALIFIED (bool AC_DIAGMODE_QUALIFIED);

    /**
     * Returns the value of the member "AC_DIAGMODE_QUALIFIED".
     *
     * If the meaning of "AC_DIAGMODE_QUALIFIED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AC_DIAGMODE_QUALIFIED"
     */
    inline bool getAC_DIAGMODE_QUALIFIED () const;

    /**
     * Sets the value of the member "WOOFER_AVAILABILITY".
     *
     * If the meaning of "WOOFER_AVAILABILITY" isn't clear, then there should be a description here.
     *
     * @param WOOFER_AVAILABILITY The value which will be set
     */
    inline void setWOOFER_AVAILABILITY (bool WOOFER_AVAILABILITY);

    /**
     * Returns the value of the member "WOOFER_AVAILABILITY".
     *
     * If the meaning of "WOOFER_AVAILABILITY" isn't clear, then there should be a description here.
     *
     * @return The value of the field "WOOFER_AVAILABILITY"
     */
    inline bool getWOOFER_AVAILABILITY () const;

    /**
     * Sets the value of the member "TWEETER_AVAILABILITY".
     *
     * If the meaning of "TWEETER_AVAILABILITY" isn't clear, then there should be a description here.
     *
     * @param TWEETER_AVAILABILITY The value which will be set
     */
    inline void setTWEETER_AVAILABILITY (bool TWEETER_AVAILABILITY);

    /**
     * Returns the value of the member "TWEETER_AVAILABILITY".
     *
     * If the meaning of "TWEETER_AVAILABILITY" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TWEETER_AVAILABILITY"
     */
    inline bool getTWEETER_AVAILABILITY () const;

    static const T_b32_MeasurementResult &getDefaultInstance();

private:

    bool _SHORT_TO_GROUND_OK:1;

    bool _SHORT_TO_GROUND_ERROR:1;

    bool _SHORT_TO_GROUND_NOT_TESTED:1;

    bool _SHORT_TO_GROUND_CONDITION_NOK:1;

    bool _SHORT_TO_BATTERY_OK:1;

    bool _SHORT_TO_BATTERY_ERROR:1;

    bool _SHORT_TO_BATTERY_NOT_TESTED:1;

    bool _SHORT_TO_BATTERY_CONDITION_NOK:1;

    bool _SHORTED_LOAD_OK:1;

    bool _SHORTED_LOAD_ERROR:1;

    bool _SHORTED_LOAD_NOT_TESTED:1;

    bool _SHORTED_LOAD_CONDITION_NOK:1;

    bool _WOOFER_OPEN_LOAD_OK:1;

    bool _WOOFER_OPEN_LOAD_ERROR:1;

    bool _WOOFER_OPEN_LOAD_NOT_TESTED:1;

    bool _WOOFER_OPEN_LOAD_CONDITION_NOK:1;

    bool _TWEETER_OPEN_LOAD_OK:1;

    bool _TWEETER_OPEN_LOAD_ERROR:1;

    bool _TWEETER_OPEN_LOAD_NOT_TESTED:1;

    bool _TWEETER_OPEN_LOAD_CONDITION_NOK:1;

    bool _DC_DIAGMODE_UNQUALIFIED:1;

    bool _DC_DIAGMODE_QUALIFIED:1;

    bool _AC_DIAGMODE_UNQUALIFIED:1;

    bool _AC_DIAGMODE_QUALIFIED:1;

    bool _WOOFER_AVAILABILITY:1;

    bool _TWEETER_AVAILABILITY:1;

};

/**
 * Measurement result for speaker diagnostics
 */
class T_Aud_MeasurementResultItem {
public:

    /**
     * Default constructor
     */
    inline  T_Aud_MeasurementResultItem ();

    /**
     * Copy constructor
     */
    inline  T_Aud_MeasurementResultItem (const T_Aud_MeasurementResultItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_Aud_MeasurementResultItem (T_e8_Aud_DataId u8DataId_, const T_b32_MeasurementResult& b32Result_);

    /**
     * Destructor
     */
    inline  ~T_Aud_MeasurementResultItem();

    /**
     * Assignment operator
     */
    inline T_Aud_MeasurementResultItem& operator = (const T_Aud_MeasurementResultItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Aud_MeasurementResultItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Aud_MeasurementResultItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Aud_MeasurementResultItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Aud_MeasurementResultItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DataId"

    static const int kU8DataId = 0;

    /**
     * Clears the field "u8DataId".
     *
     * The field will be set to its default value. The hasU8DataId()
     * method will return false.
     */
    inline void clearU8DataId();

    /**
     * Checks whether the field "u8DataId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DataId()). Otherwise it will return false.
     */
    inline bool hasU8DataId () const;

    /**
     * Returns the value of the member "u8DataId".
     *
     * u8DataId gives the channel to which the result belongs.
     *
     * @return The value of the field "u8DataId"
     */
    inline T_e8_Aud_DataId getU8DataId () const;

    /**
     * Sets the value of the member "u8DataId".
     *
     * u8DataId gives the channel to which the result belongs.
     *
     * @param u8DataId The value which will be set
     */
    inline void setU8DataId (T_e8_Aud_DataId u8DataId_);

    // API of field "b32Result"

    static const int kB32Result = 1;

    /**
     * Clears the field "b32Result".
     *
     * The field will be set to its default value. The hasB32Result()
     * method will return false.
     */
    inline void clearB32Result();

    /**
     * Checks whether the field "b32Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB32Result()). Otherwise it will return false.
     */
    inline bool hasB32Result () const;

    /**
     * Returns the value of the member "b32Result".
     *
     * Bitmask of measurement result for each channel.
     *
     * @return The value of the field "b32Result"
     */
    inline const T_b32_MeasurementResult& getB32Result () const;

    /**
     * Retrieves the value of the field "b32Result" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b32Result".
     */
    inline T_b32_MeasurementResult& getB32ResultMutable ();

    /**
     * Sets the value of the member "b32Result".
     *
     * Bitmask of measurement result for each channel.
     *
     * @param b32Result The value which will be set
     */
    inline void setB32Result (const T_b32_MeasurementResult& b32Result_);

    static const T_Aud_MeasurementResultItem &getDefaultInstance();

private:

    inline void set_has_u8DataId ();

    inline void clear_has_u8DataId ();

    inline void set_has_b32Result ();

    inline void clear_has_b32Result ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_Aud_DataId _u8DataId;

    T_b32_MeasurementResult _b32Result;

};

/**
 * Record type containing the connection status of a MCAN unit.
 */
class T_BOSE_UnitConnectionStatus {
public:

    /**
     * Default constructor
     */
    inline  T_BOSE_UnitConnectionStatus ();

    /**
     * Copy constructor
     */
    inline  T_BOSE_UnitConnectionStatus (const T_BOSE_UnitConnectionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  T_BOSE_UnitConnectionStatus (T_e8_BOSE_UnitType e8UnitType_, bool bConnected_, uint8 u8AbsenceState_, uint8 u8MuteState_);

    /**
     * Destructor
     */
    inline  ~T_BOSE_UnitConnectionStatus();

    /**
     * Assignment operator
     */
    inline T_BOSE_UnitConnectionStatus& operator = (const T_BOSE_UnitConnectionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_BOSE_UnitConnectionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_BOSE_UnitConnectionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_BOSE_UnitConnectionStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_BOSE_UnitConnectionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8UnitType"

    static const int kE8UnitType = 0;

    /**
     * Clears the field "e8UnitType".
     *
     * The field will be set to its default value. The hasE8UnitType()
     * method will return false.
     */
    inline void clearE8UnitType();

    /**
     * Checks whether the field "e8UnitType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8UnitType()). Otherwise it will return false.
     */
    inline bool hasE8UnitType () const;

    /**
     * Returns the value of the member "e8UnitType".
     *
     * Type of the unit.
     *
     * @return The value of the field "e8UnitType"
     */
    inline T_e8_BOSE_UnitType getE8UnitType () const;

    /**
     * Sets the value of the member "e8UnitType".
     *
     * Type of the unit.
     *
     * @param e8UnitType The value which will be set
     */
    inline void setE8UnitType (T_e8_BOSE_UnitType e8UnitType_);

    // API of field "bConnected"

    static const int kBConnected = 1;

    /**
     * Clears the field "bConnected".
     *
     * The field will be set to its default value. The hasBConnected()
     * method will return false.
     */
    inline void clearBConnected();

    /**
     * Checks whether the field "bConnected" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBConnected()). Otherwise it will return false.
     */
    inline bool hasBConnected () const;

    /**
     * Returns the value of the member "bConnected".
     *
     * <p>FALSE: This MCAN unit is not connected.</p>
     * <p>TRUE: This MCAN unit is connected.</p>
     *
     * @return The value of the field "bConnected"
     */
    inline bool getBConnected () const;

    /**
     * Sets the value of the member "bConnected".
     *
     * <p>FALSE: This MCAN unit is not connected.</p>
     * <p>TRUE: This MCAN unit is connected.</p>
     *
     * @param bConnected The value which will be set
     */
    inline void setBConnected (bool bConnected_);

    // API of field "u8AbsenceState"

    static const int kU8AbsenceState = 2;

    /**
     * Clears the field "u8AbsenceState".
     *
     * The field will be set to its default value. The hasU8AbsenceState()
     * method will return false.
     */
    inline void clearU8AbsenceState();

    /**
     * Checks whether the field "u8AbsenceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AbsenceState()). Otherwise it will return false.
     */
    inline bool hasU8AbsenceState () const;

    /**
     * Returns the value of the member "u8AbsenceState".
     *
     * Indicates the absence of CMF (Channel Management Frames), i.e. CMFs were not received.
     * <p>0x00 = CMF not absent, i.e. connection is OK</p>
     * <p>0x80 = CMF currently absent, i.e. connection currently NOK</p>
     * <p>0xC0 = CMF confirmed absent, i.e. connection confirmed NOK</p>
     * <p>0xFF = Absence detection is masked, i.e. diagnosis not active</p>
     *
     * @return The value of the field "u8AbsenceState"
     */
    inline uint8 getU8AbsenceState () const;

    /**
     * Sets the value of the member "u8AbsenceState".
     *
     * Indicates the absence of CMF (Channel Management Frames), i.e. CMFs were not received.
     * <p>0x00 = CMF not absent, i.e. connection is OK</p>
     * <p>0x80 = CMF currently absent, i.e. connection currently NOK</p>
     * <p>0xC0 = CMF confirmed absent, i.e. connection confirmed NOK</p>
     * <p>0xFF = Absence detection is masked, i.e. diagnosis not active</p>
     *
     * @param u8AbsenceState The value which will be set
     */
    inline void setU8AbsenceState (uint8 u8AbsenceState_);

    // API of field "u8MuteState"

    static const int kU8MuteState = 3;

    /**
     * Clears the field "u8MuteState".
     *
     * The field will be set to its default value. The hasU8MuteState()
     * method will return false.
     */
    inline void clearU8MuteState();

    /**
     * Checks whether the field "u8MuteState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8MuteState()). Otherwise it will return false.
     */
    inline bool hasU8MuteState () const;

    /**
     * Returns the value of the member "u8MuteState".
     *
     * Indicates a sending error (mute) of CMF, i.e. CMFs could not be sent.
     * <p>0x00 = CMF not muted, i.e. connection is OK</p>
     * <p>0x80 = CMF currently muted, i.e. connection currently NOK</p>
     * <p>0xC0 = CMF confirmed muted, i.e. connection confirmed NOK</p>
     * <p>0xFF = Mute detection is masked, i.e. diagnosis not active</p>
     *
     * @return The value of the field "u8MuteState"
     */
    inline uint8 getU8MuteState () const;

    /**
     * Sets the value of the member "u8MuteState".
     *
     * Indicates a sending error (mute) of CMF, i.e. CMFs could not be sent.
     * <p>0x00 = CMF not muted, i.e. connection is OK</p>
     * <p>0x80 = CMF currently muted, i.e. connection currently NOK</p>
     * <p>0xC0 = CMF confirmed muted, i.e. connection confirmed NOK</p>
     * <p>0xFF = Mute detection is masked, i.e. diagnosis not active</p>
     *
     * @param u8MuteState The value which will be set
     */
    inline void setU8MuteState (uint8 u8MuteState_);

    static const T_BOSE_UnitConnectionStatus &getDefaultInstance();

private:

    inline void set_has_e8UnitType ();

    inline void clear_has_e8UnitType ();

    inline void set_has_bConnected ();

    inline void clear_has_bConnected ();

    inline void set_has_u8AbsenceState ();

    inline void clear_has_u8AbsenceState ();

    inline void set_has_u8MuteState ();

    inline void clear_has_u8MuteState ();

    uint32 _has_bits_[ (4 + 31) / 32];

    T_e8_BOSE_UnitType _e8UnitType;

    bool _bConnected;

    uint8 _u8AbsenceState;

    uint8 _u8MuteState;

};

/**
 * If the meaning of "T_MicrophoneStatus" isn't clear, then there should be a description here.
 */
class T_MicrophoneStatus {
public:

    /**
     * Default constructor
     */
    inline  T_MicrophoneStatus ();

    /**
     * Copy constructor
     */
    inline  T_MicrophoneStatus (const T_MicrophoneStatus &rhs);

    /**
     * All fields constructor
     */
    inline  T_MicrophoneStatus (T_e8_MicConnection MicConnection_, T_e8_MicResult MicResult_);

    /**
     * Destructor
     */
    inline  ~T_MicrophoneStatus();

    /**
     * Assignment operator
     */
    inline T_MicrophoneStatus& operator = (const T_MicrophoneStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MicrophoneStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MicrophoneStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MicrophoneStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MicrophoneStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MicConnection"

    static const int kMicConnection = 0;

    /**
     * Clears the field "MicConnection".
     *
     * The field will be set to its default value. The hasMicConnection()
     * method will return false.
     */
    inline void clearMicConnection();

    /**
     * Checks whether the field "MicConnection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMicConnection()). Otherwise it will return false.
     */
    inline bool hasMicConnection () const;

    /**
     * Returns the value of the member "MicConnection".
     *
     * Microphone connection Status
     *
     * @return The value of the field "MicConnection"
     */
    inline T_e8_MicConnection getMicConnection () const;

    /**
     * Sets the value of the member "MicConnection".
     *
     * Microphone connection Status
     *
     * @param MicConnection The value which will be set
     */
    inline void setMicConnection (T_e8_MicConnection MicConnection_);

    // API of field "MicResult"

    static const int kMicResult = 1;

    /**
     * Clears the field "MicResult".
     *
     * The field will be set to its default value. The hasMicResult()
     * method will return false.
     */
    inline void clearMicResult();

    /**
     * Checks whether the field "MicResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMicResult()). Otherwise it will return false.
     */
    inline bool hasMicResult () const;

    /**
     * Returns the value of the member "MicResult".
     *
     * Microphone Result
     *
     * @return The value of the field "MicResult"
     */
    inline T_e8_MicResult getMicResult () const;

    /**
     * Sets the value of the member "MicResult".
     *
     * Microphone Result
     *
     * @param MicResult The value which will be set
     */
    inline void setMicResult (T_e8_MicResult MicResult_);

    static const T_MicrophoneStatus &getDefaultInstance();

private:

    inline void set_has_MicConnection ();

    inline void clear_has_MicConnection ();

    inline void set_has_MicResult ();

    inline void clear_has_MicResult ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_MicConnection _MicConnection;

    T_e8_MicResult _MicResult;

};

/**
 * If the meaning of "T_MicrophoneResult" isn't clear, then there should be a description here.
 */
class T_MicrophoneResult {
public:

    /**
     * Default constructor
     */
    inline  T_MicrophoneResult ();

    /**
     * Copy constructor
     */
    inline  T_MicrophoneResult (const T_MicrophoneResult &rhs);

    /**
     * All fields constructor
     */
    inline  T_MicrophoneResult (const T_MicrophoneStatus& Mic1Result_, const T_MicrophoneStatus& Mic2Result_, const T_MicrophoneStatus& Mic3Result_, const T_MicrophoneStatus& Mic4Result_);

    /**
     * Destructor
     */
    inline  ~T_MicrophoneResult();

    /**
     * Assignment operator
     */
    inline T_MicrophoneResult& operator = (const T_MicrophoneResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MicrophoneResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MicrophoneResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MicrophoneResult& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MicrophoneResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Mic1Result"

    static const int kMic1Result = 0;

    /**
     * Clears the field "Mic1Result".
     *
     * The field will be set to its default value. The hasMic1Result()
     * method will return false.
     */
    inline void clearMic1Result();

    /**
     * Checks whether the field "Mic1Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMic1Result()). Otherwise it will return false.
     */
    inline bool hasMic1Result () const;

    /**
     * Returns the value of the member "Mic1Result".
     *
     * Microphone1 Status
     *
     * @return The value of the field "Mic1Result"
     */
    inline const T_MicrophoneStatus& getMic1Result () const;

    /**
     * Retrieves the value of the field "Mic1Result" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Mic1Result".
     */
    inline T_MicrophoneStatus& getMic1ResultMutable ();

    /**
     * Sets the value of the member "Mic1Result".
     *
     * Microphone1 Status
     *
     * @param Mic1Result The value which will be set
     */
    inline void setMic1Result (const T_MicrophoneStatus& Mic1Result_);

    // API of field "Mic2Result"

    static const int kMic2Result = 1;

    /**
     * Clears the field "Mic2Result".
     *
     * The field will be set to its default value. The hasMic2Result()
     * method will return false.
     */
    inline void clearMic2Result();

    /**
     * Checks whether the field "Mic2Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMic2Result()). Otherwise it will return false.
     */
    inline bool hasMic2Result () const;

    /**
     * Returns the value of the member "Mic2Result".
     *
     * Microphone2 Status
     *
     * @return The value of the field "Mic2Result"
     */
    inline const T_MicrophoneStatus& getMic2Result () const;

    /**
     * Retrieves the value of the field "Mic2Result" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Mic2Result".
     */
    inline T_MicrophoneStatus& getMic2ResultMutable ();

    /**
     * Sets the value of the member "Mic2Result".
     *
     * Microphone2 Status
     *
     * @param Mic2Result The value which will be set
     */
    inline void setMic2Result (const T_MicrophoneStatus& Mic2Result_);

    // API of field "Mic3Result"

    static const int kMic3Result = 2;

    /**
     * Clears the field "Mic3Result".
     *
     * The field will be set to its default value. The hasMic3Result()
     * method will return false.
     */
    inline void clearMic3Result();

    /**
     * Checks whether the field "Mic3Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMic3Result()). Otherwise it will return false.
     */
    inline bool hasMic3Result () const;

    /**
     * Returns the value of the member "Mic3Result".
     *
     * Microphone3 Status
     *
     * @return The value of the field "Mic3Result"
     */
    inline const T_MicrophoneStatus& getMic3Result () const;

    /**
     * Retrieves the value of the field "Mic3Result" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Mic3Result".
     */
    inline T_MicrophoneStatus& getMic3ResultMutable ();

    /**
     * Sets the value of the member "Mic3Result".
     *
     * Microphone3 Status
     *
     * @param Mic3Result The value which will be set
     */
    inline void setMic3Result (const T_MicrophoneStatus& Mic3Result_);

    // API of field "Mic4Result"

    static const int kMic4Result = 3;

    /**
     * Clears the field "Mic4Result".
     *
     * The field will be set to its default value. The hasMic4Result()
     * method will return false.
     */
    inline void clearMic4Result();

    /**
     * Checks whether the field "Mic4Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMic4Result()). Otherwise it will return false.
     */
    inline bool hasMic4Result () const;

    /**
     * Returns the value of the member "Mic4Result".
     *
     * Microphone4 Status
     *
     * @return The value of the field "Mic4Result"
     */
    inline const T_MicrophoneStatus& getMic4Result () const;

    /**
     * Retrieves the value of the field "Mic4Result" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Mic4Result".
     */
    inline T_MicrophoneStatus& getMic4ResultMutable ();

    /**
     * Sets the value of the member "Mic4Result".
     *
     * Microphone4 Status
     *
     * @param Mic4Result The value which will be set
     */
    inline void setMic4Result (const T_MicrophoneStatus& Mic4Result_);

    static const T_MicrophoneResult &getDefaultInstance();

private:

    inline void set_has_Mic1Result ();

    inline void clear_has_Mic1Result ();

    inline void set_has_Mic2Result ();

    inline void clear_has_Mic2Result ();

    inline void set_has_Mic3Result ();

    inline void clear_has_Mic3Result ();

    inline void set_has_Mic4Result ();

    inline void clear_has_Mic4Result ();

    uint32 _has_bits_[ (4 + 31) / 32];

    T_MicrophoneStatus _Mic1Result;

    T_MicrophoneStatus _Mic2Result;

    T_MicrophoneStatus _Mic3Result;

    T_MicrophoneStatus _Mic4Result;

};

inline  T_Aud_TestRoutineParameter::T_Aud_TestRoutineParameter ()  :
    _TroubleCode (::masc_main_fi_types::T_e16_Aud_TroubleCode__VDL_ITC_FC_AUDIO_SPK_LF_CIRCUIT_INTERRUPTED),
    _WriteToRM (false),
    _MonitoringMode (::masc_main_fi_types::T_e8_Aud_MonitoringMode__FC_AUDIO_MONITORING_OFF),
    _SupervisionControl (::masc_main_fi_types::T_e8_Aud_SupervisionControl__FC_AUDIO_SUPERVISION_DEFAULT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_Aud_TestRoutineParameter::T_Aud_TestRoutineParameter (const T_Aud_TestRoutineParameter &rhs)  :
    _TroubleCode (::masc_main_fi_types::T_e16_Aud_TroubleCode__VDL_ITC_FC_AUDIO_SPK_LF_CIRCUIT_INTERRUPTED),
    _WriteToRM (false),
    _MonitoringMode (::masc_main_fi_types::T_e8_Aud_MonitoringMode__FC_AUDIO_MONITORING_OFF),
    _SupervisionControl (::masc_main_fi_types::T_e8_Aud_SupervisionControl__FC_AUDIO_SUPERVISION_DEFAULT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_Aud_TestRoutineParameter::T_Aud_TestRoutineParameter (T_e16_Aud_TroubleCode TroubleCode_, bool WriteToRM_, T_e8_Aud_MonitoringMode MonitoringMode_, T_e8_Aud_SupervisionControl SupervisionControl_)  :
    _TroubleCode (TroubleCode_),
    _WriteToRM (WriteToRM_),
    _MonitoringMode (MonitoringMode_),
    _SupervisionControl (SupervisionControl_)
{
    #ifndef NDEBUG
    if (!(T_e16_Aud_TroubleCode_IsValid(TroubleCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TroubleCode_, "T_e16_Aud_TroubleCode", "TroubleCode", "T_Aud_TestRoutineParameter");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_Aud_MonitoringMode_IsValid(MonitoringMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", MonitoringMode_, "T_e8_Aud_MonitoringMode", "MonitoringMode", "T_Aud_TestRoutineParameter");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_Aud_SupervisionControl_IsValid(SupervisionControl_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SupervisionControl_, "T_e8_Aud_SupervisionControl", "SupervisionControl", "T_Aud_TestRoutineParameter");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_Aud_TestRoutineParameter::~T_Aud_TestRoutineParameter() {
}

inline T_Aud_TestRoutineParameter& T_Aud_TestRoutineParameter::operator = (const T_Aud_TestRoutineParameter& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTroubleCode()) {
            setTroubleCode(rhs.getTroubleCode());
        } else {
            clearTroubleCode();
        }
        if (rhs.hasWriteToRM()) {
            setWriteToRM(rhs.getWriteToRM());
        } else {
            clearWriteToRM();
        }
        if (rhs.hasMonitoringMode()) {
            setMonitoringMode(rhs.getMonitoringMode());
        } else {
            clearMonitoringMode();
        }
        if (rhs.hasSupervisionControl()) {
            setSupervisionControl(rhs.getSupervisionControl());
        } else {
            clearSupervisionControl();
        }
    }
    return *this;
}

inline bool T_Aud_TestRoutineParameter::operator == (const T_Aud_TestRoutineParameter& rhs) const {
    return (((!hasTroubleCode() && !rhs.hasTroubleCode()) || getTroubleCode() == rhs.getTroubleCode()) &&
        ((!hasWriteToRM() && !rhs.hasWriteToRM()) || getWriteToRM() == rhs.getWriteToRM()) &&
        ((!hasMonitoringMode() && !rhs.hasMonitoringMode()) || getMonitoringMode() == rhs.getMonitoringMode()) &&
        ((!hasSupervisionControl() && !rhs.hasSupervisionControl()) || getSupervisionControl() == rhs.getSupervisionControl()));
}

inline bool T_Aud_TestRoutineParameter::operator != (const T_Aud_TestRoutineParameter& rhs) const {
    return ! (*this == rhs);
}

inline bool T_Aud_TestRoutineParameter::operator < (const T_Aud_TestRoutineParameter& rhs) const {
    if (hasTroubleCode() || rhs.hasTroubleCode()) {
        if ((uint32)getTroubleCode() < (uint32)rhs.getTroubleCode()) return true;
        if ((uint32)getTroubleCode() > (uint32)rhs.getTroubleCode()) return false;
    }
    if (hasWriteToRM() || rhs.hasWriteToRM()) {
        if (getWriteToRM() < rhs.getWriteToRM()) return true;
        if (getWriteToRM() > rhs.getWriteToRM()) return false;
    }
    if (hasMonitoringMode() || rhs.hasMonitoringMode()) {
        if ((uint32)getMonitoringMode() < (uint32)rhs.getMonitoringMode()) return true;
        if ((uint32)getMonitoringMode() > (uint32)rhs.getMonitoringMode()) return false;
    }
    if (hasSupervisionControl() || rhs.hasSupervisionControl()) {
        if ((uint32)getSupervisionControl() < (uint32)rhs.getSupervisionControl()) return true;
        if ((uint32)getSupervisionControl() > (uint32)rhs.getSupervisionControl()) return false;
    }
    return false;
}

inline bool T_Aud_TestRoutineParameter::operator > (const T_Aud_TestRoutineParameter& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_Aud_TestRoutineParameter::clear() {
    clearTroubleCode();
    clearWriteToRM();
    clearMonitoringMode();
    clearSupervisionControl();
}

inline void T_Aud_TestRoutineParameter::clearTroubleCode() {
    if (hasTroubleCode()) {
         clear_has_TroubleCode();
        _TroubleCode = ::masc_main_fi_types::T_e16_Aud_TroubleCode__VDL_ITC_FC_AUDIO_SPK_LF_CIRCUIT_INTERRUPTED;
     }
}

inline bool T_Aud_TestRoutineParameter::hasTroubleCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e16_Aud_TroubleCode T_Aud_TestRoutineParameter::getTroubleCode () const {
    return _TroubleCode;
}

inline void T_Aud_TestRoutineParameter::setTroubleCode (T_e16_Aud_TroubleCode TroubleCode_) {
    #ifndef NDEBUG
    if (!(T_e16_Aud_TroubleCode_IsValid(TroubleCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TroubleCode_, "T_e16_Aud_TroubleCode", "TroubleCode", "T_Aud_TestRoutineParameter");
    }
    #endif
    set_has_TroubleCode();
    this->_TroubleCode = TroubleCode_;
}

inline void T_Aud_TestRoutineParameter::clearWriteToRM() {
    if (hasWriteToRM()) {
         clear_has_WriteToRM();
        _WriteToRM = false;
     }
}

inline bool T_Aud_TestRoutineParameter::hasWriteToRM () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_Aud_TestRoutineParameter::getWriteToRM () const {
    return _WriteToRM;
}

inline void T_Aud_TestRoutineParameter::setWriteToRM (bool WriteToRM_) {
    set_has_WriteToRM();
    this->_WriteToRM = WriteToRM_;
}

inline void T_Aud_TestRoutineParameter::clearMonitoringMode() {
    if (hasMonitoringMode()) {
         clear_has_MonitoringMode();
        _MonitoringMode = ::masc_main_fi_types::T_e8_Aud_MonitoringMode__FC_AUDIO_MONITORING_OFF;
     }
}

inline bool T_Aud_TestRoutineParameter::hasMonitoringMode () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_Aud_MonitoringMode T_Aud_TestRoutineParameter::getMonitoringMode () const {
    return _MonitoringMode;
}

inline void T_Aud_TestRoutineParameter::setMonitoringMode (T_e8_Aud_MonitoringMode MonitoringMode_) {
    #ifndef NDEBUG
    if (!(T_e8_Aud_MonitoringMode_IsValid(MonitoringMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", MonitoringMode_, "T_e8_Aud_MonitoringMode", "MonitoringMode", "T_Aud_TestRoutineParameter");
    }
    #endif
    set_has_MonitoringMode();
    this->_MonitoringMode = MonitoringMode_;
}

inline void T_Aud_TestRoutineParameter::clearSupervisionControl() {
    if (hasSupervisionControl()) {
         clear_has_SupervisionControl();
        _SupervisionControl = ::masc_main_fi_types::T_e8_Aud_SupervisionControl__FC_AUDIO_SUPERVISION_DEFAULT;
     }
}

inline bool T_Aud_TestRoutineParameter::hasSupervisionControl () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_Aud_SupervisionControl T_Aud_TestRoutineParameter::getSupervisionControl () const {
    return _SupervisionControl;
}

inline void T_Aud_TestRoutineParameter::setSupervisionControl (T_e8_Aud_SupervisionControl SupervisionControl_) {
    #ifndef NDEBUG
    if (!(T_e8_Aud_SupervisionControl_IsValid(SupervisionControl_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SupervisionControl_, "T_e8_Aud_SupervisionControl", "SupervisionControl", "T_Aud_TestRoutineParameter");
    }
    #endif
    set_has_SupervisionControl();
    this->_SupervisionControl = SupervisionControl_;
}

inline void T_Aud_TestRoutineParameter::set_has_TroubleCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_Aud_TestRoutineParameter::clear_has_TroubleCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_Aud_TestRoutineParameter::set_has_WriteToRM () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_Aud_TestRoutineParameter::clear_has_WriteToRM () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_Aud_TestRoutineParameter::set_has_MonitoringMode () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_Aud_TestRoutineParameter::clear_has_MonitoringMode () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_Aud_TestRoutineParameter::set_has_SupervisionControl () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_Aud_TestRoutineParameter::clear_has_SupervisionControl () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_Aud_TestTroubleCodeStatus::T_Aud_TestTroubleCodeStatus ()  :
    _TroubleCode (::masc_main_fi_types::T_e16_Aud_TroubleCode__VDL_ITC_FC_AUDIO_SPK_LF_CIRCUIT_INTERRUPTED),
    _ErrorStatus (::masc_main_fi_types::T_e8_Aud_ErrorStatus__FC_AUDIO_TEST_PASSED),
    _RoutineStatus (::masc_main_fi_types::T_e8_Aud_RoutineStatus__FC_AUDIO_ROUTINE_NOT_RUNNING),
    _DiagnosisLogWrite (::masc_main_fi_types::T_e8_Aud_WriteTestErrorStatus__FC_AUDIO_WRITE_STATIS_DIGNOSIS_LOG)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_Aud_TestTroubleCodeStatus::T_Aud_TestTroubleCodeStatus (const T_Aud_TestTroubleCodeStatus &rhs)  :
    _TroubleCode (::masc_main_fi_types::T_e16_Aud_TroubleCode__VDL_ITC_FC_AUDIO_SPK_LF_CIRCUIT_INTERRUPTED),
    _ErrorStatus (::masc_main_fi_types::T_e8_Aud_ErrorStatus__FC_AUDIO_TEST_PASSED),
    _RoutineStatus (::masc_main_fi_types::T_e8_Aud_RoutineStatus__FC_AUDIO_ROUTINE_NOT_RUNNING),
    _DiagnosisLogWrite (::masc_main_fi_types::T_e8_Aud_WriteTestErrorStatus__FC_AUDIO_WRITE_STATIS_DIGNOSIS_LOG)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_Aud_TestTroubleCodeStatus::T_Aud_TestTroubleCodeStatus (T_e16_Aud_TroubleCode TroubleCode_, T_e8_Aud_ErrorStatus ErrorStatus_, T_e8_Aud_RoutineStatus RoutineStatus_, T_e8_Aud_WriteTestErrorStatus DiagnosisLogWrite_)  :
    _TroubleCode (TroubleCode_),
    _ErrorStatus (ErrorStatus_),
    _RoutineStatus (RoutineStatus_),
    _DiagnosisLogWrite (DiagnosisLogWrite_)
{
    #ifndef NDEBUG
    if (!(T_e16_Aud_TroubleCode_IsValid(TroubleCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TroubleCode_, "T_e16_Aud_TroubleCode", "TroubleCode", "T_Aud_TestTroubleCodeStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_Aud_ErrorStatus_IsValid(ErrorStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorStatus_, "T_e8_Aud_ErrorStatus", "ErrorStatus", "T_Aud_TestTroubleCodeStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_Aud_RoutineStatus_IsValid(RoutineStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", RoutineStatus_, "T_e8_Aud_RoutineStatus", "RoutineStatus", "T_Aud_TestTroubleCodeStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_Aud_WriteTestErrorStatus_IsValid(DiagnosisLogWrite_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DiagnosisLogWrite_, "T_e8_Aud_WriteTestErrorStatus", "DiagnosisLogWrite", "T_Aud_TestTroubleCodeStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_Aud_TestTroubleCodeStatus::~T_Aud_TestTroubleCodeStatus() {
}

inline T_Aud_TestTroubleCodeStatus& T_Aud_TestTroubleCodeStatus::operator = (const T_Aud_TestTroubleCodeStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTroubleCode()) {
            setTroubleCode(rhs.getTroubleCode());
        } else {
            clearTroubleCode();
        }
        if (rhs.hasErrorStatus()) {
            setErrorStatus(rhs.getErrorStatus());
        } else {
            clearErrorStatus();
        }
        if (rhs.hasRoutineStatus()) {
            setRoutineStatus(rhs.getRoutineStatus());
        } else {
            clearRoutineStatus();
        }
        if (rhs.hasDiagnosisLogWrite()) {
            setDiagnosisLogWrite(rhs.getDiagnosisLogWrite());
        } else {
            clearDiagnosisLogWrite();
        }
    }
    return *this;
}

inline bool T_Aud_TestTroubleCodeStatus::operator == (const T_Aud_TestTroubleCodeStatus& rhs) const {
    return (((!hasTroubleCode() && !rhs.hasTroubleCode()) || getTroubleCode() == rhs.getTroubleCode()) &&
        ((!hasErrorStatus() && !rhs.hasErrorStatus()) || getErrorStatus() == rhs.getErrorStatus()) &&
        ((!hasRoutineStatus() && !rhs.hasRoutineStatus()) || getRoutineStatus() == rhs.getRoutineStatus()) &&
        ((!hasDiagnosisLogWrite() && !rhs.hasDiagnosisLogWrite()) || getDiagnosisLogWrite() == rhs.getDiagnosisLogWrite()));
}

inline bool T_Aud_TestTroubleCodeStatus::operator != (const T_Aud_TestTroubleCodeStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool T_Aud_TestTroubleCodeStatus::operator < (const T_Aud_TestTroubleCodeStatus& rhs) const {
    if (hasTroubleCode() || rhs.hasTroubleCode()) {
        if ((uint32)getTroubleCode() < (uint32)rhs.getTroubleCode()) return true;
        if ((uint32)getTroubleCode() > (uint32)rhs.getTroubleCode()) return false;
    }
    if (hasErrorStatus() || rhs.hasErrorStatus()) {
        if ((uint32)getErrorStatus() < (uint32)rhs.getErrorStatus()) return true;
        if ((uint32)getErrorStatus() > (uint32)rhs.getErrorStatus()) return false;
    }
    if (hasRoutineStatus() || rhs.hasRoutineStatus()) {
        if ((uint32)getRoutineStatus() < (uint32)rhs.getRoutineStatus()) return true;
        if ((uint32)getRoutineStatus() > (uint32)rhs.getRoutineStatus()) return false;
    }
    if (hasDiagnosisLogWrite() || rhs.hasDiagnosisLogWrite()) {
        if ((uint32)getDiagnosisLogWrite() < (uint32)rhs.getDiagnosisLogWrite()) return true;
        if ((uint32)getDiagnosisLogWrite() > (uint32)rhs.getDiagnosisLogWrite()) return false;
    }
    return false;
}

inline bool T_Aud_TestTroubleCodeStatus::operator > (const T_Aud_TestTroubleCodeStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_Aud_TestTroubleCodeStatus::clear() {
    clearTroubleCode();
    clearErrorStatus();
    clearRoutineStatus();
    clearDiagnosisLogWrite();
}

inline void T_Aud_TestTroubleCodeStatus::clearTroubleCode() {
    if (hasTroubleCode()) {
         clear_has_TroubleCode();
        _TroubleCode = ::masc_main_fi_types::T_e16_Aud_TroubleCode__VDL_ITC_FC_AUDIO_SPK_LF_CIRCUIT_INTERRUPTED;
     }
}

inline bool T_Aud_TestTroubleCodeStatus::hasTroubleCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e16_Aud_TroubleCode T_Aud_TestTroubleCodeStatus::getTroubleCode () const {
    return _TroubleCode;
}

inline void T_Aud_TestTroubleCodeStatus::setTroubleCode (T_e16_Aud_TroubleCode TroubleCode_) {
    #ifndef NDEBUG
    if (!(T_e16_Aud_TroubleCode_IsValid(TroubleCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TroubleCode_, "T_e16_Aud_TroubleCode", "TroubleCode", "T_Aud_TestTroubleCodeStatus");
    }
    #endif
    set_has_TroubleCode();
    this->_TroubleCode = TroubleCode_;
}

inline void T_Aud_TestTroubleCodeStatus::clearErrorStatus() {
    if (hasErrorStatus()) {
         clear_has_ErrorStatus();
        _ErrorStatus = ::masc_main_fi_types::T_e8_Aud_ErrorStatus__FC_AUDIO_TEST_PASSED;
     }
}

inline bool T_Aud_TestTroubleCodeStatus::hasErrorStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_Aud_ErrorStatus T_Aud_TestTroubleCodeStatus::getErrorStatus () const {
    return _ErrorStatus;
}

inline void T_Aud_TestTroubleCodeStatus::setErrorStatus (T_e8_Aud_ErrorStatus ErrorStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_Aud_ErrorStatus_IsValid(ErrorStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorStatus_, "T_e8_Aud_ErrorStatus", "ErrorStatus", "T_Aud_TestTroubleCodeStatus");
    }
    #endif
    set_has_ErrorStatus();
    this->_ErrorStatus = ErrorStatus_;
}

inline void T_Aud_TestTroubleCodeStatus::clearRoutineStatus() {
    if (hasRoutineStatus()) {
         clear_has_RoutineStatus();
        _RoutineStatus = ::masc_main_fi_types::T_e8_Aud_RoutineStatus__FC_AUDIO_ROUTINE_NOT_RUNNING;
     }
}

inline bool T_Aud_TestTroubleCodeStatus::hasRoutineStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_Aud_RoutineStatus T_Aud_TestTroubleCodeStatus::getRoutineStatus () const {
    return _RoutineStatus;
}

inline void T_Aud_TestTroubleCodeStatus::setRoutineStatus (T_e8_Aud_RoutineStatus RoutineStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_Aud_RoutineStatus_IsValid(RoutineStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", RoutineStatus_, "T_e8_Aud_RoutineStatus", "RoutineStatus", "T_Aud_TestTroubleCodeStatus");
    }
    #endif
    set_has_RoutineStatus();
    this->_RoutineStatus = RoutineStatus_;
}

inline void T_Aud_TestTroubleCodeStatus::clearDiagnosisLogWrite() {
    if (hasDiagnosisLogWrite()) {
         clear_has_DiagnosisLogWrite();
        _DiagnosisLogWrite = ::masc_main_fi_types::T_e8_Aud_WriteTestErrorStatus__FC_AUDIO_WRITE_STATIS_DIGNOSIS_LOG;
     }
}

inline bool T_Aud_TestTroubleCodeStatus::hasDiagnosisLogWrite () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_Aud_WriteTestErrorStatus T_Aud_TestTroubleCodeStatus::getDiagnosisLogWrite () const {
    return _DiagnosisLogWrite;
}

inline void T_Aud_TestTroubleCodeStatus::setDiagnosisLogWrite (T_e8_Aud_WriteTestErrorStatus DiagnosisLogWrite_) {
    #ifndef NDEBUG
    if (!(T_e8_Aud_WriteTestErrorStatus_IsValid(DiagnosisLogWrite_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DiagnosisLogWrite_, "T_e8_Aud_WriteTestErrorStatus", "DiagnosisLogWrite", "T_Aud_TestTroubleCodeStatus");
    }
    #endif
    set_has_DiagnosisLogWrite();
    this->_DiagnosisLogWrite = DiagnosisLogWrite_;
}

inline void T_Aud_TestTroubleCodeStatus::set_has_TroubleCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_Aud_TestTroubleCodeStatus::clear_has_TroubleCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_Aud_TestTroubleCodeStatus::set_has_ErrorStatus () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_Aud_TestTroubleCodeStatus::clear_has_ErrorStatus () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_Aud_TestTroubleCodeStatus::set_has_RoutineStatus () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_Aud_TestTroubleCodeStatus::clear_has_RoutineStatus () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_Aud_TestTroubleCodeStatus::set_has_DiagnosisLogWrite () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_Aud_TestTroubleCodeStatus::clear_has_DiagnosisLogWrite () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_MicrophoneConnectionStatus::T_MicrophoneConnectionStatus ()  :
    _e8MicrophoneNumber (::masc_main_fi_types::T_e8_MicrophoneNumber__MIC_1),
    _u16MicrophoneCurrent (0u),
    _e8MicrophoneConnectionStatus (::masc_main_fi_types::T_e8_MicrophoneConnectionStatus__FC_AUDIO_DIAG_MIC_CONNECTION_OPEN),
    _e8MicrophoneDetection (::masc_main_fi_types::T_e8_MicrophoneDetection__MIC_DET_ABSENT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MicrophoneConnectionStatus::T_MicrophoneConnectionStatus (const T_MicrophoneConnectionStatus &rhs)  :
    _e8MicrophoneNumber (::masc_main_fi_types::T_e8_MicrophoneNumber__MIC_1),
    _u16MicrophoneCurrent (0u),
    _e8MicrophoneConnectionStatus (::masc_main_fi_types::T_e8_MicrophoneConnectionStatus__FC_AUDIO_DIAG_MIC_CONNECTION_OPEN),
    _e8MicrophoneDetection (::masc_main_fi_types::T_e8_MicrophoneDetection__MIC_DET_ABSENT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MicrophoneConnectionStatus::T_MicrophoneConnectionStatus (T_e8_MicrophoneNumber e8MicrophoneNumber_, uint16 u16MicrophoneCurrent_, T_e8_MicrophoneConnectionStatus e8MicrophoneConnectionStatus_, T_e8_MicrophoneDetection e8MicrophoneDetection_)  :
    _e8MicrophoneNumber (e8MicrophoneNumber_),
    _u16MicrophoneCurrent (u16MicrophoneCurrent_),
    _e8MicrophoneConnectionStatus (e8MicrophoneConnectionStatus_),
    _e8MicrophoneDetection (e8MicrophoneDetection_)
{
    #ifndef NDEBUG
    if (!(T_e8_MicrophoneNumber_IsValid(e8MicrophoneNumber_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MicrophoneNumber_, "T_e8_MicrophoneNumber", "e8MicrophoneNumber", "T_MicrophoneConnectionStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MicrophoneConnectionStatus_IsValid(e8MicrophoneConnectionStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MicrophoneConnectionStatus_, "T_e8_MicrophoneConnectionStatus", "e8MicrophoneConnectionStatus", "T_MicrophoneConnectionStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MicrophoneDetection_IsValid(e8MicrophoneDetection_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MicrophoneDetection_, "T_e8_MicrophoneDetection", "e8MicrophoneDetection", "T_MicrophoneConnectionStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MicrophoneConnectionStatus::~T_MicrophoneConnectionStatus() {
}

inline T_MicrophoneConnectionStatus& T_MicrophoneConnectionStatus::operator = (const T_MicrophoneConnectionStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8MicrophoneNumber()) {
            setE8MicrophoneNumber(rhs.getE8MicrophoneNumber());
        } else {
            clearE8MicrophoneNumber();
        }
        if (rhs.hasU16MicrophoneCurrent()) {
            setU16MicrophoneCurrent(rhs.getU16MicrophoneCurrent());
        } else {
            clearU16MicrophoneCurrent();
        }
        if (rhs.hasE8MicrophoneConnectionStatus()) {
            setE8MicrophoneConnectionStatus(rhs.getE8MicrophoneConnectionStatus());
        } else {
            clearE8MicrophoneConnectionStatus();
        }
        if (rhs.hasE8MicrophoneDetection()) {
            setE8MicrophoneDetection(rhs.getE8MicrophoneDetection());
        } else {
            clearE8MicrophoneDetection();
        }
    }
    return *this;
}

inline bool T_MicrophoneConnectionStatus::operator == (const T_MicrophoneConnectionStatus& rhs) const {
    return (((!hasE8MicrophoneNumber() && !rhs.hasE8MicrophoneNumber()) || getE8MicrophoneNumber() == rhs.getE8MicrophoneNumber()) &&
        ((!hasU16MicrophoneCurrent() && !rhs.hasU16MicrophoneCurrent()) || getU16MicrophoneCurrent() == rhs.getU16MicrophoneCurrent()) &&
        ((!hasE8MicrophoneConnectionStatus() && !rhs.hasE8MicrophoneConnectionStatus()) || getE8MicrophoneConnectionStatus() == rhs.getE8MicrophoneConnectionStatus()) &&
        ((!hasE8MicrophoneDetection() && !rhs.hasE8MicrophoneDetection()) || getE8MicrophoneDetection() == rhs.getE8MicrophoneDetection()));
}

inline bool T_MicrophoneConnectionStatus::operator != (const T_MicrophoneConnectionStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MicrophoneConnectionStatus::operator < (const T_MicrophoneConnectionStatus& rhs) const {
    if (hasE8MicrophoneNumber() || rhs.hasE8MicrophoneNumber()) {
        if ((uint32)getE8MicrophoneNumber() < (uint32)rhs.getE8MicrophoneNumber()) return true;
        if ((uint32)getE8MicrophoneNumber() > (uint32)rhs.getE8MicrophoneNumber()) return false;
    }
    if (hasU16MicrophoneCurrent() || rhs.hasU16MicrophoneCurrent()) {
        if (getU16MicrophoneCurrent() < rhs.getU16MicrophoneCurrent()) return true;
        if (getU16MicrophoneCurrent() > rhs.getU16MicrophoneCurrent()) return false;
    }
    if (hasE8MicrophoneConnectionStatus() || rhs.hasE8MicrophoneConnectionStatus()) {
        if ((uint32)getE8MicrophoneConnectionStatus() < (uint32)rhs.getE8MicrophoneConnectionStatus()) return true;
        if ((uint32)getE8MicrophoneConnectionStatus() > (uint32)rhs.getE8MicrophoneConnectionStatus()) return false;
    }
    if (hasE8MicrophoneDetection() || rhs.hasE8MicrophoneDetection()) {
        if ((uint32)getE8MicrophoneDetection() < (uint32)rhs.getE8MicrophoneDetection()) return true;
        if ((uint32)getE8MicrophoneDetection() > (uint32)rhs.getE8MicrophoneDetection()) return false;
    }
    return false;
}

inline bool T_MicrophoneConnectionStatus::operator > (const T_MicrophoneConnectionStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MicrophoneConnectionStatus::clear() {
    clearE8MicrophoneNumber();
    clearU16MicrophoneCurrent();
    clearE8MicrophoneConnectionStatus();
    clearE8MicrophoneDetection();
}

inline void T_MicrophoneConnectionStatus::clearE8MicrophoneNumber() {
    if (hasE8MicrophoneNumber()) {
         clear_has_e8MicrophoneNumber();
        _e8MicrophoneNumber = ::masc_main_fi_types::T_e8_MicrophoneNumber__MIC_1;
     }
}

inline bool T_MicrophoneConnectionStatus::hasE8MicrophoneNumber () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_MicrophoneNumber T_MicrophoneConnectionStatus::getE8MicrophoneNumber () const {
    return _e8MicrophoneNumber;
}

inline void T_MicrophoneConnectionStatus::setE8MicrophoneNumber (T_e8_MicrophoneNumber e8MicrophoneNumber_) {
    #ifndef NDEBUG
    if (!(T_e8_MicrophoneNumber_IsValid(e8MicrophoneNumber_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MicrophoneNumber_, "T_e8_MicrophoneNumber", "e8MicrophoneNumber", "T_MicrophoneConnectionStatus");
    }
    #endif
    set_has_e8MicrophoneNumber();
    this->_e8MicrophoneNumber = e8MicrophoneNumber_;
}

inline void T_MicrophoneConnectionStatus::clearU16MicrophoneCurrent() {
    if (hasU16MicrophoneCurrent()) {
         clear_has_u16MicrophoneCurrent();
        _u16MicrophoneCurrent = 0u;
     }
}

inline bool T_MicrophoneConnectionStatus::hasU16MicrophoneCurrent () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_MicrophoneConnectionStatus::getU16MicrophoneCurrent () const {
    return _u16MicrophoneCurrent;
}

inline void T_MicrophoneConnectionStatus::setU16MicrophoneCurrent (uint16 u16MicrophoneCurrent_) {
    set_has_u16MicrophoneCurrent();
    this->_u16MicrophoneCurrent = u16MicrophoneCurrent_;
}

inline void T_MicrophoneConnectionStatus::clearE8MicrophoneConnectionStatus() {
    if (hasE8MicrophoneConnectionStatus()) {
         clear_has_e8MicrophoneConnectionStatus();
        _e8MicrophoneConnectionStatus = ::masc_main_fi_types::T_e8_MicrophoneConnectionStatus__FC_AUDIO_DIAG_MIC_CONNECTION_OPEN;
     }
}

inline bool T_MicrophoneConnectionStatus::hasE8MicrophoneConnectionStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_MicrophoneConnectionStatus T_MicrophoneConnectionStatus::getE8MicrophoneConnectionStatus () const {
    return _e8MicrophoneConnectionStatus;
}

inline void T_MicrophoneConnectionStatus::setE8MicrophoneConnectionStatus (T_e8_MicrophoneConnectionStatus e8MicrophoneConnectionStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_MicrophoneConnectionStatus_IsValid(e8MicrophoneConnectionStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MicrophoneConnectionStatus_, "T_e8_MicrophoneConnectionStatus", "e8MicrophoneConnectionStatus", "T_MicrophoneConnectionStatus");
    }
    #endif
    set_has_e8MicrophoneConnectionStatus();
    this->_e8MicrophoneConnectionStatus = e8MicrophoneConnectionStatus_;
}

inline void T_MicrophoneConnectionStatus::clearE8MicrophoneDetection() {
    if (hasE8MicrophoneDetection()) {
         clear_has_e8MicrophoneDetection();
        _e8MicrophoneDetection = ::masc_main_fi_types::T_e8_MicrophoneDetection__MIC_DET_ABSENT;
     }
}

inline bool T_MicrophoneConnectionStatus::hasE8MicrophoneDetection () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_MicrophoneDetection T_MicrophoneConnectionStatus::getE8MicrophoneDetection () const {
    return _e8MicrophoneDetection;
}

inline void T_MicrophoneConnectionStatus::setE8MicrophoneDetection (T_e8_MicrophoneDetection e8MicrophoneDetection_) {
    #ifndef NDEBUG
    if (!(T_e8_MicrophoneDetection_IsValid(e8MicrophoneDetection_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MicrophoneDetection_, "T_e8_MicrophoneDetection", "e8MicrophoneDetection", "T_MicrophoneConnectionStatus");
    }
    #endif
    set_has_e8MicrophoneDetection();
    this->_e8MicrophoneDetection = e8MicrophoneDetection_;
}

inline void T_MicrophoneConnectionStatus::set_has_e8MicrophoneNumber () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MicrophoneConnectionStatus::clear_has_e8MicrophoneNumber () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MicrophoneConnectionStatus::set_has_u16MicrophoneCurrent () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MicrophoneConnectionStatus::clear_has_u16MicrophoneCurrent () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MicrophoneConnectionStatus::set_has_e8MicrophoneConnectionStatus () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MicrophoneConnectionStatus::clear_has_e8MicrophoneConnectionStatus () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_MicrophoneConnectionStatus::set_has_e8MicrophoneDetection () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_MicrophoneConnectionStatus::clear_has_e8MicrophoneDetection () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_Volume::T_Volume ()  :
    _e8VolType (::masc_main_fi_types::T_e8_VolumeType__INCREMENT),
    _s16Volume (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_Volume::T_Volume (const T_Volume &rhs)  :
    _e8VolType (::masc_main_fi_types::T_e8_VolumeType__INCREMENT),
    _s16Volume (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_Volume::T_Volume (T_e8_VolumeType e8VolType_, int16 s16Volume_)  :
    _e8VolType (e8VolType_),
    _s16Volume (s16Volume_)
{
    #ifndef NDEBUG
    if (!(T_e8_VolumeType_IsValid(e8VolType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8VolType_, "T_e8_VolumeType", "e8VolType", "T_Volume");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_Volume::~T_Volume() {
}

inline T_Volume& T_Volume::operator = (const T_Volume& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8VolType()) {
            setE8VolType(rhs.getE8VolType());
        } else {
            clearE8VolType();
        }
        if (rhs.hasS16Volume()) {
            setS16Volume(rhs.getS16Volume());
        } else {
            clearS16Volume();
        }
    }
    return *this;
}

inline bool T_Volume::operator == (const T_Volume& rhs) const {
    return (((!hasE8VolType() && !rhs.hasE8VolType()) || getE8VolType() == rhs.getE8VolType()) &&
        ((!hasS16Volume() && !rhs.hasS16Volume()) || getS16Volume() == rhs.getS16Volume()));
}

inline bool T_Volume::operator != (const T_Volume& rhs) const {
    return ! (*this == rhs);
}

inline bool T_Volume::operator < (const T_Volume& rhs) const {
    if (hasE8VolType() || rhs.hasE8VolType()) {
        if ((uint32)getE8VolType() < (uint32)rhs.getE8VolType()) return true;
        if ((uint32)getE8VolType() > (uint32)rhs.getE8VolType()) return false;
    }
    if (hasS16Volume() || rhs.hasS16Volume()) {
        if (getS16Volume() < rhs.getS16Volume()) return true;
        if (getS16Volume() > rhs.getS16Volume()) return false;
    }
    return false;
}

inline bool T_Volume::operator > (const T_Volume& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_Volume::clear() {
    clearE8VolType();
    clearS16Volume();
}

inline void T_Volume::clearE8VolType() {
    if (hasE8VolType()) {
         clear_has_e8VolType();
        _e8VolType = ::masc_main_fi_types::T_e8_VolumeType__INCREMENT;
     }
}

inline bool T_Volume::hasE8VolType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_VolumeType T_Volume::getE8VolType () const {
    return _e8VolType;
}

inline void T_Volume::setE8VolType (T_e8_VolumeType e8VolType_) {
    #ifndef NDEBUG
    if (!(T_e8_VolumeType_IsValid(e8VolType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8VolType_, "T_e8_VolumeType", "e8VolType", "T_Volume");
    }
    #endif
    set_has_e8VolType();
    this->_e8VolType = e8VolType_;
}

inline void T_Volume::clearS16Volume() {
    if (hasS16Volume()) {
         clear_has_s16Volume();
        _s16Volume = 0;
     }
}

inline bool T_Volume::hasS16Volume () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 T_Volume::getS16Volume () const {
    return _s16Volume;
}

inline void T_Volume::setS16Volume (int16 s16Volume_) {
    set_has_s16Volume();
    this->_s16Volume = s16Volume_;
}

inline void T_Volume::set_has_e8VolType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_Volume::clear_has_e8VolType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_Volume::set_has_s16Volume () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_Volume::clear_has_s16Volume () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_b8_ChannelSelect::T_b8_ChannelSelect ()  :
    _CHANNEL_LF (false),
    _CHANNEL_RF (false),
    _CHANNEL_LR (false),
    _CHANNEL_RR (false),
    _CHANNEL_CENT (false),
    _CHANNEL_SUB (false)
{
}

inline  T_b8_ChannelSelect::T_b8_ChannelSelect (const T_b8_ChannelSelect &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_ChannelSelect::T_b8_ChannelSelect (bool CHANNEL_LF, bool CHANNEL_RF, bool CHANNEL_LR, bool CHANNEL_RR, bool CHANNEL_CENT, bool CHANNEL_SUB) :
    _CHANNEL_LF (CHANNEL_LF),
    _CHANNEL_RF (CHANNEL_RF),
    _CHANNEL_LR (CHANNEL_LR),
    _CHANNEL_RR (CHANNEL_RR),
    _CHANNEL_CENT (CHANNEL_CENT),
    _CHANNEL_SUB (CHANNEL_SUB)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_ChannelSelect& T_b8_ChannelSelect::operator = (const T_b8_ChannelSelect& rhs) {
    if( this != &rhs ) {
        _CHANNEL_LF = rhs._CHANNEL_LF;
        _CHANNEL_RF = rhs._CHANNEL_RF;
        _CHANNEL_LR = rhs._CHANNEL_LR;
        _CHANNEL_RR = rhs._CHANNEL_RR;
        _CHANNEL_CENT = rhs._CHANNEL_CENT;
        _CHANNEL_SUB = rhs._CHANNEL_SUB;
    }
    return *this;
}

inline bool T_b8_ChannelSelect::operator == (const T_b8_ChannelSelect& rhs) const {
    return (_CHANNEL_LF == rhs._CHANNEL_LF &&
        _CHANNEL_RF == rhs._CHANNEL_RF &&
        _CHANNEL_LR == rhs._CHANNEL_LR &&
        _CHANNEL_RR == rhs._CHANNEL_RR &&
        _CHANNEL_CENT == rhs._CHANNEL_CENT &&
        _CHANNEL_SUB == rhs._CHANNEL_SUB);
}

inline bool T_b8_ChannelSelect::operator != (const T_b8_ChannelSelect& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_ChannelSelect::operator < (const T_b8_ChannelSelect& rhs) const {
    if (getCHANNEL_LF() < rhs.getCHANNEL_LF()) return true;
    if (getCHANNEL_LF() > rhs.getCHANNEL_LF()) return false;

    if (getCHANNEL_RF() < rhs.getCHANNEL_RF()) return true;
    if (getCHANNEL_RF() > rhs.getCHANNEL_RF()) return false;

    if (getCHANNEL_LR() < rhs.getCHANNEL_LR()) return true;
    if (getCHANNEL_LR() > rhs.getCHANNEL_LR()) return false;

    if (getCHANNEL_RR() < rhs.getCHANNEL_RR()) return true;
    if (getCHANNEL_RR() > rhs.getCHANNEL_RR()) return false;

    if (getCHANNEL_CENT() < rhs.getCHANNEL_CENT()) return true;
    if (getCHANNEL_CENT() > rhs.getCHANNEL_CENT()) return false;

    if (getCHANNEL_SUB() < rhs.getCHANNEL_SUB()) return true;
    if (getCHANNEL_SUB() > rhs.getCHANNEL_SUB()) return false;

    return false;
}

inline bool T_b8_ChannelSelect::operator > (const T_b8_ChannelSelect& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_ChannelSelect::setCHANNEL_LF (bool CHANNEL_LF) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_LF = CHANNEL_LF;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_ChannelSelect::getCHANNEL_LF () const {
    return _CHANNEL_LF;
}

inline void T_b8_ChannelSelect::setCHANNEL_RF (bool CHANNEL_RF) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_RF = CHANNEL_RF;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_ChannelSelect::getCHANNEL_RF () const {
    return _CHANNEL_RF;
}

inline void T_b8_ChannelSelect::setCHANNEL_LR (bool CHANNEL_LR) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_LR = CHANNEL_LR;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_ChannelSelect::getCHANNEL_LR () const {
    return _CHANNEL_LR;
}

inline void T_b8_ChannelSelect::setCHANNEL_RR (bool CHANNEL_RR) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_RR = CHANNEL_RR;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_ChannelSelect::getCHANNEL_RR () const {
    return _CHANNEL_RR;
}

inline void T_b8_ChannelSelect::setCHANNEL_CENT (bool CHANNEL_CENT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_CENT = CHANNEL_CENT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_ChannelSelect::getCHANNEL_CENT () const {
    return _CHANNEL_CENT;
}

inline void T_b8_ChannelSelect::setCHANNEL_SUB (bool CHANNEL_SUB) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_CHANNEL_SUB = CHANNEL_SUB;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_ChannelSelect::getCHANNEL_SUB () const {
    return _CHANNEL_SUB;
}

inline  T_BeepConfig::T_BeepConfig ()  :
    _e8VolType (::masc_main_fi_types::T_e8_Aud_Beep_Vol_Type__FC_AUDIO_BEEP_VOL_TYPE_SYSTEM_DEFAULT),
    _s16VoldB (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BeepConfig::T_BeepConfig (const T_BeepConfig &rhs)  :
    _e8VolType (::masc_main_fi_types::T_e8_Aud_Beep_Vol_Type__FC_AUDIO_BEEP_VOL_TYPE_SYSTEM_DEFAULT),
    _s16VoldB (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BeepConfig::T_BeepConfig (T_e8_Aud_Beep_Vol_Type e8VolType_, int16 s16VoldB_)  :
    _e8VolType (e8VolType_),
    _s16VoldB (s16VoldB_)
{
    #ifndef NDEBUG
    if (!(T_e8_Aud_Beep_Vol_Type_IsValid(e8VolType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8VolType_, "T_e8_Aud_Beep_Vol_Type", "e8VolType", "T_BeepConfig");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BeepConfig::~T_BeepConfig() {
}

inline T_BeepConfig& T_BeepConfig::operator = (const T_BeepConfig& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8VolType()) {
            setE8VolType(rhs.getE8VolType());
        } else {
            clearE8VolType();
        }
        if (rhs.hasS16VoldB()) {
            setS16VoldB(rhs.getS16VoldB());
        } else {
            clearS16VoldB();
        }
    }
    return *this;
}

inline bool T_BeepConfig::operator == (const T_BeepConfig& rhs) const {
    return (((!hasE8VolType() && !rhs.hasE8VolType()) || getE8VolType() == rhs.getE8VolType()) &&
        ((!hasS16VoldB() && !rhs.hasS16VoldB()) || getS16VoldB() == rhs.getS16VoldB()));
}

inline bool T_BeepConfig::operator != (const T_BeepConfig& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BeepConfig::operator < (const T_BeepConfig& rhs) const {
    if (hasE8VolType() || rhs.hasE8VolType()) {
        if ((uint32)getE8VolType() < (uint32)rhs.getE8VolType()) return true;
        if ((uint32)getE8VolType() > (uint32)rhs.getE8VolType()) return false;
    }
    if (hasS16VoldB() || rhs.hasS16VoldB()) {
        if (getS16VoldB() < rhs.getS16VoldB()) return true;
        if (getS16VoldB() > rhs.getS16VoldB()) return false;
    }
    return false;
}

inline bool T_BeepConfig::operator > (const T_BeepConfig& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BeepConfig::clear() {
    clearE8VolType();
    clearS16VoldB();
}

inline void T_BeepConfig::clearE8VolType() {
    if (hasE8VolType()) {
         clear_has_e8VolType();
        _e8VolType = ::masc_main_fi_types::T_e8_Aud_Beep_Vol_Type__FC_AUDIO_BEEP_VOL_TYPE_SYSTEM_DEFAULT;
     }
}

inline bool T_BeepConfig::hasE8VolType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_Aud_Beep_Vol_Type T_BeepConfig::getE8VolType () const {
    return _e8VolType;
}

inline void T_BeepConfig::setE8VolType (T_e8_Aud_Beep_Vol_Type e8VolType_) {
    #ifndef NDEBUG
    if (!(T_e8_Aud_Beep_Vol_Type_IsValid(e8VolType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8VolType_, "T_e8_Aud_Beep_Vol_Type", "e8VolType", "T_BeepConfig");
    }
    #endif
    set_has_e8VolType();
    this->_e8VolType = e8VolType_;
}

inline void T_BeepConfig::clearS16VoldB() {
    if (hasS16VoldB()) {
         clear_has_s16VoldB();
        _s16VoldB = 0;
     }
}

inline bool T_BeepConfig::hasS16VoldB () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int16 T_BeepConfig::getS16VoldB () const {
    return _s16VoldB;
}

inline void T_BeepConfig::setS16VoldB (int16 s16VoldB_) {
    set_has_s16VoldB();
    this->_s16VoldB = s16VoldB_;
}

inline void T_BeepConfig::set_has_e8VolType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BeepConfig::clear_has_e8VolType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BeepConfig::set_has_s16VoldB () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BeepConfig::clear_has_s16VoldB () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_Aud_VolumeStatus::T_Aud_VolumeStatus ()  :
    _AudVolumeType (::masc_main_fi_types::T_e8_Aud_VolumeType__VOLUME_NOT_DEF),
    _Volume (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_Aud_VolumeStatus::T_Aud_VolumeStatus (const T_Aud_VolumeStatus &rhs)  :
    _AudVolumeType (::masc_main_fi_types::T_e8_Aud_VolumeType__VOLUME_NOT_DEF),
    _Volume (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_Aud_VolumeStatus::T_Aud_VolumeStatus (T_e8_Aud_VolumeType AudVolumeType_, uint8 Volume_)  :
    _AudVolumeType (AudVolumeType_),
    _Volume (Volume_)
{
    #ifndef NDEBUG
    if (!(T_e8_Aud_VolumeType_IsValid(AudVolumeType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AudVolumeType_, "T_e8_Aud_VolumeType", "AudVolumeType", "T_Aud_VolumeStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_Aud_VolumeStatus::~T_Aud_VolumeStatus() {
}

inline T_Aud_VolumeStatus& T_Aud_VolumeStatus::operator = (const T_Aud_VolumeStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasAudVolumeType()) {
            setAudVolumeType(rhs.getAudVolumeType());
        } else {
            clearAudVolumeType();
        }
        if (rhs.hasVolume()) {
            setVolume(rhs.getVolume());
        } else {
            clearVolume();
        }
    }
    return *this;
}

inline bool T_Aud_VolumeStatus::operator == (const T_Aud_VolumeStatus& rhs) const {
    return (((!hasAudVolumeType() && !rhs.hasAudVolumeType()) || getAudVolumeType() == rhs.getAudVolumeType()) &&
        ((!hasVolume() && !rhs.hasVolume()) || getVolume() == rhs.getVolume()));
}

inline bool T_Aud_VolumeStatus::operator != (const T_Aud_VolumeStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool T_Aud_VolumeStatus::operator < (const T_Aud_VolumeStatus& rhs) const {
    if (hasAudVolumeType() || rhs.hasAudVolumeType()) {
        if ((uint32)getAudVolumeType() < (uint32)rhs.getAudVolumeType()) return true;
        if ((uint32)getAudVolumeType() > (uint32)rhs.getAudVolumeType()) return false;
    }
    if (hasVolume() || rhs.hasVolume()) {
        if (getVolume() < rhs.getVolume()) return true;
        if (getVolume() > rhs.getVolume()) return false;
    }
    return false;
}

inline bool T_Aud_VolumeStatus::operator > (const T_Aud_VolumeStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_Aud_VolumeStatus::clear() {
    clearAudVolumeType();
    clearVolume();
}

inline void T_Aud_VolumeStatus::clearAudVolumeType() {
    if (hasAudVolumeType()) {
         clear_has_AudVolumeType();
        _AudVolumeType = ::masc_main_fi_types::T_e8_Aud_VolumeType__VOLUME_NOT_DEF;
     }
}

inline bool T_Aud_VolumeStatus::hasAudVolumeType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_Aud_VolumeType T_Aud_VolumeStatus::getAudVolumeType () const {
    return _AudVolumeType;
}

inline void T_Aud_VolumeStatus::setAudVolumeType (T_e8_Aud_VolumeType AudVolumeType_) {
    #ifndef NDEBUG
    if (!(T_e8_Aud_VolumeType_IsValid(AudVolumeType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AudVolumeType_, "T_e8_Aud_VolumeType", "AudVolumeType", "T_Aud_VolumeStatus");
    }
    #endif
    set_has_AudVolumeType();
    this->_AudVolumeType = AudVolumeType_;
}

inline void T_Aud_VolumeStatus::clearVolume() {
    if (hasVolume()) {
         clear_has_Volume();
        _Volume = 0u;
     }
}

inline bool T_Aud_VolumeStatus::hasVolume () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_Aud_VolumeStatus::getVolume () const {
    return _Volume;
}

inline void T_Aud_VolumeStatus::setVolume (uint8 Volume_) {
    set_has_Volume();
    this->_Volume = Volume_;
}

inline void T_Aud_VolumeStatus::set_has_AudVolumeType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_Aud_VolumeStatus::clear_has_AudVolumeType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_Aud_VolumeStatus::set_has_Volume () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_Aud_VolumeStatus::clear_has_Volume () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_Aud_EDStatus::T_Aud_EDStatus ()  :
    _AudEDType (::masc_main_fi_types::T_e8_Aud_EDType__ED_NOT_DEF),
    _EDValue (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_Aud_EDStatus::T_Aud_EDStatus (const T_Aud_EDStatus &rhs)  :
    _AudEDType (::masc_main_fi_types::T_e8_Aud_EDType__ED_NOT_DEF),
    _EDValue (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_Aud_EDStatus::T_Aud_EDStatus (T_e8_Aud_EDType AudEDType_, int32 EDValue_)  :
    _AudEDType (AudEDType_),
    _EDValue (EDValue_)
{
    #ifndef NDEBUG
    if (!(T_e8_Aud_EDType_IsValid(AudEDType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AudEDType_, "T_e8_Aud_EDType", "AudEDType", "T_Aud_EDStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_Aud_EDStatus::~T_Aud_EDStatus() {
}

inline T_Aud_EDStatus& T_Aud_EDStatus::operator = (const T_Aud_EDStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasAudEDType()) {
            setAudEDType(rhs.getAudEDType());
        } else {
            clearAudEDType();
        }
        if (rhs.hasEDValue()) {
            setEDValue(rhs.getEDValue());
        } else {
            clearEDValue();
        }
    }
    return *this;
}

inline bool T_Aud_EDStatus::operator == (const T_Aud_EDStatus& rhs) const {
    return (((!hasAudEDType() && !rhs.hasAudEDType()) || getAudEDType() == rhs.getAudEDType()) &&
        ((!hasEDValue() && !rhs.hasEDValue()) || getEDValue() == rhs.getEDValue()));
}

inline bool T_Aud_EDStatus::operator != (const T_Aud_EDStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool T_Aud_EDStatus::operator < (const T_Aud_EDStatus& rhs) const {
    if (hasAudEDType() || rhs.hasAudEDType()) {
        if ((uint32)getAudEDType() < (uint32)rhs.getAudEDType()) return true;
        if ((uint32)getAudEDType() > (uint32)rhs.getAudEDType()) return false;
    }
    if (hasEDValue() || rhs.hasEDValue()) {
        if (getEDValue() < rhs.getEDValue()) return true;
        if (getEDValue() > rhs.getEDValue()) return false;
    }
    return false;
}

inline bool T_Aud_EDStatus::operator > (const T_Aud_EDStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_Aud_EDStatus::clear() {
    clearAudEDType();
    clearEDValue();
}

inline void T_Aud_EDStatus::clearAudEDType() {
    if (hasAudEDType()) {
         clear_has_AudEDType();
        _AudEDType = ::masc_main_fi_types::T_e8_Aud_EDType__ED_NOT_DEF;
     }
}

inline bool T_Aud_EDStatus::hasAudEDType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_Aud_EDType T_Aud_EDStatus::getAudEDType () const {
    return _AudEDType;
}

inline void T_Aud_EDStatus::setAudEDType (T_e8_Aud_EDType AudEDType_) {
    #ifndef NDEBUG
    if (!(T_e8_Aud_EDType_IsValid(AudEDType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AudEDType_, "T_e8_Aud_EDType", "AudEDType", "T_Aud_EDStatus");
    }
    #endif
    set_has_AudEDType();
    this->_AudEDType = AudEDType_;
}

inline void T_Aud_EDStatus::clearEDValue() {
    if (hasEDValue()) {
         clear_has_EDValue();
        _EDValue = 0;
     }
}

inline bool T_Aud_EDStatus::hasEDValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 T_Aud_EDStatus::getEDValue () const {
    return _EDValue;
}

inline void T_Aud_EDStatus::setEDValue (int32 EDValue_) {
    set_has_EDValue();
    this->_EDValue = EDValue_;
}

inline void T_Aud_EDStatus::set_has_AudEDType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_Aud_EDStatus::clear_has_AudEDType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_Aud_EDStatus::set_has_EDValue () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_Aud_EDStatus::clear_has_EDValue () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_b32_MeasurementResult::T_b32_MeasurementResult ()  :
    _SHORT_TO_GROUND_OK (false),
    _SHORT_TO_GROUND_ERROR (false),
    _SHORT_TO_GROUND_NOT_TESTED (false),
    _SHORT_TO_GROUND_CONDITION_NOK (false),
    _SHORT_TO_BATTERY_OK (false),
    _SHORT_TO_BATTERY_ERROR (false),
    _SHORT_TO_BATTERY_NOT_TESTED (false),
    _SHORT_TO_BATTERY_CONDITION_NOK (false),
    _SHORTED_LOAD_OK (false),
    _SHORTED_LOAD_ERROR (false),
    _SHORTED_LOAD_NOT_TESTED (false),
    _SHORTED_LOAD_CONDITION_NOK (false),
    _WOOFER_OPEN_LOAD_OK (false),
    _WOOFER_OPEN_LOAD_ERROR (false),
    _WOOFER_OPEN_LOAD_NOT_TESTED (false),
    _WOOFER_OPEN_LOAD_CONDITION_NOK (false),
    _TWEETER_OPEN_LOAD_OK (false),
    _TWEETER_OPEN_LOAD_ERROR (false),
    _TWEETER_OPEN_LOAD_NOT_TESTED (false),
    _TWEETER_OPEN_LOAD_CONDITION_NOK (false),
    _DC_DIAGMODE_UNQUALIFIED (false),
    _DC_DIAGMODE_QUALIFIED (false),
    _AC_DIAGMODE_UNQUALIFIED (false),
    _AC_DIAGMODE_QUALIFIED (false),
    _WOOFER_AVAILABILITY (false),
    _TWEETER_AVAILABILITY (false)
{
}

inline  T_b32_MeasurementResult::T_b32_MeasurementResult (const T_b32_MeasurementResult &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b32_MeasurementResult::T_b32_MeasurementResult (bool SHORT_TO_GROUND_OK, bool SHORT_TO_GROUND_ERROR, bool SHORT_TO_GROUND_NOT_TESTED, bool SHORT_TO_GROUND_CONDITION_NOK, bool SHORT_TO_BATTERY_OK, bool SHORT_TO_BATTERY_ERROR, bool SHORT_TO_BATTERY_NOT_TESTED, bool SHORT_TO_BATTERY_CONDITION_NOK, bool SHORTED_LOAD_OK, bool SHORTED_LOAD_ERROR, bool SHORTED_LOAD_NOT_TESTED, bool SHORTED_LOAD_CONDITION_NOK, bool WOOFER_OPEN_LOAD_OK, bool WOOFER_OPEN_LOAD_ERROR, bool WOOFER_OPEN_LOAD_NOT_TESTED, bool WOOFER_OPEN_LOAD_CONDITION_NOK, bool TWEETER_OPEN_LOAD_OK, bool TWEETER_OPEN_LOAD_ERROR, bool TWEETER_OPEN_LOAD_NOT_TESTED, bool TWEETER_OPEN_LOAD_CONDITION_NOK, bool DC_DIAGMODE_UNQUALIFIED, bool DC_DIAGMODE_QUALIFIED, bool AC_DIAGMODE_UNQUALIFIED, bool AC_DIAGMODE_QUALIFIED, bool WOOFER_AVAILABILITY, bool TWEETER_AVAILABILITY) :
    _SHORT_TO_GROUND_OK (SHORT_TO_GROUND_OK),
    _SHORT_TO_GROUND_ERROR (SHORT_TO_GROUND_ERROR),
    _SHORT_TO_GROUND_NOT_TESTED (SHORT_TO_GROUND_NOT_TESTED),
    _SHORT_TO_GROUND_CONDITION_NOK (SHORT_TO_GROUND_CONDITION_NOK),
    _SHORT_TO_BATTERY_OK (SHORT_TO_BATTERY_OK),
    _SHORT_TO_BATTERY_ERROR (SHORT_TO_BATTERY_ERROR),
    _SHORT_TO_BATTERY_NOT_TESTED (SHORT_TO_BATTERY_NOT_TESTED),
    _SHORT_TO_BATTERY_CONDITION_NOK (SHORT_TO_BATTERY_CONDITION_NOK),
    _SHORTED_LOAD_OK (SHORTED_LOAD_OK),
    _SHORTED_LOAD_ERROR (SHORTED_LOAD_ERROR),
    _SHORTED_LOAD_NOT_TESTED (SHORTED_LOAD_NOT_TESTED),
    _SHORTED_LOAD_CONDITION_NOK (SHORTED_LOAD_CONDITION_NOK),
    _WOOFER_OPEN_LOAD_OK (WOOFER_OPEN_LOAD_OK),
    _WOOFER_OPEN_LOAD_ERROR (WOOFER_OPEN_LOAD_ERROR),
    _WOOFER_OPEN_LOAD_NOT_TESTED (WOOFER_OPEN_LOAD_NOT_TESTED),
    _WOOFER_OPEN_LOAD_CONDITION_NOK (WOOFER_OPEN_LOAD_CONDITION_NOK),
    _TWEETER_OPEN_LOAD_OK (TWEETER_OPEN_LOAD_OK),
    _TWEETER_OPEN_LOAD_ERROR (TWEETER_OPEN_LOAD_ERROR),
    _TWEETER_OPEN_LOAD_NOT_TESTED (TWEETER_OPEN_LOAD_NOT_TESTED),
    _TWEETER_OPEN_LOAD_CONDITION_NOK (TWEETER_OPEN_LOAD_CONDITION_NOK),
    _DC_DIAGMODE_UNQUALIFIED (DC_DIAGMODE_UNQUALIFIED),
    _DC_DIAGMODE_QUALIFIED (DC_DIAGMODE_QUALIFIED),
    _AC_DIAGMODE_UNQUALIFIED (AC_DIAGMODE_UNQUALIFIED),
    _AC_DIAGMODE_QUALIFIED (AC_DIAGMODE_QUALIFIED),
    _WOOFER_AVAILABILITY (WOOFER_AVAILABILITY),
    _TWEETER_AVAILABILITY (TWEETER_AVAILABILITY)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b32_MeasurementResult& T_b32_MeasurementResult::operator = (const T_b32_MeasurementResult& rhs) {
    if( this != &rhs ) {
        _SHORT_TO_GROUND_OK = rhs._SHORT_TO_GROUND_OK;
        _SHORT_TO_GROUND_ERROR = rhs._SHORT_TO_GROUND_ERROR;
        _SHORT_TO_GROUND_NOT_TESTED = rhs._SHORT_TO_GROUND_NOT_TESTED;
        _SHORT_TO_GROUND_CONDITION_NOK = rhs._SHORT_TO_GROUND_CONDITION_NOK;
        _SHORT_TO_BATTERY_OK = rhs._SHORT_TO_BATTERY_OK;
        _SHORT_TO_BATTERY_ERROR = rhs._SHORT_TO_BATTERY_ERROR;
        _SHORT_TO_BATTERY_NOT_TESTED = rhs._SHORT_TO_BATTERY_NOT_TESTED;
        _SHORT_TO_BATTERY_CONDITION_NOK = rhs._SHORT_TO_BATTERY_CONDITION_NOK;
        _SHORTED_LOAD_OK = rhs._SHORTED_LOAD_OK;
        _SHORTED_LOAD_ERROR = rhs._SHORTED_LOAD_ERROR;
        _SHORTED_LOAD_NOT_TESTED = rhs._SHORTED_LOAD_NOT_TESTED;
        _SHORTED_LOAD_CONDITION_NOK = rhs._SHORTED_LOAD_CONDITION_NOK;
        _WOOFER_OPEN_LOAD_OK = rhs._WOOFER_OPEN_LOAD_OK;
        _WOOFER_OPEN_LOAD_ERROR = rhs._WOOFER_OPEN_LOAD_ERROR;
        _WOOFER_OPEN_LOAD_NOT_TESTED = rhs._WOOFER_OPEN_LOAD_NOT_TESTED;
        _WOOFER_OPEN_LOAD_CONDITION_NOK = rhs._WOOFER_OPEN_LOAD_CONDITION_NOK;
        _TWEETER_OPEN_LOAD_OK = rhs._TWEETER_OPEN_LOAD_OK;
        _TWEETER_OPEN_LOAD_ERROR = rhs._TWEETER_OPEN_LOAD_ERROR;
        _TWEETER_OPEN_LOAD_NOT_TESTED = rhs._TWEETER_OPEN_LOAD_NOT_TESTED;
        _TWEETER_OPEN_LOAD_CONDITION_NOK = rhs._TWEETER_OPEN_LOAD_CONDITION_NOK;
        _DC_DIAGMODE_UNQUALIFIED = rhs._DC_DIAGMODE_UNQUALIFIED;
        _DC_DIAGMODE_QUALIFIED = rhs._DC_DIAGMODE_QUALIFIED;
        _AC_DIAGMODE_UNQUALIFIED = rhs._AC_DIAGMODE_UNQUALIFIED;
        _AC_DIAGMODE_QUALIFIED = rhs._AC_DIAGMODE_QUALIFIED;
        _WOOFER_AVAILABILITY = rhs._WOOFER_AVAILABILITY;
        _TWEETER_AVAILABILITY = rhs._TWEETER_AVAILABILITY;
    }
    return *this;
}

inline bool T_b32_MeasurementResult::operator == (const T_b32_MeasurementResult& rhs) const {
    return (_SHORT_TO_GROUND_OK == rhs._SHORT_TO_GROUND_OK &&
        _SHORT_TO_GROUND_ERROR == rhs._SHORT_TO_GROUND_ERROR &&
        _SHORT_TO_GROUND_NOT_TESTED == rhs._SHORT_TO_GROUND_NOT_TESTED &&
        _SHORT_TO_GROUND_CONDITION_NOK == rhs._SHORT_TO_GROUND_CONDITION_NOK &&
        _SHORT_TO_BATTERY_OK == rhs._SHORT_TO_BATTERY_OK &&
        _SHORT_TO_BATTERY_ERROR == rhs._SHORT_TO_BATTERY_ERROR &&
        _SHORT_TO_BATTERY_NOT_TESTED == rhs._SHORT_TO_BATTERY_NOT_TESTED &&
        _SHORT_TO_BATTERY_CONDITION_NOK == rhs._SHORT_TO_BATTERY_CONDITION_NOK &&
        _SHORTED_LOAD_OK == rhs._SHORTED_LOAD_OK &&
        _SHORTED_LOAD_ERROR == rhs._SHORTED_LOAD_ERROR &&
        _SHORTED_LOAD_NOT_TESTED == rhs._SHORTED_LOAD_NOT_TESTED &&
        _SHORTED_LOAD_CONDITION_NOK == rhs._SHORTED_LOAD_CONDITION_NOK &&
        _WOOFER_OPEN_LOAD_OK == rhs._WOOFER_OPEN_LOAD_OK &&
        _WOOFER_OPEN_LOAD_ERROR == rhs._WOOFER_OPEN_LOAD_ERROR &&
        _WOOFER_OPEN_LOAD_NOT_TESTED == rhs._WOOFER_OPEN_LOAD_NOT_TESTED &&
        _WOOFER_OPEN_LOAD_CONDITION_NOK == rhs._WOOFER_OPEN_LOAD_CONDITION_NOK &&
        _TWEETER_OPEN_LOAD_OK == rhs._TWEETER_OPEN_LOAD_OK &&
        _TWEETER_OPEN_LOAD_ERROR == rhs._TWEETER_OPEN_LOAD_ERROR &&
        _TWEETER_OPEN_LOAD_NOT_TESTED == rhs._TWEETER_OPEN_LOAD_NOT_TESTED &&
        _TWEETER_OPEN_LOAD_CONDITION_NOK == rhs._TWEETER_OPEN_LOAD_CONDITION_NOK &&
        _DC_DIAGMODE_UNQUALIFIED == rhs._DC_DIAGMODE_UNQUALIFIED &&
        _DC_DIAGMODE_QUALIFIED == rhs._DC_DIAGMODE_QUALIFIED &&
        _AC_DIAGMODE_UNQUALIFIED == rhs._AC_DIAGMODE_UNQUALIFIED &&
        _AC_DIAGMODE_QUALIFIED == rhs._AC_DIAGMODE_QUALIFIED &&
        _WOOFER_AVAILABILITY == rhs._WOOFER_AVAILABILITY &&
        _TWEETER_AVAILABILITY == rhs._TWEETER_AVAILABILITY);
}

inline bool T_b32_MeasurementResult::operator != (const T_b32_MeasurementResult& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b32_MeasurementResult::operator < (const T_b32_MeasurementResult& rhs) const {
    if (getSHORT_TO_GROUND_OK() < rhs.getSHORT_TO_GROUND_OK()) return true;
    if (getSHORT_TO_GROUND_OK() > rhs.getSHORT_TO_GROUND_OK()) return false;

    if (getSHORT_TO_GROUND_ERROR() < rhs.getSHORT_TO_GROUND_ERROR()) return true;
    if (getSHORT_TO_GROUND_ERROR() > rhs.getSHORT_TO_GROUND_ERROR()) return false;

    if (getSHORT_TO_GROUND_NOT_TESTED() < rhs.getSHORT_TO_GROUND_NOT_TESTED()) return true;
    if (getSHORT_TO_GROUND_NOT_TESTED() > rhs.getSHORT_TO_GROUND_NOT_TESTED()) return false;

    if (getSHORT_TO_GROUND_CONDITION_NOK() < rhs.getSHORT_TO_GROUND_CONDITION_NOK()) return true;
    if (getSHORT_TO_GROUND_CONDITION_NOK() > rhs.getSHORT_TO_GROUND_CONDITION_NOK()) return false;

    if (getSHORT_TO_BATTERY_OK() < rhs.getSHORT_TO_BATTERY_OK()) return true;
    if (getSHORT_TO_BATTERY_OK() > rhs.getSHORT_TO_BATTERY_OK()) return false;

    if (getSHORT_TO_BATTERY_ERROR() < rhs.getSHORT_TO_BATTERY_ERROR()) return true;
    if (getSHORT_TO_BATTERY_ERROR() > rhs.getSHORT_TO_BATTERY_ERROR()) return false;

    if (getSHORT_TO_BATTERY_NOT_TESTED() < rhs.getSHORT_TO_BATTERY_NOT_TESTED()) return true;
    if (getSHORT_TO_BATTERY_NOT_TESTED() > rhs.getSHORT_TO_BATTERY_NOT_TESTED()) return false;

    if (getSHORT_TO_BATTERY_CONDITION_NOK() < rhs.getSHORT_TO_BATTERY_CONDITION_NOK()) return true;
    if (getSHORT_TO_BATTERY_CONDITION_NOK() > rhs.getSHORT_TO_BATTERY_CONDITION_NOK()) return false;

    if (getSHORTED_LOAD_OK() < rhs.getSHORTED_LOAD_OK()) return true;
    if (getSHORTED_LOAD_OK() > rhs.getSHORTED_LOAD_OK()) return false;

    if (getSHORTED_LOAD_ERROR() < rhs.getSHORTED_LOAD_ERROR()) return true;
    if (getSHORTED_LOAD_ERROR() > rhs.getSHORTED_LOAD_ERROR()) return false;

    if (getSHORTED_LOAD_NOT_TESTED() < rhs.getSHORTED_LOAD_NOT_TESTED()) return true;
    if (getSHORTED_LOAD_NOT_TESTED() > rhs.getSHORTED_LOAD_NOT_TESTED()) return false;

    if (getSHORTED_LOAD_CONDITION_NOK() < rhs.getSHORTED_LOAD_CONDITION_NOK()) return true;
    if (getSHORTED_LOAD_CONDITION_NOK() > rhs.getSHORTED_LOAD_CONDITION_NOK()) return false;

    if (getWOOFER_OPEN_LOAD_OK() < rhs.getWOOFER_OPEN_LOAD_OK()) return true;
    if (getWOOFER_OPEN_LOAD_OK() > rhs.getWOOFER_OPEN_LOAD_OK()) return false;

    if (getWOOFER_OPEN_LOAD_ERROR() < rhs.getWOOFER_OPEN_LOAD_ERROR()) return true;
    if (getWOOFER_OPEN_LOAD_ERROR() > rhs.getWOOFER_OPEN_LOAD_ERROR()) return false;

    if (getWOOFER_OPEN_LOAD_NOT_TESTED() < rhs.getWOOFER_OPEN_LOAD_NOT_TESTED()) return true;
    if (getWOOFER_OPEN_LOAD_NOT_TESTED() > rhs.getWOOFER_OPEN_LOAD_NOT_TESTED()) return false;

    if (getWOOFER_OPEN_LOAD_CONDITION_NOK() < rhs.getWOOFER_OPEN_LOAD_CONDITION_NOK()) return true;
    if (getWOOFER_OPEN_LOAD_CONDITION_NOK() > rhs.getWOOFER_OPEN_LOAD_CONDITION_NOK()) return false;

    if (getTWEETER_OPEN_LOAD_OK() < rhs.getTWEETER_OPEN_LOAD_OK()) return true;
    if (getTWEETER_OPEN_LOAD_OK() > rhs.getTWEETER_OPEN_LOAD_OK()) return false;

    if (getTWEETER_OPEN_LOAD_ERROR() < rhs.getTWEETER_OPEN_LOAD_ERROR()) return true;
    if (getTWEETER_OPEN_LOAD_ERROR() > rhs.getTWEETER_OPEN_LOAD_ERROR()) return false;

    if (getTWEETER_OPEN_LOAD_NOT_TESTED() < rhs.getTWEETER_OPEN_LOAD_NOT_TESTED()) return true;
    if (getTWEETER_OPEN_LOAD_NOT_TESTED() > rhs.getTWEETER_OPEN_LOAD_NOT_TESTED()) return false;

    if (getTWEETER_OPEN_LOAD_CONDITION_NOK() < rhs.getTWEETER_OPEN_LOAD_CONDITION_NOK()) return true;
    if (getTWEETER_OPEN_LOAD_CONDITION_NOK() > rhs.getTWEETER_OPEN_LOAD_CONDITION_NOK()) return false;

    if (getDC_DIAGMODE_UNQUALIFIED() < rhs.getDC_DIAGMODE_UNQUALIFIED()) return true;
    if (getDC_DIAGMODE_UNQUALIFIED() > rhs.getDC_DIAGMODE_UNQUALIFIED()) return false;

    if (getDC_DIAGMODE_QUALIFIED() < rhs.getDC_DIAGMODE_QUALIFIED()) return true;
    if (getDC_DIAGMODE_QUALIFIED() > rhs.getDC_DIAGMODE_QUALIFIED()) return false;

    if (getAC_DIAGMODE_UNQUALIFIED() < rhs.getAC_DIAGMODE_UNQUALIFIED()) return true;
    if (getAC_DIAGMODE_UNQUALIFIED() > rhs.getAC_DIAGMODE_UNQUALIFIED()) return false;

    if (getAC_DIAGMODE_QUALIFIED() < rhs.getAC_DIAGMODE_QUALIFIED()) return true;
    if (getAC_DIAGMODE_QUALIFIED() > rhs.getAC_DIAGMODE_QUALIFIED()) return false;

    if (getWOOFER_AVAILABILITY() < rhs.getWOOFER_AVAILABILITY()) return true;
    if (getWOOFER_AVAILABILITY() > rhs.getWOOFER_AVAILABILITY()) return false;

    if (getTWEETER_AVAILABILITY() < rhs.getTWEETER_AVAILABILITY()) return true;
    if (getTWEETER_AVAILABILITY() > rhs.getTWEETER_AVAILABILITY()) return false;

    return false;
}

inline bool T_b32_MeasurementResult::operator > (const T_b32_MeasurementResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b32_MeasurementResult::setSHORT_TO_GROUND_OK (bool SHORT_TO_GROUND_OK) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SHORT_TO_GROUND_OK = SHORT_TO_GROUND_OK;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getSHORT_TO_GROUND_OK () const {
    return _SHORT_TO_GROUND_OK;
}

inline void T_b32_MeasurementResult::setSHORT_TO_GROUND_ERROR (bool SHORT_TO_GROUND_ERROR) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SHORT_TO_GROUND_ERROR = SHORT_TO_GROUND_ERROR;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getSHORT_TO_GROUND_ERROR () const {
    return _SHORT_TO_GROUND_ERROR;
}

inline void T_b32_MeasurementResult::setSHORT_TO_GROUND_NOT_TESTED (bool SHORT_TO_GROUND_NOT_TESTED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SHORT_TO_GROUND_NOT_TESTED = SHORT_TO_GROUND_NOT_TESTED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getSHORT_TO_GROUND_NOT_TESTED () const {
    return _SHORT_TO_GROUND_NOT_TESTED;
}

inline void T_b32_MeasurementResult::setSHORT_TO_GROUND_CONDITION_NOK (bool SHORT_TO_GROUND_CONDITION_NOK) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SHORT_TO_GROUND_CONDITION_NOK = SHORT_TO_GROUND_CONDITION_NOK;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getSHORT_TO_GROUND_CONDITION_NOK () const {
    return _SHORT_TO_GROUND_CONDITION_NOK;
}

inline void T_b32_MeasurementResult::setSHORT_TO_BATTERY_OK (bool SHORT_TO_BATTERY_OK) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SHORT_TO_BATTERY_OK = SHORT_TO_BATTERY_OK;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getSHORT_TO_BATTERY_OK () const {
    return _SHORT_TO_BATTERY_OK;
}

inline void T_b32_MeasurementResult::setSHORT_TO_BATTERY_ERROR (bool SHORT_TO_BATTERY_ERROR) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SHORT_TO_BATTERY_ERROR = SHORT_TO_BATTERY_ERROR;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getSHORT_TO_BATTERY_ERROR () const {
    return _SHORT_TO_BATTERY_ERROR;
}

inline void T_b32_MeasurementResult::setSHORT_TO_BATTERY_NOT_TESTED (bool SHORT_TO_BATTERY_NOT_TESTED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SHORT_TO_BATTERY_NOT_TESTED = SHORT_TO_BATTERY_NOT_TESTED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getSHORT_TO_BATTERY_NOT_TESTED () const {
    return _SHORT_TO_BATTERY_NOT_TESTED;
}

inline void T_b32_MeasurementResult::setSHORT_TO_BATTERY_CONDITION_NOK (bool SHORT_TO_BATTERY_CONDITION_NOK) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SHORT_TO_BATTERY_CONDITION_NOK = SHORT_TO_BATTERY_CONDITION_NOK;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getSHORT_TO_BATTERY_CONDITION_NOK () const {
    return _SHORT_TO_BATTERY_CONDITION_NOK;
}

inline void T_b32_MeasurementResult::setSHORTED_LOAD_OK (bool SHORTED_LOAD_OK) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SHORTED_LOAD_OK = SHORTED_LOAD_OK;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getSHORTED_LOAD_OK () const {
    return _SHORTED_LOAD_OK;
}

inline void T_b32_MeasurementResult::setSHORTED_LOAD_ERROR (bool SHORTED_LOAD_ERROR) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SHORTED_LOAD_ERROR = SHORTED_LOAD_ERROR;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getSHORTED_LOAD_ERROR () const {
    return _SHORTED_LOAD_ERROR;
}

inline void T_b32_MeasurementResult::setSHORTED_LOAD_NOT_TESTED (bool SHORTED_LOAD_NOT_TESTED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SHORTED_LOAD_NOT_TESTED = SHORTED_LOAD_NOT_TESTED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getSHORTED_LOAD_NOT_TESTED () const {
    return _SHORTED_LOAD_NOT_TESTED;
}

inline void T_b32_MeasurementResult::setSHORTED_LOAD_CONDITION_NOK (bool SHORTED_LOAD_CONDITION_NOK) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SHORTED_LOAD_CONDITION_NOK = SHORTED_LOAD_CONDITION_NOK;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getSHORTED_LOAD_CONDITION_NOK () const {
    return _SHORTED_LOAD_CONDITION_NOK;
}

inline void T_b32_MeasurementResult::setWOOFER_OPEN_LOAD_OK (bool WOOFER_OPEN_LOAD_OK) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_WOOFER_OPEN_LOAD_OK = WOOFER_OPEN_LOAD_OK;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getWOOFER_OPEN_LOAD_OK () const {
    return _WOOFER_OPEN_LOAD_OK;
}

inline void T_b32_MeasurementResult::setWOOFER_OPEN_LOAD_ERROR (bool WOOFER_OPEN_LOAD_ERROR) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_WOOFER_OPEN_LOAD_ERROR = WOOFER_OPEN_LOAD_ERROR;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getWOOFER_OPEN_LOAD_ERROR () const {
    return _WOOFER_OPEN_LOAD_ERROR;
}

inline void T_b32_MeasurementResult::setWOOFER_OPEN_LOAD_NOT_TESTED (bool WOOFER_OPEN_LOAD_NOT_TESTED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_WOOFER_OPEN_LOAD_NOT_TESTED = WOOFER_OPEN_LOAD_NOT_TESTED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getWOOFER_OPEN_LOAD_NOT_TESTED () const {
    return _WOOFER_OPEN_LOAD_NOT_TESTED;
}

inline void T_b32_MeasurementResult::setWOOFER_OPEN_LOAD_CONDITION_NOK (bool WOOFER_OPEN_LOAD_CONDITION_NOK) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_WOOFER_OPEN_LOAD_CONDITION_NOK = WOOFER_OPEN_LOAD_CONDITION_NOK;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getWOOFER_OPEN_LOAD_CONDITION_NOK () const {
    return _WOOFER_OPEN_LOAD_CONDITION_NOK;
}

inline void T_b32_MeasurementResult::setTWEETER_OPEN_LOAD_OK (bool TWEETER_OPEN_LOAD_OK) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TWEETER_OPEN_LOAD_OK = TWEETER_OPEN_LOAD_OK;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getTWEETER_OPEN_LOAD_OK () const {
    return _TWEETER_OPEN_LOAD_OK;
}

inline void T_b32_MeasurementResult::setTWEETER_OPEN_LOAD_ERROR (bool TWEETER_OPEN_LOAD_ERROR) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TWEETER_OPEN_LOAD_ERROR = TWEETER_OPEN_LOAD_ERROR;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getTWEETER_OPEN_LOAD_ERROR () const {
    return _TWEETER_OPEN_LOAD_ERROR;
}

inline void T_b32_MeasurementResult::setTWEETER_OPEN_LOAD_NOT_TESTED (bool TWEETER_OPEN_LOAD_NOT_TESTED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TWEETER_OPEN_LOAD_NOT_TESTED = TWEETER_OPEN_LOAD_NOT_TESTED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getTWEETER_OPEN_LOAD_NOT_TESTED () const {
    return _TWEETER_OPEN_LOAD_NOT_TESTED;
}

inline void T_b32_MeasurementResult::setTWEETER_OPEN_LOAD_CONDITION_NOK (bool TWEETER_OPEN_LOAD_CONDITION_NOK) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TWEETER_OPEN_LOAD_CONDITION_NOK = TWEETER_OPEN_LOAD_CONDITION_NOK;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getTWEETER_OPEN_LOAD_CONDITION_NOK () const {
    return _TWEETER_OPEN_LOAD_CONDITION_NOK;
}

inline void T_b32_MeasurementResult::setDC_DIAGMODE_UNQUALIFIED (bool DC_DIAGMODE_UNQUALIFIED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DC_DIAGMODE_UNQUALIFIED = DC_DIAGMODE_UNQUALIFIED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getDC_DIAGMODE_UNQUALIFIED () const {
    return _DC_DIAGMODE_UNQUALIFIED;
}

inline void T_b32_MeasurementResult::setDC_DIAGMODE_QUALIFIED (bool DC_DIAGMODE_QUALIFIED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DC_DIAGMODE_QUALIFIED = DC_DIAGMODE_QUALIFIED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getDC_DIAGMODE_QUALIFIED () const {
    return _DC_DIAGMODE_QUALIFIED;
}

inline void T_b32_MeasurementResult::setAC_DIAGMODE_UNQUALIFIED (bool AC_DIAGMODE_UNQUALIFIED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_AC_DIAGMODE_UNQUALIFIED = AC_DIAGMODE_UNQUALIFIED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getAC_DIAGMODE_UNQUALIFIED () const {
    return _AC_DIAGMODE_UNQUALIFIED;
}

inline void T_b32_MeasurementResult::setAC_DIAGMODE_QUALIFIED (bool AC_DIAGMODE_QUALIFIED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_AC_DIAGMODE_QUALIFIED = AC_DIAGMODE_QUALIFIED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getAC_DIAGMODE_QUALIFIED () const {
    return _AC_DIAGMODE_QUALIFIED;
}

inline void T_b32_MeasurementResult::setWOOFER_AVAILABILITY (bool WOOFER_AVAILABILITY) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_WOOFER_AVAILABILITY = WOOFER_AVAILABILITY;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getWOOFER_AVAILABILITY () const {
    return _WOOFER_AVAILABILITY;
}

inline void T_b32_MeasurementResult::setTWEETER_AVAILABILITY (bool TWEETER_AVAILABILITY) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TWEETER_AVAILABILITY = TWEETER_AVAILABILITY;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_MeasurementResult::getTWEETER_AVAILABILITY () const {
    return _TWEETER_AVAILABILITY;
}

inline  T_Aud_MeasurementResultItem::T_Aud_MeasurementResultItem ()  :
    _u8DataId (::masc_main_fi_types::T_e8_Aud_DataId__DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_LF),
    _b32Result ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_Aud_MeasurementResultItem::T_Aud_MeasurementResultItem (const T_Aud_MeasurementResultItem &rhs)  :
    _u8DataId (::masc_main_fi_types::T_e8_Aud_DataId__DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_LF),
    _b32Result ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_Aud_MeasurementResultItem::T_Aud_MeasurementResultItem (T_e8_Aud_DataId u8DataId_, const T_b32_MeasurementResult& b32Result_)  :
    _u8DataId (u8DataId_),
    _b32Result (b32Result_)
{
    #ifndef NDEBUG
    if (!(T_e8_Aud_DataId_IsValid(u8DataId_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8DataId_, "T_e8_Aud_DataId", "u8DataId", "T_Aud_MeasurementResultItem");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_Aud_MeasurementResultItem::~T_Aud_MeasurementResultItem() {
}

inline T_Aud_MeasurementResultItem& T_Aud_MeasurementResultItem::operator = (const T_Aud_MeasurementResultItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8DataId()) {
            setU8DataId(rhs.getU8DataId());
        } else {
            clearU8DataId();
        }
        if (rhs.hasB32Result()) {
            setB32Result(rhs.getB32Result());
        } else {
            clearB32Result();
        }
    }
    return *this;
}

inline bool T_Aud_MeasurementResultItem::operator == (const T_Aud_MeasurementResultItem& rhs) const {
    return (((!hasU8DataId() && !rhs.hasU8DataId()) || getU8DataId() == rhs.getU8DataId()) &&
        ((!hasB32Result() && !rhs.hasB32Result()) || getB32Result() == rhs.getB32Result()));
}

inline bool T_Aud_MeasurementResultItem::operator != (const T_Aud_MeasurementResultItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_Aud_MeasurementResultItem::operator < (const T_Aud_MeasurementResultItem& rhs) const {
    if (hasU8DataId() || rhs.hasU8DataId()) {
        if ((uint32)getU8DataId() < (uint32)rhs.getU8DataId()) return true;
        if ((uint32)getU8DataId() > (uint32)rhs.getU8DataId()) return false;
    }
    if (hasB32Result() || rhs.hasB32Result()) {
        if (getB32Result() < rhs.getB32Result()) return true;
        if (getB32Result() > rhs.getB32Result()) return false;
    }
    return false;
}

inline bool T_Aud_MeasurementResultItem::operator > (const T_Aud_MeasurementResultItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_Aud_MeasurementResultItem::clear() {
    clearU8DataId();
    clearB32Result();
}

inline void T_Aud_MeasurementResultItem::clearU8DataId() {
    if (hasU8DataId()) {
         clear_has_u8DataId();
        _u8DataId = ::masc_main_fi_types::T_e8_Aud_DataId__DATAID_AUDIO_SPEAKER_RESULT_CHANNEL_LF;
     }
}

inline bool T_Aud_MeasurementResultItem::hasU8DataId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_Aud_DataId T_Aud_MeasurementResultItem::getU8DataId () const {
    return _u8DataId;
}

inline void T_Aud_MeasurementResultItem::setU8DataId (T_e8_Aud_DataId u8DataId_) {
    #ifndef NDEBUG
    if (!(T_e8_Aud_DataId_IsValid(u8DataId_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8DataId_, "T_e8_Aud_DataId", "u8DataId", "T_Aud_MeasurementResultItem");
    }
    #endif
    set_has_u8DataId();
    this->_u8DataId = u8DataId_;
}

inline void T_Aud_MeasurementResultItem::clearB32Result() {
    if (hasB32Result()) {
         clear_has_b32Result();
        _b32Result = T_b32_MeasurementResult ();
     }
}

inline bool T_Aud_MeasurementResultItem::hasB32Result () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_b32_MeasurementResult& T_Aud_MeasurementResultItem::getB32Result () const {
    return _b32Result;
}

inline T_b32_MeasurementResult& T_Aud_MeasurementResultItem::getB32ResultMutable () {
    set_has_b32Result();
    return _b32Result;
}

inline void T_Aud_MeasurementResultItem::setB32Result (const T_b32_MeasurementResult& b32Result_) {
    set_has_b32Result();
    this->_b32Result = b32Result_;
}

inline void T_Aud_MeasurementResultItem::set_has_u8DataId () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_Aud_MeasurementResultItem::clear_has_u8DataId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_Aud_MeasurementResultItem::set_has_b32Result () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_Aud_MeasurementResultItem::clear_has_b32Result () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_BOSE_UnitConnectionStatus::T_BOSE_UnitConnectionStatus ()  :
    _e8UnitType (::masc_main_fi_types::T_e8_BOSE_UnitType__AudioAmplifier),
    _bConnected (false),
    _u8AbsenceState (0u),
    _u8MuteState (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_BOSE_UnitConnectionStatus::T_BOSE_UnitConnectionStatus (const T_BOSE_UnitConnectionStatus &rhs)  :
    _e8UnitType (::masc_main_fi_types::T_e8_BOSE_UnitType__AudioAmplifier),
    _bConnected (false),
    _u8AbsenceState (0u),
    _u8MuteState (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_BOSE_UnitConnectionStatus::T_BOSE_UnitConnectionStatus (T_e8_BOSE_UnitType e8UnitType_, bool bConnected_, uint8 u8AbsenceState_, uint8 u8MuteState_)  :
    _e8UnitType (e8UnitType_),
    _bConnected (bConnected_),
    _u8AbsenceState (u8AbsenceState_),
    _u8MuteState (u8MuteState_)
{
    #ifndef NDEBUG
    if (!(T_e8_BOSE_UnitType_IsValid(e8UnitType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8UnitType_, "T_e8_BOSE_UnitType", "e8UnitType", "T_BOSE_UnitConnectionStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_BOSE_UnitConnectionStatus::~T_BOSE_UnitConnectionStatus() {
}

inline T_BOSE_UnitConnectionStatus& T_BOSE_UnitConnectionStatus::operator = (const T_BOSE_UnitConnectionStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8UnitType()) {
            setE8UnitType(rhs.getE8UnitType());
        } else {
            clearE8UnitType();
        }
        if (rhs.hasBConnected()) {
            setBConnected(rhs.getBConnected());
        } else {
            clearBConnected();
        }
        if (rhs.hasU8AbsenceState()) {
            setU8AbsenceState(rhs.getU8AbsenceState());
        } else {
            clearU8AbsenceState();
        }
        if (rhs.hasU8MuteState()) {
            setU8MuteState(rhs.getU8MuteState());
        } else {
            clearU8MuteState();
        }
    }
    return *this;
}

inline bool T_BOSE_UnitConnectionStatus::operator == (const T_BOSE_UnitConnectionStatus& rhs) const {
    return (((!hasE8UnitType() && !rhs.hasE8UnitType()) || getE8UnitType() == rhs.getE8UnitType()) &&
        ((!hasBConnected() && !rhs.hasBConnected()) || getBConnected() == rhs.getBConnected()) &&
        ((!hasU8AbsenceState() && !rhs.hasU8AbsenceState()) || getU8AbsenceState() == rhs.getU8AbsenceState()) &&
        ((!hasU8MuteState() && !rhs.hasU8MuteState()) || getU8MuteState() == rhs.getU8MuteState()));
}

inline bool T_BOSE_UnitConnectionStatus::operator != (const T_BOSE_UnitConnectionStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool T_BOSE_UnitConnectionStatus::operator < (const T_BOSE_UnitConnectionStatus& rhs) const {
    if (hasE8UnitType() || rhs.hasE8UnitType()) {
        if ((uint32)getE8UnitType() < (uint32)rhs.getE8UnitType()) return true;
        if ((uint32)getE8UnitType() > (uint32)rhs.getE8UnitType()) return false;
    }
    if (hasBConnected() || rhs.hasBConnected()) {
        if (getBConnected() < rhs.getBConnected()) return true;
        if (getBConnected() > rhs.getBConnected()) return false;
    }
    if (hasU8AbsenceState() || rhs.hasU8AbsenceState()) {
        if (getU8AbsenceState() < rhs.getU8AbsenceState()) return true;
        if (getU8AbsenceState() > rhs.getU8AbsenceState()) return false;
    }
    if (hasU8MuteState() || rhs.hasU8MuteState()) {
        if (getU8MuteState() < rhs.getU8MuteState()) return true;
        if (getU8MuteState() > rhs.getU8MuteState()) return false;
    }
    return false;
}

inline bool T_BOSE_UnitConnectionStatus::operator > (const T_BOSE_UnitConnectionStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_BOSE_UnitConnectionStatus::clear() {
    clearE8UnitType();
    clearBConnected();
    clearU8AbsenceState();
    clearU8MuteState();
}

inline void T_BOSE_UnitConnectionStatus::clearE8UnitType() {
    if (hasE8UnitType()) {
         clear_has_e8UnitType();
        _e8UnitType = ::masc_main_fi_types::T_e8_BOSE_UnitType__AudioAmplifier;
     }
}

inline bool T_BOSE_UnitConnectionStatus::hasE8UnitType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_BOSE_UnitType T_BOSE_UnitConnectionStatus::getE8UnitType () const {
    return _e8UnitType;
}

inline void T_BOSE_UnitConnectionStatus::setE8UnitType (T_e8_BOSE_UnitType e8UnitType_) {
    #ifndef NDEBUG
    if (!(T_e8_BOSE_UnitType_IsValid(e8UnitType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8UnitType_, "T_e8_BOSE_UnitType", "e8UnitType", "T_BOSE_UnitConnectionStatus");
    }
    #endif
    set_has_e8UnitType();
    this->_e8UnitType = e8UnitType_;
}

inline void T_BOSE_UnitConnectionStatus::clearBConnected() {
    if (hasBConnected()) {
         clear_has_bConnected();
        _bConnected = false;
     }
}

inline bool T_BOSE_UnitConnectionStatus::hasBConnected () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_BOSE_UnitConnectionStatus::getBConnected () const {
    return _bConnected;
}

inline void T_BOSE_UnitConnectionStatus::setBConnected (bool bConnected_) {
    set_has_bConnected();
    this->_bConnected = bConnected_;
}

inline void T_BOSE_UnitConnectionStatus::clearU8AbsenceState() {
    if (hasU8AbsenceState()) {
         clear_has_u8AbsenceState();
        _u8AbsenceState = 0u;
     }
}

inline bool T_BOSE_UnitConnectionStatus::hasU8AbsenceState () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_BOSE_UnitConnectionStatus::getU8AbsenceState () const {
    return _u8AbsenceState;
}

inline void T_BOSE_UnitConnectionStatus::setU8AbsenceState (uint8 u8AbsenceState_) {
    set_has_u8AbsenceState();
    this->_u8AbsenceState = u8AbsenceState_;
}

inline void T_BOSE_UnitConnectionStatus::clearU8MuteState() {
    if (hasU8MuteState()) {
         clear_has_u8MuteState();
        _u8MuteState = 0u;
     }
}

inline bool T_BOSE_UnitConnectionStatus::hasU8MuteState () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_BOSE_UnitConnectionStatus::getU8MuteState () const {
    return _u8MuteState;
}

inline void T_BOSE_UnitConnectionStatus::setU8MuteState (uint8 u8MuteState_) {
    set_has_u8MuteState();
    this->_u8MuteState = u8MuteState_;
}

inline void T_BOSE_UnitConnectionStatus::set_has_e8UnitType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_BOSE_UnitConnectionStatus::clear_has_e8UnitType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_BOSE_UnitConnectionStatus::set_has_bConnected () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_BOSE_UnitConnectionStatus::clear_has_bConnected () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_BOSE_UnitConnectionStatus::set_has_u8AbsenceState () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_BOSE_UnitConnectionStatus::clear_has_u8AbsenceState () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_BOSE_UnitConnectionStatus::set_has_u8MuteState () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_BOSE_UnitConnectionStatus::clear_has_u8MuteState () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_MicrophoneStatus::T_MicrophoneStatus ()  :
    _MicConnection (::masc_main_fi_types::T_e8_MicConnection__UNAVAILABLE),
    _MicResult (::masc_main_fi_types::T_e8_MicResult__NORMAL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MicrophoneStatus::T_MicrophoneStatus (const T_MicrophoneStatus &rhs)  :
    _MicConnection (::masc_main_fi_types::T_e8_MicConnection__UNAVAILABLE),
    _MicResult (::masc_main_fi_types::T_e8_MicResult__NORMAL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MicrophoneStatus::T_MicrophoneStatus (T_e8_MicConnection MicConnection_, T_e8_MicResult MicResult_)  :
    _MicConnection (MicConnection_),
    _MicResult (MicResult_)
{
    #ifndef NDEBUG
    if (!(T_e8_MicConnection_IsValid(MicConnection_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", MicConnection_, "T_e8_MicConnection", "MicConnection", "T_MicrophoneStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_MicResult_IsValid(MicResult_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", MicResult_, "T_e8_MicResult", "MicResult", "T_MicrophoneStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MicrophoneStatus::~T_MicrophoneStatus() {
}

inline T_MicrophoneStatus& T_MicrophoneStatus::operator = (const T_MicrophoneStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasMicConnection()) {
            setMicConnection(rhs.getMicConnection());
        } else {
            clearMicConnection();
        }
        if (rhs.hasMicResult()) {
            setMicResult(rhs.getMicResult());
        } else {
            clearMicResult();
        }
    }
    return *this;
}

inline bool T_MicrophoneStatus::operator == (const T_MicrophoneStatus& rhs) const {
    return (((!hasMicConnection() && !rhs.hasMicConnection()) || getMicConnection() == rhs.getMicConnection()) &&
        ((!hasMicResult() && !rhs.hasMicResult()) || getMicResult() == rhs.getMicResult()));
}

inline bool T_MicrophoneStatus::operator != (const T_MicrophoneStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MicrophoneStatus::operator < (const T_MicrophoneStatus& rhs) const {
    if (hasMicConnection() || rhs.hasMicConnection()) {
        if ((uint32)getMicConnection() < (uint32)rhs.getMicConnection()) return true;
        if ((uint32)getMicConnection() > (uint32)rhs.getMicConnection()) return false;
    }
    if (hasMicResult() || rhs.hasMicResult()) {
        if ((uint32)getMicResult() < (uint32)rhs.getMicResult()) return true;
        if ((uint32)getMicResult() > (uint32)rhs.getMicResult()) return false;
    }
    return false;
}

inline bool T_MicrophoneStatus::operator > (const T_MicrophoneStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MicrophoneStatus::clear() {
    clearMicConnection();
    clearMicResult();
}

inline void T_MicrophoneStatus::clearMicConnection() {
    if (hasMicConnection()) {
         clear_has_MicConnection();
        _MicConnection = ::masc_main_fi_types::T_e8_MicConnection__UNAVAILABLE;
     }
}

inline bool T_MicrophoneStatus::hasMicConnection () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_MicConnection T_MicrophoneStatus::getMicConnection () const {
    return _MicConnection;
}

inline void T_MicrophoneStatus::setMicConnection (T_e8_MicConnection MicConnection_) {
    #ifndef NDEBUG
    if (!(T_e8_MicConnection_IsValid(MicConnection_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", MicConnection_, "T_e8_MicConnection", "MicConnection", "T_MicrophoneStatus");
    }
    #endif
    set_has_MicConnection();
    this->_MicConnection = MicConnection_;
}

inline void T_MicrophoneStatus::clearMicResult() {
    if (hasMicResult()) {
         clear_has_MicResult();
        _MicResult = ::masc_main_fi_types::T_e8_MicResult__NORMAL;
     }
}

inline bool T_MicrophoneStatus::hasMicResult () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_MicResult T_MicrophoneStatus::getMicResult () const {
    return _MicResult;
}

inline void T_MicrophoneStatus::setMicResult (T_e8_MicResult MicResult_) {
    #ifndef NDEBUG
    if (!(T_e8_MicResult_IsValid(MicResult_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", MicResult_, "T_e8_MicResult", "MicResult", "T_MicrophoneStatus");
    }
    #endif
    set_has_MicResult();
    this->_MicResult = MicResult_;
}

inline void T_MicrophoneStatus::set_has_MicConnection () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MicrophoneStatus::clear_has_MicConnection () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MicrophoneStatus::set_has_MicResult () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MicrophoneStatus::clear_has_MicResult () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_MicrophoneResult::T_MicrophoneResult ()  :
    _Mic1Result (),
    _Mic2Result (),
    _Mic3Result (),
    _Mic4Result ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MicrophoneResult::T_MicrophoneResult (const T_MicrophoneResult &rhs)  :
    _Mic1Result (),
    _Mic2Result (),
    _Mic3Result (),
    _Mic4Result ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MicrophoneResult::T_MicrophoneResult (const T_MicrophoneStatus& Mic1Result_, const T_MicrophoneStatus& Mic2Result_, const T_MicrophoneStatus& Mic3Result_, const T_MicrophoneStatus& Mic4Result_)  :
    _Mic1Result (Mic1Result_),
    _Mic2Result (Mic2Result_),
    _Mic3Result (Mic3Result_),
    _Mic4Result (Mic4Result_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MicrophoneResult::~T_MicrophoneResult() {
}

inline T_MicrophoneResult& T_MicrophoneResult::operator = (const T_MicrophoneResult& rhs) {
    if( this != &rhs ) {
        if (rhs.hasMic1Result()) {
            setMic1Result(rhs.getMic1Result());
        } else {
            clearMic1Result();
        }
        if (rhs.hasMic2Result()) {
            setMic2Result(rhs.getMic2Result());
        } else {
            clearMic2Result();
        }
        if (rhs.hasMic3Result()) {
            setMic3Result(rhs.getMic3Result());
        } else {
            clearMic3Result();
        }
        if (rhs.hasMic4Result()) {
            setMic4Result(rhs.getMic4Result());
        } else {
            clearMic4Result();
        }
    }
    return *this;
}

inline bool T_MicrophoneResult::operator == (const T_MicrophoneResult& rhs) const {
    return (((!hasMic1Result() && !rhs.hasMic1Result()) || getMic1Result() == rhs.getMic1Result()) &&
        ((!hasMic2Result() && !rhs.hasMic2Result()) || getMic2Result() == rhs.getMic2Result()) &&
        ((!hasMic3Result() && !rhs.hasMic3Result()) || getMic3Result() == rhs.getMic3Result()) &&
        ((!hasMic4Result() && !rhs.hasMic4Result()) || getMic4Result() == rhs.getMic4Result()));
}

inline bool T_MicrophoneResult::operator != (const T_MicrophoneResult& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MicrophoneResult::operator < (const T_MicrophoneResult& rhs) const {
    if (hasMic1Result() || rhs.hasMic1Result()) {
        if (getMic1Result() < rhs.getMic1Result()) return true;
        if (getMic1Result() > rhs.getMic1Result()) return false;
    }
    if (hasMic2Result() || rhs.hasMic2Result()) {
        if (getMic2Result() < rhs.getMic2Result()) return true;
        if (getMic2Result() > rhs.getMic2Result()) return false;
    }
    if (hasMic3Result() || rhs.hasMic3Result()) {
        if (getMic3Result() < rhs.getMic3Result()) return true;
        if (getMic3Result() > rhs.getMic3Result()) return false;
    }
    if (hasMic4Result() || rhs.hasMic4Result()) {
        if (getMic4Result() < rhs.getMic4Result()) return true;
        if (getMic4Result() > rhs.getMic4Result()) return false;
    }
    return false;
}

inline bool T_MicrophoneResult::operator > (const T_MicrophoneResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MicrophoneResult::clear() {
    clearMic1Result();
    clearMic2Result();
    clearMic3Result();
    clearMic4Result();
}

inline void T_MicrophoneResult::clearMic1Result() {
    if (hasMic1Result()) {
         clear_has_Mic1Result();
        _Mic1Result.clear();
     }
}

inline bool T_MicrophoneResult::hasMic1Result () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_MicrophoneStatus& T_MicrophoneResult::getMic1Result () const {
    return _Mic1Result;
}

inline T_MicrophoneStatus& T_MicrophoneResult::getMic1ResultMutable () {
    set_has_Mic1Result();
    return _Mic1Result;
}

inline void T_MicrophoneResult::setMic1Result (const T_MicrophoneStatus& Mic1Result_) {
    set_has_Mic1Result();
    this->_Mic1Result = Mic1Result_;
}

inline void T_MicrophoneResult::clearMic2Result() {
    if (hasMic2Result()) {
         clear_has_Mic2Result();
        _Mic2Result.clear();
     }
}

inline bool T_MicrophoneResult::hasMic2Result () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_MicrophoneStatus& T_MicrophoneResult::getMic2Result () const {
    return _Mic2Result;
}

inline T_MicrophoneStatus& T_MicrophoneResult::getMic2ResultMutable () {
    set_has_Mic2Result();
    return _Mic2Result;
}

inline void T_MicrophoneResult::setMic2Result (const T_MicrophoneStatus& Mic2Result_) {
    set_has_Mic2Result();
    this->_Mic2Result = Mic2Result_;
}

inline void T_MicrophoneResult::clearMic3Result() {
    if (hasMic3Result()) {
         clear_has_Mic3Result();
        _Mic3Result.clear();
     }
}

inline bool T_MicrophoneResult::hasMic3Result () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const T_MicrophoneStatus& T_MicrophoneResult::getMic3Result () const {
    return _Mic3Result;
}

inline T_MicrophoneStatus& T_MicrophoneResult::getMic3ResultMutable () {
    set_has_Mic3Result();
    return _Mic3Result;
}

inline void T_MicrophoneResult::setMic3Result (const T_MicrophoneStatus& Mic3Result_) {
    set_has_Mic3Result();
    this->_Mic3Result = Mic3Result_;
}

inline void T_MicrophoneResult::clearMic4Result() {
    if (hasMic4Result()) {
         clear_has_Mic4Result();
        _Mic4Result.clear();
     }
}

inline bool T_MicrophoneResult::hasMic4Result () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const T_MicrophoneStatus& T_MicrophoneResult::getMic4Result () const {
    return _Mic4Result;
}

inline T_MicrophoneStatus& T_MicrophoneResult::getMic4ResultMutable () {
    set_has_Mic4Result();
    return _Mic4Result;
}

inline void T_MicrophoneResult::setMic4Result (const T_MicrophoneStatus& Mic4Result_) {
    set_has_Mic4Result();
    this->_Mic4Result = Mic4Result_;
}

inline void T_MicrophoneResult::set_has_Mic1Result () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MicrophoneResult::clear_has_Mic1Result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MicrophoneResult::set_has_Mic2Result () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MicrophoneResult::clear_has_Mic2Result () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MicrophoneResult::set_has_Mic3Result () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MicrophoneResult::clear_has_Mic3Result () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_MicrophoneResult::set_has_Mic4Result () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_MicrophoneResult::clear_has_Mic4Result () {
    _has_bits_[0] &= ~ (1u << 3);
}

} // namespace masc_main_fi_types

#endif // MASC_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
