#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef LCMDBUSCLIENT_MAIN_FI_TYPES_H
#define LCMDBUSCLIENT_MAIN_FI_TYPES_H

#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include <cstring>
#include <vector>

/**
 * Types lcmdbusclient_main_fi_types
 */

namespace lcmdbusclient_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class TheDevInfo;

// type definitions
/**
 * If the meaning of "TheSubsystemList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< TheDevInfo > TheSubsystemList;


/**
 * If the meaning of "TheDevInfo" isn't clear, then there should be a description here.
 */
class TheDevInfo {
public:

    /**
     * Default constructor
     */
    inline  TheDevInfo ();

    /**
     * Copy constructor
     */
    inline  TheDevInfo (const TheDevInfo &rhs);

    /**
     * All fields constructor
     */
    inline  TheDevInfo (uint8 devId_, uint8 devIP_, uint16 devError_);

    /**
     * Destructor
     */
    inline  ~TheDevInfo();

    /**
     * Assignment operator
     */
    inline TheDevInfo& operator = (const TheDevInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TheDevInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TheDevInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TheDevInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TheDevInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "devId"

    static const int kDevId = 0;

    /**
     * Clears the field "devId".
     *
     * The field will be set to its default value. The hasDevId()
     * method will return false.
     */
    inline void clearDevId();

    /**
     * Checks whether the field "devId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevId()). Otherwise it will return false.
     */
    inline bool hasDevId () const;

    /**
     * Returns the value of the member "devId".
     *
     * If the meaning of "devId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "devId"
     */
    inline uint8 getDevId () const;

    /**
     * Sets the value of the member "devId".
     *
     * If the meaning of "devId" isn't clear, then there should be a description here.
     *
     * @param devId The value which will be set
     */
    inline void setDevId (uint8 devId_);

    // API of field "devIP"

    static const int kDevIP = 1;

    /**
     * Clears the field "devIP".
     *
     * The field will be set to its default value. The hasDevIP()
     * method will return false.
     */
    inline void clearDevIP();

    /**
     * Checks whether the field "devIP" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevIP()). Otherwise it will return false.
     */
    inline bool hasDevIP () const;

    /**
     * Returns the value of the member "devIP".
     *
     * If the meaning of "devIP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "devIP"
     */
    inline uint8 getDevIP () const;

    /**
     * Sets the value of the member "devIP".
     *
     * If the meaning of "devIP" isn't clear, then there should be a description here.
     *
     * @param devIP The value which will be set
     */
    inline void setDevIP (uint8 devIP_);

    // API of field "devError"

    static const int kDevError = 2;

    /**
     * Clears the field "devError".
     *
     * The field will be set to its default value. The hasDevError()
     * method will return false.
     */
    inline void clearDevError();

    /**
     * Checks whether the field "devError" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevError()). Otherwise it will return false.
     */
    inline bool hasDevError () const;

    /**
     * Returns the value of the member "devError".
     *
     * If the meaning of "devError" isn't clear, then there should be a description here.
     *
     * @return The value of the field "devError"
     */
    inline uint16 getDevError () const;

    /**
     * Sets the value of the member "devError".
     *
     * If the meaning of "devError" isn't clear, then there should be a description here.
     *
     * @param devError The value which will be set
     */
    inline void setDevError (uint16 devError_);

    static const TheDevInfo &getDefaultInstance();

private:

    inline void set_has_devId ();

    inline void clear_has_devId ();

    inline void set_has_devIP ();

    inline void clear_has_devIP ();

    inline void set_has_devError ();

    inline void clear_has_devError ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _devId;

    uint8 _devIP;

    uint16 _devError;

};

inline  TheDevInfo::TheDevInfo ()  :
    _devId (0u),
    _devIP (0u),
    _devError (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TheDevInfo::TheDevInfo (const TheDevInfo &rhs)  :
    _devId (0u),
    _devIP (0u),
    _devError (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TheDevInfo::TheDevInfo (uint8 devId_, uint8 devIP_, uint16 devError_)  :
    _devId (devId_),
    _devIP (devIP_),
    _devError (devError_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TheDevInfo::~TheDevInfo() {
}

inline TheDevInfo& TheDevInfo::operator = (const TheDevInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDevId()) {
            setDevId(rhs.getDevId());
        } else {
            clearDevId();
        }
        if (rhs.hasDevIP()) {
            setDevIP(rhs.getDevIP());
        } else {
            clearDevIP();
        }
        if (rhs.hasDevError()) {
            setDevError(rhs.getDevError());
        } else {
            clearDevError();
        }
    }
    return *this;
}

inline bool TheDevInfo::operator == (const TheDevInfo& rhs) const {
    return (((!hasDevId() && !rhs.hasDevId()) || getDevId() == rhs.getDevId()) &&
        ((!hasDevIP() && !rhs.hasDevIP()) || getDevIP() == rhs.getDevIP()) &&
        ((!hasDevError() && !rhs.hasDevError()) || getDevError() == rhs.getDevError()));
}

inline bool TheDevInfo::operator != (const TheDevInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool TheDevInfo::operator < (const TheDevInfo& rhs) const {
    if (hasDevId() || rhs.hasDevId()) {
        if (getDevId() < rhs.getDevId()) return true;
        if (getDevId() > rhs.getDevId()) return false;
    }
    if (hasDevIP() || rhs.hasDevIP()) {
        if (getDevIP() < rhs.getDevIP()) return true;
        if (getDevIP() > rhs.getDevIP()) return false;
    }
    if (hasDevError() || rhs.hasDevError()) {
        if (getDevError() < rhs.getDevError()) return true;
        if (getDevError() > rhs.getDevError()) return false;
    }
    return false;
}

inline bool TheDevInfo::operator > (const TheDevInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TheDevInfo::clear() {
    clearDevId();
    clearDevIP();
    clearDevError();
}

inline void TheDevInfo::clearDevId() {
    if (hasDevId()) {
         clear_has_devId();
        _devId = 0u;
     }
}

inline bool TheDevInfo::hasDevId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 TheDevInfo::getDevId () const {
    return _devId;
}

inline void TheDevInfo::setDevId (uint8 devId_) {
    set_has_devId();
    this->_devId = devId_;
}

inline void TheDevInfo::clearDevIP() {
    if (hasDevIP()) {
         clear_has_devIP();
        _devIP = 0u;
     }
}

inline bool TheDevInfo::hasDevIP () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 TheDevInfo::getDevIP () const {
    return _devIP;
}

inline void TheDevInfo::setDevIP (uint8 devIP_) {
    set_has_devIP();
    this->_devIP = devIP_;
}

inline void TheDevInfo::clearDevError() {
    if (hasDevError()) {
         clear_has_devError();
        _devError = 0u;
     }
}

inline bool TheDevInfo::hasDevError () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 TheDevInfo::getDevError () const {
    return _devError;
}

inline void TheDevInfo::setDevError (uint16 devError_) {
    set_has_devError();
    this->_devError = devError_;
}

inline void TheDevInfo::set_has_devId () {
    _has_bits_[0] |= 1u << 0;
}

inline void TheDevInfo::clear_has_devId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void TheDevInfo::set_has_devIP () {
    _has_bits_[0] |= 1u << 1;
}

inline void TheDevInfo::clear_has_devIP () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void TheDevInfo::set_has_devError () {
    _has_bits_[0] |= 1u << 2;
}

inline void TheDevInfo::clear_has_devError () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace lcmdbusclient_main_fi_types

#endif // LCMDBUSCLIENT_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
