#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef LCMDBUSCLIENT_MAIN_FI_H
#define LCMDBUSCLIENT_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "lcmdbusclient_main_fi_types.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'lcmdbusclient_main_fi'
 *
 * Fullname: LCM DBus Client CCA Service, Application Functional Interface
 *
 * Version:
 *
 * Author: -Piyush Priye--
 *
 * Date: --05 Aug 2020--
 *
 * Department:
 *
 * Title: lcmdbusclient_fi
 *
 * <b>Description of 'lcmdbusclient_main_fi':</b>
 *
 * FI types for LCM DBus client
 */

namespace lcmdbusclient_main_fi {

static const int SERVICE_ID = 215;

static const int FID_CurrentSource = 4096;

static const int FID_NanomsgStatus = 4097;

static const int FID_SubsystemerrorStatus = 4098;

static const int FID_VoltagelevelStatus = 4099;

static const int FID_CockpitmodeStatus = 4100;

static const int FID_ThermallevelStatus = 4101;

static const int FID_DoorUnlockStatus = 4102;

static const int FID_PNMGRP10SignalStatus = 4103;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 4;

// forward declarations
class CurrentSourceStatus;

class NanomsgStatusStatus;

class NanomsgStatusSet;

class SubsystemerrorStatusStatus;

class SubsystemerrorStatusSet;

class VoltagelevelStatusStatus;

class VoltagelevelStatusSet;

class CockpitmodeStatusStatus;

class CockpitmodeStatusSet;

class ThermallevelStatusStatus;

class ThermallevelStatusSet;

class DoorUnlockStatusStatus;

class DoorUnlockStatusSet;

class PNMGRP10SignalStatusStatus;

class PNMGRP10SignalStatusSet;

// type definitions
/**
 * The get message of the property "CurrentSource"
 * Message to request the current KeyPressed List
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CurrentSourceGet;

/**
 * The upreg message of the property "CurrentSource"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CurrentSourceUpReg;

/**
 * The relUpReg message of the property "CurrentSource"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CurrentSourceRelUpReg;

/**
 * The error message of 'CurrentSource'
 */
typedef ::asf::cca::CcaTypes::DefaultError CurrentSourceError;

/**
 * The get message of the property "NanomsgStatus"
 * NanomsgStatus Active / In-active
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NanomsgStatusGet;

/**
 * The upreg message of the property "NanomsgStatus"
 * NanomsgStatus Active / In-active
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NanomsgStatusUpReg;

/**
 * The relUpReg message of the property "NanomsgStatus"
 * NanomsgStatus Active / In-active
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NanomsgStatusRelUpReg;

/**
 * The error message of 'NanomsgStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError NanomsgStatusError;

/**
 * The get message of the property "SubsystemerrorStatus"
 * Error Status for different sub-system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SubsystemerrorStatusGet;

/**
 * The upreg message of the property "SubsystemerrorStatus"
 * Error Status for different sub-system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SubsystemerrorStatusUpReg;

/**
 * The relUpReg message of the property "SubsystemerrorStatus"
 * Error Status for different sub-system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SubsystemerrorStatusRelUpReg;

/**
 * The error message of 'SubsystemerrorStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError SubsystemerrorStatusError;

/**
 * The get message of the property "VoltagelevelStatus"
 * Voltage Value
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VoltagelevelStatusGet;

/**
 * The upreg message of the property "VoltagelevelStatus"
 * Voltage Value
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VoltagelevelStatusUpReg;

/**
 * The relUpReg message of the property "VoltagelevelStatus"
 * Voltage Value
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VoltagelevelStatusRelUpReg;

/**
 * The error message of 'VoltagelevelStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError VoltagelevelStatusError;

/**
 * The get message of the property "CockpitmodeStatus"
 * Cockpit mode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CockpitmodeStatusGet;

/**
 * The upreg message of the property "CockpitmodeStatus"
 * Cockpit mode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CockpitmodeStatusUpReg;

/**
 * The relUpReg message of the property "CockpitmodeStatus"
 * Cockpit mode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CockpitmodeStatusRelUpReg;

/**
 * The error message of 'CockpitmodeStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError CockpitmodeStatusError;

/**
 * The get message of the property "ThermallevelStatus"
 * Temperature level
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ThermallevelStatusGet;

/**
 * The upreg message of the property "ThermallevelStatus"
 * Temperature level
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ThermallevelStatusUpReg;

/**
 * The relUpReg message of the property "ThermallevelStatus"
 * Temperature level
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ThermallevelStatusRelUpReg;

/**
 * The error message of 'ThermallevelStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError ThermallevelStatusError;

/**
 * The get message of the property "DoorUnlockStatus"
 * DoorUnlockStatus Active / In-active
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DoorUnlockStatusGet;

/**
 * The upreg message of the property "DoorUnlockStatus"
 * DoorUnlockStatus Active / In-active
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DoorUnlockStatusUpReg;

/**
 * The relUpReg message of the property "DoorUnlockStatus"
 * DoorUnlockStatus Active / In-active
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DoorUnlockStatusRelUpReg;

/**
 * The error message of 'DoorUnlockStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError DoorUnlockStatusError;

/**
 * The get message of the property "PNMGRP10SignalStatus"
 * PNMGRP10Signal status Active / In-active
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PNMGRP10SignalStatusGet;

/**
 * The upreg message of the property "PNMGRP10SignalStatus"
 * PNMGRP10Signal status Active / In-active
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PNMGRP10SignalStatusUpReg;

/**
 * The relUpReg message of the property "PNMGRP10SignalStatus"
 * PNMGRP10Signal status Active / In-active
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PNMGRP10SignalStatusRelUpReg;

/**
 * The error message of 'PNMGRP10SignalStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError PNMGRP10SignalStatusError;


/**
 * The status message of the property "CurrentSource"
 */
class CurrentSourceStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CurrentSourceStatus ();

    /**
     * Copy constructor
     */
    inline  CurrentSourceStatus (const CurrentSourceStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CurrentSourceStatus (const ::std::string& strSourceName_);

    /**
     * Destructor
     */
    inline virtual  ~CurrentSourceStatus();

    /**
     * Assignment operator
     */
    inline CurrentSourceStatus& operator = (const CurrentSourceStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurrentSourceStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurrentSourceStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurrentSourceStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurrentSourceStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strSourceName"

    static const int kStrSourceName = 0;

    /**
     * Clears the field "strSourceName".
     *
     * The field will be set to its default value. The hasStrSourceName()
     * method will return false.
     */
    inline void clearStrSourceName();

    /**
     * Checks whether the field "strSourceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrSourceName()). Otherwise it will return false.
     */
    inline bool hasStrSourceName () const;

    /**
     * Returns the value of the member "strSourceName".
     *
     *
     *
     * @return The value of the field "strSourceName"
     */
    inline const ::std::string& getStrSourceName () const;

    /**
     * Retrieves the value of the field "strSourceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strSourceName".
     */
    inline ::std::string& getStrSourceNameMutable ();

    /**
     * Sets the value of the member "strSourceName".
     *
     *
     *
     * @param strSourceName The value which will be set
     */
    inline void setStrSourceName (const ::std::string& strSourceName_);

    /**
     * Sets the value of the member "strSourceName".
     *
     *
     *
     * @param strSourceName The value which will be set
     */
    inline void setStrSourceName (const char* strSourceName_);

    /**
     * Sets the value of the member "strSourceName".
     *
     *
     *
     * @param strSourceName The value which will be set
     */
    inline void setStrSourceName (const char* value, size_t size);

    static const CurrentSourceStatus &getDefaultInstance();

private:

    inline void set_has_strSourceName ();

    inline void clear_has_strSourceName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _strSourceName;

};

/**
 * The status message of the property "NanomsgStatus"
 * NanomsgStatus Active / In-active
 */
class NanomsgStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NanomsgStatusStatus ();

    /**
     * Copy constructor
     */
    inline  NanomsgStatusStatus (const NanomsgStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  NanomsgStatusStatus (bool Nanomsgconstate_);

    /**
     * Destructor
     */
    inline virtual  ~NanomsgStatusStatus();

    /**
     * Assignment operator
     */
    inline NanomsgStatusStatus& operator = (const NanomsgStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NanomsgStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NanomsgStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NanomsgStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NanomsgStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Nanomsgconstate"

    static const int kNanomsgconstate = 0;

    /**
     * Clears the field "Nanomsgconstate".
     *
     * The field will be set to its default value. The hasNanomsgconstate()
     * method will return false.
     */
    inline void clearNanomsgconstate();

    /**
     * Checks whether the field "Nanomsgconstate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNanomsgconstate()). Otherwise it will return false.
     */
    inline bool hasNanomsgconstate () const;

    /**
     * Returns the value of the member "Nanomsgconstate".
     *
     * If the meaning of "Nanomsgconstate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Nanomsgconstate"
     */
    inline bool getNanomsgconstate () const;

    /**
     * Sets the value of the member "Nanomsgconstate".
     *
     * If the meaning of "Nanomsgconstate" isn't clear, then there should be a description here.
     *
     * @param Nanomsgconstate The value which will be set
     */
    inline void setNanomsgconstate (bool Nanomsgconstate_);

    static const NanomsgStatusStatus &getDefaultInstance();

private:

    inline void set_has_Nanomsgconstate ();

    inline void clear_has_Nanomsgconstate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Nanomsgconstate;

};

/**
 * The set message of the property "NanomsgStatus"
 * NanomsgStatus Active / In-active
 */
class NanomsgStatusSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NanomsgStatusSet ();

    /**
     * Copy constructor
     */
    inline  NanomsgStatusSet (const NanomsgStatusSet &rhs);

    /**
     * All fields constructor
     */
    inline  NanomsgStatusSet (bool Nanomsgconstate_);

    /**
     * Destructor
     */
    inline virtual  ~NanomsgStatusSet();

    /**
     * Assignment operator
     */
    inline NanomsgStatusSet& operator = (const NanomsgStatusSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NanomsgStatusSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NanomsgStatusSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NanomsgStatusSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NanomsgStatusSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Nanomsgconstate"

    static const int kNanomsgconstate = 0;

    /**
     * Clears the field "Nanomsgconstate".
     *
     * The field will be set to its default value. The hasNanomsgconstate()
     * method will return false.
     */
    inline void clearNanomsgconstate();

    /**
     * Checks whether the field "Nanomsgconstate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNanomsgconstate()). Otherwise it will return false.
     */
    inline bool hasNanomsgconstate () const;

    /**
     * Returns the value of the member "Nanomsgconstate".
     *
     * If the meaning of "Nanomsgconstate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Nanomsgconstate"
     */
    inline bool getNanomsgconstate () const;

    /**
     * Sets the value of the member "Nanomsgconstate".
     *
     * If the meaning of "Nanomsgconstate" isn't clear, then there should be a description here.
     *
     * @param Nanomsgconstate The value which will be set
     */
    inline void setNanomsgconstate (bool Nanomsgconstate_);

    static const NanomsgStatusSet &getDefaultInstance();

private:

    inline void set_has_Nanomsgconstate ();

    inline void clear_has_Nanomsgconstate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _Nanomsgconstate;

};

/**
 * The status message of the property "SubsystemerrorStatus"
 * Error Status for different sub-system
 * Byte0 - Dev Id
 * Byte1 - Device IP (Last 1 bytes)
 * Byte2,3 - Error details
 * below devError is used for error handling
 * bit 0, 1 Nanomessage error / No error( see below details )
 * 0 - evaluating , 1 - No error, 2 - error , 3 - Reserved
 * bit 2, 3 avdecc error error / No error ( see below details )
 * 0 - evaluating , 1 - No error, 2 - error , 3 - Reserved
 * bit 4, 5 ethernet link error(TBD)
 * bit 6, 7, 8 voltage error ( see below details )
 * 0 - Evaluating, 1 - No Error, 2 - Over Warning Voltage Error, 3 - Over Critical Voltage Error, 4 - Under Warning Voltage Error, 5 - Under Critical Voltage Error, 6 - Reserved, 7 - Reserved
 * bit 9, 10, 11 thermal error ( see below details )
 * 0 - Evaluating, 1 - No Error, 2 - High Thermal Error, 3 - Critical High Thermal Error, 4 - Over Critical Thermal Error, 5 - Low Thermal Error, 6 - Critical Low Thermal Error,
 * 7 - Under Critical Low Thermal Error
 * bit 12, 13, 14 PNMGRP_10 ( see below details )
 * 1 - not active , 2 - active
 * 0- Undefined, 3- ON, 4- User off, 5- Protected Off, 6- SW update, 7- Diagnosis
 * bit 15 HourLogic timeout ( see below details )
 * 0 - not active , 1 - active
 */
class SubsystemerrorStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SubsystemerrorStatusStatus ();

    /**
     * Copy constructor
     */
    inline  SubsystemerrorStatusStatus (const SubsystemerrorStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SubsystemerrorStatusStatus (const ::lcmdbusclient_main_fi_types::TheSubsystemList& Subsystemerrorconstate_);

    /**
     * Destructor
     */
    inline virtual  ~SubsystemerrorStatusStatus();

    /**
     * Assignment operator
     */
    inline SubsystemerrorStatusStatus& operator = (const SubsystemerrorStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SubsystemerrorStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SubsystemerrorStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SubsystemerrorStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SubsystemerrorStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Subsystemerrorconstate"

    static const int kSubsystemerrorconstate = 0;

    /**
     * Clears the field "Subsystemerrorconstate".
     *
     * The field will be set to its default value. The hasSubsystemerrorconstate()
     * method will return false.
     */
    inline void clearSubsystemerrorconstate();

    /**
     * Checks whether the field "Subsystemerrorconstate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubsystemerrorconstate()). Otherwise it will return false.
     */
    inline bool hasSubsystemerrorconstate () const;

    /**
     * Returns the value of the member "Subsystemerrorconstate".
     *
     * If the meaning of "Subsystemerrorconstate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Subsystemerrorconstate"
     */
    inline const ::lcmdbusclient_main_fi_types::TheSubsystemList& getSubsystemerrorconstate () const;

    /**
     * Retrieves the value of the field "Subsystemerrorconstate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Subsystemerrorconstate".
     */
    inline ::lcmdbusclient_main_fi_types::TheSubsystemList& getSubsystemerrorconstateMutable ();

    /**
     * Sets the value of the member "Subsystemerrorconstate".
     *
     * If the meaning of "Subsystemerrorconstate" isn't clear, then there should be a description here.
     *
     * @param Subsystemerrorconstate The value which will be set
     */
    inline void setSubsystemerrorconstate (const ::lcmdbusclient_main_fi_types::TheSubsystemList& Subsystemerrorconstate_);

    static const SubsystemerrorStatusStatus &getDefaultInstance();

private:

    static const ::std::vector< ::lcmdbusclient_main_fi_types::TheDevInfo >& getTheDevInfoList_DefaultInstance ();

    inline void set_has_Subsystemerrorconstate ();

    inline void clear_has_Subsystemerrorconstate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::lcmdbusclient_main_fi_types::TheSubsystemList _Subsystemerrorconstate;

};

/**
 * The set message of the property "SubsystemerrorStatus"
 * Error Status for different sub-system
 */
class SubsystemerrorStatusSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SubsystemerrorStatusSet ();

    /**
     * Copy constructor
     */
    inline  SubsystemerrorStatusSet (const SubsystemerrorStatusSet &rhs);

    /**
     * All fields constructor
     */
    inline  SubsystemerrorStatusSet (const ::lcmdbusclient_main_fi_types::TheSubsystemList& Subsystemerrorconstate_);

    /**
     * Destructor
     */
    inline virtual  ~SubsystemerrorStatusSet();

    /**
     * Assignment operator
     */
    inline SubsystemerrorStatusSet& operator = (const SubsystemerrorStatusSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SubsystemerrorStatusSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SubsystemerrorStatusSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SubsystemerrorStatusSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SubsystemerrorStatusSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Subsystemerrorconstate"

    static const int kSubsystemerrorconstate = 0;

    /**
     * Clears the field "Subsystemerrorconstate".
     *
     * The field will be set to its default value. The hasSubsystemerrorconstate()
     * method will return false.
     */
    inline void clearSubsystemerrorconstate();

    /**
     * Checks whether the field "Subsystemerrorconstate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubsystemerrorconstate()). Otherwise it will return false.
     */
    inline bool hasSubsystemerrorconstate () const;

    /**
     * Returns the value of the member "Subsystemerrorconstate".
     *
     * If the meaning of "Subsystemerrorconstate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Subsystemerrorconstate"
     */
    inline const ::lcmdbusclient_main_fi_types::TheSubsystemList& getSubsystemerrorconstate () const;

    /**
     * Retrieves the value of the field "Subsystemerrorconstate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Subsystemerrorconstate".
     */
    inline ::lcmdbusclient_main_fi_types::TheSubsystemList& getSubsystemerrorconstateMutable ();

    /**
     * Sets the value of the member "Subsystemerrorconstate".
     *
     * If the meaning of "Subsystemerrorconstate" isn't clear, then there should be a description here.
     *
     * @param Subsystemerrorconstate The value which will be set
     */
    inline void setSubsystemerrorconstate (const ::lcmdbusclient_main_fi_types::TheSubsystemList& Subsystemerrorconstate_);

    static const SubsystemerrorStatusSet &getDefaultInstance();

private:

    static const ::std::vector< ::lcmdbusclient_main_fi_types::TheDevInfo >& getTheDevInfoList_DefaultInstance ();

    inline void set_has_Subsystemerrorconstate ();

    inline void clear_has_Subsystemerrorconstate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::lcmdbusclient_main_fi_types::TheSubsystemList _Subsystemerrorconstate;

};

/**
 * The status message of the property "VoltagelevelStatus"
 * Voltage Value
 */
class VoltagelevelStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VoltagelevelStatusStatus ();

    /**
     * Copy constructor
     */
    inline  VoltagelevelStatusStatus (const VoltagelevelStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VoltagelevelStatusStatus (uint8 Voltagelevelconstate_);

    /**
     * Destructor
     */
    inline virtual  ~VoltagelevelStatusStatus();

    /**
     * Assignment operator
     */
    inline VoltagelevelStatusStatus& operator = (const VoltagelevelStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoltagelevelStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoltagelevelStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoltagelevelStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoltagelevelStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Voltagelevelconstate"

    static const int kVoltagelevelconstate = 0;

    /**
     * Clears the field "Voltagelevelconstate".
     *
     * The field will be set to its default value. The hasVoltagelevelconstate()
     * method will return false.
     */
    inline void clearVoltagelevelconstate();

    /**
     * Checks whether the field "Voltagelevelconstate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoltagelevelconstate()). Otherwise it will return false.
     */
    inline bool hasVoltagelevelconstate () const;

    /**
     * Returns the value of the member "Voltagelevelconstate".
     *
     * If the meaning of "Voltagelevelconstate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Voltagelevelconstate"
     */
    inline uint8 getVoltagelevelconstate () const;

    /**
     * Sets the value of the member "Voltagelevelconstate".
     *
     * If the meaning of "Voltagelevelconstate" isn't clear, then there should be a description here.
     *
     * @param Voltagelevelconstate The value which will be set
     */
    inline void setVoltagelevelconstate (uint8 Voltagelevelconstate_);

    static const VoltagelevelStatusStatus &getDefaultInstance();

private:

    inline void set_has_Voltagelevelconstate ();

    inline void clear_has_Voltagelevelconstate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Voltagelevelconstate;

};

/**
 * The set message of the property "VoltagelevelStatus"
 * Voltage Value
 */
class VoltagelevelStatusSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VoltagelevelStatusSet ();

    /**
     * Copy constructor
     */
    inline  VoltagelevelStatusSet (const VoltagelevelStatusSet &rhs);

    /**
     * All fields constructor
     */
    inline  VoltagelevelStatusSet (uint8 Voltagelevelconstate_);

    /**
     * Destructor
     */
    inline virtual  ~VoltagelevelStatusSet();

    /**
     * Assignment operator
     */
    inline VoltagelevelStatusSet& operator = (const VoltagelevelStatusSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoltagelevelStatusSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoltagelevelStatusSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoltagelevelStatusSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoltagelevelStatusSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Voltagelevelconstate"

    static const int kVoltagelevelconstate = 0;

    /**
     * Clears the field "Voltagelevelconstate".
     *
     * The field will be set to its default value. The hasVoltagelevelconstate()
     * method will return false.
     */
    inline void clearVoltagelevelconstate();

    /**
     * Checks whether the field "Voltagelevelconstate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoltagelevelconstate()). Otherwise it will return false.
     */
    inline bool hasVoltagelevelconstate () const;

    /**
     * Returns the value of the member "Voltagelevelconstate".
     *
     * If the meaning of "Voltagelevelconstate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Voltagelevelconstate"
     */
    inline uint8 getVoltagelevelconstate () const;

    /**
     * Sets the value of the member "Voltagelevelconstate".
     *
     * If the meaning of "Voltagelevelconstate" isn't clear, then there should be a description here.
     *
     * @param Voltagelevelconstate The value which will be set
     */
    inline void setVoltagelevelconstate (uint8 Voltagelevelconstate_);

    static const VoltagelevelStatusSet &getDefaultInstance();

private:

    inline void set_has_Voltagelevelconstate ();

    inline void clear_has_Voltagelevelconstate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Voltagelevelconstate;

};

/**
 * The status message of the property "CockpitmodeStatus"
 * Cockpit mode
 */
class CockpitmodeStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CockpitmodeStatusStatus ();

    /**
     * Copy constructor
     */
    inline  CockpitmodeStatusStatus (const CockpitmodeStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CockpitmodeStatusStatus (uint8 Cockpitmodeconstate_);

    /**
     * Destructor
     */
    inline virtual  ~CockpitmodeStatusStatus();

    /**
     * Assignment operator
     */
    inline CockpitmodeStatusStatus& operator = (const CockpitmodeStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CockpitmodeStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CockpitmodeStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CockpitmodeStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CockpitmodeStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Cockpitmodeconstate"

    static const int kCockpitmodeconstate = 0;

    /**
     * Clears the field "Cockpitmodeconstate".
     *
     * The field will be set to its default value. The hasCockpitmodeconstate()
     * method will return false.
     */
    inline void clearCockpitmodeconstate();

    /**
     * Checks whether the field "Cockpitmodeconstate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCockpitmodeconstate()). Otherwise it will return false.
     */
    inline bool hasCockpitmodeconstate () const;

    /**
     * Returns the value of the member "Cockpitmodeconstate".
     *
     * If the meaning of "Cockpitmodeconstate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Cockpitmodeconstate"
     */
    inline uint8 getCockpitmodeconstate () const;

    /**
     * Sets the value of the member "Cockpitmodeconstate".
     *
     * If the meaning of "Cockpitmodeconstate" isn't clear, then there should be a description here.
     *
     * @param Cockpitmodeconstate The value which will be set
     */
    inline void setCockpitmodeconstate (uint8 Cockpitmodeconstate_);

    static const CockpitmodeStatusStatus &getDefaultInstance();

private:

    inline void set_has_Cockpitmodeconstate ();

    inline void clear_has_Cockpitmodeconstate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Cockpitmodeconstate;

};

/**
 * The set message of the property "CockpitmodeStatus"
 * Cockpit mode
 */
class CockpitmodeStatusSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CockpitmodeStatusSet ();

    /**
     * Copy constructor
     */
    inline  CockpitmodeStatusSet (const CockpitmodeStatusSet &rhs);

    /**
     * All fields constructor
     */
    inline  CockpitmodeStatusSet (uint8 Cockpitmodeconstate_);

    /**
     * Destructor
     */
    inline virtual  ~CockpitmodeStatusSet();

    /**
     * Assignment operator
     */
    inline CockpitmodeStatusSet& operator = (const CockpitmodeStatusSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CockpitmodeStatusSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CockpitmodeStatusSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CockpitmodeStatusSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CockpitmodeStatusSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Cockpitmodeconstate"

    static const int kCockpitmodeconstate = 0;

    /**
     * Clears the field "Cockpitmodeconstate".
     *
     * The field will be set to its default value. The hasCockpitmodeconstate()
     * method will return false.
     */
    inline void clearCockpitmodeconstate();

    /**
     * Checks whether the field "Cockpitmodeconstate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCockpitmodeconstate()). Otherwise it will return false.
     */
    inline bool hasCockpitmodeconstate () const;

    /**
     * Returns the value of the member "Cockpitmodeconstate".
     *
     * If the meaning of "Cockpitmodeconstate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Cockpitmodeconstate"
     */
    inline uint8 getCockpitmodeconstate () const;

    /**
     * Sets the value of the member "Cockpitmodeconstate".
     *
     * If the meaning of "Cockpitmodeconstate" isn't clear, then there should be a description here.
     *
     * @param Cockpitmodeconstate The value which will be set
     */
    inline void setCockpitmodeconstate (uint8 Cockpitmodeconstate_);

    static const CockpitmodeStatusSet &getDefaultInstance();

private:

    inline void set_has_Cockpitmodeconstate ();

    inline void clear_has_Cockpitmodeconstate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Cockpitmodeconstate;

};

/**
 * The status message of the property "ThermallevelStatus"
 * Temperature level
 */
class ThermallevelStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ThermallevelStatusStatus ();

    /**
     * Copy constructor
     */
    inline  ThermallevelStatusStatus (const ThermallevelStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ThermallevelStatusStatus (uint16 Thermallevelconstate_);

    /**
     * Destructor
     */
    inline virtual  ~ThermallevelStatusStatus();

    /**
     * Assignment operator
     */
    inline ThermallevelStatusStatus& operator = (const ThermallevelStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ThermallevelStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ThermallevelStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ThermallevelStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ThermallevelStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Thermallevelconstate"

    static const int kThermallevelconstate = 0;

    /**
     * Clears the field "Thermallevelconstate".
     *
     * The field will be set to its default value. The hasThermallevelconstate()
     * method will return false.
     */
    inline void clearThermallevelconstate();

    /**
     * Checks whether the field "Thermallevelconstate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setThermallevelconstate()). Otherwise it will return false.
     */
    inline bool hasThermallevelconstate () const;

    /**
     * Returns the value of the member "Thermallevelconstate".
     *
     * If the meaning of "Thermallevelconstate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Thermallevelconstate"
     */
    inline uint16 getThermallevelconstate () const;

    /**
     * Sets the value of the member "Thermallevelconstate".
     *
     * If the meaning of "Thermallevelconstate" isn't clear, then there should be a description here.
     *
     * @param Thermallevelconstate The value which will be set
     */
    inline void setThermallevelconstate (uint16 Thermallevelconstate_);

    static const ThermallevelStatusStatus &getDefaultInstance();

private:

    inline void set_has_Thermallevelconstate ();

    inline void clear_has_Thermallevelconstate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Thermallevelconstate;

};

/**
 * The set message of the property "ThermallevelStatus"
 * Temperature level
 */
class ThermallevelStatusSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ThermallevelStatusSet ();

    /**
     * Copy constructor
     */
    inline  ThermallevelStatusSet (const ThermallevelStatusSet &rhs);

    /**
     * All fields constructor
     */
    inline  ThermallevelStatusSet (uint16 Thermallevelconstate_);

    /**
     * Destructor
     */
    inline virtual  ~ThermallevelStatusSet();

    /**
     * Assignment operator
     */
    inline ThermallevelStatusSet& operator = (const ThermallevelStatusSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ThermallevelStatusSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ThermallevelStatusSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ThermallevelStatusSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ThermallevelStatusSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Thermallevelconstate"

    static const int kThermallevelconstate = 0;

    /**
     * Clears the field "Thermallevelconstate".
     *
     * The field will be set to its default value. The hasThermallevelconstate()
     * method will return false.
     */
    inline void clearThermallevelconstate();

    /**
     * Checks whether the field "Thermallevelconstate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setThermallevelconstate()). Otherwise it will return false.
     */
    inline bool hasThermallevelconstate () const;

    /**
     * Returns the value of the member "Thermallevelconstate".
     *
     * If the meaning of "Thermallevelconstate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Thermallevelconstate"
     */
    inline uint16 getThermallevelconstate () const;

    /**
     * Sets the value of the member "Thermallevelconstate".
     *
     * If the meaning of "Thermallevelconstate" isn't clear, then there should be a description here.
     *
     * @param Thermallevelconstate The value which will be set
     */
    inline void setThermallevelconstate (uint16 Thermallevelconstate_);

    static const ThermallevelStatusSet &getDefaultInstance();

private:

    inline void set_has_Thermallevelconstate ();

    inline void clear_has_Thermallevelconstate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Thermallevelconstate;

};

/**
 * The status message of the property "DoorUnlockStatus"
 * DoorUnlockStatus Active / In-active
 */
class DoorUnlockStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoorUnlockStatusStatus ();

    /**
     * Copy constructor
     */
    inline  DoorUnlockStatusStatus (const DoorUnlockStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DoorUnlockStatusStatus (bool DoorUnlockconstate_);

    /**
     * Destructor
     */
    inline virtual  ~DoorUnlockStatusStatus();

    /**
     * Assignment operator
     */
    inline DoorUnlockStatusStatus& operator = (const DoorUnlockStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoorUnlockStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoorUnlockStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoorUnlockStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoorUnlockStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DoorUnlockconstate"

    static const int kDoorUnlockconstate = 0;

    /**
     * Clears the field "DoorUnlockconstate".
     *
     * The field will be set to its default value. The hasDoorUnlockconstate()
     * method will return false.
     */
    inline void clearDoorUnlockconstate();

    /**
     * Checks whether the field "DoorUnlockconstate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDoorUnlockconstate()). Otherwise it will return false.
     */
    inline bool hasDoorUnlockconstate () const;

    /**
     * Returns the value of the member "DoorUnlockconstate".
     *
     * If the meaning of "DoorUnlockconstate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DoorUnlockconstate"
     */
    inline bool getDoorUnlockconstate () const;

    /**
     * Sets the value of the member "DoorUnlockconstate".
     *
     * If the meaning of "DoorUnlockconstate" isn't clear, then there should be a description here.
     *
     * @param DoorUnlockconstate The value which will be set
     */
    inline void setDoorUnlockconstate (bool DoorUnlockconstate_);

    static const DoorUnlockStatusStatus &getDefaultInstance();

private:

    inline void set_has_DoorUnlockconstate ();

    inline void clear_has_DoorUnlockconstate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _DoorUnlockconstate;

};

/**
 * The set message of the property "DoorUnlockStatus"
 * DoorUnlockStatus Active / In-active
 */
class DoorUnlockStatusSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoorUnlockStatusSet ();

    /**
     * Copy constructor
     */
    inline  DoorUnlockStatusSet (const DoorUnlockStatusSet &rhs);

    /**
     * All fields constructor
     */
    inline  DoorUnlockStatusSet (bool DoorUnlockconstate_);

    /**
     * Destructor
     */
    inline virtual  ~DoorUnlockStatusSet();

    /**
     * Assignment operator
     */
    inline DoorUnlockStatusSet& operator = (const DoorUnlockStatusSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoorUnlockStatusSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoorUnlockStatusSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoorUnlockStatusSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoorUnlockStatusSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DoorUnlockconstate"

    static const int kDoorUnlockconstate = 0;

    /**
     * Clears the field "DoorUnlockconstate".
     *
     * The field will be set to its default value. The hasDoorUnlockconstate()
     * method will return false.
     */
    inline void clearDoorUnlockconstate();

    /**
     * Checks whether the field "DoorUnlockconstate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDoorUnlockconstate()). Otherwise it will return false.
     */
    inline bool hasDoorUnlockconstate () const;

    /**
     * Returns the value of the member "DoorUnlockconstate".
     *
     * If the meaning of "DoorUnlockconstate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DoorUnlockconstate"
     */
    inline bool getDoorUnlockconstate () const;

    /**
     * Sets the value of the member "DoorUnlockconstate".
     *
     * If the meaning of "DoorUnlockconstate" isn't clear, then there should be a description here.
     *
     * @param DoorUnlockconstate The value which will be set
     */
    inline void setDoorUnlockconstate (bool DoorUnlockconstate_);

    static const DoorUnlockStatusSet &getDefaultInstance();

private:

    inline void set_has_DoorUnlockconstate ();

    inline void clear_has_DoorUnlockconstate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _DoorUnlockconstate;

};

/**
 * The status message of the property "PNMGRP10SignalStatus"
 * PNMGRP10Signal status Active / In-active
 */
class PNMGRP10SignalStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PNMGRP10SignalStatusStatus ();

    /**
     * Copy constructor
     */
    inline  PNMGRP10SignalStatusStatus (const PNMGRP10SignalStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PNMGRP10SignalStatusStatus (uint8 PNMGRP10Signalstate_);

    /**
     * Destructor
     */
    inline virtual  ~PNMGRP10SignalStatusStatus();

    /**
     * Assignment operator
     */
    inline PNMGRP10SignalStatusStatus& operator = (const PNMGRP10SignalStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PNMGRP10SignalStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PNMGRP10SignalStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PNMGRP10SignalStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PNMGRP10SignalStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PNMGRP10Signalstate"

    static const int kPNMGRP10Signalstate = 0;

    /**
     * Clears the field "PNMGRP10Signalstate".
     *
     * The field will be set to its default value. The hasPNMGRP10Signalstate()
     * method will return false.
     */
    inline void clearPNMGRP10Signalstate();

    /**
     * Checks whether the field "PNMGRP10Signalstate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPNMGRP10Signalstate()). Otherwise it will return false.
     */
    inline bool hasPNMGRP10Signalstate () const;

    /**
     * Returns the value of the member "PNMGRP10Signalstate".
     *
     * If the meaning of "PNMGRP10Signalstate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PNMGRP10Signalstate"
     */
    inline uint8 getPNMGRP10Signalstate () const;

    /**
     * Sets the value of the member "PNMGRP10Signalstate".
     *
     * If the meaning of "PNMGRP10Signalstate" isn't clear, then there should be a description here.
     *
     * @param PNMGRP10Signalstate The value which will be set
     */
    inline void setPNMGRP10Signalstate (uint8 PNMGRP10Signalstate_);

    static const PNMGRP10SignalStatusStatus &getDefaultInstance();

private:

    inline void set_has_PNMGRP10Signalstate ();

    inline void clear_has_PNMGRP10Signalstate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _PNMGRP10Signalstate;

};

/**
 * The set message of the property "PNMGRP10SignalStatus"
 * PNMGRP10Signal status Active / In-active
 */
class PNMGRP10SignalStatusSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PNMGRP10SignalStatusSet ();

    /**
     * Copy constructor
     */
    inline  PNMGRP10SignalStatusSet (const PNMGRP10SignalStatusSet &rhs);

    /**
     * All fields constructor
     */
    inline  PNMGRP10SignalStatusSet (uint8 PNMGRP10Signalstate_);

    /**
     * Destructor
     */
    inline virtual  ~PNMGRP10SignalStatusSet();

    /**
     * Assignment operator
     */
    inline PNMGRP10SignalStatusSet& operator = (const PNMGRP10SignalStatusSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PNMGRP10SignalStatusSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PNMGRP10SignalStatusSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PNMGRP10SignalStatusSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PNMGRP10SignalStatusSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PNMGRP10Signalstate"

    static const int kPNMGRP10Signalstate = 0;

    /**
     * Clears the field "PNMGRP10Signalstate".
     *
     * The field will be set to its default value. The hasPNMGRP10Signalstate()
     * method will return false.
     */
    inline void clearPNMGRP10Signalstate();

    /**
     * Checks whether the field "PNMGRP10Signalstate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPNMGRP10Signalstate()). Otherwise it will return false.
     */
    inline bool hasPNMGRP10Signalstate () const;

    /**
     * Returns the value of the member "PNMGRP10Signalstate".
     *
     * If the meaning of "PNMGRP10Signalstate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PNMGRP10Signalstate"
     */
    inline uint8 getPNMGRP10Signalstate () const;

    /**
     * Sets the value of the member "PNMGRP10Signalstate".
     *
     * If the meaning of "PNMGRP10Signalstate" isn't clear, then there should be a description here.
     *
     * @param PNMGRP10Signalstate The value which will be set
     */
    inline void setPNMGRP10Signalstate (uint8 PNMGRP10Signalstate_);

    static const PNMGRP10SignalStatusSet &getDefaultInstance();

private:

    inline void set_has_PNMGRP10Signalstate ();

    inline void clear_has_PNMGRP10Signalstate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _PNMGRP10Signalstate;

};

inline  CurrentSourceStatus::CurrentSourceStatus ()  :
    _strSourceName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CurrentSourceStatus::CurrentSourceStatus (const CurrentSourceStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _strSourceName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CurrentSourceStatus::CurrentSourceStatus (const ::std::string& strSourceName_)  :
    _strSourceName (strSourceName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strSourceName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CurrentSourceStatus::~CurrentSourceStatus() {
}

inline CurrentSourceStatus& CurrentSourceStatus::operator = (const CurrentSourceStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStrSourceName()) {
            setStrSourceName(rhs.getStrSourceName());
        } else {
            clearStrSourceName();
        }
    }
    return *this;
}

inline bool CurrentSourceStatus::operator == (const CurrentSourceStatus& rhs) const {
    return (((!hasStrSourceName() && !rhs.hasStrSourceName()) || getStrSourceName() == rhs.getStrSourceName()));
}

inline bool CurrentSourceStatus::operator != (const CurrentSourceStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool CurrentSourceStatus::operator < (const CurrentSourceStatus& rhs) const {
    if (hasStrSourceName() || rhs.hasStrSourceName()) {
        if (getStrSourceName() < rhs.getStrSourceName()) return true;
        if (getStrSourceName() > rhs.getStrSourceName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CurrentSourceStatus::clone() {
    return new CurrentSourceStatus(*this);
}

inline bool CurrentSourceStatus::operator > (const CurrentSourceStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CurrentSourceStatus::clear() {
    clearStrSourceName();
}

inline void CurrentSourceStatus::clearStrSourceName() {
    if (hasStrSourceName()) {
         clear_has_strSourceName();
        _strSourceName.clear();
     }
}

inline bool CurrentSourceStatus::hasStrSourceName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& CurrentSourceStatus::getStrSourceName () const {
    return _strSourceName;
}

inline ::std::string& CurrentSourceStatus::getStrSourceNameMutable () {
    set_has_strSourceName();
    return _strSourceName;
}

inline void CurrentSourceStatus::setStrSourceName (const ::std::string& strSourceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strSourceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strSourceName();
    this->_strSourceName = strSourceName_;
}

inline void CurrentSourceStatus::setStrSourceName (const char* strSourceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strSourceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strSourceName();
    this->_strSourceName.assign(strSourceName_);
}

inline void CurrentSourceStatus::setStrSourceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strSourceName();
    this->_strSourceName.assign(value, size);
}

inline void CurrentSourceStatus::set_has_strSourceName () {
    _has_bits_[0] |= 1u << 0;
}

inline void CurrentSourceStatus::clear_has_strSourceName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NanomsgStatusStatus::NanomsgStatusStatus ()  :
    _Nanomsgconstate (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NanomsgStatusStatus::NanomsgStatusStatus (const NanomsgStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Nanomsgconstate (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NanomsgStatusStatus::NanomsgStatusStatus (bool Nanomsgconstate_)  :
    _Nanomsgconstate (Nanomsgconstate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NanomsgStatusStatus::~NanomsgStatusStatus() {
}

inline NanomsgStatusStatus& NanomsgStatusStatus::operator = (const NanomsgStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNanomsgconstate()) {
            setNanomsgconstate(rhs.getNanomsgconstate());
        } else {
            clearNanomsgconstate();
        }
    }
    return *this;
}

inline bool NanomsgStatusStatus::operator == (const NanomsgStatusStatus& rhs) const {
    return (((!hasNanomsgconstate() && !rhs.hasNanomsgconstate()) || getNanomsgconstate() == rhs.getNanomsgconstate()));
}

inline bool NanomsgStatusStatus::operator != (const NanomsgStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool NanomsgStatusStatus::operator < (const NanomsgStatusStatus& rhs) const {
    if (hasNanomsgconstate() || rhs.hasNanomsgconstate()) {
        if (getNanomsgconstate() < rhs.getNanomsgconstate()) return true;
        if (getNanomsgconstate() > rhs.getNanomsgconstate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NanomsgStatusStatus::clone() {
    return new NanomsgStatusStatus(*this);
}

inline bool NanomsgStatusStatus::operator > (const NanomsgStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NanomsgStatusStatus::clear() {
    clearNanomsgconstate();
}

inline void NanomsgStatusStatus::clearNanomsgconstate() {
    if (hasNanomsgconstate()) {
         clear_has_Nanomsgconstate();
        _Nanomsgconstate = false;
     }
}

inline bool NanomsgStatusStatus::hasNanomsgconstate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool NanomsgStatusStatus::getNanomsgconstate () const {
    return _Nanomsgconstate;
}

inline void NanomsgStatusStatus::setNanomsgconstate (bool Nanomsgconstate_) {
    set_has_Nanomsgconstate();
    this->_Nanomsgconstate = Nanomsgconstate_;
}

inline void NanomsgStatusStatus::set_has_Nanomsgconstate () {
    _has_bits_[0] |= 1u << 0;
}

inline void NanomsgStatusStatus::clear_has_Nanomsgconstate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NanomsgStatusSet::NanomsgStatusSet ()  :
    _Nanomsgconstate (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NanomsgStatusSet::NanomsgStatusSet (const NanomsgStatusSet &rhs)  :
    ::asf::core::Payload(rhs),
    _Nanomsgconstate (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NanomsgStatusSet::NanomsgStatusSet (bool Nanomsgconstate_)  :
    _Nanomsgconstate (Nanomsgconstate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NanomsgStatusSet::~NanomsgStatusSet() {
}

inline NanomsgStatusSet& NanomsgStatusSet::operator = (const NanomsgStatusSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNanomsgconstate()) {
            setNanomsgconstate(rhs.getNanomsgconstate());
        } else {
            clearNanomsgconstate();
        }
    }
    return *this;
}

inline bool NanomsgStatusSet::operator == (const NanomsgStatusSet& rhs) const {
    return (((!hasNanomsgconstate() && !rhs.hasNanomsgconstate()) || getNanomsgconstate() == rhs.getNanomsgconstate()));
}

inline bool NanomsgStatusSet::operator != (const NanomsgStatusSet& rhs) const {
    return ! (*this == rhs);
}

inline bool NanomsgStatusSet::operator < (const NanomsgStatusSet& rhs) const {
    if (hasNanomsgconstate() || rhs.hasNanomsgconstate()) {
        if (getNanomsgconstate() < rhs.getNanomsgconstate()) return true;
        if (getNanomsgconstate() > rhs.getNanomsgconstate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NanomsgStatusSet::clone() {
    return new NanomsgStatusSet(*this);
}

inline bool NanomsgStatusSet::operator > (const NanomsgStatusSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NanomsgStatusSet::clear() {
    clearNanomsgconstate();
}

inline void NanomsgStatusSet::clearNanomsgconstate() {
    if (hasNanomsgconstate()) {
         clear_has_Nanomsgconstate();
        _Nanomsgconstate = false;
     }
}

inline bool NanomsgStatusSet::hasNanomsgconstate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool NanomsgStatusSet::getNanomsgconstate () const {
    return _Nanomsgconstate;
}

inline void NanomsgStatusSet::setNanomsgconstate (bool Nanomsgconstate_) {
    set_has_Nanomsgconstate();
    this->_Nanomsgconstate = Nanomsgconstate_;
}

inline void NanomsgStatusSet::set_has_Nanomsgconstate () {
    _has_bits_[0] |= 1u << 0;
}

inline void NanomsgStatusSet::clear_has_Nanomsgconstate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SubsystemerrorStatusStatus::SubsystemerrorStatusStatus ()  :
    _Subsystemerrorconstate ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SubsystemerrorStatusStatus::SubsystemerrorStatusStatus (const SubsystemerrorStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Subsystemerrorconstate ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SubsystemerrorStatusStatus::SubsystemerrorStatusStatus (const ::lcmdbusclient_main_fi_types::TheSubsystemList& Subsystemerrorconstate_)  :
    _Subsystemerrorconstate (Subsystemerrorconstate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SubsystemerrorStatusStatus::~SubsystemerrorStatusStatus() {
}

inline SubsystemerrorStatusStatus& SubsystemerrorStatusStatus::operator = (const SubsystemerrorStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSubsystemerrorconstate()) {
            setSubsystemerrorconstate(rhs.getSubsystemerrorconstate());
        } else {
            clearSubsystemerrorconstate();
        }
    }
    return *this;
}

inline bool SubsystemerrorStatusStatus::operator == (const SubsystemerrorStatusStatus& rhs) const {
    return (((!hasSubsystemerrorconstate() && !rhs.hasSubsystemerrorconstate()) || getSubsystemerrorconstate() == rhs.getSubsystemerrorconstate()));
}

inline bool SubsystemerrorStatusStatus::operator != (const SubsystemerrorStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SubsystemerrorStatusStatus::operator < (const SubsystemerrorStatusStatus& rhs) const {
    if (hasSubsystemerrorconstate() || rhs.hasSubsystemerrorconstate()) {
        if (getSubsystemerrorconstate() < rhs.getSubsystemerrorconstate()) return true;
        if (getSubsystemerrorconstate() > rhs.getSubsystemerrorconstate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SubsystemerrorStatusStatus::clone() {
    return new SubsystemerrorStatusStatus(*this);
}

inline bool SubsystemerrorStatusStatus::operator > (const SubsystemerrorStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SubsystemerrorStatusStatus::clear() {
    clearSubsystemerrorconstate();
}

inline void SubsystemerrorStatusStatus::clearSubsystemerrorconstate() {
    if (hasSubsystemerrorconstate()) {
         clear_has_Subsystemerrorconstate();
        _Subsystemerrorconstate.clear();
     }
}

inline bool SubsystemerrorStatusStatus::hasSubsystemerrorconstate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::lcmdbusclient_main_fi_types::TheSubsystemList& SubsystemerrorStatusStatus::getSubsystemerrorconstate () const {
    return _Subsystemerrorconstate;
}

inline ::lcmdbusclient_main_fi_types::TheSubsystemList& SubsystemerrorStatusStatus::getSubsystemerrorconstateMutable () {
    set_has_Subsystemerrorconstate();
    return _Subsystemerrorconstate;
}

inline void SubsystemerrorStatusStatus::setSubsystemerrorconstate (const ::lcmdbusclient_main_fi_types::TheSubsystemList& Subsystemerrorconstate_) {
    set_has_Subsystemerrorconstate();
    this->_Subsystemerrorconstate = Subsystemerrorconstate_;
}

inline void SubsystemerrorStatusStatus::set_has_Subsystemerrorconstate () {
    _has_bits_[0] |= 1u << 0;
}

inline void SubsystemerrorStatusStatus::clear_has_Subsystemerrorconstate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SubsystemerrorStatusSet::SubsystemerrorStatusSet ()  :
    _Subsystemerrorconstate ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SubsystemerrorStatusSet::SubsystemerrorStatusSet (const SubsystemerrorStatusSet &rhs)  :
    ::asf::core::Payload(rhs),
    _Subsystemerrorconstate ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SubsystemerrorStatusSet::SubsystemerrorStatusSet (const ::lcmdbusclient_main_fi_types::TheSubsystemList& Subsystemerrorconstate_)  :
    _Subsystemerrorconstate (Subsystemerrorconstate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SubsystemerrorStatusSet::~SubsystemerrorStatusSet() {
}

inline SubsystemerrorStatusSet& SubsystemerrorStatusSet::operator = (const SubsystemerrorStatusSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSubsystemerrorconstate()) {
            setSubsystemerrorconstate(rhs.getSubsystemerrorconstate());
        } else {
            clearSubsystemerrorconstate();
        }
    }
    return *this;
}

inline bool SubsystemerrorStatusSet::operator == (const SubsystemerrorStatusSet& rhs) const {
    return (((!hasSubsystemerrorconstate() && !rhs.hasSubsystemerrorconstate()) || getSubsystemerrorconstate() == rhs.getSubsystemerrorconstate()));
}

inline bool SubsystemerrorStatusSet::operator != (const SubsystemerrorStatusSet& rhs) const {
    return ! (*this == rhs);
}

inline bool SubsystemerrorStatusSet::operator < (const SubsystemerrorStatusSet& rhs) const {
    if (hasSubsystemerrorconstate() || rhs.hasSubsystemerrorconstate()) {
        if (getSubsystemerrorconstate() < rhs.getSubsystemerrorconstate()) return true;
        if (getSubsystemerrorconstate() > rhs.getSubsystemerrorconstate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SubsystemerrorStatusSet::clone() {
    return new SubsystemerrorStatusSet(*this);
}

inline bool SubsystemerrorStatusSet::operator > (const SubsystemerrorStatusSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SubsystemerrorStatusSet::clear() {
    clearSubsystemerrorconstate();
}

inline void SubsystemerrorStatusSet::clearSubsystemerrorconstate() {
    if (hasSubsystemerrorconstate()) {
         clear_has_Subsystemerrorconstate();
        _Subsystemerrorconstate.clear();
     }
}

inline bool SubsystemerrorStatusSet::hasSubsystemerrorconstate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::lcmdbusclient_main_fi_types::TheSubsystemList& SubsystemerrorStatusSet::getSubsystemerrorconstate () const {
    return _Subsystemerrorconstate;
}

inline ::lcmdbusclient_main_fi_types::TheSubsystemList& SubsystemerrorStatusSet::getSubsystemerrorconstateMutable () {
    set_has_Subsystemerrorconstate();
    return _Subsystemerrorconstate;
}

inline void SubsystemerrorStatusSet::setSubsystemerrorconstate (const ::lcmdbusclient_main_fi_types::TheSubsystemList& Subsystemerrorconstate_) {
    set_has_Subsystemerrorconstate();
    this->_Subsystemerrorconstate = Subsystemerrorconstate_;
}

inline void SubsystemerrorStatusSet::set_has_Subsystemerrorconstate () {
    _has_bits_[0] |= 1u << 0;
}

inline void SubsystemerrorStatusSet::clear_has_Subsystemerrorconstate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  VoltagelevelStatusStatus::VoltagelevelStatusStatus ()  :
    _Voltagelevelconstate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VoltagelevelStatusStatus::VoltagelevelStatusStatus (const VoltagelevelStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Voltagelevelconstate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VoltagelevelStatusStatus::VoltagelevelStatusStatus (uint8 Voltagelevelconstate_)  :
    _Voltagelevelconstate (Voltagelevelconstate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VoltagelevelStatusStatus::~VoltagelevelStatusStatus() {
}

inline VoltagelevelStatusStatus& VoltagelevelStatusStatus::operator = (const VoltagelevelStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVoltagelevelconstate()) {
            setVoltagelevelconstate(rhs.getVoltagelevelconstate());
        } else {
            clearVoltagelevelconstate();
        }
    }
    return *this;
}

inline bool VoltagelevelStatusStatus::operator == (const VoltagelevelStatusStatus& rhs) const {
    return (((!hasVoltagelevelconstate() && !rhs.hasVoltagelevelconstate()) || getVoltagelevelconstate() == rhs.getVoltagelevelconstate()));
}

inline bool VoltagelevelStatusStatus::operator != (const VoltagelevelStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool VoltagelevelStatusStatus::operator < (const VoltagelevelStatusStatus& rhs) const {
    if (hasVoltagelevelconstate() || rhs.hasVoltagelevelconstate()) {
        if (getVoltagelevelconstate() < rhs.getVoltagelevelconstate()) return true;
        if (getVoltagelevelconstate() > rhs.getVoltagelevelconstate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VoltagelevelStatusStatus::clone() {
    return new VoltagelevelStatusStatus(*this);
}

inline bool VoltagelevelStatusStatus::operator > (const VoltagelevelStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VoltagelevelStatusStatus::clear() {
    clearVoltagelevelconstate();
}

inline void VoltagelevelStatusStatus::clearVoltagelevelconstate() {
    if (hasVoltagelevelconstate()) {
         clear_has_Voltagelevelconstate();
        _Voltagelevelconstate = 0u;
     }
}

inline bool VoltagelevelStatusStatus::hasVoltagelevelconstate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 VoltagelevelStatusStatus::getVoltagelevelconstate () const {
    return _Voltagelevelconstate;
}

inline void VoltagelevelStatusStatus::setVoltagelevelconstate (uint8 Voltagelevelconstate_) {
    set_has_Voltagelevelconstate();
    this->_Voltagelevelconstate = Voltagelevelconstate_;
}

inline void VoltagelevelStatusStatus::set_has_Voltagelevelconstate () {
    _has_bits_[0] |= 1u << 0;
}

inline void VoltagelevelStatusStatus::clear_has_Voltagelevelconstate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  VoltagelevelStatusSet::VoltagelevelStatusSet ()  :
    _Voltagelevelconstate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VoltagelevelStatusSet::VoltagelevelStatusSet (const VoltagelevelStatusSet &rhs)  :
    ::asf::core::Payload(rhs),
    _Voltagelevelconstate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VoltagelevelStatusSet::VoltagelevelStatusSet (uint8 Voltagelevelconstate_)  :
    _Voltagelevelconstate (Voltagelevelconstate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VoltagelevelStatusSet::~VoltagelevelStatusSet() {
}

inline VoltagelevelStatusSet& VoltagelevelStatusSet::operator = (const VoltagelevelStatusSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVoltagelevelconstate()) {
            setVoltagelevelconstate(rhs.getVoltagelevelconstate());
        } else {
            clearVoltagelevelconstate();
        }
    }
    return *this;
}

inline bool VoltagelevelStatusSet::operator == (const VoltagelevelStatusSet& rhs) const {
    return (((!hasVoltagelevelconstate() && !rhs.hasVoltagelevelconstate()) || getVoltagelevelconstate() == rhs.getVoltagelevelconstate()));
}

inline bool VoltagelevelStatusSet::operator != (const VoltagelevelStatusSet& rhs) const {
    return ! (*this == rhs);
}

inline bool VoltagelevelStatusSet::operator < (const VoltagelevelStatusSet& rhs) const {
    if (hasVoltagelevelconstate() || rhs.hasVoltagelevelconstate()) {
        if (getVoltagelevelconstate() < rhs.getVoltagelevelconstate()) return true;
        if (getVoltagelevelconstate() > rhs.getVoltagelevelconstate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VoltagelevelStatusSet::clone() {
    return new VoltagelevelStatusSet(*this);
}

inline bool VoltagelevelStatusSet::operator > (const VoltagelevelStatusSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VoltagelevelStatusSet::clear() {
    clearVoltagelevelconstate();
}

inline void VoltagelevelStatusSet::clearVoltagelevelconstate() {
    if (hasVoltagelevelconstate()) {
         clear_has_Voltagelevelconstate();
        _Voltagelevelconstate = 0u;
     }
}

inline bool VoltagelevelStatusSet::hasVoltagelevelconstate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 VoltagelevelStatusSet::getVoltagelevelconstate () const {
    return _Voltagelevelconstate;
}

inline void VoltagelevelStatusSet::setVoltagelevelconstate (uint8 Voltagelevelconstate_) {
    set_has_Voltagelevelconstate();
    this->_Voltagelevelconstate = Voltagelevelconstate_;
}

inline void VoltagelevelStatusSet::set_has_Voltagelevelconstate () {
    _has_bits_[0] |= 1u << 0;
}

inline void VoltagelevelStatusSet::clear_has_Voltagelevelconstate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CockpitmodeStatusStatus::CockpitmodeStatusStatus ()  :
    _Cockpitmodeconstate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CockpitmodeStatusStatus::CockpitmodeStatusStatus (const CockpitmodeStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Cockpitmodeconstate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CockpitmodeStatusStatus::CockpitmodeStatusStatus (uint8 Cockpitmodeconstate_)  :
    _Cockpitmodeconstate (Cockpitmodeconstate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CockpitmodeStatusStatus::~CockpitmodeStatusStatus() {
}

inline CockpitmodeStatusStatus& CockpitmodeStatusStatus::operator = (const CockpitmodeStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCockpitmodeconstate()) {
            setCockpitmodeconstate(rhs.getCockpitmodeconstate());
        } else {
            clearCockpitmodeconstate();
        }
    }
    return *this;
}

inline bool CockpitmodeStatusStatus::operator == (const CockpitmodeStatusStatus& rhs) const {
    return (((!hasCockpitmodeconstate() && !rhs.hasCockpitmodeconstate()) || getCockpitmodeconstate() == rhs.getCockpitmodeconstate()));
}

inline bool CockpitmodeStatusStatus::operator != (const CockpitmodeStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool CockpitmodeStatusStatus::operator < (const CockpitmodeStatusStatus& rhs) const {
    if (hasCockpitmodeconstate() || rhs.hasCockpitmodeconstate()) {
        if (getCockpitmodeconstate() < rhs.getCockpitmodeconstate()) return true;
        if (getCockpitmodeconstate() > rhs.getCockpitmodeconstate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CockpitmodeStatusStatus::clone() {
    return new CockpitmodeStatusStatus(*this);
}

inline bool CockpitmodeStatusStatus::operator > (const CockpitmodeStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CockpitmodeStatusStatus::clear() {
    clearCockpitmodeconstate();
}

inline void CockpitmodeStatusStatus::clearCockpitmodeconstate() {
    if (hasCockpitmodeconstate()) {
         clear_has_Cockpitmodeconstate();
        _Cockpitmodeconstate = 0u;
     }
}

inline bool CockpitmodeStatusStatus::hasCockpitmodeconstate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 CockpitmodeStatusStatus::getCockpitmodeconstate () const {
    return _Cockpitmodeconstate;
}

inline void CockpitmodeStatusStatus::setCockpitmodeconstate (uint8 Cockpitmodeconstate_) {
    set_has_Cockpitmodeconstate();
    this->_Cockpitmodeconstate = Cockpitmodeconstate_;
}

inline void CockpitmodeStatusStatus::set_has_Cockpitmodeconstate () {
    _has_bits_[0] |= 1u << 0;
}

inline void CockpitmodeStatusStatus::clear_has_Cockpitmodeconstate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CockpitmodeStatusSet::CockpitmodeStatusSet ()  :
    _Cockpitmodeconstate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CockpitmodeStatusSet::CockpitmodeStatusSet (const CockpitmodeStatusSet &rhs)  :
    ::asf::core::Payload(rhs),
    _Cockpitmodeconstate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CockpitmodeStatusSet::CockpitmodeStatusSet (uint8 Cockpitmodeconstate_)  :
    _Cockpitmodeconstate (Cockpitmodeconstate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CockpitmodeStatusSet::~CockpitmodeStatusSet() {
}

inline CockpitmodeStatusSet& CockpitmodeStatusSet::operator = (const CockpitmodeStatusSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCockpitmodeconstate()) {
            setCockpitmodeconstate(rhs.getCockpitmodeconstate());
        } else {
            clearCockpitmodeconstate();
        }
    }
    return *this;
}

inline bool CockpitmodeStatusSet::operator == (const CockpitmodeStatusSet& rhs) const {
    return (((!hasCockpitmodeconstate() && !rhs.hasCockpitmodeconstate()) || getCockpitmodeconstate() == rhs.getCockpitmodeconstate()));
}

inline bool CockpitmodeStatusSet::operator != (const CockpitmodeStatusSet& rhs) const {
    return ! (*this == rhs);
}

inline bool CockpitmodeStatusSet::operator < (const CockpitmodeStatusSet& rhs) const {
    if (hasCockpitmodeconstate() || rhs.hasCockpitmodeconstate()) {
        if (getCockpitmodeconstate() < rhs.getCockpitmodeconstate()) return true;
        if (getCockpitmodeconstate() > rhs.getCockpitmodeconstate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CockpitmodeStatusSet::clone() {
    return new CockpitmodeStatusSet(*this);
}

inline bool CockpitmodeStatusSet::operator > (const CockpitmodeStatusSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CockpitmodeStatusSet::clear() {
    clearCockpitmodeconstate();
}

inline void CockpitmodeStatusSet::clearCockpitmodeconstate() {
    if (hasCockpitmodeconstate()) {
         clear_has_Cockpitmodeconstate();
        _Cockpitmodeconstate = 0u;
     }
}

inline bool CockpitmodeStatusSet::hasCockpitmodeconstate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 CockpitmodeStatusSet::getCockpitmodeconstate () const {
    return _Cockpitmodeconstate;
}

inline void CockpitmodeStatusSet::setCockpitmodeconstate (uint8 Cockpitmodeconstate_) {
    set_has_Cockpitmodeconstate();
    this->_Cockpitmodeconstate = Cockpitmodeconstate_;
}

inline void CockpitmodeStatusSet::set_has_Cockpitmodeconstate () {
    _has_bits_[0] |= 1u << 0;
}

inline void CockpitmodeStatusSet::clear_has_Cockpitmodeconstate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ThermallevelStatusStatus::ThermallevelStatusStatus ()  :
    _Thermallevelconstate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ThermallevelStatusStatus::ThermallevelStatusStatus (const ThermallevelStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _Thermallevelconstate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ThermallevelStatusStatus::ThermallevelStatusStatus (uint16 Thermallevelconstate_)  :
    _Thermallevelconstate (Thermallevelconstate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ThermallevelStatusStatus::~ThermallevelStatusStatus() {
}

inline ThermallevelStatusStatus& ThermallevelStatusStatus::operator = (const ThermallevelStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasThermallevelconstate()) {
            setThermallevelconstate(rhs.getThermallevelconstate());
        } else {
            clearThermallevelconstate();
        }
    }
    return *this;
}

inline bool ThermallevelStatusStatus::operator == (const ThermallevelStatusStatus& rhs) const {
    return (((!hasThermallevelconstate() && !rhs.hasThermallevelconstate()) || getThermallevelconstate() == rhs.getThermallevelconstate()));
}

inline bool ThermallevelStatusStatus::operator != (const ThermallevelStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool ThermallevelStatusStatus::operator < (const ThermallevelStatusStatus& rhs) const {
    if (hasThermallevelconstate() || rhs.hasThermallevelconstate()) {
        if (getThermallevelconstate() < rhs.getThermallevelconstate()) return true;
        if (getThermallevelconstate() > rhs.getThermallevelconstate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ThermallevelStatusStatus::clone() {
    return new ThermallevelStatusStatus(*this);
}

inline bool ThermallevelStatusStatus::operator > (const ThermallevelStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ThermallevelStatusStatus::clear() {
    clearThermallevelconstate();
}

inline void ThermallevelStatusStatus::clearThermallevelconstate() {
    if (hasThermallevelconstate()) {
         clear_has_Thermallevelconstate();
        _Thermallevelconstate = 0u;
     }
}

inline bool ThermallevelStatusStatus::hasThermallevelconstate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 ThermallevelStatusStatus::getThermallevelconstate () const {
    return _Thermallevelconstate;
}

inline void ThermallevelStatusStatus::setThermallevelconstate (uint16 Thermallevelconstate_) {
    set_has_Thermallevelconstate();
    this->_Thermallevelconstate = Thermallevelconstate_;
}

inline void ThermallevelStatusStatus::set_has_Thermallevelconstate () {
    _has_bits_[0] |= 1u << 0;
}

inline void ThermallevelStatusStatus::clear_has_Thermallevelconstate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ThermallevelStatusSet::ThermallevelStatusSet ()  :
    _Thermallevelconstate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ThermallevelStatusSet::ThermallevelStatusSet (const ThermallevelStatusSet &rhs)  :
    ::asf::core::Payload(rhs),
    _Thermallevelconstate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ThermallevelStatusSet::ThermallevelStatusSet (uint16 Thermallevelconstate_)  :
    _Thermallevelconstate (Thermallevelconstate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ThermallevelStatusSet::~ThermallevelStatusSet() {
}

inline ThermallevelStatusSet& ThermallevelStatusSet::operator = (const ThermallevelStatusSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasThermallevelconstate()) {
            setThermallevelconstate(rhs.getThermallevelconstate());
        } else {
            clearThermallevelconstate();
        }
    }
    return *this;
}

inline bool ThermallevelStatusSet::operator == (const ThermallevelStatusSet& rhs) const {
    return (((!hasThermallevelconstate() && !rhs.hasThermallevelconstate()) || getThermallevelconstate() == rhs.getThermallevelconstate()));
}

inline bool ThermallevelStatusSet::operator != (const ThermallevelStatusSet& rhs) const {
    return ! (*this == rhs);
}

inline bool ThermallevelStatusSet::operator < (const ThermallevelStatusSet& rhs) const {
    if (hasThermallevelconstate() || rhs.hasThermallevelconstate()) {
        if (getThermallevelconstate() < rhs.getThermallevelconstate()) return true;
        if (getThermallevelconstate() > rhs.getThermallevelconstate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ThermallevelStatusSet::clone() {
    return new ThermallevelStatusSet(*this);
}

inline bool ThermallevelStatusSet::operator > (const ThermallevelStatusSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ThermallevelStatusSet::clear() {
    clearThermallevelconstate();
}

inline void ThermallevelStatusSet::clearThermallevelconstate() {
    if (hasThermallevelconstate()) {
         clear_has_Thermallevelconstate();
        _Thermallevelconstate = 0u;
     }
}

inline bool ThermallevelStatusSet::hasThermallevelconstate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 ThermallevelStatusSet::getThermallevelconstate () const {
    return _Thermallevelconstate;
}

inline void ThermallevelStatusSet::setThermallevelconstate (uint16 Thermallevelconstate_) {
    set_has_Thermallevelconstate();
    this->_Thermallevelconstate = Thermallevelconstate_;
}

inline void ThermallevelStatusSet::set_has_Thermallevelconstate () {
    _has_bits_[0] |= 1u << 0;
}

inline void ThermallevelStatusSet::clear_has_Thermallevelconstate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoorUnlockStatusStatus::DoorUnlockStatusStatus ()  :
    _DoorUnlockconstate (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoorUnlockStatusStatus::DoorUnlockStatusStatus (const DoorUnlockStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _DoorUnlockconstate (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoorUnlockStatusStatus::DoorUnlockStatusStatus (bool DoorUnlockconstate_)  :
    _DoorUnlockconstate (DoorUnlockconstate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoorUnlockStatusStatus::~DoorUnlockStatusStatus() {
}

inline DoorUnlockStatusStatus& DoorUnlockStatusStatus::operator = (const DoorUnlockStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDoorUnlockconstate()) {
            setDoorUnlockconstate(rhs.getDoorUnlockconstate());
        } else {
            clearDoorUnlockconstate();
        }
    }
    return *this;
}

inline bool DoorUnlockStatusStatus::operator == (const DoorUnlockStatusStatus& rhs) const {
    return (((!hasDoorUnlockconstate() && !rhs.hasDoorUnlockconstate()) || getDoorUnlockconstate() == rhs.getDoorUnlockconstate()));
}

inline bool DoorUnlockStatusStatus::operator != (const DoorUnlockStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DoorUnlockStatusStatus::operator < (const DoorUnlockStatusStatus& rhs) const {
    if (hasDoorUnlockconstate() || rhs.hasDoorUnlockconstate()) {
        if (getDoorUnlockconstate() < rhs.getDoorUnlockconstate()) return true;
        if (getDoorUnlockconstate() > rhs.getDoorUnlockconstate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoorUnlockStatusStatus::clone() {
    return new DoorUnlockStatusStatus(*this);
}

inline bool DoorUnlockStatusStatus::operator > (const DoorUnlockStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoorUnlockStatusStatus::clear() {
    clearDoorUnlockconstate();
}

inline void DoorUnlockStatusStatus::clearDoorUnlockconstate() {
    if (hasDoorUnlockconstate()) {
         clear_has_DoorUnlockconstate();
        _DoorUnlockconstate = false;
     }
}

inline bool DoorUnlockStatusStatus::hasDoorUnlockconstate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool DoorUnlockStatusStatus::getDoorUnlockconstate () const {
    return _DoorUnlockconstate;
}

inline void DoorUnlockStatusStatus::setDoorUnlockconstate (bool DoorUnlockconstate_) {
    set_has_DoorUnlockconstate();
    this->_DoorUnlockconstate = DoorUnlockconstate_;
}

inline void DoorUnlockStatusStatus::set_has_DoorUnlockconstate () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoorUnlockStatusStatus::clear_has_DoorUnlockconstate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DoorUnlockStatusSet::DoorUnlockStatusSet ()  :
    _DoorUnlockconstate (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DoorUnlockStatusSet::DoorUnlockStatusSet (const DoorUnlockStatusSet &rhs)  :
    ::asf::core::Payload(rhs),
    _DoorUnlockconstate (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DoorUnlockStatusSet::DoorUnlockStatusSet (bool DoorUnlockconstate_)  :
    _DoorUnlockconstate (DoorUnlockconstate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DoorUnlockStatusSet::~DoorUnlockStatusSet() {
}

inline DoorUnlockStatusSet& DoorUnlockStatusSet::operator = (const DoorUnlockStatusSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDoorUnlockconstate()) {
            setDoorUnlockconstate(rhs.getDoorUnlockconstate());
        } else {
            clearDoorUnlockconstate();
        }
    }
    return *this;
}

inline bool DoorUnlockStatusSet::operator == (const DoorUnlockStatusSet& rhs) const {
    return (((!hasDoorUnlockconstate() && !rhs.hasDoorUnlockconstate()) || getDoorUnlockconstate() == rhs.getDoorUnlockconstate()));
}

inline bool DoorUnlockStatusSet::operator != (const DoorUnlockStatusSet& rhs) const {
    return ! (*this == rhs);
}

inline bool DoorUnlockStatusSet::operator < (const DoorUnlockStatusSet& rhs) const {
    if (hasDoorUnlockconstate() || rhs.hasDoorUnlockconstate()) {
        if (getDoorUnlockconstate() < rhs.getDoorUnlockconstate()) return true;
        if (getDoorUnlockconstate() > rhs.getDoorUnlockconstate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DoorUnlockStatusSet::clone() {
    return new DoorUnlockStatusSet(*this);
}

inline bool DoorUnlockStatusSet::operator > (const DoorUnlockStatusSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DoorUnlockStatusSet::clear() {
    clearDoorUnlockconstate();
}

inline void DoorUnlockStatusSet::clearDoorUnlockconstate() {
    if (hasDoorUnlockconstate()) {
         clear_has_DoorUnlockconstate();
        _DoorUnlockconstate = false;
     }
}

inline bool DoorUnlockStatusSet::hasDoorUnlockconstate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool DoorUnlockStatusSet::getDoorUnlockconstate () const {
    return _DoorUnlockconstate;
}

inline void DoorUnlockStatusSet::setDoorUnlockconstate (bool DoorUnlockconstate_) {
    set_has_DoorUnlockconstate();
    this->_DoorUnlockconstate = DoorUnlockconstate_;
}

inline void DoorUnlockStatusSet::set_has_DoorUnlockconstate () {
    _has_bits_[0] |= 1u << 0;
}

inline void DoorUnlockStatusSet::clear_has_DoorUnlockconstate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PNMGRP10SignalStatusStatus::PNMGRP10SignalStatusStatus ()  :
    _PNMGRP10Signalstate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PNMGRP10SignalStatusStatus::PNMGRP10SignalStatusStatus (const PNMGRP10SignalStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _PNMGRP10Signalstate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PNMGRP10SignalStatusStatus::PNMGRP10SignalStatusStatus (uint8 PNMGRP10Signalstate_)  :
    _PNMGRP10Signalstate (PNMGRP10Signalstate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PNMGRP10SignalStatusStatus::~PNMGRP10SignalStatusStatus() {
}

inline PNMGRP10SignalStatusStatus& PNMGRP10SignalStatusStatus::operator = (const PNMGRP10SignalStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPNMGRP10Signalstate()) {
            setPNMGRP10Signalstate(rhs.getPNMGRP10Signalstate());
        } else {
            clearPNMGRP10Signalstate();
        }
    }
    return *this;
}

inline bool PNMGRP10SignalStatusStatus::operator == (const PNMGRP10SignalStatusStatus& rhs) const {
    return (((!hasPNMGRP10Signalstate() && !rhs.hasPNMGRP10Signalstate()) || getPNMGRP10Signalstate() == rhs.getPNMGRP10Signalstate()));
}

inline bool PNMGRP10SignalStatusStatus::operator != (const PNMGRP10SignalStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool PNMGRP10SignalStatusStatus::operator < (const PNMGRP10SignalStatusStatus& rhs) const {
    if (hasPNMGRP10Signalstate() || rhs.hasPNMGRP10Signalstate()) {
        if (getPNMGRP10Signalstate() < rhs.getPNMGRP10Signalstate()) return true;
        if (getPNMGRP10Signalstate() > rhs.getPNMGRP10Signalstate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PNMGRP10SignalStatusStatus::clone() {
    return new PNMGRP10SignalStatusStatus(*this);
}

inline bool PNMGRP10SignalStatusStatus::operator > (const PNMGRP10SignalStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PNMGRP10SignalStatusStatus::clear() {
    clearPNMGRP10Signalstate();
}

inline void PNMGRP10SignalStatusStatus::clearPNMGRP10Signalstate() {
    if (hasPNMGRP10Signalstate()) {
         clear_has_PNMGRP10Signalstate();
        _PNMGRP10Signalstate = 0u;
     }
}

inline bool PNMGRP10SignalStatusStatus::hasPNMGRP10Signalstate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 PNMGRP10SignalStatusStatus::getPNMGRP10Signalstate () const {
    return _PNMGRP10Signalstate;
}

inline void PNMGRP10SignalStatusStatus::setPNMGRP10Signalstate (uint8 PNMGRP10Signalstate_) {
    set_has_PNMGRP10Signalstate();
    this->_PNMGRP10Signalstate = PNMGRP10Signalstate_;
}

inline void PNMGRP10SignalStatusStatus::set_has_PNMGRP10Signalstate () {
    _has_bits_[0] |= 1u << 0;
}

inline void PNMGRP10SignalStatusStatus::clear_has_PNMGRP10Signalstate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PNMGRP10SignalStatusSet::PNMGRP10SignalStatusSet ()  :
    _PNMGRP10Signalstate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PNMGRP10SignalStatusSet::PNMGRP10SignalStatusSet (const PNMGRP10SignalStatusSet &rhs)  :
    ::asf::core::Payload(rhs),
    _PNMGRP10Signalstate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PNMGRP10SignalStatusSet::PNMGRP10SignalStatusSet (uint8 PNMGRP10Signalstate_)  :
    _PNMGRP10Signalstate (PNMGRP10Signalstate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PNMGRP10SignalStatusSet::~PNMGRP10SignalStatusSet() {
}

inline PNMGRP10SignalStatusSet& PNMGRP10SignalStatusSet::operator = (const PNMGRP10SignalStatusSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPNMGRP10Signalstate()) {
            setPNMGRP10Signalstate(rhs.getPNMGRP10Signalstate());
        } else {
            clearPNMGRP10Signalstate();
        }
    }
    return *this;
}

inline bool PNMGRP10SignalStatusSet::operator == (const PNMGRP10SignalStatusSet& rhs) const {
    return (((!hasPNMGRP10Signalstate() && !rhs.hasPNMGRP10Signalstate()) || getPNMGRP10Signalstate() == rhs.getPNMGRP10Signalstate()));
}

inline bool PNMGRP10SignalStatusSet::operator != (const PNMGRP10SignalStatusSet& rhs) const {
    return ! (*this == rhs);
}

inline bool PNMGRP10SignalStatusSet::operator < (const PNMGRP10SignalStatusSet& rhs) const {
    if (hasPNMGRP10Signalstate() || rhs.hasPNMGRP10Signalstate()) {
        if (getPNMGRP10Signalstate() < rhs.getPNMGRP10Signalstate()) return true;
        if (getPNMGRP10Signalstate() > rhs.getPNMGRP10Signalstate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PNMGRP10SignalStatusSet::clone() {
    return new PNMGRP10SignalStatusSet(*this);
}

inline bool PNMGRP10SignalStatusSet::operator > (const PNMGRP10SignalStatusSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PNMGRP10SignalStatusSet::clear() {
    clearPNMGRP10Signalstate();
}

inline void PNMGRP10SignalStatusSet::clearPNMGRP10Signalstate() {
    if (hasPNMGRP10Signalstate()) {
         clear_has_PNMGRP10Signalstate();
        _PNMGRP10Signalstate = 0u;
     }
}

inline bool PNMGRP10SignalStatusSet::hasPNMGRP10Signalstate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 PNMGRP10SignalStatusSet::getPNMGRP10Signalstate () const {
    return _PNMGRP10Signalstate;
}

inline void PNMGRP10SignalStatusSet::setPNMGRP10Signalstate (uint8 PNMGRP10Signalstate_) {
    set_has_PNMGRP10Signalstate();
    this->_PNMGRP10Signalstate = PNMGRP10Signalstate_;
}

inline void PNMGRP10SignalStatusSet::set_has_PNMGRP10Signalstate () {
    _has_bits_[0] |= 1u << 0;
}

inline void PNMGRP10SignalStatusSet::clear_has_PNMGRP10Signalstate () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace lcmdbusclient_main_fi

#endif // LCMDBUSCLIENT_MAIN_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
