#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef LCM_DBUSCTRL_FI_TYPES_H
#define LCM_DBUSCTRL_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "lcm_dbusctrl_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types lcm_dbusctrl_fi_types
 */

namespace lcm_dbusctrl_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_ServiceElement;

class T_StartupFailureInfo;

// type definitions
/**
 * If the meaning of "T_SPM_ServiceList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_ServiceElement > T_SPM_ServiceList;


/**
 * contains the current state of a service (systemd unit).
 */
class T_ServiceElement {
public:

    /**
     * Default constructor
     */
    inline  T_ServiceElement ();

    /**
     * Copy constructor
     */
    inline  T_ServiceElement (const T_ServiceElement &rhs);

    /**
     * All fields constructor
     */
    inline  T_ServiceElement (const ::std::string& tUnitName_, const ::std::string& tDescription_, const ::std::string& tLoadState_, const ::std::string& tActiveState_, const ::std::string& tSubState_, const ::std::string& tFollower_);

    /**
     * Destructor
     */
    inline  ~T_ServiceElement();

    /**
     * Assignment operator
     */
    inline T_ServiceElement& operator = (const T_ServiceElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ServiceElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ServiceElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ServiceElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ServiceElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tUnitName"

    static const int kTUnitName = 0;

    /**
     * Clears the field "tUnitName".
     *
     * The field will be set to its default value. The hasTUnitName()
     * method will return false.
     */
    inline void clearTUnitName();

    /**
     * Checks whether the field "tUnitName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTUnitName()). Otherwise it will return false.
     */
    inline bool hasTUnitName () const;

    /**
     * Returns the value of the member "tUnitName".
     *
     * If the meaning of "tUnitName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tUnitName"
     */
    inline const ::std::string& getTUnitName () const;

    /**
     * Retrieves the value of the field "tUnitName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tUnitName".
     */
    inline ::std::string& getTUnitNameMutable ();

    /**
     * Sets the value of the member "tUnitName".
     *
     * If the meaning of "tUnitName" isn't clear, then there should be a description here.
     *
     * @param tUnitName The value which will be set
     */
    inline void setTUnitName (const ::std::string& tUnitName_);

    /**
     * Sets the value of the member "tUnitName".
     *
     * If the meaning of "tUnitName" isn't clear, then there should be a description here.
     *
     * @param tUnitName The value which will be set
     */
    inline void setTUnitName (const char* tUnitName_);

    /**
     * Sets the value of the member "tUnitName".
     *
     * If the meaning of "tUnitName" isn't clear, then there should be a description here.
     *
     * @param tUnitName The value which will be set
     */
    inline void setTUnitName (const char* value, size_t size);

    // API of field "tDescription"

    static const int kTDescription = 1;

    /**
     * Clears the field "tDescription".
     *
     * The field will be set to its default value. The hasTDescription()
     * method will return false.
     */
    inline void clearTDescription();

    /**
     * Checks whether the field "tDescription" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTDescription()). Otherwise it will return false.
     */
    inline bool hasTDescription () const;

    /**
     * Returns the value of the member "tDescription".
     *
     * If the meaning of "tDescription" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tDescription"
     */
    inline const ::std::string& getTDescription () const;

    /**
     * Retrieves the value of the field "tDescription" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tDescription".
     */
    inline ::std::string& getTDescriptionMutable ();

    /**
     * Sets the value of the member "tDescription".
     *
     * If the meaning of "tDescription" isn't clear, then there should be a description here.
     *
     * @param tDescription The value which will be set
     */
    inline void setTDescription (const ::std::string& tDescription_);

    /**
     * Sets the value of the member "tDescription".
     *
     * If the meaning of "tDescription" isn't clear, then there should be a description here.
     *
     * @param tDescription The value which will be set
     */
    inline void setTDescription (const char* tDescription_);

    /**
     * Sets the value of the member "tDescription".
     *
     * If the meaning of "tDescription" isn't clear, then there should be a description here.
     *
     * @param tDescription The value which will be set
     */
    inline void setTDescription (const char* value, size_t size);

    // API of field "tLoadState"

    static const int kTLoadState = 2;

    /**
     * Clears the field "tLoadState".
     *
     * The field will be set to its default value. The hasTLoadState()
     * method will return false.
     */
    inline void clearTLoadState();

    /**
     * Checks whether the field "tLoadState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTLoadState()). Otherwise it will return false.
     */
    inline bool hasTLoadState () const;

    /**
     * Returns the value of the member "tLoadState".
     *
     * If the meaning of "tLoadState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tLoadState"
     */
    inline const ::std::string& getTLoadState () const;

    /**
     * Retrieves the value of the field "tLoadState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tLoadState".
     */
    inline ::std::string& getTLoadStateMutable ();

    /**
     * Sets the value of the member "tLoadState".
     *
     * If the meaning of "tLoadState" isn't clear, then there should be a description here.
     *
     * @param tLoadState The value which will be set
     */
    inline void setTLoadState (const ::std::string& tLoadState_);

    /**
     * Sets the value of the member "tLoadState".
     *
     * If the meaning of "tLoadState" isn't clear, then there should be a description here.
     *
     * @param tLoadState The value which will be set
     */
    inline void setTLoadState (const char* tLoadState_);

    /**
     * Sets the value of the member "tLoadState".
     *
     * If the meaning of "tLoadState" isn't clear, then there should be a description here.
     *
     * @param tLoadState The value which will be set
     */
    inline void setTLoadState (const char* value, size_t size);

    // API of field "tActiveState"

    static const int kTActiveState = 3;

    /**
     * Clears the field "tActiveState".
     *
     * The field will be set to its default value. The hasTActiveState()
     * method will return false.
     */
    inline void clearTActiveState();

    /**
     * Checks whether the field "tActiveState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTActiveState()). Otherwise it will return false.
     */
    inline bool hasTActiveState () const;

    /**
     * Returns the value of the member "tActiveState".
     *
     * If the meaning of "tActiveState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tActiveState"
     */
    inline const ::std::string& getTActiveState () const;

    /**
     * Retrieves the value of the field "tActiveState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tActiveState".
     */
    inline ::std::string& getTActiveStateMutable ();

    /**
     * Sets the value of the member "tActiveState".
     *
     * If the meaning of "tActiveState" isn't clear, then there should be a description here.
     *
     * @param tActiveState The value which will be set
     */
    inline void setTActiveState (const ::std::string& tActiveState_);

    /**
     * Sets the value of the member "tActiveState".
     *
     * If the meaning of "tActiveState" isn't clear, then there should be a description here.
     *
     * @param tActiveState The value which will be set
     */
    inline void setTActiveState (const char* tActiveState_);

    /**
     * Sets the value of the member "tActiveState".
     *
     * If the meaning of "tActiveState" isn't clear, then there should be a description here.
     *
     * @param tActiveState The value which will be set
     */
    inline void setTActiveState (const char* value, size_t size);

    // API of field "tSubState"

    static const int kTSubState = 4;

    /**
     * Clears the field "tSubState".
     *
     * The field will be set to its default value. The hasTSubState()
     * method will return false.
     */
    inline void clearTSubState();

    /**
     * Checks whether the field "tSubState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSubState()). Otherwise it will return false.
     */
    inline bool hasTSubState () const;

    /**
     * Returns the value of the member "tSubState".
     *
     * If the meaning of "tSubState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tSubState"
     */
    inline const ::std::string& getTSubState () const;

    /**
     * Retrieves the value of the field "tSubState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSubState".
     */
    inline ::std::string& getTSubStateMutable ();

    /**
     * Sets the value of the member "tSubState".
     *
     * If the meaning of "tSubState" isn't clear, then there should be a description here.
     *
     * @param tSubState The value which will be set
     */
    inline void setTSubState (const ::std::string& tSubState_);

    /**
     * Sets the value of the member "tSubState".
     *
     * If the meaning of "tSubState" isn't clear, then there should be a description here.
     *
     * @param tSubState The value which will be set
     */
    inline void setTSubState (const char* tSubState_);

    /**
     * Sets the value of the member "tSubState".
     *
     * If the meaning of "tSubState" isn't clear, then there should be a description here.
     *
     * @param tSubState The value which will be set
     */
    inline void setTSubState (const char* value, size_t size);

    // API of field "tFollower"

    static const int kTFollower = 5;

    /**
     * Clears the field "tFollower".
     *
     * The field will be set to its default value. The hasTFollower()
     * method will return false.
     */
    inline void clearTFollower();

    /**
     * Checks whether the field "tFollower" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTFollower()). Otherwise it will return false.
     */
    inline bool hasTFollower () const;

    /**
     * Returns the value of the member "tFollower".
     *
     * If the meaning of "tFollower" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tFollower"
     */
    inline const ::std::string& getTFollower () const;

    /**
     * Retrieves the value of the field "tFollower" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tFollower".
     */
    inline ::std::string& getTFollowerMutable ();

    /**
     * Sets the value of the member "tFollower".
     *
     * If the meaning of "tFollower" isn't clear, then there should be a description here.
     *
     * @param tFollower The value which will be set
     */
    inline void setTFollower (const ::std::string& tFollower_);

    /**
     * Sets the value of the member "tFollower".
     *
     * If the meaning of "tFollower" isn't clear, then there should be a description here.
     *
     * @param tFollower The value which will be set
     */
    inline void setTFollower (const char* tFollower_);

    /**
     * Sets the value of the member "tFollower".
     *
     * If the meaning of "tFollower" isn't clear, then there should be a description here.
     *
     * @param tFollower The value which will be set
     */
    inline void setTFollower (const char* value, size_t size);

    static const T_ServiceElement &getDefaultInstance();

private:

    inline void set_has_tUnitName ();

    inline void clear_has_tUnitName ();

    inline void set_has_tDescription ();

    inline void clear_has_tDescription ();

    inline void set_has_tLoadState ();

    inline void clear_has_tLoadState ();

    inline void set_has_tActiveState ();

    inline void clear_has_tActiveState ();

    inline void set_has_tSubState ();

    inline void clear_has_tSubState ();

    inline void set_has_tFollower ();

    inline void clear_has_tFollower ();

    uint32 _has_bits_[ (6 + 31) / 32];

    ::std::string _tUnitName;

    ::std::string _tDescription;

    ::std::string _tLoadState;

    ::std::string _tActiveState;

    ::std::string _tSubState;

    ::std::string _tFollower;

};

/**
 * contains information of StartupController failure.
 */
class T_StartupFailureInfo {
public:

    /**
     * Default constructor
     */
    inline  T_StartupFailureInfo ();

    /**
     * Copy constructor
     */
    inline  T_StartupFailureInfo (const T_StartupFailureInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_StartupFailureInfo (T_e32_LCM_STARTUP_FAILURE_TYPE tFailure_, T_e32_LCM_STARTUP_TYPE tState_, uint32 u32Data_);

    /**
     * Destructor
     */
    inline  ~T_StartupFailureInfo();

    /**
     * Assignment operator
     */
    inline T_StartupFailureInfo& operator = (const T_StartupFailureInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_StartupFailureInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_StartupFailureInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_StartupFailureInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_StartupFailureInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tFailure"

    static const int kTFailure = 0;

    /**
     * Clears the field "tFailure".
     *
     * The field will be set to its default value. The hasTFailure()
     * method will return false.
     */
    inline void clearTFailure();

    /**
     * Checks whether the field "tFailure" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTFailure()). Otherwise it will return false.
     */
    inline bool hasTFailure () const;

    /**
     * Returns the value of the member "tFailure".
     *
     * If the meaning of "tFailure" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tFailure"
     */
    inline T_e32_LCM_STARTUP_FAILURE_TYPE getTFailure () const;

    /**
     * Sets the value of the member "tFailure".
     *
     * If the meaning of "tFailure" isn't clear, then there should be a description here.
     *
     * @param tFailure The value which will be set
     */
    inline void setTFailure (T_e32_LCM_STARTUP_FAILURE_TYPE tFailure_);

    // API of field "tState"

    static const int kTState = 1;

    /**
     * Clears the field "tState".
     *
     * The field will be set to its default value. The hasTState()
     * method will return false.
     */
    inline void clearTState();

    /**
     * Checks whether the field "tState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTState()). Otherwise it will return false.
     */
    inline bool hasTState () const;

    /**
     * Returns the value of the member "tState".
     *
     * If the meaning of "tState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tState"
     */
    inline T_e32_LCM_STARTUP_TYPE getTState () const;

    /**
     * Sets the value of the member "tState".
     *
     * If the meaning of "tState" isn't clear, then there should be a description here.
     *
     * @param tState The value which will be set
     */
    inline void setTState (T_e32_LCM_STARTUP_TYPE tState_);

    // API of field "u32Data"

    static const int kU32Data = 2;

    /**
     * Clears the field "u32Data".
     *
     * The field will be set to its default value. The hasU32Data()
     * method will return false.
     */
    inline void clearU32Data();

    /**
     * Checks whether the field "u32Data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Data()). Otherwise it will return false.
     */
    inline bool hasU32Data () const;

    /**
     * Returns the value of the member "u32Data".
     *
     * If the meaning of "u32Data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32Data"
     */
    inline uint32 getU32Data () const;

    /**
     * Sets the value of the member "u32Data".
     *
     * If the meaning of "u32Data" isn't clear, then there should be a description here.
     *
     * @param u32Data The value which will be set
     */
    inline void setU32Data (uint32 u32Data_);

    static const T_StartupFailureInfo &getDefaultInstance();

private:

    inline void set_has_tFailure ();

    inline void clear_has_tFailure ();

    inline void set_has_tState ();

    inline void clear_has_tState ();

    inline void set_has_u32Data ();

    inline void clear_has_u32Data ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_e32_LCM_STARTUP_FAILURE_TYPE _tFailure;

    T_e32_LCM_STARTUP_TYPE _tState;

    uint32 _u32Data;

};

inline  T_ServiceElement::T_ServiceElement ()  :
    _tUnitName (),
    _tDescription (),
    _tLoadState (),
    _tActiveState (),
    _tSubState (),
    _tFollower ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ServiceElement::T_ServiceElement (const T_ServiceElement &rhs)  :
    _tUnitName (),
    _tDescription (),
    _tLoadState (),
    _tActiveState (),
    _tSubState (),
    _tFollower ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ServiceElement::T_ServiceElement (const ::std::string& tUnitName_, const ::std::string& tDescription_, const ::std::string& tLoadState_, const ::std::string& tActiveState_, const ::std::string& tSubState_, const ::std::string& tFollower_)  :
    _tUnitName (tUnitName_),
    _tDescription (tDescription_),
    _tLoadState (tLoadState_),
    _tActiveState (tActiveState_),
    _tSubState (tSubState_),
    _tFollower (tFollower_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tUnitName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tDescription_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tLoadState_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tActiveState_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tSubState_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tFollower_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ServiceElement::~T_ServiceElement() {
}

inline T_ServiceElement& T_ServiceElement::operator = (const T_ServiceElement& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTUnitName()) {
            setTUnitName(rhs.getTUnitName());
        } else {
            clearTUnitName();
        }
        if (rhs.hasTDescription()) {
            setTDescription(rhs.getTDescription());
        } else {
            clearTDescription();
        }
        if (rhs.hasTLoadState()) {
            setTLoadState(rhs.getTLoadState());
        } else {
            clearTLoadState();
        }
        if (rhs.hasTActiveState()) {
            setTActiveState(rhs.getTActiveState());
        } else {
            clearTActiveState();
        }
        if (rhs.hasTSubState()) {
            setTSubState(rhs.getTSubState());
        } else {
            clearTSubState();
        }
        if (rhs.hasTFollower()) {
            setTFollower(rhs.getTFollower());
        } else {
            clearTFollower();
        }
    }
    return *this;
}

inline bool T_ServiceElement::operator == (const T_ServiceElement& rhs) const {
    return (((!hasTUnitName() && !rhs.hasTUnitName()) || getTUnitName() == rhs.getTUnitName()) &&
        ((!hasTDescription() && !rhs.hasTDescription()) || getTDescription() == rhs.getTDescription()) &&
        ((!hasTLoadState() && !rhs.hasTLoadState()) || getTLoadState() == rhs.getTLoadState()) &&
        ((!hasTActiveState() && !rhs.hasTActiveState()) || getTActiveState() == rhs.getTActiveState()) &&
        ((!hasTSubState() && !rhs.hasTSubState()) || getTSubState() == rhs.getTSubState()) &&
        ((!hasTFollower() && !rhs.hasTFollower()) || getTFollower() == rhs.getTFollower()));
}

inline bool T_ServiceElement::operator != (const T_ServiceElement& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ServiceElement::operator < (const T_ServiceElement& rhs) const {
    if (hasTUnitName() || rhs.hasTUnitName()) {
        if (getTUnitName() < rhs.getTUnitName()) return true;
        if (getTUnitName() > rhs.getTUnitName()) return false;
    }
    if (hasTDescription() || rhs.hasTDescription()) {
        if (getTDescription() < rhs.getTDescription()) return true;
        if (getTDescription() > rhs.getTDescription()) return false;
    }
    if (hasTLoadState() || rhs.hasTLoadState()) {
        if (getTLoadState() < rhs.getTLoadState()) return true;
        if (getTLoadState() > rhs.getTLoadState()) return false;
    }
    if (hasTActiveState() || rhs.hasTActiveState()) {
        if (getTActiveState() < rhs.getTActiveState()) return true;
        if (getTActiveState() > rhs.getTActiveState()) return false;
    }
    if (hasTSubState() || rhs.hasTSubState()) {
        if (getTSubState() < rhs.getTSubState()) return true;
        if (getTSubState() > rhs.getTSubState()) return false;
    }
    if (hasTFollower() || rhs.hasTFollower()) {
        if (getTFollower() < rhs.getTFollower()) return true;
        if (getTFollower() > rhs.getTFollower()) return false;
    }
    return false;
}

inline bool T_ServiceElement::operator > (const T_ServiceElement& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ServiceElement::clear() {
    clearTUnitName();
    clearTDescription();
    clearTLoadState();
    clearTActiveState();
    clearTSubState();
    clearTFollower();
}

inline void T_ServiceElement::clearTUnitName() {
    if (hasTUnitName()) {
         clear_has_tUnitName();
        _tUnitName.clear();
     }
}

inline bool T_ServiceElement::hasTUnitName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_ServiceElement::getTUnitName () const {
    return _tUnitName;
}

inline ::std::string& T_ServiceElement::getTUnitNameMutable () {
    set_has_tUnitName();
    return _tUnitName;
}

inline void T_ServiceElement::setTUnitName (const ::std::string& tUnitName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tUnitName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tUnitName();
    this->_tUnitName = tUnitName_;
}

inline void T_ServiceElement::setTUnitName (const char* tUnitName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tUnitName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tUnitName();
    this->_tUnitName.assign(tUnitName_);
}

inline void T_ServiceElement::setTUnitName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tUnitName();
    this->_tUnitName.assign(value, size);
}

inline void T_ServiceElement::clearTDescription() {
    if (hasTDescription()) {
         clear_has_tDescription();
        _tDescription.clear();
     }
}

inline bool T_ServiceElement::hasTDescription () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_ServiceElement::getTDescription () const {
    return _tDescription;
}

inline ::std::string& T_ServiceElement::getTDescriptionMutable () {
    set_has_tDescription();
    return _tDescription;
}

inline void T_ServiceElement::setTDescription (const ::std::string& tDescription_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tDescription_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tDescription();
    this->_tDescription = tDescription_;
}

inline void T_ServiceElement::setTDescription (const char* tDescription_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tDescription_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tDescription();
    this->_tDescription.assign(tDescription_);
}

inline void T_ServiceElement::setTDescription (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tDescription();
    this->_tDescription.assign(value, size);
}

inline void T_ServiceElement::clearTLoadState() {
    if (hasTLoadState()) {
         clear_has_tLoadState();
        _tLoadState.clear();
     }
}

inline bool T_ServiceElement::hasTLoadState () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_ServiceElement::getTLoadState () const {
    return _tLoadState;
}

inline ::std::string& T_ServiceElement::getTLoadStateMutable () {
    set_has_tLoadState();
    return _tLoadState;
}

inline void T_ServiceElement::setTLoadState (const ::std::string& tLoadState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tLoadState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tLoadState();
    this->_tLoadState = tLoadState_;
}

inline void T_ServiceElement::setTLoadState (const char* tLoadState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tLoadState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tLoadState();
    this->_tLoadState.assign(tLoadState_);
}

inline void T_ServiceElement::setTLoadState (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tLoadState();
    this->_tLoadState.assign(value, size);
}

inline void T_ServiceElement::clearTActiveState() {
    if (hasTActiveState()) {
         clear_has_tActiveState();
        _tActiveState.clear();
     }
}

inline bool T_ServiceElement::hasTActiveState () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_ServiceElement::getTActiveState () const {
    return _tActiveState;
}

inline ::std::string& T_ServiceElement::getTActiveStateMutable () {
    set_has_tActiveState();
    return _tActiveState;
}

inline void T_ServiceElement::setTActiveState (const ::std::string& tActiveState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tActiveState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tActiveState();
    this->_tActiveState = tActiveState_;
}

inline void T_ServiceElement::setTActiveState (const char* tActiveState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tActiveState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tActiveState();
    this->_tActiveState.assign(tActiveState_);
}

inline void T_ServiceElement::setTActiveState (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tActiveState();
    this->_tActiveState.assign(value, size);
}

inline void T_ServiceElement::clearTSubState() {
    if (hasTSubState()) {
         clear_has_tSubState();
        _tSubState.clear();
     }
}

inline bool T_ServiceElement::hasTSubState () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_ServiceElement::getTSubState () const {
    return _tSubState;
}

inline ::std::string& T_ServiceElement::getTSubStateMutable () {
    set_has_tSubState();
    return _tSubState;
}

inline void T_ServiceElement::setTSubState (const ::std::string& tSubState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tSubState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tSubState();
    this->_tSubState = tSubState_;
}

inline void T_ServiceElement::setTSubState (const char* tSubState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tSubState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tSubState();
    this->_tSubState.assign(tSubState_);
}

inline void T_ServiceElement::setTSubState (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tSubState();
    this->_tSubState.assign(value, size);
}

inline void T_ServiceElement::clearTFollower() {
    if (hasTFollower()) {
         clear_has_tFollower();
        _tFollower.clear();
     }
}

inline bool T_ServiceElement::hasTFollower () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& T_ServiceElement::getTFollower () const {
    return _tFollower;
}

inline ::std::string& T_ServiceElement::getTFollowerMutable () {
    set_has_tFollower();
    return _tFollower;
}

inline void T_ServiceElement::setTFollower (const ::std::string& tFollower_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tFollower_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tFollower();
    this->_tFollower = tFollower_;
}

inline void T_ServiceElement::setTFollower (const char* tFollower_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (tFollower_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tFollower();
    this->_tFollower.assign(tFollower_);
}

inline void T_ServiceElement::setTFollower (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_tFollower();
    this->_tFollower.assign(value, size);
}

inline void T_ServiceElement::set_has_tUnitName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ServiceElement::clear_has_tUnitName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_ServiceElement::set_has_tDescription () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_ServiceElement::clear_has_tDescription () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_ServiceElement::set_has_tLoadState () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_ServiceElement::clear_has_tLoadState () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_ServiceElement::set_has_tActiveState () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_ServiceElement::clear_has_tActiveState () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_ServiceElement::set_has_tSubState () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_ServiceElement::clear_has_tSubState () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_ServiceElement::set_has_tFollower () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_ServiceElement::clear_has_tFollower () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  T_StartupFailureInfo::T_StartupFailureInfo ()  :
    _tFailure (::lcm_dbusctrl_fi_types::T_e32_LCM_STARTUP_FAILURE_TYPE__SPM_U32_STARTUP_FAILURE_NONE),
    _tState (::lcm_dbusctrl_fi_types::T_e32_LCM_STARTUP_TYPE__SPM_U32_STARTUP_ACTIVE),
    _u32Data (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_StartupFailureInfo::T_StartupFailureInfo (const T_StartupFailureInfo &rhs)  :
    _tFailure (::lcm_dbusctrl_fi_types::T_e32_LCM_STARTUP_FAILURE_TYPE__SPM_U32_STARTUP_FAILURE_NONE),
    _tState (::lcm_dbusctrl_fi_types::T_e32_LCM_STARTUP_TYPE__SPM_U32_STARTUP_ACTIVE),
    _u32Data (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_StartupFailureInfo::T_StartupFailureInfo (T_e32_LCM_STARTUP_FAILURE_TYPE tFailure_, T_e32_LCM_STARTUP_TYPE tState_, uint32 u32Data_)  :
    _tFailure (tFailure_),
    _tState (tState_),
    _u32Data (u32Data_)
{
    #ifndef NDEBUG
    if (!(T_e32_LCM_STARTUP_FAILURE_TYPE_IsValid(tFailure_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tFailure_, "T_e32_LCM_STARTUP_FAILURE_TYPE", "tFailure", "T_StartupFailureInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e32_LCM_STARTUP_TYPE_IsValid(tState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tState_, "T_e32_LCM_STARTUP_TYPE", "tState", "T_StartupFailureInfo");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_StartupFailureInfo::~T_StartupFailureInfo() {
}

inline T_StartupFailureInfo& T_StartupFailureInfo::operator = (const T_StartupFailureInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTFailure()) {
            setTFailure(rhs.getTFailure());
        } else {
            clearTFailure();
        }
        if (rhs.hasTState()) {
            setTState(rhs.getTState());
        } else {
            clearTState();
        }
        if (rhs.hasU32Data()) {
            setU32Data(rhs.getU32Data());
        } else {
            clearU32Data();
        }
    }
    return *this;
}

inline bool T_StartupFailureInfo::operator == (const T_StartupFailureInfo& rhs) const {
    return (((!hasTFailure() && !rhs.hasTFailure()) || getTFailure() == rhs.getTFailure()) &&
        ((!hasTState() && !rhs.hasTState()) || getTState() == rhs.getTState()) &&
        ((!hasU32Data() && !rhs.hasU32Data()) || getU32Data() == rhs.getU32Data()));
}

inline bool T_StartupFailureInfo::operator != (const T_StartupFailureInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_StartupFailureInfo::operator < (const T_StartupFailureInfo& rhs) const {
    if (hasTFailure() || rhs.hasTFailure()) {
        if ((uint32)getTFailure() < (uint32)rhs.getTFailure()) return true;
        if ((uint32)getTFailure() > (uint32)rhs.getTFailure()) return false;
    }
    if (hasTState() || rhs.hasTState()) {
        if ((uint32)getTState() < (uint32)rhs.getTState()) return true;
        if ((uint32)getTState() > (uint32)rhs.getTState()) return false;
    }
    if (hasU32Data() || rhs.hasU32Data()) {
        if (getU32Data() < rhs.getU32Data()) return true;
        if (getU32Data() > rhs.getU32Data()) return false;
    }
    return false;
}

inline bool T_StartupFailureInfo::operator > (const T_StartupFailureInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_StartupFailureInfo::clear() {
    clearTFailure();
    clearTState();
    clearU32Data();
}

inline void T_StartupFailureInfo::clearTFailure() {
    if (hasTFailure()) {
         clear_has_tFailure();
        _tFailure = ::lcm_dbusctrl_fi_types::T_e32_LCM_STARTUP_FAILURE_TYPE__SPM_U32_STARTUP_FAILURE_NONE;
     }
}

inline bool T_StartupFailureInfo::hasTFailure () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e32_LCM_STARTUP_FAILURE_TYPE T_StartupFailureInfo::getTFailure () const {
    return _tFailure;
}

inline void T_StartupFailureInfo::setTFailure (T_e32_LCM_STARTUP_FAILURE_TYPE tFailure_) {
    #ifndef NDEBUG
    if (!(T_e32_LCM_STARTUP_FAILURE_TYPE_IsValid(tFailure_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tFailure_, "T_e32_LCM_STARTUP_FAILURE_TYPE", "tFailure", "T_StartupFailureInfo");
    }
    #endif
    set_has_tFailure();
    this->_tFailure = tFailure_;
}

inline void T_StartupFailureInfo::clearTState() {
    if (hasTState()) {
         clear_has_tState();
        _tState = ::lcm_dbusctrl_fi_types::T_e32_LCM_STARTUP_TYPE__SPM_U32_STARTUP_ACTIVE;
     }
}

inline bool T_StartupFailureInfo::hasTState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e32_LCM_STARTUP_TYPE T_StartupFailureInfo::getTState () const {
    return _tState;
}

inline void T_StartupFailureInfo::setTState (T_e32_LCM_STARTUP_TYPE tState_) {
    #ifndef NDEBUG
    if (!(T_e32_LCM_STARTUP_TYPE_IsValid(tState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", tState_, "T_e32_LCM_STARTUP_TYPE", "tState", "T_StartupFailureInfo");
    }
    #endif
    set_has_tState();
    this->_tState = tState_;
}

inline void T_StartupFailureInfo::clearU32Data() {
    if (hasU32Data()) {
         clear_has_u32Data();
        _u32Data = 0u;
     }
}

inline bool T_StartupFailureInfo::hasU32Data () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_StartupFailureInfo::getU32Data () const {
    return _u32Data;
}

inline void T_StartupFailureInfo::setU32Data (uint32 u32Data_) {
    set_has_u32Data();
    this->_u32Data = u32Data_;
}

inline void T_StartupFailureInfo::set_has_tFailure () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_StartupFailureInfo::clear_has_tFailure () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_StartupFailureInfo::set_has_tState () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_StartupFailureInfo::clear_has_tState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_StartupFailureInfo::set_has_u32Data () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_StartupFailureInfo::clear_has_u32Data () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace lcm_dbusctrl_fi_types

#endif // LCM_DBUSCTRL_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
