/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "lcm_dbusctrl_fiCca.h"
#include "lcm_dbusctrl_fiJson.h"
#include "lcm_dbusctrl_fiProxy.h"
#include "lcm_dbusctrl_fi_typesConst.h"
#include <string>

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace lcm_dbusctrl_fi {

/*static*/ ::asf::core::Logger Lcm_dbusctrl_fiProxy::_logger ("/lcm_dbusctrl_fi/Lcm_dbusctrl_fiProxy");


class Lcm_dbusctrl_fiProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Lcm_dbusctrl_fiProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Lcm_dbusctrl_fiProxy> proxy = ::boost::static_pointer_cast<Lcm_dbusctrl_fiProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_StartProcess: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::StartProcessResult);
                                setActAndLogResult(message, "StartProcess", reinterpret_cast<act_t>(this), _logger);
                                ((StartProcessCallbackIF*) _callback)->onStartProcessResult (proxy, ::boost::static_pointer_cast<StartProcessResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::StartProcessError);
                                setActAndLogError(message, "StartProcess", reinterpret_cast<act_t>(this), _logger);
                                ((StartProcessCallbackIF*) _callback)->onStartProcessError (proxy, ::boost::static_pointer_cast<StartProcessError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_StopProcess: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::StopProcessResult);
                                setActAndLogResult(message, "StopProcess", reinterpret_cast<act_t>(this), _logger);
                                ((StopProcessCallbackIF*) _callback)->onStopProcessResult (proxy, ::boost::static_pointer_cast<StopProcessResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::StopProcessError);
                                setActAndLogError(message, "StopProcess", reinterpret_cast<act_t>(this), _logger);
                                ((StopProcessCallbackIF*) _callback)->onStopProcessError (proxy, ::boost::static_pointer_cast<StopProcessError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_StartupFinished: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::StartupFinishedResult);
                                setActAndLogResult(message, "StartupFinished", reinterpret_cast<act_t>(this), _logger);
                                ((StartupFinishedCallbackIF*) _callback)->onStartupFinishedResult (proxy, ::boost::static_pointer_cast<StartupFinishedResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::StartupFinishedError);
                                setActAndLogError(message, "StartupFinished", reinterpret_cast<act_t>(this), _logger);
                                ((StartupFinishedCallbackIF*) _callback)->onStartupFinishedError (proxy, ::boost::static_pointer_cast<StartupFinishedError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GetProcessId: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::GetProcessIdResult);
                                setActAndLogResult(message, "GetProcessId", reinterpret_cast<act_t>(this), _logger);
                                ((GetProcessIdCallbackIF*) _callback)->onGetProcessIdResult (proxy, ::boost::static_pointer_cast<GetProcessIdResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::GetProcessIdError);
                                setActAndLogError(message, "GetProcessId", reinterpret_cast<act_t>(this), _logger);
                                ((GetProcessIdCallbackIF*) _callback)->onGetProcessIdError (proxy, ::boost::static_pointer_cast<GetProcessIdError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_TriggerGetUnitList: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::TriggerGetUnitListResult);
                                setActAndLogResult(message, "TriggerGetUnitList", reinterpret_cast<act_t>(this), _logger);
                                ((TriggerGetUnitListCallbackIF*) _callback)->onTriggerGetUnitListResult (proxy, ::boost::static_pointer_cast<TriggerGetUnitListResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::TriggerGetUnitListError);
                                setActAndLogError(message, "TriggerGetUnitList", reinterpret_cast<act_t>(this), _logger);
                                ((TriggerGetUnitListCallbackIF*) _callback)->onTriggerGetUnitListError (proxy, ::boost::static_pointer_cast<TriggerGetUnitListError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RestartProcess: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::RestartProcessResult);
                                setActAndLogResult(message, "RestartProcess", reinterpret_cast<act_t>(this), _logger);
                                ((RestartProcessCallbackIF*) _callback)->onRestartProcessResult (proxy, ::boost::static_pointer_cast<RestartProcessResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::RestartProcessError);
                                setActAndLogError(message, "RestartProcess", reinterpret_cast<act_t>(this), _logger);
                                ((RestartProcessCallbackIF*) _callback)->onRestartProcessError (proxy, ::boost::static_pointer_cast<RestartProcessError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AppStartRequest: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::AppStartRequestStatus);
                                setActAndLogStatus(message, "AppStartRequest", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AppStartRequestStatus> payload = ::boost::static_pointer_cast<AppStartRequestStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AppStartRequestStatus >& refNullableStatus = proxy->_appStartRequest;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AppStartRequestCallbackIF*) _callback)->onAppStartRequestStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AppStartRequestCallbackIF*) _callback)->onAppStartRequestStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::AppStartRequestError);
                                setActAndLogError(message, "AppStartRequest", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AppStartRequestCallbackIF*) _callback)->onAppStartRequestError(proxy, ::boost::static_pointer_cast<AppStartRequestError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AppInitialized: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::AppInitializedStatus);
                                setActAndLogStatus(message, "AppInitialized", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AppInitializedStatus> payload = ::boost::static_pointer_cast<AppInitializedStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AppInitializedStatus >& refNullableStatus = proxy->_appInitialized;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AppInitializedCallbackIF*) _callback)->onAppInitializedStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AppInitializedCallbackIF*) _callback)->onAppInitializedStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::AppInitializedError);
                                setActAndLogError(message, "AppInitialized", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AppInitializedCallbackIF*) _callback)->onAppInitializedError(proxy, ::boost::static_pointer_cast<AppInitializedError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AppStateChange: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::AppStateChangeStatus);
                                setActAndLogStatus(message, "AppStateChange", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AppStateChangeStatus> payload = ::boost::static_pointer_cast<AppStateChangeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AppStateChangeStatus >& refNullableStatus = proxy->_appStateChange;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AppStateChangeCallbackIF*) _callback)->onAppStateChangeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AppStateChangeCallbackIF*) _callback)->onAppStateChangeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::AppStateChangeError);
                                setActAndLogError(message, "AppStateChange", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AppStateChangeCallbackIF*) _callback)->onAppStateChangeError(proxy, ::boost::static_pointer_cast<AppStateChangeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AppEnd: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::AppEndStatus);
                                setActAndLogStatus(message, "AppEnd", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AppEndStatus> payload = ::boost::static_pointer_cast<AppEndStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AppEndStatus >& refNullableStatus = proxy->_appEnd;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AppEndCallbackIF*) _callback)->onAppEndStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AppEndCallbackIF*) _callback)->onAppEndStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::AppEndError);
                                setActAndLogError(message, "AppEnd", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((AppEndCallbackIF*) _callback)->onAppEndError(proxy, ::boost::static_pointer_cast<AppEndError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_NewServiceLoaded: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::NewServiceLoadedStatus);
                                setActAndLogStatus(message, "NewServiceLoaded", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<NewServiceLoadedStatus> payload = ::boost::static_pointer_cast<NewServiceLoadedStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< NewServiceLoadedStatus >& refNullableStatus = proxy->_newServiceLoaded;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((NewServiceLoadedCallbackIF*) _callback)->onNewServiceLoadedStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((NewServiceLoadedCallbackIF*) _callback)->onNewServiceLoadedStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::NewServiceLoadedError);
                                setActAndLogError(message, "NewServiceLoaded", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((NewServiceLoadedCallbackIF*) _callback)->onNewServiceLoadedError(proxy, ::boost::static_pointer_cast<NewServiceLoadedError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_FailedServicesList: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::FailedServicesListStatus);
                                setActAndLogStatus(message, "FailedServicesList", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<FailedServicesListStatus> payload = ::boost::static_pointer_cast<FailedServicesListStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< FailedServicesListStatus >& refNullableStatus = proxy->_failedServicesList;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((FailedServicesListCallbackIF*) _callback)->onFailedServicesListStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((FailedServicesListCallbackIF*) _callback)->onFailedServicesListStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::FailedServicesListError);
                                setActAndLogError(message, "FailedServicesList", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((FailedServicesListCallbackIF*) _callback)->onFailedServicesListError(proxy, ::boost::static_pointer_cast<FailedServicesListError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_NewProcessId: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::NewProcessIdStatus);
                                setActAndLogStatus(message, "NewProcessId", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<NewProcessIdStatus> payload = ::boost::static_pointer_cast<NewProcessIdStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< NewProcessIdStatus >& refNullableStatus = proxy->_newProcessId;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((NewProcessIdCallbackIF*) _callback)->onNewProcessIdStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((NewProcessIdCallbackIF*) _callback)->onNewProcessIdStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::NewProcessIdError);
                                setActAndLogError(message, "NewProcessId", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((NewProcessIdCallbackIF*) _callback)->onNewProcessIdError(proxy, ::boost::static_pointer_cast<NewProcessIdError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_StartupFailureIndication: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::StartupFailureIndicationStatus);
                                setActAndLogStatus(message, "StartupFailureIndication", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<StartupFailureIndicationStatus> payload = ::boost::static_pointer_cast<StartupFailureIndicationStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< StartupFailureIndicationStatus >& refNullableStatus = proxy->_startupFailureIndication;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((StartupFailureIndicationCallbackIF*) _callback)->onStartupFailureIndicationStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((StartupFailureIndicationCallbackIF*) _callback)->onStartupFailureIndicationStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::StartupFailureIndicationError);
                                setActAndLogError(message, "StartupFailureIndication", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((StartupFailureIndicationCallbackIF*) _callback)->onStartupFailureIndicationError(proxy, ::boost::static_pointer_cast<StartupFailureIndicationError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SupervisionStateChange: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::SupervisionStateChangeStatus);
                                setActAndLogStatus(message, "SupervisionStateChange", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SupervisionStateChangeStatus> payload = ::boost::static_pointer_cast<SupervisionStateChangeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SupervisionStateChangeStatus >& refNullableStatus = proxy->_supervisionStateChange;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SupervisionStateChangeCallbackIF*) _callback)->onSupervisionStateChangeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SupervisionStateChangeCallbackIF*) _callback)->onSupervisionStateChangeStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcm_dbusctrl_fi::SupervisionStateChangeError);
                                setActAndLogError(message, "SupervisionStateChange", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SupervisionStateChangeCallbackIF*) _callback)->onSupervisionStateChangeError(proxy, ::boost::static_pointer_cast<SupervisionStateChangeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Lcm_dbusctrl_fiProxy> proxy = ::boost::static_pointer_cast<Lcm_dbusctrl_fiProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_StartProcess: {
                ::boost::shared_ptr< StartProcessError > payload (new StartProcessError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartProcess", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((StartProcessCallbackIF*) _callback)->onStartProcessError (proxy, payload);
                return true;
            }
            case FID_StopProcess: {
                ::boost::shared_ptr< StopProcessError > payload (new StopProcessError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StopProcess", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((StopProcessCallbackIF*) _callback)->onStopProcessError (proxy, payload);
                return true;
            }
            case FID_StartupFinished: {
                ::boost::shared_ptr< StartupFinishedError > payload (new StartupFinishedError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartupFinished", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((StartupFinishedCallbackIF*) _callback)->onStartupFinishedError (proxy, payload);
                return true;
            }
            case FID_GetProcessId: {
                ::boost::shared_ptr< GetProcessIdError > payload (new GetProcessIdError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProcessId", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetProcessIdCallbackIF*) _callback)->onGetProcessIdError (proxy, payload);
                return true;
            }
            case FID_TriggerGetUnitList: {
                ::boost::shared_ptr< TriggerGetUnitListError > payload (new TriggerGetUnitListError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "TriggerGetUnitList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((TriggerGetUnitListCallbackIF*) _callback)->onTriggerGetUnitListError (proxy, payload);
                return true;
            }
            case FID_RestartProcess: {
                ::boost::shared_ptr< RestartProcessError > payload (new RestartProcessError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RestartProcess", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((RestartProcessCallbackIF*) _callback)->onRestartProcessError (proxy, payload);
                return true;
            }
            case FID_AppStartRequest: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< AppStartRequestError > payload (new AppStartRequestError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AppStartRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AppStartRequestCallbackIF*) _callback)->onAppStartRequestError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AppInitialized: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< AppInitializedError > payload (new AppInitializedError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AppInitialized", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AppInitializedCallbackIF*) _callback)->onAppInitializedError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AppStateChange: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< AppStateChangeError > payload (new AppStateChangeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AppStateChange", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AppStateChangeCallbackIF*) _callback)->onAppStateChangeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AppEnd: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< AppEndError > payload (new AppEndError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AppEnd", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AppEndCallbackIF*) _callback)->onAppEndError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_NewServiceLoaded: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< NewServiceLoadedError > payload (new NewServiceLoadedError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "NewServiceLoaded", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((NewServiceLoadedCallbackIF*) _callback)->onNewServiceLoadedError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_FailedServicesList: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< FailedServicesListError > payload (new FailedServicesListError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "FailedServicesList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((FailedServicesListCallbackIF*) _callback)->onFailedServicesListError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_NewProcessId: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< NewProcessIdError > payload (new NewProcessIdError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "NewProcessId", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((NewProcessIdCallbackIF*) _callback)->onNewProcessIdError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_StartupFailureIndication: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< StartupFailureIndicationError > payload (new StartupFailureIndicationError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartupFailureIndication", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((StartupFailureIndicationCallbackIF*) _callback)->onStartupFailureIndicationError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SupervisionStateChange: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SupervisionStateChangeError > payload (new SupervisionStateChangeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SupervisionStateChange", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SupervisionStateChangeCallbackIF*) _callback)->onSupervisionStateChangeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Lcm_dbusctrl_fiProxyCallback::_logger (Lcm_dbusctrl_fiProxy::_logger);

/*static*/ ::boost::shared_ptr< Lcm_dbusctrl_fiProxy > Lcm_dbusctrl_fiProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >  proxyNew(new Lcm_dbusctrl_fiProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Lcm_dbusctrl_fiProxy > Lcm_dbusctrl_fiProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >  proxyNew(new Lcm_dbusctrl_fiProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Lcm_dbusctrl_fiProxy > Lcm_dbusctrl_fiProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Lcm_dbusctrl_fiProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >  proxyNew(new Lcm_dbusctrl_fiProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Lcm_dbusctrl_fiProxy::Lcm_dbusctrl_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Lcm_dbusctrl_fiProxy::~Lcm_dbusctrl_fiProxy()
{
    LOG_INFO ("Entering ~Lcm_dbusctrl_fiProxy");
    sendRelUpRegAll ();
}

act_t Lcm_dbusctrl_fiProxy::sendStartProcessStart(StartProcessCallbackIF& cb, const ::std::string& strLocation, uint32 u32Prio, uint32 u32Affinity, uint32 u32AffinityEnd, uint32 u32NiceLevel, uint32 u32NiceLevelEnd, ::lcm_dbusctrl_fi_types::T_e32_LCM_START_PROC_TYPE u32Type, uint32 u32Info) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_StartProcess);
        ::boost::shared_ptr< StartProcessStart > payload (new StartProcessStart());
        payload->setStrLocation(strLocation);
        payload->setU32Prio(u32Prio);
        payload->setU32Affinity(u32Affinity);
        payload->setU32AffinityEnd(u32AffinityEnd);
        payload->setU32NiceLevel(u32NiceLevel);
        payload->setU32NiceLevelEnd(u32NiceLevelEnd);
        payload->setU32Type(u32Type);
        payload->setU32Info(u32Info);
        CCA_MESSAGE(ccaMessage,header,StartProcessStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "StartProcess", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StartProcess);
        ::boost::shared_ptr< StartProcessError > payload (new StartProcessError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StartProcessError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "StartProcess", &cb);
    }
}

act_t Lcm_dbusctrl_fiProxy::sendStopProcessStart(StopProcessCallbackIF& cb, const ::std::string& strLocation, uint32 u32ProcId) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_StopProcess);
        ::boost::shared_ptr< StopProcessStart > payload (new StopProcessStart());
        payload->setStrLocation(strLocation);
        payload->setU32ProcId(u32ProcId);
        CCA_MESSAGE(ccaMessage,header,StopProcessStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "StopProcess", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StopProcess);
        ::boost::shared_ptr< StopProcessError > payload (new StopProcessError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StopProcessError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "StopProcess", &cb);
    }
}

act_t Lcm_dbusctrl_fiProxy::sendStartupFinishedStart(StartupFinishedCallbackIF& cb, ::lcm_dbusctrl_fi_types::T_e32_LCM_STARTUP_TYPE eStartUpParam) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_StartupFinished);
        ::boost::shared_ptr< StartupFinishedStart > payload (new StartupFinishedStart());
        payload->setEStartUpParam(eStartUpParam);
        CCA_MESSAGE(ccaMessage,header,StartupFinishedStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "StartupFinished", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StartupFinished);
        ::boost::shared_ptr< StartupFinishedError > payload (new StartupFinishedError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StartupFinishedError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "StartupFinished", &cb);
    }
}

act_t Lcm_dbusctrl_fiProxy::sendGetProcessIdStart(GetProcessIdCallbackIF& cb, const ::std::string& strServiceName) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GetProcessId);
        ::boost::shared_ptr< GetProcessIdStart > payload (new GetProcessIdStart());
        payload->setStrServiceName(strServiceName);
        CCA_MESSAGE(ccaMessage,header,GetProcessIdStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetProcessId", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GetProcessId);
        ::boost::shared_ptr< GetProcessIdError > payload (new GetProcessIdError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetProcessIdError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetProcessId", &cb);
    }
}

act_t Lcm_dbusctrl_fiProxy::sendTriggerGetUnitListStart(TriggerGetUnitListCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_TriggerGetUnitList);
        ::boost::shared_ptr< TriggerGetUnitListStart > payload (new TriggerGetUnitListStart());
        CCA_MESSAGE(ccaMessage,header,TriggerGetUnitListStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "TriggerGetUnitList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TriggerGetUnitList);
        ::boost::shared_ptr< TriggerGetUnitListError > payload (new TriggerGetUnitListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TriggerGetUnitListError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "TriggerGetUnitList", &cb);
    }
}

act_t Lcm_dbusctrl_fiProxy::sendRestartProcessStart(RestartProcessCallbackIF& cb, const ::std::string& strLocation, uint32 u32ProcId) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_RestartProcess);
        ::boost::shared_ptr< RestartProcessStart > payload (new RestartProcessStart());
        payload->setStrLocation(strLocation);
        payload->setU32ProcId(u32ProcId);
        CCA_MESSAGE(ccaMessage,header,RestartProcessStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "RestartProcess", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RestartProcess);
        ::boost::shared_ptr< RestartProcessError > payload (new RestartProcessError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RestartProcessError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "RestartProcess", &cb);
    }
}

act_t Lcm_dbusctrl_fiProxy::sendAppStartRequestUpReg(AppStartRequestCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AppStartRequest);
        ::boost::shared_ptr< AppStartRequestUpReg > payload (new AppStartRequestUpReg());
        CCA_MESSAGE(ccaMessage,header,AppStartRequestUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AppStartRequestRelUpReg > payloadRelUpRegHeap (new AppStartRequestRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AppStartRequest, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::lcm_dbusctrl_fi::AppStartRequestRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AppStartRequest, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AppStartRequest", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AppStartRequest", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAppStartRequest()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AppStartRequest, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AppStartRequestStatus > payloadLoopback (new AppStartRequestStatus(getAppStartRequest()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AppStartRequestStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AppStartRequest);
        ::boost::shared_ptr< AppStartRequestError > payload (new AppStartRequestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AppStartRequestError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AppStartRequest", &cb);
    }
}

bool Lcm_dbusctrl_fiProxy::sendAppStartRequestRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AppStartRequest,"AppStartRequest");
}

void Lcm_dbusctrl_fiProxy::sendAppStartRequestRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AppStartRequest);
}

const AppStartRequestStatus& Lcm_dbusctrl_fiProxy::getAppStartRequest() const {
    return _appStartRequest.get();
}

bool Lcm_dbusctrl_fiProxy::hasAppStartRequest() const {
    return _appStartRequest.hasValue();
}

act_t Lcm_dbusctrl_fiProxy::sendAppStartRequestGet(AppStartRequestCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_AppStartRequest);
        ::boost::shared_ptr< AppStartRequestGet > payload (new AppStartRequestGet());
        CCA_MESSAGE(ccaMessage,header,AppStartRequestGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "AppStartRequest", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AppStartRequest);
        ::boost::shared_ptr< AppStartRequestError > payload (new AppStartRequestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AppStartRequestError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "AppStartRequest", &cb);
    }
}

act_t Lcm_dbusctrl_fiProxy::sendAppInitializedUpReg(AppInitializedCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AppInitialized);
        ::boost::shared_ptr< AppInitializedUpReg > payload (new AppInitializedUpReg());
        CCA_MESSAGE(ccaMessage,header,AppInitializedUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AppInitializedRelUpReg > payloadRelUpRegHeap (new AppInitializedRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AppInitialized, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::lcm_dbusctrl_fi::AppInitializedRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AppInitialized, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AppInitialized", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AppInitialized", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAppInitialized()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AppInitialized, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AppInitializedStatus > payloadLoopback (new AppInitializedStatus(getAppInitialized()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AppInitializedStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AppInitialized);
        ::boost::shared_ptr< AppInitializedError > payload (new AppInitializedError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AppInitializedError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AppInitialized", &cb);
    }
}

bool Lcm_dbusctrl_fiProxy::sendAppInitializedRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AppInitialized,"AppInitialized");
}

void Lcm_dbusctrl_fiProxy::sendAppInitializedRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AppInitialized);
}

const AppInitializedStatus& Lcm_dbusctrl_fiProxy::getAppInitialized() const {
    return _appInitialized.get();
}

bool Lcm_dbusctrl_fiProxy::hasAppInitialized() const {
    return _appInitialized.hasValue();
}

act_t Lcm_dbusctrl_fiProxy::sendAppInitializedGet(AppInitializedCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_AppInitialized);
        ::boost::shared_ptr< AppInitializedGet > payload (new AppInitializedGet());
        CCA_MESSAGE(ccaMessage,header,AppInitializedGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "AppInitialized", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AppInitialized);
        ::boost::shared_ptr< AppInitializedError > payload (new AppInitializedError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AppInitializedError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "AppInitialized", &cb);
    }
}

act_t Lcm_dbusctrl_fiProxy::sendAppStateChangeUpReg(AppStateChangeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AppStateChange);
        ::boost::shared_ptr< AppStateChangeUpReg > payload (new AppStateChangeUpReg());
        CCA_MESSAGE(ccaMessage,header,AppStateChangeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AppStateChangeRelUpReg > payloadRelUpRegHeap (new AppStateChangeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AppStateChange, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::lcm_dbusctrl_fi::AppStateChangeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AppStateChange, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AppStateChange", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AppStateChange", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAppStateChange()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AppStateChange, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AppStateChangeStatus > payloadLoopback (new AppStateChangeStatus(getAppStateChange()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AppStateChangeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AppStateChange);
        ::boost::shared_ptr< AppStateChangeError > payload (new AppStateChangeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AppStateChangeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AppStateChange", &cb);
    }
}

bool Lcm_dbusctrl_fiProxy::sendAppStateChangeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AppStateChange,"AppStateChange");
}

void Lcm_dbusctrl_fiProxy::sendAppStateChangeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AppStateChange);
}

const AppStateChangeStatus& Lcm_dbusctrl_fiProxy::getAppStateChange() const {
    return _appStateChange.get();
}

bool Lcm_dbusctrl_fiProxy::hasAppStateChange() const {
    return _appStateChange.hasValue();
}

act_t Lcm_dbusctrl_fiProxy::sendAppStateChangeGet(AppStateChangeCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_AppStateChange);
        ::boost::shared_ptr< AppStateChangeGet > payload (new AppStateChangeGet());
        CCA_MESSAGE(ccaMessage,header,AppStateChangeGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "AppStateChange", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AppStateChange);
        ::boost::shared_ptr< AppStateChangeError > payload (new AppStateChangeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AppStateChangeError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "AppStateChange", &cb);
    }
}

act_t Lcm_dbusctrl_fiProxy::sendAppStateChangeSet(AppStateChangeCallbackIF& cb, uint32 u32AppId, uint32 u32State) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_AppStateChange);
        ::boost::shared_ptr< AppStateChangeSet > payload (new AppStateChangeSet());
        payload->setU32AppId(u32AppId);
        payload->setU32State(u32State);
        CCA_MESSAGE(ccaMessage,header,AppStateChangeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "AppStateChange", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AppStateChange);
        ::boost::shared_ptr< AppStateChangeError > payload (new AppStateChangeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AppStateChangeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "AppStateChange", &cb);
    }
}

act_t Lcm_dbusctrl_fiProxy::sendAppEndUpReg(AppEndCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AppEnd);
        ::boost::shared_ptr< AppEndUpReg > payload (new AppEndUpReg());
        CCA_MESSAGE(ccaMessage,header,AppEndUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AppEndRelUpReg > payloadRelUpRegHeap (new AppEndRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AppEnd, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::lcm_dbusctrl_fi::AppEndRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AppEnd, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AppEnd", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AppEnd", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAppEnd()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AppEnd, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AppEndStatus > payloadLoopback (new AppEndStatus(getAppEnd()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AppEndStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AppEnd);
        ::boost::shared_ptr< AppEndError > payload (new AppEndError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AppEndError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AppEnd", &cb);
    }
}

bool Lcm_dbusctrl_fiProxy::sendAppEndRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AppEnd,"AppEnd");
}

void Lcm_dbusctrl_fiProxy::sendAppEndRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AppEnd);
}

const AppEndStatus& Lcm_dbusctrl_fiProxy::getAppEnd() const {
    return _appEnd.get();
}

bool Lcm_dbusctrl_fiProxy::hasAppEnd() const {
    return _appEnd.hasValue();
}

act_t Lcm_dbusctrl_fiProxy::sendAppEndGet(AppEndCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_AppEnd);
        ::boost::shared_ptr< AppEndGet > payload (new AppEndGet());
        CCA_MESSAGE(ccaMessage,header,AppEndGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "AppEnd", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AppEnd);
        ::boost::shared_ptr< AppEndError > payload (new AppEndError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AppEndError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "AppEnd", &cb);
    }
}

act_t Lcm_dbusctrl_fiProxy::sendAppEndSet(AppEndCallbackIF& cb, uint32 u32AppId) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_AppEnd);
        ::boost::shared_ptr< AppEndSet > payload (new AppEndSet());
        payload->setU32AppId(u32AppId);
        CCA_MESSAGE(ccaMessage,header,AppEndSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "AppEnd", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AppEnd);
        ::boost::shared_ptr< AppEndError > payload (new AppEndError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AppEndError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "AppEnd", &cb);
    }
}

act_t Lcm_dbusctrl_fiProxy::sendNewServiceLoadedUpReg(NewServiceLoadedCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_NewServiceLoaded);
        ::boost::shared_ptr< NewServiceLoadedUpReg > payload (new NewServiceLoadedUpReg());
        CCA_MESSAGE(ccaMessage,header,NewServiceLoadedUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< NewServiceLoadedRelUpReg > payloadRelUpRegHeap (new NewServiceLoadedRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_NewServiceLoaded, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::lcm_dbusctrl_fi::NewServiceLoadedRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_NewServiceLoaded, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "NewServiceLoaded", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "NewServiceLoaded", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasNewServiceLoaded()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_NewServiceLoaded, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< NewServiceLoadedStatus > payloadLoopback (new NewServiceLoadedStatus(getNewServiceLoaded()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,NewServiceLoadedStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_NewServiceLoaded);
        ::boost::shared_ptr< NewServiceLoadedError > payload (new NewServiceLoadedError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,NewServiceLoadedError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "NewServiceLoaded", &cb);
    }
}

bool Lcm_dbusctrl_fiProxy::sendNewServiceLoadedRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_NewServiceLoaded,"NewServiceLoaded");
}

void Lcm_dbusctrl_fiProxy::sendNewServiceLoadedRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_NewServiceLoaded);
}

const NewServiceLoadedStatus& Lcm_dbusctrl_fiProxy::getNewServiceLoaded() const {
    return _newServiceLoaded.get();
}

bool Lcm_dbusctrl_fiProxy::hasNewServiceLoaded() const {
    return _newServiceLoaded.hasValue();
}

act_t Lcm_dbusctrl_fiProxy::sendNewServiceLoadedGet(NewServiceLoadedCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_NewServiceLoaded);
        ::boost::shared_ptr< NewServiceLoadedGet > payload (new NewServiceLoadedGet());
        CCA_MESSAGE(ccaMessage,header,NewServiceLoadedGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "NewServiceLoaded", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_NewServiceLoaded);
        ::boost::shared_ptr< NewServiceLoadedError > payload (new NewServiceLoadedError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,NewServiceLoadedError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "NewServiceLoaded", &cb);
    }
}

act_t Lcm_dbusctrl_fiProxy::sendFailedServicesListUpReg(FailedServicesListCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_FailedServicesList);
        ::boost::shared_ptr< FailedServicesListUpReg > payload (new FailedServicesListUpReg());
        CCA_MESSAGE(ccaMessage,header,FailedServicesListUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< FailedServicesListRelUpReg > payloadRelUpRegHeap (new FailedServicesListRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_FailedServicesList, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::lcm_dbusctrl_fi::FailedServicesListRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_FailedServicesList, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "FailedServicesList", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "FailedServicesList", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasFailedServicesList()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_FailedServicesList, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< FailedServicesListStatus > payloadLoopback (new FailedServicesListStatus(getFailedServicesList()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,FailedServicesListStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FailedServicesList);
        ::boost::shared_ptr< FailedServicesListError > payload (new FailedServicesListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FailedServicesListError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "FailedServicesList", &cb);
    }
}

bool Lcm_dbusctrl_fiProxy::sendFailedServicesListRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_FailedServicesList,"FailedServicesList");
}

void Lcm_dbusctrl_fiProxy::sendFailedServicesListRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_FailedServicesList);
}

const FailedServicesListStatus& Lcm_dbusctrl_fiProxy::getFailedServicesList() const {
    return _failedServicesList.get();
}

bool Lcm_dbusctrl_fiProxy::hasFailedServicesList() const {
    return _failedServicesList.hasValue();
}

act_t Lcm_dbusctrl_fiProxy::sendFailedServicesListGet(FailedServicesListCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_FailedServicesList);
        ::boost::shared_ptr< FailedServicesListGet > payload (new FailedServicesListGet());
        CCA_MESSAGE(ccaMessage,header,FailedServicesListGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "FailedServicesList", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FailedServicesList);
        ::boost::shared_ptr< FailedServicesListError > payload (new FailedServicesListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FailedServicesListError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "FailedServicesList", &cb);
    }
}

act_t Lcm_dbusctrl_fiProxy::sendNewProcessIdUpReg(NewProcessIdCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_NewProcessId);
        ::boost::shared_ptr< NewProcessIdUpReg > payload (new NewProcessIdUpReg());
        CCA_MESSAGE(ccaMessage,header,NewProcessIdUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< NewProcessIdRelUpReg > payloadRelUpRegHeap (new NewProcessIdRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_NewProcessId, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::lcm_dbusctrl_fi::NewProcessIdRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_NewProcessId, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "NewProcessId", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "NewProcessId", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasNewProcessId()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_NewProcessId, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< NewProcessIdStatus > payloadLoopback (new NewProcessIdStatus(getNewProcessId()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,NewProcessIdStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_NewProcessId);
        ::boost::shared_ptr< NewProcessIdError > payload (new NewProcessIdError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,NewProcessIdError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "NewProcessId", &cb);
    }
}

bool Lcm_dbusctrl_fiProxy::sendNewProcessIdRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_NewProcessId,"NewProcessId");
}

void Lcm_dbusctrl_fiProxy::sendNewProcessIdRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_NewProcessId);
}

const NewProcessIdStatus& Lcm_dbusctrl_fiProxy::getNewProcessId() const {
    return _newProcessId.get();
}

bool Lcm_dbusctrl_fiProxy::hasNewProcessId() const {
    return _newProcessId.hasValue();
}

act_t Lcm_dbusctrl_fiProxy::sendNewProcessIdGet(NewProcessIdCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_NewProcessId);
        ::boost::shared_ptr< NewProcessIdGet > payload (new NewProcessIdGet());
        CCA_MESSAGE(ccaMessage,header,NewProcessIdGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "NewProcessId", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_NewProcessId);
        ::boost::shared_ptr< NewProcessIdError > payload (new NewProcessIdError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,NewProcessIdError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "NewProcessId", &cb);
    }
}

act_t Lcm_dbusctrl_fiProxy::sendStartupFailureIndicationUpReg(StartupFailureIndicationCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_StartupFailureIndication);
        ::boost::shared_ptr< StartupFailureIndicationUpReg > payload (new StartupFailureIndicationUpReg());
        CCA_MESSAGE(ccaMessage,header,StartupFailureIndicationUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< StartupFailureIndicationRelUpReg > payloadRelUpRegHeap (new StartupFailureIndicationRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_StartupFailureIndication, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::lcm_dbusctrl_fi::StartupFailureIndicationRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_StartupFailureIndication, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "StartupFailureIndication", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "StartupFailureIndication", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasStartupFailureIndication()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_StartupFailureIndication, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< StartupFailureIndicationStatus > payloadLoopback (new StartupFailureIndicationStatus(getStartupFailureIndication()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,StartupFailureIndicationStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StartupFailureIndication);
        ::boost::shared_ptr< StartupFailureIndicationError > payload (new StartupFailureIndicationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StartupFailureIndicationError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "StartupFailureIndication", &cb);
    }
}

bool Lcm_dbusctrl_fiProxy::sendStartupFailureIndicationRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_StartupFailureIndication,"StartupFailureIndication");
}

void Lcm_dbusctrl_fiProxy::sendStartupFailureIndicationRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_StartupFailureIndication);
}

const StartupFailureIndicationStatus& Lcm_dbusctrl_fiProxy::getStartupFailureIndication() const {
    return _startupFailureIndication.get();
}

bool Lcm_dbusctrl_fiProxy::hasStartupFailureIndication() const {
    return _startupFailureIndication.hasValue();
}

act_t Lcm_dbusctrl_fiProxy::sendStartupFailureIndicationGet(StartupFailureIndicationCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_StartupFailureIndication);
        ::boost::shared_ptr< StartupFailureIndicationGet > payload (new StartupFailureIndicationGet());
        CCA_MESSAGE(ccaMessage,header,StartupFailureIndicationGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "StartupFailureIndication", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_StartupFailureIndication);
        ::boost::shared_ptr< StartupFailureIndicationError > payload (new StartupFailureIndicationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,StartupFailureIndicationError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "StartupFailureIndication", &cb);
    }
}

act_t Lcm_dbusctrl_fiProxy::sendSupervisionStateChangeUpReg(SupervisionStateChangeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SupervisionStateChange);
        ::boost::shared_ptr< SupervisionStateChangeUpReg > payload (new SupervisionStateChangeUpReg());
        CCA_MESSAGE(ccaMessage,header,SupervisionStateChangeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SupervisionStateChangeRelUpReg > payloadRelUpRegHeap (new SupervisionStateChangeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SupervisionStateChange, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::lcm_dbusctrl_fi::SupervisionStateChangeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SupervisionStateChange, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SupervisionStateChange", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SupervisionStateChange", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSupervisionStateChange()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SupervisionStateChange, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SupervisionStateChangeStatus > payloadLoopback (new SupervisionStateChangeStatus(getSupervisionStateChange()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SupervisionStateChangeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SupervisionStateChange);
        ::boost::shared_ptr< SupervisionStateChangeError > payload (new SupervisionStateChangeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SupervisionStateChangeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SupervisionStateChange", &cb);
    }
}

bool Lcm_dbusctrl_fiProxy::sendSupervisionStateChangeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SupervisionStateChange,"SupervisionStateChange");
}

void Lcm_dbusctrl_fiProxy::sendSupervisionStateChangeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SupervisionStateChange);
}

const SupervisionStateChangeStatus& Lcm_dbusctrl_fiProxy::getSupervisionStateChange() const {
    return _supervisionStateChange.get();
}

bool Lcm_dbusctrl_fiProxy::hasSupervisionStateChange() const {
    return _supervisionStateChange.hasValue();
}

act_t Lcm_dbusctrl_fiProxy::sendSupervisionStateChangeSet(SupervisionStateChangeCallbackIF& cb, bool bSupervisionActive) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SupervisionStateChange);
        ::boost::shared_ptr< SupervisionStateChangeSet > payload (new SupervisionStateChangeSet());
        payload->setBSupervisionActive(bSupervisionActive);
        CCA_MESSAGE(ccaMessage,header,SupervisionStateChangeSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SupervisionStateChange", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SupervisionStateChange);
        ::boost::shared_ptr< SupervisionStateChangeError > payload (new SupervisionStateChangeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SupervisionStateChangeError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SupervisionStateChange", &cb);
    }
}


void Lcm_dbusctrl_fiProxy::clearAllProperties ()
{
    _appStartRequest = ::asf::core::nullable<AppStartRequestStatus>();
    _appInitialized = ::asf::core::nullable<AppInitializedStatus>();
    _appStateChange = ::asf::core::nullable<AppStateChangeStatus>();
    _appEnd = ::asf::core::nullable<AppEndStatus>();
    _newServiceLoaded = ::asf::core::nullable<NewServiceLoadedStatus>();
    _failedServicesList = ::asf::core::nullable<FailedServicesListStatus>();
    _newProcessId = ::asf::core::nullable<NewProcessIdStatus>();
    _startupFailureIndication = ::asf::core::nullable<StartupFailureIndicationStatus>();
    _supervisionStateChange = ::asf::core::nullable<SupervisionStateChangeStatus>();
}

void Lcm_dbusctrl_fiProxy::sendRelUpRegAll()
{
    sendAppStartRequestRelUpRegAll();
    sendAppInitializedRelUpRegAll();
    sendAppStateChangeRelUpRegAll();
    sendAppEndRelUpRegAll();
    sendNewServiceLoadedRelUpRegAll();
    sendFailedServicesListRelUpRegAll();
    sendNewProcessIdRelUpRegAll();
    sendStartupFailureIndicationRelUpRegAll();
    sendSupervisionStateChangeRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Lcm_dbusctrl_fiProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Lcm_dbusctrl_fiProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace lcm_dbusctrl_fi
