#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef LCM_DBUSCTRL_FI_H
#define LCM_DBUSCTRL_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "lcm_dbusctrl_fi_types.h"
#include "lcm_dbusctrl_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'lcm_dbusctrl_fi'
 *
 * Fullname: LCM Late CCA Service, Application Functional Interface
 *
 * Version: $Revision:   1.1.0  $
 *
 * Author: Klaus-Peter Kollai (kol2hi) CM-AI/PJ-EPB2
 *
 * Date: $Date:  04.03.2015  $
 *
 * Department:
 *
 * Title: dbusctrl_fi
 *
 * <b>Description of 'lcm_dbusctrl_fi':</b>
 *
 * LCM service for ...
 */

namespace lcm_dbusctrl_fi {

static const int SERVICE_ID = 95;

static const int FID_StartProcess = 1;

static const int FID_StopProcess = 2;

static const int FID_StartupFinished = 3;

static const int FID_GetProcessId = 4;

static const int FID_TriggerGetUnitList = 5;

static const int FID_RestartProcess = 6;

static const int FID_AppStartRequest = 4097;

static const int FID_AppInitialized = 4098;

static const int FID_AppStateChange = 4099;

static const int FID_AppEnd = 4100;

static const int FID_NewServiceLoaded = 4101;

static const int FID_FailedServicesList = 4102;

static const int FID_NewProcessId = 4103;

static const int FID_StartupFailureIndication = 4104;

static const int FID_SupervisionStateChange = 4105;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class StartProcessStart;

class StartProcessResult;

class StopProcessStart;

class StopProcessResult;

class StartupFinishedStart;

class StartupFinishedResult;

class GetProcessIdStart;

class RestartProcessStart;

class RestartProcessResult;

class AppStartRequestStatus;

class AppInitializedStatus;

class AppStateChangeStatus;

class AppStateChangeSet;

class AppEndStatus;

class AppEndSet;

class NewServiceLoadedStatus;

class FailedServicesListStatus;

class NewProcessIdStatus;

class StartupFailureIndicationStatus;

class SupervisionStateChangeStatus;

class SupervisionStateChangeSet;

// type definitions
/**
 * The abort error message of the method "StartProcess"
 * Trigger to start a process.
 */
typedef ::asf::cca::CcaTypes::DefaultError StartProcessAbortError;

/**
 * The error message of 'StartProcess'
 */
typedef ::asf::cca::CcaTypes::DefaultError StartProcessError;

/**
 * The abort error message of the method "StopProcess"
 * Trigger to stop a process.
 */
typedef ::asf::cca::CcaTypes::DefaultError StopProcessAbortError;

/**
 * The error message of 'StopProcess'
 */
typedef ::asf::cca::CcaTypes::DefaultError StopProcessError;

/**
 * The abort error message of the method "StartupFinished"
 * Set Startup State.
 */
typedef ::asf::cca::CcaTypes::DefaultError StartupFinishedAbortError;

/**
 * The error message of 'StartupFinished'
 */
typedef ::asf::cca::CcaTypes::DefaultError StartupFinishedError;

/**
 * The result message of the method "GetProcessId"
 * Get the process ID of the main thread started by given service file. The response is only an acknowledge that the request was received.
 * The actual ProcessID is set via property NewProcessId, to have the same handling for spontanously registered services
 */
typedef ::asf::cca::CcaTypes::DefaultMessage GetProcessIdResult;

/**
 * The abort error message of the method "GetProcessId"
 * Get the process ID of the main thread started by given service file. The response is only an acknowledge that the request was received.
 * The actual ProcessID is set via property NewProcessId, to have the same handling for spontanously registered services
 */
typedef ::asf::cca::CcaTypes::DefaultError GetProcessIdAbortError;

/**
 * The error message of 'GetProcessId'
 */
typedef ::asf::cca::CcaTypes::DefaultError GetProcessIdError;

/**
 * The start message of the method "TriggerGetUnitList"
 * Get list of units available in the system.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TriggerGetUnitListStart;

/**
 * The result message of the method "TriggerGetUnitList"
 * Get list of units available in the system.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TriggerGetUnitListResult;

/**
 * The abort error message of the method "TriggerGetUnitList"
 * Get list of units available in the system.
 */
typedef ::asf::cca::CcaTypes::DefaultError TriggerGetUnitListAbortError;

/**
 * The error message of 'TriggerGetUnitList'
 */
typedef ::asf::cca::CcaTypes::DefaultError TriggerGetUnitListError;

/**
 * The abort error message of the method "RestartProcess"
 * Trigger to restart a process.
 */
typedef ::asf::cca::CcaTypes::DefaultError RestartProcessAbortError;

/**
 * The error message of 'RestartProcess'
 */
typedef ::asf::cca::CcaTypes::DefaultError RestartProcessError;

/**
 * The get message of the property "AppStartRequest"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AppStartRequestGet;

/**
 * The upreg message of the property "AppStartRequest"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AppStartRequestUpReg;

/**
 * The relUpReg message of the property "AppStartRequest"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AppStartRequestRelUpReg;

/**
 * The error message of 'AppStartRequest'
 */
typedef ::asf::cca::CcaTypes::DefaultError AppStartRequestError;

/**
 * The get message of the property "AppInitialized"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AppInitializedGet;

/**
 * The upreg message of the property "AppInitialized"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AppInitializedUpReg;

/**
 * The relUpReg message of the property "AppInitialized"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AppInitializedRelUpReg;

/**
 * The error message of 'AppInitialized'
 */
typedef ::asf::cca::CcaTypes::DefaultError AppInitializedError;

/**
 * The get message of the property "AppStateChange"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AppStateChangeGet;

/**
 * The upreg message of the property "AppStateChange"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AppStateChangeUpReg;

/**
 * The relUpReg message of the property "AppStateChange"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AppStateChangeRelUpReg;

/**
 * The error message of 'AppStateChange'
 */
typedef ::asf::cca::CcaTypes::DefaultError AppStateChangeError;

/**
 * The get message of the property "AppEnd"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AppEndGet;

/**
 * The upreg message of the property "AppEnd"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AppEndUpReg;

/**
 * The relUpReg message of the property "AppEnd"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AppEndRelUpReg;

/**
 * The error message of 'AppEnd'
 */
typedef ::asf::cca::CcaTypes::DefaultError AppEndError;

/**
 * The get message of the property "NewServiceLoaded"
 * Indicates that the state of a Service is "loaded" - systemd has called ExecStart of this service
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NewServiceLoadedGet;

/**
 * The upreg message of the property "NewServiceLoaded"
 * Indicates that the state of a Service is "loaded" - systemd has called ExecStart of this service
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NewServiceLoadedUpReg;

/**
 * The relUpReg message of the property "NewServiceLoaded"
 * Indicates that the state of a Service is "loaded" - systemd has called ExecStart of this service
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NewServiceLoadedRelUpReg;

/**
 * The error message of 'NewServiceLoaded'
 */
typedef ::asf::cca::CcaTypes::DefaultError NewServiceLoadedError;

/**
 * The get message of the property "FailedServicesList"
 * Contains a list of all services that are in "failed" state
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FailedServicesListGet;

/**
 * The upreg message of the property "FailedServicesList"
 * Contains a list of all services that are in "failed" state
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FailedServicesListUpReg;

/**
 * The relUpReg message of the property "FailedServicesList"
 * Contains a list of all services that are in "failed" state
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FailedServicesListRelUpReg;

/**
 * The error message of 'FailedServicesList'
 */
typedef ::asf::cca::CcaTypes::DefaultError FailedServicesListError;

/**
 * The get message of the property "NewProcessId"
 * sets a processID for a new systemd service that is registered
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NewProcessIdGet;

/**
 * The upreg message of the property "NewProcessId"
 * sets a processID for a new systemd service that is registered
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NewProcessIdUpReg;

/**
 * The relUpReg message of the property "NewProcessId"
 * sets a processID for a new systemd service that is registered
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NewProcessIdRelUpReg;

/**
 * The error message of 'NewProcessId'
 */
typedef ::asf::cca::CcaTypes::DefaultError NewProcessIdError;

/**
 * The get message of the property "StartupFailureIndication"
 * The information indicates why the StartupController failed
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StartupFailureIndicationGet;

/**
 * The upreg message of the property "StartupFailureIndication"
 * The information indicates why the StartupController failed
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StartupFailureIndicationUpReg;

/**
 * The relUpReg message of the property "StartupFailureIndication"
 * The information indicates why the StartupController failed
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StartupFailureIndicationRelUpReg;

/**
 * The error message of 'StartupFailureIndication'
 */
typedef ::asf::cca::CcaTypes::DefaultError StartupFailureIndicationError;

/**
 * The upreg message of the property "SupervisionStateChange"
 * The status of Supervision from lcmEarly to lcmLate
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SupervisionStateChangeUpReg;

/**
 * The relUpReg message of the property "SupervisionStateChange"
 * The status of Supervision from lcmEarly to lcmLate
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SupervisionStateChangeRelUpReg;

/**
 * The error message of 'SupervisionStateChange'
 */
typedef ::asf::cca::CcaTypes::DefaultError SupervisionStateChangeError;


/**
 * The start message of the method "StartProcess"
 * Trigger to start a process.
 */
class StartProcessStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartProcessStart ();

    /**
     * Copy constructor
     */
    inline  StartProcessStart (const StartProcessStart &rhs);

    /**
     * All fields constructor
     */
    inline  StartProcessStart (const ::std::string& strLocation_, uint32 u32Prio_, uint32 u32Affinity_, uint32 u32AffinityEnd_, uint32 u32NiceLevel_, uint32 u32NiceLevelEnd_, ::lcm_dbusctrl_fi_types::T_e32_LCM_START_PROC_TYPE u32Type_, uint32 u32Info_);

    /**
     * Destructor
     */
    inline virtual  ~StartProcessStart();

    /**
     * Assignment operator
     */
    inline StartProcessStart& operator = (const StartProcessStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartProcessStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartProcessStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartProcessStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartProcessStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strLocation"

    static const int kStrLocation = 0;

    /**
     * Clears the field "strLocation".
     *
     * The field will be set to its default value. The hasStrLocation()
     * method will return false.
     */
    inline void clearStrLocation();

    /**
     * Checks whether the field "strLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrLocation()). Otherwise it will return false.
     */
    inline bool hasStrLocation () const;

    /**
     * Returns the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strLocation"
     */
    inline const ::std::string& getStrLocation () const;

    /**
     * Retrieves the value of the field "strLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strLocation".
     */
    inline ::std::string& getStrLocationMutable ();

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const ::std::string& strLocation_);

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const char* strLocation_);

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const char* value, size_t size);

    // API of field "u32Prio"

    static const int kU32Prio = 1;

    /**
     * Clears the field "u32Prio".
     *
     * The field will be set to its default value. The hasU32Prio()
     * method will return false.
     */
    inline void clearU32Prio();

    /**
     * Checks whether the field "u32Prio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Prio()). Otherwise it will return false.
     */
    inline bool hasU32Prio () const;

    /**
     * Returns the value of the member "u32Prio".
     *
     * If the meaning of "u32Prio" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32Prio"
     */
    inline uint32 getU32Prio () const;

    /**
     * Sets the value of the member "u32Prio".
     *
     * If the meaning of "u32Prio" isn't clear, then there should be a description here.
     *
     * @param u32Prio The value which will be set
     */
    inline void setU32Prio (uint32 u32Prio_);

    // API of field "u32Affinity"

    static const int kU32Affinity = 2;

    /**
     * Clears the field "u32Affinity".
     *
     * The field will be set to its default value. The hasU32Affinity()
     * method will return false.
     */
    inline void clearU32Affinity();

    /**
     * Checks whether the field "u32Affinity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Affinity()). Otherwise it will return false.
     */
    inline bool hasU32Affinity () const;

    /**
     * Returns the value of the member "u32Affinity".
     *
     * If the meaning of "u32Affinity" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32Affinity"
     */
    inline uint32 getU32Affinity () const;

    /**
     * Sets the value of the member "u32Affinity".
     *
     * If the meaning of "u32Affinity" isn't clear, then there should be a description here.
     *
     * @param u32Affinity The value which will be set
     */
    inline void setU32Affinity (uint32 u32Affinity_);

    // API of field "u32AffinityEnd"

    static const int kU32AffinityEnd = 3;

    /**
     * Clears the field "u32AffinityEnd".
     *
     * The field will be set to its default value. The hasU32AffinityEnd()
     * method will return false.
     */
    inline void clearU32AffinityEnd();

    /**
     * Checks whether the field "u32AffinityEnd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32AffinityEnd()). Otherwise it will return false.
     */
    inline bool hasU32AffinityEnd () const;

    /**
     * Returns the value of the member "u32AffinityEnd".
     *
     * If the meaning of "u32AffinityEnd" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32AffinityEnd"
     */
    inline uint32 getU32AffinityEnd () const;

    /**
     * Sets the value of the member "u32AffinityEnd".
     *
     * If the meaning of "u32AffinityEnd" isn't clear, then there should be a description here.
     *
     * @param u32AffinityEnd The value which will be set
     */
    inline void setU32AffinityEnd (uint32 u32AffinityEnd_);

    // API of field "u32NiceLevel"

    static const int kU32NiceLevel = 4;

    /**
     * Clears the field "u32NiceLevel".
     *
     * The field will be set to its default value. The hasU32NiceLevel()
     * method will return false.
     */
    inline void clearU32NiceLevel();

    /**
     * Checks whether the field "u32NiceLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NiceLevel()). Otherwise it will return false.
     */
    inline bool hasU32NiceLevel () const;

    /**
     * Returns the value of the member "u32NiceLevel".
     *
     * If the meaning of "u32NiceLevel" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32NiceLevel"
     */
    inline uint32 getU32NiceLevel () const;

    /**
     * Sets the value of the member "u32NiceLevel".
     *
     * If the meaning of "u32NiceLevel" isn't clear, then there should be a description here.
     *
     * @param u32NiceLevel The value which will be set
     */
    inline void setU32NiceLevel (uint32 u32NiceLevel_);

    // API of field "u32NiceLevelEnd"

    static const int kU32NiceLevelEnd = 5;

    /**
     * Clears the field "u32NiceLevelEnd".
     *
     * The field will be set to its default value. The hasU32NiceLevelEnd()
     * method will return false.
     */
    inline void clearU32NiceLevelEnd();

    /**
     * Checks whether the field "u32NiceLevelEnd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NiceLevelEnd()). Otherwise it will return false.
     */
    inline bool hasU32NiceLevelEnd () const;

    /**
     * Returns the value of the member "u32NiceLevelEnd".
     *
     * If the meaning of "u32NiceLevelEnd" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32NiceLevelEnd"
     */
    inline uint32 getU32NiceLevelEnd () const;

    /**
     * Sets the value of the member "u32NiceLevelEnd".
     *
     * If the meaning of "u32NiceLevelEnd" isn't clear, then there should be a description here.
     *
     * @param u32NiceLevelEnd The value which will be set
     */
    inline void setU32NiceLevelEnd (uint32 u32NiceLevelEnd_);

    // API of field "u32Type"

    static const int kU32Type = 6;

    /**
     * Clears the field "u32Type".
     *
     * The field will be set to its default value. The hasU32Type()
     * method will return false.
     */
    inline void clearU32Type();

    /**
     * Checks whether the field "u32Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Type()). Otherwise it will return false.
     */
    inline bool hasU32Type () const;

    /**
     * Returns the value of the member "u32Type".
     *
     * If the meaning of "u32Type" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32Type"
     */
    inline ::lcm_dbusctrl_fi_types::T_e32_LCM_START_PROC_TYPE getU32Type () const;

    /**
     * Sets the value of the member "u32Type".
     *
     * If the meaning of "u32Type" isn't clear, then there should be a description here.
     *
     * @param u32Type The value which will be set
     */
    inline void setU32Type (::lcm_dbusctrl_fi_types::T_e32_LCM_START_PROC_TYPE u32Type_);

    // API of field "u32Info"

    static const int kU32Info = 7;

    /**
     * Clears the field "u32Info".
     *
     * The field will be set to its default value. The hasU32Info()
     * method will return false.
     */
    inline void clearU32Info();

    /**
     * Checks whether the field "u32Info" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Info()). Otherwise it will return false.
     */
    inline bool hasU32Info () const;

    /**
     * Returns the value of the member "u32Info".
     *
     * If the meaning of "u32Info" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32Info"
     */
    inline uint32 getU32Info () const;

    /**
     * Sets the value of the member "u32Info".
     *
     * If the meaning of "u32Info" isn't clear, then there should be a description here.
     *
     * @param u32Info The value which will be set
     */
    inline void setU32Info (uint32 u32Info_);

    static const StartProcessStart &getDefaultInstance();

private:

    inline void set_has_strLocation ();

    inline void clear_has_strLocation ();

    inline void set_has_u32Prio ();

    inline void clear_has_u32Prio ();

    inline void set_has_u32Affinity ();

    inline void clear_has_u32Affinity ();

    inline void set_has_u32AffinityEnd ();

    inline void clear_has_u32AffinityEnd ();

    inline void set_has_u32NiceLevel ();

    inline void clear_has_u32NiceLevel ();

    inline void set_has_u32NiceLevelEnd ();

    inline void clear_has_u32NiceLevelEnd ();

    inline void set_has_u32Type ();

    inline void clear_has_u32Type ();

    inline void set_has_u32Info ();

    inline void clear_has_u32Info ();

    uint32 _has_bits_[ (8 + 31) / 32];

    ::std::string _strLocation;

    uint32 _u32Prio;

    uint32 _u32Affinity;

    uint32 _u32AffinityEnd;

    uint32 _u32NiceLevel;

    uint32 _u32NiceLevelEnd;

    ::lcm_dbusctrl_fi_types::T_e32_LCM_START_PROC_TYPE _u32Type;

    uint32 _u32Info;

};

/**
 * The result message of the method "StartProcess"
 * Trigger to start a process.
 */
class StartProcessResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartProcessResult ();

    /**
     * Copy constructor
     */
    inline  StartProcessResult (const StartProcessResult &rhs);

    /**
     * All fields constructor
     */
    inline  StartProcessResult (int32 s32ReturnVal_, const ::std::string& strLocation_, uint32 u32ProcId_, uint32 u32SpawnDuration_);

    /**
     * Destructor
     */
    inline virtual  ~StartProcessResult();

    /**
     * Assignment operator
     */
    inline StartProcessResult& operator = (const StartProcessResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartProcessResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartProcessResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartProcessResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartProcessResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ReturnVal"

    static const int kS32ReturnVal = 0;

    /**
     * Clears the field "s32ReturnVal".
     *
     * The field will be set to its default value. The hasS32ReturnVal()
     * method will return false.
     */
    inline void clearS32ReturnVal();

    /**
     * Checks whether the field "s32ReturnVal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ReturnVal()). Otherwise it will return false.
     */
    inline bool hasS32ReturnVal () const;

    /**
     * Returns the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ReturnVal"
     */
    inline int32 getS32ReturnVal () const;

    /**
     * Sets the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @param s32ReturnVal The value which will be set
     */
    inline void setS32ReturnVal (int32 s32ReturnVal_);

    // API of field "strLocation"

    static const int kStrLocation = 1;

    /**
     * Clears the field "strLocation".
     *
     * The field will be set to its default value. The hasStrLocation()
     * method will return false.
     */
    inline void clearStrLocation();

    /**
     * Checks whether the field "strLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrLocation()). Otherwise it will return false.
     */
    inline bool hasStrLocation () const;

    /**
     * Returns the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strLocation"
     */
    inline const ::std::string& getStrLocation () const;

    /**
     * Retrieves the value of the field "strLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strLocation".
     */
    inline ::std::string& getStrLocationMutable ();

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const ::std::string& strLocation_);

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const char* strLocation_);

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const char* value, size_t size);

    // API of field "u32ProcId"

    static const int kU32ProcId = 2;

    /**
     * Clears the field "u32ProcId".
     *
     * The field will be set to its default value. The hasU32ProcId()
     * method will return false.
     */
    inline void clearU32ProcId();

    /**
     * Checks whether the field "u32ProcId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ProcId()). Otherwise it will return false.
     */
    inline bool hasU32ProcId () const;

    /**
     * Returns the value of the member "u32ProcId".
     *
     * If the meaning of "u32ProcId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ProcId"
     */
    inline uint32 getU32ProcId () const;

    /**
     * Sets the value of the member "u32ProcId".
     *
     * If the meaning of "u32ProcId" isn't clear, then there should be a description here.
     *
     * @param u32ProcId The value which will be set
     */
    inline void setU32ProcId (uint32 u32ProcId_);

    // API of field "u32SpawnDuration"

    static const int kU32SpawnDuration = 3;

    /**
     * Clears the field "u32SpawnDuration".
     *
     * The field will be set to its default value. The hasU32SpawnDuration()
     * method will return false.
     */
    inline void clearU32SpawnDuration();

    /**
     * Checks whether the field "u32SpawnDuration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SpawnDuration()). Otherwise it will return false.
     */
    inline bool hasU32SpawnDuration () const;

    /**
     * Returns the value of the member "u32SpawnDuration".
     *
     * If the meaning of "u32SpawnDuration" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32SpawnDuration"
     */
    inline uint32 getU32SpawnDuration () const;

    /**
     * Sets the value of the member "u32SpawnDuration".
     *
     * If the meaning of "u32SpawnDuration" isn't clear, then there should be a description here.
     *
     * @param u32SpawnDuration The value which will be set
     */
    inline void setU32SpawnDuration (uint32 u32SpawnDuration_);

    static const StartProcessResult &getDefaultInstance();

private:

    inline void set_has_s32ReturnVal ();

    inline void clear_has_s32ReturnVal ();

    inline void set_has_strLocation ();

    inline void clear_has_strLocation ();

    inline void set_has_u32ProcId ();

    inline void clear_has_u32ProcId ();

    inline void set_has_u32SpawnDuration ();

    inline void clear_has_u32SpawnDuration ();

    uint32 _has_bits_[ (4 + 31) / 32];

    int32 _s32ReturnVal;

    ::std::string _strLocation;

    uint32 _u32ProcId;

    uint32 _u32SpawnDuration;

};

/**
 * The start message of the method "StopProcess"
 * Trigger to stop a process.
 */
class StopProcessStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StopProcessStart ();

    /**
     * Copy constructor
     */
    inline  StopProcessStart (const StopProcessStart &rhs);

    /**
     * All fields constructor
     */
    inline  StopProcessStart (const ::std::string& strLocation_, uint32 u32ProcId_);

    /**
     * Destructor
     */
    inline virtual  ~StopProcessStart();

    /**
     * Assignment operator
     */
    inline StopProcessStart& operator = (const StopProcessStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopProcessStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopProcessStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopProcessStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopProcessStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strLocation"

    static const int kStrLocation = 0;

    /**
     * Clears the field "strLocation".
     *
     * The field will be set to its default value. The hasStrLocation()
     * method will return false.
     */
    inline void clearStrLocation();

    /**
     * Checks whether the field "strLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrLocation()). Otherwise it will return false.
     */
    inline bool hasStrLocation () const;

    /**
     * Returns the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strLocation"
     */
    inline const ::std::string& getStrLocation () const;

    /**
     * Retrieves the value of the field "strLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strLocation".
     */
    inline ::std::string& getStrLocationMutable ();

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const ::std::string& strLocation_);

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const char* strLocation_);

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const char* value, size_t size);

    // API of field "u32ProcId"

    static const int kU32ProcId = 1;

    /**
     * Clears the field "u32ProcId".
     *
     * The field will be set to its default value. The hasU32ProcId()
     * method will return false.
     */
    inline void clearU32ProcId();

    /**
     * Checks whether the field "u32ProcId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ProcId()). Otherwise it will return false.
     */
    inline bool hasU32ProcId () const;

    /**
     * Returns the value of the member "u32ProcId".
     *
     * If the meaning of "u32ProcId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ProcId"
     */
    inline uint32 getU32ProcId () const;

    /**
     * Sets the value of the member "u32ProcId".
     *
     * If the meaning of "u32ProcId" isn't clear, then there should be a description here.
     *
     * @param u32ProcId The value which will be set
     */
    inline void setU32ProcId (uint32 u32ProcId_);

    static const StopProcessStart &getDefaultInstance();

private:

    inline void set_has_strLocation ();

    inline void clear_has_strLocation ();

    inline void set_has_u32ProcId ();

    inline void clear_has_u32ProcId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _strLocation;

    uint32 _u32ProcId;

};

/**
 * The result message of the method "StopProcess"
 * Trigger to stop a process.
 */
class StopProcessResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StopProcessResult ();

    /**
     * Copy constructor
     */
    inline  StopProcessResult (const StopProcessResult &rhs);

    /**
     * All fields constructor
     */
    inline  StopProcessResult (int32 s32ReturnVal_);

    /**
     * Destructor
     */
    inline virtual  ~StopProcessResult();

    /**
     * Assignment operator
     */
    inline StopProcessResult& operator = (const StopProcessResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopProcessResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopProcessResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopProcessResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopProcessResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ReturnVal"

    static const int kS32ReturnVal = 0;

    /**
     * Clears the field "s32ReturnVal".
     *
     * The field will be set to its default value. The hasS32ReturnVal()
     * method will return false.
     */
    inline void clearS32ReturnVal();

    /**
     * Checks whether the field "s32ReturnVal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ReturnVal()). Otherwise it will return false.
     */
    inline bool hasS32ReturnVal () const;

    /**
     * Returns the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ReturnVal"
     */
    inline int32 getS32ReturnVal () const;

    /**
     * Sets the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @param s32ReturnVal The value which will be set
     */
    inline void setS32ReturnVal (int32 s32ReturnVal_);

    static const StopProcessResult &getDefaultInstance();

private:

    inline void set_has_s32ReturnVal ();

    inline void clear_has_s32ReturnVal ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ReturnVal;

};

/**
 * The start message of the method "StartupFinished"
 * Set Startup State.
 */
class StartupFinishedStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartupFinishedStart ();

    /**
     * Copy constructor
     */
    inline  StartupFinishedStart (const StartupFinishedStart &rhs);

    /**
     * All fields constructor
     */
    inline  StartupFinishedStart (::lcm_dbusctrl_fi_types::T_e32_LCM_STARTUP_TYPE eStartUpParam_);

    /**
     * Destructor
     */
    inline virtual  ~StartupFinishedStart();

    /**
     * Assignment operator
     */
    inline StartupFinishedStart& operator = (const StartupFinishedStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartupFinishedStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartupFinishedStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartupFinishedStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartupFinishedStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "eStartUpParam"

    static const int kEStartUpParam = 0;

    /**
     * Clears the field "eStartUpParam".
     *
     * The field will be set to its default value. The hasEStartUpParam()
     * method will return false.
     */
    inline void clearEStartUpParam();

    /**
     * Checks whether the field "eStartUpParam" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEStartUpParam()). Otherwise it will return false.
     */
    inline bool hasEStartUpParam () const;

    /**
     * Returns the value of the member "eStartUpParam".
     *
     * If the meaning of "eStartUpParam" isn't clear, then there should be a description here.
     *
     * @return The value of the field "eStartUpParam"
     */
    inline ::lcm_dbusctrl_fi_types::T_e32_LCM_STARTUP_TYPE getEStartUpParam () const;

    /**
     * Sets the value of the member "eStartUpParam".
     *
     * If the meaning of "eStartUpParam" isn't clear, then there should be a description here.
     *
     * @param eStartUpParam The value which will be set
     */
    inline void setEStartUpParam (::lcm_dbusctrl_fi_types::T_e32_LCM_STARTUP_TYPE eStartUpParam_);

    static const StartupFinishedStart &getDefaultInstance();

private:

    inline void set_has_eStartUpParam ();

    inline void clear_has_eStartUpParam ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::lcm_dbusctrl_fi_types::T_e32_LCM_STARTUP_TYPE _eStartUpParam;

};

/**
 * The result message of the method "StartupFinished"
 * Set Startup State.
 */
class StartupFinishedResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartupFinishedResult ();

    /**
     * Copy constructor
     */
    inline  StartupFinishedResult (const StartupFinishedResult &rhs);

    /**
     * All fields constructor
     */
    inline  StartupFinishedResult (int32 s32ReturnVal_);

    /**
     * Destructor
     */
    inline virtual  ~StartupFinishedResult();

    /**
     * Assignment operator
     */
    inline StartupFinishedResult& operator = (const StartupFinishedResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartupFinishedResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartupFinishedResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartupFinishedResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartupFinishedResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ReturnVal"

    static const int kS32ReturnVal = 0;

    /**
     * Clears the field "s32ReturnVal".
     *
     * The field will be set to its default value. The hasS32ReturnVal()
     * method will return false.
     */
    inline void clearS32ReturnVal();

    /**
     * Checks whether the field "s32ReturnVal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ReturnVal()). Otherwise it will return false.
     */
    inline bool hasS32ReturnVal () const;

    /**
     * Returns the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ReturnVal"
     */
    inline int32 getS32ReturnVal () const;

    /**
     * Sets the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @param s32ReturnVal The value which will be set
     */
    inline void setS32ReturnVal (int32 s32ReturnVal_);

    static const StartupFinishedResult &getDefaultInstance();

private:

    inline void set_has_s32ReturnVal ();

    inline void clear_has_s32ReturnVal ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ReturnVal;

};

/**
 * The start message of the method "GetProcessId"
 * Get the process ID of the main thread started by given service file. The response is only an acknowledge that the request was received.
 * The actual ProcessID is set via property NewProcessId, to have the same handling for spontanously registered services
 */
class GetProcessIdStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetProcessIdStart ();

    /**
     * Copy constructor
     */
    inline  GetProcessIdStart (const GetProcessIdStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetProcessIdStart (const ::std::string& strServiceName_);

    /**
     * Destructor
     */
    inline virtual  ~GetProcessIdStart();

    /**
     * Assignment operator
     */
    inline GetProcessIdStart& operator = (const GetProcessIdStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetProcessIdStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetProcessIdStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetProcessIdStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetProcessIdStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strServiceName"

    static const int kStrServiceName = 0;

    /**
     * Clears the field "strServiceName".
     *
     * The field will be set to its default value. The hasStrServiceName()
     * method will return false.
     */
    inline void clearStrServiceName();

    /**
     * Checks whether the field "strServiceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrServiceName()). Otherwise it will return false.
     */
    inline bool hasStrServiceName () const;

    /**
     * Returns the value of the member "strServiceName".
     *
     * If the meaning of "strServiceName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strServiceName"
     */
    inline const ::std::string& getStrServiceName () const;

    /**
     * Retrieves the value of the field "strServiceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strServiceName".
     */
    inline ::std::string& getStrServiceNameMutable ();

    /**
     * Sets the value of the member "strServiceName".
     *
     * If the meaning of "strServiceName" isn't clear, then there should be a description here.
     *
     * @param strServiceName The value which will be set
     */
    inline void setStrServiceName (const ::std::string& strServiceName_);

    /**
     * Sets the value of the member "strServiceName".
     *
     * If the meaning of "strServiceName" isn't clear, then there should be a description here.
     *
     * @param strServiceName The value which will be set
     */
    inline void setStrServiceName (const char* strServiceName_);

    /**
     * Sets the value of the member "strServiceName".
     *
     * If the meaning of "strServiceName" isn't clear, then there should be a description here.
     *
     * @param strServiceName The value which will be set
     */
    inline void setStrServiceName (const char* value, size_t size);

    static const GetProcessIdStart &getDefaultInstance();

private:

    inline void set_has_strServiceName ();

    inline void clear_has_strServiceName ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _strServiceName;

};

/**
 * The start message of the method "RestartProcess"
 * Trigger to restart a process.
 */
class RestartProcessStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestartProcessStart ();

    /**
     * Copy constructor
     */
    inline  RestartProcessStart (const RestartProcessStart &rhs);

    /**
     * All fields constructor
     */
    inline  RestartProcessStart (const ::std::string& strLocation_, uint32 u32ProcId_);

    /**
     * Destructor
     */
    inline virtual  ~RestartProcessStart();

    /**
     * Assignment operator
     */
    inline RestartProcessStart& operator = (const RestartProcessStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestartProcessStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestartProcessStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestartProcessStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestartProcessStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strLocation"

    static const int kStrLocation = 0;

    /**
     * Clears the field "strLocation".
     *
     * The field will be set to its default value. The hasStrLocation()
     * method will return false.
     */
    inline void clearStrLocation();

    /**
     * Checks whether the field "strLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrLocation()). Otherwise it will return false.
     */
    inline bool hasStrLocation () const;

    /**
     * Returns the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strLocation"
     */
    inline const ::std::string& getStrLocation () const;

    /**
     * Retrieves the value of the field "strLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strLocation".
     */
    inline ::std::string& getStrLocationMutable ();

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const ::std::string& strLocation_);

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const char* strLocation_);

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const char* value, size_t size);

    // API of field "u32ProcId"

    static const int kU32ProcId = 1;

    /**
     * Clears the field "u32ProcId".
     *
     * The field will be set to its default value. The hasU32ProcId()
     * method will return false.
     */
    inline void clearU32ProcId();

    /**
     * Checks whether the field "u32ProcId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ProcId()). Otherwise it will return false.
     */
    inline bool hasU32ProcId () const;

    /**
     * Returns the value of the member "u32ProcId".
     *
     * If the meaning of "u32ProcId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ProcId"
     */
    inline uint32 getU32ProcId () const;

    /**
     * Sets the value of the member "u32ProcId".
     *
     * If the meaning of "u32ProcId" isn't clear, then there should be a description here.
     *
     * @param u32ProcId The value which will be set
     */
    inline void setU32ProcId (uint32 u32ProcId_);

    static const RestartProcessStart &getDefaultInstance();

private:

    inline void set_has_strLocation ();

    inline void clear_has_strLocation ();

    inline void set_has_u32ProcId ();

    inline void clear_has_u32ProcId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _strLocation;

    uint32 _u32ProcId;

};

/**
 * The result message of the method "RestartProcess"
 * Trigger to restart a process.
 */
class RestartProcessResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestartProcessResult ();

    /**
     * Copy constructor
     */
    inline  RestartProcessResult (const RestartProcessResult &rhs);

    /**
     * All fields constructor
     */
    inline  RestartProcessResult (int32 s32ReturnVal_);

    /**
     * Destructor
     */
    inline virtual  ~RestartProcessResult();

    /**
     * Assignment operator
     */
    inline RestartProcessResult& operator = (const RestartProcessResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestartProcessResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestartProcessResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestartProcessResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestartProcessResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ReturnVal"

    static const int kS32ReturnVal = 0;

    /**
     * Clears the field "s32ReturnVal".
     *
     * The field will be set to its default value. The hasS32ReturnVal()
     * method will return false.
     */
    inline void clearS32ReturnVal();

    /**
     * Checks whether the field "s32ReturnVal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ReturnVal()). Otherwise it will return false.
     */
    inline bool hasS32ReturnVal () const;

    /**
     * Returns the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ReturnVal"
     */
    inline int32 getS32ReturnVal () const;

    /**
     * Sets the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @param s32ReturnVal The value which will be set
     */
    inline void setS32ReturnVal (int32 s32ReturnVal_);

    static const RestartProcessResult &getDefaultInstance();

private:

    inline void set_has_s32ReturnVal ();

    inline void clear_has_s32ReturnVal ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ReturnVal;

};

/**
 * The status message of the property "AppStartRequest"
 */
class AppStartRequestStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AppStartRequestStatus ();

    /**
     * Copy constructor
     */
    inline  AppStartRequestStatus (const AppStartRequestStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AppStartRequestStatus (const ::std::string& strSwBlockName_, const ::std::string& strServiceName_, uint32 u32AppId_);

    /**
     * Destructor
     */
    inline virtual  ~AppStartRequestStatus();

    /**
     * Assignment operator
     */
    inline AppStartRequestStatus& operator = (const AppStartRequestStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AppStartRequestStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AppStartRequestStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AppStartRequestStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AppStartRequestStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strSwBlockName"

    static const int kStrSwBlockName = 0;

    /**
     * Clears the field "strSwBlockName".
     *
     * The field will be set to its default value. The hasStrSwBlockName()
     * method will return false.
     */
    inline void clearStrSwBlockName();

    /**
     * Checks whether the field "strSwBlockName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrSwBlockName()). Otherwise it will return false.
     */
    inline bool hasStrSwBlockName () const;

    /**
     * Returns the value of the member "strSwBlockName".
     *
     * If the meaning of "strSwBlockName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strSwBlockName"
     */
    inline const ::std::string& getStrSwBlockName () const;

    /**
     * Retrieves the value of the field "strSwBlockName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strSwBlockName".
     */
    inline ::std::string& getStrSwBlockNameMutable ();

    /**
     * Sets the value of the member "strSwBlockName".
     *
     * If the meaning of "strSwBlockName" isn't clear, then there should be a description here.
     *
     * @param strSwBlockName The value which will be set
     */
    inline void setStrSwBlockName (const ::std::string& strSwBlockName_);

    /**
     * Sets the value of the member "strSwBlockName".
     *
     * If the meaning of "strSwBlockName" isn't clear, then there should be a description here.
     *
     * @param strSwBlockName The value which will be set
     */
    inline void setStrSwBlockName (const char* strSwBlockName_);

    /**
     * Sets the value of the member "strSwBlockName".
     *
     * If the meaning of "strSwBlockName" isn't clear, then there should be a description here.
     *
     * @param strSwBlockName The value which will be set
     */
    inline void setStrSwBlockName (const char* value, size_t size);

    // API of field "strServiceName"

    static const int kStrServiceName = 1;

    /**
     * Clears the field "strServiceName".
     *
     * The field will be set to its default value. The hasStrServiceName()
     * method will return false.
     */
    inline void clearStrServiceName();

    /**
     * Checks whether the field "strServiceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrServiceName()). Otherwise it will return false.
     */
    inline bool hasStrServiceName () const;

    /**
     * Returns the value of the member "strServiceName".
     *
     * If the meaning of "strServiceName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strServiceName"
     */
    inline const ::std::string& getStrServiceName () const;

    /**
     * Retrieves the value of the field "strServiceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strServiceName".
     */
    inline ::std::string& getStrServiceNameMutable ();

    /**
     * Sets the value of the member "strServiceName".
     *
     * If the meaning of "strServiceName" isn't clear, then there should be a description here.
     *
     * @param strServiceName The value which will be set
     */
    inline void setStrServiceName (const ::std::string& strServiceName_);

    /**
     * Sets the value of the member "strServiceName".
     *
     * If the meaning of "strServiceName" isn't clear, then there should be a description here.
     *
     * @param strServiceName The value which will be set
     */
    inline void setStrServiceName (const char* strServiceName_);

    /**
     * Sets the value of the member "strServiceName".
     *
     * If the meaning of "strServiceName" isn't clear, then there should be a description here.
     *
     * @param strServiceName The value which will be set
     */
    inline void setStrServiceName (const char* value, size_t size);

    // API of field "u32AppId"

    static const int kU32AppId = 2;

    /**
     * Clears the field "u32AppId".
     *
     * The field will be set to its default value. The hasU32AppId()
     * method will return false.
     */
    inline void clearU32AppId();

    /**
     * Checks whether the field "u32AppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32AppId()). Otherwise it will return false.
     */
    inline bool hasU32AppId () const;

    /**
     * Returns the value of the member "u32AppId".
     *
     * If the meaning of "u32AppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32AppId"
     */
    inline uint32 getU32AppId () const;

    /**
     * Sets the value of the member "u32AppId".
     *
     * If the meaning of "u32AppId" isn't clear, then there should be a description here.
     *
     * @param u32AppId The value which will be set
     */
    inline void setU32AppId (uint32 u32AppId_);

    static const AppStartRequestStatus &getDefaultInstance();

private:

    inline void set_has_strSwBlockName ();

    inline void clear_has_strSwBlockName ();

    inline void set_has_strServiceName ();

    inline void clear_has_strServiceName ();

    inline void set_has_u32AppId ();

    inline void clear_has_u32AppId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _strSwBlockName;

    ::std::string _strServiceName;

    uint32 _u32AppId;

};

/**
 * The status message of the property "AppInitialized"
 */
class AppInitializedStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AppInitializedStatus ();

    /**
     * Copy constructor
     */
    inline  AppInitializedStatus (const AppInitializedStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AppInitializedStatus (uint32 u32AppId_);

    /**
     * Destructor
     */
    inline virtual  ~AppInitializedStatus();

    /**
     * Assignment operator
     */
    inline AppInitializedStatus& operator = (const AppInitializedStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AppInitializedStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AppInitializedStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AppInitializedStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AppInitializedStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32AppId"

    static const int kU32AppId = 0;

    /**
     * Clears the field "u32AppId".
     *
     * The field will be set to its default value. The hasU32AppId()
     * method will return false.
     */
    inline void clearU32AppId();

    /**
     * Checks whether the field "u32AppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32AppId()). Otherwise it will return false.
     */
    inline bool hasU32AppId () const;

    /**
     * Returns the value of the member "u32AppId".
     *
     * If the meaning of "u32AppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32AppId"
     */
    inline uint32 getU32AppId () const;

    /**
     * Sets the value of the member "u32AppId".
     *
     * If the meaning of "u32AppId" isn't clear, then there should be a description here.
     *
     * @param u32AppId The value which will be set
     */
    inline void setU32AppId (uint32 u32AppId_);

    static const AppInitializedStatus &getDefaultInstance();

private:

    inline void set_has_u32AppId ();

    inline void clear_has_u32AppId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32AppId;

};

/**
 * The status message of the property "AppStateChange"
 */
class AppStateChangeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AppStateChangeStatus ();

    /**
     * Copy constructor
     */
    inline  AppStateChangeStatus (const AppStateChangeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AppStateChangeStatus (uint32 u32AppId_, uint32 u32State_);

    /**
     * Destructor
     */
    inline virtual  ~AppStateChangeStatus();

    /**
     * Assignment operator
     */
    inline AppStateChangeStatus& operator = (const AppStateChangeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AppStateChangeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AppStateChangeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AppStateChangeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AppStateChangeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32AppId"

    static const int kU32AppId = 0;

    /**
     * Clears the field "u32AppId".
     *
     * The field will be set to its default value. The hasU32AppId()
     * method will return false.
     */
    inline void clearU32AppId();

    /**
     * Checks whether the field "u32AppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32AppId()). Otherwise it will return false.
     */
    inline bool hasU32AppId () const;

    /**
     * Returns the value of the member "u32AppId".
     *
     * If the meaning of "u32AppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32AppId"
     */
    inline uint32 getU32AppId () const;

    /**
     * Sets the value of the member "u32AppId".
     *
     * If the meaning of "u32AppId" isn't clear, then there should be a description here.
     *
     * @param u32AppId The value which will be set
     */
    inline void setU32AppId (uint32 u32AppId_);

    // API of field "u32State"

    static const int kU32State = 1;

    /**
     * Clears the field "u32State".
     *
     * The field will be set to its default value. The hasU32State()
     * method will return false.
     */
    inline void clearU32State();

    /**
     * Checks whether the field "u32State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32State()). Otherwise it will return false.
     */
    inline bool hasU32State () const;

    /**
     * Returns the value of the member "u32State".
     *
     * If the meaning of "u32State" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32State"
     */
    inline uint32 getU32State () const;

    /**
     * Sets the value of the member "u32State".
     *
     * If the meaning of "u32State" isn't clear, then there should be a description here.
     *
     * @param u32State The value which will be set
     */
    inline void setU32State (uint32 u32State_);

    static const AppStateChangeStatus &getDefaultInstance();

private:

    inline void set_has_u32AppId ();

    inline void clear_has_u32AppId ();

    inline void set_has_u32State ();

    inline void clear_has_u32State ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32AppId;

    uint32 _u32State;

};

/**
 * The set message of the property "AppStateChange"
 */
class AppStateChangeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AppStateChangeSet ();

    /**
     * Copy constructor
     */
    inline  AppStateChangeSet (const AppStateChangeSet &rhs);

    /**
     * All fields constructor
     */
    inline  AppStateChangeSet (uint32 u32AppId_, uint32 u32State_);

    /**
     * Destructor
     */
    inline virtual  ~AppStateChangeSet();

    /**
     * Assignment operator
     */
    inline AppStateChangeSet& operator = (const AppStateChangeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AppStateChangeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AppStateChangeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AppStateChangeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AppStateChangeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32AppId"

    static const int kU32AppId = 0;

    /**
     * Clears the field "u32AppId".
     *
     * The field will be set to its default value. The hasU32AppId()
     * method will return false.
     */
    inline void clearU32AppId();

    /**
     * Checks whether the field "u32AppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32AppId()). Otherwise it will return false.
     */
    inline bool hasU32AppId () const;

    /**
     * Returns the value of the member "u32AppId".
     *
     * If the meaning of "u32AppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32AppId"
     */
    inline uint32 getU32AppId () const;

    /**
     * Sets the value of the member "u32AppId".
     *
     * If the meaning of "u32AppId" isn't clear, then there should be a description here.
     *
     * @param u32AppId The value which will be set
     */
    inline void setU32AppId (uint32 u32AppId_);

    // API of field "u32State"

    static const int kU32State = 1;

    /**
     * Clears the field "u32State".
     *
     * The field will be set to its default value. The hasU32State()
     * method will return false.
     */
    inline void clearU32State();

    /**
     * Checks whether the field "u32State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32State()). Otherwise it will return false.
     */
    inline bool hasU32State () const;

    /**
     * Returns the value of the member "u32State".
     *
     * If the meaning of "u32State" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32State"
     */
    inline uint32 getU32State () const;

    /**
     * Sets the value of the member "u32State".
     *
     * If the meaning of "u32State" isn't clear, then there should be a description here.
     *
     * @param u32State The value which will be set
     */
    inline void setU32State (uint32 u32State_);

    static const AppStateChangeSet &getDefaultInstance();

private:

    inline void set_has_u32AppId ();

    inline void clear_has_u32AppId ();

    inline void set_has_u32State ();

    inline void clear_has_u32State ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32AppId;

    uint32 _u32State;

};

/**
 * The status message of the property "AppEnd"
 */
class AppEndStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AppEndStatus ();

    /**
     * Copy constructor
     */
    inline  AppEndStatus (const AppEndStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AppEndStatus (uint32 u32AppId_);

    /**
     * Destructor
     */
    inline virtual  ~AppEndStatus();

    /**
     * Assignment operator
     */
    inline AppEndStatus& operator = (const AppEndStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AppEndStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AppEndStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AppEndStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AppEndStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32AppId"

    static const int kU32AppId = 0;

    /**
     * Clears the field "u32AppId".
     *
     * The field will be set to its default value. The hasU32AppId()
     * method will return false.
     */
    inline void clearU32AppId();

    /**
     * Checks whether the field "u32AppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32AppId()). Otherwise it will return false.
     */
    inline bool hasU32AppId () const;

    /**
     * Returns the value of the member "u32AppId".
     *
     * If the meaning of "u32AppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32AppId"
     */
    inline uint32 getU32AppId () const;

    /**
     * Sets the value of the member "u32AppId".
     *
     * If the meaning of "u32AppId" isn't clear, then there should be a description here.
     *
     * @param u32AppId The value which will be set
     */
    inline void setU32AppId (uint32 u32AppId_);

    static const AppEndStatus &getDefaultInstance();

private:

    inline void set_has_u32AppId ();

    inline void clear_has_u32AppId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32AppId;

};

/**
 * The set message of the property "AppEnd"
 */
class AppEndSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AppEndSet ();

    /**
     * Copy constructor
     */
    inline  AppEndSet (const AppEndSet &rhs);

    /**
     * All fields constructor
     */
    inline  AppEndSet (uint32 u32AppId_);

    /**
     * Destructor
     */
    inline virtual  ~AppEndSet();

    /**
     * Assignment operator
     */
    inline AppEndSet& operator = (const AppEndSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AppEndSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AppEndSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AppEndSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AppEndSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32AppId"

    static const int kU32AppId = 0;

    /**
     * Clears the field "u32AppId".
     *
     * The field will be set to its default value. The hasU32AppId()
     * method will return false.
     */
    inline void clearU32AppId();

    /**
     * Checks whether the field "u32AppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32AppId()). Otherwise it will return false.
     */
    inline bool hasU32AppId () const;

    /**
     * Returns the value of the member "u32AppId".
     *
     * If the meaning of "u32AppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32AppId"
     */
    inline uint32 getU32AppId () const;

    /**
     * Sets the value of the member "u32AppId".
     *
     * If the meaning of "u32AppId" isn't clear, then there should be a description here.
     *
     * @param u32AppId The value which will be set
     */
    inline void setU32AppId (uint32 u32AppId_);

    static const AppEndSet &getDefaultInstance();

private:

    inline void set_has_u32AppId ();

    inline void clear_has_u32AppId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32AppId;

};

/**
 * The status message of the property "NewServiceLoaded"
 * Indicates that the state of a Service is "loaded" - systemd has called ExecStart of this service
 */
class NewServiceLoadedStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NewServiceLoadedStatus ();

    /**
     * Copy constructor
     */
    inline  NewServiceLoadedStatus (const NewServiceLoadedStatus &rhs);

    /**
     * All fields constructor
     */
    inline  NewServiceLoadedStatus (const ::std::string& strServiceName_, const ::std::string& strBlockName_, uint32 u32AppId_);

    /**
     * Destructor
     */
    inline virtual  ~NewServiceLoadedStatus();

    /**
     * Assignment operator
     */
    inline NewServiceLoadedStatus& operator = (const NewServiceLoadedStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NewServiceLoadedStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NewServiceLoadedStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NewServiceLoadedStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NewServiceLoadedStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strServiceName"

    static const int kStrServiceName = 0;

    /**
     * Clears the field "strServiceName".
     *
     * The field will be set to its default value. The hasStrServiceName()
     * method will return false.
     */
    inline void clearStrServiceName();

    /**
     * Checks whether the field "strServiceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrServiceName()). Otherwise it will return false.
     */
    inline bool hasStrServiceName () const;

    /**
     * Returns the value of the member "strServiceName".
     *
     * If the meaning of "strServiceName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strServiceName"
     */
    inline const ::std::string& getStrServiceName () const;

    /**
     * Retrieves the value of the field "strServiceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strServiceName".
     */
    inline ::std::string& getStrServiceNameMutable ();

    /**
     * Sets the value of the member "strServiceName".
     *
     * If the meaning of "strServiceName" isn't clear, then there should be a description here.
     *
     * @param strServiceName The value which will be set
     */
    inline void setStrServiceName (const ::std::string& strServiceName_);

    /**
     * Sets the value of the member "strServiceName".
     *
     * If the meaning of "strServiceName" isn't clear, then there should be a description here.
     *
     * @param strServiceName The value which will be set
     */
    inline void setStrServiceName (const char* strServiceName_);

    /**
     * Sets the value of the member "strServiceName".
     *
     * If the meaning of "strServiceName" isn't clear, then there should be a description here.
     *
     * @param strServiceName The value which will be set
     */
    inline void setStrServiceName (const char* value, size_t size);

    // API of field "strBlockName"

    static const int kStrBlockName = 1;

    /**
     * Clears the field "strBlockName".
     *
     * The field will be set to its default value. The hasStrBlockName()
     * method will return false.
     */
    inline void clearStrBlockName();

    /**
     * Checks whether the field "strBlockName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrBlockName()). Otherwise it will return false.
     */
    inline bool hasStrBlockName () const;

    /**
     * Returns the value of the member "strBlockName".
     *
     * If the meaning of "strBlockName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strBlockName"
     */
    inline const ::std::string& getStrBlockName () const;

    /**
     * Retrieves the value of the field "strBlockName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strBlockName".
     */
    inline ::std::string& getStrBlockNameMutable ();

    /**
     * Sets the value of the member "strBlockName".
     *
     * If the meaning of "strBlockName" isn't clear, then there should be a description here.
     *
     * @param strBlockName The value which will be set
     */
    inline void setStrBlockName (const ::std::string& strBlockName_);

    /**
     * Sets the value of the member "strBlockName".
     *
     * If the meaning of "strBlockName" isn't clear, then there should be a description here.
     *
     * @param strBlockName The value which will be set
     */
    inline void setStrBlockName (const char* strBlockName_);

    /**
     * Sets the value of the member "strBlockName".
     *
     * If the meaning of "strBlockName" isn't clear, then there should be a description here.
     *
     * @param strBlockName The value which will be set
     */
    inline void setStrBlockName (const char* value, size_t size);

    // API of field "u32AppId"

    static const int kU32AppId = 2;

    /**
     * Clears the field "u32AppId".
     *
     * The field will be set to its default value. The hasU32AppId()
     * method will return false.
     */
    inline void clearU32AppId();

    /**
     * Checks whether the field "u32AppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32AppId()). Otherwise it will return false.
     */
    inline bool hasU32AppId () const;

    /**
     * Returns the value of the member "u32AppId".
     *
     * If the meaning of "u32AppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32AppId"
     */
    inline uint32 getU32AppId () const;

    /**
     * Sets the value of the member "u32AppId".
     *
     * If the meaning of "u32AppId" isn't clear, then there should be a description here.
     *
     * @param u32AppId The value which will be set
     */
    inline void setU32AppId (uint32 u32AppId_);

    static const NewServiceLoadedStatus &getDefaultInstance();

private:

    inline void set_has_strServiceName ();

    inline void clear_has_strServiceName ();

    inline void set_has_strBlockName ();

    inline void clear_has_strBlockName ();

    inline void set_has_u32AppId ();

    inline void clear_has_u32AppId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _strServiceName;

    ::std::string _strBlockName;

    uint32 _u32AppId;

};

/**
 * The status message of the property "FailedServicesList"
 * Contains a list of all services that are in "failed" state
 */
class FailedServicesListStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FailedServicesListStatus ();

    /**
     * Copy constructor
     */
    inline  FailedServicesListStatus (const FailedServicesListStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FailedServicesListStatus (const ::lcm_dbusctrl_fi_types::T_SPM_ServiceList& tServices_);

    /**
     * Destructor
     */
    inline virtual  ~FailedServicesListStatus();

    /**
     * Assignment operator
     */
    inline FailedServicesListStatus& operator = (const FailedServicesListStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FailedServicesListStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FailedServicesListStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FailedServicesListStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FailedServicesListStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tServices"

    static const int kTServices = 0;

    /**
     * Clears the field "tServices".
     *
     * The field will be set to its default value. The hasTServices()
     * method will return false.
     */
    inline void clearTServices();

    /**
     * Checks whether the field "tServices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTServices()). Otherwise it will return false.
     */
    inline bool hasTServices () const;

    /**
     * Returns the value of the member "tServices".
     *
     * List of all services in failed state.
     *
     * @return The value of the field "tServices"
     */
    inline const ::lcm_dbusctrl_fi_types::T_SPM_ServiceList& getTServices () const;

    /**
     * Retrieves the value of the field "tServices" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tServices".
     */
    inline ::lcm_dbusctrl_fi_types::T_SPM_ServiceList& getTServicesMutable ();

    /**
     * Sets the value of the member "tServices".
     *
     * List of all services in failed state.
     *
     * @param tServices The value which will be set
     */
    inline void setTServices (const ::lcm_dbusctrl_fi_types::T_SPM_ServiceList& tServices_);

    static const FailedServicesListStatus &getDefaultInstance();

private:

    static const ::std::vector< ::lcm_dbusctrl_fi_types::T_ServiceElement >& getT_ServiceElementList_DefaultInstance ();

    inline void set_has_tServices ();

    inline void clear_has_tServices ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::lcm_dbusctrl_fi_types::T_SPM_ServiceList _tServices;

};

/**
 * The status message of the property "NewProcessId"
 * sets a processID for a new systemd service that is registered
 */
class NewProcessIdStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NewProcessIdStatus ();

    /**
     * Copy constructor
     */
    inline  NewProcessIdStatus (const NewProcessIdStatus &rhs);

    /**
     * All fields constructor
     */
    inline  NewProcessIdStatus (const ::std::string& strBlockName_, const ::std::string& strServiceName_, uint32 u32ProcessId_);

    /**
     * Destructor
     */
    inline virtual  ~NewProcessIdStatus();

    /**
     * Assignment operator
     */
    inline NewProcessIdStatus& operator = (const NewProcessIdStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NewProcessIdStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NewProcessIdStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NewProcessIdStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NewProcessIdStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strBlockName"

    static const int kStrBlockName = 0;

    /**
     * Clears the field "strBlockName".
     *
     * The field will be set to its default value. The hasStrBlockName()
     * method will return false.
     */
    inline void clearStrBlockName();

    /**
     * Checks whether the field "strBlockName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrBlockName()). Otherwise it will return false.
     */
    inline bool hasStrBlockName () const;

    /**
     * Returns the value of the member "strBlockName".
     *
     * If the meaning of "strBlockName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strBlockName"
     */
    inline const ::std::string& getStrBlockName () const;

    /**
     * Retrieves the value of the field "strBlockName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strBlockName".
     */
    inline ::std::string& getStrBlockNameMutable ();

    /**
     * Sets the value of the member "strBlockName".
     *
     * If the meaning of "strBlockName" isn't clear, then there should be a description here.
     *
     * @param strBlockName The value which will be set
     */
    inline void setStrBlockName (const ::std::string& strBlockName_);

    /**
     * Sets the value of the member "strBlockName".
     *
     * If the meaning of "strBlockName" isn't clear, then there should be a description here.
     *
     * @param strBlockName The value which will be set
     */
    inline void setStrBlockName (const char* strBlockName_);

    /**
     * Sets the value of the member "strBlockName".
     *
     * If the meaning of "strBlockName" isn't clear, then there should be a description here.
     *
     * @param strBlockName The value which will be set
     */
    inline void setStrBlockName (const char* value, size_t size);

    // API of field "strServiceName"

    static const int kStrServiceName = 1;

    /**
     * Clears the field "strServiceName".
     *
     * The field will be set to its default value. The hasStrServiceName()
     * method will return false.
     */
    inline void clearStrServiceName();

    /**
     * Checks whether the field "strServiceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrServiceName()). Otherwise it will return false.
     */
    inline bool hasStrServiceName () const;

    /**
     * Returns the value of the member "strServiceName".
     *
     * If the meaning of "strServiceName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strServiceName"
     */
    inline const ::std::string& getStrServiceName () const;

    /**
     * Retrieves the value of the field "strServiceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strServiceName".
     */
    inline ::std::string& getStrServiceNameMutable ();

    /**
     * Sets the value of the member "strServiceName".
     *
     * If the meaning of "strServiceName" isn't clear, then there should be a description here.
     *
     * @param strServiceName The value which will be set
     */
    inline void setStrServiceName (const ::std::string& strServiceName_);

    /**
     * Sets the value of the member "strServiceName".
     *
     * If the meaning of "strServiceName" isn't clear, then there should be a description here.
     *
     * @param strServiceName The value which will be set
     */
    inline void setStrServiceName (const char* strServiceName_);

    /**
     * Sets the value of the member "strServiceName".
     *
     * If the meaning of "strServiceName" isn't clear, then there should be a description here.
     *
     * @param strServiceName The value which will be set
     */
    inline void setStrServiceName (const char* value, size_t size);

    // API of field "u32ProcessId"

    static const int kU32ProcessId = 2;

    /**
     * Clears the field "u32ProcessId".
     *
     * The field will be set to its default value. The hasU32ProcessId()
     * method will return false.
     */
    inline void clearU32ProcessId();

    /**
     * Checks whether the field "u32ProcessId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ProcessId()). Otherwise it will return false.
     */
    inline bool hasU32ProcessId () const;

    /**
     * Returns the value of the member "u32ProcessId".
     *
     * If the meaning of "u32ProcessId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ProcessId"
     */
    inline uint32 getU32ProcessId () const;

    /**
     * Sets the value of the member "u32ProcessId".
     *
     * If the meaning of "u32ProcessId" isn't clear, then there should be a description here.
     *
     * @param u32ProcessId The value which will be set
     */
    inline void setU32ProcessId (uint32 u32ProcessId_);

    static const NewProcessIdStatus &getDefaultInstance();

private:

    inline void set_has_strBlockName ();

    inline void clear_has_strBlockName ();

    inline void set_has_strServiceName ();

    inline void clear_has_strServiceName ();

    inline void set_has_u32ProcessId ();

    inline void clear_has_u32ProcessId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _strBlockName;

    ::std::string _strServiceName;

    uint32 _u32ProcessId;

};

/**
 * The status message of the property "StartupFailureIndication"
 * The information indicates why the StartupController failed
 */
class StartupFailureIndicationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartupFailureIndicationStatus ();

    /**
     * Copy constructor
     */
    inline  StartupFailureIndicationStatus (const StartupFailureIndicationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  StartupFailureIndicationStatus (const ::lcm_dbusctrl_fi_types::T_StartupFailureInfo& tStartupFailureInd_);

    /**
     * Destructor
     */
    inline virtual  ~StartupFailureIndicationStatus();

    /**
     * Assignment operator
     */
    inline StartupFailureIndicationStatus& operator = (const StartupFailureIndicationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartupFailureIndicationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartupFailureIndicationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartupFailureIndicationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartupFailureIndicationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tStartupFailureInd"

    static const int kTStartupFailureInd = 0;

    /**
     * Clears the field "tStartupFailureInd".
     *
     * The field will be set to its default value. The hasTStartupFailureInd()
     * method will return false.
     */
    inline void clearTStartupFailureInd();

    /**
     * Checks whether the field "tStartupFailureInd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTStartupFailureInd()). Otherwise it will return false.
     */
    inline bool hasTStartupFailureInd () const;

    /**
     * Returns the value of the member "tStartupFailureInd".
     *
     * If the meaning of "tStartupFailureInd" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tStartupFailureInd"
     */
    inline const ::lcm_dbusctrl_fi_types::T_StartupFailureInfo& getTStartupFailureInd () const;

    /**
     * Retrieves the value of the field "tStartupFailureInd" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tStartupFailureInd".
     */
    inline ::lcm_dbusctrl_fi_types::T_StartupFailureInfo& getTStartupFailureIndMutable ();

    /**
     * Sets the value of the member "tStartupFailureInd".
     *
     * If the meaning of "tStartupFailureInd" isn't clear, then there should be a description here.
     *
     * @param tStartupFailureInd The value which will be set
     */
    inline void setTStartupFailureInd (const ::lcm_dbusctrl_fi_types::T_StartupFailureInfo& tStartupFailureInd_);

    static const StartupFailureIndicationStatus &getDefaultInstance();

private:

    inline void set_has_tStartupFailureInd ();

    inline void clear_has_tStartupFailureInd ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::lcm_dbusctrl_fi_types::T_StartupFailureInfo _tStartupFailureInd;

};

/**
 * The status message of the property "SupervisionStateChange"
 * The status of Supervision from lcmEarly to lcmLate
 */
class SupervisionStateChangeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SupervisionStateChangeStatus ();

    /**
     * Copy constructor
     */
    inline  SupervisionStateChangeStatus (const SupervisionStateChangeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SupervisionStateChangeStatus (bool bSupervisionActive_);

    /**
     * Destructor
     */
    inline virtual  ~SupervisionStateChangeStatus();

    /**
     * Assignment operator
     */
    inline SupervisionStateChangeStatus& operator = (const SupervisionStateChangeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SupervisionStateChangeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SupervisionStateChangeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SupervisionStateChangeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SupervisionStateChangeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bSupervisionActive"

    static const int kBSupervisionActive = 0;

    /**
     * Clears the field "bSupervisionActive".
     *
     * The field will be set to its default value. The hasBSupervisionActive()
     * method will return false.
     */
    inline void clearBSupervisionActive();

    /**
     * Checks whether the field "bSupervisionActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSupervisionActive()). Otherwise it will return false.
     */
    inline bool hasBSupervisionActive () const;

    /**
     * Returns the value of the member "bSupervisionActive".
     *
     * If the meaning of "bSupervisionActive" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bSupervisionActive"
     */
    inline bool getBSupervisionActive () const;

    /**
     * Sets the value of the member "bSupervisionActive".
     *
     * If the meaning of "bSupervisionActive" isn't clear, then there should be a description here.
     *
     * @param bSupervisionActive The value which will be set
     */
    inline void setBSupervisionActive (bool bSupervisionActive_);

    static const SupervisionStateChangeStatus &getDefaultInstance();

private:

    inline void set_has_bSupervisionActive ();

    inline void clear_has_bSupervisionActive ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bSupervisionActive;

};

/**
 * The set message of the property "SupervisionStateChange"
 * The status of Supervision from lcmEarly to lcmLate
 */
class SupervisionStateChangeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SupervisionStateChangeSet ();

    /**
     * Copy constructor
     */
    inline  SupervisionStateChangeSet (const SupervisionStateChangeSet &rhs);

    /**
     * All fields constructor
     */
    inline  SupervisionStateChangeSet (bool bSupervisionActive_);

    /**
     * Destructor
     */
    inline virtual  ~SupervisionStateChangeSet();

    /**
     * Assignment operator
     */
    inline SupervisionStateChangeSet& operator = (const SupervisionStateChangeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SupervisionStateChangeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SupervisionStateChangeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SupervisionStateChangeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SupervisionStateChangeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bSupervisionActive"

    static const int kBSupervisionActive = 0;

    /**
     * Clears the field "bSupervisionActive".
     *
     * The field will be set to its default value. The hasBSupervisionActive()
     * method will return false.
     */
    inline void clearBSupervisionActive();

    /**
     * Checks whether the field "bSupervisionActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSupervisionActive()). Otherwise it will return false.
     */
    inline bool hasBSupervisionActive () const;

    /**
     * Returns the value of the member "bSupervisionActive".
     *
     * If the meaning of "bSupervisionActive" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bSupervisionActive"
     */
    inline bool getBSupervisionActive () const;

    /**
     * Sets the value of the member "bSupervisionActive".
     *
     * If the meaning of "bSupervisionActive" isn't clear, then there should be a description here.
     *
     * @param bSupervisionActive The value which will be set
     */
    inline void setBSupervisionActive (bool bSupervisionActive_);

    static const SupervisionStateChangeSet &getDefaultInstance();

private:

    inline void set_has_bSupervisionActive ();

    inline void clear_has_bSupervisionActive ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bSupervisionActive;

};

inline  StartProcessStart::StartProcessStart ()  :
    _strLocation (),
    _u32Prio (0u),
    _u32Affinity (0u),
    _u32AffinityEnd (0u),
    _u32NiceLevel (0u),
    _u32NiceLevelEnd (0u),
    _u32Type (::lcm_dbusctrl_fi_types::T_e32_LCM_START_PROC_TYPE__SPM_U32_START_PROC_TYPE_OSAL_SPAWN),
    _u32Info (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartProcessStart::StartProcessStart (const StartProcessStart &rhs)  :
    ::asf::core::Payload(rhs),
    _strLocation (),
    _u32Prio (0u),
    _u32Affinity (0u),
    _u32AffinityEnd (0u),
    _u32NiceLevel (0u),
    _u32NiceLevelEnd (0u),
    _u32Type (::lcm_dbusctrl_fi_types::T_e32_LCM_START_PROC_TYPE__SPM_U32_START_PROC_TYPE_OSAL_SPAWN),
    _u32Info (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartProcessStart::StartProcessStart (const ::std::string& strLocation_, uint32 u32Prio_, uint32 u32Affinity_, uint32 u32AffinityEnd_, uint32 u32NiceLevel_, uint32 u32NiceLevelEnd_, ::lcm_dbusctrl_fi_types::T_e32_LCM_START_PROC_TYPE u32Type_, uint32 u32Info_)  :
    _strLocation (strLocation_),
    _u32Prio (u32Prio_),
    _u32Affinity (u32Affinity_),
    _u32AffinityEnd (u32AffinityEnd_),
    _u32NiceLevel (u32NiceLevel_),
    _u32NiceLevelEnd (u32NiceLevelEnd_),
    _u32Type (u32Type_),
    _u32Info (u32Info_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLocation_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::lcm_dbusctrl_fi_types::T_e32_LCM_START_PROC_TYPE_IsValid(u32Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u32Type_, "T_e32_LCM_START_PROC_TYPE", "u32Type", "StartProcessStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartProcessStart::~StartProcessStart() {
}

inline StartProcessStart& StartProcessStart::operator = (const StartProcessStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStrLocation()) {
            setStrLocation(rhs.getStrLocation());
        } else {
            clearStrLocation();
        }
        if (rhs.hasU32Prio()) {
            setU32Prio(rhs.getU32Prio());
        } else {
            clearU32Prio();
        }
        if (rhs.hasU32Affinity()) {
            setU32Affinity(rhs.getU32Affinity());
        } else {
            clearU32Affinity();
        }
        if (rhs.hasU32AffinityEnd()) {
            setU32AffinityEnd(rhs.getU32AffinityEnd());
        } else {
            clearU32AffinityEnd();
        }
        if (rhs.hasU32NiceLevel()) {
            setU32NiceLevel(rhs.getU32NiceLevel());
        } else {
            clearU32NiceLevel();
        }
        if (rhs.hasU32NiceLevelEnd()) {
            setU32NiceLevelEnd(rhs.getU32NiceLevelEnd());
        } else {
            clearU32NiceLevelEnd();
        }
        if (rhs.hasU32Type()) {
            setU32Type(rhs.getU32Type());
        } else {
            clearU32Type();
        }
        if (rhs.hasU32Info()) {
            setU32Info(rhs.getU32Info());
        } else {
            clearU32Info();
        }
    }
    return *this;
}

inline bool StartProcessStart::operator == (const StartProcessStart& rhs) const {
    return (((!hasStrLocation() && !rhs.hasStrLocation()) || getStrLocation() == rhs.getStrLocation()) &&
        ((!hasU32Prio() && !rhs.hasU32Prio()) || getU32Prio() == rhs.getU32Prio()) &&
        ((!hasU32Affinity() && !rhs.hasU32Affinity()) || getU32Affinity() == rhs.getU32Affinity()) &&
        ((!hasU32AffinityEnd() && !rhs.hasU32AffinityEnd()) || getU32AffinityEnd() == rhs.getU32AffinityEnd()) &&
        ((!hasU32NiceLevel() && !rhs.hasU32NiceLevel()) || getU32NiceLevel() == rhs.getU32NiceLevel()) &&
        ((!hasU32NiceLevelEnd() && !rhs.hasU32NiceLevelEnd()) || getU32NiceLevelEnd() == rhs.getU32NiceLevelEnd()) &&
        ((!hasU32Type() && !rhs.hasU32Type()) || getU32Type() == rhs.getU32Type()) &&
        ((!hasU32Info() && !rhs.hasU32Info()) || getU32Info() == rhs.getU32Info()));
}

inline bool StartProcessStart::operator != (const StartProcessStart& rhs) const {
    return ! (*this == rhs);
}

inline bool StartProcessStart::operator < (const StartProcessStart& rhs) const {
    if (hasStrLocation() || rhs.hasStrLocation()) {
        if (getStrLocation() < rhs.getStrLocation()) return true;
        if (getStrLocation() > rhs.getStrLocation()) return false;
    }
    if (hasU32Prio() || rhs.hasU32Prio()) {
        if (getU32Prio() < rhs.getU32Prio()) return true;
        if (getU32Prio() > rhs.getU32Prio()) return false;
    }
    if (hasU32Affinity() || rhs.hasU32Affinity()) {
        if (getU32Affinity() < rhs.getU32Affinity()) return true;
        if (getU32Affinity() > rhs.getU32Affinity()) return false;
    }
    if (hasU32AffinityEnd() || rhs.hasU32AffinityEnd()) {
        if (getU32AffinityEnd() < rhs.getU32AffinityEnd()) return true;
        if (getU32AffinityEnd() > rhs.getU32AffinityEnd()) return false;
    }
    if (hasU32NiceLevel() || rhs.hasU32NiceLevel()) {
        if (getU32NiceLevel() < rhs.getU32NiceLevel()) return true;
        if (getU32NiceLevel() > rhs.getU32NiceLevel()) return false;
    }
    if (hasU32NiceLevelEnd() || rhs.hasU32NiceLevelEnd()) {
        if (getU32NiceLevelEnd() < rhs.getU32NiceLevelEnd()) return true;
        if (getU32NiceLevelEnd() > rhs.getU32NiceLevelEnd()) return false;
    }
    if (hasU32Type() || rhs.hasU32Type()) {
        if ((uint32)getU32Type() < (uint32)rhs.getU32Type()) return true;
        if ((uint32)getU32Type() > (uint32)rhs.getU32Type()) return false;
    }
    if (hasU32Info() || rhs.hasU32Info()) {
        if (getU32Info() < rhs.getU32Info()) return true;
        if (getU32Info() > rhs.getU32Info()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartProcessStart::clone() {
    return new StartProcessStart(*this);
}

inline bool StartProcessStart::operator > (const StartProcessStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartProcessStart::clear() {
    clearStrLocation();
    clearU32Prio();
    clearU32Affinity();
    clearU32AffinityEnd();
    clearU32NiceLevel();
    clearU32NiceLevelEnd();
    clearU32Type();
    clearU32Info();
}

inline void StartProcessStart::clearStrLocation() {
    if (hasStrLocation()) {
         clear_has_strLocation();
        _strLocation.clear();
     }
}

inline bool StartProcessStart::hasStrLocation () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StartProcessStart::getStrLocation () const {
    return _strLocation;
}

inline ::std::string& StartProcessStart::getStrLocationMutable () {
    set_has_strLocation();
    return _strLocation;
}

inline void StartProcessStart::setStrLocation (const ::std::string& strLocation_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLocation_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLocation();
    this->_strLocation = strLocation_;
}

inline void StartProcessStart::setStrLocation (const char* strLocation_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLocation_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLocation();
    this->_strLocation.assign(strLocation_);
}

inline void StartProcessStart::setStrLocation (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLocation();
    this->_strLocation.assign(value, size);
}

inline void StartProcessStart::clearU32Prio() {
    if (hasU32Prio()) {
         clear_has_u32Prio();
        _u32Prio = 0u;
     }
}

inline bool StartProcessStart::hasU32Prio () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 StartProcessStart::getU32Prio () const {
    return _u32Prio;
}

inline void StartProcessStart::setU32Prio (uint32 u32Prio_) {
    set_has_u32Prio();
    this->_u32Prio = u32Prio_;
}

inline void StartProcessStart::clearU32Affinity() {
    if (hasU32Affinity()) {
         clear_has_u32Affinity();
        _u32Affinity = 0u;
     }
}

inline bool StartProcessStart::hasU32Affinity () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 StartProcessStart::getU32Affinity () const {
    return _u32Affinity;
}

inline void StartProcessStart::setU32Affinity (uint32 u32Affinity_) {
    set_has_u32Affinity();
    this->_u32Affinity = u32Affinity_;
}

inline void StartProcessStart::clearU32AffinityEnd() {
    if (hasU32AffinityEnd()) {
         clear_has_u32AffinityEnd();
        _u32AffinityEnd = 0u;
     }
}

inline bool StartProcessStart::hasU32AffinityEnd () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 StartProcessStart::getU32AffinityEnd () const {
    return _u32AffinityEnd;
}

inline void StartProcessStart::setU32AffinityEnd (uint32 u32AffinityEnd_) {
    set_has_u32AffinityEnd();
    this->_u32AffinityEnd = u32AffinityEnd_;
}

inline void StartProcessStart::clearU32NiceLevel() {
    if (hasU32NiceLevel()) {
         clear_has_u32NiceLevel();
        _u32NiceLevel = 0u;
     }
}

inline bool StartProcessStart::hasU32NiceLevel () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 StartProcessStart::getU32NiceLevel () const {
    return _u32NiceLevel;
}

inline void StartProcessStart::setU32NiceLevel (uint32 u32NiceLevel_) {
    set_has_u32NiceLevel();
    this->_u32NiceLevel = u32NiceLevel_;
}

inline void StartProcessStart::clearU32NiceLevelEnd() {
    if (hasU32NiceLevelEnd()) {
         clear_has_u32NiceLevelEnd();
        _u32NiceLevelEnd = 0u;
     }
}

inline bool StartProcessStart::hasU32NiceLevelEnd () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint32 StartProcessStart::getU32NiceLevelEnd () const {
    return _u32NiceLevelEnd;
}

inline void StartProcessStart::setU32NiceLevelEnd (uint32 u32NiceLevelEnd_) {
    set_has_u32NiceLevelEnd();
    this->_u32NiceLevelEnd = u32NiceLevelEnd_;
}

inline void StartProcessStart::clearU32Type() {
    if (hasU32Type()) {
         clear_has_u32Type();
        _u32Type = ::lcm_dbusctrl_fi_types::T_e32_LCM_START_PROC_TYPE__SPM_U32_START_PROC_TYPE_OSAL_SPAWN;
     }
}

inline bool StartProcessStart::hasU32Type () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline ::lcm_dbusctrl_fi_types::T_e32_LCM_START_PROC_TYPE StartProcessStart::getU32Type () const {
    return _u32Type;
}

inline void StartProcessStart::setU32Type (::lcm_dbusctrl_fi_types::T_e32_LCM_START_PROC_TYPE u32Type_) {
    #ifndef NDEBUG
    if (!(::lcm_dbusctrl_fi_types::T_e32_LCM_START_PROC_TYPE_IsValid(u32Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u32Type_, "T_e32_LCM_START_PROC_TYPE", "u32Type", "StartProcessStart");
    }
    #endif
    set_has_u32Type();
    this->_u32Type = u32Type_;
}

inline void StartProcessStart::clearU32Info() {
    if (hasU32Info()) {
         clear_has_u32Info();
        _u32Info = 0u;
     }
}

inline bool StartProcessStart::hasU32Info () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint32 StartProcessStart::getU32Info () const {
    return _u32Info;
}

inline void StartProcessStart::setU32Info (uint32 u32Info_) {
    set_has_u32Info();
    this->_u32Info = u32Info_;
}

inline void StartProcessStart::set_has_strLocation () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartProcessStart::clear_has_strLocation () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StartProcessStart::set_has_u32Prio () {
    _has_bits_[0] |= 1u << 1;
}

inline void StartProcessStart::clear_has_u32Prio () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void StartProcessStart::set_has_u32Affinity () {
    _has_bits_[0] |= 1u << 2;
}

inline void StartProcessStart::clear_has_u32Affinity () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void StartProcessStart::set_has_u32AffinityEnd () {
    _has_bits_[0] |= 1u << 3;
}

inline void StartProcessStart::clear_has_u32AffinityEnd () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void StartProcessStart::set_has_u32NiceLevel () {
    _has_bits_[0] |= 1u << 4;
}

inline void StartProcessStart::clear_has_u32NiceLevel () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void StartProcessStart::set_has_u32NiceLevelEnd () {
    _has_bits_[0] |= 1u << 5;
}

inline void StartProcessStart::clear_has_u32NiceLevelEnd () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void StartProcessStart::set_has_u32Type () {
    _has_bits_[0] |= 1u << 6;
}

inline void StartProcessStart::clear_has_u32Type () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void StartProcessStart::set_has_u32Info () {
    _has_bits_[0] |= 1u << 7;
}

inline void StartProcessStart::clear_has_u32Info () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  StartProcessResult::StartProcessResult ()  :
    _s32ReturnVal (0),
    _strLocation (),
    _u32ProcId (0u),
    _u32SpawnDuration (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartProcessResult::StartProcessResult (const StartProcessResult &rhs)  :
    ::asf::core::Payload(rhs),
    _s32ReturnVal (0),
    _strLocation (),
    _u32ProcId (0u),
    _u32SpawnDuration (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartProcessResult::StartProcessResult (int32 s32ReturnVal_, const ::std::string& strLocation_, uint32 u32ProcId_, uint32 u32SpawnDuration_)  :
    _s32ReturnVal (s32ReturnVal_),
    _strLocation (strLocation_),
    _u32ProcId (u32ProcId_),
    _u32SpawnDuration (u32SpawnDuration_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLocation_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartProcessResult::~StartProcessResult() {
}

inline StartProcessResult& StartProcessResult::operator = (const StartProcessResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS32ReturnVal()) {
            setS32ReturnVal(rhs.getS32ReturnVal());
        } else {
            clearS32ReturnVal();
        }
        if (rhs.hasStrLocation()) {
            setStrLocation(rhs.getStrLocation());
        } else {
            clearStrLocation();
        }
        if (rhs.hasU32ProcId()) {
            setU32ProcId(rhs.getU32ProcId());
        } else {
            clearU32ProcId();
        }
        if (rhs.hasU32SpawnDuration()) {
            setU32SpawnDuration(rhs.getU32SpawnDuration());
        } else {
            clearU32SpawnDuration();
        }
    }
    return *this;
}

inline bool StartProcessResult::operator == (const StartProcessResult& rhs) const {
    return (((!hasS32ReturnVal() && !rhs.hasS32ReturnVal()) || getS32ReturnVal() == rhs.getS32ReturnVal()) &&
        ((!hasStrLocation() && !rhs.hasStrLocation()) || getStrLocation() == rhs.getStrLocation()) &&
        ((!hasU32ProcId() && !rhs.hasU32ProcId()) || getU32ProcId() == rhs.getU32ProcId()) &&
        ((!hasU32SpawnDuration() && !rhs.hasU32SpawnDuration()) || getU32SpawnDuration() == rhs.getU32SpawnDuration()));
}

inline bool StartProcessResult::operator != (const StartProcessResult& rhs) const {
    return ! (*this == rhs);
}

inline bool StartProcessResult::operator < (const StartProcessResult& rhs) const {
    if (hasS32ReturnVal() || rhs.hasS32ReturnVal()) {
        if (getS32ReturnVal() < rhs.getS32ReturnVal()) return true;
        if (getS32ReturnVal() > rhs.getS32ReturnVal()) return false;
    }
    if (hasStrLocation() || rhs.hasStrLocation()) {
        if (getStrLocation() < rhs.getStrLocation()) return true;
        if (getStrLocation() > rhs.getStrLocation()) return false;
    }
    if (hasU32ProcId() || rhs.hasU32ProcId()) {
        if (getU32ProcId() < rhs.getU32ProcId()) return true;
        if (getU32ProcId() > rhs.getU32ProcId()) return false;
    }
    if (hasU32SpawnDuration() || rhs.hasU32SpawnDuration()) {
        if (getU32SpawnDuration() < rhs.getU32SpawnDuration()) return true;
        if (getU32SpawnDuration() > rhs.getU32SpawnDuration()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartProcessResult::clone() {
    return new StartProcessResult(*this);
}

inline bool StartProcessResult::operator > (const StartProcessResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartProcessResult::clear() {
    clearS32ReturnVal();
    clearStrLocation();
    clearU32ProcId();
    clearU32SpawnDuration();
}

inline void StartProcessResult::clearS32ReturnVal() {
    if (hasS32ReturnVal()) {
         clear_has_s32ReturnVal();
        _s32ReturnVal = 0;
     }
}

inline bool StartProcessResult::hasS32ReturnVal () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 StartProcessResult::getS32ReturnVal () const {
    return _s32ReturnVal;
}

inline void StartProcessResult::setS32ReturnVal (int32 s32ReturnVal_) {
    set_has_s32ReturnVal();
    this->_s32ReturnVal = s32ReturnVal_;
}

inline void StartProcessResult::clearStrLocation() {
    if (hasStrLocation()) {
         clear_has_strLocation();
        _strLocation.clear();
     }
}

inline bool StartProcessResult::hasStrLocation () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& StartProcessResult::getStrLocation () const {
    return _strLocation;
}

inline ::std::string& StartProcessResult::getStrLocationMutable () {
    set_has_strLocation();
    return _strLocation;
}

inline void StartProcessResult::setStrLocation (const ::std::string& strLocation_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLocation_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLocation();
    this->_strLocation = strLocation_;
}

inline void StartProcessResult::setStrLocation (const char* strLocation_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLocation_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLocation();
    this->_strLocation.assign(strLocation_);
}

inline void StartProcessResult::setStrLocation (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLocation();
    this->_strLocation.assign(value, size);
}

inline void StartProcessResult::clearU32ProcId() {
    if (hasU32ProcId()) {
         clear_has_u32ProcId();
        _u32ProcId = 0u;
     }
}

inline bool StartProcessResult::hasU32ProcId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 StartProcessResult::getU32ProcId () const {
    return _u32ProcId;
}

inline void StartProcessResult::setU32ProcId (uint32 u32ProcId_) {
    set_has_u32ProcId();
    this->_u32ProcId = u32ProcId_;
}

inline void StartProcessResult::clearU32SpawnDuration() {
    if (hasU32SpawnDuration()) {
         clear_has_u32SpawnDuration();
        _u32SpawnDuration = 0u;
     }
}

inline bool StartProcessResult::hasU32SpawnDuration () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 StartProcessResult::getU32SpawnDuration () const {
    return _u32SpawnDuration;
}

inline void StartProcessResult::setU32SpawnDuration (uint32 u32SpawnDuration_) {
    set_has_u32SpawnDuration();
    this->_u32SpawnDuration = u32SpawnDuration_;
}

inline void StartProcessResult::set_has_s32ReturnVal () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartProcessResult::clear_has_s32ReturnVal () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StartProcessResult::set_has_strLocation () {
    _has_bits_[0] |= 1u << 1;
}

inline void StartProcessResult::clear_has_strLocation () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void StartProcessResult::set_has_u32ProcId () {
    _has_bits_[0] |= 1u << 2;
}

inline void StartProcessResult::clear_has_u32ProcId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void StartProcessResult::set_has_u32SpawnDuration () {
    _has_bits_[0] |= 1u << 3;
}

inline void StartProcessResult::clear_has_u32SpawnDuration () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  StopProcessStart::StopProcessStart ()  :
    _strLocation (),
    _u32ProcId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StopProcessStart::StopProcessStart (const StopProcessStart &rhs)  :
    ::asf::core::Payload(rhs),
    _strLocation (),
    _u32ProcId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StopProcessStart::StopProcessStart (const ::std::string& strLocation_, uint32 u32ProcId_)  :
    _strLocation (strLocation_),
    _u32ProcId (u32ProcId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLocation_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StopProcessStart::~StopProcessStart() {
}

inline StopProcessStart& StopProcessStart::operator = (const StopProcessStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStrLocation()) {
            setStrLocation(rhs.getStrLocation());
        } else {
            clearStrLocation();
        }
        if (rhs.hasU32ProcId()) {
            setU32ProcId(rhs.getU32ProcId());
        } else {
            clearU32ProcId();
        }
    }
    return *this;
}

inline bool StopProcessStart::operator == (const StopProcessStart& rhs) const {
    return (((!hasStrLocation() && !rhs.hasStrLocation()) || getStrLocation() == rhs.getStrLocation()) &&
        ((!hasU32ProcId() && !rhs.hasU32ProcId()) || getU32ProcId() == rhs.getU32ProcId()));
}

inline bool StopProcessStart::operator != (const StopProcessStart& rhs) const {
    return ! (*this == rhs);
}

inline bool StopProcessStart::operator < (const StopProcessStart& rhs) const {
    if (hasStrLocation() || rhs.hasStrLocation()) {
        if (getStrLocation() < rhs.getStrLocation()) return true;
        if (getStrLocation() > rhs.getStrLocation()) return false;
    }
    if (hasU32ProcId() || rhs.hasU32ProcId()) {
        if (getU32ProcId() < rhs.getU32ProcId()) return true;
        if (getU32ProcId() > rhs.getU32ProcId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StopProcessStart::clone() {
    return new StopProcessStart(*this);
}

inline bool StopProcessStart::operator > (const StopProcessStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StopProcessStart::clear() {
    clearStrLocation();
    clearU32ProcId();
}

inline void StopProcessStart::clearStrLocation() {
    if (hasStrLocation()) {
         clear_has_strLocation();
        _strLocation.clear();
     }
}

inline bool StopProcessStart::hasStrLocation () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StopProcessStart::getStrLocation () const {
    return _strLocation;
}

inline ::std::string& StopProcessStart::getStrLocationMutable () {
    set_has_strLocation();
    return _strLocation;
}

inline void StopProcessStart::setStrLocation (const ::std::string& strLocation_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLocation_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLocation();
    this->_strLocation = strLocation_;
}

inline void StopProcessStart::setStrLocation (const char* strLocation_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLocation_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLocation();
    this->_strLocation.assign(strLocation_);
}

inline void StopProcessStart::setStrLocation (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLocation();
    this->_strLocation.assign(value, size);
}

inline void StopProcessStart::clearU32ProcId() {
    if (hasU32ProcId()) {
         clear_has_u32ProcId();
        _u32ProcId = 0u;
     }
}

inline bool StopProcessStart::hasU32ProcId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 StopProcessStart::getU32ProcId () const {
    return _u32ProcId;
}

inline void StopProcessStart::setU32ProcId (uint32 u32ProcId_) {
    set_has_u32ProcId();
    this->_u32ProcId = u32ProcId_;
}

inline void StopProcessStart::set_has_strLocation () {
    _has_bits_[0] |= 1u << 0;
}

inline void StopProcessStart::clear_has_strLocation () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StopProcessStart::set_has_u32ProcId () {
    _has_bits_[0] |= 1u << 1;
}

inline void StopProcessStart::clear_has_u32ProcId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  StopProcessResult::StopProcessResult ()  :
    _s32ReturnVal (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StopProcessResult::StopProcessResult (const StopProcessResult &rhs)  :
    ::asf::core::Payload(rhs),
    _s32ReturnVal (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StopProcessResult::StopProcessResult (int32 s32ReturnVal_)  :
    _s32ReturnVal (s32ReturnVal_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StopProcessResult::~StopProcessResult() {
}

inline StopProcessResult& StopProcessResult::operator = (const StopProcessResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS32ReturnVal()) {
            setS32ReturnVal(rhs.getS32ReturnVal());
        } else {
            clearS32ReturnVal();
        }
    }
    return *this;
}

inline bool StopProcessResult::operator == (const StopProcessResult& rhs) const {
    return (((!hasS32ReturnVal() && !rhs.hasS32ReturnVal()) || getS32ReturnVal() == rhs.getS32ReturnVal()));
}

inline bool StopProcessResult::operator != (const StopProcessResult& rhs) const {
    return ! (*this == rhs);
}

inline bool StopProcessResult::operator < (const StopProcessResult& rhs) const {
    if (hasS32ReturnVal() || rhs.hasS32ReturnVal()) {
        if (getS32ReturnVal() < rhs.getS32ReturnVal()) return true;
        if (getS32ReturnVal() > rhs.getS32ReturnVal()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StopProcessResult::clone() {
    return new StopProcessResult(*this);
}

inline bool StopProcessResult::operator > (const StopProcessResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StopProcessResult::clear() {
    clearS32ReturnVal();
}

inline void StopProcessResult::clearS32ReturnVal() {
    if (hasS32ReturnVal()) {
         clear_has_s32ReturnVal();
        _s32ReturnVal = 0;
     }
}

inline bool StopProcessResult::hasS32ReturnVal () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 StopProcessResult::getS32ReturnVal () const {
    return _s32ReturnVal;
}

inline void StopProcessResult::setS32ReturnVal (int32 s32ReturnVal_) {
    set_has_s32ReturnVal();
    this->_s32ReturnVal = s32ReturnVal_;
}

inline void StopProcessResult::set_has_s32ReturnVal () {
    _has_bits_[0] |= 1u << 0;
}

inline void StopProcessResult::clear_has_s32ReturnVal () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StartupFinishedStart::StartupFinishedStart ()  :
    _eStartUpParam (::lcm_dbusctrl_fi_types::T_e32_LCM_STARTUP_TYPE__SPM_U32_STARTUP_ACTIVE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartupFinishedStart::StartupFinishedStart (const StartupFinishedStart &rhs)  :
    ::asf::core::Payload(rhs),
    _eStartUpParam (::lcm_dbusctrl_fi_types::T_e32_LCM_STARTUP_TYPE__SPM_U32_STARTUP_ACTIVE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartupFinishedStart::StartupFinishedStart (::lcm_dbusctrl_fi_types::T_e32_LCM_STARTUP_TYPE eStartUpParam_)  :
    _eStartUpParam (eStartUpParam_)
{
    #ifndef NDEBUG
    if (!(::lcm_dbusctrl_fi_types::T_e32_LCM_STARTUP_TYPE_IsValid(eStartUpParam_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eStartUpParam_, "T_e32_LCM_STARTUP_TYPE", "eStartUpParam", "StartupFinishedStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartupFinishedStart::~StartupFinishedStart() {
}

inline StartupFinishedStart& StartupFinishedStart::operator = (const StartupFinishedStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEStartUpParam()) {
            setEStartUpParam(rhs.getEStartUpParam());
        } else {
            clearEStartUpParam();
        }
    }
    return *this;
}

inline bool StartupFinishedStart::operator == (const StartupFinishedStart& rhs) const {
    return (((!hasEStartUpParam() && !rhs.hasEStartUpParam()) || getEStartUpParam() == rhs.getEStartUpParam()));
}

inline bool StartupFinishedStart::operator != (const StartupFinishedStart& rhs) const {
    return ! (*this == rhs);
}

inline bool StartupFinishedStart::operator < (const StartupFinishedStart& rhs) const {
    if (hasEStartUpParam() || rhs.hasEStartUpParam()) {
        if ((uint32)getEStartUpParam() < (uint32)rhs.getEStartUpParam()) return true;
        if ((uint32)getEStartUpParam() > (uint32)rhs.getEStartUpParam()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartupFinishedStart::clone() {
    return new StartupFinishedStart(*this);
}

inline bool StartupFinishedStart::operator > (const StartupFinishedStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartupFinishedStart::clear() {
    clearEStartUpParam();
}

inline void StartupFinishedStart::clearEStartUpParam() {
    if (hasEStartUpParam()) {
         clear_has_eStartUpParam();
        _eStartUpParam = ::lcm_dbusctrl_fi_types::T_e32_LCM_STARTUP_TYPE__SPM_U32_STARTUP_ACTIVE;
     }
}

inline bool StartupFinishedStart::hasEStartUpParam () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::lcm_dbusctrl_fi_types::T_e32_LCM_STARTUP_TYPE StartupFinishedStart::getEStartUpParam () const {
    return _eStartUpParam;
}

inline void StartupFinishedStart::setEStartUpParam (::lcm_dbusctrl_fi_types::T_e32_LCM_STARTUP_TYPE eStartUpParam_) {
    #ifndef NDEBUG
    if (!(::lcm_dbusctrl_fi_types::T_e32_LCM_STARTUP_TYPE_IsValid(eStartUpParam_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eStartUpParam_, "T_e32_LCM_STARTUP_TYPE", "eStartUpParam", "StartupFinishedStart");
    }
    #endif
    set_has_eStartUpParam();
    this->_eStartUpParam = eStartUpParam_;
}

inline void StartupFinishedStart::set_has_eStartUpParam () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartupFinishedStart::clear_has_eStartUpParam () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StartupFinishedResult::StartupFinishedResult ()  :
    _s32ReturnVal (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartupFinishedResult::StartupFinishedResult (const StartupFinishedResult &rhs)  :
    ::asf::core::Payload(rhs),
    _s32ReturnVal (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartupFinishedResult::StartupFinishedResult (int32 s32ReturnVal_)  :
    _s32ReturnVal (s32ReturnVal_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartupFinishedResult::~StartupFinishedResult() {
}

inline StartupFinishedResult& StartupFinishedResult::operator = (const StartupFinishedResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS32ReturnVal()) {
            setS32ReturnVal(rhs.getS32ReturnVal());
        } else {
            clearS32ReturnVal();
        }
    }
    return *this;
}

inline bool StartupFinishedResult::operator == (const StartupFinishedResult& rhs) const {
    return (((!hasS32ReturnVal() && !rhs.hasS32ReturnVal()) || getS32ReturnVal() == rhs.getS32ReturnVal()));
}

inline bool StartupFinishedResult::operator != (const StartupFinishedResult& rhs) const {
    return ! (*this == rhs);
}

inline bool StartupFinishedResult::operator < (const StartupFinishedResult& rhs) const {
    if (hasS32ReturnVal() || rhs.hasS32ReturnVal()) {
        if (getS32ReturnVal() < rhs.getS32ReturnVal()) return true;
        if (getS32ReturnVal() > rhs.getS32ReturnVal()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartupFinishedResult::clone() {
    return new StartupFinishedResult(*this);
}

inline bool StartupFinishedResult::operator > (const StartupFinishedResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartupFinishedResult::clear() {
    clearS32ReturnVal();
}

inline void StartupFinishedResult::clearS32ReturnVal() {
    if (hasS32ReturnVal()) {
         clear_has_s32ReturnVal();
        _s32ReturnVal = 0;
     }
}

inline bool StartupFinishedResult::hasS32ReturnVal () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 StartupFinishedResult::getS32ReturnVal () const {
    return _s32ReturnVal;
}

inline void StartupFinishedResult::setS32ReturnVal (int32 s32ReturnVal_) {
    set_has_s32ReturnVal();
    this->_s32ReturnVal = s32ReturnVal_;
}

inline void StartupFinishedResult::set_has_s32ReturnVal () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartupFinishedResult::clear_has_s32ReturnVal () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetProcessIdStart::GetProcessIdStart ()  :
    _strServiceName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetProcessIdStart::GetProcessIdStart (const GetProcessIdStart &rhs)  :
    ::asf::core::Payload(rhs),
    _strServiceName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetProcessIdStart::GetProcessIdStart (const ::std::string& strServiceName_)  :
    _strServiceName (strServiceName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strServiceName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetProcessIdStart::~GetProcessIdStart() {
}

inline GetProcessIdStart& GetProcessIdStart::operator = (const GetProcessIdStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStrServiceName()) {
            setStrServiceName(rhs.getStrServiceName());
        } else {
            clearStrServiceName();
        }
    }
    return *this;
}

inline bool GetProcessIdStart::operator == (const GetProcessIdStart& rhs) const {
    return (((!hasStrServiceName() && !rhs.hasStrServiceName()) || getStrServiceName() == rhs.getStrServiceName()));
}

inline bool GetProcessIdStart::operator != (const GetProcessIdStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetProcessIdStart::operator < (const GetProcessIdStart& rhs) const {
    if (hasStrServiceName() || rhs.hasStrServiceName()) {
        if (getStrServiceName() < rhs.getStrServiceName()) return true;
        if (getStrServiceName() > rhs.getStrServiceName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetProcessIdStart::clone() {
    return new GetProcessIdStart(*this);
}

inline bool GetProcessIdStart::operator > (const GetProcessIdStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetProcessIdStart::clear() {
    clearStrServiceName();
}

inline void GetProcessIdStart::clearStrServiceName() {
    if (hasStrServiceName()) {
         clear_has_strServiceName();
        _strServiceName.clear();
     }
}

inline bool GetProcessIdStart::hasStrServiceName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetProcessIdStart::getStrServiceName () const {
    return _strServiceName;
}

inline ::std::string& GetProcessIdStart::getStrServiceNameMutable () {
    set_has_strServiceName();
    return _strServiceName;
}

inline void GetProcessIdStart::setStrServiceName (const ::std::string& strServiceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strServiceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strServiceName();
    this->_strServiceName = strServiceName_;
}

inline void GetProcessIdStart::setStrServiceName (const char* strServiceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strServiceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strServiceName();
    this->_strServiceName.assign(strServiceName_);
}

inline void GetProcessIdStart::setStrServiceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strServiceName();
    this->_strServiceName.assign(value, size);
}

inline void GetProcessIdStart::set_has_strServiceName () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetProcessIdStart::clear_has_strServiceName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RestartProcessStart::RestartProcessStart ()  :
    _strLocation (),
    _u32ProcId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RestartProcessStart::RestartProcessStart (const RestartProcessStart &rhs)  :
    ::asf::core::Payload(rhs),
    _strLocation (),
    _u32ProcId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RestartProcessStart::RestartProcessStart (const ::std::string& strLocation_, uint32 u32ProcId_)  :
    _strLocation (strLocation_),
    _u32ProcId (u32ProcId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLocation_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RestartProcessStart::~RestartProcessStart() {
}

inline RestartProcessStart& RestartProcessStart::operator = (const RestartProcessStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStrLocation()) {
            setStrLocation(rhs.getStrLocation());
        } else {
            clearStrLocation();
        }
        if (rhs.hasU32ProcId()) {
            setU32ProcId(rhs.getU32ProcId());
        } else {
            clearU32ProcId();
        }
    }
    return *this;
}

inline bool RestartProcessStart::operator == (const RestartProcessStart& rhs) const {
    return (((!hasStrLocation() && !rhs.hasStrLocation()) || getStrLocation() == rhs.getStrLocation()) &&
        ((!hasU32ProcId() && !rhs.hasU32ProcId()) || getU32ProcId() == rhs.getU32ProcId()));
}

inline bool RestartProcessStart::operator != (const RestartProcessStart& rhs) const {
    return ! (*this == rhs);
}

inline bool RestartProcessStart::operator < (const RestartProcessStart& rhs) const {
    if (hasStrLocation() || rhs.hasStrLocation()) {
        if (getStrLocation() < rhs.getStrLocation()) return true;
        if (getStrLocation() > rhs.getStrLocation()) return false;
    }
    if (hasU32ProcId() || rhs.hasU32ProcId()) {
        if (getU32ProcId() < rhs.getU32ProcId()) return true;
        if (getU32ProcId() > rhs.getU32ProcId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RestartProcessStart::clone() {
    return new RestartProcessStart(*this);
}

inline bool RestartProcessStart::operator > (const RestartProcessStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RestartProcessStart::clear() {
    clearStrLocation();
    clearU32ProcId();
}

inline void RestartProcessStart::clearStrLocation() {
    if (hasStrLocation()) {
         clear_has_strLocation();
        _strLocation.clear();
     }
}

inline bool RestartProcessStart::hasStrLocation () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RestartProcessStart::getStrLocation () const {
    return _strLocation;
}

inline ::std::string& RestartProcessStart::getStrLocationMutable () {
    set_has_strLocation();
    return _strLocation;
}

inline void RestartProcessStart::setStrLocation (const ::std::string& strLocation_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLocation_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLocation();
    this->_strLocation = strLocation_;
}

inline void RestartProcessStart::setStrLocation (const char* strLocation_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLocation_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLocation();
    this->_strLocation.assign(strLocation_);
}

inline void RestartProcessStart::setStrLocation (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLocation();
    this->_strLocation.assign(value, size);
}

inline void RestartProcessStart::clearU32ProcId() {
    if (hasU32ProcId()) {
         clear_has_u32ProcId();
        _u32ProcId = 0u;
     }
}

inline bool RestartProcessStart::hasU32ProcId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 RestartProcessStart::getU32ProcId () const {
    return _u32ProcId;
}

inline void RestartProcessStart::setU32ProcId (uint32 u32ProcId_) {
    set_has_u32ProcId();
    this->_u32ProcId = u32ProcId_;
}

inline void RestartProcessStart::set_has_strLocation () {
    _has_bits_[0] |= 1u << 0;
}

inline void RestartProcessStart::clear_has_strLocation () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RestartProcessStart::set_has_u32ProcId () {
    _has_bits_[0] |= 1u << 1;
}

inline void RestartProcessStart::clear_has_u32ProcId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RestartProcessResult::RestartProcessResult ()  :
    _s32ReturnVal (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RestartProcessResult::RestartProcessResult (const RestartProcessResult &rhs)  :
    ::asf::core::Payload(rhs),
    _s32ReturnVal (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RestartProcessResult::RestartProcessResult (int32 s32ReturnVal_)  :
    _s32ReturnVal (s32ReturnVal_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RestartProcessResult::~RestartProcessResult() {
}

inline RestartProcessResult& RestartProcessResult::operator = (const RestartProcessResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS32ReturnVal()) {
            setS32ReturnVal(rhs.getS32ReturnVal());
        } else {
            clearS32ReturnVal();
        }
    }
    return *this;
}

inline bool RestartProcessResult::operator == (const RestartProcessResult& rhs) const {
    return (((!hasS32ReturnVal() && !rhs.hasS32ReturnVal()) || getS32ReturnVal() == rhs.getS32ReturnVal()));
}

inline bool RestartProcessResult::operator != (const RestartProcessResult& rhs) const {
    return ! (*this == rhs);
}

inline bool RestartProcessResult::operator < (const RestartProcessResult& rhs) const {
    if (hasS32ReturnVal() || rhs.hasS32ReturnVal()) {
        if (getS32ReturnVal() < rhs.getS32ReturnVal()) return true;
        if (getS32ReturnVal() > rhs.getS32ReturnVal()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RestartProcessResult::clone() {
    return new RestartProcessResult(*this);
}

inline bool RestartProcessResult::operator > (const RestartProcessResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RestartProcessResult::clear() {
    clearS32ReturnVal();
}

inline void RestartProcessResult::clearS32ReturnVal() {
    if (hasS32ReturnVal()) {
         clear_has_s32ReturnVal();
        _s32ReturnVal = 0;
     }
}

inline bool RestartProcessResult::hasS32ReturnVal () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 RestartProcessResult::getS32ReturnVal () const {
    return _s32ReturnVal;
}

inline void RestartProcessResult::setS32ReturnVal (int32 s32ReturnVal_) {
    set_has_s32ReturnVal();
    this->_s32ReturnVal = s32ReturnVal_;
}

inline void RestartProcessResult::set_has_s32ReturnVal () {
    _has_bits_[0] |= 1u << 0;
}

inline void RestartProcessResult::clear_has_s32ReturnVal () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AppStartRequestStatus::AppStartRequestStatus ()  :
    _strSwBlockName (),
    _strServiceName (),
    _u32AppId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AppStartRequestStatus::AppStartRequestStatus (const AppStartRequestStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _strSwBlockName (),
    _strServiceName (),
    _u32AppId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AppStartRequestStatus::AppStartRequestStatus (const ::std::string& strSwBlockName_, const ::std::string& strServiceName_, uint32 u32AppId_)  :
    _strSwBlockName (strSwBlockName_),
    _strServiceName (strServiceName_),
    _u32AppId (u32AppId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strSwBlockName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strServiceName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AppStartRequestStatus::~AppStartRequestStatus() {
}

inline AppStartRequestStatus& AppStartRequestStatus::operator = (const AppStartRequestStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStrSwBlockName()) {
            setStrSwBlockName(rhs.getStrSwBlockName());
        } else {
            clearStrSwBlockName();
        }
        if (rhs.hasStrServiceName()) {
            setStrServiceName(rhs.getStrServiceName());
        } else {
            clearStrServiceName();
        }
        if (rhs.hasU32AppId()) {
            setU32AppId(rhs.getU32AppId());
        } else {
            clearU32AppId();
        }
    }
    return *this;
}

inline bool AppStartRequestStatus::operator == (const AppStartRequestStatus& rhs) const {
    return (((!hasStrSwBlockName() && !rhs.hasStrSwBlockName()) || getStrSwBlockName() == rhs.getStrSwBlockName()) &&
        ((!hasStrServiceName() && !rhs.hasStrServiceName()) || getStrServiceName() == rhs.getStrServiceName()) &&
        ((!hasU32AppId() && !rhs.hasU32AppId()) || getU32AppId() == rhs.getU32AppId()));
}

inline bool AppStartRequestStatus::operator != (const AppStartRequestStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool AppStartRequestStatus::operator < (const AppStartRequestStatus& rhs) const {
    if (hasStrSwBlockName() || rhs.hasStrSwBlockName()) {
        if (getStrSwBlockName() < rhs.getStrSwBlockName()) return true;
        if (getStrSwBlockName() > rhs.getStrSwBlockName()) return false;
    }
    if (hasStrServiceName() || rhs.hasStrServiceName()) {
        if (getStrServiceName() < rhs.getStrServiceName()) return true;
        if (getStrServiceName() > rhs.getStrServiceName()) return false;
    }
    if (hasU32AppId() || rhs.hasU32AppId()) {
        if (getU32AppId() < rhs.getU32AppId()) return true;
        if (getU32AppId() > rhs.getU32AppId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AppStartRequestStatus::clone() {
    return new AppStartRequestStatus(*this);
}

inline bool AppStartRequestStatus::operator > (const AppStartRequestStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AppStartRequestStatus::clear() {
    clearStrSwBlockName();
    clearStrServiceName();
    clearU32AppId();
}

inline void AppStartRequestStatus::clearStrSwBlockName() {
    if (hasStrSwBlockName()) {
         clear_has_strSwBlockName();
        _strSwBlockName.clear();
     }
}

inline bool AppStartRequestStatus::hasStrSwBlockName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& AppStartRequestStatus::getStrSwBlockName () const {
    return _strSwBlockName;
}

inline ::std::string& AppStartRequestStatus::getStrSwBlockNameMutable () {
    set_has_strSwBlockName();
    return _strSwBlockName;
}

inline void AppStartRequestStatus::setStrSwBlockName (const ::std::string& strSwBlockName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strSwBlockName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strSwBlockName();
    this->_strSwBlockName = strSwBlockName_;
}

inline void AppStartRequestStatus::setStrSwBlockName (const char* strSwBlockName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strSwBlockName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strSwBlockName();
    this->_strSwBlockName.assign(strSwBlockName_);
}

inline void AppStartRequestStatus::setStrSwBlockName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strSwBlockName();
    this->_strSwBlockName.assign(value, size);
}

inline void AppStartRequestStatus::clearStrServiceName() {
    if (hasStrServiceName()) {
         clear_has_strServiceName();
        _strServiceName.clear();
     }
}

inline bool AppStartRequestStatus::hasStrServiceName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& AppStartRequestStatus::getStrServiceName () const {
    return _strServiceName;
}

inline ::std::string& AppStartRequestStatus::getStrServiceNameMutable () {
    set_has_strServiceName();
    return _strServiceName;
}

inline void AppStartRequestStatus::setStrServiceName (const ::std::string& strServiceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strServiceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strServiceName();
    this->_strServiceName = strServiceName_;
}

inline void AppStartRequestStatus::setStrServiceName (const char* strServiceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strServiceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strServiceName();
    this->_strServiceName.assign(strServiceName_);
}

inline void AppStartRequestStatus::setStrServiceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strServiceName();
    this->_strServiceName.assign(value, size);
}

inline void AppStartRequestStatus::clearU32AppId() {
    if (hasU32AppId()) {
         clear_has_u32AppId();
        _u32AppId = 0u;
     }
}

inline bool AppStartRequestStatus::hasU32AppId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 AppStartRequestStatus::getU32AppId () const {
    return _u32AppId;
}

inline void AppStartRequestStatus::setU32AppId (uint32 u32AppId_) {
    set_has_u32AppId();
    this->_u32AppId = u32AppId_;
}

inline void AppStartRequestStatus::set_has_strSwBlockName () {
    _has_bits_[0] |= 1u << 0;
}

inline void AppStartRequestStatus::clear_has_strSwBlockName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AppStartRequestStatus::set_has_strServiceName () {
    _has_bits_[0] |= 1u << 1;
}

inline void AppStartRequestStatus::clear_has_strServiceName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void AppStartRequestStatus::set_has_u32AppId () {
    _has_bits_[0] |= 1u << 2;
}

inline void AppStartRequestStatus::clear_has_u32AppId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  AppInitializedStatus::AppInitializedStatus ()  :
    _u32AppId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AppInitializedStatus::AppInitializedStatus (const AppInitializedStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _u32AppId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AppInitializedStatus::AppInitializedStatus (uint32 u32AppId_)  :
    _u32AppId (u32AppId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AppInitializedStatus::~AppInitializedStatus() {
}

inline AppInitializedStatus& AppInitializedStatus::operator = (const AppInitializedStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU32AppId()) {
            setU32AppId(rhs.getU32AppId());
        } else {
            clearU32AppId();
        }
    }
    return *this;
}

inline bool AppInitializedStatus::operator == (const AppInitializedStatus& rhs) const {
    return (((!hasU32AppId() && !rhs.hasU32AppId()) || getU32AppId() == rhs.getU32AppId()));
}

inline bool AppInitializedStatus::operator != (const AppInitializedStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool AppInitializedStatus::operator < (const AppInitializedStatus& rhs) const {
    if (hasU32AppId() || rhs.hasU32AppId()) {
        if (getU32AppId() < rhs.getU32AppId()) return true;
        if (getU32AppId() > rhs.getU32AppId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AppInitializedStatus::clone() {
    return new AppInitializedStatus(*this);
}

inline bool AppInitializedStatus::operator > (const AppInitializedStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AppInitializedStatus::clear() {
    clearU32AppId();
}

inline void AppInitializedStatus::clearU32AppId() {
    if (hasU32AppId()) {
         clear_has_u32AppId();
        _u32AppId = 0u;
     }
}

inline bool AppInitializedStatus::hasU32AppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 AppInitializedStatus::getU32AppId () const {
    return _u32AppId;
}

inline void AppInitializedStatus::setU32AppId (uint32 u32AppId_) {
    set_has_u32AppId();
    this->_u32AppId = u32AppId_;
}

inline void AppInitializedStatus::set_has_u32AppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void AppInitializedStatus::clear_has_u32AppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AppStateChangeStatus::AppStateChangeStatus ()  :
    _u32AppId (0u),
    _u32State (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AppStateChangeStatus::AppStateChangeStatus (const AppStateChangeStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _u32AppId (0u),
    _u32State (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AppStateChangeStatus::AppStateChangeStatus (uint32 u32AppId_, uint32 u32State_)  :
    _u32AppId (u32AppId_),
    _u32State (u32State_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AppStateChangeStatus::~AppStateChangeStatus() {
}

inline AppStateChangeStatus& AppStateChangeStatus::operator = (const AppStateChangeStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU32AppId()) {
            setU32AppId(rhs.getU32AppId());
        } else {
            clearU32AppId();
        }
        if (rhs.hasU32State()) {
            setU32State(rhs.getU32State());
        } else {
            clearU32State();
        }
    }
    return *this;
}

inline bool AppStateChangeStatus::operator == (const AppStateChangeStatus& rhs) const {
    return (((!hasU32AppId() && !rhs.hasU32AppId()) || getU32AppId() == rhs.getU32AppId()) &&
        ((!hasU32State() && !rhs.hasU32State()) || getU32State() == rhs.getU32State()));
}

inline bool AppStateChangeStatus::operator != (const AppStateChangeStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool AppStateChangeStatus::operator < (const AppStateChangeStatus& rhs) const {
    if (hasU32AppId() || rhs.hasU32AppId()) {
        if (getU32AppId() < rhs.getU32AppId()) return true;
        if (getU32AppId() > rhs.getU32AppId()) return false;
    }
    if (hasU32State() || rhs.hasU32State()) {
        if (getU32State() < rhs.getU32State()) return true;
        if (getU32State() > rhs.getU32State()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AppStateChangeStatus::clone() {
    return new AppStateChangeStatus(*this);
}

inline bool AppStateChangeStatus::operator > (const AppStateChangeStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AppStateChangeStatus::clear() {
    clearU32AppId();
    clearU32State();
}

inline void AppStateChangeStatus::clearU32AppId() {
    if (hasU32AppId()) {
         clear_has_u32AppId();
        _u32AppId = 0u;
     }
}

inline bool AppStateChangeStatus::hasU32AppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 AppStateChangeStatus::getU32AppId () const {
    return _u32AppId;
}

inline void AppStateChangeStatus::setU32AppId (uint32 u32AppId_) {
    set_has_u32AppId();
    this->_u32AppId = u32AppId_;
}

inline void AppStateChangeStatus::clearU32State() {
    if (hasU32State()) {
         clear_has_u32State();
        _u32State = 0u;
     }
}

inline bool AppStateChangeStatus::hasU32State () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 AppStateChangeStatus::getU32State () const {
    return _u32State;
}

inline void AppStateChangeStatus::setU32State (uint32 u32State_) {
    set_has_u32State();
    this->_u32State = u32State_;
}

inline void AppStateChangeStatus::set_has_u32AppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void AppStateChangeStatus::clear_has_u32AppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AppStateChangeStatus::set_has_u32State () {
    _has_bits_[0] |= 1u << 1;
}

inline void AppStateChangeStatus::clear_has_u32State () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  AppStateChangeSet::AppStateChangeSet ()  :
    _u32AppId (0u),
    _u32State (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AppStateChangeSet::AppStateChangeSet (const AppStateChangeSet &rhs)  :
    ::asf::core::Payload(rhs),
    _u32AppId (0u),
    _u32State (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AppStateChangeSet::AppStateChangeSet (uint32 u32AppId_, uint32 u32State_)  :
    _u32AppId (u32AppId_),
    _u32State (u32State_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AppStateChangeSet::~AppStateChangeSet() {
}

inline AppStateChangeSet& AppStateChangeSet::operator = (const AppStateChangeSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU32AppId()) {
            setU32AppId(rhs.getU32AppId());
        } else {
            clearU32AppId();
        }
        if (rhs.hasU32State()) {
            setU32State(rhs.getU32State());
        } else {
            clearU32State();
        }
    }
    return *this;
}

inline bool AppStateChangeSet::operator == (const AppStateChangeSet& rhs) const {
    return (((!hasU32AppId() && !rhs.hasU32AppId()) || getU32AppId() == rhs.getU32AppId()) &&
        ((!hasU32State() && !rhs.hasU32State()) || getU32State() == rhs.getU32State()));
}

inline bool AppStateChangeSet::operator != (const AppStateChangeSet& rhs) const {
    return ! (*this == rhs);
}

inline bool AppStateChangeSet::operator < (const AppStateChangeSet& rhs) const {
    if (hasU32AppId() || rhs.hasU32AppId()) {
        if (getU32AppId() < rhs.getU32AppId()) return true;
        if (getU32AppId() > rhs.getU32AppId()) return false;
    }
    if (hasU32State() || rhs.hasU32State()) {
        if (getU32State() < rhs.getU32State()) return true;
        if (getU32State() > rhs.getU32State()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AppStateChangeSet::clone() {
    return new AppStateChangeSet(*this);
}

inline bool AppStateChangeSet::operator > (const AppStateChangeSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AppStateChangeSet::clear() {
    clearU32AppId();
    clearU32State();
}

inline void AppStateChangeSet::clearU32AppId() {
    if (hasU32AppId()) {
         clear_has_u32AppId();
        _u32AppId = 0u;
     }
}

inline bool AppStateChangeSet::hasU32AppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 AppStateChangeSet::getU32AppId () const {
    return _u32AppId;
}

inline void AppStateChangeSet::setU32AppId (uint32 u32AppId_) {
    set_has_u32AppId();
    this->_u32AppId = u32AppId_;
}

inline void AppStateChangeSet::clearU32State() {
    if (hasU32State()) {
         clear_has_u32State();
        _u32State = 0u;
     }
}

inline bool AppStateChangeSet::hasU32State () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 AppStateChangeSet::getU32State () const {
    return _u32State;
}

inline void AppStateChangeSet::setU32State (uint32 u32State_) {
    set_has_u32State();
    this->_u32State = u32State_;
}

inline void AppStateChangeSet::set_has_u32AppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void AppStateChangeSet::clear_has_u32AppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AppStateChangeSet::set_has_u32State () {
    _has_bits_[0] |= 1u << 1;
}

inline void AppStateChangeSet::clear_has_u32State () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  AppEndStatus::AppEndStatus ()  :
    _u32AppId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AppEndStatus::AppEndStatus (const AppEndStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _u32AppId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AppEndStatus::AppEndStatus (uint32 u32AppId_)  :
    _u32AppId (u32AppId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AppEndStatus::~AppEndStatus() {
}

inline AppEndStatus& AppEndStatus::operator = (const AppEndStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU32AppId()) {
            setU32AppId(rhs.getU32AppId());
        } else {
            clearU32AppId();
        }
    }
    return *this;
}

inline bool AppEndStatus::operator == (const AppEndStatus& rhs) const {
    return (((!hasU32AppId() && !rhs.hasU32AppId()) || getU32AppId() == rhs.getU32AppId()));
}

inline bool AppEndStatus::operator != (const AppEndStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool AppEndStatus::operator < (const AppEndStatus& rhs) const {
    if (hasU32AppId() || rhs.hasU32AppId()) {
        if (getU32AppId() < rhs.getU32AppId()) return true;
        if (getU32AppId() > rhs.getU32AppId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AppEndStatus::clone() {
    return new AppEndStatus(*this);
}

inline bool AppEndStatus::operator > (const AppEndStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AppEndStatus::clear() {
    clearU32AppId();
}

inline void AppEndStatus::clearU32AppId() {
    if (hasU32AppId()) {
         clear_has_u32AppId();
        _u32AppId = 0u;
     }
}

inline bool AppEndStatus::hasU32AppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 AppEndStatus::getU32AppId () const {
    return _u32AppId;
}

inline void AppEndStatus::setU32AppId (uint32 u32AppId_) {
    set_has_u32AppId();
    this->_u32AppId = u32AppId_;
}

inline void AppEndStatus::set_has_u32AppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void AppEndStatus::clear_has_u32AppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AppEndSet::AppEndSet ()  :
    _u32AppId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AppEndSet::AppEndSet (const AppEndSet &rhs)  :
    ::asf::core::Payload(rhs),
    _u32AppId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AppEndSet::AppEndSet (uint32 u32AppId_)  :
    _u32AppId (u32AppId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AppEndSet::~AppEndSet() {
}

inline AppEndSet& AppEndSet::operator = (const AppEndSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU32AppId()) {
            setU32AppId(rhs.getU32AppId());
        } else {
            clearU32AppId();
        }
    }
    return *this;
}

inline bool AppEndSet::operator == (const AppEndSet& rhs) const {
    return (((!hasU32AppId() && !rhs.hasU32AppId()) || getU32AppId() == rhs.getU32AppId()));
}

inline bool AppEndSet::operator != (const AppEndSet& rhs) const {
    return ! (*this == rhs);
}

inline bool AppEndSet::operator < (const AppEndSet& rhs) const {
    if (hasU32AppId() || rhs.hasU32AppId()) {
        if (getU32AppId() < rhs.getU32AppId()) return true;
        if (getU32AppId() > rhs.getU32AppId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AppEndSet::clone() {
    return new AppEndSet(*this);
}

inline bool AppEndSet::operator > (const AppEndSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AppEndSet::clear() {
    clearU32AppId();
}

inline void AppEndSet::clearU32AppId() {
    if (hasU32AppId()) {
         clear_has_u32AppId();
        _u32AppId = 0u;
     }
}

inline bool AppEndSet::hasU32AppId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 AppEndSet::getU32AppId () const {
    return _u32AppId;
}

inline void AppEndSet::setU32AppId (uint32 u32AppId_) {
    set_has_u32AppId();
    this->_u32AppId = u32AppId_;
}

inline void AppEndSet::set_has_u32AppId () {
    _has_bits_[0] |= 1u << 0;
}

inline void AppEndSet::clear_has_u32AppId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NewServiceLoadedStatus::NewServiceLoadedStatus ()  :
    _strServiceName (),
    _strBlockName (),
    _u32AppId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NewServiceLoadedStatus::NewServiceLoadedStatus (const NewServiceLoadedStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _strServiceName (),
    _strBlockName (),
    _u32AppId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NewServiceLoadedStatus::NewServiceLoadedStatus (const ::std::string& strServiceName_, const ::std::string& strBlockName_, uint32 u32AppId_)  :
    _strServiceName (strServiceName_),
    _strBlockName (strBlockName_),
    _u32AppId (u32AppId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strServiceName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strBlockName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NewServiceLoadedStatus::~NewServiceLoadedStatus() {
}

inline NewServiceLoadedStatus& NewServiceLoadedStatus::operator = (const NewServiceLoadedStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStrServiceName()) {
            setStrServiceName(rhs.getStrServiceName());
        } else {
            clearStrServiceName();
        }
        if (rhs.hasStrBlockName()) {
            setStrBlockName(rhs.getStrBlockName());
        } else {
            clearStrBlockName();
        }
        if (rhs.hasU32AppId()) {
            setU32AppId(rhs.getU32AppId());
        } else {
            clearU32AppId();
        }
    }
    return *this;
}

inline bool NewServiceLoadedStatus::operator == (const NewServiceLoadedStatus& rhs) const {
    return (((!hasStrServiceName() && !rhs.hasStrServiceName()) || getStrServiceName() == rhs.getStrServiceName()) &&
        ((!hasStrBlockName() && !rhs.hasStrBlockName()) || getStrBlockName() == rhs.getStrBlockName()) &&
        ((!hasU32AppId() && !rhs.hasU32AppId()) || getU32AppId() == rhs.getU32AppId()));
}

inline bool NewServiceLoadedStatus::operator != (const NewServiceLoadedStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool NewServiceLoadedStatus::operator < (const NewServiceLoadedStatus& rhs) const {
    if (hasStrServiceName() || rhs.hasStrServiceName()) {
        if (getStrServiceName() < rhs.getStrServiceName()) return true;
        if (getStrServiceName() > rhs.getStrServiceName()) return false;
    }
    if (hasStrBlockName() || rhs.hasStrBlockName()) {
        if (getStrBlockName() < rhs.getStrBlockName()) return true;
        if (getStrBlockName() > rhs.getStrBlockName()) return false;
    }
    if (hasU32AppId() || rhs.hasU32AppId()) {
        if (getU32AppId() < rhs.getU32AppId()) return true;
        if (getU32AppId() > rhs.getU32AppId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NewServiceLoadedStatus::clone() {
    return new NewServiceLoadedStatus(*this);
}

inline bool NewServiceLoadedStatus::operator > (const NewServiceLoadedStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NewServiceLoadedStatus::clear() {
    clearStrServiceName();
    clearStrBlockName();
    clearU32AppId();
}

inline void NewServiceLoadedStatus::clearStrServiceName() {
    if (hasStrServiceName()) {
         clear_has_strServiceName();
        _strServiceName.clear();
     }
}

inline bool NewServiceLoadedStatus::hasStrServiceName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& NewServiceLoadedStatus::getStrServiceName () const {
    return _strServiceName;
}

inline ::std::string& NewServiceLoadedStatus::getStrServiceNameMutable () {
    set_has_strServiceName();
    return _strServiceName;
}

inline void NewServiceLoadedStatus::setStrServiceName (const ::std::string& strServiceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strServiceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strServiceName();
    this->_strServiceName = strServiceName_;
}

inline void NewServiceLoadedStatus::setStrServiceName (const char* strServiceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strServiceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strServiceName();
    this->_strServiceName.assign(strServiceName_);
}

inline void NewServiceLoadedStatus::setStrServiceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strServiceName();
    this->_strServiceName.assign(value, size);
}

inline void NewServiceLoadedStatus::clearStrBlockName() {
    if (hasStrBlockName()) {
         clear_has_strBlockName();
        _strBlockName.clear();
     }
}

inline bool NewServiceLoadedStatus::hasStrBlockName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& NewServiceLoadedStatus::getStrBlockName () const {
    return _strBlockName;
}

inline ::std::string& NewServiceLoadedStatus::getStrBlockNameMutable () {
    set_has_strBlockName();
    return _strBlockName;
}

inline void NewServiceLoadedStatus::setStrBlockName (const ::std::string& strBlockName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strBlockName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strBlockName();
    this->_strBlockName = strBlockName_;
}

inline void NewServiceLoadedStatus::setStrBlockName (const char* strBlockName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strBlockName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strBlockName();
    this->_strBlockName.assign(strBlockName_);
}

inline void NewServiceLoadedStatus::setStrBlockName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strBlockName();
    this->_strBlockName.assign(value, size);
}

inline void NewServiceLoadedStatus::clearU32AppId() {
    if (hasU32AppId()) {
         clear_has_u32AppId();
        _u32AppId = 0u;
     }
}

inline bool NewServiceLoadedStatus::hasU32AppId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 NewServiceLoadedStatus::getU32AppId () const {
    return _u32AppId;
}

inline void NewServiceLoadedStatus::setU32AppId (uint32 u32AppId_) {
    set_has_u32AppId();
    this->_u32AppId = u32AppId_;
}

inline void NewServiceLoadedStatus::set_has_strServiceName () {
    _has_bits_[0] |= 1u << 0;
}

inline void NewServiceLoadedStatus::clear_has_strServiceName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void NewServiceLoadedStatus::set_has_strBlockName () {
    _has_bits_[0] |= 1u << 1;
}

inline void NewServiceLoadedStatus::clear_has_strBlockName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void NewServiceLoadedStatus::set_has_u32AppId () {
    _has_bits_[0] |= 1u << 2;
}

inline void NewServiceLoadedStatus::clear_has_u32AppId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  FailedServicesListStatus::FailedServicesListStatus ()  :
    _tServices ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FailedServicesListStatus::FailedServicesListStatus (const FailedServicesListStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _tServices ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FailedServicesListStatus::FailedServicesListStatus (const ::lcm_dbusctrl_fi_types::T_SPM_ServiceList& tServices_)  :
    _tServices (tServices_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FailedServicesListStatus::~FailedServicesListStatus() {
}

inline FailedServicesListStatus& FailedServicesListStatus::operator = (const FailedServicesListStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTServices()) {
            setTServices(rhs.getTServices());
        } else {
            clearTServices();
        }
    }
    return *this;
}

inline bool FailedServicesListStatus::operator == (const FailedServicesListStatus& rhs) const {
    return (((!hasTServices() && !rhs.hasTServices()) || getTServices() == rhs.getTServices()));
}

inline bool FailedServicesListStatus::operator != (const FailedServicesListStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool FailedServicesListStatus::operator < (const FailedServicesListStatus& rhs) const {
    if (hasTServices() || rhs.hasTServices()) {
        if (getTServices() < rhs.getTServices()) return true;
        if (getTServices() > rhs.getTServices()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FailedServicesListStatus::clone() {
    return new FailedServicesListStatus(*this);
}

inline bool FailedServicesListStatus::operator > (const FailedServicesListStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FailedServicesListStatus::clear() {
    clearTServices();
}

inline void FailedServicesListStatus::clearTServices() {
    if (hasTServices()) {
         clear_has_tServices();
        _tServices.clear();
     }
}

inline bool FailedServicesListStatus::hasTServices () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::lcm_dbusctrl_fi_types::T_SPM_ServiceList& FailedServicesListStatus::getTServices () const {
    return _tServices;
}

inline ::lcm_dbusctrl_fi_types::T_SPM_ServiceList& FailedServicesListStatus::getTServicesMutable () {
    set_has_tServices();
    return _tServices;
}

inline void FailedServicesListStatus::setTServices (const ::lcm_dbusctrl_fi_types::T_SPM_ServiceList& tServices_) {
    set_has_tServices();
    this->_tServices = tServices_;
}

inline void FailedServicesListStatus::set_has_tServices () {
    _has_bits_[0] |= 1u << 0;
}

inline void FailedServicesListStatus::clear_has_tServices () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NewProcessIdStatus::NewProcessIdStatus ()  :
    _strBlockName (),
    _strServiceName (),
    _u32ProcessId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NewProcessIdStatus::NewProcessIdStatus (const NewProcessIdStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _strBlockName (),
    _strServiceName (),
    _u32ProcessId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NewProcessIdStatus::NewProcessIdStatus (const ::std::string& strBlockName_, const ::std::string& strServiceName_, uint32 u32ProcessId_)  :
    _strBlockName (strBlockName_),
    _strServiceName (strServiceName_),
    _u32ProcessId (u32ProcessId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strBlockName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strServiceName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NewProcessIdStatus::~NewProcessIdStatus() {
}

inline NewProcessIdStatus& NewProcessIdStatus::operator = (const NewProcessIdStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStrBlockName()) {
            setStrBlockName(rhs.getStrBlockName());
        } else {
            clearStrBlockName();
        }
        if (rhs.hasStrServiceName()) {
            setStrServiceName(rhs.getStrServiceName());
        } else {
            clearStrServiceName();
        }
        if (rhs.hasU32ProcessId()) {
            setU32ProcessId(rhs.getU32ProcessId());
        } else {
            clearU32ProcessId();
        }
    }
    return *this;
}

inline bool NewProcessIdStatus::operator == (const NewProcessIdStatus& rhs) const {
    return (((!hasStrBlockName() && !rhs.hasStrBlockName()) || getStrBlockName() == rhs.getStrBlockName()) &&
        ((!hasStrServiceName() && !rhs.hasStrServiceName()) || getStrServiceName() == rhs.getStrServiceName()) &&
        ((!hasU32ProcessId() && !rhs.hasU32ProcessId()) || getU32ProcessId() == rhs.getU32ProcessId()));
}

inline bool NewProcessIdStatus::operator != (const NewProcessIdStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool NewProcessIdStatus::operator < (const NewProcessIdStatus& rhs) const {
    if (hasStrBlockName() || rhs.hasStrBlockName()) {
        if (getStrBlockName() < rhs.getStrBlockName()) return true;
        if (getStrBlockName() > rhs.getStrBlockName()) return false;
    }
    if (hasStrServiceName() || rhs.hasStrServiceName()) {
        if (getStrServiceName() < rhs.getStrServiceName()) return true;
        if (getStrServiceName() > rhs.getStrServiceName()) return false;
    }
    if (hasU32ProcessId() || rhs.hasU32ProcessId()) {
        if (getU32ProcessId() < rhs.getU32ProcessId()) return true;
        if (getU32ProcessId() > rhs.getU32ProcessId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NewProcessIdStatus::clone() {
    return new NewProcessIdStatus(*this);
}

inline bool NewProcessIdStatus::operator > (const NewProcessIdStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NewProcessIdStatus::clear() {
    clearStrBlockName();
    clearStrServiceName();
    clearU32ProcessId();
}

inline void NewProcessIdStatus::clearStrBlockName() {
    if (hasStrBlockName()) {
         clear_has_strBlockName();
        _strBlockName.clear();
     }
}

inline bool NewProcessIdStatus::hasStrBlockName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& NewProcessIdStatus::getStrBlockName () const {
    return _strBlockName;
}

inline ::std::string& NewProcessIdStatus::getStrBlockNameMutable () {
    set_has_strBlockName();
    return _strBlockName;
}

inline void NewProcessIdStatus::setStrBlockName (const ::std::string& strBlockName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strBlockName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strBlockName();
    this->_strBlockName = strBlockName_;
}

inline void NewProcessIdStatus::setStrBlockName (const char* strBlockName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strBlockName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strBlockName();
    this->_strBlockName.assign(strBlockName_);
}

inline void NewProcessIdStatus::setStrBlockName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strBlockName();
    this->_strBlockName.assign(value, size);
}

inline void NewProcessIdStatus::clearStrServiceName() {
    if (hasStrServiceName()) {
         clear_has_strServiceName();
        _strServiceName.clear();
     }
}

inline bool NewProcessIdStatus::hasStrServiceName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& NewProcessIdStatus::getStrServiceName () const {
    return _strServiceName;
}

inline ::std::string& NewProcessIdStatus::getStrServiceNameMutable () {
    set_has_strServiceName();
    return _strServiceName;
}

inline void NewProcessIdStatus::setStrServiceName (const ::std::string& strServiceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strServiceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strServiceName();
    this->_strServiceName = strServiceName_;
}

inline void NewProcessIdStatus::setStrServiceName (const char* strServiceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strServiceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strServiceName();
    this->_strServiceName.assign(strServiceName_);
}

inline void NewProcessIdStatus::setStrServiceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strServiceName();
    this->_strServiceName.assign(value, size);
}

inline void NewProcessIdStatus::clearU32ProcessId() {
    if (hasU32ProcessId()) {
         clear_has_u32ProcessId();
        _u32ProcessId = 0u;
     }
}

inline bool NewProcessIdStatus::hasU32ProcessId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 NewProcessIdStatus::getU32ProcessId () const {
    return _u32ProcessId;
}

inline void NewProcessIdStatus::setU32ProcessId (uint32 u32ProcessId_) {
    set_has_u32ProcessId();
    this->_u32ProcessId = u32ProcessId_;
}

inline void NewProcessIdStatus::set_has_strBlockName () {
    _has_bits_[0] |= 1u << 0;
}

inline void NewProcessIdStatus::clear_has_strBlockName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void NewProcessIdStatus::set_has_strServiceName () {
    _has_bits_[0] |= 1u << 1;
}

inline void NewProcessIdStatus::clear_has_strServiceName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void NewProcessIdStatus::set_has_u32ProcessId () {
    _has_bits_[0] |= 1u << 2;
}

inline void NewProcessIdStatus::clear_has_u32ProcessId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  StartupFailureIndicationStatus::StartupFailureIndicationStatus ()  :
    _tStartupFailureInd ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartupFailureIndicationStatus::StartupFailureIndicationStatus (const StartupFailureIndicationStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _tStartupFailureInd ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartupFailureIndicationStatus::StartupFailureIndicationStatus (const ::lcm_dbusctrl_fi_types::T_StartupFailureInfo& tStartupFailureInd_)  :
    _tStartupFailureInd (tStartupFailureInd_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartupFailureIndicationStatus::~StartupFailureIndicationStatus() {
}

inline StartupFailureIndicationStatus& StartupFailureIndicationStatus::operator = (const StartupFailureIndicationStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTStartupFailureInd()) {
            setTStartupFailureInd(rhs.getTStartupFailureInd());
        } else {
            clearTStartupFailureInd();
        }
    }
    return *this;
}

inline bool StartupFailureIndicationStatus::operator == (const StartupFailureIndicationStatus& rhs) const {
    return (((!hasTStartupFailureInd() && !rhs.hasTStartupFailureInd()) || getTStartupFailureInd() == rhs.getTStartupFailureInd()));
}

inline bool StartupFailureIndicationStatus::operator != (const StartupFailureIndicationStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool StartupFailureIndicationStatus::operator < (const StartupFailureIndicationStatus& rhs) const {
    if (hasTStartupFailureInd() || rhs.hasTStartupFailureInd()) {
        if (getTStartupFailureInd() < rhs.getTStartupFailureInd()) return true;
        if (getTStartupFailureInd() > rhs.getTStartupFailureInd()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartupFailureIndicationStatus::clone() {
    return new StartupFailureIndicationStatus(*this);
}

inline bool StartupFailureIndicationStatus::operator > (const StartupFailureIndicationStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartupFailureIndicationStatus::clear() {
    clearTStartupFailureInd();
}

inline void StartupFailureIndicationStatus::clearTStartupFailureInd() {
    if (hasTStartupFailureInd()) {
         clear_has_tStartupFailureInd();
        _tStartupFailureInd.clear();
     }
}

inline bool StartupFailureIndicationStatus::hasTStartupFailureInd () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::lcm_dbusctrl_fi_types::T_StartupFailureInfo& StartupFailureIndicationStatus::getTStartupFailureInd () const {
    return _tStartupFailureInd;
}

inline ::lcm_dbusctrl_fi_types::T_StartupFailureInfo& StartupFailureIndicationStatus::getTStartupFailureIndMutable () {
    set_has_tStartupFailureInd();
    return _tStartupFailureInd;
}

inline void StartupFailureIndicationStatus::setTStartupFailureInd (const ::lcm_dbusctrl_fi_types::T_StartupFailureInfo& tStartupFailureInd_) {
    set_has_tStartupFailureInd();
    this->_tStartupFailureInd = tStartupFailureInd_;
}

inline void StartupFailureIndicationStatus::set_has_tStartupFailureInd () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartupFailureIndicationStatus::clear_has_tStartupFailureInd () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SupervisionStateChangeStatus::SupervisionStateChangeStatus ()  :
    _bSupervisionActive (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SupervisionStateChangeStatus::SupervisionStateChangeStatus (const SupervisionStateChangeStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _bSupervisionActive (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SupervisionStateChangeStatus::SupervisionStateChangeStatus (bool bSupervisionActive_)  :
    _bSupervisionActive (bSupervisionActive_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SupervisionStateChangeStatus::~SupervisionStateChangeStatus() {
}

inline SupervisionStateChangeStatus& SupervisionStateChangeStatus::operator = (const SupervisionStateChangeStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBSupervisionActive()) {
            setBSupervisionActive(rhs.getBSupervisionActive());
        } else {
            clearBSupervisionActive();
        }
    }
    return *this;
}

inline bool SupervisionStateChangeStatus::operator == (const SupervisionStateChangeStatus& rhs) const {
    return (((!hasBSupervisionActive() && !rhs.hasBSupervisionActive()) || getBSupervisionActive() == rhs.getBSupervisionActive()));
}

inline bool SupervisionStateChangeStatus::operator != (const SupervisionStateChangeStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SupervisionStateChangeStatus::operator < (const SupervisionStateChangeStatus& rhs) const {
    if (hasBSupervisionActive() || rhs.hasBSupervisionActive()) {
        if (getBSupervisionActive() < rhs.getBSupervisionActive()) return true;
        if (getBSupervisionActive() > rhs.getBSupervisionActive()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SupervisionStateChangeStatus::clone() {
    return new SupervisionStateChangeStatus(*this);
}

inline bool SupervisionStateChangeStatus::operator > (const SupervisionStateChangeStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SupervisionStateChangeStatus::clear() {
    clearBSupervisionActive();
}

inline void SupervisionStateChangeStatus::clearBSupervisionActive() {
    if (hasBSupervisionActive()) {
         clear_has_bSupervisionActive();
        _bSupervisionActive = false;
     }
}

inline bool SupervisionStateChangeStatus::hasBSupervisionActive () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SupervisionStateChangeStatus::getBSupervisionActive () const {
    return _bSupervisionActive;
}

inline void SupervisionStateChangeStatus::setBSupervisionActive (bool bSupervisionActive_) {
    set_has_bSupervisionActive();
    this->_bSupervisionActive = bSupervisionActive_;
}

inline void SupervisionStateChangeStatus::set_has_bSupervisionActive () {
    _has_bits_[0] |= 1u << 0;
}

inline void SupervisionStateChangeStatus::clear_has_bSupervisionActive () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SupervisionStateChangeSet::SupervisionStateChangeSet ()  :
    _bSupervisionActive (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SupervisionStateChangeSet::SupervisionStateChangeSet (const SupervisionStateChangeSet &rhs)  :
    ::asf::core::Payload(rhs),
    _bSupervisionActive (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SupervisionStateChangeSet::SupervisionStateChangeSet (bool bSupervisionActive_)  :
    _bSupervisionActive (bSupervisionActive_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SupervisionStateChangeSet::~SupervisionStateChangeSet() {
}

inline SupervisionStateChangeSet& SupervisionStateChangeSet::operator = (const SupervisionStateChangeSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBSupervisionActive()) {
            setBSupervisionActive(rhs.getBSupervisionActive());
        } else {
            clearBSupervisionActive();
        }
    }
    return *this;
}

inline bool SupervisionStateChangeSet::operator == (const SupervisionStateChangeSet& rhs) const {
    return (((!hasBSupervisionActive() && !rhs.hasBSupervisionActive()) || getBSupervisionActive() == rhs.getBSupervisionActive()));
}

inline bool SupervisionStateChangeSet::operator != (const SupervisionStateChangeSet& rhs) const {
    return ! (*this == rhs);
}

inline bool SupervisionStateChangeSet::operator < (const SupervisionStateChangeSet& rhs) const {
    if (hasBSupervisionActive() || rhs.hasBSupervisionActive()) {
        if (getBSupervisionActive() < rhs.getBSupervisionActive()) return true;
        if (getBSupervisionActive() > rhs.getBSupervisionActive()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SupervisionStateChangeSet::clone() {
    return new SupervisionStateChangeSet(*this);
}

inline bool SupervisionStateChangeSet::operator > (const SupervisionStateChangeSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SupervisionStateChangeSet::clear() {
    clearBSupervisionActive();
}

inline void SupervisionStateChangeSet::clearBSupervisionActive() {
    if (hasBSupervisionActive()) {
         clear_has_bSupervisionActive();
        _bSupervisionActive = false;
     }
}

inline bool SupervisionStateChangeSet::hasBSupervisionActive () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SupervisionStateChangeSet::getBSupervisionActive () const {
    return _bSupervisionActive;
}

inline void SupervisionStateChangeSet::setBSupervisionActive (bool bSupervisionActive_) {
    set_has_bSupervisionActive();
    this->_bSupervisionActive = bSupervisionActive_;
}

inline void SupervisionStateChangeSet::set_has_bSupervisionActive () {
    _has_bits_[0] |= 1u << 0;
}

inline void SupervisionStateChangeSet::clear_has_bSupervisionActive () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace lcm_dbusctrl_fi

#endif // LCM_DBUSCTRL_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
