/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_LCM_DBUS_FI_LCM_DBUS_FI_SERVICESTUB_H
#define ORG_BOSCH_CM_LCM_DBUS_FI_LCM_DBUS_FI_SERVICESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/lcm_dbus_fi/lcm_dbus_fi_service.h"
#include "org/bosch/cm/lcm_dbus_fi/lcm_dbus_fi_serviceConst.h"
#include <string>
#include <vector>

namespace org {
namespace bosch {
namespace cm {
namespace lcm_dbus_fi {
namespace lcm_dbus_fi_service {

class Lcm_dbus_fi_serviceStubDelegate;

class Lcm_dbus_fi_serviceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the Lcm_dbus_fi_serviceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    Lcm_dbus_fi_serviceStub (const std::string& portName);

    /**
     * Create an instance of the Lcm_dbus_fi_serviceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    Lcm_dbus_fi_serviceStub (const std::string& portName, const std::string& objectPath);

    virtual ~Lcm_dbus_fi_serviceStub();

    // property 'SystemState'

    /**
     * The method onSystemStateGet() is called by ASF when a client invokes
     * the read method for the property 'SystemState'. The onSystemStateGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'SystemState'</b>:
     *
     * Informs about system state changes. Update is send when a new system state has reached (all applications have acknowledged requested application state).  (CCA FID: 0x0001)
     */
    virtual void onSystemStateGet(const ::boost::shared_ptr< SystemStateGet >& payload);

    /**
     * Sends back the update to a previous onSystemStateGet().
     *
     * <b>Documentation of 'SystemState'</b>:
     *
     * Informs about system state changes. Update is send when a new system state has reached (all applications have acknowledged requested application state).  (CCA FID: 0x0001)
     *
     * @param act Identifies a previous invocation of onSystemStateGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSystemStateGetUpdate(T_SPM_e32_SYSTEM_STATES systemState, act_t act = 0);

    /**
     * Set the value of the property 'SystemState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SystemState'</b>:
     *
     * Informs about system state changes. Update is send when a new system state has reached (all applications have acknowledged requested application state).  (CCA FID: 0x0001)
     */
    void setSystemState(T_SPM_e32_SYSTEM_STATES systemState);

    /**
     * Returns the current value of the property 'SystemState'.
     *
     * <b>Documentation of 'SystemState'</b>:
     *
     * Informs about system state changes. Update is send when a new system state has reached (all applications have acknowledged requested application state).  (CCA FID: 0x0001)
     */
    T_SPM_e32_SYSTEM_STATES getSystemState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSystemStateUpdate().
     *
     * <b>Documentation of 'SystemState'</b>:
     *
     * Informs about system state changes. Update is send when a new system state has reached (all applications have acknowledged requested application state).  (CCA FID: 0x0001)
     */
    void sendSystemStateUpdate();

    // property 'DownloadLockStates'

    /**
     * The method onDownloadLockStatesGet() is called by ASF when a client
     * invokes the read method for the property 'DownloadLockStates'. The
     * onDownloadLockStatesGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'DownloadLockStates'</b>:
     *
     * !!! OBSOLETE DO NOT USE ANYMORE !!! !!! replaced by UpdateLockStates !!! Current state of the DownloadLock. Will return a list of the current CCA application ID of the owner of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.  (CCA FID: 0x1002)
     */
    virtual void onDownloadLockStatesGet(const ::boost::shared_ptr< DownloadLockStatesGet >& payload);

    /**
     * Sends back the update to a previous onDownloadLockStatesGet().
     *
     * <b>Documentation of 'DownloadLockStates'</b>:
     *
     * !!! OBSOLETE DO NOT USE ANYMORE !!! !!! replaced by UpdateLockStates !!! Current state of the DownloadLock. Will return a list of the current CCA application ID of the owner of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.  (CCA FID: 0x1002)
     *
     * @param act Identifies a previous invocation of
     * onDownloadLockStatesGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDownloadLockStatesGetUpdate(const ::std::vector< T_SPM_RestrictedDlLock >& downloadLockStates, act_t act = 0);

    /**
     * Set the value of the property 'DownloadLockStates' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'DownloadLockStates'</b>:
     *
     * !!! OBSOLETE DO NOT USE ANYMORE !!! !!! replaced by UpdateLockStates !!! Current state of the DownloadLock. Will return a list of the current CCA application ID of the owner of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.  (CCA FID: 0x1002)
     */
    void setDownloadLockStates(const ::std::vector< T_SPM_RestrictedDlLock >& downloadLockStates);

    /**
     * Returns the current value of the property 'DownloadLockStates'.
     *
     * <b>Documentation of 'DownloadLockStates'</b>:
     *
     * !!! OBSOLETE DO NOT USE ANYMORE !!! !!! replaced by UpdateLockStates !!! Current state of the DownloadLock. Will return a list of the current CCA application ID of the owner of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.  (CCA FID: 0x1002)
     */
    const ::std::vector< T_SPM_RestrictedDlLock >& getDownloadLockStates() const;

    /**
     * Returns the current value of the property 'DownloadLockStates' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendDownloadLockStatesUpdate() method.
     *
     * <b>Documentation of 'DownloadLockStates'</b>:
     *
     * !!! OBSOLETE DO NOT USE ANYMORE !!! !!! replaced by UpdateLockStates !!! Current state of the DownloadLock. Will return a list of the current CCA application ID of the owner of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.  (CCA FID: 0x1002)
     */
    ::std::vector< T_SPM_RestrictedDlLock >& getDownloadLockStatesMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDownloadLockStatesUpdate().
     *
     * <b>Documentation of 'DownloadLockStates'</b>:
     *
     * !!! OBSOLETE DO NOT USE ANYMORE !!! !!! replaced by UpdateLockStates !!! Current state of the DownloadLock. Will return a list of the current CCA application ID of the owner of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.  (CCA FID: 0x1002)
     */
    void sendDownloadLockStatesUpdate();

    // property 'UpdateLockStates'

    /**
     * The method onUpdateLockStatesGet() is called by ASF when a client
     * invokes the read method for the property 'UpdateLockStates'. The
     * onUpdateLockStatesGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'UpdateLockStates'</b>:
     *
     * Current state of the Locks. Will return a list of the current CCA application ID of the owner and users of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.  (CCA FID: 0x1004)
     */
    virtual void onUpdateLockStatesGet(const ::boost::shared_ptr< UpdateLockStatesGet >& payload);

    /**
     * Sends back the update to a previous onUpdateLockStatesGet().
     *
     * <b>Documentation of 'UpdateLockStates'</b>:
     *
     * Current state of the Locks. Will return a list of the current CCA application ID of the owner and users of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.  (CCA FID: 0x1004)
     *
     * @param act Identifies a previous invocation of onUpdateLockStatesGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendUpdateLockStatesGetUpdate(const ::std::vector< T_SPM_UpdateLockState >& updateLockStates, act_t act = 0);

    /**
     * Set the value of the property 'UpdateLockStates' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'UpdateLockStates'</b>:
     *
     * Current state of the Locks. Will return a list of the current CCA application ID of the owner and users of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.  (CCA FID: 0x1004)
     */
    void setUpdateLockStates(const ::std::vector< T_SPM_UpdateLockState >& updateLockStates);

    /**
     * Returns the current value of the property 'UpdateLockStates'.
     *
     * <b>Documentation of 'UpdateLockStates'</b>:
     *
     * Current state of the Locks. Will return a list of the current CCA application ID of the owner and users of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.  (CCA FID: 0x1004)
     */
    const ::std::vector< T_SPM_UpdateLockState >& getUpdateLockStates() const;

    /**
     * Returns the current value of the property 'UpdateLockStates' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendUpdateLockStatesUpdate() method.
     *
     * <b>Documentation of 'UpdateLockStates'</b>:
     *
     * Current state of the Locks. Will return a list of the current CCA application ID of the owner and users of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.  (CCA FID: 0x1004)
     */
    ::std::vector< T_SPM_UpdateLockState >& getUpdateLockStatesMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendUpdateLockStatesUpdate().
     *
     * <b>Documentation of 'UpdateLockStates'</b>:
     *
     * Current state of the Locks. Will return a list of the current CCA application ID of the owner and users of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.  (CCA FID: 0x1004)
     */
    void sendUpdateLockStatesUpdate();

    // property 'ActiveOnOffTrigger'

    /**
     * The method onActiveOnOffTriggerGet() is called by ASF when a client
     * invokes the read method for the property 'ActiveOnOffTrigger'. The
     * onActiveOnOffTriggerGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'ActiveOnOffTrigger'</b>:
     *
     * A list of all active trigger. (CCA FID: 0x110f)
     */
    virtual void onActiveOnOffTriggerGet(const ::boost::shared_ptr< ActiveOnOffTriggerGet >& payload);

    /**
     * Sends back the update to a previous onActiveOnOffTriggerGet().
     *
     * <b>Documentation of 'ActiveOnOffTrigger'</b>:
     *
     * A list of all active trigger. (CCA FID: 0x110f)
     *
     * @param act Identifies a previous invocation of
     * onActiveOnOffTriggerGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendActiveOnOffTriggerGetUpdate(const ::std::vector< T_SPM_e32_SubStateType >& activeOnOffTrigger, act_t act = 0);

    /**
     * Set the value of the property 'ActiveOnOffTrigger' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ActiveOnOffTrigger'</b>:
     *
     * A list of all active trigger. (CCA FID: 0x110f)
     */
    void setActiveOnOffTrigger(const ::std::vector< T_SPM_e32_SubStateType >& activeOnOffTrigger);

    /**
     * Returns the current value of the property 'ActiveOnOffTrigger'.
     *
     * <b>Documentation of 'ActiveOnOffTrigger'</b>:
     *
     * A list of all active trigger. (CCA FID: 0x110f)
     */
    const ::std::vector< T_SPM_e32_SubStateType >& getActiveOnOffTrigger() const;

    /**
     * Returns the current value of the property 'ActiveOnOffTrigger' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendActiveOnOffTriggerUpdate() method.
     *
     * <b>Documentation of 'ActiveOnOffTrigger'</b>:
     *
     * A list of all active trigger. (CCA FID: 0x110f)
     */
    ::std::vector< T_SPM_e32_SubStateType >& getActiveOnOffTriggerMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendActiveOnOffTriggerUpdate().
     *
     * <b>Documentation of 'ActiveOnOffTrigger'</b>:
     *
     * A list of all active trigger. (CCA FID: 0x110f)
     */
    void sendActiveOnOffTriggerUpdate();

    // property 'SubStates'

    /**
     * The method onSubStatesGet() is called by ASF when a client invokes the
     * read method for the property 'SubStates'. The onSubStatesGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'SubStates'</b>:
     *
     * (CCA FID: 0x000f)
     */
    virtual void onSubStatesGet(const ::boost::shared_ptr< SubStatesGet >& payload);

    /**
     * Sends back the update to a previous onSubStatesGet().
     *
     * <b>Documentation of 'SubStates'</b>:
     *
     * (CCA FID: 0x000f)
     *
     * @param act Identifies a previous invocation of onSubStatesGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSubStatesGetUpdate(const TSubStates& subStates, act_t act = 0);

    /**
     * Set the value of the property 'SubStates' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SubStates'</b>:
     *
     * (CCA FID: 0x000f)
     */
    void setSubStates(const TSubStates& subStates);

    /**
     * Returns the current value of the property 'SubStates'.
     *
     * <b>Documentation of 'SubStates'</b>:
     *
     * (CCA FID: 0x000f)
     */
    const TSubStates& getSubStates() const;

    /**
     * Returns the current value of the property 'SubStates' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendSubStatesUpdate() method.
     *
     * <b>Documentation of 'SubStates'</b>:
     *
     * (CCA FID: 0x000f)
     */
    TSubStates& getSubStatesMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSubStatesUpdate().
     *
     * <b>Documentation of 'SubStates'</b>:
     *
     * (CCA FID: 0x000f)
     */
    void sendSubStatesUpdate();

    // property 'HistoryTrigger'

    /**
     * The method onHistoryTriggerGet() is called by ASF when a client invokes
     * the read method for the property 'HistoryTrigger'. The
     * onHistoryTriggerGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'HistoryTrigger'</b>:
     *
     * A list of triggered states e.g. eject or insert. If trigger is seen once it will never be cleared from the list. (CCA FID: 0x20)
     */
    virtual void onHistoryTriggerGet(const ::boost::shared_ptr< HistoryTriggerGet >& payload);

    /**
     * Sends back the update to a previous onHistoryTriggerGet().
     *
     * <b>Documentation of 'HistoryTrigger'</b>:
     *
     * A list of triggered states e.g. eject or insert. If trigger is seen once it will never be cleared from the list. (CCA FID: 0x20)
     *
     * @param act Identifies a previous invocation of onHistoryTriggerGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendHistoryTriggerGetUpdate(const ::std::vector< T_SPM_HistoryTrigger >& historyTrigger, act_t act = 0);

    /**
     * Set the value of the property 'HistoryTrigger' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'HistoryTrigger'</b>:
     *
     * A list of triggered states e.g. eject or insert. If trigger is seen once it will never be cleared from the list. (CCA FID: 0x20)
     */
    void setHistoryTrigger(const ::std::vector< T_SPM_HistoryTrigger >& historyTrigger);

    /**
     * Returns the current value of the property 'HistoryTrigger'.
     *
     * <b>Documentation of 'HistoryTrigger'</b>:
     *
     * A list of triggered states e.g. eject or insert. If trigger is seen once it will never be cleared from the list. (CCA FID: 0x20)
     */
    const ::std::vector< T_SPM_HistoryTrigger >& getHistoryTrigger() const;

    /**
     * Returns the current value of the property 'HistoryTrigger' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendHistoryTriggerUpdate() method.
     *
     * <b>Documentation of 'HistoryTrigger'</b>:
     *
     * A list of triggered states e.g. eject or insert. If trigger is seen once it will never be cleared from the list. (CCA FID: 0x20)
     */
    ::std::vector< T_SPM_HistoryTrigger >& getHistoryTriggerMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendHistoryTriggerUpdate().
     *
     * <b>Documentation of 'HistoryTrigger'</b>:
     *
     * A list of triggered states e.g. eject or insert. If trigger is seen once it will never be cleared from the list. (CCA FID: 0x20)
     */
    void sendHistoryTriggerUpdate();

    // property 'InsertState'

    /**
     * The method onInsertStateGet() is called by ASF when a client invokes
     * the read method for the property 'InsertState'. The onInsertStateGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'InsertState'</b>:
     *
     * Insert key state. (CCA FID: 0x21)
     */
    virtual void onInsertStateGet(const ::boost::shared_ptr< InsertStateGet >& payload);

    /**
     * Sends back the update to a previous onInsertStateGet().
     *
     * <b>Documentation of 'InsertState'</b>:
     *
     * Insert key state. (CCA FID: 0x21)
     *
     * @param act Identifies a previous invocation of onInsertStateGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendInsertStateGetUpdate(T_SPM_e32_CD_INSERT_STATE insertState, act_t act = 0);

    /**
     * Set the value of the property 'InsertState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'InsertState'</b>:
     *
     * Insert key state. (CCA FID: 0x21)
     */
    void setInsertState(T_SPM_e32_CD_INSERT_STATE insertState);

    /**
     * Returns the current value of the property 'InsertState'.
     *
     * <b>Documentation of 'InsertState'</b>:
     *
     * Insert key state. (CCA FID: 0x21)
     */
    T_SPM_e32_CD_INSERT_STATE getInsertState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendInsertStateUpdate().
     *
     * <b>Documentation of 'InsertState'</b>:
     *
     * Insert key state. (CCA FID: 0x21)
     */
    void sendInsertStateUpdate();

    // property 'MediaEjectState'

    /**
     * The method onMediaEjectStateGet() is called by ASF when a client
     * invokes the read method for the property 'MediaEjectState'. The
     * onMediaEjectStateGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'MediaEjectState'</b>:
     *
     * Media Eject key state. (CCA FID: 0x22)
     */
    virtual void onMediaEjectStateGet(const ::boost::shared_ptr< MediaEjectStateGet >& payload);

    /**
     * Sends back the update to a previous onMediaEjectStateGet().
     *
     * <b>Documentation of 'MediaEjectState'</b>:
     *
     * Media Eject key state. (CCA FID: 0x22)
     *
     * @param act Identifies a previous invocation of onMediaEjectStateGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendMediaEjectStateGetUpdate(T_SPM_e32_MEDIA_EJECT_STATE mediaEjectState, act_t act = 0);

    /**
     * Set the value of the property 'MediaEjectState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'MediaEjectState'</b>:
     *
     * Media Eject key state. (CCA FID: 0x22)
     */
    void setMediaEjectState(T_SPM_e32_MEDIA_EJECT_STATE mediaEjectState);

    /**
     * Returns the current value of the property 'MediaEjectState'.
     *
     * <b>Documentation of 'MediaEjectState'</b>:
     *
     * Media Eject key state. (CCA FID: 0x22)
     */
    T_SPM_e32_MEDIA_EJECT_STATE getMediaEjectState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendMediaEjectStateUpdate().
     *
     * <b>Documentation of 'MediaEjectState'</b>:
     *
     * Media Eject key state. (CCA FID: 0x22)
     */
    void sendMediaEjectStateUpdate();

    // property 'PhoneMuteState'

    /**
     * The method onPhoneMuteStateGet() is called by ASF when a client invokes
     * the read method for the property 'PhoneMuteState'. The
     * onPhoneMuteStateGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'PhoneMuteState'</b>:
     *
     * State of the hard-wired phone line. (CCA FID: 0x23)
     */
    virtual void onPhoneMuteStateGet(const ::boost::shared_ptr< PhoneMuteStateGet >& payload);

    /**
     * Sends back the update to a previous onPhoneMuteStateGet().
     *
     * <b>Documentation of 'PhoneMuteState'</b>:
     *
     * State of the hard-wired phone line. (CCA FID: 0x23)
     *
     * @param act Identifies a previous invocation of onPhoneMuteStateGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPhoneMuteStateGetUpdate(T_SPM_e32_PHONE_MUTE_STATE phoneMuteState, act_t act = 0);

    /**
     * Set the value of the property 'PhoneMuteState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'PhoneMuteState'</b>:
     *
     * State of the hard-wired phone line. (CCA FID: 0x23)
     */
    void setPhoneMuteState(T_SPM_e32_PHONE_MUTE_STATE phoneMuteState);

    /**
     * Returns the current value of the property 'PhoneMuteState'.
     *
     * <b>Documentation of 'PhoneMuteState'</b>:
     *
     * State of the hard-wired phone line. (CCA FID: 0x23)
     */
    T_SPM_e32_PHONE_MUTE_STATE getPhoneMuteState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPhoneMuteStateUpdate().
     *
     * <b>Documentation of 'PhoneMuteState'</b>:
     *
     * State of the hard-wired phone line. (CCA FID: 0x23)
     */
    void sendPhoneMuteStateUpdate();

    // property 'OnTipperState'

    /**
     * The method onOnTipperStateGet() is called by ASF when a client invokes
     * the read method for the property 'OnTipperState'. The
     * onOnTipperStateGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'OnTipperState'</b>:
     *
     * Media Eject key state. (CCA FID: 0x25)
     */
    virtual void onOnTipperStateGet(const ::boost::shared_ptr< OnTipperStateGet >& payload);

    /**
     * Sends back the update to a previous onOnTipperStateGet().
     *
     * <b>Documentation of 'OnTipperState'</b>:
     *
     * Media Eject key state. (CCA FID: 0x25)
     *
     * @param act Identifies a previous invocation of onOnTipperStateGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendOnTipperStateGetUpdate(T_SPM_e32_KEY_STATE onTipperState, act_t act = 0);

    /**
     * Set the value of the property 'OnTipperState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'OnTipperState'</b>:
     *
     * Media Eject key state. (CCA FID: 0x25)
     */
    void setOnTipperState(T_SPM_e32_KEY_STATE onTipperState);

    /**
     * Returns the current value of the property 'OnTipperState'.
     *
     * <b>Documentation of 'OnTipperState'</b>:
     *
     * Media Eject key state. (CCA FID: 0x25)
     */
    T_SPM_e32_KEY_STATE getOnTipperState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendOnTipperStateUpdate().
     *
     * <b>Documentation of 'OnTipperState'</b>:
     *
     * Media Eject key state. (CCA FID: 0x25)
     */
    void sendOnTipperStateUpdate();

    // property 'IgnitionCycles'

    /**
     * The method onIgnitionCyclesGet() is called by ASF when a client invokes
     * the read method for the property 'IgnitionCycles'. The
     * onIgnitionCyclesGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'IgnitionCycles'</b>:
     *
     * Current number of ignition cycles seen after start-up. This value is incremented if another ignition cycle is seen. (CCA FID: 0x0203)
     */
    virtual void onIgnitionCyclesGet(const ::boost::shared_ptr< IgnitionCyclesGet >& payload);

    /**
     * Sends back the update to a previous onIgnitionCyclesGet().
     *
     * <b>Documentation of 'IgnitionCycles'</b>:
     *
     * Current number of ignition cycles seen after start-up. This value is incremented if another ignition cycle is seen. (CCA FID: 0x0203)
     *
     * @param act Identifies a previous invocation of onIgnitionCyclesGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendIgnitionCyclesGetUpdate(uint32 ignitionCycles, act_t act = 0);

    /**
     * Set the value of the property 'IgnitionCycles' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'IgnitionCycles'</b>:
     *
     * Current number of ignition cycles seen after start-up. This value is incremented if another ignition cycle is seen. (CCA FID: 0x0203)
     */
    void setIgnitionCycles(uint32 ignitionCycles);

    /**
     * Returns the current value of the property 'IgnitionCycles'.
     *
     * <b>Documentation of 'IgnitionCycles'</b>:
     *
     * Current number of ignition cycles seen after start-up. This value is incremented if another ignition cycle is seen. (CCA FID: 0x0203)
     */
    uint32 getIgnitionCycles() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendIgnitionCyclesUpdate().
     *
     * <b>Documentation of 'IgnitionCycles'</b>:
     *
     * Current number of ignition cycles seen after start-up. This value is incremented if another ignition cycle is seen. (CCA FID: 0x0203)
     */
    void sendIgnitionCyclesUpdate();

    // property 'SysPwrMode'

    /**
     * The method onSysPwrModeGet() is called by ASF when a client invokes the
     * read method for the property 'SysPwrMode'. The onSysPwrModeGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'SysPwrMode'</b>:
     *
     * (CCA FID: 0x0204)
     */
    virtual void onSysPwrModeGet(const ::boost::shared_ptr< SysPwrModeGet >& payload);

    /**
     * Sends back the update to a previous onSysPwrModeGet().
     *
     * <b>Documentation of 'SysPwrMode'</b>:
     *
     * (CCA FID: 0x0204)
     *
     * @param act Identifies a previous invocation of onSysPwrModeGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSysPwrModeGetUpdate(T_SPM_e32_SYSPWRMODE sysPwrMode, act_t act = 0);

    /**
     * Set the value of the property 'SysPwrMode' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SysPwrMode'</b>:
     *
     * (CCA FID: 0x0204)
     */
    void setSysPwrMode(T_SPM_e32_SYSPWRMODE sysPwrMode);

    /**
     * Returns the current value of the property 'SysPwrMode'.
     *
     * <b>Documentation of 'SysPwrMode'</b>:
     *
     * (CCA FID: 0x0204)
     */
    T_SPM_e32_SYSPWRMODE getSysPwrMode() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSysPwrModeUpdate().
     *
     * <b>Documentation of 'SysPwrMode'</b>:
     *
     * (CCA FID: 0x0204)
     */
    void sendSysPwrModeUpdate();

    // property 'SysPwrSaveMode'

    /**
     * The method onSysPwrSaveModeGet() is called by ASF when a client invokes
     * the read method for the property 'SysPwrSaveMode'. The
     * onSysPwrSaveModeGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'SysPwrSaveMode'</b>:
     *
     * (CCA FID: 0x0205)
     */
    virtual void onSysPwrSaveModeGet(const ::boost::shared_ptr< SysPwrSaveModeGet >& payload);

    /**
     * Sends back the update to a previous onSysPwrSaveModeGet().
     *
     * <b>Documentation of 'SysPwrSaveMode'</b>:
     *
     * (CCA FID: 0x0205)
     *
     * @param act Identifies a previous invocation of onSysPwrSaveModeGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSysPwrSaveModeGetUpdate(const T_SPM_b32_SYSPWRSAVEMODE& sysPwrSaveMode, act_t act = 0);

    /**
     * Set the value of the property 'SysPwrSaveMode' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SysPwrSaveMode'</b>:
     *
     * (CCA FID: 0x0205)
     */
    void setSysPwrSaveMode(const T_SPM_b32_SYSPWRSAVEMODE& sysPwrSaveMode);

    /**
     * Returns the current value of the property 'SysPwrSaveMode'.
     *
     * <b>Documentation of 'SysPwrSaveMode'</b>:
     *
     * (CCA FID: 0x0205)
     */
    const T_SPM_b32_SYSPWRSAVEMODE& getSysPwrSaveMode() const;

    /**
     * Returns the current value of the property 'SysPwrSaveMode' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendSysPwrSaveModeUpdate() method.
     *
     * <b>Documentation of 'SysPwrSaveMode'</b>:
     *
     * (CCA FID: 0x0205)
     */
    T_SPM_b32_SYSPWRSAVEMODE& getSysPwrSaveModeMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSysPwrSaveModeUpdate().
     *
     * <b>Documentation of 'SysPwrSaveMode'</b>:
     *
     * (CCA FID: 0x0205)
     */
    void sendSysPwrSaveModeUpdate();

    // property 'MapDownloadLockState'

    /**
     * The method onMapDownloadLockStateGet() is called by ASF when a client
     * invokes the read method for the property 'MapDownloadLockState'. The
     * onMapDownloadLockStateGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'MapDownloadLockState'</b>:
     *
     * Current state of the MapDownloadLock. Will return the current CCA application ID of the owner or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free. (CCA FID: 0x206)
     */
    virtual void onMapDownloadLockStateGet(const ::boost::shared_ptr< MapDownloadLockStateGet >& payload);

    /**
     * Sends back the update to a previous onMapDownloadLockStateGet().
     *
     * <b>Documentation of 'MapDownloadLockState'</b>:
     *
     * Current state of the MapDownloadLock. Will return the current CCA application ID of the owner or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free. (CCA FID: 0x206)
     *
     * @param act Identifies a previous invocation of
     * onMapDownloadLockStateGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendMapDownloadLockStateGetUpdate(uint16 mapDownloadLockState, act_t act = 0);

    /**
     * Set the value of the property 'MapDownloadLockState' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'MapDownloadLockState'</b>:
     *
     * Current state of the MapDownloadLock. Will return the current CCA application ID of the owner or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free. (CCA FID: 0x206)
     */
    void setMapDownloadLockState(uint16 mapDownloadLockState);

    /**
     * Returns the current value of the property 'MapDownloadLockState'.
     *
     * <b>Documentation of 'MapDownloadLockState'</b>:
     *
     * Current state of the MapDownloadLock. Will return the current CCA application ID of the owner or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free. (CCA FID: 0x206)
     */
    uint16 getMapDownloadLockState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendMapDownloadLockStateUpdate().
     *
     * <b>Documentation of 'MapDownloadLockState'</b>:
     *
     * Current state of the MapDownloadLock. Will return the current CCA application ID of the owner or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free. (CCA FID: 0x206)
     */
    void sendMapDownloadLockStateUpdate();

    // property 'StandbyTime'

    /**
     * The method onStandbyTimeGet() is called by ASF when a client invokes
     * the read method for the property 'StandbyTime'. The onStandbyTimeGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'StandbyTime'</b>:
     *
     * (CCA FID: 0x05)
     */
    virtual void onStandbyTimeGet(const ::boost::shared_ptr< StandbyTimeGet >& payload);

    /**
     * Sends back the update to a previous onStandbyTimeGet().
     *
     * <b>Documentation of 'StandbyTime'</b>:
     *
     * (CCA FID: 0x05)
     *
     * @param act Identifies a previous invocation of onStandbyTimeGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStandbyTimeGetUpdate(uint32 standbyTime, act_t act = 0);

    /**
     * Set the value of the property 'StandbyTime' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'StandbyTime'</b>:
     *
     * (CCA FID: 0x05)
     */
    void setStandbyTime(uint32 standbyTime);

    /**
     * Returns the current value of the property 'StandbyTime'.
     *
     * <b>Documentation of 'StandbyTime'</b>:
     *
     * (CCA FID: 0x05)
     */
    uint32 getStandbyTime() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendStandbyTimeUpdate().
     *
     * <b>Documentation of 'StandbyTime'</b>:
     *
     * (CCA FID: 0x05)
     */
    void sendStandbyTimeUpdate();

    // property 'PersitentStandbyTime'

    /**
     * The method onPersitentStandbyTimeGet() is called by ASF when a client
     * invokes the read method for the property 'PersitentStandbyTime'. The
     * onPersitentStandbyTimeGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'PersitentStandbyTime'</b>:
     *
     * Set standby time persistent. Must be set before entering the standby state.  (CCA FID: 0x06)
     */
    virtual void onPersitentStandbyTimeGet(const ::boost::shared_ptr< PersitentStandbyTimeGet >& payload);

    /**
     * Sends back the update to a previous onPersitentStandbyTimeGet().
     *
     * <b>Documentation of 'PersitentStandbyTime'</b>:
     *
     * Set standby time persistent. Must be set before entering the standby state.  (CCA FID: 0x06)
     *
     * @param act Identifies a previous invocation of
     * onPersitentStandbyTimeGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendPersitentStandbyTimeGetUpdate(uint32 persitentStandbyTime, act_t act = 0);

    /**
     * Set the value of the property 'PersitentStandbyTime' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'PersitentStandbyTime'</b>:
     *
     * Set standby time persistent. Must be set before entering the standby state.  (CCA FID: 0x06)
     */
    void setPersitentStandbyTime(uint32 persitentStandbyTime);

    /**
     * Returns the current value of the property 'PersitentStandbyTime'.
     *
     * <b>Documentation of 'PersitentStandbyTime'</b>:
     *
     * Set standby time persistent. Must be set before entering the standby state.  (CCA FID: 0x06)
     */
    uint32 getPersitentStandbyTime() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPersitentStandbyTimeUpdate().
     *
     * <b>Documentation of 'PersitentStandbyTime'</b>:
     *
     * Set standby time persistent. Must be set before entering the standby state.  (CCA FID: 0x06)
     */
    void sendPersitentStandbyTimeUpdate();

    // property 'IgnitionOffTime'

    /**
     * The method onIgnitionOffTimeGet() is called by ASF when a client
     * invokes the read method for the property 'IgnitionOffTime'. The
     * onIgnitionOffTimeGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'IgnitionOffTime'</b>:
     *
     * Set ignition off time. A restart is necessary. (CCA FID: 0x08)
     */
    virtual void onIgnitionOffTimeGet(const ::boost::shared_ptr< IgnitionOffTimeGet >& payload);

    /**
     * Sends back the update to a previous onIgnitionOffTimeGet().
     *
     * <b>Documentation of 'IgnitionOffTime'</b>:
     *
     * Set ignition off time. A restart is necessary. (CCA FID: 0x08)
     *
     * @param act Identifies a previous invocation of onIgnitionOffTimeGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendIgnitionOffTimeGetUpdate(uint32 ignitionOffTime, act_t act = 0);

    /**
     * Set the value of the property 'IgnitionOffTime' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'IgnitionOffTime'</b>:
     *
     * Set ignition off time. A restart is necessary. (CCA FID: 0x08)
     */
    void setIgnitionOffTime(uint32 ignitionOffTime);

    /**
     * Returns the current value of the property 'IgnitionOffTime'.
     *
     * <b>Documentation of 'IgnitionOffTime'</b>:
     *
     * Set ignition off time. A restart is necessary. (CCA FID: 0x08)
     */
    uint32 getIgnitionOffTime() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendIgnitionOffTimeUpdate().
     *
     * <b>Documentation of 'IgnitionOffTime'</b>:
     *
     * Set ignition off time. A restart is necessary. (CCA FID: 0x08)
     */
    void sendIgnitionOffTimeUpdate();

    // property 'DoorOpenTime'

    /**
     * The method onDoorOpenTimeGet() is called by ASF when a client invokes
     * the read method for the property 'DoorOpenTime'. The
     * onDoorOpenTimeGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'DoorOpenTime'</b>:
     *
     * Set door open time. (CCA FID: 0x0a)
     */
    virtual void onDoorOpenTimeGet(const ::boost::shared_ptr< DoorOpenTimeGet >& payload);

    /**
     * Sends back the update to a previous onDoorOpenTimeGet().
     *
     * <b>Documentation of 'DoorOpenTime'</b>:
     *
     * Set door open time. (CCA FID: 0x0a)
     *
     * @param act Identifies a previous invocation of onDoorOpenTimeGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDoorOpenTimeGetUpdate(uint32 doorOpenTime, act_t act = 0);

    /**
     * Set the value of the property 'DoorOpenTime' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'DoorOpenTime'</b>:
     *
     * Set door open time. (CCA FID: 0x0a)
     */
    void setDoorOpenTime(uint32 doorOpenTime);

    /**
     * Returns the current value of the property 'DoorOpenTime'.
     *
     * <b>Documentation of 'DoorOpenTime'</b>:
     *
     * Set door open time. (CCA FID: 0x0a)
     */
    uint32 getDoorOpenTime() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDoorOpenTimeUpdate().
     *
     * <b>Documentation of 'DoorOpenTime'</b>:
     *
     * Set door open time. (CCA FID: 0x0a)
     */
    void sendDoorOpenTimeUpdate();

    // property 'ClockDisplayTime'

    /**
     * The method onClockDisplayTimeGet() is called by ASF when a client
     * invokes the read method for the property 'ClockDisplayTime'. The
     * onClockDisplayTimeGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ClockDisplayTime'</b>:
     *
     * Set clock display time. (CCA FID: 0x0b)
     */
    virtual void onClockDisplayTimeGet(const ::boost::shared_ptr< ClockDisplayTimeGet >& payload);

    /**
     * Sends back the update to a previous onClockDisplayTimeGet().
     *
     * <b>Documentation of 'ClockDisplayTime'</b>:
     *
     * Set clock display time. (CCA FID: 0x0b)
     *
     * @param act Identifies a previous invocation of onClockDisplayTimeGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendClockDisplayTimeGetUpdate(uint32 clockDisplayTime, act_t act = 0);

    /**
     * Set the value of the property 'ClockDisplayTime' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ClockDisplayTime'</b>:
     *
     * Set clock display time. (CCA FID: 0x0b)
     */
    void setClockDisplayTime(uint32 clockDisplayTime);

    /**
     * Returns the current value of the property 'ClockDisplayTime'.
     *
     * <b>Documentation of 'ClockDisplayTime'</b>:
     *
     * Set clock display time. (CCA FID: 0x0b)
     */
    uint32 getClockDisplayTime() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendClockDisplayTimeUpdate().
     *
     * <b>Documentation of 'ClockDisplayTime'</b>:
     *
     * Set clock display time. (CCA FID: 0x0b)
     */
    void sendClockDisplayTimeUpdate();

    // property 'SystemStateTime'

    /**
     * The method onSystemStateTimeGet() is called by ASF when a client
     * invokes the read method for the property 'SystemStateTime'. The
     * onSystemStateTimeGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'SystemStateTime'</b>:
     *
     * Set the time-out value for a system state. This time describes the max. time a system state is valid without re-trigger. (CCA FID: 0xe8)
     */
    virtual void onSystemStateTimeGet(const ::boost::shared_ptr< SystemStateTimeGet >& payload);

    /**
     * Sends back the update to a previous onSystemStateTimeGet().
     *
     * <b>Documentation of 'SystemStateTime'</b>:
     *
     * Set the time-out value for a system state. This time describes the max. time a system state is valid without re-trigger. (CCA FID: 0xe8)
     *
     * @param act Identifies a previous invocation of onSystemStateTimeGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSystemStateTimeGetUpdate(const TSystemStateTime& systemStateTime, act_t act = 0);

    /**
     * Set the value of the property 'SystemStateTime' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SystemStateTime'</b>:
     *
     * Set the time-out value for a system state. This time describes the max. time a system state is valid without re-trigger. (CCA FID: 0xe8)
     */
    void setSystemStateTime(const TSystemStateTime& systemStateTime);

    /**
     * Returns the current value of the property 'SystemStateTime'.
     *
     * <b>Documentation of 'SystemStateTime'</b>:
     *
     * Set the time-out value for a system state. This time describes the max. time a system state is valid without re-trigger. (CCA FID: 0xe8)
     */
    const TSystemStateTime& getSystemStateTime() const;

    /**
     * Returns the current value of the property 'SystemStateTime' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendSystemStateTimeUpdate() method.
     *
     * <b>Documentation of 'SystemStateTime'</b>:
     *
     * Set the time-out value for a system state. This time describes the max. time a system state is valid without re-trigger. (CCA FID: 0xe8)
     */
    TSystemStateTime& getSystemStateTimeMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSystemStateTimeUpdate().
     *
     * <b>Documentation of 'SystemStateTime'</b>:
     *
     * Set the time-out value for a system state. This time describes the max. time a system state is valid without re-trigger. (CCA FID: 0xe8)
     */
    void sendSystemStateTimeUpdate();

    // property 'ProcessList'

    /**
     * The method onProcessListGet() is called by ASF when a client invokes
     * the read method for the property 'ProcessList'. The onProcessListGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'ProcessList'</b>:
     *
     * Informs about all processes configured in start configuration of SPM. (CCA FID: 0x1ff)
     */
    virtual void onProcessListGet(const ::boost::shared_ptr< ProcessListGet >& payload);

    /**
     * Sends back the update to a previous onProcessListGet().
     *
     * <b>Documentation of 'ProcessList'</b>:
     *
     * Informs about all processes configured in start configuration of SPM. (CCA FID: 0x1ff)
     *
     * @param act Identifies a previous invocation of onProcessListGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendProcessListGetUpdate(const T_SPM_ProcessInfo& processList, act_t act = 0);

    /**
     * Set the value of the property 'ProcessList' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ProcessList'</b>:
     *
     * Informs about all processes configured in start configuration of SPM. (CCA FID: 0x1ff)
     */
    void setProcessList(const T_SPM_ProcessInfo& processList);

    /**
     * Returns the current value of the property 'ProcessList'.
     *
     * <b>Documentation of 'ProcessList'</b>:
     *
     * Informs about all processes configured in start configuration of SPM. (CCA FID: 0x1ff)
     */
    const T_SPM_ProcessInfo& getProcessList() const;

    /**
     * Returns the current value of the property 'ProcessList' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendProcessListUpdate() method.
     *
     * <b>Documentation of 'ProcessList'</b>:
     *
     * Informs about all processes configured in start configuration of SPM. (CCA FID: 0x1ff)
     */
    T_SPM_ProcessInfo& getProcessListMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendProcessListUpdate().
     *
     * <b>Documentation of 'ProcessList'</b>:
     *
     * Informs about all processes configured in start configuration of SPM. (CCA FID: 0x1ff)
     */
    void sendProcessListUpdate();

    // property 'WakeupReason'

    /**
     * The method onWakeupReasonGet() is called by ASF when a client invokes
     * the read method for the property 'WakeupReason'. The
     * onWakeupReasonGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'WakeupReason'</b>:
     *
     * (CCA FID: 0x70)
     */
    virtual void onWakeupReasonGet(const ::boost::shared_ptr< WakeupReasonGet >& payload);

    /**
     * Sends back the update to a previous onWakeupReasonGet().
     *
     * <b>Documentation of 'WakeupReason'</b>:
     *
     * (CCA FID: 0x70)
     *
     * @param act Identifies a previous invocation of onWakeupReasonGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendWakeupReasonGetUpdate(T_SPM_e32_WAKEUP_REASON wakeupReason, act_t act = 0);

    /**
     * Set the value of the property 'WakeupReason' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'WakeupReason'</b>:
     *
     * (CCA FID: 0x70)
     */
    void setWakeupReason(T_SPM_e32_WAKEUP_REASON wakeupReason);

    /**
     * Returns the current value of the property 'WakeupReason'.
     *
     * <b>Documentation of 'WakeupReason'</b>:
     *
     * (CCA FID: 0x70)
     */
    T_SPM_e32_WAKEUP_REASON getWakeupReason() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendWakeupReasonUpdate().
     *
     * <b>Documentation of 'WakeupReason'</b>:
     *
     * (CCA FID: 0x70)
     */
    void sendWakeupReasonUpdate();

    // property 'StartupReason'

    /**
     * The method onStartupReasonGet() is called by ASF when a client invokes
     * the read method for the property 'StartupReason'. The
     * onStartupReasonGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'StartupReason'</b>:
     *
     * (CCA FID: 0x71)
     */
    virtual void onStartupReasonGet(const ::boost::shared_ptr< StartupReasonGet >& payload);

    /**
     * Sends back the update to a previous onStartupReasonGet().
     *
     * <b>Documentation of 'StartupReason'</b>:
     *
     * (CCA FID: 0x71)
     *
     * @param act Identifies a previous invocation of onStartupReasonGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStartupReasonGetUpdate(T_SPM_e32_STARTUP_REASON startupReason, act_t act = 0);

    /**
     * Set the value of the property 'StartupReason' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'StartupReason'</b>:
     *
     * (CCA FID: 0x71)
     */
    void setStartupReason(T_SPM_e32_STARTUP_REASON startupReason);

    /**
     * Returns the current value of the property 'StartupReason'.
     *
     * <b>Documentation of 'StartupReason'</b>:
     *
     * (CCA FID: 0x71)
     */
    T_SPM_e32_STARTUP_REASON getStartupReason() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendStartupReasonUpdate().
     *
     * <b>Documentation of 'StartupReason'</b>:
     *
     * (CCA FID: 0x71)
     */
    void sendStartupReasonUpdate();

    // property 'ConnectToBattery'

    /**
     * The method onConnectToBatteryGet() is called by ASF when a client
     * invokes the read method for the property 'ConnectToBattery'. The
     * onConnectToBatteryGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ConnectToBattery'</b>:
     *
     * (CCA FID: 0x72)
     */
    virtual void onConnectToBatteryGet(const ::boost::shared_ptr< ConnectToBatteryGet >& payload);

    /**
     * Sends back the update to a previous onConnectToBatteryGet().
     *
     * <b>Documentation of 'ConnectToBattery'</b>:
     *
     * (CCA FID: 0x72)
     *
     * @param act Identifies a previous invocation of onConnectToBatteryGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendConnectToBatteryGetUpdate(const TConnectToBattery& connectToBattery, act_t act = 0);

    /**
     * Set the value of the property 'ConnectToBattery' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ConnectToBattery'</b>:
     *
     * (CCA FID: 0x72)
     */
    void setConnectToBattery(const TConnectToBattery& connectToBattery);

    /**
     * Returns the current value of the property 'ConnectToBattery'.
     *
     * <b>Documentation of 'ConnectToBattery'</b>:
     *
     * (CCA FID: 0x72)
     */
    const TConnectToBattery& getConnectToBattery() const;

    /**
     * Returns the current value of the property 'ConnectToBattery' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendConnectToBatteryUpdate() method.
     *
     * <b>Documentation of 'ConnectToBattery'</b>:
     *
     * (CCA FID: 0x72)
     */
    TConnectToBattery& getConnectToBatteryMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendConnectToBatteryUpdate().
     *
     * <b>Documentation of 'ConnectToBattery'</b>:
     *
     * (CCA FID: 0x72)
     */
    void sendConnectToBatteryUpdate();

    // property 'CodeRequestState'

    /**
     * The method onCodeRequestStateGet() is called by ASF when a client
     * invokes the read method for the property 'CodeRequestState'. The
     * onCodeRequestStateGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'CodeRequestState'</b>:
     *
     * Current code request state. (CCA FID: 0x60)
     */
    virtual void onCodeRequestStateGet(const ::boost::shared_ptr< CodeRequestStateGet >& payload);

    /**
     * Sends back the update to a previous onCodeRequestStateGet().
     *
     * <b>Documentation of 'CodeRequestState'</b>:
     *
     * Current code request state. (CCA FID: 0x60)
     *
     * @param act Identifies a previous invocation of onCodeRequestStateGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCodeRequestStateGetUpdate(T_SPM_e32_CODE_REQUEST codeRequestState, act_t act = 0);

    /**
     * Set the value of the property 'CodeRequestState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'CodeRequestState'</b>:
     *
     * Current code request state. (CCA FID: 0x60)
     */
    void setCodeRequestState(T_SPM_e32_CODE_REQUEST codeRequestState);

    /**
     * Returns the current value of the property 'CodeRequestState'.
     *
     * <b>Documentation of 'CodeRequestState'</b>:
     *
     * Current code request state. (CCA FID: 0x60)
     */
    T_SPM_e32_CODE_REQUEST getCodeRequestState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCodeRequestStateUpdate().
     *
     * <b>Documentation of 'CodeRequestState'</b>:
     *
     * Current code request state. (CCA FID: 0x60)
     */
    void sendCodeRequestStateUpdate();

    // property 'ActiveStartUpSyncPoints'

    /**
     * The method onActiveStartUpSyncPointsGet() is called by ASF when a
     * client invokes the read method for the property
     * 'ActiveStartUpSyncPoints'. The onActiveStartUpSyncPointsGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'ActiveStartUpSyncPoints'</b>:
     *
     * Informs about all StartupSyncPoints since last wakeup. (CCA FID: 0x161)
     */
    virtual void onActiveStartUpSyncPointsGet(const ::boost::shared_ptr< ActiveStartUpSyncPointsGet >& payload);

    /**
     * Sends back the update to a previous onActiveStartUpSyncPointsGet().
     *
     * <b>Documentation of 'ActiveStartUpSyncPoints'</b>:
     *
     * Informs about all StartupSyncPoints since last wakeup. (CCA FID: 0x161)
     *
     * @param act Identifies a previous invocation of
     * onActiveStartUpSyncPointsGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendActiveStartUpSyncPointsGetUpdate(const ::std::vector< ::std::string >& activeStartUpSyncPoints, act_t act = 0);

    /**
     * Set the value of the property 'ActiveStartUpSyncPoints' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'ActiveStartUpSyncPoints'</b>:
     *
     * Informs about all StartupSyncPoints since last wakeup. (CCA FID: 0x161)
     */
    void setActiveStartUpSyncPoints(const ::std::vector< ::std::string >& activeStartUpSyncPoints);

    /**
     * Returns the current value of the property 'ActiveStartUpSyncPoints'.
     *
     * <b>Documentation of 'ActiveStartUpSyncPoints'</b>:
     *
     * Informs about all StartupSyncPoints since last wakeup. (CCA FID: 0x161)
     */
    const ::std::vector< ::std::string >& getActiveStartUpSyncPoints() const;

    /**
     * Returns the current value of the property 'ActiveStartUpSyncPoints' as
     * a mutable reference. If you change the content of the returned object
     * you have to send updates to registered clients by yourself with the
     * help of the sendActiveStartUpSyncPointsUpdate() method.
     *
     * <b>Documentation of 'ActiveStartUpSyncPoints'</b>:
     *
     * Informs about all StartupSyncPoints since last wakeup. (CCA FID: 0x161)
     */
    ::std::vector< ::std::string >& getActiveStartUpSyncPointsMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendActiveStartUpSyncPointsUpdate().
     *
     * <b>Documentation of 'ActiveStartUpSyncPoints'</b>:
     *
     * Informs about all StartupSyncPoints since last wakeup. (CCA FID: 0x161)
     */
    void sendActiveStartUpSyncPointsUpdate();

    // property 'CvmEvent'

    /**
     * The method onCvmEventGet() is called by ASF when a client invokes the
     * read method for the property 'CvmEvent'. The onCvmEventGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'CvmEvent'</b>:
     *
     * (CCA FID: 0x38)
     */
    virtual void onCvmEventGet(const ::boost::shared_ptr< CvmEventGet >& payload);

    /**
     * Sends back the update to a previous onCvmEventGet().
     *
     * <b>Documentation of 'CvmEvent'</b>:
     *
     * (CCA FID: 0x38)
     *
     * @param act Identifies a previous invocation of onCvmEventGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendCvmEventGetUpdate(T_SPM_e32_CVM_EVENT cvmEvent, act_t act = 0);

    /**
     * Set the value of the property 'CvmEvent' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'CvmEvent'</b>:
     *
     * (CCA FID: 0x38)
     */
    void setCvmEvent(T_SPM_e32_CVM_EVENT cvmEvent);

    /**
     * Returns the current value of the property 'CvmEvent'.
     *
     * <b>Documentation of 'CvmEvent'</b>:
     *
     * (CCA FID: 0x38)
     */
    T_SPM_e32_CVM_EVENT getCvmEvent() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCvmEventUpdate().
     *
     * <b>Documentation of 'CvmEvent'</b>:
     *
     * (CCA FID: 0x38)
     */
    void sendCvmEventUpdate();

    // property 'UBatSense'

    /**
     * The method onUBatSenseGet() is called by ASF when a client invokes the
     * read method for the property 'UBatSense'. The onUBatSenseGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'UBatSense'</b>:
     *
     * Current measured voltage level in mV. (CCA FID: 0x83)
     */
    virtual void onUBatSenseGet(const ::boost::shared_ptr< UBatSenseGet >& payload);

    /**
     * Sends back the update to a previous onUBatSenseGet().
     *
     * <b>Documentation of 'UBatSense'</b>:
     *
     * Current measured voltage level in mV. (CCA FID: 0x83)
     *
     * @param act Identifies a previous invocation of onUBatSenseGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendUBatSenseGetUpdate(uint16 uBatSense, act_t act = 0);

    /**
     * Set the value of the property 'UBatSense' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'UBatSense'</b>:
     *
     * Current measured voltage level in mV. (CCA FID: 0x83)
     */
    void setUBatSense(uint16 uBatSense);

    /**
     * Returns the current value of the property 'UBatSense'.
     *
     * <b>Documentation of 'UBatSense'</b>:
     *
     * Current measured voltage level in mV. (CCA FID: 0x83)
     */
    uint16 getUBatSense() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendUBatSenseUpdate().
     *
     * <b>Documentation of 'UBatSense'</b>:
     *
     * Current measured voltage level in mV. (CCA FID: 0x83)
     */
    void sendUBatSenseUpdate();

    // property 'CoproState'

    /**
     * The method onCoproStateGet() is called by ASF when a client invokes the
     * read method for the property 'CoproState'. The onCoproStateGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'CoproState'</b>:
     *
     * State of communication controller (V850). A reset of the copro will be signalled by sending SPM_U32_PROC_STATE_NORMAL -- SPM_U32_PROC_STATE_DOWN -- SPM_U32_PROC_STATE_NORMAL.  (CCA FID: 0x31)
     */
    virtual void onCoproStateGet(const ::boost::shared_ptr< CoproStateGet >& payload);

    /**
     * Sends back the update to a previous onCoproStateGet().
     *
     * <b>Documentation of 'CoproState'</b>:
     *
     * State of communication controller (V850). A reset of the copro will be signalled by sending SPM_U32_PROC_STATE_NORMAL -- SPM_U32_PROC_STATE_DOWN -- SPM_U32_PROC_STATE_NORMAL.  (CCA FID: 0x31)
     *
     * @param act Identifies a previous invocation of onCoproStateGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCoproStateGetUpdate(T_SPM_e32_PROCESSOR_STATE coproState, act_t act = 0);

    /**
     * Set the value of the property 'CoproState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'CoproState'</b>:
     *
     * State of communication controller (V850). A reset of the copro will be signalled by sending SPM_U32_PROC_STATE_NORMAL -- SPM_U32_PROC_STATE_DOWN -- SPM_U32_PROC_STATE_NORMAL.  (CCA FID: 0x31)
     */
    void setCoproState(T_SPM_e32_PROCESSOR_STATE coproState);

    /**
     * Returns the current value of the property 'CoproState'.
     *
     * <b>Documentation of 'CoproState'</b>:
     *
     * State of communication controller (V850). A reset of the copro will be signalled by sending SPM_U32_PROC_STATE_NORMAL -- SPM_U32_PROC_STATE_DOWN -- SPM_U32_PROC_STATE_NORMAL.  (CCA FID: 0x31)
     */
    T_SPM_e32_PROCESSOR_STATE getCoproState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCoproStateUpdate().
     *
     * <b>Documentation of 'CoproState'</b>:
     *
     * State of communication controller (V850). A reset of the copro will be signalled by sending SPM_U32_PROC_STATE_NORMAL -- SPM_U32_PROC_STATE_DOWN -- SPM_U32_PROC_STATE_NORMAL.  (CCA FID: 0x31)
     */
    void sendCoproStateUpdate();

    // property 'DevicePowerOnTime'

    /**
     * The method onDevicePowerOnTimeGet() is called by ASF when a client
     * invokes the read method for the property 'DevicePowerOnTime'. The
     * onDevicePowerOnTimeGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'DevicePowerOnTime'</b>:
     *
     * (CCA FID: 0x18)
     */
    virtual void onDevicePowerOnTimeGet(const ::boost::shared_ptr< DevicePowerOnTimeGet >& payload);

    /**
     * Sends back the update to a previous onDevicePowerOnTimeGet().
     *
     * <b>Documentation of 'DevicePowerOnTime'</b>:
     *
     * (CCA FID: 0x18)
     *
     * @param act Identifies a previous invocation of
     * onDevicePowerOnTimeGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDevicePowerOnTimeGetUpdate(uint32 devicePowerOnTime, act_t act = 0);

    /**
     * Set the value of the property 'DevicePowerOnTime' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'DevicePowerOnTime'</b>:
     *
     * (CCA FID: 0x18)
     */
    void setDevicePowerOnTime(uint32 devicePowerOnTime);

    /**
     * Returns the current value of the property 'DevicePowerOnTime'.
     *
     * <b>Documentation of 'DevicePowerOnTime'</b>:
     *
     * (CCA FID: 0x18)
     */
    uint32 getDevicePowerOnTime() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDevicePowerOnTimeUpdate().
     *
     * <b>Documentation of 'DevicePowerOnTime'</b>:
     *
     * (CCA FID: 0x18)
     */
    void sendDevicePowerOnTimeUpdate();

    // property 'LastSystemRuntime'

    /**
     * The method onLastSystemRuntimeGet() is called by ASF when a client
     * invokes the read method for the property 'LastSystemRuntime'. The
     * onLastSystemRuntimeGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'LastSystemRuntime'</b>:
     *
     * Time in s the system was running in the last power cycle. (CCA FID: 0x1100)
     */
    virtual void onLastSystemRuntimeGet(const ::boost::shared_ptr< LastSystemRuntimeGet >& payload);

    /**
     * Sends back the update to a previous onLastSystemRuntimeGet().
     *
     * <b>Documentation of 'LastSystemRuntime'</b>:
     *
     * Time in s the system was running in the last power cycle. (CCA FID: 0x1100)
     *
     * @param act Identifies a previous invocation of
     * onLastSystemRuntimeGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendLastSystemRuntimeGetUpdate(uint32 lastSystemRuntime, act_t act = 0);

    /**
     * Set the value of the property 'LastSystemRuntime' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'LastSystemRuntime'</b>:
     *
     * Time in s the system was running in the last power cycle. (CCA FID: 0x1100)
     */
    void setLastSystemRuntime(uint32 lastSystemRuntime);

    /**
     * Returns the current value of the property 'LastSystemRuntime'.
     *
     * <b>Documentation of 'LastSystemRuntime'</b>:
     *
     * Time in s the system was running in the last power cycle. (CCA FID: 0x1100)
     */
    uint32 getLastSystemRuntime() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLastSystemRuntimeUpdate().
     *
     * <b>Documentation of 'LastSystemRuntime'</b>:
     *
     * Time in s the system was running in the last power cycle. (CCA FID: 0x1100)
     */
    void sendLastSystemRuntimeUpdate();

    // property 'CurrentSystemRuntime'

    /**
     * The method onCurrentSystemRuntimeGet() is called by ASF when a client
     * invokes the read method for the property 'CurrentSystemRuntime'. The
     * onCurrentSystemRuntimeGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'CurrentSystemRuntime'</b>:
     *
     * Time in s the system is currently active. (CCA FID: 0x1101)
     */
    virtual void onCurrentSystemRuntimeGet(const ::boost::shared_ptr< CurrentSystemRuntimeGet >& payload);

    /**
     * Sends back the update to a previous onCurrentSystemRuntimeGet().
     *
     * <b>Documentation of 'CurrentSystemRuntime'</b>:
     *
     * Time in s the system is currently active. (CCA FID: 0x1101)
     *
     * @param act Identifies a previous invocation of
     * onCurrentSystemRuntimeGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendCurrentSystemRuntimeGetUpdate(uint32 currentSystemRuntime, act_t act = 0);

    /**
     * Set the value of the property 'CurrentSystemRuntime' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'CurrentSystemRuntime'</b>:
     *
     * Time in s the system is currently active. (CCA FID: 0x1101)
     */
    void setCurrentSystemRuntime(uint32 currentSystemRuntime);

    /**
     * Returns the current value of the property 'CurrentSystemRuntime'.
     *
     * <b>Documentation of 'CurrentSystemRuntime'</b>:
     *
     * Time in s the system is currently active. (CCA FID: 0x1101)
     */
    uint32 getCurrentSystemRuntime() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCurrentSystemRuntimeUpdate().
     *
     * <b>Documentation of 'CurrentSystemRuntime'</b>:
     *
     * Time in s the system is currently active. (CCA FID: 0x1101)
     */
    void sendCurrentSystemRuntimeUpdate();

    // property 'ResetList'

    /**
     * The method onResetListGet() is called by ASF when a client invokes the
     * read method for the property 'ResetList'. The onResetListGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'ResetList'</b>:
     *
     * (CCA FID: 0x41)
     */
    virtual void onResetListGet(const ::boost::shared_ptr< ResetListGet >& payload);

    /**
     * Sends back the update to a previous onResetListGet().
     *
     * <b>Documentation of 'ResetList'</b>:
     *
     * (CCA FID: 0x41)
     *
     * @param act Identifies a previous invocation of onResetListGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendResetListGetUpdate(const TResetList& resetList, act_t act = 0);

    /**
     * Set the value of the property 'ResetList' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ResetList'</b>:
     *
     * (CCA FID: 0x41)
     */
    void setResetList(const TResetList& resetList);

    /**
     * Returns the current value of the property 'ResetList'.
     *
     * <b>Documentation of 'ResetList'</b>:
     *
     * (CCA FID: 0x41)
     */
    const TResetList& getResetList() const;

    /**
     * Returns the current value of the property 'ResetList' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendResetListUpdate() method.
     *
     * <b>Documentation of 'ResetList'</b>:
     *
     * (CCA FID: 0x41)
     */
    TResetList& getResetListMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendResetListUpdate().
     *
     * <b>Documentation of 'ResetList'</b>:
     *
     * (CCA FID: 0x41)
     */
    void sendResetListUpdate();

    // property 'ResetCounter'

    /**
     * The method onResetCounterGet() is called by ASF when a client invokes
     * the read method for the property 'ResetCounter'. The
     * onResetCounterGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ResetCounter'</b>:
     *
     * Information about detected reset reasons.  (CCA FID: 0x1041)
     */
    virtual void onResetCounterGet(const ::boost::shared_ptr< ResetCounterGet >& payload);

    /**
     * Sends back the update to a previous onResetCounterGet().
     *
     * <b>Documentation of 'ResetCounter'</b>:
     *
     * Information about detected reset reasons.  (CCA FID: 0x1041)
     *
     * @param act Identifies a previous invocation of onResetCounterGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendResetCounterGetUpdate(const TResetCounter& resetCounter, act_t act = 0);

    /**
     * Set the value of the property 'ResetCounter' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ResetCounter'</b>:
     *
     * Information about detected reset reasons.  (CCA FID: 0x1041)
     */
    void setResetCounter(const TResetCounter& resetCounter);

    /**
     * Returns the current value of the property 'ResetCounter'.
     *
     * <b>Documentation of 'ResetCounter'</b>:
     *
     * Information about detected reset reasons.  (CCA FID: 0x1041)
     */
    const TResetCounter& getResetCounter() const;

    /**
     * Returns the current value of the property 'ResetCounter' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendResetCounterUpdate() method.
     *
     * <b>Documentation of 'ResetCounter'</b>:
     *
     * Information about detected reset reasons.  (CCA FID: 0x1041)
     */
    TResetCounter& getResetCounterMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendResetCounterUpdate().
     *
     * <b>Documentation of 'ResetCounter'</b>:
     *
     * Information about detected reset reasons.  (CCA FID: 0x1041)
     */
    void sendResetCounterUpdate();

    // property 'TransportModeList'

    /**
     * The method onTransportModeListGet() is called by ASF when a client
     * invokes the read method for the property 'TransportModeList'. The
     * onTransportModeListGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'TransportModeList'</b>:
     *
     * History of recent Transportmode trigger.  (CCA FID: 0x43)
     */
    virtual void onTransportModeListGet(const ::boost::shared_ptr< TransportModeListGet >& payload);

    /**
     * Sends back the update to a previous onTransportModeListGet().
     *
     * <b>Documentation of 'TransportModeList'</b>:
     *
     * History of recent Transportmode trigger.  (CCA FID: 0x43)
     *
     * @param act Identifies a previous invocation of
     * onTransportModeListGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendTransportModeListGetUpdate(const T_SPM_TransPortModeList& transportModeList, act_t act = 0);

    /**
     * Set the value of the property 'TransportModeList' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'TransportModeList'</b>:
     *
     * History of recent Transportmode trigger.  (CCA FID: 0x43)
     */
    void setTransportModeList(const T_SPM_TransPortModeList& transportModeList);

    /**
     * Returns the current value of the property 'TransportModeList'.
     *
     * <b>Documentation of 'TransportModeList'</b>:
     *
     * History of recent Transportmode trigger.  (CCA FID: 0x43)
     */
    const T_SPM_TransPortModeList& getTransportModeList() const;

    /**
     * Returns the current value of the property 'TransportModeList' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendTransportModeListUpdate() method.
     *
     * <b>Documentation of 'TransportModeList'</b>:
     *
     * History of recent Transportmode trigger.  (CCA FID: 0x43)
     */
    T_SPM_TransPortModeList& getTransportModeListMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTransportModeListUpdate().
     *
     * <b>Documentation of 'TransportModeList'</b>:
     *
     * History of recent Transportmode trigger.  (CCA FID: 0x43)
     */
    void sendTransportModeListUpdate();

    // property 'ResetHistory'

    /**
     * The method onResetHistoryGet() is called by ASF when a client invokes
     * the read method for the property 'ResetHistory'. The
     * onResetHistoryGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ResetHistory'</b>:
     *
     * Get a list of the latest reset reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x44)
     */
    virtual void onResetHistoryGet(const ::boost::shared_ptr< ResetHistoryGet >& payload);

    /**
     * Sends back the update to a previous onResetHistoryGet().
     *
     * <b>Documentation of 'ResetHistory'</b>:
     *
     * Get a list of the latest reset reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x44)
     *
     * @param act Identifies a previous invocation of onResetHistoryGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendResetHistoryGetUpdate(const ::std::vector< T_ResetElement >& resetHistory, act_t act = 0);

    /**
     * Set the value of the property 'ResetHistory' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ResetHistory'</b>:
     *
     * Get a list of the latest reset reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x44)
     */
    void setResetHistory(const ::std::vector< T_ResetElement >& resetHistory);

    /**
     * Returns the current value of the property 'ResetHistory'.
     *
     * <b>Documentation of 'ResetHistory'</b>:
     *
     * Get a list of the latest reset reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x44)
     */
    const ::std::vector< T_ResetElement >& getResetHistory() const;

    /**
     * Returns the current value of the property 'ResetHistory' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendResetHistoryUpdate() method.
     *
     * <b>Documentation of 'ResetHistory'</b>:
     *
     * Get a list of the latest reset reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x44)
     */
    ::std::vector< T_ResetElement >& getResetHistoryMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendResetHistoryUpdate().
     *
     * <b>Documentation of 'ResetHistory'</b>:
     *
     * Get a list of the latest reset reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x44)
     */
    void sendResetHistoryUpdate();

    // property 'WakeupHistory'

    /**
     * The method onWakeupHistoryGet() is called by ASF when a client invokes
     * the read method for the property 'WakeupHistory'. The
     * onWakeupHistoryGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'WakeupHistory'</b>:
     *
     * Get a list of the latest wakeup reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x45)
     */
    virtual void onWakeupHistoryGet(const ::boost::shared_ptr< WakeupHistoryGet >& payload);

    /**
     * Sends back the update to a previous onWakeupHistoryGet().
     *
     * <b>Documentation of 'WakeupHistory'</b>:
     *
     * Get a list of the latest wakeup reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x45)
     *
     * @param act Identifies a previous invocation of onWakeupHistoryGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendWakeupHistoryGetUpdate(const ::std::vector< T_WakeupElement >& wakeupHistory, act_t act = 0);

    /**
     * Set the value of the property 'WakeupHistory' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'WakeupHistory'</b>:
     *
     * Get a list of the latest wakeup reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x45)
     */
    void setWakeupHistory(const ::std::vector< T_WakeupElement >& wakeupHistory);

    /**
     * Returns the current value of the property 'WakeupHistory'.
     *
     * <b>Documentation of 'WakeupHistory'</b>:
     *
     * Get a list of the latest wakeup reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x45)
     */
    const ::std::vector< T_WakeupElement >& getWakeupHistory() const;

    /**
     * Returns the current value of the property 'WakeupHistory' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendWakeupHistoryUpdate() method.
     *
     * <b>Documentation of 'WakeupHistory'</b>:
     *
     * Get a list of the latest wakeup reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x45)
     */
    ::std::vector< T_WakeupElement >& getWakeupHistoryMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendWakeupHistoryUpdate().
     *
     * <b>Documentation of 'WakeupHistory'</b>:
     *
     * Get a list of the latest wakeup reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x45)
     */
    void sendWakeupHistoryUpdate();

    // property 'StateHistory'

    /**
     * The method onStateHistoryGet() is called by ASF when a client invokes
     * the read method for the property 'StateHistory'. The
     * onStateHistoryGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'StateHistory'</b>:
     *
     * Get a list of the latest wakeup/reset events and on/off reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x46)
     */
    virtual void onStateHistoryGet(const ::boost::shared_ptr< StateHistoryGet >& payload);

    /**
     * Sends back the update to a previous onStateHistoryGet().
     *
     * <b>Documentation of 'StateHistory'</b>:
     *
     * Get a list of the latest wakeup/reset events and on/off reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x46)
     *
     * @param act Identifies a previous invocation of onStateHistoryGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStateHistoryGetUpdate(const ::std::vector< T_StateChangeElement >& stateHistory, act_t act = 0);

    /**
     * Set the value of the property 'StateHistory' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'StateHistory'</b>:
     *
     * Get a list of the latest wakeup/reset events and on/off reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x46)
     */
    void setStateHistory(const ::std::vector< T_StateChangeElement >& stateHistory);

    /**
     * Returns the current value of the property 'StateHistory'.
     *
     * <b>Documentation of 'StateHistory'</b>:
     *
     * Get a list of the latest wakeup/reset events and on/off reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x46)
     */
    const ::std::vector< T_StateChangeElement >& getStateHistory() const;

    /**
     * Returns the current value of the property 'StateHistory' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendStateHistoryUpdate() method.
     *
     * <b>Documentation of 'StateHistory'</b>:
     *
     * Get a list of the latest wakeup/reset events and on/off reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x46)
     */
    ::std::vector< T_StateChangeElement >& getStateHistoryMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendStateHistoryUpdate().
     *
     * <b>Documentation of 'StateHistory'</b>:
     *
     * Get a list of the latest wakeup/reset events and on/off reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x46)
     */
    void sendStateHistoryUpdate();

    // property 'ErrStateHistory01'

    /**
     * The method onErrStateHistory01Get() is called by ASF when a client
     * invokes the read method for the property 'ErrStateHistory01'. The
     * onErrStateHistory01Get() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ErrStateHistory01'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x47)
     */
    virtual void onErrStateHistory01Get(const ::boost::shared_ptr< ErrStateHistory01Get >& payload);

    /**
     * Sends back the update to a previous onErrStateHistory01Get().
     *
     * <b>Documentation of 'ErrStateHistory01'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x47)
     *
     * @param act Identifies a previous invocation of
     * onErrStateHistory01Get(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendErrStateHistory01GetUpdate(const ::std::vector< T_StateChangeElement >& errStateHistory01, act_t act = 0);

    /**
     * Set the value of the property 'ErrStateHistory01' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ErrStateHistory01'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x47)
     */
    void setErrStateHistory01(const ::std::vector< T_StateChangeElement >& errStateHistory01);

    /**
     * Returns the current value of the property 'ErrStateHistory01'.
     *
     * <b>Documentation of 'ErrStateHistory01'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x47)
     */
    const ::std::vector< T_StateChangeElement >& getErrStateHistory01() const;

    /**
     * Returns the current value of the property 'ErrStateHistory01' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendErrStateHistory01Update() method.
     *
     * <b>Documentation of 'ErrStateHistory01'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x47)
     */
    ::std::vector< T_StateChangeElement >& getErrStateHistory01Mutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendErrStateHistory01Update().
     *
     * <b>Documentation of 'ErrStateHistory01'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x47)
     */
    void sendErrStateHistory01Update();

    // property 'ErrStateHistory02'

    /**
     * The method onErrStateHistory02Get() is called by ASF when a client
     * invokes the read method for the property 'ErrStateHistory02'. The
     * onErrStateHistory02Get() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ErrStateHistory02'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x48)
     */
    virtual void onErrStateHistory02Get(const ::boost::shared_ptr< ErrStateHistory02Get >& payload);

    /**
     * Sends back the update to a previous onErrStateHistory02Get().
     *
     * <b>Documentation of 'ErrStateHistory02'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x48)
     *
     * @param act Identifies a previous invocation of
     * onErrStateHistory02Get(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendErrStateHistory02GetUpdate(const ::std::vector< T_StateChangeElement >& errStateHistory02, act_t act = 0);

    /**
     * Set the value of the property 'ErrStateHistory02' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ErrStateHistory02'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x48)
     */
    void setErrStateHistory02(const ::std::vector< T_StateChangeElement >& errStateHistory02);

    /**
     * Returns the current value of the property 'ErrStateHistory02'.
     *
     * <b>Documentation of 'ErrStateHistory02'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x48)
     */
    const ::std::vector< T_StateChangeElement >& getErrStateHistory02() const;

    /**
     * Returns the current value of the property 'ErrStateHistory02' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendErrStateHistory02Update() method.
     *
     * <b>Documentation of 'ErrStateHistory02'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x48)
     */
    ::std::vector< T_StateChangeElement >& getErrStateHistory02Mutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendErrStateHistory02Update().
     *
     * <b>Documentation of 'ErrStateHistory02'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x48)
     */
    void sendErrStateHistory02Update();

    // property 'ErrStateHistory03'

    /**
     * The method onErrStateHistory03Get() is called by ASF when a client
     * invokes the read method for the property 'ErrStateHistory03'. The
     * onErrStateHistory03Get() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ErrStateHistory03'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x49)
     */
    virtual void onErrStateHistory03Get(const ::boost::shared_ptr< ErrStateHistory03Get >& payload);

    /**
     * Sends back the update to a previous onErrStateHistory03Get().
     *
     * <b>Documentation of 'ErrStateHistory03'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x49)
     *
     * @param act Identifies a previous invocation of
     * onErrStateHistory03Get(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendErrStateHistory03GetUpdate(const ::std::vector< T_StateChangeElement >& errStateHistory03, act_t act = 0);

    /**
     * Set the value of the property 'ErrStateHistory03' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ErrStateHistory03'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x49)
     */
    void setErrStateHistory03(const ::std::vector< T_StateChangeElement >& errStateHistory03);

    /**
     * Returns the current value of the property 'ErrStateHistory03'.
     *
     * <b>Documentation of 'ErrStateHistory03'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x49)
     */
    const ::std::vector< T_StateChangeElement >& getErrStateHistory03() const;

    /**
     * Returns the current value of the property 'ErrStateHistory03' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendErrStateHistory03Update() method.
     *
     * <b>Documentation of 'ErrStateHistory03'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x49)
     */
    ::std::vector< T_StateChangeElement >& getErrStateHistory03Mutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendErrStateHistory03Update().
     *
     * <b>Documentation of 'ErrStateHistory03'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x49)
     */
    void sendErrStateHistory03Update();

    // property 'ErrStateHistory04'

    /**
     * The method onErrStateHistory04Get() is called by ASF when a client
     * invokes the read method for the property 'ErrStateHistory04'. The
     * onErrStateHistory04Get() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ErrStateHistory04'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x4a)
     */
    virtual void onErrStateHistory04Get(const ::boost::shared_ptr< ErrStateHistory04Get >& payload);

    /**
     * Sends back the update to a previous onErrStateHistory04Get().
     *
     * <b>Documentation of 'ErrStateHistory04'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x4a)
     *
     * @param act Identifies a previous invocation of
     * onErrStateHistory04Get(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendErrStateHistory04GetUpdate(const ::std::vector< T_StateChangeElement >& errStateHistory04, act_t act = 0);

    /**
     * Set the value of the property 'ErrStateHistory04' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ErrStateHistory04'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x4a)
     */
    void setErrStateHistory04(const ::std::vector< T_StateChangeElement >& errStateHistory04);

    /**
     * Returns the current value of the property 'ErrStateHistory04'.
     *
     * <b>Documentation of 'ErrStateHistory04'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x4a)
     */
    const ::std::vector< T_StateChangeElement >& getErrStateHistory04() const;

    /**
     * Returns the current value of the property 'ErrStateHistory04' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendErrStateHistory04Update() method.
     *
     * <b>Documentation of 'ErrStateHistory04'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x4a)
     */
    ::std::vector< T_StateChangeElement >& getErrStateHistory04Mutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendErrStateHistory04Update().
     *
     * <b>Documentation of 'ErrStateHistory04'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x4a)
     */
    void sendErrStateHistory04Update();

    // property 'ErrStateHistory05'

    /**
     * The method onErrStateHistory05Get() is called by ASF when a client
     * invokes the read method for the property 'ErrStateHistory05'. The
     * onErrStateHistory05Get() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ErrStateHistory05'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x4b)
     */
    virtual void onErrStateHistory05Get(const ::boost::shared_ptr< ErrStateHistory05Get >& payload);

    /**
     * Sends back the update to a previous onErrStateHistory05Get().
     *
     * <b>Documentation of 'ErrStateHistory05'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x4b)
     *
     * @param act Identifies a previous invocation of
     * onErrStateHistory05Get(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendErrStateHistory05GetUpdate(const ::std::vector< T_StateChangeElement >& errStateHistory05, act_t act = 0);

    /**
     * Set the value of the property 'ErrStateHistory05' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ErrStateHistory05'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x4b)
     */
    void setErrStateHistory05(const ::std::vector< T_StateChangeElement >& errStateHistory05);

    /**
     * Returns the current value of the property 'ErrStateHistory05'.
     *
     * <b>Documentation of 'ErrStateHistory05'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x4b)
     */
    const ::std::vector< T_StateChangeElement >& getErrStateHistory05() const;

    /**
     * Returns the current value of the property 'ErrStateHistory05' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendErrStateHistory05Update() method.
     *
     * <b>Documentation of 'ErrStateHistory05'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x4b)
     */
    ::std::vector< T_StateChangeElement >& getErrStateHistory05Mutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendErrStateHistory05Update().
     *
     * <b>Documentation of 'ErrStateHistory05'</b>:
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x4b)
     */
    void sendErrStateHistory05Update();

    // property 'SwitchOnHistory'

    /**
     * The method onSwitchOnHistoryGet() is called by ASF when a client
     * invokes the read method for the property 'SwitchOnHistory'. The
     * onSwitchOnHistoryGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'SwitchOnHistory'</b>:
     *
     * List of ON reasons why target is switched on (display on).  (CCA FID: 0x4c)
     */
    virtual void onSwitchOnHistoryGet(const ::boost::shared_ptr< SwitchOnHistoryGet >& payload);

    /**
     * Sends back the update to a previous onSwitchOnHistoryGet().
     *
     * <b>Documentation of 'SwitchOnHistory'</b>:
     *
     * List of ON reasons why target is switched on (display on).  (CCA FID: 0x4c)
     *
     * @param act Identifies a previous invocation of onSwitchOnHistoryGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSwitchOnHistoryGetUpdate(const ::std::vector< T_SwitchOnElement >& switchOnHistory, act_t act = 0);

    /**
     * Set the value of the property 'SwitchOnHistory' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SwitchOnHistory'</b>:
     *
     * List of ON reasons why target is switched on (display on).  (CCA FID: 0x4c)
     */
    void setSwitchOnHistory(const ::std::vector< T_SwitchOnElement >& switchOnHistory);

    /**
     * Returns the current value of the property 'SwitchOnHistory'.
     *
     * <b>Documentation of 'SwitchOnHistory'</b>:
     *
     * List of ON reasons why target is switched on (display on).  (CCA FID: 0x4c)
     */
    const ::std::vector< T_SwitchOnElement >& getSwitchOnHistory() const;

    /**
     * Returns the current value of the property 'SwitchOnHistory' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendSwitchOnHistoryUpdate() method.
     *
     * <b>Documentation of 'SwitchOnHistory'</b>:
     *
     * List of ON reasons why target is switched on (display on).  (CCA FID: 0x4c)
     */
    ::std::vector< T_SwitchOnElement >& getSwitchOnHistoryMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSwitchOnHistoryUpdate().
     *
     * <b>Documentation of 'SwitchOnHistory'</b>:
     *
     * List of ON reasons why target is switched on (display on).  (CCA FID: 0x4c)
     */
    void sendSwitchOnHistoryUpdate();

    // property 'DeviceOnCounter'

    /**
     * The method onDeviceOnCounterGet() is called by ASF when a client
     * invokes the read method for the property 'DeviceOnCounter'. The
     * onDeviceOnCounterGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'DeviceOnCounter'</b>:
     *
     * (CCA FID: 0x1050)
     */
    virtual void onDeviceOnCounterGet(const ::boost::shared_ptr< DeviceOnCounterGet >& payload);

    /**
     * Sends back the update to a previous onDeviceOnCounterGet().
     *
     * <b>Documentation of 'DeviceOnCounter'</b>:
     *
     * (CCA FID: 0x1050)
     *
     * @param act Identifies a previous invocation of onDeviceOnCounterGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDeviceOnCounterGetUpdate(const TDeviceOnCounter& deviceOnCounter, act_t act = 0);

    /**
     * Set the value of the property 'DeviceOnCounter' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'DeviceOnCounter'</b>:
     *
     * (CCA FID: 0x1050)
     */
    void setDeviceOnCounter(const TDeviceOnCounter& deviceOnCounter);

    /**
     * Returns the current value of the property 'DeviceOnCounter'.
     *
     * <b>Documentation of 'DeviceOnCounter'</b>:
     *
     * (CCA FID: 0x1050)
     */
    const TDeviceOnCounter& getDeviceOnCounter() const;

    /**
     * Returns the current value of the property 'DeviceOnCounter' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendDeviceOnCounterUpdate() method.
     *
     * <b>Documentation of 'DeviceOnCounter'</b>:
     *
     * (CCA FID: 0x1050)
     */
    TDeviceOnCounter& getDeviceOnCounterMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDeviceOnCounterUpdate().
     *
     * <b>Documentation of 'DeviceOnCounter'</b>:
     *
     * (CCA FID: 0x1050)
     */
    void sendDeviceOnCounterUpdate();

    // property 'VoltageEventCounter'

    /**
     * The method onVoltageEventCounterGet() is called by ASF when a client
     * invokes the read method for the property 'VoltageEventCounter'. The
     * onVoltageEventCounterGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'VoltageEventCounter'</b>:
     *
     * Counts system voltage events. (CCA FID: 0x1051)
     */
    virtual void onVoltageEventCounterGet(const ::boost::shared_ptr< VoltageEventCounterGet >& payload);

    /**
     * Sends back the update to a previous onVoltageEventCounterGet().
     *
     * <b>Documentation of 'VoltageEventCounter'</b>:
     *
     * Counts system voltage events. (CCA FID: 0x1051)
     *
     * @param act Identifies a previous invocation of
     * onVoltageEventCounterGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendVoltageEventCounterGetUpdate(const T_SPM_VoltageEventCounter& voltageEventCounter, act_t act = 0);

    /**
     * Set the value of the property 'VoltageEventCounter' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'VoltageEventCounter'</b>:
     *
     * Counts system voltage events. (CCA FID: 0x1051)
     */
    void setVoltageEventCounter(const T_SPM_VoltageEventCounter& voltageEventCounter);

    /**
     * Returns the current value of the property 'VoltageEventCounter'.
     *
     * <b>Documentation of 'VoltageEventCounter'</b>:
     *
     * Counts system voltage events. (CCA FID: 0x1051)
     */
    const T_SPM_VoltageEventCounter& getVoltageEventCounter() const;

    /**
     * Returns the current value of the property 'VoltageEventCounter' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendVoltageEventCounterUpdate() method.
     *
     * <b>Documentation of 'VoltageEventCounter'</b>:
     *
     * Counts system voltage events. (CCA FID: 0x1051)
     */
    T_SPM_VoltageEventCounter& getVoltageEventCounterMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendVoltageEventCounterUpdate().
     *
     * <b>Documentation of 'VoltageEventCounter'</b>:
     *
     * Counts system voltage events. (CCA FID: 0x1051)
     */
    void sendVoltageEventCounterUpdate();

    // property 'VoltageRangeHistogram'

    /**
     * The method onVoltageRangeHistogramGet() is called by ASF when a client
     * invokes the read method for the property 'VoltageRangeHistogram'. The
     * onVoltageRangeHistogramGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'VoltageRangeHistogram'</b>:
     *
     * The histogram of system voltage. The histogram contains a set of 50 voltage ranges in mV and operation time in sec (CCA FID: 0x1052)
     */
    virtual void onVoltageRangeHistogramGet(const ::boost::shared_ptr< VoltageRangeHistogramGet >& payload);

    /**
     * Sends back the update to a previous onVoltageRangeHistogramGet().
     *
     * <b>Documentation of 'VoltageRangeHistogram'</b>:
     *
     * The histogram of system voltage. The histogram contains a set of 50 voltage ranges in mV and operation time in sec (CCA FID: 0x1052)
     *
     * @param act Identifies a previous invocation of
     * onVoltageRangeHistogramGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendVoltageRangeHistogramGetUpdate(const ::std::vector< T_SPM_VoltageRange >& voltageRangeHistogram, act_t act = 0);

    /**
     * Set the value of the property 'VoltageRangeHistogram' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'VoltageRangeHistogram'</b>:
     *
     * The histogram of system voltage. The histogram contains a set of 50 voltage ranges in mV and operation time in sec (CCA FID: 0x1052)
     */
    void setVoltageRangeHistogram(const ::std::vector< T_SPM_VoltageRange >& voltageRangeHistogram);

    /**
     * Returns the current value of the property 'VoltageRangeHistogram'.
     *
     * <b>Documentation of 'VoltageRangeHistogram'</b>:
     *
     * The histogram of system voltage. The histogram contains a set of 50 voltage ranges in mV and operation time in sec (CCA FID: 0x1052)
     */
    const ::std::vector< T_SPM_VoltageRange >& getVoltageRangeHistogram() const;

    /**
     * Returns the current value of the property 'VoltageRangeHistogram' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendVoltageRangeHistogramUpdate() method.
     *
     * <b>Documentation of 'VoltageRangeHistogram'</b>:
     *
     * The histogram of system voltage. The histogram contains a set of 50 voltage ranges in mV and operation time in sec (CCA FID: 0x1052)
     */
    ::std::vector< T_SPM_VoltageRange >& getVoltageRangeHistogramMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendVoltageRangeHistogramUpdate().
     *
     * <b>Documentation of 'VoltageRangeHistogram'</b>:
     *
     * The histogram of system voltage. The histogram contains a set of 50 voltage ranges in mV and operation time in sec (CCA FID: 0x1052)
     */
    void sendVoltageRangeHistogramUpdate();

    // property 'CpuUsageStatistic'

    /**
     * The method onCpuUsageStatisticGet() is called by ASF when a client
     * invokes the read method for the property 'CpuUsageStatistic'. The
     * onCpuUsageStatisticGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'CpuUsageStatistic'</b>:
     *
     * CPU usage of device. The return values are Max/Average/Min percentage of CPU usage ( CPU consumption tick / CPU overall tick ).  The data will be updated in periodically which is corresponding CPU supervision period (default is 10 sec).  (CCA FID: 0x1053)
     */
    virtual void onCpuUsageStatisticGet(const ::boost::shared_ptr< CpuUsageStatisticGet >& payload);

    /**
     * Sends back the update to a previous onCpuUsageStatisticGet().
     *
     * <b>Documentation of 'CpuUsageStatistic'</b>:
     *
     * CPU usage of device. The return values are Max/Average/Min percentage of CPU usage ( CPU consumption tick / CPU overall tick ).  The data will be updated in periodically which is corresponding CPU supervision period (default is 10 sec).  (CCA FID: 0x1053)
     *
     * @param act Identifies a previous invocation of
     * onCpuUsageStatisticGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendCpuUsageStatisticGetUpdate(const T_SPM_SystemStatisticsData& cpuUsageStatistic, act_t act = 0);

    /**
     * Set the value of the property 'CpuUsageStatistic' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'CpuUsageStatistic'</b>:
     *
     * CPU usage of device. The return values are Max/Average/Min percentage of CPU usage ( CPU consumption tick / CPU overall tick ).  The data will be updated in periodically which is corresponding CPU supervision period (default is 10 sec).  (CCA FID: 0x1053)
     */
    void setCpuUsageStatistic(const T_SPM_SystemStatisticsData& cpuUsageStatistic);

    /**
     * Returns the current value of the property 'CpuUsageStatistic'.
     *
     * <b>Documentation of 'CpuUsageStatistic'</b>:
     *
     * CPU usage of device. The return values are Max/Average/Min percentage of CPU usage ( CPU consumption tick / CPU overall tick ).  The data will be updated in periodically which is corresponding CPU supervision period (default is 10 sec).  (CCA FID: 0x1053)
     */
    const T_SPM_SystemStatisticsData& getCpuUsageStatistic() const;

    /**
     * Returns the current value of the property 'CpuUsageStatistic' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendCpuUsageStatisticUpdate() method.
     *
     * <b>Documentation of 'CpuUsageStatistic'</b>:
     *
     * CPU usage of device. The return values are Max/Average/Min percentage of CPU usage ( CPU consumption tick / CPU overall tick ).  The data will be updated in periodically which is corresponding CPU supervision period (default is 10 sec).  (CCA FID: 0x1053)
     */
    T_SPM_SystemStatisticsData& getCpuUsageStatisticMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCpuUsageStatisticUpdate().
     *
     * <b>Documentation of 'CpuUsageStatistic'</b>:
     *
     * CPU usage of device. The return values are Max/Average/Min percentage of CPU usage ( CPU consumption tick / CPU overall tick ).  The data will be updated in periodically which is corresponding CPU supervision period (default is 10 sec).  (CCA FID: 0x1053)
     */
    void sendCpuUsageStatisticUpdate();

    // property 'RamUsageStatistic'

    /**
     * The method onRamUsageStatisticGet() is called by ASF when a client
     * invokes the read method for the property 'RamUsageStatistic'. The
     * onRamUsageStatisticGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'RamUsageStatistic'</b>:
     *
     * RAM usage of device. The return values are Max/Average/Min percentage of RAM usage ( RAM consumption size / total RAM size ).  The data will be updated in periodically which is corresponding RAM supervision period (default is 10 sec).  (CCA FID: 0x1054)
     */
    virtual void onRamUsageStatisticGet(const ::boost::shared_ptr< RamUsageStatisticGet >& payload);

    /**
     * Sends back the update to a previous onRamUsageStatisticGet().
     *
     * <b>Documentation of 'RamUsageStatistic'</b>:
     *
     * RAM usage of device. The return values are Max/Average/Min percentage of RAM usage ( RAM consumption size / total RAM size ).  The data will be updated in periodically which is corresponding RAM supervision period (default is 10 sec).  (CCA FID: 0x1054)
     *
     * @param act Identifies a previous invocation of
     * onRamUsageStatisticGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRamUsageStatisticGetUpdate(const T_SPM_SystemStatisticsData& ramUsageStatistic, act_t act = 0);

    /**
     * Set the value of the property 'RamUsageStatistic' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'RamUsageStatistic'</b>:
     *
     * RAM usage of device. The return values are Max/Average/Min percentage of RAM usage ( RAM consumption size / total RAM size ).  The data will be updated in periodically which is corresponding RAM supervision period (default is 10 sec).  (CCA FID: 0x1054)
     */
    void setRamUsageStatistic(const T_SPM_SystemStatisticsData& ramUsageStatistic);

    /**
     * Returns the current value of the property 'RamUsageStatistic'.
     *
     * <b>Documentation of 'RamUsageStatistic'</b>:
     *
     * RAM usage of device. The return values are Max/Average/Min percentage of RAM usage ( RAM consumption size / total RAM size ).  The data will be updated in periodically which is corresponding RAM supervision period (default is 10 sec).  (CCA FID: 0x1054)
     */
    const T_SPM_SystemStatisticsData& getRamUsageStatistic() const;

    /**
     * Returns the current value of the property 'RamUsageStatistic' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendRamUsageStatisticUpdate() method.
     *
     * <b>Documentation of 'RamUsageStatistic'</b>:
     *
     * RAM usage of device. The return values are Max/Average/Min percentage of RAM usage ( RAM consumption size / total RAM size ).  The data will be updated in periodically which is corresponding RAM supervision period (default is 10 sec).  (CCA FID: 0x1054)
     */
    T_SPM_SystemStatisticsData& getRamUsageStatisticMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRamUsageStatisticUpdate().
     *
     * <b>Documentation of 'RamUsageStatistic'</b>:
     *
     * RAM usage of device. The return values are Max/Average/Min percentage of RAM usage ( RAM consumption size / total RAM size ).  The data will be updated in periodically which is corresponding RAM supervision period (default is 10 sec).  (CCA FID: 0x1054)
     */
    void sendRamUsageStatisticUpdate();

    // property 'StartupTimeStatistic'

    /**
     * The method onStartupTimeStatisticGet() is called by ASF when a client
     * invokes the read method for the property 'StartupTimeStatistic'. The
     * onStartupTimeStatisticGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'StartupTimeStatistic'</b>:
     *
     * Startup time of device. The return values are Max/Average/Min of start-up time in milliseconds.  The data will be updated every start-up when the STARTUP_STATE_SYSTEM_UP is reached.  (CCA FID: 0x1055)
     */
    virtual void onStartupTimeStatisticGet(const ::boost::shared_ptr< StartupTimeStatisticGet >& payload);

    /**
     * Sends back the update to a previous onStartupTimeStatisticGet().
     *
     * <b>Documentation of 'StartupTimeStatistic'</b>:
     *
     * Startup time of device. The return values are Max/Average/Min of start-up time in milliseconds.  The data will be updated every start-up when the STARTUP_STATE_SYSTEM_UP is reached.  (CCA FID: 0x1055)
     *
     * @param act Identifies a previous invocation of
     * onStartupTimeStatisticGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStartupTimeStatisticGetUpdate(const T_SPM_SystemStatisticsData& startupTimeStatistic, act_t act = 0);

    /**
     * Set the value of the property 'StartupTimeStatistic' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'StartupTimeStatistic'</b>:
     *
     * Startup time of device. The return values are Max/Average/Min of start-up time in milliseconds.  The data will be updated every start-up when the STARTUP_STATE_SYSTEM_UP is reached.  (CCA FID: 0x1055)
     */
    void setStartupTimeStatistic(const T_SPM_SystemStatisticsData& startupTimeStatistic);

    /**
     * Returns the current value of the property 'StartupTimeStatistic'.
     *
     * <b>Documentation of 'StartupTimeStatistic'</b>:
     *
     * Startup time of device. The return values are Max/Average/Min of start-up time in milliseconds.  The data will be updated every start-up when the STARTUP_STATE_SYSTEM_UP is reached.  (CCA FID: 0x1055)
     */
    const T_SPM_SystemStatisticsData& getStartupTimeStatistic() const;

    /**
     * Returns the current value of the property 'StartupTimeStatistic' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendStartupTimeStatisticUpdate() method.
     *
     * <b>Documentation of 'StartupTimeStatistic'</b>:
     *
     * Startup time of device. The return values are Max/Average/Min of start-up time in milliseconds.  The data will be updated every start-up when the STARTUP_STATE_SYSTEM_UP is reached.  (CCA FID: 0x1055)
     */
    T_SPM_SystemStatisticsData& getStartupTimeStatisticMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendStartupTimeStatisticUpdate().
     *
     * <b>Documentation of 'StartupTimeStatistic'</b>:
     *
     * Startup time of device. The return values are Max/Average/Min of start-up time in milliseconds.  The data will be updated every start-up when the STARTUP_STATE_SYSTEM_UP is reached.  (CCA FID: 0x1055)
     */
    void sendStartupTimeStatisticUpdate();

    // property 'RunlevelState'

    /**
     * The method onRunlevelStateGet() is called by ASF when a client invokes
     * the read method for the property 'RunlevelState'. The
     * onRunlevelStateGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'RunlevelState'</b>:
     *
     * Informs about the current runlevel of the system.  (CCA FID: 0x1141)
     */
    virtual void onRunlevelStateGet(const ::boost::shared_ptr< RunlevelStateGet >& payload);

    /**
     * Sends back the update to a previous onRunlevelStateGet().
     *
     * <b>Documentation of 'RunlevelState'</b>:
     *
     * Informs about the current runlevel of the system.  (CCA FID: 0x1141)
     *
     * @param act Identifies a previous invocation of onRunlevelStateGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRunlevelStateGetUpdate(T_SPM_e32_RUNLEVEL runlevelState, act_t act = 0);

    /**
     * Set the value of the property 'RunlevelState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'RunlevelState'</b>:
     *
     * Informs about the current runlevel of the system.  (CCA FID: 0x1141)
     */
    void setRunlevelState(T_SPM_e32_RUNLEVEL runlevelState);

    /**
     * Returns the current value of the property 'RunlevelState'.
     *
     * <b>Documentation of 'RunlevelState'</b>:
     *
     * Informs about the current runlevel of the system.  (CCA FID: 0x1141)
     */
    T_SPM_e32_RUNLEVEL getRunlevelState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRunlevelStateUpdate().
     *
     * <b>Documentation of 'RunlevelState'</b>:
     *
     * Informs about the current runlevel of the system.  (CCA FID: 0x1141)
     */
    void sendRunlevelStateUpdate();

    // property 'Restart'

    /**
     * The method onRestartGet() is called by ASF when a client invokes the
     * read method for the property 'Restart'. The onRestartGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Restart'</b>:
     *
     * OBSOLETE do not use anymore, replaced by Method RestartSystem  (CCA FID: 0x40)
     */
    virtual void onRestartGet(const ::boost::shared_ptr< RestartGet >& payload);

    /**
     * Sends back the update to a previous onRestartGet().
     *
     * <b>Documentation of 'Restart'</b>:
     *
     * OBSOLETE do not use anymore, replaced by Method RestartSystem  (CCA FID: 0x40)
     *
     * @param act Identifies a previous invocation of onRestartGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendRestartGetUpdate(T_SPM_e32_RESTART_TYPE restart, act_t act = 0);

    /**
     * Set the value of the property 'Restart' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Restart'</b>:
     *
     * OBSOLETE do not use anymore, replaced by Method RestartSystem  (CCA FID: 0x40)
     */
    void setRestart(T_SPM_e32_RESTART_TYPE restart);

    /**
     * Returns the current value of the property 'Restart'.
     *
     * <b>Documentation of 'Restart'</b>:
     *
     * OBSOLETE do not use anymore, replaced by Method RestartSystem  (CCA FID: 0x40)
     */
    T_SPM_e32_RESTART_TYPE getRestart() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRestartUpdate().
     *
     * <b>Documentation of 'Restart'</b>:
     *
     * OBSOLETE do not use anymore, replaced by Method RestartSystem  (CCA FID: 0x40)
     */
    void sendRestartUpdate();

    // property 'Lifesign'

    /**
     * The method onLifesignGet() is called by ASF when a client invokes the
     * read method for the property 'Lifesign'. The onLifesignGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Lifesign'</b>:
     *
     * (CCA FID: 0x0275)
     */
    virtual void onLifesignGet(const ::boost::shared_ptr< LifesignGet >& payload);

    /**
     * Sends back the update to a previous onLifesignGet().
     *
     * <b>Documentation of 'Lifesign'</b>:
     *
     * (CCA FID: 0x0275)
     *
     * @param act Identifies a previous invocation of onLifesignGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendLifesignGetUpdate(uint32 lifesign, act_t act = 0);

    /**
     * Set the value of the property 'Lifesign' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Lifesign'</b>:
     *
     * (CCA FID: 0x0275)
     */
    void setLifesign(uint32 lifesign);

    /**
     * Returns the current value of the property 'Lifesign'.
     *
     * <b>Documentation of 'Lifesign'</b>:
     *
     * (CCA FID: 0x0275)
     */
    uint32 getLifesign() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLifesignUpdate().
     *
     * <b>Documentation of 'Lifesign'</b>:
     *
     * (CCA FID: 0x0275)
     */
    void sendLifesignUpdate();

    // property 'HmiState'

    /**
     * The method onHmiStateGet() is called by ASF when a client invokes the
     * read method for the property 'HmiState'. The onHmiStateGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'HmiState'</b>:
     *
     * Set substate of the HMI application.  (CCA FID: 0x10)
     */
    virtual void onHmiStateGet(const ::boost::shared_ptr< HmiStateGet >& payload);

    /**
     * Sends back the update to a previous onHmiStateGet().
     *
     * <b>Documentation of 'HmiState'</b>:
     *
     * Set substate of the HMI application.  (CCA FID: 0x10)
     *
     * @param act Identifies a previous invocation of onHmiStateGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendHmiStateGetUpdate(T_SPM_e32_HMI_STATE hmiState, act_t act = 0);

    /**
     * Set the value of the property 'HmiState' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'HmiState'</b>:
     *
     * Set substate of the HMI application.  (CCA FID: 0x10)
     */
    void setHmiState(T_SPM_e32_HMI_STATE hmiState);

    /**
     * Returns the current value of the property 'HmiState'.
     *
     * <b>Documentation of 'HmiState'</b>:
     *
     * Set substate of the HMI application.  (CCA FID: 0x10)
     */
    T_SPM_e32_HMI_STATE getHmiState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendHmiStateUpdate().
     *
     * <b>Documentation of 'HmiState'</b>:
     *
     * Set substate of the HMI application.  (CCA FID: 0x10)
     */
    void sendHmiStateUpdate();

    // property 'SystemPowerBehaviour'

    /**
     * The method onSystemPowerBehaviourGet() is called by ASF when a client
     * invokes the read method for the property 'SystemPowerBehaviour'. The
     * onSystemPowerBehaviourGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'SystemPowerBehaviour'</b>:
     *
     * Information about special SPM/LCM handled events. E.g. in VW HMI has to display a pop-up when incoming LowBattery status message via CAN is received.  (CCA FID: 0x1010)
     */
    virtual void onSystemPowerBehaviourGet(const ::boost::shared_ptr< SystemPowerBehaviourGet >& payload);

    /**
     * Sends back the update to a previous onSystemPowerBehaviourGet().
     *
     * <b>Documentation of 'SystemPowerBehaviour'</b>:
     *
     * Information about special SPM/LCM handled events. E.g. in VW HMI has to display a pop-up when incoming LowBattery status message via CAN is received.  (CCA FID: 0x1010)
     *
     * @param act Identifies a previous invocation of
     * onSystemPowerBehaviourGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSystemPowerBehaviourGetUpdate(T_SPM_e32_SYSPWR_BEHAVIOUR systemPowerBehaviour, act_t act = 0);

    /**
     * Set the value of the property 'SystemPowerBehaviour' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'SystemPowerBehaviour'</b>:
     *
     * Information about special SPM/LCM handled events. E.g. in VW HMI has to display a pop-up when incoming LowBattery status message via CAN is received.  (CCA FID: 0x1010)
     */
    void setSystemPowerBehaviour(T_SPM_e32_SYSPWR_BEHAVIOUR systemPowerBehaviour);

    /**
     * Returns the current value of the property 'SystemPowerBehaviour'.
     *
     * <b>Documentation of 'SystemPowerBehaviour'</b>:
     *
     * Information about special SPM/LCM handled events. E.g. in VW HMI has to display a pop-up when incoming LowBattery status message via CAN is received.  (CCA FID: 0x1010)
     */
    T_SPM_e32_SYSPWR_BEHAVIOUR getSystemPowerBehaviour() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSystemPowerBehaviourUpdate().
     *
     * <b>Documentation of 'SystemPowerBehaviour'</b>:
     *
     * Information about special SPM/LCM handled events. E.g. in VW HMI has to display a pop-up when incoming LowBattery status message via CAN is received.  (CCA FID: 0x1010)
     */
    void sendSystemPowerBehaviourUpdate();

    // property 'DimState'

    /**
     * The method onDimStateGet() is called by ASF when a client invokes the
     * read method for the property 'DimState'. The onDimStateGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'DimState'</b>:
     *
     * !!! OBSOLETE DO NOT USE ANYMORE !!! -- use bit-coded property DimmingState with same functionality. Set substate of the DIMMING application.  (CCA FID: 0x11)
     */
    virtual void onDimStateGet(const ::boost::shared_ptr< DimStateGet >& payload);

    /**
     * Sends back the update to a previous onDimStateGet().
     *
     * <b>Documentation of 'DimState'</b>:
     *
     * !!! OBSOLETE DO NOT USE ANYMORE !!! -- use bit-coded property DimmingState with same functionality. Set substate of the DIMMING application.  (CCA FID: 0x11)
     *
     * @param act Identifies a previous invocation of onDimStateGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendDimStateGetUpdate(T_SPM_e32_DIM_STATE dimState, act_t act = 0);

    /**
     * Set the value of the property 'DimState' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'DimState'</b>:
     *
     * !!! OBSOLETE DO NOT USE ANYMORE !!! -- use bit-coded property DimmingState with same functionality. Set substate of the DIMMING application.  (CCA FID: 0x11)
     */
    void setDimState(T_SPM_e32_DIM_STATE dimState);

    /**
     * Returns the current value of the property 'DimState'.
     *
     * <b>Documentation of 'DimState'</b>:
     *
     * !!! OBSOLETE DO NOT USE ANYMORE !!! -- use bit-coded property DimmingState with same functionality. Set substate of the DIMMING application.  (CCA FID: 0x11)
     */
    T_SPM_e32_DIM_STATE getDimState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDimStateUpdate().
     *
     * <b>Documentation of 'DimState'</b>:
     *
     * !!! OBSOLETE DO NOT USE ANYMORE !!! -- use bit-coded property DimmingState with same functionality. Set substate of the DIMMING application.  (CCA FID: 0x11)
     */
    void sendDimStateUpdate();

    // property 'DimmingState'

    /**
     * The method onDimmingStateGet() is called by ASF when a client invokes
     * the read method for the property 'DimmingState'. The
     * onDimmingStateGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'DimmingState'</b>:
     *
     * Information about dimming states from LCM point of view for e.g. backlight.  (CCA FID: 0x1011)
     */
    virtual void onDimmingStateGet(const ::boost::shared_ptr< DimmingStateGet >& payload);

    /**
     * Sends back the update to a previous onDimmingStateGet().
     *
     * <b>Documentation of 'DimmingState'</b>:
     *
     * Information about dimming states from LCM point of view for e.g. backlight.  (CCA FID: 0x1011)
     *
     * @param act Identifies a previous invocation of onDimmingStateGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDimmingStateGetUpdate(const T_SPM_b32_DIM_STATE& dimmingState, act_t act = 0);

    /**
     * Set the value of the property 'DimmingState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'DimmingState'</b>:
     *
     * Information about dimming states from LCM point of view for e.g. backlight.  (CCA FID: 0x1011)
     */
    void setDimmingState(const T_SPM_b32_DIM_STATE& dimmingState);

    /**
     * Returns the current value of the property 'DimmingState'.
     *
     * <b>Documentation of 'DimmingState'</b>:
     *
     * Information about dimming states from LCM point of view for e.g. backlight.  (CCA FID: 0x1011)
     */
    const T_SPM_b32_DIM_STATE& getDimmingState() const;

    /**
     * Returns the current value of the property 'DimmingState' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendDimmingStateUpdate() method.
     *
     * <b>Documentation of 'DimmingState'</b>:
     *
     * Information about dimming states from LCM point of view for e.g. backlight.  (CCA FID: 0x1011)
     */
    T_SPM_b32_DIM_STATE& getDimmingStateMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDimmingStateUpdate().
     *
     * <b>Documentation of 'DimmingState'</b>:
     *
     * Information about dimming states from LCM point of view for e.g. backlight.  (CCA FID: 0x1011)
     */
    void sendDimmingStateUpdate();

    // property 'BluetoothState'

    /**
     * The method onBluetoothStateGet() is called by ASF when a client invokes
     * the read method for the property 'BluetoothState'. The
     * onBluetoothStateGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'BluetoothState'</b>:
     *
     * Set application specific substate of the phone applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x13)
     */
    virtual void onBluetoothStateGet(const ::boost::shared_ptr< BluetoothStateGet >& payload);

    /**
     * Sends back the update to a previous onBluetoothStateGet().
     *
     * <b>Documentation of 'BluetoothState'</b>:
     *
     * Set application specific substate of the phone applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x13)
     *
     * @param act Identifies a previous invocation of onBluetoothStateGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendBluetoothStateGetUpdate(T_SPM_e32_BT_STATE bluetoothState, act_t act = 0);

    /**
     * Set the value of the property 'BluetoothState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'BluetoothState'</b>:
     *
     * Set application specific substate of the phone applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x13)
     */
    void setBluetoothState(T_SPM_e32_BT_STATE bluetoothState);

    /**
     * Returns the current value of the property 'BluetoothState'.
     *
     * <b>Documentation of 'BluetoothState'</b>:
     *
     * Set application specific substate of the phone applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x13)
     */
    T_SPM_e32_BT_STATE getBluetoothState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendBluetoothStateUpdate().
     *
     * <b>Documentation of 'BluetoothState'</b>:
     *
     * Set application specific substate of the phone applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x13)
     */
    void sendBluetoothStateUpdate();

    // property 'AudioState'

    /**
     * The method onAudioStateGet() is called by ASF when a client invokes the
     * read method for the property 'AudioState'. The onAudioStateGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'AudioState'</b>:
     *
     * Set application specific substate of the audio applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x14)
     */
    virtual void onAudioStateGet(const ::boost::shared_ptr< AudioStateGet >& payload);

    /**
     * Sends back the update to a previous onAudioStateGet().
     *
     * <b>Documentation of 'AudioState'</b>:
     *
     * Set application specific substate of the audio applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x14)
     *
     * @param act Identifies a previous invocation of onAudioStateGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendAudioStateGetUpdate(T_SPM_e32_AUDIO_STATE audioState, act_t act = 0);

    /**
     * Set the value of the property 'AudioState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'AudioState'</b>:
     *
     * Set application specific substate of the audio applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x14)
     */
    void setAudioState(T_SPM_e32_AUDIO_STATE audioState);

    /**
     * Returns the current value of the property 'AudioState'.
     *
     * <b>Documentation of 'AudioState'</b>:
     *
     * Set application specific substate of the audio applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x14)
     */
    T_SPM_e32_AUDIO_STATE getAudioState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAudioStateUpdate().
     *
     * <b>Documentation of 'AudioState'</b>:
     *
     * Set application specific substate of the audio applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x14)
     */
    void sendAudioStateUpdate();

    // property 'SpiState'

    /**
     * The method onSpiStateGet() is called by ASF when a client invokes the
     * read method for the property 'SpiState'. The onSpiStateGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'SpiState'</b>:
     *
     * Set application specific substate of the SmartPhoneIntegration applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x15)
     */
    virtual void onSpiStateGet(const ::boost::shared_ptr< SpiStateGet >& payload);

    /**
     * Sends back the update to a previous onSpiStateGet().
     *
     * <b>Documentation of 'SpiState'</b>:
     *
     * Set application specific substate of the SmartPhoneIntegration applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x15)
     *
     * @param act Identifies a previous invocation of onSpiStateGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSpiStateGetUpdate(T_SPM_e32_SPI_STATE spiState, act_t act = 0);

    /**
     * Set the value of the property 'SpiState' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'SpiState'</b>:
     *
     * Set application specific substate of the SmartPhoneIntegration applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x15)
     */
    void setSpiState(T_SPM_e32_SPI_STATE spiState);

    /**
     * Returns the current value of the property 'SpiState'.
     *
     * <b>Documentation of 'SpiState'</b>:
     *
     * Set application specific substate of the SmartPhoneIntegration applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x15)
     */
    T_SPM_e32_SPI_STATE getSpiState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSpiStateUpdate().
     *
     * <b>Documentation of 'SpiState'</b>:
     *
     * Set application specific substate of the SmartPhoneIntegration applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x15)
     */
    void sendSpiStateUpdate();

    // property 'TunerState'

    /**
     * The method onTunerStateGet() is called by ASF when a client invokes the
     * read method for the property 'TunerState'. The onTunerStateGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'TunerState'</b>:
     *
     * Set application specific substate of the Tuner applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x17)
     */
    virtual void onTunerStateGet(const ::boost::shared_ptr< TunerStateGet >& payload);

    /**
     * Sends back the update to a previous onTunerStateGet().
     *
     * <b>Documentation of 'TunerState'</b>:
     *
     * Set application specific substate of the Tuner applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x17)
     *
     * @param act Identifies a previous invocation of onTunerStateGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendTunerStateGetUpdate(T_SPM_e32_TUNER_STATE tunerState, act_t act = 0);

    /**
     * Set the value of the property 'TunerState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'TunerState'</b>:
     *
     * Set application specific substate of the Tuner applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x17)
     */
    void setTunerState(T_SPM_e32_TUNER_STATE tunerState);

    /**
     * Returns the current value of the property 'TunerState'.
     *
     * <b>Documentation of 'TunerState'</b>:
     *
     * Set application specific substate of the Tuner applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x17)
     */
    T_SPM_e32_TUNER_STATE getTunerState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTunerStateUpdate().
     *
     * <b>Documentation of 'TunerState'</b>:
     *
     * Set application specific substate of the Tuner applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x17)
     */
    void sendTunerStateUpdate();

    // property 'WifiState'

    /**
     * The method onWifiStateGet() is called by ASF when a client invokes the
     * read method for the property 'WifiState'. The onWifiStateGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'WifiState'</b>:
     *
     * Set application specific substate of the connectivity applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x19)
     */
    virtual void onWifiStateGet(const ::boost::shared_ptr< WifiStateGet >& payload);

    /**
     * Sends back the update to a previous onWifiStateGet().
     *
     * <b>Documentation of 'WifiState'</b>:
     *
     * Set application specific substate of the connectivity applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x19)
     *
     * @param act Identifies a previous invocation of onWifiStateGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendWifiStateGetUpdate(T_SPM_e32_WIFI_STATE wifiState, act_t act = 0);

    /**
     * Set the value of the property 'WifiState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'WifiState'</b>:
     *
     * Set application specific substate of the connectivity applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x19)
     */
    void setWifiState(T_SPM_e32_WIFI_STATE wifiState);

    /**
     * Returns the current value of the property 'WifiState'.
     *
     * <b>Documentation of 'WifiState'</b>:
     *
     * Set application specific substate of the connectivity applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x19)
     */
    T_SPM_e32_WIFI_STATE getWifiState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendWifiStateUpdate().
     *
     * <b>Documentation of 'WifiState'</b>:
     *
     * Set application specific substate of the connectivity applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x19)
     */
    void sendWifiStateUpdate();

    // property 'OnOffReason'

    /**
     * The method onOnOffReasonGet() is called by ASF when a client invokes
     * the read method for the property 'OnOffReason'. The onOnOffReasonGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'OnOffReason'</b>:
     *
     * OBSOLETE INTERFACE, ONLY STILL HERE FOR MY16 DIAGNOSIS, will be removed soon! Set a new OnOff reason. New system state will be calculated. FUNCID = FID_SPM_SUBSTATE, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAGDEBUG, CCA_C_U16_APP_DOWNLOAD  (CCA FID: 0x02)
     */
    virtual void onOnOffReasonGet(const ::boost::shared_ptr< OnOffReasonGet >& payload);

    /**
     * Sends back the update to a previous onOnOffReasonGet().
     *
     * <b>Documentation of 'OnOffReason'</b>:
     *
     * OBSOLETE INTERFACE, ONLY STILL HERE FOR MY16 DIAGNOSIS, will be removed soon! Set a new OnOff reason. New system state will be calculated. FUNCID = FID_SPM_SUBSTATE, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAGDEBUG, CCA_C_U16_APP_DOWNLOAD  (CCA FID: 0x02)
     *
     * @param act Identifies a previous invocation of onOnOffReasonGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendOnOffReasonGetUpdate(T_SPM_e32_OnOffReason onOffReason, act_t act = 0);

    /**
     * Set the value of the property 'OnOffReason' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'OnOffReason'</b>:
     *
     * OBSOLETE INTERFACE, ONLY STILL HERE FOR MY16 DIAGNOSIS, will be removed soon! Set a new OnOff reason. New system state will be calculated. FUNCID = FID_SPM_SUBSTATE, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAGDEBUG, CCA_C_U16_APP_DOWNLOAD  (CCA FID: 0x02)
     */
    void setOnOffReason(T_SPM_e32_OnOffReason onOffReason);

    /**
     * Returns the current value of the property 'OnOffReason'.
     *
     * <b>Documentation of 'OnOffReason'</b>:
     *
     * OBSOLETE INTERFACE, ONLY STILL HERE FOR MY16 DIAGNOSIS, will be removed soon! Set a new OnOff reason. New system state will be calculated. FUNCID = FID_SPM_SUBSTATE, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAGDEBUG, CCA_C_U16_APP_DOWNLOAD  (CCA FID: 0x02)
     */
    T_SPM_e32_OnOffReason getOnOffReason() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendOnOffReasonUpdate().
     *
     * <b>Documentation of 'OnOffReason'</b>:
     *
     * OBSOLETE INTERFACE, ONLY STILL HERE FOR MY16 DIAGNOSIS, will be removed soon! Set a new OnOff reason. New system state will be calculated. FUNCID = FID_SPM_SUBSTATE, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAGDEBUG, CCA_C_U16_APP_DOWNLOAD  (CCA FID: 0x02)
     */
    void sendOnOffReasonUpdate();

    // property 'WakeupList'

    /**
     * The method onWakeupListGet() is called by ASF when a client invokes the
     * read method for the property 'WakeupList'. The onWakeupListGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'WakeupList'</b>:
     *
     * Get reset count. FUNCID = FID_SPM_WAKEUP_LIST, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x42)
     */
    virtual void onWakeupListGet(const ::boost::shared_ptr< WakeupListGet >& payload);

    /**
     * Sends back the update to a previous onWakeupListGet().
     *
     * <b>Documentation of 'WakeupList'</b>:
     *
     * Get reset count. FUNCID = FID_SPM_WAKEUP_LIST, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x42)
     *
     * @param act Identifies a previous invocation of onWakeupListGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendWakeupListGetUpdate(const TWakeupList& wakeupList, act_t act = 0);

    /**
     * Set the value of the property 'WakeupList' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'WakeupList'</b>:
     *
     * Get reset count. FUNCID = FID_SPM_WAKEUP_LIST, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x42)
     */
    void setWakeupList(const TWakeupList& wakeupList);

    /**
     * Returns the current value of the property 'WakeupList'.
     *
     * <b>Documentation of 'WakeupList'</b>:
     *
     * Get reset count. FUNCID = FID_SPM_WAKEUP_LIST, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x42)
     */
    const TWakeupList& getWakeupList() const;

    /**
     * Returns the current value of the property 'WakeupList' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendWakeupListUpdate() method.
     *
     * <b>Documentation of 'WakeupList'</b>:
     *
     * Get reset count. FUNCID = FID_SPM_WAKEUP_LIST, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x42)
     */
    TWakeupList& getWakeupListMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendWakeupListUpdate().
     *
     * <b>Documentation of 'WakeupList'</b>:
     *
     * Get reset count. FUNCID = FID_SPM_WAKEUP_LIST, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x42)
     */
    void sendWakeupListUpdate();

    // property 'StartupFinished'

    /**
     * The method onStartupFinishedGet() is called by ASF when a client
     * invokes the read method for the property 'StartupFinished'. The
     * onStartupFinishedGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'StartupFinished'</b>:
     *
     * FUNCID = FID_SPM_STARTUP_FINISHED, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_xx   (CCA FID: 0x0105)
     */
    virtual void onStartupFinishedGet(const ::boost::shared_ptr< StartupFinishedGet >& payload);

    /**
     * Sends back the update to a previous onStartupFinishedGet().
     *
     * <b>Documentation of 'StartupFinished'</b>:
     *
     * FUNCID = FID_SPM_STARTUP_FINISHED, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_xx   (CCA FID: 0x0105)
     *
     * @param act Identifies a previous invocation of onStartupFinishedGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStartupFinishedGetUpdate(bool startupFinished, act_t act = 0);

    /**
     * Set the value of the property 'StartupFinished' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'StartupFinished'</b>:
     *
     * FUNCID = FID_SPM_STARTUP_FINISHED, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_xx   (CCA FID: 0x0105)
     */
    void setStartupFinished(bool startupFinished);

    /**
     * Returns the current value of the property 'StartupFinished'.
     *
     * <b>Documentation of 'StartupFinished'</b>:
     *
     * FUNCID = FID_SPM_STARTUP_FINISHED, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_xx   (CCA FID: 0x0105)
     */
    bool getStartupFinished() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendStartupFinishedUpdate().
     *
     * <b>Documentation of 'StartupFinished'</b>:
     *
     * FUNCID = FID_SPM_STARTUP_FINISHED, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_xx   (CCA FID: 0x0105)
     */
    void sendStartupFinishedUpdate();

    // property 'SysState'

    /**
     * The method onSysStateGet() is called by ASF when a client invokes the
     * read method for the property 'SysState'. The onSysStateGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'SysState'</b>:
     *
     * Set substate of the HMI application.  (CCA FID: 0x0302)
     */
    virtual void onSysStateGet(const ::boost::shared_ptr< SysStateGet >& payload);

    /**
     * Sends back the update to a previous onSysStateGet().
     *
     * <b>Documentation of 'SysState'</b>:
     *
     * Set substate of the HMI application.  (CCA FID: 0x0302)
     *
     * @param act Identifies a previous invocation of onSysStateGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSysStateGetUpdate(T_SPM_e32_SYS_STATE sysState, act_t act = 0);

    /**
     * Set the value of the property 'SysState' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'SysState'</b>:
     *
     * Set substate of the HMI application.  (CCA FID: 0x0302)
     */
    void setSysState(T_SPM_e32_SYS_STATE sysState);

    /**
     * Returns the current value of the property 'SysState'.
     *
     * <b>Documentation of 'SysState'</b>:
     *
     * Set substate of the HMI application.  (CCA FID: 0x0302)
     */
    T_SPM_e32_SYS_STATE getSysState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSysStateUpdate().
     *
     * <b>Documentation of 'SysState'</b>:
     *
     * Set substate of the HMI application.  (CCA FID: 0x0302)
     */
    void sendSysStateUpdate();

    // property 'MostState'

    /**
     * The method onMostStateGet() is called by ASF when a client invokes the
     * read method for the property 'MostState'. The onMostStateGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'MostState'</b>:
     *
     * The CMA (CCA Most Adapter) shall be the only component which handles this MOST event.  (CCA FID: 0x0303)
     */
    virtual void onMostStateGet(const ::boost::shared_ptr< MostStateGet >& payload);

    /**
     * Sends back the update to a previous onMostStateGet().
     *
     * <b>Documentation of 'MostState'</b>:
     *
     * The CMA (CCA Most Adapter) shall be the only component which handles this MOST event.  (CCA FID: 0x0303)
     *
     * @param act Identifies a previous invocation of onMostStateGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendMostStateGetUpdate(const TMostState& mostState, act_t act = 0);

    /**
     * Set the value of the property 'MostState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'MostState'</b>:
     *
     * The CMA (CCA Most Adapter) shall be the only component which handles this MOST event.  (CCA FID: 0x0303)
     */
    void setMostState(const TMostState& mostState);

    /**
     * Returns the current value of the property 'MostState'.
     *
     * <b>Documentation of 'MostState'</b>:
     *
     * The CMA (CCA Most Adapter) shall be the only component which handles this MOST event.  (CCA FID: 0x0303)
     */
    const TMostState& getMostState() const;

    /**
     * Returns the current value of the property 'MostState' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendMostStateUpdate() method.
     *
     * <b>Documentation of 'MostState'</b>:
     *
     * The CMA (CCA Most Adapter) shall be the only component which handles this MOST event.  (CCA FID: 0x0303)
     */
    TMostState& getMostStateMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendMostStateUpdate().
     *
     * <b>Documentation of 'MostState'</b>:
     *
     * The CMA (CCA Most Adapter) shall be the only component which handles this MOST event.  (CCA FID: 0x0303)
     */
    void sendMostStateUpdate();

    // property 'MostVersion'

    /**
     * The method onMostVersionGet() is called by ASF when a client invokes
     * the read method for the property 'MostVersion'. The onMostVersionGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'MostVersion'</b>:
     *
     * The MOST version of the MOST stack used in the system  (CCA FID: 0x0304)
     */
    virtual void onMostVersionGet(const ::boost::shared_ptr< MostVersionGet >& payload);

    /**
     * Sends back the update to a previous onMostVersionGet().
     *
     * <b>Documentation of 'MostVersion'</b>:
     *
     * The MOST version of the MOST stack used in the system  (CCA FID: 0x0304)
     *
     * @param act Identifies a previous invocation of onMostVersionGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendMostVersionGetUpdate(const ::std::string& mostVersion, act_t act = 0);

    /**
     * Set the value of the property 'MostVersion' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'MostVersion'</b>:
     *
     * The MOST version of the MOST stack used in the system  (CCA FID: 0x0304)
     */
    void setMostVersion(const ::std::string& mostVersion);

    /**
     * Returns the current value of the property 'MostVersion'.
     *
     * <b>Documentation of 'MostVersion'</b>:
     *
     * The MOST version of the MOST stack used in the system  (CCA FID: 0x0304)
     */
    const ::std::string& getMostVersion() const;

    /**
     * Returns the current value of the property 'MostVersion' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendMostVersionUpdate() method.
     *
     * <b>Documentation of 'MostVersion'</b>:
     *
     * The MOST version of the MOST stack used in the system  (CCA FID: 0x0304)
     */
    ::std::string& getMostVersionMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendMostVersionUpdate().
     *
     * <b>Documentation of 'MostVersion'</b>:
     *
     * The MOST version of the MOST stack used in the system  (CCA FID: 0x0304)
     */
    void sendMostVersionUpdate();

    // property 'RVCState'

    /**
     * The method onRVCStateGet() is called by ASF when a client invokes the
     * read method for the property 'RVCState'. The onRVCStateGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'RVCState'</b>:
     *
     * Rear View Camera state of the system  (CCA FID: 0x0235)
     */
    virtual void onRVCStateGet(const ::boost::shared_ptr< RVCStateGet >& payload);

    /**
     * Sends back the update to a previous onRVCStateGet().
     *
     * <b>Documentation of 'RVCState'</b>:
     *
     * Rear View Camera state of the system  (CCA FID: 0x0235)
     *
     * @param act Identifies a previous invocation of onRVCStateGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendRVCStateGetUpdate(bool rVCState, act_t act = 0);

    /**
     * Set the value of the property 'RVCState' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'RVCState'</b>:
     *
     * Rear View Camera state of the system  (CCA FID: 0x0235)
     */
    void setRVCState(bool rVCState);

    /**
     * Returns the current value of the property 'RVCState'.
     *
     * <b>Documentation of 'RVCState'</b>:
     *
     * Rear View Camera state of the system  (CCA FID: 0x0235)
     */
    bool getRVCState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRVCStateUpdate().
     *
     * <b>Documentation of 'RVCState'</b>:
     *
     * Rear View Camera state of the system  (CCA FID: 0x0235)
     */
    void sendRVCStateUpdate();

    // property 'TriggerMostRemoteReset'

    /**
     * The method onTriggerMostRemoteResetGet() is called by ASF when a client
     * invokes the read method for the property 'TriggerMostRemoteReset'. The
     * onTriggerMostRemoteResetGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'TriggerMostRemoteReset'</b>:
     *
     * (CCA FID: 0x0701)
     */
    virtual void onTriggerMostRemoteResetGet(const ::boost::shared_ptr< TriggerMostRemoteResetGet >& payload);

    /**
     * Sends back the update to a previous onTriggerMostRemoteResetGet().
     *
     * <b>Documentation of 'TriggerMostRemoteReset'</b>:
     *
     * (CCA FID: 0x0701)
     *
     * @param act Identifies a previous invocation of
     * onTriggerMostRemoteResetGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendTriggerMostRemoteResetGetUpdate(uint32 triggerMostRemoteReset, act_t act = 0);

    /**
     * Set the value of the property 'TriggerMostRemoteReset' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'TriggerMostRemoteReset'</b>:
     *
     * (CCA FID: 0x0701)
     */
    void setTriggerMostRemoteReset(uint32 triggerMostRemoteReset);

    /**
     * Returns the current value of the property 'TriggerMostRemoteReset'.
     *
     * <b>Documentation of 'TriggerMostRemoteReset'</b>:
     *
     * (CCA FID: 0x0701)
     */
    uint32 getTriggerMostRemoteReset() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTriggerMostRemoteResetUpdate().
     *
     * <b>Documentation of 'TriggerMostRemoteReset'</b>:
     *
     * (CCA FID: 0x0701)
     */
    void sendTriggerMostRemoteResetUpdate();

    // property 'Partnumber'

    /**
     * The method onPartnumberGet() is called by ASF when a client invokes the
     * read method for the property 'Partnumber'. The onPartnumberGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Partnumber'</b>:
     *
     * (CCA FID: 0x0702)
     */
    virtual void onPartnumberGet(const ::boost::shared_ptr< PartnumberGet >& payload);

    /**
     * Sends back the update to a previous onPartnumberGet().
     *
     * <b>Documentation of 'Partnumber'</b>:
     *
     * (CCA FID: 0x0702)
     *
     * @param act Identifies a previous invocation of onPartnumberGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPartnumberGetUpdate(uint32 partnumber, act_t act = 0);

    /**
     * Set the value of the property 'Partnumber' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Partnumber'</b>:
     *
     * (CCA FID: 0x0702)
     */
    void setPartnumber(uint32 partnumber);

    /**
     * Returns the current value of the property 'Partnumber'.
     *
     * <b>Documentation of 'Partnumber'</b>:
     *
     * (CCA FID: 0x0702)
     */
    uint32 getPartnumber() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPartnumberUpdate().
     *
     * <b>Documentation of 'Partnumber'</b>:
     *
     * (CCA FID: 0x0702)
     */
    void sendPartnumberUpdate();

    // property 'Partnumbers'

    /**
     * The method onPartnumbersGet() is called by ASF when a client invokes
     * the read method for the property 'Partnumbers'. The onPartnumbersGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'Partnumbers'</b>:
     *
     * (CCA FID: 0x0703)
     */
    virtual void onPartnumbersGet(const ::boost::shared_ptr< PartnumbersGet >& payload);

    /**
     * Sends back the update to a previous onPartnumbersGet().
     *
     * <b>Documentation of 'Partnumbers'</b>:
     *
     * (CCA FID: 0x0703)
     *
     * @param act Identifies a previous invocation of onPartnumbersGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPartnumbersGetUpdate(const T_SPM_PartnumberList& partnumbers, act_t act = 0);

    /**
     * Set the value of the property 'Partnumbers' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Partnumbers'</b>:
     *
     * (CCA FID: 0x0703)
     */
    void setPartnumbers(const T_SPM_PartnumberList& partnumbers);

    /**
     * Returns the current value of the property 'Partnumbers'.
     *
     * <b>Documentation of 'Partnumbers'</b>:
     *
     * (CCA FID: 0x0703)
     */
    const T_SPM_PartnumberList& getPartnumbers() const;

    /**
     * Returns the current value of the property 'Partnumbers' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendPartnumbersUpdate() method.
     *
     * <b>Documentation of 'Partnumbers'</b>:
     *
     * (CCA FID: 0x0703)
     */
    T_SPM_PartnumberList& getPartnumbersMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPartnumbersUpdate().
     *
     * <b>Documentation of 'Partnumbers'</b>:
     *
     * (CCA FID: 0x0703)
     */
    void sendPartnumbersUpdate();

    // property 'Alphacode'

    /**
     * The method onAlphacodeGet() is called by ASF when a client invokes the
     * read method for the property 'Alphacode'. The onAlphacodeGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Alphacode'</b>:
     *
     * (CCA FID: 0x0704)
     */
    virtual void onAlphacodeGet(const ::boost::shared_ptr< AlphacodeGet >& payload);

    /**
     * Sends back the update to a previous onAlphacodeGet().
     *
     * <b>Documentation of 'Alphacode'</b>:
     *
     * (CCA FID: 0x0704)
     *
     * @param act Identifies a previous invocation of onAlphacodeGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendAlphacodeGetUpdate(const TAlphacode& alphacode, act_t act = 0);

    /**
     * Set the value of the property 'Alphacode' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Alphacode'</b>:
     *
     * (CCA FID: 0x0704)
     */
    void setAlphacode(const TAlphacode& alphacode);

    /**
     * Returns the current value of the property 'Alphacode'.
     *
     * <b>Documentation of 'Alphacode'</b>:
     *
     * (CCA FID: 0x0704)
     */
    const TAlphacode& getAlphacode() const;

    /**
     * Returns the current value of the property 'Alphacode' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendAlphacodeUpdate() method.
     *
     * <b>Documentation of 'Alphacode'</b>:
     *
     * (CCA FID: 0x0704)
     */
    TAlphacode& getAlphacodeMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAlphacodeUpdate().
     *
     * <b>Documentation of 'Alphacode'</b>:
     *
     * (CCA FID: 0x0704)
     */
    void sendAlphacodeUpdate();

    // property 'Alphacodes'

    /**
     * The method onAlphacodesGet() is called by ASF when a client invokes the
     * read method for the property 'Alphacodes'. The onAlphacodesGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Alphacodes'</b>:
     *
     * (CCA FID: 0x0705)
     */
    virtual void onAlphacodesGet(const ::boost::shared_ptr< AlphacodesGet >& payload);

    /**
     * Sends back the update to a previous onAlphacodesGet().
     *
     * <b>Documentation of 'Alphacodes'</b>:
     *
     * (CCA FID: 0x0705)
     *
     * @param act Identifies a previous invocation of onAlphacodesGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendAlphacodesGetUpdate(const T_SPM_AlphacodeList& alphacodes, act_t act = 0);

    /**
     * Set the value of the property 'Alphacodes' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Alphacodes'</b>:
     *
     * (CCA FID: 0x0705)
     */
    void setAlphacodes(const T_SPM_AlphacodeList& alphacodes);

    /**
     * Returns the current value of the property 'Alphacodes'.
     *
     * <b>Documentation of 'Alphacodes'</b>:
     *
     * (CCA FID: 0x0705)
     */
    const T_SPM_AlphacodeList& getAlphacodes() const;

    /**
     * Returns the current value of the property 'Alphacodes' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendAlphacodesUpdate() method.
     *
     * <b>Documentation of 'Alphacodes'</b>:
     *
     * (CCA FID: 0x0705)
     */
    T_SPM_AlphacodeList& getAlphacodesMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAlphacodesUpdate().
     *
     * <b>Documentation of 'Alphacodes'</b>:
     *
     * (CCA FID: 0x0705)
     */
    void sendAlphacodesUpdate();

    // property 'ManufacturersEnableCounter'

    /**
     * The method onManufacturersEnableCounterGet() is called by ASF when a
     * client invokes the read method for the property
     * 'ManufacturersEnableCounter'. The onManufacturersEnableCounterGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'ManufacturersEnableCounter'</b>:
     *
     * This property is used to set/get the Manufacturer's Enable Counter (InternalMEC).  (CCA FID: 0x0604)
     */
    virtual void onManufacturersEnableCounterGet(const ::boost::shared_ptr< ManufacturersEnableCounterGet >& payload);

    /**
     * Sends back the update to a previous onManufacturersEnableCounterGet().
     *
     * <b>Documentation of 'ManufacturersEnableCounter'</b>:
     *
     * This property is used to set/get the Manufacturer's Enable Counter (InternalMEC).  (CCA FID: 0x0604)
     *
     * @param act Identifies a previous invocation of
     * onManufacturersEnableCounterGet(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendManufacturersEnableCounterGetUpdate(uint8 manufacturersEnableCounter, act_t act = 0);

    /**
     * Set the value of the property 'ManufacturersEnableCounter' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'ManufacturersEnableCounter'</b>:
     *
     * This property is used to set/get the Manufacturer's Enable Counter (InternalMEC).  (CCA FID: 0x0604)
     */
    void setManufacturersEnableCounter(uint8 manufacturersEnableCounter);

    /**
     * Returns the current value of the property 'ManufacturersEnableCounter'.
     *
     * <b>Documentation of 'ManufacturersEnableCounter'</b>:
     *
     * This property is used to set/get the Manufacturer's Enable Counter (InternalMEC).  (CCA FID: 0x0604)
     */
    uint8 getManufacturersEnableCounter() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendManufacturersEnableCounterUpdate().
     *
     * <b>Documentation of 'ManufacturersEnableCounter'</b>:
     *
     * This property is used to set/get the Manufacturer's Enable Counter (InternalMEC).  (CCA FID: 0x0604)
     */
    void sendManufacturersEnableCounterUpdate();

    // property 'NoCalibrationState'

    /**
     * The method onNoCalibrationStateGet() is called by ASF when a client
     * invokes the read method for the property 'NoCalibrationState'. The
     * onNoCalibrationStateGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'NoCalibrationState'</b>:
     *
     * This property is used to inform the FC SPM about the No Calibration State of Maintenance (FC DIAGNOSIS). (CCA FID: 0x0605)
     */
    virtual void onNoCalibrationStateGet(const ::boost::shared_ptr< NoCalibrationStateGet >& payload);

    /**
     * Sends back the update to a previous onNoCalibrationStateGet().
     *
     * <b>Documentation of 'NoCalibrationState'</b>:
     *
     * This property is used to inform the FC SPM about the No Calibration State of Maintenance (FC DIAGNOSIS). (CCA FID: 0x0605)
     *
     * @param act Identifies a previous invocation of
     * onNoCalibrationStateGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendNoCalibrationStateGetUpdate(bool noCalibrationState, act_t act = 0);

    /**
     * Set the value of the property 'NoCalibrationState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'NoCalibrationState'</b>:
     *
     * This property is used to inform the FC SPM about the No Calibration State of Maintenance (FC DIAGNOSIS). (CCA FID: 0x0605)
     */
    void setNoCalibrationState(bool noCalibrationState);

    /**
     * Returns the current value of the property 'NoCalibrationState'.
     *
     * <b>Documentation of 'NoCalibrationState'</b>:
     *
     * This property is used to inform the FC SPM about the No Calibration State of Maintenance (FC DIAGNOSIS). (CCA FID: 0x0605)
     */
    bool getNoCalibrationState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNoCalibrationStateUpdate().
     *
     * <b>Documentation of 'NoCalibrationState'</b>:
     *
     * This property is used to inform the FC SPM about the No Calibration State of Maintenance (FC DIAGNOSIS). (CCA FID: 0x0605)
     */
    void sendNoCalibrationStateUpdate();

    // property 'SecurityCommError'

    /**
     * The method onSecurityCommErrorGet() is called by ASF when a client
     * invokes the read method for the property 'SecurityCommError'. The
     * onSecurityCommErrorGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'SecurityCommError'</b>:
     *
     * Communication error count detected by SPM security component. FUNCID = FID_SPM_SEC_COMM_ERROR, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x84)
     */
    virtual void onSecurityCommErrorGet(const ::boost::shared_ptr< SecurityCommErrorGet >& payload);

    /**
     * Sends back the update to a previous onSecurityCommErrorGet().
     *
     * <b>Documentation of 'SecurityCommError'</b>:
     *
     * Communication error count detected by SPM security component. FUNCID = FID_SPM_SEC_COMM_ERROR, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x84)
     *
     * @param act Identifies a previous invocation of
     * onSecurityCommErrorGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSecurityCommErrorGetUpdate(uint16 securityCommError, act_t act = 0);

    /**
     * Set the value of the property 'SecurityCommError' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SecurityCommError'</b>:
     *
     * Communication error count detected by SPM security component. FUNCID = FID_SPM_SEC_COMM_ERROR, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x84)
     */
    void setSecurityCommError(uint16 securityCommError);

    /**
     * Returns the current value of the property 'SecurityCommError'.
     *
     * <b>Documentation of 'SecurityCommError'</b>:
     *
     * Communication error count detected by SPM security component. FUNCID = FID_SPM_SEC_COMM_ERROR, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x84)
     */
    uint16 getSecurityCommError() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSecurityCommErrorUpdate().
     *
     * <b>Documentation of 'SecurityCommError'</b>:
     *
     * Communication error count detected by SPM security component. FUNCID = FID_SPM_SEC_COMM_ERROR, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x84)
     */
    void sendSecurityCommErrorUpdate();

    // property 'SecurityMoreThan10Vin'

    /**
     * The method onSecurityMoreThan10VinGet() is called by ASF when a client
     * invokes the read method for the property 'SecurityMoreThan10Vin'. The
     * onSecurityMoreThan10VinGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'SecurityMoreThan10Vin'</b>:
     *
     * More than 10 VINs detected by SPM security component. FUNCID = FID_SPM_SEC_MORE_10VIN_ERROR, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x85)
     */
    virtual void onSecurityMoreThan10VinGet(const ::boost::shared_ptr< SecurityMoreThan10VinGet >& payload);

    /**
     * Sends back the update to a previous onSecurityMoreThan10VinGet().
     *
     * <b>Documentation of 'SecurityMoreThan10Vin'</b>:
     *
     * More than 10 VINs detected by SPM security component. FUNCID = FID_SPM_SEC_MORE_10VIN_ERROR, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x85)
     *
     * @param act Identifies a previous invocation of
     * onSecurityMoreThan10VinGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSecurityMoreThan10VinGetUpdate(uint16 securityMoreThan10Vin, act_t act = 0);

    /**
     * Set the value of the property 'SecurityMoreThan10Vin' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'SecurityMoreThan10Vin'</b>:
     *
     * More than 10 VINs detected by SPM security component. FUNCID = FID_SPM_SEC_MORE_10VIN_ERROR, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x85)
     */
    void setSecurityMoreThan10Vin(uint16 securityMoreThan10Vin);

    /**
     * Returns the current value of the property 'SecurityMoreThan10Vin'.
     *
     * <b>Documentation of 'SecurityMoreThan10Vin'</b>:
     *
     * More than 10 VINs detected by SPM security component. FUNCID = FID_SPM_SEC_MORE_10VIN_ERROR, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x85)
     */
    uint16 getSecurityMoreThan10Vin() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSecurityMoreThan10VinUpdate().
     *
     * <b>Documentation of 'SecurityMoreThan10Vin'</b>:
     *
     * More than 10 VINs detected by SPM security component. FUNCID = FID_SPM_SEC_MORE_10VIN_ERROR, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x85)
     */
    void sendSecurityMoreThan10VinUpdate();

    // property 'SecurityInvalidVin'

    /**
     * The method onSecurityInvalidVinGet() is called by ASF when a client
     * invokes the read method for the property 'SecurityInvalidVin'. The
     * onSecurityInvalidVinGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'SecurityInvalidVin'</b>:
     *
     * Number of invalid VINs detected by SPM security component. FUNCID = FID_SPM_SEC_INVALID_VIN_ERROR, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x86)
     */
    virtual void onSecurityInvalidVinGet(const ::boost::shared_ptr< SecurityInvalidVinGet >& payload);

    /**
     * Sends back the update to a previous onSecurityInvalidVinGet().
     *
     * <b>Documentation of 'SecurityInvalidVin'</b>:
     *
     * Number of invalid VINs detected by SPM security component. FUNCID = FID_SPM_SEC_INVALID_VIN_ERROR, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x86)
     *
     * @param act Identifies a previous invocation of
     * onSecurityInvalidVinGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSecurityInvalidVinGetUpdate(uint16 securityInvalidVin, act_t act = 0);

    /**
     * Set the value of the property 'SecurityInvalidVin' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SecurityInvalidVin'</b>:
     *
     * Number of invalid VINs detected by SPM security component. FUNCID = FID_SPM_SEC_INVALID_VIN_ERROR, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x86)
     */
    void setSecurityInvalidVin(uint16 securityInvalidVin);

    /**
     * Returns the current value of the property 'SecurityInvalidVin'.
     *
     * <b>Documentation of 'SecurityInvalidVin'</b>:
     *
     * Number of invalid VINs detected by SPM security component. FUNCID = FID_SPM_SEC_INVALID_VIN_ERROR, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x86)
     */
    uint16 getSecurityInvalidVin() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSecurityInvalidVinUpdate().
     *
     * <b>Documentation of 'SecurityInvalidVin'</b>:
     *
     * Number of invalid VINs detected by SPM security component. FUNCID = FID_SPM_SEC_INVALID_VIN_ERROR, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x86)
     */
    void sendSecurityInvalidVinUpdate();

    // property 'SecurityCurrentVin'

    /**
     * The method onSecurityCurrentVinGet() is called by ASF when a client
     * invokes the read method for the property 'SecurityCurrentVin'. The
     * onSecurityCurrentVinGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'SecurityCurrentVin'</b>:
     *
     * Current VIN detected by SPM security component (17 bytes). FUNCID = FID_SPM_SEC_CURRENT_VIN, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x87)
     */
    virtual void onSecurityCurrentVinGet(const ::boost::shared_ptr< SecurityCurrentVinGet >& payload);

    /**
     * Sends back the update to a previous onSecurityCurrentVinGet().
     *
     * <b>Documentation of 'SecurityCurrentVin'</b>:
     *
     * Current VIN detected by SPM security component (17 bytes). FUNCID = FID_SPM_SEC_CURRENT_VIN, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x87)
     *
     * @param act Identifies a previous invocation of
     * onSecurityCurrentVinGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSecurityCurrentVinGetUpdate(const T_SPM_Vin& securityCurrentVin, act_t act = 0);

    /**
     * Set the value of the property 'SecurityCurrentVin' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SecurityCurrentVin'</b>:
     *
     * Current VIN detected by SPM security component (17 bytes). FUNCID = FID_SPM_SEC_CURRENT_VIN, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x87)
     */
    void setSecurityCurrentVin(const T_SPM_Vin& securityCurrentVin);

    /**
     * Returns the current value of the property 'SecurityCurrentVin'.
     *
     * <b>Documentation of 'SecurityCurrentVin'</b>:
     *
     * Current VIN detected by SPM security component (17 bytes). FUNCID = FID_SPM_SEC_CURRENT_VIN, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x87)
     */
    const T_SPM_Vin& getSecurityCurrentVin() const;

    /**
     * Returns the current value of the property 'SecurityCurrentVin' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendSecurityCurrentVinUpdate() method.
     *
     * <b>Documentation of 'SecurityCurrentVin'</b>:
     *
     * Current VIN detected by SPM security component (17 bytes). FUNCID = FID_SPM_SEC_CURRENT_VIN, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x87)
     */
    T_SPM_Vin& getSecurityCurrentVinMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSecurityCurrentVinUpdate().
     *
     * <b>Documentation of 'SecurityCurrentVin'</b>:
     *
     * Current VIN detected by SPM security component (17 bytes). FUNCID = FID_SPM_SEC_CURRENT_VIN, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x87)
     */
    void sendSecurityCurrentVinUpdate();

    // property 'SecurityVinHistory'

    /**
     * The method onSecurityVinHistoryGet() is called by ASF when a client
     * invokes the read method for the property 'SecurityVinHistory'. The
     * onSecurityVinHistoryGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'SecurityVinHistory'</b>:
     *
     * List of received VINs detected by SPM security component. FUNCID = FID_SPM_SEC_VIN_HISTORY, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x88)
     */
    virtual void onSecurityVinHistoryGet(const ::boost::shared_ptr< SecurityVinHistoryGet >& payload);

    /**
     * Sends back the update to a previous onSecurityVinHistoryGet().
     *
     * <b>Documentation of 'SecurityVinHistory'</b>:
     *
     * List of received VINs detected by SPM security component. FUNCID = FID_SPM_SEC_VIN_HISTORY, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x88)
     *
     * @param act Identifies a previous invocation of
     * onSecurityVinHistoryGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSecurityVinHistoryGetUpdate(const T_SPM_VinHistory& securityVinHistory, act_t act = 0);

    /**
     * Set the value of the property 'SecurityVinHistory' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SecurityVinHistory'</b>:
     *
     * List of received VINs detected by SPM security component. FUNCID = FID_SPM_SEC_VIN_HISTORY, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x88)
     */
    void setSecurityVinHistory(const T_SPM_VinHistory& securityVinHistory);

    /**
     * Returns the current value of the property 'SecurityVinHistory'.
     *
     * <b>Documentation of 'SecurityVinHistory'</b>:
     *
     * List of received VINs detected by SPM security component. FUNCID = FID_SPM_SEC_VIN_HISTORY, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x88)
     */
    const T_SPM_VinHistory& getSecurityVinHistory() const;

    /**
     * Returns the current value of the property 'SecurityVinHistory' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendSecurityVinHistoryUpdate() method.
     *
     * <b>Documentation of 'SecurityVinHistory'</b>:
     *
     * List of received VINs detected by SPM security component. FUNCID = FID_SPM_SEC_VIN_HISTORY, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x88)
     */
    T_SPM_VinHistory& getSecurityVinHistoryMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSecurityVinHistoryUpdate().
     *
     * <b>Documentation of 'SecurityVinHistory'</b>:
     *
     * List of received VINs detected by SPM security component. FUNCID = FID_SPM_SEC_VIN_HISTORY, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x88)
     */
    void sendSecurityVinHistoryUpdate();

    // property 'VIN'

    /**
     * The method onVINGet() is called by ASF when a client invokes the read
     * method for the property 'VIN'. The onVINGet() method returns by default
     * the current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'VIN'</b>:
     *
     * Vehicle Identification Number. FUNCID = FID_SPM_VIN, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= ...  (CCA FID: 0x0521)
     */
    virtual void onVINGet(const ::boost::shared_ptr< VINGet >& payload);

    /**
     * Sends back the update to a previous onVINGet().
     *
     * <b>Documentation of 'VIN'</b>:
     *
     * Vehicle Identification Number. FUNCID = FID_SPM_VIN, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= ...  (CCA FID: 0x0521)
     *
     * @param act Identifies a previous invocation of onVINGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendVINGetUpdate(const ::std::string& vIN, act_t act = 0);

    /**
     * Set the value of the property 'VIN' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'VIN'</b>:
     *
     * Vehicle Identification Number. FUNCID = FID_SPM_VIN, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= ...  (CCA FID: 0x0521)
     */
    void setVIN(const ::std::string& vIN);

    /**
     * Returns the current value of the property 'VIN'.
     *
     * <b>Documentation of 'VIN'</b>:
     *
     * Vehicle Identification Number. FUNCID = FID_SPM_VIN, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= ...  (CCA FID: 0x0521)
     */
    const ::std::string& getVIN() const;

    /**
     * Returns the current value of the property 'VIN' as a mutable reference.
     * If you change the content of the returned object you have to send
     * updates to registered clients by yourself with the help of the
     * sendVINUpdate() method.
     *
     * <b>Documentation of 'VIN'</b>:
     *
     * Vehicle Identification Number. FUNCID = FID_SPM_VIN, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= ...  (CCA FID: 0x0521)
     */
    ::std::string& getVINMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendVINUpdate().
     *
     * <b>Documentation of 'VIN'</b>:
     *
     * Vehicle Identification Number. FUNCID = FID_SPM_VIN, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= ...  (CCA FID: 0x0521)
     */
    void sendVINUpdate();

    // property 'SecurityState'

    /**
     * The method onSecurityStateGet() is called by ASF when a client invokes
     * the read method for the property 'SecurityState'. The
     * onSecurityStateGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'SecurityState'</b>:
     *
     * The SPM tells registered clients the current security state of the system.  (CCA FID: 0x0523)
     */
    virtual void onSecurityStateGet(const ::boost::shared_ptr< SecurityStateGet >& payload);

    /**
     * Sends back the update to a previous onSecurityStateGet().
     *
     * <b>Documentation of 'SecurityState'</b>:
     *
     * The SPM tells registered clients the current security state of the system.  (CCA FID: 0x0523)
     *
     * @param act Identifies a previous invocation of onSecurityStateGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSecurityStateGetUpdate(T_SPM_e32_SECURITY_STATE securityState, act_t act = 0);

    /**
     * Set the value of the property 'SecurityState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SecurityState'</b>:
     *
     * The SPM tells registered clients the current security state of the system.  (CCA FID: 0x0523)
     */
    void setSecurityState(T_SPM_e32_SECURITY_STATE securityState);

    /**
     * Returns the current value of the property 'SecurityState'.
     *
     * <b>Documentation of 'SecurityState'</b>:
     *
     * The SPM tells registered clients the current security state of the system.  (CCA FID: 0x0523)
     */
    T_SPM_e32_SECURITY_STATE getSecurityState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSecurityStateUpdate().
     *
     * <b>Documentation of 'SecurityState'</b>:
     *
     * The SPM tells registered clients the current security state of the system.  (CCA FID: 0x0523)
     */
    void sendSecurityStateUpdate();

    // property 'VehicleID'

    /**
     * The method onVehicleIDGet() is called by ASF when a client invokes the
     * read method for the property 'VehicleID'. The onVehicleIDGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'VehicleID'</b>:
     *
     * Current stored Vehicle ID (4 Byte value --> similar to string based VIN).  (CCA FID: 0x0524)
     */
    virtual void onVehicleIDGet(const ::boost::shared_ptr< VehicleIDGet >& payload);

    /**
     * Sends back the update to a previous onVehicleIDGet().
     *
     * <b>Documentation of 'VehicleID'</b>:
     *
     * Current stored Vehicle ID (4 Byte value --> similar to string based VIN).  (CCA FID: 0x0524)
     *
     * @param act Identifies a previous invocation of onVehicleIDGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendVehicleIDGetUpdate(uint32 vehicleID, act_t act = 0);

    /**
     * Set the value of the property 'VehicleID' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'VehicleID'</b>:
     *
     * Current stored Vehicle ID (4 Byte value --> similar to string based VIN).  (CCA FID: 0x0524)
     */
    void setVehicleID(uint32 vehicleID);

    /**
     * Returns the current value of the property 'VehicleID'.
     *
     * <b>Documentation of 'VehicleID'</b>:
     *
     * Current stored Vehicle ID (4 Byte value --> similar to string based VIN).  (CCA FID: 0x0524)
     */
    uint32 getVehicleID() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendVehicleIDUpdate().
     *
     * <b>Documentation of 'VehicleID'</b>:
     *
     * Current stored Vehicle ID (4 Byte value --> similar to string based VIN).  (CCA FID: 0x0524)
     */
    void sendVehicleIDUpdate();

    // property 'DisplayVariant'

    /**
     * The method onDisplayVariantGet() is called by ASF when a client invokes
     * the read method for the property 'DisplayVariant'. The
     * onDisplayVariantGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'DisplayVariant'</b>:
     *
     * Sets the given display variant number in the datapool and performs a restart of the system. FUNCID = FID_SPM_DISPLAY_VARIANT, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	=  (CCA FID: 0x0406)
     */
    virtual void onDisplayVariantGet(const ::boost::shared_ptr< DisplayVariantGet >& payload);

    /**
     * Sends back the update to a previous onDisplayVariantGet().
     *
     * <b>Documentation of 'DisplayVariant'</b>:
     *
     * Sets the given display variant number in the datapool and performs a restart of the system. FUNCID = FID_SPM_DISPLAY_VARIANT, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	=  (CCA FID: 0x0406)
     *
     * @param act Identifies a previous invocation of onDisplayVariantGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDisplayVariantGetUpdate(uint32 displayVariant, act_t act = 0);

    /**
     * Set the value of the property 'DisplayVariant' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'DisplayVariant'</b>:
     *
     * Sets the given display variant number in the datapool and performs a restart of the system. FUNCID = FID_SPM_DISPLAY_VARIANT, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	=  (CCA FID: 0x0406)
     */
    void setDisplayVariant(uint32 displayVariant);

    /**
     * Returns the current value of the property 'DisplayVariant'.
     *
     * <b>Documentation of 'DisplayVariant'</b>:
     *
     * Sets the given display variant number in the datapool and performs a restart of the system. FUNCID = FID_SPM_DISPLAY_VARIANT, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	=  (CCA FID: 0x0406)
     */
    uint32 getDisplayVariant() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDisplayVariantUpdate().
     *
     * <b>Documentation of 'DisplayVariant'</b>:
     *
     * Sets the given display variant number in the datapool and performs a restart of the system. FUNCID = FID_SPM_DISPLAY_VARIANT, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	=  (CCA FID: 0x0406)
     */
    void sendDisplayVariantUpdate();

    // property 'ReductionLevel'

    /**
     * The method onReductionLevelGet() is called by ASF when a client invokes
     * the read method for the property 'ReductionLevel'. The
     * onReductionLevelGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ReductionLevel'</b>:
     *
     * The reduction level is used to tell components to provide normal operation or a reduced operation level.  (CCA FID: 0x0802)
     */
    virtual void onReductionLevelGet(const ::boost::shared_ptr< ReductionLevelGet >& payload);

    /**
     * Sends back the update to a previous onReductionLevelGet().
     *
     * <b>Documentation of 'ReductionLevel'</b>:
     *
     * The reduction level is used to tell components to provide normal operation or a reduced operation level.  (CCA FID: 0x0802)
     *
     * @param act Identifies a previous invocation of onReductionLevelGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendReductionLevelGetUpdate(T_SPM_e32_REDUCTION_LEVEL reductionLevel, act_t act = 0);

    /**
     * Set the value of the property 'ReductionLevel' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ReductionLevel'</b>:
     *
     * The reduction level is used to tell components to provide normal operation or a reduced operation level.  (CCA FID: 0x0802)
     */
    void setReductionLevel(T_SPM_e32_REDUCTION_LEVEL reductionLevel);

    /**
     * Returns the current value of the property 'ReductionLevel'.
     *
     * <b>Documentation of 'ReductionLevel'</b>:
     *
     * The reduction level is used to tell components to provide normal operation or a reduced operation level.  (CCA FID: 0x0802)
     */
    T_SPM_e32_REDUCTION_LEVEL getReductionLevel() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendReductionLevelUpdate().
     *
     * <b>Documentation of 'ReductionLevel'</b>:
     *
     * The reduction level is used to tell components to provide normal operation or a reduced operation level.  (CCA FID: 0x0802)
     */
    void sendReductionLevelUpdate();

    // property 'StartupState'

    /**
     * The method onStartupStateGet() is called by ASF when a client invokes
     * the read method for the property 'StartupState'. The
     * onStartupStateGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'StartupState'</b>:
     *
     * Informs about current startup state. All applications of one sw block acknowledged the state "Initialized".  (CCA FID: 0x03)
     */
    virtual void onStartupStateGet(const ::boost::shared_ptr< StartupStateGet >& payload);

    /**
     * Sends back the update to a previous onStartupStateGet().
     *
     * <b>Documentation of 'StartupState'</b>:
     *
     * Informs about current startup state. All applications of one sw block acknowledged the state "Initialized".  (CCA FID: 0x03)
     *
     * @param act Identifies a previous invocation of onStartupStateGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStartupStateGetUpdate(T_SPM_e32_STARTUP_STATE startupState, act_t act = 0);

    /**
     * Set the value of the property 'StartupState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'StartupState'</b>:
     *
     * Informs about current startup state. All applications of one sw block acknowledged the state "Initialized".  (CCA FID: 0x03)
     */
    void setStartupState(T_SPM_e32_STARTUP_STATE startupState);

    /**
     * Returns the current value of the property 'StartupState'.
     *
     * <b>Documentation of 'StartupState'</b>:
     *
     * Informs about current startup state. All applications of one sw block acknowledged the state "Initialized".  (CCA FID: 0x03)
     */
    T_SPM_e32_STARTUP_STATE getStartupState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendStartupStateUpdate().
     *
     * <b>Documentation of 'StartupState'</b>:
     *
     * Informs about current startup state. All applications of one sw block acknowledged the state "Initialized".  (CCA FID: 0x03)
     */
    void sendStartupStateUpdate();

    // property 'EntertainMute'

    /**
     * The method onEntertainMuteGet() is called by ASF when a client invokes
     * the read method for the property 'EntertainMute'. The
     * onEntertainMuteGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'EntertainMute'</b>:
     *
     * NISSAN related mute handling. SPM handles Tipper and calculates MuteState. HMI has to follow mute state.  (CCA FID: 0x16)
     */
    virtual void onEntertainMuteGet(const ::boost::shared_ptr< EntertainMuteGet >& payload);

    /**
     * Sends back the update to a previous onEntertainMuteGet().
     *
     * <b>Documentation of 'EntertainMute'</b>:
     *
     * NISSAN related mute handling. SPM handles Tipper and calculates MuteState. HMI has to follow mute state.  (CCA FID: 0x16)
     *
     * @param act Identifies a previous invocation of onEntertainMuteGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEntertainMuteGetUpdate(bool entertainMute, act_t act = 0);

    /**
     * Set the value of the property 'EntertainMute' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'EntertainMute'</b>:
     *
     * NISSAN related mute handling. SPM handles Tipper and calculates MuteState. HMI has to follow mute state.  (CCA FID: 0x16)
     */
    void setEntertainMute(bool entertainMute);

    /**
     * Returns the current value of the property 'EntertainMute'.
     *
     * <b>Documentation of 'EntertainMute'</b>:
     *
     * NISSAN related mute handling. SPM handles Tipper and calculates MuteState. HMI has to follow mute state.  (CCA FID: 0x16)
     */
    bool getEntertainMute() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendEntertainMuteUpdate().
     *
     * <b>Documentation of 'EntertainMute'</b>:
     *
     * NISSAN related mute handling. SPM handles Tipper and calculates MuteState. HMI has to follow mute state.  (CCA FID: 0x16)
     */
    void sendEntertainMuteUpdate();

    // property 'WelcomeAudioState'

    /**
     * The method onWelcomeAudioStateGet() is called by ASF when a client
     * invokes the read method for the property 'WelcomeAudioState'. The
     * onWelcomeAudioStateGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'WelcomeAudioState'</b>:
     *
     * Welcome audio is currently enabled or not.  (CCA FID: 0x2026)
     */
    virtual void onWelcomeAudioStateGet(const ::boost::shared_ptr< WelcomeAudioStateGet >& payload);

    /**
     * Sends back the update to a previous onWelcomeAudioStateGet().
     *
     * <b>Documentation of 'WelcomeAudioState'</b>:
     *
     * Welcome audio is currently enabled or not.  (CCA FID: 0x2026)
     *
     * @param act Identifies a previous invocation of
     * onWelcomeAudioStateGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendWelcomeAudioStateGetUpdate(bool welcomeAudioState, act_t act = 0);

    /**
     * Set the value of the property 'WelcomeAudioState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'WelcomeAudioState'</b>:
     *
     * Welcome audio is currently enabled or not.  (CCA FID: 0x2026)
     */
    void setWelcomeAudioState(bool welcomeAudioState);

    /**
     * Returns the current value of the property 'WelcomeAudioState'.
     *
     * <b>Documentation of 'WelcomeAudioState'</b>:
     *
     * Welcome audio is currently enabled or not.  (CCA FID: 0x2026)
     */
    bool getWelcomeAudioState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendWelcomeAudioStateUpdate().
     *
     * <b>Documentation of 'WelcomeAudioState'</b>:
     *
     * Welcome audio is currently enabled or not.  (CCA FID: 0x2026)
     */
    void sendWelcomeAudioStateUpdate();

    // property 'UnballastTimeFromEngineStopped'

    /**
     * The method onUnballastTimeFromEngineStoppedGet() is called by ASF when
     * a client invokes the read method for the property
     * 'UnballastTimeFromEngineStopped'. The
     * onUnballastTimeFromEngineStoppedGet() method returns by default the
     * current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'UnballastTimeFromEngineStopped'</b>:
     *
     * Timer which starts when engine is not running before unballast.  (CCA FID: 0x760)
     */
    virtual void onUnballastTimeFromEngineStoppedGet(const ::boost::shared_ptr< UnballastTimeFromEngineStoppedGet >& payload);

    /**
     * Sends back the update to a previous
     * onUnballastTimeFromEngineStoppedGet().
     *
     * <b>Documentation of 'UnballastTimeFromEngineStopped'</b>:
     *
     * Timer which starts when engine is not running before unballast.  (CCA FID: 0x760)
     *
     * @param act Identifies a previous invocation of
     * onUnballastTimeFromEngineStoppedGet(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendUnballastTimeFromEngineStoppedGetUpdate(uint32 unballastTimeFromEngineStopped, act_t act = 0);

    /**
     * Set the value of the property 'UnballastTimeFromEngineStopped' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'UnballastTimeFromEngineStopped'</b>:
     *
     * Timer which starts when engine is not running before unballast.  (CCA FID: 0x760)
     */
    void setUnballastTimeFromEngineStopped(uint32 unballastTimeFromEngineStopped);

    /**
     * Returns the current value of the property 'UnballastTimeFromEngineStopped'.
     *
     * <b>Documentation of 'UnballastTimeFromEngineStopped'</b>:
     *
     * Timer which starts when engine is not running before unballast.  (CCA FID: 0x760)
     */
    uint32 getUnballastTimeFromEngineStopped() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendUnballastTimeFromEngineStoppedUpdate().
     *
     * <b>Documentation of 'UnballastTimeFromEngineStopped'</b>:
     *
     * Timer which starts when engine is not running before unballast.  (CCA FID: 0x760)
     */
    void sendUnballastTimeFromEngineStoppedUpdate();

    // property 'UnballastTimeBeforeUnballast'

    /**
     * The method onUnballastTimeBeforeUnballastGet() is called by ASF when a
     * client invokes the read method for the property
     * 'UnballastTimeBeforeUnballast'. The onUnballastTimeBeforeUnballastGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'UnballastTimeBeforeUnballast'</b>:
     *
     * Time before unballast. Configuration parameter.  (CCA FID: 0x761)
     */
    virtual void onUnballastTimeBeforeUnballastGet(const ::boost::shared_ptr< UnballastTimeBeforeUnballastGet >& payload);

    /**
     * Sends back the update to a previous
     * onUnballastTimeBeforeUnballastGet().
     *
     * <b>Documentation of 'UnballastTimeBeforeUnballast'</b>:
     *
     * Time before unballast. Configuration parameter.  (CCA FID: 0x761)
     *
     * @param act Identifies a previous invocation of
     * onUnballastTimeBeforeUnballastGet(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendUnballastTimeBeforeUnballastGetUpdate(uint32 unballastTimeBeforeUnballast, act_t act = 0);

    /**
     * Set the value of the property 'UnballastTimeBeforeUnballast' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'UnballastTimeBeforeUnballast'</b>:
     *
     * Time before unballast. Configuration parameter.  (CCA FID: 0x761)
     */
    void setUnballastTimeBeforeUnballast(uint32 unballastTimeBeforeUnballast);

    /**
     * Returns the current value of the property 'UnballastTimeBeforeUnballast'.
     *
     * <b>Documentation of 'UnballastTimeBeforeUnballast'</b>:
     *
     * Time before unballast. Configuration parameter.  (CCA FID: 0x761)
     */
    uint32 getUnballastTimeBeforeUnballast() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendUnballastTimeBeforeUnballastUpdate().
     *
     * <b>Documentation of 'UnballastTimeBeforeUnballast'</b>:
     *
     * Time before unballast. Configuration parameter.  (CCA FID: 0x761)
     */
    void sendUnballastTimeBeforeUnballastUpdate();

    // property 'UnballastWarningTime'

    /**
     * The method onUnballastWarningTimeGet() is called by ASF when a client
     * invokes the read method for the property 'UnballastWarningTime'. The
     * onUnballastWarningTimeGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'UnballastWarningTime'</b>:
     *
     * Time warning message is displayed.  (CCA FID: 0x762)
     */
    virtual void onUnballastWarningTimeGet(const ::boost::shared_ptr< UnballastWarningTimeGet >& payload);

    /**
     * Sends back the update to a previous onUnballastWarningTimeGet().
     *
     * <b>Documentation of 'UnballastWarningTime'</b>:
     *
     * Time warning message is displayed.  (CCA FID: 0x762)
     *
     * @param act Identifies a previous invocation of
     * onUnballastWarningTimeGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendUnballastWarningTimeGetUpdate(uint32 unballastWarningTime, act_t act = 0);

    /**
     * Set the value of the property 'UnballastWarningTime' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'UnballastWarningTime'</b>:
     *
     * Time warning message is displayed.  (CCA FID: 0x762)
     */
    void setUnballastWarningTime(uint32 unballastWarningTime);

    /**
     * Returns the current value of the property 'UnballastWarningTime'.
     *
     * <b>Documentation of 'UnballastWarningTime'</b>:
     *
     * Time warning message is displayed.  (CCA FID: 0x762)
     */
    uint32 getUnballastWarningTime() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendUnballastWarningTimeUpdate().
     *
     * <b>Documentation of 'UnballastWarningTime'</b>:
     *
     * Time warning message is displayed.  (CCA FID: 0x762)
     */
    void sendUnballastWarningTimeUpdate();

    // property 'DegradedCount'

    /**
     * The method onDegradedCountGet() is called by ASF when a client invokes
     * the read method for the property 'DegradedCount'. The
     * onDegradedCountGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'DegradedCount'</b>:
     *
     * Number of Unballast trigger.  (CCA FID: 0x763)
     */
    virtual void onDegradedCountGet(const ::boost::shared_ptr< DegradedCountGet >& payload);

    /**
     * Sends back the update to a previous onDegradedCountGet().
     *
     * <b>Documentation of 'DegradedCount'</b>:
     *
     * Number of Unballast trigger.  (CCA FID: 0x763)
     *
     * @param act Identifies a previous invocation of onDegradedCountGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDegradedCountGetUpdate(uint32 degradedCount, act_t act = 0);

    /**
     * Set the value of the property 'DegradedCount' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'DegradedCount'</b>:
     *
     * Number of Unballast trigger.  (CCA FID: 0x763)
     */
    void setDegradedCount(uint32 degradedCount);

    /**
     * Returns the current value of the property 'DegradedCount'.
     *
     * <b>Documentation of 'DegradedCount'</b>:
     *
     * Number of Unballast trigger.  (CCA FID: 0x763)
     */
    uint32 getDegradedCount() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDegradedCountUpdate().
     *
     * <b>Documentation of 'DegradedCount'</b>:
     *
     * Number of Unballast trigger.  (CCA FID: 0x763)
     */
    void sendDegradedCountUpdate();

    // property 'DegradedTime'

    /**
     * The method onDegradedTimeGet() is called by ASF when a client invokes
     * the read method for the property 'DegradedTime'. The
     * onDegradedTimeGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'DegradedTime'</b>:
     *
     * Accumulated time in Unballast situation.  (CCA FID: 0x764)
     */
    virtual void onDegradedTimeGet(const ::boost::shared_ptr< DegradedTimeGet >& payload);

    /**
     * Sends back the update to a previous onDegradedTimeGet().
     *
     * <b>Documentation of 'DegradedTime'</b>:
     *
     * Accumulated time in Unballast situation.  (CCA FID: 0x764)
     *
     * @param act Identifies a previous invocation of onDegradedTimeGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDegradedTimeGetUpdate(uint32 degradedTime, act_t act = 0);

    /**
     * Set the value of the property 'DegradedTime' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'DegradedTime'</b>:
     *
     * Accumulated time in Unballast situation.  (CCA FID: 0x764)
     */
    void setDegradedTime(uint32 degradedTime);

    /**
     * Returns the current value of the property 'DegradedTime'.
     *
     * <b>Documentation of 'DegradedTime'</b>:
     *
     * Accumulated time in Unballast situation.  (CCA FID: 0x764)
     */
    uint32 getDegradedTime() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDegradedTimeUpdate().
     *
     * <b>Documentation of 'DegradedTime'</b>:
     *
     * Accumulated time in Unballast situation.  (CCA FID: 0x764)
     */
    void sendDegradedTimeUpdate();

    // property 'PhoneHandoverWarnTime'

    /**
     * The method onPhoneHandoverWarnTimeGet() is called by ASF when a client
     * invokes the read method for the property 'PhoneHandoverWarnTime'. The
     * onPhoneHandoverWarnTimeGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'PhoneHandoverWarnTime'</b>:
     *
     * Time in seconds before the system shutdown starts. Trigger "SPM_U32_SYSPWR_PHONE_HANDOVER_WARN" via property "SystemPowerBehaviour" will be send only if a phone call is active. (CCA FID: 0x1018)
     */
    virtual void onPhoneHandoverWarnTimeGet(const ::boost::shared_ptr< PhoneHandoverWarnTimeGet >& payload);

    /**
     * Sends back the update to a previous onPhoneHandoverWarnTimeGet().
     *
     * <b>Documentation of 'PhoneHandoverWarnTime'</b>:
     *
     * Time in seconds before the system shutdown starts. Trigger "SPM_U32_SYSPWR_PHONE_HANDOVER_WARN" via property "SystemPowerBehaviour" will be send only if a phone call is active. (CCA FID: 0x1018)
     *
     * @param act Identifies a previous invocation of
     * onPhoneHandoverWarnTimeGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendPhoneHandoverWarnTimeGetUpdate(uint32 phoneHandoverWarnTime, act_t act = 0);

    /**
     * Set the value of the property 'PhoneHandoverWarnTime' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'PhoneHandoverWarnTime'</b>:
     *
     * Time in seconds before the system shutdown starts. Trigger "SPM_U32_SYSPWR_PHONE_HANDOVER_WARN" via property "SystemPowerBehaviour" will be send only if a phone call is active. (CCA FID: 0x1018)
     */
    void setPhoneHandoverWarnTime(uint32 phoneHandoverWarnTime);

    /**
     * Returns the current value of the property 'PhoneHandoverWarnTime'.
     *
     * <b>Documentation of 'PhoneHandoverWarnTime'</b>:
     *
     * Time in seconds before the system shutdown starts. Trigger "SPM_U32_SYSPWR_PHONE_HANDOVER_WARN" via property "SystemPowerBehaviour" will be send only if a phone call is active. (CCA FID: 0x1018)
     */
    uint32 getPhoneHandoverWarnTime() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPhoneHandoverWarnTimeUpdate().
     *
     * <b>Documentation of 'PhoneHandoverWarnTime'</b>:
     *
     * Time in seconds before the system shutdown starts. Trigger "SPM_U32_SYSPWR_PHONE_HANDOVER_WARN" via property "SystemPowerBehaviour" will be send only if a phone call is active. (CCA FID: 0x1018)
     */
    void sendPhoneHandoverWarnTimeUpdate();

    // method 'SystemMode'

    /**
     * The method onSystemMode() is called by ASF when a client invokes the
     * method 'SystemMode'. A subclass has to implement this method and send
     * back a response to the client either with the sendSystemMode() or
     * sendSystemModeError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'SystemMode'</b>:
     *
     * Method to trigger a system state change e.g. DOWNLOAD / Diagnosis.  (CCA FID: 0x1000)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSystemModeRequest (const ::boost::shared_ptr< SystemModeRequest >& request) = 0;

    /**
     * The method sendSystemModeResponse() sends a response of a previous
     * method invocation of 'SystemMode' back to the client.
     *
     * <b>Documentation of 'SystemMode'</b>:
     *
     * Method to trigger a system state change e.g. DOWNLOAD / Diagnosis.  (CCA FID: 0x1000)
     *
     * @param s32ReturnValOut If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSystemMode(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSystemModeResponse (int32 s32ReturnValOut, act_t act = 0);

    /**
     * The method sendSystemModeError() sends an error response of a previous
     * method invocation of 'SystemMode' back to the client.
     *
     * <b>Documentation of 'SystemMode'</b>:
     *
     * Method to trigger a system state change e.g. DOWNLOAD / Diagnosis.  (CCA FID: 0x1000)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSystemMode(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSystemModeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'DownloadLockState'

    /**
     * The method onDownloadLockState() is called by ASF when a client invokes
     * the method 'DownloadLockState'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendDownloadLockState() or sendDownloadLockStateError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'DownloadLockState'</b>:
     *
     * !!! OBSOLETE DO NOT USE ANYMORE !!! !!! replaced by UpdateLock !!! Method to lock specific resources for restricted downloads.  (CCA FID: 0x1001)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDownloadLockStateRequest (const ::boost::shared_ptr< DownloadLockStateRequest >& request) = 0;

    /**
     * The method sendDownloadLockStateResponse() sends a response of a
     * previous method invocation of 'DownloadLockState' back to the client.
     *
     * <b>Documentation of 'DownloadLockState'</b>:
     *
     * !!! OBSOLETE DO NOT USE ANYMORE !!! !!! replaced by UpdateLock !!! Method to lock specific resources for restricted downloads.  (CCA FID: 0x1001)
     *
     * @param s32ReturnValOut If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDownloadLockState(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDownloadLockStateResponse (int32 s32ReturnValOut, act_t act = 0);

    /**
     * The method sendDownloadLockStateError() sends an error response of a
     * previous method invocation of 'DownloadLockState' back to the client.
     *
     * <b>Documentation of 'DownloadLockState'</b>:
     *
     * !!! OBSOLETE DO NOT USE ANYMORE !!! !!! replaced by UpdateLock !!! Method to lock specific resources for restricted downloads.  (CCA FID: 0x1001)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDownloadLockState().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDownloadLockStateError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'UpdateLock'

    /**
     * The method onUpdateLock() is called by ASF when a client invokes the
     * method 'UpdateLock'. A subclass has to implement this method and send
     * back a response to the client either with the sendUpdateLock() or
     * sendUpdateLockError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'UpdateLock'</b>:
     *
     * Method to modify a lock. Not existing locks will be created. Locks that are no longer owned nor used will be deleted. Owner and state of a lock will be stored persistently  (CCA FID: 0x1003)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onUpdateLockRequest (const ::boost::shared_ptr< UpdateLockRequest >& request) = 0;

    /**
     * The method sendUpdateLockResponse() sends a response of a previous
     * method invocation of 'UpdateLock' back to the client.
     *
     * <b>Documentation of 'UpdateLock'</b>:
     *
     * Method to modify a lock. Not existing locks will be created. Locks that are no longer owned nor used will be deleted. Owner and state of a lock will be stored persistently  (CCA FID: 0x1003)
     *
     * @param s32ReturnValOut If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onUpdateLock(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendUpdateLockResponse (int32 s32ReturnValOut, act_t act = 0);

    /**
     * The method sendUpdateLockError() sends an error response of a previous
     * method invocation of 'UpdateLock' back to the client.
     *
     * <b>Documentation of 'UpdateLock'</b>:
     *
     * Method to modify a lock. Not existing locks will be created. Locks that are no longer owned nor used will be deleted. Owner and state of a lock will be stored persistently  (CCA FID: 0x1003)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onUpdateLock(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendUpdateLockError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'OnOffTrigger'

    /**
     * The method onOnOffTrigger() is called by ASF when a client invokes the
     * method 'OnOffTrigger'. A subclass has to implement this method and send
     * back a response to the client either with the sendOnOffTrigger() or
     * sendOnOffTriggerError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'OnOffTrigger'</b>:
     *
     * Set a new OnOff reason. A new system state will be calculated. (CCA FID: 0x100f)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onOnOffTriggerRequest (const ::boost::shared_ptr< OnOffTriggerRequest >& request) = 0;

    /**
     * The method sendOnOffTriggerResponse() sends a response of a previous
     * method invocation of 'OnOffTrigger' back to the client.
     *
     * <b>Documentation of 'OnOffTrigger'</b>:
     *
     * Set a new OnOff reason. A new system state will be calculated. (CCA FID: 0x100f)
     *
     * @param s32ResOut If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onOnOffTrigger(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendOnOffTriggerResponse (int32 s32ResOut, act_t act = 0);

    /**
     * The method sendOnOffTriggerError() sends an error response of a
     * previous method invocation of 'OnOffTrigger' back to the client.
     *
     * <b>Documentation of 'OnOffTrigger'</b>:
     *
     * Set a new OnOff reason. A new system state will be calculated. (CCA FID: 0x100f)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onOnOffTrigger(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendOnOffTriggerError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'StartProcess'

    /**
     * The method onStartProcess() is called by ASF when a client invokes the
     * method 'StartProcess'. A subclass has to implement this method and send
     * back a response to the client either with the sendStartProcess() or
     * sendStartProcessError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'StartProcess'</b>:
     *
     * Trigger to start a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger start process at the right time for their purposes. (CCA FID: 0x01fe)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStartProcessRequest (const ::boost::shared_ptr< StartProcessRequest >& request) = 0;

    /**
     * The method sendStartProcessResponse() sends a response of a previous
     * method invocation of 'StartProcess' back to the client.
     *
     * <b>Documentation of 'StartProcess'</b>:
     *
     * Trigger to start a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger start process at the right time for their purposes. (CCA FID: 0x01fe)
     *
     * @param s32ReturnValOut If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @param strLocationOut If the meaning of "strLocationOut" isn't clear, then there should be a description here.
     *
     * @param u32ProcIdOut If the meaning of "u32ProcIdOut" isn't clear, then there should be a description here.
     *
     * @param u32SpawnDurationOut If the meaning of "u32SpawnDurationOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onStartProcess(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendStartProcessResponse (int32 s32ReturnValOut, const ::std::string& strLocationOut, uint32 u32ProcIdOut, uint32 u32SpawnDurationOut, act_t act = 0);

    /**
     * The method sendStartProcessError() sends an error response of a
     * previous method invocation of 'StartProcess' back to the client.
     *
     * <b>Documentation of 'StartProcess'</b>:
     *
     * Trigger to start a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger start process at the right time for their purposes. (CCA FID: 0x01fe)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onStartProcess(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendStartProcessError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'StopProcess'

    /**
     * The method onStopProcess() is called by ASF when a client invokes the
     * method 'StopProcess'. A subclass has to implement this method and send
     * back a response to the client either with the sendStopProcess() or
     * sendStopProcessError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'StopProcess'</b>:
     *
     * Trigger to stop a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger stop process at the right time for their purposes. (CCA FID: 0x01fd)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStopProcessRequest (const ::boost::shared_ptr< StopProcessRequest >& request) = 0;

    /**
     * The method sendStopProcessResponse() sends a response of a previous
     * method invocation of 'StopProcess' back to the client.
     *
     * <b>Documentation of 'StopProcess'</b>:
     *
     * Trigger to stop a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger stop process at the right time for their purposes. (CCA FID: 0x01fd)
     *
     * @param s32ReturnValOut If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onStopProcess(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendStopProcessResponse (int32 s32ReturnValOut, act_t act = 0);

    /**
     * The method sendStopProcessError() sends an error response of a previous
     * method invocation of 'StopProcess' back to the client.
     *
     * <b>Documentation of 'StopProcess'</b>:
     *
     * Trigger to stop a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger stop process at the right time for their purposes. (CCA FID: 0x01fd)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onStopProcess(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendStopProcessError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RestartProcess'

    /**
     * The method onRestartProcess() is called by ASF when a client invokes
     * the method 'RestartProcess'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendRestartProcess() or sendRestartProcessError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'RestartProcess'</b>:
     *
     * Trigger to restart a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger restart process at the right time for their purposes. (CCA FID: 0x01fc)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRestartProcessRequest (const ::boost::shared_ptr< RestartProcessRequest >& request) = 0;

    /**
     * The method sendRestartProcessResponse() sends a response of a previous
     * method invocation of 'RestartProcess' back to the client.
     *
     * <b>Documentation of 'RestartProcess'</b>:
     *
     * Trigger to restart a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger restart process at the right time for their purposes. (CCA FID: 0x01fc)
     *
     * @param s32ReturnValOut If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRestartProcess(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRestartProcessResponse (int32 s32ReturnValOut, act_t act = 0);

    /**
     * The method sendRestartProcessError() sends an error response of a
     * previous method invocation of 'RestartProcess' back to the client.
     *
     * <b>Documentation of 'RestartProcess'</b>:
     *
     * Trigger to restart a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger restart process at the right time for their purposes. (CCA FID: 0x01fc)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRestartProcess(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRestartProcessError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'StartUpSyncPointReached'

    /**
     * The method onStartUpSyncPointReached() is called by ASF when a client
     * invokes the method 'StartUpSyncPointReached'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendStartUpSyncPointReached() or
     * sendStartUpSyncPointReachedError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'StartUpSyncPointReached'</b>:
     *
     * Inform about a new reached sync point. (CCA FID: 0x160)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStartUpSyncPointReachedRequest (const ::boost::shared_ptr< StartUpSyncPointReachedRequest >& request) = 0;

    /**
     * The method sendStartUpSyncPointReachedResponse() sends a response of a
     * previous method invocation of 'StartUpSyncPointReached' back to the
     * client.
     *
     * <b>Documentation of 'StartUpSyncPointReached'</b>:
     *
     * Inform about a new reached sync point. (CCA FID: 0x160)
     *
     * @param s32ResOut If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onStartUpSyncPointReached(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStartUpSyncPointReachedResponse (int32 s32ResOut, act_t act = 0);

    /**
     * The method sendStartUpSyncPointReachedError() sends an error response
     * of a previous method invocation of 'StartUpSyncPointReached' back to
     * the client.
     *
     * <b>Documentation of 'StartUpSyncPointReached'</b>:
     *
     * Inform about a new reached sync point. (CCA FID: 0x160)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onStartUpSyncPointReached(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStartUpSyncPointReachedError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ClearList'

    /**
     * The method onClearList() is called by ASF when a client invokes the
     * method 'ClearList'. A subclass has to implement this method and send
     * back a response to the client either with the sendClearList() or
     * sendClearListError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'ClearList'</b>:
     *
     * Method to clear engineering date (All at once or a selected one).  (CCA FID: 0x1040)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onClearListRequest (const ::boost::shared_ptr< ClearListRequest >& request) = 0;

    /**
     * The method sendClearListResponse() sends a response of a previous
     * method invocation of 'ClearList' back to the client.
     *
     * <b>Documentation of 'ClearList'</b>:
     *
     * Method to clear engineering date (All at once or a selected one).  (CCA FID: 0x1040)
     *
     * @param s32ResOut If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onClearList(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendClearListResponse (int32 s32ResOut, act_t act = 0);

    /**
     * The method sendClearListError() sends an error response of a previous
     * method invocation of 'ClearList' back to the client.
     *
     * <b>Documentation of 'ClearList'</b>:
     *
     * Method to clear engineering date (All at once or a selected one).  (CCA FID: 0x1040)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onClearList(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendClearListError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RestartSystem'

    /**
     * The method onRestartSystem() is called by ASF when a client invokes the
     * method 'RestartSystem'. A subclass has to implement this method and
     * send back a response to the client either with the sendRestartSystem()
     * or sendRestartSystemError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'RestartSystem'</b>:
     *
     * Method to trigger a Restart (Reset) by application e.g. DownloadFinished, DiagEcuReset, ... . No result will be received, as a reset is done inbetween.  (CCA FID: 0x1042)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRestartSystemRequest (const ::boost::shared_ptr< RestartSystemRequest >& request) = 0;

    /**
     * The method sendRestartSystemResponse() sends a response of a previous
     * method invocation of 'RestartSystem' back to the client.
     *
     * <b>Documentation of 'RestartSystem'</b>:
     *
     * Method to trigger a Restart (Reset) by application e.g. DownloadFinished, DiagEcuReset, ... . No result will be received, as a reset is done inbetween.  (CCA FID: 0x1042)
     *
     * @param e32ReturnValOut If the meaning of "e32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRestartSystem(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRestartSystemResponse (T_SPM_e32_MRESULT e32ReturnValOut, act_t act = 0);

    /**
     * The method sendRestartSystemError() sends an error response of a
     * previous method invocation of 'RestartSystem' back to the client.
     *
     * <b>Documentation of 'RestartSystem'</b>:
     *
     * Method to trigger a Restart (Reset) by application e.g. DownloadFinished, DiagEcuReset, ... . No result will be received, as a reset is done inbetween.  (CCA FID: 0x1042)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRestartSystem(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRestartSystemError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'AudioSourceChange'

    /**
     * The method onAudioSourceChange() is called by ASF when a client invokes
     * the method 'AudioSourceChange'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendAudioSourceChange() or sendAudioSourceChangeError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'AudioSourceChange'</b>:
     *
     * Method to trigger a source change by HMI. Used to change start configuration for next start-up.  (CCA FID: 0x1017)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onAudioSourceChangeRequest (const ::boost::shared_ptr< AudioSourceChangeRequest >& request) = 0;

    /**
     * The method sendAudioSourceChangeResponse() sends a response of a
     * previous method invocation of 'AudioSourceChange' back to the client.
     *
     * <b>Documentation of 'AudioSourceChange'</b>:
     *
     * Method to trigger a source change by HMI. Used to change start configuration for next start-up.  (CCA FID: 0x1017)
     *
     * @param s32ResOut If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onAudioSourceChange(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendAudioSourceChangeResponse (int32 s32ResOut, act_t act = 0);

    /**
     * The method sendAudioSourceChangeError() sends an error response of a
     * previous method invocation of 'AudioSourceChange' back to the client.
     *
     * <b>Documentation of 'AudioSourceChange'</b>:
     *
     * Method to trigger a source change by HMI. Used to change start configuration for next start-up.  (CCA FID: 0x1017)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onAudioSourceChange().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendAudioSourceChangeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ChangeBluetoothState'

    /**
     * The method onChangeBluetoothState() is called by ASF when a client
     * invokes the method 'ChangeBluetoothState'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendChangeBluetoothState() or sendChangeBluetoothStateError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'ChangeBluetoothState'</b>:
     *
     * Specific substate of the phone applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x413)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onChangeBluetoothStateRequest (const ::boost::shared_ptr< ChangeBluetoothStateRequest >& request) = 0;

    /**
     * The method sendChangeBluetoothStateResponse() sends a response of a
     * previous method invocation of 'ChangeBluetoothState' back to the
     * client.
     *
     * <b>Documentation of 'ChangeBluetoothState'</b>:
     *
     * Specific substate of the phone applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x413)
     *
     * @param s32ResOut If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onChangeBluetoothState(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendChangeBluetoothStateResponse (int32 s32ResOut, act_t act = 0);

    /**
     * The method sendChangeBluetoothStateError() sends an error response of a
     * previous method invocation of 'ChangeBluetoothState' back to the
     * client.
     *
     * <b>Documentation of 'ChangeBluetoothState'</b>:
     *
     * Specific substate of the phone applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x413)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onChangeBluetoothState(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendChangeBluetoothStateError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ChangeAudioState'

    /**
     * The method onChangeAudioState() is called by ASF when a client invokes
     * the method 'ChangeAudioState'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendChangeAudioState() or sendChangeAudioStateError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'ChangeAudioState'</b>:
     *
     * Specific substate of the audio applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x414)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onChangeAudioStateRequest (const ::boost::shared_ptr< ChangeAudioStateRequest >& request) = 0;

    /**
     * The method sendChangeAudioStateResponse() sends a response of a
     * previous method invocation of 'ChangeAudioState' back to the client.
     *
     * <b>Documentation of 'ChangeAudioState'</b>:
     *
     * Specific substate of the audio applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x414)
     *
     * @param s32ResOut If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onChangeAudioState(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendChangeAudioStateResponse (int32 s32ResOut, act_t act = 0);

    /**
     * The method sendChangeAudioStateError() sends an error response of a
     * previous method invocation of 'ChangeAudioState' back to the client.
     *
     * <b>Documentation of 'ChangeAudioState'</b>:
     *
     * Specific substate of the audio applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x414)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onChangeAudioState(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendChangeAudioStateError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ChangeSpiState'

    /**
     * The method onChangeSpiState() is called by ASF when a client invokes
     * the method 'ChangeSpiState'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendChangeSpiState() or sendChangeSpiStateError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'ChangeSpiState'</b>:
     *
     * Specific substate of the SmartPhoneIntegration applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x415)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onChangeSpiStateRequest (const ::boost::shared_ptr< ChangeSpiStateRequest >& request) = 0;

    /**
     * The method sendChangeSpiStateResponse() sends a response of a previous
     * method invocation of 'ChangeSpiState' back to the client.
     *
     * <b>Documentation of 'ChangeSpiState'</b>:
     *
     * Specific substate of the SmartPhoneIntegration applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x415)
     *
     * @param s32ResOut If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onChangeSpiState(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendChangeSpiStateResponse (int32 s32ResOut, act_t act = 0);

    /**
     * The method sendChangeSpiStateError() sends an error response of a
     * previous method invocation of 'ChangeSpiState' back to the client.
     *
     * <b>Documentation of 'ChangeSpiState'</b>:
     *
     * Specific substate of the SmartPhoneIntegration applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x415)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onChangeSpiState(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendChangeSpiStateError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ChangeTunerState'

    /**
     * The method onChangeTunerState() is called by ASF when a client invokes
     * the method 'ChangeTunerState'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendChangeTunerState() or sendChangeTunerStateError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'ChangeTunerState'</b>:
     *
     * Specific substate of the Tuner applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x417)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onChangeTunerStateRequest (const ::boost::shared_ptr< ChangeTunerStateRequest >& request) = 0;

    /**
     * The method sendChangeTunerStateResponse() sends a response of a
     * previous method invocation of 'ChangeTunerState' back to the client.
     *
     * <b>Documentation of 'ChangeTunerState'</b>:
     *
     * Specific substate of the Tuner applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x417)
     *
     * @param s32ResOut If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onChangeTunerState(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendChangeTunerStateResponse (int32 s32ResOut, act_t act = 0);

    /**
     * The method sendChangeTunerStateError() sends an error response of a
     * previous method invocation of 'ChangeTunerState' back to the client.
     *
     * <b>Documentation of 'ChangeTunerState'</b>:
     *
     * Specific substate of the Tuner applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x417)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onChangeTunerState(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendChangeTunerStateError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ChangeWifiState'

    /**
     * The method onChangeWifiState() is called by ASF when a client invokes
     * the method 'ChangeWifiState'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendChangeWifiState() or sendChangeWifiStateError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'ChangeWifiState'</b>:
     *
     * Specific substate of the connectivity applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x419)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onChangeWifiStateRequest (const ::boost::shared_ptr< ChangeWifiStateRequest >& request) = 0;

    /**
     * The method sendChangeWifiStateResponse() sends a response of a previous
     * method invocation of 'ChangeWifiState' back to the client.
     *
     * <b>Documentation of 'ChangeWifiState'</b>:
     *
     * Specific substate of the connectivity applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x419)
     *
     * @param s32ResOut If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onChangeWifiState(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendChangeWifiStateResponse (int32 s32ResOut, act_t act = 0);

    /**
     * The method sendChangeWifiStateError() sends an error response of a
     * previous method invocation of 'ChangeWifiState' back to the client.
     *
     * <b>Documentation of 'ChangeWifiState'</b>:
     *
     * Specific substate of the connectivity applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x419)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onChangeWifiState(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendChangeWifiStateError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ShutdownAndTerminateCcaApps'

    /**
     * The method onShutdownAndTerminateCcaApps() is called by ASF when a
     * client invokes the method 'ShutdownAndTerminateCcaApps'. A subclass has
     * to implement this method and send back a response to the client either
     * with the sendShutdownAndTerminateCcaApps() or
     * sendShutdownAndTerminateCcaAppsError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'ShutdownAndTerminateCcaApps'</b>:
     *
     * (CCA FID: 0x0004)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onShutdownAndTerminateCcaAppsRequest (const ::boost::shared_ptr< ShutdownAndTerminateCcaAppsRequest >& request) = 0;

    /**
     * The method sendShutdownAndTerminateCcaAppsResponse() sends a response
     * of a previous method invocation of 'ShutdownAndTerminateCcaApps' back
     * to the client.
     *
     * <b>Documentation of 'ShutdownAndTerminateCcaApps'</b>:
     *
     * (CCA FID: 0x0004)
     *
     * @param s32ResOut If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onShutdownAndTerminateCcaApps(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendShutdownAndTerminateCcaAppsResponse (int32 s32ResOut, act_t act = 0);

    /**
     * The method sendShutdownAndTerminateCcaAppsError() sends an error
     * response of a previous method invocation of
     * 'ShutdownAndTerminateCcaApps' back to the client.
     *
     * <b>Documentation of 'ShutdownAndTerminateCcaApps'</b>:
     *
     * (CCA FID: 0x0004)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onShutdownAndTerminateCcaApps(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendShutdownAndTerminateCcaAppsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetFactorySettingsNew'

    /**
     * The method onSetFactorySettingsNew() is called by ASF when a client
     * invokes the method 'SetFactorySettingsNew'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendSetFactorySettingsNew() or sendSetFactorySettingsNewError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'SetFactorySettingsNew'</b>:
     *
     * (CCA FID: 0x89)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetFactorySettingsNewRequest (const ::boost::shared_ptr< SetFactorySettingsNewRequest >& request) = 0;

    /**
     * The method sendSetFactorySettingsNewResponse() sends a response of a
     * previous method invocation of 'SetFactorySettingsNew' back to the
     * client.
     *
     * <b>Documentation of 'SetFactorySettingsNew'</b>:
     *
     * (CCA FID: 0x89)
     *
     * @param DefSetStateGroupOut If the meaning of "DefSetStateGroupOut" isn't clear, then there should be a description here.
     *
     * @param DefSetStateModeOut If the meaning of "DefSetStateModeOut" isn't clear, then there should be a description here.
     *
     * @param DefSetStateSuccessfulOut If the meaning of "DefSetStateSuccessfulOut" isn't clear, then there should be a description here.
     *
     * @param DefSetStateFirstDifferentParameterIdOut If the meaning of "DefSetStateFirstDifferentParameterIdOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetFactorySettingsNew(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetFactorySettingsNewResponse (T_e8_DiaglogDefsetType defSetStateGroupOut, T_e8_DefSetMode defSetStateModeOut, bool defSetStateSuccessfulOut, uint16 defSetStateFirstDifferentParameterIdOut, act_t act = 0);

    /**
     * The method sendSetFactorySettingsNewError() sends an error response of
     * a previous method invocation of 'SetFactorySettingsNew' back to the
     * client.
     *
     * <b>Documentation of 'SetFactorySettingsNew'</b>:
     *
     * (CCA FID: 0x89)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetFactorySettingsNew(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetFactorySettingsNewError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ClearVIN'

    /**
     * The method onClearVIN() is called by ASF when a client invokes the
     * method 'ClearVIN'. A subclass has to implement this method and send
     * back a response to the client either with the sendClearVIN() or
     * sendClearVINError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'ClearVIN'</b>:
     *
     * Clear Vehicle Identification Number if the EOL value is set or the internal manufacturersenablecounter is unequal to 0.  (CCA FID: 0x0522)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onClearVINRequest (const ::boost::shared_ptr< ClearVINRequest >& request) = 0;

    /**
     * The method sendClearVINResponse() sends a response of a previous method
     * invocation of 'ClearVIN' back to the client.
     *
     * <b>Documentation of 'ClearVIN'</b>:
     *
     * Clear Vehicle Identification Number if the EOL value is set or the internal manufacturersenablecounter is unequal to 0.  (CCA FID: 0x0522)
     *
     * @param ResultOut If the meaning of "ResultOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onClearVIN(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendClearVINResponse (uint32 resultOut, act_t act = 0);

    /**
     * The method sendClearVINError() sends an error response of a previous
     * method invocation of 'ClearVIN' back to the client.
     *
     * <b>Documentation of 'ClearVIN'</b>:
     *
     * Clear Vehicle Identification Number if the EOL value is set or the internal manufacturersenablecounter is unequal to 0.  (CCA FID: 0x0522)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onClearVIN(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendClearVINError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'PrepareDownload'

    /**
     * The method onPrepareDownload() is called by ASF when a client invokes
     * the method 'PrepareDownload'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendPrepareDownload() or sendPrepareDownloadError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'PrepareDownload'</b>:
     *
     * This function prepares the system for download. All components that are not needed are unloaded.   (CCA FID: 0x0900)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onPrepareDownloadRequest (const ::boost::shared_ptr< PrepareDownloadRequest >& request) = 0;

    /**
     * The method sendPrepareDownloadResponse() sends a response of a previous
     * method invocation of 'PrepareDownload' back to the client.
     *
     * <b>Documentation of 'PrepareDownload'</b>:
     *
     * This function prepares the system for download. All components that are not needed are unloaded.   (CCA FID: 0x0900)
     *
     * @param ResultOut If the meaning of "ResultOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onPrepareDownload(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendPrepareDownloadResponse (uint32 resultOut, act_t act = 0);

    /**
     * The method sendPrepareDownloadError() sends an error response of a
     * previous method invocation of 'PrepareDownload' back to the client.
     *
     * <b>Documentation of 'PrepareDownload'</b>:
     *
     * This function prepares the system for download. All components that are not needed are unloaded.   (CCA FID: 0x0900)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onPrepareDownload(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPrepareDownloadError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'EndDownload'

    /**
     * The method onEndDownload() is called by ASF when a client invokes the
     * method 'EndDownload'. A subclass has to implement this method and send
     * back a response to the client either with the sendEndDownload() or
     * sendEndDownloadError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'EndDownload'</b>:
     *
     * This function is used to end a download session where internal data was not changed so that a leave from download state is without risks.   (CCA FID: 0x0901)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEndDownloadRequest (const ::boost::shared_ptr< EndDownloadRequest >& request) = 0;

    /**
     * The method sendEndDownloadResponse() sends a response of a previous
     * method invocation of 'EndDownload' back to the client.
     *
     * <b>Documentation of 'EndDownload'</b>:
     *
     * This function is used to end a download session where internal data was not changed so that a leave from download state is without risks.   (CCA FID: 0x0901)
     *
     * @param ResultOut If the meaning of "ResultOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEndDownload(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendEndDownloadResponse (uint32 resultOut, act_t act = 0);

    /**
     * The method sendEndDownloadError() sends an error response of a previous
     * method invocation of 'EndDownload' back to the client.
     *
     * <b>Documentation of 'EndDownload'</b>:
     *
     * This function is used to end a download session where internal data was not changed so that a leave from download state is without risks.   (CCA FID: 0x0901)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEndDownload(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendEndDownloadError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetOnConfiguration'

    /**
     * The method onSetOnConfiguration() is called by ASF when a client
     * invokes the method 'SetOnConfiguration'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendSetOnConfiguration() or sendSetOnConfigurationError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'SetOnConfiguration'</b>:
     *
     * (CCA FID: 0x0902)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetOnConfigurationRequest (const ::boost::shared_ptr< SetOnConfigurationRequest >& request) = 0;

    /**
     * The method sendSetOnConfigurationResponse() sends a response of a
     * previous method invocation of 'SetOnConfiguration' back to the client.
     *
     * <b>Documentation of 'SetOnConfiguration'</b>:
     *
     * (CCA FID: 0x0902)
     *
     * @param ResultOut If the meaning of "ResultOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetOnConfiguration(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetOnConfigurationResponse (uint32 resultOut, act_t act = 0);

    /**
     * The method sendSetOnConfigurationError() sends an error response of a
     * previous method invocation of 'SetOnConfiguration' back to the client.
     *
     * <b>Documentation of 'SetOnConfiguration'</b>:
     *
     * (CCA FID: 0x0902)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetOnConfiguration().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetOnConfigurationError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetProcessConfiguration'

    /**
     * The method onSetProcessConfiguration() is called by ASF when a client
     * invokes the method 'SetProcessConfiguration'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendSetProcessConfiguration() or
     * sendSetProcessConfigurationError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'SetProcessConfiguration'</b>:
     *
     * (CCA FID: 0x0903)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetProcessConfigurationRequest (const ::boost::shared_ptr< SetProcessConfigurationRequest >& request) = 0;

    /**
     * The method sendSetProcessConfigurationResponse() sends a response of a
     * previous method invocation of 'SetProcessConfiguration' back to the
     * client.
     *
     * <b>Documentation of 'SetProcessConfiguration'</b>:
     *
     * (CCA FID: 0x0903)
     *
     * @param ResultOut If the meaning of "ResultOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetProcessConfiguration(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetProcessConfigurationResponse (uint32 resultOut, act_t act = 0);

    /**
     * The method sendSetProcessConfigurationError() sends an error response
     * of a previous method invocation of 'SetProcessConfiguration' back to
     * the client.
     *
     * <b>Documentation of 'SetProcessConfiguration'</b>:
     *
     * (CCA FID: 0x0903)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetProcessConfiguration(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetProcessConfigurationError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'EntertainDeMute'

    /**
     * The method onEntertainDeMute() is called by ASF when a client invokes
     * the method 'EntertainDeMute'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendEntertainDeMute() or sendEntertainDeMuteError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'EntertainDeMute'</b>:
     *
     * Method to trigger a demute by HMI.  (CCA FID: 0x1016)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEntertainDeMuteRequest (const ::boost::shared_ptr< EntertainDeMuteRequest >& request) = 0;

    /**
     * The method sendEntertainDeMuteResponse() sends a response of a previous
     * method invocation of 'EntertainDeMute' back to the client.
     *
     * <b>Documentation of 'EntertainDeMute'</b>:
     *
     * Method to trigger a demute by HMI.  (CCA FID: 0x1016)
     *
     * @param s32ReturnValOut If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEntertainDeMute(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendEntertainDeMuteResponse (int32 s32ReturnValOut, act_t act = 0);

    /**
     * The method sendEntertainDeMuteError() sends an error response of a
     * previous method invocation of 'EntertainDeMute' back to the client.
     *
     * <b>Documentation of 'EntertainDeMute'</b>:
     *
     * Method to trigger a demute by HMI.  (CCA FID: 0x1016)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEntertainDeMute(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEntertainDeMuteError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'EntertainMuteRequest'

    /**
     * The method onEntertainMuteRequest() is called by ASF when a client
     * invokes the method 'EntertainMuteRequest'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendEntertainMuteRequest() or sendEntertainMuteRequestError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'EntertainMuteRequest'</b>:
     *
     * Method to trigger a mute by HMI.  (CCA FID: 0x1015)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEntertainMuteRequestRequest (const ::boost::shared_ptr< EntertainMuteRequestRequest >& request) = 0;

    /**
     * The method sendEntertainMuteRequestResponse() sends a response of a
     * previous method invocation of 'EntertainMuteRequest' back to the
     * client.
     *
     * <b>Documentation of 'EntertainMuteRequest'</b>:
     *
     * Method to trigger a mute by HMI.  (CCA FID: 0x1015)
     *
     * @param s32ReturnValOut If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEntertainMuteRequest(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEntertainMuteRequestResponse (int32 s32ReturnValOut, act_t act = 0);

    /**
     * The method sendEntertainMuteRequestError() sends an error response of a
     * previous method invocation of 'EntertainMuteRequest' back to the
     * client.
     *
     * <b>Documentation of 'EntertainMuteRequest'</b>:
     *
     * Method to trigger a mute by HMI.  (CCA FID: 0x1015)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onEntertainMuteRequest(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEntertainMuteRequestError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'WelcomeAudioActivation'

    /**
     * The method onWelcomeAudioActivation() is called by ASF when a client
     * invokes the method 'WelcomeAudioActivation'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendWelcomeAudioActivation() or
     * sendWelcomeAudioActivationError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'WelcomeAudioActivation'</b>:
     *
     * Method to trigger a mute by HMI.  (CCA FID: 0x1025)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onWelcomeAudioActivationRequest (const ::boost::shared_ptr< WelcomeAudioActivationRequest >& request) = 0;

    /**
     * The method sendWelcomeAudioActivationResponse() sends a response of a
     * previous method invocation of 'WelcomeAudioActivation' back to the
     * client.
     *
     * <b>Documentation of 'WelcomeAudioActivation'</b>:
     *
     * Method to trigger a mute by HMI.  (CCA FID: 0x1025)
     *
     * @param s32ReturnValOut If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onWelcomeAudioActivation(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendWelcomeAudioActivationResponse (int32 s32ReturnValOut, act_t act = 0);

    /**
     * The method sendWelcomeAudioActivationError() sends an error response of
     * a previous method invocation of 'WelcomeAudioActivation' back to the
     * client.
     *
     * <b>Documentation of 'WelcomeAudioActivation'</b>:
     *
     * Method to trigger a mute by HMI.  (CCA FID: 0x1025)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onWelcomeAudioActivation(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendWelcomeAudioActivationError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    SystemStateUpdate _SystemStateProperty;

    DownloadLockStatesUpdate _DownloadLockStatesProperty;

    UpdateLockStatesUpdate _UpdateLockStatesProperty;

    ActiveOnOffTriggerUpdate _ActiveOnOffTriggerProperty;

    SubStatesUpdate _SubStatesProperty;

    HistoryTriggerUpdate _HistoryTriggerProperty;

    InsertStateUpdate _InsertStateProperty;

    MediaEjectStateUpdate _MediaEjectStateProperty;

    PhoneMuteStateUpdate _PhoneMuteStateProperty;

    OnTipperStateUpdate _OnTipperStateProperty;

    IgnitionCyclesUpdate _IgnitionCyclesProperty;

    SysPwrModeUpdate _SysPwrModeProperty;

    SysPwrSaveModeUpdate _SysPwrSaveModeProperty;

    MapDownloadLockStateUpdate _MapDownloadLockStateProperty;

    StandbyTimeUpdate _StandbyTimeProperty;

    PersitentStandbyTimeUpdate _PersitentStandbyTimeProperty;

    IgnitionOffTimeUpdate _IgnitionOffTimeProperty;

    DoorOpenTimeUpdate _DoorOpenTimeProperty;

    ClockDisplayTimeUpdate _ClockDisplayTimeProperty;

    SystemStateTimeUpdate _SystemStateTimeProperty;

    ProcessListUpdate _ProcessListProperty;

    WakeupReasonUpdate _WakeupReasonProperty;

    StartupReasonUpdate _StartupReasonProperty;

    ConnectToBatteryUpdate _ConnectToBatteryProperty;

    CodeRequestStateUpdate _CodeRequestStateProperty;

    ActiveStartUpSyncPointsUpdate _ActiveStartUpSyncPointsProperty;

    CvmEventUpdate _CvmEventProperty;

    UBatSenseUpdate _UBatSenseProperty;

    CoproStateUpdate _CoproStateProperty;

    DevicePowerOnTimeUpdate _DevicePowerOnTimeProperty;

    LastSystemRuntimeUpdate _LastSystemRuntimeProperty;

    CurrentSystemRuntimeUpdate _CurrentSystemRuntimeProperty;

    ResetListUpdate _ResetListProperty;

    ResetCounterUpdate _ResetCounterProperty;

    TransportModeListUpdate _TransportModeListProperty;

    ResetHistoryUpdate _ResetHistoryProperty;

    WakeupHistoryUpdate _WakeupHistoryProperty;

    StateHistoryUpdate _StateHistoryProperty;

    ErrStateHistory01Update _ErrStateHistory01Property;

    ErrStateHistory02Update _ErrStateHistory02Property;

    ErrStateHistory03Update _ErrStateHistory03Property;

    ErrStateHistory04Update _ErrStateHistory04Property;

    ErrStateHistory05Update _ErrStateHistory05Property;

    SwitchOnHistoryUpdate _SwitchOnHistoryProperty;

    DeviceOnCounterUpdate _DeviceOnCounterProperty;

    VoltageEventCounterUpdate _VoltageEventCounterProperty;

    VoltageRangeHistogramUpdate _VoltageRangeHistogramProperty;

    CpuUsageStatisticUpdate _CpuUsageStatisticProperty;

    RamUsageStatisticUpdate _RamUsageStatisticProperty;

    StartupTimeStatisticUpdate _StartupTimeStatisticProperty;

    RunlevelStateUpdate _RunlevelStateProperty;

    RestartUpdate _RestartProperty;

    LifesignUpdate _LifesignProperty;

    HmiStateUpdate _HmiStateProperty;

    SystemPowerBehaviourUpdate _SystemPowerBehaviourProperty;

    DimStateUpdate _DimStateProperty;

    DimmingStateUpdate _DimmingStateProperty;

    BluetoothStateUpdate _BluetoothStateProperty;

    AudioStateUpdate _AudioStateProperty;

    SpiStateUpdate _SpiStateProperty;

    TunerStateUpdate _TunerStateProperty;

    WifiStateUpdate _WifiStateProperty;

    OnOffReasonUpdate _OnOffReasonProperty;

    WakeupListUpdate _WakeupListProperty;

    StartupFinishedUpdate _StartupFinishedProperty;

    SysStateUpdate _SysStateProperty;

    MostStateUpdate _MostStateProperty;

    MostVersionUpdate _MostVersionProperty;

    RVCStateUpdate _RVCStateProperty;

    TriggerMostRemoteResetUpdate _TriggerMostRemoteResetProperty;

    PartnumberUpdate _PartnumberProperty;

    PartnumbersUpdate _PartnumbersProperty;

    AlphacodeUpdate _AlphacodeProperty;

    AlphacodesUpdate _AlphacodesProperty;

    ManufacturersEnableCounterUpdate _ManufacturersEnableCounterProperty;

    NoCalibrationStateUpdate _NoCalibrationStateProperty;

    SecurityCommErrorUpdate _SecurityCommErrorProperty;

    SecurityMoreThan10VinUpdate _SecurityMoreThan10VinProperty;

    SecurityInvalidVinUpdate _SecurityInvalidVinProperty;

    SecurityCurrentVinUpdate _SecurityCurrentVinProperty;

    SecurityVinHistoryUpdate _SecurityVinHistoryProperty;

    VINUpdate _VINProperty;

    SecurityStateUpdate _SecurityStateProperty;

    VehicleIDUpdate _VehicleIDProperty;

    DisplayVariantUpdate _DisplayVariantProperty;

    ReductionLevelUpdate _ReductionLevelProperty;

    StartupStateUpdate _StartupStateProperty;

    EntertainMuteUpdate _EntertainMuteProperty;

    WelcomeAudioStateUpdate _WelcomeAudioStateProperty;

    UnballastTimeFromEngineStoppedUpdate _UnballastTimeFromEngineStoppedProperty;

    UnballastTimeBeforeUnballastUpdate _UnballastTimeBeforeUnballastProperty;

    UnballastWarningTimeUpdate _UnballastWarningTimeProperty;

    DegradedCountUpdate _DegradedCountProperty;

    DegradedTimeUpdate _DegradedTimeProperty;

    PhoneHandoverWarnTimeUpdate _PhoneHandoverWarnTimeProperty;

    friend class Lcm_dbus_fi_serviceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace lcm_dbus_fi_service
} // namespace lcm_dbus_fi
} // namespace cm
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_CM_LCM_DBUS_FI_LCM_DBUS_FI_SERVICESTUB_H
