/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/CcaTypesConst.h"
#include "asf/stream/json.h"
#include "input_main_fi.h"
#include "input_main_fiJson.h"
#include "input_main_fiJsonPrivate.h"
#include "input_main_fi_types.h"
#include "input_main_fi_typesConst.h"
#include "input_main_fi_typesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "PressedKeysStatus"

void serializeJson (const ::input_main_fi::PressedKeysStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasKeyInfoList()) {
        yajl_gen_string(g, (const unsigned char*)  "KeyInfoList" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::input_main_fi_types::T_KeyInfo >& o1 = value.getKeyInfoList();
        {
            ::std::vector< ::input_main_fi_types::T_KeyInfo >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                serializeJson((*o0), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::input_main_fi::PressedKeysStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PressedKeysErrorStructure"

void serializeJson (const ::input_main_fi::PressedKeysErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::input_main_fi::PressedKeysErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PressedKeysError"

void serializeJson (const ::input_main_fi::PressedKeysError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::input_main_fi::PressedKeysError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::input_main_fi::PressedKeysError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::input_main_fi::PressedKeysError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EncoderDirStatusStatus"

void serializeJson (const ::input_main_fi::EncoderDirStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTEncoderDirectionList()) {
        yajl_gen_string(g, (const unsigned char*)  "tEncoderDirectionList" , 21);
        yajl_gen_array_open(g);
        const ::std::vector< ::input_main_fi_types::T_EncInfo >& o3 = value.getTEncoderDirectionList();
        {
            ::std::vector< ::input_main_fi_types::T_EncInfo >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::input_main_fi::EncoderDirStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EncoderDirStatusErrorStructure"

void serializeJson (const ::input_main_fi::EncoderDirStatusErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::input_main_fi::EncoderDirStatusErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EncoderDirStatusError"

void serializeJson (const ::input_main_fi::EncoderDirStatusError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::input_main_fi::EncoderDirStatusError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::input_main_fi::EncoderDirStatusError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::input_main_fi::EncoderDirStatusError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EncoderStatusStatus"

void serializeJson (const ::input_main_fi::EncoderStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTEncoderStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "tEncoderStatus" , 14);
        serializeJson(value.getTEncoderStatus(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::input_main_fi::EncoderStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EncoderStatusErrorStructure"

void serializeJson (const ::input_main_fi::EncoderStatusErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::input_main_fi::EncoderStatusErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EncoderStatusError"

void serializeJson (const ::input_main_fi::EncoderStatusError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::input_main_fi::EncoderStatusError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::input_main_fi::EncoderStatusError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::input_main_fi::EncoderStatusError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TouchStatusStatus"

void serializeJson (const ::input_main_fi::TouchStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTTouchDataList()) {
        yajl_gen_string(g, (const unsigned char*)  "tTouchDataList" , 14);
        yajl_gen_array_open(g);
        const ::std::vector< ::input_main_fi_types::T_TouchInfo >& o5 = value.getTTouchDataList();
        {
            ::std::vector< ::input_main_fi_types::T_TouchInfo >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                serializeJson((*o4), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::input_main_fi::TouchStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TouchStatusErrorStructure"

void serializeJson (const ::input_main_fi::TouchStatusErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::input_main_fi::TouchStatusErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TouchStatusError"

void serializeJson (const ::input_main_fi::TouchStatusError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::input_main_fi::TouchStatusError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::input_main_fi::TouchStatusError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::input_main_fi::TouchStatusError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TouchStatusPIVISecondaryStatus"

void serializeJson (const ::input_main_fi::TouchStatusPIVISecondaryStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTSecondaryTouchDataList()) {
        yajl_gen_string(g, (const unsigned char*)  "tSecondaryTouchDataList" , 23);
        yajl_gen_array_open(g);
        const ::std::vector< ::input_main_fi_types::T_TouchInfo >& o7 = value.getTSecondaryTouchDataList();
        {
            ::std::vector< ::input_main_fi_types::T_TouchInfo >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                serializeJson((*o6), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::input_main_fi::TouchStatusPIVISecondaryStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TouchStatusPIVISecondaryErrorStructure"

void serializeJson (const ::input_main_fi::TouchStatusPIVISecondaryErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::input_main_fi::TouchStatusPIVISecondaryErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TouchStatusPIVISecondaryError"

void serializeJson (const ::input_main_fi::TouchStatusPIVISecondaryError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::input_main_fi::TouchStatusPIVISecondaryError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::input_main_fi::TouchStatusPIVISecondaryError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::input_main_fi::TouchStatusPIVISecondaryError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EnableInputEventsResult"

void serializeJson (const ::input_main_fi::EnableInputEventsResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSimulationStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "SimulationStatus" , 16);
        yajl_gen_bool(g, (bool)value.getSimulationStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::input_main_fi::EnableInputEventsResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DisableInputEventsResult"

void serializeJson (const ::input_main_fi::DisableInputEventsResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSimulationStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "SimulationStatus" , 16);
        yajl_gen_bool(g, (bool)value.getSimulationStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::input_main_fi::DisableInputEventsResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimulateKeyInjectionStart"

void serializeJson (const ::input_main_fi::SimulateKeyInjectionStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE16Keycode()) {
        yajl_gen_string(g, (const unsigned char*)  "e16Keycode" , 10);
        const char* s = ::input_main_fi_types::T_e16_KeyCode_Name(value.getE16Keycode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE16Keycode());
    }
    if (!isSparse || value.hasU8KeyStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "u8KeyStatus" , 11);
        yajl_gen_integer(g, (long long)value.getU8KeyStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::input_main_fi::SimulateKeyInjectionStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimulateEncRotationStart"

void serializeJson (const ::input_main_fi::SimulateEncRotationStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8EncoderType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8EncoderType" , 13);
        const char* s = ::input_main_fi_types::T_e8_EncoderType_Name(value.getE8EncoderType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8EncoderType());
    }
    if (!isSparse || value.hasS8EncSteps()) {
        yajl_gen_string(g, (const unsigned char*)  "s8EncSteps" , 10);
        yajl_gen_integer(g, (long long)value.getS8EncSteps());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::input_main_fi::SimulateEncRotationStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimulateSingleTouchStart"

void serializeJson (const ::input_main_fi::SimulateSingleTouchStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS32XCoord()) {
        yajl_gen_string(g, (const unsigned char*)  "s32XCoord" , 9);
        yajl_gen_integer(g, (long long)value.getS32XCoord());
    }
    if (!isSparse || value.hasS32YCoord()) {
        yajl_gen_string(g, (const unsigned char*)  "s32YCoord" , 9);
        yajl_gen_integer(g, (long long)value.getS32YCoord());
    }
    if (!isSparse || value.hasE8TouchStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8TouchStatus" , 13);
        const char* s = ::input_main_fi_types::T_e8_TouchStatus_Name(value.getE8TouchStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8TouchStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::input_main_fi::SimulateSingleTouchStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimulateTouchSlideStart"

void serializeJson (const ::input_main_fi::SimulateTouchSlideStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS32XStart()) {
        yajl_gen_string(g, (const unsigned char*)  "s32XStart" , 9);
        yajl_gen_integer(g, (long long)value.getS32XStart());
    }
    if (!isSparse || value.hasS32YStart()) {
        yajl_gen_string(g, (const unsigned char*)  "s32YStart" , 9);
        yajl_gen_integer(g, (long long)value.getS32YStart());
    }
    if (!isSparse || value.hasS32XEnd()) {
        yajl_gen_string(g, (const unsigned char*)  "s32XEnd" , 7);
        yajl_gen_integer(g, (long long)value.getS32XEnd());
    }
    if (!isSparse || value.hasS32YEnd()) {
        yajl_gen_string(g, (const unsigned char*)  "s32YEnd" , 7);
        yajl_gen_integer(g, (long long)value.getS32YEnd());
    }
    if (!isSparse || value.hasU16Duration()) {
        yajl_gen_string(g, (const unsigned char*)  "u16Duration" , 11);
        yajl_gen_integer(g, (long long)value.getU16Duration());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::input_main_fi::SimulateTouchSlideStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimulateMultiTouchStart"

void serializeJson (const ::input_main_fi::SimulateMultiTouchStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS32SlotId()) {
        yajl_gen_string(g, (const unsigned char*)  "s32SlotId" , 9);
        yajl_gen_integer(g, (long long)value.getS32SlotId());
    }
    if (!isSparse || value.hasS32XCoord()) {
        yajl_gen_string(g, (const unsigned char*)  "s32XCoord" , 9);
        yajl_gen_integer(g, (long long)value.getS32XCoord());
    }
    if (!isSparse || value.hasS32YCoord()) {
        yajl_gen_string(g, (const unsigned char*)  "s32YCoord" , 9);
        yajl_gen_integer(g, (long long)value.getS32YCoord());
    }
    if (!isSparse || value.hasE8TouchStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8TouchStatus" , 13);
        const char* s = ::input_main_fi_types::T_e8_TouchStatus_Name(value.getE8TouchStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8TouchStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::input_main_fi::SimulateMultiTouchStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GestureRecordStart"

void serializeJson (const ::input_main_fi::GestureRecordStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8StartStop()) {
        yajl_gen_string(g, (const unsigned char*)  "u8StartStop" , 11);
        yajl_gen_integer(g, (long long)value.getU8StartStop());
    }
    if (!isSparse || value.hasFilePath()) {
        yajl_gen_string(g, (const unsigned char*)  "FilePath" , 8);
        const char *s = value.getFilePath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::input_main_fi::GestureRecordStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GestureRecordResult"

void serializeJson (const ::input_main_fi::GestureRecordResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBSuccess()) {
        yajl_gen_string(g, (const unsigned char*)  "bSuccess" , 8);
        yajl_gen_bool(g, (bool)value.getBSuccess());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::input_main_fi::GestureRecordResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GestureReplayStart"

void serializeJson (const ::input_main_fi::GestureReplayStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8StartStop()) {
        yajl_gen_string(g, (const unsigned char*)  "u8StartStop" , 11);
        yajl_gen_integer(g, (long long)value.getU8StartStop());
    }
    if (!isSparse || value.hasFilePath()) {
        yajl_gen_string(g, (const unsigned char*)  "FilePath" , 8);
        const char *s = value.getFilePath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::input_main_fi::GestureReplayStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GestureReplayResult"

void serializeJson (const ::input_main_fi::GestureReplayResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBSuccess()) {
        yajl_gen_string(g, (const unsigned char*)  "bSuccess" , 8);
        yajl_gen_bool(g, (bool)value.getBSuccess());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::input_main_fi::GestureReplayResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimulatePIVITouchStart"

void serializeJson (const ::input_main_fi::SimulatePIVITouchStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS32XCoord()) {
        yajl_gen_string(g, (const unsigned char*)  "s32XCoord" , 9);
        yajl_gen_integer(g, (long long)value.getS32XCoord());
    }
    if (!isSparse || value.hasS32YCoord()) {
        yajl_gen_string(g, (const unsigned char*)  "s32YCoord" , 9);
        yajl_gen_integer(g, (long long)value.getS32YCoord());
    }
    if (!isSparse || value.hasS32ScreenNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "s32ScreenNumber" , 15);
        yajl_gen_integer(g, (long long)value.getS32ScreenNumber());
    }
    if (!isSparse || value.hasE8TouchStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8TouchStatus" , 13);
        const char* s = ::input_main_fi_types::T_e8_TouchStatus_Name(value.getE8TouchStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8TouchStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::input_main_fi::SimulatePIVITouchStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DevInputNotifyConnectionStart"

void serializeJson (const ::input_main_fi::DevInputNotifyConnectionStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeviceType()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceType" , 10);
        const char* s = ::input_main_fi_types::T_e8_Device_Name(value.getDeviceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceType());
    }
    if (!isSparse || value.hasDeviceConnectStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceConnectStatus" , 19);
        const char* s = ::input_main_fi_types::T_e8_DeviceConnectStatus_Name(value.getDeviceConnectStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeviceConnectStatus());
    }
    if (!isSparse || value.hasDeviceName()) {
        yajl_gen_string(g, (const unsigned char*)  "DeviceName" , 10);
        const char *s = value.getDeviceName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::input_main_fi::DevInputNotifyConnectionStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SimulatePIVITouchSlideStart"

void serializeJson (const ::input_main_fi::SimulatePIVITouchSlideStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasS32XStart()) {
        yajl_gen_string(g, (const unsigned char*)  "s32XStart" , 9);
        yajl_gen_integer(g, (long long)value.getS32XStart());
    }
    if (!isSparse || value.hasS32YStart()) {
        yajl_gen_string(g, (const unsigned char*)  "s32YStart" , 9);
        yajl_gen_integer(g, (long long)value.getS32YStart());
    }
    if (!isSparse || value.hasS32XEnd()) {
        yajl_gen_string(g, (const unsigned char*)  "s32XEnd" , 7);
        yajl_gen_integer(g, (long long)value.getS32XEnd());
    }
    if (!isSparse || value.hasS32YEnd()) {
        yajl_gen_string(g, (const unsigned char*)  "s32YEnd" , 7);
        yajl_gen_integer(g, (long long)value.getS32YEnd());
    }
    if (!isSparse || value.hasU16Duration()) {
        yajl_gen_string(g, (const unsigned char*)  "u16Duration" , 11);
        yajl_gen_integer(g, (long long)value.getU16Duration());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::input_main_fi::SimulatePIVITouchSlideStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::PressedKeysStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::PressedKeysErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::PressedKeysError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::EncoderDirStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::EncoderDirStatusErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::EncoderDirStatusError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::EncoderStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::EncoderStatusErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::EncoderStatusError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::TouchStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::TouchStatusErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::TouchStatusError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::TouchStatusPIVISecondaryStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::TouchStatusPIVISecondaryErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::TouchStatusPIVISecondaryError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::EnableInputEventsResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::DisableInputEventsResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::SimulateKeyInjectionStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::SimulateEncRotationStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::SimulateSingleTouchStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::SimulateTouchSlideStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::SimulateMultiTouchStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::GestureRecordStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::GestureRecordResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::GestureReplayStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::GestureReplayResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::SimulatePIVITouchStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::DevInputNotifyConnectionStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi
using namespace ::asf::stream::json;

namespace input_main_fi {

std::ostream& operator<<(std::ostream& o, const ::input_main_fi::SimulatePIVITouchSlideStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace input_main_fi

