#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef HEATCTRL_MAIN_FI_TYPES_H
#define HEATCTRL_MAIN_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "heatctrl_main_fi_typesConst.h"
#include <cstring>
#include <vector>

/**
 * Types heatctrl_main_fi_types
 */

namespace heatctrl_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_SensorTemperature;

class T_SensorState;

class T_EmergencyFunction;

class T_FAN;

class T_FANReq;

class T_FANCtrl;

class T_FANCtrlReq;

// type definitions
/**
 * <p>Possible values for the temperature in deci degree Celsius.</p>
 * <p>---</p>
 * <p>e.g.: value 200 / 200 dï¿½C means 20,0ï¿½C</p>
 */
typedef int16 T_s16_SensorTemperaturValue;

/**
 * If the meaning of "T_SensorTemperatureList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_SensorTemperature > T_SensorTemperatureList;

/**
 * If the meaning of "T_SensorStateList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_SensorState > T_SensorStateList;

/**
 * If the meaning of "T_EmergencyFunctionList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_EmergencyFunction > T_EmergencyFunctionList;

/**
 * <p>Possible values for the FAN speed in percent [%].</p>
 * <p>---</p>
 * <p>e.g.: value 10 means 10%</p>
 * <p>---</p>
 * <p>NOTE: value greater than 100 indicates a error!</p>
 */
typedef uint8 T_u8_FANSpeedValue;

/**
 * <p>Possible values FAN load current in Milliampere [mA].</p>
 * <p>---</p>
 * <p>e.g.: value 155 means 155 mA = 0.155 A</p>
 * <p>---</p>
 * <p>NOTE: value equal than 0xFFFF indicates a error!</p>
 */
typedef uint16 T_u16_FANCurrentValue;


/**
 * <p>structure of sensor temperature information</p>
 */
class T_SensorTemperature {
public:

    /**
     * Default constructor
     */
    inline  T_SensorTemperature ();

    /**
     * Copy constructor
     */
    inline  T_SensorTemperature (const T_SensorTemperature &rhs);

    /**
     * All fields constructor
     */
    inline  T_SensorTemperature (T_e8_SensorID ID_, T_s16_SensorTemperaturValue Temperature_, T_e8_TemperatureQualityType Quality_, T_s16_SensorTemperaturValue TemperatureMin_, T_s16_SensorTemperaturValue TemperatureMax_);

    /**
     * Destructor
     */
    inline  ~T_SensorTemperature();

    /**
     * Assignment operator
     */
    inline T_SensorTemperature& operator = (const T_SensorTemperature& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SensorTemperature& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SensorTemperature& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SensorTemperature& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SensorTemperature& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ID"

    static const int kID = 0;

    /**
     * Clears the field "ID".
     *
     * The field will be set to its default value. The hasID()
     * method will return false.
     */
    inline void clearID();

    /**
     * Checks whether the field "ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setID()). Otherwise it will return false.
     */
    inline bool hasID () const;

    /**
     * Returns the value of the member "ID".
     *
     * <p>identificator of sensor</p>
     *
     * @return The value of the field "ID"
     */
    inline T_e8_SensorID getID () const;

    /**
     * Sets the value of the member "ID".
     *
     * <p>identificator of sensor</p>
     *
     * @param ID The value which will be set
     */
    inline void setID (T_e8_SensorID ID_);

    // API of field "Temperature"

    static const int kTemperature = 1;

    /**
     * Clears the field "Temperature".
     *
     * The field will be set to its default value. The hasTemperature()
     * method will return false.
     */
    inline void clearTemperature();

    /**
     * Checks whether the field "Temperature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTemperature()). Otherwise it will return false.
     */
    inline bool hasTemperature () const;

    /**
     * Returns the value of the member "Temperature".
     *
     * <p>detected temperature</p>
     *
     * @return The value of the field "Temperature"
     */
    inline T_s16_SensorTemperaturValue getTemperature () const;

    /**
     * Sets the value of the member "Temperature".
     *
     * <p>detected temperature</p>
     *
     * @param Temperature The value which will be set
     */
    inline void setTemperature (T_s16_SensorTemperaturValue Temperature_);

    // API of field "Quality"

    static const int kQuality = 2;

    /**
     * Clears the field "Quality".
     *
     * The field will be set to its default value. The hasQuality()
     * method will return false.
     */
    inline void clearQuality();

    /**
     * Checks whether the field "Quality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setQuality()). Otherwise it will return false.
     */
    inline bool hasQuality () const;

    /**
     * Returns the value of the member "Quality".
     *
     * <p>quality of temperature depending on source</p>
     *
     * @return The value of the field "Quality"
     */
    inline T_e8_TemperatureQualityType getQuality () const;

    /**
     * Sets the value of the member "Quality".
     *
     * <p>quality of temperature depending on source</p>
     *
     * @param Quality The value which will be set
     */
    inline void setQuality (T_e8_TemperatureQualityType Quality_);

    // API of field "TemperatureMin"

    static const int kTemperatureMin = 3;

    /**
     * Clears the field "TemperatureMin".
     *
     * The field will be set to its default value. The hasTemperatureMin()
     * method will return false.
     */
    inline void clearTemperatureMin();

    /**
     * Checks whether the field "TemperatureMin" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTemperatureMin()). Otherwise it will return false.
     */
    inline bool hasTemperatureMin () const;

    /**
     * Returns the value of the member "TemperatureMin".
     *
     * <p>smallest measured temperature since last measurement reset</p>
     *
     * @return The value of the field "TemperatureMin"
     */
    inline T_s16_SensorTemperaturValue getTemperatureMin () const;

    /**
     * Sets the value of the member "TemperatureMin".
     *
     * <p>smallest measured temperature since last measurement reset</p>
     *
     * @param TemperatureMin The value which will be set
     */
    inline void setTemperatureMin (T_s16_SensorTemperaturValue TemperatureMin_);

    // API of field "TemperatureMax"

    static const int kTemperatureMax = 4;

    /**
     * Clears the field "TemperatureMax".
     *
     * The field will be set to its default value. The hasTemperatureMax()
     * method will return false.
     */
    inline void clearTemperatureMax();

    /**
     * Checks whether the field "TemperatureMax" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTemperatureMax()). Otherwise it will return false.
     */
    inline bool hasTemperatureMax () const;

    /**
     * Returns the value of the member "TemperatureMax".
     *
     * <p>largest measured temperature since last measurement reset</p>
     *
     * @return The value of the field "TemperatureMax"
     */
    inline T_s16_SensorTemperaturValue getTemperatureMax () const;

    /**
     * Sets the value of the member "TemperatureMax".
     *
     * <p>largest measured temperature since last measurement reset</p>
     *
     * @param TemperatureMax The value which will be set
     */
    inline void setTemperatureMax (T_s16_SensorTemperaturValue TemperatureMax_);

    static const T_SensorTemperature &getDefaultInstance();

private:

    inline void set_has_ID ();

    inline void clear_has_ID ();

    inline void set_has_Temperature ();

    inline void clear_has_Temperature ();

    inline void set_has_Quality ();

    inline void clear_has_Quality ();

    inline void set_has_TemperatureMin ();

    inline void clear_has_TemperatureMin ();

    inline void set_has_TemperatureMax ();

    inline void clear_has_TemperatureMax ();

    uint32 _has_bits_[ (5 + 31) / 32];

    T_e8_SensorID _ID;

    T_s16_SensorTemperaturValue _Temperature;

    T_e8_TemperatureQualityType _Quality;

    T_s16_SensorTemperaturValue _TemperatureMin;

    T_s16_SensorTemperaturValue _TemperatureMax;

};

/**
 * <p>structure of sensor state information</p>
 */
class T_SensorState {
public:

    /**
     * Default constructor
     */
    inline  T_SensorState ();

    /**
     * Copy constructor
     */
    inline  T_SensorState (const T_SensorState &rhs);

    /**
     * All fields constructor
     */
    inline  T_SensorState (T_e8_SensorID ID_, T_e8_SensorState State_, T_e8_SensorState LastValidState_);

    /**
     * Destructor
     */
    inline  ~T_SensorState();

    /**
     * Assignment operator
     */
    inline T_SensorState& operator = (const T_SensorState& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SensorState& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SensorState& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SensorState& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SensorState& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ID"

    static const int kID = 0;

    /**
     * Clears the field "ID".
     *
     * The field will be set to its default value. The hasID()
     * method will return false.
     */
    inline void clearID();

    /**
     * Checks whether the field "ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setID()). Otherwise it will return false.
     */
    inline bool hasID () const;

    /**
     * Returns the value of the member "ID".
     *
     * <p>identificator of sensor</p>
     *
     * @return The value of the field "ID"
     */
    inline T_e8_SensorID getID () const;

    /**
     * Sets the value of the member "ID".
     *
     * <p>identificator of sensor</p>
     *
     * @param ID The value which will be set
     */
    inline void setID (T_e8_SensorID ID_);

    // API of field "State"

    static const int kState = 1;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * <p>the thermal state</p>
     *
     * @return The value of the field "State"
     */
    inline T_e8_SensorState getState () const;

    /**
     * Sets the value of the member "State".
     *
     * <p>the thermal state</p>
     *
     * @param State The value which will be set
     */
    inline void setState (T_e8_SensorState State_);

    // API of field "LastValidState"

    static const int kLastValidState = 2;

    /**
     * Clears the field "LastValidState".
     *
     * The field will be set to its default value. The hasLastValidState()
     * method will return false.
     */
    inline void clearLastValidState();

    /**
     * Checks whether the field "LastValidState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLastValidState()). Otherwise it will return false.
     */
    inline bool hasLastValidState () const;

    /**
     * Returns the value of the member "LastValidState".
     *
     * <p>The last known valid thermal state (see figure stm thermal sensor states - right substate VALID</p>
     * <p>---</p>
     * <p>Posibile states are INIT, CRITICAL_LOW - EMERGENCY_HIGH</p>
     *
     * @return The value of the field "LastValidState"
     */
    inline T_e8_SensorState getLastValidState () const;

    /**
     * Sets the value of the member "LastValidState".
     *
     * <p>The last known valid thermal state (see figure stm thermal sensor states - right substate VALID</p>
     * <p>---</p>
     * <p>Posibile states are INIT, CRITICAL_LOW - EMERGENCY_HIGH</p>
     *
     * @param LastValidState The value which will be set
     */
    inline void setLastValidState (T_e8_SensorState LastValidState_);

    static const T_SensorState &getDefaultInstance();

private:

    inline void set_has_ID ();

    inline void clear_has_ID ();

    inline void set_has_State ();

    inline void clear_has_State ();

    inline void set_has_LastValidState ();

    inline void clear_has_LastValidState ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_e8_SensorID _ID;

    T_e8_SensorState _State;

    T_e8_SensorState _LastValidState;

};

/**
 * <p>structure of emergency function information</p>
 */
class T_EmergencyFunction {
public:

    /**
     * Default constructor
     */
    inline  T_EmergencyFunction ();

    /**
     * Copy constructor
     */
    inline  T_EmergencyFunction (const T_EmergencyFunction &rhs);

    /**
     * All fields constructor
     */
    inline  T_EmergencyFunction (T_e8_EmergncyFunctionID ID_, T_e8_EmergncyFunctionState State_);

    /**
     * Destructor
     */
    inline  ~T_EmergencyFunction();

    /**
     * Assignment operator
     */
    inline T_EmergencyFunction& operator = (const T_EmergencyFunction& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_EmergencyFunction& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_EmergencyFunction& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_EmergencyFunction& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_EmergencyFunction& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ID"

    static const int kID = 0;

    /**
     * Clears the field "ID".
     *
     * The field will be set to its default value. The hasID()
     * method will return false.
     */
    inline void clearID();

    /**
     * Checks whether the field "ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setID()). Otherwise it will return false.
     */
    inline bool hasID () const;

    /**
     * Returns the value of the member "ID".
     *
     * <p>identificator of emergency function</p>
     *
     * @return The value of the field "ID"
     */
    inline T_e8_EmergncyFunctionID getID () const;

    /**
     * Sets the value of the member "ID".
     *
     * <p>identificator of emergency function</p>
     *
     * @param ID The value which will be set
     */
    inline void setID (T_e8_EmergncyFunctionID ID_);

    // API of field "State"

    static const int kState = 1;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * <p>the emergency function state</p>
     *
     * @return The value of the field "State"
     */
    inline T_e8_EmergncyFunctionState getState () const;

    /**
     * Sets the value of the member "State".
     *
     * <p>the emergency function state</p>
     *
     * @param State The value which will be set
     */
    inline void setState (T_e8_EmergncyFunctionState State_);

    static const T_EmergencyFunction &getDefaultInstance();

private:

    inline void set_has_ID ();

    inline void clear_has_ID ();

    inline void set_has_State ();

    inline void clear_has_State ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_EmergncyFunctionID _ID;

    T_e8_EmergncyFunctionState _State;

};

/**
 * <p>structure of FAN status information</p>
 */
class T_FAN {
public:

    /**
     * Default constructor
     */
    inline  T_FAN ();

    /**
     * Copy constructor
     */
    inline  T_FAN (const T_FAN &rhs);

    /**
     * All fields constructor
     */
    inline  T_FAN (T_e8_FANPowerState State_, T_u8_FANSpeedValue Speed_, T_u16_FANCurrentValue Current_);

    /**
     * Destructor
     */
    inline  ~T_FAN();

    /**
     * Assignment operator
     */
    inline T_FAN& operator = (const T_FAN& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_FAN& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_FAN& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_FAN& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_FAN& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "State"

    static const int kState = 0;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * <p>FAN power status</p>
     *
     * @return The value of the field "State"
     */
    inline T_e8_FANPowerState getState () const;

    /**
     * Sets the value of the member "State".
     *
     * <p>FAN power status</p>
     *
     * @param State The value which will be set
     */
    inline void setState (T_e8_FANPowerState State_);

    // API of field "Speed"

    static const int kSpeed = 1;

    /**
     * Clears the field "Speed".
     *
     * The field will be set to its default value. The hasSpeed()
     * method will return false.
     */
    inline void clearSpeed();

    /**
     * Checks whether the field "Speed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeed()). Otherwise it will return false.
     */
    inline bool hasSpeed () const;

    /**
     * Returns the value of the member "Speed".
     *
     * <p>FAN speed</p>
     *
     * @return The value of the field "Speed"
     */
    inline T_u8_FANSpeedValue getSpeed () const;

    /**
     * Sets the value of the member "Speed".
     *
     * <p>FAN speed</p>
     *
     * @param Speed The value which will be set
     */
    inline void setSpeed (T_u8_FANSpeedValue Speed_);

    // API of field "Current"

    static const int kCurrent = 2;

    /**
     * Clears the field "Current".
     *
     * The field will be set to its default value. The hasCurrent()
     * method will return false.
     */
    inline void clearCurrent();

    /**
     * Checks whether the field "Current" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrent()). Otherwise it will return false.
     */
    inline bool hasCurrent () const;

    /**
     * Returns the value of the member "Current".
     *
     * <p>FAN load current</p>
     *
     * @return The value of the field "Current"
     */
    inline T_u16_FANCurrentValue getCurrent () const;

    /**
     * Sets the value of the member "Current".
     *
     * <p>FAN load current</p>
     *
     * @param Current The value which will be set
     */
    inline void setCurrent (T_u16_FANCurrentValue Current_);

    static const T_FAN &getDefaultInstance();

private:

    inline void set_has_State ();

    inline void clear_has_State ();

    inline void set_has_Speed ();

    inline void clear_has_Speed ();

    inline void set_has_Current ();

    inline void clear_has_Current ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_e8_FANPowerState _State;

    T_u8_FANSpeedValue _Speed;

    T_u16_FANCurrentValue _Current;

};

/**
 * <p>structure of FAN status request</p>
 */
class T_FANReq {
public:

    /**
     * Default constructor
     */
    inline  T_FANReq ();

    /**
     * Copy constructor
     */
    inline  T_FANReq (const T_FANReq &rhs);

    /**
     * All fields constructor
     */
    inline  T_FANReq (T_e8_FANPowerState State_, T_u8_FANSpeedValue Speed_);

    /**
     * Destructor
     */
    inline  ~T_FANReq();

    /**
     * Assignment operator
     */
    inline T_FANReq& operator = (const T_FANReq& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_FANReq& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_FANReq& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_FANReq& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_FANReq& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "State"

    static const int kState = 0;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * <p>power status of FAN</p>
     *
     * @return The value of the field "State"
     */
    inline T_e8_FANPowerState getState () const;

    /**
     * Sets the value of the member "State".
     *
     * <p>power status of FAN</p>
     *
     * @param State The value which will be set
     */
    inline void setState (T_e8_FANPowerState State_);

    // API of field "Speed"

    static const int kSpeed = 1;

    /**
     * Clears the field "Speed".
     *
     * The field will be set to its default value. The hasSpeed()
     * method will return false.
     */
    inline void clearSpeed();

    /**
     * Checks whether the field "Speed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpeed()). Otherwise it will return false.
     */
    inline bool hasSpeed () const;

    /**
     * Returns the value of the member "Speed".
     *
     * <p>speed of FAN</p>
     *
     * @return The value of the field "Speed"
     */
    inline T_u8_FANSpeedValue getSpeed () const;

    /**
     * Sets the value of the member "Speed".
     *
     * <p>speed of FAN</p>
     *
     * @param Speed The value which will be set
     */
    inline void setSpeed (T_u8_FANSpeedValue Speed_);

    static const T_FANReq &getDefaultInstance();

private:

    inline void set_has_State ();

    inline void clear_has_State ();

    inline void set_has_Speed ();

    inline void clear_has_Speed ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_FANPowerState _State;

    T_u8_FANSpeedValue _Speed;

};

/**
 * <p>structure of required FAN control status</p>
 */
class T_FANCtrl {
public:

    /**
     * Default constructor
     */
    inline  T_FANCtrl ();

    /**
     * Copy constructor
     */
    inline  T_FANCtrl (const T_FANCtrl &rhs);

    /**
     * All fields constructor
     */
    inline  T_FANCtrl (T_e8_FANCtrlMode Mode_);

    /**
     * Destructor
     */
    inline  ~T_FANCtrl();

    /**
     * Assignment operator
     */
    inline T_FANCtrl& operator = (const T_FANCtrl& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_FANCtrl& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_FANCtrl& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_FANCtrl& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_FANCtrl& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Mode"

    static const int kMode = 0;

    /**
     * Clears the field "Mode".
     *
     * The field will be set to its default value. The hasMode()
     * method will return false.
     */
    inline void clearMode();

    /**
     * Checks whether the field "Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMode()). Otherwise it will return false.
     */
    inline bool hasMode () const;

    /**
     * Returns the value of the member "Mode".
     *
     * <p>FAN control mode</p>
     *
     * @return The value of the field "Mode"
     */
    inline T_e8_FANCtrlMode getMode () const;

    /**
     * Sets the value of the member "Mode".
     *
     * <p>FAN control mode</p>
     *
     * @param Mode The value which will be set
     */
    inline void setMode (T_e8_FANCtrlMode Mode_);

    static const T_FANCtrl &getDefaultInstance();

private:

    inline void set_has_Mode ();

    inline void clear_has_Mode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_e8_FANCtrlMode _Mode;

};

/**
 * <p>structure of FAN control status information</p>
 */
class T_FANCtrlReq {
public:

    /**
     * Default constructor
     */
    inline  T_FANCtrlReq ();

    /**
     * Copy constructor
     */
    inline  T_FANCtrlReq (const T_FANCtrlReq &rhs);

    /**
     * All fields constructor
     */
    inline  T_FANCtrlReq (T_e8_FANCtrlEvent Event_);

    /**
     * Destructor
     */
    inline  ~T_FANCtrlReq();

    /**
     * Assignment operator
     */
    inline T_FANCtrlReq& operator = (const T_FANCtrlReq& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_FANCtrlReq& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_FANCtrlReq& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_FANCtrlReq& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_FANCtrlReq& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Event"

    static const int kEvent = 0;

    /**
     * Clears the field "Event".
     *
     * The field will be set to its default value. The hasEvent()
     * method will return false.
     */
    inline void clearEvent();

    /**
     * Checks whether the field "Event" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEvent()). Otherwise it will return false.
     */
    inline bool hasEvent () const;

    /**
     * Returns the value of the member "Event".
     *
     * <p>event to request a FAN control mode</p>
     * <p>---</p>
     * <p>IMPORTANT NOTE:</p>
     * <p>1. In case of required FAN status only please use FC_HEATCTRL_FANCTRLEVENT_DONTCARE.</p>
     * <p>2. You can stop the manual FAN control mode with FC_HEATCTRL_FANCTRLEVENT_MANUAL_END.</p>
     *
     * @return The value of the field "Event"
     */
    inline T_e8_FANCtrlEvent getEvent () const;

    /**
     * Sets the value of the member "Event".
     *
     * <p>event to request a FAN control mode</p>
     * <p>---</p>
     * <p>IMPORTANT NOTE:</p>
     * <p>1. In case of required FAN status only please use FC_HEATCTRL_FANCTRLEVENT_DONTCARE.</p>
     * <p>2. You can stop the manual FAN control mode with FC_HEATCTRL_FANCTRLEVENT_MANUAL_END.</p>
     *
     * @param Event The value which will be set
     */
    inline void setEvent (T_e8_FANCtrlEvent Event_);

    static const T_FANCtrlReq &getDefaultInstance();

private:

    inline void set_has_Event ();

    inline void clear_has_Event ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_e8_FANCtrlEvent _Event;

};

inline  T_SensorTemperature::T_SensorTemperature ()  :
    _ID (::heatctrl_main_fi_types::T_e8_SensorID__FC_HEATCTRL_SENSORID_UNDEF),
    _Temperature (0),
    _Quality (::heatctrl_main_fi_types::T_e8_TemperatureQualityType__FC_HEATCTRL_TEMPQUALITY_INVALID),
    _TemperatureMin (0),
    _TemperatureMax (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SensorTemperature::T_SensorTemperature (const T_SensorTemperature &rhs)  :
    _ID (::heatctrl_main_fi_types::T_e8_SensorID__FC_HEATCTRL_SENSORID_UNDEF),
    _Temperature (0),
    _Quality (::heatctrl_main_fi_types::T_e8_TemperatureQualityType__FC_HEATCTRL_TEMPQUALITY_INVALID),
    _TemperatureMin (0),
    _TemperatureMax (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SensorTemperature::T_SensorTemperature (T_e8_SensorID ID_, T_s16_SensorTemperaturValue Temperature_, T_e8_TemperatureQualityType Quality_, T_s16_SensorTemperaturValue TemperatureMin_, T_s16_SensorTemperaturValue TemperatureMax_)  :
    _ID (ID_),
    _Temperature (Temperature_),
    _Quality (Quality_),
    _TemperatureMin (TemperatureMin_),
    _TemperatureMax (TemperatureMax_)
{
    #ifndef NDEBUG
    if (!(T_e8_SensorID_IsValid(ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ID_, "T_e8_SensorID", "ID", "T_SensorTemperature");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_TemperatureQualityType_IsValid(Quality_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Quality_, "T_e8_TemperatureQualityType", "Quality", "T_SensorTemperature");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SensorTemperature::~T_SensorTemperature() {
}

inline T_SensorTemperature& T_SensorTemperature::operator = (const T_SensorTemperature& rhs) {
    if( this != &rhs ) {
        if (rhs.hasID()) {
            setID(rhs.getID());
        } else {
            clearID();
        }
        if (rhs.hasTemperature()) {
            setTemperature(rhs.getTemperature());
        } else {
            clearTemperature();
        }
        if (rhs.hasQuality()) {
            setQuality(rhs.getQuality());
        } else {
            clearQuality();
        }
        if (rhs.hasTemperatureMin()) {
            setTemperatureMin(rhs.getTemperatureMin());
        } else {
            clearTemperatureMin();
        }
        if (rhs.hasTemperatureMax()) {
            setTemperatureMax(rhs.getTemperatureMax());
        } else {
            clearTemperatureMax();
        }
    }
    return *this;
}

inline bool T_SensorTemperature::operator == (const T_SensorTemperature& rhs) const {
    return (((!hasID() && !rhs.hasID()) || getID() == rhs.getID()) &&
        ((!hasTemperature() && !rhs.hasTemperature()) || getTemperature() == rhs.getTemperature()) &&
        ((!hasQuality() && !rhs.hasQuality()) || getQuality() == rhs.getQuality()) &&
        ((!hasTemperatureMin() && !rhs.hasTemperatureMin()) || getTemperatureMin() == rhs.getTemperatureMin()) &&
        ((!hasTemperatureMax() && !rhs.hasTemperatureMax()) || getTemperatureMax() == rhs.getTemperatureMax()));
}

inline bool T_SensorTemperature::operator != (const T_SensorTemperature& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SensorTemperature::operator < (const T_SensorTemperature& rhs) const {
    if (hasID() || rhs.hasID()) {
        if ((uint32)getID() < (uint32)rhs.getID()) return true;
        if ((uint32)getID() > (uint32)rhs.getID()) return false;
    }
    if (hasTemperature() || rhs.hasTemperature()) {
        if (getTemperature() < rhs.getTemperature()) return true;
        if (getTemperature() > rhs.getTemperature()) return false;
    }
    if (hasQuality() || rhs.hasQuality()) {
        if ((uint32)getQuality() < (uint32)rhs.getQuality()) return true;
        if ((uint32)getQuality() > (uint32)rhs.getQuality()) return false;
    }
    if (hasTemperatureMin() || rhs.hasTemperatureMin()) {
        if (getTemperatureMin() < rhs.getTemperatureMin()) return true;
        if (getTemperatureMin() > rhs.getTemperatureMin()) return false;
    }
    if (hasTemperatureMax() || rhs.hasTemperatureMax()) {
        if (getTemperatureMax() < rhs.getTemperatureMax()) return true;
        if (getTemperatureMax() > rhs.getTemperatureMax()) return false;
    }
    return false;
}

inline bool T_SensorTemperature::operator > (const T_SensorTemperature& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SensorTemperature::clear() {
    clearID();
    clearTemperature();
    clearQuality();
    clearTemperatureMin();
    clearTemperatureMax();
}

inline void T_SensorTemperature::clearID() {
    if (hasID()) {
         clear_has_ID();
        _ID = ::heatctrl_main_fi_types::T_e8_SensorID__FC_HEATCTRL_SENSORID_UNDEF;
     }
}

inline bool T_SensorTemperature::hasID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_SensorID T_SensorTemperature::getID () const {
    return _ID;
}

inline void T_SensorTemperature::setID (T_e8_SensorID ID_) {
    #ifndef NDEBUG
    if (!(T_e8_SensorID_IsValid(ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ID_, "T_e8_SensorID", "ID", "T_SensorTemperature");
    }
    #endif
    set_has_ID();
    this->_ID = ID_;
}

inline void T_SensorTemperature::clearTemperature() {
    if (hasTemperature()) {
         clear_has_Temperature();
        _Temperature = 0;
     }
}

inline bool T_SensorTemperature::hasTemperature () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_s16_SensorTemperaturValue T_SensorTemperature::getTemperature () const {
    return _Temperature;
}

inline void T_SensorTemperature::setTemperature (T_s16_SensorTemperaturValue Temperature_) {
    set_has_Temperature();
    this->_Temperature = Temperature_;
}

inline void T_SensorTemperature::clearQuality() {
    if (hasQuality()) {
         clear_has_Quality();
        _Quality = ::heatctrl_main_fi_types::T_e8_TemperatureQualityType__FC_HEATCTRL_TEMPQUALITY_INVALID;
     }
}

inline bool T_SensorTemperature::hasQuality () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_TemperatureQualityType T_SensorTemperature::getQuality () const {
    return _Quality;
}

inline void T_SensorTemperature::setQuality (T_e8_TemperatureQualityType Quality_) {
    #ifndef NDEBUG
    if (!(T_e8_TemperatureQualityType_IsValid(Quality_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Quality_, "T_e8_TemperatureQualityType", "Quality", "T_SensorTemperature");
    }
    #endif
    set_has_Quality();
    this->_Quality = Quality_;
}

inline void T_SensorTemperature::clearTemperatureMin() {
    if (hasTemperatureMin()) {
         clear_has_TemperatureMin();
        _TemperatureMin = 0;
     }
}

inline bool T_SensorTemperature::hasTemperatureMin () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_s16_SensorTemperaturValue T_SensorTemperature::getTemperatureMin () const {
    return _TemperatureMin;
}

inline void T_SensorTemperature::setTemperatureMin (T_s16_SensorTemperaturValue TemperatureMin_) {
    set_has_TemperatureMin();
    this->_TemperatureMin = TemperatureMin_;
}

inline void T_SensorTemperature::clearTemperatureMax() {
    if (hasTemperatureMax()) {
         clear_has_TemperatureMax();
        _TemperatureMax = 0;
     }
}

inline bool T_SensorTemperature::hasTemperatureMax () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_s16_SensorTemperaturValue T_SensorTemperature::getTemperatureMax () const {
    return _TemperatureMax;
}

inline void T_SensorTemperature::setTemperatureMax (T_s16_SensorTemperaturValue TemperatureMax_) {
    set_has_TemperatureMax();
    this->_TemperatureMax = TemperatureMax_;
}

inline void T_SensorTemperature::set_has_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SensorTemperature::clear_has_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SensorTemperature::set_has_Temperature () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SensorTemperature::clear_has_Temperature () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SensorTemperature::set_has_Quality () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SensorTemperature::clear_has_Quality () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SensorTemperature::set_has_TemperatureMin () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SensorTemperature::clear_has_TemperatureMin () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_SensorTemperature::set_has_TemperatureMax () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_SensorTemperature::clear_has_TemperatureMax () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_SensorState::T_SensorState ()  :
    _ID (::heatctrl_main_fi_types::T_e8_SensorID__FC_HEATCTRL_SENSORID_UNDEF),
    _State (::heatctrl_main_fi_types::T_e8_SensorState__FC_HEATCTRL_UNAVAIL),
    _LastValidState (::heatctrl_main_fi_types::T_e8_SensorState__FC_HEATCTRL_UNAVAIL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SensorState::T_SensorState (const T_SensorState &rhs)  :
    _ID (::heatctrl_main_fi_types::T_e8_SensorID__FC_HEATCTRL_SENSORID_UNDEF),
    _State (::heatctrl_main_fi_types::T_e8_SensorState__FC_HEATCTRL_UNAVAIL),
    _LastValidState (::heatctrl_main_fi_types::T_e8_SensorState__FC_HEATCTRL_UNAVAIL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SensorState::T_SensorState (T_e8_SensorID ID_, T_e8_SensorState State_, T_e8_SensorState LastValidState_)  :
    _ID (ID_),
    _State (State_),
    _LastValidState (LastValidState_)
{
    #ifndef NDEBUG
    if (!(T_e8_SensorID_IsValid(ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ID_, "T_e8_SensorID", "ID", "T_SensorState");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_SensorState_IsValid(State_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", State_, "T_e8_SensorState", "State", "T_SensorState");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_SensorState_IsValid(LastValidState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", LastValidState_, "T_e8_SensorState", "LastValidState", "T_SensorState");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SensorState::~T_SensorState() {
}

inline T_SensorState& T_SensorState::operator = (const T_SensorState& rhs) {
    if( this != &rhs ) {
        if (rhs.hasID()) {
            setID(rhs.getID());
        } else {
            clearID();
        }
        if (rhs.hasState()) {
            setState(rhs.getState());
        } else {
            clearState();
        }
        if (rhs.hasLastValidState()) {
            setLastValidState(rhs.getLastValidState());
        } else {
            clearLastValidState();
        }
    }
    return *this;
}

inline bool T_SensorState::operator == (const T_SensorState& rhs) const {
    return (((!hasID() && !rhs.hasID()) || getID() == rhs.getID()) &&
        ((!hasState() && !rhs.hasState()) || getState() == rhs.getState()) &&
        ((!hasLastValidState() && !rhs.hasLastValidState()) || getLastValidState() == rhs.getLastValidState()));
}

inline bool T_SensorState::operator != (const T_SensorState& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SensorState::operator < (const T_SensorState& rhs) const {
    if (hasID() || rhs.hasID()) {
        if ((uint32)getID() < (uint32)rhs.getID()) return true;
        if ((uint32)getID() > (uint32)rhs.getID()) return false;
    }
    if (hasState() || rhs.hasState()) {
        if ((uint32)getState() < (uint32)rhs.getState()) return true;
        if ((uint32)getState() > (uint32)rhs.getState()) return false;
    }
    if (hasLastValidState() || rhs.hasLastValidState()) {
        if ((uint32)getLastValidState() < (uint32)rhs.getLastValidState()) return true;
        if ((uint32)getLastValidState() > (uint32)rhs.getLastValidState()) return false;
    }
    return false;
}

inline bool T_SensorState::operator > (const T_SensorState& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SensorState::clear() {
    clearID();
    clearState();
    clearLastValidState();
}

inline void T_SensorState::clearID() {
    if (hasID()) {
         clear_has_ID();
        _ID = ::heatctrl_main_fi_types::T_e8_SensorID__FC_HEATCTRL_SENSORID_UNDEF;
     }
}

inline bool T_SensorState::hasID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_SensorID T_SensorState::getID () const {
    return _ID;
}

inline void T_SensorState::setID (T_e8_SensorID ID_) {
    #ifndef NDEBUG
    if (!(T_e8_SensorID_IsValid(ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ID_, "T_e8_SensorID", "ID", "T_SensorState");
    }
    #endif
    set_has_ID();
    this->_ID = ID_;
}

inline void T_SensorState::clearState() {
    if (hasState()) {
         clear_has_State();
        _State = ::heatctrl_main_fi_types::T_e8_SensorState__FC_HEATCTRL_UNAVAIL;
     }
}

inline bool T_SensorState::hasState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_SensorState T_SensorState::getState () const {
    return _State;
}

inline void T_SensorState::setState (T_e8_SensorState State_) {
    #ifndef NDEBUG
    if (!(T_e8_SensorState_IsValid(State_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", State_, "T_e8_SensorState", "State", "T_SensorState");
    }
    #endif
    set_has_State();
    this->_State = State_;
}

inline void T_SensorState::clearLastValidState() {
    if (hasLastValidState()) {
         clear_has_LastValidState();
        _LastValidState = ::heatctrl_main_fi_types::T_e8_SensorState__FC_HEATCTRL_UNAVAIL;
     }
}

inline bool T_SensorState::hasLastValidState () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_SensorState T_SensorState::getLastValidState () const {
    return _LastValidState;
}

inline void T_SensorState::setLastValidState (T_e8_SensorState LastValidState_) {
    #ifndef NDEBUG
    if (!(T_e8_SensorState_IsValid(LastValidState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", LastValidState_, "T_e8_SensorState", "LastValidState", "T_SensorState");
    }
    #endif
    set_has_LastValidState();
    this->_LastValidState = LastValidState_;
}

inline void T_SensorState::set_has_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SensorState::clear_has_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SensorState::set_has_State () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SensorState::clear_has_State () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SensorState::set_has_LastValidState () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SensorState::clear_has_LastValidState () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_EmergencyFunction::T_EmergencyFunction ()  :
    _ID (::heatctrl_main_fi_types::T_e8_EmergncyFunctionID__FC_HEATCTRL_EMERGENCYFUNCTION_SYSTEMSHUTDOWN),
    _State (::heatctrl_main_fi_types::T_e8_EmergncyFunctionState__FC_HEATCTRL_EMERGENCYFUNCTION_STATE_NORESULT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_EmergencyFunction::T_EmergencyFunction (const T_EmergencyFunction &rhs)  :
    _ID (::heatctrl_main_fi_types::T_e8_EmergncyFunctionID__FC_HEATCTRL_EMERGENCYFUNCTION_SYSTEMSHUTDOWN),
    _State (::heatctrl_main_fi_types::T_e8_EmergncyFunctionState__FC_HEATCTRL_EMERGENCYFUNCTION_STATE_NORESULT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_EmergencyFunction::T_EmergencyFunction (T_e8_EmergncyFunctionID ID_, T_e8_EmergncyFunctionState State_)  :
    _ID (ID_),
    _State (State_)
{
    #ifndef NDEBUG
    if (!(T_e8_EmergncyFunctionID_IsValid(ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ID_, "T_e8_EmergncyFunctionID", "ID", "T_EmergencyFunction");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_EmergncyFunctionState_IsValid(State_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", State_, "T_e8_EmergncyFunctionState", "State", "T_EmergencyFunction");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_EmergencyFunction::~T_EmergencyFunction() {
}

inline T_EmergencyFunction& T_EmergencyFunction::operator = (const T_EmergencyFunction& rhs) {
    if( this != &rhs ) {
        if (rhs.hasID()) {
            setID(rhs.getID());
        } else {
            clearID();
        }
        if (rhs.hasState()) {
            setState(rhs.getState());
        } else {
            clearState();
        }
    }
    return *this;
}

inline bool T_EmergencyFunction::operator == (const T_EmergencyFunction& rhs) const {
    return (((!hasID() && !rhs.hasID()) || getID() == rhs.getID()) &&
        ((!hasState() && !rhs.hasState()) || getState() == rhs.getState()));
}

inline bool T_EmergencyFunction::operator != (const T_EmergencyFunction& rhs) const {
    return ! (*this == rhs);
}

inline bool T_EmergencyFunction::operator < (const T_EmergencyFunction& rhs) const {
    if (hasID() || rhs.hasID()) {
        if ((uint32)getID() < (uint32)rhs.getID()) return true;
        if ((uint32)getID() > (uint32)rhs.getID()) return false;
    }
    if (hasState() || rhs.hasState()) {
        if ((uint32)getState() < (uint32)rhs.getState()) return true;
        if ((uint32)getState() > (uint32)rhs.getState()) return false;
    }
    return false;
}

inline bool T_EmergencyFunction::operator > (const T_EmergencyFunction& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_EmergencyFunction::clear() {
    clearID();
    clearState();
}

inline void T_EmergencyFunction::clearID() {
    if (hasID()) {
         clear_has_ID();
        _ID = ::heatctrl_main_fi_types::T_e8_EmergncyFunctionID__FC_HEATCTRL_EMERGENCYFUNCTION_SYSTEMSHUTDOWN;
     }
}

inline bool T_EmergencyFunction::hasID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_EmergncyFunctionID T_EmergencyFunction::getID () const {
    return _ID;
}

inline void T_EmergencyFunction::setID (T_e8_EmergncyFunctionID ID_) {
    #ifndef NDEBUG
    if (!(T_e8_EmergncyFunctionID_IsValid(ID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ID_, "T_e8_EmergncyFunctionID", "ID", "T_EmergencyFunction");
    }
    #endif
    set_has_ID();
    this->_ID = ID_;
}

inline void T_EmergencyFunction::clearState() {
    if (hasState()) {
         clear_has_State();
        _State = ::heatctrl_main_fi_types::T_e8_EmergncyFunctionState__FC_HEATCTRL_EMERGENCYFUNCTION_STATE_NORESULT;
     }
}

inline bool T_EmergencyFunction::hasState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_EmergncyFunctionState T_EmergencyFunction::getState () const {
    return _State;
}

inline void T_EmergencyFunction::setState (T_e8_EmergncyFunctionState State_) {
    #ifndef NDEBUG
    if (!(T_e8_EmergncyFunctionState_IsValid(State_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", State_, "T_e8_EmergncyFunctionState", "State", "T_EmergencyFunction");
    }
    #endif
    set_has_State();
    this->_State = State_;
}

inline void T_EmergencyFunction::set_has_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_EmergencyFunction::clear_has_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_EmergencyFunction::set_has_State () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_EmergencyFunction::clear_has_State () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_FAN::T_FAN ()  :
    _State (::heatctrl_main_fi_types::T_e8_FANPowerState__FC_HEATCTRL_FANPWRSTATE_INIT),
    _Speed (0u),
    _Current (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_FAN::T_FAN (const T_FAN &rhs)  :
    _State (::heatctrl_main_fi_types::T_e8_FANPowerState__FC_HEATCTRL_FANPWRSTATE_INIT),
    _Speed (0u),
    _Current (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_FAN::T_FAN (T_e8_FANPowerState State_, T_u8_FANSpeedValue Speed_, T_u16_FANCurrentValue Current_)  :
    _State (State_),
    _Speed (Speed_),
    _Current (Current_)
{
    #ifndef NDEBUG
    if (!(T_e8_FANPowerState_IsValid(State_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", State_, "T_e8_FANPowerState", "State", "T_FAN");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_FAN::~T_FAN() {
}

inline T_FAN& T_FAN::operator = (const T_FAN& rhs) {
    if( this != &rhs ) {
        if (rhs.hasState()) {
            setState(rhs.getState());
        } else {
            clearState();
        }
        if (rhs.hasSpeed()) {
            setSpeed(rhs.getSpeed());
        } else {
            clearSpeed();
        }
        if (rhs.hasCurrent()) {
            setCurrent(rhs.getCurrent());
        } else {
            clearCurrent();
        }
    }
    return *this;
}

inline bool T_FAN::operator == (const T_FAN& rhs) const {
    return (((!hasState() && !rhs.hasState()) || getState() == rhs.getState()) &&
        ((!hasSpeed() && !rhs.hasSpeed()) || getSpeed() == rhs.getSpeed()) &&
        ((!hasCurrent() && !rhs.hasCurrent()) || getCurrent() == rhs.getCurrent()));
}

inline bool T_FAN::operator != (const T_FAN& rhs) const {
    return ! (*this == rhs);
}

inline bool T_FAN::operator < (const T_FAN& rhs) const {
    if (hasState() || rhs.hasState()) {
        if ((uint32)getState() < (uint32)rhs.getState()) return true;
        if ((uint32)getState() > (uint32)rhs.getState()) return false;
    }
    if (hasSpeed() || rhs.hasSpeed()) {
        if (getSpeed() < rhs.getSpeed()) return true;
        if (getSpeed() > rhs.getSpeed()) return false;
    }
    if (hasCurrent() || rhs.hasCurrent()) {
        if (getCurrent() < rhs.getCurrent()) return true;
        if (getCurrent() > rhs.getCurrent()) return false;
    }
    return false;
}

inline bool T_FAN::operator > (const T_FAN& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_FAN::clear() {
    clearState();
    clearSpeed();
    clearCurrent();
}

inline void T_FAN::clearState() {
    if (hasState()) {
         clear_has_State();
        _State = ::heatctrl_main_fi_types::T_e8_FANPowerState__FC_HEATCTRL_FANPWRSTATE_INIT;
     }
}

inline bool T_FAN::hasState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_FANPowerState T_FAN::getState () const {
    return _State;
}

inline void T_FAN::setState (T_e8_FANPowerState State_) {
    #ifndef NDEBUG
    if (!(T_e8_FANPowerState_IsValid(State_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", State_, "T_e8_FANPowerState", "State", "T_FAN");
    }
    #endif
    set_has_State();
    this->_State = State_;
}

inline void T_FAN::clearSpeed() {
    if (hasSpeed()) {
         clear_has_Speed();
        _Speed = 0u;
     }
}

inline bool T_FAN::hasSpeed () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_u8_FANSpeedValue T_FAN::getSpeed () const {
    return _Speed;
}

inline void T_FAN::setSpeed (T_u8_FANSpeedValue Speed_) {
    set_has_Speed();
    this->_Speed = Speed_;
}

inline void T_FAN::clearCurrent() {
    if (hasCurrent()) {
         clear_has_Current();
        _Current = 0u;
     }
}

inline bool T_FAN::hasCurrent () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_u16_FANCurrentValue T_FAN::getCurrent () const {
    return _Current;
}

inline void T_FAN::setCurrent (T_u16_FANCurrentValue Current_) {
    set_has_Current();
    this->_Current = Current_;
}

inline void T_FAN::set_has_State () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_FAN::clear_has_State () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_FAN::set_has_Speed () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_FAN::clear_has_Speed () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_FAN::set_has_Current () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_FAN::clear_has_Current () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_FANReq::T_FANReq ()  :
    _State (::heatctrl_main_fi_types::T_e8_FANPowerState__FC_HEATCTRL_FANPWRSTATE_INIT),
    _Speed (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_FANReq::T_FANReq (const T_FANReq &rhs)  :
    _State (::heatctrl_main_fi_types::T_e8_FANPowerState__FC_HEATCTRL_FANPWRSTATE_INIT),
    _Speed (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_FANReq::T_FANReq (T_e8_FANPowerState State_, T_u8_FANSpeedValue Speed_)  :
    _State (State_),
    _Speed (Speed_)
{
    #ifndef NDEBUG
    if (!(T_e8_FANPowerState_IsValid(State_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", State_, "T_e8_FANPowerState", "State", "T_FANReq");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_FANReq::~T_FANReq() {
}

inline T_FANReq& T_FANReq::operator = (const T_FANReq& rhs) {
    if( this != &rhs ) {
        if (rhs.hasState()) {
            setState(rhs.getState());
        } else {
            clearState();
        }
        if (rhs.hasSpeed()) {
            setSpeed(rhs.getSpeed());
        } else {
            clearSpeed();
        }
    }
    return *this;
}

inline bool T_FANReq::operator == (const T_FANReq& rhs) const {
    return (((!hasState() && !rhs.hasState()) || getState() == rhs.getState()) &&
        ((!hasSpeed() && !rhs.hasSpeed()) || getSpeed() == rhs.getSpeed()));
}

inline bool T_FANReq::operator != (const T_FANReq& rhs) const {
    return ! (*this == rhs);
}

inline bool T_FANReq::operator < (const T_FANReq& rhs) const {
    if (hasState() || rhs.hasState()) {
        if ((uint32)getState() < (uint32)rhs.getState()) return true;
        if ((uint32)getState() > (uint32)rhs.getState()) return false;
    }
    if (hasSpeed() || rhs.hasSpeed()) {
        if (getSpeed() < rhs.getSpeed()) return true;
        if (getSpeed() > rhs.getSpeed()) return false;
    }
    return false;
}

inline bool T_FANReq::operator > (const T_FANReq& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_FANReq::clear() {
    clearState();
    clearSpeed();
}

inline void T_FANReq::clearState() {
    if (hasState()) {
         clear_has_State();
        _State = ::heatctrl_main_fi_types::T_e8_FANPowerState__FC_HEATCTRL_FANPWRSTATE_INIT;
     }
}

inline bool T_FANReq::hasState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_FANPowerState T_FANReq::getState () const {
    return _State;
}

inline void T_FANReq::setState (T_e8_FANPowerState State_) {
    #ifndef NDEBUG
    if (!(T_e8_FANPowerState_IsValid(State_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", State_, "T_e8_FANPowerState", "State", "T_FANReq");
    }
    #endif
    set_has_State();
    this->_State = State_;
}

inline void T_FANReq::clearSpeed() {
    if (hasSpeed()) {
         clear_has_Speed();
        _Speed = 0u;
     }
}

inline bool T_FANReq::hasSpeed () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_u8_FANSpeedValue T_FANReq::getSpeed () const {
    return _Speed;
}

inline void T_FANReq::setSpeed (T_u8_FANSpeedValue Speed_) {
    set_has_Speed();
    this->_Speed = Speed_;
}

inline void T_FANReq::set_has_State () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_FANReq::clear_has_State () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_FANReq::set_has_Speed () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_FANReq::clear_has_Speed () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_FANCtrl::T_FANCtrl ()  :
    _Mode (::heatctrl_main_fi_types::T_e8_FANCtrlMode__FC_HEATCTRL_FANCTRLMODE_INIT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_FANCtrl::T_FANCtrl (const T_FANCtrl &rhs)  :
    _Mode (::heatctrl_main_fi_types::T_e8_FANCtrlMode__FC_HEATCTRL_FANCTRLMODE_INIT)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_FANCtrl::T_FANCtrl (T_e8_FANCtrlMode Mode_)  :
    _Mode (Mode_)
{
    #ifndef NDEBUG
    if (!(T_e8_FANCtrlMode_IsValid(Mode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Mode_, "T_e8_FANCtrlMode", "Mode", "T_FANCtrl");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_FANCtrl::~T_FANCtrl() {
}

inline T_FANCtrl& T_FANCtrl::operator = (const T_FANCtrl& rhs) {
    if( this != &rhs ) {
        if (rhs.hasMode()) {
            setMode(rhs.getMode());
        } else {
            clearMode();
        }
    }
    return *this;
}

inline bool T_FANCtrl::operator == (const T_FANCtrl& rhs) const {
    return (((!hasMode() && !rhs.hasMode()) || getMode() == rhs.getMode()));
}

inline bool T_FANCtrl::operator != (const T_FANCtrl& rhs) const {
    return ! (*this == rhs);
}

inline bool T_FANCtrl::operator < (const T_FANCtrl& rhs) const {
    if (hasMode() || rhs.hasMode()) {
        if ((uint32)getMode() < (uint32)rhs.getMode()) return true;
        if ((uint32)getMode() > (uint32)rhs.getMode()) return false;
    }
    return false;
}

inline bool T_FANCtrl::operator > (const T_FANCtrl& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_FANCtrl::clear() {
    clearMode();
}

inline void T_FANCtrl::clearMode() {
    if (hasMode()) {
         clear_has_Mode();
        _Mode = ::heatctrl_main_fi_types::T_e8_FANCtrlMode__FC_HEATCTRL_FANCTRLMODE_INIT;
     }
}

inline bool T_FANCtrl::hasMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_FANCtrlMode T_FANCtrl::getMode () const {
    return _Mode;
}

inline void T_FANCtrl::setMode (T_e8_FANCtrlMode Mode_) {
    #ifndef NDEBUG
    if (!(T_e8_FANCtrlMode_IsValid(Mode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Mode_, "T_e8_FANCtrlMode", "Mode", "T_FANCtrl");
    }
    #endif
    set_has_Mode();
    this->_Mode = Mode_;
}

inline void T_FANCtrl::set_has_Mode () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_FANCtrl::clear_has_Mode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  T_FANCtrlReq::T_FANCtrlReq ()  :
    _Event (::heatctrl_main_fi_types::T_e8_FANCtrlEvent__FC_HEATCTRL_FANCTRLEVENT_MANUAL_END)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_FANCtrlReq::T_FANCtrlReq (const T_FANCtrlReq &rhs)  :
    _Event (::heatctrl_main_fi_types::T_e8_FANCtrlEvent__FC_HEATCTRL_FANCTRLEVENT_MANUAL_END)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_FANCtrlReq::T_FANCtrlReq (T_e8_FANCtrlEvent Event_)  :
    _Event (Event_)
{
    #ifndef NDEBUG
    if (!(T_e8_FANCtrlEvent_IsValid(Event_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Event_, "T_e8_FANCtrlEvent", "Event", "T_FANCtrlReq");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_FANCtrlReq::~T_FANCtrlReq() {
}

inline T_FANCtrlReq& T_FANCtrlReq::operator = (const T_FANCtrlReq& rhs) {
    if( this != &rhs ) {
        if (rhs.hasEvent()) {
            setEvent(rhs.getEvent());
        } else {
            clearEvent();
        }
    }
    return *this;
}

inline bool T_FANCtrlReq::operator == (const T_FANCtrlReq& rhs) const {
    return (((!hasEvent() && !rhs.hasEvent()) || getEvent() == rhs.getEvent()));
}

inline bool T_FANCtrlReq::operator != (const T_FANCtrlReq& rhs) const {
    return ! (*this == rhs);
}

inline bool T_FANCtrlReq::operator < (const T_FANCtrlReq& rhs) const {
    if (hasEvent() || rhs.hasEvent()) {
        if ((uint32)getEvent() < (uint32)rhs.getEvent()) return true;
        if ((uint32)getEvent() > (uint32)rhs.getEvent()) return false;
    }
    return false;
}

inline bool T_FANCtrlReq::operator > (const T_FANCtrlReq& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_FANCtrlReq::clear() {
    clearEvent();
}

inline void T_FANCtrlReq::clearEvent() {
    if (hasEvent()) {
         clear_has_Event();
        _Event = ::heatctrl_main_fi_types::T_e8_FANCtrlEvent__FC_HEATCTRL_FANCTRLEVENT_MANUAL_END;
     }
}

inline bool T_FANCtrlReq::hasEvent () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_FANCtrlEvent T_FANCtrlReq::getEvent () const {
    return _Event;
}

inline void T_FANCtrlReq::setEvent (T_e8_FANCtrlEvent Event_) {
    #ifndef NDEBUG
    if (!(T_e8_FANCtrlEvent_IsValid(Event_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Event_, "T_e8_FANCtrlEvent", "Event", "T_FANCtrlReq");
    }
    #endif
    set_has_Event();
    this->_Event = Event_;
}

inline void T_FANCtrlReq::set_has_Event () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_FANCtrlReq::clear_has_Event () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace heatctrl_main_fi_types

#endif // HEATCTRL_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
