/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef HEATCTRL_MAIN_FIPROXY_H
#define HEATCTRL_MAIN_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "heatctrl_main_fi.h"
#include "heatctrl_main_fi_types.h"

namespace heatctrl_main_fi {

class Heatctrl_main_fiProxy;

class AbstractSensorStatesCallbackIF {
public:
    virtual ~AbstractSensorStatesCallbackIF() {}

    virtual void onAbstractSensorStatesError(const ::boost::shared_ptr< Heatctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< AbstractSensorStatesError >& error) = 0;

    virtual void onAbstractSensorStatesStatus(const ::boost::shared_ptr< Heatctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< AbstractSensorStatesStatus >& status) = 0;
};

class AbstractSensorTemperaturesCallbackIF {
public:
    virtual ~AbstractSensorTemperaturesCallbackIF() {}

    virtual void onAbstractSensorTemperaturesError(const ::boost::shared_ptr< Heatctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< AbstractSensorTemperaturesError >& error) = 0;

    virtual void onAbstractSensorTemperaturesStatus(const ::boost::shared_ptr< Heatctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< AbstractSensorTemperaturesStatus >& status) = 0;
};

class EmergencyFunctionsCallbackIF {
public:
    virtual ~EmergencyFunctionsCallbackIF() {}

    virtual void onEmergencyFunctionsError(const ::boost::shared_ptr< Heatctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< EmergencyFunctionsError >& error) = 0;

    virtual void onEmergencyFunctionsStatus(const ::boost::shared_ptr< Heatctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< EmergencyFunctionsStatus >& status) = 0;
};

class FANControlCallbackIF {
public:
    virtual ~FANControlCallbackIF() {}

    virtual void onFANControlError(const ::boost::shared_ptr< Heatctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< FANControlError >& error) = 0;

    virtual void onFANControlStatus(const ::boost::shared_ptr< Heatctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< FANControlStatus >& status) = 0;
};

class FI_FC_HEATCTRL_DEFAULTCallbackIF {
public:
    virtual ~FI_FC_HEATCTRL_DEFAULTCallbackIF() {}

    virtual void onFI_FC_HEATCTRL_DEFAULTError(const ::boost::shared_ptr< Heatctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< FI_FC_HEATCTRL_DEFAULTError >& error) = 0;

    virtual void onFI_FC_HEATCTRL_DEFAULTResult(const ::boost::shared_ptr< Heatctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< FI_FC_HEATCTRL_DEFAULTResult >& result) = 0;
};

class RealSensorStatesCallbackIF {
public:
    virtual ~RealSensorStatesCallbackIF() {}

    virtual void onRealSensorStatesError(const ::boost::shared_ptr< Heatctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< RealSensorStatesError >& error) = 0;

    virtual void onRealSensorStatesStatus(const ::boost::shared_ptr< Heatctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< RealSensorStatesStatus >& status) = 0;
};

class RealSensorTemperaturesCallbackIF {
public:
    virtual ~RealSensorTemperaturesCallbackIF() {}

    virtual void onRealSensorTemperaturesError(const ::boost::shared_ptr< Heatctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< RealSensorTemperaturesError >& error) = 0;

    virtual void onRealSensorTemperaturesStatus(const ::boost::shared_ptr< Heatctrl_main_fiProxy >& proxy, const ::boost::shared_ptr< RealSensorTemperaturesStatus >& status) = 0;
};

class Heatctrl_main_fiProxyCallback;

/**
 * Heatctrl_main_fiProxy is the client side representation of the CCA
 * Functional Interface 'heatctrl_main_fi' (specified in file
 * heatctrl_main_fi.xml).
 *
 * CCA Functional Interface 'heatctrl_main_fi'
 *
 * Fullname: Heat Control CCA Service, Application Functional Interface
 *
 * Version: $Revision:   1.4.1  $
 *
 * Author: Andrï¿½ Bernard (bne2hi) CM-CI1/ERN2-E
 *
 * Date: $Date:  02.12.2017  $
 *
 * Department:
 *
 * Title: heatctrl_fi
 *
 * <b>Description of 'heatctrl_main_fi':</b>
 *
 * FC_HeatCtrl messages for CCA applications
 */
class Heatctrl_main_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Heatctrl_main_fiProxy. The caller has to pass
     * the port name and the service information. It is only possible to use
     * this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Heatctrl_main_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Heatctrl_main_fiProxy. The caller has to pass
     * the port name and the service information. It is only possible to use
     * this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Heatctrl_main_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Heatctrl_main_fiProxy. The caller has to pass
     * the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Heatctrl_main_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Heatctrl_main_fiProxy. The destructor will send RelUpReg
     * messages for all property notifications and call the error callback of
     * all pending method invocations.
     */
    ~Heatctrl_main_fiProxy();

    // Method 'FI_FC_HEATCTRL_DEFAULT'

    /**
     * Call the method 'FI_FC_HEATCTRL_DEFAULT'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'FI_FC_HEATCTRL_DEFAULT'</b>:
     *
     * <p>FC_HEATCTRL has to support a default setting. This is the Functional Interface for this.</p>
     * <p>Attention:</p>
     * <p>In FI V1.0 FI "DefSetStateGroup" is of type="T_e8_DefSetGroups"!</p>
     * <p>In FI V1.0 FI "DefSetStateMode"  is of type="T_e8_DefSetMode"!</p>
     * <p>Both types are replaced by an tU8 to get rid of all the diag-types in this FI document starting with V2.0!</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DefaultSettingsGroup relevant value: midw_fi_tcl_e8_DiagDefSetGroups::FI_EN_DEFSET_GROUP__MAINTENANCE
     *
     * @param DefaultSettingsMode relevant value: midw_fi_tcl_e8_DefSetMode::FI_EN_DEFSET_SRC_CODING
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFI_FC_HEATCTRL_DEFAULTStart(FI_FC_HEATCTRL_DEFAULTCallbackIF& cb, uint8 defaultSettingsGroup, uint8 defaultSettingsMode);

    // Property 'RealSensorTemperatures'

    /**
     * Notify on the property 'RealSensorTemperatures'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'RealSensorTemperatures'</b>:
     *
     * <p>Detected temperatures of real thermal sensors.</p>
     * <p>---</p>
     * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
     * FUNCID    = HEATCTRL_MAINFI_C_U16_REALSENSORTEMPERATURES,
     * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
     * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
     * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRealSensorTemperaturesUpReg(RealSensorTemperaturesCallbackIF& cb);

    /**
     * Remove the notifcation on property 'RealSensorTemperatures'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'RealSensorTemperatures'</b>:
     *
     * <p>Detected temperatures of real thermal sensors.</p>
     * <p>---</p>
     * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
     * FUNCID    = HEATCTRL_MAINFI_C_U16_REALSENSORTEMPERATURES,
     * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
     * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
     * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
     *
     * @param act The act which was previously returned by the
     * sendRealSensorTemperaturesUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendRealSensorTemperaturesRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'RealSensorTemperatures'.
     */
    void sendRealSensorTemperaturesRelUpRegAll ();

    /**
     * Returns the current value of the property 'RealSensorTemperatures' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasRealSensorTemperatures() returns true.
     *
     * @return the previously received value of the property 'RealSensorTemperatures'.
     */
    const RealSensorTemperaturesStatus& getRealSensorTemperatures() const;

    /**
     * Determines whether a status message for the property 'RealSensorTemperatures' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRealSensorTemperatures() const;

    /**
     * Request the value of the property 'RealSensorTemperatures' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'RealSensorTemperatures'</b>:
     *
     * <p>Detected temperatures of real thermal sensors.</p>
     * <p>---</p>
     * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
     * FUNCID    = HEATCTRL_MAINFI_C_U16_REALSENSORTEMPERATURES,
     * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
     * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
     * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRealSensorTemperaturesGet(RealSensorTemperaturesCallbackIF& cb);

    // Property 'RealSensorStates'

    /**
     * Notify on the property 'RealSensorStates'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'RealSensorStates'</b>:
     *
     * <p>Thermal states depending on detected temperatures of real thermal sensors.</p>
     * <p>Additional the MAIN thermal state is provided, too!</p>
     * <p>---</p>
     * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
     * FUNCID    = HEATCTRL_MAINFI_C_U16_REALSENSORSTATES,
     * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
     * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
     * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRealSensorStatesUpReg(RealSensorStatesCallbackIF& cb);

    /**
     * Remove the notifcation on property 'RealSensorStates'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'RealSensorStates'</b>:
     *
     * <p>Thermal states depending on detected temperatures of real thermal sensors.</p>
     * <p>Additional the MAIN thermal state is provided, too!</p>
     * <p>---</p>
     * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
     * FUNCID    = HEATCTRL_MAINFI_C_U16_REALSENSORSTATES,
     * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
     * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
     * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
     *
     * @param act The act which was previously returned by the
     * sendRealSensorStatesUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendRealSensorStatesRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'RealSensorStates'.
     */
    void sendRealSensorStatesRelUpRegAll ();

    /**
     * Returns the current value of the property 'RealSensorStates' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasRealSensorStates() returns true.
     *
     * @return the previously received value of the property 'RealSensorStates'.
     */
    const RealSensorStatesStatus& getRealSensorStates() const;

    /**
     * Determines whether a status message for the property 'RealSensorStates' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRealSensorStates() const;

    /**
     * Request the value of the property 'RealSensorStates' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'RealSensorStates'</b>:
     *
     * <p>Thermal states depending on detected temperatures of real thermal sensors.</p>
     * <p>Additional the MAIN thermal state is provided, too!</p>
     * <p>---</p>
     * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
     * FUNCID    = HEATCTRL_MAINFI_C_U16_REALSENSORSTATES,
     * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
     * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
     * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRealSensorStatesGet(RealSensorStatesCallbackIF& cb);

    // Property 'AbstractSensorTemperatures'

    /**
     * Notify on the property 'AbstractSensorTemperatures'. This method sends
     * a UpReg message to the CCA server.
     *
     * <b>Documentation of 'AbstractSensorTemperatures'</b>:
     *
     * <p>temperatures of abstracted thermal sensors realized by real thermal sensors.</p>
     * <p>---</p>
     * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
     * FUNCID    = HEATCTRL_MAINFI_C_U16_ABSTRACTSENSORTEMPERATURES,
     * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
     * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
     * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAbstractSensorTemperaturesUpReg(AbstractSensorTemperaturesCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AbstractSensorTemperatures'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AbstractSensorTemperatures'</b>:
     *
     * <p>temperatures of abstracted thermal sensors realized by real thermal sensors.</p>
     * <p>---</p>
     * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
     * FUNCID    = HEATCTRL_MAINFI_C_U16_ABSTRACTSENSORTEMPERATURES,
     * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
     * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
     * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
     *
     * @param act The act which was previously returned by the
     * sendAbstractSensorTemperaturesUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAbstractSensorTemperaturesRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AbstractSensorTemperatures'.
     */
    void sendAbstractSensorTemperaturesRelUpRegAll ();

    /**
     * Returns the current value of the property 'AbstractSensorTemperatures'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasAbstractSensorTemperatures() returns true.
     *
     * @return the previously received value of the property 'AbstractSensorTemperatures'.
     */
    const AbstractSensorTemperaturesStatus& getAbstractSensorTemperatures() const;

    /**
     * Determines whether a status message for the property 'AbstractSensorTemperatures' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAbstractSensorTemperatures() const;

    /**
     * Request the value of the property 'AbstractSensorTemperatures' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'AbstractSensorTemperatures'</b>:
     *
     * <p>temperatures of abstracted thermal sensors realized by real thermal sensors.</p>
     * <p>---</p>
     * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
     * FUNCID    = HEATCTRL_MAINFI_C_U16_ABSTRACTSENSORTEMPERATURES,
     * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
     * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
     * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAbstractSensorTemperaturesGet(AbstractSensorTemperaturesCallbackIF& cb);

    // Property 'AbstractSensorStates'

    /**
     * Notify on the property 'AbstractSensorStates'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'AbstractSensorStates'</b>:
     *
     * <p>All abstract thermal states depending on realized thermal sensors states.</p>
     * <p>Additional the MAIN thermal state is provided, too!</p>
     * <p>---</p>
     * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
     * FUNCID    = HEATCTRL_MAINFI_C_U16_ABSTRACTSENSORSTATES,
     * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
     * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
     * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAbstractSensorStatesUpReg(AbstractSensorStatesCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AbstractSensorStates'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AbstractSensorStates'</b>:
     *
     * <p>All abstract thermal states depending on realized thermal sensors states.</p>
     * <p>Additional the MAIN thermal state is provided, too!</p>
     * <p>---</p>
     * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
     * FUNCID    = HEATCTRL_MAINFI_C_U16_ABSTRACTSENSORSTATES,
     * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
     * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
     * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
     *
     * @param act The act which was previously returned by the
     * sendAbstractSensorStatesUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAbstractSensorStatesRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AbstractSensorStates'.
     */
    void sendAbstractSensorStatesRelUpRegAll ();

    /**
     * Returns the current value of the property 'AbstractSensorStates' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasAbstractSensorStates() returns true.
     *
     * @return the previously received value of the property 'AbstractSensorStates'.
     */
    const AbstractSensorStatesStatus& getAbstractSensorStates() const;

    /**
     * Determines whether a status message for the property 'AbstractSensorStates' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAbstractSensorStates() const;

    /**
     * Request the value of the property 'AbstractSensorStates' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'AbstractSensorStates'</b>:
     *
     * <p>All abstract thermal states depending on realized thermal sensors states.</p>
     * <p>Additional the MAIN thermal state is provided, too!</p>
     * <p>---</p>
     * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
     * FUNCID    = HEATCTRL_MAINFI_C_U16_ABSTRACTSENSORSTATES,
     * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
     * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
     * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAbstractSensorStatesGet(AbstractSensorStatesCallbackIF& cb);

    // Property 'EmergencyFunctions'

    /**
     * Notify on the property 'EmergencyFunctions'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'EmergencyFunctions'</b>:
     *
     * <p>State information of all supported emergency functions.</p>
     * <p>---</p>
     * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
     * FUNCID    = HEATCTRL_MAINFI_C_U16_EMERGENCYFUNCTIONS,
     * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
     * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
     * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEmergencyFunctionsUpReg(EmergencyFunctionsCallbackIF& cb);

    /**
     * Remove the notifcation on property 'EmergencyFunctions'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'EmergencyFunctions'</b>:
     *
     * <p>State information of all supported emergency functions.</p>
     * <p>---</p>
     * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
     * FUNCID    = HEATCTRL_MAINFI_C_U16_EMERGENCYFUNCTIONS,
     * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
     * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
     * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
     *
     * @param act The act which was previously returned by the
     * sendEmergencyFunctionsUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendEmergencyFunctionsRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'EmergencyFunctions'.
     */
    void sendEmergencyFunctionsRelUpRegAll ();

    /**
     * Returns the current value of the property 'EmergencyFunctions' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasEmergencyFunctions() returns true.
     *
     * @return the previously received value of the property 'EmergencyFunctions'.
     */
    const EmergencyFunctionsStatus& getEmergencyFunctions() const;

    /**
     * Determines whether a status message for the property 'EmergencyFunctions' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasEmergencyFunctions() const;

    /**
     * Request the value of the property 'EmergencyFunctions' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'EmergencyFunctions'</b>:
     *
     * <p>State information of all supported emergency functions.</p>
     * <p>---</p>
     * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
     * FUNCID    = HEATCTRL_MAINFI_C_U16_EMERGENCYFUNCTIONS,
     * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
     * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
     * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEmergencyFunctionsGet(EmergencyFunctionsCallbackIF& cb);

    // Property 'FANControl'

    /**
     * Notify on the property 'FANControl'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'FANControl'</b>:
     *
     * <p>All state information of optional FAN</p>
     * <p></p>
     * <p>A CCA application (e.g.: DIAGNOSIS) should use the following parameters,</p>
     * FUNCID    = HEATCTRL_MAINFI_C_U16_FANCONTROL,
     * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
     * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
     * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_FC_DIAGNOSIS)
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFANControlUpReg(FANControlCallbackIF& cb);

    /**
     * Remove the notifcation on property 'FANControl'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'FANControl'</b>:
     *
     * <p>All state information of optional FAN</p>
     * <p></p>
     * <p>A CCA application (e.g.: DIAGNOSIS) should use the following parameters,</p>
     * FUNCID    = HEATCTRL_MAINFI_C_U16_FANCONTROL,
     * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
     * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
     * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_FC_DIAGNOSIS)
     *
     * @param act The act which was previously returned by the
     * sendFANControlUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendFANControlRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'FANControl'.
     */
    void sendFANControlRelUpRegAll ();

    /**
     * Returns the current value of the property 'FANControl' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasFANControl() returns true.
     *
     * @return the previously received value of the property 'FANControl'.
     */
    const FANControlStatus& getFANControl() const;

    /**
     * Determines whether a status message for the property 'FANControl' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFANControl() const;

    /**
     * Request the value of the property 'FANControl' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'FANControl'</b>:
     *
     * <p>All state information of optional FAN</p>
     * <p></p>
     * <p>A CCA application (e.g.: DIAGNOSIS) should use the following parameters,</p>
     * FUNCID    = HEATCTRL_MAINFI_C_U16_FANCONTROL,
     * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
     * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
     * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_FC_DIAGNOSIS)
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFANControlGet(FANControlCallbackIF& cb);

    /**
     * Set the value of the property 'FANControl'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'FANControl'</b>:
     *
     * <p>All state information of optional FAN</p>
     * <p></p>
     * <p>A CCA application (e.g.: DIAGNOSIS) should use the following parameters,</p>
     * FUNCID    = HEATCTRL_MAINFI_C_U16_FANCONTROL,
     * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
     * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
     * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_FC_DIAGNOSIS)
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param FAN <p>Required FAN status.</p>
     *
     * @param FANCtrl <p>Required FAN control status.</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFANControlSet(FANControlCallbackIF& cb, const ::heatctrl_main_fi_types::T_FANReq& fAN, const ::heatctrl_main_fi_types::T_FANCtrlReq& fANCtrl);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Heatctrl_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'RealSensorTemperatures'

    ::asf::core::nullable< RealSensorTemperaturesStatus > _realSensorTemperatures;

    // Property 'RealSensorStates'

    ::asf::core::nullable< RealSensorStatesStatus > _realSensorStates;

    // Property 'AbstractSensorTemperatures'

    ::asf::core::nullable< AbstractSensorTemperaturesStatus > _abstractSensorTemperatures;

    // Property 'AbstractSensorStates'

    ::asf::core::nullable< AbstractSensorStatesStatus > _abstractSensorStates;

    // Property 'EmergencyFunctions'

    ::asf::core::nullable< EmergencyFunctionsStatus > _emergencyFunctions;

    // Property 'FANControl'

    ::asf::core::nullable< FANControlStatus > _fANControl;

    DECLARE_CLASS_LOGGER();

    friend class Heatctrl_main_fiProxyCallback;
};

} // namespace heatctrl_main_fi

#endif // HEATCTRL_MAIN_FIPROXY_H
