#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef HEATCTRL_MAIN_FI_H
#define HEATCTRL_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "heatctrl_main_fi_types.h"
#include <cstring>
#include <vector>

/**
 * CCA Functional Interface 'heatctrl_main_fi'
 *
 * Fullname: Heat Control CCA Service, Application Functional Interface
 *
 * Version: $Revision:   1.4.1  $
 *
 * Author: Andrï¿½ Bernard (bne2hi) CM-CI1/ERN2-E
 *
 * Date: $Date:  02.12.2017  $
 *
 * Department:
 *
 * Title: heatctrl_fi
 *
 * <b>Description of 'heatctrl_main_fi':</b>
 *
 * FC_HeatCtrl messages for CCA applications
 */

namespace heatctrl_main_fi {

static const int SERVICE_ID = 42;

static const int FID_RealSensorTemperatures = 32785;

static const int FID_RealSensorStates = 32786;

static const int FID_AbstractSensorTemperatures = 32787;

static const int FID_AbstractSensorStates = 32788;

static const int FID_EmergencyFunctions = 32789;

static const int FID_FANControl = 32801;

static const int FID_FI_FC_HEATCTRL_DEFAULT = 28673;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 4;

static const int VERSION_PATCH = 0;

// forward declarations
class RealSensorTemperaturesStatus;

class RealSensorTemperaturesErrorStructure;

class RealSensorTemperaturesError;

class RealSensorStatesStatus;

class RealSensorStatesErrorStructure;

class RealSensorStatesError;

class AbstractSensorTemperaturesStatus;

class AbstractSensorTemperaturesErrorStructure;

class AbstractSensorTemperaturesError;

class AbstractSensorStatesStatus;

class AbstractSensorStatesErrorStructure;

class AbstractSensorStatesError;

class EmergencyFunctionsStatus;

class EmergencyFunctionsErrorStructure;

class EmergencyFunctionsError;

class FANControlStatus;

class FANControlSet;

class FANControlErrorStructure;

class FANControlError;

class FI_FC_HEATCTRL_DEFAULTStart;

class FI_FC_HEATCTRL_DEFAULTResult;

// type definitions
/**
 * The get message of the property "RealSensorTemperatures"
 * <p>Detected temperatures of real thermal sensors.</p>
 * <p>---</p>
 * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_REALSENSORTEMPERATURES,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
 * Answers with temperature status message to requestor.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RealSensorTemperaturesGet;

/**
 * The upreg message of the property "RealSensorTemperatures"
 * <p>Detected temperatures of real thermal sensors.</p>
 * <p>---</p>
 * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_REALSENSORTEMPERATURES,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RealSensorTemperaturesUpReg;

/**
 * The relUpReg message of the property "RealSensorTemperatures"
 * <p>Detected temperatures of real thermal sensors.</p>
 * <p>---</p>
 * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_REALSENSORTEMPERATURES,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RealSensorTemperaturesRelUpReg;

/**
 * The get message of the property "RealSensorStates"
 * <p>Thermal states depending on detected temperatures of real thermal sensors.</p>
 * <p>Additional the MAIN thermal state is provided, too!</p>
 * <p>---</p>
 * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_REALSENSORSTATES,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
 * Answers with sensor states status message to requestor.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RealSensorStatesGet;

/**
 * The upreg message of the property "RealSensorStates"
 * <p>Thermal states depending on detected temperatures of real thermal sensors.</p>
 * <p>Additional the MAIN thermal state is provided, too!</p>
 * <p>---</p>
 * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_REALSENSORSTATES,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RealSensorStatesUpReg;

/**
 * The relUpReg message of the property "RealSensorStates"
 * <p>Thermal states depending on detected temperatures of real thermal sensors.</p>
 * <p>Additional the MAIN thermal state is provided, too!</p>
 * <p>---</p>
 * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_REALSENSORSTATES,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RealSensorStatesRelUpReg;

/**
 * The get message of the property "AbstractSensorTemperatures"
 * <p>temperatures of abstracted thermal sensors realized by real thermal sensors.</p>
 * <p>---</p>
 * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_ABSTRACTSENSORTEMPERATURES,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
 * Answers with temperature status message to requestor.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AbstractSensorTemperaturesGet;

/**
 * The upreg message of the property "AbstractSensorTemperatures"
 * <p>temperatures of abstracted thermal sensors realized by real thermal sensors.</p>
 * <p>---</p>
 * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_ABSTRACTSENSORTEMPERATURES,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AbstractSensorTemperaturesUpReg;

/**
 * The relUpReg message of the property "AbstractSensorTemperatures"
 * <p>temperatures of abstracted thermal sensors realized by real thermal sensors.</p>
 * <p>---</p>
 * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_ABSTRACTSENSORTEMPERATURES,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AbstractSensorTemperaturesRelUpReg;

/**
 * The get message of the property "AbstractSensorStates"
 * <p>All abstract thermal states depending on realized thermal sensors states.</p>
 * <p>Additional the MAIN thermal state is provided, too!</p>
 * <p>---</p>
 * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_ABSTRACTSENSORSTATES,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
 * Answers with sensor states status message to requestor.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AbstractSensorStatesGet;

/**
 * The upreg message of the property "AbstractSensorStates"
 * <p>All abstract thermal states depending on realized thermal sensors states.</p>
 * <p>Additional the MAIN thermal state is provided, too!</p>
 * <p>---</p>
 * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_ABSTRACTSENSORSTATES,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AbstractSensorStatesUpReg;

/**
 * The relUpReg message of the property "AbstractSensorStates"
 * <p>All abstract thermal states depending on realized thermal sensors states.</p>
 * <p>Additional the MAIN thermal state is provided, too!</p>
 * <p>---</p>
 * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_ABSTRACTSENSORSTATES,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AbstractSensorStatesRelUpReg;

/**
 * The get message of the property "EmergencyFunctions"
 * <p>State information of all supported emergency functions.</p>
 * <p>---</p>
 * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_EMERGENCYFUNCTIONS,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
 * Answers with temperature status message to requestor.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EmergencyFunctionsGet;

/**
 * The upreg message of the property "EmergencyFunctions"
 * <p>State information of all supported emergency functions.</p>
 * <p>---</p>
 * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_EMERGENCYFUNCTIONS,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EmergencyFunctionsUpReg;

/**
 * The relUpReg message of the property "EmergencyFunctions"
 * <p>State information of all supported emergency functions.</p>
 * <p>---</p>
 * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_EMERGENCYFUNCTIONS,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EmergencyFunctionsRelUpReg;

/**
 * The get message of the property "FANControl"
 * <p>All state information of optional FAN</p>
 * <p></p>
 * <p>A CCA application (e.g.: DIAGNOSIS) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_FANCONTROL,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_FC_DIAGNOSIS)
 * Answers with FAN and FAN control status message to requestor.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FANControlGet;

/**
 * The upreg message of the property "FANControl"
 * <p>All state information of optional FAN</p>
 * <p></p>
 * <p>A CCA application (e.g.: DIAGNOSIS) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_FANCONTROL,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_FC_DIAGNOSIS)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FANControlUpReg;

/**
 * The relUpReg message of the property "FANControl"
 * <p>All state information of optional FAN</p>
 * <p></p>
 * <p>A CCA application (e.g.: DIAGNOSIS) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_FANCONTROL,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_FC_DIAGNOSIS)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FANControlRelUpReg;

/**
 * The abort error message of the method "FI_FC_HEATCTRL_DEFAULT"
 * <p>FC_HEATCTRL has to support a default setting. This is the Functional Interface for this.</p>
 * <p>Attention:</p>
 * <p>In FI V1.0 FI "DefSetStateGroup" is of type="T_e8_DefSetGroups"!</p>
 * <p>In FI V1.0 FI "DefSetStateMode"  is of type="T_e8_DefSetMode"!</p>
 * <p>Both types are replaced by an tU8 to get rid of all the diag-types in this FI document starting with V2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError FI_FC_HEATCTRL_DEFAULTAbortError;

/**
 * The error message of 'FI_FC_HEATCTRL_DEFAULT'
 */
typedef ::asf::cca::CcaTypes::DefaultError FI_FC_HEATCTRL_DEFAULTError;


/**
 * The status message of the property "RealSensorTemperatures"
 * <p>Detected temperatures of real thermal sensors.</p>
 * <p>---</p>
 * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_REALSENSORTEMPERATURES,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
 */
class RealSensorTemperaturesStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RealSensorTemperaturesStatus ();

    /**
     * Copy constructor
     */
    inline  RealSensorTemperaturesStatus (const RealSensorTemperaturesStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RealSensorTemperaturesStatus (const ::heatctrl_main_fi_types::T_SensorTemperatureList& List_);

    /**
     * Destructor
     */
    inline virtual  ~RealSensorTemperaturesStatus();

    /**
     * Assignment operator
     */
    inline RealSensorTemperaturesStatus& operator = (const RealSensorTemperaturesStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RealSensorTemperaturesStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RealSensorTemperaturesStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RealSensorTemperaturesStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RealSensorTemperaturesStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "List"

    static const int kList = 0;

    /**
     * Clears the field "List".
     *
     * The field will be set to its default value. The hasList()
     * method will return false.
     */
    inline void clearList();

    /**
     * Checks whether the field "List" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setList()). Otherwise it will return false.
     */
    inline bool hasList () const;

    /**
     * Returns the value of the member "List".
     *
     * <p>list of temperature information of all real thermal sensors</p>
     *
     * @return The value of the field "List"
     */
    inline const ::heatctrl_main_fi_types::T_SensorTemperatureList& getList () const;

    /**
     * Retrieves the value of the field "List" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "List".
     */
    inline ::heatctrl_main_fi_types::T_SensorTemperatureList& getListMutable ();

    /**
     * Sets the value of the member "List".
     *
     * <p>list of temperature information of all real thermal sensors</p>
     *
     * @param List The value which will be set
     */
    inline void setList (const ::heatctrl_main_fi_types::T_SensorTemperatureList& List_);

    static const RealSensorTemperaturesStatus &getDefaultInstance();

private:

    static const ::std::vector< ::heatctrl_main_fi_types::T_SensorTemperature >& getT_SensorTemperatureList_DefaultInstance ();

    inline void set_has_List ();

    inline void clear_has_List ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::heatctrl_main_fi_types::T_SensorTemperatureList _List;

};

/**
 * The error message of 'RealSensorTemperatures'
 */
class RealSensorTemperaturesErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RealSensorTemperaturesErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RealSensorTemperaturesErrorStructure (const RealSensorTemperaturesErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RealSensorTemperaturesErrorStructure (uint32 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~RealSensorTemperaturesErrorStructure();

    /**
     * Assignment operator
     */
    inline RealSensorTemperaturesErrorStructure& operator = (const RealSensorTemperaturesErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RealSensorTemperaturesErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RealSensorTemperaturesErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RealSensorTemperaturesErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RealSensorTemperaturesErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint32 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint32 ErrorCode_);

    static const RealSensorTemperaturesErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ErrorCode;

};

/**
 * The error message of 'RealSensorTemperatures'
 */
class RealSensorTemperaturesError  : public ::asf::core::Payload {
public:

    enum RealSensorTemperaturesErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RealSensorTemperaturesError ();

   /**
     * Copy constructor
     */
    inline  RealSensorTemperaturesError (const RealSensorTemperaturesError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RealSensorTemperaturesError();

    /**
     * Assigns a new value to this object.
     */
    inline RealSensorTemperaturesError& operator = (const RealSensorTemperaturesError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RealSensorTemperaturesError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RealSensorTemperaturesError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RealSensorTemperaturesError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RealSensorTemperaturesError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RealSensorTemperaturesError::RealSensorTemperaturesErrorField getField () const;

    inline void setField(RealSensorTemperaturesError::RealSensorTemperaturesErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RealSensorTemperaturesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RealSensorTemperaturesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RealSensorTemperaturesErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RealSensorTemperaturesErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RealSensorTemperaturesErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RealSensorTemperaturesErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RealSensorTemperaturesErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RealSensorTemperaturesErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RealSensorTemperaturesError &getDefaultInstance();

private:

    inline void cloneData (const RealSensorTemperaturesError& rhs);

    inline void deleteData ();

    RealSensorTemperaturesErrorField __field;

    union {
        RealSensorTemperaturesErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "RealSensorStates"
 * <p>Thermal states depending on detected temperatures of real thermal sensors.</p>
 * <p>Additional the MAIN thermal state is provided, too!</p>
 * <p>---</p>
 * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_REALSENSORSTATES,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
 */
class RealSensorStatesStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RealSensorStatesStatus ();

    /**
     * Copy constructor
     */
    inline  RealSensorStatesStatus (const RealSensorStatesStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RealSensorStatesStatus (const ::heatctrl_main_fi_types::T_SensorStateList& List_);

    /**
     * Destructor
     */
    inline virtual  ~RealSensorStatesStatus();

    /**
     * Assignment operator
     */
    inline RealSensorStatesStatus& operator = (const RealSensorStatesStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RealSensorStatesStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RealSensorStatesStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RealSensorStatesStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RealSensorStatesStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "List"

    static const int kList = 0;

    /**
     * Clears the field "List".
     *
     * The field will be set to its default value. The hasList()
     * method will return false.
     */
    inline void clearList();

    /**
     * Checks whether the field "List" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setList()). Otherwise it will return false.
     */
    inline bool hasList () const;

    /**
     * Returns the value of the member "List".
     *
     * <p>list of state information of all real thermal sensors and the MAIN state</p>
     *
     * @return The value of the field "List"
     */
    inline const ::heatctrl_main_fi_types::T_SensorStateList& getList () const;

    /**
     * Retrieves the value of the field "List" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "List".
     */
    inline ::heatctrl_main_fi_types::T_SensorStateList& getListMutable ();

    /**
     * Sets the value of the member "List".
     *
     * <p>list of state information of all real thermal sensors and the MAIN state</p>
     *
     * @param List The value which will be set
     */
    inline void setList (const ::heatctrl_main_fi_types::T_SensorStateList& List_);

    static const RealSensorStatesStatus &getDefaultInstance();

private:

    static const ::std::vector< ::heatctrl_main_fi_types::T_SensorState >& getT_SensorStateList_DefaultInstance ();

    inline void set_has_List ();

    inline void clear_has_List ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::heatctrl_main_fi_types::T_SensorStateList _List;

};

/**
 * The error message of 'RealSensorStates'
 */
class RealSensorStatesErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  RealSensorStatesErrorStructure ();

    /**
     * Copy constructor
     */
    inline  RealSensorStatesErrorStructure (const RealSensorStatesErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  RealSensorStatesErrorStructure (uint32 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~RealSensorStatesErrorStructure();

    /**
     * Assignment operator
     */
    inline RealSensorStatesErrorStructure& operator = (const RealSensorStatesErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RealSensorStatesErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RealSensorStatesErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RealSensorStatesErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RealSensorStatesErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint32 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint32 ErrorCode_);

    static const RealSensorStatesErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ErrorCode;

};

/**
 * The error message of 'RealSensorStates'
 */
class RealSensorStatesError  : public ::asf::core::Payload {
public:

    enum RealSensorStatesErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  RealSensorStatesError ();

   /**
     * Copy constructor
     */
    inline  RealSensorStatesError (const RealSensorStatesError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~RealSensorStatesError();

    /**
     * Assigns a new value to this object.
     */
    inline RealSensorStatesError& operator = (const RealSensorStatesError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RealSensorStatesError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RealSensorStatesError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RealSensorStatesError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RealSensorStatesError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline RealSensorStatesError::RealSensorStatesErrorField getField () const;

    inline void setField(RealSensorStatesError::RealSensorStatesErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "RealSensorStatesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "RealSensorStatesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const RealSensorStatesErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline RealSensorStatesErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline RealSensorStatesErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (RealSensorStatesErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "RealSensorStatesErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const RealSensorStatesErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const RealSensorStatesError &getDefaultInstance();

private:

    inline void cloneData (const RealSensorStatesError& rhs);

    inline void deleteData ();

    RealSensorStatesErrorField __field;

    union {
        RealSensorStatesErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "AbstractSensorTemperatures"
 * <p>temperatures of abstracted thermal sensors realized by real thermal sensors.</p>
 * <p>---</p>
 * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_ABSTRACTSENSORTEMPERATURES,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
 */
class AbstractSensorTemperaturesStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AbstractSensorTemperaturesStatus ();

    /**
     * Copy constructor
     */
    inline  AbstractSensorTemperaturesStatus (const AbstractSensorTemperaturesStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AbstractSensorTemperaturesStatus (const ::heatctrl_main_fi_types::T_SensorTemperatureList& List_);

    /**
     * Destructor
     */
    inline virtual  ~AbstractSensorTemperaturesStatus();

    /**
     * Assignment operator
     */
    inline AbstractSensorTemperaturesStatus& operator = (const AbstractSensorTemperaturesStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AbstractSensorTemperaturesStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AbstractSensorTemperaturesStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AbstractSensorTemperaturesStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AbstractSensorTemperaturesStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "List"

    static const int kList = 0;

    /**
     * Clears the field "List".
     *
     * The field will be set to its default value. The hasList()
     * method will return false.
     */
    inline void clearList();

    /**
     * Checks whether the field "List" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setList()). Otherwise it will return false.
     */
    inline bool hasList () const;

    /**
     * Returns the value of the member "List".
     *
     * <p>list of temperature information of all abstract thermal sensors realized by real thermal sensors</p>
     *
     * @return The value of the field "List"
     */
    inline const ::heatctrl_main_fi_types::T_SensorTemperatureList& getList () const;

    /**
     * Retrieves the value of the field "List" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "List".
     */
    inline ::heatctrl_main_fi_types::T_SensorTemperatureList& getListMutable ();

    /**
     * Sets the value of the member "List".
     *
     * <p>list of temperature information of all abstract thermal sensors realized by real thermal sensors</p>
     *
     * @param List The value which will be set
     */
    inline void setList (const ::heatctrl_main_fi_types::T_SensorTemperatureList& List_);

    static const AbstractSensorTemperaturesStatus &getDefaultInstance();

private:

    static const ::std::vector< ::heatctrl_main_fi_types::T_SensorTemperature >& getT_SensorTemperatureList_DefaultInstance ();

    inline void set_has_List ();

    inline void clear_has_List ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::heatctrl_main_fi_types::T_SensorTemperatureList _List;

};

/**
 * The error message of 'AbstractSensorTemperatures'
 */
class AbstractSensorTemperaturesErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AbstractSensorTemperaturesErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AbstractSensorTemperaturesErrorStructure (const AbstractSensorTemperaturesErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AbstractSensorTemperaturesErrorStructure (uint32 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~AbstractSensorTemperaturesErrorStructure();

    /**
     * Assignment operator
     */
    inline AbstractSensorTemperaturesErrorStructure& operator = (const AbstractSensorTemperaturesErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AbstractSensorTemperaturesErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AbstractSensorTemperaturesErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AbstractSensorTemperaturesErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AbstractSensorTemperaturesErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint32 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint32 ErrorCode_);

    static const AbstractSensorTemperaturesErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ErrorCode;

};

/**
 * The error message of 'AbstractSensorTemperatures'
 */
class AbstractSensorTemperaturesError  : public ::asf::core::Payload {
public:

    enum AbstractSensorTemperaturesErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AbstractSensorTemperaturesError ();

   /**
     * Copy constructor
     */
    inline  AbstractSensorTemperaturesError (const AbstractSensorTemperaturesError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AbstractSensorTemperaturesError();

    /**
     * Assigns a new value to this object.
     */
    inline AbstractSensorTemperaturesError& operator = (const AbstractSensorTemperaturesError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AbstractSensorTemperaturesError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AbstractSensorTemperaturesError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AbstractSensorTemperaturesError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AbstractSensorTemperaturesError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AbstractSensorTemperaturesError::AbstractSensorTemperaturesErrorField getField () const;

    inline void setField(AbstractSensorTemperaturesError::AbstractSensorTemperaturesErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AbstractSensorTemperaturesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AbstractSensorTemperaturesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AbstractSensorTemperaturesErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AbstractSensorTemperaturesErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AbstractSensorTemperaturesErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AbstractSensorTemperaturesErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AbstractSensorTemperaturesErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AbstractSensorTemperaturesErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AbstractSensorTemperaturesError &getDefaultInstance();

private:

    inline void cloneData (const AbstractSensorTemperaturesError& rhs);

    inline void deleteData ();

    AbstractSensorTemperaturesErrorField __field;

    union {
        AbstractSensorTemperaturesErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "AbstractSensorStates"
 * <p>All abstract thermal states depending on realized thermal sensors states.</p>
 * <p>Additional the MAIN thermal state is provided, too!</p>
 * <p>---</p>
 * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_ABSTRACTSENSORSTATES,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
 */
class AbstractSensorStatesStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AbstractSensorStatesStatus ();

    /**
     * Copy constructor
     */
    inline  AbstractSensorStatesStatus (const AbstractSensorStatesStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AbstractSensorStatesStatus (const ::heatctrl_main_fi_types::T_SensorStateList& List_);

    /**
     * Destructor
     */
    inline virtual  ~AbstractSensorStatesStatus();

    /**
     * Assignment operator
     */
    inline AbstractSensorStatesStatus& operator = (const AbstractSensorStatesStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AbstractSensorStatesStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AbstractSensorStatesStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AbstractSensorStatesStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AbstractSensorStatesStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "List"

    static const int kList = 0;

    /**
     * Clears the field "List".
     *
     * The field will be set to its default value. The hasList()
     * method will return false.
     */
    inline void clearList();

    /**
     * Checks whether the field "List" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setList()). Otherwise it will return false.
     */
    inline bool hasList () const;

    /**
     * Returns the value of the member "List".
     *
     * <p>list of state information of all abstract thermal sensors and the MAIN state</p>
     *
     * @return The value of the field "List"
     */
    inline const ::heatctrl_main_fi_types::T_SensorStateList& getList () const;

    /**
     * Retrieves the value of the field "List" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "List".
     */
    inline ::heatctrl_main_fi_types::T_SensorStateList& getListMutable ();

    /**
     * Sets the value of the member "List".
     *
     * <p>list of state information of all abstract thermal sensors and the MAIN state</p>
     *
     * @param List The value which will be set
     */
    inline void setList (const ::heatctrl_main_fi_types::T_SensorStateList& List_);

    static const AbstractSensorStatesStatus &getDefaultInstance();

private:

    static const ::std::vector< ::heatctrl_main_fi_types::T_SensorState >& getT_SensorStateList_DefaultInstance ();

    inline void set_has_List ();

    inline void clear_has_List ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::heatctrl_main_fi_types::T_SensorStateList _List;

};

/**
 * The error message of 'AbstractSensorStates'
 */
class AbstractSensorStatesErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  AbstractSensorStatesErrorStructure ();

    /**
     * Copy constructor
     */
    inline  AbstractSensorStatesErrorStructure (const AbstractSensorStatesErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  AbstractSensorStatesErrorStructure (uint32 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~AbstractSensorStatesErrorStructure();

    /**
     * Assignment operator
     */
    inline AbstractSensorStatesErrorStructure& operator = (const AbstractSensorStatesErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AbstractSensorStatesErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AbstractSensorStatesErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AbstractSensorStatesErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AbstractSensorStatesErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint32 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint32 ErrorCode_);

    static const AbstractSensorStatesErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ErrorCode;

};

/**
 * The error message of 'AbstractSensorStates'
 */
class AbstractSensorStatesError  : public ::asf::core::Payload {
public:

    enum AbstractSensorStatesErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  AbstractSensorStatesError ();

   /**
     * Copy constructor
     */
    inline  AbstractSensorStatesError (const AbstractSensorStatesError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~AbstractSensorStatesError();

    /**
     * Assigns a new value to this object.
     */
    inline AbstractSensorStatesError& operator = (const AbstractSensorStatesError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AbstractSensorStatesError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AbstractSensorStatesError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AbstractSensorStatesError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AbstractSensorStatesError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline AbstractSensorStatesError::AbstractSensorStatesErrorField getField () const;

    inline void setField(AbstractSensorStatesError::AbstractSensorStatesErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "AbstractSensorStatesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "AbstractSensorStatesErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const AbstractSensorStatesErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline AbstractSensorStatesErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline AbstractSensorStatesErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (AbstractSensorStatesErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "AbstractSensorStatesErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const AbstractSensorStatesErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const AbstractSensorStatesError &getDefaultInstance();

private:

    inline void cloneData (const AbstractSensorStatesError& rhs);

    inline void deleteData ();

    AbstractSensorStatesErrorField __field;

    union {
        AbstractSensorStatesErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "EmergencyFunctions"
 * <p>State information of all supported emergency functions.</p>
 * <p>---</p>
 * <p>A CCA application (e.g.: HMI) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_EMERGENCYFUNCTIONS,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_UI)
 */
class EmergencyFunctionsStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EmergencyFunctionsStatus ();

    /**
     * Copy constructor
     */
    inline  EmergencyFunctionsStatus (const EmergencyFunctionsStatus &rhs);

    /**
     * All fields constructor
     */
    inline  EmergencyFunctionsStatus (const ::heatctrl_main_fi_types::T_EmergencyFunctionList& List_);

    /**
     * Destructor
     */
    inline virtual  ~EmergencyFunctionsStatus();

    /**
     * Assignment operator
     */
    inline EmergencyFunctionsStatus& operator = (const EmergencyFunctionsStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EmergencyFunctionsStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EmergencyFunctionsStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EmergencyFunctionsStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EmergencyFunctionsStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "List"

    static const int kList = 0;

    /**
     * Clears the field "List".
     *
     * The field will be set to its default value. The hasList()
     * method will return false.
     */
    inline void clearList();

    /**
     * Checks whether the field "List" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setList()). Otherwise it will return false.
     */
    inline bool hasList () const;

    /**
     * Returns the value of the member "List".
     *
     * <p>list of state information of all emergency functions</p>
     *
     * @return The value of the field "List"
     */
    inline const ::heatctrl_main_fi_types::T_EmergencyFunctionList& getList () const;

    /**
     * Retrieves the value of the field "List" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "List".
     */
    inline ::heatctrl_main_fi_types::T_EmergencyFunctionList& getListMutable ();

    /**
     * Sets the value of the member "List".
     *
     * <p>list of state information of all emergency functions</p>
     *
     * @param List The value which will be set
     */
    inline void setList (const ::heatctrl_main_fi_types::T_EmergencyFunctionList& List_);

    static const EmergencyFunctionsStatus &getDefaultInstance();

private:

    static const ::std::vector< ::heatctrl_main_fi_types::T_EmergencyFunction >& getT_EmergencyFunctionList_DefaultInstance ();

    inline void set_has_List ();

    inline void clear_has_List ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::heatctrl_main_fi_types::T_EmergencyFunctionList _List;

};

/**
 * The error message of 'EmergencyFunctions'
 */
class EmergencyFunctionsErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  EmergencyFunctionsErrorStructure ();

    /**
     * Copy constructor
     */
    inline  EmergencyFunctionsErrorStructure (const EmergencyFunctionsErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  EmergencyFunctionsErrorStructure (uint32 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~EmergencyFunctionsErrorStructure();

    /**
     * Assignment operator
     */
    inline EmergencyFunctionsErrorStructure& operator = (const EmergencyFunctionsErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EmergencyFunctionsErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EmergencyFunctionsErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EmergencyFunctionsErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EmergencyFunctionsErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint32 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint32 ErrorCode_);

    static const EmergencyFunctionsErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ErrorCode;

};

/**
 * The error message of 'EmergencyFunctions'
 */
class EmergencyFunctionsError  : public ::asf::core::Payload {
public:

    enum EmergencyFunctionsErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  EmergencyFunctionsError ();

   /**
     * Copy constructor
     */
    inline  EmergencyFunctionsError (const EmergencyFunctionsError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~EmergencyFunctionsError();

    /**
     * Assigns a new value to this object.
     */
    inline EmergencyFunctionsError& operator = (const EmergencyFunctionsError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EmergencyFunctionsError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EmergencyFunctionsError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EmergencyFunctionsError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EmergencyFunctionsError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline EmergencyFunctionsError::EmergencyFunctionsErrorField getField () const;

    inline void setField(EmergencyFunctionsError::EmergencyFunctionsErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "EmergencyFunctionsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "EmergencyFunctionsErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const EmergencyFunctionsErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline EmergencyFunctionsErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline EmergencyFunctionsErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (EmergencyFunctionsErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "EmergencyFunctionsErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const EmergencyFunctionsErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const EmergencyFunctionsError &getDefaultInstance();

private:

    inline void cloneData (const EmergencyFunctionsError& rhs);

    inline void deleteData ();

    EmergencyFunctionsErrorField __field;

    union {
        EmergencyFunctionsErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "FANControl"
 * <p>All state information of optional FAN</p>
 * <p></p>
 * <p>A CCA application (e.g.: DIAGNOSIS) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_FANCONTROL,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_FC_DIAGNOSIS)
 */
class FANControlStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FANControlStatus ();

    /**
     * Copy constructor
     */
    inline  FANControlStatus (const FANControlStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FANControlStatus (const ::heatctrl_main_fi_types::T_FAN& FAN_, const ::heatctrl_main_fi_types::T_FANCtrl& FANCtrl_);

    /**
     * Destructor
     */
    inline virtual  ~FANControlStatus();

    /**
     * Assignment operator
     */
    inline FANControlStatus& operator = (const FANControlStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FANControlStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FANControlStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FANControlStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FANControlStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FAN"

    static const int kFAN = 0;

    /**
     * Clears the field "FAN".
     *
     * The field will be set to its default value. The hasFAN()
     * method will return false.
     */
    inline void clearFAN();

    /**
     * Checks whether the field "FAN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFAN()). Otherwise it will return false.
     */
    inline bool hasFAN () const;

    /**
     * Returns the value of the member "FAN".
     *
     * <p>FAN status information.</p>
     *
     * @return The value of the field "FAN"
     */
    inline const ::heatctrl_main_fi_types::T_FAN& getFAN () const;

    /**
     * Retrieves the value of the field "FAN" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FAN".
     */
    inline ::heatctrl_main_fi_types::T_FAN& getFANMutable ();

    /**
     * Sets the value of the member "FAN".
     *
     * <p>FAN status information.</p>
     *
     * @param FAN The value which will be set
     */
    inline void setFAN (const ::heatctrl_main_fi_types::T_FAN& FAN_);

    // API of field "FANCtrl"

    static const int kFANCtrl = 1;

    /**
     * Clears the field "FANCtrl".
     *
     * The field will be set to its default value. The hasFANCtrl()
     * method will return false.
     */
    inline void clearFANCtrl();

    /**
     * Checks whether the field "FANCtrl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFANCtrl()). Otherwise it will return false.
     */
    inline bool hasFANCtrl () const;

    /**
     * Returns the value of the member "FANCtrl".
     *
     * <p>FAN control status information.</p>
     *
     * @return The value of the field "FANCtrl"
     */
    inline const ::heatctrl_main_fi_types::T_FANCtrl& getFANCtrl () const;

    /**
     * Retrieves the value of the field "FANCtrl" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FANCtrl".
     */
    inline ::heatctrl_main_fi_types::T_FANCtrl& getFANCtrlMutable ();

    /**
     * Sets the value of the member "FANCtrl".
     *
     * <p>FAN control status information.</p>
     *
     * @param FANCtrl The value which will be set
     */
    inline void setFANCtrl (const ::heatctrl_main_fi_types::T_FANCtrl& FANCtrl_);

    static const FANControlStatus &getDefaultInstance();

private:

    inline void set_has_FAN ();

    inline void clear_has_FAN ();

    inline void set_has_FANCtrl ();

    inline void clear_has_FANCtrl ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::heatctrl_main_fi_types::T_FAN _FAN;

    ::heatctrl_main_fi_types::T_FANCtrl _FANCtrl;

};

/**
 * The set message of the property "FANControl"
 * <p>All state information of optional FAN</p>
 * <p></p>
 * <p>A CCA application (e.g.: DIAGNOSIS) should use the following parameters,</p>
 * FUNCID    = HEATCTRL_MAINFI_C_U16_FANCONTROL,
 * SERVICEID = CCA_C_U16_SRV_HEATCTRL,
 * APPID     = CCA_C_U16_APP_FC_HEATCTRL,
 * TARGETID  = own CCA application id (e.g.: CCA_C_U16_APP_FC_DIAGNOSIS)
 * Request with new FAN and/or FAN control state to server.
 */
class FANControlSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FANControlSet ();

    /**
     * Copy constructor
     */
    inline  FANControlSet (const FANControlSet &rhs);

    /**
     * All fields constructor
     */
    inline  FANControlSet (const ::heatctrl_main_fi_types::T_FANReq& FAN_, const ::heatctrl_main_fi_types::T_FANCtrlReq& FANCtrl_);

    /**
     * Destructor
     */
    inline virtual  ~FANControlSet();

    /**
     * Assignment operator
     */
    inline FANControlSet& operator = (const FANControlSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FANControlSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FANControlSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FANControlSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FANControlSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FAN"

    static const int kFAN = 0;

    /**
     * Clears the field "FAN".
     *
     * The field will be set to its default value. The hasFAN()
     * method will return false.
     */
    inline void clearFAN();

    /**
     * Checks whether the field "FAN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFAN()). Otherwise it will return false.
     */
    inline bool hasFAN () const;

    /**
     * Returns the value of the member "FAN".
     *
     * <p>Required FAN status.</p>
     *
     * @return The value of the field "FAN"
     */
    inline const ::heatctrl_main_fi_types::T_FANReq& getFAN () const;

    /**
     * Retrieves the value of the field "FAN" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FAN".
     */
    inline ::heatctrl_main_fi_types::T_FANReq& getFANMutable ();

    /**
     * Sets the value of the member "FAN".
     *
     * <p>Required FAN status.</p>
     *
     * @param FAN The value which will be set
     */
    inline void setFAN (const ::heatctrl_main_fi_types::T_FANReq& FAN_);

    // API of field "FANCtrl"

    static const int kFANCtrl = 1;

    /**
     * Clears the field "FANCtrl".
     *
     * The field will be set to its default value. The hasFANCtrl()
     * method will return false.
     */
    inline void clearFANCtrl();

    /**
     * Checks whether the field "FANCtrl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFANCtrl()). Otherwise it will return false.
     */
    inline bool hasFANCtrl () const;

    /**
     * Returns the value of the member "FANCtrl".
     *
     * <p>Required FAN control status.</p>
     *
     * @return The value of the field "FANCtrl"
     */
    inline const ::heatctrl_main_fi_types::T_FANCtrlReq& getFANCtrl () const;

    /**
     * Retrieves the value of the field "FANCtrl" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FANCtrl".
     */
    inline ::heatctrl_main_fi_types::T_FANCtrlReq& getFANCtrlMutable ();

    /**
     * Sets the value of the member "FANCtrl".
     *
     * <p>Required FAN control status.</p>
     *
     * @param FANCtrl The value which will be set
     */
    inline void setFANCtrl (const ::heatctrl_main_fi_types::T_FANCtrlReq& FANCtrl_);

    static const FANControlSet &getDefaultInstance();

private:

    inline void set_has_FAN ();

    inline void clear_has_FAN ();

    inline void set_has_FANCtrl ();

    inline void clear_has_FANCtrl ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::heatctrl_main_fi_types::T_FANReq _FAN;

    ::heatctrl_main_fi_types::T_FANCtrlReq _FANCtrl;

};

/**
 * The error message of 'FANControl'
 */
class FANControlErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FANControlErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FANControlErrorStructure (const FANControlErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FANControlErrorStructure (uint32 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FANControlErrorStructure();

    /**
     * Assignment operator
     */
    inline FANControlErrorStructure& operator = (const FANControlErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FANControlErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FANControlErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FANControlErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FANControlErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint32 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * possible errors of a cca call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint32 ErrorCode_);

    static const FANControlErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ErrorCode;

};

/**
 * The error message of 'FANControl'
 */
class FANControlError  : public ::asf::core::Payload {
public:

    enum FANControlErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FANControlError ();

   /**
     * Copy constructor
     */
    inline  FANControlError (const FANControlError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FANControlError();

    /**
     * Assigns a new value to this object.
     */
    inline FANControlError& operator = (const FANControlError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FANControlError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FANControlError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FANControlError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FANControlError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FANControlError::FANControlErrorField getField () const;

    inline void setField(FANControlError::FANControlErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FANControlErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FANControlErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FANControlErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FANControlErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FANControlErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FANControlErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FANControlErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FANControlErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FANControlError &getDefaultInstance();

private:

    inline void cloneData (const FANControlError& rhs);

    inline void deleteData ();

    FANControlErrorField __field;

    union {
        FANControlErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FI_FC_HEATCTRL_DEFAULT"
 * <p>FC_HEATCTRL has to support a default setting. This is the Functional Interface for this.</p>
 * <p>Attention:</p>
 * <p>In FI V1.0 FI "DefSetStateGroup" is of type="T_e8_DefSetGroups"!</p>
 * <p>In FI V1.0 FI "DefSetStateMode"  is of type="T_e8_DefSetMode"!</p>
 * <p>Both types are replaced by an tU8 to get rid of all the diag-types in this FI document starting with V2.0!</p>
 * Message to start the setting of the default value.
 */
class FI_FC_HEATCTRL_DEFAULTStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FI_FC_HEATCTRL_DEFAULTStart ();

    /**
     * Copy constructor
     */
    inline  FI_FC_HEATCTRL_DEFAULTStart (const FI_FC_HEATCTRL_DEFAULTStart &rhs);

    /**
     * All fields constructor
     */
    inline  FI_FC_HEATCTRL_DEFAULTStart (uint8 DefaultSettingsGroup_, uint8 DefaultSettingsMode_);

    /**
     * Destructor
     */
    inline virtual  ~FI_FC_HEATCTRL_DEFAULTStart();

    /**
     * Assignment operator
     */
    inline FI_FC_HEATCTRL_DEFAULTStart& operator = (const FI_FC_HEATCTRL_DEFAULTStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FI_FC_HEATCTRL_DEFAULTStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FI_FC_HEATCTRL_DEFAULTStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FI_FC_HEATCTRL_DEFAULTStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FI_FC_HEATCTRL_DEFAULTStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefaultSettingsGroup"

    static const int kDefaultSettingsGroup = 0;

    /**
     * Clears the field "DefaultSettingsGroup".
     *
     * The field will be set to its default value. The hasDefaultSettingsGroup()
     * method will return false.
     */
    inline void clearDefaultSettingsGroup();

    /**
     * Checks whether the field "DefaultSettingsGroup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefaultSettingsGroup()). Otherwise it will return false.
     */
    inline bool hasDefaultSettingsGroup () const;

    /**
     * Returns the value of the member "DefaultSettingsGroup".
     *
     * relevant value: midw_fi_tcl_e8_DiagDefSetGroups::FI_EN_DEFSET_GROUP__MAINTENANCE
     *
     * @return The value of the field "DefaultSettingsGroup"
     */
    inline uint8 getDefaultSettingsGroup () const;

    /**
     * Sets the value of the member "DefaultSettingsGroup".
     *
     * relevant value: midw_fi_tcl_e8_DiagDefSetGroups::FI_EN_DEFSET_GROUP__MAINTENANCE
     *
     * @param DefaultSettingsGroup The value which will be set
     */
    inline void setDefaultSettingsGroup (uint8 DefaultSettingsGroup_);

    // API of field "DefaultSettingsMode"

    static const int kDefaultSettingsMode = 1;

    /**
     * Clears the field "DefaultSettingsMode".
     *
     * The field will be set to its default value. The hasDefaultSettingsMode()
     * method will return false.
     */
    inline void clearDefaultSettingsMode();

    /**
     * Checks whether the field "DefaultSettingsMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefaultSettingsMode()). Otherwise it will return false.
     */
    inline bool hasDefaultSettingsMode () const;

    /**
     * Returns the value of the member "DefaultSettingsMode".
     *
     * relevant value: midw_fi_tcl_e8_DefSetMode::FI_EN_DEFSET_SRC_CODING
     *
     * @return The value of the field "DefaultSettingsMode"
     */
    inline uint8 getDefaultSettingsMode () const;

    /**
     * Sets the value of the member "DefaultSettingsMode".
     *
     * relevant value: midw_fi_tcl_e8_DefSetMode::FI_EN_DEFSET_SRC_CODING
     *
     * @param DefaultSettingsMode The value which will be set
     */
    inline void setDefaultSettingsMode (uint8 DefaultSettingsMode_);

    static const FI_FC_HEATCTRL_DEFAULTStart &getDefaultInstance();

private:

    inline void set_has_DefaultSettingsGroup ();

    inline void clear_has_DefaultSettingsGroup ();

    inline void set_has_DefaultSettingsMode ();

    inline void clear_has_DefaultSettingsMode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _DefaultSettingsGroup;

    uint8 _DefaultSettingsMode;

};

/**
 * The result message of the method "FI_FC_HEATCTRL_DEFAULT"
 * <p>FC_HEATCTRL has to support a default setting. This is the Functional Interface for this.</p>
 * <p>Attention:</p>
 * <p>In FI V1.0 FI "DefSetStateGroup" is of type="T_e8_DefSetGroups"!</p>
 * <p>In FI V1.0 FI "DefSetStateMode"  is of type="T_e8_DefSetMode"!</p>
 * <p>Both types are replaced by an tU8 to get rid of all the diag-types in this FI document starting with V2.0!</p>
 * Message to return result of method start the setting of the default value.
 */
class FI_FC_HEATCTRL_DEFAULTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FI_FC_HEATCTRL_DEFAULTResult ();

    /**
     * Copy constructor
     */
    inline  FI_FC_HEATCTRL_DEFAULTResult (const FI_FC_HEATCTRL_DEFAULTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FI_FC_HEATCTRL_DEFAULTResult (uint8 DefaultSettingsGroup_, uint8 DefaultSettingsStatus_);

    /**
     * Destructor
     */
    inline virtual  ~FI_FC_HEATCTRL_DEFAULTResult();

    /**
     * Assignment operator
     */
    inline FI_FC_HEATCTRL_DEFAULTResult& operator = (const FI_FC_HEATCTRL_DEFAULTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FI_FC_HEATCTRL_DEFAULTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FI_FC_HEATCTRL_DEFAULTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FI_FC_HEATCTRL_DEFAULTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FI_FC_HEATCTRL_DEFAULTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefaultSettingsGroup"

    static const int kDefaultSettingsGroup = 0;

    /**
     * Clears the field "DefaultSettingsGroup".
     *
     * The field will be set to its default value. The hasDefaultSettingsGroup()
     * method will return false.
     */
    inline void clearDefaultSettingsGroup();

    /**
     * Checks whether the field "DefaultSettingsGroup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefaultSettingsGroup()). Otherwise it will return false.
     */
    inline bool hasDefaultSettingsGroup () const;

    /**
     * Returns the value of the member "DefaultSettingsGroup".
     *
     * reflecting of method start parameter DefaultSettingsGroup
     *
     * @return The value of the field "DefaultSettingsGroup"
     */
    inline uint8 getDefaultSettingsGroup () const;

    /**
     * Sets the value of the member "DefaultSettingsGroup".
     *
     * reflecting of method start parameter DefaultSettingsGroup
     *
     * @param DefaultSettingsGroup The value which will be set
     */
    inline void setDefaultSettingsGroup (uint8 DefaultSettingsGroup_);

    // API of field "DefaultSettingsStatus"

    static const int kDefaultSettingsStatus = 1;

    /**
     * Clears the field "DefaultSettingsStatus".
     *
     * The field will be set to its default value. The hasDefaultSettingsStatus()
     * method will return false.
     */
    inline void clearDefaultSettingsStatus();

    /**
     * Checks whether the field "DefaultSettingsStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefaultSettingsStatus()). Otherwise it will return false.
     */
    inline bool hasDefaultSettingsStatus () const;

    /**
     * Returns the value of the member "DefaultSettingsStatus".
     *
     * setting status ... 0 - OK, else failed
     *
     * @return The value of the field "DefaultSettingsStatus"
     */
    inline uint8 getDefaultSettingsStatus () const;

    /**
     * Sets the value of the member "DefaultSettingsStatus".
     *
     * setting status ... 0 - OK, else failed
     *
     * @param DefaultSettingsStatus The value which will be set
     */
    inline void setDefaultSettingsStatus (uint8 DefaultSettingsStatus_);

    static const FI_FC_HEATCTRL_DEFAULTResult &getDefaultInstance();

private:

    inline void set_has_DefaultSettingsGroup ();

    inline void clear_has_DefaultSettingsGroup ();

    inline void set_has_DefaultSettingsStatus ();

    inline void clear_has_DefaultSettingsStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _DefaultSettingsGroup;

    uint8 _DefaultSettingsStatus;

};

inline  RealSensorTemperaturesStatus::RealSensorTemperaturesStatus ()  :
    _List ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RealSensorTemperaturesStatus::RealSensorTemperaturesStatus (const RealSensorTemperaturesStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _List ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RealSensorTemperaturesStatus::RealSensorTemperaturesStatus (const ::heatctrl_main_fi_types::T_SensorTemperatureList& List_)  :
    _List (List_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RealSensorTemperaturesStatus::~RealSensorTemperaturesStatus() {
}

inline RealSensorTemperaturesStatus& RealSensorTemperaturesStatus::operator = (const RealSensorTemperaturesStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasList()) {
            setList(rhs.getList());
        } else {
            clearList();
        }
    }
    return *this;
}

inline bool RealSensorTemperaturesStatus::operator == (const RealSensorTemperaturesStatus& rhs) const {
    return (((!hasList() && !rhs.hasList()) || getList() == rhs.getList()));
}

inline bool RealSensorTemperaturesStatus::operator != (const RealSensorTemperaturesStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool RealSensorTemperaturesStatus::operator < (const RealSensorTemperaturesStatus& rhs) const {
    if (hasList() || rhs.hasList()) {
        if (getList() < rhs.getList()) return true;
        if (getList() > rhs.getList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RealSensorTemperaturesStatus::clone() {
    return new RealSensorTemperaturesStatus(*this);
}

inline bool RealSensorTemperaturesStatus::operator > (const RealSensorTemperaturesStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RealSensorTemperaturesStatus::clear() {
    clearList();
}

inline void RealSensorTemperaturesStatus::clearList() {
    if (hasList()) {
         clear_has_List();
        _List.clear();
     }
}

inline bool RealSensorTemperaturesStatus::hasList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::heatctrl_main_fi_types::T_SensorTemperatureList& RealSensorTemperaturesStatus::getList () const {
    return _List;
}

inline ::heatctrl_main_fi_types::T_SensorTemperatureList& RealSensorTemperaturesStatus::getListMutable () {
    set_has_List();
    return _List;
}

inline void RealSensorTemperaturesStatus::setList (const ::heatctrl_main_fi_types::T_SensorTemperatureList& List_) {
    set_has_List();
    this->_List = List_;
}

inline void RealSensorTemperaturesStatus::set_has_List () {
    _has_bits_[0] |= 1u << 0;
}

inline void RealSensorTemperaturesStatus::clear_has_List () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RealSensorTemperaturesErrorStructure::RealSensorTemperaturesErrorStructure ()  :
    _ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RealSensorTemperaturesErrorStructure::RealSensorTemperaturesErrorStructure (const RealSensorTemperaturesErrorStructure &rhs)  :
    _ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RealSensorTemperaturesErrorStructure::RealSensorTemperaturesErrorStructure (uint32 ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RealSensorTemperaturesErrorStructure::~RealSensorTemperaturesErrorStructure() {
}

inline RealSensorTemperaturesErrorStructure& RealSensorTemperaturesErrorStructure::operator = (const RealSensorTemperaturesErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool RealSensorTemperaturesErrorStructure::operator == (const RealSensorTemperaturesErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool RealSensorTemperaturesErrorStructure::operator != (const RealSensorTemperaturesErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool RealSensorTemperaturesErrorStructure::operator < (const RealSensorTemperaturesErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if (getErrorCode() < rhs.getErrorCode()) return true;
        if (getErrorCode() > rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool RealSensorTemperaturesErrorStructure::operator > (const RealSensorTemperaturesErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RealSensorTemperaturesErrorStructure::clear() {
    clearErrorCode();
}

inline void RealSensorTemperaturesErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = 0u;
     }
}

inline bool RealSensorTemperaturesErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 RealSensorTemperaturesErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void RealSensorTemperaturesErrorStructure::setErrorCode (uint32 ErrorCode_) {
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void RealSensorTemperaturesErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void RealSensorTemperaturesErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RealSensorTemperaturesError::RealSensorTemperaturesError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  RealSensorTemperaturesError::RealSensorTemperaturesError (const RealSensorTemperaturesError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  RealSensorTemperaturesError::~RealSensorTemperaturesError() {
    deleteData ();
}

inline RealSensorTemperaturesError& RealSensorTemperaturesError::operator = (const RealSensorTemperaturesError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool RealSensorTemperaturesError::operator == (const RealSensorTemperaturesError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool RealSensorTemperaturesError::operator != (const RealSensorTemperaturesError& rhs) const {
    return ! (*this == rhs);
}

inline bool RealSensorTemperaturesError::operator < (const RealSensorTemperaturesError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool RealSensorTemperaturesError::operator > (const RealSensorTemperaturesError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline RealSensorTemperaturesError::RealSensorTemperaturesErrorField RealSensorTemperaturesError::getField () const {
    return __field;
}

inline void RealSensorTemperaturesError::setField(RealSensorTemperaturesError::RealSensorTemperaturesErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* RealSensorTemperaturesError::clone() {
    return new RealSensorTemperaturesError(*this);
}

inline bool RealSensorTemperaturesError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const RealSensorTemperaturesErrorStructure& RealSensorTemperaturesError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "RealSensorTemperaturesError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return RealSensorTemperaturesErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline RealSensorTemperaturesErrorStructure& RealSensorTemperaturesError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "RealSensorTemperaturesError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new RealSensorTemperaturesErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline RealSensorTemperaturesErrorStructure* RealSensorTemperaturesError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'RealSensorTemperaturesError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new RealSensorTemperaturesErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        RealSensorTemperaturesErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void RealSensorTemperaturesError::replaceCcaErrorCode (RealSensorTemperaturesErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void RealSensorTemperaturesError::setCcaErrorCode (const RealSensorTemperaturesErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new RealSensorTemperaturesErrorStructure(value);
    }
}

inline bool RealSensorTemperaturesError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode RealSensorTemperaturesError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "RealSensorTemperaturesError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void RealSensorTemperaturesError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "RealSensorTemperaturesError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void RealSensorTemperaturesError::cloneData (const RealSensorTemperaturesError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new RealSensorTemperaturesErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new RealSensorTemperaturesErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void RealSensorTemperaturesError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  RealSensorStatesStatus::RealSensorStatesStatus ()  :
    _List ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RealSensorStatesStatus::RealSensorStatesStatus (const RealSensorStatesStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _List ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RealSensorStatesStatus::RealSensorStatesStatus (const ::heatctrl_main_fi_types::T_SensorStateList& List_)  :
    _List (List_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RealSensorStatesStatus::~RealSensorStatesStatus() {
}

inline RealSensorStatesStatus& RealSensorStatesStatus::operator = (const RealSensorStatesStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasList()) {
            setList(rhs.getList());
        } else {
            clearList();
        }
    }
    return *this;
}

inline bool RealSensorStatesStatus::operator == (const RealSensorStatesStatus& rhs) const {
    return (((!hasList() && !rhs.hasList()) || getList() == rhs.getList()));
}

inline bool RealSensorStatesStatus::operator != (const RealSensorStatesStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool RealSensorStatesStatus::operator < (const RealSensorStatesStatus& rhs) const {
    if (hasList() || rhs.hasList()) {
        if (getList() < rhs.getList()) return true;
        if (getList() > rhs.getList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RealSensorStatesStatus::clone() {
    return new RealSensorStatesStatus(*this);
}

inline bool RealSensorStatesStatus::operator > (const RealSensorStatesStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RealSensorStatesStatus::clear() {
    clearList();
}

inline void RealSensorStatesStatus::clearList() {
    if (hasList()) {
         clear_has_List();
        _List.clear();
     }
}

inline bool RealSensorStatesStatus::hasList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::heatctrl_main_fi_types::T_SensorStateList& RealSensorStatesStatus::getList () const {
    return _List;
}

inline ::heatctrl_main_fi_types::T_SensorStateList& RealSensorStatesStatus::getListMutable () {
    set_has_List();
    return _List;
}

inline void RealSensorStatesStatus::setList (const ::heatctrl_main_fi_types::T_SensorStateList& List_) {
    set_has_List();
    this->_List = List_;
}

inline void RealSensorStatesStatus::set_has_List () {
    _has_bits_[0] |= 1u << 0;
}

inline void RealSensorStatesStatus::clear_has_List () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RealSensorStatesErrorStructure::RealSensorStatesErrorStructure ()  :
    _ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RealSensorStatesErrorStructure::RealSensorStatesErrorStructure (const RealSensorStatesErrorStructure &rhs)  :
    _ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RealSensorStatesErrorStructure::RealSensorStatesErrorStructure (uint32 ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RealSensorStatesErrorStructure::~RealSensorStatesErrorStructure() {
}

inline RealSensorStatesErrorStructure& RealSensorStatesErrorStructure::operator = (const RealSensorStatesErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool RealSensorStatesErrorStructure::operator == (const RealSensorStatesErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool RealSensorStatesErrorStructure::operator != (const RealSensorStatesErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool RealSensorStatesErrorStructure::operator < (const RealSensorStatesErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if (getErrorCode() < rhs.getErrorCode()) return true;
        if (getErrorCode() > rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool RealSensorStatesErrorStructure::operator > (const RealSensorStatesErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RealSensorStatesErrorStructure::clear() {
    clearErrorCode();
}

inline void RealSensorStatesErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = 0u;
     }
}

inline bool RealSensorStatesErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 RealSensorStatesErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void RealSensorStatesErrorStructure::setErrorCode (uint32 ErrorCode_) {
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void RealSensorStatesErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void RealSensorStatesErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RealSensorStatesError::RealSensorStatesError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  RealSensorStatesError::RealSensorStatesError (const RealSensorStatesError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  RealSensorStatesError::~RealSensorStatesError() {
    deleteData ();
}

inline RealSensorStatesError& RealSensorStatesError::operator = (const RealSensorStatesError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool RealSensorStatesError::operator == (const RealSensorStatesError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool RealSensorStatesError::operator != (const RealSensorStatesError& rhs) const {
    return ! (*this == rhs);
}

inline bool RealSensorStatesError::operator < (const RealSensorStatesError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool RealSensorStatesError::operator > (const RealSensorStatesError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline RealSensorStatesError::RealSensorStatesErrorField RealSensorStatesError::getField () const {
    return __field;
}

inline void RealSensorStatesError::setField(RealSensorStatesError::RealSensorStatesErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* RealSensorStatesError::clone() {
    return new RealSensorStatesError(*this);
}

inline bool RealSensorStatesError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const RealSensorStatesErrorStructure& RealSensorStatesError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "RealSensorStatesError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return RealSensorStatesErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline RealSensorStatesErrorStructure& RealSensorStatesError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "RealSensorStatesError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new RealSensorStatesErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline RealSensorStatesErrorStructure* RealSensorStatesError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'RealSensorStatesError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new RealSensorStatesErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        RealSensorStatesErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void RealSensorStatesError::replaceCcaErrorCode (RealSensorStatesErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void RealSensorStatesError::setCcaErrorCode (const RealSensorStatesErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new RealSensorStatesErrorStructure(value);
    }
}

inline bool RealSensorStatesError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode RealSensorStatesError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "RealSensorStatesError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void RealSensorStatesError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "RealSensorStatesError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void RealSensorStatesError::cloneData (const RealSensorStatesError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new RealSensorStatesErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new RealSensorStatesErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void RealSensorStatesError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  AbstractSensorTemperaturesStatus::AbstractSensorTemperaturesStatus ()  :
    _List ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AbstractSensorTemperaturesStatus::AbstractSensorTemperaturesStatus (const AbstractSensorTemperaturesStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _List ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AbstractSensorTemperaturesStatus::AbstractSensorTemperaturesStatus (const ::heatctrl_main_fi_types::T_SensorTemperatureList& List_)  :
    _List (List_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AbstractSensorTemperaturesStatus::~AbstractSensorTemperaturesStatus() {
}

inline AbstractSensorTemperaturesStatus& AbstractSensorTemperaturesStatus::operator = (const AbstractSensorTemperaturesStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasList()) {
            setList(rhs.getList());
        } else {
            clearList();
        }
    }
    return *this;
}

inline bool AbstractSensorTemperaturesStatus::operator == (const AbstractSensorTemperaturesStatus& rhs) const {
    return (((!hasList() && !rhs.hasList()) || getList() == rhs.getList()));
}

inline bool AbstractSensorTemperaturesStatus::operator != (const AbstractSensorTemperaturesStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool AbstractSensorTemperaturesStatus::operator < (const AbstractSensorTemperaturesStatus& rhs) const {
    if (hasList() || rhs.hasList()) {
        if (getList() < rhs.getList()) return true;
        if (getList() > rhs.getList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AbstractSensorTemperaturesStatus::clone() {
    return new AbstractSensorTemperaturesStatus(*this);
}

inline bool AbstractSensorTemperaturesStatus::operator > (const AbstractSensorTemperaturesStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AbstractSensorTemperaturesStatus::clear() {
    clearList();
}

inline void AbstractSensorTemperaturesStatus::clearList() {
    if (hasList()) {
         clear_has_List();
        _List.clear();
     }
}

inline bool AbstractSensorTemperaturesStatus::hasList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::heatctrl_main_fi_types::T_SensorTemperatureList& AbstractSensorTemperaturesStatus::getList () const {
    return _List;
}

inline ::heatctrl_main_fi_types::T_SensorTemperatureList& AbstractSensorTemperaturesStatus::getListMutable () {
    set_has_List();
    return _List;
}

inline void AbstractSensorTemperaturesStatus::setList (const ::heatctrl_main_fi_types::T_SensorTemperatureList& List_) {
    set_has_List();
    this->_List = List_;
}

inline void AbstractSensorTemperaturesStatus::set_has_List () {
    _has_bits_[0] |= 1u << 0;
}

inline void AbstractSensorTemperaturesStatus::clear_has_List () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AbstractSensorTemperaturesErrorStructure::AbstractSensorTemperaturesErrorStructure ()  :
    _ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AbstractSensorTemperaturesErrorStructure::AbstractSensorTemperaturesErrorStructure (const AbstractSensorTemperaturesErrorStructure &rhs)  :
    _ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AbstractSensorTemperaturesErrorStructure::AbstractSensorTemperaturesErrorStructure (uint32 ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AbstractSensorTemperaturesErrorStructure::~AbstractSensorTemperaturesErrorStructure() {
}

inline AbstractSensorTemperaturesErrorStructure& AbstractSensorTemperaturesErrorStructure::operator = (const AbstractSensorTemperaturesErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool AbstractSensorTemperaturesErrorStructure::operator == (const AbstractSensorTemperaturesErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool AbstractSensorTemperaturesErrorStructure::operator != (const AbstractSensorTemperaturesErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool AbstractSensorTemperaturesErrorStructure::operator < (const AbstractSensorTemperaturesErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if (getErrorCode() < rhs.getErrorCode()) return true;
        if (getErrorCode() > rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool AbstractSensorTemperaturesErrorStructure::operator > (const AbstractSensorTemperaturesErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AbstractSensorTemperaturesErrorStructure::clear() {
    clearErrorCode();
}

inline void AbstractSensorTemperaturesErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = 0u;
     }
}

inline bool AbstractSensorTemperaturesErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 AbstractSensorTemperaturesErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void AbstractSensorTemperaturesErrorStructure::setErrorCode (uint32 ErrorCode_) {
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void AbstractSensorTemperaturesErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void AbstractSensorTemperaturesErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AbstractSensorTemperaturesError::AbstractSensorTemperaturesError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  AbstractSensorTemperaturesError::AbstractSensorTemperaturesError (const AbstractSensorTemperaturesError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  AbstractSensorTemperaturesError::~AbstractSensorTemperaturesError() {
    deleteData ();
}

inline AbstractSensorTemperaturesError& AbstractSensorTemperaturesError::operator = (const AbstractSensorTemperaturesError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool AbstractSensorTemperaturesError::operator == (const AbstractSensorTemperaturesError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool AbstractSensorTemperaturesError::operator != (const AbstractSensorTemperaturesError& rhs) const {
    return ! (*this == rhs);
}

inline bool AbstractSensorTemperaturesError::operator < (const AbstractSensorTemperaturesError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool AbstractSensorTemperaturesError::operator > (const AbstractSensorTemperaturesError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline AbstractSensorTemperaturesError::AbstractSensorTemperaturesErrorField AbstractSensorTemperaturesError::getField () const {
    return __field;
}

inline void AbstractSensorTemperaturesError::setField(AbstractSensorTemperaturesError::AbstractSensorTemperaturesErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* AbstractSensorTemperaturesError::clone() {
    return new AbstractSensorTemperaturesError(*this);
}

inline bool AbstractSensorTemperaturesError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const AbstractSensorTemperaturesErrorStructure& AbstractSensorTemperaturesError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "AbstractSensorTemperaturesError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return AbstractSensorTemperaturesErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline AbstractSensorTemperaturesErrorStructure& AbstractSensorTemperaturesError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "AbstractSensorTemperaturesError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new AbstractSensorTemperaturesErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline AbstractSensorTemperaturesErrorStructure* AbstractSensorTemperaturesError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'AbstractSensorTemperaturesError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new AbstractSensorTemperaturesErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        AbstractSensorTemperaturesErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void AbstractSensorTemperaturesError::replaceCcaErrorCode (AbstractSensorTemperaturesErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void AbstractSensorTemperaturesError::setCcaErrorCode (const AbstractSensorTemperaturesErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new AbstractSensorTemperaturesErrorStructure(value);
    }
}

inline bool AbstractSensorTemperaturesError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode AbstractSensorTemperaturesError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "AbstractSensorTemperaturesError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void AbstractSensorTemperaturesError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "AbstractSensorTemperaturesError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void AbstractSensorTemperaturesError::cloneData (const AbstractSensorTemperaturesError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new AbstractSensorTemperaturesErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new AbstractSensorTemperaturesErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void AbstractSensorTemperaturesError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  AbstractSensorStatesStatus::AbstractSensorStatesStatus ()  :
    _List ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AbstractSensorStatesStatus::AbstractSensorStatesStatus (const AbstractSensorStatesStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _List ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AbstractSensorStatesStatus::AbstractSensorStatesStatus (const ::heatctrl_main_fi_types::T_SensorStateList& List_)  :
    _List (List_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AbstractSensorStatesStatus::~AbstractSensorStatesStatus() {
}

inline AbstractSensorStatesStatus& AbstractSensorStatesStatus::operator = (const AbstractSensorStatesStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasList()) {
            setList(rhs.getList());
        } else {
            clearList();
        }
    }
    return *this;
}

inline bool AbstractSensorStatesStatus::operator == (const AbstractSensorStatesStatus& rhs) const {
    return (((!hasList() && !rhs.hasList()) || getList() == rhs.getList()));
}

inline bool AbstractSensorStatesStatus::operator != (const AbstractSensorStatesStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool AbstractSensorStatesStatus::operator < (const AbstractSensorStatesStatus& rhs) const {
    if (hasList() || rhs.hasList()) {
        if (getList() < rhs.getList()) return true;
        if (getList() > rhs.getList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AbstractSensorStatesStatus::clone() {
    return new AbstractSensorStatesStatus(*this);
}

inline bool AbstractSensorStatesStatus::operator > (const AbstractSensorStatesStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AbstractSensorStatesStatus::clear() {
    clearList();
}

inline void AbstractSensorStatesStatus::clearList() {
    if (hasList()) {
         clear_has_List();
        _List.clear();
     }
}

inline bool AbstractSensorStatesStatus::hasList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::heatctrl_main_fi_types::T_SensorStateList& AbstractSensorStatesStatus::getList () const {
    return _List;
}

inline ::heatctrl_main_fi_types::T_SensorStateList& AbstractSensorStatesStatus::getListMutable () {
    set_has_List();
    return _List;
}

inline void AbstractSensorStatesStatus::setList (const ::heatctrl_main_fi_types::T_SensorStateList& List_) {
    set_has_List();
    this->_List = List_;
}

inline void AbstractSensorStatesStatus::set_has_List () {
    _has_bits_[0] |= 1u << 0;
}

inline void AbstractSensorStatesStatus::clear_has_List () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AbstractSensorStatesErrorStructure::AbstractSensorStatesErrorStructure ()  :
    _ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AbstractSensorStatesErrorStructure::AbstractSensorStatesErrorStructure (const AbstractSensorStatesErrorStructure &rhs)  :
    _ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AbstractSensorStatesErrorStructure::AbstractSensorStatesErrorStructure (uint32 ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AbstractSensorStatesErrorStructure::~AbstractSensorStatesErrorStructure() {
}

inline AbstractSensorStatesErrorStructure& AbstractSensorStatesErrorStructure::operator = (const AbstractSensorStatesErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool AbstractSensorStatesErrorStructure::operator == (const AbstractSensorStatesErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool AbstractSensorStatesErrorStructure::operator != (const AbstractSensorStatesErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool AbstractSensorStatesErrorStructure::operator < (const AbstractSensorStatesErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if (getErrorCode() < rhs.getErrorCode()) return true;
        if (getErrorCode() > rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool AbstractSensorStatesErrorStructure::operator > (const AbstractSensorStatesErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AbstractSensorStatesErrorStructure::clear() {
    clearErrorCode();
}

inline void AbstractSensorStatesErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = 0u;
     }
}

inline bool AbstractSensorStatesErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 AbstractSensorStatesErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void AbstractSensorStatesErrorStructure::setErrorCode (uint32 ErrorCode_) {
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void AbstractSensorStatesErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void AbstractSensorStatesErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AbstractSensorStatesError::AbstractSensorStatesError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  AbstractSensorStatesError::AbstractSensorStatesError (const AbstractSensorStatesError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  AbstractSensorStatesError::~AbstractSensorStatesError() {
    deleteData ();
}

inline AbstractSensorStatesError& AbstractSensorStatesError::operator = (const AbstractSensorStatesError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool AbstractSensorStatesError::operator == (const AbstractSensorStatesError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool AbstractSensorStatesError::operator != (const AbstractSensorStatesError& rhs) const {
    return ! (*this == rhs);
}

inline bool AbstractSensorStatesError::operator < (const AbstractSensorStatesError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool AbstractSensorStatesError::operator > (const AbstractSensorStatesError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline AbstractSensorStatesError::AbstractSensorStatesErrorField AbstractSensorStatesError::getField () const {
    return __field;
}

inline void AbstractSensorStatesError::setField(AbstractSensorStatesError::AbstractSensorStatesErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* AbstractSensorStatesError::clone() {
    return new AbstractSensorStatesError(*this);
}

inline bool AbstractSensorStatesError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const AbstractSensorStatesErrorStructure& AbstractSensorStatesError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "AbstractSensorStatesError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return AbstractSensorStatesErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline AbstractSensorStatesErrorStructure& AbstractSensorStatesError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "AbstractSensorStatesError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new AbstractSensorStatesErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline AbstractSensorStatesErrorStructure* AbstractSensorStatesError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'AbstractSensorStatesError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new AbstractSensorStatesErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        AbstractSensorStatesErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void AbstractSensorStatesError::replaceCcaErrorCode (AbstractSensorStatesErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void AbstractSensorStatesError::setCcaErrorCode (const AbstractSensorStatesErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new AbstractSensorStatesErrorStructure(value);
    }
}

inline bool AbstractSensorStatesError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode AbstractSensorStatesError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "AbstractSensorStatesError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void AbstractSensorStatesError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "AbstractSensorStatesError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void AbstractSensorStatesError::cloneData (const AbstractSensorStatesError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new AbstractSensorStatesErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new AbstractSensorStatesErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void AbstractSensorStatesError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  EmergencyFunctionsStatus::EmergencyFunctionsStatus ()  :
    _List ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EmergencyFunctionsStatus::EmergencyFunctionsStatus (const EmergencyFunctionsStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _List ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EmergencyFunctionsStatus::EmergencyFunctionsStatus (const ::heatctrl_main_fi_types::T_EmergencyFunctionList& List_)  :
    _List (List_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EmergencyFunctionsStatus::~EmergencyFunctionsStatus() {
}

inline EmergencyFunctionsStatus& EmergencyFunctionsStatus::operator = (const EmergencyFunctionsStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasList()) {
            setList(rhs.getList());
        } else {
            clearList();
        }
    }
    return *this;
}

inline bool EmergencyFunctionsStatus::operator == (const EmergencyFunctionsStatus& rhs) const {
    return (((!hasList() && !rhs.hasList()) || getList() == rhs.getList()));
}

inline bool EmergencyFunctionsStatus::operator != (const EmergencyFunctionsStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool EmergencyFunctionsStatus::operator < (const EmergencyFunctionsStatus& rhs) const {
    if (hasList() || rhs.hasList()) {
        if (getList() < rhs.getList()) return true;
        if (getList() > rhs.getList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EmergencyFunctionsStatus::clone() {
    return new EmergencyFunctionsStatus(*this);
}

inline bool EmergencyFunctionsStatus::operator > (const EmergencyFunctionsStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EmergencyFunctionsStatus::clear() {
    clearList();
}

inline void EmergencyFunctionsStatus::clearList() {
    if (hasList()) {
         clear_has_List();
        _List.clear();
     }
}

inline bool EmergencyFunctionsStatus::hasList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::heatctrl_main_fi_types::T_EmergencyFunctionList& EmergencyFunctionsStatus::getList () const {
    return _List;
}

inline ::heatctrl_main_fi_types::T_EmergencyFunctionList& EmergencyFunctionsStatus::getListMutable () {
    set_has_List();
    return _List;
}

inline void EmergencyFunctionsStatus::setList (const ::heatctrl_main_fi_types::T_EmergencyFunctionList& List_) {
    set_has_List();
    this->_List = List_;
}

inline void EmergencyFunctionsStatus::set_has_List () {
    _has_bits_[0] |= 1u << 0;
}

inline void EmergencyFunctionsStatus::clear_has_List () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EmergencyFunctionsErrorStructure::EmergencyFunctionsErrorStructure ()  :
    _ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EmergencyFunctionsErrorStructure::EmergencyFunctionsErrorStructure (const EmergencyFunctionsErrorStructure &rhs)  :
    _ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EmergencyFunctionsErrorStructure::EmergencyFunctionsErrorStructure (uint32 ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EmergencyFunctionsErrorStructure::~EmergencyFunctionsErrorStructure() {
}

inline EmergencyFunctionsErrorStructure& EmergencyFunctionsErrorStructure::operator = (const EmergencyFunctionsErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool EmergencyFunctionsErrorStructure::operator == (const EmergencyFunctionsErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool EmergencyFunctionsErrorStructure::operator != (const EmergencyFunctionsErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool EmergencyFunctionsErrorStructure::operator < (const EmergencyFunctionsErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if (getErrorCode() < rhs.getErrorCode()) return true;
        if (getErrorCode() > rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool EmergencyFunctionsErrorStructure::operator > (const EmergencyFunctionsErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EmergencyFunctionsErrorStructure::clear() {
    clearErrorCode();
}

inline void EmergencyFunctionsErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = 0u;
     }
}

inline bool EmergencyFunctionsErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 EmergencyFunctionsErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void EmergencyFunctionsErrorStructure::setErrorCode (uint32 ErrorCode_) {
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void EmergencyFunctionsErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void EmergencyFunctionsErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EmergencyFunctionsError::EmergencyFunctionsError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  EmergencyFunctionsError::EmergencyFunctionsError (const EmergencyFunctionsError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  EmergencyFunctionsError::~EmergencyFunctionsError() {
    deleteData ();
}

inline EmergencyFunctionsError& EmergencyFunctionsError::operator = (const EmergencyFunctionsError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool EmergencyFunctionsError::operator == (const EmergencyFunctionsError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool EmergencyFunctionsError::operator != (const EmergencyFunctionsError& rhs) const {
    return ! (*this == rhs);
}

inline bool EmergencyFunctionsError::operator < (const EmergencyFunctionsError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool EmergencyFunctionsError::operator > (const EmergencyFunctionsError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline EmergencyFunctionsError::EmergencyFunctionsErrorField EmergencyFunctionsError::getField () const {
    return __field;
}

inline void EmergencyFunctionsError::setField(EmergencyFunctionsError::EmergencyFunctionsErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* EmergencyFunctionsError::clone() {
    return new EmergencyFunctionsError(*this);
}

inline bool EmergencyFunctionsError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const EmergencyFunctionsErrorStructure& EmergencyFunctionsError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "EmergencyFunctionsError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return EmergencyFunctionsErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline EmergencyFunctionsErrorStructure& EmergencyFunctionsError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "EmergencyFunctionsError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new EmergencyFunctionsErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline EmergencyFunctionsErrorStructure* EmergencyFunctionsError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'EmergencyFunctionsError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new EmergencyFunctionsErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        EmergencyFunctionsErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void EmergencyFunctionsError::replaceCcaErrorCode (EmergencyFunctionsErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void EmergencyFunctionsError::setCcaErrorCode (const EmergencyFunctionsErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new EmergencyFunctionsErrorStructure(value);
    }
}

inline bool EmergencyFunctionsError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode EmergencyFunctionsError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "EmergencyFunctionsError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void EmergencyFunctionsError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "EmergencyFunctionsError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void EmergencyFunctionsError::cloneData (const EmergencyFunctionsError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new EmergencyFunctionsErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new EmergencyFunctionsErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void EmergencyFunctionsError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  FANControlStatus::FANControlStatus ()  :
    _FAN (),
    _FANCtrl ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FANControlStatus::FANControlStatus (const FANControlStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _FAN (),
    _FANCtrl ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FANControlStatus::FANControlStatus (const ::heatctrl_main_fi_types::T_FAN& FAN_, const ::heatctrl_main_fi_types::T_FANCtrl& FANCtrl_)  :
    _FAN (FAN_),
    _FANCtrl (FANCtrl_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FANControlStatus::~FANControlStatus() {
}

inline FANControlStatus& FANControlStatus::operator = (const FANControlStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFAN()) {
            setFAN(rhs.getFAN());
        } else {
            clearFAN();
        }
        if (rhs.hasFANCtrl()) {
            setFANCtrl(rhs.getFANCtrl());
        } else {
            clearFANCtrl();
        }
    }
    return *this;
}

inline bool FANControlStatus::operator == (const FANControlStatus& rhs) const {
    return (((!hasFAN() && !rhs.hasFAN()) || getFAN() == rhs.getFAN()) &&
        ((!hasFANCtrl() && !rhs.hasFANCtrl()) || getFANCtrl() == rhs.getFANCtrl()));
}

inline bool FANControlStatus::operator != (const FANControlStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool FANControlStatus::operator < (const FANControlStatus& rhs) const {
    if (hasFAN() || rhs.hasFAN()) {
        if (getFAN() < rhs.getFAN()) return true;
        if (getFAN() > rhs.getFAN()) return false;
    }
    if (hasFANCtrl() || rhs.hasFANCtrl()) {
        if (getFANCtrl() < rhs.getFANCtrl()) return true;
        if (getFANCtrl() > rhs.getFANCtrl()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FANControlStatus::clone() {
    return new FANControlStatus(*this);
}

inline bool FANControlStatus::operator > (const FANControlStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FANControlStatus::clear() {
    clearFAN();
    clearFANCtrl();
}

inline void FANControlStatus::clearFAN() {
    if (hasFAN()) {
         clear_has_FAN();
        _FAN.clear();
     }
}

inline bool FANControlStatus::hasFAN () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::heatctrl_main_fi_types::T_FAN& FANControlStatus::getFAN () const {
    return _FAN;
}

inline ::heatctrl_main_fi_types::T_FAN& FANControlStatus::getFANMutable () {
    set_has_FAN();
    return _FAN;
}

inline void FANControlStatus::setFAN (const ::heatctrl_main_fi_types::T_FAN& FAN_) {
    set_has_FAN();
    this->_FAN = FAN_;
}

inline void FANControlStatus::clearFANCtrl() {
    if (hasFANCtrl()) {
         clear_has_FANCtrl();
        _FANCtrl.clear();
     }
}

inline bool FANControlStatus::hasFANCtrl () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::heatctrl_main_fi_types::T_FANCtrl& FANControlStatus::getFANCtrl () const {
    return _FANCtrl;
}

inline ::heatctrl_main_fi_types::T_FANCtrl& FANControlStatus::getFANCtrlMutable () {
    set_has_FANCtrl();
    return _FANCtrl;
}

inline void FANControlStatus::setFANCtrl (const ::heatctrl_main_fi_types::T_FANCtrl& FANCtrl_) {
    set_has_FANCtrl();
    this->_FANCtrl = FANCtrl_;
}

inline void FANControlStatus::set_has_FAN () {
    _has_bits_[0] |= 1u << 0;
}

inline void FANControlStatus::clear_has_FAN () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FANControlStatus::set_has_FANCtrl () {
    _has_bits_[0] |= 1u << 1;
}

inline void FANControlStatus::clear_has_FANCtrl () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  FANControlSet::FANControlSet ()  :
    _FAN (),
    _FANCtrl ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FANControlSet::FANControlSet (const FANControlSet &rhs)  :
    ::asf::core::Payload(rhs),
    _FAN (),
    _FANCtrl ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FANControlSet::FANControlSet (const ::heatctrl_main_fi_types::T_FANReq& FAN_, const ::heatctrl_main_fi_types::T_FANCtrlReq& FANCtrl_)  :
    _FAN (FAN_),
    _FANCtrl (FANCtrl_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FANControlSet::~FANControlSet() {
}

inline FANControlSet& FANControlSet::operator = (const FANControlSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFAN()) {
            setFAN(rhs.getFAN());
        } else {
            clearFAN();
        }
        if (rhs.hasFANCtrl()) {
            setFANCtrl(rhs.getFANCtrl());
        } else {
            clearFANCtrl();
        }
    }
    return *this;
}

inline bool FANControlSet::operator == (const FANControlSet& rhs) const {
    return (((!hasFAN() && !rhs.hasFAN()) || getFAN() == rhs.getFAN()) &&
        ((!hasFANCtrl() && !rhs.hasFANCtrl()) || getFANCtrl() == rhs.getFANCtrl()));
}

inline bool FANControlSet::operator != (const FANControlSet& rhs) const {
    return ! (*this == rhs);
}

inline bool FANControlSet::operator < (const FANControlSet& rhs) const {
    if (hasFAN() || rhs.hasFAN()) {
        if (getFAN() < rhs.getFAN()) return true;
        if (getFAN() > rhs.getFAN()) return false;
    }
    if (hasFANCtrl() || rhs.hasFANCtrl()) {
        if (getFANCtrl() < rhs.getFANCtrl()) return true;
        if (getFANCtrl() > rhs.getFANCtrl()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FANControlSet::clone() {
    return new FANControlSet(*this);
}

inline bool FANControlSet::operator > (const FANControlSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FANControlSet::clear() {
    clearFAN();
    clearFANCtrl();
}

inline void FANControlSet::clearFAN() {
    if (hasFAN()) {
         clear_has_FAN();
        _FAN.clear();
     }
}

inline bool FANControlSet::hasFAN () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::heatctrl_main_fi_types::T_FANReq& FANControlSet::getFAN () const {
    return _FAN;
}

inline ::heatctrl_main_fi_types::T_FANReq& FANControlSet::getFANMutable () {
    set_has_FAN();
    return _FAN;
}

inline void FANControlSet::setFAN (const ::heatctrl_main_fi_types::T_FANReq& FAN_) {
    set_has_FAN();
    this->_FAN = FAN_;
}

inline void FANControlSet::clearFANCtrl() {
    if (hasFANCtrl()) {
         clear_has_FANCtrl();
        _FANCtrl.clear();
     }
}

inline bool FANControlSet::hasFANCtrl () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::heatctrl_main_fi_types::T_FANCtrlReq& FANControlSet::getFANCtrl () const {
    return _FANCtrl;
}

inline ::heatctrl_main_fi_types::T_FANCtrlReq& FANControlSet::getFANCtrlMutable () {
    set_has_FANCtrl();
    return _FANCtrl;
}

inline void FANControlSet::setFANCtrl (const ::heatctrl_main_fi_types::T_FANCtrlReq& FANCtrl_) {
    set_has_FANCtrl();
    this->_FANCtrl = FANCtrl_;
}

inline void FANControlSet::set_has_FAN () {
    _has_bits_[0] |= 1u << 0;
}

inline void FANControlSet::clear_has_FAN () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FANControlSet::set_has_FANCtrl () {
    _has_bits_[0] |= 1u << 1;
}

inline void FANControlSet::clear_has_FANCtrl () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  FANControlErrorStructure::FANControlErrorStructure ()  :
    _ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FANControlErrorStructure::FANControlErrorStructure (const FANControlErrorStructure &rhs)  :
    _ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FANControlErrorStructure::FANControlErrorStructure (uint32 ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FANControlErrorStructure::~FANControlErrorStructure() {
}

inline FANControlErrorStructure& FANControlErrorStructure::operator = (const FANControlErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool FANControlErrorStructure::operator == (const FANControlErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool FANControlErrorStructure::operator != (const FANControlErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool FANControlErrorStructure::operator < (const FANControlErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if (getErrorCode() < rhs.getErrorCode()) return true;
        if (getErrorCode() > rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool FANControlErrorStructure::operator > (const FANControlErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FANControlErrorStructure::clear() {
    clearErrorCode();
}

inline void FANControlErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = 0u;
     }
}

inline bool FANControlErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 FANControlErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void FANControlErrorStructure::setErrorCode (uint32 ErrorCode_) {
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void FANControlErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void FANControlErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FANControlError::FANControlError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  FANControlError::FANControlError (const FANControlError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  FANControlError::~FANControlError() {
    deleteData ();
}

inline FANControlError& FANControlError::operator = (const FANControlError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool FANControlError::operator == (const FANControlError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool FANControlError::operator != (const FANControlError& rhs) const {
    return ! (*this == rhs);
}

inline bool FANControlError::operator < (const FANControlError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool FANControlError::operator > (const FANControlError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline FANControlError::FANControlErrorField FANControlError::getField () const {
    return __field;
}

inline void FANControlError::setField(FANControlError::FANControlErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* FANControlError::clone() {
    return new FANControlError(*this);
}

inline bool FANControlError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const FANControlErrorStructure& FANControlError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "FANControlError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return FANControlErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline FANControlErrorStructure& FANControlError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "FANControlError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new FANControlErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline FANControlErrorStructure* FANControlError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'FANControlError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new FANControlErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        FANControlErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void FANControlError::replaceCcaErrorCode (FANControlErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void FANControlError::setCcaErrorCode (const FANControlErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new FANControlErrorStructure(value);
    }
}

inline bool FANControlError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode FANControlError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "FANControlError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void FANControlError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "FANControlError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void FANControlError::cloneData (const FANControlError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new FANControlErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new FANControlErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void FANControlError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  FI_FC_HEATCTRL_DEFAULTStart::FI_FC_HEATCTRL_DEFAULTStart ()  :
    _DefaultSettingsGroup (0u),
    _DefaultSettingsMode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FI_FC_HEATCTRL_DEFAULTStart::FI_FC_HEATCTRL_DEFAULTStart (const FI_FC_HEATCTRL_DEFAULTStart &rhs)  :
    ::asf::core::Payload(rhs),
    _DefaultSettingsGroup (0u),
    _DefaultSettingsMode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FI_FC_HEATCTRL_DEFAULTStart::FI_FC_HEATCTRL_DEFAULTStart (uint8 DefaultSettingsGroup_, uint8 DefaultSettingsMode_)  :
    _DefaultSettingsGroup (DefaultSettingsGroup_),
    _DefaultSettingsMode (DefaultSettingsMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FI_FC_HEATCTRL_DEFAULTStart::~FI_FC_HEATCTRL_DEFAULTStart() {
}

inline FI_FC_HEATCTRL_DEFAULTStart& FI_FC_HEATCTRL_DEFAULTStart::operator = (const FI_FC_HEATCTRL_DEFAULTStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDefaultSettingsGroup()) {
            setDefaultSettingsGroup(rhs.getDefaultSettingsGroup());
        } else {
            clearDefaultSettingsGroup();
        }
        if (rhs.hasDefaultSettingsMode()) {
            setDefaultSettingsMode(rhs.getDefaultSettingsMode());
        } else {
            clearDefaultSettingsMode();
        }
    }
    return *this;
}

inline bool FI_FC_HEATCTRL_DEFAULTStart::operator == (const FI_FC_HEATCTRL_DEFAULTStart& rhs) const {
    return (((!hasDefaultSettingsGroup() && !rhs.hasDefaultSettingsGroup()) || getDefaultSettingsGroup() == rhs.getDefaultSettingsGroup()) &&
        ((!hasDefaultSettingsMode() && !rhs.hasDefaultSettingsMode()) || getDefaultSettingsMode() == rhs.getDefaultSettingsMode()));
}

inline bool FI_FC_HEATCTRL_DEFAULTStart::operator != (const FI_FC_HEATCTRL_DEFAULTStart& rhs) const {
    return ! (*this == rhs);
}

inline bool FI_FC_HEATCTRL_DEFAULTStart::operator < (const FI_FC_HEATCTRL_DEFAULTStart& rhs) const {
    if (hasDefaultSettingsGroup() || rhs.hasDefaultSettingsGroup()) {
        if (getDefaultSettingsGroup() < rhs.getDefaultSettingsGroup()) return true;
        if (getDefaultSettingsGroup() > rhs.getDefaultSettingsGroup()) return false;
    }
    if (hasDefaultSettingsMode() || rhs.hasDefaultSettingsMode()) {
        if (getDefaultSettingsMode() < rhs.getDefaultSettingsMode()) return true;
        if (getDefaultSettingsMode() > rhs.getDefaultSettingsMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FI_FC_HEATCTRL_DEFAULTStart::clone() {
    return new FI_FC_HEATCTRL_DEFAULTStart(*this);
}

inline bool FI_FC_HEATCTRL_DEFAULTStart::operator > (const FI_FC_HEATCTRL_DEFAULTStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FI_FC_HEATCTRL_DEFAULTStart::clear() {
    clearDefaultSettingsGroup();
    clearDefaultSettingsMode();
}

inline void FI_FC_HEATCTRL_DEFAULTStart::clearDefaultSettingsGroup() {
    if (hasDefaultSettingsGroup()) {
         clear_has_DefaultSettingsGroup();
        _DefaultSettingsGroup = 0u;
     }
}

inline bool FI_FC_HEATCTRL_DEFAULTStart::hasDefaultSettingsGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 FI_FC_HEATCTRL_DEFAULTStart::getDefaultSettingsGroup () const {
    return _DefaultSettingsGroup;
}

inline void FI_FC_HEATCTRL_DEFAULTStart::setDefaultSettingsGroup (uint8 DefaultSettingsGroup_) {
    set_has_DefaultSettingsGroup();
    this->_DefaultSettingsGroup = DefaultSettingsGroup_;
}

inline void FI_FC_HEATCTRL_DEFAULTStart::clearDefaultSettingsMode() {
    if (hasDefaultSettingsMode()) {
         clear_has_DefaultSettingsMode();
        _DefaultSettingsMode = 0u;
     }
}

inline bool FI_FC_HEATCTRL_DEFAULTStart::hasDefaultSettingsMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 FI_FC_HEATCTRL_DEFAULTStart::getDefaultSettingsMode () const {
    return _DefaultSettingsMode;
}

inline void FI_FC_HEATCTRL_DEFAULTStart::setDefaultSettingsMode (uint8 DefaultSettingsMode_) {
    set_has_DefaultSettingsMode();
    this->_DefaultSettingsMode = DefaultSettingsMode_;
}

inline void FI_FC_HEATCTRL_DEFAULTStart::set_has_DefaultSettingsGroup () {
    _has_bits_[0] |= 1u << 0;
}

inline void FI_FC_HEATCTRL_DEFAULTStart::clear_has_DefaultSettingsGroup () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FI_FC_HEATCTRL_DEFAULTStart::set_has_DefaultSettingsMode () {
    _has_bits_[0] |= 1u << 1;
}

inline void FI_FC_HEATCTRL_DEFAULTStart::clear_has_DefaultSettingsMode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  FI_FC_HEATCTRL_DEFAULTResult::FI_FC_HEATCTRL_DEFAULTResult ()  :
    _DefaultSettingsGroup (0u),
    _DefaultSettingsStatus (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FI_FC_HEATCTRL_DEFAULTResult::FI_FC_HEATCTRL_DEFAULTResult (const FI_FC_HEATCTRL_DEFAULTResult &rhs)  :
    ::asf::core::Payload(rhs),
    _DefaultSettingsGroup (0u),
    _DefaultSettingsStatus (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FI_FC_HEATCTRL_DEFAULTResult::FI_FC_HEATCTRL_DEFAULTResult (uint8 DefaultSettingsGroup_, uint8 DefaultSettingsStatus_)  :
    _DefaultSettingsGroup (DefaultSettingsGroup_),
    _DefaultSettingsStatus (DefaultSettingsStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FI_FC_HEATCTRL_DEFAULTResult::~FI_FC_HEATCTRL_DEFAULTResult() {
}

inline FI_FC_HEATCTRL_DEFAULTResult& FI_FC_HEATCTRL_DEFAULTResult::operator = (const FI_FC_HEATCTRL_DEFAULTResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDefaultSettingsGroup()) {
            setDefaultSettingsGroup(rhs.getDefaultSettingsGroup());
        } else {
            clearDefaultSettingsGroup();
        }
        if (rhs.hasDefaultSettingsStatus()) {
            setDefaultSettingsStatus(rhs.getDefaultSettingsStatus());
        } else {
            clearDefaultSettingsStatus();
        }
    }
    return *this;
}

inline bool FI_FC_HEATCTRL_DEFAULTResult::operator == (const FI_FC_HEATCTRL_DEFAULTResult& rhs) const {
    return (((!hasDefaultSettingsGroup() && !rhs.hasDefaultSettingsGroup()) || getDefaultSettingsGroup() == rhs.getDefaultSettingsGroup()) &&
        ((!hasDefaultSettingsStatus() && !rhs.hasDefaultSettingsStatus()) || getDefaultSettingsStatus() == rhs.getDefaultSettingsStatus()));
}

inline bool FI_FC_HEATCTRL_DEFAULTResult::operator != (const FI_FC_HEATCTRL_DEFAULTResult& rhs) const {
    return ! (*this == rhs);
}

inline bool FI_FC_HEATCTRL_DEFAULTResult::operator < (const FI_FC_HEATCTRL_DEFAULTResult& rhs) const {
    if (hasDefaultSettingsGroup() || rhs.hasDefaultSettingsGroup()) {
        if (getDefaultSettingsGroup() < rhs.getDefaultSettingsGroup()) return true;
        if (getDefaultSettingsGroup() > rhs.getDefaultSettingsGroup()) return false;
    }
    if (hasDefaultSettingsStatus() || rhs.hasDefaultSettingsStatus()) {
        if (getDefaultSettingsStatus() < rhs.getDefaultSettingsStatus()) return true;
        if (getDefaultSettingsStatus() > rhs.getDefaultSettingsStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FI_FC_HEATCTRL_DEFAULTResult::clone() {
    return new FI_FC_HEATCTRL_DEFAULTResult(*this);
}

inline bool FI_FC_HEATCTRL_DEFAULTResult::operator > (const FI_FC_HEATCTRL_DEFAULTResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FI_FC_HEATCTRL_DEFAULTResult::clear() {
    clearDefaultSettingsGroup();
    clearDefaultSettingsStatus();
}

inline void FI_FC_HEATCTRL_DEFAULTResult::clearDefaultSettingsGroup() {
    if (hasDefaultSettingsGroup()) {
         clear_has_DefaultSettingsGroup();
        _DefaultSettingsGroup = 0u;
     }
}

inline bool FI_FC_HEATCTRL_DEFAULTResult::hasDefaultSettingsGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 FI_FC_HEATCTRL_DEFAULTResult::getDefaultSettingsGroup () const {
    return _DefaultSettingsGroup;
}

inline void FI_FC_HEATCTRL_DEFAULTResult::setDefaultSettingsGroup (uint8 DefaultSettingsGroup_) {
    set_has_DefaultSettingsGroup();
    this->_DefaultSettingsGroup = DefaultSettingsGroup_;
}

inline void FI_FC_HEATCTRL_DEFAULTResult::clearDefaultSettingsStatus() {
    if (hasDefaultSettingsStatus()) {
         clear_has_DefaultSettingsStatus();
        _DefaultSettingsStatus = 0u;
     }
}

inline bool FI_FC_HEATCTRL_DEFAULTResult::hasDefaultSettingsStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 FI_FC_HEATCTRL_DEFAULTResult::getDefaultSettingsStatus () const {
    return _DefaultSettingsStatus;
}

inline void FI_FC_HEATCTRL_DEFAULTResult::setDefaultSettingsStatus (uint8 DefaultSettingsStatus_) {
    set_has_DefaultSettingsStatus();
    this->_DefaultSettingsStatus = DefaultSettingsStatus_;
}

inline void FI_FC_HEATCTRL_DEFAULTResult::set_has_DefaultSettingsGroup () {
    _has_bits_[0] |= 1u << 0;
}

inline void FI_FC_HEATCTRL_DEFAULTResult::clear_has_DefaultSettingsGroup () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FI_FC_HEATCTRL_DEFAULTResult::set_has_DefaultSettingsStatus () {
    _has_bits_[0] |= 1u << 1;
}

inline void FI_FC_HEATCTRL_DEFAULTResult::clear_has_DefaultSettingsStatus () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace heatctrl_main_fi

#endif // HEATCTRL_MAIN_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
