/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/dumm/DummService.h"
#include "com/bosch/cm/dumm/DummServiceConst.h"
#include "com/bosch/cm/dumm/DummServiceDBus.h"
#include "com/bosch/cm/dumm/DummServiceJson.h"
#include "com/bosch/cm/dumm/DummServiceStub.h"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace com {
namespace bosch {
namespace cm {
namespace dumm {
namespace DummService {

DEFINE_CLASS_LOGGER("/com/bosch/cm/dumm/com/bosch/cm/dumm/DummService", DummServiceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 10, "uploadData", 1 },
    { 16, "genCorrelationId", 0 },
    { 19, "cancelUploadRequest", 2 },
    { 22, "getUploadRequestStatus", 3 },
};


class DummServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    DummServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    DummServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    DummServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "com.bosch.cm.dumm.DummService"),
          _logger(logger) {}

    virtual ~DummServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void DummServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 4, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'genCorrelationId'

            LOG_DEBUG_STUB("process method '%s'", "genCorrelationId");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GenCorrelationIdRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GenCorrelationId", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GenCorrelationIdRequest > payload = ::boost::static_pointer_cast<GenCorrelationIdRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DummServiceStub*>(getStub())->onGenCorrelationIdRequest(payload);
            return;
        }
        case 1: {

            // method 'uploadData'

            LOG_DEBUG_STUB("process method '%s'", "uploadData");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UploadDataRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UploadData", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UploadDataRequest > payload = ::boost::static_pointer_cast<UploadDataRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DummServiceStub*>(getStub())->onUploadDataRequest(payload);
            return;
        }
        case 2: {

            // method 'cancelUploadRequest'

            LOG_DEBUG_STUB("process method '%s'", "cancelUploadRequest");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelUploadRequestRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "CancelUploadRequest", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CancelUploadRequestRequest > payload = ::boost::static_pointer_cast<CancelUploadRequestRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DummServiceStub*>(getStub())->onCancelUploadRequestRequest(payload);
            return;
        }
        case 3: {

            // method 'getUploadRequestStatus'

            LOG_DEBUG_STUB("process method '%s'", "getUploadRequestStatus");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetUploadRequestStatusRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetUploadRequestStatus", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetUploadRequestStatusRequest > payload = ::boost::static_pointer_cast<GetUploadRequestStatusRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DummServiceStub*>(getStub())->onGetUploadRequestStatusRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* DummServiceStubDelegate::introspect() const {
    return     "<interface name=\"com.bosch.cm.dumm.DummService\">\n"
            "    <method name=\"genCorrelationId\">\n"
            "      <doc>\n"
            "        <line>genCorrelationId = Method to generate the correlation Id</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"CorrelationId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>CorrelationId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"uploadData\">\n"
            "      <doc>\n"
            "        <line>uploadData = Method to upload data</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"jsonUploadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonUploadHeader = Sample jsonUploadHeader</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;UploadFunctionID&quot;:1,</line>\n"
            "          <line>&quot;CorrelationId&quot;:&quot;{CorrelationId}&quot;, //Please refer below comment for the exact format. Method to generate new correlation ID is mentioned above.</line>\n"
            "          <line>&quot;UserId&quot;:&quot;Renault&quot;,</line>\n"
            "          <line>&quot;Token&quot;:&quot;12345&quot;</line>\n"
            "          <line>}</line>\n"
            "          <line></line>\n"
            "          <line>UploadFunctionID - Unique identifier to identify an upload function. Refer to UploadFunctionID.</line>\n"
            "          <line>CorrelationId [Important] - This is used to match the request and response between clients and DUMM service. Clients must send this in the response message to a request (with correlationID) from DUMM service.</line>\n"
            "          <line>+ With Clients upload an Acknowledgement(ACK) message, Client must reuse received CorrelationId from Vnext(Vnext will use this CorrelationId to match correctly).</line>\n"
            "          <line>+ Other cases, Clients must genarate new correlationId by using uuid lib on linux. Refer to: Function getGlobalMessageId(): /ai_midw/components/fc_dumm/sources/appl/common/eventManager/fc_dumm_EventManager_Sender.cpp</line>\n"
            "          <line>the format of correlationId rely on RFC4122 standard: https://www.ietf.org/rfc/rfc4122.txt (like that: xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx)</line>\n"
            "          <line>UserId [Optional] - User ID.</line>\n"
            "          <line>Token [Optional] - Access Token.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"jsonUploadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonUploadData = Refer to UploadFunctionID for sample json message</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"requestInfo\" type=\"(usuu)\">\n"
            "        <doc>\n"
            "          <line>requestInfo = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"cancelUploadRequest\">\n"
            "      <doc>\n"
            "        <line>cancelUploadRequest = Method to cancel a upload request</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"CorrelationId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>CorrelationId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"outRequestInfo\" type=\"(usuu)\">\n"
            "        <doc>\n"
            "          <line>outRequestInfo = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"getUploadRequestStatus\">\n"
            "      <doc>\n"
            "        <line>getUploadRequestStatus = Method to get the current status of a request</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"CorrelationId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>CorrelationId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"outRequestInfo\" type=\"(usuu)\">\n"
            "        <doc>\n"
            "          <line>outRequestInfo = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <signal name=\"mqttConnectionStatus\">\n"
            "      <doc>\n"
            "        <line>mqttConnectionStatus = Signal to inform MQTT connection status change</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"connectionStatus\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>connectionStatus = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"requestStateChanged\">\n"
            "      <doc>\n"
            "        <line>requestStateChanged = Signal to inform request status change</line>\n"
            "        <line>TODO: Need to avoid broadcasting update of a request to all the clients</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"requestInfo\" type=\"(usuu)\">\n"
            "        <doc>\n"
            "          <line>requestInfo = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"serviceActivationAcknowledged\">\n"
            "      <doc>\n"
            "        <line>serviceActivationAcknowledged = Signal to inform ServiceActivationAck</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Sample jsonDownloadHeader</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;CorrelationId&quot;:&quot;2fff6fa91f414229b829e4f612f79a27&quot;,</line>\n"
            "          <line>&quot;UserId&quot;:&quot;Renault&quot;,</line>\n"
            "          <line>&quot;Token&quot;:&quot;12345&quot;</line>\n"
            "          <line>}</line>\n"
            "          <line></line>\n"
            "          <line>CorrelationId [Optional] - This is optional. If present, clients must send this in the response message to this request.</line>\n"
            "          <line>UserId [Optional] - User ID.</line>\n"
            "          <line>Token [Optional] - Access Token.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2018-07-14T19:40:37+0000&quot;,</line>\n"
            "          <line>&quot;ServiceActivation/Data/Status&quot;:&quot;KO&quot;,</line>\n"
            "          <line>&quot;ServiceActivation/Data/ErrorCode&quot;:2</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"remoteDataWipeReceived\">\n"
            "      <doc>\n"
            "        <line>remoteDataWipeReceived = Signal to inform DataWipe</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;Version&quot;:&quot;1&quot;,</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2018-07-14T19:40:37+123Z&quot;,</line>\n"
            "          <line>&quot;DataWipe/Data/Action&quot;:&quot;Wipe&quot;</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"pushMessageReceived\">\n"
            "      <doc>\n"
            "        <line>pushMessageReceived = Signal to inform PushMessage received</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2018-07-14T19:40:37+0000&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/messageIdentifier&quot;:&quot;0&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/b2bSender&quot;:&quot;0&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/serviceSender&quot;:&quot;PushMessageManager&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/userDependent&quot;:&quot;0&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/userIdentifier&quot;:&quot;0&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/messageType&quot;:&quot;0&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/domain&quot;:&quot;Assistance&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/intent&quot;:&quot;inform&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/maximumLifetime&quot;:&quot;2419200&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/textLine1&quot;:&quot;Information&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/textLine2&quot;:&quot;&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/actionButtonNumber&quot;:&quot;0&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/actionButton1&quot;:&quot;Accept&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/actionButton1Description&quot;:&quot;&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/actionButton1Semantics&quot;:&quot;OK&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/actionButton2&quot;:&quot;&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/actionButton2Description&quot;:&quot;&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/actionButton2Semantics&quot;:&quot;&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/targetedApplication&quot;:&quot;Navi&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/invokedFunction&quot;:&quot;guideTo&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/parameterList&quot;:&quot;&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/picture&quot;:&quot;https://www.cdn.renault.com/content/dam/Renault/master/new-logo/renault_french_logo_desktop.png&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/pictureType&quot;:&quot;URL&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/feedbackRequired&quot;:&quot;true&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/HMI_template_ID&quot;:&quot;0&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/priorityLevel&quot;:&quot;50&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/minPriorityLevel&quot;:&quot;0&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/maxPriorityLevel&quot;:&quot;99&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/preDrivePriority&quot;:&quot;50&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/drivingPriority&quot;:&quot;50&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/notDrivingPriority&quot;:&quot;50&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/postDriverPriority&quot;:&quot;50&quot;,</line>\n"
            "          <line>&quot;PushMessage/Data/behaviorWhileDriving&quot;:&quot;Driving&quot;</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"pushMessageDelete\">\n"
            "      <doc>\n"
            "        <line>pushMessageDelete = Signal to inform PushMessageDelete</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2018-07-14T19:40:37+0000&quot;,</line>\n"
            "          <line>&quot;PushMessageDelete/Data/messageIdentifier&quot;:&quot;0&quot;,</line>\n"
            "          <line>&quot;PushMessageDelete/Data/userDependent&quot;:&quot;false&quot;,</line>\n"
            "          <line>&quot;PushMessageDelete/Data/userIdentifier&quot;:&quot;0&quot;</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"pushMessageUpdate\">\n"
            "      <doc>\n"
            "        <line>pushMessageUpdate = Signal to inform PushMessageUpdate</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2018-07-14T19:40:37+0000&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/messageIdentifier&quot;:&quot;0&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/userDependent&quot;:&quot;False&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/userIdentifier&quot;:&quot;0&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/intent&quot;:&quot;inform&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/maximumLifetime&quot;:&quot;2419200&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/textLine1&quot;:&quot;Information&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/textLine2&quot;:&quot;&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/actionButtonNumber&quot;:&quot;0&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/actionButton1&quot;:&quot;Accept&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/actionButton1Description&quot;:&quot;&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/actionButton1Semantics&quot;:&quot;OK&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/actionButton2&quot;:&quot;&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/actionButton2Description&quot;:&quot;&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/actionButton2Semantics&quot;:&quot;&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/targetedApplication&quot;:&quot;Navi&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/invokedFunction&quot;:&quot;guideTo&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/parameterList&quot;:&quot;&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/picture&quot;:&quot;https://www.cdn.renault.com/content/dam/Renault/master/new-logo/renault_french_logo_desktop.png&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/pictureType&quot;:&quot;URL&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/feedback required&quot;:&quot;true&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/HMI_template_ID&quot;:&quot;0&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/priorityLevel&quot;:&quot;50&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/minPriorityLevel&quot;:&quot;0&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/maxPriorityLevel&quot;:&quot;99&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/preDrivePriority&quot;:&quot;50&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/drivingPriority&quot;:&quot;50&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/notDrivingPriority&quot;:&quot;50&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/postDriverPriority&quot;:&quot;50&quot;,</line>\n"
            "          <line>&quot;PushMessageUpdate/Data/behaviorWhileDriving&quot;:&quot;Driving&quot;</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"xCALL_POI_Received\">\n"
            "      <doc>\n"
            "        <line>xCALL_POI_Received = Signal to inform xCALL to alliance_telematics</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"xCallType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>xCallType = Refer to XCallType</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"RemoteDataWipe\">\n"
            "      <doc>\n"
            "        <line>RemoteDataWipe = Signal to inform Remote Data Wipe</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;Version&quot;:&quot;1&quot;,</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2016-07-27T09:37:14Z&quot;,</line>\n"
            "          <line>&quot;DataWipe/Data/Action&quot;:&quot;Wipe&quot;</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"profileSyncResponse\">\n"
            "      <doc>\n"
            "        <line>profileSyncResponse = Signal to inform ProfileSyncResponse</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2018-07-14T19:40:37+0000&quot;,</line>\n"
            "          <line>&quot;NewSyncTimeStamp&quot;:&quot;2018-07-14T19:40:37+0000&quot;,</line>\n"
            "          <line>&quot;Status&quot;:0,</line>\n"
            "          <line>&quot;ErrorCode&quot;:2,</line>\n"
            "          <line>&quot;UserProfile/Custom/MeterLanguageStatus&quot;:{</line>\n"
            "          <line>&quot;val&quot;:0,</line>\n"
            "          <line>&quot;ts&quot;:&quot;2018-07-14T19:43:37+123Z&quot;</line>\n"
            "          <line>},</line>\n"
            "          <line>&quot;UserProfile/Custom/MEXModeState&quot;:{</line>\n"
            "          <line>&quot;val&quot;:&quot;0&quot;,</line>\n"
            "          <line>&quot;ts&quot;:&quot;2018-07-14T19:43:37+123Z&quot;</line>\n"
            "          <line>}</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"profileSyncNeeded\">\n"
            "      <doc>\n"
            "        <line>profileSyncNeeded = Signal to inform ProfileSyncNeeded</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2018-07-14T19:40:37+0000&quot;</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"profileRemoteLinkResponse\">\n"
            "      <doc>\n"
            "        <line>profileRemoteLinkResponse = Signal to inform RemoteLinkResponse</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;Version&quot;:&quot;1&quot;,</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2018-07-14T19:40:37+123Z&quot;,</line>\n"
            "          <line>&quot;RemoteOrder/Received/UPRemoteLink/Action&quot;:&quot;Link&quot;,</line>\n"
            "          <line>&quot;RemoteOrder/Received/UPRemoteLink/CloudSettings&quot;:&quot;Yes&quot;</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"profileRemoteReset\">\n"
            "      <doc>\n"
            "        <line>profileRemoteReset = Signal to inform RemoteReset</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;Version&quot;:&quot;1&quot;,</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2018-07-14T19:40:37+123Z&quot;,</line>\n"
            "          <line>&quot;RemoteOrder/Received/UPRemoteReset/Action&quot;:&quot;Reset&quot;</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"profileLocalLinkAck\">\n"
            "      <doc>\n"
            "        <line>profileLocalLinkAck = Signal to inform UPLocalLink Ack</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2018-07-14T19:40:37+0000&quot;,</line>\n"
            "          <line>&quot;RemoteOrder/Received/ACK/UPLocalLink/Status&quot;:1,</line>\n"
            "          <line>&quot;RemoteOrder/Received/ACK/UPLocalLink/CloudSettings&quot;:&quot;Yes&quot;</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"profileLocalUnLinkAck\">\n"
            "      <doc>\n"
            "        <line>profileLocalUnLinkAck = Signal to inform UPLocalUnLink Ack</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2018-07-14T19:40:37+0000&quot;,</line>\n"
            "          <line>&quot;RemoteOrder/Received/ACK/UPLocalUnLink/Status&quot;:0,</line>\n"
            "          <line>&quot;RemoteOrder/Received/ACK/UPLocalUnLink/ErrorCode&quot;:2</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"EVPresoakAVNextSynchroResp\">\n"
            "      <doc>\n"
            "        <line>EVPresoakAVNextSynchroResp = Signal to inform EVPresoakAVNextSynchroResp</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2016-07-27T09:37:14Z&quot;,</line>\n"
            "          <line>&quot;NewSyncTimeStamp&quot;:&quot;2016-07-27T09:37:14Z&quot;,</line>\n"
            "          <line>&quot;Status&quot;:0,</line>\n"
            "          <line>&quot;ErrorCode&quot;:2,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/Presoak/Calendar1/ActivationState&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar1/ArrivalHour&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar1/ArrivalMinute&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar1/Monday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar1/Tuesday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar1/Wednesday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar1/Thursday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar1/Friday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar1/Saturday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar1/Sunday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/Presoak/Calendar2/ActivationState&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar2/ArrivalHour&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar2/ArrivalMinute&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar2/Monday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar2/Tuesday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar2/Wednesday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar2/Thursday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar2/Friday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar2/Saturday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar2/Sunday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/Presoak/Calendar3/ActivationState&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar3/ArrivalHour&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar3/ArrivalMinute&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar3/Monday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar3/Tuesday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar3/Wednesday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar3/Thursday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar3/Friday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar3/Saturday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar3/Sunday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/Presoak/Calendar4/ActivationState&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar4/ArrivalHour&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar4/ArrivalMinute&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar4/Monday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar4/Tuesday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar4/Wednesday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar4/Thursday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar4/Friday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar4/Saturday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar4/Sunday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/Presoak/Calendar5/ActivationState&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar5/ArrivalHour&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar5/ArrivalMinute&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar5/Monday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar5/Tuesday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar5/Wednesday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar5/Thursday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar5/Friday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar5/Saturday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/PreSoak/Calendar5/Sunday&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/Presoak/TimeStamp&quot;:&quot;2016-07-27T09:37:14Z&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/HVAC/Presoak/PreSoakTempValue_MMI&quot;:23</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"EVPresoakAVNextSynchroNeeded\">\n"
            "      <doc>\n"
            "        <line>EVPresoakAVNextSynchroNeeded = Signal to inform EVPresoakAVNextSynchroNeeded</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2016-07-27T09:37:14Z&quot;</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"EVChargeAVNextSynchroResp\">\n"
            "      <doc>\n"
            "        <line>EVChargeAVNextSynchroResp = Signal to inform EVChargeAVNextSynchroResp</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2016-07-27T09:37:14Z&quot;,</line>\n"
            "          <line>&quot;NewSyncTimeStamp&quot;:&quot;2016-07-27T09:37:14Z&quot;,</line>\n"
            "          <line>&quot;Status&quot;:0,</line>\n"
            "          <line>&quot;ErrorCode&quot;:2,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/ProgrammedStatus&quot;:&quot;Always authorized charge&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/DelayedValue&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/ActivationState1&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/BeginHour1&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/BeginMinute1&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Duration1&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Monday1&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Tuesday1&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Wednesday1&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Thursday1&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Friday1&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Saturday1&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Sunday1&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/ActivationState2&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/BeginHour2&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/BeginMinute2&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Duration2&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Monday2&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Tuesday2&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Wednesday2&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Thursday2&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Friday2&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Saturday2&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Sunday2&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/ActivationState3&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/BeginHour3&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/BeginMinute3&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Duration3&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Monday3&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Tuesday3&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Wednesday3&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Thursday3&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Friday3&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Saturday3&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Sunday3&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/ActivationState4&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/BeginHour4&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/BeginMinute4&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Duration4&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Monday4&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Tuesday4&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Wednesday4&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Thursday4&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Friday4&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Saturday4&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Sunday4&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/ActivationState5&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/BeginHour5&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/BeginMinute5&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Duration5&quot;:0,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Monday5&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Tuesday5&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Wednesday5&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Thursday5&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Friday5&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Saturday5&quot;:&quot;NO&quot;,</line>\n"
            "          <line>&quot;Vehicle/Received/EVCharge/Sunday5&quot;:&quot;NO&quot;</line>\n"
            "          <line></line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"EVChargeAVNextSynchroNeeded\">\n"
            "      <doc>\n"
            "        <line>EVChargeAVNextSynchroNeeded = Signal to inform EVChargeAVNextSynchroNeeded</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2016-07-27T09:37:14Z&quot;</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"remotePushE2E_POIAck\">\n"
            "      <doc>\n"
            "        <line>remotePushE2E_POIAck = Signal to inform E2E_POI Ack</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2016-07-27T09:37:14Z&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/Name1&quot;:&quot;RN Showroom&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/TTS1&quot;:&quot;Hello&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/Address1&quot;:&quot;Renault Nissan Techno Center&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/PhoneNumber1&quot;:&quot;133166363&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/Latitude1&quot;:40.7127837,</line>\n"
            "          <line>&quot;E2E/Sent/POI/Longitude1&quot;:-74.0059413,</line>\n"
            "          <line>&quot;E2E/Sent/POI/LatitudeMode1&quot;:&quot;South&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/LongitudeMode1&quot;:&quot;East&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/LocationType1&quot;:&quot;Tokyo&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/Name2&quot;:&quot;RN Showroom&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/TTS2&quot;:&quot;Hello&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/Address2&quot;:&quot;Renault Nissan Techno Center&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/PhoneNumber2&quot;:&quot;133166363&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/Latitude2&quot;:40.7127837,</line>\n"
            "          <line>&quot;E2E/Sent/POI/Longitude2&quot;:-74.0059413,</line>\n"
            "          <line>&quot;E2E/Sent/POI/LatitudeMode2&quot;:&quot;South&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/LongitudeMode2&quot;:&quot;East&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/LocationType2&quot;:&quot;Tokyo&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/Name3&quot;:&quot;RN Showroom&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/TTS3&quot;:&quot;Hello&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/Address3&quot;:&quot;Renault Nissan Techno Center&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/PhoneNumber3&quot;:&quot;133166363&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/Latitude3&quot;:40.7127837,</line>\n"
            "          <line>&quot;E2E/Sent/POI/Longitude3&quot;:-74.0059413,</line>\n"
            "          <line>&quot;E2E/Sent/POI/LatitudeMode3&quot;:&quot;South&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/LongitudeMode3&quot;:&quot;East&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/LocationType3&quot;:&quot;Tokyo&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/Name4&quot;:&quot;RN Showroom&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/TTS4&quot;:&quot;Hello&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/Address4&quot;:&quot;Renault Nissan Techno Center&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/PhoneNumber4&quot;:&quot;133166363&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/Latitude4&quot;:40.7127837,</line>\n"
            "          <line>&quot;E2E/Sent/POI/Longitude4&quot;:-74.0059413,</line>\n"
            "          <line>&quot;E2E/Sent/POI/LatitudeMode4&quot;:&quot;South&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/LongitudeMode4&quot;:&quot;East&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/LocationType4&quot;:&quot;Tokyo&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/Name5&quot;:&quot;RN Showroom&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/TTS5&quot;:&quot;Hello&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/Address5&quot;:&quot;Renault Nissan Techno Center&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/PhoneNumber5&quot;:&quot;133166363&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/Latitude5&quot;:40.7127837,</line>\n"
            "          <line>&quot;E2E/Sent/POI/Longitude5&quot;:-74.0059413,</line>\n"
            "          <line>&quot;E2E/Sent/POI/LatitudeMode5&quot;:&quot;South&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/LongitudeMode5&quot;:&quot;East&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/LocationType5&quot;:&quot;Tokyo&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/Name6&quot;:&quot;RN Showroom&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/TTS6&quot;:&quot;Hello&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/Address6&quot;:&quot;Renault Nissan Techno Center&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/PhoneNumber6&quot;:&quot;133166363&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/Latitude6&quot;:40.7127837,</line>\n"
            "          <line>&quot;E2E/Sent/POI/Longitude6&quot;:-74.0059413,</line>\n"
            "          <line>&quot;E2E/Sent/POI/LatitudeMode6&quot;:&quot;South&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/LongitudeMode6&quot;:&quot;East&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/POI/LocationType6&quot;:&quot;Tokyo&quot;</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"remotePushE2E_Destination\">\n"
            "      <doc>\n"
            "        <line>remotePushE2E_Destination = Signal to inform remotePush E2E_Destination</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2016-07-27T09:37:14Z&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/DownloadTrafficInfo&quot;:&quot;Yes&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/Name1&quot;:&quot;RN Showroom&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/TTS1&quot;:&quot;Hello&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/Address1&quot;:&quot;Renault Nissan Techno Center&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/PhoneNumber1&quot;:&quot;133166363&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/Latitude1&quot;:40.7127837,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/Longitude1&quot;:-74.0059413,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/LatitudeMode1&quot;:&quot;South&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/LongitudeMode1&quot;:&quot;East&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/LocationType1&quot;:&quot;Tokyo&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/CalculationCondition1&quot;:&quot;EcoRoute&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/Name2&quot;:&quot;RN Showroom&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/TTS2&quot;:&quot;Hello&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/Address2&quot;:&quot;Renault Nissan Techno Center&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/PhoneNumber2&quot;:&quot;133166363&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/Latitude2&quot;:40.7127837,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/Longitude2&quot;:-74.0059413,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/LatitudeMode2&quot;:&quot;South&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/LongitudeMode2&quot;:&quot;East&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/LocationType2&quot;:&quot;Tokyo&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/CalculationCondition2&quot;:&quot;EcoRoute&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/Name3&quot;:&quot;RN Showroom&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/TTS3&quot;:&quot;Hello&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/Address3&quot;:&quot;Renault Nissan Techno Center&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/PhoneNumber3&quot;:&quot;133166363&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/Latitude3&quot;:40.7127837,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/Longitude3&quot;:-74.0059413,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/LatitudeMode3&quot;:&quot;South&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/LongitudeMode3&quot;:&quot;East&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/LocationType3&quot;:&quot;Tokyo&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/CalculationCondition3&quot;:&quot;EcoRoute&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/Name4&quot;:&quot;RN Showroom&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/TTS4&quot;:&quot;Hello&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/Address4&quot;:&quot;Renault Nissan Techno Center&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/PhoneNumber4&quot;:&quot;133166363&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/Latitude4&quot;:40.7127837,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/Longitude4&quot;:-74.0059413,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/LatitudeMode4&quot;:&quot;South&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/LongitudeMode4&quot;:&quot;East&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/LocationType4&quot;:&quot;Tokyo&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/CalculationCondition4&quot;:&quot;EcoRoute&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/Name5&quot;:&quot;RN Showroom&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/TTS5&quot;:&quot;Hello&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/Address5&quot;:&quot;Renault Nissan Techno Center&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/PhoneNumber5&quot;:&quot;133166363&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/Latitude5&quot;:40.7127837,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/Longitude5&quot;:-74.0059413,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/LatitudeMode5&quot;:&quot;South&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/LongitudeMode5&quot;:&quot;East&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/LocationType5&quot;:&quot;Tokyo&quot;,</line>\n"
            "          <line>&quot;E2E/Sent/Destination/CalculationCondition5&quot;:&quot;EcoRoute&quot;</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"ManagedApps_RemoteOrder\">\n"
            "      <doc>\n"
            "        <line>ManagedApps_RemoteOrder = Signal to inform Remote Order Managed Apps</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;Version&quot;:&quot;1&quot;,</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2016-07-27T09:37:14Z&quot;</line>\n"
            "          <line></line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"ManagedApps_RemoteRequest\">\n"
            "      <doc>\n"
            "        <line>ManagedApps_RemoteRequest = Signal to inform Remote Request Managed Apps</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2016-07-27T09:37:14Z&quot;</line>\n"
            "          <line>&quot;ManagedApps/Received/RemoteRequest/Parameters&quot;:&quot;0&quot;</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"ManagedApps_RemoteSetting\">\n"
            "      <doc>\n"
            "        <line>ManagedApps_RemoteSetting = Signal to inform Remote Setting Managed Apps</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2016-07-27T09:37:14Z&quot;</line>\n"
            "          <line>&quot;ManagedApps_[1..20]/Received/RemoteSetting/Parameters&quot;:&quot;values&quot;</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"VPALogs\">\n"
            "      <doc>\n"
            "        <line>VPALogs = Signal to inform VPALogs</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2016-07-27T09:37:14Z&quot;</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"VPATelemetry\">\n"
            "      <doc>\n"
            "        <line>VPATelemetry = Signal to inform VPATelemetry</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2016-07-27T09:37:14Z&quot;</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"ValetMode\">\n"
            "      <doc>\n"
            "        <line>ValetMode = Signal to inform ValetMode</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;Version&quot;:&quot;1&quot;,</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2016-07-27T09:37:14Z&quot;,</line>\n"
            "          <line>&quot;ValetMode/Received/RemoteOrder/Action&quot;:&quot;1&quot;</line>\n"
            "          <line></line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"LogActivation\">\n"
            "      <doc>\n"
            "        <line>LogActivation = Signal to inform LogActivation</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2016-07-27T09:37:14Z&quot;,</line>\n"
            "          <line>&quot;Log/Received/RemoteOrder/LogType&quot;:&quot;0&quot;,</line>\n"
            "          <line>&quot;Log/Received/RemoteOrder/Command&quot;:&quot;0&quot;,</line>\n"
            "          <line>&quot;Log/Received/RemoteOrder/ComponentName&quot;:&quot;1&quot;,</line>\n"
            "          <line>&quot;Log/Received/RemoteOrder/LogLevel&quot;:&quot;T&quot;,</line>\n"
            "          <line>&quot;Log/Received/RemoteOrder/LogId&quot;:&quot;1&quot;,</line>\n"
            "          <line>&quot;Log/Received/RemoteOrder/StartDate&quot;:&quot;0&quot;,</line>\n"
            "          <line>&quot;Log/Received/RemoteOrder/EndDate&quot;:&quot;0&quot;</line>\n"
            "          <line></line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"LogRequest\">\n"
            "      <doc>\n"
            "        <line>LogRequest = Signal to inform LogRequest</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2016-07-27T09:37:14Z&quot;,</line>\n"
            "          <line>&quot;Log/Received/RemoteRequest/LogType&quot;:&quot;0&quot;,</line>\n"
            "          <line>&quot;Log/Received/RemoteRequest/ComponentName&quot;:&quot;VPA&quot;,</line>\n"
            "          <line>&quot;Log/Received/RemoteRequest/LogLevel&quot;:&quot;T&quot;,</line>\n"
            "          <line>&quot;Log/Received/RemoteRequest/LogBufferClean&quot;:&quot;0&quot;</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"LogTune\">\n"
            "      <doc>\n"
            "        <line>LogTune = Signal to inform LogTune</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2016-07-27T09:37:14Z&quot;,</line>\n"
            "          <line>&quot;Log/Received/RemoteSetting/LogId&quot;:0,</line>\n"
            "          <line>&quot;Log/Received/RemoteSetting/LogBody&quot;:&quot;0&quot;,</line>\n"
            "          <line>&quot;Log/Received/RemoteSetting/LogTriggers&quot;:&quot;periodic&quot;,</line>\n"
            "          <line>&quot;Log/Received/RemoteSetting/LogPriority&quot;:&quot;1&quot;,</line>\n"
            "          <line>&quot;Log/Received/RemoteSetting/LogCategory&quot;:&quot;1&quot;,</line>\n"
            "          <line>&quot;Log/Received/RemoteSetting/LogGatheringPeriodicity&quot;:0,</line>\n"
            "          <line>&quot;Log/Received/RemoteSetting/LogSendingPeriodicity&quot;:0,</line>\n"
            "          <line>&quot;Log/Received/RemoteSetting/StartDate&quot;:&quot;0&quot;,</line>\n"
            "          <line>&quot;Log/Received/RemoteSetting/EndDate&quot;:&quot;0&quot;</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"LogSetProbeVerbosity\">\n"
            "      <doc>\n"
            "        <line>LogSetProbeVerbosity = Signal to inform LogSetProbeVerbosity</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2016-07-27T09:37:14Z&quot;,</line>\n"
            "          <line>&quot;Log/Received/RemoteSetting/LogSetProbeVerbosityId&quot;:&quot;0&quot;,</line>\n"
            "          <line>&quot;Log/Received/RemoteSetting/LogSetProbeVerbosityFreq&quot;:&quot;0&quot;</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"LogSetSLogBufferSize\">\n"
            "      <doc>\n"
            "        <line>LogSetSLogBufferSize = Signal to inform LogSetSLogBufferSize</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2016-07-27T09:37:14Z&quot;,</line>\n"
            "          <line>&quot;Log/Received/RemoteSetting/LogBufferName&quot;:&quot;0&quot;,</line>\n"
            "          <line>&quot;Log/Received/RemoteSetting/LogBufferSize&quot;:&quot;0&quot;</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"LogSetDefaultLogConfig\">\n"
            "      <doc>\n"
            "        <line>LogSetDefaultLogConfig = Signal to inform LogSetDefaultLogConfig</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2016-07-27T09:37:14Z&quot;,</line>\n"
            "          <line>&quot;Log/Received/RemoteSetting/LogConfigFile&quot;:&quot;0&quot;</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"MapInstallRequestACK\">\n"
            "      <doc>\n"
            "        <line>MapInstallRequestACK = Signal to inform Navigation - Map Install Request ACK</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2016-07-27T09:37:14Z&quot;,</line>\n"
            "          <line>&quot;RemoteOrder/Received/ACK/MapInstallRequest/Status&quot;:0,</line>\n"
            "          <line>&quot;RemoteOrder/Received/ACK/MapInstallRequest/ErrorCode&quot;:2</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"MapInstallStatusRequestACK\">\n"
            "      <doc>\n"
            "        <line>MapInstallStatusRequestACK = Signal to inform Navigation - Map Install Status Request ACK</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadHeader\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadHeader = Refer to jsonDownloadHeader of serviceActivationAcknowledged</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"jsonDownloadData\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>jsonDownloadData = Sample jsonDownloadData</line>\n"
            "          <line>{</line>\n"
            "          <line>&quot;TimeStamp&quot;:&quot;2016-07-27T09:37:14Z&quot;,</line>\n"
            "          <line>&quot;RemoteOrder/Received/ACK/MapInstallRequest/Status&quot;:0,</line>\n"
            "          <line>&quot;RemoteOrder/Received/ACK/MapInstallRequest/ErrorCode&quot;:2</line>\n"
            "          <line>}</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "</interface>\n";
}

void DummServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<DummServiceStub*>(getStub()))->onGetAll (properties);
}

void DummServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void DummServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

DummServiceStub::DummServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new DummServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

DummServiceStub::DummServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new DummServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

DummServiceStub::~DummServiceStub() {
    delete _stubDelegate;
}

void DummServiceStub::sendMqttConnectionStatusSignal(ConnectionStatus connectionStatus) {
    if (_stubDelegate->isConnected()) {
        MqttConnectionStatusSignal* payload = new MqttConnectionStatusSignal(connectionStatus);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "mqttConnectionStatus", MqttConnectionStatusSignal, payload)
        LOG_INFO ("-> send%sSignal", "MqttConnectionStatus");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "MqttConnectionStatus");
    }
}

void DummServiceStub::sendRequestStateChangedSignal(const RequestInfo& requestInfo) {
    if (_stubDelegate->isConnected()) {
        RequestStateChangedSignal* payload = new RequestStateChangedSignal(requestInfo);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "requestStateChanged", RequestStateChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "RequestStateChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "RequestStateChanged");
    }
}

void DummServiceStub::sendServiceActivationAcknowledgedSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        ServiceActivationAcknowledgedSignal* payload = new ServiceActivationAcknowledgedSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "serviceActivationAcknowledged", ServiceActivationAcknowledgedSignal, payload)
        LOG_INFO ("-> send%sSignal", "ServiceActivationAcknowledged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ServiceActivationAcknowledged");
    }
}

void DummServiceStub::sendRemoteDataWipeReceivedSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        RemoteDataWipeReceivedSignal* payload = new RemoteDataWipeReceivedSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "remoteDataWipeReceived", RemoteDataWipeReceivedSignal, payload)
        LOG_INFO ("-> send%sSignal", "RemoteDataWipeReceived");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "RemoteDataWipeReceived");
    }
}

void DummServiceStub::sendPushMessageReceivedSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        PushMessageReceivedSignal* payload = new PushMessageReceivedSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "pushMessageReceived", PushMessageReceivedSignal, payload)
        LOG_INFO ("-> send%sSignal", "PushMessageReceived");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "PushMessageReceived");
    }
}

void DummServiceStub::sendPushMessageDeleteSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        PushMessageDeleteSignal* payload = new PushMessageDeleteSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "pushMessageDelete", PushMessageDeleteSignal, payload)
        LOG_INFO ("-> send%sSignal", "PushMessageDelete");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "PushMessageDelete");
    }
}

void DummServiceStub::sendPushMessageUpdateSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        PushMessageUpdateSignal* payload = new PushMessageUpdateSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "pushMessageUpdate", PushMessageUpdateSignal, payload)
        LOG_INFO ("-> send%sSignal", "PushMessageUpdate");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "PushMessageUpdate");
    }
}

void DummServiceStub::sendXCALL_POI_ReceivedSignal(const ::std::string& jsonDownloadHeader, XCallType xCallType, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        XCALL_POI_ReceivedSignal* payload = new XCALL_POI_ReceivedSignal(jsonDownloadHeader, xCallType, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "xCALL_POI_Received", XCALL_POI_ReceivedSignal, payload)
        LOG_INFO ("-> send%sSignal", "XCALL_POI_Received");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "XCALL_POI_Received");
    }
}

void DummServiceStub::sendRemoteDataWipeSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        RemoteDataWipeSignal* payload = new RemoteDataWipeSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "RemoteDataWipe", RemoteDataWipeSignal, payload)
        LOG_INFO ("-> send%sSignal", "RemoteDataWipe");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "RemoteDataWipe");
    }
}

void DummServiceStub::sendProfileSyncResponseSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        ProfileSyncResponseSignal* payload = new ProfileSyncResponseSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "profileSyncResponse", ProfileSyncResponseSignal, payload)
        LOG_INFO ("-> send%sSignal", "ProfileSyncResponse");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ProfileSyncResponse");
    }
}

void DummServiceStub::sendProfileSyncNeededSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        ProfileSyncNeededSignal* payload = new ProfileSyncNeededSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "profileSyncNeeded", ProfileSyncNeededSignal, payload)
        LOG_INFO ("-> send%sSignal", "ProfileSyncNeeded");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ProfileSyncNeeded");
    }
}

void DummServiceStub::sendProfileRemoteLinkResponseSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        ProfileRemoteLinkResponseSignal* payload = new ProfileRemoteLinkResponseSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "profileRemoteLinkResponse", ProfileRemoteLinkResponseSignal, payload)
        LOG_INFO ("-> send%sSignal", "ProfileRemoteLinkResponse");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ProfileRemoteLinkResponse");
    }
}

void DummServiceStub::sendProfileRemoteResetSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        ProfileRemoteResetSignal* payload = new ProfileRemoteResetSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "profileRemoteReset", ProfileRemoteResetSignal, payload)
        LOG_INFO ("-> send%sSignal", "ProfileRemoteReset");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ProfileRemoteReset");
    }
}

void DummServiceStub::sendProfileLocalLinkAckSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        ProfileLocalLinkAckSignal* payload = new ProfileLocalLinkAckSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "profileLocalLinkAck", ProfileLocalLinkAckSignal, payload)
        LOG_INFO ("-> send%sSignal", "ProfileLocalLinkAck");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ProfileLocalLinkAck");
    }
}

void DummServiceStub::sendProfileLocalUnLinkAckSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        ProfileLocalUnLinkAckSignal* payload = new ProfileLocalUnLinkAckSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "profileLocalUnLinkAck", ProfileLocalUnLinkAckSignal, payload)
        LOG_INFO ("-> send%sSignal", "ProfileLocalUnLinkAck");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ProfileLocalUnLinkAck");
    }
}

void DummServiceStub::sendEVPresoakAVNextSynchroRespSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        EVPresoakAVNextSynchroRespSignal* payload = new EVPresoakAVNextSynchroRespSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "EVPresoakAVNextSynchroResp", EVPresoakAVNextSynchroRespSignal, payload)
        LOG_INFO ("-> send%sSignal", "EVPresoakAVNextSynchroResp");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "EVPresoakAVNextSynchroResp");
    }
}

void DummServiceStub::sendEVPresoakAVNextSynchroNeededSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        EVPresoakAVNextSynchroNeededSignal* payload = new EVPresoakAVNextSynchroNeededSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "EVPresoakAVNextSynchroNeeded", EVPresoakAVNextSynchroNeededSignal, payload)
        LOG_INFO ("-> send%sSignal", "EVPresoakAVNextSynchroNeeded");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "EVPresoakAVNextSynchroNeeded");
    }
}

void DummServiceStub::sendEVChargeAVNextSynchroRespSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        EVChargeAVNextSynchroRespSignal* payload = new EVChargeAVNextSynchroRespSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "EVChargeAVNextSynchroResp", EVChargeAVNextSynchroRespSignal, payload)
        LOG_INFO ("-> send%sSignal", "EVChargeAVNextSynchroResp");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "EVChargeAVNextSynchroResp");
    }
}

void DummServiceStub::sendEVChargeAVNextSynchroNeededSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        EVChargeAVNextSynchroNeededSignal* payload = new EVChargeAVNextSynchroNeededSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "EVChargeAVNextSynchroNeeded", EVChargeAVNextSynchroNeededSignal, payload)
        LOG_INFO ("-> send%sSignal", "EVChargeAVNextSynchroNeeded");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "EVChargeAVNextSynchroNeeded");
    }
}

void DummServiceStub::sendRemotePushE2E_POIAckSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        RemotePushE2E_POIAckSignal* payload = new RemotePushE2E_POIAckSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "remotePushE2E_POIAck", RemotePushE2E_POIAckSignal, payload)
        LOG_INFO ("-> send%sSignal", "RemotePushE2E_POIAck");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "RemotePushE2E_POIAck");
    }
}

void DummServiceStub::sendRemotePushE2E_DestinationSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        RemotePushE2E_DestinationSignal* payload = new RemotePushE2E_DestinationSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "remotePushE2E_Destination", RemotePushE2E_DestinationSignal, payload)
        LOG_INFO ("-> send%sSignal", "RemotePushE2E_Destination");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "RemotePushE2E_Destination");
    }
}

void DummServiceStub::sendManagedApps_RemoteOrderSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        ManagedApps_RemoteOrderSignal* payload = new ManagedApps_RemoteOrderSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ManagedApps_RemoteOrder", ManagedApps_RemoteOrderSignal, payload)
        LOG_INFO ("-> send%sSignal", "ManagedApps_RemoteOrder");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ManagedApps_RemoteOrder");
    }
}

void DummServiceStub::sendManagedApps_RemoteRequestSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        ManagedApps_RemoteRequestSignal* payload = new ManagedApps_RemoteRequestSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ManagedApps_RemoteRequest", ManagedApps_RemoteRequestSignal, payload)
        LOG_INFO ("-> send%sSignal", "ManagedApps_RemoteRequest");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ManagedApps_RemoteRequest");
    }
}

void DummServiceStub::sendManagedApps_RemoteSettingSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        ManagedApps_RemoteSettingSignal* payload = new ManagedApps_RemoteSettingSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ManagedApps_RemoteSetting", ManagedApps_RemoteSettingSignal, payload)
        LOG_INFO ("-> send%sSignal", "ManagedApps_RemoteSetting");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ManagedApps_RemoteSetting");
    }
}

void DummServiceStub::sendVPALogsSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        VPALogsSignal* payload = new VPALogsSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "VPALogs", VPALogsSignal, payload)
        LOG_INFO ("-> send%sSignal", "VPALogs");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "VPALogs");
    }
}

void DummServiceStub::sendVPATelemetrySignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        VPATelemetrySignal* payload = new VPATelemetrySignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "VPATelemetry", VPATelemetrySignal, payload)
        LOG_INFO ("-> send%sSignal", "VPATelemetry");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "VPATelemetry");
    }
}

void DummServiceStub::sendValetModeSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        ValetModeSignal* payload = new ValetModeSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ValetMode", ValetModeSignal, payload)
        LOG_INFO ("-> send%sSignal", "ValetMode");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ValetMode");
    }
}

void DummServiceStub::sendLogActivationSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        LogActivationSignal* payload = new LogActivationSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "LogActivation", LogActivationSignal, payload)
        LOG_INFO ("-> send%sSignal", "LogActivation");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "LogActivation");
    }
}

void DummServiceStub::sendLogRequestSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        LogRequestSignal* payload = new LogRequestSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "LogRequest", LogRequestSignal, payload)
        LOG_INFO ("-> send%sSignal", "LogRequest");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "LogRequest");
    }
}

void DummServiceStub::sendLogTuneSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        LogTuneSignal* payload = new LogTuneSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "LogTune", LogTuneSignal, payload)
        LOG_INFO ("-> send%sSignal", "LogTune");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "LogTune");
    }
}

void DummServiceStub::sendLogSetProbeVerbositySignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        LogSetProbeVerbositySignal* payload = new LogSetProbeVerbositySignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "LogSetProbeVerbosity", LogSetProbeVerbositySignal, payload)
        LOG_INFO ("-> send%sSignal", "LogSetProbeVerbosity");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "LogSetProbeVerbosity");
    }
}

void DummServiceStub::sendLogSetSLogBufferSizeSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        LogSetSLogBufferSizeSignal* payload = new LogSetSLogBufferSizeSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "LogSetSLogBufferSize", LogSetSLogBufferSizeSignal, payload)
        LOG_INFO ("-> send%sSignal", "LogSetSLogBufferSize");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "LogSetSLogBufferSize");
    }
}

void DummServiceStub::sendLogSetDefaultLogConfigSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        LogSetDefaultLogConfigSignal* payload = new LogSetDefaultLogConfigSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "LogSetDefaultLogConfig", LogSetDefaultLogConfigSignal, payload)
        LOG_INFO ("-> send%sSignal", "LogSetDefaultLogConfig");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "LogSetDefaultLogConfig");
    }
}

void DummServiceStub::sendMapInstallRequestACKSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        MapInstallRequestACKSignal* payload = new MapInstallRequestACKSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "MapInstallRequestACK", MapInstallRequestACKSignal, payload)
        LOG_INFO ("-> send%sSignal", "MapInstallRequestACK");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "MapInstallRequestACK");
    }
}

void DummServiceStub::sendMapInstallStatusRequestACKSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData) {
    if (_stubDelegate->isConnected()) {
        MapInstallStatusRequestACKSignal* payload = new MapInstallStatusRequestACKSignal(jsonDownloadHeader, jsonDownloadData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "MapInstallStatusRequestACK", MapInstallStatusRequestACKSignal, payload)
        LOG_INFO ("-> send%sSignal", "MapInstallStatusRequestACK");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "MapInstallStatusRequestACK");
    }
}

void  DummServiceStub::sendGenCorrelationIdResponse (const ::std::string& correlationId, act_t act) {
    GenCorrelationIdResponse* payload = new GenCorrelationIdResponse(correlationId);
    DBUS_MESSAGE_REPLY(dbusMessage, "genCorrelationId", GenCorrelationIdResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GenCorrelationId", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DummServiceStub::sendGenCorrelationIdError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GenCorrelationIdError* payload = new GenCorrelationIdError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "genCorrelationId", GenCorrelationIdError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GenCorrelationId", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DummServiceStub::sendUploadDataResponse (const RequestInfo& requestInfo, act_t act) {
    UploadDataResponse* payload = new UploadDataResponse(requestInfo);
    DBUS_MESSAGE_REPLY(dbusMessage, "uploadData", UploadDataResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UploadData", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DummServiceStub::sendUploadDataError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UploadDataError* payload = new UploadDataError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "uploadData", UploadDataError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UploadData", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DummServiceStub::sendCancelUploadRequestResponse (const RequestInfo& outRequestInfo, act_t act) {
    CancelUploadRequestResponse* payload = new CancelUploadRequestResponse(outRequestInfo);
    DBUS_MESSAGE_REPLY(dbusMessage, "cancelUploadRequest", CancelUploadRequestResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "CancelUploadRequest", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DummServiceStub::sendCancelUploadRequestError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CancelUploadRequestError* payload = new CancelUploadRequestError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "cancelUploadRequest", CancelUploadRequestError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "CancelUploadRequest", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DummServiceStub::sendGetUploadRequestStatusResponse (const RequestInfo& outRequestInfo, act_t act) {
    GetUploadRequestStatusResponse* payload = new GetUploadRequestStatusResponse(outRequestInfo);
    DBUS_MESSAGE_REPLY(dbusMessage, "getUploadRequestStatus", GetUploadRequestStatusResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetUploadRequestStatus", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DummServiceStub::sendGetUploadRequestStatusError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetUploadRequestStatusError* payload = new GetUploadRequestStatusError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getUploadRequestStatus", GetUploadRequestStatusError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetUploadRequestStatus", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void DummServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace DummService
} // namespace dumm
} // namespace cm
} // namespace bosch
} // namespace com
