#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_CM_DUMM_DUMMSERVICE_H
#define COM_BOSCH_CM_DUMM_DUMMSERVICE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "com/bosch/cm/dumm/DummServiceConst.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "com.bosch.cm.dumm.DummService" isn't clear, then there should be a description here.
 */

namespace com {
namespace bosch {
namespace cm {
namespace dumm {
namespace DummService {

// method IDs
static const uint16 ID_genCorrelationId = 0;
static const uint16 ID_uploadData = 1;
static const uint16 ID_cancelUploadRequest = 2;
static const uint16 ID_getUploadRequestStatus = 3;

// signal IDs
static const uint16 ID_mqttConnectionStatus = 4;
static const uint16 ID_requestStateChanged = 5;
static const uint16 ID_serviceActivationAcknowledged = 6;
static const uint16 ID_remoteDataWipeReceived = 7;
static const uint16 ID_pushMessageReceived = 8;
static const uint16 ID_pushMessageDelete = 9;
static const uint16 ID_pushMessageUpdate = 10;
static const uint16 ID_xCALL_POI_Received = 11;
static const uint16 ID_RemoteDataWipe = 12;
static const uint16 ID_profileSyncResponse = 13;
static const uint16 ID_profileSyncNeeded = 14;
static const uint16 ID_profileRemoteLinkResponse = 15;
static const uint16 ID_profileRemoteReset = 16;
static const uint16 ID_profileLocalLinkAck = 17;
static const uint16 ID_profileLocalUnLinkAck = 18;
static const uint16 ID_EVPresoakAVNextSynchroResp = 19;
static const uint16 ID_EVPresoakAVNextSynchroNeeded = 20;
static const uint16 ID_EVChargeAVNextSynchroResp = 21;
static const uint16 ID_EVChargeAVNextSynchroNeeded = 22;
static const uint16 ID_remotePushE2E_POIAck = 23;
static const uint16 ID_remotePushE2E_Destination = 24;
static const uint16 ID_ManagedApps_RemoteOrder = 25;
static const uint16 ID_ManagedApps_RemoteRequest = 26;
static const uint16 ID_ManagedApps_RemoteSetting = 27;
static const uint16 ID_VPALogs = 28;
static const uint16 ID_VPATelemetry = 29;
static const uint16 ID_ValetMode = 30;
static const uint16 ID_LogActivation = 31;
static const uint16 ID_LogRequest = 32;
static const uint16 ID_LogTune = 33;
static const uint16 ID_LogSetProbeVerbosity = 34;
static const uint16 ID_LogSetSLogBufferSize = 35;
static const uint16 ID_LogSetDefaultLogConfig = 36;
static const uint16 ID_MapInstallRequestACK = 37;
static const uint16 ID_MapInstallStatusRequestACK = 38;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class RequestInfo;

class GenCorrelationIdResponse;

class UploadDataRequest;

class UploadDataResponse;

class CancelUploadRequestRequest;

class CancelUploadRequestResponse;

class GetUploadRequestStatusRequest;

class GetUploadRequestStatusResponse;

class MqttConnectionStatusSignal;

class RequestStateChangedSignal;

class ServiceActivationAcknowledgedSignal;

class RemoteDataWipeReceivedSignal;

class PushMessageReceivedSignal;

class PushMessageDeleteSignal;

class PushMessageUpdateSignal;

class XCALL_POI_ReceivedSignal;

class RemoteDataWipeSignal;

class ProfileSyncResponseSignal;

class ProfileSyncNeededSignal;

class ProfileRemoteLinkResponseSignal;

class ProfileRemoteResetSignal;

class ProfileLocalLinkAckSignal;

class ProfileLocalUnLinkAckSignal;

class EVPresoakAVNextSynchroRespSignal;

class EVPresoakAVNextSynchroNeededSignal;

class EVChargeAVNextSynchroRespSignal;

class EVChargeAVNextSynchroNeededSignal;

class RemotePushE2E_POIAckSignal;

class RemotePushE2E_DestinationSignal;

class ManagedApps_RemoteOrderSignal;

class ManagedApps_RemoteRequestSignal;

class ManagedApps_RemoteSettingSignal;

class VPALogsSignal;

class VPATelemetrySignal;

class ValetModeSignal;

class LogActivationSignal;

class LogRequestSignal;

class LogTuneSignal;

class LogSetProbeVerbositySignal;

class LogSetSLogBufferSizeSignal;

class LogSetDefaultLogConfigSignal;

class MapInstallRequestACKSignal;

class MapInstallStatusRequestACKSignal;

// type definitions
/**
 * Method to generate the correlation Id
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GenCorrelationIdRequest;

/**
 * If the meaning of "GenCorrelationIdError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GenCorrelationIdError;

/**
 * If the meaning of "UploadDataError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UploadDataError;

/**
 * If the meaning of "CancelUploadRequestError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CancelUploadRequestError;

/**
 * If the meaning of "GetUploadRequestStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetUploadRequestStatusError;

/**
 * If the meaning of "MqttConnectionStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MqttConnectionStatusError;

/**
 * If the meaning of "RequestStateChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestStateChangedError;

/**
 * If the meaning of "ServiceActivationAcknowledgedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ServiceActivationAcknowledgedError;

/**
 * If the meaning of "RemoteDataWipeReceivedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RemoteDataWipeReceivedError;

/**
 * If the meaning of "PushMessageReceivedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PushMessageReceivedError;

/**
 * If the meaning of "PushMessageDeleteError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PushMessageDeleteError;

/**
 * If the meaning of "PushMessageUpdateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PushMessageUpdateError;

/**
 * If the meaning of "XCALL_POI_ReceivedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError XCALL_POI_ReceivedError;

/**
 * If the meaning of "RemoteDataWipeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RemoteDataWipeError;

/**
 * If the meaning of "ProfileSyncResponseError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ProfileSyncResponseError;

/**
 * If the meaning of "ProfileSyncNeededError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ProfileSyncNeededError;

/**
 * If the meaning of "ProfileRemoteLinkResponseError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ProfileRemoteLinkResponseError;

/**
 * If the meaning of "ProfileRemoteResetError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ProfileRemoteResetError;

/**
 * If the meaning of "ProfileLocalLinkAckError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ProfileLocalLinkAckError;

/**
 * If the meaning of "ProfileLocalUnLinkAckError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ProfileLocalUnLinkAckError;

/**
 * If the meaning of "EVPresoakAVNextSynchroRespError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EVPresoakAVNextSynchroRespError;

/**
 * If the meaning of "EVPresoakAVNextSynchroNeededError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EVPresoakAVNextSynchroNeededError;

/**
 * If the meaning of "EVChargeAVNextSynchroRespError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EVChargeAVNextSynchroRespError;

/**
 * If the meaning of "EVChargeAVNextSynchroNeededError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EVChargeAVNextSynchroNeededError;

/**
 * If the meaning of "RemotePushE2E_POIAckError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RemotePushE2E_POIAckError;

/**
 * If the meaning of "RemotePushE2E_DestinationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RemotePushE2E_DestinationError;

/**
 * If the meaning of "ManagedApps_RemoteOrderError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ManagedApps_RemoteOrderError;

/**
 * If the meaning of "ManagedApps_RemoteRequestError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ManagedApps_RemoteRequestError;

/**
 * If the meaning of "ManagedApps_RemoteSettingError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ManagedApps_RemoteSettingError;

/**
 * If the meaning of "VPALogsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VPALogsError;

/**
 * If the meaning of "VPATelemetryError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VPATelemetryError;

/**
 * If the meaning of "ValetModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ValetModeError;

/**
 * If the meaning of "LogActivationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LogActivationError;

/**
 * If the meaning of "LogRequestError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LogRequestError;

/**
 * If the meaning of "LogTuneError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LogTuneError;

/**
 * If the meaning of "LogSetProbeVerbosityError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LogSetProbeVerbosityError;

/**
 * If the meaning of "LogSetSLogBufferSizeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LogSetSLogBufferSizeError;

/**
 * If the meaning of "LogSetDefaultLogConfigError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LogSetDefaultLogConfigError;

/**
 * If the meaning of "MapInstallRequestACKError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MapInstallRequestACKError;

/**
 * If the meaning of "MapInstallStatusRequestACKError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MapInstallStatusRequestACKError;


/**
 * If the meaning of "RequestInfo" isn't clear, then there should be a description here.
 */
class RequestInfo {
public:

    /**
     * Default constructor
     */
    inline  RequestInfo ();

    /**
     * Copy constructor
     */
    inline  RequestInfo (const RequestInfo &rhs);

    /**
     * All fields constructor
     */
    inline  RequestInfo (ResponseStatus responseStatus_, const ::std::string& CorrelationId_, UploadFunctionID uploadFunctionID_, RequestState requestState_);

    /**
     * Destructor
     */
    inline  ~RequestInfo();

    /**
     * Assignment operator
     */
    inline RequestInfo& operator = (const RequestInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "responseStatus"

    static const int kResponseStatus = 0;

    /**
     * Clears the field "responseStatus".
     *
     * The field will be set to its default value. The hasResponseStatus()
     * method will return false.
     */
    inline void clearResponseStatus();

    /**
     * Checks whether the field "responseStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponseStatus()). Otherwise it will return false.
     */
    inline bool hasResponseStatus () const;

    /**
     * Returns the value of the member "responseStatus".
     *
     * If the meaning of "responseStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "responseStatus"
     */
    inline ResponseStatus getResponseStatus () const;

    /**
     * Sets the value of the member "responseStatus".
     *
     * If the meaning of "responseStatus" isn't clear, then there should be a description here.
     *
     * @param responseStatus The value which will be set
     */
    inline void setResponseStatus (ResponseStatus responseStatus_);

    // API of field "CorrelationId"

    static const int kCorrelationId = 1;

    /**
     * Clears the field "CorrelationId".
     *
     * The field will be set to its default value. The hasCorrelationId()
     * method will return false.
     */
    inline void clearCorrelationId();

    /**
     * Checks whether the field "CorrelationId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCorrelationId()). Otherwise it will return false.
     */
    inline bool hasCorrelationId () const;

    /**
     * Returns the value of the member "CorrelationId".
     *
     * Unique identifier to identify a request.
     *
     * @return The value of the field "CorrelationId"
     */
    inline const ::std::string& getCorrelationId () const;

    /**
     * Retrieves the value of the field "CorrelationId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CorrelationId".
     */
    inline ::std::string& getCorrelationIdMutable ();

    /**
     * Sets the value of the member "CorrelationId".
     *
     * Unique identifier to identify a request.
     *
     * @param CorrelationId The value which will be set
     */
    inline void setCorrelationId (const ::std::string& CorrelationId_);

    /**
     * Sets the value of the member "CorrelationId".
     *
     * Unique identifier to identify a request.
     *
     * @param CorrelationId The value which will be set
     */
    inline void setCorrelationId (const char* CorrelationId_);

    /**
     * Sets the value of the member "CorrelationId".
     *
     * Unique identifier to identify a request.
     *
     * @param CorrelationId The value which will be set
     */
    inline void setCorrelationId (const char* value, size_t size);

    // API of field "uploadFunctionID"

    static const int kUploadFunctionID = 2;

    /**
     * Clears the field "uploadFunctionID".
     *
     * The field will be set to its default value. The hasUploadFunctionID()
     * method will return false.
     */
    inline void clearUploadFunctionID();

    /**
     * Checks whether the field "uploadFunctionID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUploadFunctionID()). Otherwise it will return false.
     */
    inline bool hasUploadFunctionID () const;

    /**
     * Returns the value of the member "uploadFunctionID".
     *
     * If the meaning of "uploadFunctionID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "uploadFunctionID"
     */
    inline UploadFunctionID getUploadFunctionID () const;

    /**
     * Sets the value of the member "uploadFunctionID".
     *
     * If the meaning of "uploadFunctionID" isn't clear, then there should be a description here.
     *
     * @param uploadFunctionID The value which will be set
     */
    inline void setUploadFunctionID (UploadFunctionID uploadFunctionID_);

    // API of field "requestState"

    static const int kRequestState = 3;

    /**
     * Clears the field "requestState".
     *
     * The field will be set to its default value. The hasRequestState()
     * method will return false.
     */
    inline void clearRequestState();

    /**
     * Checks whether the field "requestState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestState()). Otherwise it will return false.
     */
    inline bool hasRequestState () const;

    /**
     * Returns the value of the member "requestState".
     *
     * If the meaning of "requestState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "requestState"
     */
    inline RequestState getRequestState () const;

    /**
     * Sets the value of the member "requestState".
     *
     * If the meaning of "requestState" isn't clear, then there should be a description here.
     *
     * @param requestState The value which will be set
     */
    inline void setRequestState (RequestState requestState_);

    static const RequestInfo &getDefaultInstance();

private:

    inline void set_has_responseStatus ();

    inline void clear_has_responseStatus ();

    inline void set_has_CorrelationId ();

    inline void clear_has_CorrelationId ();

    inline void set_has_uploadFunctionID ();

    inline void clear_has_uploadFunctionID ();

    inline void set_has_requestState ();

    inline void clear_has_requestState ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ResponseStatus _responseStatus;

    ::std::string _CorrelationId;

    UploadFunctionID _uploadFunctionID;

    RequestState _requestState;

};

/**
 * Method to generate the correlation Id
 */
class GenCorrelationIdResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GenCorrelationIdResponse ();

    /**
     * Copy constructor
     */
    inline  GenCorrelationIdResponse (const GenCorrelationIdResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GenCorrelationIdResponse (const ::std::string& CorrelationId_);

    /**
     * Destructor
     */
    inline virtual  ~GenCorrelationIdResponse();

    /**
     * Assignment operator
     */
    inline GenCorrelationIdResponse& operator = (const GenCorrelationIdResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GenCorrelationIdResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GenCorrelationIdResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GenCorrelationIdResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GenCorrelationIdResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CorrelationId"

    static const int kCorrelationId = 0;

    /**
     * Clears the field "CorrelationId".
     *
     * The field will be set to its default value. The hasCorrelationId()
     * method will return false.
     */
    inline void clearCorrelationId();

    /**
     * Checks whether the field "CorrelationId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCorrelationId()). Otherwise it will return false.
     */
    inline bool hasCorrelationId () const;

    /**
     * Returns the value of the member "CorrelationId".
     *
     * If the meaning of "CorrelationId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CorrelationId"
     */
    inline const ::std::string& getCorrelationId () const;

    /**
     * Retrieves the value of the field "CorrelationId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CorrelationId".
     */
    inline ::std::string& getCorrelationIdMutable ();

    /**
     * Sets the value of the member "CorrelationId".
     *
     * If the meaning of "CorrelationId" isn't clear, then there should be a description here.
     *
     * @param CorrelationId The value which will be set
     */
    inline void setCorrelationId (const ::std::string& CorrelationId_);

    /**
     * Sets the value of the member "CorrelationId".
     *
     * If the meaning of "CorrelationId" isn't clear, then there should be a description here.
     *
     * @param CorrelationId The value which will be set
     */
    inline void setCorrelationId (const char* CorrelationId_);

    /**
     * Sets the value of the member "CorrelationId".
     *
     * If the meaning of "CorrelationId" isn't clear, then there should be a description here.
     *
     * @param CorrelationId The value which will be set
     */
    inline void setCorrelationId (const char* value, size_t size);

    static const GenCorrelationIdResponse &getDefaultInstance();

private:

    inline void set_has_CorrelationId ();

    inline void clear_has_CorrelationId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _CorrelationId;

};

/**
 * Method to upload data
 */
class UploadDataRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UploadDataRequest ();

    /**
     * Copy constructor
     */
    inline  UploadDataRequest (const UploadDataRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UploadDataRequest (const ::std::string& jsonUploadHeader_, const ::std::string& jsonUploadData_);

    /**
     * Destructor
     */
    inline virtual  ~UploadDataRequest();

    /**
     * Assignment operator
     */
    inline UploadDataRequest& operator = (const UploadDataRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UploadDataRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UploadDataRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UploadDataRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UploadDataRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonUploadHeader"

    static const int kJsonUploadHeader = 0;

    /**
     * Clears the field "jsonUploadHeader".
     *
     * The field will be set to its default value. The hasJsonUploadHeader()
     * method will return false.
     */
    inline void clearJsonUploadHeader();

    /**
     * Checks whether the field "jsonUploadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonUploadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonUploadHeader () const;

    /**
     * Returns the value of the member "jsonUploadHeader".
     *
     * Sample jsonUploadHeader
     * 			{
     * 				"UploadFunctionID":1,
     * 				"CorrelationId":"{CorrelationId}", //Please refer below comment for the exact format. Method to generate new correlation ID is mentioned above.
     * 				"UserId":"Renault",
     * 				"Token":"12345"
     * 			}
     *
     * 		  UploadFunctionID - Unique identifier to identify an upload function. Refer to UploadFunctionID.
     * 		  CorrelationId [Important] - This is used to match the request and response between clients and DUMM service. Clients must send this in the response message to a request (with correlationID) from DUMM service.
     * 			+ With Clients upload an Acknowledgement(ACK) message, Client must reuse received CorrelationId from Vnext(Vnext will use this CorrelationId to match correctly).
     * 			+ Other cases, Clients must genarate new correlationId by using uuid lib on linux. Refer to: Function getGlobalMessageId(): /ai_midw/components/fc_dumm/sources/appl/common/eventManager/fc_dumm_EventManager_Sender.cpp
     * 					the format of correlationId rely on RFC4122 standard: https://www.ietf.org/rfc/rfc4122.txt (like that: xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx)
     * 		  UserId [Optional] - User ID.
     * 		  Token [Optional] - Access Token.
     *
     * @return The value of the field "jsonUploadHeader"
     */
    inline const ::std::string& getJsonUploadHeader () const;

    /**
     * Retrieves the value of the field "jsonUploadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonUploadHeader".
     */
    inline ::std::string& getJsonUploadHeaderMutable ();

    /**
     * Sets the value of the member "jsonUploadHeader".
     *
     * Sample jsonUploadHeader
     * 			{
     * 				"UploadFunctionID":1,
     * 				"CorrelationId":"{CorrelationId}", //Please refer below comment for the exact format. Method to generate new correlation ID is mentioned above.
     * 				"UserId":"Renault",
     * 				"Token":"12345"
     * 			}
     *
     * 		  UploadFunctionID - Unique identifier to identify an upload function. Refer to UploadFunctionID.
     * 		  CorrelationId [Important] - This is used to match the request and response between clients and DUMM service. Clients must send this in the response message to a request (with correlationID) from DUMM service.
     * 			+ With Clients upload an Acknowledgement(ACK) message, Client must reuse received CorrelationId from Vnext(Vnext will use this CorrelationId to match correctly).
     * 			+ Other cases, Clients must genarate new correlationId by using uuid lib on linux. Refer to: Function getGlobalMessageId(): /ai_midw/components/fc_dumm/sources/appl/common/eventManager/fc_dumm_EventManager_Sender.cpp
     * 					the format of correlationId rely on RFC4122 standard: https://www.ietf.org/rfc/rfc4122.txt (like that: xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx)
     * 		  UserId [Optional] - User ID.
     * 		  Token [Optional] - Access Token.
     *
     * @param jsonUploadHeader The value which will be set
     */
    inline void setJsonUploadHeader (const ::std::string& jsonUploadHeader_);

    /**
     * Sets the value of the member "jsonUploadHeader".
     *
     * Sample jsonUploadHeader
     * 			{
     * 				"UploadFunctionID":1,
     * 				"CorrelationId":"{CorrelationId}", //Please refer below comment for the exact format. Method to generate new correlation ID is mentioned above.
     * 				"UserId":"Renault",
     * 				"Token":"12345"
     * 			}
     *
     * 		  UploadFunctionID - Unique identifier to identify an upload function. Refer to UploadFunctionID.
     * 		  CorrelationId [Important] - This is used to match the request and response between clients and DUMM service. Clients must send this in the response message to a request (with correlationID) from DUMM service.
     * 			+ With Clients upload an Acknowledgement(ACK) message, Client must reuse received CorrelationId from Vnext(Vnext will use this CorrelationId to match correctly).
     * 			+ Other cases, Clients must genarate new correlationId by using uuid lib on linux. Refer to: Function getGlobalMessageId(): /ai_midw/components/fc_dumm/sources/appl/common/eventManager/fc_dumm_EventManager_Sender.cpp
     * 					the format of correlationId rely on RFC4122 standard: https://www.ietf.org/rfc/rfc4122.txt (like that: xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx)
     * 		  UserId [Optional] - User ID.
     * 		  Token [Optional] - Access Token.
     *
     * @param jsonUploadHeader The value which will be set
     */
    inline void setJsonUploadHeader (const char* jsonUploadHeader_);

    /**
     * Sets the value of the member "jsonUploadHeader".
     *
     * Sample jsonUploadHeader
     * 			{
     * 				"UploadFunctionID":1,
     * 				"CorrelationId":"{CorrelationId}", //Please refer below comment for the exact format. Method to generate new correlation ID is mentioned above.
     * 				"UserId":"Renault",
     * 				"Token":"12345"
     * 			}
     *
     * 		  UploadFunctionID - Unique identifier to identify an upload function. Refer to UploadFunctionID.
     * 		  CorrelationId [Important] - This is used to match the request and response between clients and DUMM service. Clients must send this in the response message to a request (with correlationID) from DUMM service.
     * 			+ With Clients upload an Acknowledgement(ACK) message, Client must reuse received CorrelationId from Vnext(Vnext will use this CorrelationId to match correctly).
     * 			+ Other cases, Clients must genarate new correlationId by using uuid lib on linux. Refer to: Function getGlobalMessageId(): /ai_midw/components/fc_dumm/sources/appl/common/eventManager/fc_dumm_EventManager_Sender.cpp
     * 					the format of correlationId rely on RFC4122 standard: https://www.ietf.org/rfc/rfc4122.txt (like that: xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx)
     * 		  UserId [Optional] - User ID.
     * 		  Token [Optional] - Access Token.
     *
     * @param jsonUploadHeader The value which will be set
     */
    inline void setJsonUploadHeader (const char* value, size_t size);

    // API of field "jsonUploadData"

    static const int kJsonUploadData = 1;

    /**
     * Clears the field "jsonUploadData".
     *
     * The field will be set to its default value. The hasJsonUploadData()
     * method will return false.
     */
    inline void clearJsonUploadData();

    /**
     * Checks whether the field "jsonUploadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonUploadData()). Otherwise it will return false.
     */
    inline bool hasJsonUploadData () const;

    /**
     * Returns the value of the member "jsonUploadData".
     *
     * Refer to UploadFunctionID for sample json message
     *
     * @return The value of the field "jsonUploadData"
     */
    inline const ::std::string& getJsonUploadData () const;

    /**
     * Retrieves the value of the field "jsonUploadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonUploadData".
     */
    inline ::std::string& getJsonUploadDataMutable ();

    /**
     * Sets the value of the member "jsonUploadData".
     *
     * Refer to UploadFunctionID for sample json message
     *
     * @param jsonUploadData The value which will be set
     */
    inline void setJsonUploadData (const ::std::string& jsonUploadData_);

    /**
     * Sets the value of the member "jsonUploadData".
     *
     * Refer to UploadFunctionID for sample json message
     *
     * @param jsonUploadData The value which will be set
     */
    inline void setJsonUploadData (const char* jsonUploadData_);

    /**
     * Sets the value of the member "jsonUploadData".
     *
     * Refer to UploadFunctionID for sample json message
     *
     * @param jsonUploadData The value which will be set
     */
    inline void setJsonUploadData (const char* value, size_t size);

    static const UploadDataRequest &getDefaultInstance();

private:

    inline void set_has_jsonUploadHeader ();

    inline void clear_has_jsonUploadHeader ();

    inline void set_has_jsonUploadData ();

    inline void clear_has_jsonUploadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonUploadHeader;

    ::std::string _jsonUploadData;

};

/**
 * Method to upload data
 */
class UploadDataResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UploadDataResponse ();

    /**
     * Copy constructor
     */
    inline  UploadDataResponse (const UploadDataResponse &rhs);

    /**
     * All fields constructor
     */
    inline  UploadDataResponse (const RequestInfo& requestInfo_);

    /**
     * Destructor
     */
    inline virtual  ~UploadDataResponse();

    /**
     * Assignment operator
     */
    inline UploadDataResponse& operator = (const UploadDataResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UploadDataResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UploadDataResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UploadDataResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UploadDataResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "requestInfo"

    static const int kRequestInfo = 0;

    /**
     * Clears the field "requestInfo".
     *
     * The field will be set to its default value. The hasRequestInfo()
     * method will return false.
     */
    inline void clearRequestInfo();

    /**
     * Checks whether the field "requestInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestInfo()). Otherwise it will return false.
     */
    inline bool hasRequestInfo () const;

    /**
     * Returns the value of the member "requestInfo".
     *
     * If the meaning of "requestInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "requestInfo"
     */
    inline const RequestInfo& getRequestInfo () const;

    /**
     * Retrieves the value of the field "requestInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "requestInfo".
     */
    inline RequestInfo& getRequestInfoMutable ();

    /**
     * Sets the value of the member "requestInfo".
     *
     * If the meaning of "requestInfo" isn't clear, then there should be a description here.
     *
     * @param requestInfo The value which will be set
     */
    inline void setRequestInfo (const RequestInfo& requestInfo_);

    static const UploadDataResponse &getDefaultInstance();

private:

    inline void set_has_requestInfo ();

    inline void clear_has_requestInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    RequestInfo _requestInfo;

};

/**
 * Method to cancel a upload request
 */
class CancelUploadRequestRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CancelUploadRequestRequest ();

    /**
     * Copy constructor
     */
    inline  CancelUploadRequestRequest (const CancelUploadRequestRequest &rhs);

    /**
     * All fields constructor
     */
    inline  CancelUploadRequestRequest (const ::std::string& CorrelationId_);

    /**
     * Destructor
     */
    inline virtual  ~CancelUploadRequestRequest();

    /**
     * Assignment operator
     */
    inline CancelUploadRequestRequest& operator = (const CancelUploadRequestRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CancelUploadRequestRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CancelUploadRequestRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CancelUploadRequestRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CancelUploadRequestRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CorrelationId"

    static const int kCorrelationId = 0;

    /**
     * Clears the field "CorrelationId".
     *
     * The field will be set to its default value. The hasCorrelationId()
     * method will return false.
     */
    inline void clearCorrelationId();

    /**
     * Checks whether the field "CorrelationId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCorrelationId()). Otherwise it will return false.
     */
    inline bool hasCorrelationId () const;

    /**
     * Returns the value of the member "CorrelationId".
     *
     * If the meaning of "CorrelationId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CorrelationId"
     */
    inline const ::std::string& getCorrelationId () const;

    /**
     * Retrieves the value of the field "CorrelationId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CorrelationId".
     */
    inline ::std::string& getCorrelationIdMutable ();

    /**
     * Sets the value of the member "CorrelationId".
     *
     * If the meaning of "CorrelationId" isn't clear, then there should be a description here.
     *
     * @param CorrelationId The value which will be set
     */
    inline void setCorrelationId (const ::std::string& CorrelationId_);

    /**
     * Sets the value of the member "CorrelationId".
     *
     * If the meaning of "CorrelationId" isn't clear, then there should be a description here.
     *
     * @param CorrelationId The value which will be set
     */
    inline void setCorrelationId (const char* CorrelationId_);

    /**
     * Sets the value of the member "CorrelationId".
     *
     * If the meaning of "CorrelationId" isn't clear, then there should be a description here.
     *
     * @param CorrelationId The value which will be set
     */
    inline void setCorrelationId (const char* value, size_t size);

    static const CancelUploadRequestRequest &getDefaultInstance();

private:

    inline void set_has_CorrelationId ();

    inline void clear_has_CorrelationId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _CorrelationId;

};

/**
 * Method to cancel a upload request
 */
class CancelUploadRequestResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CancelUploadRequestResponse ();

    /**
     * Copy constructor
     */
    inline  CancelUploadRequestResponse (const CancelUploadRequestResponse &rhs);

    /**
     * All fields constructor
     */
    inline  CancelUploadRequestResponse (const RequestInfo& outRequestInfo_);

    /**
     * Destructor
     */
    inline virtual  ~CancelUploadRequestResponse();

    /**
     * Assignment operator
     */
    inline CancelUploadRequestResponse& operator = (const CancelUploadRequestResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CancelUploadRequestResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CancelUploadRequestResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CancelUploadRequestResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CancelUploadRequestResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "outRequestInfo"

    static const int kOutRequestInfo = 0;

    /**
     * Clears the field "outRequestInfo".
     *
     * The field will be set to its default value. The hasOutRequestInfo()
     * method will return false.
     */
    inline void clearOutRequestInfo();

    /**
     * Checks whether the field "outRequestInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOutRequestInfo()). Otherwise it will return false.
     */
    inline bool hasOutRequestInfo () const;

    /**
     * Returns the value of the member "outRequestInfo".
     *
     * If the meaning of "outRequestInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "outRequestInfo"
     */
    inline const RequestInfo& getOutRequestInfo () const;

    /**
     * Retrieves the value of the field "outRequestInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "outRequestInfo".
     */
    inline RequestInfo& getOutRequestInfoMutable ();

    /**
     * Sets the value of the member "outRequestInfo".
     *
     * If the meaning of "outRequestInfo" isn't clear, then there should be a description here.
     *
     * @param outRequestInfo The value which will be set
     */
    inline void setOutRequestInfo (const RequestInfo& outRequestInfo_);

    static const CancelUploadRequestResponse &getDefaultInstance();

private:

    inline void set_has_outRequestInfo ();

    inline void clear_has_outRequestInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    RequestInfo _outRequestInfo;

};

/**
 * Method to get the current status of a request
 */
class GetUploadRequestStatusRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetUploadRequestStatusRequest ();

    /**
     * Copy constructor
     */
    inline  GetUploadRequestStatusRequest (const GetUploadRequestStatusRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetUploadRequestStatusRequest (const ::std::string& CorrelationId_);

    /**
     * Destructor
     */
    inline virtual  ~GetUploadRequestStatusRequest();

    /**
     * Assignment operator
     */
    inline GetUploadRequestStatusRequest& operator = (const GetUploadRequestStatusRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetUploadRequestStatusRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetUploadRequestStatusRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetUploadRequestStatusRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetUploadRequestStatusRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CorrelationId"

    static const int kCorrelationId = 0;

    /**
     * Clears the field "CorrelationId".
     *
     * The field will be set to its default value. The hasCorrelationId()
     * method will return false.
     */
    inline void clearCorrelationId();

    /**
     * Checks whether the field "CorrelationId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCorrelationId()). Otherwise it will return false.
     */
    inline bool hasCorrelationId () const;

    /**
     * Returns the value of the member "CorrelationId".
     *
     * If the meaning of "CorrelationId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CorrelationId"
     */
    inline const ::std::string& getCorrelationId () const;

    /**
     * Retrieves the value of the field "CorrelationId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CorrelationId".
     */
    inline ::std::string& getCorrelationIdMutable ();

    /**
     * Sets the value of the member "CorrelationId".
     *
     * If the meaning of "CorrelationId" isn't clear, then there should be a description here.
     *
     * @param CorrelationId The value which will be set
     */
    inline void setCorrelationId (const ::std::string& CorrelationId_);

    /**
     * Sets the value of the member "CorrelationId".
     *
     * If the meaning of "CorrelationId" isn't clear, then there should be a description here.
     *
     * @param CorrelationId The value which will be set
     */
    inline void setCorrelationId (const char* CorrelationId_);

    /**
     * Sets the value of the member "CorrelationId".
     *
     * If the meaning of "CorrelationId" isn't clear, then there should be a description here.
     *
     * @param CorrelationId The value which will be set
     */
    inline void setCorrelationId (const char* value, size_t size);

    static const GetUploadRequestStatusRequest &getDefaultInstance();

private:

    inline void set_has_CorrelationId ();

    inline void clear_has_CorrelationId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _CorrelationId;

};

/**
 * Method to get the current status of a request
 */
class GetUploadRequestStatusResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetUploadRequestStatusResponse ();

    /**
     * Copy constructor
     */
    inline  GetUploadRequestStatusResponse (const GetUploadRequestStatusResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetUploadRequestStatusResponse (const RequestInfo& outRequestInfo_);

    /**
     * Destructor
     */
    inline virtual  ~GetUploadRequestStatusResponse();

    /**
     * Assignment operator
     */
    inline GetUploadRequestStatusResponse& operator = (const GetUploadRequestStatusResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetUploadRequestStatusResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetUploadRequestStatusResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetUploadRequestStatusResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetUploadRequestStatusResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "outRequestInfo"

    static const int kOutRequestInfo = 0;

    /**
     * Clears the field "outRequestInfo".
     *
     * The field will be set to its default value. The hasOutRequestInfo()
     * method will return false.
     */
    inline void clearOutRequestInfo();

    /**
     * Checks whether the field "outRequestInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOutRequestInfo()). Otherwise it will return false.
     */
    inline bool hasOutRequestInfo () const;

    /**
     * Returns the value of the member "outRequestInfo".
     *
     * If the meaning of "outRequestInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "outRequestInfo"
     */
    inline const RequestInfo& getOutRequestInfo () const;

    /**
     * Retrieves the value of the field "outRequestInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "outRequestInfo".
     */
    inline RequestInfo& getOutRequestInfoMutable ();

    /**
     * Sets the value of the member "outRequestInfo".
     *
     * If the meaning of "outRequestInfo" isn't clear, then there should be a description here.
     *
     * @param outRequestInfo The value which will be set
     */
    inline void setOutRequestInfo (const RequestInfo& outRequestInfo_);

    static const GetUploadRequestStatusResponse &getDefaultInstance();

private:

    inline void set_has_outRequestInfo ();

    inline void clear_has_outRequestInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    RequestInfo _outRequestInfo;

};

/**
 * Signal to inform MQTT connection status change
 */
class MqttConnectionStatusSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MqttConnectionStatusSignal ();

    /**
     * Copy constructor
     */
    inline  MqttConnectionStatusSignal (const MqttConnectionStatusSignal &rhs);

    /**
     * All fields constructor
     */
    inline  MqttConnectionStatusSignal (ConnectionStatus connectionStatus_);

    /**
     * Destructor
     */
    inline virtual  ~MqttConnectionStatusSignal();

    /**
     * Assignment operator
     */
    inline MqttConnectionStatusSignal& operator = (const MqttConnectionStatusSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MqttConnectionStatusSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MqttConnectionStatusSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MqttConnectionStatusSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MqttConnectionStatusSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "connectionStatus"

    static const int kConnectionStatus = 0;

    /**
     * Clears the field "connectionStatus".
     *
     * The field will be set to its default value. The hasConnectionStatus()
     * method will return false.
     */
    inline void clearConnectionStatus();

    /**
     * Checks whether the field "connectionStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnectionStatus()). Otherwise it will return false.
     */
    inline bool hasConnectionStatus () const;

    /**
     * Returns the value of the member "connectionStatus".
     *
     * If the meaning of "connectionStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "connectionStatus"
     */
    inline ConnectionStatus getConnectionStatus () const;

    /**
     * Sets the value of the member "connectionStatus".
     *
     * If the meaning of "connectionStatus" isn't clear, then there should be a description here.
     *
     * @param connectionStatus The value which will be set
     */
    inline void setConnectionStatus (ConnectionStatus connectionStatus_);

    static const MqttConnectionStatusSignal &getDefaultInstance();

private:

    inline void set_has_connectionStatus ();

    inline void clear_has_connectionStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ConnectionStatus _connectionStatus;

};

/**
 * Signal to inform request status change
 * 		TODO: Need to avoid broadcasting update of a request to all the clients
 */
class RequestStateChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestStateChangedSignal ();

    /**
     * Copy constructor
     */
    inline  RequestStateChangedSignal (const RequestStateChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  RequestStateChangedSignal (const RequestInfo& requestInfo_);

    /**
     * Destructor
     */
    inline virtual  ~RequestStateChangedSignal();

    /**
     * Assignment operator
     */
    inline RequestStateChangedSignal& operator = (const RequestStateChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestStateChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestStateChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestStateChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestStateChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "requestInfo"

    static const int kRequestInfo = 0;

    /**
     * Clears the field "requestInfo".
     *
     * The field will be set to its default value. The hasRequestInfo()
     * method will return false.
     */
    inline void clearRequestInfo();

    /**
     * Checks whether the field "requestInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestInfo()). Otherwise it will return false.
     */
    inline bool hasRequestInfo () const;

    /**
     * Returns the value of the member "requestInfo".
     *
     * If the meaning of "requestInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "requestInfo"
     */
    inline const RequestInfo& getRequestInfo () const;

    /**
     * Retrieves the value of the field "requestInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "requestInfo".
     */
    inline RequestInfo& getRequestInfoMutable ();

    /**
     * Sets the value of the member "requestInfo".
     *
     * If the meaning of "requestInfo" isn't clear, then there should be a description here.
     *
     * @param requestInfo The value which will be set
     */
    inline void setRequestInfo (const RequestInfo& requestInfo_);

    static const RequestStateChangedSignal &getDefaultInstance();

private:

    inline void set_has_requestInfo ();

    inline void clear_has_requestInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    RequestInfo _requestInfo;

};

/**
 * Signal to inform ServiceActivationAck
 */
class ServiceActivationAcknowledgedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ServiceActivationAcknowledgedSignal ();

    /**
     * Copy constructor
     */
    inline  ServiceActivationAcknowledgedSignal (const ServiceActivationAcknowledgedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ServiceActivationAcknowledgedSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~ServiceActivationAcknowledgedSignal();

    /**
     * Assignment operator
     */
    inline ServiceActivationAcknowledgedSignal& operator = (const ServiceActivationAcknowledgedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ServiceActivationAcknowledgedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ServiceActivationAcknowledgedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ServiceActivationAcknowledgedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ServiceActivationAcknowledgedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Sample jsonDownloadHeader
     * 			{
     * 				"CorrelationId":"2fff6fa91f414229b829e4f612f79a27",
     * 				"UserId":"Renault",
     * 				"Token":"12345"
     * 			}
     *
     * 		  CorrelationId [Optional] - This is optional. If present, clients must send this in the response message to this request.
     * 		  UserId [Optional] - User ID.
     * 		  Token [Optional] - Access Token.
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Sample jsonDownloadHeader
     * 			{
     * 				"CorrelationId":"2fff6fa91f414229b829e4f612f79a27",
     * 				"UserId":"Renault",
     * 				"Token":"12345"
     * 			}
     *
     * 		  CorrelationId [Optional] - This is optional. If present, clients must send this in the response message to this request.
     * 		  UserId [Optional] - User ID.
     * 		  Token [Optional] - Access Token.
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Sample jsonDownloadHeader
     * 			{
     * 				"CorrelationId":"2fff6fa91f414229b829e4f612f79a27",
     * 				"UserId":"Renault",
     * 				"Token":"12345"
     * 			}
     *
     * 		  CorrelationId [Optional] - This is optional. If present, clients must send this in the response message to this request.
     * 		  UserId [Optional] - User ID.
     * 		  Token [Optional] - Access Token.
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Sample jsonDownloadHeader
     * 			{
     * 				"CorrelationId":"2fff6fa91f414229b829e4f612f79a27",
     * 				"UserId":"Renault",
     * 				"Token":"12345"
     * 			}
     *
     * 		  CorrelationId [Optional] - This is optional. If present, clients must send this in the response message to this request.
     * 		  UserId [Optional] - User ID.
     * 		  Token [Optional] - Access Token.
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"ServiceActivation/Data/Status":"KO",
     * 				"ServiceActivation/Data/ErrorCode":2
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"ServiceActivation/Data/Status":"KO",
     * 				"ServiceActivation/Data/ErrorCode":2
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"ServiceActivation/Data/Status":"KO",
     * 				"ServiceActivation/Data/ErrorCode":2
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"ServiceActivation/Data/Status":"KO",
     * 				"ServiceActivation/Data/ErrorCode":2
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const ServiceActivationAcknowledgedSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform DataWipe
 */
class RemoteDataWipeReceivedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoteDataWipeReceivedSignal ();

    /**
     * Copy constructor
     */
    inline  RemoteDataWipeReceivedSignal (const RemoteDataWipeReceivedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  RemoteDataWipeReceivedSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~RemoteDataWipeReceivedSignal();

    /**
     * Assignment operator
     */
    inline RemoteDataWipeReceivedSignal& operator = (const RemoteDataWipeReceivedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoteDataWipeReceivedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoteDataWipeReceivedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoteDataWipeReceivedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoteDataWipeReceivedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2018-07-14T19:40:37+123Z",
     * 				"DataWipe/Data/Action":"Wipe"
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2018-07-14T19:40:37+123Z",
     * 				"DataWipe/Data/Action":"Wipe"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2018-07-14T19:40:37+123Z",
     * 				"DataWipe/Data/Action":"Wipe"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2018-07-14T19:40:37+123Z",
     * 				"DataWipe/Data/Action":"Wipe"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const RemoteDataWipeReceivedSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform PushMessage received
 */
class PushMessageReceivedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PushMessageReceivedSignal ();

    /**
     * Copy constructor
     */
    inline  PushMessageReceivedSignal (const PushMessageReceivedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  PushMessageReceivedSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~PushMessageReceivedSignal();

    /**
     * Assignment operator
     */
    inline PushMessageReceivedSignal& operator = (const PushMessageReceivedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PushMessageReceivedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PushMessageReceivedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PushMessageReceivedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PushMessageReceivedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"PushMessage/Data/messageIdentifier":"0",
     * 				"PushMessage/Data/b2bSender":"0",
     * 				"PushMessage/Data/serviceSender":"PushMessageManager",
     * 				"PushMessage/Data/userDependent":"0",
     * 				"PushMessage/Data/userIdentifier":"0",
     * 				"PushMessage/Data/messageType":"0",
     * 				"PushMessage/Data/domain":"Assistance",
     * 				"PushMessage/Data/intent":"inform",
     * 				"PushMessage/Data/maximumLifetime":"2419200",
     * 				"PushMessage/Data/textLine1":"Information",
     * 				"PushMessage/Data/textLine2":"",
     * 				"PushMessage/Data/actionButtonNumber":"0",
     * 				"PushMessage/Data/actionButton1":"Accept",
     * 				"PushMessage/Data/actionButton1Description":"",
     * 				"PushMessage/Data/actionButton1Semantics":"OK",
     * 				"PushMessage/Data/actionButton2":"",
     * 				"PushMessage/Data/actionButton2Description":"",
     * 				"PushMessage/Data/actionButton2Semantics":"",
     * 				"PushMessage/Data/targetedApplication":"Navi",
     * 				"PushMessage/Data/invokedFunction":"guideTo",
     * 				"PushMessage/Data/parameterList":"",
     * 				"PushMessage/Data/picture":"https://www.cdn.renault.com/content/dam/Renault/master/new-logo/renault_french_logo_desktop.png",
     * 				"PushMessage/Data/pictureType":"URL",
     * 				"PushMessage/Data/feedbackRequired":"true",
     * 				"PushMessage/Data/HMI_template_ID":"0",
     * 				"PushMessage/Data/priorityLevel":"50",
     * 				"PushMessage/Data/minPriorityLevel":"0",
     * 				"PushMessage/Data/maxPriorityLevel":"99",
     * 				"PushMessage/Data/preDrivePriority":"50",
     * 				"PushMessage/Data/drivingPriority":"50",
     * 				"PushMessage/Data/notDrivingPriority":"50",
     * 				"PushMessage/Data/postDriverPriority":"50",
     * 				"PushMessage/Data/behaviorWhileDriving":"Driving"
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"PushMessage/Data/messageIdentifier":"0",
     * 				"PushMessage/Data/b2bSender":"0",
     * 				"PushMessage/Data/serviceSender":"PushMessageManager",
     * 				"PushMessage/Data/userDependent":"0",
     * 				"PushMessage/Data/userIdentifier":"0",
     * 				"PushMessage/Data/messageType":"0",
     * 				"PushMessage/Data/domain":"Assistance",
     * 				"PushMessage/Data/intent":"inform",
     * 				"PushMessage/Data/maximumLifetime":"2419200",
     * 				"PushMessage/Data/textLine1":"Information",
     * 				"PushMessage/Data/textLine2":"",
     * 				"PushMessage/Data/actionButtonNumber":"0",
     * 				"PushMessage/Data/actionButton1":"Accept",
     * 				"PushMessage/Data/actionButton1Description":"",
     * 				"PushMessage/Data/actionButton1Semantics":"OK",
     * 				"PushMessage/Data/actionButton2":"",
     * 				"PushMessage/Data/actionButton2Description":"",
     * 				"PushMessage/Data/actionButton2Semantics":"",
     * 				"PushMessage/Data/targetedApplication":"Navi",
     * 				"PushMessage/Data/invokedFunction":"guideTo",
     * 				"PushMessage/Data/parameterList":"",
     * 				"PushMessage/Data/picture":"https://www.cdn.renault.com/content/dam/Renault/master/new-logo/renault_french_logo_desktop.png",
     * 				"PushMessage/Data/pictureType":"URL",
     * 				"PushMessage/Data/feedbackRequired":"true",
     * 				"PushMessage/Data/HMI_template_ID":"0",
     * 				"PushMessage/Data/priorityLevel":"50",
     * 				"PushMessage/Data/minPriorityLevel":"0",
     * 				"PushMessage/Data/maxPriorityLevel":"99",
     * 				"PushMessage/Data/preDrivePriority":"50",
     * 				"PushMessage/Data/drivingPriority":"50",
     * 				"PushMessage/Data/notDrivingPriority":"50",
     * 				"PushMessage/Data/postDriverPriority":"50",
     * 				"PushMessage/Data/behaviorWhileDriving":"Driving"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"PushMessage/Data/messageIdentifier":"0",
     * 				"PushMessage/Data/b2bSender":"0",
     * 				"PushMessage/Data/serviceSender":"PushMessageManager",
     * 				"PushMessage/Data/userDependent":"0",
     * 				"PushMessage/Data/userIdentifier":"0",
     * 				"PushMessage/Data/messageType":"0",
     * 				"PushMessage/Data/domain":"Assistance",
     * 				"PushMessage/Data/intent":"inform",
     * 				"PushMessage/Data/maximumLifetime":"2419200",
     * 				"PushMessage/Data/textLine1":"Information",
     * 				"PushMessage/Data/textLine2":"",
     * 				"PushMessage/Data/actionButtonNumber":"0",
     * 				"PushMessage/Data/actionButton1":"Accept",
     * 				"PushMessage/Data/actionButton1Description":"",
     * 				"PushMessage/Data/actionButton1Semantics":"OK",
     * 				"PushMessage/Data/actionButton2":"",
     * 				"PushMessage/Data/actionButton2Description":"",
     * 				"PushMessage/Data/actionButton2Semantics":"",
     * 				"PushMessage/Data/targetedApplication":"Navi",
     * 				"PushMessage/Data/invokedFunction":"guideTo",
     * 				"PushMessage/Data/parameterList":"",
     * 				"PushMessage/Data/picture":"https://www.cdn.renault.com/content/dam/Renault/master/new-logo/renault_french_logo_desktop.png",
     * 				"PushMessage/Data/pictureType":"URL",
     * 				"PushMessage/Data/feedbackRequired":"true",
     * 				"PushMessage/Data/HMI_template_ID":"0",
     * 				"PushMessage/Data/priorityLevel":"50",
     * 				"PushMessage/Data/minPriorityLevel":"0",
     * 				"PushMessage/Data/maxPriorityLevel":"99",
     * 				"PushMessage/Data/preDrivePriority":"50",
     * 				"PushMessage/Data/drivingPriority":"50",
     * 				"PushMessage/Data/notDrivingPriority":"50",
     * 				"PushMessage/Data/postDriverPriority":"50",
     * 				"PushMessage/Data/behaviorWhileDriving":"Driving"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"PushMessage/Data/messageIdentifier":"0",
     * 				"PushMessage/Data/b2bSender":"0",
     * 				"PushMessage/Data/serviceSender":"PushMessageManager",
     * 				"PushMessage/Data/userDependent":"0",
     * 				"PushMessage/Data/userIdentifier":"0",
     * 				"PushMessage/Data/messageType":"0",
     * 				"PushMessage/Data/domain":"Assistance",
     * 				"PushMessage/Data/intent":"inform",
     * 				"PushMessage/Data/maximumLifetime":"2419200",
     * 				"PushMessage/Data/textLine1":"Information",
     * 				"PushMessage/Data/textLine2":"",
     * 				"PushMessage/Data/actionButtonNumber":"0",
     * 				"PushMessage/Data/actionButton1":"Accept",
     * 				"PushMessage/Data/actionButton1Description":"",
     * 				"PushMessage/Data/actionButton1Semantics":"OK",
     * 				"PushMessage/Data/actionButton2":"",
     * 				"PushMessage/Data/actionButton2Description":"",
     * 				"PushMessage/Data/actionButton2Semantics":"",
     * 				"PushMessage/Data/targetedApplication":"Navi",
     * 				"PushMessage/Data/invokedFunction":"guideTo",
     * 				"PushMessage/Data/parameterList":"",
     * 				"PushMessage/Data/picture":"https://www.cdn.renault.com/content/dam/Renault/master/new-logo/renault_french_logo_desktop.png",
     * 				"PushMessage/Data/pictureType":"URL",
     * 				"PushMessage/Data/feedbackRequired":"true",
     * 				"PushMessage/Data/HMI_template_ID":"0",
     * 				"PushMessage/Data/priorityLevel":"50",
     * 				"PushMessage/Data/minPriorityLevel":"0",
     * 				"PushMessage/Data/maxPriorityLevel":"99",
     * 				"PushMessage/Data/preDrivePriority":"50",
     * 				"PushMessage/Data/drivingPriority":"50",
     * 				"PushMessage/Data/notDrivingPriority":"50",
     * 				"PushMessage/Data/postDriverPriority":"50",
     * 				"PushMessage/Data/behaviorWhileDriving":"Driving"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const PushMessageReceivedSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform PushMessageDelete
 */
class PushMessageDeleteSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PushMessageDeleteSignal ();

    /**
     * Copy constructor
     */
    inline  PushMessageDeleteSignal (const PushMessageDeleteSignal &rhs);

    /**
     * All fields constructor
     */
    inline  PushMessageDeleteSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~PushMessageDeleteSignal();

    /**
     * Assignment operator
     */
    inline PushMessageDeleteSignal& operator = (const PushMessageDeleteSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PushMessageDeleteSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PushMessageDeleteSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PushMessageDeleteSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PushMessageDeleteSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"PushMessageDelete/Data/messageIdentifier":"0",
     * 				"PushMessageDelete/Data/userDependent":"false",
     * 				"PushMessageDelete/Data/userIdentifier":"0"
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"PushMessageDelete/Data/messageIdentifier":"0",
     * 				"PushMessageDelete/Data/userDependent":"false",
     * 				"PushMessageDelete/Data/userIdentifier":"0"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"PushMessageDelete/Data/messageIdentifier":"0",
     * 				"PushMessageDelete/Data/userDependent":"false",
     * 				"PushMessageDelete/Data/userIdentifier":"0"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"PushMessageDelete/Data/messageIdentifier":"0",
     * 				"PushMessageDelete/Data/userDependent":"false",
     * 				"PushMessageDelete/Data/userIdentifier":"0"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const PushMessageDeleteSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform PushMessageUpdate
 */
class PushMessageUpdateSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PushMessageUpdateSignal ();

    /**
     * Copy constructor
     */
    inline  PushMessageUpdateSignal (const PushMessageUpdateSignal &rhs);

    /**
     * All fields constructor
     */
    inline  PushMessageUpdateSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~PushMessageUpdateSignal();

    /**
     * Assignment operator
     */
    inline PushMessageUpdateSignal& operator = (const PushMessageUpdateSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PushMessageUpdateSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PushMessageUpdateSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PushMessageUpdateSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PushMessageUpdateSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"PushMessageUpdate/Data/messageIdentifier":"0",
     * 				"PushMessageUpdate/Data/userDependent":"False",
     * 				"PushMessageUpdate/Data/userIdentifier":"0",
     * 				"PushMessageUpdate/Data/intent":"inform",
     * 				"PushMessageUpdate/Data/maximumLifetime":"2419200",
     * 				"PushMessageUpdate/Data/textLine1":"Information",
     * 				"PushMessageUpdate/Data/textLine2":"",
     * 				"PushMessageUpdate/Data/actionButtonNumber":"0",
     * 				"PushMessageUpdate/Data/actionButton1":"Accept",
     * 				"PushMessageUpdate/Data/actionButton1Description":"",
     * 				"PushMessageUpdate/Data/actionButton1Semantics":"OK",
     * 				"PushMessageUpdate/Data/actionButton2":"",
     * 				"PushMessageUpdate/Data/actionButton2Description":"",
     * 				"PushMessageUpdate/Data/actionButton2Semantics":"",
     * 				"PushMessageUpdate/Data/targetedApplication":"Navi",
     * 				"PushMessageUpdate/Data/invokedFunction":"guideTo",
     * 				"PushMessageUpdate/Data/parameterList":"",
     * 				"PushMessageUpdate/Data/picture":"https://www.cdn.renault.com/content/dam/Renault/master/new-logo/renault_french_logo_desktop.png",
     * 				"PushMessageUpdate/Data/pictureType":"URL",
     * 				"PushMessageUpdate/Data/feedback required":"true",
     * 				"PushMessageUpdate/Data/HMI_template_ID":"0",
     * 				"PushMessageUpdate/Data/priorityLevel":"50",
     * 				"PushMessageUpdate/Data/minPriorityLevel":"0",
     * 				"PushMessageUpdate/Data/maxPriorityLevel":"99",
     * 				"PushMessageUpdate/Data/preDrivePriority":"50",
     * 				"PushMessageUpdate/Data/drivingPriority":"50",
     * 				"PushMessageUpdate/Data/notDrivingPriority":"50",
     * 				"PushMessageUpdate/Data/postDriverPriority":"50",
     * 				"PushMessageUpdate/Data/behaviorWhileDriving":"Driving"
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"PushMessageUpdate/Data/messageIdentifier":"0",
     * 				"PushMessageUpdate/Data/userDependent":"False",
     * 				"PushMessageUpdate/Data/userIdentifier":"0",
     * 				"PushMessageUpdate/Data/intent":"inform",
     * 				"PushMessageUpdate/Data/maximumLifetime":"2419200",
     * 				"PushMessageUpdate/Data/textLine1":"Information",
     * 				"PushMessageUpdate/Data/textLine2":"",
     * 				"PushMessageUpdate/Data/actionButtonNumber":"0",
     * 				"PushMessageUpdate/Data/actionButton1":"Accept",
     * 				"PushMessageUpdate/Data/actionButton1Description":"",
     * 				"PushMessageUpdate/Data/actionButton1Semantics":"OK",
     * 				"PushMessageUpdate/Data/actionButton2":"",
     * 				"PushMessageUpdate/Data/actionButton2Description":"",
     * 				"PushMessageUpdate/Data/actionButton2Semantics":"",
     * 				"PushMessageUpdate/Data/targetedApplication":"Navi",
     * 				"PushMessageUpdate/Data/invokedFunction":"guideTo",
     * 				"PushMessageUpdate/Data/parameterList":"",
     * 				"PushMessageUpdate/Data/picture":"https://www.cdn.renault.com/content/dam/Renault/master/new-logo/renault_french_logo_desktop.png",
     * 				"PushMessageUpdate/Data/pictureType":"URL",
     * 				"PushMessageUpdate/Data/feedback required":"true",
     * 				"PushMessageUpdate/Data/HMI_template_ID":"0",
     * 				"PushMessageUpdate/Data/priorityLevel":"50",
     * 				"PushMessageUpdate/Data/minPriorityLevel":"0",
     * 				"PushMessageUpdate/Data/maxPriorityLevel":"99",
     * 				"PushMessageUpdate/Data/preDrivePriority":"50",
     * 				"PushMessageUpdate/Data/drivingPriority":"50",
     * 				"PushMessageUpdate/Data/notDrivingPriority":"50",
     * 				"PushMessageUpdate/Data/postDriverPriority":"50",
     * 				"PushMessageUpdate/Data/behaviorWhileDriving":"Driving"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"PushMessageUpdate/Data/messageIdentifier":"0",
     * 				"PushMessageUpdate/Data/userDependent":"False",
     * 				"PushMessageUpdate/Data/userIdentifier":"0",
     * 				"PushMessageUpdate/Data/intent":"inform",
     * 				"PushMessageUpdate/Data/maximumLifetime":"2419200",
     * 				"PushMessageUpdate/Data/textLine1":"Information",
     * 				"PushMessageUpdate/Data/textLine2":"",
     * 				"PushMessageUpdate/Data/actionButtonNumber":"0",
     * 				"PushMessageUpdate/Data/actionButton1":"Accept",
     * 				"PushMessageUpdate/Data/actionButton1Description":"",
     * 				"PushMessageUpdate/Data/actionButton1Semantics":"OK",
     * 				"PushMessageUpdate/Data/actionButton2":"",
     * 				"PushMessageUpdate/Data/actionButton2Description":"",
     * 				"PushMessageUpdate/Data/actionButton2Semantics":"",
     * 				"PushMessageUpdate/Data/targetedApplication":"Navi",
     * 				"PushMessageUpdate/Data/invokedFunction":"guideTo",
     * 				"PushMessageUpdate/Data/parameterList":"",
     * 				"PushMessageUpdate/Data/picture":"https://www.cdn.renault.com/content/dam/Renault/master/new-logo/renault_french_logo_desktop.png",
     * 				"PushMessageUpdate/Data/pictureType":"URL",
     * 				"PushMessageUpdate/Data/feedback required":"true",
     * 				"PushMessageUpdate/Data/HMI_template_ID":"0",
     * 				"PushMessageUpdate/Data/priorityLevel":"50",
     * 				"PushMessageUpdate/Data/minPriorityLevel":"0",
     * 				"PushMessageUpdate/Data/maxPriorityLevel":"99",
     * 				"PushMessageUpdate/Data/preDrivePriority":"50",
     * 				"PushMessageUpdate/Data/drivingPriority":"50",
     * 				"PushMessageUpdate/Data/notDrivingPriority":"50",
     * 				"PushMessageUpdate/Data/postDriverPriority":"50",
     * 				"PushMessageUpdate/Data/behaviorWhileDriving":"Driving"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"PushMessageUpdate/Data/messageIdentifier":"0",
     * 				"PushMessageUpdate/Data/userDependent":"False",
     * 				"PushMessageUpdate/Data/userIdentifier":"0",
     * 				"PushMessageUpdate/Data/intent":"inform",
     * 				"PushMessageUpdate/Data/maximumLifetime":"2419200",
     * 				"PushMessageUpdate/Data/textLine1":"Information",
     * 				"PushMessageUpdate/Data/textLine2":"",
     * 				"PushMessageUpdate/Data/actionButtonNumber":"0",
     * 				"PushMessageUpdate/Data/actionButton1":"Accept",
     * 				"PushMessageUpdate/Data/actionButton1Description":"",
     * 				"PushMessageUpdate/Data/actionButton1Semantics":"OK",
     * 				"PushMessageUpdate/Data/actionButton2":"",
     * 				"PushMessageUpdate/Data/actionButton2Description":"",
     * 				"PushMessageUpdate/Data/actionButton2Semantics":"",
     * 				"PushMessageUpdate/Data/targetedApplication":"Navi",
     * 				"PushMessageUpdate/Data/invokedFunction":"guideTo",
     * 				"PushMessageUpdate/Data/parameterList":"",
     * 				"PushMessageUpdate/Data/picture":"https://www.cdn.renault.com/content/dam/Renault/master/new-logo/renault_french_logo_desktop.png",
     * 				"PushMessageUpdate/Data/pictureType":"URL",
     * 				"PushMessageUpdate/Data/feedback required":"true",
     * 				"PushMessageUpdate/Data/HMI_template_ID":"0",
     * 				"PushMessageUpdate/Data/priorityLevel":"50",
     * 				"PushMessageUpdate/Data/minPriorityLevel":"0",
     * 				"PushMessageUpdate/Data/maxPriorityLevel":"99",
     * 				"PushMessageUpdate/Data/preDrivePriority":"50",
     * 				"PushMessageUpdate/Data/drivingPriority":"50",
     * 				"PushMessageUpdate/Data/notDrivingPriority":"50",
     * 				"PushMessageUpdate/Data/postDriverPriority":"50",
     * 				"PushMessageUpdate/Data/behaviorWhileDriving":"Driving"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const PushMessageUpdateSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform xCALL to alliance_telematics
 */
class XCALL_POI_ReceivedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  XCALL_POI_ReceivedSignal ();

    /**
     * Copy constructor
     */
    inline  XCALL_POI_ReceivedSignal (const XCALL_POI_ReceivedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  XCALL_POI_ReceivedSignal (const ::std::string& jsonDownloadHeader_, XCallType xCallType_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~XCALL_POI_ReceivedSignal();

    /**
     * Assignment operator
     */
    inline XCALL_POI_ReceivedSignal& operator = (const XCALL_POI_ReceivedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const XCALL_POI_ReceivedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const XCALL_POI_ReceivedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const XCALL_POI_ReceivedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const XCALL_POI_ReceivedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "xCallType"

    static const int kXCallType = 1;

    /**
     * Clears the field "xCallType".
     *
     * The field will be set to its default value. The hasXCallType()
     * method will return false.
     */
    inline void clearXCallType();

    /**
     * Checks whether the field "xCallType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setXCallType()). Otherwise it will return false.
     */
    inline bool hasXCallType () const;

    /**
     * Returns the value of the member "xCallType".
     *
     * Refer to XCallType
     *
     * @return The value of the field "xCallType"
     */
    inline XCallType getXCallType () const;

    /**
     * Sets the value of the member "xCallType".
     *
     * Refer to XCallType
     *
     * @param xCallType The value which will be set
     */
    inline void setXCallType (XCallType xCallType_);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 2;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const XCALL_POI_ReceivedSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_xCallType ();

    inline void clear_has_xCallType ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    XCallType _xCallType;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform Remote Data Wipe
 */
class RemoteDataWipeSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoteDataWipeSignal ();

    /**
     * Copy constructor
     */
    inline  RemoteDataWipeSignal (const RemoteDataWipeSignal &rhs);

    /**
     * All fields constructor
     */
    inline  RemoteDataWipeSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~RemoteDataWipeSignal();

    /**
     * Assignment operator
     */
    inline RemoteDataWipeSignal& operator = (const RemoteDataWipeSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoteDataWipeSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoteDataWipeSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoteDataWipeSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoteDataWipeSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"DataWipe/Data/Action":"Wipe"
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"DataWipe/Data/Action":"Wipe"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"DataWipe/Data/Action":"Wipe"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"DataWipe/Data/Action":"Wipe"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const RemoteDataWipeSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform ProfileSyncResponse
 */
class ProfileSyncResponseSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProfileSyncResponseSignal ();

    /**
     * Copy constructor
     */
    inline  ProfileSyncResponseSignal (const ProfileSyncResponseSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ProfileSyncResponseSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~ProfileSyncResponseSignal();

    /**
     * Assignment operator
     */
    inline ProfileSyncResponseSignal& operator = (const ProfileSyncResponseSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProfileSyncResponseSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProfileSyncResponseSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProfileSyncResponseSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProfileSyncResponseSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"NewSyncTimeStamp":"2018-07-14T19:40:37+0000",
     * 				"Status":0,
     * 				"ErrorCode":2,
     * 				"UserProfile/Custom/MeterLanguageStatus":{
     * 					"val":0,
     * 					"ts":"2018-07-14T19:43:37+123Z"
     * 				},
     * 				"UserProfile/Custom/MEXModeState":{
     * 					"val":"0",
     * 					"ts":"2018-07-14T19:43:37+123Z"
     * 				}
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"NewSyncTimeStamp":"2018-07-14T19:40:37+0000",
     * 				"Status":0,
     * 				"ErrorCode":2,
     * 				"UserProfile/Custom/MeterLanguageStatus":{
     * 					"val":0,
     * 					"ts":"2018-07-14T19:43:37+123Z"
     * 				},
     * 				"UserProfile/Custom/MEXModeState":{
     * 					"val":"0",
     * 					"ts":"2018-07-14T19:43:37+123Z"
     * 				}
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"NewSyncTimeStamp":"2018-07-14T19:40:37+0000",
     * 				"Status":0,
     * 				"ErrorCode":2,
     * 				"UserProfile/Custom/MeterLanguageStatus":{
     * 					"val":0,
     * 					"ts":"2018-07-14T19:43:37+123Z"
     * 				},
     * 				"UserProfile/Custom/MEXModeState":{
     * 					"val":"0",
     * 					"ts":"2018-07-14T19:43:37+123Z"
     * 				}
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"NewSyncTimeStamp":"2018-07-14T19:40:37+0000",
     * 				"Status":0,
     * 				"ErrorCode":2,
     * 				"UserProfile/Custom/MeterLanguageStatus":{
     * 					"val":0,
     * 					"ts":"2018-07-14T19:43:37+123Z"
     * 				},
     * 				"UserProfile/Custom/MEXModeState":{
     * 					"val":"0",
     * 					"ts":"2018-07-14T19:43:37+123Z"
     * 				}
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const ProfileSyncResponseSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform ProfileSyncNeeded
 */
class ProfileSyncNeededSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProfileSyncNeededSignal ();

    /**
     * Copy constructor
     */
    inline  ProfileSyncNeededSignal (const ProfileSyncNeededSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ProfileSyncNeededSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~ProfileSyncNeededSignal();

    /**
     * Assignment operator
     */
    inline ProfileSyncNeededSignal& operator = (const ProfileSyncNeededSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProfileSyncNeededSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProfileSyncNeededSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProfileSyncNeededSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProfileSyncNeededSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000"
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const ProfileSyncNeededSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform RemoteLinkResponse
 */
class ProfileRemoteLinkResponseSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProfileRemoteLinkResponseSignal ();

    /**
     * Copy constructor
     */
    inline  ProfileRemoteLinkResponseSignal (const ProfileRemoteLinkResponseSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ProfileRemoteLinkResponseSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~ProfileRemoteLinkResponseSignal();

    /**
     * Assignment operator
     */
    inline ProfileRemoteLinkResponseSignal& operator = (const ProfileRemoteLinkResponseSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProfileRemoteLinkResponseSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProfileRemoteLinkResponseSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProfileRemoteLinkResponseSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProfileRemoteLinkResponseSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2018-07-14T19:40:37+123Z",
     * 				"RemoteOrder/Received/UPRemoteLink/Action":"Link",
     * 				"RemoteOrder/Received/UPRemoteLink/CloudSettings":"Yes"
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2018-07-14T19:40:37+123Z",
     * 				"RemoteOrder/Received/UPRemoteLink/Action":"Link",
     * 				"RemoteOrder/Received/UPRemoteLink/CloudSettings":"Yes"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2018-07-14T19:40:37+123Z",
     * 				"RemoteOrder/Received/UPRemoteLink/Action":"Link",
     * 				"RemoteOrder/Received/UPRemoteLink/CloudSettings":"Yes"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2018-07-14T19:40:37+123Z",
     * 				"RemoteOrder/Received/UPRemoteLink/Action":"Link",
     * 				"RemoteOrder/Received/UPRemoteLink/CloudSettings":"Yes"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const ProfileRemoteLinkResponseSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform RemoteReset
 */
class ProfileRemoteResetSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProfileRemoteResetSignal ();

    /**
     * Copy constructor
     */
    inline  ProfileRemoteResetSignal (const ProfileRemoteResetSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ProfileRemoteResetSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~ProfileRemoteResetSignal();

    /**
     * Assignment operator
     */
    inline ProfileRemoteResetSignal& operator = (const ProfileRemoteResetSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProfileRemoteResetSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProfileRemoteResetSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProfileRemoteResetSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProfileRemoteResetSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2018-07-14T19:40:37+123Z",
     * 				"RemoteOrder/Received/UPRemoteReset/Action":"Reset"
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2018-07-14T19:40:37+123Z",
     * 				"RemoteOrder/Received/UPRemoteReset/Action":"Reset"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2018-07-14T19:40:37+123Z",
     * 				"RemoteOrder/Received/UPRemoteReset/Action":"Reset"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2018-07-14T19:40:37+123Z",
     * 				"RemoteOrder/Received/UPRemoteReset/Action":"Reset"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const ProfileRemoteResetSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform UPLocalLink Ack
 */
class ProfileLocalLinkAckSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProfileLocalLinkAckSignal ();

    /**
     * Copy constructor
     */
    inline  ProfileLocalLinkAckSignal (const ProfileLocalLinkAckSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ProfileLocalLinkAckSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~ProfileLocalLinkAckSignal();

    /**
     * Assignment operator
     */
    inline ProfileLocalLinkAckSignal& operator = (const ProfileLocalLinkAckSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProfileLocalLinkAckSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProfileLocalLinkAckSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProfileLocalLinkAckSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProfileLocalLinkAckSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"RemoteOrder/Received/ACK/UPLocalLink/Status":1,
     * 				"RemoteOrder/Received/ACK/UPLocalLink/CloudSettings":"Yes"
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"RemoteOrder/Received/ACK/UPLocalLink/Status":1,
     * 				"RemoteOrder/Received/ACK/UPLocalLink/CloudSettings":"Yes"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"RemoteOrder/Received/ACK/UPLocalLink/Status":1,
     * 				"RemoteOrder/Received/ACK/UPLocalLink/CloudSettings":"Yes"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"RemoteOrder/Received/ACK/UPLocalLink/Status":1,
     * 				"RemoteOrder/Received/ACK/UPLocalLink/CloudSettings":"Yes"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const ProfileLocalLinkAckSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform UPLocalUnLink Ack
 */
class ProfileLocalUnLinkAckSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProfileLocalUnLinkAckSignal ();

    /**
     * Copy constructor
     */
    inline  ProfileLocalUnLinkAckSignal (const ProfileLocalUnLinkAckSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ProfileLocalUnLinkAckSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~ProfileLocalUnLinkAckSignal();

    /**
     * Assignment operator
     */
    inline ProfileLocalUnLinkAckSignal& operator = (const ProfileLocalUnLinkAckSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProfileLocalUnLinkAckSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProfileLocalUnLinkAckSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProfileLocalUnLinkAckSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProfileLocalUnLinkAckSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"RemoteOrder/Received/ACK/UPLocalUnLink/Status":0,
     * 				"RemoteOrder/Received/ACK/UPLocalUnLink/ErrorCode":2
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"RemoteOrder/Received/ACK/UPLocalUnLink/Status":0,
     * 				"RemoteOrder/Received/ACK/UPLocalUnLink/ErrorCode":2
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"RemoteOrder/Received/ACK/UPLocalUnLink/Status":0,
     * 				"RemoteOrder/Received/ACK/UPLocalUnLink/ErrorCode":2
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"RemoteOrder/Received/ACK/UPLocalUnLink/Status":0,
     * 				"RemoteOrder/Received/ACK/UPLocalUnLink/ErrorCode":2
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const ProfileLocalUnLinkAckSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform EVPresoakAVNextSynchroResp
 */
class EVPresoakAVNextSynchroRespSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EVPresoakAVNextSynchroRespSignal ();

    /**
     * Copy constructor
     */
    inline  EVPresoakAVNextSynchroRespSignal (const EVPresoakAVNextSynchroRespSignal &rhs);

    /**
     * All fields constructor
     */
    inline  EVPresoakAVNextSynchroRespSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~EVPresoakAVNextSynchroRespSignal();

    /**
     * Assignment operator
     */
    inline EVPresoakAVNextSynchroRespSignal& operator = (const EVPresoakAVNextSynchroRespSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EVPresoakAVNextSynchroRespSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EVPresoakAVNextSynchroRespSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EVPresoakAVNextSynchroRespSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EVPresoakAVNextSynchroRespSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"NewSyncTimeStamp":"2016-07-27T09:37:14Z",
     * 				"Status":0,
     * 				"ErrorCode":2,
     * 				"Vehicle/Received/HVAC/Presoak/Calendar1/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/Calendar2/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/Calendar3/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/Calendar4/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/Calendar5/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Vehicle/Received/HVAC/Presoak/PreSoakTempValue_MMI":23
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"NewSyncTimeStamp":"2016-07-27T09:37:14Z",
     * 				"Status":0,
     * 				"ErrorCode":2,
     * 				"Vehicle/Received/HVAC/Presoak/Calendar1/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/Calendar2/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/Calendar3/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/Calendar4/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/Calendar5/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Vehicle/Received/HVAC/Presoak/PreSoakTempValue_MMI":23
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"NewSyncTimeStamp":"2016-07-27T09:37:14Z",
     * 				"Status":0,
     * 				"ErrorCode":2,
     * 				"Vehicle/Received/HVAC/Presoak/Calendar1/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/Calendar2/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/Calendar3/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/Calendar4/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/Calendar5/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Vehicle/Received/HVAC/Presoak/PreSoakTempValue_MMI":23
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"NewSyncTimeStamp":"2016-07-27T09:37:14Z",
     * 				"Status":0,
     * 				"ErrorCode":2,
     * 				"Vehicle/Received/HVAC/Presoak/Calendar1/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/Calendar2/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/Calendar3/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/Calendar4/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/Calendar5/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Vehicle/Received/HVAC/Presoak/PreSoakTempValue_MMI":23
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const EVPresoakAVNextSynchroRespSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform EVPresoakAVNextSynchroNeeded
 */
class EVPresoakAVNextSynchroNeededSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EVPresoakAVNextSynchroNeededSignal ();

    /**
     * Copy constructor
     */
    inline  EVPresoakAVNextSynchroNeededSignal (const EVPresoakAVNextSynchroNeededSignal &rhs);

    /**
     * All fields constructor
     */
    inline  EVPresoakAVNextSynchroNeededSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~EVPresoakAVNextSynchroNeededSignal();

    /**
     * Assignment operator
     */
    inline EVPresoakAVNextSynchroNeededSignal& operator = (const EVPresoakAVNextSynchroNeededSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EVPresoakAVNextSynchroNeededSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EVPresoakAVNextSynchroNeededSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EVPresoakAVNextSynchroNeededSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EVPresoakAVNextSynchroNeededSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const EVPresoakAVNextSynchroNeededSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform EVChargeAVNextSynchroResp
 */
class EVChargeAVNextSynchroRespSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EVChargeAVNextSynchroRespSignal ();

    /**
     * Copy constructor
     */
    inline  EVChargeAVNextSynchroRespSignal (const EVChargeAVNextSynchroRespSignal &rhs);

    /**
     * All fields constructor
     */
    inline  EVChargeAVNextSynchroRespSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~EVChargeAVNextSynchroRespSignal();

    /**
     * Assignment operator
     */
    inline EVChargeAVNextSynchroRespSignal& operator = (const EVChargeAVNextSynchroRespSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EVChargeAVNextSynchroRespSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EVChargeAVNextSynchroRespSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EVChargeAVNextSynchroRespSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EVChargeAVNextSynchroRespSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"NewSyncTimeStamp":"2016-07-27T09:37:14Z",
     * 				"Status":0,
     * 				"ErrorCode":2,
     * 				"Vehicle/Received/EVCharge/ProgrammedStatus":"Always authorized charge",
     * 				"Vehicle/Received/EVCharge/DelayedValue":0,
     * 				"Vehicle/Received/EVCharge/ActivationState1":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour1":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute1":0,
     * 				"Vehicle/Received/EVCharge/Duration1":0,
     * 				"Vehicle/Received/EVCharge/Monday1":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday1":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday1":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday1":"NO",
     * 				"Vehicle/Received/EVCharge/Friday1":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday1":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday1":"NO",
     * 				"Vehicle/Received/EVCharge/ActivationState2":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour2":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute2":0,
     * 				"Vehicle/Received/EVCharge/Duration2":0,
     * 				"Vehicle/Received/EVCharge/Monday2":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday2":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday2":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday2":"NO",
     * 				"Vehicle/Received/EVCharge/Friday2":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday2":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday2":"NO",
     * 				"Vehicle/Received/EVCharge/ActivationState3":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour3":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute3":0,
     * 				"Vehicle/Received/EVCharge/Duration3":0,
     * 				"Vehicle/Received/EVCharge/Monday3":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday3":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday3":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday3":"NO",
     * 				"Vehicle/Received/EVCharge/Friday3":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday3":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday3":"NO",
     * 				"Vehicle/Received/EVCharge/ActivationState4":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour4":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute4":0,
     * 				"Vehicle/Received/EVCharge/Duration4":0,
     * 				"Vehicle/Received/EVCharge/Monday4":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday4":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday4":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday4":"NO",
     * 				"Vehicle/Received/EVCharge/Friday4":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday4":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday4":"NO",
     * 				"Vehicle/Received/EVCharge/ActivationState5":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour5":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute5":0,
     * 				"Vehicle/Received/EVCharge/Duration5":0,
     * 				"Vehicle/Received/EVCharge/Monday5":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday5":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday5":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday5":"NO",
     * 				"Vehicle/Received/EVCharge/Friday5":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday5":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday5":"NO"
     *
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"NewSyncTimeStamp":"2016-07-27T09:37:14Z",
     * 				"Status":0,
     * 				"ErrorCode":2,
     * 				"Vehicle/Received/EVCharge/ProgrammedStatus":"Always authorized charge",
     * 				"Vehicle/Received/EVCharge/DelayedValue":0,
     * 				"Vehicle/Received/EVCharge/ActivationState1":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour1":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute1":0,
     * 				"Vehicle/Received/EVCharge/Duration1":0,
     * 				"Vehicle/Received/EVCharge/Monday1":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday1":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday1":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday1":"NO",
     * 				"Vehicle/Received/EVCharge/Friday1":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday1":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday1":"NO",
     * 				"Vehicle/Received/EVCharge/ActivationState2":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour2":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute2":0,
     * 				"Vehicle/Received/EVCharge/Duration2":0,
     * 				"Vehicle/Received/EVCharge/Monday2":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday2":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday2":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday2":"NO",
     * 				"Vehicle/Received/EVCharge/Friday2":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday2":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday2":"NO",
     * 				"Vehicle/Received/EVCharge/ActivationState3":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour3":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute3":0,
     * 				"Vehicle/Received/EVCharge/Duration3":0,
     * 				"Vehicle/Received/EVCharge/Monday3":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday3":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday3":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday3":"NO",
     * 				"Vehicle/Received/EVCharge/Friday3":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday3":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday3":"NO",
     * 				"Vehicle/Received/EVCharge/ActivationState4":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour4":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute4":0,
     * 				"Vehicle/Received/EVCharge/Duration4":0,
     * 				"Vehicle/Received/EVCharge/Monday4":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday4":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday4":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday4":"NO",
     * 				"Vehicle/Received/EVCharge/Friday4":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday4":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday4":"NO",
     * 				"Vehicle/Received/EVCharge/ActivationState5":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour5":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute5":0,
     * 				"Vehicle/Received/EVCharge/Duration5":0,
     * 				"Vehicle/Received/EVCharge/Monday5":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday5":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday5":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday5":"NO",
     * 				"Vehicle/Received/EVCharge/Friday5":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday5":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday5":"NO"
     *
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"NewSyncTimeStamp":"2016-07-27T09:37:14Z",
     * 				"Status":0,
     * 				"ErrorCode":2,
     * 				"Vehicle/Received/EVCharge/ProgrammedStatus":"Always authorized charge",
     * 				"Vehicle/Received/EVCharge/DelayedValue":0,
     * 				"Vehicle/Received/EVCharge/ActivationState1":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour1":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute1":0,
     * 				"Vehicle/Received/EVCharge/Duration1":0,
     * 				"Vehicle/Received/EVCharge/Monday1":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday1":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday1":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday1":"NO",
     * 				"Vehicle/Received/EVCharge/Friday1":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday1":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday1":"NO",
     * 				"Vehicle/Received/EVCharge/ActivationState2":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour2":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute2":0,
     * 				"Vehicle/Received/EVCharge/Duration2":0,
     * 				"Vehicle/Received/EVCharge/Monday2":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday2":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday2":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday2":"NO",
     * 				"Vehicle/Received/EVCharge/Friday2":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday2":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday2":"NO",
     * 				"Vehicle/Received/EVCharge/ActivationState3":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour3":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute3":0,
     * 				"Vehicle/Received/EVCharge/Duration3":0,
     * 				"Vehicle/Received/EVCharge/Monday3":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday3":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday3":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday3":"NO",
     * 				"Vehicle/Received/EVCharge/Friday3":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday3":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday3":"NO",
     * 				"Vehicle/Received/EVCharge/ActivationState4":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour4":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute4":0,
     * 				"Vehicle/Received/EVCharge/Duration4":0,
     * 				"Vehicle/Received/EVCharge/Monday4":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday4":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday4":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday4":"NO",
     * 				"Vehicle/Received/EVCharge/Friday4":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday4":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday4":"NO",
     * 				"Vehicle/Received/EVCharge/ActivationState5":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour5":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute5":0,
     * 				"Vehicle/Received/EVCharge/Duration5":0,
     * 				"Vehicle/Received/EVCharge/Monday5":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday5":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday5":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday5":"NO",
     * 				"Vehicle/Received/EVCharge/Friday5":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday5":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday5":"NO"
     *
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"NewSyncTimeStamp":"2016-07-27T09:37:14Z",
     * 				"Status":0,
     * 				"ErrorCode":2,
     * 				"Vehicle/Received/EVCharge/ProgrammedStatus":"Always authorized charge",
     * 				"Vehicle/Received/EVCharge/DelayedValue":0,
     * 				"Vehicle/Received/EVCharge/ActivationState1":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour1":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute1":0,
     * 				"Vehicle/Received/EVCharge/Duration1":0,
     * 				"Vehicle/Received/EVCharge/Monday1":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday1":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday1":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday1":"NO",
     * 				"Vehicle/Received/EVCharge/Friday1":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday1":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday1":"NO",
     * 				"Vehicle/Received/EVCharge/ActivationState2":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour2":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute2":0,
     * 				"Vehicle/Received/EVCharge/Duration2":0,
     * 				"Vehicle/Received/EVCharge/Monday2":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday2":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday2":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday2":"NO",
     * 				"Vehicle/Received/EVCharge/Friday2":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday2":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday2":"NO",
     * 				"Vehicle/Received/EVCharge/ActivationState3":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour3":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute3":0,
     * 				"Vehicle/Received/EVCharge/Duration3":0,
     * 				"Vehicle/Received/EVCharge/Monday3":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday3":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday3":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday3":"NO",
     * 				"Vehicle/Received/EVCharge/Friday3":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday3":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday3":"NO",
     * 				"Vehicle/Received/EVCharge/ActivationState4":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour4":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute4":0,
     * 				"Vehicle/Received/EVCharge/Duration4":0,
     * 				"Vehicle/Received/EVCharge/Monday4":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday4":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday4":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday4":"NO",
     * 				"Vehicle/Received/EVCharge/Friday4":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday4":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday4":"NO",
     * 				"Vehicle/Received/EVCharge/ActivationState5":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour5":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute5":0,
     * 				"Vehicle/Received/EVCharge/Duration5":0,
     * 				"Vehicle/Received/EVCharge/Monday5":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday5":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday5":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday5":"NO",
     * 				"Vehicle/Received/EVCharge/Friday5":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday5":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday5":"NO"
     *
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const EVChargeAVNextSynchroRespSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform EVChargeAVNextSynchroNeeded
 */
class EVChargeAVNextSynchroNeededSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EVChargeAVNextSynchroNeededSignal ();

    /**
     * Copy constructor
     */
    inline  EVChargeAVNextSynchroNeededSignal (const EVChargeAVNextSynchroNeededSignal &rhs);

    /**
     * All fields constructor
     */
    inline  EVChargeAVNextSynchroNeededSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~EVChargeAVNextSynchroNeededSignal();

    /**
     * Assignment operator
     */
    inline EVChargeAVNextSynchroNeededSignal& operator = (const EVChargeAVNextSynchroNeededSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EVChargeAVNextSynchroNeededSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EVChargeAVNextSynchroNeededSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EVChargeAVNextSynchroNeededSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EVChargeAVNextSynchroNeededSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const EVChargeAVNextSynchroNeededSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform E2E_POI Ack
 */
class RemotePushE2E_POIAckSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemotePushE2E_POIAckSignal ();

    /**
     * Copy constructor
     */
    inline  RemotePushE2E_POIAckSignal (const RemotePushE2E_POIAckSignal &rhs);

    /**
     * All fields constructor
     */
    inline  RemotePushE2E_POIAckSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~RemotePushE2E_POIAckSignal();

    /**
     * Assignment operator
     */
    inline RemotePushE2E_POIAckSignal& operator = (const RemotePushE2E_POIAckSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemotePushE2E_POIAckSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemotePushE2E_POIAckSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemotePushE2E_POIAckSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemotePushE2E_POIAckSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"E2E/Sent/POI/Name1":"RN Showroom",
     * 				"E2E/Sent/POI/TTS1":"Hello",
     * 				"E2E/Sent/POI/Address1":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber1":"133166363",
     * 				"E2E/Sent/POI/Latitude1":40.7127837,
     * 				"E2E/Sent/POI/Longitude1":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode1":"South",
     * 				"E2E/Sent/POI/LongitudeMode1":"East",
     * 				"E2E/Sent/POI/LocationType1":"Tokyo",
     * 				"E2E/Sent/POI/Name2":"RN Showroom",
     * 				"E2E/Sent/POI/TTS2":"Hello",
     * 				"E2E/Sent/POI/Address2":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber2":"133166363",
     * 				"E2E/Sent/POI/Latitude2":40.7127837,
     * 				"E2E/Sent/POI/Longitude2":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode2":"South",
     * 				"E2E/Sent/POI/LongitudeMode2":"East",
     * 				"E2E/Sent/POI/LocationType2":"Tokyo",
     * 				"E2E/Sent/POI/Name3":"RN Showroom",
     * 				"E2E/Sent/POI/TTS3":"Hello",
     * 				"E2E/Sent/POI/Address3":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber3":"133166363",
     * 				"E2E/Sent/POI/Latitude3":40.7127837,
     * 				"E2E/Sent/POI/Longitude3":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode3":"South",
     * 				"E2E/Sent/POI/LongitudeMode3":"East",
     * 				"E2E/Sent/POI/LocationType3":"Tokyo",
     * 				"E2E/Sent/POI/Name4":"RN Showroom",
     * 				"E2E/Sent/POI/TTS4":"Hello",
     * 				"E2E/Sent/POI/Address4":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber4":"133166363",
     * 				"E2E/Sent/POI/Latitude4":40.7127837,
     * 				"E2E/Sent/POI/Longitude4":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode4":"South",
     * 				"E2E/Sent/POI/LongitudeMode4":"East",
     * 				"E2E/Sent/POI/LocationType4":"Tokyo",
     * 				"E2E/Sent/POI/Name5":"RN Showroom",
     * 				"E2E/Sent/POI/TTS5":"Hello",
     * 				"E2E/Sent/POI/Address5":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber5":"133166363",
     * 				"E2E/Sent/POI/Latitude5":40.7127837,
     * 				"E2E/Sent/POI/Longitude5":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode5":"South",
     * 				"E2E/Sent/POI/LongitudeMode5":"East",
     * 				"E2E/Sent/POI/LocationType5":"Tokyo",
     * 				"E2E/Sent/POI/Name6":"RN Showroom",
     * 				"E2E/Sent/POI/TTS6":"Hello",
     * 				"E2E/Sent/POI/Address6":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber6":"133166363",
     * 				"E2E/Sent/POI/Latitude6":40.7127837,
     * 				"E2E/Sent/POI/Longitude6":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode6":"South",
     * 				"E2E/Sent/POI/LongitudeMode6":"East",
     * 				"E2E/Sent/POI/LocationType6":"Tokyo"
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"E2E/Sent/POI/Name1":"RN Showroom",
     * 				"E2E/Sent/POI/TTS1":"Hello",
     * 				"E2E/Sent/POI/Address1":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber1":"133166363",
     * 				"E2E/Sent/POI/Latitude1":40.7127837,
     * 				"E2E/Sent/POI/Longitude1":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode1":"South",
     * 				"E2E/Sent/POI/LongitudeMode1":"East",
     * 				"E2E/Sent/POI/LocationType1":"Tokyo",
     * 				"E2E/Sent/POI/Name2":"RN Showroom",
     * 				"E2E/Sent/POI/TTS2":"Hello",
     * 				"E2E/Sent/POI/Address2":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber2":"133166363",
     * 				"E2E/Sent/POI/Latitude2":40.7127837,
     * 				"E2E/Sent/POI/Longitude2":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode2":"South",
     * 				"E2E/Sent/POI/LongitudeMode2":"East",
     * 				"E2E/Sent/POI/LocationType2":"Tokyo",
     * 				"E2E/Sent/POI/Name3":"RN Showroom",
     * 				"E2E/Sent/POI/TTS3":"Hello",
     * 				"E2E/Sent/POI/Address3":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber3":"133166363",
     * 				"E2E/Sent/POI/Latitude3":40.7127837,
     * 				"E2E/Sent/POI/Longitude3":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode3":"South",
     * 				"E2E/Sent/POI/LongitudeMode3":"East",
     * 				"E2E/Sent/POI/LocationType3":"Tokyo",
     * 				"E2E/Sent/POI/Name4":"RN Showroom",
     * 				"E2E/Sent/POI/TTS4":"Hello",
     * 				"E2E/Sent/POI/Address4":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber4":"133166363",
     * 				"E2E/Sent/POI/Latitude4":40.7127837,
     * 				"E2E/Sent/POI/Longitude4":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode4":"South",
     * 				"E2E/Sent/POI/LongitudeMode4":"East",
     * 				"E2E/Sent/POI/LocationType4":"Tokyo",
     * 				"E2E/Sent/POI/Name5":"RN Showroom",
     * 				"E2E/Sent/POI/TTS5":"Hello",
     * 				"E2E/Sent/POI/Address5":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber5":"133166363",
     * 				"E2E/Sent/POI/Latitude5":40.7127837,
     * 				"E2E/Sent/POI/Longitude5":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode5":"South",
     * 				"E2E/Sent/POI/LongitudeMode5":"East",
     * 				"E2E/Sent/POI/LocationType5":"Tokyo",
     * 				"E2E/Sent/POI/Name6":"RN Showroom",
     * 				"E2E/Sent/POI/TTS6":"Hello",
     * 				"E2E/Sent/POI/Address6":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber6":"133166363",
     * 				"E2E/Sent/POI/Latitude6":40.7127837,
     * 				"E2E/Sent/POI/Longitude6":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode6":"South",
     * 				"E2E/Sent/POI/LongitudeMode6":"East",
     * 				"E2E/Sent/POI/LocationType6":"Tokyo"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"E2E/Sent/POI/Name1":"RN Showroom",
     * 				"E2E/Sent/POI/TTS1":"Hello",
     * 				"E2E/Sent/POI/Address1":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber1":"133166363",
     * 				"E2E/Sent/POI/Latitude1":40.7127837,
     * 				"E2E/Sent/POI/Longitude1":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode1":"South",
     * 				"E2E/Sent/POI/LongitudeMode1":"East",
     * 				"E2E/Sent/POI/LocationType1":"Tokyo",
     * 				"E2E/Sent/POI/Name2":"RN Showroom",
     * 				"E2E/Sent/POI/TTS2":"Hello",
     * 				"E2E/Sent/POI/Address2":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber2":"133166363",
     * 				"E2E/Sent/POI/Latitude2":40.7127837,
     * 				"E2E/Sent/POI/Longitude2":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode2":"South",
     * 				"E2E/Sent/POI/LongitudeMode2":"East",
     * 				"E2E/Sent/POI/LocationType2":"Tokyo",
     * 				"E2E/Sent/POI/Name3":"RN Showroom",
     * 				"E2E/Sent/POI/TTS3":"Hello",
     * 				"E2E/Sent/POI/Address3":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber3":"133166363",
     * 				"E2E/Sent/POI/Latitude3":40.7127837,
     * 				"E2E/Sent/POI/Longitude3":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode3":"South",
     * 				"E2E/Sent/POI/LongitudeMode3":"East",
     * 				"E2E/Sent/POI/LocationType3":"Tokyo",
     * 				"E2E/Sent/POI/Name4":"RN Showroom",
     * 				"E2E/Sent/POI/TTS4":"Hello",
     * 				"E2E/Sent/POI/Address4":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber4":"133166363",
     * 				"E2E/Sent/POI/Latitude4":40.7127837,
     * 				"E2E/Sent/POI/Longitude4":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode4":"South",
     * 				"E2E/Sent/POI/LongitudeMode4":"East",
     * 				"E2E/Sent/POI/LocationType4":"Tokyo",
     * 				"E2E/Sent/POI/Name5":"RN Showroom",
     * 				"E2E/Sent/POI/TTS5":"Hello",
     * 				"E2E/Sent/POI/Address5":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber5":"133166363",
     * 				"E2E/Sent/POI/Latitude5":40.7127837,
     * 				"E2E/Sent/POI/Longitude5":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode5":"South",
     * 				"E2E/Sent/POI/LongitudeMode5":"East",
     * 				"E2E/Sent/POI/LocationType5":"Tokyo",
     * 				"E2E/Sent/POI/Name6":"RN Showroom",
     * 				"E2E/Sent/POI/TTS6":"Hello",
     * 				"E2E/Sent/POI/Address6":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber6":"133166363",
     * 				"E2E/Sent/POI/Latitude6":40.7127837,
     * 				"E2E/Sent/POI/Longitude6":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode6":"South",
     * 				"E2E/Sent/POI/LongitudeMode6":"East",
     * 				"E2E/Sent/POI/LocationType6":"Tokyo"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"E2E/Sent/POI/Name1":"RN Showroom",
     * 				"E2E/Sent/POI/TTS1":"Hello",
     * 				"E2E/Sent/POI/Address1":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber1":"133166363",
     * 				"E2E/Sent/POI/Latitude1":40.7127837,
     * 				"E2E/Sent/POI/Longitude1":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode1":"South",
     * 				"E2E/Sent/POI/LongitudeMode1":"East",
     * 				"E2E/Sent/POI/LocationType1":"Tokyo",
     * 				"E2E/Sent/POI/Name2":"RN Showroom",
     * 				"E2E/Sent/POI/TTS2":"Hello",
     * 				"E2E/Sent/POI/Address2":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber2":"133166363",
     * 				"E2E/Sent/POI/Latitude2":40.7127837,
     * 				"E2E/Sent/POI/Longitude2":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode2":"South",
     * 				"E2E/Sent/POI/LongitudeMode2":"East",
     * 				"E2E/Sent/POI/LocationType2":"Tokyo",
     * 				"E2E/Sent/POI/Name3":"RN Showroom",
     * 				"E2E/Sent/POI/TTS3":"Hello",
     * 				"E2E/Sent/POI/Address3":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber3":"133166363",
     * 				"E2E/Sent/POI/Latitude3":40.7127837,
     * 				"E2E/Sent/POI/Longitude3":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode3":"South",
     * 				"E2E/Sent/POI/LongitudeMode3":"East",
     * 				"E2E/Sent/POI/LocationType3":"Tokyo",
     * 				"E2E/Sent/POI/Name4":"RN Showroom",
     * 				"E2E/Sent/POI/TTS4":"Hello",
     * 				"E2E/Sent/POI/Address4":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber4":"133166363",
     * 				"E2E/Sent/POI/Latitude4":40.7127837,
     * 				"E2E/Sent/POI/Longitude4":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode4":"South",
     * 				"E2E/Sent/POI/LongitudeMode4":"East",
     * 				"E2E/Sent/POI/LocationType4":"Tokyo",
     * 				"E2E/Sent/POI/Name5":"RN Showroom",
     * 				"E2E/Sent/POI/TTS5":"Hello",
     * 				"E2E/Sent/POI/Address5":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber5":"133166363",
     * 				"E2E/Sent/POI/Latitude5":40.7127837,
     * 				"E2E/Sent/POI/Longitude5":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode5":"South",
     * 				"E2E/Sent/POI/LongitudeMode5":"East",
     * 				"E2E/Sent/POI/LocationType5":"Tokyo",
     * 				"E2E/Sent/POI/Name6":"RN Showroom",
     * 				"E2E/Sent/POI/TTS6":"Hello",
     * 				"E2E/Sent/POI/Address6":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber6":"133166363",
     * 				"E2E/Sent/POI/Latitude6":40.7127837,
     * 				"E2E/Sent/POI/Longitude6":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode6":"South",
     * 				"E2E/Sent/POI/LongitudeMode6":"East",
     * 				"E2E/Sent/POI/LocationType6":"Tokyo"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const RemotePushE2E_POIAckSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform remotePush E2E_Destination
 */
class RemotePushE2E_DestinationSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemotePushE2E_DestinationSignal ();

    /**
     * Copy constructor
     */
    inline  RemotePushE2E_DestinationSignal (const RemotePushE2E_DestinationSignal &rhs);

    /**
     * All fields constructor
     */
    inline  RemotePushE2E_DestinationSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~RemotePushE2E_DestinationSignal();

    /**
     * Assignment operator
     */
    inline RemotePushE2E_DestinationSignal& operator = (const RemotePushE2E_DestinationSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemotePushE2E_DestinationSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemotePushE2E_DestinationSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemotePushE2E_DestinationSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemotePushE2E_DestinationSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"E2E/Sent/Destination/DownloadTrafficInfo":"Yes",
     * 				"E2E/Sent/Destination/Name1":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS1":"Hello",
     * 				"E2E/Sent/Destination/Address1":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber1":"133166363",
     * 				"E2E/Sent/Destination/Latitude1":40.7127837,
     * 				"E2E/Sent/Destination/Longitude1":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode1":"South",
     * 				"E2E/Sent/Destination/LongitudeMode1":"East",
     * 				"E2E/Sent/Destination/LocationType1":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition1":"EcoRoute",
     * 				"E2E/Sent/Destination/Name2":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS2":"Hello",
     * 				"E2E/Sent/Destination/Address2":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber2":"133166363",
     * 				"E2E/Sent/Destination/Latitude2":40.7127837,
     * 				"E2E/Sent/Destination/Longitude2":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode2":"South",
     * 				"E2E/Sent/Destination/LongitudeMode2":"East",
     * 				"E2E/Sent/Destination/LocationType2":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition2":"EcoRoute",
     * 				"E2E/Sent/Destination/Name3":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS3":"Hello",
     * 				"E2E/Sent/Destination/Address3":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber3":"133166363",
     * 				"E2E/Sent/Destination/Latitude3":40.7127837,
     * 				"E2E/Sent/Destination/Longitude3":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode3":"South",
     * 				"E2E/Sent/Destination/LongitudeMode3":"East",
     * 				"E2E/Sent/Destination/LocationType3":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition3":"EcoRoute",
     * 				"E2E/Sent/Destination/Name4":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS4":"Hello",
     * 				"E2E/Sent/Destination/Address4":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber4":"133166363",
     * 				"E2E/Sent/Destination/Latitude4":40.7127837,
     * 				"E2E/Sent/Destination/Longitude4":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode4":"South",
     * 				"E2E/Sent/Destination/LongitudeMode4":"East",
     * 				"E2E/Sent/Destination/LocationType4":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition4":"EcoRoute",
     * 				"E2E/Sent/Destination/Name5":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS5":"Hello",
     * 				"E2E/Sent/Destination/Address5":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber5":"133166363",
     * 				"E2E/Sent/Destination/Latitude5":40.7127837,
     * 				"E2E/Sent/Destination/Longitude5":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode5":"South",
     * 				"E2E/Sent/Destination/LongitudeMode5":"East",
     * 				"E2E/Sent/Destination/LocationType5":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition5":"EcoRoute"
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"E2E/Sent/Destination/DownloadTrafficInfo":"Yes",
     * 				"E2E/Sent/Destination/Name1":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS1":"Hello",
     * 				"E2E/Sent/Destination/Address1":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber1":"133166363",
     * 				"E2E/Sent/Destination/Latitude1":40.7127837,
     * 				"E2E/Sent/Destination/Longitude1":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode1":"South",
     * 				"E2E/Sent/Destination/LongitudeMode1":"East",
     * 				"E2E/Sent/Destination/LocationType1":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition1":"EcoRoute",
     * 				"E2E/Sent/Destination/Name2":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS2":"Hello",
     * 				"E2E/Sent/Destination/Address2":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber2":"133166363",
     * 				"E2E/Sent/Destination/Latitude2":40.7127837,
     * 				"E2E/Sent/Destination/Longitude2":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode2":"South",
     * 				"E2E/Sent/Destination/LongitudeMode2":"East",
     * 				"E2E/Sent/Destination/LocationType2":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition2":"EcoRoute",
     * 				"E2E/Sent/Destination/Name3":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS3":"Hello",
     * 				"E2E/Sent/Destination/Address3":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber3":"133166363",
     * 				"E2E/Sent/Destination/Latitude3":40.7127837,
     * 				"E2E/Sent/Destination/Longitude3":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode3":"South",
     * 				"E2E/Sent/Destination/LongitudeMode3":"East",
     * 				"E2E/Sent/Destination/LocationType3":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition3":"EcoRoute",
     * 				"E2E/Sent/Destination/Name4":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS4":"Hello",
     * 				"E2E/Sent/Destination/Address4":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber4":"133166363",
     * 				"E2E/Sent/Destination/Latitude4":40.7127837,
     * 				"E2E/Sent/Destination/Longitude4":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode4":"South",
     * 				"E2E/Sent/Destination/LongitudeMode4":"East",
     * 				"E2E/Sent/Destination/LocationType4":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition4":"EcoRoute",
     * 				"E2E/Sent/Destination/Name5":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS5":"Hello",
     * 				"E2E/Sent/Destination/Address5":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber5":"133166363",
     * 				"E2E/Sent/Destination/Latitude5":40.7127837,
     * 				"E2E/Sent/Destination/Longitude5":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode5":"South",
     * 				"E2E/Sent/Destination/LongitudeMode5":"East",
     * 				"E2E/Sent/Destination/LocationType5":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition5":"EcoRoute"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"E2E/Sent/Destination/DownloadTrafficInfo":"Yes",
     * 				"E2E/Sent/Destination/Name1":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS1":"Hello",
     * 				"E2E/Sent/Destination/Address1":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber1":"133166363",
     * 				"E2E/Sent/Destination/Latitude1":40.7127837,
     * 				"E2E/Sent/Destination/Longitude1":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode1":"South",
     * 				"E2E/Sent/Destination/LongitudeMode1":"East",
     * 				"E2E/Sent/Destination/LocationType1":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition1":"EcoRoute",
     * 				"E2E/Sent/Destination/Name2":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS2":"Hello",
     * 				"E2E/Sent/Destination/Address2":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber2":"133166363",
     * 				"E2E/Sent/Destination/Latitude2":40.7127837,
     * 				"E2E/Sent/Destination/Longitude2":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode2":"South",
     * 				"E2E/Sent/Destination/LongitudeMode2":"East",
     * 				"E2E/Sent/Destination/LocationType2":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition2":"EcoRoute",
     * 				"E2E/Sent/Destination/Name3":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS3":"Hello",
     * 				"E2E/Sent/Destination/Address3":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber3":"133166363",
     * 				"E2E/Sent/Destination/Latitude3":40.7127837,
     * 				"E2E/Sent/Destination/Longitude3":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode3":"South",
     * 				"E2E/Sent/Destination/LongitudeMode3":"East",
     * 				"E2E/Sent/Destination/LocationType3":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition3":"EcoRoute",
     * 				"E2E/Sent/Destination/Name4":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS4":"Hello",
     * 				"E2E/Sent/Destination/Address4":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber4":"133166363",
     * 				"E2E/Sent/Destination/Latitude4":40.7127837,
     * 				"E2E/Sent/Destination/Longitude4":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode4":"South",
     * 				"E2E/Sent/Destination/LongitudeMode4":"East",
     * 				"E2E/Sent/Destination/LocationType4":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition4":"EcoRoute",
     * 				"E2E/Sent/Destination/Name5":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS5":"Hello",
     * 				"E2E/Sent/Destination/Address5":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber5":"133166363",
     * 				"E2E/Sent/Destination/Latitude5":40.7127837,
     * 				"E2E/Sent/Destination/Longitude5":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode5":"South",
     * 				"E2E/Sent/Destination/LongitudeMode5":"East",
     * 				"E2E/Sent/Destination/LocationType5":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition5":"EcoRoute"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"E2E/Sent/Destination/DownloadTrafficInfo":"Yes",
     * 				"E2E/Sent/Destination/Name1":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS1":"Hello",
     * 				"E2E/Sent/Destination/Address1":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber1":"133166363",
     * 				"E2E/Sent/Destination/Latitude1":40.7127837,
     * 				"E2E/Sent/Destination/Longitude1":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode1":"South",
     * 				"E2E/Sent/Destination/LongitudeMode1":"East",
     * 				"E2E/Sent/Destination/LocationType1":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition1":"EcoRoute",
     * 				"E2E/Sent/Destination/Name2":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS2":"Hello",
     * 				"E2E/Sent/Destination/Address2":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber2":"133166363",
     * 				"E2E/Sent/Destination/Latitude2":40.7127837,
     * 				"E2E/Sent/Destination/Longitude2":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode2":"South",
     * 				"E2E/Sent/Destination/LongitudeMode2":"East",
     * 				"E2E/Sent/Destination/LocationType2":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition2":"EcoRoute",
     * 				"E2E/Sent/Destination/Name3":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS3":"Hello",
     * 				"E2E/Sent/Destination/Address3":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber3":"133166363",
     * 				"E2E/Sent/Destination/Latitude3":40.7127837,
     * 				"E2E/Sent/Destination/Longitude3":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode3":"South",
     * 				"E2E/Sent/Destination/LongitudeMode3":"East",
     * 				"E2E/Sent/Destination/LocationType3":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition3":"EcoRoute",
     * 				"E2E/Sent/Destination/Name4":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS4":"Hello",
     * 				"E2E/Sent/Destination/Address4":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber4":"133166363",
     * 				"E2E/Sent/Destination/Latitude4":40.7127837,
     * 				"E2E/Sent/Destination/Longitude4":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode4":"South",
     * 				"E2E/Sent/Destination/LongitudeMode4":"East",
     * 				"E2E/Sent/Destination/LocationType4":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition4":"EcoRoute",
     * 				"E2E/Sent/Destination/Name5":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS5":"Hello",
     * 				"E2E/Sent/Destination/Address5":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber5":"133166363",
     * 				"E2E/Sent/Destination/Latitude5":40.7127837,
     * 				"E2E/Sent/Destination/Longitude5":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode5":"South",
     * 				"E2E/Sent/Destination/LongitudeMode5":"East",
     * 				"E2E/Sent/Destination/LocationType5":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition5":"EcoRoute"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const RemotePushE2E_DestinationSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform Remote Order Managed Apps
 */
class ManagedApps_RemoteOrderSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ManagedApps_RemoteOrderSignal ();

    /**
     * Copy constructor
     */
    inline  ManagedApps_RemoteOrderSignal (const ManagedApps_RemoteOrderSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ManagedApps_RemoteOrderSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~ManagedApps_RemoteOrderSignal();

    /**
     * Assignment operator
     */
    inline ManagedApps_RemoteOrderSignal& operator = (const ManagedApps_RemoteOrderSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ManagedApps_RemoteOrderSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ManagedApps_RemoteOrderSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ManagedApps_RemoteOrderSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ManagedApps_RemoteOrderSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     *
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     *
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     *
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     *
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const ManagedApps_RemoteOrderSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform Remote Request Managed Apps
 */
class ManagedApps_RemoteRequestSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ManagedApps_RemoteRequestSignal ();

    /**
     * Copy constructor
     */
    inline  ManagedApps_RemoteRequestSignal (const ManagedApps_RemoteRequestSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ManagedApps_RemoteRequestSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~ManagedApps_RemoteRequestSignal();

    /**
     * Assignment operator
     */
    inline ManagedApps_RemoteRequestSignal& operator = (const ManagedApps_RemoteRequestSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ManagedApps_RemoteRequestSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ManagedApps_RemoteRequestSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ManagedApps_RemoteRequestSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ManagedApps_RemoteRequestSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 				"ManagedApps/Received/RemoteRequest/Parameters":"0"
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 				"ManagedApps/Received/RemoteRequest/Parameters":"0"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 				"ManagedApps/Received/RemoteRequest/Parameters":"0"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 				"ManagedApps/Received/RemoteRequest/Parameters":"0"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const ManagedApps_RemoteRequestSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform Remote Setting Managed Apps
 */
class ManagedApps_RemoteSettingSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ManagedApps_RemoteSettingSignal ();

    /**
     * Copy constructor
     */
    inline  ManagedApps_RemoteSettingSignal (const ManagedApps_RemoteSettingSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ManagedApps_RemoteSettingSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~ManagedApps_RemoteSettingSignal();

    /**
     * Assignment operator
     */
    inline ManagedApps_RemoteSettingSignal& operator = (const ManagedApps_RemoteSettingSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ManagedApps_RemoteSettingSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ManagedApps_RemoteSettingSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ManagedApps_RemoteSettingSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ManagedApps_RemoteSettingSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 				"ManagedApps_[1..20]/Received/RemoteSetting/Parameters":"values"
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 				"ManagedApps_[1..20]/Received/RemoteSetting/Parameters":"values"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 				"ManagedApps_[1..20]/Received/RemoteSetting/Parameters":"values"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 				"ManagedApps_[1..20]/Received/RemoteSetting/Parameters":"values"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const ManagedApps_RemoteSettingSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform VPALogs
 */
class VPALogsSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VPALogsSignal ();

    /**
     * Copy constructor
     */
    inline  VPALogsSignal (const VPALogsSignal &rhs);

    /**
     * All fields constructor
     */
    inline  VPALogsSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~VPALogsSignal();

    /**
     * Assignment operator
     */
    inline VPALogsSignal& operator = (const VPALogsSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VPALogsSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VPALogsSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VPALogsSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VPALogsSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const VPALogsSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform VPATelemetry
 */
class VPATelemetrySignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VPATelemetrySignal ();

    /**
     * Copy constructor
     */
    inline  VPATelemetrySignal (const VPATelemetrySignal &rhs);

    /**
     * All fields constructor
     */
    inline  VPATelemetrySignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~VPATelemetrySignal();

    /**
     * Assignment operator
     */
    inline VPATelemetrySignal& operator = (const VPATelemetrySignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VPATelemetrySignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VPATelemetrySignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VPATelemetrySignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VPATelemetrySignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const VPATelemetrySignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform ValetMode
 */
class ValetModeSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ValetModeSignal ();

    /**
     * Copy constructor
     */
    inline  ValetModeSignal (const ValetModeSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ValetModeSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~ValetModeSignal();

    /**
     * Assignment operator
     */
    inline ValetModeSignal& operator = (const ValetModeSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ValetModeSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ValetModeSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ValetModeSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ValetModeSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"ValetMode/Received/RemoteOrder/Action":"1"
     *
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"ValetMode/Received/RemoteOrder/Action":"1"
     *
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"ValetMode/Received/RemoteOrder/Action":"1"
     *
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"ValetMode/Received/RemoteOrder/Action":"1"
     *
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const ValetModeSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform LogActivation
 */
class LogActivationSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LogActivationSignal ();

    /**
     * Copy constructor
     */
    inline  LogActivationSignal (const LogActivationSignal &rhs);

    /**
     * All fields constructor
     */
    inline  LogActivationSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~LogActivationSignal();

    /**
     * Assignment operator
     */
    inline LogActivationSignal& operator = (const LogActivationSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LogActivationSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LogActivationSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LogActivationSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LogActivationSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteOrder/LogType":"0",
     * 				"Log/Received/RemoteOrder/Command":"0",
     * 				"Log/Received/RemoteOrder/ComponentName":"1",
     * 				"Log/Received/RemoteOrder/LogLevel":"T",
     * 				"Log/Received/RemoteOrder/LogId":"1",
     * 				"Log/Received/RemoteOrder/StartDate":"0",
     * 				"Log/Received/RemoteOrder/EndDate":"0"
     *
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteOrder/LogType":"0",
     * 				"Log/Received/RemoteOrder/Command":"0",
     * 				"Log/Received/RemoteOrder/ComponentName":"1",
     * 				"Log/Received/RemoteOrder/LogLevel":"T",
     * 				"Log/Received/RemoteOrder/LogId":"1",
     * 				"Log/Received/RemoteOrder/StartDate":"0",
     * 				"Log/Received/RemoteOrder/EndDate":"0"
     *
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteOrder/LogType":"0",
     * 				"Log/Received/RemoteOrder/Command":"0",
     * 				"Log/Received/RemoteOrder/ComponentName":"1",
     * 				"Log/Received/RemoteOrder/LogLevel":"T",
     * 				"Log/Received/RemoteOrder/LogId":"1",
     * 				"Log/Received/RemoteOrder/StartDate":"0",
     * 				"Log/Received/RemoteOrder/EndDate":"0"
     *
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteOrder/LogType":"0",
     * 				"Log/Received/RemoteOrder/Command":"0",
     * 				"Log/Received/RemoteOrder/ComponentName":"1",
     * 				"Log/Received/RemoteOrder/LogLevel":"T",
     * 				"Log/Received/RemoteOrder/LogId":"1",
     * 				"Log/Received/RemoteOrder/StartDate":"0",
     * 				"Log/Received/RemoteOrder/EndDate":"0"
     *
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const LogActivationSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform LogRequest
 */
class LogRequestSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LogRequestSignal ();

    /**
     * Copy constructor
     */
    inline  LogRequestSignal (const LogRequestSignal &rhs);

    /**
     * All fields constructor
     */
    inline  LogRequestSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~LogRequestSignal();

    /**
     * Assignment operator
     */
    inline LogRequestSignal& operator = (const LogRequestSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LogRequestSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LogRequestSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LogRequestSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LogRequestSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteRequest/LogType":"0",
     * 				"Log/Received/RemoteRequest/ComponentName":"VPA",
     * 				"Log/Received/RemoteRequest/LogLevel":"T",
     * 				"Log/Received/RemoteRequest/LogBufferClean":"0"
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteRequest/LogType":"0",
     * 				"Log/Received/RemoteRequest/ComponentName":"VPA",
     * 				"Log/Received/RemoteRequest/LogLevel":"T",
     * 				"Log/Received/RemoteRequest/LogBufferClean":"0"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteRequest/LogType":"0",
     * 				"Log/Received/RemoteRequest/ComponentName":"VPA",
     * 				"Log/Received/RemoteRequest/LogLevel":"T",
     * 				"Log/Received/RemoteRequest/LogBufferClean":"0"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteRequest/LogType":"0",
     * 				"Log/Received/RemoteRequest/ComponentName":"VPA",
     * 				"Log/Received/RemoteRequest/LogLevel":"T",
     * 				"Log/Received/RemoteRequest/LogBufferClean":"0"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const LogRequestSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform LogTune
 */
class LogTuneSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LogTuneSignal ();

    /**
     * Copy constructor
     */
    inline  LogTuneSignal (const LogTuneSignal &rhs);

    /**
     * All fields constructor
     */
    inline  LogTuneSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~LogTuneSignal();

    /**
     * Assignment operator
     */
    inline LogTuneSignal& operator = (const LogTuneSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LogTuneSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LogTuneSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LogTuneSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LogTuneSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteSetting/LogId":0,
     * 				"Log/Received/RemoteSetting/LogBody":"0",
     * 				"Log/Received/RemoteSetting/LogTriggers":"periodic",
     * 				"Log/Received/RemoteSetting/LogPriority":"1",
     * 				"Log/Received/RemoteSetting/LogCategory":"1",
     * 				"Log/Received/RemoteSetting/LogGatheringPeriodicity":0,
     * 				"Log/Received/RemoteSetting/LogSendingPeriodicity":0,
     * 				"Log/Received/RemoteSetting/StartDate":"0",
     * 				"Log/Received/RemoteSetting/EndDate":"0"
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteSetting/LogId":0,
     * 				"Log/Received/RemoteSetting/LogBody":"0",
     * 				"Log/Received/RemoteSetting/LogTriggers":"periodic",
     * 				"Log/Received/RemoteSetting/LogPriority":"1",
     * 				"Log/Received/RemoteSetting/LogCategory":"1",
     * 				"Log/Received/RemoteSetting/LogGatheringPeriodicity":0,
     * 				"Log/Received/RemoteSetting/LogSendingPeriodicity":0,
     * 				"Log/Received/RemoteSetting/StartDate":"0",
     * 				"Log/Received/RemoteSetting/EndDate":"0"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteSetting/LogId":0,
     * 				"Log/Received/RemoteSetting/LogBody":"0",
     * 				"Log/Received/RemoteSetting/LogTriggers":"periodic",
     * 				"Log/Received/RemoteSetting/LogPriority":"1",
     * 				"Log/Received/RemoteSetting/LogCategory":"1",
     * 				"Log/Received/RemoteSetting/LogGatheringPeriodicity":0,
     * 				"Log/Received/RemoteSetting/LogSendingPeriodicity":0,
     * 				"Log/Received/RemoteSetting/StartDate":"0",
     * 				"Log/Received/RemoteSetting/EndDate":"0"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteSetting/LogId":0,
     * 				"Log/Received/RemoteSetting/LogBody":"0",
     * 				"Log/Received/RemoteSetting/LogTriggers":"periodic",
     * 				"Log/Received/RemoteSetting/LogPriority":"1",
     * 				"Log/Received/RemoteSetting/LogCategory":"1",
     * 				"Log/Received/RemoteSetting/LogGatheringPeriodicity":0,
     * 				"Log/Received/RemoteSetting/LogSendingPeriodicity":0,
     * 				"Log/Received/RemoteSetting/StartDate":"0",
     * 				"Log/Received/RemoteSetting/EndDate":"0"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const LogTuneSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform LogSetProbeVerbosity
 */
class LogSetProbeVerbositySignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LogSetProbeVerbositySignal ();

    /**
     * Copy constructor
     */
    inline  LogSetProbeVerbositySignal (const LogSetProbeVerbositySignal &rhs);

    /**
     * All fields constructor
     */
    inline  LogSetProbeVerbositySignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~LogSetProbeVerbositySignal();

    /**
     * Assignment operator
     */
    inline LogSetProbeVerbositySignal& operator = (const LogSetProbeVerbositySignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LogSetProbeVerbositySignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LogSetProbeVerbositySignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LogSetProbeVerbositySignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LogSetProbeVerbositySignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteSetting/LogSetProbeVerbosityId":"0",
     * 				"Log/Received/RemoteSetting/LogSetProbeVerbosityFreq":"0"
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteSetting/LogSetProbeVerbosityId":"0",
     * 				"Log/Received/RemoteSetting/LogSetProbeVerbosityFreq":"0"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteSetting/LogSetProbeVerbosityId":"0",
     * 				"Log/Received/RemoteSetting/LogSetProbeVerbosityFreq":"0"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteSetting/LogSetProbeVerbosityId":"0",
     * 				"Log/Received/RemoteSetting/LogSetProbeVerbosityFreq":"0"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const LogSetProbeVerbositySignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform LogSetSLogBufferSize
 */
class LogSetSLogBufferSizeSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LogSetSLogBufferSizeSignal ();

    /**
     * Copy constructor
     */
    inline  LogSetSLogBufferSizeSignal (const LogSetSLogBufferSizeSignal &rhs);

    /**
     * All fields constructor
     */
    inline  LogSetSLogBufferSizeSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~LogSetSLogBufferSizeSignal();

    /**
     * Assignment operator
     */
    inline LogSetSLogBufferSizeSignal& operator = (const LogSetSLogBufferSizeSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LogSetSLogBufferSizeSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LogSetSLogBufferSizeSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LogSetSLogBufferSizeSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LogSetSLogBufferSizeSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteSetting/LogBufferName":"0",
     * 				"Log/Received/RemoteSetting/LogBufferSize":"0"
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteSetting/LogBufferName":"0",
     * 				"Log/Received/RemoteSetting/LogBufferSize":"0"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteSetting/LogBufferName":"0",
     * 				"Log/Received/RemoteSetting/LogBufferSize":"0"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteSetting/LogBufferName":"0",
     * 				"Log/Received/RemoteSetting/LogBufferSize":"0"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const LogSetSLogBufferSizeSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform LogSetDefaultLogConfig
 */
class LogSetDefaultLogConfigSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LogSetDefaultLogConfigSignal ();

    /**
     * Copy constructor
     */
    inline  LogSetDefaultLogConfigSignal (const LogSetDefaultLogConfigSignal &rhs);

    /**
     * All fields constructor
     */
    inline  LogSetDefaultLogConfigSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~LogSetDefaultLogConfigSignal();

    /**
     * Assignment operator
     */
    inline LogSetDefaultLogConfigSignal& operator = (const LogSetDefaultLogConfigSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LogSetDefaultLogConfigSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LogSetDefaultLogConfigSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LogSetDefaultLogConfigSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LogSetDefaultLogConfigSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteSetting/LogConfigFile":"0"
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteSetting/LogConfigFile":"0"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteSetting/LogConfigFile":"0"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteSetting/LogConfigFile":"0"
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const LogSetDefaultLogConfigSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform Navigation - Map Install Request ACK
 */
class MapInstallRequestACKSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MapInstallRequestACKSignal ();

    /**
     * Copy constructor
     */
    inline  MapInstallRequestACKSignal (const MapInstallRequestACKSignal &rhs);

    /**
     * All fields constructor
     */
    inline  MapInstallRequestACKSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~MapInstallRequestACKSignal();

    /**
     * Assignment operator
     */
    inline MapInstallRequestACKSignal& operator = (const MapInstallRequestACKSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MapInstallRequestACKSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MapInstallRequestACKSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MapInstallRequestACKSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MapInstallRequestACKSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"RemoteOrder/Received/ACK/MapInstallRequest/Status":0,
     * 				"RemoteOrder/Received/ACK/MapInstallRequest/ErrorCode":2
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"RemoteOrder/Received/ACK/MapInstallRequest/Status":0,
     * 				"RemoteOrder/Received/ACK/MapInstallRequest/ErrorCode":2
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"RemoteOrder/Received/ACK/MapInstallRequest/Status":0,
     * 				"RemoteOrder/Received/ACK/MapInstallRequest/ErrorCode":2
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"RemoteOrder/Received/ACK/MapInstallRequest/Status":0,
     * 				"RemoteOrder/Received/ACK/MapInstallRequest/ErrorCode":2
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const MapInstallRequestACKSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

/**
 * Signal to inform Navigation - Map Install Status Request ACK
 */
class MapInstallStatusRequestACKSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MapInstallStatusRequestACKSignal ();

    /**
     * Copy constructor
     */
    inline  MapInstallStatusRequestACKSignal (const MapInstallStatusRequestACKSignal &rhs);

    /**
     * All fields constructor
     */
    inline  MapInstallStatusRequestACKSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_);

    /**
     * Destructor
     */
    inline virtual  ~MapInstallStatusRequestACKSignal();

    /**
     * Assignment operator
     */
    inline MapInstallStatusRequestACKSignal& operator = (const MapInstallStatusRequestACKSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MapInstallStatusRequestACKSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MapInstallStatusRequestACKSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MapInstallStatusRequestACKSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MapInstallStatusRequestACKSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "jsonDownloadHeader"

    static const int kJsonDownloadHeader = 0;

    /**
     * Clears the field "jsonDownloadHeader".
     *
     * The field will be set to its default value. The hasJsonDownloadHeader()
     * method will return false.
     */
    inline void clearJsonDownloadHeader();

    /**
     * Checks whether the field "jsonDownloadHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadHeader()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadHeader () const;

    /**
     * Returns the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @return The value of the field "jsonDownloadHeader"
     */
    inline const ::std::string& getJsonDownloadHeader () const;

    /**
     * Retrieves the value of the field "jsonDownloadHeader" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadHeader".
     */
    inline ::std::string& getJsonDownloadHeaderMutable ();

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* jsonDownloadHeader_);

    /**
     * Sets the value of the member "jsonDownloadHeader".
     *
     * Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadHeader The value which will be set
     */
    inline void setJsonDownloadHeader (const char* value, size_t size);

    // API of field "jsonDownloadData"

    static const int kJsonDownloadData = 1;

    /**
     * Clears the field "jsonDownloadData".
     *
     * The field will be set to its default value. The hasJsonDownloadData()
     * method will return false.
     */
    inline void clearJsonDownloadData();

    /**
     * Checks whether the field "jsonDownloadData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setJsonDownloadData()). Otherwise it will return false.
     */
    inline bool hasJsonDownloadData () const;

    /**
     * Returns the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"RemoteOrder/Received/ACK/MapInstallRequest/Status":0,
     * 				"RemoteOrder/Received/ACK/MapInstallRequest/ErrorCode":2
     * 			}
     *
     * @return The value of the field "jsonDownloadData"
     */
    inline const ::std::string& getJsonDownloadData () const;

    /**
     * Retrieves the value of the field "jsonDownloadData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "jsonDownloadData".
     */
    inline ::std::string& getJsonDownloadDataMutable ();

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"RemoteOrder/Received/ACK/MapInstallRequest/Status":0,
     * 				"RemoteOrder/Received/ACK/MapInstallRequest/ErrorCode":2
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const ::std::string& jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"RemoteOrder/Received/ACK/MapInstallRequest/Status":0,
     * 				"RemoteOrder/Received/ACK/MapInstallRequest/ErrorCode":2
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* jsonDownloadData_);

    /**
     * Sets the value of the member "jsonDownloadData".
     *
     * Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"RemoteOrder/Received/ACK/MapInstallRequest/Status":0,
     * 				"RemoteOrder/Received/ACK/MapInstallRequest/ErrorCode":2
     * 			}
     *
     * @param jsonDownloadData The value which will be set
     */
    inline void setJsonDownloadData (const char* value, size_t size);

    static const MapInstallStatusRequestACKSignal &getDefaultInstance();

private:

    inline void set_has_jsonDownloadHeader ();

    inline void clear_has_jsonDownloadHeader ();

    inline void set_has_jsonDownloadData ();

    inline void clear_has_jsonDownloadData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _jsonDownloadHeader;

    ::std::string _jsonDownloadData;

};

inline  RequestInfo::RequestInfo ()  :
    _responseStatus (::com::bosch::cm::dumm::DummService::ResponseStatus__OK),
    _CorrelationId (),
    _uploadFunctionID (::com::bosch::cm::dumm::DummService::UploadFunctionID__Unknown),
    _requestState (::com::bosch::cm::dumm::DummService::RequestState__UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestInfo::RequestInfo (const RequestInfo &rhs)  :
    _responseStatus (::com::bosch::cm::dumm::DummService::ResponseStatus__OK),
    _CorrelationId (),
    _uploadFunctionID (::com::bosch::cm::dumm::DummService::UploadFunctionID__Unknown),
    _requestState (::com::bosch::cm::dumm::DummService::RequestState__UNKNOWN)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestInfo::RequestInfo (ResponseStatus responseStatus_, const ::std::string& CorrelationId_, UploadFunctionID uploadFunctionID_, RequestState requestState_)  :
    _responseStatus (responseStatus_),
    _CorrelationId (CorrelationId_),
    _uploadFunctionID (uploadFunctionID_),
    _requestState (requestState_)
{
    #ifndef NDEBUG
    if (!(ResponseStatus_IsValid(responseStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", responseStatus_, "ResponseStatus", "responseStatus", "RequestInfo");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CorrelationId_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(UploadFunctionID_IsValid(uploadFunctionID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", uploadFunctionID_, "UploadFunctionID", "uploadFunctionID", "RequestInfo");
    }
    #endif
    #ifndef NDEBUG
    if (!(RequestState_IsValid(requestState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", requestState_, "RequestState", "requestState", "RequestInfo");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestInfo::~RequestInfo() {
}

inline RequestInfo& RequestInfo::operator = (const RequestInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasResponseStatus()) {
            setResponseStatus(rhs.getResponseStatus());
        } else {
            clearResponseStatus();
        }
        if (rhs.hasCorrelationId()) {
            setCorrelationId(rhs.getCorrelationId());
        } else {
            clearCorrelationId();
        }
        if (rhs.hasUploadFunctionID()) {
            setUploadFunctionID(rhs.getUploadFunctionID());
        } else {
            clearUploadFunctionID();
        }
        if (rhs.hasRequestState()) {
            setRequestState(rhs.getRequestState());
        } else {
            clearRequestState();
        }
    }
    return *this;
}

inline bool RequestInfo::operator == (const RequestInfo& rhs) const {
    return (((!hasResponseStatus() && !rhs.hasResponseStatus()) || getResponseStatus() == rhs.getResponseStatus()) &&
        ((!hasCorrelationId() && !rhs.hasCorrelationId()) || getCorrelationId() == rhs.getCorrelationId()) &&
        ((!hasUploadFunctionID() && !rhs.hasUploadFunctionID()) || getUploadFunctionID() == rhs.getUploadFunctionID()) &&
        ((!hasRequestState() && !rhs.hasRequestState()) || getRequestState() == rhs.getRequestState()));
}

inline bool RequestInfo::operator != (const RequestInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestInfo::operator < (const RequestInfo& rhs) const {
    if (hasResponseStatus() || rhs.hasResponseStatus()) {
        if ((uint32)getResponseStatus() < (uint32)rhs.getResponseStatus()) return true;
        if ((uint32)getResponseStatus() > (uint32)rhs.getResponseStatus()) return false;
    }
    if (hasCorrelationId() || rhs.hasCorrelationId()) {
        if (getCorrelationId() < rhs.getCorrelationId()) return true;
        if (getCorrelationId() > rhs.getCorrelationId()) return false;
    }
    if (hasUploadFunctionID() || rhs.hasUploadFunctionID()) {
        if ((uint32)getUploadFunctionID() < (uint32)rhs.getUploadFunctionID()) return true;
        if ((uint32)getUploadFunctionID() > (uint32)rhs.getUploadFunctionID()) return false;
    }
    if (hasRequestState() || rhs.hasRequestState()) {
        if ((uint32)getRequestState() < (uint32)rhs.getRequestState()) return true;
        if ((uint32)getRequestState() > (uint32)rhs.getRequestState()) return false;
    }
    return false;
}

inline bool RequestInfo::operator > (const RequestInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestInfo::clear() {
    clearResponseStatus();
    clearCorrelationId();
    clearUploadFunctionID();
    clearRequestState();
}

inline void RequestInfo::clearResponseStatus() {
    if (hasResponseStatus()) {
         clear_has_responseStatus();
        _responseStatus = ::com::bosch::cm::dumm::DummService::ResponseStatus__OK;
     }
}

inline bool RequestInfo::hasResponseStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ResponseStatus RequestInfo::getResponseStatus () const {
    return _responseStatus;
}

inline void RequestInfo::setResponseStatus (ResponseStatus responseStatus_) {
    #ifndef NDEBUG
    if (!(ResponseStatus_IsValid(responseStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", responseStatus_, "ResponseStatus", "responseStatus", "RequestInfo");
    }
    #endif
    set_has_responseStatus();
    this->_responseStatus = responseStatus_;
}

inline void RequestInfo::clearCorrelationId() {
    if (hasCorrelationId()) {
         clear_has_CorrelationId();
        _CorrelationId.clear();
     }
}

inline bool RequestInfo::hasCorrelationId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& RequestInfo::getCorrelationId () const {
    return _CorrelationId;
}

inline ::std::string& RequestInfo::getCorrelationIdMutable () {
    set_has_CorrelationId();
    return _CorrelationId;
}

inline void RequestInfo::setCorrelationId (const ::std::string& CorrelationId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CorrelationId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CorrelationId();
    this->_CorrelationId = CorrelationId_;
}

inline void RequestInfo::setCorrelationId (const char* CorrelationId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CorrelationId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CorrelationId();
    this->_CorrelationId.assign(CorrelationId_);
}

inline void RequestInfo::setCorrelationId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CorrelationId();
    this->_CorrelationId.assign(value, size);
}

inline void RequestInfo::clearUploadFunctionID() {
    if (hasUploadFunctionID()) {
         clear_has_uploadFunctionID();
        _uploadFunctionID = ::com::bosch::cm::dumm::DummService::UploadFunctionID__Unknown;
     }
}

inline bool RequestInfo::hasUploadFunctionID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline UploadFunctionID RequestInfo::getUploadFunctionID () const {
    return _uploadFunctionID;
}

inline void RequestInfo::setUploadFunctionID (UploadFunctionID uploadFunctionID_) {
    #ifndef NDEBUG
    if (!(UploadFunctionID_IsValid(uploadFunctionID_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", uploadFunctionID_, "UploadFunctionID", "uploadFunctionID", "RequestInfo");
    }
    #endif
    set_has_uploadFunctionID();
    this->_uploadFunctionID = uploadFunctionID_;
}

inline void RequestInfo::clearRequestState() {
    if (hasRequestState()) {
         clear_has_requestState();
        _requestState = ::com::bosch::cm::dumm::DummService::RequestState__UNKNOWN;
     }
}

inline bool RequestInfo::hasRequestState () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline RequestState RequestInfo::getRequestState () const {
    return _requestState;
}

inline void RequestInfo::setRequestState (RequestState requestState_) {
    #ifndef NDEBUG
    if (!(RequestState_IsValid(requestState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", requestState_, "RequestState", "requestState", "RequestInfo");
    }
    #endif
    set_has_requestState();
    this->_requestState = requestState_;
}

inline void RequestInfo::set_has_responseStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestInfo::clear_has_responseStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RequestInfo::set_has_CorrelationId () {
    _has_bits_[0] |= 1u << 1;
}

inline void RequestInfo::clear_has_CorrelationId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RequestInfo::set_has_uploadFunctionID () {
    _has_bits_[0] |= 1u << 2;
}

inline void RequestInfo::clear_has_uploadFunctionID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void RequestInfo::set_has_requestState () {
    _has_bits_[0] |= 1u << 3;
}

inline void RequestInfo::clear_has_requestState () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  GenCorrelationIdResponse::GenCorrelationIdResponse ()  :
    _CorrelationId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GenCorrelationIdResponse::GenCorrelationIdResponse (const GenCorrelationIdResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _CorrelationId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GenCorrelationIdResponse::GenCorrelationIdResponse (const ::std::string& CorrelationId_)  :
    _CorrelationId (CorrelationId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CorrelationId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GenCorrelationIdResponse::~GenCorrelationIdResponse() {
}

inline GenCorrelationIdResponse& GenCorrelationIdResponse::operator = (const GenCorrelationIdResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCorrelationId()) {
            setCorrelationId(rhs.getCorrelationId());
        } else {
            clearCorrelationId();
        }
    }
    return *this;
}

inline bool GenCorrelationIdResponse::operator == (const GenCorrelationIdResponse& rhs) const {
    return (((!hasCorrelationId() && !rhs.hasCorrelationId()) || getCorrelationId() == rhs.getCorrelationId()));
}

inline bool GenCorrelationIdResponse::operator != (const GenCorrelationIdResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GenCorrelationIdResponse::operator < (const GenCorrelationIdResponse& rhs) const {
    if (hasCorrelationId() || rhs.hasCorrelationId()) {
        if (getCorrelationId() < rhs.getCorrelationId()) return true;
        if (getCorrelationId() > rhs.getCorrelationId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GenCorrelationIdResponse::clone() {
    return new GenCorrelationIdResponse(*this);
}

inline bool GenCorrelationIdResponse::operator > (const GenCorrelationIdResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GenCorrelationIdResponse::clear() {
    clearCorrelationId();
}

inline void GenCorrelationIdResponse::clearCorrelationId() {
    if (hasCorrelationId()) {
         clear_has_CorrelationId();
        _CorrelationId.clear();
     }
}

inline bool GenCorrelationIdResponse::hasCorrelationId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GenCorrelationIdResponse::getCorrelationId () const {
    return _CorrelationId;
}

inline ::std::string& GenCorrelationIdResponse::getCorrelationIdMutable () {
    set_has_CorrelationId();
    return _CorrelationId;
}

inline void GenCorrelationIdResponse::setCorrelationId (const ::std::string& CorrelationId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CorrelationId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CorrelationId();
    this->_CorrelationId = CorrelationId_;
}

inline void GenCorrelationIdResponse::setCorrelationId (const char* CorrelationId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CorrelationId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CorrelationId();
    this->_CorrelationId.assign(CorrelationId_);
}

inline void GenCorrelationIdResponse::setCorrelationId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CorrelationId();
    this->_CorrelationId.assign(value, size);
}

inline void GenCorrelationIdResponse::set_has_CorrelationId () {
    _has_bits_[0] |= 1u << 0;
}

inline void GenCorrelationIdResponse::clear_has_CorrelationId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  UploadDataRequest::UploadDataRequest ()  :
    _jsonUploadHeader (),
    _jsonUploadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UploadDataRequest::UploadDataRequest (const UploadDataRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonUploadHeader (),
    _jsonUploadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UploadDataRequest::UploadDataRequest (const ::std::string& jsonUploadHeader_, const ::std::string& jsonUploadData_)  :
    _jsonUploadHeader (jsonUploadHeader_),
    _jsonUploadData (jsonUploadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonUploadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonUploadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UploadDataRequest::~UploadDataRequest() {
}

inline UploadDataRequest& UploadDataRequest::operator = (const UploadDataRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonUploadHeader()) {
            setJsonUploadHeader(rhs.getJsonUploadHeader());
        } else {
            clearJsonUploadHeader();
        }
        if (rhs.hasJsonUploadData()) {
            setJsonUploadData(rhs.getJsonUploadData());
        } else {
            clearJsonUploadData();
        }
    }
    return *this;
}

inline bool UploadDataRequest::operator == (const UploadDataRequest& rhs) const {
    return (((!hasJsonUploadHeader() && !rhs.hasJsonUploadHeader()) || getJsonUploadHeader() == rhs.getJsonUploadHeader()) &&
        ((!hasJsonUploadData() && !rhs.hasJsonUploadData()) || getJsonUploadData() == rhs.getJsonUploadData()));
}

inline bool UploadDataRequest::operator != (const UploadDataRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool UploadDataRequest::operator < (const UploadDataRequest& rhs) const {
    if (hasJsonUploadHeader() || rhs.hasJsonUploadHeader()) {
        if (getJsonUploadHeader() < rhs.getJsonUploadHeader()) return true;
        if (getJsonUploadHeader() > rhs.getJsonUploadHeader()) return false;
    }
    if (hasJsonUploadData() || rhs.hasJsonUploadData()) {
        if (getJsonUploadData() < rhs.getJsonUploadData()) return true;
        if (getJsonUploadData() > rhs.getJsonUploadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UploadDataRequest::clone() {
    return new UploadDataRequest(*this);
}

inline bool UploadDataRequest::operator > (const UploadDataRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UploadDataRequest::clear() {
    clearJsonUploadHeader();
    clearJsonUploadData();
}

inline void UploadDataRequest::clearJsonUploadHeader() {
    if (hasJsonUploadHeader()) {
         clear_has_jsonUploadHeader();
        _jsonUploadHeader.clear();
     }
}

inline bool UploadDataRequest::hasJsonUploadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& UploadDataRequest::getJsonUploadHeader () const {
    return _jsonUploadHeader;
}

inline ::std::string& UploadDataRequest::getJsonUploadHeaderMutable () {
    set_has_jsonUploadHeader();
    return _jsonUploadHeader;
}

inline void UploadDataRequest::setJsonUploadHeader (const ::std::string& jsonUploadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonUploadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonUploadHeader();
    this->_jsonUploadHeader = jsonUploadHeader_;
}

inline void UploadDataRequest::setJsonUploadHeader (const char* jsonUploadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonUploadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonUploadHeader();
    this->_jsonUploadHeader.assign(jsonUploadHeader_);
}

inline void UploadDataRequest::setJsonUploadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonUploadHeader();
    this->_jsonUploadHeader.assign(value, size);
}

inline void UploadDataRequest::clearJsonUploadData() {
    if (hasJsonUploadData()) {
         clear_has_jsonUploadData();
        _jsonUploadData.clear();
     }
}

inline bool UploadDataRequest::hasJsonUploadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& UploadDataRequest::getJsonUploadData () const {
    return _jsonUploadData;
}

inline ::std::string& UploadDataRequest::getJsonUploadDataMutable () {
    set_has_jsonUploadData();
    return _jsonUploadData;
}

inline void UploadDataRequest::setJsonUploadData (const ::std::string& jsonUploadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonUploadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonUploadData();
    this->_jsonUploadData = jsonUploadData_;
}

inline void UploadDataRequest::setJsonUploadData (const char* jsonUploadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonUploadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonUploadData();
    this->_jsonUploadData.assign(jsonUploadData_);
}

inline void UploadDataRequest::setJsonUploadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonUploadData();
    this->_jsonUploadData.assign(value, size);
}

inline void UploadDataRequest::set_has_jsonUploadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void UploadDataRequest::clear_has_jsonUploadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void UploadDataRequest::set_has_jsonUploadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void UploadDataRequest::clear_has_jsonUploadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  UploadDataResponse::UploadDataResponse ()  :
    _requestInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UploadDataResponse::UploadDataResponse (const UploadDataResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _requestInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UploadDataResponse::UploadDataResponse (const RequestInfo& requestInfo_)  :
    _requestInfo (requestInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UploadDataResponse::~UploadDataResponse() {
}

inline UploadDataResponse& UploadDataResponse::operator = (const UploadDataResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRequestInfo()) {
            setRequestInfo(rhs.getRequestInfo());
        } else {
            clearRequestInfo();
        }
    }
    return *this;
}

inline bool UploadDataResponse::operator == (const UploadDataResponse& rhs) const {
    return (((!hasRequestInfo() && !rhs.hasRequestInfo()) || getRequestInfo() == rhs.getRequestInfo()));
}

inline bool UploadDataResponse::operator != (const UploadDataResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool UploadDataResponse::operator < (const UploadDataResponse& rhs) const {
    if (hasRequestInfo() || rhs.hasRequestInfo()) {
        if (getRequestInfo() < rhs.getRequestInfo()) return true;
        if (getRequestInfo() > rhs.getRequestInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UploadDataResponse::clone() {
    return new UploadDataResponse(*this);
}

inline bool UploadDataResponse::operator > (const UploadDataResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UploadDataResponse::clear() {
    clearRequestInfo();
}

inline void UploadDataResponse::clearRequestInfo() {
    if (hasRequestInfo()) {
         clear_has_requestInfo();
        _requestInfo.clear();
     }
}

inline bool UploadDataResponse::hasRequestInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const RequestInfo& UploadDataResponse::getRequestInfo () const {
    return _requestInfo;
}

inline RequestInfo& UploadDataResponse::getRequestInfoMutable () {
    set_has_requestInfo();
    return _requestInfo;
}

inline void UploadDataResponse::setRequestInfo (const RequestInfo& requestInfo_) {
    set_has_requestInfo();
    this->_requestInfo = requestInfo_;
}

inline void UploadDataResponse::set_has_requestInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void UploadDataResponse::clear_has_requestInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CancelUploadRequestRequest::CancelUploadRequestRequest ()  :
    _CorrelationId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CancelUploadRequestRequest::CancelUploadRequestRequest (const CancelUploadRequestRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _CorrelationId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CancelUploadRequestRequest::CancelUploadRequestRequest (const ::std::string& CorrelationId_)  :
    _CorrelationId (CorrelationId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CorrelationId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CancelUploadRequestRequest::~CancelUploadRequestRequest() {
}

inline CancelUploadRequestRequest& CancelUploadRequestRequest::operator = (const CancelUploadRequestRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCorrelationId()) {
            setCorrelationId(rhs.getCorrelationId());
        } else {
            clearCorrelationId();
        }
    }
    return *this;
}

inline bool CancelUploadRequestRequest::operator == (const CancelUploadRequestRequest& rhs) const {
    return (((!hasCorrelationId() && !rhs.hasCorrelationId()) || getCorrelationId() == rhs.getCorrelationId()));
}

inline bool CancelUploadRequestRequest::operator != (const CancelUploadRequestRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool CancelUploadRequestRequest::operator < (const CancelUploadRequestRequest& rhs) const {
    if (hasCorrelationId() || rhs.hasCorrelationId()) {
        if (getCorrelationId() < rhs.getCorrelationId()) return true;
        if (getCorrelationId() > rhs.getCorrelationId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CancelUploadRequestRequest::clone() {
    return new CancelUploadRequestRequest(*this);
}

inline bool CancelUploadRequestRequest::operator > (const CancelUploadRequestRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CancelUploadRequestRequest::clear() {
    clearCorrelationId();
}

inline void CancelUploadRequestRequest::clearCorrelationId() {
    if (hasCorrelationId()) {
         clear_has_CorrelationId();
        _CorrelationId.clear();
     }
}

inline bool CancelUploadRequestRequest::hasCorrelationId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& CancelUploadRequestRequest::getCorrelationId () const {
    return _CorrelationId;
}

inline ::std::string& CancelUploadRequestRequest::getCorrelationIdMutable () {
    set_has_CorrelationId();
    return _CorrelationId;
}

inline void CancelUploadRequestRequest::setCorrelationId (const ::std::string& CorrelationId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CorrelationId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CorrelationId();
    this->_CorrelationId = CorrelationId_;
}

inline void CancelUploadRequestRequest::setCorrelationId (const char* CorrelationId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CorrelationId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CorrelationId();
    this->_CorrelationId.assign(CorrelationId_);
}

inline void CancelUploadRequestRequest::setCorrelationId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CorrelationId();
    this->_CorrelationId.assign(value, size);
}

inline void CancelUploadRequestRequest::set_has_CorrelationId () {
    _has_bits_[0] |= 1u << 0;
}

inline void CancelUploadRequestRequest::clear_has_CorrelationId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CancelUploadRequestResponse::CancelUploadRequestResponse ()  :
    _outRequestInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CancelUploadRequestResponse::CancelUploadRequestResponse (const CancelUploadRequestResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _outRequestInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CancelUploadRequestResponse::CancelUploadRequestResponse (const RequestInfo& outRequestInfo_)  :
    _outRequestInfo (outRequestInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CancelUploadRequestResponse::~CancelUploadRequestResponse() {
}

inline CancelUploadRequestResponse& CancelUploadRequestResponse::operator = (const CancelUploadRequestResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasOutRequestInfo()) {
            setOutRequestInfo(rhs.getOutRequestInfo());
        } else {
            clearOutRequestInfo();
        }
    }
    return *this;
}

inline bool CancelUploadRequestResponse::operator == (const CancelUploadRequestResponse& rhs) const {
    return (((!hasOutRequestInfo() && !rhs.hasOutRequestInfo()) || getOutRequestInfo() == rhs.getOutRequestInfo()));
}

inline bool CancelUploadRequestResponse::operator != (const CancelUploadRequestResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool CancelUploadRequestResponse::operator < (const CancelUploadRequestResponse& rhs) const {
    if (hasOutRequestInfo() || rhs.hasOutRequestInfo()) {
        if (getOutRequestInfo() < rhs.getOutRequestInfo()) return true;
        if (getOutRequestInfo() > rhs.getOutRequestInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CancelUploadRequestResponse::clone() {
    return new CancelUploadRequestResponse(*this);
}

inline bool CancelUploadRequestResponse::operator > (const CancelUploadRequestResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CancelUploadRequestResponse::clear() {
    clearOutRequestInfo();
}

inline void CancelUploadRequestResponse::clearOutRequestInfo() {
    if (hasOutRequestInfo()) {
         clear_has_outRequestInfo();
        _outRequestInfo.clear();
     }
}

inline bool CancelUploadRequestResponse::hasOutRequestInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const RequestInfo& CancelUploadRequestResponse::getOutRequestInfo () const {
    return _outRequestInfo;
}

inline RequestInfo& CancelUploadRequestResponse::getOutRequestInfoMutable () {
    set_has_outRequestInfo();
    return _outRequestInfo;
}

inline void CancelUploadRequestResponse::setOutRequestInfo (const RequestInfo& outRequestInfo_) {
    set_has_outRequestInfo();
    this->_outRequestInfo = outRequestInfo_;
}

inline void CancelUploadRequestResponse::set_has_outRequestInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void CancelUploadRequestResponse::clear_has_outRequestInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetUploadRequestStatusRequest::GetUploadRequestStatusRequest ()  :
    _CorrelationId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetUploadRequestStatusRequest::GetUploadRequestStatusRequest (const GetUploadRequestStatusRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _CorrelationId ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetUploadRequestStatusRequest::GetUploadRequestStatusRequest (const ::std::string& CorrelationId_)  :
    _CorrelationId (CorrelationId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CorrelationId_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetUploadRequestStatusRequest::~GetUploadRequestStatusRequest() {
}

inline GetUploadRequestStatusRequest& GetUploadRequestStatusRequest::operator = (const GetUploadRequestStatusRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCorrelationId()) {
            setCorrelationId(rhs.getCorrelationId());
        } else {
            clearCorrelationId();
        }
    }
    return *this;
}

inline bool GetUploadRequestStatusRequest::operator == (const GetUploadRequestStatusRequest& rhs) const {
    return (((!hasCorrelationId() && !rhs.hasCorrelationId()) || getCorrelationId() == rhs.getCorrelationId()));
}

inline bool GetUploadRequestStatusRequest::operator != (const GetUploadRequestStatusRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool GetUploadRequestStatusRequest::operator < (const GetUploadRequestStatusRequest& rhs) const {
    if (hasCorrelationId() || rhs.hasCorrelationId()) {
        if (getCorrelationId() < rhs.getCorrelationId()) return true;
        if (getCorrelationId() > rhs.getCorrelationId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetUploadRequestStatusRequest::clone() {
    return new GetUploadRequestStatusRequest(*this);
}

inline bool GetUploadRequestStatusRequest::operator > (const GetUploadRequestStatusRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetUploadRequestStatusRequest::clear() {
    clearCorrelationId();
}

inline void GetUploadRequestStatusRequest::clearCorrelationId() {
    if (hasCorrelationId()) {
         clear_has_CorrelationId();
        _CorrelationId.clear();
     }
}

inline bool GetUploadRequestStatusRequest::hasCorrelationId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetUploadRequestStatusRequest::getCorrelationId () const {
    return _CorrelationId;
}

inline ::std::string& GetUploadRequestStatusRequest::getCorrelationIdMutable () {
    set_has_CorrelationId();
    return _CorrelationId;
}

inline void GetUploadRequestStatusRequest::setCorrelationId (const ::std::string& CorrelationId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CorrelationId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CorrelationId();
    this->_CorrelationId = CorrelationId_;
}

inline void GetUploadRequestStatusRequest::setCorrelationId (const char* CorrelationId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CorrelationId_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CorrelationId();
    this->_CorrelationId.assign(CorrelationId_);
}

inline void GetUploadRequestStatusRequest::setCorrelationId (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CorrelationId();
    this->_CorrelationId.assign(value, size);
}

inline void GetUploadRequestStatusRequest::set_has_CorrelationId () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetUploadRequestStatusRequest::clear_has_CorrelationId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetUploadRequestStatusResponse::GetUploadRequestStatusResponse ()  :
    _outRequestInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetUploadRequestStatusResponse::GetUploadRequestStatusResponse (const GetUploadRequestStatusResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _outRequestInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetUploadRequestStatusResponse::GetUploadRequestStatusResponse (const RequestInfo& outRequestInfo_)  :
    _outRequestInfo (outRequestInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetUploadRequestStatusResponse::~GetUploadRequestStatusResponse() {
}

inline GetUploadRequestStatusResponse& GetUploadRequestStatusResponse::operator = (const GetUploadRequestStatusResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasOutRequestInfo()) {
            setOutRequestInfo(rhs.getOutRequestInfo());
        } else {
            clearOutRequestInfo();
        }
    }
    return *this;
}

inline bool GetUploadRequestStatusResponse::operator == (const GetUploadRequestStatusResponse& rhs) const {
    return (((!hasOutRequestInfo() && !rhs.hasOutRequestInfo()) || getOutRequestInfo() == rhs.getOutRequestInfo()));
}

inline bool GetUploadRequestStatusResponse::operator != (const GetUploadRequestStatusResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetUploadRequestStatusResponse::operator < (const GetUploadRequestStatusResponse& rhs) const {
    if (hasOutRequestInfo() || rhs.hasOutRequestInfo()) {
        if (getOutRequestInfo() < rhs.getOutRequestInfo()) return true;
        if (getOutRequestInfo() > rhs.getOutRequestInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetUploadRequestStatusResponse::clone() {
    return new GetUploadRequestStatusResponse(*this);
}

inline bool GetUploadRequestStatusResponse::operator > (const GetUploadRequestStatusResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetUploadRequestStatusResponse::clear() {
    clearOutRequestInfo();
}

inline void GetUploadRequestStatusResponse::clearOutRequestInfo() {
    if (hasOutRequestInfo()) {
         clear_has_outRequestInfo();
        _outRequestInfo.clear();
     }
}

inline bool GetUploadRequestStatusResponse::hasOutRequestInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const RequestInfo& GetUploadRequestStatusResponse::getOutRequestInfo () const {
    return _outRequestInfo;
}

inline RequestInfo& GetUploadRequestStatusResponse::getOutRequestInfoMutable () {
    set_has_outRequestInfo();
    return _outRequestInfo;
}

inline void GetUploadRequestStatusResponse::setOutRequestInfo (const RequestInfo& outRequestInfo_) {
    set_has_outRequestInfo();
    this->_outRequestInfo = outRequestInfo_;
}

inline void GetUploadRequestStatusResponse::set_has_outRequestInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetUploadRequestStatusResponse::clear_has_outRequestInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  MqttConnectionStatusSignal::MqttConnectionStatusSignal ()  :
    _connectionStatus (::com::bosch::cm::dumm::DummService::ConnectionStatus__DISCONNECTED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MqttConnectionStatusSignal::MqttConnectionStatusSignal (const MqttConnectionStatusSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _connectionStatus (::com::bosch::cm::dumm::DummService::ConnectionStatus__DISCONNECTED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MqttConnectionStatusSignal::MqttConnectionStatusSignal (ConnectionStatus connectionStatus_)  :
    _connectionStatus (connectionStatus_)
{
    #ifndef NDEBUG
    if (!(ConnectionStatus_IsValid(connectionStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", connectionStatus_, "ConnectionStatus", "connectionStatus", "MqttConnectionStatusSignal");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MqttConnectionStatusSignal::~MqttConnectionStatusSignal() {
}

inline MqttConnectionStatusSignal& MqttConnectionStatusSignal::operator = (const MqttConnectionStatusSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasConnectionStatus()) {
            setConnectionStatus(rhs.getConnectionStatus());
        } else {
            clearConnectionStatus();
        }
    }
    return *this;
}

inline bool MqttConnectionStatusSignal::operator == (const MqttConnectionStatusSignal& rhs) const {
    return (((!hasConnectionStatus() && !rhs.hasConnectionStatus()) || getConnectionStatus() == rhs.getConnectionStatus()));
}

inline bool MqttConnectionStatusSignal::operator != (const MqttConnectionStatusSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool MqttConnectionStatusSignal::operator < (const MqttConnectionStatusSignal& rhs) const {
    if (hasConnectionStatus() || rhs.hasConnectionStatus()) {
        if ((uint32)getConnectionStatus() < (uint32)rhs.getConnectionStatus()) return true;
        if ((uint32)getConnectionStatus() > (uint32)rhs.getConnectionStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MqttConnectionStatusSignal::clone() {
    return new MqttConnectionStatusSignal(*this);
}

inline bool MqttConnectionStatusSignal::operator > (const MqttConnectionStatusSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MqttConnectionStatusSignal::clear() {
    clearConnectionStatus();
}

inline void MqttConnectionStatusSignal::clearConnectionStatus() {
    if (hasConnectionStatus()) {
         clear_has_connectionStatus();
        _connectionStatus = ::com::bosch::cm::dumm::DummService::ConnectionStatus__DISCONNECTED;
     }
}

inline bool MqttConnectionStatusSignal::hasConnectionStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ConnectionStatus MqttConnectionStatusSignal::getConnectionStatus () const {
    return _connectionStatus;
}

inline void MqttConnectionStatusSignal::setConnectionStatus (ConnectionStatus connectionStatus_) {
    #ifndef NDEBUG
    if (!(ConnectionStatus_IsValid(connectionStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", connectionStatus_, "ConnectionStatus", "connectionStatus", "MqttConnectionStatusSignal");
    }
    #endif
    set_has_connectionStatus();
    this->_connectionStatus = connectionStatus_;
}

inline void MqttConnectionStatusSignal::set_has_connectionStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void MqttConnectionStatusSignal::clear_has_connectionStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequestStateChangedSignal::RequestStateChangedSignal ()  :
    _requestInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestStateChangedSignal::RequestStateChangedSignal (const RequestStateChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _requestInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestStateChangedSignal::RequestStateChangedSignal (const RequestInfo& requestInfo_)  :
    _requestInfo (requestInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestStateChangedSignal::~RequestStateChangedSignal() {
}

inline RequestStateChangedSignal& RequestStateChangedSignal::operator = (const RequestStateChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRequestInfo()) {
            setRequestInfo(rhs.getRequestInfo());
        } else {
            clearRequestInfo();
        }
    }
    return *this;
}

inline bool RequestStateChangedSignal::operator == (const RequestStateChangedSignal& rhs) const {
    return (((!hasRequestInfo() && !rhs.hasRequestInfo()) || getRequestInfo() == rhs.getRequestInfo()));
}

inline bool RequestStateChangedSignal::operator != (const RequestStateChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestStateChangedSignal::operator < (const RequestStateChangedSignal& rhs) const {
    if (hasRequestInfo() || rhs.hasRequestInfo()) {
        if (getRequestInfo() < rhs.getRequestInfo()) return true;
        if (getRequestInfo() > rhs.getRequestInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestStateChangedSignal::clone() {
    return new RequestStateChangedSignal(*this);
}

inline bool RequestStateChangedSignal::operator > (const RequestStateChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestStateChangedSignal::clear() {
    clearRequestInfo();
}

inline void RequestStateChangedSignal::clearRequestInfo() {
    if (hasRequestInfo()) {
         clear_has_requestInfo();
        _requestInfo.clear();
     }
}

inline bool RequestStateChangedSignal::hasRequestInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const RequestInfo& RequestStateChangedSignal::getRequestInfo () const {
    return _requestInfo;
}

inline RequestInfo& RequestStateChangedSignal::getRequestInfoMutable () {
    set_has_requestInfo();
    return _requestInfo;
}

inline void RequestStateChangedSignal::setRequestInfo (const RequestInfo& requestInfo_) {
    set_has_requestInfo();
    this->_requestInfo = requestInfo_;
}

inline void RequestStateChangedSignal::set_has_requestInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestStateChangedSignal::clear_has_requestInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ServiceActivationAcknowledgedSignal::ServiceActivationAcknowledgedSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ServiceActivationAcknowledgedSignal::ServiceActivationAcknowledgedSignal (const ServiceActivationAcknowledgedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ServiceActivationAcknowledgedSignal::ServiceActivationAcknowledgedSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ServiceActivationAcknowledgedSignal::~ServiceActivationAcknowledgedSignal() {
}

inline ServiceActivationAcknowledgedSignal& ServiceActivationAcknowledgedSignal::operator = (const ServiceActivationAcknowledgedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool ServiceActivationAcknowledgedSignal::operator == (const ServiceActivationAcknowledgedSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool ServiceActivationAcknowledgedSignal::operator != (const ServiceActivationAcknowledgedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ServiceActivationAcknowledgedSignal::operator < (const ServiceActivationAcknowledgedSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ServiceActivationAcknowledgedSignal::clone() {
    return new ServiceActivationAcknowledgedSignal(*this);
}

inline bool ServiceActivationAcknowledgedSignal::operator > (const ServiceActivationAcknowledgedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ServiceActivationAcknowledgedSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void ServiceActivationAcknowledgedSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool ServiceActivationAcknowledgedSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ServiceActivationAcknowledgedSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& ServiceActivationAcknowledgedSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void ServiceActivationAcknowledgedSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void ServiceActivationAcknowledgedSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void ServiceActivationAcknowledgedSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void ServiceActivationAcknowledgedSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool ServiceActivationAcknowledgedSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& ServiceActivationAcknowledgedSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& ServiceActivationAcknowledgedSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void ServiceActivationAcknowledgedSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void ServiceActivationAcknowledgedSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void ServiceActivationAcknowledgedSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void ServiceActivationAcknowledgedSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void ServiceActivationAcknowledgedSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ServiceActivationAcknowledgedSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void ServiceActivationAcknowledgedSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RemoteDataWipeReceivedSignal::RemoteDataWipeReceivedSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoteDataWipeReceivedSignal::RemoteDataWipeReceivedSignal (const RemoteDataWipeReceivedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoteDataWipeReceivedSignal::RemoteDataWipeReceivedSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoteDataWipeReceivedSignal::~RemoteDataWipeReceivedSignal() {
}

inline RemoteDataWipeReceivedSignal& RemoteDataWipeReceivedSignal::operator = (const RemoteDataWipeReceivedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool RemoteDataWipeReceivedSignal::operator == (const RemoteDataWipeReceivedSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool RemoteDataWipeReceivedSignal::operator != (const RemoteDataWipeReceivedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoteDataWipeReceivedSignal::operator < (const RemoteDataWipeReceivedSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoteDataWipeReceivedSignal::clone() {
    return new RemoteDataWipeReceivedSignal(*this);
}

inline bool RemoteDataWipeReceivedSignal::operator > (const RemoteDataWipeReceivedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoteDataWipeReceivedSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void RemoteDataWipeReceivedSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool RemoteDataWipeReceivedSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RemoteDataWipeReceivedSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& RemoteDataWipeReceivedSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void RemoteDataWipeReceivedSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void RemoteDataWipeReceivedSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void RemoteDataWipeReceivedSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void RemoteDataWipeReceivedSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool RemoteDataWipeReceivedSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& RemoteDataWipeReceivedSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& RemoteDataWipeReceivedSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void RemoteDataWipeReceivedSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void RemoteDataWipeReceivedSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void RemoteDataWipeReceivedSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void RemoteDataWipeReceivedSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoteDataWipeReceivedSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RemoteDataWipeReceivedSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void RemoteDataWipeReceivedSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  PushMessageReceivedSignal::PushMessageReceivedSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PushMessageReceivedSignal::PushMessageReceivedSignal (const PushMessageReceivedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PushMessageReceivedSignal::PushMessageReceivedSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PushMessageReceivedSignal::~PushMessageReceivedSignal() {
}

inline PushMessageReceivedSignal& PushMessageReceivedSignal::operator = (const PushMessageReceivedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool PushMessageReceivedSignal::operator == (const PushMessageReceivedSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool PushMessageReceivedSignal::operator != (const PushMessageReceivedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool PushMessageReceivedSignal::operator < (const PushMessageReceivedSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PushMessageReceivedSignal::clone() {
    return new PushMessageReceivedSignal(*this);
}

inline bool PushMessageReceivedSignal::operator > (const PushMessageReceivedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PushMessageReceivedSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void PushMessageReceivedSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool PushMessageReceivedSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PushMessageReceivedSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& PushMessageReceivedSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void PushMessageReceivedSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void PushMessageReceivedSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void PushMessageReceivedSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void PushMessageReceivedSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool PushMessageReceivedSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& PushMessageReceivedSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& PushMessageReceivedSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void PushMessageReceivedSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void PushMessageReceivedSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void PushMessageReceivedSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void PushMessageReceivedSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void PushMessageReceivedSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PushMessageReceivedSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void PushMessageReceivedSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  PushMessageDeleteSignal::PushMessageDeleteSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PushMessageDeleteSignal::PushMessageDeleteSignal (const PushMessageDeleteSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PushMessageDeleteSignal::PushMessageDeleteSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PushMessageDeleteSignal::~PushMessageDeleteSignal() {
}

inline PushMessageDeleteSignal& PushMessageDeleteSignal::operator = (const PushMessageDeleteSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool PushMessageDeleteSignal::operator == (const PushMessageDeleteSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool PushMessageDeleteSignal::operator != (const PushMessageDeleteSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool PushMessageDeleteSignal::operator < (const PushMessageDeleteSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PushMessageDeleteSignal::clone() {
    return new PushMessageDeleteSignal(*this);
}

inline bool PushMessageDeleteSignal::operator > (const PushMessageDeleteSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PushMessageDeleteSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void PushMessageDeleteSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool PushMessageDeleteSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PushMessageDeleteSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& PushMessageDeleteSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void PushMessageDeleteSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void PushMessageDeleteSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void PushMessageDeleteSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void PushMessageDeleteSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool PushMessageDeleteSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& PushMessageDeleteSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& PushMessageDeleteSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void PushMessageDeleteSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void PushMessageDeleteSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void PushMessageDeleteSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void PushMessageDeleteSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void PushMessageDeleteSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PushMessageDeleteSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void PushMessageDeleteSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  PushMessageUpdateSignal::PushMessageUpdateSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PushMessageUpdateSignal::PushMessageUpdateSignal (const PushMessageUpdateSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PushMessageUpdateSignal::PushMessageUpdateSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PushMessageUpdateSignal::~PushMessageUpdateSignal() {
}

inline PushMessageUpdateSignal& PushMessageUpdateSignal::operator = (const PushMessageUpdateSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool PushMessageUpdateSignal::operator == (const PushMessageUpdateSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool PushMessageUpdateSignal::operator != (const PushMessageUpdateSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool PushMessageUpdateSignal::operator < (const PushMessageUpdateSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PushMessageUpdateSignal::clone() {
    return new PushMessageUpdateSignal(*this);
}

inline bool PushMessageUpdateSignal::operator > (const PushMessageUpdateSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PushMessageUpdateSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void PushMessageUpdateSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool PushMessageUpdateSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PushMessageUpdateSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& PushMessageUpdateSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void PushMessageUpdateSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void PushMessageUpdateSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void PushMessageUpdateSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void PushMessageUpdateSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool PushMessageUpdateSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& PushMessageUpdateSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& PushMessageUpdateSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void PushMessageUpdateSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void PushMessageUpdateSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void PushMessageUpdateSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void PushMessageUpdateSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void PushMessageUpdateSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PushMessageUpdateSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void PushMessageUpdateSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  XCALL_POI_ReceivedSignal::XCALL_POI_ReceivedSignal ()  :
    _jsonDownloadHeader (),
    _xCallType (::com::bosch::cm::dumm::DummService::XCallType__Unknown),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  XCALL_POI_ReceivedSignal::XCALL_POI_ReceivedSignal (const XCALL_POI_ReceivedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _xCallType (::com::bosch::cm::dumm::DummService::XCallType__Unknown),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  XCALL_POI_ReceivedSignal::XCALL_POI_ReceivedSignal (const ::std::string& jsonDownloadHeader_, XCallType xCallType_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _xCallType (xCallType_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(XCallType_IsValid(xCallType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", xCallType_, "XCallType", "xCallType", "XCALL_POI_ReceivedSignal");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  XCALL_POI_ReceivedSignal::~XCALL_POI_ReceivedSignal() {
}

inline XCALL_POI_ReceivedSignal& XCALL_POI_ReceivedSignal::operator = (const XCALL_POI_ReceivedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasXCallType()) {
            setXCallType(rhs.getXCallType());
        } else {
            clearXCallType();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool XCALL_POI_ReceivedSignal::operator == (const XCALL_POI_ReceivedSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasXCallType() && !rhs.hasXCallType()) || getXCallType() == rhs.getXCallType()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool XCALL_POI_ReceivedSignal::operator != (const XCALL_POI_ReceivedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool XCALL_POI_ReceivedSignal::operator < (const XCALL_POI_ReceivedSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasXCallType() || rhs.hasXCallType()) {
        if ((uint32)getXCallType() < (uint32)rhs.getXCallType()) return true;
        if ((uint32)getXCallType() > (uint32)rhs.getXCallType()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* XCALL_POI_ReceivedSignal::clone() {
    return new XCALL_POI_ReceivedSignal(*this);
}

inline bool XCALL_POI_ReceivedSignal::operator > (const XCALL_POI_ReceivedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void XCALL_POI_ReceivedSignal::clear() {
    clearJsonDownloadHeader();
    clearXCallType();
    clearJsonDownloadData();
}

inline void XCALL_POI_ReceivedSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool XCALL_POI_ReceivedSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& XCALL_POI_ReceivedSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& XCALL_POI_ReceivedSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void XCALL_POI_ReceivedSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void XCALL_POI_ReceivedSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void XCALL_POI_ReceivedSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void XCALL_POI_ReceivedSignal::clearXCallType() {
    if (hasXCallType()) {
         clear_has_xCallType();
        _xCallType = ::com::bosch::cm::dumm::DummService::XCallType__Unknown;
     }
}

inline bool XCALL_POI_ReceivedSignal::hasXCallType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline XCallType XCALL_POI_ReceivedSignal::getXCallType () const {
    return _xCallType;
}

inline void XCALL_POI_ReceivedSignal::setXCallType (XCallType xCallType_) {
    #ifndef NDEBUG
    if (!(XCallType_IsValid(xCallType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", xCallType_, "XCallType", "xCallType", "XCALL_POI_ReceivedSignal");
    }
    #endif
    set_has_xCallType();
    this->_xCallType = xCallType_;
}

inline void XCALL_POI_ReceivedSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool XCALL_POI_ReceivedSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& XCALL_POI_ReceivedSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& XCALL_POI_ReceivedSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void XCALL_POI_ReceivedSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void XCALL_POI_ReceivedSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void XCALL_POI_ReceivedSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void XCALL_POI_ReceivedSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void XCALL_POI_ReceivedSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void XCALL_POI_ReceivedSignal::set_has_xCallType () {
    _has_bits_[0] |= 1u << 1;
}

inline void XCALL_POI_ReceivedSignal::clear_has_xCallType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void XCALL_POI_ReceivedSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 2;
}

inline void XCALL_POI_ReceivedSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  RemoteDataWipeSignal::RemoteDataWipeSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoteDataWipeSignal::RemoteDataWipeSignal (const RemoteDataWipeSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoteDataWipeSignal::RemoteDataWipeSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoteDataWipeSignal::~RemoteDataWipeSignal() {
}

inline RemoteDataWipeSignal& RemoteDataWipeSignal::operator = (const RemoteDataWipeSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool RemoteDataWipeSignal::operator == (const RemoteDataWipeSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool RemoteDataWipeSignal::operator != (const RemoteDataWipeSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoteDataWipeSignal::operator < (const RemoteDataWipeSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoteDataWipeSignal::clone() {
    return new RemoteDataWipeSignal(*this);
}

inline bool RemoteDataWipeSignal::operator > (const RemoteDataWipeSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoteDataWipeSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void RemoteDataWipeSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool RemoteDataWipeSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RemoteDataWipeSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& RemoteDataWipeSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void RemoteDataWipeSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void RemoteDataWipeSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void RemoteDataWipeSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void RemoteDataWipeSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool RemoteDataWipeSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& RemoteDataWipeSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& RemoteDataWipeSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void RemoteDataWipeSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void RemoteDataWipeSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void RemoteDataWipeSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void RemoteDataWipeSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoteDataWipeSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RemoteDataWipeSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void RemoteDataWipeSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ProfileSyncResponseSignal::ProfileSyncResponseSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProfileSyncResponseSignal::ProfileSyncResponseSignal (const ProfileSyncResponseSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProfileSyncResponseSignal::ProfileSyncResponseSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ProfileSyncResponseSignal::~ProfileSyncResponseSignal() {
}

inline ProfileSyncResponseSignal& ProfileSyncResponseSignal::operator = (const ProfileSyncResponseSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool ProfileSyncResponseSignal::operator == (const ProfileSyncResponseSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool ProfileSyncResponseSignal::operator != (const ProfileSyncResponseSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ProfileSyncResponseSignal::operator < (const ProfileSyncResponseSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ProfileSyncResponseSignal::clone() {
    return new ProfileSyncResponseSignal(*this);
}

inline bool ProfileSyncResponseSignal::operator > (const ProfileSyncResponseSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProfileSyncResponseSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void ProfileSyncResponseSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool ProfileSyncResponseSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ProfileSyncResponseSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& ProfileSyncResponseSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void ProfileSyncResponseSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void ProfileSyncResponseSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void ProfileSyncResponseSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void ProfileSyncResponseSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool ProfileSyncResponseSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& ProfileSyncResponseSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& ProfileSyncResponseSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void ProfileSyncResponseSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void ProfileSyncResponseSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void ProfileSyncResponseSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void ProfileSyncResponseSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void ProfileSyncResponseSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ProfileSyncResponseSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void ProfileSyncResponseSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ProfileSyncNeededSignal::ProfileSyncNeededSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProfileSyncNeededSignal::ProfileSyncNeededSignal (const ProfileSyncNeededSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProfileSyncNeededSignal::ProfileSyncNeededSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ProfileSyncNeededSignal::~ProfileSyncNeededSignal() {
}

inline ProfileSyncNeededSignal& ProfileSyncNeededSignal::operator = (const ProfileSyncNeededSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool ProfileSyncNeededSignal::operator == (const ProfileSyncNeededSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool ProfileSyncNeededSignal::operator != (const ProfileSyncNeededSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ProfileSyncNeededSignal::operator < (const ProfileSyncNeededSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ProfileSyncNeededSignal::clone() {
    return new ProfileSyncNeededSignal(*this);
}

inline bool ProfileSyncNeededSignal::operator > (const ProfileSyncNeededSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProfileSyncNeededSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void ProfileSyncNeededSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool ProfileSyncNeededSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ProfileSyncNeededSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& ProfileSyncNeededSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void ProfileSyncNeededSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void ProfileSyncNeededSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void ProfileSyncNeededSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void ProfileSyncNeededSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool ProfileSyncNeededSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& ProfileSyncNeededSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& ProfileSyncNeededSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void ProfileSyncNeededSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void ProfileSyncNeededSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void ProfileSyncNeededSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void ProfileSyncNeededSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void ProfileSyncNeededSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ProfileSyncNeededSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void ProfileSyncNeededSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ProfileRemoteLinkResponseSignal::ProfileRemoteLinkResponseSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProfileRemoteLinkResponseSignal::ProfileRemoteLinkResponseSignal (const ProfileRemoteLinkResponseSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProfileRemoteLinkResponseSignal::ProfileRemoteLinkResponseSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ProfileRemoteLinkResponseSignal::~ProfileRemoteLinkResponseSignal() {
}

inline ProfileRemoteLinkResponseSignal& ProfileRemoteLinkResponseSignal::operator = (const ProfileRemoteLinkResponseSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool ProfileRemoteLinkResponseSignal::operator == (const ProfileRemoteLinkResponseSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool ProfileRemoteLinkResponseSignal::operator != (const ProfileRemoteLinkResponseSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ProfileRemoteLinkResponseSignal::operator < (const ProfileRemoteLinkResponseSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ProfileRemoteLinkResponseSignal::clone() {
    return new ProfileRemoteLinkResponseSignal(*this);
}

inline bool ProfileRemoteLinkResponseSignal::operator > (const ProfileRemoteLinkResponseSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProfileRemoteLinkResponseSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void ProfileRemoteLinkResponseSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool ProfileRemoteLinkResponseSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ProfileRemoteLinkResponseSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& ProfileRemoteLinkResponseSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void ProfileRemoteLinkResponseSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void ProfileRemoteLinkResponseSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void ProfileRemoteLinkResponseSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void ProfileRemoteLinkResponseSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool ProfileRemoteLinkResponseSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& ProfileRemoteLinkResponseSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& ProfileRemoteLinkResponseSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void ProfileRemoteLinkResponseSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void ProfileRemoteLinkResponseSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void ProfileRemoteLinkResponseSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void ProfileRemoteLinkResponseSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void ProfileRemoteLinkResponseSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ProfileRemoteLinkResponseSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void ProfileRemoteLinkResponseSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ProfileRemoteResetSignal::ProfileRemoteResetSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProfileRemoteResetSignal::ProfileRemoteResetSignal (const ProfileRemoteResetSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProfileRemoteResetSignal::ProfileRemoteResetSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ProfileRemoteResetSignal::~ProfileRemoteResetSignal() {
}

inline ProfileRemoteResetSignal& ProfileRemoteResetSignal::operator = (const ProfileRemoteResetSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool ProfileRemoteResetSignal::operator == (const ProfileRemoteResetSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool ProfileRemoteResetSignal::operator != (const ProfileRemoteResetSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ProfileRemoteResetSignal::operator < (const ProfileRemoteResetSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ProfileRemoteResetSignal::clone() {
    return new ProfileRemoteResetSignal(*this);
}

inline bool ProfileRemoteResetSignal::operator > (const ProfileRemoteResetSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProfileRemoteResetSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void ProfileRemoteResetSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool ProfileRemoteResetSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ProfileRemoteResetSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& ProfileRemoteResetSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void ProfileRemoteResetSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void ProfileRemoteResetSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void ProfileRemoteResetSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void ProfileRemoteResetSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool ProfileRemoteResetSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& ProfileRemoteResetSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& ProfileRemoteResetSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void ProfileRemoteResetSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void ProfileRemoteResetSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void ProfileRemoteResetSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void ProfileRemoteResetSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void ProfileRemoteResetSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ProfileRemoteResetSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void ProfileRemoteResetSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ProfileLocalLinkAckSignal::ProfileLocalLinkAckSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProfileLocalLinkAckSignal::ProfileLocalLinkAckSignal (const ProfileLocalLinkAckSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProfileLocalLinkAckSignal::ProfileLocalLinkAckSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ProfileLocalLinkAckSignal::~ProfileLocalLinkAckSignal() {
}

inline ProfileLocalLinkAckSignal& ProfileLocalLinkAckSignal::operator = (const ProfileLocalLinkAckSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool ProfileLocalLinkAckSignal::operator == (const ProfileLocalLinkAckSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool ProfileLocalLinkAckSignal::operator != (const ProfileLocalLinkAckSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ProfileLocalLinkAckSignal::operator < (const ProfileLocalLinkAckSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ProfileLocalLinkAckSignal::clone() {
    return new ProfileLocalLinkAckSignal(*this);
}

inline bool ProfileLocalLinkAckSignal::operator > (const ProfileLocalLinkAckSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProfileLocalLinkAckSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void ProfileLocalLinkAckSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool ProfileLocalLinkAckSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ProfileLocalLinkAckSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& ProfileLocalLinkAckSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void ProfileLocalLinkAckSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void ProfileLocalLinkAckSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void ProfileLocalLinkAckSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void ProfileLocalLinkAckSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool ProfileLocalLinkAckSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& ProfileLocalLinkAckSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& ProfileLocalLinkAckSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void ProfileLocalLinkAckSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void ProfileLocalLinkAckSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void ProfileLocalLinkAckSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void ProfileLocalLinkAckSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void ProfileLocalLinkAckSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ProfileLocalLinkAckSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void ProfileLocalLinkAckSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ProfileLocalUnLinkAckSignal::ProfileLocalUnLinkAckSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProfileLocalUnLinkAckSignal::ProfileLocalUnLinkAckSignal (const ProfileLocalUnLinkAckSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProfileLocalUnLinkAckSignal::ProfileLocalUnLinkAckSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ProfileLocalUnLinkAckSignal::~ProfileLocalUnLinkAckSignal() {
}

inline ProfileLocalUnLinkAckSignal& ProfileLocalUnLinkAckSignal::operator = (const ProfileLocalUnLinkAckSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool ProfileLocalUnLinkAckSignal::operator == (const ProfileLocalUnLinkAckSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool ProfileLocalUnLinkAckSignal::operator != (const ProfileLocalUnLinkAckSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ProfileLocalUnLinkAckSignal::operator < (const ProfileLocalUnLinkAckSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ProfileLocalUnLinkAckSignal::clone() {
    return new ProfileLocalUnLinkAckSignal(*this);
}

inline bool ProfileLocalUnLinkAckSignal::operator > (const ProfileLocalUnLinkAckSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProfileLocalUnLinkAckSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void ProfileLocalUnLinkAckSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool ProfileLocalUnLinkAckSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ProfileLocalUnLinkAckSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& ProfileLocalUnLinkAckSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void ProfileLocalUnLinkAckSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void ProfileLocalUnLinkAckSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void ProfileLocalUnLinkAckSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void ProfileLocalUnLinkAckSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool ProfileLocalUnLinkAckSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& ProfileLocalUnLinkAckSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& ProfileLocalUnLinkAckSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void ProfileLocalUnLinkAckSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void ProfileLocalUnLinkAckSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void ProfileLocalUnLinkAckSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void ProfileLocalUnLinkAckSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void ProfileLocalUnLinkAckSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ProfileLocalUnLinkAckSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void ProfileLocalUnLinkAckSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  EVPresoakAVNextSynchroRespSignal::EVPresoakAVNextSynchroRespSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EVPresoakAVNextSynchroRespSignal::EVPresoakAVNextSynchroRespSignal (const EVPresoakAVNextSynchroRespSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EVPresoakAVNextSynchroRespSignal::EVPresoakAVNextSynchroRespSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EVPresoakAVNextSynchroRespSignal::~EVPresoakAVNextSynchroRespSignal() {
}

inline EVPresoakAVNextSynchroRespSignal& EVPresoakAVNextSynchroRespSignal::operator = (const EVPresoakAVNextSynchroRespSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool EVPresoakAVNextSynchroRespSignal::operator == (const EVPresoakAVNextSynchroRespSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool EVPresoakAVNextSynchroRespSignal::operator != (const EVPresoakAVNextSynchroRespSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool EVPresoakAVNextSynchroRespSignal::operator < (const EVPresoakAVNextSynchroRespSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EVPresoakAVNextSynchroRespSignal::clone() {
    return new EVPresoakAVNextSynchroRespSignal(*this);
}

inline bool EVPresoakAVNextSynchroRespSignal::operator > (const EVPresoakAVNextSynchroRespSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EVPresoakAVNextSynchroRespSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void EVPresoakAVNextSynchroRespSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool EVPresoakAVNextSynchroRespSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& EVPresoakAVNextSynchroRespSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& EVPresoakAVNextSynchroRespSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void EVPresoakAVNextSynchroRespSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void EVPresoakAVNextSynchroRespSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void EVPresoakAVNextSynchroRespSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void EVPresoakAVNextSynchroRespSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool EVPresoakAVNextSynchroRespSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& EVPresoakAVNextSynchroRespSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& EVPresoakAVNextSynchroRespSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void EVPresoakAVNextSynchroRespSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void EVPresoakAVNextSynchroRespSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void EVPresoakAVNextSynchroRespSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void EVPresoakAVNextSynchroRespSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void EVPresoakAVNextSynchroRespSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EVPresoakAVNextSynchroRespSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void EVPresoakAVNextSynchroRespSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  EVPresoakAVNextSynchroNeededSignal::EVPresoakAVNextSynchroNeededSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EVPresoakAVNextSynchroNeededSignal::EVPresoakAVNextSynchroNeededSignal (const EVPresoakAVNextSynchroNeededSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EVPresoakAVNextSynchroNeededSignal::EVPresoakAVNextSynchroNeededSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EVPresoakAVNextSynchroNeededSignal::~EVPresoakAVNextSynchroNeededSignal() {
}

inline EVPresoakAVNextSynchroNeededSignal& EVPresoakAVNextSynchroNeededSignal::operator = (const EVPresoakAVNextSynchroNeededSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool EVPresoakAVNextSynchroNeededSignal::operator == (const EVPresoakAVNextSynchroNeededSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool EVPresoakAVNextSynchroNeededSignal::operator != (const EVPresoakAVNextSynchroNeededSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool EVPresoakAVNextSynchroNeededSignal::operator < (const EVPresoakAVNextSynchroNeededSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EVPresoakAVNextSynchroNeededSignal::clone() {
    return new EVPresoakAVNextSynchroNeededSignal(*this);
}

inline bool EVPresoakAVNextSynchroNeededSignal::operator > (const EVPresoakAVNextSynchroNeededSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EVPresoakAVNextSynchroNeededSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void EVPresoakAVNextSynchroNeededSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool EVPresoakAVNextSynchroNeededSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& EVPresoakAVNextSynchroNeededSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& EVPresoakAVNextSynchroNeededSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void EVPresoakAVNextSynchroNeededSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void EVPresoakAVNextSynchroNeededSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void EVPresoakAVNextSynchroNeededSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void EVPresoakAVNextSynchroNeededSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool EVPresoakAVNextSynchroNeededSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& EVPresoakAVNextSynchroNeededSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& EVPresoakAVNextSynchroNeededSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void EVPresoakAVNextSynchroNeededSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void EVPresoakAVNextSynchroNeededSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void EVPresoakAVNextSynchroNeededSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void EVPresoakAVNextSynchroNeededSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void EVPresoakAVNextSynchroNeededSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EVPresoakAVNextSynchroNeededSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void EVPresoakAVNextSynchroNeededSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  EVChargeAVNextSynchroRespSignal::EVChargeAVNextSynchroRespSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EVChargeAVNextSynchroRespSignal::EVChargeAVNextSynchroRespSignal (const EVChargeAVNextSynchroRespSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EVChargeAVNextSynchroRespSignal::EVChargeAVNextSynchroRespSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EVChargeAVNextSynchroRespSignal::~EVChargeAVNextSynchroRespSignal() {
}

inline EVChargeAVNextSynchroRespSignal& EVChargeAVNextSynchroRespSignal::operator = (const EVChargeAVNextSynchroRespSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool EVChargeAVNextSynchroRespSignal::operator == (const EVChargeAVNextSynchroRespSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool EVChargeAVNextSynchroRespSignal::operator != (const EVChargeAVNextSynchroRespSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool EVChargeAVNextSynchroRespSignal::operator < (const EVChargeAVNextSynchroRespSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EVChargeAVNextSynchroRespSignal::clone() {
    return new EVChargeAVNextSynchroRespSignal(*this);
}

inline bool EVChargeAVNextSynchroRespSignal::operator > (const EVChargeAVNextSynchroRespSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EVChargeAVNextSynchroRespSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void EVChargeAVNextSynchroRespSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool EVChargeAVNextSynchroRespSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& EVChargeAVNextSynchroRespSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& EVChargeAVNextSynchroRespSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void EVChargeAVNextSynchroRespSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void EVChargeAVNextSynchroRespSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void EVChargeAVNextSynchroRespSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void EVChargeAVNextSynchroRespSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool EVChargeAVNextSynchroRespSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& EVChargeAVNextSynchroRespSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& EVChargeAVNextSynchroRespSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void EVChargeAVNextSynchroRespSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void EVChargeAVNextSynchroRespSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void EVChargeAVNextSynchroRespSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void EVChargeAVNextSynchroRespSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void EVChargeAVNextSynchroRespSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EVChargeAVNextSynchroRespSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void EVChargeAVNextSynchroRespSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  EVChargeAVNextSynchroNeededSignal::EVChargeAVNextSynchroNeededSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EVChargeAVNextSynchroNeededSignal::EVChargeAVNextSynchroNeededSignal (const EVChargeAVNextSynchroNeededSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EVChargeAVNextSynchroNeededSignal::EVChargeAVNextSynchroNeededSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EVChargeAVNextSynchroNeededSignal::~EVChargeAVNextSynchroNeededSignal() {
}

inline EVChargeAVNextSynchroNeededSignal& EVChargeAVNextSynchroNeededSignal::operator = (const EVChargeAVNextSynchroNeededSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool EVChargeAVNextSynchroNeededSignal::operator == (const EVChargeAVNextSynchroNeededSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool EVChargeAVNextSynchroNeededSignal::operator != (const EVChargeAVNextSynchroNeededSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool EVChargeAVNextSynchroNeededSignal::operator < (const EVChargeAVNextSynchroNeededSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EVChargeAVNextSynchroNeededSignal::clone() {
    return new EVChargeAVNextSynchroNeededSignal(*this);
}

inline bool EVChargeAVNextSynchroNeededSignal::operator > (const EVChargeAVNextSynchroNeededSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EVChargeAVNextSynchroNeededSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void EVChargeAVNextSynchroNeededSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool EVChargeAVNextSynchroNeededSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& EVChargeAVNextSynchroNeededSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& EVChargeAVNextSynchroNeededSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void EVChargeAVNextSynchroNeededSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void EVChargeAVNextSynchroNeededSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void EVChargeAVNextSynchroNeededSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void EVChargeAVNextSynchroNeededSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool EVChargeAVNextSynchroNeededSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& EVChargeAVNextSynchroNeededSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& EVChargeAVNextSynchroNeededSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void EVChargeAVNextSynchroNeededSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void EVChargeAVNextSynchroNeededSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void EVChargeAVNextSynchroNeededSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void EVChargeAVNextSynchroNeededSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void EVChargeAVNextSynchroNeededSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void EVChargeAVNextSynchroNeededSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void EVChargeAVNextSynchroNeededSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RemotePushE2E_POIAckSignal::RemotePushE2E_POIAckSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemotePushE2E_POIAckSignal::RemotePushE2E_POIAckSignal (const RemotePushE2E_POIAckSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemotePushE2E_POIAckSignal::RemotePushE2E_POIAckSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemotePushE2E_POIAckSignal::~RemotePushE2E_POIAckSignal() {
}

inline RemotePushE2E_POIAckSignal& RemotePushE2E_POIAckSignal::operator = (const RemotePushE2E_POIAckSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool RemotePushE2E_POIAckSignal::operator == (const RemotePushE2E_POIAckSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool RemotePushE2E_POIAckSignal::operator != (const RemotePushE2E_POIAckSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool RemotePushE2E_POIAckSignal::operator < (const RemotePushE2E_POIAckSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemotePushE2E_POIAckSignal::clone() {
    return new RemotePushE2E_POIAckSignal(*this);
}

inline bool RemotePushE2E_POIAckSignal::operator > (const RemotePushE2E_POIAckSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemotePushE2E_POIAckSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void RemotePushE2E_POIAckSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool RemotePushE2E_POIAckSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RemotePushE2E_POIAckSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& RemotePushE2E_POIAckSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void RemotePushE2E_POIAckSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void RemotePushE2E_POIAckSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void RemotePushE2E_POIAckSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void RemotePushE2E_POIAckSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool RemotePushE2E_POIAckSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& RemotePushE2E_POIAckSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& RemotePushE2E_POIAckSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void RemotePushE2E_POIAckSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void RemotePushE2E_POIAckSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void RemotePushE2E_POIAckSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void RemotePushE2E_POIAckSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemotePushE2E_POIAckSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RemotePushE2E_POIAckSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void RemotePushE2E_POIAckSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RemotePushE2E_DestinationSignal::RemotePushE2E_DestinationSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemotePushE2E_DestinationSignal::RemotePushE2E_DestinationSignal (const RemotePushE2E_DestinationSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemotePushE2E_DestinationSignal::RemotePushE2E_DestinationSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemotePushE2E_DestinationSignal::~RemotePushE2E_DestinationSignal() {
}

inline RemotePushE2E_DestinationSignal& RemotePushE2E_DestinationSignal::operator = (const RemotePushE2E_DestinationSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool RemotePushE2E_DestinationSignal::operator == (const RemotePushE2E_DestinationSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool RemotePushE2E_DestinationSignal::operator != (const RemotePushE2E_DestinationSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool RemotePushE2E_DestinationSignal::operator < (const RemotePushE2E_DestinationSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemotePushE2E_DestinationSignal::clone() {
    return new RemotePushE2E_DestinationSignal(*this);
}

inline bool RemotePushE2E_DestinationSignal::operator > (const RemotePushE2E_DestinationSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemotePushE2E_DestinationSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void RemotePushE2E_DestinationSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool RemotePushE2E_DestinationSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RemotePushE2E_DestinationSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& RemotePushE2E_DestinationSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void RemotePushE2E_DestinationSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void RemotePushE2E_DestinationSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void RemotePushE2E_DestinationSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void RemotePushE2E_DestinationSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool RemotePushE2E_DestinationSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& RemotePushE2E_DestinationSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& RemotePushE2E_DestinationSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void RemotePushE2E_DestinationSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void RemotePushE2E_DestinationSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void RemotePushE2E_DestinationSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void RemotePushE2E_DestinationSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemotePushE2E_DestinationSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RemotePushE2E_DestinationSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void RemotePushE2E_DestinationSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ManagedApps_RemoteOrderSignal::ManagedApps_RemoteOrderSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ManagedApps_RemoteOrderSignal::ManagedApps_RemoteOrderSignal (const ManagedApps_RemoteOrderSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ManagedApps_RemoteOrderSignal::ManagedApps_RemoteOrderSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ManagedApps_RemoteOrderSignal::~ManagedApps_RemoteOrderSignal() {
}

inline ManagedApps_RemoteOrderSignal& ManagedApps_RemoteOrderSignal::operator = (const ManagedApps_RemoteOrderSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool ManagedApps_RemoteOrderSignal::operator == (const ManagedApps_RemoteOrderSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool ManagedApps_RemoteOrderSignal::operator != (const ManagedApps_RemoteOrderSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ManagedApps_RemoteOrderSignal::operator < (const ManagedApps_RemoteOrderSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ManagedApps_RemoteOrderSignal::clone() {
    return new ManagedApps_RemoteOrderSignal(*this);
}

inline bool ManagedApps_RemoteOrderSignal::operator > (const ManagedApps_RemoteOrderSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ManagedApps_RemoteOrderSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void ManagedApps_RemoteOrderSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool ManagedApps_RemoteOrderSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ManagedApps_RemoteOrderSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& ManagedApps_RemoteOrderSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void ManagedApps_RemoteOrderSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void ManagedApps_RemoteOrderSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void ManagedApps_RemoteOrderSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void ManagedApps_RemoteOrderSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool ManagedApps_RemoteOrderSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& ManagedApps_RemoteOrderSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& ManagedApps_RemoteOrderSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void ManagedApps_RemoteOrderSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void ManagedApps_RemoteOrderSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void ManagedApps_RemoteOrderSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void ManagedApps_RemoteOrderSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void ManagedApps_RemoteOrderSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ManagedApps_RemoteOrderSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void ManagedApps_RemoteOrderSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ManagedApps_RemoteRequestSignal::ManagedApps_RemoteRequestSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ManagedApps_RemoteRequestSignal::ManagedApps_RemoteRequestSignal (const ManagedApps_RemoteRequestSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ManagedApps_RemoteRequestSignal::ManagedApps_RemoteRequestSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ManagedApps_RemoteRequestSignal::~ManagedApps_RemoteRequestSignal() {
}

inline ManagedApps_RemoteRequestSignal& ManagedApps_RemoteRequestSignal::operator = (const ManagedApps_RemoteRequestSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool ManagedApps_RemoteRequestSignal::operator == (const ManagedApps_RemoteRequestSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool ManagedApps_RemoteRequestSignal::operator != (const ManagedApps_RemoteRequestSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ManagedApps_RemoteRequestSignal::operator < (const ManagedApps_RemoteRequestSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ManagedApps_RemoteRequestSignal::clone() {
    return new ManagedApps_RemoteRequestSignal(*this);
}

inline bool ManagedApps_RemoteRequestSignal::operator > (const ManagedApps_RemoteRequestSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ManagedApps_RemoteRequestSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void ManagedApps_RemoteRequestSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool ManagedApps_RemoteRequestSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ManagedApps_RemoteRequestSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& ManagedApps_RemoteRequestSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void ManagedApps_RemoteRequestSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void ManagedApps_RemoteRequestSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void ManagedApps_RemoteRequestSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void ManagedApps_RemoteRequestSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool ManagedApps_RemoteRequestSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& ManagedApps_RemoteRequestSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& ManagedApps_RemoteRequestSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void ManagedApps_RemoteRequestSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void ManagedApps_RemoteRequestSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void ManagedApps_RemoteRequestSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void ManagedApps_RemoteRequestSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void ManagedApps_RemoteRequestSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ManagedApps_RemoteRequestSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void ManagedApps_RemoteRequestSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ManagedApps_RemoteSettingSignal::ManagedApps_RemoteSettingSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ManagedApps_RemoteSettingSignal::ManagedApps_RemoteSettingSignal (const ManagedApps_RemoteSettingSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ManagedApps_RemoteSettingSignal::ManagedApps_RemoteSettingSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ManagedApps_RemoteSettingSignal::~ManagedApps_RemoteSettingSignal() {
}

inline ManagedApps_RemoteSettingSignal& ManagedApps_RemoteSettingSignal::operator = (const ManagedApps_RemoteSettingSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool ManagedApps_RemoteSettingSignal::operator == (const ManagedApps_RemoteSettingSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool ManagedApps_RemoteSettingSignal::operator != (const ManagedApps_RemoteSettingSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ManagedApps_RemoteSettingSignal::operator < (const ManagedApps_RemoteSettingSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ManagedApps_RemoteSettingSignal::clone() {
    return new ManagedApps_RemoteSettingSignal(*this);
}

inline bool ManagedApps_RemoteSettingSignal::operator > (const ManagedApps_RemoteSettingSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ManagedApps_RemoteSettingSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void ManagedApps_RemoteSettingSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool ManagedApps_RemoteSettingSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ManagedApps_RemoteSettingSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& ManagedApps_RemoteSettingSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void ManagedApps_RemoteSettingSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void ManagedApps_RemoteSettingSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void ManagedApps_RemoteSettingSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void ManagedApps_RemoteSettingSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool ManagedApps_RemoteSettingSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& ManagedApps_RemoteSettingSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& ManagedApps_RemoteSettingSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void ManagedApps_RemoteSettingSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void ManagedApps_RemoteSettingSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void ManagedApps_RemoteSettingSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void ManagedApps_RemoteSettingSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void ManagedApps_RemoteSettingSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ManagedApps_RemoteSettingSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void ManagedApps_RemoteSettingSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  VPALogsSignal::VPALogsSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VPALogsSignal::VPALogsSignal (const VPALogsSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VPALogsSignal::VPALogsSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VPALogsSignal::~VPALogsSignal() {
}

inline VPALogsSignal& VPALogsSignal::operator = (const VPALogsSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool VPALogsSignal::operator == (const VPALogsSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool VPALogsSignal::operator != (const VPALogsSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool VPALogsSignal::operator < (const VPALogsSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VPALogsSignal::clone() {
    return new VPALogsSignal(*this);
}

inline bool VPALogsSignal::operator > (const VPALogsSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VPALogsSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void VPALogsSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool VPALogsSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& VPALogsSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& VPALogsSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void VPALogsSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void VPALogsSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void VPALogsSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void VPALogsSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool VPALogsSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& VPALogsSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& VPALogsSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void VPALogsSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void VPALogsSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void VPALogsSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void VPALogsSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void VPALogsSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void VPALogsSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void VPALogsSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  VPATelemetrySignal::VPATelemetrySignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VPATelemetrySignal::VPATelemetrySignal (const VPATelemetrySignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VPATelemetrySignal::VPATelemetrySignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VPATelemetrySignal::~VPATelemetrySignal() {
}

inline VPATelemetrySignal& VPATelemetrySignal::operator = (const VPATelemetrySignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool VPATelemetrySignal::operator == (const VPATelemetrySignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool VPATelemetrySignal::operator != (const VPATelemetrySignal& rhs) const {
    return ! (*this == rhs);
}

inline bool VPATelemetrySignal::operator < (const VPATelemetrySignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VPATelemetrySignal::clone() {
    return new VPATelemetrySignal(*this);
}

inline bool VPATelemetrySignal::operator > (const VPATelemetrySignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VPATelemetrySignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void VPATelemetrySignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool VPATelemetrySignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& VPATelemetrySignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& VPATelemetrySignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void VPATelemetrySignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void VPATelemetrySignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void VPATelemetrySignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void VPATelemetrySignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool VPATelemetrySignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& VPATelemetrySignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& VPATelemetrySignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void VPATelemetrySignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void VPATelemetrySignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void VPATelemetrySignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void VPATelemetrySignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void VPATelemetrySignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void VPATelemetrySignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void VPATelemetrySignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ValetModeSignal::ValetModeSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ValetModeSignal::ValetModeSignal (const ValetModeSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ValetModeSignal::ValetModeSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ValetModeSignal::~ValetModeSignal() {
}

inline ValetModeSignal& ValetModeSignal::operator = (const ValetModeSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool ValetModeSignal::operator == (const ValetModeSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool ValetModeSignal::operator != (const ValetModeSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ValetModeSignal::operator < (const ValetModeSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ValetModeSignal::clone() {
    return new ValetModeSignal(*this);
}

inline bool ValetModeSignal::operator > (const ValetModeSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ValetModeSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void ValetModeSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool ValetModeSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ValetModeSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& ValetModeSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void ValetModeSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void ValetModeSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void ValetModeSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void ValetModeSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool ValetModeSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& ValetModeSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& ValetModeSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void ValetModeSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void ValetModeSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void ValetModeSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void ValetModeSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void ValetModeSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ValetModeSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void ValetModeSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  LogActivationSignal::LogActivationSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LogActivationSignal::LogActivationSignal (const LogActivationSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LogActivationSignal::LogActivationSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LogActivationSignal::~LogActivationSignal() {
}

inline LogActivationSignal& LogActivationSignal::operator = (const LogActivationSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool LogActivationSignal::operator == (const LogActivationSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool LogActivationSignal::operator != (const LogActivationSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool LogActivationSignal::operator < (const LogActivationSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LogActivationSignal::clone() {
    return new LogActivationSignal(*this);
}

inline bool LogActivationSignal::operator > (const LogActivationSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LogActivationSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void LogActivationSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool LogActivationSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& LogActivationSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& LogActivationSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void LogActivationSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void LogActivationSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void LogActivationSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void LogActivationSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool LogActivationSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& LogActivationSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& LogActivationSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void LogActivationSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void LogActivationSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void LogActivationSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void LogActivationSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void LogActivationSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void LogActivationSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void LogActivationSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  LogRequestSignal::LogRequestSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LogRequestSignal::LogRequestSignal (const LogRequestSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LogRequestSignal::LogRequestSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LogRequestSignal::~LogRequestSignal() {
}

inline LogRequestSignal& LogRequestSignal::operator = (const LogRequestSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool LogRequestSignal::operator == (const LogRequestSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool LogRequestSignal::operator != (const LogRequestSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool LogRequestSignal::operator < (const LogRequestSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LogRequestSignal::clone() {
    return new LogRequestSignal(*this);
}

inline bool LogRequestSignal::operator > (const LogRequestSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LogRequestSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void LogRequestSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool LogRequestSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& LogRequestSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& LogRequestSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void LogRequestSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void LogRequestSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void LogRequestSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void LogRequestSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool LogRequestSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& LogRequestSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& LogRequestSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void LogRequestSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void LogRequestSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void LogRequestSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void LogRequestSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void LogRequestSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void LogRequestSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void LogRequestSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  LogTuneSignal::LogTuneSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LogTuneSignal::LogTuneSignal (const LogTuneSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LogTuneSignal::LogTuneSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LogTuneSignal::~LogTuneSignal() {
}

inline LogTuneSignal& LogTuneSignal::operator = (const LogTuneSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool LogTuneSignal::operator == (const LogTuneSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool LogTuneSignal::operator != (const LogTuneSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool LogTuneSignal::operator < (const LogTuneSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LogTuneSignal::clone() {
    return new LogTuneSignal(*this);
}

inline bool LogTuneSignal::operator > (const LogTuneSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LogTuneSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void LogTuneSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool LogTuneSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& LogTuneSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& LogTuneSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void LogTuneSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void LogTuneSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void LogTuneSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void LogTuneSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool LogTuneSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& LogTuneSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& LogTuneSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void LogTuneSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void LogTuneSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void LogTuneSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void LogTuneSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void LogTuneSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void LogTuneSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void LogTuneSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  LogSetProbeVerbositySignal::LogSetProbeVerbositySignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LogSetProbeVerbositySignal::LogSetProbeVerbositySignal (const LogSetProbeVerbositySignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LogSetProbeVerbositySignal::LogSetProbeVerbositySignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LogSetProbeVerbositySignal::~LogSetProbeVerbositySignal() {
}

inline LogSetProbeVerbositySignal& LogSetProbeVerbositySignal::operator = (const LogSetProbeVerbositySignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool LogSetProbeVerbositySignal::operator == (const LogSetProbeVerbositySignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool LogSetProbeVerbositySignal::operator != (const LogSetProbeVerbositySignal& rhs) const {
    return ! (*this == rhs);
}

inline bool LogSetProbeVerbositySignal::operator < (const LogSetProbeVerbositySignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LogSetProbeVerbositySignal::clone() {
    return new LogSetProbeVerbositySignal(*this);
}

inline bool LogSetProbeVerbositySignal::operator > (const LogSetProbeVerbositySignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LogSetProbeVerbositySignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void LogSetProbeVerbositySignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool LogSetProbeVerbositySignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& LogSetProbeVerbositySignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& LogSetProbeVerbositySignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void LogSetProbeVerbositySignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void LogSetProbeVerbositySignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void LogSetProbeVerbositySignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void LogSetProbeVerbositySignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool LogSetProbeVerbositySignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& LogSetProbeVerbositySignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& LogSetProbeVerbositySignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void LogSetProbeVerbositySignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void LogSetProbeVerbositySignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void LogSetProbeVerbositySignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void LogSetProbeVerbositySignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void LogSetProbeVerbositySignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void LogSetProbeVerbositySignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void LogSetProbeVerbositySignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  LogSetSLogBufferSizeSignal::LogSetSLogBufferSizeSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LogSetSLogBufferSizeSignal::LogSetSLogBufferSizeSignal (const LogSetSLogBufferSizeSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LogSetSLogBufferSizeSignal::LogSetSLogBufferSizeSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LogSetSLogBufferSizeSignal::~LogSetSLogBufferSizeSignal() {
}

inline LogSetSLogBufferSizeSignal& LogSetSLogBufferSizeSignal::operator = (const LogSetSLogBufferSizeSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool LogSetSLogBufferSizeSignal::operator == (const LogSetSLogBufferSizeSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool LogSetSLogBufferSizeSignal::operator != (const LogSetSLogBufferSizeSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool LogSetSLogBufferSizeSignal::operator < (const LogSetSLogBufferSizeSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LogSetSLogBufferSizeSignal::clone() {
    return new LogSetSLogBufferSizeSignal(*this);
}

inline bool LogSetSLogBufferSizeSignal::operator > (const LogSetSLogBufferSizeSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LogSetSLogBufferSizeSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void LogSetSLogBufferSizeSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool LogSetSLogBufferSizeSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& LogSetSLogBufferSizeSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& LogSetSLogBufferSizeSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void LogSetSLogBufferSizeSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void LogSetSLogBufferSizeSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void LogSetSLogBufferSizeSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void LogSetSLogBufferSizeSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool LogSetSLogBufferSizeSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& LogSetSLogBufferSizeSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& LogSetSLogBufferSizeSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void LogSetSLogBufferSizeSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void LogSetSLogBufferSizeSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void LogSetSLogBufferSizeSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void LogSetSLogBufferSizeSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void LogSetSLogBufferSizeSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void LogSetSLogBufferSizeSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void LogSetSLogBufferSizeSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  LogSetDefaultLogConfigSignal::LogSetDefaultLogConfigSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LogSetDefaultLogConfigSignal::LogSetDefaultLogConfigSignal (const LogSetDefaultLogConfigSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LogSetDefaultLogConfigSignal::LogSetDefaultLogConfigSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LogSetDefaultLogConfigSignal::~LogSetDefaultLogConfigSignal() {
}

inline LogSetDefaultLogConfigSignal& LogSetDefaultLogConfigSignal::operator = (const LogSetDefaultLogConfigSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool LogSetDefaultLogConfigSignal::operator == (const LogSetDefaultLogConfigSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool LogSetDefaultLogConfigSignal::operator != (const LogSetDefaultLogConfigSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool LogSetDefaultLogConfigSignal::operator < (const LogSetDefaultLogConfigSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LogSetDefaultLogConfigSignal::clone() {
    return new LogSetDefaultLogConfigSignal(*this);
}

inline bool LogSetDefaultLogConfigSignal::operator > (const LogSetDefaultLogConfigSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LogSetDefaultLogConfigSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void LogSetDefaultLogConfigSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool LogSetDefaultLogConfigSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& LogSetDefaultLogConfigSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& LogSetDefaultLogConfigSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void LogSetDefaultLogConfigSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void LogSetDefaultLogConfigSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void LogSetDefaultLogConfigSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void LogSetDefaultLogConfigSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool LogSetDefaultLogConfigSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& LogSetDefaultLogConfigSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& LogSetDefaultLogConfigSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void LogSetDefaultLogConfigSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void LogSetDefaultLogConfigSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void LogSetDefaultLogConfigSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void LogSetDefaultLogConfigSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void LogSetDefaultLogConfigSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void LogSetDefaultLogConfigSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void LogSetDefaultLogConfigSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  MapInstallRequestACKSignal::MapInstallRequestACKSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MapInstallRequestACKSignal::MapInstallRequestACKSignal (const MapInstallRequestACKSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MapInstallRequestACKSignal::MapInstallRequestACKSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MapInstallRequestACKSignal::~MapInstallRequestACKSignal() {
}

inline MapInstallRequestACKSignal& MapInstallRequestACKSignal::operator = (const MapInstallRequestACKSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool MapInstallRequestACKSignal::operator == (const MapInstallRequestACKSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool MapInstallRequestACKSignal::operator != (const MapInstallRequestACKSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool MapInstallRequestACKSignal::operator < (const MapInstallRequestACKSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MapInstallRequestACKSignal::clone() {
    return new MapInstallRequestACKSignal(*this);
}

inline bool MapInstallRequestACKSignal::operator > (const MapInstallRequestACKSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MapInstallRequestACKSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void MapInstallRequestACKSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool MapInstallRequestACKSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& MapInstallRequestACKSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& MapInstallRequestACKSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void MapInstallRequestACKSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void MapInstallRequestACKSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void MapInstallRequestACKSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void MapInstallRequestACKSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool MapInstallRequestACKSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& MapInstallRequestACKSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& MapInstallRequestACKSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void MapInstallRequestACKSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void MapInstallRequestACKSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void MapInstallRequestACKSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void MapInstallRequestACKSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void MapInstallRequestACKSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void MapInstallRequestACKSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void MapInstallRequestACKSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  MapInstallStatusRequestACKSignal::MapInstallStatusRequestACKSignal ()  :
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MapInstallStatusRequestACKSignal::MapInstallStatusRequestACKSignal (const MapInstallStatusRequestACKSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _jsonDownloadHeader (),
    _jsonDownloadData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MapInstallStatusRequestACKSignal::MapInstallStatusRequestACKSignal (const ::std::string& jsonDownloadHeader_, const ::std::string& jsonDownloadData_)  :
    _jsonDownloadHeader (jsonDownloadHeader_),
    _jsonDownloadData (jsonDownloadData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MapInstallStatusRequestACKSignal::~MapInstallStatusRequestACKSignal() {
}

inline MapInstallStatusRequestACKSignal& MapInstallStatusRequestACKSignal::operator = (const MapInstallStatusRequestACKSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasJsonDownloadHeader()) {
            setJsonDownloadHeader(rhs.getJsonDownloadHeader());
        } else {
            clearJsonDownloadHeader();
        }
        if (rhs.hasJsonDownloadData()) {
            setJsonDownloadData(rhs.getJsonDownloadData());
        } else {
            clearJsonDownloadData();
        }
    }
    return *this;
}

inline bool MapInstallStatusRequestACKSignal::operator == (const MapInstallStatusRequestACKSignal& rhs) const {
    return (((!hasJsonDownloadHeader() && !rhs.hasJsonDownloadHeader()) || getJsonDownloadHeader() == rhs.getJsonDownloadHeader()) &&
        ((!hasJsonDownloadData() && !rhs.hasJsonDownloadData()) || getJsonDownloadData() == rhs.getJsonDownloadData()));
}

inline bool MapInstallStatusRequestACKSignal::operator != (const MapInstallStatusRequestACKSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool MapInstallStatusRequestACKSignal::operator < (const MapInstallStatusRequestACKSignal& rhs) const {
    if (hasJsonDownloadHeader() || rhs.hasJsonDownloadHeader()) {
        if (getJsonDownloadHeader() < rhs.getJsonDownloadHeader()) return true;
        if (getJsonDownloadHeader() > rhs.getJsonDownloadHeader()) return false;
    }
    if (hasJsonDownloadData() || rhs.hasJsonDownloadData()) {
        if (getJsonDownloadData() < rhs.getJsonDownloadData()) return true;
        if (getJsonDownloadData() > rhs.getJsonDownloadData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MapInstallStatusRequestACKSignal::clone() {
    return new MapInstallStatusRequestACKSignal(*this);
}

inline bool MapInstallStatusRequestACKSignal::operator > (const MapInstallStatusRequestACKSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MapInstallStatusRequestACKSignal::clear() {
    clearJsonDownloadHeader();
    clearJsonDownloadData();
}

inline void MapInstallStatusRequestACKSignal::clearJsonDownloadHeader() {
    if (hasJsonDownloadHeader()) {
         clear_has_jsonDownloadHeader();
        _jsonDownloadHeader.clear();
     }
}

inline bool MapInstallStatusRequestACKSignal::hasJsonDownloadHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& MapInstallStatusRequestACKSignal::getJsonDownloadHeader () const {
    return _jsonDownloadHeader;
}

inline ::std::string& MapInstallStatusRequestACKSignal::getJsonDownloadHeaderMutable () {
    set_has_jsonDownloadHeader();
    return _jsonDownloadHeader;
}

inline void MapInstallStatusRequestACKSignal::setJsonDownloadHeader (const ::std::string& jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader = jsonDownloadHeader_;
}

inline void MapInstallStatusRequestACKSignal::setJsonDownloadHeader (const char* jsonDownloadHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadHeader_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(jsonDownloadHeader_);
}

inline void MapInstallStatusRequestACKSignal::setJsonDownloadHeader (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadHeader();
    this->_jsonDownloadHeader.assign(value, size);
}

inline void MapInstallStatusRequestACKSignal::clearJsonDownloadData() {
    if (hasJsonDownloadData()) {
         clear_has_jsonDownloadData();
        _jsonDownloadData.clear();
     }
}

inline bool MapInstallStatusRequestACKSignal::hasJsonDownloadData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& MapInstallStatusRequestACKSignal::getJsonDownloadData () const {
    return _jsonDownloadData;
}

inline ::std::string& MapInstallStatusRequestACKSignal::getJsonDownloadDataMutable () {
    set_has_jsonDownloadData();
    return _jsonDownloadData;
}

inline void MapInstallStatusRequestACKSignal::setJsonDownloadData (const ::std::string& jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData = jsonDownloadData_;
}

inline void MapInstallStatusRequestACKSignal::setJsonDownloadData (const char* jsonDownloadData_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (jsonDownloadData_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(jsonDownloadData_);
}

inline void MapInstallStatusRequestACKSignal::setJsonDownloadData (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_jsonDownloadData();
    this->_jsonDownloadData.assign(value, size);
}

inline void MapInstallStatusRequestACKSignal::set_has_jsonDownloadHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void MapInstallStatusRequestACKSignal::clear_has_jsonDownloadHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void MapInstallStatusRequestACKSignal::set_has_jsonDownloadData () {
    _has_bits_[0] |= 1u << 1;
}

inline void MapInstallStatusRequestACKSignal::clear_has_jsonDownloadData () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace DummService
} // namespace dumm
} // namespace cm
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_CM_DUMM_DUMMSERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
