#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef DIMMING_MAIN_FI_TYPES_H
#define DIMMING_MAIN_FI_TYPES_H

#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include <cstring>

/**
 * Types dimming_main_fi_types
 */

namespace dimming_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_SecondDisp_VersionInfo;

// type definitions
/**
 * <p>Possible range of LUN identifiers (0..15)</p>
 * <p>LUNs = Logical unit numbers</p>
 * <p>LUNs are used to have an abstraction layer between the used PWMs and the connected LEDs/Display</p>
 * <p>The definition of LUNs is project specific!</p>
 * <p>---</p>
 * <p>This type is available starting with FI 2.0</p>
 */
typedef uint8 T_u8_DIM_LUN;

/**
 * <p>Possible permille values for dimming (0 to 1000 = 0.0 to 100.0%)</p>
 * <p>---</p>
 * <p>This type is available starting with FI 2.0</p>
 */
typedef uint16 T_u16_DIM_Permille;

/**
 * <p>Possible values for LED halfclasses used for tuning of the keyboard illumination.</p>
 * <p>This information presented here is only used internally and is made only available for debug/diagnosis/verification.</p>
 * <p>---</p>
 * <p>Additional information: After production LEDs are categorized into 7 halfclasses depending on their brightness.
 * Each LED from a specific type within one halfclass has the same brightness like all other LED in this halfclass.
 * Due to the different halfclasses the LEDs needs different tuning of their dimming values.
 * The halfclass value itself is determined through a resistor network on the hardware</p>
 * <p>---</p>
 * <p>This type is available starting with FI 2.0</p>
 */
typedef uint8 T_u8_DIM_Halfclasses;

/**
 * <p>Temperature values (-400..1200 = -40.0..120.0 Degree Celsius)</p>
 * <p>---</p>
 * <p>This type is available starting with FI 2.0</p>
 */
typedef int16 T_s16_DIM_Temperature;


/**
 * Record type containing version information.
 */
class T_SecondDisp_VersionInfo {
public:

    /**
     * Default constructor
     */
    inline  T_SecondDisp_VersionInfo ();

    /**
     * Copy constructor
     */
    inline  T_SecondDisp_VersionInfo (const T_SecondDisp_VersionInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_SecondDisp_VersionInfo (uint8 u8Upper_, uint8 u8Mid_, uint8 u8Lower_);

    /**
     * Destructor
     */
    inline  ~T_SecondDisp_VersionInfo();

    /**
     * Assignment operator
     */
    inline T_SecondDisp_VersionInfo& operator = (const T_SecondDisp_VersionInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SecondDisp_VersionInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SecondDisp_VersionInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SecondDisp_VersionInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SecondDisp_VersionInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Upper"

    static const int kU8Upper = 0;

    /**
     * Clears the field "u8Upper".
     *
     * The field will be set to its default value. The hasU8Upper()
     * method will return false.
     */
    inline void clearU8Upper();

    /**
     * Checks whether the field "u8Upper" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Upper()). Otherwise it will return false.
     */
    inline bool hasU8Upper () const;

    /**
     * Returns the value of the member "u8Upper".
     *
     * Upper (= Major) version number.
     *
     * @return The value of the field "u8Upper"
     */
    inline uint8 getU8Upper () const;

    /**
     * Sets the value of the member "u8Upper".
     *
     * Upper (= Major) version number.
     *
     * @param u8Upper The value which will be set
     */
    inline void setU8Upper (uint8 u8Upper_);

    // API of field "u8Mid"

    static const int kU8Mid = 1;

    /**
     * Clears the field "u8Mid".
     *
     * The field will be set to its default value. The hasU8Mid()
     * method will return false.
     */
    inline void clearU8Mid();

    /**
     * Checks whether the field "u8Mid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Mid()). Otherwise it will return false.
     */
    inline bool hasU8Mid () const;

    /**
     * Returns the value of the member "u8Mid".
     *
     * Mid (= Minor) version number.
     *
     * @return The value of the field "u8Mid"
     */
    inline uint8 getU8Mid () const;

    /**
     * Sets the value of the member "u8Mid".
     *
     * Mid (= Minor) version number.
     *
     * @param u8Mid The value which will be set
     */
    inline void setU8Mid (uint8 u8Mid_);

    // API of field "u8Lower"

    static const int kU8Lower = 2;

    /**
     * Clears the field "u8Lower".
     *
     * The field will be set to its default value. The hasU8Lower()
     * method will return false.
     */
    inline void clearU8Lower();

    /**
     * Checks whether the field "u8Lower" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Lower()). Otherwise it will return false.
     */
    inline bool hasU8Lower () const;

    /**
     * Returns the value of the member "u8Lower".
     *
     * Lower (= Patch) version number.
     *
     * @return The value of the field "u8Lower"
     */
    inline uint8 getU8Lower () const;

    /**
     * Sets the value of the member "u8Lower".
     *
     * Lower (= Patch) version number.
     *
     * @param u8Lower The value which will be set
     */
    inline void setU8Lower (uint8 u8Lower_);

    static const T_SecondDisp_VersionInfo &getDefaultInstance();

private:

    inline void set_has_u8Upper ();

    inline void clear_has_u8Upper ();

    inline void set_has_u8Mid ();

    inline void clear_has_u8Mid ();

    inline void set_has_u8Lower ();

    inline void clear_has_u8Lower ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8Upper;

    uint8 _u8Mid;

    uint8 _u8Lower;

};

inline  T_SecondDisp_VersionInfo::T_SecondDisp_VersionInfo ()  :
    _u8Upper (0u),
    _u8Mid (0u),
    _u8Lower (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SecondDisp_VersionInfo::T_SecondDisp_VersionInfo (const T_SecondDisp_VersionInfo &rhs)  :
    _u8Upper (0u),
    _u8Mid (0u),
    _u8Lower (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SecondDisp_VersionInfo::T_SecondDisp_VersionInfo (uint8 u8Upper_, uint8 u8Mid_, uint8 u8Lower_)  :
    _u8Upper (u8Upper_),
    _u8Mid (u8Mid_),
    _u8Lower (u8Lower_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SecondDisp_VersionInfo::~T_SecondDisp_VersionInfo() {
}

inline T_SecondDisp_VersionInfo& T_SecondDisp_VersionInfo::operator = (const T_SecondDisp_VersionInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8Upper()) {
            setU8Upper(rhs.getU8Upper());
        } else {
            clearU8Upper();
        }
        if (rhs.hasU8Mid()) {
            setU8Mid(rhs.getU8Mid());
        } else {
            clearU8Mid();
        }
        if (rhs.hasU8Lower()) {
            setU8Lower(rhs.getU8Lower());
        } else {
            clearU8Lower();
        }
    }
    return *this;
}

inline bool T_SecondDisp_VersionInfo::operator == (const T_SecondDisp_VersionInfo& rhs) const {
    return (((!hasU8Upper() && !rhs.hasU8Upper()) || getU8Upper() == rhs.getU8Upper()) &&
        ((!hasU8Mid() && !rhs.hasU8Mid()) || getU8Mid() == rhs.getU8Mid()) &&
        ((!hasU8Lower() && !rhs.hasU8Lower()) || getU8Lower() == rhs.getU8Lower()));
}

inline bool T_SecondDisp_VersionInfo::operator != (const T_SecondDisp_VersionInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SecondDisp_VersionInfo::operator < (const T_SecondDisp_VersionInfo& rhs) const {
    if (hasU8Upper() || rhs.hasU8Upper()) {
        if (getU8Upper() < rhs.getU8Upper()) return true;
        if (getU8Upper() > rhs.getU8Upper()) return false;
    }
    if (hasU8Mid() || rhs.hasU8Mid()) {
        if (getU8Mid() < rhs.getU8Mid()) return true;
        if (getU8Mid() > rhs.getU8Mid()) return false;
    }
    if (hasU8Lower() || rhs.hasU8Lower()) {
        if (getU8Lower() < rhs.getU8Lower()) return true;
        if (getU8Lower() > rhs.getU8Lower()) return false;
    }
    return false;
}

inline bool T_SecondDisp_VersionInfo::operator > (const T_SecondDisp_VersionInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SecondDisp_VersionInfo::clear() {
    clearU8Upper();
    clearU8Mid();
    clearU8Lower();
}

inline void T_SecondDisp_VersionInfo::clearU8Upper() {
    if (hasU8Upper()) {
         clear_has_u8Upper();
        _u8Upper = 0u;
     }
}

inline bool T_SecondDisp_VersionInfo::hasU8Upper () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_SecondDisp_VersionInfo::getU8Upper () const {
    return _u8Upper;
}

inline void T_SecondDisp_VersionInfo::setU8Upper (uint8 u8Upper_) {
    set_has_u8Upper();
    this->_u8Upper = u8Upper_;
}

inline void T_SecondDisp_VersionInfo::clearU8Mid() {
    if (hasU8Mid()) {
         clear_has_u8Mid();
        _u8Mid = 0u;
     }
}

inline bool T_SecondDisp_VersionInfo::hasU8Mid () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_SecondDisp_VersionInfo::getU8Mid () const {
    return _u8Mid;
}

inline void T_SecondDisp_VersionInfo::setU8Mid (uint8 u8Mid_) {
    set_has_u8Mid();
    this->_u8Mid = u8Mid_;
}

inline void T_SecondDisp_VersionInfo::clearU8Lower() {
    if (hasU8Lower()) {
         clear_has_u8Lower();
        _u8Lower = 0u;
     }
}

inline bool T_SecondDisp_VersionInfo::hasU8Lower () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_SecondDisp_VersionInfo::getU8Lower () const {
    return _u8Lower;
}

inline void T_SecondDisp_VersionInfo::setU8Lower (uint8 u8Lower_) {
    set_has_u8Lower();
    this->_u8Lower = u8Lower_;
}

inline void T_SecondDisp_VersionInfo::set_has_u8Upper () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SecondDisp_VersionInfo::clear_has_u8Upper () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SecondDisp_VersionInfo::set_has_u8Mid () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SecondDisp_VersionInfo::clear_has_u8Mid () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SecondDisp_VersionInfo::set_has_u8Lower () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SecondDisp_VersionInfo::clear_has_u8Lower () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace dimming_main_fi_types

#endif // DIMMING_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
