#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef DIMMING_MAIN_FI_H
#define DIMMING_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "dimming_main_fi_types.h"
#include "dimming_main_fi_typesConst.h"
#include <cstring>

/**
 * CCA Functional Interface 'dimming_main_fi'
 *
 * Fullname: VD_Dimming CCA Service, Application Functional Interface
 *
 * Version:
 *
 * Author: Fredy Wenzel
 *
 * Date: $Date:   06 March 2013 11:00:00  $
 *
 * Department:
 *
 * Title: VD_DIMMING_FI
 *
 * <b>Description of 'dimming_main_fi':</b>
 *
 * VD_Dimming messages for CCA applications
 */

namespace dimming_main_fi {

static const int SERVICE_ID = 39;

static const int FID_DIM_INFO_CarIlluminationData = 8192;

static const int FID_DIM_INFO_LightSensorBrightness = 8193;

static const int FID_DIM_INFO_DimmingMode = 8194;

static const int FID_DIM_INFO_EmulationMode = 8195;

static const int FID_DIM_INFO_ITC = 8196;

static const int FID_DIM_INFO_PWMBrightness = 8197;

static const int FID_DIM_INFO_CANBrightness = 8198;

static const int FID_DIM_KEYB_Brightness = 8448;

static const int FID_DIM_KEYB_Halfclass = 8449;

static const int FID_DIM_DISP_DriverInitalized = 8704;

static const int FID_DIM_DISP_ScreenContentAvailable = 8705;

static const int FID_DIM_DISP_Brightness = 8706;

static const int FID_DIM_DISP_Backlight = 8707;

static const int FID_DIM_DISP_TemperatureInfo = 8708;

static const int FID_DIM_DISP_Size = 8709;

static const int FID_DIM_DISP_BrightnessLevel = 8710;

static const int FID_DIM_DISP_PanelTemperature = 8711;

static const int FID_DIM_DISP_BrightnessLevelExtended = 8712;

static const int FID_DIM_DISP_VideoBrightnessLevel = 8713;

static const int FID_DIM_DISP_ContrastLevel = 8714;

static const int FID_DIM_DISP_BlackLevel = 8715;

static const int FID_DIM_DISP_YCurveLevel = 8716;

static const int FID_DIM_DISP_TintLevel = 8717;

static const int FID_DIM_DISP_ColorLevel = 8718;

static const int FID_DIM_DISP_DAY_LUMINOSITY_OFFSET = 8719;

static const int FID_DIM_DISP_NIGHT_LUMINOSITY_OFFSET = 8720;

static const int FID_DIM_DISP_COCKPIT_SLIDER_OFFSET = 8721;

static const int FID_DIM_DIAG_Variant = 8960;

static const int FID_DIM_DIAG_BrightnessInputType = 8961;

static const int FID_DIM_DISP_CSCContrastLevel = 12810;

static const int FID_DIM_DISP_CSCBlackLevel = 12811;

static const int FID_DIM_DISP_CSCGammaLevel = 12812;

static const int FID_DIM_DISP_CSCSaturationLevel = 12813;

static const int FID_DIM_DISP_CSCColorLevel = 12814;

static const int FID_DIM_SECOND_DISP_AllDisplayParam = 12815;

static const int FID_DIM_SECOND_DISP_SelfDiagnosisResult = 12816;

static const int FID_FI_VD_DIMMING_DEFAULT = 257;

static const int FID_DIM_INFO_SetDimmingMode = 9472;

static const int FID_DIM_INFO_SetEmulationMode = 9473;

static const int FID_DIM_INFO_SetDimmingState = 9552;

static const int FID_DIM_INFO_GetDimmingState = 9553;

static const int FID_DIM_INFO_SetDimmingBrightness = 9554;

static const int FID_DIM_INFO_GetDimmingBrightness = 9555;

static const int FID_DIM_INFO_GetPWMBrightness = 9556;

static const int FID_DIM_KEYB_SetDimming = 9728;

static const int FID_DIM_KEYB_SetDimmingPWM = 9729;

static const int FID_DIM_DISP_SetDriverInitalized = 9984;

static const int FID_DIM_DISP_SetScreenContentAvailable = 9985;

static const int FID_DIM_DISP_SetDimming = 9986;

static const int FID_DIM_DISP_SwitchBacklight = 9987;

static const int FID_DIM_DISP_SetBrightnessLevel = 9988;

static const int FID_DIM_DISP_SetBrightnessLevelExtended = 9989;

static const int FID_DIM_DISP_SetVideoBrightnessLevel = 9990;

static const int FID_DIM_DISP_SetContrastLevel = 9991;

static const int FID_DIM_DISP_SetBlackLevel = 9992;

static const int FID_DIM_DISP_SetYCurveLevel = 9993;

static const int FID_DIM_DISP_SetTintLevel = 9994;

static const int FID_DIM_DISP_SetColorLevel = 9995;

static const int FID_DIM_DIAG_SetBrightnessInputType = 10240;

static const int FID_DIM_DISP_SetCSCContrastLevel = 14087;

static const int FID_DIM_DISP_SetCSCBlackLevel = 14088;

static const int FID_DIM_DISP_SetCSCGammaLevel = 14089;

static const int FID_DIM_DISP_SetCSCSaturationLevel = 14090;

static const int FID_DIM_DISP_SetCSCColorLevel = 14091;

static const int FID_DIM_SECOND_DISP_SetDispParameter = 14092;

static const int FID_DIM_SECOND_DISP_SetDispOnOff = 14093;

static const int FID_DIM_SECOND_DISP_HardwareVersion = 14094;

static const int FID_DIM_SECOND_DISP_SoftwareVersion = 14095;

static const int FID_DIM_SECOND_DISP_GetALLParam = 14096;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 4;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 1;

// forward declarations
class DIM_INFO_CarIlluminationDataStatus;

class DIM_INFO_CarIlluminationDataErrorStructure;

class DIM_INFO_CarIlluminationDataError;

class DIM_INFO_LightSensorBrightnessStatus;

class DIM_INFO_LightSensorBrightnessErrorStructure;

class DIM_INFO_LightSensorBrightnessError;

class DIM_INFO_DimmingModeStatus;

class DIM_INFO_DimmingModeErrorStructure;

class DIM_INFO_DimmingModeError;

class DIM_INFO_EmulationModeStatus;

class DIM_INFO_EmulationModeErrorStructure;

class DIM_INFO_EmulationModeError;

class DIM_INFO_ITCStatus;

class DIM_INFO_ITCErrorStructure;

class DIM_INFO_ITCError;

class DIM_INFO_PWMBrightnessStatus;

class DIM_INFO_PWMBrightnessErrorStructure;

class DIM_INFO_PWMBrightnessError;

class DIM_INFO_CANBrightnessStatus;

class DIM_INFO_CANBrightnessErrorStructure;

class DIM_INFO_CANBrightnessError;

class DIM_KEYB_BrightnessStatus;

class DIM_KEYB_BrightnessErrorStructure;

class DIM_KEYB_BrightnessError;

class DIM_KEYB_HalfclassStatus;

class DIM_KEYB_HalfclassErrorStructure;

class DIM_KEYB_HalfclassError;

class DIM_DISP_DriverInitalizedStatus;

class DIM_DISP_DriverInitalizedErrorStructure;

class DIM_DISP_DriverInitalizedError;

class DIM_DISP_ScreenContentAvailableStatus;

class DIM_DISP_ScreenContentAvailableErrorStructure;

class DIM_DISP_ScreenContentAvailableError;

class DIM_DISP_BrightnessStatus;

class DIM_DISP_BrightnessErrorStructure;

class DIM_DISP_BrightnessError;

class DIM_DISP_BacklightStatus;

class DIM_DISP_BacklightErrorStructure;

class DIM_DISP_BacklightError;

class DIM_DISP_TemperatureInfoStatus;

class DIM_DISP_TemperatureInfoErrorStructure;

class DIM_DISP_TemperatureInfoError;

class DIM_DISP_SizeStatus;

class DIM_DISP_SizeErrorStructure;

class DIM_DISP_SizeError;

class DIM_DISP_BrightnessLevelStatus;

class DIM_DISP_BrightnessLevelErrorStructure;

class DIM_DISP_BrightnessLevelError;

class DIM_DISP_PanelTemperatureStatus;

class DIM_DISP_PanelTemperatureErrorStructure;

class DIM_DISP_PanelTemperatureError;

class DIM_DISP_BrightnessLevelExtendedStatus;

class DIM_DISP_BrightnessLevelExtendedErrorStructure;

class DIM_DISP_BrightnessLevelExtendedError;

class DIM_DISP_VideoBrightnessLevelStatus;

class DIM_DISP_VideoBrightnessLevelErrorStructure;

class DIM_DISP_VideoBrightnessLevelError;

class DIM_DISP_ContrastLevelStatus;

class DIM_DISP_ContrastLevelErrorStructure;

class DIM_DISP_ContrastLevelError;

class DIM_DISP_BlackLevelStatus;

class DIM_DISP_BlackLevelErrorStructure;

class DIM_DISP_BlackLevelError;

class DIM_DISP_YCurveLevelStatus;

class DIM_DISP_YCurveLevelErrorStructure;

class DIM_DISP_YCurveLevelError;

class DIM_DISP_TintLevelStatus;

class DIM_DISP_TintLevelErrorStructure;

class DIM_DISP_TintLevelError;

class DIM_DISP_ColorLevelStatus;

class DIM_DISP_ColorLevelErrorStructure;

class DIM_DISP_ColorLevelError;

class DIM_DISP_DAY_LUMINOSITY_OFFSETStatus;

class DIM_DISP_DAY_LUMINOSITY_OFFSETSet;

class DIM_DISP_DAY_LUMINOSITY_OFFSETErrorStructure;

class DIM_DISP_DAY_LUMINOSITY_OFFSETError;

class DIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus;

class DIM_DISP_NIGHT_LUMINOSITY_OFFSETSet;

class DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorStructure;

class DIM_DISP_NIGHT_LUMINOSITY_OFFSETError;

class DIM_DISP_COCKPIT_SLIDER_OFFSETStatus;

class DIM_DISP_COCKPIT_SLIDER_OFFSETSet;

class DIM_DISP_COCKPIT_SLIDER_OFFSETErrorStructure;

class DIM_DISP_COCKPIT_SLIDER_OFFSETError;

class DIM_DIAG_VariantStatus;

class DIM_DIAG_VariantErrorStructure;

class DIM_DIAG_VariantError;

class DIM_DIAG_BrightnessInputTypeStatus;

class DIM_DIAG_BrightnessInputTypeErrorStructure;

class DIM_DIAG_BrightnessInputTypeError;

class DIM_DISP_CSCContrastLevelStatus;

class DIM_DISP_CSCContrastLevelErrorStructure;

class DIM_DISP_CSCContrastLevelError;

class DIM_DISP_CSCBlackLevelStatus;

class DIM_DISP_CSCBlackLevelErrorStructure;

class DIM_DISP_CSCBlackLevelError;

class DIM_DISP_CSCGammaLevelStatus;

class DIM_DISP_CSCGammaLevelErrorStructure;

class DIM_DISP_CSCGammaLevelError;

class DIM_DISP_CSCSaturationLevelStatus;

class DIM_DISP_CSCSaturationLevelErrorStructure;

class DIM_DISP_CSCSaturationLevelError;

class DIM_DISP_CSCColorLevelStatus;

class DIM_DISP_CSCColorLevelErrorStructure;

class DIM_DISP_CSCColorLevelError;

class DIM_SECOND_DISP_AllDisplayParamStatus;

class DIM_SECOND_DISP_SelfDiagnosisResultStatus;

class FI_VD_DIMMING_DEFAULTStart;

class FI_VD_DIMMING_DEFAULTResult;

class DIM_INFO_SetDimmingModeStart;

class DIM_INFO_SetDimmingModeResult;

class DIM_INFO_SetDimmingModeErrorStructure;

class DIM_INFO_SetDimmingModeError;

class DIM_INFO_SetEmulationModeStart;

class DIM_INFO_SetEmulationModeResult;

class DIM_INFO_SetEmulationModeErrorStructure;

class DIM_INFO_SetEmulationModeError;

class DIM_INFO_SetDimmingStateStart;

class DIM_INFO_SetDimmingStateResult;

class DIM_INFO_SetDimmingStateErrorStructure;

class DIM_INFO_SetDimmingStateError;

class DIM_INFO_GetDimmingStateStart;

class DIM_INFO_GetDimmingStateResult;

class DIM_INFO_GetDimmingStateErrorStructure;

class DIM_INFO_GetDimmingStateError;

class DIM_INFO_SetDimmingBrightnessStart;

class DIM_INFO_SetDimmingBrightnessResult;

class DIM_INFO_SetDimmingBrightnessErrorStructure;

class DIM_INFO_SetDimmingBrightnessError;

class DIM_INFO_GetDimmingBrightnessStart;

class DIM_INFO_GetDimmingBrightnessResult;

class DIM_INFO_GetDimmingBrightnessErrorStructure;

class DIM_INFO_GetDimmingBrightnessError;

class DIM_INFO_GetPWMBrightnessResult;

class DIM_INFO_GetPWMBrightnessErrorStructure;

class DIM_INFO_GetPWMBrightnessError;

class DIM_KEYB_SetDimmingStart;

class DIM_KEYB_SetDimmingResult;

class DIM_KEYB_SetDimmingErrorStructure;

class DIM_KEYB_SetDimmingError;

class DIM_KEYB_SetDimmingPWMStart;

class DIM_KEYB_SetDimmingPWMResult;

class DIM_KEYB_SetDimmingPWMErrorStructure;

class DIM_KEYB_SetDimmingPWMError;

class DIM_DISP_SetDriverInitalizedStart;

class DIM_DISP_SetDriverInitalizedResult;

class DIM_DISP_SetDriverInitalizedErrorStructure;

class DIM_DISP_SetDriverInitalizedError;

class DIM_DISP_SetScreenContentAvailableStart;

class DIM_DISP_SetScreenContentAvailableResult;

class DIM_DISP_SetScreenContentAvailableErrorStructure;

class DIM_DISP_SetScreenContentAvailableError;

class DIM_DISP_SetDimmingStart;

class DIM_DISP_SetDimmingResult;

class DIM_DISP_SetDimmingErrorStructure;

class DIM_DISP_SetDimmingError;

class DIM_DISP_SwitchBacklightStart;

class DIM_DISP_SwitchBacklightResult;

class DIM_DISP_SwitchBacklightErrorStructure;

class DIM_DISP_SwitchBacklightError;

class DIM_DISP_SetBrightnessLevelStart;

class DIM_DISP_SetBrightnessLevelResult;

class DIM_DISP_SetBrightnessLevelErrorStructure;

class DIM_DISP_SetBrightnessLevelError;

class DIM_DISP_SetBrightnessLevelExtendedStart;

class DIM_DISP_SetBrightnessLevelExtendedResult;

class DIM_DISP_SetBrightnessLevelExtendedErrorStructure;

class DIM_DISP_SetBrightnessLevelExtendedError;

class DIM_DISP_SetVideoBrightnessLevelStart;

class DIM_DISP_SetVideoBrightnessLevelResult;

class DIM_DISP_SetVideoBrightnessLevelErrorStructure;

class DIM_DISP_SetVideoBrightnessLevelError;

class DIM_DISP_SetContrastLevelStart;

class DIM_DISP_SetContrastLevelResult;

class DIM_DISP_SetContrastLevelErrorStructure;

class DIM_DISP_SetContrastLevelError;

class DIM_DISP_SetBlackLevelStart;

class DIM_DISP_SetBlackLevelResult;

class DIM_DISP_SetBlackLevelErrorStructure;

class DIM_DISP_SetBlackLevelError;

class DIM_DISP_SetYCurveLevelStart;

class DIM_DISP_SetYCurveLevelResult;

class DIM_DISP_SetYCurveLevelErrorStructure;

class DIM_DISP_SetYCurveLevelError;

class DIM_DISP_SetTintLevelStart;

class DIM_DISP_SetTintLevelResult;

class DIM_DISP_SetTintLevelErrorStructure;

class DIM_DISP_SetTintLevelError;

class DIM_DISP_SetColorLevelStart;

class DIM_DISP_SetColorLevelResult;

class DIM_DISP_SetColorLevelErrorStructure;

class DIM_DISP_SetColorLevelError;

class DIM_DIAG_SetBrightnessInputTypeStart;

class DIM_DIAG_SetBrightnessInputTypeResult;

class DIM_DIAG_SetBrightnessInputTypeErrorStructure;

class DIM_DIAG_SetBrightnessInputTypeError;

class DIM_DISP_SetCSCContrastLevelStart;

class DIM_DISP_SetCSCContrastLevelResult;

class DIM_DISP_SetCSCContrastLevelErrorStructure;

class DIM_DISP_SetCSCContrastLevelError;

class DIM_DISP_SetCSCBlackLevelStart;

class DIM_DISP_SetCSCBlackLevelResult;

class DIM_DISP_SetCSCBlackLevelErrorStructure;

class DIM_DISP_SetCSCBlackLevelError;

class DIM_DISP_SetCSCGammaLevelStart;

class DIM_DISP_SetCSCGammaLevelResult;

class DIM_DISP_SetCSCGammaLevelErrorStructure;

class DIM_DISP_SetCSCGammaLevelError;

class DIM_DISP_SetCSCSaturationLevelStart;

class DIM_DISP_SetCSCSaturationLevelResult;

class DIM_DISP_SetCSCSaturationLevelErrorStructure;

class DIM_DISP_SetCSCSaturationLevelError;

class DIM_DISP_SetCSCColorLevelStart;

class DIM_DISP_SetCSCColorLevelResult;

class DIM_DISP_SetCSCColorLevelErrorStructure;

class DIM_DISP_SetCSCColorLevelError;

class DIM_SECOND_DISP_SetDispParameterStart;

class DIM_SECOND_DISP_SetDispParameterResult;

class DIM_SECOND_DISP_SetDispParameterErrorStructure;

class DIM_SECOND_DISP_SetDispParameterError;

class DIM_SECOND_DISP_SetDispOnOffStart;

class DIM_SECOND_DISP_SetDispOnOffResult;

class DIM_SECOND_DISP_SetDispOnOffErrorStructure;

class DIM_SECOND_DISP_SetDispOnOffError;

class DIM_SECOND_DISP_HardwareVersionResult;

class DIM_SECOND_DISP_HardwareVersionErrorStructure;

class DIM_SECOND_DISP_HardwareVersionError;

class DIM_SECOND_DISP_SoftwareVersionResult;

class DIM_SECOND_DISP_SoftwareVersionErrorStructure;

class DIM_SECOND_DISP_SoftwareVersionError;

// type definitions
/**
 * The get message of the property "DIM_INFO_CarIlluminationData"
 * <p>Provides the current status of the car's illumination switch and illumination value</p>
 * <p>These are the input values received from the car!
 * The values are being evaluated (together with other parameters) by VD_Dimming to determine
 * the current brightness and illumination settings.
 * These values are not to be mixed up with the current active brightness and illumination values of the headunit!
 * The car illumination brightness is either based on a PWM value or on a CAN value.
 * This depends on the setting of DIM_DIAG_BrightnessInputType.
 * If you want to know the current PWM-input or CAN-input values please check the corresponding properties.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to request current status of the car's illumination switch
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_INFO_CarIlluminationDataGet;

/**
 * The upreg message of the property "DIM_INFO_CarIlluminationData"
 * <p>Provides the current status of the car's illumination switch and illumination value</p>
 * <p>These are the input values received from the car!
 * The values are being evaluated (together with other parameters) by VD_Dimming to determine
 * the current brightness and illumination settings.
 * These values are not to be mixed up with the current active brightness and illumination values of the headunit!
 * The car illumination brightness is either based on a PWM value or on a CAN value.
 * This depends on the setting of DIM_DIAG_BrightnessInputType.
 * If you want to know the current PWM-input or CAN-input values please check the corresponding properties.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_INFO_CarIlluminationDataUpReg;

/**
 * The relUpReg message of the property "DIM_INFO_CarIlluminationData"
 * <p>Provides the current status of the car's illumination switch and illumination value</p>
 * <p>These are the input values received from the car!
 * The values are being evaluated (together with other parameters) by VD_Dimming to determine
 * the current brightness and illumination settings.
 * These values are not to be mixed up with the current active brightness and illumination values of the headunit!
 * The car illumination brightness is either based on a PWM value or on a CAN value.
 * This depends on the setting of DIM_DIAG_BrightnessInputType.
 * If you want to know the current PWM-input or CAN-input values please check the corresponding properties.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_INFO_CarIlluminationDataRelUpReg;

/**
 * The get message of the property "DIM_INFO_LightSensorBrightness"
 * <p>Provides the current status and value of the car's light sensor (if available)</p>
 * <p>Currently without further functionality, reserved for future use</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to request current status and value of the light sensor
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_INFO_LightSensorBrightnessGet;

/**
 * The upreg message of the property "DIM_INFO_LightSensorBrightness"
 * <p>Provides the current status and value of the car's light sensor (if available)</p>
 * <p>Currently without further functionality, reserved for future use</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_INFO_LightSensorBrightnessUpReg;

/**
 * The relUpReg message of the property "DIM_INFO_LightSensorBrightness"
 * <p>Provides the current status and value of the car's light sensor (if available)</p>
 * <p>Currently without further functionality, reserved for future use</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_INFO_LightSensorBrightnessRelUpReg;

/**
 * The get message of the property "DIM_INFO_DimmingMode"
 * <p>Provides the current configuration and status of the dimming mode (evaluated and received from car).
 * The status of the dimming mode depends on the configured dimming mode and the car's dimming mode.
 * Currently this information is only relevant for display dimming but in future or for different
 * customers this can also be relevant for keyboard.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to request current config/status of the dimming mode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_INFO_DimmingModeGet;

/**
 * The upreg message of the property "DIM_INFO_DimmingMode"
 * <p>Provides the current configuration and status of the dimming mode (evaluated and received from car).
 * The status of the dimming mode depends on the configured dimming mode and the car's dimming mode.
 * Currently this information is only relevant for display dimming but in future or for different
 * customers this can also be relevant for keyboard.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_INFO_DimmingModeUpReg;

/**
 * The relUpReg message of the property "DIM_INFO_DimmingMode"
 * <p>Provides the current configuration and status of the dimming mode (evaluated and received from car).
 * The status of the dimming mode depends on the configured dimming mode and the car's dimming mode.
 * Currently this information is only relevant for display dimming but in future or for different
 * customers this can also be relevant for keyboard.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_INFO_DimmingModeRelUpReg;

/**
 * The get message of the property "DIM_INFO_EmulationMode"
 * <p>Provides the current status of the EmulationMode</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to request the current status of the EmulationMode
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_INFO_EmulationModeGet;

/**
 * The upreg message of the property "DIM_INFO_EmulationMode"
 * <p>Provides the current status of the EmulationMode</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_INFO_EmulationModeUpReg;

/**
 * The relUpReg message of the property "DIM_INFO_EmulationMode"
 * <p>Provides the current status of the EmulationMode</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_INFO_EmulationModeRelUpReg;

/**
 * The get message of the property "DIM_INFO_ITC"
 * <p>Provides the current internal trouble code</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to request the current ITC
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_INFO_ITCGet;

/**
 * The upreg message of the property "DIM_INFO_ITC"
 * <p>Provides the current internal trouble code</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_INFO_ITCUpReg;

/**
 * The relUpReg message of the property "DIM_INFO_ITC"
 * <p>Provides the current internal trouble code</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_INFO_ITCRelUpReg;

/**
 * The get message of the property "DIM_INFO_PWMBrightness"
 * <p>Provides the current brightness as signalled by the car through PWM input</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to request the current PWM brightness value
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_INFO_PWMBrightnessGet;

/**
 * The upreg message of the property "DIM_INFO_PWMBrightness"
 * <p>Provides the current brightness as signalled by the car through PWM input</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_INFO_PWMBrightnessUpReg;

/**
 * The relUpReg message of the property "DIM_INFO_PWMBrightness"
 * <p>Provides the current brightness as signalled by the car through PWM input</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_INFO_PWMBrightnessRelUpReg;

/**
 * The get message of the property "DIM_INFO_CANBrightness"
 * <p>Provides the current brightness as signalled by the car through CAN input</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to request the current CAN brightness value
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_INFO_CANBrightnessGet;

/**
 * The upreg message of the property "DIM_INFO_CANBrightness"
 * <p>Provides the current brightness as signalled by the car through CAN input</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_INFO_CANBrightnessUpReg;

/**
 * The relUpReg message of the property "DIM_INFO_CANBrightness"
 * <p>Provides the current brightness as signalled by the car through CAN input</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_INFO_CANBrightnessRelUpReg;

/**
 * The get message of the property "DIM_KEYB_Brightness"
 * <p>Provides the current active keyboard brightness.
 * Even if multiple LED-groups (LUNs) are available the brighness control from the VD_Dimming server is the same.</p>
 * <p>---</p>
 * <p>Remark: This brightness value is in direct relation to the generated PWM output (if PWM is used).</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to request the current keybaord brightness
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_KEYB_BrightnessGet;

/**
 * The upreg message of the property "DIM_KEYB_Brightness"
 * <p>Provides the current active keyboard brightness.
 * Even if multiple LED-groups (LUNs) are available the brighness control from the VD_Dimming server is the same.</p>
 * <p>---</p>
 * <p>Remark: This brightness value is in direct relation to the generated PWM output (if PWM is used).</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_KEYB_BrightnessUpReg;

/**
 * The relUpReg message of the property "DIM_KEYB_Brightness"
 * <p>Provides the current active keyboard brightness.
 * Even if multiple LED-groups (LUNs) are available the brighness control from the VD_Dimming server is the same.</p>
 * <p>---</p>
 * <p>Remark: This brightness value is in direct relation to the generated PWM output (if PWM is used).</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_KEYB_BrightnessRelUpReg;

/**
 * The get message of the property "DIM_KEYB_Halfclass"
 * <p>Provides the current halfclass information:</p>
 * Halfclass ID for channel A
 * Halfclass ID for channel B
 * The current ADC channel number for channel A
 * The current ADC channel number for channel B
 * The measured AD value from channel A
 * The measured AD value from channel B
 * <p>---</p>
 * Attention:
 * It it possible to have two different Halfclasses configured in one panel.
 * Which Halfclass ID is used for each PWM is configureable for each PWM.
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to request current halfclass information
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_KEYB_HalfclassGet;

/**
 * The upreg message of the property "DIM_KEYB_Halfclass"
 * <p>Provides the current halfclass information:</p>
 * Halfclass ID for channel A
 * Halfclass ID for channel B
 * The current ADC channel number for channel A
 * The current ADC channel number for channel B
 * The measured AD value from channel A
 * The measured AD value from channel B
 * <p>---</p>
 * Attention:
 * It it possible to have two different Halfclasses configured in one panel.
 * Which Halfclass ID is used for each PWM is configureable for each PWM.
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_KEYB_HalfclassUpReg;

/**
 * The relUpReg message of the property "DIM_KEYB_Halfclass"
 * <p>Provides the current halfclass information:</p>
 * Halfclass ID for channel A
 * Halfclass ID for channel B
 * The current ADC channel number for channel A
 * The current ADC channel number for channel B
 * The measured AD value from channel A
 * The measured AD value from channel B
 * <p>---</p>
 * Attention:
 * It it possible to have two different Halfclasses configured in one panel.
 * Which Halfclass ID is used for each PWM is configureable for each PWM.
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_KEYB_HalfclassRelUpReg;

/**
 * The get message of the property "DIM_DISP_DriverInitalized"
 * <p>Used to determine the initialization status of the display driver.
 * This is used by VD_Dimming to determine the backlight status</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to get the initialization status of the display driver
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_DriverInitalizedGet;

/**
 * The upreg message of the property "DIM_DISP_DriverInitalized"
 * <p>Used to determine the initialization status of the display driver.
 * This is used by VD_Dimming to determine the backlight status</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_DriverInitalizedUpReg;

/**
 * The relUpReg message of the property "DIM_DISP_DriverInitalized"
 * <p>Used to determine the initialization status of the display driver.
 * This is used by VD_Dimming to determine the backlight status</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_DriverInitalizedRelUpReg;

/**
 * The get message of the property "DIM_DISP_ScreenContentAvailable"
 * <p>Used to determine the availablity of screen content.
 * VD_Dimming does not have this information as long as no one has updated this property (HMI/SPM)
 * This property will be set automatically to "Not Available" if VD_Dimming is shut down or
 * the display driver has been stopped.
 * The availability of screen content is necessary for VD_Dimming to activate the backlight.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to get the status of the screen content availability
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_ScreenContentAvailableGet;

/**
 * The upreg message of the property "DIM_DISP_ScreenContentAvailable"
 * <p>Used to determine the availablity of screen content.
 * VD_Dimming does not have this information as long as no one has updated this property (HMI/SPM)
 * This property will be set automatically to "Not Available" if VD_Dimming is shut down or
 * the display driver has been stopped.
 * The availability of screen content is necessary for VD_Dimming to activate the backlight.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_ScreenContentAvailableUpReg;

/**
 * The relUpReg message of the property "DIM_DISP_ScreenContentAvailable"
 * <p>Used to determine the availablity of screen content.
 * VD_Dimming does not have this information as long as no one has updated this property (HMI/SPM)
 * This property will be set automatically to "Not Available" if VD_Dimming is shut down or
 * the display driver has been stopped.
 * The availability of screen content is necessary for VD_Dimming to activate the backlight.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_ScreenContentAvailableRelUpReg;

/**
 * The get message of the property "DIM_DISP_Brightness"
 * <p>Provides the current active display brightness</p>
 * <p>---</p>
 * <p>Remark: This brightness value is in direct relation to the generated PWM output (if PWM is used).</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to request the current display brightness
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_BrightnessGet;

/**
 * The upreg message of the property "DIM_DISP_Brightness"
 * <p>Provides the current active display brightness</p>
 * <p>---</p>
 * <p>Remark: This brightness value is in direct relation to the generated PWM output (if PWM is used).</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_BrightnessUpReg;

/**
 * The relUpReg message of the property "DIM_DISP_Brightness"
 * <p>Provides the current active display brightness</p>
 * <p>---</p>
 * <p>Remark: This brightness value is in direct relation to the generated PWM output (if PWM is used).</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_BrightnessRelUpReg;

/**
 * The get message of the property "DIM_DISP_Backlight"
 * <p>Retrieve the current status of the display's backlight</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to get the current status of the display's backlight
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_BacklightGet;

/**
 * The upreg message of the property "DIM_DISP_Backlight"
 * <p>Retrieve the current status of the display's backlight</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_BacklightUpReg;

/**
 * The relUpReg message of the property "DIM_DISP_Backlight"
 * <p>Retrieve the current status of the display's backlight</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_BacklightRelUpReg;

/**
 * The get message of the property "DIM_DISP_TemperatureInfo"
 * <p>Read out the temperature information. This property delivers the following information:</p>
 * The display's panel temperature
 * The display's ambient temperature
 * The current temperature warning level
 * Timeout when warning level is switched from overheating to critical
 * Time the system is in warning level "critical"
 * <p>---</p>
 * <p>If you are only interested in the display's panel temperature then check property DIM_DISP_PanelTemperature</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to get the display and ambient temperature
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_TemperatureInfoGet;

/**
 * The upreg message of the property "DIM_DISP_TemperatureInfo"
 * <p>Read out the temperature information. This property delivers the following information:</p>
 * The display's panel temperature
 * The display's ambient temperature
 * The current temperature warning level
 * Timeout when warning level is switched from overheating to critical
 * Time the system is in warning level "critical"
 * <p>---</p>
 * <p>If you are only interested in the display's panel temperature then check property DIM_DISP_PanelTemperature</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_TemperatureInfoUpReg;

/**
 * The relUpReg message of the property "DIM_DISP_TemperatureInfo"
 * <p>Read out the temperature information. This property delivers the following information:</p>
 * The display's panel temperature
 * The display's ambient temperature
 * The current temperature warning level
 * Timeout when warning level is switched from overheating to critical
 * Time the system is in warning level "critical"
 * <p>---</p>
 * <p>If you are only interested in the display's panel temperature then check property DIM_DISP_PanelTemperature</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_TemperatureInfoRelUpReg;

/**
 * The get message of the property "DIM_DISP_Size"
 * <p>Retrieve the current display size
 * This information is based on the detected headunit.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to get the display size
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_SizeGet;

/**
 * The upreg message of the property "DIM_DISP_Size"
 * <p>Retrieve the current display size
 * This information is based on the detected headunit.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_SizeUpReg;

/**
 * The relUpReg message of the property "DIM_DISP_Size"
 * <p>Retrieve the current display size
 * This information is based on the detected headunit.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_SizeRelUpReg;

/**
 * The get message of the property "DIM_DISP_BrightnessLevel"
 * <p>Provides the current active display brightness level</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to request the current display brightness level
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_BrightnessLevelGet;

/**
 * The upreg message of the property "DIM_DISP_BrightnessLevel"
 * <p>Provides the current active display brightness level</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_BrightnessLevelUpReg;

/**
 * The relUpReg message of the property "DIM_DISP_BrightnessLevel"
 * <p>Provides the current active display brightness level</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_BrightnessLevelRelUpReg;

/**
 * The get message of the property "DIM_DISP_PanelTemperature"
 * <p>Read out the display's panel temperature</p>
 * <p>If you need all temperature information check DIM_DISP_TemperatureInfo</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to get the display's panel temperature
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_PanelTemperatureGet;

/**
 * The upreg message of the property "DIM_DISP_PanelTemperature"
 * <p>Read out the display's panel temperature</p>
 * <p>If you need all temperature information check DIM_DISP_TemperatureInfo</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_PanelTemperatureUpReg;

/**
 * The relUpReg message of the property "DIM_DISP_PanelTemperature"
 * <p>Read out the display's panel temperature</p>
 * <p>If you need all temperature information check DIM_DISP_TemperatureInfo</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_PanelTemperatureRelUpReg;

/**
 * The get message of the property "DIM_DISP_BrightnessLevelExtended"
 * <p>Provides the current active extended display brightness level</p>
 * <p>While the "normal" brightness level is limited to 5 levels this extended level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! Nissan LCN2Kai supports for example currently only the levels 0..18!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to request the current extended display brightness level
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_BrightnessLevelExtendedGet;

/**
 * The upreg message of the property "DIM_DISP_BrightnessLevelExtended"
 * <p>Provides the current active extended display brightness level</p>
 * <p>While the "normal" brightness level is limited to 5 levels this extended level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! Nissan LCN2Kai supports for example currently only the levels 0..18!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_BrightnessLevelExtendedUpReg;

/**
 * The relUpReg message of the property "DIM_DISP_BrightnessLevelExtended"
 * <p>Provides the current active extended display brightness level</p>
 * <p>While the "normal" brightness level is limited to 5 levels this extended level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! Nissan LCN2Kai supports for example currently only the levels 0..18!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_BrightnessLevelExtendedRelUpReg;

/**
 * The get message of the property "DIM_DISP_VideoBrightnessLevel"
 * <p>Provides the current active video brightness level</p>
 * <p>Valid values are 0..18 and 255!</p>
 * <p>---</p>
 * <p>Check the description of DIM_DISP_SetVideoBrightnessLevel for a more detailed explanation</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to request the current video brightness level
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_VideoBrightnessLevelGet;

/**
 * The upreg message of the property "DIM_DISP_VideoBrightnessLevel"
 * <p>Provides the current active video brightness level</p>
 * <p>Valid values are 0..18 and 255!</p>
 * <p>---</p>
 * <p>Check the description of DIM_DISP_SetVideoBrightnessLevel for a more detailed explanation</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_VideoBrightnessLevelUpReg;

/**
 * The relUpReg message of the property "DIM_DISP_VideoBrightnessLevel"
 * <p>Provides the current active video brightness level</p>
 * <p>Valid values are 0..18 and 255!</p>
 * <p>---</p>
 * <p>Check the description of DIM_DISP_SetVideoBrightnessLevel for a more detailed explanation</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_VideoBrightnessLevelRelUpReg;

/**
 * The get message of the property "DIM_DISP_ContrastLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use property DIM_DISP_CSCContrastLevel!</p>
 * <p>---</p>
 * <p>Provides the current active contrast level</p>
 * <p>Contrast level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to request the current extended display brightness level
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_ContrastLevelGet;

/**
 * The upreg message of the property "DIM_DISP_ContrastLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use property DIM_DISP_CSCContrastLevel!</p>
 * <p>---</p>
 * <p>Provides the current active contrast level</p>
 * <p>Contrast level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_ContrastLevelUpReg;

/**
 * The relUpReg message of the property "DIM_DISP_ContrastLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use property DIM_DISP_CSCContrastLevel!</p>
 * <p>---</p>
 * <p>Provides the current active contrast level</p>
 * <p>Contrast level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_ContrastLevelRelUpReg;

/**
 * The get message of the property "DIM_DISP_BlackLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use property DIM_DISP_CSCBlackLevel!</p>
 * <p>---</p>
 * <p>Provides the current active black level</p>
 * <p>Contrast level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to request the current extended display brightness level
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_BlackLevelGet;

/**
 * The upreg message of the property "DIM_DISP_BlackLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use property DIM_DISP_CSCBlackLevel!</p>
 * <p>---</p>
 * <p>Provides the current active black level</p>
 * <p>Contrast level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_BlackLevelUpReg;

/**
 * The relUpReg message of the property "DIM_DISP_BlackLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use property DIM_DISP_CSCBlackLevel!</p>
 * <p>---</p>
 * <p>Provides the current active black level</p>
 * <p>Contrast level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_BlackLevelRelUpReg;

/**
 * The get message of the property "DIM_DISP_YCurveLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use property DIM_DISP_CSCGammaLevel!</p>
 * <p>---</p>
 * <p>Provides the current active Y-Curve level</p>
 * <p>Y Curve level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to request the current extended display brightness level
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_YCurveLevelGet;

/**
 * The upreg message of the property "DIM_DISP_YCurveLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use property DIM_DISP_CSCGammaLevel!</p>
 * <p>---</p>
 * <p>Provides the current active Y-Curve level</p>
 * <p>Y Curve level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_YCurveLevelUpReg;

/**
 * The relUpReg message of the property "DIM_DISP_YCurveLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use property DIM_DISP_CSCGammaLevel!</p>
 * <p>---</p>
 * <p>Provides the current active Y-Curve level</p>
 * <p>Y Curve level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_YCurveLevelRelUpReg;

/**
 * The get message of the property "DIM_DISP_TintLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use property DIM_DISP_CSCSaturationLevel!</p>
 * <p>---</p>
 * <p>Provides the current active tint level</p>
 * <p>Tint level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to request the current extended display brightness level
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_TintLevelGet;

/**
 * The upreg message of the property "DIM_DISP_TintLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use property DIM_DISP_CSCSaturationLevel!</p>
 * <p>---</p>
 * <p>Provides the current active tint level</p>
 * <p>Tint level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_TintLevelUpReg;

/**
 * The relUpReg message of the property "DIM_DISP_TintLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use property DIM_DISP_CSCSaturationLevel!</p>
 * <p>---</p>
 * <p>Provides the current active tint level</p>
 * <p>Tint level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_TintLevelRelUpReg;

/**
 * The get message of the property "DIM_DISP_ColorLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use property DIM_DISP_CSCColorLevel!</p>
 * <p>---</p>
 * <p>Provides the current active color level</p>
 * <p>Color level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to request the current extended display brightness level
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_ColorLevelGet;

/**
 * The upreg message of the property "DIM_DISP_ColorLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use property DIM_DISP_CSCColorLevel!</p>
 * <p>---</p>
 * <p>Provides the current active color level</p>
 * <p>Color level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_ColorLevelUpReg;

/**
 * The relUpReg message of the property "DIM_DISP_ColorLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use property DIM_DISP_CSCColorLevel!</p>
 * <p>---</p>
 * <p>Provides the current active color level</p>
 * <p>Color level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_ColorLevelRelUpReg;

/**
 * The get message of the property "DIM_DISP_DAY_LUMINOSITY_OFFSET"
 * <p>Provides the current active display brightness level for Day from HMI</p>
 * <p>Available starting with FI 3.0!</p>
 * Message to request the current extended display brightness level
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_DAY_LUMINOSITY_OFFSETGet;

/**
 * The upreg message of the property "DIM_DISP_DAY_LUMINOSITY_OFFSET"
 * <p>Provides the current active display brightness level for Day from HMI</p>
 * <p>Available starting with FI 3.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_DAY_LUMINOSITY_OFFSETUpReg;

/**
 * The relUpReg message of the property "DIM_DISP_DAY_LUMINOSITY_OFFSET"
 * <p>Provides the current active display brightness level for Day from HMI</p>
 * <p>Available starting with FI 3.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_DAY_LUMINOSITY_OFFSETRelUpReg;

/**
 * The get message of the property "DIM_DISP_NIGHT_LUMINOSITY_OFFSET"
 * <p>Provides the current active display brightness level for Night from HMI</p>
 * <p>Available starting with FI 3.0!</p>
 * Message to request the current extended display brightness level
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_NIGHT_LUMINOSITY_OFFSETGet;

/**
 * The upreg message of the property "DIM_DISP_NIGHT_LUMINOSITY_OFFSET"
 * <p>Provides the current active display brightness level for Night from HMI</p>
 * <p>Available starting with FI 3.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_NIGHT_LUMINOSITY_OFFSETUpReg;

/**
 * The relUpReg message of the property "DIM_DISP_NIGHT_LUMINOSITY_OFFSET"
 * <p>Provides the current active display brightness level for Night from HMI</p>
 * <p>Available starting with FI 3.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_NIGHT_LUMINOSITY_OFFSETRelUpReg;

/**
 * The get message of the property "DIM_DISP_COCKPIT_SLIDER_OFFSET"
 * <p>Provides the current offset for the Cockpit Dimming Slider which is enabled when A-IVI is the master level</p>
 * <p>Available starting with FI 3.0!</p>
 * Message to request the current extended display brightness level
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_COCKPIT_SLIDER_OFFSETGet;

/**
 * The upreg message of the property "DIM_DISP_COCKPIT_SLIDER_OFFSET"
 * <p>Provides the current offset for the Cockpit Dimming Slider which is enabled when A-IVI is the master level</p>
 * <p>Available starting with FI 3.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_COCKPIT_SLIDER_OFFSETUpReg;

/**
 * The relUpReg message of the property "DIM_DISP_COCKPIT_SLIDER_OFFSET"
 * <p>Provides the current offset for the Cockpit Dimming Slider which is enabled when A-IVI is the master level</p>
 * <p>Available starting with FI 3.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_COCKPIT_SLIDER_OFFSETRelUpReg;

/**
 * The get message of the property "DIM_DIAG_Variant"
 * <p>Retrieve the current HW variant</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to get the hardware variant
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DIAG_VariantGet;

/**
 * The upreg message of the property "DIM_DIAG_Variant"
 * <p>Retrieve the current HW variant</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DIAG_VariantUpReg;

/**
 * The relUpReg message of the property "DIM_DIAG_Variant"
 * <p>Retrieve the current HW variant</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DIAG_VariantRelUpReg;

/**
 * The get message of the property "DIM_DIAG_BrightnessInputType"
 * <p>Retrieve the current Brightness Input Type</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 * Message to get the brightness input type configuration
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DIAG_BrightnessInputTypeGet;

/**
 * The upreg message of the property "DIM_DIAG_BrightnessInputType"
 * <p>Retrieve the current Brightness Input Type</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DIAG_BrightnessInputTypeUpReg;

/**
 * The relUpReg message of the property "DIM_DIAG_BrightnessInputType"
 * <p>Retrieve the current Brightness Input Type</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DIAG_BrightnessInputTypeRelUpReg;

/**
 * The get message of the property "DIM_DISP_CSCContrastLevel"
 * <p>Provides the current active contrast level of color space conversion.</p>
 * <p>Contrast level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 * Message to request the current extended contrast level
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_CSCContrastLevelGet;

/**
 * The upreg message of the property "DIM_DISP_CSCContrastLevel"
 * <p>Provides the current active contrast level of color space conversion.</p>
 * <p>Contrast level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_CSCContrastLevelUpReg;

/**
 * The relUpReg message of the property "DIM_DISP_CSCContrastLevel"
 * <p>Provides the current active contrast level of color space conversion.</p>
 * <p>Contrast level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_CSCContrastLevelRelUpReg;

/**
 * The get message of the property "DIM_DISP_CSCBlackLevel"
 * <p>Provides the current active black level of color space conversion.</p>
 * <p>Contrast level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 * Message to request the current extended black level
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_CSCBlackLevelGet;

/**
 * The upreg message of the property "DIM_DISP_CSCBlackLevel"
 * <p>Provides the current active black level of color space conversion.</p>
 * <p>Contrast level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_CSCBlackLevelUpReg;

/**
 * The relUpReg message of the property "DIM_DISP_CSCBlackLevel"
 * <p>Provides the current active black level of color space conversion.</p>
 * <p>Contrast level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_CSCBlackLevelRelUpReg;

/**
 * The get message of the property "DIM_DISP_CSCGammaLevel"
 * <p>Provides the current active gamma adjustment level of color space conversion.</p>
 * <p>Gamma adjustment level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 * Message to request the current extended gamma adjustment level
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_CSCGammaLevelGet;

/**
 * The upreg message of the property "DIM_DISP_CSCGammaLevel"
 * <p>Provides the current active gamma adjustment level of color space conversion.</p>
 * <p>Gamma adjustment level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_CSCGammaLevelUpReg;

/**
 * The relUpReg message of the property "DIM_DISP_CSCGammaLevel"
 * <p>Provides the current active gamma adjustment level of color space conversion.</p>
 * <p>Gamma adjustment level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_CSCGammaLevelRelUpReg;

/**
 * The get message of the property "DIM_DISP_CSCSaturationLevel"
 * <p>Provides the current active tint level of color space conversion.</p>
 * <p>Saturation level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 * Message to request the current extended saturation level
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_CSCSaturationLevelGet;

/**
 * The upreg message of the property "DIM_DISP_CSCSaturationLevel"
 * <p>Provides the current active tint level of color space conversion.</p>
 * <p>Saturation level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_CSCSaturationLevelUpReg;

/**
 * The relUpReg message of the property "DIM_DISP_CSCSaturationLevel"
 * <p>Provides the current active tint level of color space conversion.</p>
 * <p>Saturation level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_CSCSaturationLevelRelUpReg;

/**
 * The get message of the property "DIM_DISP_CSCColorLevel"
 * <p>Provides the current active color level</p>
 * <p>Color level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 * Message to request the current extended color level
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_CSCColorLevelGet;

/**
 * The upreg message of the property "DIM_DISP_CSCColorLevel"
 * <p>Provides the current active color level</p>
 * <p>Color level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_CSCColorLevelUpReg;

/**
 * The relUpReg message of the property "DIM_DISP_CSCColorLevel"
 * <p>Provides the current active color level</p>
 * <p>Color level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_DISP_CSCColorLevelRelUpReg;

/**
 * The get message of the property "DIM_SECOND_DISP_AllDisplayParam"
 * PIVI Second Screen All Display Parametwrs like Blacklevel, Brightness, color, tint, Gamma Level etc.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_SECOND_DISP_AllDisplayParamGet;

/**
 * The upreg message of the property "DIM_SECOND_DISP_AllDisplayParam"
 * PIVI Second Screen All Display Parametwrs like Blacklevel, Brightness, color, tint, Gamma Level etc.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_SECOND_DISP_AllDisplayParamUpReg;

/**
 * The relUpReg message of the property "DIM_SECOND_DISP_AllDisplayParam"
 * PIVI Second Screen All Display Parametwrs like Blacklevel, Brightness, color, tint, Gamma Level etc.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_SECOND_DISP_AllDisplayParamRelUpReg;

/**
 * The error message of 'DIM_SECOND_DISP_AllDisplayParam'
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_SECOND_DISP_AllDisplayParamError;

/**
 * The get message of the property "DIM_SECOND_DISP_SelfDiagnosisResult"
 * PIVI Second Screen get from V850.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_SECOND_DISP_SelfDiagnosisResultGet;

/**
 * The upreg message of the property "DIM_SECOND_DISP_SelfDiagnosisResult"
 * PIVI Second Screen get from V850.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_SECOND_DISP_SelfDiagnosisResultUpReg;

/**
 * The relUpReg message of the property "DIM_SECOND_DISP_SelfDiagnosisResult"
 * PIVI Second Screen get from V850.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_SECOND_DISP_SelfDiagnosisResultRelUpReg;

/**
 * The error message of 'DIM_SECOND_DISP_SelfDiagnosisResult'
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_SECOND_DISP_SelfDiagnosisResultError;

/**
 * The abort error message of the method "FI_VD_DIMMING_DEFAULT"
 * <p>VD_Dimming has to support a default setting. This is the Functional Interface for this.</p>
 * <p>Attention:</p>
 * <p>In FI V1.0 FI "DefSetStateGroup" is of type="T_e8_DefSetGroups"!</p>
 * <p>In FI V1.0 FI "DefSetStateMode"  is of type="T_e8_DefSetMode"!</p>
 * <p>Both types are replaced by an tU8 to get rid of all the diag-types in this FI document starting with V2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError FI_VD_DIMMING_DEFAULTAbortError;

/**
 * The error message of 'FI_VD_DIMMING_DEFAULT'
 */
typedef ::asf::cca::CcaTypes::DefaultError FI_VD_DIMMING_DEFAULTError;

/**
 * The abort error message of the method "DIM_INFO_SetDimmingMode"
 * <p>Set the dimming mode configuration.</p>
 * <p>The corresponding property is "DIM_DimmingMode".</p>
 * <p>Switch the dimming mode to:</p>
 * Off   = No dimming table used
 * Day   = Dimming table for "day" is used
 * Night = Dimming table for "night" is used
 * Auto  = Depending on the information received from the car either "day" or "night" table is used
 * <p>Currently this behavior is only relevant for display dimming but in future or for different customers this can be also relevant for keyboard.
 * This method is normally called by HMI. In case it is set to "AUTO" then the property value will be based on DIM_INFO_CarIlluminationData.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_INFO_SetDimmingModeAbortError;

/**
 * The abort error message of the method "DIM_INFO_SetEmulationMode"
 * <p>Switch to emulation mode. If this value is set to "setup" or "verify" then the VD_Dimming
 * server will not react on the normal external inputs any longer, instead all triggers via
 * TTFIS and Diagnosis are used to change dimming and illumination.</p>
 * <p>In "verify" mode all internal compensation tables are active in "setup" those tables are
 * inactive to do some unaltered measurements.</p>
 * <p>Possible other modes are "KeybFreeze" and "DispFreeze". This is specialized "verify" mode to
 * check given input values and their output for keyboard or for display.</p>
 * <p>On activation the VD_Dimming will store its current values and will retrieve them
 * once the DiagMode is set to "Off"</p>
 * <p>If the DiagMode mode is switched to "Off" again the external triggers are again
 * used for controlling the dimming/illumination of the keyboard</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_INFO_SetEmulationModeAbortError;

/**
 * The abort error message of the method "DIM_INFO_SetDimmingState"
 * <p>Activate or deactivate the illumination for a specific LUN</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_INFO_SetDimmingStateAbortError;

/**
 * The abort error message of the method "DIM_INFO_GetDimmingState"
 * <p>Retrieves the Dimming state of a specific LUN</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_INFO_GetDimmingStateAbortError;

/**
 * The abort error message of the method "DIM_INFO_SetDimmingBrightness"
 * <p>Set the dimming value (in permille) for a specific LUN</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_INFO_SetDimmingBrightnessAbortError;

/**
 * The abort error message of the method "DIM_INFO_GetDimmingBrightness"
 * <p>Get the dimming value (in permille) for a specific LUN</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_INFO_GetDimmingBrightnessAbortError;

/**
 * The start message of the method "DIM_INFO_GetPWMBrightness"
 * <p>Get the dimming value (in permille) for wire PWM input</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_INFO_GetPWMBrightnessStart;

/**
 * The abort error message of the method "DIM_INFO_GetPWMBrightness"
 * <p>Get the dimming value (in permille) for wire PWM input</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_INFO_GetPWMBrightnessAbortError;

/**
 * The abort error message of the method "DIM_KEYB_SetDimming"
 * <p>Sets the dimming brightness for the keyboard.
 * If brightness is set to "0%" then dimming/illumination of the keyboard is switched to "off"
 * This method is identical to DIM_SetDimmingBrightness and DIM_SetDimmingState if called for all LUNs except 0.
 * It is introduced for a much easier handling.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_KEYB_SetDimmingAbortError;

/**
 * The abort error message of the method "DIM_KEYB_SetDimmingPWM"
 * <p>Sets the PWM dimming brightness for the keyboard. This is an adjustment value.
 * If brightness is set to "0%" then dimming/illumination of the keyboard is switched to "off"</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_KEYB_SetDimmingPWMAbortError;

/**
 * The abort error message of the method "DIM_DISP_SetDriverInitalized"
 * <p>Used to set the initialization status of the display driver.
 * This is used by VD_Dimming to determine the backlight status</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_DISP_SetDriverInitalizedAbortError;

/**
 * The abort error message of the method "DIM_DISP_SetScreenContentAvailable"
 * <p>Used to set the availablity of screen content.
 * The availability of screen content is necessary for VD_Dimming to activate the backlight.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_DISP_SetScreenContentAvailableAbortError;

/**
 * The abort error message of the method "DIM_DISP_SetDimming"
 * <p>Set dimming value for display</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_DISP_SetDimmingAbortError;

/**
 * The abort error message of the method "DIM_DISP_SwitchBacklight"
 * <p>Switches the backlight of the display on or off.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_DISP_SwitchBacklightAbortError;

/**
 * The abort error message of the method "DIM_DISP_SetBrightnessLevel"
 * <p>Sets the brightness level of the display to one of the defined levels</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_DISP_SetBrightnessLevelAbortError;

/**
 * The abort error message of the method "DIM_DISP_SetBrightnessLevelExtended"
 * <p>Sets the brightness level of the display to a specific level</p>
 * <p>While the "normal" brightness level is limited to 5 levels this extended level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! Nissan LCN2Kai supports for example currently only the levels 0..18!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_DISP_SetBrightnessLevelExtendedAbortError;

/**
 * The abort error message of the method "DIM_DISP_SetVideoBrightnessLevel"
 * <p>This is a special functionality first introduced for Nissan LCN2Kai</p>
 * <p>While calling this method the dimming component will activate or deactivate a special video mode</p>
 * <p>By activating this video mode the display brightness level can be set to a different value independent from HMI and without storing the value in persistent memory</p>
 * <p>Main purpose is to have the option to change the brightness of the display backlight if a video layer is displayed</p>
 * <p>---</p>
 * <p>Remember: This changes the backlight of the display and NOT the brightness of the video layer itself. So it influences the complete screen content and not only the video layer!</p>
 * <p>---</p>
 * <p>The behaviour is very similar to DIM_DISP_SetBrightnessLevelExtended with the following modifications:</p>
 * <p>(1) the range of the brightness level is 0..18, this sets the brightness level and changes into video mode and the current DIM_Disp_BrightnessLevelExtended values are "freezed"</p>
 * <p>(2) brightness level for day and night can be set at the same time, the dimming component will use the each of the values if DimmingMode changes</p>
 * <p>(3) if the method is called with value 255 (at least for one of the parameters) then the video mode is left and the "freezed" DIM_Disp_BrightnessLevelExtended are restored</p>
 * <p>(4) because of the freezed values the HMI will not notice any changes made through this method in the property DIM_DispBrightnesseLevelExtended</p>
 * <p>(5) the video brightness level values are not stored in persistent memory</p>
 * <p>(6) the video mode is always left on startup or shutdown of the dimming component</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_DISP_SetVideoBrightnessLevelAbortError;

/**
 * The abort error message of the method "DIM_DISP_SetContrastLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use method DIM_DISP_SetCSCContrastLevel!</p>
 * <p>---</p>
 * <p>Sets the contrast level of the display to a specific level</p>
 * <p>Contrast level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_DISP_SetContrastLevelAbortError;

/**
 * The abort error message of the method "DIM_DISP_SetBlackLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use method DIM_DISP_SetCSCBlackLevel!</p>
 * <p>---</p>
 * <p>Sets the black level of the display to a specific level</p>
 * <p>Black level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_DISP_SetBlackLevelAbortError;

/**
 * The abort error message of the method "DIM_DISP_SetYCurveLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use method DIM_DISP_SetCSCGammaLevel!</p>
 * <p>---</p>
 * <p>Sets the YCurve level of the display to a specific level</p>
 * <p>YCurve level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_DISP_SetYCurveLevelAbortError;

/**
 * The abort error message of the method "DIM_DISP_SetTintLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use method DIM_DISP_SetCSCSaturationLevel!</p>
 * <p>---</p>
 * <p>Sets the tint level of the display to a specific level</p>
 * <p>Tint level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_DISP_SetTintLevelAbortError;

/**
 * The abort error message of the method "DIM_DISP_SetColorLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use method DIM_DISP_SetCSCColorLevel!</p>
 * <p>---</p>
 * <p>Sets the Color level of the display to a specific level</p>
 * <p>Color level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_DISP_SetColorLevelAbortError;

/**
 * The abort error message of the method "DIM_DIAG_SetBrightnessInputType"
 * <p>Set the current brightness input type configuration</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_DIAG_SetBrightnessInputTypeAbortError;

/**
 * The abort error message of the method "DIM_DISP_SetCSCContrastLevel"
 * <p>Sets the contrast level of the display to a specific level of color space conversion.</p>
 * <p>Contrast level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_DISP_SetCSCContrastLevelAbortError;

/**
 * The abort error message of the method "DIM_DISP_SetCSCBlackLevel"
 * <p>Sets the black level of the display to a specific level of color space conversion.</p>
 * <p>Black level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_DISP_SetCSCBlackLevelAbortError;

/**
 * The abort error message of the method "DIM_DISP_SetCSCGammaLevel"
 * <p>Sets the gamma adjustment level of the display to a specific level of color space conversion.</p>
 * <p>YCurve level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_DISP_SetCSCGammaLevelAbortError;

/**
 * The abort error message of the method "DIM_DISP_SetCSCSaturationLevel"
 * <p>Sets the saturation level of the display to a specific level of color space conversion.</p>
 * <p>Tint level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_DISP_SetCSCSaturationLevelAbortError;

/**
 * The abort error message of the method "DIM_DISP_SetCSCColorLevel"
 * <p>Sets the Color level of the display to a specific level of color space conversion.</p>
 * <p>Color level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_DISP_SetCSCColorLevelAbortError;

/**
 * The abort error message of the method "DIM_SECOND_DISP_SetDispParameter"
 * <p>Sets the different Dimming Parameters for Second Disp;ay depending on Function ID and Value.</p>
 * <p>Available starting with FI 4.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_SECOND_DISP_SetDispParameterAbortError;

/**
 * The abort error message of the method "DIM_SECOND_DISP_SetDispOnOff"
 * <p>Sets Second Display on or Off depending on value provided by client 0 - OFF and 1 - ON</p>
 * <p>Available starting with FI 4.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_SECOND_DISP_SetDispOnOffAbortError;

/**
 * The start message of the method "DIM_SECOND_DISP_HardwareVersion"
 * <p>Method to request Hardware Version</p>
 * <p>Available starting with FI 4.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_SECOND_DISP_HardwareVersionStart;

/**
 * The abort error message of the method "DIM_SECOND_DISP_HardwareVersion"
 * <p>Method to request Hardware Version</p>
 * <p>Available starting with FI 4.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_SECOND_DISP_HardwareVersionAbortError;

/**
 * The start message of the method "DIM_SECOND_DISP_SoftwareVersion"
 * <p>Method to request Software Version</p>
 * <p>Available starting with FI 4.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_SECOND_DISP_SoftwareVersionStart;

/**
 * The abort error message of the method "DIM_SECOND_DISP_SoftwareVersion"
 * <p>Method to request Software Version</p>
 * <p>Available starting with FI 4.0!</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_SECOND_DISP_SoftwareVersionAbortError;

/**
 * The start message of the method "DIM_SECOND_DISP_GetALLParam"
 * <p>Available starting with FI 4.0!</p>
 * <p>Method to request All Dimming param for 2nd display , which HMI shall call whenever they enter Display Settings Screen</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_SECOND_DISP_GetALLParamStart;

/**
 * The result message of the method "DIM_SECOND_DISP_GetALLParam"
 * <p>Available starting with FI 4.0!</p>
 * <p>Method to request All Dimming param for 2nd display , which HMI shall call whenever they enter Display Settings Screen</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DIM_SECOND_DISP_GetALLParamResult;

/**
 * The abort error message of the method "DIM_SECOND_DISP_GetALLParam"
 * <p>Available starting with FI 4.0!</p>
 * <p>Method to request All Dimming param for 2nd display , which HMI shall call whenever they enter Display Settings Screen</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_SECOND_DISP_GetALLParamAbortError;

/**
 * The error message of 'DIM_SECOND_DISP_GetALLParam'
 */
typedef ::asf::cca::CcaTypes::DefaultError DIM_SECOND_DISP_GetALLParamError;


/**
 * The status message of the property "DIM_INFO_CarIlluminationData"
 * <p>Provides the current status of the car's illumination switch and illumination value</p>
 * <p>These are the input values received from the car!
 * The values are being evaluated (together with other parameters) by VD_Dimming to determine
 * the current brightness and illumination settings.
 * These values are not to be mixed up with the current active brightness and illumination values of the headunit!
 * The car illumination brightness is either based on a PWM value or on a CAN value.
 * This depends on the setting of DIM_DIAG_BrightnessInputType.
 * If you want to know the current PWM-input or CAN-input values please check the corresponding properties.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_INFO_CarIlluminationDataStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_CarIlluminationDataStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_CarIlluminationDataStatus (const DIM_INFO_CarIlluminationDataStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_CarIlluminationDataStatus (::dimming_main_fi_types::T_e8_DIM_Status IlluminationSwitch_, ::dimming_main_fi_types::T_u16_DIM_Permille IlluminationBrightness_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_CarIlluminationDataStatus();

    /**
     * Assignment operator
     */
    inline DIM_INFO_CarIlluminationDataStatus& operator = (const DIM_INFO_CarIlluminationDataStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_CarIlluminationDataStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_CarIlluminationDataStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_CarIlluminationDataStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_CarIlluminationDataStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IlluminationSwitch"

    static const int kIlluminationSwitch = 0;

    /**
     * Clears the field "IlluminationSwitch".
     *
     * The field will be set to its default value. The hasIlluminationSwitch()
     * method will return false.
     */
    inline void clearIlluminationSwitch();

    /**
     * Checks whether the field "IlluminationSwitch" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIlluminationSwitch()). Otherwise it will return false.
     */
    inline bool hasIlluminationSwitch () const;

    /**
     * Returns the value of the member "IlluminationSwitch".
     *
     * Provides the current status of the car's illumination switch
     *
     * @return The value of the field "IlluminationSwitch"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_Status getIlluminationSwitch () const;

    /**
     * Sets the value of the member "IlluminationSwitch".
     *
     * Provides the current status of the car's illumination switch
     *
     * @param IlluminationSwitch The value which will be set
     */
    inline void setIlluminationSwitch (::dimming_main_fi_types::T_e8_DIM_Status IlluminationSwitch_);

    // API of field "IlluminationBrightness"

    static const int kIlluminationBrightness = 1;

    /**
     * Clears the field "IlluminationBrightness".
     *
     * The field will be set to its default value. The hasIlluminationBrightness()
     * method will return false.
     */
    inline void clearIlluminationBrightness();

    /**
     * Checks whether the field "IlluminationBrightness" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIlluminationBrightness()). Otherwise it will return false.
     */
    inline bool hasIlluminationBrightness () const;

    /**
     * Returns the value of the member "IlluminationBrightness".
     *
     * Provides the current status of the car's illumination brightness
     *
     * @return The value of the field "IlluminationBrightness"
     */
    inline ::dimming_main_fi_types::T_u16_DIM_Permille getIlluminationBrightness () const;

    /**
     * Sets the value of the member "IlluminationBrightness".
     *
     * Provides the current status of the car's illumination brightness
     *
     * @param IlluminationBrightness The value which will be set
     */
    inline void setIlluminationBrightness (::dimming_main_fi_types::T_u16_DIM_Permille IlluminationBrightness_);

    static const DIM_INFO_CarIlluminationDataStatus &getDefaultInstance();

private:

    inline void set_has_IlluminationSwitch ();

    inline void clear_has_IlluminationSwitch ();

    inline void set_has_IlluminationBrightness ();

    inline void clear_has_IlluminationBrightness ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::dimming_main_fi_types::T_e8_DIM_Status _IlluminationSwitch;

    ::dimming_main_fi_types::T_u16_DIM_Permille _IlluminationBrightness;

};

/**
 * The error message of 'DIM_INFO_CarIlluminationData'
 */
class DIM_INFO_CarIlluminationDataErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_CarIlluminationDataErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_CarIlluminationDataErrorStructure (const DIM_INFO_CarIlluminationDataErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_CarIlluminationDataErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_INFO_CarIlluminationDataErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_INFO_CarIlluminationDataErrorStructure& operator = (const DIM_INFO_CarIlluminationDataErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_CarIlluminationDataErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_CarIlluminationDataErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_CarIlluminationDataErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_CarIlluminationDataErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_INFO_CarIlluminationDataErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_INFO_CarIlluminationData'
 */
class DIM_INFO_CarIlluminationDataError  : public ::asf::core::Payload {
public:

    enum DIM_INFO_CarIlluminationDataErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_INFO_CarIlluminationDataError ();

   /**
     * Copy constructor
     */
    inline  DIM_INFO_CarIlluminationDataError (const DIM_INFO_CarIlluminationDataError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_CarIlluminationDataError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_INFO_CarIlluminationDataError& operator = (const DIM_INFO_CarIlluminationDataError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_CarIlluminationDataError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_CarIlluminationDataError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_CarIlluminationDataError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_CarIlluminationDataError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_INFO_CarIlluminationDataError::DIM_INFO_CarIlluminationDataErrorField getField () const;

    inline void setField(DIM_INFO_CarIlluminationDataError::DIM_INFO_CarIlluminationDataErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_INFO_CarIlluminationDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_INFO_CarIlluminationDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_INFO_CarIlluminationDataErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_INFO_CarIlluminationDataErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_INFO_CarIlluminationDataErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_INFO_CarIlluminationDataErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_INFO_CarIlluminationDataErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_INFO_CarIlluminationDataErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_INFO_CarIlluminationDataError &getDefaultInstance();

private:

    inline void cloneData (const DIM_INFO_CarIlluminationDataError& rhs);

    inline void deleteData ();

    DIM_INFO_CarIlluminationDataErrorField __field;

    union {
        DIM_INFO_CarIlluminationDataErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_INFO_LightSensorBrightness"
 * <p>Provides the current status and value of the car's light sensor (if available)</p>
 * <p>Currently without further functionality, reserved for future use</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_INFO_LightSensorBrightnessStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_LightSensorBrightnessStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_LightSensorBrightnessStatus (const DIM_INFO_LightSensorBrightnessStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_LightSensorBrightnessStatus (::dimming_main_fi_types::T_e8_DIM_Status SensorAvail_, ::dimming_main_fi_types::T_u16_DIM_Permille SensorBrightness_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_LightSensorBrightnessStatus();

    /**
     * Assignment operator
     */
    inline DIM_INFO_LightSensorBrightnessStatus& operator = (const DIM_INFO_LightSensorBrightnessStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_LightSensorBrightnessStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_LightSensorBrightnessStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_LightSensorBrightnessStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_LightSensorBrightnessStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SensorAvail"

    static const int kSensorAvail = 0;

    /**
     * Clears the field "SensorAvail".
     *
     * The field will be set to its default value. The hasSensorAvail()
     * method will return false.
     */
    inline void clearSensorAvail();

    /**
     * Checks whether the field "SensorAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSensorAvail()). Otherwise it will return false.
     */
    inline bool hasSensorAvail () const;

    /**
     * Returns the value of the member "SensorAvail".
     *
     * Provides the current status of the lightsensor
     *
     * @return The value of the field "SensorAvail"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_Status getSensorAvail () const;

    /**
     * Sets the value of the member "SensorAvail".
     *
     * Provides the current status of the lightsensor
     *
     * @param SensorAvail The value which will be set
     */
    inline void setSensorAvail (::dimming_main_fi_types::T_e8_DIM_Status SensorAvail_);

    // API of field "SensorBrightness"

    static const int kSensorBrightness = 1;

    /**
     * Clears the field "SensorBrightness".
     *
     * The field will be set to its default value. The hasSensorBrightness()
     * method will return false.
     */
    inline void clearSensorBrightness();

    /**
     * Checks whether the field "SensorBrightness" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSensorBrightness()). Otherwise it will return false.
     */
    inline bool hasSensorBrightness () const;

    /**
     * Returns the value of the member "SensorBrightness".
     *
     * Provides the current value of the car's light sensor value
     *
     * @return The value of the field "SensorBrightness"
     */
    inline ::dimming_main_fi_types::T_u16_DIM_Permille getSensorBrightness () const;

    /**
     * Sets the value of the member "SensorBrightness".
     *
     * Provides the current value of the car's light sensor value
     *
     * @param SensorBrightness The value which will be set
     */
    inline void setSensorBrightness (::dimming_main_fi_types::T_u16_DIM_Permille SensorBrightness_);

    static const DIM_INFO_LightSensorBrightnessStatus &getDefaultInstance();

private:

    inline void set_has_SensorAvail ();

    inline void clear_has_SensorAvail ();

    inline void set_has_SensorBrightness ();

    inline void clear_has_SensorBrightness ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::dimming_main_fi_types::T_e8_DIM_Status _SensorAvail;

    ::dimming_main_fi_types::T_u16_DIM_Permille _SensorBrightness;

};

/**
 * The error message of 'DIM_INFO_LightSensorBrightness'
 */
class DIM_INFO_LightSensorBrightnessErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_LightSensorBrightnessErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_LightSensorBrightnessErrorStructure (const DIM_INFO_LightSensorBrightnessErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_LightSensorBrightnessErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_INFO_LightSensorBrightnessErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_INFO_LightSensorBrightnessErrorStructure& operator = (const DIM_INFO_LightSensorBrightnessErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_LightSensorBrightnessErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_LightSensorBrightnessErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_LightSensorBrightnessErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_LightSensorBrightnessErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_INFO_LightSensorBrightnessErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_INFO_LightSensorBrightness'
 */
class DIM_INFO_LightSensorBrightnessError  : public ::asf::core::Payload {
public:

    enum DIM_INFO_LightSensorBrightnessErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_INFO_LightSensorBrightnessError ();

   /**
     * Copy constructor
     */
    inline  DIM_INFO_LightSensorBrightnessError (const DIM_INFO_LightSensorBrightnessError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_LightSensorBrightnessError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_INFO_LightSensorBrightnessError& operator = (const DIM_INFO_LightSensorBrightnessError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_LightSensorBrightnessError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_LightSensorBrightnessError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_LightSensorBrightnessError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_LightSensorBrightnessError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_INFO_LightSensorBrightnessError::DIM_INFO_LightSensorBrightnessErrorField getField () const;

    inline void setField(DIM_INFO_LightSensorBrightnessError::DIM_INFO_LightSensorBrightnessErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_INFO_LightSensorBrightnessErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_INFO_LightSensorBrightnessErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_INFO_LightSensorBrightnessErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_INFO_LightSensorBrightnessErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_INFO_LightSensorBrightnessErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_INFO_LightSensorBrightnessErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_INFO_LightSensorBrightnessErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_INFO_LightSensorBrightnessErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_INFO_LightSensorBrightnessError &getDefaultInstance();

private:

    inline void cloneData (const DIM_INFO_LightSensorBrightnessError& rhs);

    inline void deleteData ();

    DIM_INFO_LightSensorBrightnessErrorField __field;

    union {
        DIM_INFO_LightSensorBrightnessErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_INFO_DimmingMode"
 * <p>Provides the current configuration and status of the dimming mode (evaluated and received from car).
 * The status of the dimming mode depends on the configured dimming mode and the car's dimming mode.
 * Currently this information is only relevant for display dimming but in future or for different
 * customers this can also be relevant for keyboard.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_INFO_DimmingModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_DimmingModeStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_DimmingModeStatus (const DIM_INFO_DimmingModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_DimmingModeStatus (::dimming_main_fi_types::T_e8_DIM_Mode Config_, ::dimming_main_fi_types::T_e8_DIM_Mode Car_, ::dimming_main_fi_types::T_e8_DIM_Mode Status_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_DimmingModeStatus();

    /**
     * Assignment operator
     */
    inline DIM_INFO_DimmingModeStatus& operator = (const DIM_INFO_DimmingModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_DimmingModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_DimmingModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_DimmingModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_DimmingModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Config"

    static const int kConfig = 0;

    /**
     * Clears the field "Config".
     *
     * The field will be set to its default value. The hasConfig()
     * method will return false.
     */
    inline void clearConfig();

    /**
     * Checks whether the field "Config" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfig()). Otherwise it will return false.
     */
    inline bool hasConfig () const;

    /**
     * Returns the value of the member "Config".
     *
     * Provides the current configuration of the dimming mode
     * In case of "Auto" the evaluated status depends on the dimming mode reported by the car!
     *
     * @return The value of the field "Config"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_Mode getConfig () const;

    /**
     * Sets the value of the member "Config".
     *
     * Provides the current configuration of the dimming mode
     * In case of "Auto" the evaluated status depends on the dimming mode reported by the car!
     *
     * @param Config The value which will be set
     */
    inline void setConfig (::dimming_main_fi_types::T_e8_DIM_Mode Config_);

    // API of field "Car"

    static const int kCar = 1;

    /**
     * Clears the field "Car".
     *
     * The field will be set to its default value. The hasCar()
     * method will return false.
     */
    inline void clearCar();

    /**
     * Checks whether the field "Car" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCar()). Otherwise it will return false.
     */
    inline bool hasCar () const;

    /**
     * Returns the value of the member "Car".
     *
     * Provides the current received dimming mode from the car.
     *
     * @return The value of the field "Car"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_Mode getCar () const;

    /**
     * Sets the value of the member "Car".
     *
     * Provides the current received dimming mode from the car.
     *
     * @param Car The value which will be set
     */
    inline void setCar (::dimming_main_fi_types::T_e8_DIM_Mode Car_);

    // API of field "Status"

    static const int kStatus = 2;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Provides the current evaluated status of the dimming mode.
     *
     * @return The value of the field "Status"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_Mode getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Provides the current evaluated status of the dimming mode.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::dimming_main_fi_types::T_e8_DIM_Mode Status_);

    static const DIM_INFO_DimmingModeStatus &getDefaultInstance();

private:

    inline void set_has_Config ();

    inline void clear_has_Config ();

    inline void set_has_Car ();

    inline void clear_has_Car ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::dimming_main_fi_types::T_e8_DIM_Mode _Config;

    ::dimming_main_fi_types::T_e8_DIM_Mode _Car;

    ::dimming_main_fi_types::T_e8_DIM_Mode _Status;

};

/**
 * The error message of 'DIM_INFO_DimmingMode'
 */
class DIM_INFO_DimmingModeErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_DimmingModeErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_DimmingModeErrorStructure (const DIM_INFO_DimmingModeErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_DimmingModeErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_INFO_DimmingModeErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_INFO_DimmingModeErrorStructure& operator = (const DIM_INFO_DimmingModeErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_DimmingModeErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_DimmingModeErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_DimmingModeErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_DimmingModeErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_INFO_DimmingModeErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_INFO_DimmingMode'
 */
class DIM_INFO_DimmingModeError  : public ::asf::core::Payload {
public:

    enum DIM_INFO_DimmingModeErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_INFO_DimmingModeError ();

   /**
     * Copy constructor
     */
    inline  DIM_INFO_DimmingModeError (const DIM_INFO_DimmingModeError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_DimmingModeError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_INFO_DimmingModeError& operator = (const DIM_INFO_DimmingModeError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_DimmingModeError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_DimmingModeError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_DimmingModeError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_DimmingModeError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_INFO_DimmingModeError::DIM_INFO_DimmingModeErrorField getField () const;

    inline void setField(DIM_INFO_DimmingModeError::DIM_INFO_DimmingModeErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_INFO_DimmingModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_INFO_DimmingModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_INFO_DimmingModeErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_INFO_DimmingModeErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_INFO_DimmingModeErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_INFO_DimmingModeErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_INFO_DimmingModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_INFO_DimmingModeErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_INFO_DimmingModeError &getDefaultInstance();

private:

    inline void cloneData (const DIM_INFO_DimmingModeError& rhs);

    inline void deleteData ();

    DIM_INFO_DimmingModeErrorField __field;

    union {
        DIM_INFO_DimmingModeErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_INFO_EmulationMode"
 * <p>Provides the current status of the EmulationMode</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_INFO_EmulationModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_EmulationModeStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_EmulationModeStatus (const DIM_INFO_EmulationModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_EmulationModeStatus (::dimming_main_fi_types::T_e8_DIM_EmulationMode EmulationMode_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_EmulationModeStatus();

    /**
     * Assignment operator
     */
    inline DIM_INFO_EmulationModeStatus& operator = (const DIM_INFO_EmulationModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_EmulationModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_EmulationModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_EmulationModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_EmulationModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "EmulationMode"

    static const int kEmulationMode = 0;

    /**
     * Clears the field "EmulationMode".
     *
     * The field will be set to its default value. The hasEmulationMode()
     * method will return false.
     */
    inline void clearEmulationMode();

    /**
     * Checks whether the field "EmulationMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEmulationMode()). Otherwise it will return false.
     */
    inline bool hasEmulationMode () const;

    /**
     * Returns the value of the member "EmulationMode".
     *
     * Provides the current status of the EmulationMode
     *
     * @return The value of the field "EmulationMode"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_EmulationMode getEmulationMode () const;

    /**
     * Sets the value of the member "EmulationMode".
     *
     * Provides the current status of the EmulationMode
     *
     * @param EmulationMode The value which will be set
     */
    inline void setEmulationMode (::dimming_main_fi_types::T_e8_DIM_EmulationMode EmulationMode_);

    static const DIM_INFO_EmulationModeStatus &getDefaultInstance();

private:

    inline void set_has_EmulationMode ();

    inline void clear_has_EmulationMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_e8_DIM_EmulationMode _EmulationMode;

};

/**
 * The error message of 'DIM_INFO_EmulationMode'
 */
class DIM_INFO_EmulationModeErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_EmulationModeErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_EmulationModeErrorStructure (const DIM_INFO_EmulationModeErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_EmulationModeErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_INFO_EmulationModeErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_INFO_EmulationModeErrorStructure& operator = (const DIM_INFO_EmulationModeErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_EmulationModeErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_EmulationModeErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_EmulationModeErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_EmulationModeErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_INFO_EmulationModeErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_INFO_EmulationMode'
 */
class DIM_INFO_EmulationModeError  : public ::asf::core::Payload {
public:

    enum DIM_INFO_EmulationModeErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_INFO_EmulationModeError ();

   /**
     * Copy constructor
     */
    inline  DIM_INFO_EmulationModeError (const DIM_INFO_EmulationModeError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_EmulationModeError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_INFO_EmulationModeError& operator = (const DIM_INFO_EmulationModeError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_EmulationModeError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_EmulationModeError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_EmulationModeError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_EmulationModeError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_INFO_EmulationModeError::DIM_INFO_EmulationModeErrorField getField () const;

    inline void setField(DIM_INFO_EmulationModeError::DIM_INFO_EmulationModeErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_INFO_EmulationModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_INFO_EmulationModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_INFO_EmulationModeErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_INFO_EmulationModeErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_INFO_EmulationModeErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_INFO_EmulationModeErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_INFO_EmulationModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_INFO_EmulationModeErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_INFO_EmulationModeError &getDefaultInstance();

private:

    inline void cloneData (const DIM_INFO_EmulationModeError& rhs);

    inline void deleteData ();

    DIM_INFO_EmulationModeErrorField __field;

    union {
        DIM_INFO_EmulationModeErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_INFO_ITC"
 * <p>Provides the current internal trouble code</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_INFO_ITCStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_ITCStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_ITCStatus (const DIM_INFO_ITCStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_ITCStatus (uint16 ITC_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_ITCStatus();

    /**
     * Assignment operator
     */
    inline DIM_INFO_ITCStatus& operator = (const DIM_INFO_ITCStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_ITCStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_ITCStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_ITCStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_ITCStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ITC"

    static const int kITC = 0;

    /**
     * Clears the field "ITC".
     *
     * The field will be set to its default value. The hasITC()
     * method will return false.
     */
    inline void clearITC();

    /**
     * Checks whether the field "ITC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setITC()). Otherwise it will return false.
     */
    inline bool hasITC () const;

    /**
     * Returns the value of the member "ITC".
     *
     * Provides the current ITC
     *
     * @return The value of the field "ITC"
     */
    inline uint16 getITC () const;

    /**
     * Sets the value of the member "ITC".
     *
     * Provides the current ITC
     *
     * @param ITC The value which will be set
     */
    inline void setITC (uint16 ITC_);

    static const DIM_INFO_ITCStatus &getDefaultInstance();

private:

    inline void set_has_ITC ();

    inline void clear_has_ITC ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _ITC;

};

/**
 * The error message of 'DIM_INFO_ITC'
 */
class DIM_INFO_ITCErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_ITCErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_ITCErrorStructure (const DIM_INFO_ITCErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_ITCErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_INFO_ITCErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_INFO_ITCErrorStructure& operator = (const DIM_INFO_ITCErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_ITCErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_ITCErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_ITCErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_ITCErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_INFO_ITCErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_INFO_ITC'
 */
class DIM_INFO_ITCError  : public ::asf::core::Payload {
public:

    enum DIM_INFO_ITCErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_INFO_ITCError ();

   /**
     * Copy constructor
     */
    inline  DIM_INFO_ITCError (const DIM_INFO_ITCError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_ITCError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_INFO_ITCError& operator = (const DIM_INFO_ITCError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_ITCError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_ITCError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_ITCError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_ITCError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_INFO_ITCError::DIM_INFO_ITCErrorField getField () const;

    inline void setField(DIM_INFO_ITCError::DIM_INFO_ITCErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_INFO_ITCErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_INFO_ITCErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_INFO_ITCErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_INFO_ITCErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_INFO_ITCErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_INFO_ITCErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_INFO_ITCErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_INFO_ITCErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_INFO_ITCError &getDefaultInstance();

private:

    inline void cloneData (const DIM_INFO_ITCError& rhs);

    inline void deleteData ();

    DIM_INFO_ITCErrorField __field;

    union {
        DIM_INFO_ITCErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_INFO_PWMBrightness"
 * <p>Provides the current brightness as signalled by the car through PWM input</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_INFO_PWMBrightnessStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_PWMBrightnessStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_PWMBrightnessStatus (const DIM_INFO_PWMBrightnessStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_PWMBrightnessStatus (::dimming_main_fi_types::T_u16_DIM_Permille PWMBrightness_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_PWMBrightnessStatus();

    /**
     * Assignment operator
     */
    inline DIM_INFO_PWMBrightnessStatus& operator = (const DIM_INFO_PWMBrightnessStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_PWMBrightnessStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_PWMBrightnessStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_PWMBrightnessStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_PWMBrightnessStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PWMBrightness"

    static const int kPWMBrightness = 0;

    /**
     * Clears the field "PWMBrightness".
     *
     * The field will be set to its default value. The hasPWMBrightness()
     * method will return false.
     */
    inline void clearPWMBrightness();

    /**
     * Checks whether the field "PWMBrightness" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPWMBrightness()). Otherwise it will return false.
     */
    inline bool hasPWMBrightness () const;

    /**
     * Returns the value of the member "PWMBrightness".
     *
     * Provides the current PWM brightness value
     *
     * @return The value of the field "PWMBrightness"
     */
    inline ::dimming_main_fi_types::T_u16_DIM_Permille getPWMBrightness () const;

    /**
     * Sets the value of the member "PWMBrightness".
     *
     * Provides the current PWM brightness value
     *
     * @param PWMBrightness The value which will be set
     */
    inline void setPWMBrightness (::dimming_main_fi_types::T_u16_DIM_Permille PWMBrightness_);

    static const DIM_INFO_PWMBrightnessStatus &getDefaultInstance();

private:

    inline void set_has_PWMBrightness ();

    inline void clear_has_PWMBrightness ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_u16_DIM_Permille _PWMBrightness;

};

/**
 * The error message of 'DIM_INFO_PWMBrightness'
 */
class DIM_INFO_PWMBrightnessErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_PWMBrightnessErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_PWMBrightnessErrorStructure (const DIM_INFO_PWMBrightnessErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_PWMBrightnessErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_INFO_PWMBrightnessErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_INFO_PWMBrightnessErrorStructure& operator = (const DIM_INFO_PWMBrightnessErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_PWMBrightnessErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_PWMBrightnessErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_PWMBrightnessErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_PWMBrightnessErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_INFO_PWMBrightnessErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_INFO_PWMBrightness'
 */
class DIM_INFO_PWMBrightnessError  : public ::asf::core::Payload {
public:

    enum DIM_INFO_PWMBrightnessErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_INFO_PWMBrightnessError ();

   /**
     * Copy constructor
     */
    inline  DIM_INFO_PWMBrightnessError (const DIM_INFO_PWMBrightnessError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_PWMBrightnessError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_INFO_PWMBrightnessError& operator = (const DIM_INFO_PWMBrightnessError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_PWMBrightnessError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_PWMBrightnessError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_PWMBrightnessError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_PWMBrightnessError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_INFO_PWMBrightnessError::DIM_INFO_PWMBrightnessErrorField getField () const;

    inline void setField(DIM_INFO_PWMBrightnessError::DIM_INFO_PWMBrightnessErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_INFO_PWMBrightnessErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_INFO_PWMBrightnessErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_INFO_PWMBrightnessErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_INFO_PWMBrightnessErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_INFO_PWMBrightnessErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_INFO_PWMBrightnessErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_INFO_PWMBrightnessErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_INFO_PWMBrightnessErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_INFO_PWMBrightnessError &getDefaultInstance();

private:

    inline void cloneData (const DIM_INFO_PWMBrightnessError& rhs);

    inline void deleteData ();

    DIM_INFO_PWMBrightnessErrorField __field;

    union {
        DIM_INFO_PWMBrightnessErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_INFO_CANBrightness"
 * <p>Provides the current brightness as signalled by the car through CAN input</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_INFO_CANBrightnessStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_CANBrightnessStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_CANBrightnessStatus (const DIM_INFO_CANBrightnessStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_CANBrightnessStatus (::dimming_main_fi_types::T_u16_DIM_Permille CANBrightness_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_CANBrightnessStatus();

    /**
     * Assignment operator
     */
    inline DIM_INFO_CANBrightnessStatus& operator = (const DIM_INFO_CANBrightnessStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_CANBrightnessStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_CANBrightnessStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_CANBrightnessStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_CANBrightnessStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CANBrightness"

    static const int kCANBrightness = 0;

    /**
     * Clears the field "CANBrightness".
     *
     * The field will be set to its default value. The hasCANBrightness()
     * method will return false.
     */
    inline void clearCANBrightness();

    /**
     * Checks whether the field "CANBrightness" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCANBrightness()). Otherwise it will return false.
     */
    inline bool hasCANBrightness () const;

    /**
     * Returns the value of the member "CANBrightness".
     *
     * Provides the current CAN brightness value
     *
     * @return The value of the field "CANBrightness"
     */
    inline ::dimming_main_fi_types::T_u16_DIM_Permille getCANBrightness () const;

    /**
     * Sets the value of the member "CANBrightness".
     *
     * Provides the current CAN brightness value
     *
     * @param CANBrightness The value which will be set
     */
    inline void setCANBrightness (::dimming_main_fi_types::T_u16_DIM_Permille CANBrightness_);

    static const DIM_INFO_CANBrightnessStatus &getDefaultInstance();

private:

    inline void set_has_CANBrightness ();

    inline void clear_has_CANBrightness ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_u16_DIM_Permille _CANBrightness;

};

/**
 * The error message of 'DIM_INFO_CANBrightness'
 */
class DIM_INFO_CANBrightnessErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_CANBrightnessErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_CANBrightnessErrorStructure (const DIM_INFO_CANBrightnessErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_CANBrightnessErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_INFO_CANBrightnessErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_INFO_CANBrightnessErrorStructure& operator = (const DIM_INFO_CANBrightnessErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_CANBrightnessErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_CANBrightnessErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_CANBrightnessErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_CANBrightnessErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_INFO_CANBrightnessErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_INFO_CANBrightness'
 */
class DIM_INFO_CANBrightnessError  : public ::asf::core::Payload {
public:

    enum DIM_INFO_CANBrightnessErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_INFO_CANBrightnessError ();

   /**
     * Copy constructor
     */
    inline  DIM_INFO_CANBrightnessError (const DIM_INFO_CANBrightnessError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_CANBrightnessError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_INFO_CANBrightnessError& operator = (const DIM_INFO_CANBrightnessError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_CANBrightnessError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_CANBrightnessError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_CANBrightnessError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_CANBrightnessError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_INFO_CANBrightnessError::DIM_INFO_CANBrightnessErrorField getField () const;

    inline void setField(DIM_INFO_CANBrightnessError::DIM_INFO_CANBrightnessErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_INFO_CANBrightnessErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_INFO_CANBrightnessErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_INFO_CANBrightnessErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_INFO_CANBrightnessErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_INFO_CANBrightnessErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_INFO_CANBrightnessErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_INFO_CANBrightnessErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_INFO_CANBrightnessErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_INFO_CANBrightnessError &getDefaultInstance();

private:

    inline void cloneData (const DIM_INFO_CANBrightnessError& rhs);

    inline void deleteData ();

    DIM_INFO_CANBrightnessErrorField __field;

    union {
        DIM_INFO_CANBrightnessErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_KEYB_Brightness"
 * <p>Provides the current active keyboard brightness.
 * Even if multiple LED-groups (LUNs) are available the brighness control from the VD_Dimming server is the same.</p>
 * <p>---</p>
 * <p>Remark: This brightness value is in direct relation to the generated PWM output (if PWM is used).</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_KEYB_BrightnessStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_KEYB_BrightnessStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_KEYB_BrightnessStatus (const DIM_KEYB_BrightnessStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_KEYB_BrightnessStatus (::dimming_main_fi_types::T_u16_DIM_Permille Brightness_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_KEYB_BrightnessStatus();

    /**
     * Assignment operator
     */
    inline DIM_KEYB_BrightnessStatus& operator = (const DIM_KEYB_BrightnessStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_KEYB_BrightnessStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_KEYB_BrightnessStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_KEYB_BrightnessStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_KEYB_BrightnessStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Brightness"

    static const int kBrightness = 0;

    /**
     * Clears the field "Brightness".
     *
     * The field will be set to its default value. The hasBrightness()
     * method will return false.
     */
    inline void clearBrightness();

    /**
     * Checks whether the field "Brightness" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrightness()). Otherwise it will return false.
     */
    inline bool hasBrightness () const;

    /**
     * Returns the value of the member "Brightness".
     *
     * Provides the current keyboard brightness
     *
     * @return The value of the field "Brightness"
     */
    inline ::dimming_main_fi_types::T_u16_DIM_Permille getBrightness () const;

    /**
     * Sets the value of the member "Brightness".
     *
     * Provides the current keyboard brightness
     *
     * @param Brightness The value which will be set
     */
    inline void setBrightness (::dimming_main_fi_types::T_u16_DIM_Permille Brightness_);

    static const DIM_KEYB_BrightnessStatus &getDefaultInstance();

private:

    inline void set_has_Brightness ();

    inline void clear_has_Brightness ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_u16_DIM_Permille _Brightness;

};

/**
 * The error message of 'DIM_KEYB_Brightness'
 */
class DIM_KEYB_BrightnessErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_KEYB_BrightnessErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_KEYB_BrightnessErrorStructure (const DIM_KEYB_BrightnessErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_KEYB_BrightnessErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_KEYB_BrightnessErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_KEYB_BrightnessErrorStructure& operator = (const DIM_KEYB_BrightnessErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_KEYB_BrightnessErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_KEYB_BrightnessErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_KEYB_BrightnessErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_KEYB_BrightnessErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_KEYB_BrightnessErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_KEYB_Brightness'
 */
class DIM_KEYB_BrightnessError  : public ::asf::core::Payload {
public:

    enum DIM_KEYB_BrightnessErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_KEYB_BrightnessError ();

   /**
     * Copy constructor
     */
    inline  DIM_KEYB_BrightnessError (const DIM_KEYB_BrightnessError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_KEYB_BrightnessError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_KEYB_BrightnessError& operator = (const DIM_KEYB_BrightnessError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_KEYB_BrightnessError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_KEYB_BrightnessError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_KEYB_BrightnessError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_KEYB_BrightnessError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_KEYB_BrightnessError::DIM_KEYB_BrightnessErrorField getField () const;

    inline void setField(DIM_KEYB_BrightnessError::DIM_KEYB_BrightnessErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_KEYB_BrightnessErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_KEYB_BrightnessErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_KEYB_BrightnessErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_KEYB_BrightnessErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_KEYB_BrightnessErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_KEYB_BrightnessErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_KEYB_BrightnessErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_KEYB_BrightnessErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_KEYB_BrightnessError &getDefaultInstance();

private:

    inline void cloneData (const DIM_KEYB_BrightnessError& rhs);

    inline void deleteData ();

    DIM_KEYB_BrightnessErrorField __field;

    union {
        DIM_KEYB_BrightnessErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_KEYB_Halfclass"
 * <p>Provides the current halfclass information:</p>
 * Halfclass ID for channel A
 * Halfclass ID for channel B
 * The current ADC channel number for channel A
 * The current ADC channel number for channel B
 * The measured AD value from channel A
 * The measured AD value from channel B
 * <p>---</p>
 * Attention:
 * It it possible to have two different Halfclasses configured in one panel.
 * Which Halfclass ID is used for each PWM is configureable for each PWM.
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_KEYB_HalfclassStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_KEYB_HalfclassStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_KEYB_HalfclassStatus (const DIM_KEYB_HalfclassStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_KEYB_HalfclassStatus (::dimming_main_fi_types::T_u8_DIM_Halfclasses Halfclass_A_, ::dimming_main_fi_types::T_u8_DIM_Halfclasses Halfclass_B_, uint8 ADC_CFG_A_, uint8 ADC_CFG_B_, uint16 ADC_A_, uint16 ADC_B_, uint16 PWM_HC_A_, uint16 PWM_HC_B_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_KEYB_HalfclassStatus();

    /**
     * Assignment operator
     */
    inline DIM_KEYB_HalfclassStatus& operator = (const DIM_KEYB_HalfclassStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_KEYB_HalfclassStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_KEYB_HalfclassStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_KEYB_HalfclassStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_KEYB_HalfclassStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Halfclass_A"

    static const int kHalfclass_A = 0;

    /**
     * Clears the field "Halfclass_A".
     *
     * The field will be set to its default value. The hasHalfclass_A()
     * method will return false.
     */
    inline void clearHalfclass_A();

    /**
     * Checks whether the field "Halfclass_A" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHalfclass_A()). Otherwise it will return false.
     */
    inline bool hasHalfclass_A () const;

    /**
     * Returns the value of the member "Halfclass_A".
     *
     * Provides the current halfclass for channel A
     * Evaluation is based on ADC_CFG A and the measured values in AD channel A
     *
     * @return The value of the field "Halfclass_A"
     */
    inline ::dimming_main_fi_types::T_u8_DIM_Halfclasses getHalfclass_A () const;

    /**
     * Sets the value of the member "Halfclass_A".
     *
     * Provides the current halfclass for channel A
     * Evaluation is based on ADC_CFG A and the measured values in AD channel A
     *
     * @param Halfclass_A The value which will be set
     */
    inline void setHalfclass_A (::dimming_main_fi_types::T_u8_DIM_Halfclasses Halfclass_A_);

    // API of field "Halfclass_B"

    static const int kHalfclass_B = 1;

    /**
     * Clears the field "Halfclass_B".
     *
     * The field will be set to its default value. The hasHalfclass_B()
     * method will return false.
     */
    inline void clearHalfclass_B();

    /**
     * Checks whether the field "Halfclass_B" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHalfclass_B()). Otherwise it will return false.
     */
    inline bool hasHalfclass_B () const;

    /**
     * Returns the value of the member "Halfclass_B".
     *
     * Provides the current halfclass for channel B
     * Evaluation is based on ADC_CFG B and the measured values in AD channel B
     *
     * @return The value of the field "Halfclass_B"
     */
    inline ::dimming_main_fi_types::T_u8_DIM_Halfclasses getHalfclass_B () const;

    /**
     * Sets the value of the member "Halfclass_B".
     *
     * Provides the current halfclass for channel B
     * Evaluation is based on ADC_CFG B and the measured values in AD channel B
     *
     * @param Halfclass_B The value which will be set
     */
    inline void setHalfclass_B (::dimming_main_fi_types::T_u8_DIM_Halfclasses Halfclass_B_);

    // API of field "ADC_CFG_A"

    static const int kADC_CFG_A = 2;

    /**
     * Clears the field "ADC_CFG_A".
     *
     * The field will be set to its default value. The hasADC_CFG_A()
     * method will return false.
     */
    inline void clearADC_CFG_A();

    /**
     * Checks whether the field "ADC_CFG_A" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setADC_CFG_A()). Otherwise it will return false.
     */
    inline bool hasADC_CFG_A () const;

    /**
     * Returns the value of the member "ADC_CFG_A".
     *
     * Provides the information which AD channel number is used to measure A
     *
     * @return The value of the field "ADC_CFG_A"
     */
    inline uint8 getADC_CFG_A () const;

    /**
     * Sets the value of the member "ADC_CFG_A".
     *
     * Provides the information which AD channel number is used to measure A
     *
     * @param ADC_CFG_A The value which will be set
     */
    inline void setADC_CFG_A (uint8 ADC_CFG_A_);

    // API of field "ADC_CFG_B"

    static const int kADC_CFG_B = 3;

    /**
     * Clears the field "ADC_CFG_B".
     *
     * The field will be set to its default value. The hasADC_CFG_B()
     * method will return false.
     */
    inline void clearADC_CFG_B();

    /**
     * Checks whether the field "ADC_CFG_B" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setADC_CFG_B()). Otherwise it will return false.
     */
    inline bool hasADC_CFG_B () const;

    /**
     * Returns the value of the member "ADC_CFG_B".
     *
     * Provides the information which AD channel number is used to measure B
     *
     * @return The value of the field "ADC_CFG_B"
     */
    inline uint8 getADC_CFG_B () const;

    /**
     * Sets the value of the member "ADC_CFG_B".
     *
     * Provides the information which AD channel number is used to measure B
     *
     * @param ADC_CFG_B The value which will be set
     */
    inline void setADC_CFG_B (uint8 ADC_CFG_B_);

    // API of field "ADC_A"

    static const int kADC_A = 4;

    /**
     * Clears the field "ADC_A".
     *
     * The field will be set to its default value. The hasADC_A()
     * method will return false.
     */
    inline void clearADC_A();

    /**
     * Checks whether the field "ADC_A" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setADC_A()). Otherwise it will return false.
     */
    inline bool hasADC_A () const;

    /**
     * Returns the value of the member "ADC_A".
     *
     * Provides the current ADC channel A value in millivolt
     *
     * @return The value of the field "ADC_A"
     */
    inline uint16 getADC_A () const;

    /**
     * Sets the value of the member "ADC_A".
     *
     * Provides the current ADC channel A value in millivolt
     *
     * @param ADC_A The value which will be set
     */
    inline void setADC_A (uint16 ADC_A_);

    // API of field "ADC_B"

    static const int kADC_B = 5;

    /**
     * Clears the field "ADC_B".
     *
     * The field will be set to its default value. The hasADC_B()
     * method will return false.
     */
    inline void clearADC_B();

    /**
     * Checks whether the field "ADC_B" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setADC_B()). Otherwise it will return false.
     */
    inline bool hasADC_B () const;

    /**
     * Returns the value of the member "ADC_B".
     *
     * Provides the current ADC channel B value in millivolt
     *
     * @return The value of the field "ADC_B"
     */
    inline uint16 getADC_B () const;

    /**
     * Sets the value of the member "ADC_B".
     *
     * Provides the current ADC channel B value in millivolt
     *
     * @param ADC_B The value which will be set
     */
    inline void setADC_B (uint16 ADC_B_);

    // API of field "PWM_HC_A"

    static const int kPWM_HC_A = 6;

    /**
     * Clears the field "PWM_HC_A".
     *
     * The field will be set to its default value. The hasPWM_HC_A()
     * method will return false.
     */
    inline void clearPWM_HC_A();

    /**
     * Checks whether the field "PWM_HC_A" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPWM_HC_A()). Otherwise it will return false.
     */
    inline bool hasPWM_HC_A () const;

    /**
     * Returns the value of the member "PWM_HC_A".
     *
     * Provides a 16 bit mask. Each set bit corresponds to a PWM channel using halfclass A LEDs.
     * If this value is 0 then halfclass A is unused.
     *
     * @return The value of the field "PWM_HC_A"
     */
    inline uint16 getPWM_HC_A () const;

    /**
     * Sets the value of the member "PWM_HC_A".
     *
     * Provides a 16 bit mask. Each set bit corresponds to a PWM channel using halfclass A LEDs.
     * If this value is 0 then halfclass A is unused.
     *
     * @param PWM_HC_A The value which will be set
     */
    inline void setPWM_HC_A (uint16 PWM_HC_A_);

    // API of field "PWM_HC_B"

    static const int kPWM_HC_B = 7;

    /**
     * Clears the field "PWM_HC_B".
     *
     * The field will be set to its default value. The hasPWM_HC_B()
     * method will return false.
     */
    inline void clearPWM_HC_B();

    /**
     * Checks whether the field "PWM_HC_B" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPWM_HC_B()). Otherwise it will return false.
     */
    inline bool hasPWM_HC_B () const;

    /**
     * Returns the value of the member "PWM_HC_B".
     *
     * Provides a 16 bit mask. Each set bit corresponds to a PWM channel using halfclass B LEDs
     * If this value is 0 then halfclass B is unused.
     *
     * @return The value of the field "PWM_HC_B"
     */
    inline uint16 getPWM_HC_B () const;

    /**
     * Sets the value of the member "PWM_HC_B".
     *
     * Provides a 16 bit mask. Each set bit corresponds to a PWM channel using halfclass B LEDs
     * If this value is 0 then halfclass B is unused.
     *
     * @param PWM_HC_B The value which will be set
     */
    inline void setPWM_HC_B (uint16 PWM_HC_B_);

    static const DIM_KEYB_HalfclassStatus &getDefaultInstance();

private:

    inline void set_has_Halfclass_A ();

    inline void clear_has_Halfclass_A ();

    inline void set_has_Halfclass_B ();

    inline void clear_has_Halfclass_B ();

    inline void set_has_ADC_CFG_A ();

    inline void clear_has_ADC_CFG_A ();

    inline void set_has_ADC_CFG_B ();

    inline void clear_has_ADC_CFG_B ();

    inline void set_has_ADC_A ();

    inline void clear_has_ADC_A ();

    inline void set_has_ADC_B ();

    inline void clear_has_ADC_B ();

    inline void set_has_PWM_HC_A ();

    inline void clear_has_PWM_HC_A ();

    inline void set_has_PWM_HC_B ();

    inline void clear_has_PWM_HC_B ();

    uint32 _has_bits_[ (8 + 31) / 32];

    ::dimming_main_fi_types::T_u8_DIM_Halfclasses _Halfclass_A;

    ::dimming_main_fi_types::T_u8_DIM_Halfclasses _Halfclass_B;

    uint8 _ADC_CFG_A;

    uint8 _ADC_CFG_B;

    uint16 _ADC_A;

    uint16 _ADC_B;

    uint16 _PWM_HC_A;

    uint16 _PWM_HC_B;

};

/**
 * The error message of 'DIM_KEYB_Halfclass'
 */
class DIM_KEYB_HalfclassErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_KEYB_HalfclassErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_KEYB_HalfclassErrorStructure (const DIM_KEYB_HalfclassErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_KEYB_HalfclassErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_KEYB_HalfclassErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_KEYB_HalfclassErrorStructure& operator = (const DIM_KEYB_HalfclassErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_KEYB_HalfclassErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_KEYB_HalfclassErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_KEYB_HalfclassErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_KEYB_HalfclassErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_KEYB_HalfclassErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_KEYB_Halfclass'
 */
class DIM_KEYB_HalfclassError  : public ::asf::core::Payload {
public:

    enum DIM_KEYB_HalfclassErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_KEYB_HalfclassError ();

   /**
     * Copy constructor
     */
    inline  DIM_KEYB_HalfclassError (const DIM_KEYB_HalfclassError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_KEYB_HalfclassError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_KEYB_HalfclassError& operator = (const DIM_KEYB_HalfclassError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_KEYB_HalfclassError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_KEYB_HalfclassError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_KEYB_HalfclassError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_KEYB_HalfclassError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_KEYB_HalfclassError::DIM_KEYB_HalfclassErrorField getField () const;

    inline void setField(DIM_KEYB_HalfclassError::DIM_KEYB_HalfclassErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_KEYB_HalfclassErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_KEYB_HalfclassErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_KEYB_HalfclassErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_KEYB_HalfclassErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_KEYB_HalfclassErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_KEYB_HalfclassErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_KEYB_HalfclassErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_KEYB_HalfclassErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_KEYB_HalfclassError &getDefaultInstance();

private:

    inline void cloneData (const DIM_KEYB_HalfclassError& rhs);

    inline void deleteData ();

    DIM_KEYB_HalfclassErrorField __field;

    union {
        DIM_KEYB_HalfclassErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DISP_DriverInitalized"
 * <p>Used to determine the initialization status of the display driver.
 * This is used by VD_Dimming to determine the backlight status</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_DriverInitalizedStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_DriverInitalizedStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_DriverInitalizedStatus (const DIM_DISP_DriverInitalizedStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_DriverInitalizedStatus (::dimming_main_fi_types::T_e8_DIM_Status DriverInitialized_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_DriverInitalizedStatus();

    /**
     * Assignment operator
     */
    inline DIM_DISP_DriverInitalizedStatus& operator = (const DIM_DISP_DriverInitalizedStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_DriverInitalizedStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_DriverInitalizedStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_DriverInitalizedStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_DriverInitalizedStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DriverInitialized"

    static const int kDriverInitialized = 0;

    /**
     * Clears the field "DriverInitialized".
     *
     * The field will be set to its default value. The hasDriverInitialized()
     * method will return false.
     */
    inline void clearDriverInitialized();

    /**
     * Checks whether the field "DriverInitialized" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDriverInitialized()). Otherwise it will return false.
     */
    inline bool hasDriverInitialized () const;

    /**
     * Returns the value of the member "DriverInitialized".
     *
     * Initialization status of the display driver
     *
     * @return The value of the field "DriverInitialized"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_Status getDriverInitialized () const;

    /**
     * Sets the value of the member "DriverInitialized".
     *
     * Initialization status of the display driver
     *
     * @param DriverInitialized The value which will be set
     */
    inline void setDriverInitialized (::dimming_main_fi_types::T_e8_DIM_Status DriverInitialized_);

    static const DIM_DISP_DriverInitalizedStatus &getDefaultInstance();

private:

    inline void set_has_DriverInitialized ();

    inline void clear_has_DriverInitialized ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_e8_DIM_Status _DriverInitialized;

};

/**
 * The error message of 'DIM_DISP_DriverInitalized'
 */
class DIM_DISP_DriverInitalizedErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_DriverInitalizedErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_DriverInitalizedErrorStructure (const DIM_DISP_DriverInitalizedErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_DriverInitalizedErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_DriverInitalizedErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_DriverInitalizedErrorStructure& operator = (const DIM_DISP_DriverInitalizedErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_DriverInitalizedErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_DriverInitalizedErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_DriverInitalizedErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_DriverInitalizedErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_DriverInitalizedErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_DriverInitalized'
 */
class DIM_DISP_DriverInitalizedError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_DriverInitalizedErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_DriverInitalizedError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_DriverInitalizedError (const DIM_DISP_DriverInitalizedError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_DriverInitalizedError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_DriverInitalizedError& operator = (const DIM_DISP_DriverInitalizedError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_DriverInitalizedError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_DriverInitalizedError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_DriverInitalizedError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_DriverInitalizedError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_DriverInitalizedError::DIM_DISP_DriverInitalizedErrorField getField () const;

    inline void setField(DIM_DISP_DriverInitalizedError::DIM_DISP_DriverInitalizedErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_DriverInitalizedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_DriverInitalizedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_DriverInitalizedErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_DriverInitalizedErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_DriverInitalizedErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_DriverInitalizedErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_DriverInitalizedErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_DriverInitalizedErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_DriverInitalizedError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_DriverInitalizedError& rhs);

    inline void deleteData ();

    DIM_DISP_DriverInitalizedErrorField __field;

    union {
        DIM_DISP_DriverInitalizedErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DISP_ScreenContentAvailable"
 * <p>Used to determine the availablity of screen content.
 * VD_Dimming does not have this information as long as no one has updated this property (HMI/SPM)
 * This property will be set automatically to "Not Available" if VD_Dimming is shut down or
 * the display driver has been stopped.
 * The availability of screen content is necessary for VD_Dimming to activate the backlight.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_ScreenContentAvailableStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_ScreenContentAvailableStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_ScreenContentAvailableStatus (const DIM_DISP_ScreenContentAvailableStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_ScreenContentAvailableStatus (::dimming_main_fi_types::T_e8_DIM_Status ContentAvailable_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_ScreenContentAvailableStatus();

    /**
     * Assignment operator
     */
    inline DIM_DISP_ScreenContentAvailableStatus& operator = (const DIM_DISP_ScreenContentAvailableStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_ScreenContentAvailableStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_ScreenContentAvailableStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_ScreenContentAvailableStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_ScreenContentAvailableStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ContentAvailable"

    static const int kContentAvailable = 0;

    /**
     * Clears the field "ContentAvailable".
     *
     * The field will be set to its default value. The hasContentAvailable()
     * method will return false.
     */
    inline void clearContentAvailable();

    /**
     * Checks whether the field "ContentAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setContentAvailable()). Otherwise it will return false.
     */
    inline bool hasContentAvailable () const;

    /**
     * Returns the value of the member "ContentAvailable".
     *
     * Status of the screen content availability
     *
     * @return The value of the field "ContentAvailable"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_Status getContentAvailable () const;

    /**
     * Sets the value of the member "ContentAvailable".
     *
     * Status of the screen content availability
     *
     * @param ContentAvailable The value which will be set
     */
    inline void setContentAvailable (::dimming_main_fi_types::T_e8_DIM_Status ContentAvailable_);

    static const DIM_DISP_ScreenContentAvailableStatus &getDefaultInstance();

private:

    inline void set_has_ContentAvailable ();

    inline void clear_has_ContentAvailable ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_e8_DIM_Status _ContentAvailable;

};

/**
 * The error message of 'DIM_DISP_ScreenContentAvailable'
 */
class DIM_DISP_ScreenContentAvailableErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_ScreenContentAvailableErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_ScreenContentAvailableErrorStructure (const DIM_DISP_ScreenContentAvailableErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_ScreenContentAvailableErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_ScreenContentAvailableErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_ScreenContentAvailableErrorStructure& operator = (const DIM_DISP_ScreenContentAvailableErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_ScreenContentAvailableErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_ScreenContentAvailableErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_ScreenContentAvailableErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_ScreenContentAvailableErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_ScreenContentAvailableErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_ScreenContentAvailable'
 */
class DIM_DISP_ScreenContentAvailableError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_ScreenContentAvailableErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_ScreenContentAvailableError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_ScreenContentAvailableError (const DIM_DISP_ScreenContentAvailableError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_ScreenContentAvailableError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_ScreenContentAvailableError& operator = (const DIM_DISP_ScreenContentAvailableError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_ScreenContentAvailableError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_ScreenContentAvailableError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_ScreenContentAvailableError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_ScreenContentAvailableError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_ScreenContentAvailableError::DIM_DISP_ScreenContentAvailableErrorField getField () const;

    inline void setField(DIM_DISP_ScreenContentAvailableError::DIM_DISP_ScreenContentAvailableErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_ScreenContentAvailableErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_ScreenContentAvailableErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_ScreenContentAvailableErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_ScreenContentAvailableErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_ScreenContentAvailableErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_ScreenContentAvailableErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_ScreenContentAvailableErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_ScreenContentAvailableErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_ScreenContentAvailableError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_ScreenContentAvailableError& rhs);

    inline void deleteData ();

    DIM_DISP_ScreenContentAvailableErrorField __field;

    union {
        DIM_DISP_ScreenContentAvailableErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DISP_Brightness"
 * <p>Provides the current active display brightness</p>
 * <p>---</p>
 * <p>Remark: This brightness value is in direct relation to the generated PWM output (if PWM is used).</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_BrightnessStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_BrightnessStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_BrightnessStatus (const DIM_DISP_BrightnessStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_BrightnessStatus (::dimming_main_fi_types::T_u16_DIM_Permille Brightness_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_BrightnessStatus();

    /**
     * Assignment operator
     */
    inline DIM_DISP_BrightnessStatus& operator = (const DIM_DISP_BrightnessStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_BrightnessStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_BrightnessStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_BrightnessStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_BrightnessStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Brightness"

    static const int kBrightness = 0;

    /**
     * Clears the field "Brightness".
     *
     * The field will be set to its default value. The hasBrightness()
     * method will return false.
     */
    inline void clearBrightness();

    /**
     * Checks whether the field "Brightness" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrightness()). Otherwise it will return false.
     */
    inline bool hasBrightness () const;

    /**
     * Returns the value of the member "Brightness".
     *
     * Provides the current display brightness
     *
     * @return The value of the field "Brightness"
     */
    inline ::dimming_main_fi_types::T_u16_DIM_Permille getBrightness () const;

    /**
     * Sets the value of the member "Brightness".
     *
     * Provides the current display brightness
     *
     * @param Brightness The value which will be set
     */
    inline void setBrightness (::dimming_main_fi_types::T_u16_DIM_Permille Brightness_);

    static const DIM_DISP_BrightnessStatus &getDefaultInstance();

private:

    inline void set_has_Brightness ();

    inline void clear_has_Brightness ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_u16_DIM_Permille _Brightness;

};

/**
 * The error message of 'DIM_DISP_Brightness'
 */
class DIM_DISP_BrightnessErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_BrightnessErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_BrightnessErrorStructure (const DIM_DISP_BrightnessErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_BrightnessErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_BrightnessErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_BrightnessErrorStructure& operator = (const DIM_DISP_BrightnessErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_BrightnessErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_BrightnessErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_BrightnessErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_BrightnessErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_BrightnessErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_Brightness'
 */
class DIM_DISP_BrightnessError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_BrightnessErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_BrightnessError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_BrightnessError (const DIM_DISP_BrightnessError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_BrightnessError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_BrightnessError& operator = (const DIM_DISP_BrightnessError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_BrightnessError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_BrightnessError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_BrightnessError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_BrightnessError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_BrightnessError::DIM_DISP_BrightnessErrorField getField () const;

    inline void setField(DIM_DISP_BrightnessError::DIM_DISP_BrightnessErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_BrightnessErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_BrightnessErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_BrightnessErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_BrightnessErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_BrightnessErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_BrightnessErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_BrightnessErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_BrightnessErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_BrightnessError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_BrightnessError& rhs);

    inline void deleteData ();

    DIM_DISP_BrightnessErrorField __field;

    union {
        DIM_DISP_BrightnessErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DISP_Backlight"
 * <p>Retrieve the current status of the display's backlight</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_BacklightStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_BacklightStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_BacklightStatus (const DIM_DISP_BacklightStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_BacklightStatus (::dimming_main_fi_types::T_e8_DIM_Status BacklightStatus_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_BacklightStatus();

    /**
     * Assignment operator
     */
    inline DIM_DISP_BacklightStatus& operator = (const DIM_DISP_BacklightStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_BacklightStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_BacklightStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_BacklightStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_BacklightStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BacklightStatus"

    static const int kBacklightStatus = 0;

    /**
     * Clears the field "BacklightStatus".
     *
     * The field will be set to its default value. The hasBacklightStatus()
     * method will return false.
     */
    inline void clearBacklightStatus();

    /**
     * Checks whether the field "BacklightStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBacklightStatus()). Otherwise it will return false.
     */
    inline bool hasBacklightStatus () const;

    /**
     * Returns the value of the member "BacklightStatus".
     *
     * Current status of the backlight
     *
     * @return The value of the field "BacklightStatus"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_Status getBacklightStatus () const;

    /**
     * Sets the value of the member "BacklightStatus".
     *
     * Current status of the backlight
     *
     * @param BacklightStatus The value which will be set
     */
    inline void setBacklightStatus (::dimming_main_fi_types::T_e8_DIM_Status BacklightStatus_);

    static const DIM_DISP_BacklightStatus &getDefaultInstance();

private:

    inline void set_has_BacklightStatus ();

    inline void clear_has_BacklightStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_e8_DIM_Status _BacklightStatus;

};

/**
 * The error message of 'DIM_DISP_Backlight'
 */
class DIM_DISP_BacklightErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_BacklightErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_BacklightErrorStructure (const DIM_DISP_BacklightErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_BacklightErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_BacklightErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_BacklightErrorStructure& operator = (const DIM_DISP_BacklightErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_BacklightErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_BacklightErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_BacklightErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_BacklightErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_BacklightErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_Backlight'
 */
class DIM_DISP_BacklightError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_BacklightErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_BacklightError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_BacklightError (const DIM_DISP_BacklightError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_BacklightError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_BacklightError& operator = (const DIM_DISP_BacklightError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_BacklightError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_BacklightError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_BacklightError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_BacklightError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_BacklightError::DIM_DISP_BacklightErrorField getField () const;

    inline void setField(DIM_DISP_BacklightError::DIM_DISP_BacklightErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_BacklightErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_BacklightErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_BacklightErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_BacklightErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_BacklightErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_BacklightErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_BacklightErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_BacklightErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_BacklightError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_BacklightError& rhs);

    inline void deleteData ();

    DIM_DISP_BacklightErrorField __field;

    union {
        DIM_DISP_BacklightErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DISP_TemperatureInfo"
 * <p>Read out the temperature information. This property delivers the following information:</p>
 * The display's panel temperature
 * The display's ambient temperature
 * The current temperature warning level
 * Timeout when warning level is switched from overheating to critical
 * Time the system is in warning level "critical"
 * <p>---</p>
 * <p>If you are only interested in the display's panel temperature then check property DIM_DISP_PanelTemperature</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_TemperatureInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_TemperatureInfoStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_TemperatureInfoStatus (const DIM_DISP_TemperatureInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_TemperatureInfoStatus (::dimming_main_fi_types::T_s16_DIM_Temperature PanelTemp_, ::dimming_main_fi_types::T_s16_DIM_Temperature AmbientTemp_, ::dimming_main_fi_types::T_e8_DIM_WarningLevel WarningLevel_, uint16 CriticalLevelTimeout_, uint16 CriticalLevelElapsed_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_TemperatureInfoStatus();

    /**
     * Assignment operator
     */
    inline DIM_DISP_TemperatureInfoStatus& operator = (const DIM_DISP_TemperatureInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_TemperatureInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_TemperatureInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_TemperatureInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_TemperatureInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PanelTemp"

    static const int kPanelTemp = 0;

    /**
     * Clears the field "PanelTemp".
     *
     * The field will be set to its default value. The hasPanelTemp()
     * method will return false.
     */
    inline void clearPanelTemp();

    /**
     * Checks whether the field "PanelTemp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPanelTemp()). Otherwise it will return false.
     */
    inline bool hasPanelTemp () const;

    /**
     * Returns the value of the member "PanelTemp".
     *
     * Display panel temperature
     *
     * @return The value of the field "PanelTemp"
     */
    inline ::dimming_main_fi_types::T_s16_DIM_Temperature getPanelTemp () const;

    /**
     * Sets the value of the member "PanelTemp".
     *
     * Display panel temperature
     *
     * @param PanelTemp The value which will be set
     */
    inline void setPanelTemp (::dimming_main_fi_types::T_s16_DIM_Temperature PanelTemp_);

    // API of field "AmbientTemp"

    static const int kAmbientTemp = 1;

    /**
     * Clears the field "AmbientTemp".
     *
     * The field will be set to its default value. The hasAmbientTemp()
     * method will return false.
     */
    inline void clearAmbientTemp();

    /**
     * Checks whether the field "AmbientTemp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAmbientTemp()). Otherwise it will return false.
     */
    inline bool hasAmbientTemp () const;

    /**
     * Returns the value of the member "AmbientTemp".
     *
     * Display ambient temperature
     *
     * @return The value of the field "AmbientTemp"
     */
    inline ::dimming_main_fi_types::T_s16_DIM_Temperature getAmbientTemp () const;

    /**
     * Sets the value of the member "AmbientTemp".
     *
     * Display ambient temperature
     *
     * @param AmbientTemp The value which will be set
     */
    inline void setAmbientTemp (::dimming_main_fi_types::T_s16_DIM_Temperature AmbientTemp_);

    // API of field "WarningLevel"

    static const int kWarningLevel = 2;

    /**
     * Clears the field "WarningLevel".
     *
     * The field will be set to its default value. The hasWarningLevel()
     * method will return false.
     */
    inline void clearWarningLevel();

    /**
     * Checks whether the field "WarningLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWarningLevel()). Otherwise it will return false.
     */
    inline bool hasWarningLevel () const;

    /**
     * Returns the value of the member "WarningLevel".
     *
     * Current warning level
     *
     * @return The value of the field "WarningLevel"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_WarningLevel getWarningLevel () const;

    /**
     * Sets the value of the member "WarningLevel".
     *
     * Current warning level
     *
     * @param WarningLevel The value which will be set
     */
    inline void setWarningLevel (::dimming_main_fi_types::T_e8_DIM_WarningLevel WarningLevel_);

    // API of field "CriticalLevelTimeout"

    static const int kCriticalLevelTimeout = 3;

    /**
     * Clears the field "CriticalLevelTimeout".
     *
     * The field will be set to its default value. The hasCriticalLevelTimeout()
     * method will return false.
     */
    inline void clearCriticalLevelTimeout();

    /**
     * Checks whether the field "CriticalLevelTimeout" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCriticalLevelTimeout()). Otherwise it will return false.
     */
    inline bool hasCriticalLevelTimeout () const;

    /**
     * Returns the value of the member "CriticalLevelTimeout".
     *
     * Timeout when warning level is switched from overheating to critical
     *
     * @return The value of the field "CriticalLevelTimeout"
     */
    inline uint16 getCriticalLevelTimeout () const;

    /**
     * Sets the value of the member "CriticalLevelTimeout".
     *
     * Timeout when warning level is switched from overheating to critical
     *
     * @param CriticalLevelTimeout The value which will be set
     */
    inline void setCriticalLevelTimeout (uint16 CriticalLevelTimeout_);

    // API of field "CriticalLevelElapsed"

    static const int kCriticalLevelElapsed = 4;

    /**
     * Clears the field "CriticalLevelElapsed".
     *
     * The field will be set to its default value. The hasCriticalLevelElapsed()
     * method will return false.
     */
    inline void clearCriticalLevelElapsed();

    /**
     * Checks whether the field "CriticalLevelElapsed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCriticalLevelElapsed()). Otherwise it will return false.
     */
    inline bool hasCriticalLevelElapsed () const;

    /**
     * Returns the value of the member "CriticalLevelElapsed".
     *
     * Time the system is in warning level "critical"
     *
     * @return The value of the field "CriticalLevelElapsed"
     */
    inline uint16 getCriticalLevelElapsed () const;

    /**
     * Sets the value of the member "CriticalLevelElapsed".
     *
     * Time the system is in warning level "critical"
     *
     * @param CriticalLevelElapsed The value which will be set
     */
    inline void setCriticalLevelElapsed (uint16 CriticalLevelElapsed_);

    static const DIM_DISP_TemperatureInfoStatus &getDefaultInstance();

private:

    inline void set_has_PanelTemp ();

    inline void clear_has_PanelTemp ();

    inline void set_has_AmbientTemp ();

    inline void clear_has_AmbientTemp ();

    inline void set_has_WarningLevel ();

    inline void clear_has_WarningLevel ();

    inline void set_has_CriticalLevelTimeout ();

    inline void clear_has_CriticalLevelTimeout ();

    inline void set_has_CriticalLevelElapsed ();

    inline void clear_has_CriticalLevelElapsed ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::dimming_main_fi_types::T_s16_DIM_Temperature _PanelTemp;

    ::dimming_main_fi_types::T_s16_DIM_Temperature _AmbientTemp;

    ::dimming_main_fi_types::T_e8_DIM_WarningLevel _WarningLevel;

    uint16 _CriticalLevelTimeout;

    uint16 _CriticalLevelElapsed;

};

/**
 * The error message of 'DIM_DISP_TemperatureInfo'
 */
class DIM_DISP_TemperatureInfoErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_TemperatureInfoErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_TemperatureInfoErrorStructure (const DIM_DISP_TemperatureInfoErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_TemperatureInfoErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_TemperatureInfoErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_TemperatureInfoErrorStructure& operator = (const DIM_DISP_TemperatureInfoErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_TemperatureInfoErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_TemperatureInfoErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_TemperatureInfoErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_TemperatureInfoErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_TemperatureInfoErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_TemperatureInfo'
 */
class DIM_DISP_TemperatureInfoError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_TemperatureInfoErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_TemperatureInfoError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_TemperatureInfoError (const DIM_DISP_TemperatureInfoError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_TemperatureInfoError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_TemperatureInfoError& operator = (const DIM_DISP_TemperatureInfoError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_TemperatureInfoError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_TemperatureInfoError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_TemperatureInfoError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_TemperatureInfoError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_TemperatureInfoError::DIM_DISP_TemperatureInfoErrorField getField () const;

    inline void setField(DIM_DISP_TemperatureInfoError::DIM_DISP_TemperatureInfoErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_TemperatureInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_TemperatureInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_TemperatureInfoErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_TemperatureInfoErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_TemperatureInfoErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_TemperatureInfoErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_TemperatureInfoErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_TemperatureInfoErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_TemperatureInfoError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_TemperatureInfoError& rhs);

    inline void deleteData ();

    DIM_DISP_TemperatureInfoErrorField __field;

    union {
        DIM_DISP_TemperatureInfoErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DISP_Size"
 * <p>Retrieve the current display size
 * This information is based on the detected headunit.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_SizeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SizeStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SizeStatus (const DIM_DISP_SizeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SizeStatus (::dimming_main_fi_types::T_e8_DIM_DisplaySize Size_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SizeStatus();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SizeStatus& operator = (const DIM_DISP_SizeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SizeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SizeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SizeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SizeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Size"

    static const int kSize = 0;

    /**
     * Clears the field "Size".
     *
     * The field will be set to its default value. The hasSize()
     * method will return false.
     */
    inline void clearSize();

    /**
     * Checks whether the field "Size" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSize()). Otherwise it will return false.
     */
    inline bool hasSize () const;

    /**
     * Returns the value of the member "Size".
     *
     * Display size
     *
     * @return The value of the field "Size"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_DisplaySize getSize () const;

    /**
     * Sets the value of the member "Size".
     *
     * Display size
     *
     * @param Size The value which will be set
     */
    inline void setSize (::dimming_main_fi_types::T_e8_DIM_DisplaySize Size_);

    static const DIM_DISP_SizeStatus &getDefaultInstance();

private:

    inline void set_has_Size ();

    inline void clear_has_Size ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_e8_DIM_DisplaySize _Size;

};

/**
 * The error message of 'DIM_DISP_Size'
 */
class DIM_DISP_SizeErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SizeErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SizeErrorStructure (const DIM_DISP_SizeErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SizeErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_SizeErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SizeErrorStructure& operator = (const DIM_DISP_SizeErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SizeErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SizeErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SizeErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SizeErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_SizeErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_Size'
 */
class DIM_DISP_SizeError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_SizeErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_SizeError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_SizeError (const DIM_DISP_SizeError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SizeError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_SizeError& operator = (const DIM_DISP_SizeError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SizeError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SizeError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SizeError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SizeError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_SizeError::DIM_DISP_SizeErrorField getField () const;

    inline void setField(DIM_DISP_SizeError::DIM_DISP_SizeErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_SizeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_SizeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_SizeErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_SizeErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_SizeErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_SizeErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_SizeErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_SizeErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_SizeError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_SizeError& rhs);

    inline void deleteData ();

    DIM_DISP_SizeErrorField __field;

    union {
        DIM_DISP_SizeErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DISP_BrightnessLevel"
 * <p>Provides the current active display brightness level</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_BrightnessLevelStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_BrightnessLevelStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_BrightnessLevelStatus (const DIM_DISP_BrightnessLevelStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_BrightnessLevelStatus (::dimming_main_fi_types::T_e8_DIM_BrightnessLevel BrightnessLevel_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_BrightnessLevelStatus();

    /**
     * Assignment operator
     */
    inline DIM_DISP_BrightnessLevelStatus& operator = (const DIM_DISP_BrightnessLevelStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_BrightnessLevelStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_BrightnessLevelStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_BrightnessLevelStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_BrightnessLevelStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BrightnessLevel"

    static const int kBrightnessLevel = 0;

    /**
     * Clears the field "BrightnessLevel".
     *
     * The field will be set to its default value. The hasBrightnessLevel()
     * method will return false.
     */
    inline void clearBrightnessLevel();

    /**
     * Checks whether the field "BrightnessLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrightnessLevel()). Otherwise it will return false.
     */
    inline bool hasBrightnessLevel () const;

    /**
     * Returns the value of the member "BrightnessLevel".
     *
     * Provides the current display brightness level
     *
     * @return The value of the field "BrightnessLevel"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_BrightnessLevel getBrightnessLevel () const;

    /**
     * Sets the value of the member "BrightnessLevel".
     *
     * Provides the current display brightness level
     *
     * @param BrightnessLevel The value which will be set
     */
    inline void setBrightnessLevel (::dimming_main_fi_types::T_e8_DIM_BrightnessLevel BrightnessLevel_);

    static const DIM_DISP_BrightnessLevelStatus &getDefaultInstance();

private:

    inline void set_has_BrightnessLevel ();

    inline void clear_has_BrightnessLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_e8_DIM_BrightnessLevel _BrightnessLevel;

};

/**
 * The error message of 'DIM_DISP_BrightnessLevel'
 */
class DIM_DISP_BrightnessLevelErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_BrightnessLevelErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_BrightnessLevelErrorStructure (const DIM_DISP_BrightnessLevelErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_BrightnessLevelErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_BrightnessLevelErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_BrightnessLevelErrorStructure& operator = (const DIM_DISP_BrightnessLevelErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_BrightnessLevelErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_BrightnessLevelErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_BrightnessLevelErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_BrightnessLevelErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_BrightnessLevelErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_BrightnessLevel'
 */
class DIM_DISP_BrightnessLevelError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_BrightnessLevelErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_BrightnessLevelError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_BrightnessLevelError (const DIM_DISP_BrightnessLevelError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_BrightnessLevelError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_BrightnessLevelError& operator = (const DIM_DISP_BrightnessLevelError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_BrightnessLevelError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_BrightnessLevelError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_BrightnessLevelError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_BrightnessLevelError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_BrightnessLevelError::DIM_DISP_BrightnessLevelErrorField getField () const;

    inline void setField(DIM_DISP_BrightnessLevelError::DIM_DISP_BrightnessLevelErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_BrightnessLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_BrightnessLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_BrightnessLevelErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_BrightnessLevelErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_BrightnessLevelErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_BrightnessLevelErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_BrightnessLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_BrightnessLevelErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_BrightnessLevelError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_BrightnessLevelError& rhs);

    inline void deleteData ();

    DIM_DISP_BrightnessLevelErrorField __field;

    union {
        DIM_DISP_BrightnessLevelErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DISP_PanelTemperature"
 * <p>Read out the display's panel temperature</p>
 * <p>If you need all temperature information check DIM_DISP_TemperatureInfo</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_PanelTemperatureStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_PanelTemperatureStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_PanelTemperatureStatus (const DIM_DISP_PanelTemperatureStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_PanelTemperatureStatus (::dimming_main_fi_types::T_s16_DIM_Temperature Temperature_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_PanelTemperatureStatus();

    /**
     * Assignment operator
     */
    inline DIM_DISP_PanelTemperatureStatus& operator = (const DIM_DISP_PanelTemperatureStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_PanelTemperatureStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_PanelTemperatureStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_PanelTemperatureStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_PanelTemperatureStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Temperature"

    static const int kTemperature = 0;

    /**
     * Clears the field "Temperature".
     *
     * The field will be set to its default value. The hasTemperature()
     * method will return false.
     */
    inline void clearTemperature();

    /**
     * Checks whether the field "Temperature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTemperature()). Otherwise it will return false.
     */
    inline bool hasTemperature () const;

    /**
     * Returns the value of the member "Temperature".
     *
     * Display panel temperature
     *
     * @return The value of the field "Temperature"
     */
    inline ::dimming_main_fi_types::T_s16_DIM_Temperature getTemperature () const;

    /**
     * Sets the value of the member "Temperature".
     *
     * Display panel temperature
     *
     * @param Temperature The value which will be set
     */
    inline void setTemperature (::dimming_main_fi_types::T_s16_DIM_Temperature Temperature_);

    static const DIM_DISP_PanelTemperatureStatus &getDefaultInstance();

private:

    inline void set_has_Temperature ();

    inline void clear_has_Temperature ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_s16_DIM_Temperature _Temperature;

};

/**
 * The error message of 'DIM_DISP_PanelTemperature'
 */
class DIM_DISP_PanelTemperatureErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_PanelTemperatureErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_PanelTemperatureErrorStructure (const DIM_DISP_PanelTemperatureErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_PanelTemperatureErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_PanelTemperatureErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_PanelTemperatureErrorStructure& operator = (const DIM_DISP_PanelTemperatureErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_PanelTemperatureErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_PanelTemperatureErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_PanelTemperatureErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_PanelTemperatureErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_PanelTemperatureErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_PanelTemperature'
 */
class DIM_DISP_PanelTemperatureError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_PanelTemperatureErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_PanelTemperatureError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_PanelTemperatureError (const DIM_DISP_PanelTemperatureError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_PanelTemperatureError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_PanelTemperatureError& operator = (const DIM_DISP_PanelTemperatureError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_PanelTemperatureError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_PanelTemperatureError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_PanelTemperatureError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_PanelTemperatureError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_PanelTemperatureError::DIM_DISP_PanelTemperatureErrorField getField () const;

    inline void setField(DIM_DISP_PanelTemperatureError::DIM_DISP_PanelTemperatureErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_PanelTemperatureErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_PanelTemperatureErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_PanelTemperatureErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_PanelTemperatureErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_PanelTemperatureErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_PanelTemperatureErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_PanelTemperatureErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_PanelTemperatureErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_PanelTemperatureError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_PanelTemperatureError& rhs);

    inline void deleteData ();

    DIM_DISP_PanelTemperatureErrorField __field;

    union {
        DIM_DISP_PanelTemperatureErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DISP_BrightnessLevelExtended"
 * <p>Provides the current active extended display brightness level</p>
 * <p>While the "normal" brightness level is limited to 5 levels this extended level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! Nissan LCN2Kai supports for example currently only the levels 0..18!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_BrightnessLevelExtendedStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_BrightnessLevelExtendedStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_BrightnessLevelExtendedStatus (const DIM_DISP_BrightnessLevelExtendedStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_BrightnessLevelExtendedStatus (uint8 BrightnessLevelExtended_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_BrightnessLevelExtendedStatus();

    /**
     * Assignment operator
     */
    inline DIM_DISP_BrightnessLevelExtendedStatus& operator = (const DIM_DISP_BrightnessLevelExtendedStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_BrightnessLevelExtendedStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_BrightnessLevelExtendedStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_BrightnessLevelExtendedStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_BrightnessLevelExtendedStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BrightnessLevelExtended"

    static const int kBrightnessLevelExtended = 0;

    /**
     * Clears the field "BrightnessLevelExtended".
     *
     * The field will be set to its default value. The hasBrightnessLevelExtended()
     * method will return false.
     */
    inline void clearBrightnessLevelExtended();

    /**
     * Checks whether the field "BrightnessLevelExtended" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrightnessLevelExtended()). Otherwise it will return false.
     */
    inline bool hasBrightnessLevelExtended () const;

    /**
     * Returns the value of the member "BrightnessLevelExtended".
     *
     * Provides the current extended display brightness level (0..255).
     * Attention: For Nissan LCN2Kai the range is limited to 0..18!
     *
     * @return The value of the field "BrightnessLevelExtended"
     */
    inline uint8 getBrightnessLevelExtended () const;

    /**
     * Sets the value of the member "BrightnessLevelExtended".
     *
     * Provides the current extended display brightness level (0..255).
     * Attention: For Nissan LCN2Kai the range is limited to 0..18!
     *
     * @param BrightnessLevelExtended The value which will be set
     */
    inline void setBrightnessLevelExtended (uint8 BrightnessLevelExtended_);

    static const DIM_DISP_BrightnessLevelExtendedStatus &getDefaultInstance();

private:

    inline void set_has_BrightnessLevelExtended ();

    inline void clear_has_BrightnessLevelExtended ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _BrightnessLevelExtended;

};

/**
 * The error message of 'DIM_DISP_BrightnessLevelExtended'
 */
class DIM_DISP_BrightnessLevelExtendedErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_BrightnessLevelExtendedErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_BrightnessLevelExtendedErrorStructure (const DIM_DISP_BrightnessLevelExtendedErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_BrightnessLevelExtendedErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_BrightnessLevelExtendedErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_BrightnessLevelExtendedErrorStructure& operator = (const DIM_DISP_BrightnessLevelExtendedErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_BrightnessLevelExtendedErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_BrightnessLevelExtendedErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_BrightnessLevelExtendedErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_BrightnessLevelExtendedErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_BrightnessLevelExtendedErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_BrightnessLevelExtended'
 */
class DIM_DISP_BrightnessLevelExtendedError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_BrightnessLevelExtendedErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_BrightnessLevelExtendedError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_BrightnessLevelExtendedError (const DIM_DISP_BrightnessLevelExtendedError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_BrightnessLevelExtendedError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_BrightnessLevelExtendedError& operator = (const DIM_DISP_BrightnessLevelExtendedError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_BrightnessLevelExtendedError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_BrightnessLevelExtendedError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_BrightnessLevelExtendedError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_BrightnessLevelExtendedError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_BrightnessLevelExtendedError::DIM_DISP_BrightnessLevelExtendedErrorField getField () const;

    inline void setField(DIM_DISP_BrightnessLevelExtendedError::DIM_DISP_BrightnessLevelExtendedErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_BrightnessLevelExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_BrightnessLevelExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_BrightnessLevelExtendedErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_BrightnessLevelExtendedErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_BrightnessLevelExtendedErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_BrightnessLevelExtendedErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_BrightnessLevelExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_BrightnessLevelExtendedErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_BrightnessLevelExtendedError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_BrightnessLevelExtendedError& rhs);

    inline void deleteData ();

    DIM_DISP_BrightnessLevelExtendedErrorField __field;

    union {
        DIM_DISP_BrightnessLevelExtendedErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DISP_VideoBrightnessLevel"
 * <p>Provides the current active video brightness level</p>
 * <p>Valid values are 0..18 and 255!</p>
 * <p>---</p>
 * <p>Check the description of DIM_DISP_SetVideoBrightnessLevel for a more detailed explanation</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_VideoBrightnessLevelStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_VideoBrightnessLevelStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_VideoBrightnessLevelStatus (const DIM_DISP_VideoBrightnessLevelStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_VideoBrightnessLevelStatus (uint8 VideoBrightnessLevel_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_VideoBrightnessLevelStatus();

    /**
     * Assignment operator
     */
    inline DIM_DISP_VideoBrightnessLevelStatus& operator = (const DIM_DISP_VideoBrightnessLevelStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_VideoBrightnessLevelStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_VideoBrightnessLevelStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_VideoBrightnessLevelStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_VideoBrightnessLevelStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VideoBrightnessLevel"

    static const int kVideoBrightnessLevel = 0;

    /**
     * Clears the field "VideoBrightnessLevel".
     *
     * The field will be set to its default value. The hasVideoBrightnessLevel()
     * method will return false.
     */
    inline void clearVideoBrightnessLevel();

    /**
     * Checks whether the field "VideoBrightnessLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVideoBrightnessLevel()). Otherwise it will return false.
     */
    inline bool hasVideoBrightnessLevel () const;

    /**
     * Returns the value of the member "VideoBrightnessLevel".
     *
     * <p>Provides the current extended display brightness level in video brightness mode (0..255).</p>
     * <p>Valid values are 0..18 and 255!</p>
     * <p>With 0 being the darkest, 9 the medium and 18 being the brightest level.</p>
     * <p>In addition 0..18 means also that the video brightness mode is active, 255 means video brightness mode is inactive</p>
     *
     * @return The value of the field "VideoBrightnessLevel"
     */
    inline uint8 getVideoBrightnessLevel () const;

    /**
     * Sets the value of the member "VideoBrightnessLevel".
     *
     * <p>Provides the current extended display brightness level in video brightness mode (0..255).</p>
     * <p>Valid values are 0..18 and 255!</p>
     * <p>With 0 being the darkest, 9 the medium and 18 being the brightest level.</p>
     * <p>In addition 0..18 means also that the video brightness mode is active, 255 means video brightness mode is inactive</p>
     *
     * @param VideoBrightnessLevel The value which will be set
     */
    inline void setVideoBrightnessLevel (uint8 VideoBrightnessLevel_);

    static const DIM_DISP_VideoBrightnessLevelStatus &getDefaultInstance();

private:

    inline void set_has_VideoBrightnessLevel ();

    inline void clear_has_VideoBrightnessLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _VideoBrightnessLevel;

};

/**
 * The error message of 'DIM_DISP_VideoBrightnessLevel'
 */
class DIM_DISP_VideoBrightnessLevelErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_VideoBrightnessLevelErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_VideoBrightnessLevelErrorStructure (const DIM_DISP_VideoBrightnessLevelErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_VideoBrightnessLevelErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_VideoBrightnessLevelErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_VideoBrightnessLevelErrorStructure& operator = (const DIM_DISP_VideoBrightnessLevelErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_VideoBrightnessLevelErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_VideoBrightnessLevelErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_VideoBrightnessLevelErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_VideoBrightnessLevelErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_VideoBrightnessLevelErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_VideoBrightnessLevel'
 */
class DIM_DISP_VideoBrightnessLevelError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_VideoBrightnessLevelErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_VideoBrightnessLevelError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_VideoBrightnessLevelError (const DIM_DISP_VideoBrightnessLevelError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_VideoBrightnessLevelError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_VideoBrightnessLevelError& operator = (const DIM_DISP_VideoBrightnessLevelError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_VideoBrightnessLevelError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_VideoBrightnessLevelError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_VideoBrightnessLevelError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_VideoBrightnessLevelError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_VideoBrightnessLevelError::DIM_DISP_VideoBrightnessLevelErrorField getField () const;

    inline void setField(DIM_DISP_VideoBrightnessLevelError::DIM_DISP_VideoBrightnessLevelErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_VideoBrightnessLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_VideoBrightnessLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_VideoBrightnessLevelErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_VideoBrightnessLevelErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_VideoBrightnessLevelErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_VideoBrightnessLevelErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_VideoBrightnessLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_VideoBrightnessLevelErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_VideoBrightnessLevelError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_VideoBrightnessLevelError& rhs);

    inline void deleteData ();

    DIM_DISP_VideoBrightnessLevelErrorField __field;

    union {
        DIM_DISP_VideoBrightnessLevelErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DISP_ContrastLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use property DIM_DISP_CSCContrastLevel!</p>
 * <p>---</p>
 * <p>Provides the current active contrast level</p>
 * <p>Contrast level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_ContrastLevelStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_ContrastLevelStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_ContrastLevelStatus (const DIM_DISP_ContrastLevelStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_ContrastLevelStatus (uint8 Contrast_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_ContrastLevelStatus();

    /**
     * Assignment operator
     */
    inline DIM_DISP_ContrastLevelStatus& operator = (const DIM_DISP_ContrastLevelStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_ContrastLevelStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_ContrastLevelStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_ContrastLevelStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_ContrastLevelStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Contrast"

    static const int kContrast = 0;

    /**
     * Clears the field "Contrast".
     *
     * The field will be set to its default value. The hasContrast()
     * method will return false.
     */
    inline void clearContrast();

    /**
     * Checks whether the field "Contrast" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setContrast()). Otherwise it will return false.
     */
    inline bool hasContrast () const;

    /**
     * Returns the value of the member "Contrast".
     *
     * Provides the current contrast level (0..255).
     * Attention: For AIVI the range is limited to 0..32!
     *
     * @return The value of the field "Contrast"
     */
    inline uint8 getContrast () const;

    /**
     * Sets the value of the member "Contrast".
     *
     * Provides the current contrast level (0..255).
     * Attention: For AIVI the range is limited to 0..32!
     *
     * @param Contrast The value which will be set
     */
    inline void setContrast (uint8 Contrast_);

    static const DIM_DISP_ContrastLevelStatus &getDefaultInstance();

private:

    inline void set_has_Contrast ();

    inline void clear_has_Contrast ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Contrast;

};

/**
 * The error message of 'DIM_DISP_ContrastLevel'
 */
class DIM_DISP_ContrastLevelErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_ContrastLevelErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_ContrastLevelErrorStructure (const DIM_DISP_ContrastLevelErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_ContrastLevelErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_ContrastLevelErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_ContrastLevelErrorStructure& operator = (const DIM_DISP_ContrastLevelErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_ContrastLevelErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_ContrastLevelErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_ContrastLevelErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_ContrastLevelErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_ContrastLevelErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_ContrastLevel'
 */
class DIM_DISP_ContrastLevelError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_ContrastLevelErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_ContrastLevelError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_ContrastLevelError (const DIM_DISP_ContrastLevelError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_ContrastLevelError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_ContrastLevelError& operator = (const DIM_DISP_ContrastLevelError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_ContrastLevelError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_ContrastLevelError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_ContrastLevelError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_ContrastLevelError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_ContrastLevelError::DIM_DISP_ContrastLevelErrorField getField () const;

    inline void setField(DIM_DISP_ContrastLevelError::DIM_DISP_ContrastLevelErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_ContrastLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_ContrastLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_ContrastLevelErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_ContrastLevelErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_ContrastLevelErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_ContrastLevelErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_ContrastLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_ContrastLevelErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_ContrastLevelError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_ContrastLevelError& rhs);

    inline void deleteData ();

    DIM_DISP_ContrastLevelErrorField __field;

    union {
        DIM_DISP_ContrastLevelErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DISP_BlackLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use property DIM_DISP_CSCBlackLevel!</p>
 * <p>---</p>
 * <p>Provides the current active black level</p>
 * <p>Contrast level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_BlackLevelStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_BlackLevelStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_BlackLevelStatus (const DIM_DISP_BlackLevelStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_BlackLevelStatus (uint8 BlackLevel_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_BlackLevelStatus();

    /**
     * Assignment operator
     */
    inline DIM_DISP_BlackLevelStatus& operator = (const DIM_DISP_BlackLevelStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_BlackLevelStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_BlackLevelStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_BlackLevelStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_BlackLevelStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BlackLevel"

    static const int kBlackLevel = 0;

    /**
     * Clears the field "BlackLevel".
     *
     * The field will be set to its default value. The hasBlackLevel()
     * method will return false.
     */
    inline void clearBlackLevel();

    /**
     * Checks whether the field "BlackLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBlackLevel()). Otherwise it will return false.
     */
    inline bool hasBlackLevel () const;

    /**
     * Returns the value of the member "BlackLevel".
     *
     * Provides the current black level (0..255).
     * Attention: For AIVI the range is limited to 0..32!
     *
     * @return The value of the field "BlackLevel"
     */
    inline uint8 getBlackLevel () const;

    /**
     * Sets the value of the member "BlackLevel".
     *
     * Provides the current black level (0..255).
     * Attention: For AIVI the range is limited to 0..32!
     *
     * @param BlackLevel The value which will be set
     */
    inline void setBlackLevel (uint8 BlackLevel_);

    static const DIM_DISP_BlackLevelStatus &getDefaultInstance();

private:

    inline void set_has_BlackLevel ();

    inline void clear_has_BlackLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _BlackLevel;

};

/**
 * The error message of 'DIM_DISP_BlackLevel'
 */
class DIM_DISP_BlackLevelErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_BlackLevelErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_BlackLevelErrorStructure (const DIM_DISP_BlackLevelErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_BlackLevelErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_BlackLevelErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_BlackLevelErrorStructure& operator = (const DIM_DISP_BlackLevelErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_BlackLevelErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_BlackLevelErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_BlackLevelErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_BlackLevelErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_BlackLevelErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_BlackLevel'
 */
class DIM_DISP_BlackLevelError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_BlackLevelErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_BlackLevelError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_BlackLevelError (const DIM_DISP_BlackLevelError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_BlackLevelError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_BlackLevelError& operator = (const DIM_DISP_BlackLevelError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_BlackLevelError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_BlackLevelError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_BlackLevelError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_BlackLevelError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_BlackLevelError::DIM_DISP_BlackLevelErrorField getField () const;

    inline void setField(DIM_DISP_BlackLevelError::DIM_DISP_BlackLevelErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_BlackLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_BlackLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_BlackLevelErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_BlackLevelErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_BlackLevelErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_BlackLevelErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_BlackLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_BlackLevelErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_BlackLevelError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_BlackLevelError& rhs);

    inline void deleteData ();

    DIM_DISP_BlackLevelErrorField __field;

    union {
        DIM_DISP_BlackLevelErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DISP_YCurveLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use property DIM_DISP_CSCGammaLevel!</p>
 * <p>---</p>
 * <p>Provides the current active Y-Curve level</p>
 * <p>Y Curve level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_YCurveLevelStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_YCurveLevelStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_YCurveLevelStatus (const DIM_DISP_YCurveLevelStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_YCurveLevelStatus (uint8 YCurveLevel_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_YCurveLevelStatus();

    /**
     * Assignment operator
     */
    inline DIM_DISP_YCurveLevelStatus& operator = (const DIM_DISP_YCurveLevelStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_YCurveLevelStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_YCurveLevelStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_YCurveLevelStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_YCurveLevelStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "YCurveLevel"

    static const int kYCurveLevel = 0;

    /**
     * Clears the field "YCurveLevel".
     *
     * The field will be set to its default value. The hasYCurveLevel()
     * method will return false.
     */
    inline void clearYCurveLevel();

    /**
     * Checks whether the field "YCurveLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setYCurveLevel()). Otherwise it will return false.
     */
    inline bool hasYCurveLevel () const;

    /**
     * Returns the value of the member "YCurveLevel".
     *
     * Provides the current YCurve level (0..255).
     * Attention: For AIVI the range is limited to 0..32!
     *
     * @return The value of the field "YCurveLevel"
     */
    inline uint8 getYCurveLevel () const;

    /**
     * Sets the value of the member "YCurveLevel".
     *
     * Provides the current YCurve level (0..255).
     * Attention: For AIVI the range is limited to 0..32!
     *
     * @param YCurveLevel The value which will be set
     */
    inline void setYCurveLevel (uint8 YCurveLevel_);

    static const DIM_DISP_YCurveLevelStatus &getDefaultInstance();

private:

    inline void set_has_YCurveLevel ();

    inline void clear_has_YCurveLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _YCurveLevel;

};

/**
 * The error message of 'DIM_DISP_YCurveLevel'
 */
class DIM_DISP_YCurveLevelErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_YCurveLevelErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_YCurveLevelErrorStructure (const DIM_DISP_YCurveLevelErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_YCurveLevelErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_YCurveLevelErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_YCurveLevelErrorStructure& operator = (const DIM_DISP_YCurveLevelErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_YCurveLevelErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_YCurveLevelErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_YCurveLevelErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_YCurveLevelErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_YCurveLevelErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_YCurveLevel'
 */
class DIM_DISP_YCurveLevelError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_YCurveLevelErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_YCurveLevelError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_YCurveLevelError (const DIM_DISP_YCurveLevelError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_YCurveLevelError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_YCurveLevelError& operator = (const DIM_DISP_YCurveLevelError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_YCurveLevelError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_YCurveLevelError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_YCurveLevelError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_YCurveLevelError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_YCurveLevelError::DIM_DISP_YCurveLevelErrorField getField () const;

    inline void setField(DIM_DISP_YCurveLevelError::DIM_DISP_YCurveLevelErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_YCurveLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_YCurveLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_YCurveLevelErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_YCurveLevelErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_YCurveLevelErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_YCurveLevelErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_YCurveLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_YCurveLevelErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_YCurveLevelError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_YCurveLevelError& rhs);

    inline void deleteData ();

    DIM_DISP_YCurveLevelErrorField __field;

    union {
        DIM_DISP_YCurveLevelErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DISP_TintLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use property DIM_DISP_CSCSaturationLevel!</p>
 * <p>---</p>
 * <p>Provides the current active tint level</p>
 * <p>Tint level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_TintLevelStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_TintLevelStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_TintLevelStatus (const DIM_DISP_TintLevelStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_TintLevelStatus (uint8 TintLevel_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_TintLevelStatus();

    /**
     * Assignment operator
     */
    inline DIM_DISP_TintLevelStatus& operator = (const DIM_DISP_TintLevelStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_TintLevelStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_TintLevelStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_TintLevelStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_TintLevelStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TintLevel"

    static const int kTintLevel = 0;

    /**
     * Clears the field "TintLevel".
     *
     * The field will be set to its default value. The hasTintLevel()
     * method will return false.
     */
    inline void clearTintLevel();

    /**
     * Checks whether the field "TintLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTintLevel()). Otherwise it will return false.
     */
    inline bool hasTintLevel () const;

    /**
     * Returns the value of the member "TintLevel".
     *
     * Provides the current tint level (0..255).
     * Attention: For AIVI the range is limited to 0..32!
     *
     * @return The value of the field "TintLevel"
     */
    inline uint8 getTintLevel () const;

    /**
     * Sets the value of the member "TintLevel".
     *
     * Provides the current tint level (0..255).
     * Attention: For AIVI the range is limited to 0..32!
     *
     * @param TintLevel The value which will be set
     */
    inline void setTintLevel (uint8 TintLevel_);

    static const DIM_DISP_TintLevelStatus &getDefaultInstance();

private:

    inline void set_has_TintLevel ();

    inline void clear_has_TintLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _TintLevel;

};

/**
 * The error message of 'DIM_DISP_TintLevel'
 */
class DIM_DISP_TintLevelErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_TintLevelErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_TintLevelErrorStructure (const DIM_DISP_TintLevelErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_TintLevelErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_TintLevelErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_TintLevelErrorStructure& operator = (const DIM_DISP_TintLevelErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_TintLevelErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_TintLevelErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_TintLevelErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_TintLevelErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_TintLevelErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_TintLevel'
 */
class DIM_DISP_TintLevelError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_TintLevelErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_TintLevelError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_TintLevelError (const DIM_DISP_TintLevelError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_TintLevelError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_TintLevelError& operator = (const DIM_DISP_TintLevelError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_TintLevelError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_TintLevelError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_TintLevelError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_TintLevelError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_TintLevelError::DIM_DISP_TintLevelErrorField getField () const;

    inline void setField(DIM_DISP_TintLevelError::DIM_DISP_TintLevelErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_TintLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_TintLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_TintLevelErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_TintLevelErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_TintLevelErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_TintLevelErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_TintLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_TintLevelErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_TintLevelError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_TintLevelError& rhs);

    inline void deleteData ();

    DIM_DISP_TintLevelErrorField __field;

    union {
        DIM_DISP_TintLevelErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DISP_ColorLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use property DIM_DISP_CSCColorLevel!</p>
 * <p>---</p>
 * <p>Provides the current active color level</p>
 * <p>Color level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_ColorLevelStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_ColorLevelStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_ColorLevelStatus (const DIM_DISP_ColorLevelStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_ColorLevelStatus (uint8 Color_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_ColorLevelStatus();

    /**
     * Assignment operator
     */
    inline DIM_DISP_ColorLevelStatus& operator = (const DIM_DISP_ColorLevelStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_ColorLevelStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_ColorLevelStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_ColorLevelStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_ColorLevelStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Color"

    static const int kColor = 0;

    /**
     * Clears the field "Color".
     *
     * The field will be set to its default value. The hasColor()
     * method will return false.
     */
    inline void clearColor();

    /**
     * Checks whether the field "Color" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setColor()). Otherwise it will return false.
     */
    inline bool hasColor () const;

    /**
     * Returns the value of the member "Color".
     *
     * Provides the current color level (0..255).
     * Attention: For AIVI the range is limited to 0..32!
     *
     * @return The value of the field "Color"
     */
    inline uint8 getColor () const;

    /**
     * Sets the value of the member "Color".
     *
     * Provides the current color level (0..255).
     * Attention: For AIVI the range is limited to 0..32!
     *
     * @param Color The value which will be set
     */
    inline void setColor (uint8 Color_);

    static const DIM_DISP_ColorLevelStatus &getDefaultInstance();

private:

    inline void set_has_Color ();

    inline void clear_has_Color ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Color;

};

/**
 * The error message of 'DIM_DISP_ColorLevel'
 */
class DIM_DISP_ColorLevelErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_ColorLevelErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_ColorLevelErrorStructure (const DIM_DISP_ColorLevelErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_ColorLevelErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_ColorLevelErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_ColorLevelErrorStructure& operator = (const DIM_DISP_ColorLevelErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_ColorLevelErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_ColorLevelErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_ColorLevelErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_ColorLevelErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_ColorLevelErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_ColorLevel'
 */
class DIM_DISP_ColorLevelError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_ColorLevelErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_ColorLevelError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_ColorLevelError (const DIM_DISP_ColorLevelError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_ColorLevelError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_ColorLevelError& operator = (const DIM_DISP_ColorLevelError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_ColorLevelError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_ColorLevelError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_ColorLevelError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_ColorLevelError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_ColorLevelError::DIM_DISP_ColorLevelErrorField getField () const;

    inline void setField(DIM_DISP_ColorLevelError::DIM_DISP_ColorLevelErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_ColorLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_ColorLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_ColorLevelErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_ColorLevelErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_ColorLevelErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_ColorLevelErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_ColorLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_ColorLevelErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_ColorLevelError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_ColorLevelError& rhs);

    inline void deleteData ();

    DIM_DISP_ColorLevelErrorField __field;

    union {
        DIM_DISP_ColorLevelErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DISP_DAY_LUMINOSITY_OFFSET"
 * <p>Provides the current active display brightness level for Day from HMI</p>
 * <p>Available starting with FI 3.0!</p>
 */
class DIM_DISP_DAY_LUMINOSITY_OFFSETStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_DAY_LUMINOSITY_OFFSETStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_DAY_LUMINOSITY_OFFSETStatus (const DIM_DISP_DAY_LUMINOSITY_OFFSETStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_DAY_LUMINOSITY_OFFSETStatus (uint8 DayLuminosityOffset_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_DAY_LUMINOSITY_OFFSETStatus();

    /**
     * Assignment operator
     */
    inline DIM_DISP_DAY_LUMINOSITY_OFFSETStatus& operator = (const DIM_DISP_DAY_LUMINOSITY_OFFSETStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_DAY_LUMINOSITY_OFFSETStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_DAY_LUMINOSITY_OFFSETStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_DAY_LUMINOSITY_OFFSETStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_DAY_LUMINOSITY_OFFSETStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DayLuminosityOffset"

    static const int kDayLuminosityOffset = 0;

    /**
     * Clears the field "DayLuminosityOffset".
     *
     * The field will be set to its default value. The hasDayLuminosityOffset()
     * method will return false.
     */
    inline void clearDayLuminosityOffset();

    /**
     * Checks whether the field "DayLuminosityOffset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDayLuminosityOffset()). Otherwise it will return false.
     */
    inline bool hasDayLuminosityOffset () const;

    /**
     * Returns the value of the member "DayLuminosityOffset".
     *
     * Provides the current active display brightness level for Day from HMI(0..21)
     *
     * @return The value of the field "DayLuminosityOffset"
     */
    inline uint8 getDayLuminosityOffset () const;

    /**
     * Sets the value of the member "DayLuminosityOffset".
     *
     * Provides the current active display brightness level for Day from HMI(0..21)
     *
     * @param DayLuminosityOffset The value which will be set
     */
    inline void setDayLuminosityOffset (uint8 DayLuminosityOffset_);

    static const DIM_DISP_DAY_LUMINOSITY_OFFSETStatus &getDefaultInstance();

private:

    inline void set_has_DayLuminosityOffset ();

    inline void clear_has_DayLuminosityOffset ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _DayLuminosityOffset;

};

/**
 * The set message of the property "DIM_DISP_DAY_LUMINOSITY_OFFSET"
 * <p>Provides the current active display brightness level for Day from HMI</p>
 * <p>Available starting with FI 3.0!</p>
 * Set the brightness level for HMI Day Lumisoity level
 */
class DIM_DISP_DAY_LUMINOSITY_OFFSETSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_DAY_LUMINOSITY_OFFSETSet ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_DAY_LUMINOSITY_OFFSETSet (const DIM_DISP_DAY_LUMINOSITY_OFFSETSet &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_DAY_LUMINOSITY_OFFSETSet (uint8 DayLuminosityOffset_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_DAY_LUMINOSITY_OFFSETSet();

    /**
     * Assignment operator
     */
    inline DIM_DISP_DAY_LUMINOSITY_OFFSETSet& operator = (const DIM_DISP_DAY_LUMINOSITY_OFFSETSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_DAY_LUMINOSITY_OFFSETSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_DAY_LUMINOSITY_OFFSETSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_DAY_LUMINOSITY_OFFSETSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_DAY_LUMINOSITY_OFFSETSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DayLuminosityOffset"

    static const int kDayLuminosityOffset = 0;

    /**
     * Clears the field "DayLuminosityOffset".
     *
     * The field will be set to its default value. The hasDayLuminosityOffset()
     * method will return false.
     */
    inline void clearDayLuminosityOffset();

    /**
     * Checks whether the field "DayLuminosityOffset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDayLuminosityOffset()). Otherwise it will return false.
     */
    inline bool hasDayLuminosityOffset () const;

    /**
     * Returns the value of the member "DayLuminosityOffset".
     *
     * Provides the current HMI Slider Value (0..21).
     *
     * @return The value of the field "DayLuminosityOffset"
     */
    inline uint8 getDayLuminosityOffset () const;

    /**
     * Sets the value of the member "DayLuminosityOffset".
     *
     * Provides the current HMI Slider Value (0..21).
     *
     * @param DayLuminosityOffset The value which will be set
     */
    inline void setDayLuminosityOffset (uint8 DayLuminosityOffset_);

    static const DIM_DISP_DAY_LUMINOSITY_OFFSETSet &getDefaultInstance();

private:

    inline void set_has_DayLuminosityOffset ();

    inline void clear_has_DayLuminosityOffset ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _DayLuminosityOffset;

};

/**
 * The error message of 'DIM_DISP_DAY_LUMINOSITY_OFFSET'
 */
class DIM_DISP_DAY_LUMINOSITY_OFFSETErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_DAY_LUMINOSITY_OFFSETErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_DAY_LUMINOSITY_OFFSETErrorStructure (const DIM_DISP_DAY_LUMINOSITY_OFFSETErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_DAY_LUMINOSITY_OFFSETErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_DAY_LUMINOSITY_OFFSETErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_DAY_LUMINOSITY_OFFSETErrorStructure& operator = (const DIM_DISP_DAY_LUMINOSITY_OFFSETErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_DAY_LUMINOSITY_OFFSETErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_DAY_LUMINOSITY_OFFSETErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_DAY_LUMINOSITY_OFFSETErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_DAY_LUMINOSITY_OFFSETErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_DAY_LUMINOSITY_OFFSETErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_DAY_LUMINOSITY_OFFSET'
 */
class DIM_DISP_DAY_LUMINOSITY_OFFSETError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_DAY_LUMINOSITY_OFFSETErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_DAY_LUMINOSITY_OFFSETError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_DAY_LUMINOSITY_OFFSETError (const DIM_DISP_DAY_LUMINOSITY_OFFSETError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_DAY_LUMINOSITY_OFFSETError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_DAY_LUMINOSITY_OFFSETError& operator = (const DIM_DISP_DAY_LUMINOSITY_OFFSETError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_DAY_LUMINOSITY_OFFSETError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_DAY_LUMINOSITY_OFFSETError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_DAY_LUMINOSITY_OFFSETError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_DAY_LUMINOSITY_OFFSETError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_DAY_LUMINOSITY_OFFSETError::DIM_DISP_DAY_LUMINOSITY_OFFSETErrorField getField () const;

    inline void setField(DIM_DISP_DAY_LUMINOSITY_OFFSETError::DIM_DISP_DAY_LUMINOSITY_OFFSETErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_DAY_LUMINOSITY_OFFSETErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_DAY_LUMINOSITY_OFFSETErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_DAY_LUMINOSITY_OFFSETErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_DAY_LUMINOSITY_OFFSETErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_DAY_LUMINOSITY_OFFSETErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_DAY_LUMINOSITY_OFFSETErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_DAY_LUMINOSITY_OFFSETErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_DAY_LUMINOSITY_OFFSETErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_DAY_LUMINOSITY_OFFSETError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_DAY_LUMINOSITY_OFFSETError& rhs);

    inline void deleteData ();

    DIM_DISP_DAY_LUMINOSITY_OFFSETErrorField __field;

    union {
        DIM_DISP_DAY_LUMINOSITY_OFFSETErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DISP_NIGHT_LUMINOSITY_OFFSET"
 * <p>Provides the current active display brightness level for Night from HMI</p>
 * <p>Available starting with FI 3.0!</p>
 */
class DIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus (uint8 NightLuminosityOffset_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus();

    /**
     * Assignment operator
     */
    inline DIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus& operator = (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NightLuminosityOffset"

    static const int kNightLuminosityOffset = 0;

    /**
     * Clears the field "NightLuminosityOffset".
     *
     * The field will be set to its default value. The hasNightLuminosityOffset()
     * method will return false.
     */
    inline void clearNightLuminosityOffset();

    /**
     * Checks whether the field "NightLuminosityOffset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNightLuminosityOffset()). Otherwise it will return false.
     */
    inline bool hasNightLuminosityOffset () const;

    /**
     * Returns the value of the member "NightLuminosityOffset".
     *
     * Provides the current active display brightness level for Night from HMI
     *
     * @return The value of the field "NightLuminosityOffset"
     */
    inline uint8 getNightLuminosityOffset () const;

    /**
     * Sets the value of the member "NightLuminosityOffset".
     *
     * Provides the current active display brightness level for Night from HMI
     *
     * @param NightLuminosityOffset The value which will be set
     */
    inline void setNightLuminosityOffset (uint8 NightLuminosityOffset_);

    static const DIM_DISP_NIGHT_LUMINOSITY_OFFSETStatus &getDefaultInstance();

private:

    inline void set_has_NightLuminosityOffset ();

    inline void clear_has_NightLuminosityOffset ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _NightLuminosityOffset;

};

/**
 * The set message of the property "DIM_DISP_NIGHT_LUMINOSITY_OFFSET"
 * <p>Provides the current active display brightness level for Night from HMI</p>
 * <p>Available starting with FI 3.0!</p>
 * Set the brightness level for HMI Night Lumisoity level
 */
class DIM_DISP_NIGHT_LUMINOSITY_OFFSETSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_NIGHT_LUMINOSITY_OFFSETSet ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_NIGHT_LUMINOSITY_OFFSETSet (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETSet &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_NIGHT_LUMINOSITY_OFFSETSet (uint8 NightLuminosityOffset_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_NIGHT_LUMINOSITY_OFFSETSet();

    /**
     * Assignment operator
     */
    inline DIM_DISP_NIGHT_LUMINOSITY_OFFSETSet& operator = (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NightLuminosityOffset"

    static const int kNightLuminosityOffset = 0;

    /**
     * Clears the field "NightLuminosityOffset".
     *
     * The field will be set to its default value. The hasNightLuminosityOffset()
     * method will return false.
     */
    inline void clearNightLuminosityOffset();

    /**
     * Checks whether the field "NightLuminosityOffset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNightLuminosityOffset()). Otherwise it will return false.
     */
    inline bool hasNightLuminosityOffset () const;

    /**
     * Returns the value of the member "NightLuminosityOffset".
     *
     * NightLuminosityOffset Range (0..21)
     *
     * @return The value of the field "NightLuminosityOffset"
     */
    inline uint8 getNightLuminosityOffset () const;

    /**
     * Sets the value of the member "NightLuminosityOffset".
     *
     * NightLuminosityOffset Range (0..21)
     *
     * @param NightLuminosityOffset The value which will be set
     */
    inline void setNightLuminosityOffset (uint8 NightLuminosityOffset_);

    static const DIM_DISP_NIGHT_LUMINOSITY_OFFSETSet &getDefaultInstance();

private:

    inline void set_has_NightLuminosityOffset ();

    inline void clear_has_NightLuminosityOffset ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _NightLuminosityOffset;

};

/**
 * The error message of 'DIM_DISP_NIGHT_LUMINOSITY_OFFSET'
 */
class DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorStructure (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorStructure& operator = (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_NIGHT_LUMINOSITY_OFFSET'
 */
class DIM_DISP_NIGHT_LUMINOSITY_OFFSETError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_NIGHT_LUMINOSITY_OFFSETError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_NIGHT_LUMINOSITY_OFFSETError (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_NIGHT_LUMINOSITY_OFFSETError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_NIGHT_LUMINOSITY_OFFSETError& operator = (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_NIGHT_LUMINOSITY_OFFSETError::DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorField getField () const;

    inline void setField(DIM_DISP_NIGHT_LUMINOSITY_OFFSETError::DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_NIGHT_LUMINOSITY_OFFSETError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_NIGHT_LUMINOSITY_OFFSETError& rhs);

    inline void deleteData ();

    DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorField __field;

    union {
        DIM_DISP_NIGHT_LUMINOSITY_OFFSETErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DISP_COCKPIT_SLIDER_OFFSET"
 * <p>Provides the current offset for the Cockpit Dimming Slider which is enabled when A-IVI is the master level</p>
 * <p>Available starting with FI 3.0!</p>
 */
class DIM_DISP_COCKPIT_SLIDER_OFFSETStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_COCKPIT_SLIDER_OFFSETStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_COCKPIT_SLIDER_OFFSETStatus (const DIM_DISP_COCKPIT_SLIDER_OFFSETStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_COCKPIT_SLIDER_OFFSETStatus (uint8 CockpitDimmingSliderOffset_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_COCKPIT_SLIDER_OFFSETStatus();

    /**
     * Assignment operator
     */
    inline DIM_DISP_COCKPIT_SLIDER_OFFSETStatus& operator = (const DIM_DISP_COCKPIT_SLIDER_OFFSETStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_COCKPIT_SLIDER_OFFSETStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_COCKPIT_SLIDER_OFFSETStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_COCKPIT_SLIDER_OFFSETStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_COCKPIT_SLIDER_OFFSETStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CockpitDimmingSliderOffset"

    static const int kCockpitDimmingSliderOffset = 0;

    /**
     * Clears the field "CockpitDimmingSliderOffset".
     *
     * The field will be set to its default value. The hasCockpitDimmingSliderOffset()
     * method will return false.
     */
    inline void clearCockpitDimmingSliderOffset();

    /**
     * Checks whether the field "CockpitDimmingSliderOffset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCockpitDimmingSliderOffset()). Otherwise it will return false.
     */
    inline bool hasCockpitDimmingSliderOffset () const;

    /**
     * Returns the value of the member "CockpitDimmingSliderOffset".
     *
     * Provides the current offset for the Cockpit Dimming Slider which is enabled when A-IVI is the master level (0..21)
     *
     * @return The value of the field "CockpitDimmingSliderOffset"
     */
    inline uint8 getCockpitDimmingSliderOffset () const;

    /**
     * Sets the value of the member "CockpitDimmingSliderOffset".
     *
     * Provides the current offset for the Cockpit Dimming Slider which is enabled when A-IVI is the master level (0..21)
     *
     * @param CockpitDimmingSliderOffset The value which will be set
     */
    inline void setCockpitDimmingSliderOffset (uint8 CockpitDimmingSliderOffset_);

    static const DIM_DISP_COCKPIT_SLIDER_OFFSETStatus &getDefaultInstance();

private:

    inline void set_has_CockpitDimmingSliderOffset ();

    inline void clear_has_CockpitDimmingSliderOffset ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _CockpitDimmingSliderOffset;

};

/**
 * The set message of the property "DIM_DISP_COCKPIT_SLIDER_OFFSET"
 * <p>Provides the current offset for the Cockpit Dimming Slider which is enabled when A-IVI is the master level</p>
 * <p>Available starting with FI 3.0!</p>
 * Set the offset for Cockpit Dimming Slider Range: (0..21)
 */
class DIM_DISP_COCKPIT_SLIDER_OFFSETSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_COCKPIT_SLIDER_OFFSETSet ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_COCKPIT_SLIDER_OFFSETSet (const DIM_DISP_COCKPIT_SLIDER_OFFSETSet &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_COCKPIT_SLIDER_OFFSETSet (uint8 CockpitDimmingSliderOffset_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_COCKPIT_SLIDER_OFFSETSet();

    /**
     * Assignment operator
     */
    inline DIM_DISP_COCKPIT_SLIDER_OFFSETSet& operator = (const DIM_DISP_COCKPIT_SLIDER_OFFSETSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_COCKPIT_SLIDER_OFFSETSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_COCKPIT_SLIDER_OFFSETSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_COCKPIT_SLIDER_OFFSETSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_COCKPIT_SLIDER_OFFSETSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CockpitDimmingSliderOffset"

    static const int kCockpitDimmingSliderOffset = 0;

    /**
     * Clears the field "CockpitDimmingSliderOffset".
     *
     * The field will be set to its default value. The hasCockpitDimmingSliderOffset()
     * method will return false.
     */
    inline void clearCockpitDimmingSliderOffset();

    /**
     * Checks whether the field "CockpitDimmingSliderOffset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCockpitDimmingSliderOffset()). Otherwise it will return false.
     */
    inline bool hasCockpitDimmingSliderOffset () const;

    /**
     * Returns the value of the member "CockpitDimmingSliderOffset".
     *
     * CockpitDimmingSliderOffset Range (0..21)
     *
     * @return The value of the field "CockpitDimmingSliderOffset"
     */
    inline uint8 getCockpitDimmingSliderOffset () const;

    /**
     * Sets the value of the member "CockpitDimmingSliderOffset".
     *
     * CockpitDimmingSliderOffset Range (0..21)
     *
     * @param CockpitDimmingSliderOffset The value which will be set
     */
    inline void setCockpitDimmingSliderOffset (uint8 CockpitDimmingSliderOffset_);

    static const DIM_DISP_COCKPIT_SLIDER_OFFSETSet &getDefaultInstance();

private:

    inline void set_has_CockpitDimmingSliderOffset ();

    inline void clear_has_CockpitDimmingSliderOffset ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _CockpitDimmingSliderOffset;

};

/**
 * The error message of 'DIM_DISP_COCKPIT_SLIDER_OFFSET'
 */
class DIM_DISP_COCKPIT_SLIDER_OFFSETErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_COCKPIT_SLIDER_OFFSETErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_COCKPIT_SLIDER_OFFSETErrorStructure (const DIM_DISP_COCKPIT_SLIDER_OFFSETErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_COCKPIT_SLIDER_OFFSETErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_COCKPIT_SLIDER_OFFSETErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_COCKPIT_SLIDER_OFFSETErrorStructure& operator = (const DIM_DISP_COCKPIT_SLIDER_OFFSETErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_COCKPIT_SLIDER_OFFSETErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_COCKPIT_SLIDER_OFFSETErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_COCKPIT_SLIDER_OFFSETErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_COCKPIT_SLIDER_OFFSETErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_COCKPIT_SLIDER_OFFSETErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_COCKPIT_SLIDER_OFFSET'
 */
class DIM_DISP_COCKPIT_SLIDER_OFFSETError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_COCKPIT_SLIDER_OFFSETErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_COCKPIT_SLIDER_OFFSETError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_COCKPIT_SLIDER_OFFSETError (const DIM_DISP_COCKPIT_SLIDER_OFFSETError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_COCKPIT_SLIDER_OFFSETError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_COCKPIT_SLIDER_OFFSETError& operator = (const DIM_DISP_COCKPIT_SLIDER_OFFSETError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_COCKPIT_SLIDER_OFFSETError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_COCKPIT_SLIDER_OFFSETError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_COCKPIT_SLIDER_OFFSETError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_COCKPIT_SLIDER_OFFSETError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_COCKPIT_SLIDER_OFFSETError::DIM_DISP_COCKPIT_SLIDER_OFFSETErrorField getField () const;

    inline void setField(DIM_DISP_COCKPIT_SLIDER_OFFSETError::DIM_DISP_COCKPIT_SLIDER_OFFSETErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_COCKPIT_SLIDER_OFFSETErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_COCKPIT_SLIDER_OFFSETErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_COCKPIT_SLIDER_OFFSETErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_COCKPIT_SLIDER_OFFSETErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_COCKPIT_SLIDER_OFFSETErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_COCKPIT_SLIDER_OFFSETErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_COCKPIT_SLIDER_OFFSETErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_COCKPIT_SLIDER_OFFSETErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_COCKPIT_SLIDER_OFFSETError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_COCKPIT_SLIDER_OFFSETError& rhs);

    inline void deleteData ();

    DIM_DISP_COCKPIT_SLIDER_OFFSETErrorField __field;

    union {
        DIM_DISP_COCKPIT_SLIDER_OFFSETErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DIAG_Variant"
 * <p>Retrieve the current HW variant</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DIAG_VariantStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DIAG_VariantStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DIAG_VariantStatus (const DIM_DIAG_VariantStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DIAG_VariantStatus (uint8 Variant_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DIAG_VariantStatus();

    /**
     * Assignment operator
     */
    inline DIM_DIAG_VariantStatus& operator = (const DIM_DIAG_VariantStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DIAG_VariantStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DIAG_VariantStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DIAG_VariantStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DIAG_VariantStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Variant"

    static const int kVariant = 0;

    /**
     * Clears the field "Variant".
     *
     * The field will be set to its default value. The hasVariant()
     * method will return false.
     */
    inline void clearVariant();

    /**
     * Checks whether the field "Variant" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVariant()). Otherwise it will return false.
     */
    inline bool hasVariant () const;

    /**
     * Returns the value of the member "Variant".
     *
     * Hardware variant
     *
     * @return The value of the field "Variant"
     */
    inline uint8 getVariant () const;

    /**
     * Sets the value of the member "Variant".
     *
     * Hardware variant
     *
     * @param Variant The value which will be set
     */
    inline void setVariant (uint8 Variant_);

    static const DIM_DIAG_VariantStatus &getDefaultInstance();

private:

    inline void set_has_Variant ();

    inline void clear_has_Variant ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Variant;

};

/**
 * The error message of 'DIM_DIAG_Variant'
 */
class DIM_DIAG_VariantErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DIAG_VariantErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DIAG_VariantErrorStructure (const DIM_DIAG_VariantErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DIAG_VariantErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DIAG_VariantErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DIAG_VariantErrorStructure& operator = (const DIM_DIAG_VariantErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DIAG_VariantErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DIAG_VariantErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DIAG_VariantErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DIAG_VariantErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DIAG_VariantErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DIAG_Variant'
 */
class DIM_DIAG_VariantError  : public ::asf::core::Payload {
public:

    enum DIM_DIAG_VariantErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DIAG_VariantError ();

   /**
     * Copy constructor
     */
    inline  DIM_DIAG_VariantError (const DIM_DIAG_VariantError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DIAG_VariantError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DIAG_VariantError& operator = (const DIM_DIAG_VariantError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DIAG_VariantError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DIAG_VariantError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DIAG_VariantError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DIAG_VariantError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DIAG_VariantError::DIM_DIAG_VariantErrorField getField () const;

    inline void setField(DIM_DIAG_VariantError::DIM_DIAG_VariantErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DIAG_VariantErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DIAG_VariantErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DIAG_VariantErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DIAG_VariantErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DIAG_VariantErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DIAG_VariantErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DIAG_VariantErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DIAG_VariantErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DIAG_VariantError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DIAG_VariantError& rhs);

    inline void deleteData ();

    DIM_DIAG_VariantErrorField __field;

    union {
        DIM_DIAG_VariantErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DIAG_BrightnessInputType"
 * <p>Retrieve the current Brightness Input Type</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DIAG_BrightnessInputTypeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DIAG_BrightnessInputTypeStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DIAG_BrightnessInputTypeStatus (const DIM_DIAG_BrightnessInputTypeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DIAG_BrightnessInputTypeStatus (::dimming_main_fi_types::T_e8_DIM_InputConfiguration InputConfiguration_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DIAG_BrightnessInputTypeStatus();

    /**
     * Assignment operator
     */
    inline DIM_DIAG_BrightnessInputTypeStatus& operator = (const DIM_DIAG_BrightnessInputTypeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DIAG_BrightnessInputTypeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DIAG_BrightnessInputTypeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DIAG_BrightnessInputTypeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DIAG_BrightnessInputTypeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "InputConfiguration"

    static const int kInputConfiguration = 0;

    /**
     * Clears the field "InputConfiguration".
     *
     * The field will be set to its default value. The hasInputConfiguration()
     * method will return false.
     */
    inline void clearInputConfiguration();

    /**
     * Checks whether the field "InputConfiguration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInputConfiguration()). Otherwise it will return false.
     */
    inline bool hasInputConfiguration () const;

    /**
     * Returns the value of the member "InputConfiguration".
     *
     * Brightness input type configuration
     *
     * @return The value of the field "InputConfiguration"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_InputConfiguration getInputConfiguration () const;

    /**
     * Sets the value of the member "InputConfiguration".
     *
     * Brightness input type configuration
     *
     * @param InputConfiguration The value which will be set
     */
    inline void setInputConfiguration (::dimming_main_fi_types::T_e8_DIM_InputConfiguration InputConfiguration_);

    static const DIM_DIAG_BrightnessInputTypeStatus &getDefaultInstance();

private:

    inline void set_has_InputConfiguration ();

    inline void clear_has_InputConfiguration ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_e8_DIM_InputConfiguration _InputConfiguration;

};

/**
 * The error message of 'DIM_DIAG_BrightnessInputType'
 */
class DIM_DIAG_BrightnessInputTypeErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DIAG_BrightnessInputTypeErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DIAG_BrightnessInputTypeErrorStructure (const DIM_DIAG_BrightnessInputTypeErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DIAG_BrightnessInputTypeErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DIAG_BrightnessInputTypeErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DIAG_BrightnessInputTypeErrorStructure& operator = (const DIM_DIAG_BrightnessInputTypeErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DIAG_BrightnessInputTypeErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DIAG_BrightnessInputTypeErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DIAG_BrightnessInputTypeErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DIAG_BrightnessInputTypeErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DIAG_BrightnessInputTypeErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DIAG_BrightnessInputType'
 */
class DIM_DIAG_BrightnessInputTypeError  : public ::asf::core::Payload {
public:

    enum DIM_DIAG_BrightnessInputTypeErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DIAG_BrightnessInputTypeError ();

   /**
     * Copy constructor
     */
    inline  DIM_DIAG_BrightnessInputTypeError (const DIM_DIAG_BrightnessInputTypeError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DIAG_BrightnessInputTypeError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DIAG_BrightnessInputTypeError& operator = (const DIM_DIAG_BrightnessInputTypeError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DIAG_BrightnessInputTypeError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DIAG_BrightnessInputTypeError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DIAG_BrightnessInputTypeError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DIAG_BrightnessInputTypeError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DIAG_BrightnessInputTypeError::DIM_DIAG_BrightnessInputTypeErrorField getField () const;

    inline void setField(DIM_DIAG_BrightnessInputTypeError::DIM_DIAG_BrightnessInputTypeErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DIAG_BrightnessInputTypeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DIAG_BrightnessInputTypeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DIAG_BrightnessInputTypeErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DIAG_BrightnessInputTypeErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DIAG_BrightnessInputTypeErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DIAG_BrightnessInputTypeErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DIAG_BrightnessInputTypeErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DIAG_BrightnessInputTypeErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DIAG_BrightnessInputTypeError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DIAG_BrightnessInputTypeError& rhs);

    inline void deleteData ();

    DIM_DIAG_BrightnessInputTypeErrorField __field;

    union {
        DIM_DIAG_BrightnessInputTypeErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DISP_CSCContrastLevel"
 * <p>Provides the current active contrast level of color space conversion.</p>
 * <p>Contrast level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 */
class DIM_DISP_CSCContrastLevelStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_CSCContrastLevelStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_CSCContrastLevelStatus (const DIM_DISP_CSCContrastLevelStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_CSCContrastLevelStatus (uint8 ContrastLevel_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_CSCContrastLevelStatus();

    /**
     * Assignment operator
     */
    inline DIM_DISP_CSCContrastLevelStatus& operator = (const DIM_DISP_CSCContrastLevelStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_CSCContrastLevelStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_CSCContrastLevelStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_CSCContrastLevelStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_CSCContrastLevelStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ContrastLevel"

    static const int kContrastLevel = 0;

    /**
     * Clears the field "ContrastLevel".
     *
     * The field will be set to its default value. The hasContrastLevel()
     * method will return false.
     */
    inline void clearContrastLevel();

    /**
     * Checks whether the field "ContrastLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setContrastLevel()). Otherwise it will return false.
     */
    inline bool hasContrastLevel () const;

    /**
     * Returns the value of the member "ContrastLevel".
     *
     * Provides the current contrast level (0..255).
     * Attention: For AIVI the range is limited to 0..32!
     *
     * @return The value of the field "ContrastLevel"
     */
    inline uint8 getContrastLevel () const;

    /**
     * Sets the value of the member "ContrastLevel".
     *
     * Provides the current contrast level (0..255).
     * Attention: For AIVI the range is limited to 0..32!
     *
     * @param ContrastLevel The value which will be set
     */
    inline void setContrastLevel (uint8 ContrastLevel_);

    static const DIM_DISP_CSCContrastLevelStatus &getDefaultInstance();

private:

    inline void set_has_ContrastLevel ();

    inline void clear_has_ContrastLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ContrastLevel;

};

/**
 * The error message of 'DIM_DISP_CSCContrastLevel'
 */
class DIM_DISP_CSCContrastLevelErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_CSCContrastLevelErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_CSCContrastLevelErrorStructure (const DIM_DISP_CSCContrastLevelErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_CSCContrastLevelErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_CSCContrastLevelErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_CSCContrastLevelErrorStructure& operator = (const DIM_DISP_CSCContrastLevelErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_CSCContrastLevelErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_CSCContrastLevelErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_CSCContrastLevelErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_CSCContrastLevelErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_CSCContrastLevelErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_CSCContrastLevel'
 */
class DIM_DISP_CSCContrastLevelError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_CSCContrastLevelErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_CSCContrastLevelError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_CSCContrastLevelError (const DIM_DISP_CSCContrastLevelError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_CSCContrastLevelError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_CSCContrastLevelError& operator = (const DIM_DISP_CSCContrastLevelError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_CSCContrastLevelError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_CSCContrastLevelError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_CSCContrastLevelError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_CSCContrastLevelError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_CSCContrastLevelError::DIM_DISP_CSCContrastLevelErrorField getField () const;

    inline void setField(DIM_DISP_CSCContrastLevelError::DIM_DISP_CSCContrastLevelErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_CSCContrastLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_CSCContrastLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_CSCContrastLevelErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_CSCContrastLevelErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_CSCContrastLevelErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_CSCContrastLevelErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_CSCContrastLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_CSCContrastLevelErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_CSCContrastLevelError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_CSCContrastLevelError& rhs);

    inline void deleteData ();

    DIM_DISP_CSCContrastLevelErrorField __field;

    union {
        DIM_DISP_CSCContrastLevelErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DISP_CSCBlackLevel"
 * <p>Provides the current active black level of color space conversion.</p>
 * <p>Contrast level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 */
class DIM_DISP_CSCBlackLevelStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_CSCBlackLevelStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_CSCBlackLevelStatus (const DIM_DISP_CSCBlackLevelStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_CSCBlackLevelStatus (uint8 BlackLevel_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_CSCBlackLevelStatus();

    /**
     * Assignment operator
     */
    inline DIM_DISP_CSCBlackLevelStatus& operator = (const DIM_DISP_CSCBlackLevelStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_CSCBlackLevelStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_CSCBlackLevelStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_CSCBlackLevelStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_CSCBlackLevelStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BlackLevel"

    static const int kBlackLevel = 0;

    /**
     * Clears the field "BlackLevel".
     *
     * The field will be set to its default value. The hasBlackLevel()
     * method will return false.
     */
    inline void clearBlackLevel();

    /**
     * Checks whether the field "BlackLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBlackLevel()). Otherwise it will return false.
     */
    inline bool hasBlackLevel () const;

    /**
     * Returns the value of the member "BlackLevel".
     *
     * Provides the current black level (0..255).
     * Attention: For AIVI the range is limited to 0..32!
     *
     * @return The value of the field "BlackLevel"
     */
    inline uint8 getBlackLevel () const;

    /**
     * Sets the value of the member "BlackLevel".
     *
     * Provides the current black level (0..255).
     * Attention: For AIVI the range is limited to 0..32!
     *
     * @param BlackLevel The value which will be set
     */
    inline void setBlackLevel (uint8 BlackLevel_);

    static const DIM_DISP_CSCBlackLevelStatus &getDefaultInstance();

private:

    inline void set_has_BlackLevel ();

    inline void clear_has_BlackLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _BlackLevel;

};

/**
 * The error message of 'DIM_DISP_CSCBlackLevel'
 */
class DIM_DISP_CSCBlackLevelErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_CSCBlackLevelErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_CSCBlackLevelErrorStructure (const DIM_DISP_CSCBlackLevelErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_CSCBlackLevelErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_CSCBlackLevelErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_CSCBlackLevelErrorStructure& operator = (const DIM_DISP_CSCBlackLevelErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_CSCBlackLevelErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_CSCBlackLevelErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_CSCBlackLevelErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_CSCBlackLevelErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_CSCBlackLevelErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_CSCBlackLevel'
 */
class DIM_DISP_CSCBlackLevelError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_CSCBlackLevelErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_CSCBlackLevelError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_CSCBlackLevelError (const DIM_DISP_CSCBlackLevelError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_CSCBlackLevelError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_CSCBlackLevelError& operator = (const DIM_DISP_CSCBlackLevelError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_CSCBlackLevelError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_CSCBlackLevelError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_CSCBlackLevelError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_CSCBlackLevelError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_CSCBlackLevelError::DIM_DISP_CSCBlackLevelErrorField getField () const;

    inline void setField(DIM_DISP_CSCBlackLevelError::DIM_DISP_CSCBlackLevelErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_CSCBlackLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_CSCBlackLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_CSCBlackLevelErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_CSCBlackLevelErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_CSCBlackLevelErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_CSCBlackLevelErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_CSCBlackLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_CSCBlackLevelErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_CSCBlackLevelError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_CSCBlackLevelError& rhs);

    inline void deleteData ();

    DIM_DISP_CSCBlackLevelErrorField __field;

    union {
        DIM_DISP_CSCBlackLevelErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DISP_CSCGammaLevel"
 * <p>Provides the current active gamma adjustment level of color space conversion.</p>
 * <p>Gamma adjustment level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 */
class DIM_DISP_CSCGammaLevelStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_CSCGammaLevelStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_CSCGammaLevelStatus (const DIM_DISP_CSCGammaLevelStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_CSCGammaLevelStatus (uint8 GammaLevel_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_CSCGammaLevelStatus();

    /**
     * Assignment operator
     */
    inline DIM_DISP_CSCGammaLevelStatus& operator = (const DIM_DISP_CSCGammaLevelStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_CSCGammaLevelStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_CSCGammaLevelStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_CSCGammaLevelStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_CSCGammaLevelStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "GammaLevel"

    static const int kGammaLevel = 0;

    /**
     * Clears the field "GammaLevel".
     *
     * The field will be set to its default value. The hasGammaLevel()
     * method will return false.
     */
    inline void clearGammaLevel();

    /**
     * Checks whether the field "GammaLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGammaLevel()). Otherwise it will return false.
     */
    inline bool hasGammaLevel () const;

    /**
     * Returns the value of the member "GammaLevel".
     *
     * Provides the current gamma adjustment level (0..255).
     * Attention: For AIVI the range is limited to 0..32!
     *
     * @return The value of the field "GammaLevel"
     */
    inline uint8 getGammaLevel () const;

    /**
     * Sets the value of the member "GammaLevel".
     *
     * Provides the current gamma adjustment level (0..255).
     * Attention: For AIVI the range is limited to 0..32!
     *
     * @param GammaLevel The value which will be set
     */
    inline void setGammaLevel (uint8 GammaLevel_);

    static const DIM_DISP_CSCGammaLevelStatus &getDefaultInstance();

private:

    inline void set_has_GammaLevel ();

    inline void clear_has_GammaLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _GammaLevel;

};

/**
 * The error message of 'DIM_DISP_CSCGammaLevel'
 */
class DIM_DISP_CSCGammaLevelErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_CSCGammaLevelErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_CSCGammaLevelErrorStructure (const DIM_DISP_CSCGammaLevelErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_CSCGammaLevelErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_CSCGammaLevelErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_CSCGammaLevelErrorStructure& operator = (const DIM_DISP_CSCGammaLevelErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_CSCGammaLevelErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_CSCGammaLevelErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_CSCGammaLevelErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_CSCGammaLevelErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_CSCGammaLevelErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_CSCGammaLevel'
 */
class DIM_DISP_CSCGammaLevelError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_CSCGammaLevelErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_CSCGammaLevelError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_CSCGammaLevelError (const DIM_DISP_CSCGammaLevelError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_CSCGammaLevelError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_CSCGammaLevelError& operator = (const DIM_DISP_CSCGammaLevelError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_CSCGammaLevelError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_CSCGammaLevelError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_CSCGammaLevelError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_CSCGammaLevelError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_CSCGammaLevelError::DIM_DISP_CSCGammaLevelErrorField getField () const;

    inline void setField(DIM_DISP_CSCGammaLevelError::DIM_DISP_CSCGammaLevelErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_CSCGammaLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_CSCGammaLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_CSCGammaLevelErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_CSCGammaLevelErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_CSCGammaLevelErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_CSCGammaLevelErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_CSCGammaLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_CSCGammaLevelErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_CSCGammaLevelError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_CSCGammaLevelError& rhs);

    inline void deleteData ();

    DIM_DISP_CSCGammaLevelErrorField __field;

    union {
        DIM_DISP_CSCGammaLevelErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DISP_CSCSaturationLevel"
 * <p>Provides the current active tint level of color space conversion.</p>
 * <p>Saturation level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 */
class DIM_DISP_CSCSaturationLevelStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_CSCSaturationLevelStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_CSCSaturationLevelStatus (const DIM_DISP_CSCSaturationLevelStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_CSCSaturationLevelStatus (uint8 SaturationLevel_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_CSCSaturationLevelStatus();

    /**
     * Assignment operator
     */
    inline DIM_DISP_CSCSaturationLevelStatus& operator = (const DIM_DISP_CSCSaturationLevelStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_CSCSaturationLevelStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_CSCSaturationLevelStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_CSCSaturationLevelStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_CSCSaturationLevelStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SaturationLevel"

    static const int kSaturationLevel = 0;

    /**
     * Clears the field "SaturationLevel".
     *
     * The field will be set to its default value. The hasSaturationLevel()
     * method will return false.
     */
    inline void clearSaturationLevel();

    /**
     * Checks whether the field "SaturationLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSaturationLevel()). Otherwise it will return false.
     */
    inline bool hasSaturationLevel () const;

    /**
     * Returns the value of the member "SaturationLevel".
     *
     * Provides the current saturation level (0..255).
     * Attention: For AIVI the range is limited to 0..32!
     *
     * @return The value of the field "SaturationLevel"
     */
    inline uint8 getSaturationLevel () const;

    /**
     * Sets the value of the member "SaturationLevel".
     *
     * Provides the current saturation level (0..255).
     * Attention: For AIVI the range is limited to 0..32!
     *
     * @param SaturationLevel The value which will be set
     */
    inline void setSaturationLevel (uint8 SaturationLevel_);

    static const DIM_DISP_CSCSaturationLevelStatus &getDefaultInstance();

private:

    inline void set_has_SaturationLevel ();

    inline void clear_has_SaturationLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _SaturationLevel;

};

/**
 * The error message of 'DIM_DISP_CSCSaturationLevel'
 */
class DIM_DISP_CSCSaturationLevelErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_CSCSaturationLevelErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_CSCSaturationLevelErrorStructure (const DIM_DISP_CSCSaturationLevelErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_CSCSaturationLevelErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_CSCSaturationLevelErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_CSCSaturationLevelErrorStructure& operator = (const DIM_DISP_CSCSaturationLevelErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_CSCSaturationLevelErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_CSCSaturationLevelErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_CSCSaturationLevelErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_CSCSaturationLevelErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_CSCSaturationLevelErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_CSCSaturationLevel'
 */
class DIM_DISP_CSCSaturationLevelError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_CSCSaturationLevelErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_CSCSaturationLevelError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_CSCSaturationLevelError (const DIM_DISP_CSCSaturationLevelError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_CSCSaturationLevelError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_CSCSaturationLevelError& operator = (const DIM_DISP_CSCSaturationLevelError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_CSCSaturationLevelError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_CSCSaturationLevelError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_CSCSaturationLevelError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_CSCSaturationLevelError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_CSCSaturationLevelError::DIM_DISP_CSCSaturationLevelErrorField getField () const;

    inline void setField(DIM_DISP_CSCSaturationLevelError::DIM_DISP_CSCSaturationLevelErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_CSCSaturationLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_CSCSaturationLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_CSCSaturationLevelErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_CSCSaturationLevelErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_CSCSaturationLevelErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_CSCSaturationLevelErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_CSCSaturationLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_CSCSaturationLevelErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_CSCSaturationLevelError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_CSCSaturationLevelError& rhs);

    inline void deleteData ();

    DIM_DISP_CSCSaturationLevelErrorField __field;

    union {
        DIM_DISP_CSCSaturationLevelErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_DISP_CSCColorLevel"
 * <p>Provides the current active color level</p>
 * <p>Color level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited!
 * AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 3.0!</p>
 */
class DIM_DISP_CSCColorLevelStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_CSCColorLevelStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_CSCColorLevelStatus (const DIM_DISP_CSCColorLevelStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_CSCColorLevelStatus (uint8 ColorLevel_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_CSCColorLevelStatus();

    /**
     * Assignment operator
     */
    inline DIM_DISP_CSCColorLevelStatus& operator = (const DIM_DISP_CSCColorLevelStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_CSCColorLevelStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_CSCColorLevelStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_CSCColorLevelStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_CSCColorLevelStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ColorLevel"

    static const int kColorLevel = 0;

    /**
     * Clears the field "ColorLevel".
     *
     * The field will be set to its default value. The hasColorLevel()
     * method will return false.
     */
    inline void clearColorLevel();

    /**
     * Checks whether the field "ColorLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setColorLevel()). Otherwise it will return false.
     */
    inline bool hasColorLevel () const;

    /**
     * Returns the value of the member "ColorLevel".
     *
     * Provides the current color level (0..255).
     * Attention: For AIVI the range is limited to 0..32!
     *
     * @return The value of the field "ColorLevel"
     */
    inline uint8 getColorLevel () const;

    /**
     * Sets the value of the member "ColorLevel".
     *
     * Provides the current color level (0..255).
     * Attention: For AIVI the range is limited to 0..32!
     *
     * @param ColorLevel The value which will be set
     */
    inline void setColorLevel (uint8 ColorLevel_);

    static const DIM_DISP_CSCColorLevelStatus &getDefaultInstance();

private:

    inline void set_has_ColorLevel ();

    inline void clear_has_ColorLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ColorLevel;

};

/**
 * The error message of 'DIM_DISP_CSCColorLevel'
 */
class DIM_DISP_CSCColorLevelErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_CSCColorLevelErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_CSCColorLevelErrorStructure (const DIM_DISP_CSCColorLevelErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_CSCColorLevelErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_CSCColorLevelErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_CSCColorLevelErrorStructure& operator = (const DIM_DISP_CSCColorLevelErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_CSCColorLevelErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_CSCColorLevelErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_CSCColorLevelErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_CSCColorLevelErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_CSCColorLevelErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_CSCColorLevel'
 */
class DIM_DISP_CSCColorLevelError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_CSCColorLevelErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_CSCColorLevelError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_CSCColorLevelError (const DIM_DISP_CSCColorLevelError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_CSCColorLevelError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_CSCColorLevelError& operator = (const DIM_DISP_CSCColorLevelError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_CSCColorLevelError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_CSCColorLevelError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_CSCColorLevelError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_CSCColorLevelError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_CSCColorLevelError::DIM_DISP_CSCColorLevelErrorField getField () const;

    inline void setField(DIM_DISP_CSCColorLevelError::DIM_DISP_CSCColorLevelErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_CSCColorLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_CSCColorLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_CSCColorLevelErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_CSCColorLevelErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_CSCColorLevelErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_CSCColorLevelErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_CSCColorLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_CSCColorLevelErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_CSCColorLevelError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_CSCColorLevelError& rhs);

    inline void deleteData ();

    DIM_DISP_CSCColorLevelErrorField __field;

    union {
        DIM_DISP_CSCColorLevelErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "DIM_SECOND_DISP_AllDisplayParam"
 * PIVI Second Screen All Display Parametwrs like Blacklevel, Brightness, color, tint, Gamma Level etc.
 */
class DIM_SECOND_DISP_AllDisplayParamStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_SECOND_DISP_AllDisplayParamStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_SECOND_DISP_AllDisplayParamStatus (const DIM_SECOND_DISP_AllDisplayParamStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_SECOND_DISP_AllDisplayParamStatus (uint8 u8BlackLevel_, uint8 u8Brightness_, uint8 u8Color_, uint8 u8Contrast_, uint8 u8Tint_, uint16 u8GammaLevel_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_SECOND_DISP_AllDisplayParamStatus();

    /**
     * Assignment operator
     */
    inline DIM_SECOND_DISP_AllDisplayParamStatus& operator = (const DIM_SECOND_DISP_AllDisplayParamStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_SECOND_DISP_AllDisplayParamStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_SECOND_DISP_AllDisplayParamStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_SECOND_DISP_AllDisplayParamStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_SECOND_DISP_AllDisplayParamStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8BlackLevel"

    static const int kU8BlackLevel = 0;

    /**
     * Clears the field "u8BlackLevel".
     *
     * The field will be set to its default value. The hasU8BlackLevel()
     * method will return false.
     */
    inline void clearU8BlackLevel();

    /**
     * Checks whether the field "u8BlackLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8BlackLevel()). Otherwise it will return false.
     */
    inline bool hasU8BlackLevel () const;

    /**
     * Returns the value of the member "u8BlackLevel".
     *
     * If the meaning of "u8BlackLevel" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8BlackLevel"
     */
    inline uint8 getU8BlackLevel () const;

    /**
     * Sets the value of the member "u8BlackLevel".
     *
     * If the meaning of "u8BlackLevel" isn't clear, then there should be a description here.
     *
     * @param u8BlackLevel The value which will be set
     */
    inline void setU8BlackLevel (uint8 u8BlackLevel_);

    // API of field "u8Brightness"

    static const int kU8Brightness = 1;

    /**
     * Clears the field "u8Brightness".
     *
     * The field will be set to its default value. The hasU8Brightness()
     * method will return false.
     */
    inline void clearU8Brightness();

    /**
     * Checks whether the field "u8Brightness" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Brightness()). Otherwise it will return false.
     */
    inline bool hasU8Brightness () const;

    /**
     * Returns the value of the member "u8Brightness".
     *
     * If the meaning of "u8Brightness" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Brightness"
     */
    inline uint8 getU8Brightness () const;

    /**
     * Sets the value of the member "u8Brightness".
     *
     * If the meaning of "u8Brightness" isn't clear, then there should be a description here.
     *
     * @param u8Brightness The value which will be set
     */
    inline void setU8Brightness (uint8 u8Brightness_);

    // API of field "u8Color"

    static const int kU8Color = 2;

    /**
     * Clears the field "u8Color".
     *
     * The field will be set to its default value. The hasU8Color()
     * method will return false.
     */
    inline void clearU8Color();

    /**
     * Checks whether the field "u8Color" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Color()). Otherwise it will return false.
     */
    inline bool hasU8Color () const;

    /**
     * Returns the value of the member "u8Color".
     *
     * If the meaning of "u8Color" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Color"
     */
    inline uint8 getU8Color () const;

    /**
     * Sets the value of the member "u8Color".
     *
     * If the meaning of "u8Color" isn't clear, then there should be a description here.
     *
     * @param u8Color The value which will be set
     */
    inline void setU8Color (uint8 u8Color_);

    // API of field "u8Contrast"

    static const int kU8Contrast = 3;

    /**
     * Clears the field "u8Contrast".
     *
     * The field will be set to its default value. The hasU8Contrast()
     * method will return false.
     */
    inline void clearU8Contrast();

    /**
     * Checks whether the field "u8Contrast" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Contrast()). Otherwise it will return false.
     */
    inline bool hasU8Contrast () const;

    /**
     * Returns the value of the member "u8Contrast".
     *
     * If the meaning of "u8Contrast" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Contrast"
     */
    inline uint8 getU8Contrast () const;

    /**
     * Sets the value of the member "u8Contrast".
     *
     * If the meaning of "u8Contrast" isn't clear, then there should be a description here.
     *
     * @param u8Contrast The value which will be set
     */
    inline void setU8Contrast (uint8 u8Contrast_);

    // API of field "u8Tint"

    static const int kU8Tint = 4;

    /**
     * Clears the field "u8Tint".
     *
     * The field will be set to its default value. The hasU8Tint()
     * method will return false.
     */
    inline void clearU8Tint();

    /**
     * Checks whether the field "u8Tint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Tint()). Otherwise it will return false.
     */
    inline bool hasU8Tint () const;

    /**
     * Returns the value of the member "u8Tint".
     *
     * If the meaning of "u8Tint" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Tint"
     */
    inline uint8 getU8Tint () const;

    /**
     * Sets the value of the member "u8Tint".
     *
     * If the meaning of "u8Tint" isn't clear, then there should be a description here.
     *
     * @param u8Tint The value which will be set
     */
    inline void setU8Tint (uint8 u8Tint_);

    // API of field "u8GammaLevel"

    static const int kU8GammaLevel = 5;

    /**
     * Clears the field "u8GammaLevel".
     *
     * The field will be set to its default value. The hasU8GammaLevel()
     * method will return false.
     */
    inline void clearU8GammaLevel();

    /**
     * Checks whether the field "u8GammaLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8GammaLevel()). Otherwise it will return false.
     */
    inline bool hasU8GammaLevel () const;

    /**
     * Returns the value of the member "u8GammaLevel".
     *
     * If the meaning of "u8GammaLevel" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8GammaLevel"
     */
    inline uint16 getU8GammaLevel () const;

    /**
     * Sets the value of the member "u8GammaLevel".
     *
     * If the meaning of "u8GammaLevel" isn't clear, then there should be a description here.
     *
     * @param u8GammaLevel The value which will be set
     */
    inline void setU8GammaLevel (uint16 u8GammaLevel_);

    static const DIM_SECOND_DISP_AllDisplayParamStatus &getDefaultInstance();

private:

    inline void set_has_u8BlackLevel ();

    inline void clear_has_u8BlackLevel ();

    inline void set_has_u8Brightness ();

    inline void clear_has_u8Brightness ();

    inline void set_has_u8Color ();

    inline void clear_has_u8Color ();

    inline void set_has_u8Contrast ();

    inline void clear_has_u8Contrast ();

    inline void set_has_u8Tint ();

    inline void clear_has_u8Tint ();

    inline void set_has_u8GammaLevel ();

    inline void clear_has_u8GammaLevel ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint8 _u8BlackLevel;

    uint8 _u8Brightness;

    uint8 _u8Color;

    uint8 _u8Contrast;

    uint8 _u8Tint;

    uint16 _u8GammaLevel;

};

/**
 * The status message of the property "DIM_SECOND_DISP_SelfDiagnosisResult"
 * PIVI Second Screen get from V850.
 */
class DIM_SECOND_DISP_SelfDiagnosisResultStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_SECOND_DISP_SelfDiagnosisResultStatus ();

    /**
     * Copy constructor
     */
    inline  DIM_SECOND_DISP_SelfDiagnosisResultStatus (const DIM_SECOND_DISP_SelfDiagnosisResultStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_SECOND_DISP_SelfDiagnosisResultStatus (uint16 u16SelfDiagResult_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_SECOND_DISP_SelfDiagnosisResultStatus();

    /**
     * Assignment operator
     */
    inline DIM_SECOND_DISP_SelfDiagnosisResultStatus& operator = (const DIM_SECOND_DISP_SelfDiagnosisResultStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_SECOND_DISP_SelfDiagnosisResultStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_SECOND_DISP_SelfDiagnosisResultStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_SECOND_DISP_SelfDiagnosisResultStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_SECOND_DISP_SelfDiagnosisResultStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16SelfDiagResult"

    static const int kU16SelfDiagResult = 0;

    /**
     * Clears the field "u16SelfDiagResult".
     *
     * The field will be set to its default value. The hasU16SelfDiagResult()
     * method will return false.
     */
    inline void clearU16SelfDiagResult();

    /**
     * Checks whether the field "u16SelfDiagResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SelfDiagResult()). Otherwise it will return false.
     */
    inline bool hasU16SelfDiagResult () const;

    /**
     * Returns the value of the member "u16SelfDiagResult".
     *
     * If the meaning of "u16SelfDiagResult" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16SelfDiagResult"
     */
    inline uint16 getU16SelfDiagResult () const;

    /**
     * Sets the value of the member "u16SelfDiagResult".
     *
     * If the meaning of "u16SelfDiagResult" isn't clear, then there should be a description here.
     *
     * @param u16SelfDiagResult The value which will be set
     */
    inline void setU16SelfDiagResult (uint16 u16SelfDiagResult_);

    static const DIM_SECOND_DISP_SelfDiagnosisResultStatus &getDefaultInstance();

private:

    inline void set_has_u16SelfDiagResult ();

    inline void clear_has_u16SelfDiagResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16SelfDiagResult;

};

/**
 * The start message of the method "FI_VD_DIMMING_DEFAULT"
 * <p>VD_Dimming has to support a default setting. This is the Functional Interface for this.</p>
 * <p>Attention:</p>
 * <p>In FI V1.0 FI "DefSetStateGroup" is of type="T_e8_DefSetGroups"!</p>
 * <p>In FI V1.0 FI "DefSetStateMode"  is of type="T_e8_DefSetMode"!</p>
 * <p>Both types are replaced by an tU8 to get rid of all the diag-types in this FI document starting with V2.0!</p>
 * Message to start the setting of the defaultvalue.
 */
class FI_VD_DIMMING_DEFAULTStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FI_VD_DIMMING_DEFAULTStart ();

    /**
     * Copy constructor
     */
    inline  FI_VD_DIMMING_DEFAULTStart (const FI_VD_DIMMING_DEFAULTStart &rhs);

    /**
     * All fields constructor
     */
    inline  FI_VD_DIMMING_DEFAULTStart (uint8 DefaultSettingsGroup_, uint8 DefaultSettingsMode_);

    /**
     * Destructor
     */
    inline virtual  ~FI_VD_DIMMING_DEFAULTStart();

    /**
     * Assignment operator
     */
    inline FI_VD_DIMMING_DEFAULTStart& operator = (const FI_VD_DIMMING_DEFAULTStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FI_VD_DIMMING_DEFAULTStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FI_VD_DIMMING_DEFAULTStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FI_VD_DIMMING_DEFAULTStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FI_VD_DIMMING_DEFAULTStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefaultSettingsGroup"

    static const int kDefaultSettingsGroup = 0;

    /**
     * Clears the field "DefaultSettingsGroup".
     *
     * The field will be set to its default value. The hasDefaultSettingsGroup()
     * method will return false.
     */
    inline void clearDefaultSettingsGroup();

    /**
     * Checks whether the field "DefaultSettingsGroup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefaultSettingsGroup()). Otherwise it will return false.
     */
    inline bool hasDefaultSettingsGroup () const;

    /**
     * Returns the value of the member "DefaultSettingsGroup".
     *
     * Use DEFSET_GROUP__HMI_OUTLINE__DIMMING for this method
     *
     * @return The value of the field "DefaultSettingsGroup"
     */
    inline uint8 getDefaultSettingsGroup () const;

    /**
     * Sets the value of the member "DefaultSettingsGroup".
     *
     * Use DEFSET_GROUP__HMI_OUTLINE__DIMMING for this method
     *
     * @param DefaultSettingsGroup The value which will be set
     */
    inline void setDefaultSettingsGroup (uint8 DefaultSettingsGroup_);

    // API of field "DefaultSettingsMode"

    static const int kDefaultSettingsMode = 1;

    /**
     * Clears the field "DefaultSettingsMode".
     *
     * The field will be set to its default value. The hasDefaultSettingsMode()
     * method will return false.
     */
    inline void clearDefaultSettingsMode();

    /**
     * Checks whether the field "DefaultSettingsMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefaultSettingsMode()). Otherwise it will return false.
     */
    inline bool hasDefaultSettingsMode () const;

    /**
     * Returns the value of the member "DefaultSettingsMode".
     *
     * DEFSET_SRC_SET_TEF or DEFSET_SRC_SET_USER.
     *
     * @return The value of the field "DefaultSettingsMode"
     */
    inline uint8 getDefaultSettingsMode () const;

    /**
     * Sets the value of the member "DefaultSettingsMode".
     *
     * DEFSET_SRC_SET_TEF or DEFSET_SRC_SET_USER.
     *
     * @param DefaultSettingsMode The value which will be set
     */
    inline void setDefaultSettingsMode (uint8 DefaultSettingsMode_);

    static const FI_VD_DIMMING_DEFAULTStart &getDefaultInstance();

private:

    inline void set_has_DefaultSettingsGroup ();

    inline void clear_has_DefaultSettingsGroup ();

    inline void set_has_DefaultSettingsMode ();

    inline void clear_has_DefaultSettingsMode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _DefaultSettingsGroup;

    uint8 _DefaultSettingsMode;

};

/**
 * The result message of the method "FI_VD_DIMMING_DEFAULT"
 * <p>VD_Dimming has to support a default setting. This is the Functional Interface for this.</p>
 * <p>Attention:</p>
 * <p>In FI V1.0 FI "DefSetStateGroup" is of type="T_e8_DefSetGroups"!</p>
 * <p>In FI V1.0 FI "DefSetStateMode"  is of type="T_e8_DefSetMode"!</p>
 * <p>Both types are replaced by an tU8 to get rid of all the diag-types in this FI document starting with V2.0!</p>
 * Message send the setting of the defaultvalue.
 */
class FI_VD_DIMMING_DEFAULTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FI_VD_DIMMING_DEFAULTResult ();

    /**
     * Copy constructor
     */
    inline  FI_VD_DIMMING_DEFAULTResult (const FI_VD_DIMMING_DEFAULTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FI_VD_DIMMING_DEFAULTResult (uint8 DefaultSettingsGroup_, uint8 DefaultSettingsStatus_);

    /**
     * Destructor
     */
    inline virtual  ~FI_VD_DIMMING_DEFAULTResult();

    /**
     * Assignment operator
     */
    inline FI_VD_DIMMING_DEFAULTResult& operator = (const FI_VD_DIMMING_DEFAULTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FI_VD_DIMMING_DEFAULTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FI_VD_DIMMING_DEFAULTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FI_VD_DIMMING_DEFAULTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FI_VD_DIMMING_DEFAULTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefaultSettingsGroup"

    static const int kDefaultSettingsGroup = 0;

    /**
     * Clears the field "DefaultSettingsGroup".
     *
     * The field will be set to its default value. The hasDefaultSettingsGroup()
     * method will return false.
     */
    inline void clearDefaultSettingsGroup();

    /**
     * Checks whether the field "DefaultSettingsGroup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefaultSettingsGroup()). Otherwise it will return false.
     */
    inline bool hasDefaultSettingsGroup () const;

    /**
     * Returns the value of the member "DefaultSettingsGroup".
     *
     * Use DEFSET_GROUP__HMI_OUTLINE__DIMMING for this method
     *
     * @return The value of the field "DefaultSettingsGroup"
     */
    inline uint8 getDefaultSettingsGroup () const;

    /**
     * Sets the value of the member "DefaultSettingsGroup".
     *
     * Use DEFSET_GROUP__HMI_OUTLINE__DIMMING for this method
     *
     * @param DefaultSettingsGroup The value which will be set
     */
    inline void setDefaultSettingsGroup (uint8 DefaultSettingsGroup_);

    // API of field "DefaultSettingsStatus"

    static const int kDefaultSettingsStatus = 1;

    /**
     * Clears the field "DefaultSettingsStatus".
     *
     * The field will be set to its default value. The hasDefaultSettingsStatus()
     * method will return false.
     */
    inline void clearDefaultSettingsStatus();

    /**
     * Checks whether the field "DefaultSettingsStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefaultSettingsStatus()). Otherwise it will return false.
     */
    inline bool hasDefaultSettingsStatus () const;

    /**
     * Returns the value of the member "DefaultSettingsStatus".
     *
     * DEFSET_STATE_CONFIRMED or DEFSET_STATE_FAILED
     *
     * @return The value of the field "DefaultSettingsStatus"
     */
    inline uint8 getDefaultSettingsStatus () const;

    /**
     * Sets the value of the member "DefaultSettingsStatus".
     *
     * DEFSET_STATE_CONFIRMED or DEFSET_STATE_FAILED
     *
     * @param DefaultSettingsStatus The value which will be set
     */
    inline void setDefaultSettingsStatus (uint8 DefaultSettingsStatus_);

    static const FI_VD_DIMMING_DEFAULTResult &getDefaultInstance();

private:

    inline void set_has_DefaultSettingsGroup ();

    inline void clear_has_DefaultSettingsGroup ();

    inline void set_has_DefaultSettingsStatus ();

    inline void clear_has_DefaultSettingsStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _DefaultSettingsGroup;

    uint8 _DefaultSettingsStatus;

};

/**
 * The start message of the method "DIM_INFO_SetDimmingMode"
 * <p>Set the dimming mode configuration.</p>
 * <p>The corresponding property is "DIM_DimmingMode".</p>
 * <p>Switch the dimming mode to:</p>
 * Off   = No dimming table used
 * Day   = Dimming table for "day" is used
 * Night = Dimming table for "night" is used
 * Auto  = Depending on the information received from the car either "day" or "night" table is used
 * <p>Currently this behavior is only relevant for display dimming but in future or for different customers this can be also relevant for keyboard.
 * This method is normally called by HMI. In case it is set to "AUTO" then the property value will be based on DIM_INFO_CarIlluminationData.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_INFO_SetDimmingModeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_SetDimmingModeStart ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_SetDimmingModeStart (const DIM_INFO_SetDimmingModeStart &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_SetDimmingModeStart (::dimming_main_fi_types::T_e8_DIM_Mode DimmingMode_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_SetDimmingModeStart();

    /**
     * Assignment operator
     */
    inline DIM_INFO_SetDimmingModeStart& operator = (const DIM_INFO_SetDimmingModeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_SetDimmingModeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_SetDimmingModeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_SetDimmingModeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_SetDimmingModeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DimmingMode"

    static const int kDimmingMode = 0;

    /**
     * Clears the field "DimmingMode".
     *
     * The field will be set to its default value. The hasDimmingMode()
     * method will return false.
     */
    inline void clearDimmingMode();

    /**
     * Checks whether the field "DimmingMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDimmingMode()). Otherwise it will return false.
     */
    inline bool hasDimmingMode () const;

    /**
     * Returns the value of the member "DimmingMode".
     *
     * Set the dimming mode configuration.
     *
     * @return The value of the field "DimmingMode"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_Mode getDimmingMode () const;

    /**
     * Sets the value of the member "DimmingMode".
     *
     * Set the dimming mode configuration.
     *
     * @param DimmingMode The value which will be set
     */
    inline void setDimmingMode (::dimming_main_fi_types::T_e8_DIM_Mode DimmingMode_);

    static const DIM_INFO_SetDimmingModeStart &getDefaultInstance();

private:

    inline void set_has_DimmingMode ();

    inline void clear_has_DimmingMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_e8_DIM_Mode _DimmingMode;

};

/**
 * The result message of the method "DIM_INFO_SetDimmingMode"
 * <p>Set the dimming mode configuration.</p>
 * <p>The corresponding property is "DIM_DimmingMode".</p>
 * <p>Switch the dimming mode to:</p>
 * Off   = No dimming table used
 * Day   = Dimming table for "day" is used
 * Night = Dimming table for "night" is used
 * Auto  = Depending on the information received from the car either "day" or "night" table is used
 * <p>Currently this behavior is only relevant for display dimming but in future or for different customers this can be also relevant for keyboard.
 * This method is normally called by HMI. In case it is set to "AUTO" then the property value will be based on DIM_INFO_CarIlluminationData.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_INFO_SetDimmingModeResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_SetDimmingModeResult ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_SetDimmingModeResult (const DIM_INFO_SetDimmingModeResult &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_SetDimmingModeResult (::dimming_main_fi_types::T_e8_DIM_Mode DimmingMode_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_SetDimmingModeResult();

    /**
     * Assignment operator
     */
    inline DIM_INFO_SetDimmingModeResult& operator = (const DIM_INFO_SetDimmingModeResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_SetDimmingModeResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_SetDimmingModeResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_SetDimmingModeResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_SetDimmingModeResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DimmingMode"

    static const int kDimmingMode = 0;

    /**
     * Clears the field "DimmingMode".
     *
     * The field will be set to its default value. The hasDimmingMode()
     * method will return false.
     */
    inline void clearDimmingMode();

    /**
     * Checks whether the field "DimmingMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDimmingMode()). Otherwise it will return false.
     */
    inline bool hasDimmingMode () const;

    /**
     * Returns the value of the member "DimmingMode".
     *
     * Status of the configured dimming mode.
     *
     * @return The value of the field "DimmingMode"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_Mode getDimmingMode () const;

    /**
     * Sets the value of the member "DimmingMode".
     *
     * Status of the configured dimming mode.
     *
     * @param DimmingMode The value which will be set
     */
    inline void setDimmingMode (::dimming_main_fi_types::T_e8_DIM_Mode DimmingMode_);

    static const DIM_INFO_SetDimmingModeResult &getDefaultInstance();

private:

    inline void set_has_DimmingMode ();

    inline void clear_has_DimmingMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_e8_DIM_Mode _DimmingMode;

};

/**
 * The error message of 'DIM_INFO_SetDimmingMode'
 */
class DIM_INFO_SetDimmingModeErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_SetDimmingModeErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_SetDimmingModeErrorStructure (const DIM_INFO_SetDimmingModeErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_SetDimmingModeErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_INFO_SetDimmingModeErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_INFO_SetDimmingModeErrorStructure& operator = (const DIM_INFO_SetDimmingModeErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_SetDimmingModeErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_SetDimmingModeErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_SetDimmingModeErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_SetDimmingModeErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_INFO_SetDimmingModeErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_INFO_SetDimmingMode'
 */
class DIM_INFO_SetDimmingModeError  : public ::asf::core::Payload {
public:

    enum DIM_INFO_SetDimmingModeErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_INFO_SetDimmingModeError ();

   /**
     * Copy constructor
     */
    inline  DIM_INFO_SetDimmingModeError (const DIM_INFO_SetDimmingModeError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_SetDimmingModeError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_INFO_SetDimmingModeError& operator = (const DIM_INFO_SetDimmingModeError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_SetDimmingModeError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_SetDimmingModeError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_SetDimmingModeError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_SetDimmingModeError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_INFO_SetDimmingModeError::DIM_INFO_SetDimmingModeErrorField getField () const;

    inline void setField(DIM_INFO_SetDimmingModeError::DIM_INFO_SetDimmingModeErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_INFO_SetDimmingModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_INFO_SetDimmingModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_INFO_SetDimmingModeErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_INFO_SetDimmingModeErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_INFO_SetDimmingModeErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_INFO_SetDimmingModeErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_INFO_SetDimmingModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_INFO_SetDimmingModeErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_INFO_SetDimmingModeError &getDefaultInstance();

private:

    inline void cloneData (const DIM_INFO_SetDimmingModeError& rhs);

    inline void deleteData ();

    DIM_INFO_SetDimmingModeErrorField __field;

    union {
        DIM_INFO_SetDimmingModeErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DIM_INFO_SetEmulationMode"
 * <p>Switch to emulation mode. If this value is set to "setup" or "verify" then the VD_Dimming
 * server will not react on the normal external inputs any longer, instead all triggers via
 * TTFIS and Diagnosis are used to change dimming and illumination.</p>
 * <p>In "verify" mode all internal compensation tables are active in "setup" those tables are
 * inactive to do some unaltered measurements.</p>
 * <p>Possible other modes are "KeybFreeze" and "DispFreeze". This is specialized "verify" mode to
 * check given input values and their output for keyboard or for display.</p>
 * <p>On activation the VD_Dimming will store its current values and will retrieve them
 * once the DiagMode is set to "Off"</p>
 * <p>If the DiagMode mode is switched to "Off" again the external triggers are again
 * used for controlling the dimming/illumination of the keyboard</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_INFO_SetEmulationModeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_SetEmulationModeStart ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_SetEmulationModeStart (const DIM_INFO_SetEmulationModeStart &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_SetEmulationModeStart (::dimming_main_fi_types::T_e8_DIM_EmulationMode EmulationMode_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_SetEmulationModeStart();

    /**
     * Assignment operator
     */
    inline DIM_INFO_SetEmulationModeStart& operator = (const DIM_INFO_SetEmulationModeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_SetEmulationModeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_SetEmulationModeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_SetEmulationModeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_SetEmulationModeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "EmulationMode"

    static const int kEmulationMode = 0;

    /**
     * Clears the field "EmulationMode".
     *
     * The field will be set to its default value. The hasEmulationMode()
     * method will return false.
     */
    inline void clearEmulationMode();

    /**
     * Checks whether the field "EmulationMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEmulationMode()). Otherwise it will return false.
     */
    inline bool hasEmulationMode () const;

    /**
     * Returns the value of the member "EmulationMode".
     *
     * Set the emulation mode.
     *
     * @return The value of the field "EmulationMode"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_EmulationMode getEmulationMode () const;

    /**
     * Sets the value of the member "EmulationMode".
     *
     * Set the emulation mode.
     *
     * @param EmulationMode The value which will be set
     */
    inline void setEmulationMode (::dimming_main_fi_types::T_e8_DIM_EmulationMode EmulationMode_);

    static const DIM_INFO_SetEmulationModeStart &getDefaultInstance();

private:

    inline void set_has_EmulationMode ();

    inline void clear_has_EmulationMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_e8_DIM_EmulationMode _EmulationMode;

};

/**
 * The result message of the method "DIM_INFO_SetEmulationMode"
 * <p>Switch to emulation mode. If this value is set to "setup" or "verify" then the VD_Dimming
 * server will not react on the normal external inputs any longer, instead all triggers via
 * TTFIS and Diagnosis are used to change dimming and illumination.</p>
 * <p>In "verify" mode all internal compensation tables are active in "setup" those tables are
 * inactive to do some unaltered measurements.</p>
 * <p>Possible other modes are "KeybFreeze" and "DispFreeze". This is specialized "verify" mode to
 * check given input values and their output for keyboard or for display.</p>
 * <p>On activation the VD_Dimming will store its current values and will retrieve them
 * once the DiagMode is set to "Off"</p>
 * <p>If the DiagMode mode is switched to "Off" again the external triggers are again
 * used for controlling the dimming/illumination of the keyboard</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_INFO_SetEmulationModeResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_SetEmulationModeResult ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_SetEmulationModeResult (const DIM_INFO_SetEmulationModeResult &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_SetEmulationModeResult (::dimming_main_fi_types::T_e8_DIM_EmulationMode EmulationMode_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_SetEmulationModeResult();

    /**
     * Assignment operator
     */
    inline DIM_INFO_SetEmulationModeResult& operator = (const DIM_INFO_SetEmulationModeResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_SetEmulationModeResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_SetEmulationModeResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_SetEmulationModeResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_SetEmulationModeResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "EmulationMode"

    static const int kEmulationMode = 0;

    /**
     * Clears the field "EmulationMode".
     *
     * The field will be set to its default value. The hasEmulationMode()
     * method will return false.
     */
    inline void clearEmulationMode();

    /**
     * Checks whether the field "EmulationMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEmulationMode()). Otherwise it will return false.
     */
    inline bool hasEmulationMode () const;

    /**
     * Returns the value of the member "EmulationMode".
     *
     * Status of the emulation mode.
     *
     * @return The value of the field "EmulationMode"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_EmulationMode getEmulationMode () const;

    /**
     * Sets the value of the member "EmulationMode".
     *
     * Status of the emulation mode.
     *
     * @param EmulationMode The value which will be set
     */
    inline void setEmulationMode (::dimming_main_fi_types::T_e8_DIM_EmulationMode EmulationMode_);

    static const DIM_INFO_SetEmulationModeResult &getDefaultInstance();

private:

    inline void set_has_EmulationMode ();

    inline void clear_has_EmulationMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_e8_DIM_EmulationMode _EmulationMode;

};

/**
 * The error message of 'DIM_INFO_SetEmulationMode'
 */
class DIM_INFO_SetEmulationModeErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_SetEmulationModeErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_SetEmulationModeErrorStructure (const DIM_INFO_SetEmulationModeErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_SetEmulationModeErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_INFO_SetEmulationModeErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_INFO_SetEmulationModeErrorStructure& operator = (const DIM_INFO_SetEmulationModeErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_SetEmulationModeErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_SetEmulationModeErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_SetEmulationModeErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_SetEmulationModeErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_INFO_SetEmulationModeErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_INFO_SetEmulationMode'
 */
class DIM_INFO_SetEmulationModeError  : public ::asf::core::Payload {
public:

    enum DIM_INFO_SetEmulationModeErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_INFO_SetEmulationModeError ();

   /**
     * Copy constructor
     */
    inline  DIM_INFO_SetEmulationModeError (const DIM_INFO_SetEmulationModeError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_SetEmulationModeError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_INFO_SetEmulationModeError& operator = (const DIM_INFO_SetEmulationModeError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_SetEmulationModeError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_SetEmulationModeError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_SetEmulationModeError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_SetEmulationModeError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_INFO_SetEmulationModeError::DIM_INFO_SetEmulationModeErrorField getField () const;

    inline void setField(DIM_INFO_SetEmulationModeError::DIM_INFO_SetEmulationModeErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_INFO_SetEmulationModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_INFO_SetEmulationModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_INFO_SetEmulationModeErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_INFO_SetEmulationModeErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_INFO_SetEmulationModeErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_INFO_SetEmulationModeErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_INFO_SetEmulationModeErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_INFO_SetEmulationModeErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_INFO_SetEmulationModeError &getDefaultInstance();

private:

    inline void cloneData (const DIM_INFO_SetEmulationModeError& rhs);

    inline void deleteData ();

    DIM_INFO_SetEmulationModeErrorField __field;

    union {
        DIM_INFO_SetEmulationModeErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DIM_INFO_SetDimmingState"
 * <p>Activate or deactivate the illumination for a specific LUN</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_INFO_SetDimmingStateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_SetDimmingStateStart ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_SetDimmingStateStart (const DIM_INFO_SetDimmingStateStart &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_SetDimmingStateStart (uint8 LUN_, ::dimming_main_fi_types::T_e8_DIM_Status DimmingStatus_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_SetDimmingStateStart();

    /**
     * Assignment operator
     */
    inline DIM_INFO_SetDimmingStateStart& operator = (const DIM_INFO_SetDimmingStateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_SetDimmingStateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_SetDimmingStateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_SetDimmingStateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_SetDimmingStateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LUN"

    static const int kLUN = 0;

    /**
     * Clears the field "LUN".
     *
     * The field will be set to its default value. The hasLUN()
     * method will return false.
     */
    inline void clearLUN();

    /**
     * Checks whether the field "LUN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLUN()). Otherwise it will return false.
     */
    inline bool hasLUN () const;

    /**
     * Returns the value of the member "LUN".
     *
     * The LUN identifier
     *
     * @return The value of the field "LUN"
     */
    inline uint8 getLUN () const;

    /**
     * Sets the value of the member "LUN".
     *
     * The LUN identifier
     *
     * @param LUN The value which will be set
     */
    inline void setLUN (uint8 LUN_);

    // API of field "DimmingStatus"

    static const int kDimmingStatus = 1;

    /**
     * Clears the field "DimmingStatus".
     *
     * The field will be set to its default value. The hasDimmingStatus()
     * method will return false.
     */
    inline void clearDimmingStatus();

    /**
     * Checks whether the field "DimmingStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDimmingStatus()). Otherwise it will return false.
     */
    inline bool hasDimmingStatus () const;

    /**
     * Returns the value of the member "DimmingStatus".
     *
     * The dimming state to be set.
     *
     * @return The value of the field "DimmingStatus"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_Status getDimmingStatus () const;

    /**
     * Sets the value of the member "DimmingStatus".
     *
     * The dimming state to be set.
     *
     * @param DimmingStatus The value which will be set
     */
    inline void setDimmingStatus (::dimming_main_fi_types::T_e8_DIM_Status DimmingStatus_);

    static const DIM_INFO_SetDimmingStateStart &getDefaultInstance();

private:

    inline void set_has_LUN ();

    inline void clear_has_LUN ();

    inline void set_has_DimmingStatus ();

    inline void clear_has_DimmingStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _LUN;

    ::dimming_main_fi_types::T_e8_DIM_Status _DimmingStatus;

};

/**
 * The result message of the method "DIM_INFO_SetDimmingState"
 * <p>Activate or deactivate the illumination for a specific LUN</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_INFO_SetDimmingStateResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_SetDimmingStateResult ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_SetDimmingStateResult (const DIM_INFO_SetDimmingStateResult &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_SetDimmingStateResult (uint8 LUN_, ::dimming_main_fi_types::T_e8_DIM_Status DimmingStatus_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_SetDimmingStateResult();

    /**
     * Assignment operator
     */
    inline DIM_INFO_SetDimmingStateResult& operator = (const DIM_INFO_SetDimmingStateResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_SetDimmingStateResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_SetDimmingStateResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_SetDimmingStateResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_SetDimmingStateResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LUN"

    static const int kLUN = 0;

    /**
     * Clears the field "LUN".
     *
     * The field will be set to its default value. The hasLUN()
     * method will return false.
     */
    inline void clearLUN();

    /**
     * Checks whether the field "LUN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLUN()). Otherwise it will return false.
     */
    inline bool hasLUN () const;

    /**
     * Returns the value of the member "LUN".
     *
     * The LUN identifier
     *
     * @return The value of the field "LUN"
     */
    inline uint8 getLUN () const;

    /**
     * Sets the value of the member "LUN".
     *
     * The LUN identifier
     *
     * @param LUN The value which will be set
     */
    inline void setLUN (uint8 LUN_);

    // API of field "DimmingStatus"

    static const int kDimmingStatus = 1;

    /**
     * Clears the field "DimmingStatus".
     *
     * The field will be set to its default value. The hasDimmingStatus()
     * method will return false.
     */
    inline void clearDimmingStatus();

    /**
     * Checks whether the field "DimmingStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDimmingStatus()). Otherwise it will return false.
     */
    inline bool hasDimmingStatus () const;

    /**
     * Returns the value of the member "DimmingStatus".
     *
     * Status of the dimming state for requested LUN.
     *
     * @return The value of the field "DimmingStatus"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_Status getDimmingStatus () const;

    /**
     * Sets the value of the member "DimmingStatus".
     *
     * Status of the dimming state for requested LUN.
     *
     * @param DimmingStatus The value which will be set
     */
    inline void setDimmingStatus (::dimming_main_fi_types::T_e8_DIM_Status DimmingStatus_);

    static const DIM_INFO_SetDimmingStateResult &getDefaultInstance();

private:

    inline void set_has_LUN ();

    inline void clear_has_LUN ();

    inline void set_has_DimmingStatus ();

    inline void clear_has_DimmingStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _LUN;

    ::dimming_main_fi_types::T_e8_DIM_Status _DimmingStatus;

};

/**
 * The error message of 'DIM_INFO_SetDimmingState'
 */
class DIM_INFO_SetDimmingStateErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_SetDimmingStateErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_SetDimmingStateErrorStructure (const DIM_INFO_SetDimmingStateErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_SetDimmingStateErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_INFO_SetDimmingStateErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_INFO_SetDimmingStateErrorStructure& operator = (const DIM_INFO_SetDimmingStateErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_SetDimmingStateErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_SetDimmingStateErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_SetDimmingStateErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_SetDimmingStateErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_INFO_SetDimmingStateErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_INFO_SetDimmingState'
 */
class DIM_INFO_SetDimmingStateError  : public ::asf::core::Payload {
public:

    enum DIM_INFO_SetDimmingStateErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_INFO_SetDimmingStateError ();

   /**
     * Copy constructor
     */
    inline  DIM_INFO_SetDimmingStateError (const DIM_INFO_SetDimmingStateError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_SetDimmingStateError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_INFO_SetDimmingStateError& operator = (const DIM_INFO_SetDimmingStateError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_SetDimmingStateError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_SetDimmingStateError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_SetDimmingStateError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_SetDimmingStateError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_INFO_SetDimmingStateError::DIM_INFO_SetDimmingStateErrorField getField () const;

    inline void setField(DIM_INFO_SetDimmingStateError::DIM_INFO_SetDimmingStateErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_INFO_SetDimmingStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_INFO_SetDimmingStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_INFO_SetDimmingStateErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_INFO_SetDimmingStateErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_INFO_SetDimmingStateErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_INFO_SetDimmingStateErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_INFO_SetDimmingStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_INFO_SetDimmingStateErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_INFO_SetDimmingStateError &getDefaultInstance();

private:

    inline void cloneData (const DIM_INFO_SetDimmingStateError& rhs);

    inline void deleteData ();

    DIM_INFO_SetDimmingStateErrorField __field;

    union {
        DIM_INFO_SetDimmingStateErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DIM_INFO_GetDimmingState"
 * <p>Retrieves the Dimming state of a specific LUN</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_INFO_GetDimmingStateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_GetDimmingStateStart ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_GetDimmingStateStart (const DIM_INFO_GetDimmingStateStart &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_GetDimmingStateStart (uint8 LUN_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_GetDimmingStateStart();

    /**
     * Assignment operator
     */
    inline DIM_INFO_GetDimmingStateStart& operator = (const DIM_INFO_GetDimmingStateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_GetDimmingStateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_GetDimmingStateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_GetDimmingStateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_GetDimmingStateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LUN"

    static const int kLUN = 0;

    /**
     * Clears the field "LUN".
     *
     * The field will be set to its default value. The hasLUN()
     * method will return false.
     */
    inline void clearLUN();

    /**
     * Checks whether the field "LUN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLUN()). Otherwise it will return false.
     */
    inline bool hasLUN () const;

    /**
     * Returns the value of the member "LUN".
     *
     * The requested LUN-ID
     *
     * @return The value of the field "LUN"
     */
    inline uint8 getLUN () const;

    /**
     * Sets the value of the member "LUN".
     *
     * The requested LUN-ID
     *
     * @param LUN The value which will be set
     */
    inline void setLUN (uint8 LUN_);

    static const DIM_INFO_GetDimmingStateStart &getDefaultInstance();

private:

    inline void set_has_LUN ();

    inline void clear_has_LUN ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _LUN;

};

/**
 * The result message of the method "DIM_INFO_GetDimmingState"
 * <p>Retrieves the Dimming state of a specific LUN</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_INFO_GetDimmingStateResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_GetDimmingStateResult ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_GetDimmingStateResult (const DIM_INFO_GetDimmingStateResult &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_GetDimmingStateResult (uint8 LUN_, ::dimming_main_fi_types::T_e8_DIM_Status DimmingState_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_GetDimmingStateResult();

    /**
     * Assignment operator
     */
    inline DIM_INFO_GetDimmingStateResult& operator = (const DIM_INFO_GetDimmingStateResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_GetDimmingStateResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_GetDimmingStateResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_GetDimmingStateResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_GetDimmingStateResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LUN"

    static const int kLUN = 0;

    /**
     * Clears the field "LUN".
     *
     * The field will be set to its default value. The hasLUN()
     * method will return false.
     */
    inline void clearLUN();

    /**
     * Checks whether the field "LUN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLUN()). Otherwise it will return false.
     */
    inline bool hasLUN () const;

    /**
     * Returns the value of the member "LUN".
     *
     * The requested LUN-ID
     *
     * @return The value of the field "LUN"
     */
    inline uint8 getLUN () const;

    /**
     * Sets the value of the member "LUN".
     *
     * The requested LUN-ID
     *
     * @param LUN The value which will be set
     */
    inline void setLUN (uint8 LUN_);

    // API of field "DimmingState"

    static const int kDimmingState = 1;

    /**
     * Clears the field "DimmingState".
     *
     * The field will be set to its default value. The hasDimmingState()
     * method will return false.
     */
    inline void clearDimmingState();

    /**
     * Checks whether the field "DimmingState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDimmingState()). Otherwise it will return false.
     */
    inline bool hasDimmingState () const;

    /**
     * Returns the value of the member "DimmingState".
     *
     * Status of the dimming state for requested LUN.
     *
     * @return The value of the field "DimmingState"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_Status getDimmingState () const;

    /**
     * Sets the value of the member "DimmingState".
     *
     * Status of the dimming state for requested LUN.
     *
     * @param DimmingState The value which will be set
     */
    inline void setDimmingState (::dimming_main_fi_types::T_e8_DIM_Status DimmingState_);

    static const DIM_INFO_GetDimmingStateResult &getDefaultInstance();

private:

    inline void set_has_LUN ();

    inline void clear_has_LUN ();

    inline void set_has_DimmingState ();

    inline void clear_has_DimmingState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _LUN;

    ::dimming_main_fi_types::T_e8_DIM_Status _DimmingState;

};

/**
 * The error message of 'DIM_INFO_GetDimmingState'
 */
class DIM_INFO_GetDimmingStateErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_GetDimmingStateErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_GetDimmingStateErrorStructure (const DIM_INFO_GetDimmingStateErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_GetDimmingStateErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_INFO_GetDimmingStateErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_INFO_GetDimmingStateErrorStructure& operator = (const DIM_INFO_GetDimmingStateErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_GetDimmingStateErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_GetDimmingStateErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_GetDimmingStateErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_GetDimmingStateErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_INFO_GetDimmingStateErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_INFO_GetDimmingState'
 */
class DIM_INFO_GetDimmingStateError  : public ::asf::core::Payload {
public:

    enum DIM_INFO_GetDimmingStateErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_INFO_GetDimmingStateError ();

   /**
     * Copy constructor
     */
    inline  DIM_INFO_GetDimmingStateError (const DIM_INFO_GetDimmingStateError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_GetDimmingStateError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_INFO_GetDimmingStateError& operator = (const DIM_INFO_GetDimmingStateError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_GetDimmingStateError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_GetDimmingStateError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_GetDimmingStateError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_GetDimmingStateError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_INFO_GetDimmingStateError::DIM_INFO_GetDimmingStateErrorField getField () const;

    inline void setField(DIM_INFO_GetDimmingStateError::DIM_INFO_GetDimmingStateErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_INFO_GetDimmingStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_INFO_GetDimmingStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_INFO_GetDimmingStateErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_INFO_GetDimmingStateErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_INFO_GetDimmingStateErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_INFO_GetDimmingStateErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_INFO_GetDimmingStateErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_INFO_GetDimmingStateErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_INFO_GetDimmingStateError &getDefaultInstance();

private:

    inline void cloneData (const DIM_INFO_GetDimmingStateError& rhs);

    inline void deleteData ();

    DIM_INFO_GetDimmingStateErrorField __field;

    union {
        DIM_INFO_GetDimmingStateErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DIM_INFO_SetDimmingBrightness"
 * <p>Set the dimming value (in permille) for a specific LUN</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_INFO_SetDimmingBrightnessStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_SetDimmingBrightnessStart ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_SetDimmingBrightnessStart (const DIM_INFO_SetDimmingBrightnessStart &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_SetDimmingBrightnessStart (::dimming_main_fi_types::T_u8_DIM_LUN LUN_, ::dimming_main_fi_types::T_u16_DIM_Permille Brightness_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_SetDimmingBrightnessStart();

    /**
     * Assignment operator
     */
    inline DIM_INFO_SetDimmingBrightnessStart& operator = (const DIM_INFO_SetDimmingBrightnessStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_SetDimmingBrightnessStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_SetDimmingBrightnessStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_SetDimmingBrightnessStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_SetDimmingBrightnessStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LUN"

    static const int kLUN = 0;

    /**
     * Clears the field "LUN".
     *
     * The field will be set to its default value. The hasLUN()
     * method will return false.
     */
    inline void clearLUN();

    /**
     * Checks whether the field "LUN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLUN()). Otherwise it will return false.
     */
    inline bool hasLUN () const;

    /**
     * Returns the value of the member "LUN".
     *
     * The LUN identifier
     *
     * @return The value of the field "LUN"
     */
    inline ::dimming_main_fi_types::T_u8_DIM_LUN getLUN () const;

    /**
     * Sets the value of the member "LUN".
     *
     * The LUN identifier
     *
     * @param LUN The value which will be set
     */
    inline void setLUN (::dimming_main_fi_types::T_u8_DIM_LUN LUN_);

    // API of field "Brightness"

    static const int kBrightness = 1;

    /**
     * Clears the field "Brightness".
     *
     * The field will be set to its default value. The hasBrightness()
     * method will return false.
     */
    inline void clearBrightness();

    /**
     * Checks whether the field "Brightness" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrightness()). Otherwise it will return false.
     */
    inline bool hasBrightness () const;

    /**
     * Returns the value of the member "Brightness".
     *
     * The brightness value to be set.
     *
     * @return The value of the field "Brightness"
     */
    inline ::dimming_main_fi_types::T_u16_DIM_Permille getBrightness () const;

    /**
     * Sets the value of the member "Brightness".
     *
     * The brightness value to be set.
     *
     * @param Brightness The value which will be set
     */
    inline void setBrightness (::dimming_main_fi_types::T_u16_DIM_Permille Brightness_);

    static const DIM_INFO_SetDimmingBrightnessStart &getDefaultInstance();

private:

    inline void set_has_LUN ();

    inline void clear_has_LUN ();

    inline void set_has_Brightness ();

    inline void clear_has_Brightness ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::dimming_main_fi_types::T_u8_DIM_LUN _LUN;

    ::dimming_main_fi_types::T_u16_DIM_Permille _Brightness;

};

/**
 * The result message of the method "DIM_INFO_SetDimmingBrightness"
 * <p>Set the dimming value (in permille) for a specific LUN</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_INFO_SetDimmingBrightnessResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_SetDimmingBrightnessResult ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_SetDimmingBrightnessResult (const DIM_INFO_SetDimmingBrightnessResult &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_SetDimmingBrightnessResult (::dimming_main_fi_types::T_u8_DIM_LUN LUN_, ::dimming_main_fi_types::T_u16_DIM_Permille Brightness_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_SetDimmingBrightnessResult();

    /**
     * Assignment operator
     */
    inline DIM_INFO_SetDimmingBrightnessResult& operator = (const DIM_INFO_SetDimmingBrightnessResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_SetDimmingBrightnessResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_SetDimmingBrightnessResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_SetDimmingBrightnessResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_SetDimmingBrightnessResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LUN"

    static const int kLUN = 0;

    /**
     * Clears the field "LUN".
     *
     * The field will be set to its default value. The hasLUN()
     * method will return false.
     */
    inline void clearLUN();

    /**
     * Checks whether the field "LUN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLUN()). Otherwise it will return false.
     */
    inline bool hasLUN () const;

    /**
     * Returns the value of the member "LUN".
     *
     * The LUN identifier
     *
     * @return The value of the field "LUN"
     */
    inline ::dimming_main_fi_types::T_u8_DIM_LUN getLUN () const;

    /**
     * Sets the value of the member "LUN".
     *
     * The LUN identifier
     *
     * @param LUN The value which will be set
     */
    inline void setLUN (::dimming_main_fi_types::T_u8_DIM_LUN LUN_);

    // API of field "Brightness"

    static const int kBrightness = 1;

    /**
     * Clears the field "Brightness".
     *
     * The field will be set to its default value. The hasBrightness()
     * method will return false.
     */
    inline void clearBrightness();

    /**
     * Checks whether the field "Brightness" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrightness()). Otherwise it will return false.
     */
    inline bool hasBrightness () const;

    /**
     * Returns the value of the member "Brightness".
     *
     * Status of the brightness value for the requested LUN.
     * Depending on the configuration (for example using the output stepper)
     * this value will change over time.
     *
     * @return The value of the field "Brightness"
     */
    inline ::dimming_main_fi_types::T_u16_DIM_Permille getBrightness () const;

    /**
     * Sets the value of the member "Brightness".
     *
     * Status of the brightness value for the requested LUN.
     * Depending on the configuration (for example using the output stepper)
     * this value will change over time.
     *
     * @param Brightness The value which will be set
     */
    inline void setBrightness (::dimming_main_fi_types::T_u16_DIM_Permille Brightness_);

    static const DIM_INFO_SetDimmingBrightnessResult &getDefaultInstance();

private:

    inline void set_has_LUN ();

    inline void clear_has_LUN ();

    inline void set_has_Brightness ();

    inline void clear_has_Brightness ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::dimming_main_fi_types::T_u8_DIM_LUN _LUN;

    ::dimming_main_fi_types::T_u16_DIM_Permille _Brightness;

};

/**
 * The error message of 'DIM_INFO_SetDimmingBrightness'
 */
class DIM_INFO_SetDimmingBrightnessErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_SetDimmingBrightnessErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_SetDimmingBrightnessErrorStructure (const DIM_INFO_SetDimmingBrightnessErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_SetDimmingBrightnessErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_INFO_SetDimmingBrightnessErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_INFO_SetDimmingBrightnessErrorStructure& operator = (const DIM_INFO_SetDimmingBrightnessErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_SetDimmingBrightnessErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_SetDimmingBrightnessErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_SetDimmingBrightnessErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_SetDimmingBrightnessErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_INFO_SetDimmingBrightnessErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_INFO_SetDimmingBrightness'
 */
class DIM_INFO_SetDimmingBrightnessError  : public ::asf::core::Payload {
public:

    enum DIM_INFO_SetDimmingBrightnessErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_INFO_SetDimmingBrightnessError ();

   /**
     * Copy constructor
     */
    inline  DIM_INFO_SetDimmingBrightnessError (const DIM_INFO_SetDimmingBrightnessError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_SetDimmingBrightnessError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_INFO_SetDimmingBrightnessError& operator = (const DIM_INFO_SetDimmingBrightnessError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_SetDimmingBrightnessError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_SetDimmingBrightnessError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_SetDimmingBrightnessError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_SetDimmingBrightnessError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_INFO_SetDimmingBrightnessError::DIM_INFO_SetDimmingBrightnessErrorField getField () const;

    inline void setField(DIM_INFO_SetDimmingBrightnessError::DIM_INFO_SetDimmingBrightnessErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_INFO_SetDimmingBrightnessErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_INFO_SetDimmingBrightnessErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_INFO_SetDimmingBrightnessErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_INFO_SetDimmingBrightnessErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_INFO_SetDimmingBrightnessErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_INFO_SetDimmingBrightnessErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_INFO_SetDimmingBrightnessErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_INFO_SetDimmingBrightnessErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_INFO_SetDimmingBrightnessError &getDefaultInstance();

private:

    inline void cloneData (const DIM_INFO_SetDimmingBrightnessError& rhs);

    inline void deleteData ();

    DIM_INFO_SetDimmingBrightnessErrorField __field;

    union {
        DIM_INFO_SetDimmingBrightnessErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DIM_INFO_GetDimmingBrightness"
 * <p>Get the dimming value (in permille) for a specific LUN</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_INFO_GetDimmingBrightnessStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_GetDimmingBrightnessStart ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_GetDimmingBrightnessStart (const DIM_INFO_GetDimmingBrightnessStart &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_GetDimmingBrightnessStart (::dimming_main_fi_types::T_u8_DIM_LUN LUN_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_GetDimmingBrightnessStart();

    /**
     * Assignment operator
     */
    inline DIM_INFO_GetDimmingBrightnessStart& operator = (const DIM_INFO_GetDimmingBrightnessStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_GetDimmingBrightnessStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_GetDimmingBrightnessStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_GetDimmingBrightnessStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_GetDimmingBrightnessStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LUN"

    static const int kLUN = 0;

    /**
     * Clears the field "LUN".
     *
     * The field will be set to its default value. The hasLUN()
     * method will return false.
     */
    inline void clearLUN();

    /**
     * Checks whether the field "LUN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLUN()). Otherwise it will return false.
     */
    inline bool hasLUN () const;

    /**
     * Returns the value of the member "LUN".
     *
     * The LUN identifier
     *
     * @return The value of the field "LUN"
     */
    inline ::dimming_main_fi_types::T_u8_DIM_LUN getLUN () const;

    /**
     * Sets the value of the member "LUN".
     *
     * The LUN identifier
     *
     * @param LUN The value which will be set
     */
    inline void setLUN (::dimming_main_fi_types::T_u8_DIM_LUN LUN_);

    static const DIM_INFO_GetDimmingBrightnessStart &getDefaultInstance();

private:

    inline void set_has_LUN ();

    inline void clear_has_LUN ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_u8_DIM_LUN _LUN;

};

/**
 * The result message of the method "DIM_INFO_GetDimmingBrightness"
 * <p>Get the dimming value (in permille) for a specific LUN</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_INFO_GetDimmingBrightnessResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_GetDimmingBrightnessResult ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_GetDimmingBrightnessResult (const DIM_INFO_GetDimmingBrightnessResult &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_GetDimmingBrightnessResult (::dimming_main_fi_types::T_u8_DIM_LUN LUN_, ::dimming_main_fi_types::T_u16_DIM_Permille Brightness_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_GetDimmingBrightnessResult();

    /**
     * Assignment operator
     */
    inline DIM_INFO_GetDimmingBrightnessResult& operator = (const DIM_INFO_GetDimmingBrightnessResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_GetDimmingBrightnessResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_GetDimmingBrightnessResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_GetDimmingBrightnessResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_GetDimmingBrightnessResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LUN"

    static const int kLUN = 0;

    /**
     * Clears the field "LUN".
     *
     * The field will be set to its default value. The hasLUN()
     * method will return false.
     */
    inline void clearLUN();

    /**
     * Checks whether the field "LUN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLUN()). Otherwise it will return false.
     */
    inline bool hasLUN () const;

    /**
     * Returns the value of the member "LUN".
     *
     * The LUN identifier
     *
     * @return The value of the field "LUN"
     */
    inline ::dimming_main_fi_types::T_u8_DIM_LUN getLUN () const;

    /**
     * Sets the value of the member "LUN".
     *
     * The LUN identifier
     *
     * @param LUN The value which will be set
     */
    inline void setLUN (::dimming_main_fi_types::T_u8_DIM_LUN LUN_);

    // API of field "Brightness"

    static const int kBrightness = 1;

    /**
     * Clears the field "Brightness".
     *
     * The field will be set to its default value. The hasBrightness()
     * method will return false.
     */
    inline void clearBrightness();

    /**
     * Checks whether the field "Brightness" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrightness()). Otherwise it will return false.
     */
    inline bool hasBrightness () const;

    /**
     * Returns the value of the member "Brightness".
     *
     * Status of the dimming value for requested LUN.
     *
     * @return The value of the field "Brightness"
     */
    inline ::dimming_main_fi_types::T_u16_DIM_Permille getBrightness () const;

    /**
     * Sets the value of the member "Brightness".
     *
     * Status of the dimming value for requested LUN.
     *
     * @param Brightness The value which will be set
     */
    inline void setBrightness (::dimming_main_fi_types::T_u16_DIM_Permille Brightness_);

    static const DIM_INFO_GetDimmingBrightnessResult &getDefaultInstance();

private:

    inline void set_has_LUN ();

    inline void clear_has_LUN ();

    inline void set_has_Brightness ();

    inline void clear_has_Brightness ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::dimming_main_fi_types::T_u8_DIM_LUN _LUN;

    ::dimming_main_fi_types::T_u16_DIM_Permille _Brightness;

};

/**
 * The error message of 'DIM_INFO_GetDimmingBrightness'
 */
class DIM_INFO_GetDimmingBrightnessErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_GetDimmingBrightnessErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_GetDimmingBrightnessErrorStructure (const DIM_INFO_GetDimmingBrightnessErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_GetDimmingBrightnessErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_INFO_GetDimmingBrightnessErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_INFO_GetDimmingBrightnessErrorStructure& operator = (const DIM_INFO_GetDimmingBrightnessErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_GetDimmingBrightnessErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_GetDimmingBrightnessErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_GetDimmingBrightnessErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_GetDimmingBrightnessErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_INFO_GetDimmingBrightnessErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_INFO_GetDimmingBrightness'
 */
class DIM_INFO_GetDimmingBrightnessError  : public ::asf::core::Payload {
public:

    enum DIM_INFO_GetDimmingBrightnessErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_INFO_GetDimmingBrightnessError ();

   /**
     * Copy constructor
     */
    inline  DIM_INFO_GetDimmingBrightnessError (const DIM_INFO_GetDimmingBrightnessError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_GetDimmingBrightnessError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_INFO_GetDimmingBrightnessError& operator = (const DIM_INFO_GetDimmingBrightnessError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_GetDimmingBrightnessError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_GetDimmingBrightnessError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_GetDimmingBrightnessError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_GetDimmingBrightnessError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_INFO_GetDimmingBrightnessError::DIM_INFO_GetDimmingBrightnessErrorField getField () const;

    inline void setField(DIM_INFO_GetDimmingBrightnessError::DIM_INFO_GetDimmingBrightnessErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_INFO_GetDimmingBrightnessErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_INFO_GetDimmingBrightnessErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_INFO_GetDimmingBrightnessErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_INFO_GetDimmingBrightnessErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_INFO_GetDimmingBrightnessErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_INFO_GetDimmingBrightnessErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_INFO_GetDimmingBrightnessErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_INFO_GetDimmingBrightnessErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_INFO_GetDimmingBrightnessError &getDefaultInstance();

private:

    inline void cloneData (const DIM_INFO_GetDimmingBrightnessError& rhs);

    inline void deleteData ();

    DIM_INFO_GetDimmingBrightnessErrorField __field;

    union {
        DIM_INFO_GetDimmingBrightnessErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "DIM_INFO_GetPWMBrightness"
 * <p>Get the dimming value (in permille) for wire PWM input</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_INFO_GetPWMBrightnessResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_GetPWMBrightnessResult ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_GetPWMBrightnessResult (const DIM_INFO_GetPWMBrightnessResult &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_GetPWMBrightnessResult (::dimming_main_fi_types::T_u16_DIM_Permille Brightness_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_GetPWMBrightnessResult();

    /**
     * Assignment operator
     */
    inline DIM_INFO_GetPWMBrightnessResult& operator = (const DIM_INFO_GetPWMBrightnessResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_GetPWMBrightnessResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_GetPWMBrightnessResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_GetPWMBrightnessResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_GetPWMBrightnessResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Brightness"

    static const int kBrightness = 0;

    /**
     * Clears the field "Brightness".
     *
     * The field will be set to its default value. The hasBrightness()
     * method will return false.
     */
    inline void clearBrightness();

    /**
     * Checks whether the field "Brightness" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrightness()). Otherwise it will return false.
     */
    inline bool hasBrightness () const;

    /**
     * Returns the value of the member "Brightness".
     *
     * Status of the dimming value for PWM input.
     *
     * @return The value of the field "Brightness"
     */
    inline ::dimming_main_fi_types::T_u16_DIM_Permille getBrightness () const;

    /**
     * Sets the value of the member "Brightness".
     *
     * Status of the dimming value for PWM input.
     *
     * @param Brightness The value which will be set
     */
    inline void setBrightness (::dimming_main_fi_types::T_u16_DIM_Permille Brightness_);

    static const DIM_INFO_GetPWMBrightnessResult &getDefaultInstance();

private:

    inline void set_has_Brightness ();

    inline void clear_has_Brightness ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_u16_DIM_Permille _Brightness;

};

/**
 * The error message of 'DIM_INFO_GetPWMBrightness'
 */
class DIM_INFO_GetPWMBrightnessErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_INFO_GetPWMBrightnessErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_INFO_GetPWMBrightnessErrorStructure (const DIM_INFO_GetPWMBrightnessErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_INFO_GetPWMBrightnessErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_INFO_GetPWMBrightnessErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_INFO_GetPWMBrightnessErrorStructure& operator = (const DIM_INFO_GetPWMBrightnessErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_GetPWMBrightnessErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_GetPWMBrightnessErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_GetPWMBrightnessErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_GetPWMBrightnessErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_INFO_GetPWMBrightnessErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_INFO_GetPWMBrightness'
 */
class DIM_INFO_GetPWMBrightnessError  : public ::asf::core::Payload {
public:

    enum DIM_INFO_GetPWMBrightnessErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_INFO_GetPWMBrightnessError ();

   /**
     * Copy constructor
     */
    inline  DIM_INFO_GetPWMBrightnessError (const DIM_INFO_GetPWMBrightnessError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_INFO_GetPWMBrightnessError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_INFO_GetPWMBrightnessError& operator = (const DIM_INFO_GetPWMBrightnessError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_INFO_GetPWMBrightnessError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_INFO_GetPWMBrightnessError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_INFO_GetPWMBrightnessError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_INFO_GetPWMBrightnessError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_INFO_GetPWMBrightnessError::DIM_INFO_GetPWMBrightnessErrorField getField () const;

    inline void setField(DIM_INFO_GetPWMBrightnessError::DIM_INFO_GetPWMBrightnessErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_INFO_GetPWMBrightnessErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_INFO_GetPWMBrightnessErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_INFO_GetPWMBrightnessErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_INFO_GetPWMBrightnessErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_INFO_GetPWMBrightnessErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_INFO_GetPWMBrightnessErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_INFO_GetPWMBrightnessErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_INFO_GetPWMBrightnessErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_INFO_GetPWMBrightnessError &getDefaultInstance();

private:

    inline void cloneData (const DIM_INFO_GetPWMBrightnessError& rhs);

    inline void deleteData ();

    DIM_INFO_GetPWMBrightnessErrorField __field;

    union {
        DIM_INFO_GetPWMBrightnessErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DIM_KEYB_SetDimming"
 * <p>Sets the dimming brightness for the keyboard.
 * If brightness is set to "0%" then dimming/illumination of the keyboard is switched to "off"
 * This method is identical to DIM_SetDimmingBrightness and DIM_SetDimmingState if called for all LUNs except 0.
 * It is introduced for a much easier handling.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_KEYB_SetDimmingStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_KEYB_SetDimmingStart ();

    /**
     * Copy constructor
     */
    inline  DIM_KEYB_SetDimmingStart (const DIM_KEYB_SetDimmingStart &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_KEYB_SetDimmingStart (::dimming_main_fi_types::T_u16_DIM_Permille Brightness_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_KEYB_SetDimmingStart();

    /**
     * Assignment operator
     */
    inline DIM_KEYB_SetDimmingStart& operator = (const DIM_KEYB_SetDimmingStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_KEYB_SetDimmingStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_KEYB_SetDimmingStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_KEYB_SetDimmingStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_KEYB_SetDimmingStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Brightness"

    static const int kBrightness = 0;

    /**
     * Clears the field "Brightness".
     *
     * The field will be set to its default value. The hasBrightness()
     * method will return false.
     */
    inline void clearBrightness();

    /**
     * Checks whether the field "Brightness" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrightness()). Otherwise it will return false.
     */
    inline bool hasBrightness () const;

    /**
     * Returns the value of the member "Brightness".
     *
     * Status of the dimming brightness value for keyboard.
     *
     * @return The value of the field "Brightness"
     */
    inline ::dimming_main_fi_types::T_u16_DIM_Permille getBrightness () const;

    /**
     * Sets the value of the member "Brightness".
     *
     * Status of the dimming brightness value for keyboard.
     *
     * @param Brightness The value which will be set
     */
    inline void setBrightness (::dimming_main_fi_types::T_u16_DIM_Permille Brightness_);

    static const DIM_KEYB_SetDimmingStart &getDefaultInstance();

private:

    inline void set_has_Brightness ();

    inline void clear_has_Brightness ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_u16_DIM_Permille _Brightness;

};

/**
 * The result message of the method "DIM_KEYB_SetDimming"
 * <p>Sets the dimming brightness for the keyboard.
 * If brightness is set to "0%" then dimming/illumination of the keyboard is switched to "off"
 * This method is identical to DIM_SetDimmingBrightness and DIM_SetDimmingState if called for all LUNs except 0.
 * It is introduced for a much easier handling.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_KEYB_SetDimmingResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_KEYB_SetDimmingResult ();

    /**
     * Copy constructor
     */
    inline  DIM_KEYB_SetDimmingResult (const DIM_KEYB_SetDimmingResult &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_KEYB_SetDimmingResult (::dimming_main_fi_types::T_u16_DIM_Permille Brightness_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_KEYB_SetDimmingResult();

    /**
     * Assignment operator
     */
    inline DIM_KEYB_SetDimmingResult& operator = (const DIM_KEYB_SetDimmingResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_KEYB_SetDimmingResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_KEYB_SetDimmingResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_KEYB_SetDimmingResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_KEYB_SetDimmingResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Brightness"

    static const int kBrightness = 0;

    /**
     * Clears the field "Brightness".
     *
     * The field will be set to its default value. The hasBrightness()
     * method will return false.
     */
    inline void clearBrightness();

    /**
     * Checks whether the field "Brightness" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrightness()). Otherwise it will return false.
     */
    inline bool hasBrightness () const;

    /**
     * Returns the value of the member "Brightness".
     *
     * Status of the dimming brightness value for keyboard.
     *
     * @return The value of the field "Brightness"
     */
    inline ::dimming_main_fi_types::T_u16_DIM_Permille getBrightness () const;

    /**
     * Sets the value of the member "Brightness".
     *
     * Status of the dimming brightness value for keyboard.
     *
     * @param Brightness The value which will be set
     */
    inline void setBrightness (::dimming_main_fi_types::T_u16_DIM_Permille Brightness_);

    static const DIM_KEYB_SetDimmingResult &getDefaultInstance();

private:

    inline void set_has_Brightness ();

    inline void clear_has_Brightness ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_u16_DIM_Permille _Brightness;

};

/**
 * The error message of 'DIM_KEYB_SetDimming'
 */
class DIM_KEYB_SetDimmingErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_KEYB_SetDimmingErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_KEYB_SetDimmingErrorStructure (const DIM_KEYB_SetDimmingErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_KEYB_SetDimmingErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_KEYB_SetDimmingErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_KEYB_SetDimmingErrorStructure& operator = (const DIM_KEYB_SetDimmingErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_KEYB_SetDimmingErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_KEYB_SetDimmingErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_KEYB_SetDimmingErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_KEYB_SetDimmingErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_KEYB_SetDimmingErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_KEYB_SetDimming'
 */
class DIM_KEYB_SetDimmingError  : public ::asf::core::Payload {
public:

    enum DIM_KEYB_SetDimmingErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_KEYB_SetDimmingError ();

   /**
     * Copy constructor
     */
    inline  DIM_KEYB_SetDimmingError (const DIM_KEYB_SetDimmingError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_KEYB_SetDimmingError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_KEYB_SetDimmingError& operator = (const DIM_KEYB_SetDimmingError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_KEYB_SetDimmingError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_KEYB_SetDimmingError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_KEYB_SetDimmingError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_KEYB_SetDimmingError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_KEYB_SetDimmingError::DIM_KEYB_SetDimmingErrorField getField () const;

    inline void setField(DIM_KEYB_SetDimmingError::DIM_KEYB_SetDimmingErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_KEYB_SetDimmingErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_KEYB_SetDimmingErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_KEYB_SetDimmingErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_KEYB_SetDimmingErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_KEYB_SetDimmingErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_KEYB_SetDimmingErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_KEYB_SetDimmingErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_KEYB_SetDimmingErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_KEYB_SetDimmingError &getDefaultInstance();

private:

    inline void cloneData (const DIM_KEYB_SetDimmingError& rhs);

    inline void deleteData ();

    DIM_KEYB_SetDimmingErrorField __field;

    union {
        DIM_KEYB_SetDimmingErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DIM_KEYB_SetDimmingPWM"
 * <p>Sets the PWM dimming brightness for the keyboard. This is an adjustment value.
 * If brightness is set to "0%" then dimming/illumination of the keyboard is switched to "off"</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_KEYB_SetDimmingPWMStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_KEYB_SetDimmingPWMStart ();

    /**
     * Copy constructor
     */
    inline  DIM_KEYB_SetDimmingPWMStart (const DIM_KEYB_SetDimmingPWMStart &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_KEYB_SetDimmingPWMStart (::dimming_main_fi_types::T_u16_DIM_Permille Brightness_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_KEYB_SetDimmingPWMStart();

    /**
     * Assignment operator
     */
    inline DIM_KEYB_SetDimmingPWMStart& operator = (const DIM_KEYB_SetDimmingPWMStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_KEYB_SetDimmingPWMStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_KEYB_SetDimmingPWMStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_KEYB_SetDimmingPWMStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_KEYB_SetDimmingPWMStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Brightness"

    static const int kBrightness = 0;

    /**
     * Clears the field "Brightness".
     *
     * The field will be set to its default value. The hasBrightness()
     * method will return false.
     */
    inline void clearBrightness();

    /**
     * Checks whether the field "Brightness" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrightness()). Otherwise it will return false.
     */
    inline bool hasBrightness () const;

    /**
     * Returns the value of the member "Brightness".
     *
     * Status of the dimming brightness value for keyboard.
     *
     * @return The value of the field "Brightness"
     */
    inline ::dimming_main_fi_types::T_u16_DIM_Permille getBrightness () const;

    /**
     * Sets the value of the member "Brightness".
     *
     * Status of the dimming brightness value for keyboard.
     *
     * @param Brightness The value which will be set
     */
    inline void setBrightness (::dimming_main_fi_types::T_u16_DIM_Permille Brightness_);

    static const DIM_KEYB_SetDimmingPWMStart &getDefaultInstance();

private:

    inline void set_has_Brightness ();

    inline void clear_has_Brightness ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_u16_DIM_Permille _Brightness;

};

/**
 * The result message of the method "DIM_KEYB_SetDimmingPWM"
 * <p>Sets the PWM dimming brightness for the keyboard. This is an adjustment value.
 * If brightness is set to "0%" then dimming/illumination of the keyboard is switched to "off"</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_KEYB_SetDimmingPWMResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_KEYB_SetDimmingPWMResult ();

    /**
     * Copy constructor
     */
    inline  DIM_KEYB_SetDimmingPWMResult (const DIM_KEYB_SetDimmingPWMResult &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_KEYB_SetDimmingPWMResult (::dimming_main_fi_types::T_u16_DIM_Permille Brightness_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_KEYB_SetDimmingPWMResult();

    /**
     * Assignment operator
     */
    inline DIM_KEYB_SetDimmingPWMResult& operator = (const DIM_KEYB_SetDimmingPWMResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_KEYB_SetDimmingPWMResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_KEYB_SetDimmingPWMResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_KEYB_SetDimmingPWMResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_KEYB_SetDimmingPWMResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Brightness"

    static const int kBrightness = 0;

    /**
     * Clears the field "Brightness".
     *
     * The field will be set to its default value. The hasBrightness()
     * method will return false.
     */
    inline void clearBrightness();

    /**
     * Checks whether the field "Brightness" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrightness()). Otherwise it will return false.
     */
    inline bool hasBrightness () const;

    /**
     * Returns the value of the member "Brightness".
     *
     * Status of the dimming brightness value for keyboard.
     *
     * @return The value of the field "Brightness"
     */
    inline ::dimming_main_fi_types::T_u16_DIM_Permille getBrightness () const;

    /**
     * Sets the value of the member "Brightness".
     *
     * Status of the dimming brightness value for keyboard.
     *
     * @param Brightness The value which will be set
     */
    inline void setBrightness (::dimming_main_fi_types::T_u16_DIM_Permille Brightness_);

    static const DIM_KEYB_SetDimmingPWMResult &getDefaultInstance();

private:

    inline void set_has_Brightness ();

    inline void clear_has_Brightness ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_u16_DIM_Permille _Brightness;

};

/**
 * The error message of 'DIM_KEYB_SetDimmingPWM'
 */
class DIM_KEYB_SetDimmingPWMErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_KEYB_SetDimmingPWMErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_KEYB_SetDimmingPWMErrorStructure (const DIM_KEYB_SetDimmingPWMErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_KEYB_SetDimmingPWMErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_KEYB_SetDimmingPWMErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_KEYB_SetDimmingPWMErrorStructure& operator = (const DIM_KEYB_SetDimmingPWMErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_KEYB_SetDimmingPWMErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_KEYB_SetDimmingPWMErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_KEYB_SetDimmingPWMErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_KEYB_SetDimmingPWMErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_KEYB_SetDimmingPWMErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_KEYB_SetDimmingPWM'
 */
class DIM_KEYB_SetDimmingPWMError  : public ::asf::core::Payload {
public:

    enum DIM_KEYB_SetDimmingPWMErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_KEYB_SetDimmingPWMError ();

   /**
     * Copy constructor
     */
    inline  DIM_KEYB_SetDimmingPWMError (const DIM_KEYB_SetDimmingPWMError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_KEYB_SetDimmingPWMError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_KEYB_SetDimmingPWMError& operator = (const DIM_KEYB_SetDimmingPWMError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_KEYB_SetDimmingPWMError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_KEYB_SetDimmingPWMError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_KEYB_SetDimmingPWMError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_KEYB_SetDimmingPWMError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_KEYB_SetDimmingPWMError::DIM_KEYB_SetDimmingPWMErrorField getField () const;

    inline void setField(DIM_KEYB_SetDimmingPWMError::DIM_KEYB_SetDimmingPWMErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_KEYB_SetDimmingPWMErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_KEYB_SetDimmingPWMErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_KEYB_SetDimmingPWMErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_KEYB_SetDimmingPWMErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_KEYB_SetDimmingPWMErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_KEYB_SetDimmingPWMErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_KEYB_SetDimmingPWMErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_KEYB_SetDimmingPWMErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_KEYB_SetDimmingPWMError &getDefaultInstance();

private:

    inline void cloneData (const DIM_KEYB_SetDimmingPWMError& rhs);

    inline void deleteData ();

    DIM_KEYB_SetDimmingPWMErrorField __field;

    union {
        DIM_KEYB_SetDimmingPWMErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DIM_DISP_SetDriverInitalized"
 * <p>Used to set the initialization status of the display driver.
 * This is used by VD_Dimming to determine the backlight status</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_SetDriverInitalizedStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetDriverInitalizedStart ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetDriverInitalizedStart (const DIM_DISP_SetDriverInitalizedStart &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetDriverInitalizedStart (::dimming_main_fi_types::T_e8_DIM_Status SetDriverInitialized_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetDriverInitalizedStart();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetDriverInitalizedStart& operator = (const DIM_DISP_SetDriverInitalizedStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetDriverInitalizedStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetDriverInitalizedStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetDriverInitalizedStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetDriverInitalizedStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SetDriverInitialized"

    static const int kSetDriverInitialized = 0;

    /**
     * Clears the field "SetDriverInitialized".
     *
     * The field will be set to its default value. The hasSetDriverInitialized()
     * method will return false.
     */
    inline void clearSetDriverInitialized();

    /**
     * Checks whether the field "SetDriverInitialized" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSetDriverInitialized()). Otherwise it will return false.
     */
    inline bool hasSetDriverInitialized () const;

    /**
     * Returns the value of the member "SetDriverInitialized".
     *
     * Initialization status of the display driver
     *
     * @return The value of the field "SetDriverInitialized"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_Status getSetDriverInitialized () const;

    /**
     * Sets the value of the member "SetDriverInitialized".
     *
     * Initialization status of the display driver
     *
     * @param SetDriverInitialized The value which will be set
     */
    inline void setSetDriverInitialized (::dimming_main_fi_types::T_e8_DIM_Status SetDriverInitialized_);

    static const DIM_DISP_SetDriverInitalizedStart &getDefaultInstance();

private:

    inline void set_has_SetDriverInitialized ();

    inline void clear_has_SetDriverInitialized ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_e8_DIM_Status _SetDriverInitialized;

};

/**
 * The result message of the method "DIM_DISP_SetDriverInitalized"
 * <p>Used to set the initialization status of the display driver.
 * This is used by VD_Dimming to determine the backlight status</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_SetDriverInitalizedResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetDriverInitalizedResult ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetDriverInitalizedResult (const DIM_DISP_SetDriverInitalizedResult &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetDriverInitalizedResult (::dimming_main_fi_types::T_e8_DIM_Status SetDriverInitialized_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetDriverInitalizedResult();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetDriverInitalizedResult& operator = (const DIM_DISP_SetDriverInitalizedResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetDriverInitalizedResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetDriverInitalizedResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetDriverInitalizedResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetDriverInitalizedResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SetDriverInitialized"

    static const int kSetDriverInitialized = 0;

    /**
     * Clears the field "SetDriverInitialized".
     *
     * The field will be set to its default value. The hasSetDriverInitialized()
     * method will return false.
     */
    inline void clearSetDriverInitialized();

    /**
     * Checks whether the field "SetDriverInitialized" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSetDriverInitialized()). Otherwise it will return false.
     */
    inline bool hasSetDriverInitialized () const;

    /**
     * Returns the value of the member "SetDriverInitialized".
     *
     * Initialization status of the display driver
     *
     * @return The value of the field "SetDriverInitialized"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_Status getSetDriverInitialized () const;

    /**
     * Sets the value of the member "SetDriverInitialized".
     *
     * Initialization status of the display driver
     *
     * @param SetDriverInitialized The value which will be set
     */
    inline void setSetDriverInitialized (::dimming_main_fi_types::T_e8_DIM_Status SetDriverInitialized_);

    static const DIM_DISP_SetDriverInitalizedResult &getDefaultInstance();

private:

    inline void set_has_SetDriverInitialized ();

    inline void clear_has_SetDriverInitialized ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_e8_DIM_Status _SetDriverInitialized;

};

/**
 * The error message of 'DIM_DISP_SetDriverInitalized'
 */
class DIM_DISP_SetDriverInitalizedErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetDriverInitalizedErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetDriverInitalizedErrorStructure (const DIM_DISP_SetDriverInitalizedErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetDriverInitalizedErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_SetDriverInitalizedErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetDriverInitalizedErrorStructure& operator = (const DIM_DISP_SetDriverInitalizedErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetDriverInitalizedErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetDriverInitalizedErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetDriverInitalizedErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetDriverInitalizedErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_SetDriverInitalizedErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_SetDriverInitalized'
 */
class DIM_DISP_SetDriverInitalizedError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_SetDriverInitalizedErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_SetDriverInitalizedError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_SetDriverInitalizedError (const DIM_DISP_SetDriverInitalizedError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetDriverInitalizedError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_SetDriverInitalizedError& operator = (const DIM_DISP_SetDriverInitalizedError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetDriverInitalizedError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetDriverInitalizedError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetDriverInitalizedError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetDriverInitalizedError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_SetDriverInitalizedError::DIM_DISP_SetDriverInitalizedErrorField getField () const;

    inline void setField(DIM_DISP_SetDriverInitalizedError::DIM_DISP_SetDriverInitalizedErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_SetDriverInitalizedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_SetDriverInitalizedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_SetDriverInitalizedErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_SetDriverInitalizedErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_SetDriverInitalizedErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_SetDriverInitalizedErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_SetDriverInitalizedErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_SetDriverInitalizedErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_SetDriverInitalizedError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_SetDriverInitalizedError& rhs);

    inline void deleteData ();

    DIM_DISP_SetDriverInitalizedErrorField __field;

    union {
        DIM_DISP_SetDriverInitalizedErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DIM_DISP_SetScreenContentAvailable"
 * <p>Used to set the availablity of screen content.
 * The availability of screen content is necessary for VD_Dimming to activate the backlight.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_SetScreenContentAvailableStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetScreenContentAvailableStart ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetScreenContentAvailableStart (const DIM_DISP_SetScreenContentAvailableStart &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetScreenContentAvailableStart (::dimming_main_fi_types::T_e8_DIM_Status SetScreenContentAvailable_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetScreenContentAvailableStart();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetScreenContentAvailableStart& operator = (const DIM_DISP_SetScreenContentAvailableStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetScreenContentAvailableStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetScreenContentAvailableStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetScreenContentAvailableStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetScreenContentAvailableStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SetScreenContentAvailable"

    static const int kSetScreenContentAvailable = 0;

    /**
     * Clears the field "SetScreenContentAvailable".
     *
     * The field will be set to its default value. The hasSetScreenContentAvailable()
     * method will return false.
     */
    inline void clearSetScreenContentAvailable();

    /**
     * Checks whether the field "SetScreenContentAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSetScreenContentAvailable()). Otherwise it will return false.
     */
    inline bool hasSetScreenContentAvailable () const;

    /**
     * Returns the value of the member "SetScreenContentAvailable".
     *
     * Status of the screen content availability
     *
     * @return The value of the field "SetScreenContentAvailable"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_Status getSetScreenContentAvailable () const;

    /**
     * Sets the value of the member "SetScreenContentAvailable".
     *
     * Status of the screen content availability
     *
     * @param SetScreenContentAvailable The value which will be set
     */
    inline void setSetScreenContentAvailable (::dimming_main_fi_types::T_e8_DIM_Status SetScreenContentAvailable_);

    static const DIM_DISP_SetScreenContentAvailableStart &getDefaultInstance();

private:

    inline void set_has_SetScreenContentAvailable ();

    inline void clear_has_SetScreenContentAvailable ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_e8_DIM_Status _SetScreenContentAvailable;

};

/**
 * The result message of the method "DIM_DISP_SetScreenContentAvailable"
 * <p>Used to set the availablity of screen content.
 * The availability of screen content is necessary for VD_Dimming to activate the backlight.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_SetScreenContentAvailableResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetScreenContentAvailableResult ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetScreenContentAvailableResult (const DIM_DISP_SetScreenContentAvailableResult &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetScreenContentAvailableResult (::dimming_main_fi_types::T_e8_DIM_Status SetScreenContentAvailable_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetScreenContentAvailableResult();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetScreenContentAvailableResult& operator = (const DIM_DISP_SetScreenContentAvailableResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetScreenContentAvailableResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetScreenContentAvailableResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetScreenContentAvailableResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetScreenContentAvailableResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SetScreenContentAvailable"

    static const int kSetScreenContentAvailable = 0;

    /**
     * Clears the field "SetScreenContentAvailable".
     *
     * The field will be set to its default value. The hasSetScreenContentAvailable()
     * method will return false.
     */
    inline void clearSetScreenContentAvailable();

    /**
     * Checks whether the field "SetScreenContentAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSetScreenContentAvailable()). Otherwise it will return false.
     */
    inline bool hasSetScreenContentAvailable () const;

    /**
     * Returns the value of the member "SetScreenContentAvailable".
     *
     * Status of the screen content availability
     *
     * @return The value of the field "SetScreenContentAvailable"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_Status getSetScreenContentAvailable () const;

    /**
     * Sets the value of the member "SetScreenContentAvailable".
     *
     * Status of the screen content availability
     *
     * @param SetScreenContentAvailable The value which will be set
     */
    inline void setSetScreenContentAvailable (::dimming_main_fi_types::T_e8_DIM_Status SetScreenContentAvailable_);

    static const DIM_DISP_SetScreenContentAvailableResult &getDefaultInstance();

private:

    inline void set_has_SetScreenContentAvailable ();

    inline void clear_has_SetScreenContentAvailable ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_e8_DIM_Status _SetScreenContentAvailable;

};

/**
 * The error message of 'DIM_DISP_SetScreenContentAvailable'
 */
class DIM_DISP_SetScreenContentAvailableErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetScreenContentAvailableErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetScreenContentAvailableErrorStructure (const DIM_DISP_SetScreenContentAvailableErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetScreenContentAvailableErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_SetScreenContentAvailableErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetScreenContentAvailableErrorStructure& operator = (const DIM_DISP_SetScreenContentAvailableErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetScreenContentAvailableErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetScreenContentAvailableErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetScreenContentAvailableErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetScreenContentAvailableErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_SetScreenContentAvailableErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_SetScreenContentAvailable'
 */
class DIM_DISP_SetScreenContentAvailableError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_SetScreenContentAvailableErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_SetScreenContentAvailableError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_SetScreenContentAvailableError (const DIM_DISP_SetScreenContentAvailableError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetScreenContentAvailableError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_SetScreenContentAvailableError& operator = (const DIM_DISP_SetScreenContentAvailableError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetScreenContentAvailableError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetScreenContentAvailableError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetScreenContentAvailableError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetScreenContentAvailableError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_SetScreenContentAvailableError::DIM_DISP_SetScreenContentAvailableErrorField getField () const;

    inline void setField(DIM_DISP_SetScreenContentAvailableError::DIM_DISP_SetScreenContentAvailableErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_SetScreenContentAvailableErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_SetScreenContentAvailableErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_SetScreenContentAvailableErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_SetScreenContentAvailableErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_SetScreenContentAvailableErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_SetScreenContentAvailableErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_SetScreenContentAvailableErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_SetScreenContentAvailableErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_SetScreenContentAvailableError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_SetScreenContentAvailableError& rhs);

    inline void deleteData ();

    DIM_DISP_SetScreenContentAvailableErrorField __field;

    union {
        DIM_DISP_SetScreenContentAvailableErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DIM_DISP_SetDimming"
 * <p>Set dimming value for display</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_SetDimmingStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetDimmingStart ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetDimmingStart (const DIM_DISP_SetDimmingStart &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetDimmingStart (::dimming_main_fi_types::T_u16_DIM_Permille Brightness_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetDimmingStart();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetDimmingStart& operator = (const DIM_DISP_SetDimmingStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetDimmingStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetDimmingStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetDimmingStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetDimmingStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Brightness"

    static const int kBrightness = 0;

    /**
     * Clears the field "Brightness".
     *
     * The field will be set to its default value. The hasBrightness()
     * method will return false.
     */
    inline void clearBrightness();

    /**
     * Checks whether the field "Brightness" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrightness()). Otherwise it will return false.
     */
    inline bool hasBrightness () const;

    /**
     * Returns the value of the member "Brightness".
     *
     * The dimming brightness value to be set.
     *
     * @return The value of the field "Brightness"
     */
    inline ::dimming_main_fi_types::T_u16_DIM_Permille getBrightness () const;

    /**
     * Sets the value of the member "Brightness".
     *
     * The dimming brightness value to be set.
     *
     * @param Brightness The value which will be set
     */
    inline void setBrightness (::dimming_main_fi_types::T_u16_DIM_Permille Brightness_);

    static const DIM_DISP_SetDimmingStart &getDefaultInstance();

private:

    inline void set_has_Brightness ();

    inline void clear_has_Brightness ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_u16_DIM_Permille _Brightness;

};

/**
 * The result message of the method "DIM_DISP_SetDimming"
 * <p>Set dimming value for display</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_SetDimmingResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetDimmingResult ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetDimmingResult (const DIM_DISP_SetDimmingResult &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetDimmingResult (::dimming_main_fi_types::T_u16_DIM_Permille Brightness_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetDimmingResult();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetDimmingResult& operator = (const DIM_DISP_SetDimmingResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetDimmingResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetDimmingResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetDimmingResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetDimmingResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Brightness"

    static const int kBrightness = 0;

    /**
     * Clears the field "Brightness".
     *
     * The field will be set to its default value. The hasBrightness()
     * method will return false.
     */
    inline void clearBrightness();

    /**
     * Checks whether the field "Brightness" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrightness()). Otherwise it will return false.
     */
    inline bool hasBrightness () const;

    /**
     * Returns the value of the member "Brightness".
     *
     * Status of the dimming brightness value
     * Depending on the configuration (for example using the output stepper)
     * this value will change over time.
     *
     * @return The value of the field "Brightness"
     */
    inline ::dimming_main_fi_types::T_u16_DIM_Permille getBrightness () const;

    /**
     * Sets the value of the member "Brightness".
     *
     * Status of the dimming brightness value
     * Depending on the configuration (for example using the output stepper)
     * this value will change over time.
     *
     * @param Brightness The value which will be set
     */
    inline void setBrightness (::dimming_main_fi_types::T_u16_DIM_Permille Brightness_);

    static const DIM_DISP_SetDimmingResult &getDefaultInstance();

private:

    inline void set_has_Brightness ();

    inline void clear_has_Brightness ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_u16_DIM_Permille _Brightness;

};

/**
 * The error message of 'DIM_DISP_SetDimming'
 */
class DIM_DISP_SetDimmingErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetDimmingErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetDimmingErrorStructure (const DIM_DISP_SetDimmingErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetDimmingErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_SetDimmingErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetDimmingErrorStructure& operator = (const DIM_DISP_SetDimmingErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetDimmingErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetDimmingErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetDimmingErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetDimmingErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_SetDimmingErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_SetDimming'
 */
class DIM_DISP_SetDimmingError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_SetDimmingErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_SetDimmingError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_SetDimmingError (const DIM_DISP_SetDimmingError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetDimmingError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_SetDimmingError& operator = (const DIM_DISP_SetDimmingError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetDimmingError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetDimmingError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetDimmingError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetDimmingError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_SetDimmingError::DIM_DISP_SetDimmingErrorField getField () const;

    inline void setField(DIM_DISP_SetDimmingError::DIM_DISP_SetDimmingErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_SetDimmingErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_SetDimmingErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_SetDimmingErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_SetDimmingErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_SetDimmingErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_SetDimmingErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_SetDimmingErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_SetDimmingErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_SetDimmingError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_SetDimmingError& rhs);

    inline void deleteData ();

    DIM_DISP_SetDimmingErrorField __field;

    union {
        DIM_DISP_SetDimmingErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DIM_DISP_SwitchBacklight"
 * <p>Switches the backlight of the display on or off.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_SwitchBacklightStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SwitchBacklightStart ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SwitchBacklightStart (const DIM_DISP_SwitchBacklightStart &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SwitchBacklightStart (::dimming_main_fi_types::T_e8_DIM_Status SwitchBacklight_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SwitchBacklightStart();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SwitchBacklightStart& operator = (const DIM_DISP_SwitchBacklightStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SwitchBacklightStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SwitchBacklightStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SwitchBacklightStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SwitchBacklightStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SwitchBacklight"

    static const int kSwitchBacklight = 0;

    /**
     * Clears the field "SwitchBacklight".
     *
     * The field will be set to its default value. The hasSwitchBacklight()
     * method will return false.
     */
    inline void clearSwitchBacklight();

    /**
     * Checks whether the field "SwitchBacklight" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSwitchBacklight()). Otherwise it will return false.
     */
    inline bool hasSwitchBacklight () const;

    /**
     * Returns the value of the member "SwitchBacklight".
     *
     * Switches the backlight of the display on or off.
     * At the moment off and on is supported only.
     *
     * @return The value of the field "SwitchBacklight"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_Status getSwitchBacklight () const;

    /**
     * Sets the value of the member "SwitchBacklight".
     *
     * Switches the backlight of the display on or off.
     * At the moment off and on is supported only.
     *
     * @param SwitchBacklight The value which will be set
     */
    inline void setSwitchBacklight (::dimming_main_fi_types::T_e8_DIM_Status SwitchBacklight_);

    static const DIM_DISP_SwitchBacklightStart &getDefaultInstance();

private:

    inline void set_has_SwitchBacklight ();

    inline void clear_has_SwitchBacklight ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_e8_DIM_Status _SwitchBacklight;

};

/**
 * The result message of the method "DIM_DISP_SwitchBacklight"
 * <p>Switches the backlight of the display on or off.</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_SwitchBacklightResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SwitchBacklightResult ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SwitchBacklightResult (const DIM_DISP_SwitchBacklightResult &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SwitchBacklightResult (::dimming_main_fi_types::T_e8_DIM_Status SwitchBacklight_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SwitchBacklightResult();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SwitchBacklightResult& operator = (const DIM_DISP_SwitchBacklightResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SwitchBacklightResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SwitchBacklightResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SwitchBacklightResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SwitchBacklightResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SwitchBacklight"

    static const int kSwitchBacklight = 0;

    /**
     * Clears the field "SwitchBacklight".
     *
     * The field will be set to its default value. The hasSwitchBacklight()
     * method will return false.
     */
    inline void clearSwitchBacklight();

    /**
     * Checks whether the field "SwitchBacklight" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSwitchBacklight()). Otherwise it will return false.
     */
    inline bool hasSwitchBacklight () const;

    /**
     * Returns the value of the member "SwitchBacklight".
     *
     * Current status of the display backlight
     *
     * @return The value of the field "SwitchBacklight"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_Status getSwitchBacklight () const;

    /**
     * Sets the value of the member "SwitchBacklight".
     *
     * Current status of the display backlight
     *
     * @param SwitchBacklight The value which will be set
     */
    inline void setSwitchBacklight (::dimming_main_fi_types::T_e8_DIM_Status SwitchBacklight_);

    static const DIM_DISP_SwitchBacklightResult &getDefaultInstance();

private:

    inline void set_has_SwitchBacklight ();

    inline void clear_has_SwitchBacklight ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_e8_DIM_Status _SwitchBacklight;

};

/**
 * The error message of 'DIM_DISP_SwitchBacklight'
 */
class DIM_DISP_SwitchBacklightErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SwitchBacklightErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SwitchBacklightErrorStructure (const DIM_DISP_SwitchBacklightErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SwitchBacklightErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_SwitchBacklightErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SwitchBacklightErrorStructure& operator = (const DIM_DISP_SwitchBacklightErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SwitchBacklightErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SwitchBacklightErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SwitchBacklightErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SwitchBacklightErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_SwitchBacklightErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_SwitchBacklight'
 */
class DIM_DISP_SwitchBacklightError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_SwitchBacklightErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_SwitchBacklightError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_SwitchBacklightError (const DIM_DISP_SwitchBacklightError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SwitchBacklightError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_SwitchBacklightError& operator = (const DIM_DISP_SwitchBacklightError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SwitchBacklightError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SwitchBacklightError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SwitchBacklightError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SwitchBacklightError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_SwitchBacklightError::DIM_DISP_SwitchBacklightErrorField getField () const;

    inline void setField(DIM_DISP_SwitchBacklightError::DIM_DISP_SwitchBacklightErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_SwitchBacklightErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_SwitchBacklightErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_SwitchBacklightErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_SwitchBacklightErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_SwitchBacklightErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_SwitchBacklightErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_SwitchBacklightErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_SwitchBacklightErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_SwitchBacklightError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_SwitchBacklightError& rhs);

    inline void deleteData ();

    DIM_DISP_SwitchBacklightErrorField __field;

    union {
        DIM_DISP_SwitchBacklightErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DIM_DISP_SetBrightnessLevel"
 * <p>Sets the brightness level of the display to one of the defined levels</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_SetBrightnessLevelStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetBrightnessLevelStart ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetBrightnessLevelStart (const DIM_DISP_SetBrightnessLevelStart &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetBrightnessLevelStart (::dimming_main_fi_types::T_e8_DIM_BrightnessLevel BrightnessLevel_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetBrightnessLevelStart();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetBrightnessLevelStart& operator = (const DIM_DISP_SetBrightnessLevelStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetBrightnessLevelStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetBrightnessLevelStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetBrightnessLevelStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetBrightnessLevelStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BrightnessLevel"

    static const int kBrightnessLevel = 0;

    /**
     * Clears the field "BrightnessLevel".
     *
     * The field will be set to its default value. The hasBrightnessLevel()
     * method will return false.
     */
    inline void clearBrightnessLevel();

    /**
     * Checks whether the field "BrightnessLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrightnessLevel()). Otherwise it will return false.
     */
    inline bool hasBrightnessLevel () const;

    /**
     * Returns the value of the member "BrightnessLevel".
     *
     * Sets the display brightness level
     *
     * @return The value of the field "BrightnessLevel"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_BrightnessLevel getBrightnessLevel () const;

    /**
     * Sets the value of the member "BrightnessLevel".
     *
     * Sets the display brightness level
     *
     * @param BrightnessLevel The value which will be set
     */
    inline void setBrightnessLevel (::dimming_main_fi_types::T_e8_DIM_BrightnessLevel BrightnessLevel_);

    static const DIM_DISP_SetBrightnessLevelStart &getDefaultInstance();

private:

    inline void set_has_BrightnessLevel ();

    inline void clear_has_BrightnessLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_e8_DIM_BrightnessLevel _BrightnessLevel;

};

/**
 * The result message of the method "DIM_DISP_SetBrightnessLevel"
 * <p>Sets the brightness level of the display to one of the defined levels</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_SetBrightnessLevelResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetBrightnessLevelResult ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetBrightnessLevelResult (const DIM_DISP_SetBrightnessLevelResult &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetBrightnessLevelResult (::dimming_main_fi_types::T_e8_DIM_BrightnessLevel BrightnessLevel_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetBrightnessLevelResult();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetBrightnessLevelResult& operator = (const DIM_DISP_SetBrightnessLevelResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetBrightnessLevelResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetBrightnessLevelResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetBrightnessLevelResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetBrightnessLevelResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BrightnessLevel"

    static const int kBrightnessLevel = 0;

    /**
     * Clears the field "BrightnessLevel".
     *
     * The field will be set to its default value. The hasBrightnessLevel()
     * method will return false.
     */
    inline void clearBrightnessLevel();

    /**
     * Checks whether the field "BrightnessLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrightnessLevel()). Otherwise it will return false.
     */
    inline bool hasBrightnessLevel () const;

    /**
     * Returns the value of the member "BrightnessLevel".
     *
     * Current value of the display brightness level
     *
     * @return The value of the field "BrightnessLevel"
     */
    inline ::dimming_main_fi_types::T_e8_DIM_BrightnessLevel getBrightnessLevel () const;

    /**
     * Sets the value of the member "BrightnessLevel".
     *
     * Current value of the display brightness level
     *
     * @param BrightnessLevel The value which will be set
     */
    inline void setBrightnessLevel (::dimming_main_fi_types::T_e8_DIM_BrightnessLevel BrightnessLevel_);

    static const DIM_DISP_SetBrightnessLevelResult &getDefaultInstance();

private:

    inline void set_has_BrightnessLevel ();

    inline void clear_has_BrightnessLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dimming_main_fi_types::T_e8_DIM_BrightnessLevel _BrightnessLevel;

};

/**
 * The error message of 'DIM_DISP_SetBrightnessLevel'
 */
class DIM_DISP_SetBrightnessLevelErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetBrightnessLevelErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetBrightnessLevelErrorStructure (const DIM_DISP_SetBrightnessLevelErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetBrightnessLevelErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_SetBrightnessLevelErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetBrightnessLevelErrorStructure& operator = (const DIM_DISP_SetBrightnessLevelErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetBrightnessLevelErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetBrightnessLevelErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetBrightnessLevelErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetBrightnessLevelErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_SetBrightnessLevelErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_SetBrightnessLevel'
 */
class DIM_DISP_SetBrightnessLevelError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_SetBrightnessLevelErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_SetBrightnessLevelError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_SetBrightnessLevelError (const DIM_DISP_SetBrightnessLevelError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetBrightnessLevelError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_SetBrightnessLevelError& operator = (const DIM_DISP_SetBrightnessLevelError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetBrightnessLevelError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetBrightnessLevelError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetBrightnessLevelError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetBrightnessLevelError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_SetBrightnessLevelError::DIM_DISP_SetBrightnessLevelErrorField getField () const;

    inline void setField(DIM_DISP_SetBrightnessLevelError::DIM_DISP_SetBrightnessLevelErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_SetBrightnessLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_SetBrightnessLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_SetBrightnessLevelErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_SetBrightnessLevelErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_SetBrightnessLevelErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_SetBrightnessLevelErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_SetBrightnessLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_SetBrightnessLevelErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_SetBrightnessLevelError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_SetBrightnessLevelError& rhs);

    inline void deleteData ();

    DIM_DISP_SetBrightnessLevelErrorField __field;

    union {
        DIM_DISP_SetBrightnessLevelErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DIM_DISP_SetBrightnessLevelExtended"
 * <p>Sets the brightness level of the display to a specific level</p>
 * <p>While the "normal" brightness level is limited to 5 levels this extended level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! Nissan LCN2Kai supports for example currently only the levels 0..18!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_SetBrightnessLevelExtendedStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetBrightnessLevelExtendedStart ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetBrightnessLevelExtendedStart (const DIM_DISP_SetBrightnessLevelExtendedStart &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetBrightnessLevelExtendedStart (uint8 BrightnessLevelExtended_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetBrightnessLevelExtendedStart();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetBrightnessLevelExtendedStart& operator = (const DIM_DISP_SetBrightnessLevelExtendedStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetBrightnessLevelExtendedStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetBrightnessLevelExtendedStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetBrightnessLevelExtendedStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetBrightnessLevelExtendedStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BrightnessLevelExtended"

    static const int kBrightnessLevelExtended = 0;

    /**
     * Clears the field "BrightnessLevelExtended".
     *
     * The field will be set to its default value. The hasBrightnessLevelExtended()
     * method will return false.
     */
    inline void clearBrightnessLevelExtended();

    /**
     * Checks whether the field "BrightnessLevelExtended" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrightnessLevelExtended()). Otherwise it will return false.
     */
    inline bool hasBrightnessLevelExtended () const;

    /**
     * Returns the value of the member "BrightnessLevelExtended".
     *
     * Sets the extended display brightness level.
     * Nissan LCN2Kai supports for example currently only the levels 0..18!
     *
     * @return The value of the field "BrightnessLevelExtended"
     */
    inline uint8 getBrightnessLevelExtended () const;

    /**
     * Sets the value of the member "BrightnessLevelExtended".
     *
     * Sets the extended display brightness level.
     * Nissan LCN2Kai supports for example currently only the levels 0..18!
     *
     * @param BrightnessLevelExtended The value which will be set
     */
    inline void setBrightnessLevelExtended (uint8 BrightnessLevelExtended_);

    static const DIM_DISP_SetBrightnessLevelExtendedStart &getDefaultInstance();

private:

    inline void set_has_BrightnessLevelExtended ();

    inline void clear_has_BrightnessLevelExtended ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _BrightnessLevelExtended;

};

/**
 * The result message of the method "DIM_DISP_SetBrightnessLevelExtended"
 * <p>Sets the brightness level of the display to a specific level</p>
 * <p>While the "normal" brightness level is limited to 5 levels this extended level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! Nissan LCN2Kai supports for example currently only the levels 0..18!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_SetBrightnessLevelExtendedResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetBrightnessLevelExtendedResult ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetBrightnessLevelExtendedResult (const DIM_DISP_SetBrightnessLevelExtendedResult &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetBrightnessLevelExtendedResult (uint8 BrightnessLevelExtended_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetBrightnessLevelExtendedResult();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetBrightnessLevelExtendedResult& operator = (const DIM_DISP_SetBrightnessLevelExtendedResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetBrightnessLevelExtendedResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetBrightnessLevelExtendedResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetBrightnessLevelExtendedResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetBrightnessLevelExtendedResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BrightnessLevelExtended"

    static const int kBrightnessLevelExtended = 0;

    /**
     * Clears the field "BrightnessLevelExtended".
     *
     * The field will be set to its default value. The hasBrightnessLevelExtended()
     * method will return false.
     */
    inline void clearBrightnessLevelExtended();

    /**
     * Checks whether the field "BrightnessLevelExtended" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrightnessLevelExtended()). Otherwise it will return false.
     */
    inline bool hasBrightnessLevelExtended () const;

    /**
     * Returns the value of the member "BrightnessLevelExtended".
     *
     * Current value of the extended display brightness level.
     * Nissan LCN2Kai supports for example currently only the levels 0..18!
     *
     * @return The value of the field "BrightnessLevelExtended"
     */
    inline uint8 getBrightnessLevelExtended () const;

    /**
     * Sets the value of the member "BrightnessLevelExtended".
     *
     * Current value of the extended display brightness level.
     * Nissan LCN2Kai supports for example currently only the levels 0..18!
     *
     * @param BrightnessLevelExtended The value which will be set
     */
    inline void setBrightnessLevelExtended (uint8 BrightnessLevelExtended_);

    static const DIM_DISP_SetBrightnessLevelExtendedResult &getDefaultInstance();

private:

    inline void set_has_BrightnessLevelExtended ();

    inline void clear_has_BrightnessLevelExtended ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _BrightnessLevelExtended;

};

/**
 * The error message of 'DIM_DISP_SetBrightnessLevelExtended'
 */
class DIM_DISP_SetBrightnessLevelExtendedErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetBrightnessLevelExtendedErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetBrightnessLevelExtendedErrorStructure (const DIM_DISP_SetBrightnessLevelExtendedErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetBrightnessLevelExtendedErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_SetBrightnessLevelExtendedErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetBrightnessLevelExtendedErrorStructure& operator = (const DIM_DISP_SetBrightnessLevelExtendedErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetBrightnessLevelExtendedErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetBrightnessLevelExtendedErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetBrightnessLevelExtendedErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetBrightnessLevelExtendedErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_SetBrightnessLevelExtendedErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_SetBrightnessLevelExtended'
 */
class DIM_DISP_SetBrightnessLevelExtendedError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_SetBrightnessLevelExtendedErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_SetBrightnessLevelExtendedError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_SetBrightnessLevelExtendedError (const DIM_DISP_SetBrightnessLevelExtendedError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetBrightnessLevelExtendedError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_SetBrightnessLevelExtendedError& operator = (const DIM_DISP_SetBrightnessLevelExtendedError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetBrightnessLevelExtendedError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetBrightnessLevelExtendedError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetBrightnessLevelExtendedError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetBrightnessLevelExtendedError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_SetBrightnessLevelExtendedError::DIM_DISP_SetBrightnessLevelExtendedErrorField getField () const;

    inline void setField(DIM_DISP_SetBrightnessLevelExtendedError::DIM_DISP_SetBrightnessLevelExtendedErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_SetBrightnessLevelExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_SetBrightnessLevelExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_SetBrightnessLevelExtendedErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_SetBrightnessLevelExtendedErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_SetBrightnessLevelExtendedErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_SetBrightnessLevelExtendedErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_SetBrightnessLevelExtendedErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_SetBrightnessLevelExtendedErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_SetBrightnessLevelExtendedError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_SetBrightnessLevelExtendedError& rhs);

    inline void deleteData ();

    DIM_DISP_SetBrightnessLevelExtendedErrorField __field;

    union {
        DIM_DISP_SetBrightnessLevelExtendedErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DIM_DISP_SetVideoBrightnessLevel"
 * <p>This is a special functionality first introduced for Nissan LCN2Kai</p>
 * <p>While calling this method the dimming component will activate or deactivate a special video mode</p>
 * <p>By activating this video mode the display brightness level can be set to a different value independent from HMI and without storing the value in persistent memory</p>
 * <p>Main purpose is to have the option to change the brightness of the display backlight if a video layer is displayed</p>
 * <p>---</p>
 * <p>Remember: This changes the backlight of the display and NOT the brightness of the video layer itself. So it influences the complete screen content and not only the video layer!</p>
 * <p>---</p>
 * <p>The behaviour is very similar to DIM_DISP_SetBrightnessLevelExtended with the following modifications:</p>
 * <p>(1) the range of the brightness level is 0..18, this sets the brightness level and changes into video mode and the current DIM_Disp_BrightnessLevelExtended values are "freezed"</p>
 * <p>(2) brightness level for day and night can be set at the same time, the dimming component will use the each of the values if DimmingMode changes</p>
 * <p>(3) if the method is called with value 255 (at least for one of the parameters) then the video mode is left and the "freezed" DIM_Disp_BrightnessLevelExtended are restored</p>
 * <p>(4) because of the freezed values the HMI will not notice any changes made through this method in the property DIM_DispBrightnesseLevelExtended</p>
 * <p>(5) the video brightness level values are not stored in persistent memory</p>
 * <p>(6) the video mode is always left on startup or shutdown of the dimming component</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_SetVideoBrightnessLevelStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetVideoBrightnessLevelStart ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetVideoBrightnessLevelStart (const DIM_DISP_SetVideoBrightnessLevelStart &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetVideoBrightnessLevelStart (uint8 VideoBrightnessLevelDay_, uint8 VideoBrightnessLevelNight_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetVideoBrightnessLevelStart();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetVideoBrightnessLevelStart& operator = (const DIM_DISP_SetVideoBrightnessLevelStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetVideoBrightnessLevelStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetVideoBrightnessLevelStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetVideoBrightnessLevelStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetVideoBrightnessLevelStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VideoBrightnessLevelDay"

    static const int kVideoBrightnessLevelDay = 0;

    /**
     * Clears the field "VideoBrightnessLevelDay".
     *
     * The field will be set to its default value. The hasVideoBrightnessLevelDay()
     * method will return false.
     */
    inline void clearVideoBrightnessLevelDay();

    /**
     * Checks whether the field "VideoBrightnessLevelDay" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVideoBrightnessLevelDay()). Otherwise it will return false.
     */
    inline bool hasVideoBrightnessLevelDay () const;

    /**
     * Returns the value of the member "VideoBrightnessLevelDay".
     *
     * <p>Sets the display brightness level in video mode for DimmingMode "day"</p>
     * <p>Attention: The range is limited to the values 0..18 and 255!</p>
     * <p>With 0 being the darkest, 9 the medium and 18 being the brightest level.</p>
     * <p>In addition 0..18 means the video mode is being activated, 255 means video mode is deactivated</p>
     *
     * @return The value of the field "VideoBrightnessLevelDay"
     */
    inline uint8 getVideoBrightnessLevelDay () const;

    /**
     * Sets the value of the member "VideoBrightnessLevelDay".
     *
     * <p>Sets the display brightness level in video mode for DimmingMode "day"</p>
     * <p>Attention: The range is limited to the values 0..18 and 255!</p>
     * <p>With 0 being the darkest, 9 the medium and 18 being the brightest level.</p>
     * <p>In addition 0..18 means the video mode is being activated, 255 means video mode is deactivated</p>
     *
     * @param VideoBrightnessLevelDay The value which will be set
     */
    inline void setVideoBrightnessLevelDay (uint8 VideoBrightnessLevelDay_);

    // API of field "VideoBrightnessLevelNight"

    static const int kVideoBrightnessLevelNight = 1;

    /**
     * Clears the field "VideoBrightnessLevelNight".
     *
     * The field will be set to its default value. The hasVideoBrightnessLevelNight()
     * method will return false.
     */
    inline void clearVideoBrightnessLevelNight();

    /**
     * Checks whether the field "VideoBrightnessLevelNight" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVideoBrightnessLevelNight()). Otherwise it will return false.
     */
    inline bool hasVideoBrightnessLevelNight () const;

    /**
     * Returns the value of the member "VideoBrightnessLevelNight".
     *
     * <p>Sets the display brightness level in video mode for DimmingMode "night"</p>
     * <p>Attention: The range is limited to the values 0..18 and 255!</p>
     * <p>With 0 being the darkest, 9 the medium and 18 being the brightest level.</p>
     * <p>In addition 0..18 means the video mode is being activated, 255 means video mode is deactivated</p>
     *
     * @return The value of the field "VideoBrightnessLevelNight"
     */
    inline uint8 getVideoBrightnessLevelNight () const;

    /**
     * Sets the value of the member "VideoBrightnessLevelNight".
     *
     * <p>Sets the display brightness level in video mode for DimmingMode "night"</p>
     * <p>Attention: The range is limited to the values 0..18 and 255!</p>
     * <p>With 0 being the darkest, 9 the medium and 18 being the brightest level.</p>
     * <p>In addition 0..18 means the video mode is being activated, 255 means video mode is deactivated</p>
     *
     * @param VideoBrightnessLevelNight The value which will be set
     */
    inline void setVideoBrightnessLevelNight (uint8 VideoBrightnessLevelNight_);

    static const DIM_DISP_SetVideoBrightnessLevelStart &getDefaultInstance();

private:

    inline void set_has_VideoBrightnessLevelDay ();

    inline void clear_has_VideoBrightnessLevelDay ();

    inline void set_has_VideoBrightnessLevelNight ();

    inline void clear_has_VideoBrightnessLevelNight ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _VideoBrightnessLevelDay;

    uint8 _VideoBrightnessLevelNight;

};

/**
 * The result message of the method "DIM_DISP_SetVideoBrightnessLevel"
 * <p>This is a special functionality first introduced for Nissan LCN2Kai</p>
 * <p>While calling this method the dimming component will activate or deactivate a special video mode</p>
 * <p>By activating this video mode the display brightness level can be set to a different value independent from HMI and without storing the value in persistent memory</p>
 * <p>Main purpose is to have the option to change the brightness of the display backlight if a video layer is displayed</p>
 * <p>---</p>
 * <p>Remember: This changes the backlight of the display and NOT the brightness of the video layer itself. So it influences the complete screen content and not only the video layer!</p>
 * <p>---</p>
 * <p>The behaviour is very similar to DIM_DISP_SetBrightnessLevelExtended with the following modifications:</p>
 * <p>(1) the range of the brightness level is 0..18, this sets the brightness level and changes into video mode and the current DIM_Disp_BrightnessLevelExtended values are "freezed"</p>
 * <p>(2) brightness level for day and night can be set at the same time, the dimming component will use the each of the values if DimmingMode changes</p>
 * <p>(3) if the method is called with value 255 (at least for one of the parameters) then the video mode is left and the "freezed" DIM_Disp_BrightnessLevelExtended are restored</p>
 * <p>(4) because of the freezed values the HMI will not notice any changes made through this method in the property DIM_DispBrightnesseLevelExtended</p>
 * <p>(5) the video brightness level values are not stored in persistent memory</p>
 * <p>(6) the video mode is always left on startup or shutdown of the dimming component</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_SetVideoBrightnessLevelResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetVideoBrightnessLevelResult ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetVideoBrightnessLevelResult (const DIM_DISP_SetVideoBrightnessLevelResult &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetVideoBrightnessLevelResult (uint8 VideoBrightnessLevelDay_, uint8 VideoBrightnessLevelNight_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetVideoBrightnessLevelResult();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetVideoBrightnessLevelResult& operator = (const DIM_DISP_SetVideoBrightnessLevelResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetVideoBrightnessLevelResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetVideoBrightnessLevelResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetVideoBrightnessLevelResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetVideoBrightnessLevelResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VideoBrightnessLevelDay"

    static const int kVideoBrightnessLevelDay = 0;

    /**
     * Clears the field "VideoBrightnessLevelDay".
     *
     * The field will be set to its default value. The hasVideoBrightnessLevelDay()
     * method will return false.
     */
    inline void clearVideoBrightnessLevelDay();

    /**
     * Checks whether the field "VideoBrightnessLevelDay" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVideoBrightnessLevelDay()). Otherwise it will return false.
     */
    inline bool hasVideoBrightnessLevelDay () const;

    /**
     * Returns the value of the member "VideoBrightnessLevelDay".
     *
     * Returns the display brightness level for video in DimmingMode "day". Same values like described above.
     *
     * @return The value of the field "VideoBrightnessLevelDay"
     */
    inline uint8 getVideoBrightnessLevelDay () const;

    /**
     * Sets the value of the member "VideoBrightnessLevelDay".
     *
     * Returns the display brightness level for video in DimmingMode "day". Same values like described above.
     *
     * @param VideoBrightnessLevelDay The value which will be set
     */
    inline void setVideoBrightnessLevelDay (uint8 VideoBrightnessLevelDay_);

    // API of field "VideoBrightnessLevelNight"

    static const int kVideoBrightnessLevelNight = 1;

    /**
     * Clears the field "VideoBrightnessLevelNight".
     *
     * The field will be set to its default value. The hasVideoBrightnessLevelNight()
     * method will return false.
     */
    inline void clearVideoBrightnessLevelNight();

    /**
     * Checks whether the field "VideoBrightnessLevelNight" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVideoBrightnessLevelNight()). Otherwise it will return false.
     */
    inline bool hasVideoBrightnessLevelNight () const;

    /**
     * Returns the value of the member "VideoBrightnessLevelNight".
     *
     * Returns the display brightness level for video in DimmingMode "night". Same values like described above.
     *
     * @return The value of the field "VideoBrightnessLevelNight"
     */
    inline uint8 getVideoBrightnessLevelNight () const;

    /**
     * Sets the value of the member "VideoBrightnessLevelNight".
     *
     * Returns the display brightness level for video in DimmingMode "night". Same values like described above.
     *
     * @param VideoBrightnessLevelNight The value which will be set
     */
    inline void setVideoBrightnessLevelNight (uint8 VideoBrightnessLevelNight_);

    static const DIM_DISP_SetVideoBrightnessLevelResult &getDefaultInstance();

private:

    inline void set_has_VideoBrightnessLevelDay ();

    inline void clear_has_VideoBrightnessLevelDay ();

    inline void set_has_VideoBrightnessLevelNight ();

    inline void clear_has_VideoBrightnessLevelNight ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _VideoBrightnessLevelDay;

    uint8 _VideoBrightnessLevelNight;

};

/**
 * The error message of 'DIM_DISP_SetVideoBrightnessLevel'
 */
class DIM_DISP_SetVideoBrightnessLevelErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetVideoBrightnessLevelErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetVideoBrightnessLevelErrorStructure (const DIM_DISP_SetVideoBrightnessLevelErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetVideoBrightnessLevelErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_SetVideoBrightnessLevelErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetVideoBrightnessLevelErrorStructure& operator = (const DIM_DISP_SetVideoBrightnessLevelErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetVideoBrightnessLevelErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetVideoBrightnessLevelErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetVideoBrightnessLevelErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetVideoBrightnessLevelErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_SetVideoBrightnessLevelErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_SetVideoBrightnessLevel'
 */
class DIM_DISP_SetVideoBrightnessLevelError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_SetVideoBrightnessLevelErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_SetVideoBrightnessLevelError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_SetVideoBrightnessLevelError (const DIM_DISP_SetVideoBrightnessLevelError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetVideoBrightnessLevelError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_SetVideoBrightnessLevelError& operator = (const DIM_DISP_SetVideoBrightnessLevelError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetVideoBrightnessLevelError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetVideoBrightnessLevelError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetVideoBrightnessLevelError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetVideoBrightnessLevelError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_SetVideoBrightnessLevelError::DIM_DISP_SetVideoBrightnessLevelErrorField getField () const;

    inline void setField(DIM_DISP_SetVideoBrightnessLevelError::DIM_DISP_SetVideoBrightnessLevelErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_SetVideoBrightnessLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_SetVideoBrightnessLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_SetVideoBrightnessLevelErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_SetVideoBrightnessLevelErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_SetVideoBrightnessLevelErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_SetVideoBrightnessLevelErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_SetVideoBrightnessLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_SetVideoBrightnessLevelErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_SetVideoBrightnessLevelError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_SetVideoBrightnessLevelError& rhs);

    inline void deleteData ();

    DIM_DISP_SetVideoBrightnessLevelErrorField __field;

    union {
        DIM_DISP_SetVideoBrightnessLevelErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DIM_DISP_SetContrastLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use method DIM_DISP_SetCSCContrastLevel!</p>
 * <p>---</p>
 * <p>Sets the contrast level of the display to a specific level</p>
 * <p>Contrast level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_SetContrastLevelStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetContrastLevelStart ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetContrastLevelStart (const DIM_DISP_SetContrastLevelStart &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetContrastLevelStart (uint8 Contrast_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetContrastLevelStart();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetContrastLevelStart& operator = (const DIM_DISP_SetContrastLevelStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetContrastLevelStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetContrastLevelStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetContrastLevelStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetContrastLevelStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Contrast"

    static const int kContrast = 0;

    /**
     * Clears the field "Contrast".
     *
     * The field will be set to its default value. The hasContrast()
     * method will return false.
     */
    inline void clearContrast();

    /**
     * Checks whether the field "Contrast" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setContrast()). Otherwise it will return false.
     */
    inline bool hasContrast () const;

    /**
     * Returns the value of the member "Contrast".
     *
     * Sets the contrast level.
     * AIVI supports for example currently only the levels 0..32!
     *
     * @return The value of the field "Contrast"
     */
    inline uint8 getContrast () const;

    /**
     * Sets the value of the member "Contrast".
     *
     * Sets the contrast level.
     * AIVI supports for example currently only the levels 0..32!
     *
     * @param Contrast The value which will be set
     */
    inline void setContrast (uint8 Contrast_);

    static const DIM_DISP_SetContrastLevelStart &getDefaultInstance();

private:

    inline void set_has_Contrast ();

    inline void clear_has_Contrast ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Contrast;

};

/**
 * The result message of the method "DIM_DISP_SetContrastLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use method DIM_DISP_SetCSCContrastLevel!</p>
 * <p>---</p>
 * <p>Sets the contrast level of the display to a specific level</p>
 * <p>Contrast level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_SetContrastLevelResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetContrastLevelResult ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetContrastLevelResult (const DIM_DISP_SetContrastLevelResult &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetContrastLevelResult (uint8 BrightnessLevelExtended_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetContrastLevelResult();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetContrastLevelResult& operator = (const DIM_DISP_SetContrastLevelResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetContrastLevelResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetContrastLevelResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetContrastLevelResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetContrastLevelResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BrightnessLevelExtended"

    static const int kBrightnessLevelExtended = 0;

    /**
     * Clears the field "BrightnessLevelExtended".
     *
     * The field will be set to its default value. The hasBrightnessLevelExtended()
     * method will return false.
     */
    inline void clearBrightnessLevelExtended();

    /**
     * Checks whether the field "BrightnessLevelExtended" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBrightnessLevelExtended()). Otherwise it will return false.
     */
    inline bool hasBrightnessLevelExtended () const;

    /**
     * Returns the value of the member "BrightnessLevelExtended".
     *
     * Current value of the contrast level.
     * AIVI supports for example currently only the levels 0..32!
     *
     * @return The value of the field "BrightnessLevelExtended"
     */
    inline uint8 getBrightnessLevelExtended () const;

    /**
     * Sets the value of the member "BrightnessLevelExtended".
     *
     * Current value of the contrast level.
     * AIVI supports for example currently only the levels 0..32!
     *
     * @param BrightnessLevelExtended The value which will be set
     */
    inline void setBrightnessLevelExtended (uint8 BrightnessLevelExtended_);

    static const DIM_DISP_SetContrastLevelResult &getDefaultInstance();

private:

    inline void set_has_BrightnessLevelExtended ();

    inline void clear_has_BrightnessLevelExtended ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _BrightnessLevelExtended;

};

/**
 * The error message of 'DIM_DISP_SetContrastLevel'
 */
class DIM_DISP_SetContrastLevelErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetContrastLevelErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetContrastLevelErrorStructure (const DIM_DISP_SetContrastLevelErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetContrastLevelErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_SetContrastLevelErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetContrastLevelErrorStructure& operator = (const DIM_DISP_SetContrastLevelErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetContrastLevelErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetContrastLevelErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetContrastLevelErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetContrastLevelErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_SetContrastLevelErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_SetContrastLevel'
 */
class DIM_DISP_SetContrastLevelError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_SetContrastLevelErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_SetContrastLevelError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_SetContrastLevelError (const DIM_DISP_SetContrastLevelError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetContrastLevelError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_SetContrastLevelError& operator = (const DIM_DISP_SetContrastLevelError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetContrastLevelError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetContrastLevelError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetContrastLevelError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetContrastLevelError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_SetContrastLevelError::DIM_DISP_SetContrastLevelErrorField getField () const;

    inline void setField(DIM_DISP_SetContrastLevelError::DIM_DISP_SetContrastLevelErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_SetContrastLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_SetContrastLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_SetContrastLevelErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_SetContrastLevelErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_SetContrastLevelErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_SetContrastLevelErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_SetContrastLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_SetContrastLevelErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_SetContrastLevelError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_SetContrastLevelError& rhs);

    inline void deleteData ();

    DIM_DISP_SetContrastLevelErrorField __field;

    union {
        DIM_DISP_SetContrastLevelErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DIM_DISP_SetBlackLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use method DIM_DISP_SetCSCBlackLevel!</p>
 * <p>---</p>
 * <p>Sets the black level of the display to a specific level</p>
 * <p>Black level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_SetBlackLevelStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetBlackLevelStart ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetBlackLevelStart (const DIM_DISP_SetBlackLevelStart &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetBlackLevelStart (uint8 BlackLevel_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetBlackLevelStart();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetBlackLevelStart& operator = (const DIM_DISP_SetBlackLevelStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetBlackLevelStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetBlackLevelStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetBlackLevelStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetBlackLevelStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BlackLevel"

    static const int kBlackLevel = 0;

    /**
     * Clears the field "BlackLevel".
     *
     * The field will be set to its default value. The hasBlackLevel()
     * method will return false.
     */
    inline void clearBlackLevel();

    /**
     * Checks whether the field "BlackLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBlackLevel()). Otherwise it will return false.
     */
    inline bool hasBlackLevel () const;

    /**
     * Returns the value of the member "BlackLevel".
     *
     * Sets the black level.
     * AIVI supports for example currently only the levels 0..32!
     *
     * @return The value of the field "BlackLevel"
     */
    inline uint8 getBlackLevel () const;

    /**
     * Sets the value of the member "BlackLevel".
     *
     * Sets the black level.
     * AIVI supports for example currently only the levels 0..32!
     *
     * @param BlackLevel The value which will be set
     */
    inline void setBlackLevel (uint8 BlackLevel_);

    static const DIM_DISP_SetBlackLevelStart &getDefaultInstance();

private:

    inline void set_has_BlackLevel ();

    inline void clear_has_BlackLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _BlackLevel;

};

/**
 * The result message of the method "DIM_DISP_SetBlackLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use method DIM_DISP_SetCSCBlackLevel!</p>
 * <p>---</p>
 * <p>Sets the black level of the display to a specific level</p>
 * <p>Black level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_SetBlackLevelResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetBlackLevelResult ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetBlackLevelResult (const DIM_DISP_SetBlackLevelResult &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetBlackLevelResult (uint8 BlackLevel_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetBlackLevelResult();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetBlackLevelResult& operator = (const DIM_DISP_SetBlackLevelResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetBlackLevelResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetBlackLevelResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetBlackLevelResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetBlackLevelResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BlackLevel"

    static const int kBlackLevel = 0;

    /**
     * Clears the field "BlackLevel".
     *
     * The field will be set to its default value. The hasBlackLevel()
     * method will return false.
     */
    inline void clearBlackLevel();

    /**
     * Checks whether the field "BlackLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBlackLevel()). Otherwise it will return false.
     */
    inline bool hasBlackLevel () const;

    /**
     * Returns the value of the member "BlackLevel".
     *
     * Current value of the black level.
     * AIVI supports for example currently only the levels 0..32!
     *
     * @return The value of the field "BlackLevel"
     */
    inline uint8 getBlackLevel () const;

    /**
     * Sets the value of the member "BlackLevel".
     *
     * Current value of the black level.
     * AIVI supports for example currently only the levels 0..32!
     *
     * @param BlackLevel The value which will be set
     */
    inline void setBlackLevel (uint8 BlackLevel_);

    static const DIM_DISP_SetBlackLevelResult &getDefaultInstance();

private:

    inline void set_has_BlackLevel ();

    inline void clear_has_BlackLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _BlackLevel;

};

/**
 * The error message of 'DIM_DISP_SetBlackLevel'
 */
class DIM_DISP_SetBlackLevelErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetBlackLevelErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetBlackLevelErrorStructure (const DIM_DISP_SetBlackLevelErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetBlackLevelErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_SetBlackLevelErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetBlackLevelErrorStructure& operator = (const DIM_DISP_SetBlackLevelErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetBlackLevelErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetBlackLevelErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetBlackLevelErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetBlackLevelErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_SetBlackLevelErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_SetBlackLevel'
 */
class DIM_DISP_SetBlackLevelError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_SetBlackLevelErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_SetBlackLevelError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_SetBlackLevelError (const DIM_DISP_SetBlackLevelError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetBlackLevelError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_SetBlackLevelError& operator = (const DIM_DISP_SetBlackLevelError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetBlackLevelError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetBlackLevelError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetBlackLevelError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetBlackLevelError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_SetBlackLevelError::DIM_DISP_SetBlackLevelErrorField getField () const;

    inline void setField(DIM_DISP_SetBlackLevelError::DIM_DISP_SetBlackLevelErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_SetBlackLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_SetBlackLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_SetBlackLevelErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_SetBlackLevelErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_SetBlackLevelErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_SetBlackLevelErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_SetBlackLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_SetBlackLevelErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_SetBlackLevelError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_SetBlackLevelError& rhs);

    inline void deleteData ();

    DIM_DISP_SetBlackLevelErrorField __field;

    union {
        DIM_DISP_SetBlackLevelErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DIM_DISP_SetYCurveLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use method DIM_DISP_SetCSCGammaLevel!</p>
 * <p>---</p>
 * <p>Sets the YCurve level of the display to a specific level</p>
 * <p>YCurve level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_SetYCurveLevelStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetYCurveLevelStart ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetYCurveLevelStart (const DIM_DISP_SetYCurveLevelStart &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetYCurveLevelStart (uint8 YCurveLevel_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetYCurveLevelStart();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetYCurveLevelStart& operator = (const DIM_DISP_SetYCurveLevelStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetYCurveLevelStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetYCurveLevelStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetYCurveLevelStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetYCurveLevelStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "YCurveLevel"

    static const int kYCurveLevel = 0;

    /**
     * Clears the field "YCurveLevel".
     *
     * The field will be set to its default value. The hasYCurveLevel()
     * method will return false.
     */
    inline void clearYCurveLevel();

    /**
     * Checks whether the field "YCurveLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setYCurveLevel()). Otherwise it will return false.
     */
    inline bool hasYCurveLevel () const;

    /**
     * Returns the value of the member "YCurveLevel".
     *
     * Sets the YCurve level.
     * AIVI supports for example currently only the levels 0..32!
     *
     * @return The value of the field "YCurveLevel"
     */
    inline uint8 getYCurveLevel () const;

    /**
     * Sets the value of the member "YCurveLevel".
     *
     * Sets the YCurve level.
     * AIVI supports for example currently only the levels 0..32!
     *
     * @param YCurveLevel The value which will be set
     */
    inline void setYCurveLevel (uint8 YCurveLevel_);

    static const DIM_DISP_SetYCurveLevelStart &getDefaultInstance();

private:

    inline void set_has_YCurveLevel ();

    inline void clear_has_YCurveLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _YCurveLevel;

};

/**
 * The result message of the method "DIM_DISP_SetYCurveLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use method DIM_DISP_SetCSCGammaLevel!</p>
 * <p>---</p>
 * <p>Sets the YCurve level of the display to a specific level</p>
 * <p>YCurve level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_SetYCurveLevelResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetYCurveLevelResult ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetYCurveLevelResult (const DIM_DISP_SetYCurveLevelResult &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetYCurveLevelResult (uint8 YCurveLevel_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetYCurveLevelResult();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetYCurveLevelResult& operator = (const DIM_DISP_SetYCurveLevelResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetYCurveLevelResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetYCurveLevelResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetYCurveLevelResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetYCurveLevelResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "YCurveLevel"

    static const int kYCurveLevel = 0;

    /**
     * Clears the field "YCurveLevel".
     *
     * The field will be set to its default value. The hasYCurveLevel()
     * method will return false.
     */
    inline void clearYCurveLevel();

    /**
     * Checks whether the field "YCurveLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setYCurveLevel()). Otherwise it will return false.
     */
    inline bool hasYCurveLevel () const;

    /**
     * Returns the value of the member "YCurveLevel".
     *
     * Current value of the YCurve level.
     * AIVI supports for example currently only the levels 0..32!
     *
     * @return The value of the field "YCurveLevel"
     */
    inline uint8 getYCurveLevel () const;

    /**
     * Sets the value of the member "YCurveLevel".
     *
     * Current value of the YCurve level.
     * AIVI supports for example currently only the levels 0..32!
     *
     * @param YCurveLevel The value which will be set
     */
    inline void setYCurveLevel (uint8 YCurveLevel_);

    static const DIM_DISP_SetYCurveLevelResult &getDefaultInstance();

private:

    inline void set_has_YCurveLevel ();

    inline void clear_has_YCurveLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _YCurveLevel;

};

/**
 * The error message of 'DIM_DISP_SetYCurveLevel'
 */
class DIM_DISP_SetYCurveLevelErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetYCurveLevelErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetYCurveLevelErrorStructure (const DIM_DISP_SetYCurveLevelErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetYCurveLevelErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_SetYCurveLevelErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetYCurveLevelErrorStructure& operator = (const DIM_DISP_SetYCurveLevelErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetYCurveLevelErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetYCurveLevelErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetYCurveLevelErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetYCurveLevelErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_SetYCurveLevelErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_SetYCurveLevel'
 */
class DIM_DISP_SetYCurveLevelError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_SetYCurveLevelErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_SetYCurveLevelError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_SetYCurveLevelError (const DIM_DISP_SetYCurveLevelError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetYCurveLevelError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_SetYCurveLevelError& operator = (const DIM_DISP_SetYCurveLevelError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetYCurveLevelError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetYCurveLevelError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetYCurveLevelError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetYCurveLevelError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_SetYCurveLevelError::DIM_DISP_SetYCurveLevelErrorField getField () const;

    inline void setField(DIM_DISP_SetYCurveLevelError::DIM_DISP_SetYCurveLevelErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_SetYCurveLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "DIM_DISP_SetYCurveLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const DIM_DISP_SetYCurveLevelErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline DIM_DISP_SetYCurveLevelErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline DIM_DISP_SetYCurveLevelErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (DIM_DISP_SetYCurveLevelErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "DIM_DISP_SetYCurveLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const DIM_DISP_SetYCurveLevelErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const DIM_DISP_SetYCurveLevelError &getDefaultInstance();

private:

    inline void cloneData (const DIM_DISP_SetYCurveLevelError& rhs);

    inline void deleteData ();

    DIM_DISP_SetYCurveLevelErrorField __field;

    union {
        DIM_DISP_SetYCurveLevelErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "DIM_DISP_SetTintLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use method DIM_DISP_SetCSCSaturationLevel!</p>
 * <p>---</p>
 * <p>Sets the tint level of the display to a specific level</p>
 * <p>Tint level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_SetTintLevelStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetTintLevelStart ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetTintLevelStart (const DIM_DISP_SetTintLevelStart &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetTintLevelStart (uint8 TintLevel_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetTintLevelStart();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetTintLevelStart& operator = (const DIM_DISP_SetTintLevelStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetTintLevelStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetTintLevelStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetTintLevelStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetTintLevelStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TintLevel"

    static const int kTintLevel = 0;

    /**
     * Clears the field "TintLevel".
     *
     * The field will be set to its default value. The hasTintLevel()
     * method will return false.
     */
    inline void clearTintLevel();

    /**
     * Checks whether the field "TintLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTintLevel()). Otherwise it will return false.
     */
    inline bool hasTintLevel () const;

    /**
     * Returns the value of the member "TintLevel".
     *
     * Sets the tint level.
     * AIVI supports for example currently only the levels 0..32!
     *
     * @return The value of the field "TintLevel"
     */
    inline uint8 getTintLevel () const;

    /**
     * Sets the value of the member "TintLevel".
     *
     * Sets the tint level.
     * AIVI supports for example currently only the levels 0..32!
     *
     * @param TintLevel The value which will be set
     */
    inline void setTintLevel (uint8 TintLevel_);

    static const DIM_DISP_SetTintLevelStart &getDefaultInstance();

private:

    inline void set_has_TintLevel ();

    inline void clear_has_TintLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _TintLevel;

};

/**
 * The result message of the method "DIM_DISP_SetTintLevel"
 * <p>Important NOTE:</p>
 * <p>Property obsolete and will not supported in future!</p>
 * <p>Please use method DIM_DISP_SetCSCSaturationLevel!</p>
 * <p>---</p>
 * <p>Sets the tint level of the display to a specific level</p>
 * <p>Tint level can use the full range of 256 levels.</p>
 * <p>Depending on the project the range might be limited! AIVI supports for example currently only the levels 0..32!</p>
 * <p>---</p>
 * <p>Available starting with FI 2.0!</p>
 */
class DIM_DISP_SetTintLevelResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetTintLevelResult ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetTintLevelResult (const DIM_DISP_SetTintLevelResult &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetTintLevelResult (uint8 TintLevel_);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetTintLevelResult();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetTintLevelResult& operator = (const DIM_DISP_SetTintLevelResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetTintLevelResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetTintLevelResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetTintLevelResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetTintLevelResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TintLevel"

    static const int kTintLevel = 0;

    /**
     * Clears the field "TintLevel".
     *
     * The field will be set to its default value. The hasTintLevel()
     * method will return false.
     */
    inline void clearTintLevel();

    /**
     * Checks whether the field "TintLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTintLevel()). Otherwise it will return false.
     */
    inline bool hasTintLevel () const;

    /**
     * Returns the value of the member "TintLevel".
     *
     * Current value of the tint level.
     * AIVI supports for example currently only the levels 0..32!
     *
     * @return The value of the field "TintLevel"
     */
    inline uint8 getTintLevel () const;

    /**
     * Sets the value of the member "TintLevel".
     *
     * Current value of the tint level.
     * AIVI supports for example currently only the levels 0..32!
     *
     * @param TintLevel The value which will be set
     */
    inline void setTintLevel (uint8 TintLevel_);

    static const DIM_DISP_SetTintLevelResult &getDefaultInstance();

private:

    inline void set_has_TintLevel ();

    inline void clear_has_TintLevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _TintLevel;

};

/**
 * The error message of 'DIM_DISP_SetTintLevel'
 */
class DIM_DISP_SetTintLevelErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  DIM_DISP_SetTintLevelErrorStructure ();

    /**
     * Copy constructor
     */
    inline  DIM_DISP_SetTintLevelErrorStructure (const DIM_DISP_SetTintLevelErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  DIM_DISP_SetTintLevelErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~DIM_DISP_SetTintLevelErrorStructure();

    /**
     * Assignment operator
     */
    inline DIM_DISP_SetTintLevelErrorStructure& operator = (const DIM_DISP_SetTintLevelErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetTintLevelErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetTintLevelErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetTintLevelErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetTintLevelErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const DIM_DISP_SetTintLevelErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'DIM_DISP_SetTintLevel'
 */
class DIM_DISP_SetTintLevelError  : public ::asf::core::Payload {
public:

    enum DIM_DISP_SetTintLevelErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  DIM_DISP_SetTintLevelError ();

   /**
     * Copy constructor
     */
    inline  DIM_DISP_SetTintLevelError (const DIM_DISP_SetTintLevelError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~DIM_DISP_SetTintLevelError();

    /**
     * Assigns a new value to this object.
     */
    inline DIM_DISP_SetTintLevelError& operator = (const DIM_DISP_SetTintLevelError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DIM_DISP_SetTintLevelError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DIM_DISP_SetTintLevelError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DIM_DISP_SetTintLevelError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DIM_DISP_SetTintLevelError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DIM_DISP_SetTintLevelError::DIM_DISP_SetTintLevelErrorField getField () const;

    inline void setField(DIM_DISP_SetTintLevelError::DIM_DISP_SetTintLevelErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "DIM_DISP_SetTintLevelErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid t