/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "diaglog_diagnostics_fi_typesConst.h"
#include "diaglog_main_fiCca.h"
#include "diaglog_main_fiJson.h"
#include "diaglog_main_fiProxy.h"
#include "diaglog_main_fi_types.h"
#include "diaglog_main_fi_typesConst.h"
#include <vector>

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace diaglog_main_fi {

/*static*/ ::asf::core::Logger Diaglog_main_fiProxy::_logger ("/diaglog_main_fi/Diaglog_main_fiProxy");


class Diaglog_main_fiProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Diaglog_main_fiProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Diaglog_main_fiProxy> proxy = ::boost::static_pointer_cast<Diaglog_main_fiProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_SaveTestResult: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::SaveTestResultResult);
                                setActAndLogResult(message, "SaveTestResult", reinterpret_cast<act_t>(this), _logger);
                                ((SaveTestResultCallbackIF*) _callback)->onSaveTestResultResult (proxy, ::boost::static_pointer_cast<SaveTestResultResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::SaveTestResultError);
                                setActAndLogError(message, "SaveTestResult", reinterpret_cast<act_t>(this), _logger);
                                ((SaveTestResultCallbackIF*) _callback)->onSaveTestResultError (proxy, ::boost::static_pointer_cast<SaveTestResultError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SaveTestResultDynamicalDTC: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::SaveTestResultDynamicalDTCResult);
                                setActAndLogResult(message, "SaveTestResultDynamicalDTC", reinterpret_cast<act_t>(this), _logger);
                                ((SaveTestResultDynamicalDTCCallbackIF*) _callback)->onSaveTestResultDynamicalDTCResult (proxy, ::boost::static_pointer_cast<SaveTestResultDynamicalDTCResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::SaveTestResultDynamicalDTCError);
                                setActAndLogError(message, "SaveTestResultDynamicalDTC", reinterpret_cast<act_t>(this), _logger);
                                ((SaveTestResultDynamicalDTCCallbackIF*) _callback)->onSaveTestResultDynamicalDTCError (proxy, ::boost::static_pointer_cast<SaveTestResultDynamicalDTCError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ProductionReadRequest: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::ProductionReadRequestResult);
                                setActAndLogResult(message, "ProductionReadRequest", reinterpret_cast<act_t>(this), _logger);
                                ((ProductionReadRequestCallbackIF*) _callback)->onProductionReadRequestResult (proxy, ::boost::static_pointer_cast<ProductionReadRequestResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::ProductionReadRequestError);
                                setActAndLogError(message, "ProductionReadRequest", reinterpret_cast<act_t>(this), _logger);
                                ((ProductionReadRequestCallbackIF*) _callback)->onProductionReadRequestError (proxy, ::boost::static_pointer_cast<ProductionReadRequestError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_CustomerReadRequest: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::CustomerReadRequestResult);
                                setActAndLogResult(message, "CustomerReadRequest", reinterpret_cast<act_t>(this), _logger);
                                ((CustomerReadRequestCallbackIF*) _callback)->onCustomerReadRequestResult (proxy, ::boost::static_pointer_cast<CustomerReadRequestResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::CustomerReadRequestError);
                                setActAndLogError(message, "CustomerReadRequest", reinterpret_cast<act_t>(this), _logger);
                                ((CustomerReadRequestCallbackIF*) _callback)->onCustomerReadRequestError (proxy, ::boost::static_pointer_cast<CustomerReadRequestError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_getItcInformation: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::GetItcInformationResult);
                                setActAndLogResult(message, "GetItcInformation", reinterpret_cast<act_t>(this), _logger);
                                ((GetItcInformationCallbackIF*) _callback)->onGetItcInformationResult (proxy, ::boost::static_pointer_cast<GetItcInformationResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::GetItcInformationError);
                                setActAndLogError(message, "GetItcInformation", reinterpret_cast<act_t>(this), _logger);
                                ((GetItcInformationCallbackIF*) _callback)->onGetItcInformationError (proxy, ::boost::static_pointer_cast<GetItcInformationError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ProductionClearRequest: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::ProductionClearRequestResult);
                                setActAndLogResult(message, "ProductionClearRequest", reinterpret_cast<act_t>(this), _logger);
                                ((ProductionClearRequestCallbackIF*) _callback)->onProductionClearRequestResult (proxy, ::boost::static_pointer_cast<ProductionClearRequestResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::ProductionClearRequestError);
                                setActAndLogError(message, "ProductionClearRequest", reinterpret_cast<act_t>(this), _logger);
                                ((ProductionClearRequestCallbackIF*) _callback)->onProductionClearRequestError (proxy, ::boost::static_pointer_cast<ProductionClearRequestError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_CustomerClearRequest: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::CustomerClearRequestResult);
                                setActAndLogResult(message, "CustomerClearRequest", reinterpret_cast<act_t>(this), _logger);
                                ((CustomerClearRequestCallbackIF*) _callback)->onCustomerClearRequestResult (proxy, ::boost::static_pointer_cast<CustomerClearRequestResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::CustomerClearRequestError);
                                setActAndLogError(message, "CustomerClearRequest", reinterpret_cast<act_t>(this), _logger);
                                ((CustomerClearRequestCallbackIF*) _callback)->onCustomerClearRequestError (proxy, ::boost::static_pointer_cast<CustomerClearRequestError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_WriteToMedia: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::WriteToMediaResult);
                                setActAndLogResult(message, "WriteToMedia", reinterpret_cast<act_t>(this), _logger);
                                ((WriteToMediaCallbackIF*) _callback)->onWriteToMediaResult (proxy, ::boost::static_pointer_cast<WriteToMediaResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::WriteToMediaError);
                                setActAndLogError(message, "WriteToMedia", reinterpret_cast<act_t>(this), _logger);
                                ((WriteToMediaCallbackIF*) _callback)->onWriteToMediaError (proxy, ::boost::static_pointer_cast<WriteToMediaError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_getDTCbyStatusMask: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::GetDTCbyStatusMaskResult);
                                setActAndLogResult(message, "GetDTCbyStatusMask", reinterpret_cast<act_t>(this), _logger);
                                ((GetDTCbyStatusMaskCallbackIF*) _callback)->onGetDTCbyStatusMaskResult (proxy, ::boost::static_pointer_cast<GetDTCbyStatusMaskResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::GetDTCbyStatusMaskError);
                                setActAndLogError(message, "GetDTCbyStatusMask", reinterpret_cast<act_t>(this), _logger);
                                ((GetDTCbyStatusMaskCallbackIF*) _callback)->onGetDTCbyStatusMaskError (proxy, ::boost::static_pointer_cast<GetDTCbyStatusMaskError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_getLastConfirmedDTC: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::GetLastConfirmedDTCResult);
                                setActAndLogResult(message, "GetLastConfirmedDTC", reinterpret_cast<act_t>(this), _logger);
                                ((GetLastConfirmedDTCCallbackIF*) _callback)->onGetLastConfirmedDTCResult (proxy, ::boost::static_pointer_cast<GetLastConfirmedDTCResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::GetLastConfirmedDTCError);
                                setActAndLogError(message, "GetLastConfirmedDTC", reinterpret_cast<act_t>(this), _logger);
                                ((GetLastConfirmedDTCCallbackIF*) _callback)->onGetLastConfirmedDTCError (proxy, ::boost::static_pointer_cast<GetLastConfirmedDTCError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_getSupportedDTC: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::GetSupportedDTCResult);
                                setActAndLogResult(message, "GetSupportedDTC", reinterpret_cast<act_t>(this), _logger);
                                ((GetSupportedDTCCallbackIF*) _callback)->onGetSupportedDTCResult (proxy, ::boost::static_pointer_cast<GetSupportedDTCResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::GetSupportedDTCError);
                                setActAndLogError(message, "GetSupportedDTC", reinterpret_cast<act_t>(this), _logger);
                                ((GetSupportedDTCCallbackIF*) _callback)->onGetSupportedDTCError (proxy, ::boost::static_pointer_cast<GetSupportedDTCError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_getNumberOfDTCByStatusMask: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::GetNumberOfDTCByStatusMaskResult);
                                setActAndLogResult(message, "GetNumberOfDTCByStatusMask", reinterpret_cast<act_t>(this), _logger);
                                ((GetNumberOfDTCByStatusMaskCallbackIF*) _callback)->onGetNumberOfDTCByStatusMaskResult (proxy, ::boost::static_pointer_cast<GetNumberOfDTCByStatusMaskResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::GetNumberOfDTCByStatusMaskError);
                                setActAndLogError(message, "GetNumberOfDTCByStatusMask", reinterpret_cast<act_t>(this), _logger);
                                ((GetNumberOfDTCByStatusMaskCallbackIF*) _callback)->onGetNumberOfDTCByStatusMaskError (proxy, ::boost::static_pointer_cast<GetNumberOfDTCByStatusMaskError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_getStatusByDTC: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::GetStatusByDTCResult);
                                setActAndLogResult(message, "GetStatusByDTC", reinterpret_cast<act_t>(this), _logger);
                                ((GetStatusByDTCCallbackIF*) _callback)->onGetStatusByDTCResult (proxy, ::boost::static_pointer_cast<GetStatusByDTCResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::GetStatusByDTCError);
                                setActAndLogError(message, "GetStatusByDTC", reinterpret_cast<act_t>(this), _logger);
                                ((GetStatusByDTCCallbackIF*) _callback)->onGetStatusByDTCError (proxy, ::boost::static_pointer_cast<GetStatusByDTCError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_getExtendedDataByDTC: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::GetExtendedDataByDTCResult);
                                setActAndLogResult(message, "GetExtendedDataByDTC", reinterpret_cast<act_t>(this), _logger);
                                ((GetExtendedDataByDTCCallbackIF*) _callback)->onGetExtendedDataByDTCResult (proxy, ::boost::static_pointer_cast<GetExtendedDataByDTCResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::GetExtendedDataByDTCError);
                                setActAndLogError(message, "GetExtendedDataByDTC", reinterpret_cast<act_t>(this), _logger);
                                ((GetExtendedDataByDTCCallbackIF*) _callback)->onGetExtendedDataByDTCError (proxy, ::boost::static_pointer_cast<GetExtendedDataByDTCError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_getStatusByITC: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::GetStatusByITCResult);
                                setActAndLogResult(message, "GetStatusByITC", reinterpret_cast<act_t>(this), _logger);
                                ((GetStatusByITCCallbackIF*) _callback)->onGetStatusByITCResult (proxy, ::boost::static_pointer_cast<GetStatusByITCResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::GetStatusByITCError);
                                setActAndLogError(message, "GetStatusByITC", reinterpret_cast<act_t>(this), _logger);
                                ((GetStatusByITCCallbackIF*) _callback)->onGetStatusByITCError (proxy, ::boost::static_pointer_cast<GetStatusByITCError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_reportDTCSnapshotIdentification: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::ReportDTCSnapshotIdentificationResult);
                                setActAndLogResult(message, "ReportDTCSnapshotIdentification", reinterpret_cast<act_t>(this), _logger);
                                ((ReportDTCSnapshotIdentificationCallbackIF*) _callback)->onReportDTCSnapshotIdentificationResult (proxy, ::boost::static_pointer_cast<ReportDTCSnapshotIdentificationResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::ReportDTCSnapshotIdentificationError);
                                setActAndLogError(message, "ReportDTCSnapshotIdentification", reinterpret_cast<act_t>(this), _logger);
                                ((ReportDTCSnapshotIdentificationCallbackIF*) _callback)->onReportDTCSnapshotIdentificationError (proxy, ::boost::static_pointer_cast<ReportDTCSnapshotIdentificationError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_reportDTCSnapshotRecordByDTCNumber: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::ReportDTCSnapshotRecordByDTCNumberResult);
                                setActAndLogResult(message, "ReportDTCSnapshotRecordByDTCNumber", reinterpret_cast<act_t>(this), _logger);
                                ((ReportDTCSnapshotRecordByDTCNumberCallbackIF*) _callback)->onReportDTCSnapshotRecordByDTCNumberResult (proxy, ::boost::static_pointer_cast<ReportDTCSnapshotRecordByDTCNumberResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::ReportDTCSnapshotRecordByDTCNumberError);
                                setActAndLogError(message, "ReportDTCSnapshotRecordByDTCNumber", reinterpret_cast<act_t>(this), _logger);
                                ((ReportDTCSnapshotRecordByDTCNumberCallbackIF*) _callback)->onReportDTCSnapshotRecordByDTCNumberError (proxy, ::boost::static_pointer_cast<ReportDTCSnapshotRecordByDTCNumberError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_clearDTC: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::ClearDTCResult);
                                setActAndLogResult(message, "ClearDTC", reinterpret_cast<act_t>(this), _logger);
                                ((ClearDTCCallbackIF*) _callback)->onClearDTCResult (proxy, ::boost::static_pointer_cast<ClearDTCResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::ClearDTCError);
                                setActAndLogError(message, "ClearDTC", reinterpret_cast<act_t>(this), _logger);
                                ((ClearDTCCallbackIF*) _callback)->onClearDTCError (proxy, ::boost::static_pointer_cast<ClearDTCError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Control: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::ControlResult);
                                setActAndLogResult(message, "Control", reinterpret_cast<act_t>(this), _logger);
                                ((ControlCallbackIF*) _callback)->onControlResult (proxy, ::boost::static_pointer_cast<ControlResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::ControlError);
                                setActAndLogError(message, "Control", reinterpret_cast<act_t>(this), _logger);
                                ((ControlCallbackIF*) _callback)->onControlError (proxy, ::boost::static_pointer_cast<ControlError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ControlDtcSetting: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::ControlDtcSettingResult);
                                setActAndLogResult(message, "ControlDtcSetting", reinterpret_cast<act_t>(this), _logger);
                                ((ControlDtcSettingCallbackIF*) _callback)->onControlDtcSettingResult (proxy, ::boost::static_pointer_cast<ControlDtcSettingResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::ControlDtcSettingError);
                                setActAndLogError(message, "ControlDtcSetting", reinterpret_cast<act_t>(this), _logger);
                                ((ControlDtcSettingCallbackIF*) _callback)->onControlDtcSettingError (proxy, ::boost::static_pointer_cast<ControlDtcSettingError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetFactorySettingsNew: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::SetFactorySettingsNewResult);
                                setActAndLogResult(message, "SetFactorySettingsNew", reinterpret_cast<act_t>(this), _logger);
                                ((SetFactorySettingsNewCallbackIF*) _callback)->onSetFactorySettingsNewResult (proxy, ::boost::static_pointer_cast<SetFactorySettingsNewResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::SetFactorySettingsNewError);
                                setActAndLogError(message, "SetFactorySettingsNew", reinterpret_cast<act_t>(this), _logger);
                                ((SetFactorySettingsNewCallbackIF*) _callback)->onSetFactorySettingsNewError (proxy, ::boost::static_pointer_cast<SetFactorySettingsNewError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DTCActive: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::DTCActiveStatus);
                                setActAndLogStatus(message, "DTCActive", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DTCActiveStatus> payload = ::boost::static_pointer_cast<DTCActiveStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DTCActiveStatus >& refNullableStatus = proxy->_dTCActive;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DTCActiveCallbackIF*) _callback)->onDTCActiveStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DTCActiveCallbackIF*) _callback)->onDTCActiveStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::DTCActiveError);
                                setActAndLogError(message, "DTCActive", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DTCActiveCallbackIF*) _callback)->onDTCActiveError(proxy, ::boost::static_pointer_cast<DTCActiveError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SendNextTestResult: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::SendNextTestResultStatus);
                                setActAndLogStatus(message, "SendNextTestResult", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SendNextTestResultStatus> payload = ::boost::static_pointer_cast<SendNextTestResultStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SendNextTestResultStatus >& refNullableStatus = proxy->_sendNextTestResult;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SendNextTestResultCallbackIF*) _callback)->onSendNextTestResultStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::SendNextTestResultError);
                                setActAndLogError(message, "SendNextTestResult", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((SendNextTestResultCallbackIF*) _callback)->onSendNextTestResultError(proxy, ::boost::static_pointer_cast<SendNextTestResultError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DTCTriggered: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::DTCTriggeredStatus);
                                setActAndLogStatus(message, "DTCTriggered", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DTCTriggeredStatus> payload = ::boost::static_pointer_cast<DTCTriggeredStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DTCTriggeredStatus >& refNullableStatus = proxy->_dTCTriggered;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DTCTriggeredCallbackIF*) _callback)->onDTCTriggeredStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DTCTriggeredCallbackIF*) _callback)->onDTCTriggeredStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::DTCTriggeredError);
                                setActAndLogError(message, "DTCTriggered", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((DTCTriggeredCallbackIF*) _callback)->onDTCTriggeredError(proxy, ::boost::static_pointer_cast<DTCTriggeredError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SendActiveDTCList: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::SendActiveDTCListStatus);
                                setActAndLogStatus(message, "SendActiveDTCList", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SendActiveDTCListStatus> payload = ::boost::static_pointer_cast<SendActiveDTCListStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SendActiveDTCListStatus >& refNullableStatus = proxy->_sendActiveDTCList;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SendActiveDTCListCallbackIF*) _callback)->onSendActiveDTCListStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::SendActiveDTCListError);
                                setActAndLogError(message, "SendActiveDTCList", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((SendActiveDTCListCallbackIF*) _callback)->onSendActiveDTCListError(proxy, ::boost::static_pointer_cast<SendActiveDTCListError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DtcStatusChanged: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::DtcStatusChangedStatus);
                                setActAndLogStatus(message, "DtcStatusChanged", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DtcStatusChangedStatus> payload = ::boost::static_pointer_cast<DtcStatusChangedStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::boost::shared_ptr<DtcStatusChangedRelUpReg> relUpRegPara = ::boost::static_pointer_cast<DtcStatusChangedRelUpReg>(_message->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        Diaglog_main_fiProxy::DtcStatusChangedMap& refStatusMap = proxy->_dtcStatusChangedMap;
                                        Diaglog_main_fiProxy::DtcStatusChangedMap::iterator it = refStatusMap.find(*relUpRegPara);
                                        if (it == refStatusMap.end()) {
                                            ((DtcStatusChangedCallbackIF*) _callback)->onDtcStatusChangedStatus(proxy, payload);
                                            refStatusMap[*relUpRegPara] = *payload.get();
                                        }
                                        else if (message.isLoopBack() == false || (*it).second == *payload.get()) {
                                            ((DtcStatusChangedCallbackIF*) _callback)->onDtcStatusChangedStatus(proxy, payload);
                                            (*it).second = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::diaglog_main_fi::DtcStatusChangedError);
                                setActAndLogError(message, "DtcStatusChanged", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((DtcStatusChangedCallbackIF*) _callback)->onDtcStatusChangedError(proxy, ::boost::static_pointer_cast<DtcStatusChangedError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Diaglog_main_fiProxy> proxy = ::boost::static_pointer_cast<Diaglog_main_fiProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_SaveTestResult: {
                ::boost::shared_ptr< SaveTestResultError > payload (new SaveTestResultError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SaveTestResult", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SaveTestResultCallbackIF*) _callback)->onSaveTestResultError (proxy, payload);
                return true;
            }
            case FID_SaveTestResultDynamicalDTC: {
                ::boost::shared_ptr< SaveTestResultDynamicalDTCError > payload (new SaveTestResultDynamicalDTCError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SaveTestResultDynamicalDTC", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SaveTestResultDynamicalDTCCallbackIF*) _callback)->onSaveTestResultDynamicalDTCError (proxy, payload);
                return true;
            }
            case FID_ProductionReadRequest: {
                ::boost::shared_ptr< ProductionReadRequestError > payload (new ProductionReadRequestError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ProductionReadRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ProductionReadRequestCallbackIF*) _callback)->onProductionReadRequestError (proxy, payload);
                return true;
            }
            case FID_CustomerReadRequest: {
                ::boost::shared_ptr< CustomerReadRequestError > payload (new CustomerReadRequestError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CustomerReadRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((CustomerReadRequestCallbackIF*) _callback)->onCustomerReadRequestError (proxy, payload);
                return true;
            }
            case FID_getItcInformation: {
                ::boost::shared_ptr< GetItcInformationError > payload (new GetItcInformationError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetItcInformation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetItcInformationCallbackIF*) _callback)->onGetItcInformationError (proxy, payload);
                return true;
            }
            case FID_ProductionClearRequest: {
                ::boost::shared_ptr< ProductionClearRequestError > payload (new ProductionClearRequestError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ProductionClearRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ProductionClearRequestCallbackIF*) _callback)->onProductionClearRequestError (proxy, payload);
                return true;
            }
            case FID_CustomerClearRequest: {
                ::boost::shared_ptr< CustomerClearRequestError > payload (new CustomerClearRequestError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CustomerClearRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((CustomerClearRequestCallbackIF*) _callback)->onCustomerClearRequestError (proxy, payload);
                return true;
            }
            case FID_WriteToMedia: {
                ::boost::shared_ptr< WriteToMediaError > payload (new WriteToMediaError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "WriteToMedia", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((WriteToMediaCallbackIF*) _callback)->onWriteToMediaError (proxy, payload);
                return true;
            }
            case FID_getDTCbyStatusMask: {
                ::boost::shared_ptr< GetDTCbyStatusMaskError > payload (new GetDTCbyStatusMaskError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetDTCbyStatusMask", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetDTCbyStatusMaskCallbackIF*) _callback)->onGetDTCbyStatusMaskError (proxy, payload);
                return true;
            }
            case FID_getLastConfirmedDTC: {
                ::boost::shared_ptr< GetLastConfirmedDTCError > payload (new GetLastConfirmedDTCError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetLastConfirmedDTC", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetLastConfirmedDTCCallbackIF*) _callback)->onGetLastConfirmedDTCError (proxy, payload);
                return true;
            }
            case FID_getSupportedDTC: {
                ::boost::shared_ptr< GetSupportedDTCError > payload (new GetSupportedDTCError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetSupportedDTC", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetSupportedDTCCallbackIF*) _callback)->onGetSupportedDTCError (proxy, payload);
                return true;
            }
            case FID_getNumberOfDTCByStatusMask: {
                ::boost::shared_ptr< GetNumberOfDTCByStatusMaskError > payload (new GetNumberOfDTCByStatusMaskError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetNumberOfDTCByStatusMask", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetNumberOfDTCByStatusMaskCallbackIF*) _callback)->onGetNumberOfDTCByStatusMaskError (proxy, payload);
                return true;
            }
            case FID_getStatusByDTC: {
                ::boost::shared_ptr< GetStatusByDTCError > payload (new GetStatusByDTCError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetStatusByDTC", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetStatusByDTCCallbackIF*) _callback)->onGetStatusByDTCError (proxy, payload);
                return true;
            }
            case FID_getExtendedDataByDTC: {
                ::boost::shared_ptr< GetExtendedDataByDTCError > payload (new GetExtendedDataByDTCError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetExtendedDataByDTC", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetExtendedDataByDTCCallbackIF*) _callback)->onGetExtendedDataByDTCError (proxy, payload);
                return true;
            }
            case FID_getStatusByITC: {
                ::boost::shared_ptr< GetStatusByITCError > payload (new GetStatusByITCError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetStatusByITC", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GetStatusByITCCallbackIF*) _callback)->onGetStatusByITCError (proxy, payload);
                return true;
            }
            case FID_reportDTCSnapshotIdentification: {
                ::boost::shared_ptr< ReportDTCSnapshotIdentificationError > payload (new ReportDTCSnapshotIdentificationError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReportDTCSnapshotIdentification", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ReportDTCSnapshotIdentificationCallbackIF*) _callback)->onReportDTCSnapshotIdentificationError (proxy, payload);
                return true;
            }
            case FID_reportDTCSnapshotRecordByDTCNumber: {
                ::boost::shared_ptr< ReportDTCSnapshotRecordByDTCNumberError > payload (new ReportDTCSnapshotRecordByDTCNumberError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReportDTCSnapshotRecordByDTCNumber", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ReportDTCSnapshotRecordByDTCNumberCallbackIF*) _callback)->onReportDTCSnapshotRecordByDTCNumberError (proxy, payload);
                return true;
            }
            case FID_clearDTC: {
                ::boost::shared_ptr< ClearDTCError > payload (new ClearDTCError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ClearDTC", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ClearDTCCallbackIF*) _callback)->onClearDTCError (proxy, payload);
                return true;
            }
            case FID_Control: {
                ::boost::shared_ptr< ControlError > payload (new ControlError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Control", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ControlCallbackIF*) _callback)->onControlError (proxy, payload);
                return true;
            }
            case FID_ControlDtcSetting: {
                ::boost::shared_ptr< ControlDtcSettingError > payload (new ControlDtcSettingError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ControlDtcSetting", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ControlDtcSettingCallbackIF*) _callback)->onControlDtcSettingError (proxy, payload);
                return true;
            }
            case FID_SetFactorySettingsNew: {
                ::boost::shared_ptr< SetFactorySettingsNewError > payload (new SetFactorySettingsNewError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetFactorySettingsNew", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetFactorySettingsNewCallbackIF*) _callback)->onSetFactorySettingsNewError (proxy, payload);
                return true;
            }
            case FID_DTCActive: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< DTCActiveError > payload (new DTCActiveError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DTCActive", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DTCActiveCallbackIF*) _callback)->onDTCActiveError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SendNextTestResult: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< SendNextTestResultError > payload (new SendNextTestResultError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SendNextTestResult", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SendNextTestResultCallbackIF*) _callback)->onSendNextTestResultError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DTCTriggered: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< DTCTriggeredError > payload (new DTCTriggeredError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DTCTriggered", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DTCTriggeredCallbackIF*) _callback)->onDTCTriggeredError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SendActiveDTCList: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< SendActiveDTCListError > payload (new SendActiveDTCListError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SendActiveDTCList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SendActiveDTCListCallbackIF*) _callback)->onSendActiveDTCListError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DtcStatusChanged: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< DtcStatusChangedError > payload (new DtcStatusChangedError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DtcStatusChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DtcStatusChangedCallbackIF*) _callback)->onDtcStatusChangedError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Diaglog_main_fiProxyCallback::_logger (Diaglog_main_fiProxy::_logger);

/*static*/ ::boost::shared_ptr< Diaglog_main_fiProxy > Diaglog_main_fiProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Diaglog_main_fiProxy >  proxyNew(new Diaglog_main_fiProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Diaglog_main_fiProxy > Diaglog_main_fiProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Diaglog_main_fiProxy >  proxyNew(new Diaglog_main_fiProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Diaglog_main_fiProxy > Diaglog_main_fiProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Diaglog_main_fiProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Diaglog_main_fiProxy >  proxyNew(new Diaglog_main_fiProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Diaglog_main_fiProxy::Diaglog_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Diaglog_main_fiProxy::~Diaglog_main_fiProxy()
{
    LOG_INFO ("Entering ~Diaglog_main_fiProxy");
    sendRelUpRegAll ();
}

act_t Diaglog_main_fiProxy::sendSaveTestResultStart(SaveTestResultCallbackIF& cb, const ::diaglog_main_fi_types::T_TestResultList& testResultList) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SaveTestResult);
        ::boost::shared_ptr< SaveTestResultStart > payload (new SaveTestResultStart());
        payload->setTestResultList(testResultList);
        CCA_MESSAGE(ccaMessage,header,SaveTestResultStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SaveTestResult", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SaveTestResult);
        ::boost::shared_ptr< SaveTestResultError > payload (new SaveTestResultError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SaveTestResultError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SaveTestResult", &cb);
    }
}

act_t Diaglog_main_fiProxy::sendSaveTestResultDynamicalDTCStart(SaveTestResultDynamicalDTCCallbackIF& cb, const ::diaglog_main_fi_types::T_TestResultList& testResultList) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SaveTestResultDynamicalDTC);
        ::boost::shared_ptr< SaveTestResultDynamicalDTCStart > payload (new SaveTestResultDynamicalDTCStart());
        payload->setTestResultList(testResultList);
        CCA_MESSAGE(ccaMessage,header,SaveTestResultDynamicalDTCStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SaveTestResultDynamicalDTC", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SaveTestResultDynamicalDTC);
        ::boost::shared_ptr< SaveTestResultDynamicalDTCError > payload (new SaveTestResultDynamicalDTCError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SaveTestResultDynamicalDTCError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SaveTestResultDynamicalDTC", &cb);
    }
}

act_t Diaglog_main_fiProxy::sendProductionReadRequestStart(ProductionReadRequestCallbackIF& cb, ::diaglog_main_fi_types::T_e8_Protocol protocol, uint8 statusMask, uint32 iTCMask, uint32 option) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ProductionReadRequest);
        ::boost::shared_ptr< ProductionReadRequestStart > payload (new ProductionReadRequestStart());
        payload->setProtocol(protocol);
        payload->setStatusMask(statusMask);
        payload->setITCMask(iTCMask);
        payload->setOption(option);
        CCA_MESSAGE(ccaMessage,header,ProductionReadRequestStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ProductionReadRequest", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ProductionReadRequest);
        ::boost::shared_ptr< ProductionReadRequestError > payload (new ProductionReadRequestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ProductionReadRequestError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ProductionReadRequest", &cb);
    }
}

act_t Diaglog_main_fiProxy::sendCustomerReadRequestStart(CustomerReadRequestCallbackIF& cb, ::diaglog_main_fi_types::T_e8_Protocol protocol, uint8 statusMask, uint32 dTCMask, uint32 option) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_CustomerReadRequest);
        ::boost::shared_ptr< CustomerReadRequestStart > payload (new CustomerReadRequestStart());
        payload->setProtocol(protocol);
        payload->setStatusMask(statusMask);
        payload->setDTCMask(dTCMask);
        payload->setOption(option);
        CCA_MESSAGE(ccaMessage,header,CustomerReadRequestStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "CustomerReadRequest", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CustomerReadRequest);
        ::boost::shared_ptr< CustomerReadRequestError > payload (new CustomerReadRequestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CustomerReadRequestError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "CustomerReadRequest", &cb);
    }
}

act_t Diaglog_main_fiProxy::sendGetItcInformationStart(GetItcInformationCallbackIF& cb, uint8 group, const ::std::vector< uint16 >& iTCList) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_getItcInformation);
        ::boost::shared_ptr< GetItcInformationStart > payload (new GetItcInformationStart());
        payload->setGroup(group);
        payload->setITCList(iTCList);
        CCA_MESSAGE(ccaMessage,header,GetItcInformationStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetItcInformation", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_getItcInformation);
        ::boost::shared_ptr< GetItcInformationError > payload (new GetItcInformationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetItcInformationError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetItcInformation", &cb);
    }
}

act_t Diaglog_main_fiProxy::sendProductionClearRequestStart(ProductionClearRequestCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ProductionClearRequest);
        ::boost::shared_ptr< ProductionClearRequestStart > payload (new ProductionClearRequestStart());
        CCA_MESSAGE(ccaMessage,header,ProductionClearRequestStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ProductionClearRequest", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ProductionClearRequest);
        ::boost::shared_ptr< ProductionClearRequestError > payload (new ProductionClearRequestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ProductionClearRequestError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ProductionClearRequest", &cb);
    }
}

act_t Diaglog_main_fiProxy::sendCustomerClearRequestStart(CustomerClearRequestCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_CustomerClearRequest);
        ::boost::shared_ptr< CustomerClearRequestStart > payload (new CustomerClearRequestStart());
        CCA_MESSAGE(ccaMessage,header,CustomerClearRequestStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "CustomerClearRequest", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CustomerClearRequest);
        ::boost::shared_ptr< CustomerClearRequestError > payload (new CustomerClearRequestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CustomerClearRequestError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "CustomerClearRequest", &cb);
    }
}

act_t Diaglog_main_fiProxy::sendWriteToMediaStart(WriteToMediaCallbackIF& cb, ::diaglog_main_fi_types::T_e8_VDLMediaType media) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_WriteToMedia);
        ::boost::shared_ptr< WriteToMediaStart > payload (new WriteToMediaStart());
        payload->setMedia(media);
        CCA_MESSAGE(ccaMessage,header,WriteToMediaStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "WriteToMedia", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_WriteToMedia);
        ::boost::shared_ptr< WriteToMediaError > payload (new WriteToMediaError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,WriteToMediaError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "WriteToMedia", &cb);
    }
}

act_t Diaglog_main_fiProxy::sendGetDTCbyStatusMaskStart(GetDTCbyStatusMaskCallbackIF& cb, uint8 group, uint8 statusMask, uint32 dTCMask) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_getDTCbyStatusMask);
        ::boost::shared_ptr< GetDTCbyStatusMaskStart > payload (new GetDTCbyStatusMaskStart());
        payload->setGroup(group);
        payload->setStatusMask(statusMask);
        payload->setDTCMask(dTCMask);
        CCA_MESSAGE(ccaMessage,header,GetDTCbyStatusMaskStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetDTCbyStatusMask", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_getDTCbyStatusMask);
        ::boost::shared_ptr< GetDTCbyStatusMaskError > payload (new GetDTCbyStatusMaskError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetDTCbyStatusMaskError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetDTCbyStatusMask", &cb);
    }
}

act_t Diaglog_main_fiProxy::sendGetLastConfirmedDTCStart(GetLastConfirmedDTCCallbackIF& cb, uint8 group) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_getLastConfirmedDTC);
        ::boost::shared_ptr< GetLastConfirmedDTCStart > payload (new GetLastConfirmedDTCStart());
        payload->setGroup(group);
        CCA_MESSAGE(ccaMessage,header,GetLastConfirmedDTCStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetLastConfirmedDTC", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_getLastConfirmedDTC);
        ::boost::shared_ptr< GetLastConfirmedDTCError > payload (new GetLastConfirmedDTCError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetLastConfirmedDTCError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetLastConfirmedDTC", &cb);
    }
}

act_t Diaglog_main_fiProxy::sendGetSupportedDTCStart(GetSupportedDTCCallbackIF& cb, uint8 group) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_getSupportedDTC);
        ::boost::shared_ptr< GetSupportedDTCStart > payload (new GetSupportedDTCStart());
        payload->setGroup(group);
        CCA_MESSAGE(ccaMessage,header,GetSupportedDTCStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetSupportedDTC", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_getSupportedDTC);
        ::boost::shared_ptr< GetSupportedDTCError > payload (new GetSupportedDTCError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetSupportedDTCError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetSupportedDTC", &cb);
    }
}

act_t Diaglog_main_fiProxy::sendGetNumberOfDTCByStatusMaskStart(GetNumberOfDTCByStatusMaskCallbackIF& cb, uint8 group, uint8 statusMask, uint32 dTCMask) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_getNumberOfDTCByStatusMask);
        ::boost::shared_ptr< GetNumberOfDTCByStatusMaskStart > payload (new GetNumberOfDTCByStatusMaskStart());
        payload->setGroup(group);
        payload->setStatusMask(statusMask);
        payload->setDTCMask(dTCMask);
        CCA_MESSAGE(ccaMessage,header,GetNumberOfDTCByStatusMaskStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetNumberOfDTCByStatusMask", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_getNumberOfDTCByStatusMask);
        ::boost::shared_ptr< GetNumberOfDTCByStatusMaskError > payload (new GetNumberOfDTCByStatusMaskError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetNumberOfDTCByStatusMaskError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetNumberOfDTCByStatusMask", &cb);
    }
}

act_t Diaglog_main_fiProxy::sendGetStatusByDTCStart(GetStatusByDTCCallbackIF& cb, uint8 group, uint32 dTCMask) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_getStatusByDTC);
        ::boost::shared_ptr< GetStatusByDTCStart > payload (new GetStatusByDTCStart());
        payload->setGroup(group);
        payload->setDTCMask(dTCMask);
        CCA_MESSAGE(ccaMessage,header,GetStatusByDTCStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetStatusByDTC", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_getStatusByDTC);
        ::boost::shared_ptr< GetStatusByDTCError > payload (new GetStatusByDTCError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetStatusByDTCError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetStatusByDTC", &cb);
    }
}

act_t Diaglog_main_fiProxy::sendGetExtendedDataByDTCStart(GetExtendedDataByDTCCallbackIF& cb, uint8 group, uint32 dTC, uint8 dTCExtDataRecordNumber) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_getExtendedDataByDTC);
        ::boost::shared_ptr< GetExtendedDataByDTCStart > payload (new GetExtendedDataByDTCStart());
        payload->setGroup(group);
        payload->setDTC(dTC);
        payload->setDTCExtDataRecordNumber(dTCExtDataRecordNumber);
        CCA_MESSAGE(ccaMessage,header,GetExtendedDataByDTCStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetExtendedDataByDTC", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_getExtendedDataByDTC);
        ::boost::shared_ptr< GetExtendedDataByDTCError > payload (new GetExtendedDataByDTCError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetExtendedDataByDTCError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetExtendedDataByDTC", &cb);
    }
}

act_t Diaglog_main_fiProxy::sendGetStatusByITCStart(GetStatusByITCCallbackIF& cb, uint8 group, uint32 iTCMask) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_getStatusByITC);
        ::boost::shared_ptr< GetStatusByITCStart > payload (new GetStatusByITCStart());
        payload->setGroup(group);
        payload->setITCMask(iTCMask);
        CCA_MESSAGE(ccaMessage,header,GetStatusByITCStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GetStatusByITC", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_getStatusByITC);
        ::boost::shared_ptr< GetStatusByITCError > payload (new GetStatusByITCError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GetStatusByITCError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GetStatusByITC", &cb);
    }
}

act_t Diaglog_main_fiProxy::sendReportDTCSnapshotIdentificationStart(ReportDTCSnapshotIdentificationCallbackIF& cb, uint8 group) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_reportDTCSnapshotIdentification);
        ::boost::shared_ptr< ReportDTCSnapshotIdentificationStart > payload (new ReportDTCSnapshotIdentificationStart());
        payload->setGroup(group);
        CCA_MESSAGE(ccaMessage,header,ReportDTCSnapshotIdentificationStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ReportDTCSnapshotIdentification", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_reportDTCSnapshotIdentification);
        ::boost::shared_ptr< ReportDTCSnapshotIdentificationError > payload (new ReportDTCSnapshotIdentificationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ReportDTCSnapshotIdentificationError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ReportDTCSnapshotIdentification", &cb);
    }
}

act_t Diaglog_main_fiProxy::sendReportDTCSnapshotRecordByDTCNumberStart(ReportDTCSnapshotRecordByDTCNumberCallbackIF& cb, uint8 group, uint32 dTC, uint8 dTCSnapshotRecordNumber) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_reportDTCSnapshotRecordByDTCNumber);
        ::boost::shared_ptr< ReportDTCSnapshotRecordByDTCNumberStart > payload (new ReportDTCSnapshotRecordByDTCNumberStart());
        payload->setGroup(group);
        payload->setDTC(dTC);
        payload->setDTCSnapshotRecordNumber(dTCSnapshotRecordNumber);
        CCA_MESSAGE(ccaMessage,header,ReportDTCSnapshotRecordByDTCNumberStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ReportDTCSnapshotRecordByDTCNumber", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_reportDTCSnapshotRecordByDTCNumber);
        ::boost::shared_ptr< ReportDTCSnapshotRecordByDTCNumberError > payload (new ReportDTCSnapshotRecordByDTCNumberError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ReportDTCSnapshotRecordByDTCNumberError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ReportDTCSnapshotRecordByDTCNumber", &cb);
    }
}

act_t Diaglog_main_fiProxy::sendClearDTCStart(ClearDTCCallbackIF& cb, uint8 group, uint32 dTCMask) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_clearDTC);
        ::boost::shared_ptr< ClearDTCStart > payload (new ClearDTCStart());
        payload->setGroup(group);
        payload->setDTCMask(dTCMask);
        CCA_MESSAGE(ccaMessage,header,ClearDTCStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ClearDTC", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_clearDTC);
        ::boost::shared_ptr< ClearDTCError > payload (new ClearDTCError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ClearDTCError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ClearDTC", &cb);
    }
}

act_t Diaglog_main_fiProxy::sendControlStart(ControlCallbackIF& cb, ::diaglog_main_fi_types::T_e8_ControlParameter controlParameter) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_Control);
        ::boost::shared_ptr< ControlStart > payload (new ControlStart());
        payload->setControlParameter(controlParameter);
        CCA_MESSAGE(ccaMessage,header,ControlStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "Control", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Control);
        ::boost::shared_ptr< ControlError > payload (new ControlError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ControlError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "Control", &cb);
    }
}

act_t Diaglog_main_fiProxy::sendControlDtcSettingStart(ControlDtcSettingCallbackIF& cb, ::diaglog_main_fi_types::T_e8_ControlParameter controlParameter, const ::diaglog_main_fi_types::T_ControlList& dTC_List) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ControlDtcSetting);
        ::boost::shared_ptr< ControlDtcSettingStart > payload (new ControlDtcSettingStart());
        payload->setControlParameter(controlParameter);
        payload->setDTC_List(dTC_List);
        CCA_MESSAGE(ccaMessage,header,ControlDtcSettingStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ControlDtcSetting", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ControlDtcSetting);
        ::boost::shared_ptr< ControlDtcSettingError > payload (new ControlDtcSettingError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ControlDtcSettingError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ControlDtcSetting", &cb);
    }
}

act_t Diaglog_main_fiProxy::sendSetFactorySettingsNewStart(SetFactorySettingsNewCallbackIF& cb, ::diaglog_main_fi_types::T_e8_DiaglogDefsetType defSetStateGroup, ::diaglog_diagnostics_fi_types::T_e8_DefSetMode defSetStateMode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetFactorySettingsNew);
        ::boost::shared_ptr< SetFactorySettingsNewStart > payload (new SetFactorySettingsNewStart());
        payload->setDefSetStateGroup(defSetStateGroup);
        payload->setDefSetStateMode(defSetStateMode);
        CCA_MESSAGE(ccaMessage,header,SetFactorySettingsNewStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetFactorySettingsNew", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetFactorySettingsNew);
        ::boost::shared_ptr< SetFactorySettingsNewError > payload (new SetFactorySettingsNewError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetFactorySettingsNewError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetFactorySettingsNew", &cb);
    }
}

act_t Diaglog_main_fiProxy::sendDTCActiveUpReg(DTCActiveCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DTCActive);
        ::boost::shared_ptr< DTCActiveUpReg > payload (new DTCActiveUpReg());
        CCA_MESSAGE(ccaMessage,header,DTCActiveUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DTCActiveRelUpReg > payloadRelUpRegHeap (new DTCActiveRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DTCActive, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::diaglog_main_fi::DTCActiveRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DTCActive, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DTCActive", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DTCActive", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDTCActive()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DTCActive, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DTCActiveStatus > payloadLoopback (new DTCActiveStatus(getDTCActive()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DTCActiveStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DTCActive);
        ::boost::shared_ptr< DTCActiveError > payload (new DTCActiveError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DTCActiveError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DTCActive", &cb);
    }
}

bool Diaglog_main_fiProxy::sendDTCActiveRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DTCActive,"DTCActive");
}

void Diaglog_main_fiProxy::sendDTCActiveRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DTCActive);
}

const DTCActiveStatus& Diaglog_main_fiProxy::getDTCActive() const {
    return _dTCActive.get();
}

bool Diaglog_main_fiProxy::hasDTCActive() const {
    return _dTCActive.hasValue();
}

act_t Diaglog_main_fiProxy::sendDTCActiveGet(DTCActiveCallbackIF& cb, bool isDTCActive) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DTCActive);
        ::boost::shared_ptr< DTCActiveGet > payload (new DTCActiveGet());
        payload->setIsDTCActive(isDTCActive);
        CCA_MESSAGE(ccaMessage,header,DTCActiveGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DTCActive", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DTCActive);
        ::boost::shared_ptr< DTCActiveError > payload (new DTCActiveError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DTCActiveError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DTCActive", &cb);
    }
}

act_t Diaglog_main_fiProxy::sendSendNextTestResultUpReg(SendNextTestResultCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SendNextTestResult);
        ::boost::shared_ptr< SendNextTestResultUpReg > payload (new SendNextTestResultUpReg());
        CCA_MESSAGE(ccaMessage,header,SendNextTestResultUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SendNextTestResultRelUpReg > payloadRelUpRegHeap (new SendNextTestResultRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SendNextTestResult, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::diaglog_main_fi::SendNextTestResultRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SendNextTestResult, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SendNextTestResult", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SendNextTestResult", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSendNextTestResult()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SendNextTestResult, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SendNextTestResultStatus > payloadLoopback (new SendNextTestResultStatus(getSendNextTestResult()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SendNextTestResultStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SendNextTestResult);
        ::boost::shared_ptr< SendNextTestResultError > payload (new SendNextTestResultError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SendNextTestResultError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SendNextTestResult", &cb);
    }
}

bool Diaglog_main_fiProxy::sendSendNextTestResultRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SendNextTestResult,"SendNextTestResult");
}

void Diaglog_main_fiProxy::sendSendNextTestResultRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SendNextTestResult);
}

const SendNextTestResultStatus& Diaglog_main_fiProxy::getSendNextTestResult() const {
    return _sendNextTestResult.get();
}

bool Diaglog_main_fiProxy::hasSendNextTestResult() const {
    return _sendNextTestResult.hasValue();
}

act_t Diaglog_main_fiProxy::sendDTCTriggeredUpReg(DTCTriggeredCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DTCTriggered);
        ::boost::shared_ptr< DTCTriggeredUpReg > payload (new DTCTriggeredUpReg());
        CCA_MESSAGE(ccaMessage,header,DTCTriggeredUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DTCTriggeredRelUpReg > payloadRelUpRegHeap (new DTCTriggeredRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DTCTriggered, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::diaglog_main_fi::DTCTriggeredRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DTCTriggered, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DTCTriggered", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DTCTriggered", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDTCTriggered()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DTCTriggered, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DTCTriggeredStatus > payloadLoopback (new DTCTriggeredStatus(getDTCTriggered()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DTCTriggeredStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DTCTriggered);
        ::boost::shared_ptr< DTCTriggeredError > payload (new DTCTriggeredError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DTCTriggeredError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DTCTriggered", &cb);
    }
}

bool Diaglog_main_fiProxy::sendDTCTriggeredRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DTCTriggered,"DTCTriggered");
}

void Diaglog_main_fiProxy::sendDTCTriggeredRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DTCTriggered);
}

const DTCTriggeredStatus& Diaglog_main_fiProxy::getDTCTriggered() const {
    return _dTCTriggered.get();
}

bool Diaglog_main_fiProxy::hasDTCTriggered() const {
    return _dTCTriggered.hasValue();
}

act_t Diaglog_main_fiProxy::sendDTCTriggeredGet(DTCTriggeredCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DTCTriggered);
        ::boost::shared_ptr< DTCTriggeredGet > payload (new DTCTriggeredGet());
        CCA_MESSAGE(ccaMessage,header,DTCTriggeredGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DTCTriggered", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DTCTriggered);
        ::boost::shared_ptr< DTCTriggeredError > payload (new DTCTriggeredError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DTCTriggeredError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DTCTriggered", &cb);
    }
}

act_t Diaglog_main_fiProxy::sendSendActiveDTCListUpReg(SendActiveDTCListCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SendActiveDTCList);
        ::boost::shared_ptr< SendActiveDTCListUpReg > payload (new SendActiveDTCListUpReg());
        CCA_MESSAGE(ccaMessage,header,SendActiveDTCListUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SendActiveDTCListRelUpReg > payloadRelUpRegHeap (new SendActiveDTCListRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SendActiveDTCList, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::diaglog_main_fi::SendActiveDTCListRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SendActiveDTCList, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SendActiveDTCList", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SendActiveDTCList", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSendActiveDTCList()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SendActiveDTCList, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SendActiveDTCListStatus > payloadLoopback (new SendActiveDTCListStatus(getSendActiveDTCList()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SendActiveDTCListStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SendActiveDTCList);
        ::boost::shared_ptr< SendActiveDTCListError > payload (new SendActiveDTCListError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SendActiveDTCListError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SendActiveDTCList", &cb);
    }
}

bool Diaglog_main_fiProxy::sendSendActiveDTCListRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SendActiveDTCList,"SendActiveDTCList");
}

void Diaglog_main_fiProxy::sendSendActiveDTCListRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SendActiveDTCList);
}

const SendActiveDTCListStatus& Diaglog_main_fiProxy::getSendActiveDTCList() const {
    return _sendActiveDTCList.get();
}

bool Diaglog_main_fiProxy::hasSendActiveDTCList() const {
    return _sendActiveDTCList.hasValue();
}

act_t Diaglog_main_fiProxy::sendDtcStatusChangedUpReg(DtcStatusChangedCallbackIF& cb, uint8 group, uint32 dTCNumber, uint8 dTCStatusBitMask) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DtcStatusChanged);
        ::boost::shared_ptr< DtcStatusChangedUpReg > payload (new DtcStatusChangedUpReg());
        payload->setGroup(group);
        payload->setDTCNumber(dTCNumber);
        payload->setDTCStatusBitMask(dTCStatusBitMask);
        CCA_MESSAGE(ccaMessage,header,DtcStatusChangedUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DtcStatusChangedRelUpReg > payloadRelUpRegHeap (new DtcStatusChangedRelUpReg());
        payloadRelUpRegHeap->setGroup(group);
        payloadRelUpRegHeap->setDTCNumber(dTCNumber);
        payloadRelUpRegHeap->setDTCStatusBitMask(dTCStatusBitMask);
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DtcStatusChanged, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::diaglog_main_fi::DtcStatusChangedRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DtcStatusChanged, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DtcStatusChanged", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DtcStatusChanged", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDtcStatusChanged(group, dTCNumber, dTCStatusBitMask)) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DtcStatusChanged, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DtcStatusChangedStatus > payloadLoopback (new DtcStatusChangedStatus(getDtcStatusChanged(group, dTCNumber, dTCStatusBitMask)));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DtcStatusChangedStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DtcStatusChanged);
        ::boost::shared_ptr< DtcStatusChangedError > payload (new DtcStatusChangedError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DtcStatusChangedError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DtcStatusChanged", &cb);
    }
}

bool Diaglog_main_fiProxy::sendDtcStatusChangedRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DtcStatusChanged,"DtcStatusChanged");
}

void Diaglog_main_fiProxy::sendDtcStatusChangedRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DtcStatusChanged);
}

const DtcStatusChangedStatus& Diaglog_main_fiProxy::getDtcStatusChanged(uint8 group, uint32 dTCNumber, uint8 dTCStatusBitMask) const {
    DtcStatusChangedRelUpReg payload(group, dTCNumber, dTCStatusBitMask);
    DtcStatusChangedMap::const_iterator it = _dtcStatusChangedMap.find(payload);
    if (it != _dtcStatusChangedMap.end()) {
        return it->second;
    } else {
        std::string s;
        serializeJson (payload,s);
        LOG_FATAL("get%s(): No status object available which belongs to the passed parameter: %s", "DtcStatusChanged", s.c_str());
    }
}

bool Diaglog_main_fiProxy::hasDtcStatusChanged(uint8 group, uint32 dTCNumber, uint8 dTCStatusBitMask) const {
    DtcStatusChangedMap::const_iterator it = _dtcStatusChangedMap.find(DtcStatusChangedRelUpReg(group, dTCNumber, dTCStatusBitMask));
    return ( it != _dtcStatusChangedMap.end() );
}


void Diaglog_main_fiProxy::clearAllProperties ()
{
    _dTCActive = ::asf::core::nullable<DTCActiveStatus>();
    _sendNextTestResult = ::asf::core::nullable<SendNextTestResultStatus>();
    _dTCTriggered = ::asf::core::nullable<DTCTriggeredStatus>();
    _sendActiveDTCList = ::asf::core::nullable<SendActiveDTCListStatus>();
    _dtcStatusChangedMap.clear();
}

void Diaglog_main_fiProxy::sendRelUpRegAll()
{
    sendDTCActiveRelUpRegAll();
    sendSendNextTestResultRelUpRegAll();
    sendDTCTriggeredRelUpRegAll();
    sendSendActiveDTCListRelUpRegAll();
    sendDtcStatusChangedRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Diaglog_main_fiProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Diaglog_main_fiProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace diaglog_main_fi
