/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "midw_diagnostics_fi_types.h"
#include "midw_diagnostics_fi_typesConst.h"
#include "midw_diagnostics_fi_typesJson.h"
#include "midw_diagnostics_fi_typesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "T_DisplayData"

void serializeJson (const ::midw_diagnostics_fi_types::T_DisplayData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTestScreen()) {
        yajl_gen_string(g, (const unsigned char*)  "TestScreen" , 10);
        const char* s = ::midw_diagnostics_fi_types::T_e8_TestScreens_Name(value.getTestScreen());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTestScreen());
    }
    if (!isSparse || value.hasDisplayStrings()) {
        yajl_gen_string(g, (const unsigned char*)  "DisplayStrings" , 14);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o1 = value.getDisplayStrings();
        {
            ::std::vector< ::std::string >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                const char *s = (*o0).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_diagnostics_fi_types::T_DisplayData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_CountryLanguage"

void serializeJson (const ::midw_diagnostics_fi_types::T_CountryLanguage& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCountry()) {
        yajl_gen_string(g, (const unsigned char*)  "Country" , 7);
        const char* s = ::midw_diagnostics_fi_types::T_e8_Country_Name(value.getCountry());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getCountry());
    }
    if (!isSparse || value.hasLanguage()) {
        yajl_gen_string(g, (const unsigned char*)  "Language" , 8);
        const char* s = ::midw_diagnostics_fi_types::T_e8_Language_Name(value.getLanguage());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getLanguage());
    }
    if (!isSparse || value.hasSubsystem()) {
        yajl_gen_string(g, (const unsigned char*)  "Subsystem" , 9);
        const char* s = ::midw_diagnostics_fi_types::T_e8_LanguageSubsystem_Name(value.getSubsystem());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSubsystem());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_diagnostics_fi_types::T_CountryLanguage& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_CountryLanguageResult"

void serializeJson (const ::midw_diagnostics_fi_types::T_CountryLanguageResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSuccess()) {
        yajl_gen_string(g, (const unsigned char*)  "Success" , 7);
        yajl_gen_bool(g, (bool)value.getSuccess());
    }
    if (!isSparse || value.hasCountryLanguageList()) {
        yajl_gen_string(g, (const unsigned char*)  "CountryLanguageList" , 19);
        yajl_gen_array_open(g);
        const ::std::vector< ::midw_diagnostics_fi_types::T_CountryLanguage >& o3 = value.getCountryLanguageList();
        {
            ::std::vector< ::midw_diagnostics_fi_types::T_CountryLanguage >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_diagnostics_fi_types::T_CountryLanguageResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_TroubleCode"

void serializeJson (const ::midw_diagnostics_fi_types::T_TroubleCode& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTroubleCode()) {
        yajl_gen_string(g, (const unsigned char*)  "TroubleCode" , 11);
        yajl_gen_integer(g, (long long)value.getTroubleCode());
    }
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "Status" , 6);
        const char* s = ::midw_diagnostics_fi_types::T_e8_TroubleCodeStatus_Name(value.getStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_diagnostics_fi_types::T_TroubleCode& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_RouteCalculationStartParameter"

void serializeJson (const ::midw_diagnostics_fi_types::T_RouteCalculationStartParameter& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCurrentPositionLongitude()) {
        yajl_gen_string(g, (const unsigned char*)  "CurrentPositionLongitude" , 24);
        yajl_gen_integer(g, (long long)value.getCurrentPositionLongitude());
    }
    if (!isSparse || value.hasCurrentPositionLatitude()) {
        yajl_gen_string(g, (const unsigned char*)  "CurrentPositionLatitude" , 23);
        yajl_gen_integer(g, (long long)value.getCurrentPositionLatitude());
    }
    if (!isSparse || value.hasDestinationLongitude()) {
        yajl_gen_string(g, (const unsigned char*)  "DestinationLongitude" , 20);
        yajl_gen_integer(g, (long long)value.getDestinationLongitude());
    }
    if (!isSparse || value.hasDestinationLatitude()) {
        yajl_gen_string(g, (const unsigned char*)  "DestinationLatitude" , 19);
        yajl_gen_integer(g, (long long)value.getDestinationLatitude());
    }
    if (!isSparse || value.hasRouteIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "RouteIndex" , 10);
        yajl_gen_integer(g, (long long)value.getRouteIndex());
    }
    if (!isSparse || value.hasRouteOptimisation()) {
        yajl_gen_string(g, (const unsigned char*)  "RouteOptimisation" , 17);
        yajl_gen_integer(g, (long long)value.getRouteOptimisation());
    }
    if (!isSparse || value.hasCommand()) {
        yajl_gen_string(g, (const unsigned char*)  "Command" , 7);
        const char* s = ::midw_diagnostics_fi_types::T_e8_RouteCalculationCommand_Name(value.getCommand());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getCommand());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_diagnostics_fi_types::T_RouteCalculationStartParameter& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_RouteCalculationResultParameter"

void serializeJson (const ::midw_diagnostics_fi_types::T_RouteCalculationResultParameter& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCurrentPositionLongitude()) {
        yajl_gen_string(g, (const unsigned char*)  "CurrentPositionLongitude" , 24);
        yajl_gen_integer(g, (long long)value.getCurrentPositionLongitude());
    }
    if (!isSparse || value.hasCurrentPositionLatitude()) {
        yajl_gen_string(g, (const unsigned char*)  "CurrentPositionLatitude" , 23);
        yajl_gen_integer(g, (long long)value.getCurrentPositionLatitude());
    }
    if (!isSparse || value.hasDestinationLongitude()) {
        yajl_gen_string(g, (const unsigned char*)  "DestinationLongitude" , 20);
        yajl_gen_integer(g, (long long)value.getDestinationLongitude());
    }
    if (!isSparse || value.hasDestinationLatitude()) {
        yajl_gen_string(g, (const unsigned char*)  "DestinationLatitude" , 19);
        yajl_gen_integer(g, (long long)value.getDestinationLatitude());
    }
    if (!isSparse || value.hasRouteIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "RouteIndex" , 10);
        yajl_gen_integer(g, (long long)value.getRouteIndex());
    }
    if (!isSparse || value.hasRouteOptimisation()) {
        yajl_gen_string(g, (const unsigned char*)  "RouteOptimisation" , 17);
        yajl_gen_integer(g, (long long)value.getRouteOptimisation());
    }
    if (!isSparse || value.hasCommand()) {
        yajl_gen_string(g, (const unsigned char*)  "Command" , 7);
        const char* s = ::midw_diagnostics_fi_types::T_e8_RouteCalculationCommand_Name(value.getCommand());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getCommand());
    }
    if (!isSparse || value.hasRouteCalculationStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "RouteCalculationStatus" , 22);
        const char* s = ::midw_diagnostics_fi_types::T_e8_RouteCalculationStatus_Name(value.getRouteCalculationStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getRouteCalculationStatus());
    }
    if (!isSparse || value.hasRouteLength()) {
        yajl_gen_string(g, (const unsigned char*)  "RouteLength" , 11);
        yajl_gen_integer(g, (long long)value.getRouteLength());
    }
    if (!isSparse || value.hasRouteDuration()) {
        yajl_gen_string(g, (const unsigned char*)  "RouteDuration" , 13);
        yajl_gen_integer(g, (long long)value.getRouteDuration());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_diagnostics_fi_types::T_RouteCalculationResultParameter& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_CalibrationTimeStamp"

void serializeJson (const ::midw_diagnostics_fi_types::T_CalibrationTimeStamp& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasHours()) {
        yajl_gen_string(g, (const unsigned char*)  "Hours" , 5);
        yajl_gen_integer(g, (long long)value.getHours());
    }
    if (!isSparse || value.hasMinutes()) {
        yajl_gen_string(g, (const unsigned char*)  "Minutes" , 7);
        yajl_gen_integer(g, (long long)value.getMinutes());
    }
    if (!isSparse || value.hasSeconds()) {
        yajl_gen_string(g, (const unsigned char*)  "Seconds" , 7);
        yajl_gen_integer(g, (long long)value.getSeconds());
    }
    if (!isSparse || value.hasDay()) {
        yajl_gen_string(g, (const unsigned char*)  "Day" , 3);
        yajl_gen_integer(g, (long long)value.getDay());
    }
    if (!isSparse || value.hasMonth()) {
        yajl_gen_string(g, (const unsigned char*)  "Month" , 5);
        yajl_gen_integer(g, (long long)value.getMonth());
    }
    if (!isSparse || value.hasYear()) {
        yajl_gen_string(g, (const unsigned char*)  "Year" , 4);
        yajl_gen_integer(g, (long long)value.getYear());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::midw_diagnostics_fi_types::T_CalibrationTimeStamp& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace midw_diagnostics_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_diagnostics_fi_types::T_DisplayData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_diagnostics_fi_types
using namespace ::asf::stream::json;

namespace midw_diagnostics_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_diagnostics_fi_types::T_CountryLanguage& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_diagnostics_fi_types
using namespace ::asf::stream::json;

namespace midw_diagnostics_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_diagnostics_fi_types::T_CountryLanguageResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_diagnostics_fi_types
using namespace ::asf::stream::json;

namespace midw_diagnostics_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_diagnostics_fi_types::T_TroubleCode& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_diagnostics_fi_types
using namespace ::asf::stream::json;

namespace midw_diagnostics_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_diagnostics_fi_types::T_RouteCalculationStartParameter& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_diagnostics_fi_types
using namespace ::asf::stream::json;

namespace midw_diagnostics_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_diagnostics_fi_types::T_RouteCalculationResultParameter& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_diagnostics_fi_types
using namespace ::asf::stream::json;

namespace midw_diagnostics_fi_types {

std::ostream& operator<<(std::ostream& o, const ::midw_diagnostics_fi_types::T_CalibrationTimeStamp& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace midw_diagnostics_fi_types

