#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MIDW_DIAGNOSTICS_FI_TYPES_H
#define MIDW_DIAGNOSTICS_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "midw_diagnostics_fi_typesConst.h"
#include <cstring>
#include <string>
#include <vector>

/**
 * Types midw_diagnostics_fi_types
 */

namespace midw_diagnostics_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_DisplayData;

class T_CountryLanguage;

class T_CountryLanguageResult;

class T_TroubleCode;

class T_RouteCalculationStartParameter;

class T_RouteCalculationResultParameter;

class T_CalibrationTimeStamp;

// type definitions
/**
 * If the meaning of "T_DisplayStringsList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< ::std::string > T_DisplayStringsList;

/**
 * If the meaning of "T_TroubleCodeList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_TroubleCode > T_TroubleCodeList;

/**
 * If the meaning of "T_MessageBuffer" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint8 > T_MessageBuffer;

/**
 * If the meaning of "T_KDSItemList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint8 > T_KDSItemList;

/**
 * If the meaning of "T_ConfigItemList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint8 > T_ConfigItemList;

/**
 * If the meaning of "T_RequestDataUDS" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint8 > T_RequestDataUDS;

/**
 * If the meaning of "T_ResponseDataUDS" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint8 > T_ResponseDataUDS;

/**
 * If the meaning of "T_DiagData" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint8 > T_DiagData;

/**
 * If the meaning of "T_CalibrationValue" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint8 > T_CalibrationValue;

/**
 * If the meaning of "T_AlphaCode" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint8 > T_AlphaCode;


/**
 * If the meaning of "T_DisplayData" isn't clear, then there should be a description here.
 */
class T_DisplayData {
public:

    /**
     * Default constructor
     */
    inline  T_DisplayData ();

    /**
     * Copy constructor
     */
    inline  T_DisplayData (const T_DisplayData &rhs);

    /**
     * All fields constructor
     */
    inline  T_DisplayData (T_e8_TestScreens TestScreen_, const T_DisplayStringsList& DisplayStrings_);

    /**
     * Destructor
     */
    inline  ~T_DisplayData();

    /**
     * Assignment operator
     */
    inline T_DisplayData& operator = (const T_DisplayData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DisplayData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DisplayData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DisplayData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DisplayData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TestScreen"

    static const int kTestScreen = 0;

    /**
     * Clears the field "TestScreen".
     *
     * The field will be set to its default value. The hasTestScreen()
     * method will return false.
     */
    inline void clearTestScreen();

    /**
     * Checks whether the field "TestScreen" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTestScreen()). Otherwise it will return false.
     */
    inline bool hasTestScreen () const;

    /**
     * Returns the value of the member "TestScreen".
     *
     * Test screen to be displayed.
     *
     * @return The value of the field "TestScreen"
     */
    inline T_e8_TestScreens getTestScreen () const;

    /**
     * Sets the value of the member "TestScreen".
     *
     * Test screen to be displayed.
     *
     * @param TestScreen The value which will be set
     */
    inline void setTestScreen (T_e8_TestScreens TestScreen_);

    // API of field "DisplayStrings"

    static const int kDisplayStrings = 1;

    /**
     * Clears the field "DisplayStrings".
     *
     * The field will be set to its default value. The hasDisplayStrings()
     * method will return false.
     */
    inline void clearDisplayStrings();

    /**
     * Checks whether the field "DisplayStrings" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayStrings()). Otherwise it will return false.
     */
    inline bool hasDisplayStrings () const;

    /**
     * Returns the value of the member "DisplayStrings".
     *
     * Text to be displayed.
     *
     * @return The value of the field "DisplayStrings"
     */
    inline const T_DisplayStringsList& getDisplayStrings () const;

    /**
     * Retrieves the value of the field "DisplayStrings" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DisplayStrings".
     */
    inline T_DisplayStringsList& getDisplayStringsMutable ();

    /**
     * Sets the value of the member "DisplayStrings".
     *
     * Text to be displayed.
     *
     * @param DisplayStrings The value which will be set
     */
    inline void setDisplayStrings (const T_DisplayStringsList& DisplayStrings_);

    static const T_DisplayData &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_TestScreen ();

    inline void clear_has_TestScreen ();

    inline void set_has_DisplayStrings ();

    inline void clear_has_DisplayStrings ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_TestScreens _TestScreen;

    T_DisplayStringsList _DisplayStrings;

};

/**
 * If the meaning of "T_CountryLanguage" isn't clear, then there should be a description here.
 */
class T_CountryLanguage {
public:

    /**
     * Default constructor
     */
    inline  T_CountryLanguage ();

    /**
     * Copy constructor
     */
    inline  T_CountryLanguage (const T_CountryLanguage &rhs);

    /**
     * All fields constructor
     */
    inline  T_CountryLanguage (T_e8_Country Country_, T_e8_Language Language_, T_e8_LanguageSubsystem Subsystem_);

    /**
     * Destructor
     */
    inline  ~T_CountryLanguage();

    /**
     * Assignment operator
     */
    inline T_CountryLanguage& operator = (const T_CountryLanguage& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_CountryLanguage& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_CountryLanguage& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_CountryLanguage& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_CountryLanguage& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Country"

    static const int kCountry = 0;

    /**
     * Clears the field "Country".
     *
     * The field will be set to its default value. The hasCountry()
     * method will return false.
     */
    inline void clearCountry();

    /**
     * Checks whether the field "Country" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCountry()). Otherwise it will return false.
     */
    inline bool hasCountry () const;

    /**
     * Returns the value of the member "Country".
     *
     * Country code.
     *
     * @return The value of the field "Country"
     */
    inline T_e8_Country getCountry () const;

    /**
     * Sets the value of the member "Country".
     *
     * Country code.
     *
     * @param Country The value which will be set
     */
    inline void setCountry (T_e8_Country Country_);

    // API of field "Language"

    static const int kLanguage = 1;

    /**
     * Clears the field "Language".
     *
     * The field will be set to its default value. The hasLanguage()
     * method will return false.
     */
    inline void clearLanguage();

    /**
     * Checks whether the field "Language" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLanguage()). Otherwise it will return false.
     */
    inline bool hasLanguage () const;

    /**
     * Returns the value of the member "Language".
     *
     * Language code.
     *
     * @return The value of the field "Language"
     */
    inline T_e8_Language getLanguage () const;

    /**
     * Sets the value of the member "Language".
     *
     * Language code.
     *
     * @param Language The value which will be set
     */
    inline void setLanguage (T_e8_Language Language_);

    // API of field "Subsystem"

    static const int kSubsystem = 2;

    /**
     * Clears the field "Subsystem".
     *
     * The field will be set to its default value. The hasSubsystem()
     * method will return false.
     */
    inline void clearSubsystem();

    /**
     * Checks whether the field "Subsystem" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubsystem()). Otherwise it will return false.
     */
    inline bool hasSubsystem () const;

    /**
     * Returns the value of the member "Subsystem".
     *
     * Subsystem  to which the country/language pair is to be applied.
     *
     * @return The value of the field "Subsystem"
     */
    inline T_e8_LanguageSubsystem getSubsystem () const;

    /**
     * Sets the value of the member "Subsystem".
     *
     * Subsystem  to which the country/language pair is to be applied.
     *
     * @param Subsystem The value which will be set
     */
    inline void setSubsystem (T_e8_LanguageSubsystem Subsystem_);

    static const T_CountryLanguage &getDefaultInstance();

private:

    inline void set_has_Country ();

    inline void clear_has_Country ();

    inline void set_has_Language ();

    inline void clear_has_Language ();

    inline void set_has_Subsystem ();

    inline void clear_has_Subsystem ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_e8_Country _Country;

    T_e8_Language _Language;

    T_e8_LanguageSubsystem _Subsystem;

};

/**
 * If the meaning of "T_CountryLanguageResult" isn't clear, then there should be a description here.
 */
class T_CountryLanguageResult {
public:

    /**
     * Default constructor
     */
    inline  T_CountryLanguageResult ();

    /**
     * Copy constructor
     */
    inline  T_CountryLanguageResult (const T_CountryLanguageResult &rhs);

    /**
     * All fields constructor
     */
    inline  T_CountryLanguageResult (bool Success_, const ::std::vector< T_CountryLanguage >& CountryLanguageList_);

    /**
     * Destructor
     */
    inline  ~T_CountryLanguageResult();

    /**
     * Assignment operator
     */
    inline T_CountryLanguageResult& operator = (const T_CountryLanguageResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_CountryLanguageResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_CountryLanguageResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_CountryLanguageResult& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_CountryLanguageResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Success"

    static const int kSuccess = 0;

    /**
     * Clears the field "Success".
     *
     * The field will be set to its default value. The hasSuccess()
     * method will return false.
     */
    inline void clearSuccess();

    /**
     * Checks whether the field "Success" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSuccess()). Otherwise it will return false.
     */
    inline bool hasSuccess () const;

    /**
     * Returns the value of the member "Success".
     *
     * True if language operation was a total success.
     *
     * @return The value of the field "Success"
     */
    inline bool getSuccess () const;

    /**
     * Sets the value of the member "Success".
     *
     * True if language operation was a total success.
     *
     * @param Success The value which will be set
     */
    inline void setSuccess (bool Success_);

    // API of field "CountryLanguageList"

    static const int kCountryLanguageList = 1;

    /**
     * Clears the field "CountryLanguageList".
     *
     * The field will be set to its default value. The hasCountryLanguageList()
     * method will return false.
     */
    inline void clearCountryLanguageList();

    /**
     * Checks whether the field "CountryLanguageList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCountryLanguageList()). Otherwise it will return false.
     */
    inline bool hasCountryLanguageList () const;

    /**
     * Returns the value of the member "CountryLanguageList".
     *
     * The CountryLanguageList contains a number of CountryLanguage elements.
     *
     * @return The value of the field "CountryLanguageList"
     */
    inline const ::std::vector< T_CountryLanguage >& getCountryLanguageList () const;

    /**
     * Retrieves the value of the field "CountryLanguageList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CountryLanguageList".
     */
    inline ::std::vector< T_CountryLanguage >& getCountryLanguageListMutable ();

    /**
     * Sets the value of the member "CountryLanguageList".
     *
     * The CountryLanguageList contains a number of CountryLanguage elements.
     *
     * @param CountryLanguageList The value which will be set
     */
    inline void setCountryLanguageList (const ::std::vector< T_CountryLanguage >& CountryLanguageList_);

    static const T_CountryLanguageResult &getDefaultInstance();

private:

    static const ::std::vector< T_CountryLanguage >& getT_CountryLanguageList_DefaultInstance ();

    inline void set_has_Success ();

    inline void clear_has_Success ();

    inline void set_has_CountryLanguageList ();

    inline void clear_has_CountryLanguageList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _Success;

    ::std::vector< T_CountryLanguage > _CountryLanguageList;

};

/**
 * If the meaning of "T_TroubleCode" isn't clear, then there should be a description here.
 */
class T_TroubleCode {
public:

    /**
     * Default constructor
     */
    inline  T_TroubleCode ();

    /**
     * Copy constructor
     */
    inline  T_TroubleCode (const T_TroubleCode &rhs);

    /**
     * All fields constructor
     */
    inline  T_TroubleCode (uint32 TroubleCode_, T_e8_TroubleCodeStatus Status_);

    /**
     * Destructor
     */
    inline  ~T_TroubleCode();

    /**
     * Assignment operator
     */
    inline T_TroubleCode& operator = (const T_TroubleCode& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TroubleCode& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TroubleCode& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TroubleCode& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TroubleCode& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TroubleCode"

    static const int kTroubleCode = 0;

    /**
     * Clears the field "TroubleCode".
     *
     * The field will be set to its default value. The hasTroubleCode()
     * method will return false.
     */
    inline void clearTroubleCode();

    /**
     * Checks whether the field "TroubleCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTroubleCode()). Otherwise it will return false.
     */
    inline bool hasTroubleCode () const;

    /**
     * Returns the value of the member "TroubleCode".
     *
     * Trouble Code.
     *
     * @return The value of the field "TroubleCode"
     */
    inline uint32 getTroubleCode () const;

    /**
     * Sets the value of the member "TroubleCode".
     *
     * Trouble Code.
     *
     * @param TroubleCode The value which will be set
     */
    inline void setTroubleCode (uint32 TroubleCode_);

    // API of field "Status"

    static const int kStatus = 1;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Status of the trouble code.
     *
     * @return The value of the field "Status"
     */
    inline T_e8_TroubleCodeStatus getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Status of the trouble code.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (T_e8_TroubleCodeStatus Status_);

    static const T_TroubleCode &getDefaultInstance();

private:

    inline void set_has_TroubleCode ();

    inline void clear_has_TroubleCode ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _TroubleCode;

    T_e8_TroubleCodeStatus _Status;

};

/**
 * If the meaning of "T_RouteCalculationStartParameter" isn't clear, then there should be a description here.
 */
class T_RouteCalculationStartParameter {
public:

    /**
     * Default constructor
     */
    inline  T_RouteCalculationStartParameter ();

    /**
     * Copy constructor
     */
    inline  T_RouteCalculationStartParameter (const T_RouteCalculationStartParameter &rhs);

    /**
     * All fields constructor
     */
    inline  T_RouteCalculationStartParameter (int32 CurrentPositionLongitude_, int32 CurrentPositionLatitude_, int32 DestinationLongitude_, int32 DestinationLatitude_, uint8 RouteIndex_, uint8 RouteOptimisation_, T_e8_RouteCalculationCommand Command_);

    /**
     * Destructor
     */
    inline  ~T_RouteCalculationStartParameter();

    /**
     * Assignment operator
     */
    inline T_RouteCalculationStartParameter& operator = (const T_RouteCalculationStartParameter& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_RouteCalculationStartParameter& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_RouteCalculationStartParameter& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_RouteCalculationStartParameter& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_RouteCalculationStartParameter& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CurrentPositionLongitude"

    static const int kCurrentPositionLongitude = 0;

    /**
     * Clears the field "CurrentPositionLongitude".
     *
     * The field will be set to its default value. The hasCurrentPositionLongitude()
     * method will return false.
     */
    inline void clearCurrentPositionLongitude();

    /**
     * Checks whether the field "CurrentPositionLongitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentPositionLongitude()). Otherwise it will return false.
     */
    inline bool hasCurrentPositionLongitude () const;

    /**
     * Returns the value of the member "CurrentPositionLongitude".
     *
     * Longitude of starting point of route calculation.
     *
     * @return The value of the field "CurrentPositionLongitude"
     */
    inline int32 getCurrentPositionLongitude () const;

    /**
     * Sets the value of the member "CurrentPositionLongitude".
     *
     * Longitude of starting point of route calculation.
     *
     * @param CurrentPositionLongitude The value which will be set
     */
    inline void setCurrentPositionLongitude (int32 CurrentPositionLongitude_);

    // API of field "CurrentPositionLatitude"

    static const int kCurrentPositionLatitude = 1;

    /**
     * Clears the field "CurrentPositionLatitude".
     *
     * The field will be set to its default value. The hasCurrentPositionLatitude()
     * method will return false.
     */
    inline void clearCurrentPositionLatitude();

    /**
     * Checks whether the field "CurrentPositionLatitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentPositionLatitude()). Otherwise it will return false.
     */
    inline bool hasCurrentPositionLatitude () const;

    /**
     * Returns the value of the member "CurrentPositionLatitude".
     *
     * Latitude of starting point of route calculation.
     *
     * @return The value of the field "CurrentPositionLatitude"
     */
    inline int32 getCurrentPositionLatitude () const;

    /**
     * Sets the value of the member "CurrentPositionLatitude".
     *
     * Latitude of starting point of route calculation.
     *
     * @param CurrentPositionLatitude The value which will be set
     */
    inline void setCurrentPositionLatitude (int32 CurrentPositionLatitude_);

    // API of field "DestinationLongitude"

    static const int kDestinationLongitude = 2;

    /**
     * Clears the field "DestinationLongitude".
     *
     * The field will be set to its default value. The hasDestinationLongitude()
     * method will return false.
     */
    inline void clearDestinationLongitude();

    /**
     * Checks whether the field "DestinationLongitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestinationLongitude()). Otherwise it will return false.
     */
    inline bool hasDestinationLongitude () const;

    /**
     * Returns the value of the member "DestinationLongitude".
     *
     * Longitude of destination of route calculation.
     *
     * @return The value of the field "DestinationLongitude"
     */
    inline int32 getDestinationLongitude () const;

    /**
     * Sets the value of the member "DestinationLongitude".
     *
     * Longitude of destination of route calculation.
     *
     * @param DestinationLongitude The value which will be set
     */
    inline void setDestinationLongitude (int32 DestinationLongitude_);

    // API of field "DestinationLatitude"

    static const int kDestinationLatitude = 3;

    /**
     * Clears the field "DestinationLatitude".
     *
     * The field will be set to its default value. The hasDestinationLatitude()
     * method will return false.
     */
    inline void clearDestinationLatitude();

    /**
     * Checks whether the field "DestinationLatitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestinationLatitude()). Otherwise it will return false.
     */
    inline bool hasDestinationLatitude () const;

    /**
     * Returns the value of the member "DestinationLatitude".
     *
     * Latitude of starting point of route calculation.
     *
     * @return The value of the field "DestinationLatitude"
     */
    inline int32 getDestinationLatitude () const;

    /**
     * Sets the value of the member "DestinationLatitude".
     *
     * Latitude of starting point of route calculation.
     *
     * @param DestinationLatitude The value which will be set
     */
    inline void setDestinationLatitude (int32 DestinationLatitude_);

    // API of field "RouteIndex"

    static const int kRouteIndex = 4;

    /**
     * Clears the field "RouteIndex".
     *
     * The field will be set to its default value. The hasRouteIndex()
     * method will return false.
     */
    inline void clearRouteIndex();

    /**
     * Checks whether the field "RouteIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteIndex()). Otherwise it will return false.
     */
    inline bool hasRouteIndex () const;

    /**
     * Returns the value of the member "RouteIndex".
     *
     * RFFU, must always be set to 1.
     *
     * @return The value of the field "RouteIndex"
     */
    inline uint8 getRouteIndex () const;

    /**
     * Sets the value of the member "RouteIndex".
     *
     * RFFU, must always be set to 1.
     *
     * @param RouteIndex The value which will be set
     */
    inline void setRouteIndex (uint8 RouteIndex_);

    // API of field "RouteOptimisation"

    static const int kRouteOptimisation = 5;

    /**
     * Clears the field "RouteOptimisation".
     *
     * The field will be set to its default value. The hasRouteOptimisation()
     * method will return false.
     */
    inline void clearRouteOptimisation();

    /**
     * Checks whether the field "RouteOptimisation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteOptimisation()). Otherwise it will return false.
     */
    inline bool hasRouteOptimisation () const;

    /**
     * Returns the value of the member "RouteOptimisation".
     *
     * A percentage value (0-100) that specifies the route optimization. 0 = shortest, 100= fastest.
     *
     * @return The value of the field "RouteOptimisation"
     */
    inline uint8 getRouteOptimisation () const;

    /**
     * Sets the value of the member "RouteOptimisation".
     *
     * A percentage value (0-100) that specifies the route optimization. 0 = shortest, 100= fastest.
     *
     * @param RouteOptimisation The value which will be set
     */
    inline void setRouteOptimisation (uint8 RouteOptimisation_);

    // API of field "Command"

    static const int kCommand = 6;

    /**
     * Clears the field "Command".
     *
     * The field will be set to its default value. The hasCommand()
     * method will return false.
     */
    inline void clearCommand();

    /**
     * Checks whether the field "Command" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCommand()). Otherwise it will return false.
     */
    inline bool hasCommand () const;

    /**
     * Returns the value of the member "Command".
     *
     * Set positions and/or start route calculation.
     *
     * @return The value of the field "Command"
     */
    inline T_e8_RouteCalculationCommand getCommand () const;

    /**
     * Sets the value of the member "Command".
     *
     * Set positions and/or start route calculation.
     *
     * @param Command The value which will be set
     */
    inline void setCommand (T_e8_RouteCalculationCommand Command_);

    static const T_RouteCalculationStartParameter &getDefaultInstance();

private:

    inline void set_has_CurrentPositionLongitude ();

    inline void clear_has_CurrentPositionLongitude ();

    inline void set_has_CurrentPositionLatitude ();

    inline void clear_has_CurrentPositionLatitude ();

    inline void set_has_DestinationLongitude ();

    inline void clear_has_DestinationLongitude ();

    inline void set_has_DestinationLatitude ();

    inline void clear_has_DestinationLatitude ();

    inline void set_has_RouteIndex ();

    inline void clear_has_RouteIndex ();

    inline void set_has_RouteOptimisation ();

    inline void clear_has_RouteOptimisation ();

    inline void set_has_Command ();

    inline void clear_has_Command ();

    uint32 _has_bits_[ (7 + 31) / 32];

    int32 _CurrentPositionLongitude;

    int32 _CurrentPositionLatitude;

    int32 _DestinationLongitude;

    int32 _DestinationLatitude;

    uint8 _RouteIndex;

    uint8 _RouteOptimisation;

    T_e8_RouteCalculationCommand _Command;

};

/**
 * If the meaning of "T_RouteCalculationResultParameter" isn't clear, then there should be a description here.
 */
class T_RouteCalculationResultParameter {
public:

    /**
     * Default constructor
     */
    inline  T_RouteCalculationResultParameter ();

    /**
     * Copy constructor
     */
    inline  T_RouteCalculationResultParameter (const T_RouteCalculationResultParameter &rhs);

    /**
     * All fields constructor
     */
    inline  T_RouteCalculationResultParameter (int32 CurrentPositionLongitude_, int32 CurrentPositionLatitude_, int32 DestinationLongitude_, int32 DestinationLatitude_, uint8 RouteIndex_, uint8 RouteOptimisation_, T_e8_RouteCalculationCommand Command_, T_e8_RouteCalculationStatus RouteCalculationStatus_, uint32 RouteLength_, uint32 RouteDuration_);

    /**
     * Destructor
     */
    inline  ~T_RouteCalculationResultParameter();

    /**
     * Assignment operator
     */
    inline T_RouteCalculationResultParameter& operator = (const T_RouteCalculationResultParameter& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_RouteCalculationResultParameter& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_RouteCalculationResultParameter& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_RouteCalculationResultParameter& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_RouteCalculationResultParameter& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CurrentPositionLongitude"

    static const int kCurrentPositionLongitude = 0;

    /**
     * Clears the field "CurrentPositionLongitude".
     *
     * The field will be set to its default value. The hasCurrentPositionLongitude()
     * method will return false.
     */
    inline void clearCurrentPositionLongitude();

    /**
     * Checks whether the field "CurrentPositionLongitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentPositionLongitude()). Otherwise it will return false.
     */
    inline bool hasCurrentPositionLongitude () const;

    /**
     * Returns the value of the member "CurrentPositionLongitude".
     *
     * Longitude of starting point of route calculation.
     *
     * @return The value of the field "CurrentPositionLongitude"
     */
    inline int32 getCurrentPositionLongitude () const;

    /**
     * Sets the value of the member "CurrentPositionLongitude".
     *
     * Longitude of starting point of route calculation.
     *
     * @param CurrentPositionLongitude The value which will be set
     */
    inline void setCurrentPositionLongitude (int32 CurrentPositionLongitude_);

    // API of field "CurrentPositionLatitude"

    static const int kCurrentPositionLatitude = 1;

    /**
     * Clears the field "CurrentPositionLatitude".
     *
     * The field will be set to its default value. The hasCurrentPositionLatitude()
     * method will return false.
     */
    inline void clearCurrentPositionLatitude();

    /**
     * Checks whether the field "CurrentPositionLatitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentPositionLatitude()). Otherwise it will return false.
     */
    inline bool hasCurrentPositionLatitude () const;

    /**
     * Returns the value of the member "CurrentPositionLatitude".
     *
     * Latitude of starting point of route calculation.
     *
     * @return The value of the field "CurrentPositionLatitude"
     */
    inline int32 getCurrentPositionLatitude () const;

    /**
     * Sets the value of the member "CurrentPositionLatitude".
     *
     * Latitude of starting point of route calculation.
     *
     * @param CurrentPositionLatitude The value which will be set
     */
    inline void setCurrentPositionLatitude (int32 CurrentPositionLatitude_);

    // API of field "DestinationLongitude"

    static const int kDestinationLongitude = 2;

    /**
     * Clears the field "DestinationLongitude".
     *
     * The field will be set to its default value. The hasDestinationLongitude()
     * method will return false.
     */
    inline void clearDestinationLongitude();

    /**
     * Checks whether the field "DestinationLongitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestinationLongitude()). Otherwise it will return false.
     */
    inline bool hasDestinationLongitude () const;

    /**
     * Returns the value of the member "DestinationLongitude".
     *
     * Longitude of destination of route calculation.
     *
     * @return The value of the field "DestinationLongitude"
     */
    inline int32 getDestinationLongitude () const;

    /**
     * Sets the value of the member "DestinationLongitude".
     *
     * Longitude of destination of route calculation.
     *
     * @param DestinationLongitude The value which will be set
     */
    inline void setDestinationLongitude (int32 DestinationLongitude_);

    // API of field "DestinationLatitude"

    static const int kDestinationLatitude = 3;

    /**
     * Clears the field "DestinationLatitude".
     *
     * The field will be set to its default value. The hasDestinationLatitude()
     * method will return false.
     */
    inline void clearDestinationLatitude();

    /**
     * Checks whether the field "DestinationLatitude" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestinationLatitude()). Otherwise it will return false.
     */
    inline bool hasDestinationLatitude () const;

    /**
     * Returns the value of the member "DestinationLatitude".
     *
     * Latitude of starting point of route calculation.
     *
     * @return The value of the field "DestinationLatitude"
     */
    inline int32 getDestinationLatitude () const;

    /**
     * Sets the value of the member "DestinationLatitude".
     *
     * Latitude of starting point of route calculation.
     *
     * @param DestinationLatitude The value which will be set
     */
    inline void setDestinationLatitude (int32 DestinationLatitude_);

    // API of field "RouteIndex"

    static const int kRouteIndex = 4;

    /**
     * Clears the field "RouteIndex".
     *
     * The field will be set to its default value. The hasRouteIndex()
     * method will return false.
     */
    inline void clearRouteIndex();

    /**
     * Checks whether the field "RouteIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteIndex()). Otherwise it will return false.
     */
    inline bool hasRouteIndex () const;

    /**
     * Returns the value of the member "RouteIndex".
     *
     * RFFU, must always be set to 1.
     *
     * @return The value of the field "RouteIndex"
     */
    inline uint8 getRouteIndex () const;

    /**
     * Sets the value of the member "RouteIndex".
     *
     * RFFU, must always be set to 1.
     *
     * @param RouteIndex The value which will be set
     */
    inline void setRouteIndex (uint8 RouteIndex_);

    // API of field "RouteOptimisation"

    static const int kRouteOptimisation = 5;

    /**
     * Clears the field "RouteOptimisation".
     *
     * The field will be set to its default value. The hasRouteOptimisation()
     * method will return false.
     */
    inline void clearRouteOptimisation();

    /**
     * Checks whether the field "RouteOptimisation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteOptimisation()). Otherwise it will return false.
     */
    inline bool hasRouteOptimisation () const;

    /**
     * Returns the value of the member "RouteOptimisation".
     *
     * A percentage value (0-100) that specifies the route optimization. 0 = shortest, 100= fastest.
     *
     * @return The value of the field "RouteOptimisation"
     */
    inline uint8 getRouteOptimisation () const;

    /**
     * Sets the value of the member "RouteOptimisation".
     *
     * A percentage value (0-100) that specifies the route optimization. 0 = shortest, 100= fastest.
     *
     * @param RouteOptimisation The value which will be set
     */
    inline void setRouteOptimisation (uint8 RouteOptimisation_);

    // API of field "Command"

    static const int kCommand = 6;

    /**
     * Clears the field "Command".
     *
     * The field will be set to its default value. The hasCommand()
     * method will return false.
     */
    inline void clearCommand();

    /**
     * Checks whether the field "Command" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCommand()). Otherwise it will return false.
     */
    inline bool hasCommand () const;

    /**
     * Returns the value of the member "Command".
     *
     * Set positions and/or start route calculation.
     *
     * @return The value of the field "Command"
     */
    inline T_e8_RouteCalculationCommand getCommand () const;

    /**
     * Sets the value of the member "Command".
     *
     * Set positions and/or start route calculation.
     *
     * @param Command The value which will be set
     */
    inline void setCommand (T_e8_RouteCalculationCommand Command_);

    // API of field "RouteCalculationStatus"

    static const int kRouteCalculationStatus = 7;

    /**
     * Clears the field "RouteCalculationStatus".
     *
     * The field will be set to its default value. The hasRouteCalculationStatus()
     * method will return false.
     */
    inline void clearRouteCalculationStatus();

    /**
     * Checks whether the field "RouteCalculationStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteCalculationStatus()). Otherwise it will return false.
     */
    inline bool hasRouteCalculationStatus () const;

    /**
     * Returns the value of the member "RouteCalculationStatus".
     *
     * Status of the actual route calculation.
     *
     * @return The value of the field "RouteCalculationStatus"
     */
    inline T_e8_RouteCalculationStatus getRouteCalculationStatus () const;

    /**
     * Sets the value of the member "RouteCalculationStatus".
     *
     * Status of the actual route calculation.
     *
     * @param RouteCalculationStatus The value which will be set
     */
    inline void setRouteCalculationStatus (T_e8_RouteCalculationStatus RouteCalculationStatus_);

    // API of field "RouteLength"

    static const int kRouteLength = 8;

    /**
     * Clears the field "RouteLength".
     *
     * The field will be set to its default value. The hasRouteLength()
     * method will return false.
     */
    inline void clearRouteLength();

    /**
     * Checks whether the field "RouteLength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteLength()). Otherwise it will return false.
     */
    inline bool hasRouteLength () const;

    /**
     * Returns the value of the member "RouteLength".
     *
     * Length of the route calculation in metres.
     *
     * @return The value of the field "RouteLength"
     */
    inline uint32 getRouteLength () const;

    /**
     * Sets the value of the member "RouteLength".
     *
     * Length of the route calculation in metres.
     *
     * @param RouteLength The value which will be set
     */
    inline void setRouteLength (uint32 RouteLength_);

    // API of field "RouteDuration"

    static const int kRouteDuration = 9;

    /**
     * Clears the field "RouteDuration".
     *
     * The field will be set to its default value. The hasRouteDuration()
     * method will return false.
     */
    inline void clearRouteDuration();

    /**
     * Checks whether the field "RouteDuration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRouteDuration()). Otherwise it will return false.
     */
    inline bool hasRouteDuration () const;

    /**
     * Returns the value of the member "RouteDuration".
     *
     * Duration of the route calculation in seconds.
     *
     * @return The value of the field "RouteDuration"
     */
    inline uint32 getRouteDuration () const;

    /**
     * Sets the value of the member "RouteDuration".
     *
     * Duration of the route calculation in seconds.
     *
     * @param RouteDuration The value which will be set
     */
    inline void setRouteDuration (uint32 RouteDuration_);

    static const T_RouteCalculationResultParameter &getDefaultInstance();

private:

    inline void set_has_CurrentPositionLongitude ();

    inline void clear_has_CurrentPositionLongitude ();

    inline void set_has_CurrentPositionLatitude ();

    inline void clear_has_CurrentPositionLatitude ();

    inline void set_has_DestinationLongitude ();

    inline void clear_has_DestinationLongitude ();

    inline void set_has_DestinationLatitude ();

    inline void clear_has_DestinationLatitude ();

    inline void set_has_RouteIndex ();

    inline void clear_has_RouteIndex ();

    inline void set_has_RouteOptimisation ();

    inline void clear_has_RouteOptimisation ();

    inline void set_has_Command ();

    inline void clear_has_Command ();

    inline void set_has_RouteCalculationStatus ();

    inline void clear_has_RouteCalculationStatus ();

    inline void set_has_RouteLength ();

    inline void clear_has_RouteLength ();

    inline void set_has_RouteDuration ();

    inline void clear_has_RouteDuration ();

    uint32 _has_bits_[ (10 + 31) / 32];

    int32 _CurrentPositionLongitude;

    int32 _CurrentPositionLatitude;

    int32 _DestinationLongitude;

    int32 _DestinationLatitude;

    uint8 _RouteIndex;

    uint8 _RouteOptimisation;

    T_e8_RouteCalculationCommand _Command;

    T_e8_RouteCalculationStatus _RouteCalculationStatus;

    uint32 _RouteLength;

    uint32 _RouteDuration;

};

/**
 * If the meaning of "T_CalibrationTimeStamp" isn't clear, then there should be a description here.
 */
class T_CalibrationTimeStamp {
public:

    /**
     * Default constructor
     */
    inline  T_CalibrationTimeStamp ();

    /**
     * Copy constructor
     */
    inline  T_CalibrationTimeStamp (const T_CalibrationTimeStamp &rhs);

    /**
     * All fields constructor
     */
    inline  T_CalibrationTimeStamp (uint8 Hours_, uint8 Minutes_, uint8 Seconds_, uint8 Day_, uint8 Month_, uint8 Year_);

    /**
     * Destructor
     */
    inline  ~T_CalibrationTimeStamp();

    /**
     * Assignment operator
     */
    inline T_CalibrationTimeStamp& operator = (const T_CalibrationTimeStamp& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_CalibrationTimeStamp& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_CalibrationTimeStamp& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_CalibrationTimeStamp& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_CalibrationTimeStamp& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Hours"

    static const int kHours = 0;

    /**
     * Clears the field "Hours".
     *
     * The field will be set to its default value. The hasHours()
     * method will return false.
     */
    inline void clearHours();

    /**
     * Checks whether the field "Hours" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHours()). Otherwise it will return false.
     */
    inline bool hasHours () const;

    /**
     * Returns the value of the member "Hours".
     *
     * Time Stamp of Last Interaction - Local Time of day in Hours.
     * Range: 0 - 23
     * Default: 0
     *
     * @return The value of the field "Hours"
     */
    inline uint8 getHours () const;

    /**
     * Sets the value of the member "Hours".
     *
     * Time Stamp of Last Interaction - Local Time of day in Hours.
     * Range: 0 - 23
     * Default: 0
     *
     * @param Hours The value which will be set
     */
    inline void setHours (uint8 Hours_);

    // API of field "Minutes"

    static const int kMinutes = 1;

    /**
     * Clears the field "Minutes".
     *
     * The field will be set to its default value. The hasMinutes()
     * method will return false.
     */
    inline void clearMinutes();

    /**
     * Checks whether the field "Minutes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMinutes()). Otherwise it will return false.
     */
    inline bool hasMinutes () const;

    /**
     * Returns the value of the member "Minutes".
     *
     * Time Stamp of Last Interaction - Local Time of day in Minutes.
     * Range: 0 - 59
     * Default: 0
     *
     * @return The value of the field "Minutes"
     */
    inline uint8 getMinutes () const;

    /**
     * Sets the value of the member "Minutes".
     *
     * Time Stamp of Last Interaction - Local Time of day in Minutes.
     * Range: 0 - 59
     * Default: 0
     *
     * @param Minutes The value which will be set
     */
    inline void setMinutes (uint8 Minutes_);

    // API of field "Seconds"

    static const int kSeconds = 2;

    /**
     * Clears the field "Seconds".
     *
     * The field will be set to its default value. The hasSeconds()
     * method will return false.
     */
    inline void clearSeconds();

    /**
     * Checks whether the field "Seconds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSeconds()). Otherwise it will return false.
     */
    inline bool hasSeconds () const;

    /**
     * Returns the value of the member "Seconds".
     *
     * Time Stamp of Last Interaction - Local Time of day in Seconds.
     * Range: 0 - 59
     * Default: 0
     *
     * @return The value of the field "Seconds"
     */
    inline uint8 getSeconds () const;

    /**
     * Sets the value of the member "Seconds".
     *
     * Time Stamp of Last Interaction - Local Time of day in Seconds.
     * Range: 0 - 59
     * Default: 0
     *
     * @param Seconds The value which will be set
     */
    inline void setSeconds (uint8 Seconds_);

    // API of field "Day"

    static const int kDay = 3;

    /**
     * Clears the field "Day".
     *
     * The field will be set to its default value. The hasDay()
     * method will return false.
     */
    inline void clearDay();

    /**
     * Checks whether the field "Day" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDay()). Otherwise it will return false.
     */
    inline bool hasDay () const;

    /**
     * Returns the value of the member "Day".
     *
     * Time Stamp of Last Interaction - Local Calendar Day.
     * Range: 0 - 31
     * Default: 0
     *
     * @return The value of the field "Day"
     */
    inline uint8 getDay () const;

    /**
     * Sets the value of the member "Day".
     *
     * Time Stamp of Last Interaction - Local Calendar Day.
     * Range: 0 - 31
     * Default: 0
     *
     * @param Day The value which will be set
     */
    inline void setDay (uint8 Day_);

    // API of field "Month"

    static const int kMonth = 4;

    /**
     * Clears the field "Month".
     *
     * The field will be set to its default value. The hasMonth()
     * method will return false.
     */
    inline void clearMonth();

    /**
     * Checks whether the field "Month" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMonth()). Otherwise it will return false.
     */
    inline bool hasMonth () const;

    /**
     * Returns the value of the member "Month".
     *
     * Time Stamp of Last Interaction - Local Calendar Month.
     * Range: 0 - 12
     *
     * @return The value of the field "Month"
     */
    inline uint8 getMonth () const;

    /**
     * Sets the value of the member "Month".
     *
     * Time Stamp of Last Interaction - Local Calendar Month.
     * Range: 0 - 12
     *
     * @param Month The value which will be set
     */
    inline void setMonth (uint8 Month_);

    // API of field "Year"

    static const int kYear = 5;

    /**
     * Clears the field "Year".
     *
     * The field will be set to its default value. The hasYear()
     * method will return false.
     */
    inline void clearYear();

    /**
     * Checks whether the field "Year" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setYear()). Otherwise it will return false.
     */
    inline bool hasYear () const;

    /**
     * Returns the value of the member "Year".
     *
     * Time Stamp of Last Interaction - Local Calendar Year.
     * Range: 2000 - 2255
     * Scaling: E = N*1 + 2000
     * Default: 0
     *
     * @return The value of the field "Year"
     */
    inline uint8 getYear () const;

    /**
     * Sets the value of the member "Year".
     *
     * Time Stamp of Last Interaction - Local Calendar Year.
     * Range: 2000 - 2255
     * Scaling: E = N*1 + 2000
     * Default: 0
     *
     * @param Year The value which will be set
     */
    inline void setYear (uint8 Year_);

    static const T_CalibrationTimeStamp &getDefaultInstance();

private:

    inline void set_has_Hours ();

    inline void clear_has_Hours ();

    inline void set_has_Minutes ();

    inline void clear_has_Minutes ();

    inline void set_has_Seconds ();

    inline void clear_has_Seconds ();

    inline void set_has_Day ();

    inline void clear_has_Day ();

    inline void set_has_Month ();

    inline void clear_has_Month ();

    inline void set_has_Year ();

    inline void clear_has_Year ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint8 _Hours;

    uint8 _Minutes;

    uint8 _Seconds;

    uint8 _Day;

    uint8 _Month;

    uint8 _Year;

};

inline  T_DisplayData::T_DisplayData ()  :
    _TestScreen (::midw_diagnostics_fi_types::T_e8_TestScreens__Undefined),
    _DisplayStrings ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DisplayData::T_DisplayData (const T_DisplayData &rhs)  :
    _TestScreen (::midw_diagnostics_fi_types::T_e8_TestScreens__Undefined),
    _DisplayStrings ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DisplayData::T_DisplayData (T_e8_TestScreens TestScreen_, const T_DisplayStringsList& DisplayStrings_)  :
    _TestScreen (TestScreen_),
    _DisplayStrings (DisplayStrings_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_TestScreens_IsValid(TestScreen_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", TestScreen_, "T_e8_TestScreens", "TestScreen", "T_DisplayData");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DisplayData::~T_DisplayData() {
}

inline T_DisplayData& T_DisplayData::operator = (const T_DisplayData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTestScreen()) {
            setTestScreen(rhs.getTestScreen());
        } else {
            clearTestScreen();
        }
        if (rhs.hasDisplayStrings()) {
            setDisplayStrings(rhs.getDisplayStrings());
        } else {
            clearDisplayStrings();
        }
    }
    return *this;
}

inline bool T_DisplayData::operator == (const T_DisplayData& rhs) const {
    return (((!hasTestScreen() && !rhs.hasTestScreen()) || getTestScreen() == rhs.getTestScreen()) &&
        ((!hasDisplayStrings() && !rhs.hasDisplayStrings()) || getDisplayStrings() == rhs.getDisplayStrings()));
}

inline bool T_DisplayData::operator != (const T_DisplayData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DisplayData::operator < (const T_DisplayData& rhs) const {
    if (hasTestScreen() || rhs.hasTestScreen()) {
        if ((uint32)getTestScreen() < (uint32)rhs.getTestScreen()) return true;
        if ((uint32)getTestScreen() > (uint32)rhs.getTestScreen()) return false;
    }
    if (hasDisplayStrings() || rhs.hasDisplayStrings()) {
        if (getDisplayStrings() < rhs.getDisplayStrings()) return true;
        if (getDisplayStrings() > rhs.getDisplayStrings()) return false;
    }
    return false;
}

inline bool T_DisplayData::operator > (const T_DisplayData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DisplayData::clear() {
    clearTestScreen();
    clearDisplayStrings();
}

inline void T_DisplayData::clearTestScreen() {
    if (hasTestScreen()) {
         clear_has_TestScreen();
        _TestScreen = ::midw_diagnostics_fi_types::T_e8_TestScreens__Undefined;
     }
}

inline bool T_DisplayData::hasTestScreen () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_TestScreens T_DisplayData::getTestScreen () const {
    return _TestScreen;
}

inline void T_DisplayData::setTestScreen (T_e8_TestScreens TestScreen_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_TestScreens_IsValid(TestScreen_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", TestScreen_, "T_e8_TestScreens", "TestScreen", "T_DisplayData");
    }
    set_has_TestScreen();
    this->_TestScreen = TestScreen_;
}

inline void T_DisplayData::clearDisplayStrings() {
    if (hasDisplayStrings()) {
         clear_has_DisplayStrings();
        _DisplayStrings.clear();
     }
}

inline bool T_DisplayData::hasDisplayStrings () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_DisplayStringsList& T_DisplayData::getDisplayStrings () const {
    return _DisplayStrings;
}

inline T_DisplayStringsList& T_DisplayData::getDisplayStringsMutable () {
    set_has_DisplayStrings();
    return _DisplayStrings;
}

inline void T_DisplayData::setDisplayStrings (const T_DisplayStringsList& DisplayStrings_) {
    set_has_DisplayStrings();
    this->_DisplayStrings = DisplayStrings_;
}

inline void T_DisplayData::set_has_TestScreen () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DisplayData::clear_has_TestScreen () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DisplayData::set_has_DisplayStrings () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DisplayData::clear_has_DisplayStrings () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_CountryLanguage::T_CountryLanguage ()  :
    _Country (::midw_diagnostics_fi_types::T_e8_Country__Undefined),
    _Language (::midw_diagnostics_fi_types::T_e8_Language__Undefined),
    _Subsystem (::midw_diagnostics_fi_types::T_e8_LanguageSubsystem__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_CountryLanguage::T_CountryLanguage (const T_CountryLanguage &rhs)  :
    _Country (::midw_diagnostics_fi_types::T_e8_Country__Undefined),
    _Language (::midw_diagnostics_fi_types::T_e8_Language__Undefined),
    _Subsystem (::midw_diagnostics_fi_types::T_e8_LanguageSubsystem__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_CountryLanguage::T_CountryLanguage (T_e8_Country Country_, T_e8_Language Language_, T_e8_LanguageSubsystem Subsystem_)  :
    _Country (Country_),
    _Language (Language_),
    _Subsystem (Subsystem_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Country_IsValid(Country_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Country_, "T_e8_Country", "Country", "T_CountryLanguage");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Language_IsValid(Language_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Language_, "T_e8_Language", "Language", "T_CountryLanguage");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_LanguageSubsystem_IsValid(Subsystem_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Subsystem_, "T_e8_LanguageSubsystem", "Subsystem", "T_CountryLanguage");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_CountryLanguage::~T_CountryLanguage() {
}

inline T_CountryLanguage& T_CountryLanguage::operator = (const T_CountryLanguage& rhs) {
    if( this != &rhs ) {
        if (rhs.hasCountry()) {
            setCountry(rhs.getCountry());
        } else {
            clearCountry();
        }
        if (rhs.hasLanguage()) {
            setLanguage(rhs.getLanguage());
        } else {
            clearLanguage();
        }
        if (rhs.hasSubsystem()) {
            setSubsystem(rhs.getSubsystem());
        } else {
            clearSubsystem();
        }
    }
    return *this;
}

inline bool T_CountryLanguage::operator == (const T_CountryLanguage& rhs) const {
    return (((!hasCountry() && !rhs.hasCountry()) || getCountry() == rhs.getCountry()) &&
        ((!hasLanguage() && !rhs.hasLanguage()) || getLanguage() == rhs.getLanguage()) &&
        ((!hasSubsystem() && !rhs.hasSubsystem()) || getSubsystem() == rhs.getSubsystem()));
}

inline bool T_CountryLanguage::operator != (const T_CountryLanguage& rhs) const {
    return ! (*this == rhs);
}

inline bool T_CountryLanguage::operator < (const T_CountryLanguage& rhs) const {
    if (hasCountry() || rhs.hasCountry()) {
        if ((uint32)getCountry() < (uint32)rhs.getCountry()) return true;
        if ((uint32)getCountry() > (uint32)rhs.getCountry()) return false;
    }
    if (hasLanguage() || rhs.hasLanguage()) {
        if ((uint32)getLanguage() < (uint32)rhs.getLanguage()) return true;
        if ((uint32)getLanguage() > (uint32)rhs.getLanguage()) return false;
    }
    if (hasSubsystem() || rhs.hasSubsystem()) {
        if ((uint32)getSubsystem() < (uint32)rhs.getSubsystem()) return true;
        if ((uint32)getSubsystem() > (uint32)rhs.getSubsystem()) return false;
    }
    return false;
}

inline bool T_CountryLanguage::operator > (const T_CountryLanguage& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_CountryLanguage::clear() {
    clearCountry();
    clearLanguage();
    clearSubsystem();
}

inline void T_CountryLanguage::clearCountry() {
    if (hasCountry()) {
         clear_has_Country();
        _Country = ::midw_diagnostics_fi_types::T_e8_Country__Undefined;
     }
}

inline bool T_CountryLanguage::hasCountry () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_Country T_CountryLanguage::getCountry () const {
    return _Country;
}

inline void T_CountryLanguage::setCountry (T_e8_Country Country_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Country_IsValid(Country_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Country_, "T_e8_Country", "Country", "T_CountryLanguage");
    }
    set_has_Country();
    this->_Country = Country_;
}

inline void T_CountryLanguage::clearLanguage() {
    if (hasLanguage()) {
         clear_has_Language();
        _Language = ::midw_diagnostics_fi_types::T_e8_Language__Undefined;
     }
}

inline bool T_CountryLanguage::hasLanguage () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_Language T_CountryLanguage::getLanguage () const {
    return _Language;
}

inline void T_CountryLanguage::setLanguage (T_e8_Language Language_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Language_IsValid(Language_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Language_, "T_e8_Language", "Language", "T_CountryLanguage");
    }
    set_has_Language();
    this->_Language = Language_;
}

inline void T_CountryLanguage::clearSubsystem() {
    if (hasSubsystem()) {
         clear_has_Subsystem();
        _Subsystem = ::midw_diagnostics_fi_types::T_e8_LanguageSubsystem__Undefined;
     }
}

inline bool T_CountryLanguage::hasSubsystem () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_LanguageSubsystem T_CountryLanguage::getSubsystem () const {
    return _Subsystem;
}

inline void T_CountryLanguage::setSubsystem (T_e8_LanguageSubsystem Subsystem_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_LanguageSubsystem_IsValid(Subsystem_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Subsystem_, "T_e8_LanguageSubsystem", "Subsystem", "T_CountryLanguage");
    }
    set_has_Subsystem();
    this->_Subsystem = Subsystem_;
}

inline void T_CountryLanguage::set_has_Country () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_CountryLanguage::clear_has_Country () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_CountryLanguage::set_has_Language () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_CountryLanguage::clear_has_Language () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_CountryLanguage::set_has_Subsystem () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_CountryLanguage::clear_has_Subsystem () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_CountryLanguageResult::T_CountryLanguageResult ()  :
    _Success (false),
    _CountryLanguageList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_CountryLanguageResult::T_CountryLanguageResult (const T_CountryLanguageResult &rhs)  :
    _Success (false),
    _CountryLanguageList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_CountryLanguageResult::T_CountryLanguageResult (bool Success_, const ::std::vector< T_CountryLanguage >& CountryLanguageList_)  :
    _Success (Success_),
    _CountryLanguageList (CountryLanguageList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_CountryLanguageResult::~T_CountryLanguageResult() {
}

inline T_CountryLanguageResult& T_CountryLanguageResult::operator = (const T_CountryLanguageResult& rhs) {
    if( this != &rhs ) {
        if (rhs.hasSuccess()) {
            setSuccess(rhs.getSuccess());
        } else {
            clearSuccess();
        }
        if (rhs.hasCountryLanguageList()) {
            setCountryLanguageList(rhs.getCountryLanguageList());
        } else {
            clearCountryLanguageList();
        }
    }
    return *this;
}

inline bool T_CountryLanguageResult::operator == (const T_CountryLanguageResult& rhs) const {
    return (((!hasSuccess() && !rhs.hasSuccess()) || getSuccess() == rhs.getSuccess()) &&
        ((!hasCountryLanguageList() && !rhs.hasCountryLanguageList()) || getCountryLanguageList() == rhs.getCountryLanguageList()));
}

inline bool T_CountryLanguageResult::operator != (const T_CountryLanguageResult& rhs) const {
    return ! (*this == rhs);
}

inline bool T_CountryLanguageResult::operator < (const T_CountryLanguageResult& rhs) const {
    if (hasSuccess() || rhs.hasSuccess()) {
        if (getSuccess() < rhs.getSuccess()) return true;
        if (getSuccess() > rhs.getSuccess()) return false;
    }
    if (hasCountryLanguageList() || rhs.hasCountryLanguageList()) {
        if (getCountryLanguageList() < rhs.getCountryLanguageList()) return true;
        if (getCountryLanguageList() > rhs.getCountryLanguageList()) return false;
    }
    return false;
}

inline bool T_CountryLanguageResult::operator > (const T_CountryLanguageResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_CountryLanguageResult::clear() {
    clearSuccess();
    clearCountryLanguageList();
}

inline void T_CountryLanguageResult::clearSuccess() {
    if (hasSuccess()) {
         clear_has_Success();
        _Success = false;
     }
}

inline bool T_CountryLanguageResult::hasSuccess () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_CountryLanguageResult::getSuccess () const {
    return _Success;
}

inline void T_CountryLanguageResult::setSuccess (bool Success_) {
    set_has_Success();
    this->_Success = Success_;
}

inline void T_CountryLanguageResult::clearCountryLanguageList() {
    if (hasCountryLanguageList()) {
         clear_has_CountryLanguageList();
        _CountryLanguageList.clear();
     }
}

inline bool T_CountryLanguageResult::hasCountryLanguageList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< T_CountryLanguage >& T_CountryLanguageResult::getCountryLanguageList () const {
    return _CountryLanguageList;
}

inline ::std::vector< T_CountryLanguage >& T_CountryLanguageResult::getCountryLanguageListMutable () {
    set_has_CountryLanguageList();
    return _CountryLanguageList;
}

inline void T_CountryLanguageResult::setCountryLanguageList (const ::std::vector< T_CountryLanguage >& CountryLanguageList_) {
    set_has_CountryLanguageList();
    this->_CountryLanguageList = CountryLanguageList_;
}

inline void T_CountryLanguageResult::set_has_Success () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_CountryLanguageResult::clear_has_Success () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_CountryLanguageResult::set_has_CountryLanguageList () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_CountryLanguageResult::clear_has_CountryLanguageList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_TroubleCode::T_TroubleCode ()  :
    _TroubleCode (0u),
    _Status (::midw_diagnostics_fi_types::T_e8_TroubleCodeStatus__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TroubleCode::T_TroubleCode (const T_TroubleCode &rhs)  :
    _TroubleCode (0u),
    _Status (::midw_diagnostics_fi_types::T_e8_TroubleCodeStatus__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TroubleCode::T_TroubleCode (uint32 TroubleCode_, T_e8_TroubleCodeStatus Status_)  :
    _TroubleCode (TroubleCode_),
    _Status (Status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_TroubleCodeStatus_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_TroubleCodeStatus", "Status", "T_TroubleCode");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TroubleCode::~T_TroubleCode() {
}

inline T_TroubleCode& T_TroubleCode::operator = (const T_TroubleCode& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTroubleCode()) {
            setTroubleCode(rhs.getTroubleCode());
        } else {
            clearTroubleCode();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool T_TroubleCode::operator == (const T_TroubleCode& rhs) const {
    return (((!hasTroubleCode() && !rhs.hasTroubleCode()) || getTroubleCode() == rhs.getTroubleCode()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool T_TroubleCode::operator != (const T_TroubleCode& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TroubleCode::operator < (const T_TroubleCode& rhs) const {
    if (hasTroubleCode() || rhs.hasTroubleCode()) {
        if (getTroubleCode() < rhs.getTroubleCode()) return true;
        if (getTroubleCode() > rhs.getTroubleCode()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline bool T_TroubleCode::operator > (const T_TroubleCode& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TroubleCode::clear() {
    clearTroubleCode();
    clearStatus();
}

inline void T_TroubleCode::clearTroubleCode() {
    if (hasTroubleCode()) {
         clear_has_TroubleCode();
        _TroubleCode = 0u;
     }
}

inline bool T_TroubleCode::hasTroubleCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_TroubleCode::getTroubleCode () const {
    return _TroubleCode;
}

inline void T_TroubleCode::setTroubleCode (uint32 TroubleCode_) {
    set_has_TroubleCode();
    this->_TroubleCode = TroubleCode_;
}

inline void T_TroubleCode::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::midw_diagnostics_fi_types::T_e8_TroubleCodeStatus__Undefined;
     }
}

inline bool T_TroubleCode::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_TroubleCodeStatus T_TroubleCode::getStatus () const {
    return _Status;
}

inline void T_TroubleCode::setStatus (T_e8_TroubleCodeStatus Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_TroubleCodeStatus_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_TroubleCodeStatus", "Status", "T_TroubleCode");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void T_TroubleCode::set_has_TroubleCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TroubleCode::clear_has_TroubleCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TroubleCode::set_has_Status () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TroubleCode::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_RouteCalculationStartParameter::T_RouteCalculationStartParameter ()  :
    _CurrentPositionLongitude (0),
    _CurrentPositionLatitude (0),
    _DestinationLongitude (0),
    _DestinationLatitude (0),
    _RouteIndex (0u),
    _RouteOptimisation (0u),
    _Command (::midw_diagnostics_fi_types::T_e8_RouteCalculationCommand__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_RouteCalculationStartParameter::T_RouteCalculationStartParameter (const T_RouteCalculationStartParameter &rhs)  :
    _CurrentPositionLongitude (0),
    _CurrentPositionLatitude (0),
    _DestinationLongitude (0),
    _DestinationLatitude (0),
    _RouteIndex (0u),
    _RouteOptimisation (0u),
    _Command (::midw_diagnostics_fi_types::T_e8_RouteCalculationCommand__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_RouteCalculationStartParameter::T_RouteCalculationStartParameter (int32 CurrentPositionLongitude_, int32 CurrentPositionLatitude_, int32 DestinationLongitude_, int32 DestinationLatitude_, uint8 RouteIndex_, uint8 RouteOptimisation_, T_e8_RouteCalculationCommand Command_)  :
    _CurrentPositionLongitude (CurrentPositionLongitude_),
    _CurrentPositionLatitude (CurrentPositionLatitude_),
    _DestinationLongitude (DestinationLongitude_),
    _DestinationLatitude (DestinationLatitude_),
    _RouteIndex (RouteIndex_),
    _RouteOptimisation (RouteOptimisation_),
    _Command (Command_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_RouteCalculationCommand_IsValid(Command_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Command_, "T_e8_RouteCalculationCommand", "Command", "T_RouteCalculationStartParameter");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_RouteCalculationStartParameter::~T_RouteCalculationStartParameter() {
}

inline T_RouteCalculationStartParameter& T_RouteCalculationStartParameter::operator = (const T_RouteCalculationStartParameter& rhs) {
    if( this != &rhs ) {
        if (rhs.hasCurrentPositionLongitude()) {
            setCurrentPositionLongitude(rhs.getCurrentPositionLongitude());
        } else {
            clearCurrentPositionLongitude();
        }
        if (rhs.hasCurrentPositionLatitude()) {
            setCurrentPositionLatitude(rhs.getCurrentPositionLatitude());
        } else {
            clearCurrentPositionLatitude();
        }
        if (rhs.hasDestinationLongitude()) {
            setDestinationLongitude(rhs.getDestinationLongitude());
        } else {
            clearDestinationLongitude();
        }
        if (rhs.hasDestinationLatitude()) {
            setDestinationLatitude(rhs.getDestinationLatitude());
        } else {
            clearDestinationLatitude();
        }
        if (rhs.hasRouteIndex()) {
            setRouteIndex(rhs.getRouteIndex());
        } else {
            clearRouteIndex();
        }
        if (rhs.hasRouteOptimisation()) {
            setRouteOptimisation(rhs.getRouteOptimisation());
        } else {
            clearRouteOptimisation();
        }
        if (rhs.hasCommand()) {
            setCommand(rhs.getCommand());
        } else {
            clearCommand();
        }
    }
    return *this;
}

inline bool T_RouteCalculationStartParameter::operator == (const T_RouteCalculationStartParameter& rhs) const {
    return (((!hasCurrentPositionLongitude() && !rhs.hasCurrentPositionLongitude()) || getCurrentPositionLongitude() == rhs.getCurrentPositionLongitude()) &&
        ((!hasCurrentPositionLatitude() && !rhs.hasCurrentPositionLatitude()) || getCurrentPositionLatitude() == rhs.getCurrentPositionLatitude()) &&
        ((!hasDestinationLongitude() && !rhs.hasDestinationLongitude()) || getDestinationLongitude() == rhs.getDestinationLongitude()) &&
        ((!hasDestinationLatitude() && !rhs.hasDestinationLatitude()) || getDestinationLatitude() == rhs.getDestinationLatitude()) &&
        ((!hasRouteIndex() && !rhs.hasRouteIndex()) || getRouteIndex() == rhs.getRouteIndex()) &&
        ((!hasRouteOptimisation() && !rhs.hasRouteOptimisation()) || getRouteOptimisation() == rhs.getRouteOptimisation()) &&
        ((!hasCommand() && !rhs.hasCommand()) || getCommand() == rhs.getCommand()));
}

inline bool T_RouteCalculationStartParameter::operator != (const T_RouteCalculationStartParameter& rhs) const {
    return ! (*this == rhs);
}

inline bool T_RouteCalculationStartParameter::operator < (const T_RouteCalculationStartParameter& rhs) const {
    if (hasCurrentPositionLongitude() || rhs.hasCurrentPositionLongitude()) {
        if (getCurrentPositionLongitude() < rhs.getCurrentPositionLongitude()) return true;
        if (getCurrentPositionLongitude() > rhs.getCurrentPositionLongitude()) return false;
    }
    if (hasCurrentPositionLatitude() || rhs.hasCurrentPositionLatitude()) {
        if (getCurrentPositionLatitude() < rhs.getCurrentPositionLatitude()) return true;
        if (getCurrentPositionLatitude() > rhs.getCurrentPositionLatitude()) return false;
    }
    if (hasDestinationLongitude() || rhs.hasDestinationLongitude()) {
        if (getDestinationLongitude() < rhs.getDestinationLongitude()) return true;
        if (getDestinationLongitude() > rhs.getDestinationLongitude()) return false;
    }
    if (hasDestinationLatitude() || rhs.hasDestinationLatitude()) {
        if (getDestinationLatitude() < rhs.getDestinationLatitude()) return true;
        if (getDestinationLatitude() > rhs.getDestinationLatitude()) return false;
    }
    if (hasRouteIndex() || rhs.hasRouteIndex()) {
        if (getRouteIndex() < rhs.getRouteIndex()) return true;
        if (getRouteIndex() > rhs.getRouteIndex()) return false;
    }
    if (hasRouteOptimisation() || rhs.hasRouteOptimisation()) {
        if (getRouteOptimisation() < rhs.getRouteOptimisation()) return true;
        if (getRouteOptimisation() > rhs.getRouteOptimisation()) return false;
    }
    if (hasCommand() || rhs.hasCommand()) {
        if ((uint32)getCommand() < (uint32)rhs.getCommand()) return true;
        if ((uint32)getCommand() > (uint32)rhs.getCommand()) return false;
    }
    return false;
}

inline bool T_RouteCalculationStartParameter::operator > (const T_RouteCalculationStartParameter& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_RouteCalculationStartParameter::clear() {
    clearCurrentPositionLongitude();
    clearCurrentPositionLatitude();
    clearDestinationLongitude();
    clearDestinationLatitude();
    clearRouteIndex();
    clearRouteOptimisation();
    clearCommand();
}

inline void T_RouteCalculationStartParameter::clearCurrentPositionLongitude() {
    if (hasCurrentPositionLongitude()) {
         clear_has_CurrentPositionLongitude();
        _CurrentPositionLongitude = 0;
     }
}

inline bool T_RouteCalculationStartParameter::hasCurrentPositionLongitude () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 T_RouteCalculationStartParameter::getCurrentPositionLongitude () const {
    return _CurrentPositionLongitude;
}

inline void T_RouteCalculationStartParameter::setCurrentPositionLongitude (int32 CurrentPositionLongitude_) {
    set_has_CurrentPositionLongitude();
    this->_CurrentPositionLongitude = CurrentPositionLongitude_;
}

inline void T_RouteCalculationStartParameter::clearCurrentPositionLatitude() {
    if (hasCurrentPositionLatitude()) {
         clear_has_CurrentPositionLatitude();
        _CurrentPositionLatitude = 0;
     }
}

inline bool T_RouteCalculationStartParameter::hasCurrentPositionLatitude () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 T_RouteCalculationStartParameter::getCurrentPositionLatitude () const {
    return _CurrentPositionLatitude;
}

inline void T_RouteCalculationStartParameter::setCurrentPositionLatitude (int32 CurrentPositionLatitude_) {
    set_has_CurrentPositionLatitude();
    this->_CurrentPositionLatitude = CurrentPositionLatitude_;
}

inline void T_RouteCalculationStartParameter::clearDestinationLongitude() {
    if (hasDestinationLongitude()) {
         clear_has_DestinationLongitude();
        _DestinationLongitude = 0;
     }
}

inline bool T_RouteCalculationStartParameter::hasDestinationLongitude () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 T_RouteCalculationStartParameter::getDestinationLongitude () const {
    return _DestinationLongitude;
}

inline void T_RouteCalculationStartParameter::setDestinationLongitude (int32 DestinationLongitude_) {
    set_has_DestinationLongitude();
    this->_DestinationLongitude = DestinationLongitude_;
}

inline void T_RouteCalculationStartParameter::clearDestinationLatitude() {
    if (hasDestinationLatitude()) {
         clear_has_DestinationLatitude();
        _DestinationLatitude = 0;
     }
}

inline bool T_RouteCalculationStartParameter::hasDestinationLatitude () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline int32 T_RouteCalculationStartParameter::getDestinationLatitude () const {
    return _DestinationLatitude;
}

inline void T_RouteCalculationStartParameter::setDestinationLatitude (int32 DestinationLatitude_) {
    set_has_DestinationLatitude();
    this->_DestinationLatitude = DestinationLatitude_;
}

inline void T_RouteCalculationStartParameter::clearRouteIndex() {
    if (hasRouteIndex()) {
         clear_has_RouteIndex();
        _RouteIndex = 0u;
     }
}

inline bool T_RouteCalculationStartParameter::hasRouteIndex () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_RouteCalculationStartParameter::getRouteIndex () const {
    return _RouteIndex;
}

inline void T_RouteCalculationStartParameter::setRouteIndex (uint8 RouteIndex_) {
    set_has_RouteIndex();
    this->_RouteIndex = RouteIndex_;
}

inline void T_RouteCalculationStartParameter::clearRouteOptimisation() {
    if (hasRouteOptimisation()) {
         clear_has_RouteOptimisation();
        _RouteOptimisation = 0u;
     }
}

inline bool T_RouteCalculationStartParameter::hasRouteOptimisation () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_RouteCalculationStartParameter::getRouteOptimisation () const {
    return _RouteOptimisation;
}

inline void T_RouteCalculationStartParameter::setRouteOptimisation (uint8 RouteOptimisation_) {
    set_has_RouteOptimisation();
    this->_RouteOptimisation = RouteOptimisation_;
}

inline void T_RouteCalculationStartParameter::clearCommand() {
    if (hasCommand()) {
         clear_has_Command();
        _Command = ::midw_diagnostics_fi_types::T_e8_RouteCalculationCommand__Undefined;
     }
}

inline bool T_RouteCalculationStartParameter::hasCommand () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline T_e8_RouteCalculationCommand T_RouteCalculationStartParameter::getCommand () const {
    return _Command;
}

inline void T_RouteCalculationStartParameter::setCommand (T_e8_RouteCalculationCommand Command_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_RouteCalculationCommand_IsValid(Command_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Command_, "T_e8_RouteCalculationCommand", "Command", "T_RouteCalculationStartParameter");
    }
    set_has_Command();
    this->_Command = Command_;
}

inline void T_RouteCalculationStartParameter::set_has_CurrentPositionLongitude () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_RouteCalculationStartParameter::clear_has_CurrentPositionLongitude () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_RouteCalculationStartParameter::set_has_CurrentPositionLatitude () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_RouteCalculationStartParameter::clear_has_CurrentPositionLatitude () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_RouteCalculationStartParameter::set_has_DestinationLongitude () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_RouteCalculationStartParameter::clear_has_DestinationLongitude () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_RouteCalculationStartParameter::set_has_DestinationLatitude () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_RouteCalculationStartParameter::clear_has_DestinationLatitude () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_RouteCalculationStartParameter::set_has_RouteIndex () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_RouteCalculationStartParameter::clear_has_RouteIndex () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_RouteCalculationStartParameter::set_has_RouteOptimisation () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_RouteCalculationStartParameter::clear_has_RouteOptimisation () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_RouteCalculationStartParameter::set_has_Command () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_RouteCalculationStartParameter::clear_has_Command () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  T_RouteCalculationResultParameter::T_RouteCalculationResultParameter ()  :
    _CurrentPositionLongitude (0),
    _CurrentPositionLatitude (0),
    _DestinationLongitude (0),
    _DestinationLatitude (0),
    _RouteIndex (0u),
    _RouteOptimisation (0u),
    _Command (::midw_diagnostics_fi_types::T_e8_RouteCalculationCommand__Undefined),
    _RouteCalculationStatus (::midw_diagnostics_fi_types::T_e8_RouteCalculationStatus__Undefined),
    _RouteLength (0u),
    _RouteDuration (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_RouteCalculationResultParameter::T_RouteCalculationResultParameter (const T_RouteCalculationResultParameter &rhs)  :
    _CurrentPositionLongitude (0),
    _CurrentPositionLatitude (0),
    _DestinationLongitude (0),
    _DestinationLatitude (0),
    _RouteIndex (0u),
    _RouteOptimisation (0u),
    _Command (::midw_diagnostics_fi_types::T_e8_RouteCalculationCommand__Undefined),
    _RouteCalculationStatus (::midw_diagnostics_fi_types::T_e8_RouteCalculationStatus__Undefined),
    _RouteLength (0u),
    _RouteDuration (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_RouteCalculationResultParameter::T_RouteCalculationResultParameter (int32 CurrentPositionLongitude_, int32 CurrentPositionLatitude_, int32 DestinationLongitude_, int32 DestinationLatitude_, uint8 RouteIndex_, uint8 RouteOptimisation_, T_e8_RouteCalculationCommand Command_, T_e8_RouteCalculationStatus RouteCalculationStatus_, uint32 RouteLength_, uint32 RouteDuration_)  :
    _CurrentPositionLongitude (CurrentPositionLongitude_),
    _CurrentPositionLatitude (CurrentPositionLatitude_),
    _DestinationLongitude (DestinationLongitude_),
    _DestinationLatitude (DestinationLatitude_),
    _RouteIndex (RouteIndex_),
    _RouteOptimisation (RouteOptimisation_),
    _Command (Command_),
    _RouteCalculationStatus (RouteCalculationStatus_),
    _RouteLength (RouteLength_),
    _RouteDuration (RouteDuration_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_RouteCalculationCommand_IsValid(Command_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Command_, "T_e8_RouteCalculationCommand", "Command", "T_RouteCalculationResultParameter");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_RouteCalculationStatus_IsValid(RouteCalculationStatus_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", RouteCalculationStatus_, "T_e8_RouteCalculationStatus", "RouteCalculationStatus", "T_RouteCalculationResultParameter");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_RouteCalculationResultParameter::~T_RouteCalculationResultParameter() {
}

inline T_RouteCalculationResultParameter& T_RouteCalculationResultParameter::operator = (const T_RouteCalculationResultParameter& rhs) {
    if( this != &rhs ) {
        if (rhs.hasCurrentPositionLongitude()) {
            setCurrentPositionLongitude(rhs.getCurrentPositionLongitude());
        } else {
            clearCurrentPositionLongitude();
        }
        if (rhs.hasCurrentPositionLatitude()) {
            setCurrentPositionLatitude(rhs.getCurrentPositionLatitude());
        } else {
            clearCurrentPositionLatitude();
        }
        if (rhs.hasDestinationLongitude()) {
            setDestinationLongitude(rhs.getDestinationLongitude());
        } else {
            clearDestinationLongitude();
        }
        if (rhs.hasDestinationLatitude()) {
            setDestinationLatitude(rhs.getDestinationLatitude());
        } else {
            clearDestinationLatitude();
        }
        if (rhs.hasRouteIndex()) {
            setRouteIndex(rhs.getRouteIndex());
        } else {
            clearRouteIndex();
        }
        if (rhs.hasRouteOptimisation()) {
            setRouteOptimisation(rhs.getRouteOptimisation());
        } else {
            clearRouteOptimisation();
        }
        if (rhs.hasCommand()) {
            setCommand(rhs.getCommand());
        } else {
            clearCommand();
        }
        if (rhs.hasRouteCalculationStatus()) {
            setRouteCalculationStatus(rhs.getRouteCalculationStatus());
        } else {
            clearRouteCalculationStatus();
        }
        if (rhs.hasRouteLength()) {
            setRouteLength(rhs.getRouteLength());
        } else {
            clearRouteLength();
        }
        if (rhs.hasRouteDuration()) {
            setRouteDuration(rhs.getRouteDuration());
        } else {
            clearRouteDuration();
        }
    }
    return *this;
}

inline bool T_RouteCalculationResultParameter::operator == (const T_RouteCalculationResultParameter& rhs) const {
    return (((!hasCurrentPositionLongitude() && !rhs.hasCurrentPositionLongitude()) || getCurrentPositionLongitude() == rhs.getCurrentPositionLongitude()) &&
        ((!hasCurrentPositionLatitude() && !rhs.hasCurrentPositionLatitude()) || getCurrentPositionLatitude() == rhs.getCurrentPositionLatitude()) &&
        ((!hasDestinationLongitude() && !rhs.hasDestinationLongitude()) || getDestinationLongitude() == rhs.getDestinationLongitude()) &&
        ((!hasDestinationLatitude() && !rhs.hasDestinationLatitude()) || getDestinationLatitude() == rhs.getDestinationLatitude()) &&
        ((!hasRouteIndex() && !rhs.hasRouteIndex()) || getRouteIndex() == rhs.getRouteIndex()) &&
        ((!hasRouteOptimisation() && !rhs.hasRouteOptimisation()) || getRouteOptimisation() == rhs.getRouteOptimisation()) &&
        ((!hasCommand() && !rhs.hasCommand()) || getCommand() == rhs.getCommand()) &&
        ((!hasRouteCalculationStatus() && !rhs.hasRouteCalculationStatus()) || getRouteCalculationStatus() == rhs.getRouteCalculationStatus()) &&
        ((!hasRouteLength() && !rhs.hasRouteLength()) || getRouteLength() == rhs.getRouteLength()) &&
        ((!hasRouteDuration() && !rhs.hasRouteDuration()) || getRouteDuration() == rhs.getRouteDuration()));
}

inline bool T_RouteCalculationResultParameter::operator != (const T_RouteCalculationResultParameter& rhs) const {
    return ! (*this == rhs);
}

inline bool T_RouteCalculationResultParameter::operator < (const T_RouteCalculationResultParameter& rhs) const {
    if (hasCurrentPositionLongitude() || rhs.hasCurrentPositionLongitude()) {
        if (getCurrentPositionLongitude() < rhs.getCurrentPositionLongitude()) return true;
        if (getCurrentPositionLongitude() > rhs.getCurrentPositionLongitude()) return false;
    }
    if (hasCurrentPositionLatitude() || rhs.hasCurrentPositionLatitude()) {
        if (getCurrentPositionLatitude() < rhs.getCurrentPositionLatitude()) return true;
        if (getCurrentPositionLatitude() > rhs.getCurrentPositionLatitude()) return false;
    }
    if (hasDestinationLongitude() || rhs.hasDestinationLongitude()) {
        if (getDestinationLongitude() < rhs.getDestinationLongitude()) return true;
        if (getDestinationLongitude() > rhs.getDestinationLongitude()) return false;
    }
    if (hasDestinationLatitude() || rhs.hasDestinationLatitude()) {
        if (getDestinationLatitude() < rhs.getDestinationLatitude()) return true;
        if (getDestinationLatitude() > rhs.getDestinationLatitude()) return false;
    }
    if (hasRouteIndex() || rhs.hasRouteIndex()) {
        if (getRouteIndex() < rhs.getRouteIndex()) return true;
        if (getRouteIndex() > rhs.getRouteIndex()) return false;
    }
    if (hasRouteOptimisation() || rhs.hasRouteOptimisation()) {
        if (getRouteOptimisation() < rhs.getRouteOptimisation()) return true;
        if (getRouteOptimisation() > rhs.getRouteOptimisation()) return false;
    }
    if (hasCommand() || rhs.hasCommand()) {
        if ((uint32)getCommand() < (uint32)rhs.getCommand()) return true;
        if ((uint32)getCommand() > (uint32)rhs.getCommand()) return false;
    }
    if (hasRouteCalculationStatus() || rhs.hasRouteCalculationStatus()) {
        if ((uint32)getRouteCalculationStatus() < (uint32)rhs.getRouteCalculationStatus()) return true;
        if ((uint32)getRouteCalculationStatus() > (uint32)rhs.getRouteCalculationStatus()) return false;
    }
    if (hasRouteLength() || rhs.hasRouteLength()) {
        if (getRouteLength() < rhs.getRouteLength()) return true;
        if (getRouteLength() > rhs.getRouteLength()) return false;
    }
    if (hasRouteDuration() || rhs.hasRouteDuration()) {
        if (getRouteDuration() < rhs.getRouteDuration()) return true;
        if (getRouteDuration() > rhs.getRouteDuration()) return false;
    }
    return false;
}

inline bool T_RouteCalculationResultParameter::operator > (const T_RouteCalculationResultParameter& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_RouteCalculationResultParameter::clear() {
    clearCurrentPositionLongitude();
    clearCurrentPositionLatitude();
    clearDestinationLongitude();
    clearDestinationLatitude();
    clearRouteIndex();
    clearRouteOptimisation();
    clearCommand();
    clearRouteCalculationStatus();
    clearRouteLength();
    clearRouteDuration();
}

inline void T_RouteCalculationResultParameter::clearCurrentPositionLongitude() {
    if (hasCurrentPositionLongitude()) {
         clear_has_CurrentPositionLongitude();
        _CurrentPositionLongitude = 0;
     }
}

inline bool T_RouteCalculationResultParameter::hasCurrentPositionLongitude () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 T_RouteCalculationResultParameter::getCurrentPositionLongitude () const {
    return _CurrentPositionLongitude;
}

inline void T_RouteCalculationResultParameter::setCurrentPositionLongitude (int32 CurrentPositionLongitude_) {
    set_has_CurrentPositionLongitude();
    this->_CurrentPositionLongitude = CurrentPositionLongitude_;
}

inline void T_RouteCalculationResultParameter::clearCurrentPositionLatitude() {
    if (hasCurrentPositionLatitude()) {
         clear_has_CurrentPositionLatitude();
        _CurrentPositionLatitude = 0;
     }
}

inline bool T_RouteCalculationResultParameter::hasCurrentPositionLatitude () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 T_RouteCalculationResultParameter::getCurrentPositionLatitude () const {
    return _CurrentPositionLatitude;
}

inline void T_RouteCalculationResultParameter::setCurrentPositionLatitude (int32 CurrentPositionLatitude_) {
    set_has_CurrentPositionLatitude();
    this->_CurrentPositionLatitude = CurrentPositionLatitude_;
}

inline void T_RouteCalculationResultParameter::clearDestinationLongitude() {
    if (hasDestinationLongitude()) {
         clear_has_DestinationLongitude();
        _DestinationLongitude = 0;
     }
}

inline bool T_RouteCalculationResultParameter::hasDestinationLongitude () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 T_RouteCalculationResultParameter::getDestinationLongitude () const {
    return _DestinationLongitude;
}

inline void T_RouteCalculationResultParameter::setDestinationLongitude (int32 DestinationLongitude_) {
    set_has_DestinationLongitude();
    this->_DestinationLongitude = DestinationLongitude_;
}

inline void T_RouteCalculationResultParameter::clearDestinationLatitude() {
    if (hasDestinationLatitude()) {
         clear_has_DestinationLatitude();
        _DestinationLatitude = 0;
     }
}

inline bool T_RouteCalculationResultParameter::hasDestinationLatitude () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline int32 T_RouteCalculationResultParameter::getDestinationLatitude () const {
    return _DestinationLatitude;
}

inline void T_RouteCalculationResultParameter::setDestinationLatitude (int32 DestinationLatitude_) {
    set_has_DestinationLatitude();
    this->_DestinationLatitude = DestinationLatitude_;
}

inline void T_RouteCalculationResultParameter::clearRouteIndex() {
    if (hasRouteIndex()) {
         clear_has_RouteIndex();
        _RouteIndex = 0u;
     }
}

inline bool T_RouteCalculationResultParameter::hasRouteIndex () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_RouteCalculationResultParameter::getRouteIndex () const {
    return _RouteIndex;
}

inline void T_RouteCalculationResultParameter::setRouteIndex (uint8 RouteIndex_) {
    set_has_RouteIndex();
    this->_RouteIndex = RouteIndex_;
}

inline void T_RouteCalculationResultParameter::clearRouteOptimisation() {
    if (hasRouteOptimisation()) {
         clear_has_RouteOptimisation();
        _RouteOptimisation = 0u;
     }
}

inline bool T_RouteCalculationResultParameter::hasRouteOptimisation () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_RouteCalculationResultParameter::getRouteOptimisation () const {
    return _RouteOptimisation;
}

inline void T_RouteCalculationResultParameter::setRouteOptimisation (uint8 RouteOptimisation_) {
    set_has_RouteOptimisation();
    this->_RouteOptimisation = RouteOptimisation_;
}

inline void T_RouteCalculationResultParameter::clearCommand() {
    if (hasCommand()) {
         clear_has_Command();
        _Command = ::midw_diagnostics_fi_types::T_e8_RouteCalculationCommand__Undefined;
     }
}

inline bool T_RouteCalculationResultParameter::hasCommand () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline T_e8_RouteCalculationCommand T_RouteCalculationResultParameter::getCommand () const {
    return _Command;
}

inline void T_RouteCalculationResultParameter::setCommand (T_e8_RouteCalculationCommand Command_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_RouteCalculationCommand_IsValid(Command_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Command_, "T_e8_RouteCalculationCommand", "Command", "T_RouteCalculationResultParameter");
    }
    set_has_Command();
    this->_Command = Command_;
}

inline void T_RouteCalculationResultParameter::clearRouteCalculationStatus() {
    if (hasRouteCalculationStatus()) {
         clear_has_RouteCalculationStatus();
        _RouteCalculationStatus = ::midw_diagnostics_fi_types::T_e8_RouteCalculationStatus__Undefined;
     }
}

inline bool T_RouteCalculationResultParameter::hasRouteCalculationStatus () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline T_e8_RouteCalculationStatus T_RouteCalculationResultParameter::getRouteCalculationStatus () const {
    return _RouteCalculationStatus;
}

inline void T_RouteCalculationResultParameter::setRouteCalculationStatus (T_e8_RouteCalculationStatus RouteCalculationStatus_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_RouteCalculationStatus_IsValid(RouteCalculationStatus_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", RouteCalculationStatus_, "T_e8_RouteCalculationStatus", "RouteCalculationStatus", "T_RouteCalculationResultParameter");
    }
    set_has_RouteCalculationStatus();
    this->_RouteCalculationStatus = RouteCalculationStatus_;
}

inline void T_RouteCalculationResultParameter::clearRouteLength() {
    if (hasRouteLength()) {
         clear_has_RouteLength();
        _RouteLength = 0u;
     }
}

inline bool T_RouteCalculationResultParameter::hasRouteLength () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint32 T_RouteCalculationResultParameter::getRouteLength () const {
    return _RouteLength;
}

inline void T_RouteCalculationResultParameter::setRouteLength (uint32 RouteLength_) {
    set_has_RouteLength();
    this->_RouteLength = RouteLength_;
}

inline void T_RouteCalculationResultParameter::clearRouteDuration() {
    if (hasRouteDuration()) {
         clear_has_RouteDuration();
        _RouteDuration = 0u;
     }
}

inline bool T_RouteCalculationResultParameter::hasRouteDuration () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline uint32 T_RouteCalculationResultParameter::getRouteDuration () const {
    return _RouteDuration;
}

inline void T_RouteCalculationResultParameter::setRouteDuration (uint32 RouteDuration_) {
    set_has_RouteDuration();
    this->_RouteDuration = RouteDuration_;
}

inline void T_RouteCalculationResultParameter::set_has_CurrentPositionLongitude () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_RouteCalculationResultParameter::clear_has_CurrentPositionLongitude () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_RouteCalculationResultParameter::set_has_CurrentPositionLatitude () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_RouteCalculationResultParameter::clear_has_CurrentPositionLatitude () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_RouteCalculationResultParameter::set_has_DestinationLongitude () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_RouteCalculationResultParameter::clear_has_DestinationLongitude () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_RouteCalculationResultParameter::set_has_DestinationLatitude () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_RouteCalculationResultParameter::clear_has_DestinationLatitude () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_RouteCalculationResultParameter::set_has_RouteIndex () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_RouteCalculationResultParameter::clear_has_RouteIndex () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_RouteCalculationResultParameter::set_has_RouteOptimisation () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_RouteCalculationResultParameter::clear_has_RouteOptimisation () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_RouteCalculationResultParameter::set_has_Command () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_RouteCalculationResultParameter::clear_has_Command () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_RouteCalculationResultParameter::set_has_RouteCalculationStatus () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_RouteCalculationResultParameter::clear_has_RouteCalculationStatus () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_RouteCalculationResultParameter::set_has_RouteLength () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_RouteCalculationResultParameter::clear_has_RouteLength () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_RouteCalculationResultParameter::set_has_RouteDuration () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_RouteCalculationResultParameter::clear_has_RouteDuration () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline  T_CalibrationTimeStamp::T_CalibrationTimeStamp ()  :
    _Hours (0u),
    _Minutes (0u),
    _Seconds (0u),
    _Day (0u),
    _Month (0u),
    _Year (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_CalibrationTimeStamp::T_CalibrationTimeStamp (const T_CalibrationTimeStamp &rhs)  :
    _Hours (0u),
    _Minutes (0u),
    _Seconds (0u),
    _Day (0u),
    _Month (0u),
    _Year (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_CalibrationTimeStamp::T_CalibrationTimeStamp (uint8 Hours_, uint8 Minutes_, uint8 Seconds_, uint8 Day_, uint8 Month_, uint8 Year_)  :
    _Hours (Hours_),
    _Minutes (Minutes_),
    _Seconds (Seconds_),
    _Day (Day_),
    _Month (Month_),
    _Year (Year_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_CalibrationTimeStamp::~T_CalibrationTimeStamp() {
}

inline T_CalibrationTimeStamp& T_CalibrationTimeStamp::operator = (const T_CalibrationTimeStamp& rhs) {
    if( this != &rhs ) {
        if (rhs.hasHours()) {
            setHours(rhs.getHours());
        } else {
            clearHours();
        }
        if (rhs.hasMinutes()) {
            setMinutes(rhs.getMinutes());
        } else {
            clearMinutes();
        }
        if (rhs.hasSeconds()) {
            setSeconds(rhs.getSeconds());
        } else {
            clearSeconds();
        }
        if (rhs.hasDay()) {
            setDay(rhs.getDay());
        } else {
            clearDay();
        }
        if (rhs.hasMonth()) {
            setMonth(rhs.getMonth());
        } else {
            clearMonth();
        }
        if (rhs.hasYear()) {
            setYear(rhs.getYear());
        } else {
            clearYear();
        }
    }
    return *this;
}

inline bool T_CalibrationTimeStamp::operator == (const T_CalibrationTimeStamp& rhs) const {
    return (((!hasHours() && !rhs.hasHours()) || getHours() == rhs.getHours()) &&
        ((!hasMinutes() && !rhs.hasMinutes()) || getMinutes() == rhs.getMinutes()) &&
        ((!hasSeconds() && !rhs.hasSeconds()) || getSeconds() == rhs.getSeconds()) &&
        ((!hasDay() && !rhs.hasDay()) || getDay() == rhs.getDay()) &&
        ((!hasMonth() && !rhs.hasMonth()) || getMonth() == rhs.getMonth()) &&
        ((!hasYear() && !rhs.hasYear()) || getYear() == rhs.getYear()));
}

inline bool T_CalibrationTimeStamp::operator != (const T_CalibrationTimeStamp& rhs) const {
    return ! (*this == rhs);
}

inline bool T_CalibrationTimeStamp::operator < (const T_CalibrationTimeStamp& rhs) const {
    if (hasHours() || rhs.hasHours()) {
        if (getHours() < rhs.getHours()) return true;
        if (getHours() > rhs.getHours()) return false;
    }
    if (hasMinutes() || rhs.hasMinutes()) {
        if (getMinutes() < rhs.getMinutes()) return true;
        if (getMinutes() > rhs.getMinutes()) return false;
    }
    if (hasSeconds() || rhs.hasSeconds()) {
        if (getSeconds() < rhs.getSeconds()) return true;
        if (getSeconds() > rhs.getSeconds()) return false;
    }
    if (hasDay() || rhs.hasDay()) {
        if (getDay() < rhs.getDay()) return true;
        if (getDay() > rhs.getDay()) return false;
    }
    if (hasMonth() || rhs.hasMonth()) {
        if (getMonth() < rhs.getMonth()) return true;
        if (getMonth() > rhs.getMonth()) return false;
    }
    if (hasYear() || rhs.hasYear()) {
        if (getYear() < rhs.getYear()) return true;
        if (getYear() > rhs.getYear()) return false;
    }
    return false;
}

inline bool T_CalibrationTimeStamp::operator > (const T_CalibrationTimeStamp& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_CalibrationTimeStamp::clear() {
    clearHours();
    clearMinutes();
    clearSeconds();
    clearDay();
    clearMonth();
    clearYear();
}

inline void T_CalibrationTimeStamp::clearHours() {
    if (hasHours()) {
         clear_has_Hours();
        _Hours = 0u;
     }
}

inline bool T_CalibrationTimeStamp::hasHours () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_CalibrationTimeStamp::getHours () const {
    return _Hours;
}

inline void T_CalibrationTimeStamp::setHours (uint8 Hours_) {
    set_has_Hours();
    this->_Hours = Hours_;
}

inline void T_CalibrationTimeStamp::clearMinutes() {
    if (hasMinutes()) {
         clear_has_Minutes();
        _Minutes = 0u;
     }
}

inline bool T_CalibrationTimeStamp::hasMinutes () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_CalibrationTimeStamp::getMinutes () const {
    return _Minutes;
}

inline void T_CalibrationTimeStamp::setMinutes (uint8 Minutes_) {
    set_has_Minutes();
    this->_Minutes = Minutes_;
}

inline void T_CalibrationTimeStamp::clearSeconds() {
    if (hasSeconds()) {
         clear_has_Seconds();
        _Seconds = 0u;
     }
}

inline bool T_CalibrationTimeStamp::hasSeconds () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_CalibrationTimeStamp::getSeconds () const {
    return _Seconds;
}

inline void T_CalibrationTimeStamp::setSeconds (uint8 Seconds_) {
    set_has_Seconds();
    this->_Seconds = Seconds_;
}

inline void T_CalibrationTimeStamp::clearDay() {
    if (hasDay()) {
         clear_has_Day();
        _Day = 0u;
     }
}

inline bool T_CalibrationTimeStamp::hasDay () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_CalibrationTimeStamp::getDay () const {
    return _Day;
}

inline void T_CalibrationTimeStamp::setDay (uint8 Day_) {
    set_has_Day();
    this->_Day = Day_;
}

inline void T_CalibrationTimeStamp::clearMonth() {
    if (hasMonth()) {
         clear_has_Month();
        _Month = 0u;
     }
}

inline bool T_CalibrationTimeStamp::hasMonth () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_CalibrationTimeStamp::getMonth () const {
    return _Month;
}

inline void T_CalibrationTimeStamp::setMonth (uint8 Month_) {
    set_has_Month();
    this->_Month = Month_;
}

inline void T_CalibrationTimeStamp::clearYear() {
    if (hasYear()) {
         clear_has_Year();
        _Year = 0u;
     }
}

inline bool T_CalibrationTimeStamp::hasYear () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_CalibrationTimeStamp::getYear () const {
    return _Year;
}

inline void T_CalibrationTimeStamp::setYear (uint8 Year_) {
    set_has_Year();
    this->_Year = Year_;
}

inline void T_CalibrationTimeStamp::set_has_Hours () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_CalibrationTimeStamp::clear_has_Hours () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_CalibrationTimeStamp::set_has_Minutes () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_CalibrationTimeStamp::clear_has_Minutes () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_CalibrationTimeStamp::set_has_Seconds () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_CalibrationTimeStamp::clear_has_Seconds () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_CalibrationTimeStamp::set_has_Day () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_CalibrationTimeStamp::clear_has_Day () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_CalibrationTimeStamp::set_has_Month () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_CalibrationTimeStamp::clear_has_Month () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_CalibrationTimeStamp::set_has_Year () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_CalibrationTimeStamp::clear_has_Year () {
    _has_bits_[0] &= ~ (1u << 5);
}

} // namespace midw_diagnostics_fi_types

#endif // MIDW_DIAGNOSTICS_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
