/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/org/freedesktop/DBus/Properties.h"
#include "bosch/org/freedesktop/DBus/PropertiesDBus.h"
#include "bosch/org/freedesktop/DBus/PropertiesJson.h"
#include "bosch/org/freedesktop/DBus/PropertiesStub.h"
#include <map>
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace org {
namespace freedesktop {
namespace DBus {
namespace Properties {

DEFINE_CLASS_LOGGER("/org/freedesktop/DBus/Properties", PropertiesStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 3, "Get", 0 },
    { 3, "Set", 2 },
    { 6, "GetAll", 1 },
};


class PropertiesStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    PropertiesStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    PropertiesStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    PropertiesStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.freedesktop.DBus.Properties"),
          _logger(logger) {}

    virtual ~PropertiesStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void PropertiesStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 3, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'Get'

            LOG_DEBUG_STUB("process method '%s'", "Get");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Get", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetRequest > payload = ::boost::static_pointer_cast<GetRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<PropertiesStub*>(getStub())->onGetRequest(payload);
            return;
        }
        case 1: {

            // method 'GetAll'

            LOG_DEBUG_STUB("process method '%s'", "GetAll");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetAllRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetAll", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetAllRequest > payload = ::boost::static_pointer_cast<GetAllRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<PropertiesStub*>(getStub())->onGetAllRequest(payload);
            return;
        }
        case 2: {

            // method 'Set'

            LOG_DEBUG_STUB("process method '%s'", "Set");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Set", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetRequest > payload = ::boost::static_pointer_cast<SetRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<PropertiesStub*>(getStub())->onSetRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* PropertiesStubDelegate::introspect() const {
    return     "<interface name=\"org.freedesktop.DBus.Properties\">\n"
            "      <method name=\"Get\">\n"
            "        <arg direction=\"in\" name=\"interface\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"property\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"value\" type=\"v\"/>\n"
            "      </method>\n"
            "      <method name=\"GetAll\">\n"
            "        <arg direction=\"in\" name=\"interface\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"properties\" type=\"a{sv}\"/>\n"
            "      </method>\n"
            "      <method name=\"Set\">\n"
            "        <arg direction=\"in\" name=\"interface\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"property\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"value\" type=\"v\"/>\n"
            "      </method>\n"
            "      <signal name=\"PropertiesChanged\">\n"
            "        <arg name=\"interface\" type=\"s\"/>\n"
            "        <arg name=\"changed_properties\" type=\"a{sv}\"/>\n"
            "        <arg name=\"invalidated_properties\" type=\"as\"/>\n"
            "      </signal>\n"
            "</interface>\n";
}

void PropertiesStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<PropertiesStub*>(getStub()))->onGetAll (properties);
}

void PropertiesStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void PropertiesStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

PropertiesStub::PropertiesStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new PropertiesStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

PropertiesStub::PropertiesStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new PropertiesStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

PropertiesStub::PropertiesStub(::asf::dbus::DBusConnector& connector,
                                       const std::string& objectPath)
    : ::asf::dbus::DBusStub(_logger) {
    _stubDelegate = new PropertiesStubDelegate(this, _logger, connector, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

PropertiesStub::~PropertiesStub() {
    delete _stubDelegate;
}

void PropertiesStub::sendPropertiesChangedSignal(const ::std::string& interface, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& changed_properties, const ::std::vector< ::std::string >& invalidated_properties) {
    if (_stubDelegate->isConnected()) {
        PropertiesChangedSignal* payload = new PropertiesChangedSignal(interface, changed_properties, invalidated_properties);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "PropertiesChanged", PropertiesChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "PropertiesChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "PropertiesChanged");
    }
}

void  PropertiesStub::sendGetResponse (const ::asf::dbus::DBusVariant& value, act_t act) {
    GetResponse* payload = new GetResponse(value);
    DBUS_MESSAGE_REPLY(dbusMessage, "Get", GetResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Get", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  PropertiesStub::sendGetError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetError* payload = new GetError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Get", GetError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Get", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  PropertiesStub::sendGetAllResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties, act_t act) {
    GetAllResponse* payload = new GetAllResponse(properties);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetAll", GetAllResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetAll", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  PropertiesStub::sendGetAllError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetAllError* payload = new GetAllError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetAll", GetAllError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetAll", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  PropertiesStub::sendSetResponse (act_t act) {
    SetResponse* payload = new SetResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Set", SetResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Set", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  PropertiesStub::sendSetError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetError* payload = new SetError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Set", SetError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Set", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void PropertiesStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace Properties
} // namespace DBus
} // namespace freedesktop
} // namespace org
} // namespace bosch
