/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_ORG_FREEDESKTOP_DBUS_PROPERTIESPROXY_H
#define BOSCH_ORG_FREEDESKTOP_DBUS_PROPERTIESPROXY_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/org/freedesktop/DBus/Properties.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include <dbus/dbus.h>
#include <string>

namespace bosch {
namespace org {
namespace freedesktop {
namespace DBus {
namespace Properties {

class PropertiesProxy;

class GetAllCallbackIF {
public:
    virtual ~GetAllCallbackIF() {}

    virtual void onGetAllError(const ::boost::shared_ptr< PropertiesProxy >& proxy, const ::boost::shared_ptr< GetAllError >& error) = 0;

    virtual void onGetAllResponse(const ::boost::shared_ptr< PropertiesProxy >& proxy, const ::boost::shared_ptr< GetAllResponse >& response) = 0;
};

class GetCallbackIF {
public:
    virtual ~GetCallbackIF() {}

    virtual void onGetError(const ::boost::shared_ptr< PropertiesProxy >& proxy, const ::boost::shared_ptr< GetError >& error) = 0;

    virtual void onGetResponse(const ::boost::shared_ptr< PropertiesProxy >& proxy, const ::boost::shared_ptr< GetResponse >& response) = 0;
};

class PropertiesChangedCallbackIF {
public:
    virtual ~PropertiesChangedCallbackIF() {}

    virtual void onPropertiesChangedError(const ::boost::shared_ptr< PropertiesProxy >& proxy, const ::boost::shared_ptr< PropertiesChangedError >& error) = 0;

    virtual void onPropertiesChangedSignal(const ::boost::shared_ptr< PropertiesProxy >& proxy, const ::boost::shared_ptr< PropertiesChangedSignal >& signal) = 0;
};

class SetCallbackIF {
public:
    virtual ~SetCallbackIF() {}

    virtual void onSetError(const ::boost::shared_ptr< PropertiesProxy >& proxy, const ::boost::shared_ptr< SetError >& error) = 0;

    virtual void onSetResponse(const ::boost::shared_ptr< PropertiesProxy >& proxy, const ::boost::shared_ptr< SetResponse >& response) = 0;
};


/**
 * PropertiesProxy is the client side representation of the D-Bus service
 * interface 'org.freedesktop.DBus.Properties' (specified in file
 * DBusProperties.xml).
 *
 * If the meaning of "org.freedesktop.DBus.Properties" isn't clear, then there should be a description here.
 */
class PropertiesProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of PropertiesProxy.
     */
    static ::boost::shared_ptr< PropertiesProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of PropertiesProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< PropertiesProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of PropertiesProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< PropertiesProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< PropertiesProxy > proxyNew(new PropertiesProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~PropertiesProxy ();


    // Signal 'PropertiesChanged'

    /**
     * Notify on the signal 'PropertiesChanged'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'PropertiesChanged'</b>:
     *
     * If the meaning of "PropertiesChanged" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPropertiesChangedRegister(PropertiesChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'PropertiesChanged'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'PropertiesChanged'</b>:
     *
     * If the meaning of "PropertiesChanged" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendPropertiesChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPropertiesChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'PropertiesChanged'.
     */
    void sendPropertiesChangedDeregisterAll () const;



    // Method 'Get'

    /**
     * Call the method 'Get'. This method sends a message to the D-Bus server.
     *
     * <b>Documentation of 'Get'</b>:
     *
     * If the meaning of "Get" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param interface If the meaning of "interface" isn't clear, then there should be a description here.
     *
     * @param property If the meaning of "property" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetRequest(GetCallbackIF& cb, const ::std::string& interface, const ::std::string& property) const;

    // Method 'GetAll'

    /**
     * Call the method 'GetAll'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'GetAll'</b>:
     *
     * If the meaning of "GetAll" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param interface If the meaning of "interface" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetAllRequest(GetAllCallbackIF& cb, const ::std::string& interface) const;

    // Method 'Set'

    /**
     * Call the method 'Set'. This method sends a message to the D-Bus server.
     *
     * <b>Documentation of 'Set'</b>:
     *
     * If the meaning of "Set" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param interface If the meaning of "interface" isn't clear, then there should be a description here.
     *
     * @param property If the meaning of "property" isn't clear, then there should be a description here.
     *
     * @param value If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetRequest(SetCallbackIF& cb, const ::std::string& interface, const ::std::string& property, const ::asf::dbus::DBusVariant& value) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    PropertiesProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class PropertiesProxyCallback;
};

} // namespace Properties
} // namespace DBus
} // namespace freedesktop
} // namespace org
} // namespace bosch

#endif // BOSCH_ORG_FREEDESKTOP_DBUS_PROPERTIESPROXY_H
