/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_DATASERVICESSTUB_H
#define ORG_BOSCH_CM_DATASERVICESSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/DataServices.h"
#include <vector>

namespace org {
namespace bosch {
namespace cm {
namespace DataServices {

class DataServicesStubDelegate;

class DataServicesStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the DataServicesStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    DataServicesStub (const std::string& portName);

    /**
     * Create an instance of the DataServicesStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    DataServicesStub (const std::string& portName, const std::string& objectPath);

    virtual ~DataServicesStub();

    // signal 'FID_G_LOGOLIST'

    /**
     * Raise the signal 'FID_G_LOGOLIST' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'FID_G_LOGOLIST'</b>:
     *
     * FID_G_LOGOLIST = Provides the logo list data
     *
     * @param LogoList LogoList (of type aLogoList) = logo list
     * aLogoList = array[T_DAB_Logo_Link]
     * T_DAB_Logo_Link struct[u64ID, rLogo] = logo structure
     * 0: T_DAB_Logo_Link.u64ID ('u') = Service ID/ Ensemble ID
     * 1: T_DAB_Logo_Link.rLogo ('?') = gives service logo information
     */
    void sendFID_G_LOGOLISTSignal(const ::std::vector< FID_G_LOGOLISTSignalLogoListStruct >& logoList);

    // signal 'FID_G_LOGO'

    /**
     * Raise the signal 'FID_G_LOGO' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'FID_G_LOGO'</b>:
     *
     * FID_G_LOGO = Provides the logo data
     *
     * @param Logo Logo (of type T_DAB_Logo_Data) = logo
     * T_DAB_Logo_Data struct[u64ID, rLogo, rBuffer] = logo structure providing data
     * 0: T_DAB_Logo_Data.u64ID ('u') = Service ID/ Ensemble ID
     * 1: T_DAB_Logo_Data.rLogo ('?') = gives service logo information
     * 2: T_DAB_Logo_Data.rBuffer ('ay') = gives service logo data in bytes
     */
    void sendFID_G_LOGOSignal(const FID_G_LOGOSignalLogoStruct& logo);

    // signal 'FID_G_SLIDE'

    /**
     * Raise the signal 'FID_G_SLIDE' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'FID_G_SLIDE'</b>:
     *
     * FID_G_SLIDE = Provides the logo data
     *
     * @param Slide Slide (of type T_DAB_SlideData) = Slide
     * T_DAB_SlideData struct[e8SlideState, rBuffer] = Slide data
     * 0: T_DAB_SlideData.e8SlideState ('?') = tells whether to show/clear the slide image
     * 1: T_DAB_SlideData.rBuffer ('ay') = gives slide image data in bytes
     */
    void sendFID_G_SLIDESignal(const FID_G_SLIDESignalSlideStruct& slide);

    // signal 'FID_G_USERAPP_STATUS'

    /**
     * Raise the signal 'FID_G_USERAPP_STATUS' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'FID_G_USERAPP_STATUS'</b>:
     *
     * FID_G_USERAPP_STATUS = Provides the logo data
     *
     * @param u32ServiceId u32ServiceId = PSID
     *
     * @param e8UserApp e8UserApp (of type T_e8_DAB_UserApplicationType) = supported userapps
     * enum[DAB_USERAPPTYPE_SLIDESHOW (1), DAB_USERAPPTYPE_BWS (2), DAB_USERAPPTYPE_EPG (4)]
     */
    void sendFID_G_USERAPP_STATUSSignal(uint32 u32ServiceId, uint32 e8UserApp);

    // method 'FID_DAB_S_GET_USERAPP_EPG'

    /**
     * The method onFID_DAB_S_GET_USERAPP_EPG() is called by ASF when a client
     * invokes the method 'FID_DAB_S_GET_USERAPP_EPG'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendFID_DAB_S_GET_USERAPP_EPG() or
     * sendFID_DAB_S_GET_USERAPP_EPGError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'FID_DAB_S_GET_USERAPP_EPG'</b>:
     *
     * FID_DAB_S_GET_USERAPP_EPG = EPG data could be requested with this method
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onFID_DAB_S_GET_USERAPP_EPGRequest (const ::boost::shared_ptr< FID_DAB_S_GET_USERAPP_EPGRequest >& request) = 0;

    /**
     * The method sendFID_DAB_S_GET_USERAPP_EPGResponse() sends a response of
     * a previous method invocation of 'FID_DAB_S_GET_USERAPP_EPG' back to the
     * client.
     *
     * <b>Documentation of 'FID_DAB_S_GET_USERAPP_EPG'</b>:
     *
     * FID_DAB_S_GET_USERAPP_EPG = EPG data could be requested with this method
     *
     * @param e8MethodResult e8MethodResult (of type T_e8_DAB_Response) = Result code of the requested operation.
     * enum[DAB_RES_OK (0), DAB_RES_FAILED (1), DAB_RES_NOT_AVAILABLE (2), DAB_RES_INPROCESS (3)]
     *
     * @param e8EPGTypeInfo e8EPGTypeInfo (of type T_e8_DAB_EPGInfoType) = Type of EPG info sent
     * enum[DAB_EPG_SERVICEINFO (0), DAB_EPG_SCHEDULEINFO (1), DAB_EPG_GROUPINFO (2)]
     *
     * @param EPGServiceInfo EPGServiceInfo (of type T_DAB_EPG_ServiceInfo) = Service Info of current SID
     * T_DAB_EPG_ServiceInfo struct[u32EnsembleID, sEnsembleDescription, sEnsembleLinkInfo, u32ServiceID, rServiceLogo, sServiceDescription, sServiceLinkInfo, sGenreNames] = DAB EPG service information
     * 0: T_DAB_EPG_ServiceInfo.u32EnsembleID ('u') = Ensemble ID
     * 1: T_DAB_EPG_ServiceInfo.sEnsembleDescription ('s') = Gives description of Ensemble of the which the service belongs to.
     * 2: T_DAB_EPG_ServiceInfo.sEnsembleLinkInfo ('s') = List of links/URLs which gives the website or email address etc.
     * 3: T_DAB_EPG_ServiceInfo.u32ServiceID ('u') = Service Id.
     * 4: T_DAB_EPG_ServiceInfo.rServiceLogo ('?') = Logo of Service.
     * 5: T_DAB_EPG_ServiceInfo.sServiceDescription ('s') = Gives description of the Service requested .
     * 6: T_DAB_EPG_ServiceInfo.sServiceLinkInfo ('s') = List of links/URLs which gives the website or email address etc.
     * 7: T_DAB_EPG_ServiceInfo.sGenreNames ('s') = List of genres provided by this service
     *
     * @param EPGScheduleInfo EPGScheduleInfo (of type T_DAB_EPG_ScheduleInfo) = >Schedule Info of current SID
     * T_DAB_EPG_ScheduleInfo struct[bRecommended, u32EnsembleID, rScopeTime, u8CurrentProgram, rProgramInfo] = DAB EPG service schedule information
     * 0: T_DAB_EPG_ScheduleInfo.bRecommended ('b') = True if the schedule info is recommended, else false.
     * 1: T_DAB_EPG_ScheduleInfo.u32EnsembleID ('u') = Ensemble ID
     * 2: T_DAB_EPG_ScheduleInfo.rScopeTime ('?') = Gives start time and stop time of the Service scope
     * 3: T_DAB_EPG_ScheduleInfo.u8CurrentProgram ('y') = Gives index of current program 0,1,2
     * 4: T_DAB_EPG_ScheduleInfo.rProgramInfo ('?') = Gives start time and stop time of the Service scope
     *
     * @param GroupInfo GroupInfo (of type T_DAB_EPG_GroupInfo) = >gives groups in which this service is present
     * T_DAB_EPG_GroupInfo struct[sGroupName, rGroupDescription, rSupportedGenres] = information of a DAB EPG group   .
     * 0: T_DAB_EPG_GroupInfo.sGroupName ('s') = gives name of group
     * 1: T_DAB_EPG_GroupInfo.rGroupDescription ('?') = gives short and medium description ofgroup
     * 2: T_DAB_EPG_GroupInfo.rSupportedGenres ('s') = List of genres provided by this group
     *
     * @param act The parameter act identifies a previous invocation of
     * onFID_DAB_S_GET_USERAPP_EPG(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendFID_DAB_S_GET_USERAPP_EPGResponse (uint32 e8MethodResult, uint32 e8EPGTypeInfo, const FID_DAB_S_GET_USERAPP_EPGResponseEPGServiceInfoStruct& ePGServiceInfo, const FID_DAB_S_GET_USERAPP_EPGResponseEPGScheduleInfoStruct& ePGScheduleInfo, const ::std::vector< FID_DAB_S_GET_USERAPP_EPGResponseGroupInfoStruct >& groupInfo, act_t act = 0);

    /**
     * The method sendFID_DAB_S_GET_USERAPP_EPGError() sends an error response
     * of a previous method invocation of 'FID_DAB_S_GET_USERAPP_EPG' back to
     * the client.
     *
     * <b>Documentation of 'FID_DAB_S_GET_USERAPP_EPG'</b>:
     *
     * FID_DAB_S_GET_USERAPP_EPG = EPG data could be requested with this method
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onFID_DAB_S_GET_USERAPP_EPG(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendFID_DAB_S_GET_USERAPP_EPGError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'FID_DAB_S_ENABLE_USERAPP'

    /**
     * The method onFID_DAB_S_ENABLE_USERAPP() is called by ASF when a client
     * invokes the method 'FID_DAB_S_ENABLE_USERAPP'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendFID_DAB_S_ENABLE_USERAPP() or
     * sendFID_DAB_S_ENABLE_USERAPPError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'FID_DAB_S_ENABLE_USERAPP'</b>:
     *
     * FID_DAB_S_ENABLE_USERAPP = HMI could enable the needed user app with this method
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onFID_DAB_S_ENABLE_USERAPPRequest (const ::boost::shared_ptr< FID_DAB_S_ENABLE_USERAPPRequest >& request) = 0;

    /**
     * The method sendFID_DAB_S_ENABLE_USERAPPResponse() sends a response of a
     * previous method invocation of 'FID_DAB_S_ENABLE_USERAPP' back to the
     * client.
     *
     * <b>Documentation of 'FID_DAB_S_ENABLE_USERAPP'</b>:
     *
     * FID_DAB_S_ENABLE_USERAPP = HMI could enable the needed user app with this method
     *
     * @param e8MethodResult e8MethodResult (of type T_e8_DAB_Response) = Result code of the requested operation.
     * enum[DAB_RES_OK (0), DAB_RES_FAILED (1), DAB_RES_NOT_AVAILABLE (2), DAB_RES_INPROCESS (3)]
     *
     * @param e8EnabledUserApp e8EnabledUserApp (of type T_e8_DAB_UserApplicationType) = Type of userapp to be enabled
     * enum[DAB_USERAPPTYPE_SLIDESHOW (1), DAB_USERAPPTYPE_BWS (2), DAB_USERAPPTYPE_EPG (4)]
     *
     * @param act The parameter act identifies a previous invocation of
     * onFID_DAB_S_ENABLE_USERAPP(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendFID_DAB_S_ENABLE_USERAPPResponse (uint32 e8MethodResult, uint32 e8EnabledUserApp, act_t act = 0);

    /**
     * The method sendFID_DAB_S_ENABLE_USERAPPError() sends an error response
     * of a previous method invocation of 'FID_DAB_S_ENABLE_USERAPP' back to
     * the client.
     *
     * <b>Documentation of 'FID_DAB_S_ENABLE_USERAPP'</b>:
     *
     * FID_DAB_S_ENABLE_USERAPP = HMI could enable the needed user app with this method
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onFID_DAB_S_ENABLE_USERAPP(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendFID_DAB_S_ENABLE_USERAPPError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'FID_DAB_GET_LOGOLIST'

    /**
     * The method onFID_DAB_GET_LOGOLIST() is called by ASF when a client
     * invokes the method 'FID_DAB_GET_LOGOLIST'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendFID_DAB_GET_LOGOLIST() or sendFID_DAB_GET_LOGOLISTError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'FID_DAB_GET_LOGOLIST'</b>:
     *
     * FID_DAB_GET_LOGOLIST = HMI could request the needed logo list with this method
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onFID_DAB_GET_LOGOLISTRequest (const ::boost::shared_ptr< FID_DAB_GET_LOGOLISTRequest >& request) = 0;

    /**
     * The method sendFID_DAB_GET_LOGOLISTResponse() sends a response of a
     * previous method invocation of 'FID_DAB_GET_LOGOLIST' back to the
     * client.
     *
     * <b>Documentation of 'FID_DAB_GET_LOGOLIST'</b>:
     *
     * FID_DAB_GET_LOGOLIST = HMI could request the needed logo list with this method
     *
     * @param act The parameter act identifies a previous invocation of
     * onFID_DAB_GET_LOGOLIST(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendFID_DAB_GET_LOGOLISTResponse (act_t act = 0);

    /**
     * The method sendFID_DAB_GET_LOGOLISTError() sends an error response of a
     * previous method invocation of 'FID_DAB_GET_LOGOLIST' back to the
     * client.
     *
     * <b>Documentation of 'FID_DAB_GET_LOGOLIST'</b>:
     *
     * FID_DAB_GET_LOGOLIST = HMI could request the needed logo list with this method
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onFID_DAB_GET_LOGOLIST(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendFID_DAB_GET_LOGOLISTError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'FID_DAB_GET_LOGO'

    /**
     * The method onFID_DAB_GET_LOGO() is called by ASF when a client invokes
     * the method 'FID_DAB_GET_LOGO'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendFID_DAB_GET_LOGO() or sendFID_DAB_GET_LOGOError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'FID_DAB_GET_LOGO'</b>:
     *
     * FID_DAB_GET_LOGO = HMI could request the needed logo list with this method
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onFID_DAB_GET_LOGORequest (const ::boost::shared_ptr< FID_DAB_GET_LOGORequest >& request) = 0;

    /**
     * The method sendFID_DAB_GET_LOGOResponse() sends a response of a
     * previous method invocation of 'FID_DAB_GET_LOGO' back to the client.
     *
     * <b>Documentation of 'FID_DAB_GET_LOGO'</b>:
     *
     * FID_DAB_GET_LOGO = HMI could request the needed logo list with this method
     *
     * @param act The parameter act identifies a previous invocation of
     * onFID_DAB_GET_LOGO(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendFID_DAB_GET_LOGOResponse (act_t act = 0);

    /**
     * The method sendFID_DAB_GET_LOGOError() sends an error response of a
     * previous method invocation of 'FID_DAB_GET_LOGO' back to the client.
     *
     * <b>Documentation of 'FID_DAB_GET_LOGO'</b>:
     *
     * FID_DAB_GET_LOGO = HMI could request the needed logo list with this method
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onFID_DAB_GET_LOGO(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendFID_DAB_GET_LOGOError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class DataServicesStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace DataServices
} // namespace cm
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_CM_DATASERVICESSTUB_H
