/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/DataServices.h"
#include "org/bosch/cm/DataServicesDBus.h"
#include "org/bosch/cm/DataServicesJson.h"
#include "org/bosch/cm/DataServicesStub.h"
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace cm {
namespace DataServices {

DEFINE_CLASS_LOGGER("/org/bosch/cm/org/bosch/cm/DataServices", DataServicesStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 16, "FID_DAB_GET_LOGO", 3 },
    { 20, "FID_DAB_GET_LOGOLIST", 2 },
    { 24, "FID_DAB_S_ENABLE_USERAPP", 1 },
    { 25, "FID_DAB_S_GET_USERAPP_EPG", 0 },
};


class DataServicesStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    DataServicesStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    DataServicesStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    DataServicesStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.cm.DataServices"),
          _logger(logger) {}

    virtual ~DataServicesStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void DataServicesStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 4, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'FID_DAB_S_GET_USERAPP_EPG'

            LOG_DEBUG_STUB("process method '%s'", "FID_DAB_S_GET_USERAPP_EPG");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FID_DAB_S_GET_USERAPP_EPGRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "FID_DAB_S_GET_USERAPP_EPG", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< FID_DAB_S_GET_USERAPP_EPGRequest > payload = ::boost::static_pointer_cast<FID_DAB_S_GET_USERAPP_EPGRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DataServicesStub*>(getStub())->onFID_DAB_S_GET_USERAPP_EPGRequest(payload);
            return;
        }
        case 1: {

            // method 'FID_DAB_S_ENABLE_USERAPP'

            LOG_DEBUG_STUB("process method '%s'", "FID_DAB_S_ENABLE_USERAPP");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FID_DAB_S_ENABLE_USERAPPRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "FID_DAB_S_ENABLE_USERAPP", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< FID_DAB_S_ENABLE_USERAPPRequest > payload = ::boost::static_pointer_cast<FID_DAB_S_ENABLE_USERAPPRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DataServicesStub*>(getStub())->onFID_DAB_S_ENABLE_USERAPPRequest(payload);
            return;
        }
        case 2: {

            // method 'FID_DAB_GET_LOGOLIST'

            LOG_DEBUG_STUB("process method '%s'", "FID_DAB_GET_LOGOLIST");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FID_DAB_GET_LOGOLISTRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "FID_DAB_GET_LOGOLIST", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< FID_DAB_GET_LOGOLISTRequest > payload = ::boost::static_pointer_cast<FID_DAB_GET_LOGOLISTRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DataServicesStub*>(getStub())->onFID_DAB_GET_LOGOLISTRequest(payload);
            return;
        }
        case 3: {

            // method 'FID_DAB_GET_LOGO'

            LOG_DEBUG_STUB("process method '%s'", "FID_DAB_GET_LOGO");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FID_DAB_GET_LOGORequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "FID_DAB_GET_LOGO", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< FID_DAB_GET_LOGORequest > payload = ::boost::static_pointer_cast<FID_DAB_GET_LOGORequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DataServicesStub*>(getStub())->onFID_DAB_GET_LOGORequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* DataServicesStubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.cm.DataServices\">\n"
            "      <method name=\"FID_DAB_S_GET_USERAPP_EPG\">\n"
            "        <doc>\n"
            "          <line>FID_DAB_S_GET_USERAPP_EPG = EPG data could be requested with this method</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"e8EPGInfoType\" type=\"u\">\n"
            "          <doc>\n"
            "            <line>e8EPGInfoType (of type T_e8_DAB_EPGInfoType) = Type of EPG info required</line>\n"
            "            <line>enum[DAB_EPG_SERVICEINFO (0), DAB_EPG_SCHEDULEINFO (1), DAB_EPG_GROUPINFO (2)]</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"in\" name=\"u32ServiceId\" type=\"u\">\n"
            "          <doc>\n"
            "            <line>u32ServiceId = PSID</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"in\" name=\"rScheduleInfoConfig\" type=\"(((yyqyyy)(yyqyyy))u)\">\n"
            "          <doc>\n"
            "            <line>rScheduleInfoConfig (of type T_DAB_ScheduleInfoConfig) = Shcedule Info can be configured</line>\n"
            "            <line>T_DAB_ScheduleInfoConfig struct[rScope, u32NumberOfEntries] = Schedule Info Configuration</line>\n"
            "            <line>0: T_DAB_ScheduleInfoConfig.rScope ('?') = Schedule Info within this scope would be sent</line>\n"
            "            <line>1: T_DAB_ScheduleInfoConfig.u32NumberOfEntries ('u') = schedule Info would be sent with these number of entries</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"out\" name=\"e8MethodResult\" type=\"u\">\n"
            "          <doc>\n"
            "            <line>e8MethodResult (of type T_e8_DAB_Response) = Result code of the requested operation.</line>\n"
            "            <line>enum[DAB_RES_OK (0), DAB_RES_FAILED (1), DAB_RES_NOT_AVAILABLE (2), DAB_RES_INPROCESS (3)]</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"out\" name=\"e8EPGTypeInfo\" type=\"u\">\n"
            "          <doc>\n"
            "            <line>e8EPGTypeInfo (of type T_e8_DAB_EPGInfoType) = Type of EPG info sent</line>\n"
            "            <line>enum[DAB_EPG_SERVICEINFO (0), DAB_EPG_SCHEDULEINFO (1), DAB_EPG_GROUPINFO (2)]</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"out\" name=\"EPGServiceInfo\" type=\"(usasu(syyu)asasas)\">\n"
            "          <doc>\n"
            "            <line>EPGServiceInfo (of type T_DAB_EPG_ServiceInfo) = Service Info of current SID</line>\n"
            "            <line>T_DAB_EPG_ServiceInfo struct[u32EnsembleID, sEnsembleDescription, sEnsembleLinkInfo, u32ServiceID, rServiceLogo, sServiceDescription, sServiceLinkInfo, sGenreNames] = DAB EPG service information</line>\n"
            "            <line>0: T_DAB_EPG_ServiceInfo.u32EnsembleID ('u') = Ensemble ID</line>\n"
            "            <line>1: T_DAB_EPG_ServiceInfo.sEnsembleDescription ('s') = Gives description of Ensemble of the which the service belongs to.</line>\n"
            "            <line>2: T_DAB_EPG_ServiceInfo.sEnsembleLinkInfo ('s') = List of links/URLs which gives the website or email address etc.</line>\n"
            "            <line>3: T_DAB_EPG_ServiceInfo.u32ServiceID ('u') = Service Id.</line>\n"
            "            <line>4: T_DAB_EPG_ServiceInfo.rServiceLogo ('?') = Logo of Service.</line>\n"
            "            <line>5: T_DAB_EPG_ServiceInfo.sServiceDescription ('s') = Gives description of the Service requested .</line>\n"
            "            <line>6: T_DAB_EPG_ServiceInfo.sServiceLinkInfo ('s') = List of links/URLs which gives the website or email address etc.</line>\n"
            "            <line>7: T_DAB_EPG_ServiceInfo.sGenreNames ('s') = List of genres provided by this service</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"out\" name=\"EPGScheduleInfo\" type=\"(bu((yyqyyy)(yyqyyy))a(usssas((yyqyyy)y)a(sssyys))y)\">\n"
            "          <doc>\n"
            "            <line>EPGScheduleInfo (of type T_DAB_EPG_ScheduleInfo) = >Schedule Info of current SID</line>\n"
            "            <line>T_DAB_EPG_ScheduleInfo struct[bRecommended, u32EnsembleID, rScopeTime, u8CurrentProgram, rProgramInfo] = DAB EPG service schedule information</line>\n"
            "            <line>0: T_DAB_EPG_ScheduleInfo.bRecommended ('b') = True if the schedule info is recommended, else false.</line>\n"
            "            <line>1: T_DAB_EPG_ScheduleInfo.u32EnsembleID ('u') = Ensemble ID</line>\n"
            "            <line>2: T_DAB_EPG_ScheduleInfo.rScopeTime ('?') = Gives start time and stop time of the Service scope</line>\n"
            "            <line>3: T_DAB_EPG_ScheduleInfo.u8CurrentProgram ('y') = Gives index of current program 0,1,2</line>\n"
            "            <line>4: T_DAB_EPG_ScheduleInfo.rProgramInfo ('?') = Gives start time and stop time of the Service scope</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"out\" name=\"GroupInfo\" type=\"a(s(ss)as)\">\n"
            "          <doc>\n"
            "            <line>GroupInfo (of type T_DAB_EPG_GroupInfo) = >gives groups in which this service is present</line>\n"
            "            <line>T_DAB_EPG_GroupInfo struct[sGroupName, rGroupDescription, rSupportedGenres] = information of a DAB EPG group   .</line>\n"
            "            <line>0: T_DAB_EPG_GroupInfo.sGroupName ('s') = gives name of group</line>\n"
            "            <line>1: T_DAB_EPG_GroupInfo.rGroupDescription ('?') = gives short and medium description ofgroup</line>\n"
            "            <line>2: T_DAB_EPG_GroupInfo.rSupportedGenres ('s') = List of genres provided by this group</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <error name=\"org.bosch.cm.DataServices.Error.INFO_NOT_AVAILABLE\" id=\"0\">\n"
            "          <doc>\n"
            "            <line>INFO_NOT_AVAILABLE = No info available.</line>\n"
            "          </doc>\n"
            "        </error>\n"
            "        <error name=\"org.bosch.cm.DataServices.Error.DATABASE_OPEN_ERROR\" id=\"1\">\n"
            "          <doc>\n"
            "            <line>DATABASE_OPEN_ERROR = Database OPEN error</line>\n"
            "          </doc>\n"
            "        </error>\n"
            "        <error name=\"org.bosch.cm.DataServices.Error.DATABASE_READ_ERROR\" id=\"2\">\n"
            "          <doc>\n"
            "            <line>DATABASE_READ_ERROR = Database read error</line>\n"
            "          </doc>\n"
            "        </error>\n"
            "        <error name=\"org.bosch.cm.DataServices.Error.FATAL__ERROR\" id=\"3\">\n"
            "          <doc>\n"
            "            <line>FATAL__ERROR = A fatal error happened.</line>\n"
            "          </doc>\n"
            "        </error>\n"
            "      </method>\n"
            "      <method name=\"FID_DAB_S_ENABLE_USERAPP\">\n"
            "        <doc>\n"
            "          <line>FID_DAB_S_ENABLE_USERAPP = HMI could enable the needed user app with this method</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"e8UserApp\" type=\"u\">\n"
            "          <doc>\n"
            "            <line>e8UserApp (of type T_e8_DAB_UserApplicationType) = Bitfield to indicate type of userapp to be enabled</line>\n"
            "            <line>enum[DAB_USERAPPTYPE_SLIDESHOW (1), DAB_USERAPPTYPE_BWS (2), DAB_USERAPPTYPE_EPG (4)]</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"in\" name=\"bEnable\" type=\"b\">\n"
            "          <doc>\n"
            "            <line>bEnable = True/False to enable /disable</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"out\" name=\"e8MethodResult\" type=\"u\">\n"
            "          <doc>\n"
            "            <line>e8MethodResult (of type T_e8_DAB_Response) = Result code of the requested operation.</line>\n"
            "            <line>enum[DAB_RES_OK (0), DAB_RES_FAILED (1), DAB_RES_NOT_AVAILABLE (2), DAB_RES_INPROCESS (3)]</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"out\" name=\"e8EnabledUserApp\" type=\"u\">\n"
            "          <doc>\n"
            "            <line>e8EnabledUserApp (of type T_e8_DAB_UserApplicationType) = Type of userapp to be enabled</line>\n"
            "            <line>enum[DAB_USERAPPTYPE_SLIDESHOW (1), DAB_USERAPPTYPE_BWS (2), DAB_USERAPPTYPE_EPG (4)]</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <error name=\"org.bosch.cm.DataServices.Error.INFO_NOT_AVAILABLE\" id=\"0\">\n"
            "          <doc>\n"
            "            <line>INFO_NOT_AVAILABLE = No infor available.</line>\n"
            "          </doc>\n"
            "        </error>\n"
            "        <error name=\"org.bosch.cm.DataServices.Error.CONNECTION_ERROR\" id=\"1\">\n"
            "          <doc>\n"
            "            <line>CONNECTION_ERROR = Connection to DDM failed</line>\n"
            "          </doc>\n"
            "        </error>\n"
            "        <error name=\"org.bosch.cm.DataServices.Error.FATAL__ERROR\" id=\"2\">\n"
            "          <doc>\n"
            "            <line>FATAL__ERROR = A fatal error happened.</line>\n"
            "          </doc>\n"
            "        </error>\n"
            "      </method>\n"
            "      <method name=\"FID_DAB_GET_LOGOLIST\">\n"
            "        <doc>\n"
            "          <line>FID_DAB_GET_LOGOLIST = HMI could request the needed logo list with this method</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"e8LogoListType\" type=\"u\">\n"
            "          <doc>\n"
            "            <line>e8LogoListType (of type T_e8_LogoListType) = requested Logo list type</line>\n"
            "            <line>enum[DAB_LOGOLIST_ENSEMBLE (0), DAB_LOGOLIST_SERVICE (1)]</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"in\" name=\"u8LogoType\" type=\"u\">\n"
            "          <doc>\n"
            "            <line>u8LogoType (of type T_e8_LogoType) = Indicates what type of Logo is needed.</line>\n"
            "            <line>enum[LOGOTYPE_NOLOGO (0), LOGOTYPE_UNRESTRICTED (1), LOGOTYPE_COLOUR_RECTANGLE (2), LOGOTYPE_COLOUR_SQUARE (3)]</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <error name=\"org.bosch.cm.DataServices.Error.INFO_NOT_AVAILABLE\" id=\"0\">\n"
            "          <doc>\n"
            "            <line>INFO_NOT_AVAILABLE = No infor available.</line>\n"
            "          </doc>\n"
            "        </error>\n"
            "        <error name=\"org.bosch.cm.DataServices.Error.DATABASE_OPEN_ERROR\" id=\"1\">\n"
            "          <doc>\n"
            "            <line>DATABASE_OPEN_ERROR = Database OPEN error</line>\n"
            "          </doc>\n"
            "        </error>\n"
            "        <error name=\"org.bosch.cm.DataServices.Error.DATABASE_READ_ERROR\" id=\"2\">\n"
            "          <doc>\n"
            "            <line>DATABASE_READ_ERROR = Database read error</line>\n"
            "          </doc>\n"
            "        </error>\n"
            "        <error name=\"org.bosch.cm.DataServices.Error.LOGO_CORRUPTED\" id=\"3\">\n"
            "          <doc>\n"
            "            <line>LOGO_CORRUPTED = Database read error</line>\n"
            "          </doc>\n"
            "        </error>\n"
            "        <error name=\"org.bosch.cm.DataServices.Error.FATAL__ERROR\" id=\"4\">\n"
            "          <doc>\n"
            "            <line>FATAL__ERROR = A fatal error happened.</line>\n"
            "          </doc>\n"
            "        </error>\n"
            "      </method>\n"
            "      <method name=\"FID_DAB_GET_LOGO\">\n"
            "        <doc>\n"
            "          <line>FID_DAB_GET_LOGO = HMI could request the needed logo list with this method</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"e8LogoListType\" type=\"u\">\n"
            "          <doc>\n"
            "            <line>e8LogoListType (of type T_e8_LogoListType) = requested Logo list type</line>\n"
            "            <line>enum[DAB_LOGOLIST_ENSEMBLE (0), DAB_LOGOLIST_SERVICE (1)]</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"in\" name=\"u8LogoType\" type=\"u\">\n"
            "          <doc>\n"
            "            <line>u8LogoType (of type T_e8_LogoType) = Indicates what type of Logo is needed.</line>\n"
            "            <line>enum[LOGOTYPE_NOLOGO (0), LOGOTYPE_UNRESTRICTED (1), LOGOTYPE_COLOUR_RECTANGLE (2), LOGOTYPE_COLOUR_SQUARE (3)]</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"in\" name=\"u32ServiceId\" type=\"u\">\n"
            "          <doc>\n"
            "            <line>u32ServiceId = PSID</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <error name=\"org.bosch.cm.DataServices.Error.FATAL_ERROR\" id=\"null\">\n"
            "          <doc>\n"
            "            <line>FATAL_ERROR = A severe error happened.</line>\n"
            "          </doc>\n"
            "        </error>\n"
            "        <error name=\"org.bosch.cm.DataServices.Error.INFO_NOT_AVAILABLE\" id=\"0\">\n"
            "          <doc>\n"
            "            <line>INFO_NOT_AVAILABLE = No infor available.</line>\n"
            "          </doc>\n"
            "        </error>\n"
            "        <error name=\"org.bosch.cm.DataServices.Error.DATABASE_OPEN_ERROR\" id=\"1\">\n"
            "          <doc>\n"
            "            <line>DATABASE_OPEN_ERROR = Database OPEN error</line>\n"
            "          </doc>\n"
            "        </error>\n"
            "        <error name=\"org.bosch.cm.DataServices.Error.DATABASE_READ_ERROR\" id=\"2\">\n"
            "          <doc>\n"
            "            <line>DATABASE_READ_ERROR = Database read error</line>\n"
            "          </doc>\n"
            "        </error>\n"
            "        <error name=\"org.bosch.cm.DataServices.Error.LOGO_CORRUPTED\" id=\"3\">\n"
            "          <doc>\n"
            "            <line>LOGO_CORRUPTED = Database read error</line>\n"
            "          </doc>\n"
            "        </error>\n"
            "        <error name=\"org.bosch.cm.DataServices.Error.FATAL__ERROR\" id=\"4\">\n"
            "          <doc>\n"
            "            <line>FATAL__ERROR = A fatal error happened.</line>\n"
            "          </doc>\n"
            "        </error>\n"
            "      </method>\n"
            "      <signal name=\"FID_G_LOGOLIST\">\n"
            "        <doc>\n"
            "          <line>FID_G_LOGOLIST = Provides the logo list data</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"LogoList\" type=\"a(u(syyu))\">\n"
            "          <doc>\n"
            "            <line>LogoList (of type aLogoList) = logo list</line>\n"
            "            <line>aLogoList = array[T_DAB_Logo_Link]</line>\n"
            "            <line>T_DAB_Logo_Link struct[u64ID, rLogo] = logo structure</line>\n"
            "            <line>0: T_DAB_Logo_Link.u64ID ('u') = Service ID/ Ensemble ID</line>\n"
            "            <line>1: T_DAB_Logo_Link.rLogo ('?') = gives service logo information</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "      </signal>\n"
            "      <signal name=\"FID_G_LOGO\">\n"
            "        <doc>\n"
            "          <line>FID_G_LOGO = Provides the logo data</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"Logo\" type=\"(u(syyu)ay)\">\n"
            "          <doc>\n"
            "            <line>Logo (of type T_DAB_Logo_Data) = logo</line>\n"
            "            <line>T_DAB_Logo_Data struct[u64ID, rLogo, rBuffer] = logo structure providing data</line>\n"
            "            <line>0: T_DAB_Logo_Data.u64ID ('u') = Service ID/ Ensemble ID</line>\n"
            "            <line>1: T_DAB_Logo_Data.rLogo ('?') = gives service logo information</line>\n"
            "            <line>2: T_DAB_Logo_Data.rBuffer ('ay') = gives service logo data in bytes</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "      </signal>\n"
            "      <signal name=\"FID_G_SLIDE\">\n"
            "        <doc>\n"
            "          <line>FID_G_SLIDE = Provides the logo data</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"Slide\" type=\"(uay)\">\n"
            "          <doc>\n"
            "            <line>Slide (of type T_DAB_SlideData) = Slide</line>\n"
            "            <line>T_DAB_SlideData struct[e8SlideState, rBuffer] = Slide data</line>\n"
            "            <line>0: T_DAB_SlideData.e8SlideState ('?') = tells whether to show/clear the slide image</line>\n"
            "            <line>1: T_DAB_SlideData.rBuffer ('ay') = gives slide image data in bytes</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "      </signal>\n"
            "      <signal name=\"FID_G_USERAPP_STATUS\">\n"
            "        <doc>\n"
            "          <line>FID_G_USERAPP_STATUS = Provides the logo data</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"u32ServiceId\" type=\"u\">\n"
            "          <doc>\n"
            "            <line>u32ServiceId = PSID</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"out\" name=\"e8UserApp\" type=\"u\">\n"
            "          <doc>\n"
            "            <line>e8UserApp (of type T_e8_DAB_UserApplicationType) = supported userapps</line>\n"
            "            <line>enum[DAB_USERAPPTYPE_SLIDESHOW (1), DAB_USERAPPTYPE_BWS (2), DAB_USERAPPTYPE_EPG (4)]</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "      </signal>\n"
            "</interface>\n";
}

void DataServicesStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<DataServicesStub*>(getStub()))->onGetAll (properties);
}

void DataServicesStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void DataServicesStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

DataServicesStub::DataServicesStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new DataServicesStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

DataServicesStub::DataServicesStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new DataServicesStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

DataServicesStub::~DataServicesStub() {
    delete _stubDelegate;
}

void DataServicesStub::sendFID_G_LOGOLISTSignal(const ::std::vector< FID_G_LOGOLISTSignalLogoListStruct >& logoList) {
    if (_stubDelegate->isConnected()) {
        FID_G_LOGOLISTSignal* payload = new FID_G_LOGOLISTSignal(logoList);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "FID_G_LOGOLIST", FID_G_LOGOLISTSignal, payload)
        LOG_INFO ("-> send%sSignal", "FID_G_LOGOLIST");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "FID_G_LOGOLIST");
    }
}

void DataServicesStub::sendFID_G_LOGOSignal(const FID_G_LOGOSignalLogoStruct& logo) {
    if (_stubDelegate->isConnected()) {
        FID_G_LOGOSignal* payload = new FID_G_LOGOSignal(logo);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "FID_G_LOGO", FID_G_LOGOSignal, payload)
        LOG_INFO ("-> send%sSignal", "FID_G_LOGO");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "FID_G_LOGO");
    }
}

void DataServicesStub::sendFID_G_SLIDESignal(const FID_G_SLIDESignalSlideStruct& slide) {
    if (_stubDelegate->isConnected()) {
        FID_G_SLIDESignal* payload = new FID_G_SLIDESignal(slide);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "FID_G_SLIDE", FID_G_SLIDESignal, payload)
        LOG_INFO ("-> send%sSignal", "FID_G_SLIDE");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "FID_G_SLIDE");
    }
}

void DataServicesStub::sendFID_G_USERAPP_STATUSSignal(uint32 u32ServiceId, uint32 e8UserApp) {
    if (_stubDelegate->isConnected()) {
        FID_G_USERAPP_STATUSSignal* payload = new FID_G_USERAPP_STATUSSignal(u32ServiceId, e8UserApp);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "FID_G_USERAPP_STATUS", FID_G_USERAPP_STATUSSignal, payload)
        LOG_INFO ("-> send%sSignal", "FID_G_USERAPP_STATUS");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "FID_G_USERAPP_STATUS");
    }
}

void  DataServicesStub::sendFID_DAB_S_GET_USERAPP_EPGResponse (uint32 e8MethodResult, uint32 e8EPGTypeInfo, const FID_DAB_S_GET_USERAPP_EPGResponseEPGServiceInfoStruct& ePGServiceInfo, const FID_DAB_S_GET_USERAPP_EPGResponseEPGScheduleInfoStruct& ePGScheduleInfo, const ::std::vector< FID_DAB_S_GET_USERAPP_EPGResponseGroupInfoStruct >& groupInfo, act_t act) {
    FID_DAB_S_GET_USERAPP_EPGResponse* payload = new FID_DAB_S_GET_USERAPP_EPGResponse(e8MethodResult, e8EPGTypeInfo, ePGServiceInfo, ePGScheduleInfo, groupInfo);
    DBUS_MESSAGE_REPLY(dbusMessage, "FID_DAB_S_GET_USERAPP_EPG", FID_DAB_S_GET_USERAPP_EPGResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "FID_DAB_S_GET_USERAPP_EPG", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DataServicesStub::sendFID_DAB_S_GET_USERAPP_EPGError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    FID_DAB_S_GET_USERAPP_EPGError* payload = new FID_DAB_S_GET_USERAPP_EPGError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "FID_DAB_S_GET_USERAPP_EPG", FID_DAB_S_GET_USERAPP_EPGError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "FID_DAB_S_GET_USERAPP_EPG", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DataServicesStub::sendFID_DAB_S_ENABLE_USERAPPResponse (uint32 e8MethodResult, uint32 e8EnabledUserApp, act_t act) {
    FID_DAB_S_ENABLE_USERAPPResponse* payload = new FID_DAB_S_ENABLE_USERAPPResponse(e8MethodResult, e8EnabledUserApp);
    DBUS_MESSAGE_REPLY(dbusMessage, "FID_DAB_S_ENABLE_USERAPP", FID_DAB_S_ENABLE_USERAPPResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "FID_DAB_S_ENABLE_USERAPP", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DataServicesStub::sendFID_DAB_S_ENABLE_USERAPPError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    FID_DAB_S_ENABLE_USERAPPError* payload = new FID_DAB_S_ENABLE_USERAPPError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "FID_DAB_S_ENABLE_USERAPP", FID_DAB_S_ENABLE_USERAPPError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "FID_DAB_S_ENABLE_USERAPP", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DataServicesStub::sendFID_DAB_GET_LOGOLISTResponse (act_t act) {
    FID_DAB_GET_LOGOLISTResponse* payload = new FID_DAB_GET_LOGOLISTResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "FID_DAB_GET_LOGOLIST", FID_DAB_GET_LOGOLISTResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "FID_DAB_GET_LOGOLIST", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DataServicesStub::sendFID_DAB_GET_LOGOLISTError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    FID_DAB_GET_LOGOLISTError* payload = new FID_DAB_GET_LOGOLISTError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "FID_DAB_GET_LOGOLIST", FID_DAB_GET_LOGOLISTError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "FID_DAB_GET_LOGOLIST", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DataServicesStub::sendFID_DAB_GET_LOGOResponse (act_t act) {
    FID_DAB_GET_LOGOResponse* payload = new FID_DAB_GET_LOGOResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "FID_DAB_GET_LOGO", FID_DAB_GET_LOGOResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "FID_DAB_GET_LOGO", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DataServicesStub::sendFID_DAB_GET_LOGOError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    FID_DAB_GET_LOGOError* payload = new FID_DAB_GET_LOGOError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "FID_DAB_GET_LOGO", FID_DAB_GET_LOGOError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "FID_DAB_GET_LOGO", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void DataServicesStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace DataServices
} // namespace cm
} // namespace bosch
} // namespace org
