/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_DATASERVICESPROXY_H
#define ORG_BOSCH_CM_DATASERVICESPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bosch/cm/DataServices.h"
#include <dbus/dbus.h>

namespace org {
namespace bosch {
namespace cm {
namespace DataServices {

class DataServicesProxy;

class FID_DAB_GET_LOGOCallbackIF {
public:
    virtual ~FID_DAB_GET_LOGOCallbackIF() {}

    virtual void onFID_DAB_GET_LOGOError(const ::boost::shared_ptr< DataServicesProxy >& proxy, const ::boost::shared_ptr< FID_DAB_GET_LOGOError >& error) = 0;

    virtual void onFID_DAB_GET_LOGOResponse(const ::boost::shared_ptr< DataServicesProxy >& proxy, const ::boost::shared_ptr< FID_DAB_GET_LOGOResponse >& response) = 0;
};

class FID_DAB_GET_LOGOLISTCallbackIF {
public:
    virtual ~FID_DAB_GET_LOGOLISTCallbackIF() {}

    virtual void onFID_DAB_GET_LOGOLISTError(const ::boost::shared_ptr< DataServicesProxy >& proxy, const ::boost::shared_ptr< FID_DAB_GET_LOGOLISTError >& error) = 0;

    virtual void onFID_DAB_GET_LOGOLISTResponse(const ::boost::shared_ptr< DataServicesProxy >& proxy, const ::boost::shared_ptr< FID_DAB_GET_LOGOLISTResponse >& response) = 0;
};

class FID_DAB_S_ENABLE_USERAPPCallbackIF {
public:
    virtual ~FID_DAB_S_ENABLE_USERAPPCallbackIF() {}

    virtual void onFID_DAB_S_ENABLE_USERAPPError(const ::boost::shared_ptr< DataServicesProxy >& proxy, const ::boost::shared_ptr< FID_DAB_S_ENABLE_USERAPPError >& error) = 0;

    virtual void onFID_DAB_S_ENABLE_USERAPPResponse(const ::boost::shared_ptr< DataServicesProxy >& proxy, const ::boost::shared_ptr< FID_DAB_S_ENABLE_USERAPPResponse >& response) = 0;
};

class FID_DAB_S_GET_USERAPP_EPGCallbackIF {
public:
    virtual ~FID_DAB_S_GET_USERAPP_EPGCallbackIF() {}

    virtual void onFID_DAB_S_GET_USERAPP_EPGError(const ::boost::shared_ptr< DataServicesProxy >& proxy, const ::boost::shared_ptr< FID_DAB_S_GET_USERAPP_EPGError >& error) = 0;

    virtual void onFID_DAB_S_GET_USERAPP_EPGResponse(const ::boost::shared_ptr< DataServicesProxy >& proxy, const ::boost::shared_ptr< FID_DAB_S_GET_USERAPP_EPGResponse >& response) = 0;
};

class FID_G_LOGOCallbackIF {
public:
    virtual ~FID_G_LOGOCallbackIF() {}

    virtual void onFID_G_LOGOError(const ::boost::shared_ptr< DataServicesProxy >& proxy, const ::boost::shared_ptr< FID_G_LOGOError >& error) = 0;

    virtual void onFID_G_LOGOSignal(const ::boost::shared_ptr< DataServicesProxy >& proxy, const ::boost::shared_ptr< FID_G_LOGOSignal >& signal) = 0;
};

class FID_G_LOGOLISTCallbackIF {
public:
    virtual ~FID_G_LOGOLISTCallbackIF() {}

    virtual void onFID_G_LOGOLISTError(const ::boost::shared_ptr< DataServicesProxy >& proxy, const ::boost::shared_ptr< FID_G_LOGOLISTError >& error) = 0;

    virtual void onFID_G_LOGOLISTSignal(const ::boost::shared_ptr< DataServicesProxy >& proxy, const ::boost::shared_ptr< FID_G_LOGOLISTSignal >& signal) = 0;
};

class FID_G_SLIDECallbackIF {
public:
    virtual ~FID_G_SLIDECallbackIF() {}

    virtual void onFID_G_SLIDEError(const ::boost::shared_ptr< DataServicesProxy >& proxy, const ::boost::shared_ptr< FID_G_SLIDEError >& error) = 0;

    virtual void onFID_G_SLIDESignal(const ::boost::shared_ptr< DataServicesProxy >& proxy, const ::boost::shared_ptr< FID_G_SLIDESignal >& signal) = 0;
};

class FID_G_USERAPP_STATUSCallbackIF {
public:
    virtual ~FID_G_USERAPP_STATUSCallbackIF() {}

    virtual void onFID_G_USERAPP_STATUSError(const ::boost::shared_ptr< DataServicesProxy >& proxy, const ::boost::shared_ptr< FID_G_USERAPP_STATUSError >& error) = 0;

    virtual void onFID_G_USERAPP_STATUSSignal(const ::boost::shared_ptr< DataServicesProxy >& proxy, const ::boost::shared_ptr< FID_G_USERAPP_STATUSSignal >& signal) = 0;
};


/**
 * DataServicesProxy is the client side representation of the D-Bus
 * service interface 'org.bosch.cm.DataServices' (specified in file
 * G3g_DataServices.xml).
 *
 * If the meaning of "org.bosch.cm.DataServices" isn't clear, then there should be a description here.
 */
class DataServicesProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of DataServicesProxy.
     */
    static ::boost::shared_ptr< DataServicesProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of DataServicesProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< DataServicesProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of DataServicesProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< DataServicesProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< DataServicesProxy > proxyNew(new DataServicesProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~DataServicesProxy ();


    // Signal 'FID_G_LOGOLIST'

    /**
     * Notify on the signal 'FID_G_LOGOLIST'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'FID_G_LOGOLIST'</b>:
     *
     * FID_G_LOGOLIST = Provides the logo list data
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFID_G_LOGOLISTRegister(FID_G_LOGOLISTCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'FID_G_LOGOLIST'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'FID_G_LOGOLIST'</b>:
     *
     * FID_G_LOGOLIST = Provides the logo list data
     *
     * @param act The act which was previously returned by the
     * sendFID_G_LOGOLISTRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendFID_G_LOGOLISTDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'FID_G_LOGOLIST'.
     */
    void sendFID_G_LOGOLISTDeregisterAll () const;

    // Signal 'FID_G_LOGO'

    /**
     * Notify on the signal 'FID_G_LOGO'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'FID_G_LOGO'</b>:
     *
     * FID_G_LOGO = Provides the logo data
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFID_G_LOGORegister(FID_G_LOGOCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'FID_G_LOGO'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'FID_G_LOGO'</b>:
     *
     * FID_G_LOGO = Provides the logo data
     *
     * @param act The act which was previously returned by the
     * sendFID_G_LOGORegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendFID_G_LOGODeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'FID_G_LOGO'.
     */
    void sendFID_G_LOGODeregisterAll () const;

    // Signal 'FID_G_SLIDE'

    /**
     * Notify on the signal 'FID_G_SLIDE'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'FID_G_SLIDE'</b>:
     *
     * FID_G_SLIDE = Provides the logo data
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFID_G_SLIDERegister(FID_G_SLIDECallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'FID_G_SLIDE'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'FID_G_SLIDE'</b>:
     *
     * FID_G_SLIDE = Provides the logo data
     *
     * @param act The act which was previously returned by the
     * sendFID_G_SLIDERegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendFID_G_SLIDEDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'FID_G_SLIDE'.
     */
    void sendFID_G_SLIDEDeregisterAll () const;

    // Signal 'FID_G_USERAPP_STATUS'

    /**
     * Notify on the signal 'FID_G_USERAPP_STATUS'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'FID_G_USERAPP_STATUS'</b>:
     *
     * FID_G_USERAPP_STATUS = Provides the logo data
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFID_G_USERAPP_STATUSRegister(FID_G_USERAPP_STATUSCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'FID_G_USERAPP_STATUS'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'FID_G_USERAPP_STATUS'</b>:
     *
     * FID_G_USERAPP_STATUS = Provides the logo data
     *
     * @param act The act which was previously returned by the
     * sendFID_G_USERAPP_STATUSRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendFID_G_USERAPP_STATUSDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'FID_G_USERAPP_STATUS'.
     */
    void sendFID_G_USERAPP_STATUSDeregisterAll () const;



    // Method 'FID_DAB_S_GET_USERAPP_EPG'

    /**
     * Call the method 'FID_DAB_S_GET_USERAPP_EPG'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'FID_DAB_S_GET_USERAPP_EPG'</b>:
     *
     * FID_DAB_S_GET_USERAPP_EPG = EPG data could be requested with this method
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param e8EPGInfoType e8EPGInfoType (of type T_e8_DAB_EPGInfoType) = Type of EPG info required
     * enum[DAB_EPG_SERVICEINFO (0), DAB_EPG_SCHEDULEINFO (1), DAB_EPG_GROUPINFO (2)]
     *
     * @param u32ServiceId u32ServiceId = PSID
     *
     * @param rScheduleInfoConfig rScheduleInfoConfig (of type T_DAB_ScheduleInfoConfig) = Shcedule Info can be configured
     * T_DAB_ScheduleInfoConfig struct[rScope, u32NumberOfEntries] = Schedule Info Configuration
     * 0: T_DAB_ScheduleInfoConfig.rScope ('?') = Schedule Info within this scope would be sent
     * 1: T_DAB_ScheduleInfoConfig.u32NumberOfEntries ('u') = schedule Info would be sent with these number of entries
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFID_DAB_S_GET_USERAPP_EPGRequest(FID_DAB_S_GET_USERAPP_EPGCallbackIF& cb, uint32 e8EPGInfoType, uint32 u32ServiceId, const FID_DAB_S_GET_USERAPP_EPGRequestRScheduleInfoConfigStruct& rScheduleInfoConfig) const;

    // Method 'FID_DAB_S_ENABLE_USERAPP'

    /**
     * Call the method 'FID_DAB_S_ENABLE_USERAPP'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'FID_DAB_S_ENABLE_USERAPP'</b>:
     *
     * FID_DAB_S_ENABLE_USERAPP = HMI could enable the needed user app with this method
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param e8UserApp e8UserApp (of type T_e8_DAB_UserApplicationType) = Bitfield to indicate type of userapp to be enabled
     * enum[DAB_USERAPPTYPE_SLIDESHOW (1), DAB_USERAPPTYPE_BWS (2), DAB_USERAPPTYPE_EPG (4)]
     *
     * @param bEnable bEnable = True/False to enable /disable
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFID_DAB_S_ENABLE_USERAPPRequest(FID_DAB_S_ENABLE_USERAPPCallbackIF& cb, uint32 e8UserApp, bool bEnable) const;

    // Method 'FID_DAB_GET_LOGOLIST'

    /**
     * Call the method 'FID_DAB_GET_LOGOLIST'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'FID_DAB_GET_LOGOLIST'</b>:
     *
     * FID_DAB_GET_LOGOLIST = HMI could request the needed logo list with this method
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param e8LogoListType e8LogoListType (of type T_e8_LogoListType) = requested Logo list type
     * enum[DAB_LOGOLIST_ENSEMBLE (0), DAB_LOGOLIST_SERVICE (1)]
     *
     * @param u8LogoType u8LogoType (of type T_e8_LogoType) = Indicates what type of Logo is needed.
     * enum[LOGOTYPE_NOLOGO (0), LOGOTYPE_UNRESTRICTED (1), LOGOTYPE_COLOUR_RECTANGLE (2), LOGOTYPE_COLOUR_SQUARE (3)]
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFID_DAB_GET_LOGOLISTRequest(FID_DAB_GET_LOGOLISTCallbackIF& cb, uint32 e8LogoListType, uint32 u8LogoType) const;

    // Method 'FID_DAB_GET_LOGO'

    /**
     * Call the method 'FID_DAB_GET_LOGO'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'FID_DAB_GET_LOGO'</b>:
     *
     * FID_DAB_GET_LOGO = HMI could request the needed logo list with this method
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param e8LogoListType e8LogoListType (of type T_e8_LogoListType) = requested Logo list type
     * enum[DAB_LOGOLIST_ENSEMBLE (0), DAB_LOGOLIST_SERVICE (1)]
     *
     * @param u8LogoType u8LogoType (of type T_e8_LogoType) = Indicates what type of Logo is needed.
     * enum[LOGOTYPE_NOLOGO (0), LOGOTYPE_UNRESTRICTED (1), LOGOTYPE_COLOUR_RECTANGLE (2), LOGOTYPE_COLOUR_SQUARE (3)]
     *
     * @param u32ServiceId u32ServiceId = PSID
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFID_DAB_GET_LOGORequest(FID_DAB_GET_LOGOCallbackIF& cb, uint32 e8LogoListType, uint32 u8LogoType, uint32 u32ServiceId) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    DataServicesProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class DataServicesProxyCallback;
};

} // namespace DataServices
} // namespace cm
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_CM_DATASERVICESPROXY_H
